<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('eventos_model');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Eventos';
            $this->_cargarvista(null, $data);
        }
    }

        /**
         * @author René Castaneda
         * @return Gestión de eventos
         * @since 11-07-2018
         */
        function evento() {
            satelite_validar();
            $permisos = $this->gsatelite->get_permisos_opcion();
            
            $data['titulo_personal'] = "Gestión de eventos";
            $data['permisos'] = $permisos;

            cargarvista($data);
        }

        /**
        * @author René Castaneda
        * @since 2018-07-15
        * @return filtrar los activos y su depreciación.
         */

        public function filtrar_evento()
        {   
            satelite_validar();
            $registros = array();
            $permisos = $this->gsatelite->get_permisos_opcion('evento');
            $data['permisos']=$permisos;
            $txtFecha_desde = $this->input->post('txtFecha_desde');
            $txtFecha_hasta = $this->input->post('txtFecha_hasta');

            $where['evn_estado'] = 1;
            if ($this->input->post()) {                        
                if ($txtFecha_desde !='') {
                  $where['DATE(evn_fecha) >=']=formatear_fecha('Y-m-d', $txtFecha_desde);
                }
                if ($txtFecha_hasta !='') {
                    $where['DATE(evn_fecha) <=']=formatear_fecha('Y-m-d', $txtFecha_hasta);
                }
            }
           // print_r($_POST); die();
            $registros=$this->eventos_model->informacion_eventos($where);
            $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
            $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
            
            $data['registros'] = $registros;
            $html = $this->load->view('modulo_eventos/procesos/filtrar_evento', $data, true);
            echo json_encode(array('html'=>$html));
        }


        /**
         * @author René Castaneda
         * @since 15-07-2018
         * @return Agregar eventos
         */
        function agregar_evento() {
            satelite_validar();
            $ruta_modulo = 'modulo_eventos/procesos';
            $data['ruta'] = $ruta_modulo; 
            if ($_POST){
                $post_array = $_POST;
                $id_usuario_sesion = $this->tank_auth->get_user_id();
                $fecha_actual = date('Y-m-d H:i:s');
                /*
                $num_actual = $this->gsatelite->count('evn_evento') + 1;
                $codigo_evento = 'A' . generar_codigo_cor($num_actual, 4);
                $post_array['txtCodigo'] = $codigo_evento;
                */
                
                //guardar la foto
                $carpeta_destino = null;
                $ruta_imagen = null;
                if ($this->input->post('foto_evento') != "" and $this->input->post('titulo_foto_evento') != "") { 
                    $titulo = $this->input->post('titulo_foto_evento') . time();
                    $img = $this->input->post('foto_evento');
                    $extencion = end(explode(".", $img));
                    $nombre = trim($img);
                    $ruta = "public/temp/foto_evento/" . $nombre;
                    $ruta_imagen =  $titulo . "." . trim($extencion);
                    $carpeta_destino = "uploads/anexo_foto_evento/" . $titulo . "." . trim($extencion) . "";               
                    @copy($ruta, $carpeta_destino);
                    @unlink($ruta);
                }
                $evn_evento = array(
                    'evn_id_usu' => $id_usuario_sesion,
                    'evn_codigo' => ($post_array['txtCodigo'] != '') ? $post_array['txtCodigo'] : null,
                    'evn_asunto' => ($post_array['txtAsunto'] != '') ? $post_array['txtAsunto'] : null,
                    'evn_detalle' => ($post_array['txtDetalle'] != '') ? $post_array['txtDetalle'] : null,      
                    'evn_lugar' => ($post_array['txtLugar'] != '') ? $post_array['txtLugar'] : null,
                    'evn_url_imagen' => $ruta_imagen,
                    'evn_fecha_evento' => (trim($post_array['txtFechaEvento']) != '') ? formatear_fecha("Y-m-d", $post_array['txtFechaEvento']) : null,
                    'evn_fecha_evento_fin' => (trim($post_array['txtFechaEventoFin']) != '') ? formatear_fecha("Y-m-d", $post_array['txtFechaEventoFin']) : null,
                    'evn_hora_evento' => ($post_array['txtHora'] != '') ? $post_array['txtHora'] : null,
                    'evn_hora_evento_fin' => ($post_array['txtHoraFin'] != '') ? $post_array['txtHoraFin'] : null,
                    'evn_fecha' => $fecha_actual,
                    'evn_publico' => $post_array['evn_publico'],
                    'evn_estado' => 1,
                    'evn_usu_creacion' => $id_usuario_sesion,
                    'evn_fecha_creacion' => $fecha_actual,
                    'evn_usu_modificacion' => $id_usuario_sesion,
                    'evn_fecha_modificacion' => $fecha_actual
                );
                $evn_id = $this->gsatelite->ingresar('evn_evento',$evn_evento);

                
                ////// ROL POR EVENTO
                if (isset($post_array['slcRoles']) and count($post_array['slcRoles']) > 0) {
                    $roles = $post_array['slcRoles'];
                    for ($k=0; $k < count($roles) ; $k++) { 
                        if ($roles[$k] > 0) {
                            $datos_rol = array(
                                'vxl_id_evn'                => $evn_id,
                                'vxl_id_rol'                => $roles[$k],
                                'vxl_estado'                => 1,
                                'vxl_usu_creacion'          => $id_usuario_sesion,
                                'vxl_fecha_creacion'        => $fecha_actual,
                                'vxl_usu_modificacion'      => $id_usuario_sesion,
                                'vxl_fecha_modificacion'    => $fecha_actual
                            );
                            $this->gsatelite->ingresar('vxl_eventoxrol', $datos_rol);
                        }
                    }               
                }

                ///////////////////////////////////
                ////// USUARIOS POR EVENTO
                if (isset($post_array['slcRoles']) and count($post_array['slcRoles']) > 0 and is_array($post_array['slcRoles'])) {
                    $slcRoles = (trim(implode(',',$post_array['slcRoles'])) !="")? implode(',',$post_array['slcRoles']):"0";
                    $where["uxr_id_rol in (". $slcRoles.")"] = null;
                    $registros_usu =  $this->eventos_model->get_info_usuario_rol($where);
                    $array_correos = array();
                    $exito_correo = 0;
                    foreach ($registros_usu as $fila_usu) {
                        if (trim($fila_usu["email"]) !="") {
                            $array_correos[] = $fila_usu["email"];
                        }
                        $datos_usu = array(
                            'usv_id_evn'                => $evn_id,
                            'usv_id_usu'                => $fila_usu['id'],
                            'usv_confirmado'            => 0,
                            'usv_correo_enviado'        => $exito_correo,
                            'usv_fecha_confirmacion'    => null,
                            'usv_estado'                => 1,
                            'usv_usu_creacion'          => $id_usuario_sesion,
                            'usv_fecha_creacion'        => $fecha_actual,
                            'usv_usu_modificacion'      => $id_usuario_sesion,
                            'usv_fecha_modificacion'    => $fecha_actual
                        );
                        $this->gsatelite->ingresar('usv_usuario_evento', $datos_usu);
                    }    
                    $exito_correo = $this->envio_correo_evento($evn_id,$array_correos);
                    $this->gsatelite->actualizar_array("usv_usuario_evento",array("usv_correo_enviado"=>$exito_correo),array("usv_id_evn"=>$evn_id));

                }
                //////////////////////////////

                if (isset($post_array['titulo_doc'])) {
                    for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                        $carpeta_temporal_anx = "public/temp/anexos_evento/" . trim($post_array['ruta'][$i]);
                        $ruta_anexo =  time()."_".trim($post_array['ruta'][$i]);
                        $carpeta_destino_anx = "uploads/anexos_evento/" . $ruta_anexo;

                        $datos_anexo = array(
                            'ann_id_evn'    => $evn_id,
                            'ann_nombre'    => $post_array['titulo_doc'][$i],
                            'ann_url'       => $ruta_anexo,
                            'ann_estado'                => 1,
                            'ann_usu_creacion'          => $id_usuario_sesion,
                            'ann_fecha_creacion'        => $fecha_actual,
                            'ann_usu_modificacion'      => $id_usuario_sesion,
                            'ann_fecha_modificacion'    => $fecha_actual
                        );
                        $this->gsatelite->ingresar('ann_anexo_evento', $datos_anexo);

                        @copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        @unlink($carpeta_temporal_anx);
                    }
                }

                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Evento",'texto_alerta'=>"Registro procesado correctamente");
                $this->session->set_flashdata($alerta);

                if ( $post_array['btnGuardar'] == 0 ) {
                    redirect("$ruta_modulo/agregar_evento");
                } else {
                    redirect("$ruta_modulo/evento");
                }

            } else {
                $id_usuario = $this->tank_auth->get_user_id();
                $datos_usuario = $this->eventos_model->get_info_usuario(array("id"=>$id_usuario));
                $data["datos_usuario"] = $datos_usuario[0];
                $slcRoles = $this->gsatelite->get_dropdown('rol_rol', '{rol_nombre}', '', array('rol_estado' => 1), null, '', 'rol_id', true);
                $data["slcRoles"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin registros</option>'), '', $slcRoles);
                
                $num_actual = $this->gsatelite->count('evn_evento') + 1;
                $codigo_evento = 'A' . generar_codigo_cor($num_actual, 4);

                $data["codigo_evento"] = $codigo_evento;
                $data['titulo_personal']    = "Creación de evento";
                cargarvista($data);
            }
        }

    /**
     * @author René Castaneda
     * @since 22-07-2018
     * @return Editar eventos
     */
    function editar_evento($id_evento=0) {
        satelite_validar();
        $ruta_modulo = 'modulo_eventos/procesos';
        $data['ruta'] = $ruta_modulo;
        $data['es_visualizacion'] = 0;
        if ($_POST){
            $post_array = $_POST;
            $id_usuario_sesion = $this->tank_auth->get_user_id();
            $fecha_actual = date('Y-m-d H:i:s');
            $id_evento = $this->input->post('txtID_evento');
            /*
            $num_actual = $this->gsatelite->count('evn_evento') + 1;
            $codigo_evento = 'A' . generar_codigo_cor($num_actual, 4);
            $post_array['txtCodigo'] = $codigo_evento;
            */

            //guardar la foto
            $carpeta_destino = null;
            $img_original = trim($this->input->post('titulo_foto_evento_original'));
            $ruta_imagen = ($img_original == "")? null:$img_original;
            if ($this->input->post('foto_evento') != "" && $this->input->post('titulo_foto_evento') != "" && $img_original != trim($this->input->post('foto_evento')) ) 
            { 
                $titulo = $this->input->post('titulo_foto_evento') . time();
                $img = $this->input->post('foto_evento');
                $extencion = end(explode(".", $img));
                $nombre = trim($img);
                $ruta = "public/temp/foto_evento/" . $nombre;
                $ruta_imagen = $titulo . "." . trim($extencion);
                $carpeta_destino = "uploads/anexo_foto_evento/" . $titulo . "." . trim($extencion) . "";               
                @copy($ruta, $carpeta_destino);
                @unlink($ruta);
            } elseif ($img_original != "" && (trim($this->input->post('foto_evento')) == "" or $img_original != trim($this->input->post('foto_evento')))) 
            {
                $ruta = "uploads/anexo_foto_evento/" . $img_original;
                @unlink($ruta); //eliminar el archivo
            }
            $ruta_imagen = (trim($this->input->post('foto_evento')) == "" )? null:$ruta_imagen;

            $evn_evento = array(
                'evn_codigo' => ($post_array['txtCodigo'] != '') ? $post_array['txtCodigo'] : null,
                'evn_asunto' => ($post_array['txtAsunto'] != '') ? $post_array['txtAsunto'] : null,
                'evn_detalle' => ($post_array['txtDetalle'] != '') ? $post_array['txtDetalle'] : null,      
                'evn_lugar' => ($post_array['txtLugar'] != '') ? $post_array['txtLugar'] : null,
                'evn_url_imagen' =>  $ruta_imagen,
                'evn_fecha_evento' => (trim($post_array['txtFechaEvento']) != '') ? formatear_fecha("Y-m-d", $post_array['txtFechaEvento']) : null,
                'evn_fecha_evento_fin' => (trim($post_array['txtFechaEventoFin']) != '') ? formatear_fecha("Y-m-d", $post_array['txtFechaEventoFin']) : null,
                'evn_hora_evento' => ($post_array['txtHora'] != '') ? $post_array['txtHora'] : null,
                'evn_hora_evento_fin' => ($post_array['txtHoraFin'] != '') ? $post_array['txtHoraFin'] : null,
                'evn_fecha' => $fecha_actual,
                'evn_publico' => $post_array['evn_publico'],
                'evn_estado' => 1,
                'evn_usu_modificacion' => $id_usuario_sesion,
                'evn_fecha_modificacion' => $fecha_actual
            );
            $this->gsatelite->actualizar_array('evn_evento',$evn_evento, array("evn_id"=>$id_evento));
            $evn_id = $id_evento;
            
            ////// ROL POR EVENTO
            //eliminar datos para luego insertarlos
            $this->gsatelite->borrado_general("vxl_eventoxrol",array("vxl_id_evn"=>$evn_id));

            if (isset($post_array['slcRoles']) and count($post_array['slcRoles']) > 0) {
                $roles = $post_array['slcRoles'];
                for ($k=0; $k < count($roles) ; $k++) { 
                    if ($roles[$k] > 0) {
                        $datos_rol = array(
                            'vxl_id_evn'                => $evn_id,
                            'vxl_id_rol'                => $roles[$k],
                            'vxl_estado'                => 1,
                            'vxl_usu_creacion'          => $id_usuario_sesion,
                            'vxl_fecha_creacion'        => $fecha_actual,
                            'vxl_usu_modificacion'      => $id_usuario_sesion,
                            'vxl_fecha_modificacion'    => $fecha_actual
                        );
                        $this->gsatelite->ingresar('vxl_eventoxrol', $datos_rol);
                    }
                }               
            }

            ///////////////////////////////////
            ////// USUARIOS POR EVENTO
            if (isset($post_array['slcRoles']) and count($post_array['slcRoles']) > 0 and is_array($post_array['slcRoles'])) {
                $slcRoles = (trim(implode(',',$post_array['slcRoles'])) !="")? implode(',',$post_array['slcRoles']):"0";
                $registros_usu_actual =  $this->gsatelite->get_tabla("usv_usuario_evento",array("usv_id_evn"=>$evn_id));
                $array_usuarios_actuales = array();
                if (count($registros_usu_actual)) {
                    $array_usuarios_actuales = array_column($registros_usu_actual, "usv_id_usu");
                    $where["id not in (". implode(",", $array_usuarios_actuales).")"] = null;
                }
                $where["uxr_id_rol in (". $slcRoles.")"] = null;

                $registros_usu =  $this->eventos_model->get_info_usuario_rol($where);
                $array_correos = array();
                $array_usuarios_new = array();
                $exito_correo = 0;
                foreach ($registros_usu as $fila_usu) {
                    if (trim($fila_usu["email"]) !="") {
                        $array_correos[] = $fila_usu["email"];
                    }
                    $datos_usu = array(
                        'usv_id_evn'                => $evn_id,
                        'usv_id_usu'                => $fila_usu['id'],
                        'usv_confirmado'            => 0,
                        'usv_correo_enviado'        => $exito_correo,
                        'usv_fecha_confirmacion'    => null,
                        'usv_estado'                => 1,
                        'usv_usu_creacion'          => $id_usuario_sesion,
                        'usv_fecha_creacion'        => $fecha_actual,
                        'usv_usu_modificacion'      => $id_usuario_sesion,
                        'usv_fecha_modificacion'    => $fecha_actual
                    );
                    $this->gsatelite->ingresar('usv_usuario_evento', $datos_usu);
                } 

                //eliminar los que ya no apliquen
                $where2["uxr_id_rol in (". $slcRoles.")"] = null;
                $registros_new =  $this->eventos_model->get_info_usuario_rol($where2);
                $array_mantener = (count($registros_new) > 0)? array_column($registros_new, "id"):array(0);
                for ($q=0; $q < count($array_usuarios_actuales); $q++) 
                {
                    if (!in_array($array_usuarios_actuales[$q], $array_mantener)) 
                    {
                        //eliminar el que no se encuentre
                        $this->gsatelite->borrado_general("usv_usuario_evento",array("usv_id_evn"=>$evn_id, "usv_id_usu"=>$array_usuarios_actuales[$q]));
                    }
                }
                
                $exito_correo = $this->envio_correo_evento($evn_id,null,1);
                $this->gsatelite->actualizar_array("usv_usuario_evento",array("usv_correo_enviado"=>$exito_correo),array("usv_id_evn"=>$evn_id));

            } 
            else //si no hay roles elminar todo registro
            {
                $this->gsatelite->borrado_general("usv_usuario_evento",array("usv_id_evn"=>$evn_id));
            }
            //////////////////////////////

            if (isset($post_array['titulo_doc'])) {
                for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                    $carpeta_temporal_anx = "public/temp/anexos_evento/" . trim($post_array['ruta'][$i]);
                    $ruta_anexo =  time()."_".trim($post_array['ruta'][$i]);
                    $carpeta_destino_anx = "uploads/anexos_evento/" . $ruta_anexo;

                    $datos_anexo = array(
                        'ann_id_evn'    => $evn_id,
                        'ann_nombre'    => $post_array['titulo_doc'][$i],
                        'ann_url'       => $ruta_anexo,
                        'ann_estado'                => 1,
                        'ann_usu_creacion'          => $id_usuario_sesion,
                        'ann_fecha_creacion'        => $fecha_actual,
                        'ann_usu_modificacion'      => $id_usuario_sesion,
                        'ann_fecha_modificacion'    => $fecha_actual
                    );
                    $this->gsatelite->ingresar('ann_anexo_evento', $datos_anexo);

                    @copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    @unlink($carpeta_temporal_anx);
                }
            }

            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Evento",'texto_alerta'=>"Registro actualizado correctamente");
            $this->session->set_flashdata($alerta);

            if ( $post_array['btnGuardar'] == 0 ) {
                redirect("$ruta_modulo/editar_evento/$evn_id");
            } else {
                redirect("$ruta_modulo/evento");
            }

        } else {

            $registro_evento = $this->eventos_model->informacion_eventos(array("evn_id"=>$id_evento));

            $data["registro_evento"] = $registro_evento[0];
            //$data["registro_usuarios_evento"] = $this->eventos_model->get_usuarios_evento(array("vxl_id_evn"=>$id_evento));
            $roles_evento = $this->gsatelite->get_tabla("vxl_eventoxrol",array("vxl_id_evn"=>$id_evento));
            $data["registro_anexos_evento"] = $this->gsatelite->get_tabla("ann_anexo_evento",array("ann_id_evn"=>$id_evento));
            $roles_selected = array_column($roles_evento,"vxl_id_rol");

            $datos_usuario = $this->eventos_model->get_info_usuario(array("id"=>$registro_evento[0]["evn_id_usu"]));
            $data["datos_usuario"] = $datos_usuario[0];
            $slcRoles = $this->gsatelite->get_dropdown('rol_rol', '{rol_nombre}', '', array('rol_estado' => 1), $roles_selected, '', 'rol_id', true);
            $data["slcRoles"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin registros</option>'), '', $slcRoles);
            
            //$num_actual = $this->gsatelite->count('evn_evento') + 1;
            //$codigo_evento = 'A' . generar_codigo_cor($num_actual, 4);

           // $data["codigo_evento"] = $codigo_evento;
            $data['titulo_personal']    = "Edición de evento";
            cargarvista($data);
        }
    }


    /**
     * @author René Castaneda
     * @return Cartelera de eventos
     * @since 11-07-2018
     */
    function cartelera_eventos() {
        satelite_validar();
        $es_jefe = false;
        $selected = null;
        $slcConsultor = '';
        $id_usuario = $this->tank_auth->get_user_id();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $datos_usuario = $this->eventos_model->get_info_usuario(array("id"=>$id_usuario));
        $this->load->model('desarrollo_model');
        $roles = $this->desarrollo_model->get_roles_usuario($id_usuario);
        $roles_jefe = explode(',', $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD', "0"));
        foreach ($roles as $key => $val) {
            if (in_array($val, $roles_jefe)) {
                $es_jefe = true;
            }
        }
        $where["evn_estado"] = 1;
        $where_select['activated'] = 1;
        if ($_POST) {
            if ($es_jefe) {
                if ($_POST['slcConsultor']) {
                    $selected = $_POST['slcConsultor'];
                    $filtrar = implode(',', $_POST['slcConsultor']);
                    $where["(usv_id_usu IN($filtrar) OR evn_id_usu IN($filtrar))"] = null;                    
                } else {
                    $selected = null;
                }
            } else {
                $selected = $id_usuario;
                $where_select['id'] = $id_usuario;
                $where["(usv_id_usu = $id_usuario OR evn_id_usu = $id_usuario)"] = null;
            }
        } else {
            if (!$es_jefe) {
                $selected = $id_usuario;
                $where_select['id'] = $id_usuario;
                $where["(usv_id_usu = $id_usuario OR evn_id_usu = $id_usuario)"] = null;
            }
        }
        $where["evn_fecha_evento IS NOT NULL"] = null;
        // $registros = $this->eventos_model->get_usuarios_evento($where);
        $registros = $this->eventos_model->get_usuarios_eventos2($where);
        // var_dump($this->db->last_query());die();

                                $this->db->join('emp_empleado', 'emp_id = usu_id_emp AND emp_estado > 0', 'left');
        $data['slcConsultor'] = $this->gsatelite->get_dropdown('users', '[IF(ISNULL(emp_id), username, CONCAT_WS(" ",emp_nombre,emp_apellido))]','', $where_select, $selected, '', 'id', true);
        $data['es_jefe'] = ($es_jefe) ? 1 : 0;
        $data['registros'] = $registros;
        $data["datos_usuario"] = $datos_usuario[0];
        $data['titulo_personal'] = "Cartelera de eventos";
        $data['permisos'] = $permisos;
        cargarvista($data);
    }
    public function filtrar_usuarios_evento()
    {
       $slcRoles =  $this->input->post("slcRoles");
       $txtID =  $this->input->post("txtID");
       $tabla_html = "";
       if (count($slcRoles) > 0) 
       {
            $where["uxr_id_rol in (".implode(',', $slcRoles).")"] = null;
            if ($txtID > 0) {
                $this->db->join("usv_usuario_evento","usv_id_usu=id AND usv_id_evn = $txtID", "left");
            }
            $registros =  $this->eventos_model->get_info_usuario_rol($where);
            $data["registros"] = $registros;
            $tabla_html = $this->load->view("modulo_eventos/procesos/filtrar_usuarios_evento", $data, true);
       }
       die(json_encode(array("tabla_html"=>$tabla_html)));
    }

    public function guardar_gral($parametros, $carpeta=null)
    {

        $datos= @explode($parametros);
        $carpeta=$parametros;

        $image = $this->upload_gral($carpeta);

            //echo base_url().'/public/temp/'.$image['upload_data']['raw_name'].$image['upload_data']['file_ext'];
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
            //echo $image['upload_data']['client_name'];
    }
    function upload_gral($carpeta)
    {
        if ($carpeta=="assets") {
            $ruta=FCPATH . "assets/uploads/images";
        }else{
            $ruta=FCPATH . "public/temp/" . $carpeta;
        }

        if(!file_exists($ruta)){
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }
    function eliminar_imagen_gral($carpeta="")
    {

        $url = $this->input->post("url");
        echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";
        @unlink("./public/temp/$carp/" . $url);
    }

    public function verifica_codigo()
    {
        $txtCodigo = $this->input->post("txtCodigo");
        $txtID = $this->input->post("txtID");
        $query = $this->gsatelite->get_tabla("evn_evento", array("evn_codigo"=>$txtCodigo, "evn_id !="=>$txtID));
        $existe = (count($query) > 0)? 1:0;
        die(json_encode(array("existe"=>$existe)));
    }

    public function envio_correo_evento($id_evento=0, $array_correos = null, $es_update = 0, $texto_extra = "")
    {
        $exito = 0;
        //si no existe los correos preguntar los los mismos
        if ($array_correos == null && $id_evento > 0) 
        {
            $usuarios_evento = $this->eventos_model->get_usuarios_evento(array("usv_id_evn"=>$id_evento));
            $array_correos = array();
            foreach ($usuarios_evento as $f) {
                if (trim($f["email"]) != "") 
                    $array_correos[] = trim($f["email"]);
            }
        }

        if (count($array_correos) > 0 && $id_evento > 0) 
        {
            $registro_evento = $this->eventos_model->informacion_eventos(array("evn_id"=>$id_evento));
            if (trim($registro_evento[0]["email"]) != "" ) 
            {
                $email_envia = $registro_evento[0]["email"];
                $nombre_envia = $registro_evento[0]["emp_nombre"] . " " . $registro_evento[0]["emp_apellido"];
                $correos_involucrados = array_unique($array_correos);
                $asunto = "DETALLE DE EVENTO ". formatear_fecha("d-m-Y", $registro_evento[0]["evn_fecha_evento"]) . $texto_extra ;
                $data["registro_evento"] = $registro_evento[0];
                $data["titulo_evento"] = ($es_update)? "DETALLE DE ACTUALIZACIÓN DE EVENTO ". $texto_extra :"DETALLE DE NUEVO EVENTO ". $texto_extra ;
                $mensaje = $this->load->view("modulo_eventos/procesos/detalle_correo_evento",$data,true);
                $exito = $this->gsatelite->envio_correo($email_envia,$nombre_envia,$correos_involucrados,$asunto,$mensaje,$email_envia); 
            }
        }
        return $exito;
    }

    public function eliminar_registro_anexo()
    {
        $id_anexo = $this->input->post("id_anexo");
        $exito = 0 ;
        if ($id_anexo > 0) 
        {
           $exito =  $this->gsatelite->borrado_general("ann_anexo_evento",array("ann_id"=>$id_anexo));
        }
        die(json_encode(array("exito"=>$exito)));
    }

    public function editar_nombre_anexo()
    {
        $id_anexo = $this->input->post("id_anexo");
        $nombre_anexo = $this->input->post("nombre_anexo");
        $exito = 0 ;
        if ($id_anexo > 0 && $nombre_anexo != "") 
        {
            $datos_anexo = array(
                'ann_nombre'    => $nombre_anexo,
                'ann_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'ann_fecha_modificacion'    => date("Y-m-d H:i:s")
            );
           $exito =  $this->gsatelite->actualizar_array("ann_anexo_evento",$datos_anexo,array("ann_id"=>$id_anexo));
        }
        die(json_encode(array("exito"=>$exito)));
    }

    public function eliminar_evento($id_evento)
    {
        $exito = 0 ;
        if ($id_evento > 0) 
        {
             $datos_update = array(
                 'evn_estado'    => 0,
                 'evn_usu_modificacion'      => $this->tank_auth->get_user_id(),
                 'evn_fecha_modificacion'    => date("Y-m-d H:i:s")
             );
            $exito =  $this->gsatelite->actualizar_array("evn_evento",$datos_update,array("evn_id"=>$id_evento));

        }
        if ($exito) 
            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Evento",'texto_alerta'=>"Registro desactivado correctamente");
        else
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Evento",'texto_alerta'=>"Error en eliminar registro, intentar nuevamente");
        
        $this->session->set_flashdata($alerta);
        redirect("modulo_eventos/procesos/evento");
    }

    public function visualizar_evento($id_evento = 0){
        satelite_validar();
        $ruta_modulo = 'modulo_eventos/procesos';
        $data['ruta'] = $ruta_modulo;
        $registro_evento = $this->eventos_model->informacion_eventos(array("evn_id"=>$id_evento));

        $data["registro_evento"] = $registro_evento[0];
        //$data["registro_usuarios_evento"] = $this->eventos_model->get_usuarios_evento(array("vxl_id_evn"=>$id_evento));
        $roles_evento = $this->gsatelite->get_tabla("vxl_eventoxrol",array("vxl_id_evn"=>$id_evento));
        $data["registro_anexos_evento"] = $this->gsatelite->get_tabla("ann_anexo_evento",array("ann_id_evn"=>$id_evento));
        $roles_selected = array_column($roles_evento,"vxl_id_rol");

        $datos_usuario = $this->eventos_model->get_info_usuario(array("id"=>$registro_evento[0]["evn_id_usu"]));
        $data["datos_usuario"] = $datos_usuario[0];
        $slcRoles = $this->gsatelite->get_dropdown('rol_rol', '{rol_nombre}', '', array('rol_estado' => 1), $roles_selected, '', 'rol_id', true);
        $data["slcRoles"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin registros</option>'), '', $slcRoles);
        $id_detalle_invitacion = 0 ;
        $confirmacion_invitacion = 0 ;
        $query_invitacion = $this->gsatelite->get_tabla("usv_usuario_evento",array("usv_id_evn"=>$id_evento, "usv_id_usu"=>$this->tank_auth->get_user_id()));
        if (count($query_invitacion) > 0) {
            $id_detalle_invitacion = $query_invitacion[0]["usv_id"];
            $confirmacion_invitacion = $query_invitacion[0]["usv_confirmado"];
        }
        $data['titulo_personal']    = "Visualizar evento";
        $data['es_visualizacion'] = 1; 
        $data['id_detalle_invitacion'] = $id_detalle_invitacion;
        $data['confirmacion_invitacion'] = $confirmacion_invitacion;
        $this->gsatelite->cargar_vista_masterpage("modulo_eventos/procesos/editar_evento",$data,null);
    }

    public function confirmar_evento($id_invitacion=0)
    {
        $exito = 0 ;
        $id_invitacion = ($id_invitacion > 0)? $id_invitacion:$this->input->post("id_invitacion");
        if ($id_invitacion > 0) 
        {
             $datos_update = array(
                 'usv_confirmado'            => 1,
                 'usv_fecha_confirmacion'    => date("Y-m-d H:i:s"),
                 'usv_usu_modificacion'      => $this->tank_auth->get_user_id(),
                 'usv_fecha_modificacion'    => date("Y-m-d H:i:s")
             );
            $exito =  $this->gsatelite->actualizar_array("usv_usuario_evento",$datos_update,array("usv_id"=>$id_invitacion));

        }
        die(json_encode(array("exito"=>$exito)));
    }

    public function recordatorio_evento($id_evento=0)
    {
        $exito = 0 ;
        $id_evento = ($id_evento > 0)? $id_evento:$this->input->post("id_evento");
        if ($id_evento > 0) 
        {
            $exito = $this->envio_correo_evento($id_evento, null, null, " (RECORDATORIO DE EVENTO)");
        }
        die(json_encode(array("exito"=>$exito)));
    }

} // End class
