<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimiento extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('eventos_model');
        $this->load->model('sistema');
        $this->load->model('consultas');
        $this->model = $this->sistema;
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Eventos';
            $this->_cargarvista(null, $data);
        }
    }


    /**
    *@author Daniel perez
    * Rutas controller
    */  
    function rutas(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        // print_r($permisos);die();
        $crud = new grocery_CRUD();
        $crud->set_table('rut_ruta');
        $crud->display_as('rut_id','Ruta Id');
        $crud->set_subject('Ruta');
        $crud->set_relation('rut_id_cli','cli_cliente',"[CASE WHEN cli_personeria = 1 THEN CONCAT_WS(' ', cli_codigo, ' - ', cli_nombre, cli_apellido) ELSE CONCAT_WS(' ', cli_codigo, ' - ', cli_apellido) END]", array('cli_estado' => 1))
         ->display_as('rut_id_cli', 'Cliente')
         ->callback_column('Cliente', function($value, $row){
             $cliente = $this->gsatelite->get_tabla("cli_cliente", array('cli_id' => $row->rut_id_cli))[0];
            return $cliente['cli_nombre'].' '.$cliente['cli_apellido'];
         })
         ->columns('Cliente','rut_kilometraje', 'rut_tarifa', 'rut_origen', 'rut_destino', 'rut_estado')
         ->display_as('rut_kilometraje', 'Kilometraje Aproximado')
         ->callback_column('rut_kilometraje', function($value, $row){
                return $value == '' ? '0km' : $value.'km';
         })
         ->display_as('rut_tarifa', 'Tarifa')
         ->callback_column('rut_tarifa', function($value, $row){
                return $value == '' ? '$' : '$'.$value;
         })
         ->display_as('rut_origen', 'Origen')
         ->display_as('rut_destino', 'Destino')
         ->display_as('rut_estado', 'Estado')
         ->callback_column('rut_estado', function($value, $row){
                $col_estado = array('1' => 'Activo', '0' => 'Inactivo');
                return $col_estado[$value];
         })
        ->add_fields('rut_id_cli','rut_kilometraje', 'rut_tarifa', 'rut_origen', 'rut_destino', 'rut_estado', 'rut_usu_creacion', 'rut_usu_modificacion', 'rut_fecha_creacion', 'rut_fecha_modificacion')
        ->edit_fields('rut_id_cli','rut_kilometraje', 'rut_tarifa', 'rut_origen', 'rut_destino')
        ->required_fields('rut_id_cli','rut_kilometraje', 'rut_tarifa', 'rut_origen', 'rut_destino');
         ;
        $crud->field_type('rut_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
         if (end(explode('/', uri_string())) == 'read') {
                $col_estado = array('1' => 'Activo', '0' => 'Inactivo');
                return $col_estado[$value];
         }

         if (end(explode('/', uri_string())) == 'add') {
            //$crud->field_type('rut_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
             $crud->callback_column('rut_estado', function($value, $row){
                print_r($value);
                print_r($row);
                die();
             });
            $crud->field_type('rut_estado', 'hidden', 1);
            $crud->field_type('rut_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('rut_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('rut_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('rut_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
         }
         if (end(explode('/', uri_string())) == 'edit') {
            $crud->field_type('rut_estado', 'hidden', 1);
         }
         //Validaciones
         if (!$permisos['permite_agregar']) {
             $crud->unset_add();
         }
         if (!$permisos['permite_editar']) {
             $crud->unset_edit();
         }
         if (!$permisos['permite_eliminar']) {
             $crud->unset_delete();
         }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
         $output = $crud->render();
         $data['titulo_personal'] = "Rutas";
         cargarvista($data,$output,'modulo_eventos/mantenimiento/rutas');
    }
    


}