<?php 

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('evaluacion_desempeno_model');
        $this->ocultar_fecha = false;//SI SE DESEA MOSTRAR O NO FECHA DE REALZIADA LA EVALUACION
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Evaluación de Desempeño';
            cargarvista(null, $data);
        }
    }

    /**
     * @author René Castaneda
     * @since 2017-05-29
     * @return Generar reporte de la evaluación del empleado
     */
    public function evaluacion_empleado($id=0){
        satelite_validar();
        $datos = $this->evaluacion_desempeno_model->informacion_evaluacion_empleado(array('eve_id'=>$id));
        $registro = $datos[0];
        $data['registro'] = $registro;
        $ponderaciones = $this->evaluacion_desempeno_model->get_ponderaciones_evaluacion(array('coe_id_eva'=>$registro['eva_id'], 'pon_estado' => 1));
        $data['ocultar_fecha'] = $this->ocultar_fecha;
        $data['ponderaciones'] = $ponderaciones;
        $data['ponderaciones_r'] = $this->gsatelite->get_tabla('pon_ponderacion');
        $data['registro_evaluacion'] = $this->evaluacion_desempeno_model->get_datos_ponderados_evaluacion_emp(array('dte_id_eve'=>$id,'(dte_respuesta IS NOT NULL OR (dte_id_pxc IS NOT NULL AND dte_nota > 0))'=>null));
                          $this->db->order_by("rae_desde");
        $data["rangos"] = $this->gsatelite->get_tabla('rae_rango_evaluacion');
        $this->load->library('pdf');
        $html = $this->load->view('modulo_evaluacion_desempeno/reportes/evaluacion_empleado_v2', $data, true);//evaluacion_empleado
        
        $this->pdf->makePDF($html);
    }


    public function prueba_reporte(){
        $html = '<html>
        <head>
            <title>HOLA MUNDO</title>
        </head>
        <body>
        <h1>HOLA MUNDO! </h1>
        </body>
        </html>';
        $this->load->library('dompdf_html');
        //echo $html; die();
        $this->dompdf_html->generar_pdf($html,"Mi-reporte");
    }

    public function mi_reporte(){
        $html = $this->load->view('reporte/header2',array('titulo'=>'Hola Mundo'),true);

        die($html);
        $this->load->library('dompdf_html');
        $this->dompdf_html->generar_pdf($html);
    }
    
    public function evaluacion_empleado_excel($id=null){
        satelite_validar();
        $datos = $this->evaluacion_desempeno_model->informacion_evaluacion_empleado(array('eve_id'=>$id));
        $registro = $datos[0];
        $data['registro'] = $registro;
        $ponderaciones = $this->evaluacion_desempeno_model->get_ponderaciones_evaluacion(array('coe_id_eva'=>$registro['eva_id'], 'pon_estado' => 1));
        $data['ocultar_fecha'] = $this->ocultar_fecha;
        $data['ponderaciones'] = $ponderaciones;
        $data['ponderaciones_r'] = $this->gsatelite->get_tabla('pon_ponderacion');
        $data['registro_evaluacion'] = $this->evaluacion_desempeno_model->get_datos_ponderados_evaluacion_emp(array('dte_id_eve'=>$id,'(dte_respuesta IS NOT NULL OR (dte_id_pxc IS NOT NULL AND dte_nota > 0))'=>null));
        $this->db->order_by("rae_desde");
        $data["rangos"] = $this->gsatelite->get_tabla('rae_rango_evaluacion');
        $html = $this->load->view('modulo_evaluacion_desempeno/reportes/evaluacion_emp_excel_v2', $data, true);//evaluacion_empleado_excel
        if($id > 0){ 
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=reporte_evaluacion_empleado.xls"); 
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            die();
        } else {
            echo json_encode(array('resultado'=>$html));
        }       
        
    }
}



