<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('evaluacion_desempeno_model');
    }

    function index() {
    	satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Evaluación de Desempeño';
            $this->_cargarvista(null, $data);
        }
    }

    /**
    * @author René Castaneda
    * @since 2017-05-19
    * @return Mantenimiento tabla eva_evaluacion
     */
    function evaluacion() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('eva_evaluacion');
        $crud->set_subject('Evaluación');

        $columns = array(
            'eva_codigo',
            'eva_nombre',
            'eva_observacion',
            'eva_estado'
        );

        $display_as = array(
            'eva_codigo' => 'Código',
            'eva_nombre' => 'Nombre',
            'eva_indicacion' => 'Indicaciones',
            'eva_objetivo' => 'Objetivo',
            'eva_archivo' => 'Anexos',
            'eva_observacion' => 'Observación',
            'eva_estado' => 'Estado'
        );

        $required = array(
            'eva_codigo',
            'eva_nombre',
            'eva_estado'
        );

        $add_columns = array(
            'eva_codigo',
            'eva_nombre',
            'eva_indicacion',
            'eva_objetivo',
            'eva_observacion',
            'eva_archivo',
            'eva_estado',
            'eva_fecha_creacion',
            'eva_usu_creacion',
            'eva_fecha_modificacion',
            'eva_usu_modificacion'
        );

        $edit_columns = array(
            'eva_codigo',
            'eva_nombre',
            'eva_indicacion',
            'eva_objetivo',
            'eva_observacion',
            'eva_archivo',
            'eva_estado',
            'eva_fecha_modificacion',
            'eva_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('eva_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('eva_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('eva_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('eva_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('eva_codigo','Código','campo_unico[eva_evaluacion.eva_codigo]|required');
        $crud->set_rules('eva_nombre','Nombre','campo_unico[eva_evaluacion.eva_nombre]|required');
        //$crud->unset_export();
        $crud->unset_print();
        $crud->add_action('Competencias', '', 'modulo_evaluacion_desempeno/procesos/competencias', 'minia-icon-list-4');
        $crud->add_action('Evaluación - Puesto', '', 'modulo_evaluacion_desempeno/procesos/evaluacion_puesto', 'icomoon-icon-list-view');
        $crud->add_action('Duplicar Evaluación', '', 'modulo_evaluacion_desempeno/procesos/duplicar_evaluacion', 'icomoon-icon-list-view');
        $crud->set_field_upload('eva_archivo', 'uploads/anx_evaluacion');

        if ($accion == 'add') {
            $crud->field_type('eva_estado', 'hidden', 1);
        } else {
            $crud->field_type('eva_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/procesos/evaluacion/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Evaluaciones";
        cargarvista($data, $output);
    } //Fin mantenimiento Evaluaciones

        /**
        * @author Andrea Rivera
        * @package erp_satelite
        * @subpackage modulo_evaluacion_desempeno
        * @since 2019-12-13
        * @return Duplicar registro de evalucion
        */

    public function duplicar_evaluacion($id_evaluacion)
    {
        if (!$this->tank_auth->is_logged_in())
        {
            redirect('/auth/login/');
        }
        else
        {
            $this->gsatelite->verificar_registro_real('eva_evaluacion',$id_evaluacion);
            if ($id_evaluacion > 0)
            {            
                    $registro_evaluacion = $this->gsatelite->get_tabla('eva_evaluacion', array('eva_id' => $id_evaluacion));   
                    $codigo_evaluacion = $registro_evaluacion[0]['eva_codigo'];
                    $codigo_evaluacion .='1';

                    $eva_columns = array(
                        'eva_codigo'=>$codigo_evaluacion,
                        'eva_nombre'=>$registro_evaluacion[0]['eva_nombre'],
                        'eva_observacion'=>$registro_evaluacion[0]['eva_observacion'],
                        'eva_estado'=>$registro_evaluacion[0]['eva_estado'],
                        'eva_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'eva_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'eva_fecha_modificacion'=>date('Y-m-d H:i:s'),
                        'eva_usu_modificacion'=>$this->tank_auth->get_user_id()
                    );
                    $evaluacion = $this->gsatelite->ingresar('eva_evaluacion', $eva_columns); 

                    $registro_competencia = $this->gsatelite->get_tabla('coe_competencia_evaluacion', array('coe_id_eva' => $id_evaluacion));

                    $id_compe = $registro_competencia[0]['coe_id'];
                    if ($id_compe>0) {            
                        foreach ($registro_competencia as $competencias)
                        { 
                            $comp_rows = array(
                                'coe_id_cte' => $competencias['coe_id_cte'], 
                                'coe_id_eva' => $evaluacion,
                                'coe_nombre' => $competencias['coe_nombre'],
                                'coe_tipo' => $competencias['coe_tipo'], 
                                'coe_orden' => $competencias['coe_orden'],
                                'coe_descripcion' => $competencias['coe_descripcion'],
                                'coe_estado' => $competencias['coe_estado'],
                                'coe_usu_creacion' => $this->tank_auth->get_user_id(), 
                                'coe_fecha_creacion' => date('Y-m-d H:i:s'), 
                                'coe_usu_modificacion' => $this->tank_auth->get_user_id(), 
                                'coe_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            if ($comp_rows['coe_tipo']==2) {    
                                $id_competencia = $this->gsatelite->ingresar('coe_competencia_evaluacion', $comp_rows);                                     
                                $registro_pon = $this->gsatelite->get_tabla('pxc_ponderacionxcompetencia', array('pxc_id_coe' =>$id_compe)); 
                                    foreach ($registro_pon as $ponderaciones) {
                                        $insert_pon = array(
                                            'pxc_id_coe' => $id_competencia, 
                                            'pxc_id_pon' => $ponderaciones['pxc_id_pon'], 
                                            'pxc_estado' => $ponderaciones['pxc_estado'], 
                                            'pxc_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'pxc_fecha_creacion' => date('Y-m-d H:i:s'), 
                                            'pxc_usu_modificacion' => $this->tank_auth->get_user_id(), 
                                            'pxc_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );                                    
                                        $insert_ponderaciones = $this->gsatelite->ingresar('pxc_ponderacionxcompetencia', $insert_pon);               
                                    }                               
                                }else{
                                    $id_competencia = $this->gsatelite->ingresar('coe_competencia_evaluacion', $comp_rows);                     
                                } 

                        }
                    }            
                    $registro_eva_puesto = $this->gsatelite->get_tabla('ext_evaluacionxpuesto', array('ext_id_eva' => $id_evaluacion)); 
                    if ($registro_eva_puesto!=null) {
                        foreach ($registro_eva_puesto as $eva_puesto){ 
                            $eva_puesto_col = array(
                                    'ext_id_eva' => $evaluacion,
                                    'ext_id_pto' => $eva_puesto['ext_id_pto'],
                                    'ext_fecha' => date('Y-m-d H:i:s'),
                                    'ext_estado' => $eva_puesto['ext_estado'],
                                    'ext_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'ext_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'ext_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'ext_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                            $eva_puestos = $this->gsatelite->ingresar('ext_evaluacionxpuesto', $eva_puesto_col);
                        }
                    }

                    if ($evaluacion > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Duplicado", 'texto_alerta' => "Registro duplicado correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error en duplicar", 'texto_alerta' => "No se pudo duplicar el registro");
                    }
                    $this->session->set_flashdata($alerta);
                    redirect("modulo_evaluacion_desempeno/procesos/evaluacion/$id_evaluacion");         
            }
        }
    }
            

        /**
        * @author René Castaneda
        * @since 2017-05-19
        * @return Mantenimiento tabla ext_evaluacionxpuesto
         */
        public function evaluacion_puesto($id_evaluacion) {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                try {
                    if (!is_numeric($id_evaluacion)) {
                        redirect('');
                    }
                    $this->gsatelite->verificar_registro_real('eva_evaluacion',$id_evaluacion);
                    if ($this->input->post()) {
                        if ($this->input->post('evaluacion_id') > 0 and $this->input->post('puesto') > 0) {
                            $id_evaluacion = $this->input->post('evaluacion_id');
                            $insert_array = array(
                                'ext_id_eva' => $this->input->post('evaluacion_id'),
                                'ext_id_pto' => $this->input->post('puesto'),
                                'ext_fecha' => date('Y-m-d H:i:s'),
                                'ext_estado' => 1,
                                'ext_usu_creacion' => $this->tank_auth->get_user_id(),
                                'ext_fecha_creacion' => date('Y-m-d H:i:s'),
                                'ext_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'ext_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $exito = $this->gsatelite->ingresar('ext_evaluacionxpuesto', $insert_array);
                            // $envio = $this->funcion_correo(null, $this->input->post('puesto'));
                            //SIMILAR A LA FUNCION ANTERIOR PERO MANDA EL CORREO AL JEFE PARA QUE EVALUE AL EMPLEADO
                            $envio = $this->funcion_correo_2(null, $this->input->post('puesto'), $exito);
                            $array_alert = array("exito" => $exito, "envio" => $envio);
                            $this->session->set_flashdata($array_alert);                            
                            redirect("modulo_evaluacion_desempeno/procesos/evaluacion_puesto/$id_evaluacion");
                        }
                    }
                    $permisos = $this->gsatelite->get_permisos_opcion('evaluacion');
                    $data['registro'] = $this->gsatelite->get_tabla('eva_evaluacion', array('eva_id' => $id_evaluacion));
                    $crud = new grocery_CRUD();
                    $crud->set_table('ext_evaluacionxpuesto')
                            ->set_subject('Evaluación - Puesto')
                            ->where('ext_id_eva', $id_evaluacion)
                            ->columns('ext_id_pto', 'ext_estado')
                            ->add_fields('ext_id_eva', 'ext_id_pto', 'ext_estado', 'ext_usu_creacion', 'ext_usu_modificacion', 'ext_fecha_creacion', 'ext_fecha_modificacion')
                            ->edit_fields('ext_id_eva', 'ext_id_pto', 'ext_estado', 'ext_usu_modificacion', 'ext_fecha_modificacion')
                            ->display_as('ext_id_eva', 'Evaluacióna')
                            ->display_as('ext_id_pto', 'Puesto')
                            ->display_as('ext_estado', 'Estado')
                            ->required_fields('ext_id_eva', 'ext_estado')
                            ->set_relation('ext_id_pto', 'pto_puesto', '{pto_nombre}', array('pto_estado' => 1))
                            ->set_relation('ext_id_eva', 'eva_evaluacion', '{eva_nombre}')
                            ->set_rules('ext_id_pto', 'Puesto', 'trim|required|campo_unico[ext_evaluacionxpuesto.ext_id_pto]')
                            ->field_type('ext_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                            ->field_type('ext_id_eva', 'hidden', $id_evaluacion)
                            ->field_type('ext_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                            ->field_type('ext_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                            ->field_type('ext_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ;

                    $data['estado_accion'] = $crud->getState();
                    if ($data['estado_accion'] == 'add') {
                        $crud->field_type('ext_estado', 'hidden', 1);
                    } else {
                        $crud->field_type('ext_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                    }

                    $data['titulo_personal'] = "Asignar Evaluación";
                    $crud->unset_print()->unset_export()->unset_add();
                    $data['permite_agregar'] = $permisos['permite_agregar'];

                    $data['select_puesto'] = $this->evaluacion_desempeno_model->select_puesto($id_evaluacion);
                    // Validaciones
                    if (!$permisos['permite_agregar']) {
                        $crud->unset_add();
                    }
                    if (!$permisos['permite_editar']) {
                        $crud->unset_edit();
                    }
                    if (!$permisos['permite_eliminar']) {
                        $crud->unset_delete();
                    }
                    if ($permisos['permite_ver']) {
                        $crud->add_action('Ver', 'minia-icon-search', "modulo_evaluacion_desempeno/procesos/evaluacion_puesto/$id_evaluacion/read");
                    }
                    //print_r($data); die();
                    $output = $crud->render();
                    cargarvista($data, $output);
                } catch (Exception $e) {
                    show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
                }
            }
        }

    // End function evaluacion_puesto

        /**
         * @author René Castaneda
         * @since 2017-05-19
         * @return Mantenimiento de competencias por Evaluacion
         */
        public function competencias($id_evaluacion) {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                try {
                    if (!is_numeric($id_evaluacion)) {
                        redirect('');
                    }
                    $this->gsatelite->verificar_registro_real('eva_evaluacion',$id_evaluacion);

                    $permisos = $this->gsatelite->get_permisos_opcion('evaluacion');
                    $data['registro'] = $this->gsatelite->get_tabla('eva_evaluacion', array('eva_id' => $id_evaluacion));
                    $crud = new grocery_CRUD();
                    $crud->set_table('coe_competencia_evaluacion')
                            ->set_subject('Competencia')
                            ->where('coe_id_eva', $id_evaluacion)
                            ->columns('coe_orden', 'coe_id_cte', 'coe_nombre', 'coe_tipo')
                            ->display_as('coe_orden', 'Orden')
                            ->display_as('coe_id_cte', 'Categoria')
                            ->display_as('coe_nombre', 'Nombre')
                            ->display_as('coe_tipo', 'Tipo')
                            ->display_as('coe_estado', 'Estado')
                            ->required_fields('coe_nombre', 'coe_estado')
                            ->set_relation('coe_id_cte', 'cte_categoria_evaluacion', '{cte_nombre}')
                    ;
                    $crud->callback_column('coe_nombre', function($value, $row) {
                        return $value;
                    });
                    $crud->callback_column('coe_tipo', function($value, $row) {
                        $tipo = ($value == 1) ? 'Complementar' : '<a class="ver_en_modal_ajax2"  target="_blank" href="' . base_url('modulo_evaluacion_desempeno/procesos/ver_detalle_competencia/' . $row->coe_id) . '">Opc. Multiple</a>';
                        return $tipo;
                    });
                    $crud->field_type('coe_tipo', 'dropdown', array('1' => 'Complementar', '2' => 'Opc. Multiple'));


                    $data['titulo_personal'] = "Competencias Evaluación";
                    $crud->unset_print()->unset_export()->unset_edit();
                    // Validaciones
                    if (!$permisos['permite_agregar']) {
                        $crud->unset_add();
                    }
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', '', 'modulo_evaluacion_desempeno/procesos/editar_competencia', 'icomoon-icon-pencil-5');
                    }
                    if (!$permisos['permite_eliminar']) {
                        $crud->unset_delete();
                    }
                    if ($permisos['permite_ver']) {
                        $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/procesos/lectura_competencia');
                    }

                    $output = $crud->render();
                    cargarvista($data, $output);
                } catch (Exception $e) {
                    show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
                }
            }
        }

    /**
     * @author René Castaneda
     * @since 2017-05-19
     * @return Agregar Competencias
     */
    public function agregar_competencia($id_evaluacion) {
    	satelite_validar();
    	if (!is_numeric($id_evaluacion)) {
    	    redirect('');
    	}
    	$this->gsatelite->verificar_registro_real('eva_evaluacion',$id_evaluacion);
    	

        if ($this->input->post()) {
           //  print_r($_POST); die();
            $id_evaluacion = $this->input->post('id_evaluacion');
            $nombre = $this->input->post('nombre');
            $categoria = $this->input->post('categoria');
            $tipo_competencia = $this->input->post('tipo_competencia');
            $orden = $this->input->post('orden');
            $observacion = $this->input->post('observacion');
            $estado = $this->input->post('estado');
            $tipo_accion = $this->input->post('tipo_accion');

            $id_competencia = 0;

            if ($id_evaluacion > 0 && trim($nombre) != '' && $categoria > 0 && $orden > 0 && $tipo_competencia > 0) {
                $array_insert = array(
                    'coe_id_cte' => $categoria
                    , 'coe_id_eva' => $id_evaluacion
                    , 'coe_nombre' => trim($nombre)
                    , 'coe_tipo' => $tipo_competencia
                    , 'coe_orden' => $orden
                    , 'coe_descripcion' => (trim($observacion) != '') ? trim($observacion) : null
                    , 'coe_estado' => $estado
                    , 'coe_usu_creacion' => $this->tank_auth->get_user_id()
                    , 'coe_fecha_creacion' => date('Y-m-d H:i:s')
                    , 'coe_usu_modificacion' => $this->tank_auth->get_user_id()
                    , 'coe_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if ($tipo_competencia == 2) {
                    $opciones = $this->input->post('detalle_pon');
                    if (count($opciones) > 1) { //si es de tipo cerrada debe tener un minimo de 2 opciones de respuesta
                        $id_competencia = $this->gsatelite->ingresar('coe_competencia_evaluacion', $array_insert);
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                $insert_opc = array(
                                    'pxc_id_coe' => $id_competencia
                                    , 'pxc_id_pon' => ($opciones[$i] > 0) ? $opciones[$i] : null
                                    , 'pxc_estado' => 1
                                    , 'pxc_usu_creacion' => $this->tank_auth->get_user_id()
                                    , 'pxc_fecha_creacion' => date('Y-m-d H:i:s')
                                    , 'pxc_usu_modificacion' => $this->tank_auth->get_user_id()
                                    , 'pxc_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $id_detalle = $this->gsatelite->ingresar('pxc_ponderacionxcompetencia', $insert_opc);
                            }
                        }
                    }
                } else {
                    $id_competencia = $this->gsatelite->ingresar('coe_competencia_evaluacion', $array_insert);
                }
            }

            if ($id_competencia > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Agregado", 'texto_alerta' => "Registro agregado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Guardar", 'texto_alerta' => "No se pudo guardar el registro, favor verificar e intentar nuevamente");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('modulo_evaluacion_desempeno/procesos/competencias/' . $id_evaluacion);
            } else {
                redirect("modulo_evaluacion_desempeno/procesos/agregar_competencia/$id_evaluacion");
            }
        }

        $registro = $this->gsatelite->get_tabla('eva_evaluacion', array('eva_id' => $id_evaluacion));
        $data['titulo_personal'] = "Agregar Competencia";
        $data['registro'] = $registro;
        $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('cte_categoria_evaluacion', '{cte_nombre}', '', array('cte_estado' => '1'), null, '', 'cte_id', true));
        $data['ponderacion'] = $this->gsatelite->get_tabla('pon_ponderacion', array('pon_estado' => 1));
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-05-21
     * @return Editar Competencias
     * @param int $id_competencia
     */
    public function editar_competencia($id_competencia) {
    	satelite_validar();
        if ($id_competencia <= 0 or ! is_numeric($id_competencia)) {
            redirect('');
        }
        $this->gsatelite->verificar_registro_real('coe_competencia_evaluacion',$id_competencia);
        
        $registro_competencia = $this->gsatelite->get_tabla('coe_competencia_evaluacion', array('coe_id' => $id_competencia));
        $id_evaluacion = $registro_competencia[0]['coe_id_eva'];

        $existe_respuesta = $this->gsatelite->get_tabla('dte_detalle_evaluacion', array('dte_id_coe' => $id_competencia));

        if (count($existe_respuesta) > 0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La Competencia no puede ser editada pues ya fue utilizada en Evaluaciones que poseen respuestas");
            $this->session->set_flashdata($alerta);
            redirect('modulo_evaluacion_desempeno/procesos/competencias/' . $id_evaluacion);
        }
        if ($this->input->post()) {
           //print_r($_POST); die();
           $id_evaluacion = $this->input->post('id_evaluacion');
           $nombre = $this->input->post('nombre');
           $categoria = $this->input->post('categoria');
           $tipo_competencia = $this->input->post('tipo_competencia');
           $orden = $this->input->post('orden');
           $observacion = $this->input->post('observacion');
           $estado = $this->input->post('estado');
           $tipo_accion = $this->input->post('tipo_accion');
           
            $id_competencia = $this->input->post('id_competencia');

            if ($id_evaluacion > 0 && trim($nombre) != '' && $categoria > 0 && $orden > 0 && $tipo_competencia > 0) {
                $array_update = array(
                    'coe_id_cte' => $categoria
                    , 'coe_id_eva' => $id_evaluacion
                    , 'coe_nombre' => trim($nombre)
                    , 'coe_tipo' => $tipo_competencia
                    , 'coe_orden' => $orden
                    , 'coe_descripcion' => (trim($observacion) != '') ? trim($observacion) : null
                    , 'coe_estado' => $estado
                    , 'coe_usu_modificacion' => $this->tank_auth->get_user_id()
                    , 'coe_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if ($tipo_competencia == 2) {
                    $id_existen = $this->input->post('detalle_pxc_id');
                    $opciones = $this->input->post('detalle_pon');

                    if (count($opciones) > 1) { //si es de tipo cerrada debe tener un minimo de 2 opciones de respuesta
                        $this->gsatelite->actualizar_array('coe_competencia_evaluacion', $array_update, array('coe_id' => $id_competencia));
                        $editados = array();
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                if ($id_existen[$i] > 0) {
                                    $editados[] = $id_existen[$i];
                                    $update_opc = array(
                                    	'pxc_id_pon' => $opciones[$i]
                                        ,'pxc_estado' => 1
                                        , 'pxc_usu_modificacion' => $this->tank_auth->get_user_id()
                                        , 'pxc_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $id_detalle = $this->gsatelite->actualizar_array('pxc_ponderacionxcompetencia', $update_opc, array('pxc_id' => $id_existen[$i],"pxc_id_coe"=>$id_competencia));
                                } else {
                                	//$editados[] = $opciones[$i];
                                    $insert_opc = array(
                                        'pxc_id_coe' => $id_competencia
                                        , 'pxc_id_pon' => trim($opciones[$i])
                                        , 'pxc_estado' => 1
                                        , 'pxc_usu_creacion' => $this->tank_auth->get_user_id()
                                        , 'pxc_fecha_creacion' => date('Y-m-d H:i:s')
                                        , 'pxc_usu_modificacion' => $this->tank_auth->get_user_id()
                                        , 'pxc_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $id_detalle = $this->gsatelite->ingresar('pxc_ponderacionxcompetencia', $insert_opc);
                                }
                            }
                        }
                        $id_actuales = explode(',', $this->input->post('id_opc_array'));
                        for ($k = 0; $k < count($id_actuales); $k++) {
                            if (!in_array($id_actuales[$k], $editados)) { //eliminar los que ya no  venga en el post
                                $this->gsatelite->borrado_general('pxc_ponderacionxcompetencia', array('pxc_id' => $id_actuales[$k],'pxc_id_coe' => $id_competencia));

                            }
                        }
                    }
                } else {
                    $this->gsatelite->actualizar_array('coe_competencia_evaluacion', $array_update, array('coe_id' => $id_competencia));
                    $this->gsatelite->borrado_general('pxc_ponderacionxcompetencia', array('pxc_id_coe' => $id_competencia));

                }
            }

            if ($id_competencia > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Actualizado", 'texto_alerta' => "Registro actualizado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Actualizar", 'texto_alerta' => "No se pudo actualizar el registro, favor verificar e intentar nuevamente");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('modulo_evaluacion_desempeno/procesos/competencias/' . $id_evaluacion);
            } else {
                redirect("modulo_evaluacion_desempeno/procesos/editar_competencia/$id_competencia");
            }
        }

        $registro_evaluacion = $this->gsatelite->get_tabla('eva_evaluacion', array('eva_id' => $id_evaluacion));
        $data['titulo_personal'] = "Editar Competencia";
        $data['registro_evaluacion'] = $registro_evaluacion[0];
        $data['registro_competencia'] = $registro_competencia[0];
        $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('cte_categoria_evaluacion', '{cte_nombre}', '', array('cte_estado' => '1'), $registro_competencia[0]['coe_id_cte'], '', 'cte_id', true));
        $data['ponderacion'] = $this->gsatelite->get_tabla('pon_ponderacion', array('pon_estado' => 1));
        $data['opciones_ponderacion'] = array();
        if ($registro_competencia[0]['coe_tipo'] == 2) {
            $data['opciones_ponderacion'] = $this->evaluacion_desempeno_model->opcion_respuesta(array('pxc_id_coe' => $registro_competencia[0]['coe_id'], 'pxc_estado' => 1));
        }
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-05-21
     * @return validar orden Competencias
     */
    public function validar_orden() {
        $existe = 0;
        if ($this->input->post('id_eva') > 0 and $this->input->post('orden') > 0) {
            $where = array('coe_id_eva' => $this->input->post('id_eva'), 'coe_orden' => $this->input->post('orden'), 'coe_id !=' => $this->input->post('id_competencia'));
            $query = $this->gsatelite->get_tabla('coe_competencia_evaluacion', $where);
            if (count($query) > 0) {
                $existe = 1;
            }
        }

        die(json_encode(array('existe' => $existe)));
    }

    /**
     * @author René Castaneda
     * @since 2017-05-21
     * @return validar nombre de competencia
     */
    public function validar_competencia() {
        $existe = 0;
        if ($this->input->post('id_eva') > 0 and trim($this->input->post('competencia')) != '') {
            $where = array('coe_id_eva' => $this->input->post('id_eva'), 'coe_nombre' => trim($this->input->post('competencia')), 'coe_id !=' => $this->input->post('id_competencia'));
            $query = $this->gsatelite->get_tabla('coe_competencia_evaluacion', $where);
            if (count($query) > 0) {
                $existe = 1;
            }
        }

        die(json_encode(array('existe' => $existe)));
    }

    /**
     * @author René Castaneda
     * @since 2017-05-21
     * @return Ver Competencias
     * @param int $id_competencia
     */
    public function lectura_competencia($id_competencia) {
    	satelite_validar();
        if ($id_competencia <= 0 or ! is_numeric($id_competencia)) {
            redirect('');
        }
        $this->gsatelite->verificar_registro_real('coe_competencia_evaluacion',$id_competencia);
        
        $registro_competencia = $this->gsatelite->get_tabla('coe_competencia_evaluacion', array('coe_id' => $id_competencia));
        $id_evaluacion = $registro_competencia[0]['coe_id_eva'];

        $existe_respuesta = $this->gsatelite->get_tabla('dte_detalle_evaluacion', array('dte_id_coe' => $id_competencia));

       /* if (count($existe_respuesta) > 0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La Competencia no puede ser editada porque no ya se encuentra procesada con respuestas");
            $this->session->set_flashdata($alerta);
            redirect('modulo_evaluacion_desempeno/procesos/competencias/' . $id_evaluacion);
        }  */


        $registro_evaluacion = $this->gsatelite->get_tabla('eva_evaluacion', array('eva_id' => $id_evaluacion));
        $data['titulo_personal'] = "Editar Competencia";
        $data['registro_evaluacion'] = $registro_evaluacion[0];
        $data['registro_competencia'] = $registro_competencia[0];
        $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('cte_categoria_evaluacion', '{cte_nombre}', '', array('cte_estado' => '1'), $registro_competencia[0]['coe_id_cte'], '', 'cte_id', true));
        $data['ponderacion'] = $this->gsatelite->get_tabla('pon_ponderacion', array('pon_estado' => 1));
        $data['opciones_ponderacion'] = array();
        if ($registro_competencia[0]['coe_tipo'] == 2) {
            $data['opciones_ponderacion'] = $this->evaluacion_desempeno_model->opcion_respuesta(array('pxc_id_coe' => $registro_competencia[0]['coe_id'], 'pxc_estado' => 1));
        }
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-05-21
     * @return Ver detalle de competencia
     * @param int $id_competencia
     */
    public function ver_detalle_competencia($id_competencia) {
        $registro_competencia = $this->gsatelite->get_tabla('coe_competencia_evaluacion', array('coe_id' => $id_competencia));
        $data['registro_competencia'] = $registro_competencia[0];
        if ($registro_competencia[0]['coe_tipo'] == 2) {
            $data['opciones_respuesta'] = $this->evaluacion_desempeno_model->opcion_respuesta(array('pxc_id_coe' => $registro_competencia[0]['coe_id'], 'pxc_estado' => 1));
        }
        $this->load->view('modulo_evaluacion_desempeno/procesos/ver_detalle_competencia', $data);
    }

    /**
     * @author René Castaneda
     * @since 2017-05-19
     * @return Mantenimiento de Evaluacion por empleado
     */
    public function evaluacion_empleado($emp_id = NULL) {
        satelite_validar();
        $p = ($this->input->post('periodo_id') > 0 )? $this->input->post('periodo_id') : null;
        $periodoss = $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo}', '', null, $p, '', 'pde_id', true);
        $data['periodos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $periodoss);
        
        $data['periodo_id'] = 0;
        $data['fecha_inicio'] = '';
        $data['fecha_fin'] = '';
        if ($emp_id != null) {
            $where['eve_id_emp'] = $emp_id;
        } else {
            // $where['eve_id_pde'] = '0';
            $where = null;
        }

        if ($this->input->post()) {
            if ($this->input->post('periodo_id') > 0) {
                $where['eve_id_pde'] = $this->input->post('periodo_id');
            }
            if ($this->input->post('fecha_inicio') != "" ) {
                $where['date(eve_fecha_evaluacion) >='] = date('Y-m-d',strtotime($this->input->post('fecha_inicio')));
            }
            if ($this->input->post('fecha_fin') != "") {
                $where['date(eve_fecha_evaluacion) <='] = date('Y-m-d',strtotime($this->input->post('fecha_fin')));
            }
            $data['periodo_id'] = $this->input->post('periodo_id');
            $data['fecha_inicio'] = $this->input->post('fecha_inicio');
            $data['fecha_fin'] = $this->input->post('fecha_fin');
            if ($this->input->post("empleado_id") != null || $this->input->post("empleado_id") != "") {
                $where['eve_id_emp'] = $this->input->post('empleado_id');
            }
            if ($this->input->post("area_id") != null || $this->input->post("area_id") != "") {
                $area_id = $this->input->post("area_id");
                $empleados = $this->gsatelite->get_tabla('emp_empleado', array("emp_id_are" => $area_id, 'emp_estado' => 1));
                $id_empleados = (count($empleados) > 0) ? array_column($empleados, "emp_id") : array();
                $select = implode(',', $id_empleados);                
                $where["eve_id_emp IN ( $select )"] = null;
            }
        }
        
        $data["emp_id"] = $emp_id;
        //var_dump($where);die();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('eve_evaluacion_empleado');
        if ($where) {
            $crud->where($where);
        }
        $crud->set_subject('');
        $data['estado'] = $accion;
        $columns = array(
            'eve_id_emp',
            'eve_fecha_evaluacion',
            'eve_id_pde',
            'eve_calificacion'
        );

        $display_as = array(
            'eve_id_emp' => 'Código - Empleada/o',
            'eve_fecha_evaluacion' => 'Fecha',
            'eve_id_pde' => 'Periodo',
            'eve_calificacion' => 'Resultado'
        );

        $required = array(
        	'eve_id_emp',
        	'eve_fecha_evaluacion',
        	'eve_id_pde',
        	'eve_calificacion',
            'eve_estado'
        );

        $add_columns = array(
        	'eve_id_emp',
        	'eve_fecha_evaluacion',
        	'eve_id_pde',
        	'eve_calificacion',
            'eve_estado',
            'eve_fecha_creacion',
            'eve_usu_creacion',
            'eve_fecha_modificacion',
            'eve_usu_modificacion'
        );

        $edit_columns = array(
        	'eve_id_emp',
        	'eve_fecha_evaluacion',
        	'eve_id_pde',
        	'eve_calificacion',
            'eve_estado',
            'eve_fecha_modificacion',
            'eve_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->set_relation('eve_id_emp', 'emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}');
        $crud->set_relation('eve_id_pde', 'pde_periodo_evaluacion', '{pde_codigo}');
        $crud->field_type('eve_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('eve_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('eve_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('eve_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->unset_export();
        $crud->unset_print();
        $crud->unset_edit();
        $crud->callback_column('eve_fecha_evaluacion', function($value, $row) {
            return date('d-m-Y',strtotime($value));
        });

        if ($accion == 'add') {
            $crud->field_type('eve_estado', 'hidden', 1);
        } else {
            $crud->field_type('eve_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if ($permisos['permite_editar']) {
           $crud->add_action('Editar', '', 'modulo_evaluacion_desempeno/procesos/editar_evaluacion_empleado', 'icomoon-icon-pencil-5');
        }
        //if (!$permisos['permite_eliminar']) {//SE ELIMINA LA OPCION TEMPORALMENTE 21-12-20
            $crud->unset_delete();
        // }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/procesos/lectura_evaluacion_empleado'); //array('eve_estado'=>1)
            $crud->add_action('Imprimir', 'entypo-icon-printer', 'modulo_evaluacion_desempeno/reportes/evaluacion_empleado','',null,' target="_blank" ');
            $crud->add_action('Exportar a excel', 'entypo-icon-export', 'modulo_evaluacion_desempeno/reportes/evaluacion_empleado_excel','',null,' target="_blank" ');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Evaluaciones Empleada/o";
        cargarvista($data, $output, "modulo_evaluacion_desempeno/procesos/evaluacion_empleado");
    } 

    public function evalua_colaborador(){
        satelite_validar();
        $p = ($this->input->post('periodo_id') > 0 ) ? $this->input->post('periodo_id') : null;
        $periodos = $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo}', '', null, $p, '', 'pde_id', true);
        $data['periodos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $periodos);
        $data['periodo_id'] = 0;
        $data['fecha_inicio'] = '';
        $data['fecha_fin'] = '';
                   $this->db->join('emp_empleado', 'usu_id_emp = emp_id','left');
                   $this->db->join('plz_plaza', 'emp_id_plz = plz_id','left');
        $emp_plz = $this->gsatelite->get_tabla('users',array('id' => $this->tank_auth->get_user_id(), 'emp_id_plz IS NOT NULL' => null));
        if (count($emp_plz) > 0) {
            $plz_id = $emp_plz[0]["emp_id_plz"];
            $plz_hijo = $this->gsatelite->get_tabla('plz_plaza',array('plz_id_padre' => $plz_id,"plz_estado" => 1));
            $plz_hijos = implode(',', array_column($plz_hijo,"plz_id"));
            $subordinados = ($plz_hijos != "") ? $this->gsatelite->get_tabla('emp_empleado', array("emp_id_plz IN($plz_hijos)" => NULL, 'emp_estado' => 1)) : array();
            $empleados = (count($subordinados) > 0) ? array_column($subordinados, "emp_id") : array();
            $select = implode(',', $empleados);
        } else {
            $select = "";
        }
        if ($this->input->post()) {
            $where['eve_id_pde'] = $this->input->post('periodo_id');
            $where['DATE(eve_fecha_evaluacion) >='] = formatear_fecha('Y-m-d', $this->input->post('fecha_inicio'));
            $where['DATE(eve_fecha_evaluacion) <='] = formatear_fecha('Y-m-d', $this->input->post('fecha_fin'));
            $data['periodo_id'] = $this->input->post('periodo_id');
            $data['fecha_inicio'] = $this->input->post('fecha_inicio');
            $data['fecha_fin'] = $this->input->post('fecha_fin');

            if ($select != "") {
                $where["eve_id_emp IN( $select )"] = null;
            } else {
                $where['eve_id_pde'] = '0';
            }
        }else{
            $where['eve_id_pde'] = 0;            
        }
        $crud = new grocery_CRUD();
        $accion = $crud->getState();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('eve_evaluacion_empleado');
        $crud->where($where);
        $columns = array(
            'eve_id_emp',
            'eve_fecha_evaluacion',
            'eve_id_pde',
            'eve_calificacion'
        );
        $display_as = array(
            'eve_id_emp' => 'Código - Empleada/o',
            'eve_fecha_evaluacion' => 'Fecha',
            'eve_id_pde' => 'Periodo',
            'eve_calificacion' => 'Resultado'
        );
        $required = array(
            'eve_id_emp',
            'eve_fecha_evaluacion',
            'eve_id_pde',
            'eve_calificacion',
            'eve_estado'
        );
        $add_columns = array(
            'eve_id_emp',
            'eve_fecha_evaluacion',
            'eve_id_pde',
            'eve_calificacion',
            'eve_estado',
            'eve_fecha_creacion',
            'eve_usu_creacion',
            'eve_fecha_modificacion',
            'eve_usu_modificacion'
        );
        $edit_columns = array(
            'eve_id_emp',
            'eve_fecha_evaluacion',
            'eve_id_pde',
            'eve_calificacion',
            'eve_estado',
            'eve_fecha_modificacion',
            'eve_usu_modificacion'
        );
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->set_relation('eve_id_emp', 'emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}');
        $crud->set_relation('eve_id_pde', 'pde_periodo_evaluacion', '{pde_codigo}');
        $crud->field_type('eve_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('eve_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('eve_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('eve_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->unset_export();
        $crud->unset_print();
        $crud->unset_add();
        $crud->unset_edit();
        $crud->unset_delete();
        $crud->callback_column('eve_fecha_evaluacion', function($value, $row) {
            return date('d-m-Y',strtotime($value));
        });
        if ($accion == 'add') {
            $crud->field_type('eve_estado', 'hidden', 1);
        } else {
            $crud->field_type('eve_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if ($permisos['permite_editar']) {
           $crud->add_action('Editar', '', 'modulo_evaluacion_desempeno/procesos/editar_evaluacion_emp', 'icomoon-icon-pencil-5');
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/procesos/read_evaluacion_empleado');
            $crud->add_action('Imprimir', 'entypo-icon-printer', 'modulo_evaluacion_desempeno/reportes/evaluacion_empleado','',null,' target="_blank" ');
            $crud->add_action('Exportar a excel', 'entypo-icon-export', 'modulo_evaluacion_desempeno/reportes/evaluacion_empleado_excel','',null,' target="_blank" ');
        }
        $output = $crud->render();
        $data['titulo_personal'] = "Evaluaciones Empleada/o";
        cargarvista($data, $output, "modulo_evaluacion_desempeno/procesos/evalua_colaborador");
    }


    /**
     * @author René Castaneda
     * @since 2017-05-19
     * @return Agregar Evaluación Empleado
     */
    public function agregar_evaluacion_empleado($datas = null) {
    	satelite_validar();
        if ($this->input->post()) {
            // var_dump($_POST); die();
            $total_calificacion = 10.0;
            $id_evaluacion = $this->input->post('evaluacion_puesto');
            $redirigir = $this->input->post('filtro_redirect');
            $periodo = $this->input->post('periodo');
            $empleado = $this->input->post('empleado');
            $evaluacion_puesto = $this->input->post('id_evaluacion_puesto');
            $competencia_ids = $this->input->post('competencia_id');
            $competencia_tipo = $this->input->post('competencia_tipo');
            $respuesta = $this->input->post('respuesta');
            $resultado = $this->input->post('resultado');
            $observacion = $this->input->post('observacion');
            $total_calificacion = $this->input->post('total_calificacion');
            $estado = $this->input->post('estado');
            $tipo_accion = $this->input->post('tipo_accion');
            $mi_eva = $this->input->post('txtmi_eva');
            $id_eva_empleado = 0;
            $where_rango["CAST($total_calificacion AS DECIMAL) BETWEEN rae_desde and rae_hasta"] = null;
            $rango = $this->gsatelite->get_campo('rae_rango_evaluacion','rae_id',$where_rango);
            //print_r($this->db->last_query());die();
            if ($id_evaluacion > 0 && $evaluacion_puesto > 0 && $empleado > 0) {
                $array_insert = array(
                    'eve_id_emp' => $empleado
                    , 'eve_id_pde' => $periodo
                    , 'eve_id_ext' => $evaluacion_puesto
                    , 'eve_id_rae' => $rango
                    , 'eve_fecha_evaluacion' => date('Y-m-d H:i:s')
                    , 'eve_observacion' => (trim($observacion) != '') ? trim($observacion) : null
                    , 'eve_calificacion' => $total_calificacion
                    , 'eve_estado' => $estado
                    , 'eve_id_usu' => $this->tank_auth->get_user_id()
                    , 'eve_usu_creacion' => $this->tank_auth->get_user_id()
                    , 'eve_fecha_creacion' => date('Y-m-d H:i:s')
                    , 'eve_usu_modificacion' => $this->tank_auth->get_user_id()
                    , 'eve_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $id_eva_empleado = $this->gsatelite->ingresar('eve_evaluacion_empleado', $array_insert);
                for ($i = 0; $i < count($competencia_ids); $i++) {
                    if ($competencia_ids[$i] > 0) {                        
                        $insert_respuesta = array(
                            'dte_id_eve' => $id_eva_empleado
                            , 'dte_id_coe' => ($competencia_ids[$i] > 0) ? $competencia_ids[$i] : null
                            , 'dte_id_pxc' => ($respuesta[$i] > 0 and $competencia_tipo[$i] == 2) ? $respuesta[$i] : null
                            , 'dte_nota' => (trim($resultado[$i])!='' > 0 and $competencia_tipo[$i] == 2) ? trim($resultado[$i]):0
                            , 'dte_respuesta' => (trim($respuesta[$i]) !='' and $competencia_tipo[$i] == 1) ? trim($respuesta[$i]) : null
                            , 'dte_estado' => 1
                            , 'dte_usu_creacion' => $this->tank_auth->get_user_id()
                            , 'dte_fecha_creacion' => date('Y-m-d H:i:s')
                            , 'dte_usu_modificacion' => $this->tank_auth->get_user_id()
                            , 'dte_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_detalle = $this->gsatelite->ingresar('dte_detalle_evaluacion', $insert_respuesta);
                    }
                }
            }
            if ($mi_eva == 1 && $id_eva_empleado > 0 && $tipo_accion == 1) {
                // $envio = $this->funcion_correo($empleado,null);
                $envio = $this->funcion_correo_2($empleado,null,$id_eva_empleado);
            } elseif ($mi_eva == 0 && $id_eva_empleado > 0) {//enviara correo informativo al evaluado
                $envio = $this->funcion_correo_2($empleado,null,$id_eva_empleado);
            } else {
                $envio = null;
            }

            if ($id_eva_empleado > 0) {
                $alerta = array('tipo_alerta' => 'success', 
                    'titulo_alerta' => "Registro Agregado", 
                    'texto_alerta' => "Registro agregado correctamente",
                    'envio' => $envio
                );
            } else {
                $alerta = array('tipo_alerta' => 'error', 
                    'titulo_alerta' => "Error al Guardar", 
                    'texto_alerta' => "No se pudo guardar el registro, favor verificar e intentar nuevamente",
                    'envio' => $envio
                );
            }
            $this->session->set_flashdata($alerta);
            $redirect_1 = ($redirigir > 0) ? "modulo_evaluacion_desempeno/procesos/evalua_colaborador" : "modulo_evaluacion_desempeno/procesos/evaluacion_empleado";
            $redirect_2 = ($redirigir > 0) ? "modulo_evaluacion_desempeno/procesos/agregar_evaluacion_colaborador" : "modulo_evaluacion_desempeno/procesos/agregar_evaluacion_empleado";
            if ($mi_eva == 1) {
                $redirect_1 = "modulo_evaluacion_desempeno/procesos/mi_evaluacion";
                $redirect_2 = "modulo_evaluacion_desempeno/procesos/realizar_mi_evaluacion/".$empleado;
            }
            if ($tipo_accion == 1) {
                redirect($redirect_1);
            } else {
                redirect($redirect_2);
            }
        }
        if ($datas != null) {
            $data["emp_id"] = $datas["emp_id"];
        } else {
            $data["emp_id"] = 0;
        }
        $data["mi_eva"] = (isset($datas["mi_eva"]))? $datas["mi_eva"] : 0;
        $data['titulo_personal'] = "Realizar Evaluación";
        $data['periodo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo} - {DATE_FORMAT(pde_fecha_inicio,"%d-%m-%Y")} a {DATE_FORMAT(pde_fecha_fin,"%d-%m-%Y")}', '', array('pde_estado' => '1'), $datas["periodo"], '', 'pde_id', true));
        $data['empleado'] = $this->evaluacion_desempeno_model->informacion_empleado(array('emp_estado' => 1));
        $data['filtrar'] = 0;
        cargarvista($data, null, "modulo_evaluacion_desempeno/procesos/agregar_evaluacion_empleado");
    }

    public function agregar_evaluacion_colaborador() {
        satelite_validar();
                   $this->db->join('emp_empleado', 'usu_id_emp = emp_id','left');
                   $this->db->join('plz_plaza', 'emp_id_plz = plz_id','left');
        $emp_plz = $this->gsatelite->get_tabla('users',array('id' => $this->tank_auth->get_user_id(), 'emp_id_plz IS NOT NULL' => null));
        if (count($emp_plz) > 0) {
            $plz_id = $emp_plz[0]["emp_id_plz"];
            $plz_hijo = $this->gsatelite->get_tabla('plz_plaza',array('plz_id_padre' => $plz_id,"plz_estado" => 1));
            $plz_hijos = implode(',', array_column($plz_hijo,"plz_id"));
            $subordinados = ($plz_hijos != "") ? $this->gsatelite->get_tabla('emp_empleado', array("emp_id_plz IN($plz_hijos)" => NULL, 'emp_estado' => 1)) : array();
            $empleados = (count($subordinados) > 0) ? array_column($subordinados, "emp_id") : array();
            $select = (count($empleados) > 0) ? implode(',', $empleados) : 0;
        } else {
            $select = 0;
        }
        $data["emp_id"] = 0;
        $data["mi_eva"] = 0;
        $dropdown = $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo} - {DATE_FORMAT(pde_fecha_inicio,"%d-%m-%Y")} a {DATE_FORMAT(pde_fecha_fin,"%d-%m-%Y")}', '', array('pde_estado' => '1'), null, '', 'pde_id', true);
        $data['periodo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dropdown);
        $data['empleado'] = $this->evaluacion_desempeno_model->informacion_empleado(array("emp_estado" => 1, "emp_id IN( $select )" => null));
        $data['filtrar'] = 1;
        $data['titulo_personal'] = "Realizar Evaluación";
        cargarvista($data, null, "modulo_evaluacion_desempeno/procesos/agregar_evaluacion_empleado");
    }

    /**
     * @author René Castaneda
     * @since 2017-05-25
     * @return Editar Evaluación Empleado
     */
    public function editar_evaluacion_empleado($id_evaluacion_empleado = 0) {
        satelite_validar();
        if ($this->input->post()) {
            // var_dump($_POST);die();
            $redirigir = $this->input->post('filtro_redirect');
            $id_evaluacion = $this->input->post('evaluacion_puesto');
            $periodo = $this->input->post('periodo');
            $empleado = $this->input->post('empleado');
            $evaluacion_puesto = $this->input->post('id_evaluacion_puesto');
            $resultado_ids = $this->input->post('resultado_id');
            $competencia_ids = $this->input->post('competencia_id');
            $competencia_tipo = $this->input->post('competencia_tipo');
            $respuesta = $this->input->post('respuesta');
            $resultado = $this->input->post('resultado');
            $observacion = $this->input->post('observacion');
            $total_calificacion = $this->input->post('total_calificacion');
            $estado = $this->input->post('estado');
            $tipo_accion = $this->input->post('tipo_accion');
            $id_eva_empleado = $this->input->post('id_evaluacion_empleado');
            $where_rango['rae_desde <= '] = $total_calificacion;
            $where_rango['rae_hasta >='] = $total_calificacion;
            $rango = $this->gsatelite->get_campo('rae_rango_evaluacion', 'rae_id', $where_rango);
            if ($id_evaluacion > 0 && $evaluacion_puesto > 0 && $empleado > 0) {
                $array_update = array(
                    'eve_id_emp' => $empleado
                    , 'eve_id_pde' => $periodo
                    , 'eve_id_ext' => $evaluacion_puesto
                    , 'eve_id_rae' => $rango
                    , 'eve_observacion' => (trim($observacion) != '') ? trim($observacion) : null
                    , 'eve_calificacion' => $total_calificacion
                    , 'eve_estado' => $estado
                    , 'eve_usu_modificacion' => $this->tank_auth->get_user_id()
                    , 'eve_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $exito = $this->gsatelite->actualizar_array('eve_evaluacion_empleado', $array_update, array('eve_id' => $id_eva_empleado));
                for ($i = 0; $i < count($competencia_ids); $i++) {
                    if ($competencia_ids[$i] > 0 and $resultado_ids[$i] > 0 ) {
                        $update_respuesta = array(
                            'dte_id_eve' => $id_eva_empleado
                            , 'dte_id_coe' => ($competencia_ids[$i] > 0) ? $competencia_ids[$i] : null
                            , 'dte_id_pxc' => ($respuesta[$i] > 0 and $competencia_tipo[$i] == 2) ? $respuesta[$i] : null
                            , 'dte_nota' => (trim($resultado[$i])!='' > 0 and $competencia_tipo[$i] == 2) ? trim($resultado[$i]):0
                            , 'dte_respuesta' => (trim($respuesta[$i]) !='' and $competencia_tipo[$i] == 1) ? trim($respuesta[$i]) : null
                            , 'dte_estado' => 1
                            , 'dte_usu_modificacion' => $this->tank_auth->get_user_id()
                            , 'dte_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_detalle = $this->gsatelite->actualizar_array('dte_detalle_evaluacion', $update_respuesta,array('dte_id' => $resultado_ids[$i]));
                    }                    
                }
            }            
            $envio = $this->funcion_correo_2($empleado, null, $id_eva_empleado);
            if ($id_eva_empleado > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Actualizado", 'texto_alerta' => "Registro actualizado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Actualizar", 'texto_alerta' => "No se pudo actualizar el registro, favor verificar e intentar nuevamente.");
            }
            if ($envio > 0) {
                $alerta['texto_alerta'] .= ' Se envió correo de confirmación';
            } else {
                $alerta['texto_alerta'] .= ' No se pudo enviar el correo';
            }
            
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                if ($redirigir > 0) {
                    redirect('modulo_evaluacion_desempeno/procesos/evalua_colaborador');
                } else {
                    redirect('modulo_evaluacion_desempeno/procesos/evaluacion_empleado');
                }                
            } else {
                if ($redirigir > 0) {
                    redirect("modulo_evaluacion_desempeno/procesos/editar_evaluacion_emp/$id_eva_empleado");
                } else {
                    redirect("modulo_evaluacion_desempeno/procesos/editar_evaluacion_empleado/$id_eva_empleado");
                }
            }
        }
        $registro_evaluacion_empleado = $this->evaluacion_desempeno_model->verificar_empleado_evaluacion(array('eve_id'=>$id_evaluacion_empleado));
        $data['registro'] = $registro_evaluacion_empleado[0];
        $data['registro_evaluacion'] = $this->evaluacion_desempeno_model->get_datos_evaluacion_empleado(array('dte_id_eve'=>$id_evaluacion_empleado));
        $data['ponderaciones'] = $this->gsatelite->get_tabla('pon_ponderacion');
        $data['periodo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo} - {DATE_FORMAT(pde_fecha_inicio,"%Y-%m-%d")} a {DATE_FORMAT(pde_fecha_fin,"%Y-%m-%d")}', '', array('pde_estado' => '1'), $registro_evaluacion_empleado[0]['eve_id_pde'], '', 'pde_id', true));
        $data['evaluacion'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('eva_evaluacion', '{eva_nombre}', '', array('eva_id' => $registro_evaluacion_empleado[0]['ext_id_eva']), $registro_evaluacion_empleado[0]['ext_id_eva'], '', 'eva_id', true));
        $data['empleado'] = $this->evaluacion_desempeno_model->informacion_empleado(array('emp_estado' => 1));
        $data['filtrar'] = null;
        $data['titulo_personal'] = "Editar Evaluación";
        cargarvista($data);
    }

    public function editar_evaluacion_emp($id_evaluacion_empleado = 0) {
        satelite_validar();
        $registro_evaluacion_empleado = $this->evaluacion_desempeno_model->verificar_empleado_evaluacion(array('eve_id'=>$id_evaluacion_empleado));
        $data['registro'] = $registro_evaluacion_empleado[0];
        $data['registro_evaluacion'] = $this->evaluacion_desempeno_model->get_datos_evaluacion_empleado(array('dte_id_eve'=>$id_evaluacion_empleado));
        $data['ponderaciones'] = $this->gsatelite->get_tabla('pon_ponderacion');
        $data['periodo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo} - {DATE_FORMAT(pde_fecha_inicio,"%Y-%m-%d")} a {DATE_FORMAT(pde_fecha_fin,"%Y-%m-%d")}', '', array('pde_estado' => '1'), $registro_evaluacion_empleado[0]['eve_id_pde'], '', 'pde_id', true));
        $data['evaluacion'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('eva_evaluacion', '{eva_nombre}', '', array('eva_id' => $registro_evaluacion_empleado[0]['ext_id_eva']), $registro_evaluacion_empleado[0]['ext_id_eva'], '', 'eva_id', true));
        $data['empleado'] = $this->evaluacion_desempeno_model->informacion_empleado(array('emp_estado' => 1));
        $data['titulo_personal'] = "Editar Evaluación";
        $data['filtrar'] = 1;
        cargarvista($data, null, 'modulo_evaluacion_desempeno/procesos/editar_evaluacion_empleado');
    }

    /**
     * @author René Castaneda
     * @since 2017-05-25
     * @return Lectura Evaluación Empleado
     */
    public function lectura_evaluacion_empleado($id_evaluacion_empleado = 0) {
        satelite_validar();
        $registro_evaluacion_empleado = $this->evaluacion_desempeno_model->verificar_empleado_evaluacion(array('eve_id'=>$id_evaluacion_empleado));
        $data['registro'] = $registro_evaluacion_empleado[0];
        $data['registro_evaluacion'] = $this->evaluacion_desempeno_model->get_datos_evaluacion_empleado(array('dte_id_eve'=>$id_evaluacion_empleado));
        $data['ponderaciones'] = $this->gsatelite->get_tabla('pon_ponderacion');
        $data['periodo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo} - {DATE_FORMAT(pde_fecha_inicio,"%Y-%m-%d")} a {DATE_FORMAT(pde_fecha_fin,"%Y-%m-%d")}', '', array('pde_estado' => '1'), $registro_evaluacion_empleado[0]['eve_id_pde'], '', 'pde_id', true));
        $data['evaluacion'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('eva_evaluacion', '{eva_nombre}', '', array('eva_id' => $registro_evaluacion_empleado[0]['ext_id_eva']), $registro_evaluacion_empleado[0]['ext_id_eva'], '', 'eva_id', true));
        $data['empleado'] = $this->evaluacion_desempeno_model->informacion_empleado(array('emp_estado' => 1));
        $data['autogestion'] = 0;
        $data['filtrar'] = null;
        $data['titulo_personal'] = "Ver Evaluación";
        cargarvista($data);
    }

    public function read_evaluacion_empleado($id_eve = 0){
        satelite_validar();
        $reg_eva_emp = $this->evaluacion_desempeno_model->verificar_empleado_evaluacion(array('eve_id' => $id_eve));
        $data['registro'] = $reg_eva_emp[0];
        $data['registro_evaluacion'] = $this->evaluacion_desempeno_model->get_datos_evaluacion_empleado(array('dte_id_eve' => $id_eve));
        $data['ponderaciones'] = $this->gsatelite->get_tabla('pon_ponderacion');
        $data['periodo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('pde_periodo_evaluacion', '{pde_codigo} - {DATE_FORMAT(pde_fecha_inicio,"%Y-%m-%d")} a {DATE_FORMAT(pde_fecha_fin,"%Y-%m-%d")}', '', array('pde_estado' => '1'), $reg_eva_emp[0]['eve_id_pde'], '', 'pde_id', true));
        $data['evaluacion'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('eva_evaluacion', '{eva_nombre}', '', array('eva_id' => $reg_eva_emp[0]['ext_id_eva']), $reg_eva_emp[0]['ext_id_eva'], '', 'eva_id', true));
        $data['empleado'] = $this->evaluacion_desempeno_model->informacion_empleado(array('emp_estado' => 1));
        $data['autogestion'] = 0;
        $data['filtrar'] = 1;
        $data['titulo_personal'] = "Ver Evaluación";
        cargarvista($data, null, 'modulo_evaluacion_desempeno/procesos/lectura_evaluacion_empleado');
    }


    public function cargar_evaluacion()
    {
        $id_puesto = $this->input->post('puesto');
        $id_empleado = $this->input->post('id_emp');
        $periodo = $this->input->post('periodo');
        $evaluacion = "";
        $html_evaluacion = "";
        $existe = 0;
        $html_opc = '<option value=""></option>';
        if ($id_puesto > 0 and $id_empleado >0) {
            $evaluaciones = $this->evaluacion_desempeno_model->get_evaluacion_puesto(array('pto_id'=>$id_puesto,'ext_estado'=>1));
            //print_r($this->db->last_query()); die();
            $n = count($evaluaciones);
            if ($n > 0 and $n!=1) {
                $existe = 1;
                foreach ($evaluaciones as $fila) {
                    $html_opc .= '<option value="'.$fila['ext_id_eva'].'"  id_ext="'.$fila['ext_id'].'" >'.$fila['eva_nombre'].'</option>';
                }
            } else if($n==1) {
                $existe = 1;
                $evaluacion = $evaluaciones[0]['eva_nombre'];
                $html_opc .= '<option value="'.$evaluaciones[0]['ext_id_eva'].'" id_ext="'.$evaluaciones[0]['ext_id'].'"  selected >'.$evaluaciones[0]['eva_nombre'].'</option>';
            } 

        die(json_encode(array('existe'=>$existe, 'html_opc'=>$html_opc, 'html_evaluacion'=>$html_evaluacion)));
        }

    }


    public function cargar_datos_evaluacion($id_evaluacion=0) {
        $id_evaluacion = ($id_evaluacion > 0 )? $id_evaluacion : $this->input->post('evaluacion');
        $data['registros'] = $this->evaluacion_desempeno_model->get_datos_evaluacion(array('eva_id'=>$id_evaluacion));
        $data['ponderaciones'] = $this->gsatelite->get_tabla('pon_ponderacion');
        $html_evaluacion = $this->load->view('modulo_evaluacion_desempeno/procesos/datos_evaluacion', $data, true);        
        $info_datos["indicaciones"] = $data['registros'][0]["eva_indicacion"];
        $info_datos["objetivo"] = $data['registros'][0]["eva_objetivo"];
        $info_datos["anexo"] = $data['registros'][0]["eva_archivo"];
       die(json_encode(array('html_evaluacion'=>$html_evaluacion,"info_datos" => $info_datos)));
    }

    public function validar_evaluacion_empleado()
    {
        $id_puesto = ($this->input->post('puesto') > 0 )? $this->input->post('puesto'):0;
        $id_empleado = ($this->input->post('id_emp') > 0 )? $this->input->post('id_emp'):0;
        $periodo = ($this->input->post('periodo') > 0 )? $this->input->post('periodo'):0;
        $evaluacion = ($this->input->post('evaluacion') > 0 )? $this->input->post('evaluacion'):0;

        $existe = 0;
        $consulta = $this->evaluacion_desempeno_model->verificar_empleado_evaluacion(array('ext_id_eva'=>$evaluacion,'eve_id_pde'=>$periodo,'eve_id_emp'=>$id_empleado));
        //die(print_r($this->db->last_query()));
        if (count($consulta) > 0 ) {
            $existe = 1;
        }

        die(json_encode(array('existe'=>$existe)));

    }
    
    /**
     * @author Marlon Olmedo
     * @since 2020-05-18
     * @return Proceso de evaluacion a usuario propio
     * @description se carga la vista en grid las evaluaciones propias de cada usuario
      */
    public function mi_evaluacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $emp_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$this->tank_auth->get_user_id()));
            $this->evaluacion_empleado($emp_id);
        }
    }

    /**
     * @author Marlon Olmedo
     * @since 2020-05-18
     * @return Proceso de realizacion de la evaluacion a usuario propio
     * @description se carga la evaluacion que a de realizar el usuario
      */
    public function realizar_mi_evaluacion($emp_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $datos["emp_id"] = $emp_id;
            $periodo = $this->gsatelite->get_tabla('pde_periodo_evaluacion', array('pde_estado'=> 1));
            $periodo = array_column($periodo, "pde_id");
            $datos["periodo"] = end($periodo);
            $datos["mi_eva"] = 1;
            //print_r($datos["periodo"]);die();
            $this->agregar_evaluacion_empleado($datos);
        }
    }

    /**
     * @author Marlon Olmedo
     * @since 2020-05-18
     * @return Proceso de realizacion de la evaluacion a usuario propio
     * @description se carga la evaluacion que a de realizar el usuario
      */
    public function funcion_correo($emp_id = null, $puesto = null) {
        if ($puesto != null) {
            $emp_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$this->tank_auth->get_user_id()));
            $mi_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=> $emp_id))[0];
            $mi_correo = $this->gsatelite->get_campo('users', 'email', array('id'=>$this->tank_auth->get_user_id()));
            

            $where_text = "usu_id_emp IN(SELECT
                                emp_id 
                            FROM
                                emp_empleado 
                            WHERE
                                emp_id_plz IN ( SELECT plz_id FROM plz_plaza WHERE plz_id_pto = $puesto ) 
                                AND emp_id NOT IN ( $emp_id ))";
            $usuarios = $this->gsatelite->get_tabla('users', array($where_text => null));
            $asunto = "Prueba a realizar";
            $data["jefe"] = 1;
            $data["empleado"] = $mi_empleado;
            $data["plaza"] = $this->gsatelite->get_campo('plz_plaza', 'plz_nombre', array('plz_id'=>$mi_empleado["emp_id_plz"]));
            $html =  $this->load->view('modulo_evaluacion_desempeno/procesos/formato_correo', $data, true);
            
            foreach ($usuarios as $key => $value) {
                $envio = $this->gsatelite->envio_correo($mi_correo,
                                                        ($mi_empleado["emp_nombre"]." ".$mi_empleado["emp_apellido"]),
                                                        $value["email"],
                                                        $asunto,
                                                        $html);
            }
            return $envio;
        } else {
            $empleado =  $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=>$emp_id))[0];
            $plaza_id = $empleado["emp_id_plz"];

            $where_text = "usu_id_emp IN ( SELECT emp_id FROM emp_empleado WHERE emp_id_plz IN ( SELECT plz_id FROM plz_plaza WHERE plz_id IN ( SELECT plz_id_padre FROM plz_plaza WHERE plz_id = $plaza_id) ) )";

            $usuarios = $this->gsatelite->get_tabla('users', array($where_text => null))[0];

            $mi_users = $this->gsatelite->get_tabla('users', array("usu_id_emp" => $emp_id))[0];

            $data["plaza"] = $this->gsatelite->get_campo('plz_plaza', 'plz_nombre', array('plz_id'=>$plaza_id));

            $data["empleado"] = $empleado;
            $data["usuario"] = $mi_users;
            $asunto = "Realize ya mi prueba";
            $data["jefe"] = 0;
            $html =  $this->load->view('modulo_evaluacion_desempeno/procesos/formato_correo', $data, true);

            $envio = $this->gsatelite->envio_correo($mi_users["email"],
                                                        ($empleado["emp_nombre"]." ".$empleado["emp_apellido"]),
                                                        $usuarios["email"],
                                                        $asunto,
                                                        $html);

            return $envio;
        }
    }

    /**
     * @author Raul E
     * @since 2020-Dic
     * @return correo de realizacion de la evaluacion a usuarios subalternos
      */
    public function funcion_correo_2($emp_id = null, $puesto = null, $eva_id = 0) {
        $cuenta = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO', null, false, array('CUENTA'));
        if (is_null($emp_id)) {
            $mi_correo = $cuenta;// USAR EL MISMO DEL PARAMETRO PARA EVITAR ERRORES DE ENVIO
            $emp_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$this->tank_auth->get_user_id()));
            $mi_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=> $emp_id))[0];
                        $this->db->join('eva_evaluacion', 'eva_id = ext_id_eva');
            $evaluate = $this->gsatelite->get_tabla("ext_evaluacionxpuesto", array('ext_id' => $eva_id)); 
            $pla_puesto = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_pto'=> $puesto));
            $pla_padres = array_unique(array_filter(array_column($pla_puesto, 'plz_id_padre')));
            if (count($pla_padres) > 0) {
                $plz_boss = implode(',', $pla_padres);
                            $this->db->join('emp_empleado', 'usu_id_emp = emp_id');
                $emp_plzs = $this->gsatelite->get_tabla("users",array("emp_estado" => 1, "emp_id_plz IN ($plz_boss)" => null));
                $data["jefe"] = 1;
                $data["empleado"] = $mi_empleado;
                $data["evaluacion"] = $evaluate[0];
                $data["puestonombre"] = $this->gsatelite->get_campo('pto_puesto', 'pto_nombre', array('pto_id'=>$puesto));
                $data["plaza"] = $this->gsatelite->get_campo('plz_plaza', 'plz_nombre', array('plz_id'=>$mi_empleado["emp_id_plz"]));
                $html =  $this->load->view('modulo_evaluacion_desempeno/procesos/formato_correo_2', $data, true);
                $asunto = "Inicio de proceso de Evaluación de Desempeño";
                $enviados = 0;
                foreach ($emp_plzs as $key => $value) {
                    $remitente = $mi_empleado["emp_nombre"]." ".$mi_empleado["emp_apellido"];
                    $envio = $this->gsatelite->envio_correo($mi_correo, $remitente, $value["email"], $asunto, $html);
                    $enviados += $envio;
                }
                if ($enviados > 0) {
                    return 1;
                } else {
                    return 0;
                }                
            } else {
                return 0;
            }
        } else {
            $mi_correo = $cuenta;// USAR EL MISMO DEL PARAMETRO PARA EVITAR ERRORES DE ENVIO
            $sender_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$this->tank_auth->get_user_id()));
            $mi_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=> $sender_id))[0];
                        $this->db->join('pde_periodo_evaluacion', 'pde_id = eve_id_pde');
            $evaluate = $this->gsatelite->get_tabla("eve_evaluacion_empleado", array('eve_id' => $eva_id)); 
                        $this->db->join('users', 'usu_id_emp = emp_id', 'left');
            $empleado = $this->gsatelite->get_tabla("emp_empleado", array('emp_id'=>$emp_id));
                        $this->db->join('pto_puesto', 'pto_id = plz_id_pto', 'left');
            $pto_plza = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $empleado[0]['emp_id_plz']));
            $destinos = ($empleado[0]['email'] != "") ? $empleado[0]['email'] : (($empleado[0]['emp_email'] != "") ? $empleado[0]['emp_email'] : "");
            $remitente = $mi_empleado["emp_nombre"]." ".$mi_empleado["emp_apellido"];
            $data["jefe"] = 0;
            $data["plaza"] = $pto_plza[0];
            $data["empleado"] = $empleado[0];
            $data["remitente"] = $mi_empleado;
            $data["evaluacion"] = $evaluate[0];
            $periodo = $evaluate[0]['pde_codigo'];
            $html =  $this->load->view('modulo_evaluacion_desempeno/procesos/formato_correo_2', $data, true);
            $asunto = mb_convert_encoding("Resultado de Evaluación de Desempeño", "UTF-8", "auto");
            $envio = $this->gsatelite->envio_correo($mi_correo, $remitente, $destinos, $asunto, $html);
            return $envio;
        }
    }

}
