<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author René Castaneda  
 * @method Controlador de Catalogos - Evaluación de Desempeño
 */
class Catalogos extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('evaluacion_desempeno_model');
    }

    /**
    * @author René Castaneda
    * @since 2017-05-17
    * @return Mantenimiento tabla pde_periodo_evaluacion
     */
    function periodo_evaluacion() {
        satelite_validar();
        //$this->load->config('grocery_crud');
        //$this->config->set_item('grocery_crud_date_format','uk-date');
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('pde_periodo_evaluacion');
        $crud->set_subject('Período');
        $this->load->config('grocery_crud');
        $this->config->set_item('grocery_crud_date_format','uk-date');


        $columns = array(
            'pde_codigo',
            'pde_descripcion',
            'pde_fecha_inicio',
            'pde_fecha_fin',
            'pde_estado'
        );

        $display_as = array(
            'pde_codigo' => 'Código',
            'pde_descripcion' => 'Descripción',
            'pde_fecha_inicio' => 'Fecha Inicio',
            'pde_fecha_fin' => 'Fecha Fin',
            'pde_estado' => 'Estado'
        );

        $required = array(
            'pde_codigo',
            'pde_fecha_inicio',
            'pde_fecha_fin',
            'pde_estado'
        );

        $add_columns = array(
            'pde_codigo',
            'pde_descripcion',
            'pde_fecha_inicio',
            'pde_fecha_fin',
            'pde_estado',
            'pde_fecha_creacion',
            'pde_usu_creacion',
            'pde_fecha_modificacion',
            'pde_usu_modificacion'
        );

        $edit_columns = array(
            'pde_codigo',
            'pde_descripcion',
            'pde_fecha_inicio',
            'pde_fecha_fin',
            'pde_estado',
            'pde_fecha_modificacion',
            'pde_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('pde_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('pde_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('pde_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('pde_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('pde_codigo','Código','campo_unico[pde_periodo_evaluacion.pde_codigo]|required');
        $crud->unset_export();
        $crud->unset_print();
        $crud->callback_column('pde_fecha_inicio', function($value, $row) {
            return date('d-m-Y',strtotime($value));
        });
        $crud->callback_column('pde_fecha_fin', function($value, $row) {
            return date('d-m-Y',strtotime($value));
        });
        $crud->callback_field('pde_fecha_inicio', function($value, $primary_key) {
            return '<input id="field-pde_fecha_inicio" name="pde_fecha_inicio" type="text" value="'.formatear_fecha("d-m-Y", $value).'" maxlength="10" class="fecha span12 text" autocomplete="off">
            <a class="datepicker-input-clear ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only cleanb" tabindex="-1" role="button" aria-disabled="false"><span class="ui-button-text">Limpiar</span></a>
             (dd-mm-yyyy)';
        });
        $crud->callback_field('pde_fecha_fin', function($value, $primary_key) {
            return '<input id="field-pde_fecha_fin" name="pde_fecha_fin" type="text" value="'.formatear_fecha("d-m-Y", $value).'" maxlength="10" class="fecha span12 text " autocomplete="off">
            <a class="datepicker-input-clear ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only cleanb" tabindex="-1" role="button" aria-disabled="false"><span class="ui-button-text">Limpiar</span></a>
             (dd-mm-yyyy)';
        });

        $crud->callback_before_insert(function($post_array, $primary_key) {
            $post_array['pde_fecha_inicio'] = formatear_fecha("Y-m-d",$post_array['pde_fecha_inicio']);
            $post_array['pde_fecha_fin'] = formatear_fecha("Y-m-d",$post_array['pde_fecha_fin']);
            return $post_array;
        });

        $crud->callback_before_update(function($post_array,$primary_key){
            $post_array['pde_fecha_inicio'] = formatear_fecha("Y-m-d",$post_array['pde_fecha_inicio']);
            $post_array['pde_fecha_fin'] = formatear_fecha("Y-m-d",$post_array['pde_fecha_fin']);
            return $post_array;
        });

        $crud->callback_after_insert(function($post_array,$primary_key){
            $enviados = 0;
            $cuenta = $this->gsatelite->get_parametro_emp('SYS_CONFIGURACION_CORREO', null, false, array('CUENTA'));
            $emp_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
            $remite = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=> $emp_id))[0];
                        $this->db->join('plz_plaza', 'plz_id = emp_id_plz');
            $all_plzs = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1, 'plz_estado' => 1, 'plz_id_padre IS NOT NULL' => null));
            $pla_padres = array_unique(array_filter(array_column($all_plzs, 'plz_id_padre')));
            if (count($pla_padres) > 0) {
                            $this->db->where_in('emp_id_plz', $pla_padres);
                            $this->db->join('emp_empleado', 'usu_id_emp = emp_id');
                $emp_plzs = $this->gsatelite->get_tabla("users", array("emp_estado" => 1));
                $data["jefe"] = 2;
                $data["empleado"] = $remite;
                $data["evaluacion"] = $post_array;
                $data["plaza"] = $this->gsatelite->get_campo('plz_plaza', 'plz_nombre', array('plz_id' => $remite['emp_id_plz']));
                $asunto = mb_convert_encoding("Inicio de proceso de Evaluación de Desempeño", "UTF-8", "auto");
                $remitente = $remite["emp_nombre"]." ".$remite["emp_apellido"];
                $html =  $this->load->view('modulo_evaluacion_desempeno/procesos/formato_correo_2', $data, true);
                foreach ($emp_plzs as $key => $value) {
                    $enviados += $this->gsatelite->envio_correo($cuenta, $remitente, $value["email"], $asunto, $html);
                }
            }
        });

        if ($accion == 'add') {
            $crud->field_type('pde_estado', 'hidden', 1);
        } else {
            $crud->field_type('pde_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/catalogos/periodo_evaluacion/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Períodos de evaluación";
        cargarvista($data, $output);
    } //Fin mantenimiento Periodos Evaluación


    /**
    * @author René Castaneda
    * @since 2017-05-17
    * @return Mantenimiento tabla cte_categoria_evaluacion
     */
    function categoria_evaluacion() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('cte_categoria_evaluacion');
        $crud->set_subject('Categoría');

        $columns = array(
            'cte_orden',
            'cte_nombre',
            'cte_ponderacion',
            'cte_estado'
        );

        $display_as = array(
            'cte_nombre' => 'Nombre',
            'cte_ponderacion' => 'Ponderación',
            'cte_orden' => 'Orden',
            'cte_estado' => 'Estado',
            'cte_peso_maximo' => 'Peso Máximo'
        );

        $required = array(
            'cte_nombre',
            'cte_ponderacion',
            'cte_orden',
            'cte_estado'
        );

        $add_columns = array(
            'cte_nombre',
            'cte_ponderacion',
            'cte_orden',
            'cte_estado',
            'cte_peso_maximo',
            'cte_fecha_creacion',
            'cte_usu_creacion',
            'cte_fecha_modificacion',
            'cte_usu_modificacion'
        );

        $edit_columns = array(
            'cte_nombre',
            'cte_ponderacion',
            'cte_orden',
            'cte_peso_maximo',
            'cte_estado',
            'cte_fecha_modificacion',
            'cte_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        //$crud->set_relation('tie_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}', array('emp_estado' => 1));
        $crud->field_type('cte_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('cte_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('cte_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('cte_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('cte_nombre','Nombre','campo_unico[cte_categoria_evaluacion.cte_nombre]|required');
        $crud->set_rules('cte_orden','Orden','campo_unico[cte_categoria_evaluacion.cte_orden]|required');
        $crud->unset_export();
        $crud->unset_print();
        if ($accion == 'add') {
            $crud->field_type('cte_estado', 'hidden', 1);
        } else {
            $crud->field_type('cte_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }
        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/catalogos/categoria_evaluacion/read');
        }
        $output = $crud->render();
        $data['titulo_personal'] = "Categoría Evaluación";
        cargarvista($data, $output);
    } //Fin mantenimiento  Categoria Evaluación

    /**
    * @author René Castaneda
    * @since 2017-05-17
    * @return Mantenimiento tabla coe_competencia_evaluacion
     */
    function competencia_evaluacion() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('coe_competencia_evaluacion');
        $crud->set_subject('');

        $columns = array(
            'coe_codigo',
            'coe_nombre',
            'coe_id_cte',
            'coe_peso',
            'coe_estado'
        );

        $display_as = array(
            'coe_codigo' => 'Código',
            'coe_nombre' => 'Nombre',
            'coe_id_cte' => 'Categoria',
            'coe_descripcion' => 'Descripción',
            'coe_peso' => 'Peso',
            'coe_estado' => 'Estado'
        );

        $required = array(
            'coe_codigo',
            'coe_nombre',
            'coe_peso',
            'coe_id_cte',
            'coe_estado'
        );

        $add_columns = array(
            'coe_codigo',
            'coe_nombre',
            'coe_descripcion',
            'coe_id_cte',
            'coe_peso',
            'coe_estado',
            'coe_fecha_creacion',
            'coe_usu_creacion',
            'coe_fecha_modificacion',
            'coe_usu_modificacion'
        );

        $edit_columns = array(
            'coe_codigo',
            'coe_nombre',
            'coe_descripcion',
            'coe_id_cte',
            'coe_peso',
            'coe_estado',
            'coe_fecha_modificacion',
            'coe_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->set_relation('coe_id_cte', 'cte_categoria_evaluacion', '{cte_nombre}', array('cte_estado' => 1));
        $crud->field_type('coe_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('coe_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('coe_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('coe_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('coe_codigo','Código','campo_unico[coe_competencia_evaluacion.coe_codigo]|required');
        $crud->set_rules('coe_nombre','Nombre','campo_unico[coe_competencia_evaluacion.coe_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();

        if ($accion == 'add') {
            $crud->field_type('coe_estado', 'hidden', 1);
        } else {
            $crud->field_type('coe_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/catalogos/competencia_evaluacion/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Competencias";
        cargarvista($data, $output);
    } //Fin mantenimiento  Categoria Evaluación


    /**
    * @author René Castaneda
    * @since 2017-05-17
    * @return Mantenimiento tabla pon_ponderacion
     */
    function ponderacion() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('pon_ponderacion');
        $crud->set_subject('Ponderación');

        $columns = array(
            'pon_codigo',
            'pon_nombre',
            'pon_peso',
            'pon_estado'
        );

        $display_as = array(
            'pon_codigo' => 'Código',
            'pon_nombre' => 'Nombre',
            'pon_descripcion' => 'Descripción',
            'pon_peso' => 'Peso',
            'pon_estado' => 'Estado'
        );

        $required = array(
            'pon_codigo',
            'pon_nombre',
            'pon_peso',
            'pon_estado'
        );

        $add_columns = array(
            'pon_codigo',
            'pon_nombre',
            'pon_peso',
            'pon_descripcion',
            'pon_estado',
            'pon_fecha_creacion',
            'pon_usu_creacion',
            'pon_fecha_modificacion',
            'pon_usu_modificacion'
        );

        $edit_columns = array(
            'pon_codigo',
            'pon_nombre',
            'pon_peso',
            'pon_descripcion',
            'pon_estado',
            'pon_fecha_modificacion',
            'pon_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('pon_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('pon_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('pon_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('pon_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('pon_nombre','Nombre','campo_unico[pon_ponderacion.pon_nombre]|required');
        $crud->set_rules('pon_codigo','Código','campo_unico[pon_ponderacion.pon_codigo]|required');
        $crud->unset_export();
        $crud->unset_print();

        if ($accion == 'add') {
            $crud->field_type('pon_estado', 'hidden', 1);
        } else {
            $crud->field_type('pon_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/catalogos/ponderacion/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Ponderación";
        cargarvista($data, $output);
    } //Fin mantenimiento  Ponderaciones

    /**
    * @author Marlon Olmedo
    * @since 2017-05-17
    * @return Mantenimiento tabla rae_rango_evaluacion
     */
    function rango_evaluacion() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('rae_rango_evaluacion');
        $crud->set_subject('Rango Evaluación');

        $columns = array(
            'rae_nombre',
            'rae_desde',
            'rae_hasta',
            'rae_descripcion',
            'rae_estado'
        );

        $display_as = array(
            'rae_nombre' => 'Nombre',
            'rae_desde' => 'Desde',
            'rae_hasta' => 'Hasta',
            'rae_descripcion' => 'Descripcion',
            'rae_estado' => 'Estado'
        );

        $required = array(
            'rae_nombre',
            'rae_desde',
            'rae_hasta'
        );

        $add_columns = array(
            'rae_nombre',
            'rae_desde',
            'rae_hasta',
            'rae_descripcion',
            'rae_estado',
            'rae_fecha_creacion',
            'rae_usu_creacion',
            'rae_usu_modificacion',
            'rae_fecha_modificacion'
        );

        $edit_columns = array(
            'rae_nombre',
            'rae_desde',
            'rae_hasta',
            'rae_descripcion',
            'rae_estado',
            'rae_usu_modificacion',
            'rae_fecha_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        //$crud->set_relation('tie_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}', array('emp_estado' => 1));
        $crud->field_type('rae_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('rae_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('rae_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('rae_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('rae_nombre','Nombre','campo_unico[cte_categoria_evaluacion.cte_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();

        if ($accion == 'add') {
            $crud->field_type('rae_estado', 'hidden', 1);
        } else {
            $crud->field_type('rae_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            //$crud->add_action('Ver', 'minia-icon-search', 'modulo_evaluacion_desempeno/catalogos/categoria_evaluacion/read');
            $crud->unset_read();
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Rango Evaluación";
        cargarvista($data, $output);
    } //Fin mantenimiento  Categoria Evaluación


}
