<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author Mario Marquez
 * @method Controlador de Reportes - cuentas por pagar
 */
class Reportes extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->model('cuentas_pagar_model');
        $this->load->model('utm_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    public function antiguedad_saldos() {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/reportes/antiguedad_saldos');
        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['titulo_personal'] = "Antigüedad de Saldos";
        $data['clasificacion'] = $this->gsatelite->get_tabla('clp_clasificacion_proveedor',array('clp_estado'=>1));

        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_antiguedad_saldos($flag = null) {
        if ($_POST) {
            $post_array    = $this->input->post();
            $fecha_fin     = $post_array['fecha_fin'];
            $clasificacion = $post_array['clasificacion'];
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
               $provider = $post_array['proveedor'];
                if ( (is_array($provider)) && (count($provider)>0) ) {
                        $proveedor = $provider;
                    }else{
                    $proveedor = null;
                }
            }else {
                $provider = $post_array['filtro_proveedor'];
                //print_r($provider); die();
                if ($provider != '') {
                        $proveedor =explode(',', $provider);
                    }else{
                    $proveedor = null;
                }
                $fecha_fin = $post_array['filtro_fecha'];
                $clasificacion = $post_array['filtro_clasificacion'];
            }
            //print_r($provider);die();
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;
            $data['proveedor'] = "Todos";
            //Se crean las condicionales del reporte
            if (is_array($proveedor)) {
                $prov = implode(',', $proveedor);
                $where['prv_id in ('.$prov.')'] = null;
                //$proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $proveedor));
                //$nombre_proveedor = $proveedor[0]['prv_codigo'].' - '.$proveedor[0]['prv_apellido'];
                //if ($proveedor[0]['prv_tipo_pers'] == 1) {
                 //   $nombre_proveedor = $proveedor[0]['prv_codigo'].' - '.$proveedor[0]['prv_nombre']." ".$proveedor[0]['prv_apellido'];
               // }
               // $data['proveedor'] = $nombre_proveedor;
            }
            
            if ($clasificacion != '') {
                $where['clp_id'] = $clasificacion;
            }
               


            if ($fecha_fin != '') {
                $date_txt = date_format(date_create($fecha_fin),'Y-m-d');
            }else{
                $date_txt = date('Y-m-d');
            }
            $data['reporte'] = $this->cuentas_pagar_model->get_antiguedad_saldos($where,$date_txt);
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_antiguedad_saldos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('modulo_cuentas_pagar/reportes/reporte_antiguedad_saldos', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Antigüedad de saldos';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Antiguedad_Saldos_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Antiguedad_Saldos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_antiguedad_saldos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Retención de Cheques';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function cuentas_pagar_detallado() {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/reportes/cuentas_pagar_detallado');
        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['titulo_personal'] = "Reporte de cuentas a pagar detallado";
        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */
    public function reporte_cuentas_pagar_detallado($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            /* Si es consulta ajax se toman los nombres del Jquery. De lo contrario, se toman los filtros de impresión */
            $proveedor = null;
            $where = null;
            if ($flag != null) {
                $proveedor   = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $txtFechaIni = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $txtFechaFin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $proveedor   = ($post_array['filtro_proveedor'] != '') ? $post_array['filtro_proveedor'] : null;
                $txtFechaIni = ($post_array['filtro_fecha_ini'] != '' )? date('Y-m-d', strtotime($post_array['filtro_fecha_ini'])) : null;
                $txtFechaFin = ($post_array['filtro_fecha_fin'] != '')? date('Y-m-d', strtotime($post_array['filtro_fecha_fin'])) : null;
            }
            $data['proveedor'] = "Todos";
            /* Se aplican los filtros */
            $where['dpv_estado'] = 1; //solo tomar en cuenta los activos
            $where['dpv_pagado'] = 0; //solo tomar en cuenta los pendientes de pago
            if ($proveedor != null) {
                $where['prv_id'] = $proveedor;
                $proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $proveedor));
                $nombre_proveedor = $proveedor[0]['prv_codigo'] . ' - ' . $proveedor[0]['prv_apellido'];
                if ($proveedor[0]['prv_tipo_pers'] == 1) {
                    $nombre_proveedor = $proveedor[0]['prv_codigo'] . ' - ' . $proveedor[0]['prv_nombre'] . " " . $proveedor[0]['prv_apellido'];
                }
                $data['proveedor'] = $nombre_proveedor;
            }
            if ($txtFechaIni != null) {
                $where["dpv_fecha_documento >= '$txtFechaIni 00:00:00' "] = null;
            }
            if ($txtFechaFin != null) {
                $where["dpv_fecha_documento <= '$txtFechaFin 23:59:59' "] = null;
            }
            $data['reporte'] = $this->cuentas_pagar_model->get_cuentas_pagar_doc_proveedor($where);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_cuentas_pagar_detallado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_cuentas_pagar/reportes/reporte_cuentas_pagar_detallado', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Cuentas por pagar detallado';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Cuentas_Pagar_Detallado_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Cuentas_Pagar_Detallado', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_cuentas_pagar_detallado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Cuentas Pagar Detallado';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        }
    }

    public function cuentas_pagar_resumen() {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/reportes/cuentas_pagar_resumen');
        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['titulo_personal'] = "Cuentas a pagar Resumen";
        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_cuentas_pagar_resumen($flag = null) {

        if ($_POST) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $proveedor = null;
            $where = null;
            if ($flag != null) {
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $txtFechaIni = ($post_array['txtFechaIni'] != '' )? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
                $txtFechaFin = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;                

            } else {
                $proveedor = ($post_array['filtro_proveedor'] != '') ? $post_array['filtro_proveedor'] : null;
                $txtFechaIni = ($post_array['filtro_txtFechaIni'] != '' )? date('Y-m-d', strtotime($post_array['filtro_txtFechaIni'])) : null;
                $txtFechaFin = ($post_array['filtro_txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['filtro_txtFechaFin'])) : null;
            }

            $data['proveedor'] = "Todos";
            /*
             * Se aplican los filtros
             */
            if ($proveedor != null) {
                $where['prv_id'] = $proveedor;
                $proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $proveedor));
                $nombre_proveedor = $proveedor[0]['prv_codigo'].' - '.$proveedor[0]['prv_apellido'];
                if ($proveedor[0]['prv_tipo_pers'] == 1) {
                    $nombre_proveedor = $proveedor[0]['prv_codigo'].' - '.$proveedor[0]['prv_nombre'] . " " . $proveedor[0]['prv_apellido'];
                }
                $data['proveedor'] = $nombre_proveedor;
            }

            if ($txtFechaIni != null) {
                $where["DATE(dpv_fecha_documento) >= '$txtFechaIni' "] = null;
            }
            if ($txtFechaFin != null) {
                $where["DATE(dpv_fecha_documento) <= '$txtFechaFin' "] = null;
            }

            $data['reporte'] = $this->cuentas_pagar_model->get_cuentas_pagar_doc_proveedor($where, 1);
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_cuentas_pagar_resumen_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;

            $html = $this->load->view('modulo_cuentas_pagar/reportes/reporte_cuentas_pagar_resumen', $data, true);
            //echo $html; die();
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Cuentas por pagar Resumen';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Cuentas_Pagar_Resumen_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Cuentas_Pagar_Resumen', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_cuentas_pagar_resumen_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Cuentas Pagar Resumen';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

   
    public function estado_cuentas() {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/reportes/estado_cuentas');
        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['titulo_personal'] = "Estado de Cuenta Corriente";
        $this->_cargarvista($data);
    }

     /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */
    public function reporte_estado_cuentas($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $proveedor              = null;
            $where['documentos']    = null;
            $where['cheques']       = null;
            if ($flag != null) {
                $proveedor      = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $fecha_inicio   = ($post_array['fecha_ini'] != '') ? formatear_fecha('Y-m-d',$post_array['fecha_ini']) : null;
                $fecha_fin      = ($post_array['fecha_fin'] != '') ? formatear_fecha('Y-m-d', $post_array['fecha_fin']) : null;
            } else {
                $proveedor      = ($post_array['filtro_proveedor'] != '') ? $post_array['filtro_proveedor'] : null;
                $fecha_inicio   = ($post_array['filtro_inicio'] != '') ? formatear_fecha('Y-m-d', $post_array['filtro_inicio']) : null;
                $fecha_fin      = ($post_array['filtro_fin'] != '') ? formatear_fecha('Y-m-d', $post_array['filtro_fin']) : null;
            }

            /*
             * Se aplican los filtros
            */
            if ($fecha_inicio != null && $fecha_fin != null) {
                $data['fecha_inicio']                           = formatear_fecha('d-m-Y', $fecha_inicio);
                $data['fecha_fin']                              = formatear_fecha('d-m-Y', $fecha_fin);
                $where['documentos']['DATE(dpv_fecha_documento) >=']  = $fecha_inicio;
                $where['documentos']['DATE(dpv_fecha_documento) <=']  = $fecha_fin;
                $where['documentos']['dpv_estado']  = 1;
                $where['cheques']['DATE(dpv_fecha_documento) >=']               = $fecha_inicio;
                $where['cheques']['DATE(dpv_fecha_documento) <=']               = $fecha_fin;                                
                $where['estado']['che_estado =']                = 1;
                $where['estado']['dpv_estado =']                = 1;
            }
            if ($proveedor != null ){
                $where['documentos']['dpv_id_prv'] = $proveedor;
                $where['cheques']['dpv_id_prv'] = $proveedor;
                $proveedor_data = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $proveedor));                
                $nombre_proveedor = $proveedor_data[0]['prv_nombre'].' '.$proveedor_data[0]['prv_apellido'];
                if ($proveedor_data[0]['prv_tipo_pers'] == 2) {
                    $nombre_proveedor = $proveedor_data[0]['prv_apellido'];
                }
                $data['proveedor'] = $proveedor_data[0]['prv_codigo'].' - '.$nombre_proveedor;    
                $where_saldo = array(
                    'dpv_id_prv' => $proveedor,
                    'DATE(dpv_fecha_documento) < ' => $fecha_inicio,
                    'dpv_pagado' => 0                
                );
                $data['saldo_inicial']  = $this->cuentas_pagar_model->get_saldo_proveedor($where_saldo);
                //print_r($this->db->last_query()); die();
                $data['reporte']        = $this->cuentas_pagar_model->get_estado_cuentas_proveedor($where);
                //print_r($this->db->last_query()); die();
                $data['tipo_reporte']   = $tipo_reporte;
                $filename               = 'rpt_estado_cuentas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename']       = $filename;
                $data['contador']       = 0;
                $html                   = $this->load->view('modulo_cuentas_pagar/reportes/reporte_estado_cuentas', $data, true);

            } else {
                $html="";
                $proveedores    = $this->gsatelite->get_tabla("prv_proveedor", array("prv_estado" => 1) );
                $i              = 0;
                foreach ($proveedores  as $prv) {
                    $proveedor = $prv["prv_id"];
                    $where['documentos']['dpv_id_prv']  = $proveedor;
                    $where['cheques']['dpv_id_prv']     = $proveedor;
                    
                    $nombre_proveedor = $prv['prv_nombre'].' '.$prv['prv_apellido'];
                    if ($prv['prv_tipo_pers'] == 2) {
                        $nombre_proveedor = $prv['prv_apellido'];
                    }
                    $data['proveedor'] = $prv['prv_codigo'] . ' - ' . $nombre_proveedor;

                    $where_saldo = array(
                        'dpv_id_prv' => $proveedor,
                        'DATE(dpv_fecha_documento) < ' => $fecha_inicio,
                        'dpv_pagado' => 0                
                    );
                    
                    $data['saldo_inicial']  = $this->cuentas_pagar_model->get_saldo_proveedor($where_saldo);
                    //print_r($this->db->last_query());die();
                    $data['reporte']        = $this->cuentas_pagar_model->get_estado_cuentas_proveedor($where);
                    //print_r($this->db->last_query());die();
                    $data['tipo_reporte']   = $tipo_reporte;
                    $filename               = 'rpt_estado_cuentas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);  
                    $data['filename']       = $filename;
                    $data['contador']       = $i;

                    $html   .= $this->load->view('modulo_cuentas_pagar/reportes/reporte_estado_cuentas', $data, true);
             
                    $i ++;
                }
            }

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Estado de Cuenta Corriente';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $head = '<!DOCTYPE html><html><head><title>Estado de Cuenta Corriente</title></head><body><script type="text/javascript">';
                    $head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Estado de Cuenta Corriente";';
                    $head .= 'window.print();</script>';
                    $footer = '</body></html>';
                    echo $head.$reporte.$footer;die();
                    // $GLOBALS['nombre_reporte'] = 'Reporte_Cuentas_Pagar_Resumen_' . date('dmY');
                    // $this->pdf->SetMargins(10, 10, 10, 50);
                    // $this->pdf->makePdf($reporte, 'L', 'Reporte_Cuentas_Pagar_Resumen', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_cuentas_pagar_resumen_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Estado de Cuenta Corriente';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }
    
    public function pagos() {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/reportes/pagos');
        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['titulo_personal'] = "Reporte de Pagos";
        cargarvista($data);
    }
    
     /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_pagos($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();            
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $proveedor = null;
            if ($flag != null) {
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $fecha_inicio = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $proveedor = ($post_array['filtro_proveedor'] != '') ? $post_array['filtro_proveedor'] : null;
                $fecha_inicio = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }
                /*print_r($proveedor);
                print_r('<br>');
                print_r($fecha_inicio);
                print_r('<br>');
                print_r($fecha_fin);
                die();*/
            /*
             * Se aplican los filtros
             */
            if ($proveedor != null) {
                //$where['dpv_id_prv'] = $proveedor;
                //$proveedor = explode(',', $proveedor);
                //var_dump($proveedor); die();                
                //$where['dpv_id_prv'] = $proveedor;                
                //$this->db->where_in('prv_id', array($proveedor));
                $this->db->where('prv_id IN ('.$proveedor.')');
                $proveedor_data = $this->gsatelite->get_tabla('prv_proveedor');
                //print_r($proveedor_data); die();
                //$proveedor_data = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $proveedor));                                
                $nombre_proveedor = $proveedor_data[0]['prv_codigo'].' - '.$proveedor_data[0]['prv_apellido'];
                if ($proveedor_data[0]['prv_tipo_pers'] == 1) {
                    $nombre_proveedor = $proveedor_data[0]['prv_nombre'] ." ". $proveedor_data[0]['prv_apellido'];
                }
                $data['proveedor'] = $nombre_proveedor;
                $data['proveedores'] = $proveedor_data;
            }else{                 
                $proveedor_data = $this->gsatelite->get_tabla('prv_proveedor');
                $data['proveedores'] = $proveedor_data;                
            }

            if ($fecha_inicio != null && $fecha_fin != null) {
                $data['fecha_inicio'] = date('d-m-Y', strtotime($fecha_inicio));
                $data['fecha_fin'] = date('d-m-Y', strtotime($fecha_fin));
                // $where['che_fecha >='] = $fecha_inicio;
                // $where['che_fecha <='] = $fecha_fin;
            }
            //print_r($data['proveedores']); die();
            //print_r($where);
            //print_r($data['reporte']); die();            
            //print_r($this->db->last_query());die();
            // $data['where'] = $where;
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_cuentas_pagar/reportes/reporte_pagos', $data, true);
            //echo $html; die();
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Pagos';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Pagos_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Pagos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Cuentas Pagar Resumen';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function reporte_agenda_pago() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        
        if ($_POST) {
            // print_r($_POST);die();
            $post_array     = $this->input->post();
            
            $fecha_inicio   = ($post_array['txtFechaIni'] != '' )? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
            $fecha_fin      = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;
           
            $slc_proveedor  = ($post_array['slc_proveedor'] != '') ? $post_array['slc_proveedor'] : null;

            $where = array();
            if (trim($fecha_inicio) != "") {
                $where['DATE(agp_fecha_genera) >='] = date('Y-m-d', strtotime($fecha_inicio));
            }

            if (trim($fecha_fin) != "") {
                $where['DATE(agp_fecha_genera) <='] = date('Y-m-d', strtotime($fecha_fin));
            }

            if (is_numeric($slc_proveedor) && $slc_proveedor > 0) {
                $where['prv_id'] = $slc_proveedor;
            }

            $data['reporte_agenda'] = $this->cuentas_pagar_model->get_aprobacion_pagos($where);

            $tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Reporte_agenda_pago_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Agenda de Pago';
            $data['filename']           = $filename;
            $html = $this->load->view('modulo_cuentas_pagar/reportes/consultar_reporte_agenda_pago', $data, true);
          
            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();  
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Agenda de Pago';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_agenda_pago_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_agenda_pago_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $data['proveedores']         = $this->gsatelite->get_tabla("prv_proveedor",array("prv_estado" => 1));
            $data['titulo_personal']    = 'Reporte de Agenda de pago';
            cargarvista($data);
        }        
    }
    
    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     * @author Nelson Soriano
     * @since  20-03-2019
     * @param  none
     * @return Crea la vista con los filtros para la Generacion del reporte
     * Desciption: Funcion principal que genera la vista con los filtros para la generacion del reporte en  PDF / EXCEL
    **/

    public function detalle_antiguedad_saldos(){
        satelite_validar();
        $data['permisos']           = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/reportes/antiguedad_saldos');
        $data['proveedores']        = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['titulo_personal']    = "Detalle antigüedad de Saldos";
        $data['clasificacion']      = $this->gsatelite->get_tabla('clp_clasificacion_proveedor',array('clp_estado'=>1));
        $this->_cargarvista($data);
    }
     /**
     * @author Nelson Soriano
     * @since  20-03-2019
     * @param  flag  para procesar el reporte en el formato seleccionado o mostrar el preview
     * @return Crea la vista con los filtros para la Generacion del reporte
     * Desciption: Procesa el reporte en base a los parametros seleccionados por el usuario generando un preview o un formato exportable
    **/
    public function generar_reporte_det_antiguedad($es_reporte = null){
        satelite_validar();
        $f_inicio           = $this->input->post('txtFecha_desde');
        $f_fin              = $this->input->post('txtFecha_hasta');
        $p_proveedor        = $this->input->post('slcProveedores');
        $c_clasificacion    = $this->input->post('slcClasificacion');
        // configuraciones de la consulta
        $filtro_titulo      = '';
        $where['DATEDIFF(NOW(),dpv_fecha_vencimiento) >=0'] = null;
        $where['dpv_pagado'] = 0;
        $where['dpv_estado'] = 1;
        if ( ($f_inicio != '') && ($f_fin != '') ) {
           $where["date_format(dpv_fecha_documento,'%Y-%m-%d') >= "] = date_format(date_create($f_inicio),'Y-m-d');
           $where["date_format(dpv_fecha_documento,'%Y-%m-%d') <= "] = date_format(date_create($f_fin),'Y-m-d');
           $data['inicio'] = $f_inicio;
           $data['fin']    = $f_fin;
           $filtro_titulo .= 'Desde: '.$f_inicio.'<br>';
           $filtro_titulo .= 'Hasta: '.$f_fin.'<br>';
        }
        if ((is_array($p_proveedor)) && (count($p_proveedor)>0)) {
            $p_array        = implode(',', $p_proveedor);
            $where["prv_id in ($p_array) "] = null;
            $data['proveedores_ids'] = $p_proveedor;
        }
        if ($c_clasificacion != '') {
            $where["prv_id_clp"]   = $c_clasificacion;
            $data['tipo']          = $c_clasificacion;
            $filtro_titulo        .= 'Clasificacion: '.$this->gsatelite->get_campo('clp_clasificacion_proveedor','clp_nombre',array('clp_id'=>$c_clasificacion)).'<br>';
        }
        $tipo_reporte = $this->input->post('tipo_accion');
        $data['registros']    = $this->cuentas_pagar_model->get_detalle_antiguedad_saldos($where);
        $data['es_reporte']   = $es_reporte;
        $data['tipo_reporte'] = $tipo_reporte; 
        $data['decimales']    = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') != '')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $html = $this->load->view('modulo_cuentas_pagar/reportes/generar_reporte_det_antiguedad',$data,true);
        if ($es_reporte == 1) {
            switch ($tipo_reporte) {
                case 1:
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=Detalle antigüedad de Saldos".date('d-m-Y_His').".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                      <tr><th colspan='6' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                      <tr><th colspan='6' align='center' >Detalle antigüedad de Saldos</th></tr>
                      <tr><th colspan='6' align='center' >".$filtro_titulo. "</th></tr>
                      </table>";
                    echo $html; die();
                break;                    
                case 2:
                    $this->load->library('pdf');
                    $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte detalle antigüedad de saldos <br /> $filtro_titulo", 'solotitulo'=> true), true);
                    $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                    $this->pdf->makePDF($html_header.$html,'L', 'Detalle antigüedad de Saldos','Letter');
                    die();
                break;
            }
        }

        echo  json_encode(array('html'=>$html));

    }
}
