<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author Mario Marquez
 * @method Controlador de Procesos - cuentas por pagar
 */
class Procesos extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->model('cuentas_pagar_model');
        $this->load->model('utm_model');
        $this->load->model('compras_model');
        $this->load->model('contabilidad_model');
    }

    public function agenda_pagos($consulta = null) {
        satelite_validar();
        if ($this->input->post()) {
            if ($consulta != null) {
                $post_array = $this->input->post();
                $data = null;
                $proveedor = $post_array['proveedor'];
                $fecha_venc = $post_array['fecha_venc'];
                $where = null;
                if ($proveedor != '') {
                    $where['dpv_id_prv'] = $proveedor;
                }
                if ($fecha_venc != '') {
                    $where['DATE(dpv_fecha_vencimiento) <='] = date('Y-m-d', strtotime($fecha_venc));
                }
                $where['dpv_estado'] = 1;
                $where['dpv_pagado'] = 0;
                $order_by = "prv_nombre, dpv_fecha_vencimiento DESC";
                $data['formas_pago'] = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1));
                $data['agenda'] = $this->cuentas_pagar_model->get_agenda_pagos($where, $order_by);
                //die(print_r($this->db->last_query()));
                $monto_total = array_sum(array_column($data['agenda'], 'agp_apagar'));
                $html = $this->load->view('modulo_cuentas_pagar/procesos/consultar_agenda_pagos', $data, true);

                $respuesta = array('html' => $html, 'monto_total' => $monto_total);

                echo $html; //json_encode($respuesta);
                die();
            } else {
                $post_array = $this->input->post();

                $documentos = $post_array['documentos'];
                $agendas = $post_array['agendas'];
                $montos = $post_array['montoPagar'];
                $tiposPago = $post_array['tipoPagos'];
                $paramTipo = json_decode($this->gsatelite->get_parametro("SYS_FORMA_PAGO_DETALLE"),true);
                $resultado = 0;
                $aprobar = $post_array['txtpagar'];

            //    var_dump($post_array);die();

                if (count($documentos) > 0) {
                    //Se recorren los documentos
                    for ($i = 0; $i < count($documentos); $i++) {

                      if ($paramTipo['CHEQUE']==$tiposPago[$i]) {
                        $type = 1;
                      }elseif ($paramTipo['NOTA_ABONO']==$tiposPago[$i]) {
                        $type = 2;
                      }else {
                          $type = 3;
                      }

                      if ($aprobar != "") {
                        $this->guardar_aprobar($post_array);
                        break;
                        $agendas[$i] = '';
                        $montos[$i] = '';
                        $tiposPago[$i] = '';
                      }
                        /*
                         * Se verifica si la agenda es igual a cero, se ingresara
                         * y contenga ambos valores (Monto y tipo)
                         */
                        if ($agendas[$i] == 0 && $montos[$i] != '' && $tiposPago[$i] != '') {

                            $agenda_array = array(
                                'agp_id_usu_genera' => $this->tank_auth->get_user_id(),
                                'agp_id_dpv' => $documentos[$i],
                                'agp_apagar' => str_replace(',','',$montos[$i]),
                                'agp_id_frp' => $tiposPago[$i],
                                'agp_tipo' => $type,
                                'agp_fecha_genera' => date('Y-m-d H:i:s'),
                                'agp_estado_agenda' => 0,
                                'agp_estado' => 1,
                                'agp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'agp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'agp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'agp_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $resultado = $this->gsatelite->ingresar('agp_agenda_pago', $agenda_array);
                          // echo $resultado." ".$aprobar;  die();
                        }
                        /*
                         * Si la agenda es mayor a cero se actualizara y que contenga valores (Monto y tipo)
                         */ else if ($agendas[$i] > 0 && $montos[$i] != '' && $tiposPago[$i] != '') {
                            $agenda_array = array(
                                'agp_apagar' => str_replace(',','',$montos[$i]),
                                'agp_id_frp' => $tiposPago[$i],
                                'agp_tipo' => $type,
                                'agp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'agp_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $resultado = $this->gsatelite->actualizar_array('agp_agenda_pago', $agenda_array, array('agp_id' => $agendas[$i]));
                        }

                        /*
                         * De lo contrario se elimina la agenda.
                         */ else if ($agendas[$i] > 0 && $montos[$i] == '' && $tiposPago[$i] == '') {

                            $resultado = $this->gsatelite->borrado_general('agp_agenda_pago', array('agp_id' => $agendas[$i]));
                        }
                    }
                      //die();
                    $filtro_fecha = ($post_array['filtro_fecha'] != '' ) ? $post_array['filtro_fecha'] : null;
                    $filtro_proveedor = ($post_array['filtro_proveedor'] != '' ) ? $post_array['filtro_proveedor'] : null;
                    $filtro_proveedor_text = "";
                    if ($filtro_proveedor != null) {
                        $proveedor = $this->cuentas_pagar_model->get_proveedores();
                        $select = "prv_id as proveedor,CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_codigo, ' - ',prv_nombre, ' ', prv_apellido)"
                                . "WHEN prv_tipo_pers = 2 THEN CONCAT(prv_codigo, ' - ',prv_nombre) END as nombre_proveedor";

                        $proveedor = $this->cuentas_pagar_model->get_proveedores(array('prv_id' => $filtro_proveedor), null, $select);
                        $filtro_proveedor_text = $proveedor[0]['nombre_proveedor'];
                    }


                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agenda de pagos", 'texto_alerta' => "La información se proceso correctamente.");

                    $filtros = array('filtro_fecha' => $filtro_fecha, 'filtro_proveedor' => $filtro_proveedor, 'filtro_proveedor_text' => $filtro_proveedor_text);
                    //var_dump($filtros);die();
                    $this->session->set_flashdata($alerta);
                    $this->session->set_flashdata($filtros);

                    redirect('modulo_cuentas_pagar/procesos/agenda_pagos');
                }

            }
        }

        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['formas_pago'] = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1));
        $data['titulo_personal'] = "Agenda de pagos";
        $data['pagar'] = $this->gsatelite->get_parametro('SYS_CXP_AUTORIZAR_AGENDA',0);
        $this->_cargarvista($data);
    }

    public function aprobacion_agenda($consulta = null) {
        satelite_validar();
        if ($this->input->post()) {
            if ($consulta != null) {
                $post_array = $this->input->post();
                $data = null;
                $proveedor = $post_array['proveedor'];
                $tipo_pago = $post_array['tipo_pago'];
                $where = null;
                if ($proveedor != '') {
                    $where['dpv_id_prv'] = $proveedor;
                }
                if ($tipo_pago != '') {
                    $where['agp_id_frp'] = $tipo_pago;
                }
                $where['agp_estado'] = 1;
                $data['agenda'] = $this->cuentas_pagar_model->get_aprobacion_pagos($where);
                $monto_total = 0;
                foreach ($data['agenda'] as $row) {
                    if ($row['cheques_pendientes'] == 0) {
                        $monto_total += $row['agp_apagar'];
                    }
                }
                //print_r($this->db->last_query());die();
                $html = $this->load->view('modulo_cuentas_pagar/procesos/consultar_aprobacion_pagos', $data, true);

                $respuesta = array('html' => $html, 'monto_total' => $monto_total);

                echo json_encode($respuesta);
                die();
            } else {
                $post_array = $this->input->post();
                //var_dump($post_array); die();

                $agendas = (isset($post_array['agendas'])) ? $post_array['agendas'] : null;
                $conceptos = (isset($post_array['agendas'])) ? $post_array['conceptos'] : null;
                $proveedores = (isset($post_array['agendas'])) ? $post_array['proveedores'] : null;
                $montoPagar = (isset($post_array['agendas'])) ? $post_array['montoPagar'] : null;
                $aprobada = (isset($post_array['agendas'])) ? $post_array['hdnAprobarAgenda'] : null;
                $tipos_pago = (isset($post_array['agendas'])) ? $post_array['hdnTipoPago'] : null;
                $documento = (isset($post_array['agendas'])) ? $post_array['hdnDocumento'] : null;
                $frp_pago = (isset($post_array['agendas'])) ? $post_array['hdntipop'] : null;

                if (count($agendas) > 0) {
                    //Se recorren los documentos
                    for ($i = 0; $i < count($agendas); $i++) {
                        /*
                         * Se verifica si la agenda es igual a cero, se ingresara
                         * y contenga ambos valores (Monto y tipo)
                         */
                        if ($agendas[$i] != '' && $aprobada[$i] == '1') {
                            $agenda_array = array(
                                'agp_id_usu_aprueba' => $this->tank_auth->get_user_id(),
                                'agp_fecha_aprueba' => date('Y-m-d H:i:s'),
                                'agp_estado_agenda' => 1,
                                'agp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'agp_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $resultado = $this->gsatelite->actualizar_array('agp_agenda_pago', $agenda_array, array('agp_id' => $agendas[$i]));

                            if ($resultado > 0) {

                                if ($tipos_pago[$i] == 1) {
                                    $cheque_array = array(
                                        'chp_id_usu_genera' => $this->tank_auth->get_user_id(),
                                        'chp_id_dpv' => $documento[$i],
                                        'chp_id_agp' => $agendas[$i],
                                        'chp_monto' => str_replace(',', '', $montoPagar[$i]),
                                        'chp_orden' => $proveedores[$i],
                                        'chp_concepto' => $conceptos[$i],
                                        'chp_fecha' => date('Y-m-d H:i:s'),
                                        'chp_generado' => 0,
                                        'chp_estado' => 1,
                                        'chp_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'chp_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'chp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'chp_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $this->gsatelite->ingresar('chp_cheque_pendiente', $cheque_array);
                                } elseif ($tipos_pago[$i] == 2) {
                                    $nota_array = array(
                                        'ntp_id_usu_genera' => $this->tank_auth->get_user_id(),
                                        'ntp_id_dpv' => $documento[$i],
                                        'ntp_id_agp' => $agendas[$i],
                                        'ntp_monto' => str_replace(',', '', $montoPagar[$i]),
                                        'ntp_orden' => $proveedores[$i],
                                        'ntp_concepto' => $conceptos[$i],
                                        'ntp_fecha' => date('Y-m-d H:i:s'),
                                        'ntp_generado' => 0,
                                        'ntp_estado' => 1,
                                        'ntp_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'ntp_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'ntp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'ntp_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $this->gsatelite->ingresar('ntp_nota_abono_pendiente', $nota_array);
                                }elseif($tipos_pago[$i] == 3) {
                                   $otp_array = array(
                                     'otp_id_agp' => $agendas[$i],
                                     'otp_id_dpv' => $documento[$i],
                                     'otp_usu_genera' =>  $this->tank_auth->get_user_id(),
                                     'otp_id_frp' => $frp_pago[$i],
                                     'otp_monto' => str_replace(',', '', $montoPagar[$i]),
                                     'otp_orden' => $proveedores[$i],
                                     'otp_concepto' => $conceptos[$i],
                                     'otp_fecha' => date('Y-m-d H:i:s'),
                                     'otp_generado' => 0,
                                     'otp_estado' => 1,
                                     'otp_usu_creacion' =>  $this->tank_auth->get_user_id(),
                                     'otp_fecha_creacion' => date('Y-m-d H:i:s'),
                                     'otp_usu_modificacion' =>  $this->tank_auth->get_user_id(),
                                     'otp_fecha_modificacion' => date('Y-m-d H:i:s'),
                                    );

                                      $this->gsatelite->ingresar('otp_otra_forma_pgpendiente', $otp_array);
                                }
                            }
                        }
                    }

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agenda de pagos", 'texto_alerta' => "La información se proceso correctamente.");

                    $this->session->set_flashdata($alerta);
                }
                $filtro_proveedor = ($post_array['filtro_proveedor'] != '' ) ? $post_array['filtro_proveedor'] : null;

                $filtro_proveedor_text = "";
                if ($filtro_proveedor != null) {
                    $proveedor = $this->cuentas_pagar_model->get_proveedores();
                    $select = "prv_id as proveedor,CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_codigo, ' - ',prv_nombre, ' ', prv_apellido)"
                            . "WHEN prv_tipo_pers = 2 THEN CONCAT(prv_codigo, ' - ',prv_nombre) END as nombre_proveedor";

                    $proveedor = $this->cuentas_pagar_model->get_proveedores(array('prv_id' => $filtro_proveedor), null, $select);
                    $filtro_proveedor_text = $proveedor[0]['nombre_proveedor'];
                }
                $filtros = array('filtro_proveedor' => $filtro_proveedor, 'filtro_proveedor_text' => $filtro_proveedor_text);
                $this->session->set_flashdata($filtros);
                redirect('modulo_cuentas_pagar/procesos/aprobacion_agenda');
            }
        }

        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['formas_pago'] = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1));
        $data['titulo_personal'] = "Aprobación de agenda de pagos";
        $this->_cargarvista($data);
    }

    public function get_proveedores() {
        if ($this->input->post()) {
            $valorBusqueda = $this->input->post('proveedor');

            $like = array(
                "CONCAT(prv_nombre, ' ', prv_apellido)" => $valorBusqueda,
                "prv_codigo" => $valorBusqueda,
            );

            $select = "prv_id as proveedor,CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_codigo, ' - ',prv_nombre, ' ', prv_apellido)
                WHEN prv_tipo_pers = 2 THEN CONCAT(prv_codigo, ' - ',prv_apellido) END as nombre_proveedor";

            $proveedores = $this->cuentas_pagar_model->get_proveedores(array('prv_estado' => 1), $like, $select);
            //print_r($this->db->last_query());
            //var_dump($proveedores);

            echo json_encode($proveedores);
        }
    }

    public function set_agenda_pendiente() {
        satelite_validar(true);
        if ($this->input->post()) {
            $agenda_pendiente = $this->input->post("agenda");
            $resultado        = 0;

            if ((int)$agenda_pendiente == 1) {
                $agenda_array = array(
                    'agp_estado' => 0,
                    'agp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'agp_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $resultado = $this->gsatelite->actualizar_array('agp_agenda_pago', $agenda_array, array());
            } else {
                $agenda_array = array(
                    'agp_estado' => 0,
                    'agp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'agp_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $resultado = $this->gsatelite->actualizar_array('agp_agenda_pago', $agenda_array, array('agp_id'=>$agenda_pendiente));
            }

            echo $resultado;
            die();
        }
    }

    // Rafael A. Cuchilla
    // 2018-08-17

    public function otras_formas_pago ()
    {
       satelite_validar();
      if ($this->input->post()):

        $campos = $this->input->post();

        $fecha_ini = $campos['fecha_ini'];
        $fecha_fin = $campos['fecha_fin'];

        $where = null;

        if ($fecha_ini != '') {
            $where['DATE(ofp_fecha) >='] = date('Y-m-d', strtotime($fecha_ini));
        }

        if ($fecha_fin != '') {
            $where['DATE(ofp_fecha) <='] = date('Y-m-d', strtotime($fecha_fin));
        }

        $resultados = $this->cuentas_pagar_model->get_otros_pagos($where);
        $data['resultados'] =   $resultados;
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        $html = $this->load->view('modulo_cuentas_pagar/procesos/grid_otros_pagos', $data, true);
        echo $html;
        exit();

     else:
     $data['permisos'] = $this->gsatelite->get_permisos_opcion();
     $data['titulo_personal'] = "Otras Formas de Pago";
     $this->_cargarvista($data);
      endif;
    }

    public function otras_formas_pago_consolidado(){
         satelite_validar();
      if ($this->input->post()):

        $campos = $this->input->post();

        $proveedor = ($campos['proveedor'] != 'null') ? $campos['proveedor'] : array();
        $fecha_ini = $campos['fecha_ini'];
        $fecha_fin = $campos['fecha_fin'];
        $formaPago = $campos['formaPago'];

        $where = null;

        if (count($proveedor) > 0){
            $where['dpv_id_prv in('.implode(',', $proveedor).')']=null;
        }


        if ($fecha_ini != '') {
            $where['DATE(otp_fecha) >='] = date('Y-m-d', strtotime($fecha_ini));
        }

        if ($fecha_fin != '') {
            $where['DATE(otp_fecha) <='] = date('Y-m-d', strtotime($fecha_fin));
        }

        if ($formaPago != ''){
            $where['otp_id_frp']= $formaPago;
        }

        $resultados = $this->cuentas_pagar_model->get_otros_pagos_forma_consolidada($where);
        
      //print_r($this->db->last_query());die();
        //print_r($resultados);die();
        $data['resultados'] =   $resultados;
        $html = $this->load->view('modulo_cuentas_pagar/procesos/llenado_tabla_forma_pago_consolidado', $data, true);
        echo $html;
        exit();

     else:
     $data['permisos'] = $this->gsatelite->get_permisos_opcion();
     $data['titulo_personal'] = "Otras Formas de Pago";
     $this->_cargarvista($data);
      endif;
    }

    /**
     * @author: Elmer Hernandez
     * @created: 2019-10-11
     */    

    function forma_pago_consolidado(){
        satelite_validar();
        $select = null;
        $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre,prv_apellido)ELSE CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre) END]", 'proveedor', array('prv_estado' => 1), $select, null, null, true);
        $data['formas_pago'] = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1));
        $data['titulo_personal'] = "Forma de Pago consolidado";
         $this->_cargarvista($data);
    }

    /**
     * @author: Rafael A. Cuchilla
     * @created: 2018-08-17
     * @version 1.2
     * @since 22-10-2018 @author Mario Marquez
     */    
    public function agregar_otra_formapago($id = null, $ver = null) {
        satelite_validar();
        if ($this->input->post()):
            $array_post = $this->input->post();
            $codigo = $this->cuentas_pagar_model->get_codigo_otrospagos();
            $monto = ($array_post['txt_valor_monto'] != '') ? str_replace(',', '', $array_post['txt_valor_monto']) : 0;
            $monto_sujeto = ($array_post['txt_total_monto_sujeto'] != '') ? $array_post['txt_total_monto_sujeto'] : 0;
            $monto_ret = ($array_post['txt_ret_total'] != '') ? $array_post['txt_ret_total'] : 0;
            $fecha_pago = ($array_post['txtFecha'] != '') ? $array_post['txtFecha'] : date('Y-m-d');
            $forma_pago = ($array_post['slcFormapago'] != '') ? $array_post['slcFormapago'] : null;
            $id_prv = ($array_post['slcProveedor'] != '') ? $array_post['slcProveedor'] : null;
            $orden_de = ($array_post['txtOdenDe'] != '') ? $array_post['txtOdenDe'] : null;
            $concepto = ($array_post['txtConcepto'] != '') ? $array_post['txtConcepto'] : null;
            $descripciones = ($array_post['txtTablaDescripcion'] != '') ? $array_post['txtTablaDescripcion'] : null;
            $id_facturas = ($array_post['hdnFactura'] != '') ? $array_post['hdnFactura'] : null;
            $monto_facturas = ($array_post['txtTablaMonto'] != '') ? $array_post['txtTablaMonto'] : null;
            $monto_facturas_ret = ($array_post['txtTablaMontoSujeto'] != '') ? $array_post['txtTablaMontoSujeto'] : null;                       
            $monto_factu_ret_val = ($array_post['txtTablaRetencion'] != '') ? $array_post['txtTablaRetencion'] : null;
            $monto_factu_sub = ($array_post['txtTablaTotal'] != '') ? $array_post['txtTablaTotal'] : null;
            $retenciones_id = ($array_post['txtTablaRetenciones_id'] != '') ? $array_post['txtTablaRetenciones_id'] : null;
            $retenciones_porc = ($array_post['txtTablaRetenciones_porcentaje'] != '') ? $array_post['txtTablaRetenciones_porcentaje'] : null;
            $pendiente = ($array_post['txtPendiente'] != '') ? $array_post['txtPendiente'] : null;
            $tipo = $array_post['btnCrear'];
            $attfrp = $this->gsatelite->get_parametro("FRP_NTA_ANTICIPO_PROVEEDOR", 0);
            $monto_attfrp = $array_post['val_frp_att'];
            $configuracion_partida = array(
                'partida' => array(),
                'detalle_partida' => array(
                    'detalle_debe' => array(),
                    'detalle_haber' => array()
                )
            );
            $sobre_paso = $monto_sobrepasado = false;
            if ($forma_pago == $attfrp && $monto_attfrp > 0) {
                if ($monto > $monto_attfrp) {
                    $monto_sobrepasado = $monto;
                    $monto = $monto_attfrp;
                    $sobre_paso = true;
                }
            }
            $ofp_otra_forma_pago = array(
                'ofp_id_usu_genera' => $this->tank_auth->get_user_id(),
                'ofp_id_dpv' => $id_facturas[0],
                'ofp_id_frp' => $forma_pago,
                'ofp_codigo' => $codigo,
                'ofp_monto' => $monto,
                'ofp_monto_sujeto' => $monto_sujeto,
                'ofp_monto_retencion' => $monto_ret,
                'ofp_orden' => $orden_de,
                'ofp_concepto' => $concepto,
                'ofp_fecha' => date('Y-m-d', strtotime($fecha_pago)),
                'ofp_estado' => 1,
                'ofp_usu_creacion' => $this->tank_auth->get_user_id(),
                'ofp_fecha_creacion' => date('Y-m-d H:i:s'),
                'ofp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ofp_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $id_ofp = $this->gsatelite->ingresar('ofp_otra_forma_pago', $ofp_otra_forma_pago);
            //Se configura la informacion de la partida            
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 19));
            if (count($pct_concepto) > 0) {
                $concepto_partida = $pct_concepto[0]['ccp_descripcion_concepto'];
            } else {
                $concepto_partida = 'Concepto no definido';
            }
            $configuracion_partida['partida'] = array(
                'pct_id_tpd' => 'COSTO',
                'pct_concepto' => $concepto_partida . ' - '.$orden_de,
                'pct_fecha' => date('Y-m-d', strtotime($fecha_pago)),
                'pct_total' => $monto,
                'pct_codigo' => 'RC',
                'tabla_responsable' => 'ofp_otra_forma_pago',
                'registro_responsable' => $id_ofp
            );
            //NO ESTA EN USO
            //Se buscan las cuentas
            // $cuenta_debe = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', 'COSTO', array('dfp_id_prv' => $id_prv));
            $cuenta_haber = 0;
            if($forma_pago != 2){
                // $cuenta_haber = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', 'CUENTA_POR_PAGAR_CONTADO', array('dfp_id_prv' => $id_prv));
            }
            else{
                // $cuenta_haber = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_id',array('cnt_cuenta' => '1010101'));
            }            
            $n = 0;
            foreach ($id_facturas as $key) {
                if ($pendiente != null):
                    $otp_array = array(
                        'otp_id_ofp' => $id_ofp,
                        'otp_generado' => 1,
                        'otp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'otp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('otp_otra_forma_pgpendiente', $otp_array, array('otp_id' => $id));
                    $agenda = $this->gsatelite->get_campo('otp_otra_forma_pgpendiente', 'otp_id_agp', array('otp_id' => $id));
                    $this->gsatelite->actualizar_array('agp_agenda_pago', array('agp_estado' => 0), array('agp_id' => $agenda));
                endif;
                $where['dpv_estado'] = 1;
                $where['dpv_id'] = $key;
                $result = $this->utm_model->get_factura_like(null, $where);
                $abono = number_format($result[0]['dpv_monto_abono'], 4, '.', '');
                $montoT = number_format($result[0]['dpv_total'],4,'.','');
                $monto_abono = str_replace(',', '', $monto_facturas[$n]);
                $monto_abono = ($forma_pago == $attfrp && $monto_abono > $monto_attfrp) ? $monto_attfrp : $monto_abono; 
                $abono += number_format($monto_abono,4,'.','');
                $montopen = number_format(($montoT - $abono),4,'.','');
                $pagada = 0;
                if ($montopen == 0):
                    $pagada = 1;
                endif;
                $dpv_table = array(
                    'dpv_pagado' => $pagada,
                    'dpv_monto_abono' => $abono,
                    'dpv_monto_pendiente' => $montopen,
                    'dpv_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'dpv_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $dfg_table = array(
                    'dfg_id_ofp' => $id_ofp,
                    'dfg_id_dpv' => $key,
                    'dfg_concepto' => $descripciones[$n],
                    'dfg_valor' => number_format($monto_abono, 4, '.', ''),
                    'dfg_retencion' => ($monto_facturas_ret[$n] != "") ? $monto_facturas_ret[$n] : 0,
                    'dfg_retencion_calculada' =>  ($monto_factu_ret_val[$n] != "") ? $monto_factu_ret_val[$n] : 0,
                    'dfg_subtotal' => ($forma_pago==$attfrp&&str_replace(',','',$monto_factu_sub[$n])>$monto_attfrp) ? $monto_attfrp : number_format(str_replace(',', '', $monto_factu_sub[$n]), 4, '.', ''),
                    'dfg_estado' => 1,
                    'dfg_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dfg_fecha_creacion' => date('Y-m-d H:i:s'),
                    'dfg_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dfg_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $id_dfg = $this->gsatelite->ingresar('dfg_detalle_forma_pago', $dfg_table);
                $this->gsatelite->actualizar_array('dpv_documento_proveedor', $dpv_table, array('dpv_id' => $key));
                if ($forma_pago==$attfrp) {
                    $atts = $this->gsatelite->get_tabla("att_anticipo_transferencia", array("att_estado" => 1));
                    $este_abono_att = 0;
                    $new_abono_pdte = $monto_abono;
                    if ($sobre_paso && $monto_sobrepasado > 0 && $monto_sobrepasado > $monto_abono) {
                        foreach ($atts as $kas => $vas) {
                            $new_disp_attrow = $vas['att_saldo_pendiente'] - $new_abono_pdte; //SI > 0 SOBRA Y AGREGA NUEVA ROW
                            $actualizar = array(
                                'att_id_dpv' => $key, 
                                'att_abono_dpv' => ($new_abono_pdte > $vas['att_saldo_pendiente']) ? $vas['att_saldo_pendiente'] : $new_abono_pdte,
                                'att_saldo_pendiente' => ($new_abono_pdte > $vas['att_saldo_pendiente']) ? 0 : ($new_disp_attrow),
                                'att_estado' => 0,
                                'att_usu_mod' => $this->tank_auth->get_user_id(),
                                'att_fecha_mod' =>  date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('att_anticipo_transferencia', $actualizar, array('att_id' => $vas['att_id']));
                            $new_abono_pdte -= $vas['att_saldo_pendiente']; //SI > 0 AUN FALTA POR LIQUIDAR
                            if (!($new_abono_pdte > 0)) {
                                break;
                            }
                        }
                    } else {
                        foreach ($atts as $ka => $va) {
                            $new_disp_attrow = $va['att_saldo_pendiente'] - $new_abono_pdte; //SI > 0 SOBRA Y AGREGA NUEVA ROW
                            $actualizar = array(
                                'att_id_dpv' => $key, 
                                'att_abono_dpv' => ($new_abono_pdte > $va['att_saldo_pendiente']) ? $va['att_saldo_pendiente'] : $new_abono_pdte,
                                'att_saldo_pendiente' => ($new_abono_pdte > $va['att_saldo_pendiente']) ? 0 : ($new_disp_attrow),
                                'att_estado' => 0,
                                'att_usu_mod' => $this->tank_auth->get_user_id(),
                                'att_fecha_mod' =>  date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('att_anticipo_transferencia', $actualizar, array('att_id' => $va['att_id']));
                            $new_abono_pdte -= $va['att_saldo_pendiente']; //SI > 0 AUN FALTA POR LIQUIDAR
                            if ($new_disp_attrow > 0) {
                                $agrega = array(
                                    'att_id_nta' => $va['att_id_nta'],
                                    'att_saldo_inicial' => $new_disp_attrow,
                                    'att_saldo_pendiente' => $new_disp_attrow,
                                    'att_estado' => 1,
                                    'att_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'att_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'att_usu_mod' => $this->tank_auth->get_user_id(),
                                    'att_fecha_mod' => date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->ingresar('att_anticipo_transferencia', $agrega);
                            }
                            if (!($new_abono_pdte > 0)) {
                                break;
                            }
                        }
                    }
                }
                //Se agregan los detalles de la partida DEBE y HABER
                // $debe_array = array(
                //     'dpc_id_cnt' => $cuenta_debe['cnt_id'],
                //     'dpc_concepto' => 'Documento por proveedor #'. $result[0]['dpv_numero_documento'],
                //     'dpc_monto' => $monto_facturas[$n]
                // );                
                // array_push($configuracion_partida['detalle_partida']['detalle_debe'], $debe_array);
                $temp_id_ret = explode(',', $retenciones_id[$n]);
                if ($temp_id_ret[0] != ""):
                    $m = 0;
                    foreach ($temp_id_ret as $key):
                        $ret_porcentaje = explode(',', $retenciones_porc[$n]);
                        $rdp_table = array(
                            'rdp_id_dfg' => $id_dfg,
                            'rdp_id_ret' => $key,
                            'rdp_porcentaje' => $ret_porcentaje[$m],
                            'rdp_monto' => ($monto_facturas_ret[$n] * $ret_porcentaje[$m]) / 100,
                            'rdp_estado' => 1,
                            'rdp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rdp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rdp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rdp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rdp_retencion_detalle_pago', $rdp_table);
                        $m++;
                    endforeach;
                endif;
                $n++;
            }
            //  $haber_array = array(
            //         'dpc_id_cnt' => $cuenta_haber['cnt_id'],
            //         'dpc_concepto' => 'Pago de Factura',
            //         'dpc_monto' => $monto
            //     );                
            // array_push($configuracion_partida['detalle_partida']['detalle_haber'], $haber_array);            
            //Se ingresa la partida
            // $this->contabilidad_model->crear_partida($configuracion_partida);          
            /*PENDIENTE FEB/2020 NO COMPLETA EL PROCESO, NO ENVIAN DETALLE DE DEBE-HABER*/  
            // exit();
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Otras formas de pago", 'texto_alerta' => "La información se registro correctamente.");
            $this->session->set_flashdata($alerta);
            if ($pendiente != null):
                redirect('modulo_cuentas_pagar/procesos/otras_formas_pago_pendientes');
            else:
                if ($tipo == 1):
                    redirect('modulo_cuentas_pagar/procesos/agregar_otra_formapago');
                else:
                    redirect('modulo_cuentas_pagar/procesos/otras_formas_pago');
                endif;
            endif;

        else:
            $select = null;
            if ($id != null):
                $pago_pendiente = $this->cuentas_pagar_model->get_otrospagos_pendientes(array('otp_id' => $id));
                $data['pago_pendiente'] = $pago_pendiente[0];
                $documento = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $pago_pendiente[0]['otp_id_dpv']));
                $data['documento'] = $documento;
                $this->db->group_by('ret_id');
                $data['retenciones'] = $this->compras_model->get_retenciones_detalle_docProveedor(array('dxd_id_dpv' => $pago_pendiente[0]['otp_id_dpv']));
                $select = $documento[0]['dpv_id_prv'];
                $data['disable'] = 1;
            endif;
            $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre,prv_apellido)ELSE CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre) END]", 'provedor', array('prv_estado' => 1), $select, null, null, true);
            $hay_anticipo_proveedor = $this->gsatelite->get_suma("att_anticipo_transferencia", 'att_saldo_pendiente', array("att_estado" => 1));
            $data['anticipo_proveedores'] = $hay_anticipo_proveedor;
            $data['frp_nta_anticipo'] = $this->gsatelite->get_parametro("FRP_NTA_ANTICIPO_PROVEEDOR", 0);
            $data['retencion'] = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            $data['formas_pago'] = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1));
            $data['titulo_personal'] = "Agregar Otra Forma de Pago";
            if ($ver != null):
                $data['ver'] = 1;
                $this->gsatelite->cargar_vista_masterpage('modulo_cuentas_pagar/procesos/agregar_otra_formapago', $data);
            else:
                $this->_cargarvista($data);
            endif;

        endif;
    }

    function agregar_otra_forma_pago_consolidado($id = null, $ver = null){

        satelite_validar();
        $txtOrdenDe = $this->input->post('txtOdenDe');
        if ($this->input->post() && $txtOrdenDe != ''){

            $array_post = $this->input->post();
            //print_r($array_post);die();
            $codigo = $this->cuentas_pagar_model->get_codigo_otrospagos();
            $monto = ($array_post['txt_valor_monto'] != '') ? str_replace(',', '', $array_post['txt_valor_monto']) : 0;
            $monto_sujeto = ($array_post['txt_total_monto_sujeto'] != '') ? $array_post['txt_total_monto_sujeto'] : 0;
            $monto_ret = ($array_post['txt_ret_total'] != '') ? $array_post['txt_ret_total'] : 0;
            $fecha_pago = ($array_post['txtFecha'] != '') ? $array_post['txtFecha'] : date('Y-m-d');
            $forma_pago = ($array_post['slcFormapago'] != '') ? $array_post['slcFormapago'] : null;
            $id_prv = ($array_post['id_prvS'] != '') ? $array_post['id_prvS'] : null;
            $orden_de = ($array_post['txtOdenDe'] != '') ? $array_post['txtOdenDe'] : null;
            $concepto = ($array_post['txtConcepto'] != '') ? $array_post['txtConcepto'] : null;
            $descripciones = ($array_post['txtTablaDescripcion'] != '') ? $array_post['txtTablaDescripcion'] : null;
            $id_facturas = ($array_post['hdnFactura'] != '') ? $array_post['hdnFactura'] : null;
            $monto_facturas = ($array_post['txtTablaMonto'] != '') ? $array_post['txtTablaMonto'] : null;
            $monto_facturas_ret = ($array_post['txtTablaMontoSujeto'] != '') ? $array_post['txtTablaMontoSujeto'] : null;
            $monto_factu_ret_val = ($array_post['txtTablaRetencion'] != '') ? $array_post['txtTablaRetencion'] : null;
            $monto_factu_sub = ($array_post['txtTablaTotal'] != '') ? $array_post['txtTablaTotal'] : null;
            $retenciones_id = ($array_post['txtTablaRetenciones_id'] != '') ? $array_post['txtTablaRetenciones_id'] : null;
            $retenciones_porc = ($array_post['txtTablaRetenciones_porcentaje'] != '') ? $array_post['txtTablaRetenciones_porcentaje'] : null;
            $pendiente = ($array_post['txtPendiente'] != '') ? $array_post['txtPendiente'] : null;
            $tipo = $array_post['btnCrear'];
            
            $configuracion_partida = array(
                'partida' => array(),
                'detalle_partida' => array(
                    'detalle_debe' => array(),
                    'detalle_haber' => array()
                )
            );

            $ofp_otra_forma_pago = array(
                'ofp_id_usu_genera' => $this->tank_auth->get_user_id(),
                'ofp_id_dpv' => $id_prv,
                'ofp_id_frp' => $forma_pago,
                'ofp_codigo' => $codigo,
                'ofp_monto' => $monto,
                'ofp_monto_sujeto' => $monto_sujeto,
                'ofp_monto_retencion' => $monto_ret,
                'ofp_orden' => $orden_de,
                'ofp_concepto' => $concepto,
                'ofp_fecha' => date('Y-m-d', strtotime($fecha_pago)),
                'ofp_estado' => 1,
                'ofp_usu_creacion' => $this->tank_auth->get_user_id(),
                'ofp_fecha_creacion' => date('Y-m-d H:i:s'),
                'ofp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ofp_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            //print_r($ofp_otra_forma_pago);die();
            $id_ofp = $this->gsatelite->ingresar('ofp_otra_forma_pago', $ofp_otra_forma_pago);
            
            //Se configura la informacion de la partida
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 19));

            if (count($pct_concepto) > 0) {
                $concepto_partida = $pct_concepto[0]['ccp_descripcion_concepto'];
            } else {
                $concepto_partida = 'Concepto no definido';
            }


            $configuracion_partida['partida'] = array(
                'pct_id_tpd' => 'COSTO',
                'pct_concepto' => $concepto_partida . ' - '.$orden_de,
                'pct_fecha' => date('Y-m-d', strtotime($fecha_pago)),
                'pct_total' => $monto,
                'pct_codigo' => 'RC',
                'tabla_responsable' => 'ofp_otra_forma_pago',
                'registro_responsable' => $id_ofp
            );

            //Se buscan las cuentas
            $cuenta_debe = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', 'COSTO', array('dfp_id_prv' => $id_prv));
            $cuenta_haber = 0;
            if($forma_pago != 2){
                $cuenta_haber = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', 'CUENTA_POR_PAGAR_CONTADO', array('dfp_id_prv' => $id_prv));
            }
            else{
                $cuenta_haber = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_id',array('cnt_cuenta' => '1010101'));
            }
            
            $n = 0;
            foreach ($id_facturas as $key) {

                if ($pendiente != null):
                    $otp_array = array(
                        'otp_id_ofp' => $id_ofp,
                        'otp_generado' => 1,
                        'otp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'otp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('otp_otra_forma_pgpendiente', $otp_array, array('otp_id_dpv' => $key));
                endif;


                $where['dpv_estado'] = 1;
                $where['dpv_id'] = $key;

                $result = $this->utm_model->get_factura_like(null, $where);
                $abono = $result[0]['dpv_monto_abono'];
                $montoT = $result[0]['dpv_total'];

                $abono += $monto_facturas[$n];
                $montopen = $montoT - $abono;
                $pagada = 0;
                if ($montopen == 0):
                    $pagada = 1;
                endif;

                $dpv_table = array(
                    'dpv_pagado' => $pagada,
                    'dpv_monto_abono' => $abono,
                    'dpv_monto_pendiente' => $montopen,
                    'dpv_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'dpv_usu_modificacion' => $this->tank_auth->get_user_id()
                );

                $dfg_table = array(
                    'dfg_id_ofp' => $id_ofp,
                    'dfg_id_dpv' => $key,
                    'dfg_concepto' => $descripciones[$n],
                    'dfg_valor' => $monto_facturas[$n],
                    'dfg_retencion' => $monto_facturas_ret[$n],
                    'dfg_retencion_calculada' => $monto_factu_ret_val[$n],
                    'dfg_subtotal' => $monto_factu_sub[$n],
                    'dfg_estado' => 1,
                    'dfg_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dfg_fecha_creacion' => date('Y-m-d H:i:s'),
                    'dfg_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dfg_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $id_dfg = $this->gsatelite->ingresar('dfg_detalle_forma_pago', $dfg_table);
                $this->gsatelite->actualizar_array('dpv_documento_proveedor', $dpv_table, array('dpv_id' => $key));
                
                //Se agregan los detalles de la partida DEBE y HABER
                $debe_array = array(
                    'dpc_id_cnt' => $cuenta_debe['cnt_id'],
                    'dpc_concepto' => 'Documento por proveedor #'. $result[0]['dpv_numero_documento'],
                    'dpc_monto' => $monto_facturas[$n]
                );
                
                array_push($configuracion_partida['detalle_partida']['detalle_debe'], $debe_array);
                
            }
            
            $haber_array = array(
                'dpc_id_cnt' => $cuenta_haber['cnt_id'],
                'dpc_concepto' => 'Pago de Factura',
                'dpc_monto' => $monto
            );

            array_push($configuracion_partida['detalle_partida']['detalle_haber'], $haber_array);
            
            //Se ingresa la partida
            $this->contabilidad_model->crear_partida($configuracion_partida);
            
            // exit();
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Otras formas de pago", 'texto_alerta' => "La información se registro correctamente.");
            $this->session->set_flashdata($alerta);

            if ($pendiente != null):
                redirect('modulo_cuentas_pagar/procesos/forma_pago_consolidado');
            else:
                if ($tipo == 1):
                    redirect('modulo_cuentas_pagar/procesos/agregar_otra_formapago');
                else:
                    redirect('modulo_cuentas_pagar/procesos/otras_formas_pago');
                endif;
            endif;

        }else{

            $list_idche  = explode('$', $this->input->post('list_id_cheques'));
            $id_prv = $this->input->post('primerProveedorSeleccionado');
            $tipPag = $this->input->post('slcFormapago');

            foreach ($list_idche as $key => $id) {
              $select = null;
              if ($id != null):
                $pago_pendiente = $this->cuentas_pagar_model->get_otrospagos_pendientes(array('otp_id' => $id));
                $data['pago_pendiente'][$key] = $pago_pendiente[0];
                $documento = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $pago_pendiente[0]['otp_id_dpv']));
                $data['documento'] = $documento;
                $this->db->group_by('ret_id');
                $data['retenciones'] = $this->compras_model->get_retenciones_detalle_docProveedor(array('dxd_id_dpv' => $pago_pendiente[0]['otp_id_dpv']));
                $select = $documento[0]['dpv_id_prv'];
                $data['disable'] = 1;
            endif;
        }

        $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre,prv_apellido)ELSE CONCAT_WS(' ',prv_codigo, '-' ,prv_nombre) END]", 'provedor', array('prv_estado' => 1), $select, null, null, true);
        $data['retencion'] = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $data['formas_pago'] = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1));
        $data['prv'] = $this->gsatelite->get_tabla('prv_proveedor');
        $data['id_prvS']=$id_prv;
        $data['frp_id']=$tipPag;
    }
    $data['titulo_personal'] = "Agregar Forma de Pago Consolidado";
    $this->_cargarvista($data);

}

    public function otras_formas_pago_pendientes()
    {
      $data['titulo_personal'] = "Otras Formas de Pago Pendientes";
      $where = array('otp_generado' => 0,
                     'otp_estado' => 1,
                  );

      $data['pagos'] = $this->cuentas_pagar_model->get_otrospagos_pendientes($where);
      $this->_cargarvista($data);
    }

    public function anular_otra_formapago($id = null,$agp = null)
    {
      $anular = array('otp_estado' => 0,
                      'otp_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'otp_fecha_modificacion' => date('Y-m-d H:i:s')
                  );

      $registro = $this->gsatelite->actualizar_array('otp_otra_forma_pgpendiente', $anular, array('otp_id' => $id));

      $anular = array('agp_estado' => 0,
                      'agp_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'agp_fecha_modificacion' => date('Y-m-d H:i:s')
                  );

      $registro = $this->gsatelite->actualizar_array('agp_agenda_pago', $anular, array('agp_id' => $agp));

      if ($registro == 1) {
          $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Pago Pendiente Anulado", 'texto_alerta' => "El Pago pendiente fue anulado correctamente");
      } else {
          $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "No se pudo eliminar el pago.");
      }

      $this->session->set_flashdata($alerta);
      redirect('modulo_cuentas_pagar/procesos/otras_formas_pago_pendientes');
    }

    public function guardar_aprobar($datos = null)
    {
      $documentos = $datos['documentos'];
      $agendas = $datos['agendas'];
      $montos = $datos['montoPagar'];
      $tiposPago = $datos['tipoPagos'];
      $resultado = 0;
      $aprobar = $datos['txtpagar'];
      $paramTipo = json_decode($this->gsatelite->get_parametro("SYS_FORMA_PAGO_DETALLE"),true);

    for ($i=0; $i < count($documentos); $i++) {

      if ($agendas[$i] == 0 && $montos[$i] != '' && $tiposPago[$i] != '') {

        if ($paramTipo['CHEQUE']==$tiposPago[$i]) {
          $type = 1;
        }elseif ($paramTipo['NOTA_ABONO']==$tiposPago[$i]) {
          $type = 2;
        }else {
            $type = 3;
        }

          $agenda_array = array(
              'agp_id_usu_genera' => $this->tank_auth->get_user_id(),
              'agp_id_dpv' => $documentos[$i],
              'agp_apagar' => str_replace(',','',$montos[$i]),
              'agp_id_frp' => $tiposPago[$i],
              'agp_tipo' => $type,
              'agp_fecha_genera' => date('Y-m-d H:i:s'),
              'agp_estado_agenda' => 0,
              'agp_estado' => 1,
              'agp_usu_creacion' => $this->tank_auth->get_user_id(),
              'agp_fecha_creacion' => date('Y-m-d H:i:s'),
              'agp_usu_modificacion' => $this->tank_auth->get_user_id(),
              'agp_fecha_modificacion' => date('Y-m-d H:i:s'),
              'agp_id_usu_aprueba' => $this->tank_auth->get_user_id(),
              'agp_fecha_aprueba' => date('Y-m-d H:i:s'),
              'agp_estado_agenda' => 1,
              );

          $resul = $this->gsatelite->ingresar('agp_agenda_pago', $agenda_array);
//var_dump($resul);die();
          if ($resul > 0) {
            $where['dpv_id'] = $documentos[$i];
            $proveedor = $this->cuentas_pagar_model->get_info_documento($where);
            if ($proveedor[0]['prv_tipo_pers']==1) {
              $nombre_prv = $proveedor[0]['prv_nombre']." ".$proveedor[0]['prv_apellido'];
            }else {
              $nombre_prv = $proveedor[0]['prv_apellido'];
            }

               if ($type == 1) {
                   $cheque_array = array(
                       'chp_id_usu_genera' => $this->tank_auth->get_user_id(),
                       'chp_id_dpv' => $documentos[$i],
                       'chp_id_agp' => $resul,
                       'chp_monto' => str_replace(',', '', $montos[$i]),
                       'chp_orden' => $nombre_prv,
                      // 'chp_concepto' => $conceptos[$i],
                       'chp_fecha' => date('Y-m-d H:i:s'),
                       'chp_generado' => 0,
                       'chp_estado' => 1,
                       'chp_usu_creacion' => $this->tank_auth->get_user_id(),
                       'chp_fecha_creacion' => date('Y-m-d H:i:s'),
                       'chp_usu_modificacion' => $this->tank_auth->get_user_id(),
                       'chp_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $this->gsatelite->ingresar('chp_cheque_pendiente', $cheque_array);
               } elseif ($type == 2) {
                   $nota_array = array(
                       'ntp_id_usu_genera' => $this->tank_auth->get_user_id(),
                       'ntp_id_dpv' => $documentos[$i],
                       'ntp_id_agp' => $resul,
                       'ntp_monto' => str_replace(',', '', $montos[$i]),
                       'ntp_orden' => $nombre_prv,
                      // 'ntp_concepto' => $conceptos[$i],
                       'ntp_fecha' => date('Y-m-d H:i:s'),
                       'ntp_generado' => 0,
                       'ntp_estado' => 1,
                       'ntp_usu_creacion' => $this->tank_auth->get_user_id(),
                       'ntp_fecha_creacion' => date('Y-m-d H:i:s'),
                       'ntp_usu_modificacion' => $this->tank_auth->get_user_id(),
                       'ntp_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $this->gsatelite->ingresar('ntp_nota_abono_pendiente', $nota_array);
               }elseif($type == 3) {
                  $otp_array = array(
                    'otp_id_agp' => $resul,
                    'otp_id_dpv' => $documentos[$i],
                    'otp_usu_genera' =>  $this->tank_auth->get_user_id(),
                    'otp_id_frp' => $tiposPago[$i],
                    'otp_monto' => str_replace(',', '', $montos[$i]),
                    'otp_orden' => $nombre_prv,
                  //  'otp_concepto' => $conceptos[$i],
                    'otp_fecha' => date('Y-m-d H:i:s'),
                    'otp_generado' => 0,
                    'otp_estado' => 1,
                    'otp_usu_creacion' =>  $this->tank_auth->get_user_id(),
                    'otp_fecha_creacion' => date('Y-m-d H:i:s'),
                    'otp_usu_modificacion' =>  $this->tank_auth->get_user_id(),
                    'otp_fecha_modificacion' => date('Y-m-d H:i:s'),
                   );

                     $this->gsatelite->ingresar('otp_otra_forma_pgpendiente', $otp_array);
               }
           }
      }
    }

    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}
