<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author Francisco Orozco
 * @method Controlador de Catalogos - cuentas por pagar
 */
class Catalogo extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('cuentas_pagar_model');
    }

    public function proveedores($consulta = null) {
        satelite_validar();

        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->proveedores(null,array('modulo_cuentas_pagar/catalogo/proveedores','modulo_compras/catalogos/proveedores'));
        die('éxito');

        try {
            if ($consulta) {
                $post_array = $this->input->post();
                $data = null;
                $personeria = $post_array['personeria'];
                $actividad_eco = $post_array['actividad'];
                $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/proveedores');
                $where = null;
                if ($personeria != '') {
                    $where['prv_tipo_pers'] = $personeria;
                }
                if ($actividad_eco != '') {
                    $where['prv_id_acp'] = $actividad_eco;
                }

                $data['proveedores'] = $this->cuentas_pagar_model->get_proveedores($where);
                //var_dump($data['permisos']);die();
                $html = $this->load->view('modulo_cuentas_pagar/catalogo/consultar_proveedores', $data, true);

                echo $html;
                die();
            }
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/proveedores');
            $data['actividades_eco'] = $this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), null, null, null, true);
            $data['titulo_personal'] = "Mantenimiento de Proveedores";
            $this->_cargarvista($data);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function agregar_proveedor() {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->agregar_proveedor(null,array('modulo_cuentas_pagar/catalogo/proveedores','modulo_compras/catalogos/agregar_proveedor'));
        die('éxito');



        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/catalogo/proveedores', 'agregar');        
        $this->load->library('../controllers/modulo_compras/catalogos',NULL,'catalogo_compras');
        $informacion = $this->catalogo_compras->agregar_proveedor('cuentas');        
        $data['html']=$this->load->view('modulo_compras/catalogos/agregar_proveedor',$informacion, true);                        
        $this->_cargarvista($data);
    }
    
    public function editar_proveedor($prv_id){
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->editar_proveedor($prv_id,null, array('modulo_cuentas_pagar/catalogo/proveedores','modulo_compras/catalogos/editar_proveedor'));
        die('éxito');


        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/catalogo/proveedores', 'editar');
        $this->load->library('../controllers/modulo_compras/catalogos',NULL,'catalogo_compras');
        $informacion = $this->catalogo_compras->editar_proveedor($prv_id,'cuentas');
        $data['html']=$this->load->view('modulo_compras/catalogos/editar_proveedor',$informacion, true);
        $this->_cargarvista($data);
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
    

}
