<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Descripcion
 *  todos los Reportes correspondientes al módulo
 *  Controlador de para la generación de reportes - Módulo Cuentas por cobrar
 * @author:     René Castaneda
 * @version:    2017/06/02
 * @since:      2017/06/02
 * @package:    Erp Satelite
 * =================================================================================
 */

class Reportes extends CI_Controller
{

    //Constructor
    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('cuentas_cobrar_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
        $this->load->model('facturacion_model');
    }

    function index()
    {
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Cuentas por Cobrar';
            $this->_cargarvista(null, $data);
        }
    }

    public function reporte_remesas_diarias()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;

        $data['forma_pago'] = $this->gsatelite->get_dropdown('frp_forma_pago', "frp_id, frp_nombre", '', array('frp_estado' => '1'), null, '', 'frp_id', true);
        $data['tipo_pago'] = $this->gsatelite->get_dropdown('tpg_tipo_pago', 'tpg_id, tpg_nombre', '', array('tpg_estado >=' => '1'), null, '', 'tpg_id', true);
        cargarvista($data);
    }

    public function filtrar_remesas_diarias($es_reporte = 0)
    {
        $fecha_inicio             = ($this->input->post('txtFecha_desde') != '') ? date('Y-m-d', strtotime($this->input->post('txtFecha_desde'))) : '';
        $fecha_final              = ($this->input->post('txtFecha_hasta') != '') ? date('Y-m-d', strtotime($this->input->post('txtFecha_hasta'))) : '';
        $id_tpg                   = $this->input->post('id_tpg');
        $id_tipo_frp              = $this->input->post('id_tipo_frp');
        $data['txtFecha_desde']   = ($this->input->post('txtFecha_desde') != '') ? date('Y-m-d', strtotime($this->input->post('txtFecha_desde'))) : '';
        $data['txtFecha_hasta']   = ($this->input->post('txtFecha_hasta') != '') ? date('Y-m-d', strtotime($this->input->post('txtFecha_hasta'))) : '';
        $data['id_tpg']           = $this->input->post('id_tpg');
        $data['id_tipo_frp']      = $this->input->post('id_tipo_frp');

        $tipo_accion              = $this->input->post('tipo_accion');

        $data['es_reporte'] = ($es_reporte && $tipo_accion == 0) ? true : false;
        $data['periodo'] = date_format(date_create($fecha_inicio), 'd-m-Y') . ' A ' . date_format(date_create($fecha_final), 'd-m-Y');

        $data['data_remesas'] = $this->cuentas_cobrar_model->get_remesas_diarias_cxc($id_tpg, $id_tipo_frp, $fecha_inicio, $fecha_final);
        $data['count_cobros_credito'] = $this->cuentas_cobrar_model->get_count_tipo_pago($id_tpg, $id_tipo_frp, $fecha_inicio, $fecha_final);

        $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_remesas_cuentas_cobrar', $data, true);

        if ($es_reporte) {
            $filtro_titulo = ($fecha_inicio == $fecha_final) ? "De: " . date_format(date_create($fecha_inicio), 'd-m-Y') : "De: " . $data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_remesas" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='10' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='10' align='center' >Reporte remesas diarias</th></tr>
                  <tr><th colspan='10' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte Cuentas a Cobrar Detallado <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; margin-top:20px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    /**
     * @author René Castaneda
     * @since 2017-06-20
     * @return Pagos a factura detallado
     */
    public function cuentas_cobrar_detallado()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado >=' => '0'), null, null, null, true);
        $data['titulo_personal'] = "Reporte Cuentas a Cobrar Detallado";
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-06-20
     * @return filtrar reporte Pagos a factura detallado
     * @modify Nelson Soriano 14-01-2019
     * Descripcion Se agrego el filtro de vendedor al reporte
     */

    public function filtrar_cuentas_cobrar_detallado($es_reporte = 0)
    {
        satelite_validar();
        $registros        = array();
        $permisos         = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos'] = $permisos;
        $txtFecha_desde   =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta   = $this->input->post('txtFecha_hasta');
        $slcCliente       = $this->input->post('slcCliente');
        $slcVendedor      = $this->input->post('slcVendedor');

        $where['fac_estado'] = '1';
        if ($txtFecha_desde != '' and $txtFecha_hasta != '') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >='] = date_format(date_create($txtFecha_desde), 'Y-m-d');
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <='] = date_format(date_create($txtFecha_hasta), 'Y-m-d');

            if ($slcCliente > 0) {
                $where['fac_id_cli'] = $slcCliente;
            }

            if ($slcVendedor > 0) {
                $where['ven_id']    = $slcVendedor;
                $row = $this->gsatelite->get_registro('ven_vendedor', array('ven_id' => $slcVendedor));
                $data['vendedorNombre'] = $row->ven_nombre . ' ' . $row->ven_apellidos;
            }

            $registros = $this->cuentas_cobrar_model->get_cuentas_cobrar_detallado($where, array('cli_id' => 'ASC'));
            //print_r($this->db->last_query()); die();
        }
        $tipo_accion = $this->input->post('tipo_accion');
        $data['es_pdf'] = ($es_reporte && $tipo_accion == 0) ? true : false;
        $data['es_reporte'] = $es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcCliente'] = $this->input->post('slcCliente');
        $data['slcVendedor'] = $slcVendedor;
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_cuentas_cobrar_detallado', $data, true);
        if ($es_reporte) {
            $filtro_titulo = ($txtFecha_desde == $txtFecha_hasta) ? "De: " . date_format(date_create($txtFecha_desde), 'd-m-Y') : "De: " . $data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=cuenta_cobrar_detallado" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='10' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='10' align='center' >Reporte Cuentas a Cobrar Detallado</th></tr>
                  <tr><th colspan='10' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte Cuentas a Cobrar Detallado <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    /**
     * @author René Castaneda
     * @since 2017-06-20
     * @return Pagos a factura detallado
     */
    public function cuentas_cobrar_resumen()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado >=' => '0'), null, '', 'ven_id', true);
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);
        $data['titulo_personal'] = "Reporte Cuentas a Cobrar Resumen";
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-06-20
     * @return filtrar cuentas cobrar resumen (facturas)
     */

    public function filtrar_cuentas_cobrar_resumen($es_reporte = 0)
    {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos'] = $permisos;
        $txtFecha_desde =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcVendedor = $this->input->post('slcVendedor');
        $slcCliente = $this->input->post('slcCliente');
        $where['fac_estado'] = '1';
        if ($txtFecha_desde != '' and $txtFecha_hasta != '') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >='] = date_format(date_create($txtFecha_desde), 'Y-m-d');
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <='] = date_format(date_create($txtFecha_hasta), 'Y-m-d');

            if ($slcVendedor > 0) {
                $where['fac_id_ven'] = $slcVendedor;
            }
            if ($slcCliente > 0) {
                $where['fac_id_cli'] = $slcCliente;
            }
            $registros = $this->cuentas_cobrar_model->get_cuentas_cobrar_resumen($where);
            //print_r($this->db->last_query()); die();
        }
        $tipo_accion = $this->input->post('tipo_accion');
        $data['es_pdf'] = ($es_reporte && $tipo_accion == 0) ? true : false;
        $data['es_reporte'] = $es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcVendedor'] = $this->input->post('slcVendedor');
        $data['slcCliente'] = $this->input->post('slcCliente');
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_cuentas_cobrar_resumen', $data, true);
        if ($es_reporte) {
            $filtro_titulo = ($txtFecha_desde == $txtFecha_hasta) ? "De: " . date_format(date_create($txtFecha_desde), 'd-m-Y') : "De: " . $data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=cuenta_cobrar_resumen" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='5' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='5' align='center' >Reporte Cuentas a Cobrar Resumen</th></tr>
                  <tr><th colspan='5' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Cuentas a Cobrar Resumen <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    /**
     * @author René Castaneda
     * @since 2017-06-29
     * @return filtrar facturas pendientes de pago que posee un cliente
     **/
    public function aviso_cobro_cliente($cliente = 0)
    {
        $id_cliente = $cliente;
        $data['registro_cliente'] = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $cliente);
        $where['fac_id_cli'] = $id_cliente;
        $where['fac_estado'] = 1;

        $registro_factura = $this->cuentas_cobrar_model->get_datos_factura($where);
        $data['registros'] = $registro_factura;
        $html = $this->load->view('modulo_cuentas_cobrar/reportes/aviso_cobro_cliente', $data, true);

        $this->load->library('pdf');
        $html_header = $this->load->view('reporte/header', array('titulo' => "AVISO DE COBRO", 'solotitulo' => true), true);

        $this->pdf->makePDF($html_header . $html);
        die();
    }


    /**
     * @author René Castaneda
     * @since 2017-07-04
     * @return Antiguedad saldos
     */

    public function antiguedad_saldo()
    {
        satelite_validar();
        $es_jefe = false;
        $rol_jefe = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
        $roles_usuario = $this->facturacion_model->get_roles_usuario($this->tank_auth->get_user_id());
        foreach ($roles_usuario as $key => $value) {
            if ($value == $rol_jefe) {
                $es_jefe = true;
            }
        }
        $es_supervisor = $this->gsatelite->get_tabla('sup_supervisor', array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1));
        if ($es_jefe) {
            $slctd = null;
            $where = array('ven_estado >= ' => '0');
        } elseif (count($es_supervisor) > 0) {
            $slctd = null;
            $this->db->join('ven_vendedor', 'ven_id = vxs_id_ven', 'INNER');
            $vsxs = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_sup' => $es_supervisor[0]['sup_id'], 'ven_estado' => 1));
            $vendedores = (count($vsxs) > 0) ? implode(',', array_column($vsxs, 'ven_id')) : 0;
            $where = array("ven_estado >= " => '0', "ven_id IN ($vendedores)" => null);
        } else {
            $slctd = null;
            $where = array('ven_estado >= ' => '0', "ven_id_usu" => $this->tank_auth->get_user_id());
        }
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $data['tipo_cliente'] = $this->gsatelite->get_dropdown('tpc_tipo_cliente', '{tpc_nombre}', '', array('tpc_estado' => '1'), null, '', 'tpc_id', true);
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', $where, null, '', 'ven_id', true);
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);
        // $data['sucursal'] = $this->gsatelite->get_dropdown('scl_sucursal_cliente','{scl_codigo} {scl_nombre}','',array('scl_estado' => '1'),null,'','scl_id',true);//Agregado dropdwon "Sucursal" 2019-2-15
        $data['titulo_personal'] = "Reporte Antigüedad de Saldos";
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-07-04
     * @return filtrar antiguedad saldos.
     */
    public function filtrar_antiguedad_saldo($es_reporte = 0)
    {
        satelite_validar();
        $registros          = array();
        $permisos           = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos']   = $permisos;
        $slcTipoCliente     = $this->input->post('slcTipoCliente');
        $slcVendedor        = $this->input->post('slcVendedor');
        $slcCliente         = $this->input->post('slcCliente');
        $slc_proyecto       = $this->input->post('slc_proyecto');
        $slc_dias           = $this->input->post('slc_dias');
        $slcSucursal        = $this->input->post('slcSucursal');
        $txt_desde          = ($this->input->post('txt_desde') != "") ? date('Y-m-d', strtotime($this->input->post('txt_desde'))) : NULL;
        $txt_hasta          = ($this->input->post('txt_hasta') != "") ? date('Y-m-d', strtotime($this->input->post('txt_hasta'))) : NULL;
        $filtro_titulo      = '';
        $where['fac_estado'] = '1';
        $having             = null;
        if ($this->input->post()) {
            $es_jefe = false;
            $usuario = $this->tank_auth->get_user_id();
            $rol_jefe = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
            $roles_usuario = $this->facturacion_model->get_roles_usuario($usuario);
            $es_supervisor = $this->gsatelite->get_tabla('sup_supervisor', array('sup_id_usu' => $usuario, 'sup_estado' => 1));
            foreach ($roles_usuario as $key => $value) {
                if ($value == $rol_jefe) {
                    $es_jefe = true;
                }
            }
            // var_dump($es_jefe, count($es_supervisor));die();
            if ($es_jefe) {
                if ($slcVendedor > 0) {
                    $where['fac_id_ven'] = $slcVendedor;
                    $reg = $this->gsatelite->get_registro('ven_vendedor', 'ven_id', $slcVendedor);
                    if (trim($filtro_titulo) != '') {
                        $filtro_titulo .= '<br> Vendedor: ' . $reg->ven_codigo . ' ' . $reg->ven_nombre . ' ' . $reg->ven_apellidos;
                    } else {
                        $filtro_titulo .= 'Vendedor: ' . $reg->ven_codigo . ' ' . $reg->ven_nombre . ' ' . $reg->ven_apellidos;
                    }
                } else {
                    $filtro_titulo .= (trim($filtro_titulo) != '') ? '<br> Vendedor: Todos los vendedores' : 'Vendedor: Todos los vendedores';
                }
            } elseif (count($es_supervisor) > 0) {
                $this->db->join('ven_vendedor', 'ven_id = vxs_id_ven', 'inner');
                $vsxs = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_sup' => $es_supervisor[0]['sup_id'], 'ven_estado' => 1));
                $vendedores = (count($vsxs) > 0) ? implode(',', array_column($vsxs, 'ven_id')) : 0;
                $where["fac_id_ven IN ($vendedores)"] = null;
                if ($slcVendedor > 0) {
                    $where['fac_id_ven'] = $slcVendedor;
                    $reg = $this->gsatelite->get_registro('ven_vendedor', 'ven_id', $slcVendedor);
                    if (trim($filtro_titulo) != '') {
                        $filtro_titulo .= '<br> Vendedor: ' . $reg->ven_codigo . ' ' . $reg->ven_nombre . ' ' . $reg->ven_apellidos;
                    } else {
                        $filtro_titulo .= 'Vendedor: ' . $reg->ven_codigo . ' ' . $reg->ven_nombre . ' ' . $reg->ven_apellidos;
                    }
                } else {
                    $filtro_titulo .= (trim($filtro_titulo) != '') ? '<br> Vendedor: Todos los vendedores asignados' : 'Vendedor: Todos los vendedores asignados';
                }
            } else {
                $where['fac_id_ven'] = $usuario;
                $reg = $this->gsatelite->get_registro('ven_vendedor', 'ven_id', $slcVendedor);
                if (trim($filtro_titulo) != '') {
                    $filtro_titulo .= '<br> Vendedor: ' . $reg->ven_codigo . ' ' . $reg->ven_nombre . ' ' . $reg->ven_apellidos;
                } else {
                    $filtro_titulo .= 'Vendedor: ' . $reg->ven_codigo . ' ' . $reg->ven_nombre . ' ' . $reg->ven_apellidos;
                }
            }
            if ($slcCliente > 0) {
                $where['fac_id_cli'] = $slcCliente;
                $registro = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $slcCliente);
            }
            if ($slcTipoCliente > 0) {
                $where['cli_id_tpc'] = $slcTipoCliente;
                $registro = $this->gsatelite->get_registro('tpc_tipo_cliente', 'tpc_id', $slcTipoCliente);
                $filtro_titulo .= 'Tipo Cliente: ' . $registro->tpc_nombre;
            }
            if ($slcSucursal > 0) { //Agregado 2019-2-15
                $where['fac_id_scl'] = $slcSucursal;
                $registro = $this->gsatelite->get_registro('scl_sucursal_cliente', 'scl_id', $slcSucursal);
            }
            if ($slc_proyecto > 0) {
                $where['fac_id_pcl'] = $slc_proyecto;
            }
            if ($slc_dias != "") {
                switch ($slc_dias) {
                    case 0:
                        $having['sin_vencer >'] = 0;
                        break;
                    case 30:
                        $having['rango1 >'] = 0;
                        break;
                    case 60:
                        $having['rango2 >'] = 0;
                        break;
                    case 90:
                        $having['rango3 >'] = 0;
                        break;
                    case 120:
                        $having['rango4 >'] = 0;
                        break;
                    case 121:
                        $having['restantes >'] = 0;
                        break;
                }
            } else {
                $having['fac_monto_pendiente >'] = 0;
            }
            if (trim($txt_hasta) != NULL) {
                $where['DATE(fac_fecha_fact) <='] = $txt_hasta;
            } else {
                $txt_hasta = "";
            }
            $registros = $this->cuentas_cobrar_model->get_cuentas_antiguedad_saldo($where, $having, $txt_desde, $txt_hasta);
        }
        $data['es_reporte']     = $es_reporte;
        $data['slcTipoCliente'] = $this->input->post('slcTipoCliente');
        $data['slcVendedor']    = $this->input->post('slcVendedor');
        $data['slcCliente']     = $this->input->post('slcCliente');
        $data['slcSucursal']    = $this->input->post('slcSucursal'); //Agregado 2019-2-15
        $data['slc_proyecto']   = $this->input->post('slc_proyecto');
        $data['slc_dias']       = $this->input->post('slc_dias');
        $data['txt_desde']      = $this->input->post('txt_desde');
        $data['txt_hasta']      = $this->input->post('txt_hasta');

        $data['registros'] = $registros;
        if ($slc_dias != "" && $slc_dias >= 0) {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_antiguedad_saldo_dias', $data, true);
        } else {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_antiguedad_saldo', $data, true);
        }

        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=antiguedad_saldos" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='9' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='9' align='center' >Reporte Antigüedad de Saldos</th></tr>
                  <tr><th colspan='9' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Antigüedad de saldos <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" width = "100%" style="font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }


    /**
     * @author René Castaneda
     * @since 2017-07-05
     * @return Pagos a resumen
     */
    public function cuentas_cobrar_resumen_direccion()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['cobrador'] = $this->cuentas_cobrar_model->select_cobrador(array('cob_estado >=' => '0')); //'emp_estado >=' => '0',
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado >=' => '0'), null, '', 'ven_id', true);
        $data['municipio'] = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1), null, '', 'mun_id', true);
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);
        $data['titulo_personal'] = "Reporte Cuentas a Cobrar por Dirección";
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-07-05
     * @return filtrar cuentas cobrar resumen (facturas)
     */

    public function filtrar_cuentas_cobrar_resumen_direccion($es_reporte = 0)
    {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_resumen_direccion');
        $data['permisos'] = $permisos;
        $txtFecha_desde =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcVendedor = $this->input->post('slcVendedor');
        $slcCliente = $this->input->post('slcCliente');
        $slcCobrador = $this->input->post('slcCobrador');
        $slcMunicipio = $this->input->post('slcMunicipio');
        $where['fac_estado'] = '1';
        if ($txtFecha_desde != '' and $txtFecha_hasta != '') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >='] = date_format(date_create($txtFecha_desde), 'Y-m-d');
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <='] = date_format(date_create($txtFecha_hasta), 'Y-m-d');
            if ($slcVendedor > 0) {
                $where['fac_id_ven'] = $slcVendedor;
            }
            if ($slcCliente > 0) {
                $where['fac_id_cli'] = $slcCliente;
            }
            if ($slcCobrador > 0) {
                $where['abc_id_cob'] = $slcCobrador;
            }
            if ($slcMunicipio > 0) {
                $where['mun_id'] = $slcMunicipio;
            }
            $registros = $this->cuentas_cobrar_model->get_cuentas_cobrar_direcciones($where);
        }
        $data['es_reporte'] = $es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcVendedor'] = $this->input->post('slcVendedor');
        $data['slcCliente'] = $this->input->post('slcCliente');
        $data['slcCobrador'] = $this->input->post('slcCobrador');
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_cuentas_cobrar_resumen_direccion', $data, true);
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde == $txtFecha_hasta) ? "De: " . date_format(date_create($txtFecha_desde), 'd-m-Y') : "De: " . $data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=cuenta_cobrar_direccion" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='9' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='9' align='center' >Reporte Cuentas a Cobrar por Dirección</th></tr>
                  <tr><th colspan='9' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Cuentas a Cobrar por Dirección <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    /**
     * @author René Castaneda
     * @since 2017-06-19
     * @return facturas estado de cuenta
     * @modify Nelson Soriano 2019-01-14
     * Dewscripcion: se agrego filtro de vendedor
     * @modify Raul Escalante 2019-02-16
     * Descripcion: se agrego filtro de sucursal
     */
    public function estado_cuenta_corriente($mostrar_columnas = 0)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data["mostrar_columnas"] = $mostrar_columnas;
        $data['permisos'] = $permisos;
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);
        $data['tipo_cliente'] = $this->gsatelite->get_dropdown('tpc_tipo_cliente', '{tpc_nombre}', '', array('tpc_estado' => '1'), null, '', 'tpc_id', true);
        $data['titulo_personal'] = "Estado de Cuenta Cliente";
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado >=' => '0'), null, null, null, true);
        cargarvista($data, null, "modulo_cuentas_cobrar/reportes/estado_cuenta_corriente");
    }

    /**
     * @author René Castaneda
     * @since 2017-06-19
     * @return filtrar facturas estado de cuenta
     * @modify Nelson Soriano
     * descripcion: Se agrego filtro de vendedor
     * @modify Raul Escalante 2019-2-16
     * descripcion: Se agrego filtro de sucursal 
     **/
    public function filtrar_estado_cuenta_corriente($es_reporte = 0)
    {
        satelite_validar();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');

        $registros              = array();
        $permisos               = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos']       = $permisos;
        $txtFecha_desde         = $this->input->post('txtFecha_desde');
        $txtFecha_hasta         = $this->input->post('txtFecha_hasta');
        $slcCliente_post        = $this->input->post('slcCliente');
        $slcTipoCliente         = $this->input->post('slcTipoCliente');
        $slc_forma_facturacion  = $this->input->post('slc_forma_facturacion');
        $slcSucursal            = $this->input->post('slcSucursal');
        $slcVendedor            = ($this->input->post('slcVendedor') != '') ? $this->input->post('slcVendedor') : null;
        $slcCliente             = "";
        $tif_nota_credito   = $this->gsatelite->get_parametro('SYS_ID_TIPO_FACTURA_NOTA_CREDITO', 0);
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $not_cred = (isset($tipo_factura['NOTA CREDITO'])) ? $tipo_factura['NOTA CREDITO'] : 0;
        $not_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
        $mostrar_columnas       = ($this->input->post('mostrar_columnas') != '') ? $this->input->post('mostrar_columnas') : 0;
        $data['mostrar_columnas'] = $mostrar_columnas;
        $vista_reporte = ($mostrar_columnas) ? 'filtrar_estado_cuenta_corriente_maya' : 'filtrar_estado_cuenta_corriente';
        $slc_estado_cliente  = (is_numeric($this->input->post('slc_estado_cliente'))) ? $this->input->post('slc_estado_cliente') : 1;
        $estado_clientes = ($slc_estado_cliente) ? " (Cli. Activos)" : " (Cli. Inactivos)";
        $where['fac_estado !='] = '0';
        $where['cli_estado'] = "$slc_estado_cliente";
        if (is_array($slcCliente_post)) {
            if (count($slcCliente_post) > 0) {
                $slcCliente =  implode(",", $slcCliente_post);
            } else {
                $slcCliente = "";
            }
        } else {
            if ($slcCliente_post != "null") {
                $slcCliente = $slcCliente_post;
            } else {
                $slcCliente = "";
            }
        }
        if ($txtFecha_desde != '' and $txtFecha_hasta != '') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >='] = formatear_fecha('Y-m-d', $txtFecha_desde);
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <='] = formatear_fecha('Y-m-d', $txtFecha_hasta);
            $fecha_inicio = formatear_fecha('Y-m-d', $txtFecha_desde);
            if ($slcCliente != "") {
                $where['fac_id_cli in (' . $slcCliente . ')'] = null;
            }
            if ($slcTipoCliente > 0) {
                $where['cli_id_tpc'] = $slcTipoCliente;
            }
            $flag_masiva = "";
            if ($slc_forma_facturacion == 1) {
                $where['fac_generacion_masiva'] = $slc_forma_facturacion;
                $flag_masiva = " AND f2.fac_generacion_masiva = '1'";
            } elseif ($slc_forma_facturacion == 2) {
                $flag_masiva = " AND f2.fac_generacion_masiva IS NULL";
                $where['fac_generacion_masiva'] = NULL;
            }
            if ($slcVendedor) {
                $where['ven_id'] = $slcVendedor;
            }
            if ($slcSucursal != '') { //Agregado 2019-16-2           
                $where['scl_id'] = $slcSucursal;
            }
            if (/* $tif_nota_credito > 0 */$not_cred > 0 || $not_remi > 0) {
                // $where['fac_id_tif != '] = $tif_nota_credito;
                $where["fac_id_tif NOT IN ( $not_cred, $not_remi ) "] = null;
            }
            $abono_hasta = formatear_fecha('Y-m-d', $txtFecha_hasta);
            $registros = $this->cuentas_cobrar_model->get_estado_cuenta_cliente($where, array('cli_id' => 'ASC'), $fecha_inicio, $flag_masiva, $abono_hasta);
            // var_dump($this->db->last_query());die(); 
        }


        $data['es_reporte']              = $es_reporte;
        $data['txtFecha_desde']          = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta']          = $this->input->post('txtFecha_hasta');
        $data['slcCliente']              = $slcCliente;
        $data['slcTipoCliente']          = $this->input->post('slcTipoCliente');
        $data['slcVendedor']             = $slcVendedor;
        $data['slc_forma_facturacion']   = $this->input->post('slc_forma_facturacion');
        $data['slc_estado_cliente']      = $slc_estado_cliente;
        $data['periodo']        = formatear_fecha('d-m-Y', $txtFecha_desde) . ' A ' . formatear_fecha('d-m-Y', $txtFecha_hasta);
        $data['registros']      = $registros;
        $html                   = $this->load->view('modulo_cuentas_cobrar/reportes/' . $vista_reporte, $data, true);
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde == $txtFecha_hasta) ? "De: " . formatear_fecha('d-m-Y', $txtFecha_desde) : "De: " . $data['periodo'] . $estado_clientes;
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=estado_cuenta_corriente" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                $colspan_ = ($mostrar_columnas) ? 7 : 5;
                echo "<table border='0'>
                  <tr><th colspan='$colspan_' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='$colspan_' align='center' >Estado de Cuenta Corriente</th></tr>
                  <tr><th colspan='$colspan_' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte de Estado de Cuenta Corriente <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:7.5px;"', $html);
                $this->pdf->makePDF($html_header . str_replace('font-size: 14px;', 'font-size: 10px;', $html), 'L');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    /**
     * @author Habby Lovo
     * @since 2017-08-23
     * @return reporte de ingresos por categoria
     */
    public function ingreso_categoria()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $this->load->model('facturacion_model');
        $select = '';
        $gestor_cobros_drop = $this->facturacion_model->get_cobrador(array('cob_estado >=' => 0));
        foreach ($gestor_cobros_drop as $key) {
            $select .= '<option value="' . $key['cob_id'] . '">' . $key['cob_codigo'] . ' - ' . trim(($key['cob_nombre'] . ' ' . $key['cob_apellido'])) . '</option>';
        }
        $data['cobrador'] = $select;

        $data['titulo_personal'] = 'Reporte de ingresos por categoria';
        cargarvista($data);
    }

    public function filtrar_ingreso_categoria($es_reporte = 0)
    {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('ingreso_categoria');
        $data['permisos'] = $permisos;
        $txtFecha_desde =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcCobrador = $this->input->post('slcCobrador');
        $slcCategoria = $this->input->post('slcCategoria');
        //$where['fac_estado'] = '1';
        if ($txtFecha_desde != '' and $txtFecha_hasta != '') {
            $where['date_format(abc_fecha,"%Y-%m-%d") >= '] = date_format(date_create($txtFecha_desde), 'Y-m-d');
            $where['date_format(abc_fecha,"%Y-%m-%d") <= '] = date_format(date_create($txtFecha_hasta), 'Y-m-d');

            if ($slcCobrador > 0) {
                $where['cob_id'] = $slcCobrador;
            }
            if ($slcCategoria > 0) {
                $where['art_id_tia'] = $slcCategoria;
            }

            $registros = $this->cuentas_cobrar_model->get_prorrateo($where);
            // var_dump($this->db->last_query()); die();
        }
        $data['es_reporte'] = $es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcCobrador'] = $slcCobrador;
        $data['slcCategoria'] = $slcCategoria;
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_ingreso_categoria', $data, true);

        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde == $txtFecha_hasta) ? "De: " . date_format(date_create($txtFecha_desde), 'd-m-Y') : "De: " . $data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=cuenta_cobrar_detallado" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='4' align='center' >Reporte de ingresos por categoría</th></tr>
                  <tr><th colspan='4' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte de ingresos por categoría  <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    public function consultar_categoria()
    {
        $categoria = $this->input->post('categoria');
        $result = $this->cuentas_cobrar_model->get_categoria_like($categoria);
        echo json_encode($result);
    }

    public function pruebas()
    {

        die("ñoñoño, áéíóú");
        //exec('cd C:\wamp64\bin\mysql\mysql5.7.14\bin\mysqldump.exe');
        //exec('mysqldump --user=root --password=rootroot --host=localhost cuca20042017 > C:/wamp64/www/erp_satelite/midumpfile.sql');
        //die('llego');

        exec('C:\wamp64\bin\mysql\mysql5.7.14\bin\mysqldump -uroot -prootroot -h127.0.0.1 cuca20042017 > C:\wamp64\www\erp_satelite\midumpfile.sql');
        die('llego');

        //exec('mysqldump -P 3306 -h [ip_address] -u [uname] -p[pass] db_name  C:/wamp64/www/erp_satelite/midumpfile.sql');
        //die('llego');

        $filename = 'database_backup_' . date('G_a_m_d_y') . '.sql';

        $result = exec('mysqldump cuca20042017 --password=rootroot --user=root --single-transaction >C:/wamp64/www/erp_satelite/' . $filename, $output);

        if ($output == '') {/* no output is good */
            echo "no!!!!";
        } else {/* we have something to log the output here*/
        }
    }


    /**
     * @author Francisco Orozco
     * @since 2018-05-07
     * @return reporte de ingresos por categoria
     * @modify Raul Escalante 2019-02-18
     * Descripcion: se agrego filtro de sucursal
     */
    public function estado_cuenta_corriente_cliente()
    {
        satelite_validar();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        if ($_POST) {
            $post_array     = $this->input->post();
            $mostrar = array();
            $fecha_inicio   = ($post_array['txtFechaIni'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaIni']) : null;
            $fecha_fin      = ($post_array['txtFechaFin'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaFin']) : null;
            $cliente        = ($post_array['txtcliente'] != '') ? $post_array['txtcliente'] : null;
            $vendedor       = ($post_array['txtvendedor'] != '') ? $post_array['txtvendedor'] : null;
            $sucursal       = ($post_array['txtsucursal'] != '') ? $post_array['txtsucursal'] : null;
            $estado_cliente = ($post_array['slc_estado'] != '') ? $post_array['slc_estado'] : null;
            $estado_cliente = ($estado_cliente == 2) ? 0 : $estado_cliente;
            $slc_tipo_pago  = ($post_array['slc_tipo_pago'] != '') ? $post_array['slc_tipo_pago'] : null;
            $clientes       = $this->cuentas_cobrar_model->antiguedad_saldo_cliente($cliente, $vendedor, $sucursal, $estado_cliente, $fecha_inicio, $fecha_fin, $slc_tipo_pago);
            foreach ($clientes as $key => $value) {
                if (array_key_exists($value['id'], $mostrar)) {
                    $mostrar[$value['id']]['contador']++;
                    $mostrar[$value['id']]['saldo_incial'] += $value['Balance incial'];
                } else {
                    $mostrar[$value['id']]['contador'] = 1;
                    $mostrar[$value['id']]['saldo_incial'] = $value['Balance incial'];
                }
            }
            $data['clientes'] = $clientes;
            $data['mostrar'] = $mostrar;
            $tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename               = 'Reporte_estado_cuenta_corriente_cliente_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']         = 'Reporte de estado de cuenta corriente cliente';
            $data['filename']       = $filename;
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/consultar_estado_cuenta_corriente_cliente', $data, true);

            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Estado de Cuenta Corriente Cliente';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_estado_cuenta_corriente_cliente_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_estado_cuenta_corriente_cliente_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $data['tipos_pago']         = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1));
            $data['titulo_personal']    = 'Reporte de estado de cuenta corriente cliente';
            cargarvista($data);
        }
    }

    public function get_proyectos_cliente()
    {
        $cliente        = $this->input->post("cliente");
        $select         = '<option value=""></option>';
        $proyectos      = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $cliente));
        foreach ($proyectos as $key) {
            $select .= '<option value="' . $key["pcl_id"] . '">' . $key["pcl_codigo"] . ' - ' . $key["pcl_nombre"] . '</option>';
        }
        echo $select;
        die();
    }

    public function carteras_cobros()
    {
        satelite_validar();
        $data['cobrador'] = $this->cuentas_cobrar_model->select_cobrador(array('cob_estado >=' => '0')); //'emp_estado >=' => '0',
        $data['titulo_personal']    = 'Reporte de Cartera de Cobro';
        cargarvista($data);
    }

    public function filtrar_cartera_cobro($es_reporte = 0)
    {
        $txtFecha_desde =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcCobrador = $this->input->post('slcCobrador');
        $slcRuta = $this->input->post('slcRuta');
        if ($txtFecha_desde != '' && $txtFecha_hasta != '') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >='] = date_format(date_create($txtFecha_desde), 'Y-m-d');
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <='] = date_format(date_create($txtFecha_hasta), 'Y-m-d');
            if ($slcCobrador > 0) {
                $where['rxb_id_cob'] = $slcCobrador;
            }
            if ($slcRuta > 0) {
                $where['rtc_id'] = $slcRuta;
            }
            $where['fac_monto_pendiente >'] = 0;
            $registros = $this->cuentas_cobrar_model->get_clientes_ruta($where);
        }
        $data['cobrador'] = $this->input->post('cobname');
        $data['es_reporte'] = $es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcCobrador'] = $slcCobrador;
        $data['slcRuta'] = $slcRuta;
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_cartera_cobro', $data, true);

        if ($es_reporte > 0) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde == $txtFecha_hasta) ? "De: " . date_format(date_create($txtFecha_desde), 'd-m-Y') : "De: " . $data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=Reporte_cartera_cobro" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                    <tr><th colspan='11' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                    <tr><th colspan='11' align='center' >Reporte de Cartera de Cobro</th></tr>
                    </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte de Cartera de Cobro ", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cartera_cobro', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    public function get_rutas_cobrador()
    {
        $html = '<option value=""></option>';
        $cobrador = $this->input->post("cobrador");
        $where['rxb_id_cob'] = $cobrador;
        $rutas = $this->cuentas_cobrar_model->get_rutas_cob($where);
        if (count($rutas) > 0) {
            foreach ($rutas as $key) {
                $html .= "<option value='" . $key['rtc_id'] . "'>" . $key['rtc_nombre'] . "</option>";
            }
        }
        echo $html;
    }

    /** 
     * @author Raul Escalante
     * @since: 09/04/2019
     * Descripcion: Se obtienen las sucursales asociadas a los clientes
     * @return sucursales
     */
    public function get_suc_cliente()
    {
        $clientes = $this->input->post('clientes');
        $in       = implode(',', $clientes);
        $where    = "scl_id_cli in (" . $in . ")";
        $sucs     = $this->gsatelite->get_tabla("scl_sucursal_cliente", $where);
        $html     = '<option value=""></option>';
        foreach ($sucs as $value) {
            $html .= '<option value="' . $value['scl_id'] . '" >' . $value['scl_codigo'] . ' - ' . $value['scl_nombre'] . '</option>';
        }
        echo trim($html);
    }

    /**
     * @author René Castaneda
     * @since 2019-04-29
     * @return facturas estado de cuenta detalle maya
     */
    public function estado_cuenta_corriente2()
    {
        $this->estado_cuenta_corriente(1);
    }

    /**
     * @author Raul Escalante
     * @since 2019-05-14
     * @return reporte de lavado de dinero
     */
    public function lavado_dinero($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            if ($flag) {
                $fecha_inicio = ($post_array['txtFechaIni'] != '') ? $post_array['txtFechaIni'] : null;
                $fecha_fin    = ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
                $clientes     = ($post_array['clientes'] != '') ? implode(',', $post_array['clientes']) : null;
                $tipos_pago   = ($post_array['tipos'] != '') ? implode(',', $post_array['tipos']) : null;
            } else {
                $fecha_inicio = ($post_array['h_fecha_ini'] != '') ? $post_array['h_fecha_ini'] : null;
                $fecha_fin    = ($post_array['h_fecha_fin'] != '') ? $post_array['h_fecha_fin'] : null;
                $clientes     = ($post_array['h_clientes'] != '') ? $post_array['h_clientes'] : null;
                $tipos_pago   = ($post_array['h_tipo_pago'] != '') ? $post_array['h_tipo_pago'] : null;
            }
            $where = array();
            if ($fecha_inicio != null) {
                $fecha_inicio  = formatear_fecha('Y-m-d', $fecha_inicio);
                $where["abc_fecha >="] = $fecha_inicio . ' 00:00:00';
            }
            if ($fecha_fin != null) {
                $fecha_fin     = formatear_fecha('Y-m-d', $fecha_fin);
                $where["abc_fecha <="] = $fecha_fin . ' 23:59:59';
            }
            if ($clientes != null) {
                $where['cli_id in (' . $clientes . ')'] = null;
            }
            if ($tipos_pago != null) {
                $where['frp_id in (' . $tipos_pago . ')'] = null;
            }
            $tipo_reporte = $post_array['tipo_reporte'];
            $data['tipo_reporte'] = $tipo_reporte;
            $data['clientes']  = $this->cuentas_cobrar_model->get_clientes_lavado($where, $fecha_inicio, $fecha_fin);
            $data['titulo'] = 'Reporte de Lavado de Dinero';
            $data['filename'] = 'rpt_lavado_dinero_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_lavado_dinero', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Lavado de dinero';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_lavado_dinero_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Lavado', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        } else {
            $select = '';
            $tiposs = '';
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
            $tipos = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1));
            foreach ($clientes as $key) {
                if ($key['cli_personeria'] == 1) {
                    $select .= '<option value="' . $key['cli_id'] . '">' . trim($key['cli_nombre'] . ' ' . $key['cli_apellido']) . '</option>';
                } else {
                    $select .= '<option value="' . $key['cli_id'] . '">' . trim($key['cli_apellido']) . '</option>';
                }
            }
            foreach ($tipos as $key) {
                $tiposs .= '<option value="' . $key['frp_id'] . '">' . trim($key['frp_nombre']) . '</option>';
            }
            $data['clientes'] = $select;
            $data['tipos'] = $tiposs;
            $data['titulo_personal'] = "Reporte Lavado de Dinero";
            cargarvista($data);
        }
    }

    /**
     * @author Raul Escalante
     * @since 2019-05-17
     * @return reporte de composicion de saldos
     */
    public function composicion_saldos($flag = null)
    {
        satelite_validar();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        if ($_POST) {
            // print_r($_POST);die();
            $post_array = $this->input->post();
            if ($flag) {
                $fecha_hasta = ($post_array['fecha_hasta'] != '') ? $post_array['fecha_hasta'] : null;
                $vendedor    = ($post_array['vendedor'] != '') ? $post_array['vendedor'] : null;
                $cliente     = ($post_array['cliente'] != '') ? $post_array['cliente'] : null;
                $sucursal    = ($post_array['sucursal'] != '') ? $post_array['sucursal'] : null;
                $ver_saldos  = $post_array['ver_saldo'];
            } else {
                $fecha_hasta = ($post_array['h_fecha_hasta'] != '') ? $post_array['h_fecha_hasta'] : null;
                $vendedor    = ($post_array['h_vendedor'] != '') ? $post_array['h_vendedor'] : null;
                $cliente     = ($post_array['h_cliente'] != '') ? $post_array['h_cliente'] : null;
                $sucursal    = ($post_array['h_sucursal'] != '') ? $post_array['h_sucursal'] : null;
                $ver_saldos  = $post_array['h_ver_saldo'];
            }
            $having = null;
            $where = array('fac_estado <> ' => 0);
            if ($fecha_hasta != null) {
                $fecha = date('Y-m-d', strtotime($fecha_hasta));
            }
            if ($vendedor != null) {
                $where['ven_id'] = $vendedor;
            }
            if ($cliente != null) {
                $where['cli_id'] = $cliente;
            }
            if ($sucursal != null) {
                $where['fac_id_suc'] = $sucursal;
            }
            if ($ver_saldos < 1) {
                $having['saldo_actual > '] = 0;
            }
            $tipo_reporte = $post_array['tipo_reporte'];
            $data['tipo_reporte'] = $tipo_reporte;
            $data['informacion']  = $this->cuentas_cobrar_model->get_composicion_saldo($fecha, $where, $having);
            $data['titulo']       = 'Reporte de Composicion de Saldos';
            $data['filename']     = 'rpt_composicion_saldos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            //print_r($this->db->last_query()); die();
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_composicion_saldo', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Composicion de saldo';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    echo $reporte;
                    die();
                    // $GLOBALS['nombre_reporte'] = 'Reporte_composicion_saldo_' . date('dmY');                    
                    // $this->pdf->SetMargins(10, 10, 10, 50);
                    // $this->pdf->makePdf($reporte, 'P', 'Reporte_composicion_saldo', 'Letter');
                } else if ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
        } else {
            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado >=' => '0'), null, null, null, true);
            $sucursal = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', null, null, null, null, true);
            $data['sucursal'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $sucursal);
            $data['vendedores'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $vendedores);
            $data['titulo_personal'] = "Reporte de Composicion de Saldos";
            cargarvista($data);
        }
    }


    //copiado del modulo de facturacion ya que da conflicto al compartirlo xq ambos controladores tienen el mismo nombre

    public function reporte_abono_cliente($consulta = 0)
    {
        $this->load->model('facturacion_model');
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_cobrar/reportes/reporte_abono_cliente');
            if ($_POST) {
                if ($consulta > 0) {
                    //var_dump($_POST);die();
                    $post_array = $_POST;
                    $cliente = $post_array['cliente'];
                    $vendedor = $post_array['vendedor'];
                    $pago = $post_array['pago'];
                    $textocliente = $post_array['textocliente'];
                    $fecha_inicio = $post_array['fecha_ini'];
                    $fecha_fin = $post_array['fecha_fin'];
                    $data['fecha_ini'] = $fecha_inicio;
                    $data['fecha_fin'] = $fecha_fin;
                    $where['abc_monto >'] = 0;
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
                    }
                    if (trim($cliente) != "") {
                        $where['cli_id'] = $cliente;
                    }
                    if (trim($vendedor) != "") {
                        $where['ven_id'] = $vendedor;
                    }
                    $data['pago'] = $pago;
                    $data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id');
                    $data['textocliente'] = $textocliente;
                    if (trim($pago) != "") {
                        $data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado' => 1, 'dab_id_tpg' => $pago), 'abc_id');
                    } else {
                        $data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado' => 1), 'abc_id');
                    }
                    $data['tipo_reporte'] = 'grid';
                    $html = $this->load->view('facturacion/reportes/imprimir_reporte_abono_cliente', $data, true);
                    echo $html;
                    die();
                }
            } else {
                $select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo}{ven_nombre}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
                $data['vendedor'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
                $data['tipo_pago'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
                $data['titulo_personal'] = 'Reporte de abonos por cliente';
                $this->_cargarvista($data);
            }
        }
    }

    public function reporte_detallado_abono($consulta = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_cobrar/reportes/reporte_detallado_abono');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;
                    $cliente = $post_array['cliente'];
                    $vendedor = $post_array['vendedor'];
                    $pago = $post_array['pago'];
                    $slcCobrador = $this->input->post('slcCobrador');
                    $fecha_inicio = $post_array['fecha_ini'];
                    $fecha_fin = $post_array['fecha_fin'];
                    $data['fecha_ini'] = $fecha_inicio;
                    $data['fecha_fin'] = $fecha_fin;
                    $where = null;
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
                    }
                    if (trim($cliente) != "") {
                        $where['cli_id'] = $cliente;
                    }
                    if (trim($vendedor) != "") {
                        $where['ven_id'] = $vendedor;
                    }
                    if (trim($slcCobrador) > 0) {
                        $where['abc_id_cob'] = $slcCobrador;
                    }
                    if (trim($pago) != "") {
                        $where['fac_id_tpg'] = $pago;
                    }
                    $where['fac_estado >'] = 0;
                    $where['abc_monto >'] = 0;
                    $data['pago'] = $pago;
                    $data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id, abf_id');
                    $data['detalle_abono'] = $this->gsatelite->get_tabla('dab_detalle_abono', array('dab_estado' => 1, 'dab_id_tpg' => $pago));
                    $data['tipo_reporte'] = 'grid';
                    $reporte = array();
                    //se realiza un procesamiento de los datos para convertirlo en JSON y enviarlo a la vista
                    $reporte = $this->procesar_reporte_detalle_abono($data);
                    echo json_encode($reporte);
                    die();

                    /*$html = $this->load->view('modulo_cuentas_cobrar/reportes/imprimir_reporte_detallado_abono', $data, true);
                    echo json_encode(array('html' => $html));
                    die();*/
                }
            } else {
                $select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
                $data['vendedor'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $select = '';
                $clientes_reg = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
                foreach ($clientes_reg as $key) {
                    if ($key['cli_personeria'] == 1) {
                        $select .= '<option value="' . $key['cli_id'] . '">' . $key['cli_codigo'] . ' - ' . trim($key['cli_nombre'] . ' ' . $key['cli_apellido']) . '</option>';
                    } else {
                        $select .= '<option value="' . $key['cli_id'] . '">' . $key['cli_codigo'] . ' - ' . trim($key['cli_apellido']) . '</option>';
                    }
                }
                $data['clientes'] = $select;

                $select = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
                $data['tipo_pago'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $this->db->join('emp_empleado', 'emp_id=cob_id_emp', 'left');
                $slcCobrador = $this->gsatelite->get_dropdown('cob_cobrador', '{cob_codigo} -  {cob_nombre} {cob_apellido}', '', null, null, '', 'cob_id', true);
                $data['slcCobrador'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $slcCobrador);
                $data['titulo_personal'] = 'Reporte detallado de abono';
                $this->_cargarvista($data);
            }
        }
    }

    function imprimir_reporte_detallado_abono()
    {
        $fecha_ini = $this->input->post('txtFechaIni');
        $fecha_fin = $this->input->post('txtFechaFin');
        $cliente = $this->input->post('slcCliente');
        $vendedor = $this->input->post('slcVendedor');
        $pago = $this->input->post('slcPago');
        $slcCobrador = $this->input->post('slcCobrador');
        $tipo = $this->input->post('tipo_reporte');
        $where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
        $where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
        if (trim($cliente) != "") {
            $where['cli_id'] = $cliente;
        }
        if (trim($vendedor) != "") {
            $where['ven_id'] = $vendedor;
        }
        if (trim($slcCobrador) > 0) {
            $where['abc_id_cob'] = $slcCobrador;
        }
        if (trim($pago) != "") {
            $where['fac_id_tpg'] = $pago;
        }
        $where['fac_estado >'] = 0;
        $where['abc_monto >'] = 0;
        $data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id, abf_id');
        $data['detalle_abono'] = $this->gsatelite->get_tabla('dab_detalle_abono', array('dab_estado' => 1, 'dab_id_tpg' => $pago));
        $data['tipo_reporte'] = $tipo;
        $data['cliente'] = $cliente;
        $data['vendedor'] = $vendedor;
        $data['pago'] = $pago;
        $data['textcliente'] = $this->input->post('txtCliente');
        $data['textvendedor'] = $this->input->post('txtVendedor');
        $data['textpago'] = $this->input->post('txtPago');
        $data['fecha_ini'] = $fecha_ini;
        $data['fecha_fin'] = $fecha_fin;

        if ($tipo == 'excel') {
            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('modulo_cuentas_cobrar/reportes/imprimir_reporte_detallado_abono', $data);
        } else {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/imprimir_reporte_detallado_abono', $data, true);
            echo $html;
            //$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
            //$this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
        }
    }

    function imprimir_reporte_abono_cliente()
    {
        $fecha_ini = $this->input->post('txtFechaIni');
        $fecha_fin = $this->input->post('txtFechaFin');
        $cliente = $this->input->post('slcCliente');
        $vendedor = $this->input->post('slcVendedor');
        $pago = $this->input->post('slcPago');
        $tipo = $this->input->post('tipo_reporte');
        $where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
        $where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
        if (trim($cliente) != "") {
            $where['cli_id'] = $cliente;
        }
        if (trim($vendedor) != "") {
            $where['ven_id'] = $vendedor;
        }
        $where['abc_monto >'] = 0;
        $data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id');
        if (trim($pago) != "") {
            $data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado' => 1, 'dab_id_tpg' => $pago));
        } else {
            $data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado' => 1));
        }
        $data['tipo_reporte'] = $tipo;
        $data['cliente'] = $cliente;
        $data['vendedor'] = $vendedor;
        $data['pago'] = $pago;
        $data['textcliente'] = $this->input->post('txtCliente');
        $data['textvendedor'] = $this->input->post('txtVendedor');
        $data['textpago'] = $this->input->post('txtPago');
        $data['fecha_ini'] = $fecha_ini;
        $data['fecha_fin'] = $fecha_fin;
        if ($tipo == 'excel') {
            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('modulo_cuentas_cobrar/reportes/imprimir_reporte_abono_cliente', $data);
        } else {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/imprimir_reporte_abono_cliente', $data, true);
            $GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
            $this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
        }
    }


    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function antiguedad_saldo_corto_plazo()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['tipo_cliente'] = $this->gsatelite->get_dropdown('tpc_tipo_cliente', '{tpc_nombre}', '', array('tpc_estado' => '1'), null, '', 'tpc_id', true);
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), null, '', 'ven_id', true);
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);
        // $data['sucursal'] = $this->gsatelite->get_dropdown('scl_sucursal_cliente','{scl_codigo} {scl_nombre}','',array('scl_estado' => '1'),null,'','scl_id',true);
        $data['titulo_personal'] = "Reporte Antigüedad de Saldos a corto plazo";
        cargarvista($data);
    }

    function filtrar_antiguedad_saldo_corto($es_reporte = 0)
    {
        satelite_validar();
        $registros           = array();
        $permisos            = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos']    = $permisos;
        $slcTipoCliente      = $this->input->post('slcTipoCliente');
        $slcVendedor         = $this->input->post('slcVendedor');
        $slcCliente          = $this->input->post('slcCliente');
        $slc_proyecto        = $this->input->post('slc_proyecto');
        $slc_dias            = $this->input->post('slc_dias');
        $slcSucursal         = $this->input->post('slcSucursal');
        $txt_desde           = ($this->input->post('txt_desde') != "") ? date('Y-m-d', strtotime($this->input->post('txt_desde'))) : NULL;
        $txt_hasta           = ($this->input->post('txt_hasta') != "") ? date('Y-m-d', strtotime($this->input->post('txt_hasta'))) : NULL;
        $filtro_titulo       = '';
        $where['fac_estado'] = '1';
        $having              = null;
        if ($this->input->post()) {
            if ($slcTipoCliente > 0) {
                $where['cli_id_tpc'] = $slcTipoCliente;
                $registro = $this->gsatelite->get_registro('tpc_tipo_cliente', 'tpc_id', $slcTipoCliente);
                $filtro_titulo .= 'Tipo Cliente: ' . $registro->tpc_nombre;
            }
            if ($slcVendedor > 0) {
                $where['fac_id_ven'] = $slcVendedor;
                $registro = $this->gsatelite->get_registro('ven_vendedor', 'ven_id', $slcVendedor);
                $filtro_titulo .= (trim($filtro_titulo) != '') ? '<br /> Vendedor: ' . $registro->ven_codigo . ' ' . $registro->ven_nombre . ' ' . $registro->ven_apellidos : 'Vendedor: ' . $registro->ven_codigo . ' ' . $registro->ven_nombre . ' ' . $registro->ven_apellidos;
            } else {
                $filtro_titulo .= (trim($filtro_titulo) != '') ? '<br /> Vendedor: Todos los vendedores' : 'Vendedor: Todos los vendedores';
            }
            if ($slcCliente > 0) {
                $where['fac_id_cli'] = $slcCliente;
                $registro = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $slcCliente);
            }
            if ($slcSucursal > 0) {
                $where['fac_id_scl'] = $slcSucursal;
                $registro = $this->gsatelite->get_registro('scl_sucursal_cliente', 'scl_id', $slcSucursal);
            }
            if ($slc_proyecto > 0) {
                $where['fac_id_pcl'] = $slc_proyecto;
            }
            if ($slc_dias != "") {
                switch ($slc_dias) {
                    case 0:
                        $having['sin_vencer >'] = 0;
                        break;
                    case 7:
                        $having['rango1 >'] = 0;
                        break;
                    case 15:
                        $having['rango2 >'] = 0;
                        break;
                    case 30:
                        $having['rango3 >'] = 0;
                        break;
                }
            }
            if (trim($txt_desde) != NULL && trim($txt_hasta) != NULL) {
                $where['DATE(fac_fecha_fact) >='] = $txt_desde;
                $where['DATE(fac_fecha_fact) <='] = $txt_hasta;
            } else {
                $txt_desde = "";
                $txt_hasta = "";
            }
            $registros = $this->cuentas_cobrar_model->get_cuentas_antiguedad_saldo_corto_plazo($where, $having, $txt_desde, $txt_hasta);
        }
        $data['es_reporte']     = $es_reporte;
        $data['slcTipoCliente'] = $this->input->post('slcTipoCliente');
        $data['slcVendedor']    = $this->input->post('slcVendedor');
        $data['slcCliente']     = $this->input->post('slcCliente');
        $data['slcSucursal']    = $this->input->post('slcSucursal');
        $data['slc_proyecto']   = $this->input->post('slc_proyecto');
        $data['slc_dias']       = $this->input->post('slc_dias');
        $data['txt_desde']      = $this->input->post('txt_desde');
        $data['txt_hasta']      = $this->input->post('txt_hasta');
        $data['registros'] = $registros;
        if ($slc_dias != "" && $slc_dias >= 0) {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_antiguedad_saldo_dias_corto', $data, true);
        } else {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_antiguedad_saldo_corto', $data, true);
        }
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=antiguedad_saldos" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                    <tr><th colspan='9' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                    <tr><th colspan='9' align='center' >Reporte Antigüedad de Saldos</th></tr>
                    <tr><th colspan='9' align='center' >" . $filtro_titulo . "</th></tr>
                    </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Antigüedad de saldos <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" width = "100%" style="font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    public function get_sucursal_cliente()
    {
        $cli_id = $this->input->post('cliente');
        $select = '<option></option>';
        $dropdown = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_codigo} {scl_nombre}', '', array('scl_estado' => 1, 'scl_id_cli' => $cli_id), null, '', 'scl_id', true);
        $dropdown =  str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $dropdown);
        echo $select . $dropdown;
        die();
    }

    function procesar_reporte_detalle_abono($data)
    {
        $reporte = array();
        if (count($data['abono']) > 0) {
            //Se recorren los abonos
            $abonos = $data['abono'];
            $detalle_abono = $data['detalle_abono'];
            $total_reporte = 0;
            $pago = $data['pago'];
            foreach ($abonos as $abc) {
                $cliente_nombre = '';
                $monto_total = 0;
                if ($abc['cli_personeria'] == 1) {
                    $cliente_nombre = trim($abc['cli_nombre'] . ' ' . $abc['cli_apellido']);
                } else {
                    $cliente_nombre = trim($abc['cli_apellido']);
                }
                if (trim($pago) != '') {
                    $abc_id = $abc['abc_id'];
                    $detalles  = array_filter($detalle_abono, function ($value) use ($abc_id) {
                        return ($value['dab_id_abc'] == $abc_id); //  &&  $value['dab_id_tpg'] == pago
                    });
                    if (count($detalles) > 0) {
                        $monto_total = array_sum(array_column($detalles, 'dab_monto'));
                    } else {
                        if ($abc['fac_id_tpg'] == $pago) {
                            $monto_total = $abc['abc_monto'];
                        }
                    }
                } else {
                    $monto_total = $abc['abc_monto'];
                }

                $fila = array(
                    'cliente' => $cliente_nombre,
                    'codigo_abono' => $abc['abc_id'],
                    'monto_total' => '$' . number_format($monto_total, 2),
                    'fecha_abono' => formatear_fecha('d-m-Y', $abc['fecha_abono']),
                    'vendedor' => $abc['vendedor'],
                    'cobrador' => $abc['codigo_cobrador'],
                    'recibo' => $abc['abc_comprobante'],
                    'tipo_doc' => $abc['tif_abreviacion'],
                    'serie' => $abc['sef_nombre'],
                    'factura' => $abc['fac_numero'],
                    'monto_factura' => '$' . number_format($abc['abf_monto'], 2),
                    'saldo' => '$' . number_format(($abc['abf_pendiente_factura'] - $abc['fac_total_retencion']), 2)
                );

                $reporte[] = $fila;
            }
        }
        return $reporte;
    }

    public function cobranza_comision($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = array('fac_estado > ' => 0, 'abc_estado > ' => 0);
            if ($_POST['fecha_desde'] != "") {
                $where['DATE(abc_fecha) >= '] = formatear_fecha('Y-m-d', $_POST['fecha_desde']);
            }
            if ($_POST['fecha_hasta'] != "") {
                $where['DATE(abc_fecha) <= '] = formatear_fecha('Y-m-d', $_POST['fecha_hasta']);
            }
            if ($_POST['category'] > 0) {
                $where['art_id_tia'] = $_POST['category'];
            }
            if ($_POST['cobrador'] > 0) {
                $where['abc_id_cob'] = $_POST['cobrador'];
            }
            if ($_POST['vendedor'] > 0) {
                $where['fac_id_ven'] = $_POST['vendedor'];
                $where['abc_id_cob IS NULL'] = null;
            }
            $registros = $this->cuentas_cobrar_model->get_comisiones_cxc($where);
            $data['tipo'] = $_POST['tipo_reporte'];
            $data['registros'] = $registros;
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_comisiones_recuperacion', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
            } else {
                if ($_POST['tipo_reporte'] == 'pdf') {
                    $titulos = array(
                        'titulo' => "Comisiones por Recuperación de Cuentas por Cobrar",
                        'subtitulo' => "De " . $_POST['fecha_desde'] . " A " . $_POST['fecha_hasta']
                    );
                    $header = $this->load->view('reporte/header', $titulos, true);
                    $report = $header . trim($html);
                    $this->pdf->SetPrintFooter(false);
                    $this->pdf->makePDF($report, "P");

                } else {
                    echo $html;
                }                
            }
        } else {
            $data['cobrador'] = $this->gsatelite->get_dropdown('cob_cobrador', '{cob_codigo} {cob_nombre} {cob_apellido}','', array('cob_estado' => '1'), null, '', 'cob_id', true);
            $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}','', array('ven_estado' => '1'), null, '', 'ven_id', true);
            $data['categoria'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} {tia_nombre}','', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = "Comisiones por Recuperación";
            cargarvista($data, null, "modulo_cuentas_cobrar/reportes/cobranza_comision");
        }
    }

    public function seguimiento_cuentas_cobrar($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            $fec_ini = $_POST['fecha_inicio'];
            $fec_fin = $_POST['fecha_final'];
            $cliente = $_POST['cliente'];
            $vndedor = $_POST['vendedor'];
            $cobradr = $_POST['cobrador'];
            $tipo_rp = $_POST['tipo_reporte'];
            $where = array('(fac_estado = 1 OR (fac_estado = 2 AND (fac_monto_pendiente - fac_total_retencion) > 0))' => null);
            if ($fec_ini != "") {
                $where['DATE(fac_fecha_fact) >= '] = formatear_fecha('Y-m-d', $fec_ini);
            }
            if ($fec_fin != "") {
                $where['DATE(fac_fecha_fact) <= '] = formatear_fecha('Y-m-d', $fec_fin);
            }
            if ($cliente > 0) {
                $where['fac_id_cli'] = $cliente;
            }
            if ($vndedor > 0) {
                $where['fac_id_ven'] = $vndedor;
            }
            if ($cobradr > 0) {
                $where['abc_id_cob'] = $cobradr;
            }
            $registros = $this->cuentas_cobrar_model->get_seguimiento_cxcobrar($where);
            $data['tipo'] = $tipo_rp;
            $data['registros'] = $registros;
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_seguimiento_cuentas_cobrar', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
            } else {
                if ($tipo_rp == 'pdf') {
                    $html_header = $this->load->view('reporte/header', array('titulo' => "Seguimiento de Cuentas por Cobrar", 'solotitulo' => true), true);
                    $repo = $html_header . trim($html);
                    // var_dump($repo);die();
                    $this->pdf->makePDF($repo, 'L');
                } else {
                    echo $html;
                }
            }
        } else {
            $data['cobrador'] = $this->gsatelite->get_dropdown('cob_cobrador', '{cob_codigo} {cob_nombre} {cob_apellido}', '', array('cob_estado' => '1'), null, '', 'cob_id', true);
            $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), null, '', 'ven_id', true);
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = "Seguimiento de CxC";
            cargarvista($data);
        }
    }

    /**
     * @author Mario Marquez
     * @since 2020-09-28
     * @return Antiguedad saldos detallado
     */

    public function antiguedad_saldo_detallado()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['tipo_cliente'] = $this->gsatelite->get_dropdown('tpc_tipo_cliente', '{tpc_nombre}', '', array('tpc_estado' => '1'), null, '', 'tpc_id', true);
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado >=' => '0'), null, '', 'ven_id', true);
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);
        // $data['sucursal'] = $this->gsatelite->get_dropdown('scl_sucursal_cliente','{scl_codigo} {scl_nombre}','',array('scl_estado' => '1'),null,'','scl_id',true);//Agregado dropdwon "Sucursal" 2019-2-15
        $data['titulo_personal'] = "Reporte Detalle de Antiguedad de Saldos";
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-07-04
     * @return filtrar antiguedad saldos.
     */
    public function filtrar_antiguedad_saldo_detallado($es_reporte = 0)
    {
        satelite_validar();
        $registros          = array();
        $permisos           = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos']   = $permisos;
        $slcTipoCliente     = $this->input->post('slcTipoCliente');
        $slcVendedor        = $this->input->post('slcVendedor');
        $slcCliente         = $this->input->post('slcCliente');
        $slc_proyecto       = $this->input->post('slc_proyecto');
        $slc_dias           = $this->input->post('slc_dias');
        $slcSucursal        = $this->input->post('slcSucursal');
        $txt_desde          = ($this->input->post('txt_desde') != "") ? date('Y-m-d', strtotime($this->input->post('txt_desde'))) : NULL;
        $txt_hasta          = ($this->input->post('txt_hasta') != "") ? date('Y-m-d', strtotime($this->input->post('txt_hasta'))) : NULL;
        $filtro_titulo      = '';
        $where['fac_estado'] = '1';
        $having             = null;
        if ($this->input->post()) {
            if ($slcTipoCliente > 0) {
                $where['cli_id_tpc'] = $slcTipoCliente;
                $registro = $this->gsatelite->get_registro('tpc_tipo_cliente', 'tpc_id', $slcTipoCliente);
                $filtro_titulo .= 'Tipo Cliente: ' . $registro->tpc_nombre;
            }
            if ($slcVendedor > 0) {
                $where['fac_id_ven'] = $slcVendedor;
                $registro = $this->gsatelite->get_registro('ven_vendedor', 'ven_id', $slcVendedor);
                $filtro_titulo .= (trim($filtro_titulo) != '') ? '<br /> Vendedor: ' . $registro->ven_codigo . ' ' . $registro->ven_nombre . ' ' . $registro->ven_apellidos : 'Vendedor: ' . $registro->ven_codigo . ' ' . $registro->ven_nombre . ' ' . $registro->ven_apellidos;
            } else {
                $filtro_titulo .= (trim($filtro_titulo) != '') ? '<br /> Vendedor: Todos los vendedores' : 'Vendedor: Todos los vendedores';
            }
            if ($slcCliente > 0) {
                $where['fac_id_cli'] = $slcCliente;
                $registro = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $slcCliente);
            }
            if ($slcSucursal > 0) { //Agregado 2019-2-15
                $where['fac_id_scl'] = $slcSucursal;
                $registro = $this->gsatelite->get_registro('scl_sucursal_cliente', 'scl_id', $slcSucursal);
            }
            if ($slc_proyecto > 0) {
                $where['fac_id_pcl'] = $slc_proyecto;
            }
            if ($slc_dias != "") {
                switch ($slc_dias) {
                    case 0:
                        $having['sin_vencer >'] = 0;
                        break;
                    case 30:
                        $having['rango1 >'] = 0;
                        break;
                    case 60:
                        $having['rango2 >'] = 0;
                        break;
                    case 90:
                        $having['rango3 >'] = 0;
                        break;
                    case 120:
                        $having['rango4 >'] = 0;
                        break;
                    case 121:
                        $having['restantes >'] = 0;
                        break;
                }
            } else {
                $having['fac_monto_pendiente >'] = 0;
            }
            if (trim($txt_hasta) != NULL) {
                $where['DATE(fac_fecha_fact) <='] = $txt_hasta;
            } else {
                $txt_hasta = "";
            }
            $registros = $this->cuentas_cobrar_model->get_cuentas_antiguedad_saldo_detallado($where, $having, $txt_desde, $txt_hasta);
        }
        $data['es_reporte']     = $es_reporte;
        $data['slcTipoCliente'] = $this->input->post('slcTipoCliente');
        $data['slcVendedor']    = $this->input->post('slcVendedor');
        $data['slcCliente']     = $this->input->post('slcCliente');
        $data['slcSucursal']    = $this->input->post('slcSucursal'); //Agregado 2019-2-15
        $data['slc_proyecto']   = $this->input->post('slc_proyecto');
        $data['slc_dias']       = $this->input->post('slc_dias');
        $data['txt_desde']      = $this->input->post('txt_desde');
        $data['txt_hasta']      = $this->input->post('txt_hasta');

        $data['registros'] = $registros;
        if ($slc_dias != "" && $slc_dias >= 0) {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_antiguedad_saldo_detallado_dias', $data, true);
        } else {
            $html = $this->load->view('modulo_cuentas_cobrar/reportes/filtrar_antiguedad_saldo_detallado', $data, true);
        }

        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=antiguedad_saldos" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='9' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='9' align='center' >Reporte Detalle de Antigüedad de Saldos</th></tr>
                  <tr><th colspan='9' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Detalle de Antigüedad de saldos <br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" width = "100%" style="font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'cuentas_cobrar', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }
}
/* End of file reportes.php */
/* Location: ./application/controllers/modulo_cuentas_cobrar/reportes.php */
