<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Descripcion
 * Ejecuta todos los procesos de dicho modulo (dar mantemiento a tablas principales)
 * Controlador de Procesos - Módulo Cuentas por cobrar
 * @author:     René Castaneda
 * @version:    2017/06/02
 * @since:      2017/06/02
 * @package:    Erp Satelite
 * =================================================================================
 */

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('cuentas_cobrar_model');
        $this->load->model('contabilidad_model');
        $this->load->model('facturacion_model');
        $this->load->library('pdf');
    }

    function index() {
    	satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Cuentas por Cobrar';
            $this->_cargarvista(null, $data);
        }
    }

    /**
    * @author René Castaneda
    * @since 2017-06-05
    * @return Pagos a facturas de los clientes
     */

    public function pagos($otro_modulo=null)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos']=$permisos;
        $data['titulo_personal'] = "Pagos";
        $data['registros'] = $this->cuentas_cobrar_model->get_abonos_cliente(array('abc_id'=>0));
        $data['otro_mod'] = $otro_modulo;
        $formato = $this->gsatelite->get_tabla( "fri_formato_impresion" , array("fri_estado" => 1, "fri_activo" => 1, "fri_tipo_formato" => 2) );
        $data['impresion'] = ( count($formato) > 0 )? true:false;
    
        if($otro_modulo){
            return $data;
        } else{
            cargarvista($data);
        }

    }

    /**
    * @author René Castaneda
    * @since 2017-06-05
    * @return filtrar Pagos a facturas de los clientes
     */

    public function filtrar_pagos($otro_modulo = 0){
        satelite_validar();
        if ($otro_modulo > 0) {
            $newurl = $this->input->post("txt_otra_url");
            $permisos = $this->gsatelite->get_permisos_opcion($newurl);
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('pagos');
        }
        $data['permisos']=$permisos;
        if ($this->input->post()) {
            $fecha_inicio = formatear_fecha('Y-m-d',$this->input->post('txtFecha_desde'));
            $fecha_fin = formatear_fecha('Y-m-d', $this->input->post('txtFecha_hasta'));
            $is_anticipo = $this->input->post('txt_abc_anl');
            //print_r($fecha_fin);die();
            if ($is_anticipo > 0) {
                $where["DATE(anl_fecha) BETWEEN '$fecha_inicio' and '$fecha_fin'"] = null;// and anl_estado = 1
                $html = $this->filtrar_anticipos($where);
                echo json_encode(array('html'=>$html));
                die();
            }
            $where["DATE(abc_fecha) BETWEEN '$fecha_inicio' and '$fecha_fin'"] = null;// and abc_estado = 1
        }
        $data['registros'] = $this->cuentas_cobrar_model->get_abonos_cliente($where,'abc_id');
        //print_r($this->db->last_query());die();
        $formato = $this->gsatelite->get_tabla( "fri_formato_impresion" , array("fri_estado" => 1, "fri_activo" => 1, "fri_tipo_formato" => 2) );
        $data['impresion'] = ( count($formato) > 0 )? true:false;        
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/filtrar_pagos', $data, true);
        echo json_encode(array('html'=>$html));
    }

    /**
    * @author Marlon Olmedo
    * @since 2019-12-27
    * @return filtrar los anticipo de los clientes
     */

    public function filtrar_anticipos($where)
    {
        satelite_validar();
        $data['registros'] = $this->cuentas_cobrar_model->get_anticipo_cliente($where);
        // print_r($this->db->last_query());die();
        //$formato = $this->gsatelite->get_tabla( "fri_formato_impresion" , array("fri_estado" => 1, "fri_activo" => 1, "fri_tipo_formato" => 2) );
        //$data['impresion'] = ( count($formato) > 0 )? true:false;        
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/filtrar_anticipo_cliente', $data, true);
        return $html;
    }

    /**
    * @author René Castaneda
    * @since 2017-06-05
    * @return Crear una sesión para el menú para luego redirigir.
     */
    public function redireccionar($modulo='',$url='')
    {
        if ($this->input->post()) {
            $modulo = $this->input->post('modulo');
            $url = $this->input->post('url');
            //$this->session->set_userdata('menu_modulo',$modulo);
            echo json_encode(array('ir'=>$url));
        }
    }

    /**
    * @author René Castaneda
    * @since 2017-06-08
    * @return anular pago/abono
     */
    public function anular_pago_abono($factura = null, $razon = null){
        $html = "";
        $exito = 0;
        $id_abono = 0;
        if ($this->input->post() || $factura > 0) { 
            $id_abono = $this->input->post('id_abono');
            $motivo   = $this->input->post('motivo_anulacion');
            // Se define si se quiere anular un solo pago de factura
            if ($factura > 0) {
                       $this->db->join('abc_abono_cliente', 'abc_id = abf_id_abc');
                $abf = $this->gsatelite->get_tabla("abf_abono_factura", array('abf_id_fac'=>$factura, 'abc_estado'=>1));
                if (is_numeric($abf[0]['abf_id_abc']) && $abf[0]['abf_id_abc']>0) {
                    $id_abono = $abf[0]['abf_id_abc'];
                    $motivo   = (trim($razon) != "") ? $razon : "";
                } else {
                    die("No se ha seleccionado ningun abono de la factura");
                }
            }
            if (trim($motivo) !='' and $id_abono > 0) { 

                /*CONSULTAR E INACTIVAR LOS ANTICIPOS SI SE HUBIESEN ELEGIDO*/
                $anticipos = $this->cuentas_cobrar_model->get_anticipo_abono(array('ana_id_abc'=>$id_abono));
                foreach ($anticipos as $ant) {
                    $monto_anticipo = $ant['ana_monto']; //anticipo usado
                    $registro_anl = $this->gsatelite->get_registro('anl_anticipo_cliente', array('anl_id'=>$ant['ana_id_anl']));
                    $registro_anl = (array) $registro_anl;
                    $nuevo_monto_anl = $registro_anl['anl_saldo'] + $monto_anticipo;
                    $anticipo_ab = array(
                        'anl_saldo' => $nuevo_monto_anl,
                        'anl_estado' => 1,
                        'anl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'anl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('anl_anticipo_cliente',$anticipo_ab,array('anl_id'=>$ant['ana_id_anl']));
                }
                $anticipo_utilizado = array(
                    'ana_estado' => 0,
                    'ana_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'ana_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('ana_anticipo_abono',$anticipo_utilizado,array('ana_id_abc' => $id_abono));
                /*FIN ACTUALIZACIÓN DE ANTICIPOS*/

                /*CONSULTAR E INACTIVAR LOS ABONOS A FACTURAS Y COMPROBANTES DE RETENCIÓN*/
                $abono_facturas_ret = $this->cuentas_cobrar_model->get_facturas_abono_ret(array('abf_id_abc' => $id_abono));
                foreach ($abono_facturas_ret as $abf_ret) {
                    $retencion_comprobante_det = array(
                        'rxf_estado' => 1,
                        'rxf_id_cmr' => null,
                        'rxf_aplicado' => null,
                        'rxf_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rxf_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('rxf_retencionxdetalle_factura',$retencion_comprobante_det,array('rxf_id_cmr'=>$abf_ret['cmr_id']));
                    $retencion_comprobante = array(
                        'cmr_estado' => 0,
                        'cmr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cmr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cmr_comprobante_retencion',$retencion_comprobante,array('cmr_id'=>$abf_ret['cmr_id']));
                }
                /*FIN ACTUALIZACIÓN/INACTIVACIÓN DE ABONOS DE RETENCIONES*/

                /*CONSULTAR LAS FACTURAS ABONADAS Y ACTIVARLAS*/
                $abono_facturas = $this->gsatelite->get_tabla('abf_abono_factura',array('abf_id_abc'=>$id_abono));
                foreach ($abono_facturas as $abf) {
                    $monto_fac = $abf['abf_monto'];
                    $monto_fac_retencion = $abf['abf_monto_retencion'];
                    $monto_abono_retencion = ($abf['abf_monto_retencion'] > 0)? ', fac_retencion_abono = null' : '' ; 
                    $reactivar_factuar= array(
                        'fac_estado' => 1,
                        'fac_monto_abono' => "(fac_monto_abono - $monto_fac)",
                        'fac_monto_pendiente' => "(fac_monto_pendiente + $monto_fac)",
                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                        'fac_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    // print_r($reactivar_factuar); die();
                    //$this->gsatelite->actualizar_array('fac_factura',$reactivar_factuar,array('fac_id'=>$abf['abf_id_fac']));
                    $monto_fac_retencion = ($monto_fac_retencion == null) ? 0: $monto_fac_retencion;
                    $q = "UPDATE fac_factura SET fac_estado = 1, fac_monto_abono = (fac_monto_abono - $monto_fac), fac_monto_pendiente = (fac_monto_pendiente + $monto_fac + $monto_fac_retencion), fac_usu_mod = '".$this->tank_auth->get_user_id()."', fac_fecha_mod = '".date('Y-m-d H:i:s')."'$monto_abono_retencion WHERE fac_id = ". $abf['abf_id_fac'];
                       //echo $q; die();
                    $this->db->query($q);
                }
                $anular_abono_fac = array(
                    'abf_fecha_anulacion' => date('Y-m-d H:i:s'),
                    'abf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'abf_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('abf_abono_factura',$anular_abono_fac,array('abf_id_abc'=>$id_abono));
                /*FIN INACTIVACIÓN DE ABONOS A FACTURA*/

                $actualizar = array(
                    'abc_estado' => 0,
                    'abc_id_usu_anulacion' => $this->tank_auth->get_user_id(),
                    'abc_motivo_anulacion' => $this->input->post('motivo_anulacion'),
                    'abc_fecha_anulacion' => date('Y-m-d H:i:s'),
                    'abc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'abc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('abc_abono_cliente',$actualizar,array('abc_id'=>$id_abono));
                $exito = 1;
                //SOLO CREAR PARTIDA AUTOMATICA SI PARAMETRO DICE QUE SI
                if ($this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_CUENTA_POR_COBRAR', 0) > 0) {
                    $this->partida_automatica_anular_pago($id_abono, 2);
                }
                echo json_encode(array('exito'=>$exito));
                die();
            }
            $registro=$this->gsatelite->get_tabla('abc_abono_cliente',array('abc_id' => $id_abono));
            $data['registro'] = $registro[0];
            $html = $this->load->view('modulo_cuentas_cobrar/procesos/anular_pago_abono', $data, true);
        }
        echo json_encode(array('html'=>$html));
    }

    /**
    * @author Francisco Orozco
    * @since 2018-10-09
    * @return imprime notas de abono
     */
    public function imprimir_notas_abono($abono = null) {
        satelite_validar();
        if ( $abono > 0 ) {
            $this->load->library('EnLetras');
            // Tabla de las configuraciones de formato de impresion.
            $formato = $this->gsatelite->get_tabla('fri_formato_impresion', array('fri_estado' => 1, 'fri_activo'=> 1, 'fri_tipo_formato' => 2) );
            //configuraciones de formato
            $conf_formato_array = json_decode($formato[0]['fri_configuraciones_formato'], true);
            
            $where['abc_id']    = $abono;
            $registros          = $this->cuentas_cobrar_model->get_facturas_abonadas($where);
            $data['registros']  = $registros;
            
            //Get deudas.
            $where_deuda['fac_fecha_fact <=']= $registros[0]["fac_fecha_fact"];
            $where_deuda['fac_id_cli']       = $registros[0]["fac_id_cli"];
            $where_deuda["(fac_fecha_anulacion < '".$registros[0]["fac_fecha_fact"]."' OR ISNULL(fac_fecha_anulacion))"] = NULL;
            $data['suma_deuda'] = $this->gsatelite->get_suma("fac_factura","fac_total",$where_deuda);
            
            //Get abonos
            $where_abonos['abc_fecha <']   = $registros[0]["fac_fecha_fact"];
            $where_abonos['abc_id_cli']    = $registros[0]["fac_id_cli"];
            $where_abonos["(abc_fecha_anulacion < '".$registros[0]["fac_fecha_fact"]."' OR ISNULL(abc_fecha_anulacion))"] = NULL;
            $data['suma_abonos'] = $this->gsatelite->get_suma("abc_abono_cliente","abc_monto",$where_abonos);

            $header             = ( isset($conf_formato_array['HEADER']) )?$conf_formato_array['HEADER']:"";
            $header_view        = "";

            if ( $header != "" ) {
                $data2['titulo'] = $conf_formato_array['HEADER_TITULO'];
                $header_view = $this->load->view('modulo_cuentas_cobrar/procesos/header_nota_abono', $data2, true);
            }
            $data['header_view'] = $header_view ;
            $data['width_conf']  = $conf_formato_array['WIDTH'];
            $data['height_conf'] = $conf_formato_array['HEIGHT'];
            $data['size_letra']  = 6;
            if ( isset($conf_formato_array['SIZE_LETRA']) != ''){ // Se verifica si existe la variable en la tabla frf
                $data['size_letra'] = $conf_formato_array['SIZE_LETRA'];
            }

            $html = $this->load->view('modulo_cuentas_cobrar/procesos/'.$formato[0]['fri_archivo'], $data, true);

            $js = "print(true)"; // Se ejecuta la impresión al cargar el PDF.
            $this->pdf->IncludeJS($js);

            if(isset($conf_formato_array['SETCELLPADDINGS']) != '' OR isset($conf_formato_array['FORMATO']) != ''){
                $orientacion = $conf_formato_array['ORIENTACION'];
                $formato = $conf_formato_array['FORMATO'];
                $formato_array = explode(",",$formato); // Convierte el formato a array por si se quiere un formato personalizado de pagina
                $fuente = "helvetica";

                if ( isset($conf_formato_array['SETCELLPADDINGS']) != '' ){
                    $setCellPaddings = $conf_formato_array['SETCELLPADDINGS'];
                }

                if ( isset($conf_formato_array['FUENTE']) != ''){// Verifica si existe el tiempo de fuente, ejemplo: calibrib.
                    $fuente = $conf_formato_array['FUENTE'];
                }

                $margins = $conf_formato_array['MARGINS'];

                // Verificar si es ticket que sera imprimido
                if (isset($conf_formato_array['TICKET']) && $conf_formato_array['TICKET'] > 0 && count($formato_array) > 1) {
                    // Cantidad de productos
                    $cantidad_productos = count($data['datos_factura']);
                    // Calcular la cantidad de altura que se sumara
                    $cant_pro_px = $cantidad_productos * 9;
                    // Asignar el formato
                    $formato = array(0=>$formato_array[0], 1=>($formato_array[1]+$cant_pro_px));

                } else {
                    $formato = (count($formato_array) > 1)?$formato_array:$formato;//si tiene mas de un elemento se toma el array y si no el valor del formato
                }

                $this->pdf->setPrintHeader(false);
                $this->pdf->SetFont($fuente);
                $this->pdf->setCellPaddings($setCellPaddings);
                $this->pdf->SetAutoPageBreak(true, 0);
                $this->pdf->SetMargins($margins); //274, 155
                $this->pdf->AddPage($orientacion, $formato, array(
                    'family' => $fuente,
                    'style' => '',
                    'size' => 6) , true
                );
                $nota_abono = $html;
                $this->pdf->setPrintFooter(false);
                $this->pdf->writeHTML($nota_abono, true, false, false, false, '');
                $this->pdf->boletaPDF('I');
            } else{
                $nota_abono = $html;
                $this->pdf->setPrintFooter(false);
                $this->pdf->makePDF($nota_abono, $conf_formato_array['ORIENTACION'], null , 'Letter');
            }
        }   
    }

    /**
    * @author René Castaneda
    * @since 2017-06-12
    * @return Pagos a factura detallado
     */
    public function cuentas_cobrar_detallado(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['cobrador'] = $this->cuentas_cobrar_model->select_cobrador(array('cob_estado' => '1'));
        $data['vendedor'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}','', array('ven_estado' => '1'), null, '', 'ven_id', true);
        $data['tipofac'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1, 'tif_aplica_venta' => 1), null, '', 'tif_id', true);
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]",'', array('cli_estado' => '1'), null, '', 'cli_id', true);
        $data['titulo_personal'] = "Cuentas a Cobrar Detallado";
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-06-12
    * @return filtrar Pagos a factura detallado
     */

    public function filtrar_cuentas_cobrar_detallado($es_reporte=0){
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos']=$permisos;
        $txtFecha_desde =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcVendedor = $this->input->post('slcVendedor');
        $slcCliente = $this->input->post('slcCliente');
        $slcCobrador = $this->input->post('slcCobrador');
        $slcTipoFact = $this->input->post('slcTipoFact');
        $where['fac_estado'] = '1';
        if ($txtFecha_desde!='' and $txtFecha_hasta!='') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >=']=date('Y-m-d',strtotime($txtFecha_desde));
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <=']=date('Y-m-d',strtotime($txtFecha_hasta));
            if ($slcVendedor>0) {
                $where['fac_id_ven']=$slcVendedor;
            }
            if ($slcCliente>0) {
                $where['fac_id_cli']=$slcCliente;
            }
            if ($slcCobrador>0) {
                $where['abc_id_cob']=$slcCobrador;
            }
            if ($slcTipoFact > 0) {
                $where['fac_id_tif'] = $slcTipoFact;
            }
            $registros=$this->cuentas_cobrar_model->get_cuentas_cobrar_detallado($where);
            // print_r($this->db->last_query()); die();
        }
        $data['es_reporte']=$es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcVendedor'] = $this->input->post('slcVendedor');
        $data['slcCliente'] = $this->input->post('slcCliente');
        $data['slcCobrador'] = $this->input->post('slcCobrador');
        $data['slcTipoFact'] = $this->input->post('slcTipoFact');
        $data['periodo'] = date('d-m-Y',strtotime($txtFecha_desde)) . ' A ' . date('d-m-Y',strtotime($txtFecha_hasta));
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/filtrar_cuentas_cobrar_detallado', $data, true);

        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde==$txtFecha_hasta)? "De: ".date('d-m-Y',strtotime($txtFecha_desde)):"De: ".$data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=cuenta_cobrar_detallado".date('d-m-Y_His').".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='12' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='12' align='center' >Reporte Cuentas a Cobrar Detallado</th></tr>
                  <tr><th colspan='12' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Cuentas a Cobrar Detallado <br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'cuentas_cobrar','Legal');
                die();
            }
        }
        echo json_encode(array('html'=>$html));

    }

    /**
    * @author René Castaneda
    * @since 2017-06-13
    * @return visualizar detalle de factura
    */
    public function detalle_factura()
    {

        $id_factura = $this->input->post('id_factura');
        $where = array('fac_id' => $id_factura);
        $registro_factura=$this->cuentas_cobrar_model->get_datos_factura($where);
        $data['registro'] = $registro_factura[0];
        $detalle_factura=$this->cuentas_cobrar_model->get_detalles_factura(array('def_id_fac' => $id_factura));
        $data['detalle'] = $detalle_factura;
        //print_r($data); die();
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/detalle_factura', $data, true);

        echo json_encode(array('html'=>$html));

    }


    /**
    * @author René Castaneda
    * @since 2017-06-13
    * @return visualizar facturas del cliente
    */
    public function detalle_factura_resumen()
    {

        $id_cliente = $this->input->post('id_cliente');
        $fecha_ini = date_format(date_create($this->input->post('fecha_ini')), 'Y-m-d');
        $fecha_fin = date_format(date_create($this->input->post('fecha_fin')), 'Y-m-d');
        $where['fac_id_cli'] = $id_cliente;
        $where['fac_estado'] = 1;
        $where['date_format(fac_fecha_fact,"%Y-%m-%d") >=']=$fecha_ini;
        $where['date_format(fac_fecha_fact,"%Y-%m-%d") <=']=$fecha_fin;

        $registro_factura=$this->cuentas_cobrar_model->get_datos_factura($where);
        $data['registros'] = $registro_factura;
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/detalle_factura_resumen', $data, true);

        echo json_encode(array('html'=>$html));

    }



    /**
    * @author René Castaneda
    * @since 2017-06-14
    * @return Pagos a factura resumen
     */
    public function cuentas_cobrar_resumen(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos']=$permisos;
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_nombre))]",'', array('cli_estado' => '1'), null, '', 'cli_id', true);
        $data['titulo_personal'] = "Cuentas a Cobrar Resumen";
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-06-14
    * @return filtrar Pagos a factura resumen
     */
    public function filtrar_cuentas_cobrar_resumen($es_reporte=0)
    {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos']=$permisos;
        $txtFecha_desde =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcCliente = $this->input->post('slcCliente');
        $where['fac_estado'] = '1';
        if ($txtFecha_desde!='' and $txtFecha_hasta!='') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >=']=date('Y-m-d',strtotime($txtFecha_desde));
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <=']=date('Y-m-d',strtotime($txtFecha_hasta));

            if ($slcCliente>0) {
                $where['fac_id_cli']=$slcCliente;
            }

            $registros=$this->cuentas_cobrar_model->get_cuentas_cobrar_resumen($where);
            //print_r($this->db->last_query()); die();
        }
        $data['es_reporte']=$es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcCliente'] = $this->input->post('slcCliente');
        $data['periodo'] = date('d-m-Y',strtotime($txtFecha_desde)) . ' A ' . date('d-m-Y',strtotime($txtFecha_hasta));
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/filtrar_cuentas_cobrar_resumen', $data, true);

        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde==$txtFecha_hasta)? "De: ".date('d-m-Y',strtotime($txtFecha_desde)):"De: ".$data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=cuenta_cobrar_resumen".date('d-m-Y_His').".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='3' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='3' align='center' >Reporte Cuentas a Cobrar Resumen</th></tr>
                  <tr><th colspan='3' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Cuentas a Cobrar Resumen <br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'cuentas_cobrar','Letter');
                die();
            }
        }
        echo json_encode(array('html'=>$html));

    }

    /**
    * @author René Castaneda
    * @since 2017-06-14
    * @return cración del proximo cobro a la deuda del cliente
    */
    public function proximo_pago($id_cli, $id_fac = ""){
        satelite_validar();
        $serie = "";
        $where = array('cli_id' => $id_cli);
        if ($id_fac > 0) {
            $where['fac_id'] = $id_fac;
            $serie = $this->facturacion_model->get_serie_padre($id_fac);
            $this->db->join('fac_factura', 'fac_id_cli = cli_id');
        }
        $registro = $this->gsatelite->get_tabla('cli_cliente',$where);
        $data['factura'] = $id_fac;
        $data['registro'] = $registro[0];
        $data['num_factura'] = (is_array($serie)) ? $serie[0]['serie_numero'] : $serie;
        $cliente = ($registro[0]['cli_personeria'] > 1)?$registro[0]['cli_apellido']:$registro[0]['cli_nombre'].' '.$registro[0]['cli_apellido'];
        if ($id_fac > 0) {
            $columnas = array('scc_id_tsg', 'scc_fecha', 'scc_fecha_proximo', 'ultimaf', 'scc_comentario', 'scc_estado');
        } else {
            $columnas = array('scc_id_tsg', 'scc_fecha', 'facturas', 'scc_fecha_proximo', 'ultimac', 'scc_comentario', 'scc_estado');
        }        
        $displays = array(
            'scc_id_tsg' => 'Tipo Seguimiento',
            'scc_fecha' => 'Fecha', 
            'scc_fecha_proximo' => 'Fecha Próximo', 
            'scc_comentario' => 'Comentarios', 
            'scc_estado' => 'Estado',
            'ultimaf' => 'Último seg. (' . $cliente . ')',
            'ultimac' => 'Último seg. (' . $cliente . ')',
            'facturas' => 'Factura'
        );
        $agregar = array(
            'scc_id_cli',
            'scc_id_fac',
            'scc_id_tsg',
            'scc_fecha',
            'scc_fecha_proximo',
            'scc_comentario',
            'scc_estado',
            'scc_usu_creacion',
            'scc_fecha_creacion',
            'scc_usu_modificacion',
            'scc_fecha_modificacion'
        );
        $editar = array(
            'scc_id_cli',
            'scc_id_fac',
            'scc_id_tsg',
            'scc_fecha_proximo',
            'scc_comentario',
            'scc_estado',
            'scc_usu_modificacion',
            'scc_fecha_modificacion'
        );
        $idfactura = ($id_fac > 0) ? $id_fac : "";
        $crud = new grocery_CRUD();
        $crud->set_table('scc_seguimiento_cxc')
            ->set_subject('Seguimiento')
            ->columns($columnas)
            ->add_fields($agregar)
            ->edit_fields($editar)
            ->display_as($displays)
            ->required_fields('scc_id_cli', 'scc_id_tsg', 'scc_fecha', 'scc_fecha_proximo', 'scc_comentario', 'scc_estado')
            ->set_relation('scc_id_tsg', 'tsg_tipo_seguimiento', 'tsg_nombre')
            ->field_type('scc_id_cli', 'hidden', $id_cli)
            ->field_type('scc_id_fac', 'hidden', $idfactura)
            ->field_type('scc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('scc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('scc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('scc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->callback_column('facturas', function ($value, $row) {
                $datofactura = ($row->scc_id_fac > 0) ? $this->facturacion_model->get_serie_padre($row->scc_id_fac) : "";
                if (is_array($datofactura)) {
                    return '<label>' . $datofactura[0]['serie_numero'] . '</label>';
                } else {
                    return '<label></label>';
                }
            })
            ->callback_column('scc_fecha', function ($value, $row) {
                $urlFull = explode("/", $_SERVER['REQUEST_URI']);
                if (in_array("print", $urlFull) || in_array("export", $urlFull)) {
                    return formatear_fecha('d-m-Y', $row->scc_fecha);
                } else {
                    return '<span style="display: none;">' . formatear_fecha('YmdHis', $row->scc_fecha) . '</span>' . formatear_fecha('d-m-Y', $row->scc_fecha);
                }
            })
            ->callback_column('ultimaf', function ($value, $row) {
                $ultimo = $this->gsatelite->get_max('scc_seguimiento_cxc', 'scc_fecha', array('scc_id_cli' => $row->scc_id_cli, 'scc_id_fac' => $row->scc_id_fac));
                return  formatear_fecha('d-m-Y', $ultimo);
            })
            ->callback_column('ultimac', function ($value, $row) {
                $ultimo = $this->gsatelite->get_max('scc_seguimiento_cxc', 'scc_fecha', array('scc_id_cli' => $row->scc_id_cli));
                return  formatear_fecha('d-m-Y', $ultimo);
            })
            ->callback_column('scc_fecha_proximo', function ($value, $row) {
                $urlFull = explode("/", $_SERVER['REQUEST_URI']);
                if (in_array("print", $urlFull) || in_array("export", $urlFull)) {
                    return formatear_fecha('d-m-Y', $row->scc_fecha_proximo);
                } else {
                    return '<span style="display: none;">' . formatear_fecha('Ymd', $row->scc_fecha_proximo) . '</span>' . formatear_fecha('d-m-Y', $row->scc_fecha_proximo);
                }
            })
            ->callback_add_field('scc_fecha', function () {
                return '<input type="text" id="field-scc_fecha" readonly name="scc_fecha">';
            })
            ->callback_add_field('scc_fecha_proximo', function () {
                return '<input type="text" id="field-scc_fecha_proximo" name="scc_fecha_proximo" autocomplete="off" class="datePicker">';
            })
            ->callback_before_insert(function ($post_array) {
                $hora_act = date('H:i:s');
                $post_array['scc_fecha'] = formatear_fecha('Y-m-d', $post_array['scc_fecha']) . ' ' . $hora_act;
                $post_array['scc_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['scc_fecha_proximo']);
                $date1 = date('Y-m-d', strtotime($post_array['scc_fecha']));
                $date2 = date('Y-m-d', strtotime($post_array['scc_fecha_proximo']));
                if ($date1 <= $date2) {
                    return $post_array;
                } else {
                    return FALSE;
                }
            })
            ->callback_after_insert(function ($post_array, $primary_key) {
                // TEMPORALMENTE ACTUALIZAR LOS DATOS EN LA FACTURA MIENTRAS SE CAMBIA EL REPORTE
                $update_cliente = array(
                    'cli_fecha_cobro' => $post_array['scc_fecha_proximo'],
                    'cli_fecha_seguimiento_cobro' => $post_array['scc_fecha'],
                    'cli_comentario_seguimiento' => trim($post_array['scc_comentario']),
                    'cli_usu_mod' => $this->tank_auth->get_user_id(),
                    'cli_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cli_cliente', $update_cliente, array('cli_id' => $post_array['scc_id_cli']));
                if ($post_array['scc_id_fac'] > 0) {
                    $update_factura = array(
                        'fac_fecha_prox_cobro' => $post_array['scc_fecha_proximo'],
                        'fac_fecha_seguimiento_cobro' => $post_array['scc_fecha'],
                        'fac_comentario_seguimiento' => trim($post_array['scc_comentario']),
                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                        'fac_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('fac_factura', $update_factura, array('fac_id' => $post_array['scc_id_fac']));
                }
                return true;
            })
            ->callback_edit_field('scc_fecha_proximo', function ($value, $primary_key) {
                $frealizado = $this->gsatelite->get_campo('scc_seguimiento_cxc', 'scc_fecha', array('scc_id' => $primary_key));
                return '<input type="text" id="field-scc_fecha_proximo" name="scc_fecha_proximo" value="' . formatear_fecha('d-m-Y', $value) . '" class="datePicker" autocomplete="off"><input type="hidden" id="fecha_realizo" value="' . formatear_fecha('d-m-Y', $frealizado) . '">';
            })
            ->callback_before_update(function ($post_array, $primary_key) {
                $post_array['scc_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['scc_fecha_proximo']);
                $frealizado = $this->gsatelite->get_campo('scc_seguimiento_cxc', 'scc_fecha', array('scc_id' => $primary_key));
                $date1 = date('Y-m-d', strtotime($frealizado));
                $date2 = date('Y-m-d', strtotime($post_array['scc_fecha_proximo']));
                if ($date1 <= $date2) {
                    return $post_array;
                } else {
                    return FALSE;
                }
            })
            ->callback_after_update(function ($post_array, $primary_key){
                // TEMPORALMENTE ACTUALIZAR LOS DATOS EN LA FACTURA MIENTRAS SE CAMBIA EL REPORTE
                $update_cliente = array(
                    'cli_fecha_cobro' => $post_array['scc_fecha_proximo'],
                    'cli_fecha_seguimiento_cobro' => $post_array['scc_fecha'],
                    'cli_comentario_seguimiento' => trim($post_array['scc_comentario']),
                    'cli_usu_mod' => $this->tank_auth->get_user_id(),
                    'cli_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cli_cliente', $update_cliente, array('cli_id' => $post_array['scc_id_cli']));
                if ($post_array['scc_id_fac'] > 0) {
                    $update_factura = array(
                        'fac_fecha_prox_cobro' => $post_array['scc_fecha_proximo'],
                        'fac_fecha_seguimiento_cobro' => $post_array['scc_fecha'],
                        'fac_comentario_seguimiento' => trim($post_array['scc_comentario']),
                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                        'fac_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('fac_factura', $update_factura, array('fac_id' => $post_array['scc_id_fac']));
                }
                return true;
            })
        ;
        $crud->where('scc_id_cli', $id_cli);
        if ($id_fac > 0) {
            $crud->where('scc_id_fac', $id_fac);
        }
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('scc_estado', 'hidden', 1);
        } else {
            $crud->field_type('scc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->unset_delete();//->unset_export()->unset_print();
        $output = $crud->render();
        $this->gsatelite->cargar_vista_masterpage('modulo_cuentas_cobrar/procesos/proximo_pago', $data, $output);
    }

    /**
    * @author Habby Lovo
    * @since 2017-06-14
    * @return Vista de los pagos
    */
    function crear_pago($cliente = null, $factura = null, $modulo = null, $otro_modulo = null){
        if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {
            $datos["titulo_personal"] = "Pagos";
            /*
                Se cargan los datos de los clientes que tengan facturas, si viene de una factura, el cliente y la factura se filtran en la consulta
                para mostrar solo un registro del cliente que se le hizo la factura.
                si se viene de la grid de pagos, el cliente no se selecciona y no se muestra nada en la grid de las facturas, se tendria
                que seleccionar en la grid el cliente para mostrar todas sus facturas.
                si se modifica seleccionando un cliente especifico se cargan las facturas de dicho cliente seleccionado
            */
            /*$select = '';
            $disable_select_cliente = 0;
            $clientes_drop = $this->facturacion_model->get_datos_garantia(array('fac_monto_pendiente <>'=>0), 'fac_id_cli');
            foreach ($clientes_drop as $key) {
                if($cliente == $key['cli_id']){
                    $disable_select_cliente = 1 ;
                    $select .= '<option value="' . $key['cli_id'] . '" selected>'.$key['cli_codigo'].' - '.trim($key['cli_nombre'].' '.$key['cli_apellido']).'</option>';
                } else{
                    $select .= '<option value="' . $key['cli_id'] . '">'.$key['cli_codigo'].' - '.trim($key['cli_nombre'].' '.$key['cli_apellido']).'</option>';
                }
            }
            //desabilita el cliente para que no se pueda cambiar en caso que venga de una factura
            $datos['disable_cliente'] = $disable_select_cliente;
            $datos['clientes'] = $select;*/
            //obtener fecha de caja
            $where_fecha_caja   = array(
                "uxc_estado" => 1,
                "uxc_tipo" => 1,
                "uxc_id_usu" => $this->tank_auth->get_user_id()
            );
            $this->db->limit(1);
            $fecha_caja = $this->gsatelite->get_campo("uxc_usuarioxcaja","uxc_fecha_proceso",$where_fecha_caja );
            $this->db->limit(1);
            $fecha_caja_create  = $this->gsatelite->get_campo("uxc_usuarioxcaja","uxc_fecha_crea",$where_fecha_caja );
            $fecha_caja = ( $fecha_caja != null )? formatear_fecha('d-m-Y',  $fecha_caja):date('d-m-Y');
            $date1 = formatear_fecha('d-m-Y', $fecha_caja_create);
            $date2 = date('d-m-Y', time());
            $date3 = formatear_fecha('d-m-Y', $fecha_caja);
            $datos['validar_fecha_caja'] = (($date2 <= $date1 || $date3 >= $date2) ? 1 : 2);
            $factura_detalle = array();
            $anticipo_cliente   = "";
            //de donde viene las facturas
            $tipo = 1;
            $datos['tipopago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_estado' => 1, 'tpg_defecto' => 1));
            // var_dump($cliente);die();
            //si se selcciona el cliente y la factura, muestra solo el detalle de la factura seleccionada, si viene de la factura
            if($cliente != null && $factura != null){
                $tipo = 3;
                $factura_detalle = $this->facturacion_model->get_datos_pagos(array('cli_id'=>$cliente, 'fac_id'=>$factura, 'fac_estado'=>1));
                $datos['tipopago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_id' => $factura_detalle[0]['fac_id_tpg']));
            } else if($cliente != null){
                $tipo = 2;
                //si el cliente se selecciono anteriormente cargaria las facturas de dicho cliente
                $anticipo_cliente = $this->obtener_anticipo_editar($cliente);
                $factura_detalle = $this->facturacion_model->get_datos_pagos(array('cli_id'=>$cliente, 'fac_estado'=>1));
                $cli_row = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cliente));
                if ($cli_row[0]['cli_id_tpg'] > 0) {
                   $datos['tipopago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_id' => $cli_row[0]['cli_id_tpg']));
                } else {
                    $datos['tipopago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_estado' => 1, 'tpg_defecto' => 1));
                }
            }
            $arreglo = $this->obtener_detalle_factura_seleccionada($factura_detalle, $factura);
            $datos['fecha_caja']    = $fecha_caja;
            $datos['tipo_pago']     = $tipo;
            $datos['cliente']       = $cliente;
            $datos['datos_cliente'] = ($cliente != "")? $this->gsatelite->get_tabla("cli_cliente",array("cli_id" => $cliente)):"";
            $datos['factura']       = $factura;
            $datos['tabla_factura'] = $arreglo['tabla'];
            $datos['total_saldo'] = $arreglo['total_saldo'];
            $datos['total_monto'] = $arreglo['total_monto'];
            $datos['total_retencion'] = $arreglo['total_retencion'];
            $datos['anticipos_cliente'] = $anticipo_cliente;
            //$datos['factura_detalle'] = $factura_detalle;
            $datos['total_facturas'] = count($factura_detalle);
            $tipo_pag_drop = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado'=>1), null, '', 'tpg_id', true);
            $datos['slc_tipo_pago'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_pag_drop);
            $tipo_pag_drop = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado'=>1), null, '', 'tpg_id', true);
            $datos['slc_sucursal'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_pag_drop);
            /* Se cambio Tipo de Pago por Formas de pago */
            $forma_pago_drop = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado'=>1), ((count($factura_detalle) == 1)?$factura_detalle[0]['fac_id_frp']:null), '', 'frp_id', true);
            $datos['formas_pago'] = str_replace('<option value="0">Seleccione</option>', '', $forma_pago_drop);
            $banco_drop = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado'=>1), null, '', 'ban_id', true);
            $datos['bancos'] = str_replace('<option value="0">Seleccione</option>', '', $banco_drop);
            $transaccion            = $this->gsatelite->get_dropdown('ttb_tipo_transact_bancaria', '{ttb_nombre}', '', array('ttb_estado'=>1,'ttb_deposito' => 1), null, '', 'ttb_id', true);
            $transaccion            = str_replace('<option value="0">Seleccione</option>', '', $transaccion);
            $datos['transaccion']   = str_replace('<option value="0">Sin Registros</option>', '', $transaccion);
            $select = '';
            $gestor_cobros_drop = $this->facturacion_model->get_cobrador(array('cob_estado'=>1));
            foreach ($gestor_cobros_drop as $key) {
                $select .= '<option value="'.$key['cob_id'].'">'.$key['cob_codigo'].' - '.trim(($key['cob_nombre'].$key['cob_apellido'])).'</option>';
            }
            $datos['cobrador'] = $select;
            $tipo_comprobante = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_tipo'=>2,'tif_estado'=>1), null, '', 'tif_id', true);
            $datos['tipo_comprobante'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_comprobante);
            $datos['sugerido'] = (($this->gsatelite->get_max('abc_abono_cliente','abc_id'))+1);                            
            if($factura!=null){
                $total = $this->gsatelite->get_campo('fac_factura', 'fac_total', array('fac_id'=>$factura));
                $retencion = $this->gsatelite->get_campo('fac_factura', 'fac_total_retencion', array('fac_id'=>$factura));
                $datos['total'] = $total - $retencion;
                $abono = $this->gsatelite->get_campo('fac_factura', 'fac_monto_abono', array('fac_id'=>$factura));
                if($abono>0){
                    $datos['abono'] = $abono;
                }else{
                    $datos['abono'] = 0;
                }
            }

            if($otro_modulo!=null ){
                if($otro_modulo==3){ $datos['tipo_pago']=3; }
                return $datos;
            } else{
                $uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
                $uri_segments = explode('/', $uri_path);
                if ($uri_segments[2] == "modulo_cuentas_cobrar") {
                    $datos['fecha_caja'] = date("d-m-Y");
                }
                //print_r($datos);
                //die();
                cargarvista($datos);
            }
        }
    }

    function obtener_detalle_factura_seleccionada($factura_detalle, $factura = null){

        $total_monto = 0;
        $total_retencion = 0;
        $total_saldo = 0;
        if(trim($factura) != null){
            $seleccionado = (count($factura_detalle) != 1)?(""):"checked";
            $seleccionado_displ = (count($factura_detalle) != 1)?(""):"style='display:none;'";
            $seleccionado_read = (count($factura_detalle) != 1)?(""):"nostyle";
            $readonly = (count($factura_detalle) != 1)?("readonly"):"";
        } else{
            $seleccionado = "";
            $seleccionado_displ = "";
            $seleccionado_read = "";
            $readonly = "readonly";
        }


        $tabla = "";
        $facturas = "";
        foreach ($factura_detalle as $key) {

            if(count($factura_detalle) == 1 && trim($factura) != null){
                $total_monto += $key['fac_monto_pendiente'];
                $total_retencion += $key['fac_total_retencion'];
            }

            $facturas .= $key['fac_id'].',';
            $label_retencion = trim($key['fac_total_retencion']);
            $input_retencion = $key['fac_total_retencion'];
            if($key['fac_retencion_abono'] != 0){
                $label_retencion = "0.00";
                $input_retencion = "0.00";
                $total_retencion = 0;
            }
            $lbltotal = $key['fac_total']-$input_retencion;
            $div_retencion = $this->crear_detalle_retencion($key['fac_id'], $key['fac_total_retencion']);
            $retencion = '<a class="icon-table detalle_fanc_retencion" style="cursor:pointer;margin-right:11%;" id="agregar_retencion" href="#retencion_'.$key['fac_id'].'"><span class="icon16 icomoon-icon-list-view-2"></span></a>';
            $tabla .= '<tr>
                            <td>
                                <label>'.trim($key['cli_nombre'].' '.$key['cli_apellido']).'</label>
                                <input type="hidden" name="dtf_factura[]" id="dtf_factura" value="'.$key['fac_id'].'">
                            </td>
                            <td><label>'.trim($key['suc_nombre']).'</label></td>
                            <td><label>'.trim($key['ven_nombre'].' '.$key['ven_apellidos']).'</label></td>
                            <td>
                                <label>'.trim($key['tif_nombre']).'</label>
                                <input type="hidden" name="dtf_tipo_factura[]" id="dtf_tipo_factura" value="'.$key['tif_nombre'].'">
                            </td>
                            <td><label>'.trim($key['fac_numero']).'</label></td>
                            <td><label>'.((trim($key['fac_fecha_cont']) != "")?date('d/m/Y',strtotime(trim($key['fac_fecha_cont']))):"").'</label></td>
                            <td><label>'.$key['fac_subtotal'].'</label></td>
                            <td><label>'.$key['fac_impuesto'].'</label></td>
                            <td>
                                <label id="dtf_text_retencion_'.$key['fac_id'].'">$'.$label_retencion.'</label>
                                <input type="hidden"  name="dtf_retencion[]" id="dtf_retencion_'.$key['fac_id'].'" value="'.$input_retencion.'">
                                <input type="hidden" name="dtf_retencion_original[]" value="'.$key['fac_total_retencion'].'">
                                <input type="hidden" name="dtf_retencion_flag[]" value="'.$key['fac_retencion_abono'].'">
                                <input type="hidden" id="validar_retencion_'.$key['fac_id'].'" value=0>
                            </td>
                            <td>
                                <label>$'.$lbltotal.'</label>
                                <input type="hidden" name="dtf_monto[]" id="dtf_monto_'.$key['fac_id'].'" value="'.$key['fac_monto_pendiente'].'">
                                <input type="hidden" name="dtf_monto_abono[]" value="'.$key['fac_monto_abono'].'">
                            </td>
                            <td>
                                <input type="text" class="numerico dtf_pago soloDecimales" name="dtf_pago[]" id="dtf_pago_'.$key['fac_id'].'" placeholder="0.00" fac="'.$key['fac_id'].'" max="'.($key['fac_monto_pendiente']-$input_retencion).'" style="width: 80px" ret="'.$input_retencion.'" monto="'.$key['fac_monto_pendiente'].'" '.$readonly.'>
                                <input type="hidden" id="dtf_pago_temp_'.$key['fac_id'].'"  value = "0" style="width: 80px">
                                <input type="hidden" class="dtf_cambio_pago" value="0">
                            </td>
                            <td><label id="dtf_text_saldo_'.$key['fac_id'].'">$'.($key['fac_monto_pendiente']-$input_retencion).'</label></td>
                            <td style="text-align:center">
                                <input type="checkbox" name="dtf_select_factura_'.$key['fac_id'].'" fac="'.$key['fac_id'].'" id="dtf_select_factura_'.$key['fac_id'].'" class="select_factura_pag '.$seleccionado_read.'" '.$seleccionado_displ.' '.$seleccionado.'>
                                '.$retencion.$div_retencion['div_retencion'].'
                            </td>
                        </tr>';
        }
        $total_saldo = $total_monto - $total_retencion;
        $arreglo = array('tabla'=>$tabla, 'total_monto'=>$total_monto, 'total_retencion'=>$total_retencion, 'total_saldo'=>$total_saldo);
        return $arreglo;
        //echo json_encode(array('tabla'=> $tabla));
    }

    function obtener_detalle_factura(){
        $cli_id                 = $this->input->post('cliente');
        $forma_facturacion      = ($this->input->post('forma_facturacion')  != false )?$this->input->post('forma_facturacion'):"";
        $sucursal = ($this->input->post('sucursal') > 0 )?$this->input->post('sucursal'):null;
        $where = null;

        $where['cli_id']        = $cli_id;
        $where['fac_estado']    = 1;
        $where['fac_id_tpg IS NOT NULL'] = null;

        if ($sucursal != null) {
            $where['scl_id'] = $sucursal;
        }

        if ($forma_facturacion != "" OR  $forma_facturacion != null) {
            $forma_facturacion              = ($forma_facturacion != 2)?$forma_facturacion:null;
            $where['fac_generacion_masiva'] = $forma_facturacion ;
        }
        // SE QUITAN LAS NOTAS DE REMISIONYSI SE DEBEN QUITAR MAS, SE DEBEN AGREGAR AL "NOT IN()""
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        // TIPO PAGO DEL CLIENTE
        $datos_cliente = $this->gsatelite->get_tabla("cli_cliente",array("cli_id" => $cli_id));
        $tpg = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_id' => $datos_cliente[0]['cli_id_tpg']));
        $tipopag = $tpg[0]['tpg_nombre'];
        // LAS NOTAS DE REMISION NO DEBEN SALIR PUES DEPENDEN O DEPENDERAN DE OTRA FACTURA QUE SI FUE O SERA COBRADA
        $not_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
        $where["fac_id_tif NOT IN ($not_remi)"] = null;

        $tipopago = "";
        if (!empty($tpg)) {
            $tipopago = $tipopag;
        }
        $factura_detalle = $this->facturacion_model->get_datos_pagos($where);
        $tabla = "";
        $facturas = "";
        foreach ($factura_detalle as $key) {
            $facturas .= $key['fac_id'].',';
            $label_retencion = trim($key['fac_total_retencion']);
            $input_retencion = $key['fac_total_retencion'];
            if($key['fac_retencion_abono'] != 0){
                $label_retencion = "0.00";
                $input_retencion = "0.00";
            }
            $div_retencion = $this->crear_detalle_retencion($key['fac_id'], $key['fac_total_retencion']);
            
            if ($key['fac_monto_pendiente']-$input_retencion == 0) {
               $maxx  = $key['fac_monto_pendiente'];
               $maxx2 = $key['fac_monto_pendiente'];
            }else{
               $maxx  = $key['fac_monto_pendiente']-$input_retencion;
               $maxx2 = $key['fac_monto_pendiente']-$input_retencion;
            }
            $lbltotal = $key['fac_total']-$input_retencion;

            $retencion = '<a class="icon-table detalle_fanc_retencion" style="cursor:pointer;" id="agregar_retencion" href="#retencion_'.$key['fac_id'].'"><span class="icon16 icomoon-icon-list-view-2"></span></a>';
            $tabla .= '<tr>
                            <td>
                                <label>'.trim($key['nombre']).'</label>
                                <input type="hidden" name="dtf_factura[]" id="dtf_factura" value="'.$key['fac_id'].'">
                            </td>
                            <td><label>'.trim($key['suc_nombre']).'</label></td>
                            <td><label>'.trim($key['ven_nombre'].' '.$key['ven_apellidos']).'</label></td>
                            <td>
                                <label>'.trim($key['tif_nombre']).'</label>
                                <input type="hidden" name="dtf_tipo_factura[]" id="dtf_tipo_factura" value="'.$key['tif_nombre'].'">
                            </td>
                            <td><label>'.trim($key['fac_numero']).'</label></td>
                            <td><label>'.((trim($key['fac_fecha_cont']) != "")?date('d/m/Y',strtotime(trim($key['fac_fecha_cont']))):"").'</label></td>
                            <td><label>'.$key['fac_subtotal'].'</label></td>
                            <td><label>'.$key['fac_impuesto'].'</label></td>
                            <td>
                                <label id="dtf_text_retencion_'.$key['fac_id'].'">$'.$label_retencion.'</label>
                                <input type="hidden" class="dtf_retencionx" name="dtf_retencion[]" id="dtf_retencion_'.$key['fac_id'].'" value="'.$input_retencion.'">
                                <input type="hidden" name="dtf_retencion_original[]" value="'.$key['fac_total_retencion'].'">
                                <input type="hidden" name="dtf_retencion_flag[]" value="'.$key['fac_retencion_abono'].'">
                                <input type="hidden" id="validar_retencion_'.$key['fac_id'].'" value=0>
                            </td>
                            <td>
                                <label>$'.$lbltotal.'</label>
                                <input type="hidden" name="dtf_monto[]" id="dtf_monto_'.$key['fac_id'].'" value="'.$key['fac_monto_pendiente'].'">
                                <input type="hidden" name="dtf_monto_abono[]" value="'.$key['fac_monto_abono'].'">
                            </td>
                            <td> 
                                <input type="text" class="numerico dtf_pago soloDecimales" name="dtf_pago[]" id="dtf_pago_'.$key['fac_id'].'" placeholder="0.00" fac="'.$key['fac_id'].'" max="'.$maxx.'" style="width: 80px" ret="'.$input_retencion.'" monto="'.$key['fac_monto_pendiente'].'" readonly>
                                <input type="hidden" id="dtf_pago_temp_'.$key['fac_id'].'"  value = "0" style="width: 80px">
                                <input type="hidden" class="dtf_cambio_pago" value="0">
                            </td>
                            <td><label id="dtf_text_saldo_'.$key['fac_id'].'">$'.$maxx2.'</label></td>
                            <td>
                                <input type="checkbox" name="dtf_select_factura_'.$key['fac_id'].'" fac="'.$key['fac_id'].'" id="dtf_select_factura_'.$key['fac_id'].'" class="select_factura_pag nostyle">
                                '.$retencion.$div_retencion['div_retencion'].'
                            </td>
                        </tr>';
        }

        echo json_encode(array('tabla'=> $tabla, 'tipopago' => $tipopago));
    }

    function obtener_anticipo(){
        /*************************************************************************************************/
        //actualizar todos los anticipos vencidos.
        /*************************************************************************************************/
        $this->gsatelite->actualizar_array('anl_anticipo_cliente',array('anl_estado'=> 0),array('DATE(anl_fecha_vencimiento) <' => date('Y-m-d')) );
        //actualizar todos los comprobantes vencidos.
        /*************************************************************************************************/
        $this->gsatelite->actualizar_array('cmd_comprobante_descuento',array('cmd_estado_comprobante'=> 3,'cmd_estado'=> 0),array('DATE(cmd_fecha_vencimiento) <' => date('Y-m-d')) );
        /*************************************************************************************************/

        $cli_id = $this->input->post('cliente');
        $this->db->order_by('anl_fecha_vencimiento','ASC');
        $this->db->order_by('anl_id','ASC');//ordenar del más antiguo.
        $this->db->order_by('anl_saldo','DESC');
        $anticipos_reg = $this->gsatelite->get_tabla('anl_anticipo_cliente', array('anl_estado'=>1, 'anl_id_cli'=>$cli_id));
        //$caracteristicas = $this->inventario_model->get_caracteristica_factura(array('cxu_id_art'=>$id_art, 'cxu_estado'=>1));
        //$formulas = $this->inventario_model->get_formulas();

        $sin_reg = '<tr><th style="text-align:center;">Sin Anticipos</th></tr>';
        $tipo = 0;
        if(count($anticipos_reg) > 0){
            $tipo = 1;
            $sin_reg = '<tr >
                            <th>
                                Fecha
                            </th>
                            <th>
                                Monto
                            </th>
                            <th>
                                Saldo
                            </th>
                            <th>
                                Concepto
                            </th>
                            <th>
                                Comprobante
                            </th>
                            <th>
                                Aplicar
                            </th>
                            <th>
                                F. vencimiento
                            </th>
                        </tr>';
        }

        $tabla = '<table width="100%" class="responsive table table-bordered" id="tabla_anticipo_'.$cli_id.'" style="font-size:14px;">
                    <thead>
                        '.$sin_reg.'
                    </thead>
                    <tbody id="contenedor_anticipo">
        ';

        foreach ($anticipos_reg as $key) {
            $tabla .= '<tr>';
            $tabla .= '<td>'.formatear_fecha('d-m-Y',$key['anl_fecha']).'</td>';
            $tabla .= '<td>$'.$key['anl_monto'].'</td>';
            $tabla .= '<td>$'.$key['anl_saldo'].'</td>';
            $tabla .= '<td>'.$key['anl_descripcion'].'</td>';
            $tabla .= '<td>'.$key['anl_comprobante'].'</td>';
            $tabla .= '<td style="width:50px">
                            <input type="checkbox" name="anticipo_clien[]" value="'.$key['anl_id'].'" monto="'.$key['anl_saldo'].'" class="anticipos_clien" style="transform: scale(1.3);">
                            <input type="hidden" name="anticipo_saldo_'.$key['anl_id'].'" value="'.$key['anl_saldo'].'">
                        </td>';
            $tabla .= '<td>'. formatear_fecha('d-m-Y',$key['anl_fecha_vencimiento']).'</td>';
        }
        $tabla .= '</tbody></table>';

        echo json_encode(array('tabla'=>$tabla));
    }

    function obtener_anticipo_editar($cli_id){
        $this->db->order_by('anl_saldo','DESC');
        $this->db->order_by('anl_id','ASC');//ordenar del más antiguo.
        $this->db->order_by('anl_fecha','ASC');
        $anticipos_reg = $this->gsatelite->get_tabla('anl_anticipo_cliente', array('anl_estado'=>1, 'anl_id_cli'=>$cli_id));

        //$caracteristicas = $this->inventario_model->get_caracteristica_factura(array('cxu_id_art'=>$id_art, 'cxu_estado'=>1));
        //$formulas = $this->inventario_model->get_formulas();

        $sin_reg = '<tr><th style="text-align:center;">Sin Anticipos</th></tr>';
        $tipo = 0;
        if(count($anticipos_reg) > 0){
            $tipo = 1;
            $sin_reg = '<tr>
                            <th>
                                Fecha
                            </th>
                            <th>
                                Monto
                            </th>
                            <th>
                                Saldo
                            </th>
                            <th>
                                Concepto
                            </th>
                            <th>
                            </th>
                        </tr>';
        }

        $tabla = '<table width="100%" class="responsive table table-bordered" id="tabla_anticipo_'.$cli_id.'" style="font-size:14px;">
                    <thead>
                        '.$sin_reg.'
                    </thead>
                    <tbody id="contenedor_anticipo">
        ';

        foreach ($anticipos_reg as $key) {
            $tabla .= '<tr>';
            $tabla .= '<td>'.formatear_fecha('d-m-Y',$key['anl_fecha']).'</td>';
            $tabla .= '<td>$'.$key['anl_monto'].'</td>';
            $tabla .= '<td>$'.$key['anl_saldo'].'</td>';
            $tabla .= '<td>'.$key['anl_descripcion'].'</td>';
            $tabla .= '<td style="width:50px">
                            <input type="checkbox" name="anticipo_clien[]" value="'.$key['anl_id'].'" monto="'.$key['anl_saldo'].'" class="anticipos_clien" style="transform: scale(1.3);">
                            <input type="hidden" name="anticipo_saldo_'.$key['anl_id'].'" value="'.$key['anl_saldo'].'">
                        </td>';
        }
        $tabla .= '</tbody></table>';

        return $tabla;
    }

    //factura
    function crear_detalle_retencion($fac_id, $ret_actual){
        $registros_factura = $this->facturacion_model->get_productos_factura(array('def_id_fac'=>$fac_id));

        $tabla_comprobantes = $this->obtener_comprobantes_facturas($fac_id);
        $mostrar_retenciones = 0;
        $suma_monto = $ret_actual;

        //$retenciones_por_actu = 0;
        if(trim($tabla_comprobantes['tabla']) != ""){
            //$retenciones_por_actu = $tabla_comprobantes['suma'];
            $mostrar_retenciones = 1;
            $suma_monto = $tabla_comprobantes['suma'];
        }
        /*echo "<p>";
        print_r($registros_factura);
        echo "</p>";*/
        $div_retencion = '<div id="retencion_'.$fac_id.'" style="display:none">
                            <div class="box">
                                <div class="title">
                                    <h4><span>Retención</span></h4>
                                </div>
                                <div class="content">
                                    <div class="form-row row-fluid">
                                        <div class="span12">
                                            <div class="span6">
                                                <div class="row-fluid">
                                                    <label class="span4" style="padding-top: 1%">Comprobante:</label>
                                                    <div class="span7 controls">
                                                        <input type="text" id="comprobante_'.$fac_id.'">
                                                        <div id="comprobante_'.$fac_id.'_error" style="color:red;padding-top:1%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="span4">
                                                <div class="row-fluid">
                                                    <label class="span4" style="padding-top: 1%">Fecha:</label>
                                                    <div class="span7 controls">
                                                        <input type="text" id="fecha_'.$fac_id.'" class="fecha_general" value="'.date('d-m-Y').'">
                                                        <div id="fecha_'.$fac_id.'_error" style="color:red;padding-top:1%;"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="tabla_detalle_monto">
                                            <table width="100%" class="responsive table table-bordered" style="font-size:14px;">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 5% !important;display:none"></th>
                                                        <th>Cod.</th>
                                                        <th>Descripción</th>
                                                        <th>Subtotal</th>
                                                        <th>Retención</th>
                                                        <th style="width: 30% !important;">Tipo ret</th>
                                                        <th>Acción</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="body_detalle_retencion">';
        foreach ($registros_factura as $key) {
            $retenciones_por_actu = 0;

            $retencion_numero = $key['def_retencion'];
            $retencion_porcentaje_actual = $key['def_porcentaje_retencion'];
            $retencion_porcentaje_indi = $key['porcentaje'];
            if(trim($tabla_comprobantes['tabla']) != ""){

                $retencion_numero = number_format(0,2);
                $retencion_porcentaje_actual = number_format(0,2);

                $retencion_porcentaje_indi = "";

                $retenciones_por_actu = $tabla_comprobantes[$key['def_id']];
                //suma
                $mostrar_retenciones = 1;
            }
            $retencion_registros = $this->obtener_retenciones_pagos($key['def_id'], $key['art_id'], $mostrar_retenciones);
            $btn_guardar = '<button type="button" class="btn btn-primary btn-mini btn_guardar" id="btn_guar_'.$key['def_id'].'" detalle="'.$key['def_id'].'" factura="'.$fac_id.'" style="height: 30px; width: 50px; display: none;">
                                Guardar
                            </button>';
            $btn_editar = '<button type="button" class="btn btn-primary btn-mini btn_editar" id="btn_edit_'.$key['def_id'].'" detalle="'.$key['def_id'].'" style="height: 30px; width: 50px;" disabled>
                                Editar
                            </button>';
            $div_retencion .= '<tr>';
            $div_retencion .=   '<td style="display:none"><input checked="true" type="checkbox" name="checkbox_'.$fac_id.'_'.$key['def_id'].'" id="checkbox_detalle_'.$key['def_id'].'" class="nostyle check_actual" style="size: 20px" detalle="'.$key['def_id'].'"></td>';
            $div_retencion .=   '<td><label id="codigo_producto_ret_'.$key['def_id'].'">'.$key['art_codigo'].'</label> <input type="hidden" value="'.$key['def_id'].'" class="selecciones_detalles_retenciones_'.$fac_id.'" detalle="'.$key['def_id'].'"></td>';
            $div_retencion .=   '<td><label id="label_descripcion_prod_'.$key['def_id'].'">'.$key['def_descripcion'].'</label></td>';
            $div_retencion .=   '<td>
                                    <label id="label_retencion_total_'.$key['def_id'].'">$'.$key['def_subtotal'].'</label>
                                    <input type="hidden" id="input_retencion_total_'.$key['def_id'].'" value="'.$key['def_subtotal'].'">
                                </td>';
            $div_retencion .=   '<td>
                                    <label id="label_retencion_text_'.$key['def_id'].'">$'.$retencion_numero.'</label>
                                    <input type="hidden" id="input_retencion_text_'.$key['def_id'].'" value="'.$retencion_numero.'">
                                    <input type="hidden" id="retencion_porcentaje_actu_'.$key['def_id'].'" value = "'.$retencion_porcentaje_actual.'">
                                    <input type="hidden" id="retencion_porcentaje_indi_'.$key['def_id'].'" value = "'.$retencion_porcentaje_indi.'">
                                    <input type="hidden" id="retencion_porcentaje_acum_'.$key['def_id'].'" value = "'.$retenciones_por_actu.'">
                                </td>';
            $div_retencion .=   '<td>'.$retencion_registros['retencion_nombre'].$retencion_registros['retencion_select'].'</td>';
            $div_retencion .=   '<td style="text-align: center !important;">'.$btn_guardar.$btn_editar.'</td>';
            $div_retencion .= '</tr>';
        }
        $div_retencion .=                       '</tbody>
                                            </table>
                                        </div>

                                        <div class="span12" style="padding-bottom: 15px;">
                                            <div class="span12">
                                                <div class="row-fluid" align="right">
                                                    <button type="button" id="agregar_detalle_retencion_'.$fac_id.'" class="btn btn-success btn icomoon-icon-checkmark white agregar_detalle_retencion" style="font-size:12px;" factura = "'.$fac_id.'">Agregar</button>
                                                </div>
                                            </div>
                                        </div>

                                        <div id="tabla_detalle_comprobante_'.$fac_id.'">
                                            <input type="hidden" id="retencion_suma_acum_'.$fac_id.'" value = "'.$suma_monto.'">
                                            <input type="hidden" id="contador_comprobante_detall_'.$fac_id.'" value="'.$tabla_comprobantes['total_registro_tabla'].'">
                                            <input type="hidden" id="contador_acumulador'.$fac_id.'" name="contador_acumulador'.$fac_id.'" value="'.$tabla_comprobantes['acumulador_registro'].'">
                                            <table width="100%" class="responsive table table-bordered" style="font-size:14px;">
                                                <thead>
                                                    <tr>
                                                        <th>Comprobante</th>
                                                        <th style="width: 15% !important;">Cod.</th>
                                                        <th>Descripción</th>
                                                        <th>Subtotal</th>
                                                        <th>Retención</th>
                                                        <th style="width: 30% !important;">Tipo ret</th>
                                                        <th style="width: 12% !important;">Fecha</th>
                                                        <th>Acción</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="body_detalle_comprobante_'.$fac_id.'">
                                                    '.$tabla_comprobantes['tabla'].'
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>';
        $arreglo = array('div_retencion'=>$div_retencion);
        return $arreglo;
    }

    function obtener_comprobantes_facturas($fac_id){
        $comprobantes = $this->facturacion_model->get_comprobantes_factura(array('def_id_fac'=>$fac_id), 'cmr_id, def_id');
        $regresar = "";

        $arreglo = array();

        $suma_montos = 0;
        $acumulador = 0;
        $temp_cmr = "";
        $contador = 1;

        foreach ($comprobantes as $key) {
            $dat_retencion = explode('+', $key['retenciones']);

            $fecha_temp = ((trim($key['cmr_fecha']) != "")?date('d-m-Y',strtotime(trim($key['cmr_fecha']))):"");

            $retencion_con_por = $key['def_subtotal']*($dat_retencion[2]/100);
            $suma_montos += $retencion_con_por;

            if(empty($arreglo[''.$key['def_id'].'']) == 1){
                $arreglo[''.$key['def_id'].''] = 0;
            }
            $arreglo[''.$key['def_id'].''] += $dat_retencion[2];

            if(trim($temp_cmr) != trim($key['cmr_numero'])){
                $acumulador++;
            }
            $temp_cmr = $key['cmr_numero'];

            $id_comprobar = '<input type="hidden" name="existe'.$key['def_id'].$acumulador.'" value="1" />';
            $id_comprobante_reten = '<input type="hidden" id="comprobante_fac'.$fac_id.$key['cmr_numero'].'" name="comprobante_fac'.$fac_id.$acumulador.'[]" value="'.$key['cmr_numero'].'" />';
            $id_factura = '<input type="hidden" name="ret_def_'.$fac_id.$acumulador.'[]" value="'.$key['def_id'].'" />';
            $id_codigo_producto = '<input type="hidden" name="codigo_producto'.$key['def_id'].'[]" value="'.$key['art_codigo'].'" />';
            $id_descripcion_producto = '<input type="hidden" name="descripcion_producto'.$key['def_id'].'[]" value="'.$key['def_descripcion'].'" />';
            $id_total_producto = '<input type="hidden" name="total_producto'.$key['def_id'].$acumulador.'" value="'.$key['def_subtotal'].'" />';
            $id_retencion_porcentaje = '<input type="hidden" name="retencion_porcentaje'.$key['def_id'].$acumulador.'" value="'.$retencion_con_por.'" />';
            $id_retenciones_ids = '<input type="hidden" name="retenciones_ids'.$key['def_id'].$acumulador.'" value="'.$dat_retencion[0].'" />';
            $id_retenciones_por_ids = '<input type="hidden" name="retenciones_por_ids'.$key['def_id'].$acumulador.'" value="'.$dat_retencion[3].'" />';

            $id_fecha = '<input type="hidden" name="fecha_producto_det'.$acumulador.'[]" value="'.$fecha_temp.'" />';

            //$eliminar = '<a id="del_doc2" valor="'.$contador.'" thead="tabla_detalle_comprobante_'.$fac_id.'" tbody="body_detalle_comprobante_'.$fac_id.'" class="icon-remove white" style="margin-right: 5px;cursor:pointer;">&nbsp;</a>';
            $eliminar = '';

            $regresar .= '<tr id="filatabla_detalle_comprobante_'.$fac_id.$contador.'" >
                            <td>'. $id_comprobante_reten . $id_comprobar . $id_factura . $key['cmr_numero'] .'</td>
                            <td>'. $id_codigo_producto . $key['art_codigo'] . '</td>
                            <td>'. $id_descripcion_producto . $key['def_descripcion'] . '</td>
                            <td>$'. $id_total_producto . number_format($key['def_subtotal'],2) . '</td>
                            <td>$'. $id_retencion_porcentaje . number_format($retencion_con_por, 2) .'</td>
                            <td>'. $id_retenciones_ids . $id_retenciones_por_ids . $dat_retencion[1] . '</td>
                            <td>'. $id_fecha . $fecha_temp . '</td>
                            <td align="center"><div>'. $eliminar. '</div></td>
                        </tr>';
            $contador++;
        }
        $arreglo['tabla'] = $regresar;
        $arreglo['suma'] = $suma_montos;
        $arreglo['total_registro_tabla'] = $contador;
        $arreglo['acumulador_registro'] = ($acumulador+1);
        //print_r($arreglo);
        return $arreglo;
    }

    function obtener_retenciones_pagos($def_id, $art_id, $mostrar_ret){
        //$retenciones_reg = $this->facturacion_model->get_retencion_factura_productos(array('rxf_id_def'=>$def_id));
        $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        //retencion
        $retencion_array = array();
        $retencion_act_nombre = '';
        $retencion_act_producto = '';
        $retencion_array_act_producto = '';
        //$impuesto_cantidad_maxima = 0;
        $retencion_producto = $this->facturacion_model->get_retencion_factura_productos(array('rxf_id_def'=>$def_id));
        //$impuesto_producto = $this->gsatelite->get_tabla('ixt_impuestoxcotizacion', array('ixt_id_axc'=>$axc_id));
        foreach ($retencion_producto as $key2) {
            if($mostrar_ret == 0){
                $retencion_array[] = $key2['rxf_id_ret'];
                $retencion_act_nombre .= $key2['ret_nombre'].',';
                $retencion_act_producto .= $key2['rxf_id_ret'].',';
                $retencion_array_act_producto .= $key2['ret_porcentaje'].',';
            }
            //$impuesto_cantidad_maxima += $key2['imp_porcentaje'];
        }
        if($retencion_act_producto != ''){
            $retencion_act_nombre = substr($retencion_act_nombre, 0, -1);
            $retencion_act_producto = substr($retencion_act_producto, 0, -1);
            $retencion_array_act_producto = substr($retencion_array_act_producto, 0, -1);
        }
        $select = '<div style="display: none;" id="mostrar_retencion_div_'.$def_id.'">
        <select multiple="multiple" name="select_ret_'.$def_id.'[]" id="select_ret_'.$def_id.'" class="nostyle seleccione multiple_retencion" style="width: 100% !important;" placeholder="Seleccione">
        ';
        foreach ($retencion_campos as $key) {
            if($mostrar_ret == 0){
                if(in_array($key["ret_id"], $retencion_array)){
                    $select .= "<option porcentaje='".$key["ret_porcentaje"]."' value='".$key["ret_id"]."' selected>".$key["ret_nombre"]."</option>";
                } else{
                    $select .= "<option porcentaje='".$key["ret_porcentaje"]."' value='".$key["ret_id"]."'>".$key["ret_nombre"]."</option>";
                }
            } else{
                $select .= "<option porcentaje='".$key["ret_porcentaje"]."' value='".$key["ret_id"]."'>".$key["ret_nombre"]."</option>";
            }

        }
        $select .= "</select></div>";
        $regresar = array('retencion_select'=>$select, 'retencion_por'=>$retencion_array_act_producto, 'retencion_nombre'=>'<div id="mostrar_tretencion_div_'.$def_id.'">'.$retencion_act_nombre.'</div>');
        return $regresar;
    }

    function guardar_pago(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // var_dump($_POST);die();
            //registros individuales que no son arreglos
            //redirecciona a la grid o permanece en ella
            $redireccion    = (trim($this->input->post('redireccionar')) != "")?trim($this->input->post('redireccionar')):null; 
            $redireccion2   = (trim($this->input->post('redireccionar2')) != "")?trim($this->input->post('redireccionar2')):null;
            $cliente_id     = (trim($this->input->post('pag_cliente')) != "")?trim($this->input->post('pag_cliente')):null; //id del cliente
            $cobrador_id    = (trim($this->input->post('pag_cobrador')) != "")?trim($this->input->post('pag_cobrador')):null; //id del cobrador
            //se guarda el tipo comprobante de pago
            $tipo_comprobante_pago  = (trim($this->input->post('pag_tip_comprobante')) != "")?trim($this->input->post('pag_tip_comprobante')):null; 
            //# del comprobante 
            $comprobante_pago       = (trim($this->input->post('pag_comprobante')) != "")?trim($this->input->post('pag_comprobante')):null; 
            //# del recibo interno
            $recibo_interno         = (trim($this->input->post('pag_interno_recibo')) != "")?trim($this->input->post('pag_interno_recibo')):null; 
            //se guar el concepto de anticipo
            $concepto_anticipo      = (trim($this->input->post('txt_concepto_anticipo')) != "")?trim($this->input->post('txt_concepto_anticipo')):"Abono";
            $usa_anticipo = $continuidad_anticipo = false;
            //se guarda el monto individual de pago
            $monto_indivirual = (trim($this->input->post('pag_monto_abono')) != "")?trim($this->input->post('pag_monto_abono')):null; 
            $anticipos_total = (trim($this->input->post('pag_anticipo')) != "")?trim($this->input->post('pag_anticipo')):null; //total de anticipos
            //monto a abonar a todas las facturas
            $monto_total = (trim($this->input->post('pag_total_abonar')) != "")?trim($this->input->post('pag_total_abonar')):null; 
            //si existe detella del monto equivale a 1
            $aplica_detalle_monto = (trim($this->input->post('mtd_grd_detalle')) != "")?trim($this->input->post('mtd_grd_detalle')):null; 
            //si existe equivale a 1
            $total_abonar = (trim($this->input->post('pagt_total_abonar')) != "")?trim($this->input->post('pagt_total_abonar')):null; 
            //si existe detella del mondo equivale a 1
            $residuo_anticipo = (trim($this->input->post('pagt_residuo')) != "")?trim($this->input->post('pagt_residuo')):null;
            $suma_facturas = (trim($this->input->post('pagt_suma')) != "")?trim($this->input->post('pagt_suma')):null; //
            $rentencion_total_factura = (trim($this->input->post('pagt_total_reten')) != "")?trim($this->input->post('pagt_total_reten')):null;
            if (trim($this->input->post('txt_fech')) != "") {
                if ($this->input->post('txt_fech') == date('d-m-Y')) {
                    $fecha = date('Y-m-d H:i:s');
                } else {
                    $fecha = formatear_fecha('Y-m-d', $this->input->post('txt_fech')).' '.date('H:i:s');
                }                
            } else {
                $fecha = date('Y-m-d H:i:s');
            }            
            $fecha_generar_anticipo_insert = $fecha;
            $monto_recibido = (trim($this->input->post('txt_monto_recibido')) != "")?trim($this->input->post('txt_monto_recibido')):null;
            $monto_cambio = (trim($this->input->post('pagt_tdevolver')) != "")?trim($this->input->post('pagt_tdevolver')):null;
            $monto_entregado_sav = ($monto_recibido != null)?$monto_recibido:$total_abonar;
            $monto_cambio_sav = ($monto_recibido != null)?$monto_cambio:0;
            $anticipo_clien = $this->input->post('anticipo_clien'); //checkbox de los anticipos

            //arreglo de la grid de pagos
            $forma_pago_grid    = $this->input->post('mtd_forma_pago'); //arreglo de los id
            $tipo_pago_grid     = $this->input->post('mtd_tipo_pago'); //arreglo de los id
            $banco_grid         = $this->input->post('mtd_banco'); //arreglo de los id
            $cuenta_grid        = $this->input->post('mtd_cuenta'); //arreglo de los id
            $tipo_tra           = $this->input->post('mtd_tipo_transaccion'); //arreglo de los id
            $referencia_grid    = $this->input->post('mtd_referencia'); //arreglo
            $monto_grid         = $this->input->post('mtd_monto'); //arreglo de los montos de la grid
            $nombre_grid        = $this->input->post('mtd_nombre'); //arreglo de los nombres de la grid
            $fecha_grid         = $this->input->post('mtd_fech'); //arreglo de las fechas de la grid
            $fecha_transac_grid = $this->input->post('mtd_fech_tran'); //arreglo de las fechas de transaccion de la grid
            $facturas_arreglo   = $this->input->post('dtf_factura'); //arreglo de las facturas
            $facturas_arreglo   = array_unique($facturas_arreglo);
            $monto_factura_arreglo = $this->input->post('dtf_monto'); //retencion de la factura
            $monto_pendiente_factura_arreglo = $this->input->post('dtf_monto_abono'); //retencion de la factura
            $retencion_factura_arreglo = $this->input->post('dtf_retencion'); //retencion de la factura
            $retencion_factura_original_arreglo = $this->input->post('dtf_retencion_original'); //retencion de la factura
            $retencion_factura_flag_arreglo = $this->input->post('dtf_retencion_flag'); //retencion de la factura
            $pagos_por_factura_arreglo = $this->input->post('dtf_pago'); //los montos para cada factura
            $tipo_factura_arreglo = $this->input->post('dtf_tipo_factura'); //los montos para cada factura
            $vence = $this->input->post('txt_vence');
            $selecciono_facturas = 0;
            for ($c=0; $c < count($facturas_arreglo); $c++) {
                $fac_id_tmp = $facturas_arreglo[$c];
                $checkbox_factura_tmp = (trim($this->input->post('dtf_select_factura_'.$fac_id_tmp)) != "")?1:0;
                //verificamos las facturas checkeadas
                if($checkbox_factura_tmp == 1){
                    $selecciono_facturas++;
                }
            }
            $anl_id = 0;
            if(round($residuo_anticipo,2) > 0 ){
                $dias_vencimiento = $this->gsatelite->get_parametro("SYS_DIAS_VENCIMIENTO_ANTICIPO",30);
                $fecha_actual       = date('Y-m-d');
                $fecha_vencimiento  = strtotime ( '+'.$dias_vencimiento.' day' ,  strtotime($fecha_actual)  ) ;
                $fecha_vencimiento  = date ( 'Y-m-j' , $fecha_vencimiento );
                $fecha_vencimiento  = ($vence == 1)? $fecha_vencimiento: NULL;
                $anticipo_datos = array(
                        'anl_id_cli'            => $cliente_id,
                        'anl_fecha'             => $fecha_generar_anticipo_insert,
                        'anl_descripcion'       => $concepto_anticipo,
                        'anl_id_tif'            => $tipo_comprobante_pago,
                        'anl_comprobante'       => $comprobante_pago,
                        'anl_monto'             => number_format(convertirFloat($residuo_anticipo),2,'.',''),
                        'anl_saldo'             => number_format(convertirFloat($residuo_anticipo),2,'.',''),
                        'anl_estado'            => 1,
                        'anl_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'anl_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'anl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'anl_fecha_modificacion'=> date('Y-m-d H:i:s'),
                        'anl_fecha_vencimiento' => $fecha_vencimiento
                    );
                $anl_id = $this->gsatelite->ingresar('anl_anticipo_cliente', $anticipo_datos);
                //Se genera la partida del Anticipo
                $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_CUENTA_POR_COBRAR');
                if($generar_partida > 0){
                    $this->generar_partidas_contables_anticipo($anl_id);
                }
            }
            if($selecciono_facturas > 0){
                //abono
                $detalle_abc = array(
                        'abc_id_cli' => $cliente_id,
                        'abc_id_cob' => $cobrador_id,
                        'abc_id_tif' => $tipo_comprobante_pago,
                        'abc_fecha' => $fecha,
                        'abc_monto_entregado' => $monto_entregado_sav,
                        'abc_monto_cambio' => $monto_cambio_sav,
                        'abc_anticipo' => convertirFloat($anticipos_total),
                        'abc_monto' => convertirFloat($monto_indivirual),
                        'abc_total_abonar' => convertirFloat($total_abonar),
                        'abc_comprobante' => $comprobante_pago,
                        'abc_recibo_cobro' => $recibo_interno,
                        'abc_estado' => 1,
                        'abc_usu_creacion' => $this->tank_auth->get_user_id(),
                        'abc_fecha_creacion' => date('Y-m-d H:i:s'),
                        'abc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'abc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $abc_id         = $this->gsatelite->ingresar('abc_abono_cliente', $detalle_abc);                
                if($anl_id > 0 && $abc_id > 0) { // si existe anticipo vincular el abono que le dio origen al mismo
                    $this->gsatelite->actualizar_array('anl_anticipo_cliente',array('anl_id_abc_origen'=>$abc_id), array('anl_id'=>$anl_id));
                }
                $array_id_dab   = [];                
                if($forma_pago_grid != ""){
                    $factura_tmp = array();
                    $comprobante = "";
                    if ( count($facturas_arreglo) > 0 ) {
                        $contador= 0;
                        for ($a=0; $a < count($facturas_arreglo); $a++) {
                            $fac_id = $facturas_arreglo[$a];
                            if ( trim($this->input->post('dtf_select_factura_'.$fac_id)) != "" )  {
                                array_push($factura_tmp,$facturas_arreglo[$a]);
                            }
                        }
                        if ( count($factura_tmp) > 0 ) {
                            $this->db->where_in("fac_id",$factura_tmp);
                            $facturas_array= $this->gsatelite->get_tabla("fac_factura",null);
    
                            foreach ($facturas_array as $facs) {
                                $comprobante .= $facs["fac_numero"].", ";
                            }
                            $comprobante = substr($comprobante, 0, -2);
                        }
                    }
                   
                    for ($c=0; $c < count($cuenta_grid); $c++) {
                        $dab_id_tra = null;
                        if ($cuenta_grid[$c] != "" && $tipo_tra[$c] != "") {
                            $hora = date('H:i:s');
                            $tra_transaccion = array(
                                'tra_id_cub'        => $cuenta_grid[$c],
                                'tra_id_ttb'        => $tipo_tra[$c],
                                'tra_fecha'         => (trim($fecha_grid[$c]) != "") ? formatear_fecha('Y-m-d H:i:s', trim($fecha_grid[$c]) . ' ' . $hora) : date('Y-m-d H:i:s'),
                                'tra_operacion'     => (trim($nombre_grid[$c]) != "")?trim($nombre_grid[$c]):"Abono de factura.",
                                'tra_monto'         => (trim($monto_grid[$c]) != "")? convertirFloat(trim($monto_grid[$c])) : 0,
                                'tra_comprobante'   => $comprobante,
                                'tra_estado'        => 1,
                                'tra_fecha_crea'    => date('Y-m-d H:i:s'),
                                'tra_usu_crea'      => $this->tank_auth->get_user_id(),
                                'tra_fecha_mod'     => date('Y-m-d H:i:s'),
                                'tra_usu_mod'       => $this->tank_auth->get_user_id(),
                                'tra_aplicar'       => 1
                            );        
                            $dab_id_tra = $this->gsatelite->ingresar('tra_transaccion', $tra_transaccion);
                        }

                        if($forma_pago_grid[$c] != ""){
                            $detalle_dab = array(
                                    'dab_id_ban' => (trim($banco_grid[$c]) != "")?trim($banco_grid[$c]):null,
                                    'dab_id_tra' => $dab_id_tra,
                                    'dab_id_frp' => (trim($forma_pago_grid[$c]) != "")?trim($forma_pago_grid[$c]):null,
                                    'dab_id_tpg' => (trim($tipo_pago_grid[$c]) != "")?trim($tipo_pago_grid[$c]):null,
                                    'dab_id_abc' => $abc_id,
                                    'dab_fecha' => (trim($fecha_transac_grid[$c]) != "") ? date('Y-m-d',strtotime(trim($fecha_transac_grid[$c]))) : null,
                                    'dab_monto' => (trim($monto_grid[$c]) != "") ? convertirFloat(trim($monto_grid[$c])) :null,
                                    'dab_nombre' => (trim($nombre_grid[$c]) != "")?trim($nombre_grid[$c]):null,
                                    'dab_referencia' => (trim($referencia_grid[$c]) != "")?trim($referencia_grid[$c]):null,
                                    'dab_estado' => 1,
                                    'dab_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dab_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'dab_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dab_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                            $id_dab = $this->gsatelite->ingresar('dab_detalle_abono', $detalle_dab);
                            array_push($array_id_dab, $id_dab);
                        }
                    }
                }else{
                    $factura_tmp = array();
                    $comprobante = "";
                    if (count($facturas_arreglo) > 0 ) {
                        $contador= 0;
                        foreach ($facturas_arreglo as $k => $v) {
                            if (trim($this->input->post('dtf_select_factura_' . $v)) != "" )  {
                                array_push($factura_tmp, $v);
                            }
                        }
                        if (count($factura_tmp) > 0) {
                                         $this->db->where_in("fac_id", $factura_tmp);
                            $fac_array = $this->gsatelite->get_tabla("fac_factura");
                            foreach ($fac_array as $facs) {
                                $comprobante .= $facs["fac_numero"] . ", ";
                            }
                            $comprobante = substr($comprobante, 0, -2);
                        }
                    }
                    $frp_defect = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_estado' => 1, 'frp_defecto' => 1));
                    $tipos_pago = (count($frp_defect) > 0) ? $frp_defect[0]['frp_id'] : 0;
                    if ($tipos_pago > 0) {
                        $detalle_dab = array(
                            'dab_id_abc' => $abc_id,
                            'dab_id_frp' => $tipos_pago,
                            'dab_fecha' => date('Y-m-d H:i:s'),
                            'dab_monto' => ($monto_total > $monto_indivirual) ? convertirFloat($monto_indivirual) : convertirFloat($monto_total),//CASO QUE SOBRA Y HARA ANTICIPO: TOTAL  > INDIV
                            'dab_estado' => 1,
                            'dab_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dab_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dab_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dab_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_dab = $this->gsatelite->ingresar('dab_detalle_abono', $detalle_dab);
                        array_push($array_id_dab, $id_dab);
                    }
                }
                /*==================================================================================================================
                                                        ANTICIPOS
                ==================================================================================================================*/
                if($anticipo_clien != ""){
                    $pago_reten = $suma_facturas - $rentencion_total_factura;// el pago de la suma de facturas menos las retenciones
                    for ($x=0; $x < count($anticipo_clien); $x++) {
                        if(trim($anticipo_clien[$x]) != "" and $anticipo_clien[$x] > 0 ){

                            $saldo_anticipo = (trim($this->input->post('anticipo_saldo_'.$anticipo_clien[$x])) != "")?$this->input->post('anticipo_saldo_'.$anticipo_clien[$x]):0; //20
                            $id_anticipo = $anticipo_clien[$x];

                            $restante_total = $pago_reten - $saldo_anticipo;//se resta el pago menos el saldo del anticipo
                            $anticipo_nuevo_anl = 0;
                            $anticipo_abono_ana = 0;
                            if($restante_total < 0){
                                $anticipo_nuevo_anl = ($restante_total * -1);
                                $anticipo_abono_ana = $saldo_anticipo - ($restante_total * -1);
                            } else{
                                $anticipo_nuevo_anl = 0;
                                $anticipo_abono_ana = $saldo_anticipo;
                            }

                            $anticipo_relacion = array(
                                    'ana_id_anl' => $id_anticipo,
                                    'ana_id_abc' => $abc_id,
                                    'ana_monto' => $anticipo_abono_ana,
                                    'ana_saldo_anticipo' => $anticipo_nuevo_anl,
                                    'ana_fecha' => date('Y-m-d H:i:s'),
                                    'ana_estado' => 1,
                                    'ana_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'ana_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'ana_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'ana_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                            $this->gsatelite->ingresar('ana_anticipo_abono', $anticipo_relacion);
                            $usa_anticipo = true; //indicar que se utilizó anticipo

                            if($restante_total > 0){
                                $anticipo_actualizar_datos = array(
                                    'anl_saldo' => 0,
                                    'anl_estado' => 0,
                                    'anl_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'anl_fecha_modificacion' => date('Y-m-d H:i:s')
                                );

                                // verificar si el anticipo tiene comprobante
                                // Si el anticipo es utilizado en su totalidad
                                // El comprobante cambia su estado a canjeado
                                $verificar_comprobante = $this->gsatelite->get_tabla('cmd_comprobante_descuento', array('cmd_id_anl'=>$id_anticipo, 'cmd_estado_comprobante'=>1));
                                if (count($verificar_comprobante)>0) {
                                    $comprobante_actualizar_datos = array(
                                        'cmd_estado_comprobante' => 4,
                                        'cmd_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                        'cmd_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->actualizar_array('cmd_comprobante_descuento', $comprobante_actualizar_datos, array('cmd_id' => $verificar_comprobante[0]['cmd_id']));
                                }
                            } else{
                                $anticipo_actualizar_datos = array(
                                    'anl_saldo' => $anticipo_nuevo_anl,
                                    'anl_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'anl_fecha_modificacion' => date('Y-m-d H:i:s')
                                );

                                //preguntar si el nuevo saldo es igual o menor a cero entonces desactivarlo 
                                if($anticipo_nuevo_anl <= 0 ) 
                                {
                                   $anticipo_actualizar_datos['anl_estado'] = 0;
                                }
                            }
                            $this->gsatelite->actualizar_array('anl_anticipo_cliente', $anticipo_actualizar_datos, array('anl_id' => $id_anticipo));
                            $pago_reten -= $saldo_anticipo;//restamos el total por si hay mas retenciones
                        }
                        // FIN de Validacion que no esta vacia el anticipo de cliente
                    }
                }
                /*=============================================================================================================================
                                                        FACTURAS
                =============================================================================================================================*/
                //recorremos todas las facturas
                $n_facturas = 0; //contador de facturas
                $id_factura_pago = 0; //id de factura a pagar 
                for ($a=0; $a < count($facturas_arreglo); $a++) {
                    $fac_id = $facturas_arreglo[$a];
                    $checkbox_factura = (trim($this->input->post('dtf_select_factura_'.$fac_id)) != "")?1:0;
                    //verificamos las facturas checkeadas
                    if($checkbox_factura == 1){
                        $dtf_pago = (trim($pagos_por_factura_arreglo[$a]) != "")?trim($pagos_por_factura_arreglo[$a]):null; //monto individual de la factura
                        if($dtf_pago != null || $this->input->post('comprobante_fac'.$fac_id.'1') != ''){                            
                            $monto_original = (trim($monto_factura_arreglo[$a]) != "")?trim($monto_factura_arreglo[$a]):null; //monto original individual de factura
                            $monto_pendiente = (trim($monto_pendiente_factura_arreglo[$a]) != "")?trim($monto_pendiente_factura_arreglo[$a]):null; //monto original individual de factura
                            $dtf_tipo_factura = (trim($tipo_factura_arreglo[$a]) != "")?trim($tipo_factura_arreglo[$a]):null; //tipo individual de factura
                            if ($this->input->post('comprobante_fac'.$fac_id.'1') != '') {
                                $retencion_factura = (trim($retencion_factura_arreglo[$a]) != "")?trim($retencion_factura_arreglo[$a]):null; //retencion individual de factura
                                //print_r($this->input->post('comprobante_fac'.$fac_id.$a));die();
                            } else {
                                $retencion_factura = 0;
                            }
                            $retencion_original = number_format($retencion_factura_original_arreglo[$a], 2, '.', '');
                            /*
                                datos para prorrateo
                            */
                            // $porcentaje_temp = (number_format(((float)number_format($dtf_pago,2,'.',''))/$total_abonar,2,'.',''));
                            $porcentaje_temp = (float)($dtf_pago / $total_abonar);
                            $monto_pendiente_factura = ($monto_original - $dtf_pago);
                            /* SE ELIMINAN DE LA TABLA ABF LA fecha & EL ESATDO POR SER HIJAS DE LA TABLA ABC_ABONO_CLIENTE */
                            $detalle_abf = array(
                                    'abf_id_fac' => $fac_id,
                                    'abf_id_abc' => $abc_id,
                                    'abf_monto_entregado' => ($monto_entregado_sav * $porcentaje_temp),
                                    'abf_monto_cambio' => ($monto_cambio_sav * $porcentaje_temp),
                                    'abf_monto' => ($dtf_pago != "") ? $dtf_pago : 0,
                                    'abf_monto_retencion' => $retencion_factura,
                                    'abf_pendiente_factura' => $monto_pendiente_factura,
                                    'abf_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'abf_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'abf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'abf_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                            $abf_id = $this->gsatelite->ingresar('abf_abono_factura', $detalle_abf);
                            $n_facturas++; //contar el numero de facturas procesadas en el pago
                            $id_factura_pago = $fac_id;
                            $nuevo_monto = $monto_original - ($dtf_pago + $retencion_factura);
                            $nuevo_monto_pendiente = $monto_pendiente + $dtf_pago;
                            $nueva_retencion = $retencion_factura;
                            if($retencion_factura_flag_arreglo[$a] != 0){
                                $nueva_retencion = $retencion_factura_original_arreglo[$a] + $retencion_factura;
                            }
                            $aplico_retencion_nuev = 1;
                            //if($nueva_retencion == 0 OR $nueva_retencion == $retencion_factura_original_arreglo[$a]){
                            if($nueva_retencion == 0){
                                $aplico_retencion_nuev = 0;
                            }
                            $marcar_paga = $this->gsatelite->get_parametro_emp('SYS_FACTURA_PAGADA_RETENCIONES', 0);
                            // var_dump(floatval($nuevo_monto),  $nueva_retencion, floatval($retencion_factura_arreglo[$a]),  $marcar_paga);die();
                            if($nuevo_monto == 0){
                                $detalle_fac = array(
                                        'fac_total_retencion'   => $nueva_retencion,
                                        'fac_monto_pendiente'   => $nuevo_monto,
                                        'fac_estado'            => 2,
                                        'fac_retencion_abono'   => $aplico_retencion_nuev,
                                        'fac_monto_abono'       => $nuevo_monto_pendiente,
                                        'fac_usu_mod'           => $this->tank_auth->get_user_id(),
                                        'fac_fecha_mod'         => date('Y-m-d H:i:s'),
                                        'fac_fecha_pagada'      => date('Y-m-d H:i:s')
                                    );
                            } else if($nueva_retencion != 0){
                                $detalle_fac = array(
                                        'fac_total_retencion' => $nueva_retencion,
                                        'fac_monto_pendiente' => $nuevo_monto,
                                        'fac_retencion_abono' => $aplico_retencion_nuev,
                                        'fac_monto_abono' => $nuevo_monto_pendiente,
                                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                                        'fac_fecha_mod' => date('Y-m-d H:i:s')
                                    );
                            } else if($marcar_paga > 0 && $nuevo_monto != 0 && number_format($nuevo_monto, 2, '.', '') === $retencion_original) {
                                $detalle_fac = array(
                                        'fac_monto_pendiente' => $nuevo_monto,
                                        'fac_monto_abono' => $nuevo_monto_pendiente,
                                        'fac_estado' => 2,
                                        'fac_fecha_pagada' => date('Y-m-d H:i:s'),
                                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                                        'fac_fecha_mod' => date('Y-m-d H:i:s')
                                    );                            
                            } else{
                                $detalle_fac = array(
                                        //'fac_total_retencion' => $nueva_retencion,
                                        'fac_monto_pendiente' => $nuevo_monto,
                                        //'fac_retencion_abono' => $aplico_retencion_nuev,
                                        'fac_monto_abono' => $nuevo_monto_pendiente,
                                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                                        'fac_fecha_mod' => date('Y-m-d H:i:s')
                                    );
                            }
                            $this->gsatelite->actualizar_array('fac_factura', $detalle_fac, array('fac_id' => $fac_id));

                            //verifica el numero donde se quedo el conteo de los registros de la grid
                            $contador_temp = $this->input->post('contador_acumulador'.$fac_id);
                            // print_r('un contador '.$contador_temp);
                            //recorremos todos los registros para guardarlos
                            for ($b=1; $b < $contador_temp; $b++) {
                                //el nombre del comprobante y la fecha
                                $cmr_nombre = $this->input->post('comprobante_fac'.$fac_id.$b);
                                $cmr_fecha = $this->input->post('fecha_producto_det'.$fac_id.$b);

                                $nuevo_comprobante = 0;
                                //en el caso q se borro algun registro de la grid y el nuevo tiene otro numero
                                if($cmr_nombre != ""){

                                    //el id de la tabla def
                                    $def_id = $this->input->post('ret_def_'.$fac_id.$b);

                                    //suma el total de las retenciones seleccionadas
                                    $monto_cmr = 0;
                                    foreach ($def_id as $key) {
                                        if($this->input->post('existe'.$key.$b) == 1){
                                            $nuevo_comprobante++;
                                        }
                                        $monto_cmr += $this->input->post('retencion_porcentaje'.$key.$b);
                                    }
                                    if(trim($cmr_nombre[0]) != ""){
                                        //print_r($cmr_fecha);
                                        //guarda el detalle del comprobante con el total de los montos y la fecha
                                        $detalle_cmr = array(
                                                'cmr_id_abf' => $abf_id,
                                                'cmr_numero' => $cmr_nombre[0],
                                                'cmr_fecha' => (trim($cmr_fecha[0]) != "")?date('Y-m-d',strtotime(trim($cmr_fecha[0]))):null,
                                                'cmr_monto' => $monto_cmr,
                                                'cmr_estado' => 1,
                                                'cmr_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'cmr_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'cmr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'cmr_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );
                                        if($nuevo_comprobante == 0){
                                            $cmr_id = $this->gsatelite->ingresar('cmr_comprobante_retencion', $detalle_cmr);
                                        } else {
                                            $cmr_id = null;
                                        }

                                        //recorremos los productos del detalle actual
                                        foreach ($def_id as $key) {
                                            //es el monto total del detalle de la factura
                                            $montotxproducto = $this->input->post('total_producto'.$key.$b);

                                            //son los ids de las retenciones escogidas para ese detalle y los porcentajes individuales de los detalles
                                            $id_retencion_cadena = $this->input->post('retenciones_ids'.$key.$b);
                                            $id_retencion_por_cadena = $this->input->post('retenciones_por_ids'.$key.$b);
                                            //dividimos los ids y los porcentajes en un arreglo
                                            $id_retencion_por_array = explode(',', $id_retencion_por_cadena);
                                            $id_retencion_array = explode(',', $id_retencion_cadena);
                                            $contador_ret = 0;
                                            //recorremos dependiendo del numero de retenciones seleccionadas
                                            foreach ($id_retencion_array as $key2) {
                                                //sacamos el porcentaje individual de cada una de las retenciones seleccionadas
                                                $monto_temp_rxf = $montotxproducto * ($id_retencion_por_array[$contador_ret]/100);
                                                if($nuevo_comprobante == 0){
                                                    $regs = $this->gsatelite->get_tabla('rxf_retencionxdetalle_factura', array('rxf_id_def'=>$key,'rxf_id_ret'=>$key2,'rxf_estado'=>1,'rxf_aplicado'=>null));
                                                    $detalle_rxf = array(
                                                        'rxf_id_def' => $key,
                                                        'rxf_id_ret' => $key2,
                                                        'rxf_id_cmr' => $cmr_id,
                                                        'rxf_monto' => number_format($monto_temp_rxf,2,'.',''),
                                                        'rxf_aplicado' => 1,
                                                        'rxf_estado' => 1,                                                        
                                                        'rxf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                        'rxf_fecha_modificacion' => date('Y-m-d H:i:s')
                                                    );
                                                    if (count($regs) > 0) {
                                                        foreach ($regs as $k => $v) {
                                                            $this->gsatelite->actualizar_array('rxf_retencionxdetalle_factura', $detalle_rxf, array('rxf_id' => $v['rxf_id']));
                                                        }
                                                    } else {
                                                        $detalle_rxf['rxf_usu_creacion'] = $this->tank_auth->get_user_id();
                                                        $detalle_rxf['rxf_fecha_creacion'] = date('Y-m-d H:i:s');
                                                        $this->gsatelite->ingresar('rxf_retencionxdetalle_factura', $detalle_rxf);
                                                    }
                                                }
                                                $contador_ret++;
                                            }
                                        }

                                    }

                                }
                            }
                        }
                    }
                }
            }else{
                $array_id_dab = array();
                if($forma_pago_grid != ""){
                    for ($c = 0; $c < count($cuenta_grid); $c++) {
                        $dab_id_tra = null;
                        if ($cuenta_grid[$c] != "" && $tipo_tra[$c] != "") {
                            $hora = date('H:i:s');
                            $tra_transaccion = array(
                                'tra_id_cub'        => $cuenta_grid[$c],
                                'tra_id_ttb'        => $tipo_tra[$c],
                                'tra_fecha'         => (trim($fecha_grid[$c]) != "") ? formatear_fecha('Y-m-d H:i:s', trim($fecha_grid[$c]) . ' ' . $hora) : date('Y-m-d H:i:s'),
                                'tra_operacion'     => (trim($nombre_grid[$c]) != "")?trim($nombre_grid[$c]):"Anticipo de Pago.",
                                'tra_monto'         => (trim($monto_grid[$c]) != "")?trim($monto_grid[$c]):0,
                                'tra_comprobante'   => $anl_id,
                                'tra_estado'        => 1,
                                'tra_fecha_crea'    => date('Y-m-d H:i:s'),
                                'tra_usu_crea'      => $this->tank_auth->get_user_id(),
                                'tra_fecha_mod'     => date('Y-m-d H:i:s'),
                                'tra_usu_mod'       => $this->tank_auth->get_user_id(),
                                'tra_aplicar'       => 1
                            );        
                            $dab_id_tra = $this->gsatelite->ingresar('tra_transaccion', $tra_transaccion);
                        }
                        if($forma_pago_grid[$c] != ""){
                            $detalle_dab = array(
                                'dab_id_ban' => (trim($banco_grid[$c]) != "")?trim($banco_grid[$c]):null,
                                'dab_id_tra' => $dab_id_tra,
                                'dab_id_frp' => (trim($forma_pago_grid[$c]) != "")?trim($forma_pago_grid[$c]):null,
                                'dab_id_tpg' => (trim($tipo_pago_grid[$c]) != "")?trim($tipo_pago_grid[$c]):null,
                                'dab_id_anl' => $anl_id,
                                'dab_fecha' => (trim($fecha_transac_grid[$c]) != "") ? date('Y-m-d',strtotime(trim($fecha_transac_grid[$c]))) : null,
                                'dab_monto' => (trim($monto_grid[$c]) != "")?trim($monto_grid[$c]):null,
                                'dab_nombre' => (trim($nombre_grid[$c]) != "")?trim($nombre_grid[$c]):null,
                                'dab_referencia' => (trim($referencia_grid[$c]) != "")?trim($referencia_grid[$c]):null,
                                'dab_estado' => 1,
                                'dab_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dab_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dab_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dab_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $id_dab = $this->gsatelite->ingresar('dab_detalle_abono', $detalle_dab);
                            array_push($array_id_dab, $id_dab);
                        }
                    }
                }
            }
            $tipo_pago = $this->input->post('tipo_pago');
            $cliente_pago = $this->input->post('cliente_pago');
            $factura_pago = $this->input->post('factura_pago');
            $usu = $this->input->post('usu_dir');
            //PREGUNTAR SI EL PAGO FUE SOLO PARA UNA FACTURA
            if ($n_facturas == 1 && $id_factura_pago > 0){
                $consulta_anticipo = $this->cuentas_cobrar_model->get_facturas_anticipo(array('abf_id_fac'=>$id_factura_pago));
                if (count($consulta_anticipo) > 0 && $consulta_anticipo[0]['n_abc'] == 1) {
                    $continuidad_anticipo = true;
                }
            }
            /***************Generar partida contable****************/
            $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_CUENTA_POR_COBRAR');
            /***************Generar partida contable usando anticipo ****************/
            if($generar_partida > 0 && $abc_id > 0 && $usa_anticipo){
                $id_partida = $this->generar_partida_contable_pago_uso_anticipo($abc_id);
            } else { 
                /*************Fin Generar partida contable usando anticipo***************/
                if($generar_partida > 0 && $abc_id > 0 && !$usa_anticipo){
                    $id_partida = $this->generar_partida_contable_pago($abc_id);
                }
                /*************Fin Generar partida contable***************/
            }
            if($usu>0){
                $direct = '/0/1';
                $dir_grid = 'factura_caja';
                $pago_dir = '/0/1';
            }else{
                $direct = '/';
                $dir_grid = 'factura/';
                $pago_dir = '';
            }
            if($tipo_pago == 1){
                if ($selecciono_facturas == 0 && $anl_id > 0) {
                    $this->session->set_flashdata('id_anticipo', $anl_id);
                } else {
                    $this->session->set_flashdata('id_abono', $abc_id);
                }
                if($redireccion == 0){
                    redirect('modulo_cuentas_cobrar/procesos/crear_pago/');
                } else{
                    redirect('modulo_cuentas_cobrar/procesos/pagos/');
                }
            } else if($tipo_pago == 2){
                if ($selecciono_facturas == 0 && $anl_id > 0) {
                    $this->session->set_flashdata('id_anticipo', $anl_id);
                } else {
                    $this->session->set_flashdata('id_abono', $abc_id);
                }
                if($redireccion == 0){
                    redirect('modulo_cuentas_cobrar/procesos/crear_pago/'.$cliente_pago);
                } else{
                    redirect('modulo_cuentas_cobrar/procesos/pagos/');
                }
            } else if($tipo_pago == 3){
                $this->session->set_flashdata('id_factura', $factura_pago);
                if($redireccion2 != 0){
                    if($redireccion2 == 1){
                        redirect('facturacion/facturar/crear_factura'.$direct);
                    } else if($redireccion2 == 2){
                        redirect('facturacion/facturar/'.$dir_grid);
                    } else{
                        if ($selecciono_facturas == 0 && $anl_id > 0) {
                            $this->session->set_flashdata('id_anticipo', $anl_id);
                        } else {
                            $this->session->set_flashdata('id_abono', $abc_id);
                        }
                        if ($redireccion > 0) {
                            redirect('facturacion/facturar/pagos_fac');
                        } else {
                            redirect('facturacion/facturar/crear_pago_factura');
                        }
                    }
                }
                if($redireccion == 0){
                    redirect('facturacion/facturar/crear_pago_factura/'.$cliente_pago.'/'.$factura_pago.$pago_dir);
                } else{
                    redirect('facturacion/facturar/crear_factura'.$direct); // Al guardar factura se redirecciona - factura -
                }
            }


        }
    }




    /**
    * @author René Castaneda
    * @since 2017-06-19
    * @return facturas estado de cuenta
     */
    public function estado_cuenta_corriente()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos']=$permisos;
        $data['cliente'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]",'', array('cli_estado' => '1'), null, '', 'cli_id', true);
        $data['titulo_personal'] = "Estado de Cuenta Corriente";
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-06-19
    * @return filtrar facturas estado de cuenta
     */

    public function filtrar_estado_cuenta_corriente($es_reporte=0)
    {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        $data['permisos']=$permisos;
        $txtFecha_desde =  $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcCliente = $this->input->post('slcCliente');
        $where['fac_estado'] = '1';
        if ($txtFecha_desde!='' and $txtFecha_hasta!='') {
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") >=']=date('Y-m-d',strtotime($txtFecha_desde));
            $where['date_format(fac_fecha_fact,"%Y-%m-%d") <=']=date('Y-m-d',strtotime($txtFecha_hasta));

            if ($slcCliente>0) {
                $where['fac_id_cli']=$slcCliente;
            }

            $registros=$this->cuentas_cobrar_model->get_cuentas_cobrar_detallado($where);
            //print_r($this->db->last_query()); die();
        }
        $data['es_reporte']=$es_reporte;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcCliente'] = $this->input->post('slcCliente');
        $data['periodo'] = date('d-m-Y',strtotime($txtFecha_desde)) . ' A ' . date('d-m-Y',strtotime($txtFecha_hasta));
        $data['registros'] = $registros;
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/filtrar_estado_cuenta_corriente', $data, true);

        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde==$txtFecha_hasta)? "De: ".date('d-m-Y',strtotime($txtFecha_desde)):"De: ".$data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=estado_cuenta_corriente".date('d-m-Y_His').".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='9' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='9' align='center' >Estado de Cuenta Corriente</th></tr>
                  <tr><th colspan='9' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Estado de Cuenta Corriente <br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'cuentas_cobrar','Letter');
                die();
            }
        }
        echo json_encode(array('html'=>$html));

    }

    /**
    * @author Francsico Orozco
    * @since 2018-01-02
    * @return clientes
    * @param $like string para condicionar.
    */
    public function get_clientes_like(){
        if ($_POST) {
            $like = $this->input->post('cliente');
            $where['cli_estado'] = 1;
            $result = $this->cuentas_cobrar_model->get_clientes_like($where,$like);
            echo json_encode($result);
        }
    }

     /**
    * @author Nelson Soriano
    * @since  2019-01-14
    * @return Vendedores
    * @param  String.
    */
    public function get_vendedores_like(){
        if ($_POST) {
            $like = $this->input->post('vendedor');
            $where['ven_estado >='] = 0;
            $result = $this->cuentas_cobrar_model->get_vendedores_like($where,$like);
            echo json_encode($result);
        }
    }

    /**
    * @author Elman Ortiz
    * @since 2018-07-04
    * @return
    * @param id del registro abf
    * @Modified by: Mario Marquez "Se realizo un cambio en como se obtiene la partida debe obtener la partida desde el monto de la tabla abc_abono_cliente"
    */
    public function generar_partida_contable_pago($abf_id){
        /**************Parte Debe******************************************/
        //Obtener tipo de partida
        $id_tpd = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('INGRESO'));
        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        $tcn_id_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('CAJA'));
        
        $debe = $this->cuentas_cobrar_model->get_pago_cliente_debe($abf_id, $tcn_id_debe);

        //Se genera correlativo y codigo de partida
        $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tpd));
        $corr = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
        $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
        $codigo = $tipo_abr . '-' . $numero;
        //Obtener concepto de la partida contable
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 12));//Id Partida contabilidad Banco
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        }else{
          $pct_concepto = 'Concepto no definido';
        }

        $abc_data = $this->gsatelite->get_tabla('abc_abono_cliente', array('abc_id' => $abf_id));

        //Se define un tipo cuenta transitoria CXC cliente para contado
        //Se define un tipo cuenta CXC credito
        $this->db->join('fac_factura','abf_id_fac = fac_id');
        $tcn_id = $this->gsatelite->get_tabla('abf_abono_factura', array('abf_id_abc' => $abf_id));

        $csvFacturas = implode(',',array_column($tcn_id, 'fac_numero'));
        $pct_concepto .= ' Facturas #: '.$csvFacturas;
        //Si se encontraron cuentas se ejecuta el proceso de partidas

        if(count($debe) >0 ){

            $total_partida_pct = number_format(array_sum(array_column($debe, 'total_abonar')), 2, '.', '');

            //Ingreso en la pct_partida contable
            $array_partida = array(
                'pct_id_tpd'    => $id_tpd,
                'pct_id_prc'    => null,
                'pct_concepto'  => $pct_concepto,
                'pct_modulo'    => 1,
                'pct_fecha'     => $abc_data[0]['abc_fecha'],//date('Y-m-d H:i:s'),
                'pct_total'     => $total_partida_pct,
                'pct_estado'    => 1,
                'pct_fecha_crea'=> date('Y-m-d H:i:s'),
                'pct_fecha_mod' => date('Y-m-d H:i:s'),
                'pct_usu_crea'  => $this->tank_auth->get_user_id(),
                'pct_usu_mod'   => $this->tank_auth->get_user_id(),
                'pct_correlativo' => $corr->correlativo,
                'pct_codigo'    => $codigo
            );

            $agregar    = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

            //Ingreso detalle partida debe
            foreach ($debe as $key => $val) {
                $array_detalle = array(
                    'dpc_id_cnt'    => $val['cnt_id'],
                    'dpc_id_pct'    => $agregar,
                    'dpc_concepto'  => $pct_concepto,
                    'dpc_debe'      => number_format($val['total_abonar'], 2, '.', ''),
                    'dpc_haber'     => 0.00,
                    'dpc_estado'    => 1,
                    'dpc_fecha_crea'=> date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                );

                $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }

            /*************Fin parte Debe***************************************/
            /**************Parte Haber******************************************/

            $tcn_id = $tcn_id[0]['fac_id_tpg'];
            switch ($tcn_id) {
                case 2://Credito
                    $tcn_id_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('CUENTA_POR_COBRAR'));
                    break;
                default://Contado
                    $tcn_id_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('TRANSITORIA_CXC'));//AQUI DEBE IR LA TRANSITORIA
                    break;
            }

            $haber = $this->cuentas_cobrar_model->get_pago_cliente_haber($abf_id, $tcn_id_haber);
            //Ingreso detalle partida  debe
            foreach ($haber as $key => $val) {
                $array_detalle = array(
                    'dpc_id_cnt'    => $val['cnt_id'],
                    'dpc_id_pct'    => $agregar,
                    'dpc_concepto'  => $pct_concepto,
                    'dpc_debe'      => 0.00,
                    'dpc_haber'     => number_format($val['total_abonar'], 2, '.', ''),
                    'dpc_estado'    => 1,
                    'dpc_fecha_crea'=> date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                );

                $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }
            /*************Fin parte Haber***************************************/
            //$this->gsatelite->get_tabla('abc_abono_cliente', array('abc_id' => $abf_id));

            //$this->db->join('abf_abono_factura','abc_id = abf_id_abc');
            echo $agregar;


            $array_detalle_bd = array(
                    'abc_id_pct' => $agregar,
                    'abc_estado' => 1,
                    'abc_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'abc_usu_modificacion' => $this->tank_auth->get_user_id()
                );
            $this->gsatelite->actualizar_array('abc_abono_cliente', $array_detalle_bd, array('abc_id' => $abc_data[0]['abc_id']));
        }

        return $agregar;
    }

    public function generarpartidaspendientespagos() {
        ini_set( 'memory_limit', '4048M' );
        ini_set('max_execution_time', '9999');
        ini_set( 'max_input_vars', '15000' );
        /*************Parte Debe***************************************/
        //Obtener tipo de partida
        $id_tpd = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO'));
        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        $tcn_id_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CAJA'));
        /*************Fin parte Debe***************************************/

        /**************Parte Haber******************************************/
        //Se define un tipo cuenta transitoria CXC cliente para contado
        //Se define un tipo cuenta CXC credito
        $tipoCuentaCredito_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('CUENTA_POR_COBRAR'));

        $tipoCuentaTransitoria_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('TRANSITORIA_CXC'));//AQUI DEBE IR LA TRANSITORIA
        $arrayCuentasHaber = array(
            'tipoCuentaCredito' => $tipoCuentaCredito_haber,
            'tipoCuentaTransitoria' => $tipoCuentaTransitoria_haber
        );
        /*************Fin parte Haber***************************************/

        //Se obtienen todos los abonos sin partidas
        $abonosPendientes = $this->cuentas_cobrar_model->get_pagos_pendientes_partida($tcn_id_debe,$arrayCuentasHaber);
        //Se obtiene el prefijo de la partida
        $tipo_abr = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tpd));

        //Obtener concepto de la partida contable
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 12));//Id Partida contabilidad Banco
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        }else{
          $pct_concepto = 'Concepto no definido';
        }

        echo 'Consultadas - ' . count($abonosPendientes);

        $idsPartidas = array();
        try {

            //Se recorren los abonos para ir a generar las partidas
            foreach ($abonosPendientes as $abonos) {
                //Se genera correlativo y codigo de partida

                $corr = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
                $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
                $codigo = $tipo_abr . '-' . $numero;

                $numerosFacturas = implode(',',array_column($abonos['abono_factura_debe'],'fac_numero'));
                //Ingreso en la pct_partida contable
                $array_partida = array(
                    'pct_id_tpd' => $id_tpd,
                    'pct_id_prc' => null,
                    'pct_concepto' => $pct_concepto . ' - Facturas: '.$numerosFacturas,
                    'pct_modulo' => 1,
                    'pct_fecha' => $abonos['abc_fecha'],
                    'pct_total' => number_format(array_sum(array_column($abonos['abono_factura_debe'], 'total_abonar')), 2, '.', ''),
                    'pct_estado' => 1,
                    'pct_fecha_crea' => date('Y-m-d H:i:s'),
                    'pct_fecha_mod' => date('Y-m-d H:i:s'),
                    'pct_usu_crea' => $this->tank_auth->get_user_id(),
                    'pct_usu_mod' => $this->tank_auth->get_user_id(),
                    'pct_correlativo' => $corr->correlativo,
                    'pct_codigo' => $codigo
                );

                $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                echo '<br/>' . $codigo.' - '.$abonos['abc_id'];
                $idsPartidas[] = $pct_id;

                /*                 * ************ DEBE ************* */
                foreach ($abonos['abono_factura_debe'] as $debe) {
                    $array_detalle = array(
                        'dpc_id_cnt' => $debe['cuenta_debe'],
                        'dpc_id_pct' => $pct_id,
                        'dpc_concepto' => $pct_concepto,
                        'dpc_debe' => number_format($debe['total_abonar'], 2, '.', ''),
                        'dpc_haber' => 0.00,
                        'dpc_estado' => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod' => $this->tank_auth->get_user_id()
                    );

                    $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }


                /*                 * ************ FIN DEBE ************* */


                /*                 * ************ HABER ************* */
                foreach ($abonos['abono_factura_haber'] as $debe) {
                    $array_detalle = array(
                        'dpc_id_cnt' => $debe['cuenta_haber'],
                        'dpc_id_pct' => $pct_id,
                        'dpc_concepto' => $pct_concepto,
                        'dpc_debe' => 0.00,
                        'dpc_haber' => number_format($debe['total_abonar'], 2, '.', ''),
                        'dpc_estado' => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod' => $this->tank_auth->get_user_id()
                    );

                    $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
                /*                 * ************ FIN HABER ************* */

                $array_detalle_bd = array(
                    'abc_id_pct' => $pct_id,
                    'abc_estado' => 1,
                    'abc_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'abc_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $this->gsatelite->actualizar_array('abc_abono_cliente', $array_detalle_bd, array('abc_id' => $abonos['abc_id']));
            }
        } catch (Exception $ex) {
            echo 'Procesadas antes del error: '.count($idsPartidas);
            var_dump($ex);
        }
        echo 'Generadas - ' . count($idsPartidas);
    }


     /*
    * @author Mario Marquez
    * @since 2018-09-03
    * @method generar_partidas_contables_anticipo
    */
    public function generar_partidas_contables_anticipo($anl_id){

        //===================================
        //GENERAR PARTIDA CONTABLE
        //===================================
        $permite_generar = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA');

        if ( $permite_generar != 1 ) {
               return 0;
        } 
        //Se obtiene la informacion del Anticipo
        $anticipo_data = $this->gsatelite->get_tabla('anl_anticipo_cliente', array('anl_id' => $anl_id));

         /*************Parte Debe***************************************/
        //Obtener tipo de partida
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO'));
        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        $tipo_cuenta_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CAJA'));

        //Se obtiene el tipo de cuenta DEBE
        $cuenta_debe = $this->cuentas_cobrar_model->get_cuenta_contable_anticipo($anl_id, $tipo_cuenta_debe);


         //Se genera correlativo y codigo de partida
        $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $tipo_partida));
        $corr = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
        $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
        $codigo_partida = $tipo_abr . '-' . $numero;

        //Obtener concepto de la partida contable
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 17));//Id Partida contabilidad Banco
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        }else{
          $pct_concepto = 'Concepto no definido';
        }

         //Ingreso en la pct_partida contable
        $array_partida = array(
            'pct_id_tpd'    => $tipo_partida,
            'pct_id_prc'    => null,
            'pct_concepto'  => $pct_concepto.' - Comprobante: '.$anticipo_data[0]['anl_comprobante'],
            'pct_modulo'    => 1,
            'pct_fecha'     => $anticipo_data[0]['anl_fecha'],
            'pct_total'     => number_format(array_sum(array_column($cuenta_debe, 'total_abonar')), 2, '.', ''),
            'pct_estado'    => 1,
            'pct_fecha_crea'=> date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea'  => $this->tank_auth->get_user_id(),
            'pct_usu_mod'   => $this->tank_auth->get_user_id(),
            'pct_correlativo' => $corr->correlativo,
            'pct_codigo'    => $codigo_partida
        );

        $pct_id  = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);


        //Ingreso detalle partida debe
        foreach ($cuenta_debe as $debe) {
            $array_detalle = array(
                'dpc_id_cnt' => $debe['cnt_id'],
                'dpc_id_pct' => $pct_id,
                'dpc_concepto' => $pct_concepto,
                'dpc_debe' => number_format($debe['total_abonar'], 2, '.', ''),
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

            $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
        /*************Fin parte Debe***************************************/

         /* *************************************Parte Haber***************************************** */
        //Se ha definido tipo de cuenta de BANCOS siempre sin importar el tipo de pago
        $tipo_cuenta_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('ANTICIPOS'));

        $cuentas_haber = $this->cuentas_cobrar_model->get_cuenta_contable_anticipo($anl_id, $tipo_cuenta_haber);

         //Ingreso detalle partida debe
        foreach ($cuentas_haber as $haber) {
            $array_detalle = array(
                'dpc_id_cnt' => $haber['cnt_id'],
                'dpc_id_pct' => $pct_id,
                'dpc_concepto' => $pct_concepto,
                'dpc_debe' => 0.00,
                'dpc_haber' => number_format($haber['total_abonar'], 2, '.', ''),
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

            $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
        /* ************************************Fin Parte Haber***************************************** */

        //Se actualiza el anticipo con la partida generada
        $anticipo_array = array(
            'anl_id_pct' => $pct_id,
            'anl_usu_modificacion' => $this->tank_auth->get_user_id(),
            'anl_fecha_modificacion' => date('Y-m-d H:i:s')
        );

        $this->gsatelite->actualizar_array('anl_anticipo_cliente', $anticipo_array, array('anl_id' => $anl_id));
    }

    public function partidas_anticipos_pendientes_masiva() {

        //if ($this->input->post()) {
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        ini_set('max_input_vars', '15000');

        //Se obtienen las transacciones por el tipo de Transacccion
        $lstAnticiposPendientes = $this->gsatelite->get_tabla('anl_anticipo_cliente', array('anl_id_pct IS NULL' => null));

        $contadorPartidas = 0;
        foreach ($lstAnticiposPendientes as $anticipos) {
            $this->generar_partidas_contables_anticipo($anticipos['anl_id']);
            $contadorPartidas++;
        }

        $respuesta = array(
            'cantidad_partidas' => $contadorPartidas
        );


        echo json_encode($respuesta);
        //}
      }

      public function obtener_sucursal()
      {
        $cli_id                 = $this->input->post('cliente');
        $forma_facturacion      = ($this->input->post('forma_facturacion')  != false )?$this->input->post('forma_facturacion'):"";

        $where = null;
        $groupby = 'scl_id';

        $where['cli_id']        = $cli_id;
        $where['fac_estado']    = 1;

        if ($forma_facturacion != "" OR  $forma_facturacion != null) {
            $forma_facturacion              = ($forma_facturacion != 2)?$forma_facturacion:null;
            $where['fac_generacion_masiva'] = $forma_facturacion ;
        }
        $sucursales = $this->facturacion_model->get_datos_pagos($where,$groupby);
  
        $opciones = "<option value='0'>Seleccione</option>";
        if (count($sucursales) > 0) {
            foreach ($sucursales as $dpv) {
              if ($dpv['scl_id']>0) {
                $opciones .= "<option value='" . $dpv['scl_id'] . "'>" . $dpv['scl_nombre'] . "</option>";
              }

            }
        }
        $arreglo = array('sucursales' => $opciones);
        echo json_encode($arreglo);
      }


    /*
    * @author: Mario Marquez
    * @date: 13/11/2018
    * @Descripcion: Generacion masiva de partidas contables para abonos de clientes
    */

    public function generar_partida_contable_abonos_cliente(){
        if ($this->input->post()) {
            //Se obtiene los abonos de clientes que no continen partidas
          $where_anticipo = " abc_id not in (
                              SELECT abf_id_abc FROM (
                              SELECT abf_id_abc, GROUP_CONCAT(DISTINCT abf_id_fac) idf, COUNT(DISTINCT abf_id_fac) n FROM abf_abono_factura
                              JOIN abc_abono_cliente a2 on a2.abc_id = abf_id_abc
                              JOIN ana_anticipo_abono on ana_id_abc = a2.abc_id
                              GROUP BY a2.abc_id
                              HAVING n = 1
                              ) t
                              )";

                              $this->db->where($where_anticipo,null, false);
                              $this->db->group_by('abc_id');
            $abonos_cliente = $this->gsatelite->get_tabla('abc_abono_cliente' , array('abc_id_pct is null' => null));

            if(count($abonos_cliente)> 0){
                foreach ($abonos_cliente as $abono) {
                    $pct_id = $this->generar_partida_contable_pago($abono['abc_id']);

                    $PartidasIds[] = array('partida_id' => $pct_id);
                }
            }
            echo json_encode(array('cantidad_partidas' => count($PartidasIds)));
        }
        else{
             echo "Debe realizar un metodo de envio de datos";
        }
    }


    /**
    * @author René Castaneda
    * @since 2018-12-12
    * @return Partida contable usando anticipo.
    * @param id del registro abf
    */
    public function generar_partida_contable_pago_uso_anticipo($abf_id,$tipo_cuenta_utilizar=null){
        //realizar la partida si solo se ha aplicado a una factura.
                            $this->db->join('fac_factura','abf_id_fac = fac_id');
        $factura_aplicada = $this->gsatelite->get_tabla('abf_abono_factura',array('abf_id_abc'=>$abf_id));
        if(count($factura_aplicada) > 1) return null; //si hay más de una factura no 
        //validar credito o contado
        $tipo_cuenta_cxc = ($factura_aplicada[0]['fac_id_tpg'] == 1)? "TRANSITORIA_CXC":"CUENTA_POR_COBRAR"; 
       
        $tipo_cuenta_cxc = (trim($tipo_cuenta_utilizar) != "" )? $tipo_cuenta_utilizar:$tipo_cuenta_cxc;
        
        /**************Parte Debe******************************************/
        //Obtener tipo de partida
        $id_tpd = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('INGRESO'));
        $tcn_id_debe_cxc = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array("$tipo_cuenta_cxc"));
        $debe_cxc = $this->cuentas_cobrar_model->get_pago_cliente_debe_cxc($abf_id, $tcn_id_debe_cxc);
        //print_r($debe_cxc); die();
        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        
        //Se genera correlativo y codigo de partida
        $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tpd));
        $corr = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
        $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
        $codigo = $tipo_abr . '-' . $numero;

        //Obtener concepto de la partida contable para pagos.
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 12));//Id Partida contabilidad Banco
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        }else{
          $pct_concepto = 'Concepto no definido';
        }

        $abc_data = $this->gsatelite->get_tabla('abc_abono_cliente', array('abc_id' => $abf_id));

        //Se define un tipo cuenta transitoria CXC cliente para contado
        //Se define un tipo cuenta CXC credito
        $this->db->join('fac_factura','abf_id_fac = fac_id');
        $ref_fac_abo = $this->gsatelite->get_tabla('abf_abono_factura', array('abf_id_abc' => $abf_id));

        $csvFacturas = implode(',',array_column($ref_fac_abo, 'fac_numero'));
        $pct_concepto .= ' Facturas #: '.$csvFacturas;
        //Si se encontraron cuentas se ejecuta el proceso de partidas

        $this->db->join('anl_anticipo_cliente','anl_id = ana_id_anl');
        $anticipo_ref = $this->gsatelite->get_tabla('ana_anticipo_abono', array('ana_id_abc' => $abf_id));

        $csvFacturas_anticipo = implode(',',array_column($anticipo_ref, 'anl_comprobante'));
        $pct_concepto .= (count($anticipo_ref) >0)? ' Anticipos #: '.$csvFacturas_anticipo:"";
        $id_tipo_ant = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('ANTICIPOS'));
        $where_cnt_ant = array(
            'cxn_id_cli' => $ref_fac_abo[0]['fac_id_cli'],
            'cxn_id_tcn' => $id_tipo_ant,
            'cxn_id_tpg' => 1,
        );
        $cuenta_anticipo_cliente = $this->gsatelite->get_tabla('cxn_cuentaxcliente',$where_cnt_ant);
        $id_cuenta_anticipo_cliente = (count($cuenta_anticipo_cliente) > 0 )? $cuenta_anticipo_cliente[0]['cxn_id_cnt']:$this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $monto_anticipo_abono = (count($anticipo_ref) >0)? array_sum(array_column($anticipo_ref, 'ana_monto')):0;

        $usuario_actual = $this->tank_auth->get_user_id();
        $fecha_actual = date('Y-m-d H:i:s');

        if(count($debe_cxc) >0 ){

            $total_partida = array_sum(array_column($debe_cxc, 'total_abonar')) + $monto_anticipo_abono;
            //Ingreso en la pct_partida contable
            $array_partida = array(
                'pct_id_tpd'    => $id_tpd,
                'pct_id_prc'    => null,
                'pct_concepto'  => $pct_concepto,
                'pct_modulo'    => 1,
                'pct_fecha'     => $abc_data[0]['abc_fecha'],
                'pct_total'     => number_format($total_partida, 2, '.', ''),
                'pct_estado'    => 1,
                'pct_fecha_crea'=> $fecha_actual,
                'pct_fecha_mod' => $fecha_actual,
                'pct_usu_crea'  => $usuario_actual,
                'pct_usu_mod'   => $usuario_actual,
                'pct_correlativo' => $corr->correlativo,
                'pct_codigo'    => $codigo
            );

            $agregar    = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

            //Ingreso detalle partida debe
            foreach ($debe_cxc as $key => $val) {
                if ($val['total_abonar'] > 0 ) {
                    $array_detalle = array(
                        'dpc_id_cnt'    => $val['cnt_id'],
                        'dpc_id_pct'    => $agregar,
                        'dpc_concepto'  => $pct_concepto,
                        'dpc_debe'      => number_format($val['total_abonar'], 2, '.', ''),
                        'dpc_haber'     => 0.00,
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea'=> $fecha_actual,
                        'dpc_fecha_mod' => $fecha_actual,
                        'dpc_usu_crea'  => $usuario_actual,
                        'dpc_usu_mod'   => $usuario_actual
                    );

                    $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }

            if (count($anticipo_ref)>0) {

                $array_detalle = array(
                    'dpc_id_cnt'    => $id_cuenta_anticipo_cliente,
                    'dpc_id_pct'    => $agregar,
                    'dpc_concepto'  => $pct_concepto,
                    'dpc_debe'      => number_format($monto_anticipo_abono, 2, '.', ''),
                    'dpc_haber'     => 0.00,
                    'dpc_estado'    => 1,
                    'dpc_fecha_crea'=> $fecha_actual,
                    'dpc_fecha_mod' => $fecha_actual,
                    'dpc_usu_crea'  => $usuario_actual,
                    'dpc_usu_mod'   => $usuario_actual
                );

               $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }





            /*************Fin parte Debe***************************************/
            /**************Parte Haber******************************************/

            $haber = $this->cuentas_cobrar_model->get_pago_cliente_haber($abc_data[0]['abc_id'], $tcn_id_debe_cxc);
            //Ingreso detalle partida  debe
            foreach ($haber as $key => $val) {
                $array_detalle = array(
                    'dpc_id_cnt'    => $val['cnt_id'],
                    'dpc_id_pct'    => $agregar,
                    'dpc_concepto'  => $pct_concepto,
                    'dpc_debe'      => 0.00,
                    'dpc_haber'     => number_format($val['total_abonar'], 2, '.', ''),
                    'dpc_estado'    => 1,
                    'dpc_fecha_crea'=> date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                );

                $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }
            /*************Fin parte Haber***************************************/


            /*************Fin parte Debe***************************************/
            /**************Parte Haber******************************************/

/*           $tipo_cuenta_cxc_haber = "INGRESO"; //($factura_aplicada[0]['fac_id_tpg'] == 1)? "CAJA":"INGRESO"; 
           $tcn_id_haber_cxc = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array("$tipo_cuenta_cxc_haber"));

           //Se agrega el id del tipo cuenta que deben ser las cuentas para los productos
           $sumatoria_haber = 0;
           $diferencia_partida = 0;
           foreach ($ref_fac_abo as $regf) {
               $where_prod['idtipo_cnt'] = $tcn_id_haber_cxc;
               $where_prod['fac_id'] = $regf['fac_id'];
               $where_imp['fac_id'] = $regf['fac_id'];
               $cnt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac($where_prod);
               $cnt_imps = $this->facturacion_model->get_cnt_x_impu_x_fac($where_imp);
               $sumatoria_haber = array_sum(array_column($cnt_prods, 'subtotal_prod')) + array_sum(array_column($cnt_imps, 'subtotximpcuenta'));
           }

           $diferencia_partida = $sumatoria_haber - $total_partida;


            foreach ($ref_fac_abo as $regf) {
                $where_prod['idtipo_cnt'] = $tcn_id_haber_cxc;
                $where_prod['fac_id'] = $regf['fac_id'];
                $cnt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac($where_prod);
                foreach ($cnt_prods as $j => $deta) {
                    $dpc_id_cnt = ($deta['cnt_id'] > 0) ? $deta['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                    if($deta['subtotal_prod']>0) {

                        if($diferencia_partida>0) 
                        {
                            //Prorratear
                            $deta['subtotal_prod'] = (($deta['subtotal_prod']/$sumatoria_haber) * $total_partida); 
                        }

                        $array_detalle = array(
                            'dpc_id_cnt' => $dpc_id_cnt,
                            'dpc_id_pct' => $agregar,
                            'dpc_concepto' => $pct_concepto,
                            'dpc_debe' => 0.00,
                            'dpc_haber' => $deta['subtotal_prod'],
                            'dpc_estado' => 1,
                            'dpc_fecha_crea' => $fecha_actual,
                            'dpc_fecha_mod' => $fecha_actual,
                            'dpc_usu_crea' => $usuario_actual,
                            'dpc_usu_mod' => $usuario_actual
                        );

                        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                    }
                }
            }*/


            // $haber_cxc = $this->cuentas_cobrar_model->get_pago_cliente_haber_cxc($abf_id, $tcn_id_haber);
            // //Ingreso detalle partida  debe
            // foreach ($haber_cxc as $key => $val) {
            //     $array_detalle = array(
            //         'dpc_id_cnt'    => $val['cnt_id'],
            //         'dpc_id_pct'    => $agregar,
            //         'dpc_concepto'  => $pct_concepto,
            //         'dpc_debe'      => 0.00,
            //         'dpc_haber'     => number_format($val['total_abonar'], 2, '.', ''),
            //         'dpc_estado'    => 1,
            //         'dpc_fecha_crea'=> $fecha_actual,
            //         'dpc_fecha_mod' => $fecha_actual,
            //         'dpc_usu_crea'  => $usuario_actual,
            //         'dpc_usu_mod'   => $usuario_actual
            //     );

            //     $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            // }

/*
            #====================================================
            // procesar los impuestos de la factura pagada
            foreach ($ref_fac_abo as $regf) {
                $where_imp['fac_id'] = $regf['fac_id'];
                $cnt_imps = $this->facturacion_model->get_cnt_x_impu_x_fac($where_imp);
                //Ingresar los detalles de la partida para los impuesto
                foreach ($cnt_imps as $j => $deta) {
                    $dpc_id_cnt = ($deta['cxe_id_cnt'] > 0) ? $deta['cxe_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                    
                    if($diferencia_partida>0) 
                    {
                        //Prorratear
                        $deta['subtotximpcuenta'] = (($deta['subtotximpcuenta']/$sumatoria_haber) * $total_partida); 
                    }

                    $array_detalle = array(
                        'dpc_id_cnt' => $dpc_id_cnt,
                        'dpc_id_pct' => $agregar,
                        'dpc_concepto' => 'Impuestos',
                        'dpc_debe' => 0.00,
                        'dpc_haber' => $deta['subtotximpcuenta'],
                        'dpc_estado' => 1,
                        'dpc_fecha_crea' => $fecha_actual,
                        'dpc_fecha_mod' => $fecha_actual,
                        'dpc_usu_crea' => $usuario_actual,
                        'dpc_usu_mod' => $usuario_actual
                    );

                    $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }*/

            /*************Fin parte Haber***************************************/

            $array_detalle_bd = array(
                    'abc_id_pct' => $agregar,
                    'abc_estado' => 1,
                    'abc_fecha_modificacion' => $fecha_actual,
                    'abc_usu_modificacion' => $usuario_actual
                );
            $this->gsatelite->actualizar_array('abc_abono_cliente', $array_detalle_bd, array('abc_id' => $abc_data[0]['abc_id']));
        }

        return $agregar;
    }


    //rené castaneda (centralizacion de funciones para procesar abonos que usan anticipo, en forma masiva.)
    public function generar_partida_contable_abonos_cliente_anticipo()
    {   
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $where_anticipo = " abc_id in (
                            SELECT abf_id_abc FROM (
                            SELECT abf_id_abc, GROUP_CONCAT(DISTINCT abf_id_fac) idf, COUNT(DISTINCT abf_id_fac) n FROM abf_abono_factura
                            JOIN abc_abono_cliente a2 on a2.abc_id = abf_id_abc
                            JOIN ana_anticipo_abono on ana_id_abc = a2.abc_id
                            GROUP BY a2.abc_id
                            HAVING n = 1
                            ) t
                            )";

                            $this->db->where($where_anticipo,null, false);
                            $this->db->group_by('abc_id');
          $abonos_cliente = $this->gsatelite->get_tabla('abc_abono_cliente' , array('abc_id_pct is null' => null));

        $array_resultados = array();
        foreach ($abonos_cliente as $fila_abc) {
                
                $id_partida = $this->generar_partida_contable_pago_uso_anticipo($fila_abc['abc_id']);
                $array_resultados[] = array("id_abc"=>$fila_abc['abc_id'], "id_pct"=>$id_partida);
        }
        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }


    /**
    * @author Raul Escalante
    * @since 2019-02-18
    * @return sucursal
    * @param $like string para condicionar.
    */
    public function get_sucursal_like(){
        if ($_POST) {
            $like = $this->input->post('sucursal');
            $where['scl_estado'] = 1;
            $result = $this->cuentas_cobrar_model->get_sucursal_like($where,$like);
            echo json_encode($result);
        }
    }

     /**
        * @author Fracisco Orozco
        * @since 2019-07-03
        * @param STRING $banco.
        * @return HMTL cuentas bancarias
    */
    public function get_cuentas_bancarias(){
        if ($_POST) {
            $banco              = $this->input->post('banco');
            $html               = '<option value=""></option>';
            $where['cub_id_ban']= $banco;        
            $where['cub_estado']= 1;        
            $html              .= $this->gsatelite->get_dropdown('cub_cuenta_bancaria', '{cub_numero} - {cub_nombre}', '', $where, 'cub_id', null, null, true);
            $html              = str_replace('<option value="0">Seleccione</option>', '', $html);
            $html              = str_replace('<option value="0">Sin Registros</option>', '', $html);
            echo $html;
            die();
        }
    }

    /**
        * @author Raul Escalante
        * @since 2019-09-06
        * @return PDF recibo de pago
    */
    public function imprimir_recibo($id_abono = null){
        $this->load->library('EnLetras');
        $id_abono = ($id_abono != null) ? $id_abono : $this->input->post('id_abono');
        $where['abc_id'] = $id_abono;
        $data['detalles'] = $this->cuentas_cobrar_model->get_datos_recibo($where, 'abc_id, abf_id');
        $data['tipos'] = json_decode($this->gsatelite->get_parametro('SYS_ID_PAGO_EFECTIVO'), true);
        $data['es_abono'] = 1;
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/detalle_recibo_pago', $data, true);
        $this->load->library('pdf');
        $this->pdf->SetAutoPageBreak(true, 0);
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePDF($html, 'P', 'recibo_interno', 'Letter');
        die();
    }

    /**
        * @author Raul Escalante
        * @since 2020-Oct
        * @return PDF recibo de pago
    */
    public function imprimir_recibo_anticipo($id_anticipo = null){
        $this->load->library('EnLetras');
        $id_anticipo = ($id_anticipo != null) ? $id_anticipo : $this->input->post('id_anticipo');
        $where['anl_id'] = $id_anticipo;
        $data['detalles'] = $this->cuentas_cobrar_model->get_datos_recibo_anticipo($where);
        $data['es_abono'] = 0;
        $data['tipos'] = json_decode($this->gsatelite->get_parametro('SYS_ID_PAGO_EFECTIVO'), true);
        $html = $this->load->view('modulo_cuentas_cobrar/procesos/detalle_recibo_pago', $data, true);
        $this->load->library('pdf');
        $this->pdf->SetAutoPageBreak(true, 0);
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePDF($html, 'P', 'recibo_interno', 'Letter');
        die();
    }

    public function partida_automatica_anular_pago($abc_id, $prceso){
        //datos generales para la obtención y manipulación de los datos.
        $id_tpd = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('INGRESO'));
        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        $tcn_id_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('CAJA'));
        $tcn_id_haber1 = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('CUENTA_POR_COBRAR'));
        $tcn_id_haber2 = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('TRANSITORIA_CXC'));
        $where = array();
            //Obtener tipo de partida
        $where['fac_id_origen_devolucion IS NULL'] = null;
        $where['abf_monto >'] = 0;
        $where['abc_id'] = $abc_id;
        $datos_debe = array();
        $datos_haber = array();
        $where_debe['tcn_id_debe'] = $tcn_id_debe;
        $where_haber['tcn_id_haber'] = $tcn_id_haber1;
        $where_haber['tcn_id_haber_tran'] = $tcn_id_haber2;
        if (isset($consolidar) && $consolidar == 1) { //por el momento es lo mismo de la individual (para pruebas)
            $groupby_query = "cnt_id";
            $partidas = $this->contabilidad_model->get_pago_cliente_partida($where); //sin group_by
        } else {
            $groupby_query = "abc_id, cnt_id";
            $partidas = $this->contabilidad_model->get_pago_cliente_partida($where, 'abc_id');
        }
        //PARA ANTICIPOS INMERSOS
        $tcn_id_haber_ant = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('ANTICIPOS'));
        $where_haber_ant['tcn_id_haber'] = $tcn_id_haber_ant;
        //generar su respectivo debe y haber para cada partida
        $correlativo_pct = 0;
        foreach ($partidas as $pct) {
            if (trim($pct['id_referencia']) !='') {
                $correlativo_pct++;
                $where_det = $where;
                $where_det["abc_id IN (".$pct['id_referencia'].")"] = null; //se ira sobreescribiendo
                $debe = $this->contabilidad_model->get_pago_cliente_partida_debe($where_det, $where_debe, $groupby_query);
                $where_debe['tcn_id_debe'] = $tcn_id_haber_ant;
                $debe_anticipo = $this->contabilidad_model->get_pago_anticipo_cliente_partida_debe($where_det, $where_debe, $groupby_query);
                if(array_sum(array_column($debe, 'total_debe')) == 0){
                    $debe = array();
                }
                if(count($debe_anticipo) > 0 && array_sum(array_column($debe_anticipo, 'total_debe')) > 0 ){
                    $debe = array_merge($debe, $debe_anticipo);
                }
                $haber = $this->contabilidad_model->get_pago_cliente_partida_haber($where_det, $where_haber, $groupby_query);
                //PARA ANTICIPOS INMERSOS
                $where_det_ant["abc_id IN (".$pct['id_referencia'].")"] = null; //se ira sobreescribiendo
                $haber_anticipos = $this->contabilidad_model->get_anticipo_cliente_partida_haber($where_det_ant, $where_haber_ant, $groupby_query,1);
                $datos_debe[$correlativo_pct] = $debe;
                $datos_haber[$correlativo_pct] = array_merge($haber,$haber_anticipos);
                $where_det = array(); //limpiar el where
                $where_det_ant = array(); //limpiar el where
            }
        }
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 12));//no utilizado
        $data['correlativo_partida'] = (isset($correlativo_partida)) ? $correlativo_partida : 1;
        $data['pct_concepto'] = $pct_concepto;//no utilizado
        $data['partidas'] = $partidas;
        $data['debe'] = $datos_debe;
        $data['haber'] = $datos_haber;

        $id_tipo_partida         = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id'=>2, 'tpd_estado'=>1));
        $pct_correlativo= $this->gsatelite->get_max("pct_partida_contable","pct_id")+1;
        $codigo         = $id_tipo_partida[0]['tpd_prefijo'].'-'.$pct_correlativo;   // Codigo que tendra la partida

        $array_partida = array(
            'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
            'pct_concepto'      => "Anulación ".$data['partidas'][0]['concepto_partida'],
            'pct_total'         => $data['partidas'][0]['total_partida'],
            'pct_fecha'         => date('Y-m-d'),
            'pct_correlativo'   => $pct_correlativo,
            'pct_codigo'        => $codigo,
            'pct_estado'        => 1,
            'pct_fecha_crea'    => date('Y-m-d H:i:s'),
            'pct_fecha_mod'     => date('Y-m-d H:i:s'),
            'pct_usu_crea'      => $this->tank_auth->get_user_id(),
            'pct_usu_mod'       => $this->tank_auth->get_user_id()
        );
        if (($data['debe'][1]['cnt_id'] != "" && $data['haber'][1]['cnt_id'] != "") || ($data['debe'][1][0]['cnt_id'] != "" && $data['haber'][1][0]['cnt_id'] != "")) {
            //PARA EL CASO DE NO HABER CONFIGURADO CUENTAS CONTABLES, SI NO HAY NI SIQUIERA CUENTA POR DEFECTO, NO SE HACE LA PARTIDA
            $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                //Se procesan los detalles
            foreach ($data['haber'][1] as $dpc) {
                $array_detalle = array(
                    'dpc_id_cnt'        => $dpc['cnt_id'],
                    'dpc_id_pct'        => $pct_id,
                    'dpc_concepto'      => 'Anulación por pagos de facturas',
                    'dpc_debe'          => $dpc['total_haber'],
                    'dpc_haber'         => 0.00, 
                    'dpc_estado'        => 1,
                    'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                    'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }
            foreach ($data['debe'][1] as $dpc) {
                $array_detalle = array(
                    'dpc_id_cnt'        => $dpc['cnt_id'],
                    'dpc_id_pct'        => $pct_id,
                    'dpc_concepto'      => 'Anulación por pagos de facturas',
                    'dpc_debe'          => 0.00,
                    'dpc_haber'         => $dpc['total_debe'], 
                    'dpc_estado'        => 1,
                    'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                    'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                );                    
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }
        }else{
            $pct_id = 0;
        }
        // echo $pct_id;
        return $pct_id;
    }

    /**
    * @author Raul E.
    * @since 2020-abril
    * @return Grid con los anticipo de los clientes
     */
    public function anticipos_cliente(){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal'] = 'Anular Anticipos de cliente';
        cargarvista($data);
    }

    /**
    * @author Raul E.
    * @since 2020-abril
    * @return filtrar los anticipo de los clientes para anularlos
     */
    public function buscar_anticipos_cliente(){
        if ($_POST) {
            $fec_ini = formatear_fecha('Y-m-d', $this->input->post('fec_ini'));
            $fec_fin = formatear_fecha('Y-m-d', $this->input->post('fec_fin'));
            $estados = $this->input->post('estado');
            $cliente = $this->input->post('cliente');
            $where["DATE(anl_fecha) >= '$fec_ini'"] = null;
            $where["DATE(anl_fecha) <= '$fec_fin'"] = null;
            if ($cliente != "") {
                $where["anl_id_cli"] = $cliente;
            }
            if ($estados != "") {
                if (intval($estados) == 1) {
                    $where["anl_monto = anl_saldo"] = null;
                } elseif (intval($estados) == 2) {
                    $where["anl_monto != anl_saldo"] = null;
                    $where["anl_saldo >"] = 0;
                } else {
                    $where["anl_saldo"] = 0;
                }                
            }
            $data['registros'] = $this->cuentas_cobrar_model->get_anticipo_cliente($where);
            $data['version'] = 1;
            $html = $this->load->view('modulo_cuentas_cobrar/procesos/filtrar_anticipo_cliente', $data, true);
            echo $html;
        }        
        die();
    }

    /**
    * @author Raul E.
    * @since 2020-abril
    * @return anular anticipo
     */
    public function anular_pago_anticipo($anticipo = null, $razon = null){
        $html = "";
        $exito = 0;
        $id_anl = 0;
        if ($this->input->post() || $anticipo > 0) { 
            $id_anl = $this->input->post('id_anl');
            $motivo = $this->input->post('motivo_anulacion');
            $id_prc = $this->input->post('id_prc');
            if ($anticipo > 0) {
                $anl = $this->gsatelite->get_tabla("anl_anticipo_cliente", array('anl_id' => $anticipo, 'anl_estado' => 1));
                if (is_numeric($anl[0]['anl_id']) && $anl[0]['anl_id'] > 0) {
                    $id_anl = $anl[0]['anl_id'];
                    $motivo   = (trim($razon) != "") ? $razon : "";
                } else {
                    die("No se ha seleccionado ningun anticipo activo");
                }
            }
            if (trim($motivo) !='' and $id_anl > 0) { 
                $anticipos_abonos = $this->cuentas_cobrar_model->get_anticipo_abono(array('ana_id_anl' => $id_anl));
                if (count($anticipos_abonos) > 0) {
                    $exito = 0; //Si hay registros en la ana_anticipo_abono es porque el anticipo esta en uso
                } else {
                    $anticipo_an = array(
                        'anl_estado' => 0,
                        'anl_fecha_anulacion' => date('Y-m-d H:i:s'),
                        'anl_observacion_anulacion' => $motivo,
                        'anl_usu_anulacion' => $this->tank_auth->get_user_id(),
                        'anl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'anl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $actualizar = $this->gsatelite->actualizar_array('anl_anticipo_cliente', $anticipo_an, array('anl_id' => $id_anl));
                    $partidas = $this->partida_automatica_anular_anticipo($id_anl, $id_prc);
                    $exito = ($actualizar > 0) ? 1 : 0;
                }
                echo json_encode(array('exito' => $exito));
                die();
            }
            $this->db->join('cli_cliente', 'cli_id = anl_id_cli');
            $registro = $this->gsatelite->get_tabla('anl_anticipo_cliente', array('anl_id' => $id_anl));
            $data['registro'] = $registro[0];
            $html = $this->load->view('modulo_cuentas_cobrar/procesos/anular_pago_anticipo', $data, true);
        }
        echo json_encode(array('html'=>$html));
    }

    public function partida_automatica_anular_anticipo($anl_id = null, $id_prc = null){
        $n_procesadas = 0;
        $id_tpd = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('INGRESO'));
        $tcn_id_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('ANTICIPOS'));
        $tcn_id_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CAJA'));
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('DIARIO'));
        $where = array('anl_id' => $anl_id);
        $datos_debe = array();
        $datos_haber = array();
        $detalle_partida = array();
        $where_debe['tcn_id_haber'] = $tcn_id_debe;
        $where_haber['tcn_id_debe'] = $tcn_id_haber;
        $partidas = $this->contabilidad_model->get_anticipo_cliente_partida($where, 'anl_id');
        $n_partidas = count($partidas);
        foreach ($partidas as $ky => $pct) {
            if (trim($pct['id_referencia']) !='') {
                $detalle_partida[$ky]['debe'] = $this->contabilidad_model->get_anticipo_cliente_partida_haber($where, $where_debe, 'anl_id');
                $detalle_partida[$ky]['haber'] = $this->contabilidad_model->get_anticipo_cliente_partida_debe($where, $where_haber, 'anl_id');
            }
        }
        for ($i = 0; $i < $n_partidas ; $i++) {              
            $correlativo = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
            $array_partida = array(
                'pct_id_tpd'        => $id_tipo_partida,
                'pct_id_prc'        => $id_prc,
                'pct_concepto'      => "Anulación Anticipo Cliente #: " . $partidas[$i]['anl_comprobante'],
                'pct_total'         => number_format($partidas[$i]['total_partida'], 2, '.', ''),
                'pct_fecha'         => date('Y-m-d'),
                'pct_correlativo'   => $correlativo,
                'pct_estado'        => 1,
                'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                'pct_usu_mod'       => $this->tank_auth->get_user_id()
            );
            $partida_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
            $n_procesadas++;
            for ($n = 0; $n < count($detalle_partida); $n++) {
                $detalle_debe = $detalle_partida[$n]['debe'];
                $detalle_haber = $detalle_partida[$n]['haber'];
                if($partida_id > 0){ 
                    $detalle = 0;
                    foreach ($detalle_debe as $ky => $debe) {
                        $array_detalle_debe = array(
                            'dpc_id_cnt'        => $debe['cnt_id'],
                            'dpc_id_pct'        => $partida_id,
                            'dpc_concepto'      => "Anulación Anticipo Cliente #: " . $partidas[$i]['anl_comprobante'],
                            'dpc_debe'          => number_format($debe['total_haber'], 2, '.', ''),
                            'dpc_haber'         => number_format($debe['total_debe'], 2, '.', ''), 
                            'dpc_estado'        => 1,
                            'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                            'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                            'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                            'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                        );
                        $detalle += $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_debe);
                    }
                    foreach ($detalle_haber as $ke => $haber) {
                        $array_detalle_haber = array(
                            'dpc_id_cnt'        => $haber['cnt_id'],
                            'dpc_id_pct'        => $partida_id,
                            'dpc_concepto'      => "Anulación Anticipo Cliente #: " . $partidas[$i]['anl_comprobante'],
                            'dpc_debe'          => number_format($haber['total_haber'], 2, '.', ''),
                            'dpc_haber'         => number_format($haber['total_debe'], 2, '.', ''), 
                            'dpc_estado'        => 1,
                            'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                            'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                            'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                            'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                        );
                        $detalle += $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_haber);
                    }                                        
                }                
            }            
        }
        if($n_procesadas > 0 && $detalle > 0){
            return 1;
        } else {
            return 0;
        }        
    }
}
