<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Descripcion
 *  todos los mantenimientos basicos
 *  Controlador de mantenimientos - Módulo Cuentas por cobrar
 * @author:     René Castaneda  
 * @version:    2017/06/02
 * @since:      2017/06/02
 * @package:    Erp Satelite
 * =================================================================================
 */
class Mantenimientos extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('cuentas_cobrar_model');
    }

    function index() {
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Cuentas por Cobrar';
            $this->_cargarvista(null, $data);
        }
    }

    /**
     * @author: Mario Marquez
     * @since: 24/06/2017
     * Mantenimiento de cobradores
     */
    function cobradores() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_cuentas_cobrar/mantenimientos/cobradores');
        $crud = new grocery_CRUD();
        $crud->set_table('cob_cobrador');
        $crud->set_subject('Cobrador');
        $crud->unset_export()->unset_print();

        $columns = array(
            'cob_id_emp',
            'cob_estado'
        );

        $required = array(
            'cob_id_emp',
            'cob_estado'
        );

        $display_as = array(
            'cob_id_emp' => 'Empleado',
            'cob_estado' => 'Estado',
        );

        $add_fields = array(
            'cob_id_emp',
            'cob_estado',
            'cob_usu_creacion',
            'cob_fecha_creacion',
            'cob_usu_modificacion',
            'cob_fecha_modificacion'
        );

        $edit_fields = array(
            'cob_id_emp',
            'cob_estado',
            'cob_usu_modificacion',
            'cob_fecha_modificacion'
        );

        $crud->required_fields($required);
        $crud->columns($columns);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->display_as($display_as);
        $crud->field_type('cob_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('cob_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->set_relation('cob_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}', array('emp_estado' => 1));
        $crud->set_rules('cob_id_emp', 'Empleado', 'required|campo_unico[cob_cobrador.cob_id_emp]');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cob_estado', 'hidden', 1);
            $crud->field_type('cob_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cob_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->field_type('cob_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_cuentas_cobrar/mantenimientos/cobradores/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Cobradores";
        cargarvista($data, $output);
    }

}

/* End of file mantenimientos.php */
/* Location: ./application/controllers/modulo_cuentas_cobrar/mantenimientos.php */