<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Descripcion
 *  todos los mantenimientos basicos
 *  Controlador de mantenimientos - Módulo Cuentas por cobrar
 * @author:     René Castaneda
 * @version:    2017/06/02
 * @since:      2017/06/02
 * @package:    Erp Satelite
 * =================================================================================
 */
class Mantenimiento extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        //$this->load->model('gsatelite');
        $this->load->model('cuentas_cobrar_model');

    }

    function index() {
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }else{
            $data['titulo_personal'] = 'Modulo de Cuentas por Cobrar';
            cargarvista(null, $data);
        }
    }

    function formas_pago(){
        satelite_validar();
        $this->load->library('../controllers/facturacion/entradas');
        //print_r($r);
        //$permisos = $this->gsatelite->get_permisos_opcion();
        $this->entradas->forma_pago('modulo_cuentas_cobrar/mantenimiento');
        //$data['html'] = $this->load->view('facturacion/entradas/tipos_pago', $info, true);
        //cargarvista(null, $info);
    }

    /**
     * @author: Mario Marquez
     * @since: 24/06/2017
     * Mantenimiento de cobradores
     */
    function cobradores() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();
        $crud->set_table('cob_cobrador');
        $crud->set_subject('Cobrador');
        $crud->unset_export()->unset_print();

        $columns = array(
            'cob_codigo',
            'cob_nombre',
            'cob_apellido',
            'cob_estado'
        );

        $required = array(
            'cob_codigo',
            'cob_nombre',
            'cob_apellido',
            'cob_telefono',
            'cob_estado'
        );

        $display_as = array(
            'cob_codigo' => 'Código',
            'cob_nombre' => 'Nombres',
            'cob_apellido' => 'Apellidos',
            'cob_id_emp' => 'Empleado',
            'cob_telefono' => 'Teléfono',
            'cob_email' => 'E-mail',
            'cob_estado' => 'Estado',
            'rutas' => 'Rutas de Cobro'
        );

        $add_fields = array(
            'cob_id_emp',
            'cob_codigo',
            'cob_nombre',
            'cob_apellido',
            'cob_telefono',
            'cob_email',
            'cob_estado',
            'rutas',
            'cob_usu_creacion',
            'cob_fecha_creacion',
            'cob_usu_modificacion',
            'cob_fecha_modificacion'
        );

        $edit_fields = array(
            'cob_id_emp',
            'cob_codigo',
            'cob_nombre',
            'cob_apellido',
            'cob_telefono',
            'cob_email',
            'cob_estado',
            'rutas',
            'cob_usu_modificacion',
            'cob_fecha_modificacion'
        );

        $crud->required_fields($required);
        $crud->columns($columns);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->display_as($display_as);
        $crud->field_type('cob_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('cob_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->set_relation('cob_id_emp', 'emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', array('emp_estado' => 1));
        // $crud->set_rules('cob_id_emp', 'Empleado', 'required|campo_unico[cob_cobrador.cob_id_emp]');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cob_estado', 'hidden', 1);
            $crud->field_type('cob_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cob_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->field_type('cob_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $auditoria = array(
            'rxb_estado' => 1,
            'rxb_usu_creacion' => $this->tank_auth->get_user_id(),
            'rxb_fecha_creacion' =>  date('Y-m-d H:i:s'),
            'rxb_usu_modificacion' => $this->tank_auth->get_user_id(),
            "rxb_fecha_modificacion" => date('Y-m-d H:i:s')
        );

        $crud->set_relation_n_n("rutas", "rxb_rutaxcobrador","rtc_ruta_cobro", "rxb_id_cob", "rxb_id_rtc", "{rtc_nombre}", null, array("rtc_estado" => 1,"rtc_id NOT IN(SELECT rxb_id_rtc FROM rxb_rutaxcobrador)" => null), $auditoria);

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Cobradores";
        cargarvista($data, $output);
    }

    public function validar_existe_cobrador(){
        $evitar = ($this->input->post("evitar") > 0) ? $this->input->post("evitar") : 0;
        $empleado = (is_numeric($this->input->post("empleado")) && $this->input->post("empleado") > 0) ? $this->input->post("empleado") : 0;
        $existe_usuario = $this->gsatelite->get_tabla('cob_cobrador', array('cob_id_emp' => $empleado, 'cob_id != ' => $evitar, 'cob_estado' => 1));
        echo json_encode(array('existe' => count($existe_usuario)));
    }

    public function datos_emp(){
        $emp_id = (is_numeric($this->input->post("empleado")) && $this->input->post("empleado") > 0) ? $this->input->post("empleado") : 0;
        $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $emp_id, 'emp_estado' => 1));
        if ($empleado > 0) {
            $code = $empleado[0]['emp_codigo'];
            $name = $empleado[0]['emp_nombre'];
            $last = $empleado[0]['emp_apellido'];
                    $this->db->join('tel_telefono', 'tel_id = txm_id_tel');
            $txms = $this->gsatelite->get_tabla('txm_telefonoxempleado', array('txm_id_emp' => $emp_id, 'tel_estado' => 1));
            $cxps = $this->gsatelite->get_tabla('cxp_correoxempleado', array('cxp_id_emp' => $emp_id, 'cxp_estado' => 1));
            $tele = (count($txms) > 0) ? $txms[0]['tel_numero'] : "";
            $mail = (count($cxps) > 0) ? $cxps[0]['cxp_correo'] : "";
        } else {
            $code = $name = $last = $tele = $mail = "";
        }        
        echo json_encode(array('codigo' => $code, 'nombre' => $name, 'apellido' => $last, 'telefono' => $tele, 'correo' => $mail));
    }

    function clientes() {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->clientes('no', 'modulo_cuentas_cobrar');
    }

    function nuevo_cliente() {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->nuevo_cliente(null, null, true);
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/nuevo_cliente', $info, true);
        cargarvista(null, $data);
    }

    function editar_cliente($id_cliente) {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->editar_cliente($id_cliente, null, true);
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/editar_cliente', $info, true);
        cargarvista(null, $data);
    }

    function tipos_pago() {
        satelite_validar();
        $this->load->library('../controllers/facturacion/entradas');
        //$permisos = $this->gsatelite->get_permisos_opcion();
        $this->entradas->tipos_pago('modulo_cuentas_cobrar/mantenimiento');
        //$data['html'] = $this->load->view('facturacion/entradas/tipos_pago', $info, true);
        //cargarvista(null, $info);
    }

    function agregar_tipo_pago() {
        satelite_validar();
        $this->load->library('../controllers/facturacion/entradas');
        $this->entradas->agregar_tipo_pago('modulo_cuentas_cobrar/mantenimiento');
    }

    function editar_tipo_pago($id_tipo_pago, $ruta = null) {
        satelite_validar();
        $this->load->library('../controllers/facturacion/entradas');
        $this->entradas->editar_tipo_pago($id_tipo_pago, 'modulo_cuentas_cobrar/mantenimiento');
    }

    /**
     * @author: Rafael Cuchilla
     * @since: 18/09/2018
     * Mantenimiento de rutas de cobro
     */
    function rutas_cobro() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();
        $crud->set_table('rtc_ruta_cobro');
        $crud->set_subject('Rutas de Cobro');
        $crud->unset_export()->unset_print();

        $columns = array(
            'rtc_nombre',
            'rtc_descripcion'
        );

        $required = array(
            'rtc_nombre',
            'rtc_descripcion'
        );

        $display_as = array(
            'rtc_nombre' => 'Nombre',
            'rtc_descripcion' => 'Descripción',
            'rtc_estado' => 'Estado',
            'rtc_defecto' => 'Por defecto'
        );

        $add_fields = array(
            'rtc_nombre',
            'rtc_descripcion',
            'rtc_defecto',
            'rtc_estado',
            'rtc_usu_creacion',
            'rtc_fecha_creacion',
            'rtc_usu_modificacion',
            'rtc_fecha_modificacion'
        );

        $edit_fields = array(
            'rtc_nombre',
            'rtc_descripcion',
            'rtc_estado',
            'rtc_defecto',
            'rtc_usu_modificacion',
            'rtc_fecha_modificacion'
        );

        $crud->required_fields($required);
        $crud->columns($columns);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->display_as($display_as);
        $crud->field_type('rtc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('rtc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
      //  $crud->set_relation('cob_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}', array('emp_estado' => 1));
        $crud->set_rules('rtc_nombre', 'Nombre', 'required|campo_unico[rtc_ruta_cobro.rtc_nombre]');
        $crud->callback_edit_field('rtc_defecto',array($this,'defecto_callback'));

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('rtc_estado', 'hidden', 1);
            $crud->field_type('rtc_defecto', 'hidden', 0);
            $crud->field_type('rtc_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('rtc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->field_type('rtc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            //$crud->field_type('rtc_defecto', 'dropdown', array('1' => 'Si', '0' => 'No'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Rutas de Cobro";
        cargarvista($data, $output);
    }

    function defecto_callback($value)
    {
      $chec = ($value==1)?"checked='checked'":'';
      $html = '<input type="checkbox" id="chkest"'.$chec.' class="nostyle" />
      <input type="hidden" id="rtc_defecto" name = "rtc_defecto" value="'.$value.'"/>';
      return $html;
    }

    /**
     * @author Nelson Soriano
     * @since  22-08-2019
     * @description: Funcion para cargar el Preview de los Motoristas
     **/

    public function motoristas(){
        satelite_validar();
        $this->load->library('../controllers/transporte/cruds');
        $permisos = $this->gsatelite->get_permisos_opcion('transporte/cruds/motorista');
        $this->cruds->motorista(1,$permisos);
    }

    public function agregar_motorista(){
        satelite_validar();        
        $this->load->library('../controllers/transporte/cruds');
        $this->cruds->agregar_motorista('modulo_cuentas_cobrar/mantenimiento/agregar_motorista','modulo_cuentas_cobrar/mantenimiento/motoristas');
    }

     public function editar_motorista($id){
        satelite_validar();        
        $this->load->library('../controllers/transporte/cruds');
                                        //id               url accion                             url retorno                       
        $this->cruds->editar_motorista($id,'modulo_cuentas_cobrar/mantenimiento/editar_motorista','modulo_cuentas_cobrar/mantenimiento/motoristas');
    }
}

/* End of file mantenimientos.php */
/* Location: ./application/controllers/modulo_cuentas_cobrar/mantenimientos.php */
