<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->model('contratos_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Módulo de contratos';
            cargarvista(null, $data);
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function contratos() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_contratos/reportes/contratos');

        $this->db->group_by("art_id");
        $this->db->join("sxc_servicioxcliente","sxc_id_art = art_id");
        $servicios = $this->gsatelite->get_dropdown('art_articulo', '{art_nombre}', '', array('art_estado' => '1'), null, '', 'art_id', true);
        $data["servicios"] = str_replace('<option value="0">Seleccione</option>', '', $servicios);
        $data['titulo_personal'] = "Reporte de Contratos";

        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    public function reporte_contratos($flag = null) {
        satelite_validar();
        if ($_POST) {
            $post_array         = $this->input->post();
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte       = $this->input->post('tipo_reporte');

            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $proveedor = null;

            if ($flag != null) {
                $estado         = ($post_array['estado'] != '') ? $post_array['estado'] : null;
                $ordenado       = ($post_array['ordenado'] != '') ? $post_array['ordenado'] : null;
                $fecha_inicio   = ($post_array['fecha_desde'] != '' )? date('Y-m-d', strtotime($post_array['fecha_desde'])) : null;
                $fecha_fin      = ($post_array['fecha_hasta'] != '')? date('Y-m-d', strtotime($post_array['fecha_hasta'])) : null;
                $servicio       = ($post_array['slc_servicio'] != '')? $post_array['slc_servicio'] : null;
            } else {
                $estado         = ($post_array['filtro_estado'] != '') ? $post_array['filtro_estado'] : null;
                $ordenado       = ($post_array['filtro_orden'] != '') ? $post_array['filtro_orden'] : null;
                $fecha_inicio   = ($post_array['filtro_desde'] != '' )? date('Y-m-d', strtotime($post_array['filtro_desde'])) : null;
                $fecha_fin      = ($post_array['filtro_hasta'] != '')? date('Y-m-d', strtotime($post_array['filtro_hasta'])) : null;
                $servicio       = ($post_array['filtro_servicio'] != '')? $post_array['filtro_servicio'] : null;
            }

            /*
             * Se aplican los filtros
             */

            if ($estado != null) {
                $where['sxc_estado'] = ($estado == 2) ? 0 : $estado;
            }

            if ( $fecha_inicio != null || $fecha_fin != null) {
                $where['DATE(sxc_fecha_contrato) >='] = $fecha_inicio;
                $where['DATE(sxc_fecha_contrato) <='] = $fecha_fin;
            }

            if ( $servicio != null) {
                $where['sxc_id_art'] = $servicio;
            }

            $order_by = null;

            if ($ordenado != null && $ordenado == 1) {
                $order_by = "cli_codigo ASC";
            }
            if ($ordenado != null && $ordenado == 2) {
                $order_by = "cli_nombre ASC";
            }

            $data['reporte'] = $this->contratos_model->get_reporte_contratos($where, $order_by);
            //print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_contratos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;

            $html = $this->load->view('modulo_contratos/reportes/reporte_contratos', $data, true);
            //echo $html; die();
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Contratos';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Contratos_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Contratos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Reporte de Contratos';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function cuenta_cobrar($flag = null){
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        if ($_POST) {
            $periodo = $this->input->post('periodo_fecha');
            $cliente = $this->input->post('cliente_espec');
            $reporte = $this->input->post('reporte');
            $fec_ini = formatear_fecha('Y-m-d', '01-' . $periodo);
            $fec_fin = formatear_fecha('Y-m-t', $fec_ini);
            $fec_sob = date('Y-m-d', strtotime($fec_ini . "+1 month"));
            $where = array('fac_monto_pendiente > ' => 0);
            if ($cliente != "") {
                $where['cli_id'] = $cliente;
            }
            $m1 = explode('-', $fec_fin);
            $registros = $this->contratos_model->get_sobre_cuotas($where, $fec_ini, $fec_fin);
            $data['registros'] = $registros;
            $data['fec_cuota'] = $fec_sob;
            $data['fec_saldo'] = $fec_fin;
            $data['filename'] = 'det_ctas_cob';
            $data['reporte'] = $reporte;
            $tabla = $this->load->view('modulo_contratos/reportes/detalle_cuentas_cobrar', $data, true);            
            if ($flag) {
                echo json_encode(array('filas' => count($registros), 'tabla' => $tabla));
            } else {
                if ($reporte == 'pdf') {
                    $data['titulo'] = 'Cuotas por cobrar ' . formatear_fecha('m/Y', $fec_sob);
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Rpt_det_ctas_cob' . date('dmY');
                    $reporte = $header . $tabla;
                    $this->pdf->makePDF($reporte, 'P', 'Reporte_Ctas_Cob', 'Letter');
                } else {
                    echo $tabla;
                }                
            }            
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = "Reporte de Cuentas por Cobrar";
            cargarvista($data);
        }        
    }

    public function factura_masiva(){
        satelite_validar();
        if ($_POST) {
            $post_array         = $this->input->post();

            $fecha_inicio       = ($post_array['fecha_inicio'] != '' )? date('Y-m-d', strtotime($post_array['fecha_inicio'])) : null;
            $fecha_fin          = ($post_array['fecha_fin'] != '')? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;

            $fecha_inicio_corte = ($post_array['fecha_inicio_corte'] != '' )? date('Y-m-d', strtotime($post_array['fecha_inicio_corte'])): null;
            $fecha_fin_corte    = ($post_array['fecha_fin_corte'] != '')? date('Y-m-d', strtotime($post_array['fecha_fin_corte'])): null;

            $servicio       = ($post_array['servicio'] != '') ? $post_array['servicio'] : null;
            $planes         = ($post_array['plan'] != '') ? $post_array['plan'] : null;
            $tipo_factura   = ($post_array['tipo_factura'] != '') ? $post_array['tipo_factura'] : null;

            $where = null;

            if ( $servicio  != null ) {
                $where['art_id'] = $servicio ;
            }

            if ( $planes != null ) {
                $where['pln_id'] = $planes ;
            }

            if ( $tipo_factura != null ) {
                $where['fac_id_tif'] = $tipo_factura ;
            }   

            if ( $fecha_inicio != null || $fecha_fin != null) {
                $where['def_fecha_inicio >='] = $fecha_inicio;
                $where['def_fecha_fin <='] = $fecha_fin;
            }

            if ( $fecha_inicio_corte != null || $fecha_fin_corte != null) {
                $where['fac_fecha_fact >='] = $fecha_inicio_corte;
                $where['fac_fecha_fact <='] = $fecha_fin_corte;
            }

            $where['fac_generacion_masiva'] = 1;
            $where['fac_estado <>'] = 0;

            $data['facturas'] = $this->contratos_model->get_factura_masivas($where);
            $data['anulacion'] = false;
            $html = $this->load->view('modulo_contratos/reportes/consultar_facturas_masivas', $data, true);
            $data2['html'] = $html;
            echo json_encode($data2);
            die();  
        } else {
            $this->db->group_by("art_id");
            $this->db->join("pln_plan_promocion","pln_id_art = art_id");
            $data['servicio']           =  $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 1) );
            $data['tipo_factura']       =  $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1) );
            $data['titulo_personal']    = "Reporte de Facturas masivas";
            $this->_cargarvista($data);   
        }
    }


        /**
        * @author René Castaneda
        * @since 2019-03-14
        * @return Reporte Servicios Inactivos
        */
        function servicios_inactivos_clientes() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        $this->db->group_by("art_id");
        $this->db->join("sxc_servicioxcliente","sxc_id_art = art_id");
        $servicios = $this->gsatelite->get_dropdown('art_articulo', '{art_nombre}', '', array('art_estado' => '1'), null, '', 'art_id', true);
        $data["servicios"] = str_replace('<option value="0">Seleccione</option>', '', $servicios);
        $data['titulo_personal'] = "Reporte de Servicios - Inactivos";

        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2019-03-14
    * @return Filtrar Reporte Servicios Inactivos
    */
    public function filtrar_servicios_inactivos_clientes($flag = null) {
        satelite_validar();
        if ($_POST) {
            $post_array         = $this->input->post();
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte       = $this->input->post('tipo_reporte');
            $filtro_realizado = "";
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $proveedor = null;

            if ($flag != null) {
                $fecha_inicio   = ($post_array['fecha_desde'] != '' )? date('Y-m-d', strtotime($post_array['fecha_desde'])) : null;
                $fecha_fin      = ($post_array['fecha_hasta'] != '')? date('Y-m-d', strtotime($post_array['fecha_hasta'])) : null;
                $servicio       = ($post_array['slc_servicio'] != '')? $post_array['slc_servicio'] : null;
            } else {
                $fecha_inicio   = ($post_array['filtro_desde'] != '' )? date('Y-m-d', strtotime($post_array['filtro_desde'])) : null;
                $fecha_fin      = ($post_array['filtro_hasta'] != '')? date('Y-m-d', strtotime($post_array['filtro_hasta'])) : null;
                $servicio       = ($post_array['filtro_servicio'] != '')? $post_array['filtro_servicio'] : null;
            }

            /*
             * Se aplican los filtros
             */
            $where['sxc_estado'] = 0; //inactivos

            if ( $fecha_inicio != null) {
                $where['DATE(sxc_fecha_inactivo) >='] = $fecha_inicio;
                $filtro_realizado .= formatear_fecha('d-m-Y', $fecha_inicio);  
            }
            if ($fecha_fin != null) {
                $where['DATE(sxc_fecha_inactivo) <='] = $fecha_fin;
                $filtro_realizado .= (trim($filtro_realizado) !="")? " a " . formatear_fecha('d-m-Y', $fecha_fin): "Hasta: " . formatear_fecha('d-m-Y', $fecha_fin); 
            }

            if ( $servicio != null) {
                $where['sxc_id_art'] = $servicio;
                $registro_art = $this->gsatelite->get_tabla('art_articulo',array('art_id' => $servicio));
                $filtro_realizado .= (trim($filtro_realizado) !="")? "<br /> (" . $registro_art[0]['art_nombre'].")":"(" . $registro_art[0]['art_nombre'].")"; 
            }

            $data['reporte'] = $this->contratos_model->get_servicios_inactivos($where);
            //print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_servicios_inactivos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $filtro_realizado = (trim($filtro_realizado) != "")? "<br />".$filtro_realizado:"";
            $data["filtro_realizado"] = $filtro_realizado;

            $html = $this->load->view('modulo_contratos/reportes/filtrar_servicios_inactivos_clientes', $data, true);
            //echo $html; die();
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Servicios Inactivos'.$filtro_realizado;

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Contratos_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    //$this->pdf->makePdf($reporte, 'L', 'Reporte_Contratos', 'Letter');
                    $this->pdf->makePDF($reporte, 'L', 'Reporte_Contratos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Reporte de Servicios Inactivos';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

}
