<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('contratos_model');
        $this->load->model('cotizaciones_model');
        $this->load->model('facturacion_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Módulo de Contratos';
            $this->_cargarvista(null, $data);
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }


    /**
        *@author: Francisco Orozco
        *Fecha: 24/10/2017 
        *Descripción: verifica las fechas de los planes y promociones, si es promocion debera devolver la fecha inicio y fin del mismo como sugerido.
    */
    function servicio_cliente() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/procesos/servicio_cliente');
        
        if ($_POST) {
            $cliente = $this->input->post('cliente');
            $documento = $this->input->post('documento');
            $servicio = $this->input->post('servicio');
           
            $where = null;
            $like = null;

            if ( $cliente != "") {
                $like = $cliente;
            }

            if ( $documento != "") {
                $where['dcc_valor'] = $documento;
            }
            
            if ( $servicio != "") {
                $where['sxc_id_art'] = $servicio;
            }            
           
            $data['clientes'] = $this->contratos_model->get_clientes_servicios($where,$like);
    
            $html = $this->load->view('modulo_contratos/procesos/consultar_clientes', $data, true);
            echo $html;
            die();
        } else {
            $data['servicios'] = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 1) );
            $data['titulo_personal'] = "Servicios por clientes";
            $this->_cargarvista($data);
        }  
    }
   

    /*
     * @author: Mario Marquez
     * $cli_busqueda: Parametro de busqueda, desde otra funcion
     * Si no se llena sera un Json
     */

    public function get_clientes_servicio($cli_busqueda = null) {

        $cliente = ($cli_busqueda != null) ? $cli_busqueda : $this->input->post('cliente');

        $resultado = null;

        if ($cliente != null) {

            $where = array(
                'sxc_id IS NULL' => null
            );

            $like = array("CONCAT(cli_nombre, ' ', cli_apellido)" => $cliente);

            $resultado = $this->contratos_model->get_cliente_servicio($where, $like);
        }

        if ($cli_busqueda != null) {
            return $resultado;
        }

        echo json_encode($resultado);
    }

    function servicioxcliente($cli_id = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/procesos/servicio_cliente');

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'sxc_id_art',
            'sxc_id_pcn',   
            'sxc_fecha_contrato',
            'sxc_estado'
        );

        //Alias para las columnas
        $alias = array(
            'sxc_id_art' => 'Servicio',
            'sxc_fecha_contrato' => 'Fecha de contratación',
            'sxc_id_pcn' => 'Periodo de contrato',
            'sxc_estado' => 'Estado'
        );

        $edit = array(
            'sxc_id_cli',
            'sxc_id_art',
            'sxc_fecha_contrato',
            'sxc_id_pcn',
           // 'sxc_estado',
            'sxc_usu_modificacion',
            'sxc_fecha_modificacion');
        $add = array(
            'sxc_id_cli',
            'sxc_id_art',
            'sxc_fecha_contrato',
            'sxc_id_pcn',
            'sxc_estado',
            'sxc_usu_creacion',
            'sxc_fecha_creacion',
            'sxc_fecha_modificacion',
            'sxc_usu_modificacion'
        );

        $required = array(
            'sxc_id_cli',
            'sxc_id_art',
            'sxc_fecha_contrato',
            'sxc_id_pcn',
            'sxc_estado',
            'sxc_usu_creacion',
            'sxc_fecha_creacion',
            'sxc_fecha_modificacion',
            'sxc_usu_modificacion'
        );

        $crud->set_table('sxc_servicioxcliente')
                ->set_subject('Servicio por Cliente')
                ->where('sxc_id_cli', $cli_id)
                ->add_fields($add)
                ->edit_fields($edit)
                ->columns($columns)
                ->required_fields($required)
                ->display_as($alias)
                ->unset_export()
                ->unset_print()
                ->set_relation('sxc_id_art', 'art_articulo', 'art_nombre', array('art_estado' => 1, 'art_tipo' => 1))
                ->set_relation('sxc_id_pcn', 'pcn_periodo_contrato', 'pcn_nombre', array('pcn_estado' => 1))
                ->set_relation('sxc_id_cli', 'cli_cliente', '{cli_nombre} {cli_apellido}')
                ->field_type('sxc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('sxc_id_cli', 'hidden', $cli_id)
                ->field_type('sxc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('sxc_id_art', 'Servicio', 'required|callback_validar_servicio_cliente')
        ;

        $crud->callback_column('sxc_fecha_contrato', function($value,$row) {
            return formatear_fecha('d-m-Y', $value);
        });

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('sxc_estado', 'hidden', 1)
                    ->field_type('sxc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('sxc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
           $crud->field_type('sxc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        if (!$permisos['permite_agregar']) {
           $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $crud->add_action('Planes y promociones', 'icomoon-icon-calendar-2', 'modulo_contratos/procesos/planes_cliente');
        $crud->add_action('Cargos adicionales', 'cut-icon-eject', 'modulo_contratos/procesos/cargos_adicionales');
        $crud->add_action('Inactivar', 'icomoon-icon-cancel-3', 'modulo_contratos/procesos/inactivar_servicioxcliente');

        $cliente_data = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cli_id));
        $data['cliente'] = $cli_id;
        $cliente = ($cliente_data[0]['cli_personeria'] == 1)?$cliente_data[0]['cli_nombre'] . " " . $cliente_data[0]['cli_apellido']:$cliente_data[0]['cli_apellido'];


        $data['titulo_personal'] = "Servicio por cliente - " . $cliente_data[0]['cli_codigo'] . ' - ' . $cliente;

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function validar_servicio_cliente() {

        $servicio = $this->input->post('sxc_id_art');
        $cliente = $this->input->post('sxc_id_cli');

        if (end(explode('/', uri_string())) == 'add') {
            $where = array('sxc_id_art' => $servicio, 'sxc_id_cli' => $cliente, 'sxc_estado' => 1);

            $count = $this->gsatelite->count('sxc_servicioxcliente', $where);
        } else {

            $sxc_id = end(explode("/", uri_string()));
            $where = array('sxc_id_art' => $servicio, 'sxc_id_cli' => $cliente, 'sxc_estado' => 1, 'sxc_id <>' => $sxc_id);

            $count = $this->gsatelite->count('sxc_servicioxcliente', $where);
        }

        if ($count > 0) {
            $this->form_validation->set_message('validar_servicio_cliente', "El servicio ya ha sido habilitado.");
            return false;
        }

        return true;
    }

    function planes_cliente($sxc_id = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/procesos/servicio_cliente');

        $crud = new grocery_CRUD();

        //Columnas a mostrar en READ
        $columns = array(
            'pxl_id_pln',
            'pxl_costo',
            'pxl_fecha_inicio',
            'pxl_fecha_fin',
            'pxl_estado'
        );

        //Alias para las columnas
        $alias = array(
            'pxl_id_pln'        => 'Plan/Promoción',
            'pxl_fecha_inicio'  => 'Fecha de inicio',
            'pxl_fecha_fin'     => 'Fecha de fin',
            'pxl_estado'        => 'Estado',
            'pxl_costo'         => 'Costo'
        );

        $edit = array(
            'pxl_id_pln',
            'pxl_id_sxc',
            'pxl_fecha_inicio',
            'pxl_fecha_fin',
            'pxl_estado',
            'pxl_usu_modificacion',
            'pxl_fecha_modificacion');
        $add = array(
            'pxl_costo',
            'pxl_id_pln',
            'pxl_id_sxc',
            'pxl_fecha_inicio',
            'pxl_fecha_fin',
            'pxl_estado',
            'pxl_usu_creacion',
            'pxl_fecha_creacion',
            'pxl_fecha_modificacion',
            'pxl_usu_modificacion'
        );

        $required = array(
            'pxl_id_pln',
            'pxl_id_sxc',
            'pxl_fecha_inicio',
           // 'pxl_fecha_fin',
            'pxl_estado',
            'pxl_usu_creacion',
            'pxl_fecha_creacion',
            'pxl_fecha_modificacion',
            'pxl_usu_modificacion'
        );

        $crud->set_table('pxl_plan_promoxcliente')
                ->set_subject('Plan/Promoción por cliente')
                ->where('pxl_id_sxc', $sxc_id)
                ->add_fields($add)
                ->edit_fields($edit)
                ->columns($columns)
                ->required_fields($required)
                ->display_as($alias)
                ->unset_export()
                ->unset_print()
                ->set_relation('pxl_id_pln', 'pln_plan_promocion', 'pln_nombre', array('pln_estado' => 1))
                ->field_type('pxl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pxl_id_sxc', 'hidden', $sxc_id)
                ->field_type('pxl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
               // ->set_rules('pxl_id_pln', 'Plan/Promoción', 'required|callback_validar_plan_servicio')
                ->callback_field('pxl_id_pln', array($this, 'callback_planes_promociones'))
        ;

        $crud->callback_column('pxl_fecha_inicio', function($value,$row) {
            return formatear_fecha('d-m-Y', $value);
        });

        $crud->callback_column('pxl_fecha_fin', function($value,$row) {
            return formatear_fecha('d-m-Y', $value);
        });

        $crud->set_rules('pxl_fecha_inicio', 'Fecha de inicio', 'required|callback_verificar_fechas_plan_grocery');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pxl_estado', 'hidden', 1)
                    ->field_type('pxl_costo', 'hidden', 1)
                    ->field_type('pxl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pxl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('pxl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }


        $crud->callback_after_insert(function($post_array,$key){
            // DESPUES DE INSERTAR DEBEMOS OBTENER EL COSTO DEL PLAN PARA AGREGARSELO AL CLIENTE
            // EN LA TABLA pxl_plan_promoxcliente
            $pln_id             = $this->input->post('pxl_id_pln');
            
            $pln_plan_promocion = $this->gsatelite->get_tabla('pln_plan_promocion',array('pln_id' => $pln_id));
            
            $pxl_plan_promoxcliente = array(
                'pxl_costo' => $pln_plan_promocion[0]['pln_costo']
            );

            $this->gsatelite->actualizar_array('pxl_plan_promoxcliente', $pxl_plan_promoxcliente, array('pxl_id' => $key));
            return TRUE;
        });

        $crud->callback_after_update(function($post_array, $primary_key) {
            
            // DESPUES DE ACTUALIZAR DEBEMOS OBTENER EL COSTO DEL PLAN PARA AGREGARSELO AL CLIENTE
            // EN LA TABLA pxl_plan_promoxcliente
            $pln_id             = $this->input->post('pxl_id_pln');

            $pln_plan_promocion = $this->gsatelite->get_tabla('pln_plan_promocion',array('pln_id' => $pln_id));

            $pxl_plan_promoxcliente = array(
                'pxl_costo' => $pln_plan_promocion[0]['pln_costo']
            );

            $this->gsatelite->actualizar_array('pxl_plan_promoxcliente', $pxl_plan_promoxcliente, array('pxl_id' => $primary_key));
            return TRUE;
        });

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $data['servicio_data'] = $this->contratos_model->get_cliente_servicio(array('sxc_id' => $sxc_id));

        $data['titulo_personal'] = "Asignación de Planes / Promociones por cliente";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function callback_planes_promociones($value = '', $primary_key = null) {
        $urlSegment = (explode("/", uri_string()));
        $sxc_id = null;
        /*
         * Se obtiene el id del Servicio por cliente.
         */
        if (end(explode('/', uri_string())) == 'add') {
            $sxc_id = $urlSegment[count($urlSegment) - 2];
        } else {
            $sxc_id = $urlSegment[count($urlSegment) - 3];
        }

        $src_id = $this->gsatelite->get_campo('sxc_servicioxcliente', 'sxc_id_art', array('sxc_id' => $sxc_id));
        $opciones = '<select id="field-pxl_id_pln" name="pxl_id_pln" class="nostyle chosen-select" data-placeholder=" Plan/Promoción" style="width: 100%; display: none;">';
        $opciones .= '<option></option>';
        $planes = $this->gsatelite->get_tabla('pln_plan_promocion', array('pln_estado' => 1, 'pln_id_art' => $src_id));


        if (count($planes) > 0) {
            foreach ($planes as $pln) {

                $selected = ($pln['pln_id'] == $value) ? "selected=selected" : "";
                $nombre_plan = ($pln['pln_tipo'] == 1) ? "Plan - " : " Promoción - ";
                $costo = ($pln['pln_costo'] == "")? "0.00": number_format($pln['pln_costo'],2);
                $nombre_plan .= $pln['pln_nombre'];

                $opciones .= '<option ' . $selected . ' value="' . $pln['pln_id'] . '">' . $nombre_plan .": $" . $costo. '</option>';
            }
        }

        $opciones .= "</select>";

        return $opciones;
    }

    function validar_plan_servicio() {

        $plan = $this->input->post('pxl_id_pln');
        $servicio_cliente = $this->input->post('pxl_id_sxc');

        if (end(explode('/', uri_string())) == 'add') {
            $where = array('pxl_id_pln' => $plan, 'pxl_id_sxc' => $servicio_cliente, 'pxl_estado' => 1);

            $count = $this->gsatelite->count('pxl_plan_promoxcliente', $where);
        } else {

            $pxl_id = end(explode("/", uri_string()));
            $where = array('pxl_id_pln' => $plan, 'pxl_id_sxc' => $servicio_cliente, 'pxl_estado' => 1, 'pxl_id <>' => $pxl_id);

            $count = $this->gsatelite->count('pxl_plan_promoxcliente', $where);
        }

        if ($count > 0) {
            $this->form_validation->set_message('validar_plan_servicio', "El Plan/Promoción ya ha sido ingresado.");
            return false;
        }

        return true;
    }

    function cargos_adicionales($sxc_id = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/procesos/servicio_cliente');

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'caf_id_tcs',
            'caf_fecha',
            'caf_valor',
            'caf_numero_cuota',
            'caf_monto_cuota',
            'caf_estado'
        );

        //Alias para las columnas
        $alias = array(
            'caf_id_tcs'        => 'Cargo',
            'caf_fecha'         => 'Fecha',
            'caf_valor'         => 'Costo',
            'caf_numero_cuota' => 'Cuotas',
            'caf_monto_cuota'   => 'Monto por cuota',
            'caf_estado'        => 'Estado'
        );

        $edit = array(
            'caf_id_tcs',
            'caf_id_sxc',
            'caf_fecha',
            'caf_monto_cuota',
            'caf_valor',
            'caf_numero_cuota',
            'caf_estado',
            'caf_usu_modificacion',
            'caf_fecha_modificacion'
        );

        $add = array(
            'caf_id_tcs',
            'caf_id_sxc',
            'caf_fecha',
            'caf_monto_cuota',
            'caf_valor',
            'caf_numero_cuota',
            'caf_nombre',
            'caf_impuesto',
            'caf_subtotal',
            'caf_sistema',
            'caf_estado',
            'caf_usu_creacion',
            'caf_fecha_creacion',
            'caf_fecha_modificacion',
            'caf_usu_modificacion'
        );

        $required = array(
            'caf_id_tcs',
            'caf_id_sxc',
            'caf_fecha',
            'caf_valor',
            'caf_numero_cuota',
            'caf_monto_cuota',
            'caf_estado',
            'caf_usu_creacion',
            'caf_fecha_creacion',
            'caf_fecha_modificacion',
            'caf_usu_modificacion'
        );

        $crud->set_table('caf_cargo_facturacion')
                ->set_subject('Cargos Adicionales')
                ->where('caf_id_sxc', $sxc_id)
                ->add_fields($add)
                ->edit_fields($edit)
                ->columns($columns)
                ->required_fields($required)
                ->display_as($alias)
                ->unset_export()
                ->unset_print()
                ->set_relation('caf_id_tcs', 'tcs_tipo_cargo_servicio', 'tcs_nombre', array('tcs_estado' => 1))
                ->field_type('caf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('caf_id_sxc', 'hidden', $sxc_id)
                ->field_type('caf_nombre', 'hidden', '')
                ->field_type('caf_impuesto', 'hidden', 0)
                ->field_type('caf_subtotal', 'hidden', 0)
                ->field_type('caf_sistema', 'hidden', 0)
                ->field_type('caf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('caf_id_tcs', 'Cargo', 'required|callback_validar_cargo_adicional')
        //->callback_field('pxl_id_pln', array($this, 'callback_planes_promociones'))
        ;

        $crud->callback_column('caf_fecha', function($value,$row) {
            return formatear_fecha('d-m-Y', $value);
        });

        $crud->callback_column('caf_valor', array($this, '_column_decimales'));
        $crud->callback_column('caf_monto_cuota', array($this, '_column_decimales'));
        
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('caf_estado', 'hidden', 1)
                    ->field_type('caf_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('caf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('caf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $data['servicio_data'] = $this->contratos_model->get_cliente_servicio(array('sxc_id' => $sxc_id));

        $data['titulo_personal'] = "Cargos Adicionales";

        $output = $crud->render();

        $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
        $data['decimales']  = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;
        $this->_cargarvista($data, $output);
    }

    function get_cargo_costo() {
        $cargo = $this->input->post('id_cargo');

        $costo = (float) $this->gsatelite->get_campo('tcs_tipo_cargo_servicio', 'tcs_valor', array('tcs_id' => $cargo));
        echo json_encode($costo);
    }

    function validar_cargo_adicional() {

        $cargo = $this->input->post('caf_id_tcs');
        $servicio_cliente = $this->input->post('caf_id_sxc');

        if (end(explode('/', uri_string())) == 'add') {
            $where = array('caf_id_tcs' => $cargo, 'caf_id_sxc' => $servicio_cliente, 'caf_estado' => 1);

            $count = $this->gsatelite->count('caf_cargo_facturacion', $where);
        } else {

            $caf_id = end(explode("/", uri_string()));
            $where = array('caf_id_tcs' => $cargo, 'caf_id_sxc' => $servicio_cliente, 'caf_estado' => 1, 'caf_id <>' => $caf_id);

            $count = $this->gsatelite->count('caf_cargo_facturacion', $where);
        }

        if ($count > 0) {
            $this->form_validation->set_message('validar_cargo_adicional', "El Cargo ya ha sido ingresado.");
            return false;
        }

        return true;
    }

    function procesar_facturas() {
        satelite_validar();
        
        //verificar si usuario posee rol de caja y si existe el parametro
        $parametrizacion_rol_cajero = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
        
        if ( $parametrizacion_rol_cajero == "" || $parametrizacion_rol_cajero == null ) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proceso de facturas", 'texto_alerta' => "Parametro requerido");
                $this->session->set_flashdata($alerta);
                redirect('/modulo_contratos/index');
        } else {
            $rol = $this->gsatelite->get_campo('uxr_usuarioxrol','uxr_id',array('uxr_id_usu' => $this->tank_auth->get_user_id(), 'uxr_id_rol' =>  $parametrizacion_rol_cajero ));
                    
            if ( $rol == "" || $rol == NULL) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proceso de facturas", 'texto_alerta' => "No posee el rol adecuado para este proceso");
                $this->session->set_flashdata($alerta);
                redirect('/modulo_contratos/index');
            }

            //validar si posee correlativos del tipo masivo
            $validacion = array(
                'uxc_id_usu' => $this->tank_auth->get_user_id(), 
                'cof_masivo' => 1,
                'uxc_estado' => 1,
                'cof_estado'=> 1
            );
            $this->db->join('cxj_correlativoxcaja','cxj_id_cof = cof_id');
            $this->db->join('caj_caja','caj_id = cxj_id_caj');
            $this->db->join('uxc_usuarioxcaja','uxc_id_caj = caj_id');
            $correlativos_masivos = $this->gsatelite->get_tabla('cof_correlativo_factura',$validacion);

            if( count($correlativos_masivos) == 0){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proceso de facturas", 'texto_alerta' => "No posee correlativos del tipo masivo.");
                $this->session->set_flashdata($alerta);
                //redirect('/modulo_contratos/index');
            }   
    
        }

        if ($_POST) {
            $post_array = $this->input->post();
            $fecha_inicio       = date('Y-m-d', strtotime($post_array['fecha_inicio']));
            $fecha_fin          = date('Y-m-d', strtotime($post_array['fecha_fin']));
            $fecha_factura      = date('Y-m-d', strtotime($post_array['fecha_factura']));
            $regla_cuotas       = ($post_array['regla_cuotas'] != '') ? $post_array['regla_cuotas'] : 0;

            $servicio           = ($post_array['servicio'] != '') ? $post_array['servicio'] : null;
            $planes             = ($post_array['plan'] != '') ? $post_array['plan'] : null;
            $tipo_factura       = ($post_array['tipo_factura'] != '') ? $post_array['tipo_factura'] : null;
            $nombre_tipo_factura= ($post_array['nombreTipoFactura'] != '') ? $post_array['nombreTipoFactura'] : null;
            $slc_cliente        = ($post_array['slc_cliente'] != '') ? $post_array['slc_cliente'] : null;
            $periodo            = ($post_array['periodo'] != '') ? $post_array['periodo'] : null;

            // verificar si el periodo fue ya impreso.

            $where_periodo = null;

            $where_periodo["fac_nombre_factura"]    = $periodo;
            $where_periodo["fac_generacion_masiva"] = 1;
            $where_periodo["fac_id_tif"]            = $tipo_factura;
            $where_periodo["def_id_art"]            = $servicio;
            $where_periodo["fac_estado !="]         = 0;

            if ($slc_cliente != null){
                $where_periodo["fac_id_cli"] = $slc_cliente;                  
            } else {
                $where_periodo["fac_estado != 0 and fac_estado != 1"] = null;
            }

            $this->db->join("def_detalle_fact","def_id_fac = fac_id");
            $verificar_periodo  = $this->gsatelite->count("fac_factura", $where_periodo );
          
            if ($verificar_periodo > 0 ){
                $data['resultado']  = 0;
                $data['mensaje'] = "Período ya fue facturado";
                echo json_encode($data);
                die();
            }


            //validar si posee correlativos del tipo masivo
            $validacion = array(
                'uxc_id_usu' => $this->tank_auth->get_user_id(), 
                'cof_masivo' => 1,
                'uxc_estado' => 1,
                'cof_estado' => 1,
                'sef_id_tif' => $tipo_factura
            );
            $this->db->join('sef_serie_factura','sef_id = cof_id_sef');
            $this->db->join('cxj_correlativoxcaja','cxj_id_cof = cof_id');
            $this->db->join('caj_caja','caj_id = cxj_id_caj');
            $this->db->join('uxc_usuarioxcaja','uxc_id_caj = caj_id');
            $correlativos_masivos_tif = $this->gsatelite->get_tabla('cof_correlativo_factura',$validacion);

            if( count($correlativos_masivos_tif) == 0) {
                $tipo_nombre = $this->gsatelite->get_campo('tif_tipo_factura','tif_nombre',array('tif_id'=> $tipo_factura));
                $data['resultado']  = 0;
                $data['mensaje'] = "No se encontraron correlativos masivos para el tipo de factura ".$tipo_nombre ;
                echo json_encode($data);
                die();
            }   

            //verificar si posse correlativos masivos
            $where_correlativos = null;

            $where_correlativos = array(
                'uxc_id_usu'    => $this->tank_auth->get_user_id(),
                'cxj_estado'    => 1,
                'tif_id'        => $tipo_factura 
            );

            $correlitvos = $this->contratos_model->get_existencia_correlativos($where_correlativos);
            //+1 es para tomar el actual
            $total_correlativos_usados = (($correlitvos[0]['cxj_fin'] - $correlitvos[0]['cxj_inicio']) + 1) - $correlitvos[0]['cantidad'];
           
           //obtener planes de los clientes
    
            $where = array(
                'sxc_estado'    => 1,
                'cli_estado'    => 1,
                'pxl_estado'    => 1
            );

            if ($servicio != null) {
                $where['pln_id_art'] = $servicio;
            }

            if ($planes != null) {
                $where['pxl_id_pln'] = $planes;
            }

            if ($slc_cliente != null){
                $where["cli_id"]             = $slc_cliente;                   
            }

            $parametro_recibo_cuotas    = $this->gsatelite->get_parametro("SYS_RECIBO_CUOTAS","");
            $where_extra                = null; 
            $where_extra2               = null;   
            
            if ( $parametro_recibo_cuotas == $tipo_factura ){  
                $where_extra = " cli_id IN (
                    SELECT
                        fac_id_cli
                    FROM
                        (
                            SELECT
                                fac_id_cli,
                                COUNT(DISTINCT fac_id) n
                            FROM
                                fac_factura
                            JOIN cli_cliente sub_cliente ON sub_cliente.cli_id = fac_id_cli
                            WHERE
                                fac_estado = 1
                            AND fac_generacion_masiva = 1
                            GROUP BY
                                fac_id_cli
                            HAVING
                                n > 1
                        ) f
                )";

                $where_extra2  = " cli_id NOT IN (
                    SELECT
                         fac_id_cli
                     FROM
                         fac_factura AS f3
                     WHERE
                         f3.fac_estado = 1
                         AND f3.fac_generacion_masiva = 1
                         AND f3.fac_id_tif = '".$tipo_factura."'
                         AND f3.fac_nombre_factura = '".$periodo."'
                     GROUP BY fac_id_cli
                 )";

            } else if ( $regla_cuotas == 0){

                $where['cli_id_tif'] = $tipo_factura;
                $where_extra   = null;
                $where_extra2  = " cli_id NOT IN (
                   SELECT
		                fac_id_cli
	                FROM
		                fac_factura AS f3
	                WHERE
		                f3.fac_estado = 1
	                    AND f3.fac_generacion_masiva = 1
	                    AND f3.fac_id_tif = 1
                        AND f3.fac_nombre_factura = '".$periodo."'
                    GROUP BY fac_id_cli
                )";
            } else {
        
                $where['cli_id_tif'] = $tipo_factura;
                
                $where_extra = " cli_id NOT IN (
                    SELECT
                        fac_id_cli
                    FROM
                        (
                            SELECT
                                fac_id_cli,
                                COUNT(DISTINCT fac_id) n
                            FROM
                                fac_factura
                            JOIN cli_cliente sub_cliente ON sub_cliente.cli_id = fac_id_cli
                            WHERE
                                fac_estado = 1
                            AND fac_generacion_masiva = 1
                            GROUP BY
                                fac_id_cli
                            HAVING
                                n >= 2
                        ) f
                )";


                $where_extra2  = " cli_id NOT IN (
                   SELECT
		                fac_id_cli
	                FROM
		                fac_factura AS f3
	                WHERE
		                f3.fac_estado = 1
	                    AND f3.fac_generacion_masiva = 1
	                    AND f3.fac_id_tif = 1
                        AND f3.fac_nombre_factura = '".$periodo."'
                    GROUP BY fac_id_cli
                )";
            }

            //Se obtienen los planes por servicios clientes que son los cargos fijos
            $clientes = $this->contratos_model->get_cliente_facturar($where, $fecha_inicio, $fecha_fin, $where_extra, $where_extra2);  
            //var_dump($this->db->last_query());die();
            //verificar si los correlativos son suficientes para la cantidad de facturas masivas
            if ($total_correlativos_usados >= count($clientes)) {
                if (count($clientes) > 0) {        
                    $data['clientes']           = $clientes;
                    $data['rango_fechas']       = $periodo;

                    $fecha_inicio               = date('Y-m-d', strtotime($post_array['fecha_inicio']));
                    $fecha_fin                  = date('Y-m-d', strtotime($post_array['fecha_fin']));

                    $data['fecha_inicio']       = date('Y-m-d', strtotime($post_array['fecha_inicio']));
                    $data['fecha_fin']          = date('Y-m-d', strtotime($post_array['fecha_fin']));
                    $data['fecha_factura']      = date('Y-m-d', strtotime($post_array['fecha_factura']));
                    $data['tipo_factura']       = $tipo_factura;
                    $data['nombre_tipo_factura']= $this->gsatelite->get_campo('tif_tipo_factura','tif_abreviacion', array("tif_id" => $tipo_factura) );
                    $data['usuario_caja']       = $this->gsatelite->get_campo('uxc_usuarioxcaja','uxc_id',array('uxc_id_usu' => $this->tank_auth->get_user_id(),'uxc_estado' => 1 ));
                    $data['servicio_filtro']    = $servicio;
                    $html = $this->load->view('modulo_contratos/procesos/consultar_procesar_facturas', $data, true);
                    $data['html'] = $html;
                    $data['resultado']  = 1;
                    echo json_encode($data);
                    die();  
                } else {
                    // No hay correlativos
                    $data['resultado']  = 0;
                    $data['mensaje'] = "No se encontraron resultados";
                    echo json_encode($data);
                    die();
                }
            } else {
                // No hay correlativos
                $data['resultado']  = 0;
                $data['mensaje'] = "Los correlativos no son suficientes";
                echo json_encode($data);
                die();
            }

        }
        $this->db->group_by("art_id");
        $this->db->join("pln_plan_promocion","pln_id_art = art_id");
        $data['servicio']       =  $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 1) );
        $data['tipo_factura']   = $this->gsatelite->get_dropdown('tif_tipo_factura', 'tif_nombre', '', array('tif_estado' => 1), null, null, null, true);
        $data['titulo_personal']= "Procesamiento de Facturas";
        $this->_cargarvista($data);
    }

    public function get_planes_servicio($servicio = null, $flag = null) {
        satelite_validar();
        $idServicio = ($this->input->post('servicio') != '') ? $this->input->post('servicio') : $servicio;

        $this->db->join('art_articulo','art_id = pln_id_art');
        $planes = $this->gsatelite->get_tabla('pln_plan_promocion', array('pln_id_art' => $idServicio));

        $opciones = "<option></option>";

        if (count($planes) > 0) {
            foreach ($planes as $pln) {

                $nombre_plan = ($pln['pln_tipo'] == 1) ? "Plan" : "Promoción";

                $nombre_plan .= " - " . $pln['pln_nombre'];

                $codigo = $pln['art_codigo'];

                $opciones .= "<option value='" . $pln['pln_id'] . "'>" . $codigo . " - " . $nombre_plan . "</option>";
            }
        }

        if ($flag != null) {
            return $opciones;
        }

        echo $opciones;
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 24/10/2017 
        *Descripción: verifica si los planes/promociónes por medio de ajax.
    */
    public function verificar_fechas_plan() {
        satelite_validar();
        $fecha_inicio       = formatear_fecha('Y-m-d',$this->input->post('fecha_inicio'));
        $fecha_fin          = formatear_fecha('Y-m-d',$this->input->post('fecha_fin'));
        $pln_id             = $this->input->post('plan');
        $servicoxcliente    = $this->input->post('servicoxcliente');
        $plx_id             = $this->input->post('promoxcliente');

        //verifica si las fechas estan dentro del plan/promoción.
        $pln_plan_promocion = array(
            'pln_id'        => $pln_id,
            'pln_estado'    => 1,
            "pln_desde <='".$fecha_inicio."' AND pln_desde <='".$fecha_fin."'" => null  ,
            "(pln_hasta >='".$fecha_inicio."' or pln_hasta IS NULL)" => null,
            "(pln_hasta >= '".$fecha_fin."' or pln_hasta IS NULL)" => null
        );

        $rango_plan = $this->gsatelite->get_tabla( 'pln_plan_promocion', $pln_plan_promocion );

        if ( count($rango_plan) > 0 ) {
            
            //verificar planes duplicados planes/promociones por  cliente 
            $where = array(
                'pxl_id_sxc'    => $servicoxcliente,
                'pxl_estado'    => 1,
                'pxl_id_pln'    => $pln_id,
                'pxl_id <>'     => $plx_id 
            );
              
            $where2 = "(('".$fecha_inicio."' BETWEEN pxl_fecha_inicio AND pxl_fecha_fin) 
                            OR ('".$fecha_fin."' BETWEEN pxl_fecha_inicio AND pxl_fecha_fin)
                            OR ( pxl_fecha_inicio BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."')
                            OR ( pxl_fecha_fin BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."'))";

            $planes_promocion_cliente  = $this->contratos_model->verificar_plan_duplicado($where,$where2);

            if ( count($planes_promocion_cliente) > 0 ) {
                $result = array(
                    'error'     => true,
                    'titulo'    => 'Planes / Promociones',
                    'mensaje'   => 'El plan ya fue agregado anteriormente con el mismo rango de fechas, favor verifique las fechas.'
                );
            } else {
                $result = array(
                    'error'     =>  false,
                    'titulo'    => '',
                    'mensaje'   => ''
                );
            }
        } else {
            $pln_plan_promocion = array(
                'pln_id'        => $pln_id,
                'pln_estado'    => 1
            );

            $dentro_plan = $this->gsatelite->get_tabla( 'pln_plan_promocion', $pln_plan_promocion );
            
            $ini = formatear_fecha('d-m-Y',$dentro_plan[0]['pln_desde']);
            $fin = formatear_fecha('d-m-Y',$dentro_plan[0]['pln_hasta']);

            $result = array(
                'error'     => true,
                'titulo'    => 'Planes / Promociones',
                'mensaje'   => 'El rango de las fechas no coincide con el rango del plan (desde '.$ini.' hasta '.$fin.'), favor verifique las fechas.'
            );
        }
        echo json_encode($result);
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 24/10/2017 
        *Descripción: verifica si los planes/promociónes para grocery.
    */
    public function verificar_fechas_plan_grocery($post_array) {
        satelite_validar();
        $pxl_id =   0;
        if ( is_numeric( end(explode('/', uri_string()))) ){
            $pxl_id = end(explode('/', uri_string())) ;
        }

        $fecha_inicio       = formatear_fecha('Y-m-d', $this->input->post('pxl_fecha_inicio') );
        $fecha_fin          = ( $this->input->post('pxl_fecha_fin') !="" )? formatear_fecha('Y-m-d', $this->input->post('pxl_fecha_fin')) : null;
        $pln_id             = $this->input->post('pxl_id_pln');
        $servicoxcliente    = $this->input->post('pxl_id_sxc'); 
        

        if ($fecha_fin == null) {
            //verificar  si ya posee plan ilimitado
            $plan_ilimitado = false;
            $this->db->join('pln_plan_promocion','pln_id = pxl_id_pln');
            $pxl_plan_promoxcliente = $this->gsatelite->get_tabla('pxl_plan_promoxcliente',array('pxl_id_sxc' => $servicoxcliente, 'pln_id' => $pln_id) );

            if ( count($pxl_plan_promoxcliente) > 0 ) {
                foreach ($pxl_plan_promoxcliente as $key => $planxcliente) {
                    if ( $planxcliente["pxl_fecha_fin"] == null && $planxcliente["pln_tipo"] == 1 ) {
                        $plan_ilimitado = true;
                    }
                }
            }

            //evalua si posse plan ilimitado
            if ( $plan_ilimitado == true ) {
                $this->form_validation->set_message('verificar_fechas_plan_grocery', 'Ya posee un plan ilimitado.');
                return false;
            } else {

                //verifica si las fechas estan dentro del plan/promoción.                
                $pln_plan_promocion = array(
                        'pln_id'        => $pln_id,
                        'pln_estado'    => 1,
                        "pln_desde <='".$fecha_inicio."'" => null  ,
                        "(pln_hasta >='".$fecha_inicio."' or pln_hasta IS NULL)" => null,
                );
                $rango_plan = $this->gsatelite->get_tabla( 'pln_plan_promocion', $pln_plan_promocion );

                if ( count($rango_plan) > 0 ) {
                    
                        //verificar planes duplicados planes/promociones por  cliente 
                        $where = array(
                            'pxl_id_sxc'        => $servicoxcliente,
                            'pxl_estado'        => 1,
                            'pxl_id_pln'        => $pln_id,
                            'pxl_id <>'         => $pxl_id,
                            'pxl_fecha_fin >='  => $fecha_inicio
                        );
                        $planes_promocion_cliente = $this->gsatelite->get_tabla('pxl_plan_promoxcliente',$where);

                        if ( count($planes_promocion_cliente) > 0 ) {
                            $this->form_validation->set_message('verificar_fechas_plan_grocery', 'El plan ya fue agregado anteriormente con el mismo rango de fechas, favor verifique las fechas.');
                            return false;
                        } else {
                            //plan es aplicable
                            return true;
                        }
                    } else {        
                        $this->form_validation->set_message('verificar_fechas_plan_grocery', 'El rango de las fechas no coincide con el rango del plan');
                        return false;
                    }    
            }

        } else {

            //verifica si las fechas estan dentro del plan/promoción.
        
            $pln_plan_promocion = array(
                'pln_id'        => $pln_id,
                'pln_estado'    => 1,
                "pln_desde <='".$fecha_inicio."' AND pln_desde <='".$fecha_fin."'" => null  ,
                "(pln_hasta >='".$fecha_inicio."' or pln_hasta IS NULL)" => null,
                "(pln_hasta >= '".$fecha_fin."' or pln_hasta IS NULL)" => null
            );

            $rango_plan = $this->gsatelite->get_tabla( 'pln_plan_promocion', $pln_plan_promocion );
   
            if ( count($rango_plan) > 0 ) {
            
                //verificar planes duplicados planes/promociones por  cliente 
                $where = array(
                    'pxl_id_sxc'    => $servicoxcliente,
                    'pxl_estado'    => 1,
                    'pxl_id_pln'    => $pln_id,
                    'pxl_id <>'     => $pxl_id 
                );
              
                $where2 = "(('".$fecha_inicio."' BETWEEN pxl_fecha_inicio AND pxl_fecha_fin) 
                            OR ('".$fecha_fin."' BETWEEN pxl_fecha_inicio AND pxl_fecha_fin)
                            OR ( pxl_fecha_inicio BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."')
                            OR ( pxl_fecha_fin BETWEEN '".$fecha_inicio."' AND '".$fecha_fin."'))";

                $planes_promocion_cliente  = $this->contratos_model->verificar_plan_duplicado($where,$where2);

                if ( count($planes_promocion_cliente) > 0 ) {
                    $this->form_validation->set_message('verificar_fechas_plan_grocery', 'El plan ya fue agregado anteriormente con el mismo rango de fechas, favor verifique las fechas.');
                    return false;
                } else {
                    //plan es aplicable
                    return true;
                }
            } else {
                $pln_plan_promocion = array(
                    'pln_id'        => $pln_id,
                    'pln_estado'    => 1
                );

                $dentro_plan = $this->gsatelite->get_tabla( 'pln_plan_promocion', $pln_plan_promocion );
            
                $ini = formatear_fecha('d-m-Y',$dentro_plan[0]['pln_desde']);
                $fin = formatear_fecha('d-m-Y',$dentro_plan[0]['pln_hasta']);

                $this->form_validation->set_message('verificar_fechas_plan_grocery', 'El rango de las fechas no coincide con el rango del plan (desde '.$ini.' hasta '.$fin.'), favor verifique las fechas.');
                return false;
            }
        }
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 24/10/2017 
        *Descripción: verifica las fechas de los panes y promociones, si es promocion debera devolver la fecha inicio y fin del mismo como sugerido.
    */
    function obtener_fechas_plan_promocion() {
        satelite_validar();
        $pln_id             = $this->input->post('plan');
        $pln_plan_promocion = $this->gsatelite->get_tabla('pln_plan_promocion',array('pln_id' => $pln_id) );
        
        $result = array(
            'tipo'      => $pln_plan_promocion[0]['pln_tipo'],
            'desde'     => formatear_fecha('Y-m-d',$pln_plan_promocion[0]['pln_desde']),
            'hasta'     => formatear_fecha('Y-m-d',$pln_plan_promocion[0]['pln_hasta'])
        );

        echo json_encode($result);
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 13/11/2017 
        *Descripción: obtener los planes de los clientes
    */
    function get_serviciosxclientes($cliente = null, $fecha_inicial = null, $fecha_fin = null,$servicio){
        satelite_validar();
        $fecha_inicial = formatear_fecha('Y-m-d',$fecha_inicial);
        $fecha_fin = formatear_fecha('Y-m-d',$fecha_fin);
        $where = array(
            'sxc_id_cli'    => $cliente,
            'cva_defecto'   => 1,
            'sxc_id_art'    => $servicio,
            'pxl_estado'    => 1,
            'sxc_estado'    => 1
        );
        $planes = $this->contratos_model->get_serviciosxclientes($where,$fecha_inicial,$fecha_fin);
        return $planes;
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 20/11/2017 
        *Descripción: obtener los impuestos por cada cargo adicional
    */
    function get_impuestosxcargos($art_id_tia = null){
        satelite_validar();
        $this->db->join('imp_impuesto','imp_id = ixr_id_imp');
        $impuestos = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo',array('ixr_id_tia' => $art_id_tia) );
        return $impuestos;
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 22/11/2017 
        *Descripción: Crea la facturas masivamente y devuelve las facturas creadas en una tabla html.
    */
    function crear_facturas_masiva() {
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');  
        ini_set( 'max_input_vars', '2500' );
        $factura_array      = $this->input->post('txt_factura');
        $detalles_array     = $this->input->post('txt_detalles');
        $usuarioxcaja       = $this->input->post('txt_cajero');
        $tipo_factura       = $this->input->post('txt_tipo_factura');

        $correlativo_inicial    = 0;
        $correlativo_final      = 0;
        $id_factura_inicial     = 0;
        $id_factural_final      = 0;
        $cantidad_facturas      = 0;
        
        $this->db->join('cxj_correlativoxcaja','cxj_id_cof = cof_id');
        $this->db->join('caj_caja','caj_id = cxj_id_caj');
        $this->db->join('uxc_usuarioxcaja','uxc_id_caj = caj_id');
        $this->db->join('sef_serie_factura','cof_id_sef = sef_id');
        $correlativos = $this->gsatelite->get_tabla('cof_correlativo_factura',array('cxj_estado' => 1 , 'uxc_id' => $usuarioxcaja, 'cof_masivo' => 1, 'sef_id_tif' => $tipo_factura ));
       
        $correlitvo_actual      = $this->gsatelite->get_max('fac_factura','fac_numero',array('fac_id_cof' => $correlativos[0]['cof_id'] ) );

        $correlitvo_actual      = ($correlitvo_actual != null)?$correlitvo_actual + 1:$correlativos[0]['cof_inicio'];
        $correlativo_inicial    = $correlitvo_actual ;
        $facturas_creadas       = "";

        $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
        $array_num_fac = [];
        $array_fac_fecha_conta = [];
        $array_fac_tif = [];
        $id_cor = 0;

        foreach ($factura_array  as $key => $factura_jason) {
            $factura = json_decode($factura_jason);
            $cantidad_facturas++;

            $cec_caja =  $correlativos[0]['caj_id_cec_defecto'];
                if (!$cec_caja) {
                    $centro   = $this->gsatelite->get_tabla('cec_centro_costo',array('cec_estado'=>1,'cec_defecto' => 1));
                    $cec_caja = $centro[0]['cec_id'];
                }

            $fac_id_cec = $cec_caja;
            $fac_factura = array(
                'fac_id_cli'            => $factura->cliente,
                'fac_id_cof'            => $correlativos[0]['cof_id'],
                'fac_id_tpg'            => $factura->tipo_pago,
                'fac_id_tif'            => $factura->tipo_factura,
                'fac_id_uxc'            => $factura->usuario_caja,
                'fac_numero'            => $correlitvo_actual,
                'fac_fecha_fact'        => $factura->fecha_factura,
                'fac_fecha_cont'        => $factura->fecha_factura,
                'fac_nombre_factura'    => $factura->nombre,
                'fac_subtotal'          => $factura->sub_total,
                'fac_impuesto'          => $factura->impuesto,
                'fac_total'             => $factura->total,
                'fac_id_cec'            => $fac_id_cec,
                'fac_impuesto'          => $factura->impuesto,
                'fac_fecha_vencimiento' => $factura->fecha_vencimiento,
                'fac_monto_abono'       => 0,
                'fac_monto_pendiente'   => $factura->total,
                'fac_total_retencion'   => 0,
                'fac_retencion_abono'   => 0,
                'fac_tipo'              => 2,
                'fac_generacion_masiva' => 1,
                'fac_estado'            => 1,
                'fac_usu_crea'          => $this->tank_auth->get_user_id(),
                'fac_fecha_crea'        => date('Y-m-d H:i:s'),
                'fac_usu_mod'           => $this->tank_auth->get_user_id(),
                'fac_fecha_mod'         => date('Y-m-d H:i:s')
            );
            $fac_id = $this->gsatelite->ingresar('fac_factura', $fac_factura);
            
            $correlativo_final = $correlitvo_actual;

            $correlitvo_actual = $correlitvo_actual + 1;
            
            if ($cantidad_facturas == 1) {
                $id_factura_inicial = $fac_id;
            }
            $id_factural_final = $fac_id;

            $facturas_creadas = $facturas_creadas.$fac_id.", ";

            $detalles_jason = $detalles_array[$key];
            $detalles = json_decode($detalles_jason);
            
            foreach ($detalles as $detalle) {
                $def_detalle_fact = array(
                    'def_id_fac'                => $fac_id,
                    'def_id_art'                => $detalle->servicio,
                    'def_id_cva'                => $detalle->conversion,
                    'def_id_pxl'                => $detalle->plan,
                    'def_descripcion'           => $detalle->descripcion,
                    'def_cantidad'              => $detalle->cantidad,
                    'def_precio'                => $detalle->precio,
                    'def_porcentaje_impuesto'   => $detalle->porcentaje,
                    'def_impuesto'              => $detalle->impuesto,
                    'def_subtotal'              => $detalle->sub_total,
                    'def_fecha_inicio'          => $detalle->fecha_inicio,
                    'def_fecha_fin'             => $detalle->fecha_fin,
                    'def_estado'                => 1,
                    'def_usu_crea'              => $this->tank_auth->get_user_id(),
                    'def_fecha_crea'            => date('Y-m-d H:i:s'),
                    'def_usu_mod'               => $this->tank_auth->get_user_id(),
                    'def_fecha_mod'             => date('Y-m-d H:i:s')
                );
                $def_id =$this->gsatelite->ingresar('def_detalle_fact', $def_detalle_fact);
                
                //no es servicio es cargo adicional
                if ( $detalle ->servicio_array == 0) {
                    $cxs_cargoxfacturacion_serv = array(
                        'cxs_id_caf'        => $detalle->cargo_facturacion,
                        'cxs_id_def'        => $def_id,
                        'cxs_estado'        => 1,
                        'cxs_usu_crea'      => $this->tank_auth->get_user_id(),
                        'cxs_fecha_crea'    => date('Y-m-d H:i:s'),
                        'cxs_usu_mod'       => $this->tank_auth->get_user_id(),
                        'cxs_fecha_mod'     => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('cxs_cargoxfacturacion_serv', $cxs_cargoxfacturacion_serv);
                }
                
                if ( count(get_object_vars( $detalle->impuesto_detalle_array ) > 0) ) {
                    
                   $impuestos =  (array)$detalle->impuesto_detalle_array;
                   
                    foreach ( $impuestos as $key => $impuesto){
                        $impuesto = (array)$impuesto;
                        $ixf_impuestoxfactura_array = array(
                            'ixf_id_imp'        => $key,
                            'ixf_id_def'        => $def_id,
                            'ixf_monto'         => $impuesto['impuesto_mon'],
                            'ixf_porcentaje'    => $impuesto['impuesto_por'],
                            'ixf_estado'        => 1,
                            'ixf_usu_crea'      => $this->tank_auth->get_user_id(),
                            'ixf_fecha_crea'    => date('Y-m-d H:i:s'),
                            'ixf_usu_mod'       => $this->tank_auth->get_user_id(),
                            'ixf_fecha_mod'     => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('ixf_impuestoxfactura', $ixf_impuestoxfactura_array);
                    }

                }
                //Prapara array para la generacion de partidas masiva
                //Se definen forma estatica
                //Centro de Costso: VENTAS = 2
                //Tipo de cuenta: INGRESO POR VENTA GRAVADA = 2
                //Cuenta contable: 5020101 - CUOTA SOCIAL  = 1371

                //Centro costo de la caja
                $cec_caja =  $correlativos[0]['caj_id_cec_defecto'];
                if (!$cec_caja) {
                    $centro   = $this->gsatelite->get_tabla('cec_centro_costo',array('cec_estado'=>1,'cec_defecto' => 1));
                    $cec_caja = $centro[0]['cec_id'];
                }

                $dcf_id_cec = $cec_caja;
                //Tipo de cuenta contable
                $tcn = json_decode($this->gsatelite->get_parametro('SYS_TIPO_CUENTAS'));
                $dcf_id_tcn = $tcn->INGRESO;

                //cuenta contable
                $dcf_id_cnt = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');

                $dcf_porcentaje = 100.000000;

                $array_dcf_x_def = array(
                    'dcf_id_def' => $def_id,
                    'dcf_id_cec' => $dcf_id_cec,//Centro de costos VENTAS
                    'dcf_id_tcn' => $dcf_id_tcn,//Tipo de cuentas INGRESO POR VENTA GRAVADA
                    'dcf_id_cnt' => $dcf_id_cnt,//Cuenta contable
                    'dcf_porcentaje' => $dcf_porcentaje,
                    'dcf_monto' => $factura->sub_total,
                    'dcf_estado'=> 1,
                    'dcf_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dcf_usu_modificacion' => $this->tank_auth->get_user_id(),

                );
                $this->gsatelite->ingresar('dcf_detalle_centrocostoxfactura', $array_dcf_x_def);               

            }//Fin de los detalles de la factura
            //Creacion de arreglos para usarse en la insercion de las partidas
            $array_num_fac[$id_cor] = $correlitvo_actual;
            $array_fac_fecha_conta[$id_cor] = $factura->fecha_factura;
            $array_fac_tif[$id_cor] = $factura->tipo_factura;
            $id_cor++;
                       
        }
        $facturas_creadas = substr($facturas_creadas, 0, -2);        
        //obtener las facturas 
        $fac_ids = explode(",", $facturas_creadas);        
        $this->db->where_in('fac_id',$fac_ids);
        $this->db->join('tif_tipo_factura','tif_id = fac_id_tif');
        $this->db->join('cli_cliente','cli_id = fac_id_cli');
        $facturas = $this->gsatelite->get_tabla('fac_factura',null);
        /*************Generacion de partida masiva***********************/            
        $id_cor = 0;        
        foreach ($fac_ids as $k => $fa_id) {
            if($array_fac_tif[$id_cor] == 1 || $array_fac_tif[$id_cor] == 2){
                if($generar_partida > 0){
                    $where['fac_id'] = $fa_id;                            
                    $info['num_fac'] = $array_num_fac[$id_cor]; //$correlitvo_actual;
                    $info['fac_fecha_conta'] = $array_fac_fecha_conta[$id_cor];
                    $this->generar_partida_contable_masiva($where, $info);
                }                
            }
            $id_cor++;        
        }        
        /*************Fin Generacion de partida masiva*******************/   
        
        $data['correlativo_inicial']    = $correlativo_inicial;
        $data['correlativo_final']      = $correlativo_final;
        $data['factura_inicial']        = $id_factura_inicial;
        $data['factura_final']          = $id_factural_final;
        $data['where_in']               = $facturas_creadas;
        $data['facturas']               = $facturas;
        $html = $this->load->view('modulo_contratos/procesos/consultar_facturas_procesadas', $data, true);

        $data2['html'] = $html;
        echo json_encode($data2);        
        die();  
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 21/11/2017 
        *Descripción: agrega observación en fac_observacion
    */
    function mensaje(){
        satelite_validar();
        $fac_observacion  = $this->input->post('mensaje');
        $fac_id           = $this->input->post('factura');

        $fac_factura = array(
            'fac_observacion'   => $fac_observacion,
            'fac_usu_mod'       => $this->tank_auth->get_user_id(),
            'fac_fecha_mod'     => date('Y-m-d H:i:s')
        );
        $result_id = $this->gsatelite->actualizar_array('fac_factura',$fac_factura,array('fac_id' =>$fac_id ) );

        $result = $this->gsatelite->get_campo('fac_factura','fac_numero',array('fac_id' => $fac_id) );
        echo $result;
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 22/11/2017 
        *Descripción: consultar observación en fac_observacion
    */
    function consultar_descripcion() {
        satelite_validar();
        $fac_id           = $this->input->post('factura');
        $result = $this->gsatelite->get_campo('fac_factura','fac_observacion',array('fac_id' =>$fac_id ) );
        echo $result;
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 25/11/2017 
        *Descripción: imprimir facturas masivamente
    */
    function imprecion_masiva($correlativo_inicial = 0, $correlativo_final =0, $factura_inicial = 0,$factura_final=0) {
        satelite_validar();
       
        $this->load->library('EnLetras');
        
        $facturas = $this->contratos_model->get_facturas_info($correlativo_inicial, $correlativo_final, $factura_inicial,$factura_final);
        $data['facturas'] = $facturas;
        $html = $this->load->view('modulo_contratos/procesos/impresion_masiva', $data, true);
        $this->pdf->makePdf($html, 'L', 'Facturas', 'Letter');
    }

    /**
    *@author: Francisco Orozco
    *Fecha: 05/12/2017 
    *Descripción: eliminacion facturas masivamente
    */
    public function anulacion_facturas(){
        satelite_validar();
        if ($_POST) {
            $post_array         = $this->input->post();
            $fecha_inicio_corte = ($post_array['fecha_inicio_corte'] != '' )? date('Y-m-d', strtotime($post_array['fecha_inicio_corte'])): null;
            $fecha_fin_corte    = ($post_array['fecha_fin_corte'] != '')? date('Y-m-d', strtotime($post_array['fecha_fin_corte'])): null;
            $servicio       = ($post_array['servicio'] != '') ? $post_array['servicio'] : null;
            $planes         = ($post_array['plan'] != '') ? $post_array['plan'] : null;
            $tipo_factura   = ($post_array['tipo_factura'] != '') ? $post_array['tipo_factura'] : null;
            $where = null;
            if($servicio != null){
                $where['art_id'] = $servicio ;
            }
            if($planes != null){
                $where['pln_id'] = $planes ;
            }
            if($tipo_factura != null){
                $where['fac_id_tif'] = $tipo_factura ;
            }
            if($fecha_inicio_corte != null && $fecha_fin_corte != null) {
                $where['fac_fecha_fact >='] = $fecha_inicio_corte;
                $where['fac_fecha_fact <='] = $fecha_fin_corte;
            }
            $where['fac_generacion_masiva'] = 1; 
            $where['fac_estado <>'] = 0;            
            $data['facturas'] = $this->contratos_model->get_factura_masivas($where);
            $data['anulacion'] = true;
            $html = $this->load->view('modulo_contratos/reportes/consultar_facturas_masivas', $data, true);
            $data2['html'] = $html;
            echo json_encode($data2);
            die();  
        } else {
            $data['servicio'] =  $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 1) );
            $data['tipo_factura'] =  $this->gsatelite->get_tabla('tif_tipo_factura',array('tif_estado' => 1) );
            $data['titulo_personal'] = "Anulación de Facturas";
            $this->_cargarvista($data);
        }
    }

    public function ver_detalle_factura(){
        satelite_validar();
        $post_array         = $this->input->post();
        $def_id_fac         = ($post_array['ver_detalle_factura'] != '') ? $post_array['ver_detalle_factura'] : null;
        $where['fac_id']    = $def_id_fac;
        $group_by = false;
        $detalle_factura = $this->contratos_model->get_factura_masivas($where, $group_by);
        $data['detalle_factura'] = $detalle_factura;
        $html = $this->load->view('modulo_contratos/procesos/consultar_detalle_factura', $data, true);
        $data2['html'] = $html;
        echo json_encode($data2);
        die(); 
    }

    public function anular_factura() {
        satelite_validar();
        $post_array  = $this->input->post();
        $this->load->library('../controllers/facturacion/facturar');
        $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
        $descripcion = ($post_array['descripcion'] != '') ? $post_array['descripcion'] : null;
        $facturas    = ($post_array['factura_inicio'] != '') ? $post_array['factura_inicio'] : array();
        $anularse    = ($post_array['anular'] != '') ? $post_array['anular'] : array();
        $partidas    = ($post_array['factura_pct'] != '') ? $post_array['factura_pct'] : array();
        $numero_fact = ($post_array['factura_num'] != '') ? $post_array['factura_num'] : array();
        $ajax        = ($post_array['ajax'] != '') ? $post_array['ajax'] : 0;
        $contador    = count($facturas);
        for ($i = 0; $i < $contador; $i++) {
            if ($anularse[$i] > 0) {
                $factura = $facturas[$i];
                $fac_factura = array(
                    'fac_motivo_anulacion'  => $descripcion,
                    'fac_estado'            => 0,
                    'fac_fecha_anulacion'   => date('Y-m-d H:i:s'),
                    'fac_usu_mod'           => $this->tank_auth->get_user_id(),
                    'fac_fecha_mod'         => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('fac_factura', $fac_factura, array('fac_id' => $factura));
                //Si hay partida, hacer la partida de anulacion
                if ($partidas[$i] != "") {
                    if($generar_partida > 0){
                        $where['fac_id'] = $factura;
                        $info['num_fac'] = $numero_fact[$i];
                        $res_debe = $this->generar_partida_anular_factura_masivas($where, $info);
                        $this->facturar->generar_partida_anular_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_debe'], false);
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct_anulacion' => $res_debe['id_pct']), array('fac_id' => $factura));                        
                    }
                }
                //obtener los detalles que tienen cargo
                            $this->db->join('cxs_cargoxfacturacion_serv', 'cxs_id_def = def_id', 'LEFT');
                $detalles = $this->gsatelite->get_tabla('def_detalle_fact', array('def_id_fac' => $factura));
                foreach($detalles as $detalle) {
                    $cargos = $this->gsatelite->get_tabla('caf_cargo_facturacion',array('caf_id' => $detalle['cxs_id_caf']) ); 
                    $cuotas_pagadas  = $cargos[0]['caf_cuota_pagadas'];
                    $cuotas_anuladas = $detalle['def_cantidad'];
                    $cuotas_actuales = $cuotas_pagadas - $cuotas_anuladas;
                    $caf_cargo_facturacion = array(
                        'caf_cuota_pagadas'    => $cuotas_actuales,
                        'caf_usu_modificacion'       => $this->tank_auth->get_user_id(),
                        'caf_fecha_modificacion'     => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('caf_cargo_facturacion', $caf_cargo_facturacion, array('caf_id' => $detalle['cxs_id_caf']));
                }
            }
        }
        if($ajax == 0){
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Anulación de facturas", 'texto_alerta' => "Se anularon las facturas correctamente.");
            $this->session->set_flashdata($alerta);
            redirect('/modulo_contratos/procesos/anulacion_facturas/');
        }
    }

    /**
     * @author: Francisco Orozco
     * fecha: 15/12/2017     
     * descripción: callback column para para mostrar cantidad de decimales
     */
    function _column_decimales($value, $row) {
        $result = "";
        if ( $value != "") {
            $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
            $cantidad_decimales = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;
            $new_value = number_format($value, $cantidad_decimales, '.', '');
            $result = $new_value;
        }
        return $result;
    }

    /**
     * @author: Francisco Orozco
     * fecha: 12/01/2018     
     * descripción: Reimpresion de facturas.
     */
    public function reimpresion_facturas($flag = null){
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        if ($_POST) {
            $post_array         = $this->input->post();

            $fecha_inicio       = ($post_array['fecha_inicio'] != '' )? date('Y-m-d', strtotime($post_array['fecha_inicio'])) : null;
            $fecha_fin          = ($post_array['fecha_fin'] != '')? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;

            $fecha_inicio_corte = ($post_array['fecha_inicio_corte'] != '' )? date('Y-m-d', strtotime($post_array['fecha_inicio_corte'])): null;
            $fecha_fin_corte    = ($post_array['fecha_fin_corte'] != '')? date('Y-m-d', strtotime($post_array['fecha_fin_corte'])): null;

            $servicio           = ($post_array['servicio'] != '') ? $post_array['servicio'] : null;
            $planes             = ($post_array['plan'] != '') ? $post_array['plan'] : null;
            $tipo_factura       = ($post_array['tipo_factura'] != '') ? $post_array['tipo_factura'] : null;

            $periodo            = ($post_array['periodo'] != '') ? $post_array['periodo'] : null;
            $tipo_reporte       = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : "";
            
            $where = null;

            if ( $servicio  != null ) {
                $where['art_id'] = $servicio ;
            }

            if ( $planes != null ) {
                $where['pln_id'] = $planes ;
            }

            if ( $tipo_factura != null ) {
                $where['fac_id_tif'] = $tipo_factura ;
            }   

            if ( $fecha_inicio != null || $fecha_fin != null) {
                $where['def_fecha_inicio >=']   = $fecha_inicio;
                $where['def_fecha_fin <=']      = $fecha_fin;
            }

            if ( $fecha_inicio_corte != null || $fecha_fin_corte != null) {
                $where['fac_fecha_fact >='] = $fecha_inicio_corte;
                $where['fac_fecha_fact <='] = $fecha_fin_corte;
            }

            if ( $periodo != null) {
                $where['fac_nombre_factura'] = $periodo;
            }

            $where['fac_generacion_masiva'] = 1;
            $where['fac_estado <>']         = 0;

            $data['facturas']               = $this->contratos_model->get_factura_masivas($where);

            $data2['factura_inicial']       = $data['facturas'][0]['fac_id'];
            $data2['factura_numero_inical'] = $data['facturas'][0]['fac_numero'];
            $data2['factura_numero_final']  = 0;
            $facturaciones = "";
            if ( count($data['facturas']) >0 ) {
                foreach ($data['facturas'] as $value){
                    $facturaciones= $facturaciones.$value['fac_id'].",";
                    $data2['factura_final']         = $value['fac_id'];
                    $data2['factura_numero_final']  = $value['fac_numero'];
                }
            }
            $data['anulacion']      = false;
            $data['tipo_reporte']   = $tipo_reporte;
            $filename               = 'Reporte_facturacion_masiva_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['tipo_vista']     = ($flag != null)?"p":"r";//verifica si es tipo proceso y vista para las acciones
            $html                   = $this->load->view('modulo_contratos/reportes/consultar_facturas_masivas', $data, true);

            if ($tipo_reporte == '') {
                $data2['html']              = $html;
                $data2['facturaciones']     =  substr($facturaciones, 0, -1);
                echo json_encode($data2);
                die();  
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Reporte de facturacion masiva';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_facturacion_masiva_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_facturacion_masiva', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                $filename                   = 'Reporte_facturacion_masiva_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['titulo']             = 'Reporte de facturacion masiva';
                $data['filename']           = $filename;
                echo $html;
            }
        } else {
            $data['servicio']           =  $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 1) );
            $data['tipo_factura']       =  $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1) );
            $data['titulo_personal']    = "Reimpresión de facturas";
            $this->_cargarvista($data);
        }
    }

    /**
        * @author: Francisco Orozco
        * fecha: 28/02/2018     
        * descripción: vista de obtencion de cliente con deuda para generar recibo de cuotas.
    */
    function impresion_cuotas(){
        satelite_validar();
        if ($_POST) {    

            $fecha_desde                    = date('Y-m-d', strtotime($this->input->post('fecha_desde')));
            $fecha_hasta                    = date('Y-m-d', strtotime($this->input->post('fecha_hasta')));
            $fecha_sobre                    = date('Y-m-d', strtotime($this->input->post('fecha_sobre')));
            $cliente                        = $this->input->post('cliente');

            $where                          = null;
            $where['fac_monto_pendiente >'] = 0;
        
            if ( $cliente != "" ){
                $where['cli_id']    = $cliente;
                $where['cli_estado']= 1;
            }

            $clientes               = $this->contratos_model->get_sobre_cuotas($where, $fecha_desde, $fecha_hasta);
            $data['clientes']       = $clientes;
            $data['fecha_sobre']    = $fecha_sobre;
            $html                   = $this->load->view('modulo_contratos/procesos/consultar_impresion_cuotas', $data, true);
            $data2["html"]          = $html;
            $data2["cantidad"]      = count($clientes);
            echo json_encode($data2);
            die();  
        } else {
            $this->db->group_by("fac_nombre_factura");
            $data['periodos']           = $this->gsatelite->get_tabla("fac_factura",array("fac_generacion_masiva" => 1) );
            $data['tipos_factura']      = $this->gsatelite->get_tabla("cfc_clasificacion_cliente",array("cfc_estado" => 1) );
            $data['titulo_personal']    = "Impresión de sobre de cuotas";
            $this->_cargarvista($data);
        }
    }

    /**
        * @author: Francisco Orozco
        * fecha: 28/02/2018     
        * descripción: generara un impresion masiva o individual de recibo de cuotas.
    */
    function imprimir_cuotas($cliente = ""){
        satelite_validar();
        if ($_POST) { 
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');              
            $clasificacion  = "";
            $limit          = "";
            $desde          = "";       
            $cliente        = $this->input->post('filtro_cliente');
            $fecha_desde    = date('Y-m-d', strtotime($this->input->post('filtro_fecha_inicio')));
            $fecha_hasta    = date('Y-m-d', strtotime($this->input->post('filtro_fecha_fin')));
            $fecha_sobre    = date('d-m-Y', strtotime($this->input->post('filtro_fecha_sobre')));
            $desde          = $this->input->post('txt_correlativo_inicial');
            $hasta          = $this->input->post('txt_correlativo_final');         
            $limit          = ($hasta - $desde)+1;          
            $where          = null;
            $where['fac_monto_pendiente >'] = 0;        
            if ( $cliente != "" ){
                $where['cli_id']    = $cliente;
            }
            $desde                  = $desde - 1;
            $clientes               = $this->contratos_model->get_sobre_cuotas($where, $fecha_desde, $fecha_hasta, $limit, $desde);            
            $html                   = "";
            $data['fecha_sobre']    = $fecha_sobre;
            $data['fecha_hasta']   = $fecha_hasta;
            $data["enviar_correo"] = false;
            $length = count($clientes);
            for ($i = 0; $i < $length; $i++) {
                $data["clientes"] = $clientes[$i];
                if ($i == ($length - 1)) {
                    $html .= trim($this->load->view('modulo_contratos/procesos/impresion_recibo_cuotas_sobre', $data, true));
                } else {
                    $html .= str_replace('<br/>', '<br style="page-break-after: always;" />', trim($this->load->view('modulo_contratos/procesos/impresion_recibo_cuotas_sobre', $data, true)));
                }
            }
            $this->pdf->SetAutoPageBreak(true, 0);
            $this->pdf->setPrintFooter(false);
            $this->pdf->makePDF($html, 'P', 'sobre', 'Letter');

             //$html                   = $this->load->view('modulo_contratos/procesos/impresion_recibo_cuotas', $data, true);
            /*$formato = "216,205";
            $formato_array = explode(",",$formato); //convierte el formato a array por si se quiere un formato personalizado de pagina
            $orientacion = "P";
            $setCellPaddings = "0,0,0,0";
            $margins = "0, 0, 0";
            $formato = (count($formato_array) > 1)?$formato_array:$formato;
            $this->pdf->setPrintHeader(false);
            $this->pdf->SetFont('calibrib');
            $this->pdf->setCellPaddings($setCellPaddings);
            $this->pdf->SetAutoPageBreak(true, 0);
            $this->pdf->SetMargins($margins); 
            $this->pdf->AddPage($orientacion, $formato, array(
                'family' => 'calibrib',
                'style' => '',
                'size' => 12)
            );
            $this->pdf->setPrintFooter(false);
            $this->pdf->writeHTML($html, true, false, false, false, '');
            $this->pdf->boletaPDF('I');*/
        }
    }

    /**
    * @author: Raul E.
    * since: Feb/2021
    * description: generara un impresion de version 2 de sobre / recibo de cuotas.
    */
    function imprimir_sobres($cliente = ""){
        satelite_validar();
        if ($_POST) {
            $cliente = $this->input->post('filtro_cliente_sobre');
            $fecha_desde = formatear_fecha('Y-m-d', $this->input->post('filtro_fecha_inicio_sobre'));
            $fecha_hasta = formatear_fecha('Y-m-d', $this->input->post('filtro_fecha_fin_sobre'));
            $fecha_sobre = formatear_fecha('d-m-Y', $this->input->post('filtro_fecha_imp_sobre'));
            $where = array('cli_id' => $cliente, 'fac_monto_pendiente > ' => 0);
            $reg_cliente = $this->contratos_model->get_sobre_cuotas($where, $fecha_desde, $fecha_hasta);
            $data['fecha_sobre']   = $fecha_sobre;
            $data['fecha_hasta']   = $fecha_hasta;
            $data["clientes"]      = $reg_cliente[0];
            $data["enviar_correo"] = false;
            $html = $this->load->view('modulo_contratos/procesos/impresion_recibo_cuotas_sobre', $data, true);
            $this->pdf->SetAutoPageBreak(true, 0);
            $this->pdf->setPrintFooter(false);
            $this->pdf->SetTitle('Imprimir');
            $this->pdf->makePDF($html, 'P', 'sobre', 'Letter');
        }
    }

    /**
    * @author: Raul E.
    * since: Feb/2021
    * description: generara el archivo impresion de version 2 de sobre / recibo de cuotas y lo envia por correo.
    */
    public function enviar_correo_sobre(){
        if ($_POST) {
            $cliente = $this->input->post('cli_id');
            $fecha_desde = formatear_fecha('Y-m-d', $this->input->post('f_ini_sob'));
            $fecha_hasta = formatear_fecha('Y-m-d', $this->input->post('f_fin_sob'));
            $fecha_sobre = formatear_fecha('d-m-Y', $this->input->post('f_imp_sob'));
            $mails_all =  array();
            $contactos = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $cliente, 'con_email IS NOT NULL' => null, 'con_estado' => 1));
            $email_cli = $this->gsatelite->get_campo('cli_cliente', 'cli_email', array('cli_id' => $cliente));
            if ($email_cli != "") {
                array_push($mails_all, $email_cli);
            }
            $email_con = array();// array_filter(array_column($contactos, 'con_email'));
            if (count($email_con) > 0) {
                $mails_all = array_merge($mails_all, $email_con);
            }
            if (!(count($mails_all) > 0)) {
                echo json_encode(array('exito' => 2));
                die();
            }
            $where = array('cli_id' => $cliente, 'fac_monto_pendiente > ' => 0);
            $reg_cliente = $this->contratos_model->get_sobre_cuotas($where, $fecha_desde, $fecha_hasta);
            $data['fecha_sobre']   = $fecha_sobre;
            $data['fecha_hasta']   = $fecha_hasta;
            $data["clientes"]      = $reg_cliente[0];
            $data["enviar_correo"] = true;
            $html = $this->load->view('modulo_contratos/procesos/impresion_recibo_cuotas_sobre', $data, true);
            $meses = array('', 'ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep', 'oct', 'nov', 'dic');
            $part1 = str_replace(' ', '_', $reg_cliente[0]['cliente']);
            $part2 = $meses[date('n', strtotime($fecha_hasta))];
            $part3 = date('Y', strtotime($fecha_hasta));
            $nombre_pdf = $part1 . '_' . $part2 . '_' . $part3;
            $this->pdf->setPrintFooter(false);
            $GLOBALS['nombre_reporte'] = $nombre_pdf;
            $this->pdf->makePDF($html, 'P', $nombre_pdf, 'Letter', 'F');
            $ruta = FCPATH . $nombre_pdf . '.pdf';
            $ruta_adjunto = file_exists($ruta) ? $ruta : null;
            if (file_exists($ruta_adjunto)) {
                            $this->db->join('emp_empleado', 'usu_id_emp = emp_id');
                $empleado = $this->gsatelite->get_tabla('users', array('id' => $this->tank_auth->get_user_id()));
                if (!(count($empleado) > 0)) {
                    echo json_encode(array('exito' => 3));
                    die();
                }                
                $mens_html = '<!DOCTYPE html><html lang="es"><head><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><title>' . $reg_cliente[0]['cliente'];
                $mens_html .= '</title><link rel="stylesheet" href=""></head><body><div style="max-width:800px;margin:0;padding:30px 0;"><table width="80%" border="0" cellpadding="0">';
                $mens_html .= '<tr><td width="5%"></td><td align="left" width="95%" style="font: 13px/18px Arial, Helvetica, sans-serif;"><h4>Estimado(a) ' . $reg_cliente[0]['cliente'];
                $mens_html .= '</h1><br><p>Deseamos notificarle de su estado de cuenta hasta el ' . formatear_fecha('d-m-Y', $fecha_hasta) . '</p><br><p>';
                $mens_html .= 'Si usted ya cancelo el saldo pendiente al recibo de la presente, favor hacer caso omiso al recordatorio.</p></td></tr></table></div></body></html>';
                $nombre_envia = $empleado[0]['emp_nombre'].' '.$empleado[0]['emp_apellido']; 
                $de = $empleado[0]['email'];
                $exito = $this->gsatelite->envio_correo($de, $nombre_envia, $de, 'Estado de Cuenta', $mens_html, $mails_all, $ruta_adjunto, false);
                unlink($ruta_adjunto);
                echo json_encode(array('exito' =>  $exito));
            } else {
                echo json_encode(array('exito' => 0));
            }
        }
    }

    /**
        * @author Francsico Orozco
        * @since 2018-01-02
        * @return clientes
        * @param $like string para condicionar.
    */
    public function get_clientes_like(){
        if ($_POST) {
            $like           = $this->input->post('cliente');
            $clasificacion  = $this->input->post('clasificacion');
            $evaluar_plan   = $this->input->post('evaluar_plan');
    
            $where['cli_estado'] = 1;

            if( $clasificacion != "" or $clasificacion != false){
                $where['cli_id_cfc'] = $clasificacion;
            }

            if ($evaluar_plan == true) {
                $where['sxc_estado'] = 1;
                $where['pxl_estado'] = 1;
            }

            $result = $this->contratos_model->get_clientes_like($where,$like,$evaluar_plan);
            echo json_encode($result);
        }
    }

    /**
        * @author Francsico Orozco
        * @since 2018-06-05
        * @return servicios
    */
    public function get_servicio_cliente(){
        if ($_POST) {
            $cliente    = $this->input->post('cliente');
            $this->db->limit(1);
            $result     = $this->gsatelite->get_campo("sxc_servicioxcliente","sxc_id_art", array("sxc_estado" => 1, "sxc_id_cli" => $cliente ) );
            echo $result;
            die();
        }
    }
    
    /**
        * @author Elman Ortiz
        * @since 2018-06-20
        * @return Partidas contables masivas
    */
    public function generar_partida_contable_masiva($where, $info){
        //Instancia del objeto
        $this->load->library('../controllers/facturacion/facturar');

        $res_debe = $this->facturar->generar_partida_factura_afecta_noafecta_inv_debe($where,$info);
        $this->facturar->generar_partida_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_haber']);
        //Insertando los detalles
        if(count($res_debe['array_detalle_partida']) > 0){                
              $this->gsatelite->ingresar('dpc_detalle_partida', $res_debe['array_detalle_partida'], true);            
        }

        //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida
        //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
        $this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct' => $res_debe['id_pct'], 'fac_generacion_partida' => 1),array('fac_id' => $where['fac_id']));
    }

    /**
    * @author René Castaneda
    * @since 2019-03-14
    * @return Inactivar Servicios
    */
    public function inactivar_servicioxcliente($id_sxc)
    {
        satelite_validar();
        $data['exito'] = 0;
        if ($this->input->post()) {
           $obs = $this->input->post('txtObservacion');
           $id_sxc = $this->input->post('txtId_sxc');
           $fecha = date('Y-m-d H:i:s');//formatear_fecha('Y-m-d H:i:s',$this->input->post('txt_fecha_inactivo'));
           if (trim($obs) !='') {
               $update_array = array(
                'sxc_estado' => 0,
                'sxc_observacion_inactivo' => $obs,
                'sxc_usu_modificacion'       => $this->tank_auth->get_user_id(),
                'sxc_fecha_inactivo'     => $fecha,
                'sxc_fecha_modificacion'     => date('Y-m-d H:i:s')
                );
           $exito =  $this->gsatelite->actualizar_array('sxc_servicioxcliente',$update_array,array('sxc_id' => $id_sxc));
           $data['exito'] = $exito;

           }
        }
        $data['titulo_personal'] = "Inactivar Servicio";
        $registro = $this->contratos_model->get_cliente_servicio(array('sxc_id' =>$id_sxc));
        $data['registro'] = $registro[0];
        $this->gsatelite->cargar_vista_masterpage('modulo_contratos/procesos/inactivar_servicioxcliente',$data);
    }

    /**
    * @author Raul Escalante
    * @since Ene-2020
    * @return Contra-Partida para anular factura
    */
    function generar_partida_anular_factura_masivas($where, $info){
        $total_debe = 0.0000;
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
        $where['idtipo_cnt'] = ($idtipo_cnt > 0) ? $idtipo_cnt : 0;
        $cnt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac_anular($where, false);
        $cnt_imps = $this->facturacion_model->get_cnt_x_impu_x_fac_anular($where, false);
        $cnt_rets = $this->facturacion_model->get_cnt_x_ret_x_fac_anular($where, false);
        foreach ($cnt_prods as $key => $cnt_prod) {
            $total_debe = $total_debe + $cnt_prod['subtotal_prod'];
        }
        foreach ($cnt_imps as $key => $cnt_imp) {
            $total_debe = $total_debe + $cnt_imp['ixf_monto'];
        }
        foreach ($cnt_rets as $key => $cnt_ret) {
            $total_debe = $total_debe + $cnt_ret['subtotxretcuenta'];
        }
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
        $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 2));
        $orp_partida = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
        if (count($consultar) > 0) {
            $id_tipo_partida = $tipo_partida;
        }
        $pct_tabla = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 3));
        $pct_concepto = (count($pct_tabla) > 0) ? $pct_tabla[0]['ccp_descripcion_concepto'] : 'Concepto no definido';
        $array_partida = array(
            'pct_id_tpd' => $id_tipo_partida,
            'pct_id_orp' => $orp_partida,
            'pct_concepto' => $pct_concepto.' - ' . $info['num_fac'],
            'pct_total' => number_format($total_debe, 4, '.', ''),
            'pct_fecha' => date('Y-m-d H:i:s'), 
            'pct_correlativo' => $correlativo_partida,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id()
        );
        $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
        foreach ($cnt_prods as $j => $deta) {
            $dpc_id_cnt = ($deta['cnt_id'] > 0) ? $deta['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_detalle = array(
                'dpc_id_cnt' => $dpc_id_cnt,
                'dpc_id_pct' => $id_pct,
                'dpc_concepto' => 'Venta de producto',
                'dpc_debe' => $deta['subtotal_prod'],
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
        foreach ($cnt_imps as $j => $deta) {
            $dpc_id_cnt = ($deta['cxe_id_cnt'] > 0) ? $deta['cxe_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_detalle = array(
                'dpc_id_cnt' => $dpc_id_cnt,
                'dpc_id_pct' => $id_pct,
                'dpc_concepto' => 'Impuestos por venta',
                'dpc_debe' => $deta['ixf_monto'],
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
        return array('id_pct' => $id_pct, 'total_debe' => $total_debe);
    }


}