<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author Francisco Orozco
 * @method Controlador de Catalogos - contratos
 */
class Catalogos extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('contratos_model');
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function _column_to_date($value, $row) {
        $result = "";
        if ( $value != "") {
            $result = date('d-m-Y', strtotime($value));
        }
        return $result;
    }

    /**
     * @author: Francisco Orozco
     * fecha: 15/12/2017     
     * descripción: callback column para para mostrar cantidad de decimales
     */
    function _column_decimales($value, $row) {
        $result = "";
        if ( $value != "") {
            $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
            $cantidad_decimales = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;
            $new_value = number_format($value, $cantidad_decimales, '.', '');
            $result = $new_value;
        }
        return $result;
    }

    /**
     * @author: Francisco Orozco
     * fecha: 12/05/2017     
     * descripción: Pantalla tambien se encuentra replicada en el mantenimiento de cotizaciones en el método tipo_servicio.
     */
    function tipo_servicio() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/catalogos/tipo_servicio');
        $crud = new grocery_CRUD();
        $crud->set_table('tps_tipo_servicio');
        $crud->set_subject('Tipo de Servicio');
        $crud->unset_export()->unset_print();

        $crud->required_fields('tps_nombre', 'tps_estado');
        $crud->columns('tps_nombre', 'tps_estado');
        $crud->display_as('tps_nombre', 'Nombre');
        $crud->display_as('tps_estado', 'Estado');
        $crud->field_type('tps_usu_mod', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tps_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tps_usu_crea', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tps_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
        $crud->set_rules('tps_nombre', 'Nombre', 'trim|required|campo_unico[tps_tipo_servicio.tps_nombre]');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tps_estado', 'hidden', 1);
        } else {  // Editar
            $crud->field_type('tps_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/prestaciones/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipo de Servicio";
        $this->_cargarvista($data, $output);
    }

    /**
     * @author: Francisco Orozco
     * fecha: 12/05/2017     
     * descripción: Pantalla tambien se encuentra replicada en el mantenimiento de cotizaciones en el método catalogo_servicios.
     */
    public function servicios() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/catalogos/servicios');
        $crud = new grocery_CRUD();
        $crud->set_table('art_articulo');
        $crud->set_subject('Servicio');

        $crud->set_relation('art_id_tia', 'tia_tipo_articulo', '{tia_nombre}');
        $crud->required_fields('art_nombre', 'art_estado');
        $crud->columns('art_nombre', 'art_descripcion', 'art_id_tia', 'art_estado');
        $crud->display_as('art_nombre', 'Nombre');
        $crud->display_as('art_codigo', 'Código');
        $crud->display_as('art_descripcion', 'Descripción');
        $crud->display_as('art_estado', 'Estado');
        $crud->display_as('art_id_tia', 'Categoría');
        $crud->field_type('art_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('art_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('art_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('art_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->set_rules('art_nombre', 'Nombre', 'trim|required|campo_unico[art_articulo.art_nombre]');
        $crud->where('art_tipo', 1);
        //$crud->add_fields('src_nombre','src_codigo','src_id_tps','src_descripcion','src_estado','src_foto','src_usu_mod','src_fecha_mod','src_usu_crea','src_fecha_crea');
        //$crud->edit_fields('src_nombre','src_codigo','src_id_tps','src_descripcion','src_estado','src_foto','src_usu_mod','src_fecha_mod');
        //$crud->set_field_upload('src_foto','uploads/anx_servicios');
        $crud->add_action('Planes', 'icon16 icon16 icomoon-icon-calendar-2', 'modulo_contratos/catalogos/planes', '');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('art_estado', 'hidden', 1)
                    ->field_type('art_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('art_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('art_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        //Se deshabilitan las opciones ya que los servicios nacen en Inventario
        $crud->unset_add();
        $crud->unset_edit();
        $crud->unset_delete();

        // Validaciones
        if ($permisos['permite_agregar']) {
            $data["agregar"] = true;
        }

        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', 'icomoon-icon-pencil-5', 'modulo_contratos/catalogos/editar_articulo');
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            //$crud->add_action('Ver', 'minia-icon-search', 'modulo_contratos/catalogos/servicios/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Servicios";
        $this->_cargarvista($data, $output);
    }

    /**
     * @author: Francisco Orozco
     * fecha: 15/05/2017     
     * descripción: Mantenimiento de los planes.
     *             Hereda permisos de servicios.              
     */
    public function planes($servicio = null) {
        
        satelite_validar();
        //se heredan permisos del padre
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/catalogos/servicios');

        $crud = new grocery_CRUD();
        $crud->unset_add();
        $crud->unset_edit();
        $crud->unset_export();

        $columns = array(
            'pln_nombre',
            'pln_costo',
            'pln_desde',
            'pln_hasta',
            'pln_tipo'
        );
        $alias = array(
            'pln_id_art' => 'Servicio',
            'pln_nombre' => 'Nombre',
            'pln_costo' => 'Costo',
            'pln_desde' => 'Desde',
            'pln_hasta' => 'Hasta',
            'pln_tipo' => 'Tipo',
            'pln_estado' => 'Estado'
        );
        $crud->set_table('pln_plan_promocion')
                ->set_subject('Planes/Promoción')
                ->where('pln_id_art', $servicio)
                ->columns($columns)
                ->display_as($alias)
                ->set_relation('pln_id_art', 'art_articulo', 'art_nombre', array('art_estado' => 1, 'art_tipo' => 1))
                ->set_rules('pln_nombre', 'Nombre', 'trim|required|callback_planes_nombre_unico')
                ->set_rules('pln_costo', 'Costo', 'trim|required|is_numeric')
                ->field_type('pln_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('pln_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('pln_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pln_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pln_tipo', 'dropdown', array('1' => 'Plan', '2' => 'Promoción'))
                ->callback_before_insert(function($post_array, $primary_key) {
                    //VERIFICAR SI LA FECHA DE PRESENTACION NO SEA MAYOR A LA ACTUAL
                    $datetime1 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_desde']))); //fecha desde
                    $datetime2 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_hasta']))); //fecha hasta

                    if ($datetime1 <= $datetime2) {
                        return TRUE;
                    } else {
                        return FALSE;
                    }
                })
                ->callback_before_update(function($post_array, $primary_key) {
                    //VERIFICAR SI LA FECHA DE PRESENTACION NO SEA MAYOR A LA ACTUAL
                    $datetime1 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_desde']))); //fecha desde
                    $datetime2 = new DateTime(date("Y-m-d H:i:s", strtotime($post_array['pln_hasta']))); //fecha hasta

                    if ($datetime1 <= $datetime2) {
                        return TRUE;
                    } else {
                        return FALSE;
                    }
                })
                ->set_lang_string('update_error', 'Verifique las fechas del período.')
                ->set_lang_string('insert_error', 'Verifique las fechas del período.')
        ;
        $crud->callback_column('pln_desde', array($this, '_column_to_date'));
        $crud->callback_column('pln_hasta', array($this, '_column_to_date'));
        $crud->callback_column('pln_costo', array($this, '_column_decimales'));
        
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pln_estado', 'hidden', 1);
        } else {
            $crud->field_type('pln_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $data['servicio'] = null;

        // Validaciones
        if ($permisos['permite_agregar']) {
            $data['servicio'] = $servicio;
        }

        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', 'icomoon-icon-pencil-5', 'modulo_contratos/catalogos/editar_plan/' . $servicio, '');
        }

        if (!$permisos['permite_eliminar']) {
            // $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            // $crud->add_action('Ver', 'minia-icon-search', 'modulo_contratos/catalogos/planes/read'.$servicio);
        }

        $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
        $data['decimales']  = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;

        $output = $crud->render();
        $data['titulo_personal'] = "Planes/Promociones";
        $this->_cargarvista($data, $output);
    }

    function agregar_plan($servicio = null) {
        if ($_POST) {
            $temp_array = array(
                'pln_nombre' => (!empty($_POST['nombre'])) ? $_POST['nombre'] : '',
                'pln_costo' => (!empty($_POST['costo'])) ? $_POST['costo'] : 0,
                'pln_desde' => date('Y-m-d', strtotime($_POST['fecha_desde'])),
                'pln_hasta' => (!empty($_POST['fecha_hasta'])) ? date('Y-m-d', strtotime($_POST['fecha_hasta'])) : NULL,
                'pln_tipo' => $this->input->post('tipo'),
                'pln_id_art' => (!empty($_POST['servicio'])) ? $this->input->post('servicio') : NULL,
                'pln_estado' => 1,
                'pln_fecha_crea' => date('Y-m-d H:i:s'),
                'pln_fecha_mod' => date('Y-m-d H:i:s'),
                'pln_usu_crea' => $this->tank_auth->get_user_id(),
                'pln_usu_mod' => $this->tank_auth->get_user_id()
            );
            $id_plan = $this->gsatelite->ingresar('pln_plan_promocion', $temp_array);

            if ($id_plan > 0) {
                //$codigos = explode(',', $this->input->post('codigos_aplica'));

                //$this->gsatelite->borrado_general('pxp_parametro_paixplan', array('pxp_id_pln' => $id_plan));
                /*foreach ($codigos as $key => $value) {
                    if (!empty($value)) {
                        $temp_array_codigos = array(
                            'pxp_id_ppa' => $value,
                            'pxp_id_pln' => $id_plan,
                            'pxp_estado' => 1,
                            'pxp_fecha_mod' => date('Y-m-d H:i:s'),
                            'pxp_fecha_crea' => date('Y-m-d H:i:s'),
                            'pxp_usu_crea' => $this->tank_auth->get_user_id(),
                            'pxp_usu_mod' => $this->tank_auth->get_user_id(),
                        );
                        $this->gsatelite->ingresar('pxp_parametro_paixplan', $temp_array_codigos);
                    }
                }*/
                if ($_POST['guardar'] == 1) {
                    $this->gsatelite->show_dialog('Registro ingresado exitosamente', "modulo_contratos/catalogos/agregar_plan/" . $_POST['servicio'], 'success');
                } else {
                    $this->gsatelite->show_dialog('Registro ingresado exitosamente', "modulo_contratos/catalogos/planes/" . $_POST['servicio'], 'success');
                }
            } else {
                $this->gsatelite->show_dialog('No se pudo guardar el registro', 'modulo_contratos/catalogos/planes', 'error');
            }
        } else {
            $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
            $data['decimales']  = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;
            $data['servicio']   = $servicio;
            $data['titulo_personal'] = "Planes/Promociones";
            $this->_cargarvista($data);
        }
    }

// End of agregar_plan

    function editar_plan($servicio = null, $id_plan = NULL) {
        satelite_validar();
        if ($_POST) {
            $temp_array = array(
                'pln_nombre' => (!empty($_POST['nombre'])) ? $_POST['nombre'] : NULL,
                'pln_costo' => (!empty($_POST['costo'])) ? $_POST['costo'] : NULL,
                'pln_desde' => date('Y-m-d', strtotime($_POST['fecha_desde'])),
                'pln_hasta' => ($_POST['fecha_hasta'] != "")? date('Y-m-d', strtotime($_POST['fecha_hasta'])) : NULL,
                'pln_tipo' => $this->input->post('tipo'),
                'pln_estado' => ($_POST['estado'] == 1) ? $_POST['estado'] : 0,
                'pln_fecha_mod' => date('Y-m-d H:i:s'),
                'pln_usu_mod' => $this->tank_auth->get_user_id()
            );
            $id_plan = $this->gsatelite->actualizar_array('pln_plan_promocion', $temp_array, array('pln_id' => $_POST['pln_id']));

            if ($id_plan > 0) {
                //$codigos = explode(',', $this->input->post('codigos_aplica'));

                /*$this->gsatelite->borrado_general('pxp_parametro_paixplan', array('pxp_id_pln' => $_POST['pln_id']));
                foreach ($codigos as $key => $value) {
                    if (!empty($value)) {
                        $temp_array_codigos = array(
                            'pxp_id_ppa' => $value,
                            'pxp_id_pln' => $_POST['pln_id'],
                            'pxp_estado' => 1,
                            'pxp_fecha_mod' => date('Y-m-d H:i:s'),
                            'pxp_fecha_crea' => date('Y-m-d H:i:s'),
                            'pxp_usu_crea' => $this->tank_auth->get_user_id(),
                            'pxp_usu_mod' => $this->tank_auth->get_user_id(),
                        );
                        $this->gsatelite->ingresar('pxp_parametro_paixplan', $temp_array_codigos);
                    }
                }*/
                if ($_POST['guardar'] == 1) {
                    $this->gsatelite->show_dialog('Registro ingresado exitosamente', "modulo_contratos/catalogos/editar_plan/" . $_POST['servicio'] . "/" . $_POST['pln_id'], 'success');
                } else {
                    $this->gsatelite->show_dialog('Registro ingresado exitosamente', "modulo_contratos/catalogos/planes/" . $_POST['servicio'], 'success');
                }
            } else {
                $this->gsatelite->show_dialog('No se pudo editar el registro', "modulo_contratos/catalogos/planes/" . $_POST['servicio'], 'error');
            }
        } else {
            $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
            $data['decimales']  = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;

            $plan = $this->gsatelite->get_tabla('pln_plan_promocion', array('pln_id' => $id_plan));
            $data['plan'] = $plan[0];
            $data['servicio'] = $servicio;
            $data['titulo_personal'] = "Edición de Planes/Promociones";
            $this->_cargarvista($data);
        }
    }

// End funcion editar_plan

    /**
        *@author: Francisco Orozco
        *Fecha: 06/11/2017 
        *Descripción: Muestra los clientes, el codigo esta centralizado en el controlador cotizaciones.
    */
    function clientes() {
        satelite_validar();

        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->clientes('no', 'modulo_contratos');
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 06/11/2017 
        *Descripción: Agrega clientes, el codigo esta centralizado en el controlador cotizaciones.
    */
    function nuevo_cliente() {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->nuevo_cliente(null, null, true);
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/nuevo_cliente', $info, true);
        $this->_cargarvista(null, $data);
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 06/11/2017 
        *Descripción: Edita los clientes, el codigo esta centralizado en el controlador cotizaciones.
    */
    function editar_cliente($id_cliente = null) {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->editar_cliente($id_cliente, null, true);
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/editar_cliente', $info, true);
        $this->_cargarvista(null, $data);
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 07/11/2017 
        *Descripción: Funcion para agregar servicio, centralizado en inventario.
    */
    function agregar_articulo() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $info = $this->mantenimiento->agregar_articulo(8, true, 'modulo_contratos/catalogos');
        $data['html'] = $this->load->view('inventario/mantenimiento/agregar_articulo', $info, true);
        $this->_cargarvista(null, $data);
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 07/11/2017 
        *Descripción: Funcion para editar servicio, centralizado en inventario.
    */
    function editar_articulo($id_art) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $info = $this->mantenimiento->editar_articulo($id_art, '8', 'modulo_contratos/catalogos');
        $data['html'] = $this->load->view('inventario/mantenimiento/editar_articulo', $info, true);
        $this->_cargarvista(null, $data);
    }

    /**
        *@author: Francisco Orozco
        *Fecha: 07/11/2017 
        *Descripción: Mantenimiento de cargos.
    */
    function cargos(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/catalogos/cargos');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->unset_add();
            $crud->unset_edit();

            $columns = array(
                'tcs_nombre',
                'tcs_valor',
                'tcs_estado'
            );

            $alias = array(
                'tcs_nombre'    => 'Nombre',
                'tcs_valor'     => 'Valor',
                'tcs_estado'    => 'Estado'
            );

            $add = array(
                'tcs_nombre',
                'tcs_valor',
                'tcs_estado',
                'tcs_usu_crea',
                'tcs_fecha_crea',
                'tcs_usu_mod',
                'tcs_fecha_mod'
            );

            $edit = array(
                'tcs_nombre',
                'tcs_valor',
                'tcs_estado',
                'tcs_usu_mod',
                'tcs_fecha_mod'
            );
            
            $crud->set_table('tcs_tipo_cargo_servicio')
                ->set_subject('Cargos adicionales')
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($edit)
                ->field_type('tcs_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tcs_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ;
            $crud->set_rules('tcs_nombre', 'Nombre', 'trim|required|campo_unico[tcs_tipo_cargo_servicio.tcs_nombre]');
            $crud->callback_column('tcs_valor', array($this, '_column_decimales'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tcs_estado', 'hidden', 1)
                    ->field_type('tcs_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tcs_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('tcs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if ($permisos['permite_agregar']) {
                $data['agregar'] = true;
            }

            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icomoon-icon-pencil-5', 'modulo_contratos/catalogos/editar_cargo');
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if ($permisos['permite_ver']) {
               //$crud->add_action('Ver', 'icomoon-icon-search-3', 'modulo_contratos/catalogos/ver_cargo');
            }


            $output = $crud->render();
            $data['titulo_personal'] = "Cargos adicionales";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function agregar_cargo(){
        satelite_validar();
        $unidad_defecto = $this->gsatelite->get_parametro('SYS_UNIDAD_MEDIDA');
        if ($_POST) {
          
            $categoria = $this->input->post('slccategoria');
            $nombre = $this->input->post('txt_nombre');
            $valor = $this->input->post('txt_costo');

            //obtener codigo de categoria
            $codigo_categoria = $this->gsatelite->get_campo('tia_tipo_articulo','tia_codigo',array('tia_id' => $categoria) );
            //contar cantidad articulos
            $cantidad = $this->gsatelite->count('art_articulo',array('art_id_tia' => $categoria) );
            $cantidad = $cantidad + 1;
            $cantidad = str_pad($cantidad, 5, "0", STR_PAD_LEFT); 

            $codigo = $codigo_categoria.$cantidad;

            $art_articulo = array(
                'art_id_tia'                => $categoria,
                'art_nombre'                => $nombre,
                'art_codigo'                => $codigo,
                'art_descripcion'           => $nombre,
                'art_fecha'                 => date('Y-m-d H:i:s'),
                'art_tipo'                  => 1,
                'art_combo'                 => 0,
                'art_compra'                => 0,
                'art_inventario'            => 0,
                'art_venta'                 => 1,
                'art_materia_prima'         => 0,
                'art_gasto'                 => 1,
                'art_costo'                 => $valor,
                'art_produccion'            => 0,
                'art_estado'                => 1,
                'art_usu_creacion'          => $this->tank_auth->get_user_id(),
                'art_fecha_creacion'        => date('Y-m-d H:i:s'),
                'art_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'art_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $art_id = $this->gsatelite->ingresar('art_articulo', $art_articulo);

            //Se agrega la conversion del articulo

            $conversion_array = array(
                'cva_id_mep' => $unidad_defecto,
                'cva_id_art' => $art_id,
                'cva_conversion' => 1,
                'cva_defecto' => 1,
                'cva_estado' => 1,
                'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cva_fecha_modificacion' => date('Y-m-d H:i:s'),
                'cva_usu_creacion' => $this->tank_auth->get_user_id(),
                'cva_fecha_creacion' => date('Y-m-d H:i:s'),
            );
            $this->gsatelite->ingresar('cva_conversion_articulo', $conversion_array);

            $tcs_tipo_cargo_servicio = array(
                'tcs_id_art'    => $art_id,
                'tcs_nombre'    => $nombre,
                'tcs_valor'     => $valor,
                'tcs_estado'    => 1,
                'tcs_usu_crea'  => $this->tank_auth->get_user_id(),
                'tcs_fecha_crea'=> date('Y-m-d H:i:s'),
                'tcs_usu_mod'   => $this->tank_auth->get_user_id(),
                'tcs_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->ingresar('tcs_tipo_cargo_servicio', $tcs_tipo_cargo_servicio);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cargo adicional", 'texto_alerta' => "Se agrego el cargo correctamente");
                
            $this->session->set_flashdata($alerta);

            $btnGuardar = $this->input->post('btnGuardar');
            
            if ($btnGuardar == 1) {
                redirect("modulo_contratos/catalogos/agregar_cargo");
            } else {
                redirect($ruta."modulo_contratos/catalogos/cargos");
            }

        } else {
            $existe_unidad  = $this->gsatelite->verificar_registro_real('mep_medida_producto', $unidad_defecto, true);
            if (!$existe_unidad) {
                $this->gsatelite->show_dialog('Verifique el valor del parámetro requerido', 'modulo_contratos/catalogos/cargos', 'error', 'Error en parámetro');
            }
            $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
            $data['decimales']  = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;
            $data['titulo_personal'] = "Agregar cargos adicional";
            $this->_cargarvista($data);
        }
        
    }

    function editar_cargo($tcs_id = null){
        satelite_validar();
        if ($_POST) {
            $categoria = $this->input->post('slccategoria');
            $nombre = $this->input->post('txt_nombre');
            $valor = $this->input->post('txt_costo');
            $estado = $this->input->post('slc_estado');
            $cargo = $this->input->post('txt_cargo');
            $codigo = "";
            
            $tcs_tipo_cargo_servicio = array(
                'tcs_nombre'    => $nombre,
                'tcs_valor'     => $valor,
                'tcs_estado'    => $estado,
                'tcs_usu_mod'   => $this->tank_auth->get_user_id(),
                'tcs_usu_mod'   => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('tcs_tipo_cargo_servicio',$tcs_tipo_cargo_servicio,array('tcs_id' => $cargo) );

            $art_id = $this->gsatelite->get_campo('tcs_tipo_cargo_servicio','tcs_id_art',array('tcs_id' => $cargo) );


            //obtener old codigo
            $art_articulo_old = $this->gsatelite->get_tabla('art_articulo',array('art_id' => $art_id) );


            if ( $categoria != $art_articulo_old[0]['art_codigo'] ) {
                //obtener codigo de categoria
                $codigo_categoria = $this->gsatelite->get_campo('tia_tipo_articulo','tia_codigo',array('tia_id' => $categoria) );
                //contar cantidad articulos
                $cantidad = $this->gsatelite->count('art_articulo',array('art_id_tia' => $categoria) );
                $cantidad = $cantidad + 1;
                $cantidad = str_pad($cantidad, 5, "0", STR_PAD_LEFT); 
                $codigo = $codigo_categoria.$cantidad;                
            }else {
                $codigo = $art_articulo_old[0]['art_codigo'];
            }

            //obtener codigo de categoria
            $codigo_categoria = $this->gsatelite->get_campo('tia_tipo_articulo','tia_codigo',array('tia_id' => $categoria) );
            //contar cantidad articulos
            $cantidad = $this->gsatelite->count('art_articulo',array('art_id_tia' => $categoria) );
            $cantidad = $cantidad + 1;
            $cantidad = str_pad($cantidad, 5, "0", STR_PAD_LEFT); 
          
            $art_articulo = array(
                'art_id_tia'                => $categoria,
                'art_nombre'                => $nombre,
                'art_codigo'                => $codigo,
                'art_descripcion'           => $nombre,
                'art_costo'                 => $valor,
                'art_estado'                => $estado,
                'art_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'art_fecha_modificacion'    => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('art_articulo',$art_articulo,array('art_id' => $art_id) );

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cargo adicional", 'texto_alerta' => "Se edito el cargo correctamente");
                
            $this->session->set_flashdata($alerta);

            $btnGuardar = $this->input->post('btnGuardar');
            
            if ($btnGuardar == 1) {
                redirect("modulo_contratos/catalogos/editar_cargo/".$cargo);
            } else {
                redirect("modulo_contratos/catalogos/cargos");
            }
           
        } else {
            $this->db->join('art_articulo','art_id = tcs_id_art');
            $this->db->join('tia_tipo_articulo','tia_id = art_id_tia');
            $data["cargos"] = $this->gsatelite->get_tabla('tcs_tipo_cargo_servicio',array('tcs_id' => $tcs_id ) );
            $decimales          = $this->gsatelite->get_tabla('par_parametro',array('par_codigo' => 'NUMERO_DECIMALES'));
            $data['decimales']  = ($decimales[0]['par_valor'] != "")? $decimales[0]['par_valor'] : $decimales[0]['par_default'] ;
            $data['titulo_personal'] = "Editar cargos adicional";
            $this->_cargarvista($data);
        }
    }

    function ver_cargo($tcs_id = null){
        satelite_validar();
        $this->db->join('art_articulo','art_id = tcs_id_art');
        $this->db->join('tia_tipo_articulo','tia_id = art_id_tia');
        $data["cargos"] = $this->gsatelite->get_tabla('tcs_tipo_cargo_servicio',array('tcs_id' => $tcs_id ) );
        $data['titulo_personal'] = "ver cargos adicional";
        $this->_cargarvista($data);
    }

    function verificar_cargo(){
        $nombre = $this->input->post('nombre');
        $cargo = ( $this->input->post('cargo') != "")? $this->input->post('cargo'):0;

        $cantidad_cargos = $this->gsatelite->get_tabla('tcs_tipo_cargo_servicio',array('tcs_id !='=> $cargo, "tcs_nombre" => $nombre) );

        echo json_encode($cantidad_cargos);

    }

    function periodo_contrato(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_contratos/catalogos/periodo_contrato');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();

            $columns = array(
                'pcn_nombre',
                'pcn_duracion',
                'pcn_estado'
            );

            $alias = array(
                'pcn_nombre'    => 'Nombre',
                'pcn_duracion'  => 'Duración',
                'pcn_estado'    => 'Estado'
            );

            $add = array(
                'pcn_nombre',
                'pcn_duracion',
                'pcn_estado',
                'pcn_fecha_crea',
                'pcn_fecha_mod',
                'pcn_usu_crea',
                'pcn_usu_mod'
            );

            $edit = array(
                'pcn_nombre',
                'pcn_duracion',
                'pcn_estado',
                'pcn_fecha_mod',
                'pcn_usu_mod'
            );
            
            $crud->set_table('pcn_periodo_contrato')
                ->set_subject('Período de contrato')
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($edit)
                ->field_type('pcn_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('pcn_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ;
            $crud->set_rules('pcn_nombre', 'Nombre', 'trim|required|campo_unico[pcn_periodo_contrato.pcn_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pcn_estado', 'hidden', 1)
                    ->field_type('pcn_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('pcn_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('pcn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
              $crud->unset_add();
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_add();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if ($permisos['permite_ver']) {
               $crud->add_action('Ver', 'icomoon-icon-search-3', 'modulo_contratos/catalogos/periodo_contrato/read');
            }


            $output = $crud->render();
            $data['titulo_personal'] = "Período de contratos";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

}
