<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reportes extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('contabilidad_model');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Contabilidad';
            $this->_cargarvista();
        }
    }

    function listado_partida()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            ini_set('memory_limit', '2048M');
            ini_set('max_execution_time', '9999');
            $this->db->where('pct_id', 0);
            $this->db->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd');
            $data['id_ptd'] = $this->gsatelite->get_tabla('pct_partida_contable');
            $tipo = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre} ', '', null, null, '', 'tpd_id', true);
            $data["tipo"] = str_replace('<option value="0">Seleccione</option>', '', $tipo);
            $data["titulo_personal"] = "Listado de partidas";
            $this->_cargarvista($data);
        }
    }

    public function lista_partidas_defecto($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            ini_set('memory_limit', '2048M');
            ini_set('max_execution_time', '9999');
            $tipo = $this->input->post('tipo');
            $tipo_rep = $this->input->post('tipo_rep');
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $proceso_partida = $this->input->post('proceso_partida');
            $cta_def = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_total = array();
            $array_resultante = array();
            if ($proceso_partida != "") {
                $proceso_partida = explode(',', $proceso_partida);
            }
            if (is_array($proceso_partida)) {
                for ($i = 0; $i < count($proceso_partida); $i++) {
                    if ($tipo > 0) {
                        $this->db->where('pct_id_tpd', $tipo);
                    }
                    $this->db->join('tpd_tipo_partida', 'tpd_id = pct_id_tpd', 'LEFT');
                    $array_total = $this->contabilidad_model->get_datos_partida(formatear_fecha('Y-m-d', $fecha_ini), formatear_fecha('Y-m-d', $fecha_fin), $proceso_partida[$i]);
                    if ($i == 0) {
                        $array_resultante = $array_total;
                    } else {
                        $array_resultante = array_merge_recursive($array_resultante, $array_total);
                    }
                }
            } else {
                if ($tipo > 0) {
                    $where['tpd_id'] = $tipo;
                }
                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['DATE(pct_fecha) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
                    $where['DATE(pct_fecha) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
                }
                $this->db->where($where);
                $this->db->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd', 'LEFT');
                $array_resultante = $this->gsatelite->get_tabla('pct_partida_contable');
            }
            $total_debe = $total_haber = $ptdas = 0;
            $cadena = '';
            if (count($array_resultante) > 0) {
                foreach ($array_resultante as $k => $v) {
                    $detxpartida = $this->contabilidad_model->listado_partida(array('pct_id' => $v['pct_id']), 1);
                    $cuentas = array_column($detxpartida, 'cnt_id');
                    if (in_array($cta_def, $cuentas)) {
                        $cadena .= '<tr><td colspan="4"><span style="margin-left:2%"><b>' . $v['tpd_nombre'] . " #: " . $v['pct_codigo'] . '</b></span>';
                        $cadena .= '<span style="margin-left:20%"><b>' . formatear_fecha('d-m-Y', $v['pct_fecha']) . '</b></span></td>';
                        $cadena .= '<td colspan="4"><span style="margin-left:3%">Concepto: ' . $v['pct_concepto'] . '</span></td></tr>';
                        $cadena .= '<tr><th colspan="2" style="border:1px solid #000; border-right:none;">Cuenta</th>';
                        $cadena .= '<th colspan="4" style="border:1px solid #000; border-left: none; border-right: none;">Concepto</th>';
                        $cadena .= '<th colspan="1" style="border:1px solid #000; border-left:none; border-right:none;">Debe ($)</th>';
                        $cadena .= '<th colspan="1" style="border: 1px solid #000; border-left: none;">Haber ($)</th></tr>';
                        foreach ($detxpartida as $key => $deta) {
                            $cadena .= '<tr><td colspan="2" style="border: none; font-weight: bold;" class="text">' . $deta['cnt_cuenta'] . '</td>';
                            $cadena .= '<td colspan="4" style="border:none;font-weight:bold;">' . $deta['cnt_nombre'] . '</td>';
                            $cadena .= '<td colspan="1" style="text-align:right; border: none;">' . number_format($deta['debe'], 2) . '</td>';
                            $cadena .= '<td colspan="1" style="text-align:right; border: none;">' . number_format($deta['haber'], 2) . '</td></tr>';
                            $total_debe += $deta['debe'];
                            $total_haber += $deta['haber'];
                        }
                        $cadena .= '<tr><td colspan="6" style="text-align:right; border: none;"><strong>Totales:</strong></td>';
                        $cadena .= '<td colspan="1" style="text-align:right; border: none; border-top:1px solid #000;"><strong>' . $v['pct_total'] . '</strong></td>';
                        $cadena .= '<td colspan="1" style="text-align:right; border: none; border-top:1px solid #000;"><strong>' . $v['pct_total'] . '</strong></td></tr>';
                        $cadena .= '<tr><td colspan="8" style="border: none;"></td></tr>';
                        if ($tipo_rep == 'pdf') {
                            $cadena .= '<tr><td colspan="8" style="border: none;"><hr></td></tr>';
                        }
                        $ptdas++;
                    }
                }
                if ($ptdas == 0) {
                    $cadena .= '<tr><td style="text-align:center"><b>No se encontraron resultados</b></td></tr>';
                }
            } else {
                $cadena .= '<tr><td style="text-align:center"><b>No se encontraron resultados</b></td></tr>';
            }
            if ($flag) {
                echo json_encode(array('filas' => $ptdas, 'tabla' => $cadena));
            } else {
                if ($tipo_rep == 'excel') {
                    $exc_head = '<meta charset="utf-8"/><div class="head"><table><tr><td align="center" colspan="7" ><h4>' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                    $exc_head .= '<br />Reporte de Partidas con Cuentas por Defecto</h4></td></tr></table></div>';
                    $theader = '<style type="text/css">.text{ mso-number-format:"\@";}</style><table class="responsive table table-bordered" style="width: 100%;"><tbody id="datagried">';
                    $tfooter = '</tbody></table>';
                    $reporte = $exc_head . $theader . $cadena . $tfooter;
                    header("Content-Type: application/vnd.ms-excel");
                    header("Expires: 0");
                    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                    header("content-disposition: attachment;filename=Partidas_por_defecto.xls");
                    echo $reporte;
                } else {
                    $titulos = array(
                        'titulo' => "Listado de partidas con cuentas por defecto",
                        'solotitulo' => true,
                        'subtitulo' => "Valores expresados en Dolares de los Estados Unidos. De " . $fecha_ini . " A " . $fecha_fin
                    );
                    $headder = $this->load->view('reporte/header_reportes_conta', $titulos, true);
                    $theader = '<table class="responsive table table-bordered" style="width: 100%;"><tbody id="datagried">';
                    $tfooter = '</tbody></table>';
                    $this->pdf->SetPrintFooter(false);
                    $reporte = $headder . $theader . $cadena . $tfooter;
                    $this->pdf->makePDF($reporte, "P", 'Partidas Defecto', 'Letter');
                }
            }
        } else {
            $tipo = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre} ', '', null, null, '', 'tpd_id', true);
            $data["tipo"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $tipo);
            $data["titulo_personal"] = "Listado de Partidas por Defecto";
            $this->_cargarvista($data);
        }
    }

    function consultar_listado_partidas()
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $tipo = ($this->input->post('tipo') != "") ? $this->input->post('tipo') : 0;
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $proceso_partida = $this->input->post('proceso_partida');
        $where = null;
        $array_total = array();
        $array_resultante = array();
        if ($fecha_ini != '' && $fecha_fin != '') {
            $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
            $fecha_fn = date('Y-m-d', strtotime($fecha_fin));
            $where = array('date_format(pct_fecha, "%Y-%m-%d") >=' => $fecha_inicio, 'date_format(pct_fecha, "%Y-%m-%d") <=' => $fecha_fn);
        }
        if ($tipo > 0) {
            $where['tpd_id'] = $tipo;
        }
        if ($fecha_ini == '' && $fecha_fin == '' && $tipo == '') {
            $where = null;
        }
        if (is_array($proceso_partida)) {
            for ($i = 0; $i < count($proceso_partida); $i++) {
                if ($tipo > 0) {
                    $this->db->where('pct_id_tpd', $tipo);
                }
                $this->db->join('tpd_tipo_partida', 'tpd_id = pct_id_tpd', 'LEFT');
                $array_total = $this->contabilidad_model->get_datos_partida(formatear_fecha('Y-m-d', $fecha_ini), formatear_fecha('Y-m-d', $fecha_fin), $proceso_partida[$i]);
                if ($i == 0) {
                    $array_resultante = $array_total;
                } else {
                    $array_resultante = array_merge_recursive($array_resultante, $array_total);
                }
            }
        }
        //$data['query'] = $this->contabilidad_model->get_datos_partida($desde, $hasta, $proceso_partida[0]);
        if (!(is_array($proceso_partida))) {
            $this->db->where($where);
            $this->db->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd', 'LEFT');
            $array_resultante = $this->gsatelite->get_tabla('pct_partida_contable');
        }
        //$this->db->limit(1);
        //$detalles = $this->contabilidad_model->listado_partida($where);
        $partidas = $array_resultante;
        $cadena = '';
        $total_debe = $total_haber = 0;
        if (!empty($partidas)) {
            foreach ($partidas as $key) {
                $cadena .= '<tr>
				                <td colspan="3">
                                    <span style="margin-left:2%"><strong>' . $key['tpd_nombre'] . " #: " . $key['pct_codigo'] . '</strong></span> 
				                	<span style="margin-left:20%"><strong>' . date('d-m-Y', strtotime($key['pct_fecha'])) . '</strong></span>
				                </td>
                                <td><span style="margin-left:3%">Concepto: ' . $key['pct_concepto'] . '</span></td>
				            </tr>';
                $cadena .= '<tr >
                                <th style="border: 1px solid #000; border-right: none;">Cuenta</th>
                                <th style="border: 1px solid #000; border-left: none; border-right: none;">Concepto</th>' .
                    // <th style="border: 1px solid #000; border-left: none; border-right: none;">Parciales</th>
                    '<th style="border: 1px solid #000; border-left: none; border-right: none;">Debe ($)</th>
                                <th style="border: 1px solid #000; border-left: none;">Haber ($)</th>
                            </tr>';
                /*                 * ********************************** CUENTAS PADRE ******************************************* */
                $detxpartida = $this->contabilidad_model->listado_partida(array('pct_id' => $key['pct_id']), 1);
                foreach ($detxpartida as $deta) {
                    $cadena .= '<tr>
						            <td style="border: none;font-weight:bold;">' . $deta['cnt_cuenta'] . '</td>
                                    <td style="border: none;font-weight:bold;">' . $deta['cnt_nombre'] . '</td>' .
                        // <td style="text-align:right; border: none;"></td>
                        '<td style="text-align:right; border: none;">' . $deta['debe'] . '</td>
                                    <td style="text-align:right; border: none;">' . $deta['haber'] . '</td>
                                </tr>';
                    $total_debe += $deta['debe'];
                    $total_haber += $deta['haber'];
                    // $cadena .= $this->get_detalles_parcial($key['pct_id'], $deta['cnt_cuenta']);
                }
                /*                 * *********************************************************************************************** */
                //ESTABA COMENTADO Y SE DESCOMENTO
                $cadena .= '<tr>
                                <td colspan="2" style="text-align:right; border: none;"><strong>Totales:</strong></td>
	                            <td style="text-align:right; border: none; border-top:1px solid #000;"><strong>' . $key['pct_total'] . '</strong></td>
	                            <td style="text-align:right;  border: none; border-top:1px solid #000;"><strong>' . $key['pct_total'] . '</strong></td>
	                       </tr>';
                $cadena .= '<tr><td colspan="4" style="border: none;"></td></tr>';
                // <tr><td colspan="4" style="border: none;"><span><strong>Concepto:</strong></span><br></td></tr>';
            }
            $cadena .= '<tr>
                            <td colspan="2" style="text-align:right; border: none;"><b>Total General:</b></td>
                            <td style="text-align:right; border: none; border-top:1px solid #000;"><b>' . number_format($total_debe, 2, '.', '') . '</b></td>
                            <td style="text-align:right; border: none; border-top:1px solid #000;"><b>' . number_format($total_haber, 2, '.', '') . '</b></td>
                        </tr>';
        } else {
            $cadena .= '<tr>
            				<td colspan="4" style="text-align:center"> No se encontraron resultados</td>
            			</tr>';
        }
        echo json_encode($cadena);
    }


    function reporte_listado_partidas($id_partida = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                ini_set('memory_limit', '2048M');
                ini_set('max_execution_time', '9999');
                $tipo = ($this->input->post('tipo') != "") ? $this->input->post('tipo') : 0;
                $fecha_ini = $this->input->post('fecha_inicio');
                $fecha_fin = $this->input->post('fecha_fin');
                $proceso_partida = $this->input->post('proceso_partida');
                $where = null;
                if ($fecha_ini != '' && $fecha_fin != '') {
                    $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
                    $fecha_fn = date('Y-m-d', strtotime($fecha_fin));
                    $where = array('date_format(pct_fecha, "%Y-%m-%d") >=' => $fecha_inicio, 'date_format(pct_fecha, "%Y-%m-%d") <=' => $fecha_fn);
                }
                if ($tipo > 0) {
                    $where['tpd_id'] = $tipo;
                }
                $array_total = array();
                $array_resultante = array();
                if (is_array($proceso_partida)) {
                    for ($i = 0; $i < count($proceso_partida); $i++) {
                        if ($tipo > 0) {
                            $this->db->where('pct_id_tpd', $tipo);
                        }
                        $this->db->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd', 'LEFT');
                        $array_total = $this->contabilidad_model->get_datos_partida(formatear_fecha('Y-m-d', $fecha_ini), formatear_fecha('Y-m-d', $fecha_fin), $proceso_partida[$i]);
                        if ($i == 0) {
                            $array_resultante = $array_total;
                        } else {
                            $array_resultante = array_merge_recursive($array_resultante, $array_total);
                        }
                    }
                }
                //$data['query'] = $this->contabilidad_model->get_datos_partida($desde, $hasta, $proceso_partida[0]);
                if (!(is_array($proceso_partida))) {
                    $this->db->where($where);
                    $this->db->join('tpd_tipo_partida', 'tpd_id=pct_id_tpd', 'LEFT');
                    $array_resultante = $this->gsatelite->get_tabla('pct_partida_contable');
                }
                //$this->db->limit(1);
                //$detalles = $this->contabilidad_model->listado_partida($where);
                $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
                $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
                $partidas = $array_resultante;
                $cadena = '';
                if (/*!empty($detalles) &&*/!empty($partidas)) {
                    $a = count($partidas);
                    $i = 0;
                    $total_debe = 0;
                    $total_haber = 0;
                    foreach ($partidas as $key) {
                        $i++;
                        $res = str_pad($i, '6', '0', STR_PAD_LEFT);
                        if ($this->input->post('tipo_reporte') == 'excel') {
                            $cabecera = "<hr />
                                    <table border='0'>
                                        <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                                        <tr><th colspan='4' align='right' >Pag. No " . $res . "</th></tr>
                                        <tr><th colspan='4' align='center' >Listado de Partidas</th></tr>
                                        <tr><th colspan='4' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
                                    </table>";
                        } else {
                            $cabecera = $this->load->view('reporte/header_reportes_conta', array('titulo' => "Listado de partidas", 'solotitulo' => true, 'subtitulo' => "Valores expresados en Dolares de los Estados Unidos", 'num' => $res, 'propietario' => $propietario), true);
                        }
                        // $cadena .= $cabecera;
                        $cadena .= '<table class="tabla" cellpadding="2">';
                        $cadena .=      '<thead >';
                        $cadena .=          '<tr cellpadding="0">
					                           <td style="text-align:left;width:20%;"><strong>' . $key['tpd_nombre'] . " #: " . $key['pct_codigo'] . '</strong></td>
					                           <td style="text-align:right;width:20%;"><strong>' . date('d-m-Y', strtotime($key['pct_fecha'])) . '</strong></td>
                                               <td></td>
                                               <td><span style="margin-left:3%">Concepto: ' . $key['pct_concepto'] . '</span></td>
					                       </tr>';
                        $cadena .=          '<tr>
                                                <th class="head" style="width:25%">Cuenta</th>
                                                <th class="head" style="width:25%">Concepto</th>' .
                            // <th class="head" style="width:20%">Parcial ($)</th>
                            '<th class="head" style="width:25%">Debe ($)</th>
                                                <th class="head" style="width:25%">Haber ($)</th>
                            	           </tr>';
                        $cadena .= '</thead>';
                        /*                         * ********************************** CUENTAS PADRE ******************************************* */
                        $detxpartida = $this->contabilidad_model->listado_partida(array('pct_id' => $key['pct_id']), 1);
                        foreach ($detxpartida as $deta) {
                            $cadena .= '<tr>
                                            <td style="border: none;font-weight:bold;">' . $deta['cnt_cuenta'] . '</td>
                                            <td style="border: none;font-weight:bold;">' . $deta['cnt_nombre'] . '</td>' .
                                // <td style="text-align:right; border: none;"></td>
                                '<td style="text-align:right; border: none;">' . number_format($deta['debe'], 2, '.', ',') . '</td>
						                    <td style="text-align:right; border: none;">' . number_format($deta['haber'], 2, '.', ',') . '</td>
                                        </tr>';
                            $total_debe += $deta['debe'];
                            $total_haber += $deta['haber'];
                            // $cadena .= $this->get_detalles_parcial($key['pct_id'], $deta['cnt_cuenta']);
                        }
                        $cadena .= '<tr style="border-top: solid 1px black;">
                                <td colspan="2" style="text-align: right; border: none;"><b>Totales:</b></td>
                                <td style="text-align:right;"><b>' . $key['pct_total'] . '</b></td>
                                <td style="text-align:right;"><b>' . $key['pct_total'] . '</b></td>
                           </tr>';
                        $cadena .= '<tr><td colspan="4" style="border: none;"></td></tr>';
                        /*                         * *********************************************************************************************** */
                        // 	foreach ($detalles as $det ) {  
                        // 		if($key['pct_id']==$det['pct_id']){               
                        // $cadena.='<tr>
                        //           <td style="width:20%;text-align:left;">'.$det['cnt_cuenta'].'</td>
                        //           <td colspan="2" style="width:40%;text-align:left;">'.$det['dpc_concepto'].'</td>
                        //           <td style="width:20%;text-align:right;">'.$det['dpc_debe'].'</td>
                        //           <td style="width:20%;text-align:right;">'.$det['dpc_haber'].'</td>
                        //         </tr>';
                        //   }
                        // 	}
                        if ($a != $i) {
                            $cadena .= '<br style="page-break-after: always;"/>';
                        }
                    }
                    $cadena .= '<tr>
                                    <td colspan="2" style="text-align:right;"><b>Total General:</b></td>
                                    <td class="total"><b>' . $total_debe . '</b></td>
                                    <td class="total"><b>' . $total_haber . '</b></td>
                              </tr>' .
                        // <tr>
                        //   <td colspan="4" style="text-align:left;">
                        //       <span><strong>Concepto:</strong></span><br>
                        //       <span style="margin-left:3%">' . $key['pct_concepto'] . '</span>
                        //   </td>
                        // </tr>
                        '<tr>
                                <td style="height:40px;"></td>
                              </tr>
                              <tr>
                                <td style="width:25%;text-align:center;border-top-style:solid;">
                                    Hecho por<br><br>
                                </td>
                                <td style="width:8%;">
                                </td>
                                <td style="width:25%;text-align:center;border-top-style:solid;">
                                    Revisado<br><br>
                                </td>
                                <td style="width:8%;">
                                </td>
                                <td style="width:25%;text-align:center;border-top-style:solid;">
                                    Autorizado por<br><br>
                                </td>
                                <td style="width:8%;">
                                </td>
                              </tr>
                              ';
                    $cadena .= '</table>';
                } else {
                    $cadena .= '<table>';
                    $cadena .=      '<tr>
	            				       <td colspan="4" style="text-align:center"> No se encontraron resultados</td>
	            			        </tr>';
                }
                $cadena .= '</table>';

                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                $data['table_header'] = (isset($rows)) ? $rows : null;
                $data['table_tbody'] = $cadena;
                $data['tabla_info'] = (isset($tabla_info)) ? $tabla_info : null;
                $data['filename'] = $filename;

                if ($this->input->post('tipo_reporte') == 'excel') {
                    $html = $this->load->view('modulo_contabilidad/reportes/reporte_partidas_pdf.php', $data, true);
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=listado_partida_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo $html;
                    die();
                }

                $this->pdf->SetPrintFooter(false);
                $this->pdf->reportePDF('modulo_contabilidad/reportes/reporte_partidas_pdf.php', $data, "Listado de Partidas", "P");
            } else {
                $where = null;

                $where = array('pct_id' => $id_partida);
                $detalles = $this->contabilidad_model->listado_partida($where);
                $partidas = $this->gsatelite->get_tabla('pct_partida_contable', array('pct_id' => $id_partida));

                $cadena = '';
                if (!empty($detalles) && !empty($partidas)) {
                    $i = 0;
                    foreach ($partidas as $key) {
                        $i++;

                        $res = str_pad($i, '6', '0', STR_PAD_LEFT);
                        if ($this->input->post('tipo_reporte') == 'excel') {
                            $cabecera = "<hr /><table border='0'>
                                  <tr><th colspan='5' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                                  <tr><th colspan='5' align='right' >Pag. No " . $res . "</th></tr>
                                  <tr><th colspan='5' align='center' >Listado de Partidas</th></tr>
                                  <tr><th colspan='5' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
                                  </table>";
                        } else {
                            $cabecera = $this->load->view('reporte/header_reportes_conta', array('titulo' => "Listado de partidas", 'solotitulo' => true, 'subtitulo' => "Valores expresados en Dolares de los Estados Unidos", 'num' => $res), true);
                        }


                        $cadena .= $cabecera;

                        //$cadena .= 

                        $cadena .= '<table class="tabla" cellpadding="2">';
                        $cadena .= '<thead >
                            
                           </thead>';
                        $cadena .= '<tr cellpadding="0">
					                <td style="text-align:left;width:20%;"><strong>' . $key['tpd_nombre'] . " #: " . $key['pct_codigo'] . '</strong>
					                </td>
					                <td style="text-align:right;width:20%;"><strong>' . date('d-m-Y', strtotime($key['pct_fecha'])) . '</strong>
					                </td>
					              </tr>';
                        $cadena .= '<tr>
                                <th class="head" style="width:20%">Cuenta</th>
                                <th class="head" style="width:20%">Concepto</th>
                                <th class="head" style="width:20%"></th>
                                <th class="head" style="width:20%">Debe ($)</th>
                                <th class="head" style="width:20%">Haber ($)</th>
                            	</tr>';
                        foreach ($detalles as $det) {
                            if ($key['pct_id'] == $det['pct_id']) {
                                $cadena .= '<tr>
			                        <td style="width:20%;text-align:left;">' . $det['cnt_cuenta'] . '-' . $det['cnt_nombre'] . '</td>
			                        <td colspan="2" style="width:40%;text-align:left;">' . $det['dpc_concepto'] . '</td>
			                        <td style="width:20%;text-align:right;">' . $det['dpc_debe'] . '</td>
			                        <td style="width:20%;text-align:right;">' . $det['dpc_haber'] . '</td>
			                      </tr>';
                            }
                        }

                        $cadena .= '<tr>
	                            <td colspan="3" style="text-align:right;"><strong>Totales:</strong></td>
	                            <td class="total"><strong>' . $key['pct_total'] . '</strong></td>
	                            <td class="total"><strong>' . $key['pct_total'] . '</strong></td>
	                          </tr>
	                          <tr>
	                            <td colspan="4" style="text-align:left;">
	                                <span><strong>Concepto:</strong></span><br>
	                                <span style="margin-left:3%">' . $key['pct_concepto'] . '</span>
	                            </td>
	                          </tr>
	                          <tr>
	                          	<td style="height:30px;"></td>
	                          </tr>
	                          <tr>
	                          	<td style="width:25%;text-align:center;border-top-style:solid;">
	                          		Hecho por<br><br>
	                          	</td>
	                          	<td style="width:8%;">
	                          	</td>
	                          	<td style="width:25%;text-align:center;border-top-style:solid;">
	                          		Revisado<br><br>
	                          	</td>
	                          	<td style="width:8%;">
	                          	</td>
	                          	<td style="width:25%;text-align:center;border-top-style:solid;">
	                          		Autorizado por<br><br>
	                          	</td>
	                          	<td style="width:8%;">
	                          	</td>
	                          </tr>
	                          ';
                        $cadena .= '</table>';
                    }
                } else {
                    $cadena .= '<table>';
                    $cadena .= '<tr>
	            				<td colspan="4" style="text-align:center"> No se encontraron resultados</td>
	            			  </tr>';
                }

                $cadena .= '</table>';
                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                $data['table_header'] = $rows;
                $data['table_tbody'] = $cadena;
                $data['tabla_info'] = $tabla_info;
                $data['filename'] = $filename;

                if ($this->input->post('tipo_reporte') == 'excel') {
                    $html = $this->load->view('modulo_contabilidad/reportes/reporte_partidas_pdf.php', $data, true);
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=Listado_partidas_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                      <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='6' align='center' >Listado de Partidas</th></tr>
                      <tr><th colspan='6' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
                      </table>";

                    echo $html;
                    die();
                }
                $this->pdf->SetPrintFooter(false);
                $this->pdf->reportePDF('modulo_contabilidad/reportes/reporte_partidas_pdf.php', $data);
            }
        }
    }

    function movimiento_cuenta() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $dropdown = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre} ', array('cnt_estado' => 1), null, null, '', 'cnt_id', true);
            $data['cuentas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dropdown);
            $data["titulo_personal"] = "Movimiento de cuentas";
            $this->_cargarvista($data);
        }
    }

    function consultar_movimiento_cuentas() {
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        $numero_decimales_format = 2; //para cálculos
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $cuenta = $this->input->post('cuenta');
        $registro_cuenta = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta));
        $where = null;
        $where['pct_estado'] = 1;
        if ($fecha_ini != '' && $fecha_fin != '') {
            $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
            $fecha_fn = date('Y-m-d', strtotime($fecha_fin));
            //  $where = array('date_format(pct_fecha, "%Y-%m-%d") >=' => $fecha_inicio, 'date_format(pct_fecha, "%Y-%m-%d") <=' => $fecha_fn);
            $where['DATE(pct_fecha) >='] = $fecha_inicio;
            $where['DATE(pct_fecha) <='] = $fecha_fn;
        }
        if ($cuenta > 0) {
            $where['cnt_id'] = $cuenta;
        }
        if ($fecha_ini == '' && $fecha_fin == '' && $cuenta == '') {
            $where = null;
        }
        //$movimientos = $this->contabilidad_model->listado_partida($where);
        $ids_cnt_hijos = $this->contabilidad_model->get_ids_cuentas_hijas($cuenta);
        $ids_cnt_hijos = (trim($ids_cnt_hijos) != "") ? trim($ids_cnt_hijos, ',') : 0;
        unset($where['cnt_id']);
        $where["dpc_id_cnt IN ($ids_cnt_hijos,$cuenta)"] = null;

        $this->db->group_by('dpc_id');
        $this->db->order_by('pct_fecha', 'ASC');
        $this->db->order_by('dpc_debe', 'DESC');
        $this->db->order_by('cnt_cuenta', 'DESC');
        $movimientos = $this->contabilidad_model->get_saldo_anterior_cuenta($where, 1, 1);
        $cadena = '';
        if (!empty($movimientos)) {
            $where = array();
            $where['pct_estado'] = 1;
            $where['DATE(pct_fecha) <'] = $fecha_inicio; // Saldo anterior a la fecha filtrada
            // $where['cnt_id'] = $cuenta;
            //$saldo = $this->contabilidad_model->get_saldo_anterior($where);
            $num_cuenta = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_cuenta', array('cnt_id' => $cuenta));
            $cuenta_aumenta = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_aumenta', array('cnt_id' => $cuenta));
            //$movimientos_ant = $this->contabilidad_model->listado_partida($where);
            $where["dpc_id_cnt in ($ids_cnt_hijos,$cuenta)"] = null;
            $movimientos_ant_new = $this->contabilidad_model->get_saldo_anterior_cuenta($where);
            $debe_ant =  number_format($movimientos_ant_new['monto_debe'], 2, '.', ''); //(count($movimientos_ant) > 0)? array_sum(array_column($movimientos_ant, 'debe')):0;////////////////////
            $haber_ant = number_format($movimientos_ant_new['monto_haber'], 2, '.', ''); //(count($movimientos_ant) > 0)? array_sum(array_column($movimientos_ant, 'haber')):0;//////////////////
            $saldo_ant = ($cuenta_aumenta == 'D') ? ($debe_ant - $haber_ant) : ($haber_ant - $debe_ant);
            // bcdiv($saldo_ant, '1', 2)
            $info = '<thead>';
            $info .= '<tr>
		                    <th class="inf" style="border-bottom: solid black;" ><b>Cuenta:</b></th>
		                    <td style="border-bottom: solid black;">' . $registro_cuenta[0]['cnt_cuenta'] . '</td>
		                    <td style="border-bottom: solid black;">' . $registro_cuenta[0]['cnt_nombre'] . '</td>
		                    <th style="border-bottom: solid black; text-align: right;"><b>Saldo anterior $</b></th>
		                    <td style="border-bottom: solid black; text-align: right;">' . number_format($saldo_ant, 2) . '</td>
		                </tr>';
            $info .= '</thead>';

            $saldo_afectado = $saldo_ant;
            $suma_debe = 0;
            $suma_haber = 0;
            foreach ($movimientos as $mov) {
                $debe = floatval($mov['dpc_debe']);
                $haber = floatval($mov['dpc_haber']);
                $saldo_actual = ($cuenta_aumenta == 'D') ? ($debe - $haber) : ($haber - $debe);

                $suma_debe += $debe;
                $suma_haber += $haber;
                // $saldo_afectado = bcadd($saldo_afectado, $saldo_actual, 2);
                $saldo_afectado = number_format(($saldo_afectado+$saldo_actual), 2, '.','');

                $fecha = date('d-m-Y', strtotime($mov['pct_fecha']));
                $codigo_partida = ($mov['pct_codigo'] == "") ? str_replace('-', '', $mov['codigo_dependiente']) : $mov['pct_codigo'] . $mov['codigo_dependiente'];

                $cadena .= '<tr>
                                <td>' . $fecha . '</td>
                                <td>' . $codigo_partida . '</td>
                                <td style="text-align:left;">' . $mov['pct_concepto'] . '</td>
                                <td style="text-align:left;">' . $mov['dpc_descripcion'] . '</td>
                                <td style="text-align:right;">' . (($debe != 0) ? number_format($debe, 2) : '') . '</td>
                                <td style="text-align:right;">' . (($haber != 0) ? number_format($haber, 2) : '') . '</td>
                                <td style="text-align:right;">' . number_format($saldo_afectado, 2) . '</td>
                            </tr>';
            }

            $cadena .= '<tr>
	                            <td colspan="4" style="text-align:right;"><b>Totales:</b></td>
	                            <td style="text-align:right;"><b>' . number_format($suma_debe, 2) . '</b></td>
	                            <td style="text-align:right;"><b>' . number_format($suma_haber, 2) . '</b></td>
	                            <td style="text-align:right;"><b>' . number_format($saldo_afectado, 2) . '</b></td>
	                          </tr>';
        } else {
            $cadena .= '<tr><td colspan="7" style="text-align:center"> No se encontraron resultados</td></tr>';
        }
        echo json_encode(array('head' => $info, 'tbody' => $cadena));
    }

    function reporte_movimiento_cuentas($es_excel = 0) {
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $fecha_ini = $this->input->post('fecha_inicio');
                $fecha_fin = $this->input->post('fecha_fin');
                $cuenta = $this->input->post('cuenta');
                $registro_cuenta = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta));
                $where = null;
                $where['pct_estado'] = 1;
                if ($fecha_ini != '' && $fecha_fin != '') {
                    $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
                    $fecha_fn = date('Y-m-d', strtotime($fecha_fin));
                    $where['DATE(pct_fecha) >='] = $fecha_inicio;
                    $where['DATE(pct_fecha) <='] = $fecha_fn;
                }
                if ($cuenta > 0) {
                    $where['cnt_id'] = $cuenta;
                }
                if ($fecha_ini == '' && $fecha_fin == '' && $cuenta == '') {
                    $where = null;
                }
                $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
                $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
                //$movimientos = $this->contabilidad_model->listado_partida($where);
                //print_r($this->db->last_query());die();

                $ids_cnt_hijos = $this->contabilidad_model->get_ids_cuentas_hijas($cuenta);
                $ids_cnt_hijos = (trim($ids_cnt_hijos) != "") ? trim($ids_cnt_hijos, ',') : 0;
                unset($where['cnt_id']);
                $where["dpc_id_cnt in ($ids_cnt_hijos,$cuenta)"] = null;

                $this->db->group_by('dpc_id');
                $this->db->order_by('pct_fecha', 'ASC');
                $this->db->order_by('dpc_debe', 'DESC');
                $this->db->order_by('cnt_cuenta', 'DESC');
                $movimientos = $this->contabilidad_model->get_saldo_anterior_cuenta($where, 1, 1);

                $rows = $this->load->view('reporte/header_reportes_conta', array('titulo' => "MOVIMIENTO DE CUENTAS CONTABLES <br> DEL " . $fecha_ini . " AL " . $fecha_fin . "", 'solotitulo' => true,  'subtitulo' => 'Valores expresados en D&oacute;lares de los Estados Unidos', 'propietario' => $propietario), true);

                $cadena = '';

                $cadena .= '<table class="tabla" cellpadding="2" border="1">';
                $cadena .= '<thead >
                            <tr>
                                <th class="head" style="width:9%;border-top-style: solid;border-left-style: solid;">Fecha</th>
                                <th class="head" style="width:9%;border-top-style: solid;">Partida</th>
                                <th class="head" style="width:22%;border-top-style: solid;">Concepto</th>
                                <th class="head" style="width:17%;border-top-style: solid;">Descripción</th>
                                <th class="head" style="width:14%;border-top-style: solid;">Debe ($)</th>
                                <th class="head" style="width:14%;border-top-style: solid;">Haber ($)</th>
                                <th class="head" style="width:15%;border-top-style: solid;border-right-style: solid;">Saldo Actual</th>
                            </tr>
                           </thead>';
                if (!empty($movimientos)) {
                    $where = array();
                    $where['pct_estado'] = 1;
                    $where['DATE(pct_fecha) <'] = $fecha_inicio; // Saldo anterior a la fecha filtrada
                    $num_cuenta = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_cuenta', array('cnt_id' => $cuenta));
                    $cuenta_aumenta = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_aumenta', array('cnt_id' => $cuenta));
                    //$movimientos_ant = $this->contabilidad_model->listado_partida($where);
                    $where["dpc_id_cnt in ($ids_cnt_hijos,$cuenta)"] = null;
                    $movimientos_ant_new = $this->contabilidad_model->get_saldo_anterior_cuenta($where);
                    //print_r($this->db->last_query());die();
                    $debe_ant =  $movimientos_ant_new['monto_debe']; //(count($movimientos_ant) > 0)? array_sum(array_column($movimientos_ant, 'debe')):0;
                    $haber_ant = $movimientos_ant_new['monto_haber']; //(count($movimientos_ant) > 0)? array_sum(array_column($movimientos_ant, 'haber')):0;

                    $saldo_ant = 0;
                    $saldo_ant = ($cuenta_aumenta == 'D') ? ($debe_ant - $haber_ant) : ($haber_ant - $debe_ant);
                    $info = '<table cellpadding="3"><thead>';
                    $info .= '<tr>
		                    <th class="head1" ><b>Cuenta:</b></th>
		                    <td>' . $registro_cuenta[0]['cnt_cuenta'] . '</td>
		                    <td>' . $registro_cuenta[0]['cnt_nombre'] . '</td>
		                    <th class="head1"><strong>Saldo Ant.</strong></th>
		                    <td>' . number_format($saldo_ant, 2) . '</td>
		                </tr>
		                <tr>
		                	<td colspan="5"></td>
		                </tr>';
                    $info .= '</thead></table>';

                    $saldo_afectado = $saldo_ant;
                    $suma_debe = 0;
                    $suma_haber = 0;
                    $aumenta = $registro_cuenta[0]['cnt_aumenta'];
                    foreach ($movimientos as $mov) {
                        $mov['dpc_debe'] = $mov['dpc_debe'];
                        $mov['dpc_haber'] = $mov['dpc_haber'];

                        $saldo_actual = ($cuenta_aumenta == 'D') ? ($mov['dpc_debe'] - $mov['dpc_haber']) : ($mov['dpc_haber'] - $mov['dpc_debe']);
                        $fecha = date('d-m-Y', strtotime($mov['pct_fecha']));

                        $debe = ($mov['dpc_debe'] <= 0) ? 0 : $mov['dpc_debe'];
                        $haber = ($mov['dpc_haber'] <= 0) ? 0 : $mov['dpc_haber'];
                        $saldo_afectado += $saldo_actual;

                        $codigo_partida = ($mov['pct_codigo'] == "") ? str_replace('-', '', $mov['codigo_dependiente']) : $mov['pct_codigo'] . $mov['codigo_dependiente'];

                        $cadena .= '<tr>
			                        <td style="width:9%;">' . $fecha . '</td>
			                        <td style="width:9%;">' . $codigo_partida . '</td>
			                        <td style="text-align:left;width:22%;">' . $mov['pct_concepto'] . ' ' . $mov['dpc_concepto'] . '</td>
                                    <td style="text-align:left;width:17%;">' . $mov['dpc_descripcion'] . '</td>
			                        <td style="text-align:right;width:14%;">' . (($debe != 0) ? number_format($debe, 2) : '') . '</td>
			                        <td style="text-align:right;width:14%;">' . (($haber != 0) ? number_format($haber, 2) : '') . '</td>
			                        <td style="text-align:right;width:15%;">' . (($saldo_afectado != 0) ? number_format($saldo_afectado, 2) : '') . '</td>
			                      </tr>';

                        $suma_debe += (float) $debe;
                        $suma_haber += (float) $haber;
                    }

                    $cadena .= '<tr>
	                            <td colspan="4" style="text-align:right;"><strong>Totales:</strong></td>
	                            <td style="text-align:right;" class="total"><strong>' . number_format($suma_debe, 2) . '</strong></td>
	                            <td style="text-align:right;" class="total"><strong>' . number_format($suma_haber, 2) . '</strong></td>
	                            <td style="text-align:right;" class="total"><strong>' . number_format($saldo_afectado, 2) . '</strong></td>
	                          </tr>';
                } else {
                    $cadena .= '<tr>
            				<td colspan="7" style="text-align:center"> No se encontraron resultados</td>
            			  </tr>';
                }

                $cadena .= '</table>';

                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                $data['table_header'] = $rows;
                $data['table_tbody'] = $cadena;
                $data['tabla_info'] = $info;
                $data['filename'] = $filename;

                if ($es_excel) {
                    $html = $this->load->view('modulo_contabilidad/reportes/reporte_partidas_pdf.php', $data, true);
                    $html = str_replace($rows, '', $html);
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=Movimiento_cuentas_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                      <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='6' align='center' >MOVIMIENTO DE CUENTAS CONTABLES <br> DEL " . $fecha_ini . " AL " . $fecha_fin . "</th></tr>
                      </table>";

                    echo $html;
                    die();
                }

                $this->pdf->reportePDF('modulo_contabilidad/reportes/reporte_partidas_pdf.php', $data);
            }
        }
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function reporte_comprobacion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $centro_costo               = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo               = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']       = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $data['cuentas']            = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre} ', '', null, null, '', 'cnt_id', true);
            $data["titulo_personal"]    = "Reporte de comprobaci&oacute;n";
            $this->_cargarvista($data);
        }
    }

    function consultar_reporte_comprobacion_BK()
    {
        $fecha_ini          = $this->input->post('fecha_ini');
        $fecha_fin          = $this->input->post('fecha_fin');
        $flag_cuenta_cero   = $this->input->post('cuentas_con_cero');

        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

        if ($fecha_ini == '' && $fecha_fin == '') {
            $where = null;
        }


        $cuentas = $this->contabilidad_model->get_cuentas_padre();

        $padres = array();
        foreach ($cuentas as $key) {
            $padres[] = $key['cnt_id'];
        }

        $movimientos = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $fecha_fn);

        $cadena = '';

        if (!empty($movimientos)) {
            //$saldo_afectado=$saldo_ant;
            $suma_debe = 0;
            $suma_haber = 0;
            $fecha_saldo_anterior = $fecha_inicio - 1;
            $cantidad_subcuenta = 0;
            $debe = 0;
            $haber = 0;

            $dependencias = array();

            foreach ($movimientos as $mov) {
                $subcuenta = array();
                $anterior = 0;

                $totales = $this->contabilidad_model->get_saldo_cuenta($mov['cnt_cuenta'], $fecha_inicio, $fecha_fn);
                //$totales = $this->contabilidad_model->get_cuentas_totales($mov['cnt_cuenta']);
                //$saldos = $this->contabilidad_model->get_saldo_antxcnt($mov['cnt_cuenta'], $fecha_inicio);

                if (in_array($mov['cnt_id'], $padres)) {
                    $negrita = "font-weight: bold;";
                } else {
                    $negrita = '';
                }

                $debe = $totales[0]['debe'];
                $haber = $totales[0]['haber'];

                $where_ant = " (cnt_cuenta LIKE '" . $mov['cnt_cuenta'] . "%' OR cnt_cuenta = '" . $mov['cnt_cuenta'] . "') AND " .
                    "date_format(pct_fecha, '%Y-%m-%d') <'" . $fecha_inicio . "'";

                $saldo_anterior = $this->contabilidad_model->get_saldo_anterior($where_ant, true, false);
                $debe_ant = (isset($saldo_anterior['Debe'])) ? $saldo_anterior['Debe'] : 0;
                $haber_ant = (isset($saldo_anterior['Haber'])) ? $saldo_anterior['Haber'] : 0;
                $anterior = ($mov['cnt_aumenta'] == 'D') ? $debe_ant - $haber_ant : $haber_ant - $debe_ant;

                //Se recalcula el saldo actual en base al campo cnt_aumenta
                if ($mov['cnt_aumenta'] == 'D') {
                    $new_saldo = ($anterior + $debe) - $haber;
                } else {

                    $new_saldo = ($anterior + $haber) - $debe;
                }

                if ($new_saldo <> 0) {
                    $cadena .= '<tr>'
                        . '<td style="' . $negrita . '">' . $mov['cnt_cuenta'] . '</td>'
                        . '<td style="text-align:left;' . $negrita . '">' . $mov['cnt_nombre'] . '</td>'
                        . '<td style="text-align:right;' . $negrita . '">' . number_format($anterior, 2) . '</td>'
                        . '<td style="text-align:right;' . $negrita . '">' . number_format($debe, 2) . '</td>'
                        . '<td style="text-align:right;' . $negrita . '">' . number_format($haber, 2) . '</td>'
                        . '<td style="text-align:right;' . $negrita . '">' . number_format($new_saldo, 2) . '</td>'
                        . '</tr>';
                } else {
                    if ($flag_cuenta_cero == 'true') { //Imprimir Cuentas de nivel 2 si esta el flag de impresion de cuentas con cero
                        $cadena .= '<tr>'
                            . '<td style="' . $negrita . '">' . $mov['cnt_cuenta'] . '</td>'
                            . '<td style="text-align:left;' . $negrita . '">' . $mov['cnt_nombre'] . '</td>'
                            . '<td style="text-align:right;' . $negrita . '">' . number_format($anterior, 2) . '</td>'
                            . '<td style="text-align:right;' . $negrita . '">' . number_format($debe, 2) . '</td>'
                            . '<td style="text-align:right;' . $negrita . '">' . number_format($haber, 2) . '</td>'
                            . '<td style="text-align:right;' . $negrita . '">' . number_format($new_saldo, 2) . '</td>'
                            . '</tr>';
                    }
                }

                $indice = 'debe' . $mov['cnt_id_cnt_padre'];
                //$debe = $totales[0]['debe'];
                //$haber = $totales[0]['haber'];
                $suma_debe += $mov['debe']; //$debe;
                $suma_haber += $mov['haber']; //$haber;
                $dependencias[$indice] += $debe;
            }
            $saldo = $suma_haber - $suma_debe;
            if ($saldo < 0) {
                $saldo = $saldo * (-1);
            }
            $cadena .= '<tr>
                        <td colspan="3" style="text-align:right;"><strong>Totales:</strong></td>
                        <td style="text-align:right;"><strong>' . number_format($suma_debe, 2) . '</strong></td>'
                . '<td style="text-align:right;"><strong>' . number_format($suma_haber, 2) . '</strong></td>'
                . '<td style="text-align:right;"><strong>' . number_format($saldo, 2) . '</strong></td>'
                . '</tr>';
        } else {
            $cadena .= '<tr>
                <td colspan="6" style="text-align:center"> No se encontraron resultados</td>
                </tr>';
        }
        //echo json_encode(array('head'=>$info, 'tbody'=>$cadena));
        echo json_encode(array('tbody' => $cadena));
    }

    function reporte_balance_comprobacion($es_excel = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $fecha_ini = $this->input->post('fecha_inicio');
                $fecha_fin = $this->input->post('fecha_fin');
                $flag_cuenta_cero = $this->input->post('cuentas_con_cero');

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
                    $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

                    $fecha_inicio_impri = date('d/m/Y', strtotime($fecha_ini));
                    $fecha_fn_impri = date('d/m/Y', strtotime($fecha_fin));
                }

                $cuentas = $this->contabilidad_model->get_cuentas_padre();

                $padres = array();
                foreach ($cuentas as $key) {
                    $padres[] = $key['cnt_id'];
                }

                $movimientos = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $fecha_fn);

                $rows = $this->load->view('reporte/header_reportes_conta', array('titulo' => "BALANCE DE COMPROBACI&Oacute;N <br> AL " . $this->convertir_fecha_larga($fecha_fn_impri, 'de', true) . "", 'solotitulo' => true, 'subtitulo' => '<br> Valores Expresados en D&oacute;lares de los Estados Unidos'), true);

                $cadena = '';
                $cadena .= '<table class="tabla" cellpadding="2">';
                $cadena .= '<thead >
                            <tr>
                                <th class="head" style="width:15%;border-top-style: solid;border-left-style: solid;">Cuenta</th>
                                <th class="head" style="width:15%;border-top-style: solid;">T&iacute;tulo</th>
                                <th class="head" style="width:25%;border-top-style: solid;">Saldo anterior</th>
                                <th class="head" style="width:15%;border-top-style: solid;">Debe</th>
                                <th class="head" style="width:15%;border-top-style: solid;">Haber</th>
                                <th class="head" style="width:15%;border-top-style: solid;border-right-style: solid;">Nuevo saldo</th>
                            </tr>
                           </thead>';

                if (!empty($movimientos)) {
                    //$saldo_afectado=$saldo_ant;
                    $suma_debe = 0;
                    $suma_haber = 0;
                    $fecha_saldo_anterior = $fecha_inicio - 1;
                    $cantidad_subcuenta = 0;
                    $debe = 0;
                    $haber = 0;

                    $dependencias = array();

                    foreach ($movimientos as $mov) {
                        $subcuenta = array();
                        $anterior = 0;

                        $totales = $this->contabilidad_model->get_saldo_cuenta($mov['cnt_cuenta'], $fecha_inicio, $fecha_fn);
                        //$totales = $this->contabilidad_model->get_cuentas_totales($mov['cnt_cuenta']);
                        //$saldos = $this->contabilidad_model->get_saldo_antxcnt($mov['cnt_cuenta'], $fecha_inicio);

                        if (in_array($mov['cnt_id'], $padres)) {
                            $negrita = "font-weight: bold;";
                        } else {
                            $negrita = '';
                        }

                        $debe = $totales[0]['debe'];
                        $haber = $totales[0]['haber'];

                        $where_ant = " (cnt_cuenta LIKE '" . $mov['cnt_cuenta'] . "%' OR cnt_cuenta = '" . $mov['cnt_cuenta'] . "') AND " .
                            "date_format(pct_fecha, '%Y-%m-%d') <'" . $fecha_inicio . "'";

                        $saldo_anterior = $this->contabilidad_model->get_saldo_anterior($where_ant, true, false);
                        $debe_ant = (isset($saldo_anterior['Debe'])) ? $saldo_anterior['Debe'] : 0;
                        $haber_ant = (isset($saldo_anterior['Haber'])) ? $saldo_anterior['Haber'] : 0;
                        $anterior = ($mov['cnt_aumenta'] == 'D') ? $debe_ant - $haber_ant : $haber_ant - $debe_ant;
                        //Se recalcula el saldo actual en base al campo cnt_aumenta
                        if ($mov['cnt_aumenta'] == 'D') {
                            $new_saldo = ($anterior + $debe) - $haber;
                        } else {

                            $new_saldo = ($anterior + $haber) - $debe;
                        }

                        if ($new_saldo <> 0) {
                            $cadena .= '<tr>'
                                . '<td style="' . $negrita . '">' . $mov['cnt_cuenta'] . '</td>'
                                . '<td style="text-align:left;' . $negrita . '">' . $mov['cnt_nombre'] . '</td>'
                                . '<td style="text-align:right;' . $negrita . '">' . number_format($anterior, 2) . '</td>'
                                . '<td style="text-align:right;' . $negrita . '">' . number_format($debe, 2) . '</td>'
                                . '<td style="text-align:right;' . $negrita . '">' . number_format($haber, 2) . '</td>'
                                . '<td style="text-align:right;' . $negrita . '">' . number_format($new_saldo, 2) . '</td>'
                                . '</tr>';
                        } else {
                            if ($flag_cuenta_cero == 'true') { //Imprimir Cuentas de nivel 2 si esta el flag de impresion de cuentas con cero
                                $cadena .= '<tr>'
                                    . '<td style="' . $negrita . '">' . $mov['cnt_cuenta'] . '</td>'
                                    . '<td style="text-align:left;' . $negrita . '">' . $mov['cnt_nombre'] . '</td>'
                                    . '<td style="text-align:right;' . $negrita . '">' . number_format($anterior, 2) . '</td>'
                                    . '<td style="text-align:right;' . $negrita . '">' . number_format($debe, 2) . '</td>'
                                    . '<td style="text-align:right;' . $negrita . '">' . number_format($haber, 2) . '</td>'
                                    . '<td style="text-align:right;' . $negrita . '">' . number_format($new_saldo, 2) . '</td>'
                                    . '</tr>';
                            }
                        }

                        $indice = 'debe' . $mov['cnt_id_cnt_padre'];
                        //$debe = $totales[0]['debe'];
                        //$haber = $totales[0]['haber'];
                        $suma_debe += $mov['debe']; //$debe;
                        $suma_haber += $mov['haber']; //$haber;
                        $dependencias[$indice] += $debe;
                    }
                    $saldo = $suma_haber - $suma_debe;
                    if ($saldo < 0) {
                        $saldo = $saldo * (-1);
                    }
                    $cadena .= '<tr>
                                <td colspan="3" style="text-align:right;"><strong>Totales:</strong></td>
                                <td style="text-align:right;"><strong>' . number_format($suma_debe, 2) . '</strong></td>'
                        . '<td style="text-align:right;"><strong>' . number_format($suma_haber, 2) . '</strong></td>'
                        . '<td style="text-align:right;"><strong>' . number_format($saldo, 2) . '</strong></td>'
                        . '</tr>';
                } else {
                    $cadena .= '<tr>
                        <td colspan="6" style="text-align:center"> No se encontraron resultados</td>
                        </tr>';
                }
                $cadena .= '</table>';
                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header'] = $rows;
                $data['table_tbody'] = $cadena;
                $data['tabla_info'] = $info;
                $data['filename'] = $filename;

                //$data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));

                if ($es_excel) {
                    $html = $this->load->view('modulo_contabilidad/reportes/reporte_comprobacion_pdf.php', $data, true);
                    $html = str_replace($rows, '', $html);
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=reporte_comprobacion_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                      <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='6' align='center' > BALANCE DE COMPROBACI&Oacute;N <br> AL " .  $this->convertir_fecha_larga($fecha_fn_impri, 'de', true)  .  "</th></tr>
                      </table>";

                    echo $html;
                    die();
                }

                $this->pdf->reportePDF('modulo_contabilidad/reportes/reporte_comprobacion_pdf.php', $data);
            }
        }
    }

    public function balance_comprobacion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $centro_costo               = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo               = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']       = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $data["titulo_personal"]    = "Balance General Tipo Cuenta";
            $this->_cargarvista($data);
        }
    }

    function consultar_balance_comprobacion_backup()
    {
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $cuenta = $this->input->post('cuenta');

        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

        $data['nivel_minimo'] = $this->gsatelite->get_parametro('SYS_NIVEL_INICIAL_CNT');

        $reporte_balance = $this->gsatelite->get_parametro('SYS_REP_ID_BALANCE_COM');
        //$this->db->where(array('cnt_id_nic'=>$data['nivel_minimo']));
        $where_cuentas_nvl = array('nic_numero' => $data['nivel_minimo'], 'drp_id_rep' => $reporte_balance);
        $data['cuentas_nivel_1'] = $this->contabilidad_model->get_cuentas_reportes($where_cuentas_nvl);
        $where_reporte = array('drp_id_rep' => $reporte_balance);

        $data['cuentas'] = $this->contabilidad_model->get_cuentas_reportes($where_reporte);

        $data['fecha_inicio'] = $fecha_inicio;
        $data['fecha_fn'] = $fecha_fn;

        $cuentas_agrupadas = $this->gsatelite->get_parametro('SYS_CUENTAS_AGRUPADAS');
        $cuentas_agrupadas = json_decode($cuentas_agrupadas, true);

        $data['cuentas_activos'] = $cuentas_agrupadas['ACTIVOS'];
        $data['cuentas_pasivos'] = $cuentas_agrupadas['PASIVOS'];


        $html = $this->load->view('modulo_contabilidad/reportes/datos_pasivos_activos', $data, true);
        $respuesta = array(
            'html' => $html,
            'movimientos' => 1 //(count($data['activos']) > 0) ? 1 : 0
        );
        echo json_encode($respuesta);
    }

    /***********************************************************************************/
    //$data['id_tif_exportacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL',null,null,array('ID_TIF_EXPORTACION'));            
    public function consultar_balance_comprobacion($es_reporte = 0)
    {
        satelite_validar();
        $select = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
        $data["slcTipoFactura"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', '', null, '', 'tpd_id', true);
        $data["slcTipoPartida"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $data['titulo_personal'] = "Reporte consolidación partidas";
        $this->_cargarvista($data);
    }
    /**
     * @author Elman Ortiz
     * @since 2017-07-24
     * @param int $es_reporte (1=si es reporte, 0 = no es reporte)
     * @return Genera el reporte de balance general
     */
    public function generar_balance_comprobacion($es_reporte = 0)
    {
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        ini_set('max_input_vars', '15000');
        $post_array = $this->input->post();
        /*
         * Si es consulta ajax se toman los nombres del Jquery
         * De lo contrario, se toman los filtros de impresión
        */
        $fecha_inicio       = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;
        $fecha_fin          = ($post_array['txtFecha_hasta'] != '') ? $post_array['txtFecha_hasta'] : null;
        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        //Tipo de Reportes si sera Excel o Pdf
        //$tipo_reporte = $this->input->post('tipo_reporte');

        $where['pct_estado'] = 1;
        $where2['pct_estado'] = 1;
        //print_r($fecha_inicio); die();
        if ($fecha_inicio != null) {
            $where['DATE(pct_fecha) >='] = formatear_fecha('Y-m-d', $fecha_inicio);
            $where2['DATE(pct_fecha) <'] = formatear_fecha('Y-m-d', $fecha_inicio);
        }

        if ($fecha_fin != null) {
            $where['DATE(pct_fecha) <='] = formatear_fecha('Y-m-d', $fecha_fin);
        }

        if ($slc_centro_costo != "") {
            $where['pcc_id_cec'] = $slc_centro_costo;
            $where2['pcc_id_cec'] = $slc_centro_costo;
        }

        $data['txtFecha_desde']     = $fecha_inicio;
        $data['txtFecha_hasta']     = $fecha_fin;
        $data['txt_centro_costo']   = $txt_centro_costo;
        $data['slc_centro_costo']   = $slc_centro_costo;
        $data['centro']             = $txt_centro_costo;
        $titutlos_cuentas = $this->contabilidad_model->get_titulos_cuentas_principales(array('cfr_id_rep' => 1, 'cfr_estado' => 1));
        /*$totales_cuenta = [];        
        foreach ($titutlos_cuentas as $key => $value) {
            $new_array_id = explode(",", $value['cuentas']);
            //print_r($new_array_id);
            $total_padre_e_hijo = $this->contabilidad_model->get_total_cuentapadre_cuentashijas_reportes($new_array_id,$where);
            //print_r($total_padre_e_hijo); die();
            $value['total'] = $total_padre_e_hijo[0]['total'];
            $totales_cuenta[$key+1] = $value; 
        } 
        $totales_cuenta_aux = $totales_cuenta;
        foreach ($totales_cuenta as $j => $total_cuenta) {
            $acumulador_total = 0;                
            if($total_cuenta['cfr_grupo']){
                foreach ($totales_cuenta as $m => $val) {
                    if(($val['cfr_id_padre'] == $total_cuenta['cfr_id']) || ($val['cfr_id'] == $total_cuenta['cfr_id'])){
                        $acumulador_total = $acumulador_total + $val['total'];
                    }
                }
            }
            $totales_cuenta_aux[$j]['total_acumulado'] = $acumulador_total;                
        }*/
        /**************************************************************/
        //$idreporte = $this->input->post('idreporte');          
        $idreporte = 1;

        $this->db->join('tpd_tipo_partida', 'tpd_id = txr_id_tpd');
        $txrs = $this->gsatelite->get_tabla('txr_tipo_partidaxreporte', array('tpd_estado' => 1, 'txr_id_rep' => $idreporte));
        if (count($txrs) > 0) {
            $tpds = implode(',', array_column($txrs, 'txr_id_tpd'));
            $where["pct_id_tpd IN ($tpds)"] = null;
            $where2["pct_id_tpd IN ($tpds)"] = null;
        }

        $datos_reporte = $this->get_total_cuenta_recursivo2($titutlos_cuentas, $where, $idreporte, $where2);
        // var_dump($datos_reporte);die();
        // print_r($this->db->last_query());die();
        /**************************************************************/
        $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
        $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
        $filename = 'rpt_balance_comprobacion' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename']              = $filename;
        $data['es_reporte']            = $es_reporte;
        $data['registros']             = $datos_reporte;
        $cfr_alineacion = array_column($datos_reporte, 'cfr_alineacion');
        $array_filtrado = array_filter($cfr_alineacion);

        if (count($array_filtrado) > 0 && in_array('2', $array_filtrado)) {
            $orientacion_pagina = "L";
            //$data['cambio_orientacion'] = 1;
        } else {
            $orientacion_pagina = 'Portrait';
        }
        $data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
        $data['tipo_reporte'] = ($es_reporte) ? $post_array['tipo_accion'] : "";

        $html = $this->load->view('modulo_contabilidad/reportes/datos_pasivos_activos', $data, true);
        $filtro_titulo = "";
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo .= "al " . $this->convertir_fecha_larga($fecha_fin, 'de', true);
            $filtro_titulo .= "<br />";
            $filtro_titulo .= "(Valores en Dolares)";
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=Balance_General_" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='6' align='center' >Balance General</th></tr>
                  <tr><th colspan='6' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                ini_set('memory_limit', '2048M');
                ini_set('max_execution_time', '9999');

                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Balance General<br /> $filtro_titulo", 'solotitulo' => true, 'propietario' => $propietario), true);
                $this->pdf->makePDF($html_header . $html, "$orientacion_pagina", 'reincidencias', 'Letter');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }
    /***********************************************************************************/

    /*****************ESTADO DE RESULTADOS**********************************************/
    /**
     * @author Elman Ortiz
     * @since 2017-07-24
     * @param int $es_reporte (1=si es reporte, 0 = no es reporte)
     * @return Genera el reporte de balance general
     */
    public function generar_estado_resultado($es_reporte = 0)
    {
        satelite_validar();
        $post_array = $this->input->post();
        /* Si es consulta ajax se toman los nombres del Jquery, De lo contrario, se toman los filtros de impresión */
        $fecha_inicio     = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;
        $fecha_fin        = ($post_array['txtFecha_hasta'] != '') ? $post_array['txtFecha_hasta'] : null;
        $slc_centro_costo = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        /*if ($flag) {
            $fecha_inicio     = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;
            $fecha_fin        = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;                            
        } else {
            $fecha_inicio = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
            $fecha_fin    = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;                                
            $idtipopartida    = ($post_array['hslcTipoPartida'] != '') ? $post_array['hslcTipoPartida'] : null;      
            //Filtros pdf y excel
            $data['tipopartidatext']    = ($post_array['hslcTipoPartidatext'] != '') ? '<b>TIPO: </b>' . $post_array['hslcTipoPartidatext'] : '<b>TIPO: </b>' .'Todos';
            $data['fecha_iniciotext']  = ($fecha_inicio != '') ? '<b>PARTIDA DESDE: </b>' . formatear_fecha('d-m-Y', $fecha_inicio) : '';
            $data['fecha_fintext']     = ($fecha_fin != '') ? '<b>PARTIDA HASTA: </b>' . formatear_fecha('d-m-Y', $fecha_fin) : '';                
        }*/
        //Tipo de Reportes si sera Excel o Pdf
        //$tipo_reporte = $this->input->post('tipo_reporte');
        $where['pct_estado'] = 1;
        if ($fecha_inicio != null) {
            $where['DATE(pct_fecha) >='] = formatear_fecha('Y-m-d', $fecha_inicio);
        }
        if ($fecha_fin != null) {
            $where['DATE(pct_fecha) <='] = formatear_fecha('Y-m-d', $fecha_fin);
        }
        if ($slc_centro_costo != "") {
            $where['pcc_id_cec'] = $slc_centro_costo;
        }
        $data['txtFecha_desde']     = $fecha_inicio;
        $data['txtFecha_hasta']     = $fecha_fin;
        $data['txt_centro_costo']   = $txt_centro_costo;
        $data['slc_centro_costo']   = $slc_centro_costo;
        $idreporte = 2;
        $titutlos_cuentas = $this->contabilidad_model->get_titulos_cuentas_principales(array('cfr_id_rep' => $idreporte));
        /*$totales_cuenta = [];        
        foreach ($titutlos_cuentas as $key => $value) {
            $new_array_id = explode(",", $value['cuentas']);
            //print_r($new_array_id);
            $total_padre_e_hijo = $this->contabilidad_model->get_total_cuentapadre_cuentashijas_reportes($new_array_id,$where);
            //print_r($total_padre_e_hijo); die();
            $value['total'] = $total_padre_e_hijo[0]['total'];
            $totales_cuenta[$key+1] = $value; 
        }                            
        $totales_cuenta_aux = $totales_cuenta;
        foreach ($totales_cuenta as $j => $total_cuenta) {
            $acumulador_total = 0;                
            if($total_cuenta['cfr_grupo']){
                foreach ($totales_cuenta as $m => $val) {
                    if(($val['cfr_id_padre'] == $total_cuenta['cfr_id']) || ($val['cfr_id'] == $total_cuenta['cfr_id'])){
                        $acumulador_total = $acumulador_total + $val['total'];
                    }
                }
            }
            $totales_cuenta_aux[$j]['total_acumulado'] = $acumulador_total;                
        }*/
        /**************************************************************/
        $this->db->join('tpd_tipo_partida', 'tpd_id = txr_id_tpd');
        $txrs = $this->gsatelite->get_tabla('txr_tipo_partidaxreporte', array('tpd_estado' => 1, 'txr_id_rep' => $idreporte));
        if (count($txrs) > 0) {
            $tpds = implode(',', array_column($txrs, 'txr_id_tpd'));
            $where["pct_id_tpd IN ($tpds)"] = null;
        }
        $datos_reporte = $this->get_total_cuenta_recursivo($titutlos_cuentas, $where, $idreporte);
        /**************************************************************/
        $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
        $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
        $filename = 'rpt_balance_comprobacion' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['tipo_reporte'] = ($es_reporte) ? $post_array['tipo_accion'] : "";
        $data['filename']              = $filename;
        $data['es_reporte']            = $es_reporte;
        $data['registros']             = $datos_reporte;
        $data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
        $html = $this->load->view('modulo_contabilidad/reportes/datos_consulta_estado_resultado', $data, true);
        $filtro_titulo = "";
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo .= "al " . $this->convertir_fecha_larga($fecha_fin, 'de', true);
            $filtro_titulo .= "<br />";
            $filtro_titulo .= "(Valores en Dolares)";

            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=Estado_Resultado" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='6' align='center' >Estado de Resultados</th></tr>
                  <tr><th colspan='6' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf                
                ini_set('memory_limit', '2048M');
                ini_set('max_execution_time', '9999');
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Estado de Resultados<br /> $filtro_titulo", 'solotitulo' => true, 'propietario' => $propietario), true);
                $this->pdf->makePDF($html_header . $html, 'Portrait', 'reincidencias', 'Letter');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }
    /***********************************************************************************/

    function imprimir_balance_detalle($es_excel = 0)
    {
        $fecha_ini          = $this->input->post('fecha_inicio');
        $fecha_fin          = $this->input->post('fecha_fin');
        $cuenta             = $this->input->post('cuenta');
        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn           = date('Y-m-d', strtotime($fecha_fin));

        $data['nivel_minimo']   = $this->gsatelite->get_parametro('SYS_NIVEL_INICIAL_CNT');
        $reporte_balance        = $this->gsatelite->get_parametro('SYS_REP_ID_BALANCE_COM');
        $where_cuentas_nvl      = array('nic_numero' => $data['nivel_minimo'], 'drp_id_rep' => $reporte_balance);
        $data['cuentas_nivel_1'] = $this->contabilidad_model->get_cuentas_reportes($where_cuentas_nvl);
        $where_reporte          = array('drp_id_rep' => $reporte_balance);
        $data['cuentas']        = $this->contabilidad_model->get_cuentas_reportes($where_reporte);
        $data['fecha_inicio']   = $fecha_inicio;
        $data['fecha_fn']       = $fecha_fn;
        $cuentas_agrupadas      = $this->gsatelite->get_parametro('SYS_CUENTAS_AGRUPADAS');
        $cuentas_agrupadas      = json_decode($cuentas_agrupadas, true);
        $data['cuentas_activos'] = $cuentas_agrupadas['ACTIVOS'];
        $data['cuentas_pasivos'] = $cuentas_agrupadas['PASIVOS'];
        $data['firmas']         = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));

        $this->load->library('pdf');
        $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'Balance General Tipo Cuenta al ' . $fecha_fin, 'solotitulo' => true, 'subtitulo' => 'Valores Expresados en D&oacute;lares de los Estados Unidos'), true);

        if ($es_excel) {
            //$html = str_replace($header_,'',$html);
            $html = $this->load->view('modulo_contabilidad/reportes/datos_pasivos_activos_excel', $data, true);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=balance_general_tipo_cuenta_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='6' align='center' >Balance General Tipo Cuenta al " . $fecha_fin . "</th></tr>
              <tr><th colspan='6' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
              </table>";

            echo $html;
            die();
        }

        $header_ = $html;
        $html .= $this->load->view('modulo_contabilidad/reportes/datos_pasivos_activos_pdf', $data, true);
        $reporte = $this->pdf->reportePDF2($html);
    }

    public function libro_mayor($a_detalle = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //consultar por los formatos de impresión
            $tipo_formato = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES', null, null, array('LIBRO_DIARIO_MAYOR'));
            $tipo_formato = (trim($tipo_formato) != "" && $tipo_formato > 0) ? $tipo_formato : 0;
            //$tipo_formato_mayor = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES',null,null,array('LIBRO_MAYOR'));
            // $tipo_formato_mayor = (trim($tipo_formato_mayor) != "" && $tipo_formato_mayor > 0 )? $tipo_formato_mayor:0;
            $imprimir_navegador = ($tipo_formato == 1) ? 1 : 0;
            // $imprimir_navegador = ($tipo_formato_mayor == 1)? 1:0;
            //$this->db->order_by("cnt_cuenta","ASC");
            //$data['cuentas_n_3'] = $this->contabilidad_model->cuentas_nivel_3();
            $data["titulo_personal"] = ($a_detalle) ? "Libro Diario Mayor" : "Libro Mayor";
            $data["a_detalle"] = $a_detalle;
            $data["imprimir_navegador"] = $imprimir_navegador;
            $centro_costo               = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo               = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']       = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            cargarvista($data, null, 'modulo_contabilidad/reportes/libro_mayor');
        }
    }

    function consultar_libro_mayor($es_reporte = 0, $es_excel = 0)
    {
        satelite_validar();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $tipo_formato = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES', null, null, array('LIBRO_DIARIO_MAYOR'));
        $tipo_formato = (trim($tipo_formato) != "" && $tipo_formato > 0) ? $tipo_formato : 0;
        $tipo_formato_mayor = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES', null, null, array('LIBRO_MAYOR'));
        $tipo_formato_mayor = (trim($tipo_formato_mayor) != "" && $tipo_formato_mayor > 0) ? $tipo_formato_mayor : 0;
        $fecha_ini          = ($es_reporte) ? $this->input->post('fecha_inicio') : $this->input->post('fecha_ini');
        $fecha_fin          = ($es_reporte) ? $this->input->post('fecha_fin') : $this->input->post('fecha_fin');
        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $a_detalle          = $this->input->post('a_detalle');
        $data['a_detalle']  = $a_detalle;
        $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
        $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
        // $id_cnt_cuenta = $this->input->post('cuenta');
        // $id_cnt_cuenta_fin = $this->input->post('cuenta_fin');
        $fecha_inicio           = formatear_fecha('Y-m-d', $fecha_ini);
        $fecha_fn               = formatear_fecha('Y-m-d', $fecha_fin);
        $data['fecha_inicio']   = $fecha_inicio;
        $data['fecha_fn']       = $fecha_fn;
        $data['centro']         = $txt_centro_costo;
        $data['pcc_id_cec']     = $slc_centro_costo;
        $where['cnt_id_nic']    = 3;
        if ($slc_centro_costo > 0) {
            $where['pcc_id_cec'] = $slc_centro_costo;
        }
        //$where['cnt_id in (2)'] = null; //where quemado para pruebas
        //los parametros no se toman en cuenta en la query porque se desea que se dibujen todas.
        $data['cuentas']    = $this->contabilidad_model->libro_mayor($fecha_inicio, $fecha_fn, $where);
        $data['es_reporte'] = $es_reporte;
        $vista_reporte      = "consultar_libro_mayor_new";
        $colspan_header     = "6";
        $html_header        = "";
        //$a_detalle = 1 (libro diario mayor)
        $imprimir_navegador = 0; //aplica para cuando es pdf
        if ($tipo_formato == 1 && $a_detalle == 1) {
            //formato maya      //libro_diario_mayor
            $imprimir_navegador = 1;
            $vista_reporte      = "consultar_libro_diario_mayor_maya";
            $colspan_header     = "5";
            $html_header        =  "<table border='0' align='center' width='100%'><thead>
             <tr><th align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
             <tr><th align='center' >" . (($a_detalle) ? "LIBRO DIARIO MAYOR" : "LIBRO MAYOR") . "
              " . 'DEL ' . $fecha_ini . ' AL ' . $fecha_fin .  "<!-- <br> Valores Expresados en D&oacute;lares de los Estados Unidos --></th></tr>
             </thead></table>";
        } else if ($tipo_formato_mayor == 1 && $a_detalle == 0) {
            //formato maya      //libro_mayor
            $imprimir_navegador = 1;
            $vista_reporte      = "consultar_libro_mayor_maya";
            $colspan_header     = "5";
            $html_header        =  "<table border='0' align='center' width='100%'><thead>
             <tr><th align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
             <tr><th align='center' >" . (($a_detalle) ? "LIBRO DIARIO MAYOR" : "LIBRO MAYOR") . "
              " . 'DEL ' . $fecha_ini . ' AL ' . $fecha_fin .  "<!-- <br> Valores Expresados en D&oacute;lares de los Estados Unidos --></th></tr>
             </thead></table>";
        } else if ($tipo_formato_mayor == 1 && $a_detalle == 2) {
            $this->db->join('mun_municipio', 'mun_id = emr_id_mun', 'LEFT');
            $emp = $this->gsatelite->get_tabla('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()));
            $vista_reporte = "libro_consolidado_diario_mayor";
            $html_header   = '<table cellpadding="1" width="100%" border="0"><tr><td width="20%"></td><th width="60%" align="center"><b>' . mb_strtoupper($emp[0]['emr_nombre'], 'UTF-8');
            $html_header  .= '</b></th><td width="20%"></td></tr><tr><td width="70%" align="left">Dirección: ' . $emp[0]['emr_direccion'] . '</td><td width="10%"></td><td width="20%" align="left">NRC: ';
            $html_header  .= $emp[0]['emr_numero_registro'] . '</td></tr><tr><td width="70%" align="left">Población: ' . $emp[0]['mun_nombre'] . '</td><td width="10%"></td><td width="20%" align="left">NIT: ';
            $html_header  .= $emp[0]['emr_nit'] . '</td></tr><tr><td width="20%" align="left">A&ntilde;o: ' . formatear_fecha('Y', $fecha_inicio) . '</td><td width="60%" align="center">LIBRO MAYOR</td>';
            $html_header  .= '<td width="20%"></td></tr></table>';
        }
        $data['html_header']    = $html_header;
        $data['html_header_top'] = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "<br />" . ((($a_detalle) ? "LIBRO DIARIO MAYOR" : "LIBRO MAYOR") . ' DEL ' . $fecha_ini . ' AL ' . $fecha_fin);
        $date_inicial = new DateTime("$fecha_inicio");
        $date_final = new DateTime("$fecha_fn");
        $diferencia = $date_inicial->diff($date_final);
        $cantidad_dias = intval($diferencia->days) + 1;
        $data['cantidad_dias']      = $cantidad_dias;
        $data['nombres_meses']      = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
        $data['imprimir_navegador'] = $imprimir_navegador;
        $data['es_reporte']         = $es_reporte;
        $data['es_excel']           = $es_excel;
        if ($es_reporte) {
            if ($es_excel) { //excel
                $html = $this->load->view("modulo_contabilidad/reportes/$vista_reporte", $data, true);
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=libro_mayor_" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                <tr><th colspan='$colspan_header' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                <tr><th colspan='$colspan_header' align='center' >" . (($a_detalle) ? "LIBRO DIARIO MAYOR" : "LIBRO MAYOR") . "</th></tr>
                <tr><th colspan='$colspan_header' align='center' >" . 'DEL ' . $fecha_ini . ' AL ' . $fecha_fin . '<br> Valores Expresados en D&oacute;lares de los Estados Unidos' . "</th></tr>
                </table>";
                echo $html;
                die();
            } else {  //pdf
                $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => (($a_detalle) ? "LIBRO DIARIO MAYOR" : "LIBRO MAYOR") . ' <br> DEL ' . formatear_fecha('d-m-Y', $fecha_ini) . ' AL ' . formatear_fecha('d-m-Y', $fecha_fin), 'solotitulo' => true, 'subtitulo' => '<br> Valores Expresados en D&oacute;lares de los Estados Unidos', 'propietario' => $propietario), true);
                $html_header = (trim($html_header) != "") ? '' : $html;
                $html =  $html_header . $this->load->view("modulo_contabilidad/reportes/$vista_reporte", $data, true);
                $html = "&nbsp;<br />" . str_replace(array('th {'), array('.anterior {'), $html);
                if ($imprimir_navegador) {
                    echo $html;
                    die();
                }
                $this->load->library('pdf');
                $this->pdf->makePDF($html);
                die();
            }
        } else {
            $respuesta = array(
                'html' => $this->load->view("modulo_contabilidad/reportes/$vista_reporte", $data, true),
                'cuentas' => (count($data['carga_datos']) > 0) ? 1 : 0
            );
            echo json_encode($respuesta);
        }
    }

    function imprimir_libro_mayor($es_excel = 0)
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        //	setlocale(LC_TIME, 'spanish');
        $fecha_ini = $this->input->post('fecha_inicio');
        $fecha_fin = $this->input->post('fecha_fin');
        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

        $data['fecha_inicio'] = $fecha_inicio;
        $data['fecha_fn'] = $fecha_fn;

        $where['CHARACTER_LENGTH(cnt_cuenta) ='] = 4;
        $data['cuentas']        = $this->contabilidad_model->libro_mayor($fecha_inicio, $fecha_fn, $where);
        $data['mov_cuentas']    = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn);
        //$data['saldo_anterior'] = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $fecha_fn);

        $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'LIBRO MAYOR <br> DEL ' . $fecha_ini . ' AL ' . $fecha_fin, 'solotitulo' => true, 'subtitulo' => '<br> Valores Expresados en D&oacute;lares de los Estados Unidos'), true);
        $header_ = $html;
        $html .= $this->load->view('modulo_contabilidad/reportes/reporte_libro_mayor_pdf', $data, true);


        if ($es_excel) {
            $html = str_replace($header_, '', $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=libro_mayor_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='6' align='center' >LIBRO MAYOR</th></tr>
              <tr><th colspan='6' align='center' >" . 'DEL ' . $fecha_ini . ' AL ' . $fecha_fin . '<br> Valores Expresados en D&oacute;lares de los Estados Unidos' . "</th></tr>
              </table>";

            echo $html;
            die();
        }

        $this->load->library('pdf');
        $this->pdf->makePDF($html);
    }

    public function libro_diario_mayor()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->libro_mayor(1);
            die();
            // $data['cuentas_n_3'] = $this->contabilidad_model->cuentas_nivel_3();
            // $data["titulo_personal"] = "Libro Diario Mayor";

            //$this->_cargarvista($data);
        }
    }

    function consultar_libro_diario_mayor()
    {

        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $id_cnt_cuenta = $this->input->post('cuenta');

        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

        $data['cuentas'] = $this->contabilidad_model->libro_mayor($fecha_inicio, $fecha_fn);

        $data['mov_diarios'] = $this->contabilidad_model->movimientos_diarios_libro_diario($fecha_inicio, $fecha_fn);

        $mes_anterior_ini = date('Y-m-d', strtotime('-1 Month', strtotime($fecha_ini)));

        $mes_anterior_fin = date('Y-m-d', strtotime('+1 Month', strtotime($mes_anterior_ini)));
        $mes_anterior_fin = date('Y-m-d', strtotime('-1 Day', strtotime($mes_anterior_fin)));

        $data['fecha_ini_ant'] = $mes_anterior_ini;
        $data['fecha_fin_ant'] = $mes_anterior_fin;

        $data['fecha_inicio'] = $fecha_inicio;
        $data['fecha_fin'] = $fecha_fn;
        //$data['saldo_anterior'] = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $fecha_fn);


        $respuesta = array(
            'html' => $this->load->view('modulo_contabilidad/reportes/consultar_libro_diario_mayor', $data, true),
            'cuentas' => 0
        );
        echo json_encode($respuesta);
    }

    function imprimir_libro_diario_mayor($es_excel = 0)
    {
        //	setlocale(LC_TIME, 'spanish');
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $fecha_ini = $this->input->post('fecha_inicio');
        $fecha_fin = $this->input->post('fecha_fin');
        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

        $data['cuentas'] = $this->contabilidad_model->libro_mayor($fecha_inicio, $fecha_fn);
        $data['mov_diarios'] = $this->contabilidad_model->movimientos_diarios_libro_diario($fecha_inicio, $fecha_fn);
        //$data['saldo_anterior'] = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $fecha_fn);
        $dia_ini = date('d', strtotime($fecha_inicio));
        $dia_fin = date('d', strtotime($fecha_fn));
        $x = date('Y-m-d', strtotime($fecha_fn));
        $mes_ = $this->mes_letras($x);
        $year = date('Y', strtotime($fecha_fn));
        $dias = $fecha_fn - $fecha_inicio;

        $data['fecha_inicio'] = $fecha_inicio;
        $data['fecha_fin'] = $fecha_fn;

        $this->load->library('pdf');
        $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'Libro Diario Mayor <br> Del ' . $dia_ini . ' al ' . $dia_fin . ' de ' . $mes_ . ' de ' . $year, 'solotitulo' => true, 'subtitulo' => '<br> Valores Expresados en D&oacute;lares de los Estados Unidos'), true);
        $header_ = $html;
        $html .= $this->load->view('modulo_contabilidad/reportes/reporte_libro_diario_mayor_pdf', $data, true);


        if ($es_excel) {
            $html = str_replace($header_, '', $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=libro_diario_mayor_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='6' align='center' >Libro Diario Mayor</th></tr>
              <tr><th colspan='6' align='center' > de " . $mes_ . " de " . $year . "<br> Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
              </table>";

            echo $html;
            die();
        }



        $this->pdf->makePDF($html);
    }

    function mes_letras($x)
    {
        $year = substr($x, 0, 4);
        $mon = substr($x, 5, 2);
        switch ($mon) {
            case "01":
                $mes = "Enero";
                break;
            case "02":
                $mes = "Febrero";
                break;
            case "03":
                $mes = "Marzo";
                break;
            case "04":
                $mes = "Abril";
                break;
            case "05":
                $mes = "Mayo";
                break;
            case "06":
                $mes = "Junio";
                break;
            case "07":
                $mes = "Julio";
                break;
            case "08":
                $mes = "Agosto";
                break;
            case "09":
                $mes = "Septiembre";
                break;
            case "10":
                $mes = "Octubre";
                break;
            case "11":
                $mes = "Noviembre";
                break;
            case "12":
                $mes = "Diciembre";
                break;
        }
        $day = substr($x, 8, 2);
        return $mes;
    }

    public function libro_auxiliar_mayor()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //consultar por los formatos de impresión
            $centro_costo               = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo               = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']       = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $tipo_formato               = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES', null, null, array('LIBRO_AUXILIAR'));
            $tipo_formato               = (trim($tipo_formato) != "" && $tipo_formato > 0) ? $tipo_formato : 0;
            $imprimir_navegador         = ($tipo_formato == 1) ? 1 : 0;
            $data['imprimir_navegador'] = $imprimir_navegador;
            $data['cuentas_n_3']        = $this->contabilidad_model->cuentas_nivel_3($fecha_inicio, $fecha_fn);
            $data["titulo_personal"]    = "Libro Auxiliar Mayor";
            $this->_cargarvista($data);
        }
    }

    function consultar_libro_auxiliar_mayor($tipo_reporte = "")
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        ini_set('post_max_size', '512M');

        $fecha_ini              = (trim($tipo_reporte) != "" and is_numeric($tipo_reporte)) ? $this->input->post('fecha_inicio') : $this->input->post('fecha_ini');
        $fecha_fin              = (trim($tipo_reporte) != "" and is_numeric($tipo_reporte)) ? $this->input->post('fecha_fin') : $this->input->post('fecha_fin');
        $fecha_inicio           = formatear_fecha("Y-m-d", $fecha_ini);
        $fecha_fin              = formatear_fecha("Y-m-d", $fecha_fin);
        $slc_centro_costo       = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo       = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $data['tipo_reporte']   = $tipo_reporte;
        $data['html_reporte']   = (trim($tipo_reporte) != "" and is_numeric($tipo_reporte)) ? trim($this->input->post('html_reporte')) : '';

        //consultar por los formatos de impresión
        $tipo_formato       = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES', null, null, array('LIBRO_AUXILIAR'));
        $tipo_formato       = (trim($tipo_formato) != "" && $tipo_formato > 0) ? $tipo_formato : 0;
        $imprimir_navegador = ($tipo_formato == 1) ? 1 : 0;

        if ($tipo_formato > 0) {
            //consultar las cuentas nivel 5
            $where['cnt_id_nic'] = 5;
        } else {
            $where['cnt_id_nic >'] = 3;
            $padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NULL' => null));
            //$id_padres = implode(',', array_column($padres, 'cnt_id'));
            $id_padres = (count($padres) > 0) ? implode(',', array_unique(array_column($padres, 'cnt_id'))) : 0;
            if (trim($id_padres) != "") {
                $where["cnt_id NOT IN ($id_padres)"] = null;
            }
        }

        if ($slc_centro_costo != "") {
            $where['dpc_id_pcc'] = $slc_centro_costo;
        }

        $data['cuentas'] = array();
        if ($data['html_reporte'] == "") {
            $data['cuentas']     = $this->contabilidad_model->libro_mayor(null, null, $where);
        }
        $data['fecha_inicio']   = $fecha_inicio;
        $data['fecha_fin']      = $fecha_fin;
        $data['centro']         = $txt_centro_costo;
        $data['dpc_id_pcc']     = $slc_centro_costo;

        if ($tipo_formato == 1) { //formato maya
            $html = $this->load->view('modulo_contabilidad/reportes/consultar_libro_auxiliar_mayor_maya', $data, true);
        } else //no existe otro personalizado más que el de maya por eso se utiliza la misma vista (pero ya existe parametro)
        {
            $html = $this->load->view('modulo_contabilidad/reportes/consultar_libro_auxiliar_mayor_maya', $data, true);
        }

        if ($tipo_reporte == 0 && is_numeric($tipo_reporte)) {
            echo $html;
            die();
        }
        if ($tipo_reporte == 1 && is_numeric($tipo_reporte)) {
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=libro_auxiliar_mayor_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo $html;
            die();
        }
        //print_r($data); die();



        /*        $data['mov_diarios'] = $this->contabilidad_model->movimientos_diarios_libro_diario($fecha_inicio, $fecha_fn, array("cnt_id_nic >=" => 4));

        $select     = "cnt_cuenta";
        $group_by   = "cnt_cuenta";
        $where["DATE(pct_fecha) <"] = $fecha_inicio;
        $where["cnt_id_nic"] = 5 ;
        //$where      = "DATE(pct_fecha) < '" . $fecha_inicio . "' and cnt_id_nic = 5";
        $data['saldos_anteriores'] = $this->contabilidad_model->get_saldos_anteriores($select, $where, $group_by);
       // print_r($data); die();

        $movimientos_cuentas = array();

        foreach ($data['cuentas'] as $cnt) {
            foreach ($data['mov_diarios'] as $mov) {

                if ($cnt['cnt_cuenta'] == $mov['cnt_cuenta']) {
                    $movimientos_cuentas[$cnt['cnt_cuenta']][] = $mov;
                }
            }
        }

        $data['movimientos_cuentas']= $movimientos_cuentas;
        $data['fecha_inicio']       = $fecha_inicio;
        $data['fecha_fin']          = $fecha_fn;

        $mes_anterior_ini = date('Y-m-d', strtotime('-1 Month', strtotime($fecha_ini)));
        $mes_anterior_fin = date('Y-m-d', strtotime('+1 Month', strtotime($mes_anterior_ini)));
        $mes_anterior_fin = date('Y-m-d', strtotime('-1 Day', strtotime($mes_anterior_fin)));

        $data['fecha_ini_ant']  = $mes_anterior_ini;
        $data['fecha_fin_ant']  = $mes_anterior_fin;
        $data['tipo_reporte']   = "";

        if ( $imprimir_navegador == 0) {
          
            $respuesta = array(
                'html' => $this->load->view('modulo_contabilidad/reportes/consultar_libro_auxiliar_mayor', $data, true),
                'cuentas' => 0
            );
        } else {
            $html                   = "";
            $data["columna_cuenta"] = array_column($data['saldos_anteriores'], 'cnt_cuenta'); 
            foreach ($data['cuentas'] as $key => $value) {
                $data["correlativo"]= $key;      
                $html              .= $this->load->view('modulo_contabilidad/reportes/consultar_libro_auxiliar_mayor_maya', $data, true);
            }
            $respuesta  = array(
                'html'      => $html,
                'cuentas'   => 0
            );
        }*/

        $respuesta['html']  = $html;
        $respuesta['cuentas']  = 0;
        echo json_encode($respuesta);
    }

    function imprimir_libro_auxiliar_mayor($es_excel = 0)
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $fecha_ini      = $this->input->post('fecha_inicio');
        $fecha_fin      = $this->input->post('fecha_fin');
        $fecha_inicio   = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn       = date('Y-m-d', strtotime($fecha_fin));

        //consultar por los formatos de impresión
        $tipo_formato       = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES', null, null, array('LIBRO_AUXILIAR'));
        $tipo_formato       = (trim($tipo_formato) != "" && $tipo_formato > 0) ? $tipo_formato : 0;
        $imprimir_navegador = ($tipo_formato == 1) ? 1 : 0;

        $mes_anterior_ini = date('Y-m-d', strtotime('-1 Month', strtotime($fecha_ini)));
        $mes_anterior_fin = date('Y-m-d', strtotime('+1 Month', strtotime($mes_anterior_ini)));
        $mes_anterior_fin = date('Y-m-d', strtotime('-1 Day', strtotime($mes_anterior_fin)));

        $data['fecha_inicio']   = $fecha_inicio;
        $data['fecha_fin']      = $fecha_fn;
        $data['fecha_ini_ant']  = $mes_anterior_ini;
        $data['fecha_fin_ant']  = $mes_anterior_fin;

        $data['cuentas']        = $this->contabilidad_model->libro_mayor($fecha_inicio, $fecha_fn);
        $data['mov_diarios']    = $this->contabilidad_model->movimientos_diarios_libro_diario($fecha_inicio, $fecha_fn);

        $select     = "cnt_cuenta";
        $group_by   = "cnt_cuenta";
        $where      = "date_format(pct_fecha, '%Y-%m-%d') < '" . $fecha_inicio . "'";
        $data['saldos_anteriores'] = $this->contabilidad_model->get_saldos_anteriores($select, $where, $group_by);

        $movimientos_cuentas = array();

        foreach ($data['cuentas'] as $cnt) {
            foreach ($data['mov_diarios'] as $mov) {

                if ($cnt['cnt_cuenta'] == $mov['cnt_cuenta']) {
                    $movimientos_cuentas[$cnt['cnt_cuenta']][] = $mov;
                }
            }
        }

        $data['movimientos_cuentas'] = $movimientos_cuentas;

        if ($imprimir_navegador > 0) {
            $html                   = "";
            $html_final             = "";
            $html_header            = "";
            $data["columna_cuenta"] = array_column($data['saldos_anteriores'], 'cnt_cuenta');
            $empresa                = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');

            if ($es_excel) {

                foreach ($data['cuentas'] as $key => $value) {
                    $data["correlativo"] = $key;
                    $html              .= $this->load->view('modulo_contabilidad/reportes/consultar_libro_auxiliar_mayor_maya', $data, true);
                }

                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=libro_auxiliar_mayor_" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                            <tr><th colspan='6' align='center' >" . $empresa . "</th></tr>
                            <tr><th colspan='6' align='center' >Libro Auxiliar Mayor</th></tr>
                            <tr><th colspan='6' align='center' >" . 'DEL ' . $fecha_ini . ' AL ' . $fecha_fin . '<br> Valores Expresados en D&oacute;lares de los Estados Unidos' . "</th></tr>
                        </table>";
                echo $html;
                die();
            } else {
                foreach ($data['cuentas'] as $key => $value) {
                    $html_header = "";
                    $html   = "";
                    $html_header .= '<table width="100%">';
                    $html_header .= '<tr>';
                    $html_header .= '<td colspan="3" style="text-align: left;"><b>Mayor</b></td>';
                    $html_header .= '<td colspan="3" style="text-align: right;"><b>Página</b></td>';
                    $html_header .= '</tr>';
                    $html_header .= '<tr>';
                    $html_header .= '<td colspan="3" style="text-align: left;"><b>' . $empresa . '</b></td>';
                    $html_header .= '<td colspan="3" style="text-align: right;"><b>cuenta ' . $value["cnt_nombre"] . '</b></td>';
                    $html_header .= '</tr>';
                    $html_header .= '<tr>';
                    $html_header .= '<td colspan="3" style="text-align: left;"><b>Ult. Fecha </b></td>';
                    $html_header .= '<td colspan="3" style="text-align: right;"><b>Período ' . date('d/m/Y', strtotime($fecha_ini)) . ' : ' . date('d/m/Y', strtotime($fecha_fin)) . '</b></td>';
                    $html_header .= '</tr>';
                    $html_header .= '<tr>';
                    $html_header .= '<td colspan="3" style="text-align: left;"><b>Valores en USD</b></td>';
                    $html_header .= '<td colspan="3" style="text-align: right;"><b>Asientos Preliminares incluidos</b></td>';
                    $html_header .= '</tr>';
                    $html_header .= '<tr>';
                    $html_header .= '<td colspan="3"></td>';
                    $html_header .= '<td colspan="3" style="text-align: right;"><b>No. Conciliado</b></td>';
                    $html_header .= '</tr>';
                    $html_header .= '<tr>';
                    $html_header .= '<td colspan="3"></td>';
                    $html_header .= '<td colspan="3" style="text-align: right;"><b>Conciliado</b></td>';
                    $html_header .= '</tr>';
                    $html_header .= '</table>';
                    $data["correlativo"] = $key;
                    $html_final        .= $html_header . $this->load->view('modulo_contabilidad/reportes/consultar_libro_auxiliar_mayor_maya', $data, true);
                }
                echo $html_final;
                die();
            }
        }

        //$data['saldo_anterior'] = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $fecha_fn);
        $dia_ini    = date('d', strtotime($fecha_inicio));
        $dia_fin    = date('d', strtotime($fecha_fn));
        $x          = date('Y-m-d', strtotime($fecha_fn));
        $mes_       = $this->mes_letras($x);
        $year       = date('Y', strtotime($fecha_fn));
        $dias       = $fecha_fn - $fecha_inicio;
        $this->load->library('pdf');
        $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'LIBRO AUXILIAR DE MAYOR <br>del ' . $dia_ini . ' al ' . $dia_fin . ' de ' . $mes_ . ' de ' . $year, 'solotitulo' => true, 'subtitulo' => '<br> Valores Expresados en D&oacute;lares de los Estados Unidos'), true);
        $header_ = $html;
        $html .= $this->load->view('modulo_contabilidad/reportes/reporte_libro_auxiliar_mayor_pdf', $data, true);

        if ($es_excel) {
            $html = str_replace($header_, '', $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=libro_auxiliar_mayor_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='6' align='center' >LIBRO AUXILIAR DE MAYOR</th></tr>
              <tr><th colspan='6' align='center' >" . $dia_ini . " al " . $dia_fin . " de " . $mes_ . " de " . $year . "</th></tr>
              </table>";

            echo $html;
            die();
        }

        $this->pdf->makePDF($html);
    }

    public function balance_general()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $centro_costo               = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo               = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']       = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $data["titulo_personal"]    = "Balance General Tipo Reporte";
            $this->_cargarvista($data);
        }
    }

    function consultar_balance_general()
    {

        $fecha_ini          = $this->input->post('fecha_ini');
        $fecha_fin          = $this->input->post('fecha_fin');
        $cuenta             = $this->input->post('cuenta');
        $flag_cuenta_cero   = $this->input->post('cuentas_con_cero');
        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $pcc_id_cec         = ($slc_centro_costo != "") ? $slc_centro_costo : null;
        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn           = date('Y-m-d', strtotime($fecha_fin));
        $where              = null;
        if ($slc_centro_costo != "") {
            $where['pcc_id_cec'] = $slc_centro_costo;
        }

        $data['pcc_id_cec']         = $pcc_id_cec;
        $data['fecha_ini']          = $fecha_inicio;
        $data['fecha_fin']          = $fecha_fn;
        $data['cuentas']            = $this->contabilidad_model->cuentas_balance_general($fecha_inicio, $fecha_fn);
        $data['old_saldo']          = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $cuenta, $pcc_id_cec);
        $data['mov_diarios']        = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn, $where);
        $data['flag_cuenta_cero']   = $flag_cuenta_cero;

        $respuesta = array(
            'html' => $this->load->view('modulo_contabilidad/reportes/consultar_balance_general', $data, true),
            'mov_diarios' => (count($data['carga_datos']) > 0) ? 1 : 0
        );
        echo json_encode($respuesta);
    }

    function imprimir_balance_general($es_excel = 0)
    {
        //setlocale(LC_TIME, 'spanish');
        $fecha_ini          = $this->input->post('fecha_inicio');
        $fecha_fin          = $this->input->post('fecha_fin');
        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn           = date('Y-m-d', strtotime($fecha_fin));
        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $pcc_id_cec         = ($pcc_id_cec != "") ? $pcc_id_cec : null;
        $where              = null;
        if ($slc_centro_costo != "") {
            $where['pcc_id_cec'] = $slc_centro_costo;
        }

        $data['pcc_id_cec'] = $pcc_id_cec;
        $data['centro']     = $txt_centro_costo;
        $data['fecha_ini']  = $fecha_inicio;
        $data['fecha_fin']  = $fecha_fn;
        $data['cuentas']    = $this->contabilidad_model->cuentas_balance_general($fecha_inicio, $fecha_fn);
        $data['old_saldo']  = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $cuenta, $pcc_id_cec);
        $data['mov_diarios'] = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn, $where);
        $data['firmas']     = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
        $data['es_excel']   = $es_excel;
        $data['flag_cuenta_cero'] = ($this->input->post('cnt_con_cero')) ? 'true' : 'false';

        $this->load->library('pdf');
        $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'Estado de situación financiera <br> Del ' . $this->convertir_fecha_larga($fecha_ini, false, false)['dia'] . ' de ' . $this->convertir_fecha_larga($fecha_ini, false, false)['mes'] . ' Al ' . $this->convertir_fecha_larga($fecha_fin, 'de', true), 'solotitulo' => true, 'subtitulo' => 'Valores expresados en D&oacute;lares de los Estados Unidos'), true);
        $header_ = $html;
        $html .= $this->load->view('modulo_contabilidad/reportes/reporte_balance_general', $data, true);

        if ($es_excel) {
            $html = str_replace($header_, '', $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=balance_general_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='6' align='center' >Estado de situación financiera <br>Del " . $this->convertir_fecha_larga($fecha_ini, false, false)['dia'] . " de " . $this->convertir_fecha_larga($fecha_ini, false, false)['mes'] . " Al " . $this->convertir_fecha_larga($fecha_fin, 'de', true) . "</th></tr>
              <tr><th colspan='6' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
              </table>";

            echo $html;
            die();
        }
        $this->pdf->makePDF($html);
    }

    public function estado_resultado_individual()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $centro_costo           = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo           = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']   = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $data["titulo_personal"] = "Estado de resultados individual";
            $this->_cargarvista($data);
        }
    }

    function constultar_estado_resultados_individual()
    {
        $fecha_ini          = $this->input->post('fecha_ini');
        $fecha_fin          = $this->input->post('fecha_fin');
        $cuenta             = $this->input->post('cuenta');
        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn           = date('Y-m-d', strtotime($fecha_fin));
        $pcc_id_cec         = ($slc_centro_costo != "") ? $slc_centro_costo : null;
        $where              = null;

        if ($pcc_id_cec != null) {
            $where["pcc_id_cec"] = $pcc_id_cec;
        }

        $data['cuentas']    = $this->contabilidad_model->cuentas_balance_general_individual($fecha_inicio, $fecha_fn);
        $data['old_saldo']  = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $cuenta, $pcc_id_cec);
        $data['mov_diarios'] = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn, $where);
        $data['fecha_ini']  = $fecha_inicio;
        $data['fecha_fin']  = $fecha_fn;
        $data['pcc_id_cec'] = $pcc_id_cec;

        $respuesta = array(
            'html' => $this->load->view('modulo_contabilidad/reportes/consultar_estado_result_indi', $data, true),
            'mov_diarios' => (count($data['carga_datos']) > 0) ? 1 : 0
        );
        echo json_encode($respuesta);
    }

    function imprimir_estado_resultados_individual($reporte = 1)
    {
        $fecha_ini          = $this->input->post('fecha_inicio');
        $fecha_fin          = $this->input->post('fecha_fin');
        $cuenta             = $this->input->post('cuenta');
        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn           = date('Y-m-d', strtotime($fecha_fin));
        $pcc_id_cec         = ($slc_centro_costo != "") ? $slc_centro_costo : null;
        $where              = null;

        if ($pcc_id_cec != null) {
            $where["pcc_id_cec"] = $pcc_id_cec;
        }

        $data['cuentas']    = $this->contabilidad_model->cuentas_balance_general_individual($fecha_inicio, $fecha_fn);
        $data['old_saldo']  = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $cuenta, $pcc_id_cec);
        $data['mov_diarios'] = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn);
        //$data['todas_cuentas']=$this->contabilidad_model->todas_cuentas();
        $data['fecha_ini']  = $fecha_inicio;
        $data['fecha_fin']  = $fecha_fn;
        $data['pcc_id_cec'] = $pcc_id_cec;
        $data['centro']     = $txt_centro_costo;
        $data['firmas']     = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
        $data['tipo_reporte'] = $reporte;
        $fec_ini = $this->convertir_fecha_larga($fecha_inicio, false, false);

        $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'ESTADO DE RESULTADO<br> del ' . $fec_ini['dia'] . ' de ' . $fec_ini['mes'] . ' al ' . $this->convertir_fecha_larga($fecha_fin, 'de', true), 'solotitulo' => true, 'subtitulo' => 'Valores expresados en D&oacute;lares de los Estados Unidos'), true);
        $header_ = $html;
        $html .= $this->load->view('modulo_contabilidad/reportes/imprimir_estado_resultados_individual', $data, true);

        if ($reporte == 1) {
            $this->load->library('pdf');

            $this->pdf->makePDF($html);
        } else {
            $html = str_replace($header_, '', $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=estado_resultado_individual" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='3' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='3' align='center' >ESTADO DE RESULTADO<br> del " . $fec_ini['dia'] . ' de ' . $fec_ini['mes'] . ' al ' . $this->convertir_fecha_larga($fecha_fin, 'de', true) . "</th></tr>
              <tr><th colspan='3' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
              </table>";

            echo $html;
            die();

            //$data['excel'] = 1;
            //$this->load->view('acciones_personal/consultas/print_consulta_horas', $data);
        }
    }

    //Este metodo es para el estado de resultados
    public function estado_resultado_acumulado()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Estado de resultados";
            $centro_costo               = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo               = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']       = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $this->_cargarvista($data);
        }
    }

    function constultar_estado_resultados_acumulado_backup()
    {
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $cuenta = $this->input->post('cuenta');

        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

        $data['cuentas'] = $this->contabilidad_model->cuentas_balance_general_individual($fecha_inicio, $fecha_fn);
        $data['old_saldo'] = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $cuenta);
        $data['mov_diarios'] = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn);
        //print_r($data['mov_diarios']); die();
        //$data['todas_cuentas']=$this->contabilidad_model->todas_cuentas();
        $data['fecha_ini'] = $fecha_inicio;
        $data['fecha_fin'] = $fecha_fn;

        $respuesta = array(
            'html' => $this->load->view('modulo_contabilidad/reportes/consultar_estado_result_acomu', $data, true),
            'mov_diarios' => (count($data['carga_datos']) > 0) ? 1 : 0
        );
        echo json_encode($respuesta);
    }

    function imprimir_estado_resultados_acumulado($reporte = 1)
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');

        $fecha_ini = $this->input->post('fecha_inicio');

        $fecha_fin = $this->input->post('fecha_fin');
        $cuenta = $this->input->post('cuenta');
        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

        $data['cuentas'] = $this->contabilidad_model->cuentas_balance_general_individual($fecha_inicio, $fecha_fn);
        $data['old_saldo'] = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $cuenta);
        $data['mov_diarios'] = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn);
        //$data['todas_cuentas']=$this->contabilidad_model->todas_cuentas();
        $data['fecha_ini'] = $fecha_inicio;
        $data['fecha_fin'] = $fecha_fn;
        $data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
        $data['tipo_reporte'] = $reporte;

        $fec_ini = $this->convertir_fecha_larga($fecha_ini, false, false);
        $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'ESTADO DE RESULTADO<br> Del ' . $fec_ini['dia'] . ' de ' . $fec_ini['mes'] . ' al ' . $this->convertir_fecha_larga($fecha_fin, 'de', true), 'solotitulo' => true, 'subtitulo' => 'Valores expresados en D&oacute;lares de los Estados Unidos'), true);
        $header_ = $html;
        $html .= $this->load->view('modulo_contabilidad/reportes/imprimir_estado_resultados_acumulado', $data, true);
        if ($reporte == 1) {
            $this->load->library('pdf');
            $this->pdf->makePDF($html);
        } else {
            $html = str_replace($header_, '', $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=estado_resultado_acumulado_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='3' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='3' align='center' >ESTADO DE RESULTADO<br> Del " . $fec_ini['dia'] . ' de ' . $fec_ini['mes'] . " al " . $this->convertir_fecha_larga($fecha_fin, 'de', true) . "</th></tr>
              <tr><th colspan='3' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
              </table>";

            echo $html;
            die();
            //$data['excel'] = 1;
            //$this->load->view('acciones_personal/consultas/print_consulta_horas', $data);
        }
    }

    function get_detalles_parcial($partida, $cuenta)
    {
        $where = array();
        $where['pct_id'] = $partida;
        $where['cnt_cuenta'] = $cuenta;
        $detalles = $this->contabilidad_model->listado_partida($where);

        $cadena = '';
        foreach ($detalles as $det) {
            if ($det['dpc_debe'] > 0) {
                $monto = $det['dpc_debe'];
            } else {
                $monto = $det['dpc_haber'];
            }

            $cadena .= '<tr>
			                        <td style="border: none;"></td>
			                        <td style="border: none;">' . $det['dpc_concepto'] . '</td>
			                        <td style="text-align:right; border: none;">' . $monto . '</td>
			                        <td style="text-align:right; border: none;"></td>
			                        <td style="text-align:right; border: none;"></td>
			                      </tr>';
        }
        return $cadena;
    }

    /*
     * @author: Mario Marquez
     */

    public function balance_detallado_cuenta()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Balance Detallado Tipo Cuenta";
            $centro_costo           = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo           = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']   = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $this->_cargarvista($data);
        }
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax, null = Impresión
     */

    public function reporte_balance_detallado_cuenta($flag = null)
    {
        if ($_POST) {
            $post_array = $this->input->post();

            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $fecha_ini = ($post_array['fecha_inicio'] != '') ? date('Y-m-d', strtotime($post_array['fecha_inicio'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            }
            $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : null;
            $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;

            if ($fecha_ini != '' && $fecha_fin != '') {
                //$where['orc_fecha_orden >='] = $fecha_ini;
                //$where['orc_fecha_orden <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fn'] = $fecha_fin;
            }

            $data['pcc_id_cec']      = $slc_centro_costo;
            $data['centro']          = $txt_centro_costo;
            $data['nivel_minimo']    = $this->gsatelite->get_parametro('SYS_NIVEL_INICIAL_CNT');
            $reporte_balance         = $this->gsatelite->get_parametro('SYS_REP_ID_BALANCE_COM');
            $where_cuentas_nvl       = array('nic_numero' => $data['nivel_minimo'], 'cfr_id_rep' => $reporte_balance);
            $data['cuentas_nivel_1'] = $this->contabilidad_model->get_cuentas_reportes($where_cuentas_nvl);
            $where_reporte           = array('nic_numero >=' => $data['nivel_minimo'], 'nic_numero <=' => $data['nivel_minimo'] + 3);
            $data['cuentas']         = $this->contabilidad_model->todas_cuentas($where_reporte);

            $tpds = "";
            $this->db->join('tpd_tipo_partida', 'tpd_id = txr_id_tpd');
            $txrs = $this->gsatelite->get_tabla('txr_tipo_partidaxreporte', array('tpd_estado' => 1, 'txr_id_rep' => $reporte_balance));
            if (count($txrs) > 0) {
                $tpds = implode(',', array_column($txrs, 'txr_id_tpd'));
            }
            $data['tpds'] = $tpds;
            $cuentas_agrupadas = $this->gsatelite->get_parametro('SYS_CUENTAS_AGRUPADAS');
            $cuentas_agrupadas = json_decode($cuentas_agrupadas, true);
            $data['cuentas_activos'] = $cuentas_agrupadas['ACTIVOS'];
            $data['cuentas_pasivos'] = $cuentas_agrupadas['PASIVOS'];
            $data['tipo_reporte'] = $tipo_reporte;
            $data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
            $data['flag'] = $flag;
            $filename = 'rpt_ordenes_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_contabilidad/reportes/reporte_balance_detallado_cuenta', $data, true);
            if ($flag) {
                $respuesta = array(
                    'html' => $html,
                    'movimientos' => 1 //(count($data['activos']) > 0) ? 1 : 0
                );
                echo json_encode($respuesta);
            } else {
                $html = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'Estado de situación financiera al ' . $this->convertir_fecha_larga($fecha_fin, 'de', true), 'solotitulo' => true, 'subtitulo' => 'Valores Expresados en D&oacute;lares de los Estados Unidos'), true);
                $header_ = $html;
                $html .= $this->load->view('modulo_contabilidad/reportes/reporte_balance_detallado_cuenta', $data, true);
                if ($tipo_reporte == 'pdf') {

                    /* $data['titulo'] = 'Órdenes de Compras';

                      $header = $this->load->view('reporte/header', $data, true);

                      $GLOBALS['nombre_reporte'] = 'Reporte_Ordenes_Compra_' . date('dmY');

                      $reporte = $header . $html;

                      //echo $reporte;
                      $this->pdf->SetMargins(10, 10, 10, 50);
                      $this->pdf->makePdf($reporte, 'L', 'Reporte_Ordenes_Compra', 'Letter'); */

                    //$this->load->library('pdf');

                    //echo $html;die();
                    $reporte = $this->pdf->reportePDF2($html, null, "L");
                    die();
                } elseif ($tipo_reporte == 'excel') {
                    $html = str_replace($header_, '', $html);
                    //echo $html; die();
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=balance_detallado_cuenta_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                         <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                         <tr><th colspan='6' align='center' >Estado de situación financiera al " . $this->convertir_fecha_larga($fecha_fin, 'al', true) . "</th></tr>
                         <tr><th colspan='6' align='center' >Valores Expresados en D&oacute;lares de los Estados Unidos</th></tr>
                         </table>";

                    echo $html;
                    die();
                }
            }
        }
    }

    public function estado_resultado_individual_acum()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $centro_costo           = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo           = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']   = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $data["titulo_personal"] = "Estado de resultados individual resumido";
            $this->_cargarvista($data);
        }
    }

    function constultar_estado_resultados_individual_acum()
    {
        $fecha_ini          = $this->input->post('fecha_ini');
        $fecha_fin          = $this->input->post('fecha_fin');
        $cuenta             = $this->input->post('cuenta');
        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : null;
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn           = date('Y-m-d', strtotime($fecha_fin));
        $where              = null;
        if ($where != null) {
            $where['pcc_id_cec']  = $slc_centro_costo;
        }

        $data['cuentas']    = $this->contabilidad_model->cuentas_balance_general_individual($fecha_inicio, $fecha_fn);
        $data['old_saldo']  = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $fecha_fn, $cuenta, $slc_centro_costo);
        $data['mov_diarios'] = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn, $where);
        $data['fecha_ini']  = $fecha_inicio;
        $data['fecha_fin']  = $fecha_fn;
        $data['centro']     = $txt_centro_costo;
        $data['pcc_id_cec'] = $slc_centro_costo;
        $respuesta = array(
            'html' => $this->load->view('modulo_contabilidad/reportes/consultar_estado_result_indi_acum', $data, true),
            'mov_diarios' => (count($data['carga_datos']) > 0) ? 1 : 0
        );
        echo json_encode($respuesta);
    }

    function imprimir_estado_resultados_individual_acum($reporte)
    {
        $fecha_ini = $this->input->post('fecha_inicio');

        $fecha_fin      = $this->input->post('fecha_fin');
        $cuenta         = $this->input->post('cuenta');
        $fecha_inicio   = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn       = date('Y-m-d', strtotime($fecha_fin));

        $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : null;
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fn           = date('Y-m-d', strtotime($fecha_fin));
        $where              = null;
        if ($where != null) {
            $where['pcc_id_cec']  = $slc_centro_costo;
        }

        $data['cuentas']    = $this->contabilidad_model->cuentas_balance_general_individual($fecha_inicio, $fecha_fn);
        $data['old_saldo']  = $this->contabilidad_model->listado_balance_comprobacion($fecha_inicio, $cuenta, $slc_centro_costo);
        $data['mov_diarios'] = $this->contabilidad_model->mov_diarios_cuentas($fecha_inicio, $fecha_fn, $where);
        //$data['todas_cuentas']=$this->contabilidad_model->todas_cuentas();
        $data['fecha_ini']  = $fecha_inicio;
        $data['fecha_fin']  = $fecha_fn;
        $data['cuenta_txt'] = $txt_centro_costo;
        $data['pcc_id_cec'] = $slc_centro_costo;
        $data['firmas']     = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
        $html   = $this->load->view('reporte/header_reportes_conta', array('titulo' => 'ESTADO DE RESULTADO<br> Al ' . $this->convertir_fecha_larga($fecha_fin, 'de', true), 'solotitulo' => true, 'subtitulo' => 'Valores expresados en D&oacute;lares de los Estados Unidos'), true);
        $header_ = $html;
        $html   .= $this->load->view('modulo_contabilidad/reportes/imprimir_estado_resultados_individual_acum', $data, true);

        if ($reporte == 1) {
            $this->load->library('pdf');
            $this->pdf->makePDF($html);
        } else {
            $html = str_replace($header_, '', $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=Estado_resultado_individual_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
              <tr><th colspan='3' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
              <tr><th colspan='3' align='center' >ESTADO DE RESULTADO</th></tr>
              <tr><th colspan='3' align='center' >" . ' AL ' . $this->convertir_fecha_larga($fecha_fin, 'de', true)  . '<br> Valores Expresados en D&oacute;lares de los Estados Unidos' . "</th></tr>
              </table>";

            echo $html;
            die();

            //$data['excel'] = 1;
            //$this->load->view('acciones_personal/consultas/print_consulta_horas', $data);
        }
    }

    public function reporte_cuentas_contables($reporte = 0)
    {

        $data['titulo_personal'] = "Reporte cuentas contables";
        $dep = 0;
        //Llenar select dependencia
        if ($dep > 0) {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), $dep, null, null, true);
        } else {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
        }
        $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
        $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";

        if ($reporte == 1) {

            $nombre = $this->input->post('hnombre');
            $nivel = $this->input->post('hnivel');
            $dependencia = $this->input->post('hdependencia');

            $where = [];
            //Crear el where para la consulta
            if ($nombre != '') {
                array_push($where, " cnt_nombre like '" . $nombre . "%'");
            }
            if ($nivel != '') {
                array_push($where, " cnt_id_nic = " . $nivel);
            }
            if ($dependencia > 0) {
                array_push($where, " cnt_id_cnt_padre = " . $dependencia);
            }

            //Tipo de reporte        
            $data['tipo_reporte'] = $this->input->post('tipo_reporte');
            //Nombre archivo
            $filename = 'rpt_cuentas_contables' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;

            $data['cuentas'] = $this->contabilidad_model->ajax_filtro_cuenta_contable($where);
            $html = $this->load->view('modulo_contabilidad/reportes/filtrar_cuentas_contables', $data, true);

            $tipo_reporte = $this->input->post('tipo_reporte');

            if ($tipo_reporte == 'pdf') {

                $data['titulo'] = 'cuentas contables';
                $data['propietario'] = $propietario;

                $header = $this->load->view('reporte/header', $data, true);

                $GLOBALS['nombre_reporte'] = 'Reporte_cuentas_contables' . date('dmY');

                $reporte = $header . $html;

                $this->pdf->makePdf($reporte, 'L', 'Reporte_cuentas_contables', 'Letter');
            } elseif ($tipo_reporte == 'excel') {

                $filename = 'rpt_cuentas_contables' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                $data['titulo'] = 'cuentas contables';

                $data['filename'] = $filename;

                echo $html;
            }
        } else {
            $this->_cargarvista(null, $data);
        }
    }

    function ajax_filtro_cuenta_contable()
    {
        $dep = 0;
        if ($_POST) {
            //Obtener valores del filtro
            $nombre = $this->input->post('nombre');
            $nivel = $this->input->post('nivel');
            $dep = $this->input->post('dependencia');

            $where = [];
            //Crear el where para la consulta
            if ($nombre != '') {
                array_push($where, "cnt_nombre like '" . $nombre . "%'");
            }
            if ($nivel != '') {
                array_push($where, "cnt_id_nic = " . $nivel);
            }
            if ($dep > 0) {
                array_push($where, "cnt_id_cnt_padre = " . $dep);
            }

            $data['cuentas'] = $this->contabilidad_model->ajax_filtro_cuenta_contable($where);
            $html = $this->load->view('modulo_contabilidad/reportes/filtrar_cuentas_contables', $data, true);
            echo $html;
            die();
        }
    }

    /**
     * Descripción:
     * Función para reporte de libro de compras
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-01-03
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    function reporte_libro_compras($flag = null){
        satelite_validar();
        $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        if ($_POST) {
            // var_dump($this->input->post());die();
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
                $desde      = ($post_array['desde'] != '') ? $post_array['desde'] : null;
                $hasta      = ($post_array['hasta'] != '') ? $post_array['hasta'] : null;
                $proveedor  = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $tif        = ($post_array['tif'] != '') ? $post_array['tif'] : null;
            } else {
                $desde                 = ($post_array['hdesde'] != '') ? $post_array['hdesde'] : null;
                $hasta                 = ($post_array['hhasta'] != '') ? $post_array['hhasta'] : null;
                $proveedor             = ($post_array['hslcProveedor'] != '') ? $post_array['hslcProveedor'] : null;
                $data['proveedortext'] = ($post_array['hslcProveedortext'] != '') ? '<b>Proveedor: </b>' . $post_array['hslcProveedortext'] : '<b>Proveedor: </b>' . 'Todos';
                $htif                  = ($post_array['hslcTif'] != '') ? $post_array['hslcTif'] : null;
            }
            $meses = array("", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
            $mes = $meses[date('n', strtotime($desde))];
            $year = date('Y', strtotime($desde));
            $data['mes']    = ($mes != '') ? '<b>MES: </b>' . $mes : '';
            $data['mes2']   = ($mes != '') ? $mes : '';
            $data['year']   = ($year != '') ? '<b>AÑO: </b>' . $year : '';
            $data['year2']  = ($year != '') ? $year : '';
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $id_tipo_factura = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_TIPO_FACTURA'));
            $id_tipo_factura_excluidos = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_TIPO_FACTURA_EXCLUIDOS'));
            $id_tipo_factura_excluidos = (trim($id_tipo_factura_excluidos) == "") ? '0' : $id_tipo_factura_excluidos;

            $where = '';
            $where2 = null;
            $where3 = '';
            if ($desde != null && $hasta != null) {
                //Se cambio a que si no hay fecha de declaracion, busque por fecha contable     
                $where  .= " DATE(IFNULL(dpv_fecha_declaracion, dpv_fecha_contabilizacion)) >='" . formatear_fecha('Y-m-d', $desde) . "'"; 
                $where  .= " AND DATE(IFNULL(dpv_fecha_declaracion, dpv_fecha_contabilizacion)) <='" . formatear_fecha('Y-m-d', $hasta) . "'";
                $where3 .= " DATE(cqc_fecha_contabilizacion) >='" . formatear_fecha('Y-m-d', $desde) . "'"; //Se cambio a que busque por fecha contable                
                $where3 .= " AND DATE(cqc_fecha_contabilizacion) <='" . formatear_fecha('Y-m-d', $hasta) . "'"; //Se cambio a que busque por fecha contable
            }
            $where_tipo_fac = "";
            if ($id_tipo_factura != null) {
                //$id_tipo_factura = (substr_count($id_tipo_factura, ',')>0)? 
                //$where .=" AND dpv1.dpv_id_tif in (".$id_tipo_factura.")";
                //$where3[0] = " AND dpv2.dpv_id_tif  IN (".$id_tipo_factura.")"; //incluidas
                $where_tipo_fac = $id_tipo_factura;
            }
            if ($id_tipo_factura_excluidos != null) {
                // $where3[1] = " AND  dpv2.dpv_id_tif IN (".$id_tipo_factura_excluidos.")"; //incluidas
                $where_tipo_fac = $where_tipo_fac . ',' . $id_tipo_factura_excluidos;
            }
            if ($where_tipo_fac != '') {
                $where .= " AND dpv1.dpv_id_tif in (" . $where_tipo_fac . ")";
                //$where3[0] = " AND dpv2.dpv_id_tif  IN (".$where_tipo_fac.")"; //incluidas y excluidas
                //$where3[1] = " AND dpv2.dpv_id_tif  IN (".$where_tipo_fac.")"; //incluidas y excluidas
            }
            if (is_array($tif) && count($tif) > 0) {
                $tif_array = implode(',', $tif);
                $where .= " AND dpv1.dpv_id_tif in (" . $tif_array . ")";
                $where3 .= " AND cqc_id_tif in (" . $tif_array . ")";
            }
            if ($htif != null) {
                $where .= " AND dpv1.dpv_id_tif in (" . $htif . ")";
                $where3 .= " AND cqc_id_tif in (" . $htif . ")";
            }
            $data['excluidas'] = explode(',', $id_tipo_factura_excluidos);
            if ($proveedor != null) {
                $where .= " AND prv1.prv_id = '" . $proveedor . "'";
                $where3 .= " AND cqc_id_prv = '" . $proveedor . "'";
            }
            $where .= " AND dpv_estado = 1";
            $where3 .= " AND cqc_estado = 1";
            $where3 .= " AND cqc_id_dpv IS NULL";
            //Obtenr los parametros            
            $data['id_pais_internas'] = explode(',', $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PAIS_INTERNA')));
            $data['id_pais_importacion'] = explode(',', $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PAIS_IMPORTACION')));
            //$data['id_pais_internacional'] = explode(',', $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_INTERNACIONAL')));
            $where2['id_nrc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_NRC'));
            $where2['id_dui'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_DUI'));
            $where2['id_nit'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_NIT'));
            $where2['id_iva']  = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_IVA'));
            $where2['id_imp_exe_internas'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_IMP_EXE_INTERNAS')); //llama los parametros de ID_IMP_EXE_INTERNAS para una nueva busqueda  ////OTROS IMPUESTOS  EJ, FOVIAL
            $where2['id_percep'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PERCEP'));////IVA PERCIBIDO
            $where2['id_retenc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_RETENC'));
            $where2['id_anticipo_cuenta'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_ANTICIPO_CUENTA'));
            $where2['id_cesc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_CESC'));
            $reporte = $this->contabilidad_model->get_libros_compras($where, $where2, null, $where3);
            //print_r($data['id_pais_internas']);die();
            $proveedores = array();
            foreach ($reporte as $key => $value) {
                $p = $value['nombre_proveedor'];
                if (!(in_array($p, $proveedores))) {
                    //$proveedores[$key] = $value['nombre_proveedor'];
                    array_push($proveedores, $p);
                }
            }
            $filename = 'rpt_libro_compras' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']               = $filename;
            $data['reporte']                = $reporte;
            $data['tipo_reporte']           = $tipo_reporte;
            $data['NIT']                    = $this->gsatelite->get_parametro('SYS_NIT');
            $data['NRC']                    = $this->gsatelite->get_parametro('SYS_REGISTRO');
            $data['empresa']                = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
            $data['direccion']              = mb_strtoupper($this->gsatelite->get_parametro('SYS_DIR'), 'UTF-8');
            $data['titulo']                 = mb_strtoupper("Libro de compras");
            $data['sub_titulo']             = "(Valores Expresados en Dólares de los E.E.U.U.)";
            $data['proveedores']            = $proveedores;
            $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
            $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
            $data['propietario']            = $propietario;
            $data['tipo_facturacion']       = $tipo_facturacion;
            $html = $this->load->view('modulo_contabilidad/reportes/filtrar_libro_compras', $data, true);

            if ($flag) {
                echo $html;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'libros compras';
                    $GLOBALS['nombre_reporte'] = 'reporte_libro_compras_' . date('dmY');
                    $reporte = $html;
                    // $margenes = array(5,10,5);
                    // $this->pdf->makePdf($reporte, 'L', 'reporte_libro_compras', 'Legal', 'I', $margenes);
                    $head = '<!DOCTYPE html><html><head><title>REPORTE LIBRO COMPRAS</title></head><body><script type="text/javascript">';
                    $head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - REPORTE LIBRO COMPRAS";';
                    $head .= 'window.print();</script>';
                    $footer = '</body></html>';
                    $impresion = $head . $reporte . $footer;
                    echo $impresion;
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_libro_compras_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'libro de compras';
                    $data['filename'] = $filename;
                    echo $html;
                }
                if ($tipo_reporte == 'csv') {
                    echo $html;
                }
            }
        } else {
            //Obtenr los parametros            
            $data['id_pais_internas']    = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PAIS_INTERNA'));
            $data['id_pais_importacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PAIS_IMPORTACION'));
            //$data['id_pais_internacional'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_INTERNACIONAL'));
            $where2['id_nrc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_NRC'));
            $where2['id_dui'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_DUI'));
            $where2['id_nit'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_NIT'));
            $where2['id_iva']    = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_IVA'));
            $where2['id_percep'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PERCEP'));
            $where2['id_retenc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_RETENC'));
            $where2['id_anticipo_cuenta'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_ANTICIPO_CUENTA'));
            $id_tipo_factura = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_TIPO_FACTURA'));
            if (($data['id_pais_internas'] == "" || $data['id_pais_internas'] == null) || ($data['id_pais_importacion'] == "" || $data['id_pais_importacion'] == null) || ($where2['id_nrc'] == "" || $where2['id_nrc'] == null) || ($where2['id_dui'] == "" || $where2['id_dui'] == null) || ($where2['id_nit'] == "" || $where2['id_nit'] == null) || ($where2['id_iva'] == "" || $where2['id_iva'] == null) || ($where2['id_percep'] == "" || $where2['id_percep'] == null) || ($where2['id_retenc'] == "" || $where2['id_retenc'] == null) || ($where2['id_anticipo_cuenta'] == "" || $where2['id_anticipo_cuenta'] == null) || ($id_tipo_factura == "" || $id_tipo_factura == null)) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reporte libro de compras", 'texto_alerta' => "Parametro requerido");
                $this->session->set_flashdata($alerta);
                redirect('/modulo_contabilidad/index');
                die();
            }
            $select = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers=1,CONCAT_WS(' ',prv_nombre,prv_apellido),prv_apellido)]", '', array("prv_estado" => 1), null, '', 'prv_id', true);
            $data["slcProveedor"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', null, '', 'suc_id', true);
            $data["slcSucursal"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $data['titulo_personal'] = "Reporte libro compras";
            $data['tipo_facturacion'] = $tipo_facturacion;
            $data['slcTif'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para reporte de libro de ventas a consumidor final
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-01-09
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    function reporte_libro_ventas_consumidor_final($flag = null)
    {
        satelite_validar();
        ini_set('memory_limit', '4048M');/////8000 IN FSV
        ini_set('max_execution_time', '9999');
        $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);///////////////////////// FACT ELECT
        if ($_POST) {
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery. De lo contrario, se toman los filtros de impresión */
            if (isset($post_array['html_reporte'])) {
                $data['html_reporte'] =  trim($post_array['html_reporte']);
            }
            if ($flag) {
                $periodo          = ($post_array['periodo'] != '') ? $post_array['periodo'] : null;
                $periodoH         = ($post_array['hasta'] != '') ? $post_array['hasta'] : null;
                $idsucursal       = ($post_array['idsucursal'] != '') ? $post_array['idsucursal'] : null;
                $idstipofactura   = (is_array($post_array['idstipofactura']) && implode(",", $post_array['idstipofactura']) != '') ? implode(",", $post_array['idstipofactura']) : null;
                $idsseriefactura  = (is_array($post_array['idsseriefactura']) && implode(",", $post_array['idsseriefactura']) != '') ? implode(",", $post_array['idsseriefactura']) : null;
                $tipo_reporte     = "";
                $filtroFecha      = $post_array['fechaFactura'];
            } else {
                $periodo          = ($post_array['hperiodo'] != '') ? $post_array['hperiodo'] : null;
                $periodoH         = ($post_array['hperiodo_hasta'] != '') ? $post_array['hperiodo_hasta'] : null;
                $idsucursal       = ($post_array['hslcSucursal'] != '') ? $post_array['hslcSucursal'] : null;
                $idstipofactura   = ($post_array['hslcTipoFactura'] != '') ? $post_array['hslcTipoFactura'] : null;
                $idsseriefactura  = ($post_array['hslcSerieFactura'] != '') ? $post_array['hslcSerieFactura'] : null;
                $filtroFecha      = $post_array['hdnFechaFactura'];
                $data['seriefacturatext'] = ($post_array['hslcSerieFacturatext'] != '') ? '<b>Serie: </b>' . $post_array['hslcSerieFacturatext'] : '<b>Serie: </b>' . 'Todos';
                $data['tipofacturatext']  = ($post_array['hslcTipoFacturatext'] != '') ? '<b>Tipo Factura: </b>' . $post_array['hslcTipoFacturatext'] : '<b>Tipo Factura: </b>' . 'Todos';
                $data['sucursaltext']     = ($post_array['hslcSucursaltext'] != '') ? '<b>Sucursal: </b>' . $post_array['hslcSucursaltext'] : '<b>Sucursal: </b>' . 'Todos';
                $meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
                $mes1 = $meses[date('n', strtotime($periodo)) - 1];
                $mes2 = $meses[date('n', strtotime($periodoH)) - 1];
                $year1 = date('Y', strtotime($periodo));
                $year2 = date('Y', strtotime($periodoH));
                $d1 = date('d', strtotime($periodo));
                $d2 = date('d', strtotime($periodoH));
                $data['periodotext'] = ($periodo != '') ? '<b>PERÍODO:  </b>' . formatear_fecha('d-m-Y', $periodo) .' / ' . formatear_fecha('d-m-Y', $periodoH) : '';
                $tipo_reporte = $this->input->post('tipo_reporte'); //Tipo de Reportes si sera Excel o Pdf
            }
            $where = '';
            $where2 = null;
            $where_oficial = array();
            $whereAnulaOld = array('fac_estado' => 0);
            if ($periodo != null && $periodoH != null) {
                $filtroFecha = ($tipo_fact_elect == 1 && $tipo_reporte == "csv") ? 0 : $filtroFecha;//////// temporal??
                $fdesde = formatear_fecha('Y-m-d', $periodo);
                $fhasta = formatear_fecha('Y-m-d', $periodoH);
                $tmp_periodo = date('Y-m', strtotime("01-" . $periodo));
                $aux         = date('Y-m-d', strtotime("{$tmp_periodo} + 1 month"));
                $last_day    = date('Y-m-d', strtotime("{$aux} - 1 day"));
                // Se verifica el Flag de las Fechas
                if ($filtroFecha == 1) {
                    $where      .= " DATE(fac1.fac_fecha_fact) >= '$fdesde'";
                    $where      .= " AND DATE(fac1.fac_fecha_fact) <= '$fhasta'";
                    $where_oficial['DATE(fac_fecha_fact) >='] = formatear_fecha('Y-m-d', $fdesde);
                    $where_oficial['DATE(fac_fecha_fact) <='] = formatear_fecha('Y-m-d', $fhasta);
                    $whereAnulaOld['DATE(fac_fecha_cont) < '] = formatear_fecha('Y-m-d', $fdesde);
                    $whereAnulaOld['DATE(fac_fecha_anulacion) >= '] = formatear_fecha('Y-m-d', $fdesde);
                    $whereAnulaOld['DATE(fac_fecha_anulacion) <= '] = formatear_fecha('Y-m-d', $fhasta);
                } else {
                    if ($tipo_fact_elect == 1) {
                        $where_oficial['DATE(fac_fecha_fact) >='] = formatear_fecha('Y-m-d', $fdesde);
                        $where_oficial['DATE(fac_fecha_fact) <='] = formatear_fecha('Y-m-d', $fhasta);
                    } else {
                    $where      .= " DATE(fac1.fac_fecha_crea) >= '$fdesde'";
                    $where      .= " AND DATE(fac1.fac_fecha_crea) <= '$fhasta'";
                    $where_oficial['DATE(fac_fecha_crea) >='] = formatear_fecha('Y-m-d', $fdesde);
                    $where_oficial['DATE(fac_fecha_crea) <='] = formatear_fecha('Y-m-d', $fhasta);
                    }                    
                }
            }
            if ($idstipofactura != null) {
                $where .= " AND fac1.fac_id_tif IN (" . $idstipofactura . ")";
                $where_oficial["fac_id_tif IN (" . $idstipofactura . ")"] = null;
                $whereAnulaOld["fac_id_tif IN (" . $idstipofactura . ")"] = null;
            }
            if ($idsseriefactura != null) {
                $where .= " AND cof1.cof_id_sef IN (" . $idsseriefactura . ")";
                $where_oficial["cof_id_sef IN (" . $idsseriefactura . ")"] = null;
            }
            if ($idsucursal != null) {
                $where .= " AND fac1.fac_id_suc = '" . $idsucursal . "'";
                $where_oficial['fac_id_suc'] = $idsucursal;
                $whereAnulaOld['fac_id_suc'] = $idsucursal;
            }
            //$where .= " AND fac1.fac_estado != 0";//Estado 0 es anulada
            //Obtenr los parametros
            $id_tif_exportacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL', null, null, array('ID_TIF_EXPORTACION'));
            $where_oficial['ids_exportacion'] = $where2['id_tif_exportacion'] = $id_tif_exportacion;
            $whereAnulaOld['ids_exportacion'] = $id_tif_exportacion;
            //if($data['html_reporte'] == '') {
            if ($tipo_fact_elect == 1 && $filtroFecha != 1) {
                $reporte = $this->contabilidad_model->get_libros_ventas_agrupado($where_oficial);
            } else {
                $reporte = $this->contabilidad_model->get_libros_ventas($where_oficial);
            }            
            $nfilas = count($reporte); /* SI SON DEMASIADAS FILAS Y EL NAVEGADOR SE QUEDA SIN MEMORIA, SE LIMITA QUE SOLO SE PUEDA EXPORTAR A EXCEL */
            if ($flag) {
                $aplica = ($nfilas > 15000) ? false : true;  /* PENDIENTE PARAMETRIZARY CAMBIAR SEGUN LAS PRESTACIONES DEL SERVIDOR EJ. FSV 40MIL */
            } else {
                if ($tipo_reporte == 'pdf') {
                    $aplica = ($nfilas > 1000) ? false : true;  /* CAMBIAR SEGUN LAS PRESTACIONES DEL SERVIDOR EJ. FSV 10MIL */
                } else {
                    $aplica = true; /* EXPORTAR DIRECTO A EXCEL DE UNA VEZ BAJA LA DATA */
                }
            }
            $filename             = 'rpt_libro_ventas' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']     = $filename;
            $data['reporte']      = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['NIT']          = $this->gsatelite->get_parametro('SYS_NIT');
            $data['NRC']          = $this->gsatelite->get_parametro('SYS_REGISTRO');
            $data['firmas']       = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
            $data['empresa']      = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
            $data['titulo']       = "Libro de ventas de consumidor final";
            $data['sub_titulo']   = "(Valores Expresados en Dólares de los E.E.U.U.)";
            $data['tipo_fecha']   = $filtroFecha;
            $data['id_tif_expt']   = $id_tif_exportacion;
            $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
            $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
            $data['propietario']   = $propietario;
            $data['esf_elect']     = $tipo_fact_elect;
            if ($aplica) {
                /* SI SE PUEDE MOSTRAR LA VISTA SEGUN LA CANTIDAD DE REGISTROS */
                $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
                if ($empresa == 'sersaprosa') {
                    $data['anula_reporte'] = $this->contabilidad_model->get_libros_ventas($whereAnulaOld);
                    $html = $this->load->view('modulo_contabilidad/reportes/filtrar_libro_ventas_sersaprosa', $data, true);
                } else {
                $html                 = $this->load->view('modulo_contabilidad/reportes/filtrar_libro_ventas_new', $data, true);            
                }
            } else {
                $html = '';
                // $html = '<table cellpadding="2" id="tblListado" class="dynamicTable responsive table table-bordered">';
                // $html .= '<thead><tr style="text-align:center;"><th>No es posible mostrar la información en pantalla debido a la cantidad de registros. Unicamente puede exportarlos';
                // $html .= '</th></tr></thead></table>';
            }
            //}  else  {
            //print_r($data['html_reporte']); die('llego');
            //$reporte                        = array();       
            //$filename                       = 'rpt_libro_ventas' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);//OKI
            //$data['filename']               = $filename; //OKI
            //$data['reporte']                = $reporte; //OKI
            //$data['tipo_reporte']           = $tipo_reporte;//OKI
            //$data['NIT']                    = $this->gsatelite->get_parametro('SYS_NIT');//OKI
            //$data['NRC']                    = $this->gsatelite->get_parametro('SYS_REGISTRO');//OKI
            //$data['firmas']                 = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD'))); //OKI
            //$data['empresa']                = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); //OKI
            //$data['titulo']                 = "Libro de ventas de consumidor final";//OKI
            //$data['sub_titulo']             = "(Valores Expresados en Dólares de los E.E.U.U.)"; // OKI
            //$html = $this->load->view('modulo_contabilidad/reportes/filtrar_libro_ventas_new', $data, true);
            //}
            if ($flag) {
                echo json_encode(array("tabla" => trim($html), "filas" => $nfilas));
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo']             = 'libros ventas a consumidor final';
                    $GLOBALS['nombre_reporte']  = 'reporte_libro_ventas_consumidor_final_' . date('dmY');
                    $reporte                    = $html;
                    //$margenes                 = array(10,0,10);
                    $this->pdf->makePdf($reporte, 'L', '', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename           = 'rpt_libro_compras_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo']     = 'libro de ventas cosumidor final';
                    $data['filename']   = $filename;

                    echo $html;
                }
            }
        } else {
            //Obtenr los parametros            
            /*$data['id_pais_internas'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_INTERNA'));
            $data['id_pais_importacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_IMPORTACION'));
            $data['id_pais_internacional'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_INTERNACIONAL'));
            $where2['id_nrc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_NRC'));
            $where2['id_dui'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_DUI'));
            $where2['id_nit'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_NIT'));
            $where2['id_iva']  = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_IVA'));
            $where2['id_percep'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PERCEP'));
            $where2['id_retenc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_RETENC'));
            $where2['id_anticipo_cuenta'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_ANTICIPO_CUENTA'));                        
            */
            $data['id_tif_exportacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL', null, null, array('ID_TIF_EXPORTACION'));

            if ($data['id_tif_exportacion'] == "" || $data['id_tif_exportacion'] == null) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reporte libro de ventas", 'texto_alerta' => "Parametro requerido");
                $this->session->set_flashdata($alerta);
                redirect('/modulo_contabilidad/index');
                die();
            }
            $data['esf_elect']          = $tipo_fact_elect;
            $data['f_elect']            = $tipo_fact_elect;
            $select                     = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
            $data["slcTipoFactura"]     = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $select                     = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', null, '', 'suc_id', true);
            $data["slcSucursal"]        = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $data['titulo_personal']    = "Reporte libro de ventas consumidor final";
            $this->_cargarvista($data);
        }
    }

    public function ajax_serie_factura()
    {
        if ($_POST) {
            //Obtener valores del filtro
            $idtipofactura = $this->input->post('idtipofactura');

            $where = null;
            $where_in = null;
            $where['tif_estado'] = 1;
            $where['sef_estado'] = 1;
            //Crear el where para la consulta
            if ($idtipofactura != '') {
                $where_in['idtipofactura'] = $idtipofactura;
            }

            $series = $this->contabilidad_model->ajax_serie_por_factura($where, $where_in);

            $option = '<option value=""></option>';
            foreach ($series as $key => $serie) {
                $option .= '<option value="' . $serie['sef_id'] . '">' . $serie['sef_nombre'] . '</option>';
            }

            echo $option;
            die();
        }
    }

    /**
     * Descripción:
     * Función para convertir de fecha resumida (20/12/2015) a fecha extendida (20 de diciembre de 2015)
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-01-12
     * @param $fecha = Es la fecha a convertir, $complemento = Es el string entre dia y mes , y entre mes anio
     * @param $completa = Deternina si se devuelve un string con la fecha completa o los segmentos del dia, mes y anio
     * @return Retorna la fecha en formato largo ya sea en un solo string o en segmentos dentro de un array
     */
    public function convertir_fecha_larga($fecha, $complemento = null, $completa = null)
    {
        $meses_array = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
        $fecha_larga = [];

        $fecha_larga['dia'] = formatear_fecha('d', $fecha) . ' ' . $complemento;
        $fecha_larga['mes'] = $meses_array[(intval(formatear_fecha('m', $fecha)))] . ' ' . $complemento;
        $fecha_larga['anio'] = formatear_fecha('Y', $fecha);
        if ($completa) {
            return $fecha_larga['dia'] . ' ' . $fecha_larga['mes'] . ' ' . $fecha_larga['anio'];
        } else {
            return $fecha_larga;
        }
    }

    /**
     * Descripción:
     * Función para convertir de fecha resumida (20/12/2015) a fecha extendida (20 de diciembre de 2015)
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-01-24     
     * @return Redireccio al vista con filtros del reporte
     */
    public function reporte_libro_ventas_al_contribuyente($flag = null)
    {
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        if ($_POST) {
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery. De lo contrario, se toman los filtros de impresión */
            if ($flag) {
                $periodo         = ($post_array['periodo'] != '') ? $post_array['periodo'] : null;
                $periodoH        = ($post_array['hasta'] != '') ? $post_array['hasta'] : null;
                $idsucursal      = ($post_array['idsucursal'] != '') ? $post_array['idsucursal'] : null;
                $idstipofactura  = (is_array($post_array['idstipofactura']) && implode(",", $post_array['idstipofactura']) != '') ? implode(",", $post_array['idstipofactura']) : null;
                $idsseriefactura = (is_array($post_array['idsseriefactura']) && implode(",", $post_array['idsseriefactura']) != '') ? implode(",", $post_array['idsseriefactura']) : null;
                $tipo_reporte    = "";
            } else {
                $periodo         = ($post_array['hperiodo'] != '') ? $post_array['hperiodo'] : null;
                $periodoH         = ($post_array['hperiodo_hasta'] != '') ? $post_array['hperiodo_hasta'] : null;
                $idsucursal      = ($post_array['hslcSucursal'] != '') ? $post_array['hslcSucursal'] : null;
                $idstipofactura  = ($post_array['hslcTipoFactura'] != '') ? $post_array['hslcTipoFactura'] : null;
                $idsseriefactura = ($post_array['hslcSerieFactura'] != '') ? $post_array['hslcSerieFactura'] : null;
                $idsseriefacturatext = ($post_array['hslcSerieFacturatext'] != '') ? '<b>Serie: </b>' . $post_array['hslcSerieFacturatext'] : '<b>Serie: </b>' . 'Todos';
                $idstipofacturatext  = ($post_array['hslcTipoFacturatext'] != '') ? '<b>Tipo Factura: </b>' . $post_array['hslcTipoFacturatext'] : '<b>Tipo Factura: </b>' . 'Todos';
                $data['seriefacturatext'] = $idsseriefacturatext;
                $data['tipofacturatext']  = $idstipofacturatext;
                $data['sucursaltext']     = ($post_array['hslcSucursaltext'] != '') ? '<b>Sucursal: </b>' . $post_array['hslcSucursaltext'] : '<b>Sucursal: </b>' . 'Todos';
                $meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
                $mes = $meses[date('n', strtotime($periodo)) - 1];
                $year = date('Y', strtotime($periodo));
                $data['mes']    = ($mes != '') ? '<b>Desde: </b>' . formatear_fecha('d/m/Y',$periodo).' ' : '';
                $data['year']   = ($year != '') ? '<b>Hasta: </b>' . formatear_fecha('d/m/Y',$periodoH) : '';
                $tipo_reporte = $this->input->post('tipo_reporte'); //Tipo de Reportes si sera Excel o Pdf
            }
            $where = '';
            $where2 = null;
            if ($periodo != null && $periodoH != null) {
                $fdesde = formatear_fecha('Y-m-d', $periodo);
                $fhasta = formatear_fecha('Y-m-d', $periodoH);
                $tmp_periodo = date('Y-m', strtotime("01-" . $periodo));
                $aux         = date('Y-m-d', strtotime("{$tmp_periodo} + 1 month"));
                $last_day    = date('Y-m-d', strtotime("{$aux} - 1 day"));
                $where      .= " DATE(fac1.fac_fecha_fact) >= '$fdesde'";
                $where      .= " AND DATE(fac1.fac_fecha_fact) <= '$fhasta'";
            }

            if ($idstipofactura != null) {
                $where .= " AND fac1.fac_id_tif IN (" . $idstipofactura . ")";
            }

            if ($idsseriefactura != null) {
                $where .= " AND cof1.cof_id_sef IN (" . $idsseriefactura . ")";
            }

            if ($idsucursal != null) {
                $where .= " AND fac1.fac_id_suc = '" . $idsucursal . "'";
            }
            //$where .= " AND fac1.fac_estado != 0";//Estado 0 es anulada
            //Obtenr los parametros                        
            $where2['id_tif_exportacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL', null, null, array('ID_TIF_EXPORTACION'));
            $reporte = $this->contabilidad_model->get_libros_ventas_al_contribuyente($where, $where2);
            $filename = 'rpt_libro_ventas' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['reporte']        = $reporte;
            $data['tipo_reporte']   = $tipo_reporte;
            $data['NIT']            = $this->gsatelite->get_parametro('SYS_NIT');
            $data['NRC']            = $this->gsatelite->get_parametro('SYS_REGISTRO');
            $data['firmas']         = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
            $data['tipos_facturas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS')), true);
            $data['empresa']        = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
            $data['esf_elect']      = $tipo_fact_elect;
            $data['titulo']         = "Libro de ventas a contribuyentes";
            $data['sub_titulo']     = "(Valores Expresados en Dólares de los E.E.U.U.)";
            $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
            $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
            $data['propietario']    = $propietario;
            $html = $this->load->view('modulo_contabilidad/reportes/filtrar_libro_ventas_al_contribuyente', $data, true);
            if ($flag) {
                echo $html;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'ventas a contribuyentes';
                    $GLOBALS['nombre_reporte'] = 'reporte_libro_iva_al_contribuyente' . date('dmY');
                    $reporte = $html;
                    $margenes = array(10, 10, 10);
                    $this->pdf->makePdf($reporte, 'L', 'reporte_libro_iva_al_contribuyente', 'Letter', 'I', $margenes);
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_libro_compras_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Reporte de ventas a contribuyentes';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        } else {
            //Obtenr los parametros            
            /*$data['id_pais_internas'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_INTERNA'));
            $data['id_pais_importacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_IMPORTACION'));
            $data['id_pais_internacional'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PAIS_INTERNACIONAL'));
            $where2['id_nrc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_NRC'));
            $where2['id_dui'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_DUI'));
            $where2['id_nit'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_NIT'));
            $where2['id_iva']  = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_IVA'));
            $where2['id_percep'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_PERCEP'));
            $where2['id_retenc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_RETENC'));
            $where2['id_anticipo_cuenta'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA',null,null,array('ID_ANTICIPO_CUENTA'));                        
            */
            $data['id_tif_exportacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL', null, null, array('ID_TIF_EXPORTACION'));
            if ($data['id_tif_exportacion'] == "" || $data['id_tif_exportacion'] == null) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reporte libro de iva al contribuyente", 'texto_alerta' => "Parametro requerido");
                $this->session->set_flashdata($alerta);
                redirect('/modulo_contabilidad/index');
                die();
            }
            $select = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1, 'tif_aplica_venta' => 1), null, '', 'tif_id', true);
            $data["slcTipoFactura"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', null, '', 'suc_id', true);
            $data["slcSucursal"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $data['esf_elect'] = $tipo_fact_elect;
            $data['titulo_personal'] = "Reporte de ventas a contribuyentes";
            $this->_cargarvista($data);
        }
    }

    public function estado_resultado_segmentado()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
            } else {
                $data["centro_costo"] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', null, null, '', 'cec_id', true);
                $data["titulo_personal"] = "Reporte estado de resultados segmentado";
                $this->_cargarvista($data);
            }
        }
    }

    function consultar_estado_resultado_segmentado($flag = null)
    {
        /************************************************************************************/
        $post_array = $this->input->post();
        /*
         * Si es consulta ajax se toman los nombres del Jquery
         * De lo contrario, se toman los filtros de impresión
        */
        if ($flag) {
            $fecha_ini     = ($post_array['fecha_ini'] != '') ? $post_array['fecha_ini'] : null;
            $fecha_fin      = ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
            $centro_costo   = ($post_array['centro_costo'] != '') ? $post_array['centro_costo'] : null;
            $flag_mostar_porcentaje   = ($post_array['mostrar_porcentaje'] != '') ? $post_array['mostrar_porcentaje'] : null;
        } else {
            $fecha_ini     = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
            $fecha_fin      = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;
            $centro_costo   = ($post_array['hslcCentroCosto'] != '') ? $post_array['hslcCentroCosto'] : null;
            $flag_mostar_porcentaje   = ($post_array['mostar_oculto'] != '') ? $post_array['mostar_oculto'] : null;
        }

        $fecha_inicio       = date('Y-m-d', strtotime($fecha_ini));
        $fecha_fin          = date('Y-m-d', strtotime($fecha_fin));
        $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        if ($fecha_inicio != '') {
            $where['DATE(pct_fecha) >='] = $fecha_inicio;
        }
        if ($fecha_fin != '') {
            $where['DATE(pct_fecha) <='] = $fecha_fin;
        }
        if ($centro_costo != '' && $centro_costo > 0) {
            $where['fac_id_cec'] = $centro_costo;
            $array_cec = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_id' => $centro_costo));
            $reporte[] = $this->estado_resultado_centro_costo($where, $array_cec[0]['cec_nombre']);
        } else {
            $reporte = [];
            $array_cec = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_estado' => 1));
            foreach ($array_cec as $key => $cec) {
                $where['fac_id_cec'] = $cec['cec_id'];
                $centro_costo_nombre = $cec['cec_nombre'];
                array_push($reporte, $this->estado_resultado_centro_costo($where, $centro_costo_nombre));
            }
        }

        /************************************************************************************/

        /******************************************************************************/
        $fec_i = $this->convertir_fecha_larga($fecha_inicio, false, false);
        $fec_f = $this->convertir_fecha_larga($fecha_fin, false, false);
        $data['flag_mostar_porcentaje'] = $flag_mostar_porcentaje;

        //Tipo de Reportes si sera Excel o Pdf
        $tipo_reporte = $this->input->post('tipo_reporte');
        $filename = 'rpt_estado_resultado_segmentado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename']       = $filename;
        $data['reportes']       = $reporte;
        $data['tipo_reporte']   = $tipo_reporte;
        $data['centro']         = $txt_centro_costo;
        $data['fecha']          = 'PERIODO DEL ' . $fec_i['dia'] . ' DE ' . strtoupper($fec_i['mes']) . ' AL ' . $fec_f['dia'] . ' DE ' . strtoupper($fec_f['mes']) . ' DE ' . $fec_f['anio'];
        $html = $this->load->view('modulo_contabilidad/reportes/filtrar_estado_resultado_segmentado', $data, true);

        if ($flag) {
            echo $html;
            die();
        } else {

            if ($tipo_reporte == 'pdf') {

                $data['titulo'] = 'Estado de resultado segmentado';

                $header = $this->load->view('reporte/header', $data, true);

                $GLOBALS['nombre_reporte'] = 'estado_resultado_segmentado' . date('dmY');

                $reporte = $header . $html;

                $this->pdf->makePdf($reporte, 'L', 'reporte_estado_resultado_segmentado', 'Letter');
            } elseif ($tipo_reporte == 'excel') {

                $filename = 'rpt_estado_resultado_segmentado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                $data['titulo'] = 'Estado resultado segmentado';

                $data['filename'] = $filename;

                echo $html;
            }
        }
        /******************************************************************************/
    }

    function reporte_estado_resultado_segmentado($es_excel = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                print_r($_POST);
                die();
                $fecha_ini = $this->input->post('fecha_inicio');
                $fecha_fin = $this->input->post('fecha_fin');
                $flag_cuenta_cero = $this->input->post('cuentas_con_cero');

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
                    $fecha_fn = date('Y-m-d', strtotime($fecha_fin));

                    $fecha_inicio_impri = date('d/m/Y', strtotime($fecha_ini));
                    $fecha_fn_impri = date('d/m/Y', strtotime($fecha_fin));
                }

                $cuentas = $this->contabilidad_model->get_cuentas_padre();

                $header = $this->load->view('reporte/header_reportes_conta', array('titulo' => "BALANCE DE COMPROBACI&Oacute;N <br> AL " . $this->convertir_fecha_larga($fecha_fn_impri, 'de', true) . "", 'solotitulo' => true, 'subtitulo' => '<br> Valores Expresados en D&oacute;lares de los Estados Unidos'), true);

                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header'] = $rows;
                $data['table_tbody'] = $cadena;
                $data['tabla_info'] = $info;
                $data['filename'] = $filename;

                //$data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));

                if ($es_excel) {
                    $html = $this->load->view('modulo_contabilidad/reportes/reporte_comprobacion_pdf.php', $data, true);
                    $html = str_replace($rows, '', $html);
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=reporte_comprobacion_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                      <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='6' align='center' > BALANCE DE COMPROBACI&Oacute;N <br> AL " .  $this->convertir_fecha_larga($fecha_fn_impri, 'de', true)  .  "</th></tr>
                      </table>";

                    echo $html;
                    die();
                }

                $this->pdf->reportePDF('modulo_contabilidad/reportes/reporte_comprobacion_pdf.php', $data);
            }
        }
    }

    public function get_total_cuentapadre_cuentashijas($id_cuentapadre, $where)
    {
        $cuentas = $this->contabilidad_model->get_cuentas_padre();
        $padres = array();

        $padres[] = $id_cuentapadre;
        //print_r($padres);
        $ids = $this->get_id_subcuentas_x_partidas($padres);
        //print_r($total); die();
        $array_id = explode('%', $ids);
        $new_array_id = array_filter($array_id);
        array_push($new_array_id, $id_cuentapadre);
        $total = $this->contabilidad_model->get_total_cuentapadre_cuentashijas($new_array_id, $where);
        return $total;
    }

    function get_id_subcuentas_x_partidas($padres)
    {
        //print_r($padres);
        $arreglo_id = '';
        foreach ($padres as $key => $padre) {
            $where['cnt_id_cnt_padre'] = $padre;
            $hijos = $this->contabilidad_model->get_cuenta_hijas($where);
            $padres = array();
            foreach ($hijos as $key) {
                $padres[] = $key['cnt_id'];
                $arreglo_id .= $key['cnt_id'] . '%';
            }

            $arreglo_id .= $this->get_id_subcuentas_x_partidas($padres);
        }
        return $arreglo_id;
    }

    function estado_resultado_centro_costo($where, $cec_nombre)
    {
        $resultado = [];
        /**Ventas locales**/
        $venta_local_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('VENTA_LOCAL'));
        $total_venta_local = $this->get_total_cuentapadre_cuentashijas($venta_local_id, $where);
        /**Ventas Recintos Fiscales**/
        $recinto_fiscal_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('RECINTO_FISCAL'));
        $total_recinto_fiscal = $this->get_total_cuentapadre_cuentashijas($recinto_fiscal_id, $where);
        /**Ventas honduras**/
        $venta_honduras_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('VENTA_HONDURAS'));
        $total_venta_honduras = $this->get_total_cuentapadre_cuentashijas($venta_honduras_id, $where);
        /**Ventas guatemala**/
        $venta_guatemala_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('VENTA_GUATEMALA'));
        $total_venta_guatemala = $this->get_total_cuentapadre_cuentashijas($venta_guatemala_id, $where);
        /**Ventas nicaragua**/
        $venta_nicaragua_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('VENTA_NICARAGUA'));
        $total_venta_nicaragua = $this->get_total_cuentapadre_cuentashijas($venta_nicaragua_id, $where);
        /**Ventas panama**/
        $venta_panama_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('VENTA_PANAMA'));
        $total_venta_panama = $this->get_total_cuentapadre_cuentashijas($venta_panama_id, $where);
        /**Rebajas y devoluciones sobre ventas**/
        $rebajas_sobre_ventas_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('REBAJAS_SOBRE_VENTA'));
        $total_rebajas_sobre_ventas = $this->get_total_cuentapadre_cuentashijas($rebajas_sobre_ventas_id, $where);
        /**Rebajas y devoluciones del exterior**/
        $rebajas_exterior_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('REBAJAS_EXTERIOR'));
        $total_rebajas_exterior = $this->get_total_cuentapadre_cuentashijas($rebajas_exterior_id, $where);

        /**Costo de ventas internas**/
        $costo_venta_local_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('COSTO_VENTA_LOCAL'));
        $total_costo_venta_local = $this->get_total_cuentapadre_cuentashijas($costo_venta_local_id, $where);
        /**Costo de ventas recintos fiscales**/
        $costo_venta_recinto_fical_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('COSTO_VENTA_RECINTO_FISCAL'));
        $total_costo_venta_recinto_fiscal = $this->get_total_cuentapadre_cuentashijas($costo_venta_recinto_fical_id, $where);
        /**Costo de ventas Honduras**/
        $costo_venta_honduras_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('COSTO_VENTA_HONDURAS'));
        $total_costo_venta_honduras = $this->get_total_cuentapadre_cuentashijas($costo_venta_honduras_id, $where);
        /**Costo de ventas Guatemala**/
        $costo_venta_guatemala_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('COSTO_VENTA_GUATEMALA'));
        $total_costo_venta_guatemala = $this->get_total_cuentapadre_cuentashijas($costo_venta_guatemala_id, $where);
        /**Costo de ventas Nicaragua**/
        $costo_venta_nicaragua_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('COSTO_VENTA_NICARAGUA'));
        $total_costo_venta_nicaragua = $this->get_total_cuentapadre_cuentashijas($costo_venta_nicaragua_id, $where);
        /**Costo de ventas Panama**/
        $costo_venta_panama_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('COSTO_VENTA_PANAMA'));
        $total_costo_venta_panama = $this->get_total_cuentapadre_cuentashijas($costo_venta_panama_id, $where);
        /**Costo de ventas Otros ingresos**/
        $otros_ingresos_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('OTROS_INGRESOS'));
        $total_otros_ingresos = $this->get_total_cuentapadre_cuentashijas($otros_ingresos_id, $where);
        /**Costo de ventas Otros costos**/
        //$otros_costos_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO',null,null,array('OTROS_COSTOS'));
        //$total_otros_costos = $this->get_total_cuentapadre_cuentashijas($otros_costos_id);
        /**Gastos de venta**/
        $gastos_venta_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('GASTOS_VENTA'));
        $total_gastos_venta = $this->get_total_cuentapadre_cuentashijas($gastos_venta_id, $where);
        /**Gastos de administracion**/
        $gastos_administracion_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('GASTOS_ADMINISTRACION'));
        $total_gastos_administracion = $this->get_total_cuentapadre_cuentashijas($gastos_administracion_id, $where);
        /**Gastos de financieros**/
        $gastos_financieros_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO', null, null, array('GASTOS_FINANCIEROS'));
        $total_gastos_financieros = $this->get_total_cuentapadre_cuentashijas($gastos_financieros_id, $where);
        /**Gastos extraordinarios**/
        //$gastos_extraordinarios_id = $this->gsatelite->get_parametro('SYS_ESTADO_RESULTADO_SEGMENTADO',null,null,array('GASTOS_EXTRAORDINARIOS'));
        //$total_gastos_extraordinarios = $this->get_total_cuentapadre_cuentashijas($gastos_extraordinarios_id);                                    
        $resultado['centro_costo_nombre'] = $cec_nombre;
        $resultado['total_venta_local'] = $total_venta_local[0]['total'];
        $resultado['total_recinto_fiscal'] = $total_recinto_fiscal[0]['total'];
        $resultado['total_venta_honduras'] = $total_venta_honduras[0]['total'];
        $resultado['total_venta_guatemala'] = $total_venta_guatemala[0]['total'];
        $resultado['total_venta_nicaragua'] = $total_venta_nicaragua[0]['total'];
        $resultado['total_venta_panama'] = $total_venta_panama[0]['total'];
        $resultado['ventas_totales'] = $total_venta_local[0]['total'] + $total_recinto_fiscal[0]['total'] + $total_venta_honduras[0]['total'] + $total_venta_guatemala[0]['total'] + $total_venta_nicaragua[0]['total'] + $total_venta_panama[0]['total'];

        $resultado['total_rebajas_sobre_ventas'] = $total_rebajas_sobre_ventas[0]['total'];
        $resultado['total_rebajas_exterior'] = $total_rebajas_exterior[0]['total'];
        $resultado['rebajas_totales'] = $total_rebajas_sobre_ventas[0]['total'] + $total_rebajas_exterior[0]['total'];
        $resultado['ventas_netas'] = $resultado['ventas_totales'] - $resultado['rebajas_totales'];

        $resultado['total_costo_venta_local'] = $total_costo_venta_local[0]['total'];
        $resultado['total_costo_venta_recinto_fiscal'] = $total_costo_venta_recinto_fiscal[0]['total'];
        $resultado['total_costo_venta_honduras'] = $total_costo_venta_honduras[0]['total'];
        $resultado['total_costo_venta_guatemala'] = $total_costo_venta_guatemala[0]['total'];
        $resultado['total_costo_venta_nicaragua'] = $total_costo_venta_nicaragua[0]['total'];
        $resultado['total_costo_venta_panama'] = $total_costo_venta_panama[0]['total'];
        $resultado['costos_ventas'] = $total_costo_venta_local[0]['total'] + $total_costo_venta_recinto_fiscal[0]['total'] + $total_costo_venta_honduras[0]['total'] + $total_costo_venta_guatemala[0]['total'] + $total_costo_venta_nicaragua[0]['total'] + $total_costo_venta_panama[0]['total'];

        $resultado['total_otros_ingresos'] = $total_otros_ingresos[0]['total'];
        $resultado['utilidad_bruta'] = $resultado['ventas_netas'] + $resultado['total_otros_ingresos'];
        $resultado['utilidad_comercial'] = $resultado['ventas_netas'] - $resultado['costos_ventas'];

        $resultado['total_gastos_venta'] = $total_gastos_venta[0]['total'];
        $resultado['total_gastos_administracion'] = $total_gastos_administracion[0]['total'];
        $resultado['total_gastos_financieros'] = $total_gastos_financieros[0]['total'];
        $resultado['total_gastos_extraordinarios'] = 0.00;
        $resultado['gastos_operacion'] = $resultado['total_gastos_venta'] + $resultado['total_gastos_administracion'] + $resultado['total_gastos_financieros'] + $resultado['total_gastos_extraordinarios'];
        $resultado['utilidad_operacion'] = $resultado['utilidad_comercial'] - $resultado['gastos_operacion'];

        $resultado['ingresos_extraordinarios'] = 0.00;
        $resultado['gastos_extraordinarios'] = 0.00;
        $resultado['variaciones_presupuesto'] = 0.00;
        $resultado['variaciones_ajuste_inventarios'] = 0.00;
        $resultado['resultado_operacion'] = 0.00;

        return $resultado;
    }

    /*************************************************************************************************/
    /**
     * Descripción:
     * Función para convertir de fecha resumida (20/12/2015) a fecha extendida (20 de diciembre de 2015)
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-01-24     
     * @return Redireccio al vista con filtros del reporte
     */
    public function reporte_consolidacion_partidas($flag = null)
    {
        satelite_validar();
        if ($_POST) {

            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
                $fecha_inicio     = ($post_array['fecha_desde'] != '') ? $post_array['fecha_desde'] : null;
                $fecha_fin        = ($post_array['fecha_hasta'] != '') ? $post_array['fecha_hasta'] : null;
                $idtipopartida    = ($post_array['idtipopartida'] != '') ? $post_array['idtipopartida'] : null;
            } else {
                $fecha_inicio = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
                $fecha_fin    = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;
                $idtipopartida    = ($post_array['hslcTipoPartida'] != '') ? $post_array['hslcTipoPartida'] : null;

                //Filtros pdf y excel
                $data['tipopartidatext']    = ($post_array['hslcTipoPartidatext'] != '') ? '<b>TIPO: </b>' . $post_array['hslcTipoPartidatext'] : '<b>TIPO: </b>' . 'Todos';
                $data['fecha_iniciotext']  = ($fecha_inicio != '') ? '<b>PARTIDA DESDE: </b>' . formatear_fecha('d-m-Y', $fecha_inicio) : '';
                $data['fecha_fintext']     = ($fecha_fin != '') ? '<b>PARTIDA HASTA: </b>' . formatear_fecha('d-m-Y', $fecha_fin) : '';
            }

            $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
            $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where['pct_estado'] = 1;


            if ($fecha_inicio != null) {
                $where['DATE(pct_fecha) >='] = formatear_fecha('Y-m-d', $fecha_inicio);
            }

            if ($fecha_fin != null) {
                $where['DATE(pct_fecha) <='] = formatear_fecha('Y-m-d', $fecha_fin);
            }

            if ($idtipopartida != null) {
                $where['pct_id_tpd'] = $idtipopartida;
            }

            if ($slc_centro_costo != "") {
                $where['pcc_id_cec'] = $slc_centro_costo;
            }

            $reporte = $this->contabilidad_model->get_total_cuentas_partida_consolidada($where);

            $filename = 'rpt_consolidacion_partidas' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']           = $filename;
            $data['reporte']            = $reporte;
            $data['tipo_reporte']       = $tipo_reporte;
            $data['centro']             = $txt_centro_costo;
            //$data['fecha_iniciotext'] = $fecha_inicio;
            //$data['fecha_fintext']    = $fecha_fin;
            //$data['firmas']           = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));            
            $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
            $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";

            $html = $this->load->view('modulo_contabilidad/reportes/filtrar_consolidacion_partidas', $data, true);

            if ($flag) {
                echo $html;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Consolidación partidas';
                    $data['propietario'] = $propietario;
                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_consolidacion_partidas_' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->makePdf($reporte, 'L', 'reporte_consolidacion_partidas_', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_consolidacion_partidas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Consolidación partidas';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        } else {
            //$data['id_tif_exportacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL',null,null,array('ID_TIF_EXPORTACION'));            

            $select                 = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
            $data["slcTipoFactura"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $select                 = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', '', null, '', 'tpd_id', true);
            $data["slcTipoPartida"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $centro_costo           = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre} ', '', array("cec_estado" => 1), null, '', 'cec_id', true);
            $centro_costo           = str_replace('<option value="0">Sin Registros</option>', '', $centro_costo);
            $data['centro_costo']   = str_replace('<option value="0">Seleccione</option>', '', $centro_costo);
            $data['titulo_personal'] = "Reporte consolidación partidas";
            $this->_cargarvista($data);
        }
    }

    public function preparar_datos_libro_ventas_consumidor_final($datos)
    {

        //Contadores y acumuladores
        $array_elemento = [];
        $array_elementos = [];
        $indice = 0;
        $generar_linea_individual = 0;
        if (count($datos) > 0) {
            $cof_id_actual = $datos[0]['cof_id'];
            $estado_actual = $datos[0]['fac_estado'];
            $es_exenta = ($datos[0]['fac_impuesto'] <= 0) ? 1 : 0;
            $fac_num_anulada_actual;
            $fac_num_exenta_actual;
            $ban = 0;
            // $generar_linea_individual = ($datos[0]['fac_estado'] == 0)? 1:0;
        }
        foreach ($datos as $key => $dato) {
            if ($ban == 0) {
                $fac_num_inicial = $dato['fac_numero'];
            }

            $fac_numero_actual = $dato['fac_numero'];
            /// creo que no va aqui $cof_id_actual = $dato['cof_id'];

            if ($dato['fac_estado'] == 0) {
                //if($key == 0){
                //  $generar_linea_individual = 1;
                ++$indice;
                $cof_id_actual = $dato['cof_id'];

                $array_elemento[$indice]['fac_id'] = $dato['fac_id'];
                $array_elemento[$indice]['cof_id'] = $dato['cof_id'];
                $array_elemento[$indice]['fac_fecha_fact'] = $dato['fac_fecha_fact'];
                $array_elemento[$indice]['tipo_documento'] = $dato['tipo_documento'];
                $array_elemento[$indice]['del'] = $dato['fac_numero'];
                $array_elemento[$indice]['al'] = $dato['fac_numero'];
                $array_elemento[$indice]['venta_no_sujeta'] = $dato['venta_no_sujeta'];
                $array_elemento[$indice]['total_venta_exenta'] = $dato['total_venta_exenta'];
                $array_elemento[$indice]['total_venta_gravado'] = $dato['total_venta_gravado'];
                $array_elemento[$indice]['exportacion'] = $dato['exportacion'];
                $array_elemento[$indice]['retencion'] = $dato['retencion'];
                $array_elemento[$indice]['venta_total'] = $dato['venta_total'];
                $array_elemento[$indice]['fac_estado'] = $dato['fac_estado'];
                $array_elemento[$indice]['caj_nombre'] = $dato['caj_nombre'];

                $array_elemento[$indice]['fac_impuesto'] = $dato['fac_impuesto'];

                //++$indice;
                $estado_actual = $dato['fac_estado'];
                $es_exenta = ($dato['fac_impuesto'] <= 0) ? 1 : 0;
                $fac_num_anulada_actual = $dato['fac_numero'];
                $fac_num_inicial = $dato['fac_numero'] + 1;
                $ban = 0;
                /*}else{                
                    if($dato['cof_id'] == $cof_id_actual){
                       $array_elemento[$indice]['fac_id'] = $dato['fac_id'];
                       $array_elemento[$indice]['cof_id'] = $dato['cof_id'];
                       $array_elemento[$indice]['fac_fecha_fact'] = $dato['fac_fecha_fact'];
                       $array_elemento[$indice]['tipo_documento'] = $dato['tipo_documento'];
                       $array_elemento[$indice]['del'] = $dato['del'];
                       $array_elemento[$indice]['al'] = $fac_numero_actual;
                       $array_elemento[$indice]['venta_no_sujeta'] += $dato['venta_no_sujeta'];
                       $array_elemento[$indice]['total_venta_exenta'] += $dato['total_venta_exenta'];
                       $array_elemento[$indice]['total_venta_gravado'] += $dato['total_venta_gravado'];
                       $array_elemento[$indice]['exportacion'] += $dato['exportacion'];
                       $array_elemento[$indice]['retencion'] += $dato['retencion'];
                       $array_elemento[$indice]['venta_total'] += $dato['venta_total'];
                       $array_elemento[$indice]['fac_estado'] = $dato['fac_estado']; 
                    }else{
                        $cof_id_actual = $dato['cof_id'];
                        ++$indice;

                        $array_elemento[$indice]['fac_id'] = $dato['fac_id'];
                        $array_elemento[$indice]['cof_id'] = $dato['cof_id'];
                        $array_elemento[$indice]['fac_fecha_fact'] = $dato['fac_fecha_fact'];
                        $array_elemento[$indice]['tipo_documento'] = $dato['tipo_documento'];
                        $array_elemento[$indice]['del'] = $dato['del'];
                        $array_elemento[$indice]['al'] = $fac_numero_actual;
                        $array_elemento[$indice]['venta_no_sujeta'] = $dato['venta_no_sujeta'];
                        $array_elemento[$indice]['total_venta_exenta'] = $dato['total_venta_exenta'];
                        $array_elemento[$indice]['total_venta_gravado'] = $dato['total_venta_gravado'];
                        $array_elemento[$indice]['exportacion'] = $dato['exportacion'];
                        $array_elemento[$indice]['retencion'] = $dato['retencion'];
                        $array_elemento[$indice]['venta_total'] = $dato['venta_total'];
                        $array_elemento[$indice]['fac_estado'] = $dato['fac_estado'];
                    }
                }*/
            } else  if ($dato['fac_estado'] != 0 && ($es_exenta == 1 || $dato['fac_impuesto'] <= 0)) {
                // $generar_linea_individual = 1;
                ++$indice;
                $cof_id_actual = $dato['cof_id'];

                $array_elemento[$indice]['fac_id'] = $dato['fac_id'];
                $array_elemento[$indice]['cof_id'] = $dato['cof_id'];
                $array_elemento[$indice]['fac_fecha_fact'] = $dato['fac_fecha_fact'];
                $array_elemento[$indice]['tipo_documento'] = $dato['tipo_documento'];
                $array_elemento[$indice]['del'] = $dato['fac_numero'];
                $array_elemento[$indice]['al'] = $dato['fac_numero'];
                $array_elemento[$indice]['venta_no_sujeta'] = $dato['venta_no_sujeta'];
                $array_elemento[$indice]['total_venta_exenta'] = $dato['total_venta_exenta'];
                $array_elemento[$indice]['total_venta_gravado'] = $dato['total_venta_gravado'];
                $array_elemento[$indice]['exportacion'] = $dato['exportacion'];
                $array_elemento[$indice]['retencion'] = $dato['retencion'];
                $array_elemento[$indice]['venta_total'] = $dato['venta_total'];
                $array_elemento[$indice]['fac_estado'] = $dato['fac_estado'];
                $array_elemento[$indice]['caj_nombre'] = $dato['caj_nombre'];
                $es_exenta = ($dato['fac_impuesto'] <= 0) ? 1 : 0;
                $estado_actual = $dato['fac_estado'];
                $fac_num_exenta_actual = $dato['fac_numero'];
                $fac_num_inicial = $dato['fac_numero'] + 1;
                $ban = 0;
            } else {

                if ($key == 0) {
                    $array_elemento[$indice]['fac_id'] = $dato['fac_id'];
                    $array_elemento[$indice]['cof_id'] = $dato['cof_id'];
                    $array_elemento[$indice]['fac_fecha_fact'] = $dato['fac_fecha_fact'];
                    $array_elemento[$indice]['tipo_documento'] = $dato['tipo_documento'];
                    $array_elemento[$indice]['del'] = ($fac_num_inicial - $generar_linea_individual);
                    $array_elemento[$indice]['al'] = $fac_numero_actual;
                    $array_elemento[$indice]['venta_no_sujeta'] = $dato['venta_no_sujeta'];
                    $array_elemento[$indice]['total_venta_exenta'] = $dato['total_venta_exenta'];
                    $array_elemento[$indice]['total_venta_gravado'] = $dato['total_venta_gravado'];
                    $array_elemento[$indice]['exportacion'] = $dato['exportacion'];
                    $array_elemento[$indice]['retencion'] = $dato['retencion'];
                    $array_elemento[$indice]['venta_total'] = $dato['venta_total'];
                    $array_elemento[$indice]['fac_estado'] = $dato['fac_estado'];
                    $array_elemento[$indice]['caj_nombre'] = $dato['caj_nombre'];

                    $array_elemento[$indice]['fac_impuesto'] = $dato['fac_impuesto'];

                    $cof_id_actual = $dato['cof_id'];
                    $estado_actual = $dato['fac_estado'];
                    $es_exenta = ($dato['fac_impuesto'] <= 0) ? 1 : 0;
                    $ban++;
                } else {
                    if ($dato['cof_id'] == $cof_id_actual) {
                        if ($estado_actual == 0) {
                            //   $generar_linea_individual = 1;
                            ++$indice;
                        }
                        $array_elemento[$indice]['fac_id'] = $dato['fac_id'];
                        $array_elemento[$indice]['cof_id'] = $dato['cof_id'];
                        $array_elemento[$indice]['fac_fecha_fact'] = $dato['fac_fecha_fact'];
                        $array_elemento[$indice]['tipo_documento'] = $dato['tipo_documento'];
                        $array_elemento[$indice]['del'] = ($fac_num_inicial - $generar_linea_individual);
                        $array_elemento[$indice]['al'] = $fac_numero_actual;
                        $array_elemento[$indice]['venta_no_sujeta'] += $dato['venta_no_sujeta'];
                        $array_elemento[$indice]['total_venta_exenta'] += $dato['total_venta_exenta'];
                        $array_elemento[$indice]['total_venta_gravado'] += $dato['total_venta_gravado'];
                        $array_elemento[$indice]['exportacion'] += $dato['exportacion'];
                        $array_elemento[$indice]['retencion'] += $dato['retencion'];
                        $array_elemento[$indice]['venta_total'] += $dato['venta_total'];
                        $array_elemento[$indice]['fac_estado'] = $dato['fac_estado'];
                        $array_elemento[$indice]['caj_nombre'] = $dato['caj_nombre'];

                        $array_elemento[$indice]['fac_impuesto'] += $dato['fac_impuesto'];

                        $cof_id_actual = $dato['cof_id'];
                        $estado_actual = $dato['fac_estado'];
                        $es_exenta = ($dato['fac_impuesto'] <= 0) ? 1 : 0;
                        $generar_linea_individual = 0;
                    } else {
                        ++$indice;
                        //reset de variables
                        $cof_id_actual      = $dato['cof_id'];
                        $estado_actual      = $dato['fac_estado'];
                        $es_exenta = ($dato['fac_impuesto'] <= 0) ? 1 : 0;
                        $fac_num_inicial    = $dato['fac_numero'];
                        $fac_numero_actual  = $dato['fac_numero'];

                        $array_elemento[$indice]['fac_id'] = $dato['fac_id'];
                        $array_elemento[$indice]['cof_id'] = $dato['cof_id'];
                        $array_elemento[$indice]['fac_fecha_fact'] = $dato['fac_fecha_fact'];
                        $array_elemento[$indice]['tipo_documento'] = $dato['tipo_documento'];
                        $array_elemento[$indice]['del'] = ($fac_num_inicial - $generar_linea_individual);
                        $array_elemento[$indice]['al'] = $fac_numero_actual;
                        $array_elemento[$indice]['venta_no_sujeta'] = $dato['venta_no_sujeta'];
                        $array_elemento[$indice]['total_venta_exenta'] = $dato['total_venta_exenta'];
                        $array_elemento[$indice]['total_venta_gravado'] = $dato['total_venta_gravado'];
                        $array_elemento[$indice]['exportacion'] = $dato['exportacion'];
                        $array_elemento[$indice]['retencion'] = $dato['retencion'];
                        $array_elemento[$indice]['venta_total'] = $dato['venta_total'];
                        $array_elemento[$indice]['fac_estado'] = $dato['fac_estado'];
                        $array_elemento[$indice]['caj_nombre'] = $dato['caj_nombre'];
                        $array_elemento[$indice]['fac_impuesto'] = $dato['fac_impuesto'];
                        $generar_linea_individual = 0;
                    }
                }
            } //Si es anulada
            $ban++;
        }
        return $array_elemento;
    }

    public function get_total_cuenta_recursivo($datos, $filtros, $idreporte)
    {
        $datos_completos = $datos;
        foreach ($datos as $l => $data) {
            $padre = $data['cfr_id'];
            $new_array_id = explode(",", $data['cuentas']);
            /******************************************************************/
            $new_array_id2 = $this->contabilidad_model->get_todos_hijos_existentes_cuentas($new_array_id);
            $new_array_id2 .= "," . implode(',', $new_array_id);
            //$ttt .= "," . $new_array_id2;                              
            $new_array_id2 = explode(',', $new_array_id2);
            $new_array_id2 = array_filter($new_array_id2, 'strlen');
            //$zzz .= "***" . implode(',', $new_array_id2);
            /******************************************************************/
            if ($data['cfr_grupo']) {
                $total_individual = $this->contabilidad_model->get_total_hijos($padre, $filtros, $idreporte);
            } else {
                $total_individual = 0;
            }

            $total_padre_individual = $this->contabilidad_model->get_total_cuentapadre_cuentashijas_reportes($new_array_id, $filtros);
            // print_r($this->db->last_query());die();
            $total_padre_individual = (isset($total_padre_individual[0]['total'])) ? $total_padre_individual[0]['total'] : 0;
            $datos_completos[$l]['total'] = $total_individual + $total_padre_individual;
            //array_push($aaaa, $total_individual + $total_padre_individual);
        }
        return $datos_completos;
    }

    public function get_total_cuenta_recursivo2($datos, $filtros, $idreporte, $filtro2)
    {
        $datos_completos = $datos;
        foreach ($datos as $l => $data) {
            $padre = $data['cfr_id'];
            $new_array_id = explode(",", $data['cuentas']);
            /******************************************************************/
            $new_array_id2 = $this->contabilidad_model->get_todos_hijos_existentes_cuentas($new_array_id);
            $new_array_id2 .= "," . implode(',', $new_array_id);
            //$ttt .= "," . $new_array_id2;                              
            $new_array_id2 = explode(',', $new_array_id2);
            $new_array_id2 = array_filter($new_array_id2, 'strlen');
            //$zzz .= "***" . implode(',', $new_array_id2);
            /******************************************************************/
            if ($data['cfr_grupo']) {
                $total_individual = $this->contabilidad_model->get_total_hijos($padre, $filtros, $idreporte);
                // $total_individual = $this->contabilidad_model->get_total_hijos2($padre, $filtros, $idreporte, $filtro2);///////////////////////////////////////////////////
            } else {
                $total_individual = 0;
            }
            // var_dump($total_individual);          //////////////////////////////////////////////////////////////////////////////////
            $total_padre_individual = $this->contabilidad_model->get_total_cuentapadre_cuentashijas_reportes2($new_array_id, $filtros, $filtro2);
            // print_r($this->db->last_query());die();
            $total_anterior = (isset($total_padre_individual[1]['anterior'])) ? $total_padre_individual[1]['anterior'] : 0;
            $total_padre_individual = (isset($total_padre_individual[0]['total'])) ? $total_padre_individual[0]['total'] : 0;
            $datos_completos[$l]['total'] = $total_individual + $total_padre_individual + $total_anterior;
            //array_push($aaaa, $total_individual + $total_padre_individual);
        }
        // die('x');    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // var_dump($datos_completos);die();////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        return $datos_completos;
    }

    function get_todos_hijos_existentes_cuentas()
    {
        $arreglo = $this->input->post('arreglo_padres');
        $a = $this->contabilidad_model->get_todos_hijos_existentes_cuentas($arreglo);
        $a .= "," . implode(',', $arreglo);
        $a = explode(',', $a);
        $a = array_filter($a, 'strlen'); //// removes all NULL, FALSE and Empty Strings but leaves 0 (zero) values
        echo json_encode(array('abc' => array_values(array_unique($a)), 'contador' => count($a)));
    }

    function consultar_reporte_comprobacion($tipo_reporte = "") {
        // var_dump($tipo_reporte);die();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $spaces = $titles = "";
        $fecha_ini           = (trim($tipo_reporte) != "" && is_numeric($tipo_reporte)) ? $this->input->post('fecha_inicio') : $this->input->post('fecha_ini');
        $fecha_fin           = (trim($tipo_reporte) != "" && is_numeric($tipo_reporte)) ? $this->input->post('fecha_fin') : $this->input->post('fecha_fin');
        $fecha_inicio        = formatear_fecha("Y-m-d", $fecha_ini);
        $fecha_fin           = formatear_fecha("Y-m-d", $fecha_fin);
        $slc_centro_costo    = (trim($this->input->post('slc_centro_costo')) != "" && is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
        $txt_centro_costo    = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
        $mostrar_cuenta_cero = ($this->input->post('cuentas_con_cero') && $this->input->post('cuentas_con_cero') != 'false'  && $this->input->post('cuentas_con_cero') != false) ? 1 : 0;
        $data['quitar_ptda_cierre'] = ($this->input->post('partidas_cierre') > 0) ? false : true;
        $data['mostrar_cuenta_cero'] = $mostrar_cuenta_cero;
        $data['tipo_reporte']        = $tipo_reporte;
        $data['html_reporte'] = $txt_html_rpt = (trim($tipo_reporte) != "" and is_numeric($tipo_reporte)) ? trim($this->input->post('html_reporte')) : '';
        //consultar por los formatos de impresión
        $format = json_decode($this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES'), true);
        //consultar las cuentas nivel 5
        $data['cuentas'] = array();
        $data['spaces'] = $spaces;
        $data['titles'] = $titles;
        if ($tipo_reporte == "" || $tipo_reporte == 1) {
            $where_padres['cnt_id_nic'] = 3;
            $where_padres['cnt_id_cnt_padre is not null'] = null;
            if ($slc_centro_costo != "") {
                $where_padres['pcc_id_cec'] = $slc_centro_costo;
            }
            $data['cuentas']     = $this->contabilidad_model->libro_mayor(null, null, $where_padres);
        }
        $data['fecha_inicio']   = $fecha_inicio;
        $data['fecha_fin']      = $fecha_fin;
        $data['centro']         = $txt_centro_costo;
        $data['pcc_id_cec']     = $slc_centro_costo;
        if (is_numeric($tipo_reporte) && $tipo_reporte == 0 && $txt_html_rpt != "") {
            $html = $txt_html_rpt;
        } else {
            $html = $this->load->view('modulo_contabilidad/reportes/consultar_reporte_comprobacion_actualizado', $data, true);
            // CLIENTE MAYA USA OTRA VISTA POR SER SU DISEÑO 
            // $html = $this->load->view('modulo_contabilidad/reportes/consultar_reporte_comprobacion_maya_2', $data, true);
        }
        if (is_numeric($tipo_reporte)) {
            if ($tipo_reporte > 0) {
                $head_excel = '<meta charset="utf-8" /><table cellspacing="0" cellpadding="0" style="font-weight: bold;" width="100%" align="center" border="0"><tr>';
                $head_excel .= '<td width="50%" colspan="3" align="left">Balance Comprobación</td><td width="50%" colspan="3" align="right">Fecha: ' . date('d/m/Y H:i:s');
                $head_excel .= ' Página: <b  class="pageNumber" ></b></td></tr><tr><td width="50%" colspan="3" align="left">' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                $head_excel .= '</td><td width="50%" colspan="3" align="right">Período: ' . formatear_fecha('d/m/Y', $fecha_inicio) . ' : ' . formatear_fecha('d/m/Y', $fecha_fin);
                $head_excel .= '</td></tr><tr><td width="50%" colspan="3" align="left">Valores en USD</td><td width="50%" colspan="3" align="right">-</td></tr></table><br>';
                // excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=balance_comprobacion_" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo $head_excel . $html;
                die();
            } else {
                ini_set('max_execution_time', '9999');
                $header = $this->load->view('reporte/header', array('titulo' => 'Balance de Comprobación', 'solotitulo' => true), true);
                $GLOBALS['nombre_reporte'] = 'Reporte Contable - Balance de Comprobación_' . date('dmY');
                $header_ = '<!DOCTYPE html><html><head><title>REPORTE CONTABLE - BALANCE DE COMPROBACION</title></head><body><script type="text/javascript">';
                $header_ .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - BALANCE DE COMPROBACION";';
                $header_ .= 'window.print();</script>';

                $tabla = '<div id="header" align="center"><table cellspacing="0" cellpadding="0" width="100%" align="center" border="0"><tr><td width="50%" align="left">Valores en USD</td>';
                $tabla .= '<td width="50%" align="right">Período: ' . formatear_fecha('d/m/Y', $fecha_inicio) . ' : ' . formatear_fecha('d/m/Y', $fecha_fin) . '</td></tr></table><br></div>';

                $head_pdf = 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . '</script><style type="text/css" media="print">';
                $head_pdf = 'div#header {position:fixed; top:0px; left:0px; width:100%; text-align: center; font-weight: bold; border-bottom: 1px solid black; } ';
                $head_pdf = 'body { counter-increment: chapter 1; } .pageNumber:before { counter-increment: page; content: "___"; } .pageNumber:before { counter-increment: page 2; }';
                $head_pdf = '</style><div id="header" align="center"><table cellspacing="0" cellpadding="0" width="100%" align="center" border="0"><tr><td width="50%" align="left">';
                $head_pdf = 'Balance Comprobación</td><td width="50%" align="right">Fecha: ' . date('d/m/Y H:i:s') . ' Página: <b  class="pageNumber" ></b></td></tr><tr>';
                $head_pdf = '<td width="50%" align="left">' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . '</td><td width="50%" align="right">Período: ';
                $head_pdf = formatear_fecha('d/m/Y', $fecha_inicio) . ' : ' . formatear_fecha('d/m/Y', $fecha_fin) . '</td></tr><tr><td width="50%" align="left">Valores en USD</td>';
                $head_pdf = '<td width="50%" align="right">-</td></tr></table><br></div>';

                $body = str_replace('border="1" style="margin-left: 4px; font-size:14.5px;"', 'border="0" style="margin-left: 4px; font-size:12px;"', $html);
                $reporte = $header_ . $header . $tabla . $body . '</body></html>';
                echo $reporte;
                die();
            }
        } else {
            $respuesta['html']  = $html;
            $respuesta['cuentas']  = 0;
            echo json_encode($respuesta);
            die();
        }
    }

    /**
     * Descripción:
     * Función para obtener la renta por mes
     * @author Edith Herrera - Grupo Satélite
     * @since  2019-09-10
     * @param  ninguno
     * @return Registros de renta por mes de cada empleado.
     */
    function renta()
    {
        satelite_validar();
        if ($this->input->post()) {
            $tipo_reporte   = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            $renta          = ($this->input->post('txt_renta') != '') ? $this->input->post('txt_renta') : '';
            if ($tipo_reporte != null) {
                $year       = ($this->input->post('filtro_year') > 0) ? $this->input->post('filtro_year') : null;
                $empleado   = ($this->input->post('filtro_empleado') > 0) ? $this->input->post('filtro_empleado') : null;
            } else {
                $year       = $this->input->post('year');
                $empleado   = $this->input->post('empleado');
            }
            /***************************** CONSULTA *****************************************/
            $w = $h = null; //$h SERVIRA PARA UN HAVNG PARA UN SLECT SI TUVO O NO INGRESOS, DE MOMENTO NO SE USA
            $where  = $where2 = null;
            $datos_empleados = $datos_proveedores = array();
            $isr    = $this->gsatelite->get_parametro('DESCUENTO_ISR');
            if ($isr > 0) {
                $where['ddd_id_tdc'] = $isr;
            } else {
                echo json_encode(array('mensaje' => 'Se requiere configuración de parámetro del <b> impuesto sobre la renta</b>', 'error' => 1));
                die();
            }
            if ($year != '') {
                $where['DATE_FORMAT(pla_fecha_inicio,"%Y")']            = $year;
                $where2['DATE_FORMAT(dpv_fecha_contabilizacion,"%Y")']  = $year;
            }
            if ($empleado > 0) {
                $w['emp_id'] = $empleado;
                $where['emp_id'] = $empleado;
            }
            $data['renta'] = $renta;
            $data['year']  = $year;
            $data['where'] = $where;
            $data['proveedores'] = array();
            $datos_empleados = $this->contabilidad_model->get_isr_planilla($where, 'emp_id', $year);
            $newdato['codigo_1'] = $this->contabilidad_model->get_f910_01($w, $h, $year);
            $newdato['codigo_11'] = $this->contabilidad_model->get_f910_11($w, $h, $year);
            $data['empleados']  = $datos_empleados;
            $data['empleados2']  = $newdato;
            if ($renta > 0 && !($empleado > 0)) {
                $datos_proveedores = $this->contabilidad_model->get_planilla_proveedores($where2, 'prv_id', $year, $renta);
                $data['proveedores'] = $datos_proveedores;
            }
            /****************************************************************************************************** */
            $data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Renta'), true);
            $data['tipo_reporte'] = $tipo_reporte;
            if ($tipo_reporte != '') {
                switch ($tipo_reporte) {
                    case 'pdf':
                        $data['titulo'] = 'Renta';
                        $html = $this->load->view('modulo_contabilidad/reportes/consultar_renta', $data, true);
                        $this->pdf->makePdf($html, 'L', 'conteos', 'A4');
                        break;
                    case 'excel':
                        $filename = 'rpt_renta' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                        $data['titulo'] = ' renta';
                        $data['filename'] = $filename;
                        $data['excel'] = 1;
                        ob_end_clean();
                        // $html = $this->load->view('modulo_contabilidad/reportes/consultar_renta', $data, true);
                        $html = $this->load->view('modulo_contabilidad/reportes/detalle_renta_2', $data, true);
                        echo $html;
                        break;
                    case 'csv':
                        $linea = array();
                        $afps = array('MAX', 'COF', 'ISS');
                        $salario_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO', 300);
                        $agui_exento = ($salario_min * 2);
                        if (count($newdato) > 0) {
                            foreach ($newdato as $key => $codigo_ingresos_anual) {
                                $codigo_ingreso = ($key == 'codigo_1') ? '01' : '11';
                                foreach ($codigo_ingresos_anual as $k => $emp) {
                                    if ($emp['emp_es_jubilado'] > 0 && $codigo_ingreso != '11') {
                                        if ($emp['total_afp'] > 0 || $emp['total_isss'] > 0) {
                                            $codigo_ing = $codigo_ingreso;
                                        } else {
                                            if ($emp['total_isr'] > 0) {
                                                $codigo_ing = '80';
                                            } else {
                                                $codigo_ing = '81';
                                            }
                                        }
                                    } else {
                                        if ($emp['total_isr'] > 0) {
                                            $codigo_ing = $codigo_ingreso;
                                        } else {
                                            $codigo_ing = '60';
                                        }
                                    }
                                    $codigo_ing = ($emp['emp_es_jubilado'] > 0) ? '80' : $codigo_ingreso;
                                    if ($emp['aguinaldo'] > $agui_exento) {
                                        $aguinaldo_exe = number_format(($agui_exento * 100), 0, '.', '');
                                        $aguinaldo_gra = number_format((($emp['aguinaldo'] - $agui_exento) * 100), 0, '.', '');
                                    } else {
                                        $aguinaldo_exe = number_format(($emp['aguinaldo'] * 100), 0, '.', '');
                                        $aguinaldo_gra = 0;
                                    }
                                    $afp_mensual = $emp['meses_afp'];
                                    $arr_isr_mes = $emp['meses_isr'];
                                    if ($emp['afp_codigo'] != "" && in_array(strtoupper($emp['afp_codigo']), $afps)) {
                                        $monto_afp_total = number_format($emp['total_afp'], 2);
                                        $m_inpep = $m_ipsfa = number_format(0, 2);
                                    } else {
                                        $monto_afp_total = number_format(0, 2);
                                        if (strtoupper($emp['afp_codigo']) == 'INP') {
                                            $m_ipsfa = number_format(0, 2);
                                            $m_inpep = number_format($emp['total_afp'], 2);
                                        } else {
                                            $m_ipsfa = number_format($emp['total_afp'], 2);
                                            $m_inpep = number_format(0, 2);
                                        }
                                    }
                                    $linea_texto = array();
                                    $monto_devengado = number_format(($emp['devengado'] * 100), 0, '.', '');
                                    $bonificaciones = number_format(($emp['gratificaciones'] * 100), 0, '.', '');
                                    $monto_renta = number_format(($emp['total_isr'] * 100), 0, '.', '');
                                    $monto_isss = number_format(($emp['total_isss'] * 100), 0, '.', '');
                                    $monto_afp = number_format(($monto_afp_total * 100), 0, '.', '');
                                    $monto_ipsfa = number_format(($m_ipsfa * 100), 0, '.', '');
                                    $monto_inpep = number_format(($m_inpep * 100), 0, '.', '');
                                    $nombre = mb_strtolower($emp["empleado"], 'UTF-8');
                                    $emp_name = mb_strtoupper(str_replace(array("á", "é", "í", "ó", "ú", ","), array("a", "e", "i", "o", "u", ""), $nombre), 'UTF-8');
                                    // $emp_name = mb_strtoupper(str_replace(array ("á","é","í","ó","ú",","), array ("a","e","i","o","u",""), $emp["empleado"]), 'UTF-8');
                                    $linea_texto[] = str_pad($emp_name, 40, " ", STR_PAD_RIGHT);
                                    $linea_texto[] = str_pad(str_replace('-', '', $emp["documento"]), 14, " ", STR_PAD_LEFT);
                                    $linea_texto[] = $codigo_ing;
                                    $linea_texto[] = str_pad($monto_devengado, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($bonificaciones, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_renta, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($aguinaldo_exe, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($aguinaldo_gra, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_isss, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_afp, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_ipsfa, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_inpep, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                    for ($i = 1; $i <= 12; $i++) {
                                        $linea_texto[] = str_pad(number_format(($arr_isr_mes[$i]['afecto'] * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($arr_isr_mes[$i]['mensual'] * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($afp_mensual[$i] * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                    }
                                    $linea_texto[] = $year;
                                    $linea[] = trim(implode(',', $linea_texto));
                                }
                            }
                        }
                        /*
                        if (count($datos_empleados) > 0) {
                            foreach ($datos_empleados as $key => $emp) {
                                $arr_isr_mes = $arr_afp_mes = $linea_texto = array();
                                $codigo = ($emp['emp_es_jubilado'] > 0) ? '80' : '01';
                                $monto_devengado = number_format(($emp['devengado'] * 100), 0, '.', '');
                                $bonificaciones = number_format(($emp['bonificaciones'] * 100), 0, '.', '');
                                $monto_renta = number_format(($emp['renta'] * 100), 0, '.', '');
                                $monto_isss = number_format(($emp['isss'] * 100), 0, '.', '');
                                $monto_afp = (in_array(strtoupper($emp['afp_codigo']), $afps)) ? number_format(($emp['afp'] * 100), 0, '.', '') : 0;
                                $monto_ipsfa = (!(in_array(strtoupper($emp['afp_codigo']), $afps)) && strtoupper($emp['afp_codigo']) != 'INP') ? number_format(($emp['afp'] * 100), 0, '.', '') : 0;
                                $monto_inpep = (strtoupper($emp['afp_codigo']) == 'INP') ? number_format(($emp['afp'] * 100), 0, '.', '') : 0;
                                if ($emp['aguinaldo'] > $agui_exento) {
                                    $aguinaldo_exe = number_format(($agui_exento * 100), 0, '.', '');
                                    $aguinaldo_gra = number_format((($emp['aguinaldo'] - $agui_exento) * 100), 0, '.', '');
                                } else {
                                    $aguinaldo_exe = number_format(($emp['aguinaldo'] * 100), 0, '.', '');
                                    $aguinaldo_gra = 0;
                                }
                                $detalles = $this->contabilidad_model->get_isr_planilla(array('emp_id' => $emp['emp_id'], 'DATE_FORMAT(pla_fecha_inicio,"%Y")' => $year, 'ddd_id_tdc' => $isr));
                                $afp_mensual = $this->contabilidad_model->get_afp_mensual(array('ddd_id_emp' => $emp['emp_id'], 'DATE_FORMAT(pla_fecha_inicio,"%Y")' => $year));
                                foreach ($detalles as $dt) {
                                    $arr_isr_mes[$dt['mes']] = $dt['isr'];
                                    $arr_ing_mes[$dt['mes']] = $dt['ingreso'];
                                }
                                foreach ($afp_mensual as $afp) {
                                    $arr_afp_mes[$afp['mes']] = $afp['afp'];
                                }
                                $emp_name = mb_strtoupper(str_replace(array ("á","é","í","ó","ú",","), array ("a","e","i","o","u",""), $emp["empleado"]), 'UTF-8');
                                $linea_texto[] = str_pad($emp_name, 40, " ", STR_PAD_RIGHT);
                                $linea_texto[] = str_pad(str_replace('-', '', $emp["nit"]), 14, " ", STR_PAD_LEFT);
                                $linea_texto[] = $codigo;
                                $linea_texto[] = str_pad($monto_devengado, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($bonificaciones, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_renta, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($aguinaldo_exe, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($aguinaldo_gra, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_isss, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_afp, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_ipsfa, 15, " ", STR_PAD_LEFT);//IPSFA
                                $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);//CEFAFA
                                $linea_texto[] = str_pad($monto_inpep, 15, " ", STR_PAD_LEFT);//INPEP
                                $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);//BIENESTAR MAGISTERIAL
                                for ($i = 1; $i <= 12 ; $i++) { 
                                    $mes_afp = (array_key_exists($i, $arr_afp_mes)) ? $arr_afp_mes[$i] : 0;
                                    $mon_suj = (array_key_exists($i, $arr_ing_mes) && $emp['emp_es_jubilado'] < 1) ? $arr_ing_mes[$i] : 0; 
                                    if(array_key_exists($i,$arr_isr_mes)){
                                        $linea_texto[] = str_pad(number_format(($mon_suj * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($arr_isr_mes[$i] * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($mes_afp * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                    } else { 
                                        $linea_texto[] = str_pad(number_format(($mon_suj * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(0, 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($mes_afp * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                    }
                                } 
                                $linea_texto[] = $year;
                                $linea[] = trim(implode(',', $linea_texto));
                            }
                        }
                        */
                        // VERIFICAR EL IF
                        if (count($datos_proveedores) > 0) {
                            foreach ($datos_proveedores as $key => $prv) {
                                $linea_texto = $arr_mes = array();
                                $where2 = array('prv_id' => $prv['prv_id'], 'DATE_FORMAT(dpv_fecha_contabilizacion,"%Y")' => $year);
                                $det_prv = $this->contabilidad_model->get_planilla_proveedores($where2, 'prv_id, MONTH( dpv_fecha_contabilizacion)', $year, $renta);
                                foreach ($det_prv as $dt2) {
                                    $arr_mes[$dt2['mes']] = $dt2['retenciones'];
                                }
                                $total_prv = number_format(($prv['total'] * 100), 0, '.', '');
                                $monto_renta = number_format(($prv['retenciones'] * 100), 0, '.', '');
                                $prv_name = mb_strtoupper(str_replace(array("á", "é", "í", "ó", "ú", ","), array("a", "e", "i", "o", "u", ""), $prv["proveedor"]), 'UTF-8');
                                $linea_texto[] = str_pad($prv_name, 40, " ", STR_PAD_RIGHT);
                                $linea_texto[] = str_pad(str_replace('-', '', $prv["nit"]), 14, " ", STR_PAD_RIGHT);
                                $linea_texto[] = '09';
                                $linea_texto[] = str_pad($total_prv, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_renta, 15, " ", STR_PAD_LEFT);
                                for ($j = 0; $j < 8; $j++) {
                                    $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                }
                                for ($i = 1; $i <= 12; $i++) {
                                    if (array_key_exists($i, $arr_mes)) {
                                        $valor =
                                            $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($arr_mes[$i] * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                    } else {
                                        $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                    }
                                }
                                $linea_texto[] = $year;
                                $linea[] = trim(implode(',', $linea_texto));
                            }
                        }
                        $ruta_carga = 'public/temp/archivos/';
                        $nombre = 'informe_f910_' . $year . '.csv';
                        $ruta_completa  = $ruta_carga . $nombre;
                        if (file_exists($ruta_completa)) {
                            unlink($ruta_completa);
                        }
                        $separador = chr(13) . chr(10);
                        $texto_completo = $separador . implode($separador, $linea);
                        $archivo = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
                        $texto_completo = trim($texto_completo);
                        fputs($archivo, $texto_completo);
                        fclose($archivo);
                        if (ob_get_contents()) ob_end_clean();
                        header('Content-Type: text/html; charset=utf-8');
                        header("Content-Type: application/octet-stream");
                        header('Content-Disposition: attachment; filename=' . $nombre);
                        readfile($ruta_completa);
                        break;
                }
            } else {
                $html = $this->load->view('modulo_contabilidad/reportes/detalle_renta_2', $data, true);
                // $html = $this->load->view('modulo_contabilidad/reportes/detalle_renta', $data, true);                
                echo json_encode(array('renta' => $renta, 'resultado' => $html, 'year' => $year, 'empleado' => $empleado, 'error' => 0));
            }
        } else {
            $data['retenciones'] = $this->gsatelite->get_tabla("ret_retencion", array("ret_estado" => 1, 'ret_aplica_renta' => 1));
            $religion_drop       = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', null, null, '', 'emp_id', true);
            $data['empleado']    = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $religion_drop);
            $data["titulo_personal"] = "Renta";
            $this->_cargarvista($data);
        }
    }

    function pago_cuenta()
    {
        satelite_validar();
        if ($this->input->post()) {
            $fecha_ini      = $this->input->post("fecha_ini");
            $fecha_fin      = $this->input->post("fecha_fin");
            $txt_mes        = $this->input->post("txt_mes");
            $tipo_reporte   = $this->input->post("tipo_reporte");
            list($year, $mes) = explode("-", $fecha_ini);

            /***************************** CONSULTA *****************************************/
            $w = $h = null; //$h SERVIRA PARA UN HAVNG PARA UN SLECT SI TUVO O NO INGRESOS, DE MOMENTO NO SE USA
            $where  = $where2 = null;
            $datos_empleados = $datos_proveedores = array();
            $isr    = $this->gsatelite->get_parametro('DESCUENTO_ISR');
            if ($isr > 0) {
                $where['ddd_id_tdc'] = $isr;
            } else {
                echo json_encode(array('mensaje' => 'Se requiere configuración de parámetro del <b> impuesto sobre la renta</b>', 'error' => 1));
                die();
            }
            if ($year != '') {
                $where['DATE_FORMAT(pla_fecha_inicio,"%m-%Y")']            = $mes . '-' . $year;
                $where2['DATE_FORMAT(dpv_fecha_contabilizacion,"%m-%Y")']  = $mes . '-' . $year;
            }
            if ($empleado > 0) {
                $w['emp_id'] = $empleado;
                $where['emp_id'] = $empleado;
            }
            $fecha = $mes . '-' . $year;
            $data['renta'] = $renta;
            $data['year']  = $fecha;
            $data['where'] = $where;
            $data['proveedores'] = array();
            $datos_empleados = $this->contabilidad_model->get_isr_planilla($where, 'emp_id', $fecha);
            $newdato['codigo_1'] = $this->contabilidad_model->get_f910_01($w, $h, $fecha, 1);
            $newdato['codigo_11'] = $this->contabilidad_model->get_f910_11($w, $h, $fecha, 1);
            $data['empleados']  = $datos_empleados;
            $data['empleados2']  = $newdato;


            /****************************************************************************************************** */
            $data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Renta'), true);
            $data['tipo_reporte'] = $tipo_reporte;
            if ($tipo_reporte != '') {
                switch ($tipo_reporte) {
                    case 'pdf':
                        $data['titulo'] = 'Renta';
                        $data['pdf'] = 1;
                        $html = $this->load->view('modulo_contabilidad/reportes/detalle_renta_3', $data, true);
                        // $html = $this->load->view('modulo_contabilidad/reportes/consultar_renta_f14', $data, true);
                        // echo $html;
                        // die();
                        $this->pdf->makePdf($html, 'L', 'conteos', 'A4');
                        break;
                    case 'excel':
                        $filename = 'rpg_pago_cuenta' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                        $data['titulo'] = ' renta';
                        $data['filename'] = $filename;
                        $data['excel'] = 1;
                        ob_end_clean();
                        // $html = $this->load->view('modulo_contabilidad/reportes/consultar_renta', $data, true);
                        $html = $this->load->view('modulo_contabilidad/reportes/detalle_renta_3', $data, true);
                        echo $html;
                        break;
                    case 'csv':
                        $linea = array();
                        $afps = array('MAX', 'COF', 'ISS');
                        $salario_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO', 300);
                        $agui_exento = ($salario_min * 2);
                        if (count($newdato) > 0) {
                            foreach ($newdato as $key => $codigo_ingresos_anual) {
                                $codigo_ingreso = ($key == 'codigo_1') ? '01' : '11';
                                foreach ($codigo_ingresos_anual as $k => $emp) {
                                    if ($emp['emp_es_jubilado'] > 0 && $codigo_ingreso != '11') {
                                        if ($emp['total_afp'] > 0 || $emp['total_isss'] > 0) {
                                            $codigo_ing = $codigo_ingreso;
                                        } else {
                                            if ($emp['total_isr'] > 0) {
                                                $codigo_ing = '80';
                                            } else {
                                                $codigo_ing = '81';
                                            }
                                        }
                                    } else {
                                        if ($emp['total_isr'] > 0) {
                                            $codigo_ing = $codigo_ingreso;
                                        } else {
                                            $codigo_ing = '60';
                                        }
                                    }
                                    $codigo_ing = ($emp['emp_es_jubilado'] > 0) ? '80' : $codigo_ingreso;
                                    if ($emp['aguinaldo'] > $agui_exento) {
                                        $aguinaldo_exe = number_format(($agui_exento * 100), 0, '.', '');
                                        $aguinaldo_gra = number_format((($emp['aguinaldo'] - $agui_exento) * 100), 0, '.', '');
                                    } else {
                                        $aguinaldo_exe = number_format(($emp['aguinaldo'] * 100), 0, '.', '');
                                        $aguinaldo_gra = 0;
                                    }
                                    $afp_mensual = $emp['meses_afp'];
                                    $arr_isr_mes = $emp['meses_isr'];
                                    if ($emp['afp_codigo'] != "" && in_array(strtoupper($emp['afp_codigo']), $afps)) {
                                        $monto_afp_total = number_format($emp['total_afp'], 2);
                                        $m_inpep = $m_ipsfa = number_format(0, 2);
                                    } else {
                                        $monto_afp_total = number_format(0, 2);
                                        if (strtoupper($emp['afp_codigo']) == 'INP') {
                                            $m_ipsfa = number_format(0, 2);
                                            $m_inpep = number_format($emp['total_afp'], 2);
                                        } else {
                                            $m_ipsfa = number_format($emp['total_afp'], 2);
                                            $m_inpep = number_format(0, 2);
                                        }
                                    }
                                    $linea_texto = array();
                                    $monto_devengado = number_format(($emp['devengado'] * 100), 0, '.', '');
                                    $bonificaciones = number_format(($emp['gratificaciones'] * 100), 0, '.', '');
                                    $monto_renta = number_format(($emp['total_isr'] * 100), 0, '.', '');
                                    $monto_isss = number_format(($emp['total_isss'] * 100), 0, '.', '');
                                    $monto_afp = number_format(($monto_afp_total * 100), 0, '.', '');
                                    $monto_ipsfa = number_format(($m_ipsfa * 100), 0, '.', '');
                                    $monto_inpep = number_format(($m_inpep * 100), 0, '.', '');
                                    $nombre = mb_strtolower($emp["empleado"], 'UTF-8');
                                    $emp_name = mb_strtoupper(str_replace(array("á", "é", "í", "ó", "ú", ","), array("a", "e", "i", "o", "u", ""), $nombre), 'UTF-8');
                                    // $emp_name = mb_strtoupper(str_replace(array ("á","é","í","ó","ú",","), array ("a","e","i","o","u",""), $emp["empleado"]), 'UTF-8');
                                    $linea_texto[] = str_pad('1', 1, " ", STR_PAD_RIGHT);
                                    $linea_texto[] = str_pad('9300', 4, " ", STR_PAD_RIGHT);
                                    $linea_texto[] = str_pad($emp_name, 40, " ", STR_PAD_RIGHT);
                                    $linea_texto[] = str_pad(str_replace('-', '', $emp["documento"]), 14, " ", STR_PAD_LEFT);
                                    $linea_texto[] = $codigo_ing;
                                    $linea_texto[] = str_pad($monto_devengado, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($bonificaciones, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_renta, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($aguinaldo_exe, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($aguinaldo_gra, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_isss, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_afp, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_ipsfa, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad($monto_inpep, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);
                                    $linea_texto[] = str_replace('-', '', $fecha);
                                    $linea[] = trim(implode(',', $linea_texto));
                                }
                            }
                        }
                        /*
                        if (count($datos_empleados) > 0) {
                            foreach ($datos_empleados as $key => $emp) {
                                $arr_isr_mes = $arr_afp_mes = $linea_texto = array();
                                $codigo = ($emp['emp_es_jubilado'] > 0) ? '80' : '01';
                                $monto_devengado = number_format(($emp['devengado'] * 100), 0, '.', '');
                                $bonificaciones = number_format(($emp['bonificaciones'] * 100), 0, '.', '');
                                $monto_renta = number_format(($emp['renta'] * 100), 0, '.', '');
                                $monto_isss = number_format(($emp['isss'] * 100), 0, '.', '');
                                $monto_afp = (in_array(strtoupper($emp['afp_codigo']), $afps)) ? number_format(($emp['afp'] * 100), 0, '.', '') : 0;
                                $monto_ipsfa = (!(in_array(strtoupper($emp['afp_codigo']), $afps)) && strtoupper($emp['afp_codigo']) != 'INP') ? number_format(($emp['afp'] * 100), 0, '.', '') : 0;
                                $monto_inpep = (strtoupper($emp['afp_codigo']) == 'INP') ? number_format(($emp['afp'] * 100), 0, '.', '') : 0;
                                if ($emp['aguinaldo'] > $agui_exento) {
                                    $aguinaldo_exe = number_format(($agui_exento * 100), 0, '.', '');
                                    $aguinaldo_gra = number_format((($emp['aguinaldo'] - $agui_exento) * 100), 0, '.', '');
                                } else {
                                    $aguinaldo_exe = number_format(($emp['aguinaldo'] * 100), 0, '.', '');
                                    $aguinaldo_gra = 0;
                                }
                                $detalles = $this->contabilidad_model->get_isr_planilla(array('emp_id' => $emp['emp_id'], 'DATE_FORMAT(pla_fecha_inicio,"%Y")' => $year, 'ddd_id_tdc' => $isr));
                                $afp_mensual = $this->contabilidad_model->get_afp_mensual(array('ddd_id_emp' => $emp['emp_id'], 'DATE_FORMAT(pla_fecha_inicio,"%Y")' => $year));
                                foreach ($detalles as $dt) {
                                    $arr_isr_mes[$dt['mes']] = $dt['isr'];
                                    $arr_ing_mes[$dt['mes']] = $dt['ingreso'];
                                }
                                foreach ($afp_mensual as $afp) {
                                    $arr_afp_mes[$afp['mes']] = $afp['afp'];
                                }
                                $emp_name = mb_strtoupper(str_replace(array ("á","é","í","ó","ú",","), array ("a","e","i","o","u",""), $emp["empleado"]), 'UTF-8');
                                $linea_texto[] = str_pad($emp_name, 40, " ", STR_PAD_RIGHT);
                                $linea_texto[] = str_pad(str_replace('-', '', $emp["nit"]), 14, " ", STR_PAD_LEFT);
                                $linea_texto[] = $codigo;
                                $linea_texto[] = str_pad($monto_devengado, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($bonificaciones, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_renta, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($aguinaldo_exe, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($aguinaldo_gra, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_isss, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_afp, 15, " ", STR_PAD_LEFT);
                                $linea_texto[] = str_pad($monto_ipsfa, 15, " ", STR_PAD_LEFT);//IPSFA
                                $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);//CEFAFA
                                $linea_texto[] = str_pad($monto_inpep, 15, " ", STR_PAD_LEFT);//INPEP
                                $linea_texto[] = str_pad(0, 15, " ", STR_PAD_LEFT);//BIENESTAR MAGISTERIAL
                                for ($i = 1; $i <= 12 ; $i++) { 
                                    $mes_afp = (array_key_exists($i, $arr_afp_mes)) ? $arr_afp_mes[$i] : 0;
                                    $mon_suj = (array_key_exists($i, $arr_ing_mes) && $emp['emp_es_jubilado'] < 1) ? $arr_ing_mes[$i] : 0; 
                                    if(array_key_exists($i,$arr_isr_mes)){
                                        $linea_texto[] = str_pad(number_format(($mon_suj * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($arr_isr_mes[$i] * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($mes_afp * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                    } else { 
                                        $linea_texto[] = str_pad(number_format(($mon_suj * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(0, 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                        $linea_texto[] = str_pad(number_format(($mes_afp * 100), 0, '.', ''), 15, " ", STR_PAD_LEFT);
                                    }
                                } 
                                $linea_texto[] = $year;
                                $linea[] = trim(implode(',', $linea_texto));
                            }
                        }
                        */

                        $ruta_carga = 'public/temp/archivos/';
                        $nombre = 'informe_f14_' . $fecha . '.csv';
                        $ruta_completa  = $ruta_carga . $nombre;
                        if (file_exists($ruta_completa)) {
                            unlink($ruta_completa);
                        }
                        $separador = chr(13) . chr(10);
                        $texto_completo = $separador . implode($separador, $linea);
                        $archivo = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
                        $texto_completo = trim($texto_completo);
                        fputs($archivo, $texto_completo);
                        fclose($archivo);
                        if (ob_get_contents()) ob_end_clean();
                        header('Content-Type: text/html; charset=utf-8');
                        header("Content-Type: application/octet-stream");
                        header('Content-Disposition: attachment; filename=' . $nombre);
                        readfile($ruta_completa);
                        break;
                }
            } else {
                $html = $this->load->view('modulo_contabilidad/reportes/detalle_renta_3', $data, true);
                // $html = $this->load->view('modulo_contabilidad/reportes/detalle_renta', $data, true);
                // echo $html;
                // die();
                echo json_encode(array('renta' => $renta, 'html' => $html, 'year' => $year, 'empleado' => $empleado, 'error' => 0));
            }
        } else {
            $data['retenciones'] = $this->gsatelite->get_tabla("ret_retencion", array("ret_estado" => 1, 'ret_aplica_renta' => 1));
            $religion_drop       = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', null, null, '', 'emp_id', true);
            $data['empleado']    = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $religion_drop);
            $data["titulo_personal"] = "Renta";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción:
        * Función para obtener pago a cuenta
        * @author Francisco Orozco - Grupo Satélite
        * @since  2019-09-12
        * @param  ninguno
        * @return Reporte de Pago a Cuenta (F14).
    */
    function pago_cuenta_deprecate()
    {
        satelite_validar();
        if ($this->input->post()) {
            $fecha_ini      = $this->input->post("fecha_ini");
            $fecha_fin      = $this->input->post("fecha_fin");
            $txt_mes        = $this->input->post("txt_mes");
            $tipo_reporte   = $this->input->post("tipo_reporte");
            $par_isr = $this->gsatelite->get_parametro('DESCUENTO_ISR', 0);
            $par_rnt = $this->gsatelite->get_parametro('DESCUENTO_ISR10', 0);
            $where["DATE(fac_fecha_fact) >= "] = $fecha_ini;
            $where["DATE(fac_fecha_fact) <= "] = $fecha_fin;
            $where["fac_estado > "]            = 0;
            // $where["fac_id_emr"]               = $this->tank_auth->get_empresa_id();
            $where_isr["DATE(pla_fecha_inicio) >= "] = $fecha_ini;
            $where_isr["DATE(pla_fecha_fin) <= "]    = $fecha_fin;
            $where_isr["pla_estado > "]              = 2;
            $where_isr["ddd_id_tdc"]                 = $par_isr;
            $this->db->join("pla_planilla", "pla_id = ddd_id_pla");
            $data['isr_total'] = $this->gsatelite->get_suma('ddd_detalle_descuento', 'ddd_valor', $where_isr);
            $data['fac_sub_total'] = $this->gsatelite->get_suma('fac_factura', 'fac_subtotal', $where);
            //sobreescribir la renta 10%
            $where_isr["ddd_id_tdc"] = $par_rnt;
            $this->db->join("pla_planilla", "pla_id = ddd_id_pla");
            $data['renta_emp'] = $this->gsatelite->get_suma('ddd_detalle_descuento', 'ddd_valor', $where_isr);
            $this->db->join("gir_giro", "gir_id = emr_id_gir", "left");
            $data['empresa']      = $this->gsatelite->get_tabla('emr_empresa', array("emr_id" => $this->tank_auth->get_empresa_id()));
            $data['fecha']        = $txt_mes;
            $data['titulo']       = 'Pago a cuenta';
            $data['tipo_reporte'] = $tipo_reporte;
            $filename             = 'rpt_pago_cuenta' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']     = $filename;
            $html                 = $this->load->view('modulo_contabilidad/reportes/consultar_pago_cuenta', $data, true);

            if ($tipo_reporte != '') {
                $header = $this->load->view('reporte/header',  array('titulo' => 'Pago a cuenta'), true);
                switch ($tipo_reporte) {
                    case 'pdf':
                        $this->pdf->makePdf($header . $html, 'P', 'conteos', 'Letter');
                        break;
                    case 'excel':

                        $data['excel']      = 1;
                        echo $html;
                        break;
                }
            } else {
                $resultado['html']  = $html;
                echo json_encode($resultado);
                die();
            }
        } else {
            $data["titulo_personal"] = "Reporte de Pago a Cuenta (F14)";
            $this->_cargarvista($data);
        }
    }

    function reporte_centro_costos($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            if ($flag) {
                $fecha_ini = formatear_fecha("Y-m-d", $this->input->post("fecha_ini"));
                $fecha_fin = formatear_fecha("Y-m-d", $this->input->post("fecha_fin"));
            } else {
                $fecha_ini = formatear_fecha("Y-m-d", $this->input->post("hdn_fe_ini"));
                $fecha_fin = formatear_fecha("Y-m-d", $this->input->post("hdn_fe_fin"));
            }
            $tipo_reporte = $this->input->post('tipo_reporte');
            $data['reporte'] = $this->contabilidad_model->get_conta_centro_costo($fecha_ini, $fecha_fin);
            $data['fecha_ini'] = $fecha_ini;
            $data['fecha_fin'] = $fecha_fin;
            $data['filename'] = 'rpte_centro_costo';
            $data['tipo_reporte'] = $tipo_reporte;
            $html = $this->load->view('modulo_contabilidad/reportes/det_rpte_centro_costo', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Contabilidad por Centro de Costo <br>Del ' . formatear_fecha('d-m-Y', $fecha_ini) . ' al ' . formatear_fecha('d-m-Y', $fecha_fin);
                    $GLOBALS['nombre_reporte'] = 'rpte_centro_costo_' . date('dmY');
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'P', '', 'Letter');
                } else {
                    echo $html;
                }
            }
        } else {
            $data["titulo_personal"] = "Reporte por Centro de Costo";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción:
        * Función para obtener balance de saldos filtrados por mes
        * @author Marlon Olmedo - Grupo Satélite
        * @since  2019-09-26
        * @param  fechas
        * @return balance de saldos.
    */
    function saldos_balance_comprobacion($flag = NULL)
    {
        satelite_validar();
        if ($this->input->post()) {

            $fecha_ini      = date('Y-m-d', strtotime("01-" . $this->input->post("fecha_ini")));
            $fecha_fin      = date('Y-m-t', strtotime("01-" . $this->input->post("fecha_fin")));
            $cuentas = $this->gsatelite->get_tabla("cnt_cuenta_contable", array("cnt_id_nic" => 4));

            // Procesar fechas de presupuesto
            $f1 = new DateTime(formatear_fecha("Y-m-d", $fecha_ini));
            $f2 = new DateTime(formatear_fecha("Y-m-d", $fecha_fin));

            // obtener la diferencia de fechas
            $diferencia = $f1->diff($f2);

            // Obtener la cantidad de meses entre un rango de fechas
            $cant_meses = (($diferencia->y * 12) + $diferencia->m);

            ///////////////////////////////////////////////////////////////////////////////////////////////////////
            for ($i = 0; $i <= $cant_meses; $i++) { //recorremos la cantidad de meses que hay entre fechas

                $slcPeriodo = date("Y-m-d", strtotime($fecha_ini)); //se ordena la fecha segun con formato anio mes dia

                $fecha_calculo = date("t-m-Y", strtotime("$slcPeriodo +$i month")); //se trae el ultimo dia del mes y se le suma 1 mes

                $fecha_array[$i] = $fecha_calculo; //se arreglan las fechas
            }


            foreach ($cuentas as $key => $value) { //se recorren las cuentas
                $cuentas_hijos = str_replace("0", "", $this->contabilidad_model->get_ids_cuentas_hijas($value['cnt_id'])); //se traen los hijos de la cuenta
                $cuentas_hijos = (trim($cuentas_hijos) != '') ? trim(trim($cuentas_hijos), ',') : '0';
                $cnt_id_hijoxpadre = (($cuentas_hijos != '') ? ($cuentas_hijos) : '') . ',' . $value['cnt_id']; //se concatena a las cuentas hijo, la cuenta padre
                $cnt_id_hijoxpadre = str_replace(",,", ",", $cnt_id_hijoxpadre);

                $saldos = $this->contabilidad_model->get_saldos_anteriores(
                    "YEAR(pct_fecha) anio, MONTH(pct_fecha) mes",                                                                      //nuevos campos de mes y año
                    array("dpc_id_cnt IN ($cnt_id_hijoxpadre)" => null, "pct_fecha BETWEEN '$fecha_ini' and '$fecha_fin'" => NULL),    //where IN las cuentas hijos y padre
                    "YEAR(pct_fecha), MONTH(pct_fecha)"
                );                                                                              //se agrupa por año y mes

                foreach ($fecha_array as $key2 => $value2) { //se reccoren las fechas 
                    $mes = date("m", strtotime($value2)); //tomamos el mes de las fechas
                    $balance = '';
                    foreach ($saldos as $key3 => $value3) { //recorremos la cantidad de meses que hay entre fechas

                        if ((int)$mes == $value3['mes']) { //comparamos si los meses que la consulta trae es igual al mes del arreglo de fechas
                            if ($value['cnt_aumenta'] == "D") { //luego si es D se resta Debe al Haber
                                $balance = number_format(($value3['Debe'] - $value3['Haber']), 2);
                            } else { //de lo contratio se resta al Haber el Debe
                                $balance = number_format(($value3['Haber'] - $value3['Debe']), 2);
                            }
                        }
                    }
                    $saldoxmes[$key2] = $balance; //se hace un arreglo de saldos por meses de la operacion
                }
                $cuentasxcuentas[$value['cnt_nombre']] = $saldoxmes; //con el arreglo de los meses se crea un nuevo arreglo con el indice de los nombre de cuenta

            }
            $data['cuentasxcuentas'] = $cuentasxcuentas;
            $data['cant_meses'] = $cant_meses;
            $data['fecha_array'] = $fecha_array;
            $data['fecha_ini'] = $fecha_ini;
            $data['fecha_fin'] = $fecha_fin;
            //se crea arreglo de meses
            $data['meses'] = ["", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];

            if ($flag != NULL) {
                if ($flag == 1) {
                    $data['tipo_reporte'] = "pdf";
                    $html = $this->load->view('modulo_contabilidad/reportes/grid_saldos_balance_comprobacion', $data, true);
                    $header = $this->load->view('reporte/header',  array('titulo' => 'Pago a cuenta'), true);
                    $this->pdf->makePdf($header . $html, 'L', 'conteos', 'A4');
                } else {
                    $data['tipo_reporte'] = "excel";
                }
            } else {
                $data['tipo_reporte'] = "";
            }
            $html = $this->load->view('modulo_contabilidad/reportes/grid_saldos_balance_comprobacion', $data, true);
            echo $html;
            die();
            ////////////////////////////////////////////////////////////////////////////////////////////////
        } else {
            $data["titulo_personal"] = "Saldos de Balance de Comprobación";
            $this->_cargarvista($data);
        }
    }

    public function libro_consolidado_diario_mayor()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->libro_mayor(2);
            die();
        }
    }

    public function config_contable_pendiente($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            if ($flag) {
                $busqueda = $this->input->post('tipo_buscar');
                $tipo_cnt = $this->input->post('tipo_cuenta');
                $tipo_reporte = "";
            } else {
                $busqueda = $this->input->post('hdn_tipo_buscar');
                $tipo_cnt = $this->input->post('hdn_tipo_cuenta');
                $tipo_reporte = $this->input->post('tipo_reporte');
            }
            $nombre_cuenta = $this->gsatelite->get_campo('tcn_tipo_cuenta', 'tcn_nombre', array('tcn_id' => $tipo_cnt));
            //0 proveedores  && 1 clientes
            $data['tipo'] = $busqueda;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['nombre_cuenta'] = $nombre_cuenta;
            $data['datos'] = $this->contabilidad_model->get_config_pendiente($busqueda, $tipo_cnt);
            $data['filename'] = 'rpte_config_pdte';
            $html = $this->load->view('modulo_contabilidad/reportes/det_rpte_conf_cont_pdte', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'excel') {
                    echo $html;
                } else {
                    $titulo = ($busqueda > 0) ? 'Clientes' : 'Proveedores';
                    $data['titulo'] = $titulo . ' con Configuracion Contable Pendiente para el Tipo de Cuenta: ' . $nombre_cuenta;
                    $GLOBALS['nombre_reporte'] = 'rpte_centro_costo_' . date('dmY');
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'P', '', 'Letter');
                }
            }
        } else {
            $cuentas = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_abreviacion} - {tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta_cnt"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $cuentas);
            $data["titulo_personal"] = "Configuración Contable Pendiente";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción: Función para descargar plantilla de partida contable
        * @author Raul E. - Grupo Satélite
        * @since  2020-Abr
    */
    public function plantilla_cierre()
    {
        satelite_validar();
        if ($_POST) {
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuentas = $this->gsatelite->get_tabla('cnt_cuenta_contable', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL));
            $data['cuentas'] = $cuentas;
            $html = $this->load->view('modulo_contabilidad/reportes/crear_plantilla_cierre', $data, true);
            ob_end_clean();
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=plantilla_cierre.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
            die();
        }
        $data["titulo_personal"] = "Plantilla Partida Cierre Contable";
        $this->_cargarvista($data);
    }

    /*
        * Descripción: comparativo de reporte de balance general (vista)
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-Abr
    */
    public function comparativo_balance_general()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"]    = "Comparativo de Balance General";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción: comparativo de reporte de balance general (reporte)
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-Abr
    */
    public function generar_comparativo_balance_general($es_reporte = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                ini_set('memory_limit', '4048M');
                ini_set('max_execution_time', '9999');
                ini_set('max_input_vars', '15000');
                $post_array = $this->input->post();
                /*$arreglo = array(4,5);
                $a = $this->contabilidad_model->get_todos_hijos_existentes_cuentas($arreglo);
                $a .= "," . implode(',', $arreglo);            
                $a = explode(',', $a);
                $a = array_filter($a, 'strlen');
                print_r($a);         
                print_r('ttttttttttt');
                die();*/
                /*
                * Si es consulta ajax se toman los nombres del Jquery
                * De lo contrario, se toman los filtros de impresión
                */
                $fecha_inicio       = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;
                $fecha_fin          = ($post_array['txtFecha_hasta'] != '') ? $post_array['txtFecha_hasta'] : null;
                $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
                $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";

                $fechas = array();
                $fechas[0] = array(
                    "fecha_inicio" => formatear_fecha("Y-m-d", "01-" . $fecha_inicio),
                    "fecha_fin" => formatear_fecha("Y-m-t", "01-" . $fecha_inicio)
                );
                $fechas[1] = array(
                    "fecha_inicio" => formatear_fecha("Y-m-d", "01-" . $fecha_fin),
                    "fecha_fin" => formatear_fecha("Y-m-t", "01-" . $fecha_fin)
                );
                $htmls = array();
                //Tipo de Reportes si sera Excel o Pdf
                //$tipo_reporte = $this->input->post('tipo_reporte');
                //print_r($fechas);die();
                foreach ($fechas as $key => $dates) {
                    $where['pct_estado'] = 1;
                    //print_r($fecha_inicio); die();
                    if ($dates["fecha_inicio"] != null) {
                        $where['DATE(pct_fecha) >='] = $dates["fecha_inicio"];
                    }

                    if ($dates["fecha_fin"] != null) {
                        $where['DATE(pct_fecha) <='] = $dates["fecha_fin"];
                    }

                    if ($slc_centro_costo != "") {
                        $where['pcc_id_cec'] = $slc_centro_costo;
                    }

                    $data['txtFecha_desde']     = $fecha_inicio;
                    $data['txtFecha_hasta']     = $fecha_fin;
                    $data['txt_centro_costo']   = $txt_centro_costo;
                    $data['slc_centro_costo']   = $slc_centro_costo;
                    $data['centro']             = $txt_centro_costo;
                    $titutlos_cuentas = $this->contabilidad_model->get_titulos_cuentas_principales(array('cfr_id_rep' => 1, 'cfr_estado' => 1));
                    /*$totales_cuenta = [];        
                foreach ($titutlos_cuentas as $key => $value) {
                    $new_array_id = explode(",", $value['cuentas']);
                    //print_r($new_array_id);
                    $total_padre_e_hijo = $this->contabilidad_model->get_total_cuentapadre_cuentashijas_reportes($new_array_id,$where);
                    //print_r($total_padre_e_hijo); die();
                    $value['total'] = $total_padre_e_hijo[0]['total'];
                    $totales_cuenta[$key+1] = $value; 
                } 
                $totales_cuenta_aux = $totales_cuenta;
                foreach ($totales_cuenta as $j => $total_cuenta) {
                    $acumulador_total = 0;                
                    if($total_cuenta['cfr_grupo']){
                        foreach ($totales_cuenta as $m => $val) {
                            if(($val['cfr_id_padre'] == $total_cuenta['cfr_id']) || ($val['cfr_id'] == $total_cuenta['cfr_id'])){
                                $acumulador_total = $acumulador_total + $val['total'];
                            }
                        }
                    }
                    $totales_cuenta_aux[$j]['total_acumulado'] = $acumulador_total;                
                }*/
                    /**************************************************************/
                    //$idreporte = $this->input->post('idreporte');          
                    $idreporte = 1;

                    $this->db->join('tpd_tipo_partida', 'tpd_id = txr_id_tpd');
                    $txrs = $this->gsatelite->get_tabla('txr_tipo_partidaxreporte', array('tpd_estado' => 1, 'txr_id_rep' => $idreporte));
                    if (count($txrs) > 0) {
                        $tpds = implode(',', array_column($txrs, 'txr_id_tpd'));
                        $where["pct_id_tpd IN ($tpds)"] = null;
                    }

                    $datos_reporte = $this->get_total_cuenta_recursivo($titutlos_cuentas, $where, $idreporte);
                    /**************************************************************/
                    $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
                    $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
                    $filename = 'rpt_balance_comprobacion' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['filename']              = $filename;
                    $data['es_reporte']            = $es_reporte;
                    $data['registros']             = $datos_reporte;
                    $cfr_alineacion = array_column($datos_reporte, 'cfr_alineacion');
                    $array_filtrado = array_filter($cfr_alineacion);

                    if (count($array_filtrado) > 0 && in_array('2', $array_filtrado)) {
                        $orientacion_pagina = "L";
                        //$data['cambio_orientacion'] = 1;
                    } else {
                        $orientacion_pagina = 'Portrait';
                    }

                    $data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
                    $htmls[$key]           = $this->load->view('modulo_contabilidad/reportes/datos_pasivos_activos', $data, true);
                }
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////
                $data["periodo_1"] = $fecha_inicio;
                $data["periodo_2"] = $fecha_fin;
                $data["html"] = $htmls;
                //print_r($htmls);die();
                $html = $this->load->view('modulo_contabilidad/reportes/comparacion_balance_comprobacion', $data, true);

                $filtro_titulo = "";
                if ($es_reporte) {
                    $tipo_accion = $this->input->post('tipo_accion');

                    $filtro_titulo .= "al " . $this->convertir_fecha_larga($fecha_fin, 'de', true);
                    $filtro_titulo .= "<br />";
                    $filtro_titulo .= "(Valores en Dolares)";

                    if ($tipo_accion) { //excel
                        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                        header("Content-Disposition: attachment;filename=Balance_General_" . date('d-m-Y_His') . ".xls");
                        header("Pragma: no-cache");
                        header("Expires: 0");
                        echo '<meta charset="utf-8" />';
                        echo "<table border='0'>
                        <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                        <tr><th colspan='6' align='center' >Balance General</th></tr>
                        <tr><th colspan='6' align='center' >" . $filtro_titulo . "</th></tr>
                        </table>";
                        echo $html;
                        die();
                    } else { //pdf
                        ini_set('memory_limit', '2048M');
                        ini_set('max_execution_time', '9999');

                        $this->load->library('pdf');
                        $html_header = $this->load->view('reporte/header', array('titulo' => "Balance General<br /> $filtro_titulo", 'solotitulo' => true, 'propietario' => $propietario), true);
                        $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                        $this->pdf->makePDF($html_header . $html, "$orientacion_pagina", 'reincidencias', 'Letter');
                        die();
                    }
                }
                echo json_encode(array('html' => $html));
            }
        }
    }

    /*
        * Descripción: comparativo de reporte de resultado acumulado (vista)
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-Abr
    */
    public function comparacion_resultado_acumulado()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"]    = "Comparativo de Estado De Resultado";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción: comparativo de reporte de resultado acumulado (reporte)
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-Abr
    */
    public function generar_comparacion_resultado_acumulado($es_reporte = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $post_array = $this->input->post();
            /*
         * Si es consulta ajax se toman los nombres del Jquery
         * De lo contrario, se toman los filtros de impresión
        */

            $fecha_inicio     = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;
            $fecha_fin        = ($post_array['txtFecha_hasta'] != '') ? $post_array['txtFecha_hasta'] : null;
            $slc_centro_costo = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
            $txt_centro_costo = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";

            /*if ($flag) {
            $fecha_inicio     = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;
            $fecha_fin        = ($post_array['txtFecha_desde'] != '') ? $post_array['txtFecha_desde'] : null;                            
        } else {
            $fecha_inicio = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
            $fecha_fin    = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;                                
            $idtipopartida    = ($post_array['hslcTipoPartida'] != '') ? $post_array['hslcTipoPartida'] : null;      

            //Filtros pdf y excel
            $data['tipopartidatext']    = ($post_array['hslcTipoPartidatext'] != '') ? '<b>TIPO: </b>' . $post_array['hslcTipoPartidatext'] : '<b>TIPO: </b>' .'Todos';
            $data['fecha_iniciotext']  = ($fecha_inicio != '') ? '<b>PARTIDA DESDE: </b>' . formatear_fecha('d-m-Y', $fecha_inicio) : '';
            $data['fecha_fintext']     = ($fecha_fin != '') ? '<b>PARTIDA HASTA: </b>' . formatear_fecha('d-m-Y', $fecha_fin) : '';                

        }*/
            $fechas = array();
            $fechas[0] = array(
                "fecha_inicio" => formatear_fecha("Y-m-d", "01-" . $fecha_inicio),
                "fecha_fin" => formatear_fecha("Y-m-t", "01-" . $fecha_inicio)
            );
            $fechas[1] = array(
                "fecha_inicio" => formatear_fecha("Y-m-d", "01-" . $fecha_fin),
                "fecha_fin" => formatear_fecha("Y-m-t", "01-" . $fecha_fin)
            );
            $htmls = array();

            //Tipo de Reportes si sera Excel o Pdf
            //$tipo_reporte = $this->input->post('tipo_reporte');
            foreach ($fechas as $key => $dates) {

                $where['pct_estado'] = 1;


                if ($fecha_inicio != null) {
                    $where['DATE(pct_fecha) >='] = $dates["fecha_inicio"];
                }

                if ($fecha_fin != null) {
                    $where['DATE(pct_fecha) <='] = $dates["fecha_inicio"];
                }

                if ($slc_centro_costo != "") {
                    $where['pcc_id_cec'] = $slc_centro_costo;
                }

                $data['txtFecha_desde']     = $fecha_inicio;
                $data['txtFecha_hasta']     = $fecha_fin;
                $data['txt_centro_costo']   = $txt_centro_costo;
                $data['slc_centro_costo']   = $slc_centro_costo;
                $idreporte = 2;
                $titutlos_cuentas = $this->contabilidad_model->get_titulos_cuentas_principales(array('cfr_id_rep' => $idreporte));

                /**************************************************************/
                $this->db->join('tpd_tipo_partida', 'tpd_id = txr_id_tpd');
                $txrs = $this->gsatelite->get_tabla('txr_tipo_partidaxreporte', array('tpd_estado' => 1, 'txr_id_rep' => $idreporte));
                if (count($txrs) > 0) {
                    $tpds = implode(',', array_column($txrs, 'txr_id_tpd'));
                    $where["pct_id_tpd IN ($tpds)"] = null;
                }

                $datos_reporte = $this->get_total_cuenta_recursivo($titutlos_cuentas, $where, $idreporte);
                /**************************************************************/
                $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
                $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";
                $filename = 'rpt_balance_comprobacion' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename']              = $filename;
                $data['es_reporte']            = $es_reporte;
                $data['registros']             = $datos_reporte;

                $data['firmas'] = json_decode(trim($this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD')));
                $htmls[$key] = $this->load->view('modulo_contabilidad/reportes/datos_consulta_estado_resultado', $data, true);
            }
            $data["periodo_1"] = $fecha_inicio;
            $data["periodo_2"] = $fecha_fin;
            $data["html"] = $htmls;
            //print_r($htmls);die();
            $html = $this->load->view('modulo_contabilidad/reportes/tabla_comp_balance_comprobacion', $data, true);
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $filtro_titulo = "";
            if ($es_reporte) {
                $tipo_accion = $this->input->post('tipo_accion');

                $filtro_titulo .= "al " . $this->convertir_fecha_larga($fecha_fin, 'de', true);
                $filtro_titulo .= "<br />";
                $filtro_titulo .= "(Valores en Dolares)";

                if ($tipo_accion) { //excel
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=Estado_Resultado" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                  <tr><th colspan='6' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='6' align='center' >Estado de Resultados</th></tr>
                  <tr><th colspan='6' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                    echo $html;
                    die();
                } else { //pdf                
                    ini_set('memory_limit', '2048M');
                    ini_set('max_execution_time', '9999');

                    $this->load->library('pdf');
                    $html_header = $this->load->view('reporte/header', array('titulo' => "Estado de Resultados<br /> $filtro_titulo", 'solotitulo' => true, 'propietario' => $propietario), true);
                    $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                    $this->pdf->makePDF($html_header . $html, 'Portrait', 'reincidencias', 'Letter');
                    die();
                }
            }
            echo json_encode(array('html' => $html));
        }
    }

    /*
        * Descripción: comparativo de reporte de comprobacion (vista)
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-Abr
    */
    public function comparacion_comprobacion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"]    = "Comparativo de Reporte De Comprobación";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción: comparativo de reporte de comprobacion (reporte)
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-Abr
    */
    public function generar_comparacion_comprobacion($tipo_reporte = "")
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            ini_set('memory_limit', '2048M');
            ini_set('max_execution_time', '9999');
            $fecha_ini          = (trim($tipo_reporte) != "" and is_numeric($tipo_reporte)) ? $this->input->post('fecha_inicio') : $this->input->post('fecha_ini');
            $fecha_fin          = (trim($tipo_reporte) != "" and is_numeric($tipo_reporte)) ? $this->input->post('fecha_fin') : $this->input->post('fecha_fin');
            //$fecha_inicio       = formatear_fecha("Y-m-d",$fecha_ini);
            //$fecha_fin          = formatear_fecha("Y-m-d",$fecha_fin);
            $slc_centro_costo   = (trim($this->input->post('slc_centro_costo')) != "" and is_numeric($this->input->post('slc_centro_costo'))) ? $this->input->post('slc_centro_costo') : "";
            $txt_centro_costo   = (trim($this->input->post('txt_centro_costo')) != "") ? trim($this->input->post('txt_centro_costo')) : "";
            $mostrar_cuenta_cero = ($this->input->post('cuentas_con_cero') && $this->input->post('cuentas_con_cero') != 'false'  && $this->input->post('cuentas_con_cero') != false) ? 1 : 0;
            $data['mostrar_cuenta_cero'] = $mostrar_cuenta_cero;
            $data['tipo_reporte']       = $tipo_reporte;
            $data['html_reporte']       = (trim($tipo_reporte) != "" and is_numeric($tipo_reporte)) ? trim($this->input->post('html_reporte')) : '';
            //print_r($data['html_reporte']);die();    
            //consultar por los formatos de impresión
            // $tipo_formato       = $this->gsatelite->get_parametro('SYS_CONTABILIDAD_FORMATO_REPORTES',null,null,array('LIBRO_AUXILIAR'));
            // $tipo_formato       = (trim($tipo_formato) != "" && $tipo_formato > 0 )? $tipo_formato:0;
            // $imprimir_navegador = ($tipo_formato == 1)? 1:0;        
            //consultar las cuentas nivel 5

            $fechas = array();
            $fechas[0] = array(
                "fecha_inicio" => formatear_fecha("Y-m-d", "01-" . $fecha_ini),
                "fecha_fin" => formatear_fecha("Y-m-t", "01-" . $fecha_ini)
            );
            $fechas[1] = array(
                "fecha_inicio" => formatear_fecha("Y-m-d", "01-" . $fecha_fin),
                "fecha_fin" => formatear_fecha("Y-m-t", "01-" . $fecha_fin)
            );
            $htmls = array();

            foreach ($fechas as $key => $dates) {
                $data['cuentas'] = array();
                if ($data['html_reporte'] == "") {
                    $where_padres['cnt_id_nic'] = 3;
                    $where_padres['cnt_id_cnt_padre is not null'] = null;
                    if ($slc_centro_costo != "") {
                        $where_padres['pcc_id_cec'] = $slc_centro_costo;
                    }
                    // $where_padres['cnt_id in (75)'] = null; //para pruebas rapidas 75 ///2
                    //$where_padres['cnt_id_cnt_padre  in (76)'] = null; //para pruebas rapidas 1,458,770
                    $data['cuentas']     = $this->contabilidad_model->libro_mayor(null, null, $where_padres);
                }
                $data['fecha_inicio']   = $dates["fecha_inicio"];
                $data['fecha_fin']      = $dates["fecha_fin"];
                $data['centro']         = $txt_centro_costo;
                $data['pcc_id_cec']     = $slc_centro_costo;
                $data["td"] = 1;
                // if ($tipo_formato == 1) { //formato maya
                $htmls[$key] = $this->load->view('modulo_contabilidad/reportes/consultar_reporte_comprobacion_maya_2', $data, true);
                //print_r($htmls[$keys]);die();
            }
            //print_r($htmls[1]);die();
            $data["periodo_1"] = $fecha_ini;
            $data["periodo_2"] = $fecha_fin;
            $data["html"] = $htmls;
            //print_r($data["html"][0]);die();
            $html = $this->load->view('modulo_contabilidad/reportes/tabla_comparacion_comprobacion', $data, true);
            //print($html);die();
            $param_prop =  $this->gsatelite->get_parametro('SYS_CONFIGURACION_FIRMA_REPORTE_CONTABILIDAD', null, null, array('PROPIETARIO'));
            $propietario = ($param_prop) ? $param_prop["NOMBRE"] : "";

            if (is_numeric($tipo_reporte)) {
                if ($tipo_reporte > 0) {
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=balance_comprobacion_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo $html;
                    die();
                } else {
                    ini_set('memory_limit', '2048M');
                    ini_set('max_execution_time', '9999');
                    $this->load->library('pdf');
                    $html_header = $this->load->view('reporte/header', array('titulo' => "Comparacion Reporte Comprobacion<br />", 'solotitulo' => true, 'propietario' => $propietario), true);
                    //$html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                    $this->pdf->makePDF($html_header . $html, 'Portrait', 'reincidencias', 'Letter');
                    die();
                    // echo $html;
                    // die();            
                }
            } else {
                $respuesta['html']  = $html;
                $respuesta['cuentas']  = 0;
                echo json_encode($respuesta);
                die();
            }
        }
    }

    function quitar_tildes($cadena)
    {
        $no_permitidas = array("á", "é", "í", "ó", "ú", "Á", "É", "Í", "Ó", "Ú", "ñ", "À", "Ã", "Ì", "Ò", "Ù", "Ã™", "Ã ", "Ã¨", "Ã¬", "Ã²", "Ã¹", "ç", "Ç", "Ã¢", "ê", "Ã®", "Ã´", "Ã»", "Ã‚", "ÃŠ", "ÃŽ", "Ã”", "Ã›", "ü", "Ã¶", "Ã–", "Ã¯", "Ã¤", "«", "Ò", "Ã", "Ã„", "Ã‹");
        $permitidas = array("a", "e", "i", "o", "u", "A", "E", "I", "O", "U", "n", "N", "A", "E", "I", "O", "U", "a", "e", "i", "o", "u", "c", "C", "a", "e", "i", "o", "u", "A", "E", "I", "O", "U", "u", "o", "O", "i", "a", "e", "U", "I", "A", "E");
        $texto = str_replace($no_permitidas, $permitidas, $cadena);
        return $texto;
    }
}//Fin clase
