<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        //$this->load->library('../controllers/personal/planilla');
        $this->load->model('gsatelite');
        $this->load->model('contabilidad_model');
        $this->load->model('planilla_model');
        $this->load->model('facturacion_model');
        //$this->load->library('../controllers/facturacion/facturar');
        //$this->load->library('tank_auth');
    }

    function partida_contable()
    {
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        ini_set('max_input_vars', '15000');

        $campos = array(
            'pct_id' => 'Partida',
            'pct_fecha' => 'Fecha',
            'pct_concepto' => 'Concepto partida',
            'pct_total' => 'Monto',
            'pct_estado' => 'Estado'
        );
        $crud = new grocery_CRUD();
        $dep = 0;
        /*  if($_POST){

          $fecha_desde=$this->input->post('fecha_desde');
          $fecha_hasta=$this->input->post('fecha_hasta');
          $desde=date('Y-m-d', strtotime($fecha_desde));
          $hasta=date('Y-m-d', strtotime($fecha_hasta));
          //die(print_r($desde.'/'.$hasta));
          if($desde!='' && $hasta!=''){
          $crud->where("pct_fecha >= '".$desde."'");
          $crud->where("pct_fecha <= '".$hasta."'");
          }
          //die(print_r($this->db->last_query()));
          $data['fecha_desde']=$fecha_desde;
          $data['fecha_hasta']=$fecha_hasta;

          } */
        $crud->set_table('pct_partida_contable')
            ->set_subject('Partida contable')
            ->columns('pct_id', 'pct_codigo', 'pct_fecha', 'pct_concepto', 'pct_total')
            ->display_as($campos)
            //->unset_edit()
            //->unset_delete()
        ;

        //	$id_id =  $this->gsatelite->get_campo('pct_partida_contable');
        $query = $this->gsatelite->get_tabla('pct_partida_contable', array('DATE(pct_fecha) =' => date('Y-m-d')));

        //		$crud->add_action('Editar', '', 'modulo_contabilidad/procesos/editar_partida','icomoon-icon-pencil-5');
        //		$crud->add_action('Desactivar partida', '', 'modulo_contabilidad/procesos/inactivar_partida','icomoon-icon-pencil-5');
        //		$crud->add_action('Ver', '', 'modulo_contabilidad/procesos/editar_partida','icomoon-icon-pencil-5');

        /*  $crud->callback_column('pct_fecha',function($value,$row){
          if($value!="") {
          $fecha = date('d-m-Y', strtotime($value));
          return  $fecha;
          }
          }); */

        //die(print_r($query));
        // die(print_r($this->db->last_query()));
        $crud->where('pct_id', 0);
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pct_estado', 'hidden', 1);
        } else {
            $crud->field_type('pct_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['retaceo'] = $this->contabilidad_model->acc_rtceo_ptda(date('Y-m-d'), date('Y-m-d'));
        $data['query'] = $query;
        $data['titulo_personal'] = "Partidas contables";
        $this->_cargarvista($data, $crud->render());
    }

    function estado_partida($row = NULL)
    {
        $query = $this->gsatelite->get_campo('pct_partida_contable', 'pct_estado', array('pct_id' => $row->pct_id));
        if ($query == 1) {
            return 'paso';
        } else {
            return 'ocultar';
        }
    }

    function inactivar_partida($id_partida)
    {
        $rel = $this->contabilidad_model->verificar_int_partida(array('pct_id' => $id_partida));
        $rf = $rel[0];
        if ($rf['nota'] != '' || $rf['cheque'] != '' || $rf['planilla'] != '' || $rf['movimiento'] != '' || $rf['factura'] != '' || $rf['anulada'] != '' || $rf['pagos'] != '' || $rf['anticipo'] != '' || $rf['abono'] != '' || $rf['dpv'] != '') {
            $ok = 0;
            foreach ($rel as $k => $v) {
                if ($v['nota'] != '') {
                    $upd = $this->gsatelite->actualizar_array('nta_nota_abono', array('nta_id_pct' => null), array('nta_id' => $v['nota']));
                }
                if ($v['cheque'] != '') {
                    $upd = $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => null), array('che_id' => $v['cheque']));
                }
                if ($v['planilla'] != '') {
                    $upd = $this->gsatelite->actualizar_array('pla_planilla', array('pla_id_pct' => null), array('pla_id' => $v['planilla']));
                }
                if ($v['movimiento'] != '') {
                    $upd = $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => null), array('moi_id' => $v['movimiento']));
                }
                if ($v['factura'] != '' || $v['anulada'] != '') {
                    $cadena = ($v['factura'] != '') ? array('fac_id_pct' => null) : array('fac_id_pct_anulacion' => null);
                    $condiciones = ($v['factura'] != '') ? array('fac_id' => $v['factura']) : array('fac_id' => $v['anulada']);
                    $upd = $this->gsatelite->actualizar_array('fac_factura', $cadena, $condiciones);
                }
                if ($v['pagos'] != '') {
                    $upd = $this->gsatelite->actualizar_array('ofp_otra_forma_pago', array('ofp_id_pct' => null), array('ofp_id' => $v['pagos']));
                }
                if ($v['anticipo'] != '') {
                    $upd = $this->gsatelite->actualizar_array('anl_anticipo_cliente', array('anl_id_pct' => null), array('anl_id' => $v['anticipo']));
                }
                if ($v['abono'] != '') {
                    $upd = $this->gsatelite->actualizar_array('abc_abono_cliente', array('abc_id_pct' => null), array('abc_id' => $v['abono']));
                }
                if ($v['dpv'] != '') {
                    $upd = $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct' => null), array('dpv_id' => $v['dpv']));
                }
                if ($upd > 0) {
                    $ok += $upd;
                }
            }
            if ($ok > 0) {
                $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $id_partida));
                $this->gsatelite->borrado_general('pcc_partida_centro_costo', array('pcc_id_pct' => $id_partida));
                $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $id_partida));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Partida Eliminada", 'texto_alerta' => "El registro se ha eliminado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ocurrió un error", 'texto_alerta' => "El registro no pudo ser eliminado.");
            }
        } else {
            $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $id_partida));
            $this->gsatelite->borrado_general('pcc_partida_centro_costo', array('pcc_id_pct' => $id_partida));
            $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $id_partida));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Partida Eliminada", 'texto_alerta' => "El registro se ha eliminado correctamente.");
        }
        $this->session->set_flashdata($alerta);
        redirect('/modulo_contabilidad/procesos/partida_contable');
    }

    function activacion_individual($id_partida){
        satelite_validar();
        $dato = array('pct_editable_periodo' => 1, 'pct_usu_mod' => $this->tank_auth->get_user_id(), 'pct_fecha_mod' => date('Y-m-d H:i:s'));
        $restult = $this->gsatelite->actualizar_array('pct_partida_contable', $dato, array('pct_id' => $id_partida));
        echo $restult;
    }

    function agregar_partida($datos = null)
    {
        satelite_validar();
        if (!$datos) {
            if ($_POST) {
                $fec        = $this->input->post('fecha');
                $fecha      = date('Y-m-d', strtotime($fec));
                $id_tpd     = $this->input->post('tipo');
                $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tpd));
                $corr       = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
                $pc         = ($this->input->post('id_prc') > 0) ? $this->input->post('id_prc') : null;
                $codigo2    = $this->db->select('IFNULL(MAX(pct_correlativo_parcial)+1,1) AS correlativo', false)->from('pct_partida_contable')->where(array('pct_id_prc'=>$pc,'pct_id_tpd'=>$id_tpd))->get()->row();
                $numero     = (true)?str_pad($codigo2->correlativo, 5, '0', STR_PAD_LEFT):str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
                $codigo     = $tipo_abr . '-' . $numero;

                $array_partida = array(
                    'pct_id_tpd'    => ($this->input->post('tipo') > 0) ? $this->input->post('tipo') : null,
                    'pct_id_prc'    => ($this->input->post('id_prc') > 0) ? $this->input->post('id_prc') : null,
                    'pct_concepto'  => $this->input->post('concepto_gral'),
                    'pct_modulo'    => 1,
                    'pct_fecha'     => $fecha,
                    'pct_total'     => number_format($this->input->post('total_debe'), 2, '.', ''),
                    'pct_estado'    => 1,
                    'pct_editable_periodo' => 1,
                    'pct_fecha_crea' => date('Y-m-d H:i:s'),
                    'pct_fecha_mod' => date('Y-m-d H:i:s'),
                    'pct_usu_crea'  => $this->tank_auth->get_user_id(),
                    'pct_usu_mod'   => $this->tank_auth->get_user_id(),
                    'pct_correlativo' => $corr->correlativo,
                    'pct_correlativo_parcial' => $codigo2->correlativo,
                    'pct_codigo'    => $codigo
                );

                $agregar    = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

                $cuenta     = $this->input->post('detalle_c');
                $concepto   = $this->input->post('detalle_con');
                $debe       = $this->input->post('detalle_d');
                $haber      = $this->input->post('detalle_h');
                $centros    = $this->input->post('dtll_centro_costo');
                $descripts  = $this->input->post('descripcion_fila');

                foreach ($cuenta as $key => $val) {
                    $cuenta_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array("cnt_id" => $val));
                    $pcc_partida_centro_costo = array(
                        'pcc_id_pct'            => $agregar,
                        'pcc_id_cec'            => $centros[$key],
                        'pcc_codigo'            => $cuenta_array[0]["cnt_cuenta"],
                        'pcc_descripcion'       => $cuenta_array[0]["cnt_nombre"],
                        'pcc_estado'            => 1,
                        'pcc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'pcc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'pcc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'pcc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $pcc_id = $this->gsatelite->ingresar('pcc_partida_centro_costo', $pcc_partida_centro_costo);

                    $array_detalle = array(
                        'dpc_id_cnt'    => $val,
                        'dpc_id_pct'    => $agregar,
                        'dpc_id_pcc'    => $pcc_id,
                        'dpc_concepto'  => $concepto[$key],
                        'dpc_debe'      => $debe[$key],
                        'dpc_haber'     => $haber[$key],
                        'dpc_descripcion' => (trim($descripts[$key]) != "") ? trim($descripts[$key]) : null,
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );
                    $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }

                if ($agregar > 0) {
                    $alerta     = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente con código " . $codigo);
                } else {
                    $alerta     = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
                }

                $this->session->set_flashdata($alerta);

                $volver         = $this->input->post('volver');
                if ($volver == 1) {
                    redirect('modulo_contabilidad/procesos/partida_contable');
                } else {
                    redirect('modulo_contabilidad/procesos/agregar_partida');
                }
            } else {
                             $this->db->limit(1);
                $cec_dfect = $this->gsatelite->get_campo('cec_centro_costo', 'cec_id', array('cec_estado'=>1, 'cec_defecto'=> 1));
                $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
                $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
                $cuentas                = $this->gsatelite->get_tabla('cnt_cuenta_contable', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL));
                $select_cuenta          = "";
                foreach ($cuentas as $cuenta) {
                    $select_cuenta .= '<option data-aumenta="' . $cuenta["cnt_aumenta"] . '" value="' . $cuenta["cnt_id"] . '">' . $cuenta["cnt_cuenta"] . ' - ' . $cuenta["cnt_nombre"] . '</option>';
                }
                $data['cuenta']         = $select_cuenta;
                $tipo                   = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), null, null, null, true);
                $data['tipo']           = str_replace('<option value="0">Seleccione</option>', '', $tipo);
                $centros_costo          = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => 1), $cec_dfect, null, null, true);
                $data['centros_costo']  = str_replace('<option value="0">Seleccione</option>', '', $centros_costo);
                $ano_actual             = date('Y'); // Quemadp
                $mes_actual             = date('m'); // Quemado
                $data['periodo']        = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_estado' => 1)); //'prc_ano' => $ano_actual, 'prc_mes' => $mes_actual, // Se omitieron parametros para que solo muestre el activo
            }

            $data['titulo_personal'] = "Agregar partida contable";
            $this->_cargarvista($data);
        } else {
            /*  PENDIENTE  DE APLICAR EL CODIGO NUEVO  */
            //PARTIDA PARA CHEQUE MANUAL DESDE EL MODULO DE BANCOS           
            if ($datos['proceso'] == 'banco_cheque') {
                $fec        = $datos['fecha'];
                $fecha      = date('Y-m-d', strtotime($fec));
                $id_tpd     = $datos['tipo'];
                $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tpd));
                $corr       = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
                $numero     = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
                $codigo     = $tipo_abr . '-' . $numero;
                //$modulo = $this->input->post('modulo');
                $array_partida = array(
                    'pct_id_tpd'    => ($datos['tipo'] > 0) ? $datos['tipo'] : null,
                    'pct_id_prc'    => ($datos['id_prc'] > 0) ? $datos['id_prc'] : null,
                    'pct_concepto'  => $datos['concepto_gral'],
                    'pct_modulo'    => 1,
                    'pct_fecha'     => $fecha,
                    'pct_total'     => number_format($datos['total_debe'], 2, '.', ''),
                    'pct_estado'    => 1,
                    'pct_editable_periodo' => 1,
                    'pct_fecha_crea' => date('Y-m-d H:i:s'),
                    'pct_fecha_mod' => date('Y-m-d H:i:s'),
                    'pct_usu_crea'  => $this->tank_auth->get_user_id(),
                    'pct_usu_mod'   => $this->tank_auth->get_user_id(),
                    'pct_correlativo' => $corr->correlativo,
                    'pct_codigo'    => $codigo
                );
                $agregar    = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                $cuenta     = $datos['detalle_c'];
                $concepto   = $datos['detalle_con'];
                $debe       = $datos['detalle_d'];
                $haber      = $datos['detalle_h'];
                foreach ($cuenta as $key => $val) {
                    $array_detalle = array(
                        'dpc_id_cnt'    => $val,
                        'dpc_id_pct'    => $agregar,
                        'dpc_concepto' => $concepto[$key],
                        'dpc_debe'      => $debe[$key],
                        'dpc_haber'     => $haber[$key],
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );
                    $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
                if ($agregar > 0) {
                    $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $agregar), array('che_id' => $datos['idcheque']));
                    $alerta     = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente con código." . $codigo);
                } else {
                    $alerta     = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
                }
            } //Fin if para partida de cheque            
            //PARTIDA PARA TRANSFERENCIA MANUAL DESDE EL MODULO DE BANCOS           
            if ($datos['proceso'] == 'banco_trasferencia') {
                $fec        = $datos['fecha'];
                $fecha      = date('Y-m-d', strtotime($fec));
                $id_tpd     = $datos['tipo'];
                $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tpd));
                $corr       = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();

                $numero     = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
                $codigo     = $tipo_abr . '-' . $numero;
                //$modulo = $this->input->post('modulo');
                $array_partida = array(
                    'pct_id_tpd'    => ($datos['tipo'] > 0) ? $datos['tipo'] : null,
                    'pct_id_prc'    => $datos['id_prc'],
                    'pct_concepto'  => $datos['concepto_gral'],
                    'pct_modulo'    => 1,
                    'pct_fecha'     => $fecha,
                    'pct_total'     => number_format($datos['total_debe'], 2, '.', ''),
                    'pct_estado'    => 1,
                    'pct_editable_periodo' => 1,
                    'pct_fecha_crea' => date('Y-m-d H:i:s'),
                    'pct_fecha_mod' => date('Y-m-d H:i:s'),
                    'pct_usu_crea'  => $this->tank_auth->get_user_id(),
                    'pct_usu_mod'   => $this->tank_auth->get_user_id(),
                    'pct_correlativo' => $corr->correlativo,
                    'pct_codigo'    => $codigo
                );

                $agregar    = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

                $cuenta     = $datos['detalle_c'];
                $concepto   = $datos['detalle_con'];
                $debe       = $datos['detalle_d'];
                $haber      = $datos['detalle_h'];

                foreach ($cuenta as $key => $val) {
                    $array_detalle = array(
                        'dpc_id_cnt'    => $val,
                        'dpc_id_pct'    => $agregar,
                        'dpc_concepto' => $concepto[$key],
                        'dpc_debe'      => $debe[$key],
                        'dpc_haber'     => $haber[$key],
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );

                    $detalle    = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }

                if ($agregar > 0) {
                    $this->gsatelite->actualizar_array('nta_nota_abono', array('nta_id_pct' => $agregar), array('nta_id' => $datos['nta_id']));
                    $this->gsatelite->actualizar_array('tra_transaccion', array('tra_id_pct' => $agregar), array('tra_id' => $datos['idtrans']));
                    if (array_key_exists('idtrans_dest', $datos)) {
                        $this->gsatelite->actualizar_array('tra_transaccion', array('tra_id_pct' => $agregar), array('tra_id' => $datos['idtrans_dest']));
                    }
                    $alerta     = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente con código." . $codigo);
                } else {
                    $alerta     = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
                }
            } //Fin if para partida manual de transferencia de bancos
            $this->session->set_flashdata($alerta);

            /*$volver         = $this->input->post('volver');
            if ($volver == 1) {
                redirect('modulo_contabilidad/procesos/partida_contable');
            } else {
                redirect('modulo_contabilidad/procesos/agregar_partida');
            }*/
        }
    }

    function editar_partida($id_pct, $ubicacion){
        satelite_validar();
        if ($_POST) {
            $pct_id         = $this->input->post('pct_id');
            $fec            = $this->input->post('fecha');
            $fecha          = date('Y-m-d', strtotime($fec));
            $cuenta_bd      = $this->input->post('det_c');
            $concepto_bd    = $this->input->post('det_con');
            $debe_bd        = $this->input->post('det_d');
            $haber_bd       = $this->input->post('det_h');
            $detalle_id     = $this->input->post('detalle_id');
            $partida_centro = $this->input->post('partida_centro');
            $detalle_base   = $this->gsatelite->get_tabla('dpc_detalle_partida', array('dpc_id_pct' => $id_pct));
            $detalle_ccc    = $this->gsatelite->get_tabla('pcc_partida_centro_costo', array('pcc_id_pct' => $id_pct));
            $centros        = $this->input->post('dtll_centro_costo');
            $centros_db     = $this->input->post('dtll_centro_costo_base');
            $descrip_db     = $this->input->post('det_desc');
            $descripts      = $this->input->post('descripcion_fila');
            $jefe_conta     = $this->gsatelite->get_parametro_emp('SYS_ROL_JEFE_CONTABILIDAD',0);
            $auto_bloqueo   = ($this->input->post('edicion_restringida') == 1 && $jefe_conta > 0) ? true : false; 
            $ptda_actual    = $this->gsatelite->get_registro('pct_partida_contable', array('pct_id'=>$pct_id));

            foreach ($detalle_base as $val) {
                $ids_bd[] = $val['dpc_id'];
            }
            foreach ($detalle_ccc as $key => $val) {
                $ids_pcc[] = $val['pcc_id'];
            }
            /*            * ********** BORRADO DE DETALLES ********* */
            for ($i = 0; $i < count($ids_bd); $i++) {
                if ($ids_bd[$i] > 0) {
                    if (!in_array($ids_bd[$i], $detalle_id)) {
                        $eliminar = $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id' => $ids_bd[$i]));
                    }
                }
            }
            foreach ($ids_pcc as $value) {
                if ($value > 0) {
                    if (!in_array($value, $partida_centro)) {
                        $eliminar = $this->gsatelite->borrado_general('pcc_partida_centro_costo', array('pcc_id' => $value));
                    }
                }
            }
            /*             * ********** ACTUALIZACIÓN DE REGISTROS EN BD ********* */
            foreach ($cuenta_bd as $dato => $valor) {
                $cuenta_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array("cnt_id" => $valor));
                $pcc_partida_centro_costo = array(
                    'pcc_id_cec'            => $centros_db[$dato],
                    'pcc_codigo'            => $cuenta_array[0]["cnt_cuenta"],
                    'pcc_descripcion'       => $cuenta_array[0]["cnt_nombre"],
                    'pcc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'pcc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (in_array($partida_centro[$dato], $ids_pcc)) {
                    $this->gsatelite->actualizar_array('pcc_partida_centro_costo', $pcc_partida_centro_costo, array('pcc_id' => $partida_centro[$dato]));
                }
                $array_detalle_bd = array(
                    'dpc_id_cnt'    => $valor,
                    'dpc_id_pct'    => $pct_id,
                    'dpc_concepto'  => $concepto_bd[$dato],
                    'dpc_debe'      => $debe_bd[$dato],
                    'dpc_haber'     => $haber_bd[$dato],
                    'dpc_descripcion' => (trim($descrip_db[$dato]) != "") ? trim($descrip_db[$dato]) : null,
                    'dpc_estado'    => 1,
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                );
                if (in_array($detalle_id[$dato], $ids_bd)) {
                    $detalle = $this->gsatelite->actualizar_array('dpc_detalle_partida', $array_detalle_bd, array('dpc_id' => $detalle_id[$dato]));
                }
            }
            /*             * ********** INGRESO DE DETALLES ********* */
            $cuenta = $this->input->post('detalle_c');
            $concepto = $this->input->post('detalle_con');
            $debe = $this->input->post('detalle_d');
            $haber = $this->input->post('detalle_h');
            foreach ($cuenta as $key => $val) {
                    // OPORTUNIDAD DE MEJORA, DEJAR UN SOLO ARRAY Y SI HAY ID ACTUALIZAR, SINO AGREGAR
                $cuenta_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array("cnt_id" => $val));
                $pcc_partida_centro_costo = array(
                    'pcc_id_pct'            => $pct_id,
                    'pcc_id_cec'            => $centros[$key],
                    'pcc_codigo'            => $cuenta_array[0]["cnt_cuenta"],
                    'pcc_descripcion'       => $cuenta_array[0]["cnt_nombre"],
                    'pcc_estado'            => 1,
                    'pcc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'pcc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'pcc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'pcc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $pcc_id = $this->gsatelite->ingresar('pcc_partida_centro_costo', $pcc_partida_centro_costo);
                $array_detalle = array(
                    'dpc_id_cnt' => $val,
                    'dpc_id_pct' => $pct_id,
                    'dpc_id_pcc' => $pcc_id,
                    'dpc_concepto' => $concepto[$key],
                    'dpc_debe' => $debe[$key],
                    'dpc_haber' => $haber[$key],
                    'dpc_descripcion' => (trim($descripts[$key]) != "") ? trim($descripts[$key]) : null,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }
            /*             * ********** ACTUALIZACIÓN DE PARTIDA CONTABLE ********* */
            $modulo = ($this->input->post('modulo') > 0) ? $this->input->post('modulo') : null;
            if ($detalle > 0) {
                $array_partida = array(
                    'pct_id_tpd' => $this->input->post('tipo'),
                    'pct_modulo' => $modulo,
                    'pct_concepto' => $this->input->post('concepto_gral'),
                    'pct_fecha' => $fecha,
                    'pct_total' => number_format($this->input->post('total_debe'), 2, '.', ''),
                    'pct_estado' => 1,
                    'pct_fecha_crea' => date('Y-m-d H:i:s'),
                    'pct_fecha_mod' => date('Y-m-d H:i:s'),
                    'pct_usu_crea' => $this->tank_auth->get_user_id(),
                    'pct_usu_mod' => $this->tank_auth->get_user_id()
                );
                if ($auto_bloqueo) {
                    $array_partida['pct_editable_periodo'] = 0;
                }
                if ($this->input->post('tipo') != $ptda_actual->pct_id_tpd) {
                    $where_code = array('pct_id_prc' => $ptda_actual->pct_id_prc, 'pct_id_tpd' => $this->input->post('tipo'));
                    $tipo_abr = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $this->input->post('tipo')));
                    $cod2 = $this->db->select('IFNULL(MAX(pct_correlativo_parcial)+1,1) AS correlativo', false)->from('pct_partida_contable')->where($where_code)->get()->row();
                    $numero = str_pad($cod2->correlativo, 5, '0', STR_PAD_LEFT);
                    $newcodigo = $tipo_abr . '-' . $numero;
                    $array_partida['pct_codigo'] = $newcodigo;
                    $array_partida['pct_correlativo_parcial'] = $cod2->correlativo;
                }
                $agregar = $this->gsatelite->actualizar_array('pct_partida_contable', $array_partida, array('pct_id' => $pct_id));
            }
            if ($agregar > 0 && $detalle > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
            }
            $this->session->set_flashdata($alerta);
            $volver = $this->input->post('volver');
            $ubicacion = $this->input->post('ubicacion');
            if ($ubicacion == 1) {
                if ($volver == 1) {
                    redirect('modulo_contabilidad/procesos/partida_contable');
                } else {
                    redirect('modulo_contabilidad/procesos/editar_partida/' . $id_pct . '/1');
                }
            } elseif ($ubicacion == 3) {
                if ($volver == 1) {
                    redirect('utm/cuentas/gestion_cheques');
                } else {
                    redirect('modulo_contabilidad/procesos/editar_partida/' . $id_pct . '/3');
                }
            } else {
                if ($volver == 1) {
                    redirect('modulo_contabilidad/procesos/crear_partida_diaria');
                } else {
                    redirect('modulo_contabilidad/procesos/editar_partida/' . $id_pct . '/2');
                }
            }
        } else {
            $data['ubicacion']      = $ubicacion;
            $info                   = $this->gsatelite->get_tabla('pct_partida_contable', array('pct_id' => $id_pct));
            $data['info']           = $info[0];
            //Se valida la partida contable este dentro del periodo activo
            if (!validarFechaPeriodoContable(formatear_fecha('Y-m-d', $data['info']['pct_fecha']))) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "No puede modificar partidas fuera de los periodos contables.");
                $this->session->set_flashdata($alerta);
                if ($ubicacion == 3) {
                    redirect('utm/cuentas/gestion_cheques');
                } else {
                    redirect('modulo_contabilidad/procesos/partida_contable');
                }                
            }
            $data['partida']        = $id_pct;
            $detalle                = $this->contabilidad_model->get_detalle_partida($id_pct);
            $data['detalle']        = $detalle;


            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuentas                = $this->gsatelite->get_tabla('cnt_cuenta_contable', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL));
            $selec_cuentas          = "<option></option>";
            foreach ($cuentas as $cuenta) {
                $selec_cuentas .= '<option data-aumenta="' . $cuenta["cnt_aumenta"] . '" value="' . $cuenta["cnt_id"] . '">' . $cuenta["cnt_cuenta"] . ' - ' . $cuenta["cnt_nombre"] . '</option>';
            }

            $data['cuentas']        = $cuentas;
            $data['selec_cuentas']  = $selec_cuentas;

            $centros                = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_estado' => 1));
            $selec_centros          = '<option value=""></option>';
            foreach ($centros as $centro) {
                $def = ($centro['cec_defecto'] == 1) ? 'selected': '';
                $selec_centros .= '<option value="' . $centro['cec_id'] . '" ' . $def . ' >' . $centro['cec_codigo'] . ' - ' . $centro['cec_nombre'] . '</option>';
            }
            $data['centros']        = $centros;
            $data['selec_centros']  = $selec_centros;
            $data['tipo']           = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), $data['info']['pct_id_tpd'], null, null, true);
            $data['titulo_personal'] = "Editar partida contable";
            $prc_ptda = $this->gsatelite->get_registro('prc_periodo_contable', array('prc_id'=> $data['info']['pct_id_prc']));
            $data['bloquear'] = ($info[0]['pct_editable_periodo'] == 1 && $prc_ptda->prc_reactivado == 1)?1:0;
            $this->_cargarvista($data);
        }
    }

    function ver_partida_modal($id_pct = 0)
    {
        $data['detalle'] = $this->contabilidad_model->get_detalle_partida($id_pct);
        //print_r($data['detalle']);die();
        $this->load->view('modulo_contabilidad/procesos/ver_partida_modal', $data);
    }

    function excel_partida($id_pct = 0)
    {
        $data['detalle'] = $this->contabilidad_model->get_detalle_partida($id_pct);
        //print_r($data['detalle']);die();
        $this->load->view('modulo_contabilidad/procesos/export_partida_excel', $data);
    }

    /**
     * Descripción:
     * Reporte para mostrar partidas contables consolidades
     * @author Nelson Soriano
     * @since  29-07-2019
     * @param  None
     * @return reporte de partidas consolidadas
     */

    function ver_partida_detalle_modal($id_pct, $imprime = null)
    {
        $cuenta_padre   = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $detalle2       = $this->contabilidad_model->get_partida_por_detalle($id_pct, $cuenta_padre);
        $registros      = array();
        $data           = array();
        //$mayor          = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        //$defecto        = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $reporte['debe'] = array();
        $reporte['haber'] = array();

        foreach ($detalle2 as $key => $detalle) {
            $reporte_tmp    = array();
            $parcial        = ($detalle['sum_debe'] > 0) ? $detalle['sum_debe'] : $detalle['sum_haber'];
            $reporte_tmp[]  = array(
                'nivel'     => $detalle['cnt_id_nic'],
                'cuenta'    => $detalle['cnt_cuenta'],
                'nombre'    => $detalle['cnt_nombre'],
                'parcial'   => $parcial,
                'debe'      => '',
                'haber'     => '',
                'menor'     => true,
                'id'        => $detalle['cnt_id']
            );

            $nivel          = $detalle['cnt_id_nic'];
            $padre_evaluar  = $detalle['cnt_id_cnt_padre'];
            $cuenta_temporal = array();
            while ($nivel > 3 and $padre_evaluar != "") {
                $cuenta_temporal = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $padre_evaluar));
                $nivel          = $cuenta_temporal[0]['cnt_id_nic'];
                $padre_evaluar  = $cuenta_temporal[0]['cnt_id_cnt_padre'];
                $debe           = '';
                $haber          = '';
                $columna_id     = array();

                if ($nivel  == 3) {
                    $debe   = ($detalle['sum_debe'] > 0) ? $detalle['sum_debe'] : '';
                    $haber  = ($detalle['sum_haber'] > 0) ? $detalle['sum_haber'] : '';
                }

                if (array_column($reporte['debe'], 'id') != null) {
                    $columna_id = array_column($reporte['debe'], 'id');
                }

                if (in_array($cuenta_temporal[0]['cnt_id'], $columna_id)) {
                    $posicion = array_search($cuenta_temporal[0]['cnt_id'], $columna_id);
                    if ($detalle['sum_debe'] > 0) {
                        $reporte['debe'][$posicion]['debe'] += $debe;
                    } else {
                        $reporte['haber'][$posicion]['haber'] += $haber;
                    }
                } else {
                    $reporte_tmp[] = array(
                        'nivel'     => $cuenta_temporal[0]['cnt_id_nic'],
                        'cuenta'    => $cuenta_temporal[0]['cnt_cuenta'],
                        'nombre'    => $cuenta_temporal[0]['cnt_nombre'],
                        'parcial'   => '',
                        'debe'      => $debe,
                        'haber'     => $haber,
                        'menor'     => false,
                        'id'        => $cuenta_temporal[0]['cnt_id']
                    );
                }
            }
            $reporte_tmp = array_reverse($reporte_tmp);
            if ($detalle['sum_debe'] > 0) {
                $reporte['debe'] = array_merge($reporte['debe'], $reporte_tmp);
            } else {
                $reporte['haber'] = array_merge($reporte['haber'], $reporte_tmp);
            }
        }

        $data['detalles']   = $reporte;
        $data['imprime']    = false;
        $data['fecha']      = $detalle2[0]['pct_fecha'];
        $data['concepto']   = $detalle2[0]['pct_concepto'];
        $data['tpd_nombre'] = $detalle2[0]['tpd_nombre'];
        $data['id']         = $detalle2[0]['pct_id'];

        if ($imprime != false) {
            $data['imprime']    =  true;
            $data['impresion']  = 1;
            $res                = str_pad("1", '6', '0', STR_PAD_LEFT);
            $cabecera           = $this->load->view('reporte/header_reportes_conta', array('titulo' => "Listado de partidas", 'solotitulo' => true, 'subtitulo' => "Valores expresados en Dolares de los Estados Unidos", 'num' => $res), true);
            $this->load->library('pdf');
            $html               =  $this->load->view('modulo_contabilidad/procesos/ver_partida_detalle_modal', $data, true);
            $html_all           = str_replace('td{', 'tdN{', $cabecera) . $html;
            $this->pdf->SetPrintFooter(false);
            $this->pdf->makePDF($html_all);
        } else {
            $this->load->view('modulo_contabilidad/procesos/ver_partida_detalle_modal', $data);
        }
    }

    function consulta_partida_contable() {

        $fecha_desde = $this->input->post('fecha_ini');
        $fecha_hasta = $this->input->post('fecha_fin');
        $desde = date('Y-m-d', strtotime($fecha_desde));
        $hasta = date('Y-m-d', strtotime($fecha_hasta));

        $proceso_partida = $this->input->post('proceso_partida');
        $array_total = array();
        $array_resultante = array();
        for ($i = 0; $i < count($proceso_partida); $i++) {
            $array_total = $this->contabilidad_model->get_datos_partida($desde, $hasta, $proceso_partida[$i]);
            if ($i == 0) {
                $array_resultante = $array_total;
            } else {
                $array_resultante = array_merge_recursive($array_resultante, $array_total);
            }
        }
        $data['retaceo'] = $this->contabilidad_model->acc_rtceo_ptda($desde, $hasta);
        //$data['query'] = $this->contabilidad_model->get_datos_partida($desde, $hasta, $proceso_partida[0]);
        $data['query'] = $array_resultante;
        // print_r($data['query']); die();
        //echo $this->db->last_query(); die();
        $respuesta = array(
            'html' => $this->load->view('modulo_contabilidad/procesos/consulta_partida_contable', $data, true)
        );
        echo json_encode($respuesta);
    }

    /* Esta pantalla se cambio, ya que en la opcion procesar partidas se procedio a mostrar directamente la vista de procesar
     * Ya no se utiliza esta vista en el menu al dar clic en procesar partidas 
     */
    function crear_partida_diaria()
    {
        satelite_validar();

        $campos = array(
            'pct_id' => 'Partida',
            'pct_fecha' => 'Fecha',
            'pct_concepto' => 'Concepto partida',
            'pct_total' => 'Monto'
        );
        $crud = new grocery_CRUD();
        $dep = 0;
        if ($_POST) {

            $fecha_desde = $this->input->post('fecha_desde');
            $fecha_hasta = $this->input->post('fecha_hasta');
            $desde = date('Y-m-d', strtotime($fecha_desde));
            $hasta = date('Y-m-d', strtotime($fecha_hasta));
            //die(print_r($desde.'/'.$hasta));
            if ($desde != '' && $hasta != '') {
                $crud->where("pct_fecha >= '" . $desde . "'");
                $crud->where("pct_fecha <= '" . $hasta . "'");
            }
            //die(print_r($this->db->last_query()));
            $data['fecha_desde'] = $fecha_desde;
            $data['fecha_hasta'] = $fecha_hasta;
        }
        $crud->set_table('pct_partida_contable')
            ->set_subject('')
            ->columns('pct_id', 'pct_fecha', 'pct_concepto', 'pct_total')
            ->display_as($campos)
            ->unset_edit()
            ->add_action('Editar', '', 'modulo_contabilidad/procesos/editar_partida', 'icomoon-icon-pencil-5')
            ->callback_column('pct_fecha', function ($value, $row) {
                if ($value != "") {
                    $fecha = date('d-m-Y', strtotime($value));
                    return $fecha;
                }
            });
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pct_estado', 'hidden', 1);
        } else {
            $crud->field_type('pct_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        //$this->db->last_query();
        $data['query'] = $this->gsatelite->get_tabla('pct_partida_contable');
        $data['titulo_personal'] = "Partida diaria";
        $this->_cargarvista($data, $crud->render());
    }

    /**
     * Descripción:
     * Función para procesar partidas contables
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-02-14
     * @param Ninguno
     * @return Devuelve las partidas procesadas
     */
    /* Pantalla principal de procesar partidas */
    function procesar_partida()
    {
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        ini_set('max_input_vars', '15000');
        $modulo     = $this->input->post('modulo');
        $totalpartidas = $this->input->post('totalpartidas');
        if ($_POST) {
            if ($_POST['modulo'] == 8 || $_POST['modulo'] == 9 || $_POST['modulo'] == 10 || $_POST['modulo'] == 13) {
                $this->guardar_procesar_partida();
            }
            if ($modulo != 4) {
                if ($this->input->post('contenedorfacturas') && ($this->input->post('contenedorfacturas') < 1)) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Sin registros", 'texto_alerta' => "No existe datos para ingresar");
                    $this->session->set_flashdata($alerta);
                    redirect('modulo_contabilidad/procesos/procesar_partida');
                }

                if ($this->input->post('contenedorcheques') && ($this->input->post('contenedorcheques') < 1)) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Sin registros", 'texto_alerta' => "No existe datos para ingresar");
                    $this->session->set_flashdata($alerta);
                    redirect('modulo_contabilidad/procesos/procesar_partida');
                }

                // proceder a guardar las partidas
                $periodo    = $this->input->post('id_prc');                 // dato de periodo
                $modulo     = $this->input->post('modulo');                 // Modulo de donde proviene
                $tipo_inv   = $this->input->post('tipo_inv');               // Tipo de Inventario
                $tipo_pla   = $this->input->post('tipo_pla');               // Tipo de Planilla
                $fecha      = $this->input->post('fecha');                  // Fecha autorizada que se ha generado la partida
                $consolida  = $this->input->post('txtconsolidar');          // Si es consolidado la partida
                $corr       = $this->input->post('txtcorrelativopartida');  // Array de Correlativos de partidas
                $cantidad   = count($corr);                                 // Cantidad de partidas que se generaran
                $conceptos  = $this->input->post('txtconcepto');            // Array de los conceptos que se guardaran
                $txtdebe    = $this->input->post('txtdebe');                // Array de los Debe general de cada partida
                $txthaber   = $this->input->post('txthaber');               // Array de los haber general de cada partida
                $txt_g_debe = $this->input->post('txt_g_debe');             // Array Global de cada partida debe
                $txt_g_haber = $this->input->post('txt_g_haber');            // Array Global de cada partida haber
                $contenedorf = $this->input->post('contenedorfacturas');     // Contenedor de Facturas
                $cantidad_fac = $this->input->post('cantidad_facturas');     // Contenedor de Facturas
                $array_aux    = explode(',', $this->input->post('array_aux')); // Arreglo con los id para txt_codigo
            } else {
                $tipo_planilla = $this->input->post('tipo_pla');
                $fecha = $this->input->post('fecha');
                $totalpartidas = $this->input->post('totalpartidas');
                $txtcorrelativopartida = $this->input->post('txtcorrelativopartida');
                $txtconcepto = $this->input->post('txtconcepto');
            }
            $procesar = $this->input->post('procesar');
            $cantidad_fac = count(explode(",", $contenedorf[0]));
            // Valores por Defecto
            //Cuenta por defecto
            $id_tipo_partida_defecto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');

            /* ************ Modulo de Facturacion ************ */
            if ($modulo == 2) {
                //Tipo de cuenta por defecto
                $idtipo_cnt              = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('COSTO'));
                //Determinar el origen de la partida si es Documento Proveedor - Sin afectar inventario 
                $origen                  = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 2));
                $orp_partida             = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
                // Cuenta contable por defecto
                $defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
                $data['defecto_cnt'] = $defecto_cnt;
                foreach ($corr as $indice => $valor) {
                    // Recorrer todas la partidas que se generaran
                    $es_anulacion = (substr_count($valor, '_anula') > 0) ? 1 : 0;
                    // Tipo de partida
                    //if($indice < $cantidad_fac){
                    if ($es_anulacion == 0) {
                        // Tipo partida ingreso
                        $tpdin = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO'));
                        $tpdin = ($tpdin > 0) ? $tpdin : 3;
                        $id_tipo_partida         = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tpdin, 'tpd_estado' => 1));
                    } else {
                        // Tipo partida egreso
                        $tpdeg = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('DEVOLUCIONES'));
                        $tpdeg = ($tpdin > 0) ? $tpdin : 2;
                        $id_tipo_partida         = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tpdeg, 'tpd_estado' => 1));
                    }
                    $reg_factura = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $contenedorf[$indice]));
                    $reg_factura = $reg_factura[0];
                    $codigo         = $id_tipo_partida[0]['tpd_prefijo'] . '-' . $valor;   // Codigo que tendra la partida
                    $correlativo    = (int)($valor);                // Correlativo que tendra la partida
                    //En el SI se ingresan las facturas normales y en el ELSE se ingresan las anuladas
                    //$cantidad_fac es la cantidad de facturas normales y se comparan con el indice del recorrido
                    //print_r('Indice '. $indice .' '.'Cant '.$cantidad_fac ); 
                    // if($indice < $cantidad_fac){
                    if ($es_anulacion == 0) {
                        // Se guardaran las partidas, si son individuales deben traer el check de procesar, las consolidadas se guaradn siempre
                        if ($consolida > 0 || $procesar[$indice] > 0) {
                            $array_partida = array(
                                'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
                                'pct_id_prc'        => $periodo,
                                'pct_concepto'      => $conceptos[$indice],
                                'pct_id_orp'        => $orp_partida,
                                'pct_total'         => number_format($txt_g_debe[$indice], 2, '.', ''),
                                'pct_fecha'         => ($reg_factura['fac_fecha_cont']) ? formatear_fecha('Y-m-d', $reg_factura['fac_fecha_cont']) : formatear_fecha('Y-m-d', $fecha),
                                'pct_correlativo'   => $correlativo,
                                'pct_codigo'        => $codigo,
                                'pct_modulo'        => $modulo,
                                'pct_estado'        => 1,
                                'pct_editable_periodo' => 1,////PARCHE RAPIDO, VERIFICAR
                                'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                                'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                                'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                                'pct_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                            // Datos para el detalle de cada partida
                            $txt_codigo_            = $this->input->post('txt_codigo_' . $indice);
                            $txt_cuenta_            = $this->input->post('txt_cuenta_' . $indice);
                            $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . $indice);
                            $txt_nombre_            = $this->input->post('txt_nombre_' . $indice);
                            $txtdebe_               = $this->input->post('txtdebe_' . $indice);
                            $txthaber_              = $this->input->post('txthaber_' . $indice);
                            // Detalle de cada partida
                            foreach ($txt_codigo_ as $key => $value) {
                                $array_detalle = array(
                                    'dpc_id_cnt'        => ($txt_cnt_id_[$key] > 0) ? $txt_cnt_id_[$key] : $defecto_cnt[0]['cnt_id'],
                                    'dpc_id_pct'        => $agregar,
                                    'dpc_concepto'      => 'Por facturación de productos',
                                    'dpc_debe'          => number_format($txtdebe_[$key], 2, '.', ''),
                                    'dpc_haber'         => number_format($txthaber_[$key], 2, '.', ''),
                                    'dpc_estado'        => 1,
                                    'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                    'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                    'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                    'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                                );
                                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                            }
                        }
                    } else { //Partidas de anulacion
                        if ($consolida > 0 || $procesar[$indice] > 0) {
                            // Se guardaran las partidas
                            $array_partida = array(
                                'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
                                'pct_id_prc'        => $periodo,
                                'pct_concepto'      => $conceptos[$indice],
                                'pct_id_orp'        => $orp_partida,
                                'pct_total'         => number_format($txt_g_debe[$indice], 2, '.', ''),
                                'pct_fecha'         => formatear_fecha('Y-m-d', $fecha),
                                'pct_correlativo'   => $correlativo,
                                'pct_codigo'        => $codigo,
                                'pct_modulo'        => $modulo,
                                'pct_estado'        => 1,
                                'pct_editable_periodo' => 1, /////VERIFICAR DESPUES / PARCHE RAPIDO
                                'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                                'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                                'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                                'pct_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                            // Datos para el detalle de cada partida
                            $txt_codigo_            = $this->input->post('txt_codigo_' . $indice);
                            $txt_cuenta_            = $this->input->post('txt_cuenta_' . $indice);
                            $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . $indice);
                            $txt_nombre_            = $this->input->post('txt_nombre_' . $indice);
                            $txtdebe_               = $this->input->post('txthaber_' . $indice);
                            $txthaber_              = $this->input->post('txtdebe_' . $indice);
                            // Detalle de cada partida
                            foreach ($txt_codigo_ as $key => $value) {
                                $array_detalle = array(
                                    'dpc_id_cnt'        => ($txt_cnt_id_[$key] > 0) ? $txt_cnt_id_[$key] : $defecto_cnt[0]['cnt_id'],
                                    'dpc_id_pct'        => $agregar,
                                    'dpc_concepto'      => 'Por anulacion de factura',
                                    'dpc_debe'          => number_format($txtdebe_[$key], 2, '.', ''),
                                    'dpc_haber'         => number_format($txthaber_[$key], 2, '.', ''),
                                    'dpc_estado'        => 1,
                                    'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                    'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                    'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                    'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                                );
                                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                            }
                            $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct_anulacion' => $agregar), array('fac_id' => $contenedorf[$indice]));
                        }
                    }
                    if ($consolida == 1) {
                        $facturas = explode(',', $contenedorf[$indice]);
                        foreach ($facturas as $k => $v) {
                            //Actualizar el id de la partida contable en la factura
                            //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                            $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => $agregar, 'fac_generacion_partida' => 2), array('fac_id' => $v));
                        }
                    } else {
                        /* ********************* Contrapartida en caso de tener productos que afecten inventario ********************* */
                        /*$where['fac_id']        = $contenedorf[$indice];
                        $info['num_fac']        = $this->gsatelite->get_campo('fac_factura', 'fac_numero', array('fac_id'=>$contenedorf[$indice]));
                        $where_existe['fac_id'] = $contenedorf[$indice];
                        $where_existe['art_inventario'] = 1;                            
                        $afecta_inv             = $this->facturacion_model->existe_prod_afec_inv($where_existe);
                        if($afecta_inv[0]['afecta_inv']){
                            $where['cec_id']    = (isset($dtf_centro_costo)) ? $dtf_centro_costo : 0;
                            $this->load->library('../controllers/facturacion/facturar');
                            $res_debe = $this->facturar->generar_contra_partida_factura_afecta_afecta_inv_debe($where,$info);
                            $this->facturar->generar_contra_partida_factura_afecta_inv_haber($where, $res_debe['id_pct']);
                        }
                        */
                        //Actualizar el id de la partida contable en la factura
                        //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                        if (($indice < $cantidad_fac) || $es_anulacion == 0) {
                            if ($procesar[$indice] > 0) {
                                $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => $agregar, 'fac_generacion_partida' => 1), array('fac_id' => $contenedorf[$indice]));
                            }
                        }
                    }
                } //Fin foreach del correlativo
            }
            // Modulo de Inventario
            if ($modulo == 3) {
                // Tipo de partida
                $id_tipo_partida         = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('COSTO'));
                //Tipo de cuenta por defecto
                //$idtipo_cnt              = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('COSTO'));
                //Determinar el origen de la partida, este caso es por inventario
                $origen                  = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 1));
                $orp_partida             = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
                $tipo_ptda               = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $id_tipo_partida));
                // Cuenta contable por defecto
                $defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
                $data['defecto_cnt'] = $defecto_cnt;

                foreach ($corr as $indice => $valor) { // Recorrer todas la partidas que se generaran
                    if ($consolida > 0 || $procesar[$indice] > 0) {
                        $codigo         = $tipo_ptda[0]['tpd_prefijo'] . '-' . $valor;   // Codigo que tendra la partida
                        $correlativo    = (int)($valor);                // Correlativo que tendra la partida
                        // Se guardaran las partidas
                        $array_partida = array(
                            'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
                            'pct_id_prc'        => $periodo,
                            'pct_concepto'      => $conceptos[$indice],
                            'pct_id_orp'        => $orp_partida,
                            'pct_total'         => number_format($txt_g_debe[$indice], 2, '.', ''),
                            'pct_fecha'         => formatear_fecha('Y-m-d', $fecha),
                            'pct_correlativo'   => $correlativo,
                            'pct_codigo'        => $codigo,
                            'pct_modulo'        => $modulo,
                            'pct_estado'        => 1,
                            'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES
                            'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                            'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                            'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                            'pct_usu_mod'       => $this->tank_auth->get_user_id()
                        );
                        $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                        // Datos para el detalle de cada partida
                        $txt_codigo_            = $this->input->post('txt_codigo_' . $indice);
                        $txt_cuenta_            = $this->input->post('txt_cuenta_' . $indice);
                        $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . $indice);
                        $txt_nombre_            = $this->input->post('txt_nombre_' . $indice);
                        $txtdebe_               = $this->input->post('txtdebe_' . $indice);
                        $txthaber_              = $this->input->post('txthaber_' . $indice);
                        // Detalle de cada partida
                        foreach ($txt_codigo_ as $key => $value) {
                            $array_detalle = array(
                                'dpc_id_cnt'        => ($txt_cnt_id_[$key] > 0) ? $txt_cnt_id_[$key] : $defecto_cnt[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Por facturación de productos',
                                'dpc_debe'          => number_format($txtdebe_[$key], 2, '.', ''),
                                'dpc_haber'         => number_format($txthaber_[$key], 2, '.', ''),
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                        }
                    }
                    if ($consolida == 1) {
                        $facturas = explode(',', $contenedorf[$indice]);
                        foreach ($facturas as $k => $v) {
                            //Actualizar el id de la partida contable en el movimiento
                            $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $agregar), array('moi_id' => $v));
                        }
                    } else {
                        /* ********************* Contrapartida en caso de tener productos que afecten inventario ********************* */
                        /*$where['fac_id']        = $contenedorf[$indice];
                        $info['num_fac']        = $this->gsatelite->get_campo('fac_factura', 'fac_numero', array('fac_id'=>$contenedorf[$indice]));
                        $where_existe['fac_id'] = $contenedorf[$indice];
                        $where_existe['art_inventario'] = 1;                            
                        $afecta_inv             = $this->facturacion_model->existe_prod_afec_inv($where_existe);
                        if($afecta_inv[0]['afecta_inv']){
                            $where['cec_id']    = (isset($dtf_centro_costo)) ? $dtf_centro_costo : 0;

                            $this->load->library('../controllers/facturacion/facturar');
                            $res_debe = $this->facturar->generar_contra_partida_factura_afecta_afecta_inv_debe($where,$info);
                            $this->facturar->generar_contra_partida_factura_afecta_inv_haber($where, $res_debe['id_pct']);
                        }
                        */
                        //Actualizar el id de la partida contable en la factura
                        //$this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct' => $agregar),array('fac_id' => $contenedorf[$indice]));   
                        //Actualizar el id de la partida contable en el movimiento
                        if ($procesar[$indice] > 0) {
                            $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $agregar), array('moi_id' => $contenedorf[$indice]));
                        }
                    }
                }
            }
            // Modulo de Planilla
            if ($modulo == 4) {
                // Tipo de partida
                $id_tipo_partida         = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('GASTO'));
                $prefijo_partida = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tipo_partida));
                //print_r($id_tipo_partida); die();
                //Determinar el origen de la partida, este caso es por PLANILLA
                $origen                  = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 5));
                $orp_partida             = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
                // Cuenta contable por defecto
                $defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
                // Id de las planillas
                $txtidplanilla = $this->input->post('txtidplanilla');
                $txthabertotal = $this->input->post('txthabertotal');
                //Recorrer las partidas de planilla
                for ($i = 0; $i < $totalpartidas; $i++) {
                    if ($consolida > 0 || $procesar[$i] > 0) {
                        //Codigo
                        $codigo         = $prefijo_partida . '-' . $txtcorrelativopartida[$i];   // Codigo que tendra la partida
                        // Se guardaran las partidas
                        $array_partida = array(
                            'pct_id_tpd'        => $id_tipo_partida,
                            'pct_id_prc'        => null,
                            'pct_concepto'      => $txtconcepto[$i],
                            'pct_id_orp'        => $orp_partida,
                            'pct_total'         => number_format($txthabertotal[$i], 2, '.', ''),
                            'pct_fecha'         => formatear_fecha('Y-m-d', $fecha),
                            'pct_correlativo'   => $txtcorrelativopartida[$i],
                            'pct_codigo'        => $codigo,
                            'pct_modulo'        => null,
                            'pct_estado'        => 1,
                            'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES
                            'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                            'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                            'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                            'pct_usu_mod'       => $this->tank_auth->get_user_id()
                        );
                        $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                        $txt_codigo_ = $this->input->post('txt_codigo_' . $i);
                        // $txt_cuenta_ = $this->input->post('txt_cuenta_'.$i);
                        $txt_cuenta_ = $this->input->post('txt_cnt_id_' . $i);
                        $txt_nombre_ = $this->input->post('txt_nombre_' . $i);
                        $txtdebe_    = $this->input->post('txtdebe_' . $i);
                        $txthaber_    = $this->input->post('txthaber_' . $i);
                        foreach ($txt_codigo_ as $in => $val) {
                            $array_detalle = array(
                                'dpc_id_cnt'        => $txt_cuenta_[$in][0],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Por generacion de planilla',
                                'dpc_debe'          => number_format($txtdebe_[$in][0], 2, '.', ''),
                                'dpc_haber'         => number_format($txthaber_[$in][0], 2, '.', ''),
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                        }
                        //Actualizar el id de la partida contable en el movimiento
                        $this->gsatelite->actualizar_array('pla_planilla', array('pla_id_pct' => $agregar), array('pla_id' => $txtidplanilla[$i]));
                    }
                }
            }
            // Modulo de Bancos - Partidas Contables
            if ($modulo == 5) {
                // Consolidar - Partida contable
                // Cheques
                $contenedorcheques = $this->input->post('contenedorcheques');
                // Funcion Compartida
                $this->load->library('../controllers/utm/cuentas');
                if ($consolida == 1) {
                    // Arreglo de Cheques
                    $cheques           = explode(',', $contenedorcheques[0]);
                    $key = 0;

                    // Datos para el detalle de cada partida
                    $txt_codigo_            = $this->input->post('txt_codigo_' . ($key + 1));
                    $txt_cuenta_            = $this->input->post('txt_cuenta_' . ($key + 1));
                    $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . ($key + 1));
                    $txt_nombre_            = $this->input->post('txt_nombre_' . ($key + 1));
                    $txtdebe_               = $this->input->post('txtdebe_' . ($key + 1));
                    $txthaber_              = $this->input->post('txthaber_' . ($key + 1));

                    $total  = $this->input->post('txtdebetotal');
                    $info['total_pct']  = $total[$key];

                    // Datos a Enviar 
                    foreach ($txt_codigo_ as $llave => $valor) {
                        if ($txtdebe_[$llave] > 0) {
                            $cnt_proveedor[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                            $cnt_proveedor[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                            $cnt_proveedor[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                            $cnt_proveedor[$llave]['che_monto'] =  $txtdebe_[$llave];
                        } else {
                            $cnt_bancos[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                            $cnt_bancos[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                            $cnt_bancos[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                            $cnt_bancos[$llave]['che_monto'] =  $txthaber_[$llave];
                        }
                    }

                    // Informacion ha enviar
                    $info['proveedor_cnt'] = $cnt_proveedor;
                    $info['bancos_cnt']     = $cnt_bancos;

                    // Condicional
                    $where['che_fecha'] = formatear_fecha('Y-m-d', $fecha);
                    $where['che_id_pct IS NULL'] = null;
                    // Agrupador que obtendra las cuentas
                    $groupby = 'cnt_id';
                    // periodo
                    $info['periodo']    = $periodo;
                    $info['che_fecha'] = formatear_fecha('Y-m-d', $fecha);
                    $info['concepto']   = $conceptos[0];
                    // Funcion compartida el modulo de Bancos que genera la partida automatica
                    $agregar = $this->cuentas->generar_partida_contable_cheque($where, $groupby, null, $info, true, false);
                    //Actualizar el id de la partida contable en el cheque
                    foreach ($cheques as $value) {
                        $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $agregar['id_pct']), array('che_id' => $value));
                    }
                    // No consolidada - Partida Contable
                } else {
                    // Recorrer Cheques
                    foreach ($contenedorcheques as $key => $value) {
                        if ($procesar[$key] > 0) {
                            $value = array_unique(explode(',', $value));
                            $value = $value[0];
                            // Datos para el detalle de cada partida
                            $txt_codigo_            = $this->input->post('txt_codigo_' . ($key + 1));
                            $txt_cuenta_            = $this->input->post('txt_cuenta_' . ($key + 1));
                            $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . ($key + 1));
                            $txt_nombre_            = $this->input->post('txt_nombre_' . ($key + 1));
                            $txtdebe_               = $this->input->post('txtdebe_' . ($key + 1));
                            $txthaber_              = $this->input->post('txthaber_' . ($key + 1));
                            $total  = $this->input->post('txtdebetotal');
                            $info['total_pct']  = $total[$key];

                            // Datos a Enviar 
                            foreach ($txt_codigo_ as $llave => $valor) {
                                if ($txtdebe_[$llave] > 0) {
                                    $cnt_proveedor[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                                    $cnt_proveedor[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                                    $cnt_proveedor[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                                    $cnt_proveedor[$llave]['che_monto'] =  $txtdebe_[$llave];
                                } else {
                                    $cnt_bancos[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                                    $cnt_bancos[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                                    $cnt_bancos[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                                    $cnt_bancos[$llave]['che_monto'] =  $txthaber_[$llave];
                                }
                            }
                            $this->db->limit(1);
                            $reg_cheque = $this->gsatelite->get_tabla('che_cheque', array('che_id' => $value));
                            // Informacion ha enviar
                            $info['proveedor_cnt'] = $cnt_proveedor;
                            $info['bancos_cnt']     = $cnt_bancos;
                            // Concepto para la partida
                            $info['concepto'] = $conceptos[$key];
                            // Condicional
                            $where['che_id'] = $value;
                            $where['che_id_pct IS NULL'] = null;
                            $info['che_fecha'] = ($reg_cheque) ? $reg_cheque[0]['che_fecha'] : formatear_fecha('Y-m-d', $fecha);
                            // Agrupador que obtendra las cuentas
                            $groupby = 'che_id, cnt_id';
                            // Ordenador 
                            $orderby = 'che_id'; //print_r($info);die();
                            // Funcion compartida el modulo de Bancos que genera la partida automatica
                            $agregar = $this->cuentas->generar_partida_contable_cheque($where, $groupby, $orderby, $info, false, false);
                            // Actualizar el ID de Cheque
                            $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $agregar['id_pct']), array('che_id' => $value));
                        }
                    }
                }
            }
            // Modulo de Inventario
            if ($modulo == 6 || $modulo == 11 || $modulo == 12) { //11 = Comprado por caja chica //12 Anulacion de DPV
                // Tipo de partida
                $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('COSTO'));
                //Determinar el origen de la partida, este caso es por inventario
                $origen      = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 1));
                $orp_partida = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
                // Cuenta contable por defecto
                $defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
                $data['defecto_cnt'] = $defecto_cnt;

                foreach ($corr as $indice => $valor) { // Recorrer todas la partidas que se generaran
                    if ($consolida > 0 || $procesar[$indice] > 0) {
                        $codigo      = $id_tipo_partida[0]['tpd_prefijo'] . '-' . $valor;   // Codigo que tendra la partida
                        $correlativo = (int)($valor);                // Correlativo que tendra la partida
                        // Se guardaran las partidas
                        $array_partida = array(
                            'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
                            'pct_id_prc'        => $periodo,
                            'pct_concepto'      => $conceptos[$indice],
                            'pct_id_orp'        => $orp_partida,
                            'pct_total'         => number_format($txt_g_debe[$indice], 2, '.', ''),
                            'pct_fecha'         => formatear_fecha('Y-m-d', $fecha),
                            'pct_correlativo'   => $correlativo,
                            'pct_codigo'        => $codigo,
                            'pct_modulo'        => $modulo,
                            'pct_estado'        => 1,
                            'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES
                            'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                            'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                            'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                            'pct_usu_mod'       => $this->tank_auth->get_user_id()
                        );
                        $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                        // Datos para el detalle de cada partida
                        $txt_codigo_ = $this->input->post('txt_codigo_' . $indice);
                        $txt_cuenta_ = $this->input->post('txt_cuenta_' . $indice);
                        $txt_cnt_id_ = $this->input->post('txt_cnt_id_' . $indice);
                        $txt_nombre_ = $this->input->post('txt_nombre_' . $indice);
                        $txtdebe_    = $this->input->post('txtdebe_' . $indice);
                        $txthaber_   = $this->input->post('txthaber_'  . $indice);
                        // Detalle de cada partida
                        foreach ($txt_codigo_ as $key => $value) {
                            $se_anula = ($modulo == 12) ? "Anulación " : "";
                            $array_detalle = array(
                                'dpc_id_cnt'        => ($txt_cnt_id_[$key] > 0) ? $txt_cnt_id_[$key] : $defecto_cnt[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => $se_anula . 'Documento por Proveedor',
                                'dpc_debe'          => number_format($txtdebe_[$key], 2, '.', ''),
                                'dpc_haber'         => number_format($txthaber_[$key], 2, '.', ''),
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                        }
                    }
                    if ($consolida == 1) {
                        $facturas = explode(',', $contenedorf[$indice]);
                        foreach ($facturas as $k => $v) {
                            //Actualizar el id de la partida contable en la factura
                            if ($modulo == 12) {
                                $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct_anulacion' => $agregar), array('dpv_id' => $v));
                            } else {
                                $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct' => $agregar), array('dpv_id' => $v));
                            }
                        }
                    } else {
                        /* ********************* Contrapartida en caso de tener productos que afecten inventario ********************* */
                        /*$where['fac_id']        = $contenedorf[$indice];
                        $info['num_fac']        = $this->gsatelite->get_campo('fac_factura', 'fac_numero', array('fac_id'=>$contenedorf[$indice]));
                        $where_existe['fac_id'] = $contenedorf[$indice];
                        $where_existe['art_inventario'] = 1;                            
                        $afecta_inv             = $this->facturacion_model->existe_prod_afec_inv($where_existe);
                        if($afecta_inv[0]['afecta_inv']){
                            $where['cec_id']    = (isset($dtf_centro_costo)) ? $dtf_centro_costo : 0;
                            $this->load->library('../controllers/facturacion/facturar');
                            $res_debe = $this->facturar->generar_contra_partida_factura_afecta_afecta_inv_debe($where,$info);
                            $this->facturar->generar_contra_partida_factura_afecta_inv_haber($where, $res_debe['id_pct']);
                        }
                        */
                        if ($procesar[$indice] > 0) {
                            //Actualizar el id de la partida contable en el movimiento
                            if ($modulo == 12) {
                                $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct_anulacion' => $agregar), array('dpv_id' => $contenedorf[$indice]));
                            } else {
                                $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct' => $agregar), array('dpv_id' => $contenedorf[$indice]));
                            }
                        }
                    }
                }
            }
            // Modulo de Bancos - nota de abono
            if ($modulo == 7) { //print_r($this->input->post());die();
                // Consolidar - Partida contable
                // Cheques
                $contenedorcheques = $this->input->post('contenedorcheques');
                // Funcion Compartida
                $this->load->library('../controllers/utm/cuentas');
                if ($consolida == 1) {
                    // // Arreglo de Cheques
                    //print_r($_POST);die();
                    $cheques           = explode(',', $contenedorcheques[0]);
                    $key = 0;
                    foreach ($cheques as $key => $value) {

                        // Datos para el detalle de cada partida
                        $txt_codigo_            = $this->input->post('txt_codigo_' . ($key + 1));
                        $txt_cuenta_            = $this->input->post('txt_cuenta_' . ($key + 1));
                        $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . ($key + 1));
                        $txt_nombre_            = $this->input->post('txt_nombre_' . ($key + 1));
                        $txtdebe_               = $this->input->post('txtdebe_' . ($key + 1));
                        $txthaber_              = $this->input->post('txthaber_' . ($key + 1));

                        $total  = $this->input->post('txtdebetotal');
                        $info['total_pct']  = $total[$key];

                        // Datos a Enviar 
                        foreach ($txt_codigo_ as $llave => $valor) {
                            if ($txtdebe_[$llave] > 0) {
                                $cnt_proveedor[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                                $cnt_proveedor[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                                $cnt_proveedor[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                                $cnt_proveedor[$llave]['che_monto'] =  $txtdebe_[$llave];
                            } else {
                                $cnt_bancos[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                                $cnt_bancos[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                                $cnt_bancos[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                                $cnt_bancos[$llave]['che_monto'] =  $txthaber_[$llave];
                            }
                        }

                        // Informacion ha enviar
                        $info['proveedor_cnt'] = $cnt_proveedor;
                        $info['bancos_cnt']     = $cnt_bancos;

                        // Condicional
                        $where['che_fecha'] = formatear_fecha('Y-m-d', $fecha);
                        $where['che_id_pct IS NULL'] = null;
                        // Agrupador que obtendra las cuentas
                        $groupby = 'cnt_id';
                        // periodo
                        $info['periodo']    = $periodo;
                        $info['che_fecha'] = formatear_fecha('Y-m-d', $fecha);
                        $info['concepto']   = $conceptos[0];
                        // Funcion compartida el modulo de Bancos que genera la partida automatica
                        $agregar = $this->cuentas->generar_partida_contable_cheque($where, $groupby, null, $info, true, false);
                        //Actualizar el id de la partida contable en el cheque

                        $this->gsatelite->actualizar_array('che_cheque', array('che_id_pct' => $agregar['id_pct']), array('che_id' => $value));
                    }
                    // No consolidada - Partida Contable
                } else {
                    // Recorrer Cheques
                    foreach ($contenedorcheques as $key => $value) {
                        if ($procesar[$key] > 0) {
                            if (substr_count($value, ',') > 0) {
                                $value = explode(',', $value);
                                $value = $value[0]; //elegir el primero
                            }
                            // Datos para el detalle de cada partida
                            $txt_codigo_            = $this->input->post('txt_codigo_' . ($key + 1));
                            $txt_cuenta_            = $this->input->post('txt_cuenta_' . ($key + 1));
                            $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . ($key + 1));
                            $txt_nombre_            = $this->input->post('txt_nombre_' . ($key + 1));
                            $txtdebe_               = $this->input->post('txtdebe_' . ($key + 1));
                            $txthaber_              = $this->input->post('txthaber_' . ($key + 1));
                            $total  = $this->input->post('txtdebetotal');
                            $info['total_pct']  = $total[$key];
                            // Datos a Enviar 
                            foreach ($txt_codigo_ as $llave => $valor) {
                                if ($txtdebe_[$llave] > 0) {
                                    $cnt_proveedor[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                                    $cnt_proveedor[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                                    $cnt_proveedor[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                                    $cnt_proveedor[$llave]['che_monto'] =  $txtdebe_[$llave];
                                } else {
                                    $cnt_bancos[$llave]['cnt_id']    =  $txt_cnt_id_[$llave];
                                    $cnt_bancos[$llave]['cnt_cuenta'] =  $txt_cuenta_[$llave];
                                    $cnt_bancos[$llave]['cnt_nombre'] =  $txt_nombre_[$llave];
                                    $cnt_bancos[$llave]['che_monto'] =  $txthaber_[$llave];
                                }
                            }
                            $this->db->limit(1);
                            $reg_cheque = $this->gsatelite->get_tabla('nta_nota_abono', array('nta_id' => $value));
                            // Informacion ha enviar
                            $info['proveedor_cnt'] = $cnt_proveedor;
                            $info['bancos_cnt']     = $cnt_bancos;
                            // Concepto para la partida
                            $info['concepto'] = $conceptos[$key];
                            $info['periodo'] = $periodo;
                            // Condicional
                            $where['nta_id'] = $value;
                            $where['nta_id_pct IS NULL'] = null;
                            $info['nta_fecha'] = ($reg_cheque) ? $reg_cheque[0]['nta_fecha'] : formatear_fecha('Y-m-d', $fecha);
                            // Agrupador que obtendra las cuentas
                            $groupby = 'nta_id, cnt_id';
                            // Ordenador 
                            $orderby = 'nta_id'; //print_r($info);die();
                            // Funcion compartida el modulo de Bancos que genera la partida automatica
                            $agregar = $this->cuentas->generar_partida_contable_nota_abono($where, $groupby, $orderby, $info, false, false);
                            // Actualizar el ID de Cheque
                            $this->gsatelite->actualizar_array('nta_nota_abono', array('nta_id_pct' => $agregar['id_pct']), array('nta_id' => $value));
                        }
                    }
                }
            }

            if (isset($agregar) && $agregar > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
            }

            $this->session->set_flashdata($alerta);
            redirect('modulo_contabilidad/procesos/procesar_partida');
        } else {
            $data['cuentas_cnt']  = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            $ano_actual       = date('Y'); // Quemado
            $mes_actual       = date('m'); // Quemado
            $data['periodo']  = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_estado' => 1)); //'prc_ano' => $ano_actual, 'prc_mes' => $mes_actual, --- restricciones anteriores            
            $data['planilla'] = $this->contabilidad_model->get_tipo_planilla(true);
            $data['titulo_personal'] = "Procesar partida";
            $this->_cargarvista($data);
        }
    }

    // Consulta para obtener las partidas que se guardaran
    function consulta_generar_partida(){
        satelite_validar(true);
        if ($this->input->post('modulo') != 2) {
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        ini_set('max_input_vars', '15000');
        }
        $fecha          = formatear_fecha('Y-m-d', $this->input->post('fecha'));
        $modulo         = $this->input->post('modulo');
        $tipo           = $this->input->post('tipo_inv');
        $id_pla         = $this->input->post('tipo_pla');
        $consolidar     = $this->input->post('consolidar');
        $consultarMes   = $this->input->post('consultarMes');
        //Correlativo de la partida contable
        // Cuenta contable por defecto
        $defecto_cnt    = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
        //Cuenta por defecto
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $data['defecto_cnt'] = $defecto_cnt;
        $data['fecha']       = $fecha;
        if ($modulo == 2) { // Facturacion 
            //La instancia debe colocarse anates de las lineas init_set
            $this->load->library('../controllers/facturacion/facturar');
            ini_set('memory_limit', '4048M');
            ini_set('max_execution_time', '9999');
            ini_set('max_input_vars', '15000');
            $data['modulo']     = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            /********************************************/
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 10));
            if (count($pct_concepto) > 0) {
                $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
            } else {
                $pct_concepto = 'Concepto no definido';
            }
            $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $not_remi = (isset($parametros['NOTA REMISION'])) ? $parametros['NOTA REMISION'] : 0;
            /********************************************/
            if ($consolidar == 1) { // Partida Consolidada
                $html_anulada = '';
                //COMENTAR DESCOMENTAR PARA BUSCAR POR SEMANA (SEMANA EMPIEZA LUNES)
                $where = ($consultarMes) ? array("DATE_FORMAT(fac_fecha_cont,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(fac_fecha_cont)' => $fecha); //POR MES
                // $where = ($consultarMes) ? array("DATE_FORMAT(fac_fecha_cont,'%x%v')" => formatear_fecha('oW', $fecha)) : array('DATE(fac_fecha_cont)' => $fecha); //POR SEMANA
                $where['fac_estado !='] = 0; //omitir las anuladas
                $where['fac_id_tif !='] = $not_remi; //omitir las NOTAS DE REMISION
                $where['fac_id_pct IS NULL'] = null;
                $data['articulos']    = $this->contabilidad_model->obtener_productosxfactura_consolidada_new($where);
                $where['fac_id_pct IS NULL'] = null;
                $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxfactura_consolidada_new($where, 'cuenta_id');
                foreach ($data['dt_articulos'] as $key => $value) {
                    $id_articulo = $value['cuenta_id'];
                }
                $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxfactura($where, 'cxe_id_cnt, cuenta_nombre', null, $consultarMes);
                foreach ($data['impuestos'] as $key => $value) {
                    $id_impuestos = $value['cxe_id_cnt'];
                }
                $where['fac_id_pct IS NULL'] = null;
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_facturas($where, 'cnt_id', null, $consultarMes);
                foreach ($data['cnt_haber'] as $key => $value) {
                    $id_haber = $value['cnt_id'];
                }
                $data['retenciones']    = $this->contabilidad_model->obtener_reten_factura($where, 'dcr_id_cnt', 'fac_id');
            } else { // No Consolidada
                $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INGRESO'));
                $idtipo_cnt_exenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INGRESO_EXENTA'));
                //COMENTAR DESCOMENTAR PARA BUSCAR POR SEMANA (SEMANA EMPIEZA LUNES)
                $where = ($consultarMes) ? array("DATE_FORMAT(fac_fecha_cont,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(fac_fecha_cont)' => $fecha); //POR MES
                // $where = ($consultarMes) ? array("DATE_FORMAT(fac_fecha_cont,'%x%v')" => formatear_fecha('oW',$fecha)) : array('DATE(fac_fecha_cont)' => $fecha); //POR SEMANA
                $where2['dta_id_tcn'] = ($idtipo_cnt > 0) ? $idtipo_cnt : 0;
                $where2['dta_id_tcn_exenta'] = ($idtipo_cnt_exenta > 0) ? $idtipo_cnt_exenta : 0;
                $where['fac_id_pct IS NULL'] = null;
                $where['fac_id_tif !='] = $not_remi; //omitir las NOTAS DE REMISION
                $data['articulos']    = $this->contabilidad_model->obtener_productosxfactura($where, 'fac_id', null, null, $where2);
                $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxfactura($where, 'fac_id, cuenta_id', 'def_id', null, $where2);
                $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxfactura($where, 'cxe_id_cnt, fac_id, imp_id', 'def_id');
                //Retenciones
                $data['retenciones']    = $this->contabilidad_model->obtener_reten_factura($where, 'dcr_id_cnt, fac_id', 'def_id');
                $where['fac_id_pct IS NULL'] = null;
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_facturas($where, 'fac_id', 'fac_id');
                /* ======================================================================================================
                                    Inicio Partida contable para la anulacion de factura
                =========================================================================================================*/
                //$generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA'); 
                //if($generar_partida > 0){                    
                $cantidad_fac = (count($data['articulos']) + 1);
                $data['html_anulada'] = '';
                $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida', $data, true);
                #===============================
                //COMENTAR DESCOMENTAR PARA BUSCAR POR SEMANA (SEMANA EMPIEZA LUNES)
                $where = ($consultarMes) ? array("DATE_FORMAT(fac_fecha_cont,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(fac_fecha_cont)' => $fecha); //POR MES                    
                // $where = ($consultarMes) ? array("DATE_FORMAT(fac_fecha_cont,'%x%v')" => formatear_fecha('oW',$fecha)) : array('DATE(fac_fecha_cont)' => $fecha); //POR SEMANA                   
                $where2 = array();
                $where2['dta_id_tcn'] = ($idtipo_cnt > 0) ? $idtipo_cnt : 0;
                $where2['dta_id_tcn_exenta'] = ($idtipo_cnt_exenta > 0) ? $idtipo_cnt_exenta : 0;
                $where['fac_id_pct_anulacion IS NULL'] = null;
                $where['fac_estado'] = 0;
                $data['articulos']    = $this->contabilidad_model->obtener_productosxfactura($where, 'fac_id', null, null, $where2);
                $where['fac_id_pct_anulacion IS NULL'] = null;
                $where['fac_estado'] = 0;
                $data2['dt_articulos'] = $this->contabilidad_model->obtener_productosxfactura($where, 'fac_id, cuenta_id', 'def_id', null, $where2);
                $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxfactura($where, 'cxe_id_cnt, fac_id', 'def_id');
                //Retenciones
                $data['retenciones']    = $this->contabilidad_model->obtener_reten_factura($where, 'dcr_id_cnt, fac_id', 'def_id');
                $where['fac_id_pct_anulacion IS NULL'] = null;
                $where['fac_estado'] = 0;
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_facturas($where, 'fac_id', 'fac_id');
                //$html_anulada  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_anulada', $data_anu, true);
                $html_anulada = '';
                $data['cantidad_facturas'] = $cantidad_fac;
                $html_anulada_info  =  $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_anula', $data, true);
                //}                                
                /* ======================================================================================================
                                    Fin Partida contable para la anulacion de factura
                =========================================================================================================*/
            }
            if ($consolidar == 1) {
                $data['html_anulada'] = $html_anulada;
                $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida', $data, true);
            } else {
                $data['html_anulada'] = '';
                $info = $info . $html_anulada_info;
            }
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 3) { // Inventario 
            $data['modulo']    = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt']  = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            if ($consolidar == 1) { // Partida Consolidada
                $where['DATE(moi_fecha_mov) >= "' . $fecha . '"'] = null;
                $where['DATE(moi_fecha_mov) <= "' . $fecha . '"'] = null;
                $where['moi_id_pct IS NULL'] = null;
                $vista_inventario_partida = 'datos_generar_partida_inventario';
                switch ($tipo) {
                    case 2: //Salida
                        //$where2['having'] = 'tip_salida = 1';
                        $where['tip_salida'] = 1;
                        $vista_inventario_partida = 'datos_generar_partida_inventario_salida_consolidad';
                        break;
                    case 3: //Traslado
                        //$where2['having'] = 'tip_traslado = 1';
                        $where['tip_traslado'] = 1;
                        break;
                    default: //Entrada
                        //$where2['having'] = 'tip_entrada = 1';
                        $where['tip_entrada'] = 1;
                        break;
                }
                $where2['detalle'] = false;  //'tip_id'              
                $data['articulos']    = $this->contabilidad_model->obtener_productosxfactura_inventario($where, null, null, null, $where2);
                $where2['detalle'] = true; //tip_id
                $data['dt_articulos']    = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'cuenta_id', 'dee_id_moi', null, $where2);
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_movimiento_inventario($where, 'cnt_id', 'moi_id');
                $info  = $this->load->view("modulo_contabilidad/procesos/$vista_inventario_partida", $data, true);
                $datos = array('datos' => $info);
                echo json_encode($datos);
            } else { // No consolidada                
                $where['DATE(moi_fecha_mov) >= "' . $fecha . '"'] = null;
                $where['DATE(moi_fecha_mov) <= "' . $fecha . '"'] = null;
                // $where = ($consultarMes) ? array("DATE_FORMAT(moi_fecha_mov,'%Y%m')" => formatear_fecha('Ym',$fecha)) : array('DATE(moi_fecha_mov)' => $fecha); //POR MES
                $where['moi_id_pct IS NULL'] = null;
                $vista_inventario_partida = "datos_generar_partida_inventario";
                switch ($tipo) {
                    case 2: //Salida
                        $where['tip_salida'] = 1;
                        $vista_inventario_partida = "datos_generar_partida_inventario_salida";
                        break;
                    case 3: //Traslado
                        $where['tip_traslado'] = 1;
                        break;
                    default: //Entrada                        
                        $where['tip_entrada'] = 1;
                        break;
                }
                $where2['detalle'] = false;
                $data['es_salida'] = (isset($where['tip_salida']) && $where['tip_salida']  == 1) ? 1 : 0;
                $data['articulos'] = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'moi_id', 'dee_id_moi');
                $where2['detalle'] = true;
                $data['dt_articulos']    = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'moi_id, cuenta_id', 'dee_id_moi', null, $where2);
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_movimiento_inventario($where, 'moi_id, cnt_id', 'moi_id');
                $info  = $this->load->view("modulo_contabilidad/procesos/$vista_inventario_partida", $data, true);
                $datos = array('datos' => $info);
                echo json_encode($datos);
            }
        }
        if ($modulo == 4) { // Planilla 
            $data['modulo']    = $modulo;
            /*$ingreso_salario   = $this->gsatelite->get_parametro('INGRESO_SALARIO');
            $data['tipo']      = $tipo;
            $data['pla_ingr']  = $this->contabilidad_model->get_ingresos($id_pla);
            $data['pla_desc']  = $this->contabilidad_model->get_descuentos($id_pla);
            $data['datos']     = $this->planilla_model->tabla_generada_planilla($id_pla, $ingreso_salario);*/
            $this->load->library('../controllers/personal/planilla');
            //Segundo parametro es FALSE para que devuelva los datos en lugar de crear la partida            
            $data['resultados'] = $this->planilla->partida_contable_planilla($id_pla, $fecha, FALSE);
            $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_planilla', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
            //die();
        }
        if ($modulo == 5) { // Procesar partida para le modulo Banco 
            $data['modulo']    = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt']  = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            // Filtrado de fecha
            $where = ($consultarMes) ? array("DATE_FORMAT(che_fecha,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(che_fecha)' => $fecha); //POR MES
            $where['che_id_pct IS NULL'] = null;
            $where['che_estado'] = 1;
            $this->load->library('../controllers/utm/cuentas');
            if ($consolidar == 1) { 
                // Partida Consolidada
                // Agrupador que obtendra las cuentas
                $groupby = 'cnt_id';
                // Funcion compartida el modulo de Bancos que genera la partida automatica
                $datos = $this->cuentas->generar_partida_contable_cheque($where, null, null, null, true, true); 
                // var_dump($this->db->last_query());die();
                /*cnt_haber*/
                $dt_datos = $this->cuentas->generar_partida_contable_cheque($where, $groupby, null, null, true, true); //print_r($datos);die();
                $data['cnt_haber']  = (isset($dt_datos['banco_cuentas'])) ? $dt_datos['banco_cuentas'] : 0;
                foreach ($data['cnt_haber'] as $key => $value) {
                    $id_haber = $value['cnt_id'];
                    $padre = $this->verificar_padre($id_haber);
                    $data['cnt_haber'][$key]['padre']['cnt_id'] = ($padre[0] != '') ? $padre[0] : null;
                    $data['cnt_haber'][$key]['padre']['cnt_nombre'] = ($padre[1] != '') ? $padre[1] : null;
                    $data['cnt_haber'][$key]['padre']['cnt_cuenta'] = ($padre[2] != '') ? $padre[2] : null;
                    $data['cnt_haber'][$key]['padre']['cnt_id_cnt_padre'] = ($padre[3] != '') ? $padre[3] : null;
                }
                $data['cheques']    = (isset($datos['proveedor_cuentas'])) ? $datos['proveedor_cuentas'] : 0;
                $data['dt_cheques'] = (isset($dt_datos['proveedor_cuentas'])) ? $dt_datos['proveedor_cuentas'] : 0;
                foreach ($data['dt_cheques'] as $key => $value) {
                    $id_articulo = $value['cnt_id'];
                    $padre = $this->verificar_padre($id_articulo);

                    $data['dt_cheques'][$key]['padre']['cnt_id'] = ($padre[0] != '') ? $padre[0] : null;
                    $data['dt_cheques'][$key]['padre']['cnt_nombre'] = ($padre[1] != '') ? $padre[1] : null;
                    $data['dt_cheques'][$key]['padre']['cnt_cuenta'] = ($padre[2] != '') ? $padre[2] : null;
                    $data['dt_cheques'][$key]['padre']['cnt_id_cnt_padre'] = ($padre[3] != '') ? $padre[3] : null;
                }
            } else {                // Partida No Consolidada
                // Agrupador que obtendra las cuentas
                $groupby = 'che_id, cnt_id';
                // Ordenador 
                $orderby = 'che_id';
                // Funcion compartida el modulo de Bancos que genera la partida automatica
                
                $datos = $this->cuentas->generar_partida_contable_cheque($where, $groupby, $orderby, null, true, true);
                $data['cheques']    = (isset($datos['proveedor_cuentas'])) ? $datos['proveedor_cuentas'] : 0;
                $data['dt_cheques'] = (isset($datos['proveedor_cuentas'])) ? $datos['proveedor_cuentas'] : 0;
                $data['cnt_haber']  = (isset($datos['banco_cuentas'])) ? $datos['banco_cuentas'] : 0;
            }
            $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_banco', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 6) { // Compras
            ini_set('memory_limit', '4048M');
            ini_set('max_execution_time', '9999');
            ini_set('max_input_vars', '15000');
            $data['modulo']     = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('GASTO'));
            $idtipo_cnt_costo = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('COSTO'));
            $idtipo_inventario = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INVENTARIO_EN_TRANSITO'));
            $where = ($consultarMes) ? array("DATE_FORMAT(dpv_fecha_contabilizacion,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(dpv_fecha_contabilizacion)' => $fecha); //POR MES
            $where['dpv_estado > '] = 0;
            $where['dpv_id_cch IS NULL'] = null;
            if ($consolidar == 1) {
                // Partida Consolidada
                $where2['tcn_id'] = $idtipo_cnt;
                $where2['tcn_id_inventario'] = $idtipo_inventario;
                $where2['tcn_id_costo']      = $idtipo_cnt_costo;
                $where2['tcn_id_inv']        = $idtipo_inventario;
                //Articulos                                               
                $data['articulos']    = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv_consolida($where, null, null, null, $where2, $defecto_cnt);
                //Detalle de articulos
                $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv_consolida($where, 'cuenta_id', null, null, $where2, $defecto_cnt);
                //Impuestos
                $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxdocproveedor_no_afecta_inv_consolida($where, 'cxe_id_cnt, cuenta_nombre', 'dxd_id');
                //Haber                
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_docproveedor_consolida($where, 'cuenta_id');
                //Retenciones
                $data['retenciones']   = $this->contabilidad_model->obtener_retencioensxdocproveedor_no_afecta_inv($where, 'dcr_id_cnt, cuenta_nombre', 'dxd_id');
            } else {
                // No Consolidada                                
                $where2['tcn_id_costo'] = $idtipo_cnt_costo;
                $where2['tcn_id_inv']   = $idtipo_inventario;
                $where2['tcn_id']       = $idtipo_cnt;
                //Articulos                
                $data['articulos']  = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv($where, 'dpv_id', null, null, $where2);
                //Detalle de articulos
                $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv($where, 'dpv_id, cuenta_id', 'dxd_id', null, $where2);
                //Impuestos
                $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxdocproveedor_no_afecta_inv($where, 'cxe_id_cnt, dpv_id', 'dxd_id');
                //Haber
                $where2['tcn_id_prv']   =  $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_PAGAR'));
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_docproveedor($where, 'dpv_id', 'dpv_id', $where2);
                //Retenciones
                $data['retenciones']   = $this->contabilidad_model->obtener_retencioensxdocproveedor_no_afecta_inv($where, 'dcr_id_cnt, dpv_id', 'dxd_id');
            }
            $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_compra', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 7) { // Procesar partida para le modulo Banco - nota de abono
            $data['modulo']    = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt']  = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            // Filtrado de fecha
            $where = ($consultarMes) ? array("DATE_FORMAT(nta_fecha,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(nta_fecha)' => $fecha); //POR MES
            $where['nta_id_pct IS NULL'] = null;
            $where['nta_estado'] = 1;
            if ($consolidar == 1) { // Partida Consolidada
                // Agrupador que obtendra las cuentas
                $groupby = 'cnt_id';
                // Funcion compartida el modulo de Bancos que genera la partida automatica
                $this->load->library('../controllers/utm/cuentas');
                $datos = $this->cuentas->generar_partida_contable_nota_abono($where, null, null, null, true, true); //print_r($datos);die();
                /*cnt_haber*/
                $dt_datos = $this->cuentas->generar_partida_contable_nota_abono($where, $groupby, null, null, true, true); //print_r($datos);die();
                //print_r($this->db->last_query());die();
                $data['cnt_haber']  = (isset($dt_datos['banco_cuentas'])) ? $dt_datos['banco_cuentas'] : 0;
                // foreach ($data['cnt_haber'] as $key => $value) {
                //     $id_haber = $value['cnt_id'];
                //     $padre = $this->verificar_padre($id_haber);
                //     $data['cnt_haber'][$key]['padre']['cnt_id'] = ($padre[0] != '')? $padre[0] : null;
                //     $data['cnt_haber'][$key]['padre']['cnt_nombre'] = ($padre[1] != '')? $padre[1] : null;
                //     $data['cnt_haber'][$key]['padre']['cnt_cuenta'] = ($padre[2] != '')? $padre[2] : null;
                //     $data['cnt_haber'][$key]['padre']['cnt_id_cnt_padre'] = ($padre[3] != '')? $padre[3] : null;
                // }
                $data['cheques']    = (isset($datos['proveedor_cuentas'])) ? $datos['proveedor_cuentas'] : 0;
                $data['dt_cheques'] = (isset($dt_datos['proveedor_cuentas'])) ? $dt_datos['proveedor_cuentas'] : 0;
                // foreach ($data['dt_cheques'] as $key => $value) {
                //     $id_articulo = $value['cnt_id'];
                //     $padre = $this->verificar_padre($id_articulo);
                //     $data['dt_cheques'][$key]['padre']['cnt_id'] = ($padre[0] != '')? $padre[0] : null;
                //     $data['dt_cheques'][$key]['padre']['cnt_nombre'] = ($padre[1] != '')? $padre[1] : null;
                //     $data['dt_cheques'][$key]['padre']['cnt_cuenta'] = ($padre[2] != '')? $padre[2] : null;
                //     $data['dt_cheques'][$key]['padre']['cnt_id_cnt_padre'] = ($padre[3] != '')? $padre[3] : null;
                // }
            } else {                // Partida No Consolidada
                // Agrupador que obtendra las cuentas
                $groupby = 'nta_id, cnt_id';
                // Ordenador 
                $orderby = 'nta_id';
                // Funcion compartida el modulo de Bancos que genera la partida automatica
                $this->load->library('../controllers/utm/cuentas');
                $datos = $this->cuentas->generar_partida_contable_nota_abono($where, $groupby, $orderby, null, true, true);
                $datos_p = $this->cuentas->generar_partida_contable_nota_abono($where, 'nta_id', $orderby, null, true, true);
                $data['partidas']   = (isset($datos_p['proveedor_cuentas'])) ? $datos_p['proveedor_cuentas'] : 0;
                $data['cheques']    = (isset($datos['proveedor_cuentas'])) ? $datos['proveedor_cuentas'] : 0;
                $data['dt_cheques'] = (isset($datos['proveedor_cuentas'])) ? $datos['proveedor_cuentas'] : 0;
                $data['cnt_haber']  = (isset($datos['banco_cuentas'])) ? $datos['banco_cuentas'] : 0;
            }
            $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_banco_nota_abono', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 8) { //partida de cxc Pago a Facturas (facturación) - abc_abono_cliente, abf_abono_factura
            //datos generales para la obtención y manipulación de los datos.
            $id_tpd = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO'));
            //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
            $tcn_id_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CAJA'));
            $tcn_id_haber1 = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_COBRAR'));
            $tcn_id_haber2 = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('TRANSITORIA_CXC'));
            // $where = array();
            //Obtener tipo de partida
            // $where['DATE(abc_fecha)'] = $fecha;
            $where = ($consultarMes) ? array("DATE_FORMAT(abc_fecha,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(abc_fecha)' => $fecha);
            $where['abc_id_pct IS NULL'] = null;
            $where['fac_id_origen_devolucion IS NULL'] = null;
            $where['abf_monto >'] = 0;
            $where['abc_estado'] = 1;
            $datos_debe = array();
            $datos_haber = array();
            // $where_debe['tcn_id_debe'] = $tcn_id_debe;
            $where_haber['tcn_id_haber'] = $tcn_id_haber1;
            $where_haber['tcn_id_haber_tran'] = $tcn_id_haber2;
            if ($consolidar == 1) { //por el momento es lo mismo de la individual (para pruebas)
                $groupby_query = "cnt_id";
                $partidas = $this->contabilidad_model->get_pago_cliente_partida($where); //sin group_by
            } else {
                $groupby_query = "abc_id, cnt_id";
                $partidas = $this->contabilidad_model->get_pago_cliente_partida($where, 'abc_id');
            }
            //PARA ANTICIPOS INMERSOS
            $tcn_id_haber_ant = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('ANTICIPOS'));
            $where_haber_ant['tcn_id_haber'] = $tcn_id_haber_ant;
            //generar su respectivo debe y haber para cada partida
            $correlativo_pct = 0;
            foreach ($partidas as $k => &$pct) {
                if (trim($pct['id_referencia']) != '') {
                    $where_debe['tcn_id_debe'] = $tcn_id_debe;
                    $where_det = $where;
                    $where_det["abc_id IN (" . $pct['id_referencia'] . ")"] = null; //se ira sobreescribiendo
                    $debe = $this->contabilidad_model->get_pago_cliente_partida_debe($where_det, $where_debe, $groupby_query);

                    $where_det_abono = $where_det;
                    unset($where_det_abono['fac_id_origen_devolucion IS NULL']);
                    unset($where_det_abono['abf_monto >']);
                    $tcn_id_debe_cub = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
                    $where_det_abono['cxb_id_tcn'] = $tcn_id_debe_cub;
                    $debe_detalle = $this->contabilidad_model->get_pago_cliente_partida_debe_detalle_abono($where_det_abono, $groupby_query);
                    if (count($debe_detalle) > 0) {
                        $suma_detalles = array_sum(array_column($debe_detalle, 'total_debe'));
                        /**
                         * Si la suma de los detalles es igual a la suma del abono se retorna las cuentas detalle.
                         * Sino, se resta el monto de los detalles, y se hace merge con el array
                         */
                        if ($debe[0]['total_debe'] == $suma_detalles) {
                            $debe = $debe_detalle;
                        } else {
                            $debe[0]['total_debe'] -= $suma_detalles;
                            $debe = array_merge($debe, $debe_detalle);
                        }
                    }
                    $where_debe['tcn_id_debe'] = $tcn_id_haber_ant;
                    $debe_anticipo = $this->contabilidad_model->get_pago_anticipo_cliente_partida_debe($where_det, $where_debe, $groupby_query);
                    if (count($debe_anticipo) > 0 && array_sum(array_column($debe_anticipo, 'total_debe')) > 0) {
                        $debe = array_merge($debe, $debe_anticipo);
                        if ($consolidar < 1) {
                            $pct['concepto_partida'] .= ' - Anticipo(s) #' . $debe_anticipo[0]['anl_comprobante'];
                        }
                    }
                    $haber = $this->contabilidad_model->get_pago_cliente_partida_haber($where_det, $where_haber, $groupby_query);
                    //PARA ANTICIPOS INMERSOS
                    $where_det_ant["abc_id IN (" . $pct['id_referencia'] . ")"] = null; //se ira sobreescribiendo
                    $haber_anticipos = $this->contabilidad_model->get_anticipo_cliente_partida_haber($where_det_ant, $where_haber_ant, $groupby_query, 1);
                    $datos_debe[$correlativo_pct] = $debe;
                    $datos_haber[$correlativo_pct] = array_merge($haber, $haber_anticipos);
                    $where_det = array(); //limpiar el where
                    $where_det_ant = array(); //limpiar el where
                    $correlativo_pct++;
                }
            }

            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 12)); //no utilizado
            $data['correlativo_partida'] = $correlativo_partida;
            $data['pct_concepto'] = $pct_concepto; //no utilizado
            $data['partidas'] = $partidas;
            $data['debe'] = $datos_debe;
            $data['haber'] = $datos_haber;
            $data['consolidar'] = $consolidar;
            $info = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_pago_factura', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 9) { //partida de anticipos de clientes
            //datos generales para la obtención y manipulación de los datos.
            $id_tpd = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO'));
            //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
            $tcn_id_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CAJA'));
            $tcn_id_haber = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('ANTICIPOS'));
            $where = array();
            //Obtener tipo de partida
            $where['DATE(anl_fecha)'] = $fecha;
            $where['anl_id_pct IS NULL'] = null;
            $where['anl_id_abc_origen IS NULL'] = null;
            $where['anl_monto >'] = 0;
            $datos_debe = array();
            $datos_haber = array();
            $where_debe['tcn_id_debe'] = $tcn_id_debe;
            $where_haber['tcn_id_haber'] = $tcn_id_haber;
            if ($consolidar == 1) { //por el momento es lo mismo de la individual (para pruebas)
                $groupby_query = "cnt_id";
                $partidas = $this->contabilidad_model->get_anticipo_cliente_partida($where); //sin group_by
            } else {
                $groupby_query = "anl_id, cnt_id";
                $partidas = $this->contabilidad_model->get_anticipo_cliente_partida($where, 'anl_id');
            }
            //generar su respectivo debe y haber para cada partida
            $correlativo_pct = 0;
            foreach ($partidas as $key => $pct) {
                if (trim($pct['id_referencia']) != '') {
                    $correlativo_pct++;
                    $where_det = $where;
                    $where_det["anl_id IN (" . $pct['id_referencia'] . ")"] = null; //se ira sobreescribiendo
                    $debe = $this->contabilidad_model->get_anticipo_cliente_partida_debe($where_det, $where_debe, $groupby_query);
                    $haber = $this->contabilidad_model->get_anticipo_cliente_partida_haber($where_det, $where_haber, $groupby_query);
                    $datos_debe[$key] = $debe;
                    $datos_haber[$key] = $haber;
                    $where_det = array(); //limpiar el where
                }
            }
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 12)); //no utilizado
            $data['correlativo_partida'] = $correlativo_partida;
            $data['pct_concepto'] = $pct_concepto; //no utilizado
            $data['partidas'] = $partidas;
            $data['debe'] = $datos_debe;
            $data['haber'] = $datos_haber;
            $data['consolidar'] = $consolidar;
            $info = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_anticipo_cliente', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 10) {
            $data['modulo']    = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt']  = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            $pct_concept = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 19));
            $pct_concepto = (count($pct_concept) > 0) ? $pct_concept[0]['ccp_descripcion_concepto'] : 'Concepto no definido';
            $consulta_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
            $tipo_partida = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_id', array('tpd_id' => $consulta_tipo_partida));
            $where['DATE(ofp_fecha) >= "' . formatear_fecha('Y-m-d', $fecha) . '"'] = null;
            $where['DATE(ofp_fecha) <= "' . formatear_fecha('Y-m-d', $fecha) . '"'] = null;
            $where['ofp_id_pct IS NULL'] = null;
            $where['ofp_estado'] = 1;
            $groupby = ($consolidar > 0) ? null : 'ofp_id';
            $partidas = $this->contabilidad_model->get_otras_formas_pago_partida($where, $groupby);
            $correlativo_pct = 0;
            $datos_debe = $datos_haber = array();
            foreach ($partidas as $key => $pct) {
                if (trim($pct['id_referencia']) != '') {
                    $cuenta_debe = $this->gsatelite->get_cuenta_contable('dfp_detalle_finanza_proveedor', 'CUENTA_POR_PAGAR', array('dfp_id_prv' => $pct['proveedor'], 'dfp_id_tpg' => 2));
                    $cta_haber = 0;
                    if ($pct['forma_pago'] != 2) { // PENDIENTE VERIFICAR OTRAS FORMAS DE PAGO COMO TARJETAS
                        $this->db->limit(1);
                        $cta_haber = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_id', array("cnt_cuenta LIKE '1010101' OR cnt_nombre LIKE 'CAJA GENERAL'" => null));
                    } else {
                        $this->db->limit(1);
                        $cta_haber = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_id', array("cnt_cuenta LIKE '1010101' OR cnt_nombre LIKE 'CAJA GENERAL'" => null));
                    }
                    $where_det = $where;
                    $where_det["ofp_id IN (" . $pct['id_referencia'] . ")"] = null;
                    $debe = $this->contabilidad_model->get_otras_formas_pago_debe($where_det, $groupby);
                    $datos_debe[$key] = $debe;
                    $haber = $this->contabilidad_model->get_otras_formas_pago_haber($where_det, $cta_haber, $groupby);
                    $datos_haber[$key] = $haber;
                    $where_det = array();
                    $correlativo_pct++;
                }
            }
            $data['correlativo_partida'] = $correlativo_pct;
            $data['pct_concepto'] = $pct_concepto; //no utilizado
            $data['partidas'] = $partidas;
            $data['debe'] = $datos_debe;
            $data['haber'] = $datos_haber;
            $info = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_otras_formas_pago', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 11) {
            ini_set('memory_limit', '4048M');
            ini_set('max_execution_time', '9999');
            ini_set('max_input_vars', '15000');
            $data['modulo']      = $modulo;
            $data['consolidar']  = $consolidar;
            $data['cuentas_cnt'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            $tcn_gasto = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('GASTO'));
            $tcn_invtr = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INVENTARIO_EN_TRANSITO'));
            $tcn_costo = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('COSTO'));
            // $tcn_c_chi = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('FONDOS_CAJA_CHICA'));   
            // COMENTAR / DESCOMENTAR PARA GENERAR PTDAS DE TODO EL MES CASOS ESPECIALES (SOPORTE MAYA)
            // $where = ($consultarMes) ? array("DATE_FORMAT(dpv_fecha_contabilizacion,'%Y%m')" => formatear_fecha('Ym',$fecha)) : array('DATE(dpv_fecha_contabilizacion)' => $fecha); //POR MES
            // $where['dpv_id_cch IS NOT NULL'] = null;   
            $where = array('DATE(dpv_fecha_contabilizacion)' => $fecha, 'dpv_id_cch IS NOT NULL' => null);
            $where2 = array('tcn_id' => $tcn_gasto, 'tcn_id_costo' => $tcn_costo, 'tcn_id_inv' => $tcn_invtr);
            if ($consolidar == 1) { // Partida Consolidada
                $data['articulos']    = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv_consolida($where, null, null, null, $where2, $defecto_cnt);
                $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv_consolida($where, 'cuenta_id', null, null, $where2, $defecto_cnt);
                $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxdocproveedor_no_afecta_inv_consolida($where, 'cxe_id_cnt, cuenta_nombre', 'dxd_id');
                $data['retenciones']  = $this->contabilidad_model->obtener_retencioensxdocproveedor_no_afecta_inv($where, 'dcr_id_cnt, cuenta_nombre', 'dxd_id');
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_docproveedor_caja_chica_consolidada($where, 'cnt_id', 'cnt_id');
            } else { // No Consolidada                                
                $data['articulos']  = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv($where, 'dpv_id', null, null, $where2); //, cuenta_id
                $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv($where, 'dpv_id, cuenta_id', 'dxd_id', null, $where2);
                $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxdocproveedor_no_afecta_inv($where, 'cxe_id_cnt, dpv_id', 'dxd_id');
                $data['retenciones']   = $this->contabilidad_model->obtener_retencioensxdocproveedor_no_afecta_inv($where, 'dcr_id_cnt, dpv_id', 'dxd_id');
                $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_docproveedor_caja_chica($where, 'dpv_id', 'dpv_id');
            }
            $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_compra', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 12) {
            ini_set('memory_limit', '2048M');
            ini_set('max_execution_time', '9999');
            ini_set('max_input_vars', '15000');
            $data['modulo']     = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
                           $this->db->limit(1);
            $cec_defecto = $this->gsatelite->get_campo('cec_centro_costo', "cec_id", array('cec_estado' => 1, 'cec_defecto' => 1));
            $where = array('dpv_estado' => 0, 'DATE(dpv_fecha_contabilizacion)' => $fecha, 'dpv_id_pct_anulacion IS NULL' => null);
            //QUERY DEBERIA SER LA MISMA DE CREAR PERO AL REVES? /// REVISAR
            if ($consolidar > 0) {
                $data['totales'] = $this->contabilidad_model->get_debe_anul_doc_prov($where, null, null, $defecto_cnt);
                $data['cuenta_debe'] = $this->contabilidad_model->get_debe_anul_doc_prov($where, 'cnt_id', 'dpv_id', $defecto_cnt);
                $data['retenciones'] = $this->contabilidad_model->get_retenc_anul_doc_prov($where, 'cuenta_id', 'dpv_id', $defecto_cnt);
                $data['dpv_detalle'] = $this->contabilidad_model->get_detalle_anul_doc_prov($where, 'cuenta, centro', null, $defecto_cnt, $cec_defecto);
                $data['imp_doc_prv'] = $this->contabilidad_model->get_imp_anul_doc_prov($where, 'cuenta_id', null, $defecto_cnt);
            } else {
                $data['totales'] = $this->contabilidad_model->get_debe_anul_doc_prov($where, 'dpv_id', null, $defecto_cnt);
                $data['cuenta_debe'] = $this->contabilidad_model->get_debe_anul_doc_prov($where, 'dpv_id, cnt_id', 'dpv_id', $defecto_cnt);
                $data['retenciones'] = $this->contabilidad_model->get_retenc_anul_doc_prov($where, 'dpv_id, cuenta_id', 'dpv_id', $defecto_cnt);
                $data['dpv_detalle'] = $this->contabilidad_model->get_detalle_anul_doc_prov($where, 'dpv_id, cuenta, centro', null, $defecto_cnt, $cec_defecto);
                $data['imp_doc_prv'] = $this->contabilidad_model->get_imp_anul_doc_prov($where, 'dpv_id, cuenta_id', null, $defecto_cnt);
            }
            $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_anulacion_compra', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
        if ($modulo == 13) {
            $data['modulo'] = $modulo;
            $data['consolidar'] = $consolidar;
            $data['cuentas_cnt']  = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('DEPRECIACIONES'));
            $where = ($consultarMes) ? array("DATE_FORMAT(dep_fecha,'%Y%m')" => formatear_fecha('Ym', $fecha)) : array('DATE(dep_fecha)' => $fecha);
            $where['dep_estado'] = 1;
            $where['dep_id_pct IS NULL'] = null;
            $groupby = ($consolidar > 0) ? null : 'act_id_tac';
            $correlativo_pct = 0;
            $datos_debe = $datos_haber = array();
            $partidas = $this->contabilidad_model->get_depreciar_partida($where, $groupby);
            if (count($partidas) > 0) {
                foreach ($partidas as $k => $val) {
                    if (trim($val['ids_referencias']) != "") {
                        $correlativo_pct++;
                        $where_det = $where;
                        if ($consolidar == 0) {
                            $tipo_act = $val['act_id_tac'];
                            $where_det['act_id_tac'] = $tipo_act;
                        }
                        $datos_debe[$k] = $this->contabilidad_model->get_debe_depreciar_partida($where_det, 'cnt_id');
                        $datos_haber[$k] = $this->contabilidad_model->get_haber_depreciar_partida($where_det, 'cnt_id');
                    }
                }
            }
            $data['partidas'] = $partidas;
            $data['debe'] = $datos_debe;
            $data['haber'] = $datos_haber;
            $data['consolidar'] = $consolidar;
            $info = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_depreciar', $data, true);
            $datos = array('datos' => $info);
            echo json_encode($datos);
        }
    }

    // Modal que mostrara en detalle la partida contable
    function partida_diaria_modal($modulo = NULL, $fecha = NULL, $tipo = NULL, $id_pla = NULL)
    {

        $ano_actual      = date('Y');
        $mes_actual      = date('m');
        $data['periodo'] = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_ano' => $ano_actual, 'prc_mes' => $mes_actual, 'prc_estado' => 1));
        $fecha           = date('Y-m-d', strtotime($fecha));
        $data['cuentas_cnt']  = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);

        if ($modulo == 2) { // Facturacion

            $data['mod']   = $modulo;
            $data['fecha'] = $fecha;
        }

        if ($modulo == 3) { // Inventario

            $data['mod']       = $modulo;
            $data['tipo_inve'] = $tipo;
            $data['fecha']     = $fecha;
            $data['tipo']      = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), null, null, null, true);

            if ($tipo == 1) {
                $this->db->where('tip_entrada', 1);
            }
            if ($tipo == 2) {
                $this->db->where('tip_salida', 1);
            }
            $data['movi_unicos']    = $this->contabilidad_model->datos_inventario_entrada_unicos($fecha, $tipo);
            $data['movi_repetidos'] = $this->contabilidad_model->datos_inventario_entrada_repetidos($fecha, $tipo);
        }


        if ($modulo == 4) { // Planilla

            $data['mod']   = $modulo;
            $data['fecha'] = $fecha;
            $data['tipo']  = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), null, null, null, true);
            $ingreso_salario  = $this->gsatelite->get_parametro('INGRESO_SALARIO');
            $data['id_pla']   = $id_pla;
            $data['pla_ingr'] = $this->contabilidad_model->get_ingresos($id_pla);
            $data['pla_desc'] = $this->contabilidad_model->get_descuentos($id_pla);
            $data['datos']    = $this->planilla_model->tabla_generada_planilla($id_pla, $ingreso_salario);
        }

        $this->load->view('modulo_contabilidad/procesos/partida_modal', $data);
    }

    function agregar_partida_diaria()
    {
        satelite_validar();
        if ($_POST) {

            $deta       = $this->input->post('detalles');
            $de         = $this->input->post('debe');
            $ha         = $this->input->post('haber');
            $modulo     = $this->input->post('modulo');

            $detalles   = unserialize($deta);
            $debe       = unserialize($debe);
            $haber      = unserialize($haber);

            $fec        = $this->input->post('fecha1');
            $fecha      = date('Y-m-d', strtotime($fec));
            $id_tpd     = $this->input->post('tipo');
            $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $id_tpd));
            $corr       = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();

            $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
            $codigo = $tipo_abr . '-' . $numero;

            $array_partida = array(
                'pct_id_tpd' => $this->input->post('tipo'),
                'pct_id_prc' => $this->input->post('id_prc'),
                'pct_concepto' => $this->input->post('concepto_gral'),
                'pct_total' => number_format($this->input->post('total_debe'), 2, '.', ''),
                'pct_fecha' => $fecha,
                'pct_correlativo' => $corr->correlativo,
                'pct_codigo' => $codigo,
                'pct_modulo' => $modulo,
                'pct_estado' => 1,
                'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES
                'pct_fecha_crea' => date('Y-m-d H:i:s'),
                'pct_fecha_mod' => date('Y-m-d H:i:s'),
                'pct_usu_crea' => $this->tank_auth->get_user_id(),
                'pct_usu_mod' => $this->tank_auth->get_user_id(),
            );
            $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

            foreach ($detalles as $deta) {
                $array_detalle = array(
                    'dpc_id_cnt' => $deta['cuenta_id'],
                    'dpc_id_pct' => $agregar,
                    'dpc_concepto' => $deta['concepto'],
                    'dpc_debe' => $deta['debe'],
                    'dpc_haber' => $deta['haber'],
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }

            if ($agregar > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
            }

            $this->session->set_flashdata($alerta);
            redirect('modulo_contabilidad/procesos/procesar_partida');
        } else {
        }

        $data['titulo_personal'] = "Agregar partida contable";
        $this->_cargarvista($data);
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }


    function imprimir_ver_partida_modal($id_pct)
    {
        satelite_validar();
        $data['detalle'] = $this->contabilidad_model->get_detalle_partida($id_pct);
        $data['impresion'] = 1;
        $res = str_pad("1", '6', '0', STR_PAD_LEFT);
        $cabecera = $this->load->view('reporte/header_reportes_conta', array('titulo' => "Listado de partidas", 'solotitulo' => true, 'subtitulo' => "Valores expresados en Dolares de los Estados Unidos", 'num' => $res), true);

        $this->load->library('pdf');
        $html = $this->load->view('modulo_contabilidad/procesos/imprimir_ver_partida_modal', $data, true);
        $html_all = str_replace('td{', 'tdN{', $cabecera) . $html;
        //echo $html_all; die();
        $this->pdf->SetPrintFooter(false);
        $this->pdf->makePDF($html_all);
        //echo $html;
    }


    public function generar_partidas_masivas()
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $tipoProceso = $post_array['tipo_proceso'];
            $urlProceso = "";

            //Documentos por Proveedor Pendientes
            if ($tipoProceso == "1") {
                // $urlProceso = "modulo_compras/procesos/generar_partida_contable_doc_proveedor";
                $urlProceso = "modulo_compras/procesos/generar_partida_contable_doc_proveedor_masiva";
            }

            //Cierre de Caja Chica
            if ($tipoProceso == "2") {
                $urlProceso = "modulo_compras/procesos/generar_partida_contable_caja_chica";
            }

            //Salida de Inventario
            if ($tipoProceso == "3") {
                $urlProceso = "inventario/gestion_productos/generar_partida_contable_salida_inventario_masiva";
            }

            //Abonos de Clientes
            if ($tipoProceso == "4") {
                $urlProceso = "modulo_cuentas_cobrar/procesos/generar_partida_contable_abonos_cliente";
            }

            //Planillas 
            if ($tipoProceso == "5") {
                $urlProceso = "personal/planilla/generar_partida_contable_planilla";
            }

            //Facturas 
            if ($tipoProceso == "6") {
                $urlProceso = "facturacion/facturar/generar_partida_masiva_facturacion";
            }

            //Facturas anuladas 
            if ($tipoProceso == "7") {
                $urlProceso = "facturacion/facturar/generar_partida_masiva_facturacion_anulada";
            }

            //Facturas 
            if ($tipoProceso == "8") {
                $urlProceso = "modulo_cuentas_cobrar/procesos/generar_partida_contable_abonos_cliente_anticipo";
            }

            //cheques
            if ($tipoProceso == "9") {
                $urlProceso = "utm/cuentas/generar_partida_masiva_cheque";
            }

            //anticipo clientes
            if ($tipoProceso == "10") {
                $urlProceso = "modulo_cuentas_cobrar/procesos/partidas_anticipos_pendientes_masiva";
            }

            //transacciones
            if ($tipoProceso == "11") {
                $urlProceso = "utm/transacciones/partidas_transacciones_pendientes_masiva";
            }

            //Facturas Consolidadas
            if ($tipoProceso == "12") {
                $urlProceso = "modulo_contabilidad/procesos/generar_partida_masiva_facturacion_consolidada";
            }

            //Pagos Facturacion Consolidados
            if ($tipoProceso == "13") {
                $urlProceso = "modulo_contabilidad/procesos/generar_ptda_masiva_pagos_facturacion_consolidado";
            }

            //Salida de Inventario
            if ($tipoProceso == "14") {
                $urlProceso = "inventario/gestion_productos/generar_partida_contable_entrada_inventario_masiva";
            }

            //Salida de Inventario Consolidada
            if ($tipoProceso == "15") {
                $urlProceso = "inventario/gestion_productos/partida_consolidada_masiva_salida_inventario";
            }

            echo json_encode(array('url' => $urlProceso));
            die();
        }
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal'] = "Partidas Pendientes";
        cargarvista($data);
    }

    function duplicar_partida($id_pct, $ubicacion)
    {
        satelite_validar();
        if ($_POST) {
            $tipo_partida = $this->input->post('tipo');

            $fec            = $this->input->post('fecha');
            $fecha          = date('Y-m-d', strtotime($fec));
            $centros        = $this->input->post('dtll_centro_costo');
            $cuenta_bd      = $this->input->post('det_c');
            $concepto_bd    = $this->input->post('det_con');
            $debe_bd        = $this->input->post('det_d');
            $haber_bd       = $this->input->post('det_h');
            $detalle_id     = $this->input->post('detalle_id');
            $modulo         = $this->input->post('modulo'); //Pendiente modulo
            $descripts      = $this->input->post('descripcion_fila');

            //$detalle_base = $this->gsatelite->get_tabla('dpc_detalle_partida', array('dpc_id_pct' => $id_pct));

            $corr       = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
            $tipo_abr   = $this->gsatelite->get_campo('tpd_tipo_partida', 'tpd_prefijo', array('tpd_id' => $tipo_partida));
            $numero     = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);
            $codigo     = $tipo_abr . '-' . $numero;

            /*******Ingreso tabla padre************/
            if ($this->input->post('concepto_gral')) { //Valida si tiene concepto
                $array_partida = array(
                    'pct_id_tpd'        => $tipo_partida,
                    'pct_modulo'        => $modulo,
                    'pct_concepto'      => $this->input->post('concepto_gral'),
                    'pct_fecha'         => $fecha,
                    'pct_correlativo'   => $corr->correlativo,
                    'pct_codigo'        => $codigo,
                    'pct_total'         => number_format($this->input->post('total_debe'), 2, '.', ''),
                    'pct_estado'        => 1,
                    'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES COPIAR EL DE LA OTRA
                    'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                    'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                    'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                    'pct_usu_mod'       => $this->tank_auth->get_user_id()
                );
                $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
            }

            if ($pct_id > 0) {
                /*********** INGRESO DE DETALLES ********* */
                foreach ($cuenta_bd as $dato => $valor) {
                    $cuenta_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array("cnt_id" => $valor));
                    $pcc_partida_centro_costo = array(
                        'pcc_id_pct'            => $pct_id,
                        'pcc_id_cec'            => $centros[$dato],
                        'pcc_codigo'            => $cuenta_array[0]["cnt_cuenta"],
                        'pcc_descripcion'       => $cuenta_array[0]["cnt_nombre"],
                        'pcc_estado'            => 1,
                        'pcc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'pcc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'pcc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'pcc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    $pcc_id = $this->gsatelite->ingresar('pcc_partida_centro_costo', $pcc_partida_centro_costo);

                    $array_detalle_bd = array(
                        'dpc_id_pcc'    => $pcc_id,
                        'dpc_id_cnt'    => $valor,
                        'dpc_id_pct'    => $pct_id,
                        'dpc_concepto'  => $concepto_bd[$dato],
                        'dpc_descripcion' => trim($descrip_db[$dato]),
                        'dpc_debe'      => $debe_bd[$dato],
                        'dpc_haber'     => $haber_bd[$dato],
                        'dpc_estado'    => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod'   => $this->tank_auth->get_user_id()
                    );
                    $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_bd);
                }

                /*********** INGRESO DE DETALLES ********* */
                $cuenta = $this->input->post('detalle_c');
                $concepto = $this->input->post('detalle_con');
                $debe = $this->input->post('detalle_d');
                $haber = $this->input->post('detalle_h');
                foreach ($cuenta as $key => $val) {
                    $cuenta_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array("cnt_id" => $valor));
                    $pcc_partida_centro_costo = array(
                        'pcc_id_pct'            => $pct_id,
                        'pcc_id_cec'            => $centros[$val],
                        'pcc_codigo'            => $cuenta_array[0]["cnt_cuenta"],
                        'pcc_descripcion'       => $cuenta_array[0]["cnt_nombre"],
                        'pcc_estado'            => 1,
                        'pcc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'pcc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'pcc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'pcc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $pcc_id = $this->gsatelite->ingresar('pcc_partida_centro_costo', $pcc_partida_centro_costo);

                    $array_detalle = array(
                        'dpc_id_cnt' => $val,
                        'dpc_id_pct' => $pct_id,
                        'dpc_concepto' => $concepto[$key],
                        'dpc_descripcion' => (trim($descripts[$key]) != "") ? trim($descripts[$key]) : null,
                        'dpc_debe' => $debe[$key],
                        'dpc_haber' => $haber[$key],
                        'dpc_estado' => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                }
            }

            if ($pct_id > 0 && $detalle > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
            }

            $this->session->set_flashdata($alerta);

            $volver = $this->input->post('volver');
            $ubicacion = $this->input->post('ubicacion');
            //if ($ubicacion == 1) {
            if ($volver == 1) {
                redirect('modulo_contabilidad/procesos/partida_contable');
            } else {
                redirect('modulo_contabilidad/procesos/editar_partida/' . $pct_id . '/1');
            }
            /*} else {
                if ($volver == 1) {
                    redirect('modulo_contabilidad/procesos/crear_partida_diaria');
                } else {
                    redirect('modulo_contabilidad/procesos/editar_partida/' . $id_pct . '/2');
                }
            }*/
        } else {
            $data['ubicacion']      = $ubicacion;
            $data['partida']        = $id_pct;
            $detalle                = $this->contabilidad_model->get_detalle_partida($id_pct);
            $data['detalle']        = $detalle;
            $info                   = $this->gsatelite->get_tabla('pct_partida_contable', array('pct_id' => $id_pct));
            $data['info']           = $info[0];

            $cuentas                = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
            $selec_cuentas          = '<option value=""></option>';
            foreach ($cuentas as $cuenta) {
                $selec_cuentas .= '<option value="' . $cuenta['cnt_id'] . '">' . $cuenta['cnt_cuenta'] . ' - ' . $cuenta['cnt_nombre'] . '</option>';
            }
            $data['cuentas']        = $cuentas;
            $data['selec_cuentas']  = $selec_cuentas;

            $centros                = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_estado' => 1));
            $selec_centros          = '<option value=""></option>';
            foreach ($centros as $centro) {
                $selec_centros .= '<option value="' . $centro['cec_id'] . '">' . $centro['cec_codigo'] . ' ' . $centro['cec_nombre'] . '</option>';
            }
            $data['centros']        = $centros;
            $data['selec_centros']  = $selec_centros;
            $data['tipo']           = $this->gsatelite->get_dropdown('tpd_tipo_partida', '{tpd_nombre}', '', array('tpd_estado' => 1), $data['info']['pct_id_tpd'], null, null, true);
        }

        $data['titulo_personal'] = "Duplicar partida contable";
        $this->_cargarvista($data);
    }

    public function verificar_padre($cnt_id = null)
    {
        satelite_validar();
        $ajax = null;
        if ($cnt_id == null) {
            $cnt_id = $this->input->post('cnt_id');
            $ajax   = $this->input->post('ajax');
        }

        $datos = $this->db->select("*,(SELECT GROUP_CONCAT( cnt_id,',',cnt_nombre,',',cnt_cuenta,',',cnt_id_cnt_padre ) FROM cnt_cuenta_contable as padre WHERE padre.cnt_id = hijo.cnt_id_cnt_padre) as padre", false)
            ->from('cnt_cuenta_contable as hijo')
            ->where('cnt_id', $cnt_id)->get()->result_array();
        $padre = explode(",", $datos[0]['padre']);

        $abuelo['cnt_id'] = $padre[0];
        $abuelo['cnt_nombre'] = $padre[1];
        $abuelo['cnt_cuenta'] = $padre[2];
        $abuelo['cnt_id_cnt_padre'] = $padre[3];

        if ($ajax == null) {
            return $padre;
        } else {
            //print_r($abuelo);die();
            echo json_encode($abuelo);
        }
    }

    public function guardar_procesar_partida()
    {
        satelite_validar();
        // var_dump($_POST);die();
        $consolidar = $this->input->post('txtconsolidar');
        $procesar = $this->input->post('procesar');
        $n_procesadas = 0;
        $tabla_referencia = $tabla_referencia_otros = "";
        // Se guardaran las partidas
        $modulo = $this->input->post('modulo');
        switch ($modulo) { //ir agrengando casos dependiendo la(s) tabla(s) a víncular con partida
            case 8:
                $tabla_referencia = 'abc_abono_cliente';
                $tabla_referencia_otros = 'anl_anticipo_cliente';
                $tpd =  $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO'));
                break;
            case 9:
                $tabla_referencia = 'anl_anticipo_cliente';
                $tpd =  $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('ANTICIPOS'));
                break;
            case 10:
                $tabla_referencia = 'ofp_otra_forma_pago';
                $tpd =  $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('EGRESOS'));
                break;
            case 13:
                $tabla_referencia = 'dep_depreciacion';
                $tpd =  $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('DIARIO'));
                break;
            default:
                # code...
                break;
        }
        $tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tpd, 'tpd_estado' => 1));
        $prefijo_tabla = current(explode('_', $tabla_referencia));
        $prefijo_tabla_otros = current(explode('_', $tabla_referencia_otros));
        $partidas = $this->input->post('correlativopartida');
        $contenedorpartidas = $this->input->post('contenedorpartidas');
        $contenedorpartidas_otros = $this->input->post('contenedorpartidas_otros');
        $n_partidas = (count($partidas) > 0) ? count($partidas) : 0;
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('DIARIO'));
        $id_tipo_partida = ($id_tipo_partida > 0) ? $id_tipo_partida : null;
        $periodo =  $this->input->post('id_prc');
        $periodo = ($periodo > 0) ? $periodo : null;
        $conceptos = $this->input->post('txtconcepto');
        $debe_pct = $this->input->post('txtdebe');
        $haber_pct = $this->input->post('txthaber');
        $fecha_pct = $this->input->post('fecha');
        $fecha_masiva = $this->input->post('fechasXmes');
        $cod_pct = $this->input->post('txtcorrelativopartida');
        $fecha_actual = date('Y-m-d H:i:s');
        $usuario_actual = $this->tank_auth->get_user_id();
        // var_dump($n_partidas);die();
        for ($i = 0; $i < $n_partidas; $i++) {
            $fecha_partida = (count($fecha_masiva) > 0 && $fecha_masiva[$i] != "") ? $fecha_masiva[$i] : $fecha_pct;
            if ($consolidar > 0 || $procesar[$i] > 0) {
                $correlativo = $partidas[$i];
                $codigo = $tipo_partida[0]['tpd_prefijo'] . '-' . $cod_pct[$i];
                $array_partida = array(
                    'pct_id_tpd'        => $id_tipo_partida,
                    'pct_id_prc'        => $periodo,
                    'pct_concepto'      => $conceptos[$i],
                    'pct_total'         => number_format($debe_pct[$i], 2, '.', ''),
                    'pct_fecha'         => ($fecha_partida) ? formatear_fecha('Y-m-d', $fecha_partida) : date('Y-m-d'),
                    'pct_correlativo'   => $cod_pct[$i],
                    'pct_codigo'        => $codigo,
                    'pct_modulo'        => $modulo,
                    'pct_estado'        => 1,
                    'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES
                    'pct_fecha_crea'    => $fecha_actual,
                    'pct_fecha_mod'     => $fecha_actual,
                    'pct_usu_crea'      => $usuario_actual,
                    'pct_usu_mod'       => $usuario_actual
                );
                $partida_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                $n_procesadas++;
                // Datos para el detalle de cada partida
                $txt_codigo_            = $this->input->post('txt_codigo_' . $correlativo);
                $txt_cuenta_            = $this->input->post('txt_cuenta_' . $correlativo);
                $txt_cnt_id_            = $this->input->post('txt_cnt_id_' . $correlativo);
                $txt_nombre_            = $this->input->post('txt_nombre_' . $correlativo);
                $txtdebe_               = $this->input->post('txtdebe_' . $correlativo);
                $txthaber_              = $this->input->post('txthaber_' . $correlativo);
                // Detalle de cada partida
                for ($n = 0; $n < count($txt_codigo_); $n++) {
                    if ($txt_cnt_id_[$n] > 0 && $partida_id > 0) {
                        $array_detalle = array(
                            'dpc_id_cnt'        => $txt_cnt_id_[$n],
                            'dpc_id_pct'        => $partida_id,
                            'dpc_concepto'      => $txt_nombre_[$n],
                            'dpc_debe'          => number_format($txtdebe_[$n], 2, '.', ''),
                            'dpc_haber'         => number_format($txthaber_[$n], 2, '.', ''),
                            'dpc_estado'        => 1,
                            'dpc_fecha_crea'    => $fecha_actual,
                            'dpc_fecha_mod'     => $fecha_actual,
                            'dpc_usu_crea'      => $usuario_actual,
                            'dpc_usu_mod'       => $usuario_actual
                        );
                        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                    }
                }
                //VINCURLAR EL ID DE LA PARTIDA CON LAS REFERENCIA DE LAS TABLA
                $contenedorpartidas_id = $contenedorpartidas[$i];
                if ($tabla_referencia != '' && trim($contenedorpartidas_id) != '') {
                    $array_update[$prefijo_tabla . '_id_pct'] = $partida_id;
                    $where_update["$prefijo_tabla" . "_id IN ($contenedorpartidas_id)"] = null;
                    $this->gsatelite->actualizar_array($tabla_referencia, $array_update, $where_update);
                    $array_update = array(); //reinicializar
                    $where_update = array(); //reinicializar     
                }
                //VINCURLAR EL ID DE LA PARTIDA CON LAS REFERENCIA DE LAS TABLA (OTRAS TABLAS INVOLUCRADAS)
                $contenedorpartidas_id_otros = str_replace(',,', ',', $contenedorpartidas_otros[$i]);
                if ($tabla_referencia_otros != '' && trim($contenedorpartidas_id_otros) != '') {
                    $array_update_[$prefijo_tabla_otros . '_id_pct'] = $partida_id;
                    $where_update_["$prefijo_tabla_otros" . "_id IN ($contenedorpartidas_id_otros)"] = null;
                    $this->gsatelite->actualizar_array($tabla_referencia_otros, $array_update_, $where_update_);
                    $array_update_ = array(); //reinicializar
                    $where_update_ = array(); //reinicializar     
                }
            }
        }
        if ($n_procesadas > 0) {
            $alerta_texto = $n_procesadas . " Partidas procesadas con éxito";
            $alerta = array('tipo_alerta' => "success", 'titulo_alerta' => "Éxito", 'texto_alerta' => "$alerta_texto");
        } else {
            $alerta_texto = "Error al procesar partidas, favor intente de nuevo";
            $alerta = array('tipo_alerta' => "error", 'titulo_alerta' => "Error", 'texto_alerta' => "$alerta_texto");
        }
        $this->session->set_flashdata($alerta);
        redirect('modulo_contabilidad/procesos/procesar_partida');
    }

    /**
     * @param array $datos_procesar Array de datos principales del procesado de factura ( fecha_partida = Fecha del Procesado de partidas, consolidar_partida =  Flag para consolidar partidas contables,consultar_mes = Parametro para Consulta mensual, modulo = Modulo que realiza la petición)
     * @param int $tipo_proceso Tipo proceso realizado por defecto es el proceso manual de partidas ( 1- Proceso Manual (procesar partidas modulo contable, 2 - Proceso individual de la partida, un registro especifico )
     * @author Mario Marquez
     * @since 2020-02-03
     */
    public function generar_partida_doc_proveedor($datos_procesar = array(), $tipo_proceso = 1)
    {

        $this->load->library('../controllers/facturacion/facturar');
        $fecha_partida = date('Y-m-d');
        $consolidar_partida = 0;
        $consultar_mes = 0;
        $modulo = 6;
        $dpv_id = 0;
        if (isset($datos_procesar['fecha_partida'])) {
            $fecha_partida = $datos_procesar['fecha_partida'];
        }

        if (isset($datos_procesar['consolidar_partida'])) {
            $consolidar_partida = $datos_procesar['consolidar_partida'];
        }

        if (isset($datos_procesar['consultar_mes'])) {
            $consultar_mes = $datos_procesar['consultar_mes'];
        }

        if (isset($datos_procesar['modulo'])) {
            $modulo = $datos_procesar['modulo'];
        }

        $data = null;
        if ($tipo_proceso == 1) {
            ini_set('memory_limit', '4048M');
            ini_set('max_execution_time', '9999');
            ini_set('max_input_vars', '15000');
            $data['cuentas_cnt'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta}-{cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
        } else {
            $dpv_id = $datos_procesar['documento_proveedor'];
        }

        $data['modulo']     = $modulo;
        $data['consolidar'] = $consolidar_partida;
        $defecto_cnt    = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
        //Cuenta por defecto
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');

        if ($consolidar_partida == 1) { // Partida Consolidada
            $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('GASTO'));
            $idtipo_inventario = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INVENTARIO_EN_TRANSITO'));
            $idtipo_cnt_costo         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('COSTO'));
            $where                = array('DATE(dpv_fecha_contabilizacion)' => $fecha_partida);
            if ($dpv_id > 0) {
                $where['dpv_id'] = $dpv_id;
            }
            $where2['tcn_id'] = $idtipo_cnt;
            $where2['tcn_id_inventario'] = $idtipo_inventario;
            $where2['tcn_id_costo']   = $idtipo_cnt_costo;
            $where2['tcn_id_inv']   = $idtipo_inventario;
            //Articulos
            $data['articulos']    = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv_consolida($where, null, null, null, $where2, $defecto_cnt);
            //Detalle de articulos
            $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv_consolida($where, 'cuenta_id', null, null, $where2, $defecto_cnt);

            //Impuestos
            $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxdocproveedor_no_afecta_inv_consolida($where, 'cxe_id_cnt, cuenta_nombre', 'dxd_id');

            //Haber
            $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_docproveedor_consolida($where, 'cuenta_id');

            //Retenciones
            $data['retenciones']   = $this->contabilidad_model->obtener_retencioensxdocproveedor_no_afecta_inv($where, 'dcr_id_cnt, cuenta_nombre', 'dxd_id');
        } else { // No Consolidada
            $idtipo_cnt         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('GASTO'));
            $idtipo_cnt_costo         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('COSTO'));
            $tcn_id_inv         = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INVENTARIO_EN_TRANSITO'));
            $where              = array('DATE(dpv_fecha_contabilizacion)' => $fecha_partida);
            if ($dpv_id > 0) {
                $where['dpv_id'] = $dpv_id;
            }
            $where2['tcn_id']   = $idtipo_cnt;
            $where2['tcn_id_costo']   = $idtipo_cnt_costo;
            $where2['tcn_id_inv']   = $tcn_id_inv;
            //Articulos
            $data['articulos']  = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv($where, 'dpv_id, cuenta_id', null, null, $where2);
            //Detalle de articulos
            $data['dt_articulos'] = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv($where, 'dpv_id, dxd_id, cuenta_id', 'dxd_id', null, $where2);
            //Impuestos
            $data['impuestos']    = $this->contabilidad_model->obtener_impuestosxdocproveedor_no_afecta_inv($where, 'cxe_id_cnt, dpv_id', 'dxd_id');
            //Haber
            $where2['tcn_id_prv']   =  $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('CUENTA_POR_PAGAR'));
            $data['cnt_haber']    = $this->contabilidad_model->obtener_haber_docproveedor($where, 'dpv_id', 'dpv_id', $where2);
            //Retenciones
            $data['retenciones']   = $this->contabilidad_model->obtener_retencioensxdocproveedor_no_afecta_inv($where, 'dcr_id_cnt, dpv_id', 'dxd_id');
        }

        if ($tipo_proceso == 1) {
            $info  = $this->load->view('modulo_contabilidad/procesos/datos_generar_partida_compra', $data, true);
            $datos = array('datos' => $info);
            return json_encode($datos);
        } else {
            //Se guarda la partida y se retorna el Id de Partida;
            $pct_id = 0;
            return $pct_id;
        }
    }

    public function leer_excel_partida()
    {
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        ini_set('max_input_vars', '15000');
        if ($_FILES) {
            $error = $lineas = 0;
            $ctas_validas = $ids_centros = $ids_cuentas = array();
            $filas = '';
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuentas = $this->gsatelite->get_tabla('cnt_cuenta_contable', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL));
            $ctas_validas = array_column($cuentas, 'cnt_id');
            $select_cuenta = '<option value=""></option>';
            foreach ($cuentas as $cuenta) {
                $select_cuenta .= '<option data-aumenta="' . $cuenta["cnt_aumenta"] . '" value="' . $cuenta["cnt_id"] . '">'.trim($cuenta["cnt_cuenta"]).' - '.trim($cuenta["cnt_nombre"]) . '</option>';
            }
            $centros_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => 1), null, null, null, true);
            $drp_centros_costos = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $centros_costo);
            $drp_select_cuentas = $select_cuenta;
            $this->load->library('excel/excel_reader.php');
            $excel = new Excel_reader;
            $excel->read($_FILES["file"]["tmp_name"]);
            $nr_sheets = count($excel->sheets);
            if ($nr_sheets > 0) {
                $i = 0;
                $cec_exists = $cta_exists = $de_ha = $total_debe = $total_haber = 0;
                $texto_error = $cuentas_no = $nivel_no = $cecs_no = $nombres_no = $filas_no = array();
                $excel->sheets[0]['cells'] = array_values($excel->sheets[0]['cells']); //reordena el array que empieza con 1 a 0
                unset($excel->sheets[0]['cells'][0]); // elimina la posicion 0 del array
                $arreglo = $excel->sheets[0]['cells'];
                $id_cec = array_unique(array_filter(array_column($arreglo, 1)));
                $id_cta = array_unique(array_filter(array_column($arreglo, 2)));
                $id_cec = (count($id_cec) > 0) ? $id_cec : array(0);
                $id_cta = (count($id_cta) > 0) ? $id_cta : array(0);
                $centro = $this->db->select('cec_id')->where('cec_estado', 1)->where_in('cec_id', $id_cec)->from('cec_centro_costo')->get()->result_array();
                $ids_centros = array_column($centro, 'cec_id');
                $cuenta = $this->db->select('cnt_cuenta')->where('cnt_estado', 1)->where_in('cnt_cuenta', $id_cta)->from('cnt_cuenta_contable')->get()->result_array();
                $ids_cuentas = array_column($cuenta, 'cnt_cuenta');
                $lineas = count($arreglo);
                foreach ($arreglo as $key => $value) {
                    $cec = $cta = $num_cta = 0;
                    $cec_nombre = $name_cta = "";
                    $centros_costo = $drp_centros_costos;
                    $select_cuenta = $drp_select_cuentas;
                    $i++;
                    if (!(count($value) > 4)) {
                            $filas_no[] = $i;
                        if (!(isset($value[1]))) {
                            $texto_error[] = "Hay celdas vacías en los Centros de Costo";
                        } elseif (!(isset($value[2]) && isset($value[3]))) {
                            $texto_error[] = "Hay celdas vacías en los números o nombres de las Cuentas";
                        } elseif (!(isset($value[4]) && isset($value[5]))) {
                            $texto_error[] = "Hay celdas vacías en el debe o haber (Favor colocar ceros)";
                        }
                    }
                    if (in_array($value[1], $ids_centros)) {
                        $cec = $value[1];
                        $cec_codigo = $this->gsatelite->get_campo('cec_centro_costo', 'cec_codigo', array('cec_id' => $cec));
                        $cec_nombre = $cec_codigo . "&nbsp;-&nbsp;" . $this->gsatelite->get_campo('cec_centro_costo', 'cec_nombre', array('cec_id' => $cec));
                        $centros_costo = str_replace('<option value="'.$cec.'">' . $cec_nombre . '</option>', '<option value="'.$cec.'" selected>' . $cec_nombre . '</option>', $centros_costo);
                        $cec_exists++;
                    } else {
                        $cecs_no[] = $value[1];
                        $texto_error[] = "No se identifican todos los Centros de Costo";
                    }
                    if (in_array($value[2], $ids_cuentas)) {
                        $where_cta = array("cnt_estado" => 1, "cnt_cuenta" => trim($value[2]), "cnt_nombre LIKE '%" . trim(utf8_encode(trim($value[3]))) . "%'" => NULL);
                        $cta_id = $this->gsatelite->get_tabla('cnt_cuenta_contable', $where_cta);
                        if (count($cta_id) > 0) {
                            if (in_array($cta_id[0]['cnt_id'], $ctas_validas)) {
                                $cta = $cta_id[0]['cnt_id'];
                                $num_cta  = trim($cta_id[0]['cnt_cuenta']);
                                $name_cta = trim($cta_id[0]['cnt_nombre']);
                                $d_h = trim($cta_id[0]['cnt_aumenta']);
                                $select_cuenta = str_replace('<option data-aumenta="' . $d_h . '" value="' . $cta . '">' . $num_cta . ' - ' . $name_cta . '</option>', '<option data-aumenta="' . $d_h . '" value="' . $cta . '" selected>' . trim($num_cta) . ' - ' . trim($name_cta) . '</option>', $select_cuenta);
                                $cta_exists++;
                            } else {
                                $nivel_no[] = $cta_id[0]['cnt_id'] . '##' . $cta_id[0]['cnt_id_nic'];
                                $texto_error[] = "Verifique los Niveles de las Cuentas Hijas";
                            }
                        } else {
                            $nombres_no[] = $value[2] . '##' . utf8_encode(trim($value[3]));
                            $texto_error[] = "Verifique los Nombres de las Cuentas";
                        }
                    } else {
                        $cuentas_no[] = $key . '##' . $value[2];
                        $texto_error[] = "No se identifican todos los Números de Cuenta";
                    }
                    if (isset($value[4]) && (is_numeric($value[4]) && $value[4] != 0)) {
                        if (isset($value[5]) && (is_numeric($value[5]) && $value[5] != 0)) {
                                    $debe = 0;
                                    $haber = 0;
                                    $texto_error[] = "Verifique los valores del Debe y Haber";
                                } else {
                                    $de_ha++;
                                    $debe = $value[4];
                                    $haber = 0;
                                    $total_debe += $debe;
                                }
                            } else {
                        if (isset($value[5]) && (is_numeric($value[5]) && $value[5] != 0)) {
                                    $de_ha++;
                                    $debe = 0;
                                    $haber = $value[5];
                                    $total_haber += $haber;
                                } else {
                                    $debe = 0;
                                    $haber = 0;
                                    $texto_error[] = "Verifique los valores del Debe y Haber";
                                }                                
                            }                            
                    if (count($texto_error) == 0) {
                        $filas .= '<tr class="dato' . $i . ' servicio" id="DH_' . $cta . '_' . $cec . '" clase="dato' . $i . '">';
                        $filas .= '<td>';
                        $filas .= '<select style="width:95%;display:none;" name="slcCCOculto[]" data-det_cc="dtll_centro_costo_' . $i . '" id="slcCCIdOculto' . $i . '" class="slcCcDet" placeholder="Seleccione">';
                        $filas .= $centros_costo . '</select>';
                        $filas .= '<label class="label_nom_cc">' . $cec_nombre . '</label>';
                        $filas .= '<input type="hidden" id="dtll_centro_costo_' . $i . '" name="dtll_centro_costo[]" value="' . $cec . '">';
                        $filas .= '</td>';
                        $filas .= '<td class="td-input first">';
                        $filas .= '<select style="width:95%;display:none;" name="slcCntOculto[]" data-dettext_h="detalle_h' . $i . '" data-det_c="detalle_c' . $i . '" id="slcIdOculto' . $i . '" class="slcCntDet" placeholder="Seleccione">';
                        $filas .= $select_cuenta . '</select><input type="hidden" value="' . $cta . '" class="cuenta" id="detalle_c' . $i . '" name="detalle_c[]">';
                        $filas .= '<input type="hidden" value="' . number_format($debe, 2, '.', '') . '" id="detalle_d' . $i . '" name="detalle_d[]">';
                        $filas .= '<input type="hidden" value="' . number_format($haber, 2, '.', '') . '" id="detalle_h' . $i . '" name="detalle_h[]">';
                        $filas .= '<label class="label_nom_cnt">' . $num_cta . '</label>';
                        $filas .= '</td>';
                        $filas .= '<td>';
                        $filas .= '<input type="text" id="concepto_' . $i . '" readonly name="detalle_con[]" value="' . $name_cta . '" class="tables-input ">';
                        $filas .= '</td>';
                        $filas .= '<td>';
                        $filas .= '<textarea rows="1" maxlength="500" name="descripcion_fila[]" class="describe" id="descripcion_fila' . $i . '" readonly>';
                        if (isset($value[6]) && trim($value[6]) != "") {
                            $filas .= trim($value[6]);
                        }
                        $filas .= '</textarea>';
                            $filas .= '</td>';
                        $filas .= '<td class="td-input">';
                        $filas .= '<input type="text" id="debe_' . $i . '" readonly value="' . number_format($debe, 2, '.', '') . '" class="tables-input cero soloNumeros" extras=".-">';
                        $filas .= '</td>';
                        $filas .= '<td>';
                        $filas .= '<input type="text" id="haber_' . $i . '" readonly value="' . number_format($haber, 2, '.', '') . '" class="tables-input cero soloNumeros" extras=".-">';
                        $filas .= '</td>';
                        $filas .= '<td>';
                        $filas .= '<button type="button" id="guardar' . $i . '" class="btn btn-primary btn-mini guardar_fila" style="width:50px;float:left;margin-right:10%;height:30px;display:none;" data-contador="' . $i . '">Guardar</button>';
                        $filas .= '<button type="button" id="editar' . $i . '" class="btn btn-primary btn-mini editar_fila" style="width:50px;float:left;margin-right:10%;height:30px;" data-contador="' . $i . '">Editar</button>';
                        $filas .= '<button type="button" id="eliminar' . $i . '" class="btn btn-danger btn-mini delete_fila" style="width:50px;float:left;margin-right:10%;height:30px;" value="' . $i . '" >Eliminar</button>';
                        $filas .= '</td>';
                            $filas .= '</tr>';
                        }
                    }
                $texto_error = array_unique($texto_error);
                $error = (count($texto_error) > 0) ? 1 : 0;
            }
        }
        $string_error = implode("<br>", $texto_error);
        $respuesta = array('html' => $filas, 'error' => $error, 'lineas' => $lineas, 'debe' => number_format($total_debe, 2, '.', ''), 'haber' => number_format($total_haber, 2, '.', ''), 'cec' => $cec_exists, 'ctas' => $cta_exists, 'montos' => $de_ha, 'error_cuenta' => $cuentas_no, 'error_nivel' => $nivel_no, 'error_cecs' => $cecs_no, 'error_nombre' => $nombres_no, 'error_filas' => $filas_no, 'error_string' => $string_error);
        echo json_encode($respuesta);
        die();
    }

    public function generar_partida_masiva_facturacion_consolidada()
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $periodo = $this->input->post('periodo');
        $array_resultados = array();
        $procesar = array();
        if (trim($periodo != "")) {
            $fecha = '01-' . $periodo;
            $cta_defecto = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
            $prc_id = $this->gsatelite->get_min('prc_periodo_contable', 'prc_id', array('prc_estado' => 1));
            $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $not_remi = (isset($parametros['NOTA REMISION'])) ? $parametros['NOTA REMISION'] : 0;
            $mes_proc = formatear_fecha('Y-m', $fecha);
            $last = formatear_fecha('t', $fecha);
            for ($i = 1; $i <= $last; $i++) {
                $fecha_pro = $mes_proc . '-' . $i;
                $where = array('DATE(fac_fecha_cont)' => formatear_fecha('Y-m-d', $fecha_pro), 'fac_estado !=' => 0, 'fac_id_pct IS NULL' => null);
                $where['fac_id_tif !='] = $not_remi; //omitir las NOTAS DE REMISION
                $datos_factura = $this->contabilidad_model->obtener_productosxfactura_consolidada_new($where);
                if (trim($datos_factura[0]['facturas']) != "") {
                    $procesar[$i]['articulos'] = $datos_factura;
                    $procesar[$i]['dt_articulos'] = $this->contabilidad_model->obtener_productosxfactura_consolidada_new($where, 'cuenta_id');
                    $procesar[$i]['impuestos'] = $this->contabilidad_model->obtener_impuestosxfactura($where, 'cxe_id_cnt, cuenta_nombre');
                    $procesar[$i]['cnt_haber'] = $this->contabilidad_model->obtener_haber_facturas($where, 'cnt_id');
                    $procesar[$i]['fecha'] = formatear_fecha('Y-m-d', $fecha_pro);
                }
            }
            if (count($procesar) > 0) {
                $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_tabla' => 'fac_factura'));
                $orp_partida = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
                $id_tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => 3, 'tpd_estado' => 1));
                $tpd_partida = (count($id_tipo_partida) > 0) ? $id_tipo_partida[0]['tpd_id'] : null;
                $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 10, 'ccp_estado' => 1));
                $concepto = (count($pct_concepto) > 0) ? $pct_concepto[0]['ccp_descripcion_concepto'] : 'Concepto no definido';
                $codigo = ($tpd_partida != null) ? $id_tipo_partida[0]['tpd_prefijo'] . '-' : '';
                foreach ($procesar as $key => $value) {
                    $total = 0;
                    foreach ($value['dt_articulos'] as $k1 => $val1) {
                        $total += $val1['subTotal_dcf2'];
                    }
                    foreach ($value['impuestos'] as $k2 => $val2) {
                        $total += $val2['subtotximpcuenta'];
                    }
                    $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
                    $numero = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
                    $array_partida = array(
                        'pct_id_tpd'        => $tpd_partida,
                        'pct_id_prc'        => $prc_id,
                        'pct_concepto'      => $concepto,
                        'pct_id_orp'        => $orp_partida,
                        'pct_total'         => number_format($total, 2, '.', ''),
                        'pct_fecha'         => formatear_fecha('Y-m-d', $value['fecha']),
                        'pct_correlativo'   => $correlativo_partida,
                        'pct_codigo'        => $codigo . $numero,
                        'pct_modulo'        => 2,
                        'pct_estado'        => 1,
                        'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES
                        'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                        'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                        'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                        'pct_usu_mod'       => $this->tank_auth->get_user_id()
                    );
                    $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                    if ($pct_id > 0) {
                        foreach ($value['cnt_haber'] as $kh => $valh) {
                            $array_detalle1 = array(
                                'dpc_id_cnt' => ($valh['cnt_id'] > 0) ? $valh['cnt_id'] : $cta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $pct_id,
                                'dpc_concepto'      => 'Por facturación de productos',
                                'dpc_debe'          => number_format($valh['total'], 2, '.', ''),
                                'dpc_haber'         => number_format(0, 2),
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle1);
                        }
                        foreach ($value['dt_articulos'] as $ka => $vala) {
                            $array_detalle2 = array(
                                'dpc_id_cnt' => ($vala['cuenta_id'] > 0) ? $vala['cuenta_id'] : $cta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $pct_id,
                                'dpc_concepto'      => 'Por facturación de productos',
                                'dpc_debe'          => number_format(0, 2),
                                'dpc_haber'         => number_format($vala['subTotal_dcf2'], 2, '.', ''),
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle2);
                        }
                        foreach ($value['impuestos'] as $ki => $vali) {
                            $array_detalle3 = array(
                                'dpc_id_cnt' => ($vali['cxe_id_cnt'] > 0) ? $vali['cxe_id_cnt'] : $cta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $pct_id,
                                'dpc_concepto'      => 'Por facturación de productos',
                                'dpc_debe'          => number_format(0, 2),
                                'dpc_haber'         => number_format($vali['subtotximpcuenta'], 2, '.', ''),
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle3);
                        }
                        $array_resultados[] = $pct_id;
                        $facturas = explode(",", $value['articulos'][0]['facturas']);
                        foreach ($facturas as $k => $v) {
                            $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => $pct_id, 'fac_generacion_partida' => 2), array('fac_id' => $v));
                        }
                    }
                }
            }
        }
        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }

    public function generar_ptda_masiva_pagos_facturacion_consolidado()
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $periodo = $this->input->post('periodo');
        $array_resultados =  $procesar = array();
        if (trim($periodo != "")) {
            $tipo_cuentas = json_decode($this->gsatelite->get_parametro('SYS_TIPO_CUENTAS'), true);
            $tcn_id_debe      = $tipo_cuentas['CAJA'];
            $tcn_id_haber1    = $tipo_cuentas['CUENTA_POR_COBRAR'];
            $tcn_id_haber2    = $tipo_cuentas['TRANSITORIA_CXC'];
            $tcn_id_haber_ant = $tipo_cuentas['ANTICIPOS'];
            $tcn_id_debe_cub  = $tipo_cuentas['BANCOS'];
            $prc_id = $this->gsatelite->get_min('prc_periodo_contable', 'prc_id', array('prc_estado' => 1));
            $tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('INGRESO')), 'tpd_estado' => 1));
            $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, null, array('DIARIO'));
            $id_tipo_partida = ($id_tipo_partida > 0) ? $id_tipo_partida : null;
            $groupby_query = "cnt_id";
            $fecha = '01-' . $periodo;
            $mes_proc = formatear_fecha('Y-m', $fecha);
            $last = formatear_fecha('t', $fecha);
            for ($i = 1; $i <= $last; $i++) {
                $correlativo_pct = 0;
                $where = $datos_debe = $datos_haber = array();
                $dia = $mes_proc . '-' . $i;
                $fecha = formatear_fecha('Y-m-d', $dia);
                $where['DATE(abc_fecha)'] = $fecha;
                $where['abc_id_pct IS NULL'] = null;
                $where['fac_id_origen_devolucion IS NULL'] = null;
                $where['abf_monto >'] = 0;
                $where['abc_estado'] = 1;
                $partidas = $this->contabilidad_model->get_pago_cliente_partida($where);
                $where_haber['tcn_id_haber'] = $tcn_id_haber1;
                $where_haber['tcn_id_haber_tran'] = $tcn_id_haber2;
                $where_haber_ant['tcn_id_haber'] = $tcn_id_haber_ant;
                foreach ($partidas as $k => $pct) {
                    if (trim($pct['id_referencia']) != "") {
                        $where_debe['tcn_id_debe'] = $tcn_id_debe;
                        $where_det = $where;
                        $where_det["abc_id IN (" . $pct['id_referencia'] . ")"] = null;
                        $debe = $this->contabilidad_model->get_pago_cliente_partida_debe($where_det, $where_debe, $groupby_query);
                        $where_det_abono = $where_det;
                        unset($where_det_abono['fac_id_origen_devolucion IS NULL']);
                        unset($where_det_abono['abf_monto >']);
                        $where_det_abono['cxb_id_tcn'] = $tcn_id_debe_cub;
                        $debe_detalle = $this->contabilidad_model->get_pago_cliente_partida_debe_detalle_abono($where_det_abono, $groupby_query);
                        if (count($debe_detalle) > 0) {
                            $suma_detalles = array_sum(array_column($debe_detalle, 'total_debe'));
                            if ($debe[0]['total_debe'] == $suma_detalles) {
                                $debe = $debe_detalle;
                            } else {
                                $debe[0]['total_debe'] -= $suma_detalles;
                                $debe = array_merge($debe, $debe_detalle);
                            }
                        }
                        $where_debe['tcn_id_debe'] = $tcn_id_haber_ant;
                        $debe_anticipo = $this->contabilidad_model->get_pago_anticipo_cliente_partida_debe($where_det, $where_debe, $groupby_query);
                        if (count($debe_anticipo) > 0 && array_sum(array_column($debe_anticipo, 'total_debe')) > 0) {
                            $debe = array_merge($debe, $debe_anticipo);
                        }
                        $haber = $this->contabilidad_model->get_pago_cliente_partida_haber($where_det, $where_haber, $groupby_query);
                        $where_det_ant["abc_id IN (" . $pct['id_referencia'] . ")"] = null;
                        $haber_anticipos = $this->contabilidad_model->get_anticipo_cliente_partida_haber($where_det_ant, $where_haber_ant, $groupby_query, 1);
                        $datos_debe[$correlativo_pct] = $debe;
                        $datos_haber[$correlativo_pct] = array_merge($haber, $haber_anticipos);
                        $where_det = array();
                        $where_det_ant = array();
                        $correlativo_pct++;
                        $procesar[$i]['partidas'] = $partidas;
                    }
                }
                if (count($datos_debe) > 0) {
                    $procesar[$i]['debe'] = $datos_debe;
                }
                if (count($datos_haber) > 0) {
                    $procesar[$i]['haber'] = $datos_haber;
                }
            }
            if (count($procesar) > 0) {
                $fecha_actual = date('Y-m-d H:i:s');
                $usuario_actual = $this->tank_auth->get_user_id();
                foreach ($procesar as $key => $value) {
                    foreach ($value['partidas'] as $k1 => $val1) {
                        $fecha_pct = formatear_fecha('Y-m-d', $val1['fecha_codigo']);
                        $contenedorpartidas = $val1['id_referencia'];
                        $contenedorpartidas_otros = $val1['id_referencia_otros'];
                        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
                        $numero = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
                        $codigo = $tipo_partida[0]['tpd_prefijo'] . '-' . $numero;
                        $array_partida = array(
                            'pct_id_tpd'        => $id_tipo_partida,
                            'pct_id_prc'        => $prc_id,
                            'pct_concepto'      => $val1['concepto_partida'],
                            'pct_total'         => number_format($val1['total_partida'], 2, '.', ''),
                            'pct_fecha'         => ($fecha_pct) ? $fecha_pct : date('Y-m-d'),
                            'pct_correlativo'   => $numero,
                            'pct_codigo'        => $codigo,
                            'pct_modulo'        => 8,
                            'pct_estado'        => 1,
                            'pct_editable_periodo' => 1, //PARCHE RAPIDO VERIFICAR DESPUES
                            'pct_fecha_crea'    => $fecha_actual,
                            'pct_fecha_mod'     => $fecha_actual,
                            'pct_usu_crea'      => $usuario_actual,
                            'pct_usu_mod'       => $usuario_actual
                        );
                        $ptda_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                        if ($ptda_id > 0) {
                            foreach ($value['debe'] as $llave => $valor) {
                                if (is_array($valor)) {
                                    foreach ($valor as $k2 => $val2) {
                                        $array_detalle_d = array(
                                            'dpc_id_cnt'        => $val2['cnt_id'],
                                            'dpc_id_pct'        => $ptda_id,
                                            'dpc_concepto'      => $val1['concepto_partida'],
                                            'dpc_debe'          => number_format($val2['total_debe'], 2, '.', ''),
                                            'dpc_haber'         => number_format($val2['total_haber'], 2, '.', ''),
                                            'dpc_estado'        => 1,
                                            'dpc_fecha_crea'    => $fecha_actual,
                                            'dpc_fecha_mod'     => $fecha_actual,
                                            'dpc_usu_crea'      => $usuario_actual,
                                            'dpc_usu_mod'       => $usuario_actual
                                        );
                                        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_d);
                                    }
                                }
                            } //end debe
                            foreach ($value['haber'] as $llave => $valor) {
                                if (is_array($valor)) {
                                    foreach ($valor as $k3 => $val3) {
                                        $array_detalle_h = array(
                                            'dpc_id_cnt'        => $val3['cnt_id'],
                                            'dpc_id_pct'        => $ptda_id,
                                            'dpc_concepto'      => $val1['concepto_partida'],
                                            'dpc_debe'          => number_format($val3['total_debe'], 2, '.', ''),
                                            'dpc_haber'         => number_format($val3['total_haber'], 2, '.', ''),
                                            'dpc_estado'        => 1,
                                            'dpc_fecha_crea'    => $fecha_actual,
                                            'dpc_fecha_mod'     => $fecha_actual,
                                            'dpc_usu_crea'      => $usuario_actual,
                                            'dpc_usu_mod'       => $usuario_actual
                                        );
                                        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_h);
                                    }
                                }
                            } //end haber
                            if ($contenedorpartidas != '0' && trim($contenedorpartidas) != '') {
                                $this->gsatelite->actualizar_array("abc_abono_cliente", array("abc_id_pct" => $ptda_id), array("abc_id IN ($contenedorpartidas)" => null));
                            }
                            if ($contenedorpartidas_otros != '0' && trim($contenedorpartidas_otros) != '') {
                                $this->gsatelite->actualizar_array('anl_anticipo_cliente', array("anl_id_pct" => $ptda_id), array("anl_id IN ($contenedorpartidas_otros)" => null));
                            }
                            $array_resultados[] = $ptda_id;
                        }
                    }
                }
            }
        }
        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }
}
