<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class configuracion extends CI_controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
		$this->load->model('gsatelite');
		$this->load->model('contabilidad_model');
    }

    function activacion_periodo($anio = 0) {   
        $periodos_contables = $this->tank_auth->generar_periodos_contables();
        $periodos_contablesss = $this->tank_auth->get_periodo_contable();
    	$data['periodos'] = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_ano' => $anio));
    	$data['anio']=$anio;
    	$jefe = 0;
    	$jefe_conta = $this->gsatelite->get_parametro_emp('SYS_ROL_JEFE_CONTABILIDAD',0);
    	$rols_array = $this->gsatelite->get_tabla("uxr_usuarioxrol", array("uxr_id_usu" => $this->tank_auth->get_user_id()));
    	foreach ($rols_array as $rol) {
    		if ($rol["uxr_id_rol"] == $jefe_conta) {
    			$jefe++;
    		}
    	}
		$data['esjefe'] = $jefe;
        $fecha = date('Y-m-j');
        $fechas = array();
        for ($i=0; $i <= 4; $i++) { 
            $fechas[$i] = date ( 'Y' , strtotime ( '-'.$i.' year',strtotime($fecha)) );
        }
        $data["fecha"] = $fechas;
        //print_r($fechas);die();
    	$data['titulo_personal']="Activación de periodos";
	    $this->_cargarvista($data);
    }

    function agregar_periodo() {	
    	satelite_validar();
    	if ($_POST) {
    		$anio = $this->input->post('periodo');
    		$query = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_ano' =>$anio));
    		$existe = count($query);
    		$codigo = $anio;
    		if ($existe <=0) {
    			for($i = 1; $i <= 12; $i++){
    				$codigof = ($i < 10) ? $codigo . '0' . $i : $codigo . $i;
    				$array_periodo=array(
    					'prc_ano'=>$anio,
    					'prc_mes'=>$i,
    					'prc_codigo'=>$codigof,
    					'prc_estado'=> 1,
    					'prc_fecha_crea'=>date('Y-m-d H:i:s'),
    					'prc_fecha_mod'=>date('Y-m-d H:i:s'),
    					'prc_usu_crea'=>$this->tank_auth->get_user_id(),
    					'prc_usu_mod' =>$this->tank_auth->get_user_id()
    				);
    				$agregar = $this->gsatelite->ingresar('prc_periodo_contable', $array_periodo);
    			}
    		}
    		$data['periodos']=$this->gsatelite->get_tabla('prc_periodo_contable', array('prc_ano' => $anio));
    		$jefe = 0;
    		$jefe_conta = $this->gsatelite->get_parametro_emp('SYS_ROL_JEFE_CONTABILIDAD',0);
    		$rols_array = $this->gsatelite->get_tabla("uxr_usuarioxrol", array("uxr_id_usu" => $this->tank_auth->get_user_id()));
    		foreach ($rols_array as $rol) {
    			if ($rol["uxr_id_rol"] == $jefe_conta) {
    				$jefe++;
    			}
    		}
    		$data['esjefe'] = $jefe;
			$respuesta=array(
				'html'=>$this->load->view('modulo_contabilidad/configuracion/consulta_periodo_contable', $data, true)
			);
			echo json_encode($respuesta);
		}
    }

    function eliminar_periodo() {
    	$anio = $this->input->post('periodo');
    	$query= $this->contabilidad_model->eliminar_periodos($anio);
    	$existe=count($query);
    	if ($existe > 0) {
    		$resp = 1;
    	}else{
    		$resp = 0;
    		$this->gsatelite->borrado_general('prc_periodo_contable',array('prc_ano'=>$anio));
    	}
    	$data['periodos']=$this->gsatelite->get_tabla('prc_periodo_contable', array('prc_ano' => $anio));
    	 $respuesta=array(
			'html'=>$this->load->view('modulo_contabilidad/configuracion/consulta_periodo_contable', $data, true), 'resp'=>$resp);
			echo json_encode($respuesta);
    }

    function consulta_periodo_contable() {
		$periodo = $this->input->post('periodo');
		$data['periodos']=$this->gsatelite->get_tabla('prc_periodo_contable', array('prc_ano' => $periodo));
		$jefe = 0;
		$jefe_conta = $this->gsatelite->get_parametro_emp('SYS_ROL_JEFE_CONTABILIDAD',0);
		$rols_array = $this->gsatelite->get_tabla("uxr_usuarioxrol", array("uxr_id_usu" => $this->tank_auth->get_user_id()));
		foreach ($rols_array as $rol) {
			if ($rol["uxr_id_rol"] == $jefe_conta) {
				$jefe++;
			}
		}
		$data['esjefe'] = $jefe;
		$respuesta=array(
			'html'=>$this->load->view('modulo_contabilidad/configuracion/consulta_periodo_contable', $data, true));
		echo json_encode($respuesta);
	}

	function verificar_periodo()
	{
		$ano = $this->input->post('ano');
		$resp = 0;
		$periodos = $this->gsatelite->get_tabla('prc_periodo_contable');
		foreach ($periodos as $key) {
			if ($key['prc_ano'] == $ano && $key['prc_estado'] == 1) {
				$resp = 1;
			}
		}
		echo json_encode(array('resp'=>$resp));
	}	

	function activar_periodo($id_prc, $anio, $keeplock = null){
		satelite_validar();
		$codigo = $this->gsatelite->get_campo('prc_periodo_contable', 'prc_codigo', array('prc_id' => $id_prc));
		$array_periodo = array(
			'prc_estado' => 1,
			'prc_fecha_mod'=>date('Y-m-d H:i:s'),
			'prc_usu_mod' =>$this->tank_auth->get_user_id()
		);
		/* SI ES EL PERIODO CONTABLE VIGENTE O ACTIVA FULL SE TOMARA COMO ACTUAL */
		if ($keeplock) {
			$array_periodo['prc_reactivado'] = 1;//RAMATER = 0 SIEMPRE
		} else {
			$array_periodo['prc_reactivado'] = 0;
			$array_partida = array(
				'pct_editable_periodo' => 1,
				'pct_fecha_mod' => date('Y-m-d H:i:s'),
				'pct_usu_mod' => $this->tank_auth->get_user_id()
			);
			$rsptda = $this->gsatelite->actualizar_array('pct_partida_contable', $array_partida, array('pct_estado' => 1, 'pct_id_prc' => $id_prc));
		}
		$resp = $this->gsatelite->actualizar_array('prc_periodo_contable', $array_periodo, array('prc_id'=>$id_prc));
		
		$periodos = $this->tank_auth->generar_periodos_contables();
		@session_start();
		$_SESSION[$this->tank_auth->prefijo_sys.'periodo_contable'] = (count($periodos) > 0 )? $periodos : null;
		if ($resp > 0) {
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro Ingresado",'texto_alerta'=>"El periodo se ha activado correctamente.");
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error en Registro",'texto_alerta'=>"El periodo no se ha podido activar.");
		}
		$this->session->set_flashdata($alerta);
		redirect('modulo_contabilidad/configuracion/activacion_periodo/' . $anio);		
		/*
		if ($_POST) {
    		$id_prc = $this->input->post('id_periodo');
    		$anio_ = $this->input->post('anio_');
    		//die(var_dump($_POST));
    			$array_periodo=array(
					'prc_estado'=>1,
					'prc_fecha_mod'=>date('Y-m-d H:i:s'),
					'prc_usu_mod' =>$this->tank_auth->get_user_id()
				);
			$resp = $this->gsatelite->actualizar_array('prc_periodo_contable', $array_periodo, array('prc_id'=>$id_prc));

			$periodos = $this->tank_auth->generar_periodos_contables();

            @session_start();
            $_SESSION[$this->tank_auth->prefijo_sys.'periodo_contable'] = (count($periodos) > 0 )? $periodos : null;

			if ($resp == 1 ) {
				$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro Ingresado",'texto_alerta'=>"El periodo se ha activado correctamente.");
				$this->session->set_flashdata($alerta);
				$direccion = base_url('modulo_contabilidad/configuracion/activacion_periodo/'.$anio_);
				$direct = array('direccion' => $direccion );
				$this->session->set_flashdata($direct);
				redirect('modulo_contabilidad/configuracion/activacion_periodo/');
			}
    	}else{
    		$periodo = $this->gsatelite->get_tabla('prc_periodo_contable',array('prc_estado' =>1)); // 'prc_ano'=>$anio
    		$activo = 0;
    		$existe = count($periodo);
    		if ($existe > 0) {
    			// $activo = 1;
    		}
    		$data['activo'] = $activo;
    		$data['id_periodo'] = $id_prc;
    		$data['info'] = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_id' => $id_prc ));
    		$data['titulo_personal']="Editar periodo";
	    	$this->load->view('modulo_contabilidad/configuracion/activar_periodo',$data);
    	}
    	*/
	}

    function desactivar_periodo($id_prc, $anio){
    	satelite_validar();
    	$array_periodo = array(
    		'prc_estado' => 0,
    		'prc_reactivado'=> 0,
    		'prc_fecha_mod' => date('Y-m-d H:i:s'),
    		'prc_usu_mod' => $this->tank_auth->get_user_id()
    	);
    	$resp = $this->gsatelite->actualizar_array('prc_periodo_contable', $array_periodo, array('prc_id'=>$id_prc));
    	$jefe_conta = $this->gsatelite->get_parametro_emp('SYS_ROL_JEFE_CONTABILIDAD',0);
    	if ($jefe_conta > 0) {///VER SI SERA POR MEDIO DE PARAMETRO O SI SE BLOQUEARA PARA TODAS LAS PARTIDAS //FALSE EN RAMATER
    		$array_partida = array(
    			'pct_editable_periodo' => 0,
    			'pct_fecha_mod' => date('Y-m-d H:i:s'),
    			'pct_usu_mod' => $this->tank_auth->get_user_id()
    		);
    		$resp = $this->gsatelite->actualizar_array('pct_partida_contable', $array_partida, array('pct_estado' => 1, 'pct_id_prc' => $id_prc));
    	}
		$periodos = $this->tank_auth->generar_periodos_contables();
		@session_start();
		$_SESSION[$this->tank_auth->prefijo_sys.'periodo_contable'] = (count($periodos) > 0 )? $periodos : null;
		if ($resp > 0) {
			$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro Ingresado",'texto_alerta'=>"El periodo se ha desactivado correctamente.");
		} else {
			$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error en Registro",'texto_alerta'=>"El periodo no se ha podido desactivar.");
		}
		$this->session->set_flashdata($alerta);
		redirect('modulo_contabilidad/configuracion/activacion_periodo/' . $anio);
		/*
        if ($_POST) {
            $id_prc = $this->input->post('id_periodo');
            $anio_ = $this->input->post('anio_');
            $array_periodo = array(
                'prc_estado' => 0,
                'prc_fecha_mod' => date('Y-m-d H:i:s'),
                'prc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $resp = $this->gsatelite->actualizar_array('prc_periodo_contable', $array_periodo, array('prc_id' => $id_prc));
            $periodos = $this->tank_auth->generar_periodos_contables();
            @session_start();
            $_SESSION[$this->tank_auth->prefijo_sys.'periodo_contable'] = (count($periodos) > 0)? $periodos : null;
            
            if ($resp == 1) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El periodo se ha activado correctamente.");
                $this->session->set_flashdata($alerta);
                $direccion = base_url('modulo_contabilidad/configuracion/activacion_periodo/' . $anio_);
                $direct = array('direccion' => $direccion);
                $this->session->set_flashdata($direct);
                redirect('modulo_contabilidad/configuracion/activacion_periodo/');
            }
        } else {
            $data['activo'] = 0;
            $data['id_periodo'] = $id_prc;
            $data['info'] = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_id' => $id_prc));
            $data['titulo_personal'] = "Editar periodo";
            $this->load->view('modulo_contabilidad/configuracion/desactivar_periodo', $data);
        }
		*/
    }

    function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();		
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}