<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Catalogos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('contabilidad_model');
        //$this->load->library('tank_auth');
    }

    function cuenta_configuracion($reporte_contable = null) {
        $this->load->library('tank_auth');

        $id_usuario = $this->tank_auth->get_user_id();
        //obtengo el nombre del reporte contable mediente el id en al URL
        $data_rep_cont =  $this->gsatelite->get_tabla('rep_reporte_contable', array('rep_id' => $reporte_contable));
        //Obtengo el orden mayor actual en la tabla y se le agregar 1 por ser valor a ingresar
        $max_cfr_orden = 1 + $this->gsatelite->get_max("cfr_configuracion_reporte", "cfr_orden");

        $crud = new grocery_CRUD();
        $crud->unset_export();
        $crud->unset_print();
        //Si no manda un valor en la URL no tiene sentido mostrar el boton de agregar
        if($reporte_contable == null) {
            $crud->unset_add();
        }
        //verificaremos si estamos editando o no, por defecto decimos que no
        $id_edit = 0;

        $crud->set_table("cfr_configuracion_reporte");
        $crud->set_subject("Cuenta configuracion - ".$data_rep_cont[0]["rep_nombre"]);
        $crud->columns("cfr_id_padre", "cfr_titulo", "cfr_operacion", "cfr_grupo", "cfr_orden", "cfr_estado", "cuentas");
        $crud->fields("cfr_id_padre", "cfr_id_rep", "cfr_titulo", "cfr_operacion", "cfr_orden", "cfr_grupo", "cfr_subrayado", "cfr_estado", "cuentas", "cfr_usu_creacion", "cfr_fecha_creacion", "cfr_usu_modificacion", "cfr_fecha_modificacion");
        $crud->add_fields("cfr_id_padre", "cfr_id_rep", "cfr_titulo", "cfr_operacion", "cfr_grupo", "cfr_subrayado", "cfr_orden","cfr_estado", "cuentas", "cfr_usu_creacion", "cfr_fecha_creacion", "cfr_usu_modificacion", "cfr_fecha_modificacion");
        $crud->edit_fields("cfr_id_padre", "cfr_id_rep", "cfr_titulo", "cfr_operacion", "cfr_grupo", "cfr_orden", "cfr_subrayado", "cfr_estado", "cuentas", "cfr_usu_creacion", "cfr_fecha_creacion", "cfr_usu_modificacion", "cfr_fecha_modificacion");
        $crud->field_type('cfr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        $crud->field_type('cfr_operacion', 'dropdown', array('+' => 'Más (+)', '-' => 'Menos (-)'));
        $crud->field_type('cfr_grupo', 'dropdown', array('1' => 'Si', '0' => 'No'));
        $crud->field_type('cfr_subrayado', 'dropdown', array('1' => 'Si', '0' => 'No'));
        $crud->field_type('cfr_orden', 'integer');
        $crud->required_fields("cfr_titulo", "cfr_estado");
        $crud->field_type('cfr_id_rep', 'hidden', $reporte_contable);
        //$crud->field_type('cfr_orden', 'hidden', $max_cfr_orden);

        $crud->display_as('cfr_id_rep', "Reporte Contable");
        $crud->display_as('cfr_id_padre', "Dependiencia");
        $crud->display_as("cfr_estado", 'Estado');
        $crud->display_as("cfr_titulo", "Titulo");
        $crud->display_as("cfr_operacion", "Operacion");
        $crud->display_as("cfr_grupo", "Grupo");
        $crud->display_as("cfr_orden", "Orden");
        $crud->display_as("cuentas", "Cuentas Contables");
        $crud->display_as("padre", "Padre");
        $crud->display_as("cfr_subrayado", "Subrayado");

        //$crud->set_rules('cfr_orden','Pan ','callback_orden_max');

        $auditoria = array(
            'cxf_estado' => 1, 
            'cxf_usu_creacion' => $id_usuario, 
            'cxf_fecha_creacion' =>  date('Y-m-d H:i:s'), 
            'cxf_usu_modificacion' => $id_usuario, 
            "cxf_fecha_modificacion" => date('Y-m-d H:i:s')
        );

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cfr_usu_creacion', 'hidden', $id_usuario);
            $crud->field_type('cfr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('cfr_usu_modificacion', 'hidden', $id_usuario);
            $crud->field_type('cfr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('cfr_usu_creacion', 'hidden');
            $crud->field_type('cfr_fecha_creacion', 'hidden');
            $crud->field_type('cfr_usu_modificacion', 'hidden', $id_usuario);
            $crud->field_type('cfr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            //Detecta que haya mas de una coincidencia de la palabra edit en ls url
            if (substr_count(uri_string(), "edit") > 0) {
                //Primero convertimos a array los valores de la URL y luego obtenemos el ultimo(que sabemos que es el ID) con la funcion end
                //Igual sirve esto $get_id = $this->uri->segment(6);
                $id_edit = end(explode("/", uri_string()));
            }
        }
        $crud->set_relation("cfr_id_padre", "cfr_configuracion_reporte", "cfr_titulo", array("cfr_estado" => 1, "cfr_id_rep" => $reporte_contable, "cfr_id !=" => $id_edit));
        $crud->set_relation_n_n("cuentas", "cxf_cuentaxconfiguracion","cnt_cuenta_contable", "cxf_id_cfr", "cxf_id_cnt", "{cnt_cuenta} - {cnt_nombre}", null, array("cnt_estado" => "1"), $auditoria);
        $crud->where("cfr_configuracion_reporte.cfr_id_rep", $reporte_contable);

        $data['titulo_personal'] = "Cuenta Configuracion";
        $this->_cargarvista($data, $crud->render());
    }

    function orden_max($str) {
        if ($this->uri->segment(6)) {
            $id_cfr = $this->uri->segment(6);
            $orden = $this->input->post('cfr_orden');
            $max_orden = $this->gsatelite->get_max('cfr_configuracion_reporte', 'cfr_orden');
            $data = $this->gsatelite->get_tabla('cfr_configuracion_reporte', array('cfr_orden' => $orden));
            if($data[0]['cfr_id'] == $id_cfr) {
                if($orden >= $max_orden) {
                    return true;
                } else {
                    $this->form_validation->set_message('orden_max', 'Ingrese un número de orden mayor ha '.$max_orden);
                    return false;
                }
            } else {
                if($orden > $max_orden) {
                    return true;
                } else {
                    $this->form_validation->set_message('orden_max', 'Ingrese un número de orden mayor o igual ha '.$max_orden);
                    return false;
                }
            }
        } else {
            $orden = $this->input->post('cfr_orden');
            $max_orden = $this->gsatelite->get_max('cfr_configuracion_reporte', 'cfr_orden');
            if($orden > $max_orden) {
                return true;
            } else {
                $this->form_validation->set_message('orden_max', 'Ingrese un número de orden mayor a '.$max_orden);
                return false;
            }
        }
    }

    function reportes_contables() {
        $this->load->library('tank_auth');
        $id_usuario = $this->tank_auth->get_user_id();

        $auditoria_array['txr_estado'] = 1;
        $auditoria_array['txr_usu_creacion'] = $this->tank_auth->get_user_id();
        $auditoria_array['txr_usu_modificacion'] = $this->tank_auth->get_user_id();
        $auditoria_array['txr_fecha_creacion'] = date('Y-m-d H:i:s');
        $auditoria_array['txr_fecha_modificacion'] = date('Y-m-d H:i:s');

        $crud = new grocery_CRUD();
        $crud->set_table('rep_reporte_contable');
        $crud->set_subject('Reporte Contable');
        $crud->columns('rep_nombre', 'rep_estado');
        $crud->field_type('rep_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        $crud->display_as("rep_nombre", "Nombre");
        $crud->display_as("rep_estado", "Estado");
        $crud->display_as("tipo", "Tipo de Partidas");
        $crud->required_fields("rep_nombre", "rep_estado");
        $crud->set_relation_n_n('tipo', 'txr_tipo_partidaxreporte', 'tpd_tipo_partida', 'txr_id_rep', 'txr_id_tpd', 'tpd_nombre', null, array('tpd_estado' => 1), $auditoria_array);        
        $crud->fields("rep_nombre", "rep_estado", "rep_usu_creacion","rep_fecha_creacion", "rep_usu_modificacion", "rep_fecha_modificacion", "tipo");

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('rep_usu_creacion', 'hidden', $id_usuario);
            $crud->field_type('rep_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('rep_usu_modificacion', 'hidden', $id_usuario);
            $crud->field_type('rep_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('rep_usu_creacion', 'hidden');
            $crud->field_type('rep_fecha_creacion', 'hidden');
            $crud->field_type('rep_usu_modificacion', 'hidden', $id_usuario);
            $crud->field_type('rep_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        }
        $crud->add_action('Cuentas', 'icomoon-icon-stack', 'modulo_contabilidad/catalogos/cuenta_configuracion');
        $crud->set_rules('rep_nombre', 'Nombre', 'trim|required|campo_unico[rep_reporte_contable.rep_nombre]');
        $data['titulo_personal'] = "Reportes contables";
        $this->_cargarvista($data, $crud->render());
    }

    function tipo_cuenta() {
        satelite_validar();

        $campos = array(
            'tcn_nombre' => 'Nombre',
            'tcn_abreviacion' => 'Abreviación',
            'tcn_descripcion' => 'Descripción',
            'tcn_estado' => 'Estado'
        );

        $add_fields = array(
            'tcn_nombre',
            'tcn_abreviacion',
            'tcn_descripcion',
            'tcn_estado',
            'tcn_fecha_crea',
            'tcn_fecha_mod',
            'tcn_usu_crea',
            'tcn_usu_mod'
        );

        $edit_fields = array(
            'tcn_nombre',
            'tcn_abreviacion',
            'tcn_descripcion',
            'tcn_estado',
            'tcn_fecha_mod',
            'tcn_usu_mod'
        );

        $required_fields = array(
            'tcn_nombre',
            'tcn_abreviacion',
            'tcn_estado',
        );


        $crud = new grocery_CRUD();
        $crud->set_table('tcn_tipo_cuenta')
                ->set_subject('Tipo de cuenta')
                ->columns('tcn_nombre', 'tcn_abreviacion', 'tcn_estado')
                ->display_as($campos)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required_fields)
                ->set_rules('tcn_nombre', 'Nombre', 'trim|required|campo_unico[tcn_tipo_cuenta.tcn_nombre]')
                ->field_type('tcn_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tcn_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tcn_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tcn_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tcn_estado', 'hidden', 1);
        } else {
            $crud->field_type('tcn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Tipos de cuentas";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function nivel_cuenta() {
        satelite_validar();

        $campos = array(
            'nic_nombre' => 'Nombre',
            'nic_numero' => 'Nivel',
            'nic_descripcion' => 'Descripción',
            'nic_estado' => 'Estado'
        );

        $add_fields = array(
            'nic_nombre',
            'nic_numero',
            'nic_descripcion',
            'nic_estado',
            'nic_fecha_crea',
            'nic_fecha_mod',
            'nic_usu_crea',
            'nic_usu_mod'
        );
        $edit_fields = array(
            'nic_nombre',
            'nic_numero',
            'nic_descripcion',
            'nic_estado',
            'nic_fecha_mod',
            'nic_usu_mod'
        );

        $required_fields = array(
            'nic_nombre',
            'nic_numero',
            'nic_estado',
        );


        $crud = new grocery_CRUD();
        $crud->set_table('nic_nivel_cuenta')
                ->set_subject('Nivel de cuenta')
                ->columns('nic_nombre', 'nic_numero', 'nic_estado')
                ->display_as($campos)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required_fields)
                ->set_rules('nic_nombre', 'Nombre', 'trim|required|campo_unico[nic_nivel_cuenta.nic_nombre]')
                ->field_type('nic_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('nic_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('nic_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('nic_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('nic_estado', 'hidden', 1);
        } else {
            $crud->field_type('nic_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Niveles de cuentas";
        $this->_cargarvista($data, $crud->render());
    }

    /**
     * @return Mantenimiento cnt_cuenta_contable (proceso de compartir funcionalidad 21-03-2018)
     * Descripcion: Funcion padre, comparitda con el modulo Inventario/Mantenimiento ( funcion: cuenta_contable)
     */
    function cuenta_contable($ruta = null, $modulo = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $ruta1     = (trim($ruta) != '')? $ruta : 'modulo_contabilidad/catalogos/cuenta_contable';
        if($ruta){
            if($modulo){//Si modulo es de activo
                $ruta2 = 'activo/catalogo_activo/agregar_cuenta';
            }else{
                $ruta2 = 'inventario/mantenimiento/agregar_cuenta';
            }                    
        }else{
            $ruta2     = 'modulo_contabilidad/catalogos/agregar_cuenta'; 
        }

        if(trim($ruta) != ''){            
            if($modulo){//Si modulo es de activo
                $ruta3 = 'activo/catalogo_activo';
            }else{
                $ruta3 = 'inventario/mantenimiento';    
            }
        }else{
            $ruta3     = 'modulo_contabilidad/catalogos';            
        }
        //print_r($ruta2); die();
        //print_r()
        //print_r($ruta);
        //print_r('</br>');
        //print_r($ruta2); //die();

        
        $data['ruta'] = $ruta;
        $data['ruta1'] = $ruta1;
        $data['ruta2'] = $ruta2;
        
        $campos = array(
            'cnt_cuenta' => 'Cuenta',
            'cnt_nombre' => 'Nombre',
            'cnt_id_cnt_padre' => 'Dependencia',
            'cnt_id_nic' => 'Nivel',
            'cnt_estado' => 'Estado',
            'cnt_aumenta' => 'D/H'
        );
        $url_actual = uri_string();
        $crud = new grocery_CRUD();
        $dep = 0;
        if ($_POST){

            //Obtener valores del filtro
            $nombre = $this->input->post('nombre');
            $nivel = $this->input->post('nivel');
            $dep = $this->input->post('dependencia');

            //Crear el where para la consulta
            if ($nombre != '') {
                $crud->where("cnt_nombre like '" . $nombre . "%'");
            }
            if ($nivel != '') {
                $crud->where("cnt_id_nic", $nivel);
            }
            if ($dep > 0) {
                $crud->where("cnt_id_cnt_padre", $dep);
            }
            $data['nivel'] = $nivel;
            $data['nombre'] = $nombre;
        }        
        
        $crud->set_table('cnt_cuenta_contable')
                ->set_subject('Cuenta contable')
                ->display_as($campos)
                ->set_relation('cnt_id_nic', 'nic_nivel_cuenta', '{nic_numero}')
                ->unset_edit()
                ->add_action('Editar', '', "$ruta3/editar_cuenta", 'icomoon-icon-pencil-5')
                ->callback_column('cnt_id_cnt_padre', array($this, '_callback_dependencia'))
                ->order_by('cnt_cuenta, cnt_id_cnt_padre, cnt_id_nic','ASC')
        ;
        if (substr_count($url_actual, 'print') > 0 || substr_count($url_actual, 'export') > 0) {
            $crud->columns('cnt_cuenta', 'cnt_nombre', 'cnt_id_cnt_padre', 'cnt_id_nic', 'cnt_estado', 'cnt_aumenta');
        } else {
            $crud->columns('cnt_num','cnt_cuenta', 'cnt_nombre', 'cnt_id_cnt_padre', 'cnt_id_nic', 'cnt_estado', 'cnt_aumenta');
        }
        
        $uri_segments = explode('/', uri_string());
        if (end($uri_segments) == 'add') {
            $crud->field_type('cnt_estado', 'hidden', 1);
        } else {
            $crud->field_type('cnt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
          $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        //Llenar select dependencia
        if ($dep > 0) {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), $dep, null, null, true);
        } else {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
        }
        $data['titulo_personal'] = "Cuentas contables";
        //print_r($ruta2); die();
        if($ruta){
            if($modulo){//Si modulo es de activo
                cargarvista($data, $crud->render(), 'inventario/mantenimiento/cuenta_contable');
            }else{
                cargarvista($data, $crud->render(), 'inventario/mantenimiento/cuenta_contable');
            }                      
        }else{
            //print_r($ruta2); die();
            cargarvista($data, $crud->render(), 'modulo_contabilidad/catalogos/cuenta_contable');    
        }        
        // $this->_cargarvista($data, $crud->render());
    }

    /**
     * @return Mantenimiento cnt_cuenta_contable (proceso de compartir funcionalidad 21-03-2018)
     * Descripcion: Funcion padre, compartida con el modulo Inventario/Mantenimiento ( funcion: agregar_cuenta)
     */
    function agregar_cuenta($ruta = null) {
        satelite_validar();
        $ruta         = (trim($ruta) != '')? $ruta : 'modulo_contabilidad/catalogos';
        //print_r($_POST); die();
        switch ($ruta) {
            case 'inventario/mantenimiento':
                $defecto_ruta = 'gestion_cuentas';
                break;
            case 'activo/catalogo_activo':
                $defecto_ruta = 'gestion_cuenta_contable';
                break;
            default:
                $defecto_ruta = 'cuenta_contable';
                break;
        }
        //$defecto_ruta = ($ruta == 'inventario/mantenimiento')?'gestion_cuentas':'cuenta_contable';
        $data['ruta'] = $ruta;
        $data['defecto_ruta'] = $defecto_ruta;

        if ($_POST) {
            //print_r($_POST); die();
            $array_cuenta = array(
                'cnt_id_cft' => ($this->input->post('tipo_cuenta')) ? $this->input->post('tipo_cuenta') : null,
                'cnt_id_cnt_padre' => ($this->input->post('dependencia')) ? $this->input->post('dependencia') : null,
                'cnt_id_nic' => ($this->input->post('nivel')) ? $this->input->post('nivel') : null,
                'cnt_cuenta' => $this->input->post('cuenta'),
                'cnt_nombre' => $this->input->post('nombre'),
                'cnt_descripcion' => ($this->input->post('descripcion')) ? trim($this->input->post('descripcion')) : null,
                'cnt_estado' => 1,
                'cnt_aumenta' => $this->input->post('d_h'),
                'cnt_fecha_crea' => date('Y-m-d H:i:s'),
                'cnt_fecha_mod' => date('Y-m-d H:i:s'),
                'cnt_usu_crea' => $this->tank_auth->get_user_id(),
                'cnt_usu_mod' => $this->tank_auth->get_user_id()
            );
            //print_r($array_cuenta); die();
            $agregar = $this->gsatelite->ingresar('cnt_cuenta_contable', $array_cuenta);

            if ($agregar > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
            }

            $this->session->set_flashdata($alerta);
            
            $volver = $this->input->post('volver');
            if ($volver == 1) {
                redirect("$ruta/$defecto_ruta");
            } else {
                redirect("$ruta/agregar_cuenta");
            }
        } else {            
            $variable_tipo_cuenta = $this->gsatelite->get_dropdown('cft_clasificacion_cuenta_contable', '{cft_nombre}', '', array('cft_estado' => 1), null, null, null, true);            
            $variable_tipo_cuenta = str_replace('<option value="0">Seleccione</option>', '', $variable_tipo_cuenta);            
            $variable_tipo_cuenta = str_replace('<option value="0">Sin Registros</option>', '', $variable_tipo_cuenta);
            $data['tipo_cuenta'] = $variable_tipo_cuenta;

            //$data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{trim(cnt_cuenta)} - {trim(cnt_nombre)}', '', array('cnt_estado' => 1), null, null, null, true);
            $this->db->join('nic_nivel_cuenta','nic_id = cnt_id_nic');
            $data['dependencia'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
            $variable = $this->gsatelite->get_dropdown('nic_nivel_cuenta', '{nic_numero}', '', array('nic_estado' => 1), null, null, null, true);            
            $variable = str_replace('<option value="0">Seleccione</option>', '', $variable);            
            $variable = str_replace('<option value="0">Sin Registros</option>', '', $variable);
            
            $data['nivel'] = $variable;
        }

        $data['titulo_personal'] = "Agregar cuenta contable ";
        cargarvista($data, null, 'modulo_contabilidad/catalogos/agregar_cuenta');
        // $this->_cargarvista($data);
    }

    /**
     * @return Mantenimiento cnt_cuenta_contable (proceso de compartir funcionalidad 21-03-2018)
     * Descripcion: Funcion padre, compartida con el modulo Inventario/Mantenimiento ( funcion: editar_cuenta)
     */
    function editar_cuenta($cuenta = null, $ruta = null) {
        satelite_validar();
        $ruta         = (trim($ruta) != '')? $ruta : 'modulo_contabilidad/catalogos';
        switch ($ruta) {
            case 'inventario/mantenimiento':
                $defecto_ruta = 'gestion_cuentas';
                break;
            case 'activo/catalogo_activo':
                $defecto_ruta = 'gestion_cuenta_contable';
                break;
            default:
                $defecto_ruta = 'cuenta_contable';
                break;
        }
        //$defecto_ruta = ($ruta == 'inventario/mantenimiento')?'gestion_cuentas':'cuenta_contable';
        $data['ruta'] = $ruta;
        $data['defecto_ruta'] = $defecto_ruta;
        //print_r($data['ruta']);
        //print_r($data['defecto_ruta']);
        //die();

        if ($_POST) {
            
            $id_cuenta = $this->input->post('id_cuenta');
            $array_cuenta = array(
                'cnt_id_cft'    => ($this->input->post('tipo_cuenta')) ? $this->input->post('tipo_cuenta') : null,
                'cnt_id_cnt_padre' => ($this->input->post('dependencia')) ? $this->input->post('dependencia') : null,
                'cnt_id_nic'    => ($this->input->post('nivel')) ? $this->input->post('nivel') : null,
                'cnt_cuenta'    => $this->input->post('cuenta'),
                'cnt_nombre'    => $this->input->post('nombre'),
                'cnt_descripcion' => ($this->input->post('descripcion')) ? trim($this->input->post('descripcion')) : null,
                'cnt_estado'    => $this->input->post('estado'),
                'cnt_aumenta'   => $this->input->post('d_h'),
                'cnt_fecha_mod' => date('Y-m-d H:i:s'),
                'cnt_usu_mod'   => $this->tank_auth->get_user_id()
            );

            $editar = $this->gsatelite->actualizar_array('cnt_cuenta_contable', $array_cuenta, array('cnt_id' => $id_cuenta));

            if ($editar > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la información a actualizar.");
            }
            $this->session->set_flashdata($alerta);
            
            $volver = $this->input->post('volver');
            if ($volver == 1) {
                redirect("$ruta/$defecto_ruta");
            } else {
                redirect("$ruta/editar_cuenta/" . $id_cuenta);
            }
        } else {

            $data['id_cuenta'] = $cuenta;
            $info = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta));
            $data['info'] = $info[0];
            
            $variable_tipo_cuenta = $this->gsatelite->get_dropdown('cft_clasificacion_cuenta_contable', '{cft_nombre}', '', array('cft_estado' => 1), $info[0]['cnt_id_cft'], null, null, true);
            $variable_tipo_cuenta = str_replace('<option value="0">Seleccione</option>', '', $variable_tipo_cuenta);            
            $variable_tipo_cuenta = str_replace('<option value="0">Sin Registros</option>', '', $variable_tipo_cuenta);
            $data['tipo_cuenta'] = $variable_tipo_cuenta;

            $variable_dependencia = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), $info[0]['cnt_id_cnt_padre'], null, null, true);
            $variable_dependencia = str_replace('<option value="0">Seleccione</option>', '', $variable_dependencia);            
            $variable_dependencia = str_replace('<option value="0">Sin Registros</option>', '', $variable_dependencia);
            $data['dependencia'] = $variable_dependencia;

            $variable_nivel = $this->gsatelite->get_dropdown('nic_nivel_cuenta', ' {nic_numero}', '', array('nic_estado' => 1), $info[0]['cnt_id_nic'], null, null, true);
            $variable_nivel = str_replace('<option value="0">Seleccione</option>', '', $variable_nivel);            
            $variable_nivel = str_replace('<option value="0">Sin Registros</option>', '', $variable_nivel);
            $data['nivel'] = $variable_nivel;
        }

        $data['titulo_personal'] = "Editar cuenta contable ";
        cargarvista($data, null, 'modulo_contabilidad/catalogos/editar_cuenta');
        // $this->_cargarvista($data);
    }

    function _callback_dependencia($value, $row) {

        $cuenta = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_cuenta', array('cnt_id' => $value));

        return $cuenta;
    }

    function validar_numero_cuenta($cuenta = null, $id_cuenta = null) {
        satelite_validar(true);
        if ($_POST['num_cuenta'] != '') {
            $cuenta = $this->input->post('num_cuenta');
            $id_cuenta = ($this->input->post('cuenta') != '') ? $this->input->post('cuenta') : null;
        }

        if ($id_cuenta != null) {
            $where = 'cnt_cuenta = ' . $cuenta . ' AND cnt_id <> ' . $id_cuenta;
        } else {
            $where = array('cnt_cuenta' => $cuenta);
        }

        $count = $this->gsatelite->count('cnt_cuenta_contable', $where);

        if ($count > 0) {
            $existe = 1;
        } else {
            $existe = 0;
        }

        echo json_encode(array('existe' => $existe));
    }

    function tipo_partida() {
        //satelite_validar();

        $campos = array(
            'tpd_nombre' => 'Nombre',
            'tpd_prefijo' => 'Prefijo',
            'tpd_descripcion' => 'Descripción',
            'tpd_estado' => 'Estado'
        );

        $add_fields = array(
            'tpd_nombre',
            'tpd_descripcion',
            'tpd_estado',
            'tpd_fecha_crea',
            'tpd_fecha_mod',
            'tpd_usu_crea',
            'tpd_usu_mod',
            'tpd_prefijo'
        );

        $edit_fields = array(
            'tpd_nombre',
            'tpd_descripcion',
            'tpd_prefijo',
            'tpd_estado',
            'tpd_fecha_mod',
            'tpd_usu_mod'
        );

        $required_fields = array(
            'tpd_nombre',
            'tpd_prefijo',
            'tpd_estado'
        );


        $crud = new grocery_CRUD();
        $crud->set_table('tpd_tipo_partida')
                ->set_subject('Tipo de partida')
                ->columns('tpd_nombre', 'tpd_prefijo', 'tpd_descripcion', 'tpd_estado')
                ->display_as($campos)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->required_fields($required_fields)
                ->set_rules('tpd_nombre', 'Nombre', 'trim|campo_unico[tpd_tipo_partida.tpd_nombre]|required')
                ->set_rules('tpd_prefijo', 'Prefijo', 'trim|campo_unico[tpd_tipo_partida.tpd_prefijo]|required')
                ->field_type('tpd_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpd_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('tpd_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpd_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tpd_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Tipos de partidas";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    /**
     * @author René Castaneda
     * @since 27/09/2017
     * @return Obtener el siguiente numero de cuenta
     */
    public function obtener_numero_cuenta(){
        $padreCnt = $this->input->post('padreCnt');
        $registro = $this->gsatelite->get_registro('cnt_cuenta_contable','cnt_id',$padreCnt);

                 $this->db->order_by('cnt_cuenta','DESC');
                 $this->db->limit('1');
        $query = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id_cnt_padre' => $padreCnt));
        $numero_sugerido = ($query) ? (floatval($query[0]['cnt_cuenta']) + 1) : ($registro->cnt_cuenta . '01');
        $padre_aumenta = $registro->cnt_aumenta;
        die(json_encode(array('numero_cuenta' => $numero_sugerido, 'aumenta' => $padre_aumenta)));      
    }

    function clasificacion_cuenta(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();

            $columns = array(
                'cft_nombre',
                'cft_descripcion',
                'cft_abreviacion',                
                'cft_estado'                
            );

            $display_as = array(
                'cft_nombre'    => 'Nombre',
                'cft_descripcion'  => 'Descripción',
                'cft_abreviacion'  => 'Abreviación',
                'cft_estado'    => 'Estado'
            );

            $add = array(
                'cft_nombre',
                'cft_descripcion',
                'cft_abreviacion',
                'cft_estado',
                'cft_fecha_creacion',
                'cft_usu_creacion',
                'cft_fecha_modificacion',
                'cft_usu_modificacion'               
            );

            $edit = array(
                'cft_nombre',
                'cft_descripcion',
                'cft_abreviacion',
                'cft_estado',
                'cft_fecha_modificacion',
                'cft_usu_modificacion'
            );

            $required = array(
                'cft_nombre',
                'cft_abreviacion',
                'cft_estado',
                'cft_fecha_modificacion',
                'cft_usu_modificacion'
            );
            
            $crud->set_table('cft_clasificacion_cuenta_contable')
                ->set_subject('Clasificación cuenta contable')
                ->columns($columns)
                ->display_as($display_as)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($required)
                ->field_type('cft_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('cft_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())                
            ;
            $crud->set_rules('cft_nombre', 'Nombre', 'trim|required|campo_unico[cft_clasificacion_cuenta_contable.cft_nombre]');            

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cft_estado', 'hidden', 1)
                    ->field_type('cft_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cft_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('cft_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
              $crud->unset_add();
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_add();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if ($permisos['permite_ver']) {
               $crud->add_action('Ver', 'icomoon-icon-search-3', 'modulo_contabilidad/catalogos/clasificacion_cuenta/read');
            }


            $output = $crud->render();
            $data['titulo_personal'] = "Clasificación cuentas";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }
    /**
    * @author Elman Ortiz   
    * @since 18/05/2018
    * @return Mantenimiento para los conceptos de las partidas contables
    */
    function concepto_partida(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_contabilidad/catalogos/concepto_partida');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();

            $columns = array(
                'ccp_codigo',
                'ccp_referencia_proceso',                
                'ccp_descripcion_concepto',
                'ccp_estado'
            );

            $alias = array(
                'ccp_codigo'    => 'Código',
                'ccp_referencia_proceso'    => 'Referencia proceso',                                
                'ccp_descripcion_concepto' => 'Descripción concepto',
                'ccp_estado'    => 'Estado'
            );

            $add = array(
                'ccp_codigo',
                'ccp_referencia_proceso',                
                'ccp_descripcion_concepto',
                'ccp_estado',
                'ccp_fecha_creacion',
                'ccp_fecha_modificacion',
                'ccp_usu_creacion',
                'ccp_usu_modificacion'
            );

            $edit = array(
                'ccp_codigo',
                'ccp_referencia_proceso',                
                'ccp_descripcion_concepto',
                'ccp_estado',
                'ccp_fecha_modificacion',
                'ccp_usu_modificacion'
            );
            
            $crud->set_table('ccp_concepto_partida')
                ->set_subject('Conceptos de partida')
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($edit)
                ->field_type('ccp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('ccp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ;
            $crud->set_rules('ccp_nombre', 'Nombre', 'trim|required|campo_unico[ccp_concepto_partida.ccp_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ccp_estado', 'hidden', 1)
                    ->field_type('ccp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ccp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('ccp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
              $crud->unset_add();
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_add();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if ($permisos['permite_ver']) {
               $crud->add_action('Ver', 'icomoon-icon-search-3', 'modulo_contabilidad/catalogos/concepto_partida/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Concepto de partida";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function centro_costo(){
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/mantenimientos');
        $ruta = 'modulo_contabilidad/catalogos';
        $url = 'centro_costo';
        $this->mantenimientos->centro_costos($ruta, $url);
    }
    

}
