<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->model('compras_model');
        $this->load->model('inventario_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Compras';
            $this->_cargarvista(null, $data);
        }
    }

    function ordenes_compra() {
        satelite_validar();

        $data['departamentos'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', '', array('are_estado' => 1), null, null, null, true);

        $proveedores= $this->compras_model->get_proveedor_pers();
            $options='<option value="0">Todos</option>';
            foreach ($proveedores as $key) {
                if($key['pro']!=''){
                    $options.='<option value="'.$key['prv_id'].'">'.$key['pro'].'</option>';
                }
            }

            $data['proveedores'] = $options;

        $data['titulo_personal'] = "Reporte de Órdenes de Compra";
        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    function reporte_orden_compra($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $estado = ($post_array['estado'] != '') ? $post_array['estado'] : null;
                $departamento = ($post_array['departamento'] != '') ? $post_array['departamento'] : null;
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
            } else {

                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $estado_split = ($post_array['filtro_estado'] != '') ? explode("#", $post_array['filtro_estado']) : null;
                $departamento_split = ($post_array['filtro_departamento'] != '') ? explode("#", $post_array['filtro_departamento']) : null;
                $proveedor_split = ($post_array['filtro_proveedor'] != '') ? explode("#", $post_array['filtro_proveedor']) : null;
                //Se asignan los valores de filtro
                $estado = $estado_split[0];
                $data['nombreEstado'] = $estado_split[1];

                $departamento = $departamento_split[0];
                $data['nombreDepartamento'] = $departamento_split[1];

                $proveedor = $proveedor_split[0];
                $data['nombreProveedor'] = $proveedor_split[1];

                //Las fechas son las unicas que no se concatenan
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            //Se crean las condicionales del reporte
            if ($estado) {
                $where['orc_estado'] = $estado;
            }
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['orc_fecha_orden >='] = $fecha_ini;
                $where['orc_fecha_orden <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }
            if ($departamento) {
                $where['orc_id_are'] = $departamento;
            }
            if ($proveedor) {
                $where['orc_id_prv'] = $proveedor;
            }

            $data['reporte'] = $this->compras_model->get_ordenes_compra($where);

            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_ordenes_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('modulo_compras/reportes/reporte_ordenes_compra', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Órdenes de Compras';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Ordenes_Compra_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Ordenes_Compra', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_ordenes_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Órdenes de Compra';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function compras_proveedor() {
        satelite_validar();

        $proveedores= $this->compras_model->get_proveedor_pers();
        $options='<option value="0">Todos</option>';
        foreach ($proveedores as $key) {
            if($key['pro']!=''){
                $options.='<option value="'.$key['prv_id'].'">'.$key['pro'].'</option>';
            }
        }

        $data['proveedores'] = $options;

        $data['titulo_personal'] = "Reporte de compras por proveedor";
        $this->_cargarvista($data);
    }

    // $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
    function reporte_compras_proveedor($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
            } else {
                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $proveedor_split = ($post_array['filtro_proveedor'] != '') ? explode("#", $post_array['filtro_proveedor']) : null;
                //Se asignan los valores de filtro
                $proveedor = $proveedor_split[0];
                $data['nombreProveedor'] = $proveedor_split[1];
                //Las fechas son las unicas que no se concatenan
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            $where1 = "";
            $where2 = "";
            //Se crean las condicionales del reporte
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['orc_fecha_orden >='] = $fecha_ini;
                $where['orc_fecha_orden <='] = $fecha_fin;

                $where1 = "orc_fecha_orden >= '".$fecha_ini."'";
                $where1 .= " AND orc_fecha_orden <= '".$fecha_fin."'";

                $where2 = "dpv_fecha_documento >= '".$fecha_ini."'";
                $where2 .= " AND dpv_fecha_documento <= '".$fecha_fin."'";

                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }

            if ($proveedor) {
                if($where1 != ""){
                    $where1 .= " AND orc_id_prv = ".$proveedor;
                    $where2 .= " AND dpv_id_prv = ".$proveedor;
                } else{
                    $where1 .= "orc_id_prv = ".$proveedor;
                    $where2 .= "dpv_id_prv = ".$proveedor;
                }
                $where['orc_id_prv'] = $proveedor;
            }

            $where_array = array($where1, $where2);
            $data['reporte'] = $this->compras_model->get_compras_proveedor($where_array);
            // print_r($this->db->last_query());
            // die();
            $data['total'] = $this->gsatelite->get_suma('orc_orden_compra', 'orc_total', $where);

            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_compras_proveedor_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;

            $html = $this->load->view('modulo_compras/reportes/reporte_compras_proveedor', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Resumen Orden de Compra proveedor';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Compras_Proveedor_' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Compras_Proveedor', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_compras_proveedor_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Compras por proveedor';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function requisiciones() {
        satelite_validar();
        $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
        $flujos_array = json_decode($flujos, true);
        $data['flu'] = $flujos_array['REQ_COMP'];
        if(!(trim($flujos) != '' && trim($flujos_array['REQ_COMP']) != '')){
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Parametro requerido.");
                    $this->session->set_flashdata($alerta);
            redirect('/modulo_compras/index');
        }
        //$data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', 'suc_nombre', '', null, null, null, null, true);
        //$data['departamentos'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', '', array('are_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Reporte de requisiciones";
        $this->_cargarvista($data);
    }

    // $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
    public function reporte_requisiciones($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $estado = ($post_array['estado'] != '') ? $post_array['estado'] : null;
                $departamento = ($post_array['departamento'] != '') ? $post_array['departamento'] : null;
                $sucursal = ($post_array['sucursal'] != '') ? $post_array['sucursal'] : null;
            } else {
                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $estado_split = ($post_array['filtro_estado'] != '') ? explode("#", $post_array['filtro_estado']) : null;
                $departamento_split = ($post_array['filtro_departamento'] != '') ? explode("#", $post_array['filtro_departamento']) : null;
                $sucursal_split = ($post_array['filtro_sucursal'] != '') ? explode("#", $post_array['filtro_sucursal']) : null;
                //Se asignan los valores de filtro
                $estado = $estado_split[0];
                $data['nombreEstado'] = $estado_split[1];

                $departamento = $departamento_split[0];
                $data['nombreDepartamento'] = $departamento_split[1];

                $sucursal = $sucursal_split[0];
                $data['nombreSucursal'] = $sucursal_split[1];
                //Las fechas son las unicas que no se concatenan
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            //Se crean las condicionales del reporte
            if ($estado) {
                $where['rxi_estado'] = $estado;
            }
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['rxi_fecha >='] = $fecha_ini;
                $where['rxi_fecha <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }

            $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array = json_decode($flujos, true);

            $where['rxi_id_flu'] = $flujos_array['REQ_COMP'];

            if ($departamento) {
                $where['emp_id_are'] = $departamento;
            }
            if ($sucursal) {
                $where['bod_id_suc'] = $sucursal;
            }

            $data['reporte'] = $this->compras_model->get_reporte_requisiciones($where);
           // print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_ordenes_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('modulo_compras/reportes/reporte_requisiciones', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Requisiciones';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_requisiciones_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_requisiciones', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_requisiciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Requisiciones';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function compras_producto() {
        satelite_validar();
        $data['titulo_personal'] = "Reporte de compras por producto";
        $this->_cargarvista($data);
    }

    // $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
    public function reporte_compras_producto($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery De lo contrario, se toman los filtros de impresión */
            if ($flag) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $categoria = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
                $producto  = ($post_array['producto'] != '') ? $post_array['producto'] : null;
            } else {
                /* Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado" Se separan los filtros */
                $categoria_split = ($post_array['filtro_categoria'] != '') ? explode("#", $post_array['filtro_categoria']) : null;
                $producto_split = ($post_array['filtro_producto'] != '') ? explode("#", $post_array['filtro_producto']) : null;
                //Se asignan los valores de filtro
                $categoria = $categoria_split[0];
                $data['nombreCategoria'] = $categoria_split[1];
                $producto = $producto_split[0];
                $data['nombreProducto'] = $producto_split[1];
                //Las fechas son las unicas que no se concatenan
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            //Se crean las condicionales del reporte
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['dpv_fecha_documento >='] = date('Y-m-d', strtotime($fecha_ini));
                $where['dpv_fecha_documento <='] = date('Y-m-d', strtotime($fecha_fin));
                $data['fecha_inicio'] = date('Y-m-d', strtotime($fecha_ini));
                $data['fecha_fin'] = date('Y-m-d', strtotime($fecha_fin));
            }
            if ($categoria) {
                $where['tia_id'] = $categoria;
            }
            if ($producto) {
                $where['art_id'] = $producto;
            }
            $data['reporte'] = $this->compras_model->get_reporte_compras_producto($where);
            $data['suma'] = $this->compras_model->get_total_reporte_compras_roducto($where);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_compra_producto' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_compras/reportes/reporte_compras_producto', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Compras por producto';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_compras_producto' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_compras_producto', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_compras_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Compras por producto';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function consultar_categorias() {
        $categoria = $this->input->post('categoria');
        $result = $this->compras_model->get_categoria_like($categoria);
        echo json_encode($result);
    }

    public function consultar_articulos($servicio = "") {
        $articulo = $this->input->post('articulo');
        $categoria = $this->input->post('categoria');
        if ($categoria != "") {
            $codigos = $this->inventario_model->crear_arbol($categoria);
            $codigos = $codigos . $categoria;
            $codigos = split('[,]', $codigos);
            $result = $this->compras_model->get_articulo_like($articulo, $servicio, null, $codigos);
        } else {
            $result = $this->compras_model->get_articulo_like($articulo, $servicio, null, null);
        }
        echo json_encode($result);
    }

    public function retaceo() {
        satelite_validar();
        $proveedores= $this->compras_model->get_proveedor_pers();
        $options='<option value=""></option>';
        foreach ($proveedores as $key) {
            if($key['pro']!=''){
                $options.='<option value="'.$key['prv_id'].'">'.$key['pro'].'</option>';
            }
        }
        $data['proveedores'] = $options;
        $data['titulo_personal'] = "Reporte de retaceo";
        $this->_cargarvista($data);
    }

    public function reporte_retaceo($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag) {
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $retaceo = ($post_array['retaceo'] != '') ? $post_array['retaceo'] : null;
            } else {
                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $proveedor_split = ($post_array['filtro_proveedor'] != '') ? explode("#", $post_array['filtro_proveedor']) : null;
                $retaceo_split = ($post_array['filtro_retaceo'] != '') ? explode("#", $post_array['filtro_retaceo']) : null;
                //Se asignan los valores de filtro
                $proveedor = $proveedor_split[0];
                $retaceo = $retaceo_split[0];
                $data['nombreProveedor'] = $proveedor_split[1];
                $data['numeroRetaceo'] = $retaceo_split[1];
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            //Se crean las condicionales del reporte
            $where['drc_estado'] = 1;
            if ($proveedor) {
                $where['dpv_id_prv'] = $proveedor;
            }
            if ($retaceo) {
                $where['rtd_id'] = $retaceo;
            }
            $data['reporte'] = $this->compras_model->get_detalle_retaceo($where);
            // Obtener el usuario que creo el retaceo
            $crea_usuario_retaceo = $this->gsatelite->get_tabla('rtd_retaceo_documento_proveedor', array('rtd_id' => $retaceo, 'rtd_estado' => 1));
            $crea_usuario_retaceo = $this->gsatelite->get_tabla('users', array('id' => $crea_usuario_retaceo[0]['rtd_usu_creacion']));
            $data['crea_usuario_retaceo'] = $crea_usuario_retaceo[0]['username'];
            // Parametro para determinar si mostrar el usuario que autorizo la orden de compra
            $mostrar_usuario = $this->gsatelite->get_parametro('SYS_MOSTRAR_USUARIO_IMPRESION', null, null, array('reporte_retaceo'));
            $data['mostrar_usuario'] = ($mostrar_usuario > 0) ? $mostrar_usuario : 0;
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_retaceo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_compras/reportes/reporte_retaceo', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Retaceo';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Retaceo_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Retaceo', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_retaceo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Retaceo';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        }
    }

    public function documentos_proveedor() {
        satelite_validar();

        $proveedores= $this->compras_model->get_proveedor_pers();
        $options='<option value="0">Todos</option>';
        foreach ($proveedores as $key) {
            if($key['pro']!=''){
                $options.='<option value="'.$key['prv_id'].'">'.$key['pro'].'</option>';
            }
        }

        $data['proveedores'] = $options;

        //Datos select tipo de pago
        $tipopago = $this->compras_model->get_tipos_pagoxdoc();
        $options='<option value="0">Todos</option>';
        foreach ($tipopago as $key) {
            $options.='<option value="'.$key['tpg_id'].'">'.$key['tpg_nombre'].'</option>';
        }

        $data['tiposdepago'] = $options;

        $data['titulo_personal'] = "Reporte de documentos por proveedor";
        $this->_cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    function reporte_docs_proveedor($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            //print_r($post_array); die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $tipopago = ($post_array['tipo_pago'] != '') ? $post_array['tipo_pago'] : null;
            } else {

                /*
                 * Los valores de filtro vienen concatenados junto a su texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $proveedor_split = ($post_array['filtro_proveedor'] != '') ? explode("#", $post_array['filtro_proveedor']) : null;
                //$proyecto = ($post_array['filtro_proyecto'] != '') ? $post_array['filtro_proyecto'] : null;
                //$sucursal = ($post_array['filtro_sucursal'] != '') ? $post_array['filtro_sucursal'] : null;
                //Se asignan los valores de filtro
                $proveedor = $proveedor_split[0];
                $data['nombreProveedor'] = $proveedor_split[1];

                //Las fechas son las unicas que no se concatenan
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;

                //Se asigna el valor del filtro de pago
                $tipopago_split = ($post_array['filtro_tipo_pago'] != '') ? explode("#", $post_array['filtro_tipo_pago']) : null;
                $tipopago = $tipopago_split[0];
                $data['nombretipopago'] = $tipopago_split[1];
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            //Se crean las condicionales del reporte
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['dpv_fecha_documento >='] = $fecha_ini;
                $where['dpv_fecha_documento <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }
            if ($proveedor) {
                $where['dpv_id_prv'] = $proveedor;
            }
            if ($tipopago) {
                $where['dpv_id_tpg'] = $tipopago;
            }

            $data['reporte'] = $this->compras_model->get_documentos_proveedor($where);

            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_doc_proveedor_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
        $html = $this->load->view('modulo_compras/reportes/reporte_docs_proveedor', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Documentos por proveedor';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Docs_Proveedor_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Docs_Proveedor', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_doc_proveedor_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Documentos por proveedor';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function get_documentos_proveedor() {
        $this->db->join('dpv_documento_proveedor', 'dpv_id = rtd_id_dpv');
        $result = $this->gsatelite->get_dropdown('rtd_retaceo_documento_proveedor', '{prv_apellido}', '', array('prv_estado' => 1), null, null, null, true);
        return json_encode($result);
    }

    public function producto_mas_comprado() {
        satelite_validar();
        $data['titulo_personal'] = "Reporte de productos más comprados";
        $data['categoria'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, null, null, true);
        $this->_cargarvista($data);
    }

    public function reporte_producto_mas_comprado($flag = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag) {
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $categoria = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
                $numero_producto = ($post_array['numeroProducto'] != '') ? $post_array['numeroProducto'] : 0;
            } else {
                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $categoria_split = ($post_array['filtro_categoria'] != '') ? explode("#", $post_array['filtro_categoria']) : null;
                //Se asignan los valores de filtro

                $categoria = $categoria_split[0];
                $data['nombreCategoria'] = $categoria_split[1];

                //Las fechas son las unicas que no se concatenan

                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;

                $numero_producto = ($post_array['filtro_NumeroProducto'] != '') ? $post_array['filtro_NumeroProducto'] : null;
            }

            $data['cantidad'] = $numero_producto;
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;
            $limit = $numero_producto;
            //Se crean las condicionales del reporte
            $where3 = "";
            $where4 = "";
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where3 = 'date(orc_fecha_orden) >= "'.formatear_fecha("Y-m-d", $fecha_ini).'"';
                $where3 .= ' AND date(orc_fecha_orden) <= "'.formatear_fecha("Y-m-d", $fecha_fin).'"';
                $where4 = 'date(dpv_fecha_documento) >= "'.formatear_fecha("Y-m-d", $fecha_ini).'"';
                $where4 .= ' AND date(dpv_fecha_documento) <= "'.formatear_fecha("Y-m-d", $fecha_fin).'"';
                // $where['orc_fecha_orden >='] = date('Y-m-d', strtotime($fecha_ini));
                // $where['orc_fecha_orden <='] = date('Y-m-d', strtotime($fecha_fin));
                $data['fecha_inicio'] = date('Y-m-d', strtotime($fecha_ini));
                $data['fecha_fin'] = date('Y-m-d', strtotime($fecha_fin));
            }
            if ($categoria) {
                if($where3 != ""){
                    $where3 .= "AND tia_id = ".$categoria;
                    $where4 .= "AND tia_id = ".$categoria;
                } else{
                    $where3 .= "tia_id = ".$categoria;
                    $where4 .= "tia_id = ".$categoria;
                }
                // $where['tia_id'] = $categoria;
            }

            $array_where = array($where3, $where4);

            $data['reporte'] = $this->compras_model->get_producto_mas_comprado($array_where, $limit, 1);
            // die(print_r($this->db->last_query()));
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_producto_mas_comprado' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('modulo_compras/reportes/reporte_producto_mas_comprado', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Productos más comprados';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_producto_mas_comprado' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_producto_mas_comprado', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_producto_mas_comprado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Producto más comprado';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function get_retaceo_docucumento($consolidado = null) {
        if ($_POST) {
            if ($consolidado) {
                $select = '<option value=""></option>';
                $where['dpv_id_prv'] = $this->input->post("proveedor");
                $proveedores = $this->compras_model->get_retaceos_cons($where);                
                foreach ($proveedores as $key => $value) {
                    $select .= '<option value="' . $value['rtd_id'] . '">' . $value['rtd_numero'] . '</option>';
                }
                echo json_encode($select);
            } else {            
                $dpv_id_prv = $this->input->post("proveedor");
                $this->db->join('dpv_documento_proveedor', 'dpv_id = rtd_id_dpv');
                $result = $this->gsatelite->get_dropdown('rtd_retaceo_documento_proveedor', '{rtd_numero}', '', array('rtd_estado' => 1, 'dpv_id_prv' => $dpv_id_prv), null, null, null, true);
                echo json_encode($result);
            }
        }
    }

    /**
    * @author Habby Lovo
    * @since 2018-02-05
    * @return reporte consolidado de compras por proyecto
    */
    public function consolidado_compras_proyecto($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;

                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $cliente = $post_array['cliente'];
                $proyecto = $post_array['proyecto'];
                $estado = $post_array['estado'];

                //$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
                $data['fecha_ini']  = $fecha_ini;
                $data['fecha_fin']  = $fecha_fin;
                $data['cliente_id']  = $cliente;
                $data['proyecto']  = $proyecto;
                $data['estado']   = $estado;


                $where = null;

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['orc_fecha_orden >='] = date('Y-m-d', strtotime($fecha_ini));
                    $where['orc_fecha_orden <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                }

                if(trim($cliente) != ""){
                    $where['cli_id'] = $cliente;
                }
                if(trim($proyecto) != ""){
                    $where['pcl_id'] = $proyecto;
                }
                if(trim($estado) != ""){
                    $where['pcl_id_epr'] = $estado;
                }

                $proyectos = $this->compras_model->get_orden_compra_proyecto($where);

                $data['proyectos'] = $proyectos;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('modulo_compras/reportes/grid_reporte_compras_proyectos', $data, true);
                echo $html;
                die();
            }
        } else {
            $cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
            $est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
            $data['clientes'] = $cli;
            $data['estados'] = $est;
            $data['titulo_personal'] = "Consolidado de compras por proyecto";
            cargarvista($data);
        }
    }

    public function imprimir_consolidado_compras_proyecto(){
        $post_array = $_POST;

        $fecha_ini = $post_array['rpt_txtFechaIni'];
        $fecha_fin = $post_array['rpt_txtFechaFin'];
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini']  = $fecha_ini;
        $data['fecha_fin']  = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['estado']   = $estado;

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where['orc_fecha_orden >='] = date('Y-m-d', strtotime($fecha_ini));
            $where['orc_fecha_orden <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }

        if(trim($cliente) != ""){
            $where['cli_id'] = $cliente;
        }
        if(trim($proyecto) != ""){
            $where['pcl_id'] = $proyecto;
        }
        if(trim($estado) != ""){
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->compras_model->get_orden_compra_proyecto($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('modulo_compras/reportes/grid_reporte_compras_proyectos.php', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
        } else{
            $this->load->library('pdf');
            $data['titulo'] = 'Listado de compras por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('modulo_compras/reportes/grid_reporte_compras_proyectos.php', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

            $this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
        }
    }

    /**
    * @author Habby Lovo
    * @since 2018-02-05
    * @return reporte consolidado de compras por proyecto
    */
    public function consolidado_compras_proyecto_detallado($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;

                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $cliente = $post_array['cliente'];
                $proyecto = $post_array['proyecto'];
                $orden = $post_array['orden'];
                $estado = $post_array['estado'];

                //$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
                $data['fecha_ini']  = $fecha_ini;
                $data['fecha_fin']  = $fecha_fin;
                $data['cliente_id']  = $cliente;
                $data['proyecto']  = $proyecto;
                $data['orden']  = $orden;
                $data['estado']   = $estado;


                $where = null;

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['orc_fecha_orden >='] = date('Y-m-d', strtotime($fecha_ini));
                    $where['orc_fecha_orden <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                }

                if(trim($cliente) != ""){
                    $where['pcl_id_cli'] = $cliente;
                }
                if(trim($proyecto) != ""){
                    $where['pcl_id'] = $proyecto;
                }
                if(trim($orden) != ""){
                    $where['orc_id'] = $orden;
                }
                if(trim($estado) != ""){
                    $where['pcl_id_epr'] = $estado;
                }

                $proyectos = $this->compras_model->get_orden_compra_proyecto_detallado($where);

                $data['proyectos'] = $proyectos;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('modulo_compras/reportes/grid_reporte_compras_proyectos_detallado', $data, true);
                echo $html;
                die();
            }
        } else {
            $cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
            $est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
            $data['clientes'] = $cli;
            $data['estados'] = $est;
            $data['titulo_personal'] = "Consolidado de compras por proyecto";
            cargarvista($data);
        }
    }

    public function imprimir_consolidado_compras_proyecto_detallado(){
        $post_array = $_POST;

        $fecha_ini = $post_array['rpt_txtFechaIni'];
        $fecha_fin = $post_array['rpt_txtFechaFin'];
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $orden = $post_array['rpt_orden'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini']  = $fecha_ini;
        $data['fecha_fin']  = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['estado']   = $estado;

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where['orc_fecha_orden >='] = date('Y-m-d', strtotime($fecha_ini));
            $where['orc_fecha_orden <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }

        if(trim($cliente) != ""){
            $where['pcl_id_cli'] = $cliente;
        }
        if(trim($proyecto) != ""){
            $where['pcl_id'] = $proyecto;
        }
        if(trim($orden) != ""){
            $where['orc_id'] = $orden;
        }
        if(trim($estado) != ""){
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->compras_model->get_orden_compra_proyecto_detallado($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('modulo_compras/reportes/grid_reporte_compras_proyectos_detallado.php', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
        } else{
            $this->load->library('pdf');
            $data['titulo'] = 'Listado detallado compras por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('modulo_compras/reportes/grid_reporte_compras_proyectos_detallado.php', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

            $this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
        }
    }

    /**
    * @author Habby Lovo
    * @since 2018-02-06
    * @return reporte consolidado de compras por proyecto
    */
    public function consolidado_doc_prv_proyecto($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;

                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $cliente = $post_array['cliente'];
                $proyecto = $post_array['proyecto'];
                //$orden = $post_array['orden'];
                $estado = $post_array['estado'];

                //$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
                $data['fecha_ini']  = $fecha_ini;
                $data['fecha_fin']  = $fecha_fin;
                $data['cliente_id']  = $cliente;
                $data['proyecto']  = $proyecto;
                //$data['orden']  = $orden;
                $data['estado']   = $estado;


                $where = null;

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['dpv_fecha_documento >='] = date('Y-m-d', strtotime($fecha_ini));
                    $where['dpv_fecha_documento <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                }

                if(trim($cliente) != ""){
                    $where['pcl_id_cli'] = $cliente;
                }
                if(trim($proyecto) != ""){
                    $where['pcl_id'] = $proyecto;
                }
                /*if(trim($orden) != ""){
                    $where['dpv_id'] = $orden;
                }*/
                if(trim($estado) != ""){
                    $where['pcl_id_epr'] = $estado;
                }

                $proyectos = $this->compras_model->get_documento_proyecto($where);

                $data['proyectos'] = $proyectos;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('modulo_compras/reportes/grid_reporte_documento_proyecto', $data, true);
                echo $html;
                die();
            }
        } else {
            $cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
            $est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
            $data['clientes'] = $cli;
            $data['estados'] = $est;
            $data['titulo_personal'] = "Reporte consolidado de documentos de proveedor por proyecto";
            cargarvista($data);
        }
    }

    public function imprimir_consolidado_doc_prv_proyecto(){
        $post_array = $_POST;

        $fecha_ini = $post_array['rpt_txtFechaIni'];
        $fecha_fin = $post_array['rpt_txtFechaFin'];
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini']  = $fecha_ini;
        $data['fecha_fin']  = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['estado']   = $estado;

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where['dpv_fecha_documento >='] = date('Y-m-d', strtotime($fecha_ini));
            $where['dpv_fecha_documento <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }

        if(trim($cliente) != ""){
            $where['pcl_id_cli'] = $cliente;
        }
        if(trim($proyecto) != ""){
            $where['pcl_id'] = $proyecto;
        }
        /*if(trim($orden) != ""){
            $where['dpv_id'] = $orden;
        }*/
        if(trim($estado) != ""){
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->compras_model->get_documento_proyecto($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('modulo_compras/reportes/grid_reporte_documento_proyecto', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
        } else{
            $this->load->library('pdf');
            $data['titulo'] = 'Listado consolidado de documentos de proveedor por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('modulo_compras/reportes/grid_reporte_documento_proyecto', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

            $this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
        }
    }

    /**
    * @author Habby Lovo
    * @since 2018-02-05
    * @return reporte consolidado de compras por proyecto
    */
    public function consolidado_doc_prv_proyecto_detallado($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;

                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
                $cliente = $post_array['cliente'];
                $proyecto = $post_array['proyecto'];
                $documento = $post_array['documento'];
                $estado = $post_array['estado'];

                //$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
                $data['fecha_ini']  = $fecha_ini;
                $data['fecha_fin']  = $fecha_fin;
                $data['cliente_id']  = $cliente;
                $data['proyecto']  = $proyecto;
                $data['documento']  = $documento;
                $data['estado']   = $estado;


                $where = null;

                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['dpv_fecha_documento >='] = date('Y-m-d', strtotime($fecha_ini));
                    $where['dpv_fecha_documento <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                }

                if(trim($cliente) != ""){
                    $where['cli_id'] = $cliente;
                }
                if(trim($proyecto) != ""){
                    $where['pcl_id'] = $proyecto;
                }
                if(trim($documento) != ""){
                    $where['dpv_id'] = $documento;
                }
                if(trim($estado) != ""){
                    $where['pcl_id_epr'] = $estado;
                }

                $proyectos = $this->compras_model->get_documento_proyecto_detalle($where);

                $data['proyectos'] = $proyectos;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('modulo_compras/reportes/grid_reporte_documento_proyecto_detalle', $data, true);
                echo $html;
                die();
            }
        } else {
            $cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
            $est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
            $data['clientes'] = $cli;
            $data['estados'] = $est;
            $data['titulo_personal'] = "Reporte detallado de documentos de proveedor por proyecto";
            cargarvista($data);
        }
    }

    public function imprimir_consolidado_doc_prv_proyecto_detallado(){
        $post_array = $_POST;

        $fecha_ini = $post_array['rpt_txtFechaIni'];
        $fecha_fin = $post_array['rpt_txtFechaFin'];
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $documento = $post_array['rpt_documentos'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini']  = $fecha_ini;
        $data['fecha_fin']  = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['documento']  = $documento;
        $data['estado']   = $estado;

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where['dpv_fecha_documento >='] = date('Y-m-d', strtotime($fecha_ini));
            $where['dpv_fecha_documento <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }

        if(trim($cliente) != ""){
            $where['pcl_id_cli'] = $cliente;
        }
        if(trim($proyecto) != ""){
            $where['pcl_id'] = $proyecto;
        }
        if(trim($documento) != ""){
            $where['dpv_id'] = $documento;
        }
        if(trim($estado) != ""){
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->compras_model->get_documento_proyecto_detalle($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('modulo_compras/reportes/grid_reporte_documento_proyecto_detalle.php', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
        } else{
            $this->load->library('pdf');
            $data['titulo'] = 'Listado detallado documentos por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('modulo_compras/reportes/grid_reporte_documento_proyecto_detalle.php', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

            $this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
        }
    }

    public function get_proyectos_cliente() {
        $cli_id = $this->input->post('cliente');
        $select = '<option value=""></option>';
        $proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $cli_id));
        foreach ($proyectos as $key) {
            $select .= '<option value="' . $key["pcl_id"] . '">' . $key["pcl_codigo"] . ' - '. $key["pcl_nombre"] . '</option>';
        }
        $opcion = '<option value=""></option>';
        $eta_pro = $this->compras_model->get_estados_proyectos(array('pcl_id_cli' => $cli_id));
        foreach ($eta_pro as $key) {
            $opcion .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        echo json_encode(array('proyectos' => $select, 'estado' => $opcion));
    }

    public function get_ordenes_proyecto(){
        $pro_id = $this->input->post('proyecto');
        $opciones = '';
        $eta_pro = $this->compras_model->get_estado_proyecto_cliente(array('pcl_id' => $pro_id));
        foreach ($eta_pro as $key) {
            $opciones .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        $opciones_ordenes = '<option value=""></option>';
        $ordenes_reg = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id_pcl'=>$pro_id));
        foreach ($ordenes_reg as $key) {
            $opciones_ordenes .= '<option value="' . $key["orc_id"] . '">' . $key["orc_numero"] . '</option>';
        }
        echo json_encode(array('resp' => $opciones, 'ordenes' => $opciones_ordenes));
    }

    public function get_documentos_proyecto(){
        $pro_id = $this->input->post('proyecto');
        $opciones = '';
        $eta_pro = $this->compras_model->get_estado_proyecto_cliente(array('pcl_id' => $pro_id));
        foreach ($eta_pro as $key) {
            $opciones .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        $opciones_documentos = '<option value=""></option>';
        $documentos_reg = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_pcl'=>$pro_id));
        foreach ($documentos_reg as $key) {
            $opciones_documentos .= '<option value="' . $key["dpv_id"] . '">' . $key["dpv_numero_documento"] . '</option>';
        }
        echo json_encode(array('resp' => $opciones, 'documentos' => $opciones_documentos));
    }

    public function precios_compras() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if($this->input->post()) {
            $post_array     = $this->input->post();
            $fecha_inicio    = ($post_array['txtFechaIni'] != '' )? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
            $fecha_fin       = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;
            $producto        = ($post_array['producto'] != '') ? $post_array['producto'] : null;
            $bodega          = ($post_array['bodega'] > 0) ? $post_array['bodega'] : null;
            // Condicionales para la consulta
            $where      = null;
            $groupby    = null;
            $orderby    = null;
            if (trim($fecha_fin) != '') {
                $fecha_fn = date('Y-m-d', strtotime($fecha_fin));
                $where['moi_fecha_mov <='] = $fecha_fn . ' 23:59:59';
            }
            if (trim($fecha_inicio) != '') {
                $fecha_inicio    = date('Y-m-d', strtotime($fecha_inicio));
                $where['moi_fecha_mov >='] = $fecha_inicio . ' 00:00:00';
            }
            if ($producto != '') {
                $where['art_id'] = $producto;
            }
            if ($bodega > 0) {
                $where['bod_id'] = $bodega;
            }
            $where['art_id IS NOT NULL'] = null;
            $where['tip_entrada'] = 1;
            $groupby = 'art_id,bod_id';
            $orderby = 'dee_precio DESC';
            $data['detalles'] = $this->compras_model->get_precios_compras($where, $groupby, $orderby);
            // print_r($this->db->last_query());die();
            $tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Reporte_precios_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Precios de Compra';
            $data['filename']           = $filename;
            $html = $this->load->view('modulo_compras/reportes/consultar_precios_compras', $data, true);
            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Precios de Compra';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_precios_compra_' . date('dmY');
                $reporte                    = $header . $html;
                $head = '<!DOCTYPE html><html><head><title>REPORTE POR PRECIOS DE COMPRA</title></head><body><script type="text/javascript">';
                $head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - REPORTE POR PRECIOS DE COMPRA";';
                $head .= 'window.print();</script>';
                $footer = '</body></html>';
                echo $head.$reporte.$footer;
                die();
                // $this->pdf->makePdf($reporte, 'L', 'Reporte_precios_compra_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $data['titulo_personal']    = 'Reporte de Precios de Compra';
            $bodegas = $this->gsatelite->get_tabla('bod_bodega',array('bod_estado' =>1));
            $data['bodegas'] = $bodegas;
            cargarvista($data);
        }
    }


    /**
     * Descripción:
     * Función para mostrar los registros de proveedores.
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-26
     * @param  Ninguno
     * @return Registros de proveedores.
     */
    function proveedores(){
        satelite_validar();
        if ($this->input->post()) {
            $tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';

            if ($tipo_reporte != null) {
                $personeria = ($this->input->post('filtro_personeria') != '') ? $this->input->post('filtro_personeria') : null;
                $actividad = ($this->input->post('filtro_actividad') != '') ? $this->input->post('filtro_actividad') : null;
            } else {
                $personeria = $this->input->post('personeria');
                $actividad = $this->input->post('actividad');
            }

            /***************************** CONSULTA *****************************************/
                $where = array();

                 if ($personeria > 0) {
                    $where['prv_tipo_pers'] = $personeria;
                }
                if ($actividad > 0) {
                    $where['prv_id_acp'] = $actividad;
                }

                $data['proveedores'] = $this->compras_model->get_proveedores($where);
            /****************************************************************************************************** */
            $data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Proveedores'), true);

            $data['tipo_reporte'] = $tipo_reporte;
            if ($tipo_reporte != '') {
                switch ($tipo_reporte) {
                    case 'pdf':
                        $data['titulo'] = 'Proveedores';
                        $html = $this->load->view('modulo_compras/reportes/proveedores_export', $data, true);
                        $this->pdf->makePdf($html, 'L', 'conteos', 'A4');
                        break;
                    case 'excel':
                        $filename = 'rpt_proveedores' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                        $data['titulo'] = ' Reporte de proveedores';
                        $data['filename'] = $filename;
                        $data['excel'] = 1;
                        $html = $this->load->view('modulo_compras/reportes/proveedores_export', $data, true);
                        echo $html;
                        break;
                }
            }else{
                $html = $this->load->view('modulo_compras/reportes/detalle_proveedores', $data, true);
                echo json_encode(array('resultado' => $html, 'personeria'=>$personeria, 'actividad'=>$actividad));
            }
        }else{

            $actividad= $this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), null, null, null, true);
            $data['actividades_eco'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $actividad);

            $data["titulo_personal"] ="Proveedores";
            $this->_cargarvista($data);
        }
    }

    /**
        * @author Francisco Orozco
        * @since 26-07-2018
        * @return reporte listado de proveedores
    */
    public function listado_proveedores(){
        satelite_validar();
        if ($_POST) {
            $proveedor      = $this->input->post("slc_proveedor");
            //$estado         = $this->input->post("slc_estado");
            $tipo_reporte   = $this->input->post("tipo_reporte");
            $where          = NULL;
            if ( $proveedor != "" ){
                $where["prv_id"]  = $proveedor;
            }
            $nit                        = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NIT_PROVEEDOR');
            $nrc                        = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');

            $select = "*, (IF(prv_tipo_pers=1,CONCAT_WS(' ', prv_nombre, prv_apellido),prv_apellido)) AS nombre, ";
            $select .= "(SELECT GROUP_CONCAT(CONCAT(dcp_id_tde, '#', dcp_valor)) FROM dcp_documento_proveedor WHERE dcp_id_prv = prv_id AND (dcp_id_tde = ".$nit." OR dcp_id_tde = ".$nrc.")) AS documentos, ";
            $select .= "IFNULL((SELECT GROUP_CONCAT(CONCAT(ban_nombre,': ',dbp_cuenta_banco)) FROM dbp_detalle_banco_proveedor JOIN ban_banco ON ban_id = dbp_id_ban WHERE dbp_id_prv = prv_id),'--') AS cuentas";
            $data['proveedores']        = $this->compras_model->get_proveedores($where,NULL,$select);
            $data["nit"]                = $nit;
            $data["nrc"]                = $nrc;
            $data["tipo_reporte"]       = $tipo_reporte;
            $filename                   = 'Reporte_proveedores_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Reporte proveedores';
            $data['filename']           = $filename;
            $html = $this->load->view('modulo_compras/reportes/consultar_proveedores', $data, true);

            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_proveedores_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_proveedores_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $proveedores            = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers=1,CONCAT_WS(' ', prv_nombre, prv_apellido),prv_apellido)]", array("prv_estado"=> 1), null, '', '', 'prv_id', true);
            $data['proveedores']    = str_replace('<option value="0">Seleccione</option>', '', $proveedores);
            $data['titulo_personal']= 'Reporte de proveedores';
            cargarvista($data);
        }
    }

    /**
    * @author Rafael Cuchilla
    * @since 2018-08-08
    * @return reporte de liquidacion de caja chica
    */
    public function consolidado_caja_chica($consulta=0){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;
                $caja = $post_array['caja'];
                $where = null;
                if(is_array($post_array['slcCorte'])){
                    $where['ids_lcc'] = (count($post_array['slcCorte']) > 0) ? implode(',', $post_array['slcCorte']) : 0;
                } else{
                    $where['ids_lcc'] = (trim($post_array['slcCorte']) != "") ? $post_array['slcCorte'] : 0;
                }
                if(trim($caja) != ""){
                    $where['cch_id'] = $caja;
                }
                $fecha_ini_fin = $this->compras_model->get_inicio_fin_cortes(array("lcc_id IN (" . $where['ids_lcc'] . ")" => null));
                $fecha_ini = $fecha_ini_fin['fecha_inicio'];
                $fecha_fin = $fecha_ini_fin['fecha_fin'];
                $data['fecha_ini']  = $fecha_ini;
                $data['fecha_fin']  = $fecha_fin;
                $data['caja_id']  = $caja;
                $detalles = $this->compras_model->get_datos_liquidacion_caja_chica($where);
                $where2['lcc_id_cch'] = $caja;
                $where2["rcc_id_lcc IN (".$where['ids_lcc'].")"] = NULL;
                $ultimo_ingreso = $this->compras_model->get_ultimo_ingreso_caja_chica($where2);
                $data['ingreso_caja'] = ($ultimo_ingreso) ? $ultimo_ingreso['rcc_monto'] : "";
                $data['detalles'] = $detalles;
                $data['tipo_reporte'] = 'grid';
                $html = $this->load->view('modulo_compras/reportes/grid_reporte_liquidacion_caja_chica', $data, true);
                echo $html;
                die();
            }
        } else {
            $caja = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado' =>1));
            $data['cajas'] = $caja;
            $data['titulo_personal'] = "Reporte de Liquidacion de Caja Chica";
            cargarvista($data);
        }
    }

    public function imprimir_consolidado_caja_chica(){
        $post_array = $_POST;
        $caja = $post_array['rpt_caja'];
        $tipo = $post_array['rpt_tipo'];
        $nombre_caja = $post_array['caja_name'];
        $where = null;
        if(trim($caja) != ""){
            $where['cch_id'] = $caja;
        }
        $where['ids_lcc'] = 0;
        if(is_array($post_array['slcCorte'])) {
            $where['ids_lcc'] = (count($post_array['slcCorte']) > 0) ? implode(',', $post_array['slcCorte']) : 0;
        } else {
            $where['ids_lcc'] = (trim($post_array['slcCorte']) !="") ? $post_array['slcCorte'] : 0;
        }
        $fecha_ini_fin = $this->compras_model->get_inicio_fin_cortes(array("lcc_id IN (".$where['ids_lcc'].")" => null));
        $fecha_ini = $fecha_ini_fin['fecha_inicio'];
        $fecha_fin = $fecha_ini_fin['fecha_fin'];
        $detalles = $this->compras_model->get_datos_liquidacion_caja_chica($where);
        $where2['lcc_id_cch'] = $caja;
        $where2["rcc_id_lcc IN (".$where['ids_lcc'].")"] = NULL;
        $ultimo_ingreso = $this->compras_model->get_ultimo_ingreso_caja_chica($where2);
        $data['ingreso_caja'] = ($ultimo_ingreso) ? $ultimo_ingreso['rcc_monto'] : "";
        $data['suma_reintego'] = $this->gsatelite->get_suma('rcc_reintegro_caja_chica', 'rcc_monto', array('rcc_id_lcc IN ('.$where['ids_lcc'].')' => null));
        $data['fecha_ini']  = $fecha_ini;
        $data['fecha_fin']  = $fecha_fin;
        $data['caja_id']  = $caja;
        $data['nombre_caja'] = $nombre_caja;
        $data['detalles'] = $detalles;
        $data['tipo_reporte'] = $tipo;
        if($tipo == 'excel'){
            $filename = 'rpt_liquidacion_caja_chica' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('modulo_compras/reportes/grid_reporte_liquidacion_caja_chica', $data);
        } else{
            $this->load->library('pdf');
            $data['titulo'] = 'REPORTE DE LIQUIDACION DE CAJA CHICA';
            $data['solotitulo'] = '1';
            $header = $this->load->view('reporte/header', $data, true);
            $html = $this->load->view('modulo_compras/reportes/grid_reporte_liquidacion_caja_chica', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_liquidacion_caja_chica' . date('dmY');
            $this->pdf->makePdf($header.$html, 'L', 'rpt_liquidacion_caja_chica', 'Letter');
        }
    }

    public function rpt_compras_sugeridas()
    {
      satelite_validar();

      if ($this->input->post()) {
          $post_array     = $this->input->post();

          $fecha_ini     = ($post_array['fecha_ini'] != '' )? $post_array['fecha_ini'] : null;
          $fecha_fin   = ($post_array['fecha_fin'] != '')? $post_array['fecha_fin'] : null;
          $proveedor = ($post_array['slcprv'] != '')? $post_array['slcprv'] : null;

          $where    = null;

          if ($fecha_ini != '' && $fecha_fin != '') {
            $fecha_1 = date('Y-m-d', strtotime($fecha_ini));
            $fecha_2 = date('Y-m-d', strtotime($fecha_fin));
            $where = array('DATE(moi_fecha_mov)>=' => $fecha_1,'DATE(moi_fecha_mov)<=' => $fecha_2);
          }

          if ($proveedor > 0) {
              $where['moi_id_prv'] = $proveedor;
          }

          // Parametro para los decimales
          $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

          $data['consulta']       = $this->compras_model->get_compras_sugeridas($where); //print_r($this->db->last_query());die();

          $tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
          $data["tipo_reporte"]   = $tipo_reporte;
          $filename                   = 'Reporte_compras_sugeridas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
          $data['titulo']             = 'Compras Sugeridas de Productos por Bodega';
          $data['filename']           = $filename;
          $html = $this->load->view('modulo_compras/reportes/get_compras_sugeridas', $data, true);

          if ($tipo_reporte == '') {
              $data2['html'] = $html;
              echo json_encode($data2);
              die();
          } elseif ($tipo_reporte == 'pdf') {
              $data['titulo']             = 'Compras Sugeridas de Productos por Bodega';
              $header                     = $this->load->view('reporte/header', $data, true);
              $GLOBALS['nombre_reporte']  = 'Reporte_compras_sugeridas_' . date('dmY');
              $reporte                    = $header . $html;
              $this->pdf->makePdf($reporte, 'L', 'Reporte_compras_sugeridas_', 'Letter');
          } elseif ($tipo_reporte == 'excel') {
              echo $html;
          }
      } else {
          $select = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
          $data['proveedores'] = $select;
          $data['titulo_personal']    = 'Reporte de Compras Sugeridas';
          cargarvista($data);
      }
    }

    function cheques_caja_chica($tipo_reporte = null) {        
        satelite_validar();
        if ($_POST){          
            $post_array = $_POST;      
            $caja        = $post_array['slcCaja'];
            $fecha_desde = $post_array['txtFechaDesde'];
            $fecha_hasta = $post_array['txtFechaHasta'];
            $where = null;
            $having = null;
            if(is_array($post_array['slcCorte'])) {
                $where['ids_lcc'] = (count($post_array['slcCorte']) > 0)? implode(',', $post_array['slcCorte']):0;
            } else {
                $where['ids_lcc'] = (trim($post_array['slcCorte']) !="")? $post_array['slcCorte']:0;
            }
            if(trim($caja) != ""){
                $where['cch_id'] = $caja;
            } 
            if(trim($fecha_desde) != ""){
                $having['che_fecha >='] = date('Y-m-d', strtotime($fecha_desde));
            }        
            if(trim($fecha_hasta) != ""){
                $having['che_fecha <='] = date('Y-m-d', strtotime($fecha_hasta));
            }        
            $listado = $this->compras_model->get_cheques_por_caja_chica($where,$having);
            $data['listado'] = $listado;
            //$data['fecha_desde'] = date('Y-m-d', strtotime($fecha_desde));
            //$data['fecha_hasta'] = date('Y-m-d', strtotime($fecha_hasta));
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Cheques por Caja Chica'), true);
            $html .= $this->load->view('modulo_contabilidad/reportes/reporte_cheques_caja_chica', $data, true);                  
            $reporte=$this->pdf->makePDF($html, 'P');                
            $this->_cargarvista( null, $data );
            
        } else {
            $caja = $this->gsatelite->get_tabla('cch_caja_chica',array('cch_estado' =>1));
            $data['cajas'] = $caja;            
            $data['titulo_personal'] = "Reporte de Cheques por Caja Chica";
            $this->_cargarvista($data);
        }
    }


    /**
    * @author René Castaneda
    * @since 2018-12-08
    * @return generar reporte filtrar compras
    */
    public function informe_icv() {   
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos']=$permisos;         
        $data['titulo_personal'] = "Reporte compra a proveedores";
        $proveedores_reg = $this->gsatelite->get_dropdown('prv_proveedor', '[CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_nombre," ",prv_apellido) ELSE prv_nombre END]', '', array('prv_estado'=>1, '!ISNULL(prv_id_clp)' => null), null, null, 'prv_id', true);
        $proveedores = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $proveedores_reg);
        $data['proveedor'] = $proveedores;
        //Clasificacion de proveedor
        $select = $this->gsatelite->get_dropdown('clp_clasificacion_proveedor', '{clp_nombre}', '', array('clp_estado' => 1), null, '', 'clp_id', true);
        $data["clasificacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2018-12-08
    * @return filtrar compras
    */

    public function filtrar_informe_icv($es_reporte=0){   
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('informe_icv');
        $data['permisos']=$permisos;
        $clasificacion_filtro = $this->input->post('clasificacion_filtro');
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $proveedor_filtro = $this->input->post('proveedor_filtro');
        $tipoGenerador = ($this->input->post('tipo_accion') > 0) ? $this->input->post('tipo_accion') : 0;
        $parametro = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA'), true);
        $where['dpv_estado !='] = '0';
        if ($this->input->post()) {                        
            if ($txtFecha_desde !='') {
                $txtFecha_desde = '01-'.$txtFecha_desde;
                $where['DATE(dpv_fecha_documento) >='] = formatear_fecha('Y-m-d',$txtFecha_desde);
            }
            if ($txtFecha_hasta !='') {
                $txtFecha_hasta = '01-'.$txtFecha_hasta;
                $where['DATE(dpv_fecha_documento) <='] = formatear_fecha('Y-m-t',$txtFecha_hasta);
            }
            if ($proveedor_filtro !='') {
                $where['prv_id'] = $proveedor_filtro;
            }
            if($clasificacion_filtro != ''){
                $where['prv_id_clp'] = $clasificacion_filtro;
            } else{
                $clasificacion_filtro = (isset($parametro['ID_CLP_LOCAL']) && $parametro['ID_CLP_LOCAL'] != '') ? (int)$parametro['ID_CLP_LOCAL'] : 1;
                //$where['prv_id_clp'] = $clasificacion_filtro;
            }
        }
        // $registros=$this->compras_model->informe_compras_proveedores($where);
        $data['where_consulta'] = $where;
        $data['es_reporte'] = ($tipoGenerador > 0) ? 1 : 0;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['tipo_documento_nit'] = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $data['tipo_documento_nrc'] = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
        // $data['registros'] = $registros;
        $meses = array('','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
        $data['meses'] = $meses;
        $html = $this->load->view('modulo_compras/reportes/filtrar_informe_icv', $data, true);
        $filtro_titulo = "";
        $filtro_titulo .= ($txtFecha_desde !='')? " Desde: ".$txtFecha_desde:"";
        $filtro_titulo .= ($txtFecha_hasta !='' )? " Hasta: ".$txtFecha_hasta:"";

        if ($tipoGenerador == 2) { //excel
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=compras_proveedores_".date('d-m-Y_His').".xls"); 
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
            <tr><th colspan='10' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
            <tr><th colspan='10' align='center' >Reporte compra proveedores</th></tr>
            <tr><th colspan='10' align='center' >".$filtro_titulo. "</th></tr>
            </table>";
            echo $html; die();
        } else if ($tipoGenerador == 1) { //pdf
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');

            $this->load->library('pdf');
            $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte compra proveedores<br /> $filtro_titulo", 'solotitulo'=> true), true);
            $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
            $this->pdf->makePDF($html_header.$html,'lanscape', 'total_activo','Letter');
            die();
        } elseif ($tipoGenerador == 4) {//csv
            $linea = array();
            $registros = $this->compras_model->informe_compras_proveedores($where);
            foreach ($registros as $key => $value) {
                $linea_texto = array();
                $d = explode(':#', $value['documento']);
                $doc = str_replace('-', '', $d[1]);
                if ($d[2] == 2) {
                    $doc = str_pad($doc, 14, " ", STR_PAD_RIGHT);
                } elseif ($d[2] == 3) {
                    $doc = str_pad($doc, 14, " ", STR_PAD_LEFT);
                }
                $monto = number_format(($value['subtotal_proveedor'] * 100), 0, '.', '');
                $iva = number_format(($value['monto_iva'] * 100), 0, '.', '');
                $linea_texto[] = $value['mes'];
                $linea_texto[] = $d[2];
                $linea_texto[] = $doc;
                $linea_texto[] = formatear_fecha('Ymd', $value['fecha_compra']);
                $linea_texto[] = $value['tif_codigo_hacienda'];
                $linea_texto[] = str_pad(str_replace('-', '', $value['dpv_numero_documento']), 20, " ", STR_PAD_RIGHT);
                $linea_texto[] = str_pad($monto, 11, "0", STR_PAD_LEFT);
                $linea_texto[] = str_pad($iva, 11, "0", STR_PAD_LEFT);
                $linea_texto[] = $value['anio'];
                $linea[] = trim(implode(',', $linea_texto));
            }
            $ruta_carga = 'public/temp/archivos/';
            $nombre = 'compras_icv_'.date('d-m-Y').'.csv';
            $ruta_completa  = $ruta_carga . $nombre;
            if (file_exists($ruta_completa)) {
                unlink($ruta_completa);
            }
            $separador = chr(13) . chr(10);
            $texto_completo = $separador . implode($separador, $linea);
            $archivo = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
            $texto_completo = trim($texto_completo);
            fputs($archivo, $texto_completo);
            fclose($archivo);
            if (ob_get_contents()) ob_end_clean();
            header('Content-Type: text/html; charset=utf-8');
            header("Content-Type: application/octet-stream");
            header('Content-Disposition: attachment; filename=' . $nombre);
            readfile($ruta_completa);
            die();
        } else if ($tipoGenerador == 3) { //txt
            $registros=$this->compras_model->informe_compras_proveedores($where);
            $array_lineas = array();
            $array_lineas_inconsistentes[] = '======================== LINEAS INCONSISTENTES =========================';
            $clasificacion = $registros[0]['prv_id_clp'];

            $tipo_documento_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
            $tipo_documento_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
            $tipo_documento_nrc = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');

            $ruta_carga='public/temp/archivos/';
            $nombre='compras_proveedor_'.date('d-m-Y_H_i').'.prn';
            $locales = (isset($parametro['ID_CLP_LOCAL']) && $parametro['ID_CLP_LOCAL'] != '') ? (int)$parametro['ID_CLP_LOCAL'] : 1;
            $acreedor = (isset($parametro['ID_CLP_ACREE']) && $parametro['ID_CLP_ACREE'] != '') ? (int)$parametro['ID_CLP_ACREE'] : 2;
            $id_extrj = (isset($parametro['ID_CLP_INTERN']) && $parametro['ID_CLP_INTERN'] != '') ? $parametro['ID_CLP_INTERN'] : 3;
            $exento = (isset($parametro['ID_CLP_EXEN']) && $parametro['ID_CLP_EXEN'] != '') ? (int)$parametro['ID_CLP_EXEN'] : 4;
            $extrajero = explode(',', $id_extrj);
            
            if($clasificacion_filtro == $locales){
                /* ================================================================================================
                                                FORMATO PARA PROVEEDOR LOCALES
                ================================================================================================ */
                $nombre='compras_proveedor_local'.date('d-m-Y_H_i').'.prn';
                $k=1;
                foreach ($registros as $f) {
                    $linea = "";
                    $doc = "---";
                    $ndoc = "---";
                    $id_ndohacienda="1";
                    if (trim($f['documento']) != '') {
                        $d = explode(':#', $f['documento']);
                        $doc = $d[0];
                        $ndoc = $d[1];
                        $id_ndohacienda = $d[2];
                    }

                    $linea .=  str_pad(trim($f['mes']), 2, " ", STR_PAD_RIGHT);
                    $linea .=  str_pad(trim($id_ndohacienda), 1, " ", STR_PAD_RIGHT);
                    $linea .=  str_pad(trim(str_replace("-",'', $ndoc)), 14, ' ', STR_PAD_RIGHT);
                    $linea .=  str_pad(trim($f['fecha_compra_prn']), 8, " ", STR_PAD_RIGHT);
                    $linea .=  str_pad(trim($f['tif_codigo_hacienda']), 1, " ", STR_PAD_RIGHT);
                    $linea .=  str_pad(trim($f['dpv_numero_documento']), 20, " ", STR_PAD_RIGHT);
                    // $linea .=  str_pad(trim($f['dpv_documento_proveedor']), 20, ' ', STR_PAD_RIGHT);
                    $linea .=  str_pad(number_format($f['subtotal_proveedor'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(number_format($f['monto_iva'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(trim($f['anio']), 4, " ", STR_PAD_RIGHT);
                    if (strlen($linea)==72) 
                        $array_lineas[] = $linea;
                    else
                        $array_lineas_inconsistentes[] = $linea;
                }
                /* ================================================================================================
                                                FIN FORMATO PARA PROVEEDOR LOCALES
                ================================================================================================ */
            } else if($clasificacion_filtro == $acreedor){
                /* ================================================================================================
                                            FORMATO PARA ACREEDORES
                ================================================================================================ */
                $nombre='compras_proveedor_acreedores'.date('d-m-Y_H_i').'.prn';
                foreach ($registros as $f) {
                    $linea = "";
                    $tdoc = "---";
                    $ndoc = "---";
                    $id_ndohacienda = "4";
                    if (trim($f['documento_icv']) != '') {
                        $d = explode(':#', $f['documento_icv']);
                        $tdoc = $d[0];//no se usa
                        $ndoc = str_replace('-', '', $d[1]);//numero de documento sin guiones
                        $id_ndohacienda = $d[2];//numero segun hacienda
                    }

                    $linea .=  str_pad(trim($f['mes']), 2, " ", STR_PAD_RIGHT);
                    $linea .=  str_pad(trim($id_ndohacienda), 1, " ", STR_PAD_RIGHT);
                    $linea .=  str_pad(trim($ndoc), 14, ' ', STR_PAD_RIGHT);
                    $linea .=  str_pad(number_format($f['subtotal_proveedor'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(trim($f['anio']), 4, " ", STR_PAD_RIGHT);
                    if ($ndoc != "---"){
                        $array_lineas[] = $linea;
                    }
                    else{
                        $array_lineas_inconsistentes[] = $linea;
                    }
                }
                /* ================================================================================================
                                            FIN FORMATO PARA ACREEDORES
                ================================================================================================ */
            } else if(in_array($clasificacion_filtro, $extrajero)){/*$clasificacion_filtro == 3*/
                /* ================================================================================================
                                                FORMATO PARA PROVEEDOR EXTRANJERO
                ================================================================================================ */
                $nombre='compras_proveedor_extranjero'.date('d-m-Y_H_i').'.prn';
                foreach ($registros as $f) {
                    $linea = "";
                    $tdoc = "---";
                    $ndoc = "---";
                    $idoc = "9";
                    $id_ndohacienda = "";
                    if (trim($f['documento_extranjero']) != '') {
                        $d = explode(':#', $f['documento_extranjero']);
                        $tdoc = $d[0];//no se usa
                        $ndoc = str_replace('-', '', $d[1]);//numero de documento sin guiones
                        $id_ndohacienda = $d[2];//numero segun hacienda
                    }

                    if($id_ndohacienda > 5){
                        $id_ndohacienda = 6;
                    }
                    $concepto_opc = ($f['dpv_id_tmt'] != null)?$f['dpv_id_tmt']:'';
                    $fecha_emision = formatear_fecha("Ymd", $f['dpv_fecha_documento']);

                    $linea .=  str_pad(trim($f['mes']), 2, " ", STR_PAD_RIGHT);//Mes
                    $linea .=  str_pad(trim($idoc), 1, " ", STR_PAD_RIGHT);//CONCEPTO DE OPERACION TBL NUEVA
                    $linea .=  str_pad(trim($id_ndohacienda), 1, " ", STR_PAD_RIGHT);//Tipo de documento 1:NIT,2:NRC,3:DUI,4:PASAPORTE,5:CARNET,6:OTROS
                    $linea .=  str_pad(trim($ndoc), 14, ' ', STR_PAD_RIGHT);//Documento DUI o NIT
                    $linea .=  str_pad(trim(($f['prv_tipo_pers'] == 2)?$f['prv_nombre']:$f['prv_nombre']." ".$f['prv_apellido']), 50, ' ', STR_PAD_RIGHT);//Nombre proveedor
                    $linea .=  str_pad(trim(($f['prv_representante'] != null)?$f['prv_representante']:""), 50, ' ', STR_PAD_RIGHT);//Nombre representante
                    $linea .=  str_pad(trim($fecha_emision), 8, ' ', STR_PAD_RIGHT);//fecha de emision
                    $linea .=  str_pad(trim('3'), 1, ' ', STR_PAD_RIGHT);//tipo de documento PENDIENTE
                    $linea .=  str_pad(trim($f['dpv_numero_documento']), 20, ' ', STR_PAD_RIGHT);//numero de documento PENDIENTE
                    $linea .=  str_pad(number_format($f['subtotal_proveedor'],2,'',''), 11, "0", STR_PAD_LEFT);//MONTO DE OPERACION
                    $linea .=  str_pad(number_format($f['monto_iva'],2,'',''), 11, '0', STR_PAD_LEFT);//IVA DE OPERACION
                    $linea .=  str_pad(trim($f['anio']), 4, " ", STR_PAD_RIGHT);//Año
                    if ($ndoc != "---" && $id_ndohacienda != "" && $concepto_opc != ''){
                        $array_lineas[] = $linea;
                    }
                    else{
                        $array_lineas_inconsistentes[] = $linea;
                    }
                }
                /* ================================================================================================
                                                FIN FORMATO PARA PROVEEDOR EXTRANJERO
                ================================================================================================ */
            } else if($clasificacion_filtro == $exento){
                /* ================================================================================================
                                    FORMATO PARA PROVEEDOR EXCLUIDO EN IVA
                ================================================================================================ */
                $nombre='compras_proveedor_excluido_iva'.date('d-m-Y_H_i').'.prn';
                foreach ($registros as $f) {
                    $linea = "";
                    $tdoc = "---";
                    $ndoc = "---";
                    $idoc = "4";
                    $id_ndohacienda = "";
                    if (trim($f['documento_iva']) != '') {
                        $d = explode(':#', $f['documento_iva']);
                        $tdoc = $d[0];//no se usa
                        $ndoc = str_replace('-', '', $d[1]);//numero de documento sin guiones
                        $id_ndohacienda = $d[2];//numero segun hacienda
                    }

                    $fecha_emision = formatear_fecha("Ymd", $f['dpv_fecha_documento']);

                    $id_ndohacienda = ($id_ndohacienda != 1 || $id_ndohacienda != 3)?"":$id_ndohacienda;


                    $linea .=  str_pad(trim($f['mes']), 2, " ", STR_PAD_RIGHT);//Mes
                    $linea .=  str_pad(trim($id_ndohacienda), 1, " ", STR_PAD_RIGHT);//Tipo de documento 1:NIT, 3:DUI
                    $linea .=  str_pad(trim($ndoc), 14, ' ', STR_PAD_RIGHT);//Documento DUI o NIT
                    $linea .=  str_pad(trim($fecha_emision), 8, ' ', STR_PAD_RIGHT);//fecha de emision
                    $linea .=  str_pad(trim('1'), 8, ' ', STR_PAD_RIGHT);//tipo de documento PENDIENTE
                    $linea .=  str_pad(trim($f['dpv_numero_documento']), 20, ' ', STR_PAD_RIGHT);//numero de documento PENDIENTE
                    $linea .=  str_pad(number_format($f['subtotal_proveedor'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(trim($f['prv_direccion']), 150, ' ', STR_PAD_RIGHT);//Direccion
                    $linea .=  str_pad(trim($f['anio']), 4, " ", STR_PAD_RIGHT);//Año
                    if ($ndoc != "---" && $id_ndohacienda != ""){
                        $array_lineas[] = $linea;
                    }
                    else{
                        $array_lineas_inconsistentes[] = $linea;
                    }
                }
                /* ================================================================================================
                                    FIN FORMATO PARA PROVEEDOR EXCLUIDO EN IVA
                ================================================================================================ */
            }
            /* ================================================================================================
                                    GENERACION DEL ARCHIVO PRN
            ================================================================================================ */
            $separador = chr(13).chr(10);
            if (count($array_lineas_inconsistentes)>1){
                $lineas = implode($separador,array_merge($array_lineas,$array_lineas_inconsistentes));
            }
            else{
                $lineas = implode($separador,$array_lineas);
            }

            $ruta_completa=$ruta_carga.$nombre;

            if (file_exists("$ruta_completa")) {
                unlink("$ruta_completa"); //eliminar el archivo si existiese
            }

            $archivo=fopen($ruta_completa,'w+') or die('No hay permisos de escritura');
            $lineas=trim($lineas);
            fputs($archivo, $lineas);
            fclose($archivo);
            header( "Content-Type: application/octet-stream");
            header('Content-Disposition: attachment; filename="'.$nombre.'"');
           // header("Location: ".base_url()."public/temp/archivos/$nombre");

            ob_clean(); 
            flush(); 
            readfile("$ruta_completa");
            #header("Location: " . base_url() . "uploads/txt_planilla/$nombre_archivo"); 
            die();

        }
        echo json_encode(array('html'=>$html));
    }

     function detalles_cheques_por_caja_chica() {        
        satelite_validar();
        $post_array = $_POST;      
        $caja        = $post_array['caja'];
        $fecha_desde = $post_array['fecha_desde'];
        $fecha_hasta = $post_array['fecha_hasta'];
        $where  = null;
        $having = null;                        
        if(trim($caja) != ""){
            $where['cch_id'] = $caja;
        }        
        if(is_array($post_array['slcCorte'])) {
            $where['ids_lcc'] = (count($post_array['slcCorte']) > 0)? implode(',', $post_array['slcCorte']):0;
        } else {
            $where['ids_lcc'] = (trim($post_array['slcCorte']) !="")? $post_array['slcCorte']:0;
        }
        if(trim($fecha_desde) != ""){
            $having['che_fecha >='] = date('Y-m-d', strtotime($fecha_desde));
        }        
        if(trim($fecha_hasta) != ""){
            $having['che_fecha <='] = date('Y-m-d', strtotime($fecha_hasta));
        }        
        $listado = $this->compras_model->get_cheques_por_caja_chica($where,$having);
        $data['listado'] = $listado;
        $html = $this->load->view('modulo_contabilidad/reportes/detalle_cheques_caja_chica', $data, true);
        echo $html;

    }

    /**
    * @author René Castaneda
    * @since 2018-12-08
    * @return filtrar cortes caja
     */
    public function filtrar_corte_caja() {
        $where['lcc_id_cch'] = $this->input->post('slcCaja');
        if ($where['lcc_id_cch'] > 0 ) {
            $this->db->order_by('lcc_fecha_inicio', 'DESC');
            $data['options'] = $this->gsatelite->get_dropdown('lcc_liquidacion_caja_chica', '{DATE(lcc_fecha_inicio)} A {DATE(lcc_fecha_fin)}','', $where, null, '', 'lcc_id', true);
        } else {
            $this->db->order_by('lcc_fecha_inicio', 'DESC');
            $data['options'] = $this->gsatelite->get_dropdown('lcc_liquidacion_caja_chica', '{DATE(lcc_fecha_inicio)} A {DATE(lcc_fecha_fin)}','', null, null, '', 'lcc_id', true);
        }
        $data['options'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $data['options']);
        die(json_encode($data));
    }

    /**
     * Descripción:
     * Función para reporte de documentos por proveedor sin salidas de inventarios
     * @author Elman Ortiz - Grupo Satélite
     * @since 2019-01-21
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    function reporte_doc_proveedor_sin_salida($flag = null){                
        satelite_validar();
        if ($_POST){
            
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
                $slcProveedor = ($post_array['slcProveedor'] != '') ? $post_array['slcProveedor'] : null;
                $slcTipoDocumento  = ($post_array['slcTipoDocumento'] != '') ? $post_array['slcTipoDocumento'] : null;                
                $fecha_inicio    = ($post_array['fecha_inicio'] != '') ? $post_array['fecha_inicio'] : null;                
                $fecha_fin       = ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;                
            } else {
                $slcProveedor = ($post_array['hslcproveedor'] != '') ? $post_array['hslcproveedor'] : null;                
                $slcTipoDocumento  = ($post_array['htipodocumento'] != '') ? $post_array['htipodocumento'] : null;                
                $fecha_inicio    = ($post_array['hfechainicio'] != '') ? $post_array['hfechainicio'] : null;                                
                $fecha_fin    = ($post_array['hfechafin'] != '') ? $post_array['hfechafin'] : null;                                
                $data['proveedortext'] = ($post_array['hslcproveedortext'] != '') ? '<b>Proveedor: </b>' . $post_array['hslcproveedortext'] : '<b>Proveedores: </b>' .'Todos';                
                $data['tipodocumentotext']     = ($post_array['htipodocumentotext'] != '') ? '<b>Tipo documento: </b>' . $post_array['htipodocumentotext'] : '<b>Tipo documento: </b>' . 'Todos';            
                $data['fecha_inicio_text']     = ($post_array['hfechainicio'] != '') ? '<b>Periodo: </b>' . $post_array['hfechainicio'] .' - '. $post_array['hfechafin'] : '<b>Periodo: </b>' . '';                            
            }
            
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($slcProveedor != null) {
                $where['dpv_id_prv']    = $slcProveedor;
            }
            
            if ($slcTipoDocumento != null) {
                $where['dpv_id_tif']        = $slcTipoDocumento;
            }

            if ($fecha_inicio != null) {
                $where['DATE(dpv_fecha_documento) >=']=formatear_fecha('Y-m-d', $fecha_inicio);                
            }

            if ($fecha_fin != null) {
                $where['DATE(dpv_fecha_documento) <=']=formatear_fecha('Y-m-d', $fecha_fin);                
            }

            $where['dpv_estado'] = 1;
            $where['dpv_afecta_inventario'] = 1;
            //$where['(moi_id_dpv IS NULL OR tip_salida = 0)'] = null;     
            $chkProceso = ($this->input->post('chkProceso') == 1) ? 'salida':'entrada';
            $data['tipo_proceso'] = $chkProceso;
            //print_r($chkProceso); die();
                        $this->db->having("$chkProceso",0);
            $reporte = $this->compras_model->get_doc_proveedor_sin_salida($where);
            //print_r($reporte); die();
            //print_r($this->db->last_query()); die();
            $filename = "rpt_reporte_doc_proveedor_sin_$chkProceso" . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
            $data['filename']              = $filename;
            $data['reporte']               = $reporte;
            $data['tipo_reporte']          = $tipo_reporte;
            
            $html = $this->load->view('modulo_compras/reportes/filtrar_doc_proveedor_sin_salida', $data, true);
            
            if ($flag) {                
                echo $html;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = "documentos de proveedor sin $chkProceso";

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_documentos_proveedor_sin_salida_' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->makePdf($reporte, 'L', 'reporte_documentos_proveedor_sin_salida_', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_documentos_proveedor_sin_salida_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'documentos de proveedor sin salida';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
            
        } else{            
            $data['slcProveedor'] = $this->compras_model->get_proveedor_pers();                    
            $select = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1, 'tif_aplica_compra'=>1), null, '', 'tif_id', true);
            $data["slcTipoFactura"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);                    
            $data['titulo_personal'] = "Documentos por proveedor sin salida";
            $this->_cargarvista($data);
        }
    }

    /**
    * @author Nelson Soriano
    * @since  07-02-2019
    * @return reporte comparatvo de cotizaciones
    * @since  07-07-2020
    * @author Raul E.
    * Descripcion: Se redirecciona por buscar cotizaciones de crm en lugar de cot. de compra
    */
    public function comparar_cotizaciones(){
       satelite_validar();
       if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } 
        $cot = $this->gsatelite->get_dropdown('coc_cotizacion_compra', "Cotización #{coc_numero}", null, array("coc_estado" => 1), '', '', 'coc_id', true);
        $data['cotizaciones'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cot); 
        $data['permisos']          = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal']   = 'Comparativo de Cotizaciones';
        $this->_cargarvista($data);
    }

     /**
    * @author Nelson Soriano
    * @since  07-02-2019
    * @return retorna la vista para el reporte comparativo de cotizaciones
    */
     public function get_comparativo_cotizaciones($reporte = null){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('comparar_cotizaciones');
        if ($_POST) {
            $post_array         = $this->input->post();
            $fecha_ini          = $post_array['rpt_txtFechaIni'];
            $fecha_fin          = $post_array['rpt_txtFechaFin'];
            $producto           = $post_array['rpt_producto'];
            $cot                = $post_array['rpt_cotizacion'];
            $accion             = !isset($post_array['tipo_accion']) ? null: $post_array['tipo_accion'];
            $decimales          = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $data['decimales']  = ($decimales == '') ? 2 : $decimales;
            $data['fecha_ini']  = $fecha_ini;
            $data['fecha_fin']  = $fecha_fin;
            $data['producto']   = $producto;
            $data['cotizacion'] = $cot;
            $data['es_reporte'] = $reporte;
            $where = null;
            if ($fecha_ini != '' && $fecha_fin != '') {
                $where['date_format(coc_fecha,"%Y-%m-%d") >='] = formatear_fecha('Y-m-d', $fecha_ini);
                $where['date_format(coc_fecha,"%Y-%m-%d") <='] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if(trim($producto) != ""){
                $where['dco_id_art'] = $producto;
            }
            if (trim($cot) != "") {
                $where['dco_id_coc'] = $cot;
            }
            $coti = $this->gsatelite->get_campo('coc_cotizacion_compra','coc_numero',array('coc_id'=>$cot));
            $pro = ($producto != "") ? $this->gsatelite->get_campo('art_articulo','art_nombre',array('art_id'=>$producto)) : "";
            $data['info']   = $cotizaciones = $this->compras_model->get_cotizaciones_comparativo($where);
            $html           = $this->load->view('modulo_compras/reportes/get_comparativo_cotizaciones', $data, true);
            $filtro_titulo  = 'Desde: ' . $fecha_ini  .'<br>Hasta: ' . $fecha_fin . '<br>Cotizacion: ' . $coti;
            $filtro_titulo .= ($producto != "") ? '<br>Producto: ' . $pro : '';
            if($reporte){
                switch ($accion) {
                    case 'pdf':
                        $this->load->library('pdf');
                        $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Comparativo Cotizaciones <br /> $filtro_titulo", 'solotitulo'=> true), true);
                        $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                        $this->pdf->makePDF($html_header.$html,'lanscape', 'comparativo_cotizaciones','Legal');
                        die();
                        break;

                    case 'excel':
                        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                        header("Content-Disposition: attachment;filename=cotizaciones".date('d-m-Y_His').".xls");
                        header("Pragma: no-cache");
                        header("Expires: 0");
                        echo '<meta charset="utf-8" />';
                        echo "
                        <table border='0'>
                        <tr><th colspan='6' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                        <tr><th colspan='6' align='center' >Comparativo de cotizaciones</th></tr>
                        <tr><th colspan='6' align='center' >".$filtro_titulo. "</th></tr>
                        </table>";
                        echo $html; die();
                        break;
                }                  
            }else{
                echo $html;
                die();
            }    
        } 
    }

    /**
    * @author Nelson Soriano
    * @since  11-02-2019
    * @return retorna los productos relacionados a una cotizacion
    */
    public function get_cot(){
        satelite_validar();
        $cot     = $this->input->post('cot');
        $options = $this->compras_model->return_cot(array('coc_id'=>$cot));
        $option  = '<option value=""></option>';
        foreach ($options as $key => $value) {
            $option .= '<option value="'.$value['id'].'">'.$value['nombre'].'</option>';
        }
        echo json_encode(array('opc' =>$option));
        die();
    }

    /**
    * @author Raul Escalante
    * @since  16-03-2019
    * @return retorna las cotizaciones relacionadas a una requisicion
    */
    public function analisis_cotizacion_compra($flag = null){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if($this->input->post()) {
            //Si es consulta ajax se toman los nombres del Jquery ...xx/xx/1, si no, se toman los filtros de impresión ...xx/xx

            $post_array     = $this->input->post();
            if ($flag) {//si existe flag (...xxx/1)
                $fecha_inicio   = ($post_array['txtFechaIni'] != '')? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
                $fecha_fin      = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;
                $requix         = ($post_array['requix'] > 0) ? $post_array['requix'] : null;
            } else {
                $fecha_inicio   = ($post_array['h_fecha_ini'] != '')? date('Y-m-d', strtotime($post_array['h_fecha_ini'])) : null;
                $fecha_fin      = ($post_array['h_fecha_fin'] != '')? date('Y-m-d', strtotime($post_array['h_fecha_fin'])) : null;
                $requix         = ($post_array['h_requix_id'] > 0) ? $post_array['h_requix_id'] : null;
                $requix_text    = ($post_array['h_requix_text'] != '') ? $post_array['h_requix_text'] : null;
                $data['fecha_inicio_t'] = ($fecha_inicio != '') ? '<b>Fecha inicial: ' . date('d-m-Y', strtotime($fecha_inicio)) . '</b>' : '';
                $data['fecha_fin_t']    = ($fecha_fin != '') ? '<b>Fecha final: ' . date('d-m-Y', strtotime($fecha_fin)) . '</b>' : '';
                $data['requix_t']       = ($requix != '') ? '<b>' . $requix_text . '</b>' : '';                
            }
            
            $tipo_reporte   = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $where          = null;            
            
            if(!(is_null($requix))){
                $where['rxi_id'] = $requix;
            }

            if ($fecha_inicio != '' && $fecha_fin != '') {
                $where['coc_fecha >=']  = date_format(date_create($fecha_inicio),'Y-m-d');
                $where['coc_fecha <=']  = date_format(date_create($fecha_fin),'Y-m-d');
            }

            $info                   = $this->compras_model->get_cotizaciones_req($where);
            $data['rows']           = count($info);
            $data['info']           = $info;
            $filename               = 'Reporte_analisis_cotizaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['tipo_reporte']   = $tipo_reporte;
            $data['titulo']         = 'Análisis de cotización de compra';
            $html                   = $this->load->view('modulo_compras/reportes/analizar_cot_compras', $data, true);

            if ($flag) {
                $data['html'] = $html;
                echo json_encode($data);
                die();
            }/* elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Análisis de cotización de compra';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Analisis_cotizacion_compra_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Analisis_cotizacion_compra', 'Letter');
            }*/ elseif ($tipo_reporte == 'excel') {
                $data['excel']          = 1;
                $data['titulo']         = 'Análisis de cotización de compra';
                $filename               = 'Reporte_analisis_cotizaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename']       = $filename;
                echo $html;
            }
            
        } else {
            $data['requisiciones']      = $this->gsatelite->get_tabla('rxi_requisicion_inventario',"rxi_numero is not null and rxi_estado <> 0");
            $data['permisos']           = $permisos;
            $data['titulo_personal']    = 'Reporte Análisis de Cotización de compra';
            $this->_cargarvista($data);
        }
    }

    /**
        * @author Francisco Orozco
        * @since: 02/05/2019
        * Descripcion: Reporte comparativo de cotizaciones
        * @return HTML, PDF, Excel para reporte
    */
    public function comparativo_cotizaciones(){
        if ($this->input->post()) { 
            $requisicion    = ( is_numeric($this->input->post('slc_requiciones')) && $this->input->post('slc_requiciones') > 0 )?  $this->input->post('slc_requiciones') : null;
            $tipo_reporte   = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
            $where1  = array();
            $where2  = array();
            if ( $requisicion != null ) {
                $where1["dri_id_rxi"] = $requisicion;
                $where2["coc_id_rxi"] = $requisicion;
            }

            $requisiciones          = $this->compras_model->get_detalle_requisicion( $where1 );
            
            $order_by               = "prv_nombre,prv_id";            
            $group_by               = null;
            $destalles_cotizaciones = $this->compras_model->get_detalle_cotizaciones_comparativo( $where2 , $group_by, $order_by);                      
            $group_by               = "prv_nombre,prv_id";   
            $this->db->order_by($group_by);
            $this->db->join('prv_proveedor', 'prv_id = coc_id_prv','left');
            $cotizaciones                   = $this->gsatelite->get_tabla("coc_cotizacion_compra",array( "coc_id_rxi" => $requisicion ) );
            $this->db->order_by("sgm_id","desc");
            $ultimo_comentario              = $this->gsatelite->get_tabla("sgm_seguimiento_comparativo_compra",array( "sgm_id_ccc" => $destalles_cotizaciones[0]["ccc_id"] ) );
            $data["decimales"]              = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data["ultimo_comentario"]      = $ultimo_comentario[0]["sgm_observacion"];
            $data["requisiciones"]          = $requisiciones;
            $data["destalles_cotizaciones"] = $destalles_cotizaciones;
            $data["cotizaciones"]           = $cotizaciones;
            $data["tipo_reporte"]           = $tipo_reporte;
            $filename                       = 'Reporte_comparativo_cotizaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']               = $filename;
            $data['titulo']                 = 'Comparativo de cotizaciones';
            $data['disponible_mensual']     = 0;


            if ( $tipo_reporte == 'excel' && $requisiciones[0]["rxi_id_psp"] && $requisiciones[0]["rxi_id_acg"] && $requisiciones[0]["rxi_id_ace"]) {
                $date    = $requisiciones[0]["rxi_fecha"];
          
                $where = array(
                    'dps_estado'    => 1,
                    'dps_id_psp'    => $requisiciones[0]["rxi_id_psp"],
                    'dps_id_acg'    => $requisiciones[0]["rxi_id_acg"],
                    'dps_id_ace'    => $requisiciones[0]["rxi_id_ace"]
                );
    
                $group_by                   = "ace_id";
                $actividades_generales      = $this->compras_model->get_disponibilidad_mensual($date, $where, $group_by);        
                $data['disponible_mensual'] = $actividades_generales[0]['permitido'] - ($actividades_generales[0]['monto_comprometido_mensual'] + $actividades_generales[0]['monto_pagado_mensual']);
            }

            $html                           = $this->load->view('modulo_compras/reportes/rpt_detalle_comparativo_cotizacion', $data, true);
            
            if ($tipo_reporte == 'excel') {
                $data['excel']          = 1;
                $data['titulo']         = 'Reporte de comparativo de cotizaciones';
                $data['filename']       = $filename;
                echo $html;
            } else {
                $data['html'] = $html;
                echo json_encode($data);
                die();
            }

        } else {          
            $requisiciones          = $this->gsatelite->get_dropdown('rxi_requisicion_inventario', "{rxi_numero}", null, array("DATE(rxi_fecha)" => date('Y-m-d') ), '', '', 'rxi_id', true);
            $requisiciones          = str_replace('<option value="0">Sin Registros</option>', '', $requisiciones);
            $data['requisiciones']  = str_replace('<option value="0">Seleccione</option>', '', $requisiciones);
            $data['titulo_personal']= 'Reporte de comparativo de cotizaciones';
            cargarvista($data);
        }
    }

    /**
        * @author Francisco Orozco
        * @since: 06/05/2019
        * Descripcion: Obtiene las requisiciones mediante un rango de fechas.
        * @return HTML
    */
    public function get_requisiciones(){   
        $desde          = ($this->input->post('txtFechaIni') != '') ? date('Y-m-d', strtotime( $this->input->post('txtFechaIni') )) : date('Y-m-d');
        $hasta          = ($this->input->post('txtFechaFin') != '') ?  date('Y-m-d', strtotime( $this->input->post('txtFechaFin') )) : date('Y-m-d');      
        $requisiciones  = $this->gsatelite->get_dropdown('rxi_requisicion_inventario', "{rxi_numero}", null, array("DATE(rxi_fecha) >=" => $desde , "DATE(rxi_fecha) <=" => $hasta), '', '', 'rxi_id', true);        
        $requisiciones  = str_replace('<option value="0">Sin Registros</option>', '', $requisiciones);
        $requisiciones  = str_replace('<option value="0">Seleccione</option>', '', $requisiciones);
        echo $requisiciones;
        die();
    }

    /**
        * @author Nelson Soriano
        * @since: 22-05-2019
        * Optiene los impuestos de los DPV
        * @return HTML
    **/
    public function impuestos_proveedor(){
        satelite_validar();
        $data['permisos']        = $this->gsatelite->get_permisos_opcion();
        $proveedores             = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers=1,CONCAT_WS(' ', prv_nombre, prv_apellido),prv_apellido)]", array("prv_estado"=> 1), null, '', '', 'prv_id', true);
        $data['proveedores']     = str_replace('<option value="0">Seleccione</option>', '', $proveedores);
        $data['titulo_personal'] = 'Impuestos por proveedor';
        $data['impuesto']        = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('imp_impuesto','imp_nombre','',array('imp_estado' => 1),null,null,'imp_id',true)); 
        
       $fecha = new DateTime();
       $fecha->modify('first day of this month');
       $data['primero']          = $fecha->format('d-m-Y');

       $fecha2 = new DateTime();
       $fecha2->modify('last day of this month');
       $data['ultimo']           = $fecha2->format('d-m-Y');
       cargarvista($data);
    }

    /**
        * @author Nelson Soriano
        * @since: 22-05-2019
        * Optiene los impuestos de los DPV
        * @return HTML/PDF/EXCEL
    **/
    public function generar_reporte_impuestos($es_reporte){
        satelite_validar();
        $desde           = $this->input->post('txtFechaIni');
        $hasta           = $this->input->post('txtFechaFin');
        $prov            = $this->input->post('slcProveedor');
        $imp             = $this->input->post('slcImpuesto');
        $tipo            = ($this->input->post('rpt_tipo') == '')?'grid':$this->input->post('rpt_tipo');
        $filtro_titulo   = '';
        if ($tipo !== '') {
             $data['tipo_reporte'] = $tipo;
        }
        $where           = array();
        if (($desde !== '') && ($hasta !== '')) {
            $where['DATE_FORMAT(dpv_fecha_documento,"%Y-%m-%d") >='] = date_format(date_create($desde),'Y-m-d');
            $where['DATE_FORMAT(dpv_fecha_documento,"%Y-%m-%d") <='] = date_format(date_create($hasta),'Y-m-d');
            $filtro_titulo                .= 'Desde: '.$desde.'<br>Hasta: '.$hasta.'<br>';

        }

        if ($prov !== '') {
            $where['dpv_id_prv'] = $prov;
            $prov_reg            = $this->gsatelite->get_tabla('prv_proveedor',array('prv_id' => $prov));   
            $filtro_titulo      .= ($prov_reg[0]['prv_tipo_pers'] == 1)?'Proveedor: '.$prov_reg[0]['prv_nombre'].' '.$prov_reg[0]['prv_apellido'].'<br>':'Proveedor: '.$prov_reg[0]['prv_apellido'].'<br>';
        }

        if ($imp !== '') {
            $where['idd_id_imp']  = $imp;
            $filtro_titulo       .= $this->gsatelite->get_campo('imp_impuesto','imp_nombre',array('imp_id' => $imp)).'<br>';
        }
        $filtro_titulo           .= '<br>'; 
        //$data['tipo_reporte']     = 'grid';
        $data['decimales']        = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') !== '')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $data['info']             = $this->compras_model->get_impuestos_doc($where); 
        $data['filtro_titulo']    = $filtro_titulo;
        switch ($tipo) {
            case 'excel':
                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename'] = $filename;
                $html             = $this->load->view('modulo_compras/reportes/generar_reporte_impuestos',$data,true);  
                break;
            
            case 'pdf':
                $data['titulo']   = 'Impuestos por proveedor';
                $header = $this->load->view('reporte/header', $data, true);
                $html             = $this->load->view('modulo_compras/reportes/generar_reporte_impuestos',$data,true);  
                $GLOBALS['nombre_reporte'] = 'impuestos' . date('dmY');
                $this->pdf->makePdf($header.$filtro_titulo.$html, 'L', 'impuestos', 'Letter');
                break;
            case 'grid':
                 $html            = $this->load->view('modulo_compras/reportes/generar_reporte_impuestos',$data,true);  
            break;
        }

        echo $html;
    }

    /**
        * @author Nelson Soriano
        * @since: 22-05-2019
        * Optiene los impuestos de los DPV
        * @return HTML
    **/

    public function retenciones_proveedor(){
        satelite_validar();
        $data['permisos']        = $this->gsatelite->get_permisos_opcion();
        $ret = $this->gsatelite->get_dropdown('ret_retencion', 'ret_nombre', '', array('ret_estado' => 1, 'ret_aplica_renta' => 0), null, null, 'ret_id', true);
        $prv = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers=1,CONCAT_WS(' ', prv_nombre, prv_apellido),prv_apellido)]", array("prv_estado"=> 1), null, '', '', 'prv_id', true);
        $data['retenciones'] = str_replace('<option value="0">Seleccione</option>', '', $ret); 
        $data['proveedores'] = str_replace('<option value="0">Seleccione</option>', '', $prv);
        $data['titulo_personal'] = 'Informe Retenciones por proveedor';        
        cargarvista($data);
    }

      /**
        * @author Nelson Soriano
        * @since: 22-05-2019
        * Optiene las retenciones de los DPV
        * @return HTML/Excel/PDF
    **/
    public function generar_reporte_retenciones($es_reporte){
        satelite_validar();
        $desde = $this->input->post('txtFechaIni');
        $hasta = $this->input->post('txtFechaFin');
        $prov  = $this->input->post('slcProveedor');
        $imp   = $this->input->post('slcRet');
        $tipo  = ($this->input->post('rpt_tipo') == '') ? 'grid' : $this->input->post('rpt_tipo');
        $filtro_titulo   = '';
        if ($tipo !== '') {
             $data['tipo_reporte'] = $tipo;
        }
        $where = array();
        if (($desde !== '') && ($hasta !== '')) {
            $where['DATE_FORMAT(dpv_fecha_documento,"%Y-%m-%d") >='] = date_format(date_create($desde),'Y-m-d');
            $where['DATE_FORMAT(dpv_fecha_documento,"%Y-%m-%d") <='] = date_format(date_create($hasta),'Y-m-d');
            $filtro_titulo .= 'Desde: '. $desde .'<br>Hasta: '.$hasta.'<br>';
        }
        if ($prov !== '') {
            $where['dpv_id_prv'] = $prov;
            $prov_reg = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $prov));
            $filtro_titulo .= ($prov_reg[0]['prv_tipo_pers'] == 1) ? 'Proveedor: ' . $prov_reg[0]['prv_nombre'] . ' ' . $prov_reg[0]['prv_apellido'] . '<br>' : 'Proveedor: ' . $prov_reg[0]['prv_apellido'] . '<br>';
        }
        if ($imp !== '') {
            $where['rxd_id_ret'] = $imp;
            $filtro_titulo .= $this->gsatelite->get_campo('ret_retencion', 'ret_nombre', array('ret_id' => $imp)) . '<br>';
        }
        $where['ret_aplica_renta'] = 0;
        $filtro_titulo .= '<br>';
        $data['filtro_titulo'] = $filtro_titulo;        
        $info = $this->compras_model->get_retenciones_doc($where); 
        $tipos_ret = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA'), true);
        $data['info'] = $info;        
        $data['tipos_ret'] = $tipos_ret;
        switch ($tipo) {
            case 'excel':
                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename'] = $filename;
                $html             = $this->load->view('modulo_compras/reportes/generar_reporte_retenciones',$data,true);  
                break;            
            case 'pdf':
                $data['titulo']   = 'Retenciones por proveedor';
                $header = $this->load->view('reporte/header', $data, true);
                $html             = $this->load->view('modulo_compras/reportes/generar_reporte_retenciones',$data,true);  
                $GLOBALS['nombre_reporte'] = 'Retenciones' . date('dmY');
                $this->pdf->makePdf($header.$filtro_titulo.$html, 'L', 'Retenciones', 'Letter');
                break;
            case 'grid':
                 $html = $this->load->view('modulo_compras/reportes/generar_reporte_retenciones',$data,true);  
            break;
            case 'prn':
                $array_lineas = array();
                $ruta_carga = 'public/temp/archivos/';
                $nombre = 'retenciones_proveedor_' . date('d-m-Y') . '.prn';
                foreach ($info as $key => $value) {
                    $linea = "";
                    $proveedor = str_replace(array(',','.'), '', $value['proveedor']);
                    $calidad =  ($value['rxd_id_ret'] == $tipos_ret['ID_PERCEP']) ? 2 : 1;
                    if ($value['rxd_id_ret'] == $tipos_ret['ID_PERCEP']) {
                        $modalidad = 1;
                    } elseif ($value['rxd_id_ret'] == $tipos_ret['ID_RETENC']) {
                        $modalidad = 3;
                    } else {
                        $modalidad = 2;
                    }
                    $monto = number_format(($value['dxd_subtotal'] * 100), 0, '.', '');
                    $reten = number_format(($value['dxd_retencion'] * 100), 0, '.', '');
                    $linea .= str_pad(trim(strtoupper($proveedor)), 40, " ", STR_PAD_RIGHT);
                    $linea .= str_pad(trim(str_replace('-', '', $value['nit_prv'])), 14, "0", STR_PAD_RIGHT);
                    $linea .= str_pad($calidad, 1, "0", STR_PAD_RIGHT);
                    $linea .= str_pad($modalidad, 1, "0", STR_PAD_RIGHT);
                    $linea .= str_pad($value['code_tif'], 1, "0", STR_PAD_RIGHT);
                    $linea .= str_pad($value['numero'], 16, "0", STR_PAD_LEFT);
                    $linea .= str_pad($monto, 15, "0", STR_PAD_LEFT);
                    $linea .= str_pad($reten, 12, "0", STR_PAD_LEFT);
                    $linea .= str_pad($value['periodo'], 6, "0", STR_PAD_RIGHT);
                    if ($linea != ""){
                        $array_lineas[] = $linea;
                    }
                }
                $separador = chr(13).chr(10);
                $lineas = trim(implode($separador,$array_lineas));
                $ruta_completa = $ruta_carga . $nombre;
                if (file_exists("$ruta_completa")) {
                    unlink("$ruta_completa");
                }
                $archivo = fopen($ruta_completa,'w+') or die('No hay permisos de escritura');
                fputs($archivo, $lineas);
                fclose($archivo);
                header( "Content-Type: application/octet-stream");
                header('Content-Disposition: attachment; filename="'.$nombre.'"');
                ob_clean(); 
                flush(); 
                readfile("$ruta_completa");
                die();
            break;
        }
        echo $html;
    }

    public function precios_compras_dpv() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();        
        if($this->input->post()) {
            $post_array   = $this->input->post();
            $fecha_inicio = date('Y-m-d', strtotime($post_array['txtFechaIni']));
            $fecha_fin    = date('Y-m-d', strtotime($post_array['txtFechaFin']));
            $producto     = ($post_array['producto'] != '') ? $post_array['producto'] : null;
            $proveedor    = $post_array['proveedor'];
            $where      = array();
            $where['dpv_fecha_documento <='] = $fecha_fin . ' 23:59:59';
            $where['dpv_fecha_documento >='] = $fecha_inicio . ' 00:00:00';
            if ($producto != '') {
                $where['art_id'] = $producto;
            }
            if ($proveedor != "") {
                $where['prv_id'] = $proveedor;
            }
            $data['detalles'] = $this->compras_model->get_precios_compras_dpv($where);
            $tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Reporte_precios_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Precios de Compra';
            $data['filename']           = $filename;
            $html = $this->load->view('modulo_compras/reportes/consultar_precios_compras_dpv', $data, true);
            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Precios de Compra';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_precios_compra_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->SetTitle('Rpte. Precios de Compra por Docs. de Proveedor');
                $this->pdf->makePdf($reporte, 'L', 'Reporte_precios_compra_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $prvs = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers=1,CONCAT(prv_codigo,' - ',prv_nombre,' ',prv_apellido),CONCAT(prv_codigo,' - ',prv_apellido))]", array("prv_estado"=> 1), null, '', '', 'prv_id', true);
            $data['proveedores'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $prvs);
            $data['titulo_personal']    = 'Reporte de Precios de Compra por Docs. de Proveedor';
            cargarvista($data);
        }
    }

    public function rpt_libro_compras(){
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        $this->load->model('contabilidad_model');
        //Obtenr los parametros            
        $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        $data['id_pais_internas']    = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PAIS_INTERNA'));
        $data['id_pais_importacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PAIS_IMPORTACION'));
        $where2['id_nrc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_NRC'));
        $where2['id_dui'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_DUI'));
        $where2['id_nit'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_NIT'));
        $where2['id_iva']    = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_IVA'));
        $where2['id_percep'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_PERCEP'));
        $where2['id_retenc'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_RETENC'));
        $where2['id_anticipo_cuenta'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_ANTICIPO_CUENTA'));
        $id_tipo_factura = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA', null, null, array('ID_TIPO_FACTURA'));
        if ((!(trim($data['id_pais_internas']) != "")) || (!(trim($data['id_pais_importacion']) != "")) || (!(trim($where2['id_nrc']) != "")) || (!(trim($where2['id_dui']) != "")) || (!(trim($where2['id_nit']) != "")) || (!(trim($where2['id_iva']) != "")) || (!(trim($where2['id_percep']) != "")) || (!(trim($where2['id_retenc']) != "")) || (!(trim($where2['id_anticipo_cuenta']) != "")) || (!(trim($id_tipo_factura) != ""))) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reporte libro de compras", 'texto_alerta' => "Parametro requerido");
            $this->session->set_flashdata($alerta);
            redirect('/modulo_compras/index');
            die();
        }
        $select = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers=1,CONCAT_WS(' ',prv_nombre,prv_apellido),prv_apellido)]",'',array("prv_estado" => 1),null,'','prv_id', true);
        $data["slcProveedor"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', null, '', 'suc_id', true);
        $data["slcSucursal"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $data['titulo_personal'] = "Reporte libro compras";
        $data['tipo_facturacion'] = $tipo_facturacion;
        $data['slcTif'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
        $data['titulo_personal']    = "Reporte libro de compras";
        $this->_cargarvista($data);
    }

    public function retaceo_consolidado($flag = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            if ($flag) {
                $proveedor = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
                $retaceo = ($post_array['retaceo'] != '') ? $post_array['retaceo'] : null;
                $tipo_reporte = '';
            } else {
                //Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                $proveedor_split = ($post_array['filtro_proveedor'] != '') ? explode("#", $post_array['filtro_proveedor']) : null;
                $retaceo_split = ($post_array['filtro_retaceo'] != '') ? explode("#", $post_array['filtro_retaceo']) : null;
                $tipo_reporte = $post_array['tipo_reporte'];
                $proveedor = $proveedor_split[0];
                $retaceo = $retaceo_split[0];
                $data['nombreProveedor'] = $proveedor_split[1];
                $data['numeroRetaceo'] = $retaceo_split[1];
            }
            $where = null;
            $where['rtd_estado'] = 1;
            if ($proveedor) {
                $where2['dpv_id_prv'] = $proveedor;
            }
            if ($retaceo) {
                $where['rtd_id'] = $retaceo;
                $where2['rdv_id_rtd'] = $retaceo;
                $where3['grc_id_rtd'] = $retaceo;
            }
            $data['reporte'] = $this->compras_model->get_detalle_retaceo_cons($where);
            $data['documentos'] = $this->compras_model->get_docs_retaceo_cons($where2);
            $data['gastos'] = $this->compras_model->get_gastos_retaceo_cons($where3);
            $crea_usuario_retaceo = $this->gsatelite->get_tabla('rtd_retaceo_documento_proveedor', array('rtd_id' => $retaceo, 'rtd_estado' => 1));
            $crea_usuario_retaceo = $this->gsatelite->get_tabla('users', array('id' => $crea_usuario_retaceo[0]['rtd_usu_creacion']));
            $data['crea_usuario_retaceo'] = $crea_usuario_retaceo[0]['username'];
            $mostrar_usuario = $this->gsatelite->get_parametro('SYS_MOSTRAR_USUARIO_IMPRESION', null, null, array('reporte_retaceo'));
            $data['mostrar_usuario'] = ($mostrar_usuario > 0) ? $mostrar_usuario : 0;
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_retaceo_cons_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_compras/reportes/reporte_retaceo_consolidado', $data, true);
            // var_dump($html);die();
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Retaceo Consolidado';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Retaceo_Consolidado' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Retaceo', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_retaceo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Retaceo';
                    $data['filename'] = $filename;
                    echo $html;
                    die();
                }
            }                
        } else {
            $proveedores= $this->compras_model->get_proveedor_pers();
            $options='<option value=""></option>';
            foreach ($proveedores as $key) {
                if($key['pro']!=''){
                    $options.='<option value="'.$key['prv_id'].'">'.$key['pro'].'</option>';
                }
            }
            $data['proveedores'] = $options;
            $data['titulo_personal'] = "Reporte de retaceo";
            $this->_cargarvista($data);
        }
    }

    public function rpt_ordenes_compra_pendientes () {
        satelite_validar();
        if($this->input->post()) {
            $post_array   = $this->input->post();
            $fecha_inicio = ($post_array['fecha_inicio'] != '') ? date('Y-m-d', strtotime($post_array['fecha_inicio'])): null;
            $fecha_fin    = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])): null;
            $producto     = ($post_array['producto'] != '') ? $post_array['producto'] : null;
            $proveedor    = ($post_array['proveedor'] != '') ? $post_array['proveedor'] : null;
            //$orden_compra = ($post_array['orden_compra'] != '') ? $post_array['orden_compra']: null;
            $tipo_reporte 	        = $post_array['tipo_reporte'];

            $where      = array();
            if ($fecha_inicio != "") {
                $where['DATE(dor_fecha_creacion) >='] = $fecha_inicio . ' 00:00:00';
            }
            if ($fecha_fin != "") {
                $where['DATE(dor_fecha_creacion) <='] = $fecha_fin . ' 23:59:59';
            }
            if ($producto != '') {
                $where['art_id'] = $producto;
            }
            if ($proveedor != "") {
                $where['prv_id'] = $proveedor;
            }
            /*if ($orden_compra != "") {
                $where['orc_id'] = $orden_compra;
            }*/
            $data['ordenes_compra'] = $this->compras_model->get_detalle_orden_compra($where);
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Reporte_ordenes_compra_pendientes_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Ordenes de Compra Pendientes';
            $data['filename']           = $filename;
            $html = $this->load->view('modulo_compras/reportes/consultar_rpt_ordenes_compra_pendientes', $data, true);
            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
            } 
        } else {
            $prvs = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers=1,CONCAT(prv_codigo,' - ',prv_nombre,' ',prv_apellido),CONCAT(prv_codigo,' - ',prv_apellido))]", array("prv_estado"=> 1), null, '', '', 'prv_id', true);
            $data['proveedores'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $prvs);
            $data['titulo_personal']    = 'Reporte de Ordenes de Compra Pendientes';
            $this->_cargarvista($data);
        }
    }

    public function imprimir_rpt_ordenes_compra_pendientes () {
        satelite_validar();
		$post_array 	        = $this->input->post();
		$fecha_inicio 			= ($post_array['txtFechaIni'] != '' )? $post_array['txtFechaIni'] : null;
		$fecha_fin 				= ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
        $producto               = ($post_array['slcProductos'] != '') ? $post_array['slcProductos'] : null;
        $proveedor              = ($post_array['slcProveedor'] != '') ? $post_array['slcProveedor'] : null;
        //$orden_compra           = ($post_array['orden_compra'] != '') ? $post_array['orden_compra']: null;
		$tipo_reporte 	        = $post_array['tipo_reporte'];

    	$fecha_inicio 	= formatear_fecha('Y-m-d', $fecha_inicio);
    	$fecha_fin  	= formatear_fecha('Y-m-d', $fecha_fin);
    	$where          = array();
        if ($fecha_inicio != "") {
            $where['DATE(dor_fecha_creacion) >='] = $fecha_inicio . ' 00:00:00'; 
        }
        if ($fecha_fin != "") {
            $where['DATE(dor_fecha_creacion) <='] = $fecha_fin . ' 23:59:59';
        }
        if ($producto != '') {
            $where['art_id'] = $producto;
        }
        if ($proveedor != "") {
            $where['prv_id'] = $proveedor;
        }
        /*if ($orden_compra != "") {
            $where['orc_id'] = $orden_compra;
        }*/
        $data['ordenes_compra'] = $this->compras_model->get_detalle_orden_compra($where);

    	$filename                   = 'reporte_ordenes_compra_pendientes_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	$periodo                    = ($fecha_inicio != "") ? "Desde: " . formatear_fecha('d-m-Y', $fecha_inicio) :"";
    	$periodo                    .= ($fecha_fin != "") ? " Hasta: " . formatear_fecha('d-m-Y', $fecha_fin) :"";
    	$data['periodo']            = $periodo;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;

    	if($tipo_reporte == 'excel'){
    		$this->load->view('modulo_compras/reportes/consultar_rpt_ordenes_compra_pendientes', $data);
    	} else{
			$data['titulo']		= 'ordenes de compra pendientes';
    		$data['subtitulo'] 	= $periodo;
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('modulo_compras/reportes/consultar_rpt_ordenes_compra_pendientes', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'L', 'Reporte_ordenes_compra_pendientes_', 'Letter');
    	}
    }

}
