<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('compras_model');
        $this->load->model('inventario_model');
        $this->load->model('utm_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
        $this->load->model('facturacion_model');
        $this->load->library('EnLetras');

    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Modulo de Compras';
            $this->_cargarvista(null, $data);
        }
    }

    public function requisiciones($consulta = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/requisiciones');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;
                    $estado_requicision = $post_array['estado'];
                    $fecha_inicio       = $post_array['fecha_ini'];
                    $fecha_fin          = $post_array['fecha_fin'];
                    $slc_sucursal       = $post_array['slc_sucursal'];
                    $where = null;
                    if ($estado_requicision != '') {
                        $where['rxi_estado'] = $estado_requicision;
                    }
                    if ($slc_sucursal != '') {
                        $where["rxi_id_usu_solicita IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                    }
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['DATE_FORMAT(rxi_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['DATE_FORMAT(rxi_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                    }
                    $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
                    $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                    $permiso_rol = false;
                    foreach ($mis_roles as $rol) {
                        if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                            $permiso_rol = true;
                        }
                    }
                    if ( $permiso_rol == false) {
                        $where['rxi_usu_creacion']  = $this->tank_auth->get_user_id();
                        $where['rxi_id_usu_solicita']   = $this->tank_auth->get_user_id();
                    }
                    $where['id']                    = $this->tank_auth->get_user_id();
                    $where['sgr_fecha_salida']      = null;

                    $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                    $flujos_array = json_decode($flujos, true);

                    $where['flu_id']        = $flujos_array['REQ_COMP'];
                    $requisiciones          = $this->compras_model->get_backlog_requisiciones($where);
                    $data['requisiciones']  = $requisiciones;
                    $html = $this->load->view('modulo_compras/procesos/consultar_requisiciones', $data, true);

                    echo $html;
                    die();
                }
            } else {
                $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$this->tank_auth->get_user_id()));
                $sucursal_dropdown = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', $empleado[0]['emp_id_suc'], '', 'suc_id', true);
                $data['sucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $sucursal_dropdown);
                $data['titulo_personal']= 'Listado de Requisiciones';
                $this->_cargarvista($data);
            }
        }
    }


    //EN DESARROLLO
    /*
    public function mis_requisiciones($consulta = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/requisiciones');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;
                    $estado_requicision = $post_array['estado'];
                    $fecha_inicio       = $post_array['fecha_ini'];
                    $fecha_fin          = $post_array['fecha_fin'];
                    $slc_sucursal       = $post_array['slc_sucursal'];

                    $where = null;

                    if ($estado_requicision != '') {
                        $where['rxi_estado'] = $estado_requicision;
                    }

                    if ($slc_sucursal != '') {
                        $where["rxi_id_usu_solicita IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                    }

                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['DATE_FORMAT(rxi_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['DATE_FORMAT(rxi_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                    }

                    $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
                    $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                    $permiso_rol = false;

                    foreach ($mis_roles as $rol) {
                        if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                            $permiso_rol = true;
                        }
                    }
                    $where['rxi_usu_creacion']  = $this->tank_auth->get_user_id();                    
                    $where['rxi_id_usu_solicita']   = $this->tank_auth->get_user_id();
                    $where['id']                    = $this->tank_auth->get_user_id();
                    $where['sgr_fecha_salida']      = null;

                    $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                    $flujos_array = json_decode($flujos, true);

                    $where['flu_id']        = $flujos_array['REQ_COMP'];
                    $requisiciones          = $this->compras_model->get_backlog_requisiciones($where);
                    $data['requisiciones']  = $requisiciones;
                    $html = $this->load->view('modulo_compras/procesos/consultar_requisiciones', $data, true);

                    echo $html;
                    die();
                }
            } else {
                $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$this->tank_auth->get_user_id()));
                $sucursal_dropdown = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', $empleado[0]['emp_id_suc'], '', 'suc_id', true);
                $data['sucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $sucursal_dropdown);
                $data['titulo_personal']= 'Listado de Requisiciones';
                $this->_cargarvista($data);
            }
        }
    }
    */

    function agregar_requisicion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $flujos         = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array   = json_decode($flujos, true);

            $this->db->where('rxi_id_flu', $flujos_array['REQ_COMP']);
            $num_actual     = $this->inventario_model->num_max_requi();
            $codigo         = $num_actual[0]['maximo'] + 1;

            $data['num_requisicion']    = generar_codigo_cor($codigo, 5);
            $data['usuarios']           = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());            
            $data['bodegas']            = $this->inventario_model->get_bodegas_usuario();
            $data['prioridades']        = $this->gsatelite->get_dropdown('prd_prioridad', 'prd_nombre', 'prioridades', array('prd_estado' => 1), null, null, null, true);

            /* ************************************************** */
            /* Obtener los permisos para autorizar la requisicion */
            /* ************************************************** */
            $groupby = null;
            $orderby = null;
            $where   = null;

            // agrupador
            $groupby            = 'rol_id';
            $where              = array('psf_orden'=>2, 'psf_id_flu'=>3, 'axr_id_acc'=>4, 'id'=>$this->tank_auth->get_user_id());
            $data['autorizar']  = $this->inventario_model->get_permisos_autorizar_requisicion($where, $groupby, $orderby);
            $data['parametro']  = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_COMPRA'));
            $proyectos_reg      = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
            $select_proyecto    = '<option value=""></option>';

            foreach ($proyectos_reg as $key) {
                $nombre_cliente      = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
                $nombre              = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'] ;
                $select_proyecto    .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'">'.$nombre.'</option>';
            }
            $data['proyectos']       = $select_proyecto;

            $sucursal_drop           = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, '', 'suc_id', true);
            $data['sucursales']      = str_replace('<option value="0">Seleccione</option>', '', $sucursal_drop);
                                       $this->db->join('are_area','are_id=emp_id_are','left');
            $empleado_drop           = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido} Area: {are_nombre}', '', null, null, '', 'emp_id', true);
            $data['empleados']       = str_replace('<option value="0">Seleccione</option>', '', $empleado_drop);

            $data['titulo_personal'] = 'Crear requisiciones de compras';
            $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
            $this->_cargarvista($data);
        }
    }

    function registrar_requisicion() {
        if ($_POST) {
            //Si se ha enviado valores de solicitud
            $post_array             = $_POST;
            $id_detalle             = 0;
            $usuario                = $this->tank_auth->get_user_id();
            $tipoRequisicion        = $post_array['slcTipo'];
            $txtCliente             = ($post_array['txtNombreCliente'] != '') ? $post_array['txtNombreCliente'] : null;
            $slcPrioridad           = ($post_array['slcPrioridad'] != '') ? $post_array['slcPrioridad'] : null;
            $slc_presupuesto        = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $slc_actividad_general  = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $slc_act_especifica     = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
            $fecha                  = $post_array['fecha'];
            $txtDescripcion         = $post_array['txtDescripcion'];
            $txtEntrega             = $post_array['txtEntrega'];
            $txtJustificacion       = $post_array['txtJustificacion'];
            $empleadosxbodega       = $this->db->join('users','id=uxb_id_usu')->where('uxb_id_bod', $slcBodega)->get('uxb_usuarioxbodega')->result_array();

            $rxi_id_suc_solicita    = ($post_array['slc_suc_solicita'] != '') ? $post_array['slc_suc_solicita'] : null;
            $rxi_id_emp_solicita    = ($post_array['slc_emp_id_solicita'] != '') ? $post_array['slc_emp_id_solicita'] : null;

            //Array con datos de los anexos
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];

            $flujos                 = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array           = json_decode($flujos, true);
            $flujoRequisicionesComp = $flujos_array['REQ_COMP'];            

            $this->db->where('rxi_id_flu', $flujoRequisicionesComp);
            $num_actual = $this->inventario_model->num_max_requi();

            $codigo = $num_actual[0]['maximo'] + 1;
            $slcProyecto = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;

            $cod_requisicion = generar_codigo_cor($codigo, 5);

            $ingresar_requisicion = array(
                'rxi_numero'                => date('Y').'-'.$cod_requisicion,
                //'rxi_id_bod'              => $slcBodega,
                'rxi_id_prd'                => $slcPrioridad,
                'rxi_id_usu_solicita'       => $usuario,
                'rxi_id_flu'                => $flujoRequisicionesComp,
                'rxi_id_pcl'                => $slcProyecto,
                'rxi_id_suc_solicita'       => $rxi_id_suc_solicita,
                'rxi_id_emp_solicita'       => $rxi_id_emp_solicita,
                'rxi_fecha'                 => date('Y-m-d', strtotime($fecha)),
                'rxi_cliente'               => $txtCliente,
                'rxi_descripcion'           => $txtDescripcion,
                'rxi_estado'                => 1,
                'rxi_tipo'                  => $tipoRequisicion,
                'rxi_descripcion_entrega'   => $txtEntrega,
                'rxi_justificacion'         => $txtJustificacion, 
                'rxi_usu_creacion'          => $this->tank_auth->get_user_id(),
                'rxi_fecha_creacion'        => date('Y-m-d h:i:s'),
                'rxi_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion'    => date('Y-m-d h:i:s'),
                'rxi_id_psp'                => $slc_presupuesto,
                'rxi_id_ace'                => $slc_act_especifica,
                'rxi_id_acg'                => $slc_actividad_general
            );
            $id_req = $this->gsatelite->ingresar('rxi_requisicion_inventario', $ingresar_requisicion);
            $productos = $post_array['productos'];
            $cantidades = $post_array['cantidad'];
            $conversiones = $post_array['conversion'];
            $art_descrip  = $post_array['dato_prod_desc'];


            if ($id_req > 0) {
                $primer_paso = $this->inventario_model->get_primer_paso_flujo($flujoRequisicionesComp);
                if (count($primer_paso) > 0) {
                    $seguimiento_requisicion = array(
                        'sgr_id_rxi' => $id_req,
                        'sgr_id_psf' => $primer_paso[0]['psf_id'],
                        'sgr_id_usu' => $usuario,
                        'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgr_estado' => 1,
                        'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                    );

                    $id_detalle = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                }

                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {
                        $id_cant = $cantidades[$key];
                        $art_id = null;
                        $cva_id = null;
                        $act_id = null;
                        $dri_id = null;
                        $sri_id = null;

                        switch ($tipoRequisicion) {
                            case 1:
                            $art_id = $productos[$i];
                            $cva_id = $conversiones[$i];
                            break;
                            case 2:
                            $art_id = $productos[$i];
                            break;
                            case 3:
                            $act_id = $productos[$i];
                            break;
                            case 4:
                            $art_id = $productos[$i];
                            $cva_id = ($conversiones[$i]!='null') ? $conversiones[$i] : null;
                            break;
                        }

                        $detalle_req = array(
                            'dri_id_rxi' => $id_req,
                            'dri_id_art' => $art_id,
                            'dri_id_cva' => $cva_id,
                            'dri_id_act' => $act_id,
                            //'dri_id_sri' => $sri_id,
                            'dri_descripcion' => $art_descrip[$i],
                            'dri_cantidad' => convertirFloat($cantidades[$i]),
                            'dri_estado' => 1,
                            'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_creacion' => date('Y-m-d H:i:s')
                        );

                        $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
                    }
                }

                //Si vienen anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {

                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anx_requisicion/" . $nombreArchivo;

                        $documentos_array = array(
                            'aqi_id_rxi'             => $id_req,
                            'aqi_url'                => $carpeta_destino_anx,
                            'aqi_nombre'             => $nombreArchivo,
                            'aqi_estado'             => 1,
                            'aqi_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'aqi_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'aqi_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'aqi_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $aqi_id = $this->gsatelite->ingresar('aqi_anexo_requisicion_inventario', $documentos_array);

                        if ($aqi_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }

                //************* Autorizar requisición *******************************************/
                /* if ($this->gsatelite->get_parametro('INV_AUTORIZAR_REQUISION') == 1) {
                  $this->db->where('rxi_id', $id_req);
                  $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2, 'rxi_usu_mod' => $this->tank_auth->get_user_id(), 'rxi_fecha_mod' => date('Y-m-d H:i:s')));
                  $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos autorizada", 'texto_alerta' => "Ahora usted podrá ver la requisición en la pantalla de salida de artículos");
                  } else {

                  } */
                //*******************************************************************************/
                  $btnAutorizar = $post_array['btnCrear'];
                $tipo_flujo = 1; // tipo flujo: 1- Requisiciones
                $flujo      = 3; // Flujo: 3 - Requisicion de Compra
                $autorizar = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_COMPRA'));
                if (isset($autorizar) && $autorizar > 0 && $btnAutorizar === '3' && $id_req > 0) {
                    $this->autorizar_requisicion_compras_automatica($id_req, $tipo_flujo, $flujo);
                }

                if ($id_detalle > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de artículos", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            

            /* foreach ($empleadosxbodega as $key => $value) {
                $this->send_email($value['email']);
            } */
            $tipo_btn = $post_array['btnCrear'];
            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('/modulo_compras/procesos/agregar_requisicion');
            } else {
                redirect('modulo_compras/procesos/requisiciones');
            }
        }
    }

    function editar_requisicion($id_req = NULL, $tipo_flujo = null, $grid_principal = null) {
        satelite_validar();
        if ($_POST) {
            //Si se ha enviado valores de solicitud
            $post_array             = $_POST;
            $id_detalle             = 0;
            $usuario                = $this->tank_auth->get_user_id();
            $tipoRequisicion        = $post_array['slcTipo'];
            $txtJustificacion       = $post_array['txtJustificacion'];
            $txtNombreCliente       = ($post_array['txtNombreCliente'] != '') ? $post_array['txtNombreCliente'] : null;
            $slcPrioridad           = ($post_array['slcPrioridad'] != '') ? $post_array['slcPrioridad'] : null;
            $slcBodega              = $post_array['slcBodega'];
            $fecha                  = $post_array['fecha'];
            $slc_presupuesto        = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $slc_actividad_general  = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $slc_act_especifica     = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;

            $empleadosxbodega       = $this->db->join('users', 'id=uxb_id_usu')->where('uxb_id_bod', $slcBodega)->get('uxb_usuarioxbodega')->result_array();
            $txtDescripcion         = $post_array['txtDescripcion'];
            $txtEntrega             = $post_array['txtEntrega'];
            $slcProyecto            = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            
            $rxi_id_suc_solicita    = ($post_array['slc_suc_solicita'] != '') ? $post_array['slc_suc_solicita'] : null;
            $rxi_id_emp_solicita    = ($post_array['slc_emp_id_solicita'] != '') ? $post_array['slc_emp_id_solicita'] : null;

            $requisicion_array = array(
                'rxi_id_prd'                => $slcPrioridad,
                'rxi_id_pcl'                => $slcProyecto,
                'rxi_fecha'                 => date('Y-m-d', strtotime($fecha)),
                'rxi_cliente'               => $txtNombreCliente,
                'rxi_descripcion'           => $txtDescripcion,
                'rxi_justificacion'         => $txtJustificacion,   //Agregado 29/mar/19
                'rxi_descripcion_entrega'   => $txtEntrega,
                'rxi_id_suc_solicita'       => $rxi_id_suc_solicita,
                'rxi_id_emp_solicita'       => $rxi_id_emp_solicita,
                'rxi_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion'    => date('Y-m-d h:i:s'),
                'rxi_id_psp'                => $slc_presupuesto,
                'rxi_id_ace'                => $slc_act_especifica,
                'rxi_id_acg'                => $slc_actividad_general
            );
            $resultado = $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $requisicion_array, array('rxi_id' => $id_req));

            $productosIds = $post_array['hdnDetalle'];
            $productos    = $post_array['productos'];
            $cantidades   = $post_array['cantidad'];
            $conversiones = $post_array['conversion'];
            $catidad_edit = $post_array['cantidad_edit'];
            $art_descrip  = $post_array['dato_prod_desc'];
            $art_descrip_edit  = $post_array['dato_prod_desc_edit']; //recibe el array de descripcion editado
            //Anexos   
            $AnexoPrv = $post_array['AnexoPrv'];
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];

            if ($resultado > 0) {
                //Se verifica si se eliminaron productos.
                $where = array('dri_id_rxi' => $id_req);
                $dataDetalle = $this->inventario_model->get_requisicion_detalle($where);
                if (!is_array($productosIds)) {
                    $productosIds = array();
                }
                /* ****************** ACTUALIZAR CANTIDADES ************************* */
                if (count($productosIds) > 0) {
                    foreach ($productosIds as $key => $valor) {
                        $detalle_act = array(
                            'dri_cantidad' => $catidad_edit[$key],
                            'dri_estado' => 1,
                            'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dri_descripcion' => $art_descrip_edit[$key] //toma el valor de la descripcion para actualizarla en la base
                        );
                        $id_detalle = $this->gsatelite->actualizar_array('dri_detalle_requisicion_inventario', $detalle_act, array('dri_id' => $valor));
                    }
                }

                /* **************** ELIMINAR DETALLES ******************************* */
                foreach ($dataDetalle as $data) {
                    if (!in_array($data['dri_id'], $productosIds)) {
                        $this->gsatelite->borrado_general('dri_detalle_requisicion_inventario', array('dri_id' => $data['dri_id']));
                    }
                }

                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {
                        $id_cant = $cantidades[$key];
                        $art_id = null;
                        $cva_id = null;
                        $act_id = null;
                        $dri_id = null;
                        $sri_id = null;

                        switch ($tipoRequisicion) {
                            case 1:
                            $art_id = $productos[$i];
                            $cva_id = $conversiones[$i];
                            break;
                            case 2:
                            $art_id = $productos[$i];
                            break;
                            case 3:
                            $act_id = $productos[$i];
                            break;
                            case 4:
                            $art_id = $productos[$i];  
                            $cva_id = ($conversiones[$i]!='null') ? $conversiones[$i] : null;
                            break;
                        }

                        $detalle_req = array(
                            'dri_id_rxi'      => $id_req,
                            'dri_id_art'      => $art_id,
                            'dri_id_cva'      => $cva_id,
                            'dri_id_act'      => $act_id,
                            'dri_descripcion' => $art_descrip[$i],
                            'dri_cantidad'    => convertirFloat($cantidades[$i]),
                            'dri_estado'      => 1,
                            'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_creacion' => date('Y-m-d H:i:s')
                        );
                        $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
                    }
                }

                //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                $dataAnexos = $this->gsatelite->get_tabla('aqi_anexo_requisicion_inventario', array('aqi_id_rxi' => $id_req));
                if (!is_array($AnexoPrv)) {
                    $AnexoPrv = array();                
                }
                foreach ($dataAnexos as $data) {
                    if (!in_array($data['aqi_id'], $AnexoPrv)) {
                        $this->gsatelite->borrado_general('aqi_anexo_requisicion_inventario', array('aqi_id' => $data['aqi_id']));
                        $ruta_nxp = $data['aqi_url'];
                        unlink($ruta_nxp);
                    }
                }

                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_requisicion/" . $nombreArchivo;

                        $documentos_array = array(
                            'aqi_id_rxi'             => $id_req,
                            'aqi_url'                => $carpeta_destino_anx,
                            'aqi_nombre'             => $nombreArchivo,
                            'aqi_estado'             => 1,
                            'aqi_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'aqi_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'aqi_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'aqi_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $aqi_id = $this->gsatelite->ingresar('aqi_anexo_requisicion_inventario', $documentos_array);

                        if ($aqi_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }

                //************* Autorizar requisición *******************************************/
                /* if ($this->gsatelite->get_parametro('INV_AUTORIZAR_REQUISION') == 1) {
                  $this->db->where('rxi_id', $id_req);
                  $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2, 'rxi_usu_mod' => $this->tank_auth->get_user_id(), 'rxi_fecha_mod' => date('Y-m-d H:i:s')));
                  $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos autorizada", 'texto_alerta' => "Ahora usted podrá ver la requisición en la pantalla de salida de artículos");
                  } else {

                  } */
                //*******************************************************************************/
                  $btnAutorizar = $post_array['btnGuardar'];
                $tipo_flujo = 1; // tipo flujo: 1- Requisiciones
                $flujo      = 3; // Flujo: 3 - Requisicion de Compra
                $autorizar = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_COMPRA'));
                if (isset($autorizar) && $autorizar > 0 && $btnAutorizar === '3' && $id_req > 0) {
                    $this->autorizar_requisicion_compras_automatica($id_req, $tipo_flujo, $flujo);
                }
                //*******************************************************************************/
                if ($resultado > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de artículos", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);
            $tipo_btn = $post_array['btnGuardar'];

            //Si no viene desde la grid principal se envia a tareas pendientes.
            if ($grid_principal == null) {
                if ($tipo_btn == 1) {
                    redirect('/modulo_compras/procesos/editar_requisicion/' . $id_req . '/' . $tipo_flujo);
                } else {
                    redirect('/modulo_compras/inicio/tareas_pendientes');
                }
            } else {
                if ($tipo_btn == 1) {
                    redirect('/modulo_compras/procesos/editar_requisicion/' . $id_req . '/' . $tipo_flujo . '/' . $grid_principal);
                } else {
                    redirect('/modulo_compras/procesos/requisiciones');
                }
            }
        } else {
            $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $id_req));
            $data['requisicion'] = $requisicion[0];
            if ($requisicion[0]['rxi_id_ord'] != "") {
                $this->load->model('proyecto_model');
                $data_orden = $this->proyecto_model->get_orden(array('ord_id' => $requisicion[0]['rxi_id_ord']));
                if (count($data_orden) > 0) {
                    $articulos = array();
                    $data["orden_prod"] = $data_orden[0]['ord_codigo'];
                    foreach ($data_orden as $key => $value) {
                        array_push($articulos, ($value['art_codigo'] . ' - ' . $value['art_nombre']));
                    }
                    $data["art_orden"] = implode(',', $articulos);
                }
            }
            $where = array('dri_id_rxi' => $id_req);
            $data['tipo_flujo']         = $tipo_flujo;
            $data['grid_principal']     = $grid_principal;
            $data['detalle_requisicion']= $this->inventario_model->get_requisicion_detalle($where);
            $data['usuarios']           = $this->inventario_model->informacion_empleado($requisicion[0]['rxi_id_usu_solicita']);
            $data['bodegas']            = $this->inventario_model->get_bodegas_usuario();
            $data['prioridades']        = $this->gsatelite->get_dropdown('prd_prioridad', 'prd_nombre', 'prioridades', array('prd_estado' => 1), $requisicion[0]['rxi_id_prd'], null, null, true);
            $slc_presupuesto            = ($requisicion[0]['rxi_id_psp'] != "" )?$this->get_presupuestoxproyecto($requisicion[0]['rxi_id_pcl'], $requisicion[0]['rxi_id_psp']):'<option value=""></option>';
            $data['presupuesto']        = $slc_presupuesto;
            $slc_general                = ($requisicion[0]['rxi_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($requisicion[0]['rxi_id_psp'], $requisicion[0]['rxi_id_acg']):'<option value=""></option>';
            $data['general']            = $slc_general;
            $slc_especifica             = ($requisicion[0]['rxi_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($requisicion[0]['rxi_id_acg'], $requisicion[0]['rxi_id_psp'], $requisicion[0]['rxi_id_ace']):'<option value=""></option>';
            $data['especifica']         = $slc_especifica;
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $proyectos_reg              = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
            $select_proyecto            = '<option value=""></option>';
            foreach ($proyectos_reg as $key) {
                $selected = ($requisicion[0]['rxi_id_pcl'] == $key['pcl_id'])?'selected':'';
                $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
                $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
            }
            $data['proyectos'] = $select_proyecto;
            $sucursal_drop     = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, $requisicion[0]['rxi_id_suc_solicita'], '', 'suc_id', true);
            $data['sucursales']= str_replace('<option value="0">Seleccione</option>', '', $sucursal_drop);
            $empleado_drop     = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), $requisicion[0]['rxi_id_emp_solicita'], '', 'emp_id', true);
            $data['empleados'] = str_replace('<option value="0">Seleccione</option>', '', $empleado_drop);
            $data['anexos_requisicion'] = $this->gsatelite->get_tabla('aqi_anexo_requisicion_inventario', array('aqi_id_rxi' => $id_req));
            /* ************************************************** */
            /* Obtener los permisos para autorizar la requisicion */
            /* ************************************************** */
            $groupby = null;
            $orderby = null;
            $where   = null;
            // agrupador
            $groupby                = 'rol_id';
            $where                  = array('psf_orden'=>2, 'psf_id_flu'=>3, 'axr_id_acc'=>4, 'id'=>$this->tank_auth->get_user_id());
            $data['autorizar']      = $this->inventario_model->get_permisos_autorizar_requisicion($where, $groupby, $orderby);
            $data['parametro']      = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_COMPRA'));
            $data['titulo_personal']= 'Editar requisiciones de compras';
            $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
            $this->_cargarvista(null, $data);
        }
    }

    public function send_email($email) {
        $ci = get_instance();
        $ci->load->library('email');
        $config['protocol'] = "smtp";
        $config['smtp_host'] = "ssl://mail.gruposatelite.net";
        $config['smtp_port'] = "465";
        $config['smtp_user'] = $this->gsatelite->get_parametro('CORREO_ADMIN');
        $config['smtp_pass'] = "Nuevo1010";
        $config['charset'] = "utf-8";
        $config['mailtype'] = "html";
        $config['newline'] = "\r\n";

        $ci->email->initialize($config);

        $ci->email->from($this->gsatelite->get_parametro('CORREO_ADMIN'), $this->gsatelite->get_parametro('CORREO_ADMIN'));
        $list = array($email);
        $ci->email->to($list);
        $this->email->reply_to($this->gsatelite->get_parametro('CORREO_ADMIN'), '');
        $ci->email->subject('Requisición recibida');
        $ci->email->message('Estimado usuario usted tiene una requisición pendiente de despacho.');
        $ci->email->send();
    }

    /*
     * tipo categoria: 1- Articulos, 2- Servicios, 3 - Activo Fijo
     */

    public function get_categorias_productos($tipo_categoria = null) {

        $tipo = ($tipo_categoria != null) ? $tipo_categoria : $this->input->post('tipo');
        $categorias = '<option value="0">Seleccione una opción</option>';
        $productos = '<option value="0">Seleccione una opción</option>';
        switch ($tipo) {
            case 1:
            $categorias_prod = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => null, 'tia_estado' => 1));
            foreach ($categorias_prod as $key) {
                $categorias .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
            }
            break;
            case 2:
            $this->db->join('art_articulo', 'art_id_tia = tia_id');
            $this->db->group_by('tia_id');
            $categorias_prod = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => null, 'art_tipo' => 1, 'tia_estado' => 1));
            foreach ($categorias_prod as $key) {
                $categorias .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
            }
            break;
            case 3:
            $tipos_activos = $this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_estado' => 1));
            foreach ($tipos_activos as $key) {
                $categorias .= "<option value='" . $key['tac_id'] . "'>" . $key['tac_nombre'] . "</option>";
            }
            break;
            case 4:
            $this->db->join('art_articulo', 'art_id_tia = tia_id');
            $this->db->group_by('tia_id');
            $categorias_prod = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => null, 'tia_estado' => 1));
                //print_r($this->db->last_query());die();
            foreach ($categorias_prod as $key) {
                $categorias .= "<option value='" . $key['tia_id'] . "' data-tipo = '".$key['art_tipo']."'>" . $key['tia_nombre'] . "</option>";
            }
            break;
        }
        $arreglo = array(
            "categoria" => $categorias,
            "producto" => $productos
        );
        echo json_encode($arreglo);
    }

    public function get_dependencias_categoria() {
        $padre = $this->input->post('padre');
        $servicio = $this->input->post('servicio');
        $proveedor = ($this->input->post('proveedor') != '') ? $this->input->post('proveedor') : 0;
        $hijos = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => $padre, 'tia_estado' => 1));
        $cadena = "<option value='0' selected>Seleccione una opción</option>";
        $var = "<option value='0' selected>Seleccione una opción</option>";
        foreach ($hijos as $key => $value) {
            $cadena .= '<option value="' . $value['tia_id'] . '">' . $value['tia_nombre'] . '</option>';
        }
        $where_art = array('art_compra' => 1, 'art_estado' => 1);
        $articulos = $this->inventario_model->get_articulosxcategoria($padre, $servicio, $where_art);
        // print_r($this->db->last_query());die();
        $etiqueta = 0;  
        $extra = '';
        foreach ($articulos as $fila) {
            $extra = ($fila['cdp_codigo']!='') ? $fila['cdp_codigo'] : '';
            if ($fila['art_sinonimo']!='') {
                $extra = ($extra!='') ? $extra.'/ '.$fila['art_sinonimo'] : $fila['art_sinonimo'];
            }
            $extra = ($extra!='') ? ' ('.$extra.')' : '';
            $var .= "<option data-codigo='" . $fila['art_codigo'] . "' data-nombre='" . $fila['art_nombre'] . "' precio='" . $fila['sar_precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' data-tipo='".$fila['art_tipo']."'>" ;
            $var .= $fila['art_codigo'].' - '. $fila['art_nombre'].$extra;
            $var.= "</option>";
            $etiqueta++;
        }
        //Se obtienen los impuestos del tipo
        $this->db->join("ixr_impuestox_tipo_articulo", "ixr_id_imp = imp_id AND ixr_estado = 1", 'left');
        $impuestos_categoria = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado'=>1, 'ixr_id_tia'=>$padre, 'IFNULL(imp_proceso_aplica,0) <>' => 1));        
        /**** Impuestos aplicables del proveedor ****/
        $this->db->join("ixp_impuestoxproveedor", "ixp_id_imp = imp_id AND ixp_estado = 1", 'left');
        $impuestos_proveedor = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado'=>1, "ixp_id_prv"=>$proveedor, 'IFNULL(imp_proceso_aplica,0) <>' => 1));
        /**** Impuestos Globales restantes *****/
        $impuestos_ = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado'=>1, 'IFNULL(imp_proceso_aplica,0) <>' => 1));
        // /* Unir los impuestos de Proveedor y Categoria de producto y luego filtrar para obtener los seleccionados*/
        /*******************************************************************************************************************/
        $impuestos_merge = array_merge($impuestos_categoria, $impuestos_proveedor);
        $tempArr         = array_unique(array_column($impuestos_merge, 'imp_id'));
        $impuestos_array = array_intersect_key($impuestos_merge, $tempArr);
        /********************`***********************************************************************************************/
        /* Agregar los impuestos restantes                                                                                 */
        /*******************************************************************************************************************/
        $imp_temp        = array_merge($impuestos_array, $impuestos_);
        $imp_temp_       = array_unique(array_column($imp_temp, 'imp_id'));
        $impuestos_array = array_intersect_key($imp_temp, $imp_temp_);
        /*******************************************************************************************************************/

        $impuestos = "";
        if(count($impuestos_array) > 0){
            foreach ($impuestos_array as $key => $value) {
                $temp = (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]);
                if($temp != ''){
                    if ((isset($value['ixr_id']) && $value['ixr_id']>0) || (isset($value['ixp_id']) && $value['ixp_id']>0)) {
                        $impuestos .= '<option data-id="' . $value['ixr_id'] . '" data-porcentaje="' . (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]) . '" data-type="'.(((float)$value["imp_porcentaje"] != 0)?1:0).'" value="' . $value['imp_id'] . '" selected>' . $value['imp_nombre'] . '</option>';
                    } else {
                        $impuestos .= '<option data-id="" data-porcentaje="' . (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]) . '" data-type="'.(((float)$value["imp_porcentaje"] != 0)?1:0).'" value="' . $value['imp_id'] . '" >' . $value['imp_nombre'] . '</option>';
                    }
                }
            }
        }
        


        if (count($hijos) == 0) {
            $cadena = "";
        }
        if (count($articulos) == 0) {
            $var = "";
        }
        if (count($impuestos_categoria) == 0) {
            $impuestos = "";
        }

        $arreglo = array('drop' => $cadena, 'producto' => $var, 'padre' => $padre, 'impuestos' => $impuestos);
        echo json_encode($arreglo);
    }

    public function get_conversiones_articulo($idProc = null, $flag = false) {

        $producto = ($idProc > 0) ? $idProc : $this->input->post('producto');

        $where = array('cva_id_art' => $producto);

        $conversiones = $this->inventario_model->get_conversiones_producto($where);
        $var = "<option>Seleccione</option>";
        $etiqueta = 0;
        foreach ($conversiones as $fila) {

            $selected = "";

            if ($fila['cva_defecto'] == 1) {
                $selected = "selected=selected";
            }

            $var .= "<option data-conv='" . $fila['cva_conversion'] . "' " . $selected . " value='" . $fila['cva_id'] . "' id='opt_conv" . $etiqueta . "'>" . $fila['mep_nombre'] . "</option>";
            $etiqueta++;
        }

        $arreglo = array('medidas' => $var);
        echo json_encode($arreglo);
    }

    /*
     * @author: Mario Marquez
     * $idProc: Id del producto a solicitar
     * @detalle: Se obtiene toda la informacion en general del producto (Inpuestos, Cuentas, Caracteristicas, Etc)
     */

    public function get_detalles_producto($idProc = null, $flag = false) {
        $producto = ($idProc > 0) ? $idProc : $this->input->post('producto');
        $where = array('cva_id_art' => $producto, 'cva_estado'=>1);

        //Se obtienen las medidas del producto
        $conversiones = $this->inventario_model->get_conversiones_producto($where);
        $conversiones2 = $this->inventario_model->get_conversiones_producto(array('cva_id_art'=>$producto,'cva_defecto'=>1));
        $var = "<option></option>";
        $etiqueta = 0;
        foreach ($conversiones as $fila) {
            $selected = "";
            if ($fila['cva_defecto'] == 1) {
                $selected = "selected=selected";
            }
            $var .= "<option data-conv='" . $fila['cva_conversion'] . "' " . $selected . " value='" . $fila['cva_id'] . "' id='opt_conv" . $etiqueta . "' data-defecto='".$conversiones2[0]['cva_conversion']."'>" . $fila['mep_nombre'] . "</option>";
            $etiqueta++;
        }

        //Se obtienen los impuestos del articulo
        $where_imp = array('ixa_id_art' => $producto, 'IFNULL(imp_proceso_aplica,0) <>' => 1);
        $impuestos_array = $this->inventario_model->get_impuestos_producto($where_imp);
        $etiqueta = 0;
        $impuestos = '';
        if (count($impuestos_array) > 0) {
            foreach ($impuestos_array as $imp) {
                $impuestos .= "<option data-ixa='" . $imp['ixa_id'] . "' data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "' id='opt_ixa" . $etiqueta . "'>" . $imp['imp_nombre'] . "</option>";
                $etiqueta++;
            }
        }

        //Se obtiene la bodega asignada al procutdo
        $bodegaProducto = $this->gsatelite->get_campo('art_articulo', 'art_id_bod', array('art_id' => $producto));
        $sectorProducto = $this->gsatelite->get_campo('art_articulo', 'art_id_sxb', array('art_id' => $producto));
        //Se obtienen las bodegas activas
        $bodegas = $this->gsatelite->get_tabla('bod_bodega', array('bod_estado' => 1));
        $bodegas_opciones = "<option></option>";
        if (count($bodegas) > 0) {
            foreach ($bodegas as $bod) {
                $selected = ($bod['bod_id'] == $bodegaProducto) ? "selected=selected" : "";
                $bodegas_opciones .= "<option " . $selected . " value='" . $bod['bod_id'] . "'>" . $bod['bod_nombre'] . "</option>";
            }
        }

        $sector_opciones = "<option></option>";
        if ($bodegaProducto > 0) {
            //Se obtiene los sectores de la bodega asignada
            $sectores = $this->inventario_model->get_sector_grid($bodegaProducto);
            foreach ($sectores as $sec) {
                $selected = ($sec['sxb_id'] == $sectorProducto) ? "selected=selected" : "";
                $sector_opciones .= "<option " . $selected . " value='" . $sec['sxb_id'] . "'>" . $sec['seb_nombre'] . "</option>";
            }
        }
        
        $prod_invent = $this->gsatelite->get_campo('art_articulo', 'art_inventario', array('art_id' => $producto));

        $arreglo = array('medidas' => $var, 'impuestos' => $impuestos, 'bodegas' => $bodegas_opciones, 'inventariable' => $prod_invent, 'sectores' => $sector_opciones);

        if (!$flag) {
            echo json_encode($arreglo);
        } else {
            return $arreglo;
        }
    }

    function get_tipos_activos_fijo() {

        $producto = ($idProc > 0) ? $idProc : $this->input->post('producto');

        $tipos = $this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_estado' => 1));

        $opciones = "<option>Seleccione</option>";
        foreach ($tipos as $key) {
            $opciones .= "<option value='" . $key['tac_id'] . "'>" . $key['tac_nombre'] . "</option>";
        }

        if (count($tipos) == 0) {
            $opciones = "";
        }

        $arreglo = array(
            "drop" => $opciones
        );

        echo json_encode($arreglo);
    }

    function get_activos_tipo($tipo_activo = null) {
        $tipo = ($tipo_activo != null) ? $tipo_activo : $this->input->post('tipo_activo');

        if ($tipo == '') {
            $productos = $this->gsatelite->get_tabla('act_activo_fijo');
        } else {
            $where = array('act_id_tac' => $tipo);
            $productos = $this->gsatelite->get_tabla('act_activo_fijo', $where);
        }

        //print_r($this->db->last_query());die();

        $etiqueta = 0;
        $opciones = "<option value='0'>Seleccione</option>";
        foreach ($productos as $fila) {
            $opciones .= "<option data-codigo='" . $fila['act_codigo'] . "' data-nombre='" . $fila['act_nombre'] . "' value='" . $fila['act_id'] . "' id='opt_prod" . $etiqueta . "'>" . $fila['act_nombre'] . "</option>";
            $etiqueta++;
        }

        if (count($productos) == 0) {
            $opciones = "";
        }
        $arreglo = array('activos' => $opciones);
        echo json_encode($arreglo);
    }

    function get_hijos_tipos_servicio($flag = false, $where = null, $where_servicios = null) {

        $opciones = '<option value="">Seleccione una opción</option>';


        $padre = ($this->input->post('padre') != '') ? $this->input->post('padre') : null;
        if ($_POST) {
            $where['cas_id_cas_padre'] = $padre;
        }


        if ($padre != null) {
            $where_servicios['sri_id_cas'] = $padre;
        }

        $categorias = $this->inventario_model->get_categorias_servicios($where);

        $servicios = $this->inventario_model->get_servicios_inventario($where_servicios);
        // print_r($this->db->last_query());die();
        foreach ($categorias as $key) {
            $opciones .= "<option value='" . $key['cas_id'] . "'>" . $key['cas_nombre'] . "</option>";
        }

        $servicios_opc = '<option value="">Seleccione una opción</option>';

        foreach ($servicios as $key) {
            $servicios_opc .= "<option data-codigo='" . $key['sri_codigo'] . "' value='" . $key['sri_id'] . "'>" . $key['sri_nombre'] . "</option>";
        }

        if (count($categorias) == 0) {
            $opciones = "";
        }

        if (count($servicios) == 0) {
            $servicios_opc = "";
        }

        $arreglo = array(
            "drop" => $opciones,
            'servicios' => $servicios_opc
        );

        echo json_encode($arreglo);
    }

    function enviar_autorizacion($iframe = false, $registro, $tipo_flujo) {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $post_array     = $_POST;
                $paso_actual    = $post_array['hdnActualPaso'];
                $paso_siguiente = $post_array['hdnSigPaso'];
                $txtComentario  = $post_array['txtComentario'];

                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_requisicion = array(
                            'sgr_id_usu'            => $this->tank_auth->get_user_id(),
                            'sgr_observacion'       => $txtComentario,
                            'sgr_fecha_salida'      => date('Y-m-d H:i:s'),
                            'sgr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'sgr_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );
                        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi'            => $registro,
                                'sgr_id_psf'            => $paso_siguiente,
                                'sgr_id_usu'            => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada'     => date('Y-m-d H:i:s'),
                                'sgr_estado'            => 1,
                                'sgr_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);

                            if ($seguimiento > 0) {
                                $this->compras_model->cambiar_estado_registro_flujo($registro, $tipo_flujo, 2);
                            }
                        }
                    break;
                    case 2:
                        //Se cierra el paso actual
                        $seguimiento_array = array(
                            'sgo_id_usu'                => $this->tank_auth->get_user_id(),
                            'sgo_observacion'           => $txtComentario,
                            'sgo_fecha_salida'          => date('Y-m-d H:i:s'),
                            'sgo_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'sgo_fecha_modificacion'    => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgo_seguimiento_orden', $seguimiento_array, array('sgo_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $seguimiento_array = array(
                                'sgo_id_orc'            => $registro,
                                'sgo_id_psf'            => $paso_siguiente,
                                'sgo_id_usu'            => $this->tank_auth->get_user_id(),
                                'sgo_fecha_entrada'     => date('Y-m-d H:i:s'),
                                'sgo_estado'            => 1,
                                'sgo_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'sgo_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'sgo_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'sgo_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_array);

                            if ($seguimiento > 0) {
                                $this->compras_model->cambiar_estado_registro_flujo($registro, $tipo_flujo, 2);
                            }
                        }
                    break;
                    case 4:
                        //Se cierra el paso actual
                        $scm_seguimiento_comparativo_compra = array(
                            'scm_id_usu'            => $this->tank_auth->get_user_id(),
                            'scm_observacion'       => $txtComentario,
                            'scm_fecha_salida'      => date('Y-m-d H:i:s'),
                            'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );
                        $this->gsatelite->actualizar_array('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra, array('scm_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $scm_seguimiento_comparativo_compra = array(
                                'scm_id_ccc'            => $registro,
                                'scm_id_psf'            => $paso_siguiente,
                                'scm_id_usu'            => $this->tank_auth->get_user_id(),
                                'scm_fecha_entrada'     => date('Y-m-d H:i:s'),
                                'scm_estado'            => 1,
                                'scm_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'scm_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra);

                            if ($seguimiento > 0) {
                                $this->compras_model->cambiar_estado_registro_flujo($registro, $tipo_flujo, 2);
                            }
                        }
                    break;

                }

                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if ($iframe == 1) {
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                } else {
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal'] = "Siguiente Paso";
            $data['iframe']     = $iframe;
            $data['registro']   = $registro;
            $data['tipo_flujo'] = $tipo_flujo;

            $paso_actual            = $this->compras_model->get_paso_actual($registro, $tipo_flujo);
            $paso_siguiente         = $this->compras_model->get_paso_siguiente($registro, $tipo_flujo);

            $data['paso_actual']    = $paso_actual[0];
            $data['paso_siguiente'] = $paso_siguiente[0];

            switch ($tipo_flujo) {
                case 1:
                $data['paso_actual_id'] = $paso_actual[0]['sgr_id'];
                $data['nombre_registro']= $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_numero', array('rxi_id' => $registro));
                $data['titulo_registro']= "Requisición N.";
                break;
                case 2:
                $data['paso_actual_id'] = $paso_actual[0]['sgo_id'];
                $data['nombre_registro']= $this->gsatelite->get_campo('orc_orden_compra', 'orc_numero', array('orc_id' => $registro));
                $data['titulo_registro']= "Orden de Compra N.";
                break;
                case 4:
                $data['paso_actual_id'] = $paso_actual[0]['scm_id'];
                $this->db->join('rxi_requisicion_inventario','rxi_id = ccc_id_rxi');
                $data['nombre_registro']= $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'rxi_numero', array('ccc_id' => $registro));
                $data['titulo_registro']= "Comparativo de cotizacion N.";
                break;
            }

            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/enviar_autorizacion', $data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    function ver_detalle_req($iframe = 0, $id = null, $estado = null) {
        satelite_validar();
        $data['iframe'] = $iframe;
        $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $id));
        $data['requisicion'] = $requisicion[0];
        if ($requisicion[0]['rxi_id_ord'] != "") {
                $this->load->model('proyecto_model');
                $data_orden = $this->proyecto_model->get_orden(array('ord_id' => $requisicion[0]['rxi_id_ord']));
                if (count($data_orden) > 0) {
                    $articulos = array();
                    $data["orden_prod"] = $data_orden[0]['ord_codigo'];
                    foreach ($data_orden as $key => $value) {
                        array_push($articulos, ($value['art_codigo'] . ' - ' . $value['art_nombre']));
                    }
                    $data["art_orden"] = implode(',', $articulos);
                }
            }
        $where = array('dri_id_rxi' => $id);
        $data['solicitante'] = $this->inventario_model->informacion_empleado($requisicion[0]['rxi_id_usu_solicita']);
        $data['detalle_requisicion'] = $this->inventario_model->get_requisicion_detalle($where);
        $data['anexos_requisicion'] = $this->gsatelite->get_tabla('aqi_anexo_requisicion_inventario', array('aqi_id_rxi' => $id));        
        $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/detalle_requisicion', $data, true);
    }

    /**
     * @descripcion:
     * Envio de correo electronico con archivo PDF de la orden de compra.
     * @author  Nelson Soriano
     * @since   28-11-2018
     * @param   id orden de compra
     * @return  none
    **/

    public function envia_correo_fn($id_orden_compra){
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        if ($id_orden_compra != null) {           
           //Preguntar por el proveedor           
            $this->gsatelite->verificar_registro_real('orc_orden_compra', $id_orden_compra);

            $registro_orden = $this->gsatelite->get_registro('orc_orden_compra', 'orc_id', $id_orden_compra); 


            $registro_prv = $this->gsatelite->get_registro('prv_proveedor', 'prv_id', $registro_orden->orc_id_prv);    


            $registro_user = $this->gsatelite->get_registro('users', 'id', $registro_orden->orc_id_usu_solicita);         

            //preguntar por los contactos de la cotizacion.
            //y extraer los emails de los mismos.            
            $contactos_prov = $this->gsatelite->get_tabla('cpv_contacto_prov', array('cpv_id_prv' => $registro_prv->prv_id));

            $correos_involucrados = array(); //el array ya contiene un elemento (el correo del proveedor)

            foreach ($contactos_prov as $f) {             
                if ($f['cpv_email'] != "") {
                    $correos_involucrados[] = $f['cpv_email'];                   
                }
            }

            //$contactos_prov->cpv_email != "" and
            if ($registro_user->email != '' and  count($correos_involucrados) > 0) {                
                //obtener el detalle de la cotización
                $corre_prov = $registro_user->email; //$contactos_prov->cpv_email;
                $nombre_prov =$registro_user->username;
                $asunto = "ORDEN DE COMPRA";
                $mensaje = $this->impresion_orden_compra($id_orden_compra, 1,true);

                //  $this->imprimir_cotizacion2($id, false, true);
                //$ruta_adjunto = base_url('amueblados_sa_de_cv.dic.29.esta_es_un.13'.'.pdf');
                //die($ruta_adjunto);
                $ruta_adjunto = "";
                if ($this->session->userdata('nombre_pdf_orden_compra') != "") {
                    $r_pdf = $this->session->userdata('nombre_pdf_orden_compra');
                    $this->session->unset_userdata('nombre_pdf_orden_compra');
                    $ruta_adjunto = FCPATH . $r_pdf;
                }
                //$ruta_adjunto= FCPATH.'amueblados_sa_de_cv.dic.29.esta_es_un.13'.'.pdf';
                //descomentar esta linea y comentar la de abajo (cuando ya este en produccion )
                //$correos_para = implode(",",$correos_involucrados);

                $estado = $this->gsatelite->envio_correo($corre_prov,$nombre_prov,$correos_involucrados,$asunto,$mensaje,$corre_prov,$ruta_adjunto); //melbin.cruz40@gmail.com //sairamelara@hotmail.com


                //$estado =  $this->gsatelite->envio_correo('leovilla7777@gmail.com','Saira (Vendedora)','reymundo0792@hotmail.com',$asunto,$mensaje,null,$ruta_adjunto);
                if ($estado) {  //validacion si correo se envio
                    if ($ruta_adjunto != "") {
                        unlink($ruta_adjunto);
                    }
                    return $estado;
                } else {
                    return "no_server";
                }
            } else { //si correo del usuario y del proveedor estan configurado 
                if ($registro_user->email != '') { //verifica si hay correo usuario
                    return "no_correo_usu";
                } elseif (count($correos_involucrados) > 0) { //verifica si hay correo de proveedor
                    return "no_correo_prv";
                }
               
           }
       } else { //numero de orden de compra
        return "no_num_compra";
    }
}

public function enviar_correo_orden(){
    $id = $this->input->post('id_orden');
    $exito = $this->envia_correo_fn($id);

    die(json_encode(array('exito' => $exito))); 

}

public function ordenes_compra($consulta = 0) {
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/requisiciones');
        if ($_POST) {
            if ($consulta > 0) {
                $post_array = $_POST;
                $estado_requicision = $post_array['estado'];
                $fecha_inicio       = $post_array['fecha_ini'];
                $fecha_fin          = $post_array['fecha_fin'];
                $slc_sucursal       = $post_array['slc_sucusal'];
                $where = null;
                if ($estado_requicision) {
                    $where['orc_estado'] = $estado_requicision;
                }

                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $where['orc_fecha_orden >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['orc_fecha_orden <='] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
                }

                if ($slc_sucursal != '') {
                    $where["orc_id_usu_solicita IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp  WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                }
                    // Se filtra las ordenes de compra solamente del usuario logueado
                $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
                $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                $permiso_rol = false;

                foreach ($mis_roles as $rol) {
                    if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                        $permiso_rol = true;
                    }
                }

                if ( $permiso_rol == false) {
                    $where['orc_usu_creacion']  = $this->tank_auth->get_user_id();
                    $where['orc_id_usu_solicita']   = $this->tank_auth->get_user_id();// /*/
                    $where['id']                    = $this->tank_auth->get_user_id();
                } 

                // $where['orc_id_usu_solicita']   = $this->tank_auth->get_user_id();// /*/
                $where['sgo_fecha_salida']      = null;

                $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                $flujos_array = json_decode($flujos, true);

                $where['flu_id'] = $flujos_array['ORDEN_COMPRA'];
                $ordenes = $this->compras_model->get_backlog_ordenes_compra($where);
                $data['ordenes'] = $ordenes;
                // $data['requisiciones'] = $requisiciones;
                $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
                $data['pdecimal'] = 2;
                $html = $this->load->view('modulo_compras/procesos/consultar_ordenes_compra', $data, true);

                echo $html;
                die();
            }
        } else {
            $empleado               = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$this->tank_auth->get_user_id()));
            $suc_emp = (count($empleado) > 0) ? $empleado[0]['emp_id_suc'] : null;
            $sucursal_dropdown      = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', $suc_emp, '', 'suc_id', true);
            $data['sucursales']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_dropdown);
            $data['titulo_personal']= 'Listado de Ordenes de Compra';
            $this->_cargarvista($data);
        }
    }
}

function agregar_orden_compra($rxi_id = null, $modulo=null, $coc_id = null) {
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
        if ($_POST) {
            if($rxi_id == 0){
                $rxi_id = null;
            }
            $retencion = $this->gsatelite->get_parametro('SYS_ID_IMPUESTO_PERCEPCION');
            $post_array             = $this->input->post();
            $tipo_btn               = $post_array['btnCrear'];
            $rxi_id                 = $post_array['rxi_id'];
            $rxi                    = ($rxi_id!=null)?'/'.$rxi_id:'';
            //Se obtiene el flujo de las ordenes para generar el codigo nuevamente
            $flujoOrden             = $post_array['hdnFlujo'];
            $num_actual             = $this->gsatelite->count('orc_orden_compra', array('orc_id_flu' => $flujoOrden));
            $codigo                 = $num_actual + 1;
            $codigo_orden           = generar_codigo_cor($codigo, 4);
            $idRequisicion          = ($post_array['slcRequisicion'] != '') ? $post_array['slcRequisicion'] : null;
            $slcArea                = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null; 
            $fechaOrden             = $post_array['fecha'];
            $slcPrioridad           = ($post_array['slcPrioridad'] != '') ? $post_array['slcPrioridad'] : null;
            $slcProveedor           = ($post_array['slcProveedor'] != '') ? $post_array['slcProveedor'] : null;
            $txtFechaEntrega        = ($post_array['txtFechaEntrega'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaEntrega'])) : null;
            $slcCondicionPago       = ($post_array['slcCondicionPago'] != '') ? $post_array['slcCondicionPago'] : null;
            $slcTipo                = $post_array['slcTipo'];
            $txtDescripcion         = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $txtDetalle             = ($post_array['txtDetalles'] != '') ? $post_array['txtDetalles'] : null;
            $txtdocnombrede         = ($post_array['txtdocnombrede'] != '') ? $post_array['txtdocnombrede'] : null;//agrega a la variable el contenido del post
            $slcProyecto            = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $slc_presupuesto        = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $slc_actividad_general  = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $slc_act_especifica     = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
            $slcTipoTransporte      = ($post_array['slcTipoTransporte'] != '') ? $post_array['slcTipoTransporte'] : null;
            $slcIncoterms           = ($post_array['slcIncoterms'] != '') ? $post_array['slcIncoterms'] : null;
            $slcTipoFac             = ($post_array['slcTipoFac'] != '') ? $post_array['slcTipoFac'] : null;
            $slcCentroCosto         = ($post_array['slcCentroCosto'] != '') ? $post_array['slcCentroCosto'] : null;
            $slcTipoPago            = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
            $txtDescuentoGeneral    = $post_array['txtDescuentoGeneral'];
            $txtImpuestosGeneral    = $post_array['txtImpuestosGeneral'];
            $detalle_condicion      = ($post_array['detalle_condicion'] != '')?$post_array['detalle_condicion']:null;
            //$txtGastosGeneral = $post_array['txtGastosGeneral'];
            $txtSubtotalGeneral     = $post_array['txtSubtotalGeneral'];
            $txtTotalGeneral        = $post_array['txtTotalGeneral'];
            $coc_registro           = ($post_array['coc_registro'] != '') ? $post_array['coc_registro'] : null;           
            // variables para requisiciones
            $tipo_requisicion       = "";
            $detalle_requisicion    = null;
            $flujos                 = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array           = json_decode($flujos, true);
            $column_articulo        = null;
            $requisicion_batch      = array();
            //verificar si es requisicion y que tipo es.
            if ( $idRequisicion > 0) {
                $tipo_requisicion = $this->gsatelite->get_campo("rxi_requisicion_inventario","rxi_id_flu",array("rxi_id" => $idRequisicion) );
            }
            if ( $tipo_requisicion == $flujos_array['REQ_COMP'] ) {
                $detalle_requisicion= $this->gsatelite->get_tabla("dri_detalle_requisicion_inventario",array( "dri_id_rxi" => $idRequisicion) );
                $column_articulo    = array_column($detalle_requisicion, 'dri_id_art') ;  
            }
            //Array con datos de los anexos
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];
            $orden_array = array(
                'orc_id_rxi' => $idRequisicion,
                'orc_id_prv' => $slcProveedor,
                'orc_id_flu' => $flujoOrden,
                'orc_id_usu_solicita' => $this->tank_auth->get_user_id(),
                'orc_id_are' => $slcArea,
                'orc_id_prd' => $slcPrioridad,
                'orc_id_cod' => $slcCondicionPago,
                'orc_id_pcl' => $slcProyecto,
                'orc_id_coc' => $coc_registro,
                'orc_id_ttr' => $slcTipoTransporte,
                'orc_id_inr' => $slcIncoterms,
                'orc_id_tpg' => $slcTipoPago,
                'orc_id_tif' => $slcTipoFac,
                'orc_id_cec' => $slcCentroCosto,
                'orc_id_psp' => $slc_presupuesto,
                'orc_id_ace' => $slc_act_especifica,
                'orc_id_acg' => $slc_actividad_general,
                'orc_numero' => $codigo_orden,
                'orc_tipo'   => $slcTipo,
                'orc_descripcion'   => $txtDescripcion,                
                'orc_fecha_orden'   => date('Y-m-d', strtotime($fechaOrden)),
                'orc_fecha_entrega' => $txtFechaEntrega,
                'orc_impuesto'  => convertirFloat($txtImpuestosGeneral),
                'orc_descuento' => convertirFloat($txtDescuentoGeneral),
                'orc_detalle'   => $txtDetalle,
                'orc_detalle_condicion'     => $detalle_condicion,
                'orc_subtotal'              => convertirFloat($txtSubtotalGeneral),
                'orc_total'                 => convertirFloat($txtTotalGeneral),
                'orc_estado'                => 1,
                'orc_usu_creacion'          => $this->tank_auth->get_user_id(),
                'orc_fecha_creacion'        => date('Y-m-d H:i:s'),
                'orc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'orc_fecha_modificacion'    => date('Y-m-d H:i:s'),
                'orc_anombre_de'            => $txtdocnombrede //guarda la nueva variables
            );
            $orc_id = $this->gsatelite->ingresar('orc_orden_compra', $orden_array);
            if ($orc_id > 0) {
                //Se ingresa el primer paso
                $primer_paso = $this->compras_model->get_primer_paso_flujo($flujoOrden);
                if (count($primer_paso) > 0) {
                    $seguimiento_requisicion = array(
                        'sgo_id_orc' => $orc_id,
                        'sgo_id_psf' => $primer_paso[0]['psf_id'],
                        'sgo_id_usu' => $this->tank_auth->get_user_id(),
                        'sgo_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgo_estado' => 1,
                        'sgo_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgo_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                    $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_requisicion);
                }
                //Se obtienen los detalles de la grid
                $productos = $post_array['productos'];
                $conversiones = $post_array['conversion'];
                $cantidades = $post_array['cantidades'];
                $precios = $post_array['precios'];
                $impuestos = $post_array['impuestos'];
                $impuestosProducto = $post_array['impuestosProducto'];
                $descuentos = $post_array['descuentos'];
                //$gastos = $post_array['gastos'];
                $subtotalesProducto = $post_array['subtotalesProducto'];
                $totalesProducto = $post_array['totalesProducto'];
                $descripcionProd = $post_array['newdescripcionProd'];
                if (count($productos) > 0) {
                    //Se ingresan los detalles de la orden
                    for ($i = 0; $i < count($productos); $i++) {
                        $retenido = 0;
                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;
                        $conversion_prodc = (isset($conversiones[$i]) && $conversiones[$i] != "")? $conversiones[$i]:null;
                        //$conversion_prodc = (isset($conversiones[$i]))? $conversiones[$i]: null;
                        //Se validan los registros en base al tipo de orden
                        //1 = Producto, 2 = Servicio, 3 = Activo Fijo, 4 = Producto y Servicio
                        if ($slcTipo == 1) {
                            $producto_id = $productos[$i];
                            $conversion_prodc = $conversiones[$i];
                        } else if ($slcTipo == 2) {
                            $producto_id = $productos[$i];
                            //$conversion_prodc = $conversiones[$i];
                        } else if ($slcTipo == 3) {
                            $activo_id = $productos[$i];
                        } elseif ($slcTipo == 4) {
                            $producto_id = $productos[$i];
                            $conversion_prodc = ($conversiones[$i]!='') ? $conversiones[$i] : null;
                        }
                        $impuesto_detalle = convertirFloat($impuestosProducto[$i]);
                        $descuento_detalle = convertirFloat($descuentos[$i]);

                        $taxIds[$i] = explode(',', $impuestos[$i]);
                        if (in_array($retencion, $taxIds[$i])) {
                            $porc = $this->gsatelite->get_campo("imp_impuesto","imp_porcentaje",array("imp_id" => $retencion));
                            $retenido = ($porc/100) * convertirFloat($subtotalesProducto[$i]);
                            $impuesto_detalle = $impuesto_detalle - $retenido;
                        }
                        $detalle_array = array(
                            'dor_id_art' => $producto_id,
                            'dor_id_act' => $activo_id,
                            'dor_id_orc' => $orc_id,
                            'dor_id_cva' => $conversion_prodc,
                            'dor_cantidad' => convertirFloat($cantidades[$i]),
                            'dor_precio_unitario' => convertirFloat($precios[$i]),
                            'dor_impuesto' => ($impuesto_detalle == '') ? 0 : $impuesto_detalle,
                            'dor_retencion' => ($retenido > 0 ) ? $retenido : null,
                            'dor_descuento' => ($descuento_detalle == '') ? 0 : $descuento_detalle,
                            'dor_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dor_total' => convertirFloat($totalesProducto[$i]),
                            'dor_descripcion' => $descripcionProd[$i],
                            'dor_estado' => 1,
                            'dor_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dor_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dor_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dor_fecha_creacion' => date('Y-m-d H:i:s'),
                        );
                        $dor_id = $this->gsatelite->ingresar('dor_detalle_orden_compra', $detalle_array);
                        //si es requisicion, debe actualizar                            
                        if ( count($detalle_requisicion) > 0 && convertirFloat($cantidades[$i]) > 0) {
                            $key = array_search($producto_id, $column_articulo);
                            if ( is_numeric($key) ) {
                                $solicitado     = $detalle_requisicion[$key]["dri_cantidad"];
                                $despacho_old   = $detalle_requisicion[$key]["dri_cantidad_despacho"];
                                $despacho_old   = ($despacho_old > 0)?$despacho_old:0;
                                $despacho_new   = convertirFloat($despacho_old) + convertirFloat($cantidades[$i]);
                                $estado_entrega = (convertirFloat($despacho_new) >= convertirFloat($solicitado))?2:1;
                                //array batch para actualizar requisiciones.
                                $requisicion_batch_1['dri_id']                  = $detalle_requisicion[$key]["dri_id"];
                                $requisicion_batch_1['dri_cantidad_despacho']   = $despacho_new;
                                $requisicion_batch_1['dri_estado_entrega']      = $estado_entrega;
                                $requisicion_batch_1['dri_usu_modificacion']    = $this->tank_auth->get_user_id();
                                $requisicion_batch_1['dri_fecha_modificacion']  = date('Y-m-d H:i:s');
                                array_push($requisicion_batch,$requisicion_batch_1);
                            }  
                        }
                        //Si se ingresa el detalle, se ingresan los impuestos y gastos
                        if ($dor_id > 0) {
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);
                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {
                                        if ($impuestos_array[$j] != '') {
                                            $ixo_array = array(
                                                'ixo_id_imp' => $impuestos_array[$j],
                                                'ixo_id_dor' => $dor_id,
                                                'ixo_estado' => 1,
                                                'ixo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'ixo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'ixo_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'ixo_fecha_creacion' => date('Y-m-d H:i:s')
                                            );
                                            $this->gsatelite->ingresar('ixo_impuestoxdetalle_orden', $ixo_array);
                                        }
                                    }
                                }
                            }
                        }
                    }                        
                    if ( count($requisicion_batch) > 0 ) {
                        $this->db->update_batch('dri_detalle_requisicion_inventario', $requisicion_batch, 'dri_id');
                        $where_detalle["dri_id_rxi"] = $idRequisicion;
                        $where_detalle["(dri_estado_entrega != 2 OR dri_estado_entrega IS NULL)"] = NULL;
                        $detalles_actualizados  = $this->gsatelite->get_tabla("dri_detalle_requisicion_inventario", $where_detalle );
                        if ( count($detalles_actualizados) == 0 ) {
                            $requisicion_actualizacion = array(
                                "rxi_estado"            => 0,
                                "rxi_usu_modificacion"  => $this->tank_auth->get_user_id(),
                                "rxi_fecha_modificacion"=> date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $requisicion_actualizacion, array('rxi_id' => $idRequisicion));
                        } else {
                            $requisicion_actualizacion = array(
                                "rxi_estado"            => 6,
                                "rxi_usu_modificacion"  => $this->tank_auth->get_user_id(),
                                "rxi_fecha_modificacion"=> date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $requisicion_actualizacion, array('rxi_id' => $idRequisicion));
                        }
                    }
                    if ($dor_id > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "El registro se guardó correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                    }
                }
                //Si vienen anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anx_orden_compra/" . $nombreArchivo;
                        $documentos_array = array(
                            'aoc_id_orc'             => $orc_id,
                            'aoc_url'                => $carpeta_destino_anx,
                            'aoc_nombre'             => $nombreArchivo,
                            'aoc_estado'             => 1,
                            'aoc_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'aoc_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'aoc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'aoc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $aoc_id = $this->gsatelite->ingresar('aoc_anexo_orden_compra', $documentos_array);
                        if ($aoc_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $tipo_flujo = 2; // tipo flujo: 2- Orden de Compra
            $flujo      = 2; // Flujo: 2 - Orden de Compra
            $autorizar = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('ORDEN_COMPRA'));
            if (isset($autorizar) && $autorizar > 0 && $tipo_btn === '3' && $orc_id > 0) {
                $this->autorizar_requisicion_compras_automatica($orc_id, $tipo_flujo, $flujo);
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('modulo_compras/procesos/agregar_orden_compra');
            } else if($tipo_btn == 2) {
                redirect('modulo_compras/procesos/ordenes_compra');
            }else if($tipo_btn == 4) {
                redirect('modulo_compras/procesos/cotizaciones');
            } else {
                redirect('modulo_compras/procesos/ordenes_compra');
            }                
        }
        $permiso_compra = false;
        $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
        $permisos_array = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
        if ( count($permisos_array) > 0 ) {
            $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
            foreach ($roles as $role) {
                if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                    $permiso_compra = true;
                }
            }
        }
        $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
        $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;           
        $data["permiso_compra"] = $permiso_compra;  
        $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
        $flujos_array = json_decode($flujos, true);
        $num_actual = $this->gsatelite->count('orc_orden_compra', array('orc_id_flu' => $flujos_array['ORDEN_COMPRA']));
        $codigo = $num_actual + 1;
        $data['flujo'] = $flujos_array['ORDEN_COMPRA'];
        $data['num_orden'] = generar_codigo_cor($codigo, 4);
        $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $id_prv = 0;
        $data['presupuesto']        = '<option value=""></option>';
        $data['general']            = '<option value=""></option>';
        $data['especifica']         = '<option value=""></option>';
        if ($rxi_id != null && $rxi_id != 0) {
            /** ******************************** EXISTE COTIZACIÓN APROBADA ****************************** */                
            $where_cotizacion["coc_id_rxi"] = $rxi_id;
            $where_cotizacion["coc_estado"] = 2;
            if (  $coc_id > 0 ) {
                $where_cotizacion["coc_id"] = $coc_id;
            }
            $cotizacion_data = $this->compras_model->get_cotizaciones($where_cotizacion); // cotizaci[on aprobada de la requisición.
            $cotizacion = (count($cotizacion_data) > 0) ? $cotizacion_data[0] : null;
            $id_prv = $cotizacion['coc_id_prv'];
            $id_coc = $cotizacion['coc_id'];
            $cotizaciones = $this->compras_model->get_detalle_cotizacion(array('dco_id_coc' => $id_coc));
            // print_r($this->db->last_query());die();
            /** ******************************* NO EXISTE COTIZACIÓN APROBADA **************************** */            
            $data['requisicion'] = $rxi_id;
            $data['requisicion_data'] = $req = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $rxi_id));
            $data['opc'] = 1;
            $option = '';
            $options = $this->compras_model->get_requisiciones_sin_orden();        
            for ($i=0; $i < count($options) ; $i++) { 
                $option .= str_replace('<option value="0">Seleccione</option>', '', $this->gsatelite->get_dropdown('rxi_requisicion_inventario', '{rxi_numero} - {rxi_descripcion_entrega}', '', array('rxi_id' => $options[$i]['rxi_id']), $rxi_id, null, null, true));
            }
            $data['requisiciones'] = $option;
            if ($req[0]['rxi_id_ord'] != "") {
                $this->load->model('proyecto_model');
                $data_orden = $this->proyecto_model->get_orden(array('ord_id' => $req[0]['rxi_id_ord']));
                if (count($data_orden) > 0) {
                    $articulos = array();
                    $data["orden_prod"] = $data_orden[0]['ord_codigo'];
                    foreach ($data_orden as $key => $value) {
                        array_push($articulos, ($value['art_codigo'] . ' - ' . $value['art_nombre']));
                    }
                    $data["art_orden"] = implode(',', $articulos);
                }
            }
            $where_requisicion["dri_id_rxi"] = $rxi_id;
            $where_requisicion["(dri_estado_entrega != 2 OR dri_estado_entrega IS NULL)"] = NULL;
            $requisiciones = $this->inventario_model->get_requisicion_detalle( $where_requisicion );
            //print_r($cotizaciones);die();
            $data['detalles'] = (count($cotizaciones) > 0) ? $cotizaciones : $requisiciones;
            $usuario = $this->inventario_model->informacion_empleado($data['requisicion_data'][0]['rxi_id_usu_solicita']);
            $data['prioridades'] = $this->gsatelite->get_dropdown('prd_prioridad', '{prd_nombre}', '', array('prd_estado' => 1), $req[0]['rxi_id_prd'], null, null, true);            
            $slc_presupuesto            = ($req[0]['rxi_id_psp'] != "" )?$this->get_presupuestoxproyecto($req[0]['rxi_id_pcl'], $req[0]['rxi_id_psp']):'<option value=""></option>';
            $data['presupuesto']        = $slc_presupuesto;
            $slc_general                = ($req[0]['rxi_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($req[0]['rxi_id_psp'], $req[0]['rxi_id_acg'],false,false):'<option value=""></option>';
            $data['general']            = $slc_general;
            $slc_especifica             = ($req[0]['rxi_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($req[0]['rxi_id_acg'], $req[0]['rxi_id_psp'], $req[0]['rxi_id_ace']):'<option value=""></option>';
            $data['especifica']         = $slc_especifica;
        } else if(trim($rxi_id) == 0 && $rxi_id != null){
            $cotizacion_detalle = $this->gsatelite->get_tabla('coc_cotizacion_compra', array('coc_id'=>$coc_id));
            $id_prv = ($cotizacion_detalle[0]['coc_id_prv'] != null)?$cotizacion_detalle[0]['coc_id_prv']:0;
            $cotizaciones = $this->compras_model->get_detalle_cotizacion(array('dco_id_coc' => $coc_id));
            $data['requisicion'] = null;
            $data['requisiciones'] = null;
            $data['cot_detalle'] = $cotizacion_detalle[0];
            $data['detalles'] = $cotizaciones;
            $usuario = $this->inventario_model->informacion_empleado($cotizacion_detalle[0]['coc_usu_creacion']);
            $data['prioridades'] = $this->gsatelite->get_dropdown('prd_prioridad', '{prd_nombre}', '', array('prd_estado' => 1), null, null, null, true);
        } else {
            $data['requisicion'] = false;
            $option = '';
            $opc='';
            $flujos_array   = json_decode($this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO'), true);
                       $this->db->where('rxi_id_flu', $flujos_array['REQ_COMP']);//MOSTRAR SOLO REQUISICIONES DEL FLUJO DE COMPRAS
            $options = $this->compras_model->get_requisiciones_sin_orden();
            for ($i=0; $i < count($options) ; $i++) { 
                $option .= str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('rxi_requisicion_inventario','{rxi_numero} - {rxi_descripcion_entrega}','',array('rxi_id' => $options[$i]['rxi_id']),null,null,null,true));
            }
            $data['requisiciones'] = $option;
            $data['detalles'] = array();
            $usuario = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['prioridades'] = $this->gsatelite->get_dropdown('prd_prioridad', '{prd_nombre}', '', array('prd_estado' => 1), null, null, null, true);
        }
        $data['usuarios'] = $usuario;
        //$data['bodegas'] = $this->inventario_model->get_bodegas_usuario();
        $tpg_id = null;
        $cod_id = null;
        if ( $coc_id != NULL) {
           $tpg_id = $cotizacion['coc_id_tpg'];
           $cod_id = $cotizacion['coc_id_cod'];
        }
        $data['areas'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', '', array('are_estado' => 1), $usuario[0]['are_id'], null, null, true);
        $data['condiciones']  = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), $cod_id, null, null, true);
        $data['tipo_factura'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1,'tif_aplica_compra' => 1), null, null, null, true);
        $data['centro_costo'] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, null, null, true);
        $data['tipo_pago']    = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), $tpg_id, null, null, true);
        $select = "";
        $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
        foreach ($impuesto_campos as $key) {
            if ($key["imp_porcentaje"] > 0 ) {
                $select .= "<option data-type='1' data-porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
            } else {
                $select .= "<option data-type='0' data-porcentaje='" . $key["imp_valor"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
            }
        }
        $data["impuestos"] = $select;
        $select = "";
        $data['categorias_padre'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_padre' => null), null, null, null, true);
        $data['gastos'] = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));
        $proveedores = $this->compras_model->get_proveedor_pers();
        $options = '<option value=""></option>';
        foreach ($proveedores as $key) {
            $cod = ($key['prv_id_cod'] != '') ? $key['prv_id_cod'] : '';
            if ($key['pro'] != '') {
                if ($id_prv > 0 && $id_prv == $key['prv_id']) {
                    $options .= '<option value="' . $key['prv_id'] . '" detalle="' . $key['det'] . '" cod="' . $cod . '" selected>' . $key['pro'] . '</option>';
                } else {
                    $options .= '<option value="' . $key['prv_id'] . '" detalle="' . $key['det'] . '" cod="' . $cod . '">' . $key['pro'] . '</option>';
                }
            }
        }
        $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
        $select_proyecto = '<option value=""></option>';
        foreach ($proyectos_reg as $key) {
            $selected = '';
            if($rxi_id != null){
                $selected = ($data['requisicion_data'][0]['rxi_id_pcl'] == $key['pcl_id'])?'selected':'';
            }
            $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
            $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
            $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
        }
        $selected = $this->gsatelite->get_dropdown('inr_incoterms', '{inr_nombre}', '', array('inr_estado' => 1), null, null, 'inr_id', true);
        $data['incoterms'] = str_replace('<option value="0">Seleccione</option>', '', $selected);
        $selected = $this->gsatelite->get_dropdown('ttr_tipo_transporte', '{ttr_nombre}', '', array('ttr_estado' => 1), null, null, 'ttr_id', true);
        $data['transportes'] = str_replace('<option value="0">Seleccione</option>', '', $selected);
        $data['proyectos'] = $select_proyecto;
        $data['proveedores'] = $options;
        $data['dir'] = $modulo;
        $data['rxi_id'] = $rxi_id;
        /* ************************************************** */
        /* Obtener los permisos para autorizar la requisicion */
        /* ************************************************** */
        $groupby = null;
        $orderby = null;
        $where   = null;
        // agrupador
        $groupby = 'rol_id';
        $data['cotizacion_text'] = $coc_id; 
        $where   = array('psf_orden'=>2, 'psf_id_flu'=>3, 'axr_id_acc'=>4, 'id'=>$this->tank_auth->get_user_id());
        $data['autorizar'] = $this->inventario_model->get_permisos_autorizar_requisicion($where, $groupby, $orderby);
        //print_r($this->db->last_query());die();
        $data['parametro'] = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('ORDEN_COMPRA'));
        //print($data['parametro']);die();
        /* ************************************************** */
        $data['titulo_personal'] = 'Crear orden de compra';
        $anombre_de = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_CONF_IMPRESION_ORDEN_COMPRA'));
        $data['a_nombre_de'] = json_decode($anombre_de,true);
        $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
        //print_r($data["detalles"]);die();
        $this->_cargarvista($data);
    }
}

    function editar_orden_compra($orc_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($this->input->post()) {
                //Se guarda toda la informacion en una variable
                $post_array = $this->input->post();
                $tipo_btn = $post_array['btnCrear'];
                $retencion = $this->gsatelite->get_parametro('SYS_ID_IMPUESTO_PERCEPCION');

                //Se obtienen los datos del post
                $slcArea               = ($post_array['slcArea'] != "") ? $post_array['slcArea'] : null;
                $slcPrioridad          = ($post_array['slcPrioridad'] != '') ? $post_array['slcPrioridad'] : null;
                $slcProveedor          = ($post_array['slcProveedor'] != '') ? $post_array['slcProveedor'] : null;
                $txtFechaEntrega       = ($post_array['txtFechaEntrega'] != '') ?date('Y-m-d', strtotime($post_array['txtFechaEntrega'])): null;
                $slcCondicionPago      = ($post_array['slcCondicionPago'] != '') ? $post_array['slcCondicionPago'] : null;
                $slcTipo               = $post_array['slcTipo'];
                $txtDetalle            = ($post_array['txtDetalle'] != '') ? $post_array['txtDetalle'] : null;
                $txtDescripcion        = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
                $slcTipoTransporte     = ($post_array['slcTipoTransporte'] != '') ? $post_array['slcTipoTransporte'] : null;
                $slcIncoterms          = ($post_array['slcIncoterms'] != '') ? $post_array['slcIncoterms'] : null;
                $slcTipoFac            = ($post_array['slcTipoFac'] != '') ? $post_array['slcTipoFac'] : null;
                $slcCentroCosto        = ($post_array['slcCentroCosto'] != '') ? $post_array['slcCentroCosto'] : null;
                $slcTipoPago           = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
                $txtdocnombrede        = ($post_array['txtdocnombrede'] != '') ? $post_array['txtdocnombrede'] : null;//se agrega el post a la variable 
                $txtDescuentoGeneral   = $post_array['txtDescuentoGeneral'];
                $txtImpuestosGeneral   = $post_array['txtImpuestosGeneral'];
                $txtSubtotalGeneral    = $post_array['txtSubtotalGeneral'];
                $txtTotalGeneral       = $post_array['txtTotalGeneral'];
                $slcProyecto           = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
                $slc_presupuesto       = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
                $slc_actividad_general = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
                $slc_act_especifica    = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
                //Anexos   
                $AnexoPrv      = $post_array['AnexoPrv'];
                $TitulosAnexo  = $post_array['titulo_doc'];
                $NombreAnexo   = $post_array['ruta'];
                $detalle_condi = ($post_array['detalle_condicion'] != '') ? $post_array['detalle_condicion'] : null;

                $orden_array = array(
                    'orc_id_prv' => $slcProveedor,
                    'orc_id_are' => $slcArea,
                    'orc_id_prd' => $slcPrioridad,
                    'orc_id_cod' => $slcCondicionPago,
                    'orc_id_pcl' => $slcProyecto,
                    'orc_id_ttr' => $slcTipoTransporte,
                    'orc_id_inr' => $slcIncoterms,
                    'orc_id_tpg' => $slcTipoPago,
                    'orc_id_tif' => $slcTipoFac,
                    'orc_id_cec' => $slcCentroCosto,
                    'orc_id_psp' => $slc_presupuesto,
                    'orc_id_ace' => $slc_act_especifica,
                    'orc_id_acg' => $slc_actividad_general,
                    'orc_detalle'=> $txtDetalle,
                    'orc_detalle_condicion'=>$detalle_condi,
                    'orc_descripcion' => $txtDescripcion,
                    'orc_fecha_entrega' => $txtFechaEntrega,
                    'orc_impuesto' => convertirFloat($txtImpuestosGeneral),
                    'orc_descuento' => convertirFloat($txtDescuentoGeneral),
                    'orc_subtotal' => convertirFloat($txtSubtotalGeneral),
                    'orc_total' => convertirFloat($txtTotalGeneral),
                    'orc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'orc_fecha_modificacion'    => date('Y-m-d H:i:s'),
                    'orc_anombre_de'            => $txtdocnombrede //se agrego el campo de anombre_de
                );
                $resultado = $this->gsatelite->actualizar_array('orc_orden_compra', $orden_array, array('orc_id' => $orc_id));
                if ($resultado > 0) {
                    //Se obtienen los detalles de la grid para actualizar
                    $productosIds = $post_array['hdnDetalle'];
                    $CantidadesOrc = $post_array['hdnCantidadesOrc'];
                    $PreciosOrc = $post_array['hdnPreciosOrc'];
                    $impuestosDetalle = $post_array['hdnImpuestosOrc'];
                    $impuestosOrc = $post_array['impuestosOrc'];
                    $DescuentosOrc = $post_array['hdnDescuentosOrc'];
                    $subtotalesOrc = $post_array['subtotalesOrc'];
                    $totalesOrc = $post_array['totalesOrc'];
                    $descripcion_producto = $post_array['descripcionProd'];
                    //Se eliminan los registros necesarios.
                    //Se verifica si se eliminaron productos.
                    $where = array(
                        'dor_id_orc' => $orc_id
                    );
                    $dataDetalle = $this->compras_model->get_detalle_orden_compra($where);
                    if (!is_array($productosIds)) {
                        $productosIds = array();
                    }
                    foreach ($dataDetalle as $data) {
                        if (!in_array($data['dor_id'], $productosIds)) {
                            //Se eliminan los impuestos del detalle
                            $this->gsatelite->borrado_general('ixo_impuestoxdetalle_orden', array('ixo_id_dor' => $data['dor_id']));
                            //Se elimina el detalle
                            $this->gsatelite->borrado_general('dor_detalle_orden_compra', array('dor_id' => $data['dor_id']));
                        }
                    }
                    //Se actualizan los detalles
                    if (count($productosIds) > 0) {
                        for ($i = 0; $i < count($productosIds); $i++) {
                            $retenido = 0;
                            $impuestoOrc = convertirFloat($impuestosOrc[$i]);
                            $descuentoOrc = convertirFloat($DescuentosOrc[$i]);
                            $taxIds[$i] = explode(',', $impuestosDetalle[$i]);
                        if (in_array($retencion, $taxIds[$i])) {
                            $porc = $this->gsatelite->get_campo("imp_impuesto","imp_porcentaje",array("imp_id" => $retencion));
                            $retenido = ($porc/100) * convertirFloat($subtotalesOrc[$i]);
                            $impuestoOrc = $impuestoOrc - $retenido;
                        }

                            $detalle_array = array(
                                'dor_cantidad' => convertirFloat($CantidadesOrc[$i]),
                                'dor_impuesto' => ($impuestoOrc == '') ? 0 : $impuestoOrc,
                                'dor_retencion' => ($retenido > 0 ) ? $retenido : null,
                                'dor_precio_unitario' => convertirFloat($PreciosOrc[$i]),
                                'dor_descuento' => ($descuentoOrc == '') ? 0 : convertirFloat($descuentoOrc),
                                'dor_subtotal' => convertirFloat($subtotalesOrc[$i]),
                                'dor_total' => convertirFloat($totalesOrc[$i]),
                                'dor_descripcion' => $descripcion_producto[$i],
                                'dor_estado' => 1,
                                'dor_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dor_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $resultado = $this->gsatelite->actualizar_array('dor_detalle_orden_compra', $detalle_array, array('dor_id' => $productosIds[$i]));

                            //Se eliminan los impuestos del detalle
                            $this->gsatelite->borrado_general('ixo_impuestoxdetalle_orden', array('ixo_id_dor' => $productosIds[$i]));
                            //Se ingresan nuevamente
                            if (count($impuestosDetalle) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestosDetalle[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos

                                    for ($j = 0; $j < count($impuestos_array); $j++) {
                                        if ($impuestos_array[$j] != '' && is_numeric($impuestos_array[$j]) && $impuestos_array[$j] >0 ) {
                                            $ixo_array = array(
                                                'ixo_id_imp' => $impuestos_array[$j],
                                                'ixo_id_dor' => $productosIds[$i],
                                                'ixo_estado' => 1,
                                                'ixo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'ixo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'ixo_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'ixo_fecha_creacion' => date('Y-m-d H:i:s')
                                            );
                                            $this->gsatelite->ingresar('ixo_impuestoxdetalle_orden', $ixo_array);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    //Se obtienen los detalles de la grid para ingresar
                    $productos = $post_array['productos'];
                    $conversiones = $post_array['conversion'];
                    $cantidades = $post_array['cantidades'];
                    $precios = $post_array['precios'];
                    $impuestos = $post_array['impuestos'];
                    $impuestosProducto = $post_array['impuestosProducto'];
                    $descuentos = $post_array['descuentos'];
                    $subtotalesProducto = $post_array['subtotalesProducto'];
                    $totalesProducto = $post_array['totalesProducto'];
                    $newdescripcionProd = $post_array['newdescripcionProd'];


                    if (count($productos) > 0) {
                        //Se ingresan los detalles de la orden
                        for ($i = 0; $i < count($productos); $i++) {

                            $producto_id = null;
                            $conversion_prodc = null;
                            $activo_id = null;
                            $conversion_prodc = isset($conversiones[$i])? $conversiones[$i]:null;

                            //Se validan los registros en base al tipo de orden
                            //1 = Producto, 2 = Servicio, 3 = Activo Fijo
                            if ($slcTipo == 1) {
                                $producto_id = $productos[$i];
                                $conversion_prodc = $conversiones[$i];
                            } else if ($slcTipo == 2) {
                                $producto_id = $productos[$i];
                            } else if ($slcTipo == 3) {
                                $activo_id = $productos[$i];
                            } else if ($slcTipo == 4) {
                                $producto_id = $productos[$i];
                                $conversion_prodc = ($conversiones[$i]!='') ? $conversiones[$i] : null;
                            }

                            $impuesto_detalle = convertirFloat($impuestosProducto[$i]);
                            $descuento_detalle = convertirFloat($descuentos[$i]);

                            $detalle_array = array(
                                'dor_id_art' => $producto_id,
                                'dor_id_act' => $activo_id,
                                'dor_id_orc' => $orc_id,
                                'dor_id_cva' => $conversion_prodc,
                                'dor_cantidad' => convertirFloat($cantidades[$i]),
                                'dor_precio_unitario' => convertirFloat($precios[$i]),
                                'dor_impuesto' => ($impuesto_detalle == '') ? 0 : $impuesto_detalle,
                                'dor_descuento' => ($descuento_detalle == '') ? 0 : $descuento_detalle,
                                'dor_subtotal' => convertirFloat($subtotalesProducto[$i]),
                                'dor_total' => convertirFloat($totalesProducto[$i]),
                                'dor_descripcion' => $newdescripcionProd[$i],
                                'dor_estado' => 1,
                                'dor_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dor_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'dor_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dor_fecha_creacion' => date('Y-m-d H:i:s'),
                            );

                            $dor_id = $this->gsatelite->ingresar('dor_detalle_orden_compra', $detalle_array);

                            //Si se ingresa el detalle, se ingresan los impuestos y gastos
                            if ($dor_id > 0) {

                                //Se valida existan impuestos
                                if (count($impuestos) > 0) {
                                    //Se crea el array de los impuestos
                                    $impuestos_array = explode(',', $impuestos[$i]);

                                    if (count($impuestos_array) > 0) {
                                        //Se recore el array para la insercion de impuestos
                                        for ($j = 0; $j < count($impuestos_array); $j++) {
                                            if ($impuestos_array[$j] != '' && is_numeric($impuestos_array[$j]) && $impuestos_array[$j] >0 ) {
                                                $ixo_array = array(
                                                    'ixo_id_imp' => $impuestos_array[$j],
                                                    'ixo_id_dor' => $dor_id,
                                                    'ixo_estado' => 1,
                                                    'ixo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                    'ixo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                    'ixo_usu_creacion' => $this->tank_auth->get_user_id(),
                                                    'ixo_fecha_creacion' => date('Y-m-d H:i:s')
                                                );
                                                $this->gsatelite->ingresar('ixo_impuestoxdetalle_orden', $ixo_array);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }


                    //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                    $dataAnexos = $this->gsatelite->get_tabla('aoc_anexo_orden_compra', array('aoc_id_orc' => $orc_id));
                    if (!is_array($AnexoPrv)) {
                        $AnexoPrv = array();                
                    }
                    foreach ($dataAnexos as $data) {
                        if (!in_array($data['aoc_id'], $AnexoPrv)) {
                            $this->gsatelite->borrado_general('aoc_anexo_orden_compra', array('aoc_id' => $data['aoc_id']));
                            $ruta_nxp = $data['aoc_url'];
                            unlink($ruta_nxp);
                        }
                    }

                    //Anexos
                    if (count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {
                            $extension = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                            $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                            $carpeta_destino_anx = "uploads/anx_orden_compra/" . $nombreArchivo;

                            $documentos_array = array(
                                'aoc_id_orc'             => $orc_id,
                                'aoc_url'                => $carpeta_destino_anx,
                                'aoc_nombre'             => $nombreArchivo,
                                'aoc_estado'             => 1,
                                'aoc_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'aoc_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'aoc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'aoc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $anx_id = $this->gsatelite->ingresar('aoc_anexo_orden_compra', $documentos_array);

                            if ($anx_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }



                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                if ($resultado > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                $tipo_flujo = 2; // tipo flujo: 2- Orden de Compra
                $flujo      = 2; // Flujo: 2 - Orden de Compra
                $autorizar = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('ORDEN_COMPRA'));
                if (isset($autorizar) && $autorizar > 0 && $tipo_btn === '3' && $orc_id > 0) {
                    $this->autorizar_requisicion_compras_automatica($orc_id, $tipo_flujo, $flujo);
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/procesos/editar_orden_compra/' . $orc_id);
                } else {
                    redirect('modulo_compras/procesos/ordenes_compra');
                }
            }
            $sobre_giro         = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
            $data["sobre_giro"] = ($sobre_giro != "" ) ? $sobre_giro : 0;
            $permiso_compra     = false;
            $permisos_array     = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
            $permisos_array     = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
            if ( count($permisos_array) > 0 ) {
                $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
                foreach ($roles as $role) {
                    if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                        $permiso_compra = true;
                    }
                }
            }
            $data["permiso_compra"] = $permiso_compra;  
            $orden_compra       = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
            $data['decimales']  = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            if ($orden_compra[0]['orc_id_rxi'] != null) {
                $rxi_id = $orden_compra[0]['orc_id_rxi'];
                $data['requisicion'] = $orden_compra[0]['orc_id_rxi'];
                $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $rxi_id));
                $data['requisiciones'] = $this->gsatelite->get_dropdown('rxi_requisicion_inventario', 'rxi_numero', '', array('rxi_id' => $rxi_id), $rxi_id, null, null, true);
                if ($requisicion[0]['rxi_id_ord'] != "") {
                    $this->load->model('proyecto_model');
                    $data_orden = $this->proyecto_model->get_orden(array('ord_id' => $requisicion[0]['rxi_id_ord']));
                    if (count($data_orden) > 0) {
                        $articulos = array();
                        $data["orden_prod"] = $data_orden[0]['ord_codigo'];
                        foreach ($data_orden as $key => $value) {
                            array_push($articulos, ($value['art_codigo'] . ' - ' . $value['art_nombre']));
                        }
                        $data["art_orden"] = implode(',', $articulos);
                    }
                }
            } else {
                $data['requisicion'] = null;
                $data['requisiciones'] = "";
            }
            $data['orden'] = $orden_compra[0];
            $usuario = $this->inventario_model->informacion_empleado($orden_compra[0]['orc_id_usu_solicita']);
            $data['usuarios'] = $usuario;
            $areas = $this->gsatelite->get_dropdown('are_area', 'are_nombre', '', array('are_estado' => 1), $orden_compra[0]['orc_id_are'], null, null, true);
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $areas);
            $data['condiciones'] = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), $orden_compra[0]['orc_id_cod'], null, null, true);
            $data['prioridades'] = $this->gsatelite->get_dropdown('prd_prioridad', '{prd_nombre}', '', array('prd_estado' => 1), $orden_compra[0]['orc_id_prd'], null, null, true);
            $data['categorias_padre'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_padre' => null), null, null, null, true);
            $data['gastos'] = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));
            $proveedores = $this->compras_model->get_proveedor_pers();
            $options = '<option value=""></option>';
            foreach ($proveedores as $key) {
                $cod = ($key['prv_id_cod'] != '') ? $key['prv_id_cod'] : $orden_compra[0]['orc_id_cod'];
                if ($key['pro'] != '') {
                    if ($orden_compra[0]['orc_id_prv'] == $key['prv_id']) {
                        $options .= '<option value="' . $key['prv_id'] . '" detalle="'.$key['det']. '" cod="' . $cod . '" selected>' . $key['pro'] . '</option>';
                    } else {
                        $options .= '<option value="' . $key['prv_id'] . '" detalle="'.$key['det']. '" cod="' . $cod . '" >' . $key['pro'] . '</option>';
                    }
                }
            }
            $data['proveedores'] = $options;
            $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
            $select_proyecto = '<option value=""></option>';
            foreach ($proyectos_reg as $key) {
                $selected = ($orden_compra[0]['orc_id_pcl'] == $key['pcl_id'])?'selected':'';
                $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
                $nombre = $key['pcl_codigo'] . ' - ' . $$key['pcl_nombre'];
                $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
            }
            $data['proyectos'] = $select_proyecto;
            $select_inr = $this->gsatelite->get_dropdown('inr_incoterms', '{inr_nombre}', '', array('inr_estado' => 1), $orden_compra[0]['orc_id_inr'], null, 'inr_id', true);
            $select_ttr = $this->gsatelite->get_dropdown('ttr_tipo_transporte', '{ttr_nombre}', '', array('ttr_estado' => 1), $orden_compra[0]['orc_id_ttr'], null, 'ttr_id', true);
            $data['incoterms']    = str_replace('<option value="0">Seleccione</option>', '', $select_inr);            
            $data['transportes']  = str_replace('<option value="0">Seleccione</option>', '', $select_ttr);            
            $tipo_fact = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1,'tif_aplica_compra' => 1), $orden_compra[0]['orc_id_tif'], null, null, true);
            $tipo_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago',    '{tpg_nombre}', '', array('tpg_estado' => 1), $orden_compra[0]['orc_id_tpg'], null, null, true);
            $cent_cost = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), $orden_compra[0]['orc_id_cec'], null, null, true);
            $data['existe_det']   = $this->gsatelite->get_campo('orc_orden_compra','orc_detalle_condicion',Array('orc_id'=>$orc_id));
            $data['tipo_factura'] = $tipo_fact;
            $data['tipo_pago']    = $tipo_pago;
            $data['centro_costo'] = $cent_cost;            
            $select = "";
            $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
            foreach ($impuesto_campos as $key) {
                if ($key["imp_porcentaje"] > 0) {
                    $select .= "<option data-type='1' data-porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
                } else {
                    $select .= "<option data-type='0' data-porcentaje='" . $key["imp_valor"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                }
            }
            $slc_presupuesto = ($orden_compra[0]['orc_id_psp'] != "" )?$this->get_presupuestoxproyecto($orden_compra[0]['orc_id_pcl'], $orden_compra[0]['orc_id_psp']):'<option value=""></option>';
            $data['presupuesto'] = $slc_presupuesto;
            $slc_general                = ($orden_compra[0]['orc_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($orden_compra[0]['orc_id_psp'], $orden_compra[0]['orc_id_acg'],false,false):'<option value=""></option>';
            $data['general']            = $slc_general;
            $slc_especifica             = ($orden_compra[0]['orc_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($orden_compra[0]['orc_id_acg'], $orden_compra[0]['orc_id_psp'], $orden_compra[0]['orc_id_ace'],true):'<option value=""></option>';
            $data['especifica']         = $slc_especifica;
            $proyectos_reg              = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
            $data["impuestos"] = $select;
            $select = "";
            /* ************************************************** */
            /* Obtener los permisos para autorizar la requisicion */
            /* ************************************************** */
            $groupby = null;
            $orderby = null;
            $where   = null;
            // agrupador
            $groupby = 'rol_id';
            $where   = array('psf_orden'=>2, 'psf_id_flu'=>3, 'axr_id_acc'=>4, 'id'=>$this->tank_auth->get_user_id());
            $autorizar = $this->inventario_model->get_permisos_autorizar_requisicion($where, $groupby, $orderby);
            $data['autorizar'] = $autorizar;
            $data['parametro'] = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('ORDEN_COMPRA'));
            $ids_rxp = (isset($autorizar[0]['rxp_id']))? $autorizar[0]['rxp_id']:0;
            $where_acciones['rxp_id_psf'] = $autorizar[0]['psf_id'];
            $where_acciones['rxp_id in ('. $ids_rxp .')'] = null;
            $data['acciones_paso'] = $this->inventario_model->get_acciones_rol($where_acciones);//Acciones que puede realizar el usuario
            /* ************************************************** */            
            /* ************************************************** */
            $data['detalle_orden'] = $this->compras_model->get_detalle_orden_compra(array('dor_id_orc' => $orc_id));
            //anexos
            $data['anexos_orden'] = $this->gsatelite->get_tabla('aoc_anexo_orden_compra', array('aoc_id_orc' => $orc_id));
            $data['titulo_personal'] = 'Editar orden de compra';
            $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
            $this->_cargarvista($data);
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function prorrateo_gastos() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/prorrateo_gastos');

        $crud = new grocery_CRUD;

        $alias = array(
            'ptg_nombre' => 'Nombre',
            'ptg_fecha_registro' => 'Fecha registro',
            'ptg_estado' => 'Estado'
        );

        $colums = array(
            'ptg_nombre',
            'ptg_fecha_registro',
            'ptg_estado'
        );

        $crud->set_table('ptg_prorrateo_gasto')
        ->set_subject('Crear prorrateo de gastos')
        ->display_as($alias)
        ->columns($colums)
        ->field_type('ptg_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('ptg_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                //->set_relation_n_n('centros','dpr_detalle_prorrateo','cec_centro_costo','dpr_id_ptg','dpr_id_cec','cec_nombre')
        ->unset_delete()
        ->unset_add()
        ->unset_edit()
        ->unset_print()
        ->unset_export()

        ;
        $crud->where(array('ptg_estado' => 1));
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('ptg_estado', 'hidden', 1)
            ->field_type('ptg_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('ptg_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('ptg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if ($permisos['permite_agregar']) {
            $data['agregar'] = true;
        }
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_compras/procesos/editar_prorrateo', '');
        }
        if ($permisos['permite_eliminar']) {
            $crud->add_action('Borrar', 'icomoon-icon-remove', 'modulo_compras/procesos/borrar_prorrateo', 'btn-eliminar');
        }
        if ($permisos['permite_ver']) {

        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Crear prorrateo de gastos';
        $this->_cargarvista($data, $output);
    }

    public function crear_prorrateo($prorrateo_id = "") {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            $usuario_id = $this->tank_auth->get_user_id();

            //insertar prorrateo
            $prorrateo_id = $this->compras_model->insertar_prorrateos_gastos($post_array['txtNombre'], $usuario_id);
            //ingresar articulos prorrateo
            $categoria = $post_array['slc_categoria'];

            $articulos_array = array();
            //verificar si se a preseleccionado la categoria para obtener el select a utilizar
            if ( $categoria != null) {
                $articulos_array    = (isset($post_array['slcproducto_servicio'])?$post_array['slcproducto_servicio']:null);
            } else {
                $articulos          = $post_array['slcproducto_servicio_ajax'];
                if ( $articulos != "" ){
                    $articulos_array    = explode(",", $articulos);
                }
            }
            //insertar articulos
            if ( count($articulos_array) > 0 ){
                $dpa_detalle_prorrateo_art = array();
                foreach(  $articulos_array  as $articulo){
                    $dpa_detalle_prorrateo_art[] = array(
                        'dpa_id_ptg'            => $prorrateo_id,
                        'dpa_id_art'            => $articulo,
                        'dpa_estado'            => 1,
                        'dpa_usu_creacion'      => $usuario_id,
                        'dpa_usu_modificacion'  => $usuario_id,
                        'dpa_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'dpa_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                }
                $this->gsatelite->ingresar("dpa_detalle_prorrateo_art",$dpa_detalle_prorrateo_art,true);
            } else {
                //verificar si se se selecciono la categoria
                //si trae categoria y no trae productos se insertaran todos los articulos de esa categoria
                if ($categoria != ""){
                    $dpa_detalle_prorrateo_art  = array();
                    $articulos_array            = null;
                    //obtener los articulos de una categoria seleccionada
                    $articulos_array            = $this->gsatelite->get_tabla("art_articulo",array("art_estado " => 1, "art_id_tia" => $categoria) );

                    if ( count($articulos_array) > 0 ){
                        $dpa_detalle_prorrateo_art = array();
                        foreach(  $articulos_array  as $articulo){
                            $dpa_detalle_prorrateo_art[] = array(
                                'dpa_id_ptg'            => $prorrateo_id,
                                'dpa_id_art'            => $articulo["art_id"],
                                'dpa_estado'            => 1,
                                'dpa_usu_creacion'      => $usuario_id,
                                'dpa_usu_modificacion'  => $usuario_id,
                                'dpa_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'dpa_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );
                        }
                        $this->gsatelite->ingresar("dpa_detalle_prorrateo_art",$dpa_detalle_prorrateo_art,true);
                    }
                }
            }

            if ($prorrateo_id != "") {
                $this->compras_model->insertar_detalle_prorrateo($post_array, $prorrateo_id, $usuario_id);
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Se ha guardardo correctamente.");
                $this->session->set_flashdata($alerta);
                if ($data['btnGuardar'] == 0) {
                    redirect('modulo_compras/procesos/prorrateo_gastos');
                } else {
                    redirect('modulo_compras/procesos/crear_prorrateo', refresh);
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Se produjo un error interno.");
                $this->session->set_flashdata($alerta);
                redirect('modulo_compras/procesos/prorrateo_gastos');
            }
        } else {
            $where = null;
            $articulo_compra = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_compra' => 1));
            $id_categorias   = array_unique(array_column($articulo_compra, 'art_id_tia'));
            // $where['cnt_id_tcn'] = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));                        
                                       $this->db->where_in('tia_id', $id_categorias);
            $data['categorias']      = $this->gsatelite->get_tabla("tia_tipo_articulo", array('tia_estado' => 1) );
            $data['cuentas']         = $this->utm_model->get_cuentas_like_prorrateo_gral($where);                            
            $data['tipo_cnt']        = $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('GASTO'));
            $data['centro_costo']    = $this->gsatelite->get_tabla("cec_centro_costo", array('cec_estado' => 1) );
            $data['titulo_personal'] = 'Crear prorrateo de gastos';
            $this->_cargarvista($data);
        }
    }

    public function editar_prorrateo($prorrateo_id = "") {
        satelite_validar();
        if ($_POST) {
            //print_r($_POST); die();
            $post_array = $this->input->post();

            $usuario_id = $this->tank_auth->get_user_id();
            $dato_prorrateo = array(
                'ptg_nombre'            => $post_array['txtNombre'],
                'ptg_estado'            => $post_array['slcEstado'],
                'ptg_usu_modificacion'  => $usuario_id,
                'ptg_fecha_modificacion'=> date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('ptg_prorrateo_gasto', $dato_prorrateo, array('ptg_id' => $post_array['txtProrrateo']));

            //actualizar articulos
            //obtener articulos antigutos
            $articulos_old  = $this->gsatelite->get_tabla('dpa_detalle_prorrateo_art',array('dpa_estado' => 1, 'dpa_id_ptg' => $post_array['txtProrrateo']));

            $categoria      = $post_array['slc_categoria'];

            $articulos_array = array();
            //verificar si se a preseleccionado la categoria para obtener el select a utilizar
            if ( $categoria != null) {
                $articulos_array    = (isset($post_array['slcproducto_servicio'])?$post_array['slcproducto_servicio']:null);
            } else {
                $articulos          = $post_array['slcproducto_servicio_ajax'];
                if ( $articulos != "" ){
                    $articulos_array    = explode(",", $articulos);
                }
            }
            //borrar antiguos
            if (count( $articulos_old) >0){
                foreach ($articulos_old as $value) {
                    $this->gsatelite->borrado_general('dpa_detalle_prorrateo_art', array('dpa_id_art' =>$value['dpa_id_art'], 'dpa_id_ptg' => $post_array['txtProrrateo']) );
                }
            }

            //insertar articulos
            if ( count($articulos_array) > 0 ){
                $dpa_detalle_prorrateo_art = array();
                foreach(  $articulos_array  as $articulo){
                    $dpa_detalle_prorrateo_art[] = array(
                        'dpa_id_ptg'            => $post_array['txtProrrateo'],
                        'dpa_id_art'            => $articulo,
                        'dpa_estado'            => 1,
                        'dpa_usu_creacion'      => $usuario_id,
                        'dpa_usu_modificacion'  => $usuario_id,
                        'dpa_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'dpa_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                }

                $this->gsatelite->ingresar("dpa_detalle_prorrateo_art",$dpa_detalle_prorrateo_art,true);
            } else {
                //verificar si se se selecciono la categoria
                //si trae categoria y no trae productos se insertaran todos los articulos de esa categoria
                if ($categoria != ""){
                    $dpa_detalle_prorrateo_art  = array();
                    $articulos_array            = null;
                    //obtener los articulos de una categoria seleccionada
                    $articulos_array            = $this->gsatelite->get_tabla("art_articulo",array("art_estado " => 1, "art_id_tia" => $categoria) );

                    if ( count($articulos_array) > 0 ){
                        $dpa_detalle_prorrateo_art = array();
                        foreach(  $articulos_array  as $articulo){
                            $dpa_detalle_prorrateo_art[] = array(
                                'dpa_id_ptg'            => $post_array['txtProrrateo'],
                                'dpa_id_art'            => $articulo["art_id"],
                                'dpa_estado'            => 1,
                                'dpa_usu_creacion'      => $usuario_id,
                                'dpa_usu_modificacion'  => $usuario_id,
                                'dpa_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'dpa_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );
                        }
                        $this->gsatelite->ingresar("dpa_detalle_prorrateo_art",$dpa_detalle_prorrateo_art,true);
                    }
                }
            }

            //obtener todos los detalles con los centros de costo

            $prorrateos_originales = $this->gsatelite->get_tabla('dpr_detalle_prorrateo', array('dpr_id_ptg' => $post_array['txtProrrateo']));

            $dpr_id         = $post_array['id_detalle'];
            $dpr_id_cec     = $post_array['txt_centro_costo'];
            $dpr_porcentaje = $post_array['porcentaje'];
            $dpr_cuenta = $post_array['txt_cuenta_contable'];

            //recorrer  paraver rificar si viene un faltante, si no esta...es porque se elimino en la vista.
            if (count( $prorrateos_originales) >0){
                foreach ($prorrateos_originales as $value) {
                    if (!in_array($value['dpr_id'], $dpr_id)) {
                        $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dpr' => $value['dpr_id']));
                        $this->gsatelite->borrado_general('pxt_prorrateoxarticulo_cotizacion', array('pxt_id_dpr' => $value['dpr_id']));
                        $this->gsatelite->borrado_general('dpr_detalle_prorrateo', array('dpr_id' => $value['dpr_id']));
                    }
                }
            }
            //Actualizar
            foreach ( $dpr_id as $key => $value){
                if ($value != "") {
                    $dpr_detalle_prorrateo = array(
                        //'dpr_id_ptg'            => $post_array['txtProrrateo'],
                        //'dpr_id_cec'            => $dpr_id_cec[$key],
                        'dpr_porcentaje'        => substr($dpr_porcentaje[$key], 0, -1),
                        'dpr_id_cnt'        => $dpr_cuenta[$key],
                        //'dpr_estado'            => 1,
                        'dpr_usu_modificacion'  => $usuario_id,
                        'dpr_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('dpr_detalle_prorrateo', $dpr_detalle_prorrateo, array('dpr_id' => $value) );
                } else {
                    $dpr_detalle_prorrateo = array(
                        'dpr_id_ptg'            => $post_array['txtProrrateo'],
                        'dpr_id_cec'            => $dpr_id_cec[$key],
                        'dpr_id_cnt'            => $dpr_cuenta[$key],
                        'dpr_porcentaje'        => substr($dpr_porcentaje[$key], 0, -1),
                        'dpr_estado'            => 1,
                        'dpr_usu_creacion'      => $usuario_id,
                        'dpr_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'dpr_usu_modificacion'  => $usuario_id,
                        'dpr_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('dpr_detalle_prorrateo', $dpr_detalle_prorrateo);
                }
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Se ha guardardo correctamente.");
            $this->session->set_flashdata($alerta);
            if ($post_array['txt_tipo_guardado'] == 2) {
                redirect('modulo_compras/procesos/prorrateo_gastos');
            } else {
                redirect('modulo_compras/procesos/editar_prorrateo/'.$post_array['txtProrrateo']);
            }
        } else {
            $articulo_compra = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_compra' => 1));
            $id_categorias   = array_unique(array_column($articulo_compra, 'art_id_tia'));
                                         $this->db->where_in('tia_id', $id_categorias);
            $data['categorias']        = $this->gsatelite->get_tabla("tia_tipo_articulo", array('tia_estado' => 1) );
            $data['prorrateo']         = $this->gsatelite->get_registro('ptg_prorrateo_gasto', array('ptg_id' => $prorrateo_id));
            $data['detalle_prorrateo'] = $this->compras_model->obtener_detalleprorrateo($prorrateo_id);   
            $data['centro_costo']      = $this->gsatelite->get_tabla("cec_centro_costo", array('cec_estado' => 1) );

            $this->db->join('art_articulo','art_id = dpa_id_art');
            $articulos                  = $this->gsatelite->get_tabla("dpa_detalle_prorrateo_art", array('dpa_estado' => 1,'dpa_id_ptg' => $prorrateo_id) );
            //print_r($articulos); die();
            $data['articulos']          = $articulos;
            $categoria                  = array();
            $categoria_unica            = false;
            $categorias_pre_cargadas    = null;
            $articulos_array            = array();
            $articulos_json             = null;
            $i                          = 0;

            foreach ($articulos as $articulo) {
                if (!in_array($articulo['art_id_tia'], $categoria)) {
                    array_push ( $categoria , $articulo['art_id_tia'] );
                }
                array_push ( $articulos_array , $articulo['art_id'] );

                $articulos_json[$i]['id'] = $articulo['art_id'];
                $articulos_json[$i]['text'] = $articulo['art_nombre'];
                $i++;
            }

            //si solo posee 1 solo categoria entonces precargara un select multiple
            if ( count($categoria) == 1 ){
                $categoria_unica            = true;
                $categorias_pre_cargadas    = $this->gsatelite->get_tabla('art_articulo',array('art_estado' => 1,'art_id_tia' => $articulos[0]['art_id_tia']) );
            }

            $data['tipo_cnt'] = $idtipo_cnt  = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('GASTO'));            
            $data['categorias_pre_cargadas'] = $categorias_pre_cargadas;
            $data['articulos_array']         = $articulos_array;
            $data['categoria_unica']         = $categoria_unica;
            $data['articulos_json']          = json_encode($articulos_json);

            //cuentas en caso de traer detalle de prorrateo
            //print_r($articulos); die();
            $where =  null;
            if(count($articulos) > 0){
                $where['tia_id'] = $articulos[0]['art_id_tia'];
                // $where['dta_id_tcn'] = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));
                //print_r($where['cnt_id_tcn']); die();
                $data['cuentas']            = $this->utm_model->get_cuentas_like_prorrateo_gral_edit($where);
            }else{
                //$where['cnt_id_tcn'] = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));            
                $data['cuentas']            = $this->utm_model->get_cuentas_like_prorrateo_gral($where);                            
            }

            $data['titulo_personal']        = 'Editar prorrateo de los gastos';
            $this->_cargarvista($data);
        }
    }

    public function borrar_prorrateo($id_prorrateo) {
        //$this->gsatelite->borrado_general('dpr_detalle_prorrateo', array('dpr_id_ptg' => $id_prorrateo));
        //$this->gsatelite->borrado_general('ptg_prorrateo_gasto', array('ptg_id' => $id_prorrateo));
        $update = $this->gsatelite->actualizar_array('ptg_prorrateo_gasto',array('ptg_estado' => -1),array('ptg_id' => $id_prorrateo));
        if ($update) {
             $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Se borro el registro correctamente.");
        }else{
             $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No pudimos borrar el registro.");
        }
       
        $this->session->set_flashdata($alerta);
        redirect('modulo_compras/procesos/prorrateo_gastos');
    }

    public function consultar_articulos($servicio = "") {
        $articulo = $this->input->post('articulo');
        $result = $this->compras_model->get_articulo_like($articulo, $servicio);
        echo json_encode($result);
    }

    public function consultar_articulos_compras($servicio = "") {
        $articulo = $this->input->post('articulo');
        $result = $this->compras_model->get_articulo_like($articulo, $servicio, array('art_compra' => 1));
        echo json_encode($result);
    }

    public function registro_contratos() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/registro_contratos');

        $crud = new grocery_CRUD;

        $alias = array(
            'cop_numero' => 'Número',
            //'cop_id_prv' => 'Proveedor',
            'proveedor' => 'Proveedor',
            'cop_id_art' => 'Servicio',
            'cop_fecha_inicio' => 'Fecha inicio',
            'cop_fecha_fin' => 'Fecha fin',
            //'cop_fecha_facturacion' => 'Fecha de facturación',
            'cop_saldo_inicial' => 'Saldo inicial',
            'cop_cuota_mensual' => 'Cuota mensual',
            'saldo_actual' => 'Saldo Actual',
            'cop_estado' => 'Estado',
        );

        $colums = array(
            'cop_numero',
            'proveedor',
            'cop_id_art',
            'cop_fecha_inicio',
            'cop_fecha_fin',
            //'cop_fecha_facturacion',
            'cop_saldo_inicial',
            'cop_cuota_mensual',
            'saldo_actual',
            'cop_estado'
        );

        $crud->callback_column('proveedor', function($value, $row) {
            $result = "";
            $fila = (array) $row;
            $valor = end($fila);
            $result_array = explode('#', $valor, 3);
            $result = ($result_array[2] == 1) ? $result_array[0] . " " . $result_array[1] : $result_array[1];
            return $result;
        });

        $crud->callback_column('saldo_actual', function($value, $row) {
            $result = "";
            $suma = $this->compras_model->get_sum_dxd_detalle_documento_proveedor(array('cop_id' => $row->cop_id));
            $saldo_pagado = $row->cop_saldo_inicial - $suma[0]['suma'];
            $result = number_format((($saldo_pagado > 0)? $saldo_pagado : 0),2);
            return $result;
        });

        //$crud->callback_column('cop_fecha_inicio', array($this, '_column_to_date_comparativo'));

        $crud->set_table('cop_contrato_proveedor')
        ->set_subject('Contrato por proveedor')
        ->display_as($alias)
        ->columns($colums)
        ->field_type('cop_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('cop_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->set_relation('cop_id_art', 'art_articulo', 'art_nombre')
                ->set_relation('cop_id_prv', 'prv_proveedor', '{prv_nombre}#{prv_apellido}#{prv_tipo_pers}')//debe ser el ultimo set_relation
                ->unset_delete()
                ->unset_add()
                ->unset_edit()
                ->unset_print()
                ->unset_export()

                ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('cop_estado', 'hidden', 1)
                    ->field_type('cop_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cop_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'));
                } else {
                    $crud->field_type('cop_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $crud->callback_column('cop_fecha_inicio', array($this, '_callback_fecha'));
                $crud->callback_column('cop_fecha_fin', array($this, '_callback_fecha'));
                $crud->callback_column('cop_fecha_facturacion', array($this, '_callback_fecha'));
                $crud->callback_column('cop_id_prv', array($this, '_callback_proveedor'));

        //$ccv_cuota_contrato_proveedor = $this->gsatelite->get_tabla("ccv_cuota_contrato_proveedor");
        // Validaciones
                if ($permisos['permite_agregar']) {
                    $data['agregar'] = true;
                }
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_compras/procesos/editar_registro_contratos', 'editar-class', null, null, array('cop_generado' => 0,'cop_estado' => 'Activo'));
                }
                if ($permisos['permite_eliminar']) {
            // $crud->add_action('Inactivar', 'icomoon-icon-arrow-down', 'modulo_compras/procesos/inactivar_registro_contratos', 'btn-eliminar');
                }

                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'icon16 icomoon-icon-search-5', 'modulo_compras/procesos/ver_registro_contratos', '');
                }
                $crud->add_action('Generar', 'icomoon-icon-plus', 'modulo_compras/procesos/cuotas_contratos', 'agregar-class', null, null, array('cop_generado' => 0,'cop_estado' => 'Activo'));

                $crud->add_action('Detalles', 'icomoon-icon-notebook', 'modulo_compras/procesos/detalle_contrato_proveedor', 'detalle-class', null, null,array('cop_generado' => 1,'cop_estado' => 'Activo') );

                $crud->add_action('Anular', 'icomoon-icon-cancel-3', 'modulo_compras/procesos/anular_contrato_proveedor', 'anular-class', null, null, array('cop_estado' => 'Activo'));

                $output = $crud->render();


                $data['titulo_personal'] = 'Contrato por proveedor';
                $this->_cargarvista($data, $output);
            }

            public function agregar_registro_contratos() {
                satelite_validar();
                if ($_POST) {
                    $post_array = $this->input->post();
                    $usuario_id = $this->tank_auth->get_user_id();

                    $numero = $this->gsatelite->count("cop_contrato_proveedor");
                    $numero++;
                    $numero_calculado = generar_codigo_cor($numero, 4);

                    $datos_contratos = array(
                        'cop_id_prv' => $post_array['slcProveedor'],
                        'cop_id_art' => $post_array['slc_servicio'],
                        'cop_id_tif' => ($post_array['slcTipoDocumento'] != '')? $post_array['slcTipoDocumento'] : null,
                        'cop_id_tpg' => ($post_array['slcTipoPago'] != '')? $post_array['slcTipoPago'] : null,
                        'cop_numero' => $numero_calculado,
                        'cop_codigo' => $post_array['txtCodigo'],
                        'cop_fecha_inicio' => date('Y-m-d', strtotime($post_array['txtFecha_inicio'])),
                        'cop_fecha_fin' => date('Y-m-d', strtotime($post_array['txtFecha_fin'])),
                        'cop_saldo_inicial' => $post_array['txtSaldo_inicial'],
                        'cop_fecha_facturacion' => ($post_array['txtFecha_facturacion'] != '')? date('Y-m-d', strtotime($post_array['txtFecha_facturacion'])) : null,
                        'cop_cuota_mensual' => $post_array['txtCuota_mensual'],
                        'cop_descripcion' => ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : "",
                        'cop_estado' => 1,
                        'cop_usu_creacion' => $usuario_id,
                        'cop_usu_modificacion' => $usuario_id,
                        'cop_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cop_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
            //print_r($datos_contratos);die();
                    $id_contrato = $this->gsatelite->ingresar('cop_contrato_proveedor', $datos_contratos);
            //Anexos
                    if ($post_array['slcImpuestos'] != '') {
                        for ($i=0; $i < count($post_array['slcImpuestos']) ; $i++) { 
                            $datos = array('itv_id_cop' => $id_contrato,
                               'itv_id_imp' => $post_array['slcImpuestos'][$i],
                               'itv_estado' => 1,
                               'itv_usu_creacion' => $usuario_id,
                               'itv_fecha_creacion' => date('Y-m-d H:i:s'),
                               'itv_usu_modificacion' => $usuario_id,
                               'itv_fecha_modificacion' => date('Y-m-d H:i:s'),
                           );
                            $id_impuesto_Contrato = $this->gsatelite->ingresar('itv_impuesto_contrato_proveedor', $datos);
                        }
                    }

                    if (isset($post_array['titulo_doc'])) {
                        for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                            $carpeta_temporal_anx = "public/temp/anexo_contrato/" . trim($post_array['ruta'][$i]);
                            $carpeta_destino_anx = "uploads/anexo_contrato/" . trim($post_array['ruta'][$i]);

                            $datos_anexo = array(
                                'anc_id_cop' => $id_contrato,
                                'anc_url' => $carpeta_destino_anx,
                                'anc_nombre' => $post_array['titulo_doc'][$i],
                                'anc_estado' => 1,
                                'anc_usu_creacion' => $usuario_id,
                                'anc_usu_modificacion' => $usuario_id,
                                'anc_fecha_creacion' => date('Y-m-d H:i:s'),
                                'anc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('anc_anexo_contrato', $datos_anexo);

                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Se agregó el contrato número " . $numero_calculado . " correctamente");
                    $this->session->set_flashdata($alerta);
                    if ($post_array['btnGuardar'] == 2) {
                        redirect('modulo_compras/procesos/registro_contratos');
                    }
                    redirect('modulo_compras/procesos/agregar_registro_contratos', refresh);
                } else {
                    $numero = $this->gsatelite->count("cop_contrato_proveedor");
                    $numero++;
                    $data['numero'] = generar_codigo_cor($numero, 4);
                    $data['titulo_personal'] = 'Contrato por proveedor';
                    $data['proveedor'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
                    $tipo_documento         = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1,'tif_aplica_compra' => 1) );

                    $select_documento       = '<option value = ""></option>';
                    foreach ($tipo_documento as $key => $tipo) {
                        $select_documento   .= '<option value = "'.$tipo["tif_id"].'" data-abreviatura="'.$tipo["tif_abreviacion"].'">'.$tipo["tif_nombre"].'</option>';
                    }

                    $data['tipo_documento'] = $select_documento;
                    $data['tipo_pago']      = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', 'pagos', array('tpg_estado' => 1), null, null, null, true);

                    $impuestos_categoria = $this->gsatelite->get_tabla('imp_impuesto');
                    $impuestos = "";
                    foreach ($impuestos_categoria as $key => $value) {
                        $temp = (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]);
                        if($temp != ''){
                //$impuestos .= '<option data-id="' . $value['ixr_id'] . '" data-porcentaje="' . $value['imp_porcentaje'] . '" value="' . $value['imp_id'] . '" '.if($value["ixr_id"]){ echo "selected"}.'>' . $value['imp_nombre'] . '</option>';
                            if (isset($value['ixr_id']) && $value['ixr_id']) {
                                $impuestos .= '<option data-id="' . $value['ixr_id'] . '" data-porcentaje="' . (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]) . '" data-type="'.(((float)$value["imp_porcentaje"] != 0)?1:0).'" value="' . $value['imp_id'] . '" selected>' . $value['imp_nombre'] . '</option>';
                            } else {
                                $impuestos .= '<option data-id="" data-porcentaje="' . (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]) . '" data-type="'.(((float)$value["imp_porcentaje"] != 0)?1:0).'" value="' . $value['imp_id'] . '" >' . $value['imp_nombre'] . '</option>';
                            }
                        }
                    }
                    $data['impuestos'] = $impuestos;

                    $this->_cargarvista($data);
                }
            }

            public function editar_registro_contratos($contrato = "") {
                satelite_validar();
                if ($_POST) {
                    $post_array = $this->input->post();
                    $usuario_id = $this->tank_auth->get_user_id();
                    $datos_contratos = array(
                        'cop_codigo' => $post_array['txtCodigo'],
                        'cop_id_prv' => $post_array['slcProveedor'],
                        'cop_id_art' => $post_array['slc_servicio'],
                        'cop_id_tif' => $post_array['slcTipoDocumento'],
                        'cop_id_tpg' => $post_array['slcTipoPago'],
                        'cop_fecha_inicio' => date('Y-m-d', strtotime($post_array['txtFecha_inicio'])),
                        'cop_fecha_fin' => date('Y-m-d', strtotime($post_array['txtFecha_fin'])),
                        'cop_saldo_inicial' => $post_array['txtSaldo_inicial'],
                        'cop_fecha_facturacion' => date('Y-m-d', strtotime($post_array['txtFecha_facturacion'])),
                        'cop_cuota_mensual' => $post_array['txtCuota_mensual'],
                        'cop_descripcion' => ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : "",
                        'cop_estado' => ($post_array['slc_Estado'] == 1) ? $post_array['slc_Estado'] : 0,
                        'cop_usu_modificacion' => $usuario_id,
                        'cop_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cop_contrato_proveedor', $datos_contratos, array('cop_id' => $post_array['txtContrato']));
            //obtener todos los detalles
                    $contratos_originales = $this->gsatelite->get_tabla('anc_anexo_contrato', array('anc_id_cop' => $post_array['txtContrato']));

                    $documentos = (isset($post_array['anc_id']) ) ? $post_array['anc_id'] : "";

                    $this->gsatelite->borrado_general('itv_impuesto_contrato_proveedor', array('itv_id_cop'=> $post_array['txtContrato']));

                    if ($post_array['slcImpuestos'] != '') {
                        for ($i=0; $i < count($post_array['slcImpuestos']) ; $i++) { 
                            $datos = array('itv_id_cop' => $post_array['txtContrato'],
                               'itv_id_imp' => $post_array['slcImpuestos'][$i],
                               'itv_estado' => 1,
                               'itv_usu_creacion' => $usuario_id,
                               'itv_fecha_creacion' => date('Y-m-d H:i:s'),
                               'itv_usu_modificacion' => $usuario_id,
                               'itv_fecha_modificacion' => date('Y-m-d H:i:s'),
                           );
                            $id_impuesto_Contrato = $this->gsatelite->ingresar('itv_impuesto_contrato_proveedor', $datos);
                        }
                    }

            //recorrer  para verrificar si viene un faltante, si no esta...es porque se elimino en la vista.
                    for ($i = 0; $i < count($contratos_originales); $i++) {
                        if (in_array($contratos_originales[$i]['anc_id'], $documentos)) {

                        } else {
                            $carpeta_destino = $contratos_originales[$i]['anc_url'];
                            unlink($carpeta_destino);
                            $this->gsatelite->borrado_general('anc_anexo_contrato', array('anc_id' => $contratos_originales[$i]['anc_id']));
                        }
                    }
            //Insertar nuevos
                    if (isset($post_array['titulo_doc'])) {
                        for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                            $carpeta_temporal_anx = "public/temp/anexo_contrato/" . trim($post_array['ruta'][$i]);
                            $carpeta_destino_anx = "uploads/anexo_contrato/" . trim($post_array['ruta'][$i]);

                            $datos_anexo = array(
                                'anc_id_cop' => $post_array['txtContrato'],
                                'anc_url' => $carpeta_destino_anx,
                                'anc_nombre' => $post_array['titulo_doc'][$i],
                                'anc_estado' => 1,
                                'anc_usu_creacion' => $usuario_id,
                                'anc_usu_modificacion' => $usuario_id,
                                'anc_fecha_creacion' => date('Y-m-d H:i:s'),
                                'anc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('anc_anexo_contrato', $datos_anexo);

                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }

                    $numero = $post_array['txtNumero'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Se editó el contrato número " . $numero . " correctamente");
                    $this->session->set_flashdata($alerta);
                    if ($post_array['btnGuardar'] == 2) {
                        redirect('modulo_compras/procesos/registro_contratos');
                    }
                    redirect('modulo_compras/procesos/editar_registro_contratos/' . $post_array['txtContrato']);
                } else {
                    $data['titulo_personal'] = 'Contrato por proveedor';
                    $data['contratos'] = $this->compras_model->get_contratos_proveedor($contrato);
                    $data['detalle_contratos'] = $this->gsatelite->get_tabla('anc_anexo_contrato', array('anc_id_cop' => $contrato));
                    $data['proveedor'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
            //$data['proveedor'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}', 'prv_nombre', array('prv_estado' => 1), $data['contratos'][0]['cop_id_prv'], null, 'prv_id', true);
                    $data['tipo_documento'] = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1));
                    $data['tipo_pago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_estado' => 1));
                    $impuestos_seleccionados = $this->gsatelite->get_tabla('itv_impuesto_contrato_proveedor', array('itv_estado' => 1,'itv_id_cop' => $contrato));
                    foreach ($impuestos_seleccionados as $key) {
                        $data['id_impuesto'][] = $key['itv_id_imp'];
                    }
            //print_r($data['id_impuesto']);die();
                    $impuestos_categoria = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
                    $data['impuestos'] = $impuestos_categoria;


                    $this->_cargarvista($data);
                }
            }

            public function ver_registro_contratos($contrato = "") {
                satelite_validar();
                if ($_POST) {
                    redirect('modulo_compras/procesos/registro_contratos');
                } else {
                    $data['titulo_personal'] = 'Contrato por proveedor';
                    $data['contratos'] = $this->compras_model->get_contratos_proveedor($contrato);
                    $data['detalle_contratos'] = $this->gsatelite->get_tabla('anc_anexo_contrato', array('anc_id_cop' => $contrato));
                    $data['proveedor'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
            //$data['proveedor'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre}', 'prv_nombre', array('prv_estado' => 1), $data['contratos'][0]['cop_id_prv'], null, 'prv_id', true);
                    $data['tipo_documento'] = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1));
                    $data['tipo_pago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_estado' => 1));
                    $impuestos_seleccionados = $this->gsatelite->get_tabla('itv_impuesto_contrato_proveedor', array('itv_estado' => 1,'itv_id_cop' => $contrato));
                    foreach ($impuestos_seleccionados as $key) {
                        $data['id_impuesto'][] = $key['itv_id_imp'];
                    }
            //print_r($data['id_impuesto']);die();
                    $impuestos_categoria = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
                    $data['impuestos'] = $impuestos_categoria;
                    $this->_cargarvista($data);
                }
            }

            public function inactivar_registro_contratos($id_contrato) {
                $this->gsatelite->actualizar_array('anc_anexo_contrato', array('anc_estado' => 0), array('anc_id_cop' => $id_contrato));
                $this->gsatelite->actualizar_array('cop_contrato_proveedor', array('cop_estado' => 0), array('cop_id' => $id_contrato));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Se inactivo el registro correctamente.");
                $this->session->set_flashdata($alerta);
                redirect('modulo_compras/procesos/registro_contratos');
            }

            public function get_impuestos($flag = false) {
        //Se obtienen los impuestos activos
                $impuestos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));

                $etiqueta = 0;
                $impuestos_opciones = "";
                if (count($impuestos) > 0) {
                    foreach ($impuestos as $imp) {
                        $impuestos_opciones .= "<option data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "' id='opt_imp" . $etiqueta . "'>" . $imp['imp_nombre'] . "</option>";
                        $etiqueta++;
                    }
                }

                $arreglo = array('impuestos' => $impuestos_opciones);

                if (!$flag) {
                    echo json_encode($arreglo);
                } else {
                    return $arreglo;
                }
            }

    function documentos_proveedor($orc_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/documentos_proveedor');
            if ($orc_id != null) {
                $documentos_proveedor_reg = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_orc'=>$orc_id));
            } else {
                $documentos_proveedor_reg = array();
            }
            if (count($documentos_proveedor_reg) > 0) {
                if ($orc_id > 0) {
                    redirect('/modulo_compras/procesos/documentos_proveedor');
                }
            } else {
                if ($orc_id > 0) {
                    redirect('/modulo_compras/procesos/agregar_doc_proveedor/'.$orc_id.'/1');
                }
            }
            if ($_POST) {
                $post_array = $_POST;
                //Crear filtro por las fechas del documento.
                //Filtro 1 = fecha de creacion, 2 = fecha del documento, 3 = fecha de contabilidad, 4 = fecha de vencimiento
                $filtro      = $post_array['filtro'];
                $fecha_inicio= $post_array['fecha_ini'];
                $fecha_fin   = $post_array['fecha_fin'];
                $caja_chica  = $post_array['cj_chica'];
                $where       = null;
                if ($orc_id > 0) {
                    $where['dpv_id_orc'] = $orc_id;
                } else {
                    $data['no_orden_compra']= 1;
                }
                if ($filtro == 1 && $fecha_inicio != null && $fecha_fin != null) {
                    $where['date_format(dpv_fecha_creacion,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['date_format(dpv_fecha_creacion,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                } else if ($filtro == 2 && $fecha_inicio != null && $fecha_fin != null) {
                    $where['date_format(dpv_fecha_documento,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['date_format(dpv_fecha_documento,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                } else if ($filtro == 3 && $fecha_inicio != null && $fecha_fin != null) {
                    $where['date_format(dpv_fecha_contabilizacion,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['date_format(dpv_fecha_contabilizacion,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                } else if ($filtro == 4 && $fecha_inicio != null && $fecha_fin != null) {
                    $where['date_format(dpv_fecha_vencimiento,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['date_format(dpv_fecha_vencimiento,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                }
                if ($caja_chica != "") {
                    if ($caja_chica > 0) {
                        $where['dpv_id_cch'] = $caja_chica;
                    } else {
                        $where['dpv_id_cch IS NULL'] = null;
                        
                    }
                }
                $data['documentos'] = $this->compras_model->get_grid_documentos_proveedor($where);
                $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
                $data['pdecimal'] = 2;
                $html = $this->load->view('modulo_compras/procesos/consultar_doc_proveedor', $data, true);
                echo $html;
                die();
            } else {
                $cjchicas = $this->gsatelite->get_dropdown('cch_caja_chica', 'cch_nombre', '', array('cch_estado' => 1), null, '', 'cch_id', true);
                $data['cajas_chicas']    = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cjchicas);
                $reg_orden_compra        = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
                $subtitulo               = (count($reg_orden_compra) > 0) ? ' - # de Orden de Compra ' . $reg_orden_compra[0]['orc_numero'] : '';
                $data['titulo_personal'] = 'Documentos por proveedor'.$subtitulo;
                $data['orden_compra']    = $orc_id;
                $this->_cargarvista($data);
            }
        }
    }

    function suj_exc_proveedor() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            $post_array = $_POST;
            //Filtro 1 = fecha de creacion, 2 = fecha del documento, 3 = fecha de contabilidad, 4 = fecha de vencimiento
            $filtro     = $post_array['filtro'];
            $fecha_ini  = $post_array['fecha_ini'];
            $fecha_fin  = $post_array['fecha_fin'];
            $where      = null;
            $data['no_orden_compra'] = 1;
            if ($filtro == 1 && $fecha_ini != null && $fecha_fin != null) {
                $where['DATE(dpv_fecha_creacion) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
                $where['DATE(dpv_fecha_creacion) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            } else if ($filtro == 2 && $fecha_ini != null && $fecha_fin != null) {
                $where['DATE(dpv_fecha_documento) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
                $where['DATE(dpv_fecha_documento) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            } else if ($filtro == 3 && $fecha_ini != null && $fecha_fin != null) {
                $where['DATE(dpv_fecha_contabilizacion) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
                $where['DATE(dpv_fecha_contabilizacion) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            } else if ($filtro == 4 && $fecha_ini != null && $fecha_fin != null) {
                $where['DATE(dpv_fecha_vencimiento) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
                $where['DATE(dpv_fecha_vencimiento) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            $data['documentos'] = $this->compras_model->get_grid_documentos_proveedor($where);
            $data['pdecimal'] = 2;
            $html = $this->load->view('modulo_compras/procesos/consultar_doc_proveedor', $data, true);
            echo $html;
            die();
        } else {
            $data['titulo_personal'] = 'Documentos por proveedor';
            $this->_cargarvista($data);
        }
    }

    public function print_facsujexcelect($dpv_id){
            satelite_validar();
            $this->load->library('EnLetras');
            $dpv = $this->facturacion_model->get_doc_dte_compra($dpv_id)[0];
            $dxd = $this->facturacion_model->get_cuerpo_dte_compra($dpv_id);
            $emr = $this->facturacion_model->get_empresa_dte($this->tank_auth->get_empresa_id())[0];
            $formato = $this->gsatelite->get_tabla('frf_formato_factura', array('frf_activo'=>1,'frf_factura_electronica'=>1,'frf_id_tif'=>$dpv['dpv_id_tif']))[0];
            $conf_tpg_array = json_decode($formato['frf_configuracion_tipo_pago'], true);
            $conf_formato_array = json_decode($formato['frf_configuraciones_formato'], true);
            $data['pdf'] = $this->pdf;
            $data['pdecimal'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $fuente = (isset($conf_formato_array['FUENTE']) != '') ? $conf_formato_array['FUENTE'] : "helvetica";
            $setCellPaddings =(isset($conf_formato_array['SETCELLPADDINGS']) != '') ? $conf_formato_array['SETCELLPADDINGS'] : '0,0,0,0';
            $data['datos_factura'] = $dpv;
            $data['emisor'] = $emr;
            $data['detalles'] = $dxd;
            $data['width_conf']  = $conf_formato_array['WIDTH'];
            $data['height_conf'] = $conf_formato_array['HEIGHT'];
            
            $html = $this->load->view('facturacion/facturar/' . $formato['frf_archivo'], $data, true);
            if(isset($conf_formato_array['SETCELLPADDINGS']) != '' || isset($conf_formato_array['FORMATO']) != ''){
                $formatop = $conf_formato_array['FORMATO'];
                $orientacion = $conf_formato_array['ORIENTACION'];
                $formato_array = explode(",",$formatop);
                $margins = $conf_formato_array['MARGINS'];
                $formatopage = (count($formato_array) > 1) ? $formato_array : $formatop;
                $m = explode(',', $margins); /// $margins = "0,0,0" pero lo toma como un solo valor
                $this->pdf->SetMargins($m[0],$m[1],$m[2]);
                $this->pdf->setPrintHeader(false);
                $this->pdf->SetFont($fuente);
                $this->pdf->setCellPaddings($setCellPaddings);
                $this->pdf->SetAutoPageBreak(true, 0);
                $this->pdf->AddPage($orientacion, $formatopage, array('family' => $fuente, 'style' => '', 'size' => 6) , true);
                $this->pdf->setPrintFooter(false);
                $this->pdf->writeHTML($html, true, false, false, false, '');
                $this->pdf->boletaPDF('I');
            } else {
                $this->pdf->setPrintFooter(false);
                $this->pdf->makePDF($html, $conf_formato_array['ORIENTACION'], null , 'Letter');
            }
        }

        public function print_comp_retrenc($cre_id){
            satelite_validar();
            $this->load->library('EnLetras');
            $cre = $this->facturacion_model->get_doc_dte_cre($cre_id)[0];
            $dcr = $this->facturacion_model->get_cuerpo_dte_compra_dcr($cre_id);
            $emr = $this->facturacion_model->get_empresa_dte($this->tank_auth->get_empresa_id())[0];// {"DOCUMENTO":"1",,,"SIZE_LETRA":"8",,"IVA":"5"}
            // $formato = $this->gsatelite->get_tabla('frf_formato_factura', array('frf_activo'=>1,'frf_factura_electronica'=>1,'frf_id_tif'=>$dpv['dpv_id_tif']))[0];
            // $conf_tpg_array = json_decode($formato['frf_configuracion_tipo_pago'], true);
            // $conf_formato_array = json_decode($formato['frf_configuraciones_formato'], true);
            $data['width_conf']  = 17;//$conf_formato_array['WIDTH'];
            $data['height_conf'] = 14;//$conf_formato_array['HEIGHT'];
            $fuente = (false && isset($conf_formato_array['FUENTE']) != '') ? $conf_formato_array['FUENTE'] : "helvetica";
            $setCellPaddings = (false && isset($conf_formato_array['SETCELLPADDINGS']) != '') ? $conf_formato_array['SETCELLPADDINGS'] : '0,0,0,0';
            $data['pdecimal'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $data['datos_factura'] = $cre;
            $data['detalles'] = $dcr;
            $data['emisor'] = $emr;
            $data['pdf'] = $this->pdf;            
            // $html = $this->load->view('facturacion/facturar/' . $formato['frf_archivo'], $data, true);
            // var_dump($dcr);die();
            $html = $this->load->view('facturacion/facturar/detalle_comprobante_retencion_electronico', $data, true);
            if(true || (isset($conf_formato_array['SETCELLPADDINGS']) != '' || isset($conf_formato_array['FORMATO']) != '')){
                $formatop = "215,279";// $conf_formato_array['FORMATO'];
                $orientacion = "P";// $conf_formato_array['ORIENTACION'];
                $formato_array = explode(",",$formatop);
                $margins = "0,0,0";// $conf_formato_array['MARGINS'];
                $formatopage = (count($formato_array) > 1) ? $formato_array : $formatop;
                $m = explode(',', $margins); /// $margins = "0,0,0" pero lo toma como un solo valor
                $this->pdf->SetMargins($m[0],$m[1],$m[2]);
                $this->pdf->setPrintHeader(false);
                $this->pdf->SetFont($fuente);
                $this->pdf->setCellPaddings($setCellPaddings);
                $this->pdf->SetAutoPageBreak(true, 0);
                $this->pdf->AddPage($orientacion, $formatopage, array('family' => $fuente, 'style' => '', 'size' => 6) , true);
                $this->pdf->setPrintFooter(false);
                $this->pdf->writeHTML($html, true, false, false, false, '');
                $this->pdf->boletaPDF('I');
            } else {
                $this->pdf->setPrintFooter(false);
                $this->pdf->makePDF($html, "P", null , 'Letter');//$conf_formato_array['ORIENTACION']
            }
        }

        /**
         * @descripcion:
         * Funcion que permite crear una nota de abono desde un dpv
         * @author  Nelson Soriano
         * @since   14-12-2018
         * @param   id del dpv
         * @return  Vista con los controles para agregar una nota de abono
        **/
    public function nota_abono_pendiente($id_dpv=null){
        //Se ingresan los datos correspondientes a la nota de abono
        satelite_validar();
        if ($_POST) {
            $post_array   = $this->input->post(); 
            $id_documento = $post_array['documento_nota'];
            $id_usuario   = $this->tank_auth->get_user_id();
            $monto_nota   = $post_array['monto_nota'];
            $orden_de     = $post_array['orden_nota'];
            $concepto     = $post_array['concepto_nota'];
            $observacion  = $post_array['observacion_nota'];
            $fecha        = date('Y-m-d H:i:s');
            $generado     = 0;
            $estado       = 1;
            $usuario_crea = $this->tank_auth->get_user_id();
            $usu_modifica = $this->tank_auth->get_user_id();
            $f_creacion   = date('Y-m-d H:i:s');
            $f_modifica   = date('Y-m-d H:i:s');
            $data         = array(
                'ntp_id_usu_genera'      => $id_usuario,
                'ntp_id_dpv'             => $id_documento,
                'ntp_id_agp'             => null,
                'ntp_monto'              => $monto_nota,
                'ntp_orden'              => $orden_de,
                'ntp_concepto'           => $concepto,
                'ntp_observacion'        => $observacion,
                'ntp_fecha'              => $fecha,
                'ntp_generado'           => $generado,
                'ntp_estado'             => $estado,
                'ntp_usu_creacion'       => $usuario_crea,
                'ntp_fecha_creacion'     => $f_creacion,
                'ntp_usu_modificacion'   => $usu_modifica,
                'ntp_fecha_modificacion' => $f_modifica
            );
            $resultado = $this->gsatelite->ingresar('ntp_nota_abono_pendiente', $data);
            $iframe = 1;
            if ($resultado > 0) {
                if ($iframe == 1) {
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => " Transferencia Bancaria Pendiente", 'texto_alerta' => "El proceso se realizó correctamente.");
                } else {
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cheque Pendiente Generado" . $estado, 'texto_alerta' => "El proceso se realizó correctamente.");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }else{
                $data['cerrar_modal'] = 1;                
                $data['alerta'] = $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nota Abono pendiente", 'texto_alerta' => "Error al procesar solicitud");
            }
        }

        if ($id_dpv) {
            $iframe = 1;       
            $data['documento'] = $this->compras_model->get_informacion_dpv_drp($id_dpv);       
            $data['titulo_personal'] = "Nota de abono pendiente";
            $data['iframe'] = $iframe;       
        }
        if ($iframe == 1) {
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/nota_abono_pendiente', $data);
        } else {
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $this->_cargarvista($data);
        }
        
    }

    public function comprob_retenc_renta($dpv_id = 0){
        satelite_validar();
        // $existe_fri = $this->gsatelite->get_tabla('fri_formato_impresion', array('fri_estado' => 1, 'fri_activo' => 1, 'fri_tipo_formato' => 5));
        $where = array('dxd_id_dpv' => $dpv_id);
        $data['retencion'] = $this->compras_model->comp_retenc_renta($where);
        $data['empresa'] = $this->facturacion_model->get_empresa_dte($this->tank_auth->get_empresa_id())[0];
        $formato = "comp_retenc_renta_dpv"; // SINO LUEGO AGREGARLO EN LA FRI
        $html = $this->load->view('modulo_compras/procesos/' . $formato, $data, true);
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePDF($html, 'P', null , 'Letter');
    }

    // $flag 1 = Indica si el reporte es impresion 2 = excel
    public function impresion_orden_compra($id_orden_compra, $flag, $correo = null) {
        //obtener validacion de firmas
        $flujos         = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO',2);
        $flujos_array   = json_decode($flujos, true);
        $flujo          = $flujos_array['ORDEN_COMPRA'];
        $firmas         = $this->get_firmas_reportes($flujo, $id_orden_compra);

        $filename                       = 'ordenes_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename']               = $filename;
        $data['orden_compra']           = $this->compras_model->get_ordenes_compra(array('orc_id' => $id_orden_compra));
        $data['detalle_orden_compra']   = $this->compras_model->get_detalle_orden_compra(array('dor_id_orc' => $id_orden_compra));
        // Solicitante es el que crea la orden de compra - $this->tank_auth->get_user_id()
        // Se cambio ya que mostraba el usuario logueado, debe mostrar el solicitante
        $data['datos_usuario'] = $this->inventario_model->informacion_empleado($data['orden_compra'][0]['orc_id_usu_solicita']);
        $where = null;
        $where_in = null;

        $flujo_orden_compra         = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
        $flujo_orden_compra         = json_decode($flujo_orden_compra);
        // Parametro para determinar si mostrar el usuario que autorizo la orden de compra
        $mostrar_usuario = $this->gsatelite->get_parametro('SYS_MOSTRAR_USUARIO_IMPRESION', null, null, array('impresion_orden_compra'));
        $data['mostrar_usuario'] = ($mostrar_usuario > 0)?$mostrar_usuario:0;

        $aprobaciones = $this->gsatelite->get_parametro('SYS_APROBACION_SEGUIMIENTO_ORDEN');
        $aprobaciones = json_decode($aprobaciones);

        $where['sgo_id_orc']= $id_orden_compra;
        $where['psf_id_flu']= $flujo_orden_compra->ORDEN_COMPRA;
        $where_in           = explode(",", $aprobaciones->AUTORIZADA);
        $data['usuarios']   = $this->compras_model->get_usuarios_autorizan_compra($where, $where_in);
        $data['firmas']     = $firmas;

        if ($flag == '1') {
            $data['tipo_reporte'] = 'pdf';
            $data['titulo'] = 'Orden de Compra';
            $html = $this->load->view('modulo_compras/procesos/impresion_orden_compra', $data, true);
            $data['solotitulo'] = 'Orden de Compra';
            $header = $this->load->view('reporte/header', $data, true);
            $GLOBALS['nombre_reporte'] = 'Ordenes_Compra_' . date('dmY');
            $n = 'Ordenes_Compra_' . date('dmY');
            // $reporte = $header . $html;
            $reporte = $html;
            /*
            * H = Horizontal
            * L = Vertical
            */
            if ($correo) {
                $this->session->set_userdata('nombre_pdf_orden_compra',$n.'.pdf');
                $this->pdf->makePdf($reporte, 'H', 'Ordenes_Compra', 'Letter','F');
            }else{
                $this->pdf->makePdf($reporte, 'H', 'Ordenes_Compra', 'Letter','I');
            }

        } else {
            $data['tipo_reporte'] = 'excel';
            $data['filename'] = $filename;
            $html = $this->load->view('modulo_compras/procesos/impresion_orden_compra', $data, true);
            $filename = 'ordenes_compra_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo'] = 'Ordenes de Compra';        
            echo $html;
        }
    }

    public function imprimir_orden_compras($id_orden, $tipo_impresion, $correo = null){
        satelite_validar();
        $this->impresion_orden_compra($id_orden, $tipo_impresion, $correo);
    }
    
    // agregar doc_proveedor/
    function agregar_doc_proveedor($orc_id = null, $modulo = null, $suj_exc = null) {
        satelite_validar();    
        $cec_defecto = $this->gsatelite->get_max('cec_centro_costo', 'cec_id', array('cec_estado' => 1,'cec_defecto' => 1));//CENTRO DE COSTO POR DEFECTO
        $id_nota_cred = $this->gsatelite->get_parametro('SYS_ID_TIPO_FACTURA_NOTA_CREDITO');
        if ($_POST) {
            // var_dump($_POST);die();
            $es_nota_cred = 0;
            $costo_promedio        = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            $usaFacturaElectronica = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION');
            $post_array            = $this->input->post();
            $tipo_btn              = $post_array['btnCrear'];
            $idOrdenCompra         = ($post_array['slcOrdenCompra'] != '') ? $post_array['slcOrdenCompra'] : null;
            $slcDocAfecta          = ($post_array['slcDocAfecta'] != '') ? $post_array['slcDocAfecta'] : null;
            $slcTipo               = $post_array['slcTipo'];
            $txtConcepto           = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $slcProveedor          = $post_array['slcProveedor'];
            $txtDescripcion        = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $slcTipoPago           = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
            $slcCajaChica          = ($post_array['slcCajaChica'] != '') ? $post_array['slcCajaChica'] : null;
            $slcCondicionPago      = ($post_array['slcCondicionPago'] != '') ? $post_array['slcCondicionPago'] : null;
            $hdnAfectaInv          = $post_array['hdnAfectaInv'];
            $slcTipoDocumento      = ($post_array['slcTipoDocumento'] != '') ? $post_array['slcTipoDocumento'] : null; //TIPO DE FACTURA
            $slcCentroCosto        = ($post_array['slcCentroCosto'] != '') ? $post_array['slcCentroCosto'] : $cec_defecto;
            $txtNumDoc             = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;
            $slcProyecto           = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $txtSerieDoc           = ($post_array['txtSerieDoc'] != '') ? $post_array['txtSerieDoc'] : null;
            $slc_presupuesto       = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $txtFechaDoc           = ($post_array['txtFechaDoc'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDoc'])) : null;
            $slc_actividad_general = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $txtFechaVencimiento   = ($post_array['txtFechaVencimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVencimiento'])) : null;
            $slc_act_especifica    = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
            $txtFechaConta         = ($post_array['txtFechaConta'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaConta'])) : null;
            $txtFechaDeclara       = ($post_array['txtFechaDeclara'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaDeclara']) : null;
            $slcTipoMonto          = ($post_array['slcTipoMonto'] != '') ? $post_array['slcTipoMonto'] : null;
            $txtNRC                = ($post_array['txtNrc']) ? $post_array['txtNrc'] : null;
            $nombre_act_especifica = ($post_array['txt_nombre_actividad'] != '') ? $post_array['txt_nombre_actividad'] : null;
            $nombre_proveedor      = ($post_array['txt_nombre_proveedor'] != '') ? $post_array['txt_nombre_proveedor'] : null;
            $txtObservacion        = ($post_array['txtObservacion']) ? $post_array['txtObservacion'] : null;
            $txtDescuentoGeneral   = str_replace(',','',(($post_array['txtDescuentoGeneral'] != '') ? $post_array['txtDescuentoGeneral'] : 0));
            $txtImpuestosGeneral   = str_replace(',','',($post_array['txtImpuestosGeneral']));
            $txtRetencionGeneral   = str_replace(',','',($post_array['txtRetencionGeneral']));
            $txtSubtotalGeneral    = str_replace(',','',($post_array['txtSubtotalGeneral']));
            $txtTotalGeneral       = str_replace(',','',($post_array['txtTotalGeneral']));
            $abreviacion           = ($post_array['txt_abreviacion'] != '') ? $post_array['txt_abreviacion'] : null;
            $caja_chica_definida   = ($post_array['caja_chica_definida'] != '')?$post_array['caja_chica_definida']:"";
            $liquidacion_definida  = ($post_array['liquidacion_definida'] != '')?$post_array['liquidacion_definida']:"";
            $finalizar_orc         = $post_array['hdnFinaliza'];//"0/1" por default es 1
            $ord_id_iniciales      = (isset($post_array['ord_ids'])) ? explode(',', $post_array['ord_ids']) : null;
            $dpv_id_pct            = 0;
            $generar_partida       = 0;
            $dpv_orc_ya_afecto     = $post_array['orden_ya_afecto'];
            //VARAIBLE PARA LISTA DE COMPROBANTES
            $lista_comprobantes = array(
                "liquidacion"   => $liquidacion_definida, 
                "caja_chica"    => $caja_chica_definida
            );
            $this->session->set_flashdata($lista_comprobantes);
            //Anexos
            $TitulosAnexo = (isset($post_array['titulo_doc'])) ? $post_array['titulo_doc'] : null;
            $NombreAnexo  = (isset($post_array['ruta'])) ? $post_array['ruta'] : array();
            $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            //Validar si es una nota de credito y se ha definido a cual doc afecta
            if ((int)$slcTipoDocumento == (int)$id_nota_cred && $slcDocAfecta != null) {
                $es_nota_cred = 1;
                //buscar dpv generador y actualizarlo
                $dpv_proviene = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $slcDocAfecta));
                if(count($dpv_proviene)>0){
                    //Total pagado en la nota de credito
                    $total_de_la_nota_credito   = $txtTotalGeneral;
                    $dpv_nota_monto_abono       = $dpv_proviene[0]['dpv_monto_abono'];
                    $dpv_nota_monto_pendiente   = $dpv_proviene[0]['dpv_monto_pendiente'];
                    $dpv_nota_monto_nta_credito = $txtTotalGeneral;
                    $monto_saldo_nota_temporal  = (abs($total_de_la_nota_credito) - $dpv_nota_monto_pendiente);
                    //Si el total de la nota de credito excedo el monto pendiente del dpv
                    if($monto_saldo_nota_temporal >= 0){
                        $dpv_nota_monto_abono       = $dpv_proviene[0]['dpv_total'];
                        $dpv_nota_monto_pendiente   = 0.00;
                        $dpv_nota_monto_nta_credito = abs($total_de_la_nota_credito);
                        $dpv_nota_monto_nta_saldo   = abs($monto_saldo_nota_temporal);
                        $dpv_nota_colocar_pagado    = 1;
                    }else{//En caso de que la nota de credito no excede el monto pendiente de dpv
                        $dpv_nota_monto_abono       = $dpv_nota_monto_abono + abs($txtTotalGeneral);
                        $dpv_nota_monto_pendiente   = $dpv_nota_monto_pendiente - abs($txtTotalGeneral);
                        $dpv_nota_monto_nta_credito = abs($total_de_la_nota_credito);
                        $dpv_nota_monto_nta_saldo   = 0.00;
                        $dpv_nota_colocar_pagado    = 0;
                    }
                    $actualizar_proviene = array(
                        'dpv_pagado' => $dpv_nota_colocar_pagado,
                        'dpv_monto_abono' => $dpv_nota_monto_abono, 
                        'dpv_monto_pendiente' => $dpv_nota_monto_pendiente,
                        'dpv_monto_nta_credito' => $dpv_nota_monto_nta_credito,
                        'dpv_monto_nta_saldo' => $dpv_nota_monto_nta_saldo                    
                    );
                    $nta_cre = $this->gsatelite->actualizar_array('dpv_documento_proveedor', $actualizar_proviene, array('dpv_id' => $slcDocAfecta));
                }
                $txtTotalGeneral = ($txtTotalGeneral < 0) ? $txtTotalGeneral : ($txtTotalGeneral * -1);
                $txtImpuestosGeneral = ($txtImpuestosGeneral < 0) ? $txtImpuestosGeneral : ($txtImpuestosGeneral * -1);
                $txtDescuentoGeneral = ($txtDescuentoGeneral < 0) ? $txtDescuentoGeneral : ($txtDescuentoGeneral * -1);
                $txtRetencionGeneral = ($txtRetencionGeneral < 0) ? $txtRetencionGeneral : ($txtRetencionGeneral * -1);
                $txtSubtotalGeneral = ($txtSubtotalGeneral < 0) ? $txtSubtotalGeneral : ($txtSubtotalGeneral * -1);
            }
            $documento_array = array(
                'dpv_id_orc'                => $idOrdenCompra,
                'dpv_id_prv'                => $slcProveedor,
                'dpv_id_tpg'                => $slcTipoPago,
                'dpv_id_tif'                => $slcTipoDocumento,
                'dpv_id_cch'                => $slcCajaChica,
                'dpv_id_pcl'                => $slcProyecto,
                'dpv_id_tmt'                => $slcTipoMonto,
                'dpv_id_cec'                => $slcCentroCosto,
                'dpv_id_cod'                => $slcCondicionPago,
                'dpv_id_psp'                => $slc_presupuesto,
                'dpv_id_ace'                => $slc_act_especifica,
                'dpv_id_acg'                => $slc_actividad_general,
                'dpv_id_dpv_afecta'         => $slcDocAfecta,
                'dpv_serie_documento'       => $txtSerieDoc,
                'dpv_numero_documento'      => $txtNumDoc,
                'dpv_fecha_documento'       => $txtFechaDoc,
                'dpv_fecha_contabilizacion' => $txtFechaConta,
                'dpv_fecha_declaracion'     => $txtFechaDeclara,
                'dpv_fecha_vencimiento'     => $txtFechaVencimiento,
                'dpv_concepto'              => $txtConcepto,
                'dpv_descripcion'           => $txtDescripcion,
                'dpv_afecta_inventario'     => ($dpv_orc_ya_afecto > 0) ? 1 : $hdnAfectaInv,
                'dpv_tipo'                  => $slcTipo,
                'dpv_pagado'                => ($es_nota_cred > 0) ? 1 : 0,
                'dpv_monto_abono'           => ($es_nota_cred > 0) ? $txtTotalGeneral : 0,
                'dpv_monto_pendiente'       => ($es_nota_cred > 0) ? 0 : convertirFloat($txtTotalGeneral),
                'dpv_impuesto'              => convertirFloat($txtImpuestosGeneral),
                'dpv_descuento'             => convertirFloat($txtDescuentoGeneral),
                'dpv_retencion'             => convertirFloat($txtRetencionGeneral),
                'dpv_subtotal'              => convertirFloat($txtSubtotalGeneral),
                'dpv_total'                 => convertirFloat($txtTotalGeneral),
                'dpv_observacion'           => $txtObservacion,
                'dpv_estado'                => 1,
                'dpv_usu_creacion'          => $this->tank_auth->get_user_id(),
                'dpv_fecha_creacion'        => date('Y-m-d H:i:s'),
                'dpv_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'dpv_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $dpv_id = $this->gsatelite->ingresar('dpv_documento_proveedor', $documento_array);
            //se verificara si se agregaran gastos a presupuestos.
            if ( $slcProyecto != "" && $slc_act_especifica != "" && $es_nota_cred == 0) {//solo cuando no sea nota de credito
                $condiciones = array(
                    "dps_id_ace"    => $slc_act_especifica,
                    "dps_id_acg"    => $slc_actividad_general,
                    "dps_id_psp"    => $slc_presupuesto,
                );
                $detalle_presupuesto = $this->gsatelite->get_campo("dps_detalle_presupuesto","dps_id",$condiciones);
                if ( $detalle_presupuesto != null ) {
                    $dgp_detalle_gasto_prespuesto = array(
                        'dgp_id_dps'            => $detalle_presupuesto,
                        'dgp_id_tgp'            => 5,
                        'dgp_id_dpv'            => $dpv_id,
                        'dgp_fecha'             => $txtFechaDoc,
                        'dgp_descripcion'       => $nombre_proveedor,
                        'dgp_referencia'        => $abreviacion." - ".$txtNumDoc,
                        'dgp_cantidad'          => 1,
                        'dgp_monto'             => convertirFloat($txtTotalGeneral),
                        'dgp_total_retencion'   => convertirFloat($txtRetencionGeneral),
                        'dgp_total_impuesto'    => convertirFloat($txtImpuestosGeneral),
                        'dgp_sub_monto'         => convertirFloat($txtSubtotalGeneral),
                        'dgp_origen'            => null,
                        'dgp_referencia_origen' => null,
                        'dgp_estado'            => 1,
                        'dgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'dgp_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'dgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'dgp_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $dgp_id = $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dgp_detalle_gasto_prespuesto);
                }
            }
            //Obtener info para concepto partida            
            $data_prv_doc = $this->compras_model->get_datos_doc_prove(array('dpv_id' => $dpv_id));
            $data_concepto = [];
            if(count($data_prv_doc)>0 && $es_nota_cred == 0){//pendiente procedimiento para las notas de credito
                $data_concepto['nombre_com'] = ($data_prv_doc[0]['prv_tipo_pers'] == 2) ? $data_prv_doc[0]['prv_apellido'] : $data_prv_doc[0]['prv_nombre'].' '.$data_prv_doc[0]['prv_apellido'];
                $data_concepto['fecha_doc']  = formatear_fecha('d-m-Y',$data_prv_doc[0]['dpv_fecha_contabilizacion']);
                $data_concepto['dpv_numero']  = $data_prv_doc[0]['dpv_numero_documento'];                
            }else{
                //$data_concepto = null;
                $data_concepto['nombre_com'] = '';
                $data_concepto['fecha_doc']  = '';
                $data_concepto['dpv_numero'] = '';
            }
            if ($dpv_id > 0) {
                //Se obtienen los detalles de la grid
                $detalle_orden = (isset($post_array['dor_id'])) ? $post_array['dor_id'] : array();
                $cantidad_real = (isset($post_array['cantidades_real'])) ? $post_array['cantidades_real'] : array();
                $productos = $post_array['productos'];
                $descripcionProd = $post_array['descripcionProd'];
                $conversiones = $post_array['conversion'];
                $cantidades = $post_array['cantidades'];
                $precios = $post_array['precios'];
                $retenciones = $post_array['retenciones'];
                $impuestos = $post_array['impuestos'];
                $bodegas = $post_array['bodegas'];
                $sectores = $post_array['sectores'];
                $impuestosProducto = $post_array['impuestosProducto'];
                $retencionesProducto = $post_array['retencionesProducto'];
                $tiposVenta = $post_array['tiposVenta'];
                $descuentos = $post_array['descuentos'];
                $descuento_monto = $post_array['descuentomonto'];
                //$gastos = $post_array['gastos'];
                $subtotalesProducto = $post_array['subtotalesProducto'];
                $totalesProducto = $post_array['totalesProducto'];
                $conversionDefe = ($post_array['conversionDefe'])? $post_array['conversionDefe'] : null ;
                $conversionConv = ($post_array['conversionConv'])? $post_array['conversionConv'] : null ;
                $tipo_producto = $post_array['tipo_producto'];               
                if(count($detalle_orden)>0 && $es_nota_cred == 0){//pendiente procedimiento para las notas de creditos
                    $descartados = array_diff($ord_id_iniciales, $detalle_orden);
                    if ($finalizar_orc > 0) {//si se dio por finalizada la orden
                        foreach ($descartados as $key => $value) {
                            $this->gsatelite->actualizar_array('dor_detalle_orden_compra', array('dor_estado' => 0), array('dor_id'=>$value));
                        }
                    }
                }
                if (count($productos) > 0) {
                     //Se ingresan los detalles de la orden
                    for ($i = 0; $i < count($productos); $i++) {
                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;
                        $producto_id = $productos[$i];
                        $conversion_prodc = (trim($conversiones[$i])?$conversiones[$i]:null);
                        if ($es_nota_cred > 0) {
                            $precios[$i] = ($precios[$i] < 0) ? $precios[$i] : ($precios[$i] * -1);
                            $impuestosProducto[$i] = ($impuestosProducto[$i] < 0) ? $impuestosProducto[$i] : ($impuestosProducto[$i] * -1);
                            $descuentos[$i] = ($descuentos[$i] < 0) ? $descuentos[$i] : ($descuentos[$i] * -1);
                            $retencionesProducto[$i] = ($retencionesProducto[$i] < 0) ? $retencionesProducto[$i] : ($retencionesProducto[$i] * -1);
                            $subtotalesProducto[$i] = ($subtotalesProducto[$i] < 0) ? $subtotalesProducto[$i] : ($subtotalesProducto[$i] * -1);
                            $totalesProducto[$i] = ($totalesProducto[$i] < 0) ? $totalesProducto[$i] : ($totalesProducto[$i] * -1);
                        }
                        $detalle_array = array(
                            'dxd_id_bod' => ($bodegas[$i] > 0) ? $bodegas[$i] : null,
                            'dxd_id_sxb' => ($sectores[$i] > 0) ? $sectores[$i] : null,
                            'dxd_id_dpv' => $dpv_id,
                            'dxd_id_act' => $activo_id, 
                            'dxd_id_cva' => $conversion_prodc,
                            'dxd_id_art' => $producto_id,
                            'dxd_id_tpv' => ($tiposVenta[$i] != '') ? $tiposVenta[$i] : null,
                            'dxd_cantidad' => convertirFloat($cantidades[$i]),
                            'dxd_precio_unitario' => convertirFloat($precios[$i]),
                            'dxd_impuesto' => convertirFloat($impuestosProducto[$i]),
                            'dxd_descuento' => ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0,
                            'dxd_monto_descuento' => ($descuento_monto[$i] != '') ? convertirFloat($descuento_monto[$i]) : 0,
                            'dxd_retencion' => convertirFloat($retencionesProducto[$i]),
                            'dxd_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dxd_total' => convertirFloat($totalesProducto[$i]),
                            'dxd_procesado_inventario' => ($dpv_orc_ya_afecto > 0) ? 1 : 0,
                            'dxd_descripcion' => $descripcionProd[$i],
                            'dxd_estado' => 1,
                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_creacion' => date('Y-m-d H:i:s'),
                        );
                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);
                        //Si se ingresa el detalle, se ingresan los impuestos y retenciones
                        if ($dxd_id > 0) {
                            ////// ACTUALIZAR CANTIDAD EN LOS DETALLES DE LA ORDEN DE COMPRA (SI APLICA) ///////
                            if(count($detalle_orden) > 0){
                                if ($es_nota_cred > 0) {
                                    $pendiente = convertirFloat($cantidad_real[$i]) + convertirFloat($cantidades[$i]);
                                } else {
                                    $pendiente = convertirFloat($cantidad_real[$i]) - convertirFloat($cantidades[$i]);
                                }
                                if ($dpv_orc_ya_afecto == 0) {
                                    //$first = $this->gsatelite->get_campo('dor_detalle_orden_compra', 'dor_cantidad_pendiente', array('dor_id'=>$detalle_orden[$i]));
                                    $this->gsatelite->actualizar_array('dor_detalle_orden_compra', array('dor_cantidad_pendiente'=>$pendiente), array('dor_id'=>$detalle_orden[$i]));
                                }
                            }
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);
                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {
                                        if ($impuestos_array[$j] != '') {
                                            $por_imp = $this->gsatelite->get_campo('imp_impuesto','imp_porcentaje', array('imp_id'=>$impuestos_array[$j]));
                                            if($por_imp>0){
                                                $mon_im = ($por_imp/100)*$subtotalesProducto[$i];
                                            }else{
                                                $imp_val    = $this->gsatelite->get_campo('imp_impuesto','imp_valor', array('imp_id'=>$impuestos_array[$j]));                                          
                                                $mon_im     = $cantidades[$i] * $imp_val;
                                                $por_imp    = $imp_val;
                                            }
                                            if ($es_nota_cred > 0) {
                                                $mon_im = ($mon_im < 0) ? $mon_im : ($mon_im * -1);
                                            }
                                            if ($impuestos_array[$j] > 0) {
                                                $ixo_array = array(
                                                    'idd_id_imp' => $impuestos_array[$j],
                                                    'idd_id_dxd' => $dxd_id,
                                                    'idd_porcentaje' => $por_imp,
                                                    'idd_monto' => $mon_im,
                                                    'idd_estado' => 1,
                                                    'idd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                    'idd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                    'idd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                    'idd_fecha_creacion' => date('Y-m-d H:i:s')
                                                );
                                                $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                            }

                                        }
                                    }
                                }
                            }
                            //Se valida existan retenciones
                            if (count($retenciones) > 0) {
                                //Se crea el array de los retenciones
                                $retenciones_array = explode(',', $retenciones[$i]);
                                if (count($retenciones_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($retenciones_array); $j++) {
                                        if ($retenciones_array[$j] != '') {
                                            $por_ret = $this->gsatelite->get_campo('ret_retencion','ret_porcentaje', array('ret_id'=>$retenciones_array[$j]));
                                            if($por_ret  > 0){
                                                $mon_ret    = ($por_ret / 100) * convertirFloat($subtotalesProducto[$i]);
                                            }else{
                                                $ret_val    = $this->gsatelite->get_campo('ret_retencion','ret_valor', array('ret_id'=>$impuestos_array[$j]));
                                                $mon_ret    = $cantidades[$i] * $ret_val;
                                                $por_ret    = $ret_val;
                                            }
                                            $rxd_array = array(
                                                'rxd_id_ret'            => $retenciones_array[$j],
                                                'rxd_id_dxd'            => $dxd_id,
                                                'rxd_monto'             => $mon_ret,
                                                'rxd_porcentaje'        => $por_ret,
                                                'rxd_estado'            => 1,
                                                'rxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_modificacion'=> date('Y-m-d H:i:s'),
                                                'rxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_creacion'    => date('Y-m-d H:i:s')
                                            );
                                            $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                        }
                                    }
                                }
                            }
                            //Se procesan los detalles del prorrateo
                            // var_dump($productos[$i]);
                            // var_dump(count($post_array['centroCostos_' . $productos[$i]]) > 0 && $es_nota_cred == 0);
                            // var_dump($post_array['centroCostos_' . $productos[$i]]);
                            if (isset($post_array['centroCostos_' . $productos[$i]]) && count($post_array['centroCostos_' . $productos[$i]]) > 0 && $es_nota_cred == 0) {
                                //pendiente proceso para nota de credito
                                $centros_costo      = $post_array['centroCostos_' . $productos[$i]];
                                $porcentajes        = $post_array['porcentajesCec_' . $productos[$i]];
                                $totales            = $post_array['totalCec_' . $productos[$i]];
                                $cuentacontable     = $post_array['cuentacontablenew_' . $productos[$i]];
                                $pxd_id_cec         = $post_array['codigo_centro_costo_' . $productos[$i]];
                                //
                                foreach ($centros_costo as $j => $val) {
                                    $detalle_pro_array = array(
                                        'pxd_id_dpr'            => ($val != "") ? $val : NULL,
                                        'pxd_id_dxd'            => $dxd_id,
                                        'pxd_id_cnt'            => ($cuentacontable[$j] != "") ? $cuentacontable[$j] : NULL,
                                        'pxd_id_cec'            => $pxd_id_cec[$j],
                                        'pxd_porcentaje'        => $porcentajes[$j],
                                        'pxd_total'             => convertirFloat($totales[$j]),
                                        'pxd_estado'            => 1,
                                        'pxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_creacion'    => date('Y-m-d H:i:s'),
                                        'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                    unset($post_array['centroCostos_' . $productos[$i]][$j]);
                                }
                                /*
                                for ($j = 0; $j < count($post_array['centroCostos_' . $productos[$i]]); $j++) {
                                    $detalle_pro_array = array(
                                        'pxd_id_dpr'            => ($centros_costo[$j] != "")?$centros_costo[$j]:NULL,
                                        'pxd_id_dxd'            => $dxd_id,
                                        'pxd_id_cnt'            => ($cuentacontable[$j] != "")?$cuentacontable[$j]:NULL,
                                        'pxd_id_cec'            => $pxd_id_cec[$j],
                                        'pxd_porcentaje'        => $porcentajes[$j],
                                        'pxd_total'             => convertirFloat($totales[$j]),
                                        'pxd_estado'            => 1,
                                        'pxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_creacion'    => date('Y-m-d H:i:s'),
                                        'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                }
                                */
                            }
                            // echo " || ";
                        } // End if
                    } // End for
                    //Anexos
                    if (count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {
                            $extension = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                            $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                            $carpeta_destino_anx = "uploads/anx_doc_proveedor/" . $nombreArchivo;
                            $documentos_array = array(
                                'adp_id_dpv' => $dpv_id,
                                'adp_url' => $carpeta_destino_anx,
                                'adp_nombre' => $nombreArchivo,
                                'adp_estado' => 1,
                                'adp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'adp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'adp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'adp_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );
                            $nxp_id = $this->gsatelite->ingresar('adp_anexo_documento', $documentos_array);
                            if ($nxp_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }
                    // if ($hdnAfectaInv == 1 && ($slcTipo == 1 || $slcTipo == 4)) {
                    if ($hdnAfectaInv == 1 && $es_nota_cred == 0) {//pendiente proceso con notas de credito
                        $tipoProcesos = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
                        $tipoProcesos_array = json_decode($tipoProcesos, true);
                        $this->db->order_by('dxd_id_bod');
                        $this->db->group_by('dxd_id_bod');
                        $detalle_query = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod !=' => ''));
                        $movimientos_array = array();
                        //Se crean todos los movimientos
                        foreach ($detalle_query as $dxd) {
                            $movimientos_array[]['movimientos'] = array(
                                'moi_id_prv' => $slcProveedor,
                                'moi_id_tip' => $tipoProcesos_array['DOC_PROV'],
                                'moi_id_bod' => $dxd['dxd_id_bod'],
                                'moi_id_dpv' => $dpv_id,
                                'moi_documento' => $txtNumDoc,
                                'moi_descripcion' => $txtConcepto,
                                'moi_fecha_mov' => date('Y-m-d H:i:s'),
                                'moi_estado' => 1,
                                'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                                'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                                'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                        }
                        //Se crean los detalles del movimiento
                        for ($i = 0; $i < count($movimientos_array); $i++) {
                            $bod_id = $movimientos_array[$i]['movimientos']['moi_id_bod'];
                            $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod' => $bod_id,'art_inventario' => 1));
                            if (count($detalles_doc) > 0) {
                                $desc_prod = ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0;
                                foreach ($detalles_doc as $key => $det) {
                                    if($det['art_tipo'] == 0){
                                        $precio_uni = convertirFloat($det['dxd_precio_unitario']);
                                        $descuento_art = ($precio_uni)-(($precio_uni)*($desc_prod/100));
                                        $nueva_cantidad_actu = convertirFloat(($det['dxd_cantidad']*(/*$conversionConv[$i] */ $det['conversion1']/$det['conversion2'] /*$conversionDefe[$i] */)));
                                        $nueva_precio_actu = convertirFloat(($descuento_art*(/*$conversionDefe[$i] */$det['conversion2']/$det['conversion1']/* $conversionConv[$i] */)));
                                        
                                        if($conversionDefe==null){
                                            $nueva_cantidad_actu = $det['dxd_cantidad'];
                                            $nueva_precio_actu = $det['dxd_precio_unitario'];
                                            
                                            //traemos la unidad por defecto para realizar la convercion
                                                            $this->db->join('cva_conversion_articulo','mep_id = cva_id_mep');
                                                            $this->db->where(array('cva_defecto' => 1,'cva_id_art' => $det['dxd_id_art']));
                                            $defecto = $this->gsatelite->get_tabla('mep_medida_producto',array('mep_estado'=>1));
                                            
                                                             $this->db->join('cva_conversion_articulo','mep_id = cva_id_mep');
                                                             $this->db->where(array('cva_id_art' => $det['dxd_id_art'], 'cva_id' => $det['dxd_id_cva']));
                                            $actualx =  $this->gsatelite->get_tabla('mep_medida_producto',array('mep_estado'=>1));

                                           
                                            $nueva_cantidad_actu = ( $det['dxd_cantidad'] * $actualx[0]['cva_conversion'] ) / $defecto[0]['cva_conversion'];
                                            
                                        }
                                        if ($costo_promedio == 1) {
                                            $nuevo_precio =  $this->recalcular_precio_promedio($det['dxd_id_art'], $bod_id, $nueva_cantidad_actu, $nueva_precio_actu);
                                        }
                                        $movimientos_array[$i]['detalles'][$key]['sar_saldo'] = array(
                                            'sar_id_art' => $det['dxd_id_art'],
                                            'sar_id_bod' => $bod_id,
                                            'sar_cant_actual' => $nueva_cantidad_actu,
                                            'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $nueva_precio_actu,
                                            'sar_fecha_caducidad' => null,
                                            'sar_id_sxb' => $det['dxd_id_sxb'],
                                            'sar_estado' => 1,
                                            'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $movimientos_array[$i]['detalles'][$key]['dee_movimiento'] = array(
                                            'dee_id_moi' => null,
                                            'dee_id_art' => $det['dxd_id_art'],
                                            'dee_id_sar' => null,
                                            'dee_id_cva' => $det['dxd_id_cva'],
                                            'dee_id_sxb' => $det['dxd_id_sxb'],
                                            'dee_cantidad' => $nueva_cantidad_actu,
                                            'dee_precio' => $nueva_precio_actu,
                                            'dee_subtotal' => convertirFloat($det['dxd_subtotal']),
                                            'dee_estado' => 1,
                                            'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $movimientos_array[$i]['detalles'][$key]['dxd_detalle_doc'] = array(
                                            'dxd_id' => $det['dxd_id'],
                                            'dxd_procesado_inventario' => 1,
                                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        );
                                    }
                                }
                            }
                        }
                        $ids_moi = $this->ingresar_entrada($movimientos_array);
                        //============= Generar asiento afecta inventario documento por proveedor============//
                        foreach ($ids_moi as $key => $moi_id) {
                            $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_COMPRA');
                            $doc_referencia = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;//Es lo que identifica al documento 
                            if($generar_partida > 0){
                                $res_debe = $this->generar_partida_docprov_afecta_inv_debe($moi_id, $doc_referencia, $data_concepto);
                                $this->generar_partida_docprov_afecta_inv_haber($slcProveedor, $res_debe['id_pct'], $res_debe['total_haber']);//Proveedor, idpartida
                                $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_debe['id_pct']), array('moi_id' => $moi_id));
                            }
                        }
                    }else{
                        //No afecta inventario o ya lo afecto si es orden-compra
                        if ($dpv_orc_ya_afecto > 0) {
                            //para el caso que la orden ya se habia metido a inventario y faltaba el dpv, se actualizara para tener ambos datos, ***CONSULTAR/VERIFICAR
                            $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_dpv' => $dpv_id), array('moi_id_orc' => $idOrdenCompra));
                            $this->gsatelite->actualizar_array('orc_orden_compra', array('orc_estado'=>0,'orc_fecha_modificacion'=>date('Y-m-d H:i:s'),'orc_usu_modificacion'=>$this->tank_auth->get_user_id()), array('orc_id' => $idOrdenCompra));
                        }
                        //if($generar_partida > 0 && $dpv_id > 0){
                        $where['dpv_id'] = $dpv_id;
                        $info['num_doc_provedor'] = $txtNumDoc;
                        $info['fecha_doc_provedor'] = $txtFechaConta;
                            //$res_debe = $this->generar_partida_docprov_no_afecta_inv_debe($where, $info, $data_concepto);
                            //$this->generar_partida_docprov_no_afecta_inv_haber($slcProveedor, $res_debe['id_pct'], $res_debe['total_haber'], $slcTipoPago);
                            //Se asocia la partida con el documento
                            //$this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct' => $res_debe['id_pct']), array('dpv_id' => $dpv_id));
                        //}
                        //==============Fin Generar Partida No afecta inventario documento por proveedor===========//
                    }
                    //actualizar partida contable
                    $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_COMPRA');
                    if ($generar_partida > 0 && $dpv_id > 0) {
                        $dpv_id_pct = $this->generar_partida_automatica_doc_proveedor($dpv_id,2);
                        //actualizar el dpv
                        if ( $dpv_id_pct > 0 ) {
                            $dpv_documento_proveedor = array (
                                "dpv_id_pct" => $dpv_id_pct
                            );
                            $this->gsatelite->actualizar_array("dpv_documento_proveedor", $dpv_documento_proveedor, array("dpv_id" => $dpv_id) );
                        }
                    }                    
                    ///////////////////////////// Si se paga por caja chica ////////////////////////////////////////////////////
                    if($slcCajaChica>0){
                        $id_lcc = $post_array['id_lcc'];
                        $this->registro_caja_chica($dpv_id, $documento_array, $id_lcc, null, $txtNRC);
                    }
                    if ($dxd_id > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "El registro se guardó correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                    }
                    ////////////////////////////////////////// FACYURACION ELECTRONICA  //////////////////////////////////////
                    if ($usaFacturaElectronica == 1 && $slcTipoDocumento == $tipo_factura["SUJETO EXCLUIDO"]) {
                        $num_ctrl = $this->generar_datos_factura_electronica($dpv_id);
                        $fact_elect = array(
                            'dpv_id_caja_factura_electronica' => $post_array['id_caj_sujexc'],
                            'dpv_codigo_generacion' => $num_ctrl['cod_generation'],
                            'dpv_numero_control' => $num_ctrl['num_control']
                        );
                        $this->gsatelite->actualizar_array("dpv_documento_proveedor", $fact_elect, array("dpv_id" => $dpv_id));
                        $this->crear_json_suj_exc($dpv_id);
                        $this->envio_sujeto_excluido($dpv_id);
                    }
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }//if ($dpv_id > 0
            $this->session->set_flashdata($alerta);
            $from_suj_exc = $post_array['suj_exc_elect'];
            if ($tipo_btn == 1) {
                if ($from_suj_exc > 0) {
                    redirect('modulo_compras/procesos/add_suj_exc_proveedor/');
                } else {
                    redirect('modulo_compras/procesos/agregar_doc_proveedor/');
                }
            } else {
                if ($caja_chica_definida != "") {
                    $array_where = array('lcc_estado' => 1, 'lcc_corte' => 0, 'lcc_id_cch' => $caja_chica_definida, 'lcc_disponible IS NOT NULL' => NULL);
                    $lcc_id = $this->gsatelite->get_max("lcc_liquidacion_caja_chica", "lcc_id", $array_where);
                    redirect("modulo_compras/procesos/agregar_comp_caja_chica/" . $lcc_id);
                    // redirect('modulo_compras/procesos/periodo_caja_chica');
                }
                if($modulo != null){
                    redirect('modulo_compras/procesos/ordenes_compra/');
                } else{
                    if ($from_suj_exc > 0) {
                        redirect('modulo_compras/procesos/suj_exc_proveedor');
                    } else {
                        redirect('modulo_compras/procesos/documentos_proveedor');
                    }
                }            
            }
        } else {
            //variables de la function lista_comprobantes
            $caja_chica_definida    = ($this->session->flashdata('caja_chica'))? $this->session->flashdata('caja_chica'):"";
            $liquidacion_definida   = ($this->session->flashdata('liquidacion'))? $this->session->flashdata('liquidacion'):"";
            $permiso_compra = false;
            $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
            $permisos_array = ( $permisos_array != "" ) ? explode(",", $permisos_array) : null;
            if (is_array($permisos_array) && count($permisos_array) > 0 ) {
                $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
                foreach ($roles as $role) {
                    if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                        $permiso_compra = true;
                    }
                }
            }
            $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
            $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;
            $data["permiso_compra"] = $permiso_compra;   
            $data['orden_compra']   = null;
            $data['ordenes_data']   = null;
            $option                 = '';
            $options                = $this->compras_model->get_orden_dxp();
            for ($i=0; $i < count($options); $i++) {
                $valido = (int)$options[$i]['valido'];
                if($valido){
                           $this->db->join('prv_proveedor', 'prv_id = orc_id_prv', 'left');
                    $opt = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $options[$i]['orc_id']));
                    $option .= '<option value="' . $opt[0]['orc_id'] . '">' . $opt[0]['orc_numero'] . ' / ';
                    $option .= ($opt[0]['prv_tipo_pers'] < 2) ? $opt[0]['prv_nombre'] . ' ' . $opt[0]['prv_apellido'] : $opt[0]['prv_apellido'];
                    $option .= '</option>';
                    
                }
            }
            $data['inventario_afectado'] = 0;
            $data['ordenes']        = $option;
            $data['detalle_orden']  = null;
            $orden_data = null;
            if ($orc_id != null) {
                $data['orden_compra'] = $orc_id;
                $orden_data = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
                $data['ordenes_data'] = $orden_data;
                $option='';
                $options = $this->compras_model->get_orden_dxp();
                for ($i=0; $i < count($options); $i++) {
                    $valido = (int)$options[$i]['valido'];
                    if($valido){
                               $this->db->join('prv_proveedor', 'prv_id = orc_id_prv', 'left');
                        $opt = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $options[$i]['orc_id']));
                        $sltd = ($opt[0]['orc_id'] == $orc_id) ? "selected" : "";
                        $option .= '<option value="' . $opt[0]['orc_id'] . '" ' . $sltd . '>' . $opt[0]['orc_numero'] . ' / ';
                        $option .= ($opt[0]['prv_tipo_pers'] < 2) ? $opt[0]['prv_nombre'] . ' ' . $opt[0]['prv_apellido'] : $opt[0]['prv_apellido'];
                        $option .= '</option>';
                    }
                }
                $data['inventario_afectado'] = $orc_estado = ($this->gsatelite->get_campo('orc_orden_compra', 'orc_estado', array('orc_id' => $orc_id)) == 7) ? 1 : 0;
                $data['ordenes']= $option;
                $data['opc']    = 1;
                $where_dor = array('dor_id_orc' => $orc_id);
                if ($orc_estado == 0) {
                    $where_dor['dor_estado'] = 1;
                    $where_dor['(dor_cantidad_pendiente > 0 || dor_cantidad_pendiente IS NULL)'] = null;
                }
                $data['detalle_orden'] = $ids = $this->compras_model->get_detalle_orden_compra($where_dor);
                $data['ids_detalle_orden']  = implode(',', array_column($ids, 'dor_id'));
                $data['documento_afecta']   = $this->gsatelite->get_dropdown('dpv_documento_proveedor', 'dpv_numero_documento', '', array('dpv_id_prv' => $data['ordenes_data'][0]['orc_id_prv']), null, null, null, true);
                //Verificar si existe dpv para validar el tipo de documento
                $this->db->group_by('dpv_id_tif');
                $documento = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_orc' => $orc_id));
                $ids_tif = array();
                foreach ($documento as $doc) {
                    $ids_tif[] = $doc['dpv_id_tif'];
                }
            }
            /* SI VIENE PARA SUJ EXCLUIDO SOLO ESA LLAMAR*/
            $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
            $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $tif_sje = (isset($tipo_factura["SUJETO EXCLUIDO"]) && $tipo_factura["SUJETO EXCLUIDO"] > 0) ? $tipo_factura["SUJETO EXCLUIDO"] : 0;
            if ($suj_exc && $tipo_facturacion == 1) {
                $this->db->where("tif_id", $tif_sje);
            }
            $tipo_documento         = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1,'tif_aplica_compra' => 1) );
            $select_documento       = '<option value = ""></option>';
            foreach ($tipo_documento as $key => $tipo) {
                $select_documento   .= '<option value = "'.$tipo["tif_id"].'" data-abreviatura="'.$tipo["tif_abreviacion"].'">'.$tipo["tif_nombre"].'</option>';
            }
            $data['tipo_documento'] = $select_documento;
            $data['id_nota_cred']   = $id_nota_cred;
            //$data['proveedores']    = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
            $data['tipo_pago']      = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', 'pagos', array('tpg_estado' => 1), null, null, null, true);
            $data['centro_costo']   = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), $cec_defecto, null, null, true);
            $data['condiciones']    = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), null, null, null, true);
            $data['retenciones']    = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            $data['tipo_venta'] = $this->gsatelite->get_dropdown('tpv_tipo_venta', '{tpv_nombre}', 'tipo_venta', array('tpv_estado'=>1,'tpv_aplica_compra'=>1), null, null, null, true);
            $tpv_compras_defecto = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1,'tpv_aplica_compra' => 1, 'tpv_defecto_compras' => 1));
            $data['tipo_compra_defecto'] = (count($tpv_compras_defecto) > 0) ? $tpv_compras_defecto[0]['tpv_id'] : 0;
            $data['bodegas'] = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', 'bodegas', array('bod_estado' => 1), null, null, null, true);
            $data['prorrateos'] = $this->gsatelite->get_dropdown('ptg_prorrateo_gasto', '{ptg_nombre}', 'prorrateos', array('ptg_estado' => 1), null, null, null, true);
            $data['centro_costos'] = $this->gsatelite->get_tabla("cec_centro_costo",array('cec_estado' => 1));
            $proveedores = $this->compras_model->get_proveedor_pers();
            $options = '<option value=""></option>';
            foreach ($proveedores as $key) {
                $cod = ($key['prv_id_cod'] != '') ? $key['prv_id_cod'] : '';
                if ($key['pro'] != '') {
                    if ($orc_id != null && $key['prv_id'] == $data['ordenes_data'][0]['orc_id_prv']) {
                        $select = 'selected="selected"';
                    } else {
                        $select = '';
                    }
                    $options .= '<option data-nombre = "'. $key['nombre'] .'" data-dias = "' . $key['prv_dias_plazo'] . '" value="' . $key['prv_id'] . '" ' . $select . ' cod="' . $cod . '">' . $key['pro'] . '</option>';
                }
            }
            $data['proveedores'] = $options;
            $select = "";
            $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
            foreach ($impuesto_campos as $key) {
                if ($key["imp_porcentaje"] > 0) {
                    $select .= "<option data-type='1' data-porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
                } else {
                    $select .= "<option data-type='0' data-porcentaje='" . $key["imp_valor"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                }
            }
            $data["impuestos"] = $select;
            $select = "";
            $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            foreach ($retencion_campos as $key) {
                if ($key["ret_defecto"] == 1) {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
            $data["retencion"] = $select;
            $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
            $select_proyecto = '<option value=""></option>';
            foreach ($proyectos_reg as $key) {
                $selected = '';
                if($orc_id != null){
                    $selected = ($orden_data[0]['orc_id_pcl'] == $key['pcl_id'])?'selected':'';
                }
                $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
                $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
            }
            $data['proyectos'] = $select_proyecto;
            ///////////////////// Sólo cajas chicas que poseen monto disponible /////////////////////////////
                           $this->db->limit(1);
            $cch_id_emp  = $this->gsatelite->get_campo( "emp_empleado", "emp_id", array( "emp_estado" => 1, "emp_id_usu" => $this->tank_auth->get_user_id() ) );
                     $this->db->where(array('lcc_corte'=>0));
                     $this->db->join('lcc_liquidacion_caja_chica', 'lcc_id_cch=cch_id AND lcc_disponible IS NOT NULL');
            $cajas = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado' => 1,'cch_id_emp' => $cch_id_emp));
            $opt_cajas = '<option value=""></option>';
            foreach ($cajas as $cj) {
                $selected  = ( $caja_chica_definida == $cj['cch_id'])?'selected':'';
                $opt_cajas .='<option '.$selected.' value="'.$cj['cch_id'].'" data-sobregiro="'.$cj['cch_sobregirar'].'"  data-lcc="'.$cj['lcc_id'].'">'.$cj['cch_nombre'].' ('.$cj['lcc_disponible'].')</option>';
            }
            $data['cajas_chicas'] = $opt_cajas;
            /////////////////////////////////////////////////////////////////////////////////////////////////
            $par_nrc=$this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
            $mask = $this->gsatelite->get_registro('tde_tipo_documento', array('tde_id'=>$par_nrc));
            $data['mask'] = $mask->tde_mascara;
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $dias_pasados = "";
            $dias_futuros = "";
            $json_meses = $this->gsatelite->get_parametro('SYS_DOC_PROV_FECHA_CONTABLE');
            if ( $json_meses != "" ) {
                $configuracion_meses = json_decode($json_meses,true);
                if ( $configuracion_meses["DIAS_PASADOS"] != "" && is_numeric($configuracion_meses["DIAS_PASADOS"]) ) {
                    $dias_pasados = $configuracion_meses["DIAS_PASADOS"] * -1;
                }
                if ( $configuracion_meses["DIAS_FUTUROS"] != "" ) {
                    $dias_futuros = $configuracion_meses["DIAS_FUTUROS"];
                }
            }   
            $data['presupuesto']    = '<option value=""></option>';
            $data['general']        = '<option value=""></option>';
            $data['especifica']     = '<option value=""></option>';
            if ($orc_id != null) {  
                $slc_presupuesto            = ($orden_data[0]['orc_id_psp'] != "" )?$this->get_presupuestoxproyecto($orden_data[0]['orc_id_pcl'], $orden_data[0]['orc_id_psp'],false):'<option value=""></option>';
                $data['presupuesto']        = $slc_presupuesto;
                $slc_general                = ($orden_data[0]['orc_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($orden_data[0]['orc_id_psp'], $orden_data[0]['orc_id_acg'],false,false):'<option value=""></option>';
                $data['general']            = $slc_general;
                $slc_especifica             = ($orden_data[0]['orc_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($orden_data[0]['orc_id_acg'], $orden_data[0]['orc_id_psp'], $orden_data[0]['orc_id_ace'], true, false, false):'<option value=""></option>';
                $data['especifica']         = $slc_especifica;
            }
            $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data['permite_add_art'] = intval($this->gsatelite->get_permisos_opcion("modulo_compras/catalogos/articulo",'agregar', null, true));
            $regresar_btn = "";
            if($modulo != null){
                $regresar_btn = "modulo_compras/procesos/ordenes_compra";
            } else{
                $regresar_btn = ($suj_exc) ? "modulo_compras/procesos/suj_exc_proveedor" : "modulo_compras/procesos/documentos_proveedor/" . $orc_id;
            }
            $data['regresar_btn'] = $regresar_btn;
            $data['tipo_redirect'] = ($modulo != null) ? 1 : '';
            $data['dias_pasados']   = $dias_pasados;
            $data['dias_futuros']   = $dias_futuros;
            $tipo_cuenta_costo = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('GASTO'));
                                              $this->db->join('dta_detalle_tipoarticulo', 'dta_id_cnt=cnt_id');  
            $data['cuentas']                = $this->utm_model->get_cuentas_like_prorrateo_gral(array('dta_id_tcn'=>$tipo_cuenta_costo));
            $data['caja_chica_definida']    = $caja_chica_definida;
            $data['liquidacion_definida']   = $liquidacion_definida;
                //tipo de cuenta
            $select = $this->gsatelite->get_dropdown('tmt_tipo_monto', '{tmt_nombre}', '', array('tmt_estado' => 1), null, '', 'tmt_id', true);
            $data["tipo_monto"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
            $data['titulo_personal'] = "Documentos por proveedor";
            $data['suj_exc'] = ($suj_exc != null) ? 1 : '';
            $data['id_tif_suj_exc'] = $tif_sje;
            $data['tipo_facturacion'] = $tipo_facturacion;
            if ($suj_exc) {
                $uxc = $this->gsatelite->get_tabla("uxc_usuarioxcaja", array("uxc_id_usu"=>$this->tank_auth->get_user_id(),"uxc_tipo"=> 1,"uxc_estado"=>1));
                $cajasujexc = (count($uxc) > 0) ? $uxc[0]['uxc_id_caj'] : 0;
            } else {
                $cajasujexc = 0;
            }                                    
            $data['caja_suj_exc'] = $cajasujexc;
            cargarvista($data, null, "modulo_compras/procesos/agregar_doc_proveedor");
        }
    }

    function add_suj_exc_proveedor() {
        $permiso = false;
        $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
        $fe = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION');
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $roles = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()));
        if (is_array($roles) && count($roles) > 0) {
            foreach ($roles as $r) {
                if ($r["uxr_id_rol"] == $rol) {
                    /* SI EL USUARIO TIENE ROL DE FACTURACION*/
                    $permiso = true;
                }
            }
        }
        if ($permiso) {
            /* SI EL USUARIO TIENE UNA CAJA */
            $user_caja = $this->gsatelite->get_tabla("uxc_usuarioxcaja",array("uxc_id_usu" => $this->tank_auth->get_user_id(), "uxc_tipo" => 1, "uxc_estado" => 1));
            $caja_id = (count($user_caja) > 0) ? $user_caja[0]['uxc_id_caj'] : 0;
            /* SI LA CAJA TIENE SERIE */
            $series_caja = $this->compras_model->get_caja_doc_prv_suj_exc(array('caj_id' => $caja_id, 'sef_id_tif' => $tipo_factura["SUJETO EXCLUIDO"]));
            if (count($series_caja) > 0) {
                $this->agregar_doc_proveedor(null, null, $fe);
            } else {
                $this->gsatelite->show_dialog('El usuario no posee un caja definida con correlativos para la emisión de documentos de sujeto excluido.', 'modulo_compras/procesos/suj_exc_proveedor', 'error', 'Error de correlativos');
            }
        } else {
            $this->gsatelite->show_dialog('El usuario no posee el rol requerido.', 'modulo_compras/procesos/suj_exc_proveedor', 'error', 'Error de roles');
        }
    }

    public function get_correlativo_suj_exc(){
        $tipo = $_POST['tipo'];
        $caja = $_POST['caja'];
        $tipo_fac = $this->facturacion_model->nuevas_series($tipo, $caja);
        if (count($tipo_fac) > 0) {
            $correlativosxc = $this->facturacion_model->correlativos_x_cajas_sujexc($tipo_fac[0]['cof_id'], $caja);
            if (count($correlativosxc) > 0) {
                $wherenum = array(
                    'dpv_numero_documento >=' => $correlativosxc[0]['cxj_inicio'], 
                    'dpv_id_caja_factura_electronica' => $caja, 
                    'dpv_id_tif' => $tipo
                );
                $numeros = $this->compras_model->get_numeros_facturas($wherenum, 1);
                $numero = (count($numeros) > 0) ? ($numeros[0]['dpv_numero_documento'] + 1) : $correlativosxc[0]['cxj_inicio'];
                $serief = $correlativosxc[0]['sef_nombre'];
            } else {
                $serief = "";
                $numero = 0;
            }
        } else {
            $serief = "";
            $numero = 0;
        }
        echo json_encode(array('numero' => $numero, 'serie' => $serief));
    }

    /*
     * @ver_detalle: 1 = Ver en Iframe, 2 = Ver como pantalla normal, null = Editar la pantalla
     * @redireccion: 1 = No redireccione a DPV de orden de compras
     */

    function editar_doc_proveedor($dpv_id = null, $ver_detalle = null, $redireccion = null) {
        satelite_validar();
        if ($_POST) {
            if (isset($_POST['caso_uso']) && $_POST['caso_uso'] == 3 && $dpv_id != null) {
                $this->editar_datos_dpv_inv($dpv_id);
            }
            $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            $post_array = $this->input->post();
            $tipo_btn              = (isset($post_array['btnCrear'])) ? $post_array['btnCrear'] : 0;
            $idOrdenCompra         = (isset($post_array['slcOrdenCompra'])) ? $post_array['slcOrdenCompra'] : null;
            $slcDocAfecta          = ($post_array['slcDocAfecta'] != '') ? $post_array['slcDocAfecta'] : null;
            $slcTipo               = $post_array['slcTipo'];
            $txtConcepto           = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $slcProveedor          = $post_array['slcProveedor'];
            $txtDescripcion        = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $slcTipoPago           = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
            $slcCajaChica          = ($post_array['slcCajaChica'] != '') ? $post_array['slcCajaChica'] : null;
            $slcCondicionPago      = ($post_array['slcCondicionPago'] != '') ? $post_array['slcCondicionPago'] : null;
            $hdnAfectaInv          = $post_array['hdnAfectaInv'];
            $slcTipoDocumento      = ($post_array['slcTipoDocumento'] != '') ? $post_array['slcTipoDocumento'] : null;
            $slcCentroCosto        = ($post_array['slcCentroCosto'] != '') ? $post_array['slcCentroCosto'] : null;
            $txtNumDoc             = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;
            $slcProyecto           = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $txtSerieDoc           = ($post_array['txtSerieDoc'] != '') ? $post_array['txtSerieDoc'] : null;
            $slc_presupuesto       = (isset($post_array['slc_presupuesto']) && $post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $txtFechaDoc           = ($post_array['txtFechaDoc'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDoc'])) : null;
            $slc_actividad_general = (isset($post_array['slc_actividad_general']) && $post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $txtFechaVencimiento   = ($post_array['txtFechaVencimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVencimiento'])) : null;
            $txtFechaDeclara       = ($post_array['txtFechaDeclara'] != '') ? formatear_fecha('Y-m-d', $post_array['txtFechaDeclara']) : null;
            $slc_act_especifica    = (isset($post_array['slc_actividad_espeficifica']) && $post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
            $txtFechaConta         = ($post_array['txtFechaConta'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaConta'])) : null;
            $slcTipoMonto          = ($post_array['slcTipoMonto'] != '') ? $post_array['slcTipoMonto'] : null;
            $txtNRC                = ($post_array['txtNrc']) ? $post_array['txtNrc'] : null;
            $nombre_act_especifica = ($post_array['txt_nombre_actividad'] != '') ? $post_array['txt_nombre_actividad'] : null;
            $nombre_proveedor      = ($post_array['txt_nombre_proveedor'] != '') ? $post_array['txt_nombre_proveedor'] : null;
            $txtObservacion        = ($post_array['txtObservacion']) ? $post_array['txtObservacion'] : null;
            $txtDescuentoGeneral   = (isset($post_array['txtDescuentoGeneral'])) ? $post_array['txtDescuentoGeneral'] : 0;
            $txtImpuestosGeneral   = $post_array['txtImpuestosGeneral'];
            $txtRetencionGeneral   = ($post_array['txtRetencionGeneral'] != '') ? $post_array['txtRetencionGeneral'] : 0;
            $txtSubtotalGeneral    = $post_array['txtSubtotalGeneral'];
            $txtTotalGeneral       = $post_array['txtTotalGeneral'];
            $abreviacion           = ($post_array['txt_abreviacion'] != '') ? $post_array['txt_abreviacion'] : null;            
            //$slcRetenciones       = ($post_array['slcRetenciones'] != '') ? $post_array['slcRetenciones'] : null;
            
            //aca convierte a la unidad de defecto
            $conversionDefe = $post_array['conversionDefe'];
            $conversionConv = $post_array['conversionConv'];

            //Anexos
            $TitulosAnexo   = (isset($post_array['titulo_doc'])) ? $post_array['titulo_doc'] : null;
            $NombreAnexo    = (isset($post_array['ruta'])) ? $post_array['ruta'] : null;
            $AnexoDpv       = (isset($post_array['AnexoDpv'])) ? $post_array['AnexoDpv'] : null;
            
            $edit=null;

            $id_orc = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_orc', array('dpv_id'=>$dpv_id));
            //Si se edita el documento con caja asignada.
            /* $existe_caja= $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_cch', array('dpv_id'=>$dpv_id));
            if($existe_caja>0){ $edit=1; }else{ $edit=null; }*/

            $documento_array = array(
                'dpv_id_prv'                => $slcProveedor,
                'dpv_id_tpg'                => $slcTipoPago,
                'dpv_id_tif'                => $slcTipoDocumento,
                'dpv_id_cch'                => $slcCajaChica,
                'dpv_id_dpv_afecta'         => $slcDocAfecta,
                'dpv_id_pcl'                => $slcProyecto,
                'dpv_id_tmt'                => $slcTipoMonto,
                'dpv_id_cec'                => $slcCentroCosto,
                'dpv_id_cod'                => $slcCondicionPago,
                'dpv_serie_documento'       => $txtSerieDoc,
                'dpv_numero_documento'      => $txtNumDoc,
                'dpv_fecha_documento'       => $txtFechaDoc,
                'dpv_fecha_contabilizacion' => $txtFechaConta,
                'dpv_fecha_vencimiento'     => $txtFechaVencimiento,
                'dpv_fecha_declaracion'     => $txtFechaDeclara,
                'dpv_concepto'              => $txtConcepto,
                'dpv_descripcion'           => $txtDescripcion,
                'dpv_afecta_inventario'     => $hdnAfectaInv,
                'dpv_tipo'                  => $slcTipo,
                'dpv_monto_pendiente'       => convertirFloat($txtTotalGeneral),
                'dpv_impuesto'              => convertirFloat($txtImpuestosGeneral),
                'dpv_descuento'             => convertirFloat($txtDescuentoGeneral),
                'dpv_retencion'             => convertirFloat($txtRetencionGeneral),
                'dpv_subtotal'              => convertirFloat($txtSubtotalGeneral),
                'dpv_total'                 => convertirFloat($txtTotalGeneral),
                'dpv_observacion'           => $txtObservacion,
                'dpv_estado'                => 1,
                'dpv_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'dpv_fecha_modificacion'    => date('Y-m-d H:i:s'),
                'dpv_id_psp'                => $slc_presupuesto,
                'dpv_id_ace'                => $slc_act_especifica,
                'dpv_id_acg'                => $slc_actividad_general
            );

            $resultado = $this->gsatelite->actualizar_array('dpv_documento_proveedor', $documento_array, array('dpv_id' => $dpv_id));
            //se borrar gastos si existen
            $this->gsatelite->borrado_general('dgp_detalle_gasto_prespuesto', array('dgp_id_dpv' => $dpv_id));
            //se verificara si se agregaran gastos a presupuestos.
            if ( $slcProyecto != "" && $slc_act_especifica != "" ) {
                $condiciones = array(
                    "dps_id_ace"    => $slc_act_especifica,
                    "dps_id_acg"    => $slc_actividad_general,
                    "dps_id_psp"    => $slc_presupuesto,
                );
                $detalle_presupuesto = $this->gsatelite->get_campo("dps_detalle_presupuesto","dps_id",$condiciones);
                if ( $detalle_presupuesto != null ) {
                    $dgp_detalle_gasto_prespuesto = array(
                        'dgp_id_dps'            => $detalle_presupuesto,
                        'dgp_id_tgp'            => 5,
                        'dgp_id_dpv'            => $dpv_id,
                        'dgp_fecha'             => $txtFechaDoc,
                        'dgp_descripcion'       => $nombre_proveedor,
                        'dgp_referencia'        => $abreviacion." - ".$txtNumDoc,
                        'dgp_cantidad'          => 1,
                        'dgp_monto'             => convertirFloat($txtTotalGeneral),
                        'dgp_total_retencion'   => convertirFloat($txtRetencionGeneral),
                        'dgp_total_impuesto'    => convertirFloat($txtImpuestosGeneral),
                        'dgp_sub_monto'         => convertirFloat($txtSubtotalGeneral),
                        'dgp_origen'            => null,
                        'dgp_referencia_origen' => null,
                        'dgp_estado'            => 1,
                        'dgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'dgp_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'dgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'dgp_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $dgp_id = $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dgp_detalle_gasto_prespuesto);
                }
            }

            if ($resultado > 0) {

                //Se obtienen los detalles de la grid para actualizar
                $row       = $post_array['row_actual'];
                $productosIds       = $post_array['hdnDetalle'];
                $cantidad_real      = $post_array['cantidades_real'];
                $hdnDetalleProd     = $post_array['hdnDetalleProd'];
                $txtCantidadesDpv   = $post_array['txtCantidadesDpv'];
                $txtPreciosDpv      = $post_array['txtPreciosDpv'];
                $BodegasDpv         = $post_array['hdnBodegasDpv'];
                $SectoresDpv        = $post_array['hdnSectoresDpv'];
                $impuestosDetalle   = $post_array['hdnImpuestosDpv'];
                $impuestosDpv       = $post_array['impuestosDpv'];
                $tiposVentaDpv      = $post_array['tiposVentaDpv'];
                $retencionesDetalle = $post_array['hdnRetencionesDpv'];
                $retencionesDpv     = $post_array['retencionesDpv'];
                $DescuentosDpv      = $post_array['hdnDescuentosDpv'];
                $subtotalesDpv      = $post_array['subtotalesDpv'];
                $totalesDpv         = $post_array['totalesDpv'];
                $descripcionProd    = $post_array['descripcionProd'];

                //Se eliminan los registros necesarios.
                //Se verifica si se eliminaron productos.
                $where = array(
                    'dxd_id_dpv' => $dpv_id
                );
                $dataDetalle = $this->compras_model->get_detalle_doc_proveedor($where);
                if (!is_array($productosIds)) {
                    $productosIds = array();
                }

                foreach ($dataDetalle as $data) {
                    if (!in_array($data['dxd_id'], $productosIds)) {
                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('idd_impuestoxdetalle_documento', array('idd_id_dxd' => $data['dxd_id']));
                        //Se eliminan las retenciones del detalle
                        $this->gsatelite->borrado_general('rxd_retencionxdetalle_documento', array('rxd_id_dxd' => $data['dxd_id']));
                        //se eliminana los prorrateos 
                        $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dxd' => $data['dxd_id']));
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('dxd_detalle_documento_proveedor', array('dxd_id' => $data['dxd_id']));
                        //
                    }
                }

                //Se actualizan los detalles
                if (count($productosIds) > 0) {
                    for ($i = 0; $i < count($productosIds); $i++) {
                        //Eliminar los detalles prorratedo
                        $this->db->join('pxd_prorrateoxdetalle_documento', 'dxd_id = pxd_id_dxd');
                        $last_dtpro = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $productosIds[$i]));
                            // print_r($last_dtpro);
                        foreach ($hdnDetalleProd as $index => $valueDP) {
                            $idsCnt = $post_array['cuentacontable_'.$valueDP];//id de la cuenta contable
                            if ($this->input->post('cuentacontable_'.$valueDP)) {
                                foreach ($idsCnt as $indexCnt => $idCnt) {
                                    // print_r($idsCnt);
                                    foreach ($last_dtpro as $key => $dtpro) {
                                        if (!in_array($dtpro['dxd_id'], $productosIds)) {
                                            $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dxd' => $dtpro['dxd_id'],'pxd_id_cnt' => $idCnt));
                                        }
                                    }
                                }
                            }else{
                                foreach ($last_dtpro as $key => $last_iddxd) {
                                    $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dxd' => $last_iddxd['dxd_id']));
                                }
                            }
                        }

                        $this->db->join('pxd_prorrateoxdetalle_documento', 'dxd_id = pxd_id_dxd');
                        $prorrateo_array = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $productosIds[$i]));
                        $prorrateo_id_array = array_column($prorrateo_array, 'pxd_id');
                        $prorrateo_exist = $this->input->post('prorrateo_exist_'.$row[$i].'_'.$hdnDetalleProd[$i]);
                        foreach ($prorrateo_id_array as $key_pro => $prorrateo_ids) {
                            if(!in_array($prorrateo_ids, $prorrateo_exist)){
                                $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id' => $prorrateo_ids));
                            }
                        }
                        //Fin eliminar detalle prorrateo

                        $detalle_array = array(
                            'dxd_id_bod'            => ($BodegasDpv[$i] > 0) ? $BodegasDpv[$i] : null,
                            'dxd_id_sxb'            => ($SectoresDpv[$i] > 0) ? $SectoresDpv[$i] : null,
                            'dxd_id_tpv'            => ($tiposVentaDpv[$i] != '') ? $tiposVentaDpv[$i] : null,
                            'dxd_cantidad'          => convertirFloat($txtCantidadesDpv[$i]),
                            'dxd_precio_unitario'   => convertirFloat($txtPreciosDpv[$i]),
                            'dxd_impuesto'          => convertirFloat($impuestosDpv[$i]),
                            'dxd_descuento'         => ($DescuentosDpv[$i] != '') ? convertirFloat($DescuentosDpv[$i]) : 0,
                            'dxd_retencion'         => convertirFloat($retencionesDpv[$i]),
                            'dxd_subtotal'          => convertirFloat($subtotalesDpv[$i]),
                            'dxd_descripcion'       => $descripcionProd[$i],
                            'dxd_total'             => convertirFloat($totalesDpv[$i]),
                            'dxd_estado'            => 1,
                            'dxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion'=> date('Y-m-d H:i:s'),
                        );

                        $resultado = $this->gsatelite->actualizar_array('dxd_detalle_documento_proveedor', $detalle_array, array('dxd_id' => $productosIds[$i]));
                        if($resultado>0){
                             ////// ACTUALIZAR CANTIDAD EN LOS DETALLES DE LA ORDEN DE COMPRA (SI APLICA) ///////
                            if($id_orc>0){
                                $det_dor = $this->gsatelite->get_tabla('dor_detalle_orden_compra', array('dor_id_orc'=>$id_orc,'dor_id_art'=>$hdnDetalleProd[$i]));
                                if(count($det_dor)>0){
                                    $pendiente = convertirFloat($cantidad_real[$i]) - convertirFloat($txtCantidadesDpv[$i]);

                                    $this->gsatelite->actualizar_array('dor_detalle_orden_compra', array('dor_cantidad_pendiente'=>$pendiente), array('dor_id'=>$det_dor[0]['dor_id']));
                                }
                            }
                        }

                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('idd_impuestoxdetalle_documento', array('idd_id_dxd' => $productosIds[$i]));
                        //Se ingresan nuevamente
                        if (count($impuestosDetalle) > 0) {
                            //Se crea el array de los impuestos
                            $impuestos_array = explode(',', $impuestosDetalle[$i]);
                            foreach ($impuestos_array as $key => $value) {
                                if (trim($value) != '') {
                                    $tax = $this->gsatelite->get_campo('imp_impuesto','imp_porcentaje', array('imp_id'=>$value));
                                    if ($tax > 0) {
                                        $por_imp = $tax;
                                        $mon_imp = ($por_imp / 100) * $subtotalesDpv[$i];
                                    } else {
                                        $por_imp = $this->gsatelite->get_campo('imp_impuesto','imp_valor', array('imp_id'=>$value));
                                        $mon_imp = $txtCantidadesDpv[$i] * $por_imp;
                                    }
                                    $ixo_array = array(
                                        'idd_id_imp'            => $value,
                                        'idd_id_dxd'            => $productosIds[$i],
                                        'idd_porcentaje'        => $por_imp,
                                        'idd_monto'             => $mon_imp,
                                        'idd_estado'            => 1,
                                        'idd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'idd_fecha_modificacion'=> date('Y-m-d H:i:s'),
                                        'idd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                        'idd_fecha_creacion'    => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                }
                            }
                        }

                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('rxd_retencionxdetalle_documento', array('rxd_id_dxd' => $productosIds[$i]));
                        //Se valida existan retenciones
                        if (count($retencionesDetalle) > 0) {
                            //Se crea el array de los retenciones
                            $retenciones_array = explode(',', $retencionesDetalle[$i]);

                            if (count($retenciones_array) > 0) {
                                //Se recore el array para la insercion de impuestos
                                for ($j = 0; $j < count($retenciones_array); $j++) {
                                    if ($retenciones_array[$j] != '') {
                                        $por_ret = $this->gsatelite->get_campo('ret_retencion','ret_porcentaje', array('ret_id'=>$retenciones_array[$j]));
                                        if($por_ret  >0 ){
                                            $mon_ret    = ($por_ret/100)*$subtotalesDpv[$i];
                                        }else{
                                            $ret_val    = $this->gsatelite->get_campo('ret_retencion','ret_valor', array('ret_id'=>$impuestos_array[$j]));                                          
                                            $mon_ret    = $txtCantidadesDpv[$i] * $ret_val;
                                            $por_ret    = $ret_val;
                                        }
                                        $rxd_array = array(
                                            'rxd_id_ret'            => $retenciones_array[$j],
                                            'rxd_id_dxd'            => $productosIds[$i],
                                            'rxd_monto'             => $mon_ret,
                                            'rxd_porcentaje'        => $por_ret,
                                            'rxd_estado'            => 1,
                                            'rxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                            'rxd_fecha_modificacion'=> date('Y-m-d H:i:s'),
                                            'rxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                            'rxd_fecha_creacion'    => date('Y-m-d H:i:s')
                                        );

                                        $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                    }
                                }
                            }
                        }

                        //Se procesan los detalles del prorrateo ya ingresados.
                        if (count($post_array['hdnCec_' . $hdnDetalleProd[$i]]) > 0) {
                            $hdnIdsPxd = $post_array['hdnCec_' . $hdnDetalleProd[$i]];
                            $porcentajes = $post_array['porcentajesPxd_' . $hdnDetalleProd[$i]];
                            $totales = $post_array['totalPxd_' . $hdnDetalleProd[$i]];
                            for ($j = 0; $j < count($post_array['hdnCec_' . $hdnDetalleProd[$i]]); $j++) {
                                if ($porcentajes[$j] != '') {
                                    $detalle_pro_array = array(
                                        'pxd_porcentaje'        => $porcentajes[$j],
                                        'pxd_total'             => convertirFloat($totales[$j]),
                                        'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->actualizar_array('pxd_prorrateoxdetalle_documento', $detalle_pro_array, array('pxd_id' => $hdnIdsPxd[$j]));
                                }
                            }
                        }

                        //Se procesan los nuevos
                        //Se procesan los detalles del prorrateo
                        if (isset($post_array['centroCostos_' . $hdnDetalleProd[$i]]) && count($post_array['centroCostos_' . $hdnDetalleProd[$i]]) > 0) {

                            $centros_costo = $post_array['centroCostos_' . $hdnDetalleProd[$i]];
                            $porcentajes = $post_array['porcentajesCec_' . $hdnDetalleProd[$i]];
                            $totales = $post_array['totalCec_' . $hdnDetalleProd[$i]];
                            $cuentacontable = $post_array['cuentacontablenew_' . $hdnDetalleProd[$i]];
                            $pxd_id_cec         = $post_array['codigo_centro_costo_' . $hdnDetalleProd[$i]];

                            for ($j = 0; $j < count($post_array['centroCostos_' . $hdnDetalleProd[$i]]); $j++) {
                                // if ($centros_costo[$j] != '') {
                                $detalle_pro_array = array(
                                    'pxd_id_dpr'            => (trim($centros_costo[$j]) != "") ? $centros_costo[$j] : NULL,
                                    'pxd_id_dxd'            => $productosIds[$i],
                                    'pxd_id_cnt'            => ($cuentacontable[$j] != "")?$cuentacontable[$j]:NULL,
                                    'pxd_id_cec'            => ($pxd_id_cec[$j] != "")?$pxd_id_cec[$j]:NULL,
                                    'pxd_porcentaje'        => $porcentajes[$j],
                                    'pxd_total'             => convertirFloat($totales[$j]),
                                    'pxd_estado'            => 1,
                                    'pxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'pxd_fecha_creacion'    => date('Y-m-d H:i:s'),
                                    'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                // }
                            }
                        }
                    }
                }

                //Se obtienen los detalles de la grid
                $productos = (isset($post_array['productos'])) ? $post_array['productos'] : null;
                $conversiones = (isset($post_array['productos'])) ? $post_array['conversion'] : null;
                $cantidades = (isset($post_array['productos'])) ? $post_array['cantidades'] : null;
                $precios = (isset($post_array['productos'])) ? $post_array['precios'] : null;
                $retenciones = (isset($post_array['productos'])) ? $post_array['retenciones'] : null;
                $impuestos = (isset($post_array['productos'])) ? $post_array['impuestos'] : null;
                $bodegas = (isset($post_array['productos'])) ? $post_array['bodegas'] : null;
                $sectores = (isset($post_array['productos'])) ? $post_array['sectores'] : null;
                $impuestosProducto = (isset($post_array['productos'])) ? $post_array['impuestosProducto'] : null;
                $retencionesProducto = (isset($post_array['productos'])) ? $post_array['retencionesProducto'] : null;
                $tiposVenta = (isset($post_array['productos'])) ? $post_array['tiposVenta'] : null;
                $descuentos = (isset($post_array['productos'])) ? $post_array['descuentos'] : null;
                //$gastos = $post_array['gastos'];
                $subtotalesProducto = (isset($post_array['productos'])) ? $post_array['subtotalesProducto'] : null;
                $totalesProducto = (isset($post_array['productos'])) ? $post_array['totalesProducto'] : null;
                $newdescripcionProd = (isset($post_array['newdescripcionProd'])) ? $post_array['newdescripcionProd'] : null;

                if (count($productos) > 0) {
                    //Se ingresan los detalles de la orden
                    for ($i = 0; $i < count($productos); $i++) {

                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;

                        //Se validan los registros en base al tipo de orden
                        //1 = Producto, 2 = Servicio, 3 = Activo Fijo
                        // if ($slcTipo == 1) {
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // } else if ($slcTipo == 2) {
                        //     $producto_id = $productos[$i];
                        // } else if($slcTipo == 4){
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // } else {
                        //     // $activo_id = $productos[$i];
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // }

                        $producto_id = $productos[$i];
                        $conversion_prodc = (trim($conversiones[$i])?$conversiones[$i]:null);

                        $detalle_array = array(
                            'dxd_id_bod' => ($bodegas[$i] > 0) ? $bodegas[$i] : null,
                            'dxd_id_sxb' => ($sectores[$i] > 0) ? $sectores[$i] : null,
                            'dxd_id_dpv' => $dpv_id,
                            'dxd_id_act' => $activo_id,
                            'dxd_id_cva' => $conversion_prodc,
                            'dxd_id_art' => $producto_id,
                            'dxd_id_tpv' => ($tiposVenta[$i] != '') ? $tiposVenta[$i] : null,
                            'dxd_cantidad' => convertirFloat($cantidades[$i]),
                            'dxd_precio_unitario' => convertirFloat($precios[$i]),
                            'dxd_impuesto' => convertirFloat($impuestosProducto[$i]),
                            'dxd_descuento' => ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0,
                            'dxd_retencion' => convertirFloat($retencionesProducto[$i]),
                            'dxd_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dxd_total' => convertirFloat($totalesProducto[$i]),
                            'dxd_descripcion' => $newdescripcionProd[$i],
                            'dxd_estado' => 1,
                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_creacion' => date('Y-m-d H:i:s'),
                        );

                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);

                        //Si se ingresa el detalle, se ingresan los impuestos y retenciones
                        if ($dxd_id > 0) {
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {
                                        if ($impuestos_array[$j] != '') {
                                            $por_imp = $this->gsatelite->get_campo('imp_impuesto','imp_porcentaje', array('imp_id'=>$impuestos_array[$j]));
                                            if($por_imp>0){
                                                $mon_im = ($por_imp/100)*$subtotalesProducto[$i];
                                            }else{
                                                $imp_val    = $this->gsatelite->get_campo('imp_impuesto','imp_valor', array('imp_id'=>$impuestos_array[$j]));                                          
                                                $mon_im     = $cantidades[$i] * $imp_val;
                                                $por_imp    = $imp_val;
                                            }
                                            $ixo_array = array(
                                                'idd_id_imp'            => $impuestos_array[$j],
                                                'idd_id_dxd'            => $dxd_id,
                                                'idd_porcentaje'        => $por_imp,
                                                'idd_monto'             => $mon_im,
                                                'idd_estado'            => 1,
                                                'idd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                                'idd_fecha_modificacion'=> date('Y-m-d H:i:s'),
                                                'idd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                                'idd_fecha_creacion'    => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                        }
                                    }
                                }
                            }

                            //Se valida existan retenciones
                            if (count($retenciones) > 0) {
                                //Se crea el array de los retenciones
                                $retenciones_array = explode(',', $retenciones[$i]);

                                if (count($retenciones_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($retenciones_array); $j++) {

                                        if ($retenciones_array[$j] != '') {
                                            $rxd_array = array(
                                                'rxd_id_ret' => $retenciones_array[$j],
                                                'rxd_id_dxd' => $dxd_id,
                                                'rxd_estado' => 1,
                                                'rxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'rxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                        }
                                    }
                                }
                            }

                            //Se procesan los detalles del prorrateo
                            if (count($post_array['centroCostos_' . $productos[$i]]) > 0) {
                                $centros_costo = $post_array['centroCostos_' . $productos[$i]];
                                $porcentajes = $post_array['porcentajesCec_' . $productos[$i]];
                                $totales = $post_array['totalCec_' . $productos[$i]];
                                $cuentacontable = $post_array['cuentacontablenew_' . $productos[$i]];
                                for ($j = 0; $j < count($post_array['centroCostos_' . $productos[$i]]); $j++) {
                                    // if ($centros_costo[$j] != '') {
                                    $detalle_pro_array = array(
                                        'pxd_id_dpr' => (trim($centros_costo[$j]) != "") ? $centros_costo[$j] : NULL,
                                        'pxd_id_dxd' => $dxd_id,
                                        'pxd_id_cnt' => $cuentacontable[$j],
                                        'pxd_porcentaje' => $porcentajes[$j],
                                        'pxd_total' => $totales[$j],
                                        'pxd_estado' => 1,
                                        'pxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'pxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                    // }
                                }
                            }
                        }
                    }
                }

                //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                $dataAnexos = $this->gsatelite->get_tabla('adp_anexo_documento', array('adp_id_dpv' => $dpv_id));
                if (!is_array($AnexoDpv)) {
                    $AnexoDpv = array();
                }
                foreach ($dataAnexos as $data) {
                    if (!in_array($data['adp_id'], $AnexoDpv)) {
                        $this->gsatelite->borrado_general('adp_anexo_documento', array('adp_id' => $data['adp_id']));
                        $ruta_nxp = $data['adp_url'];
                        unlink($ruta_nxp);
                    }
                }

                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);

                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_doc_proveedor/" . $nombreArchivo;

                        $documentos_array = array(
                            'adp_id_dpv' => $dpv_id,
                            'adp_url' => $carpeta_destino_anx,
                            'adp_nombre' => $nombreArchivo,
                            'adp_estado' => 1,
                            'adp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'adp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'adp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'adp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $nxp_id = $this->gsatelite->ingresar('adp_anexo_documento', $documentos_array);

                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }

                if ($hdnAfectaInv == 1 && ($slcTipo == 1 || $slcTipo == 4)) {
                    $tipoProcesos = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
                    $tipoProcesos_array = json_decode($tipoProcesos, true);

                    $this->db->order_by('dxd_id_bod');
                    $this->db->group_by('dxd_id_bod');
                    $detalle_query = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod !=' => ''));

                    $movimientos_array = array();

                    //Se crean todos los movimientos
                    foreach ($detalle_query as $dxd) {
                        $movimientos_array[]['movimientos'] = array(
                            'moi_id_prv' => $slcProveedor,
                            'moi_id_tip' => $tipoProcesos_array['DOC_PROV'],
                            'moi_id_bod' => $dxd['dxd_id_bod'],
                            'moi_id_dpv' => $dpv_id,
                            'moi_documento' => $txtNumDoc,
                            'moi_descripcion' => $txtConcepto,
                            'moi_fecha_mov' => date('Y-m-d H:i:s'),
                            'moi_estado' => 1,
                            'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                            'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }

                    //Se crean los detalles del movimiento
                    for ($i = 0; $i < count($movimientos_array); $i++) {

                        $bod_id = $movimientos_array[$i]['movimientos']['moi_id_bod'];

                        $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod' => $bod_id));
                        if (count($detalles_doc) > 0) {
                            $desc_prod = ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0;
                            foreach ($detalles_doc as $key => $det) {
                                if($det['art_tipo'] == 0){
                                    $precio_uni = convertirFloat($det['dxd_precio_unitario']);
                                    $descuento_art = ($precio_uni)-(($precio_uni)*($desc_prod/100));

                                    $nueva_cantidad_actu = convertirFloat( ($det['dxd_cantidad']*($conversionConv[$i]/$conversionDefe[$i]) ) );
                                    $nueva_precio_actu = convertirFloat(($descuento_art*($conversionDefe[$i]/$conversionConv[$i]) ) );

                                    if ($costo_promedio == 1) {
                                        $nuevo_precio =  $this->recalcular_precio_promedio($det['dxd_id_art'], $bod_id, $nueva_cantidad_actu, $nueva_precio_actu);
                                    }

                                    $movimientos_array[$i]['detalles'][$key]['sar_saldo'] = array(
                                        'sar_id_art' => $det['dxd_id_art'],
                                        'sar_id_bod' => $bod_id,
                                        'sar_cant_actual' => $nueva_cantidad_actu,
                                        'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $nueva_precio_actu,                                        
                                        'sar_fecha_caducidad' => null,
                                        'sar_id_sxb' => $det['dxd_id_sxb'],
                                        'sar_estado' => 1,
                                        'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $movimientos_array[$i]['detalles'][$key]['dee_movimiento'] = array(
                                        'dee_id_moi' => null,
                                        'dee_id_art' => $det['dxd_id_art'],
                                        'dee_id_sar' => null,
                                        'dee_id_cva' => $det['dxd_id_cva'],
                                        'dee_id_sxb' => $det['dxd_id_sxb'],
                                        'dee_cantidad' => $nueva_cantidad_actu,
                                        'dee_precio' => $nueva_precio_actu,
                                        'dee_subtotal' => convertirFloat($det['dxd_subtotal']),
                                        'dee_estado' => 1,
                                        'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $movimientos_array[$i]['detalles'][$key]['dxd_detalle_doc'] = array(
                                        'dxd_id' => $det['dxd_id'],
                                        'dxd_procesado_inventario' => 1,
                                        'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    );
                                }

                            }
                        }
                    }
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            //modificar la partida contable
            $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_COMPRA');
            if ( $generar_partida > 0) {
                $this->generar_partida_automatica_doc_proveedor($dpv_id,2);
            }

            $this->ingresar_entrada($movimientos_array);


            ///////////////////////////// Si se paga por caja chica ////////////////////////////////////////////////////

            if($slcCajaChica>0){
                $id_lcc = $post_array['id_lcc'];
                $this->registro_caja_chica($dpv_id, $documento_array, $id_lcc, $edit, $txtNRC);

            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if ($resultado > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "El registro se actualizó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }


            $this->session->set_flashdata($alerta);
            
            if ($tipo_btn == 1 && $hdnAfectaInv != 1) {
                redirect('modulo_compras/procesos/editar_doc_proveedor/' . $dpv_id);
            } else {
                $idOrdenCompra = ($redireccion > 0) ? '' : $idOrdenCompra;
                redirect('modulo_compras/procesos/documentos_proveedor/' . $idOrdenCompra);
            }
        }
        // *********************************************************************************************** \\
        $permiso_compra = false;
        $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA',"");
        $permisos_array = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
        if (is_array($permisos_array) && count($permisos_array) > 0 ) {
            $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
            foreach ($roles as $role) {
                if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                    $permiso_compra = true;
                }
            }
        }
        $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
        $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;
        $data["permiso_compra"] = $permiso_compra;   
        $doc_proveedor          = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
        $data['orden']          = $doc_proveedor[0]['dpv_id_orc'];
        //$data['doc_proveedor']  = (count($doc_proveedor) > 0) ? $doc_proveedor : ''; //print_r($doc_proveedor);die();
        $data['tipo_pago']      = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', 'pagos', array('tpg_estado' => 1), $doc_proveedor[0]['dpv_id_tpg'], null, null, true);

        $data['retenciones']    = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $data['tipo_venta']     = $this->gsatelite->get_dropdown('tpv_tipo_venta', '{tpv_nombre}', 'tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_compra' => 1), null, null, null, true);
        $data['bodegas']        = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', 'bodegas', array('bod_estado' => 1), null, null, null, true);
        $data['documentosAfecta'] = $this->gsatelite->get_dropdown('dpv_documento_proveedor', 'dpv_numero_documento', 'documentoAfecta', array('dpv_id_prv' => $doc_proveedor[0]['dpv_id_prv'], 'dpv_id !=' => $dpv_id), $doc_proveedor[0]['dpv_id_dpv_afecta'], null, null, true);
        $data['doc_proveedor']  = $doc_proveedor[0];

        $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id)); 

        $data['anexos_doc']     = $this->gsatelite->get_tabla('adp_anexo_documento', array('adp_id_dpv' => $dpv_id));
        $data['prorrateos']     = $this->gsatelite->get_dropdown('ptg_prorrateo_gasto', '{ptg_nombre}', 'prorrateos', array('ptg_estado' => 1), null, null, null, true);
        $data['centro_costos']  = $this->gsatelite->get_tabla("cec_centro_costo",array('cec_estado' => 1));
        $orc_id                 = $doc_proveedor[0]['dpv_id_orc'];

        if ($orc_id > 0) {
            $data['orden_compra'] = $orc_id;
            $data['ordenes_data'] = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
            $data['ordenes'] = $this->gsatelite->get_dropdown('orc_orden_compra', 'orc_numero', '', array('orc_id' => $orc_id), $orc_id, null, null, true);

            //Verificar si existe dpv para validar el tipo de documento
            $this->db->where('dpv_id !=', $dpv_id);
            $this->db->group_by('dpv_id_tif');
            $documento = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_orc' => $orc_id));

            $ids_tif = array();
            foreach ($documento as $doc) {
                $ids_tif[] = $doc['dpv_id_tif'];
            }

            if (count($documento) > 0) {
                $this->db->where('tif_estado', 1);
                $this->db->where('tif_aplica_compra', 1);
                $this->db->where_not_in('tif_id', $ids_tif);
                $this->db->or_where('tif_id', $doc_proveedor[0]['dpv_id_tif']);
                $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', null, $doc_proveedor[0]['dpv_id_tif'], null, null, true);
            } else {
                $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', array('tif_estado' => 1,'tif_aplica_compra' => 1), null, null, null, true);
            }
        } else {
            $data['orden_compra'] = null;
            $data['ordenes'] = "";
        }
        $data['condiciones']    = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), $doc_proveedor[0]['dpv_id_cod'], null, null, true);
        $data['centro_costo']   = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), $doc_proveedor[0]['dpv_id_cec'], null, null, true);
        $tipo_documento         = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1,'tif_aplica_compra' => 1) );
        $select_documento       = '<option value = ""></option>';
        foreach ($tipo_documento as $key => $tipo) {
            $selected = ($doc_proveedor[0]['dpv_id_tif'] == $tipo["tif_id"] )?"selected":"";
            $select_documento   .= '<option value = "'.$tipo["tif_id"].'" data-abreviatura="'.$tipo["tif_abreviacion"].'" '.$selected.'>'.$tipo["tif_nombre"].'</option>';
        }

        $data['tipo_documento'] = $select_documento;
        $proveedores            = $this->compras_model->get_proveedor_pers();
        $options                = '<option value=""></option>';
        foreach ($proveedores as $key) {
            if ($key['pro'] != '') {
                if ($doc_proveedor[0]['dpv_id_prv'] == $key['prv_id']) {
                    $options .= '<option data-nombre = "' . $key['nombre'] . '" data-dias = "' . $key['prv_dias_plazo'] . '" value="' . $key['prv_id'] . '" selected>' . $key['pro'] . '</option>';
                } else {
                    $options .= '<option data-nombre = "' . $key['nombre'] . '" data-dias = "' . $key['prv_dias_plazo'] . '" value="' . $key['prv_id'] . '" >' . $key['pro'] . '</option>';
                }
            }
        }

        $data['proveedores'] = $options;

        ///////////////////// Sólo cajas chicas que poseen monto disponible /////////////////////////////
        $this->db->limit(1);
        $cch_id_emp  = $this->gsatelite->get_campo( "emp_empleado", "emp_id", array( "emp_id_usu" => $this->tank_auth->get_user_id() ) );
        if(!($ver_detalle > 0)){
            $this->db->where(array('lcc_corte'=>0));
        }
                 $this->db->join('lcc_liquidacion_caja_chica', 'lcc_id_cch=cch_id AND lcc_disponible IS NOT NULL');
        $cajas = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado'=>1,'cch_id_emp'=>$cch_id_emp));
        if (count($cajas) == 0 && $ver_detalle != '') {
            $cajas = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado'=>1,'cch_id'=>$doc_proveedor[0]['dpv_id_cch']));
        }
        $opt_cajas = '<option value=""></option>';
        foreach ($cajas as $cj) {
            if( $doc_proveedor[0]['dpv_id_cch']==$cj['cch_id']){ $select="selected"; }else{ $select=''; }
            $saldo = ($ver_detalle > 0) ? '' : ' (' . $cj['lcc_disponible'] . ')';
            $opt_cajas .='<option value="'.$cj['cch_id'].'"  data-lcc="'.$cj['lcc_id'].'" '.$select.'>'.$cj['cch_nombre'].$saldo.'</option>';
        }
        $data['cajas_chicas'] = $opt_cajas;
        /////////////////////////////////////////////////////////////////////////////////////////////////

        $dis = $this->gsatelite->get_tabla('agp_agenda_pago', array('agp_estado'=>1, 'agp_id_dpv'=>$dpv_id));
        if(count($dis)>0){ $data['disabled']=1; }else{ $data['disabled']=0; }
        ////////////////////////////////////////////////////////////////////////////////////////////////

        $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
        $select_proyecto = '<option value=""></option>';
        foreach ($proyectos_reg as $key) {
            $selected = ($doc_proveedor[0]['dpv_id_pcl'] == $key['pcl_id'])?'selected':'';

            $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
            $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
            $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
        }
        $data['proyectos'] = $select_proyecto;

        $select = "";
        $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
        foreach ($impuesto_campos as $key) {
            if ($key["imp_porcentaje"] > 0) {
                $select .= "<option data-type='1' data-porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
            } else {
                $select .= "<option data-type='0' data-porcentaje='" . $key["imp_valor"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
            }
        }

        $data["impuestos"] = $select;
        $select = "";
        $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        foreach ($retencion_campos as $key) {
            if ($key["ret_defecto"] == 1) {
                $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
            } else {
                $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
            }
        }
        $data["retencion"] = $select;
        ////////////////////////////////////////////////////////////////////////////////////////////////
        $par_nrc=$this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
        $mask = $this->gsatelite->get_registro('tde_tipo_documento', array('tde_id'=>$par_nrc));
        $data['mask'] = $mask->tde_mascara;

        $data['ver_detalle'] = ($ver_detalle == null || $ver_detalle == 0) ? null : $ver_detalle;
        $data['titulo_personal'] = "Documentos por Proveedor";
        $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $dias_pasados   = "";
        $dias_futuros   = "";
        $fechas_pasadas = "";
        $fechas_futuras = "";
        $json_meses     = $this->gsatelite->get_parametro('SYS_DOC_PROV_FECHA_CONTABLE');

        if ( $json_meses != "" ) {
            $configuracion_meses = json_decode($json_meses,true);
            if ( $configuracion_meses["DIAS_PASADOS"] != "" && is_numeric($configuracion_meses["DIAS_PASADOS"]) ) {
                $dias_pasados = $configuracion_meses["DIAS_PASADOS"];
                $fechas_pasadas = strtotime ( '-'.$dias_pasados.' day' , strtotime ( $doc_proveedor[0]['dpv_fecha_contabilizacion'] ) ) ;
                $fechas_pasadas = date ( 'Y,m,d' , $fechas_pasadas );
            }
            if ( $configuracion_meses["DIAS_FUTUROS"] != "" ) {
                $dias_futuros = $configuracion_meses["DIAS_FUTUROS"];
                $fechas_futuras = strtotime ( '+'.$dias_futuros.' day' , strtotime ( $doc_proveedor[0]['dpv_fecha_contabilizacion'] ) ) ;
                $fechas_futuras = date ( 'Y,m,d' , $fechas_futuras );
            }
        }   

        $data['dias_pasados']       = "new Date(".$fechas_pasadas.")";
        $data['dias_futuros']       = "new Date(".$fechas_futuras.")";
        $data['cheque_pendiente']   = $this->gsatelite->get_tabla('chp_cheque_pendiente', array('chp_estado' => 1, "chp_id_dpv" => $dpv_id) );
        $data['redireccion']        = $redireccion;
        $data['es_modal_ver']       = $ver_detalle;

        $slc_presupuesto            = ($doc_proveedor[0]['dpv_id_psp'] != "" )?$this->get_presupuestoxproyecto($doc_proveedor[0]['dpv_id_pcl'], $doc_proveedor[0]['dpv_id_psp'],false):'<option value=""></option>';
        $data['presupuesto']        = $slc_presupuesto;
        $slc_general                = ($doc_proveedor[0]['dpv_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_acg'],false,false):'<option value=""></option>';
        $data['general']            = $slc_general;
        $slc_especifica             = ($doc_proveedor[0]['dpv_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($doc_proveedor[0]['dpv_id_acg'], $doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_ace'],true,false,false):'<option value=""></option>';
        $data['especifica']         = $slc_especifica;

        $where['cnt_id_tcn'] = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));             
        $data['cuentas'] = $this->utm_model->get_cuentas_like_prorrateo_gral($where);

        //tipo de cuenta
        $select = $this->gsatelite->get_dropdown('tmt_tipo_monto', '{tmt_nombre}', '', array('tmt_estado' => 1), $doc_proveedor[0]['dpv_id_tmt'], '', 'tmt_id', true);
        $data["tipo_monto"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
        $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
        if ($ver_detalle == 1) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/editar_doc_proveedor', $data, true);
        } else if ($ver_detalle == 2) {
            $this->_cargarvista($data);
        } else if ($ver_detalle == 3) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/editar_doc_proveedor', $data, true);
        } else {
            $this->_cargarvista($data);
        }
    }

    public function print_doc_proveedor($dpv_id = null)    {
        satelite_validar();
        $doc_proveedor = $this->compras_model->get_datos_dpv(array('dpv_id' => $dpv_id));
        $data['titulo'] = 'Datos del Documento de Proveedor';
        $data['solotitulo'] = true;
        $header = $this->load->view('reporte/header', $data, true);
        $data['doc_prov']  = $doc_proveedor[0];
        $data['detalles']  = $doc_proveedor;
        $data['encabezado'] = $header;
        $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $html = $this->load->view('modulo_compras/procesos/imprimir_doc_proveedor', $data, true);
        $this->pdf->makePDF($html, 'L');
    }

    function editar_datos_dpv_inv($dpv_id = null){
        if ($_POST) {
            $slcPrv = $_POST['slcProveedor'];
            $serieDoc = $_POST['txtSerieDoc'];
            $numeroDoc = $_POST['txtNumDoc'];
            if ($dpv_id != null && $slcPrv > 0 && trim($serieDoc) != "" && trim($numeroDoc) != "") {
                $documento_array = array(
                    'dpv_id_prv' => $slcPrv,
                    'dpv_serie_documento' => $serieDoc,
                    'dpv_numero_documento' => $numeroDoc,
                    'dpv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dpv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('dpv_documento_proveedor', $documento_array, array('dpv_id' => $dpv_id));
                $movimientos_array = array(
                    'moi_id_prv' => $slcPrv,
                    'moi_documento' => $numeroDoc,
                    'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('moi_movimiento_inv', $movimientos_array, array('moi_id_dpv' => $dpv_id));
                redirect("modulo_compras/procesos/editar_doc_proveedor/$dpv_id/3/S");
            } else {
                redirect("modulo_compras/procesos/editar_doc_proveedor/$dpv_id/3/E");
            }            
        } else {
            redirect("modulo_compras/procesos/editar_doc_proveedor/$dpv_id/3/E");
            
        }
    }

    /*
     * @prvId = Id del Proveedor
     * @numDocumento = Si se envia, verifica la existencia del documento por proveedor (Returna True o False)
     * @Flag = Determina si se retorna el array o es via ajax
     */

    public function get_documentos_proveedor($prvId = null, $flag = false, $numDocumento = null) {
        $tipodoc     = $this->input->post('tipo');
        $idDocumento = $this->input->post('documento');
        $proveedorId = ($prvId != null) ? $prvId : $this->input->post('proveedor');
        $documento   = ($numDocumento != null) ? $numDocumento : $this->input->post('numDocumento');

        //Si existe el parametro documento solo verifica la existencia.
        if ($documento != '') {
            $numdoc = trim(str_replace(array('_',' ','-'), '', $documento));
            $where = array(
                "TRIM(REPLACE(REPLACE(REPLACE(dpv_numero_documento, ' ', ''), '_', ''), '-', '')) = '$numdoc'" => null,
                "dpv_id_prv" => $proveedorId,
                "dpv_estado" => 1
            );
            if ($tipodoc != null) { 
                $where['dpv_id_tif'] = $tipodoc;
            }
            if ($idDocumento != null) {
                $where['dpv_id !='] = $idDocumento;
            }
            $arreglo = $this->gsatelite->count('dpv_documento_proveedor', $where);
        } else {
            //Se obtienen los documentos del proveedor
            $documentos = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_prv' => $proveedorId, 'dpv_estado' => 1));
            $opciones = "<option value='0'>Seleccione</option>";
            if (count($documentos) > 0) {
                foreach ($documentos as $dpv) {
                    $opciones .= "<option value='" . $dpv['dpv_id'] . "'>" . $dpv['dpv_numero_documento'] . "</option>";
                }
            }
            $arreglo = array('documentos' => $opciones);
        }
        if (!$flag) {
            echo json_encode($arreglo);
        } else {
            return $arreglo;
        }
    }

function get_sector_bodega($bodegaId = null, $sectorId = null, $flag = false) {
    $bod_id = ($bodegaId != null) ? $bodegaId : $this->input->post('bodega');
    $sector = ($sectorId != null) ? $bodegaId : $this->input->post('sector');
    $datos_sector_bod = $this->inventario_model->get_sector_grid($bod_id);
    $select = '<option></option>';

    foreach ($datos_sector_bod as $key) {
        if ($sector == $key['sxb_id']) {
            $select .= '<option value="' . $key['sxb_id'] . '" selected>' . $key['seb_nombre'] . '</option>';
        } else {
            $select .= '<option value="' . $key['sxb_id'] . '">' . $key['seb_nombre'] . '</option>';
        }
    }

    $arreglo = array('sectores' => $select);

    if ($flag) {
        return $arreglo;
    } else {
        echo json_encode($arreglo);
    }
}

    // $flag 1 = Indica si el reporte es impresion 2 = excel
public function impresion_requisiciones_materiales($id_requisicion, $flag) {
        //obtener validacion de firmas
    $flujos         = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO',3);
    $flujos_array   = json_decode($flujos, true);
    $flujo          = $flujos_array['REQ_COMP'];
    $firmas         = $this->get_firmas_reportes($flujo, $id_requisicion);
    $filename       = 'requisiciones_materiales_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    $data['filename'] = $filename;
    $data['datos_requisicion'] = $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $id_requisicion));
    $ace = $requisicion[0]['rxi_id_ace'];
    $data['actividad_code'] = $this->gsatelite->get_campo('ace_actividad_especifica', 'ace_codigo', array('ace_id' => $ace));
    $data['actividad_name'] = $this->gsatelite->get_campo('ace_actividad_especifica', 'ace_nombre', array('ace_id' => $ace));
    $data['prioridad_name'] = $this->gsatelite->get_campo('prd_prioridad', 'prd_nombre', array('prd_id' => $requisicion[0]['rxi_id_prd']));
    $data['detalle_orden_compra'] = $this->compras_model->get_detalle_requisicion(array('dri_id_rxi' => $id_requisicion));
        // Se cambio el usuario que mostrara, ya que estaba mostrando el usuario que modifico el registro y debe ser el que solicito la requisicion
    $data['datos_usuario']   = $this->inventario_model->informacion_empleado($requisicion[0]['rxi_id_usu_solicita']);
    $autoriza                = $this->gsatelite->get_campo('users', 'username', array('id' => $requisicion[0]['rxi_id_usu_aprueba']));
        $data['usuario_aprueba'] = $autoriza;//this->inventario_model->usuario_autoriza_rxi($id_requisicion);
        $data['firmas']          = $firmas;
        if ($flag == '1') {
            $data['tipo_reporte'] = 'pdf';
            $data['titulo'] = 'Requisición de Compras';
            $html = $this->load->view('modulo_compras/procesos/impresion_requisiciones_materiales', $data, true);
            //$header = $this->load->view('reporte/header_requisicion', $data, true);
            $GLOBALS['nombre_reporte'] = 'requisiciones_materiales_' . date('dmY');
            $reporte = $header . $html;
            $this->pdf->makePdf($reporte, 'P', 'requisiciones_materiales', 'Letter');
        } else {
            $data['tipo_reporte'] = 'excel';
            $html = $this->load->view('modulo_compras/procesos/impresion_requisiciones_materiales', $data, true);
            $filename = 'requisiciones_materiales_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']   = 'Requisición de Materialess';
            $data['filename'] = $filename;
            echo $html;
        }
    }

    function anular_doc_proveedor($dpv_id, $iframe = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;
            $dpv_id_pct_anulacion   = null;
            //se quitaran los gastos
            $this->gsatelite->borrado_general('dgp_detalle_gasto_prespuesto', array('dgp_id_dpv' => $dpv_id));
            /*********************************************************************/
            //Generacion de contra partida
            $dpv_documento_proveedor = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $dpv_id));
            $partida_automatica = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_COMPRA');
            if( $dpv_documento_proveedor[0]['dpv_id_pct_anulacion'] == NUll && $partida_automatica > 0) {
                //$this->load->library('../controllers/utm/cuentas');
                $dpv_id_pct_anulacion = $this->generar_partida_automatica_anular_doc_proveedor($dpv_documento_proveedor[0]['dpv_id'],2);//$this->cuentas->generar_contra_partida($dpv_documento_proveedor[0]['dpv_id_pct'],2,20);
            }    
            /*********************************************************************/
            $dpv_id_pct_anulacion = ($dpv_id_pct_anulacion > 0) ? $dpv_id_pct_anulacion : NUll;
            $doc_array = array(
                'dpv_id_pct_anulacion'      => $dpv_id_pct_anulacion,
                'dpv_id_usu_anula'          => $this->tank_auth->get_user_id(),
                'dpv_observacion_anulacion' => $post_array['txtComentario'],
                'dpv_estado'                => 0,
                'dpv_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'dpv_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $resultado = $this->gsatelite->actualizar_array('dpv_documento_proveedor', $doc_array, array('dpv_id' => $dpv_id));
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if ($resultado > 0) {
                //Se crea la partida de anulacion
                $array = array('ccv_id_dpv' => null, 'ccv_facturado' => 0);
                $resultado_ccv = $this->gsatelite->actualizar_array('ccv_cuota_contrato_proveedor', $array, array('ccv_id_dpv' => $dpv_id));
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////  
            /**********************************************************************/
            $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
            $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $sello = "";
            if ($tipo_fact_elect == 1 && $dpv_documento_proveedor[0]['dpv_id_tif'] == $tipo_factura["SUJETO EXCLUIDO"] ) {
                if ($dpv_documento_proveedor[0]["dpv_sello_recepcion"] != "" && $dpv_documento_proveedor[0]["dpv_sello_recepcion"] != null) {
                    $jsonEnv = json_encode([
                        "codigoGeneracion" => $dpv_documento_proveedor[0]["dpv_codigo_generacion"],
                        "selloRecepcion" => $dpv_documento_proveedor[0]["dpv_sello_recepcion"],
                        "tipoAnulacion" => 2,
                        "motivo" => "Anulación",
                        "idInterno" => $dpv_documento_proveedor[0]["dpv_id"]
                    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                    ##Dar tratamiento, para todos los tipos posibles de errores
                    ##En motivo de anulacion poner minimo de 5 caracteres
                    $res_env = $this->procesar_invalidacion($jsonEnv);
                    $decode_res = json_decode($res_env, true);
                    $mensaje = $decode_res["body"]["mensage"] . " | " . $decode_res["body"]["response"]["descripcionMsg"];
                    $actualice = array(
                        "dpv_sello_anulacion_fact_elect" => $decode_res["body"]["response"]["selloRecibido"],
                        "dpv_comentario_anula_fact_elect" => $mensaje
                    );
                    $this->gsatelite->actualizar_array("dpv_documento_proveedor", $actualice, array("dpv_id" => $dpv_documento_proveedor[0]['dpv_id']));
                    $sello = "<br>Sello: ".$decode_res["body"]["response"]["selloRecibido"];
                }
            }
            //Si es iframe se enviar un parametro para cerrar el modal
            //Sino se redirecciona a la url configurada
            if ($iframe == 1) {
                $data['cerrar_modal'] = 1;
                $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Documento Anulado", 'texto_alerta' => "La anulación se procesó correctamente.");
            } else {
                $redireccionar = $post_array['redireccion'];
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Documento Anulado", 'texto_alerta' => "La anulación se procesó correctamente.");
                $this->session->set_flashdata($alerta);
                redirect($redireccionar);
            }
        }
        $doc_proveedor = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
        $data['titulo_personal'] = "Anular Documento de Proveedor - " . $doc_proveedor[0]['dpv_numero_documento'];
        $data['doc_proveedor'] = $doc_proveedor[0];
        $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id));
        $data['iframe'] = $iframe;
        if ($iframe) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/anular_doc_proveedor', $data);
        } else {
            $this->_cargarvista($data);
        }
    }

    function procesar_invalidacion($json){
        $dato_api = json_decode($this->gsatelite->get_parametro('API_KEY_FACTURACION_SAT'), true);
        $cliente_key = $dato_api["kEY_CLIENTE"];
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $dato_api["URL_INVALIDACION"],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => $json,
            CURLOPT_HTTPHEADER => array(
                "Authorization: $cliente_key",
                "Content-Type: application/json",
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    function anular_requisicion($iframe = 0, $id = null, $tipo_flujo = null) {
        satelite_validar();
        if ($_POST) {

            $post_array = $_POST;

            $txtComentario = $post_array['txtComentario'];
            $doc_array = array(
                'rxi_id_usu_anulacion' => $this->tank_auth->get_user_id(),
                'rxi_descripcion_anulacion' => $post_array['txtComentario'],
                'rxi_estado' => 5,
                'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $pasos_anulacion = $this->gsatelite->get_parametro('SYS_PASOS_ANULACION');
            $pasos_array = json_decode($pasos_anulacion, true);
            $paso_siguiente = $pasos_array['REQ_COMP'];

            $resultado = $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $doc_array, array('rxi_id' => $id));

            $paso_actual = $post_array['paso_actual'];

            //Se cierra el paso actual
            $seguimiento_requisicion = array(
                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                'sgr_observacion' => $txtComentario,
                'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));

            //Se ingresa el paso especial para anulacion
            if ($paso_siguiente > 0) {
                $seguimiento_requisicion = array(
                    'sgr_id_rxi' => $id,
                    'sgr_id_psf' => $paso_siguiente,
                    'sgr_id_usu' => $this->tank_auth->get_user_id(),
                    'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                    'sgr_estado' => 1,
                    'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                    'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
            }

            /*
             * Si es iframe se enviar un parametro para cerrar el modal
             * Sino se redirecciona a la url configurada
             */
            if ($iframe == 1) {
                $data['cerrar_modal'] = 1;
                $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición", 'texto_alerta' => "La anulación se procesó correctamente.");
            } else {
                $redireccionar = $post_array['redireccion'];
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición", 'texto_alerta' => "La anulación se procesó correctamente.");
                $this->session->set_flashdata($alerta);
                redirect($redireccionar);
            }
        }
        $data['iframe'] = $iframe;
        $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $id));
        $data['requisicion'] = $requisicion[0];

        $where = array(
            'dri_id_rxi' => $id
        );

        $paso_actual = $this->inventario_model->get_paso_actual($id, $tipo_flujo);
        $data['paso_actual'] = $paso_actual[0];

        $data['solicitante'] = $this->inventario_model->informacion_empleado($requisicion[0]['rxi_id_usu_solicita']);
        $data['detalle_requisicion'] = $this->inventario_model->get_requisicion_detalle($where);
        $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/anular_requisicion', $data, true);
    }

    function ver_detalle_orden($iframe = 0, $registro = null, $tipo_flujo = null) {
        satelite_validar();
        $data['iframe'] = $iframe;
        $orden_compra = $this->compras_model->get_ordenes_compra(array('orc_id' => $registro));
        $data['orden_compra'] = $orden_compra[0];
        if ($orden_compra[0]['rxi_id_ord'] != "") {
            $data['orden_prod'] = $this->gsatelite->get_campo('ord_orden', 'ord_codigo', array('ord_id' => $orden_compra[0]['rxi_id_ord']));
        }
        $where = array('dor_id_orc' => $registro);
        $data['solicitante'] = $this->inventario_model->informacion_empleado($orden_compra[0]['orc_id_usu_solicita']);
        $data['detalle_orden'] = $detalle_orc = $this->compras_model->get_detalle_orden_compra($where);
        $data['orden'] = $detalle_orc[0];
        $data['anexos'] = $this->gsatelite->get_tabla('aoc_anexo_orden_compra', array('aoc_id_orc' => $registro));
        $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/detalle_orden_compra', $data, true);
    }

    function anular_orden_compra($iframe = 0, $registro = null, $tipo_flujo = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;

            $txtComentario = $post_array['txtComentario'];
            $doc_array = array(
                'orc_id_usu_anulacion' => $this->tank_auth->get_user_id(),
                'orc_descripcion_anulacion' => $post_array['txtComentario'],
                'orc_estado' => 5,
                'orc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'orc_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $pasos_anulacion = $this->gsatelite->get_parametro('SYS_PASOS_ANULACION');
            $pasos_array = json_decode($pasos_anulacion, true);
            $paso_siguiente = $pasos_array['ORDEN_COMPRA'];

            $resultado = $this->gsatelite->actualizar_array('orc_orden_compra', $doc_array, array('orc_id' => $registro));

            $paso_actual = $post_array['paso_actual'];

            //Se cierra el paso actual
            $seguimiento_orden = array(
                'sgo_id_usu' => $this->tank_auth->get_user_id(),
                'sgo_observacion' => $txtComentario,
                'sgo_fecha_salida' => date('Y-m-d H:i:s'),
                'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $this->gsatelite->actualizar_array('sgo_seguimiento_orden', $seguimiento_orden, array('sgo_id' => $paso_actual));

            //Se ingresa el paso especial para anulacion
            if ($paso_siguiente > 0) {
                $seguimiento_orden = array(
                    'sgo_id_orc' => $registro,
                    'sgo_id_psf' => $paso_siguiente,
                    'sgo_id_usu' => $this->tank_auth->get_user_id(),
                    'sgo_fecha_entrada' => date('Y-m-d H:i:s'),
                    'sgo_estado' => 1,
                    'sgo_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgo_fecha_creacion' => date('Y-m-d h:i:s'),
                    'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_orden);
            }

            /*
             * Si es iframe se enviar un parametro para cerrar el modal
             * Sino se redirecciona a la url configurada
             */
            if ($iframe == 1) {
                $data['cerrar_modal'] = 1;
                $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "La anulación se procesó correctamente.");
            } else {
                $redireccionar = $post_array['redireccion'];
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de compra", 'texto_alerta' => "La anulación se procesó correctamente.");
                $this->session->set_flashdata($alerta);
                redirect($redireccionar);
            }
        }

        $data['iframe'] = $iframe;
        $orden_compra = $this->compras_model->get_ordenes_compra(array('orc_id' => $registro));
        $data['orden_compra'] = $orden_compra[0];

        $where = array(
            'dor_id_orc' => $registro
        );
        $data['solicitante'] = $this->inventario_model->informacion_empleado($orden_compra[0]['orc_id_usu_solicita']);
        $data['detalle_orden'] = $this->compras_model->get_detalle_orden_compra($where);

        $paso_actual = $this->compras_model->get_paso_actual($registro, $tipo_flujo);
        $data['paso_actual'] = $paso_actual[0];
        $data['tipo_flujo'] = $tipo_flujo;

        if ($iframe) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/anular_orden_compra', $data, true);
        } else {
            $this->_cargarvista($data);
        }
    }

    /*
     * @dpv_id = Id del Documento por Proveedor
     */
    public function retaceos($dpv_id) {
        satelite_validar();

        $data['documento']       = $dpv_id;
        $data['retaceos']        = $this->compras_model->get_retaceos(array('rtd_id_dpv' => $dpv_id));
        $data['titulo_personal'] = "Listado Retaceos";
        $this->_cargarvista($data);
    }

    public function agregar_retaceo($dpv_id = null) {        
        satelite_validar();        
        if ($this->input->post()) {
            if($dpv_id){//Cuando es un retaceo individual        
                $post_array         = $this->input->post();
                $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
                $tipo_btn           = $post_array['btnCrear'];
                $txtNumRetaceo      = $post_array['txtNumRetaceo'];
                $txtPoliza          = $post_array['txtPoliza'];
                $txtAduana          = $post_array['txtAduana'];
                $txTObservaciones   = $post_array['txTObservaciones'];
                $hdnAfectaInv       = $post_array['hdnAfectaInv'];
                $txtTotalProdcutos  = $post_array['txtTotalProdcutos'];
                $txtTotalRetaceoPorc= $post_array['txtTotalRetaceoPorc'];
                $txtTotalRetaceo    = $post_array['txtTotalRetaceo'];
                $txtTotalGastos     = $post_array['txtTotalGastos'];
                $txtFechaRegistro   = $post_array['txtFechaRegistro'];
                $txtFechaRegistro   = str_replace("am", "", $txtFechaRegistro);
                $txtFechaRegistro   = str_replace("pm", "", $txtFechaRegistro);
                $txtFechaRegistro   = formatear_fecha('Y-m-d', $txtFechaRegistro);
                $txtFechaRegistro .= ' ' . date('H:i:s');
                $aplico_peso        = $post_array['hdnAplicarPeso'];
                //Anexos
                $TitulosAnexo       = $post_array['titulo_doc'];
                $NombreAnexo        = $post_array['ruta'];
                $retaceo_array = array(
                    'rtd_id_dpv'            => $dpv_id,
                    'rtd_numero'            => $txtNumRetaceo,
                    'rtd_poliza'            => $txtPoliza,
                    'rtd_aduana'            => $txtAduana,
                    'rtd_observacion'       => $txTObservaciones,
                    'rtd_afecta_inventario' => $hdnAfectaInv,
                    'rtd_subtotal'          => convertirFloat($txtTotalProdcutos),
                    'rtd_retaceo_porcentaje'=> convertirFloat($txtTotalRetaceoPorc),
                    'rtd_retaceo'           => convertirFloat($txtTotalRetaceo),
                    'rtd_total_gasto'       => convertirFloat($txtTotalGastos),
                    'rtd_fecha_registro'    => date('Y-m-d H:i:s', strtotime($txtFechaRegistro)),
                    'rtd_aplico_peso'       => $aplico_peso,
                    'rtd_estado'            => 1,
                    'rtd_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rtd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'rtd_fecha_creacion'    => date('Y-m-d h:i:s'),
                    'rtd_fecha_modificacion'=> date('Y-m-d h:i:s')
                );
                $rtd_id = $this->gsatelite->ingresar('rtd_retaceo_documento_proveedor', $retaceo_array);
                //Registrar retaceo en la tabla de rdv_retaceo_documento_proveedor
                $retaceo_rdv_array = array(
                    'rdv_id_rtd'        => $rtd_id,
                    'rdv_id_dpv'        => $dpv_id,
                    'rdv_observacion'   => $txTObservaciones,
                    'rdv_afecta_inventario' => $hdnAfectaInv,
                    'rdv_subtotal' => convertirFloat($txtTotalProdcutos),
                    'rdv_retaceo_porcentaje' => convertirFloat($txtTotalRetaceoPorc),
                    'rdv_retaceo' => convertirFloat($txtTotalRetaceo),
                    'rdv_total_gasto' =>convertirFloat($txtTotalGastos),
                    'rdv_fecha_registro' =>date('Y-m-d H:i:s', strtotime($txtFechaRegistro)),
                    'rdv_estado' => 1,
                    'rdv_usu_creacion' =>$this->tank_auth->get_user_id(),
                    'rdv_usu_modificacion' =>$this->tank_auth->get_user_id(),
                    'rdv_fecha_creacion' =>date('Y-m-d h:i:s'),
                    'rdv_fecha_modificacion' =>date('Y-m-d h:i:s')
                );
                $rdv_id = $this->gsatelite->ingresar('rdv_retaceo_documento_proveedor', $retaceo_rdv_array);
                if ($rtd_id > 0) {
                    $hdnDetalle         = $post_array['hdnDetalle'];
                    $hdnArticulo        = $post_array['hdnArticulo'];
                    $hdnConversion      = $post_array['hdnConversion'];
                    $hdnSector          = $post_array['hdnSector'];
                    $cantidades         = $post_array['cantidades'];
                    $precios            = $post_array['precios'];
                    $subtotales         = $post_array['subtotales'];
                    $porcRetaceo        = $post_array['porcRetaceo'];
                    $precios_finales    = $post_array['preciosfinal'];
                    $retaceo            = $post_array['retaceo'];
                    $gastos             = $post_array['gastos'];
                    $proveedores        = $post_array['proveedores'];
                    $documentos         = $post_array['documentos'];
                    $OtroNodocumentos   = $post_array['OtroNodocumentos'];
                    $montos             = $post_array['montos'];
                    $detalle_cantidad   = $post_array['txt_cantidadproductos'];
                    $detalle_productos  = $post_array['txt_productos'];
                    $detalle_documento  = $post_array['txt_detalles_docs'];
                    if (count($cantidades) > 0) {
                        //Se agrega el detalle del retaceo
                        for ($i = 0; $i < count($cantidades); $i++) {
                            $detalle_array = array(
                                'drc_id_art'            => $hdnArticulo[$i],
                                'drc_id_cva'            => ($hdnConversion[$i] != '') ? $hdnConversion[$i] : null,
                                'drc_id_rtd'            => $rtd_id,
                                'drc_id_dxd'            => $hdnDetalle[$i],
                                'drc_cantidad'          => convertirFloat($cantidades[$i]),
                                'drc_precio_unitario'   => convertirFloat($precios[$i]),
                                'drc_precio_final'      => convertirFloat($precios_finales[$i]),
                                'drc_subtotal'          => convertirFloat($subtotales[$i]),
                                'drc_retaceo_porcentaje'=> convertirFloat($porcRetaceo[$i]),
                                'drc_retaceo'           => convertirFloat($retaceo[$i]),
                                'drc_retaceo_peso'       => (isset($post_array['peso'][$i]))?convertirFloat($post_array['peso'][$i]):0.00,
                                'drc_incrementeo_precio' => ($post_array['txtIncrementoX'][$i] != '')?convertirFloat($post_array['txtIncrementoX'][$i]):0,
                                'drc_retaceo_calculo'    => ($post_array['txtRetaceoX'][$i] != '')?convertirFloat($post_array['txtRetaceoX'][$i]):0,
                                'drc_estado'            => 1,
                                'drc_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'drc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'drc_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'drc_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );
                            $drc_id = $this->gsatelite->ingresar('drc_detalle_retaceo', $detalle_array);
                            if ($drc_id > 0) {
                                //Se procesan los detalles del prorrateo
                                if (count($post_array['hdnCec_' . $hdnArticulo[$i]]) > 0) {
                                    $id_pxd         = $post_array['hdnCec_' . $hdnArticulo[$i]];
                                    $id_prorrateo   = $post_array['hdnPtr_' . $hdnArticulo[$i]];
                                    $porcentajes    = $post_array['porcentajesPxd_' . $hdnArticulo[$i]];
                                    $totales        = $post_array['totalPxd_' . $hdnArticulo[$i]];
                                    for ($j = 0; $j < count($post_array['hdnCec_' . $hdnArticulo[$i]]); $j++) {
                                        if ($id_pxd[$j] != '') {
                                            $detalle_pro_array = array(
                                                'dar_id_ptg'             => ($id_prorrateo[$j]>0)? $id_prorrateo[$j]:null,
                                                'dar_id_drc'             => $drc_id,
                                                'dar_id_pxd'             => $id_pxd[$j],
                                                'dar_porcentaje'         => convertirFloat($porcentajes[$j]),
                                                'dar_total'              => convertirFloat($totales[$j]),
                                                'dar_estado'             => 1,
                                                'dar_usu_creacion'       => $this->tank_auth->get_user_id(),
                                                'dar_fecha_creacion'     => date('Y-m-d H:i:s'),
                                                'dar_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                                'dar_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );
                                            $this->gsatelite->ingresar('dar_detalle_aplicacion_retaceo', $detalle_pro_array);
                                        }
                                    }
                                }
                            }
                        }
                        //Se agrega el detalle de gastos
                        for ($i = 0; $i < count($gastos); $i++) {
                            $gastos_array = array(
                                'grc_id_dpv'            => ($documentos[$i] != '') ? $documentos[$i] : null,
                                'grc_id_gst'            => $gastos[$i],
                                'grc_id_rtd'            => $rtd_id,
                                'grc_otro_documento'    => $OtroNodocumentos[$i],
                                'grc_monto'             => convertirFloat($montos[$i]),
                                'grc_estado'            => 1,
                                'grc_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'grc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'grc_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'grc_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );
                            $grc_id = $this->gsatelite->ingresar('grc_gasto_retaceo', $gastos_array);
                            $doc_array          = explode(",", $detalle_documento[$i]);
                            $porcentaje_detalle = 100/$detalle_cantidad[$i];
                            $new_monto          = convertirFloat($montos[$i]) / $detalle_cantidad[$i];
                            foreach ($doc_array as $doc) {
                                $detalle_gastos = array(
                                    'gxd_id_grc'            => $grc_id,
                                    'gxd_id_dxd'            => $doc,
                                    'gxd_monto'             => $new_monto,
                                    'gxd_porcentaje'        => $porcentaje_detalle,
                                    'gxd_estado'            => 1,
                                    'gxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'gxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'gxd_fecha_creacion'    => date('Y-m-d h:i:s'),
                                    'gxd_fecha_modificacion'=> date('Y-m-d h:i:s')
                                );
                                $this->gsatelite->ingresar('gxd_gastoxdetalle_documento', $detalle_gastos);
                            };
                        }
                    }
                    //Anexos
                    if (count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {
                            $extension            = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                            $nombreArchivo        = trim($TitulosAnexo[$i]) . "." . trim($extension);
                            $carpeta_destino_anx  = "uploads/anx_retaceo/" . $nombreArchivo;
                            $documentos_array = array(
                                'anr_id_rtd'            => $rtd_id,
                                'anr_url'               => $carpeta_destino_anx,
                                'anr_nombre'            => $nombreArchivo,
                                'anr_estado'            => 1,
                                'anr_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'anr_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'anr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'anr_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );
                            $nxp_id = $this->gsatelite->ingresar('anr_anexo_retaceo', $documentos_array);
                            if ($nxp_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }
                    if ($hdnAfectaInv == 1) {
                        $tipoProcesos       = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
                        $tipoProcesos_array = json_decode($tipoProcesos, true);
                        $this->db->order_by('dxd_id_bod');
                        $this->db->group_by('dxd_id_bod');
                        $detalle_query     = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod !=' => ''));
                        $movimientos_array = array();
                        $idProveedor       = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_prv', array('dpv_id' => $dpv_id));
                        //Se crean todos los movimientos
                        foreach ($detalle_query as $dxd) {
                            $movimientos_array[]['movimientos'] = array(
                                'moi_id_prv'            => $idProveedor,
                                'moi_id_tip'            => $tipoProcesos_array['RETACEO'],
                                'moi_id_bod'            => $dxd['dxd_id_bod'],
                                'moi_id_dpv'            => $dpv_id,//$rtd_id,
                                'moi_id_rtd'            => $rtd_id,
                                'moi_documento'         => $txtNumRetaceo,
                                'moi_descripcion'       => $txTObservaciones . '-- Proviniente de Retaceo',
                                'moi_fecha_mov'         => formatear_fecha('Y-m-d H:i:s', $txtFechaRegistro),// date('Y-m-d H:i:s'),
                                'moi_estado'            => 1,
                                'moi_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'moi_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'moi_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'moi_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );
                        }
                        //Se crean los detalles del movimiento
                        for ($i = 0; $i < count($movimientos_array); $i++) {
                            $bod_id       = $movimientos_array[$i]['movimientos']['moi_id_bod'];
                            $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'art_tipo' => 0, 'dxd_id_bod' => $bod_id));
                            if (count($detalles_doc) > 0) {
                                foreach ($detalles_doc as $key => $det) {
                                    if ($costo_promedio == 1) {
                                        $nuevo_precio =  $this->recalcular_precio_promedio($det['dxd_id_art'], $bod_id, convertirFloat($cantidades[$key]), convertirFloat($precios_finales[$key]) );
                                    }                                                                           
                                    $movimientos_array[$i]['detalles'][$key]['sar_saldo'] = array(
                                        'sar_id_art'            => $det['dxd_id_art'],
                                        'sar_id_bod'            => $bod_id,
                                        'sar_cant_actual'       => convertirFloat($cantidades[$key]),
                                        'sar_precio'            => ($costo_promedio == 1) ? $nuevo_precio : convertirFloat($precios_finales[$key]),
                                        'sar_fecha_caducidad'   => null,
                                        'sar_id_sxb'            => $det['dxd_id_sxb'],
                                        'sar_estado'            => 1,
                                        'sar_usu_creacion'      => $this->tank_auth->get_user_id(),
                                        'sar_fecha_creacion'    => date('Y-m-d H:i:s'),
                                        'sar_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'sar_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $movimientos_array[$i]['detalles'][$key]['dee_movimiento'] = array(
                                        'dee_id_moi'            => null,
                                        'dee_id_art'            => $det['dxd_id_art'],
                                        'dee_id_sar'            => null,
                                        'dee_id_cva'            => $det['dxd_id_cva'],
                                        'dee_id_sxb'            => $det['dxd_id_sxb'],
                                        'dee_cantidad'          => convertirFloat($cantidades[$key]),
                                        'dee_precio'            => convertirFloat($precios_finales[$key]),
                                        'dee_subtotal'          => convertirFloat($cantidades[$key]) * convertirFloat($precios_finales[$key]),
                                        'dee_estado'            => 1,
                                        'dee_usu_creacion'      => $this->tank_auth->get_user_id(),
                                        'dee_fecha_creacion'    => date('Y-m-d H:i:s'),
                                        'dee_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'dee_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                }
                            }
                        }
                        $this->ingresar_entrada($movimientos_array);
                    }
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1 && $hdnAfectaInv == 0) {
                    redirect('modulo_compras/procesos/editar_retaceo/' . $rtd_id);
                } else if ($tipo_btn == 1 && $hdnAfectaInv == 1) {
                    redirect('modulo_compras/procesos/editar_retaceo/' . $rtd_id . '/2');
                } else {
                    redirect('modulo_compras/procesos/retaceos/' . $dpv_id);
                }
            }else{//Si es un retaceo consolidado tomado desde el proceso de retaceo consolidado
                $post_array         = $this->input->post();
                //var_dump($post_array);die();
                $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
                $tipo_btn           = $post_array['btnCrear'];
                $txtNumRetaceo      = $post_array['txtNumRetaceo'];
                $txtPoliza          = $post_array['txtPoliza'];
                $txtAduana          = $post_array['txtAduana'];
                $txTObservaciones   = $post_array['txTObservaciones'];
                $hdnAfectaInv       = $post_array['hdnAfectaInv'];
                $txtTotalProdcutos  = $post_array['txtTotalProdcutos'];
                $txtTotalRetaceoPorc= $post_array['txtTotalRetaceoPorc'];
                $txtTotalRetaceo    = $post_array['txtTotalRetaceo'];
                $txtTotalGastos     = $post_array['txtTotalGastos'];
                $txtFechaRegistro   = $post_array['txtFechaRegistro'];
                $txtFechaRegistro   = str_replace("am", "", $txtFechaRegistro);
                $txtFechaRegistro   = str_replace("pm", "", $txtFechaRegistro);
                $txtFechaRegistro   = formatear_fecha('Y-m-d', $txtFechaRegistro);
                $txtFechaRegistro .= ' ' . date('H:i:s');
                //IDs de los dpvs
                $arrayIdsDpv   = $post_array['iddpv']; 
                $txtFechaRegistro   = str_replace("am", "", $txtFechaRegistro);
                $txtFechaRegistro   = str_replace("pm", "", $txtFechaRegistro);
                //Anexos
                $TitulosAnexo       = $post_array['titulo_doc'];
                $NombreAnexo        = $post_array['ruta'];
                $aplico_peso        = $post_array['hdnAplicarPeso'];
                $retaceo_array = array(
                    'rtd_id_dpv'            => $dpv_id,
                    'rtd_numero'            => $txtNumRetaceo,
                    'rtd_poliza'            => $txtPoliza,
                    'rtd_aduana'            => $txtAduana,
                    'rtd_observacion'       => $txTObservaciones,
                    'rtd_afecta_inventario' => $hdnAfectaInv,
                    'rtd_subtotal'          => convertirFloat($txtTotalProdcutos),
                    'rtd_retaceo_porcentaje'=> convertirFloat($txtTotalRetaceoPorc),
                    'rtd_retaceo'           => convertirFloat($txtTotalRetaceo),
                    'rtd_total_gasto'       => convertirFloat($txtTotalGastos),
                    'rtd_fecha_registro'    => date('Y-m-d H:i:s', strtotime($txtFechaRegistro)),
                    'rtd_aplico_peso'       => 1,//$aplico_peso,
                    'rtd_estado'            => 1,
                    'rtd_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rtd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'rtd_fecha_creacion'    => date('Y-m-d h:i:s'),
                    'rtd_fecha_modificacion'=> date('Y-m-d h:i:s')
                );
                $rtd_id = $this->gsatelite->ingresar('rtd_retaceo_documento_proveedor', $retaceo_array);
                //Registrar retaceo en la tabla de rdv_retaceo_documento_proveedor
                foreach ($arrayIdsDpv as $key => $id_documento_prov) {                                    
                    $retaceo_rdv_array = array(
                        'rdv_id_rtd'        => $rtd_id,
                        'rdv_id_dpv'        => $id_documento_prov,
                        'rdv_observacion'   => $txTObservaciones,
                        'rdv_afecta_inventario' => $hdnAfectaInv,
                        'rdv_subtotal' => convertirFloat($txtTotalProdcutos),
                        'rdv_retaceo_porcentaje' => convertirFloat($txtTotalRetaceoPorc),
                        'rdv_retaceo' => convertirFloat($txtTotalRetaceo),
                        'rdv_total_gasto' =>convertirFloat($txtTotalGastos),
                        'rdv_fecha_registro' =>date('Y-m-d H:i:s', strtotime($txtFechaRegistro)),
                        'rdv_estado' => 1,
                        'rdv_usu_creacion' =>$this->tank_auth->get_user_id(),
                        'rdv_usu_modificacion' =>$this->tank_auth->get_user_id(),
                        'rdv_fecha_creacion' =>date('Y-m-d h:i:s'),
                        'rdv_fecha_modificacion' =>date('Y-m-d h:i:s')
                    );
                    $rdv_id = $this->gsatelite->ingresar('rdv_retaceo_documento_proveedor', $retaceo_rdv_array);
                }

                if ($rtd_id > 0) {
                    $hdnDetalle         = $post_array['hdnDetalle'];
                    $hdnArticulo        = $post_array['hdnArticulo'];
                    $hdnConversion      = $post_array['hdnConversion'];
                    $hdnSector          = $post_array['hdnSector'];
                    $cantidades         = $post_array['cantidades'];
                    $precios            = $post_array['precios'];
                    $subtotales         = $post_array['subtotales'];
                    $porcRetaceo        = $post_array['porcRetaceo'];
                    $precios_finales    = $post_array['preciosfinal'];
                    $retaceo            = $post_array['retaceo'];

                    $gastos             = $post_array['gastos'];
                    $proveedores        = $post_array['proveedores'];
                    $documentos         = $post_array['documentos'];
                    $OtroNodocumentos   = $post_array['OtroNodocumentos'];
                    $hdnAplicar_gasto_peso   = $post_array['hdnAplicar_gasto_peso'];
                    $montos             = $post_array['montos'];
                    $detalle_cantidad   = $post_array['txt_cantidadproductos'];
                    $detalle_productos  = $post_array['txt_productos'];
                    $detalle_documento  = $post_array['txt_detalles_docs'];

                    if (count($cantidades) > 0) {
                        //Se agrega el detalle del retaceo
                        for ($i = 0; $i < count($cantidades); $i++) {
                            $detalle_array = array(
                                'drc_id_art'            => $hdnArticulo[$i],
                                'drc_id_cva'            => ($hdnConversion[$i] != '') ? $hdnConversion[$i] : null,
                                'drc_id_rtd'            => $rtd_id,
                                'drc_id_dxd'            => $hdnDetalle[$i],
                                'drc_cantidad'          => convertirFloat($cantidades[$i]),
                                'drc_precio_unitario'   => convertirFloat($precios[$i]),
                                'drc_precio_final'      => convertirFloat($precios_finales[$i]),
                                'drc_subtotal'          => convertirFloat($subtotales[$i]),
                                'drc_retaceo_porcentaje'=> convertirFloat($porcRetaceo[$i]),
                                'drc_retaceo'           => convertirFloat($retaceo[$i]),
                                'drc_retaceo_peso'       => (isset($post_array['peso'][$i]))?convertirFloat($post_array['peso'][$i]):0.00,
                                'drc_porcentaje_peso'       => (isset($post_array['txtPesoX'][$i]))?convertirFloat($post_array['txtPesoX'][$i]):0.00,
                                'drc_incrementeo_precio' => ($post_array['txtIncrementoX'][$i] != '')?convertirFloat($post_array['txtIncrementoX'][$i]):0,
                                'drc_retaceo_calculo'    => ($post_array['txtRetaceoX'][$i] != '')?convertirFloat($post_array['txtRetaceoX'][$i]):0,
                                'drc_estado'            => 1,
                                'drc_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'drc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'drc_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'drc_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );
                            $drc_id = $this->gsatelite->ingresar('drc_detalle_retaceo', $detalle_array);
                            if ($drc_id > 0) {
                                //Se procesan los detalles del prorrateo
                                if (count($post_array['hdnCec_' . $hdnArticulo[$i]]) > 0) {

                                    $id_pxd         = $post_array['hdnCec_' . $hdnArticulo[$i]];
                                    $id_prorrateo   = $post_array['hdnPtr_' . $hdnArticulo[$i]];
                                    $porcentajes    = $post_array['porcentajesPxd_' . $hdnArticulo[$i]];
                                    $totales        = $post_array['totalPxd_' . $hdnArticulo[$i]];

                                    for ($j = 0; $j < count($post_array['hdnCec_' . $hdnArticulo[$i]]); $j++) {
                                        if ($id_pxd[$j] != '') {
                                            $detalle_pro_array = array(
                                                'dar_id_ptg'             => ($id_prorrateo[$j] == '') ? null: $id_prorrateo[$j],
                                                'dar_id_drc'             => $drc_id,
                                                'dar_id_pxd'             => $id_pxd[$j],
                                                'dar_porcentaje'         => convertirFloat($porcentajes[$j]),
                                                'dar_total'              => convertirFloat($totales[$j]),
                                                'dar_estado'             => 1,
                                                'dar_usu_creacion'       => $this->tank_auth->get_user_id(),
                                                'dar_fecha_creacion'     => date('Y-m-d H:i:s'),
                                                'dar_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                                'dar_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );
                                            $this->gsatelite->ingresar('dar_detalle_aplicacion_retaceo', $detalle_pro_array);
                                        }
                                    }
                                }
                            }
                        }

                        //Se agrega el detalle de gastos
                        for ($i = 0; $i < count($gastos); $i++) {
                            $gastos_array = array(
                                //'grc_id_dpv'            => ($documentos[$i] != '') ? $documentos[$i] : null,
                                'grc_id_dpv'            => null,
                                'grc_id_gst'            => $gastos[$i],
                                'grc_id_rtd'            => $rtd_id,
                                'grc_otro_documento'    => $OtroNodocumentos[$i],
                                'grc_monto'             => convertirFloat($montos[$i]),
                                'grc_tipo_retaceo'      => $hdnAplicar_gasto_peso[$i],
                                'grc_estado'            => 1,
                                'grc_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'grc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'grc_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'grc_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );

                            $grc_id = $this->gsatelite->ingresar('grc_gasto_retaceo', $gastos_array);

                            $doc_array          = explode(",", $detalle_documento[$i]);
                            $porcentaje_detalle = 100/$detalle_cantidad[$i];
                            $new_monto          = convertirFloat($montos[$i]) / $detalle_cantidad[$i];

                            foreach ($doc_array as $doc) {
                                $detalle_gastos = array(
                                    'gxd_id_grc'            => $grc_id,
                                    'gxd_id_dxd'            => $doc,
                                    'gxd_monto'             => $new_monto,
                                    'gxd_porcentaje'        => $porcentaje_detalle,
                                    'gxd_estado'            => 1,
                                    'gxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'gxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'gxd_fecha_creacion'    => date('Y-m-d h:i:s'),
                                    'gxd_fecha_modificacion'=> date('Y-m-d h:i:s')
                                );
                                $this->gsatelite->ingresar('gxd_gastoxdetalle_documento', $detalle_gastos);
                            };
                        }
                    }

                    //Anexos
                    if (count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {

                            $extension            = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                            $nombreArchivo        = trim($TitulosAnexo[$i]) . "." . trim($extension);
                            $carpeta_destino_anx  = "uploads/anx_retaceo/" . $nombreArchivo;

                            $documentos_array = array(
                                'anr_id_rtd'            => $rtd_id,
                                'anr_url'               => $carpeta_destino_anx,
                                'anr_nombre'            => $nombreArchivo,
                                'anr_estado'            => 1,
                                'anr_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'anr_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'anr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'anr_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );

                            $nxp_id = $this->gsatelite->ingresar('anr_anexo_retaceo', $documentos_array);

                            if ($nxp_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }

                    if ($hdnAfectaInv == 1) {
                        $tipoProcesos       = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
                        $tipoProcesos_array = json_decode($tipoProcesos, true);
                        //print_r($tipoProcesos_array ); die();
                        if ($tipoProcesos_array['RETACEO'] != '') {
                            $m = 0;
                            foreach ($arrayIdsDpv as $key => $value) {
                                //Preguntamos si el DPV ya afecto inventario
                                $ya_afecto = $this->gsatelite->get_tabla('moi_movimiento_inv',array('moi_id_dpv' => $value));
                                if(count($ya_afecto) == 0) {
                                    $movimientos_array = array();
                                                     $this->db->order_by('dxd_id_bod');
                                                     $this->db->group_by('dxd_id_bod');
                                    $detalle_query = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $value, 'dxd_id_bod !=' => ''));
                                    $idProveedor = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_prv', array('dpv_id' => $value));                            
                                    //Se crean todos los movimientos
                                    foreach ($detalle_query as $dxd) {
                                        $movimientos_array[]['movimientos'] = array(
                                            'moi_id_prv'            => $idProveedor,
                                            'moi_id_tip'            => $tipoProcesos_array['RETACEO'],
                                            'moi_id_bod'            => $dxd['dxd_id_bod'],
                                            'moi_id_rtd'            => $rtd_id,
                                            'moi_id_dpv'            => $value,
                                            'moi_documento'         => $txtNumRetaceo,
                                            'moi_descripcion'       => $txTObservaciones . '-- Proviniente de Retaceo',
                                            'moi_fecha_mov'         => formatear_fecha('Y-m-d H:i:s', $txtFechaRegistro),
                                            'moi_estado'            => 1,
                                            'moi_usu_creacion'      => $this->tank_auth->get_user_id(),
                                            'moi_fecha_creacion'    => date('Y-m-d H:i:s'),
                                            'moi_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                            'moi_fecha_modificacion'=> date('Y-m-d H:i:s')
                                        );
                                    }
                                    //Se crean los detalles del movimiento
                                    for ($i = 0; $i < count($movimientos_array); $i++) {
                                        $bod_id       = $movimientos_array[$i]['movimientos']['moi_id_bod'];
                                        $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('art_tipo' => 0, 'dxd_id_dpv' => $value, 'dxd_id_bod' => $bod_id));
                                        if (count($detalles_doc) > 0) {
                                            foreach ($detalles_doc as $key => $det) {
                                                if ($costo_promedio == 1) {
                                                    $nuevo_precio = $this->recalcular_precio_promedio($det['dxd_id_art'], $bod_id, convertirFloat($cantidades[$m]), convertirFloat($precios_finales[$m]));
                                                }
                                                $movimientos_array[$i]['detalles'][$key]['sar_saldo'] = array(
                                                    'sar_id_art'            => $det['dxd_id_art'],
                                                    'sar_id_bod'            => $bod_id,
                                                    'sar_cant_actual'       => convertirFloat($cantidades[$m]),
                                                    'sar_precio'            => ($costo_promedio == 1) ? $nuevo_precio : convertirFloat($precios_finales[$m]),
                                                    'sar_fecha_caducidad'   => null,
                                                    'sar_id_sxb'            => $det['dxd_id_sxb'],
                                                    'sar_estado'            => 1,
                                                    'sar_usu_creacion'      => $this->tank_auth->get_user_id(),
                                                    'sar_fecha_creacion'    => date('Y-m-d H:i:s'),
                                                    'sar_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                                    'sar_fecha_modificacion'=> date('Y-m-d H:i:s')
                                                );
                                                $movimientos_array[$i]['detalles'][$key]['dee_movimiento'] = array(
                                                    'dee_id_moi'            => null,
                                                    'dee_id_art'            => $det['dxd_id_art'],
                                                    'dee_id_sar'            => null,
                                                    'dee_id_cva'            => $det['dxd_id_cva'],
                                                    'dee_id_sxb'            => $det['dxd_id_sxb'],
                                                    'dee_cantidad'          => convertirFloat($cantidades[$m]),
                                                    'dee_precio'            => convertirFloat($precios_finales[$m]),
                                                    'dee_subtotal'          => convertirFloat($cantidades[$m]) * convertirFloat($precios_finales[$m]),
                                                    'dee_estado'            => 1,
                                                    'dee_usu_creacion'      => $this->tank_auth->get_user_id(),
                                                    'dee_fecha_creacion'    => date('Y-m-d H:i:s'),
                                                    'dee_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                                    'dee_fecha_modificacion'=> date('Y-m-d H:i:s')
                                                );
                                                $m++;
                                            }
                                        }
                                        $this->ingresar_entrada($movimientos_array);
                                    }
                                }
                            }
                        }
                    }
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1 && $hdnAfectaInv == 0) {
                    redirect('modulo_compras/procesos/agregar_retaceo/'/* . $rtd_id*/);
                } else if ($tipo_btn == 1 && $hdnAfectaInv == 1) {
                    redirect('modulo_compras/procesos/agregar_retaceo/'/* . $rtd_id . '/2'*/);
                } else {
                    redirect('modulo_compras/procesos/retaceos_consolidados');
                }
            }//Fin del retaceo consolidado
        }//Fin post

        if($dpv_id){//Cuando es un retaceo individual        
            $documento          = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
            $data['documento']  = $documento[0];
            $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'art_tipo'=>0));
            $data['gastos']     = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));

            $proveedores = $this->compras_model->get_proveedor_pers();
            $options     = '<option value=""></option>';
            foreach ($proveedores as $key) {
                if ($key['pro'] != '') {
                    $options .= '<option value="' . $key['prv_id'] . '">' . $key['pro'] . '</option>';
                }
            }

            $data['proveedores']    = $options;
            $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            // $data['codigo']         = ($this->gsatelite->get_max('grc_gasto_retaceo','grc_id'))+1;
            $parametro = json_decode($this->gsatelite->get_parametro_emp('SYS_CODIGO_RETACEO'), true);
            $peso_porc = 0;
            if (is_array($parametro)) {
                switch ($parametro['PERIODICIDAD']) {
                    case 'Y':
                        $search= date('Y');
                        $wnum = array("DATE_FORMAT(rtd_fecha_registro, '%Y') = $search" => null);
                        break;
                    case 'M':
                        $search= date('n');
                        $wnum = array("DATE_FORMAT(rtd_fecha_registro, '%c') = $search" => null);
                        break;                    
                    default:
                        $wnum = null;
                        break;
                }
                $pad = ($parametro['LONG_CORRELATIVO'] > 0) ? $parametro['LONG_CORRELATIVO'] : 3;
                $num_codigo = ($this->gsatelite->count("rtd_retaceo_documento_proveedor", $wnum)) + 1;
                $padNumero = str_pad($num_codigo, $pad, '0', STR_PAD_LEFT);
                $sufijo = ""; 
                $parsuf = explode("##", $parametro['SUFIJO']);
                foreach ($parsuf as $k => $v) {
                    if ( strpos($v,"{") === false && strpos($v,"|") === false) {
                        $sufijo .= $v; 
                    } else {
                        $evnt = explode("||", $v);
                        $dato = str_replace(array("{","}"), "", $evnt[0]);
                        switch ($dato) {
                            case '1':
                                $sufijo .= str_replace(array("{","}","'"), "", date($evnt[1]));
                                break;
                            default:
                                $sufijo .= "";
                                break;
                        }
                    }
                }
                $retcod = $parametro["PREFIJO"] . $padNumero . $sufijo;
                if (isset($parametro["PESO_PORC"]) && is_numeric($parametro["PESO_PORC"])) {
                    $peso_porc = $parametro["PESO_PORC"];
                }
            } else {
                $num_codigo = ($this->gsatelite->get_max('grc_gasto_retaceo','grc_id')) + 1;
                $retcod = "RET-" . $num_codigo;
            }            
            $data['codigo'] = $retcod;
            $data['titulo_personal']= "Agregar Retaceo";
            $this->_cargarvista($data);
        }else{//Si es un retaceo consolidado tomado desde el proceso de retaceo consolidado
            $documento          = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
            $data['documento']  = count($documento) > 0 ? $documento[0]: array();
            $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'art_tipo'=>0));
            //print_r($this->db->last_query()); 
            //print_r($data['detalle_documento']);            
            $data['gastos']     = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));

            $proveedores = $this->compras_model->get_proveedor_pers();
            $options     = '<option value=""></option>';
            foreach ($proveedores as $key) {
                if ($key['pro'] != '') {
                    $options .= '<option value="' . $key['prv_id'] . '">' . $key['pro'] . '</option>';
                }
            }

            $data['proveedores']    = $options;
            $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $parametro = json_decode($this->gsatelite->get_parametro_emp('SYS_CODIGO_RETACEO'), true);
            $peso_porc = 0;
            if (is_array($parametro)) {
                switch ($parametro['PERIODICIDAD']) {
                    case 'Y':
                        $search= date('Y');
                        $wnum = array("DATE_FORMAT(rtd_fecha_registro, '%Y') = $search" => null);
                        break;
                    case 'M':
                        $search= date('n');
                        $wnum = array("DATE_FORMAT(rtd_fecha_registro, '%c') = $search" => null);
                        break;                    
                    default:
                        $wnum = null;
                        break;
                }
                $pad = ($parametro['LONG_CORRELATIVO'] > 0) ? $parametro['LONG_CORRELATIVO'] : 3;
                $num_codigo = ($this->gsatelite->count("rtd_retaceo_documento_proveedor", $wnum)) + 1;
                $padNumero = str_pad($num_codigo, $pad, '0', STR_PAD_LEFT);
                $sufijo = ""; 
                $parsuf = explode("##", $parametro['SUFIJO']);
                foreach ($parsuf as $k => $v) {
                    if ( strpos($v,"{") === false && strpos($v,"|") === false) {
                        $sufijo .= $v; 
                    } else {
                        $evnt = explode("||", $v);
                        $dato = str_replace(array("{","}"), "", $evnt[0]);
                        switch ($dato) {
                            case '1':
                                $sufijo .= str_replace(array("{","}","'"), "", date($evnt[1]));
                                break;
                            default:
                                $sufijo .= "";
                                break;
                        }
                    }
                }
                $retcod = $parametro["PREFIJO"] . $padNumero . $sufijo;
                if (isset($parametro["PESO_PORC"]) && is_numeric($parametro["PESO_PORC"])) {
                    $peso_porc = $parametro["PESO_PORC"];
                }
            } else {
                $num_codigo = ($this->gsatelite->get_max('grc_gasto_retaceo','grc_id')) + 1;
                $retcod = "RET-" . $num_codigo;
            }            
            $data['codigo'] = $retcod;
            $data['peso_porc'] = $peso_porc;
            $data['titulo_personal']= "Agregar Retaceo";
            
            //$this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/agregar_retaceo_consolidado', $data, false);
            cargarvista($data, false, 'modulo_compras/procesos/agregar_retaceo_consolidado');
            //$this->_cargarvista($data);
        }

    }

    /*
     * @ver_detalle: 1 = Ver en Iframe, 2 = Ver como pantalla normal, null = Editar la pantalla
     */

    public function editar_retaceo($rtd_id, $ver_detalle = null) {
        satelite_validar();
        if ($this->input->post()) {
            //print_r($this->input->post());die();

            $post_array         = $this->input->post();
            $costo_promedio     = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            $tipo_btn           = $post_array['btnCrear'];
            $dpv_id             = $this->gsatelite->get_campo('rtd_retaceo_documento_proveedor', 'rtd_id_dpv', array('rtd_id' => $rtd_id));
            $txtNumRetaceo      = $post_array['txtNumRetaceo'];
            $txtPoliza          = $post_array['txtPoliza'];
            $txtAduana          = $post_array['txtAduana'];
            $txTObservaciones   = $post_array['txTObservaciones'];
            $hdnAfectaInv       = $post_array['hdnAfectaInv'];
            $txtTotalProdcutos  = $post_array['txtTotalProdcutos'];
            $txtTotalRetaceoPorc= $post_array['txtTotalRetaceoPorc'];
            $txtTotalRetaceo    = $post_array['txtTotalRetaceo'];
            $txtTotalGastos     = $post_array['txtTotalGastos'];
            //$txtFechaRegistro = $post_array['txtFechaRegistro'];

            $retaceo_array = array(
                'rtd_numero'            => $txtNumRetaceo,
                'rtd_poliza'            => $txtPoliza,
                'rtd_aduana'            => $txtAduana,
                'rtd_observacion'       => $txTObservaciones,
                'rtd_afecta_inventario' => $hdnAfectaInv,
                'rtd_subtotal'          => convertirFloat($txtTotalProdcutos),
                'rtd_retaceo_porcentaje'=> convertirFloat($txtTotalRetaceoPorc),
                'rtd_retaceo'           => convertirFloat($txtTotalRetaceo),
                'rtd_total_gasto'       => convertirFloat($txtTotalGastos),
                'rtd_estado'            => 1,
                'rtd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'rtd_fecha_modificacion'=> date('Y-m-d h:i:s')
            );
            $resultado = $this->gsatelite->actualizar_array('rtd_retaceo_documento_proveedor', $retaceo_array, array('rtd_id' => $rtd_id));
            
            if ($resultado > 0) {

                $hdnDetalle         = $post_array['hdnDetalle'];
                $hdnArticulo        = $post_array['hdnArticulo'];
                $hdnConversion      = $post_array['hdnConversion'];
                //$hdnSector        = $post_array['hdnSector'];
                $cantidadesRtd      = $post_array['cantidadesRtd'];
                $preciosRtd         = $post_array['preciosRtd'];
                $preciosFinalRtd    = $post_array['preciosfinalRtd'];
                $subtotalesRtd      = $post_array['subtotalesRtd'];
                $porcRetaceoRtd     = $post_array['porcRetaceoRtd'];
                $retaceoRtd         = $post_array['retaceoRtd'];

                $cantidades         = (isset($post_array['cantidades'])) ? $post_array['cantidades'] : null;
                $precios            = (isset($post_array['precios'])) ? $post_array['precios'] : null;
                $subtotales         = (isset($post_array['subtotales'])) ? $post_array['subtotales'] : null;
                $precios_finales    = (isset($post_array['preciosfinal'])) ? $post_array['preciosfinal'] : null;
                $porcRetaceo        = (isset($post_array['porcRetaceo'])) ? $post_array['porcRetaceo'] : null;
                $retaceo            = (isset($post_array['retaceo'])) ? $post_array['retaceo'] : null;

                $hdnGasto           = $post_array['hdnGasto'];
                $gastos             = $post_array['gastos'];
                //$proveedores = $post_array['proveedores'];
                $documentos         = $post_array['documentos'];
                $otroNoDocumentos   = $post_array['OtroNodocumentos'];
                $montos             = $post_array['montos'];

                $detalle_cantidad   = $post_array['txt_cantidadproductos'];
                $detalle_productos  = $post_array['txt_productos'];
                $detalle_documento  = $post_array['txt_detalles_docs'];

                //Anexos
                $AnexoRtd       = $post_array['AnexoRtd'];
                $TitulosAnexo   = $post_array['titulo_doc'];
                $NombreAnexo    = $post_array['ruta'];

                //Se procesan los detalles ya ingresados
                $dataDetalleRetaceo = $this->compras_model->get_detalle_retaceo(array('drc_id_rtd' => $rtd_id));
                if (!is_array($hdnDetalle)) {
                    $hdnDetalle = array();
                }
                foreach ($dataDetalleRetaceo as $data) {
                    if (!in_array($data['drc_id'], $hdnDetalle)) {
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('drc_detalle_retaceo', array('drc_id' => $data['drc_id']));
                    }
                }

                if (count($hdnDetalle) > 0) {
                    //Se actualizan los detalles
                    for ($i = 0; $i < count($hdnDetalle); $i++) {
                        $detalle_act_array = array(
                            'drc_cantidad'          => convertirFloat($cantidadesRtd[$i]),
                            'drc_precio_unitario'   => convertirFloat($preciosRtd[$i]),
                            'drc_subtotal'          => convertirFloat($subtotalesRtd[$i]),
                            'drc_retaceo_porcentaje'=> convertirFloat($porcRetaceoRtd[$i]),
                            'drc_precio_final'      => convertirFloat($preciosFinalRtd[$i]),
                            'drc_retaceo'           => convertirFloat($retaceoRtd[$i]),
                            'drc_estado'            => 1,
                            'drc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'drc_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('drc_detalle_retaceo', $detalle_act_array, array('drc_id' => $hdnDetalle[$i]));

                        if (count($post_array['hdnCec_' . $hdnArticulo[$i]]) > 0) {

                            $hdnDar         = $post_array['hdnDar_' . $hdnArticulo[$i]];
                            $id_pxd         = $post_array['hdnCec_' . $hdnArticulo[$i]];
                            $id_prorrateo   = $post_array['hdnPtr_' . $hdnArticulo[$i]];
                            $porcentajes    = $post_array['porcentajesPxd_' . $hdnArticulo[$i]];
                            $totales        = $post_array['totalPxd_' . $hdnArticulo[$i]];

                            for ($j = 0; $j < count($post_array['hdnCec_' . $hdnArticulo[$i]]); $j++) {
                                if ($id_pxd[$j] != '') {
                                    $detalle_pro_array = array(
                                        'dar_id_ptg'            => $id_prorrateo[$j],
                                        'dar_id_drc'            => $hdnDetalle[$i],
                                        'dar_id_pxd'            => $id_pxd[$j],
                                        'dar_porcentaje'        => convertirFloat($porcentajes[$j]),
                                        'dar_total'             => convertirFloat($totales[$j]),
                                        'dar_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'dar_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->actualizar_array('dar_detalle_aplicacion_retaceo', $detalle_pro_array, array('dar_id' => $hdnDar[$j]));
                                }
                            }
                        }
                    }
                }

                //Se procesan los gastos ya ingresados
                $dataGastosRetaceo = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));
                if (!is_array($hdnGasto)) {
                    $hdnGasto = array();
                }

                foreach ($dataGastosRetaceo as $data) {
                    if (!in_array($data['grc_id'], $hdnGasto)) {
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('gxd_gastoxdetalle_documento', array('gxd_id_grc' => $data['grc_id']));
                        $this->gsatelite->borrado_general('grc_gasto_retaceo', array('grc_id' => $data['grc_id']));
                    }
                }

                if (count($cantidades) > 0) {
                    //Se agrega el detalle del retaceo
                    for ($i = 0; $i < count($cantidades); $i++) {
                        $detalle_array = array(
                            'drc_id_art'            => $hdnArticulo[$i],
                            'drc_id_cva'            => ($hdnConversion[$i] != '') ? $hdnConversion[$i] : null,
                            'drc_id_rtd'            => $rtd_id,
                            'drc_id_dxd'            => $hdnDetalle,
                            'drc_cantidad'          => convertirFloat($cantidades[$i]),
                            'drc_precio_unitario'   => convertirFloat($precios[$i]),
                            'drc_precio_final'      => convertirFloat($precios_finales[$i]),
                            'drc_subtotal'          => convertirFloat($subtotales[$i]),
                            'drc_retaceo_porcentaje'=> convertirFloat($porcRetaceo[$i]),
                            'drc_retaceo'           => convertirFloat($retaceo[$i]),
                            'drc_estado'            => 1,
                            'drc_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'drc_fecha_creacion'    => date('Y-m-d h:i:s'),
                            'drc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'drc_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );

                        $drc_id = $this->gsatelite->ingresar('drc_detalle_retaceo', $detalle_array);
                    }
                }

                if (count($gastos) > 0) {
                    //Se agrega el detalle de gastos
                    for ($i = 0; $i < count($gastos); $i++) {
                        $gastos_array = array(
                            'grc_id_dpv'            => (trim($documentos[$i]) != '') ? $documentos[$i] : null,
                            'grc_id_gst'            => $gastos[$i],
                            'grc_id_rtd'            => $rtd_id,
                            'grc_otro_documento'    => $otroNoDocumentos[$i],
                            'grc_monto'             => convertirFloat($montos[$i]),
                            'grc_estado'            => 1,
                            'grc_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'grc_fecha_creacion'    => date('Y-m-d h:i:s'),
                            'grc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'grc_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );
                        
                        $grc_id = $this->gsatelite->ingresar('grc_gasto_retaceo', $gastos_array);

                        $doc_array          = explode(",", $detalle_documento[$i]);
                        $porcentaje_detalle = 100/$detalle_cantidad[$i];
                        $new_monto          = convertirFloat($montos[$i]) / $detalle_cantidad[$i];

                        foreach ($doc_array as $doc) {
                            $detalle_gastos = array(
                                'gxd_id_grc'            => $grc_id,
                                'gxd_id_dxd'            => $doc,
                                'gxd_monto'             => $new_monto,
                                'gxd_porcentaje'        => $porcentaje_detalle,
                                'gxd_estado'            => 1,
                                'gxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'gxd_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'gxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'gxd_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );
                            $this->gsatelite->ingresar('gxd_gastoxdetalle_documento', $detalle_gastos);
                        };

                    }
                }

                //Se validan los anexos ya ingresados
                $dataAnexosRetaceo = $this->gsatelite->get_tabla('anr_anexo_retaceo', array('anr_id_rtd' => $rtd_id));
                if (!is_array($AnexoRtd)) {
                    $AnexoRtd = array();
                }

                foreach ($dataAnexosRetaceo as $data) {
                    if (!in_array($data['anr_id'], $AnexoRtd)) {
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('anr_anexo_retaceo', array('anr_id' => $data['anr_id']));
                    }
                }

                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {

                        $extension            = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo        = trim($TitulosAnexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anx_retaceo/" . $nombreArchivo;

                        $documentos_array = array(
                            'anr_id_rtd'            => $rtd_id,
                            'anr_url'               => $carpeta_destino_anx,
                            'anr_nombre'            => $nombreArchivo,
                            'anr_estado'            => 1,
                            'anr_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'anr_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'anr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'anr_fecha_modificacion'=> date('Y-m-d H:i:s'),
                        );

                        $nxp_id = $this->gsatelite->ingresar('anr_anexo_retaceo', $documentos_array);

                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }

                if ($hdnAfectaInv == 1) {
                    $tipoProcesos       = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
                    $tipoProcesos_array = json_decode($tipoProcesos, true);

                    $this->db->order_by('dxd_id_bod');
                    $this->db->group_by('dxd_id_bod');
                    $detalle_query = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod !=' => ''));
                    $movimientos_array = array();
                    $idProveedor = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_prv', array('dpv_id' => $dpv_id));
                    $retac_fecha = $this->gsatelite->get_campo('rtd_retaceo_documento_proveedor', 'rtd_fecha_registro', array('rtd_id' => $rtd_id));

                    //Se crean todos los movimientos
                    foreach ($detalle_query as $dxd) {
                        $movimientos_array[]['movimientos'] = array(
                            'moi_id_prv'            => $idProveedor,
                            'moi_id_tip'            => $tipoProcesos_array['RETACEO'],
                            'moi_id_bod'            => $dxd['dxd_id_bod'],
                            'moi_id_rtd'            => $rtd_id,
                            'moi_id_dpv'            => $dpv_id,
                            'moi_documento'         => $txtNumRetaceo,
                            'moi_descripcion'       => $txTObservaciones . '-- Proviniente de Retaceo',
                            'moi_fecha_mov'         => formatear_fecha('Y-m-d H:i:s', $retac_fecha),
                            'moi_estado'            => 1,
                            'moi_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'moi_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'moi_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'moi_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                    }
                    //Se crean los detalles del movimiento
                    for ($i = 0; $i < count($movimientos_array); $i++) {
                        $bod_id = $movimientos_array[$i]['movimientos']['moi_id_bod'];
                        $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'art_tipo'=> 0, 'dxd_id_bod' => $bod_id));
                        if (count($detalles_doc) > 0) {
                            foreach ($detalles_doc as $key => $det) {
                                if ($costo_promedio == 1) {
                                    $nuevo_precio =  $this->recalcular_precio_promedio($det['dxd_id_art'], $bod_id, convertirFloat($cantidadesRtd[$key]), convertirFloat($preciosFinalRtd[$key]));
                                }                                        

                                $movimientos_array[$i]['detalles'][$key]['sar_saldo'] = array(
                                    'sar_id_art'            => $det['dxd_id_art'],
                                    'sar_id_bod'            => $bod_id,
                                    'sar_cant_actual'       => convertirFloat($cantidadesRtd[$key]),
                                    'sar_precio'            => ($costo_promedio == 1) ? $nuevo_precio : convertirFloat($preciosFinalRtd[$key]),
                                    'sar_fecha_caducidad'   => null,
                                    'sar_id_sxb'            => $det['dxd_id_sxb'],
                                    'sar_estado'            => 1,
                                    'sar_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'sar_fecha_creacion'    => date('Y-m-d H:i:s'),
                                    'sar_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'sar_fecha_modificacion'=> date('Y-m-d H:i:s')
                                );

                                $movimientos_array[$i]['detalles'][$key]['dee_movimiento'] = array(
                                    'dee_id_moi'            => null,
                                    'dee_id_art'            => $det['dxd_id_art'],
                                    'dee_id_sar'            => null,
                                    'dee_id_cva'            => $det['dxd_id_cva'],
                                    'dee_id_sxb'            => $det['dxd_id_sxb'],
                                    'dee_cantidad'          => convertirFloat($cantidadesRtd[$key]),
                                    'dee_precio'            => convertirFloat($preciosFinalRtd[$key]),
                                    'dee_subtotal'          => convertirFloat($cantidadesRtd[$key]) * convertirFloat($preciosFinalRtds[$key]),
                                    'dee_estado'            => 1,
                                    'dee_usu_creacion'      => $this->tank_auth->get_user_id(),
                                    'dee_fecha_creacion'    => date('Y-m-d H:i:s'),
                                    'dee_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                    'dee_fecha_modificacion'=> date('Y-m-d H:i:s')
                                );
                            }
                        }
                    }
                    $this->ingresar_entrada($movimientos_array);
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1 && $hdnAfectaInv == 0) {
                redirect('modulo_compras/procesos/editar_retaceo/' . $rtd_id);
            } else if ($tipo_btn == 1 && $hdnAfectaInv == 1) {
                redirect('modulo_compras/procesos/editar_retaceo/' . $rtd_id . '/2');
            } else {

                $dpv_id = $this->gsatelite->get_campo('rtd_retaceo_documento_proveedor', 'rtd_id_dpv', array('rtd_id' => $rtd_id));
                redirect('modulo_compras/procesos/retaceos/' . $dpv_id);
            }
        }

        $retaceo    = $this->compras_model->get_retaceos(array('rtd_id' => $rtd_id));
        $documento  = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $retaceo[0]['rtd_id_dpv']));

        $data['retaceo']            = $retaceo[0];
        $data['ver_retaceo']        = $ver_detalle;
        $data['documento']          = $documento[0];
        $data['detalle_documento']  = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $retaceo[0]['rtd_id_dpv']));
        $data['detalle_retaceo']    = $this->compras_model->get_detalle_retaceo(array('drc_id_rtd' => $rtd_id));
        $data['detalle_gastos']     = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));

        $data['gastos']         = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));
        
        $data['proveedores']    = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['anexos_retaceo'] = $this->gsatelite->get_tabla('anr_anexo_retaceo', array('anr_id_rtd' => $rtd_id));

        if ($ver_detalle == 1) {
            $data['titulo_personal'] = "Ver Retaceo";
        } else {
            $data['titulo_personal'] = "Editar Retaceo";
        }

        $data['ver_detalle'] = $ver_detalle;

        if ($ver_detalle == 1) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/editar_retaceo', $data, true);
        } else {
            $this->_cargarvista($data);
        }
    }

    /*
     * @array_movimientos = array multidimensional
     * que contiene el array de movimiento y ul sub array con los detalles.
     */

    function ingresar_entrada($array_movimientos) {
        $idsMovimiento = array();
        //Se recorre el array para ingresar los movimientos
        foreach ($array_movimientos as $moi) {
            //Se asigna el array a ingresar
            $movimiento_array = $moi['movimientos'];

            //Se ingresa el movimiento
            $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $movimiento_array);

            //Si el movimiento se ingreso, se ingresan los detalles
            if ($moi_id > 0) {
                foreach ($moi['detalles'] as $det) {
                    $saldo_array = $det['sar_saldo'];
                    //Se ingresa el saldo nuevo
                    $sar_id = $this->gsatelite->ingresar('sar_saldo_articulo', $saldo_array);

                    if ($sar_id > 0) {
                        $detalle_array = $det['dee_movimiento'];

                        //Se asocian el movimiento y el saldo al detalle
                        $detalle_array['dee_id_moi'] = $moi_id;
                        $detalle_array['dee_id_sar'] = $sar_id;
                        //Se ingresa el detalle del movimiento
                        $dee_id = $this->gsatelite->ingresar('dee_detalle_mov', $detalle_array);


                        $dxd_array = $det['dxd_detalle_doc'];
                        if ($dxd_array != null) {
                            $dxd_id = $dxd_array['dxd_id'];
                            unset($dxd_array['dxd_id']);

                            $this->gsatelite->actualizar_array('dxd_detalle_documento_proveedor', $dxd_array, array('dxd_id' => $dxd_id));
                        }
                    }
                }

                $idsMovimiento[] = $moi_id;
            }
        }
        //die();
        //Se regresan los IDs de los movimientos ingresados.
        return $idsMovimiento;
    }

    function duplicar_doc_proveedor($dpv_id = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_btn = $post_array['btnCrear'];
            $idOrdenCompra = ($post_array['slcOrdenCompra'] != '') ? $post_array['slcOrdenCompra'] : null;
            $slcProveedor = $post_array['slcProveedor'];
            $slcTipoPago = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
            $slcTipoDocumento = ($post_array['slcTipoDocumento'] != '') ? $post_array['slcTipoDocumento'] : null;
            $txtSerieDoc = ($post_array['txtSerieDoc'] != '') ? $post_array['txtSerieDoc'] : null;
            $txtNumDoc = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;
            $slcDocAfecta = ($post_array['slcDocAfecta'] != '') ? $post_array['slcDocAfecta'] : null;
            $txtFechaDoc = ($post_array['txtFechaDoc'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDoc'])) : null;
            $txtFechaConta = ($post_array['txtFechaConta'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaConta'])) : null;
            $txtFechaVencimiento = ($post_array['txtFechaVencimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVencimiento'])) : null;
            $txtConcepto = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $txtDescripcion = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            //$slcRetenciones = ($post_array['slcRetenciones'] != '') ? $post_array['slcRetenciones'] : null;
            $hdnAfectaInv = $post_array['hdnAfectaInv'];
            $slcCajaChica = ($post_array['slcCajaChica'] != '') ? $post_array['slcCajaChica'] : null;
            $slcTipo = $post_array['slcTipo'];

            $txtDescuentoGeneral = ($post_array['txtDescuentoGeneral'] != '') ? $post_array['txtDescuentoGeneral'] : 0;
            $txtRetencionGeneral = ($post_array['txtRetencionGeneral'] != '') ? $post_array['txtRetencionGeneral'] : 0;
            $txtImpuestosGeneral = $post_array['txtImpuestosGeneral'];
            $txtSubtotalGeneral = $post_array['txtSubtotalGeneral'];
            $txtTotalGeneral = $post_array['txtTotalGeneral'];

            $documento_array = array(
                'dpv_id_orc' => $idOrdenCompra,
                'dpv_id_prv' => $slcProveedor,
                'dpv_id_tpg' => $slcTipoPago,
                'dpv_id_tif' => $slcTipoDocumento,
                'dpv_id_cch' => $slcCajaChica,
                'dpv_id_dpv_afecta' => $slcDocAfecta,
                'dpv_serie_documento' => $txtSerieDoc,
                'dpv_numero_documento' => $txtNumDoc,
                'dpv_fecha_documento' => $txtFechaDoc,
                'dpv_fecha_contabilizacion' => $txtFechaConta,
                'dpv_fecha_vencimiento' => $txtFechaVencimiento,
                'dpv_concepto' => $txtConcepto,
                'dpv_descripcion' => $txtDescripcion,
                'dpv_afecta_inventario' => $hdnAfectaInv,
                'dpv_tipo' => $slcTipo,
                'dpv_pagado' => 0,
                'dpv_monto_abono' => 0,
                'dpv_monto_pendiente' => 0,
                'dpv_impuesto' => convertirFloat($txtImpuestosGeneral),
                'dpv_descuento' => convertirFloat($txtDescuentoGeneral),
                'dpv_retencion' => convertirFloat($txtRetencionGeneral),
                'dpv_subtotal' => convertirFloat($txtSubtotalGeneral),
                'dpv_total' => convertirFloat($txtTotalGeneral),
                'dpv_estado' => 1,
                'dpv_usu_creacion' => $this->tank_auth->get_user_id(),
                'dpv_fecha_creacion' => date('Y-m-d H:i:s'),
                'dpv_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dpv_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->ingresar('dpv_documento_proveedor', $documento_array);

            if ($resultado > 0) {

                $dpv_id = $resultado;

                //Se obtienen los detalles de la grid
                $productos = $post_array['productos'];
                $conversiones = $post_array['conversion'];
                $cantidades = $post_array['cantidades'];
                $precios = $post_array['precios'];
                $retenciones = $post_array['retenciones'];
                $impuestos = $post_array['impuestos'];
                $bodegas = $post_array['bodegas'];
                $sectores = $post_array['sectores'];
                $impuestosProducto = $post_array['impuestosProducto'];
                $retencionesProducto = $post_array['retencionesProducto'];
                $tiposVenta = $post_array['tiposVenta'];
                $descuentos = $post_array['descuentos'];
                //$gastos = $post_array['gastos'];
                $subtotalesProducto = $post_array['subtotalesProducto'];
                $totalesProducto = $post_array['totalesProducto'];

                if (count($productos) > 0) {
                    //Se ingresan los detalles de la orden
                    for ($i = 0; $i < count($productos); $i++) {

                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;

                        //Se validan los registros en base al tipo de orden
                        //1 = Producto, 2 = Servicio, 3 = Activo Fijo
                        if ($slcTipo == 1) {
                            $producto_id = $productos[$i];
                            $conversion_prodc = $conversiones[$i];
                        } else if ($slcTipo == 2) {
                            $producto_id = $productos[$i];
                        } else {
                            $activo_id = $productos[$i];
                        }

                        $detalle_array = array(
                            'dxd_id_bod' => ($bodegas[$i] > 0) ? $bodegas[$i] : null,
                            'dxd_id_sxb' => ($sectores[$i] > 0) ? $sectores[$i] : null,
                            'dxd_id_dpv' => $dpv_id,
                            'dxd_id_act' => $activo_id,
                            'dxd_id_cva' => $conversion_prodc,
                            'dxd_id_art' => $producto_id,
                            'dxd_id_tpv' => ($tiposVenta[$i] != '') ? $tiposVenta[$i] : null,
                            'dxd_cantidad' => $cantidades[$i],
                            'dxd_precio_unitario' => $precios[$i],
                            'dxd_impuesto' => convertirFloat($impuestosProducto[$i]),
                            'dxd_descuento' => ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0,
                            'dxd_retencion' => convertirFloat($retencionesProducto[$i]),
                            'dxd_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dxd_total' => convertirFloat($totalesProducto[$i]),
                            'dxd_estado' => 1,
                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_creacion' => date('Y-m-d H:i:s'),
                        );

                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);

                        //Si se ingresa el detalle, se ingresan los impuestos y retenciones
                        if ($dxd_id > 0) {
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {

                                        $tax = $this->gsatelite->get_campo('imp_impuesto','imp_porcentaje', array('imp_id'=>$impuestos_array[$j]));
                                            if ($tax > 0) {
                                                $por_imp = $tax;
                                                $mon_imp = ($por_imp / 100) * $subtotalesDpv[$i];
                                            } else {
                                                $por_imp = $this->gsatelite->get_campo('imp_impuesto','imp_valor', array('imp_id'=>$value));
                                                $mon_imp = $txtCantidadesDpv[$i] * $por_imp;
                                            }
                                        
                                        if ($impuestos_array[$j] != '') {
                                            $ixo_array = array(
                                                'idd_id_imp' => $impuestos_array[$j],
                                                'idd_id_dxd' => $dxd_id,
                                                'idd_estado' => 1,
                                                'idd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'idd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'idd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'idd_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                        }
                                    }
                                }
                            }

                            //Se valida existan retenciones
                            if (count($retenciones) > 0) {
                                //Se crea el array de los retenciones
                                $retenciones_array = explode(',', $retenciones[$i]);

                                if (count($retenciones_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($retenciones_array); $j++) {

                                        if ($retenciones_array[$j] != '') {
                                            $rxd_array = array(
                                                'rxd_id_ret' => $retenciones_array[$j],
                                                'rxd_id_dxd' => $dxd_id,
                                                'rxd_estado' => 1,
                                                'rxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'rxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            if ($resultado > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "El registro se duplico correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $data['cerrar_modal'] = 1;
            $data['alerta'] = $alerta;
        }

        $doc_proveedor = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
        $data['proveedores'] = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        $data['tipo_pago'] = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', 'pagos', array('tpg_estado' => 1), $doc_proveedor[0]['dpv_id_tpg'], null, null, true);
        $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', array('tif_estado' => 1,'tif_aplica_compra' => 1), $doc_proveedor[0]['dpv_id_tif'], null, null, true);
        $data['retenciones'] = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));

        /* $data['cajas_chicas'] = $this->gsatelite->get_dropdown('cch_caja_chica', '{cch_nombre}', 'caja_chica', array('cch_estado' => 1), $doc_proveedor[0]['dpv_id_cch'], null, null, true);*/
        $data['tipo_venta'] = $this->gsatelite->get_dropdown('tpv_tipo_venta', '{tpv_nombre}', 'tipo_venta', array('tpv_estado'=>1,'tpv_aplica_compra'=>1), null, null, null, true);
        $data['bodegas'] = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', 'bodegas', array('bod_estado' => 1), null, null, null, true);
        $data['documentosAfecta'] = $this->gsatelite->get_dropdown('dpv_documento_proveedor', 'dpv_numero_documento', 'documentoAfecta', array('dpv_estado' => 1, 'dpv_id' => $doc_proveedor[0]['dpv_id_prv'], 'dpv_id !=' => $dpv_id), $doc_proveedor[0]['dpv_id_dpv_afecta'], null, null, true);
        $data['doc_proveedor'] = $doc_proveedor[0];

        $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id));

        $orc_id = $doc_proveedor[0]['dpv_id_orc'];

        if ($orc_id > 0) {
            $data['orden_compra'] = $orc_id;
            $data['ordenes_data'] = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
            $data['ordenes'] = $this->gsatelite->get_dropdown('orc_orden_compra', 'orc_numero', '', array('orc_id' => $orc_id), $orc_id, null, null, true);
        } else {
            $data['orden_compra'] = null;
            $data['ordenes'] = "";
        }

        ///////////////////// Sólo cajas chicas que poseen monto disponible /////////////////////////////
        $this->db->where(array('lcc_corte'=>0));
        $this->db->join('lcc_liquidacion_caja_chica', 'lcc_id_cch=cch_id AND lcc_disponible IS NOT NULL');
        $cajas = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado'=>1));

        $opt_cajas = '<option value=""></option>';
        foreach ($cajas as $cj) {
            if( $doc_proveedor[0]['dpv_id_cch']==$cj['cch_id']){ $select="selected"; }else{ $select=''; }
            $opt_cajas .='<option value="'.$cj['cch_id'].'"  data-lcc="'.$cj['lcc_id'].'" '.$select.'>'.$cj['cch_nombre'].' ('.$cj['lcc_disponible'].')</option>';
        }
        $data['cajas_chicas'] = $opt_cajas;
        /////////////////////////////////////////////////////////////////////////////////////////////////

        $data['titulo_personal'] = "Documentos por Proveedor";
        $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/duplicar_doc_proveedor', $data, true);
    }

    // $flag 1 = Indica si el reporte es impresion 2 = excel
    public function impresion_quedan($id_doc_proveedor, $id_quedan, $flag) {
        satelite_validar();
        $this->load->library('texto');
        $quedan = $this->gsatelite->get_tabla('qda_quedan', array('qda_id' => $id_quedan, 'qda_estado' => 1));
        $fecha_vencimiento_dpv = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_fecha_vencimiento', array('dpv_id' => $id_doc_proveedor));
        $dia_semana = formatear_fecha('w', $fecha_vencimiento_dpv);
        $dia_pago = "";
        switch ($dia_semana){ 
            case 0: $dia_pago = "DOMINGO"; break; 
            case 1: $dia_pago = "LUNES"; break; 
            case 2: $dia_pago = "MARTES"; break; 
            case 3: $dia_pago = "MI&Eacute;RCOLES"; break; 
            case 4: $dia_pago = "JUEVES"; break; 
            case 5: $dia_pago = "VIERNES"; break; 
            case 6: $dia_pago = "S&Aacute;BADO"; break; 
        } 
        if (count($quedan) > 0) {
            $data['dias'] = $dia_pago;
            $data['pago'] = formatear_fecha("d-m-Y", $fecha_vencimiento_dpv);
            $data['filename'] = 'quedan_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $tipo_documento_nit = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NIT_PROVEEDOR');            
            $data['datos_proveedor'] = $this->compras_model->get_quedan(array('dpv_id' => $id_doc_proveedor));
            $data['nit'] = $this->gsatelite->get_tabla('dcp_documento_proveedor', array('dcp_id_tde' => $tipo_documento_nit, 'dcp_id_prv' => $data['datos_proveedor'][0]['prv_id']));
            $total = number_format($data['datos_proveedor'][0]['dpv_monto_pendiente'], 2, '.', '');
            $dinero = explode(".", $total);
            $txtDolares = $this->texto->ValorEnLetras($dinero[0]);
            $data['total_letra'] = strtoupper($txtDolares) . " " . $dinero[1] . "/100 DOLARES";
            $data['quedan'] = $quedan;
            $data['fecha'] = ($quedan[0]['qda_fecha'] != null) ? $quedan[0]['qda_fecha'] : date('Y-m-d H:i:s');
            $data['tipo_reporte'] = ($flag == 1) ? 'pdf' : 'excel';
            $html = $this->load->view('modulo_compras/procesos/impresion_quedan', $data, true);
            if ($flag == 1) {
                $GLOBALS['nombre_reporte'] = 'quedan_' . date('dmY');
                $this->pdf->makePdf($html, 'P', 'documento_quedan', 'Letter');
            } else {
                echo $html;
            }
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de impresión", 'texto_alerta' => "No se pudo imprimir el documento");
            $this->session->set_flashdata($alerta);
            redirect('/modulo_compras/procesos/grid_quedan_form/' . $id_doc_proveedor);
        }
    }

    public function cotizaciones($rxi_id = null, $consulta = null, $nodef = null, $permisos = null, $vista = null) {
        satelite_validar();
        try {

            if ($consulta == 1 && $_POST) {
                $post_array     = $this->input->post();
                $data           = null;
                $proveedor      = $post_array['proveedor'];
                $requiscion     = $post_array['slc_requisicion'];
                $fecha_ini      = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin      = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $slc_sucursal   = $post_array['slc_sucusal'];
                $estado         = $post_array['slc_estado'];
                
                $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/proveedores');
                if($permisos != null){
                    $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/cotizaciones');
                }
                $permiso_val = $post_array['permiso_val'];

                $where = null;
                //var_dump($estado != 'null');die();
                if ($estado != 'null') {
                    $estado_ = implode(",",$estado);
                    $where["coc_estado IN($estado_)"] = NULL;
                }

                if ($slc_sucursal != '') {
                    $where["coc_usu_creacion IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp  WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                }

                if ($proveedor != '') {
                    $where['coc_id_prv'] = $proveedor;
                }
                if ($requiscion != '') {
                    $where['coc_id_rxi'] = $requiscion;
                }
                if ($fecha_ini != '' && $fecha_fin != '') {
                    $where['DATE(coc_fecha) >='] = $fecha_ini;
                    $where['DATE(coc_fecha) <='] = $fecha_fin;
                }

                if ($rxi_id > 0) {
                    $where['coc_id_rxi'] = $rxi_id;
                }

                $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
                $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                $permiso_rol = false;

                foreach ($mis_roles as $rol) {
                    if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                        $permiso_rol = true;
                    }
                }

                if ( $permiso_rol == false) {
                    $where['coc_usu_creacion']   = $this->tank_auth->get_user_id();
                } 

                $where['dco_estado'] = 1;
                $data['permiso_val'] = $permiso_val;
                $data['cotizaciones'] = $this->compras_model->get_cotizaciones($where);
                //print_r($this->db->last_query());die();         
                $html = $this->load->view('modulo_compras/procesos/consultar_cotizaciones', $data, true);
                echo $html;
                die();
            }
            $permiso_val = 0;
            if($vista != null){
                $permiso_val = 1;
            }

            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/cotizaciones');
            if($permisos != null){
                $data['permisos'] = $permisos;
            }
            $data['permiso_val']    = $permiso_val;
            $data['proveedores']    = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo,' - ', prv_nombre, prv_apellido) ELSE  CONCAT_WS(' ',prv_codigo,' - ', prv_apellido) END]", 'proveedores', array('prv_estado' => 1), null, null, null, true);            
            $this->db->join("users","id = rxi_usu_creacion");
            $data['requisiciones']  = $this->gsatelite->get_dropdown('rxi_requisicion_inventario', "{rxi_numero} - {username}", 'requisiciones', null, null, null, null, true);
            $data['requisicion']    = ($rxi_id > 0) ? $rxi_id : null; //$this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), null, null, null, true);
            $empleado               = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$this->tank_auth->get_user_id()));
            $sucursal_dropdown      = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', $empleado[0]['emp_id_suc'], '', 'suc_id', true);
            $data['sucursales']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_dropdown);
            $data['titulo_personal'] = "Registro de Cotizaciones";
            if($vista != null){
                cargarvista($data, null, $vista);
            } else{
                $this->_cargarvista($data);
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function cotizaciones2() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $permisos['permite_agregar'] = 0;
        $permisos['permite_editar'] = 0;
        $permisos['permite_eliminar'] = 0;
        $this->cotizaciones(null, null, null, $permisos, 'modulo_compras/procesos/cotizaciones');
    }

    public function seguimiento_orden_compra($orc_id = null) {
        satelite_validar();

        if ($orc_id != null) {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/ordenes_compra');

            $crud = new grocery_CRUD;

            $alias = array(
                'sgc_fecha' => 'Fecha',
                'sgc_id_tsg' => 'Tipos',
                'sgc_id_mts' => 'Forma seguimiento',
                'sgc_contacto' => 'Contacto',
                'sgc_comentario' => 'Comentario',
                'sgc_fecha_prox_seg' => 'Próx. seguimiento'
            );

            $colums = array(
                'sgc_fecha',
                'sgc_id_tsg',
                'sgc_id_mts',
                'sgc_contacto',
                'sgc_comentario',
                'sgc_fecha_prox_seg'
            );

            $crud->set_table('sgc_seguimiento_compra')
            ->set_subject('Seguimiento de compra')
            ->display_as($alias)
            ->columns($colums)
            ->set_relation('sgc_id_mts', 'mts_motivo_seguimiento', 'mts_nombre')
            ->set_relation('sgc_id_tsg', 'tsg_tipo_seguimiento', 'tsg_nombre')
            ->unset_delete()
            ->callback_column('sgc_fecha', array($this, '_callback_fecha'))
            ->callback_column('sgc_fecha_prox_seg', array($this, '_callback_fecha'))
            ->unset_add()
            ->unset_edit()
            ->unset_print()
            ->unset_export()
            ->where('sgc_id_orc', $orc_id)
            ;

            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_compras/procesos/editar_seguimiento_orden_compra/' . $orc_id, '');
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Seguimiento de orden de compra";
            $data['orc_id'] = $orc_id;
            $this->_cargarvista($data, $output);
        } else {

        }
    }

    public function _callback_fecha($value, $row) {
        $new_date = '';
        if ($value != '') {
            $new_date = date('d-m-Y', strtotime($value));
            ;
        }
        return $new_date;
    }

    public function agregar_seguimiento_orden_compra($orc_id = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();

            $fecha_seguimiento = ($post_array['txtFecha_seguimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFecha_seguimiento'])) : null;
            $contacto = ($post_array['txtContacto'] != '') ? $post_array['txtContacto'] : null;
            $comentario = ($post_array['txtComentario'] != '') ? $post_array['txtComentario'] : null;
            $tipo = ($post_array['slcTipo'] != '') ? $post_array['slcTipo'] : null;
            $forma = ($post_array['slcForma'] != '') ? $post_array['slcForma'] : null;
            $proximo_seguimiento = ($post_array['txtProximo_seguimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtProximo_seguimiento'])) : null;
            $orc_id = ($post_array['txt_orden'] != '') ? $post_array['txt_orden'] : null;

            $seguimiento_array = array(
                'sgc_id_orc' => $orc_id,
                'sgc_id_tsg' => $forma,
                'sgc_id_mts' => $tipo,
                'sgc_fecha' => $fecha_seguimiento,
                'sgc_contacto' => $contacto,
                'sgc_comentario' => $comentario,
                'sgc_fecha_prox_seg' => $proximo_seguimiento,
                'sgc_estado' => 1,
                'sgc_usu_creacion' => $this->tank_auth->get_user_id(),
                'sgc_fecha_creacion' => date('Y-m-d h:i:s'),
                'sgc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgc_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $this->gsatelite->ingresar('sgc_seguimiento_compra', $seguimiento_array);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Seguimiento de compra", 'texto_alerta' => "El registro se guardó correctamente");

            $this->session->set_flashdata($alerta);

            if ($post_array['btnGuardar'] == 1) {
                redirect('modulo_compras/procesos/agregar_seguimiento_orden_compra/' . $orc_id);
            } else {
                redirect('modulo_compras/procesos/seguimiento_orden_compra/' . $orc_id);
            }
        } else {
            $data['forma'] = $this->gsatelite->get_tabla('tsg_tipo_seguimiento');
            $data['tipo'] = $this->gsatelite->get_tabla('mts_motivo_seguimiento');

            $data['id_orden'] = $orc_id;
            $this->db->join('prv_proveedor', 'prv_id = orc_id_prv', 'left');
            $data['orden'] = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
            $data['titulo_personal'] = "Seguimiento de orden de compra";
            $this->_cargarvista($data);
        }
    }

    public function editar_seguimiento_orden_compra($orc_id = null, $sgc_id = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();

            $fecha_seguimiento = ($post_array['txtFecha_seguimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFecha_seguimiento'])) : null;
            $contacto = ($post_array['txtContacto'] != '') ? $post_array['txtContacto'] : null;
            $comentario = ($post_array['txtComentario'] != '') ? $post_array['txtComentario'] : null;
            $tipo = ($post_array['slcTipo'] != '') ? $post_array['slcTipo'] : null;
            $forma = ($post_array['slcForma'] != '') ? $post_array['slcForma'] : null;
            $proximo_seguimiento = ($post_array['txtProximo_seguimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtProximo_seguimiento'])) : null;
            $sgc_id = ($post_array['txt_seguimiento'] != '') ? $post_array['txt_seguimiento'] : null;
            $orc_id = ($post_array['txt_orden'] != '') ? $post_array['txt_orden'] : null;

            $seguimiento_array = array(
                'sgc_id_tsg' => $forma,
                'sgc_id_mts' => $tipo,
                'sgc_fecha' => $fecha_seguimiento,
                'sgc_contacto' => $contacto,
                'sgc_comentario' => $comentario,
                'sgc_fecha_prox_seg' => $proximo_seguimiento,
                'sgc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgc_fecha_modificacion' => date('Y-m-d h:i:s')
            );
            $this->gsatelite->actualizar_array('sgc_seguimiento_compra', $seguimiento_array, array('sgc_id' => $sgc_id));

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Seguimiento de compra", 'texto_alerta' => "El registro se actualizo correctamente");

            $this->session->set_flashdata($alerta);

            if ($post_array['btnGuardar'] == 1) {
                redirect('modulo_compras/procesos/editar_seguimiento_orden_compra/' . $orc_id . '/' . $sgc_id);
            } else {
                redirect('modulo_compras/procesos/seguimiento_orden_compra/' . $orc_id);
            }
        } else {
            $data['id_seguimiento'] = $sgc_id;
            $data['id_orden'] = $orc_id;

            $data['forma'] = $this->gsatelite->get_tabla('tsg_tipo_seguimiento');

            $data['tipo'] = $this->gsatelite->get_tabla('mts_motivo_seguimiento');

            $this->db->join('sgc_seguimiento_compra', 'sgc_id_orc = orc_id');
            $this->db->join('prv_proveedor', 'prv_id = orc_id_prv');
            $data['orden'] = $this->gsatelite->get_tabla('orc_orden_compra', array('sgc_id' => $sgc_id));

            $data['seguimiento'] = $this->gsatelite->get_tabla('sgc_seguimiento_compra', array('sgc_id' => $sgc_id));
            $data['titulo_personal'] = "Seguimiento de orden de compra";

            $this->_cargarvista($data);
        }
    }

    public function agregar_cotizacion($rxi_id = null) {
        satelite_validar();
        if ($_POST) { 
            //print_r($_POST);die();
            $post_array             = $_POST;
            $slcRequisicion         = ($post_array['slcRequisicion'] != '') ? $post_array['slcRequisicion'] : null;
            $txtFechaCotizacion     = ($post_array['txtFechaCotizacion'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaCotizacion'])) : null;
            $txtPeriodoVal          = ($post_array['txtPeriodoVal'] != '') ? $post_array['txtPeriodoVal'] : null;
            $txtNombreVendedor      = ($post_array['txtNombreVendedor'] != '') ? $post_array['txtNombreVendedor'] : null;
            $slcTipo                = ($post_array['slcTipo'] != '') ? $post_array['slcTipo'] : null;
            $txtDescripcion         = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $slcProveedor           = ($post_array['slcProveedor'] != '') ? $post_array['slcProveedor'] : null;
            $txtDescuentoGeneral    = ($post_array['txtDescuentoGeneral'] != '') ? $post_array['txtDescuentoGeneral'] : null;
            $txtSubtotalGeneral     = ($post_array['txtSubtotalGeneral'] != '') ? $post_array['txtSubtotalGeneral'] : null;
            $txtImpuestosGeneral    = ($post_array['txtImpuestosGeneral'] != '') ? $post_array['txtImpuestosGeneral'] : null;
            $txtGastosGeneral       = ($post_array['txtGastosGeneral'] != '') ? $post_array['txtGastosGeneral'] : null;
            $txtTotalGeneral        = ($post_array['txtTotalGeneral'] != '') ? $post_array['txtTotalGeneral'] : null;
            $slc_presupuesto        = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $slc_actividad_general  = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $slc_act_especifica     = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
            $slcProyecto            = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $txtEntrega             = ($post_array['txtEntrega'] != '') ? $post_array['txtEntrega'] : null;
            $txtCondiciones         = ($post_array['txt_condiciones'] != '') ? $post_array['txt_condiciones'] : null;
            $coc_id_tpg             = ($post_array['slc_tipo_pago'] != '') ? $post_array['slc_tipo_pago'] : null;
            $coc_id_cod             = ($post_array['slc_condicion_pago'] != '') ? $post_array['slc_condicion_pago'] : null;            
            $num_actual             = $this->gsatelite->count('coc_cotizacion_compra');
            $codigo                 = $num_actual + 1;
            $num_cotizacion         = generar_codigo_cor($codigo, 4);
            //Array con datos de los anexos
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];
            $cotizacion_array = array(
                'coc_id_rxi'                => $slcRequisicion,
                'coc_id_prv'                => $slcProveedor,
                'coc_id_tpg'                => $coc_id_tpg,
                'coc_id_cod'                => $coc_id_cod,
                'coc_vendedor'              => $txtNombreVendedor,
                'coc_numero'                => $num_cotizacion,
                'coc_observacion'           => $txtDescripcion,
                'coc_tipo_requerimiento'    => $slcTipo,
                'coc_fecha'                 => $txtFechaCotizacion,
                'coc_periodo_validez'       => $txtPeriodoVal,
                'coc_impuesto'              => convertirFloat($txtImpuestosGeneral),
                'coc_descuento'             => convertirFloat($txtDescuentoGeneral),
                'coc_otros_gastos'          => convertirFloat($txtGastosGeneral),
                'coc_subtotal'              => convertirFloat($txtSubtotalGeneral),
                'coc_total'                 => convertirFloat($txtTotalGeneral),
                'coc_estado'                => 1,
                'coc_usu_creacion'          => $this->tank_auth->get_user_id(),
                'coc_fecha_creacion'        => date('Y-m-d H:i:s'),
                'coc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'coc_fecha_modificacion'    => date('Y-m-d H:i:s'),
                'coc_id_psp'                => $slc_presupuesto,
                'coc_id_ace'                => $slc_act_especifica,
                'coc_id_acg'                => $slc_actividad_general,
                'coc_id_pcl'                => $slcProyecto,
                'coc_entrega'               => $txtEntrega,
                'coc_codiciones_entrega'    => $txtCondiciones
            );           
            $coc_id = $this->gsatelite->ingresar('coc_cotizacion_compra', $cotizacion_array);
            if ($coc_id > 0) {
                //Se obtienen los detalles
                $conversion = ($post_array['conversion'] != '') ? $post_array['conversion'] : null;
                $productos = ($post_array['productos'] != '') ? $post_array['productos'] : null;
                $impuestos = ($post_array['impuestos'] != '') ? $post_array['impuestos'] : null;
                $gastos = ($post_array['gastos'] != '') ? $post_array['gastos'] : null;
                $descuentos = ($post_array['descuentos'] != '') ? $post_array['descuentos'] : null;
                $cantidades = ($post_array['cantidades'] != '') ? $post_array['cantidades'] : null;
                $precios = ($post_array['precios'] != '') ? $post_array['precios'] : null;
                $impuestosProducto = ($post_array['impuestosProducto'] != '') ? $post_array['impuestosProducto'] : null;
                $gastosProducto = ($post_array['gastosProducto'] != '') ? $post_array['gastosProducto'] : null;
                $subtotalesProducto = ($post_array['subtotalesProducto'] != '') ? $post_array['subtotalesProducto'] : null;
                $totalesProducto = ($post_array['totalesProducto'] != '') ? $post_array['totalesProducto'] : null;
                if (count($productos) > 0) {
                    //Se ingresan los detalles de la cotizacion
                    for ($i = 0; $i < count($productos); $i++) {
                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;
                        //Se validan los registros en base al tipo de orden
                        //1 = Producto, 2 = Servicio, 3 = Activo Fijo, 4 = Producto y Servicio
                        if ($slcTipo == 1) {
                            $producto_id = $productos[$i];
                            $conversion_prodc = $conversion[$i];
                        } else if ($slcTipo == 2) {
                            $producto_id = $productos[$i];
                        } else if($slcTipo == 3) {
                            $activo_id = $productos[$i];
                        } else if ($slcTipo == 4) {
                            $producto_id = $productos[$i];
                            $conversion_prodc = ($conversion[$i]!='') ? $conversion[$i] : null;
                        }
                        $impuesto_detalle = convertirFloat($impuestosProducto[$i]);
                        $gastos_detalle = convertirFloat($gastosProducto[$i]);
                        $descuento_detalle = convertirFloat($descuentos[$i]);
                        $detalle_array = array(
                            'dco_id_art' => $producto_id,
                            'dco_id_act' => $activo_id,
                            'dco_id_coc' => $coc_id,
                            'dco_id_cva' => ($conversion_prodc > 0)? $conversion_prodc:null,
                            'dco_cantidad' => convertirFloat($cantidades[$i]),
                            'dco_precio_unitario' => convertirFloat($precios[$i]),
                            //'dco_otros_gastos' => ($gastos_detalle == '') ? 0 : $gastos_detalle,
                            'dco_impuesto' => ($impuesto_detalle == '') ? 0 : $impuesto_detalle,
                            'dco_descuento' => ($descuento_detalle == '') ? 0 : $descuento_detalle,
                            'dco_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dco_total' => convertirFloat($totalesProducto[$i]),
                            'dco_estado' => 1,
                            'dco_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dco_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dco_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dco_fecha_creacion' => date('Y-m-d H:i:s'),
                        );
                        $dco_id = $this->gsatelite->ingresar('dco_detalle_cotizacion', $detalle_array);
                        //Si se ingresa el detalle, se ingresan los impuestos y gastos
                        if ($dco_id > 0) {
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);
                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {
                                        if ($impuestos_array[$j] != '') {
                                            $ixo_array = array(
                                                'ixz_id_imp' => $impuestos_array[$j],
                                                'ixz_id_dco' => $dco_id,
                                                'ixz_estado' => 1,
                                                'ixz_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'ixz_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'ixz_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'ixz_fecha_creacion' => date('Y-m-d H:i:s')
                                            );
                                            $this->gsatelite->ingresar('ixz_impuestoxdetalle_cotizacion', $ixo_array);
                                        }
                                    }
                                }
                            }
                            //Se valida existan gastos
                            if (count($gastos) > 0) {
                                //Se crea el array de los impuestos
                                $gastos_array = explode(',', $gastos[$i]);
                                if (count($gastos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($gastos_array); $j++) {
                                        if ($gastos_array[$j] != '') {
                                            $gxt_array = array(
                                                'gxt_id_gst' => $gastos_array[$j],
                                                'gxt_id_dco' => $dco_id,
                                                'gxt_estado' => 1,
                                                'gxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'gxt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'gxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'gxt_fecha_creacion' => date('Y-m-d H:i:s')
                                            );
                                            $this->gsatelite->ingresar('gxt_gastosxdetalle_cotizacion', $gxt_array);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                //Si vienen anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anx_cotizacion/" . $nombreArchivo;

                        $documentos_array = array(
                            'ant_id_coc'             => $coc_id,
                            'ant_url'                => $carpeta_destino_anx,
                            'ant_nombre'             => $nombreArchivo,
                            'ant_estado'             => 1,
                            'ant_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'ant_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'ant_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'ant_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $ant_id = $this->gsatelite->ingresar('ant_anexo_cotizacion_compra', $documentos_array);

                        if ($ant_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotizaciones", 'texto_alerta' => "Cotización #" . $num_cotizacion . " se procesó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotizaciones", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $tipo_btn = $post_array['btnCrear'];

            $this->session->set_flashdata($alerta);

            if($rxi_id == null){
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/procesos/agregar_cotizacion/');
                    //redirect('modulo_compras/procesos/agregar_cotizacion/' . $coc_id); //antes 04/11/2018
                } else {
                    redirect('modulo_compras/procesos/cotizaciones/');
                }
            } else{
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/procesos/agregar_cotizacion/' . $rxi_id);
                } else {
                    redirect('modulo_compras/procesos/cotizaciones/' . $rxi_id.'/1');
                }
            }
        }
        $permiso_compra = false;
        $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
        $permisos_array = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
        if ( count($permisos_array) > 0 ) {
            $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
            foreach ($roles as $role) {
                if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                    $permiso_compra = true;
                }
            }
        }
        $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
        $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;
        $data["permiso_compra"] = $permiso_compra;        
        $num_actual             = $this->gsatelite->count('coc_cotizacion_compra');
        $codigo                 = $num_actual + 1;
        $data['num_cotizacion'] = generar_codigo_cor($codigo, 4);

        $data['presupuesto']        = '<option value=""></option>';
        $data['general']            = '<option value=""></option>';
        $data['especifica']         = '<option value=""></option>';

        if ($rxi_id != null) {
            $data['requisicion']        = $rxi_id;
            $data['requisicion_data']   = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $rxi_id));
                        $this->db->join('users', 'id = rxi_id_usu_solicita');
                        $this->db->join('emp_empleado', 'emp_id_usu = id');
                        $this->db->join('are_area', 'are_id = emp_id_are', 'LEFT');
            $dato_rxi = $this->gsatelite->get_registro('rxi_requisicion_inventario', array('rxi_id' => $rxi_id));
            $area_name = $dato_rxi->are_nombre;
            $fecha_rxi = formatear_fecha('d-m-Y', $dato_rxi->rxi_fecha);
            $data['requisiciones'] = $this->gsatelite->get_dropdown('rxi_requisicion_inventario',"{rxi_numero} - $area_name ($fecha_rxi)",'', array('rxi_id' => $rxi_id), $rxi_id, null, null, true);
            $data['detalle_requisicion']= $this->inventario_model->get_requisicion_detalle(array('dri_id_rxi' => $rxi_id));
            $req                        = $data['requisicion_data'];
            $slc_presupuesto            = ($req[0]['rxi_id_psp'] != "" )?$this->get_presupuestoxproyecto($req[0]['rxi_id_pcl'], $req[0]['rxi_id_psp']):'<option value=""></option>';
            $data['presupuesto']        = $slc_presupuesto;
            $slc_general                = ($req[0]['rxi_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($req[0]['rxi_id_psp'], $req[0]['rxi_id_acg'],false,false):'<option value=""></option>';
            $data['general']            = $slc_general;
            $slc_especifica             = ($req[0]['rxi_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($req[0]['rxi_id_acg'], $req[0]['rxi_id_psp'], $req[0]['rxi_id_ace']):'<option value=""></option>';
            $data['especifica']         = $slc_especifica;

        } else {
            $req                        = null;
            $data['requisicion']        = null;
            $select = '<option value=""></option>';
                            $this->db->group_by('rxi_id');
                            $this->db->join('coc_cotizacion_compra', 'coc_id_rxi = rxi_id', 'LEFT');
                            $this->db->join('users', 'id = rxi_id_usu_solicita');
                            $this->db->join('emp_empleado', 'emp_id_usu = id');
                            $this->db->join('are_area', 'are_id = emp_id_are', 'LEFT');
            $slc_requisix = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_estado' => 3, '(coc_estado != 2 OR coc_estado IS NULL)' => null));
            foreach ($slc_requisix as $k => $v) {
                $solicitante = $this->inventario_model->informacion_empleado($v['rxi_id_usu_solicita']);
                $select .= '<option value="' . $v['rxi_id'] . '" >' . $v['rxi_numero'] . ' - ' . $solicitante[0]['are_nombre'] . ' (' . formatear_fecha('d-m-Y', $v['rxi_fecha']) . ')</option>';
            }
            $data['requisiciones'] = $select;
            $data['detalle_requisicion']= null; 
        }

        $proveedores    = $this->compras_model->get_proveedor_pers();
        $options        = '<option value=""></option>';
        foreach ($proveedores as $key) {
            //if ($key['pro'] != '') {
            $options .= '<option value="' . $key['prv_id'] . '">' . $key['pro'] . '</option>';
            // }
        }
        $proyectos_reg      = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
        $select_proyecto    = '<option value=""></option>';

        foreach ($proyectos_reg as $key) {
            $selected = "";
            if ($req  != null){
                $selected = ($key['pcl_id'] == $req[0]["rxi_id_pcl"])?"selected":"";
            }
            $nombre_cliente     = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
            $nombre             = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
            $select_proyecto    .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
        }
        $data['proyectos']          = $select_proyecto;
        $condiciones_drop           = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), null, null, null, true);
        $data['condiciones']        = str_replace('<option value="0">Seleccione</option>', '', $condiciones_drop);    
        $tipo_pago_drop             = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, null, null, true);
        $data['tipo_pago']          = str_replace('<option value="0">Seleccione</option>', '', $tipo_pago_drop);    
        $data['proveedores']        = $options;
        $data['gastos']             = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));
        $data['titulo_personal']    = "Agregar Cotización";
        $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
        $this->_cargarvista($data);
    }

    public function editar_cotizacion($coc_id = null) {
        satelite_validar();
        if ($_POST) {

            $post_array             = $_POST;
            $slcRequisicion         = ($post_array['slcRequisicion'] != '') ? $post_array['slcRequisicion'] : null;
            $txtFechaCotizacion     = ($post_array['txtFechaCotizacion'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaCotizacion'])) : null;
            $txtPeriodoVal          = ($post_array['txtPeriodoVal'] != '') ? $post_array['txtPeriodoVal'] : null;
            $txtNombreVendedor      = ($post_array['txtNombreVendedor'] != '') ? $post_array['txtNombreVendedor'] : null;
            $slcTipo                = ($post_array['slcTipo'] != '') ? $post_array['slcTipo'] : null;
            $txtDescripcion         = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $slcProveedor           = ($post_array['slcProveedor'] != '') ? $post_array['slcProveedor'] : null;
            $txtDescuentoGeneral    = ($post_array['txtDescuentoGeneral'] != '') ? $post_array['txtDescuentoGeneral'] : null;
            $txtSubtotalGeneral     = ($post_array['txtSubtotalGeneral'] != '') ? $post_array['txtSubtotalGeneral'] : null;
            $txtImpuestosGeneral    = ($post_array['txtImpuestosGeneral'] != '') ? $post_array['txtImpuestosGeneral'] : null;
            $txtGastosGeneral       = ($post_array['txtGastosGeneral'] != '') ? $post_array['txtGastosGeneral'] : null;
            $txtTotalGeneral        = ($post_array['txtTotalGeneral'] != '') ? $post_array['txtTotalGeneral'] : null;
            $slc_presupuesto        = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $slc_actividad_general  = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $slc_act_especifica     = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null; 
            $slcProyecto            = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $txtEntrega             = ($post_array['txtEntrega'] != '') ? $post_array['txtEntrega'] : null;
            $txtCondiciones         = ($post_array['txt_condiciones'] != '') ? $post_array['txt_condiciones'] : null;
            $coc_id_tpg             = ($post_array['slc_tipo_pago'] != '') ? $post_array['slc_tipo_pago'] : null;
            $coc_id_cod             = ($post_array['slc_condicion_pago'] != '') ? $post_array['slc_condicion_pago'] : null;            

            $cotizacion_array = array(
                'coc_id_prv'                => $slcProveedor,
                'coc_id_tpg'                => $coc_id_tpg,
                'coc_id_cod'                => $coc_id_cod,
                'coc_vendedor'              => $txtNombreVendedor,
                'coc_observacion'           => $txtDescripcion,
                'coc_tipo_requerimiento'    => $slcTipo,
                'coc_fecha'                 => $txtFechaCotizacion,
                'coc_periodo_validez'       => $txtPeriodoVal,
                'coc_impuesto'              => convertirFloat($txtImpuestosGeneral),
                'coc_descuento'             => convertirFloat($txtDescuentoGeneral),
                'coc_otros_gastos'          => convertirFloat($txtGastosGeneral),
                'coc_subtotal'              => convertirFloat($txtSubtotalGeneral),
                'coc_total'                 => convertirFloat($txtTotalGeneral),
                'coc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'coc_fecha_modificacion'    => date('Y-m-d H:i:s'),
                'coc_id_psp'                => $slc_presupuesto,
                'coc_id_ace'                => $slc_act_especifica,
                'coc_id_acg'                => $slc_actividad_general,
                'coc_id_pcl'                => $slcProyecto,
                'coc_entrega'               => $txtEntrega,
                'coc_codiciones_entrega'    => $txtCondiciones
            );

            //Anexos   
            $AnexoPrv = $post_array['AnexoPrv'];
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];

            $resultado = $this->gsatelite->actualizar_array('coc_cotizacion_compra', $cotizacion_array, array('coc_id' => $coc_id));

            if ($resultado > 0) {
                //Se obtienen los detalles ya registrados
                $registrosDco = ($post_array['registrosDco'] != '') ? $post_array['registrosDco'] : null;
                $productosDco = ($post_array['productosDco'] != '') ? $post_array['productosDco'] : null;
                $impuestosDco = ($post_array['impuestosDco'] != '') ? $post_array['impuestosDco'] : null;
                $gastosDco = ($post_array['gastosDco'] != '') ? $post_array['gastosDco'] : null;
                $cantidadesDco = ($post_array['cantidadesDco'] != '') ? $post_array['cantidadesDco'] : null;
                $preciosDco = ($post_array['preciosDco'] != '') ? $post_array['preciosDco'] : null;
                $impuestosProductoDco = ($post_array['impuestosProductoDco'] != '') ? $post_array['impuestosProductoDco'] : null;
                $gastosProductoDco = ($post_array['gastosProductoDco'] != '') ? $post_array['gastosProductoDco'] : null;
                $descuentosDco = ($post_array['descuentosDco'] != '') ? $post_array['descuentosDco'] : null;
                $subtotalesProductoDco = ($post_array['subtotalesProductoDco'] != '') ? $post_array['subtotalesProductoDco'] : null;
                $totalesProductoDco = ($post_array['totalesProductoDco'] != '') ? $post_array['totalesProductoDco'] : null;

                $num_cotizacion = $this->gsatelite->get_campo('coc_cotizacion_compra', 'coc_numero', array('coc_id' => $coc_id));


                //Se eliminan los registros necesarios.
                //Se verifica si se eliminaron productos.
                $where = array(
                    'dco_id_coc' => $coc_id
                );
                $dataDetalle = $this->compras_model->get_detalle_cotizacion($where);
                if (!is_array($registrosDco)) {
                    $registrosDco = array();
                }
                foreach ($dataDetalle as $data) {
                    if (!in_array($data['dco_id'], $registrosDco)) {

                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('ixz_impuestoxdetalle_cotizacion', array('ixz_id_dco' => $data['dco_id']));
                        //Se eliminan los gastos del detalle
                        $this->gsatelite->borrado_general('gxt_gastosxdetalle_cotizacion', array('gxt_id_dco' => $data['dco_id']));
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('dco_detalle_cotizacion', array('dco_id' => $data['dco_id']));
                    }
                }

                //Se actualizan los detalles
                if (count($registrosDco) > 0) {

                    for ($i = 0; $i < count($registrosDco); $i++) {

                        $impuesto_detalle = convertirFloat($impuestosProductoDco[$i]);
                        $gastos_detalle = convertirFloat($gastosProductoDco[$i]);
                        $descuento_detalle = convertirFloat($descuentosDco[$i]);


                        $detalle_array = array(
                            'dco_cantidad' => convertirFloat($cantidadesDco[$i]),
                            'dco_precio_unitario' => convertirFloat($preciosDco[$i]),
                            //'dco_otros_gastos' => ($gastos_detalle == '') ? 0 : $gastos_detalle,
                            'dco_impuesto' => ($impuesto_detalle == '') ? 0 : $impuesto_detalle,
                            'dco_descuento' => ($descuento_detalle == '') ? 0 : $descuento_detalle,
                            'dco_subtotal' => convertirFloat($subtotalesProductoDco[$i]),
                            'dco_total' => convertirFloat($totalesProductoDco[$i]),
                            'dco_estado' => 1,
                            'dco_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dco_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dco_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dco_fecha_creacion' => date('Y-m-d H:i:s'),
                        );

                        $resultado = $this->gsatelite->actualizar_array('dco_detalle_cotizacion', $detalle_array, array('dco_id' => $registrosDco[$i]));

                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('ixz_impuestoxdetalle_cotizacion', array('ixz_id_dco' => $registrosDco[$i]));
                        //Se ingresan nuevamente
                        if (count($impuestosDco) > 0) {
                            //Se crea el array de los impuestos
                            $impuestos_array = explode(',', $impuestosDco[$i]);

                            if (count($impuestos_array) > 0) {
                                //Se recore el array para la insercion de impuestos

                                for ($j = 0; $j < count($impuestos_array); $j++) {
                                    if ($impuestos_array[$j] != '') {
                                        $ixz_array = array(
                                            'ixz_id_imp' => $impuestos_array[$j],
                                            'ixz_id_dco' => $registrosDco[$i],
                                            'ixz_estado' => 1,
                                            'ixz_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'ixz_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'ixz_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'ixz_fecha_creacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('ixz_impuestoxdetalle_cotizacion', $ixz_array);
                                    }
                                }
                            }
                        }

                        //Se eliminan los gastos del detalle
                        $this->gsatelite->borrado_general('gxt_gastosxdetalle_cotizacion', array('gxt_id_dco' => $registrosDco[$i]));
                        //Se ingresan nuevamente
                        if (count($gastosDco) > 0) {
                            //Se crea el array de los impuestos
                            $gastos_array = explode(',', $gastosDco[$i]);

                            if (count($gastos_array) > 0) {
                                //Se recore el array para la insercion de impuestos

                                for ($j = 0; $j < count($gastos_array); $j++) {
                                    if ($gastos_array[$j] != '') {
                                        $gxt_array = array(
                                            'gxt_id_gst' => $gastos_array[$j],
                                            'gxt_id_dco' => $registrosDco[$i],
                                            'gxt_estado' => 1,
                                            'gxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'gxt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'gxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'gxt_fecha_creacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('gxt_gastosxdetalle_cotizacion', $gxt_array);
                                    }
                                }
                            }
                        }
                    }
                }

                //Se obtienen los detalles
                $conversion = ($post_array['conversion'] != '') ? $post_array['conversion'] : null;
                $productos = ($post_array['productos'] != '') ? $post_array['productos'] : null;
                $impuestos = ($post_array['impuestos'] != '') ? $post_array['impuestos'] : null;
                $gastos = ($post_array['gastos'] != '') ? $post_array['gastos'] : null;
                $descuentos = ($post_array['descuentos'] != '') ? $post_array['descuentos'] : null;
                $cantidades = ($post_array['cantidades'] != '') ? $post_array['cantidades'] : null;
                $precios = ($post_array['precios'] != '') ? $post_array['precios'] : null;
                $impuestosProducto = ($post_array['impuestosProducto'] != '') ? $post_array['impuestosProducto'] : null;
                $gastosProducto = ($post_array['gastosProducto'] != '') ? $post_array['gastosProducto'] : null;
                $subtotalesProducto = ($post_array['subtotalesProducto'] != '') ? $post_array['subtotalesProducto'] : null;
                $totalesProducto = ($post_array['totalesProducto'] != '') ? $post_array['totalesProducto'] : null;

                if (count($productos) > 0) {
                    //Se ingresan los detalles de la cotizacion
                    for ($i = 0; $i < count($productos); $i++) {

                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;

                        //Se validan los registros en base al tipo de orden
                        //1 = Producto, 2 = Servicio, 3 = Activo Fijo
                        if ($slcTipo == 1) {
                            $producto_id = $productos[$i];
                            $conversion_prodc = $conversion[$i];
                        } else if ($slcTipo == 2) {
                            $producto_id = $productos[$i];
                        } else if ($slcTipo == 3) {
                            $activo_id = $productos[$i];
                        } else if ($slcTipo == 4) {
                            $producto_id = $productos[$i];
                            $conversion_prodc = ($conversion[$i]!='') ? $conversion[$i] : null;
                        }

                        $impuesto_detalle = convertirFloat($impuestosProducto[$i]);
                        $gastos_detalle = convertirFloat($gastosProducto[$i]);
                        $descuento_detalle = convertirFloat($descuentos[$i]);

                        $detalle_array = array(
                            'dco_id_art' => $producto_id,
                            'dco_id_act' => $activo_id,
                            'dco_id_coc' => $coc_id,
                            'dco_id_cva' => $conversion_prodc,
                            'dco_cantidad' => convertirFloat($cantidades[$i]),
                            'dco_precio_unitario' => convertirFloat($precios[$i]),
                            //'dco_otros_gastos' => ($gastos_detalle == '') ? 0 : $gastos_detalle,
                            'dco_impuesto' => ($impuesto_detalle == '') ? 0 : $impuesto_detalle,
                            'dco_descuento' => ($descuento_detalle == '') ? 0 : $descuento_detalle,
                            'dco_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dco_total' => convertirFloat($totalesProducto[$i]),
                            'dco_estado' => 1,
                            'dco_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dco_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dco_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dco_fecha_creacion' => date('Y-m-d H:i:s'),
                        );

                        $dco_id = $this->gsatelite->ingresar('dco_detalle_cotizacion', $detalle_array);

                        //Si se ingresa el detalle, se ingresan los impuestos y gastos
                        if ($dco_id > 0) {

                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {

                                        if ($impuestos_array[$j] != '') {
                                            $ixo_array = array(
                                                'ixz_id_imp' => $impuestos_array[$j],
                                                'ixz_id_dco' => $dco_id,
                                                'ixz_estado' => 1,
                                                'ixz_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'ixz_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'ixz_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'ixz_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('ixz_impuestoxdetalle_cotizacion', $ixo_array);
                                        }
                                    }
                                }
                            }


                            //Se valida existan gastos
                            if (count($gastos) > 0) {
                                //Se crea el array de los impuestos
                                $gastos_array = explode(',', $gastos[$i]);

                                if (count($gastos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($gastos_array); $j++) {

                                        if ($gastos_array[$j] != '') {
                                            $gxt_array = array(
                                                'gxt_id_gst' => $gastos_array[$j],
                                                'gxt_id_dco' => $dco_id,
                                                'gxt_estado' => 1,
                                                'gxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'gxt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'gxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'gxt_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('gxt_gastosxdetalle_cotizacion', $gxt_array);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                $dataAnexos = $this->gsatelite->get_tabla('ant_anexo_cotizacion_compra', array('ant_id_coc' => $coc_id));
                if (!is_array($AnexoPrv)) {
                    $AnexoPrv = array();                
                }
                foreach ($dataAnexos as $data) {
                    if (!in_array($data['ant_id'], $AnexoPrv)) {
                        $this->gsatelite->borrado_general('ant_anexo_cotizacion_compra', array('ant_id' => $data['ant_id']));
                        $ruta_nxp = $data['ant_url'];
                        unlink($ruta_nxp);
                    }
                }

                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_cotizacion/" . $nombreArchivo;

                        $documentos_array = array(
                            'ant_id_coc'             => $coc_id,
                            'ant_url'                => $carpeta_destino_anx,
                            'ant_nombre'             => $nombreArchivo,
                            'ant_estado'             => 1,
                            'ant_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'ant_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'ant_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'ant_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $ant_id = $this->gsatelite->ingresar('ant_anexo_cotizacion_compra', $documentos_array);

                        if ($ant_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }




                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotizaciones", 'texto_alerta' => "Cotización #" . $num_cotizacion . " se actualizó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotizaciones", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $tipo_btn = $post_array['btnCrear'];

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('modulo_compras/procesos/editar_cotizacion/' . $coc_id);
            } else {
                redirect('modulo_compras/procesos/cotizaciones/');
            }
        }
        $permiso_compra = false;
        $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
        $permisos_array = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
        if ( count($permisos_array) > 0 ) {
            $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
            foreach ($roles as $role) {
                if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                    $permiso_compra = true;
                }
            }
        }
        $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
        $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;
        $data["permiso_compra"] = $permiso_compra; 
        $cotizacion_data        = $this->compras_model->get_cotizaciones(array('coc_id' => $coc_id));
        $cotizacion             = $cotizacion_data[0];
        $rxi_id                 = $cotizacion['coc_id_rxi'];
        if ($rxi_id != null) {
            $data['requisicion'] = $rxi_id;
            $data['requisicion_data'] = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $rxi_id));
            $this->db->join('users','id = rxi_id_usu_solicita');
            $data['requisiciones'] = $this->gsatelite->get_dropdown('rxi_requisicion_inventario', '{rxi_numero} - {username}', '', array('rxi_id' => $rxi_id), $rxi_id, null, null, true);
        } else {
            $data['requisicion'] = null;
            $this->db->join('users','id = rxi_id_usu_solicita');
            $data['requisiciones'] = $this->gsatelite->get_dropdown('rxi_requisicion_inventario', '{rxi_numero} - {username}', '', array('rxi_estado' => 3), null, null, null, true);
            $data['detalle_requisicion'] = null;
        }

        $proveedores = $this->compras_model->get_proveedor_pers();
        $options = '<option value=""></option>';
        foreach ($proveedores as $key) {
            if ($key['pro'] != '') {
                if ($cotizacion['coc_id_prv'] == $key['prv_id']) {
                    $options .= '<option value="' . $key['prv_id'] . '" selected>' . $key['pro'] . '</option>';
                } else {
                    $options .= '<option value="' . $key['prv_id'] . '" >' . $key['pro'] . '</option>';
                }
            }
        }
        
        $slc_presupuesto            = ($cotizacion['coc_id_psp'] != "" )?$this->get_presupuestoxproyecto($cotizacion['coc_id_pcl'], $cotizacion['coc_id_psp']):'<option value=""></option>';
        $data['presupuesto']        = $slc_presupuesto;
        $slc_general                = ($cotizacion['coc_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($cotizacion['coc_id_psp'], $cotizacion['coc_id_acg'],false,false):'<option value=""></option>';
        $data['general']            = $slc_general;
        $slc_especifica             = ($cotizacion['coc_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($cotizacion['coc_id_acg'], $cotizacion['coc_id_psp'], $cotizacion['coc_id_ace'],true):'<option value=""></option>';
        $data['especifica']         = $slc_especifica;
        $proyectos_reg              = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
        $select_proyecto            = '<option value=""></option>';
        foreach ($proyectos_reg as $key) {
            $selected = ($cotizacion['coc_id_pcl'] == $key['pcl_id'])?'selected':'';
            $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
            $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
            $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
        }
        $data['proyectos']          = $select_proyecto;
        $condiciones_drop           = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), $cotizacion['coc_id_cod'], null, null, true);
        $data['condiciones']        = str_replace('<option value="0">Seleccione</option>', '', $condiciones_drop);    
        $tipo_pago_drop             = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), $cotizacion['coc_id_tpg'], null, null, true);
        $data['tipo_pago']          = str_replace('<option value="0">Seleccione</option>', '', $tipo_pago_drop);            
        $data['proveedores']        = $options;
        $data['gastos']             = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));
        $data['cotizacion']         = $cotizacion;
        $data['detalle_cotizacion'] = $this->compras_model->get_detalle_cotizacion(array('dco_id_coc' => $coc_id));
        //anexos
        $data['anexos_cot'] = $this->gsatelite->get_tabla('ant_anexo_cotizacion_compra', array('ant_id_coc' => $coc_id));
        $data['titulo_personal']    = "Agregar Cotización";
        $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
        $this->_cargarvista($data);
    }

    public function anexos_cotizacion($coc_id) {
        try {
            $crud = new grocery_CRUD;
            $add = array(
                'ant_id_coc',
                'ant_nombre',
                'ant_url',
                'ant_estado',
                'ant_usu_creacion',
                'ant_fecha_creacion',
                'ant_usu_modificacion',
                'ant_fecha_modificacion'
            );
            $edit = array(
                'ant_id_coc',
                'ant_nombre',
                'ant_url',
                'ant_estado',
                'ant_usu_modificacion',
                'ant_fecha_modificacion'
            );
            $required = array(
                'ant_id_coc',
                'ant_nombre',
                'ant_url',
                'ant_estado',
                'ant_usu_modificacion',
                'ant_fecha_modificacion'
            );
            $alias = array(
                'ant_nombre' => 'Nombre',
                'ant_url' => 'Anexo',
                'ant_estado' => 'Estado'
            );

            $columns = array(
                'ant_nombre',
                'ant_url',
                'ant_estado'
            );

            $crud->set_table('ant_anexo_cotizacion_compra')
            ->set_subject('Anexo')
            ->add_fields($add)
            ->edit_fields($edit)
            ->columns($columns)
            ->display_as($alias)
            ->field_type('ant_id_coc', 'hidden', $coc_id)
            ->required_fields($required)
            ->set_field_upload('ant_url', 'uploads/anx_cotizacion', 'Anexo')
            ->field_type('ant_fecha_modificacion', 'hidden', date('Y-m-d H-i-s'))
            ->field_type('ant_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->where('ant_id_coc', $coc_id)
            ;

            $crud->callback_before_upload(array($this, 'callback_before_upload_document'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ant_estado', 'hidden', 1)
                ->field_type('ant_fecha_creacion', 'hidden', date('Y-m-d H-i-s'))
                ->field_type('ant_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ;
            } else {
                $crud->field_type('ant_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $output = $crud->render();
            $cotizacion = $this->compras_model->get_cotizaciones(array('coc_id' => $coc_id));

            $data['cotizacion'] = $cotizacion[0];

            $data['titulo_personal'] = "Anexos de Cotización";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * ====================
     * CALLBACKS
     * ===================
     * */

    /**
     * files_to_upload = información del archivo
     * field_info = información del path
     */
    function callback_before_upload_document($files_to_upload, $field_info) {

        $encrypted_name = $field_info->encrypted_field_name;

        $search = array("(", ")");

        //$files_to_upload[$encrypted_name]['name'] = str_replace($search, "_", $files_to_upload[$encrypted_name]['name']);

        if (strpos($files_to_upload[$encrypted_name]['name'], '(') || strpos($files_to_upload[$encrypted_name]['name'], ')') || strpos($files_to_upload[$encrypted_name]['name'], '&') || strpos($files_to_upload[$encrypted_name]['name'], '!') || strpos($files_to_upload[$encrypted_name]['name'], '%') || strpos($files_to_upload[$encrypted_name]['name'], '=') || strpos($files_to_upload[$encrypted_name]['name'], '$')) {

            return 'Elimine caracteres especiales en el nombre del archivo';
        } else {
            return true;
        }
    }

    public function estado_cotizacion($coc_id = null, $iframe = null, $ver = null) {

        if ($this->input->post()) {
            $post_array = $this->input->post();
            $slcEstado = $post_array['slcEstado'];
            $txtComentario = $post_array['txtComentario'];
            $id_rxi = $post_array['id_rxi'];

            $usuario_aprueba = null;
            $usuario_anula = null;
            $comentario_aprueba = null;
            $comentario_anula = null;
            $fecha_aprueba = null;
            $fecha_anula = null;

            //Si el estado es 2, se aprobo la cotizacion
            if ($slcEstado == 2) {
                $usuario_aprueba = $this->tank_auth->get_user_id();
                $comentario_aprueba = $txtComentario;
                $fecha_aprueba = date('Y-m-d H:i:s');

                // Se colocan como rechazadas las restantes pertenecientes a la misma requisición
                $actualizar_coc = array(
                    'coc_id_usu_rechaza'=>$usuario_aprueba,
                    'coc_fecha_rechaza' =>$fecha_aprueba,
                    'coc_estado' => 3, //Rechazada
                    'coc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'coc_fecha_modificacion'=>date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('coc_cotizacion_compra', $actualizar_coc, array('coc_id_rxi' => $id_rxi));
            } else {
                $usuario_anula = $this->tank_auth->get_user_id();
                $comentario_anula = $txtComentario;
                $fecha_anula = date('Y-m-d H:i:s');
            }

            $cotizacion_array = array(
                'coc_id_usu_aprueba' => $usuario_aprueba,
                'coc_id_usu_rechaza' => $usuario_anula,
                'coc_observacion_aprueba' => $comentario_aprueba,
                'coc_observacion_rechazo' => $comentario_anula,
                'coc_fecha_aprueba' => $fecha_aprueba,
                'coc_fecha_rechaza' => $fecha_anula,
                'coc_estado' => $slcEstado,
                'coc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'coc_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->actualizar_array('coc_cotizacion_compra', $cotizacion_array, array('coc_id' => $coc_id));

            $estado = ($slcEstado == 2) ? "Autorizada" : "Anulada";

            $num_cotizacion = $this->gsatelite->get_campo('coc_cotizacion_compra', 'coc_numero', array('coc_id' => $coc_id));

            $data['ver'] = $ver;

            if ($resultado > 0) {
                if ($iframe == 1) {
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotización #" . $num_cotizacion . " " . $estado, 'texto_alerta' => "El proceso se realizó correctamente.");
                } else {
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotización #" . $num_cotizacion . " " . $estado, 'texto_alerta' => "El proceso se realizó correctamente.");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
        }

        $permiso_compra = false;
        $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
        $permisos_array = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
        if ( count($permisos_array) > 0 ) {
            $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
            foreach ($roles as $role) {
                if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                    $permiso_compra = true;
                }
            }
        }
        $data["permiso_compra"]     = $permiso_compra;  

        $data['titulo_personal']    = "Estado Cotizaciones";
        $cotizacion                 = $this->compras_model->get_cotizaciones(array('coc_id' => $coc_id));
        $data['detalle_cotizacion'] = $this->compras_model->get_detalle_cotizacion(array('dco_id_coc' => $coc_id));
        $data['cotizacion']         = $cotizacion[0];
        $data['id_rxi']             = $cotizacion[0]['coc_id_rxi'];
        $data['iframe']             = $iframe;
        $data['ver']                = $ver;
        $data['anexos_cot']         = $this->gsatelite->get_tabla('ant_anexo_cotizacion_compra', array('ant_id_coc' => $coc_id));
        $slc_presupuesto            = ($cotizacion[0]['coc_id_psp'] != "" && $cotizacion[0]['coc_id_pcl'] != "")?$this->get_presupuestoxproyecto($cotizacion[0]['coc_id_pcl'], $cotizacion[0]['coc_id_psp']):'<option value=""></option>';
        $data['presupuesto']        = $slc_presupuesto;
        $slc_general                = ($cotizacion[0]['coc_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($cotizacion[0]['coc_id_psp'], $cotizacion[0]['coc_id_acg']):'<option value=""></option>';
        $data['general']            = $slc_general;
        $slc_especifica             = ($cotizacion[0]['coc_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($cotizacion[0]['coc_id_acg'], $cotizacion[0]['coc_id_psp'], $cotizacion[0]['coc_id_ace']):'<option value=""></option>';
        $data['especifica']         = $slc_especifica;
        $proyectos_reg              = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
        $select_proyecto            = '<option value=""></option>';
        foreach ($proyectos_reg as $key) {
            $selected = ($cotizacion[0]['coc_id_pcl'] == $key['pcl_id'])?'selected':'';
            $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
            $nombre = $key['pcl_codigo'] . ' - ' . $nombre_cliente;
            $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
        }
        $data['proyectos']          = $select_proyecto;
        if ($iframe == 1) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/estado_cotizacion', $data);
        } else {
            $this->_cargarvista($data);
        }
    }

    public function get_detalle_requisicion($rxi_id = null, $flag = null) {
        $idRequisicion = ($rxi_id != null) ? $rxi_id : $this->input->post('requisicion');
        $dataRequisicion = array();
        $requisicion = $this->compras_model->get_reporte_requisiciones(array('rxi_id' => $idRequisicion));

        $dataRequisicion['req'] = array(
            'numero' => $requisicion[0]['rxi_numero'],
            'tipo' => $requisicion[0]['rxi_tipo'],
        );

        $detalleRequisicion = $this->compras_model->get_detalle_requisicion(array('dri_id_rxi' => $idRequisicion));

        $gastos = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));
        $gastos_html = "";
        foreach ($gastos as $value) {
            $gastos_html .= "<option data-porcentaje='" . $value['gst_porcentaje'] . "' value='" . $value['gst_id'] . "'>" . $value['gst_nombre'] . "</option>";
        }


        foreach ($detalleRequisicion as $row) {
            $producto_id = null;
            $producto = null;
            $producto_codigo = null;
            $categoria = null;
            $categoria_id = null;
            $conversion = null;
            $medida = null;
            $impuestos_html = "";

            switch ($requisicion[0]['rxi_tipo']) {
                case 1:
                $producto_id = $row['dri_id_art'];
                $producto = $row['art_nombre'];
                $producto_codigo = $row['art_codigo'];
                $categoria = $row['tia_nombre'];
                $categoria_id = $row['tia_id'];
                $conversion = $row['cva_id'];
                $medida = $row['mep_nombre'];

                $where_imp = array('ixr_id_tia' => $categoria_id, 'imp_estado' => 1, 'IFNULL(imp_proceso_aplica,0) <>' => 1);
                $impuestos_array = $this->inventario_model->get_impuestos_categoria($where_imp);
                $etiqueta = 0;
                if (count($impuestos_array) > 0) {
                    foreach ($impuestos_array as $imp) {
                        $impuestos_html .= "<option selected data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "' id='opt_ixa" . $etiqueta . "'>" . $imp['imp_nombre'] . "</option>";

                        $etiqueta++;
                    }
                }
                $impuestos_colum = array_column($impuestos_array,"imp_id");
                $impuestos_ids = implode(",",$impuestos_colum);
                break;
                case 2:
                $producto_id = $row['dri_id_art'];
                $producto = $row['art_nombre'];
                $producto_codigo = $row['art_codigo'];
                $categoria = $row['tia_nombre'];
                $categoria_id = $row['tia_id'];
                $where_imp = array('ixr_id_tia' => $categoria_id);
                $impuestos_array = $this->inventario_model->get_impuestos_categoria($where_imp);
                $etiqueta = 0;
                if (count($impuestos_array) > 0) {
                    foreach ($impuestos_array as $imp) {

                        $impuestos_html .= "<option selected data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "' id='opt_ixa" . $etiqueta . "'>" . $imp['imp_nombre'] . "</option>";

                        $etiqueta++;
                    }
                }
                $impuestos_colum = array_column($impuestos_array,"imp_id");
                $impuestos_ids = implode(",",$impuestos_colum);
                break;
                case 3:
                $producto_id = $row['dri_id_act'];
                $producto = $row['act_nombre'];
                $producto_codigo = $row['art_codigo'];
                $categoria = $row['tac_nombre'];

                $impuestos_array = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
                $etiqueta = 0;
                if (count($impuestos_array) > 0) {
                    foreach ($impuestos_array as $imp) {
                        $impuestos_html .= "<option selected data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "' id='opt_ixa" . $etiqueta . "'>" . $imp['imp_nombre'] . "</option>";
                        $etiqueta++;
                    }
                }
                $impuestos_colum = array_column($impuestos_array,"imp_id");
                $impuestos_ids = implode(",",$impuestos_colum);
                break;

                case 4:
                $etiqueta = 0;
                $producto_id = $row['dri_id_art'];
                $producto = $row['art_nombre'];
                $producto_codigo = $row['art_codigo'];
                $medida = ($row['mep_nombre']!='') ? $row['mep_nombre'] : '-----';
                $categoria = $row['tia_nombre'];
                $categoria_id = $row['tia_id'];
                $conversion = $row['cva_id'];
                $where_imp = array('ixr_id_tia' => $categoria_id);
                $impuestos_array = $this->inventario_model->get_impuestos_categoria($where_imp);
                if (count($impuestos_array) > 0) {
                    foreach ($impuestos_array as $imp) {
                        $impuestos_html .= "<option data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "' id='opt_ixa" . $etiqueta . "'>" . $imp['imp_nombre'] . "</option>";
                        $etiqueta++;
                    }
                }
                $impuestos_colum = array_column($impuestos_array,"imp_id");
                $impuestos_ids = implode(",",$impuestos_colum);
                break;
            }


            $dataRequisicion['detalle'][] = array(
                'prd' => $producto_id,
                'producto' => $producto,
                'producto_codigo' => $producto_codigo,
                'conversion' => $conversion,
                'categoria' => $categoria,
                'medida' => $medida,
                'cantidad' => $row['dri_cantidad'],
                'precio' => 0,
                'descuento' => 0,
                'impuestos_html' => $impuestos_html,
                'gastos_html' => $gastos_html,
                'ids_imp' => $impuestos_ids
            );
        }
        if ($flag) {
            return $dataRequisicion;
        }

        echo json_encode($dataRequisicion);
    }

    public function get_detalle_prorrateo($ptg_id = null, $flag = null) {

        $idProrrateo = ($ptg_id != null) ? $ptg_id : $this->input->post('prorrateo');

        $dataProrrateo = array();

        $detalleProrrateo = $this->compras_model->obtener_detalleprorrateo($idProrrateo);

        $opciones = "<option></option>";

        foreach ($detalleProrrateo as $row) {
            $opciones .= '<option id="' . $row['cec_id'] . '" data-porcentaje="' . $row['dpr_porcentaje'] . '" data-cuenta="1" value="' . $row['dpr_id'] . '">' . $row['cec_nombre'] . '</option>';
        }

        $dataProrrateo['opciones'] = $opciones;

        if ($flag) {
            return $flag;
        }

        echo json_encode($dataProrrateo);
    }

    public function generar_doc_pendiente($dpv_id = null, $tipo_doc = null, $iframe = null) {

        $documento = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
        if ($_POST) {
            $post_array = $_POST;

            $txtComentario = $post_array['txtComentario'];

            $nombreProveedor = $documento[0]['prv_apellido'];
            //Se valida el tipo de personeria
            if ($documento[0]['prv_tipo_pers'] == 1) {
                $nombreProveedor = $documento[0]['prv_nombre']. ' ' . $documento[0]['prv_apellido'];
            }

            $cheque_array = array(
                'chp_id_usu_genera' => $this->tank_auth->get_user_id(),
                'chp_id_dpv' => $dpv_id,
                'chp_monto' => $documento[0]['dpv_total'],
                'chp_orden' => $nombreProveedor,
                'chp_concepto' => $documento[0][''],
                'chp_observacion' => $txtComentario,
                'chp_fecha' => date('Y-m-d H:i:s'),
                'chp_generado' => 0,
                'chp_estado' => 1,
                'chp_usu_creacion' => $this->tank_auth->get_user_id(),
                'chp_fecha_creacion' => date('Y-m-d H:i:s'),
                'chp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'chp_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->ingresar('chp_cheque_pendiente', $cheque_array);

            if ($resultado > 0) {
                if ($iframe == 1) {
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cheque Pendiente Generado" . $estado, 'texto_alerta' => "El proceso se realizó correctamente.");
                } else {
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cheque Pendiente Generado" . $estado, 'texto_alerta' => "El proceso se realizó correctamente.");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
        }

        $data['titulo_personal'] = "Cheque/Nota de Abono";

        $data['documento'] = $documento[0];
        $data['tipo_doc'] = $tipo_doc;
        $data['iframe'] = $iframe;
        if ($iframe == 1) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/generar_doc_pendiente', $data);
        } else {
            $this->_cargarvista($data);
        }
    }

    public function get_codigo_contrato() {
        $codigoNew = $this->input->post('codigoNew');
        $result = $this->gsatelite->get_campo('cop_contrato_proveedor', 'cop_id', array('cop_codigo' => $codigoNew));
        echo json_encode($result);
    }

    public function get_monto_dpv() {
        satelite_validar();
        $idDocumento = $this->input->post('documento');
        //Si existe el parametro documento solo verifica la existencia.
        if ($idDocumento > 0) {
            $total = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_subtotal', array('dpv_id' => $idDocumento));
        }
        echo json_encode($total);
    }

    public function get_cen_cos_aso_catprod() {
        $art_id = $this->input->post('idprod');
        //$art_id_tia = $this->input->post('idcec');
        $dta_id_cec = $this->input->post('idcec');
        $where = array('art_id' => $art_id, 'dta_id_cec' => $dta_id_cec);
        $result = $this->compras_model->get_cen_cos_aso_catprod($where);
        if ($result) {
            $res = true;
        } else {
            $res = false;
        }

        $dta_id_cnt = $result[0]['dta_id_cnt'];

        $cco_nombre = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $dta_id_cnt));

        echo json_encode(array('estado' => $res, 'cnt_nombre' => $cco_nombre[0]['cnt_nombre'], 'cnt_id' => $cco_nombre[0]['cnt_id']));
        //print_r($this->input->post('id'));
        //echo 'hola';
        //echo json_encode($total);
    }

   /**
     * @author Edith Herrera
     * @since  05/09/2017
     * @return Grid para la gestión de liquidaciones de caja chica.
     */
   public function periodo_caja_chica() {
    satelite_validar();
    $data['permisos']           = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/periodo_caja_chica');
    $data['permisos_proveedor'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/documentos_proveedor','agregar',null,true);

    if ($_POST) {
        $post_array = $_POST;
        $caja           = $post_array['caja'];
        $fecha_inicio   = $post_array['fecha_ini'];
        $fecha_fin      = $post_array['fecha_fin'];
        $estado         = $post_array['estado'];
        $where          = null;

        if ($caja>0) {
            $where['lcc_id_cch'] = $caja;
        }
        if ($estado > 0) {
            if ($estado > 1) {
                $where['lcc_corte'] = 0;
            } else {
                $where['lcc_corte'] = 1;
            }
        }
        if ($fecha_inicio != '' && $fecha_fin != '') {
            $where['lcc_fecha_inicio >='] = date('Y-m-d', strtotime($fecha_inicio));
            $where['lcc_fecha_inicio <='] = date('Y-m-d', strtotime($fecha_fin));
        }
        $data['liquidacion'] = $periodos = $this->compras_model->get_periodo_caja($where);
        $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $html = $this->load->view('modulo_compras/procesos/consultar_periodo_caja_chica', $data, true);
        echo $html;
    } else {
        $autorizar_str      = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
        $autorizar_array    = explode(",",$autorizar_str);
        $roles_array        = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()));
        $autorizar          = false;
        foreach ($roles_array as $rol) {
            if (in_array($rol["uxr_id_rol"], $autorizar_array)) {
                $autorizar = true;
            }
        }
        $data['liquidacion']= $liquidacion = $this->gsatelite->get_tabla('lcc_liquidacion_caja_chica', array('lcc_estado' => 1, 'lcc_corte' => 0));
        $cajas_arr = array();
        if(count($liquidacion)>0){
            foreach ($liquidacion as $caj) {
                $cajas_arr[] = $caj['lcc_id_cch'];
            }
        }
        if ($autorizar == false) { 
            $reg_usu = $this->gsatelite->get_tabla('users',array('id'=>$this->tank_auth->get_user_id()));
            $this->db->where( "cch_id_emp", $reg_usu[0]['usu_id_emp']); 
        }
        $data['cajas_chicas'] =  $cajas = $this->gsatelite->get_dropdown('cch_caja_chica', '{cch_nombre}', 'caja_chica', array('cch_estado' => 1), null, null, 'cch_id', true);
        if ($autorizar == false) {$reg_usu = $this->gsatelite->get_tabla('users',array('id'=>$this->tank_auth->get_user_id())); $this->db->where( "cch_id_emp", $reg_usu[0]['usu_id_emp']);}
        if(count($cajas_arr) > 0){ $this->db->where_not_in('cch_id', $cajas_arr); }
        $data['disponibles']    = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado' => 1));        
        $data['titulo_personal']= 'Liquidación de caja chica';
        $this->_cargarvista($data);
    }
}

     /**
     * @author Edith Herrera
     * @since  05/09/2017
     * @return Formulario para agregar la liquidaci[on de caja chica.
     **/
    public function agregar_liquidacion() {
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;
            $caja = $post_array['slcCaja'];
            $fecha = formatear_fecha('Y-m-d', $post_array['txtFechaLiq']);
            $disponible = $post_array['txtMontoDisp'];
            $this->db->where('lcc_id_cch', $caja);
            $max_lcc = $this->db->select_max('lcc_id')->from('lcc_liquidacion_caja_chica')->get()->row();
            $remanente = $this->gsatelite->get_campo('lcc_liquidacion_caja_chica','lcc_disponible', array('lcc_id'=>$max_lcc->lcc_id, 'lcc_id_cch'=>$caja));
            $rem = ($remanente > 0) ? $remanente : 0;
            // $rem += ()?: $disponible;
            $array_liquidacion= array(
                'lcc_id_cch' => $caja,
                'lcc_fecha_inicio' => $fecha,
                'lcc_remanente' => $rem,
                'lcc_asignado' => $rem,
                'lcc_disponible' => $rem,
                'lcc_corte' => 0,
                'lcc_estado' => 1,
                'lcc_usu_creacion' => $this->tank_auth->get_user_id(),
                'lcc_fecha_creacion' => date('Y-m-d H:i:s'),
                'lcc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'lcc_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $ingreso = $this->gsatelite->ingresar('lcc_liquidacion_caja_chica', $array_liquidacion);
            if ($ingreso > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Liquidación de caja chica", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Liquidación de caja chica", 'texto_alerta' => "Ocurrió un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);
            redirect('modulo_compras/procesos/periodo_caja_chica');
        } else {
            $autorizar_str      = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
            $autorizar_array    = explode(",",$autorizar_str);
            $roles_array        = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
            $autorizar          = false;
            foreach ($roles_array as $rol) {
                if (in_array($rol["uxr_id_rol"], $autorizar_array)) {
                    $autorizar = true;
                }
            }   
                             $this->db->join('lcc_liquidacion_caja_chica', 'lcc_id_cch = cch_id AND lcc_corte = 0', 'inner');
            $cajas_activas = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado'=>1));
            $cajas_act=array();
            if(count($cajas_activas)>0){
                foreach ($cajas_activas as $caja) {
                    $cajas_act[] = $caja['cch_id'];
                }
            }
            if ( $autorizar == false) { 
                $empleado = $this->gsatelite->get_campo("users", 'usu_id_emp', array("id" => $this->tank_auth->get_user_id()));
                $this->db->where( "cch_id_emp", $empleado); 
            }
            if(count($cajas_act) > 0){
                $this->db->where_not_in('cch_id', $cajas_act);
            }   
            $data['cajas_chicas'] = $this->gsatelite->get_dropdown('cch_caja_chica', '{cch_nombre}', 'caja_chica', array('cch_estado' => 1), null, null, null, true);
            $data['titulo_personal'] = 'Liquidación de caja chica';
            $this->_cargarvista($data);
        }
    }

    public function get_monto_disponible($lcc_id=null, $che_id=null, $flag=null, $caja_id=null, $tipo=null){
        satelite_validar();
        $caja = ($caja_id) ? $caja_id : $this->input->post('caja');
        $lcc_id = ($lcc_id) ? $lcc_id : $this->input->post('lcc');
        $cheque = ($che_id) ? $che_id : $this->input->post('cheque');
        $tipo = ($tipo) ? $tipo : $this->input->post('tipo'); // Si viene del formulario de agregar o editar reintegro.
        $primerCheque = str_replace(',', '', $this->input->post('primerCheque'));
        $verificar = ($this->input->post('vMonto'))?$this->input->post('vMonto') : null;
        if($lcc_id <= 0){
            $lcc_id= $this->gsatelite->get_max('lcc_liquidacion_caja_chica', 'lcc_id', array('lcc_estado'=>1, 'lcc_id_cch'=>$caja));
        }
        // $lcc_id= $this->gsatelite->get_max('lcc_liquidacion_caja_chica', 'lcc_id', array('lcc_corte'=>1, 'lcc_estado'=>1));
        $disponible = $this->compras_model->get_disponible(array('lcc_id'=>$lcc_id, 'lcc_corte'=>0, 'lcc_id_cch'=>$caja));
        if(count($disponible)<=0){
            $disponible = $this->compras_model->get_disponible(array('lcc_id'=>$lcc_id, 'lcc_corte'=>1, 'lcc_id_cch'=>$caja));
        }
        $cheques = $this->compras_model->get_cheques(array('che_id'=>$cheque));
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $monto_disp = (count($disponible) > 0) ? number_format($disponible[0]['lcc_disponible'], $decimales, '.', '') : number_format(0, $decimales, '.', '');
        $this->db->select_sum('cqc_total');
        $monto_asig = $this->db->from('cqc_comprobante_liquidacion_caja')->where('cqc_id_lcc', $lcc_id)->get()->row();
        $monto_final=0;
        $asignado = 0;
        if(count($cheques)>0){
            $monto_che = str_replace(',','', $cheques[0]['che_monto']);
            if($tipo==1){ // Formulario de agregar reintegro.
                $monto_final = (float)$monto_che + (float) $disponible[0]['lcc_asignado'];
                $asignado = ($disponible[0]['lcc_asignado'])+$monto_che;
            }else{ // Formulario de editar reintegro.
                $monto_final = ((float) $disponible[0]['lcc_asignado'] - (float)str_replace(',','', $primerCheque )) + (float)$monto_che;
                $asignado =  ($disponible[0]['lcc_asignado']-$primerCheque)+$monto_che;
            }
            $che_monto = number_format($monto_che, $decimales, '.', '');
        }else{
            $che_monto = 0;
        }
        if($primerCheque>0){
            $monto_disp = ($disponible[0]['lcc_asignado'] - $primerCheque - $monto_asig->cqc_total) + $monto_che;
        }
        if($monto_asig->cqc_total<$monto_disp){
            $monto_req = (float)str_replace(',','', $monto_disp) - (float)str_replace(',','', $monto_asig->cqc_total);
        }else{
            $monto_req = (float)$monto_asig->cqc_total;
        }
        if($flag!=null){
            return array('monto'=>$monto_disp, 'che_monto'=>$che_monto, 'decimales'=>$decimales, 'asignado'=>$asignado);
        }else{
            if($verificar<=0){
                echo json_encode(array('monto'=>$monto_disp, 'che_monto'=>$che_monto, 'decimales'=>$decimales, 'asignado'=>$asignado));
                die();
            }else{
                if((float)$monto_final >= (float)$monto_req){
                    echo json_encode(array('monto'=>$monto_disp, 'che_monto'=>$che_monto, 'flag'=>1, 'decimales'=>$decimales, 'asignado'=>$asignado));
                    die();
                }else{
                    echo json_encode(array('monto'=>$monto_disp, 'che_monto'=>$che_monto, 'flag'=>0, 'decimales'=>$decimales, 'asignado'=>$asignado));
                    die();
                }
            }
        }

    }

    public function get_monto_nota_disponible($lcc_id=null, $nta_id=null, $flag=null, $caja_id=null, $tipo=null){
        satelite_validar();
        $tipo = ($tipo) ? $tipo : $this->input->post('tipo'); // Si viene del formulario de agregar o editar reintegro.
        $caja = ($caja_id) ? $caja_id : $this->input->post('caja');
        $lcc_id = ($lcc_id) ? $lcc_id : $this->input->post('lcc');
        $transf = ($nta_id) ? $che_id : $this->input->post('nota');
        $primerCheque = str_replace(',', '', $this->input->post('primerCheque'));
        $verificar = ($this->input->post('vMonto'))?$this->input->post('vMonto') : null;
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        if($lcc_id <= 0){
            $lcc_id= $this->gsatelite->get_max('lcc_liquidacion_caja_chica', 'lcc_id', array('lcc_estado'=>1, 'lcc_id_cch'=>$caja));
        }
        $disponible = $this->compras_model->get_disponible(array('lcc_id'=>$lcc_id, 'lcc_corte'=>0, 'lcc_id_cch'=>$caja));
        if(count($disponible)<=0){
            $disponible = $this->compras_model->get_disponible(array('lcc_id'=>$lcc_id, 'lcc_corte'=>1, 'lcc_id_cch'=>$caja));
        }
        $monto_disp = (count($disponible) > 0) ? number_format($disponible[0]['lcc_disponible'], $decimales, '.', '') : number_format(0, $decimales, '.', '');
                      $this->db->select_sum('cqc_total');
        $monto_asig = $this->db->from('cqc_comprobante_liquidacion_caja')->where('cqc_id_lcc', $lcc_id)->get()->row();
        $asignado = 0;
        $monto_nta = 0;
        $monto_final = 0;
        // ["nota"]=> "1" ["caja"]=>  "1" ["lcc"]=>  "1" ["vMonto"]=>  "1" ["primerCheque"]=>  "0" ["tipo"]=>  "1" }
                       $this->db->join('tra_transaccion', 'tra_id = nta_id_tra');
        $notas_abono = $this->gsatelite->get_tabla('nta_nota_abono', array('nta_estado'=>1,'tra_aplicar'=>1,'nta_id' => $transf));
        if(count($notas_abono) > 0){
            $monto_nta = str_replace(',','', $notas_abono[0]['nta_monto']);
            if($tipo == 1){
                // Formulario de agregar reintegro.
                $monto_final = (float)$monto_nta + (float)$disponible[0]['lcc_asignado'];
                $asignado = (float)$disponible[0]['lcc_asignado'] + (float)$monto_nta;
            }else{
                // Formulario de editar reintegro.
                $monto_final = ((float) $disponible[0]['lcc_asignado'] - (float)str_replace(',','', $primerCheque )) + (float)$monto_nta;
                $asignado =  ($disponible[0]['lcc_asignado']-$primerCheque)+$monto_nta;
            }
            $nta_monto = number_format($monto_nta, $decimales, '.', '');
        }else{
            $nta_monto = 0;
        }
        if($primerCheque>0){
            $monto_disp = ($disponible[0]['lcc_asignado'] - $primerCheque - $monto_asig->cqc_total) + $monto_nta;
        }
        if($monto_asig->cqc_total<$monto_disp){
            $monto_req = (float)str_replace(',','', $monto_disp) - (float)str_replace(',','', $monto_asig->cqc_total);
        }else{
            $monto_req = (float)$monto_asig->cqc_total;
        }
        if($flag != null){
            return array('monto'=>$monto_disp, 'nta_monto'=>$nta_monto, 'decimales'=>$decimales, 'asignado'=>$asignado);
        }else{
            if($verificar<=0){
                echo json_encode(array('monto'=>$monto_disp, 'nta_monto'=>$che_monto, 'decimales'=>$decimales, 'asignado'=>$asignado));
                die();
            }else{
                if((float)$monto_final >= (float)$monto_req){
                    echo json_encode(array('monto'=>$monto_disp, 'nta_monto'=>$nta_monto, 'flag'=>1, 'decimales'=>$decimales, 'asignado'=>$asignado));
                    die();
                }else{
                    echo json_encode(array('monto'=>$monto_disp, 'nta_monto'=>$nta_monto, 'flag'=>0, 'decimales'=>$decimales, 'asignado'=>$asignado));
                    die();
                }
            }
        }

    }

     /**
     * @author Edith Herrera
     * @since  5/09/2017
     * @return Formulario de edición de liquidaciones de caja chica.
     **/
     public function editar_liquidacion($lcc_id=null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;
            $lcc_id = $post_array['lcc_id'];

            $fecha = $post_array['txtFechaLiq'];
            $fecha_liq= formatear_fecha('Y-m-d', $post_array['txtFechaLiq']);


             // Se actualiza el registro del periodo para liquidación.
            $array_periodo= array(
                'lcc_fecha_inicio'=>$fecha_liq,
                'lcc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'lcc_fecha_modificacion'=>date('Y-m-d H:i:s')
            );

            // Se actualiza el periodo de caja chica.
            $actualizar=$this->gsatelite->actualizar_array('lcc_liquidacion_caja_chica', $array_periodo, array('lcc_id'=>$lcc_id));

            if($actualizar>0){
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Períodos para liquidación", 'texto_alerta' => "El registro se actualizó correctamente");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Períodos para liquidación", 'texto_alerta' => "Ocurrió un problema al actualizar el registro.");
            }

            $this->session->set_flashdata($alerta);
            redirect('modulo_compras/procesos/periodo_caja_chica');
        } else {
            $where = array('lcc_id'=>$lcc_id);
            $liquidacion = $this->compras_model->get_periodo_caja($where);
            $data['liquidacion'] = $liquidacion[0];

            $data['cajas_chicas'] = $this->gsatelite->get_dropdown('cch_caja_chica', '{cch_nombre}', 'caja_chica', array('cch_estado' => 1, 'cch_id'=>$liquidacion[0]['lcc_id_cch']), $liquidacion[0]['lcc_id_cch'], null, 'cch_id', true);
            $data['lcc_id']= $lcc_id;

            $disponible = $this->compras_model->get_disponible(array('lcc_id_cch'=>$liquidacion[0]['lcc_id_cch'], 'lcc_corte'=>0));

            $disp = ($disponible[0]['lcc_disponible'] != '') ? $disponible[0]['lcc_disponible'] : 0;
            $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') != '')? $this->gsatelite->get_parametro('NUMERO_DECIMALES')  : 2;
            $data['monto'] = number_format($disp, $decimales, '.', ',');

            $data['titulo_personal'] = 'Editar liquidación de caja chica';
            $this->_cargarvista($data);
        }
    }

     /**
     * @author Edith Herrera
     * @since  07/09/2017
     * @return Registro de comprobantes liquidados por caja chica.
     */
     function agregar_comp_caja_chica($lcc_id=null) {
        satelite_validar();
        if($_POST){
            $post_array=$this->input->post();
            $proveedor      = ($post_array['proveedor']>0)?$post_array['proveedor']:null;
            $tipo_venta     = ($post_array['tipo_venta']>0)?$post_array['tipo_venta']:null;
            $tipo_documento = ($post_array['tipo_documento']>0)?$post_array['tipo_documento']:null;
            $numero_doc     = ($post_array['numero_doc']!='')?$post_array['numero_doc']:null;
            $nrc            = ($post_array['nrc']!='')?$post_array['nrc']:null;
            $concepto       = ($post_array['concepto']!='')?$post_array['concepto']:null;
            $total_fecha    = ($post_array['TotalFechaDoc']!='')?$post_array['TotalFechaDoc']:null;
            $fecha_conta    = ($post_array['TotalFechaConta']!='')?$post_array['TotalFechaConta']:null;
            $tipo_monto     = ($post_array['tipo_monto']!='')?$post_array['tipo_monto']:null;
            $total_imp      = ($post_array['TotalImpuesto']!='')?$post_array['TotalImpuesto']:null;
            $total_ret      = ($post_array['TotalRetencion']!='')?$post_array['TotalRetencion']:null;
            $total_monto    = ($post_array['TotalMonto']!='')?$post_array['TotalMonto']:null;
            $monto          = ($post_array['monto']!='')?$post_array['monto']:null;
            $impuesto       = $post_array['impuestos'];
            $retencion      = $post_array['retenciones'];
            $lcc_id         = $post_array['id_lcc'];
            $total_cantidad = ($post_array['TotalCantidad']!='') ? $post_array['TotalCantidad'] : 1;
            $decimal = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):null;
            $disp =str_replace(',', '', $post_array['txtDisponible']);

            $idsCqc         = $post_array['id_cqc'];

            $comprobantes_bd = $this->gsatelite->get_tabla('cqc_comprobante_liquidacion_caja', array('cqc_id_lcc'=>$lcc_id));

            foreach ($proveedor as $key => $value) {
                $array_comp = array(
                    'cqc_id_prv'=>$value,
                    'cqc_id_tpv'=>$tipo_venta[$key],
                    'cqc_id_tif'=>$tipo_documento[$key],
                    'cqc_id_lcc'=>$post_array['id_lcc'],
                    'cqc_numero_documento'=>$numero_doc[$key],
                    'cqc_nrc'=>$nrc[$key],
                    'cqc_concepto'=>$concepto[$key],
                    'cqc_fecha_documento'=>formatear_fecha('Y-m-d',$total_fecha[$key]),
                    'cqc_fecha_contabilizacion'=>formatear_fecha('Y-m-d',$fecha_conta[$key]),
                    'cqc_tipo_monto'=>($tipo_monto[$key] != '')?$tipo_monto[$key]:null,
                    'cqc_impuesto'=>$total_imp[$key],
                    'cqc_retencion'=>$total_ret[$key],
                    'cqc_total'=>$total_monto[$key],
                    'cqc_monto'=>$monto[$key],
                    'cqc_cantidad'=>$total_cantidad[$key],
                    'cqc_estado'=>1,
                    'cqc_usu_creacion'=>$this->tank_auth->get_user_id(),
                    'cqc_fecha_creacion'=>date('Y-m-d H:i:s'),
                    'cqc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'cqc_fecha_modificacion'=>date('Y-m-d H:i:s')
                );

                $comp = $this->gsatelite->ingresar('cqc_comprobante_liquidacion_caja', $array_comp);

                /********************** INGRESO DE IMPUESTOS POR CADA COMPROBANTE *********************************/
                $subTotal = round(($monto[$key] * $total_cantidad[$key]),$decimal);
                
                $impuestos   = explode(',', $impuesto[$key]);
                $retenciones = explode(',', $retencion[$key]);

                if($impuesto[$key]!=''){

                    foreach ($impuestos as $imp) {
                        $ilc_monto_impuesto = 0;
                        $imp_data = $this->gsatelite->get_registro('imp_impuesto', array('imp_id'=>$imp));
                        if ($imp_data->imp_porcentaje > 0) {
                            $monto_imp = ((float)$subTotal*((float)$imp_data->imp_porcentaje/100));
                            $ilc_monto_impuesto = $imp_data->imp_porcentaje;
                        } else {
                            $monto_imp = ((float)$total_cantidad[$key]*(float)$imp_data->imp_valor);
                            $ilc_monto_impuesto = $imp_data->imp_valor;
                        }
                        
                        $array_imp = array(
                            'ilc_id_imp'=>$imp,
                            'ilc_id_cqc'=>$comp,
                            'ilc_porcentaje'=>$ilc_monto_impuesto,
                            'ilc_monto_impuesto'=>$monto_imp,
                            'ilc_estado'=>1,
                            'ilc_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'ilc_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'ilc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'ilc_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('ilc_impuesto_liquidacion_comprobante', $array_imp);
                    }
                }
                if($retencion[$key]!=''){
                    foreach ($retenciones as $ret) {
                        $ret_data = $this->gsatelite->get_registro('ret_retencion', array('ret_id'=>$ret));
                        $monto_ret = ((float)$subTotal*((float)$ret_data->ret_porcentaje/100));
                        $array_ret = array(
                            'rlc_id_ret'=>$ret,
                            'rlc_id_cqc'=>$comp,
                            'rlc_porcentaje'=>$ret_data->ret_porcentaje,
                            'rlc_monto_impuesto'=>$monto_ret,
                            'rlc_estado'=>1,
                            'rlc_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'rlc_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'rlc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'rlc_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rlc_retencion_liquidacion_comprobante', $array_ret);
                    }
                }

                /**************************************************************************************************/
            }

            $actualizar_lcc = array(
                'lcc_disponible' => number_format($disp, $decimal, '.', ''),
                'lcc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'lcc_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('lcc_liquidacion_caja_chica', $actualizar_lcc, array('lcc_id'=>$post_array['id_lcc']));


            /******************************** Eliminar comprobantes *****************************************/
            if (count($comprobantes_bd) > 0) {
                foreach ($comprobantes_bd as $row) {
                    if (!in_array($row['cqc_id'], $idsCqc)) {

                        $dpv_id                 = $this->gsatelite->get_campo("cqc_comprobante_liquidacion_caja", 'cqc_id_dpv', array("cqc_id" =>$row['cqc_id']) );

                        $dpv_documento_proveedor= $this->gsatelite->get_tabla("dpv_documento_proveedor",array("dpv_id" => $dpv_id ) );

                        $dpv_documento_proveedor_array = array(
                            'dpv_pagado'            => 0,
                            'dpv_monto_abono'       => 0,
                            'dpv_monto_pendiente'   => $dpv_documento_proveedor[0]['dpv_monto_abono'],
                            'dpv_id_cch'            => NULL,
                            'dpv_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dpv_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('dpv_documento_proveedor', $dpv_documento_proveedor_array , array('dpv_id'=> $dpv_id) );

                        $ilc_impuesto_liquidacion_comprobante_array = array(
                            'ilc_estado'                => 0,
                            'ilc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'ilc_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('ilc_impuesto_liquidacion_comprobante' , $ilc_impuesto_liquidacion_comprobante_array , array('ilc_id_cqc' => $row['cqc_id']) );

                        $rlc_retencion_liquidacion_comprobante_array = array(
                            'rlc_estado'                => 0,
                            'rlc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'rlc_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rlc_retencion_liquidacion_comprobante' , $rlc_retencion_liquidacion_comprobante_array , array('rlc_id_cqc' => $row['cqc_id']) );

                        $cqc_comprobante_liquidacion_caja_array = array(
                            'cqc_estado'                => 0,
                            'cqc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'cqc_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cqc_comprobante_liquidacion_caja' , $cqc_comprobante_liquidacion_caja_array , array('cqc_id' => $row['cqc_id']) );

                        $comp++;
                    }
                }
            }

            /************************************************************************************************/

            if ($comp>0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comprobantes para caja chica", 'texto_alerta' => "Los registros se ingresaron con éxito.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Comprobantes para caja chica", 'texto_alerta' => "Ocurrió un error al guardar la información.");
            }

            $this->session->set_flashdata($alerta);
            if($post_array['export']==1){
                redirect("modulo_compras/procesos/agregar_comp_caja_chica/".$lcc_id);
            }else{
                redirect('modulo_compras/procesos/periodo_caja_chica');
            }
        }else{
            $where = array('lcc_id'=>$lcc_id);
            $liquidacion = $this->compras_model->get_periodo_caja($where);

            $data['fecha'] = ($liquidacion[0]['lcc_fecha_inicio']) ? formatear_fecha('d-m-Y', $liquidacion[0]['lcc_fecha_inicio']) : '';
            $data['decimal'] = $decimal = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

            $data['caja_chica']  = $liquidacion[0]['cch_nombre'];
            $data['sobre_girar'] = $liquidacion[0]['cch_sobregirar'];
            $data['caja_id']     = $caja = $liquidacion[0]['cch_id'];
            $data['monto']       = number_format($liquidacion[0]['lcc_disponible'], $decimal, '.',',');
            $data['limite']      = number_format($liquidacion[0]['lcc_asignado'], $decimal, '.',',');
            $data['lcc_id']      = $lcc_id;

            $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', array('tif_estado' => 1,'tif_aplica_compra' => 1), null, null, null, true);
            $data['retenciones'] = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            $data['impuestos'] = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));

            $venta_defecto = $this->gsatelite->get_campo('tpv_tipo_venta', 'tpv_id', array('tpv_defecto'=>1));
            $data['tipo_venta'] = $this->gsatelite->get_dropdown('tpv_tipo_venta', '{tpv_nombre}', 'tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_compra' => 1), $venta_defecto, null, null, true);


            $data['documentos'] = $documentos = $this->compras_model->get_comprobantes( array('cqc_id_lcc'=>$lcc_id, 'cqc_estado' => 1) );
            if(count($documentos)>0 && $documentos[0]['cqc_liquidado_cierre']<1){
                $data['mostrar'] = 1;
            }else if(count($documentos)<=0){
                $data['mostrar'] = 1;
            }else{
                $data['mostrar'] = 0;
            }

           // die(print_r($data['mostrar']));
            $par_nrc=$this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
            $mask = $this->gsatelite->get_registro('tde_tipo_documento', array('tde_id'=>$par_nrc));
            $data['mask'] = $mask->tde_mascara;



            /*********************************************** DATA - PRODUCTOS **********************************************/
            //Se recalcula el código
            $numero_proveedores = $this->gsatelite->count('prv_proveedor');
            $data['codigo_proveedor'] = generar_codigo_cor($numero_proveedores + 1);

            $data['nacionalidades'] = $this->gsatelite->get_dropdown('pai_pais', 'pai_nacionalidad', 'nacionalidades', array('pai_estado' => 1, 'pai_nacionalidad <>' => ''), null, null, null, true);

            $data['municipios'] = $this->gsatelite->get_dropdown('mun_municipio', 'mun_nombre', 'municipios', null, null, null, null, true);

            $data['tamanio_prov'] = $this->gsatelite->get_dropdown('tap_tamano_prov', 'tap_nombre', 'tamanios', array('tap_estado' => 1), null, null, null, true);

            $data['giros'] = $this->gsatelite->get_dropdown('gir_giro', 'gir_nombre', 'giros', array('gir_estado' => 1), null, null, null, true);

            $data['actividades_eco'] = $this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), null, null, null, true);
            /****************************************************************************************/

            $data['titulo_personal'] = "Comprobantes liquidados por caja chica";
            $this->_cargarvista($data);
        }
    }

    public function get_proveedores() {
        if ($this->input->post()) {
            $valorBusqueda = $this->input->post('proveedor');

            $like = array(
                "CONCAT(prv_nombre, ' ', prv_apellido)" => $valorBusqueda,
                "prv_codigo" => $valorBusqueda,
            );

            $select = "prv_id as proveedor,CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_codigo, ' - ',prv_nombre, ' ', prv_apellido)
            WHEN prv_tipo_pers = 2 THEN CONCAT(prv_codigo, ' - ',prv_apellido) END as nombre_proveedor";

            $proveedores = $this->compras_model->get_proveedores(array('prv_estado' => 1), $like, $select);

            echo json_encode($proveedores);
        }
    }

    public function registro_caja_chica($dpv_id, $documento_array, $id_lcc, $edit=null, $txtNrc=null){
        $get_lcc=null;
        if($id_lcc>0){
            $get_lcc=$this->gsatelite->get_tabla('lcc_liquidacion_caja_chica', array('lcc_id'=>$id_lcc));
        }
        // Se actualiza el estado y monto del dpv.
        $actualizar_dpv = array(
            'dpv_pagado' => 1,
            'dpv_monto_abono' => convertirFloat($documento_array['dpv_total']),
            'dpv_monto_pendiente' => 0
        );

        $this->gsatelite->actualizar_array('dpv_documento_proveedor', $actualizar_dpv, array('dpv_id'=>$dpv_id));

        $ingresar_cqc = array(
            'cqc_id_prv'=>$documento_array['dpv_id_prv'],
            'cqc_id_tpv'=>null,
            'cqc_id_tif'=>$documento_array['dpv_id_tif'],
            'cqc_id_lcc'=>$id_lcc,
            'cqc_id_dpv'=>$dpv_id,
            'cqc_numero_documento'=>$documento_array['dpv_numero_documento'],
            'cqc_nrc'=>($txtNrc!='')?$txtNrc:null,
            'cqc_concepto'=>$documento_array['dpv_concepto'],
            'cqc_fecha_documento'=>$documento_array['dpv_fecha_documento'],
            'cqc_fecha_contabilizacion'=>$documento_array['dpv_fecha_contabilizacion'],
            'cqc_impuesto'=>$documento_array['dpv_impuesto'],
            'cqc_retencion'=>$documento_array['dpv_retencion'],
            'cqc_total'=>$documento_array['dpv_total'],
            'cqc_monto'=>$documento_array['dpv_subtotal'],
            'cqc_estado'=>1,
            'cqc_usu_creacion'=>$this->tank_auth->get_user_id(),
            'cqc_fecha_creacion'=>date('Y-m-d H:i:s'),
            'cqc_usu_modificacion'=>$this->tank_auth->get_user_id(),
            'cqc_fecha_modificacion'=>date('Y-m-d H:i:s')
        );

        $actualizar_lcc = array(
            'lcc_disponible' => convertirFloat($get_lcc[0]['lcc_disponible']) - convertirFloat($documento_array['dpv_total']),
            'lcc_usu_modificacion' => $this->tank_auth->get_user_id(),
            'lcc_fecha_modificacion' => date('Y-m-d H:i:s')
        );

        $agregar=null;
        // Se agrega o actualiza como comprobante cuando se edita un dpv con caja chica asignada. (actualmente no se puede editar un dpv con caja asignada).
        /*if(count($get_lcc)>0 && $edit!=null){
            $comp = $this->gsatelite->get_tabla('cqc_comprobante_liquidacion_caja', array('cqc_id_dpv'=>$dpv_id));
            $this->gsatelite->actualizar_array('cqc_comprobante_liquidacion_caja', $ingresar_cqc, array('cqc_id_lcc'=>$comp[0]['cqc_id']));

            $agregar = $comp[0]['cqc_id'];
            if($agregar > 0){ // si ya existe el comprobante, eliminar los impuestos y retenciones.
                $this->gsatelite->borrado_general('ilc_impuesto_liquidacion_comprobante', array('ilc_id_cqc'=>$agregar));
                $this->gsatelite->borrado_general('rlc_retencion_liquidacion_comprobante', array('rlc_id_cqc'=>$agregar));
            }
        }else{*/
            $this->gsatelite->actualizar_array('lcc_liquidacion_caja_chica', $actualizar_lcc, array('lcc_id'=>$id_lcc));
            $agregar = $this->gsatelite->ingresar('cqc_comprobante_liquidacion_caja', $ingresar_cqc);
        //}

            $impuestos  = $this->compras_model->get_impuestos_doc(array('dxd_id_dpv'=>$dpv_id));
            $retenciones= $this->compras_model->get_retenciones_doc(array('dxd_id_dpv'=>$dpv_id));

            foreach ($impuestos as $imp) {
                $calculo_impuesto = ($imp['monto_imp'] > 0 )?$imp['monto_imp']:$imp['monto_imp2'];
                $array_imp = array(
                    'ilc_id_imp'            => $imp['idd_id_imp'],
                    'ilc_id_cqc'            => $agregar,
                    'ilc_porcentaje'        => $imp['imp_porcentaje'],
                    'ilc_monto_impuesto'    => $calculo_impuesto,
                    'ilc_estado'            => 1,
                    'ilc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ilc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ilc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ilc_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('ilc_impuesto_liquidacion_comprobante', $array_imp);
            }

            foreach ($retenciones as $ret) {
                $calculo_retencion = ($imp['monto_ret'] > 0 )?$imp['monto_ret']:$imp['monto_re2'];
                $array_ret = array(
                    'rlc_id_ret'            => $ret['rxd_id_ret'],
                    'rlc_id_cqc'            => $agregar,
                    'rlc_porcentaje'        => $ret['ret_porcentaje'],
                    'rlc_monto_impuesto'    => $calculo_retencion,
                    'rlc_estado'            => 1,
                    'rlc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rlc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'rlc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'rlc_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('rlc_retencion_liquidacion_comprobante', $array_ret);
            }

        }


        function imprimir_retaceo($rtd_id) {
            satelite_validar();
            if ($rtd_id == null) {
                redirect('inicio');
            }
            $retaceo = $this->compras_model->get_retaceos(array('rtd_id' => $rtd_id));
            if (count($retaceo) > 0) {
                $documento = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $retaceo[0]['rtd_id_dpv']));
                $data['retaceo'] = $retaceo[0];
                $data['documento'] = $documento[0];
                $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $retaceo[0]['rtd_id_dpv']));
                $data['detalle_retaceo'] = $this->compras_model->get_detalle_retaceo(array('drc_id_rtd' => $rtd_id));
                $data['detalle_gastos'] = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));
                $data['tipo_reporte'] = 'pdf';
                $html = $this->load->view('modulo_compras/procesos/imprimir_retaceo', $data, true);
                $data['titulo'] = 'Retaceo N. ' . $retaceo[0]['rtd_numero'];
                $data['solotitulo'] = true;
                $header = $this->load->view('reporte/header', $data, true);
            } else {
                $retaceo = $this->compras_model->get_retaceos_consolidado(array('rtd_id' => $rtd_id));
                $idsDpv = (count($retaceo) > 0) ? implode(',', array_column($retaceo, 'rdv_id_dpv')) : 0;
                $documento = $this->compras_model->get_documentos_proveedor(array("dpv_id IN ($idsDpv) " => null));
                $data['retaceo'] = $retaceo;
                $data['documento'] = $documento;
                $data['detalle_retaceo'] = $this->compras_model->get_detalle_retaceo_consolida(array('drc_id_rtd' => $rtd_id));
                $data['detalle_gastos'] = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));
                $data['tipo_reporte'] = 'pdf';
                $html = $this->load->view('modulo_compras/procesos/imprimir_retaceo_consolida', $data, true);
                $data['titulo'] = 'Retaceo N. ' . $retaceo[0]['rtd_numero'];
                $data['solotitulo'] = true;
                $header = $this->load->view('reporte/header', $data, true);                
            }
            $GLOBALS['nombre_reporte'] = 'Retaceo_' . date('dmYHis');
            $reporte = $header . $html;
            $this->pdf->makePdf($reporte, 'L', 'Retaceo', 'Letter');
        }

        function imprimir_retaceo_excel($rtd_id) {
            satelite_validar();
            if ($rtd_id == null) {
                redirect('inicio');
            }
            $retaceo = $this->compras_model->get_retaceos(array('rtd_id' => $rtd_id));
            if (count($retaceo) > 0) {
                $documento = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $retaceo[0]['rtd_id_dpv']));
                $data['retaceo'] = $retaceo[0];
                $data['documento'] = $documento[0];
                $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $retaceo[0]['rtd_id_dpv']));
                $data['detalle_retaceo'] = $this->compras_model->get_detalle_retaceo(array('drc_id_rtd' => $rtd_id));
                $data['detalle_gastos'] = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));
                $data['tipo_reporte'] = 'excel';
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename']=$filename;
                $html = $this->load->view('modulo_compras/procesos/imprimir_retaceo_excel', $data, true);
            } else {
                $retaceo = $this->compras_model->get_retaceos_consolidado(array('rtd_id' => $rtd_id));
                $idsDpv = (count($retaceo) > 0) ? implode(',', array_column($retaceo, 'rdv_id_dpv')) : 0;
                $documento = $this->compras_model->get_documentos_proveedor(array("dpv_id IN ($idsDpv) " => null));
                $data['retaceo'] = $retaceo;
                $data['documento'] = $documento;
                $data['detalle_retaceo'] = $this->compras_model->get_detalle_retaceo_consolida(array('drc_id_rtd' => $rtd_id));
                $data['detalle_gastos'] = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));
                $data['tipo_reporte'] = 'excel';
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename']=$filename;
                $html = $this->load->view('modulo_compras/procesos/imprimir_retaceo_consolida', $data, true);
            }
            echo $html;
        }

        function get_nrc_proveedor(){
            satelite_validar();
            $proveedor = $this->input->post('id');
            $tipo= $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');

        $get_nrc = $this->compras_model->get_documento(array('tde_id'=>$tipo,'prv_id'=>$proveedor)); //Documentos del proveedor (NIT, NRC, etc.).

        echo json_encode($get_nrc[0]['dcp_valor']);
        die();
    }

    /*
     * @author: Mario Marquez
     * $tipo 1 = Busca Nacionalidades 2 = Busca Departamentos 3 = Busca Municipios
     */

    public function get_localidades($id_filtro = null, $tipo = null) {
        $idLocalizacion = ($id_filtro != null) ? $id_filtro : $this->input->post('filtro');
        $tipoLocalidad = ($tipo != null) ? $tipo : $this->input->post('tipo');

        $opciones = "<option></option>";

        $where = null;
        switch ($tipoLocalidad) {
            case 1:
            if ($idLocalizacion != null) {
                $where['pai_id'] = $idLocalizacion;
            }
            $registros = $this->gsatelite->get_tabla('pai_pais', $where);

            foreach ($registros as $row) {
                $opciones .= "<option value='" . $row['pai_id'] . "'>" . $row['pai_nombre'] . "</option>";
            }
            break;
            case 2:
            if ($idLocalizacion != null) {
                $where['dep_id_pai'] = $idLocalizacion;
            }
            $registros = $this->gsatelite->get_tabla('dep_departamento', $where);

            foreach ($registros as $row) {
                $opciones .= "<option value='" . $row['dep_id'] . "'>" . $row['dep_nombre'] . "</option>";
            }

            break;

            case 3:
            if ($idLocalizacion != null) {
                $where['mun_id_dep'] = $idLocalizacion;
            }
            $registros = $this->gsatelite->get_tabla('mun_municipio', $where);

            foreach ($registros as $row) {
                $opciones .= "<option value='" . $row['mun_id'] . "'>" . $row['mun_nombre'] . "</option>";
            }
            break;
        }

        if ($tipo != null) {
            return $opciones;
        }

        echo $opciones;
    }

    function guardar_proveedor(){
        satelite_validar();
        $post_array=$this->input->post();

        //Se recalcula el código
        $numero_proveedores = $this->gsatelite->count('prv_proveedor');

        //$codigo_proveedor = generar_codigo_cor($numero_proveedores + 1);
        $codigo_proveedor = generar_codigo_cor($numero_proveedores + 1);

        $proveedor_array = array(
            'prv_id_mun' => ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null,
            'prv_id_tap' => ($post_array['slcTamanioProv'] != '') ? $post_array['slcTamanioProv'] : null,
            'prv_id_pai' => ($post_array['slcNacionalidad'] != '') ? $post_array['slcNacionalidad'] : null,
            'prv_id_gir' => ($post_array['slcGiro'] != '') ? $post_array['slcGiro'] : null,
            'prv_id_acp' => ($post_array['slcActividad'] != '') ? $post_array['slcActividad'] : null,
            'prv_tipo_pers' => $post_array['slcPersoneria'],
            'prv_codigo' => $codigo_proveedor,
            'prv_nombre' => ($post_array['txtNombreProv'] != '') ? $post_array['txtNombreProv'] : null,
            'prv_apellido' => ($post_array['txtApellidoProv'] != '') ? $post_array['txtApellidoProv'] : null,
            'prv_direccion' => ($post_array['txtDireccionProv'] != '') ? $post_array['txtDireccionProv'] : null,
            'prv_representante' => ($post_array['txtRepresentante'] != '') ? $post_array['txtRepresentante'] : null,
            'prv_fecha_registro' => ($post_array['txtFechaRegistro'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaRegistro'])) : null,

            'prv_estado' => 1,
            'prv_usu_creacion' => $this->tank_auth->get_user_id(),
            'prv_fecha_creacion' => date('Y-m-d H:i:s'),
            'prv_usu_modificacion' => $this->tank_auth->get_user_id(),
            'prv_fecha_modificacion' => date('Y-m-d H:i:s'),
        );


        $prv_id = $this->gsatelite->ingresar('prv_proveedor', $proveedor_array);

        if ($prv_id > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar proveedor", 'texto_alerta' => "El registro se guardó correctamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar proveedor", 'texto_alerta' => "Ocurrió un problema al crear el registro.");
        }

        echo json_encode($alerta);
    }

    /*
     * @prvId = Id del Proveedor
     * @numDocumento = Si se envia, verifica la existencia del número asignado a los comprobantes (Returna True o False)
     * @Flag = Determina si se retorna el array o es via ajax
     */

    public function get_documentos_caja($prvId = null, $flag = false, $numDocumento = null) {

        $proveedorId = ($prvId != null) ? $prvId : $this->input->post('proveedor');
        $documento   = ($numDocumento != null)? $numDocumento : $this->input->post('txtNumDoc');

        //Si existe el parametro documento solo verifica la existencia.
        if ($documento != '') {
            $where = array(
                'cqc_numero_documento' => $documento,
                'cqc_id_prv' => $proveedorId,
                'cqc_id_dpv' => null,
                'cqc_estado' => 1
            );
           /* if ($comprobante != null) {
                $where['cqc_id !='] = $comprobante;
            }*/

            $conteo = $this->gsatelite->count('cqc_comprobante_liquidacion_caja', $where);
            $arreglo = $conteo;
        }

        if (!$flag) {
            echo json_encode($arreglo);
        } else {
            return $arreglo;
        }
    }

     /**
     * @author Edith Herrera
     * @since  27/09/2017
     * @return Reintegro de caja chica.
     */
     function reintegro_caja($lcc_id=null) {
        satelite_validar();
        if($_POST){
            $post_array=$this->input->post();
            $lcc_id = $post_array['id_lcc'];
            $tipo_reintegro = $post_array['hdnTipoReintegro'];
            $che_id = ($post_array['slcCheque'] > 0) ? $post_array['slcCheque'] : null;
            $monto = ($post_array['monto'] != '') ? str_replace(',', '', $post_array['monto']) : null;
            $nta_id = ($post_array['slcTransferencias'] > 0) ? $post_array['slcTransferencias'] : null;
            $monto_nta = ($post_array['montoNta'] != '') ? str_replace(',', '', $post_array['montoNta']) : null;
            $monto = ($tipo_reintegro > 0) ? $monto_nta : $monto;
            $lcc_bd = $this->gsatelite->get_tabla('lcc_liquidacion_caja_chica', array('lcc_id'=>$lcc_id));
            $asig_bd = $lcc_bd[0]['lcc_asignado'];
            $disp_db = $lcc_bd[0]['lcc_disponible'];

                          $this->db->select_sum('cqc_total');
            $monto_asig = $this->db->from('cqc_comprobante_liquidacion_caja')->where('cqc_id_lcc', $lcc_id)->get()->row();
            $nuevo_disp =((float)$monto + (float)$asig_bd)-(float)$monto_asig->cqc_total;
            $array_rcc = array(
                'rcc_id_nta' => $nta_id,
                'rcc_id_che' => $che_id,
                'rcc_id_lcc' => $lcc_id,
                'rcc_fecha' => date('Y-m-d H:i:s'),
                'rcc_monto' => ($monto != '') ? $monto : null,
                'rcc_monto_disponible' => ($disp_db != '') ? $disp_db : null,
                'rcc_estado'=>1,
                'rcc_usu_creacion'=>$this->tank_auth->get_user_id(),
                'rcc_fecha_creacion'=>date('Y-m-d H:i:s'),
                'rcc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'rcc_fecha_modificacion'=>date('Y-m-d H:i:s')
            );
            $rcc = $this->gsatelite->ingresar('rcc_reintegro_caja_chica', $array_rcc);

            $lcc_actualiza = array(
                'lcc_asignado'=>(float)$monto + (float)$asig_bd,
                'lcc_disponible'=>$nuevo_disp,
                'lcc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'lcc_fecha_modificacion'=>date('Y-m-d H:i:s')
            );
            $act_lcc = $this->gsatelite->actualizar_array('lcc_liquidacion_caja_chica', $lcc_actualiza,array('lcc_id'=>$lcc_id));
            if ($rcc>0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Reintegro de caja chica", 'texto_alerta' => "Los registros se ingresaron con éxito.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reintegro de caja chica", 'texto_alerta' => "Ocurrió un error al guardar la información.");
            }
            $this->session->set_flashdata($alerta);
            redirect('modulo_compras/procesos/grid_reintegro_caja/'.$lcc_id);

        }else{
                    $this->db->join('cch_caja_chica', 'lcc_id_cch=cch_id');
            $info = $this->gsatelite->get_tabla('lcc_liquidacion_caja_chica', array('lcc_id' => $lcc_id));
            $data['info'] = $info[0];
            $usados = $this->gsatelite->get_tabla('rcc_reintegro_caja_chica', array('rcc_estado'=>1));
            $che_usados = $nta_usados = array();
            if($usados > 0){
                foreach ($usados as $us ) {
                    if ($us['rcc_id_che']) {
                        $che_usados[] = $us['rcc_id_che'];
                    }
                    if ($us['rcc_id_nta']) {
                        $nta_usados[] = $us['rcc_id_nta'];
                    }
                }
            }
            if(count($che_usados)>0){
                $this->db->where_not_in('che_id', $che_usados);
            }
            $where['che_aplica_caja_chica']  = 1;
            $where['che_id_cch']  = $info[0]['lcc_id_cch'];
            $cheques = $this->compras_model->get_cheques($where);
            if(count($nta_usados)>0){
                $this->db->where_not_in('nta_id', $nta_usados);
            }
            $notasab = $this->gsatelite->get_tabla("nta_nota_abono", array("nta_aplica_caja_chica"=> 1, "nta_id_cch" => $info[0]['lcc_id_cch']));

            $option='<option value=""></option>';
            foreach ($cheques as $che) {
                if($che['che_orden']!=''){
                    $cheque = $che['che_numero'].' - '.$che['che_orden'];
                }else{
                    $cheque = $che['che_numero'];
                }
                $option.='<option value="'.$che['che_id'].'">'.$cheque.'</option>';
            }
            $data['cheques'] = $option;
            $option='<option value=""></option>';
            foreach ($notasab as $nta) {
                $dato = ($nta['nta_orden'] != '') ? $nta['nta_codigo'].' - '.$nta['nta_orden'] : $nta['nta_codigo'];
                $option.='<option value="'.$nta['nta_id'].'">'.$dato.'</option>';
            }
            $data['notas_abono'] = $option;

            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['titulo_personal'] = "Reintegro de caja chica";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * @since  28/09/2017
     * @return Grid para reintegro de caja chica.
     */
    public function grid_reintegro_caja($lcc_id) {
        satelite_validar();
        if($lcc_id<=0){
            redirect('/auth/login/');
        }else{
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/procesos/periodo_caja_chica');

                    $this->db->where('lcc_id', $lcc_id);
                    $this->db->join('cch_caja_chica', 'lcc_id_cch=cch_id');
            $info = $this->gsatelite->get_tabla('lcc_liquidacion_caja_chica');
            $data['info'] = $info[0];
            $data['reintegros'] = $reintegros = $this->compras_model->get_reintegros(array('lcc_id'=>$lcc_id));
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['lcc_id'] = $lcc_id;
            $data['titulo_personal'] = 'Reintegro de caja chica';
            $this->_cargarvista($data);

        }
    }


    /**
     * @author Edith Herrera
     * @since  29/09/2017
     * @return Editar reintegro de caja chica.
     */
    function editar_reintegro_caja($lcc_id=null, $rcc_id=null) {
        satelite_validar();

        if($_POST){
            $post_array=$this->input->post();
            $che_id = $post_array['slcCheque'];
            $lcc_id = $post_array['id_lcc'];
            $rcc_id = $post_array['id_rcc'];
            $monto  = ($post_array['monto']!='')?str_replace(',','',$post_array['monto']):null;
            $first  = ($post_array['cheque_first']!='')?str_replace(',','',$post_array['cheque_first']):null;

            $lcc_bd = $this->gsatelite->get_tabla('lcc_liquidacion_caja_chica', array('lcc_id'=>$lcc_id));
            $asig_bd = $lcc_bd[0]['lcc_asignado']-$first;
            $disp_db = $lcc_bd[0]['lcc_disponible']-$first;

            $this->db->select_sum('cqc_total');
            $monto_asig = $this->db->from('cqc_comprobante_liquidacion_caja')->where('cqc_id_lcc', $lcc_id)->get()->row();
            $nuevo_disp =((float)str_replace(',','', $monto) + (float)$asig_bd)-(float)$monto_asig->cqc_total;

            $array_rcc = array(
                'rcc_id_che'=>$che_id,
                'rcc_id_lcc'=>$lcc_id,
                'rcc_fecha'=>date('Y-m-d H:i:s'),
                'rcc_monto'=>($monto!='')?$monto:null,
                'rcc_monto_disponible'=>($disp_db!='')?$disp_db:null,
                'rcc_estado'=>1,
                'rcc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'rcc_fecha_modificacion'=>date('Y-m-d H:i:s')
            );
            $rcc = $this->gsatelite->actualizar_array('rcc_reintegro_caja_chica', $array_rcc, array('rcc_id'=>$rcc_id));

            $lcc_actualiza = array(
                'lcc_asignado'=>(float)$monto + (float)$asig_bd,
                'lcc_disponible'=>$nuevo_disp,
                'lcc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'lcc_fecha_modificacion'=>date('Y-m-d H:i:s')
            );
            $act_lcc = $this->gsatelite->actualizar_array('lcc_liquidacion_caja_chica', $lcc_actualiza,array('lcc_id'=>$lcc_id));

            if ($rcc>0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Reintegro de caja chica", 'texto_alerta' => "Los registros se ingresaron con éxito.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reintegro de caja chica", 'texto_alerta' => "Ocurrió un error al guardar la información.");
            }

            $this->session->set_flashdata($alerta);
            redirect('modulo_compras/procesos/grid_reintegro_caja/'.$lcc_id);

        }else{
                    $this->db->where('lcc_id', $lcc_id);
                    $this->db->join('cch_caja_chica', 'lcc_id_cch=cch_id');
            $info = $this->gsatelite->get_tabla('lcc_liquidacion_caja_chica');
            $data['info'] = $info[0];

            $get_rcc=$this->gsatelite->get_registro('rcc_reintegro_caja_chica', array('rcc_id'=>$rcc_id));

                      $this->db->where('rcc_id <>', $rcc_id);
            $usados = $this->gsatelite->get_tabla('rcc_reintegro_caja_chica', array('rcc_estado'=>1));

            $che_usados = $nta_usadas = array();
            if($usados>0){
                foreach ($usados as $us ) {
                    $che_usados[] = $us['rcc_id_che'];
                    $nta_usadas[] = $us['rcc_id_nta'];
                }
                $che_usados = array_filter($che_usados);
                $nta_usadas = array_filter($nta_usadas);
            }

            if(count($che_usados)>0){
                $this->db->where_not_in('che_id', $che_usados);
            }
            $cheques = $this->compras_model->get_cheques();

            if(count($nta_usadas)>0){
                $this->db->where_not_in('nta_id', $nta_usadas);
            }
            $notasab = $this->gsatelite->get_tabla("nta_nota_abono", array("nta_aplica_caja_chica"=> 1, "nta_id_cch" => $info[0]['lcc_id_cch']));

            $montos=array();
            $monto_select = 0;
            $option='<option value=""></option>';
            foreach ($cheques as $che) {
                if($che['che_concepto']!=''){
                    $cheque = $che['che_numero'].' - '.$che['che_concepto'];
                }else{
                    $cheque = $che['che_numero'];
                }
                if($get_rcc->rcc_id_che==$che['che_id']){
                    $select='selected="selected"';
                    $montos = $this->get_monto_disponible($lcc_id, $che['che_id'], 1, $info[0]['lcc_id_cch'],2);
                    $monto_select = $che['che_monto'];
                }else{
                    $select='';
                }
                $option.='<option value="'.$che['che_id'].'" '.$select.'>'.$cheque.'</option>';
            }
            $decimal = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

            $data['cheques'] = $option;
            $disp=$get_rcc->rcc_monto_disponible;
            $data['disponible'] = $disponible = $montos['monto'];

            $data['monto_cheque'] = number_format($monto_select, $decimal,'.',',');
            $data['asignado'] = number_format($info[0]['lcc_asignado'], $decimal,'.',',');
            //number_format($montos['monto']-$disp +$montos['che_monto'],2);
            $data['rcc_id'] = $rcc_id;

            $data['titulo_personal'] = "Editar reintegro de caja chica";
            $this->_cargarvista($data);
        }
    }


     /**
     * @author Edith Herrera
     * @since  30/09/2017
     * @return Cierre de caja chica.
     */
     function corte_caja($lcc_id=null) {
        satelite_validar();
        if($_POST){
            $post_array   = $this->input->post();
            $lcc_id       = $post_array['lcc_id'];
            $fecha_ini    = ($post_array['fecha_ini'] != '') ? $post_array['fecha_ini'] : null;
            $fecha_fin    = ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
            $total_monto  = ($post_array['txtMontoTotal']!='') ? $post_array['txtMontoTotal'] : null;
            $id_cqc       = $post_array['id_cqc'];
            $lcc_bd       = $this->gsatelite->get_registro('lcc_liquidacion_caja_chica', array('lcc_id'=>$lcc_id));
            $decimales    = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
                            $this->db->join('emp_empleado', 'emp_id = cch_id_emp');
            $empleado_cch = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado' => 1, 'cch_id' => $lcc_bd->lcc_id_cch));
            $orden        = (count($empleado_cch) > 0) ? $empleado_cch[0]['emp_nombre'] . ' ' . $empleado_cch[0]['emp_apellido'] : $this->gsatelite->get_parametro('SYS_EMPRESA','');
            $array_cierre = array(
                'cjc_id_usu' => $this->tank_auth->get_user_id(),
                'cjc_id_lcc' => $lcc_id,
                'cjc_fecha' => formatear_fecha('Y-m-d',$fecha_ini),
                'cjc_fecha_cierre' => formatear_fecha('Y-m-d',$fecha_fin),
                'cjc_total_liquidacion' => number_format(str_replace(',', '', $total_monto), $decimales,'.', ''),
                'cjc_estado' => 1,
                'cjc_usu_creacion' => $this->tank_auth->get_user_id(),
                'cjc_fecha_creacion' => date('Y-m-d H:i:s'),
                'cjc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cjc_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $cierre = $this->gsatelite->ingresar('cjc_cierre_caja_chica', $array_cierre);
            foreach ($id_cqc as $cqc => $value) {
                $this->gsatelite->actualizar_array('cqc_comprobante_liquidacion_caja', array('cqc_liquidado_cierre'=>1), array('cqc_id'=>$value));
            }
            $actualizar_lcc = array(
                'lcc_fecha_fin' => formatear_fecha('Y-m-d',$fecha_fin),
                // 'lcc_asignado' => (float)$lcc_bd->lcc_asignado - (float)str_replace(',', '', $total_monto),
                'lcc_corte'=>1,
                'lcc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'lcc_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('lcc_liquidacion_caja_chica', $actualizar_lcc, array('lcc_id'=>$lcc_id));
            /************************* GENERAR CHEQUE PENDIENTE ***************************************/
            $cheque_array = array(
                'chp_id_usu_genera' => $this->tank_auth->get_user_id(),
                'chp_id_cjc' => $cierre,
                'chp_monto' => number_format(str_replace(',', '', $total_monto), $decimales,'.', ''),
                'chp_orden' => $orden,
                'chp_concepto' => 'Reintegro de caja chica',
                'chp_fecha' => date('Y-m-d H:i:s'),
                'chp_generado' => 0,
                'chp_estado' => 1,
                'chp_usu_creacion' => $this->tank_auth->get_user_id(),
                'chp_fecha_creacion' => date('Y-m-d H:i:s'),
                'chp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'chp_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $resultado = $this->gsatelite->ingresar('chp_cheque_pendiente', $cheque_array);
            /*****************************************************************************************/
            //===================================
            //GENERAR PARTIDA CONTABLE PARA EL CIERRE DE CAJA CHICA
            //===================================
            $permite_generar = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_CIERRE_CAJA_CHICA');
            if ($permite_generar == 1 and $cierre > 0) {
                //generar partida de cierre caja
                $this->generar_partida_contable_caja_chica_individual(array('cjc_id'=>$cierre));
            }

            if ($cierre>0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cierre de caja chica", 'texto_alerta' => "Los registros se ingresaron correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cierre de caja chica", 'texto_alerta' => "Ocurrió un error al guardar la información.");
            }

            $this->session->set_flashdata($alerta);
            redirect('modulo_compras/procesos/periodo_caja_chica');
        }else{
            $where = array('lcc_id'=>$lcc_id);
            $liquidacion = $this->compras_model->get_periodo_caja($where);
            $data['fecha'] = ($liquidacion[0]['lcc_fecha_inicio']) ? formatear_fecha('d-m-Y', $liquidacion[0]['lcc_fecha_inicio']) : '';
            $data['caja_chica'] = $liquidacion[0]['cch_nombre'];
            $data['caja_id'] = $caja = $liquidacion[0]['cch_id'];

            $data['monto']=$liquidacion[0]['monto'];
            $data['limite']=$liquidacion[0]['lcc_asignado'];
            $data['lcc_id']=$lcc_id;

            $data['documentos'] = $this->compras_model->get_comprobantes(array('cqc_id_lcc'=>$lcc_id, 'cqc_estado' => 1) );
            $data['decimal']=($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['titulo_personal'] = "Corte de caja chica";
            $this->_cargarvista($data);
        }
    }


    public function get_codigos_pro(){
        $id_art = $this->input->post('producto');
        $tipo = $this->input->post('tipo');

        if($tipo==3){
            echo json_encode(array('mostrar'=>'')); // Activo fijo no posee mas códigos asociados.
        }else{
            $datos = $this->gsatelite->get_tabla('cdp_codigo_producto', array('cdp_id_art'=>$id_art));
            die(print_r($datos));
            $codigos=array();
            if(count($datos)>0){
                foreach ($datos as $dat) {
                    $codigos[]=$dat['cdp_codigo'];
                }
            }

            if(count($codigos)>0){
                $mostrar = implode(', ', $codigos);
            }else{
                $mostrar ='';
            }

            echo json_encode(array('mostrar'=>$mostrar));
        }
    }

    public function get_articulos(){
        $art_id_tia = $this->input->post('categoria');
        $articulos  = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', '', array('art_estado' => 1, 'art_id_tia'=> $art_id_tia), 'art_id', null, null, true);
        $select = str_replace('<option value="0">Seleccione</option>', '', $articulos);
        echo $select;
    }

    /**
    * @author ELman Ortiz
    * @fecha: 25/01/2018
    * @descripcion: Genera la partida contable automatica cuando se hace un ingreso de productos en compras que afecta inventario
    */
    function generar_partida_docprov_afecta_inv_debe($moi_id, $doc_referencia, $data_doc = null){
        $cuentas = null;
        $cuentas_imp = null;
        $total_debe = 0.00;

        //Se obtiene el registro de Movimiento
        $data_moi = $this->gsatelite->get_tabla('moi_movimiento_inv',array('moi_id' => $moi_id));

        //Tipo Cuenta de existencia por defecto
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INVENTARIO_EN_TRANSITO'));
        
        //Se obtienen los productos que afectan inventario desde el Movimiento
        $subtxcatprod = $this->inventario_model->get_subtotales_cuentaprod($moi_id, $idtipo_cnt);
        
        $articulos_no_inv = null;
        //Si el movimiento contiene un documento se obtienen los articulos que no afectan inventario.
        if($data_moi[0]['moi_id_dpv']!=null){

            $where_articulos = array(
                'dxd_id_dpv' => $data_moi[0]['moi_id_dpv'],
                'art_inventario' => 0
            );
            $articulos_no_inv = $this->compras_model->get_cnt_x_prod_x_docproveedor($where_articulos);
        }


        //print_r($subtxcatprod); die();
        foreach ($subtxcatprod as $key => $value) {
            $cuentas[$key] = ($value['cnt_id']) ? array('0' => array('cnt_id' => $value['cnt_id'])) : array('0' => array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO')));
            $total_debe = $total_debe + $value['newsubtotal'];
        }

        if($articulos_no_inv!=null){
            $total_debe += array_sum(array_column($articulos_no_inv, 'subtotal_prod'));
        }


        //Impuestos categoria por productos
        $impxcatprod = array();//$this->inventario_model->get_impuesto_cuentaprod($moi_id);
        foreach ($impxcatprod as $key => $value2) {
            $cuentas_imp[$key] = ($value2['cnt_id']) ? array('0' => array('cnt_id' => $value2['cnt_id'])) : array('0' => array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO')));
            $total_debe = $total_debe + $value2['monto_imp_det'];//Corresponde al impuesto por detalle de impuesto
        }

        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
        $origen = $this->gsatelite->get_tabla('orp_origen_partida',array('orp_tabla' =>'moi_movimiento'));
        $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;

        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));

        $cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');

        if (count($consultar)>0) {
            $id_tipo_partida = $tipo_partida;
        }

        //Concepto entrada de producto documento proveedor
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 8));
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
      }else{
          $pct_concepto = 'Concepto no definido';
      }


      $array_partida = array(
        'pct_id_tpd' => $id_tipo_partida,
            //'pct_id_prc' => $this->input->post('id_prc'),
            'pct_id_orp' => $orp_partida,//YA
            'pct_concepto' => $pct_concepto.' - ' . $data_doc['nombre_com'].' - '.$data_doc['fecha_doc']. ' - ' .$data_doc['dpv_numero'],//YA
            'pct_total' => number_format($total_debe, 4, '.', ''),//YA
            'pct_fecha' => formatear_fecha('Y-m-d', $data_doc['fecha_doc']), //date('Y-m-d H:i:s'), //YA
            'pct_correlativo' => $correlativo_partida,//YA
            'pct_codigo' => $doc_referencia,
            //'pct_modulo' => $modulo,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id(),
        );

      $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('EXISTENCIA'));

      $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
        //Cuenta inicial
      foreach ($subtxcatprod as $j => $deta) {
        $array_detalle = array(
                    'dpc_id_cnt' => $cuentas[$j][0]['cnt_id'],//YA
                    'dpc_id_pct' => $agregar,//YA
                    'dpc_concepto' => 'Entrada de producto documento proveedor',
                    'dpc_debe' => $deta['newsubtotal'],//debe
                    'dpc_haber' => 0.00,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );

        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
    }

        //Detalles de productos no afectan inv.
    if($articulos_no_inv!=null){
        foreach ($articulos_no_inv as $j => $deta) {
            $array_detalle = array(
                    'dpc_id_cnt' => ($deta['cuenta_id'] == null) ? $cuenta_defecto : $deta['cuenta_id'] ,//YA
                    'dpc_id_pct' => $agregar,//YA
                    'dpc_concepto' => 'Gasto',
                    'dpc_debe' => $deta['subtotal_prod'],//debe
                    'dpc_haber' => 0.00,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );

            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
    }

        //Cuenta para los impuestos
    foreach ($impxcatprod as $k => $deta2) {
        $array_detalle_imp = array(
                'dpc_id_cnt' => $cuentas_imp[$k][0]['cnt_id'],//YA
                'dpc_id_pct' => $agregar,//YA
                'dpc_concepto' => $deta2['imp_nombre'],
                'dpc_debe' => $deta2['monto_imp_det'],//debe
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_imp);
    }
    return array('id_pct' => $agregar, 'total_haber' => $total_debe);
    }//Fin debe partida contable entrada doc por proveedor si afecta inventario

    /**
     *@return Elman Ortiz
     *@fecha 25/07/2017
     *@descripcion: Haber de entrada cuando afecta inventario por medio de documento por proveedor
     */
    function generar_partida_docprov_afecta_inv_haber($prv_id, $id_pct, $monto_haber){
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CUENTA_POR_PAGAR'));
        $where = array('prv_id' => $prv_id, 'tcn_id' => $tipo_cuenta);
        //Obtener la cuenta
        $id_cuenta = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $id_cnt = $this->inventario_model->get_cuenta_contable($where);
        if(count($id_cnt) > 0){
            $id_cuenta = $id_cnt[0]['dfp_id_cnt'];
        }

        $array_detalle = array(
            'dpc_id_cnt' => $id_cuenta,//YA
            'dpc_id_pct' => $id_pct,//Ya
            'dpc_concepto' => 'Pago a Proveedor',
            'dpc_debe' => 0.00,//haber
            'dpc_haber' => $monto_haber,
            'dpc_estado' => 1,
            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
            'dpc_fecha_mod' => date('Y-m-d H:i:s'),
            'dpc_usu_crea' => $this->tank_auth->get_user_id(),
            'dpc_usu_mod' => $this->tank_auth->get_user_id()
        );
        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
    }//Fin haber partida contable entrada cuando afecta inventario por medio de documento por proveedor

    /**
     *@return Elman Ortiz
     *@fecha 30/01/2018
     *@descripcion: Haber de entrada cuando no afecta inventario por medio de documento por proveedor
     */
    function generar_partida_docprov_no_afecta_inv_debe($where, $info, $data_doc = null){
        $total_debe = 0.0000;
        $id_cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $where_articulos = array(
            'dpv_id' => $where['dpv_id']
        );
        $cnt_prods = $this->compras_model->get_cnt_x_prod_x_docproveedor($where);
        $total_retenciones = 0;
        //Obtener los productos
        foreach ($cnt_prods as $key => $cnt_prod) {
            $total_debe = $total_debe + $cnt_prod['subtotal_prod'];
        }
        //Obtener los impuestos
        $cnt_imps = $this->compras_model->get_cnt_x_impu_x_docproveedor($where);
        foreach ($cnt_imps as $key => $cnt_imp) {
            $total_debe = $total_debe + $cnt_imp['subtotximpcuenta'];
        }
        //Obtener las retenciones
        $cnt_rets = $this->compras_model->get_cnt_x_ret_x_docproveedor($where);
        foreach ($cnt_rets as $key => $cnt_ret) {
            $total_retenciones = $total_retenciones + $cnt_ret['subtotxretcuenta'];
        }

        $total_debe = $total_debe - $total_retenciones;

        //Tipo de cuenta por defecto
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('COSTO'));
        //Correlativo de la partida contable
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
        //Determinar el origen de la partida si es Documento Proveedor - Sin afectar inventario
        $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 7));
        $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;
        //Cuenta por defecto
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        //Tipo de partida
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
        if (count($consultar)>0) {
            $id_tipo_partida = $tipo_partida;
        }

        //Concepto por factura sin afectar inventario
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 9));
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
      }else{
          $pct_concepto = 'Concepto no definido';
      }

      $array_partida = array(
        'pct_id_tpd' => $id_tipo_partida,
            //'pct_id_prc' => $this->input->post('id_prc'),
            'pct_id_orp' => $orp_partida,//YA
            //'pct_concepto' => $pct_concepto.' - ' . $info['num_doc_provedor'],//YA
            'pct_concepto' => $pct_concepto.' - '.$data_doc['nombre_com'].' - '.$data_doc['fecha_doc']. ' - ' .$data_doc['dpv_numero'],//YA
            'pct_total' => number_format($total_debe, 4, '.', ''),//YA
            'pct_fecha' => $info['fecha_doc_provedor'], //YA
            'pct_correlativo' => $correlativo_partida,//YA
            //'pct_codigo' => $codigo,
            //'pct_modulo' => $modulo,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id()
        );

      $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

        //Ingresar los detalles de la partida para los productos
      foreach ($cnt_prods as $j => $deta) {
        $dpc_id_cnt = ($deta['cuenta_id'] > 0) ? $deta['cuenta_id'] : $id_cuenta_defecto;
        $array_detalle = array(
                'dpc_id_cnt' => $dpc_id_cnt,//YA
                'dpc_id_pct' => $id_pct,//YA
                'dpc_concepto' => 'Documento por proveedor No afecta inventario',
                'dpc_debe' => $deta['subtotal_prod'],//debe
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
    }

        //Ingresar los detalles de la partida para los impuesto
    foreach ($cnt_imps as $j => $deta) {
        $dpc_id_cnt = ($deta['cxe_id_cnt'] > 0) ? $deta['cxe_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $array_detalle = array(
                'dpc_id_cnt' => $dpc_id_cnt,//YA
                'dpc_id_pct' => $id_pct,//YA
                'dpc_concepto' => 'Documento por proveedor No afecta inventario',
                'dpc_debe' => $deta['subtotximpcuenta'],//debe
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
    }

        //Ingresar los detalles de la partida para las retenciones
    foreach ($cnt_rets as $j => $deta) {
        $dpc_id_cnt = ($deta['dcr_id_cnt'] > 0) ? $deta['dcr_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $array_detalle = array(
                'dpc_id_cnt' => $dpc_id_cnt,//YA
                'dpc_id_pct' => $id_pct,//YA
                'dpc_concepto' => 'Documento por proveedor No afecta inventario',
                'dpc_debe' => 0.00,//debe
                'dpc_haber' => $deta['subtotxretcuenta'],
                'dpc_estado' => 1, //Cambio temporal para determinar que las retenciones restan al total @author: Mario Marquez
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
    }

    return array('id_pct' => $id_pct, 'total_haber' => $total_debe);
}

    /**
     *@return Elman Ortiz
     *@fecha 30/01/2018
     *@descripcion: Haber cuando NO afecta inventario por medio de documento por proveedor
     * prv_id = id del proveedor, id_pct = id de la partida contable, monto_haber = monto haber, tipo_pago si es credito o contado
     */
    function generar_partida_docprov_no_afecta_inv_haber($prv_id, $id_pct, $monto_haber, $tipo_pago){
        if($tipo_pago == 1){//Es contado
            $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CAJA'));
        }else{//Credito
            $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CUENTA_POR_PAGAR'));
        }

        $where = array('prv_id' => $prv_id, 'tcn_id' => $tipo_cuenta);
        //Obtener la cuenta
        $id_cuenta = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $id_cnt = $this->inventario_model->get_cuenta_contable($where);

        if(count($id_cnt) > 0){
            $id_cuenta = $id_cnt[0]['dfp_id_cnt'];
        }

        $array_detalle = array(
            'dpc_id_cnt' => $id_cuenta,//YA
            'dpc_id_pct' => $id_pct,//Ya
            'dpc_concepto' => 'Pago a Proveedor',
            'dpc_debe' => 0.00,//haber
            'dpc_haber' => $monto_haber,
            'dpc_estado' => 1,
            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
            'dpc_fecha_mod' => date('Y-m-d H:i:s'),
            'dpc_usu_crea' => $this->tank_auth->get_user_id(),
            'dpc_usu_mod' => $this->tank_auth->get_user_id()
        );
        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
    }//Fin haber partida contable cuando NO afecta inventario por medio de documento por proveedor

    public function get_tabla_prorrateo(){
        $this->load->model('facturacion_model');
        $bodega     = $this->input->post("bodega");
        $producto   = $this->input->post("producto");
        $total      = $this->input->post("total");
        $tabla      = $this->input->post("tabla");
        $row        = $this->input->post("row");
        $where      = null;
        //obtener prorrateo
        if ( $tabla != "") {
            $where['ptg_id'] = $tabla;
        } else {
            $where['dpa_id_art'] = $producto;
        }
                      $this->db->limit("1");
                      $this->db->order_by("ptg_id","asc");
                      $this->db->join("dpa_detalle_prorrateo_art","dpa_id_ptg = ptg_id");
        $prorrateo  = $this->gsatelite->get_campo("ptg_prorrateo_gasto","ptg_id", $where );
        $where      = null;
        if ($prorrateo != "") {
            //obtener la categoria del producto
            $articulo = $this->gsatelite->get_tabla("art_articulo",array("art_id" => $producto));
            //verificar si el productos es gasto o costo
            $tipo_cuenta_json = $this->gsatelite->get_parametro("SYS_TIPO_CUENTAS");
            $tipo_cuenta_obj = json_decode( $tipo_cuenta_json);
            if ( $articulo[0]["art_gasto"] == "1" ) {
                $tipo_cuenta = $tipo_cuenta_obj->GASTO;
            } else {
                $tipo_cuenta = $tipo_cuenta_obj->COSTO;
            }
             //obtener los detalle del prorrateo
            $where['dpr_id_ptg']    = $prorrateo;
            $sub_where              = "WHERE dta_id_cec = cec_id AND dta_id_bod = '".$bodega."' AND dta_id_tia = '".$articulo[0]["art_id_tia"]."' AND dta_id_tcn ='".$tipo_cuenta."'";
            $detalle_prorrateo      = $this->compras_model->get_detalle_prorrateo($where,$sub_where);            
            $data['detalles']       = $detalle_prorrateo;
            $data['producto']       = $producto;
            $data['total']          = $total;
            $data['row']          = $row;
            $html = $this->load->view('modulo_compras/procesos/tabla_prorrateo', $data, true);
            echo $html;
        } else{
            // CONFIGURAR EL CENTRO DE COSTO POR DEFECTO Y CUENTA
            $datos_empresa = $this->tank_auth->get_all_empresa();   //datos de la empresa
            $id_cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO', null);
            $empresa_id = $datos_empresa->emr_id;
            //CONFIGURACION DE PAISES
            $pais_defecto = '';
            $pais_usuario = $this->inventario_model->get_pais_usuario2(array('id' =>$this->tank_auth->get_user_id())); // pais de la persona logeada de la nacionalidad
            $id_pais_defecto = $datos_empresa->emr_id_pai; //pais ligada a la empresa
            if(count($pais_usuario) > 0){
                if($pais_usuario[0]['emp_id_pai'] != ''){
                    $pais_defecto =  $pais_usuario[0]['emp_id_pai'];                   
                } else{
                    $pais_defecto = $id_pais_defecto;            
                }                
            } else if($id_pais_defecto != ''){
                $pais_defecto = $id_pais_defecto;           
            } else{
                $select_pai = $this->gsatelite->get_campo('pai_pais', 'pai_id', array('pai_defecto'=>1));
                $pais_defecto = $select_pai;
            }
            // FIN DE CONFIGURACION DE PAISES
            $where_centro_costo = array('pai_id'=>$pais_defecto, 'cec_id_emr'=>$empresa_id, 'cnt_id'=>$id_cuenta_defecto);
            $centro_costo_reg = $this->facturacion_model->get_centro_costo_defecto($where_centro_costo);
            $detalle_prorrateo = $centro_costo_reg;
            // FIN DE CONFIGURAR EL CENTRO DE COSTO POR DEFECTO Y CUENTA
            $data['detalles']       = $detalle_prorrateo;
            $data['producto']       = $producto;
            $data['total']          = $total;
            $data['row']          = $row;
            $html = $this->load->view('modulo_compras/procesos/tabla_prorrateo', $data, true);
            echo $html;
        }
    }

    /**
     * @author Habby Lovo
     * @since 2018-02-20
     * @return
    */
    public function get_productos_like() {
        satelite_validar(true);
        $producto = ($this->input->post('producto') != '') ? $this->input->post('producto') : null;
        $servicio = ($this->input->post('servicio') != '') ? $this->input->post('servicio') : null;
        $modulo = ($this->input->post('otro') != '') ? $this->input->post('otro') : null;
        $where = null;
        $like = null;

        if ($producto != '') {
            if($modulo != null){
                // $where = array('art_estado'=>1);
                if($servicio == '2') {
                    $where = array('art_compra' => 1, 'art_tipo' => 1,'art_estado' => 1);
                } else if($servicio == '4'){
                    $where = array('art_compra' => 1,'art_estado' => 1);
                } else if($servicio == '3'){
                    $where = array('art_estado' => 1);
                    // $where = array('art_activo_fijo' => 1, 'art_tipo' => 0,'art_estado' => 1);
                } else {
                    $where = array('art_compra' => 1, 'art_tipo' => 0,'art_estado' => 1);
                }
            } else{
                if($servicio == '2') {
                    $where = array('art_compra' => 1, 'art_tipo' => 1,'art_estado' => 1);
                } else if($servicio == '4'){
                    $where = array('art_compra' => 1,'art_estado' => 1);
                } else {
                    $where = array('art_compra' => 1, 'art_tipo' => 0,'art_estado' => 1);
                }
            }

            // print_r($where);
            $like = "(art_nombre    LIKE '%".$producto."%' OR art_codigo   LIKE '%".$producto."%'
            OR art_sinonimo LIKE '%".$producto."%' OR cdp_codigo   LIKE '%".$producto."%')";
        }

        $arreglo = array();
        $productos = $this->compras_model->get_productos_like($where, $like);
        $extra = '';

        if (count($productos) > 0) {
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['art_id'];
                $arreglo[$key]['codigo'] = $value['art_codigo'];
                $extra = ($value['cdp_codigo']!='') ? $value['cdp_codigo'] : '';
                if ($value['art_sinonimo']!='') {
                    $extra = ($extra!='') ? $extra.'/ '.$value['art_sinonimo'] : $value['art_sinonimo'];
                }
                $extra = ($extra!='') ? ' ('.$extra.')' : '';
                $arreglo[$key]['prod_nombre'] = $value['art_nombre'].$extra;
/*
                $arreglo[$key]['precio'] = $value['sar_precio'];
                $arreglo[$key]['tipo'] = $value['art_tipo'];*/
            }


        }
        echo json_encode($arreglo);
    }

    public function cargar_impuestos_ajax(){
        satelite_validar(true);
        $producto  = ($this->input->post('producto')  != '') ? $this->input->post('producto') : null;
        $proveedor = ($this->input->post('proveedor') != '') ? $this->input->post('proveedor') : null;
        //Se obtienen los impuestos del tipo

        $categoria  = $this->gsatelite->get_campo("art_articulo","art_id_tia", array('art_id'=>$producto));

        /**** Impuestos del Producto *****/
        $this->db->join("ixr_impuestox_tipo_articulo", "ixr_id_imp = imp_id AND ixr_estado = 1", 'left');
        $impuestos_categoria = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado'=>1, 'ixr_id_tia'=>$categoria, 'IFNULL(imp_proceso_aplica,0) <>' => 1));
        
        /**** Impuestos Globales restantes *****/
      //  $this->db->join("ixr_impuestox_tipo_articulo", "ixr_id_imp = imp_id", 'left');
      //  $impuestos_ = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado'=>1, 'ixr_id IS NULL'=>null));
        $impuestos_ = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado'=>1, 'IFNULL(imp_proceso_aplica,0) <>' => 1));
        
        /**** Impuestos aplicables del proveedor ****/
        $this->db->join("ixp_impuestoxproveedor", "ixp_id_imp = imp_id AND ixp_estado = 1", 'left');
        $impuestos_proveedor = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado'=>1, "ixp_id_prv"=>$proveedor, 'IFNULL(imp_proceso_aplica,0) <>' => 1));

        /*******************************************************************************************************************/
        /* Obtener los impuestos de Proveedor y Categoria de producto                                                      */
        /*******************************************************************************************************************/
        $impuestos_merge = array_merge($impuestos_categoria, $impuestos_proveedor);
        $tempArr         = array_unique(array_column($impuestos_merge, 'imp_id'));
        $impuestos_array = array_intersect_key($impuestos_merge, $tempArr);
        /********************`***********************************************************************************************/
        /* Agregar los impuestos restantes                                                                                 */
        /*******************************************************************************************************************/
        $imp_temp        = array_merge($impuestos_array, $impuestos_);
        $imp_temp_       = array_unique(array_column($imp_temp, 'imp_id'));
        $impuestos_array = array_intersect_key($imp_temp, $imp_temp_);
        /*******************************************************************************************************************/

        $impuestos = "";
        if(count($impuestos_array) > 0){
            foreach ($impuestos_array as $key => $value) {
                $temp = (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]);
                if($temp != ''){
                    //$impuestos .= '<option data-id="' . $value['ixr_id'] . '" data-porcentaje="' . $value['imp_porcentaje'] . '" value="' . $value['imp_id'] . '" '.if($value["ixr_id"]){ echo "selected"}.'>' . $value['imp_nombre'] . '</option>';
                    if ((isset($value['ixr_id']) && $value['ixr_id']>0) || (isset($value['ixp_id']) && $value['ixp_id']>0)) {
                        $ixr = (isset($value['ixr_id'])) ? $value['ixr_id'] : "";
                        $impuestos .= '<option data-id="' . $ixr . '" data-porcentaje="' . (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]) . '" data-type="'.(((float)$value["imp_porcentaje"] != 0)?1:0).'" value="' . $value['imp_id'] . '" selected>' . $value['imp_nombre'] . '</option>';
                    } else {
                        $impuestos .= '<option data-id="" data-porcentaje="' . (((float)$value["imp_porcentaje"] != 0)?$value["imp_porcentaje"]:$value["imp_valor"]) . '" data-type="'.(((float)$value["imp_porcentaje"] != 0)?1:0).'" value="' . $value['imp_id'] . '" >' . $value['imp_nombre'] . '</option>';
                    }
                }
            }
        }
        echo json_encode(array('impuesto'=>$impuestos));
    }

    /**
     *@return Luis Navarro
     *@fecha 30/07/2018
     *@descripcion: Realizar la autorazion automatica de la requisicon
     */
    public function autorizar_requisicion_compras_automatica($registro = null, $tipo_flujo = null, $flujo = null) {
        // Obtener los pasos de seguimiento
        /*
        * Flujo: 1 = Requisicion de Compras
        */
        /******************************************************************************************/
        /* Obtener el paso actual de la requisicion                                               */
        // $paso_actual    = $this->inventario_model->get_paso_actual($registro, $tipo_flujo);
        $paso_actual    = $this->compras_model->get_paso_actual($registro, $tipo_flujo);
        if ($tipo_flujo === 1) {
            $paso_actual    = $paso_actual[0]['sgr_id'];
        } else {
            $paso_actual    = $paso_actual[0]['sgo_id'];
        }

        /******************************************************************************************/
        // Obtener el paso Siguiente de la requisicion
        // $paso_siguiente = $this->compras_model->get_paso_siguiente($registro,$tipo_flujo);
        $this->db->limit(1);
        $paso_siguiente    = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id_flu'=>$flujo, 'psf_orden'=>3));
        $paso_siguiente    = $paso_siguiente[0]['psf_id'];

        /******************************************************************************************/
        $Comentario_actual = 'Creacion de la requisicion';
        $comentario_sig    = 'Autorizacion de requsicion automatica';
        /******************************************************************************************/
        $orden_actual = 'Creacion de la Orden de Compra';
        $orden_sig    = 'Autorizacion de la Orden de Compra automatica';
        /******************************************************************************************/
        if (!count($paso_actual) > 0 && !count($paso_siguiente) > 0) {
            die("Error");
        }

        //Se cierra el paso actual y se ingresa el siguiente paso si existe
        switch ($tipo_flujo) {
            case 1:
                //Se cierra el paso actual
            $seguimiento_requisicion = array(
                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                'sgr_observacion' => $Comentario_actual,
                'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));

                //Si existe un siguiente paso se ingresa
            if ($paso_siguiente > 0) {
                $seguimiento_requisicion = array(
                    'sgr_id_rxi' => $registro,
                    'sgr_id_psf' => $paso_siguiente,
                    'sgr_id_usu' => $this->tank_auth->get_user_id(),
                    'sgr_observacion' => $comentario_sig,
                    'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                    'sgr_estado' => 1,
                    'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                    'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);

            }

                //Se actualiza el estado del registro
            $this->load->library('../controllers/modulo_compras/inicio');
            $this->inicio->cambiar_estado_registro($registro, $tipo_flujo, 3);
            break;
            case 2:
                //Se cierra el paso actual
            $seguimiento_array = array(
                'sgo_id_usu' => $this->tank_auth->get_user_id(),
                'sgo_observacion' => $orden_actual,
                'sgo_fecha_salida' => date('Y-m-d H:i:s'),
                'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $this->gsatelite->actualizar_array('sgo_seguimiento_orden', $seguimiento_array, array('sgo_id' => $paso_actual));

                //Si existe un siguiente paso se ingresa
            if ($paso_siguiente > 0) {
                $seguimiento_array = array(
                    'sgo_id_orc' => $registro,
                    'sgo_id_psf' => $paso_siguiente,
                    'sgo_id_usu' => $this->tank_auth->get_user_id(),
                    'sgo_observacion' => $orden_sig,
                    'sgo_fecha_entrada' => date('Y-m-d H:i:s'),
                    'sgo_estado' => 1,
                    'sgo_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgo_fecha_creacion' => date('Y-m-d h:i:s'),
                    'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_array);

            }

                //Se actualiza el estado del registro
            $this->load->library('../controllers/modulo_compras/inicio');
            $this->inicio->cambiar_estado_registro($registro, $tipo_flujo, 3);
            break;
        }
    }

    public function get_precio_ultima_entrada()
    {
        $id_articulo = $this->input->post('id_articulo');
        $unidad_medida = $this->input->post('unidad_medida');
        $where['dee_id_art'] = $id_articulo;
        $where['cva_id_mep'] = $unidad_medida;
        $where['tip_entrada'] = 1;

        $datos = $this->compras_model->get_precio_ultima_entrada($where);
        die(json_encode($datos));
    }

    public function get_permisos_padre_prod() {
        satelite_validar(true);
        /*      Obtener permisos para agregar producto        */
        /* ************************************************** */
        $permisos        = $this->gsatelite->get_permisos_opcion("modulo_compras/catalogos/articulo");
        $permite_agregar = (int)$permisos['permite_agregar'];
        /* ************************************************** */

        echo json_encode(array('permiso'=>$permite_agregar));
    }

    public function get_monto_detalle_dpv($tipo = "") {
        satelite_validar();
        $idDocumento        = $this->input->post('documento');
        $total              = 0;
        $where['dxd_id_dpv']= $idDocumento;
        $where['dxd_estado']= 1;

        if ( $tipo != "" ) {
            $where['art_tipo']  = $tipo;
        }

        if ($idDocumento > 0) {
            $this->db->join("art_articulo","art_id = dxd_id_art");
            $total = $this->gsatelite->get_suma('dxd_detalle_documento_proveedor', ' dxd_subtotal', $where );
        }
        echo json_encode($total);
    }

    public function generar_partida_contable_doc_proveedor_masiva(){
        if ($_POST) {
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');
            $periodo = $this->input->post('periodo');
            $this->load->model('contabilidad_model');
            $fecha_ini  = formatear_fecha('Y-m-d', '01-' .  $periodo);
            $fecha_fin  = formatear_fecha('Y-m-t', $fecha_ini);
            $where_docs = array('dpv_id_pct IS NULL' => null, 'DATE(dpv_fecha_contabilizacion) >=' => $fecha_ini, 'DATE(dpv_fecha_contabilizacion) <=' => $fecha_fin, 'dpv_estado >' => 0);
            $documentos = $this->gsatelite->get_tabla('dpv_documento_proveedor', $where_docs); 
            $respuestas = $procesadas = array();
            $where2['tcn_id']       = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('GASTO'));
            $where2['tcn_id_costo'] = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('COSTO')); 
            $where2['tcn_id_inv']   = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INVENTARIO_EN_TRANSITO'));  
            $where2['tcn_id_prv']   = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('CUENTA_POR_PAGAR'));
            $periodo  = $this->gsatelite->get_tabla('prc_periodo_contable', array('prc_estado' => 1));
            $defecto_cnt = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id'=>$this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
            foreach ($documentos as $key => $value) {
                $where = array('dpv_id' => $value['dpv_id']);
                $respuestas[$value['dpv_id']]['dt_articulos']  = $this->contabilidad_model->obtener_productosxdocproveedor_no_afecta_inv($where, 'dpv_id, cuenta_id', 'dxd_id', null, $where2);
                $respuestas[$value['dpv_id']]['impuestos']     = $this->contabilidad_model->obtener_impuestosxdocproveedor_no_afecta_inv($where, 'cxe_id_cnt, dpv_id', 'dxd_id');
                $respuestas[$value['dpv_id']]['retenciones']   = $this->contabilidad_model->obtener_retencioensxdocproveedor_no_afecta_inv($where, 'dcr_id_cnt, dpv_id', 'dxd_id');
                if ($value['dpv_id_cch'] != "") {
                    $respuestas[$value['dpv_id']]['cnt_haber'] = $this->contabilidad_model->obtener_haber_docproveedor_caja_chica($where, 'dpv_id', 'dpv_id'); 
                } else {
                    $respuestas[$value['dpv_id']]['cnt_haber'] = $this->contabilidad_model->obtener_haber_docproveedor($where, 'dpv_id', 'dpv_id', $where2);                    
                }
            }
            if (count($respuestas) > 0) {
                foreach ($respuestas as $key => $value) {
                    $id_tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('COSTO'))));
                    $origen      = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 1));
                    $orp_partida = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
                    $tbl_pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 8));
                    $pct_concepto = (count($tbl_pct_concepto) > 0) ? $tbl_pct_concepto[0]['ccp_descripcion_concepto'] : 'Concepto no definido';
                    $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
                    $numero         = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
                    $cod            = $numero;
                    $correlativo    = (int)($cod); 
                    $codigo         = $id_tipo_partida[0]['tpd_prefijo'] . '-' . $correlativo;
                                $this->db->join("prv_proveedor","dpv_id_prv = prv_id", "left");
                    $doc_prvd = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $key));
                    $nombre_proveedor = ($doc_prvd[0]['prv_tipo_pers'] > 1) ? $doc_prvd[0]["prv_apellido"] : $doc_prvd[0]["prv_nombre"] . " " . $doc_prvd[0]["prv_apellido"];
                    $fecha_documento  = formatear_fecha("d-m-Y", $doc_prvd[0]["dpv_fecha_contabilizacion"]);
                    $numero_documento = $doc_prvd[0]['dpv_numero_documento'];
                    $total_documento  = $doc_prvd[0]['dpv_total'] + $doc_prvd[0]['dpv_retencion'];
                    $modulo = ($doc_prvd[0]['dpv_id_cch'] != "") ? 11 : 6;
                    $concepto = $pct_concepto . ' con fecha ' . $fecha_documento . ' #' . $numero_documento . ' - ' . $nombre_proveedor;
                    $array_partida = array(
                        'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
                        'pct_id_prc'        => $periodo[0]['prc_id'],
                        'pct_concepto'      => $concepto,
                        'pct_id_orp'        => $orp_partida,
                        'pct_total'         => number_format($total_documento, 2, '.', ''),
                        'pct_fecha'         => formatear_fecha('Y-m-d', $fecha_documento),
                        'pct_correlativo'   => $correlativo,
                        'pct_codigo'        => $codigo,
                        'pct_modulo'        => $modulo,
                        'pct_estado'        => 1,
                        'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                        'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                        'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                        'pct_usu_mod'       => $this->tank_auth->get_user_id()
                    );
                    $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                    if ($agregar > 0) {
                        $detalle = 0;
                        foreach ($value['dt_articulos'] as $k1 => $value1) {
                            $array_detalle_dt = array(
                                'dpc_id_cnt'        => ($value1['cuenta_id'] > 0) ? $value1['cuenta_id'] : $defecto_cnt[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Documento por Proveedor #' . $numero_documento,
                                'dpc_debe'          => number_format($value1['subtotal_prod'], 2, '.', ''), 
                                'dpc_haber'         => number_format(0, 2, '.', ''), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );                        
                            $detalle += $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_dt);
                        }
                        if (count($value['impuestos']) > 0) {
                            foreach ($value['impuestos'] as $k2 => $value2) {
                                $array_detalle_im = array(
                                    'dpc_id_cnt'        => ($value2['cxe_id_cnt'] > 0) ? $value2['cxe_id_cnt'] : $defecto_cnt[0]['cnt_id'],
                                    'dpc_id_pct'        => $agregar,
                                    'dpc_concepto'      => 'Documento por Proveedor #' . $numero_documento,
                                    'dpc_debe'          => number_format($value2['subtotximpcuenta'], 2, '.', ''), 
                                    'dpc_haber'         => number_format(0, 2, '.', ''), 
                                    'dpc_estado'        => 1,
                                    'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                    'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                    'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                    'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                                );                        
                                $detalle += $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_im);
                            }
                        }
                        foreach ($value['cnt_haber'] as $k3 => $value3) {
                            $array_detalle_hb = array(
                                'dpc_id_cnt'        => ($value3['cnt_id'] > 0) ? $value3['cnt_id'] : $defecto_cnt[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Documento por Proveedor #' . $numero_documento,
                                'dpc_debe'          => number_format(0, 2, '.', ''), 
                                'dpc_haber'         => number_format($value3['total'], 2, '.', ''), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );                        
                            $detalle += $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_hb);
                        }
                        if (count($value['retenciones']) > 0) {
                            foreach ($value['retenciones'] as $k4 => $value4) {
                                $array_detalle_rt = array(
                                    'dpc_id_cnt'        => ($value4['dcr_id_cnt'] > 0) ? $value4['dcr_id_cnt'] : $defecto_cnt[0]['cnt_id'],
                                    'dpc_id_pct'        => $agregar,
                                    'dpc_concepto'      => 'Documento por Proveedor #' . $numero_documento,
                                    'dpc_debe'          => number_format(0, 2, '.', ''), 
                                    'dpc_haber'         => number_format($value4['subtotxretencion'], 2, '.', ''), 
                                    'dpc_estado'        => 1,
                                    'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                    'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                    'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                    'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                                );                        
                                $detalle += $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_rt);
                            }
                        }
                        $this->gsatelite->actualizar_array('dpv_documento_proveedor',array('dpv_id_pct' => $agregar), array('dpv_id' => $key));
                        $procesadas[] = $agregar;
                    }
                }
            }
            echo json_encode(array('cantidad_partidas' => count($procesadas)));
            die();
        }

    } 

    public function generar_partida_contable_doc_proveedor() {

        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die('text');

            //Se obtienen los documentos que no tienen partida y no afectan inventario
            $lstDocNoInventario = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_pct IS NULL' => null, 'dpv_afecta_inventario' => 0));

            $lstDocInventario = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_pct IS NULL' => null, 'dpv_afecta_inventario' => 1));

            $PartidasIds = array();
            //Se procesan las partidas que no afectan inventario
            if (count($lstDocNoInventario) > 0) {
                foreach ($lstDocNoInventario as $doc) {
                    $where['dpv_id'] = $doc['dpv_id'];
                    $info['num_doc_provedor'] = $doc['dpv_numero_documento'];
                    $info['fecha_doc_provedor'] = $doc['dpv_fecha_documento'];
                    
                    $data_proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $doc['dpv_id_prv']));
                    
                    $data_doc = array(
                      'nombre_com'   => ($data_proveedor[0]['prv_tipo_pers'] == 1) ? $data_proveedor[0]['prv_nombre'] . ' '. $data_proveedor[0]['prv_apellido'] : $data_proveedor[0]['prv_apellido'],
                      'fecha_doc' => formatear_fecha('d-m-Y', $doc['dpv_fecha_documento']),
                      'dpv_numero' => $doc['dpv_numero_documento']
                  );
                    
                    $res_debe = $this->generar_partida_docprov_no_afecta_inv_debe($where, $info, $data_doc);
                    $this->generar_partida_docprov_no_afecta_inv_haber($doc['dpv_id_prv'], $res_debe['id_pct'], $res_debe['total_haber'], $doc['dpv_id_tpg']);
                    //Se asocia la partida con el documento
                    $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct' => $res_debe['id_pct']), array('dpv_id' => $doc['dpv_id']));

                    $PartidasIds[] = array('dpv_id' => $doc['dpv_id'], 'pct_id' =>  $res_debe['id_pct'], 'tipo' => 'No Afecta Inventario');
                }
            }

            //Se procesan las partidas que afectan inventario
            if (count($lstDocInventario) > 0) {
                foreach ($lstDocInventario as $doc) {

                    //Se genera la partida del documento
                    $where['dpv_id'] = $doc['dpv_id'];
                    $info['num_doc_provedor'] = $doc['dpv_numero_documento'];
                    $info['fecha_doc_provedor'] = $doc['dpv_fecha_documento'];
                    
                    $data_proveedor = $this->gsatelite->get_tabla('prv_proveedor', array('prv_id' => $doc['dpv_id_prv']));
                    
                    $data_doc = array(
                      'nombre_com'   => ($data_proveedor[0]['prv_tipo_pers'] == 1) ? $data_proveedor[0]['prv_nombre'] . ' '. $data_proveedor[0]['prv_apellido'] : $data_proveedor[0]['prv_apellido'],
                      'fecha_doc' => formatear_fecha('d-m-Y', $doc['dpv_fecha_documento']),
                      'dpv_numero' => $doc['dpv_numero_documento']
                  );

                    //Se obtienen los movimientos del documento
                    $this->db->join('tip_tipo_proceso','tip_id = moi_id_tip','inner');
                    $lstMovimientos = $this->gsatelite->get_tabla('moi_movimiento_inv', array('moi_id_dpv' => $doc['dpv_id'], 'moi_id_pct IS NULL' => null,'tip_entrada' => 1 ));

                    //============= Generar asiento afecta inventario documento por proveedor============//
                    $n_mov=0;
                    $id_partida_mov = 0;
                    foreach ($lstMovimientos as $moi) {
                        $n_mov++;
                        $doc_referencia = ($doc['dpv_numero_documento'] != '') ? $doc['dpv_numero_documento'] : null; //Es lo que identifica al documento

                        $res_debe = $this->generar_partida_docprov_afecta_inv_debe($moi['moi_id'], $doc_referencia, $data_doc);
                        $this->generar_partida_docprov_afecta_inv_haber($doc['dpv_id_prv'], $res_debe['id_pct'], $res_debe['total_haber']); //Proveedor, idpartida
                        $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_debe['id_pct']), array('moi_id' => $moi['moi_id']));
                        if ($n_mov == 1) { //en la primera partida actualizar el dpv
                            $id_partida_mov = $res_debe['id_pct'];
                        }
                    }
                    //==============Generar asiento afecta inventario documento por proveedor===========//
                    //Se asocia la partida con el documento
                    if ($id_partida_mov > 0) {
                        $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct' => $id_partida_mov), array('dpv_id' => $doc['dpv_id']));
                    }
                   // $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_id_pct' => $res_debe_partida['id_pct']), array('dpv_id' => $doc['dpv_id']));

                    $PartidasIds[] = array('dpv_id' => $doc['dpv_id'], 'pct_id' => $res_debe_partida['id_pct'], 'tipo' => 'Afecta Inventario');
                }
            }
            echo json_encode(array('cantidad_partidas' => count($PartidasIds)));
            die();
        }
        echo 'Haz un metodo POST';
    }

    public function generar_partida_contable_caja_chica() {

        if ($this->input->post()) {
            $PartidasIds = array();
            $post_array = $this->input->post();
            //Se obtienen los cierres de caja chica sin partidas
            //Se obtienen los documentos que no tienen partida y no afectan inventario
            $lstCierreCajaChica = $this->gsatelite->get_tabla('cjc_cierre_caja_chica', array('cjc_id_pct IS NULL' => null));

            $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
            $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
            if (count($consultar) > 0) {
                $id_tipo_partida = $tipo_partida;
            }

            //Concepto por factura sin afectar inventario
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 18));
            if (count($pct_concepto) > 0) {
                $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
            } else {
                $pct_concepto = 'Concepto no definido';
            }

            foreach ($lstCierreCajaChica as $cierre) {

                $corr = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
                $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);

                $array_partida = array(
                    'pct_id_tpd' => $id_tipo_partida,
                    //'pct_id_prc' => $this->input->post('id_prc'),
                    'pct_id_orp' => null,
                    'pct_concepto' => $pct_concepto,
                    'pct_total' => number_format($cierre['cjc_total_liquidacion'], 4, '.', ''),
                    'pct_fecha' => $cierre['cjc_fecha_cierre'],
                    'pct_correlativo' => $corr->correlativo,
                    'pct_codigo' => $corr->correlativo,
                    'pct_estado' => 1,
                    'pct_fecha_crea' => date('Y-m-d H:i:s'),
                    'pct_fecha_mod' => date('Y-m-d H:i:s'),
                    'pct_usu_crea' => $this->tank_auth->get_user_id(),
                    'pct_usu_mod' => $this->tank_auth->get_user_id()
                );

                $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

                //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
                //$tipo_cuenta_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
                $tipo_cuenta_debe = $tipo_cuenta_haber = $tipo_cuenta_debe = $this->gsatelite->get_parametro('SYS_CUENTAS_CAJA_CHICA', null, null, array('DEBE'));;

                //Se ingresa el detalle del DEBE
                $array_detalle = array(
                    'dpc_id_cnt' => $tipo_cuenta_debe,
                    'dpc_id_pct' => $pct_id,
                    'dpc_concepto' => $pct_concepto,
                    'dpc_debe' => number_format($cierre['cjc_total_liquidacion'], 4, '.', ''),
                    'dpc_haber' => 0.00,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);

                //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
                //$tipo_cuenta_debe = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('BANCOS'));
                $tipo_cuenta_haber = $tipo_cuenta_debe = $this->gsatelite->get_parametro('SYS_CUENTAS_CAJA_CHICA', null, null, array('HABER'));;

                //Se ingresa el detalle del HABER
                $array_detalle = array(
                    'dpc_id_cnt' => $tipo_cuenta_haber, //YA
                    'dpc_id_pct' => $pct_id,
                    'dpc_concepto' => $pct_concepto,
                    'dpc_debe' => 0.00,
                    'dpc_haber' => number_format($cierre['cjc_total_liquidacion'], 4, '.', ''),
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);

                //Se asocia la partida con el documento
                $this->gsatelite->actualizar_array('cjc_cierre_caja_chica', array('cjc_id_pct' => $pct_id), array('cjc_id' => $cierre['cjc_id']));

                $PartidasIds[] = array('registro_id' => $cierre['cjc_id'], 'pct_id' => $pct_id, 'tipo' => 'Caja Chica');
            }

            echo json_encode(array('cantidad_partidas' => count($PartidasIds)));
            die();
        }
    }

    public function grid_quedan_form($id){
        satelite_validar();
        $data['id'] = $id;
        $data['dpv'] = $this->compras_model->get_quedan(array('dpv_id' => $id));
        $data['quedans'] = $this->gsatelite->get_tabla('qda_quedan', array('qda_id_dpv' => $id));
        $data['titulo_personal']= 'Listado de Quedan';
        $this->_cargarvista($data);
    }

    public function agregar_quedan($dpvid = null, $qdaid = null){
        satelite_validar();
        if ($_POST) {
            $observacion = $this->input->post('txtObservacion');
            $max = number_format($this->gsatelite->get_max('qda_quedan', 'qda_id'));
            $correlativo = $max + 1;
            $quedan_array = array(
                'qda_id_dpv' => $dpvid,
                'qda_usu_genera' => $this->tank_auth->get_user_id(),
                'qda_correlativo' => $correlativo,
                'qda_fecha' => date('Y-m-d H:i:s'),
                'qda_observacion' => $observacion,
                'qda_estado' => 1,
                'qda_usu_creacion' => $this->tank_auth->get_user_id(),
                'qda_fecha_creacion' => date('Y-m-d H:i:s'),
                'qda_usu_modificacion' => $this->tank_auth->get_user_id(),
                'qda_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $resultado = $this->gsatelite->ingresar('qda_quedan', $quedan_array);
            if ($resultado > 0) {
                $this->session->set_flashdata('id_quedan', $resultado);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al guardar", 'texto_alerta' => "No se pudo crear el documento");
                $this->session->set_flashdata($alerta);
            } 
            redirect('/modulo_compras/procesos/grid_quedan_form/' . $dpvid);
            // $fechapago   = $this->input->post('txtFechaPago') != null ? $this->input->post('txtFechaPago')   : null;
            // $dias        = $this->input->post('txtCancelacion') != null ? $this->input->post('txtCancelacion') : null;
            // $fecha_vencimiento_dpv = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_fecha_vencimiento', array('dpv_id'=>$id_doc_proveedor));
            // $dia_semana = formatear_fecha('w', $fecha_vencimiento_dpv);
            // $dia_pago = "";
            //despues imprimirlo LLAMAR A IMPRIMIR QUEDAN
            // $filename = 'quedan_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            // $data['filename'] = $filename;
            // $tipo_documento_nit = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NIT_PROVEEDOR');
        } else {
            $dato_dpv = $this->compras_model->get_quedan(array('dpv_id' => $dpvid));
            $data['quedan'] = ($qdaid != null) ? $this->gsatelite->get_tabla('qda_quedan', array('qda_id' => $qdaid)) : array();
            $data['ver'] = ($qdaid != null) ? 1 : 0;
            $data['dato_dpv'] = $dato_dpv[0];
            $data['titulo_personal']= 'Nuevo Quedan';
            $this->_cargarvista($data);
        }        
    }

    public function anular_quedan($dpvid, $qdaid){
        satelite_validar();
        if ($_POST) {
            $motivo = $this->input->post('motivo');
            $quedan_array = array(
                'qda_usu_anulacion' => $this->tank_auth->get_user_id(),
                'qda_motivo_anulacion' => $motivo,
                'qda_estado' => 0,
                'qda_usu_modificacion' => $this->tank_auth->get_user_id(),
                'qda_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('qda_quedan', $quedan_array, array('qda_id' => $qdaid, 'qda_id_dpv' => $dpvid));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Anulación", 'texto_alerta' => "Se ha anulado el documento");
            $this->session->set_flashdata($alerta);
            redirect('/modulo_compras/procesos/grid_quedan_form/' . $dpvid);
        }            
    }

    public function quedan_form($id = null) {
        $data['id'] = $id;
        $data['tittle'] = "Quedan";
        $fecha_vencimiento = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_fecha_vencimiento', array('dpv_id'=>$id));
        $dia_semana = formatear_fecha('w', $fecha_vencimiento);
        $dia = "";
        switch ($dia_semana){ 
            case 0: $dia = "Domingo"; break; 
            case 1: $dia = "Lunes"; break; 
            case 2: $dia = "Martes"; break; 
            case 3: $dia = "Miercoles"; break; 
            case 4: $dia = "Jueves"; break; 
            case 5: $dia = "Viernes"; break; 
            case 6: $dia = "Sabado"; break; 
        } 
        $data['fecha_vencimiento'] = $fecha_vencimiento;
        $data['dia'] = $dia;
        $html = $this->load->view('modulo_compras/procesos/quedan_form.php',$data, true);
        echo $html;die();
    }

    //René Castaneda
    //Generar partida contable caja chica de manera individual
    public function generar_partida_contable_caja_chica_individual($where_cierre){
        $lstCierreCajaChica = $this->gsatelite->get_tabla('cjc_cierre_caja_chica', $where_cierre);
        $cierre = $lstCierreCajaChica[0];
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
        $tcn_cch_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('FONDOS_CAJA_CHICA'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $tipo_partida));
        if (count($consultar) > 0) {
            $id_tipo_partida = $tipo_partida;
        }

        //Concepto por factura sin afectar inventario
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 18));
        if (count($pct_concepto) > 0) {
            $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        } else {
            $pct_concepto = 'Concepto no definido';
        }

        $corr = $this->db->select('IFNULL(MAX(pct_correlativo)+1,1) as correlativo', false)->from('pct_partida_contable')->get()->row();
        $numero = str_pad($corr->correlativo, 5, '0', STR_PAD_LEFT);

        $array_partida = array(
            'pct_id_tpd' => $id_tipo_partida,
            'pct_concepto' => $pct_concepto,
            'pct_total' => number_format($cierre['cjc_total_liquidacion'], 4, '.', ''),
            'pct_fecha' => $cierre['cjc_fecha_cierre'],
            'pct_correlativo' => $corr->correlativo,
            'pct_codigo' => $corr->correlativo,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id()
        );
        $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
        $cuenta_defecto_partida = $this->gsatelite->get_parametro("SYS_CUENTA_DEFECTO");
        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        // $tipo_cuenta_debe = $tipo_cuenta_debe = $this->gsatelite->get_parametro('SYS_CUENTAS_CAJA_CHICA', null, null, array('DEBE'));;
        $where = $where2 = $where_cierre;
        $where['cnj_id_tcn'] = $tcn_cch_id;
        $where['cnj_tipo_proceso'] = 1;
        $cuenta_debe = $this->compras_model->get_config_cnj($where);
        //Se ingresa el detalle del DEBE
        $array_detalle = array(
            // 'dpc_id_cnt' => ($tipo_cuenta_debe > 0)? $tipo_cuenta_debe:$cuenta_defecto_partida,
            'dpc_id_cnt' => (count($cuenta_debe) > 0) ? $cuenta_debe[0]['cnj_id_cnt'] : $cuenta_defecto_partida,
            'dpc_id_pct' => $pct_id,
            'dpc_concepto' => $pct_concepto,
            'dpc_debe' => number_format($cierre['cjc_total_liquidacion'], 4, '.', ''),
            'dpc_haber' => 0.00,
            'dpc_estado' => 1,
            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
            'dpc_fecha_mod' => date('Y-m-d H:i:s'),
            'dpc_usu_crea' => $this->tank_auth->get_user_id(),
            'dpc_usu_mod' => $this->tank_auth->get_user_id()
        );
        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);

        //Se ha definido tipo de cuenta de CAJA siempre sin importar el tipo de pago
        // $tipo_cuenta_haber = $this->gsatelite->get_parametro('SYS_CUENTAS_CAJA_CHICA', null, null, array('HABER'));;
        $where2['cnj_id_tcn'] = $tcn_cch_id;
        $where2['cnj_tipo_proceso'] = 2;
        $cuenta_haber = $this->compras_model->get_config_cnj($where2);
        //Se ingresa el detalle del HABER
        $array_detalle = array(
            'dpc_id_cnt' => (count($cuenta_haber) > 0) ? $cuenta_haber[0]['cnj_id_cnt'] : $cuenta_defecto_partida,
            'dpc_id_pct' => $pct_id,
            'dpc_concepto' => $pct_concepto,
            'dpc_debe' => 0.00,
            'dpc_haber' => number_format($cierre['cjc_total_liquidacion'], 4, '.', ''),
            'dpc_estado' => 1,
            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
            'dpc_fecha_mod' => date('Y-m-d H:i:s'),
            'dpc_usu_crea' => $this->tank_auth->get_user_id(),
            'dpc_usu_mod' => $this->tank_auth->get_user_id()
        );
        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        //Se asocia la partida con el documento
        $this->gsatelite->actualizar_array('cjc_cierre_caja_chica', array('cjc_id_pct' => $pct_id), array('cjc_id' => $cierre['cjc_id']));
        return $pct_id;
    }

    public function prueba_correo($saludo='test'){
       $exito = $this->gsatelite->envio_correo("rene.castaneda@gruposatelite.net", "byron.beltran@gruposatelite.net","ENVIO CORREO", 'TEST',"rene.castaneda@gruposatelite.net");
       echo $exito;
   }

    /** 
        * @author Francisco Orozco
        * @since: 21/02/2019
        * Descripcion: Se obtienen los presupuestos que depende de un proyecto
        * @return presupuestos
    */
    public function get_presupuestoxproyecto($proyecto = "", $seleccionado = "" , $evaluar_post = true) {
        if ($_POST && $evaluar_post) { 
            $proyecto = ($this->input->post('proyecto') != false)? $this->input->post('proyecto'): $proyecto;
        }
        $where = array(
            'psp_estado'            => 1,
            'psp_id_pcl'            => $proyecto,
            'psp_estado_prespuesto' => 2
        );
                          $this->db->join('are_area', 'are_id = psp_id_are');  
        $presupuestos   = $this->gsatelite->get_tabla("psp_presupuesto",$where);
        $html           = '<option value=""></option>';
        foreach ($presupuestos as $value) {
            $selected   = "";
            if ( $value['psp_id'] == $seleccionado) {
                $selected = "selected";
            }
            $html .= '<option value="'.$value['psp_id'].'" '.$selected.' data-area="'.$value['are_nombre'].'">'.$value['psp_nombre'].'</option>';
        }
        if ($_POST && $evaluar_post) {
            echo trim($html);
        } else {
            return trim($html);
        }       
    }

    /**
        * @author Francisco Orozco
        * @since: 21/02/2019
        * Descripcion: Se obtienen las actividades general de un presupuesto
        * @return actividades generales
    */
    function get_actividades_generalesxpresupusto($presupuesto = "", $seleccionado = "", $evaluar_post = true, $evaluar_usuario = true) {
        satelite_validar();
        if ($_POST && $evaluar_post) { 
            $presupuesto = $this->input->post('presupuesto');
        }
        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto
        );
        $select                 = "*, 
        (
        sum(dps_presupuesto_actividad) - IFNULL(
        (
        SELECT
        SUM(dgp_monto)
        FROM
        dgp_detalle_gasto_prespuesto
        WHERE
        dgp_id_dps = dps_id
        AND dgp_estado = 1
        ),
        0
        )
        ) AS total,
        (
        SELECT
        IFNULL(
        (
        sum(orc_total) - sum(dpv_total)
        ) + sum(dpv_monto_pendiente),
        0
        )
        FROM
        orc_orden_compra
        LEFT JOIN dpv_documento_proveedor ON dpv_id_orc = orc_id
        WHERE
        orc_id_psp = dps_id_psp
        AND orc_id_acg = dps_id_acg
        AND dpv_id = NULL
        ) AS monto_comprometido,
        (
        SELECT
        GROUP_CONCAT(uxa_id_usu)
        FROM
        uxa_usuarioxactividad_general
        WHERE
        uxa_id_acg = acg_id
    ) AS usuarios";
    $group_by               = "acg_id";
    $actividades_generales  = $this->compras_model->get_actividades_x_presupusto($select,$where,$group_by); 

    $html                   = '<option value=""></option>';
    foreach ($actividades_generales as $value) {
        $selected           = "";
        $usuarios_permitidos = array( $this->tank_auth->get_user_id() );
        if ($evaluar_usuario == true) {
            $usuarios_permitidos= explode(",",$value['usuarios']); 
        } 

        $disponible = $value['total'] - $value['monto_comprometido'];
        if ( $value['acg_id'] == $seleccionado) {
            $selected = "selected";
        }
        if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
            $html .= '<option value="'.$value['acg_id'].'" '.$selected.'>'.$value['acg_codigo'].' - '.$value['acg_nombre'].' ($'.number_format( $disponible,2,".",",").')</option>';
        }
    }
    if ($_POST && $evaluar_post) {
        echo trim($html);
    } else {
        return trim($html);
    }   
}

    /**
        * @author Francisco Orozco
        * @since: 21/02/2019
        * Descripcion: Se obtienen las actividades especificas de un de una actividad general
        * @return actividades especificas
    */
    function get_actividades_especificas_x_actividad_general($general = "", $presupuesto = "", $seleccionado = "", $edicion = false, $evaluar_post = true, $evaluar_usuario = true) {
        satelite_validar();
        
        if ($_POST && $evaluar_post) { 
            $general    = ($this->input->post('general') != false)? $this->input->post('general'): $general;
            $presupuesto= ($this->input->post('presupuesto') != false)? $this->input->post('presupuesto'): $presupuesto;
            $periodo    = ($this->input->post('fecha') != false)? date('Ym', strtotime( $this->input->post('fecha') )): date('Ym');
            $fecha      = ($this->input->post('fecha') != false)? date('Y-m-d', strtotime( $this->input->post('fecha') )): date('Y-m-d');
        } else {
            $periodo    = date('Ym');
            $fecha      = date('Y-m-d');
        }

        $where = array(
            'dps_estado'    => 1,
            'dps_id_psp'    => $presupuesto,
            'dps_id_acg'    => $general
        );
        $group_by               = "ace_id";
        $actividades_generales  = $this->compras_model->get_actividades_especificas_x_actividad_general($fecha, $periodo, $where, $group_by);  
        $html                   = '<option value=""></option>';
        foreach ($actividades_generales as $value) {
            $selected           = "";
            $usuarios_permitidos = array( $this->tank_auth->get_user_id() );
            if ($evaluar_usuario == true) {
                $usuarios_permitidos= explode(",",$value['usuarios_permitidos']); 
            } 
            $disponible         = ($value['total'] - $value['monto_comprometido']) ;
            $disponible_mensual = "";
            //if ( $value['planes'] > 0 ) {
            $disponible_mensual = $value['permitido'] - ($value['monto_comprometido_mensual'] + $value['monto_pagado_mensual']);
            $disponible_mensual = number_format($disponible_mensual,2,".",",");
            //}
            if ( $value['ace_id'] == $seleccionado) {
                $selected = "selected";
            }
            if ( in_array( $this->tank_auth->get_user_id(), $usuarios_permitidos ) ) {
                if ($disponible > 0 or $edicion == true) {
                    $html .= '<option data-monto_disponible_mensual="'.$disponible_mensual.'" data-monto_disponible="'.number_format($disponible,2,".","").'" data-nombre="'.$value['ace_nombre'].'" value="'.$value['ace_id'].'" '.$selected.'>'.$value['ace_codigo'].' - '.$value['ace_nombre'].' ('.number_format($disponible,2,".",",").')</option>';
                }
            }
        }
        if ($_POST && $evaluar_post) {
            echo trim($html);
        } else {
            return trim($html);
        }   
    }
    
    /**
        * @author Francisco Orozco
        * @since: 27/04/2019
        * Descripcion: Se obtienen los presupuestos, las actividades generales y las actividades especifas
        * @return JSON 
    */
    public function get_datos_proyectos() {
        $proceso                = $this->input->post("tipo");
        $id                     = $this->input->post("codigo");
        $proyecto               = ""; 
        $resultado['info']      = false;    
        switch ($proceso) {
            case 1: //Requisición
            $requisicion = $this->gsatelite->get_tabla("rxi_requisicion_inventario",array("rxi_id" => $id) );
            if (count($requisicion) > 0 ) {
                    //busca en la tabla la existencia de el proyecto (Marlon Olmedo)
                $slc_proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id' => $requisicion[0]['rxi_id_pcl']) );
                    //si existen los datos los imprime en concatenacion, de lo contrario envia un option (Marlon Olmedo)
                $resultado['proyectos']     = (count($slc_proyectos) != 0)?'<option value="'.$slc_proyectos[0]['pcl_id'].'">'.$slc_proyectos[0]['pcl_codigo'].'-'.$slc_proyectos[0]['pcl_nombre'].'</option>':'<option value=""></option>';
                $slc_presupuesto            = ($requisicion[0]['rxi_id_psp'] != "" )?$this->get_presupuestoxproyecto($requisicion[0]['rxi_id_pcl'], $requisicion[0]['rxi_id_psp'],false):'<option value=""></option>';
                $resultado['presupuesto']   = $slc_presupuesto;
                $slc_general                = ($requisicion[0]['rxi_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($requisicion[0]['rxi_id_psp'], $requisicion[0]['rxi_id_acg'],false,false):'<option value=""></option>';
                $resultado['general']       = $slc_general;
                $slc_especifica             = ($requisicion[0]['rxi_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($requisicion[0]['rxi_id_acg'], $requisicion[0]['rxi_id_psp'], $requisicion[0]['rxi_id_ace'],true,false):'<option value=""></option>';
                $resultado['especifica']    = $slc_especifica;
                $resultado['info']          = true;
            }
            break;           
            case 2: //documento proveedor
            $doc_proveedor          = $this->gsatelite->get_tabla("dpv_documento_proveedor",array('dpv_id' => $id) );
            if ( count($doc_proveedor) > 0 ) {  
                $slc_presupuesto            = ($doc_proveedor[0]['dpv_id_psp'] != "" )?$this->get_presupuestoxproyecto($doc_proveedor[0]['dpv_id_pcl'], $doc_proveedor[0]['dpv_id_psp'],false):'<option value=""></option>';
                $resultado['presupuesto']   = $slc_presupuesto;
                $slc_general                = ($doc_proveedor[0]['dpv_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_acg'],false,false):'<option value=""></option>';
                $resultado['general']       = $slc_general;
                $slc_especifica             = ($doc_proveedor[0]['dpv_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($doc_proveedor[0]['dpv_id_acg'], $doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_ace'],true,false):'<option value=""></option>';
                $resultado['especifica']    = $slc_especifica;
                $resultado['info']          = true;
            }
            break; 
        }   
/*        print_r($resultado['proyectos']);
die();*/
echo json_encode($resultado);
die();
}

    /**
        * @author Francisco Orozco 
        * @since  29/03/2019
        * @return vista del detalle maestro de comparativo
    */
    public function comparar_cotizaciones($consulta = 0) {
        satelite_validar();
        if ($_POST) { 
            if ($consulta > 0) {

                $slc_requisicion    = $this->input->post('slc_requisicion');
                $fecha_inicio       = $this->input->post('fecha_ini');
                $fecha_fin          = $this->input->post('fecha_fin');
                $slc_sucursal       = $this->input->post('slc_sucursal');

                $where = null;

                if ($slc_requisicion != '') {
                    $where['ccc_id_rxi'] = $slc_requisicion;
                }

                if ($slc_sucursal != '') {
                    $where["ccc_id_usu_crea IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp  WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                }

                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $where['DATE(rxi_fecha) >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['DATE(rxi_fecha) <='] = date('Y-m-d', strtotime($fecha_fin));
                }

                $autorizar_str      = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
                $autorizar_array    = explode(",",$autorizar_str);
                $roles_array        = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                $autorizar          = false;

                foreach ($roles_array as $rol) {
                    if (in_array($rol["uxr_id_rol"], $autorizar_array)) {
                        $autorizar = true;
                    }
                }   

                if ( $autorizar == false) { 
                    $where['ccc_usu_creacion']  = $this->tank_auth->get_user_id();
                }

                $where['scm_fecha_salida']  = null;
                $data2['detalles']          = $this->compras_model->get_backlog_comparativos($where);                                          
                $data2['autorizar']         = $autorizar;
                $html                       = $this->load->view('modulo_compras/procesos/detalle_comparativo_cotizaciones', $data2, true);

                echo $html;
                die();
            }

        } else{
            $empleado           = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$this->tank_auth->get_user_id()));
            $sucursal_dropdown  = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', $empleado[0]['emp_id_suc'], '', 'suc_id', true);
            $data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_dropdown);

            $this->db->join("ccc_comparativo_cotizacion_compra","ccc_id_rxi = rxi_id");
            $this->db->join("users","id = rxi_usu_creacion");
            $requisicion_dropdown  = $this->gsatelite->get_dropdown('rxi_requisicion_inventario', '{rxi_numero} - {username}', '', '', '', '', 'rxi_id', true);
            $data['requisiciones'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $requisicion_dropdown);

            $permisos           = $this->gsatelite->get_permisos_opcion();
            $data['agregar']    = false;

            if ($permisos['permite_agregar']) {
                $data['agregar'] = true;
            }

            $data['tabla']          = $tabla;
            $data['titulo_personal']= 'Comparativo de cotización';
            $this->_cargarvista($data);
        }
    }

    /**
        * @author Francisco Orozco 
        * @since  29/03/2019
        * @return vista para crear comparativo
    */
    public function crear_comparativo() {
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');  
        ini_set( 'max_input_vars', '2500' );
        if ( $_POST) {
            $envio_aprobacion   = $this->input->post("txt_envio_aprobacion");
            $requisicion        = $this->input->post("txt_requisicion");         
            $sub_total          = $this->input->post("txt_sub_total");
            $descuento          = $this->input->post("txt_descuentos");
            $impuesto           = $this->input->post("txt_impuestos");
            $total              = $this->input->post("txt_total");
            $fechas_cotizaciones= $this->input->post("txt_fecha_cotizacion");

            usort($fechas_cotizaciones, function ( $a, $b ) {
                return strtotime($a) - strtotime($b);
            });

            $flujos             = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO',4);
            $flujos_array       = json_decode($flujos, true);
            $fecha_inicio       = date('Y-m-d', strtotime($fechas_cotizaciones[0]));
            $fechas_cotizaciones= array_reverse($fechas_cotizaciones);
            $fecha_fin          = date('Y-m-d', strtotime($fechas_cotizaciones[0]));
            
            $ccc_comparativo_cotizacion_compra  = array(
                'ccc_id_rxi'                => $requisicion,
                'ccc_id_usu_crea'           => $this->tank_auth->get_user_id(),
                'ccc_id_flu'                => $flujos_array['COMPARATIVO_COMPRA'],
                'ccc_fecha'                 => date('Y-m-d H:i:s'),
                'ccc_fecha_inicio'          => $fecha_inicio,
                'ccc_fecha_fin'             => $fecha_fin,
                'ccc_observacion'           => "",
                'ccc_observacion_autoriza'  => "",
                'ccc_observacion_rechaza'   => "",
                'ccc_subtotal'              => $sub_total,
                'ccc_descuento'             => $descuento,
                'ccc_impuesto'              => $impuesto,
                'ccc_total'                 => $total,
                'ccc_estado'                => 1,
                'ccc_usu_creacion'          => $this->tank_auth->get_user_id(),
                'ccc_fecha_creacion'        => date('Y-m-d H:i:s'),
                'ccc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'ccc_fecha_modificacion'    => date('Y-m-d H:i:s')
            );

            $ccc_id     = $this->gsatelite->ingresar('ccc_comparativo_cotizacion_compra', $ccc_comparativo_cotizacion_compra);
            //primer paso en el flujo
            $primer_paso= $this->inventario_model->get_primer_paso_flujo($flujos_array['COMPARATIVO_COMPRA']);
            if (count($primer_paso) > 0) {
                $scm_seguimiento_comparativo_compra = array(
                    'scm_id_ccc'            => $ccc_id,
                    'scm_id_psf'            => $primer_paso[0]['psf_id'],
                    'scm_id_usu'            =>  $this->tank_auth->get_user_id(),
                    'scm_fecha_entrada'     => date('Y-m-d H:i:s'),
                    'scm_estado'            => 1,
                    'scm_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'scm_fecha_creacion'    => date('Y-m-d h:i:s'),
                    'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                );
                $this->gsatelite->ingresar('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra);
            }

            $seguimientos = $this->input->post("txt_seguimiento"); 
            foreach ($seguimientos as $seguimiento) {
                $sgm_seguimiento_comparativo_compra  = array(
                    'sgm_id_usu'                => $this->tank_auth->get_user_id(),
                    'sgm_id_ccc'                => $ccc_id,
                    'sgm_fecha'                 => date('Y-m-d H:i:s'),
                    'sgm_observacion'           => $seguimiento,
                    'sgm_estado'                => 1,
                    'sgm_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'sgm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'sgm_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'sgm_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('sgm_seguimiento_comparativo_compra', $sgm_seguimiento_comparativo_compra);
            }

            $detalle_requisicion = $this->input->post("chk_detalle_cotizacion");
            
            foreach ($detalle_requisicion as $key => $detalle) {
                $dpm_detalle_comparativo_compra = array(
                    'dpm_id_dri'                => $this->input->post("detalle_requisicion_".$detalle),
                    'dpm_id_dco'                => $this->input->post("detalle_cotizacion_".$detalle),
                    'dpm_id_ccc'                => $ccc_id,
                    'dpm_cantidad'              => $this->input->post("cantidad_".$detalle),
                    'dpm_precio_unitario'       => $this->input->post("precio_unitario_".$detalle),
                    'dpm_impuesto'              => $this->input->post("impuesto_cotizacion_".$detalle),
                    'dpm_descuento'             => $this->input->post("descuento_cotizacion_".$detalle),
                    'dpm_subtotal'              => $this->input->post("sub_cotizacion_".$detalle),
                    'dpm_total'                 => $this->input->post("total_cotizacion_".$detalle),
                    'dpm_observacion'           => "",
                    'dpm_estado'                => 1,
                    'dpm_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'dpm_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'dpm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'dpm_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('dpm_detalle_comparativo_compra', $dpm_detalle_comparativo_compra);
                
            }            
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comparativo de cotización", 'texto_alerta' => "Se guardo el comparativo de cotización");
            $this->session->set_flashdata($alerta);
            redirect('/modulo_compras/procesos/comparar_cotizaciones');
        } else{
            $this->db->group_by("rxi_id");
            $this->db->join("coc_cotizacion_compra","coc_id_rxi = rxi_id","left");
            $this->db->join("ccc_comparativo_cotizacion_compra","ccc_id_rxi = rxi_id","left");
            $this->db->join("ace_actividad_especifica","ace_id = rxi_id_ace","left");
            $this->db->join("users","id = rxi_usu_creacion");
            $requisiciones_array        = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_estado' => 3, 'ccc_id IS NULL' => NULL,'coc_estado' => 1) );              
            $requisiciones              = '';
            foreach ($requisiciones_array as $requisicion) {
                $requisiciones .= '<option data-especifica="'.$requisicion["rxi_id_ace"].'" data-nombre="'.$requisicion["ace_nombre"].'" data-codigo="'.$requisicion["ace_codigo"].'" value="'.$requisicion["rxi_id"].'">'.$requisicion["rxi_numero"].' - '.$requisicion["username"].'</option>';
            }

            $requisiciones              = str_replace('<option value="0">Seleccione</option>', '', $requisiciones);
            $data['requisiciones']      = $requisiciones;
            $usuario                    = $this->gsatelite->get_tabla("emp_empleado", array("emp_id_usu" => $this->tank_auth->get_user_id() ));
            $data['usuario']            = $usuario[0]["emp_nombre"]." ".$usuario[0]["emp_apellido"];
            $data['titulo_personal']    = 'Crear comparativo de cotización';
            $this->_cargarvista($data);
        }   
    }
    
    public function get_comparativos_cotizaciones() {
        satelite_validar();
        if ( $_POST ) {            
            $requisicion            = $this->input->post("requisicion");
            $requisiciones          = $this->compras_model->get_detalle_requisicion( array("dri_id_rxi" => $requisicion) );
            $order_by               = "prv_nombre,prv_id";            
            $group_by               = null;
            $where["coc_id_rxi"]    = $requisicion;
            $where["coc_estado"]    = 1;
            
            $destalles_cotizaciones = $this->compras_model->get_detalle_cotizaciones( $where , $group_by, $order_by);            

            $group_by               = "prv_nombre,prv_id";   
            $this->db->order_by($group_by);
            $this->db->join('prv_proveedor', 'prv_id = coc_id_prv','left');
            $cotizaciones           = $this->gsatelite->get_tabla("coc_cotizacion_compra", $where );

            $data["requisiciones"]              = $requisiciones;
            $data["destalles_cotizaciones"]     = $destalles_cotizaciones;
            $data["cotizaciones"]               = $cotizaciones;
            $detalle_comparativo_cotizacion = $this->load->view('modulo_compras/procesos/detalle_comparativo_cotizacion', $data, true);
            $data2["cotizaciones"]  = $cotizaciones;
            $detalle_comparativo_proveedores = $this->load->view('modulo_compras/procesos/detalle_comparativo_proveedores', $data2, true);

            $disponible = 0;

            $periodo    = ( $requisiciones[0]["rxi_fecha"] != "")? date('Ym', strtotime( $requisiciones[0]["rxi_fecha"]) ): date('Ym');
            $fecha      = ( $requisiciones[0]["rxi_fecha"] != "")? date('Y-m-d', strtotime( $requisiciones[0]["rxi_fecha"] )): date('Y-m-d');
            
            if ( $requisiciones[0]["rxi_id_psp"] != "" && $requisiciones[0]["rxi_id_acg"] != "" && $requisiciones[0]["rxi_id_ace"] != "" ) {
                $where = array(
                    'dps_estado'    => 1,
                    'dps_id_psp'    => $requisiciones[0]["rxi_id_psp"],
                    'dps_id_acg'    => $requisiciones[0]["rxi_id_acg"],
                    'dps_id_ace'    => $requisiciones[0]["rxi_id_ace"]
                );

                $select = '
                (
                SELECT
                pcp_monto
                FROM
                pcp_plan_compra_presupuesto
                WHERE
                pcp_estado = 1
                AND pcp_id_dps = dps_id
                AND "'.$periodo.'" = pcp_periodo
                ) AS permitido,
                (
                SELECT
                IFNULL(sum(orc_total), 0)
                FROM
                orc_orden_compra
                WHERE
                orc_id_psp = dps_id_psp
                AND orc_id_ace = dps_id_ace
                AND orc_fecha_orden >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                AND orc_fecha_orden <= LAST_DAY("'.$fecha.'")
                ) AS monto_comprometido_mensual,
                (
                SELECT
                IFNULL(sum(dpv_total), 0)
                FROM
                dpv_documento_proveedor
                WHERE
                dpv_id_psp = dps_id_psp
                AND dpv_id_ace = dpv_id_ace
                AND ISNULL(dpv_id_orc)
                AND dpv_fecha_documento >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                AND dpv_fecha_documento <= LAST_DAY("'.$fecha.'")
                ) AS monto_pagado_mensual
                ';

                $group_by    = "ace_id";
                $actividades = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by);             
                if ( count($actividades) >0 ) {
                    $disponible = $actividades[0]['permitido'] - ($actividades[0]['monto_comprometido_mensual'] + $actividades[0]['monto_pagado_mensual']);
                }
            }            

            $result["detalle_comparativo_cotizacion"]   = $detalle_comparativo_cotizacion;
            $result["detalle_comparativo_proveedores"]  = $detalle_comparativo_proveedores;
            $result["disponible"]                        = $disponible;
            echo json_encode($result);
            die();
        }
    }

    /**
        * @author Francisco Orozco 
        * @since  29/03/2019
        * @param  id del comaparativo
        * @return vista de edicion de comparativo
    */
    public function editar_comparativo($comparativo = null) {
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');  
        ini_set( 'max_input_vars', '2500' );
        if ( $_POST) {
            $comparativo        = $this->input->post("txt_comparativo");            
            $sub_total          = $this->input->post("txt_sub_total");
            $descuento          = $this->input->post("txt_descuentos");
            $impuesto           = $this->input->post("txt_impuestos");
            $total              = $this->input->post("txt_total");            
            $envio_aprobacion   = $this->input->post("txt_envio_aprobacion");
            $fechas_cotizaciones= $this->input->post("txt_fecha_cotizacion");

            usort($fechas_cotizaciones, function ( $a, $b ) {
                return strtotime($a) - strtotime($b);
            });
            
            $fecha_inicio       = date('Y-m-d', strtotime($fechas_cotizaciones[0]));
            $fechas_cotizaciones= array_reverse($fechas_cotizaciones);
            $fecha_fin          = date('Y-m-d', strtotime($fechas_cotizaciones[0]));

            $ccc_comparativo_cotizacion_compra  = array(
                'ccc_observacion'           => "",
                'ccc_fecha_inicio'          => $fecha_inicio,
                'ccc_fecha_fin'             => $fecha_fin,
                'ccc_subtotal'              => $sub_total,
                'ccc_descuento'             => $descuento,
                'ccc_impuesto'              => $impuesto,
                'ccc_total'                 => $total,
                'ccc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'ccc_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('ccc_comparativo_cotizacion_compra', $ccc_comparativo_cotizacion_compra, array('ccc_id' => $comparativo));

            $seguimientos = $this->input->post("txt_seguimiento"); 
            
            foreach ($seguimientos as $seguimiento) {
                $sgm_seguimiento_comparativo_compra  = array(
                    'sgm_id_usu'                => $this->tank_auth->get_user_id(),
                    'sgm_id_ccc'                => $comparativo,
                    'sgm_fecha'                 => date('Y-m-d H:i:s'),
                    'sgm_observacion'           => $seguimiento,
                    'sgm_estado'                => 1,
                    'sgm_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'sgm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'sgm_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'sgm_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('sgm_seguimiento_comparativo_compra', $sgm_seguimiento_comparativo_compra);
            }
            
            //Se eliminan los detalles
            $this->gsatelite->borrado_general('dpm_detalle_comparativo_compra', array('dpm_id_ccc' => $comparativo) );

            $detalle_requisicion = $this->input->post("chk_detalle_cotizacion");
            
            foreach ($detalle_requisicion as $key => $detalle) {
                $dpm_detalle_comparativo_compra = array(
                    'dpm_id_dri'                => $this->input->post("detalle_requisicion_".$detalle),
                    'dpm_id_dco'                => $this->input->post("detalle_cotizacion_".$detalle),
                    'dpm_id_ccc'                => $comparativo,
                    'dpm_cantidad'              => $this->input->post("cantidad_".$detalle),
                    'dpm_precio_unitario'       => $this->input->post("precio_unitario_".$detalle),
                    'dpm_impuesto'              => $this->input->post("impuesto_cotizacion_".$detalle),
                    'dpm_descuento'             => $this->input->post("descuento_cotizacion_".$detalle),
                    'dpm_subtotal'              => $this->input->post("sub_cotizacion_".$detalle),
                    'dpm_total'                 => $this->input->post("total_cotizacion_".$detalle),
                    'dpm_observacion'           => "",
                    'dpm_estado'                => 1,
                    'dpm_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'dpm_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'dpm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'dpm_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('dpm_detalle_comparativo_compra', $dpm_detalle_comparativo_compra);
            }            

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comparativo de cotización", 'texto_alerta' => "Se modificó el comparativo de cotización");
            $this->session->set_flashdata($alerta);
            redirect('/modulo_compras/procesos/comparar_cotizaciones');
        } else{
            $autorizar_str      = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
            $autorizar_array    = explode(",",$autorizar_str);
            $roles_array        = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
            $autorizar          = false;
            foreach ($roles_array as $rol) {
                if (in_array($rol["uxr_id_rol"], $autorizar_array)) {
                    $autorizar = true;
                }
            }    

            $this->db->order_by("sgm_fecha","desc");
            $this->db->join("emp_empleado","emp_id_usu = sgm_id_usu");
            $this->db->join("ccc_comparativo_cotizacion_compra","ccc_id = sgm_id_ccc");
            $this->db->join("rxi_requisicion_inventario","rxi_id = ccc_id_rxi");
            $this->db->join("ace_actividad_especifica","ace_id = rxi_id_ace","left");
            $seguimientos                           = $this->gsatelite->get_tabla("sgm_seguimiento_comparativo_compra",array("sgm_id_ccc" => $comparativo) );
            $detalle_cotizaciones                   = $this->get_edicion_comparativos_cotizaciones($comparativo);
            $usuario                                = $this->gsatelite->get_tabla("emp_empleado", array("emp_id_usu" => $this->tank_auth->get_user_id() ));

            $disponible = 0;
            
            $periodo    = ( $seguimientos[0]["rxi_fecha"] != "")? date('Ym', strtotime( $seguimientos[0]["rxi_fecha"]) ): date('Ym');
            $fecha      = ( $seguimientos[0]["rxi_fecha"] != "")? date('Y-m-d', strtotime( $seguimientos[0]["rxi_fecha"] )): date('Y-m-d');

            if ( $seguimientos[0]["rxi_id_psp"] != "" && $seguimientos[0]["rxi_id_acg"] != "" && $seguimientos[0]["rxi_id_ace"] != "" ) {
                $where = array(
                    'dps_estado'    => 1,
                    'dps_id_psp'    => $seguimientos[0]["rxi_id_psp"],
                    'dps_id_acg'    => $seguimientos[0]["rxi_id_acg"],
                    'dps_id_ace'    => $seguimientos[0]["rxi_id_ace"]
                );

                $select = '
                (
                SELECT
                pcp_monto
                FROM
                pcp_plan_compra_presupuesto
                WHERE
                pcp_estado = 1
                AND pcp_id_dps = dps_id
                AND "'.$periodo.'" = pcp_periodo
                ) AS permitido,
                (
                SELECT
                IFNULL(sum(orc_total), 0)
                FROM
                orc_orden_compra
                WHERE
                orc_id_psp = dps_id_psp
                AND orc_id_ace = dps_id_ace
                AND orc_fecha_orden >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                AND orc_fecha_orden <= LAST_DAY("'.$fecha.'")
                ) AS monto_comprometido_mensual,
                (
                SELECT
                IFNULL(sum(dpv_total), 0)
                FROM
                dpv_documento_proveedor
                WHERE
                dpv_id_psp = dps_id_psp
                AND dpv_id_ace = dpv_id_ace
                AND ISNULL(dpv_id_orc)
                AND dpv_fecha_documento >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                AND dpv_fecha_documento <= LAST_DAY("'.$fecha.'")
                ) AS monto_pagado_mensual
                ';

                $group_by    = "ace_id";
                $actividades = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by);      
                if ( count($actividades) >0 ) {
                    $disponible = $actividades[0]['permitido'] - ($actividades[0]['monto_comprometido_mensual'] + $actividades[0]['monto_pagado_mensual']);
                }
            }

            $evalular                             = 0;    
            if ( count($seguimientos)  > 0 ) {
                $evalular = ( $seguimientos[0]["rxi_id_ace"] > 0 )?1:0;
            }      
            $data['disponible']                     = $disponible;
            $data['usuario']                        = $usuario[0]["emp_nombre"]." ".$usuario[0]["emp_apellido"];
            $data['seguimientos']                   = $seguimientos;
            $data['detalle_comparativo_cotizacion'] = $detalle_cotizaciones["detalle_comparativo_cotizacion"];
            $data['detalle_comparativo_proveedores']= $detalle_cotizaciones["detalle_comparativo_proveedores"];
            $data['comparativo_cotizacion']         = $detalle_cotizaciones["comparativo_cotizacion"];
            $data['titulo_personal']                = 'Editar comparativo de cotización';
            $data['autorizar']                      = $autorizar;
            $data['evalular']                       = $evalular;
            $data['especifico']                     = ($seguimientos[0]["ace_nombre"] != "")?'<b>Pda. Presup. / Rubro: </b>'.$seguimientos[0]["ace_codigo"].' - '.$seguimientos[0]["ace_nombre"]:'';
            $this->_cargarvista($data);
        }   
    }

    public function get_edicion_comparativos_cotizaciones($comparativo) {
        satelite_validar();        
        $comparativo_cotizacion = $this->gsatelite->get_tabla("ccc_comparativo_cotizacion_compra",array("ccc_id" => $comparativo));
        $requisicion            = $comparativo_cotizacion[0]["ccc_id_rxi"];
        $requisiciones          = $this->compras_model->get_detalle_requisicion( array("dri_id_rxi" => $requisicion) );

        $order_by               = "prv_nombre,prv_id";            
        $group_by               = null;
        $destalles_cotizaciones = $this->compras_model->get_detalle_cotizaciones_comparativo( array("coc_id_rxi" => $requisicion), $group_by, $order_by);                      

        $group_by               = "prv_nombre,prv_id";   
        $this->db->order_by($group_by);
        $this->db->join('prv_proveedor', 'prv_id = coc_id_prv','left');
        $cotizaciones           = $this->gsatelite->get_tabla("coc_cotizacion_compra",array( "coc_id_rxi" => $requisicion ) );

        $data["requisiciones"]              = $requisiciones;
        $data["destalles_cotizaciones"]     = $destalles_cotizaciones;
        $data["cotizaciones"]               = $cotizaciones;
        $detalle_comparativo_cotizacion     = $this->load->view('modulo_compras/procesos/detalle_comparativo_cotizacion', $data, true);

        $data2["cotizaciones"]              = $cotizaciones;
        $detalle_comparativo_proveedores    = $this->load->view('modulo_compras/procesos/detalle_comparativo_proveedores', $data2, true);

        $result["detalle_comparativo_cotizacion"]   = $detalle_comparativo_cotizacion;
        $result["detalle_comparativo_proveedores"]  = $detalle_comparativo_proveedores;
        $result["comparativo_cotizacion"]           = $comparativo_cotizacion;
        return $result;
    }

    /**
        * @author Francisco Orozco 
        * @since  29/03/2019
        * @param  id del comaparativo
        * @return vista de aprobacion o rechazo de comparativo
    */
    public function aprobacion_comparativo($comparativo = null) {
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');  
        ini_set( 'max_input_vars', '2500' );
        if ( $_POST) {

            $comparativo    = $this->input->post("txt_comparativo");            
            $total          = $this->input->post("txt_total");
            $aprobacion     = 3;//($this->input->post("slc_aprobacion") != "")?$this->input->post("slc_aprobacion"):1;
            $paso_actual    = $this->input->post("hdnActualPaso");
            $seguimientos   = $this->input->post("txt_seguimiento");
            $paso_siguiente = $this->input->post("hdnSigPaso");
            $txtComentario  = end($seguimientos);

            //Se cierra el paso actual
            $scm_seguimiento_comparativo_compra = array(
                'scm_id_usu'            => $this->tank_auth->get_user_id(),
                'scm_observacion'       => $txtComentario,
                'scm_fecha_salida'      => date('Y-m-d H:i:s'),
                'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
            );
            $this->gsatelite->actualizar_array('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra, array('scm_id' => $paso_actual));

            //Si existe un siguiente paso se ingresa
            if ($paso_siguiente > 0) {
                $scm_seguimiento_comparativo_compra = array(
                    'scm_id_ccc'            => $comparativo,
                    'scm_id_psf'            => $paso_siguiente,
                    'scm_id_usu'            => $this->tank_auth->get_user_id(),
                    'scm_fecha_entrada'     => date('Y-m-d H:i:s'),
                    'scm_estado'            => 1,
                    'scm_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'scm_fecha_creacion'    => date('Y-m-d h:i:s'),
                    'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                );

                $seguimiento = $this->gsatelite->ingresar('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra);
            }        

            //aprobacion == 3 si es aprobado
            $ccc_comparativo_cotizacion_compra  = array(
                'ccc_id_usu_autoriza'       => $this->tank_auth->get_user_id(),
                'ccc_estado'                => $aprobacion,
                'ccc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'ccc_fecha_modificacion'    => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('ccc_comparativo_cotizacion_compra', $ccc_comparativo_cotizacion_compra, array('ccc_id' => $comparativo));
            
            foreach ($seguimientos as $seguimiento) {
                $sgm_seguimiento_comparativo_compra  = array(
                    'sgm_id_usu'                => $this->tank_auth->get_user_id(),
                    'sgm_id_ccc'                => $comparativo,
                    'sgm_fecha'                 => date('Y-m-d H:i:s'),
                    'sgm_observacion'           => $seguimiento,
                    'sgm_estado'                => 1,
                    'sgm_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'sgm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'sgm_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'sgm_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('sgm_seguimiento_comparativo_compra', $sgm_seguimiento_comparativo_compra);
            }
            
            if ( $aprobacion != 3) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comparativo de cotización", 'texto_alerta' => "Se envio el comparativo de cotización a revisión");
                $this->session->set_flashdata($alerta);
            }  else {
                $this->aprobar_cotizaciones($comparativo);
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comparativo de cotización", 'texto_alerta' => "Se aprobo el comparativo de cotización");
                $this->session->set_flashdata($alerta);
            }
            redirect('/modulo_compras/inicio/tareas_pendientes');            
        } else{
            $autorizar_str      = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
            $autorizar_array    = explode(",",$autorizar_str);
            $roles_array        = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
            $autorizar          = false;
            foreach ($roles_array as $rol) {
                if (in_array($rol["uxr_id_rol"], $autorizar_array)) {
                    $autorizar = true;
                }
            }    
            $this->db->order_by("sgm_fecha","desc");
            $this->db->join("emp_empleado","emp_id_usu = sgm_id_usu");
            $this->db->join("ccc_comparativo_cotizacion_compra","ccc_id = sgm_id_ccc");
            $this->db->join("rxi_requisicion_inventario","rxi_id = ccc_id_rxi");
            $this->db->join("ace_actividad_especifica","ace_id = rxi_id_ace","left");
            $seguimientos           = $this->gsatelite->get_tabla("sgm_seguimiento_comparativo_compra",array("sgm_id_ccc" => $comparativo) );
            $detalle_cotizaciones   = $this->get_edicion_comparativos_cotizaciones($comparativo);
            $usuario                = $this->gsatelite->get_tabla("emp_empleado", array("emp_id_usu" => $this->tank_auth->get_user_id() ));

            $disponible = 0;
            
            $periodo    = ( $seguimientos[0]["rxi_fecha"] != "")? date('Ym', strtotime( $seguimientos[0]["rxi_fecha"]) ): date('Ym');
            $fecha      = ( $seguimientos[0]["rxi_fecha"] != "")? date('Y-m-d', strtotime( $seguimientos[0]["rxi_fecha"] )): date('Y-m-d');

            if ( $seguimientos[0]["rxi_id_psp"] != "" && $seguimientos[0]["rxi_id_acg"] != "" && $seguimientos[0]["rxi_id_ace"] != "" ) {
                $where = array(
                    'dps_estado'    => 1,
                    'dps_id_psp'    => $seguimientos[0]["rxi_id_psp"],
                    'dps_id_acg'    => $seguimientos[0]["rxi_id_acg"],
                    'dps_id_ace'    => $seguimientos[0]["rxi_id_ace"]
                );

                $select = '
                (
                SELECT
                pcp_monto
                FROM
                pcp_plan_compra_presupuesto
                WHERE
                pcp_estado = 1
                AND pcp_id_dps = dps_id
                AND "'.$periodo.'" = pcp_periodo
                ) AS permitido,
                (
                SELECT
                IFNULL(sum(orc_total), 0)
                FROM
                orc_orden_compra
                WHERE
                orc_id_psp = dps_id_psp
                AND orc_id_ace = dps_id_ace
                AND orc_fecha_orden >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                AND orc_fecha_orden <= LAST_DAY("'.$fecha.'")
                ) AS monto_comprometido_mensual,
                (
                SELECT
                IFNULL(sum(dpv_total), 0)
                FROM
                dpv_documento_proveedor
                WHERE
                dpv_id_psp = dps_id_psp
                AND dpv_id_ace = dpv_id_ace
                AND ISNULL(dpv_id_orc)
                AND dpv_fecha_documento >= DATE_FORMAT("'.$fecha.'", "%Y-%m-01")
                AND dpv_fecha_documento <= LAST_DAY("'.$fecha.'")
                ) AS monto_pagado_mensual
                ';

                $group_by    = "ace_id";
                $actividades = $this->compras_model->get_actividades_x_presupusto($select, $where, $group_by);             
                if ( count($actividades) >0 ) {
                    $disponible = $actividades[0]['permitido'] - ($actividades[0]['monto_comprometido_mensual'] + $actividades[0]['monto_pagado_mensual']);
                }
            }            
            
            $paso_siguiente = $this->compras_model->get_paso_siguiente($comparativo,4);
            $paso_actual = $this->compras_model->get_paso_actual($comparativo,4);
            $data['paso_siguiente']                 = $paso_siguiente[0];
            $data['paso_actual_id']                 = $paso_actual[0]['scm_id'];
            $data['disponible']                     = $disponible;
            $data['usuario']                        = $usuario[0]["emp_nombre"]." ".$usuario[0]["emp_apellido"];
            $data['seguimientos']                   = $seguimientos;
            $data['detalle_comparativo_cotizacion'] = $detalle_cotizaciones["detalle_comparativo_cotizacion"];
            $data['detalle_comparativo_proveedores']= $detalle_cotizaciones["detalle_comparativo_proveedores"];
            $data['comparativo_cotizacion']         = $detalle_cotizaciones["comparativo_cotizacion"];
            $data['titulo_personal']                = 'Aprobar comparativo de cotización';
            $data['autorizar']                      = $autorizar;
            $data['especifico']                     = ($seguimientos[0]["ace_nombre"] != "")?'<b>Pda. Presup. / Rubro: </b>'.$seguimientos[0]["ace_codigo"].' - '.$seguimientos[0]["ace_nombre"]:'';
            $this->_cargarvista($data);
        }   
    }

    /**
        * @author Francisco Orozco 
        * @since  29/03/2019
        * @param  id del comaparativo
        * @return Aprueba y rechaza cotizaciones segun el comparativo
    */
    public function aprobar_cotizaciones( $comparativo = null ) {
        if ( $comparativo != null ) {
            $this->db->join("dpm_detalle_comparativo_compra","dpm_id_ccc = ccc_id");
            $comparativos               = $this->gsatelite->get_tabla("ccc_comparativo_cotizacion_compra",array("ccc_id" => $comparativo));
            $cotizaciones_verificadas   = $this->compras_model->get_cotizaciones_aprobadas( array( "rxi_id" => $comparativos[0]["ccc_id_rxi"]) );

            foreach ($cotizaciones_verificadas as $cotizaciones ) {
                if ( $cotizaciones["aprobadas"] > 0) {
                    $coc_cotizacion_compra = array(
                        'coc_aprobacion_comparativo'=> 1,
                        'coc_id_usu_aprueba'        => $this->tank_auth->get_user_id(),
                        'coc_fecha_aprueba'         => date('Y-m-d H:i:s'),
                        'coc_estado'                => 2, //Aprobada
                        'coc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'coc_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('coc_cotizacion_compra', $coc_cotizacion_compra, array('coc_id' => $cotizaciones["coc_id"] ));
                } else {
                    $coc_cotizacion_compra = array(
                        'coc_id_usu_rechaza'    => $this->tank_auth->get_user_id(),
                        'coc_fecha_rechaza'     => date('Y-m-d H:i:s'),
                        'coc_estado'            => 3, //Rechazada
                        'coc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'coc_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('coc_cotizacion_compra', $coc_cotizacion_compra, array('coc_id' => $cotizaciones["coc_id"] ));
                }
                //se cambiaran a todos los detalles a 0
                $dco_detalle_cotizacion = array(
                    'dco_estado'    => 0
                );
                $this->gsatelite->actualizar_array('dco_detalle_cotizacion', $dco_detalle_cotizacion, array('dco_id_coc' => $cotizaciones["coc_id"] ));
            }
            //solo los chequeados pasaran a estado 1
            foreach ($comparativos as $detalle) {
                $dco_detalle_cotizacion = array(
                    'dco_aprobacion_comparativo'    => 1,
                    'dco_estado'                    => 1
                );
                $this->gsatelite->actualizar_array('dco_detalle_cotizacion', $dco_detalle_cotizacion, array('dco_id' => $detalle["dpm_id_dco"] ));
            }

        }
    }

    /**
        * @author Francisco Orozco 
        * @since  29/03/2019
        * @param  id del comaparativo
        * @return Vista de comparativos
    */
    public function ver_comparativo($comparativo = null) {
        satelite_validar();

        $autorizar_str      = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
        $autorizar_array    = explode(",",$autorizar_str);
        $roles_array        = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
        $autorizar          = false;
        foreach ($roles_array as $rol) {
            if (in_array($rol["uxr_id_rol"], $autorizar_array)) {
                $autorizar = true;
            }
        }    
        $this->db->order_by("sgm_fecha","desc");
        $this->db->join("emp_empleado","emp_id_usu = sgm_id_usu");
        $seguimientos                           = $this->gsatelite->get_tabla("sgm_seguimiento_comparativo_compra",array("sgm_id_ccc" => $comparativo) );
        $detalle_cotizaciones                   = $this->get_edicion_comparativos_cotizaciones($comparativo);
        $usuario                                = $this->gsatelite->get_tabla("emp_empleado", array("emp_id_usu" => $this->tank_auth->get_user_id() ));
        $data['usuario']                        = $usuario[0]["emp_nombre"]." ".$usuario[0]["emp_apellido"];
        $data['seguimientos']                   = $seguimientos;
        $data['detalle_comparativo_cotizacion'] = $detalle_cotizaciones["detalle_comparativo_cotizacion"];
        $data['detalle_comparativo_proveedores']= $detalle_cotizaciones["detalle_comparativo_proveedores"];
        $data['comparativo_cotizacion']         = $detalle_cotizaciones["comparativo_cotizacion"];
        $data['titulo_personal']                = 'Ver comparativo de cotización';
        $data['autorizar']                      = $autorizar;
        
        $this->_cargarvista($data);
    }

    /*********************INICIO NOTA DE CREDITO DESDE DOC PROVEEDOR********************/
    /*
     * @ver_detalle: 1 = Ver en Iframe, 2 = Ver como pantalla normal, null = Editar la pantalla
     * @redireccion: 1 = No redireccione a DPV de orden de compras
     */
    function crear_nota_credito($dpv_id = null, $ver_detalle = null, $redireccion = null) {        
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            $costo_promedio     = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            /**********INICIO ACTUALIZAR EL DPV A PARTIR DE LA NOTA DE CREDITO**************/
            $dpv_proviene = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $dpv_id));
            if(count($dpv_proviene)>0){
                //Total pagado en la nota de credito
                $total_de_la_nota_credito   = $post_array['txtTotalGeneral'];
                $dpv_nota_monto_abono       = $dpv_proviene[0]['dpv_monto_abono'];
                $dpv_nota_monto_pendiente   = $dpv_proviene[0]['dpv_monto_pendiente'];
                $dpv_nota_monto_nta_credito = $post_array['txtTotalGeneral'];
                $monto_saldo_nota_temporal  = (abs($total_de_la_nota_credito) - $dpv_nota_monto_pendiente);
                //Calcular el saldo
                //Si el total de la nota de credito excedo el monto pendiente del dpv
                if($monto_saldo_nota_temporal >=0){
                    $dpv_nota_monto_abono       = $dpv_proviene[0]['dpv_total'];
                    $dpv_nota_monto_pendiente   = 0.00;
                    $dpv_nota_monto_nta_credito = abs($total_de_la_nota_credito);
                    $dpv_nota_monto_nta_saldo   = abs($monto_saldo_nota_temporal);
                    $dpv_nota_colocar_pagado    = 1;
                }else{//En caso de que la nota de credito no excede el monto pendiente de dpv
                    $dpv_nota_monto_abono       = $dpv_nota_monto_abono + abs($post_array['txtTotalGeneral']);
                    $dpv_nota_monto_pendiente   = $dpv_nota_monto_pendiente - abs($post_array['txtTotalGeneral']);
                    $dpv_nota_monto_nta_credito = abs($total_de_la_nota_credito);
                    $dpv_nota_monto_nta_saldo   = 0.00;
                    $dpv_nota_colocar_pagado    = 0;
                }
                $actualizar_proviene = array(
                    'dpv_pagado' => $dpv_nota_colocar_pagado,
                    'dpv_monto_abono' => $dpv_nota_monto_abono, 
                    'dpv_monto_pendiente' => $dpv_nota_monto_pendiente,
                    'dpv_monto_nta_credito' => $dpv_nota_monto_nta_credito,
                    'dpv_monto_nta_saldo' => $dpv_nota_monto_nta_saldo                    
                );
                $nta_cre = $this->gsatelite->actualizar_array('dpv_documento_proveedor', $actualizar_proviene, array('dpv_id' => $dpv_id));
            }
            $cec_padre = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_cec', array('dpv_id' => $dpv_id));
            /**********FIN ACTUALIZAR EL DPV A PARTIR DE LA NOTA DE CREDITO**************/
            $tipo_btn               = $post_array['btnCrear'];
            $idOrdenCompra          = (isset($post_array['slcOrdenCompra'])) ? $post_array['slcOrdenCompra'] : null;
            $slcProveedor           = $post_array['slcProveedor'];
            $slcTipoPago            = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
            $slcTipoDocumento       = ($post_array['slcTipoDocumento'] != '') ? $post_array['slcTipoDocumento'] : null;
            $txtSerieDoc            = ($post_array['txtSerieDoc'] != '') ? $post_array['txtSerieDoc'] : null;
            $txtNumDoc              = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;
            $slcDocAfecta           = ($post_array['slcDocAfecta'] != '') ? $post_array['slcDocAfecta'] : null;
            $txtFechaDoc            = ($post_array['txtFechaDoc'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDoc'])) : null;
            $txtFechaConta          = ($post_array['txtFechaConta'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaConta'])) : null;
            $fechaDeclaracion       = ($post_array['txtFechaDeclara'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDeclara'])) : null;
            $txtFechaVencimiento    = ($post_array['txtFechaVencimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVencimiento'])) : null;
            $txtConcepto            = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $txtDescripcion         = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            //$slcRetenciones       = ($post_array['slcRetenciones'] != '') ? $post_array['slcRetenciones'] : null;
            $hdnAfectaInv           = $post_array['hdnAfectaInv'];
            $slcCajaChica           = ($post_array['slcCajaChica'] != '') ? $post_array['slcCajaChica'] : null;
            $slcTipoMonto           = ($post_array['slcTipoMonto'] != '') ? $post_array['slcTipoMonto'] : null;
            $slcTipo                = $post_array['slcTipo'];
            $txtObservacion         = ($post_array['txtObservacion']) ? $post_array['txtObservacion'] : null;
            $txtDescuentoGeneral    = (isset($post_array['txtDescuentoGeneral'])) ? $post_array['txtDescuentoGeneral'] : 0;
            $txtRetencionGeneral    = ($post_array['txtRetencionGeneral'] != '') ? $post_array['txtRetencionGeneral'] : 0;
            $txtImpuestosGeneral    = $post_array['txtImpuestosGeneral'];
            $txtSubtotalGeneral     = $post_array['txtSubtotalGeneral'];
            $txtTotalGeneral        = $post_array['txtTotalGeneral'];
            $slc_presupuesto        = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $slc_actividad_general  = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $slc_act_especifica     = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
            $nombre_act_especifica  = ($post_array['txt_nombre_actividad'] != '') ? $post_array['txt_nombre_actividad'] : null;
            $abreviacion            = ($post_array['txt_abreviacion'] != '') ? $post_array['txt_abreviacion'] : null;
            $nombre_proveedor       = ($post_array['txt_nombre_proveedor'] != '') ? $post_array['txt_nombre_proveedor'] : null;
            $txtNRC         = ($post_array['txtNrc']) ? $post_array['txtNrc'] : null;
            //aca convierte a la unidad de defecto
            $conversionDefe = $post_array['conversionDefe'];
            $conversionConv = $post_array['conversionConv'];
            //Anexos
            $TitulosAnexo   = (isset($post_array['titulo_doc'])) ? $post_array['titulo_doc'] : null;
            $NombreAnexo    = (isset($post_array['ruta'])) ? $post_array['ruta'] : null;
            $AnexoDpv       = (isset($post_array['AnexoDpv'])) ? $post_array['AnexoDpv'] : null;
            $slcProyecto    = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $edit = null;
            $id_orc = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_orc', array('dpv_id'=>$dpv_id));
            //Si se edita el documento con caja asignada.
            /* $existe_caja= $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_cch', array('dpv_id'=>$dpv_id));
            if($existe_caja>0){ $edit=1; }else{ $edit=null; }*/

            $documento_array = array(
                'dpv_id_prv' => $slcProveedor,
                'dpv_id_tpg' => $slcTipoPago,
                'dpv_id_tif' => $slcTipoDocumento,
                'dpv_id_cch' => $slcCajaChica,
                'dpv_id_dpv_afecta'     => $dpv_id,
                'dpv_id_pcl'            => $slcProyecto,
                'dpv_id_tmt'            => $slcTipoMonto,
                'dpv_id_cec'            => $cec_padre,
                'dpv_serie_documento'   => $txtSerieDoc,
                'dpv_numero_documento'  => $txtNumDoc,
                'dpv_fecha_documento'   => $txtFechaDoc,
                'dpv_fecha_contabilizacion' => $txtFechaConta,
                'dpv_fecha_declaracion'     => $fechaDeclaracion,
                'dpv_fecha_vencimiento'     => $txtFechaVencimiento,
                'dpv_concepto'              => $txtConcepto,
                'dpv_descripcion'           => $txtDescripcion,
                'dpv_afecta_inventario'     => $hdnAfectaInv,
                'dpv_tipo'                  => $slcTipo,
                'dpv_monto_pendiente'       => 0.00,//Este es el monto pendiente
                'dpv_monto_abono'           => convertirFloat($txtTotalGeneral),//Aqui va el monto total
                'dpv_impuesto'              => convertirFloat($txtImpuestosGeneral),
                'dpv_descuento'             => convertirFloat($txtDescuentoGeneral),
                'dpv_retencion'             => convertirFloat($txtRetencionGeneral),
                'dpv_subtotal'              => convertirFloat($txtSubtotalGeneral),
                'dpv_total'                 => convertirFloat($txtTotalGeneral),
                'dpv_observacion'           => $txtObservacion,
                'dpv_pagado'                => 1,
                'dpv_estado'                => 1,
                'dpv_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'dpv_usu_creacion'          => $this->tank_auth->get_user_id(),
                'dpv_fecha_modificacion'    => date('Y-m-d H:i:s'),
                'dpv_fecha_creacion'        => date('Y-m-d H:i:s'),
                'dpv_id_psp'                => $slc_presupuesto,
                'dpv_id_ace'                => $slc_act_especifica,
                'dpv_id_acg'                => $slc_actividad_general
            );
            //$resultado = $this->gsatelite->actualizar_array('dpv_documento_proveedor', $documento_array, array('dpv_id' => $dpv_id));
            $dpv_id = $this->gsatelite->ingresar('dpv_documento_proveedor', $documento_array);
            //se borrar gastos si existen
            //$this->gsatelite->borrado_general('dgp_detalle_gasto_prespuesto', array('dgp_id_dpv' => $dpv_id));
            //se verificara si se agregaran gastos a presupuestos.
            ///////////////////////////////// PENDIENTE DE HACER PRUEBAS ///////////////////////////////////////////////////////////////
            /*Se Comento el 9-11-2019, Queda pendiente revisar forma de proceder con el presupuesto
            if ( $slcProyecto != "" && $slc_act_especifica != "" ) {
                $condiciones = array(
                    "dps_id_ace"    => $slc_act_especifica,
                    "dps_id_acg"    => $slc_actividad_general,
                    "dps_id_psp"    => $slc_presupuesto,
                );
                $detalle_presupuesto = $this->gsatelite->get_campo("dps_detalle_presupuesto","dps_id",$condiciones);
                if ($detalle_presupuesto != null ) {
                    $dgp_detalle_gasto_prespuesto = array(
                        'dgp_id_dps'            => $detalle_presupuesto,
                        'dgp_id_tgp'            => 5,
                        'dgp_id_dpv'            => $dpv_id,
                        'dgp_fecha'             => $txtFechaDoc,
                        'dgp_descripcion'       => $nombre_proveedor,
                        'dgp_referencia'        => $abreviacion." - ".$txtNumDoc,
                        'dgp_cantidad'          => 1,
                        'dgp_monto'             => convertirFloat($txtTotalGeneral),
                        'dgp_total_retencion'   => convertirFloat($txtRetencionGeneral),
                        'dgp_total_impuesto'    => convertirFloat($txtImpuestosGeneral),
                        'dgp_sub_monto'         => convertirFloat($txtSubtotalGeneral),
                        'dgp_origen'            => null,
                        'dgp_referencia_origen' => null,
                        'dgp_estado'            => 1,
                        'dgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'dgp_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'dgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'dgp_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $dgp_id = $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dgp_detalle_gasto_prespuesto);
                }
            }
            */
            if ($dpv_id > 0) {
                //Se obtienen los detalles de la grid para actualizar
                $row       = $post_array['row_actual'];
                $cvaDpv    = $post_array['hdn_cva_id'];///////////////////////////////////////////////////////////////////////////////NO ESTA - CREAR ////////////////////////////
                $productosIds       = $post_array['hdnDetalle'];
                $cantidad_real      = $post_array['cantidades_real'];
                $hdnDetalleProd     = $post_array['hdnDetalleProd'];
                $txtCantidadesDpv   = $post_array['txtCantidadesDpv'];
                $txtPreciosDpv      = $post_array['txtPreciosDpv'];
                $BodegasDpv         = $post_array['hdnBodegasDpv'];
                $SectoresDpv        = $post_array['hdnSectoresDpv'];
                $impuestosDetalle   = $post_array['hdnImpuestosDpv'];
                $impuestosDpv       = $post_array['impuestosDpv'];
                $tiposVentaDpv      = $post_array['tiposVentaDpv'];
                $retencionesDetalle = $post_array['hdnRetencionesDpv'];
                $retencionesDpv     = $post_array['retencionesDpv'];
                $DescuentosDpv      = $post_array['hdnDescuentosDpv'];
                $subtotalesDpv      = $post_array['subtotalesDpv'];
                $totalesDpv         = $post_array['totalesDpv'];
                $descripcionProd    = $post_array['descripcionProd'];
                //Se eliminan los registros necesarios.
                //Se verifica si se eliminaron productos.
                /*$where = array(
                    'dxd_id_dpv' => $dpv_id
                );
                $dataDetalle = $this->compras_model->get_detalle_doc_proveedor($where);
                if (!is_array($productosIds)) {
                    $productosIds = array();
                }
                foreach ($dataDetalle as $data) {
                    if (!in_array($data['dxd_id'], $productosIds)) {
                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('idd_impuestoxdetalle_documento', array('idd_id_dxd' => $data['dxd_id']));
                        //Se eliminan las retenciones del detalle
                        $this->gsatelite->borrado_general('rxd_retencionxdetalle_documento', array('rxd_id_dxd' => $data['dxd_id']));
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('dxd_detalle_documento_proveedor', array('dxd_id' => $data['dxd_id']));
                        //
                    }
                }*/
                //Se actualizan los detalles
                if (count($productosIds) > 0) {
                    for ($i = 0; $i < count($productosIds); $i++) {
                        //Eliminar los detalles prorratedo
                        /*$this->db->join('pxd_prorrateoxdetalle_documento', 'dxd_id = pxd_id_dxd');
                        $last_dtpro = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $productosIds[$i]));
                            // print_r($last_dtpro);
                        foreach ($hdnDetalleProd as $index => $valueDP) {
                            $idsCnt = $post_array['cuentacontable_'.$valueDP];//id de la cuenta contable
                            if ($this->input->post('cuentacontable_'.$valueDP)) {
                                foreach ($idsCnt as $indexCnt => $idCnt) {
                                    // print_r($idsCnt);
                                    foreach ($last_dtpro as $key => $dtpro) {
                                        if (!in_array($dtpro['dxd_id'], $productosIds)) {
                                            $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dxd' => $dtpro['dxd_id'],'pxd_id_cnt' => $idCnt));
                                        }
                                    }
                                }
                            }else{
                                foreach ($last_dtpro as $key => $last_iddxd) {
                                    $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dxd' => $last_iddxd['dxd_id']));
                                }
                            }
                        }
                        $this->db->join('pxd_prorrateoxdetalle_documento', 'dxd_id = pxd_id_dxd');
                        $prorrateo_array = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $productosIds[$i]));
                        $prorrateo_id_array = array_column($prorrateo_array, 'pxd_id');
                        $prorrateo_exist = $this->input->post('prorrateo_exist_'.$row[$i].'_'.$hdnDetalleProd[$i]);
                        foreach ($prorrateo_id_array as $key_pro => $prorrateo_ids) {
                            if(!in_array($prorrateo_ids, $prorrateo_exist)){
                                $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id' => $prorrateo_ids));
                            }
                        }*/
                        //Fin eliminar detalle prorrateo
                        $detalle_array = array(
                            'dxd_id_dpv'            => $dpv_id,
                            'dxd_id_bod'            => ($BodegasDpv[$i] > 0) ? $BodegasDpv[$i] : null,
                            'dxd_id_sxb'            => ($SectoresDpv[$i] > 0) ? $SectoresDpv[$i] : null,
                            'dxd_id_cva'            => ($cvaDpv[$i] > 0) ? $cvaDpv[$i] : null,
                            'dxd_id_tpv'            => ($tiposVentaDpv[$i] != '') ? $tiposVentaDpv[$i] : null,
                            'dxd_id_art'            => ($hdnDetalleProd[$i] != '') ? $hdnDetalleProd[$i] : null,
                            'dxd_cantidad'          => convertirFloat($txtCantidadesDpv[$i]),
                            'dxd_precio_unitario'   => convertirFloat($txtPreciosDpv[$i]),
                            'dxd_impuesto'          => ($impuestosDpv[$i] <= 0) ? convertirFloat($impuestosDpv[$i]) : (convertirFloat($impuestosDpv[$i]) * -1),
                            'dxd_descuento'         => ($DescuentosDpv[$i] <= 0) ? convertirFloat($DescuentosDpv[$i]) : (convertirFloat($DescuentosDpv[$i]) * -1),
                            'dxd_retencion'         => ($retencionesDpv[$i] <= 0) ? convertirFloat($retencionesDpv[$i]) : (convertirFloat($retencionesDpv[$i]) * -1),
                            'dxd_subtotal'          => ($subtotalesDpv[$i] <= 0) ? convertirFloat($subtotalesDpv[$i]) : (convertirFloat($subtotalesDpv[$i]) * -1),
                            'dxd_descripcion'       => $descripcionProd[$i],
                            'dxd_total'             => ($totalesDpv[$i] <= 0) ? convertirFloat($totalesDpv[$i]) : (convertirFloat($totalesDpv[$i]) * -1),
                            'dxd_estado'            => 1,
                            'dxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion'=> date('Y-m-d H:i:s'),
                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_creacion' => date('Y-m-d H:i:s')
                        );                        
                        ///$resultado = $this->gsatelite->actualizar_array('dxd_detalle_documento_proveedor', $detalle_array, array('dxd_id' => $productosIds[$i]));
                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);
                        if($dxd_id >0){
                             ////// ACTUALIZAR CANTIDAD EN LOS DETALLES DE LA ORDEN DE COMPRA (SI APLICA) ///////
                            if($id_orc>0){
                                $det_dor = $this->gsatelite->get_tabla('dor_detalle_orden_compra', array('dor_id_orc'=>$id_orc,'dor_id_art'=>$hdnDetalleProd[$i]));
                                if(count($det_dor)>0){
                                    $pendiente = convertirFloat($cantidad_real[$i]) + convertirFloat($txtCantidadesDpv[$i]);
                                    $this->gsatelite->actualizar_array('dor_detalle_orden_compra', array('dor_cantidad_pendiente'=>$pendiente), array('dor_id'=>$det_dor[0]['dor_id']));
                                }
                            }
                        }
                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('idd_impuestoxdetalle_documento', array('idd_id_dxd' => $dxd_id));
                        //Se ingresan nuevamente
                        if (count($impuestosDetalle) > 0) {
                            //Se crea el array de los impuestos
                            $impuestos_array = explode(',', $impuestosDetalle[$i]);
                            if (count($impuestos_array) > 0) {
                                //Se recore el array para la insercion de impuestos
                                for ($j = 0; $j < count($impuestos_array); $j++) {
                                    $por_imp = $this->gsatelite->get_campo('imp_impuesto','imp_porcentaje', array('imp_id'=>$impuestos_array[$j]));
                                    if($por_imp > 0){
                                        $mon_im = ($por_imp/100) * $subtotalesDpv[$j];
                                    }else{
                                        $imp_val    = $this->gsatelite->get_campo('imp_impuesto','imp_valor', array('imp_id'=>$impuestos_array[$j]));                                          
                                        $mon_im     = $cantidades[$i] * $imp_val;
                                        $por_imp    = $imp_val;
                                    }
                                    if ($impuestos_array[$j] != '') {
                                        $ixo_array = array(
                                            'idd_id_imp' => $impuestos_array[$j],
                                            'idd_id_dxd' => $dxd_id,
                                            'idd_porcentaje' => $por_imp,
                                            'idd_monto' => ($mon_im <= 0) ? $mon_im : ($mon_im * -1),
                                            'idd_estado' => 1,
                                            'idd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'idd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'idd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'idd_fecha_creacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                    }
                                }
                            }
                        }
                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('rxd_retencionxdetalle_documento', array('rxd_id_dxd' => $dxd_id));
                        //Se valida existan retenciones
                        if (count($retencionesDetalle) > 0) {
                            //Se crea el array de los retenciones
                            $retenciones_array = explode(',', $retencionesDetalle[$i]);
                            if (count($retenciones_array) > 0) {
                                //Se recore el array para la insercion de impuestos
                                for ($j = 0; $j < count($retenciones_array); $j++) {
                                    if ($retenciones_array[$j] != '') {
                                        $rxd_array = array(
                                            'rxd_id_ret' => $retenciones_array[$j],
                                            'rxd_id_dxd' => $dxd_id,
                                            'rxd_estado' => 1,
                                            'rxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'rxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'rxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'rxd_fecha_creacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                    }
                                }
                            }
                        }
                        //Se procesan los detalles del prorrateo ya ingresados.
                        /*
                        if (count($post_array['hdnCec_' . $hdnDetalleProd[$i]]) > 0) {
                            $hdnIdsPxd = $post_array['hdnCec_' . $hdnDetalleProd[$i]];
                            $porcentajes = $post_array['porcentajesPxd_' . $hdnDetalleProd[$i]];
                            $totales = $post_array['totalPxd_' . $hdnDetalleProd[$i]];
                            for ($j = 0; $j < count($post_array['hdnCec_' . $hdnDetalleProd[$i]]); $j++) {
                                if ($porcentajes[$j] != '') {
                                    $detalle_pro_array = array(
                                        'pxd_porcentaje'        => $porcentajes[$j],
                                        'pxd_total'             => convertirFloat($totales[$j]),
                                        'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->actualizar_array('pxd_prorrateoxdetalle_documento', $detalle_pro_array, array('pxd_id' => $hdnIdsPxd[$j]));
                                }
                            }
                        }
                        //Se procesan los nuevos
                        //Se procesan los detalles del prorrateo
                        if (isset($post_array['centroCostos_' . $hdnDetalleProd[$i]]) && count($post_array['centroCostos_' . $hdnDetalleProd[$i]]) > 0) {
                            $centros_costo = $post_array['centroCostos_' . $hdnDetalleProd[$i]];
                            $porcentajes = $post_array['porcentajesCec_' . $hdnDetalleProd[$i]];
                            $totales = $post_array['totalCec_' . $hdnDetalleProd[$i]];
                            $cuentacontable = $post_array['cuentacontablenew_' . $hdnDetalleProd[$i]];
                            $pxd_id_cec         = $post_array['codigo_centro_costo_' . $hdnDetalleProd[$i]];

                            for ($j = 0; $j < count($post_array['centroCostos_' . $hdnDetalleProd[$i]]); $j++) {
                                // if ($centros_costo[$j] != '') {
                                    $detalle_pro_array = array(
                                        'pxd_id_dpr'            => ($centros_costo[$j] != "")?$centros_costo[$j]:NULL,
                                        'pxd_id_dxd'            => $productosIds[$i],
                                        'pxd_id_cnt'            => ($cuentacontable[$j] != "")?$cuentacontable[$j]:NULL,
                                        'pxd_id_cec'            => ($pxd_id_cec[$j] != "")?$pxd_id_cec[$j]:NULL,
                                        'pxd_porcentaje'        => $porcentajes[$j],
                                        'pxd_total'             => convertirFloat($totales[$j]),
                                        'pxd_estado'            => 1,
                                        'pxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_creacion'    => date('Y-m-d H:i:s'),
                                        'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                // }
                            }
                        }
                        */
                    }
                }
                //Se obtienen los detalles de la grid
                /*$productos = (isset($post_array['productos'])) ? $post_array['productos'] : null;
                $conversiones = (isset($post_array['productos'])) ? $post_array['conversion'] : null;
                $cantidades = (isset($post_array['productos'])) ? $post_array['cantidades'] : null;
                $precios = (isset($post_array['productos'])) ? $post_array['precios'] : null;
                $retenciones = (isset($post_array['productos'])) ? $post_array['retenciones'] : null;
                $impuestos = (isset($post_array['productos'])) ? $post_array['impuestos'] : null;
                $bodegas = (isset($post_array['productos'])) ? $post_array['bodegas'] : null;
                $sectores = (isset($post_array['productos'])) ? $post_array['sectores'] : null;
                $impuestosProducto = (isset($post_array['productos'])) ? $post_array['impuestosProducto'] : null;
                $retencionesProducto = (isset($post_array['productos'])) ? $post_array['retencionesProducto'] : null;
                $tiposVenta = (isset($post_array['productos'])) ? $post_array['tiposVenta'] : null;
                $descuentos = (isset($post_array['productos'])) ? $post_array['descuentos'] : null;
                //$gastos = $post_array['gastos'];
                $subtotalesProducto = (isset($post_array['productos'])) ? $post_array['subtotalesProducto'] : null;
                $totalesProducto = (isset($post_array['productos'])) ? $post_array['totalesProducto'] : null;
                $newdescripcionProd = (isset($post_array['newdescripcionProd'])) ? $post_array['newdescripcionProd'] : null;*/
                /*
                if (count($productos) > 0) {
                    //Se ingresan los detalles de la orden
                    for ($i = 0; $i < count($productos); $i++) {
                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;*/
                        //Se validan los registros en base al tipo de orden
                        //1 = Producto, 2 = Servicio, 3 = Activo Fijo
                        // if ($slcTipo == 1) {
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // } else if ($slcTipo == 2) {
                        //     $producto_id = $productos[$i];
                        // } else if($slcTipo == 4){
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // } else {
                        //     // $activo_id = $productos[$i];
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // }
                        /*$producto_id = $productos[$i];
                        $conversion_prodc = (trim($conversiones[$i])?$conversiones[$i]:null);
                        $detalle_array = array(
                            'dxd_id_bod' => ($bodegas[$i] > 0) ? $bodegas[$i] : null,
                            'dxd_id_sxb' => ($sectores[$i] > 0) ? $sectores[$i] : null,
                            'dxd_id_dpv' => $resultado,
                            'dxd_id_dpv' => $dpv_id,
                            'dxd_id_act' => $activo_id,
                            'dxd_id_cva' => $conversion_prodc,
                            'dxd_id_art' => $producto_id,
                            'dxd_id_tpv' => ($tiposVenta[$i] != '') ? $tiposVenta[$i] : null,
                            'dxd_cantidad' => convertirFloat($cantidades[$i]),
                            'dxd_precio_unitario' => convertirFloat($precios[$i]),
                            'dxd_impuesto' => convertirFloat($impuestosProducto[$i]),
                            'dxd_descuento' => ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0,
                            'dxd_retencion' => convertirFloat($retencionesProducto[$i]),
                            'dxd_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dxd_total' => convertirFloat($totalesProducto[$i]),
                            'dxd_descripcion' => $newdescripcionProd[$i],
                            'dxd_estado' => 1,
                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_creacion' => date('Y-m-d H:i:s'),
                        );
                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);*/
                        //Si se ingresa el detalle, se ingresan los impuestos y retenciones
                        /*if ($dxd_id > 0) {
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {

                                        if ($impuestos_array[$j] != '') {
                                            $ixo_array = array(
                                                'idd_id_imp' => $impuestos_array[$j],
                                                'idd_id_dxd' => $dxd_id,
                                                'idd_estado' => 1,
                                                'idd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'idd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'idd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'idd_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                        }
                                    }
                                }
                            }*/
                            //Se valida existan retenciones
                            /*
                            if (count($retenciones) > 0) {
                                //Se crea el array de los retenciones
                                $retenciones_array = explode(',', $retenciones[$i]);

                                if (count($retenciones_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($retenciones_array); $j++) {

                                        if ($retenciones_array[$j] != '') {
                                            $rxd_array = array(
                                                'rxd_id_ret' => $retenciones_array[$j],
                                                'rxd_id_dxd' => $dxd_id,
                                                'rxd_estado' => 1,
                                                'rxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'rxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                        }
                                    }
                                }
                            }*/
                            //Se procesan los detalles del prorrateo
                            /*
                            if (count($post_array['centroCostos_' . $productos[$i]]) > 0) {
                                $centros_costo = $post_array['centroCostos_' . $productos[$i]];
                                $porcentajes = $post_array['porcentajesCec_' . $productos[$i]];
                                $totales = $post_array['totalCec_' . $productos[$i]];
                                $cuentacontable = $post_array['cuentacontablenew_' . $productos[$i]];
                                for ($j = 0; $j < count($post_array['centroCostos_' . $productos[$i]]); $j++) {
                                    // if ($centros_costo[$j] != '') {
                                        $detalle_pro_array = array(
                                            'pxd_id_dpr' => $centros_costo[$j],
                                            'pxd_id_dxd' => $dxd_id,
                                            'pxd_id_cnt' => $cuentacontable[$j],
                                            'pxd_porcentaje' => $porcentajes[$j],
                                            'pxd_total' => $totales[$j],
                                            'pxd_estado' => 1,
                                            'pxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'pxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'pxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'pxd_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                    // }
                                }
                            }*/
                    /*                        }
                        }
                    }*/
                //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                $dataAnexos = $this->gsatelite->get_tabla('adp_anexo_documento', array('adp_id_dpv' => $dpv_id));
                if (!is_array($AnexoDpv)) {
                    $AnexoDpv = array();
                }
                foreach ($dataAnexos as $data) {
                    if (!in_array($data['adp_id'], $AnexoDpv)) {
                        $this->gsatelite->borrado_general('adp_anexo_documento', array('adp_id' => $data['adp_id']));
                        $ruta_nxp = $data['adp_url'];
                        unlink($ruta_nxp);
                    }
                }
                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anx_doc_proveedor/" . $nombreArchivo;
                        $documentos_array = array(
                            'adp_id_dpv' => $dpv_id,
                            'adp_url' => $carpeta_destino_anx,
                            'adp_nombre' => $nombreArchivo,
                            'adp_estado' => 1,
                            'adp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'adp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'adp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'adp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );
                        $nxp_id = $this->gsatelite->ingresar('adp_anexo_documento', $documentos_array);
                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
                // Se comento 9-11-2019, ya no hacia MOIs, se cambio 25-7-2023 para que haga MOI de salida si aplica
                if ($hdnAfectaInv == 1 && ($slcTipo == 1 || $slcTipo == 4)) {
                    $tipoProcesos = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
                    $tipoProcesos_array = json_decode($tipoProcesos, true);
                                     $this->db->order_by('dxd_id_bod');
                                     $this->db->group_by('dxd_id_bod');
                    $detalle_query = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod !=' => ''));
                    $array_bod = array_unique(array_filter(array_column($detalle_query, 'dxd_id_bod')));
                    $lmt = count($detalle_query);
                    foreach ($array_bod as $k => $b) {
                        $movimiento_array = array(
                            'moi_id_prv' => $slcProveedor,
                            'moi_id_tip' => $tipoProcesos_array['SAL_DOC_PROV'],
                            'moi_id_bod' => $b,
                            'moi_id_dpv' => $dpv_id,
                            'moi_documento' => $txtNumDoc,
                            'moi_descripcion' => $txtConcepto,
                            'moi_fecha_mov' => date('Y-m-d H:i:s'),
                            'moi_estado' => 1,
                            'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                            'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $movimiento_array);
                        for ($x = 0; $x < $lmt; $x++) {
                            if ($detalle_query[$x]['dxd_id_bod'] == $b && trim($detalle_query[$x]['dxd_id_art']) != "" && $detalle_query[$x]['dxd_cantidad'] > 0) {
                                $cantidades = $this->inventario_model->get_cantidad_bodega(null, $detalle_query[$x]['dxd_id_bod'], null, $detalle_query[$x]['dxd_id_art']);
                                $this->load->library('../controllers/inventario/gestion_productos');
                                if ($costo_promedio == 2) { //si es por fefo
                                    $condiciones = array (
                                        "articulo"          => $detalle_query[$x]['dxd_id_art'],
                                        "moi_id"            => $moi_id,
                                        "sector"            => $detalle_query[$x]['dxd_id_sxb'],
                                        "cantidades"        => $detalle_query[$x]['dxd_cantidad'],
                                        "bodega"            => $b,
                                        "lote"              => null,
                                        "cantidad_maxima"   => $cantidades[0]["cantidad"],
                                        "id_conversion"     => $detalle_query[$x]['dxd_id_cva'],
                                        "traslado"          => null,
                                        "producto_destino"  => null,
                                        "requisicion"       => null
                                    );
                                    $this->gestion_productos->fefo( $condiciones );
                                } else {
                                    $this->gestion_productos->peps_salida($detalle_query[$x]['dxd_id_art'], null, $moi_id, $detalle_query[$x]['dxd_id_cva'], $detalle_query[$x]['dxd_cantidad'], $detalle_query[$x]['dxd_id_sxb'], $cantidades[0]["cantidad"], $b);
                                }
                            }
                        }
                    }                    
                    //SE TENIA INGRESO DE INV. SE CAMBIO POR SALIDA 25-7-23, SE DEJA CODIGO COMENTADO POR SI SURGE CASO DE USO DE ENTRADA
                    /*
                    $movimientos_array = array();
                    //Se crean todos los movimientos
                    foreach ($detalle_query as $dxd) {
                        $movimientos_array[]['movimientos'] = array(
                            'moi_id_prv' => $slcProveedor,
                            'moi_id_tip' => $tipoProcesos_array['DOC_PROV'],
                            'moi_id_bod' => $dxd['dxd_id_bod'],
                            'moi_id_dpv' => $dpv_id,
                            'moi_documento' => $txtNumDoc,
                            'moi_descripcion' => $txtConcepto,
                            'moi_fecha_mov' => date('Y-m-d H:i:s'),
                            'moi_estado' => 1,
                            'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                            'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }
                    //Se crean los detalles del movimiento
                    for ($i = 0; $i < count($movimientos_array); $i++) {
                        $bod_id = $movimientos_array[$i]['movimientos']['moi_id_bod'];
                        $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod' => $bod_id));
                        if (count($detalles_doc) > 0) {
                            $desc_prod = ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0;
                            foreach ($detalles_doc as $key => $det) {
                                if($det['art_tipo'] == 0){
                                    $precio_uni = convertirFloat($det['dxd_precio_unitario']);
                                    $descuento_art = ($precio_uni) - (($precio_uni) * ($desc_prod/100));
                                    $nueva_cantidad_actu = convertirFloat( ($det['dxd_cantidad']*($conversionConv[$i]/$conversionDefe[$i]) ) );
                                    $nueva_precio_actu = convertirFloat(($descuento_art*($conversionDefe[$i]/$conversionConv[$i]) ) );
                                    if ($costo_promedio == 1) {
                                        $nuevo_precio =  $this->recalcular_precio_promedio($det['dxd_id_art'], $bod_id, $nueva_cantidad_actu, $nueva_precio_actu);
                                    }
                                    $movimientos_array[$i]['detalles'][$key]['sar_saldo'] = array(
                                        'sar_id_art' => $det['dxd_id_art'],
                                        'sar_id_bod' => $bod_id,
                                        'sar_cant_actual' => $nueva_cantidad_actu,
                                        'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $nueva_precio_actu,
                                        'sar_fecha_caducidad' => null,
                                        'sar_id_sxb' => $det['dxd_id_sxb'],
                                        'sar_estado' => 1,
                                        'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $movimientos_array[$i]['detalles'][$key]['dee_movimiento'] = array(
                                        'dee_id_moi' => null,
                                        'dee_id_art' => $det['dxd_id_art'],
                                        'dee_id_sar' => null,
                                        'dee_id_cva' => $det['dxd_id_cva'],
                                        'dee_id_sxb' => $det['dxd_id_sxb'],
                                        'dee_cantidad' => $nueva_cantidad_actu,
                                        'dee_precio' => $nueva_precio_actu,
                                        'dee_subtotal' => convertirFloat($det['dxd_subtotal']),
                                        'dee_estado' => 1,
                                        'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $movimientos_array[$i]['detalles'][$key]['dxd_detalle_doc'] = array(
                                        'dxd_id' => $det['dxd_id'],
                                        'dxd_procesado_inventario' => 1,
                                        'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    );
                                }
                            }
                        }
                    }
                    $this->ingresar_entrada($movimientos_array);
                    */
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            ///////////////////////////// Si se paga por caja chica ////////////////////////////////////////////////////
            if($slcCajaChica>0){
                $id_lcc = $post_array['id_lcc'];
                $this->registro_caja_chica($dpv_id, $documento_array, $id_lcc, $edit, $txtNRC);
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if ($dpv_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Nota de Credito", 'texto_alerta' => "El registro se almaceno correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nota de Credito", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('modulo_compras/procesos/editar_doc_proveedor/' . $dpv_id);
            } else {
                $idOrdenCompra = ($redireccion > 0) ? '' : $idOrdenCompra;
                redirect('modulo_compras/procesos/documentos_proveedor/' . $idOrdenCompra);
            }
        }
        // *********************************************************************************************** \\
        $permiso_compra = false;
        $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
        $permisos_array = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
        if ( count($permisos_array) > 0 ) {
            $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
            foreach ($roles as $role) {
                if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                    $permiso_compra = true;
                }
            }
        }
        $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
        $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;
        $data["permiso_compra"] = $permiso_compra;   
        $doc_proveedor          = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
        $data['orden']          = $doc_proveedor[0]['dpv_id_orc'];
        //$data['doc_proveedor']  = (count($doc_proveedor) > 0) ? $doc_proveedor : ''; //print_r($doc_proveedor);die();
        $data['tipo_pago']      = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', 'pagos', array('tpg_estado' => 1), $doc_proveedor[0]['dpv_id_tpg'], null, null, true);
        $data['retenciones']    = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $data['tipo_venta']     = $this->gsatelite->get_dropdown('tpv_tipo_venta', '{tpv_nombre}', 'tipo_venta', array('tpv_estado'=>1,'tpv_aplica_compra'=>1), null, null, null, true);
        $data['bodegas']        = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', 'bodegas', array('bod_estado' => 1), null, null, null, true);
        $data['documentosAfecta'] = $this->gsatelite->get_dropdown('dpv_documento_proveedor', 'dpv_numero_documento', 'documentoAfecta', array('dpv_id_prv' => $doc_proveedor[0]['dpv_id_prv'], 'dpv_id !=' => $dpv_id), $doc_proveedor[0]['dpv_id_dpv_afecta'], null, null, true);
        $data['doc_proveedor']  = $doc_proveedor[0];
        $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id)); 

        $data['anexos_doc']     = $this->gsatelite->get_tabla('adp_anexo_documento', array('adp_id_dpv' => $dpv_id));
        $data['prorrateos']     = $this->gsatelite->get_dropdown('ptg_prorrateo_gasto', '{ptg_nombre}', 'prorrateos', array('ptg_estado' => 1), null, null, null, true);
        $data['centro_costos']  = $this->gsatelite->get_tabla("cec_centro_costo",array('cec_estado' => 1));
        $orc_id                 = $doc_proveedor[0]['dpv_id_orc'];
        $tipo_factura            = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        if ($orc_id > 0) {
            $data['orden_compra'] = $orc_id;
            $data['ordenes_data'] = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
            $data['ordenes'] = $this->gsatelite->get_dropdown('orc_orden_compra', 'orc_numero', '', array('orc_id' => $orc_id), $orc_id, null, null, true);

            //Verificar si existe dpv para validar el tipo de documento
            $this->db->where('dpv_id !=', $dpv_id);
            $this->db->group_by('dpv_id_tif');
            $documento = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_orc' => $orc_id));

            $ids_tif = array();
            foreach ($documento as $doc) {
                $ids_tif[] = $doc['dpv_id_tif'];
            }

            if (count($documento) > 0) {
                $this->db->where('tif_estado', 1);
                $this->db->where('tif_aplica_nota_credito', 1);//Validar que sea nota de credito
                $this->db->where_not_in('tif_id', $ids_tif);
                $this->db->or_where('tif_id', $doc_proveedor[0]['dpv_id_tif']);
                $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', null, $doc_proveedor[0]['dpv_id_tif'], null, null, true);
            } else {
                $this->db->where('tif_aplica_nota_credito', 1);//Validar que sea nota de credito
                $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', array('tif_estado' => 1,'tif_aplica_compra' => 1), null, null, null, true);
            }
        } else {
            $data['orden_compra'] = null;
            $data['ordenes'] = "";
        }
        $tipo_documento         = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', array('tif_estado' => 1, 'tif_id' => $tipo_factura['NOTA CREDITO']), $tipo_factura['NOTA CREDITO'], null, null, true);
        //$this->db->where('tif_aplica_nota_credito', 1);//Validar que sea nota de credito
        /* $tipo_documento = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1) );
        $select_documento = '<option value = ""></option>';
        foreach ($tipo_documento as $key => $tipo) {
            $selected = ($doc_proveedor[0]['dpv_id_tif'] == $tipo["tif_id"] )?"selected":"";
            $select_documento   .= '<option value = "'.$tipo["tif_id"].'" data-abreviatura="'.$tipo["tif_abreviacion"].'" '.$selected.'>'.$tipo["tif_nombre"].'</option>';
        }*/
        $data['tipo_documento'] = $tipo_documento;
        $proveedores            = $this->compras_model->get_proveedor_pers();
        $options                = '<option value=""></option>';
        foreach ($proveedores as $key) {
            if ($key['pro'] != '') {
                if ($doc_proveedor[0]['dpv_id_prv'] == $key['prv_id']) {
                    $options .= '<option data-nombre = "' . $key['nombre'] . '" data-dias = "' . $key['prv_dias_plazo'] . '" value="' . $key['prv_id'] . '" selected>' . $key['pro'] . '</option>';
                } else {
                    $options .= '<option data-nombre = "' . $key['nombre'] . '" data-dias = "' . $key['prv_dias_plazo'] . '" value="' . $key['prv_id'] . '" >' . $key['pro'] . '</option>';
                }
            }
        }
        $data['proveedores'] = $options;
        ///////////////////// Sólo cajas chicas que poseen monto disponible /////////////////////////////
        if($ver_detalle==''){
            $this->db->where(array('lcc_corte'=>0));
        }
                 $this->db->join('lcc_liquidacion_caja_chica', 'lcc_id_cch=cch_id AND lcc_disponible IS NOT NULL');
        $cajas = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado'=>1));
        $opt_cajas = '<option value=""></option>';
        foreach ($cajas as $cj) {
            if( $doc_proveedor[0]['dpv_id_cch']==$cj['cch_id']){ $select="selected"; }else{ $select=''; }
            $opt_cajas .='<option value="'.$cj['cch_id'].'"  data-lcc="'.$cj['lcc_id'].'" '.$select.'>'.$cj['cch_nombre'].' ('.$cj['lcc_disponible'].')</option>';
        }
        $data['cajas_chicas'] = $opt_cajas;
        /////////////////////////////////////////////////////////////////////////////////////////////////
        $dis = $this->gsatelite->get_tabla('agp_agenda_pago', array('agp_estado'=>1, 'agp_id_dpv'=>$dpv_id));
        if(count($dis)>0){ $data['disabled']=1; }else{ $data['disabled']=0; }
        ////////////////////////////////////////////////////////////////////////////////////////////////
        $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
        $select_proyecto = '<option value=""></option>';
        foreach ($proyectos_reg as $key) {
            $selected = ($doc_proveedor[0]['dpv_id_pcl'] == $key['pcl_id'])?'selected':'';
            $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
            $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
            $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
        }
        $data['proyectos'] = $select_proyecto;
        $select = "";
        $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
        foreach ($impuesto_campos as $key) {
            if ($key["imp_porcentaje"] > 0) {
                $select .= "<option data-type='1' data-porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
            } else {
                $select .= "<option data-type='0' data-porcentaje='" . $key["imp_valor"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
            }
        }
        $data["impuestos"] = $select;
        $select = "";
        $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        foreach ($retencion_campos as $key) {
            if ($key["ret_defecto"] == 1) {
                $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
            } else {
                $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
            }
        }
        $data["retencion"] = $select;
        ////////////////////////////////////////////////////////////////////////////////////////////////
        $par_nrc=$this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
        $mask = $this->gsatelite->get_registro('tde_tipo_documento', array('tde_id'=>$par_nrc));
        $data['mask'] = $mask->tde_mascara;

        $data['ver_detalle'] = ($ver_detalle == null || $ver_detalle == 0)?null:$ver_detalle;
        $data['titulo_personal'] = "Documentos por Proveedor";
        $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $dias_pasados   = "";
        $dias_futuros   = "";
        $fechas_pasadas = "";
        $fechas_futuras = "";
        $json_meses     = $this->gsatelite->get_parametro('SYS_DOC_PROV_FECHA_CONTABLE');
        if ( $json_meses != "" ) {
            $configuracion_meses = json_decode($json_meses,true);
            if ( $configuracion_meses["DIAS_PASADOS"] != "" && is_numeric($configuracion_meses["DIAS_PASADOS"]) ) {
                $dias_pasados = $configuracion_meses["DIAS_PASADOS"];
                $fechas_pasadas = strtotime ( '-'.$dias_pasados.' day' , strtotime ( $doc_proveedor[0]['dpv_fecha_contabilizacion'] ) ) ;
                $fechas_pasadas = date ( 'Y,m,d' , $fechas_pasadas );
            }
            if ( $configuracion_meses["DIAS_FUTUROS"] != "" ) {
                $dias_futuros = $configuracion_meses["DIAS_FUTUROS"];
                $fechas_futuras = strtotime ( '+'.$dias_futuros.' day' , strtotime ( $doc_proveedor[0]['dpv_fecha_contabilizacion'] ) ) ;
                $fechas_futuras = date ( 'Y,m,d' , $fechas_futuras );
            }
        }   
        $data['dias_pasados']       = "new Date(".$fechas_pasadas.")";
        $data['dias_futuros']       = "new Date(".$fechas_futuras.")";
        $data['cheque_pendiente']   = $this->gsatelite->get_tabla('chp_cheque_pendiente', array('chp_estado' => 1, "chp_id_dpv" => $dpv_id) );
        $data['redireccion']        = $redireccion;
        $data['es_modal_ver']       = $ver_detalle;

        $slc_presupuesto            = ($doc_proveedor[0]['dpv_id_psp'] != "" )?$this->get_presupuestoxproyecto($doc_proveedor[0]['dpv_id_pcl'], $doc_proveedor[0]['dpv_id_psp']):'<option value=""></option>';
        $data['presupuesto']        = $slc_presupuesto;
        $slc_general                = ($doc_proveedor[0]['dpv_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_acg']):'<option value=""></option>';
        $data['general']            = $slc_general;
        $slc_especifica             = ($doc_proveedor[0]['dpv_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($doc_proveedor[0]['dpv_id_acg'], $doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_ace'],true):'<option value=""></option>';
        $data['especifica']         = $slc_especifica;

        $where['cnt_id_tcn'] = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));             
        $data['cuentas'] = $this->utm_model->get_cuentas_like_prorrateo_gral($where);

        //tipo de cuenta
        $select = $this->gsatelite->get_dropdown('tmt_tipo_monto', '{tmt_nombre}', '', array('tmt_estado' => 1), $doc_proveedor[0]['dpv_id_tmt'], '', 'tmt_id', true);
        $data["tipo_monto"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        if ($ver_detalle == 1) {
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/editar_doc_proveedor', $data, true);
        } else if ($ver_detalle == 2) {
            $this->_cargarvista($data);
        } else {
            $this->_cargarvista($data);
        }
    }
    /*************************FIN NOTA DE CREDITO*********************************/

    /**
        * @author Francisco Orozco 
        * @since  03/05/2019
        * @param  id del comaparativo
        * @return Disponible mensual
    */
    public function disponibilidad_mensual() {
        if ( $_POST ) { 

            $date       = ($this->input->post('fecha') != false)? date('Y-m-d', strtotime( $this->input->post('fecha') )): date('Y-m-d');
            $presupuesto= ($this->input->post('presupuesto') != false)? $this->input->post('presupuesto'): 0;
            $general    = ($this->input->post('general') != false)? $this->input->post('general'): 0;
            $especifica = ($this->input->post('especifica') != false)? $this->input->post('especifica'): 0;

            $where = array(
                'dps_estado'    => 1,
                'dps_id_psp'    => $presupuesto,
                'dps_id_acg'    => $general,
                'dps_id_ace'    => $especifica
            );

            $group_by               = "ace_id";
            $actividades_generales  = $this->compras_model->get_disponibilidad_mensual($date, $where, $group_by);        
            $disponible_mensual = $actividades_generales[0]['permitido'] - ($actividades_generales[0]['monto_comprometido_mensual'] + $actividades_generales[0]['monto_pagado_mensual']);
            echo trim($disponible_mensual);
            die();
        }
    }
    /**
        * @author Francisco Orozco 
        * @since  09/05/2019
        * @param  id del comaparativo
        * @return reporte de comparativo
    */
    public function imprimir_comparativo($comparativo) {
        if ($comparativo > 0) {            
            //obtener validacion de firmas
            $flujos         = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO',4);
            $flujos_array   = json_decode($flujos, true);
            $flujo          = $flujos_array['COMPARATIVO_COMPRA'];
            $firmas         = $this->get_firmas_reportes($flujo, $comparativo);
            
            $requisicion= $this->gsatelite->get_campo("ccc_comparativo_cotizacion_compra","ccc_id_rxi",array("ccc_id" => $comparativo) );
            $where1     = array();
            $where2     = array();
            if ( $requisicion != null ) {
                $where1["dri_id_rxi"] = $requisicion;
                $where2["coc_id_rxi"] = $requisicion;
            }

            $requisiciones          = $this->compras_model->get_detalle_requisicion( $where1 );
            $order_by               = "prv_nombre,prv_id";            
            $group_by               = null;
            $destalles_cotizaciones = $this->compras_model->get_detalle_cotizaciones_comparativo( $where2 , $group_by, $order_by);                      
            $group_by               = "prv_nombre,prv_id";   
            
            $this->db->order_by($group_by);
            $this->db->join('prv_proveedor', 'prv_id = coc_id_prv','left');
            $cotizaciones                   = $this->gsatelite->get_tabla("coc_cotizacion_compra",array( "coc_id_rxi" => $requisicion ) );
            $this->db->order_by("sgm_id","desc");
            $ultimo_comentario              = $this->gsatelite->get_tabla("sgm_seguimiento_comparativo_compra",array( "sgm_id_ccc" => $destalles_cotizaciones[0]["ccc_id"] ) );
            $data["decimales"]              = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data["ultimo_comentario"]      = $ultimo_comentario[0]["sgm_observacion"];
            $data["requisiciones"]          = $requisiciones;
            $data["destalles_cotizaciones"] = $destalles_cotizaciones;
            $data["cotizaciones"]           = $cotizaciones;
            $data["tipo_reporte"]           = 'excel';
            $filename                       = 'Reporte_comparativo_cotizaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']               = $filename;
            $data['titulo']                 = 'Comparativo de cotizaciones';
            $data['disponible_mensual']     = 0;
            $date                           = $requisiciones[0]["rxi_fecha"];
            $data['firmas']                 = $firmas;

            $where = array(
                'dps_estado'    => 1,
                'dps_id_psp'    => $requisiciones[0]["rxi_id_psp"],
                'dps_id_acg'    => $requisiciones[0]["rxi_id_acg"],
                'dps_id_ace'    => $requisiciones[0]["rxi_id_ace"]
            );

            $group_by                   = "ace_id";
            $actividades_generales      = $this->compras_model->get_disponibilidad_mensual($date, $where, $group_by);        
            $data['disponible_mensual'] = $actividades_generales[0]['permitido'] - ($actividades_generales[0]['monto_comprometido_mensual'] + $actividades_generales[0]['monto_pagado_mensual']);
            
            $html                   = $this->load->view('modulo_compras/reportes/rpt_detalle_comparativo_cotizacion', $data, true);
            $data['excel']          = 1;
            $data['titulo']         = 'Reporte de comparativo de cotizaciones';
            $data['filename']       = $filename;
            echo $html;
        }    
    }

    
    /**
    * @author Raul Escalante
    * @param  articulo, bodega, cantidad y precio de la entrada actual
    * @return precio promedio de los articulos incluyendo lo ya inventariado
    */
    public function recalcular_precio_promedio($articulo, $bodega, $cantidad, $precio){
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES','2');
        $existencia = ($cantidad != 0) ? $cantidad : 0; //ctdad nueva
        $valores    = ($precio != 0) ? ($precio * $existencia) : 0;     //valor (ctdad * precio)
        $ids = array();
        $where['art_id'] = $articulo;
        $where['bod_id'] = $bodega;
        $actual_existenc = $this->inventario_model->calcular_precio_promedio($where); //obtener lo que hay        
        foreach ($actual_existenc as $key => $value) {
            $existencia += ($value['sar_cant_actual'] != '') ? $value['sar_cant_actual'] : 0;
            $valores    += ($value['valor'] != '') ? $value['valor'] : 0;
            $ids[] = $value['sar_id'];        
        }
        $nuevo_precio = round(($valores / $existencia),$decimales);//precio promedio (valor/ctdad)
        $new_price = array('sar_precio' => $nuevo_precio);
        if (!(empty($ids))) {
            foreach ($ids as $key => $value) {
                $this->gsatelite->actualizar_array('sar_saldo_articulo', $new_price, array('sar_id' => $value));
            }
        }        
        return $nuevo_precio;
    }
    /**
        * @author: Francsico Orozco 
        * @since: 30-05-2019
        * @method: Se obtienelas firmas por flujo. 
        * @param: $flujo_id 'id del flujo'
        * @param: $proceso_id 'id del proceso, compras requicion, comparativo.'
        * @return: html
    **/
    public function get_firmas_reportes($flujo_id = 0, $proceso_id = 0){
        if ($flujo_id > 0) {
            //Obtener el flujo.
            $flujo  = $this->gsatelite->get_tabla("flu_flujo", array("flu_id" => $flujo_id) );        
            $firmas = array();
            $html   = "";
            if ( count($flujo) > 0 ) {
                if ( isset($flujo[0]["flu_tabla_seguimiento"]) && isset($flujo[0]["flu_tabla_proceso"]) && isset($flujo[0]["flu_tabla_seguimiento"]) != "" && isset($flujo[0]["flu_tabla_proceso"]) != "") {
                    $tabla_proceso      = $flujo[0]["flu_tabla_proceso"];
                    $tabla_seguimiento  = $flujo[0]["flu_tabla_seguimiento"];
                    //obtener prefijos
                    $prefijo_tbl_seg    = substr($tabla_seguimiento,0,3);
                    $prefijo_tbl_pro    = substr($tabla_proceso,0,3);
                    
                    //obtener firmas
                    $where_firmas       = array(
                        "psf_id_flu"        => $flujo_id,
                        "psf_aplica_firma"  => 1,
                        "psf_estado"        =>1
                    );

                    $this->db->order_by("psf_orden","ASC");
                    $this->db->group_by("psf_id");
                    $firmas = $this->gsatelite->get_tabla("psf_paso_flujo", $where_firmas );
                    //obtener el usuarios y historial de pasos 
                    $where_usuarios = array( 
                        "psf_id_flu"                            => $flujo_id,
                        "psf_aplica_firma"                      => 1,
                        "psf_estado"                            => 1,
                        $prefijo_tbl_seg."_id_".$prefijo_tbl_pro=> $proceso_id
                    );

                    $usuarios           = $this->compras_model->get_usuarios_firmas_reportes($tabla_seguimiento, $where_usuarios);     
                    $data["usuarios"]   = $usuarios;
                    $data["firmas"]     = $firmas;
                    $html               = $this->load->view('modulo_compras/procesos/firmas_reportes',$data,true);
                }         
            }      
            return $html;
        }
    }
    
    /**
        * @author Jose Marlon Olmedo Alas
        * @param  none
        * @return la existencia de un proveedor en la misma cotizacion
    */
    public function existencia_proveedor_cotizacion(){

        $id_proveedor = $this->input->post('proveedor');
        $id_requisicion = $this->input->post('requisicion');
        $where = array('coc_id_prv' => $id_proveedor, 'coc_id_rxi' => $id_requisicion);
        $campo = $this->gsatelite->get_tabla('coc_cotizacion_compra', $where);
        $json = array('contador' => count($campo));
        echo json_encode($json);
    }

    /**
    * @author Elman Ortiz    
    * @return Returna la lista de retaceos con solidados
    */
    public function retaceos_consolidados() {
        satelite_validar();
        $data['retaceos']        = $this->compras_model->get_retaceos_consolidados_lista();        
        $data['titulo_personal'] = "Listado Retaceos Consolidados";
        $this->_cargarvista($data);
    }

    /**
    * @author Elman Ortiz    
    * @return Returna la lista de documentos
    */
    public function get_documentos_proveedor_retaceo_macivo() {
        satelite_validar();
        $dpv_id = $this->input->post('id_prv');
        $global_iddpvs = $this->input->post('global_iddpvs');
        $data['registros'] = $this->compras_model->get_documentos_proveedor_retaceo_macivo($dpv_id, $global_iddpvs);        
        $html = $this->load->view('modulo_compras/procesos/detalle_lista_documentos', $data, true);        
        echo $html;
    }

    /**
    * @author Elman Ortiz    
    * @return Returna la lista de documentos
    */
    public function get_detalles_documentos_proveedor_retaceo_macivo($globalids = NULL,$es_editar = null) {
        satelite_validar();
        $prv_name = "";
        $i=0;
        if ($_POST) {
            $global_iddpvs = $this->input->post('global_iddpvs');
        } else {
            $global_iddpvs = $globalids;
        }        
        $tabla = $this->gsatelite->get_tabla('dpv_documento_proveedor', array("dpv_id in ($global_iddpvs)" => NULL));
        $num_docs = array_column($tabla, 'dpv_numero_documento');//array con los numeros de Doc seleccionados
        $ids_prov = array_column($tabla, 'dpv_id_prv');//array con los id de los proveedores
        $doc_num = implode(', ', $num_docs);//string con los numeros de docs condatenados
        $prv_ids = implode(', ', array_unique(array_filter($ids_prov)));
        $proveedores = $this->gsatelite->get_tabla('prv_proveedor', array("prv_id in ($prv_ids)" => NULL));
        foreach ($proveedores as $key => $value) {
            if ($i==0) {
                $prv_name .= ($value['prv_tipo_pers'] == 2) ? $value['prv_apellido'] : $value['prv_nombre'] . ' ' . $value['prv_apellido']; 
                $i++;
            } else {
                $prv_name .= ($value['prv_tipo_pers'] == 2) ? ', ' . $value['prv_apellido'] : ', ' . $value['prv_nombre'] . ' ' . $value['prv_apellido']; 
            }            
        }
        //Obtener detalles del proveedor
        //$data['dpv_registros'] = $this->compras_model->get_detalles_documentos_proveedor_retaceo_macivo($global_iddpvs);        
        $documentos          = $this->compras_model->get_documentos_proveedor_retaceo_macivo_detalles(null, $global_iddpvs);       
        $data['documentos']  = $documentos;        
        $data['detalle_documento'] = $this->compras_model->get_detalles_documentos_proveedor_retaceo_macivo($global_iddpvs, array('art_tipo'=>0));        
        $data['es_editar'] = 0;
        if ($es_editar == 1) {
            $data['es_editar'] = 1;
        }
        //print_r( $data['es_editar']); die();
        $html = $this->load->view('modulo_compras/procesos/detalle_x_documentos', $data, true);
        if ($_POST) {
            echo json_encode(array('tabla' => $html, 'doc_num' => $doc_num, 'prv_name' => $prv_name));
        } else {
           return $html;
        }
    }

    /**
    * @author Elman Ortiz    
    * @return Realizar la eliminacion logica del registro
    */
    public function eliminar_retaceo_consolidado() {
        $id_rtd = $this->input->post('id_rtd');        

        $this->db->where(array('rtd_id'=>$id_rtd));
        $this->db->update('rtd_retaceo_documento_proveedor', array('rtd_estado' => 0));
        $res = $this->db->affected_rows();
        
        if($res > 0){//Se actualizo el registro
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Retaceo consolidado eliminado", 'texto_alerta' => "El registro se eliminó correctamente");
            $this->session->set_flashdata($alerta);
            echo 1;
        }else{//No se actualizo el registro            
            echo 0;
        }
    }

    /********************AGREGAR RETACEO CONSOLIDADO*******************************/
    public function editar_retaceo_consolidado($rtd_id) {
        satelite_validar();
        if ($this->input->post()) {
            // var_dump($this->input->post());die();
            $post_array         = $this->input->post();
            $costo_promedio     = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            $tipo_btn           = $post_array['btnCrear'];
            $dpv_id             = $this->gsatelite->get_campo('rtd_retaceo_documento_proveedor', 'rtd_id_dpv', array('rtd_id' => $rtd_id));
            $txtNumRetaceo      = $post_array['txtNumRetaceo'];
            $txtPoliza          = $post_array['txtPoliza'];
            $txtAduana          = $post_array['txtAduana'];
            $txTObservaciones   = $post_array['txTObservaciones'];
            $hdnAfectaInv       = $post_array['hdnAfectaInv'];
            $txtTotalProdcutos  = $post_array['txtTotalProdcutos'];
            $txtTotalRetaceoPorc= $post_array['txtTotalRetaceoPorc'];
            $txtTotalRetaceo    = $post_array['txtTotalRetaceo'];
            $txtTotalGastos     = $post_array['txtTotalGastos'];
            $aplico_peso        = $post_array['hdnAplicarPeso'];
            //$txtFechaRegistro = $post_array['txtFechaRegistro'];
            $retaceo_array = array(
                'rtd_numero'            => $txtNumRetaceo,
                'rtd_poliza'            => $txtPoliza,
                'rtd_aduana'            => $txtAduana,
                'rtd_observacion'       => $txTObservaciones,
                'rtd_afecta_inventario' => $hdnAfectaInv,
                'rtd_subtotal'          => convertirFloat($txtTotalProdcutos),
                'rtd_retaceo_porcentaje'=> convertirFloat($txtTotalRetaceoPorc),
                'rtd_retaceo'           => convertirFloat($txtTotalRetaceo),
                'rtd_total_gasto'       => convertirFloat($txtTotalGastos),
                'rtd_aplico_peso'       => $aplico_peso,
                'rtd_estado'            => 1,
                'rtd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'rtd_fecha_modificacion'=> date('Y-m-d h:i:s')
            );
            //print_r($retaceo_array); die();
            $resultado = $this->gsatelite->actualizar_array('rtd_retaceo_documento_proveedor', $retaceo_array, array('rtd_id' => $rtd_id));            
            if ($resultado > 0) {
                $hdnDetalle         = $post_array['hdnDetalle'];
                $hdnArticulo        = $post_array['hdnArticulo'];
                $hdnConversion      = $post_array['hdnConversion'];
                $cantidades         = (isset($post_array['cantidades'])) ? $post_array['cantidades'] : null;
                $precios            = (isset($post_array['precios'])) ? $post_array['precios'] : null;
                $precios_finales    = (isset($post_array['preciosfinal'])) ? $post_array['preciosfinal'] : null;
                $subtotales         = (isset($post_array['subtotales'])) ? $post_array['subtotales'] : null;
                $porcRetaceo        = (isset($post_array['porcRetaceo'])) ? $post_array['porcRetaceo'] : null;
                $retaceo            = (isset($post_array['retaceo'])) ? $post_array['retaceo'] : null;
                $hdnGasto           = $post_array['hdnGasto'];
                $gastos             = (isset($post_array['gastos'])) ? $post_array['gastos'] : null; //gastos nuevos
                /*
                $hdnSector        = $post_array['hdnSector'];
                $cantidadesRtd      = $post_array['cantidadesRtd'];
                $preciosRtd         = $post_array['preciosRtd'];
                $preciosFinalRtd    = $post_array['preciosfinalRtd'];
                $subtotalesRtd      = $post_array['subtotalesRtd'];
                $porcRetaceoRtd     = $post_array['porcRetaceoRtd'];
                $retaceoRtd         = $post_array['retaceoRtd'];
                */
                //$proveedores = $post_array['proveedores'];
                /*
                $documentos         = $post_array['documentos'];//hdnDpv
                $montos             = $post_array['montos'];
                $detalle_documento  = $post_array['txt_detalles_docs'];
                */
                $otroNoDocumentos   = $post_array['OtroNodocumentos'];
                $detalle_cantidad   = (isset($post_array['txt_cantidadproductos'])) ? $post_array['txt_cantidadproductos'] : null;
                // $detalle_productos  = $post_array['txt_productos']; //NO SE UTILIZA?
                //Anexos
                $AnexoRtd       = (isset($post_array['AnexoRtd'])) ? $post_array['AnexoRtd'] : null;
                $TitulosAnexo   = (isset($post_array['titulo_doc'])) ? $post_array['titulo_doc'] : null;
                $NombreAnexo    = (isset($post_array['ruta'])) ? $post_array['ruta'] : null;
                //Se procesan los detalles ya ingresados
                $dataDetalleRetaceo = $this->compras_model->get_detalle_retaceo_consolida(array('drc_id_rtd' => $rtd_id));
                if (!is_array($hdnDetalle)) {
                    $hdnDetalle = array();
                }
                if (is_array($cantidades) && count($cantidades) > 0) {
                    //Se agrega el detalle del retaceo
                    for ($i = 0; $i < count($cantidades); $i++) {
                        $o = $this->gsatelite->get_tabla('drc_detalle_retaceo',array('drc_id_dxd' => $hdnDetalle[$i]));
                        if(count($o) == 0){
                            $detalle_array = array(
                            'drc_id_art'            => $hdnArticulo[$i],
                            'drc_id_cva'            => ($hdnConversion[$i] != '') ? $hdnConversion[$i] : null,
                            'drc_id_rtd'            => $rtd_id,
                            'drc_id_dxd'            => $hdnDetalle[$i],
                            'drc_cantidad'          => convertirFloat($cantidades[$i]),
                            'drc_precio_unitario'   => convertirFloat($precios[$i]),
                            'drc_precio_final'      => convertirFloat($precios_finales[$i]),
                            'drc_subtotal'          => convertirFloat($subtotales[$i]),
                            'drc_retaceo_porcentaje'=> convertirFloat($porcRetaceo[$i]),
                            'drc_retaceo'           => convertirFloat($retaceo[$i]),
                            'drc_retaceo_peso'      => (isset($post_array['peso'][$i]))?convertirFloat($post_array['peso'][$i]): 0,
                            'drc_incrementeo_precio' => ($post_array['txtIncrementoX'][$i] != '')?convertirFloat($post_array['txtIncrementoX'][$i]):0,
                            'drc_retaceo_calculo'    => ($post_array['txtRetaceoX'][$i] != '')?convertirFloat($post_array['txtRetaceoX'][$i]):0,
                            'drc_estado'            => 1,
                            'drc_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'drc_fecha_creacion'    => date('Y-m-d h:i:s'),
                            'drc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'drc_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );
                        $drc_id = $this->gsatelite->ingresar('drc_detalle_retaceo', $detalle_array);

                        }
                     }
                }
                foreach ($dataDetalleRetaceo as $data) {
                    
                    if (!in_array($data['drc_id_dxd'], $hdnDetalle)) {
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('drc_detalle_retaceo', array('drc_id' => $data['drc_id']));
                    }
                }
                if (count($hdnDetalle) > 0) {
                    //Se actualizan los detalles
                    for ($i = 0; $i < count($hdnDetalle); $i++) {
                        $detalle_act_array = array(
                            'drc_cantidad'          => convertirFloat($cantidades[$i]),
                            'drc_precio_unitario'   => convertirFloat($precios[$i]),
                            'drc_precio_final'      => convertirFloat($precios_finales[$i]),
                            'drc_subtotal'          => convertirFloat($subtotales[$i]),
                            'drc_retaceo_porcentaje'=> convertirFloat($porcRetaceo[$i]),
                            'drc_retaceo_peso'       => (isset($post_array['peso'][$i]))?convertirFloat($post_array['peso'][$i]):0.00,
                            'drc_incrementeo_precio' => ($post_array['txtIncrementoX'][$i] != '')?convertirFloat($post_array['txtIncrementoX'][$i]):0,
                            'drc_retaceo'           => convertirFloat($retaceo[$i]),
                            'drc_retaceo_calculo'    => ($post_array['txtRetaceoX'][$i] != '')?convertirFloat($post_array['txtRetaceoX'][$i]):0,
                            'drc_estado'            => 1,
                            'drc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'drc_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );
                        $iddrc = $this->gsatelite->get_tabla('drc_detalle_retaceo',array('drc_id_dxd' => $hdnDetalle[$i])); 
                        $this->gsatelite->actualizar_array('drc_detalle_retaceo', $detalle_act_array, array('drc_id' => $iddrc[0]['drc_id']));
                        if (count($post_array['hdnCec_' . $hdnArticulo[$i]]) > 0) {
                            $hdnDar         = (isset($post_array['hdnDar_' . $hdnArticulo[$i]])) ? $post_array['hdnDar_' . $hdnArticulo[$i]] : null;
                            $id_pxd         = $post_array['hdnCec_' . $hdnArticulo[$i]];
                            $id_prorrateo   = $post_array['hdnPtr_' . $hdnArticulo[$i]];
                            $porcentajes    = $post_array['porcentajesPxd_' . $hdnArticulo[$i]];
                            $totales        = $post_array['totalPxd_' . $hdnArticulo[$i]];
                            for ($j = 0; $j < count($post_array['hdnCec_' . $hdnArticulo[$i]]); $j++) {
                                if ($id_pxd[$j] != '' && isset($hdnDar[$j]) && $hdnDar[$j] > 0) {////////////////validar de donde viene ???
                                    $detalle_pro_array = array(
                                        'dar_id_ptg'            => $id_prorrateo[$j],
                                        'dar_id_drc'            => $hdnDetalle[$i],
                                        'dar_id_pxd'            => $id_pxd[$j],
                                        'dar_porcentaje'        => convertirFloat($porcentajes[$j]),
                                        'dar_total'             => convertirFloat($totales[$j]),
                                        'dar_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'dar_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->actualizar_array('dar_detalle_aplicacion_retaceo', $detalle_pro_array, array('dar_id' => $hdnDar[$j]));
                                }
                            }
                        }
                    }
                }
                //Se procesan los gastos ya ingresados
                $dataGastosRetaceo = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));
                if (!is_array($hdnGasto)) {
                    $hdnGasto = array();
                }
                foreach ($dataGastosRetaceo as $data) {
                    if (!in_array($data['grc_id'], $hdnGasto)) {
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('gxd_gastoxdetalle_documento', array('gxd_id_grc' => $data['grc_id']));
                        $this->gsatelite->borrado_general('grc_gasto_retaceo', array('grc_id' => $data['grc_id']));
                    }
                }
                
                if (is_array($gastos) && count($gastos) > 0) {
                    //Se agrega el detalle de gastos
                    for ($i = 0; $i < count($gastos); $i++) {
                        $gastos_array = array(
                            'grc_id_dpv'            => (trim($documentos[$i]) != '') ? $documentos[$i] : null,
                            'grc_id_gst'            => $gastos[$i],
                            'grc_id_rtd'            => $rtd_id,
                            'grc_otro_documento'    => $otroNoDocumentos[$i],
                            'grc_monto'             => convertirFloat($montos[$i]),
                            'grc_estado'            => 1,
                            'grc_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'grc_fecha_creacion'    => date('Y-m-d h:i:s'),
                            'grc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'grc_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );                        
                        $grc_id = $this->gsatelite->ingresar('grc_gasto_retaceo', $gastos_array);
                        $doc_array          = explode(",", $detalle_documento[$i]);
                        $porcentaje_detalle = 100/$detalle_cantidad[$i];
                        $new_monto          = convertirFloat($montos[$i]) / $detalle_cantidad[$i];
                        foreach ($doc_array as $doc) {
                            $detalle_gastos = array(
                                'gxd_id_grc'            => $grc_id,
                                'gxd_id_dxd'            => $doc,
                                'gxd_monto'             => $new_monto,
                                'gxd_porcentaje'        => $porcentaje_detalle,
                                'gxd_estado'            => 1,
                                'gxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'gxd_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'gxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'gxd_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );
                            $this->gsatelite->ingresar('gxd_gastoxdetalle_documento', $detalle_gastos);
                        };
                    }
                }
                //Se validan los anexos ya ingresados
                $dataAnexosRetaceo = $this->gsatelite->get_tabla('anr_anexo_retaceo', array('anr_id_rtd' => $rtd_id));
                if (!is_array($AnexoRtd)) {
                    $AnexoRtd = array();
                }
                foreach ($dataAnexosRetaceo as $data) {
                    if (!in_array($data['anr_id'], $AnexoRtd)) {
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('anr_anexo_retaceo', array('anr_id' => $data['anr_id']));
                    }
                }
                //Anexos
                if (is_array($NombreAnexo) && count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension            = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                        $nombreArchivo        = trim($TitulosAnexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anx_retaceo/" . $nombreArchivo;
                        $documentos_array = array(
                            'anr_id_rtd'            => $rtd_id,
                            'anr_url'               => $carpeta_destino_anx,
                            'anr_nombre'            => $nombreArchivo,
                            'anr_estado'            => 1,
                            'anr_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'anr_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'anr_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'anr_fecha_modificacion'=> date('Y-m-d H:i:s'),
                        );
                        $nxp_id = $this->gsatelite->ingresar('anr_anexo_retaceo', $documentos_array);
                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
                $afectoinv = false;
                if ($hdnAfectaInv == 1) {
                                    $this->db->join('rdv_retaceo_documento_proveedor', 'rdv_id_rtd = rtd_id');
                    $dpv_id_array = $this->gsatelite->get_tabla('rtd_retaceo_documento_proveedor', array('rtd_id' => $rtd_id));
                    $tipoProcesos_array = json_decode($this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS'), true);
                    $movimientos_array = array();
                    if (count($dpv_id_array) > 0) {
                        $m = 0;
                        foreach ($dpv_id_array as $llave => $valor) {
                            //Preguntamos si el DPV ya afecto inventario
                            $ya_afecto = $this->gsatelite->get_tabla('moi_movimiento_inv',array('moi_id_dpv' => $valor['rdv_id_dpv']));
                            if (count($ya_afecto) == 0) {
                                                $this->db->order_by('dxd_id_bod');
                                                $this->db->group_by('dxd_id_bod');
                                $detalleQuery = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $valor['rdv_id_dpv'], 'dxd_id_bod !=' => ''));
                                $id_proveedor = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_prv', array('dpv_id' => $valor['rdv_id_dpv']));
                                foreach ($detalleQuery as $dxd) {
                                    $bod_id = $dxd['dxd_id_bod'];
                                    $movimientos_array[$llave]['movimientos'] = array(
                                        'moi_id_prv'             => $id_proveedor,
                                        'moi_id_tip'             => $tipoProcesos_array['RETACEO'],
                                        'moi_id_bod'             => $bod_id,
                                        'moi_id_rtd'             => $rtd_id,
                                        'moi_id_dpv'             => $valor['rdv_id_dpv'],
                                        'moi_documento'          => $txtNumRetaceo,
                                        'moi_descripcion'        => $txTObservaciones . '-- Proviniente de Retaceo',
                                        'moi_fecha_mov'          => formatear_fecha('Y-m-d H:i:s', $valor['rtd_fecha_registro']),
                                        'moi_estado'             => 1,
                                        'moi_usu_creacion'       => $this->tank_auth->get_user_id(),
                                        'moi_fecha_creacion'     => date('Y-m-d H:i:s'),
                                        'moi_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                        'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv'=>$valor['rdv_id_dpv'],'art_tipo'=>0,'dxd_id_bod'=>$bod_id));
                                    if (count($detalles_doc) > 0) {
                                        foreach ($detalles_doc as $key => $det) {
                                            $nuevo_precio = 0;
                                            $pf = ($precios_finales[$m] > 0) ? $precios_finales[$m] : (($txtTotalGastos + $txtTotalProdcutos) / $cantidades[$m]);
                                            if ($costo_promedio > 0) {
                                                $nuevo_precio = $this->recalcular_precio_promedio($det['dxd_id_art'],$bod_id,convertirFloat($det['dxd_cantidad']), convertirFloat($pf));
                                            }
                                            $precio = ($costo_promedio == 1) ? $nuevo_precio : convertirFloat($pf);
                                            $movimientos_array[$llave]['detalles'][$key]['sar_saldo'] = array(
                                                'sar_id_art'            => $det['dxd_id_art'],
                                                'sar_id_bod'            => $bod_id,
                                                'sar_cant_actual'       => convertirFloat($cantidades[$m]),
                                                'sar_precio'            => $precio,
                                                'sar_fecha_caducidad'   => null,
                                                'sar_id_sxb'            => $det['dxd_id_sxb'],
                                                'sar_estado'            => 1,
                                                'sar_usu_creacion'      => $this->tank_auth->get_user_id(),
                                                'sar_fecha_creacion'    => date('Y-m-d H:i:s'),
                                                'sar_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                                'sar_fecha_modificacion'=> date('Y-m-d H:i:s')
                                            );
                                            $movimientos_array[$llave]['detalles'][$key]['dee_movimiento'] = array(
                                                'dee_id_moi'            => null,
                                                'dee_id_art'            => $det['dxd_id_art'],
                                                'dee_id_sar'            => null,
                                                'dee_id_cva'            => $det['dxd_id_cva'],
                                                'dee_id_sxb'            => $det['dxd_id_sxb'],
                                                'dee_cantidad'          => convertirFloat($cantidades[$m]),
                                                'dee_precio'            => convertirFloat($precios_finales[$m]),
                                                'dee_subtotal'          => convertirFloat($cantidades[$m]) * convertirFloat($precios_finales[$m]),
                                                'dee_estado'            => 1,
                                                'dee_usu_creacion'      => $this->tank_auth->get_user_id(),
                                                'dee_fecha_creacion'    => date('Y-m-d H:i:s'),
                                                'dee_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                                'dee_fecha_modificacion'=> date('Y-m-d H:i:s')
                                            );
                                            $m++;
                                        }
                                        
                                    }
                                }
                            }
                        }
                    }
                    if (count($movimientos_array) > 0) {
                        $this->ingresar_entrada($movimientos_array);
                        $afectoinv = true;
                    }                    
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Retaceo", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1 && $hdnAfectaInv == 0) {
                redirect('modulo_compras/procesos/editar_retaceo_consolidado/' . $rtd_id);
            } else if ($tipo_btn == 1 && $hdnAfectaInv == 1) {
                if ($afectoinv) {
                    redirect('modulo_compras/procesos/retaceos_consolidados/');
                } else {
                    redirect('modulo_compras/procesos/editar_retaceo_consolidado/' . $rtd_id);
                }
            } else {
                redirect('modulo_compras/procesos/retaceos_consolidados/');
            }
        }        
        $prv_name = "";
        $i=0;
        $retaceo        = $this->compras_model->get_lista_documentos_editar_retaceo_consolidado(array('rtd_id' => $rtd_id));                      
        $list_array_dpv = array_column($retaceo, 'dpv_id');
        $documento  = $this->compras_model->get_documentos_proveedor(null, $list_array_dpv);
        $num_docs = array_column($documento, 'dpv_numero_documento');
        $ids_prov = array_column($documento, 'dpv_id_prv');
        $docs_num = implode(', ', $num_docs);
        $prv_ids = implode(', ', array_unique(array_filter($ids_prov)));
        $proveedores = $this->gsatelite->get_tabla('prv_proveedor', array("prv_id in ($prv_ids)" => NULL));
        foreach ($proveedores as $key => $value) {
            if ($i==0) {
                $prv_name .= ($value['prv_tipo_pers'] == 2) ? $value['prv_apellido'] : $value['prv_nombre'] . ' ' . $value['prv_apellido']; 
                $i++;
            } else {
                $prv_name .= ($value['prv_tipo_pers'] == 2) ? ', ' . $value['prv_apellido'] : ', ' . $value['prv_nombre'] . ' ' . $value['prv_apellido']; 
            }            
        }
        $global_iddpvs              = implode(',', array_column($documento, 'dpv_id'));
        $data['html_detalles_dpvs'] = $this->get_detalles_documentos_proveedor_retaceo_macivo($global_iddpvs,1);
        $data['retaceo']            = $retaceo[0];
        // $data['ver_retaceo']        = $ver_detalle;
        $data['documento']          = $documento;
        $data['numero_documentos']  = $docs_num;
        $data['nombre_proveedor']   = $prv_name;
        $data['detalle_documento']  = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $retaceo[0]['rtd_id_dpv']));
        $data['detalle_retaceo']    = $this->compras_model->get_detalle_retaceo(array('drc_id_rtd' => $rtd_id));
        $data['detalle_gastos']     = $this->compras_model->get_gastos_retaceo(array('grc_id_rtd' => $rtd_id));
        $data['gastos']         = $this->gsatelite->get_tabla('gst_gasto', array('gst_estado' => 1));
        $data['global_iddpvs']      = $global_iddpvs;
        $this->db->group_by('prv_id');
        $proveedores = $proveedores = $this->compras_model->get_proveedor_pers();
        //$data['proveedores']    = $this->gsatelite->get_tabla('prv_proveedor', array('prv_estado' => 1));
        //$proveedores = $this->compras_model->get_proveedor_pers();        
        $options     = '<option value=""></option>';
        foreach ($proveedores as $key) {
            if($key['pro'] != '') {
                $options .= '<option value="' . $key['prv_id'] . '">' . $key['pro'] . '</option>';
            }
        }
        $data['proveedores']    = $options;        
        $data['anexos_retaceo'] = $this->gsatelite->get_tabla('anr_anexo_retaceo', array('anr_id_rtd' => $rtd_id));
        $data['titulo_personal'] = "Editar Retaceo Consolidado";
        $parametro = json_decode($this->gsatelite->get_parametro_emp('SYS_CODIGO_RETACEO'), true);
        $data['peso_porc'] = (isset($parametro["PESO_PORC"]) && is_numeric($parametro["PESO_PORC"])) ? $parametro["PESO_PORC"] : 0;
        $this->_cargarvista($data);
    }

        /**
    * @author Jose Olmedo   
    * @return imprime los detalles del contrato 
    */
        public function detalle_contrato_proveedor($id=null) {

            $data['registro_contrato'] = $this->compras_model->get_cop_contrato_proveedor(array('cop_id' => $id));
            $data['contrato_proveedor'] = $this->compras_model->get_ccv_contrato_proveedor(array('ccv_id_cop' => $id));
            $data['cheques'] = $this->compras_model->get_dch_detalle_cheque();
            $data['meses'] = [1=>'Enero', 2=>'Febrero', 3=>'Marzo',4=>'Abril',5=>'Mayo',6=>'Junio', 7=>'Julio',8=>'Agosto', 9=>'Septiembre',10=>'Octubre',11=>'Noviembre',12=>'Diciembre'];
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/detalle_contrato_proveedor',$data);
        }

            /**
    * @author Jose Olmedo   
    * @return imprime los cheques documento proveedor que pertenezca a un contrato
    */
            public function detalle_contrato_proveedor_cheques($id=null) {

                $data['cheques'] = $this->compras_model->get_dch_detalle_cheque(array("dch_id_dpv" => $id));
                $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/contrato_proveedor_cheques',$data);
            }

    /**
    * @author Jose Olmedo   
    * @return se edita el doc proveedor
    */
    public function editar_contrato_proveedor($cop_id=null, $ccv_id=null, $dpv_id=null) {

        if ($_POST) {
            $post_array            = $this->input->post();
            $txtNumDoc             = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;
            $txtFechaDoc           = ($post_array['txtFechaDoc'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDoc'])) : null;
            $txtFechaVencimiento   = ($post_array['txtFechaVencimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVencimiento'])) : null;
            $txtFechaConta         = ($post_array['txtFechaConta'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaConta'])) : null;
            $proyecto              = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $act_general           = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $presupuesto           = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $act_especifica        = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $array = array('dpv_numero_documento' => $txtNumDoc,
               'dpv_fecha_documento' => $txtFechaDoc,
               'dpv_fecha_vencimiento' => $txtFechaVencimiento,
               'dpv_fecha_contabilizacion' => $txtFechaConta,
               'dpv_id_pcl'                => $proyecto,
               'dpv_id_psp'                => $presupuesto,
               'dpv_id_acg'                => $act_general,
               'dpv_id_ace'                => $act_especifica
           );
            $respuesta = $this->gsatelite->actualizar_array('dpv_documento_proveedor',$array, array('dpv_id' => $dpv_id));

            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Doc. Proveedor", 'texto_alerta' => "El documento Proveedor ha sido actualizado exitosamente.");
                $this->session->set_flashdata($alerta);
            }

            echo json_encode($cop_id);
            die();
        }

        $data['registro_contrato'] = $this->compras_model->get_cop_contrato_proveedor(array('cop_id' => $cop_id));
        $data['contrato_proveedor'] = $this->compras_model->get_ccv_contrato_proveedor(array('ccv_id' => $ccv_id));
        foreach ($data['contrato_proveedor'] as $key) {
            $data['dpv_datos']['impuesto'] += $key['ccv_impuesto'];
            $data['dpv_datos']['subtotal'] += $key['ccv_monto'];
            $data['dpv_datos']['total'] += $key['ccv_total'];
        } 
        foreach ($data['registro_contrato'] as $key) {
            $imp_id[] = $key['imp_id'];
        }
        $data['imp_id'] = implode(',', $imp_id);
        $data['ccv_id'] = $ccv_id;
        $data['proveedor'] = $this->gsatelite->get_tabla("prv_proveedor", array('prv_estado' => 1));
        $data['dpv_data'] = $this->gsatelite->get_tabla("dpv_documento_proveedor", array('dpv_id' => $data['contrato_proveedor'][0]['ccv_id_dpv']));
        $data['tipo_documento'] = $this->gsatelite->get_tabla("tif_tipo_factura", array('tif_estado' => 1));
        $data['tipo_pago'] = $this->gsatelite->get_tabla("tpg_tipo_pago", array('tpg_estado' => 1));
        $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
        $select_proyecto = '<option value=""></option>';
        foreach ($proyectos_reg as $key) {
            $selected = ($data['dpv_data'][0]['dpv_id_pcl'] == $key['pcl_id'])?'selected':'';

            $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
            $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
            $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
        }
        $data['proyectos'] = $select_proyecto;

        $slc_general                = ($data['dpv_data'][0]['dpv_id_acg'] != "" )? $this->get_actividades_generalesxpresupusto($data['dpv_data'][0]['dpv_id_psp'], $data['dpv_data'][0]['dpv_id_acg'],false,false):'<option value=""></option>';
        $data['general']            = $slc_general;

        $slc_presupuesto            = ($data['dpv_data'][0]['dpv_id_psp'] != "" )?$this->get_presupuestoxproyecto($data['dpv_data'][0]['dpv_id_pcl'], $data['dpv_data'][0]['dpv_id_psp'],false):'<option value=""></option>';
        $data['presupuesto']        = $slc_presupuesto;

        $slc_especifica             = ($data['dpv_data'][0]['dpv_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($data['dpv_data'][0]['dpv_id_acg'], $data['dpv_data'][0]['dpv_id_psp'], $data['dpv_data'][0]['dpv_id_ace'],true,false,false):'<option value=""></option>';
        $data['especifica']         = $slc_especifica;

        $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
        $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/editar_contrato_proveedor',$data);
    }

                /**
    * @author Jose Olmedo   
    * @return anula contratos proveedor
    */
                public function anular_contrato_proveedor($id=null) {

                    if ($_POST) {
                        $post_array            = $this->input->post();
                        $observacion           = $post_array['txtdescripcion'];
                        $array = array('cop_observacion_desact' => $observacion,
                           'cop_fecha_desact' => date('Y-m-d H:i:s'),
                           'cop_estado' => 0);
                        $respuesta = $this->gsatelite->actualizar_array('cop_contrato_proveedor', $array, array('cop_id' => $id));

                        if ($respuesta > 0) {
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cuotas de Contrato", 'texto_alerta' => "El documento proveedor a sido Anulado con exito.");
                            $this->session->set_flashdata($alerta);
                        }
                        echo json_encode($respuesta);
                        die();
                    }
                    $data['cop_id'] = $id;
                    $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/anular_contrato_proveedor',$data);
                }

                /**
    * @author Jose Olmedo   
    * @return invoca el la facturacion para contrato por medio del doc.proveedor
    */
                public function contrato_proveedorXdoc_proveedor($ccv_id=null,$cop_id=null) {

                    $data['registro_contrato'] = $this->compras_model->get_cop_contrato_proveedor(array('cop_id' => $cop_id));
                    $data['contrato_proveedor'] = $this->compras_model->get_ccv_contrato_proveedor(array('ccv_id' => $ccv_id));
                    foreach ( $data['contrato_proveedor'] as $key) {
                        $data['dpv_datos']['impuesto'] += $key['ccv_impuesto'];
                        $data['dpv_datos']['subtotal'] += $key['ccv_monto'];
                        $data['dpv_datos']['total'] += $key['ccv_total'];
                    } 
                    foreach ($data['registro_contrato'] as $key) {
                        $imp_id[] = $key['imp_id'];
                    }
                    $data['imp_id'] = implode(',', $imp_id);
                    $data['ccv_id'] = $ccv_id;
                    $data['proveedor'] = $this->gsatelite->get_tabla("prv_proveedor", array('prv_estado' => 1));
                    $data['tipo_documento'] = $this->gsatelite->get_tabla("tif_tipo_factura", array('tif_estado' => 1));
                    $data['tipo_pago'] = $this->gsatelite->get_tabla("tpg_tipo_pago", array('tpg_estado' => 1));
                    $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
                    $select_proyecto = '<option value=""></option>';
                    foreach ($proyectos_reg as $key) {
                        $selected = '';
                        if($orc_id != null){
                            $selected = ($orden_data[0]['orc_id_pcl'] == $key['pcl_id'])?'selected':'';
                        }

                        $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
                        $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                        $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
                    }
                    $data['proyectos'] = $select_proyecto;
                    $data['presupuesto_compra'] = $this->gsatelite->get_campo('par_parametro', 'par_valor', array('par_codigo' => 'SYS_PRESUPUESTO_COMPRA'));
                    $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/contrato_proveedorXdoc_proveedor',$data);
                }

                    /**
    * @author Jose Olmedo   
    * @return almacena los datos de contrato proveedor en doc.proveedor
    */
                    public function agregar_contratoXdocproveedor($ccv_id=null) {
                        if ($_POST) {
                            $post_array            = $this->input->post();
                            $slcProveedor          = $post_array['slcProveedor'];
                            $slcTipoPago           = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
                            $slcTipoDocumento      = ($post_array['slcTipoDocumento'] != '') ? $post_array['slcTipoDocumento'] : null;
                            $txtNumDoc             = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;
                            $txtFechaDoc           = ($post_array['txtFechaDoc'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDoc'])) : null;
                            $txtFechaVencimiento   = ($post_array['txtFechaVencimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVencimiento'])) : null;
                            $txtFechaConta         = ($post_array['txtFechaConta'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaConta'])) : null;
                            $txtImpuestosGeneral   = str_replace(',','',($post_array['txtImpuestosGeneral']));
                            $txtSubtotalGeneral    = str_replace(',','',($post_array['txtSubtotalGeneral']));
                            $txtTotalGeneral       = str_replace(',','',($post_array['txtTotalGeneral']));
                            $impuestos             = ($post_array['txtidimpuestos'] != '') ? $post_array['txtidimpuestos'] : null;
                            $proyecto              = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
                            $act_general           = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
                            $presupuesto           = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
                            $act_especifica        = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                            $documento_array = array(
                                'dpv_id_prv'                => $slcProveedor,
                                'dpv_id_tpg'                => $slcTipoPago,
                                'dpv_id_tif'                => $slcTipoDocumento,
                                'dpv_id_pcl'                => $proyecto,
                                'dpv_id_psp'                => $presupuesto,
                                'dpv_id_acg'                => $act_general,
                                'dpv_id_ace'                => $act_especifica,
                                'dpv_numero_documento'      => $txtNumDoc,
                                'dpv_fecha_documento'       => $txtFechaDoc,
                                'dpv_fecha_contabilizacion' => $txtFechaConta,
                                'dpv_fecha_vencimiento'     => $txtFechaVencimiento,
                                'dpv_afecta_inventario'     => 0,
                                'dpv_tipo'                  => 2,
                                'dpv_pagado'                => 0,
                                'dpv_monto_abono'           => 0,
                                'dpv_monto_pendiente'       => convertirFloat($txtTotalGeneral),
                                'dpv_impuesto'              => convertirFloat($txtImpuestosGeneral),
                                'dpv_subtotal'              => convertirFloat($txtSubtotalGeneral),
                                'dpv_total'                 => convertirFloat($txtTotalGeneral),
                                'dpv_estado'                => 1,
                                'dpv_usu_creacion'          => $this->tank_auth->get_user_id(),
                                'dpv_fecha_creacion'        => date('Y-m-d H:i:s'),
                                'dpv_usu_modificacion'      => $this->tank_auth->get_user_id(),
                                'dpv_fecha_modificacion'    => date('Y-m-d H:i:s')
                            );
                            $dpv_id = $this->gsatelite->ingresar('dpv_documento_proveedor', $documento_array);
                            if ($dpv_id > 0) {
                //Se obtienen los detalles de la grid
                                $productos = $post_array['productos'];
                                $impuestosProducto = $post_array['impuestosProducto'];
                                $subtotalesProducto = $post_array['subtotalesProducto'];
                                $totalesProducto = $post_array['totalesProducto'];

                                if (count($productos) > 0) {
                    //Se ingresan los detalles de la orden
                                    for ($i = 0; $i < count($productos); $i++) {

                                        $producto_id = null;
                        //$conversion_prodc = null;
                                        $activo_id = null;
                                        $producto_id = $productos[$i];
                        //$conversion_prodc = (trim($conversiones[$i])?$conversiones[$i]:null);

                                        $detalle_array = array(
                                            'dxd_id_dpv' => $dpv_id,
                                            'dxd_id_art' => $producto_id,
                                            'dxd_cantidad' => 1,
                                            'dxd_precio_unitario' => 0,
                                            'dxd_impuesto' => convertirFloat($impuestosProducto[$i]),
                                            'dxd_descuento' => 0,
                                            'dxd_subtotal' => convertirFloat($subtotalesProducto[$i]),
                                            'dxd_total' => convertirFloat($totalesProducto[$i]),
                                            'dxd_estado' => 1,
                                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'dxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                        );
                                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);
                                    }
                                }
                        //Si se ingresa el detalle, se ingresan los impuestos y retenciones
                                if ($dxd_id > 0) {
                            ////// ACTUALIZAR CANTIDAD EN LOS DETALLES DE LA ORDEN DE COMPRA (SI APLICA) ///////
                            //Se valida existan impuestos
                                    if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                        $impuestos_array = explode(',', $impuestos);

                                        if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                            for ($j = 0; $j < count($impuestos_array); $j++) {

                                                if ($impuestos_array[$j] != '') {
                                                    $por_imp = $this->gsatelite->get_campo('imp_impuesto','imp_porcentaje', array('imp_id'=>$impuestos_array[$j]));
                                                    if($por_imp>0){
                                                        $mon_im = ($por_imp/100)*$subtotalesProducto[$i];
                                                    }else{

                                                        $imp_val = $this->gsatelite->get_campo('imp_impuesto','imp_valor', array('imp_id'=>$impuestos_array[$j]));
                                                //print_r($cantidades);
                                                //print_r($imp_val); die();
                                                        $mon_im = $cantidades[$i] * $imp_val;
                                                        $por_imp = $imp_val;
                                                    }
                                                    $ixo_array = array(
                                                        'idd_id_imp' => $impuestos_array[$j],
                                                        'idd_id_dxd' => $dxd_id,
                                                        'idd_porcentaje' => $por_imp,
                                                        'idd_monto' => $mon_im,
                                                        'idd_estado' => 1,
                                                        'idd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                        'idd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                        'idd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                        'idd_fecha_creacion' => date('Y-m-d H:i:s')
                                                    );
                                                    $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                                }
                                            }
                                        }
                                    }

                        } // End if
                    }
                    $art_array = array(
                        'ccv_id_dpv' => $dpv_id,
                        'ccv_facturado' => 1 
                    );
                    $respuesta = $this->gsatelite->actualizar_array('ccv_cuota_contrato_proveedor',$art_array, array('ccv_id' => $ccv_id));
                }
                $id_cop = $this->gsatelite->get_campo('ccv_cuota_contrato_proveedor','ccv_id_cop', array('ccv_id' => $ccv_id));

                $can_cuotas = $this->gsatelite->get_campo('cop_contrato_proveedor','cop_cuota_pendiente', array('cop_id' => $id_cop));

                $respuesta = $this->gsatelite->actualizar_array('cop_contrato_proveedor',array('cop_cuota_pendiente' => ($can_cuotas-1)), array('cop_id' => $id_cop));

                if ($respuesta > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cuotas de Contrato", 'texto_alerta' => "El documento proveedor a sido generado con exito.");
                    $this->session->set_flashdata($alerta);
                }

                echo json_encode($id_cop);
            }

/**
    * @author Jose Olmedo   
    * @return genera las cuotas del contrato
    */
public function rango_meses() {

    $fecha_inicio = $this->input->post('fechainicio');
    $fecha_fin = $this->input->post('fechafin');

    $datetime1=new DateTime($fecha_inicio);
    $datetime2=new DateTime($fecha_fin);

        # obtenemos la diferencia entre las dos fechas
    $interval=$datetime2->diff($datetime1);

        # obtenemos la diferencia en meses
    $intervalMeses = $interval->format("%m");
        # obtenemos la diferencia en años y la multiplicamos por 12 para tener los meses
    $intervalAnos = $interval->format("%y")*12;

        //echo "hay una diferencia de ".($intervalMeses+$intervalAnos)." meses";

    $cantidadmeses =  $intervalAnos + $intervalMeses + 1;

    echo json_encode($cantidadmeses);

}

            /**
    * @author Jose Olmedo   
    * @return genera las cuotas del contrato
    */
            public function cuotas_contratos($id=null) {

                $registro_contrato = $this->compras_model->get_cop_contrato_proveedor(array('cop_id' => $id));

                $datetime1=new DateTime($registro_contrato[0]['cop_fecha_inicio']);
                $datetime2=new DateTime($registro_contrato[0]['cop_fecha_fin']);

        # obtenemos la diferencia entre las dos fechas
                $interval=$datetime2->diff($datetime1);

        # obtenemos la diferencia en meses
                $intervalMeses = $interval->format("%m");
        # obtenemos la diferencia en años y la multiplicamos por 12 para tener los meses
                $intervalAnos = $interval->format("%y")*12;

        //echo "hay una diferencia de ".($intervalMeses+$intervalAnos)." meses";

                $cantidadmeses =  $intervalAnos + $intervalMeses;

                foreach ($registro_contrato as $key) {
                    if ($key['imp_valor'] > 0 ) {
                        $impvalor += $key['imp_valor'];
                    } else {
                        $imporcentaje += $key['imp_porcentaje']; 
                    }
                }

                $porcentajeimpuesto = (($impvalor*100)/$registro_contrato[0]['cop_cuota_mensual']);

                $imporcentaje += $porcentajeimpuesto;

                $montosimpuesto = $registro_contrato[0]['cop_cuota_mensual'] / (($imporcentaje/100)+1);

                $impuesto = $registro_contrato[0]['cop_cuota_mensual'] - $montosimpuesto;

                if ($registro_contrato[0]['cop_fecha_facturacion'] != '') {
                    $fecha_facturacion = explode('-', formatear_fecha('d-m-Y', $registro_contrato[0]['cop_fecha_facturacion']));

                    $fechainicio = explode('-', formatear_fecha('d-m-Y', $registro_contrato[0]['cop_fecha_inicio']));

                    $fechar = $fecha_facturacion[0].'-'.$fechainicio[1].'-'.$fechainicio[2];
                } else {
                    $fechar = formatear_fecha('d-m-Y',$registro_contrato[0]['cop_fecha_inicio']);
                }

        //$fechar = $registro_contrato[0]['cop_fecha_inicio'];
                $data = null;
                for ($i=0; $i <= $cantidadmeses ; $i++) {
                    $fecha = date('Y-m-d',strtotime($fechar.'+ '.$i.' month'));
                    $data[] = array(
                        'ccv_id_cop' => $registro_contrato[0]['cop_id'],
                        'ccv_fecha_cuota' => $fecha,
                        'ccv_monto' => $montosimpuesto,
                        'ccv_impuesto' => $impuesto,
                        'ccv_total' => $registro_contrato[0]['cop_cuota_mensual'],
                        'ccv_estado' => 1,
                        'ccv_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ccv_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ccv_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ccv_fecha_modificacion' => date('Y-m-d H:i:s')
                    );    
                }
                if (count($data) > 0) {
                    $cant_afe = $this->gsatelite->ingresar('ccv_cuota_contrato_proveedor', $data, true);
                }
                $resultado = $this->gsatelite->actualizar_array('cop_contrato_proveedor', array('cop_generado' => 1,
                    'cop_cantidad_cuota' => $cant_afe,
                    'cop_cuota_pendiente' => $cant_afe)
                , array('cop_id' => $id));

                if ($cant_afe > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cuotas de Contrato", 'texto_alerta' => "Las cuotas del contrato has sido generadas exitosamente.");
                    $this->session->set_flashdata($alerta);
                }

                redirect('/modulo_compras/procesos/registro_contratos');
            }

            /**
    * @author Jose Olmedo   
    * @return trae la cantidad de meses exactos
    */
/*    public function rango_meses() {
        $fechainicio = $this->input->post('fechainicio');
        $fechafin = $this->input->post('fechafin');

        $meses = $this->db->select('TIMESTAMPDIFF(MONTH,"'.$fechainicio.'","'.$fechafin.'") as fecha',false);*/

        /*print_r($meses->get()->result_array());die();*/

/*        $meses = $meses->get()->result_array();
       echo json_encode($meses[0]['fecha']);
   }*/

    /**
    * @author Elman Ortiz    
    * @return Returna la lista de documentos
    */
    public function get_editar_detalles_documentos_proveedor_retaceo_macivo($global_iddpvs) {
        satelite_validar();

        //$global_iddpvs = $this->input->post('global_iddpvs');            
        //Obtener detalles del proveedor
        //$data['dpv_registros'] = $this->compras_model->get_detalles_documentos_proveedor_retaceo_macivo($global_iddpvs);        
        $documentos          = $this->compras_model->get_documentos_proveedor_retaceo_macivo_detalles(null, $global_iddpvs);               
        
        $data['documentos']  = $documentos;
        
        $data['detalle_documento'] = $this->compras_model->get_detalles_documentos_proveedor_retaceo_macivo($global_iddpvs, array('art_tipo'=>0));
        //print_r($this->db->last_query()); die();
        $html = $this->load->view('modulo_compras/procesos/detalle_x_documentos', $data, true);
        
        //calculos de editar retaceo
        $resultado = $this->get_editar_detalles_documentos_proveedor_retaceo_macivo_calculos($data);

        $totalProductos = $resultado['totalProductos']; 

        $total_retaceo_porc = $resultado['total_retaceo_porc'];

        $total_retaceo_peso = $resultado['total_retaceo_porc'];

        $total_retaceo_monto = $resultado['total_retaceo_monto'];
        
        $select_productos = $resultado['select_productos'];

        //print_r($select_productos); die();
        //return $html;
        return json_encode(array('html' => $html, 'totalProductos' => $totalProductos, 'total_retaceo_porc' => $total_retaceo_porc, 'total_retaceo_peso' => $total_retaceo_porc, 'total_retaceo_monto' => $total_retaceo_monto, 'select_productos' => $select_productos));
    }

    /**
    * @author Elman Ortiz    
    * @return Returna los calculos para el editar del retaceo
    */
    public function get_editar_detalles_documentos_proveedor_retaceo_macivo_calculos($data) {
        $documentos         = $data['documentos'];
        $detalle_documento  = $data['detalle_documento'];
        //print_r($documentos); die();
        $cantidad_decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') > 0) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;

        $select_productos   = "";
        $arreglo_productos  = "";

        if (count($detalle_documento) > 0):
            $i = 1;
            $totalProductos         = array_sum(array_column($detalle_documento, 'dxd_subtotal'));
            $total_retaceo_porc     = 0;
            $total_retaceo_monto    = 0;
            foreach ($detalle_documento as $dxd):
                //Determinar el documento
                $indice_seleccionado ='';
                foreach ($documentos as $i => $doc) {
                    if($doc['dpv_id'] == $dxd['dxd_id_dpv']){
                        $indice_seleccionado = $i;
                    }
                }
                $documento = $documentos[$indice_seleccionado];
                //print_r($documentos); die();

                $id_detalle          = $dxd['dxd_id'];
                $arreglo_productos  .= "'".$dxd['art_id']."',";
                $select_productos   .= "<option id='".$dxd['art_id']."' data-detalle='".$id_detalle."'>".$dxd['numero_documento']." - ".$dxd['art_nombre']."</option>";
                $producto_id         = "";
                $codigo_producto     = "";
                $nombre_producto     = "";
                $unidad_medida       = "";
                $cantidad_productos  = convertirFloat($dxd['dxd_cantidad']);
                $precio_producto     = convertirFloat($dxd['dxd_precio_unitario']);
                $subtotal            = convertirFloat($dxd['dxd_subtotal']);
                $total               = convertirFloat($dxd['dxd_total']);
                $retaceo_porc        = (($dxd['dxd_subtotal'] / $totalProductos) * 100);
                $retaceo_porc_format = convertirFloat($retaceo_porc);
                $retaceo_monto       = (($retaceo_porc_format/100) * $totalProductos); // Formular para ir sumando al total de retaceo
                $categoria_id        = '';
                // die(print_r($dxd['dxd_subtotal'].'/'. $totalProductos));
                $total_retaceo_porc  += $retaceo_porc;
                $total_retaceo_monto += $retaceo_monto;
                $monto_gasto = 0 * $retaceo_porc;                                                                
                $precio_final = ($retaceo_monto)/$cantidad_productos;
                switch ($documento['dpv_tipo']) {
                    case 1:
                    $producto_id        = $dxd['art_id'];
                    $codigo_producto    = $dxd['art_codigo'];
                    $nombre_producto    = $dxd['art_nombre'];
                    $unidad_medida      = $dxd['mep_nombre'];
                    $conversion_id      = $dxd['cva_id'];
                    $categoria_id       = $dxd['art_id_tia'];
                    break;
                    case 2:
                    $producto_id        = $dxd['art_id'];
                    $codigo_producto    = $dxd['art_codigo'];
                    $nombre_producto    = $dxd['art_nombre'];
                    $unidad_medida      = '';
                    $categoria_id       = $dxd['art_id_tia'];
                    break;
                    case 3:
                    $producto_id        = $dxd['art_id'];
                    $codigo_producto    = $dxd['act_codigo'];
                    $nombre_producto    = $dxd['act_nombre'];
                    $unidad_medida      = '';
                    $categoria_id       = $dxd['act_id_tac'];
                    break;
                    case 4:
                    $producto_id        = $dxd['art_id'];
                    $codigo_producto    = $dxd['art_codigo'];
                    $nombre_producto    = $dxd['art_nombre'];
                    $unidad_medida      = $dxd['mep_nombre'];
                    $conversion_id      = $dxd['cva_id'];
                    $categoria_id       = $dxd['art_id_tia'];
                    break;
                }
                ?>

                <?php
        //Se obtienen los detalles 
                $detalle_prorrateo  = $this->compras_model->get_detalle_prorrateo_docProv(array('pxd_id_dxd' => $id_detalle));
                $prorrateo_id       = (isset($detalle_prorrateo[0]['dpr_id_ptg']) && $detalle_prorrateo[0]['dpr_id_ptg'] != '') ? $detalle_prorrateo[0]['dpr_id_ptg'] : null;
                $prorrateo_det      = $this->gsatelite->get_dropdown('ptg_prorrateo_gasto', '{ptg_nombre}', 'prorrateos', array('ptg_estado' => 1), $prorrateo_id, null, null, true);
        //$detalleProrrateo = $this->compras_model->obtener_detalleprorrateo($prorrateo_id);
                $opciones_cec       = "<option></option>";
        /*foreach ($detalleProrrateo as $row) {
            $opciones_cec .= '<option data-porcentaje="' . $row['dpr_porcentaje'] . '" data-cuenta="' . $row['cec_cuenta_contable'] . '" value="' . $row['dpr_id'] . '">' . $row['cec_nombre'] . '</option>';
        }*/
        ?>

        <?php
        if (count($detalle_prorrateo) > 0):
            foreach ($detalle_prorrateo as $pxd):
                ?>

                <?php
            endforeach;
        endif;
        ?>

        <?php
        $i++;
    endforeach;
endif;
$arreglo_productos = substr($arreglo_productos, 0, -1);

return array('totalProductos' =>$totalProductos, 'total_retaceo_porc' => $total_retaceo_porc, 'total_retaceo_monto' => $total_retaceo_monto, 'select_productos' => $select_productos);

}


    /**
        * @author Francisco Orozco
        * @since  18/06/2019
        * @param  prespuesto 
        * @param  especifico 
        * @param  producto 
        * @return JSON si apruena o no
        * Descripcion: Verifica si el producto ha sido agregado en detalle del presupuesto
    */
    public function articulo_aprobado() {
        $presupuesto= $this->input->post("presupuesto");
        $especifico = $this->input->post("especifico");
        $producto   = $this->input->post("producto");
        $aprobado   = 0;  
        
        //verificar si se han configurado productos.

        $where_configuracion = array(
            'dps_id_psp' => $presupuesto,
            'dps_id_ace' => $especifico,
            'atp_estado' => 1,
        );

        $this->db->join("dps_detalle_presupuesto","dps_id = atp_id_dps");
        $verificacion = $this->gsatelite->count('atp_articulo_detalle_presupuesto', $where_configuracion); 

        if ( $verificacion == 0 ) { //si no esta configurado...cualquier producto pasara.
            $aprobado = 1;
        } else {
            $where      = array(
                'dps_id_psp' => $presupuesto,
                'dps_id_ace' => $especifico,
                'atp_estado' => 1,
                'atp_id_art' => $producto
            );

            $this->db->join("dps_detalle_presupuesto","dps_id = atp_id_dps");
            $data = $this->gsatelite->get_tabla('atp_articulo_detalle_presupuesto', $where);        
            
            if ( count($data) > 0 ) {
                $aprobado = 1;
            }
        }    
        
        echo json_encode( array('aprobacion' => $aprobado) );
        die();
    }

    public function lista_comprobantes($liquidacion = null, $caja_chica = null) {
        if ( $liquidacion > 0 && $caja_chica > 0 ) {
            $lista_comprobantes = array(
                "liquidacion"   => $liquidacion, 
                "caja_chica"    => $caja_chica
            );
            $this->session->set_flashdata($lista_comprobantes);
            redirect('/modulo_compras/procesos/agregar_doc_proveedor');
        } else {
            redirect('/auth/login/');
        }
    }

    /*********************INICIO NOTA DE DEBITO DESDE DOC PROVEEDOR********************/
    /*
     * @ver_detalle: 1 = Ver en Iframe, 2 = Ver como pantalla normal, null = Editar la pantalla
     * @redireccion: 1 = No redireccione a DPV de orden de compras
     */
    function crear_nota_debito($dpv_id = null, $ver_detalle = null, $redireccion = null) {        
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            $costo_promedio     = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            //print_r($post_array);
            //die();
            /**********INICIO ACTUALIZAR EL DPV A PARTIR DE LA NOTA DE DEBITO**************/
            /*            $dpv_proviene = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id' => $dpv_id));
            if(count($dpv_proviene)>0){*/
                //Total pagado en la nota de debito
                //$total_de_la_nota_debito = str_replace(',', '', $post_array['txtTotalGeneral']);                

                /*                $dpv_nota_monto_abono = $dpv_proviene[0]['dpv_monto_abono'];
                $dpv_nota_monto_pendiente = $dpv_proviene[0]['dpv_monto_pendiente'];                
                $dpv_nota_monto_nta_debito = str_replace(',', '', $post_array['txtTotalGeneral']);*/
                $dpv_nota_monto_nta_debito = str_replace(',', '', $post_array['txtTotalGeneral']);
                //$monto_saldo_nota_temporal = ($total_de_la_nota_debito - $dpv_nota_monto_pendiente);
                //Calcular el saldo
                //Si el monto abono de la nota de debito es mayor a 0
                //if($dpv_nota_monto_abono > 0){
                /*                    $dpv_nota_monto_abono       = $dpv_nota_monto_abono + $dpv_nota_monto_nta_debito;
                    $dpv_nota_monto_pendiente   = $dpv_nota_monto_pendiente + $dpv_nota_monto_nta_debito;
                    $dpv_nota_monto_nta_debito = $dpv_nota_monto_nta_debito;*/
                    //$dpv_nota_monto_nta_saldo   = ($monto_saldo_nota_temporal) < 0 ? -1*$monto_saldo_nota_temporal: $monto_saldo_nota_temporal;    
                //}else{//En caso de que el monto abono sea 0
                    /*$dpv_nota_monto_abono       = $dpv_nota_monto_abono - $post_array['txtTotalGeneral'];
                    $dpv_nota_monto_pendiente   = $dpv_nota_monto_pendiente + $post_array['txtTotalGeneral'];
                    $dpv_nota_monto_nta_debito = $post_array['txtTotalGeneral'];*/
                    //$dpv_nota_monto_nta_saldo   = 0.00;
                //}
            /*
            print_r('dpv_nota_monto_abono: ' . $dpv_nota_monto_abono);
            echo "<br>";
            print_r('dpv_nota_monto_pendiente: ' . $dpv_nota_monto_pendiente);
            echo "<br>";
            print_r('dpv_nota_monto_nta_credito: ' . $dpv_nota_monto_nta_credito);
            echo "<br>";
            print_r('dpv_nota_monto_nta_saldo: ' . $dpv_nota_monto_nta_saldo);
            print_r(($post_array['slcDocAfecta'] != '') ? $post_array['slcDocAfecta'] : null);
            die();

                $nta_cre = $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_monto_abono' => $dpv_nota_monto_abono,'dpv_monto_pendiente' => $dpv_nota_monto_pendiente, 'dpv_monto_nta_credito' => $dpv_nota_monto_nta_debito), array('dpv_id' => $dpv_id));
            }*/
            $nta_de = $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_monto_nta_debito' => $dpv_nota_monto_nta_debito), array('dpv_id' => $dpv_id));
            //= convertirFloat($txtTotalGeneral);
            /*print_r('dpv_nota_monto_abono: ' . $dpv_nota_monto_abono);
            echo "<br>";
            print_r('dpv_nota_monto_pendiente: ' . $dpv_nota_monto_pendiente);
            echo "<br>";
            print_r('dpv_nota_monto_nta_credito: ' . $dpv_nota_monto_nta_credito);
            echo "<br>";
            print_r('dpv_nota_monto_nta_saldo: ' . $dpv_nota_monto_nta_saldo);*/
            //print_r(($post_array['slcDocAfecta'] != '') ? $post_array['slcDocAfecta'] : null;);
            //die();

            /**********FIN ACTUALIZAR EL DPV A PARTIR DE LA NOTA DE CREDITO**************/
            //$post_array = $this->input->post();
            $tipo_btn               = $post_array['btnCrear'];
            $idOrdenCompra          = (isset($post_array['slcOrdenCompra'])) ? $post_array['slcOrdenCompra'] : null;
            $slcProveedor           = $post_array['slcProveedor'];
            $slcTipoPago            = ($post_array['slcTipoPago'] != '') ? $post_array['slcTipoPago'] : null;
            $slcTipoDocumento       = ($post_array['slcTipoDocumento'] != '') ? $post_array['slcTipoDocumento'] : null;
            $txtSerieDoc            = ($post_array['txtSerieDoc'] != '') ? $post_array['txtSerieDoc'] : null;
            $txtNumDoc              = ($post_array['txtNumDoc'] != '') ? $post_array['txtNumDoc'] : null;
            $slcDocAfecta           = ($post_array['slcDocAfecta'] != '') ? $post_array['slcDocAfecta'] : null;
            $txtFechaDoc            = ($post_array['txtFechaDoc'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaDoc'])) : null;
            $txtFechaConta          = ($post_array['txtFechaConta'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaConta'])) : null;
            $txtFechaVencimiento    = ($post_array['txtFechaVencimiento'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVencimiento'])) : null;
            $txtConcepto            = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $txtDescripcion         = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            //$slcRetenciones       = ($post_array['slcRetenciones'] != '') ? $post_array['slcRetenciones'] : null;
            $hdnAfectaInv           = $post_array['hdnAfectaInv'];
            $slcCajaChica           = ($post_array['slcCajaChica'] != '') ? $post_array['slcCajaChica'] : null;
            $slcTipoMonto           = ($post_array['slcTipoMonto'] != '') ? $post_array['slcTipoMonto'] : null;
            $slcTipo                = $post_array['slcTipo'];
            $txtObservacion         = ($post_array['txtObservacion']) ? $post_array['txtObservacion'] : null;
            $txtDescuentoGeneral    = (isset($post_array['txtDescuentoGeneral'])) ? $post_array['txtDescuentoGeneral'] : 0;
            $txtRetencionGeneral    = ($post_array['txtRetencionGeneral'] != '') ? $post_array['txtRetencionGeneral'] : 0;
            $txtImpuestosGeneral    = $post_array['txtImpuestosGeneral'];
            $txtSubtotalGeneral     = $post_array['txtSubtotalGeneral'];
            $txtTotalGeneral        = $post_array['txtTotalGeneral'];
            $slc_presupuesto        = ($post_array['slc_presupuesto'] != '') ? $post_array['slc_presupuesto'] : null;
            $slc_actividad_general  = ($post_array['slc_actividad_general'] != '') ? $post_array['slc_actividad_general'] : null;
            $slc_act_especifica     = ($post_array['slc_actividad_espeficifica'] != '') ? $post_array['slc_actividad_espeficifica'] : null;
            $nombre_act_especifica  = ($post_array['txt_nombre_actividad'] != '') ? $post_array['txt_nombre_actividad'] : null;
            $abreviacion            = ($post_array['txt_abreviacion'] != '') ? $post_array['txt_abreviacion'] : null;
            $nombre_proveedor       = ($post_array['txt_nombre_proveedor'] != '') ? $post_array['txt_nombre_proveedor'] : null;

            $txtNRC         = ($post_array['txtNrc']) ? $post_array['txtNrc'] : null;
            //aca convierte a la unidad de defecto
            $conversionDefe = $post_array['conversionDefe'];
            $conversionConv = $post_array['conversionConv'];

            //Anexos
            $TitulosAnexo   = (isset($post_array['titulo_doc'])) ? $post_array['titulo_doc'] : null;
            $NombreAnexo    = (isset($post_array['ruta'])) ? $post_array['ruta'] : null;
            $AnexoDpv       = (isset($post_array['AnexoDpv'])) ? $post_array['AnexoDpv'] : null;
            $slcProyecto    = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $edit=null;

            $id_orc = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_orc', array('dpv_id'=>$dpv_id));
            //Si se edita el documento con caja asignada.
            /* $existe_caja= $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_id_cch', array('dpv_id'=>$dpv_id));
            if($existe_caja>0){ $edit=1; }else{ $edit=null; }*/

            $documento_array = array(
                'dpv_id_prv' => $slcProveedor,
                'dpv_id_tpg' => $slcTipoPago,
                'dpv_id_tif' => $slcTipoDocumento,
                'dpv_id_cch' => $slcCajaChica,
                'dpv_id_dpv_afecta'     => $dpv_id,
                'dpv_id_pcl'            => $slcProyecto,
                'dpv_id_tmt'            => $slcTipoMonto,
                'dpv_serie_documento'   => $txtSerieDoc,
                'dpv_numero_documento'  => $txtNumDoc,
                'dpv_fecha_documento'   => $txtFechaDoc,
                'dpv_fecha_contabilizacion' => $txtFechaConta,
                'dpv_fecha_vencimiento'     => $txtFechaVencimiento,
                'dpv_concepto'              => $txtConcepto,
                'dpv_descripcion'           => $txtDescripcion,
                'dpv_afecta_inventario'     => $hdnAfectaInv,
                'dpv_tipo'                  => $slcTipo,
                'dpv_monto_pendiente'       => 0.00,//Este es el monto pendiente
                'dpv_monto_abono'           => convertirFloat($txtTotalGeneral),//Aqui va el monto total
                'dpv_impuesto'              => convertirFloat($txtImpuestosGeneral),
                'dpv_descuento'             => convertirFloat($txtDescuentoGeneral),
                'dpv_retencion'             => convertirFloat($txtRetencionGeneral),
                'dpv_subtotal'              => convertirFloat($txtSubtotalGeneral),
                'dpv_total'                 => convertirFloat($txtTotalGeneral),
                'dpv_observacion'           => $txtObservacion,
                'dpv_pagado'                => 0,
                'dpv_estado'                => 1,
                'dpv_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'dpv_usu_creacion'          => $this->tank_auth->get_user_id(),
                'dpv_fecha_modificacion'    => date('Y-m-d H:i:s'),
                'dpv_fecha_creacion'        => date('Y-m-d H:i:s'),
                'dpv_id_psp'                => $slc_presupuesto,
                'dpv_id_ace'                => $slc_act_especifica,
                'dpv_id_acg'                => $slc_actividad_general
            );            

            //print_r($documento_array); die();
            //$resultado = $this->gsatelite->actualizar_array('dpv_documento_proveedor', $documento_array, array('dpv_id' => $dpv_id));
           $dpv_id = $this->gsatelite->ingresar('dpv_documento_proveedor', $documento_array);
            //print_r($resultado); die();
            //se borrar gastos si existen
            //$this->gsatelite->borrado_general('dgp_detalle_gasto_prespuesto', array('dgp_id_dpv' => $dpv_id));
            //se verificara si se agregaran gastos a presupuestos.
           if ( $slcProyecto != "" && $slc_act_especifica != "" ) {
            $condiciones = array(
                "dps_id_ace"    => $slc_act_especifica,
                "dps_id_acg"    => $slc_actividad_general,
                "dps_id_psp"    => $slc_presupuesto,
            );
            $detalle_presupuesto = $this->gsatelite->get_campo("dps_detalle_presupuesto","dps_id",$condiciones);
            if ( $detalle_presupuesto != null ) {
                $dgp_detalle_gasto_prespuesto = array(
                    'dgp_id_dps'            => $detalle_presupuesto,
                    'dgp_id_tgp'            => 5,
                    'dgp_id_dpv'            => $dpv_id,
                    'dgp_fecha'             => $txtFechaDoc,
                    'dgp_descripcion'       => $nombre_proveedor,
                    'dgp_referencia'        => $abreviacion." - ".$txtNumDoc,
                    'dgp_cantidad'          => 1,
                    'dgp_monto'             => convertirFloat($txtTotalGeneral),
                    'dgp_total_retencion'   => convertirFloat($txtRetencionGeneral),
                    'dgp_total_impuesto'    => convertirFloat($txtImpuestosGeneral),
                    'dgp_sub_monto'         => convertirFloat($txtSubtotalGeneral),
                    'dgp_origen'            => null,
                    'dgp_referencia_origen' => null,
                    'dgp_estado'            => 1,
                    'dgp_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'dgp_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'dgp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'dgp_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $dgp_id = $this->gsatelite->ingresar('dgp_detalle_gasto_prespuesto', $dgp_detalle_gasto_prespuesto);
            }
        }

        if ($dpv_id > 0) {
                //Se obtienen los detalles de la grid para actualizar
            $row       = $post_array['row_actual'];
            $productosIds       = $post_array['hdnDetalle'];
            $cantidad_real      = $post_array['cantidades_real'];
            $hdnDetalleProd     = $post_array['hdnDetalleProd'];
            $txtCantidadesDpv   = $post_array['txtCantidadesDpv'];
            $txtPreciosDpv      = $post_array['txtPreciosDpv'];
            $BodegasDpv         = $post_array['hdnBodegasDpv'];
            $SectoresDpv        = $post_array['hdnSectoresDpv'];
            $impuestosDetalle   = $post_array['hdnImpuestosDpv'];
            $impuestosDpv       = $post_array['impuestosDpv'];
            $tiposVentaDpv      = $post_array['tiposVentaDpv'];
            $retencionesDetalle = $post_array['hdnRetencionesDpv'];
            $retencionesDpv     = $post_array['retencionesDpv'];
            $DescuentosDpv      = $post_array['hdnDescuentosDpv'];
            $subtotalesDpv      = $post_array['subtotalesDpv'];
            $totalesDpv         = $post_array['totalesDpv'];
            $descripcionProd    = $post_array['descripcionProd'];

                //Se eliminan los registros necesarios.
                //Se verifica si se eliminaron productos.
                /*$where = array(
                    'dxd_id_dpv' => $dpv_id
                );
                $dataDetalle = $this->compras_model->get_detalle_doc_proveedor($where);
                if (!is_array($productosIds)) {
                    $productosIds = array();
                }

                foreach ($dataDetalle as $data) {
                    if (!in_array($data['dxd_id'], $productosIds)) {
                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('idd_impuestoxdetalle_documento', array('idd_id_dxd' => $data['dxd_id']));
                        //Se eliminan las retenciones del detalle
                        $this->gsatelite->borrado_general('rxd_retencionxdetalle_documento', array('rxd_id_dxd' => $data['dxd_id']));
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('dxd_detalle_documento_proveedor', array('dxd_id' => $data['dxd_id']));
                        //
                    }
                }*/

                //Se actualizan los detalles
                if (count($productosIds) > 0) {
                    for ($i = 0; $i < count($productosIds); $i++) {
                        //Eliminar los detalles prorratedo
                        /*$this->db->join('pxd_prorrateoxdetalle_documento', 'dxd_id = pxd_id_dxd');
                        $last_dtpro = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $productosIds[$i]));*/
                            // print_r($last_dtpro);
                /*                        foreach ($hdnDetalleProd as $index => $valueDP) {
                            $idsCnt = $post_array['cuentacontable_'.$valueDP];//id de la cuenta contable
                            if ($this->input->post('cuentacontable_'.$valueDP)) {
                                foreach ($idsCnt as $indexCnt => $idCnt) {
                                    // print_r($idsCnt);
                                    foreach ($last_dtpro as $key => $dtpro) {
                                        if (!in_array($dtpro['dxd_id'], $productosIds)) {
                                            $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dxd' => $dtpro['dxd_id'],'pxd_id_cnt' => $idCnt));
                                        }
                                    }
                                }
                            }else{
                                foreach ($last_dtpro as $key => $last_iddxd) {
                                    $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id_dxd' => $last_iddxd['dxd_id']));
                                }
                            }
                        }*/

                /*                        $this->db->join('pxd_prorrateoxdetalle_documento', 'dxd_id = pxd_id_dxd');
                        $prorrateo_array = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $productosIds[$i]));
                        $prorrateo_id_array = array_column($prorrateo_array, 'pxd_id');
                        $prorrateo_exist = $this->input->post('prorrateo_exist_'.$row[$i].'_'.$hdnDetalleProd[$i]);
                        foreach ($prorrateo_id_array as $key_pro => $prorrateo_ids) {
                            if(!in_array($prorrateo_ids, $prorrateo_exist)){
                                $this->gsatelite->borrado_general('pxd_prorrateoxdetalle_documento', array('pxd_id' => $prorrateo_ids));
                            }
                        }*/
                        //Fin eliminar detalle prorrateo

                        $detalle_array = array(
                            'dxd_id_dpv'            => $dpv_id,
                            'dxd_id_bod'            => ($BodegasDpv[$i] > 0) ? $BodegasDpv[$i] : null,
                            'dxd_id_sxb'            => ($SectoresDpv[$i] > 0) ? $SectoresDpv[$i] : null,
                            'dxd_id_tpv'            => ($tiposVentaDpv[$i] != '') ? $tiposVentaDpv[$i] : null,
                            'dxd_cantidad'          => convertirFloat($txtCantidadesDpv[$i]),
                            'dxd_precio_unitario'   => convertirFloat($txtPreciosDpv[$i]),
                            'dxd_impuesto'          => convertirFloat($impuestosDpv[$i]),
                            'dxd_descuento'         => ($DescuentosDpv[$i] != '') ? convertirFloat($DescuentosDpv[$i]) : 0,
                            'dxd_retencion'         => convertirFloat($retencionesDpv[$i]),
                            'dxd_subtotal'          => convertirFloat($subtotalesDpv[$i]),
                            'dxd_descripcion'       => $descripcionProd[$i],
                            'dxd_total'             => convertirFloat($totalesDpv[$i]),
                            'dxd_estado'            => 1,
                            'dxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion'=> date('Y-m-d H:i:s'),
                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_creacion' => date('Y-m-d H:i:s')
                        );
                        
                        ///$resultado = $this->gsatelite->actualizar_array('dxd_detalle_documento_proveedor', $detalle_array, array('dxd_id' => $productosIds[$i]));
                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);
                        if($dxd_id > 0){
                             ////// ACTUALIZAR CANTIDAD EN LOS DETALLES DE LA ORDEN DE COMPRA (SI APLICA) ///////
                            if($id_orc>0){
                                $det_dor = $this->gsatelite->get_tabla('dor_detalle_orden_compra', array('dor_id_orc'=>$id_orc,'dor_id_art'=>$hdnDetalleProd[$i]));
                                if(count($det_dor)>0){
                                    $pendiente = convertirFloat($cantidad_real[$i]) - convertirFloat($txtCantidadesDpv[$i]);

                                    $this->gsatelite->actualizar_array('dor_detalle_orden_compra', array('dor_cantidad_pendiente'=>$pendiente), array('dor_id'=>$det_dor[0]['dor_id']));
                                }
                            }
                        }

                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('idd_impuestoxdetalle_documento', array('idd_id_dxd' => $dxd_id));
                        //Se ingresan nuevamente
                        if (count($impuestosDetalle) > 0) {
                            //Se crea el array de los impuestos
                            $impuestos_array = explode(',', $impuestosDetalle[$i]);

                            if (count($impuestos_array) > 0) {
                                //Se recore el array para la insercion de impuestos
                                for ($j = 0; $j < count($impuestos_array); $j++) {
                                    $por_imp = $this->gsatelite->get_campo('imp_impuesto','imp_porcentaje', array('imp_id'=>$impuestos_array[$j]));
                                    if($por_imp>0){
                                        $mon_im = ($por_imp/100)*$subtotalesDpv[$j];
                                    }else{

                                        $imp_val    = $this->gsatelite->get_campo('imp_impuesto','imp_valor', array('imp_id'=>$impuestos_array[$j]));                                          
                                        $mon_im     = $cantidades[$i] * $imp_val;
                                        $por_imp    = $imp_val;
                                    }
                                    if ($impuestos_array[$j] != '') {
                                        $ixo_array = array(
                                            'idd_id_imp' => $impuestos_array[$j],
                                            'idd_id_dxd' => $dxd_id,
                                            'idd_porcentaje' => $por_imp,
                                            'idd_monto' => $mon_im,
                                            'idd_estado' => 1,
                                            'idd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'idd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'idd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'idd_fecha_creacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                    }
                                }
                            }
                        }

                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('rxd_retencionxdetalle_documento', array('rxd_id_dxd' => $dxd_id));
                        //Se valida existan retenciones
                        if (count($retencionesDetalle) > 0) {
                            //Se crea el array de los retenciones
                            $retenciones_array = explode(',', $retencionesDetalle[$i]);

                            if (count($retenciones_array) > 0) {
                                //Se recore el array para la insercion de impuestos
                                for ($j = 0; $j < count($retenciones_array); $j++) {

                                    if ($retenciones_array[$j] != '') {
                                        $rxd_array = array(
                                            'rxd_id_ret' => $retenciones_array[$j],
                                            'rxd_id_dxd' => $dxd_id,
                                            'rxd_estado' => 1,
                                            'rxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'rxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'rxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'rxd_fecha_creacion' => date('Y-m-d H:i:s')
                                        );

                                        $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                    }
                                }
                            }
                        }

                        //Se procesan los detalles del prorrateo ya ingresados.
                /*        if (count($post_array['hdnCec_' . $hdnDetalleProd[$i]]) > 0) {
                            $hdnIdsPxd = $post_array['hdnCec_' . $hdnDetalleProd[$i]];
                            $porcentajes = $post_array['porcentajesPxd_' . $hdnDetalleProd[$i]];
                            $totales = $post_array['totalPxd_' . $hdnDetalleProd[$i]];
                            for ($j = 0; $j < count($post_array['hdnCec_' . $hdnDetalleProd[$i]]); $j++) {
                                if ($porcentajes[$j] != '') {
                                    $detalle_pro_array = array(
                                        'pxd_porcentaje'        => $porcentajes[$j],
                                        'pxd_total'             => convertirFloat($totales[$j]),
                                        'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->actualizar_array('pxd_prorrateoxdetalle_documento', $detalle_pro_array, array('pxd_id' => $hdnIdsPxd[$j]));
                                }
                            }
                        }

                        //Se procesan los nuevos
                        //Se procesan los detalles del prorrateo
                        if (isset($post_array['centroCostos_' . $hdnDetalleProd[$i]]) && count($post_array['centroCostos_' . $hdnDetalleProd[$i]]) > 0) {

                            $centros_costo = $post_array['centroCostos_' . $hdnDetalleProd[$i]];
                            $porcentajes = $post_array['porcentajesCec_' . $hdnDetalleProd[$i]];
                            $totales = $post_array['totalCec_' . $hdnDetalleProd[$i]];
                            $cuentacontable = $post_array['cuentacontablenew_' . $hdnDetalleProd[$i]];
                            $pxd_id_cec         = $post_array['codigo_centro_costo_' . $hdnDetalleProd[$i]];

                            for ($j = 0; $j < count($post_array['centroCostos_' . $hdnDetalleProd[$i]]); $j++) {
                                // if ($centros_costo[$j] != '') {
                                    $detalle_pro_array = array(
                                        'pxd_id_dpr'            => ($centros_costo[$j] != "")?$centros_costo[$j]:NULL,
                                        'pxd_id_dxd'            => $productosIds[$i],
                                        'pxd_id_cnt'            => ($cuentacontable[$j] != "")?$cuentacontable[$j]:NULL,
                                        'pxd_id_cec'            => ($pxd_id_cec[$j] != "")?$pxd_id_cec[$j]:NULL,
                                        'pxd_porcentaje'        => $porcentajes[$j],
                                        'pxd_total'             => convertirFloat($totales[$j]),
                                        'pxd_estado'            => 1,
                                        'pxd_usu_creacion'      => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_creacion'    => date('Y-m-d H:i:s'),
                                        'pxd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                        'pxd_fecha_modificacion'=> date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                // }
                            }
                        }*/
                    }
                }

                //Se obtienen los detalles de la grid
                /*$productos = (isset($post_array['productos'])) ? $post_array['productos'] : null;
                $conversiones = (isset($post_array['productos'])) ? $post_array['conversion'] : null;
                $cantidades = (isset($post_array['productos'])) ? $post_array['cantidades'] : null;
                $precios = (isset($post_array['productos'])) ? $post_array['precios'] : null;
                $retenciones = (isset($post_array['productos'])) ? $post_array['retenciones'] : null;
                $impuestos = (isset($post_array['productos'])) ? $post_array['impuestos'] : null;
                $bodegas = (isset($post_array['productos'])) ? $post_array['bodegas'] : null;
                $sectores = (isset($post_array['productos'])) ? $post_array['sectores'] : null;
                $impuestosProducto = (isset($post_array['productos'])) ? $post_array['impuestosProducto'] : null;
                $retencionesProducto = (isset($post_array['productos'])) ? $post_array['retencionesProducto'] : null;
                $tiposVenta = (isset($post_array['productos'])) ? $post_array['tiposVenta'] : null;
                $descuentos = (isset($post_array['productos'])) ? $post_array['descuentos'] : null;
                //$gastos = $post_array['gastos'];
                $subtotalesProducto = (isset($post_array['productos'])) ? $post_array['subtotalesProducto'] : null;
                $totalesProducto = (isset($post_array['productos'])) ? $post_array['totalesProducto'] : null;
                $newdescripcionProd = (isset($post_array['newdescripcionProd'])) ? $post_array['newdescripcionProd'] : null;*/

                /*if (count($productos) > 0) {
                    //Se ingresan los detalles de la orden
                    for ($i = 0; $i < count($productos); $i++) {

                        $producto_id = null;
                        $conversion_prodc = null;
                        $activo_id = null;

                        //Se validan los registros en base al tipo de orden
                        //1 = Producto, 2 = Servicio, 3 = Activo Fijo
                        // if ($slcTipo == 1) {
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // } else if ($slcTipo == 2) {
                        //     $producto_id = $productos[$i];
                        // } else if($slcTipo == 4){
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // } else {
                        //     // $activo_id = $productos[$i];
                        //     $producto_id = $productos[$i];
                        //     $conversion_prodc = $conversiones[$i];
                        // }

                        $producto_id = $productos[$i];
                        $conversion_prodc = (trim($conversiones[$i])?$conversiones[$i]:null);

                        $detalle_array = array(
                            'dxd_id_bod' => ($bodegas[$i] > 0) ? $bodegas[$i] : null,
                            'dxd_id_sxb' => ($sectores[$i] > 0) ? $sectores[$i] : null,
                            'dxd_id_dpv' => $resultado,
                            'dxd_id_dpv' => $dpv_id,
                            'dxd_id_act' => $activo_id,
                            'dxd_id_cva' => $conversion_prodc,
                            'dxd_id_art' => $producto_id,
                            'dxd_id_tpv' => ($tiposVenta[$i] != '') ? $tiposVenta[$i] : null,
                            'dxd_cantidad' => convertirFloat($cantidades[$i]),
                            'dxd_precio_unitario' => convertirFloat($precios[$i]),
                            'dxd_impuesto' => convertirFloat($impuestosProducto[$i]),
                            'dxd_descuento' => ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0,
                            'dxd_retencion' => convertirFloat($retencionesProducto[$i]),
                            'dxd_subtotal' => convertirFloat($subtotalesProducto[$i]),
                            'dxd_total' => convertirFloat($totalesProducto[$i]),
                            'dxd_descripcion' => $newdescripcionProd[$i],
                            'dxd_estado' => 1,
                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dxd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxd_fecha_creacion' => date('Y-m-d H:i:s'),
                        );

                        $dxd_id = $this->gsatelite->ingresar('dxd_detalle_documento_proveedor', $detalle_array);

                        //Si se ingresa el detalle, se ingresan los impuestos y retenciones
                        if ($dxd_id > 0) {
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {

                                        if ($impuestos_array[$j] != '') {
                                            $ixo_array = array(
                                                'idd_id_imp' => $impuestos_array[$j],
                                                'idd_id_dxd' => $dxd_id,
                                                'idd_estado' => 1,
                                                'idd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'idd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'idd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'idd_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('idd_impuestoxdetalle_documento', $ixo_array);
                                        }
                                    }
                                }
                            }

                            //Se valida existan retenciones
                            if (count($retenciones) > 0) {
                                //Se crea el array de los retenciones
                                $retenciones_array = explode(',', $retenciones[$i]);

                                if (count($retenciones_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($retenciones_array); $j++) {

                                        if ($retenciones_array[$j] != '') {
                                            $rxd_array = array(
                                                'rxd_id_ret' => $retenciones_array[$j],
                                                'rxd_id_dxd' => $dxd_id,
                                                'rxd_estado' => 1,
                                                'rxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'rxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'rxd_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('rxd_retencionxdetalle_documento', $rxd_array);
                                        }
                                    }
                                }
                            }

                            //Se procesan los detalles del prorrateo
                            /*if (count($post_array['centroCostos_' . $productos[$i]]) > 0) {

                                $centros_costo = $post_array['centroCostos_' . $productos[$i]];
                                $porcentajes = $post_array['porcentajesCec_' . $productos[$i]];
                                $totales = $post_array['totalCec_' . $productos[$i]];
                                $cuentacontable = $post_array['cuentacontablenew_' . $productos[$i]];

                                for ($j = 0; $j < count($post_array['centroCostos_' . $productos[$i]]); $j++) {
                                    // if ($centros_costo[$j] != '') {
                                        $detalle_pro_array = array(
                                            'pxd_id_dpr' => $centros_costo[$j],
                                            'pxd_id_dxd' => $dxd_id,
                                            'pxd_id_cnt' => $cuentacontable[$j],
                                            'pxd_porcentaje' => $porcentajes[$j],
                                            'pxd_total' => $totales[$j],
                                            'pxd_estado' => 1,
                                            'pxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'pxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'pxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'pxd_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('pxd_prorrateoxdetalle_documento', $detalle_pro_array);
                                    // }
                                }
                            }*/
                        /*}
                        }
                    }*/

                //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                    $dataAnexos = $this->gsatelite->get_tabla('adp_anexo_documento', array('adp_id_dpv' => $dpv_id));
                    if (!is_array($AnexoDpv)) {
                        $AnexoDpv = array();
                    }
                    foreach ($dataAnexos as $data) {
                        if (!in_array($data['adp_id'], $AnexoDpv)) {
                            $this->gsatelite->borrado_general('adp_anexo_documento', array('adp_id' => $data['adp_id']));
                            $ruta_nxp = $data['adp_url'];
                            unlink($ruta_nxp);
                        }
                    }

                //Anexos
                    if (count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {
                            $extension = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);

                            $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                            $carpeta_destino_anx = "uploads/anx_doc_proveedor/" . $nombreArchivo;

                            $documentos_array = array(
                                'adp_id_dpv' => $dpv_id,
                                'adp_url' => $carpeta_destino_anx,
                                'adp_nombre' => $nombreArchivo,
                                'adp_estado' => 1,
                                'adp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'adp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'adp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'adp_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );

                            $nxp_id = $this->gsatelite->ingresar('adp_anexo_documento', $documentos_array);

                            if ($nxp_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }

                    if ($hdnAfectaInv == 1 && ($slcTipo == 1 || $slcTipo == 4)) {
                        $tipoProcesos = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS');
                        $tipoProcesos_array = json_decode($tipoProcesos, true);

                        $this->db->order_by('dxd_id_bod');
                        $this->db->group_by('dxd_id_bod');
                        $detalle_query = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod !=' => ''));

                        $movimientos_array = array();

                    //Se crean todos los movimientos
                        foreach ($detalle_query as $dxd) {
                            $movimientos_array[]['movimientos'] = array(
                                'moi_id_prv' => $slcProveedor,
                                'moi_id_tip' => $tipoProcesos_array['DOC_PROV'],
                                'moi_id_bod' => $dxd['dxd_id_bod'],
                                'moi_id_dpv' => $dpv_id,
                                'moi_documento' => $txtNumDoc,
                                'moi_descripcion' => $txtConcepto,
                                'moi_fecha_mov' => date('Y-m-d H:i:s'),
                                'moi_estado' => 1,
                                'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                                'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                                'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                        }

                    //Se crean los detalles del movimiento
                        for ($i = 0; $i < count($movimientos_array); $i++) {

                            $bod_id = $movimientos_array[$i]['movimientos']['moi_id_bod'];

                            $detalles_doc = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id, 'dxd_id_bod' => $bod_id));
                            if (count($detalles_doc) > 0) {
                                $desc_prod = ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0;
                                foreach ($detalles_doc as $key => $det) {
                                    if($det['art_tipo'] == 0 && $det['dxd_id_art'] > 0){
                                        $precio_uni = convertirFloat($det['dxd_precio_unitario']);
                                        $descuento_art = ($precio_uni)-(($precio_uni)*($desc_prod/100));

                                        $nueva_cantidad_actu = convertirFloat( ($det['dxd_cantidad']*($conversionConv[$i]/$conversionDefe[$i]) ) );
                                        $nueva_precio_actu = convertirFloat(($descuento_art*($conversionDefe[$i]/$conversionConv[$i]) ) );

                                        if ($costo_promedio == 1) {
                                            $nuevo_precio =  $this->recalcular_precio_promedio($det['dxd_id_art'], $bod_id, $nueva_cantidad_actu, $nueva_precio_actu);
                                        }                                         

                                        $movimientos_array[$i]['detalles'][$key]['sar_saldo'] = array(
                                            'sar_id_art' => $det['dxd_id_art'],
                                            'sar_id_bod' => $bod_id,
                                            'sar_cant_actual' => $nueva_cantidad_actu,
                                            'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $nueva_precio_actu,
                                            'sar_fecha_caducidad' => null,
                                            'sar_id_sxb' => $det['dxd_id_sxb'],
                                            'sar_estado' => 1,
                                            'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );

                                        $movimientos_array[$i]['detalles'][$key]['dee_movimiento'] = array(
                                            'dee_id_moi' => null,
                                            'dee_id_art' => $det['dxd_id_art'],
                                            'dee_id_sar' => null,
                                            'dee_id_cva' => $det['dxd_id_cva'],
                                            'dee_id_sxb' => $det['dxd_id_sxb'],
                                            'dee_cantidad' => $nueva_cantidad_actu,
                                            'dee_precio' => $nueva_precio_actu,
                                            'dee_subtotal' => convertirFloat($det['dxd_subtotal']),
                                            'dee_estado' => 1,
                                            'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );

                                        $movimientos_array[$i]['detalles'][$key]['dxd_detalle_doc'] = array(
                                            'dxd_id' => $det['dxd_id'],
                                            'dxd_procesado_inventario' => 1,
                                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        );
                                    }

                                }
                            }
                        }

                        $this->ingresar_entrada($movimientos_array);
                    }
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Documento por Proveedor", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

            ///////////////////////////// Si se paga por caja chica ////////////////////////////////////////////////////

                if($slcCajaChica>0){
                    $id_lcc = $post_array['id_lcc'];
                    $this->registro_caja_chica($dpv_id, $documento_array, $id_lcc, $edit, $txtNRC);

                }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
                if ($dpv_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Nota de Débito", 'texto_alerta' => "El registro se almaceno correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nota de Débito", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }


                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('modulo_compras/procesos/editar_doc_proveedor/' . $dpv_id);
                } else {
                    $idOrdenCompra = ($redireccion > 0) ? '' : $idOrdenCompra;
                    redirect('modulo_compras/procesos/documentos_proveedor/' . $idOrdenCompra);
                }
        }//die('aaa');
        // *********************************************************************************************** \\
        $permiso_compra = false;
        $permisos_array = $this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA');
        $permisos_array = ( $permisos_array != "" )? explode(",", $permisos_array) :null;
        if ( count($permisos_array) > 0 ) {
            $roles          = $this->gsatelite->get_tabla("uxr_usuarioxrol", array( "uxr_id_usu" => $this->tank_auth->get_user_id()) );
            foreach ($roles as $role) {
                if ( in_array($role["uxr_id_rol"], $permisos_array) ) {
                    $permiso_compra = true;
                }
            }
        }
        $sobre_giro             = $this->gsatelite->get_parametro('SYS_SOBREGIRO_GASTO_PRESUPUESTO ');
        $data["sobre_giro"]     = ($sobre_giro != "" )?$sobre_giro:0;
        $data["permiso_compra"] = $permiso_compra;   
        $doc_proveedor          = $this->compras_model->get_documentos_proveedor(array('dpv_id' => $dpv_id));
        $data['orden']          = $doc_proveedor[0]['dpv_id_orc'];
        //$data['doc_proveedor']  = (count($doc_proveedor) > 0) ? $doc_proveedor : ''; //print_r($doc_proveedor);die();
        $data['tipo_pago']      = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', 'pagos', array('tpg_estado' => 1), $doc_proveedor[0]['dpv_id_tpg'], null, null, true);

        $data['retenciones']    = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $data['tipo_venta']     = $this->gsatelite->get_dropdown('tpv_tipo_venta', '{tpv_nombre}', 'tipo_venta', array('tpv_estado'=>1,'tpv_aplica_compra'=>1), null, null, null, true);
        $data['bodegas']        = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', 'bodegas', array('bod_estado' => 1), null, null, null, true);
        $data['documentosAfecta'] = $this->gsatelite->get_dropdown('dpv_documento_proveedor', 'dpv_numero_documento', 'documentoAfecta', array('dpv_id_prv' => $doc_proveedor[0]['dpv_id_prv'], 'dpv_id !=' => $dpv_id), $doc_proveedor[0]['dpv_id_dpv_afecta'], null, null, true);
        $data['doc_proveedor']  = $doc_proveedor[0];

        $data['detalle_documento'] = $this->compras_model->get_detalle_doc_proveedor(array('dxd_id_dpv' => $dpv_id)); 

        $data['anexos_doc']     = $this->gsatelite->get_tabla('adp_anexo_documento', array('adp_id_dpv' => $dpv_id));
        $data['prorrateos']     = $this->gsatelite->get_dropdown('ptg_prorrateo_gasto', '{ptg_nombre}', 'prorrateos', array('ptg_estado' => 1), null, null, null, true);
        $data['centro_costos']  = $this->gsatelite->get_tabla("cec_centro_costo",array('cec_estado' => 1));
        $orc_id                 = $doc_proveedor[0]['dpv_id_orc'];
        $tipo_factura            = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        if ($tipo_factura['NOTA DEBITO'] != '' && $tipo_factura['NOTA DEBITO'] > 0) {
            $where1 = array('tif_estado' => 1, 'tif_aplica_compra' => 1, 'tif_id' => $tipo_factura['NOTA DEBITO']);
            $selctd = $tipo_factura['NOTA DEBITO'];
        } else {
            $where1 = array('tif_estado' => 1, 'tif_aplica_compra' => 1);
            $selctd = "";
        }
        if ($orc_id > 0) {
            $data['orden_compra'] = $orc_id;
            $data['ordenes_data'] = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' => $orc_id));
            $data['ordenes'] = $this->gsatelite->get_dropdown('orc_orden_compra', 'orc_numero', '', array('orc_id' => $orc_id), $orc_id, null, null, true);

            //Verificar si existe dpv para validar el tipo de documento
            $this->db->where('dpv_id !=', $dpv_id);
            $this->db->group_by('dpv_id_tif');
            $documento = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_orc' => $orc_id));

            $ids_tif = array();
            foreach ($documento as $doc) {
                $ids_tif[] = $doc['dpv_id_tif'];
            }

            if (count($documento) > 0) {
                $this->db->where('tif_estado', 1);
                $this->db->where('tif_aplica_nota_debito', 1);//Validar que sea nota de credito
                $this->db->where_not_in('tif_id', $ids_tif);
                $this->db->or_where('tif_id', $doc_proveedor[0]['dpv_id_tif']);
                $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', null, $doc_proveedor[0]['dpv_id_tif'], null, null, true);
            } else {
                $this->db->where('tif_aplica_nota_credito', 1);//Validar que sea nota de credito
                $data['tipo_documento'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', array('tif_estado' => 1), null, null, null, true);
            }
        } else {
            $data['orden_compra'] = null;
            $data['ordenes'] = "";
        }
        $tipo_documento = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', 'documentos', $where1, $selctd, null, 'tif_id', true);
        /*$select_documento       = '<option value = ""></option>';
        foreach ($tipo_documento as $key => $tipo) {
            $selected = ($tipo_factura['NOTA DEBITO'] == $tipo["tif_id"] )?"selected":"";
            $select_documento   .= '<option value = "'.$tipo["tif_id"].'" data-abreviatura="'.$tipo["tif_abreviacion"].'" '.$selected.'>'.$tipo["tif_nombre"].'</option>';
        }*/
        $data['tipo_documento'] = $tipo_documento;
        $proveedores            = $this->compras_model->get_proveedor_pers();
        $options                = '<option value=""></option>';
        foreach ($proveedores as $key) {
            if ($key['pro'] != '') {
                if ($doc_proveedor[0]['dpv_id_prv'] == $key['prv_id']) {
                    $options .= '<option data-nombre = "' . $key['nombre'] . '" data-dias = "' . $key['prv_dias_plazo'] . '" value="' . $key['prv_id'] . '" selected>' . $key['pro'] . '</option>';
                } else {
                    $options .= '<option data-nombre = "' . $key['nombre'] . '" data-dias = "' . $key['prv_dias_plazo'] . '" value="' . $key['prv_id'] . '" >' . $key['pro'] . '</option>';
                }
            }
        }

        $data['proveedores'] = $options;

        ///////////////////// Sólo cajas chicas que poseen monto disponible /////////////////////////////
        if($ver_detalle==''){
         $this->db->where(array('lcc_corte'=>0));
     }
     $this->db->join('lcc_liquidacion_caja_chica', 'lcc_id_cch=cch_id AND lcc_disponible IS NOT NULL');
     $cajas = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_estado'=>1));

     $opt_cajas = '<option value=""></option>';
     foreach ($cajas as $cj) {
        if( $doc_proveedor[0]['dpv_id_cch']==$cj['cch_id']){ $select="selected"; }else{ $select=''; }
        $opt_cajas .='<option value="'.$cj['cch_id'].'"  data-lcc="'.$cj['lcc_id'].'" '.$select.'>'.$cj['cch_nombre'].' ('.$cj['lcc_disponible'].')</option>';
    }
    $data['cajas_chicas'] = $opt_cajas;
        /////////////////////////////////////////////////////////////////////////////////////////////////


    $dis = $this->gsatelite->get_tabla('agp_agenda_pago', array('agp_estado'=>1, 'agp_id_dpv'=>$dpv_id));
    if(count($dis)>0){ $data['disabled']=1; }else{ $data['disabled']=0; }
        ////////////////////////////////////////////////////////////////////////////////////////////////

    $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
    $select_proyecto = '<option value=""></option>';
    foreach ($proyectos_reg as $key) {
        $selected = ($doc_proveedor[0]['dpv_id_pcl'] == $key['pcl_id'])?'selected':'';

        $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
        $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
        $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
    }
    $data['proyectos'] = $select_proyecto;

    $select = "";
    $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1,  'IFNULL(imp_proceso_aplica,0) <>' => 1));
    foreach ($impuesto_campos as $key) {
        if ($key["imp_porcentaje"] > 0) {
            $select .= "<option data-type='1' data-porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
        } else {
            $select .= "<option data-type='0' data-porcentaje='" . $key["imp_valor"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
        }
    }

    $data["impuestos"] = $select;
    $select = "";
    $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
    foreach ($retencion_campos as $key) {
        if ($key["ret_defecto"] == 1) {
            $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
        } else {
            $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
        }
    }
    $data["retencion"] = $select;

        ////////////////////////////////////////////////////////////////////////////////////////////////
    $par_nrc=$this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');
    $mask = $this->gsatelite->get_registro('tde_tipo_documento', array('tde_id'=>$par_nrc));
    $data['mask'] = $mask->tde_mascara;

    $data['ver_detalle'] = ($ver_detalle == null || $ver_detalle == 0)?null:$ver_detalle;
    $data['titulo_personal'] = "Documentos por Proveedor";
    $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
    $dias_pasados   = "";
    $dias_futuros   = "";
    $fechas_pasadas = "";
    $fechas_futuras = "";
    $json_meses     = $this->gsatelite->get_parametro('SYS_DOC_PROV_FECHA_CONTABLE');

    if ( $json_meses != "" ) {
        $configuracion_meses = json_decode($json_meses,true);
        if ( $configuracion_meses["DIAS_PASADOS"] != "" && is_numeric($configuracion_meses["DIAS_PASADOS"]) ) {
            $dias_pasados = $configuracion_meses["DIAS_PASADOS"];
            $fechas_pasadas = strtotime ( '-'.$dias_pasados.' day' , strtotime ( $doc_proveedor[0]['dpv_fecha_contabilizacion'] ) ) ;
            $fechas_pasadas = date ( 'Y,m,d' , $fechas_pasadas );
        }
        if ( $configuracion_meses["DIAS_FUTUROS"] != "" ) {
            $dias_futuros = $configuracion_meses["DIAS_FUTUROS"];
            $fechas_futuras = strtotime ( '+'.$dias_futuros.' day' , strtotime ( $doc_proveedor[0]['dpv_fecha_contabilizacion'] ) ) ;
            $fechas_futuras = date ( 'Y,m,d' , $fechas_futuras );
        }
    }   

    $data['dias_pasados']       = "new Date(".$fechas_pasadas.")";
    $data['dias_futuros']       = "new Date(".$fechas_futuras.")";
    $data['cheque_pendiente']   = $this->gsatelite->get_tabla('chp_cheque_pendiente', array('chp_estado' => 1, "chp_id_dpv" => $dpv_id) );
    $data['redireccion']        = $redireccion;
    $data['es_modal_ver']       = $ver_detalle;

    $slc_presupuesto            = ($doc_proveedor[0]['dpv_id_psp'] != "" )?$this->get_presupuestoxproyecto($doc_proveedor[0]['dpv_id_pcl'], $doc_proveedor[0]['dpv_id_psp']):'<option value=""></option>';
    $data['presupuesto']        = $slc_presupuesto;
    $slc_general                = ($doc_proveedor[0]['dpv_id_acg'] != "" )?$this->get_actividades_generalesxpresupusto($doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_acg']):'<option value=""></option>';
    $data['general']            = $slc_general;
    $slc_especifica             = ($doc_proveedor[0]['dpv_id_ace'] != "" )?$this->get_actividades_especificas_x_actividad_general($doc_proveedor[0]['dpv_id_acg'], $doc_proveedor[0]['dpv_id_psp'], $doc_proveedor[0]['dpv_id_ace'],true):'<option value=""></option>';
    $data['especifica']         = $slc_especifica;

    $where['cnt_id_tcn'] = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('GASTO'));             
    $data['cuentas'] = $this->utm_model->get_cuentas_like_prorrateo_gral($where);

        //tipo de cuenta
    $select = $this->gsatelite->get_dropdown('tmt_tipo_monto', '{tmt_nombre}', '', array('tmt_estado' => 1), $doc_proveedor[0]['dpv_id_tmt'], '', 'tmt_id', true);
    $data["tipo_monto"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

    if ($ver_detalle == 1) {
        $this->gsatelite->cargar_vista_masterpage('modulo_compras/procesos/editar_doc_proveedor', $data, true);
    } else if ($ver_detalle == 2) {
        $this->_cargarvista($data);
    } else {
        $this->_cargarvista($data);
    }
}
/*************************FIN NOTA DE CREDITO*********************************/

    /**
        * @author Francisco Orozco
        * @since  15/07/2019
        * @param  INT dpv_id   
        * @param  INT tipo_proceso         
        * @return INT Id de partida o si es error retorna 0
        * Descripcion: si tipo = 1 crear un arreglo de la partida contable y si es 2 realiza una insercion en la bd
        * proceso evaluar automaticamente si es de editar
    */
    public function generar_partida_automatica_doc_proveedor($dpv_id = null, $tipo_proceso = 1) {
        satelite_validar();
        
        //tipo_proceso = 1 : return array
        //tipo_proceso = 2 : Insercion
        if ( $_POST){
            if (  $dpv_id > 0 ) {
                //declaracion de varaibles globales
                $proceso_partida    = null;
                $fecha_global_crea  = date('Y-m-d H:i:s');
                $fecha_global_edit  = date('Y-m-d H:i:s');
                $usuario_global_crea= $this->tank_auth->get_user_id();
                $usuario_global_edit= $this->tank_auth->get_user_id();
                $edicion            = false;
                //variables para aproximacion
                $porcentaje_debe    = 0; 
                $porcentaje_haber   = 0; 
                $contador_debe      = 0;
                $contador_haber     = 0;

                //verificacion de periodo contable 
                $this->db->limit(1);
                $this->db->order_by("prc_id","DESC");
                $prc_id = $this->gsatelite->get_tabla("prc_periodo_contable", array( "prc_estado" => 1 ) ); 

                //cuenta por defecto
                $cuenta_defecto         = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                $cuenta_defecto_array   = $this->gsatelite->get_tabla("cnt_cuenta_contable", array( "cnt_id" => $cuenta_defecto ) );
            
                //centro de costo por defecto
                $this->db->limit(1);
                $centro_defecto         = $this->gsatelite->get_campo('cec_centro_costo',"cec_id",array('cec_defecto' => 1) ); 
            
                //Obtener el documento de proveedor con sus detalles.
                $where['dpv_id']        = $dpv_id;
                $dpv                    = $this->compras_model->get_detalle_doc_proveedor_partida( $where, $cuenta_defecto, $centro_defecto );
                if ( count( $dpv ) > 0  ) {
                    //edicion
                    if ( $dpv[0]["dpv_id_pct"] > 0) {
                        $edicion                = true;
                        $pct_partida_contable   = $this->gsatelite->get_tabla("pct_partida_contable", array( "pct_id" => $dpv[0]["dpv_id_pct"] ) );
                        $fecha_global_crea      = $pct_partida_contable[0]["pct_fecha_crea"];
                        $usuario_global_crea    = $pct_partida_contable[0]["pct_usu_crea"];
                    }

                    $ccp_id = ( $dpv[0]["dpv_id_dpv_afecta"] != "" )? 9:8;
                    
                    //Concepto entrada de producto documento proveedor
                    $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => $ccp_id));
                    if(count($pct_concepto) > 0){
                        $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
                    }else{
                        $pct_concepto = 'Concepto no definido';
                    }

                    //Cuenta haber
                    if($dpv[0]["dpv_id_tpg"] == 1) { //Es contado
                        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CAJA'));
                    } else { //Credito
                        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CUENTA_POR_PAGAR'));
                    }
                    
                    //obtener impuestos
                    $cuentas_impuestos          = $this->compras_model->get_cuentas_impuestos();            
                    $cuentas_impuestos_column   = array_column($cuentas_impuestos, 'imp_id');
        
                    //obtener retenciones
                    $cuentas_retenciones        = $this->compras_model->get_cuentas_retenciones();
                    $cuentas_retenciones_column = array_column($cuentas_retenciones, 'ret_id');

                    //cuenta defecto (haber o bebe)
                    $this->db->limit(1);                
                    $cuenta_haber       = $this->gsatelite->get_campo('dfp_detalle_finanza_proveedor','dfp_id_cnt',array("dfp_estado" => 1, "dfp_id_tpg" => $dpv[0]["dpv_id_tpg"], "dfp_id_tcn" => $tipo_cuenta, 'dfp_id_prv' => $dpv[0]["dpv_id_prv"]));
                    $cuenta_haber       = ($cuenta_haber != "") ? $cuenta_haber : $cuenta_defecto;
                    $cuenta_haber_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array( "cnt_id" => $cuenta_haber ) );

                    //tipo de partida
                    $id_tipo_partida= $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');

                    //Tipo de partida
                    $tipo_partida   = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));
                    $consultar      = $this->gsatelite->get_tabla('tpd_tipo_partida',array( 'tpd_id' => $tipo_partida ) );

                    if (count($consultar) > 0 ) {
                        $id_tipo_partida = $tipo_partida;
                    }

                    //obtencion de fecha contable
                    $pct_fecha      = ($dpv[0]['dpv_fecha_contabilizacion'] != "")?$dpv[0]['dpv_fecha_contabilizacion']:$dpv[0]['dpv_fecha_documento'];
                    $pct_fecha      = ($pct_fecha != "")?$pct_fecha:$fecha_global;

                    //obtener id del origen de la partida contable
                    $this->db->limit(1);
                    $pct_id_orp     = $this->gsatelite->get_campo("orp_origen_partida", "orp_id", array("orp_tabla" => "dpv_documento_proveedor", "orp_estado" => 1) );
                    $pct_id_orp     = ($pct_id_orp != "")?$pct_id_orp: NULL;

                    //obtener el correlativo 
                    if ($edicion == true) {
                        $pct_correlativo= $pct_partida_contable[0]["pct_correlativo"];
                    } else {
                        $pct_correlativo= $this->gsatelite->get_max("pct_partida_contable","pct_id")+1;
                    }
                
                    $nombre_completo= ($dpv[0]['prv_tipo_pers'] == 1) ? $dpv[0]['prv_nombre'] . ' '. $dpv[0]['prv_apellido'] : $dpv[0]['prv_apellido'];

                    // se obtendran los centros de costos
                  
                    if ($dpv[0]['centro'] != "") {
                        $centros_array  = array_column($dpv, 'centro');
                        $centros_array  = array_unique($centros_array);
                    } else {
                        if ($centro_defecto != "") {
                            $centros_array  = array($centro_defecto);
                        } else {
                            return 0;
                        }
                    }
                              
                    $contador_centros   = 0;
                    $contador_detalles  = 0;

                    //Se creara el arreglo encabezado de la partida contable
                    $proceso_partida["Encabezado_partida_contable"] = array(
                        'pct_id_tpd'        => $id_tipo_partida,
                        'pct_id_prc'        => $prc_id[0]["prc_id"],
                        'pct_id_padre'      => null,
                        'pct_id_orp'        => $pct_id_orp,
                        'pct_concepto'      => $nombre_completo."-".$pct_concepto."-".formatear_fecha('d-m-Y', $dpv[0]['dpv_fecha_documento'])."-".$dpv[0]['dpv_numero_documento'],
                        'pct_total'         => number_format($dpv[0]['dpv_total'], 4, '.', ''),
                        'pct_fecha'         => $pct_fecha,
                        'pct_correlativo'   => $pct_correlativo,
                        'pct_codigo'        => $dpv[0]['dpv_numero_documento'],
                        'pct_modulo'        => 5,
                        'pct_observacion'   => "",
                        'pct_estado'        => 1,
                        'pct_fecha_crea'    => $fecha_global_crea,
                        'pct_fecha_mod'     => $fecha_global_edit,
                        'pct_usu_crea'      => $usuario_global_crea,
                        'pct_usu_mod'       => $usuario_global_edit
                    );
                  
                    //se creara arreglo de los detalles de la partidas
                    foreach ($centros_array as $key1=> $centros) {
                        //creacion de pcc
                        $proceso_partida["pcc_partida_centro_costo"][] = array (                                                    
                            'pcc_id_cec'            => $centros,
                            'pcc_codigo'            => $dpv[0]['dpv_numero_documento'],
                            'pcc_descripcion'       => "",
                            'pcc_estado'            => 1,
                            'pcc_usu_creacion'      => $usuario_global_crea,
                            'pcc_fecha_creacion'    => $fecha_global_crea,
                            'pcc_usu_modificacion'  => $usuario_global_edit,
                            'pcc_fecha_modificacion'=> $fecha_global_edit
                        );
                        
                        foreach ($dpv as $key2=> $detalle) {
                            //////////////proceso para debe////////////////////////

                            //se verificar si tiene cuenta, sino sera el nombre de la cuenta por defecto.
                            $nombre_cuenta_debe = ( $detalle['cnt_id'] != "" )?$detalle['cnt_nombre']:$cuenta_defecto_array[0]["cnt_nombre"];                   
                            if ( $centros == $detalle['centro'] ) {
                                //impuestos
                                if ( $detalle['impuestos'] != "" ) {                   
                                    $impuestos      = array();
                                    $impuesto_str   = $detalle['impuestos'];
                                    $impuesto_array = explode(",", $impuesto_str);
                                    $todos_impuestos= null;

                                    foreach ($impuesto_array as $impuesto) { 
                                        //posicion = 0: cuenta,
                                        //posicion = 1: impuesto,
                                        //posicion = 2: valor,                  
                                        $prorrateo_tmp      = explode("#", $impuesto);
                                        $cuenta_impuesto    = ($prorrateo_tmp[0] != "")?$prorrateo_tmp[0]:$cuenta_defecto;
                                        
                                        if ( isset ( $todos_impuestos[$cuenta_impuesto] ) ) {
                                            $todos_impuestos[$cuenta_impuesto]['valor'] += $prorrateo_tmp[2];
                                        } else {
                                            $todos_impuestos[$cuenta_impuesto]['valor']= $prorrateo_tmp[2];
                                        }
                                        $todos_impuestos[$cuenta_impuesto]['cuenta']   = $prorrateo_tmp[0];
                                        
                                        //se busca el nombre de la cuenta
                                        if ( in_array( $prorrateo_tmp[1], $cuentas_impuestos_column ) ) {
                                            $posicion = array_search($prorrateo_tmp[1] , $cuentas_impuestos_column );
                                            $todos_impuestos[$cuenta_impuesto]['nombre'] = $cuentas_impuestos[$posicion]["cnt_nombre"];
                                        } else {
                                            $todos_impuestos[$cuenta_impuesto]['nombre'] = $cuenta_defecto_array[0]["cnt_nombre"];
                                        }
                                    }
                                       
                                    foreach ($todos_impuestos as $imp) {
                                        //acumulacion de porcentajes del debe
                                        $porcentaje_debe   += (($imp['valor']*100) / $dpv[0]['dpv_total']); 
                                        $contador_debe     += number_format($imp['valor'], 4, '.', '');

                                        $proceso_partida["dpc_detalle_partida"]["impuestos"][$contador_centros][] = array(
                                            'dpc_id_cnt'                => $imp['cuenta'],   
                                            'dpc_concepto'              => $imp['nombre'],   
                                            'dpc_debe'                  => number_format($imp['valor'], 4, '.', ''),
                                            'dpc_haber'                 => 0.0000,
                                            'dpc_porcentaje_prorrateo'  => ($imp['valor']*100) / $dpv[0]['dpv_total'],      
                                            'dpc_estado'                => 1, 
                                            'dpc_fecha_crea'            => $fecha_global_crea,
                                            'dpc_fecha_mod'             => $fecha_global_edit,
                                            'dpc_usu_crea'              => $usuario_global_crea,
                                            'dpc_usu_mod'               => $usuario_global_edit
                                        );
                                    } 
                                }  

                                //retencion                        
                                if ( $detalle['retenciones'] != "" ) { 
                                    $retenciones        = array();
                                    $retencion_str      = $detalle['retenciones'];
                                    $retencion_array    = explode(",", $retencion_str);
                                    $todas_retenciones  = null;

                                    foreach ($retencion_array as $retencion) {  
                                        //posicion = 0: cuenta,
                                        //posicion = 1: retencion,
                                        //posicion = 2: valor,  
                                        $prorrateo_tmp      = explode("#", $retencion);
                                        $cuenta_retencion   = ($prorrateo_tmp[0] != "")?$prorrateo_tmp[0]:$cuenta_defecto;                                
                                        if ( isset ( $todas_retenciones[$cuenta_retencion] ) ) {
                                            $todas_retenciones[$cuenta_retencion]['valor'] += $prorrateo_tmp[2];
                                        } else {
                                            $todas_retenciones[$cuenta_retencion]['valor']= $prorrateo_tmp[2];
                                        }
                                        $todas_retenciones[$cuenta_retencion]['cuenta']   = $prorrateo_tmp[0];
                                        //se busca el nombre de la cuenta
                                        if ( in_array( $prorrateo_tmp[1], $cuentas_retenciones_column ) ) {
                                            $posicion = array_search($prorrateo_tmp[1] , $cuentas_retenciones_column );
                                            $todas_retenciones[$cuenta_retencion]['nombre'] = $cuentas_retenciones[$posicion]["cnt_nombre"];
                                        } else {
                                            $todas_retenciones[$cuenta_retencion]['nombre'] = $cuenta_defecto_array[0]["cnt_nombre"];
                                        }

                                    }
                                    
                                    foreach ($todas_retenciones as $ret) {
                                        //acumulacion de porcentajes 
                                        $porcentaje_debe   += ($ret['valor']*100) / $dpv[0]['dpv_total'];
                                        $contador_debe     += number_format($ret['valor'], 4, '.', '');

                                        $proceso_partida["dpc_detalle_partida"]["retenciones"][$contador_centros][] = array(
                                            'dpc_id_cnt'                => $ret['cuenta'],   
                                            'dpc_concepto'              => $ret['nombre'],
                                            'dpc_debe'                  => number_format($ret['valor'], 4, '.', ''),
                                            'dpc_haber'                 => 0.0000,
                                            'dpc_porcentaje_prorrateo'  => ($ret['valor']*100) / $dpv[0]['dpv_total'],      
                                            'dpc_estado'                => 1, 
                                            'dpc_fecha_crea'            => $fecha_global_crea,
                                            'dpc_fecha_mod'             => $fecha_global_edit,
                                            'dpc_usu_crea'              => $usuario_global_crea,
                                            'dpc_usu_mod'               => $usuario_global_edit
                                        );
                                    }
                                }

                                if ( $key1 == ( count($centros_array) - 1 ) && $key2 == (count($dpv)-1) ) { // si es la ultima iteracion, procedera acumular.                                
                                    $dpc_porcentaje_prorrateo_d = $this->aproximacion($porcentaje_debe,100);                                
                                    $dpc_debe                   = $this->aproximacion($contador_debe,$dpv[0]['dpv_total']);                                                           
                                } else {
                                    $porcentaje_debe           += ($detalle['total']*100) / $dpv[0]['dpv_total']; 
                                    $dpc_porcentaje_prorrateo_d = ($detalle['total']*100) / $dpv[0]['dpv_total'];

                                    $contador_debe             += number_format($detalle['total'], 4, '.', '');
                                    $dpc_debe                   = number_format($detalle['total'], 4, '.', '');
                                }
                                
                                $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                                    'dpc_id_cnt'                => $detalle['cuenta'],   
                                    'dpc_concepto'              => $nombre_cuenta_debe,
                                    'dpc_debe'                  => $dpc_debe,
                                    'dpc_haber'                 => 0.0000,
                                    'dpc_porcentaje_prorrateo'  => $dpc_porcentaje_prorrateo_d, 
                                    'dpc_estado'                => 1, 
                                    'dpc_fecha_crea'            => $fecha_global_crea,
                                    'dpc_fecha_mod'             => $fecha_global_edit,
                                    'dpc_usu_crea'              => $usuario_global_crea,
                                    'dpc_usu_mod'               => $usuario_global_edit
                                );
                                
                                //haber                             
                                if ( $key1 == ( count($centros_array) - 1 ) && $key2 == (count($dpv)-1) ) {  // si es la ultima iteracion, procedera acumular.
                                    $dpc_porcentaje_prorrateo_h = $this->aproximacion($porcentaje_haber,100);
                                    $dpc_haber                  = $this->aproximacion($contador_haber,$dpv[0]['dpv_total']);
                                } else {
                                    $porcentaje_haber          += (($detalle['suma_haber']*100) / $dpv[0]['dpv_total']); 
                                    $dpc_porcentaje_prorrateo_h = ($detalle['suma_haber']*100) / $dpv[0]['dpv_total'];

                                    $contador_haber            += number_format($detalle['suma_haber'], 4, '.', '');
                                    $dpc_haber                  = number_format($detalle['suma_haber'], 4, '.', '');
                                }

                                $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                    'dpc_id_cnt'                => $cuenta_haber,   
                                    'dpc_concepto'              => $cuenta_haber_array[0]["cnt_nombre"],
                                    'dpc_debe'                  => 0.0000,
                                    'dpc_haber'                 => $dpc_haber,
                                    'dpc_porcentaje_prorrateo'  => $dpc_porcentaje_prorrateo_h, 
                                    'dpc_estado'                => 1, 
                                    'dpc_fecha_crea'            => $fecha_global_crea,
                                    'dpc_fecha_mod'             => $fecha_global_edit,
                                    'dpc_usu_crea'              => $usuario_global_crea,
                                    'dpc_usu_mod'               => $usuario_global_edit
                                );                                        
                                
                            }   
                            $contador_detalles++;                 
                        }
                        $contador_centros++;
                    }            
                    if ( $tipo_proceso == 1) {
                        return $proceso_partida;
                    } else {
                        if ($edicion == true) {
                            //ediciion en pct_partida_contable
                            $id_pct = $pct_partida_contable[0]["pct_id"];
                            $this->gsatelite->actualizar_array('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"], array('pct_id' => $id_pct) );
                            //eliminacion de los detalles
                            $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $id_pct) );
                            $this->gsatelite->borrado_general('pcc_partida_centro_costo', array('pcc_id_pct' => $id_pct) );
                        } else {
                            //insertar en pct_partida_contable
                            $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"] );
                        }
                        
        
                        foreach ( $proceso_partida["pcc_partida_centro_costo"] as $centro_contador => $partida_centro) {
                            //se agregaran partdas por centro de costo
                            $partida_centro["pcc_id_pct"] = $id_pct;
                            $id_pcc = $this->gsatelite->ingresar('pcc_partida_centro_costo', $partida_centro);
                            
                            //se agregaran los detalles de partida

                            //debe
                            foreach ($proceso_partida["dpc_detalle_partida"]["debe"][$centro_contador] as $debe_contador => $debe) {
                                $debe["dpc_id_pcc"] = $id_pcc;  
                                $debe["dpc_id_pct"] = $id_pct;  
                                $this->gsatelite->ingresar('dpc_detalle_partida', $debe);
                            }
        
                            //impuesto
                            if ( isset($proceso_partida["dpc_detalle_partida"]["impuestos"][$centro_contador]) ) {
                                foreach ( $proceso_partida["dpc_detalle_partida"]["impuestos"][$centro_contador] as $contador_impuesto => $impuesto) {
                                    $impuesto["dpc_id_pcc"] = $id_pcc;
                                    $impuesto["dpc_id_pct"] = $id_pct;
                                    $this->gsatelite->ingresar('dpc_detalle_partida', $impuesto);
                                }
                            }
                        
                            //retenciones
                            if ( isset($proceso_partida["dpc_detalle_partida"]["retenciones"][$centro_contador]) ) {
                                foreach ( $proceso_partida["dpc_detalle_partida"]["retenciones"][$centro_contador] as $contador_retencion => $retencion) {
                                    $retencion["dpc_id_pcc"] = $id_pcc;
                                    $retencion["dpc_id_pct"] = $id_pct;
                                    $this->gsatelite->ingresar('dpc_detalle_partida', $retencion);
                                }
                            }
                        
                            //haber
                            foreach ( $proceso_partida["dpc_detalle_partida"]["haber"][$centro_contador] as $contador_haber => $haber) {
                                $haber["dpc_id_pcc"] = $id_pcc;
                                $haber["dpc_id_pct"] = $id_pct;
                                $this->gsatelite->ingresar('dpc_detalle_partida', $haber);
                            }
        
                        }
                        return $id_pct;
                    }            
                } else {
                    return 0;
                }      
            } else{
                return 0;
            }
        } else{
            redirect('/auth/login/');
        }
    }

    /**
        * @author Francisco Orozco
        * @since  23/07/2019
        * @param  DOUBLE contador_total
        * @param  DOUBLE total_necesario         
        * @return DOUBLE Id de partida o si es error retorna 0
        * Descripcion: Se aplicara aproximacion hacia el total, si falta, agregara y si se pasa, le quitara para aplicar ley del llegue.
    */
    function aproximacion($contador_total = 0, $total_necesario = 0 ) {       
        satelite_validar();  
        if ( $contador_total != $total_necesario) {         
            $total = $total_necesario - $contador_total;    
        } else {
            $total = 0;
        }
        return $total;
    }

    public function actualizar_docs(){
        $i=0;
        $prv_name = "";        
        $ids = $this->input->post('ids');
        $tabla = $this->gsatelite->get_tabla('dpv_documento_proveedor', array("dpv_id in ($ids)" => NULL));
        $num_docs = array_column($tabla, 'dpv_numero_documento');//array con los numeros de Doc seleccionados
        $ids_prov = array_column($tabla, 'dpv_id_prv');//array con los id de los proveedores
        $doc_num = implode(', ', $num_docs);//string con los numeros de docs condatenados
        $prv_ids = implode(', ', array_unique(array_filter($ids_prov)));
        $proveedores = $this->gsatelite->get_tabla('prv_proveedor', array("prv_id in ($prv_ids)" => NULL));
        foreach ($proveedores as $key => $value) {
            if ($i==0) {
                $prv_name .= ($value['prv_tipo_pers'] == 2) ? $value['prv_apellido'] : $value['prv_nombre'] . ' ' . $value['prv_apellido']; 
                $i++;
            } else {
                $prv_name .= ($value['prv_tipo_pers'] == 2) ? ', ' . $value['prv_apellido'] : ', ' . $value['prv_nombre'] . ' ' . $value['prv_apellido']; 
            }            
        }
        echo json_encode(array('doc_num' => $doc_num, 'prv_name' => $prv_name));
    }

    public function caja_chica_flashdata($caja_id = NULL){
        $data = 0;
        $cch_id_emp = 0;
        $caja_id = $this->input->post('caja_chica');
        $emp_id  = $this->gsatelite->get_campo("emp_empleado", "emp_id", array("emp_id_usu" => $this->tank_auth->get_user_id()));
        if ($caja_id != NULL && $caja_id > 0) {
            $cch_id_emp  = $this->gsatelite->get_campo("cch_caja_chica", "cch_id_emp", array("cch_id" => $caja_id));
        }
        if ($caja_id != NULL && $caja_id > 0 && (int)$emp_id == (int)$cch_id_emp) {
            $this->session->set_flashdata('caja_chica', $caja_id);
            $data = 1;
        }        
        echo $data;
        die();
    }

    /**
        * @author Francisco Orozco
        * @since  15/07/2019
        * @param  INT dpv_id   
        * @param  INT tipo_proceso         
        * @return INT Id de partida o si es error retorna 0
        * Descripcion: si tipo = 1 crear un arreglo de la partida contable y si es 2 realiza una insercion en la bd
        * proceso evaluar automaticamente si es de editar
    */
    public function generar_partida_automatica_anular_doc_proveedor($dpv_id = null, $tipo_proceso = 1) {
        satelite_validar();
        
        //tipo_proceso = 1 : return array
        //tipo_proceso = 2 : Insercion
        //if ( $_POST){
        //var_dump($dpv_id);die();
            if (  $dpv_id > 0 ) {
                //declaracion de varaibles globales
                $proceso_partida    = null;
                $fecha_global_crea  = date('Y-m-d H:i:s');
                $fecha_global_edit  = date('Y-m-d H:i:s');
                $usuario_global_crea= $this->tank_auth->get_user_id();
                $usuario_global_edit= $this->tank_auth->get_user_id();
                $edicion            = false;
                //variables para aproximacion
                $porcentaje_debe    = 0; 
                $porcentaje_haber   = 0; 
                $contador_debe      = 0;
                $contador_haber     = 0;

                //verificacion de periodo contable 
                $this->db->limit(1);
                $this->db->order_by("prc_id","DESC");
                $prc_id = $this->gsatelite->get_tabla("prc_periodo_contable", array( "prc_estado" => 1 ) ); 

                //cuenta por defecto
                $cuenta_defecto         = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                $cuenta_defecto_array   = $this->gsatelite->get_tabla("cnt_cuenta_contable", array( "cnt_id" => $cuenta_defecto ) );
            
                //centro de costo por defecto
                $this->db->limit(1);
                $centro_defecto         = $this->gsatelite->get_campo('cec_centro_costo',"cec_id",array('cec_defecto' => 1) ); 
            
                //Obtener el documento de proveedor con sus detalles.
                $where['dpv_id']        = $dpv_id;
                $dpv                    = $this->compras_model->get_detalle_doc_proveedor_partida( $where, $cuenta_defecto, $centro_defecto );                             
                //var_dump($dpv);die();
                if ( count( $dpv ) > 0  ) {
                    //edicion
                    if ( $dpv[0]["dpv_id_pct"] > 0) {
                        $edicion                = true;
                        $pct_partida_contable   = $this->gsatelite->get_tabla("pct_partida_contable", array( "pct_id" => $dpv[0]["dpv_id_pct"] ) );
                        $fecha_global_crea      = $pct_partida_contable[0]["pct_fecha_crea"];
                        $usuario_global_crea    = $pct_partida_contable[0]["pct_usu_crea"];
                    }

                    $ccp_id = ( $dpv[0]["dpv_id_dpv_afecta"] != "" )? 9:8;
                    
                    //Concepto entrada de producto documento proveedor
                    $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => $ccp_id));
                    if(count($pct_concepto) > 0){
                        $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
                    }else{
                        $pct_concepto = 'Concepto no definido';
                    }

                    //Cuenta haber
                    if($dpv[0]["dpv_id_tpg"] == 1) { //Es contado
                        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CAJA'));
                    } else { //Credito
                        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CUENTA_POR_PAGAR'));
                    }
                    
                    //obtener impuestos
                    $cuentas_impuestos          = $this->compras_model->get_cuentas_impuestos();            
                    $cuentas_impuestos_column   = array_column($cuentas_impuestos, 'imp_id');
        
                    //obtener retenciones
                    $cuentas_retenciones        = $this->compras_model->get_cuentas_retenciones();
                    $cuentas_retenciones_column = array_column($cuentas_retenciones, 'ret_id');

                    //cuenta defecto (haber o bebe)
                    $this->db->limit(1);                
                    $cuenta_haber       = $this->gsatelite->get_campo('dfp_detalle_finanza_proveedor','dfp_id_cnt',array("dfp_estado" => 1, "dfp_id_tpg" => $dpv[0]["dpv_id_tpg"], "dfp_id_tcn" => $tipo_cuenta ));
                    $cuenta_haber       = ($cuenta_haber != "")?$cuenta_haber:$cuenta_defecto;
                    $cuenta_haber_array = $this->gsatelite->get_tabla("cnt_cuenta_contable", array( "cnt_id" => $cuenta_haber ) );

                    //tipo de partida
                    $id_tipo_partida= $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');

                    //Tipo de partida
                    $tipo_partida   = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));
                    $consultar      = $this->gsatelite->get_tabla('tpd_tipo_partida',array( 'tpd_id' => $tipo_partida ) );

                    if (count($consultar) > 0 ) {
                        $id_tipo_partida = $tipo_partida;
                    }

                    //obtencion de fecha contable
                    $pct_fecha      = ($dpv[0]['dpv_fecha_contabilizacion'] != "")?$dpv[0]['dpv_fecha_contabilizacion']:$dpv[0]['dpv_fecha_documento'];
                    $pct_fecha      = ($pct_fecha != "")?$pct_fecha:$fecha_global;

                    //obtener id del origen de la partida contable
                    $this->db->limit(1);
                    $pct_id_orp     = $this->gsatelite->get_campo("orp_origen_partida", "orp_id", array("orp_tabla" => "dpv_documento_proveedor", "orp_estado" => 1) );
                    $pct_id_orp     = ($pct_id_orp != "")?$pct_id_orp: NULL;

                    //obtener el correlativo 
                    if ($edicion == true) {
                        $pct_correlativo= $pct_partida_contable[0]["pct_correlativo"];
                    } else {
                        $pct_correlativo= $this->gsatelite->get_max("pct_partida_contable","pct_id")+1;
                    }
                
                    $nombre_completo= ($dpv[0]['prv_tipo_pers'] == 1) ? $dpv[0]['prv_nombre'] . ' '. $dpv[0]['prv_apellido'] : $dpv[0]['prv_apellido'];

                    // se obtendran los centros de costos
                  
                    if ($dpv[0]['centro'] != "") {
                        $centros_array  = array_column($dpv, 'centro');
                        $centros_array  = array_unique($centros_array);
                    } else {
                        if ($centro_defecto != "") {
                            $centros_array  = array($centro_defecto);
                        } else {
                            return 0;
                        }
                    }
                              
                    $contador_centros   = 0;
                    $contador_detalles  = 0;

                    //Se creara el arreglo encabezado de la partida contable
                    $proceso_partida["Encabezado_partida_contable"] = array(
                        'pct_id_tpd'        => $id_tipo_partida,
                        'pct_id_prc'        => $prc_id[0]["prc_id"],
                        'pct_id_padre'      => null,
                        'pct_id_orp'        => $pct_id_orp,
                        'pct_concepto'      => "Anulación ". $nombre_completo."-".$pct_concepto."-".formatear_fecha('d-m-Y', $dpv[0]['dpv_fecha_documento'])."-".$dpv[0]['dpv_numero_documento'],
                        'pct_total'         => number_format($dpv[0]['dpv_total'], 4, '.', ''),
                        'pct_fecha'         => date('Y-m-d H:i:s'),
                        'pct_correlativo'   => $pct_correlativo,
                        'pct_codigo'        => $dpv[0]['dpv_numero_documento'],
                        'pct_modulo'        => 5,
                        'pct_observacion'   => "",
                        'pct_estado'        => 1,
                        'pct_fecha_crea'    => $fecha_global_crea,
                        'pct_fecha_mod'     => $fecha_global_edit,
                        'pct_usu_crea'      => $usuario_global_crea,
                        'pct_usu_mod'       => $usuario_global_edit
                    );
                  
                    //se creara arreglo de los detalles de la partidas
                    foreach ($centros_array as $key1=> $centros) {
                        //creacion de pcc
                        $proceso_partida["pcc_partida_centro_costo"][] = array (                                                    
                            'pcc_id_cec'            => $centros,
                            'pcc_codigo'            => $dpv[0]['dpv_numero_documento'],
                            'pcc_descripcion'       => "",
                            'pcc_estado'            => 1,
                            'pcc_usu_creacion'      => $usuario_global_crea,
                            'pcc_fecha_creacion'    => $fecha_global_crea,
                            'pcc_usu_modificacion'  => $usuario_global_edit,
                            'pcc_fecha_modificacion'=> $fecha_global_edit
                        );
                        
                        foreach ($dpv as $key2=> $detalle) {
                            //////////////proceso para debe////////////////////////

                            //se verificar si tiene cuenta, sino sera el nombre de la cuenta por defecto.
                            $nombre_cuenta_debe = ( $detalle['cnt_id'] != "" )?$detalle['cnt_nombre']:$cuenta_defecto_array[0]["cnt_nombre"];                   
                            if ( $centros == $detalle['centro'] ) {
                                //impuestos
                                if ( $detalle['impuestos'] != "" ) {                   
                                    $impuestos      = array();
                                    $impuesto_str   = $detalle['impuestos'];
                                    $impuesto_array = explode(",", $impuesto_str);
                                    $todos_impuestos= null;

                                    foreach ($impuesto_array as $impuesto) { 
                                        //posicion = 0: cuenta,
                                        //posicion = 1: impuesto,
                                        //posicion = 2: valor,                  
                                        $prorrateo_tmp      = explode("#", $impuesto);
                                        $cuenta_impuesto    = ($prorrateo_tmp[0] != "")?$prorrateo_tmp[0]:$cuenta_defecto;
                                        
                                        if ( isset ( $todos_impuestos[$cuenta_impuesto] ) ) {
                                            $todos_impuestos[$cuenta_impuesto]['valor'] += $prorrateo_tmp[2];
                                        } else {
                                            $todos_impuestos[$cuenta_impuesto]['valor']= $prorrateo_tmp[2];
                                        }
                                        $todos_impuestos[$cuenta_impuesto]['cuenta']   = $prorrateo_tmp[0];
                                        
                                        //se busca el nombre de la cuenta
                                        if ( in_array( $prorrateo_tmp[1], $cuentas_impuestos_column ) ) {
                                            $posicion = array_search($prorrateo_tmp[1] , $cuentas_impuestos_column );
                                            $todos_impuestos[$cuenta_impuesto]['nombre'] = $cuentas_impuestos[$posicion]["cnt_nombre"];
                                        } else {
                                            $todos_impuestos[$cuenta_impuesto]['nombre'] = $cuenta_defecto_array[0]["cnt_nombre"];
                                        }
                                    }
                                       
                                    foreach ($todos_impuestos as $imp) {
                                        //acumulacion de porcentajes del debe
                                        $porcentaje_debe   += (($imp['valor']*100) / $dpv[0]['dpv_total']); 
                                        $contador_debe     += number_format($imp['valor'], 4, '.', '');

                                        $proceso_partida["dpc_detalle_partida"]["impuestos"][$contador_centros][] = array(
                                            'dpc_id_cnt'                => $imp['cuenta'],   
                                            'dpc_concepto'              => $imp['nombre'],   
                                            'dpc_debe'                  => 0.0000,
                                            'dpc_haber'                 => number_format($imp['valor'], 4, '.', ''),
                                            'dpc_porcentaje_prorrateo'  => ($imp['valor']*100) / $dpv[0]['dpv_total'],      
                                            'dpc_estado'                => 1, 
                                            'dpc_fecha_crea'            => $fecha_global_crea,
                                            'dpc_fecha_mod'             => $fecha_global_edit,
                                            'dpc_usu_crea'              => $usuario_global_crea,
                                            'dpc_usu_mod'               => $usuario_global_edit
                                        );
                                    } 
                                }  

                                //retencion                        
                                if ( $detalle['retenciones'] != "" ) { 
                                    $retenciones        = array();
                                    $retencion_str      = $detalle['retenciones'];
                                    $retencion_array    = explode(",", $retencion_str);
                                    $todas_retenciones  = null;

                                    foreach ($retencion_array as $retencion) {  
                                        //posicion = 0: cuenta,
                                        //posicion = 1: retencion,
                                        //posicion = 2: valor,  
                                        $prorrateo_tmp      = explode("#", $retencion);
                                        $cuenta_retencion   = ($prorrateo_tmp[0] != "")?$prorrateo_tmp[0]:$cuenta_defecto;                                
                                        if ( isset ( $todas_retenciones[$cuenta_retencion] ) ) {
                                            $todas_retenciones[$cuenta_retencion]['valor'] += $prorrateo_tmp[2];
                                        } else {
                                            $todas_retenciones[$cuenta_retencion]['valor']= $prorrateo_tmp[2];
                                        }
                                        $todas_retenciones[$cuenta_retencion]['cuenta']   = $prorrateo_tmp[0];
                                        //se busca el nombre de la cuenta
                                        if ( in_array( $prorrateo_tmp[1], $cuentas_retenciones_column ) ) {
                                            $posicion = array_search($prorrateo_tmp[1] , $cuentas_retenciones_column );
                                            $todas_retenciones[$cuenta_retencion]['nombre'] = $cuentas_retenciones[$posicion]["cnt_nombre"];
                                        } else {
                                            $todas_retenciones[$cuenta_retencion]['nombre'] = $cuenta_defecto_array[0]["cnt_nombre"];
                                        }

                                    }
                                    
                                    foreach ($todas_retenciones as $ret) {
                                        //acumulacion de porcentajes 
                                        $porcentaje_debe   += ($ret['valor']*100) / $dpv[0]['dpv_total'];
                                        $contador_debe     += number_format($ret['valor'], 4, '.', '');

                                        $proceso_partida["dpc_detalle_partida"]["retenciones"][$contador_centros][] = array(
                                            'dpc_id_cnt'                => $ret['cuenta'],   
                                            'dpc_concepto'              => $ret['nombre'],
                                            'dpc_debe'                  => 0.0000,
                                            'dpc_haber'                 => number_format($ret['valor'], 4, '.', ''),
                                            'dpc_porcentaje_prorrateo'  => ($ret['valor']*100) / $dpv[0]['dpv_total'],      
                                            'dpc_estado'                => 1, 
                                            'dpc_fecha_crea'            => $fecha_global_crea,
                                            'dpc_fecha_mod'             => $fecha_global_edit,
                                            'dpc_usu_crea'              => $usuario_global_crea,
                                            'dpc_usu_mod'               => $usuario_global_edit
                                        );
                                    }
                                }

                                if ( $key1 == ( count($centros_array) - 1 ) && $key2 == (count($dpv)-1) ) { // si es la ultima iteracion, procedera acumular.                                
                                    $dpc_porcentaje_prorrateo_d = $this->aproximacion($porcentaje_debe,100);                                
                                    $dpc_debe                   = $this->aproximacion($contador_debe,$dpv[0]['dpv_total']);                                                           
                                } else {
                                    $porcentaje_debe           += ($detalle['total']*100) / $dpv[0]['dpv_total']; 
                                    $dpc_porcentaje_prorrateo_d = ($detalle['total']*100) / $dpv[0]['dpv_total'];

                                    $contador_debe             += number_format($detalle['total'], 4, '.', '');
                                    $dpc_debe                   = number_format($detalle['total'], 4, '.', '');
                                }
                                
                                $proceso_partida["dpc_detalle_partida"]["debe"][$contador_centros][] = array(
                                    'dpc_id_cnt'                => $detalle['cuenta'],   
                                    'dpc_concepto'              => $nombre_cuenta_debe,
                                    'dpc_debe'                  => 0.0000,
                                    'dpc_haber'                 => $dpc_debe,
                                    'dpc_porcentaje_prorrateo'  => $dpc_porcentaje_prorrateo_d, 
                                    'dpc_estado'                => 1, 
                                    'dpc_fecha_crea'            => $fecha_global_crea,
                                    'dpc_fecha_mod'             => $fecha_global_edit,
                                    'dpc_usu_crea'              => $usuario_global_crea,
                                    'dpc_usu_mod'               => $usuario_global_edit
                                );
                                
                                //haber                             
                                if ( $key1 == ( count($centros_array) - 1 ) && $key2 == (count($dpv)-1) ) {  // si es la ultima iteracion, procedera acumular.
                                    $dpc_porcentaje_prorrateo_h = $this->aproximacion($porcentaje_haber,100);
                                    $dpc_haber                  = $this->aproximacion($contador_haber,$dpv[0]['dpv_total']);
                                } else {
                                    $porcentaje_haber          += (($detalle['suma_haber']*100) / $dpv[0]['dpv_total']); 
                                    $dpc_porcentaje_prorrateo_h = ($detalle['suma_haber']*100) / $dpv[0]['dpv_total'];

                                    $contador_haber            += number_format($detalle['suma_haber'], 4, '.', '');
                                    $dpc_haber                  = number_format($detalle['suma_haber'], 4, '.', '');
                                }

                                $proceso_partida["dpc_detalle_partida"]["haber"][$contador_centros][] = array(
                                    'dpc_id_cnt'                => $cuenta_haber,   
                                    'dpc_concepto'              => $cuenta_haber_array[0]["cnt_nombre"],
                                    'dpc_debe'                  => $dpc_haber,
                                    'dpc_haber'                 => 0.0000,
                                    'dpc_porcentaje_prorrateo'  => $dpc_porcentaje_prorrateo_h, 
                                    'dpc_estado'                => 1, 
                                    'dpc_fecha_crea'            => $fecha_global_crea,
                                    'dpc_fecha_mod'             => $fecha_global_edit,
                                    'dpc_usu_crea'              => $usuario_global_crea,
                                    'dpc_usu_mod'               => $usuario_global_edit
                                );                                        
                                
                            }   
                            $contador_detalles++;                 
                        }
                        $contador_centros++;
                    }            
                    if ( $tipo_proceso == 1) {
                        return $proceso_partida;
                    } else {
                        if ($edicion == true) {
                            //ediciion en pct_partida_contable
                            $id_pct = $pct_partida_contable[0]["pct_id"];
                            $this->gsatelite->actualizar_array('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"], array('pct_id' => $id_pct) );
                            //eliminacion de los detalles
                            $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $id_pct) );
                            $this->gsatelite->borrado_general('pcc_partida_centro_costo', array('pcc_id_pct' => $id_pct) );
                        } else {
                            //insertar en pct_partida_contable
                            $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $proceso_partida["Encabezado_partida_contable"] );
                        }
                        
        
                        foreach ( $proceso_partida["pcc_partida_centro_costo"] as $centro_contador => $partida_centro) {
                            //se agregaran partdas por centro de costo
                            $partida_centro["pcc_id_pct"] = $id_pct;
                            $id_pcc = $this->gsatelite->ingresar('pcc_partida_centro_costo', $partida_centro);
                            
                            //se agregaran los detalles de partida

                            //debe
                            foreach ($proceso_partida["dpc_detalle_partida"]["debe"][$centro_contador] as $debe_contador => $debe) {
                                $debe["dpc_id_pcc"] = $id_pcc;  
                                $debe["dpc_id_pct"] = $id_pct;  
                                $this->gsatelite->ingresar('dpc_detalle_partida', $debe);
                            }
        
                            //impuesto
                            if ( isset($proceso_partida["dpc_detalle_partida"]["impuestos"][$centro_contador]) ) {
                                foreach ( $proceso_partida["dpc_detalle_partida"]["impuestos"][$centro_contador] as $contador_impuesto => $impuesto) {
                                    $impuesto["dpc_id_pcc"] = $id_pcc;
                                    $impuesto["dpc_id_pct"] = $id_pct;
                                    $this->gsatelite->ingresar('dpc_detalle_partida', $impuesto);
                                }
                            }
                        
                            //retenciones
                            if ( isset($proceso_partida["dpc_detalle_partida"]["retenciones"][$centro_contador]) ) {
                                foreach ( $proceso_partida["dpc_detalle_partida"]["retenciones"][$centro_contador] as $contador_retencion => $retencion) {
                                    $retencion["dpc_id_pcc"] = $id_pcc;
                                    $retencion["dpc_id_pct"] = $id_pct;
                                    $this->gsatelite->ingresar('dpc_detalle_partida', $retencion);
                                }
                            }
                        
                            //haber
                            foreach ( $proceso_partida["dpc_detalle_partida"]["haber"][$centro_contador] as $contador_haber => $haber) {
                                $haber["dpc_id_pcc"] = $id_pcc;
                                $haber["dpc_id_pct"] = $id_pct;
                                $this->gsatelite->ingresar('dpc_detalle_partida', $haber);
                            }
        
                        }
                        return $id_pct;
                    }            
                } else {
                    return 0;
                }      
            } else{
                return 0;
            }
        
    }

    /**
     *@author: Marlon Olmedo
     *Fecha: 2019/07/22
     *Descripción: Verificar si el usuario tiene permiso para agregar un nuevo cliente
     */
    public function get_permisos(){
        satelite_validar();
        $permisos_url = $this->input->post('url');
        $permisos = $this->gsatelite->get_permisos_opcion($permisos_url);
        $permite_agregar = (int) $permisos['permite_agregar'];
        
        echo json_encode(array('permiso' => $permite_agregar));
    }

    /**
     *@author: Marlon Olmedo
     *Fecha: 2019/07/22
     *Descripción: Verificar la existencia de un flujo en compras
     */
    public function validar_flujo($parametro_ = NULL){
        satelite_validar();
        $parametro = ($this->input->post('parametro') != '')? $this->input->post('parametro') : $parametro_; //acepta ya sea post por ajax o llamada desde otra funcion
        $no_par = 0;
        $no_flu = 0;
        
        $par_parametro = json_decode($this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO',4), true);
        
        if ($par_parametro[$parametro] != NULL) {
            $primer_paso= $this->inventario_model->get_primer_paso_flujo($par_parametro[$parametro]);
            
            if (!empty($primer_paso)) {
                $no_flu = 1;
                //print_r("entrar");die();
            }
            //var_dump(!empty($primer_paso));die();
            $no_par = 1;
        } 

        if ($this->input->post('parametro') != '') { //si es por ajax sera un echo 
            echo json_encode(array('no_par' => $no_par, "no_flu" => $no_flu));
        } else {
            return array('no_par' => $no_par, "no_flu" => $no_flu);
        }
        
    }

    /**
    * Descripción: Invoca la Consulta de la ubicacion de productos y/o sectores del modulo de facturacion
    * @author Grupo satélite - Raul Escalante
    */
    public function ubicacion_producto(){
        satelite_validar();
        $this->load->library('../controllers/facturacion/facturar');
        $this->facturar->ubicacion_producto();
    }

    function exportar_dpvs() {
        satelite_validar();
        switch ($_POST['slcFiltro']) {
            case '1':
                $where['DATE(dpv_fecha_creacion) >= '] = formatear_fecha('Y-m-d', $_POST['txtFechaIni']);
                $where['DATE(dpv_fecha_creacion) <= '] = formatear_fecha('Y-m-d', $_POST['txtFechaFin']);
                break;
            case '2':
                $where['DATE(dpv_fecha_documento) >= '] = formatear_fecha('Y-m-d', $_POST['txtFechaIni']);
                $where['DATE(dpv_fecha_documento) <= '] = formatear_fecha('Y-m-d', $_POST['txtFechaFin']);
                break;
            case '3':
                $where['DATE(dpv_fecha_contabilizacion) >= '] = formatear_fecha('Y-m-d', $_POST['txtFechaIni']);
                $where['DATE(dpv_fecha_contabilizacion) <= '] = formatear_fecha('Y-m-d', $_POST['txtFechaFin']);
                break;
            case '4':
                $where['DATE(dpv_fecha_vencimiento) >= '] = formatear_fecha('Y-m-d', $_POST['txtFechaIni']);
                $where['DATE(dpv_fecha_vencimiento) <= '] = formatear_fecha('Y-m-d', $_POST['txtFechaFin']);
                break;
            default:
                $where = null;
                break;
        }
        if ($_POST['slCjch'] != "") {
            if ($_POST['slCjch'] > 0) {
                $where['dpv_id_cch'] = $_POST['slCjch'];
            } else {
                $where['dpv_id_cch IS NULL'] = null;
            }
        }
        $data['documentos'] = $this->compras_model->get_grid_documentos_proveedor($where);
        $data['tipo_reporte'] = $_POST['tipo_rep'];
        $data['filename'] = 'rpt_doc_proveedor_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $html = $this->load->view('modulo_compras/procesos/reporte_documentos_proveedor', $data, true);
        if ($_POST['tipo_rep'] == 'pdf') {
            $data['solotitulo'] = true;
            $data['titulo'] = 'Documentos de Proveedor';    
            $header = $this->load->view('reporte/header', $data, true);    
            $GLOBALS['nombre_reporte'] = 'Reporte_Documentos_Proveedor_' . date('dmY');    
            $reporte = $header . $html;
            $this->pdf->makePdf($reporte, 'L');
        } else {
            echo $html;
        }        
    }


    ///////////////////////////////////////////////FACTURACION ELECTRONICA ///////////////////////////////////////////

    public function generar_datos_factura_electronica($dpv_id='') {
        $bytes = openssl_random_pseudo_bytes(16);
        $bytes[6] = chr(ord($bytes[6]) & 0x0f | 0x40);
        $bytes[8] = chr(ord($bytes[8]) & 0x3f | 0x80);
        $string =  strtoupper(vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($bytes), 4)));
        $generacion = strtoupper($string);
        $codigos_control = $this->facturacion_model->datos_numero_control_compras($dpv_id);
        $num_ctrl = 'DTE-' . $codigos_control['tipo_documento'] . '-';
        if ($codigos_control['suc_codigo_fact_elect'] != "") {
            $num_ctrl .= $codigos_control['suc_codigo_fact_elect'];
        } else {
            $num_ctrl .= 'S' . str_pad(intval($codigos_control['suc_codigo']), 3, '0', STR_PAD_LEFT);
        }
        if ($codigos_control['caj_codigo_fact_elect'] != "") {
            $num_ctrl .= $codigos_control['caj_codigo_fact_elect'];
        } else {
            $num_ctrl .= 'P' . str_pad(intval($codigos_control['caj_id']), 3, '0', STR_PAD_LEFT);
        }
        $num_ctrl .= '-' . str_pad(intval($codigos_control['corr_anual']), 15, '0', STR_PAD_LEFT);
        return array('cod_generation' => $generacion, 'num_control' => $num_ctrl);
    }

    public function crear_json_suj_exc($dpv_id=''){
        $response = $cuerpo = array();
        $this->load->library('EnLetras');
        $prv_document = $this->facturacion_model->get_doc_dte_compra($dpv_id)[0]; //PROVEEDOR (RECEPTOR)
        $code_suc_arry = substr(explode("-", $prv_document['dpv_numero_control'])[2], 0, 4);
        $nombre_sucursal = $this->gsatelite->get_campo("suc_sucursal", "suc_nombre", array("suc_codigo_fact_elect" => $code_suc_arry));
        $empresa = $this->facturacion_model->get_empresa_dte($this->tank_auth->get_empresa_id())[0]; // (EMISOR)
        $detalles = $this->facturacion_model->get_cuerpo_dte_compra($dpv_id);
        $totalf = explode('.', number_format($prv_document['dpv_total'], 2, '.',''));
        $total_letras = $this->enletras->num2letras($totalf[0]);
        $total_letras .= ' CON ' . $totalf[1] . '/100 DOLARES';
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $dato_api = json_decode($this->gsatelite->get_parametro('API_KEY_FACTURACION_SAT'), true);
        if ($prv_document['dpv_id_tif'] == $tipo_factura["SUJETO EXCLUIDO"]) {
            //DETALLES CUERPO
            foreach ($detalles as $k => $v) {
                $punit = $v['dxd_precio_unitario'];
                $venta = (number_format($punit, 8, '.', '') * number_format($v['dxd_cantidad'], 8, '.', '')) - number_format($v['dxd_descuento'], 8, '.', '');
                $detalle = array(
                    "numItem" => ($k + 1),
                    "tipoItem" => intval($v['code_art_tipo']),
                    "cantidad" => round($v['dxd_cantidad'], 4),
                    "codigo" => (trim($v['art_codigo']) != "") ? mb_substr(trim($v['art_codigo']),0,25,"UTF-8") : null,
                    "uniMedida" => intval($v['code_uni_medi']), 
                    "descripcion" => mb_substr(trim($v['dxd_descripcion']), 0, 1000,"UTF-8"),
                    "precioUni" => round($punit, 4),
                    "montoDescu" => round($v['dxd_descuento'], 4),
                    "compra" => round($venta, 4),
                );
                $cuerpo[] = $detalle;
            }
            //DATOS RECEPTOR
            $nitduinum = ($prv_document['prv_nit'] != "" && $prv_document['cod_tde_nit'] != "") ? str_replace('-', '',  $prv_document['prv_nit']) : str_replace('-', '',  $prv_document['prv_dui']);
            $nitduicod = ($prv_document['prv_nit'] != "" && $prv_document['cod_tde_nit'] != "") ? $prv_document['cod_tde_nit'] : $prv_document['cod_tde_dui'];
            $receptnom = ($prv_document['prv_tipo_pers'] > 1) ? $prv_document['prv_apellido'] : $prv_document['prv_nombre']  . ' ' .  $prv_document['prv_apellido'];
            if ($prv_document['condicion_operacion'] == "" || $prv_document['condicion_operacion'] == 2) {
                $pagos = null;
            } else {
                // $pagos = array(
                //     array(
                //         "codigo" => "02", //  cat 17
                //         "montoPago" =>  1000, //Deberá indicar el valor monetario que seha aplicado con cadaforma de pago 
                //         "referencia" => "Referencia no. 32CCSA",// si cash  esto null
                //         "periodo" => 4, // si credito tiempo ej 6 meses    aqui 6 y en plazo el cod de meses     sino null
                //         "plazo" => "02",// si credito  tiempo segun cat 18 (meses-dias), sino null 
                //         "observaciones" => null
                //     ),
                //     array(
                //         "codigo" => "02",
                //         "periodo" => 4,
                //         "plazo" => "02",
                //         "montoPago" => 1000,
                //         "referencia" => "Referencia no. 32CCSA"
                //     )
                // );
                $pagos = null;
            }            
            $response = array(
                "identificacion" => array(
                    "version" => 1,
                    "ambiente" => ($dato_api["AMBIENTE"] != "") ? $dato_api["AMBIENTE"] : "00",//00=prueba - 01=produccion
                    "tipoDte" => "14",
                    "numeroControl" => $prv_document['dpv_numero_control'],
                    "codigoGeneracion" => $prv_document['dpv_codigo_generacion'],
                    "tipoModelo" => 1,
                    "tipoOperacion" => 1,
                    "tipoContingencia" => null,
                    "motivoContin" => null,
                    "fecEmi" => date('Y-m-d'),
                    "horEmi" => date('H:i:s'),
                    "tipoMoneda" => "USD"        
                ),
                "emisor" => array(
                    "nit" => (trim($empresa['emr_nit']) != "")?str_replace('-','',trim($empresa['emr_nit'])):str_replace('-','',$this->gsatelite->get_parametro('SYS_NIT')),
                    "nrc" => (trim($empresa['emr_numero_registro'])!= "")?str_replace('-','',trim($empresa['emr_numero_registro'])):str_replace('-','',$this->gsatelite->get_parametro('SYS_REGISTRO')),
                    "nombre" => $empresa['emr_nombre'],
                    "codActividad" => $empresa['gir_codigo_fact_elect'],
                    "descActividad" => mb_substr(trim($empresa['gir_nombre']),0, 150,"UTF-8"),
                    "direccion" => array(
                        "departamento" => ($empresa['dep_codigo_fact_elect'] != "") ? $empresa['dep_codigo_fact_elect'] : $empresa['dep_codigo'],
                        "municipio" => ($empresa['mun_codigo_fact_elect'] != "") ? $empresa['mun_codigo_fact_elect'] : $empresa['mun_codigo'],
                        "complemento" => mb_substr(trim($empresa['emr_direccion']),0, 200,"UTF-8")
                    ),
                    "telefono" => str_replace('-', '', $empresa['emr_telefono']),
                    "codEstableMH" => null,// CODIGO DEL ESTABLECIMIETO
                    "codEstable" => null,
                    "codPuntoVentaMH" => null,// CODIGO DEL PUNTO DE VENTA
                    "codPuntoVenta" => null, 
                    "correo" => $empresa['emr_correo']
                ),
                "sujetoExcluido" => array(
                    "tipoDocumento" => ($nitduicod != "") ? $nitduicod :"37",
                    "numDocumento" => ($nitduinum != "") ? str_replace('-', '', $nitduinum) : "N/D",
                    "nombre" => mb_substr(trim($receptnom),0, 250,"UTF-8"), 
                    "codActividad" => ($prv_document['gir_codigo_fact_elect'] != "") ? $prv_document['gir_codigo_fact_elect'] : null,
                    "descActividad" => ($prv_document['gir_codigo_fact_elect'] != "") ? $prv_document['gir_nombre'] : null,
                    "direccion" => array(
                        "departamento" => ($prv_document['dep_codigo_fact_elect'] != "") ? $prv_document['dep_codigo_fact_elect'] : $prv_document['dep_codigo'],
                        "municipio" => ($prv_document['mun_codigo_fact_elect'] != "") ? $prv_document['mun_codigo_fact_elect'] : $prv_document['mun_codigo'],
                        "complemento" => (trim($prv_document['prv_direccion']) != "") ? mb_substr(trim($prv_document['prv_direccion']),0, 200,"UTF-8") : "N/D",
                    ),
                    "telefono" => ($prv_document['telefono'] !=  "") ? str_replace('-', '',  $prv_document['telefono']) : null,
                    "correo" => (trim($prv_document['correo']) != "") ? trim($prv_document['correo']) : "N@GMAIL.COM"
                ),
                "cuerpoDocumento" => $cuerpo,
                "resumen" => array(
                    "totalCompra" => round(($prv_document['dpv_subtotal'] + $prv_document['dpv_descuento']), 2), //suma de (cant*precio)
                    "descu" => round($prv_document['dpv_descuento'], 2),
                    "totalDescu" => round($prv_document['dpv_descuento'], 2),
                    "subTotal" => round($prv_document['dpv_subtotal'], 2), //el subtotal ya trae descontado el descutno
                    "ivaRete1" => round($prv_document['iva_retenido'], 2),
                    "reteRenta" => round($prv_document['retenido_renta10'], 2), 
                    "totalPagar"  => round($prv_document['dpv_total'], 2),
                    "totalLetras" => mb_strtoupper(mb_substr($total_letras, 0, 200 ,"UTF-8"), 'UTF-8'),
                    "condicionOperacion" => 2,// ($prv_document['condicion_operacion'] != "") ? $prv_document['condicion_operacion'] : 2, //por defeco credito para no detallar pagos
                    "observaciones" => ($prv_document['dpv_observacion'] != "") ? $prv_document['dpv_observacion']: null,
                    // "pagos" => $pagos ,
                    "pagos" => $pagos,
                ),
                "apendice" => array(
                    array(
                        "campo" => "DteNombre",
                        "etiqueta" => "Nombre Documento",
                        "valor" => "Factura Sujeto Excluido Electrónico"
                    ),
                    array(
                        "campo" => "CorrelativoInterno",
                        "etiqueta" => "Correlativo Interno",
                        "valor" => $prv_document['dpv_numero_documento']
                    )
                )
            );
            if (trim($nombre_sucursal) != "") {
                $response["apendice"][] = array(
                    "campo" => "SucNombre",
                    "etiqueta" => "Nombre Sucursal",
                    "valor" => $nombre_sucursal
                );
            }
            $json = json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            return $this->gsatelite->actualizar_array('dpv_documento_proveedor', array('dpv_json_factura_electronica' => $json), array('dpv_id' => $dpv_id));
        } else {
            return 0;
        }
    }

    public function envio_sujeto_excluido($dpv_id=''){
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $dpv_row = $this->gsatelite->get_registro('dpv_documento_proveedor',  array('dpv_id' => $dpv_id));
        if ($dpv_row->dpv_id_tif == $tipo_factura["SUJETO EXCLUIDO"] ) {
            $response = "";
            $arr_json = array();
            $dato_api = json_decode($this->gsatelite->get_parametro('API_KEY_FACTURACION_SAT'), true);
            $caja_defecto = $this->gsatelite->get_parametro_emp('SYS_CAJA_FACTURACION_ELECTRONICA_MIGRADAS', 0);
            $cajaenvio = ($dpv_row->dpv_id_caja_factura_electronica > 0) ? $dpv_row->dpv_id_caja_factura_electronica : $caja_defecto;
            if (trim($dato_api["URL"]) != "" && $cajaenvio > 0) {
                $suc_code = $this->facturacion_model->get_suc_code_json_compras($cajaenvio);
                $dpv = $this->facturacion_model->get_doc_dte_compra($dpv_id)[0];
                $arr_json["auditoria"] = array(
                    "tipo" => 0, //0=ind - 1=bloque
                    "sucursal" => $suc_code,
                    "tipoDte" => "14",
                    "usu_creacion" => $this->tank_auth->get_user_id(),
                    "usu_modificacion" => $this->tank_auth->get_user_id(),
                    "fecha_creacion"  => date('Y-m-d H:i:s'),
                    "fecha_modificacion" => date('Y-m-d H:i:s'),
                    "estado" => 1
                );
                $arr_json["json"] = array(json_decode($dpv['dpv_json_factura_electronica'], true));
                $json = json_encode($arr_json, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                $cliente_key = (isset($dato_api["kEY_CLIENTE"]) && trim($dato_api["kEY_CLIENTE"]) != "") ? trim($dato_api["kEY_CLIENTE"]) : "1q2w3e4r5t6y7u8i9o1q2w3e4r5t6y7u8i9o1q2w3e";
                if ($dpv_row->dpv_sello_recepcion == "") {
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => $dato_api["URL"],
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        CURLOPT_POSTFIELDS => $json,
                        CURLOPT_HTTPHEADER => array(
                            "X-API-Version: 1",
                            "Authorization: $cliente_key",
                            "Content-Type: application/json",
                            "X-API-Key: test_sk_de5302a4-8360-4c90-9f5a-e63aa6efd424"
                        ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);
                    $ans_arr = json_decode($response, true);
                    if (isset($ans_arr['status']) && $ans_arr['status'] != '') {
                        if (isset($ans_arr['body']['ID'])) {
                            $actualiza = array(
                                'dpv_numero_electronico_interno' => $ans_arr['body']['ID'],
                                'dpv_observaciones_factura_electronica' => $ans_arr['body']['mensage']
                            );
                        } else {
