<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Inicio extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('inventario_model');
        $this->load->model('compras_model');
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->library('excel/excel_reader.php');
    }
    
    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function tareas_pendientes($consulta=0){
        satelite_validar();
        if($_POST){
            if($consulta!=0){
                $post_array = $_POST;

                $tipo_solicitud = $post_array['tipo'];
                $where_general  = array('requisiciones', 'ordenes');
                $estado         = ($post_array['estado'] != '') ? $post_array['estado'] : null;
                $fecha_inicio   = ($post_array['fecha_ini'] != '') ? $post_array['fecha_ini'] : null;
                $fecha_fin      = ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
                $slc_sucursal   = ($post_array['slc_sucursal'] != '') ? $post_array['slc_sucursal'] : null;
                $estado         = implode(",",$estado); 

                if ($estado != null) {
                    $where_general['requisiciones']['rxi_estado IN ('.$estado.')']   = NULL;
                    $where_general['ordenes']['orc_estado IN ('.$estado.')']         = NULL;
                    $where_general['comparativo']['ccc_estado IN ('.$estado.')']     = NULL;
                } else {
                    //temporal
                    $where_general['requisiciones']["rxi_estado NOT IN (1,6)"]  = NULL;
                    $where_general['ordenes']["orc_estado NOT IN (1,6)"]        = NULL;
                    $where_general['comparativo']['ccc_estado NOT IN (1,6)']    = NULL;
                }

                if ($fecha_inicio != null && $fecha_fin != null) {
                    $where_general['requisiciones']['DATE(rxi_fecha) >=']   = date('Y-m-d', strtotime($fecha_inicio));
                    $where_general['requisiciones']['DATE(rxi_fecha) <=']   = date('Y-m-d', strtotime($fecha_fin));

                    $where_general['ordenes']['DATE(orc_fecha_orden) >=']   = date('Y-m-d', strtotime($fecha_inicio));
                    $where_general['ordenes']['DATE(orc_fecha_orden) <=']   = date('Y-m-d', strtotime($fecha_fin));

                    $where_general['comparativo']['DATE(ccc_fecha) >=']     = date('Y-m-d', strtotime($fecha_inicio));
                    $where_general['comparativo']['DATE(ccc_fecha) <=']     = date('Y-m-d', strtotime($fecha_fin));
                }
                
                if ($slc_sucursal != '' or $slc_sucursal != null) {
                    $where_general['requisiciones']["rxi_id_usu_solicita IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                    $where_general['ordenes']["orc_id_usu_solicita IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp  WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                    $where_general['comparativo']["ccc_id_usu_crea IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp  WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                }   

                $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                $flujos_array = json_decode($flujos, true);

                $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
                $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                $permiso_rol = false;

                foreach ($mis_roles as $rol) {
                    if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                        $permiso_rol = true;
                    }
                }

                if ( $permiso_rol == false) {
                        $where_general['requisiciones']['rxi_usu_creacion']   = $this->tank_auth->get_user_id();
                        $where_general['ordenes']['orc_usu_creacion']         = $this->tank_auth->get_user_id();
                        $where_general['comparativo']['ccc_usu_creacion']     = $this->tank_auth->get_user_id();
                }  else {
                    if ($slc_sucursal != '' or $slc_sucursal != null) {
                        $where_general['requisiciones']["rxi_id_usu_solicita IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                        $where_general['ordenes']["orc_id_usu_solicita IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp  WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                        $where_general['comparativo']["ccc_id_usu_crea IN (SELECT id FROM users usu_solicita JOIN emp_empleado emp_solicita ON emp_solicita.emp_id = usu_solicita.usu_id_emp  WHERE emp_solicita.emp_id_suc = $slc_sucursal )"] = null;
                    }
                }
                
                $where_general['requisiciones']['id']               = $this->tank_auth->get_user_id();
                $where_general['ordenes']['id']                     = $this->tank_auth->get_user_id();
                $where_general['comparativo']['id']                 = $this->tank_auth->get_user_id();
                $where_general['requisiciones']['flu_id']           = $flujos_array['REQ_COMP'];
                $where_general['requisiciones']['sgr_fecha_salida'] = null;
                $where_general['ordenes']['sgo_fecha_salida']       = null;
                $where_general['comparativo']['scm_fecha_salida']   = null;

                $backlog = $this->compras_model->get_backlog_compras($where_general,$tipo_solicitud);   
                // print_r($this->db->last_query());die();           
                $data['listado'] = $backlog;

                $html = $this->load->view('modulo_compras/inicio/consultar_tareas', $data, true);

                echo $html;
                die();
            }
        } else {
            /*
            busqueda no es necesaria ya que el jquery realiza un nueva peticion
            
            $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array   = json_decode($flujos, true);
            $estado         = '2,4';
            $where_general['requisiciones']['flu_id']           = $flujos_array['REQ_COMP'];
            $where_general['requisiciones']['id']               = $this->tank_auth->get_user_id();
            $where_general['requisiciones']['sgr_fecha_salida'] = null;

            $where_general['ordenes']['id']                 = $this->tank_auth->get_user_id();
            $where_general['ordenes']['sgo_fecha_salida']   = null;           

            $where_general['requisiciones']['rxi_estado IN ('.$estado.')']   = NULL;
            $where_general['ordenes']['orc_estado IN ('.$estado.')']         = NULL;
            $where_general['comparativo']['ccc_estado IN ('.$estado.')']     = NULL;

            //$backlog                = $this->compras_model->get_backlog_compras($where_general);
            //$data2['listado']       = $backlog;*/
            $html                   = "";//$this->load->view('modulo_compras/inicio/consultar_tareas', $data2, true);
            $empleado               = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$this->tank_auth->get_user_id()));
            $sucursal_dropdown      = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', $empleado[0]['emp_id_suc'], '', 'suc_id', true);
            $data['sucursales']     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_dropdown);
            $data['html']           = $html;
            $data['titulo_personal']= "Aprobaciones";
            $this->_cargarvista($data);
        }
    }
    
    /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra.
     */
    function finalizar_paso($iframe = false,$registro,$tipo_flujo){
        
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $post_array = $_POST;
                $paso_actual = $post_array['hdnActualPaso'];
                $paso_siguiente = $post_array['hdnSigPaso'];
                $txtComentario = $post_array['txtComentario'];
                
                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_requisicion = array(
                            'sgr_id_usu' => $this->tank_auth->get_user_id(),
                            'sgr_observacion' => $txtComentario,
                            'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion,array('sgr_id'=>$paso_actual));
                        
                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $registro,
                                'sgr_id_psf' => $paso_siguiente,
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                            
                            if($seguimiento > 0 ){
                                
                            }
                        }
                        break;
                    case 2:
                        //Se cierra el paso actual
                        $seguimiento_array = array(
                            'sgo_id_usu' => $this->tank_auth->get_user_id(),
                            'sgo_observacion' => $txtComentario,
                            'sgo_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgo_seguimiento_orden', $seguimiento_array, array('sgo_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $seguimiento_array = array(
                                'sgo_id_orc' => $registro,
                                'sgo_id_psf' => $paso_siguiente,
                                'sgo_id_usu' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgo_estado' => 1,
                                'sgo_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_array);
                        }
                        break;
                }
                
                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }
                else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal'] = "Siguiente Paso";
            $data['iframe'] = $iframe;
            $data['registro'] = $registro;
            $data['tipo_flujo'] = $tipo_flujo;
            
            switch ($tipo_flujo) {
                 case 1:
                     $data['nombre_registro'] = $this->gsatelite->get_campo('rxi_requisicion_inventario','rxi_numero',array('rxi_id'=>$registro));
                     $data['titulo_registro'] = "Requisición N.";
                     break;
                case 2:
                    $data['nombre_registro'] = $this->gsatelite->get_campo('orc_orden_compra', 'orc_numero', array('orc_id' => $registro));
                    $data['titulo_registro'] = "Orden de Compra N.";
                    break;
            }
            
            $paso_actual = $this->inventario_model->get_paso_actual($registro,$tipo_flujo);
            $paso_siguiente = $this->inventario_model->get_paso_siguiente($registro,$tipo_flujo);
            $data['paso_actual'] = $paso_actual[0];
            $data['paso_siguiente'] = $paso_siguiente[0];
            
            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('modulo_compras/inicio/finalizar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }
    
    function autorizar_paso($iframe = false, $registro, $tipo_flujo){        
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $post_array     = $_POST;
                $paso_actual    = $post_array['hdnActualPaso'];
                $paso_siguiente = $post_array['hdnSigPaso'];
                $txtComentario  = $post_array['txtComentario'];
                
                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_requisicion = array(
                            'sgr_id_usu' => $this->tank_auth->get_user_id(),
                            'sgr_observacion' => $txtComentario,
                            'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $registro,
                                'sgr_id_psf' => $paso_siguiente,
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);

                        }

                        //Se actualiza el estado del registro
                        $this->cambiar_estado_registro($registro, $tipo_flujo, 3);
                        break;
                    case 2:
                        //Se cierra el paso actual
                        $seguimiento_array = array(
                            'sgo_id_usu' => $this->tank_auth->get_user_id(),
                            'sgo_observacion' => $txtComentario,
                            'sgo_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgo_seguimiento_orden', $seguimiento_array, array('sgo_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $seguimiento_array = array(
                                'sgo_id_orc' => $registro,
                                'sgo_id_psf' => $paso_siguiente,
                                'sgo_id_usu' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgo_estado' => 1,
                                'sgo_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_array);

                        }
                        
                        //Se actualiza el estado del registro
                        $this->cambiar_estado_registro($registro, $tipo_flujo, 3);
                        break;
                    case 4:
                        //Se cierra el paso actual
                        $scm_seguimiento_comparativo_compra = array(
                            'scm_id_usu'            => $this->tank_auth->get_user_id(),
                            'scm_observacion'       => $txtComentario,
                            'scm_fecha_salida'      => date('Y-m-d H:i:s'),
                            'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );
                        $this->gsatelite->actualizar_array('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra, array('scm_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $scm_seguimiento_comparativo_compra = array(
                                'scm_id_ccc'            => $registro,
                                'scm_id_psf'            => $paso_siguiente,
                                'scm_id_usu'            => $this->tank_auth->get_user_id(),
                                'scm_fecha_entrada'     => date('Y-m-d H:i:s'),
                                'scm_estado'            => 1,
                                'scm_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'scm_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra);
                        }

                        //Se actualiza el estado del registro
                        $this->cambiar_estado_registro($registro, $tipo_flujo, 3);

                        break;
                }

                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }
                else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal'] = "Autorizar";
            $data['iframe'] = $iframe;
            $data['registro'] = $registro;
            $data['tipo_flujo'] = $tipo_flujo;
            $paso_actual = $this->compras_model->get_paso_actual($registro,$tipo_flujo);
            $paso_siguiente = $this->compras_model->get_paso_siguiente($registro,$tipo_flujo);
            $data['paso_actual'] = $paso_actual[0];
            $data['paso_siguiente'] = $paso_siguiente[0];            
            switch ($tipo_flujo) {
                case 1:
                    $data['paso_actual_id'] =  $paso_actual[0]['sgr_id'];
                    $data['nombre_registro'] = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_numero', array('rxi_id' => $registro));
                    $data['titulo_registro'] = "Requisición N.";
                    break;
                case 2:
                    $data['paso_actual_id'] =  $paso_actual[0]['sgo_id'];
                    $data['nombre_registro'] = $this->gsatelite->get_campo('orc_orden_compra', 'orc_numero', array('orc_id' => $registro));
                    $data['titulo_registro'] = "Orden de Compra N.";
                    break;
                case 4:
                    $data['paso_actual_id'] =  $paso_actual[0]['scm_id'];
                    $this->db->join('rxi_requisicion_inventario','rxi_id = ccc_id_rxi');
                    $data['nombre_registro'] = $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'rxi_numero', array('ccc_id' => $registro));
                    $data['titulo_registro'] = "Comparativo de requisición N.";
                    break;
            }            
            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('modulo_compras/inicio/autorizar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }
    
    function regresar_paso($iframe = false, $registro, $tipo_flujo){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $post_array     = $_POST;
                $paso_actual    = $post_array['hdnActualPaso'];
                $paso_anterior  = $post_array['hdnAntPaso'];
                $txtComentario  = $post_array['txtComentario'];
                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_requisicion = array(
                            'sgr_id_usu' => $this->tank_auth->get_user_id(),
                            'sgr_observacion' => $txtComentario,
                            'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));

                        //Si existe un paso Anterior se ingresa
                        if ($paso_anterior > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $registro,
                                'sgr_id_psf' => $paso_anterior,
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                        }

                        //Se actualiza el estado del registro
                        $resultado = $this->cambiar_estado_registro($registro, $tipo_flujo, 4);
                        break;

                    case 2:
                        //Se cierra el paso actual
                        $seguimiento_array = array(
                            'sgo_id_usu' => $this->tank_auth->get_user_id(),
                            'sgo_observacion' => $txtComentario,
                            'sgo_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgo_seguimiento_orden', $seguimiento_array, array('sgo_id' => $paso_actual));

                        //Si existe un siguiente paso se ingresa
                        if ($paso_anterior > 0) {
                            $seguimiento_array = array(
                                'sgo_id_orc' => $registro,
                                'sgo_id_psf' => $paso_anterior,
                                'sgo_id_usu' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgo_estado' => 1,
                                'sgo_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_array);
                        }

                        //Se actualiza el estado del registro
                        $this->cambiar_estado_registro($registro, $tipo_flujo, 4);
                        break;
                    case 4:
                        //Se cierra el paso actual
                        $scm_seguimiento_comparativo_compra = array(
                            'scm_id_usu'            => $this->tank_auth->get_user_id(),
                            'scm_observacion'       => $txtComentario,
                            'scm_fecha_salida'      => date('Y-m-d H:i:s'),
                            'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );
                        
                        $this->gsatelite->actualizar_array('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra, array('scm_id' => $paso_actual));

                        //Si existe un paso Anterior se ingresa
                        if ($paso_anterior > 0) {
                            $scm_seguimiento_comparativo_compra = array(
                                'scm_id_ccc'            => $registro,
                                'scm_id_psf'            => $paso_anterior,
                                'scm_id_usu'            => $this->tank_auth->get_user_id(),
                                'scm_fecha_entrada'     => date('Y-m-d H:i:s'),
                                'scm_estado'            => 1,
                                'scm_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'scm_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra);
                        }

                        //Se actualiza el estado del registro
                        $resultado = $this->cambiar_estado_registro($registro, $tipo_flujo, 4);
                        break;

                }

                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal']= "Regresar(Rechazar)";
            $data['iframe']         = $iframe;
            $data['registro']       = $registro;
            $data['tipo_flujo']     = $tipo_flujo;            
            $paso_actual            = $this->compras_model->get_paso_actual($registro,$tipo_flujo);
            $paso_anterior          = $this->compras_model->get_paso_anterior($registro,$tipo_flujo);
            $data['paso_actual']    = $paso_actual[0];
            $data['paso_anterior']  = $paso_anterior[0]['psf_id'];
            $data['slct_paso_ant']  = $paso_anterior;
            switch ($tipo_flujo) {
                case 1:
                    $data['paso_actual_id'] =  $paso_actual[0]['sgr_id'];
                    $data['nombre_registro'] = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_numero', array('rxi_id' => $registro));
                    $data['titulo_registro'] = "Requisición N.";
                    break;
                case 2:
                    $data['paso_actual_id'] =  $paso_actual[0]['sgo_id'];
                    $data['nombre_registro'] = $this->gsatelite->get_campo('orc_orden_compra', 'orc_numero', array('orc_id' => $registro));
                    $data['titulo_registro'] = "Orden de Compra N.";
                    break;
                case 4:
                    $data['paso_actual_id'] =  $paso_actual[0]['scm_id'];
                    $this->db->join('rxi_requisicion_inventario','rxi_id = ccc_id_rxi');
                    $data['nombre_registro'] = $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'rxi_numero', array('ccc_id' => $registro));
                    $data['titulo_registro'] = "Comparativo de Requisición N.";
                    break;
            }
            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('modulo_compras/inicio/regresar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }
    
    
    function historial_pasos($iframe = 0, $registro = null, $tipo_flujo = null){
        satelite_validar();

        $data['iframe'] = $iframe;
        $data['registro'] = $registro;
        $data['tipo_flujo'] = $tipo_flujo;
        
        $historial = $this->compras_model->get_historial_paso($registro,$tipo_flujo);
        $data['historial'] = $historial;

        $this->gsatelite->cargar_vista_masterpage('modulo_compras/inicio/historial_pasos', $data, true);
    }
    
    function cambiar_estado_registro($registro,$tipoFlujo,$estado){
        
        $registro_array = array();
        $tabla = "";
        $where = null;
        //Se modifica el estado en base al tipo de flujo.
        switch ($tipoFlujo) {
            case 1: 
                
                $registro_array['rxi_estado']               = $estado;
                $registro_array['rxi_usu_modificacion']     = $this->tank_auth->get_user_id();
                $registro_array['rxi_fecha_modificacion']   = date('Y-m-d H:i:s');
                $registro_array['rxi_id_usu_aprueba']       = $this->tank_auth->get_user_id();
                $tabla = "rxi_requisicion_inventario";
                $where = array('rxi_id'=>$registro);
                break;
            case 2: 
                
                $registro_array['orc_estado']               = $estado;
                $registro_array['orc_usu_modificacion']     = $this->tank_auth->get_user_id();
                $registro_array['orc_fecha_modificacion']   = date('Y-m-d H:i:s');
                $registro_array['orc_id_usu_aprueba']       = $this->tank_auth->get_user_id();
                $tabla = "orc_orden_compra";
                $where = array('orc_id'=>$registro);
                break;
            case 4: 
                
                $registro_array['ccc_estado']               = $estado;
                $registro_array['ccc_usu_modificacion']     = $this->tank_auth->get_user_id();
                $registro_array['ccc_fecha_modificacion']   = date('Y-m-d H:i:s');
                $registro_array['ccc_id_usu_autoriza']      = $this->tank_auth->get_user_id();
                $tabla  = "ccc_comparativo_cotizacion_compra";
                $where  = array('ccc_id'=>$registro);
                break;                
        }
        
        if(count($registro_array)>0 && $tabla!='' && $where!=null){
            $resultado = $this->gsatelite->actualizar_array($tabla,$registro_array,$where);
        }

        return $resultado;
    }
    
    function _cargarvista($data = 0, $crud = 0){
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
}