<?php if (!defined('BASEPATH'))exit('No direct script access allowed');
class Configuracion extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('inventario_model');
        //$this->load->library('encode');
        $this->load->library('grocery_CRUD');
        $this->load->library('session');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Configuracion";
            $this->_cargarvista($data);
        }
    }

    function flujos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion('inventario/configuracion/flujos');

            $crud = new grocery_CRUD();

            $crud->set_table('flu_flujo');
            $crud->set_subject('');
            $columns = array(
                'flu_nombre',
                'flu_descripcion',
                'flu_estado',
            );

            $display_as = array(
                'flu_nombre' => 'Nombre',
                'flu_descripcion' => 'Descripción',
                'flu_estado' => 'Estado',
            );

            $crud->columns($columns)
                    ->display_as($display_as)
                    ->unset_export()
                    ->unset_print()
                    ->unset_add()
                    ->unset_edit()
            ;

            $crud->field_type('flu_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));

            if ($permisos['permite_editar']) {
                $crud->add_action('&nbsp;Editar', '', 'modulo_compras/configuracion/editar_flujo', 'icon16 icomoon-icon-pencil-5');
            }
            $crud->add_action('&nbsp;Pasos por flujo', '', 'modulo_compras/configuracion/pasos_flujo', 'icomoon-icon-forward');

            //if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
            //}
            $output = $crud->render();
            $data['permisos'] = $permisos;
            $data['titulo_personal'] = 'Flujo de trabajo';
            $this->_cargarvista($data, $output);
        }
    }

    function agregar_flujo() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST['nombre_flujo']) {
                //var_dump($_POST);die();

                $nombre = $this->input->post('nombre_flujo');
                $descripcion = $this->input->post('descripcion_flujo');
                $tipo_btn = $this->input->post('tipo_btn');

                $flujo_array = array(
                    'flu_nombre' => $nombre,
                    'flu_descripcion' => $descripcion,
                    'flu_estado' => 1,
                    'flu_usu_creacion' => $this->tank_auth->get_user_id(),
                    'flu_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'flu_fecha_creacion' => date('Y-m-d H:i:s'),
                    'flu_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $flu_id = $this->gsatelite->ingresar('flu_flujo', $flujo_array);

                if ($flu_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Proceso realizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/configuracion/agregar_flujo');
                } else if ($tipo_btn == 2) {
                    redirect('modulo_compras/configuracion/flujos');
                }
            }


            $data['titulo_personal'] = "Agregar Flujo de trabajo";
            $this->_cargarvista($data);
        }
    }

    function editar_flujo($flu_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //var_dump($_POST);die();

                $nombre = $this->input->post('nombre_flujo');
                $descripcion = $this->input->post('descripcion_flujo');
                $estado = ($this->input->post('estado') == 2) ? 0 : 1;
                $tipo_btn = $this->input->post('tipo_btn');

                $flujo_array = array(
                    'flu_nombre' => $nombre,
                    'flu_descripcion' => $descripcion,
                    'flu_estado' => $estado,
                    'flu_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'flu_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                $where = array('flu_id' => $flu_id);
                $result = $this->gsatelite->actualizar_array('flu_flujo', $flujo_array, $where);

                if ($result > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "Proceso realizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/configuracion/editar_flujo/' . $flu_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_compras/configuracion/flujos');
                }
            }

            if ($flu_id == null) {
                redirect('/auth/login/');
            }
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));

            $data['titulo_personal'] = "Editar Flujo de trabajo";
            $this->_cargarvista($data);
        }
    }

    function validar_nombre_flujo($flu_nombre = null, $flu_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $flu_nombre = $this->input->post('nombre');
                $flu_id = $this->input->post('flujo');
            }

            if ($flu_id != null && $flu_id != '') {
                $where = "flu_nombre = '" . $flu_nombre . "' AND flu_id <> " . $flu_id;

                $count = $this->gsatelite->count('flu_flujo', $where);
            } else {
                $where = array('flu_nombre' => $flu_nombre);

                $count = $this->gsatelite->count('flu_flujo', $where);
            }


            if ($_POST) {
                if ($count > 0) {
                    echo json_encode(array('existe' => 1));
                } else {
                    echo json_encode(array('existe' => 0));
                }
            } else {
                if ($count > 0) {
                    return false;
                } else {
                    return true;
                }
            }
        }
    }

    function pasos_flujo($flu_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($flu_id == null) {
                redirect('/auth/login/');
            }

            //$permisos = $this->gsatelite->get_permisos_opcion('pasos_flujo');

            $crud = new grocery_CRUD();

            $crud->set_table('psf_paso_flujo');
            $crud->set_subject('');

            $columns = array(
                'psf_orden',
                'psf_nombre',
                'psf_descripcion',
                'psf_estado',
            );

            $display_as = array(
                'psf_orden' => 'Orden',
                'psf_nombre' => 'Etapa',
                'psf_descripcion' => 'Descripción',
                'psf_estado' => 'Estado',
            );


            $crud->columns($columns)
                    ->display_as($display_as)
                    ->unset_export()
                    ->unset_print()
                    ->unset_add()
                    ->unset_edit()
                    ->where('psf_id_flu', $flu_id)
                    ->order_by('psf_orden', 'asc')
                    ->field_type('psf_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'))
            ;

            $crud->add_action('&nbsp;Editar', '', 'modulo_compras/configuracion/editar_paso/' . $flu_id, 'icon16 icomoon-icon-pencil-5');
            $crud->add_action('&nbsp;Roles', '', 'modulo_compras/configuracion/roles_paso', 'icomoon-icon-users');

            $output = $crud->render();
            //$data['permisos'] = $permisos;
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $data['titulo_personal'] = 'Flujo ' . $data['flujo'][0]['flu_nombre'] . " - Pasos por flujo";

            $this->_cargarvista($data, $output);
        }
    }

    function agregar_paso($flu_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($flu_id == null) {
                redirect('/auth/login/');
            }
            if (isset($_POST['nombre_paso'])) {
                //var_dump($_POST);die();

                $nombre_paso = trim($this->input->post('nombre_paso'));
                $orden = $this->input->post('orden_paso');
                $siguiente_paso = $this->input->post('siguiente_paso');
                $obligatorio = $this->input->post('obligatorio');
                $area = $this->input->post('area');
                $descripcion = $this->input->post('descripcion_paso');
                $tipo_btn = $this->input->post('tipo_btn');
                $aplica_firma = ($this->input->post('firma_check') != '')? $this->input->post('firma_check') : 0;
                $enunciado_firma = ($this->input->post('titulofirma_paso') != '')? $this->input->post('titulofirma_paso') : null;

                $paso_array = array(
                    'psf_id_flu' => $flu_id,
                    'psf_nombre' => $nombre_paso,
                    'psf_descripcion' => $descripcion,
                    'psf_obligatorio' => $obligatorio,
                    'psf_orden' => $orden,
                    'psf_paso_siguiente' => $siguiente_paso,
                    'psf_area' => $area,
                    'psf_aplica_firma' => $aplica_firma,
                    'psf_enunciado_firma' => $enunciado_firma,
                    'psf_estado' => 1,
                    'psf_usu_creacion' => $this->tank_auth->get_user_id(),
                    'psf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'psf_fecha_creacion' => date('Y-m-d H:i:s'),
                    'psf_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                /*print_r($paso_array);die();*/
                $psf_id = $this->gsatelite->ingresar('psf_paso_flujo', $paso_array);

                if ($psf_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Proceso realizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/configuracion/agregar_paso/' . $flu_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_compras/configuracion/pasos_flujo/' . $flu_id);
                }
            }
            $data['titulo_personal'] = 'Agregar paso';
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $this->_cargarvista($data);
        }
    }

    function editar_paso($flu_id = null, $psf_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($flu_id == null || $psf_id == null) {
                redirect('/auth/login/');
            }
            if (isset($_POST['nombre_paso'])) {
                //var_dump($_POST);die();

                $nombre_paso = trim($this->input->post('nombre_paso'));
                $orden = $this->input->post('orden_paso');
                $obligatorio = $this->input->post('obligatorio');
                $siguiente_paso = $this->input->post('siguiente_paso');
                $area = $this->input->post('area');
                $descripcion = $this->input->post('descripcion_paso');
                $estado = ($this->input->post('estado') == 2) ? 0 : 1;
                $tipo_btn = $this->input->post('tipo_btn');
                $aplica_firma = ($this->input->post('firma_check') != '')? $this->input->post('firma_check') : 0;
                $enunciado_firma = ($this->input->post('titulofirma_paso') != '' and $this->input->post('firma_check') > 0)? $this->input->post('titulofirma_paso') : null;

                $paso_array = array(
                    'psf_nombre' => $nombre_paso,
                    'psf_descripcion' => $descripcion,
                    'psf_obligatorio' => $obligatorio,
                    'psf_orden' => $orden,
                    'psf_paso_siguiente' => $siguiente_paso,
                    'psf_area' => $area,
                    'psf_aplica_firma' => $aplica_firma,
                    'psf_enunciado_firma' => $enunciado_firma,
                    'psf_estado' => $estado,
                    'psf_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'psf_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                $where = array('psf_id' => $psf_id);
                $result = $this->gsatelite->actualizar_array('psf_paso_flujo', $paso_array, $where);

                if ($result > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "Proceso actualizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/configuracion/editar_paso/' . $flu_id . '/' . $psf_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_compras/configuracion/pasos_flujo/' . $flu_id);
                }
            }
            $data['titulo_personal'] = 'Editar paso';
            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));
            $this->_cargarvista($data);
        }
    }

    function acciones() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion('inventario/configuracion/acciones');

            $crud = new grocery_CRUD();

            $crud->set_table('acc_accion');
            $crud->set_subject('');

            $columns = array(
                'acc_nombre',
                'acc_icono',
                'acc_url',
                'acc_estado',
            );

            $required = array(
                'acc_nombre',
                'acc_icono',
                'acc_url',
                'acc_estado',
            );

            $display_as = array(
                'acc_nombre' => 'Nombre',
                'acc_icono' => 'Icono',
                'acc_url' => 'Url',
                'acc_estado' => 'Estado',
            );

            $add_fields = array(
                'acc_nombre',
                'acc_url',
                'Flujo',
                'acc_icono',
                'acc_estado',
                'acc_usu_creacion',
                'acc_usu_modificacion',
                'acc_fecha_creacion',
                'acc_fecha_modificacion'
            );

            $edit_fields = array(
                'acc_nombre',
                'acc_url',
                'Flujo',
                'acc_icono',
                'acc_estado',
                'acc_usu_modificacion',
                'acc_fecha_modificacion'
            );

            $auditoria_acciones = array(
                'axf_estado' => 1,
                'axf_usu_creacion' => $this->tank_auth->get_user_id(),
                'axf_usu_modificacion' => $this->tank_auth->get_user_id(),
                'axf_fecha_modificacion' => date('Y-m-d H:i:s'),
                'axf_fecha_creacion' => date('Y-m-d H:i:s')
            );

            $crud->columns($columns)
                    ->display_as($display_as)
                    ->unset_export()
                    ->unset_print()
                    ->set_rules('acc_nombre', 'Nombre', 'required|campo_unico[acc_accion.acc_nombre]')
                    ->set_rules('acc_icono', 'Icono', 'required')
                    ->required_fields($required)
                    ->add_fields($add_fields)
                    ->edit_fields($edit_fields)
                ->set_relation_n_n('Flujo', 'axf_accionesxflujo', 'flu_flujo', 'axf_id_acc', 'axf_id_flu', 'flu_nombre', null, array('flu_estado' => 1), $auditoria_acciones)
                    ->set_field_upload('acc_icono', 'uploads/anx_acciones')
                    ->field_type('acc_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'))
                    ->field_type('acc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('acc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('acc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('acc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ;

            $this->load->config('grocery_crud');
            //$this->config->set_item('grocery_crud_file_upload_allow_file_types',
            //'jpeg|jpg|png');


            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            $output = $crud->render();
            $data['permisos'] = $permisos;
            $data['titulo_personal'] = "Acciones";
            //$data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $flu_id));
            $this->_cargarvista($data, $output);
        }
    }

    function roles_paso($psf_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($psf_id == null) {
                redirect('/auth/login/');
            }

            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));

            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $data['paso'][0]['psf_id_flu']));

            $data['roles'] = $this->inventario_model->get_roles_paso(array('rxp_id_psf' => $psf_id));

            $data['titulo_personal'] = 'Asociar rol a flujo de trabajo';

            $this->_cargarvista($data);
        }
    }

    function agregar_rol_paso($psf_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($psf_id == null) {
                redirect('/auth/login/');
            }

            if ($_POST) {
                //var_dump($_POST);die();

                $rol = $this->input->post('rol');
                $acciones = $this->input->post('acciones');
                $tipo_btn = $this->input->post('tipo_btn');

                $rxp_array = array(
                    'rxp_id_psf' => $psf_id,
                    'rxp_id_rol' => $rol,
                    'rxp_estado' => 1,
                    'rxp_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxp_fecha_creacion' => date('Y-m-d H:i:s'),
                    'rxp_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $rxp_id = $this->gsatelite->ingresar('rxp_rolxpaso', $rxp_array);

                if (count($acciones) > 0 && $acciones != null) {
                    for ($i = 0; $i < count($acciones); $i++) {
                        $axr_array = array(
                            'axr_id_rxp' => $rxp_id,
                            'axr_id_acc' => $acciones[$i],
                            'axr_estado' => 1,
                            'axr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axr_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $axr_id = $this->gsatelite->ingresar('axr_accionxrol_paso', $axr_array);
                    }
                }

                if ($rxp_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro procesado", 'texto_alerta' => "Proceso procesado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/configuracion/agregar_rol_paso/' . $psf_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_compras/configuracion/roles_paso/' . $psf_id);
                }
            }

            $data['roles'] = $this->gsatelite->get_dropdown('rol_rol', '{rol_nombre}', 'roles', array('rol_estado' => 1), null, null, null, true);

            $data['acciones'] = $this->gsatelite->get_dropdown('acc_accion', '{acc_nombre}', 'acciones', array('acc_estado' => 1), null, null, null, true);

            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));

            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $data['paso'][0]['psf_id_flu']));

            $data['titulo_personal'] = 'Asociar rol a flujo de trabajo';

            $this->_cargarvista($data);
        }
    }

    function editar_rol_paso($psf_id = null, $rxp_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($psf_id == null) {
                redirect('/auth/login/');
            }

            if ($_POST) {
                //var_dump($_POST);die();

                $rol = $this->input->post('rol');
                $estado = ($this->input->post('estado') == 2) ? 0 : 1;
                $acciones = $this->input->post('acciones');
                $tipo_btn = $this->input->post('tipo_btn');

                $rxp_array = array(
                    'rxp_id_rol' => $rol,
                    'rxp_estado' => $estado,
                    'rxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxp_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $where = array('rxp_id' => $rxp_id);

                $result = $this->gsatelite->actualizar_array('rxp_rolxpaso', $rxp_array, $where);

                if (count($acciones) > 0 && $acciones != null) {

                    $del = $this->gsatelite->borrado_general('axr_accionxrol_paso', array('axr_id_rxp' => $rxp_id));

                    for ($i = 0; $i < count($acciones); $i++) {
                        $axr_array = array(
                            'axr_id_rxp' => $rxp_id,
                            'axr_id_acc' => $acciones[$i],
                            'axr_estado' => 1,
                            'axr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axr_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $axr_id = $this->gsatelite->ingresar('axr_accionxrol_paso', $axr_array);
                    }
                }

                if ($result > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "Proceso actualizado con éxito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_compras/configuracion/editar_rol_paso/' . $psf_id . '/' . $rxp_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_compras/configuracion/roles_paso/' . $psf_id);
                }
            }

            $rxp_info = $this->inventario_model->get_roles_paso(array('rxp_id' => $rxp_id));

            $data['rxp_info'] = $rxp_info;

            $data['roles'] = $this->gsatelite->get_dropdown('rol_rol', '{rol_nombre}', 'roles', array('rol_estado' => 1), $rxp_info[0]['rxp_id_rol'], null, null, true);

            // $data['acciones'] = $this->gsatelite->get_dropdown('acc_accion','{acc_nombre}','acciones',array('acc_estado'=>1),null,null,null,true);

            $data['acciones'] = $this->gsatelite->get_tabla('acc_accion', array('acc_estado' => 1));

            $axr_data = $this->inventario_model->get_acciones_rol(array('axr_id_rxp' => $rxp_id));

            $data['axr_list'] = array_column($axr_data, 'axr_id_acc');

            $data['rxp_id'] = $rxp_id;

            $data['paso'] = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id' => $psf_id));

            $data['flujo'] = $this->gsatelite->get_tabla('flu_flujo', array('flu_id' => $data['paso'][0]['psf_id_flu']));

            $data['titulo_personal'] = 'Asociar rol a flujo de trabajo';

            $this->_cargarvista($data);
        }
    }

    function eliminar_rol_paso($rxp_id = null, $psf_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($rxp_id == null) {
                redirect('/auth/login/');
            } else {

                $del = $this->gsatelite->borrado_general('axr_accionxrol_paso', array('axr_id_rxp' => $rxp_id));
                $where = array('rxp_id' => $rxp_id);
                $del_rxp = $this->gsatelite->borrado_general('rxp_rolxpaso', $where);

                $this->session->set_flashdata($alerta);

                redirect('modulo_compras/configuracion/roles_paso/' . $psf_id);
            }
        }
    }

    function validar_orden_paso($psf_id = null, $orden = null, $flu_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $psf_id = $this->input->post('paso');
                $orden = $this->input->post('orden');
                $flu_id = $this->input->post('flujo');
            }

            if ($psf_id == null) {

                $where = array('psf_id_flu' => $flu_id, 'psf_orden' => $orden);

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            } else if ($psf_id != null) {

                $where = 'psf_id_flu = ' . $flu_id . ' AND psf_orden = ' . $orden . ' AND psf_id <> ' . $psf_id;

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            } else {
                
            }

            if ($_POST) {
                if ($count > 0) {
                    echo json_encode(array('existe' => 1));
                } else {
                    echo json_encode(array('existe' => 0));
                }
            } else {
                if ($count > 0) {
                    return false;
                } else {
                    return true;
                }
            }
        }
    }

    function validar_nombre_paso($psf_nombre = null, $psf_id = null, $flu_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $psf_nombre = trim($this->input->post('nombre'));
                $psf_id = $this->input->post('paso');
                $flu_id = $this->input->post('flujo');
            }

            if ($psf_id != null && $psf_id != '') {
                $where = "psf_nombre = '" . $psf_nombre . "' AND psf_id_flu = " . $flu_id . " AND psf_id <> " . $psf_id;

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            } else {
                $where = array('psf_nombre' => $psf_nombre, 'psf_id_flu' => $flu_id);

                $count = $this->gsatelite->count('psf_paso_flujo', $where);
            }


            if ($_POST) {
                if ($count > 0) {
                    echo json_encode(array('existe' => 1));
                } else {
                    echo json_encode(array('existe' => 0));
                }
            } else {
                if ($count > 0) {
                    return false;
                } else {
                    return true;
                }
            }
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}
