<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author Mario Marquez  
 * @method Controlador de Catalogos - Compras
 */
class Catalogos extends CI_Controller {

    //Constructor
    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('compras_model');
        $this->load->library('tank_auth');
    }

    function articulo() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->articulo('Catálogo de producto', 'modulo_compras', null, 'modulo_compras/catalogos');
    }

    function tipo_articulo() {
        satelite_validar();
        // $modulo = 3;
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->tipo_articulo('modulo_compras/catalogos');
    }

    public function agregar_pro_articulo() {
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->agregar_pro_articulo('modulo_compras/catalogos/agregar_pro_articulo', 'modulo_compras/catalogos/tipo_articulo');
        $data['html'] = $html;
        $this->_cargarvista($data);

        // $data['padre'] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));
        // $data['cuen_con'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
        // $data['caract'] = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
        // $data['cuentas'] = $this->gsatelite->get_tabla('cco_cuenta_contable');
        // $data['titulo_personal'] = "Gestión de categoría";
        // $this->_cargarvista($data);
    }

    public function guardar_pro_articulo() {
        satelite_validar();


        if ($_POST) {
            // die(var_dump($_POST));
            $padre = $this->input->post('padre');
            if ($padre > 0) {
                $padre = $this->input->post('padre');
            } else {
                $padre = null;
            }
            $art_array = array(
                'tia_nombre' => $this->input->post('categoria'),
                'tia_id_cco' => ($this->input->post('cuenta') > 0) ? $this->input->post('cuenta') : null,
                'tia_estado' => 1,
                'tia_padre' => $padre,
                'tia_codigo' => $this->input->post('codigo'),
            );
            //$this->db->insert('cxj_correlativoxcaja', $uxc_array);
            $respuesta = $this->db->insert('tia_tipo_articulo', $art_array);
            $art_id = $this->db->insert_id();

            $cnt1 = $this->input->post('cuen_cont_cli');
            if (!empty($cnt1)) {
                foreach ($cnt1 as $id1) {
                    $info1 = array(
                        'cxa_id_tia' => $art_id,
                        'cxa_id_cnt' => $id1,
                        'cxa_tipo' => 1,
                        'cxa_estado' => 1,
                        'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                        'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                        'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info1);
                }
            }

            $cnt2 = $this->input->post('cuen_cont_cli_2');
            foreach ($cnt2 as $id2) {
                $info2 = array(
                    'cxa_id_tia' => $art_id,
                    'cxa_id_cnt' => $id2,
                    'cxa_tipo' => 2,
                    'cxa_estado' => 1,
                    'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info2);
            }

            $cnt3 = $this->input->post('cuen_cont_cli_3');
            foreach ($cnt3 as $id3) {
                $info3 = array(
                    'cxa_id_tia' => $art_id,
                    'cxa_id_cnt' => $id3,
                    'cxa_tipo' => 3,
                    'cxa_estado' => 1,
                    'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info3);
            }

            $cnt4 = $this->input->post('cuen_cont_cli_4');
            foreach ($cnt4 as $id4) {
                $info4 = array(
                    'cxa_id_tia' => $art_id,
                    'cxa_id_cnt' => $id4,
                    'cxa_tipo' => 4,
                    'cxa_estado' => 1,
                    'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info4);
            }


            $car = $this->input->post('caracteristicas');
            foreach ($car as $id_car) {
                $info_car = array(
                    'cxr_id_car' => $id_car,
                    'cxr_id_tia' => $art_id,
                    'cxr_estado' => 1,
                    'cxr_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxr_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxr_caractxtipo_articulo', $info_car);
            }

            $rediret = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect('modulo_compras/catalogos/agregar_pro_articulo');
            } else if ($dir == 2) {
                redirect('modulo_compras/catalogos/tipo_articulo');
            }
        }
    }

    public function validar_codigo() {
        $codigo = $this->input->post('codigo');
        $code = $this->input->post('code');
        $codigos = $this->gsatelite->get_tabla('tia_tipo_articulo');
        $resp = 0;
        if ($codigo == $code) {
            echo json_encode(array('resp' => $resp));
            die();
        }
        $codigo1 = strtolower($codigo);
        foreach ($codigos as $cod) {
            $codigo_base = strtolower($cod['tia_codigo']);
            if ($codigo_base == $codigo1) {
                $resp = 1;
                echo json_encode(array('resp' => $resp));
                die();
            }
        }
        echo json_encode(array('resp' => $resp));
    }

    function editar_pro_articulo($id_tia) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->editar_pro_articulo($id_tia, 'modulo_compras/catalogos/editar_pro_articulo', 'modulo_compras/catalogos/tipo_articulo');
        $data['html'] = $html;
        $this->_cargarvista($data);
    }

    function agregar_articulo($modulo = null, $otro_modulo = null) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->agregar_articulo(13, $otro_modulo, 'modulo_compras/catalogos');
    }

    function guardar_articulo() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->guardar_articulo('modulo_compras/catalogos');
    }

    function editar_articulo($id_art) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->editar_articulo($id_art, 13, 'modulo_compras/catalogos');
    }

    function duplicar_articulo($id_art){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
       $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/articulo');
       $this->mantenimiento->duplicar_articulo($id_art,"modulo_compras/catalogos");
    }

    function precios_articulo($id_art) { 
        satelite_validar();
        $tipo = $this->input->post('slcTipo');
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->precios_articulo_new($id_art, $tipo, "modulo_compras/catalogos");
    }

    function agregar_formula($art_id) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->agregar_formula($art_id,'modulo_compras/catalogos', 'formulas_producto');   
    }

    public function formulas_producto($art_id) {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->formulas_producto($art_id, 'modulo_compras/catalogos'); 
    }

    public function gestion_impuestos() {
        satelite_validar();        
        $this->load->library('../controllers/cotizaciones/mantenimientos');                
        $this->mantenimientos->gestion_impuestos('modulo_compras/catalogos'); 
    }

    public function agregar_impuesto() {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->agregar_impuesto('modulo_compras/catalogos');
    }

    function editar_impuesto($id_impuesto, $ruta = null) {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');        
        $this->mantenimientos->editar_impuesto($id_impuesto,'modulo_compras/catalogos');
    }

    function actualizar_impuesto($id_impuesto) {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');        
        $this->mantenimientos->actualizar_impuesto($id_impuesto);
    }

    public function guardar_impuesto($ruta = null) {
        satelite_validar();
        $ruta = (trim($ruta) != '')? $ruta : 'modulo_compras/catalogos';
        
        if ($_POST) {

            $imp_array = array(
                'imp_nombre' => $this->input->post('nombre'),
                'imp_defecto' => $this->input->post('apli_defect'),
                'imp_porcentaje' => $this->input->post('porcentaje'),
                'imp_valor' => $this->input->post('valor'),
                'imp_estado' => 1,
                'imp_usu_mod' => $this->tank_auth->get_user_id(),
                'imp_fecha_mod' => date('Y-m-d h:i:s'),
            );
            $respuesta = $this->gsatelite->ingresar('imp_impuesto', $imp_array);

            $centro_costo = $this->input->post('centrosCosto');
            $cuenta_cnt = $this->input->post('cuentaContable');
            $tipo_cnt = $this->input->post('tipoCuentas');
            foreach ($cuenta_cnt as $key => $cnt) {
                $info = array(
                    'cxe_id_cnt' => $cnt,
                    'cxe_id_imp' => $respuesta,
                    'cxe_id_tcn' => $tipo_cnt[$key],
                    'cxe_id_cec' => $centro_costo[$key],
                    'cxe_tipo' => null,
                    'cxe_estado' => 1,
                    'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info);
            }

            $rediret = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect($ruta.'/agregar_impuesto');
            } else if ($dir == 2) {
                redirect($ruta.'/gestion_impuestos');
            }
        }
    }

    public function proveedores($consulta = null,$ruta_vista=null) {
        satelite_validar();
        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = (is_array($ruta_vista))? $ruta_vista[0]:'modulo_compras/catalogos/proveedores'; //cuando viene la petición de otro modulo.

        $arreglo_url = explode('/',$ruta_permisos);
        $data['ruta_permisos'] = $ruta_permisos;
        $data['modulo_url'] = $arreglo_url[0].'/'.$arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista))? $ruta_vista[1]:null;
        
       try {
            if ($consulta) {
                $post_array = $this->input->post();
                $ruta_permisos = $post_array['ruta_permisos_op'];
                $modulo_url = $post_array['modulo_url'];
                $data['ruta_editar'] = base_url(($modulo_url));

                $personeria = $post_array['personeria'];
                $actividad_eco = $post_array['actividad'];
                $data['permisos'] = $this->gsatelite->get_permisos_opcion($ruta_permisos);
                $where = null;
                if ($personeria != '') {
                    $where['prv_tipo_pers'] = $personeria;
                }
                if ($actividad_eco != '') {
                    $where['prv_id_acp'] = $actividad_eco;
                }
                $where['prv_estado'] = 1;
                $data['proveedores'] = $this->compras_model->get_proveedores($where);
                //var_dump($data['permisos']);die();
                $html = $this->load->view('modulo_compras/catalogos/consultar_proveedores', $data, true);

                echo $html;
                die();
            }
            $data['permisos'] = $this->gsatelite->get_permisos_opcion($ruta_permisos);
            $data['actividades_eco'] = $this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), null, null, null, true);
            $data['titulo_personal'] = "Mantenimiento de Proveedores";
            $this->_cargarvista($data,null,$ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function unidad_medida() {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->medida_producto('proyectos/mantenimientos/unidad_medida');
    }

    /*
     * @author: Mario Marquez
     * $referencia: 1 = Indica que la pantalla esta siendo heredada de otro modulo
     */

    public function agregar_proveedor($referencia = 0,$ruta_vista=0,$modales=null) {
        satelite_validar();
        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = ($ruta_vista != 0)? $ruta_vista[0]:'modulo_compras/catalogos/proveedores'; //cuando viene la petición de otro modulo.
        $arreglo_url = explode('/',$ruta_permisos);
        $modulo_url = $arreglo_url[0].'/'.$arreglo_url[1]; //cuando viene la petición de otro modulo.
        $data['modulo_url'] = $modulo_url;
        $ruta_vista = (is_array($ruta_vista))? $ruta_vista[1]:null;

        if ($referencia == 0) {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion($ruta_permisos, 'agregar');
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $Impuestos = $post_array['slcImpuestos'];
            $condicion = $post_array['slcCondicion'];
            //Emails
            $EmailsProv = $post_array['EmailsProv'];
            //Telefonos
            $tiposTelefonosProv = $post_array['tiposTelefonosProv'];
            $TelefonosProv = $post_array['TelefonosProv'];
            // Casificacion del proveedor
            $slcClasificacionProv = $post_array['slcClasificacionProv'];
            //Contactos
            $NombreContactos = $post_array['NombreContactos'];
            $ApellidoContactos = $post_array['ApellidoContactos'];
            $CargoContactos = $post_array['CargoContactos'];
            $TelefonoContactos = $post_array['TelefonoContactos'];
            $EmailContactos = $post_array['EmailContactos'];
            //Documentos
            $tiposDocumentos = $post_array['tiposDocumentos'];
            $NumDocumentos = $post_array['NumDocumentos'];
            $FechaVencDocumentos = $post_array['FechaVencDocumentos'];
            $FechaExpDocumentos = $post_array['FechaExpDocumentos'];
            $LugarExpDocumentos = $post_array['LugarExpDocumentos'];
            $TitulosAnexosDoc = $post_array['TitulosAnexosDoc'];
            $NombreAnexoDoc = $post_array['nombre_anexo_doc'];
            $RutaAnexoDoc = $post_array['ruta_anexo_doc'];
            //Finanzas
            $retenciones    = $post_array['slc_retenciones'];
            //Cuentas Contables
            $centrosCosto   = $post_array['centrosCosto'];
            $cuentaContable = $post_array['cuentaContable'];
            $tipoCuentas    = $post_array['tipoCuentas'];
            $tipoPago       = $post_array['tipoPago'];
            //Anexos
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];
            $esmodal = $post_array['esmodal'];
            // validacion para no duplicar el proveedor
            $existe = true;
            $doc_pv = 0;
            $cod    = $this->input->post('txtCodigo');
            //$reg    = $this->gsatelite->get_tabla('prv_proveedor',array('prv_codigo' => $cod));
            if (count($tiposDocumentos) > 0 && count($NumDocumentos) > 0) {
                for ($i = 0; $i < count($NumDocumentos); $i++) { 
                    $docu = $this->gsatelite->get_tabla('dcp_documento_proveedor',array('dcp_id_tde' => $tiposDocumentos[$i], 'dcp_valor' => $NumDocumentos[$i]));
                    if (count($docu) > 0) {
                        $doc_pv++;
                    }
                }
            }
            $existe = (!($doc_pv > 0)) ? FALSE : TRUE;
            if (!($existe)) {
                //Se recalcula el código
                $numero_proveedores = $this->gsatelite->count('prv_proveedor');
                // Codigo autogenerado
                $codigo_proveedor = generar_codigo_cor($numero_proveedores + 1);

                $proveedor_array = array(
                    'prv_id_mun' => ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null,
                    'prv_id_dis' => ($post_array['slcDistrito'] != '') ? $post_array['slcDistrito'] : null,
                    'prv_id_tap' => ($post_array['slcTamanioProv'] != '') ? $post_array['slcTamanioProv'] : null,
                    'prv_id_pai' => ($post_array['slcNacionalidad'] != '') ? $post_array['slcNacionalidad'] : null,
                    'prv_id_gir' => ($post_array['slcGiro'] != '') ? $post_array['slcGiro'] : null,
                    'prv_id_acp' => ($post_array['slcActividad'] != '') ? $post_array['slcActividad'] : null,
                    'prv_id_clp' => ($slcClasificacionProv != '') ? $slcClasificacionProv : null,
                    'prv_id_cod' => ($condicion != '') ? $condicion : null, 
                    'prv_tipo_pers' => $post_array['slcPersoneria'],
                    'prv_codigo' => ($post_array['txtCodigo'] != '') ? $post_array['txtCodigo'] : null,
                    'prv_nombre' => ($post_array['txtNombreProv'] != '') ? $post_array['txtNombreProv'] : null,
                    'prv_apellido' => ($post_array['txtApellidoProv'] != '') ? $post_array['txtApellidoProv'] : null,
                    'prv_direccion' => ($post_array['txtDireccionProv'] != '') ? $post_array['txtDireccionProv'] : null,
                    'prv_observacion' => ($post_array['txtObservacion'] != '') ? $post_array['txtObservacion'] : null,
                    'prv_representante' => ($post_array['txtRepresentante'] != '') ? $post_array['txtRepresentante'] : null,
                    'prv_fecha_registro' => ($post_array['txtFechaRegistro'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaRegistro'])) : null,
                    'prv_limite_credito' => ($post_array['txtLimite'] != '') ? $post_array['txtLimite'] : null,
                    'prv_dias_plazo' => ($post_array['txtDiasPlazo'] != '') ? $post_array['txtDiasPlazo'] : null,
                    'prv_detalle_condicion' => ($post_array['detalle_condicion'] != '') ? $post_array['detalle_condicion'] : null,
                    'prv_comentario_actividad' => ($post_array['txtComentariosAct'] != '') ? $post_array['txtComentariosAct'] : null,
                    'prv_estado' => 1,
                    'prv_usu_creacion' => $this->tank_auth->get_user_id(),
                    'prv_fecha_creacion' => date('Y-m-d H:i;s'),
                    'prv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'prv_fecha_modificacion' => date('Y-m-d H:i;s'),
                );

                $prv_id = 0;
                $reg  = $this->gsatelite->get_tabla('prv_proveedor',array('prv_codigo'=>$cod)); //preguntar si existe
                if(count($reg)<=0)
                {    
                    $prv_id = $this->gsatelite->ingresar('prv_proveedor', $proveedor_array);
                }
                else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro duplicado", 'texto_alerta' => "Duplicidad de registro detectada. (Registro no ingresado)");
                    $this->session->set_flashdata($alerta);
                    redirect("$modulo_url");
                }
                if ($prv_id > 0) {
                    //Impuestos
                    if (count($Impuestos) > 0) {
                        for ($i = 0; $i < count($Impuestos); $i++) {
                            $impuestos_array = array(
                                'ixp_id_prv' => $prv_id,
                                'ixp_id_imp' => $Impuestos[$i],
                                'ixp_estado' => 1,
                                'ixp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'ixp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'ixp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'ixp_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );
                            $this->gsatelite->ingresar('ixp_impuestoxproveedor', $impuestos_array);
                        }
                    }

                    //Correos
                    if (count($EmailsProv) > 0) {
                        for ($i = 0; $i < count($EmailsProv); $i++) {
                            $correos_array = array(
                                'cpd_id_prv' => $prv_id,
                                'cpd_correo' => $EmailsProv[$i],
                                'cpd_estado' => 1,
                                'cpd_usu_creacion' => $this->tank_auth->get_user_id(),
                                'cpd_fecha_creacion' => date('Y-m-d H:i:s'),
                                'cpd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'cpd_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );
                            $this->gsatelite->ingresar('cpd_correo_proveedor', $correos_array);
                        }
                    }


                    //Telefonos
                    if (count($tiposTelefonosProv) > 0) {
                        for ($i = 0; $i < count($tiposTelefonosProv); $i++) {
                            $telefonos_array = array(
                                'tep_id_prv' => $prv_id,
                                'tep_id_tit' => $tiposTelefonosProv[$i],
                                'tep_numero' => $TelefonosProv[$i],
                                'tep_estado' => 1,
                                'tep_usu_creacion' => $this->tank_auth->get_user_id(),
                                'tep_fecha_creacion' => date('Y-m-d H:i:s'),
                                'tep_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'tep_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );
                            $this->gsatelite->ingresar('tep_telefono_proveedor', $telefonos_array);
                        }
                    }

                    //Contactos
                    if (count($NombreContactos) > 0) {
                        for ($i = 0; $i < count($NombreContactos); $i++) {
                            $contactos_array = array(
                                'cpv_id_prv' => $prv_id,
                                'cpv_nombre' => $NombreContactos[$i],
                                'cpv_apellidos' => ($ApellidoContactos[$i] != "") ? $ApellidoContactos[$i] : null,
                                'cpv_cargo' => ($CargoContactos[$i] != "") ? $CargoContactos[$i] : null,
                                'cpv_telefono' => ($TelefonoContactos[$i] != "") ? $TelefonoContactos[$i] : null,
                                'cpv_email' => ($EmailContactos[$i] != "") ? $EmailContactos[$i] : null,
                                'cpv_estado' => 1,
                                'cpv_usu_creacion' => $this->tank_auth->get_user_id(),
                                'cpv_fecha_creacion' => date('Y-m-d H:i:s'),
                                'cpv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'cpv_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );
                            $this->gsatelite->ingresar('cpv_contacto_prov', $contactos_array);
                        }
                    }

                    //Documentos
                    if (count($tiposDocumentos) > 0) {
                        for ($i = 0; $i < count($tiposDocumentos); $i++) {

                            $extension = end(explode('.', $NombreAnexoDoc[$i]));
                            $carpeta_temporal = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexoDoc[$i]);
                            $carpeta_destino = "uploads/anx_proveedor/" . trim($TitulosAnexosDoc[$i]) . "." . trim($extension);
                            $documentos_array = array(
                                'dcp_id_prv' => $prv_id,
                                'dcp_id_tde' => $tiposDocumentos[$i],
                                'dcp_valor' => $NumDocumentos[$i],
                                'dcp_fecha_vence' => (trim($FechaVencDocumentos[$i])!='')? date('Y-m-d H:i:s', strtotime($FechaVencDocumentos[$i])):null,
                                'dcp_fecha_expedicion' => (trim($FechaExpDocumentos[$i])!='')? date('Y-m-d H:i:s', strtotime($FechaExpDocumentos[$i])):null,
                                'dcp_lugar_expedicion' => (trim($LugarExpDocumentos[$i])!='')? $LugarExpDocumentos[$i]:null,
                                'dcp_nombre_anexo' => $NombreAnexoDoc[$i],
                                'dcp_url' => $carpeta_destino,
                                'dcp_estado' => 1,
                                'dcp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dcp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dcp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dcp_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );
                            $dcp_id = $this->gsatelite->ingresar('dcp_documento_proveedor', $documentos_array);
                            if ($dcp_id > 0) {
                                copy($carpeta_temporal, $carpeta_destino);
                                unlink($carpeta_temporal);
                            }
                        }
                    }

                    //Finanzas
                    //$retenciones
                    foreach ($retenciones as $retencion ) {
                        $retencion_array = array(
                            'rpv_id_ret'            => $retencion,
                            'rpv_id_prv'            => $prv_id,
                            'rpv_estado'            => 1,
                            'rpv_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'rpv_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'rpv_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'rpv_fecha_modificacion'=> date('Y-m-d H:i:s'),
                        );
                        $this->gsatelite->ingresar('rpv_retencion_proveedor', $retencion_array);
                    }

                    // Variables de Captura para las cuentas bancarias
                    $bancos              = $this->input->post("bancos");
                    $txt_cuentaBancarias = $this->input->post("txt_cuentaBancarias");
                    $txtorden_de_banco   = $this->input->post("txtorden_de_banco");
                    // Cuentas bancarias
                    if ($bancos!=null) {
                        for ($i = 0; $i < count($bancos); $i++) {
                            $cuentasBancarias_array = array(
                                'dbp_id_prv'            => $prv_id,
                                'dbp_id_ban'            => ($bancos[$i] > 0)?$bancos[$i]:null,
                                'dbp_cuenta_banco'      => (is_numeric($txt_cuentaBancarias[$i]))?$txt_cuentaBancarias[$i]:null,
                                'dbp_orden_de'          => (trim($txtorden_de_banco[$i]) != "")?$txtorden_de_banco[$i]:null,
                                'dbp_estado'            => 1,
                                'dbp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'dbp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'dbp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'dbp_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('dbp_detalle_banco_proveedor', $cuentasBancarias_array);
                        }
                    }                

                    //Cuentas Contables
                    if (is_array($centrosCosto) && count($centrosCosto) > 0) {
                        for ($i = 0; $i < count($centrosCosto); $i++) {
                            $cuentas_array = array(
                                'dfp_id_prv'            => $prv_id,
                                'dfp_id_cnt'            => $cuentaContable[$i],
                                'dfp_id_tcn'            => $tipoCuentas[$i],
                                'dfp_id_cec'            => $centrosCosto[$i],
                                'dfp_id_tpg'            => $tipoPago[$i],
                                'dfp_estado'            => 1,
                                'dfp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'dfp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'dfp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'dfp_fecha_modificacion'=> date('Y-m-d H:i:s'),
                            );
                            $this->gsatelite->ingresar('dfp_detalle_finanza_proveedor', $cuentas_array);
                        }
                    }

                    //Anexos
                    if (is_array($NombreAnexo) &&count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {

                            $extension = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);
                            $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);
                            $carpeta_destino_anx = "uploads/anx_proveedor/" . $nombreArchivo;
                            $documentos_array = array(
                                'nxp_id_prv' => $prv_id,
                                'nxp_url' => $carpeta_destino_anx,
                                'nxp_nombre' => $nombreArchivo,
                                'nxp_estado' => 1,
                                'nxp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'nxp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'nxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'nxp_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );
                            $nxp_id = $this->gsatelite->ingresar('nxp_anexo_proveedor', $documentos_array);

                            if ($nxp_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }


                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proveedor", 'texto_alerta' => "Proveedor #" . $codigo_proveedor . " creado");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
                }
                $tipo_btn = $post_array['btnGuardar'];
                if ($esmodal > 0) {
                     $this->session->set_flashdata($alerta);
                     echo json_encode(array("valido" => 1,"boton" => $tipo_btn));
                     die();
                }

                if ($tipo_btn == 1) {
                    if ($referencia == 'cuentas')
                        $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/agregar_proveedor", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                    $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/agregar_proveedor", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                } else {
                    if ($referencia == 'cuentas')
                        $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                    $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                }
                //fin de la validacion del producto para evitar duplicidad

            }else{ // aqui es cuando pasa por alto
                $tipo_btn = $post_array['btnGuardar'];
                if ($esmodal > 0) {
                     $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proveedor no se guardó", 'texto_alerta' => "El proveedor ya había sido creado con anterioridad.");
                     $this->session->set_flashdata($alerta);
                     echo json_encode(array("valido" => 1,"boton" => $tipo_btn));
                     die();
                }
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proveedor", 'texto_alerta' => "El proveedor ya había sido creado con anterioridad.");
                if ($tipo_btn == 1) {
                    if ($referencia == 'cuentas')
                        $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/agregar_proveedor", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                    $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/agregar_proveedor", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                } else {
                    if ($referencia == 'cuentas')
                        $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                    $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                }
                
            }
        }// fin del post

        // $numero_proveedores       = $this->gsatelite->count('prv_proveedor');
        $numero_proveedores       = $this->gsatelite->get_max('prv_proveedor', 'prv_id');
        $data['codigo_proveedor'] = generar_codigo_cor($numero_proveedores + 1);
        $data['nacionalidades']   = $this->gsatelite->get_dropdown('pai_pais', 'pai_nacionalidad', 'nacionalidades', array('pai_estado' => 1, 'pai_nacionalidad <>' => ''), null, null, null, true);
        $data['municipios']       = $this->gsatelite->get_dropdown('mun_municipio', 'mun_nombre', 'municipios', null, null, null, null, true);
        $data['tamanio_prov']     = $this->gsatelite->get_dropdown('tap_tamano_prov', 'tap_nombre', 'tamanios', array('tap_estado' => 1), null, null, null, true);
        $data['giros']            = $this->gsatelite->get_dropdown('gir_giro', '{gir_codigo} {gir_nombre}', 'giros', array('gir_estado' => 1), null, null, null, true);
        $data['impuestos']        = $this->gsatelite->get_dropdown('imp_impuesto', 'imp_nombre', 'impuestos', array('imp_estado' => 1), null, null, null, true);
        $data['retenciones']      = $this->gsatelite->get_dropdown('ret_retencion', 'ret_nombre', 'retenciones', array('ret_estado' => 1), null, null, null, true);
        $data['tipos_pagos']      = $this->gsatelite->get_dropdown('tpg_tipo_pago', 'tpg_nombre', 'tipo de pagos', array('tpg_estado' => 1), null, null, null, true);
        $data['tipos_telefono']   = $this->gsatelite->get_dropdown('tit_tipo_telefono', 'tit_nombre', 'telefonos', null, null, null, null, true);
        $data['tipos_documentos'] = $this->gsatelite->get_tabla('tde_tipo_documento', array('tde_estado' => 1));
        $data['actividades_eco']  = $this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), null, null, null, true);
        $data['titulo_personal']  = "Agregar Proveedor";
        $data['referencia']       = $referencia;
        if ($referencia != 0) {
            return $data;
        }
        //Centro de costos
        $data["centro_costo"]  = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        //tipo de cuenta 
        $data["tipo_cuenta"]   = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        //cuenta contable
        $data["cuen_con"]      = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
        // Clasificación de proveedor
        $clasificacion         = $this->gsatelite->get_dropdown('clp_clasificacion_proveedor', '{clp_nombre}', '', array('clp_estado' => 1), null, '', 'clp_id', true);
        $data["clasificacion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $clasificacion);
        // Condición de pago
        $condicion             = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), null, '', 'cod_id', true);
        $data["condicion"]     = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $condicion);
        // Bancos
        $select                = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
        $data["bancos"]        = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);        
        
        if (substr_count($_SERVER['HTTP_REFERER'], 'agregar_cotizacion') || $modales != null) { 
            $data["esmodal"] = 1;
            $this->gsatelite->cargar_vista_masterpage('modulo_compras/catalogos/agregar_proveedor',$data);
        } else {
            $data["esmodal"] = 0;
            $this->_cargarvista($data,null,$ruta_vista);
        }
    }

    public function editar_proveedor($prv_id, $referencia = null, $ruta_vista=null) {
        satelite_validar();
        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = (is_array($ruta_vista))? $ruta_vista[0]:'modulo_compras/catalogos/proveedores'; //cuando viene la petición de otro modulo.
        $arreglo_url = explode('/',$ruta_permisos);
        $modulo_url = $arreglo_url[0].'/'.$arreglo_url[1]; //cuando viene la petición de otro modulo.
        $data['modulo_url'] = $modulo_url;
        $ruta_vista = (is_array($ruta_vista))? $ruta_vista[1]:null;

        if ($referencia == null) {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion($ruta_permisos, 'editar');
        }
        if ($this->input->post()) { 
            // var_dump($_POST);die();
            $post_array = $this->input->post();
            $Impuestos = (isset($post_array['slcImpuestos']) && $post_array['slcImpuestos'] != '') ? $post_array['slcImpuestos'] : null;
            //Emails
            $EmailsIds = (isset($post_array['Emails']) && $post_array['Emails'] != '') ? $post_array['Emails'] : null;
            $EmailsText = (isset($post_array['EmailsText']) && $post_array['EmailsText'] != '') ? $post_array['EmailsText'] : null;
            $EmailsProv = (isset($post_array['EmailsProv']) && $post_array['EmailsProv'] != '') ? $post_array['EmailsProv'] : null;
            //Telefonos
            $TelefonosIds = (isset($post_array['TelefonosPrv']) && $post_array['TelefonosPrv'] != '') ? $post_array['TelefonosPrv'] : null;
            $TiposTelefonosPrv = (isset($post_array['TiposTelefonosPrv']) && $post_array['TiposTelefonosPrv'] != '') ? $post_array['TiposTelefonosPrv'] : null;
            $NumTelefonosPrv = (isset($post_array['NumTelefonosPrv']) && $post_array['NumTelefonosPrv'] != '') ? $post_array['NumTelefonosPrv'] : null;

            $tiposTelefonosProv = (isset($post_array['tiposTelefonosProv']) && $post_array['tiposTelefonosProv'] != '') ? $post_array['tiposTelefonosProv'] : null;
            $TelefonosProv = (isset($post_array['TelefonosProv']) && $post_array['TelefonosProv'] != '') ? $post_array['TelefonosProv'] : null;

            //Contactos
            $ContactosIds = (isset($post_array['hdnContactoPrv']) && $post_array['hdnContactoPrv'] != '') ? $post_array['hdnContactoPrv'] : null;
            $NombreContactosPrv = (isset($post_array['NombreContactosPrv']) && $post_array['NombreContactosPrv'] != '') ? $post_array['NombreContactosPrv'] : null;
            $ApellidoContactosPrv = (isset($post_array['ApellidoContactosPrv']) && $post_array['ApellidoContactosPrv'] != '') ? $post_array['ApellidoContactosPrv'] : null;
            $CargoContactosPrv = (isset($post_array['CargoContactosPrv']) && $post_array['CargoContactosPrv'] != '') ? $post_array['CargoContactosPrv'] : null;
            $EmailContactosPrv = (isset($post_array['EmailContactosPrv']) && $post_array['EmailContactosPrv'] != '') ? $post_array['EmailContactosPrv'] : null;
            $TelefonoContactosPrv = (isset($post_array['TelefonoContactosPrv']) && $post_array['TelefonoContactosPrv'] != '') ? $post_array['TelefonoContactosPrv'] : null;

            $NombreContactos = (isset($post_array['NombreContactos']) && $post_array['NombreContactos'] != '') ? $post_array['NombreContactos'] : null;
            $ApellidoContactos = (isset($post_array['ApellidoContactos']) && $post_array['ApellidoContactos'] != '') ? $post_array['ApellidoContactos'] : null;
            $CargoContactos = (isset($post_array['CargoContactos']) && $post_array['CargoContactos'] != '') ? $post_array['CargoContactos'] : null;
            $TelefonoContactos = (isset($post_array['TelefonoContactos']) && $post_array['TelefonoContactos'] != '') ? $post_array['TelefonoContactos'] : null;
            $EmailContactos = (isset($post_array['EmailContactos']) && $post_array['EmailContactos'] != '') ? $post_array['EmailContactos'] : null;

            $condicion = $post_array['slcCondicion'];


            //Documentos            
            $DocumentosIds = $post_array['hdnDocumentoPrv'];
            $tiposDocumentosPrv = $post_array['tiposDocumentosPrv'];
            $NumDocumentosPrv = $post_array['NumDocumentosPrv'];
            $FechaVencDocumentosPrv = $post_array['FechaVencDocumentosPrv'];
            $FechaExpDocumentosPrv = $post_array['FechaExpDocumentosPrv'];
            $LugarExpDocumentosPrv = $post_array['LugarExpDocumentosPrv'];

            $tiposDocumentos = $post_array['tiposDocumentos'];
            $NumDocumentos = $post_array['NumDocumentos'];
            $FechaVencDocumentos = $post_array['FechaVencDocumentos'];
            $FechaExpDocumentos = $post_array['FechaExpDocumentos'];
            $LugarExpDocumentos = $post_array['LugarExpDocumentos'];
            $TitulosAnexosDoc = $post_array['TitulosAnexosDoc'];
            $NombreAnexoDoc = $post_array['nombre_anexo_doc'];
            $RutaAnexoDoc = $post_array['ruta_anexo_doc'];

            //Finanzas
            $retenciones    = $post_array['slc_retenciones'];

            //Cuentas Contables
            $detalleCuentas = $post_array['hdnCuentaProv'];
            $centrosCosto = $post_array['centrosCosto'];
            $cuentaContable = $post_array['cuentaContable'];
            $tipoCuentas = $post_array['tipoCuentas'];
            $tipoPago       = $post_array['tipoPago'];

            //Anexos
            $AnexoPrv = $post_array['AnexoPrv'];

            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];

            $tipoBtn = $post_array['btnTipo'];

            // Casificacion del proveedor
            $slcClasificacionProv = $post_array['slcClasificacionProv'];
 

            $proveedor_array = array(
                'prv_id_mun' => ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null,
                'prv_id_dis' => ($post_array['slcDistrito'] != '') ? $post_array['slcDistrito'] : null,
                'prv_id_tap' => ($post_array['slcTamanioProv'] != '') ? $post_array['slcTamanioProv'] : null,
                'prv_id_pai' => ($post_array['slcNacionalidad'] != '') ? $post_array['slcNacionalidad'] : null,
                'prv_id_gir' => ($post_array['slcGiro'] != '') ? $post_array['slcGiro'] : null,
                'prv_id_acp' => ($post_array['slcActividad'] != '') ? $post_array['slcActividad'] : null,
                'prv_id_clp' => ($slcClasificacionProv != '') ? $slcClasificacionProv : null,
                'prv_id_cod' => ($condicion > 0 ) ? $condicion : null, 
                'prv_tipo_pers' => $post_array['slcPersoneria'],
                'prv_codigo' => ($post_array['txtCodigo'] != '') ? $post_array['txtCodigo'] : null,
                'prv_nombre' => ($post_array['txtNombreProv'] != '') ? $post_array['txtNombreProv'] : null,
                'prv_apellido' => ($post_array['txtApellidoProv'] != '') ? $post_array['txtApellidoProv'] : null,
                'prv_direccion' => ($post_array['txtDireccionProv'] != '') ? $post_array['txtDireccionProv'] : null,
                'prv_representante' => ($post_array['txtRepresentante'] != '') ? $post_array['txtRepresentante'] : null,
                'prv_observacion' => ($post_array['txtObservacion'] != '') ? $post_array['txtObservacion'] : null,
                'prv_fecha_registro' => ($post_array['txtFechaRegistro'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaRegistro'])) : null,
                'prv_limite_credito' => ($post_array['txtLimite'] != '') ? convertirFloat($post_array['txtLimite']) : null,
                'prv_dias_plazo' => ($post_array['txtDiasPlazo'] != '') ? $post_array['txtDiasPlazo'] : null,
                'prv_detalle_condicion' => ($post_array['detalle_condicion'] != '') ? $post_array['detalle_condicion'] : null,
                'prv_comentario_actividad' => ($post_array['txtComentariosAct'] != '') ? $post_array['txtComentariosAct'] : null,
                'prv_estado' => 1,
                'prv_usu_modificacion' => $this->tank_auth->get_user_id(),
                'prv_fecha_modificacion' => date('Y-m-d H:i;s'),
            );

            $registro = $this->gsatelite->actualizar_array('prv_proveedor', $proveedor_array, array('prv_id' => $prv_id));

            if ($registro > 0) {

                //Se eliminan los impuestos ya existentes
                $this->gsatelite->borrado_general('ixp_impuestoxproveedor', array('ixp_id_prv' => $prv_id));

                //Impuestos
                if (count($Impuestos) > 0) {
                    for ($i = 0; $i < count($Impuestos); $i++) {
                        $impuestos_array = array(
                            'ixp_id_prv' => $prv_id,
                            'ixp_id_imp' => $Impuestos[$i],
                            'ixp_estado' => 1,
                            'ixp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ixp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ixp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ixp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->ingresar('ixp_impuestoxproveedor', $impuestos_array);
                    }
                }

                //Se obtienen los emails guardados, si existen se verifica si se actualizan o se eliminan
                $dataEmails = $this->gsatelite->get_tabla('cpd_correo_proveedor', array('cpd_id_prv' => $prv_id));
                if (!is_array($EmailsIds)) {
                    $EmailsIds = array();
                }
                foreach ($dataEmails as $data) {
                    if (!in_array($data['cpd_id'], $EmailsIds)) {
                        $this->gsatelite->borrado_general('cpd_correo_proveedor', array('cpd_id' => $data['cpd_id']));
                    }
                }

                //Se actualizan los registros
                if (count($EmailsIds) > 0) {
                    for ($i = 0; $i < count($EmailsIds); $i++) {
                        $correos_array = array(
                            'cpd_correo' => $EmailsText[$i],
                            'cpd_estado' => 1,
                            'cpd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpd_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->actualizar_array('cpd_correo_proveedor', $correos_array, array('cpd_id' => $EmailsIds[$i]));
                    }
                }

                //Correos
                if (count($EmailsProv) > 0) {
                    for ($i = 0; $i < count($EmailsProv); $i++) {
                        $correos_array = array(
                            'cpd_id_prv' => $prv_id,
                            'cpd_correo' => $EmailsProv[$i],
                            'cpd_estado' => 1,
                            'cpd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cpd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpd_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->ingresar('cpd_correo_proveedor', $correos_array);
                    }
                }

                //Se obtienen los Telefonos guardados, si existen se verifica si se actualizan o se eliminan
                $dataTelefonos = $this->gsatelite->get_tabla('tep_telefono_proveedor', array('tep_id_prv' => $prv_id));
                if (!is_array($TelefonosIds)) {
                    $TelefonosIds = array();
                }
                foreach ($dataTelefonos as $data) {
                    if (!in_array($data['tep_id'], $TelefonosIds)) {
                        $this->gsatelite->borrado_general('tep_telefono_proveedor', array('tep_id' => $data['tep_id']));
                    }
                }

                //Se actualizan los registros
                if (count($TelefonosIds) > 0) {
                    for ($i = 0; $i < count($TelefonosIds); $i++) {
                        $telefonos_array = array(
                            'tep_id_tit' => $TiposTelefonosPrv[$i],
                            'tep_numero' => $NumTelefonosPrv[$i],
                            'tep_estado' => 1,
                            'tep_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'tep_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->actualizar_array('tep_telefono_proveedor', $telefonos_array, array('tep_id' => $TelefonosIds[$i]));
                    }
                }

                //Telefonos
                if (count($tiposTelefonosProv) > 0) {
                    for ($i = 0; $i < count($tiposTelefonosProv); $i++) {
                        $telefonos_array = array(
                            'tep_id_prv' => $prv_id,
                            'tep_id_tit' => $tiposTelefonosProv[$i],
                            'tep_numero' => $TelefonosProv[$i],
                            'tep_estado' => 1,
                            'tep_usu_creacion' => $this->tank_auth->get_user_id(),
                            'tep_fecha_creacion' => date('Y-m-d H:i:s'),
                            'tep_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'tep_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->ingresar('tep_telefono_proveedor', $telefonos_array);
                    }
                }

                //Se obtienen los Contactos guardados, si existen se verifica si se actualizan o se eliminan
                $dataContactos = $this->gsatelite->get_tabla('cpv_contacto_prov', array('cpv_id_prv' => $prv_id));
                if (!is_array($ContactosIds)) {
                    $ContactosIds = array();
                }
                foreach ($dataContactos as $data) {
                    if (!in_array($data['cpv_id'], $ContactosIds)) {
                        $this->gsatelite->borrado_general('cpv_contacto_prov', array('cpv_id' => $data['cpv_id']));
                    }
                }

                //Se actualizan los registros
                if (count($ContactosIds) > 0) {
                    for ($i = 0; $i < count($ContactosIds); $i++) {
                        $contactos_array = array(
                            'cpv_nombre' => $NombreContactosPrv[$i],
                            'cpv_apellidos' => ($ApellidoContactosPrv[$i] != "") ? $ApellidoContactosPrv[$i] : null,
                            'cpv_cargo' => ($CargoContactosPrv[$i] != "") ? $CargoContactosPrv[$i] : null,
                            'cpv_telefono' => ($TelefonoContactosPrv[$i] != "") ? $TelefonoContactosPrv[$i] : null,
                            'cpv_email' => ($EmailContactosPrv[$i] != "") ? $EmailContactosPrv[$i] : null,
                            'cpv_estado' => 1,
                            'cpv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpv_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->actualizar_array('cpv_contacto_prov', $contactos_array, array('cpv_id' => $ContactosIds[$i]));
                    }
                }

                //Contactos
                if (count($NombreContactos) > 0) {
                    for ($i = 0; $i < count($NombreContactos); $i++) {
                        $contactos_array = array(
                            'cpv_id_prv' => $prv_id,
                            'cpv_nombre' => $NombreContactos[$i],
                            'cpv_apellidos' => ($ApellidoContactos[$i] != "") ? $ApellidoContactos[$i] : null,
                            'cpv_cargo' => ($CargoContactos[$i] != "") ? $CargoContactos[$i] : null,
                            'cpv_telefono' => ($TelefonoContactos[$i] != "") ? $TelefonoContactos[$i] : null,
                            'cpv_email' => ($EmailContactos[$i] != "") ? $EmailContactos[$i] : null,
                            'cpv_estado' => 1,
                            'cpv_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpv_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cpv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpv_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->ingresar('cpv_contacto_prov', $contactos_array);
                    }
                }

                //Se obtienen los Documentos guardados, si existen se verifica si se actualizan o se eliminan
                $dataDocumentos = $this->gsatelite->get_tabla('dcp_documento_proveedor', array('dcp_id_prv' => $prv_id));
                if (!is_array($DocumentosIds)) {
                    $DocumentosIds = array();
                }
                foreach ($dataDocumentos as $data) {
                    if (!in_array($data['dcp_id'], $DocumentosIds)) {
                        $this->gsatelite->borrado_general('dcp_documento_proveedor', array('dcp_id' => $data['dcp_id']));
                    }
                }

                //Se actualizan los registros
                if (count($DocumentosIds) > 0) {
                    for ($i = 0; $i < count($DocumentosIds); $i++) {

                        $documentos_array = array(
                            'dcp_id_tde' => $tiposDocumentosPrv[$i],
                            'dcp_valor' => $NumDocumentosPrv[$i],
                            'dcp_fecha_vence' => (trim($FechaVencDocumentosPrv[$i]) != '')? date('Y-m-d H:i:s', strtotime($FechaVencDocumentosPrv[$i])):null,
                            'dcp_fecha_expedicion' => (trim($FechaExpDocumentosPrv[$i]) != '')? date('Y-m-d H:i:s', strtotime($FechaExpDocumentosPrv[$i])):null,
                            'dcp_lugar_expedicion' => (trim($LugarExpDocumentosPrv[$i]) != '')? $LugarExpDocumentosPrv[$i]:null,
                            //'dcp_nombre_anexo' => $NombreAnexoDoc[$i],
                            //'dcp_url' => $carpeta_destino,
                            'dcp_estado' => 1,
                            'dcp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dcp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->actualizar_array('dcp_documento_proveedor', $documentos_array, array('dcp_id' => $DocumentosIds[$i]));
                    }
                }

                //Documentos
                if (count($tiposDocumentos) > 0) {
                    for ($i = 0; $i < count($tiposDocumentos); $i++) {


                        $extension = end(explode('.', $NombreAnexoDoc[$i]));
                        $carpeta_temporal = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexoDoc[$i]);
                        $carpeta_destino = "uploads/anx_proveedor/" . trim($TitulosAnexosDoc[$i]) . "." . trim($extension);

                        $documentos_array = array(
                            'dcp_id_prv' => $prv_id,
                            'dcp_id_tde' => $tiposDocumentos[$i],
                            'dcp_valor' => $NumDocumentos[$i],
                            'dcp_fecha_vence' => (trim($FechaVencDocumentos[$i]) != '')? date('Y-m-d H:i:s', strtotime($FechaVencDocumentos[$i])):null,
                            'dcp_fecha_expedicion' => (trim($FechaExpDocumentos[$i]) != '')? date('Y-m-d H:i:s', strtotime($FechaExpDocumentos[$i])):null,
                            'dcp_lugar_expedicion' => (trim($LugarExpDocumentos[$i]) != '')? $LugarExpDocumentos[$i]:null,
                            'dcp_nombre_anexo' => $NombreAnexoDoc[$i],
                            'dcp_url' => $carpeta_destino,
                            'dcp_estado' => 1,
                            'dcp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dcp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dcp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dcp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $dcp_id = $this->gsatelite->ingresar('dcp_documento_proveedor', $documentos_array);

                        if ($dcp_id > 0) {
                            copy($carpeta_temporal, $carpeta_destino);
                            unlink($carpeta_temporal);
                        }
                    }
                }

                //Finanzas
                //$retenciones
                $retenciones_old = $this->gsatelite->get_tabla('rpv_retencion_proveedor', array('rpv_id_prv' => $prv_id));
                if (!is_array($retenciones_old)) {
                    $detalleCuentas = array();
                }
                foreach ($retenciones_old as $ret) {
                    $this->gsatelite->borrado_general('rpv_retencion_proveedor', array('rpv_id' => $ret['rpv_id']) );
                }

                foreach ($retenciones as $retencion ) {
                    $retencion_array = array(
                        'rpv_id_ret'            => $retencion,
                        'rpv_id_prv'            => $prv_id,
                        'rpv_estado'            => 1,
                        'rpv_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'rpv_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'rpv_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'rpv_fecha_modificacion'=> date('Y-m-d H:i:s'),
                    );

                    $this->gsatelite->ingresar('rpv_retencion_proveedor', $retencion_array);
                }

                // Variables de Captura para las cuentas bancarias
                $bancos              = $this->input->post("bancos");
                $txt_cuentaBancarias = $this->input->post("txt_cuentaBancarias");
                $txtorden_de_banco   = $this->input->post("txtorden_de_banco");

                // Cuentas bancarias
                $this->gsatelite->borrado_general('dbp_detalle_banco_proveedor', array('dbp_id_prv' => $prv_id));
                if (count($bancos) > 0 && $bancos != null) {
                    for ($i = 0; $i < count($bancos); $i++) {
                        $cuentasBancarias_array = array(
                            'dbp_id_prv'            => $prv_id,
                            'dbp_id_ban'            => ($bancos[$i] > 0)?$bancos[$i]:null,
                            'dbp_cuenta_banco'      => (is_numeric($txt_cuentaBancarias[$i]))?$txt_cuentaBancarias[$i]:null,
                            'dbp_orden_de'          => (trim($txtorden_de_banco[$i]) != "")?$txtorden_de_banco[$i]:null,
                            'dbp_estado'            => 1,
                            'dbp_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'dbp_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'dbp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dbp_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('dbp_detalle_banco_proveedor', $cuentasBancarias_array);
                    }
                }                 

                //$detalleCuentas
                //Se obtienen las Cuentas guardadas, si existen se verifica si se eliminara
                $dataCuentas = $this->gsatelite->get_tabla('dfp_detalle_finanza_proveedor', array('dfp_id_prv' => $prv_id));
                if (!is_array($detalleCuentas)) {
                    $detalleCuentas = array();
                }
                foreach ($dataCuentas as $data) {
                    if (!in_array($data['dfp_id'], $detalleCuentas)) {
                        $this->gsatelite->borrado_general('dfp_detalle_finanza_proveedor', array('dfp_id' => $data['dfp_id']));
                    }
                }
                //Cuentas Contables
                if (count($centrosCosto) > 0) {
                    for ($i = 0; $i < count($centrosCosto); $i++) {
                        $cuentas_array = array(
                            'dfp_id_prv'            => $prv_id,
                            'dfp_id_cnt'            => $cuentaContable[$i],
                            'dfp_id_tcn'            => $tipoCuentas[$i],
                            'dfp_id_cec'            => $centrosCosto[$i],
                            'dfp_id_tpg'            => $tipoPago[$i],
                            'dfp_estado'            => 1,
                            'dfp_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'dfp_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'dfp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dfp_fecha_modificacion'=> date('Y-m-d H:i:s'),
                        );

                        $this->gsatelite->ingresar('dfp_detalle_finanza_proveedor', $cuentas_array);
                    }
                }


                //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                $dataAnexos = $this->gsatelite->get_tabla('nxp_anexo_proveedor', array('nxp_id_prv' => $prv_id));
                if (!is_array($AnexoPrv)) {
                    $AnexoPrv = array();
                }
                foreach ($dataAnexos as $data) {
                    if (!in_array($data['nxp_id'], $AnexoPrv)) {
                        $this->gsatelite->borrado_general('nxp_anexo_proveedor', array('nxp_id' => $data['nxp_id']));
                        $ruta_nxp = $data['nxp_url'];
                        unlink($ruta_nxp);
                    }
                }

                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);

                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_proveedor/" . $nombreArchivo;

                        $documentos_array = array(
                            'nxp_id_prv' => $prv_id,
                            'nxp_url' => $carpeta_destino_anx,
                            'nxp_nombre' => $nombreArchivo,
                            'nxp_estado' => 1,
                            'nxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'nxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'nxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'nxp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $nxp_id = $this->gsatelite->ingresar('nxp_anexo_proveedor', $documentos_array);

                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proveedor", 'texto_alerta' => "Proveedor actualizado");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
            }

            //$this->session->set_flashdata($alerta);

            // if ($tipoBtn == 1) {
            //     if ($referencia == 'cuentas')
            //         $this->gsatelite->show_dialog($alerta['texto_alerta'], "modulo_cuentas_pagar/catalogo/editar_proveedor/" . $prv_id, $alerta['tipo_alerta'], $alerta['titulo_alerta']);
            //     $this->gsatelite->show_dialog($alerta['texto_alerta'], "modulo_compras/catalogos/editar_proveedor/" . $prv_id, $alerta['tipo_alerta'], $alerta['titulo_alerta']);
            // } else {
            //     if ($referencia == 'cuentas')
            //         $this->gsatelite->show_dialog($alerta['texto_alerta'], "modulo_cuentas_pagar/catalogo/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
            //     $this->gsatelite->show_dialog($alerta['texto_alerta'], "modulo_compras/catalogos/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
            // }
            // if ($tipoBtn == 1) {
            //     redirect('modulo_compras/catalogos/editar_proveedor/' . $prv_id);
            // } else {
            //     redirect('modulo_compras/catalogos/proveedores');
            // }





            if ($tipoBtn == 1) {
                if ($referencia == 'cuentas')
                    $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/editar_proveedor/" . $prv_id, $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/editar_proveedor/" . $prv_id, $alerta['tipo_alerta'], $alerta['titulo_alerta']);
            } else {
                if ($referencia == 'cuentas')
                    $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
                $this->gsatelite->show_dialog($alerta['texto_alerta'], "$modulo_url/proveedores", $alerta['tipo_alerta'], $alerta['titulo_alerta']);
            }
            if ($tipoBtn == 1) {
                redirect($modulo_url.'/editar_proveedor/' . $prv_id);
            } else {
                redirect($modulo_url.'/proveedores');
            }


        
        }//end post
        $proveedor_info = $this->compras_model->get_proveedores(array('prv_id' => $prv_id));
        $data['proveedor'] = $proveedor_info[0];
        $data['nacionalidades'] = $this->gsatelite->get_dropdown('pai_pais', 'pai_nacionalidad', 'nacionalidades', array('pai_estado' => 1, 'pai_nacionalidad <>' => ''), $proveedor_info[0]['prv_id_pai'], null, null, true);
        $data['departamentos']  = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', 'departamentos', array('dep_id_pai' => $proveedor_info[0]['prv_id_pai']), $proveedor_info[0]['dep_id'], null, null, true);
        $data['municipios']     = $this->gsatelite->get_dropdown('mun_municipio', 'mun_nombre', 'municipios', array('mun_id_dep'=>$proveedor_info[0]['dep_id'],'mun_estado'=>1), $proveedor_info[0]['prv_id_mun'], null, null, true);
        $data['distritos']      = $this->gsatelite->get_dropdown('dis_distrito', 'dis_nombre', '', array('dis_id_mun'=>$proveedor_info[0]['prv_id_mun'],'dis_estado'=>1), $proveedor_info[0]['prv_id_dis'], null, null, true);

        $data['tamanio_prov']   = $this->gsatelite->get_dropdown('tap_tamano_prov', 'tap_nombre', 'tamanios', array('tap_estado' => 1), $proveedor_info[0]['prv_id_tap'], null, null, true);
        $data['giros']          = $this->gsatelite->get_dropdown('gir_giro', '{gir_codigo} {gir_nombre}', 'giros', array('gir_estado' => 1), $proveedor_info[0]['prv_id_gir'], null, null, true);
        $data['impuestos']      = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));
        $data['retenciones']    = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));

        //aqui        
        $ret_prov               = $this->gsatelite->get_tabla('rpv_retencion_proveedor',array('rpv_id_prv'=>$prv_id));
        $ret_prov_array         = ($ret_prov)? array_column($ret_prov, 'rpv_id_ret'): array();
        $retenciones            = $this->gsatelite->get_dropdown('ret_retencion', '{ret_nombre}', '', array('ret_estado' => 1), $ret_prov_array , '', 'ret_id', true);
        $data['retenciones']    = str_replace('<option value="0">Seleccione</option>', '', $retenciones);
        $data['tipos_pagos']        = $this->gsatelite->get_dropdown('tpg_tipo_pago', 'tpg_nombre', 'tipo de pagos', array('tpg_estado' => 1), null, null, null, true);
        $data['tipos_telefono'] = $this->gsatelite->get_dropdown('tit_tipo_telefono', 'tit_nombre', 'telefonos', null, null, null, null, true);
        $data['tipos_documentos'] = $this->gsatelite->get_tabla('tde_tipo_documento', array('tde_estado' => 1));
        $data['correos_proveedor'] = $this->gsatelite->get_tabla('cpd_correo_proveedor', array('cpd_id_prv' => $prv_id));

        //Centro de costos
        $data["centro_costo"] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        //tipo de cuenta 
        $data["tipo_cuenta"] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        //cuenta contable
        $data["cuen_con"] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);

                                       $this->db->join('tit_tipo_telefono', 'tep_id_tit = tit_id', 'inner');
        $data['telefonos_proveedor'] = $this->gsatelite->get_tabla('tep_telefono_proveedor', array('tep_id_prv' => $prv_id));

        $data['contactos_proveedor']    = $this->gsatelite->get_tabla('cpv_contacto_prov', array('cpv_id_prv' => $prv_id));
        $data['impuestos_proveedor']    = $this->gsatelite->get_tabla('ixp_impuestoxproveedor', array('ixp_id_prv' => $prv_id));
        $data['actividades_eco']        = $this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), $proveedor_info[0]['prv_id_acp'], null, null, true);
        $data['cuentas_contables']      = $this->compras_model->get_cuentas_proveedor(array('dfp_id_prv' => $prv_id));
        $data['detalle_condicion']      = $this->gsatelite->get_campo('prv_proveedor','prv_detalle_condicion',array('prv_id'=>$prv_id));
        // Clasificación de proveedor
        $clasificacion = $this->gsatelite->get_dropdown('clp_clasificacion_proveedor', '{clp_nombre}', '', array('clp_estado' => 1), $proveedor_info[0]['prv_id_clp'], '', 'clp_id', true);
        $data["clasificacion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $clasificacion);

        // Condición de pago
        $condicion = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), $proveedor_info[0]['prv_id_cod'], '', 'cod_id', true);
        $data["condicion"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $condicion);

        $this->db->join('tde_tipo_documento', 'dcp_id_tde = tde_id', 'inner');
        $documentos_proveedor = $this->gsatelite->get_tabla('dcp_documento_proveedor', array('dcp_id_prv' => $prv_id));

        $this->db->join('ban_banco', 'ban_id = dbp_id_ban');
        $data['cuentas_bancarias_prv'] = $this->gsatelite->get_tabla('dbp_detalle_banco_proveedor', array('dbp_id_prv' => $prv_id));

        // Bancos
        $select = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
        $data["bancos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);         

        foreach ($documentos_proveedor as $key => $dpc) {
            $documentos_proveedor[$key]['opciones_tdd'] = $this->get_tipos_documentos($documentos_proveedor[$key]['tde_id'], true);
        }

        $data['documentos_proveedor'] = $documentos_proveedor;
        $data['anexos_proveedor'] = $this->gsatelite->get_tabla('nxp_anexo_proveedor', array('nxp_id_prv' => $prv_id));
        $data['titulo_personal'] = "Editar Proveedor";

        $data['referencia'] = $referencia;
        if ($referencia != null) {
            return $data;
        }
        $this->_cargarvista($data,null,$ruta_vista);
    }

    public function get_tipos_documentos($seleccionado = null, $flag = false) {

        $opciones = "";

        $tipos_documentos = $this->gsatelite->get_tabla('tde_tipo_documento', array('tde_estado' => 1));
        $opciones = "<option>Seleccione</option>";
        foreach ($tipos_documentos as $tipo) {

            $selected = ($seleccionado == $tipo['tde_id']) ? "selected=selected" : '';

            $opciones .= '<option data-mascara="' . $tipo['tde_mascara'] . '" ' . $selected . ' value="' . $tipo['tde_id'] . '">' . $tipo['tde_nombre'] . '</option>';
        }

        if ($flag) {
            return $opciones;
        }
        echo $opciones;
    }

    function actividad_economica() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/actividad_economica');
        $crud = new grocery_CRUD;
        $alias = array(
            'acp_nombre' => 'Nombre',
            'acp_estado' => 'Estado');

        $colums = array(
            'acp_nombre',
            'acp_estado');
        $edit = array(
            'acp_nombre',
            'acp_estado',
            'acp_usu_modificacion',
            'acp_fecha_modificacion');
        $add = array(
            'acp_nombre',
            'acp_estado',
            'acp_usu_creacion',
            'acp_fecha_creacion',
            'acp_fecha_modificacion',
            'acp_usu_modificacion'
        );

        $crud->set_table('acp_act_economica_prov')
                ->set_subject('Actividad Económica')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($add)
                ->field_type('acp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('acp_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->set_rules('acp_nombre', 'Nombre', 'trim|required|campo_unico[acp_act_economica_prov.acp_nombre]')
                ->unset_delete()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('acp_estado', 'hidden', 1)
                    ->field_type('acp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('acp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('acp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/actividad_economica/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Actividad Económica";
        $this->_cargarvista($data, $output);
    }

    public function giro_comercial() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;

        $alias = array(
            'gir_nombre' => 'Nombre',
            'gir_estado' => 'Estado',
            'gir_porcentaje_pago_cuenta' => 'Porcentaje pago cuenta'
        );

        $colums = array(
            'gir_nombre',
            'gir_porcentaje_pago_cuenta',
            'gir_estado');

        $edit = array(
            'gir_nombre',
            'gir_porcentaje_pago_cuenta',
            'gir_estado',
            'gir_usu_mod',
            'gir_fecha_mod');

        $add = array(
            'gir_nombre',
            'gir_porcentaje_pago_cuenta',
            'gir_estado',
            'gir_usu_mod',
            'gir_usu_crea',
            'gir_fecha_crea',
            'gir_fecha_mod');

        $req = array(
            'gir_nombre',
            'gir_estado',
            'gir_usu_mod',
            'gir_fecha_mod');

        $crud->set_table('gir_giro')
                ->set_subject('Giro comercial')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($req)
                ->field_type('gir_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('gir_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                ->set_rules('gir_nombre', 'Nombre', 'trim|required|campo_unico[gir_giro.gir_nombre]')
                ->unset_delete()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('gir_estado', 'hidden', 1);
            $crud->field_type('gir_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('gir_fecha_crea', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('gir_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Giro comercial";
        $this->_cargarvista($data, $output, 'modulo_compras/catalogos/giro_comercial');
    }

    function tamanio_proveedor() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/tamanio_proveedor');
        $crud = new grocery_CRUD;
        $alias = array(
            'tap_nombre' => 'Nombre',
            'tap_estado' => 'Estado');

        $colums = array(
            'tap_nombre',
            'tap_estado');
        $edit = array(
            'tap_nombre',
            'tap_estado',
            'tap_usu_modificacion',
            'tap_fecha_modificacion');
        $add = array(
            'tap_nombre',
            'tap_estado',
            'tap_usu_creacion',
            'tap_fecha_creacion',
            'tap_fecha_modificacion',
            'tap_usu_modificacion');

        $crud->set_table('tap_tamano_prov')
                ->set_subject('Tamaño proveedor')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($add)
                ->field_type('tap_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tap_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->set_rules('tap_nombre', 'Nombre', 'trim|required|campo_unico[tap_tamano_prov.tap_nombre]')
                ->unset_delete()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tap_estado', 'hidden', 1)
                    ->field_type('tap_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tap_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('tap_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
             $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Tamaño proveedor";
        $this->_cargarvista($data, $output);
    }

    /*
     * Fecha Modificacion: 2018-07-20
     * Modificado por: Rafael Cuchilla
     * Descripcion: Se corrigio CRUD
     */

    public function prioridad() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('prd_prioridad');
            $crud->set_subject('Prioridad');

            $tmp_prd_atencion =0;

            $columnas = array(
                'prd_nombre',
                'prd_estado' 
            );

            $campos = array(
                'prd_nombre',
                'prd_atencion',
                'prd_estado',
                'prd_usu_creacion',
                'prd_usu_modificacion',
                'prd_fecha_creacion',
                'prd_fecha_modificacion'
            );
            $edit = array(
                'prd_nombre',
                'prd_atencion',
                'prd_estado',
                'prd_usu_modificacion',
                'prd_fecha_modificacion'
            );

            $display_as = array(
                'prd_nombre' => 'Nombre',
                'prd_atencion'=>'Requiere atención',
                'prd_estado' => 'Estado'
            );

            $crud->field_type('prd_usu_modificacion', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('prd_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'));
            $crud->field_type('prd_usu_creacion', 'hidden',$this->tank_auth->get_user_id());
            $crud->field_type('prd_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            $crud->set_rules('prd_nombre', 'Nombre', 'campo_unico[prd_prioridad.prd_nombre]|required');
            $crud->required_fields($columnas);
            $crud->callback_field('prd_atencion', array($this,'check_field'));
            
            $crud->callback_before_insert(function($post_array, $primary_key){
                if(!isset($post_array['prd_atencion'])){
                     $post_array['prd_atencion']=0;
                   return $post_array;
                 }
             });

             $crud->callback_before_update(function($post_array, $primary_key){
                 if(!isset($post_array['prd_atencion'])){
                     $post_array['prd_atencion']=0;
                    return $post_array;
                }
             });

            $crud->columns($columnas);
           // $crud->fields($campos);
            $crud->edit_fields($edit)
                 ->add_fields($campos);

            $crud->display_as($display_as);

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('prd_estado', 'hidden', 1);
                //$crud->field_type('prd_atencion', 'hidden', 0);
            } else {
                $crud->field_type('prd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/prioridad/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de prioridades";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function check_field($value= 0,$primary_key=null)
    {
        if($value==1){ 
            $checked = 'checked="checked"'; 
        }else{ 
            $checked=''; 
        }
            return '<input id="field-prd_atencion" name="prd_atencion" type="checkbox" class="span12 nostyle" '.$checked.' value="'.$value.'">';
    }

    function condicion_pago() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/condicion_pago');
            $crud = new grocery_CRUD();
            $crud->set_table('cod_condicion')
                    ->set_subject('Condición')
                    ->columns('cod_nombre', 'cod_descripcion', 'cod_estado')
                    ->display_as('cod_nombre', 'Nombre')
                    ->display_as('cod_descripcion', 'Descripción')
                    ->display_as('cod_estado', 'Estado')
                    ->required_fields('cod_nombre', 'cod_estado')
                    ->set_rules('cod_nombre', 'Nombre', 'trim|required|campo_unico[cod_condicion.cod_nombre]')
                    ->field_type('cod_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cod_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ;

            $crud->add_fields('cod_nombre', 'cod_descripcion', 'cod_usu_crea', 'cod_usu_mod', 'cod_fecha_crea', 'cod_fecha_mod', 'cod_estado');
            $crud->edit_fields('cod_nombre', 'cod_descripcion', 'cod_usu_mod', 'cod_fecha_mod', 'cod_estado');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cod_estado', 'hidden', 1)
                        ->field_type('cod_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('cod_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ;
            } else {  // Editar
                $crud->field_type('cod_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }


            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'transporte/cruds/prioridad/read');
            }

            $data['titulo_personal'] = "Condiciones";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    public function otros_gastos() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/otros_gastos');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('gst_gasto');
            $crud->set_subject('');

            $columnas = array(
                'gst_nombre',
                'gst_defecto',
                'gst_porcentaje',
                'gst_id_cnt',
                'gst_estado'
            );

            $add_fields = array(
                'gst_nombre',
                'gst_defecto',
                'gst_porcentaje',
                'gst_id_cnt',
                'gst_estado',
                'gst_usu_creacion',
                'gst_usu_modificacion',
                'gst_fecha_creacion',
                'gst_fecha_modificacion'
            );

            $required_fields = array(
                'gst_nombre',
                'gst_id_cnt',
                'gst_defecto'
            );

            $edit_fields = array(
                'gst_nombre',
                'gst_defecto',
                'gst_porcentaje',
                'gst_id_cnt',
                'gst_estado',
                'gst_usu_modificacion',
                'gst_fecha_modificacion'
            );

            $display_as = array(
                'gst_nombre' => 'Nombre',
                'gst_defecto' => 'Defecto',
                'gst_porcentaje' => 'Porcentaje',
                'gst_id_cnt' => 'Cuenta Contable',
                'gst_estado' => 'Estado'
            );

            $crud->set_rules('gst_nombre', 'Nombre', 'campo_unico[gst_gasto.gst_nombre]|required');
            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->set_relation('gst_id_cnt','cnt_cuenta_contable','{cnt_cuenta} {cnt_nombre}');
            $crud->field_type('gst_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('gst_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('gst_defecto', 'dropdown', array('1' => 'Aplica', '0' => 'No Aplica'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('gst_estado', 'hidden', 1)
                        ->field_type('gst_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('gst_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('gst_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/otros_gastos/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Otros Gastos";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function retenciones($ruta_vista = null) {        
        satelite_validar();        
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $url_array = explode('/', uri_string());
            $url = $url_array[0].'/'.$url_array[1];

            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('ret_retencion');
            $crud->set_subject('Retención');

            $columnas = array(
                'ret_nombre',
                'ret_defecto',
                'ret_porcentaje',
                'ret_valor',
                'ret_estado'
            );

            $add_fields = array(
                'ret_nombre',
                'ret_defecto',
                'ret_porcentaje',
                'ret_valor',
                'ret_estado',
                'ret_usu_creacion',
                'ret_usu_modificacion',
                'ret_fecha_creacion',
                'ret_fecha_modificacion'
            );

            $edit_fields = array(
                'ret_nombre',
                'ret_defecto',
                'ret_porcentaje',
                'ret_valor',
                'ret_estado',
                'ret_usu_modificacion',
                'ret_fecha_modificacion'
            );

            $display_as = array(
                'ret_nombre' => 'Nombre',
                'ret_defecto' => 'Defecto',
                'ret_porcentaje' => 'Porcentaje',
                'ret_valor' => 'Valor',
                'ret_estado' => 'Estado'
            );

            $crud->set_rules('ret_nombre', 'Nombre', 'campo_unico[ret_retencion.ret_nombre]|required');
            $crud->required_fields($add_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('ret_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ret_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ret_defecto', 'dropdown', array('1' => 'Aplica', '0' => 'No Aplica'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ret_estado', 'hidden', 1)
                        ->field_type('ret_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('ret_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('ret_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

           // Validaciones
           $crud->unset_edit();
           if (!$permisos['permite_agregar']) {
                $crud->unset_add();
           }
            if ($permisos['permite_editar']) {                
                $crud->add_action('Editar', 'icomoon-icon-pencil-5', $url.'/editar_retencion');                                            
            }
           if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', $url.'/ver_retencion');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Retenciones";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function caja_chica() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/caja_chica');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('cch_caja_chica');
            $crud->set_subject('');

            $columnas = array(
                'cch_nombre',
                'cch_id_emp',
                'cch_descripcion',
                'cch_estado',
                'cch_sobregirar'
            );

            $add_fields = array(
                'cch_nombre',
                'cch_id_emp',
                'cch_descripcion',
                'cch_estado',
                'cch_usu_creacion',
                'cch_usu_modificacion',
                'cch_fecha_creacion',
                'cch_fecha_modificacion',
                'cch_sobregirar'
            );

            $edit_fields = array(
                'cch_nombre',
                'cch_id_emp',
                'cch_descripcion',
                'cch_estado',
                'cch_usu_modificacion',
                'cch_fecha_modificacion',
                'cch_sobregirar'
            );

            $required_fields = array(
                'cch_nombre',
                'cch_id_emp',
                'cch_estado',
                'cch_usu_creacion',
                'cch_usu_modificacion',
                'cch_fecha_creacion',
                'cch_fecha_modificacion'
            );

            $display_as = array(
                'cch_nombre' => 'Nombre',
                'cch_id_emp' => 'Empleado',
                'cch_descripcion' => 'Descripción',
                'cch_estado' => 'Estado',
                'cch_sobregirar' => 'Sobregirar'
            );
            $crud->field_type('cch_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cch_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->callback_field('cch_sobregirar', array($this,'check_flag'));
            $crud->callback_column('cch_sobregirar',array($this,'change_name'));

            $crud->callback_before_insert(function($post_array, $primary_key){
                if(!isset($post_array['cch_sobregirar'])){
                     $post_array['cch_sobregirar'] = 0;
                   return $post_array;
                 }
             });

             $crud->callback_before_update(function($post_array, $primary_key){
                 if(!isset($post_array['cch_sobregirar'])){
                     $post_array['cch_sobregirar'] = 0;
                    return $post_array;
                }
             });

            $crud->set_rules('cch_nombre', 'Nombre', 'campo_unico[cch_caja_chica.cch_nombre]|required');
            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->set_relation('cch_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}', array('emp_estado' => 1));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cch_estado', 'hidden', 1)
                        ->field_type('cch_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('cch_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('cch_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->unset_edit();
            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'modulo_compras/catalogos/editar_caja_chica');
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/caja_chica/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Caja Chica";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function agregar_caja_chica(){
        //satelite_validar();
        if ($this->input->post()){
            $redireccion = $this->input->post('redireccion'); //text
            $nombre      = trim($this->input->post('nombre')); //text requerido
            $descripcion = (trim($this->input->post('descripcion')) != '') ? $this->input->post('descripcion') : null; //text opcional
            $empleado    = $this->input->post('empleado'); //select requerido
            $sobregirar  = $this->input->post('hsobregirar');//checkbox 0/1
            $cuenta_contable = (count($this->input->post('cuenta_contable')) > 0 && $this->input->post('cuenta_contable') != '') ? $this->input->post('cuenta_contable') : array(); //array
            $tipo_cuenta     = (count($this->input->post('tipo_cuenta')) > 0 && $this->input->post('tipo_cuenta') != '') ? $this->input->post('tipo_cuenta') : array(); //array
            $tipo_proceso    = (count($this->input->post('proceso_caja')) > 0 && $this->input->post('proceso_caja') != '') ? $this->input->post('proceso_caja') : array(); //array
            $fecha_registro = date('Y-m-d h:i:s');
            $registrar_cch = array(
                'cch_id_emp' => $empleado,
                'cch_nombre' => $nombre,                    
                'cch_descripcion' => $descripcion,
                'cch_sobregirar' => $sobregirar,
                'cch_estado' => 1,                    
                'cch_usu_creacion' => $this->tank_auth->get_user_id(),
                'cch_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cch_fecha_creacion' => $fecha_registro,
                'cch_fecha_modificacion' => $fecha_registro
            );
            $cch_id = $this->gsatelite->ingresar('cch_caja_chica', $registrar_cch);
            if ($cch_id > 0) {
                if (!(empty($cuenta_contable)) && !(empty($tipo_cuenta)) && !(empty($tipo_proceso))) {
                    $registrar_cnj = [];
                    foreach ($cuenta_contable as $key => $value) {
                        $registrar_cnj[] = array(
                            'cnj_id_cch' => $cch_id,
                            'cnj_id_cnt' => $value,
                            'cnj_id_tcn' => $tipo_cuenta[$key],
                            'cnj_tipo_proceso' => $tipo_proceso[$key],
                            'cnj_estado' => 1,
                            'cnj_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cnj_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cnj_fecha_creacion' => $fecha_registro,
                            'cnj_fecha_modificacion' => $fecha_registro
                        );
                    }
                    $this->gsatelite->ingresar('cnj_cuenta_caja_chica', $registrar_cnj, true);
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de caja chica", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de victima", 'texto_alerta' => "El registro no se guardó correctamente.");
            }
            /* =====    REDIRECCIONES   ===== */
            $this->session->set_flashdata($alerta);
            if ($redireccion == 0) {
                redirect('modulo_compras/catalogos/agregar_caja_chica/');
            } else if ($redireccion == 1) {
                redirect('modulo_compras/catalogos/caja_chica');
            }
            die();
        }//fin del post
        /* =============================
                VISTA
        ============================= */
        //empleados
        $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
        $data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        //tipo de cuenta
        $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        $data["tipo_cuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $data['titulo_personal'] = 'Agregar Caja Chica';
        cargarvista($data);
    }

    public function editar_caja_chica($id){
        // satelite_validar();
        if ($this->input->post()){
            //var_dump($this->input->post());die();
            $redireccion = $this->input->post('redireccion'); //text
            $editar_id   = $this->input->post('editar_id'); //Id de la caja
            $nombre      = trim($this->input->post('nombre')); //text requerido
            $descripcion = (trim($this->input->post('descripcion')) != '') ? $this->input->post('descripcion') : null; //text opcional
            $empleado    = $this->input->post('empleado'); //select requerido
            $sobregirar  = $this->input->post('hsobregirar'); //checkbox 0/1

            $cuenta_caja_nuevo = (count($this->input->post('cuenta_caja_nuevo')) > 0 && $this->input->post('cuenta_caja_nuevo') != '')?$this->input->post('cuenta_caja_nuevo'):array(); //array
            $cuenta_contable   = (count($this->input->post('cuenta_contable')) > 0 && $this->input->post('cuenta_contable') != '')?$this->input->post('cuenta_contable'):array(); //array
            $tipo_cuenta       = (count($this->input->post('tipo_cuenta')) > 0 && $this->input->post('tipo_cuenta') != '')?$this->input->post('tipo_cuenta'):array(); //array
            $tipo_proceso      = (count($this->input->post('proceso_caja')) > 0 && $this->input->post('proceso_caja') != '') ? $this->input->post('proceso_caja') : array(); //array
            $registrar_cch = array();
            if($nombre != null && $empleado != null){
                $fecha_registro = date('Y-m-d h:i:s');
                $registrar_cch = array(
                    'cch_nombre' => $nombre,
                    'cch_id_emp' => $empleado,
                    'cch_descripcion' => $descripcion,
                    'cch_estado' => 1,
                    'cch_sobregirar' => $sobregirar,
                    'cch_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cch_fecha_modificacion' => $fecha_registro
                );
                $this->gsatelite->actualizar_array('cch_caja_chica', $registrar_cch, array('cch_id'=>$editar_id));

                if($editar_id > 0){
                    $cuenta_caja_chica_reg = $this->gsatelite->get_tabla('cnj_cuenta_caja_chica', array('cnj_id_cch'=>$editar_id));
                    $cnj_id_array = array_column($cuenta_caja_chica_reg, 'cnj_id'); //ids de las cnj para compararla con las q vienen
                    $registrar_cnj = [];
                    foreach ($cuenta_caja_nuevo as $key => $value) {
                        if(trim($value) != ''){
                            if(in_array($value, $cnj_id_array)){
                                $posicion = array_search($value, $cnj_id_array);
                                unset($cnj_id_array[$posicion]); //eliminamos las posiciones existentes
                            }
                        } else{
                            $registrar_cnj[] = array(
                                'cnj_id_cch' => $editar_id,
                                'cnj_id_cnt' => $cuenta_contable[$key],
                                'cnj_id_tcn' => $tipo_cuenta[$key],
                                'cnj_tipo_proceso' => $tipo_proceso[$key],
                                'cnj_estado' => 1,
                                'cnj_usu_creacion' => $this->tank_auth->get_user_id(),
                                'cnj_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'cnj_fecha_creacion' => $fecha_registro,
                                'cnj_fecha_modificacion' => $fecha_registro
                            );
                        }
                    }
                    /* ======   Elimina los registros que se eliminaron en la tabla     ===== */
                    foreach ($cnj_id_array as $key => $value) {
                        $this->gsatelite->borrado_general('cnj_cuenta_caja_chica', array('cnj_id'=>$value));
                    }
                    if(count($registrar_cnj) > 0){
                        $this->gsatelite->ingresar('cnj_cuenta_caja_chica', $registrar_cnj, true);
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de caja chica", 'texto_alerta' => "El registro se actualizó correctamente.");
            } else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de victima", 'texto_alerta' => "El registro no se actualizó correctamente.");
            }
            /* =====    REDIRECCIONES   ===== */
            $this->session->set_flashdata($alerta);
            if ($redireccion == 0) {
                redirect('modulo_compras/catalogos/editar_caja_chica/'.$editar_id);
            } else if ($redireccion == 1) {
                redirect('modulo_compras/catalogos/caja_chica');
            }
            die();
        } //fin del post
        /* =====    VISTA   ==== */
        $caja_chica_reg = $this->gsatelite->get_tabla('cch_caja_chica', array('cch_id'=>$id));
        $data['registro'] = $caja_chica_reg[0];
        //empleados
        $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), $caja_chica_reg[0]['cch_id_emp'], '', 'emp_id', true);
        $data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        //tipo de cuenta
        $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        $data["tipo_cuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $data['tabla_cuenta_caja_chica'] = $this->tabla_cuenta_caja_chica($id);
        $data['titulo_personal'] = 'Editar Caja Chica';
        cargarvista($data);
    }

    public function tabla_cuenta_caja_chica($id){
        $this->db->join('tcn_tipo_cuenta', 'tcn_id = cnj_id_tcn');
        $this->db->join('cnt_cuenta_contable', 'cnt_id = cnj_id_cnt');
        $registros = $this->gsatelite->get_tabla('cnj_cuenta_caja_chica', array('cnj_id_cch'=>$id));
        $data['registros'] = $registros;
        $data['cuenta_caja_chica'] = $registros;
        $html = (count($registros) > 0) ? $this->load->view('modulo_compras/catalogos/tabla_cuenta_caja_chica', $data, true):'';
        // print_r($html);die();
        return array('tabla'=>trim($html),'contador'=>(count($registros)+1));
    }

    public function check_flag($value= 0,$primary_key=null)
    {
        if($value==1){ 
            $checked = 'checked="checked"'; 
        }else{ 
            $checked=''; 
        }
            return '<input id="field-cch_sobregirar" name="cch_sobregirar" type="checkbox" class="span12 nostyle" '.$checked.' value="'.$value.'">';
    }

    public function change_name($value, $row)
    {
        if($value == 1){
            return 'SI';
        }else{
            return 'NO';
        }
    }

    public function tipo_venta($titulo_per = null, $opc = null, $modulo = null) {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/tipo_venta');
            if($opc != null){
                $permisos = $opc;
            }
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpv_tipo_venta');
            $crud->set_subject('Tipo');

            $columnas = array(
                'tpv_nombre',
                'tpv_descripcion',
                'tpv_abreviacion',
                'tpv_defecto',
                'tpv_estado'
            );

            $add_fields = array(
                'tpv_nombre',
                'tpv_descripcion',
                'tpv_abreviacion',
                'tpv_defecto',
                'tpv_estado',
                'tpv_aplica_venta',
                'tpv_aplica_compra',
                'tpv_usu_creacion',
                'tpv_usu_modificacion',
                'tpv_fecha_creacion',
                'tpv_fecha_modificacion'
            );

            $edit_fields = array(
                'tpv_nombre',
                'tpv_descripcion',
                'tpv_abreviacion',
                'tpv_defecto',
                'tpv_aplica_venta',
                'tpv_aplica_compra',
                'tpv_estado',
                'tpv_usu_modificacion',
                'tpv_fecha_modificacion'
            );

            $required_fields = array(
                'tpv_nombre',
                'tpv_estado',
                'tpv_defecto',
                'tpv_usu_creacion',
                'tpv_usu_modificacion',
                'tpv_fecha_creacion',
                'tpv_fecha_modificacion'
            );

            $display_as = array(
                'tpv_nombre'        => 'Nombre',
                'tpv_descripcion'   => 'Descripción',
                'tpv_abreviacion'   => 'Abreviacion',
                'tpv_defecto'       => 'Defecto',
                'tpv_aplica_venta'  => 'Aplica Ventas',
                'tpv_aplica_compra' => 'Aplica Compras',
                'tpv_estado'        => 'Estado'
            );

            $crud->set_rules('tpv_nombre', 'Nombre', 'campo_unico[tpv_tipo_venta.tpv_nombre]|required');
            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->callback_column('tpv_defecto', function($value, $row) {
                $val = ($value == null || $value == 0)?'':'X';       
                return $val;                
            });
            $crud->callback_add_field('tpv_defecto', function() {
                return '<input type="checkbox" id="chkvalidar" class="nostyle chk"><input type="hidden" id="field-tpv_defecto" name="tpv_defecto" value="0">';
            });
            $crud->callback_add_field('tpv_aplica_venta', function() {
                return '<input type="checkbox" id="chkventa" class="nostyle chk" checked><input type="hidden" id="field-tpv_aplica_venta" name="tpv_aplica_venta" value="1">';
            });
            $crud->callback_add_field('tpv_aplica_compra', function() {
                return '<input type="checkbox" id="chkcompra" class="nostyle chk" checked><input type="hidden" id="field-tpv_aplica_compra" name="tpv_aplica_compra" value="1">';
            });
            $crud->callback_edit_field('tpv_defecto', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                $defecto = ($value)?'checked':''; 
                return '<input type="checkbox" id="chkvalidar" '.$defecto.' class="nostyle chk" '.$leer.'><input type="hidden" id="field-tpv_defecto" name="tpv_defecto" value="'.$value.'">';
            });
            $crud->callback_edit_field('tpv_aplica_venta', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                $defecto = ($value) ? 'checked' : ''; 
                return '<input type="checkbox" id="chkventa" '.$defecto.' class="nostyle chk" '.$leer.'><input type="hidden" id="field-tpv_aplica_venta" name="tpv_aplica_venta" value="'.$value.'">';
            });
            $crud->callback_edit_field('tpv_aplica_compra', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'readonly ':'';
                $defecto = ($value) ? 'checked' : ''; 
                return '<input type="checkbox" id="chkcompra" '.$defecto.' class="nostyle chk" '.$leer.'><input type="hidden" id="field-tpv_aplica_compra" name="tpv_aplica_compra" value="'.$value.'">';
            });

            $crud->callback_before_insert(function($post_array){
                if ($post_array['tpv_defecto'] > 0) {
                    $CI = & get_instance();
                    $CI->gsatelite->actualizar_array('tpv_tipo_venta', array('tpv_defecto'=>0), array());
                }
                return $post_array;
            });
            $crud->callback_before_update(function($post_array){
                if ($post_array['tpv_defecto'] > 0) {
                    $CI = & get_instance();
                    $CI->gsatelite->actualizar_array('tpv_tipo_venta', array('tpv_defecto'=>0), array());
                }                
                return $post_array;
            });
            $crud->field_type('tpv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tpv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tpv_estado', 'hidden', 1)
                        ->field_type('tpv_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tpv_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('tpv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                if($modulo == 'facturacion'){
                    $crud->add_action('Ver', 'minia-icon-search', 'facturacion/entradas/tipo_venta/read');
                } else{
                    $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/tipo_venta/read');
                }
            }

            $output = $crud->render();
            //Se cambio titulo_personal de 'Catalogo de Tipo venta' a 'Catálogo de Tipo de compra'

            $data['titulo_personal'] = "Catálogo de Tipo de compra";
            if($titulo_per != null && $titulo_per != 'add'){
                $data['titulo_personal'] = $titulo_per;
            }

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /*
     *
     * Descripcion: Funcion que permite dar mantenimiento a tipo factura desde el modulo de compras
     *
     */

    function tipo_factura() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/tipo_factura');
        $this->load->library('../controllers/facturacion/mantenimientos');
        $this->mantenimientos->tipo_factura($permisos);
    }

    function _cargarvista($data = 0, $crud = 0, $ruta_vista="") {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = (trim($ruta_vista) != '' )? trim($ruta_vista):$data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function tipo_seguimiento() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/tipo_seguimiento');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mts_motivo_seguimiento');
            $crud->set_subject('Tipo de seguimiento');

            $columnas = array(
                'mts_nombre',
                'mts_descripcion',
                'mts_estado'
            );

            $add_fields = array(
                'mts_nombre',
                'mts_descripcion',
                'mts_estado',
                'mts_usu_creacion',
                'mts_usu_modificacion',
                'mts_fecha_creacion',
                'mts_fecha_modificacion'
            );

            $edit_fields = array(
                'mts_nombre',
                'mts_descripcion',
                'mts_estado',
                'mts_usu_modificacion',
                'mts_fecha_modificacion'
            );

            $required_fields = array(
                'mts_nombre',
                'mts_estado',
                'mts_usu_creacion',
                'mts_usu_modificacion',
                'mts_fecha_creacion',
                'mts_fecha_modificacion'
            );

            $display_as = array(
                'mts_nombre' => 'Nombre',
                'mts_descripcion' => 'Descripción',
                'mts_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('mts_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('mts_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('mts_estado', 'hidden', 1)
                        ->field_type('mts_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('mts_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('mts_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/tipo_seguimiento/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipo de seguimiento";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /*
     * @author: Mario Marquez
     * $tipo 1 = Busca Nacionalidades 2 = Busca Departamentos 3 = Busca Municipios
     */

    public function get_localidades($id_filtro = null, $tipo = null) {
        $idLocalizacion = ($id_filtro != null) ? $id_filtro : $this->input->post('filtro');
        $tipoLocalidad = ($tipo != null) ? $tipo : $this->input->post('tipo');
        $opciones = "<option></option>";

        $where = null;
        switch ($tipoLocalidad) {
            case 1:
                if ($idLocalizacion != null) {
                    $where['pai_id'] = $idLocalizacion;
                    $where['pai_estado'] = 1;
                }
                $registros = $this->gsatelite->get_tabla('pai_pais', $where);
                foreach ($registros as $row) {
                    $opciones .= "<option value='" . $row['pai_id'] . "'>" . $row['pai_nombre'] . "</option>";
                }
                break;
            case 2:
                if ($idLocalizacion != null) {
                    $where['dep_id_pai'] = $idLocalizacion;
                    $where['dep_estado'] = 1;
                }
                $registros = $this->gsatelite->get_tabla('dep_departamento', $where);
                foreach ($registros as $row) {
                    $opciones .= "<option value='" . $row['dep_id'] . "'>" . $row['dep_nombre'] . "</option>";
                }
                break;
            case 3:
                if ($idLocalizacion != null) {
                    $where['mun_id_dep'] = $idLocalizacion;
                    $where['mun_estado'] = 1;
                }
                $registros = $this->gsatelite->get_tabla('mun_municipio', $where);
                foreach ($registros as $row) {
                    $opciones .= "<option value='" . $row['mun_id'] . "'>" . $row['mun_nombre'] . "</option>";
                }
                break;
            case 4:
                if ($idLocalizacion != null) {
                    $where['dis_id_mun'] = $idLocalizacion;
                    $where['dis_estado'] = 1;
                }
                $registros = $this->gsatelite->get_tabla('dis_distrito', $where);
                foreach ($registros as $row) {
                    $opciones .= "<option value='" . $row['dis_id'] . "'>" . $row['dis_nombre'] . "</option>";
                }
                break;
        }
        if ($tipo != null) {
            return $opciones;
        }
        echo $opciones;
    }

    public function tipo_pago() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/tipo_pago');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tpg_tipo_pago');
            $crud->set_subject('Tipo de pago');

            $columnas = array(
                'tpg_nombre',
                'tpg_estado'
            );

            $add_fields = array(
                'tpg_nombre',
                'tpg_estado',
                'tpg_usu_crea',
                'tpg_usu_mod',
                'tpg_fecha_crea',
                'tpg_fecha_mod'
            );

            $edit_fields = array(
                'tpg_nombre',
                'tpg_estado',
                'tpg_usu_mod',
                'tpg_fecha_mod'
            );

            $required_fields = array(
                'tpg_nombre',
                'tpg_estado',
                'tpg_usu_crea',
                'tpg_usu_mod',
                'tpg_fecha_crea',
                'tpg_fecha_mod'
            );

            $display_as = array(
                'tpg_nombre' => 'Nombre',
                'tpg_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('tpg_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tpg_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('tpg_nombre', 'Nombre', 'campo_unico[tpg_tipo_pago.tpg_nombre]|required');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tpg_estado', 'hidden', 1)
                        ->field_type('tpg_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tpg_fecha_crea', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('tpg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/tipo_pago/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipo de pago";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }
    
    public function agregar_retencion($modulo = NULL){        
        if ($_POST) {            
            //pestaña general
            $url_actual = (trim($this->input->post('url_actual')) != "") ? $this->input->post('url_actual') : null;
            $ret_nombre = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : '';
            $ret_defecto = ($this->input->post('defecto')!='') ? $this->input->post('defecto') : 0;
            $ret_porcentaje = (trim($this->input->post('porcentaje')) != "") ? $this->input->post('porcentaje') : 0;
            $ret_valor = (trim($this->input->post('txtValor')) != "") ? $this->input->post('txtValor') : 0;
            $ret_val_min = (trim($this->input->post('txtValorMin')) != "") ? $this->input->post('txtValorMin') : 0;
            $ret_aplica_renta = (trim($this->input->post('txt_aplica_reporte')) != "") ? $this->input->post('txt_aplica_reporte') : 0;

            //grid de la pestaña de finanzas
            $fin_cuenta = $this->input->post('fin_cuenta'); //array cnt            
            $fin_costo = $this->input->post('fin_costo'); //array cec
            $fin_porcentaje = $this->input->post('fin_porcentaje'); //array

            if($ret_nombre != null){
                //Agregar retencion
                $ret_retencion = array(
                    'ret_nombre'            => $ret_nombre,
                    'ret_defecto'           => $ret_defecto,
                    'ret_porcentaje'        => $ret_porcentaje,
                    'ret_valor'             => $ret_valor,
                    'ret_valor_minimo'      => $ret_val_min,
                    'ret_aplica_renta'      => $ret_aplica_renta,
                    'ret_estado'            => 1,            
                    'ret_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ret_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ret_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ret_fecha_modificacion'=> date('Y-m-d H:i:s')
                  );
                $ret_id = $this->gsatelite->ingresar('ret_retencion', $ret_retencion);
                
                $dcr_registros = array();
                for ($x = 0; $x < count($fin_cuenta) ; $x++) {
                    $fin_cuenta_reg = (trim($fin_cuenta[$x]) != "") ? $fin_cuenta[$x] : null;                    
                    $fin_costo_reg = (trim($fin_costo[$x]) != "") ? $fin_costo[$x] : null;
                    $fin_porcentaje_reg = (trim($fin_porcentaje[$x]) != "") ? $fin_porcentaje[$x] : 0;

                    $dcr_id_tcn = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $fin_cuenta_reg));
                    
                    if($fin_cuenta_reg != null){
                        $dcr_registros = array(
                            'dcr_id_cnt' => $fin_cuenta_reg,
                            'dcr_id_tcn' => $dcr_id_tcn[0]['cnt_id_tcn'],
                            'dcr_id_cec' => $fin_costo_reg,
                            'dcr_id_ret' => $ret_id,
                            'dcr_estado'=> 1,            
                            'dcr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dcr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dcr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dcr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->ingresar('dcr_detalle_cuenta_retencion', $dcr_registros);
                    }
                }
                //if(count($dcr_registros) > 0){
                    //$this->gsatelite->ingresar('dcr_detalle_cuenta_retencion', $dcr_registros, true);
                //}
                $respuesta = 1;                
            } else{
                $respuesta = 0;
            }
            
            if($respuesta>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
            $this->session->set_flashdata($alerta);
            
            $dir=$this->input->post('direccion');
            if($dir == 1){
                redirect($url_actual.'/agregar_retencion');
            }else if($dir == 2){
                redirect($url_actual.'/retenciones');  
            }
            // print_r($art_array); die();
        }else{
            //$data['cuen_con']=$this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado'=>1));
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $this->db->order_by('cnt_id','asc');
            $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);        

            $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["costos"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $url_array = explode('/', uri_string());
            $url = $url_array[0].'/'.$url_array[1];
            $data['url_actual'] = $url;

            $data['titulo_personal'] = "Agregar retención";
            //$this->_cargarvista($data);
            if ($modulo)
                return $data;
            $this->_cargarvista($data);
        }
    }//Fin agregar retencion

    /***************************** Editar retencion ********************************/
    public function editar_retencion($id_retencion=null, $modulo = NULL)
    {        
        satelite_validar();                
        if ($_POST) {                        
            //pestaña general            
            $url_actual = (trim($this->input->post('url_actual')) != "") ? $this->input->post('url_actual') : null;
            $ret_nombre = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
            $ret_defecto = ($this->input->post('defecto')!='') ? $this->input->post('defecto') : 0;
            $ret_porcentaje = (trim($this->input->post('porcentaje')) != "") ? $this->input->post('porcentaje') : 0;
            $ret_valor = (trim($this->input->post('txtValor')) != "") ? $this->input->post('txtValor') : 0;
            $ret_val_min = (trim($this->input->post('txtValorMin')) != "") ? $this->input->post('txtValorMin') : 0;
            $ret_aplica_renta = (trim($this->input->post('txt_aplica_reporte')) != "") ? $this->input->post('txt_aplica_reporte') : 0;

            //grid de la pestaña de finanzas
            $fin_cuenta = $this->input->post('fin_cuenta'); //array cnt
            $fin_costo = $this->input->post('fin_costo'); //array cec
            $fin_porcentaje = $this->input->post('fin_porcentaje'); //array


            if($ret_nombre != null){     
                $ret_retencion = array(
                    'ret_nombre'            => $ret_nombre,
                    'ret_defecto'           => $ret_defecto,
                    'ret_porcentaje'        => $ret_porcentaje,
                    'ret_valor'             => $ret_valor,
                    'ret_valor_minimo'      => $ret_val_min,
                    'ret_aplica_renta'      => $ret_aplica_renta,
                    'ret_estado'            => ($this->input->post('estado') > 0)? 1:0,  
                    'ret_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ret_fecha_modificacion'=> date('Y-m-d H:i:s')
                  );
                $ret_id = $this->gsatelite->actualizar_array('ret_retencion', $ret_retencion, array('ret_id' => $id_retencion));

                $this->gsatelite->borrado_general('dcr_detalle_cuenta_retencion', array('dcr_id_ret'=>$id_retencion));

                //Ingresando los registros en detalle 
                $dcr_registros = array();
                for ($x = 0; $x < count($fin_cuenta) ; $x++) {
                    $fin_cuenta_reg = (trim($fin_cuenta[$x]) != "") ? $fin_cuenta[$x] : null;                    
                    $fin_costo_reg = (trim($fin_costo[$x]) != "") ? $fin_costo[$x] : null;
                    $fin_porcentaje_reg = (trim($fin_porcentaje[$x]) != "") ? $fin_porcentaje[$x] : 0;

                    $dcr_id_tcn = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $fin_cuenta_reg));
                    
                    if($fin_cuenta_reg != null){
                        $dcr_registros = array(
                            'dcr_id_cnt' => $fin_cuenta_reg,
                            'dcr_id_tcn' => $dcr_id_tcn[0]['cnt_id_tcn'],
                            'dcr_id_cec' => $fin_costo_reg,
                            'dcr_id_ret' => $id_retencion,
                            'dcr_estado'=> 1,            
                            'dcr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dcr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dcr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dcr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    $this->gsatelite->ingresar('dcr_detalle_cuenta_retencion', $dcr_registros);
                    }
                }
                /**********************************************************/
                /*if(count($dtd_registros) > 0){
                    $this->gsatelite->ingresar('dtd_detalle_tipo_descuento', $dtd_registros, true);
                }*/
                $respuesta = 1;
            } else{
                $respuesta = 0;
            }
            
            if($respuesta>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
            $this->session->set_flashdata($alerta);

            $dir=$this->input->post('direccion');
            if($dir==1){
                redirect($url_actual.'/editar_retencion/'.$id_retencion);
            }else if($dir==2){
                redirect($url_actual.'/retenciones');  
            }
        }else{
            $data['defecto'] = array('0' => 'No Aplica', '1'=> 'Aplica');
            $data['estado'] = array('0' => 'Inactivo', '1'=> 'Activo');
            $data['id_retencion'] = $id_retencion;
            //General
            $tb_retencion = $this->gsatelite->get_tabla('ret_retencion', array('ret_id' => $id_retencion));            
            $data['ret_nombre'] = $tb_retencion[0]['ret_nombre'];
            $data['ret_porcentaje'] = $tb_retencion[0]['ret_porcentaje'];
            $data['ret_valor'] = $tb_retencion[0]['ret_valor'];
            $data['ret_valor_min'] = $tb_retencion[0]['ret_valor_minimo'];
            $data['ret_defecto'] = $tb_retencion[0]['ret_defecto'];
            $data['ret_estado'] = $tb_retencion[0]['ret_estado'];  

            $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            //$data['decimales'] = ($decimales)?$decimales:2;   
            $data['decimales'] = 2; // Se colocan dos decimales de acuerdo a la configuración en BD

            //Finanza
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $this->db->order_by('cnt_id','asc');
            $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);            

            $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["costos"] = str_replace('<option value="0">Seleccione</option>', '', $select);            
            
            $this->db->join('dcr_detalle_cuenta_retencion','ret_id = dcr_id_ret')
                     ->join('cnt_cuenta_contable','cnt_id = dcr_id_cnt','left')
                     ->join('cec_centro_costo','cec_id = dcr_id_cec','left');                                                    
            $data['grid_finanza'] = $this->gsatelite->get_tabla('ret_retencion', array('ret_id'=>$id_retencion));

            $url_array = explode('/', uri_string());
            $url = $url_array[0].'/'.$url_array[1];
            $data['url_actual'] = $url;

            $data['titulo_personal'] = "Editar retención";
            //$this->_cargarvista($data, null);
            if ($modulo)
                return $data;
            $this->_cargarvista($data, null);
        }
    }    
    /****************************Fin editar retencion**********************************/    

    /****************************Ver retencion***************************************/
    public function ver_retencion($id_retencion=null, $modulo = NULL)
    {        
        satelite_validar();        
        if ($_POST) {             
            //pestaña general            
            $ret_nombre = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
            $ret_porcentaje = (trim($this->input->post('porcentaje')) != "") ? $this->input->post('porcentaje') : null;
            $ret_defecto = ($this->input->post('defecto')) ? $this->input->post('defecto') : null;
            //grid de la pestaña de finanzas
            $fin_cuenta = $this->input->post('fin_cuenta'); //array cnt
            $fin_costo = $this->input->post('fin_costo'); //array cec
            $fin_porcentaje = $this->input->post('fin_porcentaje'); //array

            if($ret_nombre != null){                                
                $this->gsatelite->borrado_general('dcr_detalle_cuenta_retencion', array('dcr_id_ret'=>$id_retencion));

                //Ingresando los registros en detalle 
                $dcr_registros = array();
                for ($x = 0; $x < count($fin_cuenta) ; $x++) {
                    $fin_cuenta_reg = (trim($fin_cuenta[$x]) != "") ? $fin_cuenta[$x] : null;                    
                    $fin_costo_reg = (trim($fin_costo[$x]) != "") ? $fin_costo[$x] : null;
                    $fin_porcentaje_reg = (trim($fin_porcentaje[$x]) != "") ? $fin_porcentaje[$x] : 0;

                    $dcr_id_tcn = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $fin_cuenta_reg));
                    
                    if($fin_cuenta_reg != null){
                        $dcr_registros = array(
                            'dcr_id_cnt' => $fin_cuenta_reg,
                            'dcr_id_tcn' => $dcr_id_tcn[0]['cnt_id_tcn'],
                            'dcr_id_cec' => $fin_costo_reg,
                            'dcr_id_ret' => $id_retencion,
                            'dcr_estado'=> 1,            
                            'dcr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dcr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dcr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dcr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }
                    $this->gsatelite->ingresar('dcr_detalle_cuenta_retencion', $dcr_registros);
                }
                /**********************************************************/
                /*if(count($dtd_registros) > 0){
                    $this->gsatelite->ingresar('dtd_detalle_tipo_descuento', $dtd_registros, true);
                }*/
                $respuesta = 1;
            } else{
                $respuesta = 0;
            }
            
            if($respuesta>0){
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Procesado",'texto_alerta'=>"Registro(s) ingresado(s) con éxito");
            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Error",'texto_alerta'=>"Ocurrió un error al ingresar la información");
            }
            $this->session->set_flashdata($alerta);

            $dir=$this->input->post('direccion');
            if($dir==1){
                redirect('modulo_compras/catalogos/editar_retencion/'.$id_retencion);
            }else if($dir==2){
                redirect('modulo_compras/catalogos/retenciones');  
            }
        }else{            
            $data['defecto'] = array('0' => 'No Aplica', '1'=> 'Aplica');
            $data['id_retencion'] = $id_retencion;
            //General
            $tb_retencion = $this->gsatelite->get_tabla('ret_retencion', array('ret_id' => $id_retencion));            
            $data['ret_nombre'] = $tb_retencion[0]['ret_nombre'];
            $data['ret_porcentaje'] = $tb_retencion[0]['ret_porcentaje'];
            $data['ret_defecto'] = $tb_retencion[0]['ret_defecto'];    
            $data['ret_valor'] = $tb_retencion[0]['ret_valor'];
            $data['ret_valor_min'] = $tb_retencion[0]['ret_valor_minimo'];        
            //Finanza
            $this->db->order_by('cnt_id','asc');
            $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);            

            $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["costos"] = str_replace('<option value="0">Seleccione</option>', '', $select);            
            
            $this->db->join('dcr_detalle_cuenta_retencion','ret_id = dcr_id_ret')
                     ->join('cnt_cuenta_contable','cnt_id = dcr_id_cnt','left')
                     ->join('cec_centro_costo','cec_id = dcr_id_cec','left');                                                    
            $data['grid_finanza'] = $this->gsatelite->get_tabla('ret_retencion', array('ret_id'=>$id_retencion));

            $url_array = explode('/', uri_string());
            $url = $url_array[0].'/'.$url_array[1];
            $data['url_actual'] = $url;  

            $data['titulo_personal'] = "Ver retención";
            if ($modulo)
                return $data;
            $this->_cargarvista($data, null);
        }
    }    
    /****************************Fin ver retencion***************************************/

    public function validar_nombre(){
        $nombre = $this->input->post('nombre');  
        $id = $this->input->post('id');   

        if($id>0){ $this->db->where('ret_id <>', $id); }     
        $nombres = $this->gsatelite->get_tabla('ret_retencion');
        $resp = 0;
        
        $nombre_min = strtolower($nombre);
        foreach ($nombres as $nom) {
        $nombre_base = strtolower($nom['ret_nombre']);
          if ($nombre_base == $nombre_min) {
              $resp = 1;
              echo json_encode(array('resp'=>$resp));
              die();
          }
        }
        
        echo json_encode(array('resp'=>$resp));
    }

    /**
     * @author Elman Ortiz
     * @return Mantenimiento cec_centro_costo
     */
    function centro_costos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/centro_costos');
                $crud = new grocery_CRUD();
                $crud->set_table('cec_centro_costo')
                        ->set_subject('Centro de costo')
                        //->columns('cec_nombre', 'cec_observacion', 'cec_cuenta_contable', 'cec_estado')
                        ->columns('cec_nombre', 'cec_observacion', 'cec_estado')
                        //->fields('cec_nombre', 'cec_observacion', 'cec_cuenta_contable', 'cec_estado', 'cec_usu_mod', 'cec_fecha_mod')
                        ->fields('cec_nombre', 'cec_observacion', 'cec_estado', 'cec_usu_mod', 'cec_fecha_mod')
                        ->display_as('cec_nombre', 'Nombre')
                        ->display_as('cec_observacion', 'Observación')
                        ->display_as('cec_cuenta_contable', 'Cuenta Contable')
                        ->display_as('cec_estado', 'Estado')
                        ->required_fields('cec_nombre', 'cec_estado')
                        ->set_rules('cec_nombre', 'Nombre', 'trim|required|campo_unico[cec_centro_costo.cec_nombre]')
                        ->field_type('cec_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('cec_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('cec_estado', 'hidden', 1);
                } else {
                    $crud->field_type('cec_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                 // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/centro_costos/read');
                }

                $data['titulo_personal'] = "Centro de costos";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
    * @author Edith Herrera
    * @since  2018-02-06
    * @return Clasificación del proveedor
    **/
    function clasificacion_proveedor() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        
        $crud = new grocery_CRUD;
        $alias = array(
            'clp_codigo' => 'Código',
            'clp_nombre' => 'Nombre',
            'clp_descripcion'=>'Descripcion',
            'clp_prefijo'=>'Prefijo',
            'clp_estado' => 'Estado'
            );

        $colums = array(
            'clp_codigo',
            'clp_nombre',
            'clp_descripcion',
            'clp_prefijo',
            'clp_estado'
            );

        $edit = array(
            'clp_codigo',
            'clp_nombre',
            'clp_descripcion',
            'clp_prefijo',
            'clp_estado',
            'clp_usu_modificacion',
            'clp_fecha_modificacion'
            );

        $add = array(
            'clp_codigo',
            'clp_nombre',
            'clp_descripcion',
            'clp_prefijo',
            'clp_estado',
            'clp_usu_creacion',
            'clp_fecha_creacion',
            'clp_usu_modificacion',
            'clp_fecha_modificacion'
        );

        $required = array(
            'clp_nombre',
            'clp_estado',
            'clp_usu_creacion',
            'clp_fecha_creacion',
            'clp_usu_modificacion',
            'clp_fecha_modificacion'
        );

        $crud->set_table('clp_clasificacion_proveedor')
                ->set_subject('Clasificación')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($required)
                ->field_type('clp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('clp_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->set_rules('clp_nombre', 'Nombre', 'trim|required|campo_unico[clp_clasificacion_proveedor.clp_nombre]')
                ->unset_delete()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('clp_estado', 'hidden', 1)
                    ->field_type('clp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('clp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('clp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/clasificacion_proveedor/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Clasificación de proveedor";
        $this->_cargarvista($data, $output);
    }

    /**
    * @author Luis Navarro
    * @since  05/03/2018
    * @return generar codigo sugerido para proveedores.
    */
    public function generar_codigo_proveedor() {
        satelite_validar(true);
        if ($this->input->post()){  
            $clasificacion_id   = $this->input->post("clasificacion");
            $clasificacion      = $this->gsatelite->get_campo("clp_clasificacion_proveedor","clp_prefijo",array("clp_id" => $clasificacion_id));
            $proveedor          = ($this->input->post("proveedor") != null)?$this->input->post("proveedor"):0;
            $cantidad           = $this->gsatelite->count("prv_proveedor",array("prv_id_clp" => $clasificacion_id));
            $result             = trim($clasificacion.str_pad($cantidad + 1 , 4, "0", STR_PAD_LEFT));
            $i                  = 1;
            $clasificacion_old  = NULL;

            if ( $proveedor != 0) {
                $clasificacion_old = $this->gsatelite->get_tabla("cli_cliente",array("cli_id" => $proveedor));
                if ($clasificacion_old[0]["prv_id_clp"] != $clasificacion_id ) {
                    while ( $this->gsatelite->get_campo("prv_proveedor","prv_id",array("prv_codigo" => $result)) != NULL ) {
                        $i++;
                        $result             = $clasificacion.str_pad($cantidad+ $i , 4, "0", STR_PAD_LEFT);
                    }
                } else {
                    $clasificacion_old[0]["prv_codigo"];
                }
            } else {
                while ( $this->gsatelite->get_campo("prv_proveedor","prv_codigo",array("prv_codigo" => $result)) != NULL ) {
                    $i++;
                    $result             = $clasificacion.str_pad($cantidad+ $i , 4, "0", STR_PAD_LEFT);
                }
            }
            echo $result;
        }
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a los tipos de transporte (tabla: ttr_tipo_transporte)
     * Funcionalidad Compartida del Modulo de Registro Academico - Tipo de Transporte
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-06-26
     * @param ninguno
     * @return Mantenimiento de tipo de transporte
     */
    public function tipo_transporte() {
        satelite_validar();
        $this->load->library('../controllers/registro_academico/mantenimientos');
        $this->mantenimientos->tipo_transporte();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Incoterms  (tabla: inr_incoterms)
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-06-26
     * @param $ruta_vista = Asignar otra vista(opcional)
     * @return Mantenimiento de Incoterms
     */
    public function incoterms($ruta_vista = null){
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        //cuando viene la petición de otro modulo.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'modulo_compras/catalogos/incoterms'; 
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        $columns = array(
            'inr_nombre', 
            'inr_descripcion',
            'inr_estado'
        );

        $display_as = array(
            'inr_nombre'        => 'Nombre',
            'inr_descripcion'   => 'Descripción',
            'inr_estado'        => 'Estado'
        );

        $add_fields = array(
            'inr_nombre', 
            'inr_descripcion',
            'inr_estado',
            'inr_usu_creacion',
            'inr_fecha_creacion',
            'inr_usu_modificacion',
            'inr_fecha_modificacion'
        );

        $edit_fields = array(
            'inr_nombre', 
            'inr_descripcion',
            'inr_estado',
            'inr_usu_modificacion',
            'inr_fecha_modificacion'
        );

        $required = array(
            'inr_nombre',
            'inr_estado'
        );

        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud =  new grocery_CRUD();
        $crud->set_subject('Incoterms');
        $crud->set_table('inr_incoterms');
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->required_fields($required);
        $crud->set_rules('inr_nombre','nombre','trim|required|campo_unico[inr_incoterms.inr_nombre]');
        $crud->set_rules('inr_estado','estado','trim|required');
        $crud->field_type('inr_usu_creacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('inr_usu_modificacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('inr_fecha_creacion','hidden',date('Y-m-d H:i:s'));
        $crud->field_type('inr_fecha_modificacion','hidden',date('Y-m-d H:i:s'));

        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('inr_estado','hidden',1);
        }else {
            $crud->field_type('inr_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }
        if(!$permisos["permite_agregar"]){
            $crud->unset_add();
        }
        if(!$permisos["permite_ver"]){
            $crud->unset_read();
        } else {
            $data_url = $this->masterpage->getUsuario();
            $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
            $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        }

        $output = $crud->render();
        $data['titulo_personal']="Incoterms";
        $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'modulo_compras/catalogos/incoterms';
        cargarvista($data, $output, $ruta_vista);
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Tipo de monto  (tabla: tmt_tipo_monto)
     * @author Habby Lovo - Grupo Satélite
     * @since 2019-03-04
     * @param $ruta_vista = Asignar otra vista(opcional)
     * @return Mantenimiento de tipo de monto
     */
    public function tipo_monto($ruta_vista = null){
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        //cuando viene la petición de otro modulo.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'modulo_compras/catalogos/tipo_monto'; 
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        $columns = array(
            'tmt_codigo', 
            'tmt_nombre',
            'tmt_estado'
        );

        $display_as = array(
            'tmt_codigo'        => 'Codigo',
            'tmt_nombre'        => 'Nombre',
            'tmt_estado'        => 'Estado'
        );

        $add_fields = array(
            'tmt_codigo', 
            'tmt_nombre',
            'tmt_estado',
            'tmt_usu_creacion',
            'tmt_fecha_creacion',
            'tmt_usu_modificacion',
            'tmt_fecha_modificacion'
        );

        $edit_fields = array(
            'tmt_codigo', 
            'tmt_nombre',
            'tmt_estado',
            'tmt_usu_modificacion',
            'tmt_fecha_modificacion'
        );

        $required = array(
            'tmt_nombre',
            'tmt_estado'
        );

        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud =  new grocery_CRUD();
        $crud->set_subject('Tipo de monto');
        $crud->set_table('tmt_tipo_monto');
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->required_fields($required);
        $crud->set_rules('inr_nombre','nombre','trim|required|campo_unico[tmt_tipo_monto.tmt_nombre]');
        $crud->set_rules('tmt_estado','estado','trim|required');
        $crud->field_type('tmt_usu_creacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('tmt_usu_modificacion','hidden',$this->tank_auth->get_user_id());
        $crud->field_type('tmt_fecha_creacion','hidden',date('Y-m-d H:i:s'));
        $crud->field_type('tmt_fecha_modificacion','hidden',date('Y-m-d H:i:s'));

        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('tmt_estado','hidden',1);
        }else {
            $crud->field_type('tmt_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }
        if(!$permisos["permite_agregar"]){
            $crud->unset_add();
        }
        if(!$permisos["permite_ver"]){
            $crud->unset_read();
        } else {
            $data_url = $this->masterpage->getUsuario();
            $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
            $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        }

        $output = $crud->render();
        $data['titulo_personal']="Tipo de montos";
        $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'modulo_compras/catalogos/tipo_monto';
        cargarvista($data, $output, $ruta_vista);
    }

    /**
    * @author Habby Lovo
    * @since 2019-03-04
    * @return Mantenimiento tabla tipo_documento, se copio de expediente personal
    */
    function tipo_documento($url_vista='') {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de documento');
            $crud->set_table('tde_tipo_documento');

            $columns = array(
                'tde_nombre', 
                'tde_mascara',
                'tde_codigo_hacienda',
                'tde_estado'
            );

            $display_as = array(
                'tde_nombre'    => 'Nombre',
                'tde_mascara'   => 'Máscara',
                'tde_codigo_hacienda'   => 'Código',
                'tde_estado'    => 'Estado'
            );

            $fields = array(
                'tde_nombre', 
                'tde_mascara',
                'tde_codigo_hacienda',
                'tde_estado', 
                'tde_usu_mod', 
                'tde_fecha_mod'
            );

            $required = array(
                'tde_nombre', 
                'tde_estado'
            );

            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->fields($fields);
            $crud->required_fields($required);
            $crud->set_rules('tde_nombre', 'Nombre', 'trim|required|campo_unico[tde_tipo_documento.tde_nombre]');
            $crud->field_type('tde_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tde_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tde_estado', 'hidden', 1);
            } else {
                $crud->field_type('tde_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            
            $output    = $crud->render();
            $data['titulo_personal'] = "Tipos de documentos";
            cargarvista($data, $output, 'modulo_compras/catalogos/tipo_documento');
        }
    }

    /**
     * Descripción:
     * Validacion para eliminar al proveedor
     * @author Nelson Soriano
     * @since  22-03-2019
     * @param  id_proveedor
     * @return 1 si procede, 2 si contiene dependecias y no procede
     */
    public function validar_eliminar_prv(){
        satelite_validar();
        $id  = $this->input->post('id_proveedor_x');
        if ($id > 0) {
            $data = $this->gsatelite->get_tabla('dpv_documento_proveedor',array('dpv_id_prv' => $id));
            if (count($data)>0) {
                $flag = 2;
            }else{
                $flag = 1;
                $array_prv = array('prv_estado' => 0);
                $this->gsatelite->actualizar_array('prv_proveedor',$array_prv,array('prv_id' => $id));
            }
            echo json_encode(array('procede' => $flag));
        }
    }

    /**
     * Descripción:
     * Validacion codigo de proveedor
     * @author Marlon Olmedo
     * @since  24-07-2020
     * @param  codigo proveedor
     * @return cantidad de registros con el mismo codigo
     */
    public function validar_codigo_prv() {
        satelite_validar();
        $codigo_prv  = $this->input->post('codigo_prv');
        
        $proveedores = $this->gsatelite->get_tabla('prv_proveedor',array('prv_codigo' => trim($codigo_prv)));
            
        echo json_encode(array('prv_cantidad' => count($proveedores)));
        die();
    }

} // End class
