<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('avisos_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index() {
        satelite_validar();
        $data['titulo_personal'] = 'Modulo de Avisos';
        cargarvista($data);
    }

    function avisos($consulta = 0) {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($this->input->post()) {
            if ($consulta > 0) {
                $post_array = $this->input->post();

                $fecha_inicio = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];

                $where = null;

                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $where['DATE(avi_fecha) >='] = formatear_fecha('Y-m-d', $fecha_inicio);
                    $where['DATE(avi_fecha) <='] = formatear_fecha('Y-m-d', $fecha_fin);
                }

                $avisos = $this->avisos_model->get_avisos($where);

                $data['avisos'] = $avisos;

                $html = $this->load->view('modulo_avisos/procesos/consultar_avisos', $data, true);

                echo $html;
                die();
            }
        } else {
            $data['titulo_personal'] = 'Listado de Avisos';
            cargarvista($data);
        }
    }

    function agregar_aviso() {
        satelite_validar();
        try {
            $num_actual = $this->gsatelite->count('avi_aviso');
            $num_actual += 1;
            //Se genera el codigo del aviso
            $codigo_aviso = 'A' . generar_codigo_cor($num_actual, 4);
            if ($this->input->post()) {
                $post_array = $this->input->post();
                $alerta = "";
                $tipo_btn = $post_array['btnCrear'];
                //var_dump($post_array);die();
                $nombreArchivo = trim($post_array['foto_empleado']);
                $carpeta_destino_anx = ($nombreArchivo != "") ? "uploads/anx_avisos/" . $nombreArchivo : "";
                $aviso_array = array(
                    'avi_id_usu' => $this->tank_auth->get_user_id(),
                    'avi_codigo' => $codigo_aviso,
                    'avi_asunto' => $post_array['txtAsunto'],
                    'avi_detalle' => $post_array['txtDetalles'],
                    'avi_fecha_hasta' => formatear_fecha('Y-m-d', $post_array['txtFechaHasta']),
                    'avi_fecha_desde' => formatear_fecha('Y-m-d', $post_array['txtFechaDesde']),
                    'avi_url_imagen' => $carpeta_destino_anx,
                    'avi_fecha' => date('Y-m-d H:i:s'),
                    'avi_publico' => $post_array['avi_publico'],
                    'avi_estado' => 1,
                    'avi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'avi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'avi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'avi_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $avi_id = $this->gsatelite->ingresar('avi_aviso', $aviso_array);

                if ($avi_id > 0) {
                    $lstRoles = $post_array["slcRoles"];
                    if (count($lstRoles) > 0) {
                        for ($i = 0; $i < count($lstRoles); $i++) {
                            $rol_array = array(
                                'vxr_id_avi' => $avi_id,
                                'vxr_id_rol' => $lstRoles[$i],
                                'vxr_estado' => 1,
                                'vxr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'vxr_fecha_creacion' => date('Y-m-d H:i:s'),
                                'vxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'vxr_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $vxr_id = $this->gsatelite->ingresar('vxr_avisoxrol', $rol_array);
                        }
                    }

                    $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($post_array['foto_empleado']);
                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    unlink($carpeta_temporal_anx);


                    //Anexos
                    $TitulosAnexo = $post_array['titulo_doc'];
                    $NombreAnexo = $post_array['ruta'];

                    //Anexos
                    if (count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {
                            $extension = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);

                            $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                            $carpeta_destino_anx = "uploads/anx_avisos/" . $nombreArchivo;

                            $documentos_array = array(
                                'ani_id_avi' => $avi_id,
                                'ani_url' => $carpeta_destino_anx,
                                'ani_nombre' => $nombreArchivo,
                                'ani_estado' => 1,
                                'ani_usu_creacion' => $this->tank_auth->get_user_id(),
                                'ani_fecha_creacion' => date('Y-m-d H:i:s'),
                                'ani_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'ani_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );

                            $ani_id = $this->gsatelite->ingresar('ani_anexo_aviso', $documentos_array);

                            if ($ani_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aviso", 'texto_alerta' => "El aviso " . $codigo_aviso . " se guardo correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Aviso", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_avisos/procesos/agregar_aviso');
                } else if ($tipo_btn == 2) {
                    redirect('modulo_avisos/procesos/avisos');
                }
            }
            $data['codigo_aviso'] = $codigo_aviso;
            $data['lstRoles'] = $this->gsatelite->get_dropdown('rol_rol', 'rol_nombre', '', array('rol_estado' => 1), null, null, null, true);
            $data['infoUsuario'] = $this->avisos_model->get_info_usuario(array('id' => $this->tank_auth->get_user_id()));
            $data['titulo_personal'] = 'Agregar Aviso';
            cargarvista($data);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    function editar_aviso($avi_id, $ver_detalle = 0) {
        satelite_validar();
        try {
            if ($this->input->post()) {
                $post_array = $this->input->post();
                $alerta = "";
                $tipo_btn = $post_array['btnCrear'];
                //var_dump($post_array);die();
                $nombreArchivo = trim($post_array['foto_empleado']);
                $carpeta_destino_anx = ($nombreArchivo != "") ? "uploads/anx_avisos/" . $nombreArchivo : "";
                $AnexoDpv = (isset($post_array['AnexoDpv'])) ? $post_array['AnexoDpv'] : null;
                //Anexos
                $TitulosAnexo = $post_array['titulo_doc'];
                $NombreAnexo = $post_array['ruta'];

                $aviso_array = array(
                    'avi_asunto' => $post_array['txtAsunto'],
                    'avi_detalle' => $post_array['txtDetalles'],
                    'avi_fecha_hasta' => formatear_fecha('Y-m-d', $post_array['txtFechaHasta']),
                    'avi_fecha_desde' => formatear_fecha('Y-m-d', $post_array['txtFechaDesde']),
                    'avi_url_imagen' => $carpeta_destino_anx,
                    'avi_publico' => $post_array['avi_publico'],
                    'avi_estado' => 1,
                    'avi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'avi_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $resultado = $this->gsatelite->actualizar_array('avi_aviso', $aviso_array, array('avi_id' => $avi_id));

                if ($resultado > 0) {
                    $lstRoles = $post_array["slcRoles"];

                    //Se elimina el detalle de roles
                    $this->gsatelite->borrado_general('vxr_avisoxrol', array('vxr_id_avi' => $avi_id));
                    if (count($lstRoles) > 0) {
                        for ($i = 0; $i < count($lstRoles); $i++) {
                            $rol_array = array(
                                'vxr_id_avi' => $avi_id,
                                'vxr_id_rol' => $lstRoles[$i],
                                'vxr_estado' => 1,
                                'vxr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'vxr_fecha_creacion' => date('Y-m-d H:i:s'),
                                'vxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'vxr_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $vxr_id = $this->gsatelite->ingresar('vxr_avisoxrol', $rol_array);
                        }
                    }

                    $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($post_array['foto_empleado']);

                    if (file_exists($carpeta_temporal_anx)) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }


                    //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                    $dataAnexos = $this->gsatelite->get_tabla('ani_anexo_aviso', array('ani_id_avi' => $avi_id));
                    if (!is_array($AnexoDpv)) {
                        $AnexoDpv = array();
                    }
                    foreach ($dataAnexos as $data) {
                        if (!in_array($data['ani_id'], $AnexoDpv)) {
                            $this->gsatelite->borrado_general('ani_anexo_aviso', array('ani_id' => $data['ani_id']));
                            $ruta_nxp = $data['ani_url'];
                            unlink($ruta_nxp);
                        }
                    }

                    //Anexos
                    if (count($NombreAnexo) > 0) {
                        for ($i = 0; $i < count($NombreAnexo); $i++) {
                            $extension = end(explode('.', $NombreAnexo[$i]));
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);

                            $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                            $carpeta_destino_anx = "uploads/anx_avisos/" . $nombreArchivo;

                            $documentos_array = array(
                                'ani_id_avi' => $avi_id,
                                'ani_url' => $carpeta_destino_anx,
                                'ani_nombre' => $nombreArchivo,
                                'ani_estado' => 1,
                                'ani_usu_creacion' => $this->tank_auth->get_user_id(),
                                'ani_fecha_creacion' => date('Y-m-d H:i:s'),
                                'ani_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'ani_fecha_modificacion' => date('Y-m-d H:i:s'),
                            );

                            $ani_id = $this->gsatelite->ingresar('ani_anexo_aviso', $documentos_array);

                            if ($ani_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aviso", 'texto_alerta' => "El aviso " . $codigo_aviso . " se guardo correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Aviso", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('modulo_avisos/procesos/editar_aviso/' . $avi_id);
                } else if ($tipo_btn == 2) {
                    redirect('modulo_avisos/procesos/avisos');
                }
            }
            $infoAviso = $this->gsatelite->get_tabla('avi_aviso', array('avi_id' => $avi_id));
            $data["infoAviso"] = $infoAviso[0];
            //var_dump($data["infoAviso"]);die();
            $lstRolAviso = $this->gsatelite->get_tabla('vxr_avisoxrol', array('vxr_id_avi' => $avi_id));
            $data['lstRoles'] = $this->gsatelite->get_dropdown('rol_rol', 'rol_nombre', '', array('rol_estado' => 1), array_column($lstRolAviso, 'vxr_id_rol'), null, null, true);
            $data['infoUsuario'] = $this->avisos_model->get_info_usuario(array('id' => $this->tank_auth->get_user_id()));
            $data['anexos_aviso'] = $this->gsatelite->get_tabla('ani_anexo_aviso', array('ani_id_avi' => $avi_id));

            $data['titulo_personal'] = 'Agregar Aviso';
            $data['ver_detalle'] = $ver_detalle;

            if ($ver_detalle == 1) {
                $this->gsatelite->cargar_vista_masterpage('modulo_avisos/procesos/editar_aviso', $data, true);
            } else {
                cargarvista($data);
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    function eliminar_aviso($avi_id) {

        if ($avi_id > 0) {

            $infoAviso = $this->gsatelite->get_tabla('avi_aviso', array('avi_id' => $avi_id));

            //Se eliminan los anexos
            $this->gsatelite->borrado_general('ani_anexo_aviso', array('ani_id_avi' => $avi_id));
            //Se elimina el detalle de roles
            $this->gsatelite->borrado_general('vxr_avisoxrol', array('vxr_id_avi' => $avi_id));
            //Se borra el aviso
            $this->gsatelite->borrado_general('avi_aviso', array('avi_id' => $avi_id));

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Aviso", 'texto_alerta' => "El aviso " . $infoAviso[0]['avi_codigo'] . " se eliminó correctamente.");
            $this->session->set_flashdata($alerta);

            redirect('modulo_avisos/procesos/avisos');
        }
    }

    function cartelera_avisos(){
    	satelite_validar();
        
        //Se obtienen los avisos segun la fecha
        $where = 'DATE(NOW()) BETWEEN DATE(avi_fecha_desde) AND DATE(avi_fecha_hasta) AND avi_estado = 1 and uxr_id_usu = '.$this->tank_auth->get_user_id();
        $where .= " or avi_id_usu = ".$this->tank_auth->get_user_id();
        $data['lstAvisos'] = $this->avisos_model->get_avisos_usuario($where);
        //print_r($this->db->last_query());die();
        $data['titulo_personal'] = 'Cartelera de Avisos';
        cargarvista($data);
    }

}

// End class
