<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('tank_auth');
        $this->load->model('gsatelite');
        $this->load->model('planilla_model');
        $this->load->model('personal_model');
        $this->load->model('accion_personal_model');
        $this->load->model('marcacion_model');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * @author René Castaneda
     * @return gestión de turnos
     */
    public function turno() {
        satelite_validar();
        if ($_POST) {
            // die(var_dump($_POST));
            $insert_turno = array(
                'tur_id_tiu' => $this->input->post('tipo_turno')
                , 'tur_nombre' => $this->input->post('nombre_turno')
                , 'tur_descuento_automatico' => $this->input->post('desc_auto')
                , 'tur_descripcion' => $this->input->post('descripcion_turno')
                , 'tur_estado' => $this->input->post('estado_turno')
                , 'tur_permite_traslape' => $this->input->post('hidden_permite_traslape_dias')
                , 'tur_usu_mod' => $this->tank_auth->get_user_id()
                , 'tur_fecha_mod' => date("Y-m-d H:i:s")
            );
            $id_turno = $this->gsatelite->ingresar('tur_turno', $insert_turno);

            $detalles = $this->input->post('detalle_h');
            $dia = $this->input->post('detalle_h_dia');
            for ($i = 0; $i < count($detalles); $i++) {
                if ($detalles[$i] > 0 and $dia[$i] > 0) {
                    $insert_detalle = array(
                        'dxt_id_tur' => $id_turno
                        , 'dxt_id_deh' => $detalles[$i]
                        , 'dxt_id_dia' => $dia[$i]
                        , 'dxt_estado' => 1
                        , 'dxt_usu_mod' => $this->tank_auth->get_user_id()
                        , 'dxt_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->ingresar('dxt_detallexturno', $insert_detalle);
                }
            }

            $boton = $this->input->post('boton');
            if ($boton == '2') {
                redirect('marcacion/procesos/vista_turno');
            }
            if ($boton == '1') {
                $this->gsatelite->show_dialog('Turno ingresado con éxito', 'marcacion/procesos/turno', 'success');
            }
        } else {
            $datos['titulo_personal'] = "Gestión de turnos";
            $this->_cargarvista($datos, null);
        }
    }

    /**
     * @author René Castaneda
     * @return gestión de turnos
     */
    public function editar_turno($id = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('tur_turno', $id);
        if ($_POST) {
            $id = $this->input->post('id_turno');
            $update_turno = array(
                'tur_id_tiu' => $this->input->post('tipo_turno')
                , 'tur_nombre' => $this->input->post('nombre_turno')
                , 'tur_descuento_automatico' => $this->input->post('desc_auto')
                , 'tur_descripcion' => $this->input->post('descripcion_turno')
                , 'tur_estado' => $this->input->post('estado_turno')
                , 'tur_permite_traslape' => $this->input->post('hidden_permite_traslape_dias')
                , 'tur_usu_mod' => $this->tank_auth->get_user_id()
                , 'tur_fecha_mod' => date("Y-m-d H:i:s")
            );
            $this->gsatelite->actualizar_array('tur_turno', $update_turno, array('tur_id' => $id));

            //ACTUALIZAR LOS DETALLES DE HORARIO
            //preguntar por los existentes
            $consul = $this->gsatelite->get_tabla('dxt_detallexturno', array('dxt_id_tur' => $id));
            $seleccionados_activos = array();
            $seleccionados_deh = array();
            $seleccionados_dia = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['dxt_id_deh'] . $f['dxt_id_dia'];
                $seleccionados_deh[] = $f['dxt_id_deh'];
                $seleccionados_dia[] = $f['dxt_id_dia'];
            }

            $array_datos = $this->input->post('detalle_h');
            $array_datos_dia = $this->input->post('detalle_h_dia');
            $array_concatenado = array();
            for ($i = 0; $i < count($array_datos); $i++) {
                if ($array_datos[$i] > 0 and $array_datos_dia[$i] > 0) {
                    $array_concatenado[] = $array_datos[$i] . $array_datos_dia[$i];
                    if (!in_array($array_datos[$i] . $array_datos_dia[$i], $seleccionados_activos)) { //preguntar si se ha elegido uno nuevo
                        $insert_detalle = array(
                              'dxt_id_tur' => $id
                            , 'dxt_id_deh' => $array_datos[$i]
                            , 'dxt_id_dia' => $array_datos_dia[$i]
                            , 'dxt_estado' => 1
                            , 'dxt_usu_mod' => $this->tank_auth->get_user_id()
                            , 'dxt_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $this->gsatelite->ingresar('dxt_detallexturno', $insert_detalle);
                    } else {// si existe unicamente actualizar los campos de auditoria
                        $cadena = array(
                            'dxt_estado' => 1
                            , 'dxt_usu_mod' => $this->tank_auth->get_user_id()
                            , 'dxt_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('dxt_detallexturno', $cadena, array('dxt_id_deh' => $array_datos[$i], 'dxt_id_dia' => $array_datos_dia[$i], 'dxt_id_tur' => $id));
                    }
                }
            }

            //AHORA RECORRER LOS EXISTENTES Y PREGUNTAR CUAL NO SE HA ELEGIDO

            for ($i = 0; $i < count($seleccionados_activos); $i++) {
                if (!in_array($seleccionados_activos[$i], $array_concatenado)) {
                    $cadena = array(
                        'dxt_estado' => 0
                        , 'dxt_usu_mod' => $this->tank_auth->get_user_id()
                        , 'dxt_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('dxt_detallexturno', $cadena, array('dxt_id_deh' => $seleccionados_deh[$i], 'dxt_id_dia' => $seleccionados_dia[$i], 'dxt_id_tur' => $id));
                }
            }
            /////////////////FIN ACTUALIZACIÓN DE DETALLES

            $this->gsatelite->show_dialog('Turno actualizado con éxito', 'marcacion/procesos/vista_turno', 'success');
        } else {
            $datos['titulo_personal'] = "GESTIÓN DE TURNOS";
            $consulta = $this->gsatelite->get_tabla('tur_turno', array('tur_id' => $id));
            $datos['informacion'] = $consulta[0];
            $this->_cargarvista($datos, null);
        }
    }

    function verificar_nombre() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $nombre = $this->input->post('nombre');
            $id = $this->input->post('id');
            if ($nombre != "") {
                $pregunta = $this->gsatelite->get_tabla('tur_turno', array('tur_nombre' => $nombre, 'tur_id !=' => $id));
                if (count($pregunta) > 0) {
                    echo json_encode(array('existe' => 1));
                } else {
                    echo json_encode(array('existe' => 0));
                }
            } else {
                echo json_encode(array('existe' => 0));
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento vista turno
     */
    function vista_turno() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_table('tur_turno')
                        ->set_subject('turno')
                        ->columns('tur_nombre', 'tur_descripcion', 'tur_descuento_automatico', 'tur_estado')
                        ->fields('tur_nombre', 'tur_descripcion', 'tur_descuento_automatico', 'tur_estado', 'tur_usu_mod', 'tur_fecha_mod')
                        ->display_as('tur_nombre', 'Nombre')
                        ->display_as('tur_descripcion', 'Descripción')
                        ->display_as('tur_estado', 'Estado')
                        ->display_as('tur_descuento_automatico', 'Des. Automático')
                        ->required_fields('tur_nombre', 'tur_descuento_automatico', 'tur_estado', 'tur_usu_mod', 'tur_fecha_mod')
                        ->set_rules('tur_nombre', 'Nombre', 'trim|required|campo_unico[tur_turno.tur_nombre]')
                        ->field_type('tur_descuento_automatico', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                        ->field_type('tur_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'))
                        ->field_type('tur_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tur_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->add_action('Editar', '', 'marcacion/procesos/editar_turno', 'icomoon-icon-pencil-5')
                        ->unset_delete()
                        ->unset_export()
                        ->unset_print()
                        ->unset_edit()
                ;
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if ($permisos['permite_editar']) {
                    //preguntar si ya posee datos para actualizar o agregar configuraciones
                    $crud->add_action('Configuraciones', '', '', 'entypo-icon-settings', function($primary_key, $row) {                    
                        $pre1 = $this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $primary_key));
                        $pre2 = $this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $primary_key));
                        $pre3 = $this->gsatelite->get_tabla('che_configuracion_hora_extra', array('che_id_tur' => $primary_key));
                        if (count($pre1) == 0 and count($pre2) == 0 and count($pre3) == 0) {
                            return base_url() . 'marcacion/procesos/configuracion_turno_add/' . $primary_key;
                        } else {
                            return base_url() . 'marcacion/procesos/configuracion_turno_edit/' . $primary_key;
                        }
                    });
                }
                $data['titulo_personal'] = "Gestión de turnos";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return gestión de agregar configuracion turno
     */
    public function configuracion_turno_add($id_turno = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('tur_turno', $id_turno);
        if ($_POST) {
            // die(var_dump($_POST));
            $id_turno = $this->input->post('id_turno');
            $inicio_calculo_entrada = $this->input->post('minutos_inicio_calculo_entrada') != "" ? $this->input->post('minutos_inicio_calculo_entrada'): 0;
            $inicio_calculo_salida = $this->input->post('minutos_inicio_calculo_salida') != "" ? $this->input->post('minutos_inicio_calculo_salida'): 0;
            $eventos_doble = $this->input->post('minutos_contar_doble_min') != "" ? $this->input->post('minutos_contar_doble_min'): 0;

            if ($this->input->post('aplica_entrada_tarde') == 1 && $this->input->post('minutos_tarde_ent') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 1,
                    'cot_minutos' => $this->input->post('minutos_tarde_ent'),
                    'cot_inicio_calculo' => $inicio_calculo_entrada,
                    'cot_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos'),
                    'cot_eventos_doble' => $eventos_doble,
                    'cot_id_fre' => null,// $this->input->post('frecuencia_ent')
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
            }
            if ($this->input->post('aplica_salida_temprano') == 1 && $this->input->post('minutos_temp_sal') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 2,
                    'cot_minutos' => $this->input->post('minutos_temp_sal'),
                    'cot_inicio_calculo' => $inicio_calculo_salida,
                    'cot_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos'),
                    'cot_eventos_doble' => $eventos_doble,
                    'cot_id_fre' => null,// $this->input->post('frecuencia_sal')
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
            }
            if ($this->input->post('aplica_si_no_marca_ent') == 1 && $this->input->post('minutos_sino_ent') > 0 && $this->input->post('tipo_retraso_sino_ent') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno
                    , 'cat_tipo' => 1
                    , 'cat_minutos' => $this->input->post('minutos_sino_ent')
                    , 'cat_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos')
                    , 'cat_eventos_doble' => $eventos_doble
                    , 'cat_id_thf' => $this->input->post('tipo_retraso_sino_ent')
                    , 'cat_estado' => 1
                    , 'cat_usu_mod' => $this->tank_auth->get_user_id()
                    , 'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
            }
            if ($this->input->post('aplica_si_no_marca_sal') == 1 && $this->input->post('minutos_sino_sal') > 0 && $this->input->post('tipo_retraso_sino_sal') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno
                    , 'cat_tipo' => 2
                    , 'cat_minutos' => $this->input->post('minutos_sino_sal')
                    , 'cat_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos')
                    , 'cat_eventos_doble' => $eventos_doble
                    , 'cat_id_thf' => $this->input->post('tipo_retraso_sino_sal')
                    , 'cat_estado' => 1
                    , 'cat_usu_mod' => $this->tank_auth->get_user_id()
                    , 'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
            }
            //DETALLES DE RANGO DE HORAS EXTRAS
            $detalle_min_desde = $this->input->post('detalle_hora_desde');
            $detalle_min_hasta = $this->input->post('detalle_hora_hasta');
            $detalle_frecuencia = $this->input->post('detalle_fre');
            $detalle_hr_extra = $this->input->post('detalle_hora_extra');
            for ($i = 0; $i < count($detalle_min_desde); $i++) {
                if ($detalle_min_desde[$i] != "" and $detalle_hr_extra[$i] > 0) {
                    $insert_detalle = array(
                        'che_id_tur' => $id_turno
                        , 'che_minutos_desde' => $detalle_min_desde[$i]
                        , 'che_minutos_hasta' => $detalle_min_hasta[$i]
                        , 'che_factor_hora' => $detalle_hr_extra[$i]
                        , 'che_id_the' => $detalle_frecuencia[$i]
                        , 'che_estado' => 1
                        , 'che_usu_mod' => $this->tank_auth->get_user_id()
                        , 'che_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->ingresar('che_configuracion_hora_extra', $insert_detalle);
                }
            }

            $this->gsatelite->show_dialog('Configuración ingresada con éxito', 'marcacion/procesos/vista_turno', 'success');
        } else {
            $datos['id_turno'] = $id_turno;
            $reg_turno = $this->gsatelite->get_tabla('tur_turno', array('tur_id' => $id_turno));
            $datos['reg_turno'] = $reg_turno[0];
            $time = $this->gsatelite->get_dropdown('thf_tipo_hora_faltante', '{thf_nombre} ({thf_factor})','', array('thf_estado'=>1), null, '', 'thf_id', true);
            $frec = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre}','', array('the_estado' => 1), null, '', 'the_id', true);
            $datos['tiempo_faltante'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $time);
            $datos['frecuencias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $frec);
            $datos['titulo_personal'] = "CONFIGURACIONES";
            $this->_cargarvista($datos, null);
        }
    }

    /**
     * @author René Castaneda
     * @return gestión de editar configuracion turno
     */
    public function configuracion_turno_edit($id_turno = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('tur_turno', $id_turno);
        if ($_POST) {
            // die(var_dump($_POST));
            $id_turno = $this->input->post('id_turno');
            $tiene_entrada_tarde = count($this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 1)));
            $tiene_salida_temp = count($this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 2)));
            $tiene_sino_entrada = count($this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 1)));
            $tiene_sino_salida = count($this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 2)));
            
            $inicio_calculo_entrada = $this->input->post('minutos_inicio_calculo_entrada') != "" ? $this->input->post('minutos_inicio_calculo_entrada'): 0;
            $inicio_calculo_salida = $this->input->post('minutos_inicio_calculo_salida') != "" ? $this->input->post('minutos_inicio_calculo_salida'): 0;
            $eventos_doble = $this->input->post('minutos_contar_doble_min') != "" ? $this->input->post('minutos_contar_doble_min'): 0;

            if ($this->input->post('aplica_entrada_tarde') == 1 && $this->input->post('minutos_tarde_ent') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 1,
                    'cot_minutos' => $this->input->post('minutos_tarde_ent'),
                    'cot_inicio_calculo' => $inicio_calculo_entrada,
                    'cot_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos'),
                    'cot_eventos_doble' => $eventos_doble,
                    'cot_id_fre' => null,// $this->input->post('frecuencia_ent')
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_entrada_tarde > 0) { //si ya posee registro actualizar
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 1));
                } else { //si no insertar
                    $id_insert_entrada = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_entrada_tarde') < 1) {
                    $array_insert = array(
                        'cot_estado' => 0,
                        'cot_usu_mod' => $this->tank_auth->get_user_id(),
                        'cot_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 1));
                }
            }

            if ($this->input->post('aplica_salida_temprano') == 1 && $this->input->post('minutos_temp_sal') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 2,
                    'cot_minutos' => $this->input->post('minutos_temp_sal'),
                    'cot_inicio_calculo' => $inicio_calculo_salida,
                    'cot_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos'),
                    'cot_eventos_doble' => $eventos_doble,
                    'cot_id_fre' => null,// $this->input->post('frecuencia_sal')
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_salida_temp > 0) { //si ya posee registro actualizar
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 2));
                } else {
                    $id_insert_salida = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_salida_temprano') < 1) {
                    $array_insert = array(
                        'cot_estado' => 0
                        , 'cot_usu_mod' => $this->tank_auth->get_user_id()
                        , 'cot_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 2));
                }
            }

            if ($this->input->post('aplica_si_no_marca_ent') == 1 && $this->input->post('minutos_sino_ent') > 0 && $this->input->post('tipo_retraso_sino_ent') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno
                    , 'cat_tipo' => 1
                    , 'cat_minutos' => $this->input->post('minutos_sino_ent')
                    , 'cat_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos')
                    , 'cat_eventos_doble' => $eventos_doble
                    , 'cat_id_thf' => $this->input->post('tipo_retraso_sino_ent')
                    , 'cat_estado' => 1
                    , 'cat_usu_mod' => $this->tank_auth->get_user_id()
                    , 'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_sino_entrada > 0) {
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 1));
                } else {
                    $id_insert = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_si_no_marca_ent') < 1) {
                    $array_insert = array(
                        'cat_estado' => 0
                        , 'cat_usu_mod' => $this->tank_auth->get_user_id()
                        , 'cat_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 1));
                }
            }

            if ($this->input->post('aplica_si_no_marca_sal') == 1 && $this->input->post('minutos_sino_sal') > 0 && $this->input->post('tipo_retraso_sino_sal') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno
                    , 'cat_tipo' => 2
                    , 'cat_minutos' => $this->input->post('minutos_sino_sal')
                    , 'cat_aplicar_doble' => $this->input->post('hidden_aplica_contar_doble_minutos')
                    , 'cat_eventos_doble' => $eventos_doble
                    , 'cat_id_thf' => $this->input->post('tipo_retraso_sino_sal')
                    , 'cat_estado' => 1
                    , 'cat_usu_mod' => $this->tank_auth->get_user_id()
                    , 'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_sino_salida > 0) {
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 2));
                } else {
                    $id_insert = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_si_no_marca_sal') < 1) {
                    $array_insert = array(
                        'cat_estado' => 0
                        , 'cat_usu_mod' => $this->tank_auth->get_user_id()
                        , 'cat_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 2));
                }
            }
            //DETALLES DE RANGO DE HORAS EXTRAS
            $detalle_min_desde = $this->input->post('detalle_hora_desde');
            $detalle_min_hasta = $this->input->post('detalle_hora_hasta');
            $detalle_frecuencia = $this->input->post('detalle_fre');
            $detalle_hr_extra = $this->input->post('detalle_hora_extra');
            $this->gsatelite->borrado_general('che_configuracion_hora_extra', array('che_id_tur' => $id_turno));
            for ($i = 0; $i < count($detalle_min_desde); $i++) {
                if ($detalle_min_desde[$i] != "" && $detalle_hr_extra[$i] > 0) {
                    $insert_detalle = array(
                        'che_id_tur' => $id_turno
                        , 'che_minutos_desde' => $detalle_min_desde[$i]
                        , 'che_minutos_hasta' => $detalle_min_hasta[$i]
                        , 'che_factor_hora' => $detalle_hr_extra[$i]
                        , 'che_id_the' => $detalle_frecuencia[$i] != '' ? $detalle_frecuencia[$i]: null
                        , 'che_estado' => 1
                        , 'che_usu_mod' => $this->tank_auth->get_user_id()
                        , 'che_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->ingresar('che_configuracion_hora_extra', $insert_detalle);
                }
            }
            $this->gsatelite->show_dialog('Configuración actualizada con éxito', 'marcacion/procesos/vista_turno', 'success');
        } else {
            $datos['id_turno'] = $id_turno;
            $reg_turno = $this->gsatelite->get_tabla('tur_turno', array('tur_id' => $id_turno));
            $datos['reg_turno'] = $reg_turno[0];
            $datos['configuracion_entrada'] = $this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 1, 'cot_estado' => 1));
            $datos['configuracion_salida'] = $this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 2, 'cot_estado' => 1));
            $datos['configuracion_accion_entrada'] = $this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 1, 'cat_estado' => 1));
            $datos['configuracion_accion_salida'] = $this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 2, 'cat_estado' => 1));

            $this->db->join('the_tipo_hora_extra', 'che_id_the = the_id', 'left');
            $datos['configuracion_hora_extra'] = $this->gsatelite->get_tabla('che_configuracion_hora_extra', array('che_id_tur' => $id_turno, 'che_estado' => 1));
            $frec = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre}','', array('the_estado' => 1), null, '', 'the_id', true);
            $datos['frecuencias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $frec);
            $datos['titulo_personal'] = "CONFIGURACIONES";
            $this->_cargarvista($datos, null);
        }
    }

    /**
     * @author René Castaneda
     * @return gestión de asignación de turnos
     */
    public function asignacion_turno() {
        satelite_validar();
        if ($_POST) {
            // die(var_dump($_POST));
            $fecha_h = (trim($this->input->post('fecha_hasta')) != "" && !($this->input->post('indefinido'))) ? date('Y-m-d', strtotime($this->input->post('fecha_hasta'))) : null;
            $tiu_turno = $this->gsatelite->get_campo('tur_turno','tur_id_tiu', array('tur_id' => $this->input->post('turno')));
            $insert_detalle = array(
                'txe_id_tur' => $this->input->post('turno'),
                'txe_id_emp' => $this->input->post('empleado'),
                'txe_id_tiu' => ($tiu_turno != "") ? $tiu_turno : null,
                'txe_desde' => date('Y-m-d', strtotime($this->input->post('fecha_desde'))),
                'txe_hasta' => $fecha_h,
                'txe_indefinido' => ($this->input->post('indefinido') > 0) ? 1 : 0,
                'txe_adicional' => 0,//($this->input->post('adicional')) ? 1 : 0
                'txe_estado' => 1,
                'txe_usu_mod' => $this->tank_auth->get_user_id(),
                'txe_fecha_mod' => date("Y-m-d H:i:s")
            );
            $id_detalle = $this->gsatelite->ingresar('txe_turnoxempleado', $insert_detalle);
            $boton = $this->input->post('boton');
            if ($boton == '2') {
                //redirect('marcacion/procesos/grid_asignacion_turno');
                $this->gsatelite->show_dialog('Turno asignado con éxito', 'marcacion/procesos/grid_asignacion_turno', 'success');
            }
            if ($boton == '1') {
                $this->gsatelite->show_dialog('Turno asignado con éxito', 'marcacion/procesos/asignacion_turno', 'success');
            }
        } else {
            $select = '<option value=""></option>';
            $empleados = $this->marcacion_model->get_empleados_turnados(array('emp_estado' => 1));
            if (count($empleados) > 0) {
                foreach ($empleados as $key => $val) {
                    if ($val['ctdad'] > 0) {
                        if ($val['ctdad'] > 1) {
                            $turno = ' (Varios Turnos Hasta: '.$val['hasta'].')';
                        } else {
                            $turno = ' ('.$val['tur_nombre'].' / Desde: '.$val['desde'].' Hasta: '.$val['hasta'].')';
                        }
                        
                    } else {
                        $turno = '';
                    }                    
                    $select .= '<option value="'.$val['emp_id'].'">'.$val['emp_codigo'].' - '.$val['emp_nombre'].' '.$val['emp_apellido'].$turno.'</option>';
                }
            }
            $datos['select_empleado'] = $select;
            $datos['titulo_personal'] = "Asignación de turnos";
            $this->_cargarvista($datos, null);
        }
    }

    /**
     * @author René Castaneda
     * @return gestión de asignación de turnos
     */
    public function asignacion_turno_edit($id) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('txe_turnoxempleado', $id);
        if ($_POST) {
            // die(var_dump($_POST));
            $id_detalle_tur = $this->input->post('id_detalle_turno');
            $fecha_h = (trim($this->input->post('fecha_hasta')) != "") ? date('Y-m-d', strtotime($this->input->post('fecha_hasta'))) : null;
            $tiu_turno = $this->gsatelite->get_campo('tur_turno','tur_id_tiu', array('tur_id' => $this->input->post('turno')));
            $id_empleado = $this->input->post('empleado');
            $update_detalle = array(
                'txe_id_tur' => $this->input->post('turno'),
                'txe_id_emp' => $this->input->post('empleado'),
                'txe_id_tiu' => ($tiu_turno != "") ? $tiu_turno : null,
                'txe_desde' => date('Y-m-d', strtotime($this->input->post('fecha_desde'))),
                'txe_hasta' => $fecha_h,
                'txe_indefinido' => ($this->input->post('indefinido') > 0) ? 1 : 0,
                'txe_adicional' => 0,// ($this->input->post('adicional')) ? 1 : 0
                'txe_estado' => 1,
                'txe_usu_mod' => $this->tank_auth->get_user_id(),
                'txe_fecha_mod' => date("Y-m-d H:i:s")
            );
            $id_detalle = $this->gsatelite->actualizar_array('txe_turnoxempleado', $update_detalle, array('txe_id' => $id_detalle_tur));
            $this->gsatelite->show_dialog('Turno actualizado con éxito', "marcacion/procesos/grid_asignacion_turno", 'success');
        } else {
            $id_emp = $this->gsatelite->get_campo('txe_turnoxempleado', 'txe_id_emp', array('txe_id' => $id));
            $datos['empleado'] = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $id_emp);
            $this->db->join('tur_turno', 'tur_id=txe_id_tur');
            $this->db->join('tiu_tipo_turno', 'tiu_id=txe_id_tiu', 'left');
            $datos['detalles'] = $this->gsatelite->get_tabla('txe_turnoxempleado', array('txe_id_emp' => $id_emp, 'txe_id' => $id));
            $datos['titulo_personal'] = "Asignación de turnos";
            $this->_cargarvista($datos, null);
        }
    }

    function cargar_select_empleados_area() {
        $id_are = $this->input->post('id');
        $empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', 'empleado', array('emp_id_are' => $id_are, 'emp_estado' => 1), null, ' placeholder="Seleccione" id="empleado" style="width:100%;" class="nostyle"');
        $datos['empleados_select'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value="" ></option>', $empleados); 
        die(json_encode($datos));
    }

    function cargar_select_empleados_area_listado_empleados() {
        $id_are = $this->input->post('id');
        $datos['empleados_select'] = str_replace('<option value="0">Seleccione</option>', '<option value="" ></option>', $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', 'empleado', array('emp_id_are' => $id_are), null, ' placeholder="Seleccione"  id="empleado" style="width:100%;" class="nostyle"'));
        die(json_encode($datos));
    }

    function cargar_select_turno_habiles() {
        $id_emp = $this->input->post('id');
        $pregunta = $this->gsatelite->get_tabla('txe_turnoxempleado', array('txe_id_emp' => $id_emp));
        $no_permitidos = array(0);
        foreach ($pregunta as $k) {
            $no_permitidos[] = $k['txe_id_tur'];
        }
        //$this->db->where_not_in('tur_id', $no_permitidos);
        $select = $this->gsatelite->get_dropdown('tur_turno', '{tur_nombre}', 'turno', array('tur_estado' => 1), null, ' required placeholder="Selccione" style="width:100%" id="turno" class="nostyle"');
        $select = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $select);
        //die($this->db->last_query());
        $datos['turno_select'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
        die(json_encode($datos));
    }

    /**
     * @author René Castaneda
     * @return agregar marcación
     */
    public function marcacion_edit($id) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('mar_marcacion', $id);
        if ($_POST) {
            //            die(date("N",strtotime($this->input->post('fecha_corrige'))));
            //    die(var_dump($_POST));

            $datos_correc = array($this->input->post('empleado'),
                $this->input->post('fecha_corrige'),
                formatear_fecha('H:i:s', $this->input->post('hora_entrada')),
                formatear_fecha('H:i:s', $this->input->post('hora_salida')));

            $id_dxt_encontrado = $this->buscar_horario_correccion($datos_correc);
            if ($id_dxt_encontrado == 0) {
                $this->gsatelite->show_dialog('Error. No existe ningun turno asociado al empleado que contenga dicho detalle de marcación', 'marcacion/procesos/agregar_marcacion', 'error');
            }
            //  die($id_dxt_encontrado);
            $id_detalle = $this->input->post('id_marcacion');
            $update_detalle = array(
                'mar_id_emp' => $this->input->post('empleado')
                , 'mar_id_dxt' => $id_dxt_encontrado
                , 'mar_hora_entrada' => formatear_fecha('H:i:s', $this->input->post('hora_entrada'))
                , 'mar_hora_salida' => formatear_fecha('H:i:s', $this->input->post('hora_salida'))
                , 'mar_fecha_entrada' => date('Y-m-d', strtotime($this->input->post('fecha_corrige')))
                , 'mar_fecha_salida' => date('Y-m-d', strtotime($this->input->post('fecha_corrige')))
                , 'mar_estado' => 1
                , 'mar_usu_modificacion' => $this->tank_auth->get_user_id()
                , 'mar_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $this->gsatelite->actualizar_array('mar_marcacion', $update_detalle, array('mar_id' => $id_detalle));

            $correccion_array = array(
                'cor_hora_desde' => formatear_fecha('H:i:s', $this->input->post('hora_entrada'))
                , 'cor_hora_hasta' => formatear_fecha('H:i:s', $this->input->post('hora_salida'))
                , 'cor_observacion' => $this->input->post('observaciones')
                , 'cor_fecha' => date('Y-m-d H:i:s', strtotime($this->input->post('fecha_corrige')))
                , 'cor_estado' => 1
                , 'cor_fecha_mod' => date('Y-m-d H:i:s')
                , 'cor_usu_mod' => $this->tank_auth->get_user_id()
            );
            $id_correc = $this->gsatelite->ingresar('cor_correcion', $correccion_array);

            $array_cxm = array(
                'cxm_id_cor' => $id_correc
                , 'cxm_id_mar' => $id_detalle
                , 'cxm_estado' => 1
                , 'cxm_fecha_mod' => date('Y-m-d H:i:s')
                , 'cxm_usu_mod' => $this->tank_auth->get_user_id()
            );
            $this->gsatelite->ingresar('cxm_correcionxmarcacion', $array_cxm);


            $this->gsatelite->show_dialog('Marcación actualizada con éxito.', 'marcacion/procesos/confirmar_marcacion', 'success');
        } else {
            $detalle = $this->gsatelite->get_tabla('mar_marcacion', array('mar_id' => $id));
            $this->db->join('are_area', 'are_id=emp_id_are');
            $datos_emple = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $detalle[0]['mar_id_emp']));
            // die(var_dump($detalle[0]));
            $datos['detalle'] = $detalle[0];
            $datos['datos_emple'] = $datos_emple[0];
            $datos['titulo_personal'] = "CORREGIR MARCACIÓN";
            $this->_cargarvista($datos, null);
        }
    }

    /**
     * @author Melbin Cruz
     * @return procesar marcación
     */
    public function procesar_marcacion() {
        satelite_validar();
        $data['tipo_planilla'] = $this->planilla_model->get_tipo_contrato();
        $data['titulo_personal'] = "Procesar marcación";
        $areas  = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado' => '1'), null, '', 'are_id', true); 
        $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);        
        $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);
        $data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);            
        $this->_cargarvista($data, null);
    }

    function obtener_periodo_planilla($tipo_estado = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $option = "";
            $var = '<option value=""></option>';
            $t_planilla = $this->input->post('t_planilla');
            $tipo = $this->input->post('tipo');
            if ($tipo_estado) {
                $periodos = $this->planilla_model->obtener_periodo_planilla2($t_planilla, $tipo);
            } else {
                $periodos = $this->planilla_model->obtener_periodo_planilla($t_planilla, $tipo);
            }
            foreach ($periodos as $key) {
                switch ($key['pla_estado']) {
                    case '1':
                        $estado = "Creada";
                        break;
                    case '2':
                        $estado = "Generada";
                        break;
                    case '3':
                        $estado = "Autorizada";
                        break;

                    default:
                        # code...
                        break;
                }
                $var .= "<option value='" . $key['pla_id'] . "'>" . $key['pla_fecha_inicio'] . "  --  " . $key['pla_fecha_fin'] . " " . $estado . "</option>";
            }
            $arreglo = array("drop" => $var);

            echo json_encode($arreglo);
        }
    }

    /**
     * @author René Castaneda
     * @return agregar marcación
     */
    public function agregar_marcacion() {
        satelite_validar();
        if ($_POST) {
            // die(date("N",strtotime($this->input->post('fecha_corrige'))));
            // die(var_dump($_POST));

            $datos_correc = array($this->input->post('empleado'),
                $this->input->post('fecha_corrige'),
                formatear_fecha('H:i:s', $this->input->post('hora_entrada')),
                formatear_fecha('H:i:s', $this->input->post('hora_salida')));

            $id_dxt_encontrado = $this->buscar_horario_correccion($datos_correc);
            if ($id_dxt_encontrado == 0) {
                $this->gsatelite->show_dialog('Error. No existe ningun turno asociado al empleado que contenga dicho detalle de marcación', 'marcacion/procesos/agregar_marcacion', 'error');
            }
            //  die($id_dxt_encontrado);
            $insert_detalle = array(
                'mar_id_emp' => $this->input->post('empleado')
                , 'mar_id_dxt' => $id_dxt_encontrado
                , 'mar_hora_entrada' => formatear_fecha('H:i:s', $this->input->post('hora_entrada'))
                , 'mar_hora_salida' => formatear_fecha('H:i:s', $this->input->post('hora_salida'))
                , 'mar_fecha_entrada' => date('Y-m-d', strtotime($this->input->post('fecha_corrige')))
                , 'mar_fecha_salida' => date('Y-m-d', strtotime($this->input->post('fecha_corrige2')))
                , 'mar_estado' => 1
                , 'mar_revisado' => 0
                , 'mar_usu_modificacion' => $this->tank_auth->get_user_id()
                , 'mar_usu_creacion' => $this->tank_auth->get_user_id()
                , 'mar_fecha_modificacion' => date("Y-m-d H:i:s")
                , 'mar_fecha_creacion' => date("Y-m-d H:i:s")
            );
            $id_detalle = $this->gsatelite->ingresar('mar_marcacion', $insert_detalle);

            $correccion_array = array(
                'cor_hora_desde' => formatear_fecha('H:i:s', $this->input->post('hora_entrada'))
                , 'cor_hora_hasta' => formatear_fecha('H:i:s', $this->input->post('hora_salida'))
                , 'cor_observacion' => $this->input->post('observaciones')
                , 'cor_fecha' => date('Y-m-d H:i:s', strtotime($this->input->post('fecha_corrige')))
                , 'cor_estado' => 1
                , 'cor_fecha_mod' => date('Y-m-d H:i:s')
                , 'cor_usu_mod' => $this->tank_auth->get_user_id()
            );
            $id_correc = $this->gsatelite->ingresar('cor_correcion', $correccion_array);

            $array_cxm = array(
                'cxm_id_cor' => $id_correc
                , 'cxm_id_mar' => $id_detalle
                , 'cxm_estado' => 1
                , 'cxm_fecha_mod' => date('Y-m-d H:i:s')
                , 'cxm_usu_mod' => $this->tank_auth->get_user_id()
            );
            $this->gsatelite->ingresar('cxm_correcionxmarcacion', $array_cxm);
            $this->gsatelite->show_dialog('Marcación agregada con éxito. Debe Procesar para terminar registro.', 'marcacion/procesos/confirmar_marcacion', 'success');
        } else {
            $dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $datos['selec_empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            $datos['titulo_personal'] = "Agregar marcación";
            $this->_cargarvista($datos, null);
        }
    }

    /**
    * @author Daniel Perez
    * @return Devuelve la lista de marcaciones con su nombre validadas por empleado y turno
    *
    */
    function cargar_marcacion_txt() {
        satelite_validar();
        switch ($this->uri->segments[4]){
            // Valida que cada registro posea un id empleado y un turno valido
            case 'validar':
                ob_end_clean();
                $packet = json_decode(file_get_contents('php://input'));
                $output = [];

                foreach ($packet as $marc) {
                    /*$datos_busqueda = array($marc->emp_id, $marc->c3, $marc->row->hora_entrada, $marc->row->hora_salida);
                    $id_dxt_encontrado = $this->buscar_horario_correccion($datos_busqueda);
                    print_r($id_dxt_encontrado);*/
                    // Si no viene el codigo de empleado se declara como falso el id para validar en el frontend
                    if (!isset($marc->c1)) {
                        $marc->emp_id = false;
                    }else{
                    // Si viene el codigo se extrae el id y los datos del empleado
                        $row_emp = $this->marcacion_model->marcacionesxturno($marc->c1);
                        $marc->emp_id = $row_emp[0]->emp_id;
                        $marc->nombre = $row_emp[0]->emp_nombre;
                        $marc->apellido = $row_emp[0]->emp_apellido;
                    }
                }
                print_r(json_encode($packet));
            break;
            case 'informe':
                $packet = json_decode(file_get_contents('php://input')); 
                $datos['titulo_personal'] = "Informe de Marcaciones";
                cargarvista($datos, null, 'marcacion/procesos/informe_marcaciones_txt');
            break;
            default:
                $data['titulo_personal'] = "Cargar marcación TXT";
                $this->_cargarvista($data, null);  
            break;
        }
    }

    public function guardar_marcaciones_txt() {
        satelite_validar();
        ob_end_clean();
        $empleados = json_decode(file_get_contents('php://input'));
        
        $marcas_procesadas = 0;
        $marcas_no_procesadas = 0;
        for ($i = 0; $i < count($empleados); $i++) {
            if ($empleados[$i]->emp_id != null) {
                $row_emp = $this->marcacion_model->verificarTurnoEmpleado($empleados[$i]->emp_id);
                //$row_emp = $this->marcacion_model->verificarTurnoEmpleado($empleados[$i]->emp_id);
                //buscar el horario correspondiente al registro de la marcación
                $datos = array($empleados[$i]->emp_id, formatear_fecha('Y-m-d',$empleados[$i]->fecha_entrada), $empleados[$i]->hora_entrada, $empleados[$i]->hora_salida);
                $id_dxt_encontrado = $this->buscar_horario_correccion($datos);
                if ($id_dxt_encontrado <= 0) {
                    $id_dxt_encontrado = null;
                }
                $empleados[$i]->fecha_entrada = formatear_fecha('Y-m-d',$empleados[$i]->fecha_entrada);
                $empleados[$i]->fecha_salida = formatear_fecha('Y-m-d',$empleados[$i]->fecha_salida);
                if ($row_emp > 0){
                    $insert_mar = array(
                        'mar_id_emp' => $empleados[$i]->emp_id,
                        'mar_id_dxt' => $id_dxt_encontrado,
                        'mar_fecha_entrada' => $empleados[$i]->fecha_entrada,
                        'mar_hora_entrada' => $empleados[$i]->hora_entrada,
                        'mar_fecha_salida' => $empleados[$i]->fecha_salida,
                        'mar_hora_salida' => $empleados[$i]->hora_salida,
                        'mar_revisado' => 0,
                        'mar_estado' => 1,
                        'mar_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'mar_usu_creacion' => $this->tank_auth->get_user_id(),
                        'mar_fecha_modificacion' => date("Y-m-d H:i:s"),
                        'mar_fecha_creacion' => date("Y-m-d H:i:s")
                    );
                    $id_detalle = $this->gsatelite->ingresar('mar_marcacion', $insert_mar);
                    $marcas_procesadas++; 
                }else{
                //almacenar las filas no procesadas
                    $marcas_no_procesadas++;
                }
            }
        }
        $datos = array( 'marcas_procesadas' => $marcas_procesadas, 'marcas_no_procesadas' => $marcas_no_procesadas, 'filas_no_procesadas' => 0 );
        print_r(json_encode($datos));
    }

    function buscar_horario_correccion($datos) {
        //PREGUNTAR POR EL PARAMETRO PARA CONFIGURACION DE RANGO DE TURNO
        $par = $this->gsatelite->get_parametro('TIEMPO_BUSQUEDA_HORARIO');
        $tiempo_busqueda = (trim($par) != "" and count(explode(':', $par)) > 0) ? trim($par) : '02:00:00';

        $id_emp = $datos[0]; // ID empleado
        $fecha = date("Y-m-d", strtotime($datos[1])); // fecha entrada
        $entra = $datos[2]; // hora entrada

        if(isset($datos[3])) {
            $sale = $datos[3]; // Hora salida
            $sale = $this->gsatelite->convertir_hora($sale, 1, "$tiempo_busqueda", 2);
        } else {
            $sale = null;
        }
        
        //convertir las horas en segundos
        $entra = $this->gsatelite->convertir_hora($entra, 1, "$tiempo_busqueda", 1);
        
        $fecha_date = new Datetime($fecha);
        $id_encontrado = 0;        
        //preguntar por el dia. 1-lunes hasta 7-domingo e igual deben coindir los id de la tabla dia_dia
        //no perderse con la fecha si es 05/10/2020 corresponde a Lunes ID 1 de la tabla dia_dia
        $dia_n = date("N", strtotime($fecha));
        //print_r($dia_n);die();
        //consultar los turnos del empleado (turnos no indefinidos)
        $this->db->where('txe_indefinido', 0);
        $this->db->where('txe_hasta is not null', null, false);
        $turnos_emp = $this->gsatelite->get_tabla('txe_turnoxempleado', array('txe_id_emp' => $id_emp, 'txe_estado' => 1));
        foreach ($turnos_emp as $f) { //recorrer los detalles
            //convertir a fechas 
            if ($id_encontrado == 0) {
                $date1 = new Datetime($f['txe_desde']); //fecha desde
                $date2 = new Datetime($f['txe_hasta']); //fecha hasta
                //preguntar en el rango en el que coincide
                if ($fecha_date >= $date1 && $fecha_date <= $date2) {
                    //consultar el detalle del turno al que pertenece la maracación
                    // $where=array('deh_hora_entrada >='=>$entra, 'deh_hora_salida <='=>$sale);
                    $this->db->join('deh_detalle_horario', 'deh_id=dxt_id_deh');
                    $detalle_turn = $this->gsatelite->get_tabla('dxt_detallexturno', array('dxt_id_tur' => $f['txe_id_tur'], 'dxt_id_dia' => $dia_n));
                    foreach ($detalle_turn as $k) {
                        //preguntar si entran en el rango
                        // if( ($entra >= $k['deh_hora_entrada'] or $entra <= $k['deh_hora_entrada'] ) and ($sale <= $k['deh_hora_salida'] or $sale >= $k['deh_hora_salida'] ) )
                        //convertir las horas en segundos   
                        $deh_hora_entrada = $this->gsatelite->convertir_hora($k['deh_hora_entrada']);
                        $deh_hora_salida = $this->gsatelite->convertir_hora($k['deh_hora_salida']);
                        if(isset($sale)) {
                            if ($entra >= $deh_hora_entrada && $sale <= $deh_hora_salida) {
                                if ($id_encontrado == 0) {
                                    $id_encontrado = $k['dxt_id'];
                                }
                            }
                        } else {
                            if ($entra >= $deh_hora_entrada) {
                                if ($id_encontrado == 0) {
                                    $id_encontrado = $k['dxt_id'];
                                }
                            }
                        }
                        
                    }
                }
            }
        }
        if ($id_encontrado == 0) {
            //consultar los turnos del empleado (turnos indefinidos) si aun no se encontro en la primera consulta
            $this->db->where('txe_indefinido', 1);
            //$this->db->where('txe_hasta',null);
            $turnos_emp = $this->gsatelite->get_tabla('txe_turnoxempleado', array('txe_id_emp' => $id_emp, 'txe_estado' => 1));
            foreach ($turnos_emp as $f) { //recorrer los detalles
                //convertir a fechas 
                if ($id_encontrado == 0) {
                    $date1 = new Datetime($f['txe_desde']); //fecha desde
                    //preguntar en el rango en el que coincide
                    if ($fecha_date >= $date1) {
                        //consultar el detalle del turno al que pertenece la maracación
                        // $where=array('deh_hora_entrada >='=>$entra, 'deh_hora_salida <='=>$sale);
                        $this->db->join('deh_detalle_horario', 'deh_id=dxt_id_deh');
                        //$this->db->where($where);
                        $detalle_turn = $this->gsatelite->get_tabla('dxt_detallexturno', array('dxt_id_tur' => $f['txe_id_tur'], 'dxt_id_dia' => $dia_n));
                        foreach ($detalle_turn as $k) {
                            //preguntar si entran en el rango
                            $deh_hora_entrada = $this->gsatelite->convertir_hora($k['deh_hora_entrada']);
                            $deh_hora_salida = $this->gsatelite->convertir_hora($k['deh_hora_salida']);
                            if(isset($sale)) {
                                if ($entra >= $deh_hora_entrada && $sale <= $deh_hora_salida) {
                                    if ($id_encontrado == 0) {
                                        $id_encontrado = $k['dxt_id'];
                                    }
                                }
                            } else {
                                if ($entra >= $deh_hora_entrada) {
                                    if ($id_encontrado == 0) {
                                        $id_encontrado = $k['dxt_id'];
                                    }
                                }
                            }
                            
                        }
                    }
                }
            }
        }

        return $id_encontrado;
    }

    function cargar_marcacion() {
        satelite_validar();
        if ($_FILES) {
            $this->load->library('excel/excel_reader.php');
            $excel = new Excel_reader;
            $excel->read($_FILES["excel_marcacion"]["tmp_name"]);

            $nr_sheets = count($excel->sheets);       // gets the number of sheets
            $excel_data = '';
            // to store the the html tables with data of each sheet
            //  die(var_dump($excel->boundsheets[0]['name']));
            // traverses the number of sheets and sets html table with each sheet data in $excel_data
            for ($i = 0; $i < $nr_sheets; $i++) {
                if ($excel->sheets[$i]['numCols'] == 6) {
                    $re_h = '<center><table border="1" class="responsive table table-bordered contenedor" id="data_expand" name="data_expand">';     // starts html table
                    $re_h .= '<thead>';
                    $re_h .= '<tr>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'ID EMPLEADA/O';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'NOMBRE';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'HORA ENTRADA';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'HORA SALIDA';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'FECHA ENTRADA';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'FECHA SALIDA';
                    $re_h .= '</th>';
                    $re_h .= '</tr>';
                    $re_h .= '</thead>';

                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center>' . $re_h . $this->sheetData($excel->sheets[$i]) . '<br/>';
                } else {
                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center><br/><center><h3>';
                    $excel_data .= 'La hoja actual no cumple con el formato de columnas: " [COD_EMPLEADO][NOMBRE][ENTRADA][SALIDA][FECHA_ENT][FECHA_SAL]"</h3><br/>';
                    $excel_data .= '<h4>Favor revisar documento de excel y cantidad de columas</h4></center><br/>';
                }
            }

            $data['tabla_html'] = $excel_data;

            $data['titulo_personal'] = "CARGAR MARCACIÓN";
            $this->_cargarvista($data, null);
        } else {
            $data['titulo_personal'] = "CARGAR MARCACIÓN";
            $this->_cargarvista($data, null);
        }
    }

    function sheetData($sheet) {
        $re = '<tbody id="contenedor">';

        $unpacker = $this->procesar_info($sheet);
        //die(print_r($unpacker));
        //echo $sheet['numRows']; die();
        $x = 1;
        while ($x <= $sheet['numRows']) {
            $re .= "<tr>\n";
            $y = 1;
            while ($y <= $sheet['numCols']) {

                $cell = isset($sheet['cells'][$x][$y]) ? $sheet['cells'][$x][$y] : '';
                $re .= ($unpacker[$y - 1][$x - 1] != "empreado no encontrado") ? "<td style='text-align: left;'>" : "<td style='text-align: left;' class='eliminar_padre'>";

                if ($unpacker[$y - 1][$x - 1] != "empleado no encontrado") {
                    if ($unpacker[$y - 1][$x - 1] != '') {
                        switch ($y) {
                            case 1:
                                $re .= $unpacker[$y - 1][$x - 1] . " [ID-" . $cell . "]" . "<input type='hidden' name='empleado[]' class='empleado' value='" . $cell . "'/></td>\n";
                                break;

                            case 2:
                                $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='nombre_emp_excel[]' class='nombre_emp_excels' value='" . $cell . "'/></td>\n";
                                break;

                            case 3:
                                $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='hora_entrada[]' class='hora_entrada' value='" . $cell . "'/></td>\n";
                                break;

                            case 4:
                                $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='hora_salida[]' class='hora_salida' value='" . $cell . "'/></td>\n";
                                break;

                            case 5:
                                $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='fecha[]' class='fecha' value='" . $cell . "'/></td>\n";
                                break;

                            case 6:
                                $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='fecha2[]' class='fecha2' value='" . $cell . "'/></td>\n";
                                break;
                        }
                    } else {
                        $re .= "</td>\n";
                    }
                } else {
                    if ($y == 2) {
                        $re .= "</td>\n";
                    } else {
                        $re .= $unpacker[$y - 1][$x - 1] . "</td>\n";
                    }
                }
                $y++;
            }
            $re .= "</tr>\n";
            $x++;
        }
        //
        //print_r($re .'</tbody></table></center>');exit();
        return $re . '</tbody></table></center>';     // ends and returns the html table
    }

    function procesar_info($hoja) {
        $condiciones[0] = array(); //Empleado id nombre base
        $condiciones[1] = array(); //empleado nombre excel
        $condiciones[2] = array(); //hora entrada
        $condiciones[3] = array(); //hora salida
        $condiciones[4] = array(); //fecha entrada
        $condiciones[5] = array(); //fecha salida

        $x = 1;
        while ($x <= $hoja['numRows']) {
            $y = 1;
            while ($y <= $hoja['numCols']) {
                $cell = isset($hoja['cells'][$x][$y]) ? $hoja['cells'][$x][$y] : '';

                $condiciones[$y - 1] = array_merge($condiciones[$y - 1], array($cell));

                $y++;
            }
            $x++;
        }

        //var_dump($condiciones[0]); die();
        foreach ($condiciones[0] as $key => $valor) {

            if ($condiciones[0][$key] != '') { //preguntar por los ids
                $id_emp = $this->db->select('emp_id')->where('emp_id', $condiciones[0][$key])->from('emp_empleado')->get()->result_array();

                $resulters = $this->db->select()
                                ->where('emp_id', @$id_emp[0]['emp_id'])
                                ->from('emp_empleado')->get()->row_array();


                if (isset($resulters['emp_id'])) {
                    //preguntar si posee al menos un turno asociado
                    $texto = $resulters['emp_nombre'] . ' ' . $resulters['emp_apellido'];
                    $resulters_tur = $this->db->select()
                                    ->join('txe_turnoxempleado', 'txe_id_emp=emp_id')
                                    ->where('emp_id', @$id_emp[0]['emp_id'])
                                    ->where('txe_estado', 1)
                                    ->from('emp_empleado')->get()->row_array();
                    if (count($resulters_tur) <= 0) {
                        $texto .= '<k style="color:#FF4A4A;"> (sin turno asociado<input value="no" name="posee_turno[]" type="hidden" />)</k>';
                    } else {
                        $texto .= '<input value="si" name="posee_turno[]" type="hidden" />';
                    }

                    //preguntar si existe el id del horario del excel configurado en el sistema
                    // $pregun = $this->gsatelite->get_tabla('dxt_detallexturno',array('dxt_id'=>$condiciones[5][$key]));
                    /*  if(count($pregun)>0){
                      }else {
                      } */

                    $condiciones[0][$key] = $texto;
                    $condiciones[1][$key] = $condiciones[1][$key];
                    $condiciones[2][$key] = $condiciones[2][$key];
                    $condiciones[3][$key] = $condiciones[3][$key];
                    $condiciones[4][$key] = $condiciones[4][$key];
                    $condiciones[5][$key] = $condiciones[5][$key];
                } else {
                    $condiciones[0][$key] = "empleado no encontrado";
                    $condiciones[1][$key] = "";
                    $condiciones[2][$key] = "";
                    $condiciones[3][$key] = "";
                    $condiciones[4][$key] = "";
                    $condiciones[5][$key] = "";
                }
            } else {
                $condiciones[0][$key] = "";
                $condiciones[1][$key] = "";
                $condiciones[2][$key] = "";
                $condiciones[3][$key] = "";
                $condiciones[4][$key] = "";
                $condiciones[5][$key] = "";
            }
        }


        return $condiciones;
    }

    public function guardar_marcaciones_excel() {
        satelite_validar();
        if ($_POST) {
            //     die(var_dump($_POST));

            $posee_turno = $this->input->post('posee_turno');
            $empleados = $this->input->post('empleado');
            $hora_entra = $this->input->post('hora_entrada');
            $hora_sale = $this->input->post('hora_salida');
            $fecha_entra = $this->input->post('fecha');
            $fecha_sale = $this->input->post('fecha2');
            $j = 0; //contador de los registros procesados
            $filas_no_procesadas = array();
            for ($i = 0; $i < count($empleados); $i++) {
                //condicionar que todo toda la data existe y vaya integra 
                // print_r($posee_turno);
                // die();
                if (trim($posee_turno[$i]) == 'si' and $empleados[$i] > 0 and
                        $hora_entra[$i] != "" and $hora_sale[$i] != "" and
                        $fecha_entra[$i] != "" and $fecha_sale[$i] != ""
                ) {
                    //estructurar los datos para el insert
                    $fecha_ent = str_replace('/', '-', $fecha_entra[$i]);
                    $fecha_ent = date('Y-m-d H:i:s', strtotime($fecha_ent));
                    $fecha_sal = str_replace('/', '-', $fecha_sale[$i]);
                    $fecha_sal = date('Y-m-d H:i:s', strtotime($fecha_sal));

                    // $id_detalle_horario = 
                    $datos_busqueda = array($empleados[$i],
                        $fecha_ent,
                        $hora_entra[$i],
                        $hora_sale[$i]);
                    //buscar el horario correspondiente al registro de la marcación
                    $id_dxt_encontrado = $this->buscar_horario_correccion($datos_busqueda);
                    
                    if ($id_dxt_encontrado > 0) {
                        $insert_mar = array(
                            'mar_id_emp' => $empleados[$i]
                            , 'mar_id_dxt' => $id_dxt_encontrado
                            , 'mar_fecha_entrada' => $fecha_ent
                            , 'mar_hora_entrada' => $hora_entra[$i]
                            , 'mar_fecha_salida' => $fecha_sal
                            , 'mar_hora_salida' => $hora_sale[$i]
                            , 'mar_estado' => 1
                            , 'mar_usu_modificacion' => $this->tank_auth->get_user_id()
                            , 'mar_usu_creacion' => $this->tank_auth->get_user_id()
                            , 'mar_fecha_modificacion' => date("Y-m-d H:i:s")
                            , 'mar_fecha_creacion' => date("Y-m-d H:i:s")
                        );

                        $id_detalle = $this->gsatelite->ingresar('mar_marcacion', $insert_mar);

                        //llevar un conteo de los registro procesados y no procesados
                        ($id_detalle > 0) ? $j++ : $filas_no_procesadas[] = $i;
                    } else {
                        //almacenar las filas no procesadas
                        $filas_no_procesadas[] = $i;
                    }
                } else {
                    $filas_no_procesadas[] = $i;
                }
            }
            //al final redireccionar a consultar marcaciones y mostrar un mensaje de los resultados
            $no_procesadas = count($filas_no_procesadas);
            $detalle_no_procesadas = implode('-', $filas_no_procesadas);
            $datos = array('procesadas' => $j, 'no_procesadas' => $no_procesadas, 'f_no_procesadas' => $detalle_no_procesadas);
            $this->session->set_flashdata('datos', $datos);


            $this->gsatelite->show_dialog('Proceso Finalizado', 'marcacion/procesos/informe_marcaciones', 'success');
        }
    }

    /**
     * @author René Castaneda
     */
    public function informe_marcaciones($datos) {
        satelite_validar();
        if ($datos["procesadas"] > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Éxito.", 'texto_alerta' => "Proceso Finalizado");
        } 
        $this->session->set_flashdata($alerta);
        $d = $datos;
        $d['permisos_procesar'] = $this->gsatelite->get_permisos_opcion('confirmar_marcacion');
        $d['titulo_personal'] = "Carga de Marcación";
        cargarvista($d, null, 'marcacion/procesos/informe_marcaciones');
        //$this->_cargarvista($d, null);
    }

    /**
     * @author Raul E.
     * @return calcula entradas tardes y devuelve grid editable
     */
    public function confirmar_marcacion($edicion = null){
        satelite_validar();
        ini_set( 'memory_limit', '4048M' );        
        ini_set('max_execution_time', '9999');        
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            $area = $this->input->post('area');
            $empl = $this->input->post('empleado');
            $desde = formatear_fecha('Y-m-d', $this->input->post('desde'));
            $hasta = formatear_fecha('Y-m-d', $this->input->post('hasta'));
            if ($edicion) {
                $arreglo_edit = array(
                    'mar_id_dxt' => null,
                    'mar_fecha_entrada' => formatear_fecha('Y-m-d', $this->input->post('fec_inn')),
                    'mar_hora_entrada' => formatear_fecha('H:i:s', $this->input->post('hor_inn')),
                    'mar_fecha_salida' => formatear_fecha('Y-m-d', $this->input->post('fec_out')),
                    'mar_hora_salida' => formatear_fecha('H:i:s', $this->input->post('hor_out')),
                    'mar_fecha_modificacion' => date("Y-m-d H:i:s"),
                    'mar_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $this->gsatelite->actualizar_array('mar_marcacion', $arreglo_edit, array('mar_id' => $edicion));
                $correccion_array = array(
                    'cor_hora_desde' => formatear_fecha('H:i:s', $this->input->post('hor_inn')), 
                    'cor_hora_hasta' => formatear_fecha('H:i:s', $this->input->post('hor_out')), 
                    'cor_observacion' => 'Editar Procesamiento de Marcación', 
                    'cor_fecha' => date('Y-m-d H:i:s', strtotime($this->input->post('fec_inn'))), 
                    'cor_estado' => 1, 
                    'cor_fecha_mod' => date('Y-m-d H:i:s'), 
                    'cor_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_correc = $this->gsatelite->ingresar('cor_correcion', $correccion_array);
                $array_cxm = array(
                    'cxm_id_cor' => $id_correc, 
                    'cxm_id_mar' => $edicion, 
                    'cxm_estado' => 1, 
                    'cxm_fecha_mod' => date('Y-m-d H:i:s'),
                    'cxm_usu_mod' => $this->tank_auth->get_user_id()
                );
                $this->gsatelite->ingresar('cxm_correcionxmarcacion', $array_cxm);
            }
            $array_where = array('mar_fecha_entrada >=' => $desde, 'mar_fecha_entrada <=' =>   $hasta, 'mar_estado' => 1, 'mar_procesada' => 0);  
            if($empl != ""){
                $array_where['mar_id_emp'] = $empl;
            }
            if ($area != null) {
                $array_where['are_id'] = $area;
            }
            $procesadas = array();

            $marcaciones = $this->marcacion_model->get_reporte_marcacion2($array_where);
            $marcaciones = $this->procesarMarcacionesMultiples($marcaciones);

            foreach ($marcaciones as $k => &$val) {
                $procesadas[$val['mar_id']]['fe_inn'] = $val['mar_fecha_entrada'];
                $procesadas[$val['mar_id']]['fe_out'] = $val['mar_fecha_salida'];
                $procesadas[$val['mar_id']]['ho_inn'] = $val['mar_hora_entrada'];
                $procesadas[$val['mar_id']]['ho_out'] = $val['mar_hora_salida'];
                $procesadas[$val['mar_id']]['p_plan'] = $val['mar_procesada'];
                $procesadas[$val['mar_id']]['estado'] = $val['mar_estado'];
                $procesadas[$val['mar_id']]['cheked'] = $val['mar_revisado'];
                $procesadas[$val['mar_id']]['e_code'] = $val['emp_codigo'];
                $procesadas[$val['mar_id']]['e_name'] = $val['emp_nombre'].' '.$val['emp_apellido'];
                $procesadas[$val['mar_id']]['turnos'] = $val['mar_id_dxt'];
                $procesadas[$val['mar_id']]['t_name'] = $val['tur_nombre'];                
                $procesadas[$val['mar_id']]['la_inn'] = isset($val['la_inn']) ? $val['la_inn'] : 0;
                $procesadas[$val['mar_id']]['la_out'] = isset($val['la_out']) ? $val['la_out'] : 0;
                $procesadas[$val['mar_id']]['ho_ext'] = isset($val['horas_extras']) ? $val['horas_extras'] : 0;
                $procesadas[$val['mar_id']]['t_pendiente'] = isset($val['tiempo_pendiente']) ? $val['tiempo_pendiente'] : 0;
            }

            foreach ($procesadas as $key => $value) {
                $arreglo = array(
                    'mar_revisado' => 1,
                    'mar_id_dxt' => $value['turnos'],
                    'mar_entrada_tarde' => ($value['la_inn'] > 0) ? $value['la_inn'] : 0,
                    'mar_salida_temp' => ($value['la_out'] > 0) ? $value['la_out'] : 0,
                    'mar_hora_extra' => ($value['ho_ext'] > 0) ? $value['ho_ext'] : 0,
                    'mar_tiempo_pendiente' => (isset($value['t_pendiente']) && ($value['t_pendiente'] > 0)) ? $value['t_pendiente'] : 0,
                    'mar_fecha_modificacion' => date("Y-m-d H:i:s"),
                    'mar_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $this->gsatelite->actualizar_array('mar_marcacion', $arreglo, array('mar_id' => $key));
            }
            $data['detalles'] = $procesadas;
            $html = $this->load->view('marcacion/procesos/grid_conf_marcaciones', $data, true);
            echo $html;
            die();
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = "Procesar Marcaciones";
            $areas  = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado' => '1'), null, '', 'are_id', true); 
            $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data['areas']     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);
            $data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);            
            cargarvista($data, null, 'marcacion/procesos/confirmar_marcacion');
        }
    }

    /**
     * @author Raul E.
     * @return elimina un registro y devuelve la grid editable
     */
    public function eliminar_proc_marc($mar_id = null){
        satelite_validar();
        if ($mar_id) {
            $area = $this->input->post('area');
            $empl = $this->input->post('empleado');
            $desde = formatear_fecha('Y-m-d', $this->input->post('desde'));
            $hasta = formatear_fecha('Y-m-d', $this->input->post('hasta'));
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('confirmar_marcacion');
            $correcciones = $this->gsatelite->get_tabla('cxm_correcionxmarcacion', array('cxm_id_mar' => $mar_id));
            if (count($correcciones) > 0) {
                foreach ($correcciones as $kc => $vlc) {
                    $id = $vlc['cxm_id_cor'];
                    $this->gsatelite->borrado_general('cxm_correcionxmarcacion', array('cxm_id' => $vlc['cxm_id']));
                    $this->gsatelite->borrado_general('cor_correcion', array('cor_id' => $id));
                }
            }
            $this->gsatelite->borrado_general('mar_marcacion', array('mar_id' => $mar_id));
            $array_where = array('mar_fecha_entrada >=' => $desde, 'mar_fecha_entrada <=' =>   $hasta, 'mar_estado' => 1, 'mar_procesada' => 0);  
            if($empl != ""){
                $array_where['mar_id_emp'] = $emp;
            }
            if ($area != null) {
                $array_where['are_id'] = $area;
            }
            $procesadas = array();
            $marcaciones = $this->marcacion_model->get_reporte_marcacion2($array_where);
            foreach ($marcaciones as $k => $val) {
                $procesadas[$val['mar_id']]['fe_inn'] = $val['mar_fecha_entrada'];
                $procesadas[$val['mar_id']]['fe_out'] = $val['mar_fecha_salida'];
                $procesadas[$val['mar_id']]['ho_inn'] = $val['mar_hora_entrada'];
                $procesadas[$val['mar_id']]['ho_out'] = $val['mar_hora_salida'];
                $procesadas[$val['mar_id']]['p_plan'] = $val['mar_procesada'];
                $procesadas[$val['mar_id']]['estado'] = $val['mar_estado'];
                $procesadas[$val['mar_id']]['cheked'] = $val['mar_revisado'];
                $procesadas[$val['mar_id']]['e_code'] = $val['emp_codigo'];
                $procesadas[$val['mar_id']]['e_name'] = $val['emp_nombre'].' '.$val['emp_apellido'];
                $procesadas[$val['mar_id']]['la_inn'] = $val['mar_entrada_tarde'];
                $procesadas[$val['mar_id']]['la_out'] = $val['mar_salida_temp'];
                $procesadas[$val['mar_id']]['ho_ext'] = $val['mar_hora_extra'];
                $procesadas[$val['mar_id']]['turnos'] = $val['mar_id_dxt'];
                $procesadas[$val['mar_id']]['t_name'] = $val['tur_nombre'];
            }
            $data['detalles'] = $procesadas;
            $html = $this->load->view('marcacion/procesos/grid_conf_marcaciones', $data, true);
            // echo json_encode(array('resultado'=>$html));
            echo $html;
        }        
    }

    public function pruebas_marcacion() {
        //echo "hola";
        //$par = $this->gsatelite->get_parametro('hola_Mundo');
        $par = $this->gsatelite->get_parametro('TIEMPO_BUSQUEDA_HORARIO');
        $tiempo_busqueda = (trim($par) != "" and count(explode(':', $par)) == 3) ? trim($par) : '02:00:00';
        //    echo $tiempo_busqueda; die();

        $h1 = $this->gsatelite->convertir_hora('14:30:00', 1, $tiempo_busqueda, 1);
        $h2 = $this->gsatelite->convertir_hora('21:00:00', 1, $tiempo_busqueda, 2);
        //echo ($h2)/60/60; die();
        //echo ($h2-$h1)/60/60; die();
        $horario1 = $this->gsatelite->convertir_hora('14:00:00');
        $horario2 = $this->gsatelite->convertir_hora('22:00:00');

        // if( $h1 >= $k['deh_hora_entrada'] and $h2 <= $k['deh_hora_salida']) {
        if ($h1 >= $horario1 and $h2 <= $horario2) {
            //    echo "entro";
        }
        //die(); 
        $datos = array('1', '2015-03-15', '20:00:00', '07:00:00');
        $id_h = $this->buscar_horario_correccion($datos);
        // echo $id_h;

        $hora_cambia = $this->gsatelite->convertir_hora_militar('08:00:00 p.m.');
        echo $hora_cambia;
    }

    function probar_excel() {

        $ta = "<table border=1><tr><td>campouno</td><td>campodos</td></tr>";
        for ($i = 1; $i <= 603; $i++) {
            $ta .= "<tr><td>$i</td><td>1</td>";
            $ta .= "<tr><td>$i</td><td>2</td>";
            $ta .= "<tr><td>$i</td><td>3</td>";
            # code...
        }
        $ta .= "</table>";

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment;filename=para_sai.xls");
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $ta;
    }

    /* FUNCIONES DE PRUEBAS PARA PROCESAR LA MARCACIÓN */
    function cargar_marcacion2() {
        satelite_validar();
        if ($_FILES) {
            $this->load->library('excel/excel_reader.php');
            $excel = new Excel_reader;
            try {
                $excel->read($_FILES["excel_marcacion"]["tmp_name"]);
            } catch (Exception $e) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cargar Marcación", 'texto_alerta' => "El archivo Seleccionado no es legible, Porfavor verifique su contenido");
                $this->session->set_flashdata($alerta);
                redirect('/marcacion/procesos/cargar_marcacion2');
            }
            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));/////temporal isdemu
            $nr_sheets = count($excel->sheets);// numero de hojas del archivo
            $array = array_values($excel->sheets[0]["cells"]);
            $formato = $this->input->post('formato_personalizado');
            if ($formato > 0) {
                $campos = array();
                $columnasXcel = $array[0];
                unset($array[0]);//celdas de la hoja 1, sin los titulos
                $parametrizado = $this->gsatelite->get_tabla("fcm_formato_carga_marcacion", array("fcm_id_fmp"=>1,"fcm_estado"=>1)); //$this->campos_parametro_fac();
                $excel->sheets[0]["numRows"] = count($array);
                $excel->sheets[0]["cells"] = $array;
                $excel->sheets[0]["mi_formato"] = $parametrizado;
                if (count($columnasXcel) > 2) {
                    $respuesta  = '<center><table border="1" class="responsive table table-bordered contenedor" id="data_expand" name="data_expand"><thead><tr>';
                    foreach ($columnasXcel as $k => $v) {
                        $campos[$v] = $k;
                        $respuesta .= '<th>' . $v . '</th>';
                    }
                    $conf_form = $this->gsatelite->get_registro("fmp_formato_marcador_personalizado", array("fmp_id" => $formato));
                    if ($conf_form->fmp_fecha_hora > 0) {
                        // 0=fecha -hora en distinta celda | 1=fecha-hora misma celda
                        $respuesta .= '<th></th>';
                    }
                    $respuesta .= '</tr></thead>';
                    $excel->sheets[0]["col_titulo"] = $campos;
                    for ($i = 0; $i < $nr_sheets; $i++) {
                        // Limpiar data si empresa es isdemu quita marcaciones con menos de 1 minutos de diferencia (parametro: SYS_DIFERENCIA_ENTRE_MARCACIONES_MIN)
                        if ($empresa == "isdemu") {
                            $cleanData = $this->filtrarData($excel->sheets[$i]);
                            if (isset($cleanData) && $cleanData) {
                                $excel->sheets[$i]["numRows"] = $cleanData['numRows'];
                                $excel->sheets[$i]["cells"] = $cleanData['cells'];

                            }                                
                        }

                        //Procesa los datos de cada hoja del excel
                        $excel_data = $this->sheetData2($excel->sheets[$i], $formato);
                        $respuesta .= $excel_data;
                    }
                    $respuesta .= '</table></center>';
                } else {
                    $respuesta = '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center><br/><center>';
                    $respuesta .= '<h3>La hoja actual no cumple con la cantidad mínima de columnas </h3><br/>';
                    $respuesta .= '<h4>Favor revisar documento de Excel e intente nuevamente</h4></center><br/>';
                }
                $excel_data =  $respuesta;
            } else {
                unset($array[0]);//celdas de la hoja 1, sin los titulos
                $excel->sheets[0]["numRows"] = count($array);
                $excel->sheets[0]["cells"] = $array;
                $excel_data = '';
                // die(var_dump($excel->boundsheets[0]['name']));
                for ($i = 0; $i < $nr_sheets; $i++) {
                    if ($excel->sheets[$i]['numCols'] == 5) {
                        $re_h = '<center><table border="1" class="responsive table table-bordered contenedor" id="data_expand" name="data_expand">';
                        $re_h .= '<thead>';
                        $re_h .= '<tr>';
                        $re_h .= '<th>CODIGO</th>';
                        $re_h .= '<th>DEPARTAMENTO / AREA</th>';
                        $re_h .= '<th>EMPLEADA/O</th>';
                        $re_h .= '<th>FECHA ENTRADA</th>';
                        $re_h .= '<th>HORA ENTRADA</th>';
                        $re_h .= '<th>FECHA SALIDA</th>';
                        $re_h .= '<th>HORA SALIDA</th>';
                        $re_h .= '</tr>';
                        $re_h .= '</thead>';
                        $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center>'; 
                        $excel_data .= $re_h;
                        $excel_data .= $this->sheetData2($excel->sheets[$i]);
                        $excel_data .= '<br/>';
                    } elseif ($excel->sheets[$i]['numCols'] == 4 && $empresa == "isdemu") {
                        $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center>'; 
                        $excel_data .= '<center><table border="1" class="responsive table table-bordered contenedor" id="data_expand" name="data_expand">';
                        $excel_data .= '<thead><tr>';
                        $excel_data .= '<th>CODIGO</th>';
                        $excel_data .= '<th>DEPARTAMENTO / AREA</th>';
                        $excel_data .= '<th>EMPLEADA/O</th>';
                        $excel_data .= '<th>FECHA ENTRADA</th>';
                        $excel_data .= '<th>HORA ENTRADA</th>';
                        $excel_data .= '<th>FECHA SALIDA</th>';
                        $excel_data .= '<th>HORA SALIDA</th>';
                        $excel_data .= '</tr></thead>';
                        $excel_data .= $this->sheetData2($excel->sheets[$i]);
                        $excel_data .= '<br/>';
                    } else {
                        $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center><br/><center><h3>';
                        $excel_data .= 'La hoja actual no cumple con el formato de columnas: " [CODIGO][AREA][EMPLEADA/O][FECHA ENT-SAL][HORA ENT-SAL]"</h3><br/>';
                        $excel_data .= '<h4>Favor revisar documento de excel y cantidad de columas</h4></center><br/>';
                    }
                }
            }
            $sltformatos = null;
            if (true) {
                $dropdown = $this->gsatelite->get_dropdown('fmp_formato_marcador_personalizado','fmp_nombre','', array('fmp_estado'=>1), $formato, '', 'fmp_id', true);
                $sltformatos = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            }
            $data['formatos'] = $sltformatos;
            $data['tabla_html'] = $excel_data;
            $data['titulo_personal'] = "Cargar marcación";
            $this->_cargarvista($data, null);
        } else {
            $formatos = null;
            if (true) {
                $dropdown = $this->gsatelite->get_dropdown('fmp_formato_marcador_personalizado','fmp_nombre','', array('fmp_estado'=>1), null, '', 'fmp_id', true);
                $formatos = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
            }
            $data['formatos'] = $formatos;
            $data['titulo_personal'] = "Cargar marcación";
            $this->_cargarvista($data, null);
        }
    }

    function sheetData2($sheet, $formato = null) {
        $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));/////temporal isdemu
        $re = '<tbody id="contenedor">';
        $unpacker = $this->procesar_info2($sheet , $formato);
        $turnos_empleados = $unpacker['turnos_empleados'];
        $addmarc = array();
        if (isset($unpacker['conturnos']) && count($unpacker['conturnos']) > 0) {
            foreach ($unpacker['conturnos'] as $key => $val) {
                // Primero convertir a fecha para obtener el minimo y maximo
                $timestamps = array_map(function($f) {
                    return DateTime::createFromFormat("j/n/Y H:i:s", $f)->getTimestamp();
                }, $val);

                $minfch = date("d/m/Y H:i:s", min($timestamps));
                $maxfch = date("d/m/Y H:i:s", max($timestamps));

                $fechaRef = DateTime::createFromFormat("d/m/Y H:i:s", $minfch);

                $mesActual = $fechaRef->format('m');      // Ejemplo: "11"
                $anioActual = $fechaRef->format('Y');     // Ejemplo: "2025"

                $primerDiaMes = (new DateTime("$anioActual-$mesActual-01"))->format('d/m/Y H:i:s');
                $ultimoDiaMes = (new DateTime("$anioActual-$mesActual-01"))
                    ->modify('last day of this month')
                    ->format('d/m/Y H:i:s');             

                $addmarc[] = $key . '_' . $primerDiaMes . '_' . $ultimoDiaMes;
            }
        }
        $arryturn = implode("##", $addmarc);
        $rows = $sheet['numRows'];
        if ($formato > 0) {
            $cols = $sheet['numCols'];
            $f_code = $f_finn = $f_fout = $f_hinn = $f_hout = $f_turn = 0;
            $conf_form = $this->gsatelite->get_registro("fmp_formato_marcador_personalizado", array("fmp_id" => $formato));
            $deta_form = $this->gsatelite->get_tabla("fcm_formato_carga_marcacion", array("fcm_id_fmp" => $formato, "fcm_estado" => 1));
            foreach ($deta_form as $key => $value) {
                switch ($value['fcm_campo_destino']) {
                    case "emp_codigo":
                        $f_code = $value["fcm_posicion_columna"];
                        break;
                    case "mar_fecha_entrada":
                        $f_finn = $value["fcm_posicion_columna"];
                        break;
                    case "mar_fecha_salida":
                        $f_fout = $value["fcm_posicion_columna"];
                        break;
                    case "mar_hora_entrada":
                        $f_hinn = $value["fcm_posicion_columna"];
                        break;
                    case "mar_hora_salida":
                        $f_hout = $value["fcm_posicion_columna"];
                        break;
                    case "tur_nombre":
                        $f_turn = $value["fcm_posicion_columna"];
                        break;
                }
            }
            for ($x = 0; $x < $rows; $x++) {
                $nxt = ($x < ($rows - 1)) ? ($x + 1) : -1;
                $lst = ($x < ($rows - 1)) ? ($x - 1) : $rows-2;
                $codigo_emp = (isset($unpacker[$f_code][$x])) ? $unpacker[$f_code][$x] : null;
                $codigo_emp_posterior = (isset($unpacker[$f_code][$nxt]) && $unpacker[$f_code][$nxt] != "") ? $unpacker[$f_code][$nxt] : null;
                if ($conf_form->fmp_fecha_hora > 0) {
                    $fmarcacion_posterior = (isset($unpacker[$f_finn][$nxt]) && $unpacker[$f_finn][$nxt] != "") ? $unpacker[$f_finn][$nxt]: null;
                    $hmarcacion_posterior = (isset($unpacker[$f_hinn][$nxt]) && $unpacker[$f_hinn][$nxt] != "") ? $unpacker[$f_hinn][$nxt] : null;
                    $fnext = explode(' ', $fmarcacion_posterior);
                    $hnext = explode(' ', $hmarcacion_posterior);
                    $fecha_marcacion_posterior = $fnext[0];
                    $hora_marcacion_posterior  = $hnext[1];

                    $f1 = explode(' ', $unpacker[$f_finn][$x]);
                    $f2 = explode(' ', $unpacker[$f_fout][$x]);
                    if ($conf_form->fmp_dia_separado > 0) {
                        $fecha_marcacion_1 = (isset($unpacker[$f_finn][$x])) ? $f1[0] : null;
                        $fecha_marcacion_2 = (isset($unpacker[$f_fout][$x])) ? $f2[0] : null;
                    } else {
                        $fecha_marcacion_1 = (isset($unpacker[$f_finn][$x])) ? $f1[0] : null;
                        $fecha_marcacion_2 = (isset($unpacker[$f_fout][$x])) ? $f2[0] : $fecha_marcacion_1;
                    }
                    if ($conf_form->fmp_hora_separada > 0) {
                        $hora_marcacion_1 = (isset($unpacker[$f_hinn][$x])) ? $f1[1] : null;
                        $hora_marcacion_2 = (isset($unpacker[$f_hout][$x])) ? $f2[1] : null;
                    } else {
                        $hora_marcacion_1 = (isset($unpacker[$f_hinn][$x])) ? $f1[1] : null;
                        $hora_marcacion_2 = (isset($unpacker[$f_hout][$x])) ? $f2[1] : $hora_marcacion_1;
                    }
                } else {
                    $fecha_marcacion_posterior = (isset($unpacker[$f_finn][$nxt]) && $unpacker[$f_finn][$nxt] != "") ? $unpacker[$f_finn][$nxt]: null;
                    $hora_marcacion_posterior  = (isset($unpacker[$f_hinn][$nxt]) && $unpacker[$f_hinn][$nxt] != "") ? $unpacker[$f_hinn][$nxt] : null;
                    if ($conf_form->fmp_dia_separado > 0) {
                        $fecha_marcacion_1 = (isset($unpacker[$f_finn][$x])) ? $unpacker[$f_finn][$x] : null;
                        $fecha_marcacion_2 = (isset($unpacker[$f_fout][$x])) ? $unpacker[$f_fout][$x] : null;
                    } else {
                        $fecha_marcacion_1 = (isset($unpacker[$f_finn][$x])) ? $unpacker[$f_finn][$x] : null;
                        $fecha_marcacion_2 = (isset($unpacker[$f_fout][$x])) ? $unpacker[$f_fout][$x] : $fecha_marcacion_1;
                    }
                    if ($conf_form->fmp_hora_separada > 0) {
                        $hora_marcacion_1 = (isset($unpacker[$f_hinn][$x])) ? $unpacker[$f_hinn][$x] : null;
                        $hora_marcacion_2 = (isset($unpacker[$f_hout][$x])) ? $unpacker[$f_hout][$x] : null;
                    } else {
                        $hora_marcacion_1 = (isset($unpacker[$f_hinn][$x])) ? $unpacker[$f_hinn][$x] : null;
                        $hora_marcacion_2 = (isset($unpacker[$f_hout][$x])) ? $unpacker[$f_hout][$x] : $hora_marcacion_1;
                    }
                }
                if(isset($fecha_marcacion_1)) {
                    $date = DateTime::createFromFormat('d/m/Y', $fecha_marcacion_1);
                    if ($date) {
                        $dia_fecha_adicional_marcacion = $date->modify('+1 day')->format('d/m/Y');
                    } else {
                        $dia_fecha_adicional_marcacion = null;
                    }
                } else {
                    $dia_fecha_adicional_marcacion = null;
                }
                if (isset($codigo_emp)) {
                    $re .= "<tr>";
                    for ($y = 1; $y <= $cols; $y++) {
                        $re .= '<td><span>' . $unpacker[$y][$x] . '</span></td>' . "\n";
                    }
                    if ($conf_form->fmp_fecha_hora > 0) {
                        $re .= '<td>';
                        if (is_numeric($codigo_emp)) {
                            $re .= '<input type="hidden" name="empleado[]" class="empleado" value="' . $codigo_emp . '"/>';
                            if ($codigo_emp == $codigo_emp_posterior && $fecha_marcacion_1 == $fecha_marcacion_posterior) { 
                                $re .= '<input type="hidden" name="fecha_entra[]" class="fecha_entra" value="' . $fecha_marcacion_1 . '"/>';
                                $re .= '<input type="hidden" name="hora_entra[]" class="hora_entra" value="' . $hora_marcacion_1 . '"/>';
                                $re .= '<input type="hidden" name="fecha_sale[]" class="fecha_sale" value="' . $fecha_marcacion_posterior . '"/>';
                                $re .= '<input type="hidden" name="hora_sale[]" class="hora_sale" value="' . $hora_marcacion_posterior . '"/>';
                                $re .= $fecha_marcacion_posterior . ' ' . $hora_marcacion_posterior;
                                foreach ($unpacker as &$column) {
                                    unset($column[$nxt]);
                                }
                            }elseif ($codigo_emp == $codigo_emp_posterior && $dia_fecha_adicional_marcacion == $fecha_marcacion_posterior && $hora_marcacion_1 > $hora_marcacion_posterior && (!isset($turnos_empleados[$codigo_emp]['tur_permite_traslape']) || $turnos_empleados[$codigo_emp]['tur_permite_traslape'] == 1)) {
                                $re .= '<input type="hidden" name="fecha_entra[]" class="fecha_entra" value="' . $fecha_marcacion_1 . '"/>';
                                $re .= '<input type="hidden" name="hora_entra[]" class="hora_entra" value="' . $hora_marcacion_1 . '"/>';
                                $re .= "<input type='hidden' name='fecha_sale[]' class='fecha_sale' value='" . $fecha_marcacion_posterior . "'/>";
                                $re .= "<input type='hidden' name='hora_sale[]' class='hora_sale' value='" . $hora_marcacion_posterior . "'/>";
                                foreach ($unpacker as &$column) {
                                    unset($column[$nxt]);
                                }
                            } else {
                                $re .= '<input type="hidden" name="fecha_entra[]" class="fecha_entra" value="' . $fecha_marcacion_1 . '"/>';
                                $re .= '<input type="hidden" name="hora_entra[]" class="hora_entra" value="' . $hora_marcacion_1 . '"/>';
                                $re .= "<input type='hidden' name='fecha_sale[]' class='fecha_sale' value=''/>";
                                $re .= "<input type='hidden' name='hora_sale[]' class='hora_sale' value=''/>";
                            }
                        }
                        $re .= '</td>';
                    } else {
                        $re .= '<input type="hidden" name="fecha_entra[]" class="fecha_entra" value="' . $fecha_marcacion_1 . '"/>';
                        $re .= '<input type="hidden" name="hora_entra[]" class="hora_entra" value="' . $hora_marcacion_1 . '"/>';
                        if (isset($fecha_marcacion_2) && $conf_form->fmp_dia_separado > 0) {
                            //MISMA FILA 2 FECHAS
                            $re .= "<input type='hidden' name='fecha_sale[]' class='fecha_sale' value='" . $fecha_marcacion_2 . "'/>";
                        }
                        if ($conf_form->fmp_hora_separada > 0) {
                            $re .= "<input type='hidden' name='hora_sale[]' class='hora_sale' value='" . $hora_marcacion_2 . "'/>";
                        }
                    }                    
                    $re .= "</tr>". "\n";
                }
            }
            $re .= '<input type="hidden" name="no_leidas" value="' . $unpacker['no'] . '"/>'; 
            $re .= '<input type="hidden" name="leidas" value="' . $unpacker['si'] . '"/>'; 
            $re .= '<input type="hidden" name="array_turn" value="' . $arryturn . '"/>';
            $re .= '<input type="hidden" name="formato_personalizado" value="' . $formato . '"/>';
        } else {
            $cols = ($empresa == "isdemu") ? 5 : $sheet['numCols'];
            for ($x = 1; $x <= $rows; $x++) {
                $codigo_emp = (isset($unpacker[0][$x - 1])) ? $unpacker[0][$x - 1]: null;
                $existe_emp = (isset($unpacker[2][$x - 1]) && $unpacker[2][$x - 1] != "") ? true : false; //nombre_empleado
                $fecha_marcacion = (isset($unpacker[3][$x - 1])) ? $unpacker[3][$x - 1]: null;
                $hora_marcacion = (isset($unpacker[4][$x - 1])) ? $unpacker[4][$x - 1]: null;
                if(isset($fecha_marcacion)) {
                    $date = DateTime::createFromFormat('d/m/Y', $fecha_marcacion);
                    if ($date) {
                        $dia_fecha_adicional_marcacion = $date->modify('+1 day')->format('d/m/Y');
                    } else {
                        $dia_fecha_adicional_marcacion = null;
                    }
                } else {
                    $dia_fecha_adicional_marcacion = null;
                }
                $codigo_emp_posterior = (isset($unpacker[0][$x]) && $unpacker[0][$x] != "") ? $unpacker[0][$x]: null;
                $fecha_marcacion_posterior = (isset($unpacker[3][$x]) && $unpacker[3][$x] != "") ? $unpacker[3][$x]: null;
                $hora_marcacion_posterior = (isset($unpacker[4][$x]) && $unpacker[4][$x] != "") ? $unpacker[4][$x]: null;
                if (isset($codigo_emp)) {
                    $re .= "<tr>\n";
                    for ($y = 1; $y <= $cols; $y++) { 
                        if ($existe_emp) {
                            if ($codigo_emp == $codigo_emp_posterior && $fecha_marcacion == $fecha_marcacion_posterior) { 
                                //tiene entrada y salida
                                if ($unpacker[$y - 1][$x - 1] != '') {
                                    switch ($y) {
                                        case 1:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='empleado[]' class='empleado' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";               
                                        break;
                                        case 2:
                                            $re .= "<td style='text-align: left;'><span>" . utf8_encode($unpacker[$y - 1][$x - 1]) . "</span>";
                                            $re .= "<input type='hidden' name='nombre_area_excel[]' class='nombre_area_excel' value='" . utf8_encode($unpacker[$y - 1][$x - 1]) . "'/></td>\n";                      
                                        break;
                                        case 3:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='nombre_emp_excel[]' class='nombre_emp_excel' value='" . utf8_encode($unpacker[$y - 1][$x - 1]) . "'/></td>\n";                                     
                                        break;
                                        case 4:
                                            $re .= "<td style='text-align: left;'><span>" . formatear_fecha('d-m-Y', $unpacker[$y - 1][$x - 1]) . "</span>";
                                            $re .= "<input type='hidden' name='fecha_entra[]' class='fecha_entra' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";
                                        break;
                                        case 5:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='hora_entra[]' class='hora_entra' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";
                                        break;
                                    }
                                } else {
                                    $re .= "<td style='text-align: left;'></td>\n";
                                }
                            } else if ($codigo_emp == $codigo_emp_posterior && $dia_fecha_adicional_marcacion == $fecha_marcacion_posterior && $hora_marcacion > $hora_marcacion_posterior) {
                                if ($unpacker[$y - 1][$x - 1] != '') {
                                    switch ($y) {
                                        case 1:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='empleado[]' class='empleado' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";               
                                        break;
                                        case 2:
                                            $re .= "<td style='text-align: left;'><span>" . utf8_encode($unpacker[$y - 1][$x - 1]) . "</span>";
                                            $re .= "<input type='hidden' name='nombre_area_excel[]' class='nombre_area_excel' value='" . utf8_encode($unpacker[$y - 1][$x - 1]) . "'/></td>\n"; 
                                        break;
                                        case 3:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='nombre_emp_excel[]' class='nombre_emp_excel' value='" . utf8_encode($unpacker[$y - 1][$x - 1]) . "'/></td>\n";
                                        break;
                                        case 4:
                                            $re .= "<td style='text-align: left;'><span>" . formatear_fecha('d-m-Y', $unpacker[$y - 1][$x - 1]) . "</span>";
                                            $re .= "<input type='hidden' name='fecha_entra[]' class='fecha_entra' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";
                                        break;
                                        case 5:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='hora_entra[]' class='hora_entra' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";
                                        break;
                                    }
                                } else {
                                    $re .= "<td style='text-align: left;'></td>\n";
                                }
                            } else {
                                //solo tiene entrada
                                if ($unpacker[$y - 1][$x - 1] != '') {
                                    switch ($y) {
                                        case 1:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='empleado[]' class='empleado' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";
                                        break;
                                        case 2:
                                            $re .= "<td style='text-align: left;'><span>" . utf8_encode($unpacker[$y - 1][$x - 1]) . "</span>";
                                            $re .= "<input type='hidden' name='nombre_area_excel[]' class='nombre_area_excel' value='" . utf8_encode($unpacker[$y - 1][$x - 1]) . "'/></td>\n";
                                        break;
                                        case 3:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='nombre_emp_excel[]' class='nombre_emp_excel' value='" . utf8_encode($unpacker[$y - 1][$x - 1]) . "'/></td>\n";
                                        break;
                                        case 4:
                                            $re .= "<td style='text-align: left;'><span>" . formatear_fecha('d-m-Y', $unpacker[$y - 1][$x - 1]) . "</span>";
                                            $re .= "<input type='hidden' name='fecha_entra[]' class='fecha_entra' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";
                                        break;
                                        case 5:
                                            $re .= "<td style='text-align: left;'><span>" . $unpacker[$y - 1][$x - 1] . "</span>";
                                            $re .= "<input type='hidden' name='hora_entra[]' class='hora_entra' value='" . $unpacker[$y - 1][$x - 1] . "'/></td>\n";
                                        break;
                                    }
                                } else {
                                    $re .= "<td style='text-align: left;'></td>\n";
                                }
                            }
                        } else {
                            if ($y > 1) {
                                $re .= "<td style='text-align: left;'></td>\n";
                            } else {
                                $re .= "<td style='text-align: left;'>" . $unpacker[$y - 1][$x - 1] . "</td>\n";
                            }
                        }                
                    }
                    if ($codigo_emp == $codigo_emp_posterior && $fecha_marcacion == $fecha_marcacion_posterior) {
                        $re .= "<td style='text-align: left;'><span>" . $fecha_marcacion_posterior . "</span>";
                        $re .= "<input type='hidden' name='fecha_sale[]' class='fecha_sale' value='" . $fecha_marcacion_posterior . "'/></td>\n";
                        $re .= "<td style='text-align: left;'><span>" . $hora_marcacion_posterior . "</span>";
                        $re .= "<input type='hidden' name='hora_sale[]' class='hora_sale' value='" . $hora_marcacion_posterior . "'/></td>\n";
                        // Eliminar la fila posterior del $unpacker
                        foreach ($unpacker as &$column) {
                            unset($column[$x]);
                        }
                        // Reindexar el array para mantener coherencia
                        foreach ($unpacker as &$column) {
                            if (is_array($column)) {
                                $column = array_values($column);
                            }
                        }
                    } else if ($codigo_emp == $codigo_emp_posterior && $dia_fecha_adicional_marcacion == $fecha_marcacion_posterior && $hora_marcacion > $hora_marcacion_posterior) {
                        $re .= "<td style='text-align: left;'><span>" . $fecha_marcacion_posterior . "</span>";
                        $re .= "<input type='hidden' name='fecha_sale[]' class='fecha_sale' value='" . $fecha_marcacion_posterior . "'/></td>\n";
                        $re .= "<td style='text-align: left;'><span>" . $hora_marcacion_posterior . "</span>";
                        $re .= "<input type='hidden' name='hora_sale[]' class='hora_sale' value='" . $hora_marcacion_posterior . "'/></td>\n";
                        // Eliminar la fila posterior del $unpacker
                        foreach ($unpacker as &$column) {
                            unset($column[$x]);
                        }                        
                        // Reindexar el array para mantener coherencia
                        foreach ($unpacker as &$column) {
                            if (is_array($column)) {
                                $column = array_values($column);
                            }
                        }
                    } else {
                        $re .= "<td style='text-align: left;'><span></span>";
                        $re .= "<input type='hidden' name='fecha_sale[]' class='fecha_sale' value=''/></td>\n";
                        $re .= "<td style='text-align: left;'><span></span>";
                        $re .= "<input type='hidden' name='hora_sale[]' class='hora_sale' value=''/></td>\n";
                    }
                    $re .= "</tr>\n";
                }
            }
            $re .= '<input type="hidden" name="no_leidas" value="' . $unpacker['no'] . '"/>'; 
            $re .= '<input type="hidden" name="leidas" value="' . $unpacker['si'] . '"/>'; 
            $re .= '<input type="hidden" name="array_turn" value="' . $arryturn . '"/>'; 
            $re .= '</tbody></table></center>'; 
        }
        return $re;
    }

    function procesar_info2($hoja, $personalized_format = null) { //EXCEL PROCESAR INFO
        // $turnos_empleado = variable para saber si el turno permite traslape de dias 
        $prueba = $conturno = $turnos_empleados =  array();
        if ($personalized_format > 0) {
            $leidas = $no_leidas = 0;
            $c_code = $c_finn = $c_fout = $c_hinn = $c_hout = $c_turn = 0;
            $condiciones = array();
            $filas = $hoja['numRows'];
            $colum = $hoja['numCols'];
            foreach ($hoja['col_titulo'] as $k => $val) {
                $condiciones[$val] = array();
            }
            for ($x = 1; $x <= $filas; $x++) {
                for ($y = 1; $y <= $colum; $y++) {
                    $prueba[$y-1][$x-1] = $hoja['cells'][$x][$y];
                }
            }
            $conf_form = $this->gsatelite->get_registro("fmp_formato_marcador_personalizado", array("fmp_id" => $personalized_format));
            $deta_form = $this->gsatelite->get_tabla("fcm_formato_carga_marcacion", array("fcm_id_fmp" => $personalized_format, "fcm_estado" => 1));
            foreach ($deta_form as $key => $value) {
                switch ($value['fcm_campo_destino']) {
                    case "emp_codigo":
                        $c_code = $value["fcm_posicion_columna"];
                        break;
                    case "mar_fecha_entrada":
                        $c_finn = $value["fcm_posicion_columna"];
                        break;
                    case "mar_fecha_salida":
                        $c_fout = $value["fcm_posicion_columna"];
                        break;
                    case "mar_hora_entrada":
                        $c_hinn = $value["fcm_posicion_columna"];
                        break;
                    case "mar_hora_salida":
                        $c_hout = $value["fcm_posicion_columna"];
                        break;
                    case "tur_nombre":
                        $c_turn = $value["fcm_posicion_columna"];
                        break;
                }
            }
            $necesarios = array($c_code, $c_finn, $c_fout, $c_hinn, $c_hout);
            foreach ($prueba as $col => $vcol) {
                if (in_array(($col + 1), $necesarios)) {
                    if ($col == ($c_code - 1)) {
                        $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));/////temporal isdemu
                        foreach ($vcol as $k => $fila) {
                            if ($empresa == "isdemu") {
                                $id_emp = $this->db->select('emp_id')->where("CONVERT(SUBSTR(emp_codigo FROM 3), UNSIGNED) = $fila")->from('emp_empleado')->get()->result_array();
                            } else {
                                $id_emp = $this->db->select('emp_id')->where('emp_codigo', $fila)->from('emp_empleado')->get()->result_array();
                            }
                            if (count($id_emp) > 0) {
                                $leidas++;
                                $resulters = $this->db->select()->where('emp_id', @$id_emp[0]['emp_id'])->from('emp_empleado')->get()->row_array();
                                $nombre_emp = '<span>' . $resulters['emp_nombre'] . ' ' . $resulters['emp_apellido'] . '</span>';
                                                $this->db->join('tur_turno', 'tur_id = txe_id_tur');
                                $resulter_tur = $this->gsatelite->get_tabla('txe_turnoxempleado', array('txe_id_emp'=>$id_emp[0]['emp_id'], 'txe_estado'=>1));
                                if (count($resulter_tur) > 0) {
                                    $conturno[$id_emp[0]['emp_id'] .  '_' . $resulter_tur[0]['txe_id_tur']][$k] = $prueba[$c_finn - 1][$k];
                                    
                                    if (!isset($turnos_empleados[$fila])) {
                                        $turnos_empleados[$fila] = ['tur_id' => $resulter_tur[0]['tur_id'], 'tur_permite_traslape' => $resulter_tur[0]['tur_permite_traslape']];
                                    }
                                }
                                $condiciones[$c_code][$k] = $fila;
                            } else {
                                $no_leidas++;
                                $condiciones[$c_code][$k] = "<span>Código no se encuentra: " . $fila . "</span>";
                            }
                        }
                    }
                    if ($col == ($c_finn - 1)) {
                        foreach ($vcol as $k => $fila) {
                            $condiciones[$c_finn][$k] = formatear_fecha('d/m/Y', $fila);
                        }
                    }
                    if ($col == ($c_fout - 1) && $conf_form->fmp_dia_separado > 0) {
                        foreach ($vcol as $k => $fila) {
                            $condiciones[$c_fout][$k] = $fila;
                        }
                    }
                    if ($col == ($c_hinn - 1)) {
                        foreach ($vcol as $k => $fila) {
                            $datos_entra = explode(' ', $fila);
                            if ($conf_form->fmp_fecha_hora > 0) {
                                $hora_entrar = (count($datos_entra) > 2) ? $datos_entra[1] . ' ' . $datos_entra[2] : $datos_entra[1];
                                $hora_entra = formatear_fecha('H:i:s', $hora_entrar);
                                if (isset($condiciones[$c_finn][$k])) {
                                    $condiciones[$c_finn][$k] .= " " . $hora_entra;
                                } else {
                                    $condiciones[$c_hinn][$k] = $hora_entra;
                                }
                            } else {
                                $hora_entrar = (count($datos_entra) > 1) ? $datos_entra[0] . ' ' . $datos_entra[1] : $datos_entra[0];
                                $condiciones[$c_hinn][$k] = formatear_fecha('H:i:s', $hora_entrar);
                            }
                        }
                    }
                    if ($col == ($c_hout - 1) && $conf_form->fmp_hora_separada > 0) {
                        foreach ($vcol as $k => $fila) {
                            $datos_entra = explode(' ', $fila);
                            $hora_entrar = (count($datos_entra) > 1) ? $datos_entra[0] . ' ' . $datos_entra[1] : $datos_entra[0];
                            $hora_entra = formatear_fecha('H:i:s', $hora_entrar);
                            $condiciones[$c_hout][$k] = $hora_entra;
                        }
                    }                    
                } else {
                    foreach ($vcol as $kf => $fila) {
                        $condiciones[($col + 1)][$kf] = $fila;
                    }
                }
                $condiciones['si'] = $leidas;
                $condiciones['no'] = $no_leidas;
                $condiciones['conturnos'] = $conturno;
                $condiciones['turnos_empleados'] = $turnos_empleados;
            }
        } else {
            $condiciones[0] = array(); //Empleado codigo
            $condiciones[1] = array(); //Área
            $condiciones[2] = array(); //Empleado nombre excel
            $condiciones[3] = array(); //Fecha E/S
            $condiciones[4] = array(); //Hora E/S
            $filas = $hoja['numRows'];
            $colum = $hoja['numCols'];
            for ($x = 1; $x <= $filas; $x++) {
                for ($y = 1; $y <= $colum; $y++) {
                    $prueba[$y-1][$x-1] = $hoja['cells'][$x][$y];
                }
            }

            /*
            $prueba_transpuesta = array();
            for ($x = 0; $x < count($prueba); $x++) {
                for ($y = 0; $y < count($prueba[$x]); $y++) {
                    $prueba_transpuesta[$y][$x] = $prueba[$x][$y];
                }
            }
            usort($prueba_transpuesta, function($a, $b) {
                $fechaHoraA = DateTime::createFromFormat('d/m/Y H:i:s', $a[3] . ' ' . $a[4]);
                $fechaHoraB = DateTime::createFromFormat('d/m/Y H:i:s', $b[3] . ' ' . $b[4]);
                if ($fechaHoraA == $fechaHoraB) {
                    return 0;
                }
                return ($fechaHoraA < $fechaHoraB) ? -1 : 1;
            });
            $prueba = array();
            for ($x = 0; $x < count($prueba_transpuesta); $x++) {
                for ($y = 0; $y < count($prueba_transpuesta[$x]); $y++) {
                    $prueba[$y][$x] = $prueba_transpuesta[$x][$y];
                }
            }
            */

            $leidas = $no_leidas = 0;
            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));/////temporal isdemu
            foreach ($prueba[0] as $k => $val) {
                if ($empresa == "isdemu") {
                    $id_emp = $this->db->select('emp_id')->where("CONVERT(SUBSTR(emp_codigo FROM 3), UNSIGNED) = $val")->from('emp_empleado')->get()->result_array();
                } else {
                    $id_emp = $this->db->select('emp_id')->where('emp_codigo', $val)->from('emp_empleado')->get()->result_array();
                }
                if (count($id_emp) > 0) {
                    $leidas++;
                    $resulters = $this->db->select()->where('emp_id', @$id_emp[0]['emp_id'])->from('emp_empleado')->get()->row_array();
                    $texto = '<span>' . $resulters['emp_nombre'] . ' ' . $resulters['emp_apellido'] . '</span>';
                    $this->db->join('txe_turnoxempleado', 'txe_id_emp = emp_id');
                    $resulters_tur = $this->db->select()->where('emp_id', @$id_emp[0]['emp_id'])->where('txe_estado', 1)->from('emp_empleado')->get()->row_array();
                    if ($empresa == "isdemu") {
                        $condiciones[0][$k] = $val;
                        $condiciones[1][$k] = $prueba[1][$k];
                        $condiciones[2][$k] = $texto;
                        $fechor = explode(" ", $prueba[3][$k]);
                        if (count($fechor) == 3) {
                            $hora_entrar = $fechor[1] . ' ' . $fechor[2];
                        } else {
                            $hora_entrar = $fechor[1];
                        }                    
                        $condiciones[3][$k] = $fechor[0];
                        $condiciones[4][$k] = formatear_fecha('H:i:s', $hora_entrar);
                    } else {                
                        $hora = $prueba[4][$k];
                        $datos_entra = explode(' ', $hora);
                        $hora_entrar = (count($datos_entra) > 1) ? $datos_entra[0] . ' ' . $datos_entra[1] : $datos_entra[0];
                        $hora_entra = formatear_fecha('H:i:s', $hora_entrar);
                        $condiciones[0][$k] = $val;
                        $condiciones[1][$k] = $prueba[1][$k];
                        $condiciones[2][$k] = $texto;
                        $condiciones[3][$k] = $prueba[3][$k];
                        $condiciones[4][$k] = $hora_entra;
                    }
                    if (count($resulters_tur) > 0) {
                        $texto .= '<span style="display:none">si</span>';//<input value="si" name="posee_turno[]" type="hidden" />';
                        $conturno[$id_emp[0]['emp_id'] .  '_' . $resulters_tur['txe_id_tur']][] = formatear_fecha('Ymd', $condiciones[3][$k]);

                        if (!isset($turnos_empleados[$val])) {
                            $turnos_empleados[$val] = $resulter_tur[0];
                        }                        

                    } else {
                        $texto .= '<span style="display:none">no</span>';//<input value="no" name="posee_turno[]" type="hidden" />';
                    }
                } else {
                    $no_leidas++;
                    $condiciones[0][$k] = "<span>Empleada/o no encontrado, ( " . $val . " )</span>";
                    $condiciones[1][$k] = "";
                    $condiciones[2][$k] = "";
                    $condiciones[3][$k] = "";
                    $condiciones[4][$k] = "";
                }
            }
            $condiciones['si'] = $leidas;
            $condiciones['no'] = $no_leidas;
            $condiciones['conturnos'] = $conturno;
            $condiciones['turnos_empleados'] = $turnos_empleados;

        }
        return $condiciones;
    }

    public function guardar_marcaciones_excel2() {
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $post = json_decode($_POST['jsonData'], true);
            $_POST = array_merge($_POST, $post);

            ini_set( 'memory_limit', '4048M' );        
            ini_set('max_execution_time', '9999');
            $formato_personalizado = ($this->input->post('formato_personalizado') > 0) ? $this->input->post('formato_personalizado') : null;
            $posee_turno = $this->input->post('posee_turno');
            $empleados = $this->input->post('empleado'); //CODIGO del empleado (Antes era el dui)
            $fecha_entra_ = $this->input->post('fecha_entra');
            $hora_entra_ = $this->input->post('hora_entra');
            $hora_sale_ = $this->input->post('hora_sale');

            $fecha_sale_ = $this->input->post('fecha_sale');

            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));/////temporal isdemu
            $metermarc = explode("##", $this->input->post('array_turn'));
            $j = 0; //contador de los registros procesados
            $rnp = 0; //REGISTROS NO PROCESADOS
            $filas_no_procesadas = array();
            for ($i = 0; $i < count($empleados); $i++) {
                //condicionar que todo toda la data existe y vaya integra -- CODIGO ELIMINADO EN EL IF: ' || $fecha_sale_[$i] != "" ' y ' || $hora_sale_[$i] != "" 
                if ($empleados[$i] != '' && ($fecha_entra_[$i] != "" ) && ($hora_entra_[$i] != "" )) {
                    if ($empresa == "isdemu") {
                        $id_empleado = $this->db->select('emp_id')->where("CONVERT(SUBSTR(emp_codigo FROM 3), UNSIGNED) = $empleados[$i]")->from('emp_empleado')->get()->result_array();
                    } else {
                        $id_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_codigo' => $empleados[$i]));
                    }
                    $id_emp = $id_empleado[0]['emp_id'];                    
                    //obtener los datos
                    $datos_entra = explode(' ', $hora_entra_[$i]);                    
                    $fecha_entra = trim($fecha_entra_[$i]);
                    if(isset($fecha_sale_[$i]) && $fecha_sale_[$i] != "") {
                        $fecha_sale = trim($fecha_sale_[$i]);
                        $fecha_sal = str_replace('/', '-', $fecha_sale);
                        $fecha_sal = date('Y-m-d H:i:s', strtotime($fecha_sal));
                    } else {
                        /////VALIDAR CASO DE USO
                        if(isset($fecha_entra_[$i]) && $fecha_entra_[$i] != "") {
                            $fecha_sale = trim($fecha_entra_[$i]);
                            $fecha_sal = str_replace('/', '-', $fecha_sale);
                            $fecha_sal = date('Y-m-d H:i:s', strtotime($fecha_sal));
                        } else {
                        $fecha_sal = null;
                        }
                    }
                    $hora_entra = (count($datos_entra) > 1) ? $datos_entra[0] . ' ' . $datos_entra[1] : $datos_entra[0];
                    $hora_entra = formatear_fecha('H:i:s', $hora_entra);
                    if (isset($hora_sale_[$i]) && $hora_sale_[$i] != "") {
                        if ($fecha_entra_[$i]==$fecha_sale_[$i]&&$hora_entra_[$i]==$hora_sale_[$i]) {
                            $hora_sale = null;
                        } else {
                            $datos_sale = explode(' ', $hora_sale_[$i]);
                            $hora_sale = (count($datos_sale) > 1) ? $datos_sale[0] . ' ' . $datos_sale[1] : $datos_sale[0];
                            $hora_sale = formatear_fecha('H:i:s', $hora_sale);
                        }
                    } else {
                        $hora_sale = null;
                    }                    
                    // $hora_entra = $this->gsatelite->convertir_hora_militar("$hora_entra");
                    // $hora_sale = $this->gsatelite->convertir_hora_militar("$hora_sale");
                    //estructurar los datos para el insert
                    $fecha_ent = str_replace('/', '-', $fecha_entra);
                    $datos_busqueda = array($id_emp, $fecha_ent, $hora_entra, $hora_sale);
                    $fecha_ent = date('Y-m-d', strtotime($fecha_ent));
                    //buscar el horario correspondiente al registro de la marcación
                    $id_dxt_encontrado = $this->buscar_horario_correccion($datos_busqueda);
                    // TODO: Validar si se debe de tomar en cuenta hora de entrada ya que si en el nuevo registro existe un cambio en la hora lo interpreta como registro nuevo
                    $existe_turno = array('mar_id_emp' => $id_emp,'mar_fecha_entrada' => $fecha_ent,'mar_hora_entrada' => $hora_entra);
                    if ($id_dxt_encontrado > 0) {
                        $existe_turno['mar_id_dxt'] = $id_dxt_encontrado;
                    }
                    $existe = $this->gsatelite->get_tabla('mar_marcacion', $existe_turno);
                    if (count($existe) > 0) {
                        if ($existe[0]['mar_procesada'] > 0) {
                            /*mar_procesada cambia a 1 al ingresar a planilla*/
                            $rnp++;
                        } else {
                            foreach ($existe as $key => $value) {
                                $correcciones = $this->gsatelite->get_tabla('cxm_correcionxmarcacion', array('cxm_id_mar' => $value['mar_id']));
                                if (count($correcciones) > 0) {
                                    foreach ($correcciones as $kc => $vlc) {
                                        $id = $vlc['cxm_id_cor'];
                                        $this->gsatelite->borrado_general('cxm_correcionxmarcacion', array('cxm_id' => $vlc['cxm_id']));
                                        $this->gsatelite->borrado_general('cor_correcion', array('cor_id' => $id));
                                    }
                                }
                                $this->gsatelite->borrado_general('mar_marcacion', array('mar_id' => $value['mar_id']));
                            }
                            $insert_mar = array(
                                'mar_id_emp' => $id_emp, 
                                'mar_fecha_entrada' => $fecha_ent, 
                                'mar_hora_entrada' => $hora_entra, 
                                'mar_fecha_salida' => $fecha_sal, 
                                'mar_hora_salida' => $hora_sale, 
                                'mar_procesada' => 0, 
                                'mar_revisado' => 0, 
                                'mar_estado' => 1, 
                                'mar_fecha_creacion' => date("Y-m-d H:i:s"),
                                'mar_usu_modificacion' => $this->tank_auth->get_user_id(), 
                                'mar_usu_creacion' => $this->tank_auth->get_user_id(), 
                                'mar_fecha_modificacion' => date("Y-m-d H:i:s")
                            );
                            if ($id_dxt_encontrado > 0) {
                                $insert_mar['mar_id_dxt'] = $id_dxt_encontrado;
                            }
                            $id_detalle = $this->gsatelite->ingresar('mar_marcacion', $insert_mar);
                            if ($id_detalle > 0) {
                                $j++;
                            } else {
                                $rnp++;
                            }
                        }                        
                    } else {
                        /*No hay registro en la tabla, es primera vez que se carga, se ingresara*/
                        $insert_mar = array(
                            'mar_id_emp' => $id_emp, 
                            'mar_fecha_entrada' => $fecha_ent, 
                            'mar_hora_entrada' => $hora_entra, 
                            'mar_fecha_salida' => $fecha_sal, 
                            'mar_hora_salida' => $hora_sale, 
                            'mar_procesada' => 0, 
                            'mar_revisado' => 0, 
                            'mar_estado' => 1, 
                            'mar_fecha_creacion' => date("Y-m-d H:i:s"),
                            'mar_usu_creacion' => $this->tank_auth->get_user_id(), 
                            'mar_usu_modificacion' => $this->tank_auth->get_user_id(), 
                            'mar_fecha_modificacion' => date("Y-m-d H:i:s") 
                        );
                        if ($id_dxt_encontrado > 0) {
                            $insert_mar['mar_id_dxt'] = $id_dxt_encontrado;
                        }
                        $id_detalle = $this->gsatelite->ingresar('mar_marcacion', $insert_mar);
                        if ($id_detalle > 0) {
                            $j++;
                        } else {
                            $rnp++;
                        }
                    }
                } else {
                    $rnp++;
                }
            }
            /*Al final redireccionar a consultar marcaciones y mostrar un mensaje de los resultados*/
            $no_procesadas = $rnp;//count($filas_no_procesadas);
            $detalle_no_procesadas = "";//implode('-', $filas_no_procesadas);
            $no_leidas = $this->input->post('no_leidas');
            $si_leidas = $this->input->post('leidas');
            if (count($metermarc)) {
                foreach ($metermarc as $k => $fila) {
                    $f = explode("_", $fila);
                    $fini = strtotime(formatear_fecha("Y-m-d", $f[2]));
                    $ffin = strtotime(formatear_fecha("Y-m-d", $f[3]));
                    for ($i = $fini; $i <= $ffin; $i += 86400) {
                        $d = date('Y-m-d', $i);
                        $n = formatear_fecha("N", $d);
                        $feriado = $this->gsatelite->count("dnl_dia_no_laboral", array("dnl_estado" => 1, "DATE('$d') BETWEEN DATE(dnl_fecha_inicio) AND DATE(dnl_fecha_fin)" => null));
                        $yamarco = $this->gsatelite->count("mar_marcacion", array("mar_id_emp"=> $f[0], "mar_fecha_entrada"=> $d));
                        $detalle = $this->gsatelite->get_tabla("dxt_detallexturno", array("dxt_estado" => 1, "dxt_id_tur"=> $f[1], "dxt_id_dia"=> $n));
                        if ($feriado == 0 && $yamarco == 0 && count($detalle) == 1) {
                            $insert = array('mar_id_emp' => $f[0], 'mar_id_dxt'=>$detalle[0]["dxt_id"],
                                'mar_fecha_entrada'=>$d,
                                'mar_fecha_salida'=>$d,
                                'mar_procesada'=>0, 
                                'mar_revisado'=>0, 
                                'mar_estado'=>1, 
                                'mar_fecha_creacion'=>date("Y-m-d H:i:s"),
                                'mar_usu_modificacion'=>$this->tank_auth->get_user_id(), 
                                'mar_usu_creacion'=>$this->tank_auth->get_user_id(), 
                                'mar_fecha_modificacion'=>date("Y-m-d H:i:s")
                            );
                            $this->gsatelite->ingresar('mar_marcacion', $insert);                            
                        }
                    }
                }
            }
            $datos = array('procesadas' => $j, 'no_procesadas' => $no_procesadas, 'f_no_procesadas' => $detalle_no_procesadas, 'excel_no' => $no_leidas, 'excel_ok' => $si_leidas);
            $this->informe_marcaciones($datos);
        }
    }

    // Melbin Cruz
    public function get_marcaciones() {
        satelite_validar();
        ini_set( 'memory_limit', '4048M' );        
        ini_set('max_execution_time', '9999');        
        if ($_POST) {
            $desde = date('Y-m-d', strtotime($this->input->post('desde')));
            $hasta = date('Y-m-d', strtotime($this->input->post('hasta')));
            $area = $this->input->post('area');
            $empl = $this->input->post('empleado');              
            $data['es_reporte'] = 'si';
            $array_where = array(
                'mar_fecha_entrada >=' => $desde,
                'mar_fecha_entrada <=' => $hasta,
                'mar_procesada'        => 0, 
                'mar_revisado'         => 1,
                'tiu_aplica_marcacion' => 1
            );

            if($empl != ""){
                $array_where['mar_id_emp'] = $empl;
            }
            if ($area != null) {
                $array_where['are_id'] = $area;
            }               
           
            $marcaciones = $this->marcacion_model->get_reporte_marcacion($array_where); // Este es el poderoso
            $dias_trabajados_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
            $horas_trabajadas_dia = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
            $diurno_in = $this->gsatelite->get_campo('the_tipo_hora_extra', 'the_inicio', array('the_id' => 1));
            $diurno_out = $this->gsatelite->get_campo('the_tipo_hora_extra', 'the_fin', array('the_id' => 1));
            $hora_factor_diurno = $this->gsatelite->get_campo('the_tipo_hora_extra', 'the_factor', array('the_id' => 1));
            $hora_factor_nocturno = $this->gsatelite->get_campo('the_tipo_hora_extra', 'the_factor', array('the_id' => 2));
            // Horas no trabajadas
            $diurno_in_descuento = $this->gsatelite->get_campo('thf_tipo_hora_faltante', 'thf_inicio', array('thf_id' => 1));
            $diurno_out_descuento = $this->gsatelite->get_campo('thf_tipo_hora_faltante', 'thf_fin', array('thf_id' => 1));
            $hora_factor_diurno_desc = $this->gsatelite->get_campo('thf_tipo_hora_faltante', 'thf_factor', array('thf_id' => 1));
            $hora_factor_nocturno_desc = $this->gsatelite->get_campo('thf_tipo_hora_faltante', 'thf_factor', array('thf_id' => 2));
            $registro_tipo_hora = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id', 1); // horas no trabajadas

            $tipo_hora = array();
            $valor_hora = array();
            $hora_extra = array();
            $retraso_salida = array();
            $calculo_array = array();
            $tipo_descuento = array();
            $descuento = array();

            $tipo_hora_descuento = 1;  // TODO: Buscar como cambiar quemados

            // Variable para almacenar las marcaciones agrupadas por dia
            $marcaciones_mostrar_grid = array();

            // Agrupar marcaciones por empleado y dia
            $marcaciones_agrupadas = $this->agruparMarcacionesEmpleadoFecha($marcaciones);
            $countMarcacion = 0;

            foreach ($marcaciones_agrupadas as $key => &$marcaciones_dia) {
                // ordenar por hora de entrada
                $this->ordenarPorHoraEntrada($marcaciones_dia);

                $tiempo_pendiente = 0;

                $primer_marcacion = min($marcaciones_dia); 
                $ultima_marcacion = max($marcaciones_dia);

                // Si tiene mas de una marcacion al dia y la ultima marcacion es null
                if (count($marcaciones_dia) > 1 && ($ultima_marcacion['mar_hora_salida'] == null || $ultima_marcacion['mar_hora_salida'] == '' )) {
                    $ultima_marcacion['mar_hora_salida'] = $ultima_marcacion['mar_hora_entrada'];
                }

                // Validar o asignar turno
                $this->validarTurnoAsignado($primer_marcacion);

                // Calcular tiempo pendiente por faltas de marcación (sin hora entrada/salida)
                $tiempo_pendiente += $this->calcularTiempoMarcacionesFaltantes($primer_marcacion, $ultima_marcacion, $key);

                // Calcular entradas tarde y salida temprana
                $tiempo_pendiente += $this->calcularRetrasosYSalidasTempranas($primer_marcacion, $ultima_marcacion);

                //Validar tiempo fuera (marcaciones de por medio)
                $tiempo_pendiente += $this->calcularTiempoFueraConPermisos($marcaciones_dia, $key);


                // Se asignan valores a la primera marcacion
                $marcaciones_dia[0]['tiempo_pendiente'] = round($tiempo_pendiente);
                $marcaciones_dia[0]['horas_extras'] = 0;
                $marcaciones_dia[0]['la_inn'] = isset($primer_marcacion['la_inn']) ? $primer_marcacion['la_inn'] : 0;
                $marcaciones_dia[0]['la_out'] = isset($primer_marcacion['la_out']) ? $primer_marcacion['la_out'] : 0;
                $marcaciones_dia[0]['mar_id_dxt'] = $primer_marcacion['mar_id_dxt'];
                $marcaciones_dia[0]['tur_nombre'] = $primer_marcacion['tur_nombre'];

                // Para mostrar hora salida cuando tiene multiples marcaciones se asignar la salida de ultima marcacion
                // a la primera marcacion que es la que mostramos
                $marcaciones_dia[0]['mar_hora_salida'] = $ultima_marcacion['mar_hora_salida'];
                $marcaciones_mostrar_grid[] = $marcaciones_dia[0];
                // Fin procesamiento marcacion


                // Iniciar el calculo de descuentos y horas extras
                // Calcular el tipo de hora extra
                if (strtotime($primer_marcacion['mar_hora_entrada']) < strtotime($diurno_in)) {
                    $tipo_hora[] = 2;
                    $valor_hora[] = $hora_factor_nocturno;
                } else {
                    if (strtotime($ultima_marcacion['mar_hora_salida']) < strtotime($diurno_out) || strtotime($primer_marcacion['mar_hora_entrada']) > strtotime($diurno_in)) {
                        $tipo_hora[] = 1;
                        $valor_hora[] = $hora_factor_diurno;
                    } else {
                        $tipo_hora[] = 2;
                        $valor_hora[] = $hora_factor_nocturno;
                    }
                } // Fin tipo de hora extra   

                $retraso_sal = $tiempo_pendiente;
                $valor_descuento = 0;

                if ($retraso_sal > 0) {
                    if (strtotime($primer_marcacion['mar_hora_entrada']) >= strtotime($diurno_out_descuento)) { // Horas nocturnas para descuento
                        $valor_descuento = $hora_factor_nocturno_desc;
                        $tipo_hora_descuento = 2; // TODO: Buscar como cambiar quemados
                    } else {
                        $valor_descuento = $hora_factor_diurno_desc;
                    }
                }


                $horas_extras_asignadas = $this->calcularHorasExtras($primer_marcacion, $ultima_marcacion);                

                $hora_extra[] = $horas_extras_asignadas;
                $retraso_salida[] = round($tiempo_pendiente);

                // Calcular el pago por hora extra
                $factor = $valor_hora[$countMarcacion];
                $nhoras = $horas_extras_asignadas;
                $salario = $primer_marcacion['emp_salario'];
                $calcula = (($salario / ($dias_trabajados_mes * $horas_trabajadas_dia)) * $nhoras);
                $n_calculo = ($calcula * $factor);
                $calculo_array[] = number_format($n_calculo, 2);

                //Calcular descuento por salida temprano o llegada tardia
                $factor = $valor_descuento; //$registro_tipo_hora->thf_factor;
                $nhoras = round($retraso_sal) / 60;
                $salario = $primer_marcacion['emp_salario'];
                $calcula = (($salario / ($dias_trabajados_mes * $horas_trabajadas_dia)) * $nhoras);
                $n_calculo = ($calcula * $factor);
                $descuento[] = number_format($n_calculo, 2);
                $tipo_descuento[] = $tipo_hora_descuento; //$registro_tipo_hora->thf_id_tdc;   
                $countMarcacion++;                  
            }

            $data['consulta'] = $marcaciones_mostrar_grid;

            // Se envian a la vista los id de marcaciones no mostradas (por ser agrupadas) para que queden procesados mar_procesada = 1 
            $ids_marcaciones_originales = array_column($marcaciones, 'mar_id');
            $ids_marcaciones_mostradas = array_column($marcaciones_mostrar_grid, 'mar_id');
            $ids_marcaciones_no_mostradas = array_diff($ids_marcaciones_originales, $ids_marcaciones_mostradas);
            $data['id_marcaciones_agrupadas'] = array_values($ids_marcaciones_no_mostradas);

            // Llenar arreglos a procesar en la vista
            $data['horas_extras'] = $hora_extra;
            $data['retraso_salida'] = $retraso_salida;
            $data['tipo_hora'] = $tipo_hora;
            $data['valor_hora'] = $valor_hora;
            $data['calculo'] = $calculo_array;
            $data['descuento'] = $descuento;
            $data['tipo_descuento'] = $tipo_descuento;
            $html = $this->load->view('marcacion/consultas/get_marcaciones2', $data, true); // Devuelve la tabla de resultados
            echo json_encode(array('resultado' => $html));
        } else {
            die("<h1>Error!!!!!!!!!</h1>");
        }
    }

    //@author René Castaneda
    public function agregar_horas_extras($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // var_dump($_POST);die();
                // Unir jsonData con el post
                $post = json_decode($_POST['jsonData'], true);
                $_POST = array_merge($_POST, $post);  

                // Actualizar marcaciones que fueron agrupadas
                $id_marcaciones_agrupadas = $this->input->post('id_marcaciones_agrupadas');
                if (!empty($id_marcaciones_agrupadas)) {
                    foreach ($id_marcaciones_agrupadas as $indice => $valor) {
                        $arreglo = array( 'mar_procesada' => 1 );
                        //Actualizar marcaciones.
                        $this->gsatelite->actualizar_array('mar_marcacion', $arreglo, array('mar_id' => $valor));
                    }
                }

                $marcaciones = $this->input->post('marcaciones');
                if (!empty($marcaciones)) {
                    foreach ($marcaciones as $indice => $valor) {
                        $arreglo = array( 'mar_procesada' => 1 );
                        //Actualizar marcaciones.
                        $this->gsatelite->actualizar_array('mar_marcacion', $arreglo, array('mar_id' => $valor));
                    }
                }
                $registro_periodo = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('planilla'));
                //$registro_tipo_hora=$this->gsatelite->get_registro('the_tipo_hora_extra','the_id',$this->input->post('tipo_hora_extra'));
                // y$registro_tipo_hora=$this->gsatelite->get_registro('thf_tipo_hora_faltante','thf_id',1); // thf_factor
                // Codigo para insertar las horas extras
                $empleados = $this->input->post('emp_codigo');
                $horas_extras = $this->input->post('horas_extras');
                $tipo_hora_extra = $this->input->post('tipo_hora');
                // $valor_hora  = $this->input->post('valor_hora');
                $calculo_monto = $this->input->post('calculo');
                //die(print_r($empleados));
                foreach ($empleados as $key => $value) {
                    // Detalle de las horas extras  
                    $array_detalle = array(
                        'hxe_id_pla' => $this->input->post('planilla'),
                        'hxe_id_the' => $tipo_hora_extra[$key], 
                        'hxe_id_emp' => $value,
                        'hxe_num_hora' => $horas_extras[$key],
                        'hxe_observacion' => 'Registro procesado desde Marcación',
                        'hxe_estado' => 1,
                        'hxe_fecha_crea' => date("Y-m-d H:i:s"),
                        'hxe_usu_crea' => $this->tank_auth->get_user_id(),
                        'hxe_fecha_mod' => date("Y-m-d H:i:s"),
                        'hxe_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_detalle_horas = $this->gsatelite->ingresar('hxe_hora_extraxempleado', $array_detalle);

                    //ahora ingresar el ingreso en la tabla ingreso
                    $ingreso = array(
                        'inn_id_tig' => $tipo_hora_extra[$key],
                        'inn_id_emp' => $value,
                        'inn_id_hxe' => $id_detalle_horas,
                        'inn_id_tpl' => $this->input->post('tipo_planilla'),
                        'inn_motivo' => 'Registro procesado desde Marcación',
                        'inn_observacion' => 'Registro procesado desde Marcación',
                        'inn_permanente' => 0,
                        'inn_valor' => $calculo_monto[$key],
                        'inn_fecha_desde' => date("Y-m-d", strtotime($registro_periodo->pla_fecha_inicio)),
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => 1,
                        'inn_fecha_crea' => date("Y-m-d H:i:s"),
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_crea' => $this->tank_auth->get_user_id(),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_ingreso = $this->gsatelite->ingresar('inn_ingreso', $ingreso);
                }// End foreach Empleados
                // Insertar los retrasos
                $empleado2 = $this->input->post('emp_id2');
                $retrasos = $this->input->post('retrasos');
                $descuentos = $this->input->post('descuento');
                $tipo_descuento = $this->input->post('tipo_descuento');

                foreach ($empleado2 as $key => $value) {
                    // Detalle de las horas extras  
                    // $array_detalle = array(
                    //     'hxe_id_pla' => $this->input->post('planilla'),
                    //     'hxe_id_thf' => $tipo_descuento[$key],
                    //     'hxe_id_emp' => $value,
                    //     'hxe_num_hora' => ($retrasos[$key]/60),
                    //     'hxe_observacion' => 'Descuento procesado desde Marcación', 
                    //     'hxe_estado' => 1, 
                    //     'hxe_fecha_crea' => date("Y-m-d H:i:s"),
                    //     'hxe_fecha_mod' => date("Y-m-d H:i:s"),
                    //     'hxe_usu_crea' => $this->tank_auth->get_user_id(),
                    //     'hxe_usu_mod' => $this->tank_auth->get_user_id()
                    // );
                    // $id_detalle_horas = $this->gsatelite->ingresar('hxe_hora_extraxempleado', $array_detalle);
                    //ahora hacer el ingreso en la tabla ingreso    
                    $registro_tipo_hora = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id', $tipo_descuento[$key]); // thf_factor

                    $descuento_detalle = array(
                        'dss_id_emp' => $value,
                        'dss_id_tpl' => $this->input->post('tipo_planilla'),
                        'dss_id_tdc' => $registro_tipo_hora->thf_id_tdc,
                        // 'dss_id_hxe' => $id_detalle_horas,
                        'dss_motivo' => 'Descuento procesado desde Marcación',
                        'dss_observacion' => 'Descuento procesado desde Marcación',
                        'dss_permanente' => 0,
                        'dss_valor' => $descuentos[$key],
                        'dss_fecha' => date("Y-m-d H:i:s"),
                        'dss_fecha_desde' => date("Y-m-d", strtotime($registro_periodo->pla_fecha_inicio)),
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => 1,
                        'dss_fecha_mod' => date("Y-m-d H:i:s"),
                        'dss_fecha_crea' => date("Y-m-d H:i:s"),
                        'dss_usu_crea' => $this->tank_auth->get_user_id(),
                        'dss_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    // var_dump(  $descuento_detalle);die();
                    $id_dess = $this->gsatelite->ingresar('dss_descuento', $descuento_detalle);
                }
                $id_emp = $this->input->post('emp_id'); //acciones_personal/principal/gestion_horas_extras/$id_emp
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "marcacion/procesos/procesar_marcacion");
            } else {
                $this->gsatelite->show_dialog("Proceso no se ha realizado ", "marcacion/procesos/procesar_marcacion", "error");
            }
        }
    }
    
    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function detalle_turno($id_turno=null) {
        $data['turno'] = $this->gsatelite->get_tabla('tur_turno', array('tur_id' => $id_turno));
    $this->load->view('marcacion/procesos/detalle_turno.php',$data);
    }

    /**
     * @author Marlon Olmedo
     * @return gestión de asignación de turnos
     */
    public function grid_asignacion_turno() {
        satelite_validar();
        if ($_POST) {
            $estado = ($this->input->post('slcEstado') != '') ? $this->input->post('slcEstado') : null;
            $where = null;
            if ($estado != null) {
                $where["txe_estado"] = $estado;
            }
            // $this->db->group_by("emp_id");
            $this->db->join('tur_turno','tur_id=txe_id_tur');
            $this->db->join('tiu_tipo_turno','tiu_id=txe_id_tiu','left');
            $this->db->join('emp_empleado','emp_id=txe_id_emp');
            $data['detalles_turno'] = $this->gsatelite->get_tabla('txe_turnoxempleado',$where);
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $html = $this->load->view('marcacion/procesos/tabla_grid_asignacion_turno',$data,true);
            echo json_encode(array("resultado" => $html));
            die();
        } else {
            $datos['permisos'] = $this->gsatelite->get_permisos_opcion();
            $datos['titulo_personal'] = "Gestión de turnos";
            $this->_cargarvista($datos, null);
        }
    }

    /**
     * @author Marlon Olmedo
     * @return validar disposicion de turno segun fecha
     */
    public function validar_turno_fecha($edit_id = 0) {
        satelite_validar();
        $fecha1 = ($this->input->post('fecha1') != '') ? $this->input->post('fecha1') : null;
        $fecha2 = ($this->input->post('fecha2') != '') ? $this->input->post('fecha2') : null;
        $empleado = ($this->input->post('empleado') != '')? $this->input->post('empleado') : null;
        $edit_id = ($this->input->post('editar') > 0) ? $this->input->post('editar') : 0;
        $where = null;
        $where["txe_id_emp"] = $empleado;
        $where["txe_estado"] = 1;
        if ($fecha1 != null) {
            $fecha1_ = formatear_fecha('Y-m-d', $fecha1);
            if ($fecha2 != null) {
                $fecha2_ = formatear_fecha('Y-m-d', $fecha2);
                $where["(txe_indefinido = 1 OR ('$fecha1_' BETWEEN DATE(txe_desde) AND DATE(txe_hasta)) OR ('$fecha2_' BETWEEN DATE(txe_desde) AND DATE(txe_hasta)))"] = null;
            } else {
                $where["(txe_indefinido = 1 OR ('$fecha1_' BETWEEN DATE(txe_desde) AND DATE(txe_hasta)))"] = null;
            }
        } else {
            if ($fecha2 != null) {
                $fecha2_ = formatear_fecha('Y-m-d', $fecha2);
                $where["'$fecha2_' BETWEEN DATE(txe_desde) AND DATE(txe_hasta)"] = null;
            }
        }
        if ($edit_id > 0) {
            $where["txe_id != "] = $edit_id;
        }
        $this->db->where($where,null,false);
        $turnos = $this->gsatelite->get_tabla('txe_turnoxempleado');
        $indefi = array_filter(array_column($turnos, 'txe_indefinido'));
        echo json_encode(array("id_turno" => count($turnos), 'indefinido' => count($indefi)));
        die();
    }

    function reiniciarIndicesDesdeUno($array)
    {
        $nuevo = array();
        $i = 1;

        foreach ($array as $item) {
            $nuevo[$i] = $item;
            $i++;
        }

        return $nuevo;
    }  

    function filtrarData($datos)
    {
        $resultado = array();
        $agrupadoPorDia = array();

        $minutosDiferencia = $this->gsatelite->get_parametro('SYS_DIFERENCIA_ENTRE_MARCACIONES_MIN', 1);
        $segundosDiferencia = $minutosDiferencia * 60; // convertir a segundos        

        foreach ($datos['cells'] as $index => $row) {
            // Asegurar que existe la columna 3 (código empleado) y 4 (fecha/hora)
            if (!isset($row[3]) || !isset($row[4])) {
                continue;
            }

            $codigoEmpleado = $row[3];
            $fechaHoraStr = $row[4];

            $fechaHora = DateTime::createFromFormat('j/n/Y H:i:s', $fechaHoraStr);

            if (!$fechaHora) {
                continue; // Ignorar fechas inválidas
            }

            // Agrupar por día y por empleado
            $clave = $codigoEmpleado . '-' . $fechaHora->format('Y-m-d');

            if (!isset($agrupadoPorDia[$clave])) {
                $agrupadoPorDia[$clave] = array();
            }

            $agrupadoPorDia[$clave][] = array(
                'fechaHora' => $fechaHora,
                'row' => $row,
                'index' => $index,
            );
        }

        // Recorrer grupos (empleado/día)
        foreach ($agrupadoPorDia as $grupo => $entradas) {

            // Ordenar por fecha/hora ascendente (sin usar <=>)
            usort($entradas, function($a, $b) {
                $t1 = $a['fechaHora']->getTimestamp();
                $t2 = $b['fechaHora']->getTimestamp();
                if ($t1 == $t2) return 0;
                return ($t1 < $t2) ? -1 : 1;
            });

            // Filtrar registros con diferencia ≤ 1 minuto
            $filtradas = array();
            $ultimaFecha = null;
            foreach ($entradas as $item) {
                $fechaActual = $item['fechaHora'];

                if ($ultimaFecha === null) {
                    $filtradas[] = $item;
                    $ultimaFecha = $fechaActual;
                    continue;
                }

                $diffSeg = abs($fechaActual->getTimestamp() - $ultimaFecha->getTimestamp());
                // $diffMin = $diffSeg / 60;
                $diffMin = $diffSeg;

                if ($diffMin > $segundosDiferencia) { // conservar solo si supera 1 minuto
                    $filtradas[] = $item;
                    $ultimaFecha = $fechaActual;
                }
            }

            // Agregar las marcaciones filtradas al resultado
            foreach ($filtradas as $marcacion) {
                $resultado[$marcacion['index']] = $marcacion['row'];
            }
        }

        // Ordenar por índice original para mantener el orden original
        ksort($resultado);

        // Devolver array cells y total de filas 
        return array(
            'cells' => $this->reiniciarIndicesDesdeUno($resultado),
            'numRows' => count($resultado),
        );
    } 

    function procesarMarcacionesMultiples($marcaciones)
    {
        // Agrupar marcaciones por empleado y fecha
        $marcaciones_agrupadas = $this->agruparMarcacionesEmpleadoFecha($marcaciones);


        foreach ($marcaciones_agrupadas as $key => &$marcaciones_dia) {
            // ordenar por hora de entrada
            $this->ordenarPorHoraEntrada($marcaciones_dia);

            $tiempo_pendiente = 0;
            // Obtener minutos tarde o entrada temprano
            $primer_marcacion = min($marcaciones_dia); 
            $ultima_marcacion = max($marcaciones_dia);

            // Si tiene mas de una marcacion al dia y la hora de salida de ultima marcacion es null
            if (count($marcaciones_dia) > 1 && ($ultima_marcacion['mar_hora_salida'] == null || $ultima_marcacion['mar_hora_salida'] == '' )) {
                $ultima_marcacion['mar_hora_salida'] = $ultima_marcacion['mar_hora_entrada'];
            }

            // Validar o asignar turno
            $this->validarTurnoAsignado($primer_marcacion);

            // Calcular tiempo pendiente por faltas de marcación (sin hora entrada/salida)
            $tiempo_pendiente += $this->calcularTiempoMarcacionesFaltantes($primer_marcacion, $ultima_marcacion, $key);


            // Calcular entradas tarde y salida temprana
            $tiempo_pendiente += $this->calcularRetrasosYSalidasTempranas($primer_marcacion, $ultima_marcacion);

            //Validar tiempo fuera (marcaciones de por medio)
            $tiempo_pendiente += $this->calcularTiempoFueraConPermisos($marcaciones_dia, $key);

            $horas_extras = $this->calcularHorasExtras($primer_marcacion, $ultima_marcacion);
            
            if (is_null($primer_marcacion['mar_id_dxt'])) {
                $tiempo_pendiente = 0;
                $primer_marcacion['la_inn'] = 0;
                $primer_marcacion['la_out'] = 0;
                $horas_extras = 0;
            }

            // Se asignan valores a la primera marcacion
            $marcaciones_dia[0]['tiempo_pendiente'] = round($tiempo_pendiente);
            $marcaciones_dia[0]['horas_extras'] = $horas_extras;
            $marcaciones_dia[0]['la_inn'] = isset($primer_marcacion['la_inn']) ? $primer_marcacion['la_inn'] : 0;
            $marcaciones_dia[0]['la_out'] = isset($primer_marcacion['la_out']) ? $primer_marcacion['la_out'] : 0;
            $marcaciones_dia[0]['mar_id_dxt'] = $primer_marcacion['mar_id_dxt'];
            $marcaciones_dia[0]['tur_nombre'] = $primer_marcacion['tur_nombre'];

        }

        $marcaciones_originales = array_merge(...array_values($marcaciones_agrupadas));
        return $marcaciones_originales;
    }

    private function agruparMarcacionesEmpleadoFecha($marcaciones)
    {
        $marcaciones_agrupadas = [];
        foreach ($marcaciones as $m) {
            $emp = $m['mar_id_emp'];
            $fecha = $m['mar_fecha_entrada'];
            $key = $emp . '_' . $fecha;
            if (!isset($marcaciones_agrupadas[$key])) {
                $marcaciones_agrupadas[$key] = array();
            }
            $marcaciones_agrupadas[$key][] = $m;
        }

        return $marcaciones_agrupadas;
    }

    private function ordenarPorHoraEntrada(&$marcaciones_dia)
    {
        usort($marcaciones_dia, function ($a, $b) {
            return strcmp($a['mar_hora_entrada'], $b['mar_hora_entrada']);
        });
    }

    private function validarTurnoAsignado(&$marcacion)
    {
        if (!empty($marcacion['mar_id_dxt'])) {
            $this->db->join('dxt_detallexturno', 'tur_id = dxt_id_tur');
            $turn = $this->gsatelite->get_campo('tur_turno', 'tur_id', array('dxt_estado' => 1, 'dxt_id' => $marcacion['mar_id_dxt']));
            $estado_turno = $this->gsatelite->get_campo('txe_turnoxempleado', 'txe_estado', array('txe_id_tur' => $turn, 'txe_id_emp' => $marcacion['mar_id_emp']));
            if ($estado_turno < 1) {
                $marcacion['mar_id_dxt'] = "";
                $marcacion['tur_nombre'] = "";
                $marcacion['tur_id'] = "";
            }
        } else {
            $datos_busqueda = array($marcacion['mar_id_emp'], $marcacion['mar_fecha_entrada'], $marcacion['mar_hora_entrada'], $marcacion['mar_hora_salida']);
            $id_dxt = $this->buscar_horario_correccion($datos_busqueda);
            if ($id_dxt > 0) {
                $marcacion['mar_id_dxt'] = $id_dxt;
                $this->db->join('deh_detalle_horario', 'deh_id = dxt_id_deh');
                $this->db->join('tur_turno', 'tur_id = dxt_id_tur');
                $nu_turno = $this->gsatelite->get_tabla('dxt_detallexturno', array('tur_estado' => 1, 'dxt_estado' => 1, 'dxt_id' => $id_dxt));
                $marcacion['tur_id'] = $nu_turno[0]['tur_id'];
                $marcacion['tur_nombre'] = $nu_turno[0]['tur_nombre'];
                $marcacion['deh_hora_entrada'] = $nu_turno[0]['deh_hora_entrada'];
                $marcacion['deh_hora_salida'] = $nu_turno[0]['deh_hora_salida'];
            }
        }
    } 

    private function calcularTiempoMarcacionesFaltantes(&$primer_marcacion, $ultima_marcacion, $key)
    {
        $tiempo_pendiente = 0;
        $retraso_ent = 0;
        $retraso_sal = 0;

        // Obtener todos los permisos del día
        $permiso_dia_completo = $this->marcacion_model->verificar_permiso_dia_completo(
            $primer_marcacion['mar_id_emp'],
            $primer_marcacion['mar_fecha_entrada']
        );

        // Si tiene permiso dia completo retorna 0
        if ($permiso_dia_completo) return 0; 


        if (is_null($primer_marcacion['mar_hora_entrada']) || is_null($ultima_marcacion['mar_hora_salida'])) {
            $hora_in_asignada = $this->marcacion_model->hora_a_minutos($primer_marcacion['deh_hora_entrada']);
            $hora_out_asignada = $this->marcacion_model->hora_a_minutos($primer_marcacion['deh_hora_salida']);

            // EMPLEADO NO MARCO PERO HAY UN PERMISO QUE LO AMPARA
            $permiso_inicia = ($primer_marcacion['inicia_permiso']) ? $this->marcacion_model->hora_a_minutos($primer_marcacion['inicia_permiso']) : 0;
            $permiso_termina = ($primer_marcacion['termina_permiso']) ? $this->marcacion_model->hora_a_minutos($primer_marcacion['termina_permiso']) : 0;
            $sin_permiso_dia_completo = ($primer_marcacion['id_permiso'] != "" && $permiso_inicia == 0 && $permiso_termina == 0) ? false : true;
            // var_dump($sin_permiso_dia_completo);
            if (is_null($primer_marcacion['mar_hora_entrada'])) {

                $catconfinn = $this->gsatelite->get_tabla("cat_configuracion_accion_turno",array('cat_id_tur'=>$primer_marcacion['tur_id'],'cat_estado'=>1,'cat_tipo'=>1));
                if (count($catconfinn) > 0 && $catconfinn[0]['cat_minutos'] > 0) {
                    // Cubre el permiso
                    if ($permiso_termina > 0 && $permiso_termina > $hora_in_asignada && $permiso_termina <= $hora_out_asignada && $permiso_inicia >= $hora_in_asignada) {
                        $tiempo_pendiente += 0;
                    } else {
                        if ($sin_permiso_dia_completo) {
                            $tiempo_pendiente += $catconfinn[0]['cat_minutos'];
                            $retraso_ent = $catconfinn[0]['cat_minutos'];
                        } else {
                            $tiempo_pendiente += 0;
                        }
                    }
                } else {
                    $tiempo_pendiente += 0;
                }
            }
            if (is_null($ultima_marcacion['mar_hora_salida'])) {

                $catconfinn = $this->gsatelite->get_tabla("cat_configuracion_accion_turno",array('cat_id_tur'=>$primer_marcacion['tur_id'],'cat_estado'=>1,'cat_tipo'=>2));
                if (count($catconfinn) > 0 && $catconfinn[0]['cat_minutos'] > 0) {
                    if ($permiso_inicia > 0 && $permiso_inicia >= $hora_in_asignada && $permiso_inicia < $hora_out_asignada && $permiso_termina >= $hora_out_asignada) {
                        $tiempo_pendiente += 0;
                    } else {                                
                        if ($sin_permiso_dia_completo) {
                            $tiempo_pendiente += $catconfinn[0]['cat_minutos'];
                            $retraso_sal = $catconfinn[0]['cat_minutos'];
                        } else {
                            $tiempo_pendiente += 0;
                        }
                    }
                } else {
                    $tiempo_pendiente += 0;
                }
            }
        }
        $primer_marcacion['la_inn'] = ceil($retraso_ent);
        $primer_marcacion['la_out'] = ceil($retraso_sal);            

        return $tiempo_pendiente;
    }

    private function calcularRetrasosYSalidasTempranas(&$primer_marcacion, $ultima_marcacion)
    {
        if (is_null($primer_marcacion['mar_hora_entrada']) || is_null($ultima_marcacion['mar_hora_salida'])) return 0;
        $tiempo_pendiente = 0;

        $tiempo_gracia = $this->marcacion_model->get_tiempo_gratis(array('tur_id'=>$primer_marcacion['tur_id'], 'cot_estado' => 1));
        $aply_ret_inn = $aply_ret_out = false;
        $hora_in_gracia = $hora_out_gracia = 0; 

        foreach ($tiempo_gracia as $key2 => $val2) {
            if($val2['cot_tipo']==1){
                $aply_ret_inn = true;
                $minxtra = $val2['cot_minutos'] - $val2['cot_inicio_calculo'];
                $minxtin = ($minxtra < 0) ? 0 : $minxtra;
                $hora_in_gracia = $val2['cot_minutos'];
            }
            if($val2['cot_tipo']==2){
                $aply_ret_out = true;
                $minxtra = $val2['cot_minutos'] - $val2['cot_inicio_calculo'];
                $minxtou = ($minxtra < 0) ? 0 : $minxtra;
                $hora_out_gracia = $val2['cot_minutos'];
            } 
        }

        $retraso_ent = $retraso_sal = 0;
        $hora_entrada = $this->marcacion_model->hora_a_minutos($primer_marcacion['mar_hora_entrada']);
        $hora_salida = $this->marcacion_model->hora_a_minutos($ultima_marcacion['mar_hora_salida']);
        $hora_in_asignada = $this->marcacion_model->hora_a_minutos($primer_marcacion['deh_hora_entrada']);  
        $hora_out_asignada = $this->marcacion_model->hora_a_minutos($primer_marcacion['deh_hora_salida']); 
        $hora_in =  $hora_in_asignada;
        $hora_out = $hora_out_asignada;

        // Verificar si tiene permiso todo el dia

        // Obtener todos los permisos del día
        $permiso_dia_completo = $this->marcacion_model->verificar_permiso_dia_completo(
            $primer_marcacion['mar_id_emp'],
            $primer_marcacion['mar_fecha_entrada']
        );

        // Si tiene permiso dia completo retorna 0
        if ($permiso_dia_completo) return 0;

        $permisos_dia = $this->marcacion_model->obtener_permisos_dia(
            $primer_marcacion['mar_id_emp'],
            $primer_marcacion['mar_fecha_entrada']
        );

        // Retraso entrada
        $retraso_ent = max(0, $hora_entrada - $hora_in);
        // Aplicar tiempo de gracia
        if ($retraso_ent <= $hora_in_gracia) {
            $retraso_ent = 0;
        }

        foreach ($permisos_dia as $permiso) {
            $inicio_interseccion = max($hora_in, $permiso['hxe_hora_inicio']);
            $fin_interseccion = min($hora_entrada, $permiso['hxe_hora_fin']);
            if ($fin_interseccion > $inicio_interseccion) {
                $retraso_ent -= ($fin_interseccion - $inicio_interseccion);
            }
        }
        $retraso_ent = max(0, $retraso_ent);

        // Rretraso salida
        $retraso_sal = max(0, $hora_out - $hora_salida);
        if ($retraso_sal <= $hora_out_gracia) {
            $retraso_sal = 0;
        }

        foreach ($permisos_dia as $permiso) {
            $inicio_interseccion = max($hora_salida, $permiso['hxe_hora_inicio']);
            $fin_interseccion = min($hora_out, $permiso['hxe_hora_fin']);
            if ($fin_interseccion > $inicio_interseccion) {
                $retraso_sal -= ($fin_interseccion - $inicio_interseccion);
            }
        }
        $retraso_sal = max(0, $retraso_sal);


        $tiempo_pendiente = $retraso_ent + $retraso_sal;
        $primer_marcacion['la_inn'] = ceil($retraso_ent);
        $primer_marcacion['la_out'] = ceil($retraso_sal);

        return ceil($tiempo_pendiente);
    }    

    private function calcularTiempoFueraConPermisos($marcaciones_dia, $key)
    {
        $tiempo_pendiente = 0;

        for ($i = 0; $i < count($marcaciones_dia) - 1; $i++) {
            $salida = $marcaciones_dia[$i]['mar_hora_salida'];
            $entrada_siguiente = $marcaciones_dia[$i + 1]['mar_hora_entrada']; 

            if (!empty($salida) && !empty($entrada_siguiente)) {
                $min_salida = $this->marcacion_model->hora_a_minutos($salida);
                $min_entrada_siguiente = $this->marcacion_model->hora_a_minutos($entrada_siguiente);
          
                $diferencia = $min_entrada_siguiente - $min_salida;

                if ($diferencia > 0) {

                    // Obtener los permisos x dia
                    // Obtener todos los permisos del día
                    $permiso_dia_completo = $this->marcacion_model->verificar_permiso_dia_completo(
                        $marcaciones_dia[$i]['mar_id_emp'],
                        $marcaciones_dia[$i]['mar_fecha_entrada']
                    );

                    // Si tiene permiso dia completo retorna 0
                    if ($permiso_dia_completo) return 0;

                    $permisos_dia = $this->marcacion_model->obtener_permisos_dia($marcaciones_dia[$i]['mar_id_emp'], $marcaciones_dia[$i]['mar_fecha_entrada']);
                    $tiempo_cubierto_por_permiso = 0;

                    $inicio_intervalo = $min_salida;
                    $fin_intervalo = $min_entrada_siguiente;
                    $hora_entrada = $this->marcacion_model->hora_a_minutos($marcaciones_dia[$i]['deh_hora_entrada']);
                    $hora_salida = $this->marcacion_model->hora_a_minutos($marcaciones_dia[$i]['deh_hora_salida']);  

                    // Si el fin de intervalo es posterior a la hora de salida                  
                    if ($fin_intervalo > $hora_salida) {
                        $fin_intervalo = $hora_salida;
                    }

                    if ($inicio_intervalo < $hora_entrada) {
                        $inicio_intervalo = $hora_entrada;
                    }

                    // Recorremos todos los permisos del día
                    foreach ($permisos_dia as $permiso) {

                        $permiso_inicio = $permiso['hxe_hora_inicio'];
                        $permiso_fin    = $permiso['hxe_hora_fin'];

                        // Calcular intersección entre el intervalo de marcación y el permiso
                        $inicio_interseccion = max($inicio_intervalo, $permiso_inicio);
                        $fin_interseccion = min($fin_intervalo, $permiso_fin);

                        if ($fin_interseccion > $inicio_interseccion) {
                            $tiempo_cubierto_por_permiso += ($fin_interseccion - $inicio_interseccion);
                        }
                    }

                    // Evitar exceder el tiempo fuera total
                    $tiempo_fuera = $fin_intervalo - $inicio_intervalo;
                    if ($tiempo_cubierto_por_permiso > $tiempo_fuera) {
                        $tiempo_cubierto_por_permiso = $tiempo_fuera;
                    }

                    $tiempo_pendiente_real = max(0, $tiempo_fuera - $tiempo_cubierto_por_permiso);
                    $tiempo_pendiente += $tiempo_pendiente_real;                  
                }
            }
        } 
        return $tiempo_pendiente;
    } 

    private function calcularHorasExtras($primer_marcacion, $ultima_marcacion)
    {
        if ($ultima_marcacion['mar_hora_salida'] == null) {
            return 0;
        }

        $hora_salida_real = $this->marcacion_model->hora_a_minutos($ultima_marcacion['mar_hora_salida']);
        $hora_salida_turno = $this->marcacion_model->hora_a_minutos($primer_marcacion['deh_hora_salida']);
        $horas_extras_asignadas = 0;
        $hora_descuento = 60;

        // Diferencia real entre salida y fin de turno
        $tiempo_trabajado = $hora_salida_real - $hora_salida_turno;

        if($tiempo_trabajado > 0){
            $minimo = $primer_marcacion['che_minutos_desde'];
            $maximo = $primer_marcacion['che_minutos_hasta'];
            $factor_hora = $primer_marcacion['che_factor_hora'];
            // Obtener las horas en minutos que se restaran
            for ($i=1; $i < 10; $i++) { 
                $hora_descuento = 60*$i;
                if($maximo < $hora_descuento){
                    break;
                }
            }
            // Hacer el calculo del tiempo a pagar
            while ($tiempo_trabajado>0) {
                if($tiempo_trabajado<$minimo){
                    break;
                } else if($tiempo_trabajado >= $minimo && $tiempo_trabajado <= $maximo){
                    $horas_extras_asignadas += $factor_hora;
                    break;
                } else if($tiempo_trabajado>$maximo){
                    $tiempo_trabajado = $tiempo_trabajado - $hora_descuento;
                    $horas_extras_asignadas +=$factor_hora;
                }
            }
        }        
        return $horas_extras_asignadas;
    }

    // TODO: Verificar funcionamiento con turnos nocturnos
    private function calcularDiferenciaMinutos($hora_inicio, $hora_fin)
    {
        $min_inicio = $this->marcacion_model->hora_a_minutos($hora_inicio);
        $min_fin = $this->marcacion_model->hora_a_minutos($hora_fin);
        
        $diferencia = $min_fin - $min_inicio;
        
        // Si es negativo, el turno cruza medianoche
        if ($diferencia < 0) {
            $diferencia += 1440; // Sumar 24 horas
        }
        
        return $diferencia;
    }    

}

?>