<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Mantenimientos extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
		      	
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
            $this->_cargarvista();
		}
	}



   /**
   * @author René Castaneda
   * @return Mantenimiento tre_tipo_retraso
   */
 function tipo_retraso() 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                
                $crud = new grocery_CRUD();
                $crud->set_table('tre_tipo_retraso')
                     ->set_subject('Tipo de retraso')
                     ->columns('tre_nombre','tre_estado')
                     ->fields('tre_nombre','tre_estado','tre_usu_mod','tre_fecha_mod')
                     ->display_as('tre_nombre','Nombre')
                     ->display_as('tre_estado', 'Estado')
                     ->required_fields('tre_nombre','tre_estado')
                     ->set_rules('tre_nombre','Nombre','trim|required|campo_unico[tre_tipo_retraso.tre_nombre]')
                     ->field_type('tre_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tre_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->unset_delete()
                     ;
                      if(end(explode('/',uri_string()))=='add') {
                     $crud->field_type('tre_estado','hidden',1);
                     }
                     else {
                     $crud->field_type('tre_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     }
                     $data['titulo_personal'] = "Tipos de retraso";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }


    /**
     * @author René Castaneda
     * @return Mantenimiento deh_detalle_horario
     */
    function detalle_horario() 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                //$dias_semana=array('Lunes'=>'Lunes','Martes'=>'Martes','Miércoles'=>'Miércoles','Jueves'=>'Jueves','Viernes'=>'Viernes','Sábado'=>'Sábado','Domingo'=>'Domingo');
                $crud = new grocery_CRUD();
                $crud->set_table('deh_detalle_horario')
                     ->set_subject('detalle de horario')
                     ->columns('deh_hora_entrada', 'deh_hora_salida', 'deh_estado')
                     ->fields('deh_hora_entrada', 'deh_hora_salida', 'deh_estado','deh_usu_mod','deh_fecha_mod')
                     ->display_as('deh_hora_entrada', 'Hora entrada')
                     ->display_as('deh_hora_salida', 'Hora salida')
                     ->display_as('deh_estado', 'Estado')
                     ->required_fields('deh_hora_entrada', 'deh_hora_salida', 'deh_estado','deh_usu_mod','deh_fecha_mod');
                if($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA')!=2) { //en caso de que sea emi omitir la validacion por los turnos que traspasan dos dias
                //    $crud->set_rules('deh_hora_entrada','Hora entrada','trim|callback_validacion_tiempo|required');
                }     
                $crud->field_type('deh_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                     ->field_type('deh_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('deh_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->unset_delete()
                     ;
                      if(end(explode('/',uri_string()))=='add') {
                     $crud->field_type('deh_estado','hidden',1);
                     }
                     else {
                     $crud->field_type('deh_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     }
                     $data['titulo_personal'] = "Detalles de horario";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

    function dias_feriados () 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                $crud = new grocery_CRUD();
                $crud->set_table('dnl_dia_no_laboral')
                        ->set_subject('Dias feriados')
                        ->columns('dnl_nombre', 'dnl_fecha_inicio', 'dnl_fecha_fin', 'dnl_descripcion', 'dnl_estado')
                        ->fields('dnl_nombre', 'dnl_tipo', 'dnl_fecha_inicio', 'dnl_fecha_fin', 'dnl_descripcion', 'dnl_estado', 'dnl_usu_modificacion', 'dnl_fecha_modificacion')
                        ->display_as('dnl_nombre', 'Nombre')
                        ->display_as('dnl_tipo', 'Tipo')
                        ->display_as('dnl_fecha_inicio', 'Fecha de inicio')
                        ->display_as('dnl_fecha_fin', 'Fecha final')
                        ->display_as('dnl_descripcion', 'Descripcion')
                        ->display_as('dnl_estado', 'Estado')
                        ->required_fields('dnl_nombre', 'dnl_tipo', 'dnl_fecha_inicio', 'dnl_estado', 'dnl_usu_modificacion', 'dnl_fecha_modificacion')
                        ->field_type('dnl_tipo', 'dropdown', array('1' => 'Fijo', '2' => 'Variable'))
                        ->field_type('dnl_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'))
                        ->field_type('dnl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('dnl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->add_action('Editar', '', "marcacion/mantenimientos/editar_dias_feriados", 'icomoon-icon-pencil-5')
                        ->add_action('Eliminar', 'icon16 icomoon-icon-remove', 'marcacion/mantenimientos/eliminar_dias_feriados', 'eliminar_dias_feriados')
                        ->unset_add()
                        ->unset_edit()
                        ->unset_read()
                        ->unset_delete()
                    ;

                    $exploded_url = explode('/', uri_string());

                    if(end($exploded_url)=='add') {
                        $crud->field_type('dnl_estado','hidden',1);
                    } else {
                        $crud->field_type('dnl_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                    }
                    $data['titulo_personal'] = "Dias feriados";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

    function ingresar_dias_feriados() {
        satelite_validar();
        if ($this->input->post()) {

            $nombre = (trim($this->input->post('nombre')) != "")?$this->input->post('nombre'):null;
            $fecha_inicio = $this->input->post('fecha_inicio_hidden');
            $fecha_fin = $this->input->post('fecha_fin_hidden');
            $dnl_descripcion = ($this->input->post('descripcion') != "")? $this->input->post('descripcion'):null;            
            $slc_tipo = ($this->input->post('slc_tipo') != "")? $this->input->post('slc_tipo'):null;

            $columnas_insert = array(
                'dnl_nombre' => $nombre,
                'dnl_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio),
                'dnl_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin),
                'dnl_descripcion' => $dnl_descripcion,
                'dnl_tipo' => $slc_tipo[0],
                'dnl_estado' => 1,
                'dnl_usu_creacion' => $this->tank_auth->get_user_id(),
                'dnl_fecha_creacion' => date('Y-m-d H:i:s'),
                'dnl_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dnl_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $dia_id = $this->gsatelite->ingresar('dnl_dia_no_laboral', $columnas_insert);
            
            // Mostrar alerta
            if ($dia_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de día feriado", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de día feriado", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("redireccion");

            if ($redireccion == 1) {
                redirect('marcacion/mantenimientos/ingresar_dias_feriados');
            } else if ($redireccion == 2) {
                redirect('marcacion/mantenimientos/dias_feriados');
            }
            die();
        } else {

            $data['titulo_personal'] = 'Agregar Días Feriados';
            $this->_cargarvista($data);
        }
    }

    public function editar_dias_feriados($dia_ide){
        satelite_validar();
        $data_dias = $this->gsatelite->get_tabla('dnl_dia_no_laboral',array('dnl_estado' => 1, 'dnl_id' => $dia_ide));
        $data['dia_id']                 = $data_dias[0]['dnl_id']; 
        $data['descripcion_dia']        = $data_dias[0]['dnl_descripcion'];
        $data['fechainicio']            = $data_dias[0]['dnl_fecha_inicio'];
        $data['fechafin']               = $data_dias[0]['dnl_fecha_fin'];
        $data['nombre']                 = $data_dias[0]['dnl_nombre'];
        $data['estado']                 = $data_dias[0]['dnl_estado'];
        $data['tipo_selected']          = $data_dias[0]['dnl_tipo'];
        if ($this->input->post()) {
            // print_r($_POST);die();

            $dias_id = (trim($this->input->post('id_dia')) != "")?$this->input->post('id_dia'):null;
            $nombre = (trim($this->input->post('nombre')) != "")?$this->input->post('nombre'):null;
            $fecha_inicio = $this->input->post('fecha_inicio_hidden');
            $fecha_fin = $this->input->post('fecha_fin_hidden');
            $dnl_descripcion = ($this->input->post('descripcion') != "")? $this->input->post('descripcion'):null;            
            $slc_tipo = ($this->input->post('slc_tipo') != "")? $this->input->post('slc_tipo'):null;

            $columnas_insert = array(
                'dnl_nombre' => $nombre,
                'dnl_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio),
                'dnl_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin),
                'dnl_descripcion' => $dnl_descripcion,
                'dnl_tipo' => $slc_tipo[0],
                'dnl_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dnl_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $dia_id = $this->gsatelite->actualizar_array('dnl_dia_no_laboral', $columnas_insert, array('dnl_id' => $dias_id));
       
            if ($dia_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de día feriado", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de día feriado", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("redireccion");

            if ($redireccion == 1) {
                redirect('marcacion/mantenimientos/editar_dias_feriados/'.$dias_id);
            } else if ($redireccion == 2) {
                redirect('marcacion/mantenimientos/dias_feriados');
            }
            die();
        } else {
            $data['titulo_personal'] = 'Editar Días Feriados';
            // var_dump($data);die();
            cargarvista($data, null, 'marcacion/mantenimientos/editar_dias_feriados');
        }
    }

    public function  eliminar_dias_feriados(){
        satelite_validar();
        $id  =  $this->input->post('dias_id');
        
        $mov = $this->gsatelite->borrado_general('dnl_dia_no_laboral', array('dnl_id' => $id));

        if (!$mov) {
            echo json_encode(array('respuesta'=> 0));
            die();
        }else{
             echo json_encode(array('respuesta'=> 1));
        }
    }

    //Rene castaneda
    //validacion de tiempos elegidos
    public function validacion_tiempo($data)
    {
        //   die(print_r($_POST));
        if( $data != '' )
        {
        $validado1=false; //variable que cambiará de valor cuando no se cumpla una condición de validación
        $validado2=false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación
        
        $f1=$this->input->post('deh_hora_entrada');
        $f2=$this->input->post('deh_hora_salida');
        $n_dias = strtotime($this->input->post('deh_hora_salida')) - strtotime($this->input->post('deh_hora_entrada'));    
        if($n_dias>0) { $validado1=true; } //primera condición
        else { $this->form_validation->set_message('validacion_tiempo', 'Hora entrada debe ser menor a hora salida');
                return false; }

        //PREGUNTAR SI EXISTEN REGISTROS SIMILARES
        $url_array = explode('/', uri_string());//en el caso de edit
        $no_incluir = (is_numeric(end($url_array)) and end($url_array)>0 )? end($url_array):0;     
        $pregunta = $this->gsatelite->get_tabla('deh_detalle_horario',array('deh_id !='=>$no_incluir,
                                                'deh_hora_entrada ='=>date('H:i',strtotime($f1)), 
                                                'deh_hora_salida ='=>date('H:i',strtotime($f2))
                                                ));
        if(count($pregunta)>0){
        $this->form_validation->set_message('validacion_tiempo', 'Ya existen otros rangos de tiempos similares');
                return false; 
            }
            else {
            $validado2=true; 
            }

        return ($validado1 and $validado2)? true:false;

        }
        else {
            return true;
        }
    }

    /**
    * @author René Castaneda
    * @return Mantenimiento tur_turno
    */
    function turno() 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {

                $crud = new grocery_CRUD();
                $crud->set_table('tur_turno')
                     ->set_subject('Turno')
                     ->columns('tur_nombre','tur_retraso','tur_id_tre','tur_estado')
                     ->set_relation('tur_id_tre','tre_tipo_retraso','tre_nombre',array('tre_estado'=>1))
                     ->fields('tur_nombre','tur_retraso','tur_id_tre','tur_estado','tur_usu_mod','tur_fecha_mod')
                     ->display_as('tur_nombre', 'Nombre')
                     ->display_as('tur_retraso', 'Retraso')
                     ->display_as('tur_estado', 'Estado')
                     ->display_as('tur_id_tre', 'Tipo retraso')
                     ->required_fields('tur_nombre','tur_estado','tur_usu_mod','tur_fecha_mod')
                     ->set_rules('tur_nombre','Nombre','trim|required|campo_unico[tur_turno.tur_nombre]')
                     ->field_type('tur_retraso','dropdown',array('1' => 'Sí', '0' => 'No'))
                     ->field_type('tur_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                     ->field_type('tur_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tur_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->unset_delete()
                     ;
                     $data['titulo_personal'] = "PUESTOS";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

    /**
    * @author Raul E.
    * @return Mantenimiento fre_frecuencia
    */
    function frecuencia(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try{
                $crud = new grocery_CRUD();
                $crud->set_table('fre_frecuencia')
                     ->set_subject('Frecuencia')
                     ->columns('fre_nombre','fre_estado')
                     ->display_as('fre_nombre', 'Nombre')
                     ->display_as('fre_estado', 'Estado')
                     ->required_fields('fre_nombre','fre_estado')
                     ->set_rules('fre_nombre','Nombre','trim|required|campo_unico[fre_frecuencia.fre_nombre]')
                     ->field_type('fre_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('fre_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                     ->edit_fields('fre_nombre','fre_estado', 'fre_usu_modificacion', 'fre_fecha_modificacion')
                     ->unset_delete()
                     ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('fre_estado', 'hidden', 1)
                         ->field_type('fre_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                         ->field_type('fre_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                    ;
                } else {
                    $crud->field_type('fre_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $data['titulo_personal'] = "Frecuencias";
                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }catch(Exception $e){
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }            
        }
    }

  /**
   * @author René Castaneda
   * @return Mantenimiento axp_anexoxpuesto
   */
 function anexos_puesto($id_puesto=null) 
    {
                satelite_validar();  
                $this->gsatelite->verificar_registro_real('pto_puesto',$id_puesto);
                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');
                $this->config->set_item('grocery_crud_file_upload_allow_file_types','pdf|jpeg|jpg|png|doc|xls|ppt');
                    
                $crud->set_table('axp_anexoxpuesto')
                     ->set_subject('Anexo Puesto')
                     ->where('axp_anexoxpuesto.axp_id_pto',$id_puesto)
                     ->columns('axp_id_pto','axp_nombre','axp_url','axp_estado')
                     ->set_relation('axp_id_pto', 'pto_puesto', 'pto_nombre')
                     ->fields('axp_id_pto','axp_nombre','axp_url','axp_estado','axp_usu_mod','axp_fecha_mod')
                     ->display_as('axp_id_pto', 'Puesto')
                     ->display_as('axp_nombre', 'Nombre')
                     ->display_as('axp_url', 'Anexo')
                     ->display_as('axp_estado', 'Estado')
                     ->required_fields('axp_id_pto','axp_nombre','axp_url','axp_estado')
                     ->set_rules('axp_nombre','Nombre','trim|required|campo_unico[axp_anexoxpuesto.axp_nombre]')
                     ->field_type('axp_id_pto', 'hidden', $id_puesto)
                      ->field_type('axp_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                     ->field_type('axp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('axp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->set_field_upload('axp_url','uploads/anexos_puesto')
                     ->unset_print()
                     ->unset_delete()
                     ->unset_export()
                     ;
                   
                     $data['titulo_personal'] = "ANEXOS PUESTO";
                     $output = $crud->render();
                     $this->_cargarvista($data,$output);
                   
        
    }



   /**
   * @author René Castaneda
   * @return Mantenimiento prv_periodo_vacacion
   */
 function periodos_vacacion() 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                
                $crud = new grocery_CRUD();
                $crud->set_table('prv_periodo_vacacion')
                     ->set_subject('Periodos Vacación')
                     ->columns('prv_nombre','prv_desde','prv_hasta','prv_estado')
                     ->fields('prv_nombre','prv_desde','prv_hasta','prv_estado','prv_usu_mod','prv_fecha_mod')
                     ->display_as('prv_nombre', 'Nombre')
                     ->display_as('prv_desde', 'Desde')
                     ->display_as('prv_hasta', 'Hasta')
                     ->display_as('prv_estado', 'Estado')
                     ->required_fields('prv_nombre','prv_desde','prv_hasta','prv_estado')
                     ->set_rules('prv_nombre','Nombre','trim|required|campo_unico[prv_periodo_vacacion.prv_nombre]')
                     ->set_rules('prv_desde','Desde','trim|callback_validacion_fechas|required')
                     ->field_type('prv_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                     ->field_type('prv_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('prv_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->unset_delete()
                     ;
                     $data['titulo_personal'] = "PERIODOS DE VACACIÓN";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }



    public function validacion_fechas($data)
{
//   die(print_r($_POST));
    if( $data != '' )
    {
    $validado1=false; //variable que cambiará de valor cuando no se cumpla una condición de validación
    $validado2=false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación
    
    $f1=$this->input->post('prv_desde');
    $f2=$this->input->post('prv_hasta');
    $n_dias= $this->gsatelite->get_intervalo_dias($f1,$f2);    
    if($n_dias>0) { $validado1=true; } //primera condición
    else { $this->form_validation->set_message('validacion_fechas', 'Fecha desde debe ser menor a fecha hasta');
            return false; }

   //PREGUNTAR SI EXISTEN REGISTROS DE FECHA DESDE MAYOR A LA INGRESADA. (PARA EVITAR REGISTRO CRUZADOS) 
    $url_array = explode('/', uri_string());//en el caso de edit
    $no_incluir = (is_numeric(end($url_array)) and end($url_array)>0 )? end($url_array):0;     
    $pregunta = $this->gsatelite->get_tabla('prv_periodo_vacacion',array('prv_id !='=>$no_incluir, 'prv_hasta >='=>date('Y-m-d',strtotime($f1))));
    if(count($pregunta)>0){
       $this->form_validation->set_message('validacion_fechas', 'Ya existen otros periodos que contienen la fecha desde');
            return false; 
        }
        else {
           $validado2=true; 
        }

       return ($validado1 and $validado2)? true:false;

    }
    else {
        return true;
    }
}

	function _cargarvista($data=0,$crud=0)
	{	


		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();		
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}


    /**
   * @author Nelson Soriano
   * @return Mantenimiento tipos de turno
   * @since  27-05-2019
   **/

    public function tipos_turnos(){
        satelite_validar();
        $id = null;///???
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $alias              = array(
                                    'tiu_nombre' => 'Nombre tipo',
                                    'tiu_estado'  => 'Estado',
                                    'tiu_aplica_marcacion' => 'Aplica marcacion');
        $required           = array(
                                'tiu_estado');

        $field              = array(
                                'tiu_nombre','tiu_estado',
                                'tiu_fecha_mod',
                                'tiu_usu_mod',
                                'tiu_usu_crea',
                                'tiu_fecha_crea',
                                'tiu_aplica_marcacion'
                            );
        $display            = array('tiu_nombre','tiu_estado','tiu_aplica_marcacion');

        $crud = new grocery_CRUD();
                $crud->set_table('tiu_tipo_turno')
                     ->set_subject('Tipo de turnos')
                     ->columns($display)
                     ->fields($field)
                     ->display_as($alias)
                     ->required_fields($required)
                     ->field_type('tiu_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tiu_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->field_type('tiu_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                     ->field_type('tiu_usu_crea', 'hidden',  $this->tank_auth->get_user_id())
                     ->callback_column('tiu_aplica_marcacion', function($value, $row) {
                        if ($value == 1) {
                            return 'Si';
                        }else{ return 'No';}
                    })
                     ->callback_add_field('tiu_aplica_marcacion', function() {
                      return '<input type="checkbox" id="chbdeAmarcacion" class="nostyle" checked>
                      <input type="hidden" id="field-tiu_aplica_marcacion" name="tiu_aplica_marcacion" value="1">';
                      })
                     ->callback_edit_field('tiu_aplica_marcacion', function($value, $primary_key) use ($id) {
                            $id      = $primary_key;
                            $leer    = ($this->uri->rsegments[3] == 'read')?'iButton':'';
                            $defecto = ($value)?'checked':''; // Verificar si esta activo
                            return '<input type="checkbox" id="chbdeAmarcacion" '.$defecto.' class="'.$leer.' nostyle">
                            <input type="hidden" id="field-tiu_aplica_marcacion" name="tiu_aplica_marcacion" value="'.$value.'">';
                        })
                     ;
                      if(end(explode('/',uri_string()))=='add') {
                     $crud->field_type('tiu_estado','hidden',1);
                     $crud->field_type('tiu_usu_crea','hidden', $this->tank_auth->get_user_id());
                     $crud->field_type('tiu_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
                     }
                     else {
                     $crud->field_type('tiu_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     }

                if (!$permisos['permite_ver']) {
                   $crud->unset_read();
                }

                if (!$permisos['permite_agregar']) {
                   $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                   $crud->unset_edit();
                }
                $data['titulo_personal'] = 'Tipos de turnos';
                $output = $crud->render();
                $this->_cargarvista($data,$output);
    }

}



/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */