<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Consultas extends CI_Controller {
	function __construct() {
		parent::__construct();
		$this->load->library('grocery_CRUD');
        $this->load->library('pdf');
		$this->load->library('form_validation');
		$this->load->model('gsatelite');
        $this->load->model('planilla_model');
        $this->load->model('personal_model');
        $this->load->model('accion_personal_model');
        $this->load->model('marcacion_model');
    }

	function index(){
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$this->_cargarvista();
		}
	}

    public function listado_empleados(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['total_empleados'] = $this->personal_model->listado_empleados();
            $data['titulo_personal'] = "Turno de empleados";
            $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data['empelados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $this->_cargarvista($data,null);
        }
    }

    public function consulta_marcaciones($id = NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                die(var_dump($_POST));
            }
            $data['agregar_marcacion'] = $id;
            $data['titulo_personal'] = "Marcaciones";
            $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data['empelados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $this->_cargarvista($data,null);
        }
    }

    public function listado_marcaciones($flag=null) {
        satelite_validar();
        if ($_POST) {
            $arename = $empname = "";
            $areid = $_POST["area"];
            $empid = $_POST["empleado"];
            $desde = $_POST["desde"];
            $hasta = $_POST["hasta"];
            $tipor = $_POST["tipo"];
            $where = array('mar_estado' => 1);
            if ($areid > 0) {
                $where['emp_id_are'] = $areid;
                $arename = $this->gsatelite->get_campo('are_area','are_nombre', array('are_id' => $areid));
            }
            if ($empid > 0) {
                $where['mar_id_emp'] = $empid;
                $emprow = $this->gsatelite->get_registro('emp_empleado', array('emp_id' => $empid));
                $empname = $emprow->emp_nombre . ' ' . $emprow->emp_apellido;
            }
            if ($desde != "") {
                $where['mar_fecha_entrada >= '] = formatear_fecha('Y-m-d', $desde);
            }
            if ($hasta != "") {
                $where['mar_fecha_entrada <= '] = formatear_fecha('Y-m-d', $hasta);
            }
                        $this->db->join('emp_empleado', 'emp_id = mar_id_emp');
                        $this->db->join('are_area', 'are_id = emp_id_are', 'LEFT');
                        $this->db->join('dxt_detallexturno', 'dxt_id = mar_id_dxt', 'LEFT');
                        $this->db->join('deh_detalle_horario', 'deh_id = dxt_id_deh', 'LEFT');
                        $this->db->join('tur_turno', 'tur_id = dxt_id_tur', 'LEFT');
            $registro = $this->gsatelite->get_tabla('mar_marcacion', $where);
            $data['tipo'] = $tipor;
            $data['arename'] = $arename;
            $data['empname'] = $empname;
            $data['registros'] = $registro;
            $periodo = ($desde != "" && $hasta != "") ? "De $desde a $hasta" : "";
            $data['periodo'] = $periodo;
            $html = $this->load->view('marcacion/consultas/detalle_listado_marcaciones', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($registro)));
            } else {
                if ($tipor == 1) {
                    echo $html;
                } else {
                    $header = $this->load->view('reporte/header', array('titulo' => 'Detalle de Marcaciones', 'solotitulo' => true), true);
                    $reporte = $header . $html;
                    $this->pdf->SetTitle("Detalle de Marcaciones");        
                    $this->pdf->makePDF($reporte, 'L');
                }
            }
        } else {
            $data['titulo_personal'] = "Listado Marcaciones";
            $seleca = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado' => '1'), null, '', 'are_id', true); 
            $selece = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data['areslct'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $seleca);
            $data['empslct'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $selece);
            $this->_cargarvista($data,null);
        }        
    }

    public function ver_datos_permiso($hxe_id){
        $data['detalle_permiso'] = $this->marcacion_model->get_datos_permiso(array('hxe_id' => $hxe_id));
        $data['titulo_personal'] = "Datos del Permiso";
        $this->gsatelite->cargar_vista_masterpage('marcacion/consultas/detalles_permiso', $data);
    }

    public function get_marcaciones(){
        satelite_validar();
        if($_POST){
            $arename = $empname = "";
            $area = $this->input->post('area');
            $emp = $this->input->post('empleado');
            $lista = $this->input->post('lista');
            $desde = date('Y-m-d',strtotime($this->input->post('desde')));
            $hasta = date('Y-m-d',strtotime($this->input->post('hasta')));
            $data['es_reporte'] = $this->input->post('tipo'); //'si';
            $data['print_editado'] = $this->input->post('print_editado');
            $data['autogestion'] = $autogestion = ($this->input->post('autogestion') != '') ? true : false;
            if(!empty($emp)){
                if($emp=="todos"){
                    $array_where = array(
                        'mar_fecha_entrada >='=>$desde,
                        'mar_fecha_entrada <='=>$hasta
                    );  
                }else{    
                    $array_where = array(
                        'mar_id_emp'=>$emp,
                        'mar_fecha_entrada >='=>$desde,
                        'mar_fecha_entrada <='=>$hasta
                    );
                    $empl = $this->gsatelite->get_registro('emp_empleado',array('emp_id'=>$emp));
                    $empname = $empl->emp_nombre.' '.$empl->emp_apellido;
                }
            } else {
                $array_where = array(
                    'mar_fecha_entrada >='=>$desde,
                    'mar_fecha_entrada <='=>$hasta
                );
                if ($lista != "" && $autogestion) {
                    $array_where["mar_id_emp IN ($lista)"] = null;
                }
            }
            if ($area != null) {
                $array_where['are_id'] = $area;
                $arer = $this->gsatelite->get_registro('are_area',array('are_id'=>$area));
                $arename = $arer->are_nombre;
            }   
            if(empty($data['es_reporte']) || ($data['print_editado'])){
                $array_where['mar_procesada'] = 0;
            } 
            $array_where['mar_revisado'] = 1;
            $marcaciones = $this->marcacion_model->get_reporte_marcacion2($array_where);
            $data['consulta'] = $marcaciones;
            $hora_extra = $retraso_entrada = $retraso_salidas = $perm_id = array();
            foreach ($marcaciones as $key => $value) {
                $tiempo_gracia = $this->marcacion_model->get_tiempo_gratis(array('tur_id'=>$value['tur_id'], 'cot_id_fre'=>$value['che_id_fre'], 'cot_estado' => 1));
                $hora_in_gracia = 0;
                $hora_out_gracia = 0;
                // Obtener los tiempos de gracia
                $aply_ret_inn = $aply_ret_out = false;
                foreach ($tiempo_gracia as $key2 => $value2) {
                    if($value2['cot_tipo']==1){
                        $aply_ret_inn = true;
                        $minxtra = $value2['cot_minutos'] - $value2['cot_inicio_calculo'];
                        $minxtin = ($minxtra < 0) ? 0 : $minxtra;
                        $hora_in_gracia = $value2['cot_minutos'];
                    }
                    if($value2['cot_tipo']==2){
                        $aply_ret_out = true;
                        $minxtra = $value2['cot_minutos'] - $value2['cot_inicio_calculo'];
                        $minxtou = ($minxtra < 0) ? 0 : $minxtra;
                        $hora_out_gracia = $value2['cot_minutos'];
                    } 
                }
                if (is_null($value['mar_hora_entrada']) || is_null($value['mar_hora_salida'])) {
                    $hora_in_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_entrada']);  
                    $hora_out_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_salida']);
                    $permiso_inicia = $this->marcacion_model->hora_a_minutos($value['inicia_permiso']);
                    $permiso_termina = $this->marcacion_model->hora_a_minutos($value['termina_permiso']);
                    $sin_permiso_dia_completo = ($value['id_permiso'] != "" && $permiso_inicia == 0 && $permiso_termina == 0) ? false : true;
                    if (is_null($value['mar_hora_entrada'])) {
                        $catconfinn = $this->gsatelite->get_tabla("cat_configuracion_accion_turno",array('cat_id_tur'=>$value['tur_id'],'cat_estado'=>1,'cat_tipo'=>1));
                        if (count($catconfinn) > 0 && $catconfinn[0]['cat_minutos'] > 0) {
                            if ($permiso_termina > 0 && $permiso_termina > $hora_in_asignada && $permiso_termina <= $hora_out_asignada && $permiso_inicia >= $hora_in_asignada) {
                                $retraso_ent = 0;
                            } else {
                                $retraso_ent = ($sin_permiso_dia_completo) ? $catconfinn[0]['cat_minutos'] : 0;
                            }
                        } else {
                            $retraso_ent = 0;
                        }                        
                    }
                    if (is_null($value['mar_hora_salida'])) {
                        $catconfinn = $this->gsatelite->get_tabla("cat_configuracion_accion_turno",array('cat_id_tur'=>$value['tur_id'],'cat_estado'=>1,'cat_tipo'=>2));
                        if (count($catconfinn) > 0 && $catconfinn[0]['cat_minutos'] > 0) {
                            if ($permiso_inicia > 0 && $permiso_inicia >= $hora_in_asignada && $permiso_inicia < $hora_out_asignada && $permiso_termina >= $hora_out_asignada) {
                                $retraso_sal = 0;
                            } else {
                                $retraso_sal = ($sin_permiso_dia_completo) ? $catconfinn[0]['cat_minutos'] : 0;
                            }
                        } else {
                            $retraso_sal = 0;
                        }
                    }
                    $hora_extra[] = 0;
                    $retraso_entrada[] = round($retraso_ent);
                    $retraso_salidas[] = round($retraso_sal);
                } else {                
                    $horas_trabajadas = $this->gsatelite->restar_horas_mysql($value['mar_hora_entrada'], $value['mar_hora_salida']);
                    $horas_asignadas = $this->gsatelite->restar_horas_mysql($value['deh_hora_entrada'], $value['deh_hora_salida']);
                    $horas_extras_trabajadas =  $horas_trabajadas - $horas_asignadas;
                    $horas_extras_asignadas = 0;
                    $tiempo_trabajado = round($horas_extras_trabajadas*60);
                    $hora_descuento = 60;
                    // Campos para calcular los retrasos
                    $hora_entrada = $this->marcacion_model->hora_a_minutos($value['mar_hora_entrada']);
                    $hora_salida = $this->marcacion_model->hora_a_minutos($value['mar_hora_salida']);
                    $hora_in_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_entrada']);  
                    $hora_out_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_salida']); 
                    $permiso_inicia = $this->marcacion_model->hora_a_minutos($value['inicia_permiso']);
                    $permiso_termina = $this->marcacion_model->hora_a_minutos($value['termina_permiso']);
                    $sin_permiso_dia_completo = ($value['id_permiso'] != "" && $permiso_inicia == 0 && $permiso_termina == 0) ? false : true;
                    $hora_in =  $hora_in_asignada + $hora_in_gracia;
                    $hora_out = $hora_out_asignada - $hora_out_gracia;
                    if ($permiso_termina > 0 && $permiso_termina > $hora_in && $permiso_termina <= $hora_out && $permiso_inicia <= $hora_in) {
                        $hora_in = $permiso_termina;
                        $perm_id[$key] = $value['id_permiso'];
                    }
                    if ($permiso_inicia > 0 && $permiso_inicia < $hora_out && $permiso_inicia >= $hora_in && $permiso_termina >= $hora_out) {
                        $hora_out = $permiso_inicia;
                        $perm_id[$key] = $value['id_permiso'];
                    }
                    $hora_entro = $hora_in + (59/60);//SI ENTRA 8:00:00, TAMBIEN SE RECIBE COMO VALIDO HASTA 8:00:59
                    $retraso_ent = $retraso_sal = 0;
                    if($value['mar_id_dxt'] != "" && $aply_ret_inn && $hora_entrada > $hora_entro && $sin_permiso_dia_completo){
                        $retraso_ent += intval(($hora_entrada - ($hora_in - $minxtin)));
                    }
                    if($value['mar_id_dxt'] != "" && $aply_ret_out && $hora_salida < $hora_out && $sin_permiso_dia_completo){
                        $retraso_sal += ceil(($hora_out - ($hora_salida - $minxtou)));
                    }  
                    // Fin del calculo de Retrasos o Salidas Temprano
                    //Calcular las Horas Extras
                    if($tiempo_trabajado>0){
                        // Hacer el calculo
                        $minimo = $value['che_minutos_desde'];
                        $maximo = $value['che_minutos_hasta'];
                        $factor_hora = $value['che_factor_hora'];
                        // Obtener las horas en minutos que se restaran
                        for ($i=1; $i < 10; $i++) { 
                            $hora_descuento = 60*$i;
                            if($maximo < $hora_descuento){
                                break;
                            }
                        }
                        // Hacer el calculo del tiempo a pagar
                        while ($tiempo_trabajado>0) {
                            if($tiempo_trabajado<$minimo){
                                break;
                            } else if($tiempo_trabajado >= $minimo && $tiempo_trabajado <= $maximo){
                                $horas_extras_asignadas +=$factor_hora;
                                break;
                            } else if($tiempo_trabajado>$maximo){
                                $tiempo_trabajado = $tiempo_trabajado - $hora_descuento;
                                $horas_extras_asignadas +=$factor_hora;
                            }
                        }
                    }
                    $hora_extra[] = $horas_extras_asignadas;
                    $retraso_entrada[] = round($retraso_ent);
                    $retraso_salidas[] = round($retraso_sal);
                }
            }
            $data['horas_extras'] = $hora_extra;
            $data['retraso_entrada'] = $retraso_entrada;
            $data['retraso_salida'] = $retraso_salidas;
            $data['permisos_ids'] = $perm_id;
            $data['arename'] = $arename;
            $data['empname'] = $empname;
            $data['esexcel'] = ($this->input->post('tipo') == 1) ? 1 : 0;
            // Procesar datos aca
            $html = $this->load->view('marcacion/consultas/get_marcaciones', $data, true); // Devuelve la tabla de resultados
            if($this->input->post('tipo')==1){ //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_marcacion.xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo $html;
            } elseif ($this->input->post('tipo')==2) { //pdf
                if (trim($empname) || trim($arename) != "") {
                    $subtitulo = "";
                    if (trim($arename) != "") {
                        $subtitulo = $arename;
                    }
                    if (trim($empname) != "") {
                        if ($subtitulo != "") {
                            $subtitulo .= "<br>";
                            $subtitulo .= $empname;
                        } else {
                            $subtitulo = $empname;
                        }                        
                    }
                    $titulos = array('titulo' => 'Marcaciones', 'subtitulo' => $subtitulo);
                } else {
                    $titulos = array('titulo' => 'Marcaciones');
                }                
                $html_header = $this->load->view('reporte/header', $titulos, true);    
                $this->load->library('pdf');
                $html = str_replace('class="responsive table table-striped table-bordered table-condensed"', ' style="font-size:8px;" ', $html);
                $this->pdf->makePDF($html_header.$html,'L');
            } else {
                echo json_encode(array('resultado'=>$html));
            }
        } else {
            die("<h1>Error!!!!!!!!!</h1>");
        }        
    }

    /**
     * @autor: Raul E
     * Descripcion: Reporte de llegadas tardias o salidas temprano
     */
    public function llegadas_tardias($flag = null){
        satelite_validar();
        if ($_POST) {
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $is_report = $this->input->post('tipo_rpte');
            $empleados = array();
            if ($fecha_ini != "" && $fecha_fin != "") {
                $data['periodo'] = "Del $fecha_ini Al $fecha_fin";
                $array_where = array('mar_fecha_entrada >=' => formatear_fecha('Y-m-d', $fecha_ini), /*'emp_id'=>142,*/ 'mar_fecha_entrada <=' => formatear_fecha('Y-m-d', $fecha_fin));
                             $this->db->group_by('emp_id');
                             $this->db->join('mar_marcacion', 'emp_id = mar_id_emp');
                $empleados = $this->gsatelite->get_tabla('emp_empleado', $array_where);
                $marcaciones = $this->marcacion_model->get_marcacion_area($array_where, 'emp_id, dxt_id, mar_fecha_entrada');
                // var_dump($marcaciones);die();
                if (count($marcaciones) > 0) {
                    $retraso_entrada = $retraso_salidas = $diasinjust = array();
                    foreach ($marcaciones as $key => $value) {
                        $tiempo_gracia = $this->marcacion_model->get_tiempo_gratis(array('tur_id' => $value['dxt_id_tur'], 'cot_estado' => 1, 'cot_id_fre'=>$value['che_id_fre']));
                        $hora_in_gracia = 0;
                        $hora_out_gracia = 0;
                        $aply_ret_inn = $aply_ret_out = false;
                        foreach ($tiempo_gracia as $key2 => $value2) {
                            if($value2['cot_tipo']==1){
                                $aply_ret_inn = true;
                                $minxtra = $value2['cot_minutos'] - $value2['cot_inicio_calculo'];
                                $minxtin = ($minxtra < 0) ? 0 : $minxtra;
                                $hora_in_gracia = $value2['cot_minutos'];
                            }
                            if($value2['cot_tipo']==2){
                                $aply_ret_out = true;
                                $minxtra = $value2['cot_minutos'] - $value2['cot_inicio_calculo'];
                                $minxtou = ($minxtra < 0) ? 0 : $minxtra;                                
                                $hora_out_gracia = $value2['cot_minutos'];
                            } 
                        }
                        $retraso_inn = $retraso_out = 0;
                        if (is_null($value['mar_hora_entrada']) || is_null($value['mar_hora_salida'])) {
                            $hora_in_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_entrada']);  
                            $hora_out_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_salida']); 
                            $permiso_inicia = $this->marcacion_model->hora_a_minutos($value['inicia_permiso']);
                            $permiso_termina = $this->marcacion_model->hora_a_minutos($value['termina_permiso']);
                            $sin_permiso_dia_completo = ($value['id_permiso'] != "" && $permiso_inicia == 0 && $permiso_termina == 0) ? false : true;
                            if (is_null($value['mar_hora_entrada'])) {
                                $catconfinn = $this->gsatelite->get_tabla("cat_configuracion_accion_turno",array('cat_id_tur'=>$value['dxt_id_tur'],'cat_estado'=>1,'cat_tipo'=>1));
                                if (count($catconfinn) > 0 && $catconfinn[0]['cat_minutos'] > 0) {
                                    if ($permiso_termina > 0 && $permiso_termina > $hora_in_asignada && $permiso_termina <= $hora_out_asignada && $permiso_inicia >= $hora_in_asignada) {
                                        $retraso_inn = 0;
                                    } else {
                                        if ($sin_permiso_dia_completo) {
                                            $retraso_inn = $catconfinn[0]['cat_minutos'];
                                        } else {
                                            $retraso_inn = 0;
                                        }
                                    }
                                } else {
                                    //// PDTE + CASOS DE USO
                                    $retraso_inn = 0;
                                }
                            }
                            if (is_null($value['mar_hora_salida'])) {
                                $catconfinn = $this->gsatelite->get_tabla("cat_configuracion_accion_turno",array('cat_id_tur'=>$value['dxt_id_tur'],'cat_estado'=>1,'cat_tipo'=>2));
                                if (count($catconfinn) > 0 && $catconfinn[0]['cat_minutos'] > 0) {
                                    if ($permiso_inicia > 0 && $permiso_inicia >= $hora_in_asignada && $permiso_inicia < $hora_out_asignada && $permiso_termina >= $hora_out_asignada) {
                                        $retraso_out = 0;
                                    } else {
                                        if ($sin_permiso_dia_completo) {
                                            $retraso_out = $catconfinn[0]['cat_minutos'];
                                        } else {
                                            $retraso_out = 0;
                                        }
                                    }
                                } else {
                                    //// PDTE + CASOS DE USO
                                    $retraso_out = 0;
                                }
                            }
                            if (is_null($value['mar_hora_entrada']) &&  is_null($value['mar_hora_salida']) && $sin_permiso_dia_completo) {
                                $diasinjust[$value['emp_id']][] = ($catconfinn[0]['cat_minutos'] + $catconfinn[0]['cat_minutos']);
                            }
                        } else {
                            $hora_entrada = $this->marcacion_model->hora_a_minutos($value['mar_hora_entrada']);
                            $hora_salida = $this->marcacion_model->hora_a_minutos($value['mar_hora_salida']);
                            $hora_in_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_entrada']);  
                            $hora_out_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_salida']); 
                            $permiso_inicia = $this->marcacion_model->hora_a_minutos($value['inicia_permiso']);
                            $permiso_termina = $this->marcacion_model->hora_a_minutos($value['termina_permiso']);
                            $sin_permiso_dia_completo = ($value['id_permiso'] != "" && $permiso_inicia == 0 && $permiso_termina == 0) ? false : true;
                            $hora_in = ($hora_in_asignada + $hora_in_gracia);
                            $hora_out = ($hora_out_asignada - $hora_out_gracia);
                            if ($permiso_termina > 0 && $permiso_termina > $hora_in && $permiso_termina <= $hora_out && $permiso_inicia <= $hora_in) {
                                $hora_in = $permiso_termina;
                            }
                            if ($permiso_inicia > 0 && $permiso_inicia < $hora_out && $permiso_inicia >= $hora_in && $permiso_termina >= $hora_out) {
                                $hora_out = $permiso_inicia;
                            }
                            $hora_entro = $hora_in + (59/60);//SI ENTRA 8:00:00, TAMBIEN SE RECIBE COMO VALIDO HASTA 8:00:59
                            if($value['mar_id_dxt'] != "" && $aply_ret_inn && $hora_entrada > $hora_entro && $sin_permiso_dia_completo){
                                $retraso_inn += intval(($hora_entrada - ($hora_in - $minxtin)));
                            }
                            if($value['mar_id_dxt'] != "" && $aply_ret_out && $hora_salida < $hora_out && $sin_permiso_dia_completo){
                                $retraso_out += ceil(($hora_out - ($hora_salida - $minxtou)));
                            }
                        }
                        if ($retraso_inn > 0) {
                            $retraso_entrada[$value['emp_id']][] = round($retraso_inn);
                        }
                        if ($retraso_out > 0) {
                            $retraso_salidas[$value['emp_id']][] = round($retraso_out);
                        }
                    }
                    $data['injustificados'] = $diasinjust;
                    $data['retraso_entrada'] = $retraso_entrada;
                    $data['retraso_salidas'] = $retraso_salidas;
                    // var_dump($retraso_entrada);die();
                }
            }
            $data['empleados'] = $empleados;
            $data['reporte'] = $is_report;
            $html = $this->load->view('marcacion/consultas/detalle_llegadas_tardias', $data, true);
            if ($flag) {
                $resultado = array('tabla' => $html, 'registros' => count($empleados));
                echo json_encode($resultado);
            } else {
                if ($is_report == 'pdf') {
                    $header = $this->load->view('reporte/header', array('titulo' => 'Llegadas Tardías'), true);
                    $reporte = $header . $html;
                    $this->pdf->makePDF($reporte, 'P');
                } else {
                    echo $html;
                }                
            }
        } else {
            $data['titulo_personal'] = "Llegadas Tardías";
            $this->_cargarvista($data);
        }        
    }

    /**
     * @autor: Raul E
     * Descripcion: Reporte de eventos de llegadas tardias por empleado
     */
    public function incidencia_marca($flag = null){ 
        satelite_validar();
        if ($_POST) {
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $ctd_event = $this->input->post('ctdad_evn');
            $is_report = $this->input->post('tipo_rpte');
            //empleados activos con turno y marcaciones revisadas dentro del periodo
            $where = array('mar_revisado' => 1, 'mar_estado' => 1, 'emp_estado' => 1, 'mar_id_dxt IS NOT NULL' => null);
            $where['mar_fecha_entrada >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            $where['mar_fecha_entrada <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            $registros = $this->marcacion_model->get_incid_marc($where);
            $data['periodo'] = $periodo = "Del $fecha_ini Al $fecha_fin";
            $data['registros'] = $registros;
            $data['pasables'] = $ctd_event;
            $data['reporte'] = $is_report;
            $html = $this->load->view('marcacion/consultas/detalle_incid_marca', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'registros' => count($registros)));
            } else {
                if ($is_report == 'pdf') {
                    $datos = $this->load->view('reporte/header', array('titulo' => 'Eventos de Llegadas Tardías', 'subtitulo' => $periodo), true);
                    $datos .= $html;
                    $this->pdf->makePDF($datos, 'P');
                } else {
                    echo $html;
                }                
            }
            
        } else {
            $data['titulo_personal'] = "Incidencias Marcaciones";
            $this->_cargarvista($data);
        }        
    }

    public function grafico_llegadas_tarde($fec_ini = '', $fec_fin = '', $ctdad = ''){
        $fecha_ini = formatear_fecha('Y-m-d', $fec_ini);
        $fecha_fin = formatear_fecha('Y-m-d', $fec_fin);
        $ctd_event = intval($ctdad);
        $where = array('mar_revisado'=> 1, 'mar_estado'=> 1, 'emp_estado'=> 1, 'mar_id_dxt IS NOT NULL'=> null, 'mar_fecha_entrada >='=> $fecha_ini, 'mar_fecha_entrada <='=> $fecha_fin);
        $registros = $this->marcacion_model->get_incid_marc($where);
        $valores = array("Personal sin llegadas tarde" => 0, "Personal con llegadas tarde (1 a $ctd_event veces)" => 0, "Personal con llegadas tarde (Más de $ctd_event veces)" => 0);
        foreach ($registros as $key => $val) {
            if ($val['eventos'] > 0) {
                if ($val['eventos'] > $ctd_event) {
                    $valores["Personal con llegadas tarde (Más de $ctd_event veces)"]++;
                } else {
                    $valores["Personal con llegadas tarde (1 a $ctd_event veces)"]++;
                }
            } else {
                $valores['Personal sin llegadas tarde']++;
            }            
        }
        $data['registros'] = $valores;
        $data['colores'] = array('#AED581', '#FFF176', '#E57373');
        $this->load->view('marcacion/consultas/grafico_llegadas_tardias', $data, false);        
    }


    public function get_empleados(){
        satelite_validar();
        if($_POST){
            $area = $this->input->post('area');
            $emp = $this->input->post('empleado');
            $array_where = array();
            if ($emp > 0) {
                $array_where['emp_id'] = $emp;
            }
            if ($area > 0) {
                $array_where['are_id'] = $area;
            }
            $data['total_empleados'] = $this->personal_model->listado_empleados($array_where);
            $data['titulo_personal'] = "Turno de empleados";
            $html = $this->load->view('marcacion/consultas/get_empleados', $data, true); // Devuelve la tabla de resultados
            if($this->input->post('tipo')==1){ //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_marcacion.xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo $html;
            } elseif ($this->input->post('tipo')==2) { //pdf
                $html_header = $this->load->view('reporte/header', array('titulo' => 'Marcaciones'), true);    
                $this->load->library('pdf');
                $html = str_replace('class="responsive table table-striped table-bordered table-condensed"', ' style="font-size:8px;" ', $html);
                $this->pdf->makePDF($html_header.$html,'L');
            } else {
                echo json_encode(array('resultado'=>$html));
            }
        } else {
            die("<h1>Error!!!!!!!!!</h1>");
        }
    }

    public function get_lista_empleados_area() {
        $area = $this->input->post('area');
        $emps = $this->gsatelite->get_dropdown('emp_empleado','{emp_codigo} - {emp_nombre} {emp_apellido}','',array('emp_id_are'=> $area,'emp_estado'=>1), null,null,'emp_id', true);
        echo json_encode(array('select' => str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'),'<option value=""></option>',$emps)));
    }

    public function ver_detalle_turno($id_emp,$modal = false) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->gsatelite->verificar_registro_real('emp_empleado',$id_emp);
            $data['empleado'] = $this->gsatelite->get_registro('emp_empleado','emp_id',$id_emp);
                                $this->db->join('tur_turno','tur_id=txe_id_tur');
                                $this->db->join('tiu_tipo_turno','tiu_id=txe_id_tiu');
            $data['detalles'] = $this->gsatelite->get_tabla('txe_turnoxempleado',array('txe_id_emp'=>$id_emp,'txe_estado'=>1));
            $data["viene_modal"] = $modal;
            $data['titulo_personal'] = "Turno de empleados";
            if ($modal) {
                $this->gsatelite->cargar_vista_masterpage('marcacion/consultas/ver_detalle_turno', $data);
            } else {
                $this->_cargarvista($data,null);
            } 
        }
    }

    function eliminar_detalle($id, $grid = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('txe_turnoxempleado',$id);
        $id_emp = $this->gsatelite->get_campo('txe_turnoxempleado','txe_id_emp',array('txe_id'=>$id));
        $this->gsatelite->actualizar_array('txe_turnoxempleado',array('txe_estado'=>0),array('txe_id'=>$id));
        if ($grid) {
            $this->gsatelite->show_dialog('Turno desactivado con éxito',"marcacion/procesos/grid_asignacion_turno",'success');
        } else {
            $this->gsatelite->show_dialog('Turno desactivado con éxito',"marcacion/consultas/ver_detalle_turno/$id_emp",'success');
        }
    }

  public function consulta_detalle_horario()
  {
    if (!$this->tank_auth->is_logged_in()) {
      redirect('/auth/login/');
    } else {
      if($_POST){
        die(var_dump($_POST));
      }
      $data['titulo_personal'] = "Detalles de horario";
      $this->_cargarvista($data,null);
    }
  }

    public function get_detalle_turno($infoxtra = null){
        satelite_validar();
        if($_POST){
            $turno = $this->input->post('turno');
            $data['es_reporte'] = $this->input->post('tipo');
            $data['registro_turno'] = $this->gsatelite->get_registro('tur_turno','tur_id',$turno);
                                $this->db->order_by('dia_id', 'ASC');
                                $this->db->join('dia_dia','dia_id=dxt_id_dia');
                                $this->db->join('deh_detalle_horario','deh_id=dxt_id_deh')->group_by('dxt_id');
            $data['consulta'] = $this->gsatelite->get_tabla('dxt_detallexturno',array('dxt_id_tur'=>$turno));
            $data['infoxtra'] = $infoxtra; 
            $html = $this->load->view('marcacion/consultas/get_detalle_turno', $data, true);
            if($this->input->post('tipo')==1){ //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_detalle_turno.xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo $html;
            } elseif ($this->input->post('tipo')==2) { //pdf
                $html_header = $this->load->view('reporte/header', array('titulo' => 'Detalle Turno'), true);
                $this->load->library('pdf');
                $html = str_replace('class="responsive table table-striped table-bordered table-condensed"', ' style="font-size:8px;" ', $html);
                $this->pdf->makePDF($html_header.$html,'L');
            } else {
                echo json_encode(array('resultado'=>$html));
            }
        } else {
            die("<h1>Error!!!!!!!!!</h1>");
        }        
    }

    /**
    * Descripción:
    * Función para generar reportes personalizado UTE
    * @author René Castaneda - Grupo satélite
    * @since  2021-09-06
    * @param  $flag int 
    * @return 
    */
    public function llegadas_tardias2($flag = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $is_report = $this->input->post('tipo_rpte');
            $empleados = array();
            if ($fecha_ini != "" && $fecha_fin != ""){
                $data['periodo'] = "Del $fecha_ini Al $fecha_fin";
                $fecha_ini =  formatear_fecha('Y-m-d', $fecha_ini);
                $fecha_fin =  formatear_fecha('Y-m-d', $fecha_fin);
                $dias_mes =  formatear_fecha('t', $fecha_ini);
                $marcaciones = $this->marcacion_model->get_marcacion_emp($fecha_ini, $fecha_fin);
                $data['marcaciones'] = $marcaciones;
                $data['dias_mes'] = $dias_mes;
                $data['reporte'] = $is_report;
                $html = $this->load->view('marcacion/consultas/detalle_llegadas_tardias2', $data, true);
                if ($flag) {
                    $resultado = array('tabla' => $html, 'registros' => count($marcaciones));
                    echo json_encode($resultado);
                } else {
                    if ($is_report == 'pdf') {
                        $header = $this->load->view('reporte/header', array('titulo' => 'llegadas tardías / salidas temprano'), true);
                        $reporte = $header . $html;
                        $this->pdf->SetTitle("Resumen de marcaciones");        
                        $this->pdf->makePDF($reporte, 'L');
                    } else {
                        echo $html;
                    }                
                }
            }
        } else {
            $data['titulo_personal'] = "Llegadas Tardías";
            $this->_cargarvista($data);
        }        
    }
   
	function _cargarvista($data=0,$crud=0){	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();		
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}




}

