<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Public_controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->model('eventos_model');
        $this->load->model('avisos_model');
        $this->load->model('landing_page_model');
        $this->load->model('estructura_organizativa_model');
    }

    function index() {

        $this->lod_landing_page();

    }

    function valida_permiso()
    {
        $landing_page = $this->gsatelite->get_parametro_emp("SYS-ACTIVA-LANDING-PAGE")??0;

        if (!$this->tank_auth->is_logged_in()) {
            
            if (!$landing_page) {
               redirect('/auth/login/');
            }
        }
    }

    function lod_landing_page(){
        $this->valida_permiso();

        $where["evn_estado"] = 1;
        $where["evn_publico"] = 1;
        $registros = $this->eventos_model->get_usuarios_eventos2($where);

        $tbl = array();

        foreach ($registros as $cal) {
            // Asegurarse de que las fechas estén en el formato Y-m-d
            $fechaInicio = !empty($cal["evn_fecha_evento"]) 
                ? date("Y-m-d", strtotime($cal["evn_fecha_evento"])) 
                : "1970-01-01";

            $fechaFin = !empty($cal["evn_fecha_evento_fin"]) 
                ? date("Y-m-d", strtotime($cal["evn_fecha_evento_fin"])) 
                : $fechaInicio;

            // Asegurarse de que las horas estén definidas
            $horaInicio = !empty($cal["evn_hora_evento"]) ? $cal["evn_hora_evento"] : "00:00:00";
            $horaFin = !empty($cal["evn_hora_evento_fin"]) ? $cal["evn_hora_evento_fin"] : $horaInicio;

            // Construir cada evento
            $tbl[] = [
                "id" => $cal["evn_id"],
                "title" => $cal["evn_asunto"],
                "start" => $fechaInicio . " " . $horaInicio,
                "end" => $fechaFin . " " . $horaFin,
                "description" => $cal["evn_detalle"],
                "location" => $cal["evn_lugar"],
                "backgroundColor" => "#87378E",
                "url" => base_url()."landing_page/public_controller/visualizar_evento/".$cal["evn_id"]
            ];
        }

        
        $data['avisos'] = $this->landing_page_model->get_avisos();
        $data["registros"] = json_encode($tbl);
        $data["archivero"] = $this->landing_page_model->load_public_arch();
        $data["directorio"] = $this->landing_page_model->load_directorio();
        $data["cumplea"] = $this->landing_page_model->load_cumple_mes();
        

        $data["vista"] = "landing_page/index";
        $this->load_public_template($data);

    }

    function lod_organigrama(){
        $tipo_estructura = "";
    

        $id_empresa = 1;
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS - PLAZA";
        // $data["imprimir"] = $print;
        $datos_padres = $this->landing_page_model->get_solo_padres(null, $id_empresa);

        $area_especifica = (count($datos_padres) > 0) ? $datos_padres[0]['are_id'] : null;
        if ($area_especifica != null and $area_especifica > 0) {
            $data["id_area_espeficica"] = $area_especifica;
            $data['registro_area'] = $this->gsatelite->get_registro('are_area', 'are_id', $area_especifica);

        } else {


            $data["datos_padres"] = $datos_padres;

            $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
            $this->db->where('mxr_id_emr', $id_empresa);
            $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"] = $nivel['ultimo_nivel'];
        }



        $data["vista"] = 'landing_page/internas/organigrama';

        $data["emr_id"] = $id_empresa;

        $data["landing_page"] = 1;

        $this->load_public_template($data);

    }

	function load_document(){
        $this->valida_permiso();
        $data["vista"] = "internas/load_document";
        $this->load_public_template($data);

    }

	public function get_documentos() {
        $this->valida_permiso();
        $directorioBase = FCPATH . '/uploads/documentos_intranet';

        if (isset($_GET['carpeta'])) {
            $carpeta = basename($_GET['carpeta']); // Sanitizar el nombre de la carpeta
            $ruta = $directorioBase . '/' . $carpeta;

            if (is_dir($ruta)) {
                $archivos = array_diff(scandir($ruta), array('.', '..', '_vti_cnf')); // Excluir _vti_cnf
                $data = ['documentos' => array_values($archivos)];
            } else {
                $data = ['documentos' => []];
            }
        } else {
            $data = ['documentos' => []];
        }

        $this->output
        ->set_content_type('application/json', 'utf-8')
        ->set_output(json_encode($data, JSON_UNESCAPED_UNICODE));

    }






    function construir_organigrama($data, $parentId = null) {
        $this->valida_permiso();
    $chartData = [];
    foreach ($data as $item) {
        if ($item['CODIGO_ORDEN_PADRE'] == $parentId) {
            $node = [
                'id' => $item['CORRELATIVO'],   
                'parent' => $item['CODIGO_ORDEN_PADRE'],
                'name' => $item['NOMBRE_AREA'],
            ];

            $children = $this->construir_organigrama($data, $item['CORRELATIVO']);
            if ($children) {
                $node['children'] = $children;
            }
            $chartData[] = $node;
        }
    }
    return $chartData;
}


    function lod_directory(){
        $this->valida_permiso();

        $data["directorio"] = $this->oracleserver_model->get_tabla("in_guia_telefonica_v");
        $data["vista"] = "internas/directorio";
        $this->load_public_template($data);

    }

    function load_birthday(){
        $this->valida_permiso();

        $data["cumple_dia"] = $this->oracleserver_model->get_cumple_dia();
        $data["cumple_mes"] = $this->oracleserver_model->get_cumple_mes();

        $data["vista"] = "internas/cumplea";
        $this->load_public_template($data);

    }

    function load_calendar()
    {
        $this->valida_permiso();
        $where["evn_estado"] = 1;
        $registros = $this->eventos_model->get_usuarios_eventos2($where);

        $tbl = array();

        foreach ($registros as $cal) {
            // Asegurarse de que las fechas estén en el formato Y-m-d
            $fechaInicio = !empty($cal["evn_fecha_evento"]) 
                ? date("Y-m-d", strtotime($cal["evn_fecha_evento"])) 
                : "1970-01-01";

            $fechaFin = !empty($cal["evn_fecha_evento_fin"]) 
                ? date("Y-m-d", strtotime($cal["evn_fecha_evento_fin"])) 
                : $fechaInicio;

            // Asegurarse de que las horas estén definidas
            $horaInicio = !empty($cal["evn_hora_evento"]) ? $cal["evn_hora_evento"] : "00:00:00";
            $horaFin = !empty($cal["evn_hora_evento_fin"]) ? $cal["evn_hora_evento_fin"] : $horaInicio;

            // Construir cada evento
            $tbl[] = [
                "id" => $cal["evn_id"],
                "title" => $cal["evn_asunto"],
                "start" => $fechaInicio . " " . $horaInicio,
                "end" => $fechaFin . " " . $horaFin,
                "description" => $cal["evn_detalle"],
                "location" => $cal["evn_lugar"],
                "backgroundColor" => "#131655",
            ];
        }

        $data['registros'] = json_encode($tbl);
        $data["vista"] = "internas/calendario";
        $this->load_public_template($data);
    }


    public function visualizar_evento($id_evento = 0){


        $registro_evento = $this->eventos_model->informacion_eventos(array("evn_id"=>$id_evento));

        $data["registro_evento"] = $registro_evento[0];

        $roles_evento = $this->gsatelite->get_tabla("vxl_eventoxrol",array("vxl_id_evn"=>$id_evento));
        $data["registro_anexos_evento"] = $this->gsatelite->get_tabla("ann_anexo_evento",array("ann_id_evn"=>$id_evento));
        $roles_selected = array_column($roles_evento,"vxl_id_rol");

        $datos_usuario = $this->eventos_model->get_info_usuario(array("id"=>$registro_evento[0]["evn_id_usu"]));
        $data["datos_usuario"] = $datos_usuario[0];



        $this->gsatelite->cargar_vista_masterpage("landing_page/public/ver_evento",$data,null);
    }


    public function load_arch_x_uba() {
        $arch_id = $this->input->post("uba_id");

        $archivos = $this->landing_page_model->load_arch_x_uba($arch_id);

        foreach ($archivos as &$archivo) {
            $archivo['arh_size'] = formatFileSize($archivo['arh_size']);
        }

        $output = [
            "archivos" => $archivos
        ];

        ob_clean();
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($output, JSON_UNESCAPED_UNICODE);
        exit;
    }





    function load_public_template($data){

        $this->valida_permiso();
        $data["redes"] = $this->gsatelite->get_tabla("grs_gestion_redes_sociales", ["grs_estado" => 1]);
        $arraHed = $this->gsatelite->get_tabla("gcs_gestion_contenido_sistema", ["gcs_estado" => 1, "gcs_clave" => "LOGO_HEADER"]);
        $arraFot = $this->gsatelite->get_tabla("gcs_gestion_contenido_sistema", ["gcs_estado" => 1, "gcs_clave" => "LOGO_FOOTER"]);

        $header = end($arraHed);
        $footer = end($arraFot);

        $data["logo_header"] = $header["gcs_url"];
        $data["logo_footer"] = $footer["gcs_url"];

        $html = $this->load->view("landing_page/config/header", $data);
        $html .= $this->load->view($data['vista'], $data);
        $html .= $this->load->view("landing_page/config/footer", $data);

        return $html;

    }
}
