<?php 

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Controller_landing_page extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('sistema');
        $this->load->model('consultas');
        $this->load->model('gsatelite');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }


public function slider_init() {
    satelite_validar();
        try {
           
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $this->load->config('grocery_crud');
            $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'jpeg|jpg|png');

            $columnas = array(
                'gcs_lugar',
                'gcs_clave',
                'gcs_nombre',
                'gcs_valor',
                'gcs_url',
                'gcs_estado'
            );

            $required = array(
                'gcs_lugar',
                'gcs_estado'
            );

            $alias = array(
                'gcs_lugar'=>'Lugar',
                'gcs_clave'=>'Clave',
                'gcs_nombre'=>'Descripción o titulo',
                'gcs_valor'=>'Valor o subtitulo',
                'gcs_url'=>'Imagen',
                'gcs_estado'=>'Estado'
            );

            $columnas_insert = array(
                'gcs_lugar',
                'gcs_clave',
                'gcs_nombre',
                'gcs_valor',
                'gcs_url',
                'gcs_estado',
                'gcs_usu_creacion',
                'gcs_fecha_creacion',
                'gcs_usu_modificacion',
                'gcs_fecha_modificacion'
            );

            $columnas_update = array(
                'gcs_lugar',
                'gcs_clave',
                'gcs_nombre',
                'gcs_valor',
                'gcs_url',
                'gcs_estado',
                'gcs_usu_modificacion',
                'gcs_fecha_modificacion'
            );
            $lugar_contenido = array(
                '1'=>'INICIO'
            );
            $clave_contenido = array(
                'IMAGEN_CARRUSEL'=>'Imagen para carrusel',
                'LOGO_HEADER'=>'Imagen logo superior',
                'LOGO_FOOTER'=>'Imagen log inferior',
            );
            $crud->set_table('gcs_gestion_contenido_sistema')
                    ->set_subject('Gestión Contenido')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->field_type('gcs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('gcs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('gcs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('gcs_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('gcs_lugar', 'hidden', 1)
                    ->field_type('gcs_clave', 'dropdown', $clave_contenido)
                    ->set_field_upload('gcs_url', 'uploads/sistema/gestion_contenido', 'Imagen')
            ;
            $crud->callback_column('gcs_valor',function($value, $row){
                return $value;
            });
            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('gcs_estado', 'hidden', 1);
            } else {
                $crud->field_type('gcs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if (substr_count(uri_string(),'add') > 0 || substr_count(uri_string(),'edit') > 0 ) {
                $crud->field_type('gcs_lugar', 'hidden', 1);
            } else {
                $crud->field_type('gcs_lugar', 'dropdown', $lugar_contenido);
            }

            $crud->field_type('gcs_valor', 'text');


            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Gestión Contenido";
           
            $ruta_vista = 'landing_page/public/slider_init';
            cargarvista($data, $output, $ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }






public function gestionar_pagina_inicio() {
        satelite_validar();
        try {
           
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $this->load->config('grocery_crud');
            $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'jpeg|jpg|png');

            $columnas = array(
                'gpi_clave',
                'gpi_nombre',
                'gpi_valor',
                'gpi_presentacion',
                'gpi_url_bloque',
                'gpi_url_principal',
                'gpi_estado'
            );

            $required = array(
                'gpi_lugar',
                'gpi_clave',
                'gpi_presentacion',
                'gpi_nombre',
                'gpi_estado'
            );

            $alias = array(
                'gpi_lugar'=>'Lugar',
                'gpi_clave'=>'Clave',
                'gpi_nombre'=>'Descripción o titulo',
                'gpi_valor'=>'Cuerpo',
                'gpi_ancho' => "Ancho de imagen",
                'gpi_alto' => "Alto de imagen",
                'gpi_theme' => "Tema",
                'gpi_presentacion' => 'Presentaion',
                'gpi_div_id' => "Id del elemento",
                'gpi_url_principal'=>'Imagen principal',
                'gpi_url_bloque'=>'Imagen del bloque',
                'gpi_estado'=>'Estado'
            );

            $columnas_insert = array(
                'gpi_lugar',
                'gpi_clave',
                'gpi_nombre',
                'gpi_valor',
                'gpi_ancho',
                'gpi_alto',
                'gpi_theme',
                'gpi_presentacion',
                'gpi_div_id',
                'gpi_url_bloque',
                'gpi_url_principal',
                'gpi_estado',
                'gpi_usu_creacion',
                'gpi_fecha_creacion',
                'gpi_usu_modificacion',
                'gpi_fecha_modificacion'
            );

            $columnas_update = array(
                'gpi_lugar',
                'gpi_clave',
                'gpi_nombre',
                'gpi_valor',
                'gpi_ancho',
                'gpi_alto',
                'gpi_theme',
                'gpi_presentacion',
                'gpi_div_id',
                'gpi_url_bloque',
                'gpi_url_principal',
                'gpi_estado',
                'gpi_usu_modificacion',
                'gpi_fecha_modificacion'
            );
            $lugar_contenido = array(
                '1'=>'INICIO'
            );
            $clave_contenido = array(
                'INDEX'=>'Pagina principal',
                'CUMPLE'=>'Cumpleañeros',
                'DIRECTORIO'=>'Directorios',
                'CALENDARIO'=>'Calendario',
                'ORGANIGRAMA'=>'Organigrama'
            );

            $presentacion = array(
                1 => 'Bloque unico',
                2 => 'Bloque doble'
            );

             $clave_tema= array(
                "BG-BLUE" => "Tema Azul",
                "BG-SMOKE" => "Tema Gris",
                "BG-IMG" => "Bloque con imagen",
                "BG-IMG-FIXED" => "Bloque con imagen fija"
            );

            $crud->set_table('gpi_gestion_pagina_inicio')
                    ->set_subject('Gestión Contenido')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->field_type('gpi_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('gpi_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('gpi_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('gpi_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('gpi_lugar', 'hidden', 1)
                    ->field_type('gpi_clave', 'dropdown', $clave_contenido)
                    ->field_type('gpi_theme', 'dropdown', $clave_tema)
                    ->field_type('gpi_presentacion', 'dropdown', $presentacion)
                    ->set_field_upload('gpi_url_bloque', 'uploads/sistema/gestion_contenido', 'Imagen')
                    ->set_field_upload('gpi_url_principal', 'uploads/sistema/gestion_contenido', 'Imagen')
            ;
            $crud->callback_column('gpi_valor',function($value, $row){
                return $value;
            });
            $uri_segments = explode('/', uri_string());
if (end($uri_segments) == 'add') {
                $crud->field_type('gpi_estado', 'hidden', 1);
            } else {
                $crud->field_type('gpi_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if (substr_count(uri_string(),'add') > 0 || substr_count(uri_string(),'edit') > 0 ) {
                $crud->field_type('gpi_lugar', 'hidden', 1);
            } else {
                $crud->field_type('gpi_lugar', 'dropdown', $lugar_contenido);
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Gestión Contenido";
           
            $ruta_vista = 'landing_page/public/gestionar_pagina_inicio';
            cargarvista($data, $output, $ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    function get_detail_block_init() {
        $data = [
            "table" => $this->gsatelite->get_tabla("gpi_gestion_pagina_inicio", ["gpi_estado" => 1])
        ];

        // Limpiar buffers y forzar salida JSON
        ob_clean();
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        exit;
    }





    /**
     * @author Melbin Cruz
     */
    function validar_nombre_usuario() {
        $usuario = $this->input->post('usuario');
        $usuario_hid = $this->input->post('usuario_hid');

        if ($usuario_hid == $usuario) {
            echo json_encode(array('respuesta' => 2));
            die(); // Es el mismo ingresado
        }

        if (strpos($usuario, ' ') !== false) {
            echo json_encode(array('respuesta' => 0));
        } else {

            $existe = $this->gsatelite->get_campo('users', 'id', array('username' => $usuario));

            if ($existe > 0) {
                echo json_encode(array('respuesta' => 1)); // Existe
            } else {
                echo json_encode(array('respuesta' => 2)); // No existe
            }
        }
    }




    function cambiar($id) {
        if ($id != null) {
            $nick = $this->sistema->obtenerNickUser($id);
            $data['titulo_personal'] = 'Cambiar Clave para ' . $nick->username;
            $data['llave_u'] = $id;
            $this->_cargarvista($data);
        } else {
            redirect('sistema/acceso/usuarios');
        }
    }



    public function gestion_redes_sociales() {
    satelite_validar();
        try {
           
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $this->load->config('grocery_crud');
            $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'jpeg|jpg|png');

            $columnas = array(
                'grs_nombre',
                'grs_url',
                'grs_icono',
                'grs_estado'
            );

            $required = array(
                'grs_nombre',
                'grs_url',
                'grs_icono',
                'grs_estado'
            );

            $alias = array(
                'grs_nombre'=>'Nombre',
                'grs_url'=>'Url',
                'grs_icono'=>'Icono',
                'grs_estado'=>'Estado'
            );

            $columnas_insert = array(
                'grs_nombre',
                'grs_url',
                'grs_icono',
                'grs_estado',
                'grs_usu_creacion',
                'grs_fecha_creacion',
                'grs_usu_modificacion',
                'grs_fecha_modificacion'
            );

            $columnas_update = array(
                'grs_nombre',
                'grs_url',
                'grs_icono',
                'grs_estado',
                'grs_usu_modificacion',
                'grs_fecha_modificacion'
            );


            $crud->set_table('grs_gestion_redes_sociales')
                    ->set_subject('Gestión de redes sociales')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->field_type('grs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('grs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('grs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('grs_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->set_field_upload('grs_icono', 'public/source/utiles/img/redes', 'Imagen')
            ;
            $crud->callback_column('gcs_valor',function($value, $row){
                return $value;
            });
            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('grs_estado', 'hidden', 1);
            } else {
                $crud->field_type('grs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Gestión Contenido";
           
            $ruta_vista = 'landing_page/public/gestion_redes_sociales';
            cargarvista($data, $output, $ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }





   
    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }




}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */