<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Requisiciones extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('excel/excel_reader.php');
    }

    public function send_email($email) {
        $ci = get_instance();
        $ci->load->library('email');
        $config['protocol'] = "smtp";
        $config['smtp_host'] = "ssl://mail.gruposatelite.net";
        $config['smtp_port'] = "465";
        $config['smtp_user'] = $this->gsatelite->get_parametro('CORREO_ADMIN');
        $config['smtp_pass'] = "Nuevo1010";
        $config['charset'] = "utf-8";
        $config['mailtype'] = "html";
        $config['newline'] = "\r\n";

        $ci->email->initialize($config);

        $ci->email->from($this->gsatelite->get_parametro('CORREO_ADMIN'), $this->gsatelite->get_parametro('CORREO_ADMIN'));
        $list = array($email);
        $ci->email->to($list);
        $this->email->reply_to($this->gsatelite->get_parametro('CORREO_ADMIN'), '');
        $ci->email->subject('Requisición recibida');
        $ci->email->message('Estimado usuario usted tiene una requisición pendiente de despacho.');
        $ci->email->send();
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->cargar_registros('bod_bodega', 'bod_estado', 1);
            $data['titulo_personal'] = 'CREAR REQUISICIONES DE INVENTARIO';
            $this->_cargarvista(null, $data);
        }
    }

    function crear_req() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['num_requi'] = $this->inventario_model->num_max_requi();
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->get_bodegas_usuario();
            $data['titulo_personal'] = 'Crear requisiciones de inventario';
            $this->_cargarvista(null, $data);
        }
    }

    function editar_requisicion($id_req = NULL) {
        satelite_validar();
        if ($_POST) {
            //die(var_dump($_POST));
            $id_req = $this->input->post('id_req');
            $usuario = $this->tank_auth->get_user_id();
            $bodega = $_POST['bodega'];
            $fecha = $_POST['fecha'];
            $empleadosxbodega = $this->db->join('users', 'id=uxb_id_usu')->where('uxb_id_bod', $bodega)->get('uxb_usuarioxbodega')->result_array();
            $descripcion = $_POST['descripcion_req'];

            $actualizar_requisicion = array(
                'rxi_id_user' => $usuario,
                'rxi_fecha' => date('Y-m-d', strtotime($fecha)),
                'rxi_id_bod' => $bodega,
                'rxi_descripcion' => $descripcion,
                'rxi_documento' => $this->input->post('documento'),
                'rxi_estado' => 1,
                'rxi_tipo' => 1,
                'rxi_usu_mod' => $this->tank_auth->get_user_id(),
                'rxi_fecha_mod' => date('Y-m-d h:i:s')
            );

            $req_actualizada = $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $actualizar_requisicion, array('rxi_id' => $id_req));

            if ($req_actualizada == 1) {
                $detalle_remover = $this->gsatelite->borrado_general('dri_detalle_requisicion_inventario', array('dri_id_rxi' => $id_req));
            }

            if ($detalle_remover > 0) {
                $productos = $_POST['productos'];
                $cantidades = $_POST['cantidad'];

                foreach ($productos as $key => $id_prod) {
                    $id_cant = $cantidades[$key];

                    $detalle_req = array(
                        'dri_id_rxi' => $id_req,
                        'dri_id_art' => $id_prod,
                        'dri_cantidad' => convertirFloat($id_cant)
                    );

                    $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos", 'texto_alerta' => "El registro se actualizó correctamente");
                $this->session->set_flashdata($alerta);

                foreach ($empleadosxbodega as $key => $value) {
                    $this->send_email($value['email']);
                }

                redirect('/inventario/requisiciones/historial_req');
            }
        } else {
            $bodega = $_POST['bodega'];
            $data['bodega'] = $bodega;
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['requisicion'] = $this->inventario_model->editar_requisicion($id_req);
            $data['req_detalle'] = $this->inventario_model->requisicion_detalle($id_req);
            $data['existencias'] = $this->inventario_model->obt_cant_actual_existente();
            $data['bodegas'] = $this->gsatelite->get_dropdown('bod_bodega', '{bod_ubicacion}-{bod_nombre}', '', array('bod_estado' => '1'), $data['requisicion'][0]['bod_id'], '', 'bod_id', true);
            $data['id_req'] = $id_req;
            $data['html'] = $this->load->view('inventario/requisiciones/requisicion_tabla', $data, true);
            //die(print_r($data['html']));
            $data['titulo_personal'] = 'Editar Requisición';
            $this->_cargarvista(null, $data);
        }
    }

    function historial_req() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $user = $this->tank_auth->get_user_id();
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->get_bodegas_usuario();
            $data['solicitudes'] = $this->inventario_model->historial_solicitudes($user);
            $data['pendientes'] = $this->inventario_model->historial_solicitudes2($user);
            $data['anuladas'] = $this->inventario_model->solicitudes_rechazadas($user);
            //var_dump($this->db->last_query());exit();
            // Nuevos datos
            //    $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}','', null, null, '', 'bod_id', true);
            //    $data["select_rxi_id_bod"] = str_replace('<option value="0">Seleccione</option>', '',$select);

            $data['titulo_personal'] = 'Historial de requisiciones';
            $this->_cargarvista(null, $data);
        }
    }

    function filtro_requisicion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // All your code here.
            if ($_POST) {
                //die(print_r($_POST));

                $filtro = $this->input->post('filtro');
                $valor = $this->input->post('valor');
                $tipo_req = $this->input->post('tipo_req'); // 1= Despachada, 2= Pendientes, 3=Anulada
                $user = $this->tank_auth->get_user_id();

                $where = null;
                if ($filtro == 'rxi_fecha') {
                    $f = explode('#', $valor);
                    $where = array('date_format(' . $filtro . ',"%Y-%m-%d") >=' => date('Y-m-d', strtotime($f[0])), 'date_format(' . $filtro . ',"%Y-%m-%d") <=' => date('Y-m-d', strtotime($f[1])));
                } else {
                    $where = array("$filtro" => trim($valor));
                }

                // Obtener Solicitudes
                $html = '';
                if ($tipo_req == 1) {
                    $data['solicitudes'] = $this->inventario_model->historial_solicitudes($user, $where);
                    //  die(print_r($this->db->last_query()));
                    $html = $this->load->view('inventario/requisiciones/requisiciones_despachadas', $data, true);
                } else
                if ($tipo_req == 2) {
                    $data['pendientes'] = $this->inventario_model->historial_solicitudes2($user, $where);
                    $html = $this->load->view('inventario/requisiciones/requisiciones_pendientes', $data, true);
                } else {
                    $data['anuladas'] = $this->inventario_model->solicitudes_rechazadas($user, $where);
                    $html = $this->load->view('inventario/requisiciones/requisiciones_anuladas', $data, true);
                }

                // die(print_r($this->db->last_query()));   
                echo json_encode(array('resultado' => $html));
            }
        }
    }

    function autorizacion_requisicion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $user = $this->tank_auth->get_user_id();
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->cargar_registros('bod_bodega', 'bod_estado', 1);
            $data['solicitudes'] = $this->inventario_model->historial_solicitudes($user);
            $data['pendientes'] = $this->inventario_model->historial_solicitudes3($user);
            $data['titulo_personal'] = 'Requisiciones pendientes de autorización';
            //var_dump($data); die();
            $this->_cargarvista(null, $data);
        }
    }

    function autorizar_req($rxi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->db->where('rxi_id', $rxi_id);
            $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2, 'rxi_usu_mod' => $this->tank_auth->get_user_id(), 'rxi_fecha_mod' => date('Y-m-d H:i:s')));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos autorizada", 'texto_alerta' => "Ahora usted podrá ver la requisición en la pantalla de salida de artículos");

            $this->session->set_flashdata($alerta);
            redirect('inventario/requisiciones/autorizacion_requisicion');
        }
    }

    function mi_historial() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->cargar_registros('bod_bodega', 'bod_estado', 1);
            $data['solicitudes'] = $this->inventario_model->historial_solicitudes($this->tank_auth->get_user_id());
            $data['pendientes'] = $this->inventario_model->historial_solicitudes2($this->tank_auth->get_user_id());
            $data['titulo_personal'] = 'HISTORIAL DE REQUISICIONES';
            $this->_cargarvista(null, $data);
        }
    }

    function historial_show_detalle($id = null, $estado = null) {
        satelite_validar();

        $id_req_show = $id;
        $id_req = $id;
        $pendientes = 0;
        $anuladas = 0;
        if ($estado == 1) {
            $pendientes = 1;
        } else
        if ($estado == 2) {
            $anuladas = 1;
        }
        $data['id_req_show'] = $id;
        $data['pendientes'] = $pendientes;
        $data['anuladas'] = $anuladas;
        $data['detail'] = $this->inventario_model->cargar_req_detail($id_req_show);
        $data['query'] = $this->inventario_model->productos_requisicion_rxi_new_1($id_req);
        //    $detail = $this->inventario_model->cargar_req_detail($id_req_show);
        //    print_r($detail);
        $html = $this->load->view('inventario/requisiciones/detalle_requisicion', $data, true);
        echo $html;
    }

    public function anular_requisicion($tipo, $id_req_show) {
        if ($tipo == 1) {
            $observacion = $this->input->post('justificar_anulacion');
            //    echo $observacion; die();
            $this->inventario_model->anular_requisicion($id_req_show, $observacion);
        } elseif ($tipo == 2) {
            $observacion = $this->input->post('justificar_anulacion');
            //     echo $observacion; die();
            $this->inventario_model->marcar_entrega($id_req_show, $observacion);
            //     print_r($this->db->last_query());
            //     die();
        }
        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización de estado", 'texto_alerta' => "Se modificó el estado de la requisición exitosamente");

        $this->session->set_flashdata($alerta);
        redirect('inventario/requisiciones/historial_req');
    }

    function get_bodegas() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';

        //La categoria seleccionada en el proceso AJAX JSON
        $bodegas = $this->inventario_model->cargar_todo('bod_bodega');

        foreach ($bodegas as $fila) {
            $var .= "<option value='" . $fila['bod_id'] . "'>" . $fila['bod_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_categorias() {
        $option = "";
        $var = '<option>Seleccione una opción</option>';
        $bodega = $this->input->post('bodega_sel');
        $categorias = $this->inventario_model->get_categorias($bodega);

        foreach ($categorias as $key) {
            $var .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';

        //La categoria seleccionada en el proceso AJAX JSON
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->cargar_todo('art_articulo', array('art_id_tia' => $categoria));

        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "'>" . $fila['art_nombre'] . "</option>";
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos_catxbodega() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');

        $articulos = $this->inventario_model->get_productos_bodega_cantidad_salida($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_codigo'] . "--" . $fila['art_nombre'] . ' (' . $fila['sar_cant_actual'] . ')' . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos_catxbodega2() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->get_productos_bodega_cantidad_salida($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_nombre'] . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos_catxbodega_kardex() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->get_productos_bodega_cantidad_salida2($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_nombre'] . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function registrar_requisicion() {
        if ($_POST) { //Si se ha enviado valores de solicitud
            var_dump($_POST);
            die();

            $post_array = $_POST;

            $id_detalle = 0;
            $usuario = $this->tank_auth->get_user_id();
            $slcBodega = $post_array['slcBodega'];
            //$fecha = date('Ymd h:i:s'); //Temporalmente deshabilitado mientras ingresan requisiciones
            $fecha = $post_array['fecha'];
            $empleadosxbodega = $this->db->join('users', 'id=uxb_id_usu')->where('uxb_id_bod', $slcBodega)->get('uxb_usuarioxbodega')->result_array();

            $txtDescripcion = $post_array['txtDescripcion'];

            $ingresar_requisicion = array(
                'rxi_id_user' => $usuario,
                'rxi_fecha' => date('Y-m-d', strtotime($fecha)),
                'rxi_id_bod' => $slcBodega,
                'rxi_descripcion' => $txtDescripcion,
                'rxi_documento' => $this->input->post('documento'),
                'rxi_estado' => 1,
                'rxi_tipo' => 1,
                'rxi_usu_mod' => $this->tank_auth->get_user_id(),
                'rxi_fecha_mod' => date('Y-m-d h:i:s')
            );

            $id_req = $this->gsatelite->ingresar('rxi_requisicion_inventario', $ingresar_requisicion);

            $productos = $post_array['productos'];
            $cantidades = $post_array['cantidad'];

            foreach ($productos as $key => $id_prod) {
                $id_cant = $cantidades[$key];

                $detalle_req = array(
                    'dri_id_rxi' => $id_req,
                    'dri_id_art' => $id_prod,
                    'dri_cantidad' => convertirFloat($id_cant)
                );

                $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
            }

            //************* Autorizar requisición *******************************************/ 
            if ($this->gsatelite->get_parametro('INV_AUTORIZAR_REQUISION') == 1) {
                $this->db->where('rxi_id', $id_req);
                $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2, 'rxi_usu_mod' => $this->tank_auth->get_user_id(), 'rxi_fecha_mod' => date('Y-m-d H:i:s')));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos autorizada", 'texto_alerta' => "Ahora usted podrá ver la requisición en la pantalla de salida de artículos");
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos", 'texto_alerta' => "El registro se guardó correctamente");
            }
            //*******************************************************************************/
            $this->session->set_flashdata($alerta);

            foreach ($empleadosxbodega as $key => $value) {
                $this->send_email($value['email']);
            }


            redirect('/inventario/requisiciones/crear_req');
        }
    }

    function obtener_bodegas_articulos() {
        $id_articulo = $this->input->post('id_articulo');
        $id_solicitud = $this->input->post('id_solicitud');
        $cantidad_articulos = $this->inventario_model->get_cantidad_articulos_solicitud($id_articulo, $id_solicitud);
        $bodegas = $this->inventario_model->get_bodegas_articulos($id_articulo);
        $var = '<option value=""> Seleccione una opción </option>';
        foreach ($bodegas as $mostrar_bodegas) {
            $var .= '<option value = "' . $mostrar_bodegas['bod_id'] . '">' . $mostrar_bodegas['bod_nombre'] . '</option>';
        }

        $arreglo = array(
            "drop" => $var,
            "cantidad" => $cantidad_articulos[0]['dri_cantidad'],
        );
        echo json_encode($arreglo);
    }

    function get_productos_catxbodega_entrada() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->get_productos_bodega_cantidad_entrada($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_nombre'] . ' (' . $fila['sar_cant_actual'] . ')' . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_tipo_articulos() {
        $option = "";
        $var = '<option>Seleccione una opción</option>';
        $bodega = $this->input->post('bodega');
        $categorias = $this->inventario_model->get_categorias($bodega);

        foreach ($categorias as $key) {
            $var .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_tipo_articulos_medicina() {
        $option = "";
        $var = '<option>Seleccione una opcion</option>';
        $bodega = $this->input->post('bodega');
        $categorias = $this->inventario_model->get_articulos_medicina($bodega);

        foreach ($categorias as $key) {
            $var .= "<option value='" . $key['art_id'] . "'>" . $key['art_nombre'] . ' (' . $key['sar_cant_actual'] . ')' . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function modificar_cantidad() {
        $id_detalle = $this->input->get('identificador');
        $id_solicitud = $this->input->get('solicitud');

        $data['detalle'] = $id_detalle;
        $data['solicitud'] = $id_solicitud;

        $this->_cargarvista(null, $data);
    }

    function realizar_modificacion() {
        $bandera = false;
        $cantidad = $this->input->post('cantidad');
        $detalle = $this->input->post('detalle');
        $solicitud = $this->input->post('solicitud');


        $actualizar_cantidad_detalle = array('dri_cantidad' => convertirFloat($cantidad));

        $indicador = $this->gsatelite->actualizar('dri_detalle_requisicion_inventario', $actualizar_cantidad_detalle, 'dri_id', $detalle);

        if ($indicador != "") {
            $bandera = true;
        }

        echo json_encode($bandera);
    }

    function rechazar_solicitud(){
        $solicitud = $this->input->post('id_solicitud');
        $bandera = true;
        $eliminar_solicitud = array('rxi_estado' => 2);

        $indicador = $this->gsatelite->actualizar('rxi_requisicion_inventario', $eliminar_solicitud, 'rxi_id', $solicitud);

        if ($indicador != "") {
            $bandera = false;
        }

        echo json_encode($bandera);
    }

    function imprimir_boleta() {
        $data['id_req_show'] = $this->input->get('identificador');
        $data['detail'] = $this->inventario_model->cargar_req_detail($data['id_req_show']);
        //print_r($this->db->last_query());exit();
        $data['query'] = $this->inventario_model->productos_requisicion_rxi_new_1($data['id_req_show']);
        // die(print_r($this->db->last_query()));
        $data['pend'] = $this->input->get('pend');
        /* print_r($data['detail']['rxi_id_user']);
          exit(); */
        $data['user_info'] = $this->inventario_model->cargar_info_user($data['detail']['rxi_id_user']);




        $this->load->library('PDF');
        $this->load->library('EnLetras');

        $data['letras_solicitado'] = array();
        $data['letras_despachado'] = array();

        //print_r($this->enletras->ValorEnLetras(10124.65,""));//999999999 Limite de clase
        //exit();

        foreach ($data['query'] as $key => $valor) {
            $data['letras_solicitado'] = array_merge($data['letras_solicitado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad'], "")));

            if (isset($data['pend']) && $data['pend'] != '') {
                $data['letras_despachado'] = array_merge($data['letras_despachado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad_despacho'], "")));
            }
        }
        $aplica_estilos = ($this->gsatelite->get_parametro('SYS_EMPRESA') != 'CUSCATANCINGO') ? 1 : 0;
        //$aplica_estilos= ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA')!='4') ? 1 : 0 ;
        //$aplica_estilos= 0;
        $html = $this->load->view('inventario/requisiciones/generar_pdf', $data, true);
        $reporte = $this->pdf->reportePDF2($html, $aplica_estilos);
        /*    header("Content-Type: application/vnd.ms-excel");
          header("Expires: 0");
          header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
          header("content-disposition: attachment;filename=jujuju.xls");
          echo $html; */
    }

    function imprimir_requi_despa() {
        $data['id_req_show'] = $this->input->get('identificador');
        $data['detail'] = $this->inventario_model->cargar_req_detail($data['id_req_show']);
        //print_r($this->db->last_query());exit();
        $data['query'] = $this->inventario_model->productos_requisicion_rxi_new_1($data['id_req_show']);
        $data['pend'] = $this->input->get('pend');
        /* print_r($data['detail']['rxi_id_user']);
          exit(); */
        $data['user_info'] = $this->inventario_model->cargar_info_user($data['detail']['rxi_id_user']);




        $this->load->library('PDF');
        $this->load->library('EnLetras');

        $data['letras_solicitado'] = array();
        $data['letras_despachado'] = array();

        //print_r($this->enletras->ValorEnLetras(10124.65,""));//999999999 Limite de clase
        //exit();

        foreach ($data['query'] as $key => $valor) {
            $data['letras_solicitado'] = array_merge($data['letras_solicitado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad'], "")));

            if (isset($data['pend']) && $data['pend'] != '') {
                $data['letras_despachado'] = array_merge($data['letras_despachado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad_despacho'], "")));
            }
        }
        $aplica_estilos = ($this->gsatelite->get_parametro('SYS_EMPRESA') != 'CUSCATANCINGO') ? 1 : 0;
        //$aplica_estilos= ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA')!='4') ? 1 : 0 ;
        //$aplica_estilos= 0;
        // $html = $this->load->view('inventario/requisiciones/generar_pdf',$data,true);


        $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename'] = $filename;
        header("Content-Type: application/vnd.ms-excel");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("content-disposition: attachment;filename=" . $filename . ".xls");
        $html = $this->load->view('inventario/reportes/reporte_requicisiones_despachadas', $data, true);
        echo $html;
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}
