    <?php if (!defined('BASEPATH')) exit('No direct script access allowed');

    class Reportes extends CI_Controller
    {
        function __construct()
        {
            parent::__construct();
            $this->load->model('inventario_model');
            $this->load->model('gsatelite');
            $this->load->library('grocery_CRUD');
            $this->load->library('pdf');
            $this->load->library('excel/excel_reader.php');
        }

        function index()
        {
          $data['solicitudes'] = $this->inventario_model->consulta_general('tra_translado');
          $data['titulo_personal']='Traslado entre bodegas';
          $this->_cargarvista(null,$data);
      }

      public function caracteristicasxarticulo()
      {
          $data['articulos']=$this->db->select()
                          ->from('cxu_caracxarticulo')
                          ->join('art_articulo','art_id=cxu_id_art')
                          ->group_by('cxu_id_art')
                          ->get()->result_array();
                          //print_r($data);exit();
            $data['titulo_personal']="Características por artículo";
        $this->_cargarvista($data);
      }

      public function imprimir_categorias()
      {
        $data['articulos']=$this->db->select()
                          ->from('cxu_caracxarticulo')
                          ->join('art_articulo','art_id=cxu_id_art')
                          ->group_by('cxu_id_art')
                          ->get()->result_array();
            $html  = $this->load->view('reporte/header', array('titulo' => 'Caracteristicas de artículos'), true);

        $html.=$this->load->view('inventario/reportes/caracteristicas_print.php', $data,true);
        //print_r($html);exit();
        $reporte=$this->pdf->reportePDF2($html);
    }

      function generar_boleta()
      {
       $id_solicitud = $this->input->get('identificador');
       $obtener_movimiento_salida = $this->inventario_model->consulta_condicion_resultado('tra_translado','tra_id',$id_solicitud);
       $id_movimiento_salida = $obtener_movimiento_salida[0]['tra_id_moi_sal'];
       $id_movimiento_entrada = $obtener_movimiento_salida[0]['tra_id_moi_ent'];



       $campos_pdf = "dee_cantidad, dee_precio,art_nombre";
       $join_pdf   = "dee_detalle_mov,sar_saldo_articulo.sar_id = dee_detalle_mov.dee_id_sar/art_articulo,art_articulo.art_id = sar_saldo_articulo.sar_id_art";
       $tabla = "sar_saldo_articulo";
       $campo_condicion = "dee_detalle_mov.dee_id_moi";
       $data['detalle'] = $this->inventario_model->consulta_ejecutando_join($tabla,$campos_pdf,$join_pdf,$campo_condicion,$id_movimiento_salida);
       $bodega_entrada= $this->inventario_model->bodega_entrada($id_movimiento_entrada);
       $bodega_salida= $this->inventario_model->bodega_salida($id_movimiento_salida);
       $data['cabezera']= '<table><tr><td><span style="font-weight:bold;font-size: 1.em;">BODEGA DE PROCEDENCIA:</span><span>'.$bodega_salida[0]['bod_nombre'].'</span>
       <span style="font-weight:bold;font-size: 1.em;">BODEGA DESTINO:</span><span>'.$bodega_entrada[0]['bod_nombre'].'</span><br>
       <span style="font-weight:bold;font-size: 1.em;">FECHA DE MOVIMIENTO:</span><span>'.date('d/m/Y',strtotime($bodega_entrada[0]['moi_fecha_mov'])).'</span><br></td></tr></table>';    
       $this->pdf->reportePDF('inventario/boleta_traslado/generar_pdf', $data, 'Traslado');


    }

        function inventario_departamento()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {		
                $data["titulo_personal"] = "INVENTARIO DEPARTAMENTO";
                $data['bodega']=$this->inventario_model->usuarioxbodega();
                $data['furgones']=$this->inventario_model->obtener_furgones();	
                $this->_cargarvista(null,$data);

            }
        }

        public function inventario_requisiciones()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data['saldos']=$this->inventario_model->get_detalles_rxixbodega();
                $data['titulo_personal']="Reporte de requisiciones por bodega";
                $this->_cargarvista($data);
            }
        }

        public function ver_cantxbodega($id_art)
        {
            $data['bodegas']=$this->inventario_model->cantidad_requisicionesxbodega($id_art);
            $this->load->view('inventario/reportes/ver_cantxbodega',$data);
        }



        function inventario_saldo_cero()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data['saldos']=$this->inventario_model->saldo_cero();

                $data["titulo_personal"] = "REPORTE DE SALDO CERO";
                $this->_cargarvista(null,$data);
            }
        }

        function reporte_saldo_cero($tipo=1)
        {
            //$tipo=1 (excel), $tipo=2 (pdf)
            $data=$this->inventario_model->saldo_cero();
            $rows="<b>REPORTES DE SALDOS A CERO</b>";
            if($data){

                $cadena='<table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #C0C0C0;">';
                $cadena.='<th style="text-align:center; font-weight:bold;">Código</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Cantidad actual</th>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<th style="text-align:center; font-weight:bold;">Último contenedor ingresado</th>';
            }
                $cadena.='<th style="text-align:center; font-weight:bold;">Primera feha de salida</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Última feha de salida</th>';
                $cadena.='</tr>';
                foreach ( $data as $sld ) {
                    $cadena.='<tr >';
                    $cadena.='<td style="text-align:center;">'.$sld['art_codigo'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$sld['art_nombre'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$sld['cant_actual'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<td style="text-align:center;">'.$sld['ultimo_contenedor'].'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.date('d/m/Y', strtotime($sld['primer_salida'])).'</td>';
                    $cadena.='<td style="text-align:center;">'. date('d/m/Y', strtotime($sld['ultima_salida'])).'</td>';
                    $cadena.='</tr>';
                }
                $cadena.='</table>';
            }
            else{
                $cadena='';
                $cadena.='<tr>';
                $cadena.='<td>0</td>';
                $cadena.='<td>Cero Registros Encontrados</td>';
                $cadena.='<td class="center"></td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td></td>';
            }
                $cadena.='<td></td>';
                $cadena.='<td></td>';
                $cadena.='</tr>';
                $cadena.='<tr>';
            }
            //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            //Obtener datos y construir secciones del reporte

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            if($tipo==1){
                $this->load->view('inventario/reportes/reporte_furgon.php', $data);
            }
            else if($tipo==2){
                $this->pdf->reportePDF('inventario/reportes/reporte_saldo_cero_pdf.php', $data, 'Saldo Cero');
            }

        }

        function reporte_requisicones($tipo)
        {
            $data= $this->inventario_model->get_detalles_rxixbodega();
            if ($data){
                $rows='REPORTE DE CANTIDADES SOLICITADAS POR BODEGA';
                $cadena='<table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #C0C0C0;">';
                $cadena.='<th style="text-align:center; font-weight:bold;">Producto</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Cantidad actual</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Cantidad solicitada</th>';
                $cadena.='</tr>';
                foreach ($data as $key) {
                    $cadena.='<tr style="background-color: yellow;">';
                    $cadena.='<td>'.$key['productos'].'</td>';
                    $cadena.='<td>'.$key['nombre'].'</td>';
                    $cadena.='<td>'.number_format($key['cant_actual'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td>'.number_format($key['cantidad'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='</tr>';
                    $data_bodega=$this->inventario_model->cantidad_requisicionesxbodega($key['art_id']);
                    $total=0;
                    foreach ($data_bodega as $bod) {
                        $cadena.='<tr >';
                        $cadena.='<td><b>'.$bod['sucursal'].'</b></td>';
                        $cadena.='<td>'.$bod['cantxbodega'].'</td>';
                        $cadena.='<td></td>';
                        $cadena.='<td></td>';
                        $cadena.='</tr>';
                        $total+=$bod['cantxbodega'];

                    }
                    $cadena.='<tr>';
                    $cadena.='<td>Total: </td>';
                    $cadena.='<td>'.number_format($total, $this->gsatelite->get_parametro('NUMERO_DECIMALES'), ".", ",").'</td>';
                    $cadena.='<td colspan="2"></td>';
                    $cadena.='</tr>';
                }
                $cadena.='</table>';	
            }

            //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            //Obtener datos y construir secciones del reporte

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            if($tipo==1){
                $this->load->view('inventario/reportes/reporte_furgon.php', $data);
            }
            else if($tipo==2){
                $this->pdf->reportePDF('inventario/reportes/reporte_saldo_cero_pdf.php', $data, 'requisiciones');
            }


        }

        function reporte_proveedor($tipo=1)
        {
            //$tipo=1 (excel), $tipo=2 (pdf)
            $entradas=0;
            $salidas=0;
            $saldo=0;
            $total=0;
            $proveedor=$_POST['proveedor'];
            $data=$this->inventario_model->consultaxproveedor($proveedor);
            $rows="REPORTES DE EXISTENCIAS";
            if($data){
                $cadena='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #C0C0C0;">';
                $cadena.='<th style="text-align:center; font-weight:bold;">Proveedor</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Línea</th>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<th style="text-align:center; font-weight:bold;">Contenedor</th>';
            }
                $cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Existencias</th>';
                $cadena.='</tr>';
                foreach ( $data as $sld ) {
                    $cadena.='<tr >';
                    $cadena.='<td style="text-align:center;">'.$sld['proveedor'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$sld['linea'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<td style="text-align:center;">'.$sld['contenedor'].'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.$sld['nombre'].'</td>';
                    $cadena.='<td style="text-align:center;">'.number_format($sld['Entradas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td>'.number_format($sld['Salidas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td>'.number_format($sld['Saldo'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='</tr>';
                    $entradas+=$sld['Entradas'];
                $salidas+=$sld['Salidas'];
                $saldo+=$sld['Saldo'];


                }
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=4;}else{ $col=3; }
                $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align:right;"><b>'.number_format($entradas,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align:right;"><b>'.number_format($salidas,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align:right;"><b>'.number_format($saldo,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td></tr>';
                $cadena.='</table>';
            }
            else{
                $cadena.='<tr>';
                $cadena.='<td>0</td>';
                $cadena.='<td>Cero Registros Encontrados</td>';
                $cadena.='<td class="center"></td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td></td>';
            }
                $cadena.='<td></td>';
                $cadena.='<td></td>';
                $cadena.='</tr>';
                $cadena.='</table>';
            }
            //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            //Obtener datos y construir secciones del reporte

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            if($tipo==1){
                $this->load->view('inventario/reportes/reporte_furgon.php', $data);
            }
            else if($tipo==2){
                $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data, 'Existencias');
            }

        }

            function reporte_proveedor_costos($tipo=1)
        {
            //$tipo=1 (excel), $tipo=2 (pdf)
            $entradas=0;
            $salidas=0;
            $saldo=0;
            $total=0;
            $proveedor=$_POST['proveedor'];
            $data=$this->inventario_model->consultaxproveedor($proveedor);
            $rows="REPORTES DE PROVEEDORES Y COSTOS";
            if($data){
                $cadena='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #C0C0C0;">';
                $cadena.='<th style="text-align:center; font-weight:bold;">Proveedor</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Línea</th>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<th style="text-align:center; font-weight:bold;">Contenedor</th>';
            }
                $cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Existencias</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Costos</th>';

                $cadena.='</tr>';
                foreach ( $data as $sld ) {
                    $cadena.='<tr >';
                    $cadena.='<td style="text-align:center;">'.$sld['proveedor'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$sld['linea'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<td style="text-align:center;">'.$sld['contenedor'].'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.$sld['nombre'].'</td>';
                    $cadena.='<td style="text-align:center;">'.number_format($sld['Entradas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td>'.number_format($sld['Salidas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td>'.number_format($sld['Saldo'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td>'.str_replace(',', '<br />', $sld['precios_costos']).'</td>';
                    $cadena.='</tr>';
                    $entradas+=$sld['Entradas'];
                $salidas+=$sld['Salidas'];
                $saldo+=$sld['Saldo'];


                }
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=4;}else{ $col=3; }
                $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align:right;"><b>'.number_format($entradas,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align:right;"><b>'.number_format($salidas,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align:right;"><b>'.number_format($saldo,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td>';
                $cadena.='<td></td></tr>';
                $cadena.='</table>';
            }
            else{
                $cadena.='<tr>';
                $cadena.='<td>0</td>';
                $cadena.='<td>Cero Registros Encontrados</td>';
                $cadena.='<td class="center"></td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td></td>';
            }
                $cadena.='<td></td>';
                $cadena.='<td></td>';
                $cadena.='<td></td>';
                $cadena.='</tr>';
                $cadena.='</table>';
            }
            //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            //Obtener datos y construir secciones del reporte

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            if($tipo==1){
                $this->load->view('inventario/reportes/reporte_furgon.php', $data);
            }
            else if($tipo==2){
                $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data, 'Proveedores y Costos');
            }

        }

        function reporte_existencia($tipo=1,$ylufa=null)
        {
            //print_r($ylufa);exit();
            //$tipo=1 (excel), $tipo=2 (pdf)
            $cantidad=0;
            $total=0;
            $data = ($ylufa==2) ? $this->inventario_model->get_existencias_ylufa() : $this->inventario_model->get_existencias();
            //print_r($this->db->last_query());exit();
            $rows="REPORTES DE EXISTENCIAS";
            if($data){
                $cadena='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" style="border:1px solid black;">';
                $cadena.='<tr style="background-color: #F0F0F0;">';
                if($ylufa !=2){
                    $cadena.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
                }else{
                  $cadena.='<th style="text-align:center; font-weight:bold;">Departamento</th>';  
                }
                
                $cadena.='<th style="text-align:center; font-weight:bold;">Línea</th>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<th style="text-align:center; font-weight:bold;">Contenedor</th>';
            }
                $cadena.='<th style="text-align:center; font-weight:bold;">Código</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Existencia</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Costo</th>';
                $cadena.='<th style="text-align:center; font-weight:bold;">Total</th>';
                $cadena.='</tr>';
                foreach ( $data as $sld ) {
                    $cadena.='<tr >';
                    if($ylufa !=2){
                    $cadena.='<td style="text-align:center;">'.$sld['bodega'].'</td>';
                }else{
                    $cadena.='<td style="text-align:center;">'.$sld['departamento'].'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.$sld['linea'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<td style="text-align:center;">'.$sld['contenedor'].'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.$sld['codigo'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$sld['nombre'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$sld['cantidad'].'</td>';
                    $cadena.='<td>'."$".number_format($sld['precio'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td>'."$".number_format($sld['total'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';

                    $cadena.='</tr>';
                    $cantidad+=(int)$sld['cantidad'];
                    $total+=(int)$sld['total'];

                }
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=5;}else{ $col=4; }
                $cadena.='<tr style="background-color: #C0C0C0;" ><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align: right;"><b>'.number_format($cantidad,2).'</b></td><td style="text-align: right;"></td><td style="text-align: right;"><b>$'.number_format($total,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td></tr>';
                $cadena.='</table>';
            }
            else{
                $cadena.='<tr>';
                $cadena.='<td>0</td>';
                $cadena.='<td>Cero Registros Encontrados</td>';
                $cadena.='<td class="center"></td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td></td>';
            }
                $cadena.='<td></td>';
                $cadena.='<td></td>';
                $cadena.='</tr>';
                $cadena.='</table>';
            }
            //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            //Obtener datos y construir secciones del reporte

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            if($tipo==1){
                $this->load->view('inventario/reportes/reporte_furgon.php', $data);
            }
            else if($tipo==2){
                $this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data, 'Existencias');
            }

        }

        function inventario_factura()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data["titulo_personal"]="INVENTARIO FACTURA";
                if($_POST)
                {
                    $doc=$this->input->post('documento');
                    $tipo=$this->input->post('tipo');
                    if($tipo==1)
                    {
                        $tipo="tip_entrada";
                    }
                    elseif($tipo==2)
                    {
                        $tipo="tip_salida";
                    }
                    $mois=$this->inventario_model->get_movimientos($doc);

                    $cadena="";

                    foreach ($mois as $key) {

                        $detalles=$this->inventario_model->get_movimientos_detalles($key['moi_id'],$tipo);

                        if(!empty($detalles)){
                            $cadena.='<tr><td colspan="8"><br />Fecha: '.$detalles[0]['fecha_mov'].'</td></tr>';
                            $cadena.='<tr><td colspan="8">Documento: '.$detalles[0]['documento'].'</td></tr>';
                            $cadena.='<tr><td colspan="8">Descripción: '.$detalles[0]['descripcion'].'</td></tr>';
                            //$cadena.='<tr><td colspan="6">Furgón: '.$detalles[0]['furgon'].'</td></tr>';
                            $cadena.='<tr><td colspan="8">Bodega: '.$detalles[0]['bodega'].'</td></tr>';
                            $cadena.='<tr><td colspan="8"></td></tr>';

                            $cadena.='<tr width="10%"><th>Código</th>';
                            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                            $cadena.='<th width="10%">Contenedor</th>';
                        }
                            $cadena.='<th width="40%">Artículo</th>';
                            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                            $cadena.='<th width="10%">Caja</th>';
                        }
                            $cadena.='<th width="10%">Cantidad</th>';
                            if($tipo=="tip_entrada"){ //Solo se mostraran en caso de ser entradas 
                            $cadena.='<th width="10%">Precio</th>';
                            $cadena.='<th width="10%">Sub-total</th>';
                            }
                            $cadena.='<th width="10%">Imagen</th>';
                            $cadena.='</tr>';

                            $sumatoria_subtotal=0;
                            $sumatoria_cantidad=0;

                            foreach ($detalles as $det) {
                                //$subT = number_format($det['cant_art']*$det['precio'],2);
                                $cadena.='<tr><td style="text-align:center;">'.$det['codigo'].'</td>';
                                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                                $cadena.='<td style="text-align:center;">'.$det['furgon'].'</td>';
                            }
                                $cadena.='<td style="text-align:center;">'.$det['nombre'].'</td>';
                                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){							
                                $cadena.='<td style="text-align:center;">'.'&nbsp;'.$det['caja'].'</td>';
                            }
                                $cadena.='<td style="text-align:center;">'.$det['cant_art'].'</td>';
                                if($tipo=="tip_entrada"){ //Solo se mostraran en caso de ser entradas 
                                $cadena.='<td style="text-align:right;" >'."$".number_format($det['precio'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                                $cadena.='<td style="text-align:right;" >'."$".number_format($det['cant_art']*$det['precio'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                                }
                                if(isset($det['foto'])){
                                $cadena.='<td><div class="controls center"><input type="checkbox"  name="'.$det['foto'].'" id="'.$det['foto'].'" class="ibuttonCheck nostyle" /></div></td></tr>';
                                }
                                else{
                                $cadena.='<td style="text-align:center;">No posee</td>';
                                }
                                $cadena.='</tr>';
                                $sumatoria_cantidad +=$det['cant_art'];
                                $sumatoria_subtotal +=$det['cant_art']*$det['precio'];
                            }
                            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=4;}else{ $col=2; } 
                            if($tipo=="tip_entrada"){ //Lleva precio y Subtotal
                                $cadena .='<tr><td colspan="'.$col.'" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>'. number_format($sumatoria_cantidad,$this->gsatelite->get_parametro('NUMERO_DECIMALES')) .'</td><td></td><td  style="text-align:right;" ><b>'."$". number_format($sumatoria_subtotal,$this->gsatelite->get_parametro('NUMERO_DECIMALES')) .'</b></td><td></td></tr>';
                            }else{
                                $cadena .='<tr><td colspan="'.$col.'" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>'. number_format($sumatoria_cantidad,$this->gsatelite->get_parametro('NUMERO_DECIMALES')) .'</b></td><td></td></tr>';
                            }
                        }



                    }

                    $arreglo=array('drop'=>$cadena);
                    echo json_encode($arreglo);



                }
                else{
                    $data['titulo_personal']="REPORTE POR  DOCUMENTO";
                    $this->_cargarvista(null,$data);
                }
            }
        }

        function reporte_factura($tipoR=1)
        {
            //$tipoR=1 (excel), $tipoR=2 (pdf)
            $doc=$_POST['doc'];
            $tipo=$_POST['tipo'];
            if($tipo==1)
            {
                $tipo="tip_entrada";
            }
            elseif($tipo==2)
            {
                $tipo="tip_salida";
            }
            $mois=$this->inventario_model->get_movimientos($doc);
            $cadena="";
            $rows="REPORTE DE DOCUMENTOS CON NÚMERO: ".$doc;
            foreach ($mois as $key) {

                $detalles=$this->inventario_model->get_movimientos_detalles($key['moi_id'],$tipo);
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=7;}else{ $col=4; }
                if(!empty($detalles)){
                    $cadena.='<table class="tabla" style="border:1px solid black;" width="100%">';
                    $cadena.='<tr><td colspan="'.$col.'"><br /><b>Fecha:</b> '.$detalles[0]['fecha_mov'].'</td></tr>';
                    $cadena.='<tr><td colspan="'.$col.'"><b>Documento: </b>'.$detalles[0]['documento'].'</td></tr>';
                    $cadena.='<tr><td colspan="'.$col.'"><b>Descripción: </b>'.$detalles[0]['descripcion'].'</td></tr>';
                    //$cadena.='<tr><td colspan="7">Contenedor: '.$detalles[0]['furgon'].'</td></tr>';
                    $cadena.='<tr><td colspan="'.$col.'"><b>Bodega: </b> '.$detalles[0]['bodega'].'</td></tr>';
                    $cadena.='<tr style="background-color: #C0C0C0;"><th>Código</th>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<th>Contenedor</th>';
                }
                    $cadena.='<th>Artículo</th>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<th>Caja</th>';
                    $cadena.='<th>Cantidad</th>';
                }
                    if($tipo=="tip_entrada"){
                    $cadena.='<th>Precio</th>';
                    $cadena.='<th>Sub-total</th>';
                    }
                    $cadena.='</tr>';	

                    $sumatoria_subtotal=0;
                    $sumatoria_cantidad=0;

                    foreach ($detalles as $det) {
                        $cadena.='<tr><td style="text-align:center;">'.$det['codigo'].'</td>';
                        if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){	
                        $cadena.='<td style="text-align:center;">'.$det['furgon'].'</td>';
                    }
                        $cadena.='<td style="text-align:center;">'.$det['nombre'].'</td>';
                        if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){					
                        $cadena.='<td style="text-align:center;"><span style="color:white;" >&nbsp;</span>'.'&nbsp;'.$det['caja'].'</td>';
                        $cadena.='<td style="text-align:center;">'.$det['cant_art'].'</td>';
                    }
                        if($tipo=="tip_entrada"){ //Solo se mostraran en caso de ser entradas 
                        $cadena.='<td style="text-align:right;">'."$".number_format($det['precio'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                        $cadena.='<td style="text-align:right;">'."$".number_format($det['cant_art']*$det['precio'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                        }
                        $cadena.='</tr>';
                        $sumatoria_subtotal += $det['cant_art']*$det['precio'];
                        $sumatoria_cantidad +=$det['cant_art'];
                    }

                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=4;}else{ $col=2; }
                    $cadena .='<tr><td></td></tr>';
                    if($tipo=="tip_entrada"){ //Lleva precio y Subtotal
                        $cadena .='<tr><td colspan="'.$col.'" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>'. number_format($sumatoria_cantidad,$this->gsatelite->get_parametro('NUMERO_DECIMALES')) .'</b></td><td  style="text-align:right;" ><b>'."$". number_format($sumatoria_subtotal,2) .'</b></td></tr>';
                    }else{
                        $cadena .='<tr><td colspan="'.$col.'" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>'. number_format($sumatoria_cantidad,$this->gsatelite->get_parametro('NUMERO_DECIMALES')) .'</b></td></tr>';
                    }
                    $cadena.='</table>';
                    //$cadena .='<tr><td colspan="5" style="text-align:right;" >Total</td><td  style="text-align:right;" ><b>'."$" . number_format($sumatoria_subtotal,2) .'</b></td></tr>';


                }



            }
                    //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            //Obtener datos y construir secciones del reporte

            $data['table_header']     = $rows;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;

            if($tipoR==1){
                $this->load->view('inventario/reportes/reporte_factura.php', $data);
            }
            else if($tipoR==2){
                $this->pdf->reportePDF('inventario/reportes/reporte_factura_pdf.php', $data, 'INVENTARIO FACTURA');
            }
        }

        function inventario_existencia()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data["titulo_personal"] ="REPORTE DE EXISTENCIAS";
                $data['detalle']=$this->inventario_model->get_existencias();
                $this->_cargarvista($data); 
            }
        }

        function inventario_existencia_ylufa()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data["titulo_personal"] ="REPORTE DE EXISTENCIAS";
                $data['detalle']=$this->inventario_model->get_existencias_ylufa();
                //print_r($this->db->last_query());exit();
                $this->_cargarvista($data);
            }
        }

        function inventario_proveedor()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data['proveedor']=$this->inventario_model->proveedor_con_mov();
                $data["titulo_personal"] ="REPORTE DE PROVEEDORES";
                //$data['detalle']=$this->inventario_model->consultaxproveedor();
                $this->_cargarvista($data);
            }
        }

        public function consultaxproveedor()
        {
            $proveedor= $this->input->post('proveedor');
            $rpt=$this->input->post('rpt');
            $datos=$this->inventario_model->consultaxproveedor($proveedor);
            $cadena="";
            foreach ($datos as $key => $sld) {
                $numero=explode(',', $sld['precios_costos']);
                $dos="";
                for ($i=0; $i < count($numero) ; $i++) { 
                    $dos.=number_format($numero[$i],$this->gsatelite->get_parametro('NUMERO_DECIMALES'))."<br>";
                }


                $cadena.="<tr><td>".$sld['proveedor']."</td>";
                $cadena.="<td>".$sld['linea']."</td>";
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.="<td>".$sld['furgon']."</td>";
            }
                $cadena.="<td>".$sld['nombre']."</td>";
                $cadena.="<td>".$sld['UM']."</td>";
                $cadena.="<td>".number_format($sld['Entradas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES'))."</td>";
                $cadena.="<td>".number_format($sld['Salidas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES'))."</td>";
                $cadena.="<td>".number_format($sld['Saldo'],$this->gsatelite->get_parametro('NUMERO_DECIMALES'))."</td>";
                if ($rpt=='costo') {
                    $cadena.="<td>". $dos."</td>";
                }
                if(isset($sld['art_foto'])){
                $cadena.="<td><div class='controls center'><input type='checkbox'  name='".$sld['art_foto']." id='".$sld['art_foto']."' class='ibuttonCheck nostyle' /></div></td>";
                }else{
                $cadena.="<td style='text-align:center;''>No posee</td>";	
                }
                $cadena.="</tr>";
            }

            $arreglo=array('drop'=>$cadena);
            echo json_encode($arreglo);
        }

        function inventario_proveedor_costos()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $data['proveedor']=$this->inventario_model->proveedor_con_mov();
                $data["titulo_personal"] ="REPORTE DE PROVEEDORES Y COSTOS";
                //$data['detalle']=$this->inventario_model->consultaxproveedor();
                $this->_cargarvista($data);
            }
        }

        function inventario_furgon()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {	
                $data['bodega']=$this->inventario_model->usuarioxbodega();
                $data["titulo_personal"] = "REPORTE POR  CONTENEDOR" ;
                $this->_cargarvista(null,$data);
            }
        }

        function inventario_prod_sin_mov()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {		
                $data['bodega']=$this->inventario_model->usuarioxbodega();
                $data['titulo_personal']="REPORTE DE PRODUCTOS SIN MOVIMIENTO";
                $this->_cargarvista(null,$data);
            }
        }

        function inventario_codigo()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {		
                $data["titulo_personal"] = "INVENTARIO CÓDIGO";
                $data['bodega']=$this->inventario_model->usuarioxbodega();
                $data['titulo_personal']="REPORTE POR CÓDIGO";
                $this->_cargarvista(null,$data);

            }
        }

        function categoria_departamento()
        {
            $padre=$this->input->post('departamento_sel');
            $categorias=$this->inventario_model->get_categorias_hijas($padre);
            $var = '<option value="">Seleccione una opción</option>';


            foreach($categorias as $key => $fila)
            {
                $var .= "<option value='". $fila['tia_id']."'>".$fila['tia_nombre']."</option>";
            }


            $arreglo = array( 
                "drop"=>$var,
                );

            echo json_encode($arreglo);
        }

        function cuerpo_busquedaxfurgon($informacion)
        {
            //  $ndecimales =  $this->gsatelite->get_parametro('NUMERO_DECIMALES');
             $ndecimales =  2;

            $entrada=0;
            $salida=0;
            $saldo=0;
            $cadena="";
            foreach ($informacion as $key) 
            {
                                //$cadena.='<tr><td>'.$key['bodega'].'</td>';
                $cadena.='<td style="text-align:left;">'.$key['codigo'].'</td>';
                $cadena.='<td style="text-align:left;">'.$key['nombre'].'</td>';
                $cadena.='<td style="text-align:left;">'.$key['caja'].'</td>';
                $cadena.='<td style="text-align:left;">'.$key['cantidad'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Entradas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Salidas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Saldo'],$ndecimales).'</td>';
                $entrada+=(int)$key['Entradas'];
                $salida+=(int)$key['Salidas'];
                $saldo+=(int)$key['Saldo'];
                if(isset($key['foto'])){
                    $cadena.='<td><div class="controls center"><input type="checkbox"  name="'.$key['foto'].'" id="'.$key['foto'].'" class="ibuttonCheck nostyle" /></div></td></tr>';
                }
                else{
                    $cadena.='<td style="text-align:center;">No posee</td></tr>';
                }
            }

            $cadena.='<tr><td colspan="5"><b>Total:</b></td><td style="text-align: right;"><b>'.number_format($entrada,$ndecimales).'</b></td><td style="text-align: right;"><b>'.number_format($salida,$ndecimales).'</b></td><td style="text-align: right;"><b>'.number_format($saldo,$ndecimales).'</b></td><td></td></tr>';

            return $cadena;

        }

        function busquedaxfurgon()
        {		


            $cabezera='<tr>';
            //$cadena.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Imagen</th>';
            $cabezera.='</tr>';

            $cabezera='<tr>';
            //$cadena.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Imagen</th>';
            $cabezera.='</tr>';

            /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            $furgon=$this->input->post('furgon');
            $codigo= $this->input->post('cod_art');
            //var_dump($this->input->post('categoria'));exit();
            //
            /*--------------------------------------------------------------------*/

            /* ------------- condiciones para la busqueda por codigo --------------*/

            $cod_art = ($codigo =="") ? null : $codigo ;

            /*--------------- Encontrar dependencias de ultima categoria ---------*/


             
            $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){

                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }

            $categorias_final=array_reverse($padre_del_padre);
             //print_r($categorias_final);exit();

            /*--------------------------------------------------------------------*/

           
            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != ""){   
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }   
                }

                //print_r($elementos);exit();

                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=11;}else{ $col=8; } 
                
                $ultimo_padre=end($elementos);
                //print_r($ultimo_padre);exit();
                $departamento_inf_tr="";
                $departamento_infe_tr="";
                $i=1;
                $cabeza=0;
                                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {


                        /*if($ids!=key($ultimo_padre)){

                            $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);

                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color:#F0F0F0;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                //$departamento_inf_tr.=$departamento_infe_tr;
                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxfurgon($tipo['tia_id'],$furgon,$bodega,$cod_art);

                                    //print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->cuerpo_busquedaxfurgon($informacion);
                                    }
                                }
                            }else {
                                $informacion=$this->inventario_model->consultaxfurgon($ids,$furgon,$bodega,$cod_art);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->cuerpo_busquedaxfurgon($informacion);
                                }
                            }       
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }

                //exit();


                $cadena.=$departamento_inf_tr;

                $arreglo = array( 
                    "drop"=>$cadena,
                    );

                echo json_encode($arreglo);
            }

        function cuerpo_busqueda_produc_sin_movimiento($informacion)
        {
            $entrada=0;
            $salida=0;
            $saldo=0;
            $cadena="";
            $mostrar=0;
            foreach ($informacion as $key) 
            {
                if($key['Salidas'] == 0){
                                //$cadena.='<tr><td>'.$key['bodega'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<tr><td style="text-align:center;">'.$key['furgon'].'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.$key['nombre'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$key['codigo'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<td style="text-align:center;">'.$key['caja'].'</td>';
                    $cadena.='<td style="text-align:center;">'.number_format($key['cantidad'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';
                    $cadena.='<td style="text-align:right;">'.number_format($key['Entradas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td style="text-align:right;">'.number_format($key['Salidas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                    $cadena.='<td style="text-align:right;">'.number_format($key['Saldo'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';


                    $entrada+=(int)$key['Entradas'];
                    $salida+=(int)$key['Salidas'];
                    $saldo+=(int)$key['Saldo'];
                    if(isset($key['foto'])){
                    $cadena.='<td><div class="controls center"><input type="checkbox"  name="'.$key['foto'].'" id="'.$key['foto'].'" class="ibuttonCheck nostyle" /></div></td>';
                    $cadena.='</tr>';
                }
                else{
                    $cadena.='<td style="text-align:center;">No posee</td>';
                    $cadena.='</tr>';
                }
                $mostrar++;
                }
            }
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=6;}else{ $col=3; }
            $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align: right;"><b>'.number_format($entrada,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align: right;"><b>'.number_format($salida,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align: right;"><b>'.number_format($saldo,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td></td></tr>';


            $datos=array('cadena'=>$cadena,'data'=>$mostrar);
            return $cadena;

        }

        function busqueda_produc_sin_movimiento()
        {		
            $cadena="";
            $cabezera='<tr>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th style="text-align:center; font-weight:bold;">Contenedor</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Imagen</th>';
            $cabezera.='</tr>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=10;}else{ $col=7; } 

            /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            /*--------------------------------------------------------------------*/

            /*--------------- Encontrar dependencias de ultima categoria ---------*/



            $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }
            $categorias_final=array_reverse($padre_del_padre);

            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }	
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=11;}else{ $col=8; } 
                $ultimo_padre=end($elementos);

                $departamento_inf_tr="";
                $departamento_infe_tr="";
                $i=1;
                $cabeza=0;
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {

                       // print_r($_POST);exit();
                        /*if($ids!=key($ultimo_padre)){

                            $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);

                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color:gray;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                //$departamento_inf_tr.=$departamento_infe_tr;
                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxdep($tipo['tia_id'],$bodega,'',3);
                                    //  print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->cuerpo_busqueda_produc_sin_movimiento($informacion);
                                    }
                                }
                            }else {
                                $informacion=$this->inventario_model->consultaxdep($ids,$bodega,'',3);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->cuerpo_busqueda_produc_sin_movimiento($informacion);
                                }
                            }       
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }


        $cadena.=$departamento_inf_tr;



            $arreglo = array( 
                "drop"=>$cadena,
                );

            echo json_encode($arreglo);
        }


        function ver_imagen($foto=null)
        {
            if(!empty($foto)){
                $data['imagen']="<img src=".base_url('/assets/uploads/images/'.$foto).">";
            }
            else
            {
                $data['imagen']="El artículo no posee fotografia";
            }
            $this->load->view('inventario/reportes/ver_imagen',$data);
        }

        function cuerpo_busquedaxdepartamento($informacion)
        {
            //  $ndecimales =  $this->gsatelite->get_parametro('NUMERO_DECIMALES');
             $ndecimales =  2;

            $entrada=0;
            $salida=0;
            $saldo=0;
            $cadena="";
            foreach ($informacion as $key) 
            {
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<tr class="odd gradeX"><td style="text-align:center;">'.$key['furgon'].'</td>';
            }
                $cadena.='<td style="text-align:left;">'.$key['codigo'].'</td>';
                $cadena.='<td style="text-align:left;">'.$key['nombre'].'</td>';
                $cadena.='<td><a class="linker btn" href="'.base_url().'inventario/reportes/ver_precios/'.$key['id_sar'].'">Ver precios</a></td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:left;">'.$key['caja'].'</td>';
            }
                $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:left;">'.$key['cantidad'].'</td>';
            }
                $cadena.='<td style="text-align:right;">'.number_format($key['Entradas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Salidas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Saldo'], $ndecimales).'</td>';
                $entrada+=(int)$key['Entradas'];
                $salida+=(int)$key['Salidas'];
                $saldo+=(int)$key['Saldo'];
                if(isset($key['foto'])){
                    $cadena.='<td><div class="controls center"><input type="checkbox"  name="'.$key['foto'].'" id="'.$key['foto'].'" class="ibuttonCheck nostyle" /></div></td></tr>';
                }
                else{
                    $cadena.='<td style="text-align:center;">No posee</td>';
                    $cadena.='</tr>';
                }
            }
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=7;}else{ $col=4; } 

            $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align: right;"><b>'.number_format($entrada,$ndecimales).'</b></td><td style="text-align: right;"><b>'.number_format($salida,$ndecimales).'</b></td><td style="text-align: right;"><b>'.number_format($saldo,$ndecimales).'</b></td><td></td></tr>';

            return $cadena;

        }


        function busquedaxdepartamento()
        {
            $cabezera='<tr>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cabezera.='<th>Contenedor</th>';
            }
            $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Precios</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
            }
            $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
            }
            $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Imagen</th>';
            $cabezera.='</tr>';

            $furgones=$this->input->post('furgon');

            if($furgones != "")
            {
                $cadena_in="";
                foreach ($furgones as $key =>$value ) {

                    $cadena_in.=$value.',';

                }

                $furgon=substr($cadena_in,0,-1);
            }
            else
            {
                $furgon="";
            }

            /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            $codigo= $this->input->post('cod_art');
            /*--------------------------------------------------------------------*/

            /* ------------- condiciones para la busqueda por codigo --------------*/

            $cod_art = ($codigo =="") ? null : $codigo ;
            /*--------------------------------------------------------------------*/

            /*--------------- Encontrar dependencias de ultima categoria ---------*/



            $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }
            $categorias_final=array_reverse($padre_del_padre);

            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }   
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=11;}else{ $col=8; } 
                $ultimo_padre=end($elementos);
                $departamento_inf_tr="";
                $departamento_infe_tr="";
                $i=1;
                $cabeza=0;
                $ids_cat_consultados = array();
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {


                        /*if($ids!=key($ultimo_padre)){

                            $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/
                            
                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);
                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color:#F0F0F0;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                //$departamento_inf_tr.=$departamento_infe_tr;

                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxdep($tipo['tia_id'],$bodega,$furgon,$cod_art);
                                    $ids_cat_consultados[] = $tipo['tia_id'];
                                    //print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->cuerpo_busquedaxdepartamento($informacion);
                                    } 
                                }
                            }else {
                                //preguntar si los datos fueron ya consultados en el for de arriba.
                                if(!in_array($ids, $ids_cat_consultados)) {
                                
                                $informacion=$this->inventario_model->consultaxdep($ids,$bodega,$furgon,$cod_art);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría NO '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->cuerpo_busquedaxdepartamento($informacion);
                                }

                                }

                            }		
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }


        $cadena.=$departamento_inf_tr;





        $arreglo = array( 
            "drop"=>$cadena,
            );

        echo json_encode($arreglo);
        }

        function cuerpo_busquedaxcodigo($informacion)
        {
            $entrada=0;
            $salida=0;
            $saldo=0;
            $cadena="";
            foreach ($informacion as $key) 
            {
                $cadena.='<tr><td style="text-align:center;">'.$key['bodega'].'</td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:center;">'.$key['furgon'].'</td>';
            }
                $cadena.='<td style="text-align:center;">'.$key['codigo'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['nombre'].'</td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:center;">'.$key['caja'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['cantidad'].'</td>';
            }
                $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Entradas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Salidas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Saldo'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $entrada+=(int)$key['Entradas'];
                $salida+=(int)$key['Salidas'];
                $saldo+=(int)$key['Saldo'];
                $cadena.='<td><a class="linker btn" href="'.base_url().'inventario/reportes/ver_precios/'.$key['id_sar'].'">Ver precios</a></td>';
                if(isset($key['foto'])){
                    $cadena.='<td><div class="controls center"><input type="checkbox"  name="'.$key['foto'].'" id="'.$key['foto'].'" class="ibuttonCheck nostyle" /></div></td></tr>';
                }
                else{
                    $cadena.='<td style="text-align:center;">No posee</td>';
                    $cadena.='</tr>';
                }
            }
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=7;}else{ $col=4; }
            $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align: right;"><b>'.number_format($entrada,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align: right;"><b>'.number_format($salida,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align: right;"><b>'.number_format($saldo,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td></td><td></td></tr>';
            return $cadena;

        }

        function busquedaxcodigo()
        {
            $cadena="";
            $cabezera='<tr>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th>Contenedor</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Precios Venta</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Imagen</th>';
            $cabezera.='</tr>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=12;}else{ $col=9; } 


            /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            /*--------------------------------------------------------------------*/

            /*--------------- Encontrar dependencias de ultima categoria ---------*/



            $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }
            $categorias_final=array_reverse($padre_del_padre);

            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }	
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=12;}else{ $col=9; } 
                $ultimo_padre=end($elementos);
                $departamento_inf_tr="";
                $departamento_infe_tr="";
                $i=1;
                $cabeza=0;
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {


                        /*if($ids!=key($ultimo_padre)){

                            $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);

                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color:gray;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                //$departamento_inf_tr.=$departamento_infe_tr;
                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxdep($tipo['tia_id'],$bodega,'',null);
                                    //print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->cuerpo_busquedaxcodigo($informacion);
                                    }
                                }
                            }else {
                                $informacion=$this->inventario_model->consultaxdep($ids,$bodega,'',null);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->cuerpo_busquedaxcodigo($informacion);
                                }
                            }       
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }



        $cadena.=$departamento_inf_tr;



















            /*if(empty($bodega) )
            {
                $bodega=$this->inventario_model->get_bodega();
                $cadena="";

                foreach ($bodega as $bdg) {
                    $cadena.='<tr><td colspan="'.$col.'"><b><br />BODEGA: '.$bdg['bod_nombre'].'</b></td></tr>';
                    $tia_padre=$this->inventario_model->get_tia_padre($bdg['bod_id']);
                    foreach ($tia_padre as $papa) {
                        $cadena.='<tr><td colspan="'.$col.'"><b>DEPARTAMENTO: '.$papa['tia_nombre'].'</b></td></tr>';
                        $tia_hijo=$this->inventario_model->get_tia_hijo($bdg['bod_id'],$papa['tia_id']);

                        foreach ($tia_hijo as $hijo) {

                            $informacion=$this->inventario_model->consultaxdep($hijo['tia_id'],$bdg['bod_id']);
                            if(count($informacion)>0){
                                $cadena.='<tr><td colspan="11"><b><br />Categoría '.$i.': '.$hijo['tia_nombre'].'</b></td></tr>';
                                $cadena.=$cabezera;
                                $cadena.=$this->cuerpo_busquedaxcodigo($informacion);
                            }
                        }
                    }
                }

            }
            elseif(!empty($bodega) && empty($departamento)){
                $bodega=$this->input->post('bodega');
                $tia_padre=$this->inventario_model->get_tia_padre($bodega);
                foreach ($tia_padre as $papa) {
                    $cadena.='<tr><td colspan="'.$col.'"><b>DEPARTAMENTO: '.$papa['tia_nombre'].'</b></td></tr>';
                    $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$papa['tia_id']);

                    foreach ($tia_hijo as $hijo) {
                        $informacion=$this->inventario_model->consultaxdep($hijo['tia_id'],$bodega);
                        if(count($informacion)>0){
                            $cadena.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$hijo['tia_nombre'].'</b></td></tr>';
                            $cadena.=$cabezera;
                            $cadena.=$this->cuerpo_busquedaxcodigo($informacion);

                        }
                    }
                }

            }

            elseif(!empty($bodega) && !empty($departamento) && empty($categoria)){
                $departamento=$this->input->post('departamento');
                $bodega=$this->input->post('bodega');

                $tia_padre=$this->inventario_model->get_tia_padre($bodega,$departamento);
                foreach ($tia_padre as $papa) {
                    $cadena.='<tr><td colspan="'.$col.'"><b>DEPARTAMENTO: '.$papa['tia_nombre'].'</b></td></tr>';
                    $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$departamento);

                    foreach ($tia_hijo as $hijo) {

                        $informacion=$this->inventario_model->consultaxdep($hijo['tia_id'],$bodega);
                        if(count($informacion)>0){
                            $cadena.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$hijo['tia_nombre'].'</b></td></tr>';
                            $cadena.=$cabezera;
                            $cadena.=$this->cuerpo_busquedaxcodigo($informacion);

                        }
                    }
                }

            }

            elseif(!empty($bodega)  && !empty($categoria)){
                $departamento=$this->input->post('departamento');
                $bodega=$this->input->post('bodega');
                $categoria=$this->input->post('categoria');

                $tia_padre=$this->inventario_model->get_tia_padre($bodega,$departamento);
                foreach ($tia_padre as $papa) {
                    $cadena.='<tr><td colspan="'.$col.'"><b>DEPARTAMENTO: '.$papa['tia_nombre'].'</b></td></tr>';
                    $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$departamento);

                    foreach ($tia_hijo as $hijo) {
                        if($hijo['tia_id']==$categoria){

                            $informacion=$this->inventario_model->consultaxdep($categoria,$bodega);

                            if(count($informacion)>0){
                                $cadena.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$hijo['tia_nombre'].'</b></td></tr>';
                                $cadena.=$cabezera;
                                $cadena.=$this->cuerpo_busquedaxcodigo($informacion);


                            }

                        }
                    }
                }
            }*/
            $arreglo = array( 
                "drop"=>$cadena,
                );

            echo json_encode($arreglo);


        }

        function ver_precios($id_sar)
        {
            $data['precios']=$this->inventario_model->listado_precios($id_sar);
            $this->load->view('inventario/reportes/ver_precios',$data);
        }

        function tbody_reporte_furgon($informacion)
        {
            //$ndecimales =  $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $ndecimales =  2;

            $entradas=0;
            $salidas=0;
            $saldo=0;
            $cadena="";
            foreach ($informacion as $key) 
            {

                $cadena.='<tr>';
                $cadena.='<td style="text-align:center;">'.$key['codigo'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['nombre'].'</td>';
                $cadena.='<td style="text-align:center;">'."&nbsp;".$key['caja'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['cantidad'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';
                $cadena.='<td style="text-align:right;">&nbsp;'.number_format($key['Entradas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align:right;">&nbsp;'.number_format($key['Salidas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align: right;">&nbsp;'.number_format($key['Saldo'],$ndecimales).'</td></tr>';
                $entradas+=(float)$key['Entradas'];
                $salidas+=(float)$key['Salidas'];
                $saldo+=(float)$key['Saldo'];
            }
            $cadena.='<tr><td colspan="8"></td></tr>';
            $cadena.='<tr><td colspan="5"><b>Total:</b></td><td style="text-align:right;">&nbsp;<b>'.number_format($entradas,$ndecimales).'</b></td><td style="text-align:right;">&nbsp;<b>'.number_format($salidas,$ndecimales).'</b></td><td style="text-align:right;">&nbsp;<b>'.number_format($saldo,$ndecimales).'</b></td></tr>';
            return $cadena;

        }

        public function reporte_furgon()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {

                $furgon=$this->input->post('furgon');
                $categoria=$this->input->post('categoria');
                $bodega=$this->input->post('bodega');
                $departamento=$this->input->post('departamento');
                $tipo_reporte=$this->input->post('tipo_reporte');
                $cabezera='<tr><td style="text-align:center; font-weight:bold;">Código</td>';
                $cabezera.='<td style="text-align:center; font-weight:bold;">Nombre</td>';
                $cabezera.='<td style="text-align:center; font-weight:bold;">No. Caja</td>';
                $cabezera.='<td style="text-align:center; font-weight:bold;">Cant/Caja</td>';
                $cabezera.='<td style="text-align:center; font-weight:bold;">UM</td>';
                $cabezera.='<td style="text-align:center; font-weight:bold;">Entradas</td>';
                $cabezera.='<td style="text-align:center; font-weight:bold;">Salidas</td>';
                $cabezera.='<td style="text-align:center; font-weight:bold;">Saldo</td>';
                $cabezera.='</tr>';
                $cadena="";



                        /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            $codigo= $this->input->post('cod_art');
            //print_r($_POST);exit();

            /*--------------------------------------------------------------------*/

            /* ------------- condiciones para la busqueda por codigo --------------*/

            $cod_art = ($codigo =="") ? null : $codigo ;

            /*--------------------------------------------------------------------*/



            /*--------------- Encontrar dependencias de ultima categoria ---------*/



             $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }

            $categorias_final=array_reverse($padre_del_padre);

            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }   
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=8;}else{ $col=8; } 
                $ultimo_padre=end($elementos);

                $departamento_inf_tr="";
                $i=1;
                $cabeza=0;
                $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                $departamento_tr.='<tbody>';
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {
                       /* $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                        $departamento_tr.='<thead>';
                        $departamento_tr.='<tr style="background-color: #C0C0C0;"><th colspan="8" style="text-align:center; font-weight:bold;">DEPARTAMENTO: '.$papa['tia_nombre'].'</th></tr>';
                        $departamento_tr.='</thead>';
                        $departamento_tr.='<tbody>';*/

                        /*if($ids!=key($ultimo_padre)){

                            $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);
                           

                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color: #F0F0F0;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxfurgon($tipo['tia_id'],$furgon,$bodega,$cod_art);
                                    //print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->tbody_reporte_furgon($informacion);
                                        
                                    }

                                }
                            }else {
                                $informacion=$this->inventario_model->consultaxfurgon($ids,$furgon,$bodega,$cod_art);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->tbody_reporte_furgon($informacion);
                                    
                                }
                            }       
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }

                
        $cadena.=$departamento_tr.$departamento_inf_tr;
        $cadena.='</tbody>';
        $cadena.='</table>';
	


                if($tipo_reporte=='excel'){
            //Nombre del archivo 
                    $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            //Obtener datos y construir secciones del reporte

                    $data['table_header']     	= $rows;
                    $data['table_tbody']      	= $cadena;
                    $data['filename']         	= $filename;

                    $this->load->view('inventario/reportes/reporte_furgon', $data);
                }

                if($tipo_reporte=='pdf'){
                    $data['table_header']     	= $rows;
                    $data['table_tbody']      	= $cadena;
                    $this->pdf->reportePDF('inventario/reportes/reporte_furgon_pdf', $data, 'Furgón');
                }
            }
        }

        function tbody_reporte_prod_sin_mov($informacion)
        {
            $ndecimales =  $this->gsatelite->get_parametro('NUMERO_DECIMALES');
         //   $ndecimales =  2;
            $entrada=0;
            $salida=0;
            $saldo=0;
            $cadena="";
            $mostrar=0;
            foreach ($informacion as $key) 
            {
                if($key['Salidas'] == 0){
                                //$cadena.='<tr><td>'.$key['bodega'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<tr><td style="text-align:center;">'.$key['furgon'].'</td>';
                }
                else{$cadena.="<tr>";}
                    $cadena.='<td style="text-align:center;">'.$key['codigo'].'</td>';
                    $cadena.='<td style="text-align:center;">'.$key['nombre'].'</td>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cadena.='<td style="text-align:center;">'.$key['caja'].'</td>';
                    $cadena.='<td style="text-align:center;">'.number_format($key['cantidad'],$ndecimales).'</td>';
                }
                    $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';
                    $cadena.='<td style="text-align:right;">'.number_format($key['Entradas'],$ndecimales).'</td>';
                    $cadena.='<td style="text-align:right;">'.number_format($key['Salidas'],$ndecimales).'</td>';
                    $cadena.='<td style="text-align:right;">'.number_format($key['Saldo'],$ndecimales).'</td></tr>';


                    $entrada+=(int)$key['Entradas'];
                    $salida+=(int)$key['Salidas'];
                    $saldo+=(int)$key['Saldo'];

                $mostrar++;
                }
            }
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=6;}else{ $col=3; } 
            $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align: right;"><b>'.number_format($entrada,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align: right;"><b>'.number_format($salida,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align: right;"><b>'.number_format($saldo,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td></tr>';
            $datos=array('cadena'=>$cadena,'data'=>$mostrar);
            return $cadena;
        }


        public function reporte_prod_sin_mov()
        {

            $categoria=$this->input->post('categorias');
            $bodega=$this->input->post('bodega');
            $departamento=$this->input->post('departamento');
            $tipo_reporte=$this->input->post('tipo_reporte');
            $cabezera='<tr style="background-color: #C0C0C0;">';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th>Contenedor</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){	
            $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera.='</tr>';
            $cadena="";
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=9;}else{ $col=6; } 

            /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            /*--------------------------------------------------------------------*/

            /*--------------- Encontrar dependencias de ultima categoria ---------*/



            $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }
            $categorias_final=array_reverse($padre_del_padre);

            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }	
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=9;}else{ $col=6; } 
                $ultimo_padre=end($elementos);
                $departamento_inf_tr="";
                $i=1;
                $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                $departamento_tr.='<tbody>';
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {
                       /* $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                        $departamento_tr.='<thead>';
                        $departamento_tr.='<tr style="background-color: #C0C0C0;"><th colspan="8" style="text-align:center; font-weight:bold;">DEPARTAMENTO: '.$papa['tia_nombre'].'</th></tr>';
                        $departamento_tr.='</thead>';
                        $departamento_tr.='<tbody>';*/

                        /*if($ids!=key($ultimo_padre)){

                            $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);
                           

                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color: #C0C0C0;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxdep($tipo['tia_id'],$bodega,'',3);
                                    //print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->tbody_reporte_prod_sin_mov($informacion);
                                        
                                    }

                                }
                            }else {
                                $informacion=$this->inventario_model->consultaxdep($ids,$bodega,'',3);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->tbody_reporte_prod_sin_mov($informacion);
                                    
                                }
                            }       
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }

                
        $cadena.=$departamento_tr.$departamento_inf_tr;


            if($tipo_reporte=='excel'){
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header']     = $rows;
                $data['table_tbody']      = $cadena;
                $data['filename']         = $filename;



                $this->load->view('inventario/reportes/reporte_departamento.php', $data);
            }
            if($tipo_reporte=='pdf'){
                $data['table_header']     	= $rows;
                $data['table_tbody']      	= $cadena;
                $this->pdf->reportePDF('inventario/reportes/reporte_prod_sin_mov_pdf', $data, 'Productos sin Movimiento');
            }
        }

        function tbody_reporte_codigo($informacion)
        {
            $entradas=0;
            $salidas=0;
            $saldo=0;
            $cadena="";
            foreach ($informacion as $key) 
            {

                $cadena.='<tr>';
                $cadena.='<td style="text-align:center;">'.$key['bodega'].'</td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:center;">'.$key['furgon'].'</td>';
            }
                $cadena.='<td style="text-align:center;">'.$key['codigo'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['nombre'].'</td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:center;">'."&nbsp;".$key['caja'].'</td>';
                $cadena.='<td style="text-align:center;">'.$key['cantidad'].'</td>';
            }
                $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';			
                $cadena.='<td style="text-align:right;">'.number_format($key['Entradas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $cadena.='<td style="text-align:right;">'.number_format($key['Salidas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $cadena.='<td style="text-align: right;">'.number_format($key['Saldo'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $cadena.='</tr>';
                $entradas+=$key['Entradas'];
                $salidas+=$key['Salidas'];
                $saldo+=$key['Saldo'];
            }
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=7;}else{ $col=4; }
            $cadena.='<tr><td></td></tr>';
            $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align:right;"><b>'.number_format($entradas,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align:right;"><b>'.number_format($salidas,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td><td style="text-align:right;"><b>'.number_format($saldo,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td></tr>';
            $cadena.='<tr><td></td></tr>';
            return $cadena;

        }

        public function reporte_codigo()
        {
            $categoria=$this->input->post('categoria');
            $bodega=$this->input->post('bodega');
            $departamento=$this->input->post('departamento');

            $cabezera='<tr  style="background-color: #C0C0C0;">';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th style="text-align:center; font-weight:bold;">Contenedor</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
            $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
        }
            $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera.='</tr>';
            $cadena="";
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=10;}else{ $col=7; }
            $furgones=$this->input->post('furgon');
            if($furgones != "")
            {
                $cadena_in="";
            foreach ($furgones as $key =>$value ) {

                $cadena_in.=$value.',';

            }

            $furgon=substr($cadena_in,0,-1);
            }
            else
            {
                $furgon="";
            }   

            /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            $codigo= $this->input->post('cod_art');

            /*--------------------------------------------------------------------*/

            /* ------------- condiciones para la busqueda por codigo --------------*/

            $cod_art = ($codigo =="") ? null : $codigo ;

            /*--------------------------------------------------------------------*/



            /*--------------- Encontrar dependencias de ultima categoria ---------*/



            $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }
            $categorias_final=array_reverse($padre_del_padre);

            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }   
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=9;}else{ $col=6; } 
                $ultimo_padre=end($elementos);
                $departamento_inf_tr="";
                $i=1;
                $cabeza=0;
                $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                $departamento_tr.='<tbody>';
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {
                       /* $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                        $departamento_tr.='<thead>';
                        $departamento_tr.='<tr style="background-color: #C0C0C0;"><th colspan="8" style="text-align:center; font-weight:bold;">DEPARTAMENTO: '.$papa['tia_nombre'].'</th></tr>';
                        $departamento_tr.='</thead>';
                        $departamento_tr.='<tbody>';*/

                        /*if($ids!=key($ultimo_padre)){

                            $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);
                           

                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color: #C0C0C0;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxdep($tipo['tia_id'],$bodega,'',null);
                                    //print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->tbody_reporte_codigo($informacion);
                                        
                                    }

                                }
                            }else {
                                $informacion=$this->inventario_model->consultaxdep($ids,$bodega,'',null);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->tbody_reporte_codigo($informacion);
                                    
                                }
                            }       
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }

                
        $cadena.=$departamento_tr.$departamento_inf_tr;
            

            $tipo_reporte =$this->input->post('tipo_reporte');

            if($tipo_reporte=='excel'){
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header']     = $rows;
                $data['table_tbody']      = $cadena;
                $data['filename']         = $filename;
                $this->load->view('inventario/reportes/reporte_departamento.php', $data);
            }
            if($tipo_reporte=='pdf'){
                $data['table_header']     	= $rows;
                $data['table_tbody']      	= $cadena;
                ini_set('memory_limit', '256M');
                $this->pdf->reportePDF('inventario/reportes/reporte_departamento_pdf', $data, 'Reporte por Código');
            }


        }

        function tbody_reporte_departamento($informacion)
        {
            //$ndecimales =  $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $ndecimales =  2;

            $entradas=0;
            $salidas=0;
            $saldo=0;
            $cadena="";
            foreach ($informacion as $key) 
            {
                $cadena.='<tr >';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:center;">'.$key['furgon'].'</td>';
            }
                $cadena.='<td style="text-align:left;">'.$key['codigo'].'</td>';
                $cadena.='<td style="text-align:left;">'.$key['nombre'].'</td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:left;">'."&nbsp;".$key['caja'].'</td>';
            }
                $cadena.='<td style="text-align:center;">'.$key['UM'].'</td>';
                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                $cadena.='<td style="text-align:left;">'.$key['cantidad'].'</td>';
            }
                $cadena.='<td style="text-align:right;">&nbsp;'.number_format($key['Entradas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align:right;">&nbsp;'.number_format($key['Salidas'],$ndecimales).'</td>';
                $cadena.='<td style="text-align:right;">&nbsp;'.number_format($key['Saldo'],$ndecimales).'</td>';
                $cadena.='</tr>';
                $entradas+=$key['Entradas'];
                $salidas+=$key['Salidas'];
                $saldo+=$key['Saldo'];
            }
            if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=6;}else{ $col=3; }
            $cadena.='<tr><td></td></tr>';
            $cadena.='<tr><td colspan="'.$col.'"><b>Total:</b></td><td style="text-align:right;"><b>'.number_format($entradas,$ndecimales).'</b></td><td style="text-align:right;"><b>'.number_format($salidas,$ndecimales).'</b></td><td style="text-align:right;"><b>'.number_format($saldo,$ndecimales).'</b></td></tr>';
            $cadena.='<tr><td></td></tr>';
            return $cadena;

        }



        public function reporte_departamento()
        {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                    $cabezera='<tr style="background-color: #F0F0F0;">';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cabezera.='<th>Contenedor</th>';
                }
                    $cabezera.='<th style="text-align:center; font-weight:bold;">Código</th>';
                    $cabezera.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cabezera.='<th style="text-align:center; font-weight:bold;">No. Caja</th>';
                }
                    $cabezera.='<th style="text-align:center; font-weight:bold;">UM</th>';
                    if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){
                    $cabezera.='<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
                }
                    $cabezera.='<th style="text-align:center; font-weight:bold;">Entradas</th>';
                    $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
                    $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
                    $cabezera.='</tr>';

                    $furgones=$this->input->post('furgon');
            if($furgones != "")
            {
                $cadena_in="";
            foreach ($furgones as $key =>$value ) {

                $cadena_in.=$value.',';

            }

            $furgon=substr($cadena_in,0,-1);
            }
            else
            {
                $furgon="";
            }	

            /*---------------- Parametros de busqueda ----------------------------*/
            $bodega=$this->input->post('bodega');
            $ultima_categoria=$this->input->post('categoria');
            $codigo= $this->input->post('cod_art');

            /*--------------------------------------------------------------------*/

            /* ------------- condiciones para la busqueda por codigo --------------*/

            $cod_art = ($codigo =="") ? null : $codigo ;

            /*--------------------------------------------------------------------*/



            /*--------------- Encontrar dependencias de ultima categoria ---------*/



            $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();
                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');
            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }
            $categorias_final=array_reverse($padre_del_padre);

            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);
                    }	
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=9;}else{ $col=6; } 
                $ultimo_padre=end($elementos);
                $departamento_inf_tr="";
                $i=1;
                $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                $departamento_tr.='<tbody>';
                $ids_cat_consultados = array();
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {
                       /* $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                        $departamento_tr.='<thead>';
                        $departamento_tr.='<tr style="background-color: #C0C0C0;"><th colspan="8" style="text-align:center; font-weight:bold;">DEPARTAMENTO: '.$papa['tia_nombre'].'</th></tr>';
                        $departamento_tr.='</thead>';
                        $departamento_tr.='<tbody>';*/

                        /*if($ids!=key($ultimo_padre)){

                            $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';

                        }else{*/

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);
                           

                            if(count($tia_hijo)>0){
                            $departamento_infe_tr='<tr style="background-color: #F0F0F0;"><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                                foreach ($tia_hijo as $tia => $tipo) {
                                    $informacion=$this->inventario_model->consultaxdep($tipo['tia_id'],$bodega,$furgon,$cod_art);
                                    $ids_cat_consultados[] = $tipo['tia_id'];
                                    //print_r($this->db->last_query());exit();
                                    if(count($informacion)>0 && $cabeza<1){
                                        $departamento_inf_tr.=$departamento_infe_tr;
                                        $cabeza++;
                                    }

                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera;
                                        $departamento_inf_tr.=$this->tbody_reporte_departamento($informacion);
                                        
                                    }

                                }
                            }else {
                                if(!in_array($ids, $ids_cat_consultados)) {
                                $informacion=$this->inventario_model->consultaxdep($ids,$bodega,$furgon,$cod_art);
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera;
                                    $departamento_inf_tr.=$this->tbody_reporte_departamento($informacion);
                                    
                                }
                            }
                            }       
                        //}
                    }
                    $cabeza=0;
                    $i++;
                }

                
        $cadena.=$departamento_tr.$departamento_inf_tr;

                $tipo_reporte=$this->input->post('tipo_reporte');




                if($tipo_reporte=='excel'){
                    $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                    $data['table_header']     = $rows;
                    $data['table_tbody']      = $cadena;
                    $data['filename']         = $filename;
                    $this->load->view('inventario/reportes/reporte_departamento.php', $data);
                }
                if($tipo_reporte=='pdf'){
                    $data['table_header']     	= $rows;
                    $data['table_tbody']      	= $cadena;
                    $this->pdf->reportePDF('inventario/reportes/reporte_departamento_pdf', $data, 'Departamento o de Código');
                }
            }
        }

        function _cargarvista($data=0,$crud=0)
        {	
            $this->load->view('vacia',$crud);	
            if($data!=0)
                $data=array_merge($data,$this->masterpage->getUsuario());
            else
                $data=$this->masterpage->getUsuario();
            $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
            $this->masterpage->setMasterPage('masterpage_default');
            $this->masterpage->addContentPage($vista, 'content',$data);
            $this->masterpage->show();
        }
    }
    ?>