<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    function index() {
        $data['bodegas']         = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
        $data['categorias']      = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_padre' => null,'tia_estado' => 1), null, null, null, true);
        $data['solicitudes']     = array();//$this->inventario_model->consulta_general('tra_translado');
        $data['titulo_personal'] = 'Traslado entre bodegas';
        $this->_cargarvista(null, $data);
    }

    public function caracteristicasxarticulo() {
        $data['articulos'] = $this->inventario_model->get_articulosxcaracteristicas(null, "art_id");
        //print_r($data);exit();
        $data['categoria_padre'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', 'categorias', array('tia_padre ' => null, 'tia_aplica_tipo_venta' => 1, 'tia_estado' => 1), null, null, null, true);
        $data['titulo_personal'] = "Características por artículo";
        $this->_cargarvista($data);
    }

    public function reporte_categorias($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            //var_dump($post_array);die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
                $categoria = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
                $producto = ($post_array['producto'] != '') ? $post_array['producto'] : null;
            } else {
                $categoria = ($post_array['filtro_categoria'] != '') ? $post_array['filtro_categoria'] : null;
                $producto = ($post_array['filtro_producto'] != '') ? $post_array['filtro_producto'] : null;
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;
            //Se crean las condicionales del reporte
            if ($categoria != null) {
                $where['tia_id'] = $categoria;
            }
            if ($producto != null) {
                $where['art_id'] = $producto;
            }

            $group_by = "art_id";

            $data['reporte'] = $this->inventario_model->get_articulosxcaracteristicas($where, $group_by);
            //print_r($this->db->last_query());die();
            //var_dump($data['reporte']);die();
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_caracteristicas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('inventario/reportes/reporte_caracteristicas', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Características';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Caracteristicas_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'I', 'Reporte_Caracteristicas', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_caracteristicas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Reporte de características';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function imprimir_categorias() {
        $data['articulos'] = $this->db->select()
                        ->from('art_articulo')
                        ->join('cxu_caracxarticulo', 'art_id=cxu_id_art', 'left')
                        ->group_by('art_id')
                        ->get()->result_array();
        $html = $this->load->view('reporte/header', array('titulo' => 'CaracterÍsticas de artículos'), true);

        $html .= $this->load->view('inventario/reportes/caracteristicas_print.php', $data, true);
        //print_r($html);exit();
        $reporte = $this->pdf->reportePDF2($html);
    }

    function generar_boleta() {
        $id_solicitud = $this->input->get('identificador');
        $obtener_movimiento_salida = $this->inventario_model->consulta_condicion_resultado('tra_translado', 'tra_id', $id_solicitud);
        $id_movimiento_salida = $obtener_movimiento_salida[0]['tra_id_moi_sal'];
        $id_movimiento_entrada = $obtener_movimiento_salida[0]['tra_id_moi_ent'];
        $campos_pdf = "dee_cantidad, dee_precio,art_nombre";
        $join_pdf = "dee_detalle_mov,sar_saldo_articulo.sar_id = dee_detalle_mov.dee_id_sar/art_articulo,art_articulo.art_id = sar_saldo_articulo.sar_id_art";
        $tabla = "sar_saldo_articulo";
        $campo_condicion = "dee_detalle_mov.dee_id_moi";
        $data['detalle'] = $this->inventario_model->consulta_ejecutando_join($tabla, $campos_pdf, $join_pdf, $campo_condicion, $id_movimiento_salida);
        $bodega_entrada = $this->inventario_model->bodega_entrada($id_movimiento_entrada);
        $bodega_salida = $this->inventario_model->bodega_salida($id_movimiento_salida);
        $data['cabezera'] = '<table><tr><td><span style="font-weight:bold;font-size: 1.em;">BODEGA DE PROCEDENCIA:</span><span>' . $bodega_salida[0]['bod_nombre'] . '</span>
       <span style="font-weight:bold;font-size: 1.em;">BODEGA DESTINO:</span><span>' . $bodega_entrada[0]['bod_nombre'] . '</span><br>
       <span style="font-weight:bold;font-size: 1.em;">FECHA DE MOVIMIENTO:</span><span>' . date('d/m/Y', strtotime($bodega_entrada[0]['moi_fecha_mov'])) . '</span><br></td></tr></table>';
        $this->pdf->reportePDF('inventario/boleta_traslado/generar_pdf', $data, 'Traslado');
    }

    function inventario_departamento() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Reporte por Categoría";
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data['furgones'] = $this->inventario_model->obtener_furgones();
            $this->_cargarvista(null, $data);
        }
    }

    public function inventario_requisiciones($consulta = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/reportes/inventario_requisiciones');
            if ($_POST) {
                if ($consulta > 0) {
                    $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                    $flujos_array = json_decode($flujos, true);
                    $post_array = $_POST;
                    $bodega = $post_array['bodega'];
                    $fecha_inicio = $post_array['fecha_ini'];
                    $fecha_fin = $post_array['fecha_fin'];
                    $modulo = $post_array['modulo'];
                    $data['bodega_id'] = $bodega;
                    $data['fecha_ini'] = $fecha_inicio;
                    $data['fecha_fin'] = $fecha_fin;
                    $data['modulo'] = $modulo;
                    $where = null;
                    if($modulo == 1){
                        $where['rxi_id_flu'] = $flujos_array['REQ_INV'];
                    } else if($modulo == 2){
                        $where['rxi_id_flu'] = $flujos_array['REQ_COMP'];
                    }
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['rxi_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['rxi_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                    }
                    if(trim($bodega) != "" && $modulo == 1){
                        $where['rxi_id_bod'] = $bodega;
                    }
                    $requisiciones = $this->inventario_model->get_reporte_requisiciones($where, $modulo);
                    $data['requisiciones'] = $requisiciones;
                    $data['tipo_reporte'] = 'grid';
                    $html = $this->load->view('inventario/reportes/imprimir_reporte_requisicion', $data, true);
                    echo $html;
                    die();
                }
            } else {
                $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                $flujos_array = json_decode($flujos, true);
                $data['flu'] = $flujos_array['REQ_INV'];

                if(!(trim($flujos) != '' && trim($flujos_array['REQ_INV']) != '')){
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Falta configuracion de parametro.");
                    $this->session->set_flashdata($alerta);
                    redirect('/inventario/index');
                }
                $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
                $data['bodegas'] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data['titulo_personal'] = "Reporte de requisiciones por bodega";
                $this->_cargarvista($data);
            }
        }
    }


    public function imprimir_inventario_requisiciones(){
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $decimales = (trim($decimales) != '')?$decimales:2;
        $data['decimales'] = $decimales;

        $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
        $flujos_array = json_decode($flujos, true);

        $post_array = $_POST;

        $rxi_id = $post_array['rpt_codigo'];
        $bodega = $post_array['rpt_slcBodega'];
        $fecha_inicio = $post_array['rpt_txtFechaIni'];
        $fecha_fin = $post_array['rpt_txtFechaFin'];
        $tipo = $post_array['rpt_tipo'];
        $modulo = $post_array['modulo'];

        $data['rxi_id'] = $rxi_id;
        $data['bodega_id'] = $bodega;
        $data['fecha_ini'] = $fecha_inicio;
        $data['fecha_fin'] = $fecha_fin;
        $data['tipo_reporte'] = $tipo;
        $data['modulo'] = $modulo;

        $where = null;

        if($modulo == 1){
            $where['rxi_id_flu'] = $flujos_array['REQ_INV'];
        } else if($modulo == 2){
            $where['rxi_id_flu'] = $flujos_array['REQ_COMP'];
        }

        if($rxi_id != ""){
            $where['rxi_id'] = $rxi_id;
        }

        if ($fecha_inicio != '' && $fecha_fin != '') {
            $where['rxi_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
            $where['rxi_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }

        if(trim($bodega) != "" && $modulo == 1){
            $where['rxi_id_bod'] = $bodega;
        }
        $requisiciones = $this->inventario_model->get_reporte_requisiciones_detalle($where, $modulo);
        $data['requisiciones'] = $requisiciones;
        //print_r($requisiciones);exit();die();
        if($tipo == 'excel'){
            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('inventario/reportes/imprimir_reporte_requisicion', $data);
        } else{
            $data['titulo'] = 'requisiciones';
            $header = $this->load->view('reporte/header', $data, true);

            $html = $this->load->view('inventario/reportes/imprimir_reporte_requisicion', $data, true);
            $GLOBALS['nombre_reporte'] = 'requisiciones' . date('dmY');

            //echo $html;
            $this->pdf->makePdf($header.$html, 'L', 'requisiciones', 'Letter');
        }
    }

    public function ver_cantxbodega($id_art) {
        $data['bodegas'] = $this->inventario_model->cantidad_requisicionesxbodega($id_art);
        $this->load->view('inventario/reportes/ver_cantxbodega', $data);
    }

    function inventario_saldo_cero() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // ******************************************************
            // Se comento para no mostrar datos al momento de cargar el reporte
            // $group_by = "   art_codigo,art_nombre";
            // $having = "SUM(sar_cant_actual) = 0";
            // $data['saldos'] = $this->inventario_model->saldo_cero(null, $group_by, $having);
            // print_r($this->db->last_query());die();
            // ******************************************************
            $data['bodegas'] = $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', 'bodegas', array('bod_estado' => 1), null, null, null, true);
            $data['categorias'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_padre' => null,'tia_estado' => 1), null, null, null, true);
            $data["titulo_personal"] = "Reporte de saldos cero";
            $this->_cargarvista(null, $data);
        }
    }

    function reporte_saldo_cero($tipo = null) {
        //$tipo=1 (excel), $tipo=2 (pdf)
        if ($_POST) {
            $post_array = $this->input->post();
            $group_by = "";
            if ($tipo == null) {
                $bodega     = ($post_array['bodega'] > 0) ? $post_array['bodega'] : null;
                $categoria  = ($post_array['categoria'] > 0) ? $post_array['categoria'] : null;
                $productos  = (count($post_array['productos']) > 0) ? implode(',', $post_array['productos']) : null;
            } else {
                $bodega     = ($post_array['filtro_bodega'] > 0) ? $post_array['filtro_bodega'] : null;
                $categoria  = ($post_array['filtro_catego'] > 0) ? $post_array['filtro_catego'] : null;
                $productos  = (trim($post_array['filtro_produc']) !="") ? $post_array['filtro_produc'] : null;
            }
            $where = null;
            if ($bodega != null) {
                $where['sar_id_bod'] = $bodega;
                $bod_name = $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $bodega));
            } else {
                $group_by = "sar_id_bod,";
                $bod_name = 'Todas las bodegas';
            }
            if ($categoria != null) {
                $categoria_padre = $categoria;
                $categorias_final = array();
                $categoria_arbol = $this->inventario_model->crear_arbol($categoria, "");
                if($categoria_arbol != ''){
                    $categorias_final = explode(',', $categoria_arbol);
                    $categorias_final = array_filter($categorias_final, function ($value){
                        return !is_null($value) && $value !== '';
                    });
                    $categorias_final[] = $categoria;
                }else{
                    if ($categoria != "") {
                        $padre_x_padre = array();
                        $i = 0;
                        while ($categoria != null) {
                            if ($i == 0) {
                                $padre_x_padre[] = $categoria;
                            } else {
                                $categoria = $this->db->where('tia_id', $categoria)->get('tia_tipo_articulo')->row_array();
                                $categoria = $categoria['tia_padre'];
                                $padre_x_padre[] = $categoria;
                            }
                            $i++;
                        }
                        $padre_x_padre = array_filter($padre_x_padre, function ($value){
                            return !is_null($value) && $value !== '';
                        });
                        $categorias_final = array_reverse($padre_x_padre);
                    }                    
                }
                $ids = implode(',', $categorias_final);
                $where["art_id_tia IN ($ids)"] = null;
            }
            if ($productos != null) {
                $in = $productos;   
            }
            $group_by .= "art_codigo,art_nombre";
            $having = "SUM(sar_cant_actual) = 0";
            $data['reporte'] = $this->inventario_model->saldo_cero($where, $in, $group_by, $having);
            // print_r($this->db->last_query());die();
            $filename = 'rpt_saldos_cero_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo;
            $data['subtitulo'] = 'Bodega: ' . $bod_name;
            $html = $this->load->view('inventario/reportes/reporte_saldos_cero', $data, true);
            //die(print_r($tipo));
            if ($tipo == null) {
                echo $html;
            } else {
                if ($tipo == 2) {
                    $data['titulo'] = 'Saldos Cero';
                    $data['subtitulo'] = 'Bodega: ' . $bod_name;
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Saldos_Cero_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Saldos_Cero', 'Letter');
                } elseif ($tipo == 1) {
                    $filename = 'rpt_saldos_cero_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Saldos Cero';
                    $data['filename'] = $filename;
                    echo $html;

                }
            }
        }
    }

    function reporte_requisicones($tipo) {
        $data = $this->inventario_model->get_detalles_rxixbodega();
        if ($data) {

            $rows = 'requisiciones por bodega';
            $us = $this->tank_auth->get_user_id();
            $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
            $titulo = $rows;
            $encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);
            $cadena = '<table class="tabla" style="border:1px solid black;">';
            $cadena .= '<tr style="background-color: #C0C0C0;">';
            $cadena .= '<th style="text-align:center; font-weight:bold;">C&oacute;digo</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Producto</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Saldo Actual</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Cantidad solicitada</th>';
            $cadena .= '<th colspan="2" style="text-align:center; font-weight:bold;">Solicitante</th>';
            $cadena .= '</tr>';
            foreach ($data as $key) {
                $cadena .= '<tr style="background-color: #FCFC96;">';
                $cadena .= '<td height="15px">' . $key['productos'] . '</td>';
                $cadena .= '<td>' . $key['nombre'] . '</td>';
                $cadena .= '<td>' . number_format($key['cant_actual'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                $cadena .= '<td>' . number_format($key['cantidad'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                $cadena .= '<td colspan="2"></td>';
                $cadena .= '</tr>';
                $data_bodega = $this->inventario_model->cantidad_requisicionesxbodega($key['art_id']);
                $total = 0;
                foreach ($data_bodega as $bod) {
                    $cadena .= '<tr >';
                    $cadena .= '<td colspan="3"><b>' . $bod['sucursal'] . '</b></td>';
                    $cadena .= '<td>' . number_format($bod['cantxbodega'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    $cadena .= '<td>' . $bod['solicitante'] . '</td>';
                    // $cadena.='<td></td>';
                    // $cadena.='<td></td>';
                    $cadena .= '</tr>';
                    $total += $bod['cantxbodega'];
                }
                $cadena .= '<tr>';
                $cadena .= '<td colspan="3" style="text-align:right;"><b>Total: </b></td>';
                $cadena .= '<td><b>' . number_format($total, $this->gsatelite->get_parametro('NUMERO_DECIMALES'), ".", ",") . '</b></td>';
                $cadena .= '<td></td>';
                $cadena .= '</tr>';
            }
            $cadena .= '</table>';
        }

        //Nombre del archivo
        $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        //Obtener datos y construir secciones del reporte


        if ($tipo == 1) {
            $data['table_header'] = $encabezado;
            $data['table_tbody'] = $cadena;
            $data['filename'] = $filename;
            $this->load->view('inventario/reportes/reporte_furgon.php', $data);
        } else if ($tipo == 2) {
            $data['table_header'] = '<br>';
            $data['table_tbody'] = $cadena;
            $data['filename'] = $filename;
            $this->pdf->reportePDF('inventario/reportes/reporte_saldo_cero_pdf.php', $data, 'requisiciones');
        }
    }

    function reporte_proveedor($tipo = 1) {
        //$tipo=1 (excel), $tipo=2 (pdf)
        ini_set('memory_limit', '1024M' );
        ini_set('max_execution_time', '9999');
        $Entradas   = 0;
        $salidas    = 0;
        $saldo      = 0;
        $total      = 0;
        $proveedor  = $_POST['filtro_proveedor'];
        $fecha_inicio   = $this->input->post('filtro_inicio');
        $fecha_fin      = $this->input->post('filtro_fin');

        $decimales      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!=null)?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

        $where = null;
        if ($fecha_inicio != '' && $fecha_fin != null) {
            $fecha_inicio  = date('Y-m-d', strtotime($fecha_inicio));
            $fecha_fin     = date('Y-m-d', strtotime($fecha_fin));
            $where["DATE(moi_fecha_mov) >="] = $fecha_inicio;
            $where["DATE(moi_fecha_mov) <="] = $fecha_fin;
        }

        $data = $this->inventario_model->consultaxproveedor($proveedor, $where);
        $rows = "proveedores";

        $us     = $this->tank_auth->get_user_id();
        $user   = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
        $titulo = $rows;
        $encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);

        if ($data) {
            $cadena = '<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" border="1" style="border:1px solid black;">';
            $cadena .= '<thead><tr>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Fecha</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Documento</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Proveedor</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Categoría</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Producto</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Marca</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">UM</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Entradas</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Salidas</th>';
            $cadena .= '<th style="text-align:center; font-weight:bold;">Saldo Actual</th>';
            $cadena .= '</tr></thead><tbody>';
            foreach ($data as $sld) {
                $fecha = ($sld['dpv_fecha'] != "") ? $sld['dpv_fecha'] : $sld['moi_fecha_mov'];
                $cadena .= '<tr >';
                $cadena .= '<td style="text-align:center;">' . formatear_fecha('d-m-Y',$fecha) . '</td><td style="text-align:center;">';
                $cadena .= ($sld['dpv_numero'] != "") ? $sld['dpv_numero'] : "--";       
                $cadena .= '</td><td style="text-align:center;">' . $sld['proveedor'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $sld['linea'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $sld['nombre'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $sld['marca'] . '</td>';                
                $cadena .= '<td style="text-align:center;">' . $sld['UM'] . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($sld['Entradas'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($sld['Salidas'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($sld['Saldo'], $decimales) . '</td>';
                $cadena .= '</tr>';
                $entradas   += $sld['Entradas'];
                $salidas    += $sld['Salidas'];
                $saldo      += $sld['Saldo'];
            }
               $col = 7;
            
            $cadena .= '<tr><td colspan="' . $col . '"><b>Total:</b></td><td style="text-align:right;"><b>' . number_format($entradas, $decimales) . '</b></td><td style="text-align:right;"><b>' . number_format($salidas, $decimales) . '</b></td><td style="text-align:right;"><b>' . number_format($saldo, $decimales) . '</b></td></tr>';
            $cadena .= '</tbody></table>';
        } else {
            $cadena .= '<tr>';
            $cadena .= '<td>0</td>';
            $cadena .= '<td>Cero Registros Encontrados</td>';
            $cadena .= '<td></td>';
            $cadena .= '<td></td>';
            $cadena .= '</tr>';
            $cadena .= '</table>';
        }
        //Nombre del archivo
        $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        //Obtener datos y construir secciones del reporte

        if ($tipo == 1) {
            $data['table_header']   = $encabezado;
            $data['table_tbody']    = $cadena;
            $data['filename']       = $filename;
            $this->load->view('inventario/reportes/reporte_furgon', $data);
        } else if ($tipo == 2) {
            $data['table_header']   = '<br>';
            $data['table_tbody']    = $cadena;
            $data['filename']       = $filename;
            $this->pdf->reportePDF('inventario/reportes/reporte_furgon_pdf', $data, 'proveedores','L');
        }
    }

    function reporte_proveedor_costos($tipo = 1) {
        //$tipo=1 (excel), $tipo=2 (pdf)
        $entradas = 0;
        $salidas = 0;
        $saldo = 0;
        $costos = 0;
        $total = 0;        
        $fecha_inicio = $this->input->post('filtro_inicio');
        $fecha_fin    = $this->input->post('filtro_fin');
        $categoria    = ($this->input->post('filtro_category') > 0) ? $this->input->post('filtro_category') : null;
        $proveedor    = ($this->input->post('filtro_proveedor') != '') ? $this->input->post('filtro_proveedor') : null;
        $productos    = ($this->input->post('filtro_productos') != '') ? $this->input->post('filtro_productos') : null;
        $decimales=($this->gsatelite->get_parametro('NUMERO_DECIMALES')!=null)?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $where = null;
        if ($fecha_inicio != '' && $fecha_fin != null) {
            $fecha_inicio = date('Y-m-d', strtotime($fecha_inicio));
            $fecha_fin = date('Y-m-d', strtotime($fecha_fin));
            $where["DATE(moi_fecha_mov) >="] = $fecha_inicio;
            $where["DATE(moi_fecha_mov) <="] = $fecha_fin;
        }
        if ($categoria != null) {
            $where["IFNULL(tia_padre,tia_id)"] = $categoria;
        }
        if ($productos != null) {
            $in = $productos;
        }
        $data['rpt'] = 'costo';
        $data['datos'] = $this->inventario_model->consultaxproveedor($proveedor, $where, $in);
        $data['t_rpt'] = $tipo;//$tipo=1 (excel), $tipo=2 (pdf)
        $user = $this->gsatelite->get_campo('users', 'username', array('id' => $this->tank_auth->get_user_id()));
        $encabezado = $this->load->view('reporte/header_excel', array('titulo' => "Proveedores y Costos", 'user' => $user), true);
        $data['table_header'] = $encabezado;
        if ($data) {
            $cadena = '<table class="tabla" border="1" style="border:0px solid black;"><tr><th style="text-align:center;"><b>Proveedor</b></th><th style="text-align:center;"><b>Categoría</b></th>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cadena .= '<th style="text-align:center; font-weight:bold;">Contenedor</th>';
            }
            $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
            $cadena .= '<th style="text-align:center;"><b>Producto</b></th><th style="text-align:center;"><b>Marca</b></th><th style="text-align:center;"><b>Entradas</b></th>';
            $cadena .= '<th style="text-align:center;"><b>Salidas</b></th><th style="text-align:center;"><b>Saldo Actual</b></th><th style="text-align:center;"><b>Costos ';
            $cadena .= (trim($smb) != "") ? "($smb)" : "";
            $cadena .= '</b></th></tr>';
            foreach ($data as $sld) {
                $cadena .= '<tr >';
                $cadena .= '<td style="text-align:center;">' . $sld['proveedor'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $sld['linea'] . '</td>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<td style="text-align:center;">' . $sld['contenedor'] . '</td>';
                }
                $cadena .= '<td style="text-align:center;">' . $sld['nombre'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $sld['marca'] . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($sld['Entradas'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($sld['Salidas'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($sld['Saldo'], $decimales) . '</td>';
                $cadena .= '<td class="decimales" style="text-align:right;">' . number_format($sld['precios_costos'], $decimales) . '</td>';
                $cadena .= '</tr>';
                $entradas += $sld['Entradas'];
                $salidas += $sld['Salidas'];
                $saldo += $sld['Saldo'];
                $costos += $sld['precios_costos'];
            }
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $col = 5;
            } else {
                $col = 4;
            }
            $cadena .= '<tr><td colspan="' . $col . '"><b>Total:</b></td><td style="text-align:right;"><b>' . number_format($entradas, $decimales) . '</b></td><td style="text-align:right;"><b>' . number_format($salidas, $decimales) . '</b></td><td class="decimales" style="text-align:right;"><b>' . number_format($saldo, $decimales) . '</b></td>';
            $cadena .= '<td class="decimales" style="text-align:right;"><b>' . number_format($costos, $decimales) . '</b></td></tr>';
            $cadena .= '</table>';
        } else {
            $cadena .= '<tr>';
            $cadena .= '<td>0</td>';
            $cadena .= '<td>Cero Registros Encontrados</td>';
            $cadena .= '<td class="center"></td>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cadena .= '<td></td>';
            }
            $cadena .= '<td></td>';
            $cadena .= '<td></td>';
            $cadena .= '<td></td>';
            $cadena .= '</tr>';
            $cadena .= '</table>';
        }
        //Nombre del archivo
        $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename'] = $filename;
        $html = $this->load->view('inventario/reportes/consulta_proveedores', $data, true);
        if ($tipo == 1) {
            echo $html;
            die();
            // $data['table_header'] = $encabezado;
            // $data['table_tbody'] = $cadena;
            // $data['filename'] = $filename;
            // $this->load->view('inventario/reportes/reporte_furgon.php', $data);
        } else if ($tipo == 2) {
            // $data['table_header'] = '<br>';
            // $data['table_tbody'] = $cadena;
            // $data['filename'] = $filename;
            // $reporte = $encabezado . $cadena;
            $this->pdf->makePdf($html, 'L', 'Proveedores y Costos', 'Letter');
            //$this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data, 'proveedores y costos');
        }
    }

    function inventario_factura() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $select = '<option value=""></option>';
            $tabla = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_traslado' => 0,'tip_estado' => 1));
            foreach ($tabla as $key => $value) {
                $select .= '<option value="' . $value['tip_id'] . '" data-entrada="' . $value['tip_entrada'] .'">' . $value['tip_nombre'] . '</option>';
            }
            $data['tipos'] = $select;
            $data['categorias'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', 'categorias', array('tia_padre' => null,'tia_aplica_tipo_venta' => 1,'tia_estado' => 1), null, null, null, true);
            $data['titulo_personal'] = "Reporte por tipo de movimiento";
            $this->_cargarvista(null, $data);
        }
    }

    function inventario_proceso() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $doc = $this->input->post('documento');
                $tipo = $this->input->post('tipo');
                if ($tipo == 1) {
                    $tipo = "tip_entrada";
                } elseif ($tipo == 2) {
                    $tipo = "tip_salida";
                }

                $where = array('moi_documento' => $doc);

                $mois = $this->inventario_model->get_movimientos($where);

                $cadena = "";

                foreach ($mois as $key) {

                    $detalles = $this->inventario_model->get_movimientos_detalles_proceso($key['moi_id'], $tipo);

                    if (!empty($detalles)) {
                        $cadena .= '<tr><td><b>Fecha:</b> ' . $detalles[0]['fecha_mov'] . '</td>';
                        $cadena .= '<td colspan="2"><b>No. Documento:</b> ' . $detalles[0]['documento'] . '</td>';
                        $cadena .= '<td colspan="4"><b>Bodega:</b> ' . $detalles[0]['bodega'] . '</td></tr>';
                        $cadena .= '<tr><td colspan="8"><b>Descripción:</b> ' . $detalles[0]['descripcion'] . '</td></tr>';
                        //$cadena.='<tr><td colspan="6">Furgón: '.$detalles[0]['furgon'].'</td></tr>';

                        $cadena .= '<tr><td colspan="8"></td></tr>';
                        $cadena .= '<tr width="10%"><th width="30%">Tipo de proceso</th>';
                        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                            $cadena .= '<th width="10%">Contenedor</th>';
                        }
                        $cadena .= '<th width="10%">Código</th>';
                        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                            $cadena .= '<th width="10%">Contenedor</th>';
                        }
                        $cadena .= '<th width="40%">Artículo</th>';
                        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                            $cadena .= '<th width="10%">Caja</th>';
                        }
                        $cadena .= '<th width="10%">Cantidad</th>';
                        if ($tipo == "tip_entrada") { //Solo se mostraran en caso de ser entradas
                            $cadena .= '<th width="10%">Precio</th>';
                            $cadena .= '<th width="10%">Sub-total</th>';
                        }
                        $cadena .= '<th width="10%">Imagen</th>';
                        $cadena .= '</tr>';

                        $sumatoria_subtotal = 0;
                        $sumatoria_cantidad = 0;

                        foreach ($detalles as $det) {
                            //$subT = number_format($det['cant_art']*$det['precio'],2);
                            $cadena .= '<tr><td style="text-align:center;">' . $det['tip_proceso'] . '</td>';
                            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                                $cadena .= '<td style="text-align:center;">' . $det['furgon'] . '</td>';
                            }
                            $cadena .= '<td style="text-align:center;">' . $det['codigo'] . '</td>';
                            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                                $cadena .= '<td style="text-align:center;">' . $det['furgon'] . '</td>';
                            }
                            $cadena .= '<td style="text-align:center;">' . $det['nombre'] . '</td>';
                            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                                $cadena .= '<td style="text-align:center;">' . '&nbsp;' . $det['caja'] . '</td>';
                            }
                            $cadena .= '<td style="text-align:center;">' . $det['cant_art'] . '</td>';
                            if ($tipo == "tip_entrada") { //Solo se mostraran en caso de ser entradas
                                $cadena .= '<td style="text-align:right;" >' . "$" . number_format($det['precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                                $cadena .= '<td style="text-align:right;" >' . "$" . number_format($det['cant_art'] * $det['precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                            }
                            if (isset($det['foto'])) {
                                $cadena .= '<td><div class="controls center"><input type="checkbox"  name="' . $det['foto'] . '" id="' . $det['foto'] . '" class="ibuttonCheck nostyle" /></div></td></tr>';
                            } else {
                                $cadena .= '<td style="text-align:center;">No posee</td>';
                            }
                            $cadena .= '</tr>';
                            $sumatoria_cantidad += $det['cant_art'];
                            $sumatoria_subtotal += $det['cant_art'] * $det['precio'];
                        }
                        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                            $col = 4;
                        } else {
                            $col = 2;
                        }
                        if ($tipo == "tip_entrada") { //Lleva precio y Subtotal
                            $cadena .= '<tr><td colspan="' . ($col + 1) . '" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>' . number_format($sumatoria_cantidad, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td><td></td><td  style="text-align:right;" ><b>' . "$" . number_format($sumatoria_subtotal, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td><td></td></tr>';
                        } else {
                            $cadena .= '<tr><td colspan="' . ($col + 1) . '" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>' . number_format($sumatoria_cantidad, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td><td></td><td></td></tr>';
                        }
                    }
                }

                $arreglo = array('drop' => $cadena);
                echo json_encode($arreglo);
            } else {
                $data['titulo_personal'] = "Reporte por proceso";
                $this->_cargarvista(null, $data);
            }
        }
    }

    function reporte_proceso($tipoR = 1) {
        //$tipoR=1 (excel), $tipoR=2 (pdf)
        $doc = $_POST['docu'];
        $tipo = $_POST['tip'];
        if ($tipo == 1) {
            $tipo = "tip_entrada";
        } elseif ($tipo == 2) {
            $tipo = "tip_salida";
        }

        $where = array('moi_documento' => $doc);
        $mois = $this->inventario_model->get_movimientos($where);
        $cadena = "";

        $us = $this->tank_auth->get_user_id();
        $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
        //$titulo = "inventario factura y procesos";
        $titulo = "Reporte de procesos";
        $rows = "Reporte por procesos con número de documento: " . $doc;
        $encabezado = $this->load->view('reporte/header_reporte', array('titulo' => $titulo, 'user' => $user, 'columna_empresa' => 3, 'columna_date' => 1, 'columna_logo' => 1), true);
        //$encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);


        foreach ($mois as $key) {

            $detalles = $this->inventario_model->get_movimientos_detalles_proceso($key['moi_id'], $tipo);
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $col = 7;
            } else {
                $col = 4;
            }
            if (!empty($detalles)) {
                $cadena .= '<table class="tabla" border="1" style="border:1px solid black;" width="100%">';
                $cadena .= '<tr><td colspan="' . ($col + 2) . '"><b>Fecha:</b> ' . $detalles[0]['fecha_mov'] . '</td></tr>';
                $cadena .= '<tr><td colspan="' . ($col + 2) . '"><b>No. Documento: </b>' . $detalles[0]['documento'] . '</td></tr>';
                $cadena .= '<tr><td colspan="' . ($col + 2) . '"><b>Descripción: </b>' . $detalles[0]['descripcion'] . '</td></tr>';
                //$cadena.='<tr><td colspan="7">Contenedor: '.$detalles[0]['furgon'].'</td></tr>';
                $cadena .= '<tr><td colspan="' . ($col + 2) . '"><b>Bodega: </b> ' . $detalles[0]['bodega'] . '</td></tr>';

                $cadena .= '<tr><th>Tipo de proceso</th>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<th>Contenedor</th>';
                }

                $cadena .= '<th>Código</th>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<th>Contenedor</th>';
                }
                $cadena .= '<th>Artículo</th>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<th>Caja</th>';
                    $cadena .= '<th>Cantidad</th>';
                }
                if ($tipo == "tip_entrada") {
                    $cadena .= '<th>Cantidad</th>';
                    $cadena .= '<th>Precio</th>';
                    $cadena .= '<th>Sub-total</th>';
                }
                $cadena .= '</tr>';

                $sumatoria_subtotal = 0;
                $sumatoria_cantidad = 0;

                foreach ($detalles as $det) {
                    $cadena .= '<tr><td style="text-align:center;">' . $det['tip_proceso'] . '</td>';
                    if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                        $cadena .= '<td style="text-align:center;">' . $det['furgon'] . '</td>';
                    }

                    $cadena .= '<td style="text-align:center;">' . $det['codigo'] . '</td>';
                    if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                        $cadena .= '<td style="text-align:center;">' . $det['furgon'] . '</td>';
                    }
                    $cadena .= '<td style="text-align:center;">' . $det['nombre'] . '</td>';
                    if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                        $cadena .= '<td style="text-align:center;"><span style="color:white;" >&nbsp;</span>' . '&nbsp;' . $det['caja'] . '</td>';
                        $cadena .= '<td style="text-align:center;">' . $det['cant_art'] . '</td>';
                    }
                    if ($tipo == "tip_entrada") { //Solo se mostraran en caso de ser entradas
                        $cadena .= '<td style="text-align:right;">' . number_format($det['cant_art'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                        $cadena .= '<td style="text-align:right;">' . "$" . number_format($det['precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                        $cadena .= '<td style="text-align:right;">' . "$" . number_format($det['cant_art'] * $det['precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    }
                    $cadena .= '</tr>';
                    $sumatoria_subtotal += $det['cant_art'] * $det['precio'];
                    $sumatoria_cantidad += $det['cant_art'];
                }

                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $col = 4;
                } else {
                    $col = 2;
                }
                $cadena .= '<tr><td colspan="' . ($col + 4) . '"></td></tr>';
                if ($tipo == "tip_entrada") { //Lleva precio y Subtotal
                    $cadena .= '<tr><td colspan="' . ($col + 1) . '" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>' . number_format($sumatoria_cantidad, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td><td></td><td  style="text-align:right;" ><b>' . "$" . number_format($sumatoria_subtotal, 2) . '</b></td></tr>';
                } else {
                    $cadena .= '<tr><td colspan="' . ($col + 1) . '" style="text-align:right;" >Totales</td><td  style="text-align:right;" ><b>' . number_format($sumatoria_cantidad, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td></tr>';
                }
                $cadena .= '</table>';
                //$cadena .='<tr><td colspan="5" style="text-align:right;" >Total</td><td  style="text-align:right;" ><b>'."$" . number_format($sumatoria_subtotal,2) .'</b></td></tr>';
            }
        }
        //Nombre del archivo
        $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        //Obtener datos y construir secciones del reporte
        $data['table_tbody'] = $cadena;
        $data['filename'] = $filename;

        if ($tipoR == 1) {
            $data['table_header'] = $encabezado;
            //$data['enunciado'] = $rows;
            $this->load->view('inventario/reportes/reporte_proceso.php', $data);
        } else if ($tipoR == 2) {
            $encabezado = $this->load->view('reporte/header_reporte', array('titulo' => $titulo, 'user' => $user, 'tipo' => 'pdf', 'style' => 0, 'enunciado' => $rows), true);
            $data['table_header'] = $rows;
            $this->pdf->makePdf(($encabezado . $data['table_tbody']), 'H', 'reporte_proceso', 'Letter');
            ///$this->pdf->reportePDF('inventario/reportes/reporte_proceso_pdf.php', $data, 'inventario factura y procesos');
        }
    }

    function reporte_factura($flag = null) {
        if ($_POST) {
            // var_dump($_POST);die();
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery, De lo contrario, se toman los filtros de impresión */
            if ($flag == 1) {
                $tipo         = ($post_array['tipo'] != '') ? $post_array['tipo'] : null;
                $tipo_proceso = ($post_array['tipo_proc'] != '') ? $post_array['tipo_proc'] : null;
                $documento    = ($post_array['documento'] != '') ? $post_array['documento'] : null;
                $fecha_inicio = $post_array['txtFechaIni'];
                $fecha_fin    = $post_array['txtFechaFin'];
                $categoria    = ($post_array['categoria'] > 0) ? $post_array['categoria'] : null;
                $productos    = (is_array($post_array['productos']) && count($post_array['productos']) > 0) ? implode(',', $post_array['productos']) : null;
                $tipo_reporte = '';
            } else {
                $tipo         = ($post_array['filtro_tipo'] != '') ? $post_array['filtro_tipo'] : null;
                $tipo_proceso = ($post_array['filtro_tipo_entr'] != '') ? $post_array['filtro_tipo_entr'] : null;
                $documento    = ($post_array['filtro_documento'] != '') ? $post_array['filtro_documento'] : null;
                $fecha_inicio = $post_array['filtro_fechIni'];
                $fecha_fin    = $post_array['filtro_fechFin'];
                $categoria    = ($post_array['filtro_categoria'] > 0) ? $post_array['filtro_categoria'] : null;
                $productos    = (trim($post_array['filtro_productos']) !="") ? $post_array['filtro_productos'] : null;
                $tipo_reporte = $this->input->post('tipo_reporte');
            }
            $where = null;
            $where_ti = null;
            $data['fecha_ini'] = $fecha_inicio;
            $data['fecha_fin'] = $fecha_fin;            
            if ($tipo != null && $tipo_proceso != null) {
                //1 = entrada, 2 = Salida
                if ($tipo_proceso == 1) {
                    $where['tip_entrada'] = 1;
                    $where_ti['tip_entrada'] = 1;
                } else {
                    $where['tip_salida'] = 1;
                    $where_ti['tip_salida'] = 1;
                }
                $where_ti['moi_id_tip'] = $tipo;
            }
            if ($fecha_inicio != '' && $fecha_fin != '') {
                $where['moi_fecha_mov >='] = date('Y-m-d', strtotime($fecha_inicio));
                $where_ti['moi_fecha_mov >='] = date('Y-m-d', strtotime($fecha_inicio));
                $where['moi_fecha_mov <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                $where_ti['moi_fecha_mov <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
            }
            $where['uxb_id_usu'] = $this->tank_auth->get_user_id();
            $data['where'] = $where;
            $data['num_documento'] = $documento;
            if(trim($documento) != ''){
                $where_ti['moi_documento'] = $documento;
            }
            if ($categoria != null || true) {
                $cat = $categoria; 
                $categorias_final = array();
                $categoria_arbol = $this->inventario_model->crear_arbol($categoria, "");
                if($categoria_arbol != ''){
                    $categorias_final = explode(',', $categoria_arbol);
                    $categorias_final = array_filter($categorias_final, function ($value){
                        //se eliminan los espacios vacios
                        return !is_null($value) && $value !== '';
                    });
                    $categorias_final[] = $categoria;
                }else{
                    if ($categoria != "") {
                        $padre_x_padre = array();
                        $i = 0;
                        while ($categoria != null) {
                            if ($i == 0) {
                                $padre_x_padre[] = $categoria;
                            } else {
                                $categoria = $this->db->where('tia_id', $categoria)->get('tia_tipo_articulo')->row_array();
                                $categoria = $categoria['tia_padre'];
                                $padre_x_padre[] = $categoria;
                            }
                            $i++;
                        }
                        $padre_x_padre = array_filter($padre_x_padre, function ($value){
                            return !is_null($value) && $value !== '';
                        });
                        $categorias_final = array_reverse($padre_x_padre);
                    } else {
                        $categorias_total = $this->inventario_model->get_categorias();
                        foreach ($categorias_total as $y) {
                            $padre_del_padre = explode(',', $this->inventario_model->crear_arbol($y['tia_id'], ""));
                            $padre_del_padre = array_filter($padre_del_padre, function ($value){
                                return !is_null($value) && $value !== '';
                            });
                            if (count($padre_del_padre) > 0) {
                                $padre_del_padre[] = $y['tia_id'];
                                $categorias_final = array_merge($categorias_final, $padre_del_padre);
                            }
                        }
                    }
                }
                // $data['categoria'] = $categoria;
                if ($cat != null) {
                    $data['categoria'] = $categorias_final;
                }                
            }
            if ($productos != null) {
                $data['prod_in'] = $productos;   
            }
            $data['reporte'] = $this->inventario_model->get_movimientos($where_ti);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_documento_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('inventario/reportes/reporte_factura', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    ini_set( 'memory_limit', '1024M' );
                    ini_set('max_execution_time', '9999');
                    $data['solotitulo'] = 'true';
                    $data['titulo'] = 'Reporte por tipo de movimiento';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Documento_' . date('dmY');
                    $header_ = '<!DOCTYPE html><html><head><title>REPORTE POR TIPO DE MOVIMIENTO</title></head><body><script type="text/javascript">';
                    $header_ .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - REPORTE POR TIPO DE MOVIMIENTO";';
                    $header_ .= 'window.print();</script>';
                    $footer = '</body></html>';
                    $reporte = $header_ . $header . $html . $footer;
                    echo $reporte;die();
                    //$this->pdf->SetMargins(10, 10, 10, 50);
                    // $this->pdf->makePdf($reporte, 'P', 'Reporte_tipo_de_movimiento', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_documento_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Reporte por tipo de movimiento';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        }
    }

    function inventario_existencia() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Reporte de existencias";
            //$data['detalle'] = $this->inventario_model->get_existencias();
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data['categoria_padre'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', 'tia_nombre', 'categorias', array('tia_padre ' => null, 'tia_estado' => 1), null, null, null, true);
            $this->_cargarvista($data);
        }
    }

    
    /**
    * @author Nelson Soriano
    * @since  2019-11-26
    * @return reporte de existencias por lote
    */

    function inventario_existencia_lotes() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Reporte de existencias";
            //$data['detalle'] = $this->inventario_model->get_existencias();
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data['categoria_padre'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', 'tia_nombre', 'categorias', array('tia_padre ' => null, 'tia_estado' => 1), null, null, null, true);
            $this->_cargarvista($data);
        }
    }


    /*
     * @modified by: Mario Marquez
     * $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
     */

    function reporte_existencia($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if ($flag == 1) {
                $bodega = ($post_array['bodega'] != '') ? $post_array['bodega'] : null;
                $categoria = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
                $producto = ($post_array['producto'] != '') ? $post_array['producto'] : null;
                $lote = ($post_array['lote'] != '') ? $post_array['lote'] : null;
            } else {
                $bodega = ($post_array['filtro_bodega'] != '') ? $post_array['filtro_bodega'] : null;
                $categoria = ($post_array['filtro_categoria'] != '') ? $post_array['filtro_categoria'] : null;
                $producto = ($post_array['filtro_producto'] != '') ? $post_array['filtro_producto'] : null;
                $lote = ($post_array['filtro_lote'] != '') ? $post_array['filtro_lote'] : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            $having = null;
            //Se crean las condicionales del reporte
            if ($bodega != null) {
                $where['sar_id_bod'] = $bodega;
            }
            if ($categoria != null) {
                //Obtener padres he hijos
                $where_tia = $this->obtener_categoria_hijas($categoria);
                $where['tia_id IN('.$where_tia.')'] = null;                
            }
            if ($producto != null) {
                $where['art_id'] = $producto;
            }
            if ($lote != "") {
                $where['dee_codigo_lote'] = $lote;
            }
            //$where['uxb_id_usu'] = $this->tank_auth->get_user_id();
            $group_by = "art_id, sar_id_bod, mep_id, sector";
            $where["sar_cant_actual !="] = 0;
            
            if ($lote != null) {
                //$having .= " AND lote = "."'".$lote."'";
                $where["sar_id in (select dee_id_sar from dee_detalle_mov where dee_codigo_lote ='$lote' AND dee_id_sar = sar_id)"] = null;
            }
            $order_by = "linea,codigo";

            $data['reporte'] = $this->inventario_model->get_existencias($where, $group_by, $having, $order_by);
           // print_r($this->db->last_query()); die();
            $data['tipo_reporte'] = $tipo_reporte;
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

            $filename = 'rpt_existencias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['filename'] = $filename;
            //print_r($data);die();
            $html = $this->load->view('inventario/reportes/reporte_existencia', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'existencias';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Existencias_' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Existencias', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_existencias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Reporte de existencias';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    function reporte_existencia_lotes($flag = null) {
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        if ($_POST) {
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery. De lo contrario, se toman los filtros de impresión */
            if ($flag == 1) {
                $bodega = ($post_array['bodega'] != '') ? $post_array['bodega'] : null;
                $categoria = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
                $producto = ($post_array['producto'] != '') ? $post_array['producto'] : null;
                $lote = ($post_array['lote'] != '') ? $post_array['lote'] : null;
            } else {
                $bodega = ($post_array['filtro_bodega'] != '') ? $post_array['filtro_bodega'] : null;
                $categoria = ($post_array['filtro_categoria'] != '') ? $post_array['filtro_categoria'] : null;
                $producto = ($post_array['filtro_producto'] != '') ? $post_array['filtro_producto'] : null;
                $lote = ($post_array['filtro_lote'] != '') ? $post_array['filtro_lote'] : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            //Se crean las condicionales del reporte
            if ($bodega != null) {
                $where['bod_id'] = $bodega;
            }
            if ($categoria != null) {
                //Obtener padres he hijos
                $where_tia = $this->obtener_categoria_hijas($categoria);
                $where['tia_id IN('.$where_tia.')'] = null;                
            }
            if ($producto != null) {
                $where['art_id'] = $producto;
            }
            if ($lote != "") {
                $where['dee_codigo_lote'] = $lote;
            }
            //$where['uxb_id_usu'] = $this->tank_auth->get_user_id();
            $group_by = "dee_codigo_lote";
            $where["sar_cant_actual > 0 "] = null;
            if ($lote != null) {
                //$having .= " AND lote = "."'".$lote."'";
                //$where["sar_id in (select dee_id_sar from dee_detalle_mov where dee_codigo_lote ='$lote' AND dee_id_sar = sar_id)"] = null;
            }
            $order_by = "linea,codigo";
            $data['reporte'] = $this->inventario_model->get_existencias_lotes($where, $group_by, $having, $order_by);
            $data['tipo_reporte'] = $tipo_reporte;
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $filename = 'rpt_existencias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('inventario/reportes/reporte_existencia_lotes', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'existencias';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Existencias_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Existencias', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_existencias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Reporte de existencias';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
        }
    }

    function inventario_proveedor() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['proveedor']       = $this->inventario_model->proveedor_con_mov();
            $data["titulo_personal"] = "Reporte de proveedores";
            //$data['detalle']=$this->inventario_model->consultaxproveedor();
            $this->_cargarvista($data);
        }
    }

    function productos_proximos_a_vencer() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data["titulo_personal"] = "Reporte de productos próximos a vencer";
            //$data['detalle']=$this->inventario_model->consultaxproveedor();
            $cadena = date('Y-m-d') . '##' . $this->tank_auth->get_user_id();
            $this->gsatelite->actualizar_array('par_parametro', array('par_valor' => $cadena), array('par_codigo' => 'AUDITORIA_VERIFICACION_VENCIMIENTO_PRODUCTOS'));

            $this->_cargarvista($data);
        }
    }

    function get_reporte_productos_a_vencer() {
        //echo print_r($_POST);
        satelite_validar();
        //$html_header  = $this->load->view('reporte/header', array('titulo' => 'Productos próximos a vencer'), true);

        $f1 = date('Y-m-d 00:00:00', strtotime($this->input->post('desde')));
        $f2 = date('Y-m-d 23:59:59', strtotime($this->input->post('hasta')));
        $bodega = $this->input->post('bodega');
        $bodega2 = $this->input->post('bod');

        $tipo = $this->input->post('tipo');
        $where = array();
        if ($this->input->post('desde') != "" and $this->input->post('hasta') != "") {
            $where['sar_fecha_caducidad >='] = $f1;
            $where['sar_fecha_caducidad <='] = $f2;
        }

        if ($bodega != "") {
            $where['sar_id_bod'] = $bodega;
        } else {
            if ($bodega2 != "") {
                $where['sar_id_bod'] = $bodega2;
            }
        }
        $where['sar_cant_actual >'] = 0;

        $us = $this->tank_auth->get_user_id();
        $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
        $titulo = "productos próximos a vencer";
        $encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);

        $data['consulta'] = $this->inventario_model->get_productos_a_vencer('sar_saldo_articulo', $where);
        if ($tipo == 1) {
            $data['table_header'] = $encabezado;
        }
        $html = $this->load->view('inventario/reportes/get_reporte_productos_a_vencer', $data, true);
        if ($tipo == null or $tipo == "") {
            //  echo $html;
            echo json_encode(array('resultado' => $html));
        } else if ($tipo == 2) {
            $this->pdf->reportePDF('inventario/reportes/get_reporte_productos_a_vencer.php', $data, 'productos próximos a vencer');
        } else {
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=productos_proximos_a_vencer.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
        }
    }

    public function consultaxproveedor() {        
        $fecha_inicio = $this->input->post('fecha_ini');
        $fecha_fin    = $this->input->post('fecha_fin');
        $categoria    = ($this->input->post('categoria') > 0) ? $this->input->post('categoria') : null;
        $productos    = ($this->input->post('productos') != '') ? implode(',', $this->input->post('productos')) : null;
        $rpt          = $this->input->post('rpt');               
        $tipo_producto          = $this->input->post('tipo_producto');

        if (is_array($this->input->post('proveedor')) && count($this->input->post('proveedor')) > 0) {
            $proveedor = implode(',', $this->input->post('proveedor'));
        } else {
            $proveedor = ($this->input->post('proveedor') != '') ? $this->input->post('proveedor') : null;
        }                 
        $where        = null;
        if ($fecha_inicio != '' && $fecha_fin != null) {
            $fecha_inicio  = date('Y-m-d', strtotime($fecha_inicio));
            $fecha_fin     = date('Y-m-d', strtotime($fecha_fin));
            $where["DATE(moi_fecha_mov) >="] = $fecha_inicio;
            $where["DATE(moi_fecha_mov) <="] = $fecha_fin;
        }
        if ($categoria != null) {
            $where["IFNULL(tia_padre,tia_id)"] = $categoria;
        }
        if ($productos != null) {
            $in = $productos;
        }
        if ($tipo_producto != null && $tipo_producto != '') {
            $where["art_tipo"] = $tipo_producto;
        }        
        $data['rpt'] = $rpt;
        $data['t_rpt'] = "";
        $data['datos'] = $this->inventario_model->consultaxproveedor($proveedor, $where, $in);
        $html = $this->load->view('inventario/reportes/consulta_proveedores', $data, true);
        echo json_encode(array('resultado' => $html));
    }

    function inventario_proveedor_costos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_padre' => null,'tia_estado' => 1), null, null, null, true);
            $proveedores = $this->inventario_model->proveedor_con_mov();

            $data['categorias'] = $categorias;            
            $data['proveedor'] = $proveedores;
            $data["titulo_personal"] = "Reporte de proveedores y costos";
            //$data['detalle']=$this->inventario_model->consultaxproveedor();
            $this->_cargarvista($data);
        }
    }

    function inventario_prod_sin_mov() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data['titulo_personal'] = "Reporte de productos sin movimiento";
            $this->_cargarvista(null, $data);
        }
    }

    function inventario_codigo() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data['titulo_personal'] = "Reporte por bodega";
            $this->_cargarvista(null, $data);
        }
    }

    /*
    * @author Raul E.
    * @since 2020-ago
    * @return reporte inventario_codigo SIN costos
    */
    function bodega_sin_costo() {
        satelite_validar();
        $data['bodega'] = $this->inventario_model->usuarioxbodega();
        $data['titulo_personal'] = "Reporte por bodega";
        $this->_cargarvista(null, $data);
    }

    function categoria_departamento() {
        $padre = $this->input->post('departamento_sel');
        $categorias = $this->inventario_model->get_categorias_hijas($padre);
        $var = '<option value="">Seleccione una opción</option>';


        foreach ($categorias as $key => $fila) {
            $var .= "<option value='" . $fila['tia_id'] . "'>" . $fila['tia_nombre'] . "</option>";
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function cuerpo_busquedaxfurgon($informacion) {
        //  $ndecimales =  $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $ndecimales = 2;

        $entrada = 0;
        $salida = 0;
        $saldo = 0;
        $cadena = "";
        foreach ($informacion as $key) {
            //$cadena.='<tr><td>'.$key['bodega'].'</td>';
            $cadena .= '<td style="text-align:left;">' . $key['codigo'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['nombre'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['caja'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['cantidad'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['UM'] . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Entradas'], $ndecimales) . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Salidas'], $ndecimales) . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Saldo'], $ndecimales) . '</td>';
            $entrada += (int) $key['Entradas'];
            $salida += (int) $key['Salidas'];
            $saldo += (int) $key['Saldo'];
            if (!empty($key['foto'])) {
                $cadena .= '<td><div class="controls center"><input type="checkbox"  name="' . $key['foto'] . '" id="' . $key['foto'] . '" class="ibuttonCheck nostyle" /></div></td></tr>';
            } else {
                $cadena .= '<td style="text-align:center;">No posee</td></tr>';
            }
        }

        $cadena .= '<tr><td colspan="5"><b>Total:</b></td><td style="text-align: right;"><b>' . number_format($entrada, $ndecimales) . '</b></td><td style="text-align: right;"><b>' . number_format($salida, $ndecimales) . '</b></td><td style="text-align: right;"><b>' . number_format($saldo, $ndecimales) . '</b></td><td></td></tr>';

        return $cadena;
    }

    function busquedaxfurgon() {


        $cabezera = '<tr>';
        //$cadena.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Código</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Nombre</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">No. Caja</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Cant/Caja</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">UM</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Entradas</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Salidas</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Saldo</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Imagen</th>';
        $cabezera .= '</tr>';

        $cabezera = '<tr>';
        //$cadena.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Código</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Nombre</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">No. Caja</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Cant/Caja</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">UM</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Entradas</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Salidas</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Saldo</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Imagen</th>';
        $cabezera .= '</tr>';

        /* ---------------- Parametros de busqueda ---------------------------- */
        $bodega = $this->input->post('bodega');
        $ultima_categoria = $this->input->post('categoria');
        $furgon = $this->input->post('furgon');
        $codigo = $this->input->post('cod_art');

        //estructurar el encabezado del furgon
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $html_furgon = '<h3>Contenedor: ' . @$furgon . '</h3> <br/>';
        } else {
            $html_furgon = '';
        }


        //var_dump($this->input->post('categoria'));exit();
        //
            /* -------------------------------------------------------------------- */

        /* ------------- condiciones para la busqueda por codigo -------------- */

        $cod_art = ($codigo == "") ? null : $codigo;

        /* --------------- Encontrar dependencias de ultima categoria --------- */



        $padre_del_padre = array();
        $i = 0;
        if ($ultima_categoria == "") {

            $categorias_total = $this->inventario_model->get_categorias();
            foreach ($categorias_total as $y) {
                $padre_del_padre[] = $y['tia_id'];
            }
            array_push($padre_del_padre, '');
        } else {
            while ($ultima_categoria != null) {
                if ($i == 0) {
                    $padre_del_padre[] = $ultima_categoria;
                } else {
                    $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria = $ultima_categoria['tia_padre'];
                    $padre_del_padre[] = $ultima_categoria;
                }
                $i++;
            }
        }

        $categorias_final = array_reverse($padre_del_padre);
        //print_r($categorias_final);exit();

        /* -------------------------------------------------------------------- */


        /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */

        $cadena = ""; // arreglo que mandaremos en un json
        $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

        foreach ($categorias_final as $key => $value) {
            if ($key != "") {
                $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
            }
        }

        //print_r($elementos);exit();

        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 11;
        } else {
            $col = 8;
        }

        $ultimo_padre = end($elementos);
        //print_r($ultimo_padre);exit();
        $departamento_inf_tr = "";
        $departamento_infe_tr = "";
        $i = 1;
        $cabeza = 0;
        $ids_cat_consultados = array();
        foreach ($elementos as $key => $value) {
            foreach ($value as $ids => $valores) {


                /* if($ids!=key($ultimo_padre)){

                  $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                  }else{ */

                $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);


                if (count($tia_hijo) > 0) {
                    $departamento_infe_tr = '<tr style="background-color:#F0F0F0;"><td colspan="' . $col . '"><b><br />Departamento : ' . $valores . '</b></td></tr>';

                    //$departamento_inf_tr.=$departamento_infe_tr;
                    foreach ($tia_hijo as $tia => $tipo) {

                        //preguntar si posee articulos y saber si es padre o no.
                        $pre = $this->gsatelite->get_tabla('art_articulo', array('art_id_tia' => end($categorias_final)));

                        if (count($pre) <= 0) {

                            $tipo_id_tia = $tipo['tia_id'];
                        } else {
                            $tipo_id_tia = end($categorias_final);
                        }


                        if (!in_array($tipo_id_tia, $ids_cat_consultados)) {

                            $informacion = $this->inventario_model->consultaxdep($tipo_id_tia, $bodega, $furgon, $cod_art);

                            //die($this->db->last_query());

                            $reg_tia = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id' => $tipo_id_tia));
                            $ids_cat_consultados[] = $tipo_id_tia;
                            //print_r($this->db->last_query());exit();
                            if (count($informacion) > 0 && $cabeza < 1) {
                                $departamento_inf_tr .= $departamento_infe_tr;
                                $cabeza++;
                            }

                            if (count($informacion) > 0) {
                                $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $reg_tia[0]['tia_nombre'] . '</b></td></tr>';
                                $departamento_inf_tr .= $cabezera;
                                $departamento_inf_tr .= $this->cuerpo_busquedaxfurgon($informacion);
                            }
                        }
                    }
                } else {
                    //preguntar si los datos fueron ya consultados en el for de arriba.
                    if (!in_array($ids, $ids_cat_consultados)) {
                        $informacion = $this->inventario_model->consultaxfurgon($ids, $furgon, $bodega, $cod_art);

                        if (count($informacion) > 0) {

                            $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $valores . '</b></td></tr>';
                            $departamento_inf_tr .= $cabezera;
                            $departamento_inf_tr .= $this->cuerpo_busquedaxfurgon($informacion);
                        }
                    }
                }
                //}
            }
            $cabeza = 0;

            $i++;
        }




        $cadena .= $departamento_inf_tr;

        $arreglo = array(
            "drop" => $cadena,
            "furgon_name" => $html_furgon
        );

        echo json_encode($arreglo);
    }

    function cuerpo_busqueda_produc_sin_movimiento($informacion, $aplica_imagen = true) {
        $resta_aplicar_img = ($aplica_imagen) ? 0 : 1;
        $entrada = 0;
        $salida = 0;
        $saldo = 0;
        $cadena = "";
        $mostrar = 0;
        foreach ($informacion as $key) {
            if ($key['Salidas'] == 0) {
                //$cadena.='<tr><td>'.$key['bodega'].'</td>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<tr>';
                    $cadena .= '<td style="text-align:center;">' . $key['furgon'] . '</td>';
                } else {
                    $cadena .= '<tr>';
                }
                $cadena .= '<td style="text-align:center;">' . $key['nombre'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $key['codigo'] . '</td>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<td style="text-align:center;">' . $key['caja'] . '</td>';
                    $cadena .= '<td style="text-align:center;">&nbsp;' . number_format($key['cantidad'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                }
                $cadena .= '<td style="text-align:center;">' . $key['UM'] . '</td>';
                //  $cadena.='<td style="text-align:center;">&nbsp;'.number_format($key['Entradas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                //$cadena.='<td style="text-align:center;">&nbsp;'.number_format($key['Salidas'],$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $cadena .= '<td style="text-align:center;">&nbsp;' . number_format($key['Saldo'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';


                $entrada += (int) $key['Entradas'];
                $salida += (int) $key['Salidas'];
                $saldo += (int) $key['Saldo'];
                if ($aplica_imagen) {
                    if (!empty($key['foto'])) {
                        $cadena .= '<td><div class="controls center"><input type="checkbox"  name="' . $key['foto'] . '" id="' . $key['foto'] . '" class="ibuttonCheck nostyle" /></div></td>';
                        $cadena .= '</tr>';
                    } else {
                        $cadena .= '<td style="text-align:center;">No posee</td>';
                        $cadena .= '</tr>';
                    }
                } else {
                    $cadena .= '</tr>';
                }

                $mostrar++;
            }
        }
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 5 - $resta_aplicar_img;
        } else {
            $col = 3 - $resta_aplicar_img;
        }

        //die(print_r($resta_aplicar_img));
        $cadena .= '<tr><td colspan="' . ($col + 1) . '"><b>Total:</b></td>';
        //    $cadena.='<td style="text-align: center;"><b>'.number_format($entrada,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td>';
        //   $cadena.='<td style="text-align: center;"><b>'.number_format($salida,$this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</b></td>';
        $cadena .= '<td style="text-align: center;"><b>' . number_format($saldo, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td></tr>';


        $datos = array('cadena' => $cadena, 'data' => $mostrar);
        return $cadena;
    }

    function busqueda_produc_sin_movimiento2($regresa_html = false, $aplica_imagen = true, $datos_externos = null) {
        $resta_aplicar_img = ($aplica_imagen) ? 0 : 1;
        $cadena = "";
        $cabezera = '';
        //depende del regresar_html nos pone el head con thead o con tr para el reporte
        if(!$regresa_html){
            $cabezera = '<thead>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cabezera .= '<th style="text-align:center; font-weight:bold; width:5+0%;"><b>Contenedor</b></th>';
            }
            $cabezera .= '<th style="text-align:center; font-weight:bold;"><strong>Códigos</strong></th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>Producto</b></th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>Lote</b></th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>Marca</b></th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>Fecha Inicio <br /> Compra</b></th>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>No. Caja</b></th>';
                $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>Cant/Caja</b></th>';
            }
            $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>UM</b></th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;"><b>Cantidad</b></th>';
            //  $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            if ($aplica_imagen == 1) {
                //  $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
                //$cabezera .= '<th style="text-align:center; font-weight:bold;">Imagen</th>';
            } else if ($aplica_imagen == 0) {
                //  $cabezera.='<th style="text-align:center; font-weight:bold; border-right: 1px solid #120707;">Saldo</th>';
            }
            $cabezera .= '</thead>';
        } else{
            $cabezera = '<tr>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cabezera .= '<th style="text-align:center; font-weight:bold; width:5+0%;">Contenedor</th>';
            }
            $cabezera .= '<th style="text-align:center; font-weight:bold !important;"><strong>Código</strong></th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Producto</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Lote</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Marca</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Fecha Inicio <br /> Compra</th>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cabezera .= '<th style="text-align:center; font-weight:bold;">No. Caja</th>';
                $cabezera .= '<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
            }
            $cabezera .= '<th style="text-align:center; font-weight:bold;">UM</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Cantidad</th>';
            //  $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';
            if ($aplica_imagen == 1) {
                //  $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
                //$cabezera .= '<td style="text-align:center; font-weight:bold;">Imagen</td>';
            } else if ($aplica_imagen == 0) {
                //  $cabezera.='<th style="text-align:center; font-weight:bold; border-right: 1px solid #120707;">Saldo</th>';
            }
            $cabezera .= '</tr>';
        }
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 13 - $resta_aplicar_img;
        } else {
            $col = 8 - $resta_aplicar_img;
        }
        if ($datos_externos) {
            $bodega    = $datos_externos['bodega'];
            $categoria = ($datos_externos['hidden_cat'] > 0) ? $datos_externos['hidden_cat'] : "";
            $fecha_ini = ($datos_externos['fecha_ini'] != '') ? $datos_externos['fecha_ini'] : null;
            $fecha_fin = ($datos_externos['fecha_fin'] != '') ? $datos_externos['fecha_fin'] : null;
            $productos = (isset($datos_externos['slcProduct']) && count($datos_externos['slcProduct']) > 0) ? implode(',', $datos_externos['slcProduct']) : null;
        } else {
            $bodega    = $this->input->post('bodega');
            $categoria = $this->input->post('categoria');
            $fecha_ini = ($this->input->post('fecha_ini') != '') ? $this->input->post('fecha_ini') : null;
            $fecha_fin = ($this->input->post('fecha_fin') != '') ? $this->input->post('fecha_fin') : null;
            $productos = (count($this->input->post('productos')) > 0) ? implode(',', $this->input->post('productos')) : null;
        }
        //filtra las categorias si se escoge en el filtro de categorias
        $ids_tia = array();
        $nombres_tia = array();
        $categorias_final = array();
        $categoria_arbol = $this->inventario_model->crear_arbol($categoria, "");
        if($categoria_arbol != ''){
            $categorias_final = explode(',', $categoria_arbol);
            //se eliminan los espacios vacios
            $categorias_final = array_filter($categorias_final, function ($value){
                return !is_null($value) && $value !== '';
            });
            $categorias_final[] = $categoria;
        }else{
            if ($categoria != "") {
                $padre_x_padre = array();
                $i = 0;
                while ($categoria != null) {
                    if ($i == 0) {
                        $padre_x_padre[] = $categoria;
                    } else {
                        $categoria = $this->db->where('tia_id', $categoria)->get('tia_tipo_articulo')->row_array();
                        $categoria = $categoria['tia_padre'];
                        $padre_x_padre[] = $categoria;
                    }
                    $i++;
                }
                $padre_x_padre = array_filter($padre_x_padre, function ($value){
                    return !is_null($value) && $value !== '';
                });
                $categorias_final = array_reverse($padre_x_padre);
            } else {
                $categorias_total = $this->inventario_model->get_categorias();
                foreach ($categorias_total as $y) {
                    $padre_del_padre = explode(',', $this->inventario_model->crear_arbol($y['tia_id'], ""));
                    $padre_del_padre = array_filter($padre_del_padre, function ($value){
                        return !is_null($value) && $value !== '';
                    });
                    if (count($padre_del_padre) > 0) {
                        $padre_del_padre[] = $y['tia_id'];
                        $categorias_final = array_merge($categorias_final, $padre_del_padre);
                    }
                }
            }
        }
        // var_dump($categorias_final);die();
        foreach ($categorias_final as $key) {
            $categorias_total = $this->inventario_model->get_tias(array('tia_id' => $key));
            $ids_tia[] = $categorias_total[0]['tia_id'];
            $nombres_tia[] = $categorias_total[0]['tia_nombre'];
        }
        //array para almacenar los registros sin movimiento
        $arreglo_valores = array();
        $arreglo_valores2 = array();
        $tia_nombre_temp = '-1';
        $contador_total = 0;
        //nos devuelve todos los productos por bodega
        $where['sar_id_bod'] = $bodega;
        if ($fecha_ini != null) {
            $where['moi_fecha_mov >='] = date("Y-m-d", strtotime($fecha_ini)) . ' 00:00:00';
        }
        if ($fecha_fin != null) {
            $where['moi_fecha_mov <='] = date("Y-m-d", strtotime($fecha_fin)) . ' 23:59:59';
        }
        if ($productos != null) {
            $in = $productos;   
        }
        $productos_reg = $this->inventario_model->get_productos_sn_exist($where,$in);
        foreach ($productos_reg as $n => $key) {
            //si salida del producto es 0 se considera sin movimiento
            if($key['salidas'] == 0){
                //obtenemos la categoria padre del producto para asociarlo a un arreglo con el id del padre
                $tia_hijo = $this->obtener_padre($key['tia_id']);// $tia_hijo['id_tia']                
                if (in_array($key['tia_id'], $ids_tia)) { // la categoria padre de la categoria debe estar en la lista de productos
                    $valores = array('tia_id'=>$key['tia_id'], 'tia_padre'=>$key['tia_padre'], 'tia_nombre'=>$key['tia_nombre'], 'art_nombre'=>$key['art_nombre'],
                        'cantidad'=>$key['entradas'], 'art_codigo'=>$key['art_codigo'],'lote'=>$key['lote'],'fecha'=>$key['fecha'], 'mep_nombre'=>$key['mep_nombre'], 
                        'foto'=>$key['art_foto'], 'marca'=>$key['marca']);
                    $arreglo_valores[$tia_hijo['id_tia']][$n] = $valores;
                    if (!(array_key_exists($tia_hijo['id_tia'], $arreglo_valores2))) {
                        $arreglo_valores2[$tia_hijo['id_tia']] = array('tia_id'=> $tia_hijo['id_tia'], 'tia_nombre'=>$tia_hijo['nombre_tia']);
                    }
                }
            }
        }
        // var_dump($arreglo_valores);
        // var_dump($arreglo_valores2);
        // die();

        $data['col'] = $col;
        $data['categoria'] = $categoria;
        $data['aplica_imagen'] = $aplica_imagen;
        $data['regresa_html'] = $regresa_html;
        $data['cabezera'] = $cabezera;
        $data['arreglo_valores'] = $arreglo_valores;
        $data['arreglo_valores2'] = $arreglo_valores2;
        $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        // var_dump($data);die();
        $tabla = $this->load->view('inventario/reportes/imprimir_reporte_inventario_sin_mov', $data, true);
        if ($regresa_html) {
            return $tabla;
        } else {
            echo json_encode(array("drop" => $tabla));
        }
    }

    function busqueda_produc_sin_movimiento($regresa_html = false, $aplica_imagen = true) {
        $resta_aplicar_img = ($aplica_imagen) ? 0 : 1;
        $cadena = "";

        $cabezera = '<tr>';


        $cabezera .= '<th style="text-align:center; font-weight:bold; border-left: 1px solid #120707;">Producto</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Código</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">UM</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Entradas</th>';
        //  $cabezera.='<th style="text-align:center; font-weight:bold;">Salidas</th>';

        if ($aplica_imagen == 1) {
            //  $cabezera.='<th style="text-align:center; font-weight:bold;">Saldo</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;border-right: 1px solid #F0F0F0;">Imagen</th>';
        } else if ($aplica_imagen == 0) {
            //  $cabezera.='<th style="text-align:center; font-weight:bold; border-right: 1px solid #120707;">Saldo</th>';
        }
        $cabezera .= '</tr>';
        $col = 7 - $resta_aplicar_img;

        /* ---------------- Parametros de busqueda ---------------------------- */
        $bodega = $this->input->post('bodega');
        $ultima_categoria = $this->input->post('categoria');
        /* -------------------------------------------------------------------- */


        /* --------------- Encontrar dependencias de ultima categoria --------- */
        $padre_del_padre = array();
        $i = 0;
        if ($ultima_categoria == "") {
            $categorias_total = $this->inventario_model->get_categorias();
            foreach ($categorias_total as $y) {
                $padre_del_padre[] = $y['tia_id'];
            }
            array_push($padre_del_padre, '');
        } else {

            while ($ultima_categoria != null) {
                if ($i == 0) {
                    $padre_del_padre[] = $ultima_categoria;
                } else {
                    $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria = $ultima_categoria['tia_padre'];
                    $padre_del_padre[] = $ultima_categoria;
                }
                $i++;
            }
        }
        $categorias_final = array_reverse($padre_del_padre);

        /* -------------------------------------------------------------------- */


        /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */

        $cadena = ""; // arreglo que mandaremos en un json
        $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

        foreach ($categorias_final as $key => $value) {
            if ($key != null) {
                $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
            }
        }


        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 10 - $resta_aplicar_img;
        } else {
            $col = 7 - $resta_aplicar_img;
        }
        $ultimo_padre = end($elementos);

        $departamento_inf_tr = "";
        $departamento_infe_tr = "";
        //$departamento_inf_tr="";
        $i = 1;
        $cabeza = 0;
        foreach ($elementos as $key => $value) {
            foreach ($value as $ids => $valores) {

                // print_r($_POST);exit();
                /* if($ids!=key($ultimo_padre)){

                  $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                  }else{ */

                $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);

                // $departamento_inf_tr.=$cabezera;
                if (count($tia_hijo) > 0) {
                    $departamento_infe_tr = '<tr style="background-color:#DDDDDD;"><td colspan="' . ($col - 2) . '"><b><br />Departamento ' . $i . ': ' . $valores . '</b></td></tr>';
                    //$departamento_inf_tr.=$departamento_infe_tr;
                    foreach ($tia_hijo as $tia => $tipo) {
                        $informacion = $this->inventario_model->consultaxdep($tipo['tia_id'], $bodega, '', 3);
                        //  print_r($this->db->last_query());exit();
                        if (count($informacion) > 0 && $cabeza < 1) {
                            $departamento_inf_tr .= $departamento_infe_tr;
                            $cabeza++;
                        }

                        if (count($informacion) > 0) {
                            $departamento_inf_tr .= '<tr><td colspan="' . ($col - 2) . '"><b><br />Categoría ' . $i . ': ' . $tipo['tia_nombre'] . '</b></td></tr>';
                            // $departamento_inf_tr.=$cabezera;
                            $departamento_inf_tr .= $this->cuerpo_busqueda_produc_sin_movimiento($informacion, $aplica_imagen);
                        }
                    }
                } else {
                    $informacion = $this->inventario_model->consultaxdep($ids, $bodega, '', 3);

                    // die(print_r(count($informacion)));
                    if (count($informacion) > 0) {
                        $departamento_inf_tr .= '<tr><td colspan="' . ($col - 2) . '"><b><br />Categoría ' . $i . ': ' . $valores . '</b></td></tr>';
                        $registro = count($this->cuerpo_busqueda_produc_sin_movimiento($informacion, $aplica_imagen));

                        // $departamento_inf_tr.=$cabezera;
                        $departamento_inf_tr .= $cabezera;
                        $departamento_inf_tr .= $this->cuerpo_busqueda_produc_sin_movimiento($informacion, $aplica_imagen);
                    }
                }
                //}
            }
            $cabeza = 0;
            $i++;
        }


        $cadena = $departamento_inf_tr;

        $arreglo = array(
            "drop" => $cadena
        );

        if ($regresa_html) {
            return $cadena;
        } else {
            echo json_encode($arreglo);
        }
    }

    function obtener_padre($tia_id){
        $registros = $this->inventario_model->get_papa_tia(array('tia_id'=>$tia_id));
        $tia_id = $registros[0]['tia_id'];
        $tia_padre = $registros[0]['tia_padre'];
        $tia_nombre = $registros[0]['tia_nombre'];
        if($tia_padre != null){
            do{
                $registros = $this->inventario_model->get_papa_tia(array('tia_id'=>$tia_padre));
                $tia_id = $registros[0]['tia_id'];
                $tia_padre = $registros[0]['tia_padre'];
                $tia_nombre = $registros[0]['tia_nombre'];
            } while ($tia_padre != null);
        }
        //echo $tia_nombre;
        return array('id_tia'=>$tia_id,'nombre_tia'=>$tia_nombre);
    }

    function ver_imagen($foto = null) {
        if (!empty($foto)) {
            $data['imagen'] = "<img src=" . base_url('/assets/uploads/images/' . $foto) . ">";
        } else {
            $data['imagen'] = "El artículo no posee fotografia";
        }
        $this->load->view('inventario/reportes/ver_imagen', $data);
    }

    function cuerpo_busquedaxdepartamento($informacion) {

        $ndecimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!=null)?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

        $entrada = 0;
        $salida = 0;
        $saldo = 0;
        $cadena = "";
        foreach ($informacion as $key) {
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cadena .= '<tr class="odd gradeX"><td style="text-align:left;">' . $key['furgon'] . '</td>';
            }
            $cadena .= '<td style="text-align:left;">' . $key['codigo'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['nombre'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['marca'] . '</td>';
            if ($this->gsatelite->get_parametro('SYS_LISTADO_PRECIO') != 0) { // Precios de pdv
                //$cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/reportes/ver_precios/' . $key['id_sar'] . '">Ver precios</a></td>';
            } else if ($this->gsatelite->get_parametro('SYS_LISTADO_PRECIO') == 0) {
                //$cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/reportes/ver_precios_listado/' . $key['id_art'] . '/' . $key['id_um'] . '">Ver precios</a></td>';
            }
            $cadena .= '<td style="text-align:left;">' . $key['UM'] . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Entradas'], $ndecimales) . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Salidas'], $ndecimales) . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Saldo'], $ndecimales) . '</td>';
            $entrada += $key['Entradas'];
            $salida += $key['Salidas'];
            $saldo += $key['Saldo'];

            if (!empty($key['foto'])) {
                //$cadena .= '<td><div class="controls center"><input type="checkbox"  name="' . $key['foto'] . '" id="' . $key['foto'] . '" class="ibuttonCheck nostyle" /></div></td>';
                $cadena .= '</tr>';
            } else {
               //$cadena .= '<td style="text-align:center;">No posee</td>';
                $cadena .= '</tr>';
            }
        }

        $col = 4;


        $cadena .= '<tr><td colspan="' . $col . '" style="text-align: right;"><b>Total:</b></td>';
        $cadena .= '<td style="text-align: right;"><b>' . number_format($entrada, $ndecimales) . '</b></td>';
        $cadena .= '<td style="text-align: right;"><b>' . number_format($salida, $ndecimales) . '</b></td>';
        $cadena .= '<td style="text-align: right;"><b>' . number_format($saldo, $ndecimales) . '</b></td></tr>';

        return $cadena;
    }

    function busquedaxdepartamento() {
        $cabezera = '<tr>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Código</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Producto</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">Marca</th>';
        //$cabezera .= '<th style="text-align:left; font-weight:bold;">Precios</th>';
        $cabezera .= '<th style="text-align:left; font-weight:bold;">UM</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Entradas</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Salidas</th>';
        $cabezera .= '<th style="text-align:right; font-weight:bold;">Saldo Actual</th>';
        //$cabezera .= '<th style="text-align:right; font-weight:bold;">Imagen</th>';
        $cabezera .= '</tr>';
        $furgon = "";
        /* ---------------- Parametros de busqueda ---------------------------- */
        $bodega = $this->input->post('bodega');
        $ultima_categoria = $this->input->post('categoria');
        $codigo = $this->input->post('cod_art');
        /* ------------- condiciones para la busqueda por codigo -------------- */
        $cod_art = ($codigo == "") ? null : $codigo;
        /* --------------- Encontrar dependencias de ultima categoria --------- */
        $categorias_final = array();
        $padre_x_padre = array();
        $i = 0;
        $categoria_arbol = $this->inventario_model->crear_arbol($ultima_categoria, "");
        if($categoria_arbol != ''){
            $categorias_final = explode(',', $categoria_arbol);
            $categorias_final = array_filter($categorias_final, function ($value){ return !is_null($value) && $value !== ''; });
            $categorias_final[] = $ultima_categoria;
        }else{
            if ($ultima_categoria != "") {
                $arbol_cat = $this->inventario_model->crear_arbol($ultima_categoria);
                $categorias_split = explode(',',$arbol_cat);
                for($k = 0; $k < count($categorias_split); $k++){
                    if($categorias_split[$k] != ''){
                        $padre_x_padre[] = $categorias_split[$k];
                    }
                }
                // while ($ultima_categoria != null) {
                    if ($i == 0) {
                        $padre_x_padre[] = $ultima_categoria;
                    } else {
                        $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                        $ultima_categoria = $ultima_categoria['tia_padre'];
                        $padre_x_padre[] = $ultima_categoria;
                    }
                    $i++;
                // }
                // $padre_x_padre = array_filter($padre_x_padre, function ($value){
                //     return !is_null($value) && $value !== '';
                // });
                $categorias_final = $padre_x_padre;
            } else {
                $categorias_total = $this->inventario_model->get_categorias($bodega);
                foreach ($categorias_total as $y) {
                    $padre_x_padre[] = $y['tia_id'];                    
                    // $padre_del_padre = explode(',', $this->inventario_model->crear_arbol($y['tia_id'], ""));
                    // $padre_del_padre = array_filter($padre_del_padre, function ($value){ return !is_null($value) && $value !== ''; });
                    // if (count($padre_del_padre) > 0) {
                    //     $padre_del_padre[] = $y['tia_id'];
                    //     $categorias_final = array_merge($categorias_final, $padre_del_padre);
                    // }
                }
                // array_push($padre_x_padre, '');
                $categorias_final = $padre_x_padre;
            }
        }
        
        //print_r($categorias_final);die();
        /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */
        $cadena = ""; // arreglo que mandaremos en un json
        $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije
        foreach ($categorias_final as $key => $value) {
            if ($value != "") {
                $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
            }
        }
        //print_r($elementos);die();
        $col = 7;
        // $ultimo_padre = end($elementos);
        $departamento_inf_tr = "";
        $departamento_infe_tr = "";
        $i = 1;
        $cabeza = 0;
        $ids_cat_consultados = array();
        foreach ($elementos as $key => $value) {
            foreach ($value as $ids => $valores) {
                $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);
                if (count($tia_hijo) > 0) {
                    foreach ($tia_hijo as $tia => $tipo) {
                        //preguntar si posee articulos y saber si es padre o no.
                        $pre = $this->gsatelite->get_tabla('art_articulo', array('art_id_tia' => end($categorias_final)));
                        // if (count($pre) <= 0) {
                            $tipo_id_tia = $tipo['tia_id'];
                        // } else {
                        //     $tipo_id_tia = end($categorias_final);
                        // }
                        if (!in_array($tipo_id_tia, $ids_cat_consultados)) {
                            $informacion = $this->inventario_model->consultaxcategoria_productos($tipo_id_tia, $bodega, $furgon, $cod_art);
                            $reg_tia = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id' => $tipo_id_tia));
                            $ids_cat_consultados[] = $tipo_id_tia;
                            if (count($informacion) > 0 && $cabeza < 1) {
                                $departamento_inf_tr .= $departamento_infe_tr;
                                $cabeza++;
                            }

                            if (count($informacion) > 0) {
                                $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $reg_tia[0]['tia_nombre'] . '</b></td></tr>';
                                $departamento_inf_tr .= $cabezera;
                                $departamento_inf_tr .= $this->cuerpo_busquedaxdepartamento($informacion);

                            }
                        }
                    }
                } else {
                    //preguntar si los datos fueron ya consultados en el for de arriba.
                    if (!in_array($ids, $ids_cat_consultados)) {
                        $informacion = $this->inventario_model->consultaxcategoria_productos($ids, $bodega, $furgon, $cod_art);
                        if (count($informacion) > 0) {
                            //echo($this->db->last_query()) ."<br/>";
                            $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $valores . '</b></td></tr>';
                            $departamento_inf_tr .= $cabezera;
                            $departamento_inf_tr .= $this->cuerpo_busquedaxdepartamento($informacion);
                        }
                    }
                }
            }
            $cabeza = 0;
            $i++;
        }
        // die();
        $cadena .= $departamento_inf_tr;
        $arreglo = array("drop" => $cadena);
        echo json_encode($arreglo);
    }

    function cuerpo_busquedaxcodigo($informacion, $ocultarCostos = 0) {
        $entrada = 0;
        $salida = 0;
        $saldo = 0;
        $total_entrada_fila = 0;
        $total_salida_fila = 0;
        $total_final_fila = 0;
        $costo_entrada = 0;
        $costo_salida = 0;
        $total_entrada = 0;
        $total_salida = 0;
        $total_saldo = 0;
        $cadena = "";
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        foreach ($informacion as $key) {
            //   $cadena.='<tr><td style="text-align:center;">'.$key['bodega'].'</td>';
            $cadena .= '<td style="text-align:center;">' . formatear_fecha('d-m-Y', $key['moi_fecha_mov']) . '</td>'; 
            $cadena .= '<td style="text-align:center;">' . $key['codigo'] . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['nombre'] . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['lote'] . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['marca'] . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['UM'] . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Entradas'], $decimales) . '</td>';
            if($ocultarCostos == 0){
                $total_entrada_fila = $key['Entradas'] * $key['precio_compra'];
                $cadena .= '<td style="text-align:right;">' . number_format($key['precio_compra'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($total_entrada_fila, $decimales) . '</td>';
            }
            $cadena .= '<td style="text-align:right;">' . number_format($key['Salidas'], $decimales) . '</td>';
            if($ocultarCostos == 0){
                $total_salida_fila = $key['Salidas'] * $key['precio_compra'];
                $cadena .= '<td style="text-align:right;">' . number_format($key['precio_compra'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($total_salida_fila, $decimales) . '</td>';
            }
            $cadena .= '<td style="text-align:right;">' . number_format($key['Saldo'], $decimales) . '</td>';
            if($ocultarCostos == 0){
                $total_final_fila = $key['Saldo'] * $key['precio_compra'];
                $cadena .= '<td style="text-align:right;">' . number_format($total_final_fila, $decimales) . '</td>';
            }
            $entrada += $key['Entradas'];
            $salida += $key['Salidas'];
            $saldo += $key['Saldo'];
            $total_entrada += $total_entrada_fila;
            $total_salida += $total_salida_fila;
            $total_saldo += $total_final_fila;
            //$cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/reportes/ver_precios/' . $key['id_sar'] . '">Ver precios</a></td>';
            $cadena .= '</tr>';
        }
        $col = 6;
        $cadena .= '<tr><td colspan="' . $col . '"><b>Total:</b></td>';
        $cadena .= '<td style="text-align: right;"><b>' . number_format($entrada, $decimales) . '</b></td>';
        if($ocultarCostos == 0){
            $cadena .= '<td style="text-align: right;"><b></b></td>';
            $cadena .= '<td style="text-align: right;"><b>' . number_format($total_entrada, $decimales) . '</b></td>';
        }
        $cadena .= '<td style="text-align: right;"><b>' . number_format($salida, $decimales) . '</b></td>';
        if($ocultarCostos == 0){
            $cadena .= '<td style="text-align: right;"><b></b></td>';
            $cadena .= '<td style="text-align: right;"><b>' . number_format($total_salida, $decimales) . '</b></td>';
        }
        $cadena .= '<td style="text-align: right;"><b>' . number_format($saldo, $decimales) . '</b></td>';
        if($ocultarCostos == 0){
            $cadena .= '<td style="text-align: right;"><b>' . number_format($total_saldo, $decimales) . '</b></td>';
        }
        $cadena .= '</tr>';
        $totales_array = array(
            'cantidad_entrada' => $entrada,
            'subtotal_entrada' => $total_entrada,
            'cantidad_salida' => $salida,
            'subtotal_salida' => $total_salida,
            'cantidad_existencia' => $saldo,
            'subtotal_existencia' => $total_saldo
        );

        return array('html' => $cadena, 'totales' => $totales_array );
    }

    function busquedaxcodigo() {
        $total_entradas_general = 0;
        $total_salidas_general = 0;
        $total_entrada_costo_general = 0;
        $total_salida_general = 0;
        $total_salida_costo_general = 0;
        $total_existencia_general = 0;
        $total_saldos_costo_general = 0;
        $bodega         = $this->input->post('bodega');
        $txtFechaIni    = $this->input->post('txtFechaIni');
        $txtFechaFin    = $this->input->post('txtFechaFin');
        $ocultarCostos  = $this->input->post('ocultarCosto');//0=no=mostrar;;1=si=ocultar
        $cadena = "";
        $cabezera = '<tr>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Fecha</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Código</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Producto</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Lote</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Marca</th>';        
        $cabezera .= '<th style="text-align:center; font-weight:bold;">UM</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Entradas</th>';
        if ($ocultarCostos == 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Costo</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Total</th>';
        }
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Salidas</th>';
        if ($ocultarCostos == 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Costo</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Total</th>';
        }
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Saldo Actual</th>';
        if ($ocultarCostos == 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Costo Total</th>';
        }
        $cabezera .= '</tr>';
        /* ---------------- Parametros de busqueda ---------------------------- */
        $ultima_categoria = $this->input->post('categoria');
        /* --------------- Encontrar dependencias de ultima categoria --------- */
        $padre_del_padre = array();
        $i = 0;
        if ($ultima_categoria == "") {
            $categorias_total = $this->inventario_model->get_categorias($bodega);
            foreach ($categorias_total as $y) {
                $padre_del_padre[] = $y['tia_id'];
            }
            array_push($padre_del_padre, '');
        } else {
            $arbol_cat = $this->inventario_model->crear_arbol($ultima_categoria);
            $categorias_split = explode(',',$arbol_cat);
            for($k = 0; $k < count($categorias_split); $k++){
                if($categorias_split[$k]!=''){
                    $padre_del_padre[] = $categorias_split[$k];
                }
            }
            // while ($ultima_categoria != null) {
            if ($i == 0) {
                $padre_del_padre[] = $ultima_categoria;
            } else {
                $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                $ultima_categoria = $ultima_categoria['tia_padre'];
                $padre_del_padre[] = $ultima_categoria;
            }
            $i++;
            // }
        }
        $categorias_final = array_reverse($padre_del_padre);
        /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */
        $cadena = ""; // arreglo que mandaremos en un json
        $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije
        foreach ($categorias_final as $key => $value) {
            if ($value != "") {
                $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
            }
        }
        if ($ocultarCostos == 0) {
            $col = 14;
        } else {
            $col = 9;
        }
        $ultimo_padre = end($elementos);
        $departamento_inf_tr = "";
        $departamento_infe_tr = "";
        $i = 1;
        $cabeza = 0;
        $campo_bode = $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $bodega));
        $departamento_inf_tr .= '<tr><td colspan="' . $col . '" style="text-align:center;"><b><br />' . $campo_bode . '</b></td></tr>';
        $sin_reg  = 0;
        foreach ($elementos as $key => $value) {
            foreach ($value as $ids => $valores) {
                /* if($ids!=key($ultimo_padre)){
                  $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';
                  }else{ */
                $tia_hijo_temp = array();
                $tia_hijo_reg = $this->inventario_model->get_tia_hijos($ids, true);
                $tia_hijo_temp = array_merge($tia_hijo_temp, $tia_hijo_reg);
                while (count($tia_hijo_reg) > 0) {
                    $tia_id_column = array_column($tia_hijo_reg, 'tia_id');
                    $tia_id_implode = implode(', ', $tia_id_column);
                    $tia_hijo_reg = $this->inventario_model->get_tia_hijos($tia_id_implode);
                    $tia_hijo_temp = array_merge($tia_hijo_temp, $tia_hijo_reg);
                }
                $tia_id_temp_column = array_column($tia_hijo_temp, 'tia_id');
                $where_hijos = implode(',', $tia_id_temp_column);
                $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $where_hijos);
                if (count($tia_hijo) > 0) {
                    $sin_reg += count($tia_hijo);
                    // $departamento_infe_tr = '<tr style="background-color:gray;"><td colspan="' . $col . '"><b><br />Departamento ' . $i . ': ' . $valores . '</b></td></tr>';
                    //$departamento_inf_tr.=$departamento_infe_tr;
                    foreach ($tia_hijo as $tia => $tipo) {
                        $informacion = $this->inventario_model->consultaxdep($tipo['tia_id'], $bodega, '', null, $txtFechaIni, $txtFechaFin);
                        if (count($informacion) > 0 && $cabeza < 1) {
                            $departamento_inf_tr .= $departamento_infe_tr;
                            $cabeza++;
                        }
                        if (count($informacion) > 0) {
                            $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría ' . /*$i .*/ ': ' . $tipo['tia_nombre'] . '</b></td></tr>';
                            $departamento_inf_tr .= $cabezera;
                            $array_datos = $this->cuerpo_busquedaxcodigo($informacion, $ocultarCostos);
                            $total_entradas_general += $array_datos['totales']['cantidad_entrada'];
                            $total_salidas_general += $array_datos['totales']['cantidad_salida'];
                            $total_existencia_general += $array_datos['totales']['cantidad_existencia'];
                            $total_entrada_costo_general += $array_datos['totales']['subtotal_entrada'];
                            $total_salida_costo_general += $array_datos['totales']['subtotal_salida'];
                            $total_saldos_costo_general += $array_datos['totales']['subtotal_existencia'];
                            $departamento_inf_tr .= $array_datos['html'];
                        }
                    }
                } else {
                    // Se obtiene los registros de cada categoria
                    $informacion = $this->inventario_model->consultaxdep($ids, $bodega, '', null, $txtFechaIni, $txtFechaFin);
                    $sin_reg += count($informacion);
                    if (count($informacion) > 0) {
                        $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría ' . $i . ': ' . $valores . '</b></td></tr>';
                        $departamento_inf_tr .= $cabezera;
                        $array_datos = $this->cuerpo_busquedaxcodigo($informacion, $ocultarCostos);
                        $departamento_inf_tr .= $array_datos['html'];
                    }
                }
            }
            $cabeza = 0;
            $i++;
        }
        //Se suman los totales.        
        if($sin_reg === 0){
            $departamento_inf_tr .= $cabezera.'<tr><td style="text-align:center" colspan="'.$col.'">Sin registros</td></tr>';
        }
        if (substr_count($departamento_inf_tr, '<tr>') == 1) {
            $departamento_inf_tr .= $cabezera.'<tr><td style="text-align:center" colspan="'.$col.'">Sin registros</td></tr>';
        }
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $departamento_inf_tr .= '<tr>';
        $departamento_inf_tr .= '<td colspan="6" style="text-align: right;"><b>Total General</b></td>';
        $departamento_inf_tr .= '<td style="text-align: right;"><b>'.number_format($total_entradas_general, $decimales).'</b></td>';
        if($ocultarCostos == 0){
            $departamento_inf_tr .= '<td></td>';
            $departamento_inf_tr .= '<td style="text-align: right;"><b>$'.number_format($total_entrada_costo_general, $decimales).'</b></td>';
        }
        $departamento_inf_tr .= '<td style="text-align: right;"><b>'.number_format($total_salidas_general, $decimales).'</b></td>';
        if($ocultarCostos == 0){
            $departamento_inf_tr .= '<td></td>';
            $departamento_inf_tr .= '<td style="text-align: right;"><b>$'.number_format($total_salida_costo_general, $decimales).'</b></td>';
        }
        $departamento_inf_tr .= '<td style="text-align: right;"><b>'.number_format($total_existencia_general, $decimales).'</b></td>';
        if($ocultarCostos == 0){
            $departamento_inf_tr .= '<td style="text-align: right;"><b>$'.number_format($total_saldos_costo_general, $decimales).'</b></td>';            
        }
        $departamento_inf_tr .= '</tr>';

        $cadena .= $departamento_inf_tr;
        $arreglo = array(
            "drop" => $cadena,
        );

        echo json_encode($arreglo);
    }

    function ver_precios($id_sar) {
        $data['precios'] = $this->inventario_model->listado_precios($id_sar);
        $this->load->view('inventario/reportes/ver_precios', $data);
    }

    function tbody_reporte_furgon($informacion) {
        //$ndecimales =  $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $ndecimales = 2;

        $entradas = 0;
        $salidas = 0;
        $saldo = 0;
        $cadena = "";
        foreach ($informacion as $key) {

            $cadena .= '<tr>';
            $cadena .= '<td style="text-align:left;">' . $key['codigo'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['nombre'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . "&nbsp;" . $key['caja'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['cantidad'] . '</td>';
            $cadena .= '<td style="text-align:left;">' . $key['UM'] . '</td>';
            $cadena .= '<td style="text-align:right;">&nbsp;' . number_format($key['Entradas'], $ndecimales) . '</td>';
            $cadena .= '<td style="text-align:right;">&nbsp;' . number_format($key['Salidas'], $ndecimales) . '</td>';
            $cadena .= '<td style="text-align: right;">&nbsp;' . number_format($key['Saldo'], $ndecimales) . '</td></tr>';
            $entradas += (float) $key['Entradas'];
            $salidas += (float) $key['Salidas'];
            $saldo += (float) $key['Saldo'];
        }
        $cadena .= '<tr><td colspan="8"></td></tr>';
        $cadena .= '<tr><td colspan="5"><b>Total:</b></td><td style="text-align:right;">&nbsp;<b>' . number_format($entradas, $ndecimales) . '</b></td><td style="text-align:right;">&nbsp;<b>' . number_format($salidas, $ndecimales) . '</b></td><td style="text-align:right;">&nbsp;<b>' . number_format($saldo, $ndecimales) . '</b></td></tr>';
        return $cadena;
    }

    public function reporte_furgon() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $furgon = $this->input->post('furgon');
            $categoria = $this->input->post('categoria');
            $bodega = $this->input->post('bodega');
            $departamento = $this->input->post('departamento');
            $tipo_reporte = $this->input->post('tipo_reporte');
            $cabezera = '<tr><td style="text-align:center; font-weight:bold;">Código</td>';
            $cabezera .= '<td style="text-align:left; font-weight:bold;">Nombre</td>';
            $cabezera .= '<td style="text-align:left; font-weight:bold;">No. Caja</td>';
            $cabezera .= '<td style="text-align:left; font-weight:bold;">Cant/Caja</td>';
            $cabezera .= '<td style="text-align:left; font-weight:bold;">UM</td>';
            $cabezera .= '<td style="text-align:right; font-weight:bold;">Entradas</td>';
            $cabezera .= '<td style="text-align:right; font-weight:bold;">Salidas</td>';
            $cabezera .= '<td style="text-align:right; font-weight:bold;">Saldo</td>';
            $cabezera .= '</tr>';
            $cadena = "";



            /* ---------------- Parametros de busqueda ---------------------------- */
            $bodega = $this->input->post('bodega');
            $ultima_categoria = $this->input->post('categoria');
            $codigo = $this->input->post('cod_art');
            //print_r($_POST);exit();
            //estructurar el encabezado del furgon
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $html_furgon = '<h3>Contenedor: ' . @$furgon . '</h3> <br/>';
            } else {
                $html_furgon = '';
            }
            /* -------------------------------------------------------------------- */

            /* ------------- condiciones para la busqueda por codigo -------------- */

            $cod_art = ($codigo == "") ? null : $codigo;

            /* -------------------------------------------------------------------- */



            /* --------------- Encontrar dependencias de ultima categoria --------- */



            $padre_del_padre = array();
            $i = 0;
            if ($ultima_categoria == "") {
                $categorias_total = $this->inventario_model->get_categorias();
                foreach ($categorias_total as $y) {
                    $padre_del_padre[] = $y['tia_id'];
                }
                array_push($padre_del_padre, '');
            } else {
                while ($ultima_categoria != null) {
                    if ($i == 0) {
                        $padre_del_padre[] = $ultima_categoria;
                    } else {
                        $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                        $ultima_categoria = $ultima_categoria['tia_padre'];
                        $padre_del_padre[] = $ultima_categoria;
                    }
                    $i++;
                }
            }

            $categorias_final = array_reverse($padre_del_padre);

            /* -------------------------------------------------------------------- */


            /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */

            $cadena = ""; // arreglo que mandaremos en un json
            $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

            foreach ($categorias_final as $key => $value) {
                if ($key != null) {
                    $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                    $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
                }
            }


            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $col = 8;
            } else {
                $col = 8;
            }
            $ultimo_padre = end($elementos);

            $departamento_inf_tr = "";
            $i = 1;
            $cabeza = 0;
            $departamento_tr = $html_furgon . '<table class="tabla" style="border:0px solid black;">';
            $departamento_tr .= '<tbody>';
            $ids_cat_consultados = array();
            foreach ($elementos as $key => $value) {
                foreach ($value as $ids => $valores) {
                    /* $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                      $departamento_tr.='<thead>';
                      $departamento_tr.='<tr style="background-color: #C0C0C0;"><th colspan="8" style="text-align:center; font-weight:bold;">DEPARTAMENTO: '.$papa['tia_nombre'].'</th></tr>';
                      $departamento_tr.='</thead>';
                      $departamento_tr.='<tbody>'; */

                    /* if($ids!=key($ultimo_padre)){

                      $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';

                      }else{ */

                    $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);


                    if (count($tia_hijo) > 0) {

                        $departamento_infe_tr = '<tr style="background-color: #F0F0F0;"><td style=" text-align:left;" colspan="' . $col . '"><b><br />Departamento : ' . $valores . '</b></td></tr>';

                        foreach ($tia_hijo as $tia => $tipo) {

                            //preguntar si posee articulos y saber si es padre o no.
                            $pre = $this->gsatelite->get_tabla('art_articulo', array('art_id_tia' => end($categorias_final)));
                            if (count($pre) <= 0) {

                                $tipo_id_tia = $tipo['tia_id'];
                            } else {
                                $tipo_id_tia = end($categorias_final);
                            }

                            if (!in_array($tipo_id_tia, $ids_cat_consultados)) {
                                $informacion = $this->inventario_model->consultaxdep($tipo_id_tia, $bodega, $furgon, $cod_art);
                                //die($this->db->last_query());
                                $reg_tia = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id' => $tipo_id_tia));
                                $ids_cat_consultados[] = $tipo_id_tia;
                                //print_r($this->db->last_query());exit();
                                if (count($informacion) > 0 && $cabeza < 1) {
                                    $departamento_inf_tr .= $departamento_infe_tr;
                                    $cabeza++;
                                }

                                if (count($informacion) > 0) {
                                    $departamento_inf_tr .= '<tr><td  style=" text-align:left;" colspan="' . $col . '"><b><br />Categoría : ' . $reg_tia[0]['tia_nombre'] . '</b></td></tr>';
                                    $departamento_inf_tr .= $cabezera;
                                    $departamento_inf_tr .= $this->tbody_reporte_furgon($informacion);
                                }
                            }
                        }
                    } else {
                        //preguntar si los datos fueron ya consultados en el for de arriba.
                        if (!in_array($ids, $ids_cat_consultados)) {
                            $informacion = $this->inventario_model->consultaxfurgon($ids, $furgon, $bodega, $cod_art);
                            if (count($informacion) > 0) {
                                $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $valores . '</b></td></tr>';
                                $departamento_inf_tr .= $cabezera;
                                $departamento_inf_tr .= $this->tbody_reporte_furgon($informacion);
                            }
                        }
                    }
                    //}
                }
                $cabeza = 0;
                $i++;
            }


            $cadena .= $departamento_tr . $departamento_inf_tr;
            $cadena .= '</tbody>';
            $cadena .= '</table>';



            if ($tipo_reporte == 'excel') {
                //Nombre del archivo
                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                //Obtener datos y construir secciones del reporte

                $data['table_header'] = $rows;
                $data['table_tbody'] = $cadena;
                $data['filename'] = $filename;

                $this->load->view('inventario/reportes/reporte_furgon', $data);
            }

            if ($tipo_reporte == 'pdf') {
                $data['table_header'] = $rows;
                $data['table_tbody'] = $cadena;
                $this->pdf->reportePDF('inventario/reportes/reporte_furgon_pdf', $data, 'Contenedor');
            }
        }
    }

    function tbody_reporte_prod_sin_mov($informacion) {
        $ndecimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        //   $ndecimales =  2;
        $entrada = 0;
        $salida = 0;
        $saldo = 0;
        $cadena = "";
        $mostrar = 0;
        foreach ($informacion as $key) {
            if ($key['Salidas'] == 0) {
                //$cadena.='<tr><td>'.$key['bodega'].'</td>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<tr><td style="text-align:center;">' . $key['furgon'] . '</td>';
                } else {
                    $cadena .= "<tr>";
                }
                $cadena .= '<td style="text-align:center;">' . $key['codigo'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $key['nombre'] . '</td>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<td style="text-align:center;">' . $key['caja'] . '</td>';
                    $cadena .= '<td style="text-align:center;">' . number_format($key['cantidad'], $ndecimales) . '</td>';
                }
                $cadena .= '<td style="text-align:center;">' . $key['UM'] . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($key['Entradas'], $ndecimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($key['Salidas'], $ndecimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($key['Saldo'], $ndecimales) . '</td></tr>';


                $entrada += (int) $key['Entradas'];
                $salida += (int) $key['Salidas'];
                $saldo += (int) $key['Saldo'];

                $mostrar++;
            }
        }
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 6;
        } else {
            $col = 3;
        }
        $cadena .= '<tr><td colspan="' . $col . '"><b>Total:</b></td><td style="text-align: right;"><b>' . number_format($entrada, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td><td style="text-align: right;"><b>' . number_format($salida, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td><td style="text-align: right;"><b>' . number_format($saldo, $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</b></td></tr>';
        $datos = array('cadena' => $cadena, 'data' => $mostrar);
        return $cadena;
    }

    public function reporte_prod_sin_mov() {
        satelite_validar();
        $post_array = $this->input->post();
        $rows = "productos sin movimiento";
        $cadena = '<table class="tabla" width="100%" style="border:0px solid black;" border="1">';
        $cadena .= $this->busqueda_produc_sin_movimiento2(true, false, $post_array);
        $cadena .= '</table>';
        $tipo_reporte = $this->input->post('tipo_reporte');
        $bd_nam = ($this->input->post('bodega') > 0) ? $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $this->input->post('bodega'))) : 'Todas las Bodegas';
        $us = $this->tank_auth->get_user_id();
        $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
        $titulo = 'productos sin movimiento';
        $encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);
        if ($tipo_reporte == 'excel') {
            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo'] = 'productos sin movimiento';
            $data['subtitulo'] = 'Bodega: ' . $bd_nam;
            $data['table_header'] = $encabezado;
            $data['tipo_reporte'] = 'excel';
            $data['datos_excel'] = $cadena;
            $data['filename'] = $filename;
            $this->load->view('inventario/reportes/imprimir_reporte_inventario_sin_mov.php', $data);
        }
        if ($tipo_reporte == 'pdf') {
            $data['titulo'] = 'Productos sin movimiento';
            $data['subtitulo'] = 'Bodega: ' . $bd_nam;
            $encabezado = $this->load->view('reporte/header', $data, true);
            $header = '<!DOCTYPE html><html><head><title>REPORTE PROD. SIN MOV</title></head><body><script type="text/javascript">';
            $header .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - productos_sin_movimiento' . date('dmY') . '";';
            $header .= 'window.print();</script>';
            $footer = '</body></html>';
            $reporte = $header . $encabezado . $cadena . $footer;
            echo $reporte;
            // $this->pdf->makePdf($reporte, 'L', 'productos_sin_movimiento', 'Letter');
        }
    }

    function tbody_reporte_codigo($informacion, $costo = null) {
        $entradas = 0;
        $total_entrada = 0;
        $salidas = 0;
        $total_salidas = 0;
        $saldo = 0;
        $total_saldo = 0;
        $total_entrada_fila = $total_salida_fila = $total_saldo_fila = 0;
        $cadena = "";
        $ocultarCostos = ($costo != null) ? $costo : 1;
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        foreach ($informacion as $key) {

            $cadena .= '<tr nobr="true">';
            //  $cadena.='<td style="text-align:center;">'.$key['bodega'].'</td>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cadena .= '<td style="text-align:center;">' . $key['furgon'] . '</td>';
            }
            $cadena .= '<td style="text-align:center;">' . formatear_fecha('d-m-Y', $key['moi_fecha_mov']) . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['codigo'] . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['nombre'] . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['lote'] . '</td>';
            $cadena .= '<td style="text-align:center;">' . $key['marca'] . '</td>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cadena .= '<td style="text-align:center;">' . "&nbsp;" . $key['caja'] . '</td>';
                $cadena .= '<td style="text-align:center;">' . $key['cantidad'] . '</td>';
            }
            $cadena .= '<td style="text-align:center;">' . $key['UM'] . '</td>';
            $cadena .= '<td style="text-align:right;">' . number_format($key['Entradas'], $decimales) . '</td>';
            if($ocultarCostos == 0){
                $total_entrada_fila = $key['Entradas'] * $key['precio_compra'];
                $cadena .= '<td style="text-align:right;">' . number_format($key['precio_compra'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($total_entrada_fila, $decimales) . '</td>';
            }
            $cadena .= '<td style="text-align:right;">' . number_format($key['Salidas'], $decimales) . '</td>';
            if($ocultarCostos == 0){
                $total_salida_fila = $key['Salidas'] * $key['precio_compra'];
                $cadena .= '<td style="text-align:right;">' . number_format($key['precio_compra'], $decimales) . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($total_salida_fila, $decimales) . '</td>';
            }
            $cadena .= '<td style="text-align: right;">' . number_format($key['Saldo'], $decimales) . '</td>';
            if($ocultarCostos == 0){
                $total_saldo_fila = $key['Saldo'] * $key['precio_compra'];
                $cadena .= '<td style="text-align:right;">' . number_format($total_saldo_fila, $decimales) . '</td>';
            }
            $cadena .= '</tr>';
            $entradas += $key['Entradas'];
            $total_entrada += $total_entrada_fila;
            $salidas += $key['Salidas'];
            $total_salidas += $total_salida_fila;
            $saldo += $key['Saldo'];
            $total_saldo += $total_saldo_fila;
        }
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 9;
        } else {
            $col = 6;
        }
        $fila_blanca = ($ocultarCostos == 0) ? 13 :9;
        $cadena .= '<tr><td colspan="'.$fila_blanca.'"></td></tr>';
        $cadena .= '<tr><td colspan="' . $col . '"><b>Total:</b></td>';
        $cadena .= '<td style="text-align:right;"><b>' . number_format($entradas, $decimales) . '</b></td>';
        if($ocultarCostos == 0){
            $cadena .= '<td style="text-align: right;"><b></b></td>';
            $cadena .= '<td style="text-align: right;"><b>' . number_format($total_entrada, $decimales) . '</b></td>';
        }
        $cadena .= '<td style="text-align:right;"><b>' . number_format($salidas, $decimales) . '</b></td>';
        if($ocultarCostos == 0){
            $cadena .= '<td style="text-align: right;"><b></b></td>';
            $cadena .= '<td style="text-align: right;"><b>' . number_format($total_salidas, $decimales) . '</b></td>';
        }
        $cadena .= '<td style="text-align:right;"><b>' . number_format($saldo, $decimales) . '</b></td>';
        if($ocultarCostos == 0){
            $cadena .= '<td style="text-align: right;"><b>' . number_format($total_saldo, $decimales) . '</b></td>';            
        }
        $cadena .= '</tr>';
        $totales_array = array(
            'cantidad_entrada' => $entradas,
            'subtotal_entrada' => $total_entrada,
            'cantidad_salida' => $salidas,
            'subtotal_salida' => $total_salidas,
            'cantidad_existencia' => $saldo,
            'subtotal_existencia' => $total_saldo
        );
        return array('html' => $cadena, 'totales' => $totales_array );
        // return $cadena;
    }

    public function reporte_codigo() {
        $total_entradas_general = 0;
        $total_entrada_costo_general = 0;
        $total_salidas_general = 0;
        $total_salida_costo_general = 0;
        $total_existencia_general = 0;
        $total_saldos_costo_general = 0;
        $txtFechaIni    = $this->input->post('txtFechaIni');
        $txtFechaFin    = $this->input->post('txtFechaFin');
        $ocultarCostos  = $this->input->post('hdnOcultarCosto');//0=no=mostrar;;1=si=ocultar
        $us = $this->tank_auth->get_user_id();
        $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
        $titulo = " bodega";
        $encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);
        $rows = "bodega";
        $categoria = $this->input->post('categoria');
        $bodega = $this->input->post('bodega');
        $departamento = $this->input->post('departamento');
        $cabezera = '<tr>';
        // $cabezera.='<th style="text-align:center; font-weight:bold;">Bodega</th>';
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Contenedor</th>';
        }
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Fecha</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Código</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Producto</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Lote</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Marca</th>';
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">No. Caja</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Cant/Caja</th>';
        }
        $cabezera .= '<th style="text-align:center; font-weight:bold;">UM</th>';
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Entradas</th>';
        if ($ocultarCostos == 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Costo</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Total</th>';
        }
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Salidas</th>';
        if ($ocultarCostos == 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Costo</th>';
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Total</th>';
        }
        $cabezera .= '<th style="text-align:center; font-weight:bold;">Saldo Actual</th>';
        if ($ocultarCostos == 0) {
            $cabezera .= '<th style="text-align:center; font-weight:bold;">Costo Total</th>';
        }
        $cabezera .= '</tr>';
        $cadena = "";
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            if ($ocultarCostos == 0) {
                $col = 17;
            } else {
                $col = 12;
            }            
        } else {
            if ($ocultarCostos == 0) {
                $col = 14;
            } else {
                $col = 9;
            }
        }
        $furgones = $this->input->post('furgon');
        if ($furgones != "") {
            $cadena_in = "";
            foreach ($furgones as $key => $value) {

                $cadena_in .= $value . ',';
            }

            $furgon = substr($cadena_in, 0, -1);
        } else {
            $furgon = "";
        }
        /* ---------------- Parametros de busqueda ---------------------------- */
        $bodega = $this->input->post('bodega');
        $ultima_categoria = $this->input->post('categoria');
        $ultima_categoria = (!$ultima_categoria) ? $this->input->post('last_cat') : $ultima_categoria;
        $codigo = $this->input->post('cod_art');
        /* -------------------------------------------------------------------- */
        /* ------------- condiciones para la busqueda por codigo -------------- */
        $cod_art = ($codigo == "") ? null : $codigo;
        /* -------------------------------------------------------------------- */
        /* --------------- Encontrar dependencias de ultima categoria --------- */
        $padre_del_padre = array();
        $i = 0;
        if ($ultima_categoria == "") {
            $categorias_total = $this->inventario_model->get_categorias($bodega);
            foreach ($categorias_total as $y) {
                $padre_del_padre[] = $y['tia_id'];
            }
            array_push($padre_del_padre, '');
        } else {
            $arbol_cat = $this->inventario_model->crear_arbol($ultima_categoria);
            $categorias_split = explode(',',$arbol_cat);
            for($k = 0; $k < count($categorias_split); $k++){
                if($categorias_split[$k]!=''){
                    $padre_del_padre[] = $categorias_split[$k];
                }
            }
            // while ($ultima_categoria != null) {
            if ($i == 0) {
                $padre_del_padre[] = $ultima_categoria;
            } else {
                $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                $ultima_categoria = $ultima_categoria['tia_padre'];
                $padre_del_padre[] = $ultima_categoria;
            }
            $i++;
            // }
        }
        $categorias_final = array_reverse($padre_del_padre);
        /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */
        $cadena = ""; // arreglo que mandaremos en un json
        $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije
        foreach ($categorias_final as $key => $value) {
            if ($value != "") {
                $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
            }
        }
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            if ($ocultarCostos == 0) {
                $col = 15;
            } else {
                $col = 10;
            }
        } else {
            if ($ocultarCostos == 0) {
                $col = 14;
            } else {
                $col = 9;
            }
        }
        $ultimo_padre = end($elementos);
        $departamento_inf_tr = "";
        $i = 1;
        $cabeza = 0;
        $departamento_tr = '<table class="tabla" border="1" style="border:1px solid black; font-size: 8pt;">';
        $departamento_tr .= '<tbody>';
        $campo_bode = $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $bodega));
        $departamento_inf_tr .= '<tr><td colspan="' . $col . '" style="text-align:center;"><b><br />' . $campo_bode . '</b></td></tr>';
        foreach ($elementos as $key => $value) {
            foreach ($value as $ids => $valores) {
                /* $departamento_tr='<table class="tabla" style="border:1px solid black;">';
                  $departamento_tr.='<thead>';
                  $departamento_tr.='<tr style="background-color: #C0C0C0;"><th colspan="8" style="text-align:center; font-weight:bold;">DEPARTAMENTO: '.$papa['tia_nombre'].'</th></tr>';
                  $departamento_tr.='</thead>';
                  $departamento_tr.='<tbody>'; */
                /* if($ids!=key($ultimo_padre)){
                  $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                  }else{ */
                // $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);
                $tia_hijo_temp = array();
                $tia_hijo_reg = $this->inventario_model->get_tia_hijos($ids, true);
                $tia_hijo_temp = array_merge($tia_hijo_temp, $tia_hijo_reg);
                // print_r($this->db->last_query());
                while (count($tia_hijo_reg) > 0) {
                    $tia_id_column = array_column($tia_hijo_reg, 'tia_id');
                    $tia_id_implode = implode(', ', $tia_id_column);
                    $tia_hijo_reg = $this->inventario_model->get_tia_hijos($tia_id_implode);
                    $tia_hijo_temp = array_merge($tia_hijo_temp, $tia_hijo_reg);
                }
                $tia_id_temp_column = array_column($tia_hijo_temp, 'tia_id');
                $where_hijos = implode(',', $tia_id_temp_column);
                $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $where_hijos);
                if (count($tia_hijo) > 0) {
                    // $departamento_infe_tr = '<tr style="background-color: #C0C0C0;"><td style="border-right: 0px solid black;border-left: 0px solid black;" colspan="' . $col . '"><b><br />Departamento ' . $i . ': ' . $valores . '</b></td></tr>';
                    foreach ($tia_hijo as $tia => $tipo) {
                        $informacion = $this->inventario_model->consultaxdep($tipo['tia_id'], $bodega, '', null, $txtFechaIni, $txtFechaFin);
                        if (count($informacion) > 0 && $cabeza < 1) {
                            $departamento_inf_tr .= $departamento_infe_tr;
                            $cabeza++;
                        }

                        if (count($informacion) > 0) {
                            $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría ' . /*$i .*/ ': ' . $tipo['tia_nombre'] . '</b></td></tr>';
                            $departamento_inf_tr .= $cabezera;
                            $array_datos = $this->tbody_reporte_codigo($informacion, $ocultarCostos);
                            $departamento_inf_tr .= $array_datos['html'];
                            $total_entradas_general += $array_datos['totales']['cantidad_entrada'];
                            $total_entrada_costo_general += $array_datos['totales']['subtotal_entrada'];
                            $total_salidas_general += $array_datos['totales']['cantidad_salida'];
                            $total_salida_costo_general += $array_datos['totales']['subtotal_salida'];
                            $total_existencia_general += $array_datos['totales']['cantidad_existencia'];                            
                            $total_saldos_costo_general += $array_datos['totales']['subtotal_existencia'];
                        }
                    }
                } else {
                    $informacion = $this->inventario_model->consultaxdep($ids, $bodega, '', null, $txtFechaIni, $txtFechaFin);
                    if (count($informacion) > 0) {
                        $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría ' . /*$i .*/ ': ' . $valores . '</b></td></tr>';
                        $departamento_inf_tr .= $cabezera;
                        $array_datos = $this->tbody_reporte_codigo($informacion, $ocultarCostos);
                        $departamento_inf_tr .= $array_datos['html'];
                    }
                }
                //}
            }
            $cabeza = 0;
            $i++;
        }
        if (substr_count($departamento_inf_tr, '<tr>') == 1) {
            $departamento_inf_tr .= $cabezera.'<tr><td style="text-align:center" colspan="9">Sin registros</td></tr>';
        }
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $departamento_inf_tr .= '<tr nobr="true">';
        $departamento_inf_tr .= '<td colspan="6" style="text-align: right;"><b>Total General</b></td>';
        $departamento_inf_tr .= '<td style="text-align: right;"><b>'.number_format($total_entradas_general, $decimales).'</b></td>';
        if($ocultarCostos == 0){
            $departamento_inf_tr .= '<td></td>';
            $departamento_inf_tr .= '<td style="text-align: right;"><b>$'.number_format($total_entrada_costo_general, $decimales).'</b></td>';
        }
        $departamento_inf_tr .= '<td style="text-align: right;"><b>'.number_format($total_salidas_general, $decimales).'</b></td>';
        if($ocultarCostos == 0){
            $departamento_inf_tr .= '<td></td>';
            $departamento_inf_tr .= '<td style="text-align: right;"><b>$'.number_format($total_salida_costo_general, $decimales).'</b></td>';
        }
        $departamento_inf_tr .= '<td style="text-align: right;"><b>'.number_format($total_existencia_general, $decimales).'</b></td>';
        if($ocultarCostos == 0){
            $departamento_inf_tr .= '<td style="text-align: right;"><b>$'.number_format($total_saldos_costo_general, $decimales).'</b></td>';            
        }
        $departamento_inf_tr .= '</tr>';
        $cadena .= $departamento_tr . $departamento_inf_tr;
        $tipo_reporte = $this->input->post('tipo_reporte');
        $data['table_tbody'] = $cadena;
        if ($tipo_reporte == 'excel') {
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['table_header'] = $encabezado;
            $data['filename'] = $filename;
            $this->load->view('inventario/reportes/reporte_departamento_pdf', $data);
        }
        if ($tipo_reporte == 'pdf') {
            $data['table_header'] = '';
            $reporte = $this->load->view('inventario/reportes/reporte_departamento_pdf', $data, true);
            $data['titulo'] = 'Bodega';
            $encabezado = $this->load->view('reporte/header', $data, true);
            $header = '<!DOCTYPE html><html><head><title>REPORTE POR BODEGA</title></head><body><script type="text/javascript">';
            $header .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - bodega' . date('dmY') . '";';
            $header .= 'window.print();</script>';
            $footer = '</body></html>';
            $completo = $header . $encabezado . $reporte . $footer;
            echo $completo;
            // $this->pdf->reportePDF('inventario/reportes/reporte_departamento_pdf', $data, 'bodega', 'L');
        }
    }

    function tbody_reporte_departamento($informacion, $reporte = "") {
        $dec = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!=null)?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

        $entradas = 0;
        $salidas = 0;
        $saldo = 0;
        $cadena = "";
        foreach ($informacion as $key) {
            $cadena .= '<tr nobr="true">';
            $cadena .= ($reporte == 'pdf')?'<td width="11%">' . $key['codigo'] . '</td>' : '<td>' . $key['codigo'] . '</td>';
            $cadena .= ($reporte == 'pdf')?'<td width="26%">' . $key['nombre'] . '</td>' : '<td>' . $key['nombre'] . '</td>';
            $cadena .= ($reporte == 'pdf')?'<td width="12%">' . $key['marca'] . '</td>' : '<td>' . $key['marca'] . '</td>';
            $cadena .= ($reporte == 'pdf')?'<td width="12%">' . $key['UM'] . '</td>' : '<td>' . $key['UM'] . '</td>';
            $cadena .= ($reporte == 'pdf')?'<td width="13%" style="text-align:right;">'.number_format($key['Entradas'], $dec).'</td>':'<td style="text-align:right;">'.number_format($key['Entradas'], $dec).'</td>';
            $cadena .= ($reporte == 'pdf')?'<td width="13%" style="text-align:right;">'.number_format($key['Salidas'], $dec).'</td>':'<td style="text-align:right;">'.number_format($key['Salidas'], $dec).'</td>';
            $cadena .= ($reporte == 'pdf')?'<td width="13%" style="text-align:right;">'.number_format($key['Saldo'], $dec).'</td>':'<td style="text-align:right;">'.number_format($key['Saldo'], $dec).'</td>';
            $cadena .= '</tr>';
            $entradas += $key['Entradas'];
            $salidas += $key['Salidas'];
            $saldo += $key['Saldo'];
        }

        $col = 4;

        $cadena .= '<tr><td colspan="7"></td></tr>';
        //$cadena .= '<tr><td colspan="' . $col . '"><b>Total:</b></td><td style="text-align:right;"><b>' . number_format($entradas, $dec) . '</b></td><td style="text-align:right;"><b>' . number_format($salidas, $dec) . '</b></td><td style="text-align:right;"><b>' . number_format($saldo, $dec) . '</b></td></tr>';
        $cadena .= '<tr>';
        $cadena .= '<td colspan="' . $col . '"><b>Total:</b></td>'
                . '<td style="text-align:right;"><b>' . number_format($entradas, $dec) . '</b></td>'
                . '<td style="text-align:right;"><b>' . number_format($salidas, $dec) . '</b></td>'
                . '<td style="text-align:right;"><b>' . number_format($saldo, $dec) . '</b></td>';
        $cadena .= '</tr>';
        return $cadena;
    }

    public function reporte_departamento() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // var_dump($_POST);die();
            $contador = 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            $cabezera = '<tr>';
            $cabezera .= ($tipo_reporte == 'pdf') ? '<th width="11%"><b>Código</b></th>' : '<th><b>Código</b></th>';
            $cabezera .= ($tipo_reporte == 'pdf') ? '<th width="26%"><b>Nombre</b></th>' : '<th><b>Nombre</b></th>';
            $cabezera .= ($tipo_reporte == 'pdf') ? '<th width="12%"><b>Marca</b></th>' : '<th><b>Marca</b></th>';
            $cabezera .= ($tipo_reporte == 'pdf') ? '<th width="12%"><b>UM</b></th>' : '<th><b>UM</b></th>';
            $cabezera .= ($tipo_reporte == 'pdf') ? '<th width="13%"><b>Entradas</b></th>' : '<th><b>Entradas</b></th>';
            $cabezera .= ($tipo_reporte == 'pdf') ? '<th width="13%"><b>Salidas</b></th>' : '<th><b>Salidas</b></th>';
            $cabezera .= ($tipo_reporte == 'pdf') ? '<th width="13%"><b>Saldo Actual</b></th>' : '<th><b>Saldo Actual</b></th>';
            $cabezera .= '</tr>';
            $furgon = "";
            /* ---------------- Parametros de busqueda ---------------------------- */
            $bodega = $this->input->post('bodega');
            $bodega_name = ($bodega > 0) ? $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $bodega)) : 'Todas las Bodegas';
            $nombre_bodega = 'Bodega: ' . $bodega_name;
            // $ultima_categoria = $this->input->post('categoria');
            $ultima_categoria = $this->input->post('hdn_cateoria');
            $codigo = $this->input->post('cod_art');
            /* ------------- condiciones para la busqueda por codigo -------------- */
            $cod_art = ($codigo == "") ? null : $codigo;
            /* --------------- Encontrar dependencias de ultima categoria --------- */
            $categorias_final = array();
            $padre_x_padre = array();
            $i = 0;
            $categoria_arbol = $this->inventario_model->crear_arbol($ultima_categoria, "");            
            if($categoria_arbol != ''){
                $categorias_final = explode(',', $categoria_arbol);
                $categorias_final = array_filter($categorias_final, function ($value){ return !is_null($value) && $value !== ''; });
                $categorias_final[] = $ultima_categoria;
            }else{
                if ($ultima_categoria != "") {
                    $arbol_cat = $this->inventario_model->crear_arbol($ultima_categoria);
                    $categorias_split = explode(',',$arbol_cat);
                    for($k = 0; $k < count($categorias_split); $k++){
                        if($categorias_split[$k] != ''){
                            $padre_x_padre[] = $categorias_split[$k];
                        }
                    }
                    // while ($ultima_categoria != null) {
                        if ($i == 0) {
                            $padre_x_padre[] = $ultima_categoria;
                        } else {
                            $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                            $ultima_categoria = $ultima_categoria['tia_padre'];
                            $padre_x_padre[] = $ultima_categoria;
                        }
                        $i++;
                    // }
                    // $padre_x_padre = array_filter($padre_x_padre, function ($value){
                    //     return !is_null($value) && $value !== '';
                    // });
                    $categorias_final = $padre_x_padre;
                } else {
                    $categorias_total = $this->inventario_model->get_categorias($bodega);
                    foreach ($categorias_total as $y) {
                        $padre_x_padre[] = $y['tia_id'];                    
                        // $padre_del_padre = explode(',', $this->inventario_model->crear_arbol($y['tia_id'], ""));
                        // $padre_del_padre = array_filter($padre_del_padre, function ($value){ return !is_null($value) && $value !== ''; });
                        // if (count($padre_del_padre) > 0) {
                        //     $padre_del_padre[] = $y['tia_id'];
                        //     $categorias_final = array_merge($categorias_final, $padre_del_padre);
                        // }
                    }
                    // array_push($padre_x_padre, '');
                    $categorias_final = $padre_x_padre;
                }
            }
            /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */
            $cadena = ""; // arreglo que mandaremos en un json
            $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije
            foreach ($categorias_final as $key => $value) {
                if ($value != "") {
                    $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                    $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
                }
            }
            $col = 7;
            // $ultimo_padre = end($elementos);
            $departamento_inf_tr = "";
            $i = 1;
            $departamento_tr = '<table class="tabla" border="1" cellpadding="1">';
            $departamento_tr .= '<tbody>';
            $ids_cat_consultados = array();
            foreach ($elementos as $key => $value) {
                foreach ($value as $ids => $valores) {
                    $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);
                    if (count($tia_hijo) > 0) {
                        foreach ($tia_hijo as $tia => $tipo) {
                            //preguntar si posee articulos y saber si es padre o no.
                            $pre = $this->gsatelite->get_tabla('art_articulo', array('art_id_tia' => end($categorias_final)));
                            // if (count($pre) <= 0) {
                                $tipo_id_tia = $tipo['tia_id'];
                            // } else {
                            //     $tipo_id_tia = end($categorias_final);
                            // }
                            if (!in_array($tipo_id_tia, $ids_cat_consultados)) {
                                $informacion = $this->inventario_model->consultaxcategoria_productos($tipo_id_tia, $bodega, $furgon, $cod_art);
                                $reg_tia = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id' => $tipo_id_tia));
                                $ids_cat_consultados[] = $tipo_id_tia;
                                if (count($informacion) > 0 && $cabeza < 1) {
                                    $departamento_inf_tr .= $departamento_infe_tr;
                                    $cabeza++;
                                }

                                if (count($informacion) > 0) {
                                    if ($tipo_reporte == 'pdf') {
                                        $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $reg_tia[0]['tia_nombre'] . '</b></td></tr>';
                                    } else {
                                        $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $reg_tia[0]['tia_nombre'] . '</b></td></tr>';
                                    }
                                    $departamento_inf_tr .= $cabezera;
                                    $departamento_inf_tr .= $this->tbody_reporte_departamento($informacion, $tipo_reporte);
                                }
                            }
                        }
                    } else {
                        if (!in_array($ids, $ids_cat_consultados)) {
                            $informacion = $this->inventario_model->consultaxcategoria_productos($ids, $bodega, $furgon, $cod_art);
                            if (count($informacion) > 0) {
                                $contador++;
                                if ($tipo_reporte == 'pdf') {
                                    if ($contador == 1) {
                                        $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $valores . '</b></td></tr>';
                                    } else {
                                        $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $valores . '</b></td></tr>';
                                    }
                                } else {
                                    $departamento_inf_tr .= '<tr><td colspan="' . $col . '"><b><br />Categoría : ' . $valores . '</b></td></tr>';
                                }
                                $departamento_inf_tr .= $cabezera; //vamher
                                $departamento_inf_tr .= $this->tbody_reporte_departamento($informacion, $tipo_reporte);
                            }
                        }
                    }
                    //}
                }
                $cabeza = 0;
                $i++;
            }

            $cadena .= $departamento_tr . $departamento_inf_tr;


            $us = $this->tank_auth->get_user_id();
            $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
            $titulo =   'REPORTE POR CATEGORÍAS';
            $encabezado = $this->load->view('reporte/header_reporte', array('titulo' => $titulo, 'subtitulo' => $nombre_bodega, 'user' => $user, 'columna_empresa' => 2, 'columna_date' => 2, 'columna_logo' => 2), true);
            $data['table_tbody'] = $cadena . "</tbody></table>";
            if ($tipo_reporte == 'excel') {
                $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header'] = $encabezado;
                //"Reporte por departamento";
                // $data['table_tbody']      = $cadena;
                $data['filename'] = $filename;
                $this->load->view('inventario/reportes/reporte_categoria.php', $data);
            }
            if ($tipo_reporte == 'pdf') {
                $header = '<!DOCTYPE html><html><head><title>REPORTE POR CATEGORÍAS</title></head><body><script type="text/javascript">';
                $header .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - REPORTE POR CATEGORÍAS";';
                $header .= 'window.print();</script>';
                $footer = '</body></html>';
                $encabezado = $this->load->view('reporte/header_reporte', array('titulo' => $titulo, 'subtitulo' => $nombre_bodega, 'user' => $user, 'tipo' => 'pdf', 'style' => 0), true);
                $reporte = $header . $encabezado . $data['table_tbody'] . $footer;
                echo $reporte;die();
                //$this->pdf->makePdf($reporte, 'L', 'reporte_departamento', 'Letter');
                //$this->pdf->reportePDF('inventario/reportes/reporte_departamento_pdf', $data, 'departamento ');
            }
        }
    }

    function ver_precios_listado($id_art, $id_mep) {
        $data['listado'] = $this->inventario_model->listado_precios($id_art, $id_mep);
        $this->load->view('inventario/reportes/ver_precios', $data);
    }

    /*
     * Consultas/Kardex
     */

    function index2() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = "Consulta por nombre y código";
            $this->_cargarvista($data);
        }
    }

    function busqueda_codigo() {
        $codigo = $this->input->post('codigo_buscar');
        $informacion = $this->inventario_model->consultaxcodigo($codigo);
        $encabezado = '<img src="' . base_url('/assets/uploads/images/' . $informacion[0]['foto']) . '" style="width:150px;height:150px;">';
        $encabezado .= '<br><p><b>Codigo: </b>' . $informacion[0]['codigo'] . '</p>';
        $encabezado .= '<p><b>Nombre: </b>' . $informacion[0]['nombre'] . '</p>';
        $cadena = '';
        foreach ($informacion as $key) {
            $cadena .= '<tr><td>' . $key['furgon'] . '</td>';
            $cadena .= '<td>' . $key['caja'] . '</td>';
            $cadena .= '<td>' . $key['Entradas'] . '</td>';
            $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/consultas/consultas_detalle_entradas/' . $key['ixc'] . '">Ver entradas</a></td>';
            $cadena .= '<td>' . $key['Salidas'] . '</td>';
            $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/consultas/consultas_detalle_salidas/' . $key['ixc'] . '">Ver salidas</a></td>';
            $cadena .= '<td>' . $key['Saldo'] . '</td>';
            $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/consultas/consulta_detalle_furgon/' . $key['id_art'] . '/' . $key['furgon'] . '">Ver detalles</a></td></tr>';
        }
        $arreglo = array(
            "drop" => $cadena,
            "drop2" => $encabezado
        );
        //exit();
        echo json_encode($arreglo);
    }

    function consultas_detalle_salidas($ixc) {
        $data['detalle_salidas'] = $this->inventario_model->detalle_salidasxsar_id($ixc);
        $this->load->view('inventario/consultas/consultas_detalle_salidas', $data);
    }

    function consultas_detalle_entradas($ixc) {
        $data['detalle_entradas'] = $this->inventario_model->detalle_entradasxsar_id($ixc);
        $this->load->view('inventario/consultas/consultas_detalle_entradas', $data);
    }

    function consulta_detalle_furgon($articulo, $furgon) {
        $data['detalle_furgon'] = $this->inventario_model->detalle_existenciaxfurgon($articulo, $furgon);
        $this->load->view('inventario/consultas/consultas_detalle_furgon', $data);
    }

    function krdx_producto($sin_costo = null) {
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->get_bodegas_usuario();
        $data['tipo'] = $sin_costo;
        $data['titulo_personal'] = 'Kardex por producto';
        cargarvista($data, null, 'inventario/reportes/krdx_producto');
    }

    function krdx_tipo_art() {
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->get_bodegas_usuario();
        $cp = $this->gsatelite->get_dropdown('tia_tipo_articulo','{tia_codigo} - {tia_nombre}','',array('tia_estado'=>1,'tia_aplica_tipo_venta'=>1,'tia_padre IS NULL'=>null),null,'','tia_id', true);
        $data['tias_padres'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cp);
        $data['titulo_personal'] = 'Kardex por categoría';
        $this->_cargarvista(null, $data);
    }

    function cuentas_afectadas() {
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->get_bodegas_usuario();
        $data['titulo_personal'] = 'Cuentas afectadas';
        $this->_cargarvista(null, $data);
    }

    function get_kardex_producto() {
        $id_prod = $this->input->post('id_prod');
        $id_bod = $this->input->post('id_bod');
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $mostrar_costo = $this->input->post('mostrar_costos');
        $saldos_cero = $this->input->post('saldos_cero');
        $coslpan_header = ($mostrar_costo == 1) ? "1" : "3";
        $kardex_prod = $this->inventario_model->kardex_producto($id_prod, $id_bod, $fecha_ini, $fecha_fin);  
        // var_dump($this->db->last_query());die();
        $nombre_prod = $this->inventario_model->get_productos(array('art_id' => $id_prod));
        $bodega_name = ($id_bod > 0) ? $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $id_bod)) : 'Todas las Bodegas';
        $nombre_bodega = 'Bodega: ' . $bodega_name;
        $aplica_costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
        $num_decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        //$nombre_prod = $this->db->where('art_id', $id_prod)->join('mep_medida_producto', 'mep_id=art_id_mep')->get('art_articulo')->result_array();
        //$nombre_bod = $this->inventario_model->cargar_registro('bod_bodega', 'bod_id', $id_bod);
        $precios_detalle = array();
        foreach ($kardex_prod as $key) {
            array_push($precios_detalle, $key['dee_cantidad']);
        }
        //print("<pre>".print_r($kardex_prod,true)."</pre>");die();
        $total_dee_cantidad = array_sum($precios_detalle);
        $html = '';
        $html .= '';
        $excel = '';
        $pdf = '';
        $fecha_sal_anterior = date("Y-m-d", strtotime($fecha_ini));
        //$fecha_fin = date("Y-m-d", strtotime($fecha_fin));
        $suma_cantidad_salida = 0;
        $suma_cantidad_entrada = 0;
        $suma_total_salida = 0;
        $suma_total_entrada = 0;
        $precio_totales = 0;
        $cantidad_totales = 0;
        $dee_sal_anterior = 0;
        $where_saldo_anterior = array(
            "dee_id_art" => $id_prod, 
            "DATE(moi_fecha_mov) <" => $fecha_sal_anterior
        );
        if($id_bod!=''){
           $where_saldo_anterior["moi_id_bod"] = $id_bod;
        }
        

        $saldos_anteriores = $this->inventario_model->get_saldo_anterior($where_saldo_anterior);
        //print_r($this->db->last_query());die();
        foreach ($saldos_anteriores as $key) {
            if ($key["cantidad_entrada"] != null) {
                $suma_cantidad_entrada += $key["cantidad_entrada"];
                $suma_total_entrada += $key["total_entrada"];
            }
            if ($key["cantidad_salida"] != null) {
                $suma_cantidad_salida += $key["cantidad_salida"];
                $suma_total_salida += $key["total_salida"];
            }
            $dee_sal_anterior = $key["dee_precio"];
        }

        $cantidad_totales = $suma_cantidad_entrada - $suma_cantidad_salida;
        $precio_totales = $suma_total_entrada - $suma_total_salida;

        $cosplan_header = ($mostrar_costo == 0) ? 17 : 11;


        $excel .= '<thead> <tr>';
        $excel .= '<th colspan="' . $cosplan_header . '" height="5" align="right">';
        $excel .= '<font style="float:right"><b>Fecha: ' . date('d/m/Y') . '</b></font><br>';
        $excel .= '<center><b style="font-size:20px">KARDEX DE PRODUCTO</b></center>';
        $excel .= '<center><b style="font-size:20px">Registro de Control de Inventarios</b></center>';
        $excel .= '<center><b style="font-size:20px">' . $this->gsatelite->get_parametro('SYS_EMPRESA') . '</b></center>';
        $excel .= '<center><b>NIT: ' . $this->gsatelite->get_parametro('SYS_NIT') . '</b></center>';
        $excel .= '<center><b>NRC :' . $this->gsatelite->get_parametro('SYS_REGISTRO') . '</b></center>';
        $excel .= '<center><b>Kardex del ' . date('d/m/Y', strtotime($fecha_ini)) . ' al ' . date('d/m/Y', strtotime($fecha_fin)) . '</b></center>';
        $excel .= '<center><b>' . $nombre_bodega . '</b></center>';
        $excel .= '<center><b>MEDIDA: ' . $nombre_prod[0]['mep_nombre'] . '</b></center>';
        $excel .= '</th>';
        $excel .= '</tr>';

        $pdf .= '<table cellpadding="0" border=0>';
        $pdf .= '<tr>';
        $pdf .= '<td align="left" width="35%">';
        $pdf .= '<br><img height="48px" width="auto" src="' . base_url() . 'media/imagenes/sistema/' . $this->gsatelite->get_parametro('SYS_LOGOTIPO') . '.png">';
        $pdf .= '</td>';
        $pdf .= '<td align="center" width="30%">';
        $pdf .= '<b style="font-size:12px">' . $this->gsatelite->get_parametro('SYS_EMPRESA') . '</b></center><br>';
        $pdf .= '<b style="font-size:10px">Registro de Control de Inventarios</b></center><br>';
        $pdf .= '<center><b>NIT: ' . $this->gsatelite->get_parametro('SYS_NIT') . '</b></center><br>';
        $pdf .= '<center><b>NRC :' . $this->gsatelite->get_parametro('SYS_REGISTRO') . '</b></center><br>';
        $pdf .= '<center><b>Kardex del ' . date('d/m/Y', strtotime($fecha_ini)) . ' al ' . date('d/m/Y', strtotime($fecha_fin)) . '</b></center><br>';
        $pdf .= '<center><b>' . $nombre_bodega . '</b></center><br>';
        $pdf .= '<center><b>MEDIDA: ' . $nombre_prod[0]['mep_nombre'] . '</b></center>';
        $pdf .= '</td>';
        $pdf .= '<td align="right" width="35%">';
        $pdf .= '<div align="right"><font style="float:right"><b>Fecha: ' . date('d/m/Y') . '</b></font></div>';
        $pdf .= '</td>';
        //$pdf .=         '<span style="font-size: 12px; font-weight: bold;" class="fuente_titulo">';
        $pdf .= '</tr>';
        $pdf .= '<tr><td colspan="3"></td></tr>';
        $pdf .= '<tr><td colspan="3"><hr></td></tr>';
        $pdf .= '</table>';

        $cantidad_totales = $suma_cantidad_entrada - $suma_cantidad_salida;
        $precio_totales = $suma_total_entrada - $suma_total_salida;
        $costo_sal_ant = number_format($dee_sal_anterior, $num_decimales);
        if ($aplica_costo_promedio == 1 && $cantidad_totales > 0) {
            $costo_sal_ant = number_format($precio_totales / $cantidad_totales, $num_decimales);
        }
        $costo_sal_ant = ($cantidad_totales == 0) ? number_format(0, $num_decimales): $costo_sal_ant;
        $cosplan_header = ($mostrar_costo == 0) ? 7 : 1;  //9:3
        $html .= '<tr>';
            $html .= '<th colspan="2" style="text-align:left">' . $nombre_prod[0]['art_codigo'] . '</th>';
            $html .= '<th colspan="' . $cosplan_header . '">' . $nombre_prod[0]['art_nombre'] . '</th>';
            $html .= '<th colspan="4">' . $nombre_prod[0]['mrp_nombre'] . '</th>';
            $html .= '<th colspan="1">Saldo Anterior</th>';
            $html .= '<th colspan="1">' . number_format($cantidad_totales, $num_decimales) . '</th>';
            $html .= '<th colspan="1"></th>';
            if ($mostrar_costo != 0) {
               $html .= '<th colspan="1"></th>';
            } else {
                $html .= '<th colspan="1">$' . number_format($precio_totales, $num_decimales) . '</th>';
            }
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<th>';
        $html .= 'No.';
        $html .= '</th>';
        $html .= '<th colspan="2">';
        $html .= 'MOVIMIENTO';
        $html .= '</th>';
        $html .= '<th>';
        $html .= 'REFERENCIA';
        $html .= '</th>';
        $html .= '<th>';
        $html .= 'BODEGA';
        $html .= '</th>';
        $html .= '<th colspan="2">';
        $html .= 'PROVEEDOR';
        $html .= '</th>';
        $html .= '<th>';
        $html .= 'USUARIO';
        $html .= '</th>';
        $html .= '<th colspan="' . $coslpan_header . '">';
        $html .= 'ENTRADAS';
        $html .= '</th>';
        $html .= '<th colspan="' . $coslpan_header . '">';
        $html .= 'SALIDAS';
        $html .= '</th>';
        $html .= '<th colspan="' . $coslpan_header . '">';
        $html .= 'EXISTENCIAS';
        $html .= '</th>';
        $html .= '</tr>';
        $html .= '</thead><tbody id="contenedor">';
        $contador = 1;
        $saldo_acum = 0;
        if (!empty($kardex_prod)) {
            $html .= '<tr>';
            /* $html .= '<td></td>';
              $html .= '<td></td>'; */
            $html .= '<td></td>';
            $html .= '<td>Tipo</td>';
            $html .= '<td>Fecha</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td>Nombre</td>';
            $html .= '<td>Nacionalidad</td>';
            $html .= '<td></td>';
            $html .= '<td>Unidades</td>';
            if ($mostrar_costo == 0) {
                $html .= '<td class="costos">Costo U</td>';
                $html .= '<td>Total</td>';
            }

            $html .= '<td>Unidades</td>';
            if ($mostrar_costo == 0) {
                $html .= '<td>Costo U</td>';
                $html .= '<td>Total</td>';
            }

            $html .= '<td>Unidades</td>';
            if ($mostrar_costo == 0) {
                $html .= '<td>Costo U</td>';
                $html .= '<td colspan="1"><span style="alignment:right;">Total</span></td>';
            }


            $html .= '</tr>';

            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Saldo Inicial</td>';
            /* $html .= '<td></td>';
              $html .= '<td></td>'; */
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            if ($mostrar_costo == 0) {
                $html .= '<td class="costos"></td>';
                $html .= '<td></td>';
            }

            $html .= '<td></td>';
            if ($mostrar_costo == 0) {
                $html .= '<td></td>';
                $html .= '<td></td>';
            }
            $html .= '<td style="text-align:right;">' . number_format($cantidad_totales, $num_decimales) . '</td>';
            $saldo_acum += number_format($cantidad_totales, $num_decimales, '.', '');
            if ($mostrar_costo == 0) {
                $html .= '<td class="decimales" style="text-align:right;">$' . $costo_sal_ant . '</td>';
                $html .= '<td class="decimales">$' . number_format($precio_totales, $num_decimales) . '</td>';
            }
            $html .= '</tr>';
            $temp = 0;
            $band = 0;
            $cantidad_entrada = 0;
            $precios_entrada = 0;
            $cantidad_salida = 0;
            $precios_salida = 0;
            $dee_cantidad1 = array();
            $dee_cantidad2 = array();
            $dee_precio1 = array();
            $dee_precio2 = array();
            $monto_existencia = array();
            $entradas = array();
            $salidas = array();
            $cantidad_existencia = array();
            $acumulativo_cantidad_entradas = 0;
            $acumulativo_precio_entradas = 0;
            $acumulativo_total_entradas = 0;
            $entrada = -1;
            $costo_promedio = $costo_sal_ant;
            //print_r($kardex_prod); die();
            foreach ($kardex_prod as $key) {
                $html .= '<tr>';
                $html .= '<td>' . $contador . '</td>';
                if ($key['tip_entrada'] == 1) {
                    $html .= '<td style="text-align:left;">' . $key['tip_nombre'] . '</td>';
                } else if ($key['tip_salida'] == 1) {
                    $html .= '<td style="text-align:right;">' . $key['tip_nombre'] . '</td>';
                }
                $html .= '<td>' . date("d/m/Y", strtotime($key['moi_fecha_mov'])) . '</td>';
                $html .= '<td>';
                /***********************************************************/
                // Codigo que aparece en el reporte en el campo de referencia
                if(trim($key['fac_numero']) != ""){
                    $serie = (isset($key['serie_fac']))?'-'.$key['serie_fac']:'';
                    $html .=  $key['tif_abreviacion'] .$serie.'-'. $key['fac_numero']; 
                }else {
                    $serie = (isset($key['dpv_serie_documento']) && $key['dpv_serie_documento'] != "")?'-'.$key['dpv_serie_documento']:'';
                    $html .=  ((trim($key['ord_codigo']) != "")?$key['ord_codigo']:((trim($key['abre2'])!='')?$key['abre2'].$serie.'-'.$key['moi_documento']:$key['moi_documento'])) ;
                }
                /***********************************************************/
                $html .= '</td>';
                $html .= '<td>' . $key['bod_nombre'] . '</td>';
                $html .= '<td>' . $key['prv_nombre'] . '</td>';
                $html .= '<td>' . $key['pai_nacionalidad'] . '</td>';
                $usuario = $this->gsatelite->get_campo('users','username', array('id'=>$key['usuario']));
                $html .= '<td>' . $usuario.' '. '</td>';
                $contador ++;
                if ($aplica_costo_promedio == 0) {
                    $costo_temp = number_format($key['dee_precio'], $num_decimales);
                    if ($band == 0) {
                        $temp = $costo_temp;
                        $band = 1;
                    }
                }
                if ($key['tip_entrada'] == 1) {
                    $entrada++;
                    $acumulativo_cantidad_entradas += $key['dee_cantidad'];
                    $acumulativo_precio_entradas += $key['sar_precio'];
                    $acumulativo_total_entradas += $key['dee_cantidad'] * $key['dee_precio'];
                    $costo_promedio = $acumulativo_total_entradas/$acumulativo_cantidad_entradas;
                    //$costo_promedio = $key['dee_precio'];
                    $cantidad_entrada += $key['dee_cantidad'];
                    $saldo_acum += number_format($key['dee_cantidad'], $num_decimales, '.', '');
                    $html .= '<td style="color: blue; text-align:right;">' . number_format($key['dee_cantidad'], $num_decimales) . '</td>';
                    if ($mostrar_costo == 0) {
                        $html .= '<td class="costos decimales" style="color: blue; text-align:right;">$' . number_format($key['dee_precio'], $num_decimales) . '</td>';
                        $html .= '<td class="decimales" style="color: blue; text-align:right;">$' . number_format(($key['dee_cantidad'] * $key['dee_precio']), $num_decimales) . '</td>';
                    }
                    $html .= '<td>&nbsp;</td>';
                    if ($mostrar_costo == 0) {
                        $html .= '<td>&nbsp;</td>';
                        $html .= '<td>&nbsp;</td>';
                    }
                    $total_entradas = round(($key['dee_cantidad'] * $key['dee_precio']), $num_decimales);
                    $precios_entrada += $total_entradas;
                    array_push($entradas, $total_entradas);
                    $t_entradas = array_sum($entradas);
                    array_push($dee_cantidad1, $key['dee_cantidad']);
                    $ttc1 = array_sum($dee_cantidad1);
                    array_push($dee_precio1, $key['dee_precio']);
                    $ttp1 = array_sum($dee_precio1);
                }
                if ($key['tip_salida'] == 1) {
                    if ($aplica_costo_promedio == 0) {
                        if ($temp != $key['dee_precio']) {
                            $band = 0;
                        }
                        if ($band == 0) {
                            $temp = $costo_temp;
                            $band = 1;
                        }
                    }
                    $cantidad_salida += $key['dee_cantidad'];
                    $saldo_acum -= number_format($key['dee_cantidad'], $num_decimales, '.', '');
                    $html .= '<td style="color: red; text-align:right;">&nbsp;</td>';
                    if ($mostrar_costo == 0) {
                        $html .= '<td>&nbsp;</td>';
                        $html .= '<td>&nbsp;</td>';
                    }
                    $html .= '<td style="color: red; text-align:right;">' . number_format($key['dee_cantidad'], $num_decimales) . '</td>';
                    if ($mostrar_costo == 0) {
                        $html .= '<td class="costos decimales" style="color: red; text-align:right;">$' . number_format($key['dee_precio'], $num_decimales) . '</td>';
                        $html .= '<td class="decimales" style="color: red; text-align:right;">$' . number_format(($key['dee_cantidad'] * $key['dee_precio']), $num_decimales) . '</td>';
                    }
                    $total_salidas = round(($key['dee_cantidad'] * $key['dee_precio']), $num_decimales);
                    $precios_salida += $total_salidas;
                    array_push($salidas, $total_salidas);
                    $t_salidas = array_sum($salidas);
                    array_push($dee_cantidad2, $key['dee_cantidad']);
                    $ttc2 = array_sum($dee_cantidad2);
                    array_push($dee_precio2, $key['dee_precio']);
                    $ttp2 = array_sum($dee_precio2);
                }
                if (end(explode(',', $key['cantidad_existencia'])) == null) {
                    $html .= '<td>0</td>';
                    $html .= '<td class="decimales" colspan="1"><span style="alignment:right;">$' . number_format(0, $num_decimales) . '</span></td>';
                } else {
                    if ($key['tip_salida'] == 1) {
                        $existencia_reporte = number_format(end(explode(',', $key['cantidad_existencia'])), $num_decimales, '.', '');
                        // $existencia_monto_reporte = number_format(end(explode(',', $key['monto_existencia'])), $num_decimales, '.', '');
                        $temp = number_format($key['dee_precio'], $num_decimales, '.', '');
                        $existencia_monto_reporte = number_format(($saldo_acum * $temp), $num_decimales, '.', '');
                        if ($aplica_costo_promedio == 1) {
                            $temp = number_format($costo_promedio, $num_decimales);
                            $existencia_monto_reporte = number_format(($saldo_acum * $costo_promedio), $num_decimales, '.', '');//$existencia_reporte
                            //number_format(end(explode(',', $key['monto_existencia'])) / end(explode(',', $key['cantidad_existencia'])), $num_decimales);
                        }//$existencia_reporte
                        $html .= '<td style="color: red; text-align:right;">' . number_format($saldo_acum, $num_decimales) . '</td>';
                        if ($mostrar_costo == 0) {
                            $html .= '<td class="costos decimales" style="color: red; text-align:right;">$' . number_format($temp, $num_decimales) . '</td>';
                            $html .= '<td class="decimales" colspan="1" style="color: red;"><span style="alignment:right;">$' . number_format($existencia_monto_reporte, $num_decimales) . '</span></td>';
                        }
                    } else if ($key['tip_entrada'] == 1) {                        
                        $existencia_reporte = number_format(end(explode(',', $key['cantidad_existencia'])), $num_decimales, '.','');
                        // $existencia_monto_reporte = number_format(end(explode(',', $key['monto_existencia'])), $num_decimales, '.', '');
                        $temp = number_format($key['dee_precio'], $num_decimales, '.', '');
                        $existencia_monto_reporte = number_format(($saldo_acum * $temp), $num_decimales, '.', '');//$existencia_reporte
                        if ($aplica_costo_promedio == 1) {
                            $temp = number_format($costo_promedio, $num_decimales);
                            $existencia_monto_reporte = number_format(($saldo_acum * $costo_promedio), $num_decimales, '.', '');//$existencia_reporte
                            //1000;// number_format(end(explode(',', $key['monto_existencia'])) / end(explode(',', $key['cantidad_existencia'])), $num_decimales);
                        }//$existencia_reporte
                        $html .= '<td style="color: blue; text-align:right;">'. number_format($saldo_acum, $num_decimales) . '</td>';
                        if ($mostrar_costo == 0) {
                            $html .= '<td class="costos decimales" style="color: blue; text-align:right;">$' . number_format($temp, $num_decimales) . '</td>';
                            $html .= '<td class="decimales" colspan="1" style="color: blue;"><span style="alignment:right;">$' . number_format($existencia_monto_reporte , $num_decimales) . '</span></td>';
                        }
                    }

                    array_push($cantidad_existencia, end(explode(',', $key['cantidad_existencia'])));
                    $total_cantidad_existencia = array_sum($cantidad_existencia);
                    array_push($monto_existencia, end(explode(',', $key['monto_existencia'])));
                    $total_monto_existencia = array_sum($monto_existencia);
                }

                $html .= '</tr>';
            }
            $html .= '<tr>';
            $html .= '<td colspan="2">Totales del Movimiento:</td>';
            $html .= '<td>al ' . date('d/m/Y', strtotime($fecha_fin)) . '</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td style="text-align:right;">' . number_format($cantidad_entrada, $num_decimales) . '</td>';

            if ($mostrar_costo == 0) {
                $html .= '<td></td>';
                $html .= '<td class="decimales" style="text-align:right;">$' . number_format($precios_entrada, $num_decimales) . '</td>';
            }

            $html .= '<td style="text-align:right;">' . number_format($cantidad_salida, $num_decimales) . '</td>';

            if ($mostrar_costo == 0) {
                $html .= '<td></td>';
                $html .= '<td class="decimales" style="text-align:right;">$' . number_format($precios_salida, $num_decimales) . '</td>';
            }
            $html .= '<td style="text-align:right;">' .  number_format($saldo_acum, $num_decimales) . '</td>';//$existencia_reporte
            if ($mostrar_costo == 0) {
                $html .= '<td style="text-align:right;"></td>';
                $html .= '<td class="decimales" colspan="1"><span style="alignment:right;">' . '$' . number_format($existencia_monto_reporte, $num_decimales) . '</span></td>';
            }            
            $html .= '</tr>';
            $html .= '</tbody>';
        } else {
            $cosplan_cero_datos = ($mostrar_costo == 0) ? 17 : 11;
            if ($precio_totales > 0) {
                $cp1 = ($mostrar_costo == 0) ? 11 : 7;
                $html .= '<tr><td></td><td colspan="2">Saldo Anterior hasta el '.formatear_fecha('d-m-Y', $fecha_ini).'</td><td colspan="'.$cp1.'"></td>';
                $html .= '<td style="text-align:right;">' . number_format($cantidad_totales, $num_decimales) . '</td>';
                if ($mostrar_costo == 0) {
                    $html .= '<td></td>';
                    $html .= '<td class="decimales">$' . number_format($precio_totales, $num_decimales) . '</td>';
                }
                $html .= '</tr>';
            }

            $html .= '<tr><td colspan="' . $cosplan_cero_datos . '" style="text-align:center;">NO SE ENCONTRARON MÁS REGISTROS</td>';

            $html .= '</tr>';
        }

        $arreglo = array(
            "drop" => $excel . $html,
            "pdf" => $pdf . '<table border="1" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried" style="font-size:7px;"><thead>' . $html . '</table>'
        );

        echo json_encode($arreglo);
    }

    function get_kardex_tipo() {
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $flag ='';
        $ultima_categoria = $this->input->post('categoria');
        $categoria_val = $ultima_categoria;
        $bodega = $this->input->post('bodega');
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $ocultarCosto = $this->input->post('ocultarCosto');
        $total_entradas_general = 0;
        $total_salidas_general = 0;
        $total_existencia_general = 0;
        $total_entrada_costo_general = 0;
        $total_salida_costo_general = 0;
        $total_existencia_costo_general = 0;
        if ($fecha_ini > $fecha_fin) {
            die();
        }
        $bodega_name = ($bodega > 0) ? $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $bodega)) : 'Todas las Bodegas';
        $nomb_bod = 'Bodega: ' . $bodega_name;
        $cabezera = '';
        $cabezera2 = '';
        $colspan_header = ($ocultarCosto == 0) ? 16 : 10;
        $excel = '<thead> <tr nobr="true">';
        $excel .= '<th colspan="' . $colspan_header . '" height="5" align="right">';
        $excel .= '<font style="float:right"><b>Fecha: ' . date('d/m/Y') . '</b></font><br>';
        $excel .= '<center><b style="font-size:20px">' . $this->gsatelite->get_parametro('SYS_EMPRESA') . '</b></center>';
        $excel .= '<center><b>NIT: ' . $this->gsatelite->get_parametro('SYS_NIT') . '</b></center>';
        $excel .= '<center><b>NRC :' . $this->gsatelite->get_parametro('SYS_REGISTRO') . '</b></center>';
        $excel .= '<center><b>' . $nomb_bod . '</b></center>';
        $excel .= '<center><b>Kardex del ' . date('d/m/Y', strtotime($fecha_ini)) . ' al ' . date('d/m/Y', strtotime($fecha_fin)) . '</b></center>';
        $excel .= '</th>';
        $excel .= '</tr>';

        $pdf = '<table cellpadding="0">';
        $pdf .= '<tr nobr="true">';
        $pdf .= '<td align="left" width="35%">';
        $pdf .= '<br><img height="48px" width="auto" src="' . base_url() . 'media/imagenes/sistema/' . $this->gsatelite->get_parametro('SYS_LOGOTIPO') . '.png">';
        $pdf .= '</td>';
        $pdf .= '<td align="center" width="30%">';
        $pdf .= '<b style="font-size:12px">' . $this->gsatelite->get_parametro('SYS_EMPRESA') . '</b></center><br>';
        $pdf .= '<center><b>NIT: ' . $this->gsatelite->get_parametro('SYS_NIT') . '</b></center><br>';
        $pdf .= '<center><b>NRC :' . $this->gsatelite->get_parametro('SYS_REGISTRO') . '</b></center><br>';
        $pdf .= '<center><b>' . $nomb_bod . '</b></center><br>';
        $pdf .= '<center><b>Kardex del ' . date('d/m/Y', strtotime($fecha_ini)) . ' al ' . date('d/m/Y', strtotime($fecha_fin)) . '</b></center><br>';
        $pdf .= '</td>';
        $pdf .= '<td align="right" width="35%">';
        $pdf .= '<div align="right"><font style="float:right"><b>Fecha: ' . date('d/m/Y') . '</b></font></div>';
        $pdf .= '</td>';
        $pdf .= '</tr>';
        $pdf .= '<tr nobr="true"><td colspan="3"></td></tr>';
        $pdf .= '<tr nobr="true"><td colspan="3"><hr></td></tr>';
        $pdf .= '</table>';

        $cabezera .= '<thead>';
        $cabezera .= '<tr nobr="true">';
        $cabezera .= '<th>';
        $cabezera .= 'No.';
        $cabezera .= '</th>';
        $cabezera .= '<th colspan="2">';
        $cabezera .= 'MOVIMIENTO';
        $cabezera .= '</th>';
        $cabezera .= '<th>';
        $cabezera .= 'REFERENCIA';
        $cabezera .= '</th>';
        $cabezera .= '<th>';
        $cabezera .= 'BODEGA';
        $cabezera .= '</th>';
        $cabezera .= '<th colspan="2">';
        $cabezera .= 'PROVEEDOR';
        $cabezera .= '</th>';

        $colspan_header = ($ocultarCosto == 0) ? 3 : 1;

        $cabezera .= '<th colspan="' . $colspan_header . '">';
        $cabezera .= 'ENTRADAS';
        $cabezera .= '</th>';
        $cabezera .= '<th colspan="' . $colspan_header . '">';
        $cabezera .= 'SALIDAS';
        $cabezera .= '</th>';
        $cabezera .= '<th colspan="' . $colspan_header . '">';
        $cabezera .= 'EXISTENCIAS';
        $cabezera .= '</th>';
        $cabezera .= '</tr></thead>';

        $cabezera2 .= '<tbody id="contenedor">';
        $cabezera2 .= '<tr nobr="true">';
        $cabezera2 .= '<td></td>';
        $cabezera2 .= '<td>Tipo</td>';
        $cabezera2 .= '<td>Fecha</td>';
        $cabezera2 .= '<td></td>';
        $cabezera2 .= '<td></td>';
        $cabezera2 .= '<td>Nombre</td>';
        $cabezera2 .= '<td>Nacionalidad</td>';
        $cabezera2 .= '<td>Unidades</td>';

        //Se ocultan las columnas segun el flag
        if ($ocultarCosto == 0) {
            $cabezera2 .= '<td>Costo U</td>';
            $cabezera2 .= '<td>Total</td>';
        }

        $cabezera2 .= '<td>Unidades</td>';
        if ($ocultarCosto == 0) {
            $cabezera2 .= '<td>Costo U</td>';
            $cabezera2 .= '<td>Total</td>';
        }
        $cabezera2 .= '<td>Unidades</td>';
        if ($ocultarCosto == 0) {
            $cabezera2 .= '<td>Costo U</td>';
            $cabezera2 .= '<td><span style="text-align:right;">Saldo</span></td>';
        }
        $cabezera2 .= '</tr>';

        $padre_del_padre = array();
        $i = 0;

        //Se validan las categorias
        /*if($ultima_categoria == ""){
            //Si no hay ninguna categoria se buscan todas las existentes con saldos ya sea por bodega o en general
            $categorias_total = $this->inventario_model->get_categorias($bodega);
            foreach ($categorias_total as $y) {
                $padre_del_padre[] = $y['tia_id'];
            }
            array_push($padre_del_padre, '');
        }else{
            $arbol_cat = $this->inventario_model->crear_arbol($ultima_categoria);
            $categorias_split = explode(',',$arbol_cat);
            for($k = 0; $k < count($categorias_split); $k++){
                if($categorias_split[$k]!=''){
                    $padre_del_padre[] = $categorias_split[$k];
                }
            }

            /*while ($ultima_categoria != null) {
                if ($i == 0) {
                    $padre_del_padre[] = $ultima_categoria;
                } else {
                    $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria = $ultima_categoria['tia_padre'];
                    $padre_del_padre[] = $ultima_categoria;
                }
                $i++;
            }
            }*/
        
        $categorias_final = array();
        $categoria_arbol = $this->inventario_model->crear_arbol($ultima_categoria, "");
        if($categoria_arbol != ''){
            $categorias_final = explode(',', $categoria_arbol);
            //se eliminan los espacios vacios
            $categorias_final = array_filter($categorias_final, function ($value){
                return !is_null($value) && $value !== '';
            });
            $categorias_final[] = $ultima_categoria;
        }else{
            if ($ultima_categoria != "") {
                $padre_x_padre = array();
                $i = 0;
                while ($ultima_categoria != null) {
                    if ($i == 0) {
                        $padre_x_padre[] = $ultima_categoria;
                    } else {
                        $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                        $ultima_categoria = $ultima_categoria['tia_padre'];
                        $padre_x_padre[] = $ultima_categoria;
                    }
                    $i++;
                }
                $padre_x_padre = array_filter($padre_x_padre, function ($value){
                    return !is_null($value) && $value !== '';
                });
                $categorias_final = array_reverse($padre_x_padre);
            } else {
                $categorias_total = $this->inventario_model->get_categorias();
                foreach ($categorias_total as $y) {
                    $padre_del_padre = explode(',', $this->inventario_model->crear_arbol($y['tia_id'], ""));
                    $padre_del_padre = array_filter($padre_del_padre, function ($value){
                        return !is_null($value) && $value !== '';
                    });
                    if (count($padre_del_padre) > 0) {
                        $padre_del_padre[] = $y['tia_id'];
                        $categorias_final = array_merge($categorias_final, $padre_del_padre);
                    }
                }
            }
        }

        //print_r($categorias_final);die();
        //print_r(implode(',',$categorias_final));die();
        /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */

        $cadena = ""; // arreglo que mandaremos en un json
        $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije
        foreach ($categorias_final as $key => $value) {
            if ($key != null) {
                $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
            }
        }

        //print_r($elementos);die();
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 14;
        } else {
            $col = 11;
        }
        $ultimo_padre = end($elementos);
        // var_dump($ultimo_padre);die();
        $departamento_inf_tr = "";
        $departamento_infe_tr = "";
        $i = 1;
        $colspan_header = ($ocultarCosto == 0) ? 16 : 10;
        $cuerpo_array = array();
        foreach ($elementos as $key => $value) {

            //var_dump($value);
            foreach ($value as $ids => $valores) {
                $ids2 = $ids;
                if ($categoria_val == "") {
                    $ids2 = key($ultimo_padre);
                }
                //if ($ids2!= key($ultimo_padre)) {
                    $departamento_infe_tr = '<tr nobr="true"><td colspan="' . $colspan_header . '"><b><br />Departamento ' . $i . ': ' . $valores . '</b></td></tr>';
                //}else{
                    //var_dump($ids);
                    $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);
                    if (count($tia_hijo) > 0) {
                        $departamento_inf_tr .= $departamento_infe_tr;
                        foreach ($tia_hijo as $tia => $tipo) {
                            $informacion = $this->inventario_model->kardex_tipo($tipo['tia_id'], $bodega, $fecha_ini, $fecha_fin);
                            $cat_cuenta = $this->gsatelite->get_campo('tia_tipo_articulo', 'tia_id_cco', array('tia_estado' => 1, 'tia_id' => $tipo['tia_id']));
                            $cuenta_nombre = $this->gsatelite->get_campo('cco_cuenta_contable', 'cco_nombre', array('cco_id' => $cat_cuenta));
                            $cuenta = '';
                            if ($flag == 1) {
                                if (!empty($cuenta_nombre)) {
                                    $cuenta = ", Cuenta Contable : " . $cuenta_nombre;
                                }
                            }

                            if (count($informacion) > 0) {
                                $departamento_inf_tr .= '<tr nobr="true"><td colspan="' . $colspan_header . '"><b><br />Categoría : ' . $tipo['tia_nombre'] . $cuenta . '</b></td></tr>';
                                $departamento_inf_tr .=  $cabezera2;
                                $cuerpo_array = $this->cuerpo_kardex($informacion, $fecha_ini, $fecha_fin, $bodega, $ocultarCosto);
                                //var_dump( $cuerpo_array );
                                $departamento_inf_tr .= $cuerpo_array['html'];
                                 //Se suman los totales.
                                $total_entradas_general += $cuerpo_array['totales']['cantidad_entrada'];
                                $total_salidas_general += $cuerpo_array['totales']['cantidad_salida'];
                                $total_existencia_general += $cuerpo_array['totales']['existencia_reporte'];
                                $total_entrada_costo_general += $cuerpo_array['totales']['precios_entrada'];
                                $total_salida_costo_general += $cuerpo_array['totales']['precios_salida'];
                                $total_existencia_costo_general += $cuerpo_array['totales']['existencia_monto_reporte'];
                            }
                        }
                    } else {
                        $informacion = $this->inventario_model->kardex_tipo($ids, $bodega, $fecha_ini, $fecha_fin);
                        $cat_cuenta = $this->gsatelite->get_campo('tia_tipo_articulo', 'tia_id_cco', array('tia_estado' => 1, 'tia_id' => $ids));
                        $cuenta_nombre = $this->gsatelite->get_campo('cco_cuenta_contable', 'cco_nombre', array('cco_id' => $cat_cuenta));
                        $cuenta = '';
                        if ($flag == 1) {
                            if (!empty($cuenta_nombre)) {
                                $cuenta = ", Cuenta Contable : " . $cuenta_nombre;
                            }
                        }
                        if (count($informacion) > 0) {
                            if (!empty($cuenta_nombre)) {
                                $departamento_inf_tr .= '<tr nobr="true"><td colspan="' . $colspan_header . '"><b>Cuenta Contable: ' . $cuenta_nombre . '</b></td></tr>';
                            }
                            $departamento_inf_tr .= '<tr nobr="true"><td colspan="' . $colspan_header . '"><b>Categoría : ' . $valores . '</b></td></tr>';

                            $departamento_inf_tr .= $cabezera2;
                             $cuerpo_array = $this->cuerpo_kardex($informacion, $fecha_ini, $fecha_fin, $bodega, $ocultarCosto);
                             $departamento_inf_tr .= $cuerpo_array['html'];
                        }
                    }
                //}

               

            } // End foreach categorrías
            $i++;

            
        } // End foreach elementos

        

        
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $departamento_inf_tr.="<tr>";
        $departamento_inf_tr.='<td colspan="2">Total General</td>';
        $departamento_inf_tr .= "<td> al ".formatear_fecha('d-m-Y',$fecha_fin)."</td>"; 
        $departamento_inf_tr .= "<td></td>";
        $departamento_inf_tr .= "<td></td>";
        $departamento_inf_tr .= "<td></td>";
        $departamento_inf_tr .= "<td></td>";
        $departamento_inf_tr .= '<td style="text-align:right;">'.number_format($total_entradas_general, $decimales)."</td>";
        if ($ocultarCosto == 0) {
            $departamento_inf_tr .= "<td></td>";
            $departamento_inf_tr .= '<td class="decimales" style="text-align:right;">$'.number_format($total_entrada_costo_general, $decimales)."</td>";
        }
        $departamento_inf_tr .= '<td style="text-align:right;">'.number_format($total_salidas_general, $decimales)."</td>";
        if ($ocultarCosto == 0) {
            $departamento_inf_tr .= "<td></td>";
            $departamento_inf_tr .= '<td class="decimales" style="text-align:right;">$'.number_format($total_salida_costo_general, $decimales)."</td>";
        }
        $departamento_inf_tr .= '<td style="text-align:right;">'.number_format($total_existencia_general, $decimales)."</td>";
        if ($ocultarCosto == 0) {
            $departamento_inf_tr .= "<td></td>";
            $departamento_inf_tr .= '<td class="decimales" style="text-align:right;">$'.number_format($total_existencia_costo_general, $decimales)."</td>";
        }
        $departamento_inf_tr.="</tr>";


        /*if (empty($informacion)&& $categoria_val != "") {
            $cadena .= $cabezera . '<tr nobr="true"><td colspan="' . $colspan_header . '" style="text-align:center;">NO SE ENCONTRARON REGISTROS</td></tr>';
        } else {*/
            $cadena .= $cabezera . $departamento_inf_tr;
        //}
        $arreglo = array(
            "drop" => $excel . $cadena,
            "pdf" => $pdf . '<table border="1" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried" style="font-size:7px;">' . $cadena . '</table>'
        );

        echo json_encode($arreglo);
    }

    public function cuerpo_kardex($informacion, $fecha_ini, $fecha_fin, $id_bod, $ocultarCostos) {
        //die(print_r($id_bod.'/'));
        $temp_art = "";
        $contador = 1;
        $temp = 0;
        $band = 0;
        $band2 = 0;
        $cantidad_entrada = 0;
        $precios_entrada = 0;
        $cantidad_salida = 0;
        $precios_salida = 0;
        $dee_cantidad1 = array();
        $dee_cantidad2 = array();
        $dee_precio1 = array();
        $dee_precio2 = array();
        $monto_existencia = array();
        $entradas = array();
        $salidas = array();
        $cantidad_existencia = array();
        $html = "";
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $fecha_sal_anterior = formatear_fecha("Y-m-d", $fecha_ini);
        $suma_cantidad_salida = 0;
        $suma_cantidad_entrada = 0;
        $suma_total_salida = 0;
        $suma_total_entrada = 0;
        $precio_totales = 0;
        $cantidad_totales = 0;
        $dee_sal_anterior = 0;

        $where_saldo_anterior = array(
            "dee_id_art" => $informacion[0]["art_id"],
            "DATE(moi_fecha_mov) < " => $fecha_sal_anterior
        );

        if($id_bod!=''){
            $where_saldo_anterior['moi_id_bod'] =$id_bod;
        }

        $saldos_anteriores = $this->inventario_model->get_saldo_anterior($where_saldo_anterior);
        // print_r($this->db->last_query());die();  
        foreach ($saldos_anteriores as $key) {
            if ($key["cantidad_entrada"] != null) {
                $suma_cantidad_entrada += $key["cantidad_entrada"];
                $suma_total_entrada += $key["total_entrada"];
            }
            if ($key["cantidad_salida"] != null) {
                $suma_cantidad_salida += $key["cantidad_salida"];
                $suma_total_salida += $key["total_salida"];
            }
            $dee_sal_anterior = $key["dee_precio"];
        }
        $cantidad_totales = $suma_cantidad_entrada - $suma_cantidad_salida;
        $precio_totales = $suma_total_entrada - $suma_total_salida;

        $colspan_art = ($ocultarCostos == 0) ? 6 : 3; //9 : 3
        $colspan_art2 = ($ocultarCostos == 0) ? 4 : 1;

        /************************ Fila Categoría *************************************************/
        $html .= '<tr nobr="true">';
        $html .= '<td colspan="2" style="text-align:right">' . $informacion[0]['art_codigo'] . '</td>';
        $html .= '<td colspan="' . ($colspan_art + 1). '">' . $informacion[0]['art_nombre'] . '</td>';
        $html .= '<td colspan="' . $colspan_art2 . '">' . $informacion[0]['marca'] . '</td>';
        $html .= '<td colspan="1">Saldo anterior</td>';
        $html .= '<td class="decimales" colspan="1">$' . number_format($cantidad_totales, $decimales) . '</td>';
        $html .= '<td class="decimales" colspan="1">$' . number_format($precio_totales, $decimales) . '</td>';
        $html .= '</tr>';

        /******************************* Detalles del Kardex ***********************************/
        foreach ($informacion as $key) {
            if ($temp_art != $key['dee_id_art']) {
                if ($band2 != 0) {
                    $contador = 1;
                    $html .= '<tr nobr="true">';
                    $html .= '<td colspan="2">Totales del Movimientos:</td>';
                    $html .= '<td>al ' . date('d/m/Y', strtotime($fecha_fin)) . '</td>';
                    $html .= '<td></td>';
                    $html .= '<td></td>';
                    $html .= '<td></td>';
                    $html .= '<td></td>';
                    $html .= '<td style="text-align:right;">' . number_format($cantidad_entrada, $decimales) . '</td>';
                    if ($ocultarCostos == 0) {
                        $html .= '<td></td>';
                        $html .= '<td class="decimales" style="text-align:right;">$' . number_format($precios_entrada, $decimales) . '</td>';
                    }
                    $html .= '<td style="text-align:right;">' . number_format($cantidad_salida, $decimales) . '</td>';

                    if ($ocultarCostos == 0) {
                        $html .= '<td></td>';
                        $html .= '<td class="decimales" style="text-align:right;">$' . number_format($precios_salida, $decimales) . '</td>';
                    }
                    $html .= '<td style="text-align:right;">' . $existencia_reporte . '</td>';

                    if ($ocultarCostos == 0) {
                        $html .= '<td style="text-align:right;"></td>';
                        $html .= '<td class="decimales" style="text-align:right;">' . '$' . $existencia_monto_reporte . '</td>';
                    }
                    $html .= '</tr>';

                    $html .= '<tr nobr="true">';

                    $colspan_totales = ($ocultarCostos == 0) ? 16 : 10;

                    $html .= '<td colspan="' . $colspan_totales . '"></td>';
                    $html .= '</tr>';

                    $cantidad_entrada = 0;
                    $precios_entrada = 0;
                    $cantidad_salida = 0;
                    $precios_salida = 0;

                    $suma_cantidad_salida = 0;
                    $suma_cantidad_entrada = 0;
                    $suma_total_salida = 0;
                    $suma_total_entrada = 0;
                    $precio_totales = 0;
                    $cantidad_totales = 0;

                    $dee_sal_anterior = 0;
                    $saldos_anteriores = $this->inventario_model->get_saldo_anterior(array("dee_id_art" => $key["art_id"], "moi_id_bod" => $id_bod, "moi_fecha_mov <" => $fecha_sal_anterior));
                    foreach ($saldos_anteriores as $key2) {
                        if ($key2["cantidad_entrada"] != null) {
                            $suma_cantidad_entrada += $key2["cantidad_entrada"];
                            $suma_total_entrada += $key2["total_entrada"];
                        }
                        if ($key2["cantidad_salida"] != null) {
                            $suma_cantidad_salida += $key2["cantidad_salida"];
                            $suma_total_salida += $key2["total_salida"];
                        }
                        $dee_sal_anterior = $key2["dee_precio"];
                    }

                    $cantidad_totales = $suma_cantidad_entrada - $suma_cantidad_salida;
                    $precio_totales = $suma_total_entrada - $suma_total_salida;

                    $html .= '<tr nobr="true">';
                    $html .= '<td colspan="2" style="text-align:right">' . $key['art_codigo'] . '</td>';
                    $coslpan_articulo = ($ocultarCostos == 0 ) ? 11 : 6;
                    $html .= '<td colspan="' . $coslpan_articulo . '">' . $key['art_nombre'] . '</td>';
                    $html .= '<td colspan="1">Saldo anterior</td>';
                    $html .= '<td colspan="1">' . number_format($cantidad_totales, $decimales) . '</td>';
                    if ($ocultarCostos == 0) {
                        $html .= '<td class="decimales" colspan="1">$' . number_format($precio_totales, $decimales) . '</td>';
                    }
                    $html .= '</tr>';
                }
                $band2 = 1;
            }
            $temp_art = $key['dee_id_art'];

            $html .= '<tr nobr="true">';
            $html .= '<td>' . $contador . '</td>';
            $html .= '<td>' . $key['tip_nombre'] . '</td>';
            $html .= '<td>' . date("d/m/Y", strtotime($key['moi_fecha_mov'])) . '</td>';
            //$html .= '<td>' . ((trim($key['ord_codigo']) != "")?$key['ord_codigo']:$key['moi_documento']) . '</td>';
            $html .= '<td>';
            /***********************************************************/
            // Codigo que aparece en el reporte en el campo de referencia
            if(trim($key['fac_numero']) != ""){
                $serie = (isset($key['serie_fac']))?'-'.$key['serie_fac']:'';
                $html .=  $key['tif_abreviacion'] .$serie.'-'. $key['fac_numero']; 
            }else {
                $serie = (isset($key['dpv_serie_documento']) && $key['dpv_serie_documento'] != "")?'-'.$key['dpv_serie_documento']:'';
                $html .=  ((trim($key['ord_codigo']) != "")?$key['ord_codigo']:((trim($key['abre2'])!='')?$key['abre2'].$serie.'-'.$key['moi_documento']:$key['moi_documento'])) ;
            }
            /***********************************************************/
            $html .= '</td>';

            $html .= '<td>' . $key['bod_nombre'] . '</td>'; //Bodega
            $html .= '<td>' . $key['prv_nombre'] . '</td>'; // Producto
            $html .= '<td>' . $key['pai_nacionalidad'] . '</td>'; //Nacionalidad
            //$html .= '<td>' . $key['moi_documento'] . '</td>';
            //$html .= '<td>' . $key['mep_nombre'] . '</td>';
            //$html .= '<td>' . $key['art_nombre'] . '[' . $key['art_codigo'] . ']</td>';
            $contador++;
            if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 0) {
                $costo_temp = number_format($key['dee_precio'], $decimales);
                if ($band == 0) {
                    $temp = $costo_temp;
                    $band = 1;
                }
            }

            if ($key['tip_entrada'] == 1) {
                $cantidad_entrada += $key['dee_cantidad'];
                $html .= '<td style="color: blue; text-align:right;">' . number_format($key['dee_cantidad'], $decimales) . '</td>';
                if ($ocultarCostos == 0) {
                    $html .= '<td class="decimales" style="color: blue; text-align:right;">$' . number_format($key['dee_precio'], $decimales) . '</td>';
                    $html .= '<td class="decimales" style="color: blue; text-align:right;">$' . number_format(($key['dee_cantidad'] * $key['dee_precio']), $decimales) . '</td>';
                }
                $html .= '<td>&nbsp;</td>';
                if ($ocultarCostos == 0) {
                    $html .= '<td>&nbsp;</td>';
                    $html .= '<td>&nbsp;</td>';
                }
                $total_entradas = round(($key['dee_cantidad'] * $key['dee_precio']), $decimales);

                $precios_entrada += $total_entradas;

                array_push($entradas, $total_entradas);
                $t_entradas = array_sum($entradas);
                array_push($dee_cantidad1, $key['dee_cantidad']);
                $ttc1 = array_sum($dee_cantidad1);
                array_push($dee_precio1, $key['dee_precio']);
                $ttp1 = array_sum($dee_precio1);
            }

            if ($key['tip_salida'] == 1) {
                if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 0) {
                    if ($temp != $key['dee_precio']) {
                        $band = 0;
                    }
                    if ($band == 0) {
                        $temp = $costo_temp;
                        $band = 1;
                    }
                }
                $cantidad_salida += $key['dee_cantidad'];
                $html .= '<td>&nbsp;</td>';
                if ($ocultarCostos == 0) {
                    $html .= '<td>&nbsp;</td>';
                    $html .= '<td>&nbsp;</td>';
                }

                $html .= '<td style="color: red; text-align:right;">' . number_format($key['dee_cantidad'], $decimales) . '</td>';
                if ($ocultarCostos == 0) {
                    $html .= '<td class="decimales" style="color: red; text-align:right;">' . '$' . number_format($key['dee_precio'], $decimales) . '</td>';
                    $html .= '<td class="decimales" style="color: red; text-align:right;">' . '$' . number_format(($key['dee_cantidad'] * $key['dee_precio']), $decimales) . '</td>';
                }
                $total_salidas = round(($key['dee_cantidad'] * $key['dee_precio']), $decimales);
                $precios_salida += $total_salidas;
                array_push($salidas, $total_salidas);
                $t_salidas = array_sum($salidas);
                array_push($dee_cantidad2, $key['dee_cantidad']);
                $ttc2 = array_sum($dee_cantidad2);
                array_push($dee_precio2, $key['dee_precio']);
                $ttp2 = array_sum($dee_precio2);
            }

            if (current(explode(',', $key['cantidad_existencia'])) == null) {
                $html .= '<td class="decimales">$' . number_format(0, $decimales) . '</td>';
                $html .= '<td class="decimales" style="text-align:right;"><span style="text-align:right;">$' . number_format(0, $decimales) . '</span></td>';
            } else {
                $existencia_reporte = number_format(current(explode(',', $key['cantidad_existencia'])), $decimales);
                $existencia_monto_reporte = number_format(current(explode(',', $key['monto_existencia'])), $decimales);
                //number_format(round($key['monto_existencia'], 2), 2)
                if ($key['tip_salida'] == 1) {
                    if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 1) {

                        $temp = number_format(current(explode(',', $key['monto_existencia'])) / current(explode(',', $key['cantidad_existencia'])), $decimales);
                    }
                    $html .= '<td style="color: red; text-align:right;">' . $existencia_reporte . '</td>';
                    if ($ocultarCostos == 0) {
                        $html .= '<td class="decimales" style="color: red; text-align:right;">$' . $temp . '</td>';
                        $html .= '<td class="decimales" style="color: red; text-align:right;"><span style="text-align:right;">$' . $existencia_monto_reporte . '</span></td>';
                    }
                } else {
                    if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 1) {
                        $temp = number_format(current(explode(',', $key['monto_existencia'])) / current(explode(',', $key['cantidad_existencia'])), $decimales);
                    }

                    $html .= '<td style="color: blue; text-align:right;">' . $existencia_reporte . '</td>';
                    if ($ocultarCostos == 0) {
                        $html .= '<td class="decimales" style="color: blue; text-align:right;">$' . $temp . '</td>';
                        $html .= '<td class="decimales" style="color: blue; text-align:right;"><span style="text-align:right;">$' . $existencia_monto_reporte . '</span></td>';
                    }
                }

                array_push($cantidad_existencia, current(explode(',', $key['cantidad_existencia'])));
                $total_cantidad_existencia = array_sum($cantidad_existencia);
                array_push($monto_existencia, current(explode(',', $key['monto_existencia'])));
                $total_monto_existencia = array_sum($monto_existencia);
            }
            $html .= '</tr>';
            $band = 0;
            $temp = 0;
        }



        $html .= '<tr nobr="true">';
        $html .= '<td colspan="2">Totales del Movimiento:</td>';
        $html .= '<td>al ' . date('d/m/Y', strtotime($fecha_fin)) . '</td>';
        $html .= '<td></td>';
        $html .= '<td></td>';
        $html .= '<td></td>';
        $html .= '<td></td>';
        $html .= '<td style="text-align:right;">' . number_format($cantidad_entrada, $decimales) . '</td>';
        if ($ocultarCostos == 0) {
            $html .= '<td></td>';
            $html .= '<td class="decimales" style="text-align:right;">$' . number_format($precios_entrada, $decimales) . '</td>';
        }

        $html .= '<td style="text-align:right;">' . number_format($cantidad_salida, $decimales) . '</td>';
        if ($ocultarCostos == 0) {
            $html .= '<td></td>';
            $html .= '<td class="decimales" style="text-align:right;">$' . number_format($precios_salida, $decimales) . '</td>';
        }


        $html .= '<td style="text-align:right;">' . $existencia_reporte . '</td>';
        if ($ocultarCostos == 0) {
            $html .= '<td style="text-align:right;"></td>';
            $html .= '<td class="decimales" style="text-align:right;">' . '$' . $existencia_monto_reporte . '</td>';
        }

        $html .= '</tr></tbody>';

        $totales = array(
            'cantidad_entrada' => $cantidad_entrada,
            'precios_entrada' => $precios_entrada,
            'cantidad_salida' => $cantidad_salida,
            'precios_salida' => $precios_salida,
            'existencia_reporte' => str_replace(',', '', $existencia_reporte),
            'existencia_monto_reporte' => str_replace(',', '', $existencia_monto_reporte)
        );

        return array('html' => $html, 'totales' => $totales);
    }

    function export_excel($tipoR = 1) {
        //$tipoR=1 (excel), $tipoR=2 (pdf)
        if ($tipoR == 1) {
            // header("Content-type: application/vnd.ms-excel; name='excel'");
            // header("Content-Disposition: filename=ficheroExcel.xls");
            // header("Pragma: no-cache");
            // header("Expires: 0");


            $us = $this->tank_auth->get_user_id();
            $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
            $titulo = "kardex producto";
            $encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);



            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header'] = $encabezado;
            $data['table_tbody'] = $_POST['datos_a_enviar'];
            $data['filename'] = $filename;

            $this->load->view('inventario/kardex/export_excel.php', $data);
        } else if ($tipoR == 2) {
            // die(print_r($_POST['datos_a_enviar']));
            $data['table_header'] = "<br>";
            $data["table_tbody"] = $_POST['datos_a_enviar'];
            $this->pdf->reportePDF('inventario/reportes/reporte_kardexproducto_pdf.php', $data, 'kardex producto', 'L');
        }
    }

    function export_excel_kardex($tipoR = 1) {
        //$tipoR=1 (excel), $tipoR=2 (pdf)
        if ($tipoR == 1) {
            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $html = str_replace(array('<td class="costos decimales" style="color: blue; text-align:right;">$','<td class="costos decimales" style="color: red; text-align:right;">$'), array('<td class="costos decimales" style="color: blue; text-align:right;">', '<td class="costos decimales" style="color: red; text-align:right;">'), $_POST['datos_a_enviar']);
            // $data['table_tbody'] = $_POST['datos_a_enviar'];
            $data['table_tbody'] = $html;
            $data['filename'] = $filename;

            $this->load->view('inventario/kardex/export_excel2.php', $data);
        } else if ($tipoR == 2) {
             // die(print_r($_POST['datos_a_enviar']));
            $header = $this->load->view('reporte/header', $data, true);
            //$data['table_header'] = "<br>";
            $html = $_POST['datos_a_enviar_pdf'];
            //print_r($html);exit(); die();
            $encabezado = '<!DOCTYPE html><html><head><title>KARDEX CATEGORÍAS</title></head><body><script type="text/javascript">';
            $encabezado .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Kardex Categoría' . date('dmY') . '";';
            $encabezado .= 'window.print();</script>';
            $footer = '</body></html>';
            $reporte = $encabezado . $html . $footer;
            echo $reporte;
            die();
            // $this->pdf->makePdf($html, 'L', 'reporte_karde', 'Legal');
            // $this->pdf->reportePDF('inventario/reportes/reporte_kardexproducto_pdf.php', $data, 'kardex producto', 'L');
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function historico_existencias($consulta = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/reportes/historico_existencias');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;
                    $bodega     = $post_array['bodega'];
                    $categoria  = $post_array['categoria'];
                    $producto   = $post_array['producto'];
                    $codlote    = $post_array['lote'];
                    $fecha_fin  = $post_array['fecha_fin'];
                    $fecha_ini  = $post_array['fecha_ini'];

                    $data['bodega_id']  = $bodega;
                    $data['categoria']  = $categoria;
                    $data['producto']   = $producto;
                    $data['codlote']    = $codlote;
                    $data['fecha_fin']  = $fecha_fin;

                    $where = null;

                    if ($fecha_ini != '') {
                        $where['moi_fecha_mov >='] = date('Y-m-d H:i:s', strtotime($fecha_ini . " 00:00:00"));
                    }
                    if ($fecha_fin != '') {
                        $where['moi_fecha_mov <='] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
                    }
                    if(trim($bodega) != ""){
                        $where['moi_id_bod'] = $bodega;
                    }
                    if(trim($categoria) != ""){
                        $where['tia_id'] = $categoria;
                    }
                    if(trim($producto) != ""){
                        $where['art_id'] = $producto;
                    }
                    if (trim($codlote) != "") {
                        $where['dee_codigo_lote'] = $codlote;
                    }
                    $existencias = $this->inventario_model->get_reporte_historico($where);

                    $data['existencias'] = $existencias;
                    $data['tipo_reporte'] = 'grid';
                    $html = $this->load->view('inventario/reportes/imprimir_historico_existencias', $data, true);

                    echo $html;
                    die();
                }
            } else {
                $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
                $data['bodegas'] = str_replace('<option value="0">Seleccione</option>', '', $select);

                //$data['saldos'] = $this->inventario_model->get_detalles_rxixbodega();
                $data['titulo_personal'] = "Reporte histórico de existencias";
                $this->_cargarvista($data);
            }
        }
    }

    public function imprimir_historico_existencias(){
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        $post_array = $_POST;

        $bodega     = $post_array['rpt_slcBodega'];
        $categoria  = $post_array['rpt_categoria'];
        $producto   = $post_array['rpt_slcProductos'];
        $codlote    = $post_array['txtcodigolote'];
        $fecha_fin  = $post_array['rpt_txtFechaFin'];
        $fecha_ini  = $post_array['rpt_txtFechaIni'];
        $tipo       = $post_array['rpt_tipo'];

        $data['bodega_id']  = $bodega;
        $data['categoria']  = $categoria;
        $data['producto']   = $producto;
        $data['codlote']    = $codlote;
        $data['fecha_fin']  = $fecha_fin;

        $where = null;

        if ($fecha_ini != '') {
            $where['moi_fecha_mov >='] = date('Y-m-d H:i:s', strtotime($fecha_ini . " 00:00:00"));
        }
        if ($fecha_fin != '') {
            $where['moi_fecha_mov <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
        }
        if(trim($bodega) != ""){
            $where['moi_id_bod'] = $bodega;
        }
        if(trim($categoria) != ""){
            $where['tia_id'] = $categoria;
        }
        if(trim($producto) != ""){
            $where['art_id'] = $producto;
        }
        if (trim($codlote) != ""){
            $where['dee_codigo_lote'] = $codlote;
        }
        $existencias = $this->inventario_model->get_reporte_historico($where);

        $data['existencias'] = $existencias;
        $data['tipo_reporte'] = $tipo;

        if($tipo == 'excel'){
            $filename = 'rpt_historico' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $this->load->view('inventario/reportes/imprimir_historico_existencias', $data);
        } else{
            $data['titulo'] = 'Reporte histórico de existencias';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);

            $html = $this->load->view('inventario/reportes/imprimir_historico_existencias', $data, true);
            $GLOBALS['nombre_reporte'] = 'historico' . date('dmY');

            //echo $html;
            $this->pdf->makePdf($header.$html, 'L', 'historico', 'Letter');
        }
    }

    public function obtener_codlote_articulo() {
        if ($this->input->post()) {
            $bodega     = $this->input->post("bodega");
            $producto   = $this->input->post("producto");
            $where = null;
            if (trim($bodega) != "") {
                $where['sar_id_bod'] = $bodega;
            }
            if (trim($producto) != "") {
                $where['dee_id_art'] = $producto;
            }
            $where['dee_estado'] = 1;
            $where['sar_cant_actual > 0'] = null;

            $this->db->join("sar_saldo_articulo", "dee_id_sar = sar_id");
            $select = $this->gsatelite->get_dropdown('dee_detalle_mov', '{dee_codigo_lote}', '', $where, null, '', 'dee_codigo_lote', true);
            $select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            echo json_encode(array("codlote"=>$select));
            die();
        }
    }

    public function impresion_etiquetas_empaques($consulta = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if ($this->input->post()) {

            $post_array     = $this->input->post();

            $fecha_inicio   = ($post_array['txtFechaIni'] != '' )? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
            $fecha_fin      = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;

            $slcProductos   = ($post_array['slcProductos'] != '') ? $post_array['slcProductos'] : null;
            $txtcodigolote  = ($post_array['txtcodigolote'] != '') ? $post_array['txtcodigolote'] : null;

            // Filtrar
            $where = null;

            if ($fecha_inicio != null && $fecha_fin != null) {
                $where["moi_fecha_mov BETWEEN '$fecha_inicio' AND '$fecha_fin' "] = null;
            }

            if ($slcProductos != null) {
                $where['art_id'] = $slcProductos;
            }

            if ($txtcodigolote != null) {
                $where['dee_codigo_lote'] = $txtcodigolote;
            }

            $data['empaques']       = $this->inventario_model->get_etiquetas_empaques($where);

            $tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Impresion_etiquetas_empaques_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Impresión Etiquetas Empaques';
            $data['filename']           = $filename;
            $html = $this->load->view('inventario/reportes/consultar_impresion_etiquetas_empaques', $data, true);

            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            }
        } else {
            // Obtener las categorias
            $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data['categorias'] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data['titulo_personal'] = "Impresión Etiquetas Empaques";
            $this->_cargarvista($data);
        }
    }

    public function imprimir_etiqueta_empaque($empaque = null) {
        satelite_validar();
        $post_array     = $this->input->post();

        if ($this->input->post()) {
            // print_r($_POST);die();
            $fecha_inicio   = ($post_array['_txtfecha_desde'] != '' )? date('Y-m-d', strtotime($post_array['_txtfecha_desde'])) : null;
            $fecha_fin      = ($post_array['_txtfecha_hasta'] != '')? date('Y-m-d', strtotime($post_array['_txtfecha_hasta'])) : null;

            $slcProductos   = ($post_array['_txt_producto'] != '') ? $post_array['_txt_producto'] : null;
            $txtcodigolote  = ($post_array['_txt_cod_lote'] != '') ? $post_array['_txt_cod_lote'] : null;

            $txtdesde       = ($post_array['txt_desde_'] != '') ? $post_array['txt_desde_'] : null;
            $txthasta       = ($post_array['txt_hasta_'] != '') ? $post_array['txt_hasta_'] : null;
        } else {
            $fecha_inicio   = null;
            $fecha_fin      = null;

            $slcProductos   = null;
            $txtcodigolote  = null;

            $txtdesde       = null;
            $txthasta       = null;
        }

        $where = null;

        if ($empaque != null) {
            $where['dmp_id'] = $empaque;
        }

        if ($fecha_inicio != null && $fecha_fin != null) {
            $where["moi_fecha_mov BETWEEN '$fecha_inicio' AND '$fecha_fin' "] = null;
        }

        if ($slcProductos != null) {
            $where['art_id'] = $slcProductos;
        }

        if ($txtcodigolote != null) {
            $where['dee_codigo_lote'] = $txtcodigolote;
        }

        $data['empaques']  = $this->inventario_model->get_etiquetas_empaques($where);

        $ids = array();
        foreach ($data['empaques'] as $key => $value) {
            $indice = $key + 1;
            if ($txtdesde != null && $txthasta != null) {
                if ($indice >= $txtdesde && $indice <= $txthasta) {
                    $ids[] = $value['dmp_id'];
                }
            } else {
                $ids[] = $value['dmp_id'];
            }
        }

        $data['ids']     = $ids;
        $data['usuario'] = $this->gsatelite->get_tabla('users', array('id'=>$this->tank_auth->get_user_id()));

        // Config Barcode
        $data['style'] = array(
            'position'      => 'C',
            'align'         => 'C',
            'stretch'       => false,
            'fitwidth'      => true,
            'cellfitalign'  => '',
            'border'        => true,
            'hpadding'      => '',
            'vpadding'      => '',
            'fgcolor'       => array(0, 0, 0),
            'bgcolor'       => array(255, 255, 255),
            'text'          => true,
            'font'          => 'helvetica',
            'fontsize'      => 8,
            'stretchtext'   => 4
        );

        // Configuración
        $fuente = 'helvetica';
        $setCellPaddings = '0,0,0,0';
        $margins = '2.5,3,2.5';
        $orientacion = 'L';
        $formato     = array(0 => 105, 1 => 150);

        $html = $this->load->view('inventario/reportes/impresion_etiquetas_empaques_pdf', $data, true); //echo $html;die();
        $this->pdf->setPrintHeader(false);
        $this->pdf->SetFont($fuente);
        $this->pdf->setCellPaddings($setCellPaddings);
        $this->pdf->SetAutoPageBreak(true, 0);
        $this->pdf->SetMargins($margins);
        $this->pdf->AddPage($orientacion, $formato, array(
            'family' => $fuente,
            'style' => '',
            'size' => 7.5) , true
        );
        $this->pdf->setPrintFooter(false);
        $this->pdf->writeHTML($html, true, false, false, false, '');
        $this->pdf->boletaPDF('I');
    }

    public function existencias_empaques() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {  //print_r($_POST);die();
            $post_array     = $this->input->post();
            $tipo_reporte   = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';

            if (trim($tipo_reporte) == "") {
                $bodega     = ($post_array['slcBodega'] != '' )? $post_array['slcBodega'] : null;
                $producto   = ($post_array['slcProductos'] != '')?  $post_array['slcProductos'] : null;
                $codlote    = ($post_array['txtcodigolote'] != '') ?  $post_array['txtcodigolote']  : null;
            } else {
                $bodega     = ($post_array['filtro_bodega'] != '' )? $post_array['filtro_bodega'] : null;
                $producto   = ($post_array['filtro_producto'] != '')?  $post_array['filtro_producto'] : null;
                $codlote    = ($post_array['filtro_lote'] != '') ?  $post_array['filtro_lote']  : null;
            }

            // Filtro
            $where = null;
            if ($bodega != null) {
                $where['moi_id_bod'] = $bodega;
            }
            if ($producto != null) {
                $where['art_id'] = $producto;
            }
            if ($codlote != null) {
                $where['dee_codigo_lote'] = $codlote;
            }

            $data['existencias']       = $this->inventario_model->get_existencias_empaques($where);
            // print_r($this->db->last_query());die();

            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Reporte_existencias_empaques_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Existencia de Empaque';
            $data['filename']           = $filename;
            $html = $this->load->view('inventario/reportes/consultar_existencias_empaques', $data, true);

            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Existencias de Empaques';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_existencias_empaques_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_existencias_empaques_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data['bodegas'] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select          = str_replace('<option value="">Sin Registros</option>', '', $select);
            $data['titulo_personal']    = 'Existencia de Empaque';
            cargarvista($data);
        }
    }

    /**
    * @author Luis Navarro
    * @since 2018-07-19
    * @return reporte de Minimo-Maximo de productos
    */
    public function reporte_minimo_maximo(){
        satelite_validar();

        if ($_POST) {
            $post_array     = $this->input->post();

            $bodega     = ($post_array['bodega'] != '' )? $post_array['bodega'] : null;
            $producto   = ($post_array['producto'] != '')? $post_array['producto'] : null;

            $where      = null;
            $groupby    = null;
            $orderby    = null;

            if ($bodega > 0) {
                $where['mma_id_bod'] = $bodega;
            }

            if ($producto > 0) {
                $where['mma_id_art'] = $producto;
            }

            $groupby    = 'mma_id';

            // Parametro para los decimales
            $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

            $data['consulta']       = $this->inventario_model->get_min_max_producto($where, $groupby, $orderby);//print_r($this->db->last_query());die();

            $tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Reporte_minimo_maximo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Minimo-Maximo de Producto por Bodega';
            $data['filename']           = $filename;
            $html = $this->load->view('inventario/reportes/consultar_minimo_maximo', $data, true);

            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Minimo-Maximo de Producto por Bodega';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_minimo_maximo_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'Reporte_minimo_maximo_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data['bodegas'] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data['titulo_personal']    = 'Reporte de Minimo-Maximo de Producto';
            cargarvista($data);
        }
    }


    /**
     * Descripción:
     * Función para mostrar el Kardex por producto sin costos.
     * Función compartida del mismo módulo función: krdx_producto
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-27
     * @param  Ninguno
     * @return Kardex por producto sin costos.
     */
    function krdx_producto_costo() {
        satelite_validar();
        $this->krdx_producto(1);
    }

    /**
     * Descripción:
     * Función para cargar los datos en la vista o pdf, excel del reporte Inventario Físico  
     * @author Elman Ortiz - Grupo Satélite
     * @since  2018-12-05
     * @param  Ninguno
     * @return Datos o vista del reporte de Inventario Físico
     */
    public function reporte_inventario_fisico() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '9999');
        if ($_POST) {  
            $post_array     = $this->input->post();
            $tipo_reporte   = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
            if (trim($tipo_reporte) == "") {
                $bodega     = ($post_array['slcBodega'] != '' )? $post_array['slcBodega'] : null;
                $selector   = ($post_array['slcSelector'] != '')?  $post_array['slcSelector'] : null;
                $categoria  = ($post_array['slcCategoria'] != '') ?  $post_array['slcCategoria']  : null;
                $fecha_fin  = ($post_array['fecha_fin'] != '') ?  $post_array['fecha_fin']  : null;
                $sin_exist  = ($post_array['filtro_sin_ex'] != '') ?  $post_array['filtro_sin_ex']  : null;                
            } else {                
                $bodega     = ($post_array['filtro_bodega'] != '' )? $post_array['filtro_bodega'] : null;
                $selector   = ($post_array['filtro_selector'] != '')?  $post_array['filtro_selector'] : null;
                $categoria  = ($post_array['filtro_categoria'] != '') ?  $post_array['filtro_categoria']  : null;
                $fecha_fin  = ($post_array['filtro_fecha'] != '') ?  $post_array['filtro_fecha']  : null;
                $sin_exist  = ($post_array['filtro_sin_ex'] != '') ?  $post_array['filtro_sin_ex']  : null;
            }
            $padre_del_padre = array();
            $i = 0;
            $ultima_categoria = $categoria;
            while ($ultima_categoria != null) {
                if ($i == 0) {
                    $padre_del_padre[] = $ultima_categoria;
                } else {
                    $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria = $ultima_categoria['tia_padre'];
                    $padre_del_padre[] = $ultima_categoria;
                }
                $i++;
            }            
            $categorias_final = array_reverse($padre_del_padre);
            $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije
            foreach ($categorias_final as $key => $value) {
                if ($key != null) {
                    $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                    $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
                }
            }
            $ultimo_padre = end($elementos);
            $hijos_fin = array();
            foreach ($elementos as $key => $value) {
                foreach ($value as $ids => $valores) {
                    $tia_hijo_temp = array();
                    $tia_hijo_reg = $this->inventario_model->get_tia_hijos($ids, true);
                    $tia_hijo_temp = array_merge($tia_hijo_temp, $tia_hijo_reg);
                    while (count($tia_hijo_reg) > 0) {
                        $tia_id_column = array_column($tia_hijo_reg, 'tia_id');
                        $tia_id_implode = implode(', ', $tia_id_column);
                        $tia_hijo_reg = $this->inventario_model->get_tia_hijos($tia_id_implode);
                        $tia_hijo_temp = array_merge($tia_hijo_temp, $tia_hijo_reg);
                    }
                    $tia_id_temp_column = array_column($tia_hijo_temp, 'tia_id');
                    $where_hijos = implode(',', $tia_id_temp_column);
                    $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $where_hijos);
                    $hijos_fin = $tia_hijo;
                }
            }
            // var_dump($hijos_fin);
            $ids = array_column($hijos_fin, 'tia_id');
            $ids_hijos = '';
            if (count($ids) > 0) {
                $ids_hijos = implode(',', $ids);
            }
            // Filtros
            $where = null;
            $having = "";
            if ($bodega != null) {//Bodega (filtro obligatorio)
                $where['art_id_bod'] = $bodega;
                //$where['sar_id_bod'] = $bodega;
            }
            if ($selector != null) {
                $where['art_id_sxb'] = $selector;
                //$where['sxb_id_seb'] = $selector;
            }
            if ($categoria != null) {//(filtro obligatorio)
                // $where['art_id_tia'] = $categoria;//Categoria del producto
                $where["art_id_tia IN ($ids_hijos)"] = NULL;//Categoria del producto
                //$having['tia_id'] = $categoria;//Categoria del producto
            }   
            if ($fecha_fin != null) {       //fecha del movimiento hasta (por defecto "hasta hoy")
                $fecha_mod = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                $having = "DATE(moi_fecha_mov) <= '".$fecha_mod."'";
            }         
            if ($sin_exist != null) {        //fecha del movimiento hasta (por defecto "hasta hoy")
                if ($having!="") {
                    $having .= ($sin_exist > 0) ? " AND cantidad >= 0" : " AND cantidad > 0";
                } else {
                    $having .= ($sin_exist > 0)?"cantidad >= 0" : "cantidad > 0";
                }            
            }         
            $data['inventario_fisico']       = $this->inventario_model->reporte_inventario_fisico($where, $having); 
                // print_r($this->db->last_query());die(); 

            $data["tipo_reporte"]   = $tipo_reporte;
            $filename                   = 'Reporte_inventario_fisico_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Inventario Físico';
            $data['filename']           = $filename;
            $html = $this->load->view('inventario/reportes/consultar_inventario_fisico', $data, true);

            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                $data['titulo']             = 'Inventario físico';
                $header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'Reporte_inventario_fisico_' . date('dmY');
                $reporte                    = $header . $html;
                $this->pdf->makePdf($reporte, 'P', 'Reporte_inventario_fisico_', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }
        } else {                    
            $select_sector = $this->inventario_model->get_sectoresxbodegas_posee_usuario();
            $data["slcSector"] = $select_sector;
            $select_bodega = $this->inventario_model->get_bodegas_usuario();
            $data["slcBodega"] = $select_bodega;                    
            $data['titulo_personal']    = 'Inventario físico';
            cargarvista($data);
        }
    }

    /*
     * @author: Elman Ortiz
     * Funcion ajax, que devuelve el listado opciones dependientes de una categoria
     * Si Flag = 1, se regresan los array de información por json
     */

    public function get_dependencias_categoria_reporte_fisico($flag = null) {
        $padre = $this->input->post('padre');
        $bodega = $this->input->post('bodega');
        $sector = $this->input->post('sector');
        $servicios = $this->input->post('servicio');

        //$this->db->where('tia_padre', $padre);
        $impuestos='';
        $hijos = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => $padre));
        $cadena = "<option value='0' selected>Seleccione una opción</option>";
        $var = "<option value='0' selected>Seleccione una opción</option>";

        foreach ($hijos as $key => $value) {
            $cadena .= '<option value="' . $value['tia_id'] . '">'.$value['tia_codigo'].' - '.$value['tia_nombre'] . '</option>';
        }

        $where_art = array('art_estado' => 1, 'art_inventario' => 1);
        if ($sector > 0) {
            //$where_art['art_id_sxb'] = $sector;
        }

        if ($bodega != '') {
            //$where_art['art_id_bod'] = $bodega;
        }

        //$articulos = $this->inventario_model->get_articulosxcategoria($padre, $servicios, $where_art);
        //print_r(count($articulos)); die();
        $etiqueta = 0;
        /*foreach ($articulos as $fila) {
            $var .= "<option data-codigo='" . $fila['art_codigo'] . "' data-nombre='" . $fila['art_nombre'] . "' "
                    . "precio='" . $fila['sar_precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "'>" . $fila['art_codigo'] . ' - '. $fila['art_nombre'] . "</option>";
            $etiqueta++;
        }*/

        if (count($hijos) == 0) {
            $cadena = "";
        }
        /*if (count($articulos) == 0) {
            $var = "";
        }*/

        if ($flag == null) {
            $arreglo = array('drop' => $cadena, 'padre' => $padre, 'impuestos' => $impuestos);
        } else if ($flag == 1) {
            $arreglo = array(
                'producto' => $articulos
            );
        }

        echo json_encode($arreglo);
    }

    function obtener_categoriaxbodega() {
        $this->load->library('../controllers/inventario/gestion_productos');        

        $bod_id = $this->input->post('bodega');
        $categoria_productos = $this->inventario_model->get_productosxbodega(array('art_id_bod' => $bod_id), "tia_id");
        //$categoria_productos = $this->inventario_model->get_productosxbodega(array('bod_id' => $bod_id), "tia_id");
        $select = "<option value=''></option>";
        $categorias_id = array();
        $categorias_nombre = array();
        $categorias_codigo = array();
        foreach ($categoria_productos as $key) {
            if ($key["tia_padre"] == null and !in_array($key["tia_id"], $categorias_id)) {
                $categorias_codigo[] = $key["tia_codigo"];
                $categorias_nombre[] = $key["tia_nombre"];
                $categorias_id[] = $key["tia_id"];
            } else {
                $arreglo = $this->gestion_productos->obtener_padres_tia($key["tia_id"]);
                if (!in_array($arreglo[0], $categorias_nombre)) {
                    $categorias_nombre[] = $arreglo[0];
                    $categorias_id[] = $arreglo[1];
                    $categorias_codigo[] = $arreglo[2];
                }
            }
        }
        for ($x = 0; $x < count($categorias_nombre); $x++) {
            $select .= '<option value="' . $categorias_id[$x] . '">'.$categorias_codigo[$x].' - '.$categorias_nombre[$x] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    function obtener_categoria_hijas($idpadre){

        $array_hijas = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => $idpadre));
        if(count($array_hijas)>0){
            $arra_id_hijas = array_column($array_hijas, 'tia_id');
            $string_id_hijas = implode(",",$arra_id_hijas);
        }else{
            $string_id_hijas = "";
        }
        //Se inicializa la listas de ids
        $list_acum = $idpadre;
        
        $string_lista_ids_padre_hijas = $this->recursivo_categorias_hijas($string_id_hijas, $list_acum);
        
        return $string_lista_ids_padre_hijas;
    }

    function recursivo_categorias_hijas($string_id_hijas, $list_acum){                
        if($string_id_hijas != ""){
            $array_id_hijas = explode(",", $string_id_hijas);
        }else{
            $array_id_hijas = [];
        }
        //Se van agregando los ids a la lista
        $lista = $list_acum;        
                
        foreach ($array_id_hijas as $key => $value) {            
            $string_id_todas = implode(",", array_column($this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => $value)), 'tia_id'));
            if($string_id_todas != ''){
                $lista .= ','.$value .','. $this->recursivo_categorias_hijas($string_id_todas, $lista);
            }else{
                $lista .= ','.$value;
            }        
        }
        return $lista;                              
    }

    public function articles_x_category() {
        $cat_id = $this->input->post('categoria');
        $select = "<option value=''></option>";
        $categorias_final = array();
        $categoria_arbol = $this->inventario_model->crear_arbol($cat_id, "");
        if($categoria_arbol != ''){
            $categorias_final = explode(',', $categoria_arbol);
            $categorias_final = array_filter($categorias_final, function ($value){
                return !is_null($value) && $value !== '';
            });
            $categorias_final[] = $cat_id;
        }else{
            $padre_x_padre = array();
            $i = 0;
            while ($cat_id != null) {
                if ($i == 0) {
                    $padre_x_padre[] = $cat_id;
                } else {
                    $cat_id = $this->db->where('tia_id', $cat_id)->get('tia_tipo_articulo')->row_array();
                    $cat_id = $cat_id['tia_padre'];
                    $padre_x_padre[] = $cat_id;
                }
                $i++;
            }
            $padre_x_padre = array_filter($padre_x_padre, function ($value){
                return !is_null($value) && $value !== '';
            });
            $categorias_final = array_reverse($padre_x_padre);
        }
        $productos = $this->inventario_model->get_productosxcategoria($categorias_final);
        foreach ($productos as $key => $value) {
            $select .= '<option value="' . $value['art_id'] . '">'.$value['art_codigo'].' - '.$value['art_nombre'] . '</option>';
        }
        echo $select;
    }

    public function inventario_existencia_unidades() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Reporte de existencias";
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data['categoria_padre'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', 'tia_nombre', 'categorias', array('tia_padre ' => null, 'tia_estado' => 1), null, null, null, true);
            $this->_cargarvista($data);
        }
    }

    /*
     * @author: Raul Escalante
     * Funcion que devuelve el reporte de existencias sin tomar en cuenta los costos, 
     * Si Flag = 1, se regresan los array de información por json si no, PDF/EXCEL
     */
    function reporte_existencia_unidades($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            if ($flag == 1) {
                $bodega = ($post_array['bodega'] != '') ? $post_array['bodega'] : "";
                $categoria = ($post_array['categoria'] != '') ? $post_array['categoria'] : "";
                $producto = ($post_array['producto'] != '') ? $post_array['producto'] : "";
                $lote = ($post_array['lote'] != '') ? $post_array['lote'] : "";
                $sector = ($post_array['sector'] != '') ? $post_array['sector'] : "";
            } else {
                $bodega = ($post_array['filtro_bodega'] != '') ? $post_array['filtro_bodega'] : "";
                $categoria = ($post_array['filtro_categoria'] != '') ? $post_array['filtro_categoria'] : "";
                $producto = ($post_array['filtro_producto'] != '') ? $post_array['filtro_producto'] : "";
                $lote = ($post_array['filtro_lote'] != '') ? $post_array['filtro_lote'] : "";
                $sector = ($post_array['filtro_sector'] != '') ? $post_array['filtro_sector'] : "";
            }
            $tipo_reporte = $post_array['tipo_reporte'];
            $where = null;
            if ($bodega != "") {
                $where['bod_id'] = $bodega;
            }
            if ($categoria != "") {
                $where_tia = $this->obtener_categoria_hijas($categoria);
                $where['tia_id IN('.$where_tia.')'] = null;                
            }
            if ($producto != "") {
                $where['art_id'] = $producto;
            }
            if ($sector != "") {
                $where['sar_id_sxb'] = $sector;
            }
            $where['uxb_id_usu'] = $this->tank_auth->get_user_id();
            $group_by = ($this->gsatelite->get_parametro("SYS_USA_SECTORES", 0) > 0) ? "art_id, sar_id_bod, mep_id, sector" : "art_id, sar_id_bod, mep_id";
            $having = "SUM(sar_cant_actual) > 0";
            if ($lote != "") {
                $where["sar_id in (select dee_id_sar from dee_detalle_mov where dee_codigo_lote=$lote AND dee_id_sar = sar_id)"] = null;
            }
            $order_by = "linea,codigo";
            $data['reporte'] = $this->inventario_model->get_existencias_unidades($where, $group_by, $having, $order_by);
            $data['tipo_reporte'] = $tipo_reporte;
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['filename'] = 'rpt_existencias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $html = $this->load->view('inventario/reportes/reporte_existencia_unidades', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Existencias';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Reporte_Existencias_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Existencias', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_existencias_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Reporte de existencias';
                    echo $html;
                }
            }
        }
    }


    /*
    * @author: Raul Escalante
    * Funcion que filtra los reportes de traslados en la vista Imprimir Traslados
    */
    function filtrar_impresion_traslado($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();
            if ($flag) {
                $reporte = $this->inventario_model->consulta_general('tra_translado');
            } else {            
                $fecha_ini = ($post_array['fecha_ini'] != '') ? $post_array['fecha_ini'] : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
                $categoria = ($post_array['categoria'] > 0) ? $post_array['categoria'] : null;
                $bodega    = ($post_array['bodega'] > 0) ? $post_array['bodega'] : null;
                $productos = ($post_array['productos'] != '') ? implode(',', $post_array['productos']) : null;
                $where = array();
                if ($fecha_ini != null) {
                    $where['fecha_ini'] = date('Y-m-d H:i:s', strtotime($fecha_ini . ' 00:00:00'));
                }
                if ($fecha_fin != null) {
                    $where['fecha_fin'] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
                }
                if ($categoria != null) {
                    $where['categoria'] = $categoria;
                }
                if ($productos != null) {
                    $where['productos'] = $productos;   
                }
                if ($bodega != null){
                    $where['bodega'] = $bodega;
                }
                $reporte = $this->inventario_model->filtrar_traslados($where);
            }
            $tabla  = '<table cellpadding="0" cellspacing="0" id="datagried1" border="0" class="responsive display table table-bordered" width="100%"><thead><tr>';
            $tabla .= '<th width="15%">Fecha</th><th width="15%">Número Solicitud</th><th>Descripción</th><th>Generar Pdf</th></tr></thead><tbody >';
            if (!(empty($reporte))) {
                foreach ($reporte as $key => $value) {
                    $tabla .= '<tr>';
                    $tabla .= '<td>' . formatear_fecha('d-m-Y', $value['tra_fecha_translado']) . '</td>';
                    $tabla .= '<td>#' . $value['tra_id'] . '</td>';
                    $tabla .= '<td>' . $value['tra_descripcion'] . '</td>';
                    $tabla .= '<td style="text-align: center;">'; 
                    $tabla .= '<a href="' . base_url() . 'inventario/boleta_traslado/generar_boleta?identificador=' . $value['tra_id'] . '" target="_blank">';
                    $tabla .= '<img src="' . base_url() . 'media/images/reporte/PDF.png" width="40px" heigth="40px;"/>';
                    $tabla .= '</a>'; 
                    $tabla .= '</td>';
                    $tabla .= '</tr>';
                }
            }
            $tabla .= '</tbody></table>';
            echo $tabla;            
        }
        
    }

    /**
     * Descripción:
     * Función para mostrar reporte resumen del Kardex por producto 
     * @author Raul Escalante - Grupo Satélite
     * @since  2019-08-12
     */
    function rpt_krdx_resumen($flag = null) {
        satelite_validar();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        if ($_POST) {
            $con_movimiento = array();
            $post_array = $this->input->post();            
            $tipo_reporte = $post_array['tipo_reporte'];
            if ($flag) {
                $bodega    = $post_array['bodega'];
                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
            } else {
                $bodega    = $post_array['hdn_bod_id'];
                $fecha_ini = $post_array['hdn_fe_ini'];
                $fecha_fin = $post_array['hdn_fe_fin'];
            }
            $detalles = (isset($_POST['html_reporte'])) ? array() : $this->inventario_model->rpte_kardex_resumen($bodega,$fecha_ini,$fecha_fin);
            if (count($detalles) > 0) {            
                foreach ($detalles as $key => $value) {                    
                    if ($value['entradas'] > 0 || $value['salidas'] > 0 || $value['inv_ini_uni'] > 0) {
                        $con_movimiento[] = $value;
                    }
                }
            }
            $filename = 'rpt_krdx_resum_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $datos_bodega = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $bodega));
            $data['decimales'] = $decimales;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['filename'] = $filename;
            $data['detalles'] = $con_movimiento;
            $datos['decimales'] = $decimales;
            $datos['tbl_rsum'] = $this->inventario_model->tabla_rpt_krdx_det($bodega,$fecha_ini,$fecha_fin);
            $tabla_resumen = $this->load->view('inventario/reportes/det_krdx_tabla_resumen', $datos, true);
            $data['subtitulo'] = '<br/> Bodega: '.$datos_bodega[0]['bod_nombre'] . ' <br/> ';
            $data['subtitulo'] .= 'Del ' . formatear_fecha('d-m-Y',$fecha_ini) . ' Al ' . formatear_fecha('d-m-Y',$fecha_fin);
            $html = (isset($_POST['html_reporte'])) ? $_POST['html_reporte'] : $this->load->view('inventario/reportes/detalle_krdx_resumen', $data, true);            
            if ($flag) {
                echo $html;
            } else {
                $html = str_replace(
                    '<table style="font-size:12.5px;" class="responsive table table-bordered" id="datagried" width="100%" name="datagried">'
                    , '<table style="font-size:11px;" border="1" width="100%" cellpadding="0" cellspacing="0">', $html);
                if ($tipo_reporte == 'pdf') { //versión html el pdf tarda demasiado
                    $data['titulo'] = 'Kardex Resumen';
                    $header = $this->load->view('reporte/header', $data, true);
                    $header = str_replace('<table align="center" cellpadding="0" >', '<table align="center" cellpadding="0" width="100%">', $header);
                    $encabezado_footer = '
                    <table  border="0" width="100%" cellpadding="0" cellspacing="0" >
                       <thead><tr  nobr="true" ><td>'.$header.'</td></tr></thead>
                       <tbody>
                    <tr><td>
                    ';
                    //<tfoot><tr><td>Your footer goes here</td></tr></tfoot>
                    $html = $encabezado_footer . $html . $tabla_resumen . '<script type="text/javascript">
                    window.print();
                    document.title = "Reporte kardex resumen";
                    </script>
                    </td></tr>
                       </tbody>
                    </table>
                    ';
                    $GLOBALS['nombre_reporte'] = 'Rpte_krdx_resumen_' . date('dmY');
                    $reporte = $html;
                    echo $reporte; die();
                    //$this->pdf->makePdf($reporte, 'L', 'Reporte_Krdx_resumen', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("content-disposition: attachment;filename=" . $filename . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");

                    $input = "0\.";
                    $valor =  str_pad($input, ($decimales + 3), 0, STR_PAD_RIGHT);
                    $cuerpo = $html . $tabla_resumen;
                    echo  '<style type="text/css">.decimales {mso-number-format: ' . $valor . ';}</style>
                    <meta charset="utf-8" />
                    <div class="head"><table><tr><td align="center" colspan="12" >
                    <h4>'. mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8').'<br />
                    Reporte de Kardex Resumen <br>' . $data['subtitulo'].'</h4></td></tr></table></div>';
                    echo $cuerpo;
                }                  
            }            
        }else{
            $select = '<option value=""></option>';
            $bodegas = $this->inventario_model->get_bodegas_usuario();
            foreach ($bodegas as $key => $bod) {
                $select .= '<option value="' . $bod['bod_id'] . '">' . $bod['bod_nombre'] . '</option>';
            }
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['bodega'] = $select;
            $data['titulo_personal'] = 'Reporte Kardex Resumen';
            cargarvista($data);
        }
    }

    function rpt_krdx_detalle($flag = null){
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        if ($_POST) {
            $post_array = $this->input->post();
            $detalles = $con_detalle = array();
            $tipo_reporte = $post_array['tipo_reporte'];
            if ($flag) {
                $bodega    = $post_array['bodega'];
                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
            } else {
                $bodega    = $post_array['hdn_bod_id'];
                $fecha_ini = $post_array['hdn_fe_ini'];
                $fecha_fin = $post_array['hdn_fe_fin'];
            }
            $datos_resumen = $this->inventario_model->rpte_kardex_resumen($bodega,$fecha_ini,$fecha_fin);
            foreach ($datos_resumen as $key => $value) {
                if ($value['entradas'] > 0 || $value['salidas'] > 0 || $value['inv_ini_uni'] > 0) {
                    $con_detalle[] = $value['art_id'];
                } else {
                    if ($bodega != "") {
                        unset($datos_resumen[$key]);
                    }
                }
            }
            $detalles_mov = $this->inventario_model->rpte_kardex_detalle($bodega,$fecha_ini,$fecha_fin,$con_detalle);
            if (count($detalles_mov) > 0) {
                foreach ($datos_resumen as $k1 => $val1) {
                    $datos_detalles = array();
                    foreach ($detalles_mov as $k2 => $val2) {
                        if ($val2['llave'] == $val1['llave']) {
                            $datos_detalles[] = $val2;
                        }
                    }
                    if (count($datos_detalles) > 0) {
                        $datos_resumen[$k1]['movimientos'] = $datos_detalles;
                    }
                }
            }
            if ($bodega != "") {
                //reordenar los datos y resetear las keys del array $datos_resumen y seguir usandolo
                $datos_reporte = usort($datos_resumen, function($a, $b) {
                    return $a['llave'] - $b['llave'];
                });
            }
            $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $datos['decimales'] = $decimales;
            $datos['tbl_rsum'] = $this->inventario_model->tabla_rpt_krdx_det($bodega,$fecha_ini,$fecha_fin);
            $tabla_resumen = $this->load->view('inventario/reportes/det_krdx_tabla_resumen', $datos, true);
            $filename = 'rpt_krdx_det_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['nit'] = $this->gsatelite->get_parametro('SYS_NIT');
            $data['nrc'] = $this->gsatelite->get_parametro('SYS_REGISTRO');
            $data['decimales'] = $decimales;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['filename'] = $filename;
            $data['detalles'] = $datos_resumen;
            $data['tbl_rsum'] = $tabla_resumen;
            $data['subtitulo'] = 'Periodo del ' . formatear_fecha('d-m-Y',$fecha_ini) . ' al ' . formatear_fecha('d-m-Y',$fecha_fin);
            $html = $this->load->view('inventario/reportes/detalle_krdx_detalle', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Kardex Detallado';
                    $data['subtitulo'] = 'Del ' . formatear_fecha('d-m-Y',$fecha_ini) . ' Al ' . formatear_fecha('d-m-Y',$fecha_fin);
                    // $header = $this->load->view('reporte/header', $data, true);
                    // $header = str_replace('<table align="center" cellpadding="0" >', '<table align="center" cellpadding="0" width="100%">', $header);
                    // $encabezado_footer = '<style> thead { display: table-header-group; } tfoot { display: table-footer-group; }
                    // @media print { thead { display: table-header-group; border:none; } tfoot { display: table-footer-group; } }
                    // @media screen { thead { display: none; } tfoot { display: none; } } </style>
                    // <table  border="0" width="100%" cellpadding="0" cellspacing="0" ><thead><tr  nobr="true" ><td>'.$header.'</td></tr></thead><tbody><tr><td>';
                    // $html = $encabezado_footer . $html. '<script type="text/javascript"> window.print(); document.title = "Reporte kardex resumen"; </script>
                    // </td></tr></tbody></table>';
                    $data['bodega'] = ($bodega != "") ? $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $bodega)) : 'TODAS';
                    $data['nit'] = $this->gsatelite->get_parametro('SYS_NIT');
                    $data['nrc'] = $this->gsatelite->get_parametro('SYS_REGISTRO');
                    $data['subtitulo'] = 'Del ' . formatear_fecha('d-m-Y',$fecha_ini) . ' Al ' . formatear_fecha('d-m-Y',$fecha_fin);
                    $header = $this->load->view('reporte/header_krdx_det', $data, true);
                    $GLOBALS['nombre_reporte'] = 'Rpte_krdx_detalle_' . date('dmY');
                    // $reporte = $html;
                    // echo $reporte; die();
                    $reporte = $header . $html;
                    echo $reporte;die();
                    // $this->pdf->makePdf($reporte, 'L', 'Reporte_Krdx_Detalle', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }                  
            }            
        } else {
            $select = '<option value=""></option>';
            $bodegas = $this->inventario_model->get_bodegas_usuario();
            foreach ($bodegas as $key => $bod) {
                $select .= '<option value="' . $bod['bod_id'] . '">' . $bod['bod_nombre'] . '</option>';
            }
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['bodega'] = $select;
            $data['titulo_personal'] = 'Reporte Kardex Detallado';
            cargarvista($data);
        }
        
    }

    /**
     * Descripción:
     * Función para mostrar los datos de los expedientes del paciente creados
     * @author Habby Lovo - Grupo satélite
     * @since  2019-08-12
     * @param  Ninguno
     * @return registros de paciente
     */
    public function balance_bodega(){
        if($this->input->post()){
            $slcPeriodo = $this->input->post('slcPeriodo');
            $slcBodega = $this->input->post('slcBodega');
            if($slcPeriodo == ''){
                $slcPeriodo = date("m");
            }
            $year = date('Y');
            $dia = date("d", mktime(0,0,0, $slcPeriodo+1, 0, $year));
            $fecha_ini = date('Y-m-d', mktime(0,0,0, $slcPeriodo, 1, $year));
            $fecha_fin = date('Y-m-d', mktime(0,0,0, $slcPeriodo, $dia, $year));
            $bodega = ($slcBodega != '') ? $slcBodega : null;
            $historial_movimiento_reg = $this->inventario_model->get_movimientos_reporte($fecha_ini, $fecha_fin, $bodega);
            $data['tipo'] = '';
            $data["reporte_reg"] = $historial_movimiento_reg;
            $html = $this->load->view('inventario/reportes/tabla_balance_bodega', $data, true);
            echo $html;
            die();
        }
        $meses = array('Enero'=> 1, 'Febrero'=> 2, 'Marzo'=> 3, 'Abril'=> 4, 'Mayo'=> 5, 'Junio'=> 6, 'Julio'=> 7, 'Agosto'=> 8, 'Septiembre'=> 9, 'Octubre'=> 10,  'Noviembre'=> 11, 'Diciembre'=> 12);
        $select = '';
        $mes_actual = date('m');
        foreach ($meses as $key => $value) {
            $selected = ($mes_actual == $value) ? 'selected':'';
            $select .= '<option value="'.$value.'" '.$selected.'>'.$key.'</option>';
        }
        $data['slcMeses'] = $select;
        $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => '1'), null, '', 'bod_id', true);
        $data['slcBodega'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');
        $data['titulo_personal'] = 'Reporte de Balance de bodega';
        cargarvista($data);
    }

    function imprimir_balance_bodega(){
        try{
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', '9999');
            if($this->input->post()){
                $slcPeriodo = $this->input->post('slcPeriodo');
                $slcBodega = $this->input->post('slcBodega');
                $tipo = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
                $meses_letras = array(1=>'Enero',2=>'Febrero',3=>'Marzo',4=>'Abril',5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');
                if($slcPeriodo == ''){
                    $slcPeriodo = date("m");
                }
                $year = date('Y');
                $dia = date("d", mktime(0,0,0, $slcPeriodo+1, 0, $year));
                $fecha_ini = date('Y-m-d', mktime(0,0,0, $slcPeriodo, 1, $year));
                $fecha_fin = date('Y-m-d', mktime(0,0,0, $slcPeriodo, $dia, $year));
                $bodega = ($slcBodega != '') ? $slcBodega : null;
                $bodega_nombre = ($slcBodega != '') ? $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $slcBodega)) : '';
                $historial_movimiento_reg = $this->inventario_model->get_movimientos_reporte($fecha_ini, $fecha_fin, $bodega);
                $data['dia_inicio'] = 1;
                $data['dia_fin'] = $dia;
                $data['bodega_nombre'] = $bodega_nombre;
                $data['mes_nombre'] = $meses_letras[$slcPeriodo];
                $data['tipo'] = $tipo;
                $data["reporte_reg"] = $historial_movimiento_reg;
                $data['filename'] = 'Balance de bodega';
                if($tipo == 'excel'){
                    $html = $this->load->view('inventario/reportes/tabla_balance_bodega', $data, true);
                    echo $html;
                } else{
                    ini_set('display_errors', 0);
                    $html_header = $this->load->view('reporte/header', array('titulo' => 'Balance de Bodega'), true);
                    $html = $this->load->view('inventario/reportes/tabla_balance_bodega_pdf', $data, true);
                    $reporte = $this->pdf->makePDF($html_header . $html, 'L');
                }
                die();
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Descripción:
     * @author Habby Lovo - Grupo satélite
     * @since  2019-08-12
     * @param  Ninguno
     * @return registros de paciente
     */
    public function reporte_saldo_consumo(){
        if($this->input->post()){
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', '9999');
            $slcPeriodo = $this->input->post('slcPeriodo');
            $slcBodega = $this->input->post('slcBodega');
            if($slcPeriodo == ''){
                $slcPeriodo = date("m");
            }
            $year = date('Y');
            $dia = date("d", mktime(0,0,0, $slcPeriodo+1, 0, $year));
            $fecha_ini = date('Y-m-d', mktime(0,0,0, $slcPeriodo, 1, $year));
            $fecha_fin = date('Y-m-d', mktime(0,0,0, $slcPeriodo, $dia, $year));
            $where = 'AND DATE(moi_fecha_mov) >= "'.$fecha_ini.'" AND DATE(moi_fecha_mov) <= "'.$fecha_fin.'"';
            $historial_movimiento_reg = $this->inventario_model->get_saldo_existencia_reporte($where);
            $bodegas_reg = $this->gsatelite->get_tabla('bod_bodega');
            $indentificador_columna = array_column($historial_movimiento_reg, 'indentificador');
            $tia_columna_array = array_column($historial_movimiento_reg, 'tia_id');
            $tia_columna = array_unique($tia_columna_array);
            $tia_columna = array_filter($tia_columna);
            $tia_columna = array_values($tia_columna);

            $regresar = array();
            foreach ($tia_columna as $key => $value) {
                foreach ($bodegas_reg as $key2 => $value2) {

                    if(in_array(($value.$value2['bod_id']), $indentificador_columna)){
                        $posicion = array_search(($value.$value2['bod_id']), $indentificador_columna);

                        if(!isset($regresar[$value])){
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => $historial_movimiento_reg[$posicion]['entradas']);
                            $regresar[$value] = array(
                                'categoria' => $value,
                                'codigo' => $historial_movimiento_reg[$posicion]['tia_codigo'],
                                'bodega' => array($arreglo_temp)
                            );
                        } else{
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => $historial_movimiento_reg[$posicion]['entradas']);
                            array_push($regresar[$value]['bodega'], $arreglo_temp);
                        }
                    } else{
                        $posicion = array_search($value, $tia_columna_array);
                        if(!isset($regresar[$value])){
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => 0);
                            $regresar[$value] = array(
                                'categoria' => $value,
                                'codigo' => $historial_movimiento_reg[$posicion]['tia_codigo'],
                                'bodega' => array($arreglo_temp)
                            );
                        } else{
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => 0);
                            array_push($regresar[$value]['bodega'], $arreglo_temp);
                        }
                    }
                }
            }
            
            $data['tipo'] = '';
            $data['bodegas_reg'] = $bodegas_reg;
            $data["reporte_reg"] = $regresar;
            $html = $this->load->view('inventario/reportes/tabla_reporte_saldo_consumo', $data, true);
            echo $html;
            die();
        }
        $meses = array('Enero'=> 1, 'Febrero'=> 2, 'Marzo'=> 3, 'Abril'=> 4, 'Mayo'=> 5, 'Junio'=> 6, 'Julio'=> 7, 'Agosto'=> 8, 'Septiembre'=> 9, 'Octubre'=> 10,  'Noviembre'=> 11, 'Diciembre'=> 12);
        $select = '';
        $mes_actual = date('m');
        foreach ($meses as $key => $value) {
            $selected = ($mes_actual == $value)?'selected':'';
            $select .= '<option value="'.$value.'" '.$selected.'>'.$key.'</option>';
        }
        $data['slcMeses'] = $select;
        $meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');
        $bodegas_reg = $this->gsatelite->get_tabla('bod_bodega');
        $data['bodegas_reg'] = $bodegas_reg;
        $data['titulo_personal'] = 'Reporte de saldo de consumo';
        cargarvista($data);
    }

    public function reporte_consumo_area($flag=null){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $where = array();
            $are = $_POST["are_slc"];
            $bod = $_POST["bod_slc"];
            $tia = $_POST["tia_slc"];
            $fini = formatear_fecha("Y-m-d", $_POST["fch_ini"]);
            $ffin = formatear_fecha("Y-m-d", $_POST["fch_fin"]);
            $tipo = $_POST["tipo_repo"];
            if ($fini != "") {
                $where['DATE(moi_fecha_mov) >= '] = $fini;
            }
            if ($ffin != "") {
                $where['DATE(moi_fecha_mov) <= '] = $ffin;
            }
            if ($are > 0) {
                $where['are_id'] = $are;
            }
            if ($bod > 0) {
                $where['bod_id'] = $bod;
            }
            if ($tia > 0) {
                $where['tia_id'] = $tia;
            }
            $registros = $this->inventario_model->consumo_areas_report($where);
            $html = $this->load->view('inventario/reportes/tabla_rpte_consumo_area', array('tipo'=>$tipo,'filas'=>$registros,'filename'=>'consumos'.date('dmY')), true);
            if ($flag) {
                echo json_encode(array('html' => $html, 'filas' => count($registros)));
            } else {
                if ($tipo == 'pdf') {
                    $header = $this->load->view('reporte/header', array('titulo' => 'Requisiciones'), true);
                    $this->pdf->makePDF($header . $html, 'L');
                } else {
                    echo $html;
                }                
            }
        } else {
            $area = $this->gsatelite->get_dropdown('are_area', 'are_nombre', '', array('are_estado'=>1), null, '', 'are_id', true);
            $bode = $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', '', array('bod_estado'=>1), null, '', 'bod_id', true);
            $cate = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} {tia_nombre}', '', array('tia_estado'=>1), null, '', 'tia_id', true);
            $data['slc_are'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $area);
            $data['slc_bod'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $bode);
            $data['slc_tia'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $cate);
            $data['titulo_personal'] = 'Reporte de Consumo';
            cargarvista($data);
        }
    }

    public function reporte_requisiciones_area($flag=null){
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $where = array();
            $are = $_POST["are_slc"];
            $bod = $_POST["bod_slc"];
            $tia = $_POST["tia_slc"];
            $fini = formatear_fecha("Y-m-d", $_POST["fch_ini"]);
            $ffin = formatear_fecha("Y-m-d", $_POST["fch_fin"]);
            $tipo = $_POST["tipo_repo"];
            if ($fini != "") {
                $where['DATE(rxi_fecha) >= '] = $fini;
            }
            if ($ffin != "") {
                $where['DATE(rxi_fecha) <= '] = $ffin;
            }
            if ($are > 0) {
                $where['are_id'] = $are;
            }
            if ($bod > 0) {
                $where['bod_id'] = $bod;
            }
            if ($tia > 0) {
                $where['tia_id'] = $tia;
            }
            $registros = $this->inventario_model->requix_areas_report($where);
            $html = $this->load->view('inventario/reportes/tabla_rpte_requix_area', array('tipo'=>$tipo,'filas'=>$registros,'filename'=>'consumos'.date('dmY')), true);
            if ($flag) {
                echo json_encode(array('html' => $html, 'filas' => count($registros)));
            } else {
                if ($tipo == 'pdf') {
                    $header = $this->load->view('reporte/header', array('titulo' => 'Requisiciones'), true);
                    $this->pdf->makePDF($header . $html, 'L');
                } else {
                    echo $html;
                }                
            }
        } else {
            $area = $this->gsatelite->get_dropdown('are_area', 'are_nombre', '', array('are_estado'=>1), null, '', 'are_id', true);
            $bode = $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', '', array('bod_estado'=>1), null, '', 'bod_id', true);
            $cate = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} {tia_nombre}', '', array('tia_estado'=>1), null, '', 'tia_id', true);
            $data['slc_are'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $area);
            $data['slc_bod'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $bode);
            $data['slc_tia'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $cate);
            $data['titulo_personal'] = 'Reporte de Consumo Requisiciones';
            cargarvista($data);
        }
    }

    function imprimir_reporte_saldo_consumo(){
        try{
            if($this->input->post()){
                ini_set('memory_limit', '-1');
                ini_set('max_execution_time', '9999');
                $slcPeriodo = $this->input->post('slcPeriodo');
                $tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

                if($slcPeriodo == ''){
                    $slcPeriodo = date("m");
                }

                $year = date('Y');
                $dia = date("d", mktime(0,0,0, $slcPeriodo+1, 0, $year));

                $fecha_ini = date('Y-m-d', mktime(0,0,0, $slcPeriodo, 1, $year));
                $fecha_fin = date('Y-m-d', mktime(0,0,0, $slcPeriodo, $dia, $year));


                $where = 'AND DATE(moi_fecha_mov) >= "'.$fecha_ini.'" AND DATE(moi_fecha_mov) <= "'.$fecha_fin.'"';

                // print_r($where);
                $historial_movimiento_reg = $this->inventario_model->get_saldo_existencia_reporte($where);

                $bodegas_reg = $this->gsatelite->get_tabla('bod_bodega');

                $indentificador_columna = array_column($historial_movimiento_reg, 'indentificador');

                $tia_columna_array = array_column($historial_movimiento_reg, 'tia_id');
                $tia_columna = array_unique($tia_columna_array);
                $tia_columna = array_filter($tia_columna);
                $tia_columna = array_values($tia_columna);

                $regresar = array();
                foreach ($tia_columna as $key => $value) {
                    foreach ($bodegas_reg as $key2 => $value2) {

                        if(in_array(($value.$value2['bod_id']), $indentificador_columna)){
                            $posicion = array_search(($value.$value2['bod_id']), $indentificador_columna);

                            if(!isset($regresar[$value])){
                                $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => $historial_movimiento_reg[$posicion]['entradas']);
                                $regresar[$value] = array(
                                    'categoria' => $value,
                                    'codigo' => $historial_movimiento_reg[$posicion]['tia_codigo'],
                                    'bodega' => array($arreglo_temp)
                                );
                            } else{
                                $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => $historial_movimiento_reg[$posicion]['entradas']);
                                array_push($regresar[$value]['bodega'], $arreglo_temp);
                            }
                        } else{
                            $posicion = array_search($value, $tia_columna_array);
                            if(!isset($regresar[$value])){
                                $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => 0);
                                $regresar[$value] = array(
                                    'categoria' => $value,
                                    'codigo' => $historial_movimiento_reg[$posicion]['tia_codigo'],
                                    'bodega' => array($arreglo_temp)
                                );
                            } else{
                                $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => 0);
                                array_push($regresar[$value]['bodega'], $arreglo_temp);
                            }
                        }
                        
                    }
                }
                
                $meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');

                $data['dia_inicio'] = 1;
                $data['dia_fin'] = $dia;
                $data['mes_nombre'] = $meses_letras[$slcPeriodo];
                $data['tipo'] = $tipo;
                $data['bodegas_reg'] = $bodegas_reg;
                $data["reporte_reg"] = $regresar;
                
                $data['filename'] = 'Balance de bodega';
                if($tipo == 'excel'){
                    $html = $this->load->view('inventario/reportes/tabla_reporte_saldo_consumo', $data, true);
                    echo $html;
                    // $this->load->library('excelphp');
                    // $this->excelphp->crear_excel('Balance de bodega', $html, 0, 'Saldo de consumo correspondiente al mes de '.$data['mes_nombre'].' / '.$year);
                }
                die();
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Descripción:
     * Función para mostrar los datos de los expedientes del paciente creados
     * @author Habby Lovo - Grupo satélite
     * @since  2019-08-12
     * @param  Ninguno
     * @return registros de paciente
     */
    public function reporte_informe_mensual_existencia(){
        if($this->input->post()){
            $slcPeriodo = $this->input->post('slcPeriodo');
            $slcBodega = $this->input->post('slcBodega');

            if($slcPeriodo == ''){
                $slcPeriodo = date("m");
            }

            $year = date('Y');
            $dia = date("d", mktime(0,0,0, $slcPeriodo+1, 0, $year));

            $fecha_ini = date('Y-m-d', mktime(0,0,0, $slcPeriodo, 1, $year));
            $fecha_fin = date('Y-m-d', mktime(0,0,0, $slcPeriodo, $dia, $year));


            $where['DATE(cex_fecha_desde) = "'.$fecha_ini.'" AND DATE(cex_fecha_hasta) = "'.$fecha_fin.'"'] = null;

            if($slcBodega != ''){
                $where['cex_id_bod'] = $slcBodega;
            }
            // print_r($where);
            $historial_movimiento_reg = $this->inventario_model->get_informe_existencia_reporte($where);

            $categoria_reg = $this->gsatelite->get_tabla('tia_tipo_articulo');

            $regresar = array();
            foreach ($categoria_reg as $key => $value) {
                if(!isset($regresar[$value['tia_id'] ])){
                    $regresar[$value['tia_id']] = array(
                        'categoria_id' => $value['tia_id'],
                        'categoria' => $value['tia_nombre'],
                        'codigo' => $value['tia_codigo'],
                        'productos' => array()
                    );
                }
                foreach ($historial_movimiento_reg as $key2 => $value2) {
                    if($value2['tia_id'] == $value['tia_id']){
                        if(!isset($regresar[$value2['tia_id']])){
                            $arreglo_temp = array(
                                'codigo_articulo' => $value2['art_codigo'], 
                                'producto' => $value2['art_nombre'],
                                'medida' => $value2['mep_nombre'],
                                'correlativo' => $value2['cex_correlativo'],
                                'cantidad' => $value2['cex_cantidad_ant'],
                                'precio' => $value2['cex_precio_ant'],
                                'total' => $value2['total']
                            );
                            $regresar[$value2['tia_id']] = array(
                                'categoria_id' => $value2['tia_id'],
                                'categoria' => $value2['tia_nombre'],
                                'codigo' => $value2['tia_codigo'],
                                'productos' => array($arreglo_temp)
                            );
                        } else{
                            $arreglo_temp = array(
                                'codigo_articulo' => $value2['art_codigo'], 
                                'producto' => $value2['art_nombre'],
                                'medida' => $value2['mep_nombre'],
                                'correlativo' => $value2['cex_correlativo'],
                                'cantidad' => $value2['cex_cantidad_ant'],
                                'precio' => $value2['cex_precio_ant'],
                                'total' => $value2['total']
                            );
                            array_push($regresar[$value2['tia_id']]['productos'], $arreglo_temp);
                        }
                    }
                }
            }

            // print_r($regresar);

            // die();
            $data['tipo'] = '';
            $data["reporte_reg"] = $regresar;
            $html = $this->load->view('inventario/reportes/tabla_reporte_informe_mensual_existencia', $data, true);
            echo $html;
            die();
        }
        $meses = array('Enero'=> 1, 'Febrero'=> 2, 'Marzo'=> 3, 'Abril'=> 4, 'Mayo'=> 5, 'Junio'=> 6, 'Julio'=> 7, 'Agosto'=> 8, 'Septiembre'=> 9, 'Octubre'=> 10,  'Noviembre'=> 11, 'Diciembre'=> 12);

        $select = '';
        $mes_actual = date('m');
        foreach ($meses as $key => $value) {
            $selected = ($mes_actual == $value)?'selected':'';
            $select .= '<option value="'.$value.'" '.$selected.'>'.$key.'</option>';
        }
        $data['slcMeses'] = $select;

        $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => '1'), null, '', 'bod_id', true);
        $data['slcBodega'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');

        $data['titulo_personal'] = 'Informe mensual de las existencias';
        cargarvista($data);
    }

    function imprimir_reporte_informe_mensual_existencia(){
        try{
            ini_set('memory_limit', '-1');
            ini_set('max_execution_time', '9999');
            if($this->input->post()){
                $slcPeriodo = $this->input->post('slcPeriodo');
                $slcBodega = $this->input->post('slcBodega');
                $tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

                $meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');

                if($slcPeriodo == ''){
                    $slcPeriodo = date("m");
                }

                $year = date('Y');
                $dia = date("d", mktime(0,0,0, $slcPeriodo+1, 0, $year));

                $fecha_ini = date('Y-m-d', mktime(0,0,0, $slcPeriodo, 1, $year));
                $fecha_fin = date('Y-m-d', mktime(0,0,0, $slcPeriodo, $dia, $year));

                $where['DATE(cex_fecha_desde) = "'.$fecha_ini.'" AND DATE(cex_fecha_hasta) = "'.$fecha_fin.'"'] = null;

                $bodega_nombre = '';
                if($slcBodega != ''){
                    $where['cex_id_bod'] = $slcBodega;
                    $bodega_reg = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $slcBodega));
                    $bodega_nombre = $bodega_reg[0]['bod_nombre'];
                }
                // print_r($where);
                $historial_movimiento_reg = $this->inventario_model->get_informe_existencia_reporte($where);

                $categoria_reg = $this->gsatelite->get_tabla('tia_tipo_articulo');

                $regresar = array();
                foreach ($categoria_reg as $key => $value) {
                    if(!isset($regresar[$value['tia_id'] ])){
                        $regresar[$value['tia_id']] = array(
                            'categoria_id' => $value['tia_id'],
                            'categoria' => $value['tia_nombre'],
                            'codigo' => $value['tia_codigo'],
                            'productos' => array()
                        );
                    }
                    foreach ($historial_movimiento_reg as $key2 => $value2) {
                        if($value2['tia_id'] == $value['tia_id']){
                            if(!isset($regresar[$value2['tia_id']])){
                                $arreglo_temp = array(
                                    'codigo_articulo' => $value2['art_codigo'], 
                                    'producto' => $value2['art_nombre'],
                                    'medida' => $value2['mep_nombre'],
                                    'correlativo' => $value2['cex_correlativo'],
                                    'cantidad' => $value2['cex_cantidad_ant'],
                                    'precio' => $value2['cex_precio_ant'],
                                    'total' => $value2['total']
                                );
                                $regresar[$value2['tia_id']] = array(
                                    'categoria_id' => $value2['tia_id'],
                                    'categoria' => $value2['tia_nombre'],
                                    'codigo' => $value2['tia_codigo'],
                                    'productos' => array($arreglo_temp)
                                );
                            } else{
                                $arreglo_temp = array(
                                    'codigo_articulo' => $value2['art_codigo'], 
                                    'producto' => $value2['art_nombre'],
                                    'medida' => $value2['mep_nombre'],
                                    'correlativo' => $value2['cex_correlativo'],
                                    'cantidad' => $value2['cex_cantidad_ant'],
                                    'precio' => $value2['cex_precio_ant'],
                                    'total' => $value2['total']
                                );
                                array_push($regresar[$value2['tia_id']]['productos'], $arreglo_temp);
                            }
                        }
                    }
                }

                // print_r($regresar);

                // die();
                $data['dia_inicio'] = 1;
                $data['dia_fin'] = $dia;
                $data['bodega_nombre'] = $bodega_nombre;
                $data['mes_nombre'] = $meses_letras[$slcPeriodo];
                $data['tipo'] = $tipo;
                $data["reporte_reg"] = $regresar;
                
                $data['filename'] = 'Informe mensual de existencias';
                if($tipo == 'excel'){
                    $html = $this->load->view('inventario/reportes/tabla_reporte_informe_mensual_existencia', $data, true);
                    echo $html;
                } else{
                    ini_set('display_errors', 0);
                    $html_header = $this->load->view('reporte/header', array('titulo' => 'Informe mensual de existencias'), true);
                    $html = $this->load->view('inventario/reportes/tabla_reporte_informe_mensual_existencia_pdf', $data, true);
                    // echo $html;
                    // die();
                    $reporte = $this->pdf->makePDF($html_header . $html, 'L');
                    // $this->pdf->makePdf($html, 'h', 'Reporte_de_programas_vinculados', 'Letter');
                }
                die();
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function existencias_bodegas($flag = null){
        satelite_validar();
        /*REPORTE TIENE INCONSISTENCIAS EN SU LOGICA, POR EJEMPLO DEBE BUSCAR EXISTENCIAS PERO SOLO MUESTRA SALIDAS.
        SE DEBE REDEFINIR LA LOGICA DEL REPORTE POR LO QUE EN LA VISTA SE DESABILITARA EL BOTON DE CONSULTAR,
        SE ENVIARA UNA ALERTA Y SE REDIRIGIRA HACIA UN REPORTE SIMILAR HASTA QUE SE MODIFIQUE EL PRESENTE REPORTE,
        POSTERIORMENTE SE VOLVERA A HABILITAR 23/9/20 by Raul E.*/
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_reporte = $post_array['tipo_reporte'];
            if ($flag) {                
                $fecha_ini = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];
            } else {
                $fecha_ini = $post_array['hdn_fe_ini'];
                $fecha_fin = $post_array['hdn_fe_fin'];
            }
            $where['DATE(moi_fecha_mov) >='] = $fecha_ini;
            $where['DATE(moi_fecha_mov) <='] = $fecha_fin;
            $historial_movimiento_reg = $this->inventario_model->get_existencias_bodegas($where);
            $bodegas_reg = $this->gsatelite->get_tabla('bod_bodega');
            $indentificador_columna = array_column($historial_movimiento_reg, 'indentificador');
            $tia_columna_array = array_values(array_unique(array_filter(array_column($historial_movimiento_reg, 'tia_id'))));
            $regresar = array();
            foreach ($tia_columna_array as $key => $value) {
                foreach ($bodegas_reg as $key2 => $value2) {
                    if(in_array(($value.$value2['bod_id']), $indentificador_columna)){
                        $posicion = array_search(($value.$value2['bod_id']), $indentificador_columna);
                        if(!isset($regresar[$value])){
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => $historial_movimiento_reg[$posicion]['salidas']);
                            $regresar[$value] = array(
                                'categoria' => $value,
                                'codigo' => $historial_movimiento_reg[$posicion]['tia_codigo'],
                                'bodega' => array($arreglo_temp)
                            );
                        } else {
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => $historial_movimiento_reg[$posicion]['salidas']);
                            array_push($regresar[$value]['bodega'], $arreglo_temp);
                        }
                    } else{
                        $posicion = array_search($value, $tia_columna_array);
                        if(!isset($regresar[$value])){
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => 0);
                            $regresar[$value] = array(
                                'categoria' => $value,
                                'codigo' => $historial_movimiento_reg[$posicion]['tia_codigo'],
                                'bodega' => array($arreglo_temp)
                            );
                        } else{
                            $arreglo_temp = array('bodega_nombre' => $value2['bod_nombre'], 'monto' => 0);
                            array_push($regresar[$value]['bodega'], $arreglo_temp);
                        }
                    }                    
                }
            }
            $fecha = explode('-', $fecha_ini);
            $filename = 'rpt_exist_bod_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $decimales = (trim($decimales) != '') ? $decimales : 2;
            $data['decimales'] = $decimales;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['filename'] = $filename;
            $data['reporte_reg'] = $regresar;
            $data['bodegas_reg'] = $bodegas_reg;
            $data['mes'] = $fecha[1];
            $data['anio'] = $fecha[0];
            $html = $this->load->view('inventario/reportes/detalle_existencias_bodegas', $data, true);
            echo $html;
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = 'Saldo Existencias Bodegas';
            cargarvista($data);
        }
    }

    /*
    * @author Raul E.
    * @since 2020-abr
    * @return reporte de inventarios MH
    */
    public function informe_inventario_anual($flag = null){
        satelite_validar();
        if ($_POST) {
            ini_set('memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');
            if ($flag) {
                $year = $this->input->post('periodo');
                $bode = $this->input->post('bodega');
                $reporte = "";
                $tipo_reporte = "";
            } else {
                $reporte = $this->input->post('reporte');
                $tipo_reporte = $this->input->post('tipo_reporte');
                $year = $this->input->post('hdn_year');
                $bode = $this->input->post('hdn_bod');
            }
            $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $bod_nom = mb_strtoupper($this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $bode)), 'UTF-8'); 
            $filename = 'reporte_inventario_anual_' . $year;
            if ($flag != "" || $tipo_reporte == 'prn') {
                $tip_entrada = implode(',', array_column($this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_entrada' => 1,'tip_estado' => 1)), 'tip_id'));
                $tip_entrada = ($tip_entrada != "") ? $tip_entrada : 0;
                $where["moi_id_tip IN ($tip_entrada)"] = null;
                $where['DATE_FORMAT(moi_fecha_mov,"%Y")'] = $year;
                if ($bode != "") {
                    $where["moi_id_bod"] = $bode;
                }
                $articulos = $this->inventario_model->get_reporte_983($where);
                $data['articulos'] = $articulos;
                $data['decimales'] = $decimales;
                $data['anio'] = $year;
                $html = $this->load->view('inventario/reportes/detalle_reporte_983', $data, true);
            }
            if ($flag) {
                $arreglo = array('tabla' => $html, 'filas' => count($articulos));
                echo json_encode($arreglo);
            } else {
                if ($tipo_reporte == 'pdf') {
                    $titulo = 'Inventario Anual ';
                    $titulo .= ($bode != "") ? 'Bodega: ' . $bod_nom . ' / ' . $year : $year;
                    $header = $this->load->view('reporte/header', array('titulo' => $titulo), true);
                    $GLOBALS['nombre_reporte'] = $filename;
                    $reporte = $header . $reporte;
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_F983', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $head = '<meta charset="utf-8" /><div class="head"><table><tr><td align="center" colspan="3" ><h3>' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                    $head .= '</h3></td></tr><tr><td align="center" colspan="3" ><h4>REPORTE DE INVENTARIO ANUAL DE ' . $year . '</h4></td></tr>';
                    $head .= ($bode != "") ? '<tr><td align="center" colspan="3"><h5>BODEGA: ' . $bod_nom . '</h5></td></tr>' : '';
                    $head .= '</table></div>'; 
                    $reporte_excel = $head . $reporte;
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("content-disposition: attachment;filename=" . $filename . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo $reporte_excel;
                } else {
                    $array_lineas = array();
                    $ruta_carga = 'public/temp/archivos/';
                    $nombre = 'reporte_inventario_anual_' . $year . '.prn';
                    $error_cat = $error_ref = 0;
                    foreach ($articulos as $key => $value) {
                        $cantidad = number_format($value['cantidad'],10,'','');
                        $costo_un = number_format($value['costo'],10,'','');
                        $costo_to = number_format(($value['cantidad'] * $value['costo']),10,'','');
                        if (!($value['art_referencia_del_bien'] > 0)) {
                            $error_cat++;
                        }
                        if (!($value['art_referencia_en_libro'] > 0)) {
                            $error_ref++;
                        }
                        $produc = mb_strtoupper(str_replace(array ("á","é","í","ó","ú",","), array ("a","e","i","o","u",""), $value['art_nombre']), 'UTF-8');
                        $medida = mb_strtoupper(str_replace(array ("á","é","í","ó","ú",","), array ("a","e","i","o","u",""), $value['medida']), 'UTF-8');
                        $linea = "";
                        $linea .= str_pad(trim($produc), 50, " ", STR_PAD_RIGHT);
                        $linea .= str_pad(trim($medida), 25, " ", STR_PAD_RIGHT);
                        $linea .= str_pad($cantidad, 22, "0", STR_PAD_LEFT);
                        $linea .= str_pad($costo_un, 24, "0", STR_PAD_LEFT);
                        $linea .= str_pad($costo_to, 24, "0", STR_PAD_LEFT);
                        $linea .= str_pad(trim($value['art_referencia_del_bien']), 2, "0", STR_PAD_LEFT);
                        $linea .= str_pad(trim($value['art_referencia_en_libro']), 2, "0", STR_PAD_LEFT);
                        $linea .= str_pad($year, 4, "0", STR_PAD_RIGHT);
                        if ($linea != ""){
                            $array_lineas[] = $linea;
                        }
                    }
                    if ($error_cat == 0 && $error_ref == 0) {
                        $separador = chr(13).chr(10);
                        $lineas = trim(implode($separador,$array_lineas));
                        $ruta_completa = $ruta_carga . $nombre;
                        if (file_exists("$ruta_completa")) {
                            unlink("$ruta_completa");
                        }
                        $archivo = fopen($ruta_completa,'w+') or die('No hay permisos de escritura');
                        fputs($archivo, $lineas);
                        fclose($archivo);
                        header( "Content-Type: application/octet-stream");
                        header('Content-Disposition: attachment; filename="'.$nombre.'"');
                        ob_clean(); 
                        flush(); 
                        readfile("$ruta_completa");
                    } else {
                        if ($error_cat > 0) {
                            echo "<b>Existen " . $error_cat . " productos a los que no se les ha especificado la Categoría del bien</b><br>";
                        }
                        if ($error_ref > 0) {
                            echo "<b>Existen " . $error_ref . " productos a los que no se les ha especificado la Referencia en Libros</b><br>";
                        }
                    }
                }                
            }            
        } else {
            $select = '';
            $bodegas = $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data['permiso'] = $this->gsatelite->get_permisos_opcion();
            $data['bodega'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $bodegas);
            cargarvista($data);
        }
    }    

    public function ajustes_inventario($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fec_ini = $this->input->post('fecha_ini');
            $fec_fin = $this->input->post('fecha_fin');
            $bodegas = $this->input->post('bodega_id');
            $tipo_aj = $this->input->post('ajuste_tp');
            $reporte = $this->input->post('reporte');
            if ($fec_ini != "") {
                $where['DATE(aju_fecha_ajuste) >= '] = formatear_fecha('Y-m-d', $fec_ini);
            }
            if ($fec_fin != "") {
                $where['DATE(aju_fecha_ajuste) <= '] = formatear_fecha('Y-m-d', $fec_fin);
            }
            if ($bodegas != "") {
                $where['moi_id_bod'] = $bodegas;
            }
            if ($tipo_aj != "") {
                $where['dea_tipo_operacion'] = $tipo_aj;
            }
            $titulo = 'Detalle de Ajustes de Inventario';
            $subtitulo = ($fec_ini != "") ? 'Desde: ' . formatear_fecha('d-m-Y', $fec_ini) . ' ' : "";
            $subtitulo .= ($fec_fin != "") ? 'Hasta: ' . formatear_fecha('d-m-Y', $fec_fin) : "";
            $registros = $this->inventario_model->get_ajustes_inv($where);
            $data['dec'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $data['subtitulo'] = $subtitulo;
            $data['registros'] = $registros;
            $data['tipo_reporte'] = $reporte;
            $html = $this->load->view('inventario/reportes/detalle_ajustes_inv', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
            } else {
                if ($reporte == 'pdf') {                    
                    $header = $this->load->view('reporte/header', array('titulo' => $titulo, 'subtitulo' => $subtitulo), true);
                    $GLOBALS['nombre_reporte'] = $titulo;
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'Ajustes de Inventario', 'Letter');
                } else {
                    echo $html;
                }                
            }            
        } else {
            $bodegas = $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data['permiso'] = $this->gsatelite->get_permisos_opcion();
            $data['bodega'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $bodegas);
            cargarvista($data);
        }        
    }

    function codigo_art_secundario() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["titulo_personal"] = "Codigos de Productos Secundarios";
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $data['categoria_padre'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', 'tia_nombre', 'categorias', array('tia_padre ' => null, 'tia_estado' => 1), null, null, null, true);
            $this->_cargarvista($data);
        }
    }

    function reporte_codigo_secundario($flag = null) {
        if ($_POST) {
            $post_array = $this->input->post();

            if ($flag == 1) {
                // $bodega = ($post_array['bodega'] != '') ? $post_array['bodega'] : null;
                $categoria = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
                $producto = ($post_array['producto'] != '') ? $post_array['producto'] : null;
            } else {
                // $bodega = ($post_array['filtro_bodega'] != '') ? $post_array['filtro_bodega'] : null;
                $categoria = ($post_array['filtro_categoria'] != '') ? $post_array['filtro_categoria'] : null;
                $producto = ($post_array['filtro_producto'] != '') ? $post_array['filtro_producto'] : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            $having = null;
            //Se crean las condicionales del reporte
            // if ($bodega != null) {
            //     $where['art_id_bod'] = $bodega;
            // }
            if ($categoria != null) {
                $where['art_id_tia'] = $categoria;                
            }
            if ($producto != null) {
                $where['art_id'] = $producto;
            }
            $group_by = "art_id, art_id_bod";
            
            $order_by = "codigo, linea";

            $data['reporte'] = $this->inventario_model->get_codigo_secundario($where, $group_by, $having, $order_by);
            $data['tipo_reporte'] = $tipo_reporte;
            $filename = 'rpt_codigo_secundario_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $html = $this->load->view('inventario/reportes/reporte_codigo_secundario', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Codigos Secundarios';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Codigo_Secundario' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Codigo_Secundario', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_codigo_secundario_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Codigos Secundarios';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    public function inventario_existencia_sector($f=null){
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            if ($post_array['a_cero'] > 0) {
                $where = array('sar_cant_actual > ' => 0);
            } else {
                $where = array('sar_cant_actual >= ' => 0);
            }
            if ($post_array['bod_id'] != "") {
                $where['sar_id_bod'] = $post_array['bod_id'];
            }
            if ($post_array['cat_id'] != "") {
                $where['tia_id'] = $post_array['cat_id'];                
            }
            if ($post_array['art_id'] != "") {
                $where['art_id'] = $post_array['art_id'];
            }
            if ($post_array['sxb_id'] != "") {
                $where['sar_id_sxb'] = $post_array['sxb_id'];
            }
            $data['tipo_reporte'] = $post_array['tipo_rep'];
            $groupby = ($this->gsatelite->get_parametro("SYS_USA_SECTORES", 0) > 0) ? "art_id, sar_id_bod, mep_id, sector" : "art_id, sar_id_bod, mep_id";
            $data['reporte'] = $this->inventario_model->get_existencias($where, $groupby, null, "linea, codigo");
            $html = $this->load->view('inventario/reportes/detalle_existencias_sector', $data, true);
            if ($f) {
                echo json_encode(array('tabla' => $html, 'filas' => count($data['reporte'])));
            } else {
                if ($post_array['tipo_rep'] == 'pdf') {
                    $GLOBALS['nombre_reporte'] = 'Reporte_Existencias_Sector_' . date('dmY');
                    $header = $this->load->view('reporte/header', array('titulo'=>'Existencias por sector'), true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Existencias_Sector', 'Letter');
                } else {
                    echo $html;
                }                
            }            
        } else {
            $data['bodegas'] = $this->inventario_model->usuarioxbodega();
            $data['categorias'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} {tia_nombre}', '', array('tia_estado' => 1), null, null, 'tia_id', true);
            $data['titulo_personal'] = 'Ubicación de Productos';
            $this->_cargarvista($data);
        }
    }


}//END CLASS
?>