<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reporteria extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('inventario_model');
		$this->load->model('gsatelite');
		if(ob_get_contents()) ob_end_clean();
	}

	public function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}

    
    function reporte_general(){

    	$this->_cargarvista();
    }
    

    public function generar_pdf()
    {
    	$tipo_proceso = $this->input->post('proceso');
    	$fecha_b      = date("Y-m-d",strtotime($this->input->post('fecha_inicio')));
    	$fecha_b2     = date("Y-m-d",strtotime($this->input->post('fecha_final')));

       $this->load->library('Pdf');
        $proceso = 1;
        $fecha = '2013-06-17';
        $fecha2 = '2013-06-20';
        $costo_final = 0;
        $result=$this->inventario_model->detalles_inventario($proceso,$fecha,$fecha2);
       
        $imprimir_html = '<h1>Alcaldia Municipal de Chalatenango</h1><br/><br/>';
        
        $imprimir_html.='<h2>Detalles de todas las compras realizadas</h2><br/>';
        $imprimir_html.='<h4>Modulo de Inventario</h4>';
        $imprimir_html.='<br/><br/><br/>';
        $imprimir_html.='<table width="100%"  border="1" cellspacing="3" cellpadding="3">';
        $imprimir_html.='<thead>';
        $imprimir_html.='<tr>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Detalles de compra</th>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Fecha de compras</th>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Cantidad de articulos</th>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Precio unitario de articulos</th>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Articulo</th>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Categoria del articulo</th>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Bodega</th>';
        $imprimir_html.='<th style="background-color:Teal;color:white;">Subtotal</th>';
        $imprimir_html.='</tr>';
        $imprimir_html.='</thead>';
        $imprimir_html.='<tbody>';
        foreach ($result as $informacion) {
        $imprimir_html.='<tr>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.$informacion['detalle'].'</td>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.$informacion['fecha'].'</td>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.$informacion['cantidad'].'</td>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.$informacion['precio'].'</td>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.$informacion['articulo'].'</td>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.$informacion['categoria'].'</td>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.$informacion['bodega'].'</td>';
        $imprimir_html.='<td style="background-color:LightCyan;">'.number_format($informacion['subtotal'],2).'</td>';
        $imprimir_html.='</tr>';
        $costo_final +=$informacion['subtotal'];
        }
        $imprimir_html.='</tbody>';
        $imprimir_html.='</table><br/><br/>';
        $imprimir_html.='<h3><font color="teal">costo final:'." $".$costo_final.'</font></h3>';
        $imprimir_html.='Detalles generados el dia:'.date("d/m/Y").'<br/><br/>';
        
        $this->pdf->makePDF($imprimir_html);

    }

    
             

	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
	}



/* End of file reporteria.php */
/* Location: ./application/controllers/reporteria.php */