﻿<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Registro_proveedor extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('inventario_model');
		$this->load->model('gsatelite');
		$this->load->library('grocery_CRUD');
        
        if(ob_get_contents()) ob_end_clean();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}
  

    public function generar_proveedores()
        {
    	$options['0']='seleccione';
        $this->db->where('reg_id_nir',8);
        foreach ($this->db->get('reg_region')->result() as $key) 
            {
            $options[$key->reg_id] = $key->reg_nombre;
            }
        $salida = "<div class='form-field-box' id='zona_field_box'><div class='form-input-box' id='zona_input_box'>".
    	form_dropdown('zona', $options, 0,"id=\"field-zona\" class=\"chosen-select\" style=\"display:inline-block; width:300px;\" ").
        "<div style=\"display:inline-block\"   id=\"departamentos_input_box\"><select id=\"departamentos\" name=\"departamentos\" class=\"chosen-select\" style=\"width:300px;\"></select></div>".
        "<div style=\"display:inline-block\"   id=\"dep_proveedor\"><select id=\"prv_id_reg_municipio\" name=\"prv_id_reg_municipio\" class=\"chosen-select\" style=\"width:300px;\"></select></div>".
    	"</div></div>";
    	return $salida;
        }

    public function buscar_paises()
        {
        $options['0']='seleccione';
        $this->db->where('reg_id_nir',2);
        foreach ($this->db->get('reg_region')->result() as $key) 
            {
            $options[$key->reg_id] = $key->reg_nombre;
            }
        $salida = "<div class='form-field-box' id='prv_id_reg_pais_field_box'><div class='form-input-box' id='prv_id_reg_pais_input_box'>".
        form_dropdown('prv_id_reg_pais', $options, 0,"id=\"field-prv_id_reg_pais\" class=\"chosen-select\" style=\"display:inline-block; width:300px;\" ").
        "</div></div>";
        return $salida;
        }


    public function get_municipio($dep)
        {
	    $this->db->where('reg_padre',$dep);
        foreach ($this->db->get('reg_region')->result() as $key) 
            {
            $options[] = array($key->reg_id,$key->reg_nombre);
            }
        echo json_encode($options);
        }


    public function ingresar_proveedor()
        {
     	$objeto_crud = new grocery_CRUD;
     	$objeto_crud->set_table('prv_proveedor');
        $objeto_crud->set_subject('Proveedor');
        $objeto_crud->set_relation('prv_id_reg_pais','reg_region','reg_nombre');
     	$objeto_crud->set_relation('prv_tamano','cat_catalogo','cat_nombre',array('cat_tipo'=>36,'cat_padre'=>0));
        
        $objeto_crud->add_fields('prv_id_reg_pais','prv_id_reg_municipio','prv_tamano','prv_codigo','prv_nombre','prv_direccion','prv_nit','prv_nrc','prv_servicio','prv_giro','prv_obs');
        $objeto_crud->columns('prv_codigo','prv_nombre','prv_nit','prv_nrc');
      
        $objeto_crud->display_as('prv_codigo','codigo de proveedor');
        $objeto_crud->display_as('prv_nombre','nombre de proveedor');
        $objeto_crud->display_as('prv_direccion','direccion de proveedor');
        $objeto_crud->display_as('prv_nit','numero de nit proveedor');
        $objeto_crud->display_as('prv_nrc','numero nrc de proveedor');
        $objeto_crud->display_as('prv_giro','giro del proveedor');
        $objeto_crud->display_as('prv_tamano','tamaño de proveedor');
        $objeto_crud->display_as('prv_id_reg_pais','pais de procedencia del proveedor');
        $objeto_crud->display_as('prv_id_reg_municipio','Ubicación del proveedor');
        $objeto_crud->display_as('prv_servicio','servicios');
        $objeto_crud->display_as('prv_obs','Observaciones');


        $objeto_crud->set_rules('prv_codigo','codigo del proveedor','required||integer');
        $objeto_crud->set_rules('prv_nombre','nombre del proveedor','required');
        $objeto_crud->set_rules('prv_direccion','direccion del proveedor','required');
        $objeto_crud->set_rules('prv_tamano','tamano del proveedor','required||integer');
        $objeto_crud->set_rules('prv_giro','giro del proveedor','required');
        $objeto_crud->set_rules('prv_nrc','campo nrc','required');
        $objeto_crud->set_rules('prv_servicio','servicio del proveedor','required');
        $objeto_crud->set_rules('prv_obs','observaciones del proveedor','required');
        $objeto_crud->set_rules('prv_id_reg_pais','pais de procedencia del proveedor','required');
        $objeto_crud->set_rules('prv_id_reg_municipio','Ubicación del proveedor','required');

    	$objeto_crud->add_action('Agregar Contacto', base_url() . 'media/imagenes/sistema/mcon_add.png','','con_add',function($primary_key , $row){return $primary_key;});
        $objeto_crud->add_action('Ver Contactos',  base_url() . 'media/imagenes/sistema/con_add.png', '','',array($this,'buscar_contacto'));
        $objeto_crud->add_action('Agregar Teléfono', base_url() . 'media/imagenes/sistema/mtel.png','','tel_add',function($primary_key){return $primary_key;});
        $objeto_crud->add_action('Ver Teléfonos',  base_url() . 'media/imagenes/sistema/tel.png', '','',array($this,'buscar_telefono'));
        $objeto_crud->add_action('Agregar Correo', base_url() . 'media/imagenes/sistema/memail.png','','cor_add',function($primary_key){return $primary_key;});
        $objeto_crud->add_action('Ver Correos',  base_url() . 'media/imagenes/sistema/email.png', '','',array($this,'buscar_correo'));

        $objeto_crud->unset_delete();  
        $objeto_crud->callback_add_field('prv_id_reg_municipio',array($this,'generar_proveedores'));
        $objeto_crud->callback_add_field('prv_id_reg_pais',array($this,'buscar_paises'));
        $objeto_crud->callback_edit_field('prv_id_reg_municipio',array($this,'generar_proveedores'));
        $objeto_crud->callback_edit_field('prv_id_reg_pais',array($this,'buscar_paises'));

        $output = $objeto_crud->render();
        $this->_cargarvista(null,$output);
        }

    function agregar_contacto()
        {
        if($prv_id = $this->input->post('prv_id'))
            {
            if($val = $this->db->insert('con_contacto',array(
                                                'con_id_prv'    =>  $prv_id,
                                                'con_nombre'    =>  $this->input->post('con_nombre'),
                                                'con_puesto'    =>  $this->input->post('con_puesto')
                                                )))
                {
                die('Contacto Guardado');
                }
            else
                {
                die('Error: No pudo guardarse');
                }
            }
        $data = array('prv_id' => $id = $this->input->post('valor'));
        $this->load->view('inventario/registro_proveedor/contacto_add_proveedor',$data);
        }

    function agregar_telefono()
        {
        if($prv_id = $this->input->post('prv_id'))
            {
            if($val = $this->db->insert('tel_telefono',array(
                                                'tel_telefono'    =>  $this->input->post('tel_telefono'),
                                                'tel_nombre'    =>  $this->input->post('tel_nombre')
                                                )))
                {
                $tel_id=mysql_insert_id();
                if($val = $this->db->insert('txp_telefonoxproveedor',array(
                                                'txp_id_prv'    =>  $prv_id,
                                                'txp_id_tel'    =>  $tel_id
                                                )))
                    {
                    die('Teléfono Guardado'); 
                    }
                else
                    {   
                    die('Error: No puedo guardarse la relación del proveedor con el teléfono');
                    } 
                }
            else
                {   
                die('Error: No puedo guardarse el teléfono');
                }
            }

        $data = array('prv_id' => $id = $this->input->post('valor'));
        $this->load->view('inventario/registro_proveedor/telefono_add_proveedor',$data);
        }

    function agregar_telefono2()
        {
        if($con_id = $this->input->post('con_id'))
                {
                if($val = $this->db->insert('tel_telefono',array(
                                                    'tel_telefono'    =>  $this->input->post('tel_telefono'),
                                                    'tel_nombre'    =>  $this->input->post('tel_nombre')
                                                    )))
                    {
                    $tel_id=mysql_insert_id();
                    if($val = $this->db->insert('txc_telefonoxcontacto',array(
                                                    'txc_id_con'    =>  $con_id,
                                                    'txc_id_tel'    =>  $tel_id
                                                    )))
                        {
                        die('Teléfono Guardado'); 
                        }
                    else
                        {   
                        die('Error: No puedo guardarse la relación del contacto con el teléfono');
                        } 
                    }
                else
                    {   
                    die('Error: No puedo guardarse el teléfono');
                    }
                }
        $data = array('con_id' => $id = $this->input->post('valor'));   
        $this->load->view('inventario/registro_proveedor/telefono_add_contacto',$data);
        }

    function agregar_correo2()
        {
        if($con_id = $this->input->post('con_id'))
            {
            if($val = $this->db->insert('cor_correo',array(
                                                'cor_correo'    =>  $this->input->post('cor_correo'),
                                                'cor_nombre'    =>  $this->input->post('cor_nombre')
                                                )))
                {
                $cor_id=mysql_insert_id();
                if($val = $this->db->insert('cxc_correoxcontacto',array(
                                                'cxc_id_con'    =>  $con_id,
                                                'cxc_id_cor'    =>  $cor_id
                                                )))
                    {
                    die('Correo Guardado'); 
                    }
                else
                    {   
                    die('Error: No puedo guardarse la relación del contacto con el correo');
                    } 
                }
            else
                {   
                die('Error: No puedo guardarse el correo');
                }
            }
        $data = array('con_id' => $id = $this->input->post('valor'));
        $this->load->view('inventario/registro_proveedor/correo_add_contacto',$data);
        }

    function agregar_correo()
        {
        if($prv_id = $this->input->post('prv_id'))
            {
            if($val = $this->db->insert('cor_correo',array(
                                                'cor_correo'    =>  $this->input->post('cor_correo'),
                                                'cor_nombre'    =>  $this->input->post('cor_nombre')
                                                )))
                {
                $cor_id=mysql_insert_id();
                if($val = $this->db->insert('cxp_correoxproveedor',array(
                                                'cxp_id_prv'    =>  $prv_id,
                                                'cxp_id_cor'    =>  $cor_id
                                                )))
                    {
                    die('Correo Guardado'); 
                    }
                else
                    {   
                    die('Error: No puedo guardarse la relación del proveedor con el correo');
                    } 
                }
            else
                {   
                die('Error: No puedo guardarse el correo');
                }
            }
        $data = array('prv_id' => $id = $this->input->post('valor'));
        $this->load->view('inventario/registro_proveedor/correo_add_proveedor',$data);
        }

    function buscar_contacto($primary_key)
        {
        return site_url('../inventario/registro_proveedor/ver_contacto/'.$primary_key);
        }

    public function ver_contacto($id)
        {
        $objeto_crud = new grocery_CRUD;
        $objeto_crud->set_table('con_contacto');
        $objeto_crud->set_relation('con_id_prv','prv_proveedor','prv_nombre');
        $objeto_crud->add_fields('con_id_prv','con_nombre','con_puesto');
        $objeto_crud->columns('con_nombre','con_puesto');
        $objeto_crud->display_as('con_id_prv','Nombre del proveedor');
        $objeto_crud->display_as('con_nombre','Nombre del contacto');
        $objeto_crud->display_as('con_puesto','Puesto');
        
        $objeto_crud->set_rules('con_id_prv','Nombre del proveedor','required||integer');
        $objeto_crud->set_rules('con_nombre','Nombre del contacto','required');
        $objeto_crud->set_rules('con_puesto','Puesto','required');

        $objeto_crud->add_action('Agregar Teléfono', base_url() . 'media/imagenes/sistema/mtel.png','','tel_add',function($primary_key){return $primary_key;});
        $objeto_crud->add_action('Ver Teléfonos',  base_url() . 'media/imagenes/sistema/tel.png', '','tel_ver',function($primary_key){return $primary_key;});
        $objeto_crud->add_action('Agregar Correo', base_url() . 'media/imagenes/sistema/memail.png','','cor_add',function($primary_key){return $primary_key;});
        $objeto_crud->add_action('Ver Correos',  base_url() . 'media/imagenes/sistema/email.png', '','cor_ver',function($primary_key){return $primary_key;});

        $objeto_crud->unset_add(); 
        $objeto_crud->where('con_id_prv', $id);
        $output = $objeto_crud->render();
        $this->_cargarvista(null,$output);
        }

    function buscar_telefono($primary_key)
        {
        return site_url('../inventario/registro_proveedor/ver_telefono/'.$primary_key);
        }

    public function ver_telefono($id)
        {
        $objeto_crud = new grocery_CRUD;
        $objeto_crud->set_table('tel_telefono');
        $objeto_crud->set_relation('tel_id','txp_telefonoxproveedor','txp_id_tel');
        $objeto_crud->display_as('tel_telefono','Telefono');
        $objeto_crud->display_as('tel_nombre','Ubicación');
        
        $objeto_crud->set_rules('tel_telefono','Número de teléfono','required');
        $objeto_crud->set_rules('tel_nombre','Ubicación','required');

        $objeto_crud->unset_add(); 
        $objeto_crud->unset_delete(); 
        $objeto_crud->where('txp_id_prv', $id);
        $output = $objeto_crud->render();
        $this->_cargarvista(null,$output);
        }

    public function ver_telefono2()
        {
        $data['datos']= $this->inventario_model->ver_telefono($this->input->post('valor'));   
        $this->load->view('inventario/registro_proveedor/telefono_ver_contacto',$data);
        }

    public function ver_correo2()
        {
        $data['datos']=$this->inventario_model->ver_correo($this->input->post('valor'));   
        $this->load->view('inventario/registro_proveedor/correo_ver_contacto',$data);
        }

    function buscar_correo($primary_key)
        {
        return site_url('../inventario/registro_proveedor/ver_correo/'.$primary_key);
        }

    public function ver_correo($id)
        {
        $objeto_crud = new grocery_CRUD;
        $objeto_crud->set_table('cor_correo');
        $objeto_crud->set_relation('cor_id','cxp_correoxproveedor','cxp_id_cor');
        $objeto_crud->display_as('cor_correo','Correo');
        $objeto_crud->display_as('cor_nombre','Nombre');
        
        $objeto_crud->set_rules('cor_correo','Correo','required');
        $objeto_crud->set_rules('cor_nombre','Nombre','required');

        $objeto_crud->unset_add(); 
        $objeto_crud->where('cxp_id_prv', $id);
        $output = $objeto_crud->render();
        $this->_cargarvista(null,$output);
        }

    function _cargarvista($data=0,$crud=0)
    	{	
    		$this->load->view('vacia',$crud);	
    		if($data!=0)
    			$data=array_merge($data,$this->masterpage->getUsuario());
    		else
    			$data=$this->masterpage->getUsuario();
    		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
    		$this->masterpage->setMasterPage('masterpage_default');
    		$this->masterpage->addContentPage($vista, 'content',$data);
    		$this->masterpage->show();
    	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */