<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimiento extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->database();
        $this->load->helper('url');
        $this->load->model('gsatelite');
        $this->load->model('consultas');
        $this->load->model('inventario_model');
        $this->load->model('expediente_personal_model');
        $this->load->library('grocery_CRUD');
        $this->load->dbutil();
    }

    public function tipo_proceso() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //print_r($_POST);die();
                $nombre             = $this->input->post('nombre');
                $descripcion        = $this->input->post('descripcion');
                $estado             = $this->input->post('estado');  // En la insercion norrmal no se esta ocupando, seguir proceso para ver si se ocupa despues.
                $tipo_proceso       = $this->input->post('tipo');
                $entrada_proceso    = $this->input->post('entrada2');
                $salida_proceso     = $this->input->post('salida2');
                //print_r($tipo_proceso); die();
                // Datos de la Ficha de Finanzas
                $centro_costo_cec   = $this->input->post('centro_costo_cec');
                $tipo_cuenta_tcn    = $this->input->post('tipo_cuenta_tcn');
                //$cuenta_contable_cnt= $this->input->post('cuenta_contable_cnt');
                $bodega             = $this->input->post('bodega');

                $insert_tipo_proceso = array(
                    'tip_nombre'        => $nombre,
                    'tip_descripcion'   => $descripcion,
                    'tip_estado'        => 1,
                    'tip_usr_mod'       => $this->tank_auth->get_user_id(),
                    'tip_fecha_mod'     => date('Y-m-d H-i-s')
                );

                $entrada = ($entrada_proceso > 0) ? $entrada_proceso : null;
                $salida = ($salida_proceso > 0) ? $salida_proceso : null;

                switch ($tipo_proceso) {
                    case '1':
                        $merge = array(// entrada
                            'tip_entrada'   => 1,
                            'tip_salida'    => 0,
                            'tip_traslado'  => 0,
                            'tip_ajuste'    => 0,
                            'tip_id_tip_entrada'    => $entrada,
                            'tip_id_tip_salida'     => null,
                            'tip_facturacion'       => 0
                        );
                        break;
                    case '2':
                        $merge = array(// Salida
                            'tip_entrada'       => 0,
                            'tip_salida'        => 1,
                            'tip_traslado'      => 0,
                            'tip_ajuste'        => 0,
                            'tip_id_tip_entrada'=> null,
                            'tip_id_tip_salida' => $salida,
                            'tip_facturacion'   => 0
                        );
                        break;
                    case '3':               // Traslado
                        $merge = array(
                            'tip_entrada'       => 0,
                            'tip_salida'        => 0,
                            'tip_traslado'      => 1,
                            'tip_id_tip_entrada'=> $entrada,
                            'tip_id_tip_salida' => $salida,
                            'tip_ajuste'        => 0,
                            'tip_facturacion'   => 0
                        );
                        break;
                    case '4':           // Ajuste
                        $tip_entrada_ajuste = 0;
                        $tip_salida_ajuste = 0;
                        if($entrada > 0)
                            $tip_entrada_ajuste=1;
                        if($salida > 0)
                            $tip_salida_ajuste=1;
                        $merge = array(
                            'tip_entrada'       => $tip_entrada_ajuste,
                            'tip_salida'        => $tip_salida_ajuste,
                            'tip_traslado'      => 0,
                            'tip_id_tip_entrada'=> $entrada,
                            'tip_id_tip_salida' => $salida,
                            'tip_ajuste'        => 1,
                            'tip_facturacion'   => 0
                        );
                        break;

                    case '5':            // Facturacion
                        $tip_entrada_ajuste = 0;
                        $tip_salida_ajuste = 0;

                        if($entrada > 0)
                            $tip_entrada_ajuste=1;
                        if($salida > 0)
                            $tip_salida_ajuste=1;

                        $merge = array(
                            'tip_entrada'       => $tip_entrada_ajuste,
                            'tip_salida'        => $tip_salida_ajuste,
                            'tip_traslado'      => 0,
                            'tip_id_tip_entrada'=> $entrada,
                            'tip_id_tip_salida' => $salida,
                            'tip_ajuste'        => 0,
                            'tip_facturacion'   => 1
                        );
                        break;
                    default:
                        # code...
                        break;
                }

                //print_r(array());
                $insert = array();
                $insert = array_merge($insert_tipo_proceso, $merge);                
                $registro = $this->gsatelite->ingresar('tip_tipo_proceso', $insert);

                // Ficha Finanzas
                for ($x = 0; $x < count($centro_costo_cec); $x++) {
                    if (trim($centro_costo_cec[$x]) != "" && trim($tipo_cuenta_tcn[$x]) != "") {
                        $datos = array(
                            'ctp_id_cec' => $centro_costo_cec[$x],
                            'ctp_id_cnt' => null,
                            'ctp_id_tcn' => $tipo_cuenta_tcn[$x],
                            'ctp_id_tip' => $registro,
                            'ctp_id_bod' => ($bodega[$x] != "")?$bodega[$x]:null,
                            'ctp_estado' => 1,
                            'ctp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'ctp_fecha_modificacion'    => date('Y-m-d H:i:s'),
                            'ctp_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'ctp_fecha_creacion'        => date('Y-m-d H:i:s')
                        );

                        $reg_detalle = $this->gsatelite->ingresar('ctp_cuenta_tipo_proceso', $datos);
                    }
                }

                if ($registro > 0 ) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
                }

                $this->session->set_flashdata($alerta);
                $redireccion = $this->input->post('btn_enviar');
                if ($redireccion == 1) {
                    redirect('inventario/mantenimiento/tipo_proceso');
                } elseif ($redireccion == 2) {
                    redirect('inventario/mantenimiento/index_procesos');
                }

            
            } else {
                // Mandar lista de entrada o salida por facturacion
                $data['procesos'] = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1));

                /* ************************************** Tab Finanzas ************************************** */
                //centro de costo
                $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
                $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //tipo de cuenta
                $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
                $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //cuenta contable
                //$select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
                //$data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //Bodega
                $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
                $data["bodega"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                /* ******************************************************************************************* */

                $data["titulo_personal"] = "Tipos de procesos";
                $this->_cargarvista($data);
            }
        }
    }

    public function tipo_proceso_edit($proceso) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // print_r($_POST);die();
                $nombre     = $this->input->post('nombre');
                $descripcion= $this->input->post('descripcion');
                $estado     = $this->input->post('estado');
                $tipo_proceso   = $this->input->post('tipo');
                $tipo_traslado  = $this->input->post('tipo_traslado');
                $entrada_proceso= $this->input->post('entrada2');
                $salida_proceso = $this->input->post('salida2');
                $txtAutoriza = $this->input->post('txtAutoriza');

                /* ****** Finanzas ****** */
                $centro_costo_cec   = $this->input->post('centro_costo_cec');
                $tipo_cuenta_tcn    = $this->input->post('tipo_cuenta_tcn');
                //$cuenta_contable_cnt= $this->input->post('cuenta_contable_cnt');
                $bodega             = $this->input->post('bodega');

                $insert_tipo_proceso = array(
                    'tip_nombre'        => $nombre,
                    'tip_descripcion'   => $descripcion,
                    'tip_estado'        => $estado,
                    'tip_aplica_autorizacion' => $txtAutoriza,
                    'tip_usr_mod'       => $this->tank_auth->get_user_id(),
                    'tip_fecha_mod'     => date('Y-m-d H-i-s'));

                $entrada = ($entrada_proceso > 0) ? $entrada_proceso : null;
                $salida = ($salida_proceso > 0) ? $salida_proceso : null;

                switch ($tipo_proceso) {
                    case '1':
                        $merge = array(// entrada
                            'tip_entrada'   => 1,
                            'tip_salida'    => 0,
                            'tip_traslado'  => 0,
                            'tip_ajuste'    => 0,
                            'tip_id_tip_entrada'    => $entrada,
                            'tip_id_tip_salida'     => null,
                            'tip_facturacion'       => 0
                        );
                        break;
                    case '2':
                        $merge = array(// Salida
                            'tip_entrada'   => 0,
                            'tip_salida'    => 1,
                            'tip_traslado'  => 0,
                            'tip_ajuste'    => 0,
                            'tip_id_tip_entrada'    => null,
                            'tip_id_tip_salida'     => $salida,
                            'tip_facturacion'       => 0
                        );
                        break;

                    case '3':               // Traslado
                        $merge = array(
                            'tip_entrada'       => 0,
                            'tip_salida'        => 0,
                            'tip_traslado'      => 1,
                            'tip_id_tip_entrada'=> $entrada,
                            'tip_id_tip_salida' => $salida,
                            'tip_ajuste'        => 0,
                            'tip_facturacion'   => 0
                        );
                        break;

                    case '4':           // Ajuste
                    $tip_entrada_ajuste = 0;
                    $tip_salida_ajuste = 0;

                    if($entrada > 0)
                        $tip_entrada_ajuste=1;
                    if($salida > 0)
                        $tip_salida_ajuste=1;

                    $merge = array(
                        'tip_entrada'       => $tip_entrada_ajuste,
                        'tip_salida'        => $tip_salida_ajuste,
                        'tip_traslado'      => 0,
                        'tip_id_tip_entrada'=> $entrada,
                        'tip_id_tip_salida' => $salida,
                        'tip_ajuste'        => 1,
                        'tip_facturacion'   => 0
                    );
                    break;

                    case '5':            // Facturacion
                    $tip_entrada_ajuste = 0;
                    $tip_salida_ajuste = 0;

                    if($entrada > 0)
                        $tip_entrada_ajuste=1;
                    if($salida > 0)
                        $tip_salida_ajuste=1;

                        $merge = array(
                            'tip_entrada'       => $tip_entrada_ajuste,
                            'tip_salida'        => $tip_salida_ajuste,
                            'tip_traslado'      => 0,
                            'tip_id_tip_entrada'=> $entrada,
                            'tip_id_tip_salida' => $salida,
                            'tip_ajuste'        => 0,
                            'tip_facturacion'   => 1
                        );
                        break;
                    default:
                        # code...
                        break;
                }

                $insert = array();
                $insert = array_merge($insert_tipo_proceso, $merge);
                $this->db->where('tip_id', $proceso);
                $registro = $this->db->update('tip_tipo_proceso', $insert);

                /* ************ Ficha de Finanzas *************** */
                //Se eliminan las cuentas asociadas
                $this->gsatelite->borrado_general('ctp_cuenta_tipo_proceso', array('ctp_id_tip' => $proceso));

                for ($x = 0; $x < count($centro_costo_cec); $x++) {
                    if (trim($centro_costo_cec[$x]) != "" && trim($tipo_cuenta_tcn[$x]) != "") {
                        $datos = array(
                            'ctp_id_cec' => $centro_costo_cec[$x],
                            'ctp_id_cnt' => null,
                            'ctp_id_tcn' => $tipo_cuenta_tcn[$x],
                            'ctp_id_tip' => $proceso,
                            'ctp_id_bod' => ($bodega[$x] != "")?$bodega[$x]:null,
                            'ctp_estado' => 1,
                            'ctp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'ctp_fecha_modificacion'    => date('Y-m-d H:i:s'),
                            'ctp_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'ctp_fecha_creacion'        => date('Y-m-d H:i:s')
                        );
                        //print_r($datos); die();
                        $reg_detalle = $this->gsatelite->ingresar('ctp_cuenta_tipo_proceso', $datos);
                    }
                }

                        
                if ($registro > 0 && $reg_detalle > 0) {
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha modificado correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser modificado, verifique la informacion ingresada.");
                }
                $this->session->set_flashdata($alerta);

                $redireccion = $this->input->post('btn_enviar');
                if ($redireccion == 1) {
                    redirect('inventario/mantenimiento/tipo_proceso_edit/' . $proceso);
                } elseif ($redireccion == 2) {
                    redirect('inventario/mantenimiento/index_procesos');
                }
            } else {
                /* ********************************* Tab Finanzas ********************************* */
                // Obtener los datos
                $data['finanzas'] = $this->inventario_model->get_cuenta_tipo_proceso(array('ctp_id_tip' => $proceso));
                //centro de costo
                $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
                $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //tipo de cuenta
                $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
                $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //cuenta contable
                //$select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
                //$data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                //Bodega
                $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
                $data["bodega"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                /* ********************************************************************************** */
                $data["titulo_personal"] = "Tipos de procesos";
                $data['proceso'] = $this->db->get_where('tip_tipo_proceso', array('tip_id' => $proceso))->row_array();
                $data['proceso_hijo'] = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1));
                $this->_cargarvista($data);
            }
        }
    }

    public function entradas() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $id = $this->input->post('valor');
                $data['proceso_padre'] = $this->gsatelite->get_registro('tip_tipo_proceso', array('tip_id' => $id, 'tip_estado' => 1));
                $data['proceso_hijo'] = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1));
                $salida = $this->load->view('inventario/mantenimiento/procesos', $data, true);
                //echo "<option>'".$data['proceso_padre']->tip_nombre."'</option>";
                echo $salida;
            }
        }
    }

    public function entradas2() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1, 'tip_entrada' =>  1));//,'tip_id_tip_entrada IS NOT NULL' => null
            // $data['proceso_hijo'] = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1));
            // $salida = $this->load->view('inventario/mantenimiento/procesos', $data, true);
            $option= '<option value=""></option>';
            foreach($data as $fila){
                $option.="<option class='salida' value=".$fila['tip_id'].">".$fila['tip_nombre']."</option>";
            }
            echo $option;
        }
    }

    public function salidas2() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1, 'tip_salida' => 1));//,'tip_id_tip_salida is not null'=>null
            // $data['proceso_hijo'] = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1));
            // $salida = $this->load->view('inventario/mantenimiento/procesos', $data, true);
            $option= '<option value=""></option>';
            foreach($data as $fila){
                $option.="<option class='salida' value=".$fila['tip_id'].">".$fila['tip_nombre']."</option>";
            }
            echo $option;
        }
    }

    public function index_procesos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/index_procesos');
            $data['procesos'] = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1));
            $data['titulo_personal'] = "Tipos de procesos";
            $this->_cargarvista($data);
        }
    }

    public function hacer_respaldo() {

        $nombre = "C:\\respaldos\\backup_" . date('Y-m-d-H-i-s') . "";
        system("mysqldump --opt -h192.168.1.56 -udesarrollo3 -pdesarrollo3 --databases erpsatelite -r >$nombre.sql");


        //$this->_cargarvista();
    }

    public function verificar_codigo() {
        $codigo = $this->input->post('codigo');
        $esteId = $this->input->post('id_edit');
        //QUITAR ESPACIOS Y CARACTERES QUE PUEDAN HABER QUEDADO, AGREGAR LAS QUE FALTEN
        $codigo = str_replace(array(' ','%','$','&','@','#','^','\'','"'), '', $codigo);
        $existe = $this->inventario_model->verificar_codigo($codigo, $esteId);
        $arreglo = array('drop' => count($existe));
        echo json_encode($arreglo);
    }

    public function verificar_codigo_edit() {
        $codigo = $this->input->post('codigo');
        $articulo = $this->input->post('articulo');
        $existe = $this->db->where(array('art_codigo' => $codigo, 'art_id <>' => $articulo))->get('art_articulo')->result_array();
        //print_r(count($existe));
        $arreglo = array('drop' => count($existe));
        //$arreglo=array('drop'=>0); //quitar la validación para ylufa

        echo json_encode($arreglo);
    }

    function backup_tables($host, $user, $pass, $name, $tables = '*') {
        $return = "";
        $link = mysql_connect($host, $user, $pass);
        mysql_select_db($name, $link);

        //get all of the tables
        if ($tables == '*') {
            $tables = array();
            $result = mysql_query('SHOW TABLES');
            while ($row = mysql_fetch_row($result)) {
                $tables[] = $row[0];
            }
        } else {
            $tables = is_array($tables) ? $tables : explode(',', $tables);
        }

        //cycle through

        foreach ($tables as $table) {
            $result = mysql_query('SELECT * FROM ' . $table);
            $num_fields = mysql_num_fields($result);

            $return .= 'DROP TABLE ' . $table . ';';
            $row2 = mysql_fetch_row(mysql_query('SHOW CREATE TABLE ' . $table));
            $return .= "\n\n" . $row2[1] . ";\n\n";

            for ($i = 0; $i < $num_fields; $i++) {
                while ($row = mysql_fetch_row($result)) {
                    $return .= 'INSERT INTO ' . $table . ' VALUES(';
                    for ($j = 0; $j < $num_fields; $j++) {
                        $row[$j] = addslashes($row[$j]);
                        //$row[$j] = preg_match("\n","\\n",$row[$j]);
                        //$row[$j] =preg_replace('/[^A-Za-z0-9_]/', '',$row[$j]);
                        $row[$j] = preg_replace('/\n/', '/\\n/', $row[$j]);
                        if (isset($row[$j])) {
                            $return .= '"' . $row[$j] . '"';
                        } else {
                            $return .= '""';
                        }
                        if ($j < ($num_fields - 1)) {
                            $return .= ',';
                        }
                    }
                    $return .= ");\n";
                }
            }
            $return .= "\n\n\n";
        }

        //save file
        $handle = fopen('db-backup-' . date('Y-m-d-H-i-s') . '.sql', 'w+');
        fwrite($handle, $return);
        fclose($handle);
    }

    public function new_crud() {
        $db_driver = $this->db->platform();
        $model_name = 'grocery_crud_model_' . $db_driver;
        $model_alias = 'm' . substr(md5(rand()), 0, rand(4, 15));

        unset($this->{$model_name});
        $this->load->library('grocery_CRUD');
        $crud = new Grocery_CRUD();
        if (file_exists(APPPATH . '/models/' . $model_name . '.php')) {
            $this->load->model('grocery_crud_generic_model');
            $this->load->model($model_name, $model_alias);
            $crud->basic_model = $this->{$model_alias};
        }
        return $crud;
    }
    /**
     *Descripcion:
     *Mantemiento para registrar politicas de devolucinn
     *@author: Nelson Soroiano
     *@since:  19-12-2018
     *@param:  none
     *@return: Grocery para dar mantenimiento a politicas de devolucion
    **/

    public function politicas_devolucion(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud       = new Grocery_CRUD();
        $required   = array(
                        'pld_nombre',
                    );
        $add        = array(
                        'pld_nombre',
                        'pld_descripcion',
                        'pld_estado',
                        'pld_usu_creacion',
                        'pld_fecha_creacion',
                        'pld_usu_modificacion',
                        'pld_fecha_modificacion'
                   );
        $alias     = array(
                        'pld_nombre'      => 'Nombre',
                        'pld_descripcion' => 'Descripcion',
                        'pld_estado'      => 'Estado'
                   );
        $columns   = array(
                        'pld_nombre',
                        'pld_descripcion',
                        'pld_estado'
                   );
        $edit      = array(
                        'pld_nombre',
                        'pld_descripcion',
                        'pld_estado'
                    );

        $crud->set_table('pld_politica_devolucion')
             //->set_subject('Politicas de Devolucion')
             ->set_subject('')
             ->columns($columns)
             ->add_fields($add)
             ->edit_fields($edit)
             ->display_as($alias)
             ->required_fields($required)
             ->field_type('pld_usu_modificacion','hidden',$this->tank_auth->get_user_id())
             ->field_type('pld_fecha_modificacion','hidden',date('Y-m-d H:i:s'))
            ;


        $uri_segments = explode('/', uri_string()); 
        if (end($uri_segments) == 'add') {
            $crud->field_type('pld_estado','hidden',1)
                 ->field_type('pld_usu_creacion','hidden',$this->tank_auth->get_user_id())
                 ->field_type('pld_fecha_creacion','hidden',date('Y-m-d H:i:s'));

        }else{
             $crud->field_type('pld_estado','dropdown',array('1' => 'Activo', '0' => 'Inactivo'))
                 ->field_type('pld_usua_modificacion','hidden',$this->tank_auth->get_user_id())
                 ->field_type('pld_fecha_modificacion','hidden',date('Y-m-d H:i:s'));
        }

        if(!$permisos['permite_agregar']){
            $crud->unset_add();
        }

        if(!$permisos['permite_editar']){
            $crud->unset_edit();
        }

        if(!$permisos['permite_eliminar']){
            $crud->unset_delete();
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Politicas de Devolucion';
        $this->_cargarvista($data, $output);
    }

    function descargar_imagenes() {
        $data['listado_productos'] = $this->inventario_model->productos_imagenes();
        $titulo['titulo_personal'] = 'Descarga de imágenes';
        $this->_cargarvista($titulo, $data);
    }

    function descarga() {
        $this->load->library('zip');
        $folder = FCPATH . 'assets/uploads/images/';

        foreach ($_POST as $nombre_campo => $valor) {
            $nombre_campo_segments = explode('_', $nombre_campo);
            $extension = end($nombre_campo_segments);
            $img = str_replace("_" . $extension, "." . $extension, $nombre_campo);
            $ruta = $folder . $img;
            //$ruta_imagen = str_replace('/', '\\', $ruta);
            $ruta_imagen = $ruta;
            //echo $ruta_imagen.'<p>';
            $this->zip->read_file($ruta_imagen);
            //$this->zip->add_data($img,$ruta_imagen);
        }
        $this->zip->archive($folder . 'imagenes.zip');
        redirect(base_url() . 'assets/uploads/images/imagenes.zip');
    }

    public function empleado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $crud = $this->new_crud();
            //Columnas a mostrar en READ
            $columns = array(
                'emp_id_suc',
                'emp_id_are',
                'emp_codigo',
                'emp_nombre',
                'emp_apellido',
            );

            //Alias para las columnas
            $alias = array(
                'emp_id_plz' => 'Plaza',
                'emp_id_are' => 'Área',
                'emp_codigo' => 'Código',
                'emp_nombre' => 'Nombres',
                'emp_apellido' => 'Apellidos',
                'emp_estado' => 'Estado',
                'emp_direccion' => 'Dirección',
                'emp_telefono' => 'Teléfono',
                'emp_lugar_nac' => 'Lugar de nacimiento',
                'emp_fecha_nac' => 'Fecha d nacimiento',
                'emp_id_gen' => 'Sexo',
                'emp_id_pro' => 'Profesión',
                'emp_id_esc' => 'Estado civil',
                'emp_fecha_ingreso' => 'Fecha de ingreso',
                'emp_fecha_retiro' => 'Fecha de retiro',
                'emp_salario' => 'Salario',
                // 'emp_id_usu' => 'Usuario de sistema',
                'emp_id_suc' => 'Sucursal',
                'emp_contacto_emergencia' => 'Contacto de Emergencia',
                'emp_id_pat_contacto' => 'Parentesco del contacto'
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
                'emp_id_plz',
                'emp_id_are',
                'emp_codigo',
                'emp_nombre',
                'emp_apellido',
                'emp_direccion',
                'emp_estado',
                'emp_id_suc',
                'emp_telefono',
                'emp_lugar_nac',
                'emp_usu_mod',
                'emp_id_gen',
                'emp_id_pro',
                'emp_id_esc',
                'emp_salario',
                'emp_contacto_emergencia',
                'emp_id_pat_contacto',
                'emp_fecha_mod',
                'emp_usu_crea',
                'emp_fecha_crea'
                    //'emp_id_usu',
            );

            //Columnas a mostrar en EDIT
            $edit_columns = array(
                'emp_id_plz',
                'emp_id_are',
                'emp_codigo',
                'emp_nombre',
                'emp_apellido',
                'emp_direccion',
                'emp_estado',
                'emp_telefono',
                'emp_lugar_nac',
                'emp_id_gen',
                'emp_id_pro',
                'emp_id_esc',
                'emp_id_suc',
                'emp_usu_mod',
                'emp_fecha_mod',
                'emp_salario',
            );

            $required_fields = array(
                'emp_nombre',
                'emp_apellido',
                'emp_id_suc',
                'emp_codigo',
                'emp_estado'
            );
            $empleado = explode('/', uri_string());
            $empleado = $empleado[count($empleado) - 1];
            if (is_numeric($empleado)) {
                $usu_empleado = $this->db->select('emp_id_usu')->from('emp_empleado')->where('emp_id', $empleado)->get()->result_array();
            }
            $resultado = $this->db->select('emp_id_usu')->from('emp_empleado')->get()->result_array();

            $cadena_in = '';
            if (isset($usu_empleado[0]['emp_id_usu'])) {
                foreach ($resultado as $key) {
                    if (isset($key['emp_id_usu']) && $key['emp_id_usu'] != $usu_empleado[0]['emp_id_usu']) {
                        $cadena_in .= $key['emp_id_usu'] . ',';
                    }
                }
            } else {
                foreach ($resultado as $key) {
                    if (isset($key['emp_id_usu'])) {
                        $cadena_in .= $key['emp_id_usu'] . ',';
                    }
                }
            }
            $final = substr($cadena_in, 0, -1);
            if (strlen($final) <= 0) {
                $final = 0;
            }
            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza();//TODAS LAS PLAZAS QUE YA ESTEN ASIGNADAS PARA HACER UN NOT-IN
            $ids_string = (count($arreglo_ids) > 0) ? implode(",", $arreglo_ids) : "0";

            $crud->set_table('emp_empleado')
                    ->set_subject('Empleada/o')
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($required_fields)
                    //->set_rules('emp_telefono','Telefono','exact_length[9]')
                    //->set_rules('emp_telefono','Telefono','exact_length[9]')
                    ->set_relation('emp_id_plz', 'plz_plaza', 'plz_nombre', array("plz_estado" => 1, "plz_id NOT IN ($ids_string)" => null))
                    ->set_relation('emp_id_are', 'are_area', 'are_nombre', array('are_estado' => 1))
                    ->set_relation('emp_id_pro', 'pro_profesion', 'pro_nombre', array('pro_estado' => 1))
                    ->set_relation('emp_id_esc', 'esc_estado_civil', 'esc_nombre', array('esc_estado' => 1))
                    ->set_relation('emp_id_suc', 'suc_sucursal', 'suc_nombre')
                    ->set_relation('emp_id_pat_contacto', 'pat_parentesco', 'pat_nombre')
                    // ->set_relation('emp_id_usu', 'users', 'username',"id not in ({$final})")
                    /************************* Campos de Auditoria *****************************/
                    ->field_type('emp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('emp_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('emp_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('emp_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    /****************************************************************************/
                    ->set_rules('emp_codigo', 'Código', 'callback_username_check_insert9|required')
                    ->set_rules('emp_salario', 'Salario', 'is_numeric')

                    //  ->field_type('emp_estado', 'dropdown', array("1" => "ACTIVO", "0" => "INACTIVO"))
                    ->set_relation('emp_id_gen', 'gen_genero', 'gen_nombre', array("gen_estado" => 1))
                    ->unset_delete();
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('emp_estado', 'hidden', 1);
            } else {
                $crud->field_type('emp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Empleadas/os";
            $this->_cargarvista($data, $output);
        }
    }

    public function username_check_insert9($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("emp_id", $id)->get('emp_empleado')->row()->bod_nombre;
            $num_row = $this->db->where('emp_codigo', $str)->where('emp_id !=', $id)->get('emp_empleado')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert9', 'El código para el empleado ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('emp_codigo', $str)->get('emp_empleado')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert9', 'El código para el empleado ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function index() {

        $this->_cargarvista();
    }

    public function sucursal() {
        satelite_validar();
        try {

            $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/sucursal');

            $crud = $this->new_crud();

            //Columnas a mostrar en READ
            $columns = array(
                'suc_codigo',
                'suc_nombre',
                'suc_id_mun',
                'suc_direccion'
            );

            //Alias para las columnas
            $alias = array(
                //'suc_id_zon' => 'Zona',
                'suc_id_mun' => 'Ubicación',
                'suc_codigo' => 'Código',
                'suc_nombre' => 'Sucursal',
                'suc_direccion' => 'Dirección'
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
                //'suc_id_zon',
                'suc_id_mun',
                'suc_codigo',
                'suc_nombre',
                'suc_direccion',
                'suc_usu_mod',
                'suc_fecha_mod'
            );

            //Columnas a mostrar en EDIT
            $edit_columns = array(
                'suc_id_mun',
                'suc_codigo',
                'suc_nombre',
                'suc_direccion',
                'suc_usu_mod',
                'suc_fecha_mod'
            );

            $require_columns = array(
                'suc_codigo',
                'suc_nombre',
                'suc_usu_mod',
                'suc_fecha_mod'
            );

            $crud->set_table('suc_sucursal')
                    ->set_subject('Sucursal')
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($require_columns)
                    ->field_type('suc_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('suc_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->set_rules('suc_nombre', 'Nombre', 'callback_username_check_insert')
                    ->set_rules('suc_codigo', 'Nombre', 'callback_username_check_insert_suc_codigo')

                    //->set_relation('suc_id_zon', 'zon_zona_regional', 'zon_nombre')
                    ->set_relation('suc_id_mun', 'mun_municipio', 'mun_nombre');
            $crud->set_rules('suc_nombre', 'Nombre Sucursal', 'required');
            $crud->set_rules('suc_codigo', 'Código Sucursal', 'campo_unico[suc_sucursal.suc_codigo]|required');

            // if(end(explode('/',uri_string()))=='add') {
            //     $crud->field_type('suc_estado','hidden',1);
            //   }
            //   else {
            //     $crud->field_type('suc_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            //   }
            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'inventario/mantenimiento/sucursal/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de sucursales";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function username_check_insert($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("suc_id", $id)->get('suc_sucursal')->row()->suc_nombre;
            $num_row = $this->db->where('suc_nombre', $str)->where('suc_id !=', $id)->get('suc_sucursal')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert', 'El nombre de la sucursal ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('suc_nombre', $str)->get('suc_sucursal')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert', 'El nombre de la sucursal ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function username_check_insert_suc_codigo($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("suc_id", $id)->get('suc_sucursal')->row()->suc_nombre;
            $num_row = $this->db->where('suc_codigo', $str)->where('suc_id !=', $id)->get('suc_sucursal')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert_suc_codigo', 'El código de la sucursal ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('suc_codigo', $str)->get('suc_sucursal')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert_suc_codigo', 'El código de la sucursal ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function bodega() {
        satelite_validar();
        try {
            $usa_sectores = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/bodega');
            $crud = $this->new_crud();

            //Columnas a mostrar en READ
            $columns = array(
                'bod_id_suc',
                'bod_nombre',
                'bod_ubicacion',
                'bod_estado'
            );

            //Alias para las columnas
            $alias = array(
                'bod_id_suc'    => 'Sucursal',
                'bod_nombre'    => 'Nombre Bodega',
                'bod_estado'    => 'Estado',
                'bod_ubicacion' => 'Ubicación',
                'bod_tipo_bodega' => 'Tipo bodega',
                'usuarios'      => 'Usuarios'
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
                'bod_id_suc',
                'bod_nombre',
                'bod_estado',
                'bod_ubicacion',
                'bod_usu_creacion',
                'bod_fecha_creacion',
                'bod_usu_modificacion',
                'bod_fecha_modificacion',
                'usuarios'
            );

            //Columnas a mostrar en EDIT
            $edit_columns = array(
                'bod_id_suc',
                'bod_nombre',
                'bod_estado',
                'bod_ubicacion',
                'bod_usu_modificacion',
                'bod_fecha_modificacion',
                'usuarios'
            );

            //Columnas requeridas
            $requeridas = array(
                'bod_id_suc',
                'bod_nombre',
                'bod_estado',
                'bod_fecha_mod'
            );

            $adult_array_user = array('uxb_defecto' => 0, 'uxb_usu_mod' => $this->tank_auth->get_user_id(), 'uxb_fecha_mod' => date('Y-m-d H:i:s'));

            $crud->set_table('bod_bodega')
                    ->set_subject('Bodega')
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($requeridas)
                    //->set_relation('bod_tipo_bodega','pra_proposito_articulo','pra_nombre')
                    ->field_type('bod_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('bod_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('bod_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('bod_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->set_relation('bod_id_suc', 'suc_sucursal', 'suc_nombre')
                    ->set_rules('bod_nombre', 'Nombre', 'callback_username_check_insert3|required')
                    ->set_relation_n_n('usuarios', 'uxb_usuarioxbodega', 'users', 'uxb_id_bod', 'uxb_id_usu', 'username', null, null, $adult_array_user);
                    // ->callback_column('usuarios')
            ;

            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('bod_estado', 'hidden', 1);
            } else {
                $crud->field_type('bod_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->unset_read();
            }
            if ($usa_sectores > 0) {
                $crud->add_action('&nbsp;Sectores', '', 'inventario/mantenimiento/sectorxbodega', 'icomoon-icon-stack');
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Catálogo de bodegas";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function get_sector_grid($value, $row) {
        $bod_id = $row->bod_id;
        $sector = $this->inventario_model->get_sector_grid($bod_id);
        $sectors = "";
        foreach ($sector as $key) {
            $sectors .= $key["seb_nombre"] . ", ";
        }
        $sectors = substr(trim($sectors), 0, -1);
        return $sectors;
    }

    public function actualizar_sxb($value, $row) {
        $cadena = array(
            'sxb_estado' => 1,
            'sxb_usu_creacion' => $this->tank_auth->get_user_id(),
            'sxb_fecha_creacion' => date('Y-m-d H:i:s'),            
            'sxb_usu_modificacion' => $this->tank_auth->get_user_id(),
            'sxb_fecha_modificacion' => date('Y-m-d h:i:s')
        );
        $this->gsatelite->actualizar_array('sxb_sectorxbodega', $cadena, array('sxb_id_bod' => $row));
    }

    public function insert_sxb($value, $row) {
        $cadena = array(
            'sxb_estado' => 1,
            'sxb_usu_creacion' => $this->tank_auth->get_user_id(),
            'sxb_fecha_creacion' => date('Y-m-d H:i:s'),
            'sxb_usu_modificacion' => $this->tank_auth->get_user_id(),
            'sxb_fecha_modificacion' => date('Y-m-d h:i:s')
        );
        $this->gsatelite->actualizar_array('sxb_sectorxbodega', $cadena, array('sxb_id_bod' => $row));
    }

    public function username_check_insert3($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("bod_id", $id)->get('bod_bodega')->row()->bod_nombre;
            $num_row = $this->db->where('bod_nombre', $str)->where('bod_id !=', $id)->get('bod_bodega')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert3', 'El nombre de la bodega ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('bod_nombre', $str)->get('bod_bodega')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert3', 'El nombre de la bodega ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function medida_producto() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $url_array = explode('/', uri_string());
            $crud = $this->new_crud();            
            //Columnas a mostrar en READ
            $columns = array(
                'mep_id',
                'mep_codigo',
                'mep_nombre',
                'mep_estado'
            );
            //Alias para las columnas
            $alias = array(
                'mep_id' => 'Id',
                'mep_nombre' => 'Nombre de la Medida',
                'mep_estado' => 'Estado',
                'mep_codigo' => 'Código'
            );
            //Columnas a mostrar en ADD
            $add_columns = array(
                'mep_nombre',
                'mep_codigo',
                'mep_estado',
                'mep_usu_mod',
                'mep_fecha_mod'
            );
            //Columnas a mostrar en EDIT
            $edit_columns = array(
                'mep_nombre',
                'mep_codigo',
                'mep_estado',
                'mep_usu_mod',
                'mep_fecha_mod'
            );
            $crud->set_table('mep_medida_producto')
                    ->set_subject('Unidad de medida')
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->required_fields($edit_columns)
                    ->field_type('mep_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('mep_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                    ->set_rules('mep_nombre', 'Nombre', 'trim|required|campo_unico[mep_medida_producto.mep_nombre]')
                    ->set_rules('mep_codigo', 'Código', 'trim|required|campo_unico[mep_medida_producto.mep_codigo]')
                    ->edit_fields($edit_columns);
            // $crud->set_rules('mep_nombre','Nombre de la medida','required');
            // $crud->set_rules('mep_codigo','Código','required');
            if (end($url_array) == 'add') {
                $crud->field_type('mep_estado', 'hidden', 1);
            } else {
                $crud->field_type('mep_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Catálogo de unidades de medida";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function username_check_insert2($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("mep_id", $id)->get('mep_medida_producto')->row()->mep_nombre;
            $num_row = $this->db->where('mep_nombre', $str)->where('mep_id !=', $id)->get('mep_medida_producto')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert2', 'El nombre de la medida ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('mep_nombre', $str)->get('mep_medida_producto')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert2', 'El nombre de la medida ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function username_check_insert22($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("mep_id", $id)->get('mep_medida_producto')->row()->mep_codigo;
            $num_row = $this->db->where('mep_codigo', $str)->where('mep_id !=', $id)->get('mep_medida_producto')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert22', 'El Código de la medida ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('mep_codigo', $str)->get('mep_medida_producto')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert22', 'El Código de la medida ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function marca() {
        try {
            $crud = $this->new_crud();
            $columnas = array(
                'mar_nombre',
                'mar_desc'
            );

            $alias = array(
                'mar_nombre' => 'Nombre de marca',
                'mar_desc' => 'Descripcion de marca'
            );

            $columnas_insert = array(
                'mar_nombre',
                'mar_desc'
            );

            $columnas_update = array(
                'mar_nombre',
                'mar_desc'
            );

            $crud->set_table('mar_marca')
                    ->set_subject('Catalogo de marcas')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update);

            $output = $crud->render();
            $this->_cargarvista(null, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function duplicar_articulo($articulo, $ruta_modulo = null) {
        if ($ruta_modulo == 'cotizaciones/mantenimientos') {
            $data['urlx'] = 'cotizaciones/mantenimientos/articulo';
        }
        $ruta = trim($ruta_modulo) != "" ? $ruta_modulo : "inventario/mantenimiento";
        if ($_POST) {
            //select requerido
            $art_id = $this->input->post('articulo_id');
            //tab 1 insertar primero
            $tia_id_tab1 = $this->input->post('categorias'); //select requerido
            $art_codigo_tab1 = $this->input->post('codigo');  //requerido
            $art_codigo_barra_tab1 = (trim($this->input->post('codigo_barra')) != "") ? $this->input->post('codigo_barra') : null;
            $art_nombre_tab1 = $this->input->post('nombre');  //requerido
            $art_sinonimo_tab1 = (trim($this->input->post('sinonimo_art')) != "") ? $this->input->post('sinonimo_art') : null;
            $art_descripcion_tab1 = (trim($this->input->post('descripcion')) != "") ? $this->input->post('descripcion') : null;

            $art_foto_tab1 = (trim($this->input->post('foto_empleado')) != "") ? $this->input->post('foto_empleado') : null;
            $cda_id_tab1 = (trim($this->input->post('codigo_arancelario')) != "") ? $this->input->post('codigo_arancelario') : null;  //select
            $art_tipo_tab1 = (trim($this->input->post('tipo_producto')) != "") ? $this->input->post('tipo_producto') : null; //select
            $art_maximo_tab1 = (trim($this->input->post('maximo')) != "") ? $this->input->post('maximo') : null;
            $art_minimo_tab1 = (trim($this->input->post('minimo')) != "") ? $this->input->post('minimo') : null;
            $precio_sug = ($this->input->post('precio_sug') != '') ? $this->input->post('precio_sug') : null;

            $art_aplica_serie_tab1 = (trim($this->input->post('serie')) != "") ? 1 : 0; //ibutton
            $art_combo_tab1 = (trim($this->input->post('combo')) != "") ? 1 : 0;  //ibutton

            $art_cuota = (trim($this->input->post('cuota')) != "") ? 1 : 0;  //ibutton
            $art_num_cuota = (trim($this->input->post('txtCantidadCta')) != "") ? trim($this->input->post('txtCantidadCta')) : null;  //textbox
            //Grid despues de insertar el articulo
            $cxr_id_cxu_tab1 = $this->input->post('tipo_caracteristica');  //array
            $cxu_valor_tab1 = $this->input->post('nombre_caracteristica');  //array 
            //Tab2
            $mep_id_cva_tab2 = $this->input->post('medida_conversion'); //array
            $cva_conversion_tab1 = $this->input->post('conversion'); //array
            $cva_equivalente_tab1 = $this->input->post('equivalente'); //array
            $cva_defecto_tab1 = $this->input->post('defecto');  //array
            //Tab3
            $art_inventario_tab3        = (trim($this->input->post('prod_inventario')) != "") ? 1 : 0; //ibutton
            $art_compra_tab3            = (trim($this->input->post('prod_compra')) != "") ? 1 : 0; //ibutton
            $art_venta_tab3             = (trim($this->input->post('prod_venta')) != "") ? 1 : 0; //ibutton
            $art_materia_prima_tab3     = (trim($this->input->post('prod_materiap')) != "") ? 1 : 0;  //ibutton
            $art_gasto_tab3             = (trim($this->input->post('prod_gasto')) != "") ? 1 : 0; //ibutton
            $art_costo_tab3             = (trim($this->input->post('prod_costo')) != "") ? 1 : 0; //ibutton
            $art_activo_fijo_tab3       = (trim($this->input->post('activo_fijo')) != "") ? 1 : 0; //ibutton
            $art_produccion_tab3        = (trim($this->input->post('prod_produccion')) != "") ? 1 : 0; //ibutton
            $art_componente_tab3        = (trim($this->input->post('prod_componente')) != "") ? 1 : 0; //ibutton
            $bod_id                     = (trim($this->input->post('bodega_bod')) != "") ? $this->input->post('bodega_bod') : null;
            $sxb_sectorxbodega          = (trim($this->input->post('sector_sxb')) != "") ? $this->input->post('sector_sxb') : null;
            $slcMarca                   = (trim($this->input->post('slcMarca')) != "") ? $this->input->post('slcMarca') : null;
            $art_aplica_empaque_tab3    = (trim($this->input->post('aplica_empaque')) != "") ? 1 : 0; //ibutton
            //Tab 4
            $tgr_id_tab1 = (trim($this->input->post('agrupacion_general_combo')) != "") ? $this->input->post('agrupacion_general_combo') : null; //select
            $id_art_cma = $this->input->post('producto_datos_combo'); //array
            $cantidad_cma = $this->input->post('cantidad_datos_combo'); //array

            if (trim($art_codigo_tab1) != "" && trim($art_nombre_tab1) != "" && trim($tia_id_tab1)) {
                $respuesta = $this->db->insert('art_articulo', array(
                    'art_id_tia' => $tia_id_tab1,
                    'art_id_cda' => $cda_id_tab1,
                    'art_id_tgr' => $tgr_id_tab1,
                    'art_id_mrp' => $slcMarca,
                    'art_nombre' => $art_nombre_tab1,
                    'art_codigo' => $art_codigo_tab1,
                    //'art_codigo_barra' => $art_codigo_barra_tab1,
                    'art_sinonimo' => $art_sinonimo_tab1,
                    'art_descripcion' => $art_descripcion_tab1,
                    'art_foto' => $art_foto_tab1,
                    'art_minimo' => $art_minimo_tab1,
                    'art_maximo' => $art_maximo_tab1,
                    'art_fecha' => date('Y-m-d H:i:s'),
                    'art_tipo' => $art_tipo_tab1,
                    'art_aplica_serie' => $art_aplica_serie_tab1,
                    'art_combo' => $art_combo_tab1,
                    'art_compra' => $art_compra_tab3,
                    'art_inventario' => $art_inventario_tab3,
                    'art_venta' => $art_venta_tab3,
                    'art_materia_prima' => $art_materia_prima_tab3,
                    'art_gasto' => $art_gasto_tab3,
                    'art_costo' => $art_costo_tab3,
                    'art_activo_fijo' => $art_activo_fijo_tab3,
                    'art_produccion'    => $art_produccion_tab3,
                    'art_componente'    => $art_componente_tab3,
                    'art_id_bod'        => $bod_id,
                    'art_id_sxb'        => $sxb_sectorxbodega,
                    'art_aplica_empaque'=> $art_aplica_empaque_tab3,
                    'art_aplica_cuota'  => $art_cuota, 
                    'art_numero_cuota'  => $art_num_cuota,
    
                    //'art_codigo_proveedor' => $art_codigo_tab1,
                    'art_precio_sugerido' => $precio_sug,
                    'art_estado' => 1,
                    'art_usu_creacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_creacion' => date('Y-m-d H:i:s'),
                    'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_modificacion' => date('Y-m-d H:i:s')
                ));
                $art_id = $this->db->insert_id();
                for ($x = 0; $x < count($mep_id_cva_tab2); $x++) {
                    if (trim($mep_id_cva_tab2[$x]) != "" && trim($cva_conversion_tab1[$x]) != "" && trim($cva_defecto_tab1[$x]) != "") {
                        $respuesta = $this->db->insert('cva_conversion_articulo', array(
                            'cva_id_mep' => $mep_id_cva_tab2[$x],
                            'cva_id_art' => $art_id,
                            'cva_conversion' => $cva_conversion_tab1[$x],
                            'cva_medida_equivalente' => (trim($cva_equivalente_tab1[$x]) != '')?$cva_equivalente_tab1[$x]:null,
                            'cva_defecto' => $cva_defecto_tab1[$x],
                            'cva_estado' => 1,
                            'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cva_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'cva_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cva_fecha_creacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }
                for ($x = 0; $x < count($cxr_id_cxu_tab1); $x++) {
                    if (trim($cxr_id_cxu_tab1[$x]) != "") {
                        //if (trim($cxr_id_cxu_tab1[$x]) != "" && trim($cxu_valor_tab1[$x]) != "") {
                        $respuesta = $this->db->insert('cxu_caracxarticulo', array(
                            'cxu_id_art' => $art_id,
                            'cxu_id_cxr' => $cxr_id_cxu_tab1[$x],
                            'cxu_valor' => $cxu_valor_tab1[$x],
                            'cxu_estado' => 1,
                            'cxu_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cxu_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cxu_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cxu_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }
                for ($x = 0; $x < count($id_art_cma); $x++) {
                    if (trim($id_art_cma[$x]) != "" && trim($cantidad_cma[$x]) != "") {
                        $respuesta = $this->db->insert('cma_combo_articulo', array(
                            'cma_id_art' => $art_id,
                            'cma_id_art_combo' => $id_art_cma[$x],
                            'cma_cantidad' => $cantidad_cma[$x],
                            'cma_estado' => 1,
                            'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cma_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'cma_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cma_fecha_creacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }
            }

            /*======================= GUARDAR CODIGOS DE PRODUCTO  Add by René Castaneda ============================================*/
            if ($this->input->post('ncodigo_producto')) {
                $ncodigo_producto = $this->input->post('ncodigo_producto');
                $ncodigos = count($ncodigo_producto);
                $array_codigos = array();
                for ($q=0; $q < $ncodigos ; $q++) { 
                    if ($ncodigo_producto[$q] != '') {
                        $array_codigos[] = array(
                            'cdp_id_art' => $art_id
                            ,'cdp_codigo' => $ncodigo_producto[$q]
                            ,'cdp_estado' => 1
                            ,'cdp_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_modificacion' =>  date('Y-m-d H:i:s')
                            ,'cdp_usu_creacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_creacion' =>  date('Y-m-d H:i:s')

                        );
                    }
                }
                if (count($array_codigos) > 0 ) {
                $this->gsatelite->ingresar('cdp_codigo_producto',$array_codigos,true);
                } 
            }
            /*======================= FIN GUARDAR CODIGOS DE PRODCUTO ============================================*/

            /*======================= GUARDAR MINIMO-MAXIMO POR BODEGA  ============================================*/

            if ($this->input->post('bodega_min_max')) {
                $bodega_min_max   = $this->input->post('bodega_min_max');
                $minimos   = $this->input->post('min_val');
                $maximos   = $this->input->post('max_val');
                $nbodegas_MinMax  = count($bodega_min_max);
                $array_MinMax = array();
                for ($l=0; $l < $nbodegas_MinMax ; $l++) { 
                    if ($bodega_min_max[$l] != '') {
                        $array_MinMax[] = array(
                            'mma_id_art'    => $art_id
                            ,'mma_id_bod'   => $bodega_min_max[$l]
                            ,'mma_minimo'   => ($minimos[$l] != "") ? $minimos[$l] : null
                            ,'mma_maximo'   => ($maximos[$l] != "") ? $maximos[$l] : null
                            ,'mma_estado'   => 1
                            ,'mma_usu_creacion'     => $this->tank_auth->get_user_id()
                            ,'mma_fecha_creacion'   =>  date('Y-m-d H:i:s')
                            ,'mma_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'mma_fecha_modificacion' =>  date('Y-m-d H:i:s')

                        );
                    }
                }

                if (count($array_MinMax) > 0 ) {
                $this->gsatelite->ingresar('mma_mimino_maximoxarticulo', $array_MinMax, true);
                }
            }

            /*======================= FIN GUARDAR MINIMO-MAXIMO POR BODEGA  =========================================*/
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de artículos", 'texto_alerta' => "El registro se guardó correctamente");
            $this->session->set_flashdata($alerta);
            $red = $this->input->post('redireccion');
            if ($coti == 1) {
                if($red == 1){
                    redirect('/cotizaciones/mantenimientos/articulo');
                }else{
                    redirect('/cotizaciones/mantenimientos/editar_articulo/'.$art_id);
                }
            } elseif ($proy == 1) {
                if($red == 1){
                    redirect('/proyectos/mantenimientos/articulo');
                }else{
                    redirect('/proyectos/mantenimientos/editar_articulo/'.$art_id);
                }
            } elseif ($fac == 1) {
                if($red == 1){
                    redirect('/facturacion/entradas/articulo');
                }else{
                    redirect('/facturacion/entradas/editar_articulo/'.$art_id);
                }
            }  elseif ($modulo_contratos == 1) {
                if($red == 1){
                    redirect('/modulo_contratos/catalogos/servicios');
                }else{
                    redirect('/modulo_contratos/catalogos/editar_articulo/'.$art_id);
                }
            } elseif ($compras == 1) {
                if($red == 1){
                    redirect('/modulo_compras/catalogos/servicios');
                }else{
                    //cargarvista($data, $output, "inventario/mantenimiento/editar_articulo/".$art_id);
                    redirect('/modulo_compras/catalogos/editar_articulo/'.$art_id);
                }
            } else {
                if ($red == 1) {
                    redirect($ruta.'/articulo');
                } else {
                    //cargarvista($data, $output, "inventario/mantenimiento/editar_articulo/".$art_id);
                    redirect($ruta.'/editar_articulo/' . $art_id);
                }
            }

        } else {            
            /*$cxr_id = $this->input->post('cxr_id');
            print_r($cxr_id); die();*/
            //registros de la tabla articulos para visualisar
            $data["mod"] = 1;
            $data["art_articulo"] = $art = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $articulo));
            //var_dump($data['art_articulo']);die();

            $data["codigo_arancelario"] = $this->gsatelite->get_tabla('cda_codigo_arancelario', array('cda_estado' => 1));

            $data["categoria_tia"] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));

            //select para elegir las caracteristicas del articulo   
            //$caracteristicas = $this->inventario_model->get_caracteristica2($data["art_articulo"][0]["art_id_tia"]);
            $caracteristicas = $this->inventario_model->get_caracteristica2($data["art_articulo"][0]["art_id_tia"]);

            $cadena = '';
            foreach ($caracteristicas as $k) {
                $cadena .= '<option value="' . $k['cxr_id'] . '">' . $k['car_nombre'] . '</option>';
            }
            //print_r($cadena); die();
            $data["select_caracteristica"] = $cadena;

            //muestra los datos en la grid de la tab 1
            $data['caracteristicas_grid'] = $caracteristicas;
            $data['cxu_articulo'] = $this->gsatelite->get_tabla('cxu_caracxarticulo', array('cxu_estado' => 1, 'cxu_id_art' => $articulo));
            $caract_sty = 'style="display:none;"';
            if (!empty($data['cxu_articulo'])) {
                $caract_sty = '';
            }
            $data['caract_sty'] = $caract_sty;

            //muestra los datos de la grid de la tab 2
            $data['conversiones_grid'] = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_estado' => 1, 'cva_id_art' => $articulo));
            $data['mep_articulo'] = $this->gsatelite->get_tabla('mep_medida_producto', array('mep_estado' => 1));
            $conver_sty = 'style="display:none;"';
            if (!empty($data['conversiones_grid'])) {
                $conver_sty = '';
            }
            $data['conver_sty'] = $conver_sty;
            //tab 3
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), $data["art_articulo"][0]["art_id_bod"], '', 'bod_id', true);
            $data["bodega_bod"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $datos_sector_bod = $this->inventario_model->get_sector_grid($data["art_articulo"][0]["art_id_bod"]);
            $select = '<option value=""></option>';
            foreach ($datos_sector_bod as $key) {
                if ($data["art_articulo"][0]["art_id_sxb"] == $key['sxb_id']) {
                    $select .= '<option value="' . $key['sxb_id'] . '" selected>' . $key['seb_nombre'] . '</option>';
                } else {
                    $select .= '<option value="' . $key['sxb_id'] . '">' . $key['seb_nombre'] . '</option>';
                }
            }
            $data["sxb_sector"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            //muestra los datos de la grid de la tab 4
            $data['combo_grid'] = $this->inventario_model->get_articulo_cma($articulo);
            $combo_sty = 'style="display:none;"';
            if (!(empty($data['combo_grid']))) {
                $combo_sty = '';
            }
            // tab de Minimo-Maximo
            $this->db->join('bod_bodega', 'bod_id = mma_id_bod');
            $data['bod_min_max'] = $this->gsatelite->get_tabla('mma_mimino_maximoxarticulo', array('mma_id_art'=>$articulo, 'mma_estado'=>1));

            $data['combo_sty'] = $combo_sty;

            $data['tipos_agrupacion'] = $this->gsatelite->get_tabla('tgr_tipo_agrupacion', array('tgr_estado' => 1));

            $select = $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => 1), null, '', 'mep_id', true);
            $data["medida_producto"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $select = $this->gsatelite->get_dropdown('tgr_tipo_agrupacion', '{tgr_nombre}', '', array('tgr_estado' => 1), null, '', 'tgr_id', true);
            $data["tipo_agrupacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data["categorias"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $marcas = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', array('mrp_estado' => 1), $art[0]['art_id_mrp'], '', 'mrp_id', true);
            $data["marcas"] = str_replace('<option value="0">Seleccione</option>', '', $marcas);

            // Tab de Minimo-Maximo
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data["bodega_max_min"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data['titulo_personal'] = "Duplicar producto";
            
            //TODO EL PROCESO PARA AGREGAR UN VALOR CORRECTO AL CAMPO codigo 
            $codigo = "";
            //ID de categoria
            $id_categoria = $data['art_articulo'][0]['art_id_tia'];

            $categoria_codigo = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_id' => $id_categoria));
            //Prefijo de categoria
            $codigo_categoria = $categoria_codigo[0]['tia_codigo'];

            $correlativo = $this->inventario_model->get_correlativo($codigo_categoria);
            $numero_correlativo = array();

            foreach ($correlativo as $key) {
                $temp = "";
                $temp_cod_n = strlen($key['art_codigo']);
                $temp_cod = $key['art_codigo'];
                for ($x = 0; $x < $temp_cod_n; $x++) {
                    if ($x > strlen($codigo_categoria)) {
                        $temp .= $temp_cod[$x];
                    }
                }
                if (is_numeric($temp)) {
                    $numero_correlativo[] = sprintf('%0' . 5 . 's', ($temp + 1));
                }
            }

            if (empty($numero_correlativo)) {
                $numero_correlativo[0] = sprintf('%0' . 5 . 's', 1);
            } else {
                rsort($numero_correlativo);
            }
            
            $codigo = $codigo_categoria.$numero_correlativo[0];

            //Asignamos el valor codigo al input al momento de cargar la pagina
            $data['art_articulo']['codigo'] = $codigo;

            if($modulo == '7'){
                $data["mod"] = 7;
            } 
            if($modulo == '13'){
                $data["mod"] = 13;
            } 
            if($modulo == '8'){
                $data["mod"] = 8;
                $data['titulo_personal'] = "Edición de producto - servicio";
                return $data;
            }
            if ($modulo == '4' || $otro_modulo !=  "") {

            }
            if( $ruta_modulo == "" || $ruta_modulo == null) {
                $data['ruta_modulo'] = "inventario/mantenimiento";
            }

            $data['ruta_modulo'] = ($ruta_modulo == null) ? "inventario/mantenimiento" : $ruta_modulo;
            cargarvista($data, null, "inventario/mantenimiento/duplicar_articulo");
        }
    }

    public function articulo($titulo = null, $otro_modulo = null, $permisos=null, $ruta = null) { //Necesita que le metan la foto
        satelite_validar();
        try {
            
            $ruta = trim($ruta) != "" ? $ruta : "inventario/mantenimiento";
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');
            $crud = $this->new_crud();

            $permisos = $this->gsatelite->get_permisos_opcion();

            $diferente_session = ($otro_modulo != '' )? $otro_modulo.'_':'';
            $where_datos = array();
                //configuración filtros
            $filtro_banderas = array("1"=>"art_materia_prima","2"=>"art_produccion","3"=>"art_gasto","4"=>"art_costo","5"=>"art_venta","6"=>"art_compra");

            if ($this->input->post()) {
                $this->session->set_userdata($diferente_session . 'filtro_categoria_art',$this->input->post('slcCategoria'));
                $this->session->set_userdata($diferente_session . 'filtro_tipo_art',$this->input->post('slcTipo')); 
                $this->session->set_userdata($diferente_session . 'filtro_slcConf',$this->input->post('slcConf')); 
                $this->session->set_userdata($diferente_session . 'filtro_codigo',$this->input->post('txtCodigo'));       
            }

            if ($this->session->userdata($diferente_session . 'filtro_categoria_art') > 0 ) {
                $registros_cat = $this->gsatelite->get_tabla('tia_tipo_articulo',array('tia_padre' => $this->session->userdata($diferente_session . 'filtro_categoria_art')));
                $ids_cat = array();
                if (count($registros_cat) > 0 ) {
                    foreach ($registros_cat as $f) {
                        $ids_cat[] = $f['tia_id'];
                        $registros_cat2 = $this->gsatelite->get_tabla('tia_tipo_articulo',array('tia_padre' => $f['tia_id']));
                        if (count($registros_cat) > 0 ) {
                            foreach ($registros_cat2 as $f2) {
                                $ids_cat[] = $f2['tia_id']; 
                            } 
                        }

                    }
                }
                $ids_cat[] = $this->session->userdata($diferente_session . 'filtro_categoria_art') ;
                $ids_categorias = implode(',', $ids_cat);
                $where_datos["art_id_tia in ($ids_categorias)"] = null;
                //$where_datos['art_id_tia'] = $this->session->userdata('filtro_categoria_art');
            }
            if ($this->session->userdata($diferente_session . 'filtro_tipo_art') > 0 ) {
                $where_datos['art_tipo'] = $this->session->userdata($diferente_session . 'filtro_tipo_art') - 1; //para igualarlos a la base
            }

            if ($this->session->userdata($diferente_session . 'filtro_slcConf') > 0 ) {
                $where_datos[$filtro_banderas[$this->session->userdata($diferente_session . 'filtro_slcConf')]] = 1; 
            }

            if ($this->session->userdata($diferente_session . 'filtro_codigo') != '' ) {
                $where_datos["CONCAT_WS(' ', art_nombre, art_codigo,(SELECT GROUP_CONCAT(cdp_codigo) FROM cdp_codigo_producto WHERE cdp_id_art = art_id)) like '%".$this->session->userdata($diferente_session . 'filtro_codigo')."%' "] = null; 
            }
            if (($this->input->post() and count($where_datos) <= 0) || substr_count(uri_string(), 'print') > 0  || substr_count(uri_string(), 'export') > 0  ) {
                $where_datos['art_estado'] = 1;
            }
            $where = (count($where_datos) > 0)? $where_datos:array('art_id'=>0);

            $id_categ_filtro = ($this->session->userdata($diferente_session . 'filtro_categoria_art') > 0)? $this->session->userdata($diferente_session . 'filtro_categoria_art'):null;
            $tipo_art_filtro = ($this->session->userdata($diferente_session . 'filtro_tipo_art') != '' )? $this->session->userdata($diferente_session . 'filtro_tipo_art'):null;
            $slcConf_filtro = ($this->session->userdata($diferente_session . 'filtro_slcConf') != '' )? $this->session->userdata($diferente_session . 'filtro_slcConf'):null;

            $txtCodigo = ($this->session->userdata($diferente_session . 'filtro_codigo') != '' )? $this->session->userdata($diferente_session . 'filtro_codigo'):'';

            //se hizo asi dado que hay multiples vistas para que el grocery se renderice.
            $data_filtro['permisos'] = $permisos;
            $data_filtro['id_categ_filtro'] = $id_categ_filtro;
            $data_filtro['codigo_art'] = $txtCodigo;
            
            $data_filtro['tipo_art_filtro'] = $tipo_art_filtro;
            $data_filtro['slcConf'] = $slcConf_filtro;
           // print_r($data_filtro); die();
            $data_filtro['categoria'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}','', array('tia_estado' => '1'), $id_categ_filtro, '', 'tia_id', true);
            $data['html_filtro_articulo'] = $this->load->view('inventario/mantenimiento/html_filtro_articulo', $data_filtro, true); 
          
            //var_dump($where);die();
            $crud->where($where);

            //Columnas a mostrar en READ
            $columns = array(
                'art_id',
                'art_codigo',
                'art_nombre',
                'art_sinonimo',
                'art_id_mrp',
                'medida',
                'art_id_ppr',
                // 'codigo_tia',
                'art_id_tia',
                'art_tipo',
                // 'art_codigo_proveedor',
                'art_estado'
            );

            //Alias para las columnas
            $alias = array(
                'art_id'      => 'ID',
                'art_codigo'  => 'Código',
                'art_nombre'  => 'Producto',
                'art_sinonimo'=> 'Sinonimo',
                'art_id_mrp'  => 'Marca',
                'medida'      => 'UM',
                'art_minimo'  => 'Mínimo',
                'art_maximo'  => 'Máximo',
                // 'codigo_tia' => 'Código categoría',
                'art_id_tia'  => 'Categoría',
                'art_foto'    => 'Foto de artículo',
                'art_estado'  => 'Estado',
                'art_aplica_serie' => 'Aplica Serie',
                'art_tipo'    => 'Tipo',
                // 'art_codigo_proveedor' => 'Código fábrica',
                'propositos'  => 'Tipo artículo',
                'art_id_ppr'  => 'Presentación'
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
                'art_id_tia',
                'art_nombre',
                //'art_id_mep',				
                'art_codigo',
                'art_codigo_proveedor',
                'art_minimo',
                'art_maximo',
                'art_foto',
                'propositos',
                'art_aplica_serie',
                'art_estado',
                'art_usu_mod',
                'art_fecha_mod',
                'art_fecha'
            );

            //Columnas a mostrar en EDIT
            $edit_columns = array(
                'art_id_tia',
                'art_nombre',
                //'art_id_mep',				
                'art_codigo',
                'art_codigo_proveedor',
                'art_minimo',
                'art_maximo',
                'art_foto',
                'propositos',
                'art_aplica_serie',
                'art_estado',
                'art_usu_mod',
                'art_fecha_mod'
            );

            $req_columns = array(
                'art_id_tia',
                'art_nombre',
                //'art_id_mep',
                'art_estado'
            );
            $query_padres = "SELECT DISTINCT tia_padre FROM tia_tipo_articulo";
            $padres = $this->db->query($query_padres)->result_array();

            $cadena_in = "";
            foreach ($padres as $key => $value) {
                if ($value['tia_padre'] != "") {
                    $cadena_in .= $value['tia_padre'] . ",";
                }
            }
            $cadena_final = substr($cadena_in, 0, -1);
            if ($cadena_final == '') {
                $cadena_final = 0;
            }
            $query_no_tienen_hijos = "SELECT tia_id FROM tia_tipo_articulo WHERE tia_id NOT IN (" . $cadena_final . ")";
            $no_tienen_hijos = $this->db->query($query_no_tienen_hijos)->result_array();
            $cadena_in2 = "";
            foreach ($no_tienen_hijos as $key2 => $value2) {
                if ($value2['tia_id'] != "") {
                    $cadena_in2 .= $value2['tia_id'] . ",";
                }
            }
          
            $cadena_final2 = substr($cadena_in2, 0, -1);
            if ($cadena_final2 == '') {
                $cadena_final2 = 0;
            }
            $dir = explode('/', uri_string());
            $crud->set_table('art_articulo')
                    //->set_subject('Productos')
                    ->set_subject('')
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($req_columns)
                    ->set_field_upload('art_foto', 'assets/uploads/images')
                    ->callback_column('medida', array($this, 'medida'))
                    ->callback_column('codigo_tia', array($this, 'codigo_tia'))
                    ->set_rules('art_nombre', 'Nombre', 'required')
                    ->set_rules('art_id_tia', 'Categoría', 'required')
                    ->set_relation('art_id_tia', 'tia_tipo_articulo', 'tia_nombre', "tia_id IN({$cadena_final2})")
                    ->field_type('art_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                    ->field_type('art_aplica_serie', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                    ->field_type('art_tipo', 'dropdown', array('1' => 'Servicio', '0' => 'Producto'))
                    ->set_relation_n_n('propositos', 'axp_articuloxproposito', 'pra_proposito_articulo', 'axp_id_art', 'axp_id_pra', 'pra_nombre')
                    ->set_relation('art_id_mrp','mrp_marca_producto','mrp_nombre')
                    ->set_relation('art_id_ppr','ppr_presentacion_producto','ppr_nombre') // Relacion tabla Presentacion
                    ->field_type('art_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('art_fecha_mod', 'hidden', date('Y-m-d h:i:s'))

            ;
            $crud->callback_column('art_nombre', function($value, $row) {
                return $value;
            });

            //permisos
            if ($permisos["permite_editar"]) {
                if ($titulo != '' && $otro_modulo == 'facturacion') {
                    $crud->add_action('Editar', '', 'facturacion/entradas/editar_articulo', 'icomoon-icon-pencil-5');
                } else if ($titulo != '' && $otro_modulo == 'modulo_compras') {
                    $crud->add_action('Editar', '', 'modulo_compras/catalogos/editar_articulo', 'icomoon-icon-pencil-5');
                } else if ($titulo != '' && $otro_modulo == 'cotizaciones') {
                    $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'cotizaciones/mantenimientos/editar_articulo', 'edit');
                } else if ($titulo != '' && $otro_modulo == 'proyectos') {
                    $crud->add_action('Etapas producción', 'icon16 icomoon-icon-enter', 'proyectos/mantenimientos/etapas_produccion');
                    $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'proyectos/mantenimientos/editar_articulo', 'edit');
                    $crud->add_action('Factores de calidad', 'icon16 icomoon-icon-equalizer', 'proyectos/mantenimientos/factor_calidad_articulo');
                } else if ($titulo != '') {
                    $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'tarificador/procesos/editar_articulo', 'edit');
                } else {
                    $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'inventario/mantenimiento/editar_articulo', 'edit');
                }
            }
            //Agregar opcion de poder duplicar articulo
            if($permisos["permite_agregar"] && $permisos["permite_editar"]) {
                $ruta = ($ruta == "") ? "cotizaciones/mantenimientos":$ruta;
                $crud->add_action('Duplicar', 'icon16 icon16 icomoon-icon-copy-2', $ruta.'/duplicar_articulo','edit');
            }


            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            $data['add_articulo'] = 1;

            if (!$permisos["permite_agregar"]) {
                $data['add_articulo'] = 0;
            }

            $data['otro'] = $otro_modulo;
            if ($dir[0] == 'proyectos') {
                $crud->add_action('Costeo Producto', 'icon16 icomoon-icon-stack ', 'proyectos/mantenimientos/presupuesto','pre_duplicar');
                // $crud->add_action('Etapas analíticas', 'icon16 icomoon-icon-checkmark', 'proyectos/mantenimientos/etapas_cursograma_analitico','duplicar_etapa_analitica');
            } else if ($dir[0] == 'inventario') {
                $crud->add_action('Lista precios', 'icon16 icomoon-icon-list-view', 'inventario/mantenimiento/precios_articulo');
                $crud->add_action('Formulas', 'icomoon-icon-calculate-2', 'inventario/mantenimiento/formulas_producto');
            } else if ($dir[0] == 'facturacion') {
                $crud->add_action('Lista precios', 'icon16 icomoon-icon-list-view', 'facturacion/entradas/precios_articulo'); //SE CAMBIO LA OPCION DE PROCESOS MAY/21
                $crud->add_action('Formulas', 'icomoon-icon-calculate-2', 'facturacion/entradas/formulas_producto');
            } else if($dir[0] == 'modulo_compras') {
                // $crud->add_action('Lista precios', 'icon16 icomoon-icon-list-view', 'modulo_compras/catalogos/precios_articulo'); //FALTA OPCION EN PROCESOS COMO EN FACTURACION MAY/21
                $crud->add_action('Formulas', 'icomoon-icon-calculate-2', 'modulo_compras/catalogos/formulas_producto');
            } else if ($dir[0] == 'cotizaciones') {
                // $crud->add_action('Lista precios', 'icon16 icomoon-icon-list-view', 'cotizaciones/mantenimientos/precios_articulo'); //FALTA OPCION EN PROCESOS COMO EN FACTURACION MAY/21
                $crud->add_action('Costeo Producto', 'icon16 icon16 icomoon-icon-stack ', 'cotizaciones/mantenimientos/presupuesto','pre_duplicar');
            }
           
            $crud->field_type('art_fecha', 'hidden', date('Y-m-d h:i:s'))
                    ->unset_edit()
            ;
            $crud->callback_after_upload(array($this, 'cargar_imagen_callback_after_upload'));
            $crud->callback_before_delete(array($this, 'delete_pxa'));

            $output = $crud->render();

            if ($titulo != '') {
                $data['titulo_personal'] = $titulo;
            } else {
                $data['titulo_personal'] = "Catálogo de productos";
            }
            $data['modu'] = $dir[0];
            $data['ruta'] = $ruta;

            if ($ruta == "" || $ruta == null) {
                $this->_cargarvista($data, $output);
            } else {
                if($ruta == "cotizaciones/mantenimientos") {
                    $this->_cargarvista($data, $output);
                } else if($ruta == "proyectos/mantenimientos") {
                    $this->_cargarvista($data, $output);
                } else {
                    cargarvista($data, $output, 'inventario/mantenimiento/articulo');
                }
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function medida($value, $row) {
        $medida = $this->inventario_model->get_medida($row->art_id);

        $medida_nombre = (isset($medida[0]['mep_nombre'])) ? $medida[0]['mep_nombre'] : "";
        return $medida_nombre;
    }

    function codigo_tia($value, $row) {
        $categoria = $this->gsatelite->get_registro('tia_tipo_articulo', array('tia_id'=>$row->art_id_tia));
        $codigo_cat = (isset($categoria->tia_codigo)) ? $categoria->tia_codigo : "";
        return $codigo_cat;
    }

    public function delete_pxa($primary_key) {
        $this->db->where('pxa_id_art', $primary_key);
        $this->db->delete('pxa_proveedorxarticulo');
        return true;
    }

    public function username_check_insert4($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("art_id", $id)->get('art_articulo')->row()->art_nombre;
            $num_row = $this->db->where('art_nombre', $str)->where('art_id !=', $id)->get('art_articulo')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert4', 'El nombre del articulo ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('art_nombre', $str)->get('art_articulo')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert4', 'El nombre del articulo ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function cargar_imagen_callback_after_upload($uploader_response, $field_info, $files_to_upload) {
        $this->load->library('image_moo');

        //Is only one file uploaded so it ok to use it with $uploader_response[0].
        $file_uploaded = $field_info->upload_path . '/' . $uploader_response[0]->name;

        $this->image_moo->load($file_uploaded)->resize(800, 600)->save($file_uploaded, true);

        return true;
    }

    /**
     * @author Luis Navarro (proceso de compartir funcionalidad 15-01-2018)
     * @return Mantenimiento tia_tipo_articulo
     * Descripcion: Funcion padre, compartida con el modulo cotizaciones/mantenimientos ( funcion: categorias)
     * Funcionalidad Padre, compartida con el modulo facturacion/entradas (funcion: categorias)
     * Funcionalidad Padre, compartida con el modulo proyectos/mantenimientos (funcion: categorias)
     */
    public function tipo_articulo($ruta = null) {
        satelite_validar();
        try {
            $ruta = (trim($ruta) != '')? $ruta : 'inventario/mantenimiento';
            $data['ruta'] = $ruta;
            $crud = $this->new_crud();

            $where_datos = array();

            $slcFiltro = (trim($this->input->post('slcFiltro')) != null)?$this->input->post('slcFiltro'):"";
            $impFiltro = (trim($this->input->post('impFiltro')) != null)?$this->input->post('impFiltro'):"";
            $data['slcFiltro'] = $slcFiltro;
            $data['impFiltro'] = $impFiltro;
            $data['read'] = 'readonly';
            
            if($slcFiltro == 1){
                $where_datos['tia_tipo_articulo.tia_codigo'] = $impFiltro;
            }else if($slcFiltro == 2){
                $where_datos['tia_tipo_articulo.tia_nombre'] = $impFiltro;
            } else{
                $where_datos = array();
            }

            if($impFiltro == null){
                $data['slcFiltro'] = "";
                $data['impFiltro'] = "";
                $where_datos = array();
            } else{
                $data['read'] = '';
            }

            $where = (count($where_datos) > 0)? $where_datos:array();
            if($_POST){
                if(count($where) > 0){
                    $crud->like($where);
                }
            } else{
                $where = array('tia_tipo_articulo.tia_id'=>0);
                $crud->where($where);
            }
            

            $permisos = $this->gsatelite->get_permisos_opcion();

            $data['permisos'] = $permisos;
            
            

            //Columnas a mostrar en READ
            $columns = array(
                'tia_codigo',
                'Nivel superior',
                'tia_nombre',
                'caracn',
                //'carac',
                'tia_estado'
            );

            //Alias para las columnas
            $alias = array(
                'tia_nombre' => 'Categoría',
                'tia_id_cco' => 'Cuenta contable',
                'tia_estado' => 'Estado',
                'tia_padre' => 'Padre categoría',
                'tia_codigo' => 'Código',
                'caracn' => 'Características'
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
                'tia_padre',
                'tia_codigo',
                'tia_nombre',
                'tia_id_cco',
                'tia_estado',
                'carac'
            );

            //Columnas a mostrar en EDIT
            $edit_columns = array(
                'tia_padre',
                'tia_codigo',
                'tia_nombre',
                'tia_id_cco',
                'tia_estado',
                'carac'
            );

            $required = array(
                'tia_codigo',
                'tia_nombre',
                'tia_estado'
            );
            $categoria = $this->uri->segment(5);
            $url = explode('/', uri_string());
            if (end($url) == 'add' or prev($url) == 'edit') { //preguntar si es una accion de editar o agregar
                //LLAMAR A LA FUNCION QUE HACE EL FILTRO PARA SELECCIONAR SOLO LOS PADRES Y LOS HIJOS
                $idsPermitidos = $this->inventario_model->get_categoriasPadre_hijos();
                $crud->set_relation('tia_padre', 'tia_tipo_articulo', '{tia_id} {tia_nombre}', array('tia_id <>' => $categoria, "tia_id IN ({$idsPermitidos})" => null), null, null, $default_value = 0);
            } else {
                $crud->set_relation('tia_padre', 'tia_tipo_articulo', '{tia_id} {tia_nombre}');
            }

            $crud->set_table('tia_tipo_articulo')
                    //->set_subject('Categoría')
                    ->set_subject('')
                    ->columns($columns)
                    ->display_as($alias)
                    ->unset_edit()
                    ->unset_add()
                    ->unset_delete()
                    ->unset_read()
                    ->add_fields($add_columns)
                    ->required_fields($required)
                    //->set_relation('tia_padre', 'tia_tipo_articulo', '{tia_id} {tia_nombre}', array('tia_id <>'=>$categoria,"tia_padre"=>null),null,null,$default_value = 0)
                    ->set_rules('tia_nombre', 'Nombre', 'callback_username_check_insert5')
                    ->set_rules('tia_codigo', 'Código', 'callback_username_check_insert55')
                    ->set_relation_n_n('carac', 'cxr_caractxtipo_articulo', 'car_caracteristica', 'cxr_id_tia', 'cxr_id_car', '{car_nombre}', null, array('cxr_estado' => 1))
                    //->set_relation('tia_id_cco', 'cco_cuenta_contable', 'cco_nombre')
                    ->callback_after_insert(array($this, 'insertar_auditoria'))
                    ->callback_after_update(array($this, 'insertar_auditoria'))
                    ->callback_column('Nivel superior', array($this, 'columna_padres'))
                    ->callback_column('caracn', array($this, 'get_caracteristica_grid'))
                    ->edit_fields($edit_columns);
            $crud->set_rules('tia_codigo', 'Código', 'required|campo_unico[tia_tipo_articulo.tia_codigo]');
            $crud->set_rules('tia_nombre', 'Nombre Categoría', 'required|campo_unico[tia_tipo_articulo.tia_nombre]');
            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('tia_estado', 'hidden', 1);
            } else {
                $crud->field_type('tia_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if ($permisos["permite_editar"]) {
                $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', "$ruta/editar_pro_articulo");
            }

            $data['add_articulo'] = 1;
            if (!$permisos["permite_agregar"]) {
                $data['add_articulo'] = 0;
            }

            $output = $crud->render();

            $data["titulo_personal"] = "Catálogo de categorías";

            cargarvista($data, $output, 'inventario/mantenimiento/tipo_articulo.php');
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function get_caracteristica_grid($value, $row) {
        $tia_id = $row->tia_id;
        $caracteristicas = $this->inventario_model->get_caracteristica_grid($tia_id);
        $caract = "";
        foreach ($caracteristicas as $key) {
            $caract .= $key["car_nombre"] . ", ";
        }
        $caract = substr(trim($caract), 0, -1);
        return $caract;
    }

    /**
     * @author Luis Navarro (proceso de compartir funcionalidad 15-01-2018)
     * @return Mantenimiento tia_tipo_articulo
     * Descripcion: Funcion padre, compartida con el modulo cotizaciones/mantenimientos ( funcion: agregar_pro_articulo)
     * Funcionalidad Padre, compartida con el modulo facturacion/entradas (funcion: agregar_pro_articulo)
     * Funcionalidad Padre, compartida con el modulo proyectos/mantenimientos (funcion: agregar_pro_articulo)
     */
    public function agregar_pro_articulo($modulo = null, $regresar = null) {
        //Generales
        //tipo articulo
        $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
        $data["padre"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        //caracteristica
        $select = $this->gsatelite->get_dropdown('car_caracteristica', '{car_nombre}', '', array('car_estado' => 1), null, '', 'car_id', true);
        $data["caract"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        // Generar codigo sugerido para la categoria
        $cantidadCat    = $this->gsatelite->count("tia_tipo_articulo");
        $codsugerido    = trim(str_pad($cantidadCat + 1 , 4, "0", STR_PAD_LEFT));
        $data['codigo'] = $codsugerido;

        //Tab Finanzas
        //centro de costo
        $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        //tipo de cuenta
        $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        //cuenta contable
        $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
        $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        //Bodega
        $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
        $data["bodega"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        //CONFIGURACION DE PAISES
        $pais_usuario = $this->inventario_model->get_pais_usuario2(array('id' =>$this->tank_auth->get_user_id())); // pais de la persona logeada de la nacionalidad
        $id_pais_defecto = $this->tank_auth->get_all_empresa()->emr_id_pai; //pais ligada a la empresa
        if(count($pais_usuario) > 0){
            if($pais_usuario[0]['emp_id_pai'] != ''){
                $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $pais_usuario[0]['emp_id_pai'], '', 'pai_id', true);
                $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);                    
            } else{
                //echo "aaaaaaa"; die();
                $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $id_pais_defecto, '', 'pai_id', true);
                $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);                
            }                
        } else if($id_pais_defecto != ''){
            //echo "aaaaaaa"; die();
            $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $id_pais_defecto, '', 'pai_id', true);
            $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);                
        } else{
            $select_pai = $this->gsatelite->get_campo('pai_pais', 'pai_id', array('pai_defecto'=>1));
            $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $select_pai, '', 'pai_id', true);
            $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        }
        // FIN DE CONFIGURACION DE PAISES


        //impuesto
        $select = $this->gsatelite->get_dropdown('imp_impuesto', '{imp_nombre}', '', array('imp_estado' => 1), null, '', 'imp_id', true);
        $data["impuesto"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        $data['modulo_url'] = $modulo;
        $data['modulo_grid'] = $regresar;
        $data['titulo_personal'] = "Gestión de categoría";
// editar_pro_articulo
        if ($modulo == null) {
            $data['modulo_url'] = "inventario/mantenimiento/agregar_pro_articulo";
            $data['modulo_grid'] = "inventario/mantenimiento/tipo_articulo";
            $this->_cargarvista($data);
        } else {
            $html = $this->load->view('inventario/mantenimiento/agregar_pro_articulo', $data, true);
            return $html;
        }
    }

    public function guardar_pro_articulo() {
        satelite_validar();
        if ($_POST) {
            // die(print_r($_POST));
            //Pestaña General
            $padre = $this->input->post('padre');
            $codigo = $this->input->post('codigo');
            $categoria = $this->input->post('categoria');
            $cuenta_contable_cco = $this->input->post('cuenta_contable_cco');
            $caracteristicas_car = $this->input->post('caracteristicas_car');
            $bodega = $this->input->post('bodega');
            $bodega = ($bodega != '') ? $bodega : null;
            $hdnModuloGrid = ($this->input->post('hdnModuloGrid') != '') ? $this->input->post('hdnModuloGrid') : null;
            $hdnModulo = ($this->input->post('hdnModulo') != '') ? $this->input->post('hdnModulo') : null;
            $tipoganancia  = ($this->input->post('tipo_margen') == 1) ? $this->input->post('tipo_margen')  : 0;
            $valorganancia = ($this->input->post('valor_ganancia') > 0) ? $this->input->post('valor_ganancia')  : null;
            $hdnAplicaImpuesto = ($this->input->post('hidden_aplica_impuesto') != '') ? $this->input->post('hidden_aplica_impuesto') : null;
            $hdnAplicaTipoVenta = ($this->input->post('hidden_aplica_tipo_venta') != '') ? $this->input->post('hidden_aplica_tipo_venta') : null;


            $impuesto_imp = $this->input->post('impuesto_imp');

            //Se comprueba si el codigo y la categoria no vayan en blanco
            if (trim($codigo) != "" && trim($categoria) != "") {
                $respuesta = $this->db->insert('tia_tipo_articulo', array(
                    //'tia_id_cco' => (trim($cuenta_contable_cco) != "") ? $cuenta_contable_cco : null,
                    'tia_padre' => (trim($padre) != "") ? $padre : null,
                    'tia_codigo' => $codigo,
                    'tia_nombre' => $categoria,
                    'tia_aplica_impuestos' => $hdnAplicaImpuesto,
                    'tia_aplica_tipo_venta' => $hdnAplicaTipoVenta,
                    'tia_tipo_ganancia' => $tipoganancia,
                    'tia_monto_ganancia' => $valorganancia,
                    'tia_estado' => 1,
                    'tia_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tia_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tia_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tia_fecha_modificacion' => date('Y-m-d H:i:s')
                ));
                $tia_id = $this->db->insert_id();
                if (!empty($caracteristicas_car)) {
                    for ($x = 0; $x < count($caracteristicas_car); $x++) {
                        $respuesta = $this->db->insert('cxr_caractxtipo_articulo', array(
                            'cxr_id_car' => $caracteristicas_car[$x],
                            'cxr_id_tia' => $tia_id,
                            'cxr_estado' => 1,
                            'cxr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cxr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cxr_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }

                if (!empty($impuesto_imp)) {
                    for ($y = 0; $y < count($impuesto_imp); $y++) {
                        $respuesta = $this->db->insert('ixr_impuestox_tipo_articulo', array(
                            'ixr_id_imp' => $impuesto_imp[$y],
                            'ixr_id_tia' => $tia_id,
                            'ixr_estado' => 1,
                            'ixr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ixr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ixr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ixr_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }
            }

            $centro_costo_cec = $this->input->post('centro_costo_cec');
            $cuenta_contable_cnt = $this->input->post('cuenta_contable_cnt');
            $tipo_cuenta_tcn = $this->input->post('tipo_cuenta_tcn');
            $pais = $this->input->post('pais');

            for ($x = 0; $x < count($centro_costo_cec); $x++) {
                if (trim($centro_costo_cec[$x]) != "" && trim($tipo_cuenta_tcn[$x]) != "" && trim($cuenta_contable_cnt[$x]) != "") {
                    $respuesta = $this->db->insert('dta_detalle_tipoarticulo', array(
                        'dta_id_cec' => $centro_costo_cec[$x],
                        'dta_id_cnt' => $cuenta_contable_cnt[$x],
                        'dta_id_tcn' => $tipo_cuenta_tcn[$x],
                        'dta_id_tia' => $tia_id,
                        'dta_id_bod' => ($bodega[$x] != "")?$bodega[$x]:null,
                        'dta_id_pai' => $pais[$x],
                        'dta_estado' => 1,
                        'dta_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dta_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'dta_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dta_fecha_creacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

            $rediret = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect($hdnModulo);
            } else if ($dir == 2) {
                redirect($hdnModuloGrid);
            }
        }
    }

    public function validar_codigo() {
        $codigo = $this->input->post('codigo');
        $code = $this->input->post('code');
        $codigos = $this->gsatelite->get_tabla('tia_tipo_articulo');
        $resp = 0;
        if ($codigo == $code) {
            echo json_encode(array('resp' => $resp));
            die();
        }
        $codigo1 = strtolower($codigo);
        foreach ($codigos as $cod) {
            $codigo_base = strtolower($cod['tia_codigo']);
            if ($codigo_base == $codigo1) {
                $resp = 1;
                echo json_encode(array('resp' => $resp));
                die();
            }
        }
        echo json_encode(array('resp' => $resp));
    }

    public function editar_pro_articulo($id_art = null, $modulo = null, $regresar = null) {
        satelite_validar();
        if ($_POST) {
            // print_r($_POST); die();
            //Pestaña General
            $tia_id = $this->input->post('id_arti');
            $codigo_tia = $this->input->post('codigo_tia');
            $padre = $this->input->post('padre');
            $codigo = $this->input->post('codigo');
            $categoria = $this->input->post('categoria');
            $cuenta_contable_cco = $this->input->post('cuenta_contable_cco');
            $caracteristicas_car = $this->input->post('caracteristicas_car');
            $estado = $this->input->post('estado');
            $hdnModuloGrid = ($this->input->post('hdnModuloGrid') != '') ? $this->input->post('hdnModuloGrid') : null;
            $hdnModulo = ($this->input->post('hdnModulo') != '') ? $this->input->post('hdnModulo') : null;
            $hdnAplicaImpuesto = ($this->input->post('hidden_aplica_impuesto') != '') ? $this->input->post('hidden_aplica_impuesto') : null;
            $hdnAplicaTipoVenta = ($this->input->post('hidden_aplica_tipo_venta') != '') ? $this->input->post('hidden_aplica_tipo_venta') : null;
            $tipoganancia  = ($this->input->post('tipo_margen') == 1) ? $this->input->post('tipo_margen')  : 0;
            $valorganancia = ($this->input->post('valor_ganancia') > 0) ? $this->input->post('valor_ganancia')  : null;

            $impuesto_imp = $this->input->post('impuesto_imp');

            //Se comprueba si el codigo y la categoria no vayan en blanco
            if (trim($codigo) != "" && trim($categoria) != "") {
                $cadena = array(
                    //'tia_id_cco' => (trim($cuenta_contable_cco) != "") ? $cuenta_contable_cco : null,
                    'tia_padre' => (trim($padre) != "") ? $padre : null,
                    'tia_codigo' => $codigo,
                    'tia_nombre' => $categoria,
                    'tia_aplica_impuestos' => $hdnAplicaImpuesto,
                    'tia_aplica_tipo_venta' => $hdnAplicaTipoVenta,
                    'tia_tipo_ganancia' => $tipoganancia,
                    'tia_monto_ganancia' => $valorganancia,
                    'tia_estado' => $estado,
                    'tia_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tia_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $respuesta = $this->gsatelite->actualizar_array('tia_tipo_articulo', $cadena, array('tia_id' => $tia_id));
                
                //En caso de que se Inactive el padre se desactivaran todos los que dependendan. 
                if (trim($padre) == "" && $estado == 0){
                    $subcadena = array(
                        'tia_estado' => $estado,
                        'tia_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'tia_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    $subrespuesta = $this->gsatelite->actualizar_array('tia_tipo_articulo', $subcadena, array('tia_padre' => $tia_id));
                }
            }

            //Edita las caracteristicas
            $consula_cxr = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id_tia' => $tia_id, 'cxr_estado' => 1));
            $registros_crx = array();
            $registros_car_crx = array();
            foreach ($consula_cxr as $fcrx) {
                $registros_crx[] = $fcrx['cxr_id'];
                $registros_car_crx[] = $fcrx['cxr_id_car'];
            }
            $i = 0;
            foreach ($caracteristicas_car as $key => $value) {
                if (!in_array($value, $registros_car_crx)) {
                    $this->db->insert('cxr_caractxtipo_articulo', array(
                        'cxr_id_car' => $value,
                        'cxr_id_tia' => $tia_id,
                        'cxr_estado' => 1,
                        'cxr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cxr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cxr_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
                $i++;
            }
            for ($j = 0; $j < count($registros_car_crx); $j++) {
                if (!in_array($registros_car_crx[$j], $caracteristicas_car)) {
                    $cadena = array(
                        'cxr_estado' => 0,
                        'cxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cxr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cxr_caractxtipo_articulo', $cadena, array('cxr_id' => $registros_crx[$j], 'cxr_id_tia' => $tia_id));
                }
            }

            //Edita los impuestos
            $consula_ixr = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('ixr_id_tia' => $tia_id, 'ixr_estado' => 1));
            $registros_ixr = array();
            $registros_imp_ixr = array();
            foreach ($consula_ixr as $fcrx) {
                $registros_ixr[] = $fcrx['ixr_id'];
                $registros_imp_ixr[] = $fcrx['ixr_id_imp'];
            }
            $i = 0;

            foreach ($impuesto_imp as $key => $value) {
                if (!in_array($value, $registros_imp_ixr)) {
                    $this->db->insert('ixr_impuestox_tipo_articulo', array(
                        'ixr_id_imp' => $value,
                        'ixr_id_tia' => $tia_id,
                        'ixr_estado' => 1,
                        'ixr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ixr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ixr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ixr_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
                $i++;
            }
            for ($j = 0; $j < count($registros_imp_ixr); $j++) {
                if (!in_array($registros_imp_ixr[$j], $impuesto_imp)) {
                    $cadena = array(
                        'ixr_estado' => 0,
                        'ixr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ixr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('ixr_impuestox_tipo_articulo', $cadena, array('ixr_id' => $registros_ixr[$j], 'ixr_id_tia' => $tia_id));
                }
            }
            ///////

            $centro_costo_cec = $this->input->post('centro_costo_cec');
            $cuenta_contable_cnt = $this->input->post('cuenta_contable_cnt');
            $tipo_cuenta_tcn = $this->input->post('tipo_cuenta_tcn');
            $bodega = $this->input->post('bodega');


            //Se eliminan las cuentas asociadas
            $this->gsatelite->borrado_general('dta_detalle_tipoarticulo', array('dta_id_tia' => $tia_id));

            $centro_costo_cec = $this->input->post('centro_costo_cec');
            $cuenta_contable_cnt = $this->input->post('cuenta_contable_cnt');
            $tipo_cuenta_tcn = $this->input->post('tipo_cuenta_tcn');
            $pais = $this->input->post('pais');

            for ($x = 0; $x < count($centro_costo_cec); $x++) {
                if (trim($centro_costo_cec[$x]) != "" && trim($tipo_cuenta_tcn[$x]) != "" && trim($cuenta_contable_cnt[$x]) != "") {
                    $respuesta = $this->db->insert('dta_detalle_tipoarticulo', array(
                        'dta_id_cec' => $centro_costo_cec[$x],
                        'dta_id_cnt' => $cuenta_contable_cnt[$x],
                        'dta_id_tcn' => $tipo_cuenta_tcn[$x],
                        'dta_id_tia' => $tia_id,
                        'dta_id_bod' => ($bodega[$x] != "")?$bodega[$x]:null,
                        'dta_id_pai' => $pais[$x],
                        'dta_estado' => 1,
                        'dta_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dta_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'dta_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dta_fecha_creacion' => date('Y-m-d H:i:s')
                    ));
                }
            }


            $rediret = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) editado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al editar la información");
            }

            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect($hdnModulo . '/' . $tia_id);
            } else if ($dir == 2) {
                redirect($hdnModuloGrid);
            }
        } else {
            $data['id_art'] = $id_art;//Este hace referencia a la categoria del articulo
            $data['articulo'] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id' => $id_art));            


            //Generales
            //tipo articulo
            $data["padre"] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_id <>' => $id_art));
            //cuenta contable
            $data['cuenta_contable'] = $this->gsatelite->get_tabla('cco_cuenta_contable');
            //caracteristica
            $data['caract'] = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            $data['car_x_art'] = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id_tia' => $id_art, 'cxr_estado' => 1));

            //Tab Finanzas
            $data['finanzas'] = $this->inventario_model->get_cuenta_categoria(array('dta_id_tia' => $id_art));
            //print_r($data['finanzas']); die();
            //centro de costo
            $select = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data["centro_costo_select"] = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_estado' => 1));
            //tipo de cuenta
            $select = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            //Bodega
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data["bodega"] = str_replace('<option value="0">Seleccione</option>', '', $select);            

            //Pais
            //CONFIGURACION DE PAISES
            $pais_usuario = $this->inventario_model->get_pais_usuario2(array('id' =>$this->tank_auth->get_user_id())); // pais de la persona logeada de la nacionalidad
            $id_pais_defecto = $this->tank_auth->get_all_empresa()->emr_id_pai; //pais ligada a la empresa
            if(count($pais_usuario) > 0){
                if($pais_usuario[0]['emp_id_pai'] != ''){
                    $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $pais_usuario[0]['emp_id_pai'], '', 'pai_id', true);
                    $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);                    
                } else{
                    //echo "aaaaaaa"; die();
                    $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $id_pais_defecto, '', 'pai_id', true);
                    $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);                
                }                
            } else if($id_pais_defecto != ''){
                //echo "aaaaaaa"; die();
                $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $id_pais_defecto, '', 'pai_id', true);
                $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);                
            } else{
                $select_pai = $this->gsatelite->get_campo('pai_pais', 'pai_id', array('pai_defecto'=>1));
                $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), $select_pai, '', 'pai_id', true);
                $data["pais"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            }
            // FIN DE CONFIGURACION DE PAISES            

            //Bodega Select
            $data["bodega_select"] = $this->gsatelite->get_tabla('bod_bodega', array('bod_estado' => 1));

            $data["tipo_cuenta_select"] = $this->gsatelite->get_tabla('tcn_tipo_cuenta', array('tcn_estado' => 1));
            //cuenta contable
            $select = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data["cuen_con_select"] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
            //impuesto
            $select = $this->gsatelite->get_dropdown('imp_impuesto', '{imp_nombre}', '', array('imp_estado' => 1), null, '', 'imp_id', true);
            $data["impuesto"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            



            $data["imp_por_detall"] = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('ixr_estado' => 1, 'ixr_id_tia' => $id_art));
            $data["impuesto_select"] = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));

            $data['titulo_personal'] = "Gestión de categoría";

            //$data['padre']=$this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado'=>1));
            /* $data['cco_cuentas'] = $this->gsatelite->get_tabla('cco_cuenta_contable');
              $data['caracteristicas'] = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado'=>1));
              $data['car_x_art'] = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id_tia'=>$id_art, 'cxr_estado'=>1));

              $data['cuentas'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia'=>$id_art, 'cxa_tipo'=>1));
              $data['cuentas2'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia'=>$id_art, 'cxa_tipo'=>2));
              $data['cuentas3'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia'=>$id_art, 'cxa_tipo'=>3));
              $data['cuentas4'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia'=>$id_art, 'cxa_tipo'=>4));

              $data['cnt_cont'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado'=>1)); */
            $data['titulo_personal'] = "Gestión de categoría";

            $data['modulo_url'] = $modulo;
            $data['modulo_grid'] = $regresar;

            if ($modulo == null) {
                $data['modulo_url'] = "inventario/mantenimiento/editar_pro_articulo";
                $data['modulo_grid'] = "inventario/mantenimiento/tipo_articulo";
                $this->_cargarvista($data);
            } else {
                $html = $this->load->view('inventario/mantenimiento/editar_pro_articulo', $data, true);
                return $html;
            }
//$this->_cargarvista($data, null);
        }
    }

    public function columna_padres($value, $row) {
        $valores = $this->inventario_model->categorias_hijas_padres($row->tia_id);
        return $valores[0]['departamento'];
    }

    public function insertar_auditoria($post_array, $key) {
//die(print_r($key));
        $actualizar = array('cxr_estado' => 1,
            'cxr_usu_mod' => $this->tank_auth->get_user_id(),
            'cxr_fecha_mod' => date('Y-m-d H:i:s'));
        $this->db->where('cxr_id_tia', $key)->update('cxr_caractxtipo_articulo', $actualizar);


        return true;
    }

    public function caracteristicasxtipoarticulo() {
        $flag  = true;
        $generar_codigo = $numero = "";
        $numero_correlativo = array();
        $codigo_categoria = $codigo_marca = "";
        $id_marca = $this->input->post('marca');
        $code_actual = $this->input->post('codigo');
        $categoria = $this->input->post('categoria');
        $config_codigo = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_PRODUCTO', "");
        $cadena = '<option value=""></option>';
        if ($categoria > 0) {
            $codigo_categoria = $this->gsatelite->get_campo('tia_tipo_articulo', 'tia_codigo', array('tia_id' => $categoria, 'tia_estado' => 1));
            $caracteristicas = $this->inventario_model->get_caracteristica2($categoria);
            foreach ($caracteristicas as $k) {
                $cadena .= '<option value="' . $k['cxr_id'] . '">' . $k['car_nombre'] . '</option>';
            }
        }
        if ($id_marca > 0) {
            $codigo_marca = $this->gsatelite->get_campo('mrp_marca_producto', 'mrp_codigo', array('mrp_id' => $id_marca, 'mrp_estado' => 1));
        }
        $correlativo = $this->inventario_model->get_correlativo($codigo_categoria);
        if (trim($config_codigo) != "") {
            $generado = 1;
            $configuracion = json_decode($config_codigo, true);
            $input_arrays = array('mrp_codigo' => $codigo_marca, 'tia_codigo' => $codigo_categoria);
            $config_array = explode(',', $configuracion['ESTRUCTURA_CODIGO']);
            for ($i=0; $i < count($config_array); $i++) {
                if (isset($input_arrays[$config_array[$i]])) {
                    $generar_codigo .= $input_arrays[$config_array[$i]];
                }elseif ($config_array[$i] == "correlativo") {
                    if (trim($code_actual) != "") {
                        $generar_codigo .= trim($code_actual);
                    } else {
                        if ($configuracion['AGREGA_CORRELATIVO'] > 0) {
                            $long = ($configuracion['LONG_CORRELATIVO'] > 0) ? $configuracion['LONG_CORRELATIVO'] : 3;
                            foreach ($correlativo as $key) {
                                $temp = "";
                                $temp_cod_n = strlen($key['art_codigo']);
                                $temp_cod = $key['art_codigo'];
                                for ($x = 0; $x < $temp_cod_n; $x++) {
                                    if ($x > strlen($codigo_categoria)) {
                                        $temp .= $temp_cod[$x];
                                    }
                                }
                                $temp = $temp + 1;
                                if (is_numeric($temp)) {
                                    $numero_correlativo[] = sprintf('%0' . $long . 's', ($temp));
                                }
                            }
                            if (empty($numero_correlativo)) {
                                $numero_correlativo[0] = sprintf('%0' . $long . 's', 1);
                            } else {
                                rsort($numero_correlativo);
                            }
                            $numero = $numero_correlativo[0];
                            $codigox = $this->gsatelite->get_tabla('art_articulo',array('art_codigo' => $codigo_categoria . $numero_correlativo[0]));
                            if (count($codigox) > 0){
                                $numero = $numero_correlativo[0] + 1;
                                while ($flag == true) {
                                    $codigox = $this->gsatelite->get_tabla('art_articulo',array('art_codigo' => $codigo_categoria.$numero));
                                    if (count($codigox) > 0) {
                                        $numero++;
                                    }else{
                                        $flag = false;
                                    }
                                }
                            }
                            $generar_codigo .= $numero;
                        } 
                    }                    
                }
            }
        } else {
            $generado = 0;
            foreach ($correlativo as $key) {
                $temp = "";
                $temp_cod_n = strlen($key['art_codigo']);
                $temp_cod = $key['art_codigo'];
                for ($x = 0; $x < $temp_cod_n; $x++) {
                    if ($x > strlen($codigo_categoria)) {
                        $temp .= $temp_cod[$x];
                    }
                }
                $temp = $temp + 1;
                if (is_numeric($temp)) {
                    $numero_correlativo[] = sprintf('%0' . 3 . 's', ($temp));
                }
            }
            if (empty($numero_correlativo)) {
                $numero_correlativo[0] = sprintf('%0' . 3 . 's', 1);
            } else {
                rsort($numero_correlativo);
            }
            $numero = $numero_correlativo[0];
            $codigox = $this->gsatelite->get_tabla('art_articulo',array('art_codigo' => $codigo_categoria . $numero_correlativo[0]));
            if (count($codigox) > 0){
                $numero = $numero_correlativo[0] + 1;
                while ($flag == true) {
                    $codigox = $this->gsatelite->get_tabla('art_articulo',array('art_codigo' => $codigo_categoria.$numero));
                    if (count($codigox) > 0) {
                        $numero++;
                    }else{
                        $flag = false;
                    }
                }
            }            
        }
        $arreglo = array('drop' => $cadena, 'categoria_cod' => $codigo_categoria, 'correlativo' => $numero, 'generado' => $generado, 'code_genera' => $generar_codigo);
        echo json_encode($arreglo);
    }

    public function articulo_tipoxcategoria() {
        $categoria = $this->input->post('categoria');
        $tipo = $this->input->post('tipo');
        $caracteristicas = $this->gsatelite->get_tabla('art_articulo', array('art_tipo' => $tipo, 'art_id_tia' => $categoria));

        $cadena = '<option value="" selected="selected"></opction>';
        foreach ($caracteristicas as $k) {
            $cadena .= '<option value="' . $k['art_id'] . '">' . $k['art_nombre'] . '</option>';
        }
        $arreglo = array('drop' => $cadena);
        echo json_encode($arreglo);
    }

      /**
     * @modify Nelson Soriano
     * @since 27-02-2019
     * @descripcion: Se agrego validacion para la duplicidad de productos, al hacer click mas de una vez en el control
     */

    public function guardar_articulo($ruta_modulo = null) { 
        $valid          = true;
        $codigo_validar = $this->input->post('codigo');
        $rows           = $this->gsatelite->get_tabla('art_articulo',array('art_codigo'=> $codigo_validar,'art_estado'=>1));
        if ( (is_array($rows)) && (count($rows)>0) ) {
            $valid      = false;
        }
        $post_array = $_POST;        
        if($this->input->post('url_send') == "") {
            $ruta = trim($ruta_modulo) != "" ? $ruta_modulo : "inventario/mantenimiento";
        } else {
            $ruta_modulo = $this->input->post('url_send');
            $ruta = trim($ruta_modulo) != "" ? $ruta_modulo : "inventario/mantenimiento";
        }
        //tab 1 insertar primero        
        // funcion para validar que no se dupliquen los registros al precionar varias veces el boton agregar
        if ($valid) {
            $tia_id_tab1 = $this->input->post('categorias'); //select requerido
            $art_codigo_tab1 = $this->input->post('codigo');  //requerido
            $art_codigo_barra_tab1 = (trim($this->input->post('codigo_barra')) != "") ? $this->input->post('codigo_barra') : null;
            $art_nombre_tab1 = $this->input->post('nombre');  //requerido
            $art_sinonimo_tab1 = (trim($this->input->post('sinonimo_art')) != "") ? $this->input->post('sinonimo_art') : null;
            $art_descripcion_tab1 = (trim($this->input->post('descripcion')) != "") ? $this->input->post('descripcion') : null;
            $art_foto_tab1 = (trim($this->input->post('foto_empleado')) != "") ? $this->input->post('foto_empleado') : null;
            $cda_id_tab1 = (trim($this->input->post('codigo_arancelario')) != "") ? $this->input->post('codigo_arancelario') : null;  //select
            $art_tipo_tab1 = (trim($this->input->post('tipo_producto')) != "") ? $this->input->post('tipo_producto') : null; //select
            $art_maximo_tab1 = (trim($this->input->post('maximo')) != "") ? $this->input->post('maximo') : null;
            $art_minimo_tab1 = (trim($this->input->post('minimo')) != "") ? $this->input->post('minimo') : null;
            $precio_sug = ($this->input->post('precio_sug') != '') ? $this->input->post('precio_sug') : null;
            $presentacion = ($this->input->post('presentacion') != '') ? $this->input->post('presentacion') : null;
            $consumo_max = ($this->input->post('max_consumo') != '') ? $this->input->post('max_consumo') : null;
            $dias_cobertura = ($this->input->post('dias_stock') != '') ? $this->input->post('dias_stock') : null;
            $stock_seguridad = ($this->input->post('stock_seguridad') != '') ? $this->input->post('stock_seguridad') : null;

            $art_aplica_serie_tab1 = (trim($this->input->post('serie')) != "") ? 1 : 0; //ibutton
            $art_combo_tab1 = (trim($this->input->post('combo')) != "") ? 1 : 0;  //ibutton

            $art_cuota = (trim($this->input->post('cuota')) != "") ? 1 : 0;  //ibutton
            $art_num_cuota = (trim($this->input->post('txtCantidadCta')) != "") ? trim($this->input->post('txtCantidadCta')) : null;  //textbox
            //Grid despues de insertar el articulo
            $cxr_id_cxu_tab1 = $this->input->post('tipo_caracteristica');  //array
            $cxu_valor_tab1 = $this->input->post('nombre_caracteristica');  //array 
            //Tab2
            $mep_id_cva_tab2 = $this->input->post('medida_conversion'); //array
            $cva_conversion_tab1 = $this->input->post('conversion'); //array
            $cva_equivalente_tab1 = $this->input->post('equivalente'); //array
            $cva_defecto_tab1 = $this->input->post('defecto');  //array
            //Tab3
            $art_inventario_tab3        = (trim($this->input->post('prod_inventario')) != "") ? 1 : 0; //ibutton
            $art_compra_tab3            = (trim($this->input->post('prod_compra')) != "") ? 1 : 0; //ibutton
            $art_venta_tab3             = (trim($this->input->post('prod_venta')) != "") ? 1 : 0; //ibutton
            $art_materia_prima_tab3     = (trim($this->input->post('prod_materiap')) != "") ? 1 : 0;  //ibutton
            $art_gasto_tab3             = (trim($this->input->post('prod_gasto')) != "") ? 1 : 0; //ibutton
            $art_costo_tab3             = (trim($this->input->post('prod_costo')) != "") ? 1 : 0; //ibutton
            $art_activo_fijo_tab3       = (trim($this->input->post('activo_fijo')) != "") ? 1 : 0; //ibutton
            $art_produccion_tab3        = (trim($this->input->post('prod_produccion')) != "") ? 1 : 0; //ibutton
            $art_componente_tab3        = (trim($this->input->post('prod_componente')) != "") ? 1 : 0; //ibutton
            $bod_id                     = (trim($this->input->post('bodega_bod')) != "") ? $this->input->post('bodega_bod') : null;
            $sxb_sectorxbodega          = (trim($this->input->post('sector_sxb')) != "") ? $this->input->post('sector_sxb') : null;
            $slcMarca                   = (trim($this->input->post('slcMarca')) != "") ? $this->input->post('slcMarca') : null;
            $art_aplica_empaque_tab3    = (trim($this->input->post('aplica_empaque')) != "") ? 1 : 0; //ibutton
            $es_modal                   = (trim($this->input->post('es_modal')) === "1") ? 1 : 0; //ibutton
            $art_para_web_tab3          = (trim($this->input->post('para_web')) != "") ? 1 : 0; //ibutton
            $art_anticipo               = (trim($this->input->post('anticipo')) != "") ? 1 : 0; //ibutton
            $categoria_mh               = (trim($this->input->post('categoria_mh')) != "") ? $this->input->post('categoria_mh') : null;
            $referencia_mh              = (trim($this->input->post('referencia_mh')) != "") ? $this->input->post('referencia_mh') : null;
            //Tab 4
            $tgr_id_tab1 = (trim($this->input->post('agrupacion_general_combo')) != "") ? $this->input->post('agrupacion_general_combo') : null; //select
            $id_art_cma = $this->input->post('producto_datos_combo'); //array
            $id_art_mep = $this->input->post('medida_datos_combo'); //array
            $cantidad_cma = $this->input->post('cantidad_datos_combo'); //array

            if (trim($art_codigo_tab1) != "" && trim($art_nombre_tab1) != "" && trim($tia_id_tab1)) {
                $respuesta = $this->db->insert('art_articulo', array(
                    'art_id_tia' => $tia_id_tab1,
                    'art_id_cda' => $cda_id_tab1,
                    'art_id_tgr' => $tgr_id_tab1,
                    'art_id_mrp' => $slcMarca,
                    'art_nombre' => $art_nombre_tab1,
                    'art_codigo' => $art_codigo_tab1,
                    'art_sinonimo' => $art_sinonimo_tab1,
                    'art_descripcion' => $art_descripcion_tab1,
                    'art_foto' => $art_foto_tab1,
                    'art_minimo' => $art_minimo_tab1,
                    'art_maximo' => $art_maximo_tab1,
                    'art_fecha' => date('Y-m-d H:i:s'),
                    'art_tipo' => $art_tipo_tab1,
                    'art_aplica_serie' => $art_aplica_serie_tab1,
                    'art_combo' => $art_combo_tab1,
                    'art_compra' => $art_compra_tab3,
                    'art_inventario' => $art_inventario_tab3,
                    'art_venta' => $art_venta_tab3,
                    'art_materia_prima' => $art_materia_prima_tab3,
                    'art_gasto' => $art_gasto_tab3,
                    'art_costo' => $art_costo_tab3,
                    'art_activo_fijo' => $art_activo_fijo_tab3,
                    'art_produccion'    => $art_produccion_tab3,
                    'art_componente'    => $art_componente_tab3,
                    'art_id_bod'        => $bod_id,
                    'art_id_sxb'        => $sxb_sectorxbodega,
                    'art_aplica_empaque'=> $art_aplica_empaque_tab3,
                    'art_aplica_para_web'=> $art_para_web_tab3,
                    'art_aplica_cuota'  => $art_cuota, 
                    'art_numero_cuota'  => $art_num_cuota,
                    'art_id_ppr'  => $presentacion,
                    'art_consumo_max' => $consumo_max,
                    'art_dias_cobertura' => $dias_cobertura,
                    'art_stock_seguridad' => $stock_seguridad,
                    'art_precio_sugerido' => $precio_sug,
                    'art_referencia_del_bien' => $categoria_mh,
                    'art_referencia_en_libro' => $referencia_mh,
                    'art_estado' => 1,
                    'art_usu_creacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_creacion' => date('Y-m-d H:i:s'),
                    'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'art_anticipo' => $art_anticipo
                ));
                $art_id = $this->db->insert_id();
                /**************************   Agregar Politicas de devolucion *******************************************/
                /************************** Agregado por Nelson Soriano 19-12-18 ****************************************/
                $politicas = $this->input->post('politicasxart');
                if ( is_array($politicas) && count($politicas) > 0) {
                    for ($i=0; $i < count($politicas); $i++) {
                        $politicas_array = array(
                            'pxr_id_pld'             => $politicas[$i],
                            'pxr_id_art'             => $art_id,
                            'pxr_estado'             => 1,
                            'pxr_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'pxr_fecha_creacion'     => date('Y-m-d H-i-s'),
                            'pxr_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'pxr_fecha_modificacion' => date('Y-m-d H-i-s')
                        );
                        $this->gsatelite->ingresar('pxr_politicas_devolucionxarticulo', $politicas_array);
                    }
                }
                for ($x = 0; $x < count($mep_id_cva_tab2); $x++) {
                    if (trim($mep_id_cva_tab2[$x]) != "" && trim($cva_conversion_tab1[$x]) != "" && trim($cva_defecto_tab1[$x]) != "") {
                        $respuesta = $this->db->insert('cva_conversion_articulo', array(
                            'cva_id_mep' => $mep_id_cva_tab2[$x],
                            'cva_id_art' => $art_id,
                            'cva_conversion' => $cva_conversion_tab1[$x],
                            'cva_medida_equivalente' => (trim($cva_equivalente_tab1[$x]) != '')?$cva_equivalente_tab1[$x]:null,
                            'cva_defecto' => $cva_defecto_tab1[$x],
                            'cva_estado' => 1,
                            'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cva_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'cva_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cva_fecha_creacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }
                for ($x = 0; $x < count($cxr_id_cxu_tab1); $x++) {
                    if (trim($cxr_id_cxu_tab1[$x]) != "") {
                        //if (trim($cxr_id_cxu_tab1[$x]) != "" && trim($cxu_valor_tab1[$x]) != "") {
                        $respuesta = $this->db->insert('cxu_caracxarticulo', array(
                            'cxu_id_art' => $art_id,
                            'cxu_id_cxr' => $cxr_id_cxu_tab1[$x],
                            'cxu_valor' => $cxu_valor_tab1[$x],
                            'cxu_estado' => 1,
                            'cxu_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cxu_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cxu_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cxu_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }
                for ($x = 0; $x < count($id_art_cma); $x++) {
                    if (trim($id_art_cma[$x]) != "" && trim($cantidad_cma[$x]) != "") {
                        $respuesta = $this->db->insert('cma_combo_articulo', array(
                            'cma_id_art' => $art_id,
                            'cma_id_art_combo' => $id_art_cma[$x],
                            'cma_id_cva' => $id_art_mep[$x],
                            'cma_cantidad' => $cantidad_cma[$x],
                            'cma_estado' => 1,
                            'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cma_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'cma_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cma_fecha_creacion' => date('Y-m-d H:i:s')
                        ));
                    }
                }
            }
            /*======================= GUARDAR CODIGOS DE PRODUCTO  Add by René Castaneda ============================================*/
            if ($this->input->post('ncodigo_producto')) {
                $ncodigo_producto = $this->input->post('ncodigo_producto');
                $ncodigos = count($ncodigo_producto);
                $array_codigos = array();
                for ($q=0; $q < $ncodigos ; $q++) { 
                    if ($ncodigo_producto[$q] != '') {
                        $array_codigos[] = array(
                            'cdp_id_art' => $art_id
                            ,'cdp_codigo' => $ncodigo_producto[$q]
                            ,'cdp_estado' => 1
                            ,'cdp_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_modificacion' =>  date('Y-m-d H:i:s')
                            ,'cdp_usu_creacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_creacion' =>  date('Y-m-d H:i:s')

                        );
                    }
                }
                if (count($array_codigos) > 0 ) {
                    $this->gsatelite->ingresar('cdp_codigo_producto',$array_codigos,true);
                }
            }
            // CODIGOS DE COMPRA PARA LECTOR DE JSON
            if ($this->input->post('code_producto_compra')) {
                $id_compra_mep = $this->input->post('id_medida_compra');
                $id_compra_prv = $this->input->post('id_proveedor_compra');
                $codes_compras = $this->input->post('code_producto_compra');
                $array_code_compra = array();
                foreach ($codes_compras as $k => $value) {
                    if (trim($value) !="") {
                        $array_code_compra[] = array(
                            'cpc_id_art' => $art_id,
                            'cpc_id_prv' => $id_compra_prv[$k],
                            'cpc_id_mep' => $id_compra_mep[$k],
                            'cpc_codigo' => $value,
                            'cpc_estado' => 1,
                            'cpc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpc_fecha_modificacion' =>  date('Y-m-d H:i:s'),
                            'cpc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpc_fecha_creacion' =>  date('Y-m-d H:i:s')
                        );
                    }
                }
                if (count($array_code_compra) > 0 ) {
                    $this->gsatelite->ingresar("cpc_codigo_producto_compras", $array_code_compra, true);
                }
            }
            /*======================= FIN GUARDAR CODIGOS DE PRODCUTO ============================================*/

            /*======================= GUARDAR MINIMO-MAXIMO POR BODEGA  ============================================*/
            if ($this->input->post('bodega_min_max')) {
                $bodega_min_max   = $this->input->post('bodega_min_max');
                $minimos   = $this->input->post('min_val');
                $maximos   = $this->input->post('max_val');
                $nbodegas_MinMax  = count($bodega_min_max);
                $array_MinMax = array();
                for ($l=0; $l < $nbodegas_MinMax ; $l++) { 
                    if ($bodega_min_max[$l] != '') {
                        $array_MinMax[] = array(
                            'mma_id_art'    => $art_id
                            ,'mma_id_bod'   => $bodega_min_max[$l]
                            ,'mma_minimo'   => ($minimos[$l] != "") ? $minimos[$l] : null
                            ,'mma_maximo'   => ($maximos[$l] != "") ? $maximos[$l] : null
                            ,'mma_estado'   => 1
                            ,'mma_usu_creacion'     => $this->tank_auth->get_user_id()
                            ,'mma_fecha_creacion'   =>  date('Y-m-d H:i:s')
                            ,'mma_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'mma_fecha_modificacion' =>  date('Y-m-d H:i:s')

                        );
                    }
                }

                if (count($array_MinMax) > 0 ) {
                   $this->gsatelite->ingresar('mma_mimino_maximoxarticulo', $array_MinMax, true);
                }
            }
            /*======================= FIN GUARDAR MINIMO-MAXIMO POR BODEGA  =========================================*/

            /*======================= GUARDAR GALERIA IMAGENES  ============================================*/        
            if (isset($post_array['titulo_doc'])) {
                for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                    $carpeta_temporal_anx = "public/temp/anx_galeria_articulo/" . trim($post_array['ruta'][$i]);
                    $ruta_anexo =  time()."_".trim($post_array['ruta'][$i]);
                    $carpeta_destino_anx = "uploads/anx_galeria_articulo/" . $ruta_anexo;

                    $datos_anexo = array(
                        'gia_id_art'    => $art_id,
                        'gia_url'       => $ruta_anexo,
                        'gia_nombre'    => $post_array['titulo_doc'][$i],                    
                        'gia_codigo_color'    => $post_array['rgb'][$i],                    
                        'gia_estado'                => 1,
                        'gia_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'gia_fecha_creacion'        => date('Y-m-d H:i:s'),
                        'gia_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'gia_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('gia_galeria_imagen_articulo', $datos_anexo);

                    @copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    @unlink($carpeta_temporal_anx);
                }
            }
            /*======================= FIN GUARDAR GALERIA IMAGENES  ============================================*/

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de artículos", 'texto_alerta' => "El registro se guardó correctamente");

            $this->session->set_flashdata($alerta);

            $mod = $this->input->post('modulo');
            $fac = $this->input->post('facturacion');
            $coti = $this->input->post('cotizaciones');
            $proy = $this->input->post('proyectos');
            $red = $this->input->post('redireccion');
            $modulo_contratos = $this->input->post('modulo_contratos');
            $compras = $this->input->post('modulo_compras');        

            // Verificar si viene de un modal
            if ($es_modal === 1) {
                $modulo = (int)$mod;
                $alerta['registroProcesado'] = 1;
                $alerta['direccion'] = 2;
                $this->session->set_flashdata($alerta);
                redirect($ruta.'/agregar_articulo/'.$modulo.'/1');
                die();
            }

            if ($coti == 1) {
                if ($red == 1) { 
                    redirect($ruta.'/articulo');
                }else{
                    redirect($ruta.'/agregar_articulo/3');
                }
            } elseif ($proy == 1) {
                if ($red == 1) {
                    redirect('/proyectos/mantenimientos/articulo');
                }else{
                    redirect('/proyectos/mantenimientos/agregar_articulo/2');
                }
            } elseif ($modulo_contratos == 1) {
                if ($red == 1) {
                    redirect('/modulo_contratos/catalogos/servicios');
                }else{
                    redirect('/modulo_contratos/catalogos/agregar_articulo/8');
                }
            } elseif ($fac == 1) {
                redirect('/facturacion/entradas/articulo');
            } elseif ($compras == 1) {
                redirect($ruta.'/agregar_articulo');
            } else {
                if ($red == 1) {
                    redirect($ruta.'/articulo');
                } else {
                    redirect($ruta.'/agregar_articulo');
                }
            }
        }else{
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de artículos", 'texto_alerta' => "El registro se guardó correctamente");
            $this->session->set_flashdata($alerta);

            $mod = $this->input->post('modulo');
            $fac = $this->input->post('facturacion');
            $coti = $this->input->post('cotizaciones');
            $proy = $this->input->post('proyectos');
            $red = $this->input->post('redireccion');
            $modulo_contratos = $this->input->post('modulo_contratos');
            $compras = $this->input->post('modulo_compras');        

                // Verificar si viene de un modal
            if ($es_modal === 1) {
                $modulo = (int)$mod;
                $alerta['registroProcesado'] = 1;
                $alerta['direccion'] = 2;
                $this->session->set_flashdata($alerta);
                redirect($ruta.'/agregar_articulo/'.$modulo.'/1');
                die();
            }

            if ($coti == 1) {
                if ($red == 1) { 
                    redirect($ruta.'/articulo');
                }else{
                    redirect($ruta.'/agregar_articulo/3');
                }
            } elseif ($proy == 1) {
                if ($red == 1) {
                    redirect('/proyectos/mantenimientos/articulo');
                }else{
                    redirect('/proyectos/mantenimientos/agregar_articulo/2');
                }
            } elseif ($modulo_contratos == 1) {
                if ($red == 1) {
                    redirect('/modulo_contratos/catalogos/servicios');
                }else{
                    redirect('/modulo_contratos/catalogos/agregar_articulo/8');
                }
            } elseif ($fac == 1) {
                redirect('/facturacion/entradas/articulo');
            } elseif ($compras == 1) {
                redirect($ruta.'/agregar_articulo');
            } else {
                if ($red == 1) {
                    redirect($ruta.'/articulo');
                } else {
                    redirect($ruta.'/agregar_articulo');
                }
            }
        }
    }

    public function caracteristicas($ruta_modulo = "inventario/mantenimiento/caracteristicas") {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion($ruta_modulo);
            $url_array = explode('/', uri_string());
            $crud = $this->new_crud();

            //Columnas a mostrar en READ
            $columns = array(
                //'car_codigo',
                'car_nombre',
                'car_descripcion'
            );

            //Alias para las columnas
            $alias = array(
                //'car_codigo' => 'Código',
                'car_nombre' => 'Nombre',
                'car_descripcion' => 'Descripción',
                'car_estado' => 'Estado'
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
               // 'car_codigo',
                'car_nombre',
                'car_descripcion',
                'car_estado',
                'car_usu_mod',
                'car_fecha_mod',
                'car_usu_crea',
                'car_fecha_crea'
            );


            $req_columns = array(
                'car_nombre',
                'car_estado'
            );

            $crud->set_table('car_caracteristica')
                ->set_subject('')
                ->columns($columns)
                ->display_as($alias) /* LUEGO REVISAR PORQUE ESTE CODIGO CREO QUE NI SE USA */
                ->add_fields($add_columns)
                ->required_fields($req_columns)
                ->field_type('car_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('car_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('car_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('car_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                ->set_rules('car_nombre', 'Nombre de la característica', 'trim|required|callback_caracteristica_nombre_unico')
            ;            /* LUEGO REVISAR PORQUE ESTE CODIGO CREO QUE NI SE USA O SE SOVREESCRIBE LA URL */
            if (end($url_array) == 'add') {
                $crud->field_type('car_estado', 'hidden', 1);
            } else {
                $crud->field_type('car_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            /* LUEGO REVISAR PORQUE ESTE CODIGO CREO QUE NI SE USA O SE SOVREESCRIBE LA URL */
            $crud->callback_add_field('car_codigo', function () {
                $tabla = 'car_caracteristica';
                $campo = 'car_codigo';
                $last = $this->inventario_model->get_max_codigo($tabla, $campo);
                $code = $last->codigo;
                $cod = (int) $code + 1;
                $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
            });
            $crud->callback_edit_field('car_codigo', function ($value, $primary_key) {
                if ($value == '') {
                    $tabla = 'car_caracteristica';
                    $campo = 'car_codigo';
                    $last = $this->inventario_model->get_max_codigo($tabla, $campo);
                    $code = $last->codigo;
                    $cod = (int) $code + 1;
                    $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
                } else {
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $value . '" >';
                }
            });
            $crud->edit_fields($add_columns);

            // Validaciones
            $crud->unset_add();
            $data['agregar'] = true;
            if (!$permisos['permite_agregar']) {
                $data['agregar'] = false;
            }

            $crud->unset_edit();
            if ($permisos['permite_editar']) {
                if ($ruta_modulo != "inventario/mantenimiento/caracteristicas") {
                    $ruta = explode("/", $ruta_modulo);
                    $crud->add_action('Editar', 'minia-icon-pencil', base_url().$ruta[0].'/'.$ruta[1].'/caracteristicas_editar/');
                } else {
                    $crud->add_action('Editar', 'minia-icon-pencil', base_url().'inventario/mantenimiento/caracteristicas_editar/');
                }
            }

            $crud->unset_delete();
            if ($permisos['permite_eliminar']) {
                if ($ruta_modulo != "inventario/mantenimiento/caracteristicas") {
                    $ruta = explode("/", $ruta_modulo);
                    $crud->add_action('Borrar', 'icon16 icomoon-icon-remove', base_url().$ruta[0].'/'.$ruta[1].'/caracteristicas_eliminar/');
                } else {
                    $crud->add_action('Borrar', 'icon16 icomoon-icon-remove', base_url().'inventario/mantenimiento/caracteristicas_eliminar/');
                }
            }

            if ($permisos['permite_ver']) {
                if ($ruta_modulo != "inventario/mantenimiento/caracteristicas") {
                    $ruta = explode("/", $ruta_modulo);
                    $crud->add_action('Ver', 'minia-icon-search', base_url().$ruta[0].'/'.$ruta[1].'/caracteristicas_ver/');
                } else {
                    $crud->add_action('Ver', 'minia-icon-search', base_url().'inventario/mantenimiento/caracteristicas_ver/');
                }
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de características";
            $data['otro_modulo'] = ($ruta_modulo != "inventario/mantenimiento/caracteristicas") ? $ruta_modulo : "";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * @author Boris Estrada
     * Si modulo es 3 = cotizaciones/mantenimientos/articulo. (Francisco Orozco 07-11-2017)
     * si modulo es 2 = proyectos/mantenimientos/articulo. (Francisco Orozco 07-11-2017)
     * si modulo es 4 = tarificador/procesos/articulo. (Francisco Orozco 07-11-2017)
     * si modulo es 7 = ??. (Francisco Orozco 07-11-2017)
     * si modulo es 8 = modulo_contratos/catalogos/servicios (Francisco Orozco 07-11-2017)
     * @modify: Nelson Soriano-19-12-2018-agregacion de politicas de devolucion
     */
    public function agregar_articulo($modulo = null, $otro_modulo = null, $ruta_modulo = null) {
        $data['dias_mes'] = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
        $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');

        $ruta = trim($ruta_modulo) != "" ? $ruta_modulo : "inventario/mantenimiento";

        /* CASO ALFAGEOMATICS SE ESTA USANDO ESTA TABLA PARA GUARDAR LA CUENTA CONTABLE DEL PRODUCTO PERO SOLO A NIVEL INFORMATIVO */
        $select = $this->gsatelite->get_dropdown('cda_codigo_arancelario', '{cda_codigo} {cda_descripcion}', '', array('cda_estado' => 1), null, '', 'cda_id', true);
        $data["codigo_arancelario"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1, 'tia_padre' => null), null, '', 'tia_id', true);
        $data["categorias"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => 1), null, '', 'mep_id', true);
        $data["medida_producto"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('tgr_tipo_agrupacion', '{tgr_nombre}', '', array('tgr_estado' => 1), null, '', 'tgr_id', true);
        $data["tipo_agrupacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
        $data["bodega_bod"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

        $tic_com = $this->gsatelite->get_dropdown('tic_tipo_comision', '{tic_nombre}', '', array('tic_estado' => 1), null, '', 'tic_id', true);
        $data["comision"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tic_com);

        $tip_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
        $data["tipo_pago"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tip_pago);

        $marcas = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', array('mrp_estado' => 1), null, '', 'mrp_id', true);
        $data["marcas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $marcas);

        $presentacion = $this->gsatelite->get_dropdown('ppr_presentacion_producto', '{ppr_nombre}', '', array('ppr_estado' => 1), null, '', 'ppr_id', true);
        $data["presentacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $presentacion);

        $configuracion_producto = $this->gsatelite->get_parametro('SYS_CONF_PROD', 0);
        $conf_prod_array = json_decode($configuracion_producto, true);

        $data['ibutton_inventario'] = $conf_prod_array['INVENTARIO'];
        $data['ibutton_compra'] = $conf_prod_array['COMPRA'];
        $data['ibutton_venta'] = $conf_prod_array['VENTA'];        

        $data['mod'] = 1;

        if($modulo == 2){ $data['mod'] = 2; }
        if($modulo == 3){ $data['mod'] = 3; }
        if($modulo == 7 ){ $data['mod'] = 7; }
        if($modulo == 13){ $data["mod"] = 13;}
        $data['ruta_modulo'] = $ruta;
       
        $data['titulo_personal'] = "Agregar producto";
        if($modulo == 8 ){ 
            $data['mod'] = 8; 
            $data['titulo_personal'] = "Agregar producto - servicio";
        }

        // Verificar si es modal
        $es_modal = (is_numeric($otro_modulo) && (int)$otro_modulo === 1) ? 1 : 0;
        $data['es_modal'] = $es_modal;
        $data['politicas'] = $this->gsatelite->get_dropdown('pld_politica_devolucion', 'pld_nombre', 'politicas', array('pld_estado' => 1), null, null, false, true);
        $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo,prv_nombre,prv_apellido) ELSE CONCAT_WS(' ',prv_apellido) End]", '', array('prv_estado' => 1), null, null, null, true);
        $data['ruta_modulo'] = $ruta;
        if($ruta == "proyectos/mantenimientos") {
            $data['ruta_modulo'] = $ruta;
            return $data;
        } else {
            if ($es_modal === 1) {
                $this->gsatelite->cargar_vista_masterpage("inventario/mantenimiento/agregar_articulo", $data, true);
            } else {
                cargarvista($data, null, "inventario/mantenimiento/agregar_articulo");
            }
        }

    }

    public function editar_articulo($articulo, $modulo = null, $ruta_modulo = null) {
        if ($_POST) {
            $post_array = $_POST;
            // var_dump($post_array);die();
            $ruta = trim($ruta_modulo) != "" ? $ruta_modulo : "inventario/mantenimiento";
            $art_id = $this->input->post('articulo_id'); //select requerido
            //tab 1
            $tia_id_tab1 = $this->input->post('categorias'); //select requerido
            $art_codigo_tab1 = $this->input->post('codigo');  //requerido
            $art_codigo_barra_tab1 = (trim($this->input->post('codigo_barra')) != "") ? $this->input->post('codigo_barra') : null;
            $art_nombre_tab1 = $this->input->post('nombre');  //requerido
            $art_sinonimo_tab1 = (trim($this->input->post('sinonimo_art')) != "") ? $this->input->post('sinonimo_art') : null;
            $art_descripcion_tab1 = (trim($this->input->post('descripcion')) != "") ? $this->input->post('descripcion') : null;
            $estado = $this->input->post('estado'); //requerido

            $art_foto_tab1 = (trim($this->input->post('foto_empleado')) != "") ? $this->input->post('foto_empleado') : null;
            $cda_id_tab1 = (trim($this->input->post('codigo_arancelario')) != "") ? $this->input->post('codigo_arancelario') : null;  //select
            $art_tipo_tab1 = (trim($this->input->post('tipo_producto')) != "") ? $this->input->post('tipo_producto') : null; //select
            $art_maximo_tab1 = (trim($this->input->post('maximo')) != "") ? $this->input->post('maximo') : null;
            $art_minimo_tab1 = (trim($this->input->post('minimo')) != "") ? $this->input->post('minimo') : null;
            $precio_sug = ($this->input->post('precio_sug') != '') ? $this->input->post('precio_sug') : null;
            $art_aplica_serie_tab1 = (trim($this->input->post('serie')) != "") ? 1 : 0; //ibutton
            $art_combo_tab1 = (trim($this->input->post('combo')) != "") ? 1 : 0;  //ibutton

            $art_cuota = (trim($this->input->post('cuota')) != "") ? 1 : 0;  //ibutton
            $art_num_cuota = (trim($this->input->post('txtCantidadCta')) != "") ? trim($this->input->post('txtCantidadCta')) : null;  //textbox
            //tab3
            $art_inventario_tab3 = (trim($this->input->post('prod_inventario')) != "") ? 1 : 0; //ibutton
            $art_compra_tab3 = (trim($this->input->post('prod_compra')) != "") ? 1 : 0; //ibutton
            $art_venta_tab3 = (trim($this->input->post('prod_venta')) != "") ? 1 : 0; //ibutton
            $art_materia_prima_tab3 = (trim($this->input->post('prod_materiap')) != "") ? 1 : 0;  //ibutton
            $art_gasto_tab3 = (trim($this->input->post('prod_gasto')) != "") ? 1 : 0; //ibutton
            $art_costo_tab3 = (trim($this->input->post('prod_costo')) != "") ? 1 : 0; //ibutton
            $art_activo_fijo_tab3 = (trim($this->input->post('activo_fijo')) != "") ? 1 : 0; //ibutton
            $art_produccion_tab3 = (trim($this->input->post('prod_produccion')) != "") ? 1 : 0; //ibutton
            $art_componente_tab3 = (trim($this->input->post('prod_componente')) != "") ? 1 : 0; //ibutton
            $art_aplica_empaque_tab3    = (trim($this->input->post('aplica_empaque')) != "") ? 1 : 0; //ibutton
            $art_para_web_tab3          = (trim($this->input->post('para_web')) != "") ? 1 : 0; //ibutton
            $art_anticipo          = (trim($this->input->post('anticipo')) != "") ? 1 : 0; //ibutton
            $consumo_max = ($this->input->post('max_consumo') != '') ? $this->input->post('max_consumo') : null;
            $dias_cobertura = ($this->input->post('dias_stock') != '') ? $this->input->post('dias_stock') : null;
            $stock_seguridad = ($this->input->post('stock_seguridad') != '') ? $this->input->post('stock_seguridad') : null;
            $categoria_mh = ($this->input->post('categoria_mh') != "") ? $this->input->post('categoria_mh') : null;
            $referencia_mh = ($this->input->post('referencia_mh') != "") ? $this->input->post('referencia_mh') : null;

            $bod_id = (trim($this->input->post('bodega_bod')) != "") ? $this->input->post('bodega_bod') : null;
            $sxb_sectorxbodega = (trim($this->input->post('sector_sxb')) != "") ? $this->input->post('sector_sxb') : null;

            $tgr_id_tab1 = (trim($this->input->post('agrupacion_general_combo')) != "") ? $this->input->post('agrupacion_general_combo') : null; //select
            $slcMarca = (trim($this->input->post('slcMarca')) != "") ? $this->input->post('slcMarca') : null;

            $presentacion = ($this->input->post('presentacion') != '') ? $this->input->post('presentacion') : null;
            if (trim($art_codigo_tab1) != "" && trim($art_nombre_tab1) != "" && trim($tia_id_tab1) != "" && trim($estado) != "") {
                $cadena = array(
                    'art_id_tia' => $tia_id_tab1,
                    'art_id_cda' => $cda_id_tab1,
                    'art_id_tgr' => $tgr_id_tab1,
                    'art_id_bod' => $bod_id,
                    'art_id_mrp' => $slcMarca,
                    'art_id_sxb' => $sxb_sectorxbodega,
                    'art_nombre' => $art_nombre_tab1,
                    'art_codigo' => $art_codigo_tab1,
                    'art_sinonimo' => $art_sinonimo_tab1,
                    'art_descripcion' => $art_descripcion_tab1,
                    'art_foto' => $art_foto_tab1,
                    'art_minimo' => $art_minimo_tab1,
                    'art_maximo' => $art_maximo_tab1,
                    'art_fecha' => date('Y-m-d H:i:s'),
                    'art_tipo' => $art_tipo_tab1,
                    'art_aplica_serie' => $art_aplica_serie_tab1,
                    'art_combo' => $art_combo_tab1,
                    'art_compra' => $art_compra_tab3,
                    'art_inventario' => $art_inventario_tab3,
                    'art_venta' => $art_venta_tab3,
                    'art_id_ppr'  => $presentacion,
                    'art_materia_prima' => $art_materia_prima_tab3,
                    'art_gasto' => $art_gasto_tab3,
                    'art_costo' => $art_costo_tab3,
                    'art_consumo_max' => $consumo_max,
                    'art_dias_cobertura' => $dias_cobertura,
                    'art_stock_seguridad' => $stock_seguridad,
                    'art_activo_fijo' => $art_activo_fijo_tab3,
                    'art_produccion' => $art_produccion_tab3,
                    'art_componente' => $art_componente_tab3,
                    'art_precio_sugerido' => $precio_sug,
                    'art_aplica_empaque'=> $art_aplica_empaque_tab3,
                    'art_aplica_para_web'=> $art_para_web_tab3,
                    'art_referencia_del_bien' => $categoria_mh,
                    'art_referencia_en_libro' => $referencia_mh,
                    'art_estado' => $estado,
                    'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'art_anticipo' => $art_anticipo
                );
                $this->gsatelite->actualizar_array('art_articulo', $cadena, array('art_id' => $art_id));
            }
            //editar politicas de devolucion//
            $politicas_edit = $this->input->post('politicasxartupdate');           
            if (is_array($politicas_edit)) {
                $this->gsatelite->borrado_general('pxr_politicas_devolucionxarticulo', array('pxr_id_art'=>$art_id));
                for ($i=0; $i < count($politicas_edit); $i++) {
                    $politicas_array = array(
                        'pxr_id_pld'             => $politicas_edit[$i],
                        'pxr_id_art'             => $art_id,
                        'pxr_estado'             => 1,
                        'pxr_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'pxr_fecha_creacion'     => date('Y-m-d H-i-s'),
                        'pxr_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'pxr_fecha_modificacion' => date('Y-m-d H-i-s')
                    );
                    $this->gsatelite->ingresar('pxr_politicas_devolucionxarticulo', $politicas_array);
                }
            }else{
                $this->gsatelite->borrado_general('pxr_politicas_devolucionxarticulo', array('pxr_id_art'=>$art_id));
            }

            /* =============================================================================================================
              =                                      GRID TAB 1
              ================================================================================================================
             */
            $id_cxu_tab1 = $this->input->post('id_cxu_tab1');  //array id_cxu
            $cxr_id_cxu_tab1 = $this->input->post('tipo_caracteristica');  //array
            $cxu_valor_tab1 = $this->input->post('nombre_caracteristica');  //array 
            $consula_cxu = $this->gsatelite->get_tabla('cxu_caracxarticulo', array('cxu_id_art' => $art_id, 'cxu_estado' => 1));
            $registros_cxu = array();
            foreach ($consula_cxu as $rcxu) {
                $registros_cxu[] = $rcxu['cxu_id'];
            }
            for ($x = 0; $x < count($cxr_id_cxu_tab1); $x++) {
                if (trim($cxr_id_cxu_tab1[$x]) != "") {
                    if (!in_array($id_cxu_tab1[$x], $registros_cxu)) { //preguntar si se ha elegido uno nuevo
                        $this->db->insert('cxu_caracxarticulo', array(
                            'cxu_id_art' => $art_id,
                            'cxu_id_cxr' => $cxr_id_cxu_tab1[$x],
                            'cxu_valor' => $cxu_valor_tab1[$x],
                            'cxu_estado' => 1,
                            'cxu_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cxu_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cxu_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cxu_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {// si existe unicamente actualizar los campos de auditoria
                        $cadena = array(
                            'cxu_id_cxr' => $cxr_id_cxu_tab1[$x],
                            'cxu_valor' => $cxu_valor_tab1[$x],
                            'cxu_estado' => 1,
                            'cxu_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cxu_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cxu_caracxarticulo', $cadena, array('cxu_id_art' => $art_id, 'cxu_id' => $id_cxu_tab1[$x], 'cxu_estado' => 1));
                    }
                }
            }
            for ($kcxu = 0; $kcxu < count($registros_cxu); $kcxu++) {
                if (!in_array($registros_cxu[$kcxu], $id_cxu_tab1)) {
                    $cadena = array(
                        'cxu_estado' => 0,
                        'cxu_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cxu_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cxu_caracxarticulo', $cadena, array('cxu_id_art' => $art_id, 'cxu_id' => $registros_cxu[$kcxu], 'cxu_estado' => 1));
                }
            }
            /* =============================================================================================================
              =                                      GRID TAB 2
              ================================================================================================================
             */
            $id_cva_tab2 = $this->input->post('id_cva_tab2'); //array id_cva
            $mep_id_cva_tab2 = $this->input->post('medida_conversion'); //array
            $cva_conversion_tab1 = $this->input->post('conversion'); //array
            $cva_equivalente_tab1 = $this->input->post('equivalente'); //array
            $cva_defecto_tab1 = $this->input->post('defecto');  //array

            $consula_cva = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $art_id, 'cva_estado' => 1));
            $registros_cva = array();
            foreach ($consula_cva as $rcva) {
                $registros_cva[] = $rcva['cva_id'];
            }
            for ($x = 0; $x < count($mep_id_cva_tab2); $x++) {
                if (trim($mep_id_cva_tab2[$x]) != "" && trim($cva_conversion_tab1[$x]) != "" && trim($cva_defecto_tab1[$x]) != "") {
                    if (!in_array($id_cva_tab2[$x], $registros_cva)) { //preguntar si se ha elegido uno nuevo
                        $this->db->insert('cva_conversion_articulo', array(
                            'cva_id_mep' => $mep_id_cva_tab2[$x],
                            'cva_id_art' => $art_id,
                            'cva_conversion' => $cva_conversion_tab1[$x],
                            'cva_medida_equivalente' => (trim($cva_equivalente_tab1[$x]) != '')?$cva_equivalente_tab1[$x]:null,
                            'cva_defecto' => $cva_defecto_tab1[$x],
                            'cva_estado' => 1,
                            'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cva_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'cva_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cva_fecha_creacion' => date('Y-m-d H:i:s')
                        ));
                    } else {// si existe unicamente actualizar los campos de auditoria
                        $cadena = array(
                            'cva_id_mep' => $mep_id_cva_tab2[$x],
                            'cva_conversion' => $cva_conversion_tab1[$x],
                            'cva_medida_equivalente' => (trim($cva_equivalente_tab1[$x]) != '')?$cva_equivalente_tab1[$x]:null,
                            'cva_defecto' => $cva_defecto_tab1[$x],
                            'cva_estado' => 1,
                            'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cva_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cva_conversion_articulo', $cadena, array('cva_id_art' => $art_id, 'cva_id' => $id_cva_tab2[$x], 'cva_estado' => 1));
                    }
                }
            }

            for ($kcva = 0; $kcva < count($registros_cva); $kcva++) {
                if (!in_array($registros_cva[$kcva], $id_cva_tab2)) {
                    $cadena = array(
                        'cva_defecto' => 0,
                        'cva_estado' => 0,
                        'cva_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cva_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cva_conversion_articulo', $cadena, array('cva_id_art' => $art_id, 'cva_id' => $registros_cva[$kcva], 'cva_estado' => 1));
                }
            }
            /* =============================================================================================================
              =                                      GRID TAB 3
              ================================================================================================================
             */
            //tab 4
            $id_cma_combo = $this->input->post('id_cma_combo'); //array id_cma
            $id_art_cma = $this->input->post('producto_datos_combo'); //array
            $id_art_mep = $this->input->post('medida_datos_combo'); //array
            $cantidad_cma = $this->input->post('cantidad_datos_combo'); //array
            $consula_cma = $this->gsatelite->get_tabla('cma_combo_articulo', array('cma_id_art' => $art_id, 'cma_estado' => 1));
            $registros_cma = array();
            foreach ($consula_cma as $rcma) {
                $registros_cma[] = $rcma['cma_id'];
            }

            for ($x = 0; $x < count($id_art_cma); $x++) {
                if (trim($id_art_cma[$x]) != "" && trim($cantidad_cma[$x]) != "") {
                    if (!in_array($id_cma_combo[$x], $registros_cma)) { //preguntar si se ha elegido uno nuevo
                        $this->db->insert('cma_combo_articulo', array(
                            'cma_id_art' => $art_id,
                            'cma_id_art_combo' => $id_art_cma[$x],
                            'cma_id_cva' => $id_art_mep[$x],
                            'cma_cantidad' => $cantidad_cma[$x],
                            'cma_estado' => 1,
                            'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cma_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'cma_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cma_fecha_creacion' => date('Y-m-d H:i:s')
                        ));
                    } else {// si existe unicamente actualizar los campos de auditoria
                        $cadena = array(
                            'cma_id_art_combo' => $id_art_cma[$x],
                            'cma_cantidad' => $cantidad_cma[$x],
                            'cma_estado' => 1,
                            'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cma_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cma_combo_articulo', $cadena, array('cma_id_art' => $art_id, 'cma_id' => $id_cma_combo[$x], 'cma_estado' => 1));
                    }
                }
            }

            for ($kcma = 0; $kcma < count($registros_cma); $kcma++) {
                if (!in_array($registros_cma[$kcma], $id_cma_combo)) {
                    $cadena = array(
                        'cma_estado' => 0,
                        'cma_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cma_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cma_combo_articulo', $cadena, array('cma_id_art' => $art_id, 'cma_id' => $registros_cma[$kcma], 'cma_estado' => 1));
                }
            }


            /*======================= GUARDAR CODIGOS DE PRODUCTO  Add by René Castaneda ============================================*/
            if ($this->input->post('ncodigo_producto')) {                
                #Consultando los códigos actuales para validar la actualización sobre los existentes.
                $codigos_actuales_pro = $this->gsatelite->get_tabla('cdp_codigo_producto', array('cdp_id_art'=>$art_id));
                $array_codigo_actuales = array();
                $codigos_actuales_ids = array();
                $codigos_actuales_ids2 = array();
                foreach ($codigos_actuales_pro as $ca) {
                    $codigos_actuales[$ca['cdp_id']] = $ca['cdp_codigo'];
                    $codigos_actuales_ids[clean_string($ca['cdp_codigo'])] = $ca['cdp_id'];
                    $codigos_actuales_ids2[] = $ca['cdp_id'];
                }
                $ncodigo_producto_ids = $this->input->post('ncodigo_producto_ids');
                $ncodigo_producto = $this->input->post('ncodigo_producto');
                $ncodigos = count($ncodigo_producto);
                $array_codigos = array();
                for ($q=0; $q < $ncodigos ; $q++) { 
                    if ($ncodigo_producto[$q] != '' and !in_array($ncodigo_producto[$q], $codigos_actuales) ) {
                        $array_codigos[] = array(
                            'cdp_id_art' => $art_id
                            ,'cdp_codigo' => $ncodigo_producto[$q]
                            ,'cdp_estado' => 1
                            ,'cdp_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_modificacion' =>  date('Y-m-d H:i:s')
                            ,'cdp_usu_creacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_creacion' =>  date('Y-m-d H:i:s')

                        );
                    } elseif ($ncodigo_producto[$q] != '' and in_array($ncodigo_producto[$q], $codigos_actuales)) {
                        $ncodigo_producto_ids[] = $codigos_actuales_ids[clean_string($ncodigo_producto[$q])];
                        $array_codigos_update = array(
                            'cdp_id_art' => $art_id
                            ,'cdp_codigo' => $ncodigo_producto[$q]
                            ,'cdp_estado' => 1
                            ,'cdp_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_modificacion' =>  date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cdp_codigo_producto',$array_codigos_update,array('cdp_id'=>$codigos_actuales_ids[$ncodigo_producto[$q]]));
                    }
                }
                if (count($array_codigos) > 0 ) {
                   $this->gsatelite->ingresar('cdp_codigo_producto',$array_codigos,true);
                }

                //DESACTIVAR LOS CÓDIGOS QUE NO SE UTILIZARÁN (NO SE ELIMINAN PARA DEJAR BITACORÁ)
                $ncodigo_producto_ids = array_unique($ncodigo_producto_ids);
                for ($p=0; $p < count($codigos_actuales_ids2) ; $p++) { 
                    //print_r($codigos_actuales_ids2); die();
                    if (!in_array($codigos_actuales_ids2[$p], $ncodigo_producto_ids)) { //si no esta en el arreglo es porque fue eliminado
                        $array_codigos_update = array(
                            'cdp_estado' => 0
                            ,'cdp_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'cdp_fecha_modificacion' =>  date('Y-m-d H:i:s')
                        );
                            $this->gsatelite->actualizar_array('cdp_codigo_producto',$array_codigos_update,array('cdp_id'=>$codigos_actuales_ids2[$p]));
                    }
                }                
            } else {
                $array_codigos_update = array(
                    'cdp_estado' => 0
                    ,'cdp_usu_modificacion' => $this->tank_auth->get_user_id()
                    ,'cdp_fecha_modificacion' =>  date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cdp_codigo_producto',$array_codigos_update,array('cdp_id_art'=>$art_id));
            }
            // CODIGOS DE COMPRA PARA LECTOR DE JSON
            if ($this->input->post('id_cpc')) {
                $id_cpc = $this->input->post('id_cpc');
                $cpc_actual = $this->gsatelite->get_tabla('cpc_codigo_producto_compras', array('cpc_id_art' => $art_id));
                foreach ($cpc_actual as $a => $v) {
                    if (!(in_array($v['cpc_id'], $id_cpc))) {
                        $array_compras_update = array(
                            'cpc_estado' => 0,
                            'cpc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpc_fecha_modificacion' =>  date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cpc_codigo_producto_compras',$array_compras_update,array('cpc_id' => $v['cpc_id']));
                    }
                }
                $id_compra_mep = $this->input->post('id_medida_compra');
                $id_compra_prv = $this->input->post('id_proveedor_compra');
                $codes_compras = $this->input->post('code_producto_compra');
                foreach ($id_cpc as $k => $value) {
                    if ($value == 0) {
                        $array_code_compra = array(
                            'cpc_id_art' => $art_id,
                            'cpc_id_prv' => $id_compra_prv[$k],
                            'cpc_id_mep' => $id_compra_mep[$k],
                            'cpc_codigo' => $codes_compras[$k],
                            'cpc_estado' => 1,
                            'cpc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpc_fecha_modificacion' =>  date('Y-m-d H:i:s'),
                            'cpc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpc_fecha_creacion' =>  date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('cpc_codigo_producto_compras', $array_code_compra);
                    }
                }
            } else {
                $array_compras_update = array(
                    'cpc_estado' => 0,
                    'cpc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cpc_fecha_modificacion' =>  date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cpc_codigo_producto_compras',$array_compras_update,array('cpc_id_art' => $art_id));
            }
            /*======================= FIN GUARDAR CODIGOS DE PRODCUTO ============================================*/

            /*======================= GUARDAR Minimo-Maximo =====================================================*/
            $this->gsatelite->borrado_general('mma_mimino_maximoxarticulo', array('mma_id_art'=>$art_id));
            if ($this->input->post('bodega_min_max')) {

                $bodega_min_max   = $this->input->post('bodega_min_max');
                $minimos          = $this->input->post('min_val');
                $maximos          = $this->input->post('max_val');
                $nbodegas_MinMax  = count($bodega_min_max);
                $array_MinMax = array();
                for ($l=0; $l < $nbodegas_MinMax ; $l++) { 
                    if ($bodega_min_max[$l] != '') {
                        $array_MinMax[] = array(
                            'mma_id_art'    => $art_id
                            ,'mma_id_bod'   => $bodega_min_max[$l]
                            ,'mma_minimo'   => ($minimos[$l] != "") ? $minimos[$l] : null
                            ,'mma_maximo'   => ($maximos[$l] != "") ? $maximos[$l] : null
                            ,'mma_estado'   => 1
                            ,'mma_usu_creacion'     => $this->tank_auth->get_user_id()
                            ,'mma_fecha_creacion'   =>  date('Y-m-d H:i:s')
                            ,'mma_usu_modificacion' => $this->tank_auth->get_user_id()
                            ,'mma_fecha_modificacion' =>  date('Y-m-d H:i:s')

                        );
                    }
                }

                if (count($array_MinMax) > 0 ) {
                   $this->gsatelite->ingresar('mma_mimino_maximoxarticulo', $array_MinMax, true);
                }                
            }      



            /*======================= FINGUARDAR Minimo-Maximo ==================================================*/

            /*======================= GALERIA IMAGENES ===============================*/
            if (isset($post_array['titulo_doc'])) {
                
                for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                    $carpeta_temporal_anx = "public/temp/anx_galeria_articulo/" . trim($post_array['ruta'][$i]);
                    $ruta_anexo =  time()."_".trim($post_array['ruta'][$i]);
                    $carpeta_destino_anx = "uploads/anx_galeria_articulo/" . $ruta_anexo;

                    $datos_anexo = array(
                        'gia_id_art'    => $art_id,
                        'gia_url'       => $ruta_anexo,
                        'gia_nombre'    => $post_array['titulo_doc'][$i],                    
                        'gia_codigo_color'    => $post_array['rgb'][$i],                    
                        'gia_estado'                => 1,
                        'gia_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'gia_fecha_creacion'        => date('Y-m-d H:i:s'),
                        'gia_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'gia_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('gia_galeria_imagen_articulo', $datos_anexo);

                    @copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    @unlink($carpeta_temporal_anx);
                }
            }//fin actualizar galeria
            /*======================= FIN GALERIA IMAGENES ===============================*/

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización de artículos", 'texto_alerta' => "El registro se editó correctamente");
            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post('redireccion');

            $mod = $this->input->post('modulo');
            $fac = $this->input->post('facturacion');
            $coti = $this->input->post('cotizaciones');
            $proy = $this->input->post('proyectos');
            $modulo_contratos  = $this->input->post('modulo_contratos');
            $compras = $this->input->post('modulo_compras');

            $red = $this->input->post('redireccion');

            if ($coti == 1) {
                if($red == 1){
                    redirect('/cotizaciones/mantenimientos/articulo');
                }else{
                    redirect('/cotizaciones/mantenimientos/editar_articulo/'.$art_id);
                }
            } elseif ($proy == 1) {
                if($red == 1){
                    redirect('/proyectos/mantenimientos/articulo');
                }else{
                    redirect('/proyectos/mantenimientos/editar_articulo/'.$art_id);
                }
            } elseif ($fac == 1) {
                if($red == 1){
                    redirect('/facturacion/entradas/articulo');
                }else{
                    redirect('/facturacion/entradas/editar_articulo/'.$art_id);
                }
            }  elseif ($modulo_contratos == 1) {
                if($red == 1){
                    redirect('/modulo_contratos/catalogos/servicios');
                }else{
                    redirect('/modulo_contratos/catalogos/editar_articulo/'.$art_id);
                }
            } elseif ($compras == 1) {
                if($red == 1){
                    redirect('/modulo_compras/catalogos/servicios');
                }else{
                    //cargarvista($data, $output, "inventario/mantenimiento/editar_articulo/".$art_id);
                    redirect('/modulo_compras/catalogos/editar_articulo/'.$art_id);
                }
            } else {
                if ($red == 1) {
                    redirect($ruta.'/articulo');
                } else {
                    //cargarvista($data, $output, "inventario/mantenimiento/editar_articulo/".$art_id);
                    redirect($ruta.'/editar_articulo/' . $art_id);
                }
            }
        } else {            
            /*$cxr_id = $this->input->post('cxr_id');
            print_r($cxr_id); die();*/
            //registros de la tabla articulos para visualisar
            /* CASO ALFAGEOMATICS SE ESTA USANDO ESTA TABLA PARA GUARDAR LA CUENTA CONTABLE DEL PRODUCTO PERO SOLO A NIVEL INFORMATIVO */
            $data["mod"] = 1;
            $data["art_articulo"] = $art = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $articulo));
            $data["codigo_arancelario"] = $this->gsatelite->get_tabla('cda_codigo_arancelario', array('cda_estado' => 1));
            $data["categoria_tia"] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));           
            //Galeria de imagenes
            $galeri_reg = $this->gsatelite->get_tabla("gia_galeria_imagen_articulo",array("gia_id_art"=>$articulo));
            $cantidad_galeria = (count($galeri_reg) > 0 )? (count($galeri_reg)):0;
            $data["cantidad_galeria"] = $cantidad_galeria;
            $data["registro_anexos_galeria_imagenes"] = $galeri_reg;
            //select para elegir las caracteristicas del articulo            
            //$caracteristicas = $this->inventario_model->get_caracteristica2($data["art_articulo"][0]["art_id_tia"]);
            $caracteristicas = $this->inventario_model->get_caracteristica2($data["art_articulo"][0]["art_id_tia"]);            
            $cadena = '';
            foreach ($caracteristicas as $k) {
                $cadena .= '<option value="' . $k['cxr_id'] . '">' . $k['car_nombre'] . '</option>';
            }
            //print_r($cadena); die();
            $data["select_caracteristica"] = $cadena;

            //muestra los datos en la grid de la tab 1
            $data['caracteristicas_grid'] = $caracteristicas;
            $data['cxu_articulo'] = $this->gsatelite->get_tabla('cxu_caracxarticulo', array('cxu_estado' => 1, 'cxu_id_art' => $articulo));
            $caract_sty = 'style="display:none;"';
            if (!empty($data['cxu_articulo'])) {
                $caract_sty = '';
            }
            $data['caract_sty'] = $caract_sty;
            //muestra los datos de la grid de la tab 2
            $data['conversiones_grid'] = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_estado' => 1, 'cva_id_art' => $articulo));
            $data['mep_articulo'] = $this->gsatelite->get_tabla('mep_medida_producto', array('mep_estado' => 1));
            $conver_sty = 'style="display:none;"';
            if (!empty($data['conversiones_grid'])) {
                $conver_sty = '';
            }
            $data['conver_sty'] = $conver_sty;
            //tab 3
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), $data["art_articulo"][0]["art_id_bod"], '', 'bod_id', true);
            $data["bodega_bod"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $datos_sector_bod = $this->inventario_model->get_sector_grid($data["art_articulo"][0]["art_id_bod"]);
            $select = '<option value=""></option>';
            foreach ($datos_sector_bod as $key) {
                if ($data["art_articulo"][0]["art_id_sxb"] == $key['sxb_id']) {
                    $select .= '<option value="' . $key['sxb_id'] . '" selected>' . $key['seb_nombre'] . '</option>';
                } else {
                    $select .= '<option value="' . $key['sxb_id'] . '">' . $key['seb_nombre'] . '</option>';
                }
            }
            $data["sxb_sector"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //muestra los datos de la grid de la tab 4
            $data['combo_grid'] = $this->inventario_model->get_articulo_cma($articulo);
            $combo_sty = 'style="display:none;"';
            if (!(empty($data['combo_grid']))) {
                $combo_sty = '';
            }
            // tab de Minimo-Maximo
            $this->db->join('bod_bodega', 'bod_id = mma_id_bod');
            $data['bod_min_max'] = $this->gsatelite->get_tabla('mma_mimino_maximoxarticulo', array('mma_id_art'=>$articulo, 'mma_estado'=>1));
            $data['combo_sty'] = $combo_sty;
            $data['dias_mes'] = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
            $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $data['tipos_agrupacion'] = $this->gsatelite->get_tabla('tgr_tipo_agrupacion', array('tgr_estado' => 1));
            $select = $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => 1), null, '', 'mep_id', true);
            $data["medida_producto"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->gsatelite->get_dropdown('tgr_tipo_agrupacion', '{tgr_nombre}', '', array('tgr_estado' => 1), null, '', 'tgr_id', true);
            $data["tipo_agrupacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data["categorias"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $marcas = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_nombre}', '', array('mrp_estado' => 1), $art[0]['art_id_mrp'], '', 'mrp_id', true);
            $data["marcas"] = str_replace('<option value="0">Seleccione</option>', '', $marcas);
            $presentacion = $this->gsatelite->get_dropdown('ppr_presentacion_producto', '{ppr_nombre}', '', array('ppr_estado' => 1), $art[0]['art_id_ppr'], '', 'ppr_id', true);
            $data["presentacion"] = str_replace('<option value="0">Seleccione</option>', '', $presentacion);
            // Tab de Minimo-Maximo
            $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
            $data['codigos_compras'] = $this->gsatelite->get_tabla('cpc_codigo_producto_compras', array('cpc_id_art' => $articulo, 'cpc_estado' => 1));
            $data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT_WS(' ',prv_codigo,prv_nombre,prv_apellido) ELSE CONCAT_WS(' ',prv_apellido) End]", '', array('prv_estado' => 1), null, null, null, true);
            $data["bodega_max_min"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $politicas = $this->gsatelite->get_tabla('pxr_politicas_devolucionxarticulo',array('pxr_id_art' => $articulo));
            $ids = array_column($politicas, 'pxr_id_pld');
            $multi = '';
            if (count($politicas)>0) {                
                $multi .= $this->gsatelite->get_dropdown('pld_politica_devolucion', 'pld_nombre', 'politicas', array('pld_estado'=>1 ), $ids, null, null, true);                
            }else{
                 $multi .= $this->gsatelite->get_dropdown('pld_politica_devolucion', 'pld_nombre', 'politicas', array('pld_estado' => 1), null, null, false, true);
            }
            $data['politicas'] = $multi;
            //$data['mod']=$modulo;
            $data['titulo_personal'] = "Edición de producto";
            if($modulo == '7'){
                $data["mod"] = 7;
            } 
            if($modulo == '13'){
                $data["mod"] = 13;
            } 
            if($modulo == '8'){
                $data["mod"] = 8;
                $data['titulo_personal'] = "Edición de producto - servicio";
                return $data;
            }
            if ($modulo == '4')/* || $otro_modulo !=  "")*/ {
                
            }
            if( $ruta_modulo == "" || $ruta_modulo == null) {
                $data['ruta_modulo'] = "inventario/mantenimiento";
            }
            $data['ruta_modulo'] = ($ruta_modulo == null) ? "inventario/mantenimiento" : $ruta_modulo;
            cargarvista($data, null, "inventario/mantenimiento/editar_articulo");
        }
    }

    public function guardar_gral($parametros, $carpeta = null) {

        $datos = @explode($parametros);
        $carpeta = $parametros;


        $image = $this->upload_gral($carpeta);

//echo base_url().'/public/temp/'.$image['upload_data']['raw_name'].$image['upload_data']['file_ext'];
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
//echo $image['upload_data']['client_name'];
    }

    function upload_gral($carpeta) {
        if ($carpeta == "assets") {
            $ruta = FCPATH . "assets/uploads/images";
        } else {
            $ruta = FCPATH . "assets/uploads/images/";
        }

        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    function eliminar_imagen_gral($carpeta = "") {
        $name = $this->input->post('name');
        $url = $this->input->post("url");
        $url1 = $this->input->post("url1");

        echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";
        unlink($url1 . "assets/uploads/images/" . $name);
    }

    public function actualizar_articulo() {
//print_r($_POST);exit();
        $articulo_cabezera = array(
            'art_id_tia' => $_POST['categoria'],
            'art_id_mep' => $_POST['medida'],
            'art_nombre' => $_POST['nombre'],
            'art_descripcion' => $_POST['descripcion'],
            'art_codigo' => $_POST['codigo'],
            'art_foto' => ($_POST['edit_foto']) ? $_POST['edit_foto'] : $_POST['id_foto'],
            'art_minimo' => ($_POST['minimo'] == "") ? null : $_POST['minimo'],
            'art_maximo' => ($_POST['maximo'] == "") ? null : $_POST['maximo'],
            'art_fecha' => date('Y-m-d H:i:s'),
            'art_estado' => $_POST['estado'],
            'art_usu_mod' => $this->tank_auth->get_user_id(),
            'art_fecha_mod' => date('Y-m-d H:i:s'),
            'art_aplica_serie' => $_POST['serie'],
            'art_codigo_proveedor' => $_POST['codigo_proveedor'],
            'art_inventario' => ($this->input->post('art_inventario')) ? 1 : 0,
            'art_venta' => ($this->input->post('art_venta')) ? 1 : 0,
            'art_compra' => ($this->input->post('art_compra')) ? 1 : 0
        );
        $this->db->where('art_id', $_POST['articulo'])->update('art_articulo', $articulo_cabezera);
        $this->db->where('axp_id_art', $_POST['articulo']);
        $this->db->delete('axp_articuloxproposito');

        $this->db->where('pxa_id_art', $_POST['articulo']);
        $this->db->delete('pxa_proveedorxarticulo');

        $art_id = $this->input->post('articulo');

        $proveedores = $this->input->post('proveedor');
//die(print_r($proveedores));
        for ($k = 0; $k < count($proveedores); $k++) {
            if ($proveedores[$k] > 0) {
                $prvxart = array(
                    'pxa_id_art' => $art_id,
                    'pxa_id_prv' => $proveedores[$k],
                    'pxa_estado' => 1,
                    'pxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'pxa_fecha_mod' => date('Y-m-d-H-i-s')
                );
                $cxu = $this->gsatelite->ingresar('pxa_proveedorxarticulo', $prvxart);
            }
        }

        $this->db->where('cxu_id_art', $_POST['articulo']);
        $this->db->delete('cxu_caracxarticulo');




        $caracteristica = $_POST['caracteristicas'];
        $caracteristica_valor = $_POST['valor_cxc'];
        $caracteristica_estado = $_POST['estado_cxc'];
        $articulo = $_POST['articulo'];
        $tip_art = $this->gsatelite->get_campo('art_articulo', 'art_id_tia', array('art_id' => $articulo));
        for ($i = 0; $i <= count($caracteristica); $i++) {
//die(print_r($caracteristica[$i]));
            if (!empty($caracteristica[$i])) {
                $caracxart = array(
                    'cxu_id_cxr' => $caracteristica[$i],
                    'cxu_id_art' => $_POST['articulo'],
                    'cxu_valor' => $caracteristica_valor[$i],
                    'cxu_estado' => $caracteristica_estado[$i],
                    'cxu_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxu_fecha_mod' => date('Y-m-d-H-i-s')
                );

                $cxu = $this->gsatelite->ingresar('cxu_caracxarticulo', $caracxart);
            }
        }

        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización de artículos", 'texto_alerta' => "El registro se actualizo correctamente");
        $this->session->set_flashdata($alerta);
        $volver = $this->input->post('volver');
        $coti = $this->input->post('cotizaciones');
        $proy = $this->input->post('proyectos');

        if ($coti == 1) {
            if ($volver == 1) {
                redirect('/cotizaciones/mantenimientos/articulo');
            } else {
                redirect('/cotizaciones/mantenimientos/editar_articulo/' . $_POST['articulo']);
            }
        }

        if ($proy == 1) {
            if ($volver == 1) {
                redirect('/proyectos/mantenimientos/articulo');
            } else {
                redirect('/proyectos/mantenimientos/editar_articulo/' . $_POST['articulo']);
            }
        }



        if ($volver == 1) {
            redirect('/inventario/mantenimiento/articulo');
        } else {
            redirect('/inventario/mantenimiento/editar_articulo/' . $_POST['articulo']);
        }

        $mod = $this->input->post('modulo');
        $fac = $this->input->post('facturacion');
        if ($mod == 3) {
            redirect('/cotizaciones/mantenimientos/articulo');
        } else if ($mod == 2) {
            redirect('/proyectos/mantenimientos/articulo');
        } else if ($mod == 4) {
            redirect('/tarificador/procesos/articulo');
        } else if ($mod == 7) {
            redirect('/facturacion/entradas/articulo');
        } else {
            redirect('/inventario/mantenimiento/articulo');
        }
    }

    public function cxu_caracxart() {
        try {
            $crud = $this->new_crud();
            $columns = array(
                'cxu_id_cxr',
                'cxu_valor',
                'cxu_descripcion',
                'cxu_estado'
            );

//Alias para las columnas
            $alias = array(
                'cxu_id_cxr' => 'Característica',
                'cxu_valor' => 'Nombre',
                'cxu_estado' => 'Estado',
                'cxu_descripcion' => 'Descripción'
            );

//Columnas a mostrar en ADD
            $add_columns = array(
                'cxu_id_art',
                'cxu_id_cxr',
                'cxu_valor',
                'cxu_estado',
                'cxu_usu_mod',
                'cxu_fecha_mod',
                'cxu_descripcion'
            );

            $req_columns = array(
                'cxu_id_art',
                'cxu_valor',
                'cxu_estado',
                'cxu_usu_mod',
                'cxu_fecha_mod'
            );
            $addoedit = explode('/', uri_string());
            $addoedit = $addoedit[count($addoedit) - 2];
            if (is_numeric($addoedit)) {
                $articulo = $addoedit;
            } else {
                $articulo = explode('/', uri_string());
                $articulo = $articulo[count($articulo) - 3];
            }

            $url = explode('/', uri_string());
            if ($url[count($url) - 2] == "success") {
                $id_art = $url[count($url) - 3];
            } else {
                $id_art = end($url);
            }


            $campo = $this->gsatelite->get_campo('art_articulo', 'art_nombre', array('art_id' => $id_art));
            $nombre = (is_object($campo)) ? $campo->art_nombre : $campo;

            $crud->set_table('cxu_caracxarticulo')->set_subject('Característica de artículo')->columns($columns)->where('cxu_id_art', $id_art)->display_as($alias)->add_fields($add_columns)->required_fields($req_columns)->field_type('cxu_id_art', 'hidden', $articulo)->field_type('cxu_usu_mod', 'hidden', $this->tank_auth->get_user_id())->field_type('cxu_fecha_mod', 'hidden', date('Y-m-d H:i:s'))->field_type('cxu_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))->callback_add_field('cxu_id_cxr', array($this, 'llenar_categorias_art'))->callback_edit_field('cxu_id_cxr', array($this, 'llenar_categorias_art'))->callback_column('cxu_id_cxr', array($this, 'nombrar_carac'))->set_rules('cxu_valor', 'Nombre de la característica', 'trim|required|campo_unico[cxu_caracxarticulo.cxu_valor]')->edit_fields($add_columns)
            ;
            $output = $crud->render();
            $data['titulo_personal'] = "CARACTERÍSTICAS";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function nombrar_carac($key, $post_array) {

        $cxu = explode('/', uri_string());
        $cxu = $cxu[count($cxu) - 1];
        $caracteristica = $this->db->select()->from('cxu_caracxarticulo')->where('cxr_id', $key)
                        ->where('')->join('cxr_caractxtipo_articulo', 'cxr_id=cxu_id_cxr')->join('car_caracteristica', 'car_id=cxr_id_car')->get()->result_array();
        return $caracteristica[0]['car_nombre'];
    }

    public function llenar_categorias_art($key, $post_array) {
        $addoedit = explode('/', uri_string());
        $addoedit = $addoedit[count($addoedit) - 2];
        if (is_numeric($addoedit)) {
            $articulo = $addoedit;
            $cxu = null;
            $caracteristica = null;
        } else {

            $articulo = explode('/', uri_string());
            $articulo = $articulo[count($articulo) - 3];
            $cxu = explode('/', uri_string());
            $cxu = $cxu[count($cxu) - 1];
            $caracteristica = $this->db->select()->from('cxu_caracxarticulo')->where('cxu_id', $cxu)->join('cxr_caractxtipo_articulo', 'cxr_id=cxu_id_cxr')->join('car_caracteristica', 'car_id=cxr_id_car')->get()->result_array();
        }


        $tia_id = $this->db->where('art_id', $articulo)->get('art_articulo')->result_array();
        $cxtia = $this->db->where('cxr_id_tia', $tia_id[0]['art_id_tia'])->join('car_caracteristica', 'car_id=cxr_id_car')->get('cxr_caractxtipo_articulo')->result_array();
        $option = '<select name="cxu_id_cxr" id="field-cxu_id_cxr" class="nostyle chosen-select" style="width: 100%; display: none;" placeholder="Seleccione característica">';
        $option .= '<option value=" " selected="selected">Seleccione una característica</option>';
        foreach ($cxtia as $key => $value) {
            if ($value['cxr_id_car'] != $caracteristica[0]['car_id']) {
                $option .= "<option value='" . $value['cxr_id'] . "' >" . $value['car_nombre'] . "</option>";
            } else {
                $option .= "<option value='" . $value['cxr_id'] . "'' selected='selected'>" . $value['car_nombre'] . "</option>";
            }
        }
        $option .= "</select>";
        return $option;
    }

    public function username_check_insert5($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("tia_id", $id)->get('tia_tipo_articulo')->row()->tia_nombre;
            $num_row = $this->db->where('tia_nombre', $str)->where('tia_id !=', $id)->get('tia_tipo_articulo')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert5', 'El nombre del tipo de categoría ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('tia_nombre', $str)->get('tia_tipo_articulo')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert5', 'El nombre del tipo de categoría ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function username_check_insert55($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("tia_id", $id)->get('tia_tipo_articulo')->row()->tia_nombre;
            $num_row = $this->db->where('tia_codigo', $str)->where('tia_id !=', $id)->get('tia_tipo_articulo')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert55', 'El código del tipo de categoría ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('tia_codigo', $str)->get('tia_tipo_articulo')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert55', 'El código del tipo de categoría ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function proveedores($consulta = null) {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->proveedores(null, array('inventario/mantenimiento/proveedores', 'modulo_compras/catalogos/proveedores'));
        die('éxito');
       
    }

    public function agregar_proveedor($modal = 0) {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        if ($modal > 0) {
            $this->catalogos->agregar_proveedor(0,array('inventario/mantenimiento/proveedores', 'modulo_compras/catalogos/agregar_proveedor'), 1);
        } else {
            $this->catalogos->agregar_proveedor(null,array('inventario/mantenimiento/proveedores', 'modulo_compras/catalogos/agregar_proveedor'));
            die('éxito');
        }
    }

    

    public function editar_proveedor($prv_id) {
        satelite_validar();

        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->editar_proveedor($prv_id, null, array('inventario/mantenimiento/proveedores', 'modulo_compras/catalogos/editar_proveedor'));
        die('éxito');
    }

    public function dxp_documentosxproveedor() {
        try {
            $crud = $this->new_crud();
            $add = array('dxp_id_prv',
                'dxp_nombre',
                'dxp_descripcion',
                'dxp_estado',
                'dxp_fecha_mod',
                'dxp_usu_mod');
            $required = array('dxp_id_prv',
                'dxp_nombre',
                'dxp_estado',
                'dxp_fecha_mod',
                'dxp_usu_mod');
            $alias = array('dxp_nombre' => 'Anexo',
                'dxp_estado' => 'Estado',
                'dxp_descripcion' => 'Descripción');
            $columns = array('dxp_nombre',
                'dxp_descripcion',
                'dxp_estado');
            $addoedit = explode('/', uri_string());
            $addoedit = $addoedit[count($addoedit) - 2];
            if (is_numeric($addoedit)) {
                $proveedor = $addoedit;
            } else {
                $proveedor = explode('/', uri_string());
                $proveedor = $proveedor[count($proveedor) - 3];
            }

            $url = explode('/', uri_string());
            if ($url[count($url) - 2] == "success") {
                $id_prv = $url[count($url) - 3];
            } else {
                $id_prv = end($url);
            }

            $crud->set_table('dxp_documentosxproveedor')->set_subject('Anexo')->add_fields($add)->edit_fields($add)->columns($columns)->display_as($alias)->where('dxp_id_prv', $id_prv)->field_type('dxp_id_prv', 'hidden', $proveedor)->required_fields($required)->set_field_upload('dxp_nombre', 'assets/uploads/anexos_proveedor', 'nombre')->field_type('dxp_fecha_mod', 'hidden', date('Y-m-d H-i-s'))->field_type('dxp_usu_mod', 'hidden', $this->tank_auth->get_user_id());
//->field_type('dxp_estado','dropdown',array('1'=>'Activo','0'=>'Inactivo'));
            $crud->callback_before_upload(array($this, 'callback_before_upload_document'));

            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('dxp_estado', 'hidden', 1);
            } else {
                $crud->field_type('dxp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Anexos del proveedor";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function tamanio_proveedor() {
        satelite_validar();
        try {
            $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/tamanio_proveedor');
            $url_array = explode('/', uri_string());
            $crud = $this->new_crud();
//Columnas a mostrar en READ
            $columns = array(
                'tap_nombre',
                'tap_estado'
            );
//Alias para las columnas
            $alias = array(
                'tap_nombre' => 'Nombre',
                'tap_estado' => 'Estado'
            );
//Columnas a mostrar en ADD
            $add_columns = array(
                'tap_nombre',
                'tap_estado',
                'tap_usu_creacion',
                'tap_fecha_creacion',
                'tap_usu_modificacion',
                'tap_fecha_modificacion'
            );
//Columnas a mostrar en EDIT
            $edit_columns = array(
                'tap_nombre',
                'tap_estado',
                'tap_usu_modificacion',
                'tap_fecha_modificacion'
            );
//Columnas a mostrar en EDIT
            $req_columns = array(
                'tap_nombre',
                'tap_estado'
            );

            $crud->set_table('tap_tamano_prov')->set_subject('Tamaño de proveedor')->columns($columns)->display_as($alias)->add_fields($add_columns)->edit_fields($edit_columns)->required_fields($req_columns)->field_type('tap_usu_creacion', 'hidden', $this->tank_auth->get_user_id())->field_type('tap_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())->field_type('tap_fecha_creacion', 'hidden', date('Y:m:d h:i:s'))->field_type('tap_fecha_modificacion', 'hidden', date('Y:m:d h:i:s'))->set_rules('tap_nombre', 'Nombre', 'campo_unico[tap_tamano_prov.tap_nombre]|required');

            if (end($url_array) == 'add') {
                $crud->field_type('tap_estado', 'hidden', 1);
            } else {
                $crud->field_type('tap_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

// Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }

            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'inventario/mantenimiento/tamanio_proveedor/read');
            }

            $output = $crud->render();
            $data["titulo_personal"] = "Tamaños de proveedores";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function username_check_insert1($str) {
        $uri_segments = explode('/', uri_string());
        $id = end($uri_segments);
        if (is_numeric($id)) {
            $username_old = $this->db->where("prv_id", $id)->get('prv_proveedor')->row()->prv_nombre;
            $num_row = $this->db->where('prv_nombre', $str)->where('prv_id !=', $id)->get('prv_proveedor')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert1', 'El nombre del proveedor ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('prv_nombre', $str)->get('prv_proveedor')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('username_check_insert1', 'El nombre del proveedor ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function precios_articulo_new($id_art, $tipo = null, $ruta_modulo) {
        satelite_validar();
        
        $this->gsatelite->verificar_registro_real('art_articulo', $id_art);

        $ruta = trim($ruta_modulo) != '' ? $ruta_modulo : "inventario/mantenimiento";
        $where = null;
        $crud = new grocery_CRUD();

        $data['id_articulo'] = $id_art > 0 ? $id_art : 0;
        // Verificar si vienen datos por POST
        if ($tipo != null) { 
            //ESTOOOOO   $tipo = $this->input->post('slcTipo');
            if ($tipo > 0 ) {
                $where['tlp_id'] = $tipo;
            }
        } // else {
        //     $where['tlp_id'] = null;
        // }
        // Verificar si se ha definido
        if (isset($where)) {
            $crud->where($where);
        }

        $add_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_estado',
            'lip_usu_creacion',
            'lip_fecha_creacion',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $edit_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_estado',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $colum_fields = array(            
            'lip_desde',
            'lip_hasta',
            'lip_precio',
            'lip_descuento_min',
            'lip_descuento_max',            
            'lip_id_tlp',            
            'lip_estado'            
        );

        $required = array(
            'lip_id_tlp',
            'lip_id_art', 
            'lip_desde', 
            'lip_hasta', 
            'lip_precio', 
            'lip_estado', 
            'lip_id_mep', 
            'lip_descuento_min', 
            'lip_descuento_max'
        ); 

        $display_as = array(
            'lip_desde'         => 'Cantidad Desde',
            'lip_hasta'         => 'Cantidad Hasta',
            'lip_descuento_min' => 'Porcentaje Minimo',
            'lip_descuento_max' => 'Porcentaje Maximo',
            'lip_precio'        => 'Precio',
            'lip_ultimo_prec_compra' => 'Precio última compra',
            'lip_variacion_utilidad' => '% Variación utilidad',
            'lip_estado'        => 'Estado',
            'lip_id_mep'        => 'Unidad',
            'lip_id_tlp'        => 'Tipo lista'
        );

        $crud->set_table('lip_listado_precio')
                ->set_subject('Precio Producto')
                ->where('lip_id_art', $id_art)
                ->columns($colum_fields)
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->display_as($display_as)
                ->set_relation('lip_id_tlp', 'tlp_tipo_lista_precio', '{tlp_nombre}', array('tlp_estado' => 1))
                ->required_fields($required)
                ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango')
                ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
                ->set_rules('lip_descuento_min', 'Porcentaje Minimo', 'trim|required|is_numeric')
                ->set_rules('lip_descuento_max', 'Porcentaje Maximo', 'trim|required|is_numeric')
                ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
                ->field_type('lip_id_art', 'hidden', $id_art)
                ->field_type('lip_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lip_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
        ;
        $crud->set_relation('lip_id_mep', 'mep_medida_producto', 'mep_nombre', array('mep_estado' => '1'));
        $uri_segments = explode('/', uri_string()); 
        if (end($uri_segments) == 'add') {
            $crud->field_type('lip_estado', 'hidden', 1);
            $crud->field_type('lip_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('lip_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Listado de Precios";
        $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);

        // Enviar url
        $data['url'] = explode('/', uri_string());
        // Datos para filtro de tipo de lista
        $tipo_lista = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', array('tlp_estado' => '1'), null, '', 'tlp_id', true);
        $data["tipo_lista"] = str_replace('<option value="0">Seleccione</option>', '', $tipo_lista);
        $data['url_model'] = $ruta;

        $output = $crud->render();
        //$this->_cargarvista($data, $output);
        cargarvista($data, $output, "inventario/mantenimiento/precios_articulo");
    }

    function precios_articulo($id_art) {
        satelite_validar();

        $this->gsatelite->verificar_registro_real('art_articulo', $id_art);
        $alerta='';

        $crud = $this->new_crud();
        $crud->set_table('lip_listado_precio')
            ->set_subject('Precio Producto')
            ->where('lip_id_art', $id_art)
            ->columns('lip_id_tlp','lip_desde', 'lip_hasta', 'lip_id_mep', 'lip_descuento_min','lip_descuento_max','lip_precio', 'lip_estado')
            ->fields('lip_id_art', 'lip_desde', 'lip_hasta', 'lip_precio', 'lip_id_mep', 'lip_estado', 'lip_usu_creacion', 'lip_fecha_creacion', 'lip_usu_modificacion', 'lip_fecha_modificacion')
            ->display_as('lip_desde', 'Cantidad Desde')
            ->display_as('lip_hasta', 'Cantidad Hasta')
            ->display_as('lip_descuento_min', 'Porcentaje Minimo')
            ->display_as('lip_descuento_max', 'Porcentaje Maximo')
            ->display_as('lip_ultimo_prec_compra', 'Precio última compra')
            ->display_as('lip_variacion_utilidad', '% Variación utilidad')
            ->display_as('lip_precio', 'Precio')
            ->display_as('lip_estado', 'Estado')
            ->display_as('lip_id_mep', 'Unidad medida')
            ->display_as('lip_id_tlp', 'Tipo de lista')
            ->add_fields('lip_id_art', 'lip_id_tlp', 'lip_desde', 'lip_hasta','lip_descuento_min','lip_descuento_max', 'lip_precio', 'lip_id_mep', 'lip_ultimo_prec_compra', 'lip_variacion_utilidad', 'lip_estado', 'lip_usu_creacion', 'lip_fecha_creacion', 'lip_usu_modificacion', 'lip_fecha_modificacion', 'lip_id_cva')
            ->edit_fields('lip_id_cva','lip_id_art', 'lip_id_tlp', 'lip_desde', 'lip_hasta', 'lip_descuento_min','lip_descuento_max','lip_precio', 'lip_id_mep', 'lip_ultimo_prec_compra', 'lip_variacion_utilidad', 'lip_estado', 'lip_usu_modificacion', 'lip_fecha_modificacion')
            ->required_fields('lip_id_tlp', 'lip_id_art', 'lip_desde', 'lip_hasta', 'lip_precio', 'lip_estado', 'lip_id_mep', 'lip_descuento_min','lip_descuento_max')
            ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango')
            ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
            ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
            ->set_rules('lip_descuento_min', 'Porcentaje Minimo', 'trim|required|is_numeric')
            ->set_rules('lip_descuento_max', 'Porcentaje Maximo', 'trim|required|is_numeric')
            ->field_type('lip_id_art', 'hidden', $id_art)
            ->field_type('lip_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('lip_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('lip_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('lip_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            //->unset_delete();
            ;
        $crud->set_relation('lip_id_tlp', 'tlp_tipo_lista_precio', 'tlp_nombre', array('tlp_estado' => '1'));
        $crud->set_relation('lip_id_mep', 'mep_medida_producto', 'mep_nombre', array('mep_estado' => '1'));

        $uri_segments = explode('/', uri_string()); 
        if (end($uri_segments) == 'add') {            
            $crud->field_type('lip_estado', 'hidden', 1);
        } else {  // Editar
            $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        //Aqui va el id del cva
        $crud->field_type('lip_id_cva', 'hidden', 0);

        $ruta = (false) ? '' : "inventario/mantenimiento";
        $data['url_model'] = $ruta;           
        $this->session->set_flashdata($alerta);
        $data['titulo_personal'] = "Listado de Precios";
        $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);
        $data['id_art'] = $id_art;

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    public function validacion_rango($data) {
        if ($data != '') {
            //die(var_dump($_POST));
            $validado1 = false; //variable que cambiará de valor cuando no se cumpla una condición de validación
            $validado2 = false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación

            //Tipo de lista
            $lip_id_tlp = $this->input->post('lip_id_tlp');
            //Rango de cantidad
            $f1 = $this->input->post('lip_desde');
            $f2 = $this->input->post('lip_hasta');
            //Articulo
            $lip_id_art = $this->input->post('lip_id_art');
            //unidad de medida
            $lip_id_mep = $this->input->post('lip_id_mep');

            if ($f2 >= $f1) {
                $validado1 = true;
            } //primera condición
            else {
                $this->form_validation->set_message('validacion_rango', 'El campo desde debe ser menor al campos hasta');
                return false;
            }

            //PREGUNTAR SI EXISTEN REGISTROS DE FECHA DESDE MAYOR A LA INGRESADA. (PARA EVITAR REGISTRO CRUZADOS) 
            $url_array = explode('/', uri_string()); //en el caso de edit
            $no_incluir = (is_numeric(end($url_array)) and end($url_array) > 0 ) ? end($url_array) : 0;                    
            /*
            $pregunta = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id !=' => $no_incluir, 'lip_desde' => $f1, 'lip_hasta' => $f2, 'lip_id_art' => $id_art));
            $pregunta2 = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id !=' => $no_incluir, 'lip_hasta >=' => $f1, 'lip_id_art' => $id_art));            
            
            if (count($pregunta) > 0) {
                $this->form_validation->set_message('validacion_rango', 'Ya existe un registro con un rango similar al que intenta ingresarr.');
                return false;
            }
            if (count($pregunta2) > 0 and ! is_numeric(end($url_array))) {
                $this->form_validation->set_message('validacion_rango', 'Ya existe otro registro que contiene la cantidad desde');
                return false;
            } else {
                $validado2 = true;
            }
            return ($validado1 and $validado2) ? true : false;*/
            $where = [];
            $where['lip_id_tlp'] = $lip_id_tlp;
            $where['lip_id !='] = $no_incluir;
            //$where['lip_desde'] = $f1;
            //$where['lip_hasta'] = $f2;            
            $where['lip_id_mep'] = $lip_id_mep;
            $where['lip_id_art'] = $lip_id_art;       
            $where['( ('.$f1.' BETWEEN lip_desde and lip_hasta) or ('.$f2.' BETWEEN lip_desde and lip_hasta) )'] = null;       
            $existe = $this->gsatelite->get_tabla('lip_listado_precio', $where);             
            if(count($existe) > 0){
                    $this->form_validation->set_message('validacion_rango', 'Ya existe una lista el mismo tipo de lista, rango de precios y unidad de medida');
                    return false;
                }else{
                    return true;
            }             
        } else {
            return true;
        }
    }

    /*
    * Funcionalidad compartida del modulo de Contabilidad(Catalogo Cuentas contables tabla: cnt_cuenta_contable)
    */
    function gestion_cuentas() {
        satelite_validar();
        $this->load->library('../controllers/modulo_contabilidad/catalogos');
        $this->catalogos->cuenta_contable('inventario/mantenimiento/gestion_cuentas');
    }

    public function actividad_economica() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('actividad_economica');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('acp_act_economica_prov');
            $crud->set_subject('Actividad económica');

            $columnas = array(
                'acp_nombre',
                'acp_estado'
            );

            $campos = array(
                'acp_nombre',
                'acp_estado',
                'acp_usu_creacion',
                'acp_usu_modificacion',
                'acp_fecha_creacion',
                'acp_fecha_modificacion'
            );

            $display_as = array(
                'acp_nombre' => 'Nombre',
                'acp_estado' => 'Estado',
                'acp_usu_creacion' => 'Usuario creacion',
                'acp_usu_modificacion' => 'Usuario modificacion',
                'acp_fecha_creacion' => 'Fecha creacion',
                'acp_fecha_modificacion' => 'Fecha modificacion'
            );


            $crud->field_type('acp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('acp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('acp_fecha_creacion', 'hidden', date('Y-m-d-H-i-s'));
            $crud->field_type('acp_fecha_modificacion', 'hidden', date('Y-m-d-H-i-s'));
            $crud->field_type('acp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('acp_nombre', 'Nombre', 'campo_unico[acp_act_economica_prov.acp_nombre]|required');
            $crud->required_fields($columnas);

            $crud->columns($columnas);
            $crud->fields($campos);
            $crud->display_as($display_as);
//$crud->callback_before_insert(array($this, '_log_usuario_insert'));
//$crud->callback_before_update(array($this, '_log_usuario_update'));
// Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de actividad económica";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * ====================
     * CALLBACKS
     * ===================
     * */

    /**
     * files_to_upload = información del archivo
     * field_info = información del path
     */
    function callback_before_upload_document($files_to_upload, $field_info) {

        $encrypted_name = $field_info->encrypted_field_name;

        $search = array("(", ")");

//$files_to_upload[$encrypted_name]['name'] = str_replace($search, "_", $files_to_upload[$encrypted_name]['name']);

        if (strpos($files_to_upload[$encrypted_name]['name'], '(') || strpos($files_to_upload[$encrypted_name]['name'], ')') || strpos($files_to_upload[$encrypted_name]['name'], '&') || strpos($files_to_upload[$encrypted_name]['name'], '!') || strpos($files_to_upload[$encrypted_name]['name'], '%') || strpos($files_to_upload[$encrypted_name]['name'], '=') || strpos($files_to_upload[$encrypted_name]['name'], '$')) {

            return 'Elimine caracteres especiales en el nombre del archivo';
        } else {
            return true;
        }
    }

    /**
     * ====================
     * @Autor: Mario Marquez
     * ===================
     * */
    function caracteristica_nombre_unico() {
        $nom_carac = trim($this->input->post('car_nombre'));
// $mod_carac = $this->input->post('car_modulo');

        $uri_segments = explode('/', uri_string()); 
        if (end($uri_segments) == 'add') {
            $where = array('car_caracteristica.car_nombre' => $nom_carac);
            $query = $this->db->select('car_caracteristica.car_id')->from('car_caracteristica');
            $this->db->where($where);
        } else {
            $id_carac = end($uri_segments);
            $where = array('car_caracteristica.car_nombre' => $nom_carac);
            $query = $this->db->select('car_caracteristica.car_id')->from('car_caracteristica');
            $this->db->where($where);
            $this->db->where_not_in('car_caracteristica.car_id', $id_carac);
        }
        $result = $query->get()->result();
        if (count($result) > 0) {
            $this->form_validation->set_message('caracteristica_nombre_unico', 'El campo Nombre debe ser único.');
            return false;
        } else {
            return true;
        }
    }

    function areas() {
        $this->load->library('../controllers/expediente_personal/catalogos');
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/areas');
        $this->catalogos->area_empresa($permisos);
    }

    /**
     * @author René Castaneda
     * @since 16-02-2018
     * @return Mantenimiento plz_plaza
     */
    //==== INICIO COMPARTIR FUNCIONALIDAD DE MANTENIMIENTO DE PLAZA - ESTRUCTURA ORGANIZATIVA
    public function plazas()
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->plazas();
    }

    public function agregar_plaza()
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->agregar_plaza();
    }

    public function editar_plaza($plz_id, $ver = null, $modulo = null, $ruta = null)
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->editar_plaza($plz_id, $ver, $modulo, $ruta);
    }

    //==== FIN COMPARTIR FUNCIONALIDAD DE MANTENIMIENTO DE PLAZA - ESTRUCTURA ORGANIZATIVA

    
    /*
    * Funcinalidad Compartida. Modulo de Estructura Organizativa>Mantenimientos>centro_costos
    */
    function centros_costo() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/mantenimientos');
        
        $this->mantenimientos->centro_costos('inventario/mantenimiento', 'centros_costo');
    }

    /**
     * Descripción:
     * Funcionalidad compartida del modulo de Estructura Organizativa
     * @author René Castaneda
     * @return Mantenimiento axp_anexoxpuesto
     */
    function puesto() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->puestos('inventario/mantenimiento');

    }

    /**
     * Descripción:
     * Función para agregar puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param Ninguno
     * @return Obtener la vista para agregar un puesto
     */
    function agregar_puesto() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->agregar_puesto('inventario/mantenimiento', 'puesto');    
    }

    /**
     * Descripción:
     * Función para editar el puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param $pto_id = ID del puesto
     * @return Obtener la vista para editar puesto
     */
    function editar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->editar_puesto($pto_id, 'inventario/mantenimiento', 'puesto');
    }

    /**
     * Descripción:
     * Función para obtener la vista de ver el registro de puesto
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param $pto_id = ID del puesto que se desea ver
     * @return Obtener Vista de puesto
     */
    function ver_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->ver_puesto($pto_id, 'inventario/mantenimiento', 'puesto');
    }

    /**
     * Descripción:
     * Función para eliminar un puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param $pto_id = ID del puesto
     * @return Eliminar un registro de puesto
     */
    function eliminar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->eliminar_puesto($pto_id, 'inventario/mantenimiento', 'puesto');
    }

    function profesion() {
        $this->load->library('../controllers/sistema/catalogo');
        satelite_validar();
//$titulo
        $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/profesion');
        $this->catalogo->profesion($permisos);
    }

    function arancelarios() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/arancelarios');
            $crud = new grocery_CRUD();
            $crud->set_subject('')->set_table('cda_codigo_arancelario');
            $crud->columns('cda_codigo', 'cda_impuesto', 'cda_descripcion', 'cda_estado');
            $crud->display_as('cda_codigo', 'Código')->display_as('cda_descripcion', 'Descripción')->display_as('cda_impuesto', '% Impuesto')->display_as('cda_estado', 'Estado');
            $crud->add_fields('cda_codigo', 'cda_descripcion', 'cda_impuesto', 'cda_estado', 'cda_usu_modificacion', 'cda_fecha_modificacion', 'cda_usu_creacion', 'cda_fecha_creacion');
            $crud->edit_fields('cda_codigo', 'cda_impuesto', 'cda_descripcion', 'cda_estado', 'cda_usu_modificacion', 'cda_fecha_modificacion');
            $crud->required_fields('cda_codigo');
            $crud->set_rules('cda_codigo', 'código', 'trim|required|campo_unico[cda_codigo_arancelario.cda_codigo]');
            $crud->set_rules('cda_estado', 'Tipo', 'trim|required');
            $crud->set_rules('cda_impuesto', 'Impuesto', 'numeric');
            $crud->field_type('cda_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cda_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cda_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('cda_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->callback_column('cda_impuesto', function($value, $row) {
                $porcentaje = $row->cda_impuesto . " %";
                return $porcentaje;
            });
            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('cda_estado', 'hidden', 1);
            } else {
                $crud->field_type('cda_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'inventario/mantenimiento/arancelarios/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Código Arancelario";
            $this->_cargarvista($data, $output);
        }
    }

    function tipo_agrupacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/tipo_agrupacion');
            $crud = new grocery_CRUD();
            $crud->set_subject('')->set_table('tgr_tipo_agrupacion');
            $crud->columns('tgr_nombre', 'tgr_descripcion', 'tgr_estado');
            $crud->display_as('tgr_nombre', 'Nombre')->display_as('tgr_descripcion', 'Descripción')->display_as('tgr_estado', 'Estado');
            $crud->add_fields('tgr_nombre', 'tgr_descripcion', 'tgr_estado', 'tgr_usu_modificacion', 'tgr_fecha_modificacion', 'tgr_usu_creacion', 'tgr_fecha_creacion');
            $crud->edit_fields('tgr_nombre', 'tgr_descripcion', 'tgr_estado', 'tgr_usu_modificacion', 'tgr_fecha_modificacion');
            $crud->required_fields('tgr_nombre', 'tgr_estado');
            $crud->set_rules('tgr_nombre', 'nombre', 'trim|required|campo_unico[tgr_tipo_agrupacion.tgr_nombre]');
            $crud->set_rules('tgr_estado', 'estado', 'trim|required');
            $crud->field_type('tgr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tgr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tgr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tgr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('tgr_estado', 'hidden', 1);
            } else {
                $crud->field_type('tgr_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'inventario/mantenimiento/tipo_agrupacion/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de agrupación";
            $this->_cargarvista($data, $output);
        }
    }

    function tipo_lista($ruta_vista = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'inventario/mantenimiento/tipo_lista'; 
            $arreglo_url = explode('/', $ruta_permisos);
            $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $ruta_vista = (is_array($ruta_vista) && count($ruta_vista) > 1) ? $ruta_vista[1] : null;

            $permisos = $this->gsatelite->get_permisos_opcion($ruta_permisos);

            $add_fields = array(
                'tlp_nombre', 
                'tlp_descripcion', 
                'tlp_estado', 
                'tlp_defecto',
                'tlp_usu_creacion', 
                'tlp_fecha_creacion', 
                'tlp_usu_modificacion', 
                'tlp_fecha_modificacion'
            );
            $edit_fields = array(
                'tlp_nombre', 
                'tlp_descripcion', 
                'tlp_defecto',
                'tlp_estado', 
                'tlp_usu_modificacion', 
                'tlp_fecha_modificacion'
            );
            $display_as = array(
                'tlp_id'            => 'ID',
                'tlp_nombre'        => 'Nombre',
                'tlp_descripcion'   => 'Descripción',
                'tlp_estado'        => 'Estado',
                'tlp_defecto'       => 'Lista por Defecto',
            );
            $required = array(
                'tlp_nombre', 
                'tlp_estado'
            );
            $columns = array(
                'tlp_id',
                'tlp_nombre', 
                'tlp_descripcion', 
                'tlp_estado'
            );

            $crud = new grocery_CRUD();
            //$crud->set_subject('Tipo de lista');
            $crud->set_subject('');
            $crud->set_table('tlp_tipo_lista_precio');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required);

            $crud->callback_add_field('tlp_defecto', function() {
                return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-tlp_defecto" name="tlp_defecto" value="0">';
            });
            $crud->callback_edit_field('tlp_defecto', function($value, $primary_key) {
                $leer    = ($this->uri->rsegments[3] == 'read')?'iButton':'';
                $defecto = ($value)?'checked':''; // Verificar si esta activo
                return '<input type="checkbox" id="chbdefecto" '.$defecto.' class="'.$leer.' nostyle"><input type="hidden" id="field-tlp_defecto" name="tlp_defecto" value="'.$value.'">';
            });

            $crud->set_rules('tlp_nombre', 'Nombre', 'trim|required|campo_unico[tlp_tipo_lista_precio.tlp_nombre]');
            $crud->set_rules('tlp_estado', 'Estado', 'trim|required');
            $crud->field_type('tlp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tlp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tlp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tlp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('tlp_estado', 'hidden', 1);
            } else {
                $crud->field_type('tlp_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if (!$permisos["permite_ver"]) {
                $crud->unset_read();
            } else {
                // $crud->add_action('&nbsp;&nbsp;Ver', '', 'inventario/mantenimiento/tipo_lista/read', 'icomoon-icon-search-3');
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipo de lista";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'inventario/mantenimiento/tipo_lista';
            cargarvista($data, $output, $ruta_vista);
        }
    }

    function catalogo_categoria() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $titulo['titulo_personal'] = "Nuevo empleado";

            $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data["categorias"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $select = $this->gsatelite->get_dropdown('nii_nivel_idioma', '{nii_nombre}', '', array('nii_estado' => 1), null, '', 'nii_id', true);
            $data["nivel_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $this->_cargarvista($titulo, $data);
        }
    }

    function sector_bodega() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/sector_bodega');

            $crud = new grocery_CRUD();
            $crud->set_subject('Sector de bodega')->set_table('seb_sector_bodega');
            $crud->columns('seb_nombre', 'seb_descripcion', 'seb_estado');
            $crud->display_as('seb_nombre', 'Nombre')->display_as('seb_descripcion', 'Descripción')->display_as('seb_estado', 'Estado');
            $crud->add_fields('seb_nombre', 'seb_descripcion', 'seb_estado', 'seb_usu_creacion', 'seb_fecha_creacion', 'seb_usu_modificacion', 'seb_fecha_modificacion');
            $crud->edit_fields('seb_nombre', 'seb_descripcion', 'seb_estado', 'seb_usu_modificacion', 'seb_fecha_modificacion');
            $crud->required_fields('seb_nombre', 'seb_estado');
            $crud->set_rules('seb_nombre', 'nombre', 'trim|required|campo_unico[seb_sector_bodega.seb_nombre]');
            $crud->set_rules('seb_estado', 'estado', 'trim|required');
            $crud->field_type('seb_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('seb_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('seb_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('seb_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('seb_estado', 'hidden', 1);
            } else {
                $crud->field_type('seb_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if ($permisos["permite_ver"]) {
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'inventario/mantenimiento/sector_bodega/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Sectores de bodega";
            $this->_cargarvista($data, $output);
        }
    }

    public function formulas_producto($art_id = null, $ruta_vista = null) {
        satelite_validar();

        if ($art_id == null) {
            redirect('inventario/mantenimiento/articulo');
        }
        $ruta = (trim($ruta_vista) != '')? $ruta_vista.'/editar_formula':'inventario/mantenimiento/editar_formula'; 

        try {
//$permisos = $this->gsatelite->get_permisos_opcion('inventario/mantenimiento/formulas_producto');
            $crud = new grocery_CRUD();
            $crud->set_table('foa_formula_articulo');
            $crud->set_subject('');

            $columnas = array(
                'foa_nombre',
                'foa_descripcion',
                'foa_afecta_cantidad',
                'foa_estado'
            );

            $display_as = array(
                'foa_nombre' => 'Nombre',
                'foa_descripcion' => 'Descripción',
                'foa_afecta_cantidad' => 'Afecta Cantidad',
                'foa_estado' => 'Estado'
            );

            $crud->columns($columnas);
            $crud->display_as($display_as);

            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('foa_estado', 'hidden', 1);
            } else {
                $crud->field_type('foa_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                $crud->field_type('foa_afecta_cantidad', 'dropdown', array('1' => 'Si', '0' => 'No'));
            }
            $crud->where('foa_id_art', $art_id);
            $crud->unset_delete();
            $crud->unset_edit();
            $crud->unset_add();
            $crud->add_action('Editar', 'icomoon-icon-pencil-5', "$ruta");
            $crud->add_action('Ver', 'minia-icon-search', 'inventario/mantenimiento/editar_formula/1');

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Fórmulas de producto";

            $data['articulo'] = $this->gsatelite->get_registro('art_articulo', array('art_id' => $art_id));

            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'inventario/mantenimiento';
            $data['ruta'] = $ruta_vista;
            cargarvista($data, $output, 'inventario/mantenimiento/formulas_producto');
           
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function agregar_formula($art_id = null, $ruta=null, $flag=null) {
        $ruta = (trim($ruta) != '')? $ruta : 'inventario/mantenimiento';
        if ($art_id == null) {
            redirect($ruta.'/articulo');
        }
        $flag = (trim($flag) != '')? $flag : 'agregar_formula';
        $data['ruta'] = $ruta;
        $data['flag'] = $flag;
        //die(print_r($ruta));

        if ($_POST) {

            $post_array = $_POST;
            $ruta = $post_array['hdnRuta'];
           

            $txtNombre = $post_array['txtNombre'];
            $hdnAfectaCant = $post_array['hdnAfectaCant'];
            $txtDescripcion = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;

            $caracteristicasNombre = $post_array['caracteristicasNombre'];
            $caracteristicas = $post_array['caracteristicas'];
            $operadores = $post_array['operadores'];
            $valoresDefecto = $post_array['valoresDefecto'];
            $tipo_btn = $post_array['btnCrear'];

            $formula_array = array(
                'foa_id_art' => $art_id,
                'foa_nombre' => $txtNombre,
                'foa_descripcion' => $txtDescripcion,
                'foa_afecta_cantidad' => $hdnAfectaCant,
                'foa_estado' => 1,
                'foa_usu_creacion' => $this->tank_auth->get_user_id(),
                'foa_fecha_creacion' => date('Y-m-d H:i:s'),
                'foa_usu_modificacion' => $this->tank_auth->get_user_id(),
                'foa_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $foa_id = $this->gsatelite->ingresar('foa_formula_articulo', $formula_array);

            if ($foa_id) {
                if (count($caracteristicasNombre) > 0) {
                    for ($i = 0; $i < count($caracteristicasNombre); $i++) {
                        $operacion_array = array(
                            'dxf_id_foa' => $foa_id,
                            'dxf_id_cxu' => $caracteristicas[$i],
                            'dxf_operador' => $operadores[$i],
                            'dxf_valor_defecto' => ($valoresDefecto[$i] != '') ? $valoresDefecto[$i] : null,
                            'dxf_descripcion' => $caracteristicasNombre[$i],
                            'dxf_estado' => 1,
                            'dxf_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxf_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dxf_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dxf_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('dxf_detallexformula', $operacion_array);
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Fórmula de Producto", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fórmula de Producto", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect($ruta.'/'.$flag.'/'.$art_id);
            } else {
                redirect($ruta.'/formulas_producto/' . $art_id);
            }
        }

        $articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
        $data['caracteristicas'] = $this->inventario_model->get_caracteristicas_producto(array('cxu_id_art' => $art_id, 'cxu_estado' => 1));
        $operadores = $this->gsatelite->get_parametro('SYS_FORMULAS_MAT');
        $data['operadores'] = json_decode($operadores, true);

        $data['articulo'] = $articulo[0];
        $data['titulo_personal'] = "Agregar Fórmula - " . $articulo[0]['art_codigo'] . ' - ' . $articulo[0]['art_nombre'];
       
        cargarvista($data, null, 'inventario/mantenimiento/agregar_formula');
    }

    public function editar_formula($foa_id = null, $ver = null, $ruta = null, $flag = null) {
        if ($ver != null) {
            $foa_id = $ver;
            $ver = 1;
        }

        $art_id = $this->gsatelite->get_campo('foa_formula_articulo', 'foa_id_art', array('foa_id' => $foa_id));

        $ruta = (trim($ruta) != '')? $ruta : 'inventario/mantenimiento';
        $flag = (trim($flag) != '')? $flag : 'editar_formula';
        $data['ruta'] = $ruta;
        $data['flag'] = $flag;
       

        if ($_POST) {
            $post_array = $_POST;
            $ruta = $post_array['hdnRuta'];

            $txtNombre = $post_array['txtNombre'];
            $hdnAfectaCant = $post_array['hdnAfectaCant'];
            $txtDescripcion = ($post_array['txtDescripcion'] != '') ? $post_array['txtDescripcion'] : null;
            $slcEstado = ($post_array['slcEstado'] == 2) ? 0 : $post_array['slcEstado'];

            $hdnOperadores = $post_array['hdnOperadores'];
            $caracteristicasNombre = $post_array['caracteristicasNombre'];
            $caracteristicas = $post_array['caracteristicas'];
            $operadores = $post_array['operadores'];
            $valoresDefecto = $post_array['valoresDefecto'];
            $tipo_btn = $post_array['btnCrear'];

            $formula_array = array(
                'foa_nombre' => $txtNombre,
                'foa_descripcion' => $txtDescripcion,
                'foa_afecta_cantidad' => $hdnAfectaCant,
                'foa_estado' => $slcEstado,
                'foa_usu_modificacion' => $this->tank_auth->get_user_id(),
                'foa_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->actualizar_array('foa_formula_articulo', $formula_array, array('foa_id' => $foa_id));

            if ($resultado > 0) {

//Se procesan los detalles eliminados de la pantalla
                $detallesFormula = $this->inventario_model->get_caracteristicas_formula(array('dxf_id_foa' => $foa_id));

                if (!is_array($hdnOperadores)) {
                    $hdnOperadores = array();
                }

                if (count($detallesFormula) > 0) {
                    foreach ($detallesFormula as $dat) {
                        if (!in_array($dat['dxf_id'], $hdnOperadores)) {
                            $this->gsatelite->borrado_general('dxf_detallexformula', array('dxf_id' => $dat['dxf_id']));
                        }
                    }
                }


                if (count($caracteristicasNombre) > 0) {
                    for ($i = 0; $i < count($caracteristicasNombre); $i++) {
                        $operacion_array = array(
                            'dxf_id_foa' => $foa_id,
                            'dxf_id_cxu' => $caracteristicas[$i],
                            'dxf_operador' => $operadores[$i],
                            'dxf_valor_defecto' => ($valoresDefecto[$i] != '') ? $valoresDefecto[$i] : null,
                            'dxf_descripcion' => $caracteristicasNombre[$i],
                            'dxf_estado' => 1,
                            'dxf_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dxf_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dxf_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dxf_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('dxf_detallexformula', $operacion_array);
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Fórmula de Producto", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fórmula de Producto", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect($ruta.'/'.$flag.'/'.$foa_id);
            } else {
                redirect($ruta.'/formulas_producto/' . $art_id);
            }

        
        }

        $formula = $this->gsatelite->get_tabla('foa_formula_articulo', array('foa_id' => $foa_id));

        $articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $formula[0]['foa_id_art']));
        $data['caracteristicas'] = $this->inventario_model->get_caracteristicas_producto(array('cxu_id_art' => $art_id,'cxu_estado'=>1));
        $data['detalle'] = $this->inventario_model->get_caracteristicas_formula(array('dxf_id_foa' => $foa_id));
        $data['articulo'] = $articulo[0];
        $data['formula'] = $formula[0];

        $operadores = $this->gsatelite->get_parametro('SYS_FORMULAS_MAT');
        $data['operadores'] = json_decode($operadores, true);
        $data['ver'] = $ver;
        $data['titulo_personal'] = "Agregar Fórmula - " . $articulo[0]['art_codigo'] . ' - ' . $articulo[0]['art_nombre'];
        cargarvista($data, null, 'inventario/mantenimiento/editar_formula');
    }

    function get_detalles_tipo_articulo() {
        if ($this->input->post()) {
            $post_array = $this->input->post();

            $tia_id = $post_array['tipo_articulo'];

            $impuestos_html = "";
            $caracteristicas_html = "";
            $cuentas_contables_html = "";

            if ($tia_id > 0) {
                $data['caracteristicas'] = $this->inventario_model->get_caracteristica($tia_id);
                $caracteristicas_html = $this->load->view('inventario/mantenimiento/detalles_categoria_producto', $data, true);

                $data['caracteristicas'] = null;
                $data['cuentas_contables'] = $this->inventario_model->get_cuenta_categoria(array('dta_id_tia' => $tia_id));
                $cuentas_contables_html = $this->load->view('inventario/mantenimiento/detalles_categoria_producto', $data, true);

                $data['caracteristicas'] = null;
                $data['cuentas_contables'] = null;
                $data['impuestos'] = $this->inventario_model->get_impuestos_categoria(array('ixr_id_tia' => $tia_id));
                $impuestos_html = $this->load->view('inventario/mantenimiento/detalles_categoria_producto', $data, true);
            }
//print_r($cuentas_contables_html);
//die();
            $resultado = array(
                'caracteristicas' => trim($caracteristicas_html),
                'impuestos' => trim($impuestos_html),
                'cuentas_contables' => trim($cuentas_contables_html),
            );

            echo json_encode($resultado);
        }
    }

    /**
     * @author Elman Ortiz
     * @date 15/08/2017
     * @modified: Nelson Soriano - 02-11-2019 - agregacion de precio a caracteristicas de productos
     */
    function caracteristicas_agregar($otro_modulo = null){        
        satelite_validar();        
        if ($this->input->post('tipoboton') == 'cancel') {
            if ($this->input->post('otro_modulo') != "") {
                $m = $this->input->post('otro_modulo');
                redirect($m . 'caracteristicas');
            } else {
                redirect('inventario/mantenimiento/caracteristicas');
            }            
        }

        if ($this->input->post()) {//Para guardar las caracteristicas            
            //Crear arreglo caracteristicas            
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => 1,
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );

            $car_id  = $this->gsatelite->ingresar('car_caracteristica', $caracteristica_array);
            $valores = $this->input->post('valores'); 
            $precios = $this->input->post('preciosCa');   
            $lista   = array_combine($valores, $precios);              
            if ($lista) {
                //$elem = " ";
                foreach ($lista as $key => $value) {                    
                    //vrl_valores_lista
                    $valores_lista_array = array(                
                        'vrl_id_car'                => $car_id,
                        'vrl_valor'                 => $key,
                        'vrl_precio_valor'          => ($value != '')?$value:null,
                        'vrl_estado'                => 1,
                        'vrl_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion'        => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                      
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }   

            }/*else{
                //vrl_valores_lista
                $valores_lista_array = array(                
                    'vrl_id_car' => $car_id,
                    'vrl_valor' => ($this->input->post('inpValorUnico')) ? $this->input->post('inpValorUnico') : null,
                    'vrl_estado' => 1,
                    'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                    'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                );  
            }*/
            $otro_modulo = ($this->input->post('otro_modulo') != "") ? $this->input->post('otro_modulo') : null;
            
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);

            if ($this->input->post('tipoboton') == 'save') {
                if ($otro_modulo) {
                    redirect($otro_modulo . 'caracteristicas_agregar');
                } else {
                    redirect('inventario/mantenimiento/caracteristicas_agregar/');
                }                
            } else {
                if ($otro_modulo) {
                    redirect($otro_modulo . 'caracteristicas');
                } else {
                    redirect('inventario/mantenimiento/caracteristicas/');
                }
            }
        }else{//Mostrar vista para caracteristicas            
            $last = $this->inventario_model->get_max_codigo('car_caracteristica', 'car_codigo');
            $code = $last->codigo;
            $cod = (int) $code + 1;
            $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);            

            $data['otro_modulo'] = $otro_modulo;
            $data['titulo_personal'] = "Catálogo de características";
            $data['codigo'] = $codigo;
            cargarvista($data,null,'inventario/mantenimiento/caracteristicas_agregar');
        }
    }

    /**
     * @author Elman Ortiz
     * @date 15/08/2017
     */
    function caracteristicas_ver($car_id, $otro_modulo = null){
        satelite_validar();
                                  $this->db->join('vrl_valores_lista','car_id =vrl_id_car','left');
        $data['caracteristica'] = $this->gsatelite->get_tabla('car_caracteristica', array('car_id'=>$car_id));
        $data['otro_modulo'] = $otro_modulo;
        $data['titulo_personal'] = "Ver características";
        cargarvista($data,null,'inventario/mantenimiento/caracteristicas_ver');
    }

    /**
     * @author Elman Ortiz
     * @date 17/08/2017
     */
    function caracteristicas_eliminar($car_id, $otro_modulo = null){
        $tbl_vrl = $this->gsatelite->get_tabla('vrl_valores_lista', array('vrl_id_car' => $car_id));        
        $result1 = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));        
        $result2 = $this->inventario_model->delete_caracteristica(array('car_id' => $car_id));        
        if ($result2 < 1 && count($tbl_vrl) > 0) {//No se pudo borrar y reversion de los datos eliminados
            $vrl_array = array(                
                'vrl_id_car' => $tbl_vrl[0]['vrl_id_car'],
                'vrl_valor' => $tbl_vrl[0]['vrl_valor'],                
                'vrl_estado' => $tbl_vrl[0]['vrl_estado'],
                'vrl_usu_modificacion' => $tbl_vrl[0]['vrl_usu_modificacion'],
                'vrl_fecha_modificacion' => $tbl_vrl[0]['vrl_fecha_modificacion'],
                'vrl_usu_creacion' => $tbl_vrl[0]['vrl_usu_creacion'],
                'vrl_fecha_creacion' => $tbl_vrl[0]['vrl_fecha_creacion']
            );
            $registro = $this->gsatelite->ingresar('vrl_valores_lista', $vrl_array);
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar característica", 'texto_alerta' => "Otros registros dependen de este, por lo tanto no podrá ser eliminado.");
        }else{
            if($result2 == 0){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar característica", 'texto_alerta' => "Otros registros dependen de este, por lo tanto no podrá ser eliminado.");
            }else{
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Eliminar característica", 'texto_alerta' => "El registro se eliminó correctamente.");
            }            
        }
        $this->session->set_flashdata($alerta);
        if ($otro_modulo) {
            redirect($otro_modulo . "caracteristicas");
        } else {
            redirect('inventario/mantenimiento/caracteristicas');
        }
    }

    /**
     * @author Elman Ortiz
     * @date 21/08/2017
     */
    function caracteristicas_editar($car_id = null, $otro_modulo = null){
        satelite_validar();
        if($_POST){//Guardar datos

            $car_id = $this->input->post('car_id');            
            //Crear arreglo caracteristicas            
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => $this->input->post('slcEstado'),
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('car_caracteristica', $caracteristica_array, array('car_id'=>$car_id));            
            $res = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));                            
            $valores = $this->input->post('valores');   
            $precios = $this->input->post('preciosCaUpdate');    
            $lista   = array_combine($valores, $precios);     
            //print_r(($lista)); die();
            if ($lista) {
                //$elem = " ";                                
                foreach ($lista as $key => $value) {                    
                    //vrl_valores_lista
                    $valores_lista_array = array(                
                        'vrl_id_car'             => $car_id,
                        'vrl_valor'              => $key,
                        'vrl_precio_valor'       => ($value != '')?$value:null,
                        'vrl_estado'             => 1,
                        'vrl_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }                
            }
            $otro_modulo = ($this->input->post('otro_modulo') != "") ? $this->input->post('otro_modulo') : null;
            
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);
            
            if ($this->input->post('tipoboton') == 'save') {
                if ($otro_modulo) {
                    redirect($otro_modulo . 'caracteristicas_editar/' . $car_id);
                } else {
                    redirect('inventario/mantenimiento/caracteristicas_editar/'.$car_id);
                }
            } else {
                if ($otro_modulo) {
                    redirect($otro_modulo . 'caracteristicas/');
                } else {
                    redirect('inventario/mantenimiento/caracteristicas/');
                }
            }
        }else{//Cargar datos
            satelite_validar();
                     $this->db->join('vrl_valores_lista','car_id =vrl_id_car','left');
            $carac = $this->gsatelite->get_tabla('car_caracteristica', array('car_id'=>$car_id));
            $data['car_id'] = $car_id;
            $data['caracteristica'] = $carac;
            $data['otro_modulo'] = $otro_modulo;
            $data['car_codigo'] = $carac[0]['car_codigo'];
            $data['titulo_personal'] = "Editar características";
            cargarvista($data,null,'inventario/mantenimiento/caracteristicas_editar');
        }            
    }//caracteristicas editar

    /**
    * @author Edith Herrera  
    * @return Mantenimiento de marcas 
    * @since 05/10/2017
    */
    function marca_producto() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_table('mrp_marca_producto')
                     //->set_subject('Marcas')
                     ->set_subject('')
                     ->columns('mrp_codigo','mrp_nombre','mrp_descripcion', 'mrp_estado')
                     ->fields('mrp_codigo','mrp_nombre','mrp_descripcion', 'mrp_estado', 'mrp_usu_creacion','mrp_usu_modificacion','mrp_fecha_creacion','mrp_fecha_modificacion')
                     ->display_as('mrp_codigo', 'Código')
                     ->display_as('mrp_nombre', 'Nombre')
                     ->display_as('mrp_descripcion', 'Descripción')
                     ->display_as('mrp_estado', 'Estado')
                     ->required_fields('mrp_nombre', 'mrp_codigo','mrp_estado')
                     ->set_rules('mrp_codigo','Código','trim|required|campo_unico[mrp_marca_producto.mrp_codigo]')
                     ->set_rules('mrp_nombre','Nombre','trim|required|campo_unico[mrp_marca_producto.mrp_nombre]')
                     ->field_type('mrp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('mrp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                     ->field_type('mrp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('mrp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ;

                // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
                $crud->callback_add_field('mrp_codigo', function () {
                    $tabla='mrp_marca_producto';
                    $campo='mrp_codigo';
                    $last = $this->consultas->get_max_codigo($tabla,$campo);
                    $code = $last->codigo;
                    $cod = (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                    return '<input id="field-mrp_codigo" name="mrp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                });
                $crud->callback_edit_field('mrp_codigo', function ($value, $primary_key) {
                    if($value==''){
                        $tabla = 'mrp_marca_producto';
                        $campo = 'mrp_codigo';
                        $last = $this->consultas->get_max_codigo($tabla,$campo);
                        $code = $last->codigo;
                        $cod = (int)$code+1;
                        $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                        return '<input id="field-mrp_codigo" name="mrp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                    }else{
                        return '<input id="field-mrp_codigo" name="mrp_codigo" type="text" maxlength="99" value="'.$value.'" >';
                    }
                });

                $state = $crud->getState();
                if($state== 'success'){
                    $crud->callback_field('mrp_codigo', function ($value, $primary_key) {
                        if($value==''){
                            $tabla='mrp_marca_producto';
                            $campo='mrp_codigo';
                            $last=$this->consultas->get_max_codigo($tabla,$campo);
                            $code=$last->codigo;
                            $cod= (int)$code+1;
                            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                            return '<input id="field-mrp_codigo" name="mrp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                        }else{
                            return '<input id="field-mrp_codigo" name="mrp_codigo" type="text" maxlength="99" value="'.$value.'" >';
                        }
                    });
                }
                $uri_segments = explode('/',uri_string());
                if(end($uri_segments)=='add') {
                    $crud->field_type('mrp_estado','hidden',1);
                }else {
                    $crud->field_type('mrp_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }                     
                $data['titulo_personal'] = "Marcas";
                  
                // Permisos
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if ($permisos['permite_ver']) {
                    $data_url = $this->masterpage->getUsuario();
                    $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                    $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
                }
                $output = $crud->render();
                cargarvista($data,$output,'inventario/mantenimiento/marca_producto');
            } catch(Exception $e) {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
        }
    }

    public function verificar_codigo_mrp(){
        $codigo = $this->input->post('codigo');
        $existe = $this->db->where('mrp_codigo', $codigo)->get('mrp_marca_producto')->result_array();
        $arreglo = array('drop' => count($existe));
        echo json_encode($arreglo);
    }


    /**
    * @author René Castaneda
    * @since 2017-10-10
    * @return Validación de codigo de producto
     */
    public function validar_codigo_producto(){
        $codigo = $this->input->post('txtCodigo');
        $idProd = $this->input->post('txtIdProd');
        $codigo = str_replace(array(' ','%','$','&','@','#','^','\'','"'), '', $codigo);
        // EVITAR REPETIDOS PARA EL MISMO PRODUCTO
        $query = $this->gsatelite->get_tabla('cdp_codigo_producto', array('cdp_codigo'=>$codigo, 'cdp_id_art'=>$idProd, 'cdp_estado'=>1));
        // EVITAR REPETIR UN CODIGO PADRE
        $articulos = $this->gsatelite->get_tabla('art_articulo', array('art_codigo'=>$codigo, 'art_id != '=>$idProd, 'art_estado'=>1));
        $exito = 0;
        if (count($query) > 0 || count($articulos) > 0) {
            $exito = 1;
        }
        die(json_encode(array('exito' => $exito)));
    }
    public function valida_code_producto_compra(){
        // var_dump($_POST);die();
        $prvid = $this->input->post('txtProv');
        $mepid = $this->input->post('txtMedi');
        $codigo = $this->input->post('txtCodigo');
        $idProd = $this->input->post('txtIdProd');
        // $codigo = str_replace(array(' ','%','$','&','@','#','^','\'','"'), '', $codigo);
        // EVITAR REPETIDOS PARA EL MISMO PRODUCTO
        $query = $this->gsatelite->get_tabla('cpc_codigo_producto_compras', array('cpc_codigo'=>$codigo, 'cpc_id_art'=>$idProd, 'cpc_id_prv'=>$prvid, 'cpc_id_mep'=>$mepid, 'cpc_estado'=>1));
        // EVITAR REPETIR UN CODIGO PADRE
        $articulos = $this->gsatelite->get_tabla('art_articulo', array('art_codigo'=>$codigo, 'art_id != '=>$idProd, 'art_estado'=>1));
        $existe_code = (count($query) > 0) ? 1 : 0;
        $existe_padre = (count($articulos) > 0) ? : 0;
        die(json_encode(array('codigo' => $existe_code, 'articulo' => $existe_padre)));
    }

    function get_ajax_select_unidad_medida ($id_lip = null) {
        $id_art = $this->input->post('id_art');
        if($id_lip){//Para edit
            //El valor previo
            $lip_prev = $this->gsatelite->get_tabla('lip_listado_precio',array('lip_id_art' => $id_art,'lip_id' => $id_lip));

            $where = array('cva_id_art' => $id_art, 'cva_estado' => 1);
            $this->db->join('mep_medida_producto', 'mep_id = cva_id_mep');
            $unidades_medida = $this->gsatelite->get_tabla('cva_conversion_articulo',$where);
            $slc_uni_med = '<option value=""></option>';            
            foreach ($unidades_medida as $key => $unidad_medida) {
                if($unidad_medida['cva_id_mep'] == $lip_prev[0]['lip_id_mep']){
                    $slc_uni_med .= '<option data-idcva="'.$unidad_medida['cva_id'].'" value="' .$unidad_medida['mep_id'].'" selected>'.$unidad_medida['mep_nombre'].'</option>';    
                }else{
                    $slc_uni_med .= '<option data-idcva="'.$unidad_medida['cva_id'].'" value="' .$unidad_medida['mep_id'].'">'.$unidad_medida['mep_nombre'].'</option>';    
                }
                
            }    
        }else{//Para agregar
            $where = array('cva_id_art' => $id_art, 'cva_estado' => 1);
            $this->db->join('mep_medida_producto', 'mep_id = cva_id_mep');
            $unidades_medida = $this->gsatelite->get_tabla('cva_conversion_articulo',$where);
            $slc_uni_med = '<option value=""></option>';
            foreach ($unidades_medida as $key => $unidad_medida) {
                $slc_uni_med .= '<option data-idcva="'.$unidad_medida['cva_id'].'" value="' .$unidad_medida['mep_id'].'">'.$unidad_medida['mep_nombre'].'</option>';
            }
        }        

        echo $slc_uni_med;
        die();
    }

    /*
    * Funcionalidad compartida del modulo de Contabilidad(Funcion de Agregar cuenta contable tabla: cnt_cuenta_contable)
    */
    function agregar_cuenta() {
        satelite_validar();
        $this->load->library('../controllers/modulo_contabilidad/catalogos');
        $this->catalogos->agregar_cuenta('inventario/mantenimiento');
    }

    /*
    * Funcionalidad compartida del modulo de Contabilidad(Funcion de editar cuenta contable tabla: cnt_cuenta_contable)
    */
    function editar_cuenta($id_cuenta = null) {
        satelite_validar();
        $this->load->library('../controllers/modulo_contabilidad/catalogos');
        $this->catalogos->editar_cuenta($id_cuenta, 'inventario/mantenimiento');
    }

    public function get_productos_like() {
        satelite_validar(true);
        $this->load->model('facturacion_model');
        $tipo = ($this->input->post('tipo') != '') ? $this->input->post('tipo') : null;
        $producto = ($this->input->post('producto') != '') ? $this->input->post('producto') : null;
        $where = null;
        $like = null;
        if ($tipo != null) {
            $where['art_tipo'] = $tipo;
        }
        
        if ($producto != '') {
            //$where = '(art_tipo = 1 or art_venta = 1)';
            //$like = "(CONCAT(art_codigo,' - ', art_nombre)  LIKE '%".$producto."%' OR art_codigo LIKE '%".$producto."%')";
            $like = "(art_nombre LIKE '%".$producto."%' OR art_codigo LIKE '%".$producto."%' 
                 OR art_sinonimo LIKE '%".$producto."%' OR cdp_codigo LIKE '%".$producto."%')";
        }
        $arreglo = array();
        $extra = '';
        $productos = $this->facturacion_model->get_productos_like($where, $like);

        if (count($productos) > 0) {
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['art_id'];
                $arreglo[$key]['codigo'] = $value['art_codigo'];
                //$arreglo[$key]['prod_nombre'] = $value['art_nombre'];
                $extra = ($value['cdp_codigo']!='') ? $value['cdp_codigo'] : '';
                if ($value['art_sinonimo']!='') {
                    $extra = ($extra!='') ? $extra.'/ '.$value['art_sinonimo'] : $value['art_sinonimo'];
                }
                $extra = ($extra!='') ? ' ('.$extra.')' : '';
                $arreglo[$key]['prod_nombre'] = $value['art_nombre'].$extra;
            }
        }
        echo json_encode($arreglo);
    }

    public function get_medida() {
        satelite_validar(true);
        $producto = ($this->input->post('producto') != '') ? $this->input->post('producto') : null;

        $this->db->join('mep_medida_producto', 'mep_id = cva_id_mep','inner');
        // $productos = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art'=>$producto,'cva_defecto'=>1));
        $productos = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art'=>$producto));
        $arreglo = array();
        $select = '<option value=""></option>';
        foreach ($productos as $key => $value) {
            $selected = ($value['cva_defecto'] == 1)?"selected":"";
            $select .= '<option value="'.$value['cva_id'].'" '.$selected.'>'.$value['mep_nombre'].'</option>';
        }
        // if (count($productos) > 0) {
        //     $arreglo['id'] = $productos[0]['mep_id'];
        //     $arreglo['medida'] = $productos[0]['mep_nombre'];
        // }
        echo json_encode(array('productos'=>$select, 'cantidad'=>count($productos)));
    }

    /**
    * @author Luis Navarro
    * @since  2018-06-23
    * @return Verificar si el flag de tipo de lista esta o no activo
     */
    function verificar_flag_defecto_tipo_lista() {
        satelite_validar(true);

        if($this->input->post()) {
            $flag       = $this->input->post("flag");
            $consulta   = $this->gsatelite->get_tabla('tlp_tipo_lista_precio', array('tlp_defecto'=>1, 'tlp_estado'=>1));

            if (count($consulta)>0) {
                $defecto = 1;
            } else {
                $defecto = 0;
            }

            echo json_encode(array('id' => $consulta[0]['tlp_id'], 'cant_defecto'=>count($consulta), 'es_defecto'=>$defecto));
        }
    }

        /**
     * Descripción:
     * Función para dar mantenimiento de Tipo de telefono  (tabla: tit_tipo_telefono)
     * Funcionalidad Compartida del Modulo de Expediente Personal - tipo_telefono
     * @author Rafael Cuchilla - Grupo Satélite
     * @since 2018-07-18
     * @param ninguno
     * @return Mantenimiento de Tipo de telefono
     */
    public function tipo_telefono() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->tipo_telefono();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a presentacion de producto (tabla: ppr_presentacion_producto)
     * @author Habby Lovo - Grupo satélite
     * @since  2018-10-08
     * @param  Ninguno
     * @return Mantenimiento de presentacion de producto
     */
    public function presentacion() {
        satelite_validar();

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();


            $columnas = array(
                'ppr_nombre',
                'ppr_estado'
            );

            $required = array(
                'ppr_nombre',
                'ppr_estado'
            );

            $alias = array(
                'ppr_nombre' => 'Nombre',
                'ppr_estado' => 'Estado'
            );

            $columnas_insert = array(
                'ppr_nombre',
                'ppr_estado',
                'ppr_usu_creacion',
                'ppr_fecha_creacion',
                'ppr_usu_modificacion',
                'ppr_fecha_modificacion'
            );

            $columnas_update = array(
                'ppr_nombre',
                'ppr_estado',
                'ppr_usu_modificacion',
                'ppr_fecha_modificacion'
            );

            $crud->set_table('ppr_presentacion_producto')
                    //->set_subject('Presentación de producto')
                    ->set_subject('')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->set_rules('ppr_nombre', 'Nombre', 'trim|required|campo_unico[ppr_presentacion_producto.ppr_nombre]')
                    ->field_type('ppr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ppr_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('ppr_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('ppr_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ;

            $uri_segments = explode('/', uri_string());
            if (end($uri_segments) == 'add') {
                $crud->field_type('ppr_estado', 'hidden', 1);
            } else {
                $crud->field_type('ppr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Presentación de productos";
           
            cargarvista($data, $output,'inventario/mantenimiento/presentacion');
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    //Elimina la imgen de la galeria de imagenes
    public function eliminar_imagen_galeria()
    {
        $id_anexo = $this->input->post("id_anexo");
        $exito = 0 ;
        if ($id_anexo > 0) 
        {
           $exito =  $this->gsatelite->borrado_general("gia_galeria_imagen_articulo",array("gia_id"=>$id_anexo));
        }
        die(json_encode(array("exito"=>$exito)));
    }

    //Edita el nombre de la imagen
    public function editar_nombre_anexo()
    {
        $id_anexo = $this->input->post("id_anexo");
        $nombre_anexo = $this->input->post("nombre_anexo");
        $exito = 0 ;
        if ($id_anexo > 0 && $nombre_anexo != "") 
        {
            $datos_anexo = array(
                'gia_nombre'    => $nombre_anexo,
                'gia_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'gia_fecha_modificacion'    => date("Y-m-d H:i:s")
            );
           $exito =  $this->gsatelite->actualizar_array("gia_galeria_imagen_articulo",$datos_anexo,array("gia_id"=>$id_anexo));
        }
        die(json_encode(array("exito"=>$exito)));
    }

    //Edita el codigo rgb de la imagen
    public function editar_codigo_rgb_anexo()
    {
        $id_anexo = $this->input->post("id_anexo");
        $nombre_anexo = $this->input->post("nombre_anexo");
        $exito = 0 ;
        if ($id_anexo > 0 && $nombre_anexo != "") 
        {
            $datos_anexo = array(
                'gia_codigo_color'    => $nombre_anexo,
                'gia_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'gia_fecha_modificacion'    => date("Y-m-d H:i:s")
            );
           $exito =  $this->gsatelite->actualizar_array("gia_galeria_imagen_articulo",$datos_anexo,array("gia_id"=>$id_anexo));
        }
        die(json_encode(array("exito"=>$exito)));
    }

    /**
     * @author Elman Ortiz - Grupo Satélite
     * @since  2019-03-13
     * @return Actualizar articulo, pasara la descripcion a carateristica medidas
     */
    public function actualizar_articulo_descripcion_caracteristica($password = null){
    if ($password) {
        if ($password == 'n12b5p30ateliteZ') {    

                $idcategoriaproducto = array('1','3','4','5','7','10');
                //Obtener productos        
                //die();

                //Creando la caracteristica
                $last_carac = end($this->gsatelite->get_tabla('car_caracteristica'));
                $last_idcarac = $last_carac['car_id'];
                $new_last_codcarac = trim($last_carac['car_codigo'])+1;
                
                if(strlen($new_last_codcarac) == 1){
                    $new_last_codcarac = '00'.$new_last_codcarac;  
                }
                if(strlen($new_last_codcarac) == 2){
                    $new_last_codcarac = '0'.$new_last_codcarac;
                }

                $last_nomcarac = count($this->gsatelite->get_tabla('car_caracteristica', array('car_nombre' => 'MATERIALES')));
                if($last_idcarac <= 21 and $last_nomcarac < 1){
                    $new_carac_array = array('car_codigo' => $new_last_codcarac, 
                                       'car_nombre' => 'MATERIALES',
                                       'car_descripcion' => 'Materiales',
                                       'car_tipo' => 5,
                                       'car_usu_crea' => $this->tank_auth->get_user_id(),
                                       'car_fecha_crea' => date("Y-m-d H:i:s"),
                                       'car_estado' => 1,
                                       'car_usu_mod' => $this->tank_auth->get_user_id(),
                                       'car_fecha_mod' => date("Y-m-d H:i:s")
                                    );
                    $id_carac = $this->gsatelite->ingresar('car_caracteristica', $new_carac_array);
                }else{
                    $id_carac = 22;
                    //die('***********NO SE PUEDE CONTINUAR CON EL PROCESO**************');
                }

                foreach ($idcategoriaproducto as $key => $idcat) {
                    $array_cxr = array('cxr_id_car' => $id_carac,
                          'cxr_id_tia' => $idcat,
                          'cxr_estado' => 1,
                          'cxr_usu_creacion' => $this->tank_auth->get_user_id(),
                          'cxr_fecha_creacion' => date("Y-m-d H:i:s"),
                          'cxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'cxr_fecha_modificacion' => date("Y-m-d H:i:s")
                        );

                    //Crear la nueva categoria para el articulo
                    $a = $this->gsatelite->ingresar('cxr_caractxtipo_articulo', $array_cxr);

                }

                //Obtener productos
                $articulos = $this->select_articulo_array($idcategoriaproducto);
                
                foreach ($articulos as $key => $art) {
                    $car = $this->select_ultima_carac($art['art_id']);
                    
                    //Arreglo para crear la caracteristica
                    $new_cxu = array('cxu_id_art' => $art['art_id'],
                                     'cxu_id_cxr' => $car[0]['cxr_id'], 
                                     'cxu_valor'  => ($art['art_descripcion'])? $art['art_descripcion'] : '',
                                     'cxu_estado' => 1,
                                     'cxu_usu_creacion' => $this->tank_auth->get_user_id(),
                                     'cxu_fecha_creacion' => date("Y-m-d H:i:s"),
                                     'cxu_usu_modificacion' => $this->tank_auth->get_user_id(),
                                     'cxu_fecha_modificacion' => date("Y-m-d H:i:s")
                        );
                    //Crear la nueva caracteristica para el articulo
                    $this->gsatelite->ingresar('cxu_caracxarticulo', $new_cxu);

                    //Obteniendo CXU
                    $where_up_art = array('cxr_id_car' => 1, 'cxu_id_art' => $art['art_id'], 'cxu_estado' => 1);
                    $this->db->join('cxr_caractxtipo_articulo', 'cxu_id_cxr = cxr_id');
                    $get_cxu = $this->gsatelite->get_tabla('cxu_caracxarticulo', $where_up_art);
                    
                    $cxu_valor = isset($get_cxu[0]) ? $get_cxu[0]['cxu_valor']:'';
                    
                    //Arreglo para actualizar la descripcion del articulo con
                    $upd_desc_art = array('art_descripcion' => $cxu_valor, 'art_usu_modificacion' => $this->tank_auth->get_user_id(), 'art_fecha_modificacion' => date("Y-m-d H:i:s"));
                    $this->gsatelite->actualizar_array('art_articulo', $upd_desc_art, array('art_id' => $art['art_id']));                    
                    
                }

                die('***********PROCESO COMPLETADO**************');
            }else{
                echo "*****URL INCORRECTA (PROCESO NO PUDO SER EJECUTADO)******";
            }
        }else{
            echo "*****EL PROCESO NO PUDO EJECUTARSE******";
        }
    }    

    function select_articulo_array($where_in) {            
        $query =$this->db->select('*'); 
                $this->db->from('art_articulo'); 
                $this->db->where_in('art_id_tia', $where_in);                
        return $query->get()->result_array();
    }

    function select_ultima_carac($artid) {            
        $query =$this->db->select('cxr_caractxtipo_articulo.*', false); 
                $this->db->from('art_articulo'); 
                $this->db->join('tia_tipo_articulo', 'art_id_tia = tia_id');
                $this->db->join('cxr_caractxtipo_articulo', 'tia_id = cxr_id_tia');
                $this->db->where('art_id', $artid);
                $this->db->order_by('cxr_id', 'DESC');
                $this->db->limit(1);
                
        return $query->get()->result_array();
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    function motorista(){
        satelite_validar();
        $this->load->library('../controllers/transporte/cruds');
        $this->cruds->motorista();
    }

    function tipo_licencia(){
        satelite_validar();
        $this->load->library('../controllers/transporte/cruds');
        $this->cruds->tipo_licencia();
    }

    function agregar_motorista(){
        satelite_validar();
        $this->load->library('../controllers/transporte/cruds');
        $this->cruds->agregar_motorista();
    }

    function editar_motorista($id){
        satelite_validar();
        $this->load->library('../controllers/transporte/cruds');
        $this->cruds->editar_motorista($id);
    }

    function sectorxbodega($bod_id = null) {
        satelite_validar();
        $select = '<option></option>';
                  $this->db->where('sxb_estado', 1);
        $sxb_ya = $this->inventario_model->get_sector_grid($bod_id);
        $bodega = $this->gsatelite->get_registro('bod_bodega', array('bod_id' => $bod_id));
        $idya = (count($sxb_ya) > 0) ? array_unique(array_column($sxb_ya, 'seb_id')) : array(0);
                  $this->db->where_not_in('seb_id', $idya);
        $sector = $this->gsatelite->get_tabla('seb_sector_bodega', array('seb_estado' => 1));
        foreach ($sector as $key) {
            $select .= '<option value="'.$key['seb_id'].'" data-descripcion = '.$key['seb_nombre'].'>'.$key['seb_nombre'].'</option>';
        }
        $data['bodega'] = $bod_id;
        $data['sector'] = $select;
        $data['det_sector'] = $sxb_ya;
        $data['nom_bodega'] = $bodega->bod_nombre;
        $data['titulo_personal'] = "Sector por Bodega";
        $this->_cargarvista($data);
    }

    function insertar_sectorxbodega($idsector, $idbodega){
        $exist = $this->gsatelite->get_tabla('sxb_sectorxbodega', array('sxb_estado' => 1, 'sxb_id_bod' => $idbodega, 'sxb_id_seb' => $idsector));
        if (count($exist) > 0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Sector Duplicado", 'texto_alerta' => "El Sector ya existe en esta Bodega.");
        } else {
            $cadena = array(
                'sxb_id_seb' => $idsector,
                'sxb_id_bod' => $idbodega,
                'sxb_estado' => 1,
                'sxb_usu_creacion' => $this->tank_auth->get_user_id(),
                'sxb_fecha_creacion' => date('Y-m-d H:i:s'),
                'sxb_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sxb_fecha_modificacion' => date('Y-m-d h:i:s')
            );
            $sxb_id = $this->gsatelite->ingresar('sxb_sectorxbodega', $cadena);
            if ($sxb_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Sector", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Sector", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
        }
        $this->session->set_flashdata($alerta);
        redirect('inventario/mantenimiento/sectorxbodega/' . $idbodega);
    }

    function datos_sectorxbodega($idsxb, $idbodega){
        // VALIDAR REFERENCIAS
        $art = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_id_sxb' => $idsxb));
        $sar = $this->gsatelite->get_tabla('sar_saldo_articulo', array('sar_estado' => 1, 'sar_id_sxb' => $idsxb));
        $etp = $this->gsatelite->get_tabla('etp_etapa', array('etp_estado' => 1, 'etp_id_sxb' => $idsxb));
        $dxd = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_estado' => 1, 'dxd_id_sxb' => $idsxb));
        $dtr = $this->gsatelite->get_tabla('dtr_detalle_traslado_pendiente', array("dtr_estado" => 1, "dtr_id_sxb = $idsxb OR dtr_id_sxb_salida = $idsxb" => null));
        $dee = $this->gsatelite->get_tabla('dee_detalle_mov', array('dee_estado' => 1, 'dee_id_sxb' => $idsxb));
        if (count($art) > 0 || count($sar) > 0 || count($etp) > 0 || count($dxd) > 0 || count($dtr) > 0 || count($dee) > 0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Sector", 'texto_alerta' => "Otros registros dependen de este,<br />Por lo tanto No podrá ser eliminado");
        } else {
            $borro = $this->gsatelite->borrado_general('sxb_sectorxbodega', array('sxb_id' => $idsxb));
            if ($borro > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Sector", 'texto_alerta' => "El registro se eliminó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Sector", 'texto_alerta' => "Ocurrió un error<br />No se pudo eliminar el registro");
            }            
        }
        $this->session->set_flashdata($alerta);
        redirect('inventario/mantenimiento/sectorxbodega/' . $idbodega);
    }
    
}
/* End of file mantenimiento.php */
/* Location: ./application/controllers/inventario/mantenimiento.php */