<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Kardex extends CI_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
        $this->load->library('grocery_CRUD');
        $this->load->library('excel/excel_reader.php');
    }

    function index2() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = "Consulta por nombre y código";
            $this->_cargarvista($data);
        }
    }

    function busqueda_codigo() {
        $codigo = $this->input->post('codigo_buscar');
        $informacion = $this->inventario_model->consultaxcodigo($codigo);
        $encabezado = '<img src="' . base_url('/assets/uploads/images/' . $informacion[0]['foto']) . '" style="width:150px;height:150px;">';
        $encabezado .= '<br><p><b>Codigo: </b>' . $informacion[0]['codigo'] . '</p>';
        $encabezado .= '<p><b>Nombre: </b>' . $informacion[0]['nombre'] . '</p>';
        $cadena = '';
        foreach ($informacion as $key) {
            $cadena .= '<tr><td>' . $key['furgon'] . '</td>';
            $cadena .= '<td>' . $key['caja'] . '</td>';
            $cadena .= '<td>' . $key['Entradas'] . '</td>';
            $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/consultas/consultas_detalle_entradas/' . $key['ixc'] . '">Ver entradas</a></td>';
            $cadena .= '<td>' . $key['Salidas'] . '</td>';
            $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/consultas/consultas_detalle_salidas/' . $key['ixc'] . '">Ver salidas</a></td>';
            $cadena .= '<td>' . $key['Saldo'] . '</td>';
            $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/consultas/consulta_detalle_furgon/' . $key['id_art'] . '/' . $key['furgon'] . '">Ver detalles</a></td></tr>';
        }
        $arreglo = array(
            "drop" => $cadena,
            "drop2" => $encabezado
        );
        //exit();
        echo json_encode($arreglo);
    }

    function consultas_detalle_salidas($ixc) {
        $data['detalle_salidas'] = $this->inventario_model->detalle_salidasxsar_id($ixc);
        $this->load->view('inventario/consultas/consultas_detalle_salidas', $data);
    }

    function consultas_detalle_entradas($ixc) {
        $data['detalle_entradas'] = $this->inventario_model->detalle_entradasxsar_id($ixc);
        $this->load->view('inventario/consultas/consultas_detalle_entradas', $data);
    }

    function consulta_detalle_furgon($articulo, $furgon) {
        $data['detalle_furgon'] = $this->inventario_model->detalle_existenciaxfurgon($articulo, $furgon);
        $this->load->view('inventario/consultas/consultas_detalle_furgon', $data);
    }

    function index() {
        $data['solicitudes'] = $this->inventario_model->consulta_general('tra_translado');
        $data['titulo_personal'] = 'KARDEX POR PRODUCTO';
        $this->_cargarvista(null, $data);
    }

    function krdx_producto() {
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->get_bodegas_usuario();

        $data['titulo_personal'] = 'Kardex por producto';
        $this->_cargarvista(null, $data);
    }

    function krdx_tipo_art() {
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->get_bodegas_usuario();
        $data['titulo_personal'] = 'Kardex por categoría';
        $this->_cargarvista(null, $data);
    }

    function cuentas_afectadas() {
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->get_bodegas_usuario();
        $data['titulo_personal'] = 'Cuentas afectadas';
        $this->_cargarvista(null, $data);
    }

    function get_kardex_producto() {
        $id_prod = $this->input->post('id_prod');
        $id_bod = $this->input->post('id_bod');
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        if ($fecha_ini > $fecha_fin) {
            die();
        } else {
            
        }
        /* print_r($id_bod.'*'.$id_prod.'*'.$fecha_ini.'*'.$fecha_fin);
          exit(); */

        $kardex_prod = $this->inventario_model->kardex_producto($id_prod, $id_bod, $fecha_ini, $fecha_fin);
        //echo die(print_r($this->db->last_query()));
        $nombre_prod = $this->db->where('art_id', $id_prod)->join('mep_medida_producto', 'mep_id=art_id_mep')->get('art_articulo')->result_array();
        $nombre_bod = $this->inventario_model->cargar_registro('bod_bodega', 'bod_id', $id_bod);


        $precios_detalle = array();
        foreach ($kardex_prod as $key) {
            array_push($precios_detalle, $key['dee_cantidad']);
        }

        $total_dee_cantidad = array_sum($precios_detalle);

        //header("Content-type: application/vnd.ms-excel");

        $html = '';
        $html .= '<thead>';
        $html .= '<tr>';
        $html .= '<th colspan="13" height="5">';
        $html .= '<center><b>BODEGA: ' . $nombre_bod['bod_nombre'] . '</b></center>';
        $html .= '<center><b>PRODUCTO: ' . $nombre_prod[0]['art_nombre'] . '- IDENTIFICADOR[' . $nombre_prod[0]['art_codigo'] . ']</b></center>';
        $html .= '<center><b>MEDIDA: ' . $nombre_prod[0]['mep_nombre'] . '</b></center>';
        $html .= '</th>';
        /* $html.='</tr><tr>'; 
          $html.='<th colspan="13">';
          $html.='<center>PRODUCTO: <span>'.$nombre_prod[0]['art_nombre'].'- IDENTIFICADOR['.$nombre_prod[0]['art_codigo'].']</span></center>';
          $html.='</th>';
          $html.='</tr>';
          $html.='<tr>';
          $html.='<th colspan="13">';
          $html.='<center>MEDIDA: <span>'.$nombre_prod[0]['mep_nombre'].'</span></center>';
          $html.='</th>'; */
        $html .= '</tr>';
        $html .= '<tr>';
        $html .= '<th >';
        $html .= 'FECHA';
        $html .= '</th>';
        $html .= '<th >';
        $html .= 'PROCESO';
        $html .= '</th>';
        $html .= '<th >';
        $html .= 'TIPO';
        $html .= '</th>';
        $html .= '<th >';
        $html .= 'DOCUMENTO';
        $html .= '</th>';
        $html .= '<th >';
        $html .= 'PROVEEDOR';
        $html .= '</th>';
        $html .= '<th colspan="3">';
        $html .= 'ENTRADAS';
        $html .= '</th>';
        $html .= '<th colspan="3">';
        $html .= 'SALIDAS';
        $html .= '</th>';
        $html .= '<th colspan="3">';
        $html .= 'EXISTENCIAS';
        $html .= '</th>';
        $html .= '</tr>';
        $html .= '</thead><tbody id="contenedor">';
        if (!empty($kardex_prod)) {


            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td>Cantidad</td>';
            $html .= '<td>Precio</td>';
            $html .= '<td>Total</td>';
            $html .= '<td>Cantidad</td>';
            $html .= '<td>Precio</td>';
            $html .= '<td>Total</td>';
            $html .= '<td>Saldo Cantidad</td>';
            $html .= '<td colspan="2"><span style="alignment:right;">Saldo Valor</span></td>';
            $html .= '</tr>';

            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Saldo Inicial</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td colspan="2">0</td>';
            $html .= '</tr>';

            $dee_cantidad1 = array();
            $dee_cantidad2 = array();
            $dee_precio1 = array();
            $dee_precio2 = array();
            $monto_existencia = array();
            $entradas = array();
            $salidas = array();
            $cantidad_existencia = array();
            foreach ($kardex_prod as $key) {   // estoy aca
                $html .= '<tr>';
                $html .= '<td>' . date("Y-m-d", strtotime($key['moi_fecha_mov'])) . '</td>';
                if ($key['tip_entrada'] == 1) {
                    $html .= '<td style="text-align:left;">' . $key['tip_nombre'] . '</td>';
                    $html .= '<td style="text-align:left;">' . $key['tip_nombre'] . '</td>';
                } else {
                    $html .= '<td style="text-align:right;">' . $key['tip_nombre'] . '</td>';
                    $html .= '<td style="text-align:right;">' . $key['tip_nombre'] . '</td>';
                }

                $html .= '<td>' . $key['moi_documento'] . '</td>';
                $html .= '<td>' . $key['prv_nombre'] . '</td>';


                if ($key['tip_entrada'] == 1) {
                    $html .= '<td style="color: blue; text-align:right;">' . number_format($key['dee_cantidad'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    $html .= '<td style="color: blue; text-align:right;">' . '$' . number_format($key['dee_precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    $html .= '<td style="color: blue; text-align:right;">' . '$' . number_format(($key['dee_cantidad'] * $key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    $html .= '<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                    $total_entradas = round(($key['dee_cantidad'] * $key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES'));
                    array_push($entradas, $total_entradas);
                    $t_entradas = array_sum($entradas);
                    array_push($dee_cantidad1, $key['dee_cantidad']);
                    $ttc1 = array_sum($dee_cantidad1);
                    array_push($dee_precio1, $key['dee_precio']);
                    $ttp1 = array_sum($dee_precio1);
                }

                if ($key['tip_salida'] == 1) {
                    $html .= '<td style="color: red; text-align:right;">&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                    $html .= '<td style="color: red; text-align:right;">' . number_format($key['dee_cantidad'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    $html .= '<td style="color: red; text-align:right;">' . '$' . number_format($key['dee_precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    $html .= '<td style="color: red; text-align:right;">' . '$' . number_format(($key['dee_cantidad'] * $key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                    $total_salidas = round(($key['dee_cantidad'] * $key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES'));
                    array_push($salidas, $total_salidas);
                    $t_salidas = array_sum($salidas);
                    array_push($dee_cantidad2, $key['dee_cantidad']);
                    $ttc2 = array_sum($dee_cantidad2);
                    array_push($dee_precio2, $key['dee_precio']);
                    $ttp2 = array_sum($dee_precio2);
                }

                if ($key['cantidad_existencia'] == null) {
                    $html .= '<td>0</td>';
                    $html .= '<td colspan="2"><span style="alignment:right;">' . '$0' . '</span></td>';
                } else {
                    if ($key['tip_salida'] == 1) {
                        $html .= '<td style="color: red; text-align:right;">' . number_format($key['cantidad_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                        $html .= '<td colspan="2" style="color: red;"><span style="alignment:right;">' . '$' . number_format($key['monto_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</span></td>';
                    } else {
                        $html .= '<td style="color: blue; text-align:right;">' . number_format($key['cantidad_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</td>';
                        $html .= '<td colspan="2" style="color: blue;"><span style="alignment:right;">' . '$' . number_format($key['monto_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')) . '</span></td>';
                    }

                    array_push($cantidad_existencia, $key['cantidad_existencia']);
                    $total_cantidad_existencia = array_sum($cantidad_existencia);
                    array_push($monto_existencia, $key['monto_existencia']);
                    $total_monto_existencia = array_sum($monto_existencia);
                }

                $html .= '</tr>';
            }
            /* $html.='<tr>';
              $html.='<td></td>';
              $html.='<td><b>Total:</b></td>';
              $html.='<td></td>';
              $html.='<td style="color: blue; text-align:right;">'.number_format($ttc1,2).'</td>';
              $html.='<td style="color: blue; text-align:right;"><!--$'.number_format($ttp1,2).'--></td>';
              $html.='<td style="color: blue; text-align:right;">$'.number_format($t_entradas,2).'</td>';
              if(isset($ttc2) && isset($ttp2) && isset($t_salidas)){
              $html.='<td style="color: red; text-align:right;">'.number_format($ttc2,2).'</td>';
              $html.='<td style="color: red; text-align:right;"><!--$'.number_format($ttp2,2).'--></td>';
              $html.='<td style="color: red; text-align:right;">$'.number_format($t_salidas,2).'</td>';
              }
              else
              {
              $html.='<td>'./*$total_cantidad_existencia. */'</td>';
            //$html.='<td>'./*round($total_monto_existencia,2).*/'</td>';
            //$html.='<td>'./*$total_cantidad_existencia.*/'</td>';
            //}
            // $html.='<td>'./*$total_cantidad_existencia.*/'</td>';
            //$html.='<td>'./*round($total_monto_existencia,2).*/'</td>';
            //$html.='</tr>';

            $html .= '</tbody>';
        } else {

            $html .= '<tr><td colspan="12" style="text-align:center;">NO SE ENCONTRARON REGISTROS</td>';

            $html .= '</tr>';
        }
        $arreglo = array(
            "drop" => $html
        );

        echo json_encode($arreglo);
    }

    function get_kardex_tipo() {
        $ultima_categoria = $this->input->post('categoria');
        $bodega = $this->input->post('bodega');
        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');
        $flag = $this->input->post('flag');
        if ($fecha_ini > $fecha_fin) {
            die();
        } else {
            
        }
        /* print_r($id_bod.'*'.$id_prod.'*'.$fecha_ini.'*'.$fecha_fin);
          exit(); */
        // echo    print_r($ultima_categoria); exit();
        //$nombre_cat = $this->inventario_model->cargar_registro('tia_tipo_articulo','tia_id',$id_cat);
        $nombre_bod = $this->inventario_model->cargar_registro('bod_bodega', 'bod_id', $bodega);

        //header("Content-type: application/vnd.ms-excel");
        // $html.='</tr><tr>'; 
        //         $html.='<th colspan="12">';
        //         $html.='<center>PRODUCTO: <span>'.$nombre_prod[0]['art_nombre'].'- IDENTIFICADOR['.$nombre_prod[0]['art_codigo'].']</span></center>';
        //         $html.='</th>';

        $cabezera = '';
        $cabezera2 = '';
        $cabezera .= '<thead>';
        $cabezera .= '<tr>';
        $cabezera .= '<th colspan="14">';
        $cabezera .= '<center>BODEGA: <span>' . $nombre_bod['bod_nombre'] . '</span></center>';
        $cabezera .= '</th>';
        $cabezera .= '</tr>';
        $cabezera .= '<tr><th colspan="14">';
        //$cabezera.='<center>TIPO DE PRODUCTO: <span>'.$nombre_cat['tia_nombre'].'</span></center>';
        $cabezera .= '</th>';
        $cabezera .= '</tr>';
        $cabezera2 .= '<tr>';
        $cabezera2 .= '<th >';
        $cabezera2 .= 'FECHA';
        $cabezera2 .= '</th>';
        $cabezera2 .= '<th >';
        $cabezera2 .= 'PROCESO';
        $cabezera2 .= '</th>';
        $cabezera2 .= '<th >';
        $cabezera2 .= 'DOCUMENTO';
        $cabezera2 .= '</th>';
        $cabezera2 .= '<th >';
        $cabezera2 .= 'UM';
        $cabezera2 .= '</th>';
        $cabezera2 .= '<th >';
        $cabezera2 .= 'ART&Iacute;CULO';
        $cabezera2 .= '</th>';
        $cabezera2 .= '<th colspan="3">';
        $cabezera2 .= 'ENTRADAS';
        $cabezera2 .= '</th>';
        $cabezera2 .= '<th colspan="3">';
        $cabezera2 .= 'SALIDAS';
        $cabezera2 .= '</th>';
        $cabezera2 .= '<th colspan="3">';
        $cabezera2 .= 'SALDO ACTUAL';
        $cabezera2 .= '</th>';
        $cabezera2 .= '</tr>';
        $cabezera2 .= '</thead><tbody id="contenedor">';

        $cabezera2 .= '<tr>';
        $cabezera2 .= '<td></td>';
        $cabezera2 .= '<td></td>';
        $cabezera2 .= '<td></td>';
        $cabezera2 .= '<td></td>';
        $cabezera2 .= '<td>Descripci&oacute;n</td>';
        $cabezera2 .= '<td>Cantidad</td>';
        $cabezera2 .= '<td>Precio</td>';
        $cabezera2 .= '<td>Total</td>';
        $cabezera2 .= '<td>Cantidad</td>';
        $cabezera2 .= '<td>Precio</td>';
        $cabezera2 .= '<td>Total</td>';
        $cabezera2 .= '<td colspan="3"><span style="text-align:right;">Saldo</span></td>';
        $cabezera2 .= '</tr>';

        $padre_del_padre = array();
        $i = 0;
        if ($ultima_categoria == "") {
            $categorias_total = $this->inventario_model->get_categorias();

            foreach ($categorias_total as $y) {
                $padre_del_padre[] = $y['tia_id'];
            }
            array_push($padre_del_padre, '');
        } else {
            while ($ultima_categoria != null) {
                if ($i == 0) {
                    $padre_del_padre[] = $ultima_categoria;
                } else {
                    $ultima_categoria = $this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria = $ultima_categoria['tia_padre'];
                    $padre_del_padre[] = $ultima_categoria;
                }
                $i++;
            }
        }
        $categorias_final = array_reverse($padre_del_padre);


        /* -------------------------------------------------------------------- */


        /* ---------------------DEPENDENCIAS ENCONTRADAS----------------------- */

        $cadena = ""; // arreglo que mandaremos en un json
        $elementos = array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

        foreach ($categorias_final as $key => $value) {
            if ($key != null) {
                $elemento = $this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                $elementos[] = array($elemento['tia_id'] => $elemento['tia_nombre']);
            }
        }


        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $col = 14;
        } else {
            $col = 11;
        }
        $ultimo_padre = end($elementos);

        $departamento_inf_tr = "";
        $departamento_infe_tr = "";
        $i = 1;
        foreach ($elementos as $key => $value) {
            foreach ($value as $ids => $valores) {


                if ($ids != key($ultimo_padre)) {

                    $departamento_infe_tr = '<tr><td colspan="14"><b><br />Departamento ' . $i . ': ' . $valores . '</b></td></tr>';
                } else {

                    $tia_hijo = $this->inventario_model->get_tia_hijo($bodega, $ids);

                    if (count($tia_hijo) > 0) {
                        $departamento_inf_tr .= $departamento_infe_tr;
                        foreach ($tia_hijo as $tia => $tipo) {

                            $informacion = $this->inventario_model->kardex_tipo($tipo['tia_id'], $bodega, $fecha_ini, $fecha_fin);
                            //print_r($informacion);
                            $cat_cuenta = $this->gsatelite->get_campo('tia_tipo_articulo', 'tia_id_cco', array('tia_estado' => 1, 'tia_id' => $tipo['tia_id']));
                            $cuenta_nombre = $this->gsatelite->get_campo('cco_cuenta_contable', 'cco_nombre', array('cco_id' => $cat_cuenta));
                            $cuenta = '';
                            if ($flag == 1) {
                                if (!empty($cuenta_nombre)) {
                                    $cuenta = ", Cuenta Contable : " . $cuenta_nombre;
                                }
                            }

                            if (count($informacion) > 0) {
                                $departamento_inf_tr .= '<tr><td colspan="14"><b><br />Categoría ' . $i . ': ' . $tipo['tia_nombre'] . $cuenta . '</b></td></tr>';
                                $departamento_inf_tr .= $cabezera2;
                                $departamento_inf_tr .= $this->cuerpo_kardex($informacion);
                            }
                        }
                    } else {
                        $informacion = $this->inventario_model->kardex_tipo($ids, $bodega, $fecha_ini, $fecha_fin);
                        $cat_cuenta = $this->gsatelite->get_campo('tia_tipo_articulo', 'tia_id_cco', array('tia_estado' => 1, 'tia_id' => $ids));
                        $cuenta_nombre = $this->gsatelite->get_campo('cco_cuenta_contable', 'cco_nombre', array('cco_id' => $cat_cuenta));
                        //print_r($this->db->last_query());
                        $cuenta = '';
                        if ($flag == 1) {
                            if (!empty($cuenta_nombre)) {
                                $cuenta = ", Cuenta Contable : " . $cuenta_nombre;
                            }
                        }
                        if (count($informacion) > 0) {

                            if (!empty($cuenta_nombre)) {
                                $departamento_inf_tr .= '<tr><td colspan="14"><b>Cuenta Contable: ' . $cuenta_nombre . '</b></td></tr>';
                            }


                            $departamento_inf_tr .= '<tr><td colspan="14"><b>Categoría ' . $i . ': ' . $valores . '</b></td></tr>';
                            $departamento_inf_tr .= $cabezera2;
                            $departamento_inf_tr .= $this->cuerpo_kardex($informacion);
                        }
                    }
                }
            }
            $i++;
        }

        if (empty($informacion)) {
            $cadena .= $cabezera . '<tr><td colspan="14" style="text-align:center;">NO SE ENCONTRARON REGISTROS</td></tr>';
        } else {
            $cadena .= $cabezera . $departamento_inf_tr;
        }



        // $kardex_tipo = $this->inventario_model->kardex_tipo($id_cat,$id_bod,$fecha_ini,$fecha_fin);



        $arreglo = array(
            "drop" => $cadena
        );

        echo json_encode($arreglo);
    }

    public function cuerpo_kardex($informacion) {
        $dee_cantidad1 = array();
        $dee_cantidad2 = array();
        $dee_precio1 = array();
        $dee_precio2 = array();
        $monto_existencia = array();
        $entradas = array();
        $salidas = array();
        $cantidad_existencia = array();
        $html = "";
        foreach ($informacion as $key) {
            $html .= '<tr>';
            $html .= '<td>' . date("Y-m-d", strtotime($key['moi_fecha_mov'])) . '</td>';
            $html .= '<td>' . $key['tip_nombre'] . '</td>';
            $html .= '<td>' . $key['moi_documento'] . '</td>';
            $html .= '<td>' . $key['mep_nombre'] . '</td>';
            $html .= '<td>' . $key['art_nombre'] . '[' . $key['art_codigo'] . ']</td>';
            if ($key['tip_entrada'] == 1) {
                $html .= '<td style="color: blue; text-align:right;">' . number_format($key['dee_cantidad'], 2) . '</td>';
                $html .= '<td style="color: blue; text-align:right;">' . '$' . number_format($key['dee_precio'], 2) . '</td>';
                $html .= '<td style="color: blue; text-align:right;">' . '$' . number_format(round(($key['dee_cantidad'] * $key['dee_precio']), 2), 2) . '</td>';
                $html .= '<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                $total_entradas = round(($key['dee_cantidad'] * $key['dee_precio']), 2);
                array_push($entradas, $total_entradas);
                $t_entradas = array_sum($entradas);
                array_push($dee_cantidad1, $key['dee_cantidad']);
                $ttc1 = array_sum($dee_cantidad1);
                array_push($dee_precio1, $key['dee_precio']);
                $ttp1 = array_sum($dee_precio1);
            }

            if ($key['tip_salida'] == 1) {
                $html .= '<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                $html .= '<td style="color: red; text-align:right;">' . number_format($key['dee_cantidad'], 2) . '</td>';
                $html .= '<td style="color: red; text-align:right;">' . '$' . number_format($key['dee_precio'], 2) . '</td>';
                $html .= '<td style="color: red; text-align:right;">' . '$' . number_format(round(($key['dee_cantidad'] * $key['dee_precio']), 2), 2) . '</td>';
                $total_salidas = round(($key['dee_cantidad'] * $key['dee_precio']), 2);
                array_push($salidas, $total_salidas);
                $t_salidas = array_sum($salidas);
                array_push($dee_cantidad2, $key['dee_cantidad']);
                $ttc2 = array_sum($dee_cantidad2);
                array_push($dee_precio2, $key['dee_precio']);
                $ttp2 = array_sum($dee_precio2);
            }

            if ($key['cantidad_existencia'] == null) {
                $html .= '<td>0</td>';
                $html .= '<td colspan="2" style="text-align:right;"><span style="text-align:right;">' . '$0' . '</span></td>';
            } else {
                if ($key['tip_salida'] == 1) {
                    $html .= '<td style="color: red; text-align:right;">' . number_format($key['cantidad_existencia'], 2) . '</td>';
                    $html .= '<td colspan="2" style="color: red; text-align:right;"><span style="text-align:right;">' . '$' . number_format(round($key['monto_existencia'], 2), 2) . '</span></td>';
                } else {
                    $html .= '<td style="color: blue; text-align:right;">' . number_format($key['cantidad_existencia'], 2) . '</td>';
                    $html .= '<td colspan="2" style="color: blue; text-align:right;"><span style="text-align:right;">' . '$' . number_format(round($key['monto_existencia'], 2), 2) . '</span></td>';
                }
                array_push($cantidad_existencia, $key['cantidad_existencia']);
                $total_cantidad_existencia = array_sum($cantidad_existencia);
                array_push($monto_existencia, $key['monto_existencia']);
                $total_monto_existencia = array_sum($monto_existencia);
            }

            $html .= '</tr>';
        }
        $html .= '<tr>';
        $html .= '<td></td>';
        $html .= '<td><b>Total:</b></td>';
        $html .= '<td></td>';
        $html .= '<td></td>';
        $html .= '<td></td>';
        $html .= '<td style="color: blue; text-align:right;">' . number_format(round($ttc1, 2), 2) . '</td>';
        $html .= '<td style="color: blue; text-align:right;"><!--$' . number_format(round($ttp1, 2), 2) . '--></td>';
        $html .= '<td style="color: blue; text-align:right;">$' . number_format($t_entradas, 2) . '</td>';
        if (isset($ttc2) && isset($ttp2) && isset($t_salidas)) {
            $html .= '<td style="color: red; text-align:right;">' . number_format(round($ttc2, 2), 2) . '</td>';
            $html .= '<td style="color: red; text-align:right;"><!--$' . number_format(round($ttp2, 2), 2) . '--></td>';
            $html .= '<td style="color: red; text-align:right;">$' . number_format($t_salidas, 2) . '</td>';
        } else {
            $html .= '<td>' . /* $total_cantidad_existencia. */'</td>';
            $html .= '<td>' . /* round($total_monto_existencia,2). */'</td>';
            $html .= '<td>' . /* $total_cantidad_existencia. */'</td>';
        }

        $html .= '<td></td>';
        $html .= '<td></td>';

        $html .= '</tr>';

        $html .= '</tbody>';

        return $html;
    }

    function export_excel($tipoR = 1) {
        //$tipoR=1 (excel), $tipoR=2 (pdf)
        if ($tipoR == 1) {
            // header("Content-type: application/vnd.ms-excel; name='excel'"); 
            // header("Content-Disposition: filename=ficheroExcel.xls"); 
            // header("Pragma: no-cache"); 
            // header("Expires: 0"); 


            $us = $this->tank_auth->get_user_id();
            $user = $this->gsatelite->get_campo('users', 'username', array('id' => $us));
            $titulo = "kardex producto";
            $encabezado = $this->load->view('reporte/header_excel', array('titulo' => $titulo, 'user' => $user), true);



            $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header'] = $encabezado;
            $data['table_tbody'] = $_POST['datos_a_enviar'];
            $data['filename'] = $filename;

            $this->load->view('inventario/kardex/export_excel.php', $data);
        } else if ($tipoR == 2) {
            // die(print_r($_POST['datos_a_enviar']));
            $data['table_header'] = "<br>";
            $data["table_tbody"] = $_POST['datos_a_enviar'];
            $this->pdf->reportePDF('inventario/reportes/reporte_kardexproducto_pdf.php', $data, 'kardex producto', 'L');
        }
    }

    function generar_boleta() {
        $id_solicitud = $this->input->get('identificador');
        $obtener_movimiento_salida = $this->inventario_model->consulta_condicion_resultado('tra_translado', 'tra_id', $id_solicitud);
        $id_movimiento_salida = $obtener_movimiento_salida[0]['tra_id_moi_sal'];

        $campos_pdf = "dee_cantidad, dee_precio,art_nombre";
        $join_pdf = "dee_detalle_mov,dbo.sar_saldo_articulo.sar_id = dbo.dee_detalle_mov.dee_id_sar/art_articulo,dbo.art_articulo.art_id = dbo.sar_saldo_articulo.sar_id_art";
        $tabla = "sar_saldo_articulo";
        $campo_condicion = "dbo.dee_detalle_mov.dee_id_moi";
        $data['detalle'] = $this->inventario_model->consulta_ejecutando_join($tabla, $campos_pdf, $join_pdf, $campo_condicion, $id_movimiento_salida);
        $html = $this->load->view('inventario/boleta_traslado/generar_pdf', $data, true);

        $this->load->library('PDF');
        $cabecera = '<table>';
        $cabecera .= '<tr>';
        $cabecera .= '<td><img src="' . base_url('/media/images/reporte/logo_small2.jpg') . '" alt="UTE" /></td>';
        $cabecera .= '<td><h1>Unidad T&eacute;cnica Ejecutiva del Sector de Justicia</h1></td>';
        $cabecera .= '</tr>';
        $cabecera .= '</table>';


        $pdf = $this->pdf->cargarPdf();
        $pdf->mirrorMargins = 1;
        //Agregar metadata al PDF
        $pdf->SetTitle('Traslado de inventario');
        $pdf->SetAuthor($this->config->item('sistema') . ' desarrollado por Grupo Satelite El Salvador');
        //Obtener el contenido de print.css
        $stylesheet = file_get_contents(base_url('stylesheets/print.css'));
        //Importante! el parametro entero 1 indica que esta es una hoja de estilo para el reporte
        $pdf->WriteHTML($stylesheet, 1);
        $pdf->SetHTMLHeader($cabecera);
        //Crear footer del reporte {sistema} - {Numero Pagina} - {fecha y hora}  
        $pdf->SetFooter($this->config->item('sistema') . '|{PAGENO}|' . date("Ymd h:i:s"));
        //Escribir el resultado HTML en el PDF
        $pdf->WriteHTML($html);
        //Guardar el archivo 
        $pdf->Output($ruta_archivo_pdf, 'D');
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}

?>