<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Inicio extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->library('excel/excel_reader.php');
    }
    
    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }
    
    function tareas_pendientes($consulta=0){
        satelite_validar();
        if ($_POST) {
            if ($consulta > 0) {
                //var_dump($_POST);die();
                $post_array = $_POST;

                $estado_requicision = $post_array['estado'];
                $fecha_inicio = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];

                $where = null;
                //Se agregan las condiciones si los filtros contienen datos
                if ($estado_requicision!='') {
                    $where['rxi_estado'] = $estado_requicision;
                }
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $where['DATE(rxi_fecha) >='] = date('Y-m-d', strtotime($fecha_inicio));
                    $where['DATE(rxi_fecha) <='] = date('Y-m-d', strtotime($fecha_fin));
                }
                
                $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                $flujos_array = json_decode($flujos, true);

                $where['flu_id'] = $flujos_array['REQ_INV'];

                //Se condiciona el paso actual
                $where['sgr_fecha_salida'] = null;
                //Condicion para obtener el seguimiento correcto del flujo
                $where['id'] = $this->tank_auth->get_user_id();
                
                $requisiciones = $this->inventario_model->get_backlog_requisiciones($where);
                //print_r($this->db->last_query());die(); 
                $data['requisiciones'] = $requisiciones;

                $html = $this->load->view('inventario/inicio/consultar_tareas', $data, true);

                echo $html;
                die();
            }
        } else{
            
            
            $data['titulo_personal'] = "Aprobaciones";
            $this->_cargarvista($data);
        }
    }
    
     /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra.
     */
    function finalizar_paso($iframe = false,$registro,$tipo_flujo){
        
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                //var_dump($_POST);die();
                $post_array = $_POST;
                $paso_actual = $post_array['hdnActualPaso'];
                $paso_siguiente = $post_array['hdnSigPaso'];
                $txtComentario = $post_array['txtComentario'];
                
                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_requisicion = array(
                            'sgr_id_usu' => $this->tank_auth->get_user_id(),
                            'sgr_observacion' => $txtComentario,
                            'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion,array('sgr_id'=>$paso_actual));
                        
                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0){
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $registro,
                                'sgr_id_psf' => $paso_siguiente,
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );

                            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                            
                            if($seguimiento > 0 ){
                                
                            }
                        }
                        break;
                }
                
                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }
                else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal'] = "Siguiente Paso";
            $data['iframe'] = $iframe;
            $data['registro'] = $registro;
            $data['tipo_flujo'] = $tipo_flujo;
            
            switch ($tipo_flujo) {
                 case 1:
                     $data['nombre_registro'] = $this->gsatelite->get_campo('rxi_requisicion_inventario','rxi_numero',array('rxi_id'=>$registro));
                     $data['titulo_registro'] = "Requisición N.";
                     break;
            }
            
            $paso_actual = $this->inventario_model->get_paso_actual($registro,$tipo_flujo);
            $paso_siguiente = $this->inventario_model->get_paso_siguiente($registro,$tipo_flujo);
            $data['paso_actual'] = $paso_actual[0];
            $data['paso_siguiente'] = $paso_siguiente[0];
            
            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('inventario/inicio/finalizar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }
    
     /*
     * tipo flujo: 1- Requisiciones, 2- Orden de Compra.
     */
    function autorizar_paso($iframe = false,$registro,$tipo_flujo){
        
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                //var_dump($_POST);die();
                $post_array = $_POST;
                $paso_actual = $post_array['hdnActualPaso'];
                $paso_siguiente = $post_array['hdnSigPaso'];
                $txtComentario = $post_array['txtComentario'];
                
                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_requisicion = array(
                            'sgr_id_usu' => $this->tank_auth->get_user_id(),
                            'sgr_observacion' => $txtComentario,
                            'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                        );
                        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion,array('sgr_id'=>$paso_actual));
                        
                        //Si existe un siguiente paso se ingresa
                        if ($paso_siguiente > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $registro,
                                'sgr_id_psf' => $paso_siguiente,
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );
                            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                            
                            if($seguimiento > 0 ){
                                //Se actualiza el estado del registro
                                $this->cambiar_estado_registro($registro, $tipo_flujo, 3);
                            }
                        }
                        $this->gsatelite->actualizar_array('rxi_requisicion_inventario', array('rxi_id_usu_aprueba'=>$this->tank_auth->get_user_id()), array('rxi_id'=>$registro));
                        break;
                }
                
                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }
                else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal'] = "Siguiente Paso";
            $data['iframe'] = $iframe;
            $data['registro'] = $registro;
            $data['tipo_flujo'] = $tipo_flujo;
            
            switch ($tipo_flujo) {
                 case 1:
                     $data['nombre_registro'] = $this->gsatelite->get_campo('rxi_requisicion_inventario','rxi_numero',array('rxi_id'=>$registro));
                     $data['titulo_registro'] = "Requisición N.";
                     break;
            }
            
            $paso_actual = $this->inventario_model->get_paso_actual($registro,$tipo_flujo);
            $paso_siguiente = $this->inventario_model->get_paso_siguiente($registro,$tipo_flujo);
            $data['paso_actual'] = $paso_actual[0];
            $data['paso_siguiente'] = $paso_siguiente[0];
            
            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('inventario/inicio/autorizar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    function regresar_paso($iframe = false, $registro, $tipo_flujo){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $post_array     = $_POST;
                $paso_actual    = $_POST['hdnActualPaso'];//36
                $paso_anterior  = $_POST['hdnAntPaso'];//13
                $txtComentario  = $_POST['txtComentario'];//"Demasiado"
                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                switch ($tipo_flujo) {
                    case 1:
                        //Se cierra el paso actual
                        $seguimiento_requisicion = array(
                            'sgr_id_usu' => $this->tank_auth->get_user_id(),
                            'sgr_observacion' => $txtComentario,
                            'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                        );
                        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));
                        //Si existe un paso Anterior se ingresa
                        if ($paso_anterior > 0) {
                            $seguimiento_requisicion = array(
                                'sgr_id_rxi' => $registro,
                                'sgr_id_psf' => $paso_anterior,
                                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgr_estado' => 1,
                                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                            );
                            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                        }
                        //Se actualiza el estado del registro
                        $resultado = $this->cambiar_estado_registro($registro, $tipo_flujo, 4);
                        break;
                    case 2:
                        //Se cierra el paso actual
                        $seguimiento_array = array(
                            'sgo_id_usu' => $this->tank_auth->get_user_id(),
                            'sgo_observacion' => $txtComentario,
                            'sgo_fecha_salida' => date('Y-m-d H:i:s'),
                            'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                        );
                        $this->gsatelite->actualizar_array('sgo_seguimiento_orden', $seguimiento_array, array('sgo_id' => $paso_actual));
                        //Si existe un siguiente paso se ingresa
                        if ($paso_anterior > 0) {
                            $seguimiento_array = array(
                                'sgo_id_orc' => $registro,
                                'sgo_id_psf' => $paso_anterior,
                                'sgo_id_usu' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_entrada' => date('Y-m-d H:i:s'),
                                'sgo_estado' => 1,
                                'sgo_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sgo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sgo_fecha_creacion' => date('Y-m-d h:i:s'),
                                'sgo_fecha_modificacion' => date('Y-m-d h:i:s')
                            );
                            $seguimiento = $this->gsatelite->ingresar('sgo_seguimiento_orden', $seguimiento_array);
                        }
                        //Se actualiza el estado del registro
                        $this->cambiar_estado_registro($registro, $tipo_flujo, 4);
                        break;
                    case 4:
                        //Se cierra el paso actual
                        $scm_seguimiento_comparativo_compra = array(
                            'scm_id_usu'            => $this->tank_auth->get_user_id(),
                            'scm_observacion'       => $txtComentario,
                            'scm_fecha_salida'      => date('Y-m-d H:i:s'),
                            'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                        );                        
                        $this->gsatelite->actualizar_array('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra, array('scm_id' => $paso_actual));
                        //Si existe un paso Anterior se ingresa
                        if ($paso_anterior > 0) {
                            $scm_seguimiento_comparativo_compra = array(
                                'scm_id_ccc'            => $registro,
                                'scm_id_psf'            => $paso_anterior,
                                'scm_id_usu'            => $this->tank_auth->get_user_id(),
                                'scm_fecha_entrada'     => date('Y-m-d H:i:s'),
                                'scm_estado'            => 1,
                                'scm_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'scm_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'scm_fecha_creacion'    => date('Y-m-d h:i:s'),
                                'scm_fecha_modificacion'=> date('Y-m-d h:i:s')
                            );
                            $seguimiento = $this->gsatelite->ingresar('scm_seguimiento_comparativo_compra', $scm_seguimiento_comparativo_compra);
                        }
                        //Se actualiza el estado del registro
                        $resultado = $this->cambiar_estado_registro($registro, $tipo_flujo, 4);
                        break;
                }
                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if($iframe==1){
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                }else{
                    $redireccionar = $post_array['redireccion'];
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal']= "Regresar(Rechazar)";
            $data['iframe']         = $iframe;
            $data['registro']       = $registro;
            $data['tipo_flujo']     = $tipo_flujo;            
            $paso_actual            = $this->inventario_model->get_paso_actual($registro,$tipo_flujo);
            $paso_anterior          = $this->inventario_model->get_paso_anterior($registro,$tipo_flujo);
            $data['paso_actual']    = $paso_actual[0];
            $data['paso_anterior']  = $paso_anterior[0]['psf_id'];
            $data['slct_paso_ant']  = $paso_anterior;
            switch ($tipo_flujo) {
                case 1:
                    $data['paso_actual_id'] =  $paso_actual[0]['sgr_id'];
                    $data['nombre_registro'] = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_numero', array('rxi_id' => $registro));
                    $data['titulo_registro'] = "Requisición N.";
                    break;
                case 2:
                    $data['paso_actual_id'] =  $paso_actual[0]['sgo_id'];
                    $data['nombre_registro'] = $this->gsatelite->get_campo('orc_orden_compra', 'orc_numero', array('orc_id' => $registro));
                    $data['titulo_registro'] = "Orden de Compra N.";
                    break;
                case 4:
                    $data['paso_actual_id'] =  $paso_actual[0]['scm_id'];
                    $this->db->join('rxi_requisicion_inventario','rxi_id = ccc_id_rxi');
                    $data['nombre_registro'] = $this->gsatelite->get_campo('ccc_comparativo_cotizacion_compra', 'rxi_numero', array('ccc_id' => $registro));
                    $data['titulo_registro'] = "Comparativo de Requisición N.";
                    break;
            }
            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('inventario/inicio/regresar_paso',$data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }
    
    function historial_pasos($iframe = 0, $registro = null, $tipo_flujo = null){
        satelite_validar();

        $data['iframe'] = $iframe;
        $data['registro'] = $registro;
        $data['tipo_flujo'] = $tipo_flujo;
        
        $historial = $this->inventario_model->get_historial_paso($registro,$tipo_flujo);
        
        $data['historial'] = $historial;

        $this->gsatelite->cargar_vista_masterpage('inventario/inicio/historial_pasos', $data, true);
    }
    
    function cambiar_estado_registro($registro,$tipoFlujo,$estado){
        
        $registro_array = array();
        $tabla = "";
        $where = null;
        //Se modifica el estado en base al tipo de flujo.
        switch ($tipoFlujo) {
            case 1: 
                
                $registro_array['rxi_estado'] = $estado;
                $registro_array['rxi_usu_modificacion'] = $this->tank_auth->get_user_id();
                $registro_array['rxi_fecha_modificacion'] = date('Y-m-d H:i:s');
                $tabla = "rxi_requisicion_inventario";
                $where = array('rxi_id'=>$registro);
                break;
            case 2: 
                
                $registro_array['orc_estado'] = $estado;
                $registro_array['orc_usu_modificacion'] = $this->tank_auth->get_user_id();
                $registro_array['orc_fecha_modificacion'] = date('Y-m-d H:i:s');
                $tabla = "orc_orden_compra";
                $where = array('orc_id'=>$registro);
                break;
        }
        
        if(count($registro_array)>0 && $tabla!='' && $where!=null){
            $resultado = $this->gsatelite->actualizar_array($tabla,$registro_array,$where);
        }

        return $resultado;
    }
    
    function _cargarvista($data = 0, $crud = 0){
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
}