<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');



function obtener_productos_tia() {
        $tia_id = $this->input->post('categoria');
        $tipo = $this->input->post('tipo');
        $bod=0;
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $select_producto = "<option value=''></option>";
        if ($tipo == 1) {
            $productos = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_inventario' => 1, 'art_id_tia' => $tia_id));
            foreach ($productos as $key) {
                $select_producto .= '<option value="' . $key['art_id'] . '">'.$key['art_codigo'].' - '. $key['art_nombre'] . '</option>';
            }
        } else {
            $bod_id = $this->input->post('bodega');
            $sector = (trim($this->input->post('sector')) != "") ? $this->input->post('sector') : null;
            $productos = $this->inventario_model->get_cantidad_bodega($tia_id, $bod_id, $sector);
            if($bod_id<=0){ $bod=1; }
            if ($sector != null) {
                foreach ($productos as $key) {
                    $select_producto .= '<option value="' . $key['art_id'] . '" cant="' . round($key['cantidad'], $decimales, '.', '') . '">'.$key['art_codigo'].' - '. $key['art_nombre'] . '&nbsp;(' . round($key['cantidad'], $decimales, '.', '') . ')</option>';
                }
                /*
                  // sector null para que muestre toda la cantidad existente
                  $productos_filtro = $this->inventario_model->get_cantidad_bodega($tia_id, $bod_id, $sector, $productos[0]['art_id']);
                  foreach ($productos_filtro as $key) {
                  $select_producto .= '<option value="'.$key['art_id'].'" cant="'.round($key['cantidad'], 2).'">'.$key['art_nombre'].'&nbsp;('.round($key['cantidad'], 2).')</option>';
                } */
            } else {
                foreach ($productos as $key) {
                    $select_producto .= '<option value="' . $key['art_id'] . '" cant="' . round($key['cantidad'], 2) . '">'.$key['art_codigo'].' - '.$key['art_nombre'] . '&nbsp;(' . round($key['cantidad'], 2) . ')</option>';
                }
            }
        }
        if (count($productos) == 0) {
            $select_producto = "<option value=''></option>";
        }

        $hijos = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_padre' => $tia_id));
        $select_categoria = "<option value=''></option>";
        $cat_hijo = 0;
        foreach ($hijos as $key1) {
            $cat_hijo = 1;
            $select_categoria .= '<option value="' . $key1['tia_id'] . '">'.$key1['tia_codigo'].' - '. $key1['tia_nombre'] . '</option>';
        }
        if (count($hijos) == 0) {
            $cat_hijo = 0;
            $select_categoria = "<option value=''></option>";
        }

        $arreglo = array('producto' => $select_producto, 'categoria' => $select_categoria, 'cat_hijo' => $cat_hijo, 'bodega'=>$bod);
        echo json_encode($arreglo);
    }
class Gestion_productos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('inventario_model');
        $this->load->model('contabilidad_model');
        $this->load->model('facturacion_model');
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->library('excel/excel_reader.php');
        $this->load->library('pdf');
    }

    
    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    public function validar_documento() {
        satelite_validar();
        if ($_POST) {
            //echo die(print_r($_POST));
            $documento = $this->input->post('id');
            $campo = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_documento', array('rxi_documento' => $documento));
            echo json_encode(array('drop' => $campo));
        }
    }

    public function get_permisos_padre_prod() {
        satelite_validar(true);
        /*      Obtener permisos para agregar producto del modulo de inventario        */
        $permisos        = $this->gsatelite->get_permisos_opcion("inventario/mantenimiento/articulo");
        $permite_agregar = (int)$permisos['permite_agregar'];
        echo json_encode(array('permiso'=>$permite_agregar));
    }

    public function obtener_hijos_cat() {
        $padre = $this->input->post('padre');
        $bodega = $this->input->post('bodega');
        $pantalla = $this->input->post('pantalla');
        $servicios = $this->input->post('servicios');

        $this->db->where('tia_padre', $padre);
        $hijos = $this->db->get('tia_tipo_articulo')->result_array();
        $cadena = "<option value='0' selected>Seleccione una opción</option>";
        foreach ($hijos as $key => $value) {
            $cadena .= '<option value="' . $value['tia_id'] . '">'.$value['tia_codigo'].' - '. $value['tia_nombre'] . '</option>';
        }

        $var = '<option value="0"> Seleccione una opción </option>';
        $consulta = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $bodega));
        // $tipo_bodega = $consulta[0]['bod_tipo_bodega'];
        if ($servicios != '') {
            $this->db->where('art_tipo', 1);
        }
        if ($pantalla == "entrada") {
            $articulos = $this->inventario_model->artxcategorias($bodega, $padre, $pantalla);
        } else if ($pantalla == "salida") {
            $articulos = $this->inventario_model->artxcategorias($bodega, $padre, $pantalla);
            //$articulos = $this->inventario_model->get_productos_bodega_cantidad_salida($bodega,$padre);
        }


        $etiqueta = 0;
        foreach ($articulos as $fila) {
            if ($pantalla == "entrada") {
                $var .= "<option precio='" . $fila['sar_precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "'>" . $fila['art_codigo'] . " | " . $fila['art_nombre'] . " | " . $fila['mep_nombre'] . "</option>";
                $etiqueta++;
            } else if ($pantalla == "salida") {
                $var .= "<option precio='" . $fila['precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_codigo'] . " | " . $fila['art_nombre'] . ' (' . $fila['sar_cant_actual'] . ')' . "</option>";
                $etiqueta++;
            }
        }
        if (count($hijos) == 0) {
            $cadena = "";
        }
        if (count($articulos) == 0) {
            $var = "";
        }
        $arreglo = array('drop' => $cadena, 'producto' => $var, 'padre' => $padre);
        echo json_encode($arreglo);
    }

    public function productosxbodega() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_producto = $this->input->post('producto_id');
            $id_bodega = $this->input->post('bodega_id');
            $existencia_art = $this->inventario_model->comprobar_existencias($id_producto, $id_bodega);

            $datos = $this->inventario_model->datos_generles_articulo($id_producto);
            $id_art = $id_producto;
            $bodega = $id_bodega;
            $cantidad_ex = $this->inventario_model->obt_cant_minimaYexistente($id_art, $bodega);
            $datos_arti = "";

            foreach ($datos as $fila) {
                $datos_arti .= "<input value='" . $fila['art_codigo'] . "' id='dato_prod_cod'>";
                $datos_arti .= "<input value='" . $fila['art_nombre'] . "' id='dato_prod_nom'>";
                $datos_arti .= "<input value='" . $fila['mep_nombre'] . "' id='dato_prod_um'>";
                foreach ($cantidad_ex as $cant) {
                    $datos_arti .= "<input value='" . $cant['suma'] . "' id='dato_prod_exis'>";
                }
            }
            $arreglo = array('existencia' => $existencia_art['existencias'], 'datos' => $datos_arti);
            echo json_encode($arreglo);
        }
    }

    public function productosxcajafurgon() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_producto = $this->input->post('producto_id');
            $id_bodega = $this->input->post('bodega_id');
            $query = "SELECT * FROM ixc_ingresoxcontenedor
                        INNER JOIN dee_detalle_mov ON dee_id_ixc= ixc_id
                        INNER JOIN moi_movimiento_inv ON moi_id = dee_id_moi
                        INNER JOIN tip_tipo_proceso ON tip_id = moi_id_tip
                        INNER JOIN sar_saldo_articulo ON sar_id = dee_id_sar
                        INNER JOIN art_articulo ON art_id = sar_id_art
                        INNER JOIN mep_medida_producto ON mep_id=art_id_mep
                        WHERE tip_entrada = 1 AND dee_id_art =" . $id_producto . " AND moi_id NOT IN (SELECT tra_id_moi_ent FROM tra_translado) GROUP BY ixc_id";
            $resultado = $this->db->query($query)->result_array();

            $cadena = '<option value="0">Seleccione una opción</option>';
            foreach ($resultado as $key => $value) {
                $cadena .= "<option  sar='" . $value['sar_id'] . "' value='" . $value['ixc_id'] . "'>Contenedor " . $value['ixc_contenedor'] . " | Caja " . $value['ixc_caja'] . " | Cantidad " . $value['ixc_cantidad_actual'] . "</option>";
            }
            $datos = $this->inventario_model->datos_generles_articulo($id_producto);
            $datos_arti = "";
            foreach ($datos as $fila) {
                $datos_arti .= "<input value='" . $fila['art_codigo'] . "' id='dato_prod_cod'>";
                $datos_arti .= "<input value='" . $fila['art_nombre'] . "' id='dato_prod_nom'>";
                $datos_arti .= "<input value='" . $fila['mep_nombre'] . "' id='dato_prod_um'>";
            }

            $existencia_art = $this->inventario_model->comprobar_existencias($id_producto, $id_bodega);

            $arreglo = array('drop' => $cadena, 'consulta' => $this->db->last_query(), 'existencia' => $existencia_art['existencias'], 'medida' => $resultado[0]['mep_nombre'], 'datos' => $datos_arti);
            echo json_encode($arreglo);
        }
    }

    public function existenciaxixc() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $ixc = $this->input->post('ixc');
            $query = "SELECT ixc_cantidad_actual,ixc_contenedor FROM ixc_ingresoxcontenedor
            WHERE ixc_id = " . $ixc;
            $resultado = $this->db->query($query)->result_array();
            $cadena = $resultado;
            $arreglo = array('drop' => $resultado[0]['ixc_cantidad_actual'], 'furgon' => $resultado[0]['ixc_contenedor']);
            echo json_encode($arreglo);
        }
    }

    /* public function anular_requisicion() {
      if (!$this->tank_auth->is_logged_in()) {
      redirect('/auth/login/');
      } else {
      $id_req = $this->input->post('req_id');
      $this->db->where('rxi_id', $id_req);
      $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2));
      }
  } */

  public function entrada_productos($consulta = 0) {
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
        $data['permisos']       = $this->gsatelite->get_permisos_opcion('inventario/gestion_productos/entrada_productos');
        if ($_POST) {
            if ($consulta > 0) {

                $post_array     = $_POST;

                $tipo_entrada   = $post_array['estado'];
                $fecha_inicio   = $post_array['fecha_ini'];
                $fecha_fin      = $post_array['fecha_fin'];

                $where = null;
                if ($tipo_entrada) {
                    $where['moi_id_tip']        = $tipo_entrada;
                }
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $where['moi_fecha_mov >=']  = date('Y-m-d', strtotime($fecha_inicio));
                    $where['moi_fecha_mov <=']  = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
                }

                $this->db->group_by('moi_id');
                $entradas = $this->inventario_model->get_backlog_inventario_entrada($where);
                    //print_r($this->db->last_query()); die();
                $data['entradas']   = $entradas;

                $html = $this->load->view('inventario/gestion_productos/consultar_entradas_productos', $data, true);

                echo $html;
                die();
            }
        } else {
            $select = $this->gsatelite->get_dropdown('tip_tipo_proceso', '{tip_nombre}', '', array('tip_estado' => 1, 'tip_entrada' => 1), null, '', 'tip_id', true);
            $data['tipo_proceso']    = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data['titulo_personal'] = 'Entradas de productos';
            $this->_cargarvista($data);
        }
    }
}

public function agregar_entrada() {
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
        $data['par'] = $this->gsatelite->get_parametro('SYS_LISTADO_PRECIO');
        $data['usasec'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
        $select = $this->gsatelite->get_dropdown('prv_proveedor', '[CASE WHEN prv_tipo_pers = 2 then CONCAT(prv_codigo,"-",prv_apellido) ELSE CONCAT(prv_codigo,"-",prv_nombre," ", prv_apellido) END ]', '', array('prv_estado' => 1), null, '', 'prv_id', true);
        $data["proveedor_prv"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
        $bodegas = $this->inventario_model->get_bodegas_usuario();
        $select = "";
        foreach ($bodegas as $key) {
            $select .= "<option value='" . $key['bod_id'] . "'>" . $key['bod_nombre'] . "</option>";
        }
        $data["bodega_bod"] = $select;
        $select = $this->gsatelite->get_dropdown('tip_tipo_proceso', '{tip_nombre}', '', array('tip_estado' => 1, 'tip_entrada' => 1), null, '', 'tip_id', true);
        $data["entrada_tip"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1, 'tia_padre' => null), null, '', 'tia_id', true);
        $data["categoria_tia"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        //muestra las ordenes de compra
        $orden_compra = $this->inventario_model->get_orden_compra(array('orc_tipo !=' => 3));
        $select = "";
        foreach ($orden_compra as $key) {
            if ($key["orc_estado"] == 3 || $key["orc_estado"] == 6) {
                    //valores[0] son los estados de los documentos, si tenemos 1 significa que hay un documento activo
                    //valores[1] es la cantidad de registros de los documentos, si hay
                if ($key['rxi_id_bod'] == null) {
                    $bodega = 0;
                } else {
                    $bodega = $key['rxi_id_bod'];
                }
                if ($key['activo_dpv'] != 0) {
                    $select .= "<option bodega='" . $bodega . "' tipo='dpv' value='" . $key['orc_id'] . "'>" . $key['orc_numero'] . " / ".$key['proveedor']."</option>";
                } else if ($key["dpv_exist"] == null) {
                    $select .= "<option bodega='" . $bodega . "' tipo='orc' value='" . $key['orc_id'] . "'>" . $key['orc_numero'] . " / ".$key['proveedor']."</option>";
                }
            }
        }
        $data["dpvs"] = $this->get_documento_proveedor(1);
        $notas_remision = $this->inventario_model->get_notas_remi(array('tip_salida' => 1, 'tip_entrada' => 0));
        $select_rem = "";
        foreach ($notas_remision as $key => $val) {
            $select_rem .= '<option value="' . $val['moi_id'] . '" data-fac="' . $val['fac_id'] . '">' . $val['moi_documento'] . '</option>';
        }
        $data["nota_rem"] = $select_rem;
        $data["orden_orc"]          = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        $data['usuarios']           = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['proceso_unidad']     = $this->inventario_model->cargar_todo('mep_medida_producto');
        $data['tipo_transaccion']   = $this->inventario_model->cargar_todo('tip_tipo_proceso', array('tip_entrada' => 1, 'tip_estado' => 1));
        $cero = $this->gsatelite->get_parametro('SYS_PRECIO_CERO_INV');
        $data['cero']=($cero!='')?$cero:0;
        $precio_defecto = $this->gsatelite->get_parametro('INV_PRECIO_DEFECTO_ENTRADA_PRODUCTOS');
        $data['precio_defecto'] = ($precio_defecto!='') ? $precio_defecto : "";
        $cantidad_defecto = $this->gsatelite->get_parametro('SYS_INV_DEFECTO_CANTIDAD_PRODUCTOS',0);
        $data['cantidad_defecto'] = ($cantidad_defecto != null && $cantidad_defecto > 0 ) ? $cantidad_defecto : "";
        $data['cantidad_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $dias_vencimiento           = $this->gsatelite->get_parametro('SYS_DIAS_VENCIMIENTO_INV');
        $data['costo_promedio']     = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO', 2);
        $dias_vencimiento = ($dias_vencimiento != NULL or $dias_vencimiento!= "")?$dias_vencimiento:"";
        $fecha_vencimiento = "";
        if ($dias_vencimiento != ""){
            $fecha = date('Y-m-d');
            $fecha_vencimiento = strtotime ( '+'.$dias_vencimiento.' day' , strtotime ( $fecha ) ) ;
            $fecha_vencimiento = date ( 'd-m-Y' , $fecha_vencimiento );
        }
        $data['fecha_vencimiento'] = $fecha_vencimiento;
        $data['titulo_personal'] = 'Ingreso de inventario';
        $this->_cargarvista($data);
    }
}

    public function visualizar_entrada($moi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data["movimiento_entrada"] = $this->gsatelite->get_tabla("moi_movimiento_inv", array("moi_estado" => 1, "moi_id" => $moi_id));

            $datos_entrada = $data["movimiento_entrada"][0];
            $data["proveedor_prv"] = $this->gsatelite->get_tabla("prv_proveedor", array("prv_id" => $datos_entrada["moi_id_prv"]));

                                         $this->db->join('prv_proveedor','prv_id = dpv_id_prv','left');
            $data["doc_proveedor_dcp"] = $this->gsatelite->get_tabla("dpv_documento_proveedor", array("dpv_id" => $datos_entrada["moi_id_dpv"]));

            $data['orc_documento'] = $this->gsatelite->get_dropdown('orc_orden_compra', '{orc_numero}', '', '', $data["movimiento_entrada"][0]['moi_id_orc'], '', 'orc_id', true);
            $data["bodega_bod"] = $this->gsatelite->get_tabla("bod_bodega", array("bod_id" => $datos_entrada["moi_id_bod"]));
            $data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $datos_entrada["moi_id_tip"]));

            //$data["doc_cliente_dcc"] = $this->gsatelite->get_tabla("dcp_documento_proveedor",array("dcp_id"=>$datos_entrada["moi_id_dcp"]));
            /* $sector_bodega = $this->gsatelite->get_tabla("sxb_sectorxbodega",array("sxb_id"=>$datos_entrada["moi_id_sxb"]));
            $data["sector_seb"] = $this->gsatelite->get_tabla("seb_sector_bodega",array("seb_id"=>$sector_bodega[0]["sxb_id_seb"])); */

                                          $this->db->join('sar_saldo_articulo', 'sar_id = dee_id_sar', 'left');
            $data["detalle_movimiento"] = $this->gsatelite->get_tabla("dee_detalle_mov", array("dee_id_moi" => $moi_id));
            $data["sector_seb"] = $this->inventario_model->get_sector_grid($datos_entrada["moi_id_bod"]);
            $data["articulos"] = $this->gsatelite->get_tabla("art_articulo");
            $data["conversiones"] = $this->gsatelite->get_tabla("cva_conversion_articulo", array("cva_estado" => 1));
            $data["medida"] = $this->gsatelite->get_tabla("mep_medida_producto", array("mep_estado" => 1));

            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['titulo_personal'] = 'Vista de inventario';
            $this->_cargarvista($data);
        }
    }

    public function visualizar_salida($moi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data["movimiento_entrada"] = $this->gsatelite->get_tabla("moi_movimiento_inv", array("moi_estado" => 1, "moi_id" => $moi_id));
            $datos_entrada = $data["movimiento_entrada"][0];
            $detalle_requisicion = $this->gsatelite->get_tabla("dxm_detallexmovimiento", array("dxm_id_moi" => $datos_entrada["moi_id"]));
            if ($datos_entrada['moi_id_rxi'] != "") {
                $requisicion = $this->gsatelite->get_tabla("rxi_requisicion_inventario", array("rxi_id" => $datos_entrada['moi_id_rxi']));
                $data["requisicion"] = $requisicion;
                if ($requisicion[0]['rxi_id_ord'] != "") {
                    $this->load->model('proyecto_model');
                    $data_orden = $this->proyecto_model->get_orden(array('ord_id' => $requisicion[0]['rxi_id_ord']));
                    if (count($data_orden) > 0) {
                        $articulos = array();
                        $data["orden_prod"] = $data_orden[0]['ord_codigo'];
                        foreach ($data_orden as $key => $value) {
                            array_push($articulos, ($value['art_codigo'] . ' - ' . $value['art_nombre']));
                        }
                        $data["art_orden"] = implode(',', $articulos);
                    }
                }
            }
            //$data["doc_proveedor_dcp"] = $this->gsatelite->get_tabla("dcp_documento_proveedor",array("dcp_id"=>$datos_entrada["moi_id_dcp"]));
            //$data["doc_cliente_dcc"] = $this->gsatelite->get_tabla("dcp_documento_proveedor",array("dcp_id"=>$datos_entrada["moi_id_dcp"]));
            $data["bodega_bod"] = $this->gsatelite->get_tabla("bod_bodega", array("bod_id" => $datos_entrada["moi_id_bod"]));
            /* $sector_bodega = $this->gsatelite->get_tabla("sxb_sectorxbodega",array("sxb_id"=>$datos_entrada["moi_id_sxb"]));
            $data["sector_seb"] = $this->gsatelite->get_tabla("seb_sector_bodega",array("seb_id"=>$sector_bodega[0]["sxb_id_seb"])); */
            $data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $datos_entrada["moi_id_tip"]));
            //$data["detalle_movimiento"] = $this->gsatelite->get_tabla("dee_detalle_mov", array("dee_id_moi"=>$moi_id));
            $data["detalle_movimiento"] = $this->inventario_model->get_salidas_dee($moi_id);
            $data["sector_seb"] = $this->inventario_model->get_sector_grid($datos_entrada["moi_id_bod"]);
            $data["articulos"] = $this->gsatelite->get_tabla("art_articulo");
            $data["conversiones"] = $this->gsatelite->get_tabla("cva_conversion_articulo", array("cva_estado" => 1));
            $data["medida"] = $this->gsatelite->get_tabla("mep_medida_producto", array("mep_estado" => 1));
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['titulo_personal'] = 'Vista de inventario';
            $this->_cargarvista($data);
        }
    }

    public function visualizar_traslado($moi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$data["movimiento_entrada"] = $this->gsatelite->get_tabla("moi_movimiento_inv",array("moi_estado"=>1,"moi_id"=>$moi_id));
            //$datos_entrada = $data["movimiento_entrada"][0];

            $data["movimiento_entrada"] = $this->inventario_model->get_backlog_inventario_traslado(array("tra_estado" => 1, "tra_id" => $moi_id));
            $datos_entrada = $data["movimiento_entrada"][0];
            //"bod_estado"=>1,

            $detalle_requisicion = $this->inventario_model->get_requisicionxmovimiento(array("moi_id" => $datos_entrada["tra_id_moi_sal"]));
            $data["requisicion"] = $detalle_requisicion;

            //$data["bodega_bod"] = $this->inventario_model->get_traslados(array("moi_id"=>$moi_id));
            //$bodega_entrada = explode(",", $data["bodega_bod"][0]["bodega_entrada"]);
            //$data["bodega_caract"] = array("bod_id"=>$bodega_entrada[0], "bod_nombre"=>$bodega_entrada[1], "suc_nombre"=>$bodega_entrada[2]);

            $data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $datos_entrada["tra_id_tip"]));

            //$data["detalle_movimiento"] = $this->gsatelite->get_tabla("dee_detalle_mov", array("dee_id_moi"=>$moi_id));
            $data["detalle_movimiento"] = $this->inventario_model->get_salidas_dee($datos_entrada["tra_id_moi_ent"]);
            //$data["detalle_movimiento"] = $this->inventario_model->get_salidas_dee($datos_entrada["tra_id_moi_sal"], array("sar_id_bod"=>$data["bodega_bod"][0]["moi_id_bod"]));
            $data['usa_sector'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data["sector_seb"] = $this->inventario_model->get_sector_grid($datos_entrada["tra_id_moi_sal"]);


            $data["articulos"] = $this->gsatelite->get_tabla("art_articulo");
            $data["conversiones"] = $this->gsatelite->get_tabla("cva_conversion_articulo", array("cva_estado" => 1));
            $data["medida"] = $this->gsatelite->get_tabla("mep_medida_producto", array("mep_estado" => 1));

            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['titulo_personal'] = 'Vista de inventario';
            $this->_cargarvista($data);
        }
    }

    /*
     * Controlador: print_visualizar_traslado
     * Descripcion: Controlador para generar el reporte pdf de traslado de Productos
     */

    public function print_visualizar_traslado($moi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->library('pdf');
            $data["movimiento_entrada"] = $this->inventario_model->get_backlog_inventario_traslado(array("tra_estado" => 1, "tra_id" => $moi_id));
            $datos_entrada = $data["movimiento_entrada"][0];
            $detalle_requisicion = $this->inventario_model->get_requisicionxmovimiento(array("moi_id" => $datos_entrada["tra_id_moi_sal"]));
            $data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $datos_entrada["tra_id_tip"]));
            $data["detalle_movimiento"] = $this->inventario_model->get_salidas_dee($datos_entrada["tra_id_moi_ent"]); //DE ENTRADA
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['usa_sector'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data['titulo'] = 'Traslado de Productos';
            $header = $this->load->view('reporte/header', $data, true);
            $GLOBALS['nombre_reporte'] = 'Reporte_traslado' . date('dmY');
            $html = $this->load->view('inventario/gestion_productos/print_visualizar_traslado', $data, true);
            $reporte = $header . $html;
            $this->pdf->makePdf($reporte, 'L', 'Reporte Traslado', 'Letter');
        }
    }


    function guardar_entrada() {
        // var_dump($_POST);die();
        $cuentas = null;
        $redireccion = $this->input->post('redireccion');
        $proveedor_prv = (trim($this->input->post('proveedor_prv')) != "" && trim($this->input->post('proveedor_prv')) != 0) ? $this->input->post('proveedor_prv') : null;
        $orden_compra_orc = (trim($this->input->post('orden_compra_orc')) != "" && trim($this->input->post('orden_compra_orc')) != 0) ? $this->input->post('orden_compra_orc') : null;
        $doc_proveedor_dcp = (trim($this->input->post('doc_proveedor_dcp')) != "") ? $this->input->post('doc_proveedor_dcp') : null;
        //$doc_cliente_dcc = (trim($this->input->post('doc_cliente_dcc')) != "")?$this->input->post('doc_cliente_dcc'):null;
        $bodega_bod = (trim($this->input->post('bodega_bod')) != "") ? $this->input->post('bodega_bod') : null;
        $doc_referencia = (trim($this->input->post('doc_referencia')) != "") ? $this->input->post('doc_referencia') : null;
        $tip_entrada = (trim($this->input->post('tip_entrada')) != "") ? $this->input->post('tip_entrada') : null;
        $factura_rem = (trim($this->input->post('fac_rem')) != "") ? $this->input->post('fac_rem') : null;
        $comentario = (trim($this->input->post('comentario')) != "") ? $this->input->post('comentario') : null;
        $producto_art = $this->input->post('producto_art'); //array
        $correlativo = $this->input->post('correlativo'); //array
        $medida_cva = $this->input->post('medida_cva'); //array
        $cantidad_dee = $this->input->post('cantidad_dee'); //array
        $precio_dee = $this->input->post('precio_dee'); //array
        $costo_total = $this->input->post('costo_total'); //array
        $fecha_dee = $this->input->post('fecha_dee'); //array
        $sector_sxb = $this->input->post('sector_sxb'); //array
        $lote = $this->input->post('codigo_lote');
        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
        $reversa = (trim($this->input->post('reversa')) != "") ? $this->input->post('reversa') : 0;
        $moi_id_moi_reversa = null;
        if ($reversa == 1) {
            $moi_id_moi_reversa =  (trim($this->input->post('moi_id_inicia_reversa')) != "") ? $this->input->post('moi_id_inicia_reversa') : null;
        }
        $tipo = $this->input->post('tipo_caracteristica');
        if (trim($bodega_bod) != "" && trim($tip_entrada) != "") {//Bodega y tipo de entrada
            $respuesta = $this->db->insert('moi_movimiento_inv', array(
                'moi_id_prv' => $proveedor_prv,
                'moi_id_tip' => $tip_entrada,
                'moi_id_bod' => $bodega_bod,
                'moi_id_fac' => $factura_rem,
                'moi_id_dpv' => $doc_proveedor_dcp,
                //'moi_id_dcc'=> $doc_cliente_dcc,
                'moi_id_orc' => $orden_compra_orc,
                'moi_documento' => $doc_referencia,
                //'moi_retaceo'=> null,
                'moi_descripcion' => $comentario,
                'moi_fecha_mov' => (trim($this->input->post('fecha_registro_mov')) != "")? formatear_fecha('Y-m-d',trim($this->input->post('fecha_registro_mov'))).' '.date('H:i:s'):date('Y-m-d H:i:s'),
                'moi_estado' => 1,
                'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion' => date('Y-m-d H:i:s')
            ));
            $moi_id = $this->db->insert_id();
            //Actulizar el movimiento que genera la reversa
            $array_update_moi_inicial = array(
                'moi_reversa'           => $reversa,
                'moi_id_moi_reversa'    => $moi_id
            );
            $this->gsatelite->actualizar_array('moi_movimiento_inv', $array_update_moi_inicial, array('moi_id' => $moi_id_moi_reversa) ) ;
            if ($orden_compra_orc != null) {
                $cantidad_dee_original = $this->input->post('cantidad_dee_original'); //array
                for ($x = 0; $x < count($producto_art); $x++) {
                    if (trim($producto_art[$x]) != "" && (trim($cantidad_dee[$x]) != "" && (trim($cantidad_dee[$x] != 0))) && trim($precio_dee[$x]) != "") {
                        if($this->input->post('caracteristica_'.$producto_art[$x].'_'.$correlativo[$x]))
                            $caracteristicas_id = ($this->input->post('caracteristica_'.$producto_art[$x].'_'.$correlativo[$x])) ? $this->input->post('caracteristica_'.$producto_art[$x].'_'.$correlativo[$x]):array();
                        $fecha = (trim($fecha_dee[$x]) != "") ? date('Y-m-d', strtotime($fecha_dee[$x])) : null;
                        $sector = (trim($sector_sxb[$x]) != "") ? $sector_sxb[$x] : null;
                        if ($costo_promedio == 1) {
                            $nuevo_precio =  $this->recalcular_precio_promedio($producto_art[$x], $bodega_bod, $cantidad_dee[$x], $precio_dee[$x]);
                        }
                        $respuesta = $this->db->insert('sar_saldo_articulo', array(
                            'sar_id_art' => $producto_art[$x],
                            'sar_id_bod' => $bodega_bod,
                            'sar_cant_actual' => $cantidad_dee[$x],
                            'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $precio_dee[$x],
                            'sar_fecha_caducidad' => $fecha,
                            'sar_id_sxb' => $sector,
                            'sar_estado' => 1,
                            'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                            'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                            'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                        $sar_id = $this->db->insert_id();
                        $dee_array = array(
                            'dee_id_moi' => $moi_id,
                            'dee_id_art' => $producto_art[$x],
                            'dee_id_sar' => $sar_id,
                            'dee_id_cva' => $medida_cva[$x],
                            'dee_id_sxb' => $sector,//SE ELIMINARA DE LA DEE Y SOLO ESTARA EN LA SAR // REUNION MAYO 2023 /////// PDTE DESARROLLAR ////
                            'dee_cantidad' => $cantidad_dee[$x],
                            'dee_fecha_caducidad' => $fecha,
                            'dee_precio' => $precio_dee[$x],
                            'dee_subtotal' => $costo_total[$x],
                            'dee_codigo_lote'=>(trim($lote[$x]) != "") ? $lote[$x] : null,
                            'dee_estado' => 1,
                            'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dee_id = $this->gsatelite->ingresar('dee_detalle_mov', $dee_array);
                        /* ===============================================================================================================
                                            EMPAQUETADO
                        =================================================================================================================*/
                        $empaquetados   = ($this->input->post('empaque_orden_'.$producto_art[$x]))?$this->input->post('empaque_orden_'.$producto_art[$x]):array();
                        $caracteristica = ($this->input->post('empaque_carac_'.$producto_art[$x]))?$this->input->post('empaque_carac_'.$producto_art[$x]):array();
                        $codigo         = ($this->input->post('empaque_codigo_'.$producto_art[$x]))?$this->input->post('empaque_codigo_'.$producto_art[$x]):array();
                        $unidades       = ($this->input->post('empaque_unidades_'.$producto_art[$x]))?$this->input->post('empaque_unidades_'.$producto_art[$x]):array();
                        $neto           = ($this->input->post('empaque_peso_n_'.$producto_art[$x]))?$this->input->post('empaque_peso_n_'.$producto_art[$x]):array();
                        $bruto          = ($this->input->post('empaque_peso_b_'.$producto_art[$x]))?$this->input->post('empaque_peso_b_'.$producto_art[$x]):array();
                        foreach ($empaquetados as $value => $empaquetado) {
                            $dmp_array = array(
                                'dmp_id_cxu'            => $caracteristica[$value],
                                'dmp_id_dee'            => $dee_id,
                                'dmp_orden'             => $empaquetados[$value],
                                'dmp_codigo_empaque'    => $codigo[$value],
                                'dmp_cantidad'          => $unidades[$value],
                                'dmp_peso_neto'         => $neto[$value],
                                'dmp_peso_bruto'        => $bruto[$value],
                                'dmp_procesado_salida'  => 0,
                                'dmp_estado'            => 1,
                                'dmp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                'dmp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                'dmp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                'dmp_fecha_modificacion'=> date('Y-m-d H:i:s')
                            );
                            $dmp_id = $this->gsatelite->ingresar('dmp_detalle_empaque', $dmp_array);
                        }
                        /* ==================================================================================
                            CARACTERÍSTICAS POR DETALLE
                        ===================================================================================*/
                        if(count($caracteristicas_id) > 0){
                            for ($y = 0; $y < count($caracteristicas_id); $y++) {            
                            //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                                if ($tipo[$x] == 0) {

                                } else if ($tipo[$x] == 1) {
                                    //toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                    $caracteristicas_id_valor = $this->input->post('valorcaja_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                    //la descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                } else if ($tipo[$x] == 2) {
                                    //toma los valores de las cajas escondidas despues de aplicar la formula se almacenan en estas
                                    //si no se a seleccionado ninguna formula, entonces el valor de las cajas que se toma seria las visibles
                                    if ($formula != "") {
                                        $caracteristicas_id_valor = $this->input->post('valor_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                                    } else {
                                        $caracteristicas_id_valor = $this->input->post('valorcaja_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                                    }
                                    //la descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                                }
                                if ($tipo[$x] != 0) {
                                    if (trim($caracteristicas_id_valor) != "") {
                                        // Se guardará en la tabla cdi_caract_detalle_inventario
                                        $caracteristicas_inv = array(
                                            'cdi_id_cxu' => $caracteristicas_id[$y],
                                            'cdi_id_dee' => $dee_id,
                                            'cdi_valor' => (trim($caracteristicas_id_valor) != "") ? $caracteristicas_id_valor : null,
                                            'cdi_descripcion' => (trim($caracteristicas_id_descripcion) != "") ? $caracteristicas_id_descripcion : null,
                                            'cdi_estado' => 1,
                                            'cdi_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cdi_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cdi_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cdi_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('cdi_caract_detalle_inventario', $caracteristicas_inv);
                                    }
                                }
                            }        
                        }//Fin del if $caracteristicas_id > 0
                        /* =======================================================================
                                        CENTRO COSTO
                        ========================================================================*/
                        $identificador = '_'.$producto_art[$x].'_'.$correlativo[$x];
                        $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                        $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                        $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                        $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $costo_sav = array();
                        if($centro_costo_costo != ''){
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcm_id_dee' => $dee_id,
                                    'dcm_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcm_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcm_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcm_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcm_monto' => $subtotal_costo[$id_cost],
                                    'dcm_estado' => 1,
                                    'dcm_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dcm_fecha_creacion' =>  $fecha_creacion,
                                    'dcm_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dcm_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcm_detalle_centrocostoxmovimiento', $costo_sav, true);
                        }
                        /* ==========================================================================
                                            FIN CENTRO COSTO
                        ===========================================================================*/
                        if ($doc_proveedor_dcp == null) {
                            $orden_compra = $this->inventario_model->mostrar_orden_compra_entrada(array("dor_id_orc" => $orden_compra_orc, "dor_id_art" => $producto_art[$x]));
                            if ($orden_compra[0]["dor_cantidad_entregada"] <= $orden_compra[0]["dor_cantidad"]) {
                                $cantidad_actualizar = floatval(number_format($orden_compra[0]["dor_cantidad_entregada"], 2)) + floatval(number_format($cantidad_dee_original[$x], 2));
                                $estado_dor = 1;
                                if($cantidad_actualizar == floatval(number_format($orden_compra[0]["dor_cantidad"],2))){
                                    $estado_dor = 0;
                                }
                                $actualizar = array(
                                    'dor_cantidad_entregada' => $cantidad_actualizar,
                                    'dor_estado' => $estado_dor,
                                    'dor_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dor_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->actualizar_array("dor_detalle_orden_compra", $actualizar, array("dor_id" => $orden_compra[0]["dor_id"]));
                            }
                        } else if ($doc_proveedor_dcp != null) {
                            $actualizar_dxd = array(
                                'dxd_procesado_inventario' => 1,
                                'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dxd_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array("dxd_detalle_documento_proveedor", $actualizar_dxd, array("dxd_id_bod" => $bodega_bod, "dxd_id_art" => $producto_art[$x], "dxd_id_dpv" => $doc_proveedor_dcp));
                        }
                    }
                }
                $flag_finalizar = 0;
                if ($doc_proveedor_dcp == null) {
                    $orden_compra_cancelar = $this->inventario_model->mostrar_orden_compra_entrada(array("dor_id_orc" => $orden_compra_orc));
                    foreach ($orden_compra_cancelar as $key) {
                        if ($key["dor_cantidad_entregada"] != $key["dor_cantidad"]) {
                            $flag_finalizar = 1;
                        }
                    }
                    if ($flag_finalizar == 1) {
                        $actualizar = array(
                            'orc_estado' => 6,
                            'orc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'orc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array("orc_orden_compra", $actualizar, array("orc_id" => $orden_compra_orc));
                    } else {
                        $hay_dpv = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dpv_id_orc' => $orden_compra_orc, 'dpv_estado > ' => 0));
                        $actualizar = array(
                            'orc_estado' => (count($hay_dpv) > 0) ? 0 : 7,
                            'orc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'orc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array("orc_orden_compra", $actualizar, array("orc_id" => $orden_compra_orc));
                    }
                } else {
                    $estado = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_estado', array('dpv_id' => $doc_proveedor_dcp)); 
                    // Se agregó la validación según el estado del documento para no afectar el conteo de detalles del documento tomados en activo fijo.
                    //$dxd_estado_productos = $this->gsatelite->get_tabla("dxd_detalle_documento_proveedor", array("dxd_procesado_inventario" => 0, "dxd_id_dpv" => $doc_proveedor_dcp));
                    if ($estado == 3) {
                        $actualizar = array(
                            'dpv_estado' => 0,
                            'dpv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dpv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array("dpv_documento_proveedor", $actualizar, array("dpv_id" => $doc_proveedor_dcp));
                    }
                }
            } else { //Orden de compra is null
                //print_r($_POST);die();
                for ($x = 0; $x < count($producto_art); $x++) {
                    if (trim($producto_art[$x]) != "" && (trim($cantidad_dee[$x]) != "" && (trim($cantidad_dee[$x] != 0))) && trim($precio_dee[$x]) != "") {
                        $caracteristicas_id = $this->input->post('caracteristica_'.$producto_art[$x].'_'.$correlativo[$x]); //array
                        $fecha = (trim($fecha_dee[$x]) != "") ? date('Y-m-d', strtotime($fecha_dee[$x])) : null;
                        $sector = (trim($sector_sxb[$x]) != "") ? $sector_sxb[$x] : null;
                        if ($costo_promedio == 1) {
                            $nuevo_precio =  $this->recalcular_precio_promedio($producto_art[$x], $bodega_bod, $cantidad_dee[$x], $precio_dee[$x]);
                        }
                        $respuesta = $this->db->insert('sar_saldo_articulo', array(
                            'sar_id_art' => $producto_art[$x],
                            'sar_id_bod' => $bodega_bod,
                            'sar_cant_actual' => $cantidad_dee[$x],
                            'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $precio_dee[$x],
                            'sar_fecha_caducidad' => $fecha,
                            'sar_id_sxb' => $sector,
                            'sar_estado' => 1,
                            'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                            'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                            'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                        $sar_id = $this->db->insert_id();
                        $dee_array = array(
                            'dee_id_moi' => $moi_id,
                            'dee_id_art' => $producto_art[$x],
                            'dee_id_sar' => $sar_id,
                            'dee_id_cva' => $medida_cva[$x],
                            'dee_id_sxb' => $sector,
                            'dee_cantidad' => $cantidad_dee[$x],
                            'dee_fecha_caducidad' => $fecha,
                            'dee_precio' => $precio_dee[$x],
                            'dee_subtotal' => $costo_total[$x],
                            'dee_codigo_lote'=>(trim($lote[$x]) != "") ? $lote[$x] : null,
                            'dee_estado' => 1,
                            'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dee_id = $this->gsatelite->ingresar('dee_detalle_mov', $dee_array);
                         /* ===============================================================================================================
                                                                    EMPAQUETADO
                                                                    =================================================================================================================*/
                                                                    $empaquetados   = $this->input->post('empaque_orden_'.$producto_art[$x]);
                                                                    $caracteristica = $this->input->post('empaque_carac_'.$producto_art[$x]);
                                                                    $codigo         = $this->input->post('empaque_codigo_'.$producto_art[$x]);
                                                                    $unidades       = $this->input->post('empaque_unidades_'.$producto_art[$x]);
                                                                    $neto           = $this->input->post('empaque_peso_n_'.$producto_art[$x]);
                                                                    $bruto          = $this->input->post('empaque_peso_b_'.$producto_art[$x]);

                                                                    foreach ($empaquetados as $value => $empaquetado) {
                                                                        $dmp_array = array(
                                                                            'dmp_id_cxu'            => $caracteristica[$value],
                                                                            'dmp_id_dee'            => $dee_id,
                                                                            'dmp_orden'             => $empaquetados[$value],
                                                                            'dmp_codigo_empaque'    => $codigo[$value],
                                                                            'dmp_cantidad'          => $unidades[$value],
                                                                            'dmp_peso_neto'         => $neto[$value],
                                                                            'dmp_peso_bruto'        => $bruto[$value],
                                                                            'dmp_procesado_salida'  => 0,
                                                                            'dmp_estado'            => 1,
                                                                            'dmp_usu_creacion'      => $this->tank_auth->get_user_id(),
                                                                            'dmp_fecha_creacion'    => date('Y-m-d H:i:s'),
                                                                            'dmp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                                                                            'dmp_fecha_modificacion'=> date('Y-m-d H:i:s')
                                                                        );
                                                                        $dmp_id = $this->gsatelite->ingresar('dmp_detalle_empaque', $dmp_array);
                                                                    }
                        /* =========================================================================================
                                                        CARACTERÍSTICAS POR DETALLE
                                                        ==========================================================================================*/
                                                        for ($y = 0; $y < count($caracteristicas_id); $y++) {
                        //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                                                            if ($tipo[$x] == 0) {

                                                            } else if ($tipo[$x] == 1) {
                            //toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                $caracteristicas_id_valor = $this->input->post('valorcaja_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                //la descripcion es el nombre de car_caracteristicas
                                $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                            } else if ($tipo[$x] == 2) {
                            //toma los valores de las cajas escondidas despues de aplicar la formula se almacenan en estas
                            //si no se a seleccionado ninguna formula, entonces el valor de las cajas que se toma seria las visibles
                                if ($formula != "") {
                                    $caracteristicas_id_valor = $this->input->post('valor_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                } else {
                                    $caracteristicas_id_valor = $this->input->post('valorcaja_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                }
                                //la descripcion es el nombre de car_caracteristicas
                                $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $producto_art[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                            }
                            if ($tipo[$x] != 0) {
                                if (trim($caracteristicas_id_valor) != "") {
                                //die(print_r($caracteristicas_id_valor));
                                // Se guardará en la tabla cdi_caract_detalle_inventario
                                    $caracteristicas_inv = array(
                                        'cdi_id_cxu' => $caracteristicas_id[$y],
                                        'cdi_id_dee' => $dee_id,
                                        'cdi_valor' => (trim($caracteristicas_id_valor) != "") ? $caracteristicas_id_valor : null,
                                        'cdi_descripcion' => (trim($caracteristicas_id_descripcion) != "") ? $caracteristicas_id_descripcion : null,
                                        'cdi_estado' => 1,
                                        'cdi_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'cdi_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'cdi_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdi_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    // die(print_r($caracteristicas_inv));
                                    $this->gsatelite->ingresar('cdi_caract_detalle_inventario', $caracteristicas_inv);
                                }
                            }
                        }
                        /*======================================================================================
                                                   CENTRO COSTO
                                                   ======================================================================================*/
                                                   $identificador = '_'.$producto_art[$x].'_'.$correlativo[$x];
                                                   $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                                                   $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                                                   $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                                                   $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                                                   $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                                                   $fecha_creacion = date('Y-m-d H:i:s');
                                                   $costo_sav = array();
                                                   if($centro_costo_costo != ''){
                                                    foreach ($centro_costo_costo as $id_cost => $costo) {
                                                        $costo_sav[] = array(
                                                            'dcm_id_dee' => $dee_id,
                                                            'dcm_id_cec' => $centro_costo_costo[$id_cost],
                                                            'dcm_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                                            'dcm_id_cnt' => $cuenta_contable_costo[$id_cost],
                                                            'dcm_porcentaje' => $porcentaje_costo[$id_cost],
                                                            'dcm_monto' => $subtotal_costo[$id_cost],
                                                            'dcm_estado' => 1,
                                                            'dcm_usu_creacion' => $this->tank_auth->get_user_id(),
                                                            'dcm_fecha_creacion' =>  $fecha_creacion,
                                                            'dcm_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                            'dcm_fecha_modificacion' =>  $fecha_creacion
                                                        );
                                                    }
                                                    $this->gsatelite->ingresar('dcm_detalle_centrocostoxmovimiento', $costo_sav, true);
                                                }
                        /*======================================================================================
                                                    FIN CENTRO COSTO
                                                    =======================================================================================*/
                                                    if ($doc_proveedor_dcp != null) {
                                                        $actualizar_dxd = array(
                                                            'dxd_procesado_inventario' => 1,
                                                            'dxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                            'dxd_fecha_modificacion' => date('Y-m-d H:i:s')
                                                        );
                                                        $this->gsatelite->actualizar_array("dxd_detalle_documento_proveedor", $actualizar_dxd, array("dxd_id_bod" => $bodega_bod, "dxd_id_art" => $producto_art[$x], "dxd_id_dpv" => $doc_proveedor_dcp));
                                                    }

                    }
                }

                if ($doc_proveedor_dcp != null) {
                    $obs = $this->gsatelite->get_campo('dpv_documento_proveedor', 'dpv_observacion', array('dpv_id' => $doc_proveedor_dcp));
                    $fec = (trim($this->input->post('fecha_registro_mov')) != "") ? formatear_fecha('d-m-Y', $this->input->post('fecha_registro_mov')) : date('d-m-Y');
                    $actualizar = array(
                        'dpv_afecta_inventario' => 1,
                        'dpv_observacion' => $obs . " //Afecta inventario " . $fec,
                        'dpv_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dpv_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array("dpv_documento_proveedor", $actualizar, array("dpv_id" => $doc_proveedor_dcp));
                }

            }

            //============= Generar asiento entrada inventario ===============//
            $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_INVENTARIO');
            $doc_referencia = ($this->input->post('doc_referencia')) ? $this->input->post('doc_referencia') : '';

            if($generar_partida > 0){
                $res_debe = $this->generar_asiento_entrada_inv_debe($moi_id, $doc_referencia);
                //$this->generar_asiento_entrada_inv_haber($proveedor_prv, $res_debe['id_pct'], $res_debe['total_haber']);//Proveedor, idpartida
                $this->generar_asiento_entrada_inv_haber($tip_entrada, $res_debe['id_pct'], $res_debe['total_haber']);//Proveedor, idpartida
                $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_debe['id_pct']), array('moi_id' => $moi_id));
            }
            //==============Fin Generar asiento entrada inventario ===========//

            $moi_id;
            $bodega_bod;

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Entrada de productos", 'texto_alerta' => "El registro se guardó correctamente");
            $this->session->set_flashdata($alerta);
            if ($redireccion == 0) {
                redirect('/inventario/gestion_productos/agregar_entrada');
            } else {
                redirect('/inventario/gestion_productos/entrada_productos');
            }
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Entrada de productos", 'texto_alerta' => "Los campos con * son requeridos");
            $this->session->set_flashdata($alerta);
            redirect('/inventario/gestion_productos/agregar_entrada');
        }
    }

    public function ajustes() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Ajustes de inventario';
            $data['bodega'] = $this->inventario_model->usuarioxbodega();
            $this->_cargarvista($data);
        }
    }

    public function ajustes_xls($export=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if (!$_FILES && $export == null) {
                $this->gsatelite->show_dialog('No es posible cargar el detalle de ajuste', 'inventario/gestion_productos/ajustes', 'error' );
            }
            $codigo_leidos  = array();
            $excel          = new Excel_reader;
            $excel->read($_FILES["excelfile"]["tmp_name"]);

            $data['bodega']     = $_POST['bodega'];
            $data['nombre_bod'] = $_POST['nombre_bod'];

            $datos_excel= $excel->sheets[0];
            $registros  = $datos_excel['cells'];
            $html       = '<tbody id="contenedor">';
            unset($registros[1]);// se quita primera linea de tiulos
            //print_r($registros); die();
            $es_string = 0;
            foreach ($registros as $fila) {
                $repetido       = false;
                $codigo_producto= $fila[1];
                $cantidad_fisica= $fila[2];
                
                if (!is_numeric($cantidad_fisica)) {
                    $es_string += 1;
                    $cantidad_fisica = 0;
                }
                
                if (in_array($codigo_producto, $codigo_leidos, true)) {
                    $repetido = true;  
                }

                $html .= ($repetido == false)?'<tr>':'<tr style="background-color: #FFF55C;">';     
                $this->db->limit(1);         
                $id_art = $this->gsatelite->get_campo("art_articulo", "art_id", array("art_codigo" => trim($codigo_producto)) );

                if ( $id_art != null ) {
                    $saldos = $this->inventario_model->get_ajuste_existencia(array('art_id' => $id_art, 'sar_id_bod' => $data['bodega']) );

                    if ( count($saldos) > 0 ) {  
                        if ($repetido == true) {
                            $html .= '<td>'.$codigo_producto;
                            $html .= '<td>'.$saldos[0]['art_nombre'].'</td>';
                            $html .= '<td colspan="3">Código duplicado</td>';
                        } else {
                            array_push($codigo_leidos,$codigo_producto); 
                            $html .= '<td>'.$codigo_producto;
                            $html .= '<input type="hidden" name="productos[]" id="productos" value="' . $codigo_producto . '"/>';
                            $html .= '<input type="hidden" name="name_prod[]" id="name_prod" value="' . $saldos[0]["art_nombre"] . '"/>';
                            $html .= '<input type="hidden" name="codigo_prod[]" id="codigo_prod" value="'.$codigo_producto.'"/>';
                            $html .= '<input type="hidden" name="id_prod[]" id="id_prod" value="'.$id_art.'"/>';
                            $html .= '</td>';
                            $html .= '<td>'.$saldos[0]['art_nombre'].'</td>';
                            $html .= '<td>'.$cantidad_fisica;
                            $html .= "<input type='hidden' name='cantidad[]' id='cantidad' value='" . $cantidad_fisica . "'/>";
                            $html .= '</td>';
                            $html .= '<td>'.$saldos[0]['cantidad_existencia'];
                            $html .= "<input type='hidden' name='existencia[]' id='existencia' value='" . $saldos[0]['cantidad_existencia'] . "'/>";
                            $html .= '</td>';
                            if ( $saldos[0]['cantidad_existencia'] > $cantidad_fisica ) {
                                $html .= '<td><span style="color:red;">Faltante(-' . number_format( ($saldos[0]['cantidad_existencia'] - $cantidad_fisica), 2) . ')</span><input type="hidden" value="0" class="tipo_movimiento" name="tipo_movimiento[]"><input type="hidden" value="0" name="efectuar_movimiento[]"><input type="hidden" value="Faltante(-' . number_format( ($saldos[0]['cantidad_existencia'] - $cantidad_fisica), 2) . ')" name="text_mov[]"></td>';
                            } else if ( $saldos[0]['cantidad_existencia'] < $cantidad_fisica ) {
                                $html .= "<td><span style='color:green;'>Sobrante(+" . number_format( ($cantidad_fisica - $saldos[0]['cantidad_existencia']), 2) . ")</span><input type='hidden' value='1' class='tipo_movimiento' name='tipo_movimiento[]'><input type='hidden' value='0' name='efectuar_movimiento[]'><input type='hidden' value='Sobrante(+" . number_format( ($cantidad_fisica - $saldos[0]['cantidad_existencia']), 2) . ")' name='text_mov[]'></td>";
                            } else {
                                $html .= "<td><span style='color:blue;'>Correcto" . "</span><input type='hidden' value='2' class='tipo_movimiento'name='tipo_movimiento[]'><input type='hidden' value='0' name='efectuar_movimiento[]'><input type='hidden' value='Correcto' name='text_mov[]'></td>";
                            }
                        }                      
                    } else {
                        $html .= '<td>'.$codigo_producto.'</td><td colspan="4">Producto no encontrado en movimientos de inventario.</td>';    
                    }
                } else {
                    $html .= '<td>'.$codigo_producto.'</td><td colspan="4">Producto no fue encontrado.</td>';
                }
                $html .= '</tr>';
            }
            $html .= '</tbody></table></center>';
            $nr_sheets = count($excel->sheets);       // gets the number of sheets
            $excel_data = '';
            // to store the the html tables with data of each sheet
            // traverses the number of sheets and sets html table with each sheet data in $excel_data

            for ($i = 0; $i < $nr_sheets; $i++) {
                if ($excel->sheets[$i]['numCols'] <= 2) {
                    $re_h = '<center><table class="responsive table table-bordered contenedor" style="width:75%" id="data_expand" name="data_expand">';     // starts html table
                    $re_h .= '<thead>';
                    $re_h .= '<tr>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'PRODUCTO';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CÓDIGO';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CANTIDAD FISICA';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'CANTIDAD EXISTENCIA';
                    $re_h .= '</th>';
                    $re_h .= '<th colspan="1">';
                    $re_h .= 'MOVIMIENTO';
                    $re_h .= '</th>';
                    $re_h .= '</tr>';
                    $re_h .= '</thead>';
                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center>' . $re_h . $html . '<br/>';
                } else {
                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center><br/><center><h3>';
                    $excel_data .= 'La hoja actual no cumple con el formato de dos columnas: " [COD_ARTICULO][CANTIDAD FISICA] "</h3><br/>';
                    $excel_data .= '<h4>Favor revisar documento de excel y cantidad de columas seleccionadas</h4></center><br/>';
                }
            }

            $data['tabla_html'] = $excel_data;

            if ($es_string > 0) {
                $alerta = array('tipo_alerta' => 'error', 
                'titulo_alerta' => "Ajustes de inventario", 
                'texto_alerta' => "La cantidad fisica debe ser un numero.",
                "cantidad_fisica" => true);
                $this->session->set_flashdata($alerta);
            } else {
                $alerta = array("cantidad_fisica" => false);
                $this->session->set_flashdata($alerta);
            }
            //print_r($es_string);die();
            $data['tipo_transaccion'] = $this->inventario_model->cargar_tipo_proceso('tip_ajuste = 1 and (tip_entrada = 1 or tip_salida = 1)');
            $data['titulo_personal'] = 'Ajustes de inventario';
            $this->_cargarvista($data);
        }
    }

    function sheetData($sheet, $bodega) {
        $re = '<tbody id="contenedor">';
        //print_r($sheet);exit();die();
        $unpacker = $this->procesar_info($sheet, $bodega);

        $x = 1;
        while ($x <= $sheet['numRows']) {
            $re .= "<tr>\n";
            $y = 1;
            while ($y <= $sheet['numCols']) {

                $cell = isset($sheet['cells'][$x][$y]) ? $sheet['cells'][$x][$y] : '';

                print_r($unpacker[$y - 1][$x - 1] != '');

                if ($unpacker[$y - 1][$x - 1] != "Producto no encontrado en movimientos de inventario") {
                    if ($unpacker[$y - 1][$x - 1] != '') {
                        $re .= "<td style='text-align: left;'>";
                        switch ($y) {
                            case 1:
                            $re .= $unpacker[$y - 1][$x - 1] . " [" . $cell . "]" . "<input type='hidden' name='productos[]' id='productos' value='" . $cell . "'/><input type='hidden' name='name_prod[]' id='name_prod' value='" . $unpacker[$y - 1][$x - 1] . " [" . $cell . "]"  . "'/></td>\n";
                            break;

                            case 2:
                            $re .= "<input type='hidden' name='cantidad[]' id='cantidad' value='" . $unpacker[$y - 1][$x - 1] . "'/>" . number_format($unpacker[$y - 1][$x - 1], 2) . "</td>\n";
                            $re .= "<td style='text-align: left;'><input type='hidden' name='existencia[]' id='existencia' value='" . $unpacker[$y][$x - 1] . "'/>";

                            if ($unpacker[$y][$x - 1] == '.00') {
                                $re .= "0</td>\n";
                            } else {
                                $re .= number_format($unpacker[$y][$x - 1], 2) . "</td>\n";
                            }

                            if ($unpacker[$y][$x - 1] > $unpacker[$y - 1][$x - 1]) {
                                $re .= "<td><span style='color:red;'>Faltante(-" . number_format(($unpacker[$y][$x - 1] - $unpacker[$y - 1][$x - 1]), 2) . ")</span><input type='hidden' value='0' class='tipo_movimiento' name='tipo_movimiento[]'><input type='hidden' value='0' name='efectuar_movimiento[]'><input type='hidden' value='Faltante(-" . number_format(($unpacker[$y][$x - 1] - $unpacker[$y - 1][$x - 1]), 2) . ")' name='text_mov[]'></td>\n";
                            } elseif ($unpacker[$y][$x - 1] < $unpacker[$y - 1][$x - 1]) {
                                $re .= "<td><span style='color:green;'>Sobrante(+" . number_format(($unpacker[$y - 1][$x - 1] - $unpacker[$y][$x - 1]), 2) . ")</span><input type='hidden' value='1' class='tipo_movimiento' name='tipo_movimiento[]'><input type='hidden' value='0' name='efectuar_movimiento[]'><input type='hidden' value='Sobrante(+" . number_format(($unpacker[$y - 1][$x - 1] - $unpacker[$y][$x - 1]), 2) . ")' name='text_mov[]'></td>\n";
                            } else {
                                $re .= "<td><span style='color:blue;'>Correcto" . "</span><input type='hidden' value='2' class='tipo_movimiento'name='tipo_movimiento[]'><input type='hidden' value='0' name='efectuar_movimiento[]'><input type='hidden' value='Correcto' name='text_mov[]'></td>\n";
                            }
                            break;
                        }
                    }
                    // } else {
                    //     if ($y == 2) {
                    //         $re .= "</td><td></td>\n";
                    //     } else {
                    //         $re .= "</td><td></td>\n";
                    //     }
                    // }
                } else {
                    $re .= "<td style='text-align: center;' colspan='4'>";
                    if ($y == 2) {
                        //$re .= "</td><td></td>\n";
                    } else {
                        $re .= $unpacker[$y - 1][$x - 1] . "</td>\n";
                    }
                }
                $y++;
            }
            $re .= "</tr>\n";
            $x++;
        }

        return $re . '</tbody></table></center>';     // ends and returns the html table
    }

    function procesar_info($hoja, $bodega) {
        $condiciones[0] = array(); //Productos
        $condiciones[1] = array(); //Cantidades fisicas
        $condiciones[2] = array(); //Cantidades existentes

        $x = 1;
        while ($x <= $hoja['numRows']) {
            $y = 1;
            while ($y <= $hoja['numCols']) {
                $cell = isset($hoja['cells'][$x][$y]) ? $hoja['cells'][$x][$y] : '';

                $condiciones[$y - 1] = array_merge($condiciones[$y - 1], array($cell));

                $y++;
            }
            $x++;
        }

        foreach ($condiciones[0] as $key => $valor) {

            if ($condiciones[0][$key] != '') {
                $id_art = $this->db->select('art_id')->where('art_codigo', $condiciones[0][$key])->from('art_articulo')->get()->result_array();
                $id_art = (count($id_art)>0)?$id_art:null;
                // exit();die();
                //$resulters = $this->inventario_model->kardex_ajustes(@$id_art[0]['art_id'], $bodega);
                $resulters = $this->inventario_model->get_ajuste_existencia(array('sar_id_art'=>$id_art[0]['art_id'], 'sar_id_bod'=>$bodega));
                if(count($resulters) > 0){
                    if($resulters[0]['cantidad_existencia'] != null){
                        $condiciones[0][$key] = $resulters[0]['art_nombre'];
                        $condiciones[2][$key] = $resulters[0]['cantidad_existencia'];
                    } else{
                        $condiciones[0][$key] = "Producto no encontrado en movimientos de inventario";
                        $condiciones[1][$key] = "";
                        $condiciones[2][$key] = "";
                    }
                } else{
                    $condiciones[0][$key] = "Producto no encontrado en movimientos de inventario";
                    $condiciones[1][$key] = "";
                    $condiciones[2][$key] = "";
                }
            } else {
                $condiciones[0][$key] = "";
                $condiciones[1][$key] = "";
                $condiciones[2][$key] = "";
            }
        }


        return $condiciones;
    }

    function datos_bodega() {
        $bod_id = $this->input->post('bodega');
        $tipo_bodega = $this->inventario_model->datos_bodega($bod_id);
        $arreglo = array(
            "tip_bodega" => $tipo_bodega[0]['bod_tipo_bodega']
        );

        echo json_encode($arreglo);
    }

    function get_tip_art() {
        $option = "";
        $var = '<option value="0">Seleccione una opción</option>';
        $categorias = $this->inventario_model->get_categorias();
        $bod_id = $this->input->post('bodega_sel');
        $tipo_bodega = $this->inventario_model->datos_bodega($bod_id);
        $bodega_destino = $this->inventario_model->bodega_destino($bod_id);
        $productosxbodega = $this->inventario_model->prductosxbodega($bod_id);
        //echo print_r($this->db->last_query());
        //echo die(print_r($bodega_destino));
        $bod = '<option value="0">Seleccione una opción</option>';
        foreach ($bodega_destino as $fila) {
            $bod .= "<option value='" . $fila['bod_id'] . "'>" . $fila['bod_nombre'] . "</option>";
        }

        foreach ($categorias as $key) {
            $var .= "<option value='" . $key['tia_id'] . "'>".$key['tia_codigo'].' - '.$key['tia_nombre'] . "</option>";
        }
        $art_opt = '<option value="0">Seleccione una opción</option>';
        foreach ($productosxbodega as $producto) {
            $art_opt .= "<option value='" . $producto['art_id'] . "' name='" . $producto['sar_cant_actual'] . "''>" . $producto['art_codigo'] . " " . $producto['art_nombre'] . "</option>";
        }


        $sectores_html = "<option></option>";
        $sectores = $this->inventario_model->get_sector_grid($bod_id);
        foreach ($sectores as $ser) {
            $sectores_html .= "<option value='" . $ser['sxb_id'] . "' >" . $ser['seb_nombre'] . "</option>";
        }

        if (count($sectores) == 0) {
            $sectores_html = "";
        }

        //echo print_r($art_opt);
        $arreglo = array(
            "drop" => $var,
            // "tip_bodega"=>$tipo_bodega[0]['bod_tipo_bodega'],
            "bodega_destino" => $bod,
            "artxbodega" => $art_opt,
            'sectores' => $sectores_html
        );

        echo json_encode($arreglo);
    }

    function get_hija_cat() {
        $hija = $this->input->post('departamento_sel');
        $option = "";
        $var = '<option>Seleccione una opción</option>';
        $hijas_categorias = $this->inventario_model->get_categorias_hijas2($hija);

        foreach ($hijas_categorias as $key) {
            $var .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos_xcat() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $options = "";
            //$var ="<option value=''> seleccione una opcionasas </option>";
            $var = '<option> Seleccione una opción </option>';
            $categoria = $this->input->post('categoria_sel');
            $bodega = $this->input->post('bodega_sel');
            $consulta = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $bodega));
            // $tipo_bodega = $consulta[0]['bod_tipo_bodega'];
            $articulos = $this->inventario_model->get_productos_categoria($categoria);


            $etiqueta = 0;
            foreach ($articulos as $fila) {
                $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "'>" . $fila['art_codigo'] . "--" . $fila['art_nombre'] . "--" . $fila['mep_nombre'] . "</option>";
                $etiqueta++;
            }


            $arreglo = array(
                "drop" => $var,
            );

            echo json_encode($arreglo);
        }
    }

    function cantidad_minima_prod($flag = false) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_art = $this->input->post('product');
            $bodega = $this->input->post('bodega');
            $articulos = $this->inventario_model->obt_cant_minimaYexistente($id_art, $bodega);
            $i = count($articulos) - 1;
            $existente = $articulos[$i]['suma'];
            $minimo = $articulos[$i]['art_minimo'];
            if (!empty($minimo)) {
                if ($existente < $minimo) {
                    $var = 0;
                } else {
                    $var = 1;
                }
            } else {
                $var = 2;
            }
            foreach ($articulos as $suma) {
                $suma_art = $suma['suma'];
            }
            if (empty($suma_art)) {
                $suma_art = 0;
            }
            $datos = $this->inventario_model->datos_generles_articulo($id_art);
            $datos_arti = "";
            $etiqueta = 0;
            foreach ($datos as $fila) {
                $datos_arti .= "<input value='" . $fila['art_codigo'] . "' id='dato_prod_cod'>";
                $datos_arti .= "<input value='" . $fila['art_nombre'] . "' id='dato_prod_nom'>";
                $datos_arti .= "<input value='" . $fila['mep_nombre'] . "' id='dato_prod_um'>";
                $datos_arti .= "<input value='" . $suma_art . "' id='dato_prod_sum'>";
                $etiqueta++;
            }

            $arreglo = array("drop" => $var, "dat" => $datos_arti);
            if ($flag) {
                return $arreglo;
            } else {
                echo json_encode($arreglo);
            }
        }
    }

    public function salida_productos($consulta = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/gestion_productos/salida_productos');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array     = $_POST;
                    $tipo_entrada   = $post_array['estado'];
                    $fecha_inicio   = $post_array['fecha_ini'];
                    $fecha_fin      = $post_array['fecha_fin'];
                    $where          = null;
                    
                    if ($tipo_entrada) {
                        $where['moi_id_tip'] = $tipo_entrada;
                    }
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['DATE(moi_fecha_mov) >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['DATE(moi_fecha_mov) <='] = date('Y-m-d', strtotime($fecha_fin));
                    }
                    
                    $salida         = $this->inventario_model->get_backlog_inventario_salida($where);                    
                    $data['salida'] = $salida;
                    // print_r($data);die();
                    $html           = $this->load->view('inventario/gestion_productos/consultar_salidas_productos', $data, true);
                    echo $html;
                    die();
                }
            } else {
                $select                     = $this->gsatelite->get_dropdown('tip_tipo_proceso', '{tip_nombre}', '', array('tip_estado' => 1, 'tip_salida' => 1), null, '', 'tip_id', true);
                $data['tipo_proceso']       = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data['titulo_personal']    = 'Salida de productos';
                $this->_cargarvista($data);
            }
        }
    }

    function agregar_salida() {                
        satelite_validar();
        $select = $this->gsatelite->get_dropdown('prv_proveedor', '[CASE WHEN prv_tipo_pers = 2 then CONCAT(prv_codigo,"-",prv_nombre) ELSE CONCAT(prv_codigo,"-",prv_nombre," ", prv_apellido) END ]', '', array('prv_estado' => 1), null, '', 'prv_id', true);
        $data["proveedores"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        //Filtra las bodegas por usuario
        $bodegas = $this->inventario_model->get_bodegas_usuario();
        $select = "";
        foreach ($bodegas as $key) {
            $select .= "<option value='" . $key['bod_id'] . "'>" . $key['bod_nombre'] . "</option>";
        }
        $data["bodega_bod"] = $select;

        //muestra el tipo de salida
        $select = $this->gsatelite->get_dropdown('tip_tipo_proceso', '{tip_nombre}', '', array('tip_estado' => 1, 'tip_salida' => 1), null, '', 'tip_id', true);
        $data["salida_tip"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        //muestra los articulos
        $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1, 'tia_padre' => null), null, '', 'tia_id', true);
        $data["categoria_tia"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        //muestra las requisiciones
        $flujo = json_decode($this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO'), true);
        $rxi_bodega = (count($bodegas) > 0) ? array_filter(array_column($bodegas, 'bod_id')) : array(0);
                       $this->db->where_in('rxi_id_bod', $rxi_bodega);
        $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id_flu' => $flujo['REQ_INV'], 'rxi_tipo != ' => 3));
        $select = "";
        foreach ($requisicion as $key) {
            if ($key["rxi_estado"] == 6 || $key["rxi_estado"] == 3) {
                if ($key['rxi_id_bod'] == null) {
                    $bodega = 0;
                } else {
                    $bodega = $key['rxi_id_bod'];
                }
                $solicitante = $this->inventario_model->informacion_empleado($key['rxi_id_usu_solicita']);
                $select .= '<option value="'.$key['rxi_id'].'" bodega="'.$bodega.'">'.$key['rxi_numero'].' - '.$solicitante[0]['are_nombre'].' ('.formatear_fecha('d-m-Y', $key['rxi_fecha']).')</option>';
            }
        }
        $data["requisicion_rxi"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        
        //CLIENTES CON FACTURAS QUE NO SE HAN DESCARGADO DE INVENTARIO
        $client = '';
        $clientes = $this->inventario_model->get_cli_fac_sin_moi();
        foreach ($clientes as $cli) {
            $codigo = ($cli['cli_codigo'] != '') ? trim($cli['cli_codigo']) . ' - ' : '';
            $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
            $client .= '<option value="' . $cli['cli_id'] . '">' . $nombre_cliente . '</option>';
        }

        $cantidad_defecto = $this->gsatelite->get_parametro('SYS_INV_DEFECTO_CANTIDAD_PRODUCTOS');
        $data['cantidad_defecto'] = ($cantidad_defecto != null && $cantidad_defecto > 0 )?$cantidad_defecto:"";
        $data['clientes'] = $client;
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['proceso_unidad'] = $this->inventario_model->cargar_todo('mep_medida_producto');
        $data['tipo_transaccion'] = $this->inventario_model->cargar_todo('tip_tipo_proceso', array('tip_entrada' => 1, 'tip_estado' => 1));
        $data['cantidad_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $data['costo_promedio'] = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
        $data['titulo_personal'] = 'Salida de inventario';
        $this->_cargarvista($data);
    }

    function cargar_documento_cliente(){
        $id_cliente = $this->input->post('cliente');
                      $this->db->join('moi_movimiento_inv','moi_id_fac = fac_id','left')->where('moi_id_fac');
        $documentos = $this->gsatelite->get_tabla('fac_factura', array('fac_id_cli'=>$id_cliente, 'fac_estado'=>1, 'fac_total > 0' => null));        
        $select = '<option value=""></option>';
        foreach ($documentos as $key) {
            $select .= '<option value="'.$key['fac_id'].'">Doc. #'.$key['fac_numero'] . '  (' . formatear_fecha('d-m-Y', $key['fac_fecha_fact']) . ')</option>';
        }
        echo json_encode(array('resp'=>$select));
    }

    function guardar_salida($info_salida = null) {
        if($info_salida == null){
            $post_array = $this->input->post();
            $doc_cliente_dcc= (trim($this->input->post('doc_cliente_dcc')) != "")?$this->input->post('doc_cliente_dcc'):null; //fac_id
            $requisicion_rxi= (trim($this->input->post('requisicion_rxi')) != "") ? $this->input->post('requisicion_rxi') : null;
            $doc_referencia = (trim($this->input->post('doc_referencia')) != "") ? $this->input->post('doc_referencia') : null;
            $fecha_registro = (trim($this->input->post('fecha_registro')) != "") ? formatear_fecha('Y-m-d',$this->input->post('fecha_registro')) : null;
            $bodega_bod     = (trim($this->input->post('bodega_bod')) != "") ? $this->input->post('bodega_bod') : null;
            $tip_salida     = (trim($this->input->post('tip_salida')) != "") ? $this->input->post('tip_salida') : null;
            $comentario     = (trim($this->input->post('comentario')) != "") ? $this->input->post('comentario') : null;
            $moi_id_prv     = (trim($this->input->post('slc_proveedor')) != "") ? $this->input->post('slc_proveedor') : null;
            $moi_id_dpv     = (trim($this->input->post('slc_documento_proveedor')) != "") ? $this->input->post('slc_documento_proveedor') : null;
            $redireccion    = $this->input->post('redireccion');
            $tipo_proceso   = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            $reversa = (trim($this->input->post('reversa')) != "") ? $this->input->post('reversa') : 0;
            $moi_id_moi_reversa = null;
            if ($reversa == 1) {
                $moi_id_moi_reversa =  (trim($this->input->post('moi_id_inicia_reversa')) != "") ? $this->input->post('moi_id_inicia_reversa') : null;
            }
            //$this->input->post('reversa');

            $producto_art   = $this->input->post('producto_art'); //array
            $correlativo    = $this->input->post('correlativo'); //array
            $medida_cva     = $this->input->post('medida_cva'); //array
            $cantidad_dee   = $this->input->post('cantidad_dee'); //array
            $sector_sxb     = $this->input->post('sector_sxb'); //array
            $codigo_lote    = $this->input->post('codigo_lote'); //array
        }else{
            $post_array = $info_salida;
            $doc_cliente_dcc= ($info_salida['doc_cliente_dcc'] != "")?$info_salida['doc_cliente_dcc']:null;
            $requisicion_rxi= ($info_salida['requisicion_rxi'] != "") ? $info_salida['requisicion_rxi'] : null;
            $doc_referencia = ($info_salida['doc_referencia'] != "") ? $info_salida['doc_referencia'] : null;
            $fecha_registro = ($info_salida['fecha_registro'] != "") ? formatear_fecha('Y-m-d',$info_salida['fecha_registro']) : null;
            $bodega_bod     = ($info_salida['bodega_bod'] != "") ? $info_salida['bodega_bod'] : null;
            $tip_salida     = ($info_salida['tip_salida'] != "") ? $info_salida['tip_salida'] : null;
            $comentario     = ($info_salida['comentario'] != "") ? $info_salida['comentario'] : null;
            $moi_id_prv     = ($info_salida['slc_proveedor'] != "") ? $info_salida['slc_proveedor'] : null;
            $moi_id_dpv     = ($info_salida['slc_documento_proveedor'] != "") ? $info_salida['slc_documento_proveedor'] : null;
            $redireccion    = $this->input->post('redireccion');
            $tipo_proceso   = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            
            $reversa = ($info_salida['reversa'] != "") ? $info_salida['reversa'] : 0;
            $moi_id_moi_reversa = null;
            if ($reversa == 1) {
                $moi_id_moi_reversa =  ($info_salida['moi_id_inicia_reversa'] != "") ? $info_salida['moi_id_inicia_reversa'] : null;
            }
            $producto_art   = $info_salida['producto_art']; //array
            $correlativo    = $info_salida['correlativo']; //array
            $medida_cva     = $info_salida['medida_cva']; //array
            $cantidad_dee   = $info_salida['cantidad_dee']; //array
            $sector_sxb     = $info_salida['sector_sxb']; //array
            $codigo_lote    = $info_salida['codigo_lote']; //array
        }
        if (trim($bodega_bod) != "" && trim($tip_salida) != "") {
            $respuesta = $this->db->insert('moi_movimiento_inv', array(
                'moi_id_prv'            => $moi_id_prv,
                'moi_id_dpv'            => $moi_id_dpv,
                'moi_id_tip'            => $tip_salida,
                'moi_id_bod'            => $bodega_bod,
                'moi_id_fac'            => $doc_cliente_dcc,
                'moi_documento'         => $doc_referencia,
                'moi_id_rxi'            => $requisicion_rxi,
                'moi_descripcion'       => $comentario,
                'moi_fecha_mov'         => ($fecha_registro !='')?  $fecha_registro.' '.date('H:i:s'):date('Y-m-d H:i:s'),
                //'moi_reversa'           => $reversa,
                //'moi_id_moi_reversa'    => $moi_id_moi_reversa,
                'moi_estado'            => 1,
                'moi_usu_creacion'      => $this->tank_auth->get_user_id(),
                'moi_fecha_creacion'    => date('Y-m-d H:i:s'),
                'moi_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion'=> date('Y-m-d H:i:s')
            ));
            $moi_id = $this->db->insert_id(); 
            //Actulizar el movimiento que genera la reversa
            $array_update_moi_inicial = array(
                'moi_reversa'           => $reversa,
                'moi_id_moi_reversa'    => $moi_id
            );
            $this->gsatelite->actualizar_array('moi_movimiento_inv', $array_update_moi_inicial, array('moi_id' => $moi_id_moi_reversa) ) ;

            for ($x = 0; $x < count($producto_art); $x++) {
                if (trim($producto_art[$x]) != "" && trim($cantidad_dee[$x]) != "" && trim($cantidad_dee[$x]) > 0) {
                    $cantidades = $this->inventario_model->get_cantidad_bodega(null, $bodega_bod, null, $producto_art[$x]);
                    //evaluara el tipo de proceso que debe seguir
                    if ($tipo_proceso == 2) { //si es por fefo
                        $condiciones = array (
                            "articulo"          => $producto_art[$x],
                            "moi_id"            => $moi_id,
                            "sector"            => $sector_sxb[$x],
                            "cantidades"        => $cantidad_dee[$x],
                            "bodega"            => $bodega_bod,
                            "lote"              => $codigo_lote[$x],
                            "cantidad_maxima"   => $cantidades[0]["cantidad"],
                            "id_conversion"     => $medida_cva[$x],
                            "traslado"          => null,
                            "producto_destino"  => null,
                            "requisicion"       => $requisicion_rxi
                        );
                        $this->fefo( $condiciones );
                    } else {
                        if ($requisicion_rxi != null) {
                            $this->peps_salida($producto_art[$x], null, $moi_id, $medida_cva[$x], $cantidad_dee[$x], $sector_sxb[$x], $cantidades[0]["cantidad"], $bodega_bod, null, $requisicion_rxi, $codigo_lote[$x]);
                        } else {
                            $this->peps_salida($producto_art[$x], null, $moi_id, $medida_cva[$x], $cantidad_dee[$x], $sector_sxb[$x], $cantidades[0]["cantidad"], $bodega_bod, null, null, $codigo_lote[$x]);
                        }
                    }
                }
                if($this->input->post('chk_empaque_'.$producto_art[$x])){  $empaquetados = $this->input->post('chk_empaque_'.$producto_art[$x]);}else{  $empaquetados =array();}

                foreach ($empaquetados as $value => $empaquetado) {
                    $dmp_array = array(
                        'dmp_procesado_salida'  => 1,
                        'dmp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'dmp_fecha_modificacion'=> date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('dmp_detalle_empaque', $dmp_array, array('dmp_id' => $empaquetado) ) ;
                }
            }

            /************ Solicitud de materiales para produccion ******************************/
            if ($requisicion_rxi != null) {
                $this->consolidar_solicitud_materiales($requisicion_rxi);
                $p = $this->gsatelite->get_suma("dri_detalle_requisicion_inventario", "dri_cantidad", array("dri_id_rxi" => $requisicion_rxi));
                $d = $this->gsatelite->get_suma("dri_detalle_requisicion_inventario", "dri_cantidad_despacho", array("dri_id_rxi" => $requisicion_rxi));
                if ($d < $p) {
                    $this->gsatelite->actualizar_array("rxi_requisicion_inventario", array('rxi_estado' => 6), array('rxi_id' => $requisicion_rxi));
                }
            }
            //centro de costo
            $this->generar_centro_costo_salida($moi_id, $post_array);

            /************ Generar asiento contable Salida inventario ******************************/
            $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_INVENTARIO');
            if($info_salida == null){
                $cliente = ($this->input->post('doc_proveedor_dcp')) ? $this->input->post('doc_proveedor_dcp') : '';    
            } else {
                $cliente =  ($info_salida['doc_proveedor_dcp']) ? $info_salida['doc_proveedor_dcp'] : '';  
            }
            
            if($generar_partida > 0){
                $res_haber = $this->generar_asiento_salida_inv_haber($moi_id);
                $data_movimiento = array(
                    'moi_id' => $moi_id,
                    'moi_fecha_mov' => ($fecha_registro !='')?  $fecha_registro.' '.date('H:i:s'):date('Y-m-d H:i:s'),//(trim($this->input->post('fecha_registro')) != '')?  formatear_fecha('Y-m-d',$this->input->post('fecha_registro')):date('Y-m-d H:i:s'),
                    'moi_id_dpv' =>  $moi_id_dpv,
                    'moi_id_fac'            => $doc_cliente_dcc,
                    'moi_documento'         => $doc_referencia,
                    'moi_id_rxi'            => $requisicion_rxi,
                );
                $this->generar_asiento_salida_inv_debe($cliente, $res_haber['id_pct'], $res_haber['total_debe'], $data_movimiento);
                $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_haber['id_pct']), array('moi_id' => $moi_id));
            }
            /*************Fin generacion asiento contable salida inventario************************/

            if($info_salida!=null){
                return array('moi_id' => $moi_id);
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Salida de productos", 'texto_alerta' => "El registro se guardó correctamente");
            $this->session->set_flashdata($alerta);
            if ($redireccion == 0) {
                redirect('/inventario/gestion_productos/agregar_salida');
            }elseif ($redireccion == 2) {//En caso que sea una reversa de entrada(opcion guardar)
                redirect('/inventario/gestion_productos/agregar_entrada');
            }elseif ($redireccion == 3) {
                redirect('/inventario/gestion_productos/entrada_productos');
            } else {
                redirect('/inventario/gestion_productos/salida_productos');
            }
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Salida de productos", 'texto_alerta' => "Los campos con * son requeridos");
            $this->session->set_flashdata($alerta);
            //redirect('/inventario/gestion_productos/agregar_salida');
        }
    }

    function consolidar_solicitud_materiales($requisicion){
        $where['rxi_id']    = $requisicion;
        $consolidaciones    = $this->inventario_model->movimientos_solicitud_materiales($where);
        foreach($consolidaciones as $key => $consolidacion){
            $pendiente = $consolidacion['axm_cantidad'] - $consolidacion['despachados'];
            $pendiente = ($pendiente < 0) ? 0 : $pendiente;
            $actualizacion = array(
                'axm_pendiente'     => $pendiente,
                'axm_despachada'    => $consolidacion['despachados']
            );
            $this->gsatelite->actualizar_array('axm_articulo_matxarticulo_ord', $actualizacion, array( 'axm_id' => $consolidacion['axm_id']) );
        }
    }

    function generar_centro_costo_salida($moi, $post_array){
        $correlativo = $post_array['correlativo']; //array
        $dee_reg = $this->gsatelite->get_tabla('dee_detalle_mov', array('dee_id_moi'=>$moi));
        foreach ($dee_reg as $key => $value) {
            /* ====================================================================================================================
            CENTRO COSTO
            ======================================================================================================================*/
            $identificador = '_'.$value['dee_id_art'].'_'.$correlativo[$key];

            $centro_costo_costo = ($post_array['centro_costo_costo'.$identificador] != '')?$post_array['centro_costo_costo'.$identificador]:'';
            $tipo_cuenta_costo = $post_array['tipo_cuenta_costo'.$identificador];
            $cuenta_contable_costo = $post_array['cuenta_contable_costo'.$identificador];
            $porcentaje_costo = $post_array['porcentaje_costo'.$identificador];
            $subtotal_costo = $post_array['subtotal_costo'.$identificador];

            $fecha_creacion = date('Y-m-d H:i:s');
            $costo_sav = array();
            if($centro_costo_costo != ''){
                foreach ($centro_costo_costo as $id_cost => $costo) {
                    $costo_sav[] = array(
                        'dcm_id_dee' => $value['dee_id'],
                        'dcm_id_cec' => $centro_costo_costo[$id_cost],
                        'dcm_id_tcn' => $tipo_cuenta_costo[$id_cost],
                        'dcm_id_cnt' => $cuenta_contable_costo[$id_cost],
                        'dcm_porcentaje' => $porcentaje_costo[$id_cost],
                        'dcm_monto' => $subtotal_costo[$id_cost],
                        'dcm_estado' => 1,
                        'dcm_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dcm_fecha_creacion' =>  $fecha_creacion,
                        'dcm_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dcm_fecha_modificacion' =>  $fecha_creacion
                    );
                }
                $this->gsatelite->ingresar('dcm_detalle_centrocostoxmovimiento', $costo_sav, true);
            }
            /* ====================================================================================================================
            FIN CENTRO COSTO
            ======================================================================================================================*/
        }

    }

    function costo_promedio_salida($id_art, $bodega_bod, $sector = null, $lote = null) {
        /*
        foreach ($sar_saldo as $key) {
        $dee_detalle_entrada = $this->inventario_model->get_costo_promedio(array('dee_id_sar'=>$key["sar_id"], 'tip_entrada'=>1));
        $dee_detalle_salida = $this->inventario_model->get_costo_promedio(array('dee_id_sar'=>$key["sar_id"], 'tip_salida'=>1));
        $cantidad_salida += $dee_detalle_salida[0]["cantidad"];
        $costo_salida += $dee_detalle_salida[0]["precio"];
        $cantidad_entrada += $dee_detalle_entrada[0]["cantidad"];
        $costo_entrada += $dee_detalle_entrada[0]["precio"];
        }
        */
        $cantidad_entrada = 0;
        $costo_entrada = 0;
        $cantidad_salida = 0;
        $costo_salida = 0;

        if ($sector != null) {
            $where = array('sar_id_art' => $id_art, 'sar_id_bod' => $bodega_bod, 'sar_id_sxb' => $sector);
            if($lote!=null){ $where['dee_codigo_lote'] = $lote; }
            $dee_detalle = $this->inventario_model->get_costo_promedio($where);
        } else {
            $where = array('sar_id_art' => $id_art, 'sar_id_bod' => $bodega_bod);
            if($lote!=null){ $where['dee_codigo_lote'] = $lote; }
            $dee_detalle = $this->inventario_model->get_costo_promedio($where);
        }

        foreach ($dee_detalle as $key) {
            $datos = explode(" ", $key["valores"]);
            $cantidad_entrada += $datos[0];
            $costo_entrada += $datos[1];
            $cantidad_salida += $datos[2];
            $costo_salida += $datos[3];
        }
        //$cantidades = $this->inventario_model->get_costo_promedio(array('art_id'=>$id_art, 'bod_id'=>$bodega_bod));
        $costo_promedio = (($costo_entrada - $costo_salida) / ($cantidad_entrada - $cantidad_salida));
        return $costo_promedio;
    }

    function peps_salida($id_art, $producto_destino, $moi_id, $cva_id, $cantidad, $sector_art, $cantidad_maxima, $bodega_bod, $traslado=null, $requisicion=null, $lote=null, $array_empaques=null) {
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        //dejar null el valor del producto destino para que se tome el mismo valor el id del producto como destino
        if(trim($producto_destino) == null){
            $producto_destino = $id_art;
        }
        $peps = 0;
        $where = null;
        if ($sector_art != NULL && trim($sector_art) != "") {//SECTOR DE SALIDA
            $where = array();
            if($lote!=null && $lote > 0){ 
                $where['dee_codigo_lote'] = $lote; 
            } // Cuando es por lote
            $where['sar_id_sxb'] = $sector_art;
            $sar_saldo = $this->inventario_model->get_sar_cantidades($id_art, $bodega_bod, $where);
        } else {
            if($lote != null && $lote > 0){ 
                $where = array('dee_codigo_lote'=> $lote); 
            } // Cuando es por lote
            $sar_saldo = $this->inventario_model->get_sar_cantidades($id_art, $bodega_bod, $where);
        }
        if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 1) {
            if ($sector_art != NULL && trim($sector_art) != "") {
                $where = array('sar_id_art' => $id_art, 'sar_id_bod' => $bodega_bod, 'sar_id_sxb' => $sector_art);
                //$precio_peps = $this->costo_promedio_salida($id_art, $bodega_bod, $sector_art, $lote);
            } else {
                $where = array('sar_id_art' => $id_art, 'sar_id_bod' => $bodega_bod);
                //$precio_peps = $this->costo_promedio_salida($id_art, $bodega_bod, null, $lote);
            }
            $this->db->limit(1);
            $this->db->order_by('sar_id DESC');
            $precio_peps = $this->gsatelite->get_tabla('sar_saldo_articulo', $where);
            $precio_peps = $precio_peps[0]['sar_precio'];
            $peps = 1;
        }
        //Cantidad restante para repetir el foreach, dependiento de la cantidad que se ingreso.
        $cantidad_restante = $cantidad;
        //Cantidad para ingresar en la tabla dee_detalle
        $cantidad_ingresar = 0;
        //Cantidad restante después de restarle la cantidad elegida
        $cantidad_actualizar = 0;
        //Acumulador para salir del do while, cuando el acumulador es igual a la cantidad ingresada se saldrá del do while
        $acumulador_cantidad = 0;
        $contador = 0;
        //Precio de la primera entrada con cantidades
        //Verifica si la cantidad máxima es menor a la cantidad elegida
        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
        if ($cantidad <= $cantidad_maxima) {
            do {
                $cantidad_sar = $sar_saldo[$contador]['sar_cant_actual'];
                if (!isset($sar_saldo[$contador]['sar_cant_actual'])) {
                  $acumulador_cantidad = $cantidad;
                }else{
                    $fecha = (trim($sar_saldo[$contador]['sar_fecha_caducidad']) != "") ? date('Y-m-d', strtotime($sar_saldo[$contador]['sar_fecha_caducidad'])) : null;
                $sar_id = $sar_saldo[$contador]['sar_id'];
                if ($peps == 0) {
                    $precio_peps = $sar_saldo[$contador]["sar_precio"];
                }
                $precio_peps = ($precio_peps > 0) ? $precio_peps : 0;
                /*
                  Si la cantidad ingresada es mayor a la cantidad del registro, se hace una resta del mayor menos el menor.
                  se guarda el valor de la cantidad de sar_cant_actual en la tabla dee_detalle. Como resta cantidad para
                  almacenar, se repite el do while y pasa al otro registro y hace el mismo proceso
                 */
                if ($cantidad_sar <= $cantidad_restante) {
                    $cantidad_restante = $cantidad_restante - $cantidad_sar;
                    $cantidad_ingresar = $cantidad_sar;
                    $cantidad_actualizar = $cantidad_sar - $cantidad_ingresar;
                    $acumulador_cantidad += $cantidad_ingresar;
                } else {
                    $temp = $cantidad_restante;
                    $cantidad_restante = $cantidad_sar - $cantidad_restante;
                    $cantidad_ingresar = $temp;
                    $cantidad_actualizar = $cantidad_sar - $cantidad_ingresar;
                    $acumulador_cantidad += $cantidad_ingresar;
                }
                $costo_total = $cantidad_ingresar * $precio_peps;
                if (is_numeric($cantidad_ingresar) && $cantidad_ingresar > 0){ //validación si el dato es numerico y mayor a cero
                    $cadena_dee = array( //detalles de la salida
                        'dee_id_moi' => $moi_id,
                        'dee_id_art' => $id_art,
                        'dee_id_sar' => $sar_id,
                        'dee_id_cva' => $cva_id,
                        'dee_id_sxb' => (trim($sector_art) != "") ? $sector_art : null,
                        'dee_cantidad' => ($cantidad_ingresar)?$cantidad_ingresar:0,
                        'dee_fecha_caducidad' => $fecha,
                        'dee_precio' => $precio_peps,
                        'dee_subtotal' => $costo_total,
                        'dee_codigo_lote'=>$lote,
                        'dee_estado' => 1,
                        'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('dee_detalle_mov', $cadena_dee);
                }

                $cadena = array(
                    'sar_cant_actual' => $cantidad_actualizar,
                    'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('sar_saldo_articulo', $cadena, array('sar_id' => $sar_id));

                if ($traslado != null) {
                    $sector = (trim($traslado["sector"]) != "") ? $traslado["sector"] : null;
                    if ($costo_promedio == 1) {
                        $nuevo_precio =  $this->recalcular_precio_promedio($producto_destino, $traslado["bodega"], $cantidad_ingresar, $precio_peps);
                    }
                    if (is_numeric($cantidad_ingresar) && $cantidad_ingresar > 0){ //validación si el dato es numerico y mayor a cero
                        $cadena_sar_insert = array( //producto destino
                            'sar_id_art' => $producto_destino,
                            'sar_id_bod' => $traslado["bodega"],
                            'sar_cant_actual' => $cantidad_ingresar,
                            'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $precio_peps,
                            //'sar_precio' => $precio_peps,
                            'sar_fecha_caducidad' => $fecha,
                            'sar_id_sxb' => $sector,
                            'sar_estado' => 1,
                            'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                            'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                            'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $sar_id_entrada = $this->gsatelite->ingresar('sar_saldo_articulo', $cadena_sar_insert);

                        $cadena_dee_insert = array( //detalle de la entrada
                            'dee_id_moi' => $traslado["moi_entrada"],
                            'dee_id_art' => $producto_destino,
                            'dee_id_sar' => $sar_id_entrada,
                            'dee_id_cva' => $cva_id,
                            'dee_id_sxb' => $sector,
                            'dee_cantidad' => $cantidad_ingresar,
                            'dee_fecha_caducidad' => $fecha,
                            'dee_precio' => $precio_peps,
                            'dee_subtotal' => $costo_total,
                            'dee_codigo_lote'=>$lote,
                            'dee_estado' => 1,
                            'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dee_id = $this->gsatelite->ingresar('dee_detalle_mov', $cadena_dee_insert);
                    }

                    if ($array_empaques != null){
                        $this->traslado_empaque($array_empaques,$dee_id);
                    }
                }
                }
                
                $contador++;
            } while ($acumulador_cantidad != $cantidad);
        }
        if ($requisicion != null) {
            //hace los cambios en la requisicion
            if ($cantidad != 0) {
                $this->requisicion_salida($requisicion, $id_art, $moi_id, $cantidad);
                $solicitado = $this->gsatelite->get_suma('dri_detalle_requisicion_inventario', 'dri_cantidad', array('dri_id_rxi'=>$requisicion));
                $despachdos = $this->gsatelite->get_suma('dri_detalle_requisicion_inventario', 'dri_cantidad_despacho', array('dri_id_rxi'=>$requisicion));
                if ($despachdos < $solicitado) {
                    $this->gsatelite->actualizar_array('rxi_requisicion_inventario', array('rxi_estado' => 6), array('rxi_id' => $requisicion));
                }
            }
            //verifica si la requisicion cuenta con registros, si los estados de los productos estan concluidas el estado de la requisicion
            //pasa a despachado
            $cmb_estado = $this->inventario_model->mostrar_requisicion_salida($requisicion);
            if (count($cmb_estado) == 0) {
                $cadena = array(
                    'rxi_estado' => 0,
                    'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $cadena, array('rxi_id' => $requisicion));
            }
        }
        return 1;
    }

function requisicion_salida($rxi_id, $id_art, $moi_id, $cantidad_despachada) {
        //obtenemos el detalle de la requisicion con respecto al id del producto
    $datos_rxi = $this->inventario_model->mostrar_requisicion_salida($rxi_id, $id_art);
        //obtenemos la cantidad que se a despachado
    $cantidad_despachada_actual = $datos_rxi[0]["dri_cantidad_despacho"];
        //obtenemos la cantidad solicitada
    $cantidad_rxi = $datos_rxi[0]["dri_cantidad"];
    $dri_id = $datos_rxi[0]["dri_id"];

        //verificamos si la cantidad despachada y la cantidad que vamos a despachar es menor o igual a la cantidad solicitada
    if ((($cantidad_despachada_actual + $cantidad_despachada) <= $cantidad_rxi)) {
            //cuando la cantidad estado llegue a 0, significa que ya no hay productos pendientes y el estado de 1 cambia a 0
        $cantidad_estado = $cantidad_rxi - ($cantidad_despachada_actual + $cantidad_despachada);
            //actualizamos la cantidad despachada de la requisicion
        $cantidad_actualizar = ($cantidad_despachada_actual + $cantidad_despachada);
        $estado = 1;
        if ($cantidad_estado == 0) {
            $estado = 0;
        }
            //actualizamos los detalles de la requisicion
        $cadena = array(
            'dri_cantidad_despacho' => convertirFloat($cantidad_actualizar),
            'dri_estado' => $estado,
            'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
            'dri_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $this->gsatelite->actualizar_array('dri_detalle_requisicion_inventario', $cadena, array('dri_id' => $dri_id));

            //insertamos un detalle del movimiento
        $respuesta = $this->db->insert('dxm_detallexmovimiento', array(
                //'moi_id_prv'=> $proveedor_prv,
            'dxm_id_moi' => $moi_id,
            'dxm_id_dri' => $dri_id,
            'dxm_estado' => 1,
            'dxm_usu_creacion' => $this->tank_auth->get_user_id(),
            'dxm_fecha_creacion' => date('Y-m-d H:i:s'),
            'dxm_usu_modificacion' => $this->tank_auth->get_user_id(),
            'dxm_fecha_modificacion' => date('Y-m-d H:i:s')
        ));
            //si la requisicion  no se finaliza, el estado de la requisicion cambia a pendiente
        if ($estado == 1) {
            $cadena = array(
                'rxi_estado' => 6,
                'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $cadena, array('rxi_id' => $rxi_id));
        }
    }
}

function get_articulos_rxi() {
    $num_req = $this->input->post('id_req_sel');
        //$articulos_rxi = $this->inventario_model->id_art_id_bod($num_req);
        //$articulos_rxi = $this->consultas->cargar_req_moi($num_req);


    $articulos_rxi = $this->inventario_model->productos_requisicion_rxi_new($num_req);
    $cadena = '';
    $row = 0;

    foreach ($articulos_rxi as $id) {
        $id_art = $id['dri_id_art'];
        $bodega = $id['rxi_id_bod'];
    }
    $cantidad_existente = $this->inventario_model->obt_cant_actual_existente();


    $num_art = count($articulos_rxi);

    foreach ($articulos_rxi as $key) {
        $id_product = $key['dri_id_art'];
        $bodega = $key['rxi_id_bod'];
        $cantidad_si = 0;
        if ($key['rxi_estado'] == 3) {
            $dri_cantidad = $key['dri_cantidad'] - $key['dri_cantidad_despacho'];
        } else {
            $dri_cantidad = $key['dri_cantidad'];
        }
        $cadena .= '<tr><td><input type="hidden" value="' . $row . 'F' . $key['dri_id_art'] . '" name="ids_filaP[]" /><input type="hidden" name="bodega[]" id="bodega' . $row . '" value="' . $key['rxi_id_bod'] . '"/>';
        $cadena .= '<input type="hidden" name="categoria[]" id="categoria" value="' . $key['tia_id'] . '"/>';
        $cadena .= '<input type="hidden" name="productos[]" id="productos' . $row . '" value="' . $key['dri_id_art'] . '"/>';
        $cadena .= '<input type="hidden" name="cantidad[]" id="cantidadi' . $row . '" value="' . $dri_cantidad . '"/>';
        $cadena .= '<input type="hidden" name="ixc_detail[]" id="ixc' . $row . '" value=""/>';
        $cadena .= '<input type="hidden" class="ixc_val" name="ixc_estado" id="ixc_estado' . $row . '" value="0"/>';
        $cadena .= '<label name="producto_label" id="productos"/>' . $key['art_codigo'] . '</td>';

        $cadena .= '<td><label name="nombre_art" id="nombre_art"/>' . $key['art_nombre'] . '</td>';
        $cadena .= '<td><label name="nombre_art" id="nombre_art"/>' . $key['mep_nombre'] . '</td>';

        foreach ($cantidad_existente as $cant) {
            if ($cant['art_id'] == $id_product && $cant['bod_id'] == $bodega) {
                $cantidad_si = $cant['suma'];
            } else {
                $cantidad_no = 0;
            }
        }

        if ($cantidad_si > 0) {
            $cadena .= '<td><label name="nombre_art" id="nombre_art"/>' . $cantidad_si . '</td>';
        } else {
            $cadena .= '<td><label name="nombre_art" id="nombre_art"/>0</td>';
        }


        $cadena .= '<td>
        <label name="cantidad_label" id="cantidadsol' . $row . '"/>
        <input type="hidden" name="cantidad_label_[]" id="cant_la' . $row . '" value=""/>
        </td>';


        $cadena .= '<td><label name="cant_sol_label" class="label_cant" id="cantidadl' . $row . '"/>
        <input id="editarl' . $row . '" extras="." class="editar_cant soloNumeros" style="display:none;" value="' . $dri_cantidad . '"/>
        </td>';
        $cadena .= '<td>';

        if ($num_art == 1 || $dri_cantidad == 0) {
            $cadena .= '<button type="button" disabled id="remove" id_fila="' . $row . 'F' . $key['dri_id_art'] . '" class="remove  icomoon-icon-remove-5" style="width:35px;height:35px;" />';
        } else {
            $cadena .= '<button type="button" id="remove" id_fila="' . $row . 'F' . $key['dri_id_art'] . '" class="remove  icomoon-icon-remove-5" style="width:35px;height:35px;"/>';
        }

        if ($dri_cantidad == 0) {
            $cadena .= '<button type="button" disabled id="guardar" onmouseover="validarRangoCorrelativo_general();" id_fila="' . $row . 'F' . $key['dri_id_art'] . '" nombre_producto=' . $key['art_codigo'] . '-' . $key['art_nombre'] . ' id_producto=' . $key['dri_id_art'] . ' name="g' . $row . '" class="guardar icomoon-icon-disk"  style="width:35px;height:35px;display:none;"/>';

            $cadena .= '<button type="button" disabled id="editar" nombre_producto=' . $key['art_codigo'] . '-' . $key['art_nombre'] . ' id_producto=' . $key['dri_id_art'] . ' name="' . $row . '" class="editar  icomoon-icon-pencil-2" style="width:35px;height:35px;"/></td></tr>';
        } else {
            $cadena .= '<button type="button" id="guardar" onmouseover="validarRangoCorrelativo_general();" id_fila="' . $row . 'F' . $key['dri_id_art'] . '" nombre_producto=' . $key['art_codigo'] . '-' . $key['art_nombre'] . ' id_producto=' . $key['dri_id_art'] . ' name="g' . $row . '" class="guardar icomoon-icon-disk" style="width:35px;height:35px;display:none;"/>';

            $cadena .= '<button type="button" id="editar" nombre_producto=' . $key['art_codigo'] . '-' . $key['art_nombre'] . ' id_producto=' . $key['dri_id_art'] . ' name="' . $row . '" class="editar  icomoon-icon-pencil-2" style="width:35px;height:35px;"/></td></tr>';
        }
        $row++;
    }


    $arreglo = array(
        "drop" => $cadena,
        "count" => (((count(explode('tr', $cadena))) - 1) / 2),
        "bodega" => $articulos_rxi[0]['rxi_id_bod'],
    );

    echo json_encode($arreglo);
}

function get_articulos_rxi2() {
    $num_req = $this->input->post('id_req_sel');
    $articulos_rxi = $this->inventario_model->productos_requisicion_rxi($num_req);
        //$articulos_rxi = $this->consultas->cargar_req_moi($num_req);
    $cadena = '';
    $row = 0;

    foreach ($articulos_rxi as $key) {
        $cadena .= '<tr><td style="display:none;">' . $key['dri_id_art'] . '</td><td><input type="hidden" name="bodega[]" id="bodega" value="' . $key['rxi_id_bod'] . '"/>';
        $cadena .= '<input type="hidden" name="categoria[]" id="categoria" value="' . $key['tia_id'] . '"/>';
        $cadena .= '<input type="hidden" name="productos[]" id="productos" value="' . $key['dri_id_art'] . '"/>';
        $cadena .= '<input type="hidden" name="cantidad[]" id="cantidadi' . $row . '" value="' . $key['dri_cantidad'] . '"/>';

        $cadena .= '<label name="producto_label" id="productos"/>' . $key['art_nombre'] . '</td>';
            //$cadena.='<td><label name="cantidad_label" id="cantidadsol'.$row.'"/>'.$key['art_nombre'].'</td>';
        $cadena .= '<td><label name="cant_sol_label" id="cantidadl' . $row . '"/></td>';
        $cadena .= '<td><button type="button" id="remove" class="remove" style="width:35px;height:35px;"/>';
        $cadena .= '<button type="button" id="editar" name="' . $row . '" class="editar" style="width:35px;height:35px;"/></td><td style="display:none;">' . $key['dri_id_art'] . '</td></tr>';
        $row++;
        $val_bodega = $key['rxi_id_bod'];
    }

    $arreglo = array(
        "drop" => $cadena,
        "count" => (((count(explode('tr', $cadena))) - 1) / 2),
        "val_bodega" => $val_bodega
    );

    echo json_encode($arreglo);
}

public function ajustes_preparar() {
    parse_str($_POST['formulario'], $formSR);
    // var_dump($formSR);die();
    $bodega = $formSR['bodega'];
    $productos1 = $formSR['productos'];
    $cantidades = $formSR['cantidad'];
    $existencias = $formSR['existencia'];
    $descripcion = $formSR['descripcion'];
    $tipo_movimiento = $formSR['tipo_movimiento'];
    $efectuar_movimiento = $formSR['efectuar_movimiento'];
    $productos_id = $formSR['id_prod'];
    $aju_correlativo = number_format($this->gsatelite->get_max('aju_ajuste_inventario', 'aju_correlativo'), 0) + 1;
    $correlativo = str_pad($aju_correlativo, 5, '0', STR_PAD_LEFT);
    $ajuste = array(
        'aju_correlativo' => $correlativo, 
        'aju_usu_genera' => $this->tank_auth->get_user_id(),
        'aju_fecha_ajuste' => date('Y-m-d H:i:s'),
        'aju_estado' => 1,
        'aju_usu_creacion' => $this->tank_auth->get_user_id(),
        'aju_fecha_creacion' => date('Y-m-d H:i:s'),
        'aju_usu_modificacion' => $this->tank_auth->get_user_id(),
        'aju_fecha_modificacion' => date('Y-m-d H:i:s')
    );
    $id_aju = $this->gsatelite->ingresar('aju_ajuste_inventario', $ajuste);
    $formSR['id_aju'] = $id_aju;
    foreach ($productos1 as $k => $val) {
        if ($efectuar_movimiento[$k] > 0) {
            $detalle = array(
                'dea_id_aju' => $id_aju,
                'dea_id_art' => $productos_id[$k],
                'dea_cantidad_fisica' => $cantidades[$k],
                'dea_existencia' => $existencias[$k],
                'dea_tipo_operacion' => $tipo_movimiento[$k],
                'dea_procesado' => 1,
                'dea_estado' => 1,
                'dea_usu_creacion' => $this->tank_auth->get_user_id(),
                'dea_fecha_creacion' => date('Y-m-d H:i:s'),
                'dea_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dea_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $id_det = $this->gsatelite->ingresar('dea_detalle_ajuste_inv', $detalle);
        }
    }
    $ajuste_val = $this->crear_ajuste_movimiento($formSR);

    if ($ajuste_val == 1) {
        $arreglo = array("act" => '4');
    } else{
        $arreglo = array("act" => '5');
    }

    ob_end_clean();
    echo json_encode($arreglo);
    exit();die();

        $tipos_proceso = $this->inventario_model->cargar_registro('tip_tipo_proceso', 'tip_id', $proceso);
        $proc_entrada = $tipos_proceso['tip_tras_ent'];
        $proc_salida = $tipos_proceso['tip_tras_sal'];
        $entradas[0] = array(); //Array de productos en ENTRADAS
        $entradas[1] = array(); //Array de cantidades a proecesar en ENTRADAS
        $entradas[2] = array($bodega);
        $salidas[0] = array(); //Array de productos en SALIDAS
        $salidas[1] = array(); //Array de cantidades a procesar en SALIDAS
        $salidas[2] = array($bodega);
        foreach ($productos as $key => $valor) {//Recorriendo las productos
            if ($cantidades[$key] > $existencias[$key]) {//Si es una entrada al ser mayor la cantidad fisica
                $entradas[0] = array_merge($entradas[0], array($valor));
                $entradas[1] = array_merge($entradas[1], array($cantidades[$key] - $existencias[$key]));
            }
            if ($cantidades[$key] < $existencias[$key]) {//Si es una salida al ser menor la cantidad fisica
                $salidas[0] = array_merge($salidas[0], array($valor));
                $salidas[1] = array_merge($salidas[1], array($existencias[$key] - $cantidades[$key]));
            }
        }
        
        $res1 = 0; //Respuesta de ingresos
        $res2 = 0; //Respuesta de egresos
        if (count($entradas[0]) > 0) {
            //$res1=$this->ingresar_productos_movimiento('ajuste',$entradas,$proc_entrada,$descripcion);
            $res1 = $this->ingresar_productos_movimiento('ajuste', $entradas, $proceso, $descripcion);
        }
        if (count($salidas[0]) > 0) {
            //$res2=$this->salida_productos_movimiento('ajuste',$salidas,$proc_salida,$descripcion);
            $res2 = $this->salida_productos_movimiento('ajuste', $salidas, $proceso, $descripcion);
        }

        if ($res1 == 1 && $res2 == 1) {
            $arreglo = array("act" => '1');
        }
        if ($res1 == 0 && $res2 == 1) {
            $arreglo = array("act" => '2');
        }
        if ($res1 == 1 && $res2 == 0) {
            $arreglo = array("act" => '3');
        }
        if ($res1 == 0 && $res2 == 0) {
            $arreglo = array("act" => '4');
        }
        ob_end_clean();
        echo json_encode($arreglo);
    }

    public function crear_ajuste_movimiento($formulario){
        $fecha = date('Y-m-d H:i:s');
        $bodega = $formulario['bodega'];

        $productos_codigo = $formulario['productos']; //array
        $cantidades = $formulario['cantidad']; //array
        $existencias = $formulario['existencia']; //array
        $tipo_movimiento = $formulario['tipo_movimiento']; //array
        $efectuar_movimiento = $formulario['efectuar_movimiento']; //array
        $descripcion = $formulario['descripcion'];
        $proceso = $formulario['tipo_transaccion'];
        $id_ajuste = $formulario['id_aju'];
	
        $ingresar_movimiento = array(
            'moi_id_bod' => $bodega,
            'moi_id_tip' => $proceso,
            'moi_fecha_mov' => $fecha,
            'moi_id_aju' => $id_ajuste,
            'moi_usu_creacion' => $this->tank_auth->get_user_id(),
            'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
            'moi_fecha_creacion' => date('Y-m-d H:i:s'),
            'moi_fecha_modificacion' => date('Y-m-d H:i:s'),
            'moi_descripcion' => $descripcion
        );
        $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $ingresar_movimiento);
        //$productos = array();
        $contador_reg = 0;
        $contador_val = 0;
        foreach ($productos_codigo as $key => $id) {
            /*$id_producto = $this->db->select('art_id')->where('art_codigo', $id)->get('art_articulo')->result_array();
            array_push($productos, $id_producto[0]['art_id']);*/

            if($efectuar_movimiento[$key] == 1){

                $id_producto = $this->inventario_model->detalle_producto_ajuste(array('cva_defecto'=>1, 'art_codigo'=>$id), $bodega);
                $id_art = $id_producto[0]['art_id'];
                $cva_id = $id_producto[0]['cva_id'];

                $cantidad_maxima = $existencias[$key];
                $saldo = ($id_producto[0]['saldo'] != null)?$id_producto[0]['saldo']:0;
                if($tipo_movimiento[$key] != 1){                    
                    
                    $cantidad = (float)($existencias[$key] - $cantidades[$key]);
                    $ajuste_val = $this->peps_salida($id_art, null, $moi_id, $cva_id, $cantidad, '', $cantidad_maxima, $bodega);
                    $contador_val += $ajuste_val;
                } else{
                    $cantidad = (float)($cantidades[$key] - $existencias[$key]);
                    $ajuste_val = $this->crear_entrada_ajuste($id_art, $cva_id, $bodega, $cantidad, $saldo, $moi_id);
                    $contador_val += $ajuste_val;
                }
                $contador_reg++;
            }
        }
        $regresar = 0;
        if($contador_reg == $contador_val && $moi_id > 0){
            $regresar = 1;
        } else{
            $regresar = 0;
        }
        return $regresar;
    }

    public function crear_entrada_ajuste($articulo, $unidad_medida, $bodega, $cantidad, $precio, $moi_id){
        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
        if ($costo_promedio == 1) {
            $nuevo_precio =  $this->recalcular_precio_promedio($articulo, $bodega, $cantidad, $precio);
        }

        $saldos_articulo = array(
            'sar_id_art' => $articulo,
            'sar_id_bod' => $bodega,
            'sar_cant_actual' => $cantidad,
            'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $precio,
            'sar_estado' => 1,
            'sar_usu_creacion' => $this->tank_auth->get_user_id(),
            'sar_fecha_creacion' => date('Y-m-d H:i:s'),
            'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
            'sar_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $sar_id = $this->gsatelite->ingresar('sar_saldo_articulo', $saldos_articulo);
        $detalle_movimiento = array(
            'dee_id_moi' => $moi_id,
            'dee_id_art' => $articulo,
            'dee_id_sar' => $sar_id,
            'dee_id_cva' => $unidad_medida,
            'dee_cantidad' => $cantidad,
            'dee_precio' => $precio,
            'dee_subtotal' => ($cantidad*$precio),
            'dee_estado' => 1,
            'dee_usu_creacion' => $this->tank_auth->get_user_id(),
            'dee_fecha_creacion' => date('Y-m-d H:i:s'),
            'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
            'dee_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $dee_id = $this->gsatelite->ingresar('dee_detalle_mov', $detalle_movimiento);

        $regresar = 0;
        if($sar_id > 0 && $dee_id > 0){
            $regresar = 1;
        } else{
            $regresar = 0;
        }
        return $regresar;
    }

    public function ingresar_productos_movimiento($ajuste = null, $ingreso = null, $proc_entrada = null, $descript_ajuste = null) {
        //if ($_POST) { //Si se ha enviado valores de solicitud
        // print_r($_POST);
        // exit(); }

        $flag = 0; //Bandera de error
        $parametro = $_POST['parametro'];
        //variables de control (para guardar el id_del detalle y vincularlo con el correlativo indicado en el caso que aplique serie)
        $arregloIDtrProductos = $this->input->post('ids_filaP'); //este arreglo solo llevará los ids de los tr de todos los productos
        $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie


        if ($ajuste == null) {
            $entrada = $_POST['tipo_transaccion'];
            $usuario = $this->tank_auth->get_user_id();
            $bodega = $_POST['bodega'];
            $proveedor = $_POST['proveedor'];
            $fecha = date('Y-m-d h:i:s');
            $documento = $_POST['documento'];


            $descripcion = $_POST['descripcion_requisicion'];

            $caducidad = ($_POST['caducidad']);
            $productos = $_POST['productos'];
            $cantidades = $_POST['cantidad'];
            $retaceo = $_POST['retaceo'];

            if ($_POST['retaceo'] == '') {
                $precios = $_POST['precios'];
            } else {
                $precios = $_POST['precios1'];
            }

            $p1 = $_POST['p1'];
            $u1 = $_POST['u1'];
            $p2 = $_POST['p2'];
            $u2 = $_POST['u2'];
            $p3 = $_POST['p3'];
            $u3 = $_POST['u3'];
            $p4 = $_POST['p4'];
            $u4 = $_POST['u4'];
            $p5 = $_POST['p5'];
            $u5 = $_POST['u5'];
            $n1 = $_POST['nombre_precio1'];
            $n2 = $_POST['nombre_precio2'];
            $n3 = $_POST['nombre_precio3'];
            $n4 = $_POST['nombre_precio4'];
            $n5 = $_POST['nombre_precio5'];
            $caja = $_POST['caja'];
            $furgon = $_POST['furgon'];
            $cantxcaja = $_POST['cantxcaja'];
        } else {

            $entrada = $proc_entrada;

            $usuario = $this->tank_auth->get_user_id();
            $bodega = $ingreso[2][0];
            $fecha = date("Y-m-d H:i:s");
            $documento = '';
            $descripcion = $descript_ajuste;

            //$productos1 = $ingreso[0];
            $productos = $ingreso[0];
            $cantidades = $ingreso[1];

            $precios = array();


            foreach ($productos as $key => $id_prod) {//Conociendo los precios de cada producto
                //$id_prod=$this->db->select('art_id')->where('art_codigo',$id_prod)->get('art_articulo')->result_array();
                $saldos = $this->llamar_datos_row("sar_saldo_articulo", array('sar_id_art' => $productos[$key], 'sar_id_bod' => $bodega, 'sar_cant_actual !=' => '0'), 'sar_id ASC');

                if (count($saldos) > 0) {
                    $precios = array_merge($precios, array($saldos[0]['sar_precio']));
                } else {
                    $flag = 1;
                }
            }
            /* $productos=array();
              foreach ($productos1 as $key => $id) {
              $id_producto=$this->db->select('art_id')->where('art_codigo',$id)->get('art_articulo')->result_array();
              array_push($productos,$id_producto[0]['art_id']);
          } */
      }

      if ($flag == 0) {
            //en este punto se realizara la insercion del movimiento
        ( $proveedor == 0 ) ? $proveedor = NULL : $proveedor;
        if (!empty($retaceo)) {
            $ingresar_movimiento = array(
                'moi_retaceo' => $retaceo,
                'moi_id_bod' => $bodega,
                'moi_id_tip' => $entrada,
                'moi_documento' => $documento,
                'moi_fecha_mov' => $fecha,
                'moi_usu_modificacion' => $usuario,
                'moi_fecha_modificacion' => date('Y-m-d H:i:s'),
                'moi_descripcion' => $descripcion,
                'moi_id_prv' => $proveedor
            );
        } else {
            $ingresar_movimiento = array(
                'moi_id_bod' => $bodega,
                'moi_id_tip' => $entrada,
                'moi_documento' => $documento,
                'moi_fecha_mov' => $fecha,
                'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion' => date('Y-m-d H:i:s'),
                'moi_descripcion' => $descripcion,
                'moi_id_prv' => $proveedor
            );
        }

        $id_movimiento = $this->gsatelite->ingresar('moi_movimiento_inv', $ingresar_movimiento);


            //este bucle repetitivo nos servira para guardar todos los productos anexados a la compra
            $IDsMovimientos = array(); //este arreglo guardará todos los ids que se inserten
            foreach ($productos as $key => $id_prod) {
                $id_cant = $cantidades[$key];
                $id_precio = $precios[$key];
                $id_cantxcaja = $cantxcaja[$key];
                $id_caducidad = NULL;
                if (isset($caducidad)) {
                    if (!empty($caducidad[$key])) {
                        $id_caducidad = date('Y-m-d H:i:s', strtotime($caducidad[$key])); // date('Y-m-d h:i:s', strtotime($_POST['caducidad']));
                    }
                }
                if (isset($caja)) {
                    $id_caja = $caja[$key];
                }

                if (isset($furgon)) {
                    $id_furgon = $furgon[$key];
                }

                if (isset($p1)) {
                    $id_precio_venta1 = $p1[$key];
                }
                if (isset($u1)) {
                    $id_unidad_medida1 = $u1[$key];
                }

                if (isset($p2)) {
                    $id_precio_venta2 = $p2[$key];
                }

                if (isset($u2)) {
                    $id_unidad_medida2 = $u2[$key];
                }

                if (isset($p3)) {
                    $id_precio_venta3 = $p3[$key];
                }
                if (isset($u3)) {
                    $id_unidad_medida3 = $u3[$key];
                }
                if (isset($p4)) {
                    $id_precio_venta4 = $p4[$key];
                }
                if (isset($u4)) {
                    $id_unidad_medida4 = $u4[$key];
                }
                if (isset($p5)) {
                    $id_precio_venta5 = $p5[$key];
                }
                if (isset($u5)) {
                    $id_unidad_medida5 = $u5[$key];
                }
                if (isset($n1)) {
                    $id_nombre_precio1 = $n1[$key];
                }
                if (isset($n2)) {
                    $id_nombre_precio2 = $n2[$key];
                }
                if (isset($n3)) {
                    $id_nombre_precio3 = $n3[$key];
                }
                if (isset($n4)) {
                    $id_nombre_precio4 = $n4[$key];
                }
                if (isset($n5)) {
                    $id_nombre_precio5 = $n5[$key];
                }




                if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 0) {
                    $ingresar_saldo = array(
                        'sar_id_art' => $id_prod,
                        'sar_id_bod' => $bodega,
                        'sar_cant_actual' => $id_cant,
                        'sar_precio' => $id_precio,
                        'sar_fecha_caducidad' => $id_caducidad,
                        'sar_usu_mod' => $this->tank_auth->get_user_id(),
                        'sar_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $id_saldo = $this->gsatelite->ingresar('sar_saldo_articulo', $ingresar_saldo);
                } else {
                    $saldo_actual = $this->db->select()
                    ->from('sar_saldo_articulo')
                    ->where('sar_id_art', $id_prod)
                    ->where('sar_id_bod', $bodega)
                    ->get()->result_array();

                    if (empty($saldo_actual)) {
                        $precio_actual = 0;
                        $sar_cant_actual = 0;
                    } else {
                        $sar_cant_actual = $saldo_actual[0]['sar_cant_actual'];
                        $precio_actual = ($saldo_actual[0]['sar_cant_actual']) * ($saldo_actual[0]['sar_precio']);
                    }

                    $precio_entrada = $id_cant * $id_precio;
                    $cantidad_existencia = $sar_cant_actual + ($id_cant);
                    $suma_precios = $precio_actual + $precio_entrada;
                    $nuevo_precio = $suma_precios / $cantidad_existencia;

                    $ingresar_saldo = array(
                        'sar_id_art' => $id_prod,
                        'sar_id_bod' => $bodega,
                        'sar_cant_actual' => $cantidad_existencia,
                        'sar_precio' => $nuevo_precio,
                        'sar_fecha_caducidad' => null,
                        'sar_usu_mod' => $this->tank_auth->get_user_id(),
                        'sar_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    if (empty($saldo_actual)) {
                        $id_saldo = $this->gsatelite->ingresar('sar_saldo_articulo', $ingresar_saldo);
                    } else {
                        $id_saldo1 = $this->db->where('sar_id', $saldo_actual[0]['sar_id'])->update('sar_saldo_articulo', $ingresar_saldo);
                        $id_saldo = $saldo_actual[0]['sar_id'];
                    }
                }

                if ($ajuste == null && $parametro != 0) {
                    $ingresar_ixc = array(
                        'ixc_cantidad_caja' => $id_cantxcaja,
                        'ixc_contenedor' => $id_furgon,
                        'ixc_caja' => $id_caja,
                        'ixc_cantidad_actual' => $id_cant);
                    $id_ixc = $this->gsatelite->ingresar('ixc_ingresoxcontenedor', $ingresar_ixc);
                }



                $ingresar_detalle = array(
                    'dee_id_ixc' => $id_ixc,
                    'dee_id_moi' => $id_movimiento,
                    'dee_id_art' => $id_prod,
                    'dee_id_sar' => $id_saldo,
                    'dee_cantidad' => $id_cant,
                    'dee_precio' => $id_precio,
                    'dee_usr_mod' => $usuario,
                    'dee_fecha_mod' => date('Y-m-d h:i:s')
                );

                $id_detalle = $this->gsatelite->ingresar('dee_detalle_mov', $ingresar_detalle);
                $id_filaUnico = $arregloIDtrProductos[$key] . 'S'; //variable de control (indice del arreglo-que concuerdará con el id del tr de las series. y poder llevar el id del detalle correctamente)
                $IDsMovimientos["$id_filaUnico"] = $id_detalle;
                if ($this->gsatelite->get_parametro('SYS_LISTADO_PRECIO') == '1') {
                    if (!empty($id_precio_venta1) && !empty($id_unidad_medida1) && !empty($id_nombre_precio1)) {

                        $ingresar_precios1 = array('pdv_id_sar' => $id_saldo,
                            'pdv_precio' => $id_precio_venta1,
                            'pdv_id_mep' => $id_unidad_medida1,
                            'pdv_nombre' => $id_nombre_precio1);
                        $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios1);
                    }
                    if (!empty($id_precio_venta2) && !empty($id_unidad_medida2) && !empty($id_nombre_precio2)) {
                        $ingresar_precios2 = array('pdv_id_sar' => $id_saldo,
                            'pdv_precio' => $id_precio_venta2,
                            'pdv_id_mep' => $id_unidad_medida2,
                            'pdv_nombre' => $id_nombre_precio2);
                        $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios2);
                    }
                    if (!empty($id_precio_venta3) && !empty($id_unidad_medida3) && !empty($id_nombre_precio3)) {
                        $ingresar_precios3 = array('pdv_id_sar' => $id_saldo,
                            'pdv_precio' => $id_precio_venta3,
                            'pdv_id_mep' => $id_unidad_medida3,
                            'pdv_nombre' => $id_nombre_precio3);
                        $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios3);
                    }
                    if (!empty($id_precio_venta4) && !empty($id_unidad_medida4) && !empty($id_nombre_precio4)) {
                        $ingresar_precios4 = array('pdv_id_sar' => $id_saldo,
                            'pdv_precio' => $id_precio_venta4,
                            'pdv_id_mep' => $id_unidad_medida4,
                            'pdv_nombre' => $id_nombre_precio4);
                        $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios4);
                    }
                    if (!empty($id_precio_venta5) && !empty($id_unidad_medida5) && !empty($id_nombre_precio5)) {
                        $ingresar_precios5 = array('pdv_id_sar' => $id_saldo,
                            'pdv_precio' => $id_precio_venta5,
                            'pdv_id_mep' => $id_unidad_medida5,
                            'pdv_nombre' => $id_nombre_precio5);
                        $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios5);
                    }
                }
            }//end foreach
        }

        //REALIZAR EL INSERT DE LAS SERIES EN LOS PRODUCTOS A CUALES SE LES HA APLICADO.
        $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie
        $idsDetalles = $IDsMovimientos;

        $ids_productos = $this->input->post('producto_serie');
        $nom_series = $this->input->post('nombre_serie');
        $ini_correlativo = $this->input->post('iniC_serie');
        $fin_correlativo = $this->input->post('finC_serie');
        if (count($ids_productos) > 0) {
            for ($i = 0; $i < count($ids_productos); $i++) {
                if ($ids_productos[$i] > 0) { //condicionar que sea un id valido.
                    //preguntar por el id del detalle correcto
                    $id_filaUnicoS = $arregloIDtrProductosSeries[$i];
                    $idMovimientoSerie = $idsDetalles[$id_filaUnicoS]; //hacer referencia al key correcto.
                    $insert_serie = array(
                        'ser_id_art' => $ids_productos[$i]
                        , 'ser_nombre' => trim($nom_series[$i])
                        , 'ser_estado' => 1
                        , 'ser_fecha_mod' => date('Y-m-d H:i:s')
                        , 'ser_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_serie = $this->gsatelite->ingresar('ser_serie', $insert_serie); //insertar la serie

                    $insert_correlativo = array(
                        'cor_id_ser' => $id_serie
                        , 'cor_tipo' => 1
                        , 'cor_inicio' => $ini_correlativo[$i]
                        , 'cor_fin' => $fin_correlativo[$i]
                        , 'cor_estado' => 1
                        , 'cor_id_dee' => $idMovimientoSerie
                        , 'cor_usu_mod' => $this->tank_auth->get_user_id()
                        , 'cor_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $id_correlativo = $this->gsatelite->ingresar('cor_correlativo', $insert_correlativo); //insertar del correlativo
                }
            }
        }
        //FIN DEL SCRIPT QUE INSERTA LAS SERIES Y CORRELATIVOS
        if ($ajuste == null) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Entrada de artículos", 'texto_alerta' => "El registro se guardó correctamente");

            $this->session->set_flashdata($alerta);
            redirect('/inventario/gestion_productos/entrada_productos');
        } else {
            /* print_r($flag);
            exit(); */
            return $flag;
        }
        //}
    }

    public function salida_productos_movimiento($ajuste = null, $egreso = null, $proc_salida = null, $descript_ajuste = null) {
        $flag = 0;
        //Definicion de campos de una requisicion

        $access_moi = 0;
        //Bandera para especificar si se realizara al menos un movimiento, si alguna cantidad es diferente de cero.
        //variables de control (para guardar el id_del detalle y vincularlo con el correlativo indicado en el caso que aplique serie)
        $arregloIDtrProductos = $this->input->post('ids_filaP'); //este arreglo solo llevará los ids de los tr de todos los productos
        $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie

        if ($ajuste == null) {
            //Campos generales
            $salida = $_POST['tipo_transaccion'];
            $requisicionxi = $_POST['requisicionxi'];
            $usuario = $this->tank_auth->get_user_id();
            $descripcion_moi = $_POST['descripcion_moi'];
            $fecha = date('Y-m-d h:i:s', strtotime($_POST['fec']));
            $documento = $_POST['documento'];
            $bodega = $_POST['bodega'][0];
            $productos = $_POST['productos'];
            $cantidades = $_POST['cantidad'];
            $ixc = $_POST['ixc_detail'];
            $id_sar = $_POST['sar_saldo'];
            // $ser=$_POST['nombre_serie'];

            $productos_depurado = array();
            $cantidades_depurado = array();
            // var_dump($productos); exit();
            foreach ($productos as $key => $valor) {
                if ($cantidades[$key] != 0) {
                    $productos_depurado = array_merge($productos_depurado, array($valor));
                    $cantidades_depurado = array_merge($cantidades_depurado, array($cantidades[$key]));
                    $access_moi = 1;
                }
            }

            $productos = $productos_depurado;
            $cantidades = $cantidades_depurado;
        } else {
            $salida = $proc_salida;
            $usuario = $this->tank_auth->get_user_id();
            $descripcion_moi = $descript_ajuste;
            $fecha = date("Y-m-d h:i:s");
            $bodega = $egreso[2][0];
            $productos = $egreso[0];
            $cantidades = $egreso[1];
            $access_moi = 1;
            /* $productos=array();
              foreach ($productos1 as $key => $id) {
              $id_producto=$this->db->select('art_id')->where('art_codigo',$id)->get('art_articulo')->result_array();
              array_push($productos,$id_producto[0]['art_id']);
          } */
      }

        if ($access_moi == 1) { //Si al menos se va a procesar un producto
            //Preparando variables para movimiento de salida
            $egresar_movimiento = array(
                'moi_id_bod' => $bodega,
                'moi_id_tip' => $salida,
                'moi_fecha_mov' => $fecha,
                'moi_usu_modificacion' => $usuario,
                'moi_fecha_modificacion' => date('Y-m-d h:i:s'),
                'moi_descripcion' => $descripcion_moi,
                'moi_documento' => $documento
            );


            $id_movimiento = $this->gsatelite->ingresar('moi_movimiento_inv', $egresar_movimiento);
            //Se ingresa un movimiento de salida

            $IDsMovimientos = array(); //este arreglo guardará todos los ids que se inserten del movimiento

            foreach ($productos as $key => $id_prod) {

                //$saldos=$this->llamar_datos_row("sar_saldo_articulo",array('sar_id_art'=>$productos[$key],'sar_id_bod'=>$bodega,'sar_id'=>$id_sar[$key],'sar_cant_actual !='=>0),'sar_id ASC');
                $saldos = $this->llamar_datos_row("sar_saldo_articulo", array('sar_id_art' => $productos[$key], 'sar_id_bod' => $bodega, 'sar_cant_actual !=' => 0), 'sar_id ASC');
                //  die(print_r($this->db->last_query()));
                //die(var_dump($saldos));
                if (count($saldos) > 0) {
                    $puntero = 0;           //Inicia consulta de saldos
                    $final = count($saldos) - 1; //Limite de consulta de saldos
                    $cant_solicitada = $cantidades[$key];
                    $ixc_id = $ixc[$key];
                    $id_filaUnico = $arregloIDtrProductos[$key] . 'S'; //variable de control (indice del arreglo-que concuerdará con el id del tr de las series. y poder llevar el id del detalle correctamente)
                    //Funcion recursiva hasta acabar el pedido o cantidad=0
                    do {
                        $cant_restador = $this->procesar_saldos($usuario, $id_movimiento, $cant_solicitada, $saldos[$puntero], $ixc_id);
                        $cant_solicitada = $cant_solicitada - $cant_restador[0];
                        $IDsMovimientos["$id_filaUnico"] = $cant_restador[1]; // la variable $cant_restador es un arreglo y en su posicion 1 trae el id del detalle insertado.
                        $puntero++;
                    } while (($puntero <= $final) && ($cant_solicitada > 0));
                } else {
                    $flag = 1;
                }
            }
        }


        if (isset($requisicionxi)) {
            if ($requisicionxi != 'ini') {
                //Si es una salida por requisicion
                //Alterar la cantidad que realmente se despacho de la requisicion

                $productos = $_POST['productos'];
                $cantidades = $_POST['cantidad'];
                //Volviendo a leer los productos que se definieron del post, para procesar detalles de requisicion con valor cero!

                foreach ($productos as $key => $id_prod_dri) {
                    $cant_despachada = $this->db->where(array('dri_id_rxi' => $requisicionxi, 'dri_id_art' => $id_prod_dri))->get('dri_detalle_requisicion_inventario')->result_array();

                    $cant_dri = $cantidades[$key] + $cant_despachada[0]['dri_cantidad_despacho'];

                    if ($cant_despachada[0]['dri_cantidad'] >= $cant_dri) {
                        //$incompletos++;
                        $detalle_req = array(
                            'dri_cantidad_despacho' => convertirFloat($cant_dri)
                        );

                        $condiciones = array(
                            'dri_id_rxi' => $requisicionxi,
                            'dri_id_art' => $id_prod_dri
                        );

                        $this->gsatelite->actualizar_array('dri_detalle_requisicion_inventario', $detalle_req, $condiciones);
                    }
                $cant_despachada_ = $this->db->where(array('dri_id_rxi' => $requisicionxi /* ,'dri_id_art'  =>$id_prod_dri */))->get('dri_detalle_requisicion_inventario')->result_array();
                $total_movi = count($cant_despachada_);

                $a = 0;
                $incompletos = 0;
                foreach ($cant_despachada_ as $cant_des) {
                    if ($cant_des['dri_cantidad'] == $cant_des['dri_cantidad_despacho']) {
                        $incompletos++;
                    } else {
                        $incompletos;
                    }
                    $a++;
                }
                    //   if ($cant_despachada_[0]['dri_cantidad'] != $cant_despachada_[0]['dri_cantidad_despacho']) {$incompletos++;}
            }
            if ($incompletos == $total_movi) {
                $estado_req = 0;
            } else {
                $estado_req = 3;
            }

                //Alterar estado de requisicion y agregar el movimiento que se realizo
            $actualizar_rxi = array(
                'rxi_estado' => $estado_req,
                'rxi_id_moi' => $id_movimiento
            );

            $this->gsatelite->actualizar('rxi_requisicion_inventario', $actualizar_rxi, 'rxi_id', $requisicionxi);
        } else {
                //Si es una salida normal
                //El movimiento ya se completo
        }
    }

        //REALIZAR los insert de los correlativos

        $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie
        $idsDetalles = $IDsMovimientos;

        $ids_productos = $this->input->post('producto_serie');
        $nom_series = $this->input->post('nombre_serie');
        $ini_correlativo = $this->input->post('iniC_serie');
        $fin_correlativo = $this->input->post('finC_serie');
        if (count($ids_productos) > 0) {
            for ($i = 0; $i < count($ids_productos); $i++) {
                if ($nom_series[$i] > 0) { //condicionar que sea un id valido.
                    $id_serie = $nom_series[$i];
                    //preguntar por el id del detalle correcto
                    $id_filaUnicoS = $arregloIDtrProductosSeries[$i];
                    $idMovimientoSerie = $idsDetalles[$id_filaUnicoS]; //hacer referencia al key correcto.
                    $insert_correlativo = array(
                        'cor_id_ser' => $id_serie
                        , 'cor_tipo' => 2
                        , 'cor_inicio' => $ini_correlativo[$i]
                        , 'cor_fin' => $fin_correlativo[$i]
                        , 'cor_estado' => 1
                        , 'cor_id_dee' => $idMovimientoSerie
                        , 'cor_usu_mod' => $this->tank_auth->get_user_id()
                        , 'cor_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $id_correlativo = $this->gsatelite->ingresar('cor_correlativo', $insert_correlativo); //insertar del correlativo
                }
            }
        }
        //FIN DEL SCRIPT QUE INSERTA LAS SERIES Y CORRELATIVOS


        if ($ajuste == null) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Salida de artículos", 'texto_alerta' => "El registro se guardó correctamente");

            $this->session->set_flashdata($alerta);

            redirect('/inventario/gestion_productos/salida_productos');
        } else {
            return $flag;
        }
        //}
    }

    function llamar_datos_row($tabla, $where, $order) {
        $query = $this->inventario_model->cargar_todo($tabla, $where, $order);
        return $query;
    }

    function procesar_saldos($user, $id_mov, $cant_solic, $saldo_row, $ixc_id = null) {

        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $saldo_ixc = $this->db->select('ixc_cantidad_actual')->from('ixc_ingresoxcontenedor')->where('ixc_id', $ixc_id)->get()->result_array();
        }

        $cant_fila = $saldo_row['sar_cant_actual'];
        //Cantidad de productos segun PEPS actual

        $restador = null;
        //Cantidad de elementos restantes por procesar
        //die(print_r($cant_fila+'*'+$cant_solic));
        if ($cant_solic <= $cant_fila) {
            //Si hay suficientes elementos en la fila actual
            $restador = $cant_solic;
            $this->gsatelite->actualizar('sar_saldo_articulo', array('sar_cant_actual' => ($cant_fila - $cant_solic)), 'sar_id', $saldo_row['sar_id']);
            //Actualizando el saldo del articulo para la fila especifica
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $this->gsatelite->actualizar('ixc_ingresoxcontenedor', array('ixc_cantidad_actual' => ($saldo_ixc[0]['ixc_cantidad_actual'] - $cant_solic)), 'ixc_id', $ixc_id);
            }
        }

        if ($cant_solic > $cant_fila) {
            //Si no hay suficientes elementos en la fila
            $restador = $cant_fila;

            $this->gsatelite->actualizar('sar_saldo_articulo', array('sar_cant_actual' => 0), 'sar_id', $saldo_row['sar_id']);
            //Actualizando el saldo del articulo para la fila especifica
        }
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') == 0) {
            $ixc_id = null;
        }


        $ingresar_detalle = array(
            'dee_id_ixc' => $ixc_id,
            'dee_id_moi' => $id_mov,
            'dee_id_art' => $saldo_row['sar_id_art'],
            'dee_id_sar' => $saldo_row['sar_id'],
            'dee_cantidad' => $restador,
            'dee_precio' => $saldo_row['sar_precio'],
            'dee_usr_mod' => $user,
            'dee_fecha_mod' => date('Y-m-d h:i:s')
        );
        //die(print_r($ingresar_detalle));

        $id_detalle_m = $this->gsatelite->ingresar('dee_detalle_mov', $ingresar_detalle);

        //Ingresando un nuevo detalle para el movimiento de salida actual

        return array($restador, $id_detalle_m);
    }

    function comprobar_cantidades() {

        parse_str($_POST['formulario'], $formSR);
        //die(var_dump($formSR));
        $productos = $formSR['productos'];
        $bodegas = $formSR['bodega'];
        $cantidades = $formSR['cantidad'];

        //print_r($formSR);
        $arreglo = array();
        $counter = 0;

        foreach ($productos as $key => $id_prod_SR) {
            $campos = "SUM(sar_cant_actual) as existencia,art_nombre as nombre";
            $this->db->select($campos);
            $this->db->from('sar_saldo_articulo');
            $this->db->join('art_articulo', 'sar_id_art=art_id');
            $this->db->where('sar_id_art', $id_prod_SR);
            $this->db->where('sar_id_bod', $bodegas[$key]);
            $this->db->group_by("art_nombre");

            $query2 = $this->db->get();
            $query2 = $query2->row_array();
            //die(var_dump($this->db->last_query()));
            print_r($cantidades[$key] . '-' . $query2['existencia']);

            if ($cantidades[$key] > $query2['existencia']) {
                $arreglo[$counter] = array("nombre" => $query2['nombre'], "existencia" => $query2['existencia']);
                $counter++;
            }
        }
        //print_r($arreglo);

        ob_end_clean();
        //Limmpia los datos basura

        echo json_encode($arreglo);
    }

    function realizar_asignacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $solicitud = $this->input->get('identificador');
            $obtener_bodega = $this->inventario_model->cargar_registros('rxi_requisicion_inventario', 'rxi_id', $solicitud);
            $data['bodega'] = $obtener_bodega[0]['rxi_id_bod'];
            $data['detalles'] = $this->inventario_model->detalle_requisicion_inventario($solicitud);
            $data['solicitud'] = $solicitud;
            $this->_cargarvista(null, $data);
        }
    }

    public function llena_localidades() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';

        $provincia = $this->input->post('provincia');
        $table = 'art_articulo';
        $campo = 'art_id_bodega';
        $localidades = $this->inventario_model->cargar_productos_bodega($provincia);
        foreach ($localidades as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "'>" . $fila['art_nombre'] . "</option>";
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

//end of fucntion llena_localidades

    function mostrar_empleados() {
        $options = "";
        $var = '<option value="">Seleccione un empleado</option>';
        $area = $this->input->post('id_area');
        $mostrar_empleados = $this->inventario_model->asignacion_empleado_inventario($area);
        foreach ($mostrar_empleados as $empleados_area) {
            $var .= "<option value='" . $empleados_area['id'] . "'>" . $empleados_area['username'] . '-' . $empleados_area['are_nombre'] . "</option>";
        }
        $arreglo = array("drop" => $var,);
        echo json_encode($arreglo);
    }

    public function llenar_Series() {
        $options = "";
        $var = "<option value='0'>seleccione una opción</option>";
        if ($this->input->post('provincia')) {
            $valores = $this->inventario_model->cargar_registros('ser_serie', 'ser_id_art', $this->input->post('provincia'));
            foreach ($valores as $fila) {

                $var .= "<option value='" . $fila['ser_id'] . "'>" . $fila['ser_nombre'] . "</option>";
            }

            $variable = "asasas";
            $arreglo = array(
                "drop" => $var,
                "text" => $variable
            );

            echo json_encode($arreglo);
        }
    }

    function mostrar_correlativos() {
        $bodega = $this->input->post('bodega');
        $articulo = $this->input->post('articulo');
        $serie = $this->input->post('serie');
        $solicitados = $this->input->post('solicitados');
        $correlativos_disponibles = $this->inventario_model->obtener_correlativos($bodega, $articulo, $serie, $solicitados);
        if (isset($correlativos_disponibles[0]['cor_numero'])) {
            $valores = array(
                "iniciales" => $correlativos_disponibles[0]['cor_numero'],
                "finales" => $correlativos_disponibles[$solicitados - 1]['cor_numero']
            );
        } else {
            $valores = array(
                "iniciales" => 0,
                "finales" => 0
            );
        }
        echo json_encode($valores);
    }

    function mostrar_correlativos_alt() {
        $bodega = $this->input->post('bodega');
        $articulo = $this->input->post('articulo');
        $serie = $this->input->post('serie');
        $solicitados = $this->input->post('solicitados');
        $correlativos_disponibles = $this->inventario_model->obtener_correlativos2($bodega, $articulo, $serie, $solicitados);
        if (isset($correlativos_disponibles[0]['cor_numero'])) {
            $valores = array(
                "iniciales" => $correlativos_disponibles[0]['cor_numero'],
                "finales" => $correlativos_disponibles[$solicitados - 1]['cor_numero']
            );
        } else {
            $valores = array(
                "iniciales" => 0,
                "finales" => 0
            );
        }
        echo json_encode($valores);
    }

    public function comprobar_existencias() {
        $cantidad_extraes = $this->input->post('cantidad');
        $articulo_seleccionado = $this->input->post('articulo');
        $bodega = $this->input->post('bodega');
        $existencias_base = $this->inventario_model->comprobar_existencias($articulo_seleccionado, $bodega);

        if ($articulo_seleccionado == "") {
            echo "debe seleccionar un producto";
        } else {
            if ($existencias_base['existencias'] >= $cantidad_extraes) {
                echo "Hay suficientes exitencias \n  total de existencias : " . $existencias_base['existencias'];
            }//end if
            else {
                echo "No hay suficientes artículos \n total de existencias : " . $existencias_base['existencias'];
            }
        }
    }

    public function proceso_asignar_trasladar_articulos() { //Revisar los traslados
        /* print_r($_POST);
        exit(); */
        $requisicion = $this->input->post('requisicion');
        $tipo_proceso = $this->input->post('proceso');
        $detalle_salida = $this->input->post('tabla');
        $bodega = $this->input->post('bodega');
        $descripcion = $this->input->post('descripcion');
        $proceso = $this->input->post('tipo_tr');
        $fecha_base = date('Y-m-d', strtotime($this->input->post('fecha'))) . ' ' . date('H:i:s');
        $parametro = $this->input->post('parametro');




        $tipos_proceso = $this->inventario_model->cargar_registro('tip_tipo_proceso', 'tip_id', $proceso);

        $proc_entrada = $tipos_proceso['tip_id_tip_entrada'];
        $proc_salida = $tipos_proceso['tip_id_tip_salida'];
        $data = true;

        $bodega = $this->input->post('bodega');
        $destino = $this->input->post('bodega_destino');
        if ($bodega == $destino) {
            $data = true;
        } else {
            //Para un traslado, la requisicion que moi guardara, si es el caso?

            $arreglo_movimiento = array(
                'moi_id_bod' => $bodega,
                'moi_id_tip' => $proc_salida,
                'moi_descripcion' => $descripcion,
                'moi_fecha_mov' => $fecha_base,
                'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion' => $fecha_base
            );

            $id_movimiento_salida = $this->gsatelite->ingresar('moi_movimiento_inv', $arreglo_movimiento);

            $arreglo_entrada_traslado = array(
                'moi_id_bod' => $this->input->post('bodega_destino'),
                'moi_id_tip' => $proc_entrada,
                'moi_descripcion' => $descripcion,
                'moi_fecha_mov' => $fecha_base,
                'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion' => $fecha_base
            );

            $id_movimiento_entrada = $this->gsatelite->ingresar('moi_movimiento_inv', $arreglo_entrada_traslado);

            $arreglo_traslado = array(
                'tra_id_moi_sal' => $id_movimiento_salida,
                'tra_id_moi_ent' => $id_movimiento_entrada,
                'tra_descripcion' => $descripcion,
                'tra_id_tip' => $proceso
            );

            $insertar_traslado = $this->gsatelite->ingresar('tra_translado', $arreglo_traslado);
            //echo "1";
            //print_r($detalle_salida);
            //exit();
            foreach ($detalle_salida as $ingresar_base) {
                //echo "2";
                /* print_r($ingresar_base);
                exit(); */
                $ixc_id = $ingresar_base['ixc_detail'];
                $saldo_ixc = $this->db->select('ixc_cantidad_actual')->from('ixc_ingresoxcontenedor')->where('ixc_id', $ixc_id)->get()->result_array();
                $salida = $ingresar_base['cantidad'];
                $total_existencias = $this->inventario_model->comprobar_existencias($ingresar_base['id'], $this->input->post('bodega'));
                //print_r($total_existencias);
                //print_r('cantidad'.$ingresar_base['cantidad']);

                if ($total_existencias['existencias'] >= $ingresar_base['cantidad']) {
                    //echo "3";
                    while ($salida > 0) {
                        //echo "4";
                        $compras = $this->inventario_model->cargar_articulos($bodega, $ingresar_base['id']);
                        $saldo = $compras['sar_cant_actual'];
                        $operar_saldo = $saldo - $salida;

                        if ($operar_saldo > 0) {
                            $arreglo_modificar_cantidad_compra = array('sar_cant_actual' => $operar_saldo);
                            $id_compra = $compras['identificador'];
                            $tabla = 'sar_saldo_articulo';
                            $campo = 'sar_id';

                            $this->gsatelite->actualizar($tabla, $arreglo_modificar_cantidad_compra, $campo, $id_compra);
                            //$this->gsatelite->actualizar('ixc_ingresoxcontenedor',array('ixc_cantidad_actual'=>($saldo_ixc[0]['ixc_cantidad_actual']-$salida)),'ixc_id',$ixc_id);

                            $campo_salida = $salida;
                        }

                        if ($operar_saldo <= 0) {
                            $arreglo_actualizar_cero = array('sar_cant_actual' => 0);
                            $llave_compra = $compras['identificador'];
                            $table = 'sar_saldo_articulo';
                            $tupla = 'sar_id';
                            $this->gsatelite->actualizar($table, $arreglo_actualizar_cero, $tupla, $llave_compra);
                            //$this->gsatelite->actualizar('ixc_ingresoxcontenedor',array('ixc_cantidad_actual'=>($saldo_ixc[0]['ixc_cantidad_actual']-$salida)),'ixc_id',$ixc_id);
                            $campo_salida = $saldo;
                        }

                        $salida = $salida - $saldo;

                        //Detalle de movimiento de salida
                        $arreglo_detalle = array(
                            //'dee_id_ixc'      => $ixc_id,
                            'dee_id_moi' => $id_movimiento_salida,
                            'dee_id_art' => $ingresar_base['id'],
                            'dee_id_sar' => $compras['identificador'],
                            'dee_cantidad' => $campo_salida,
                            'dee_precio' => $compras['sar_precio'],
                            'dee_usr_mod' => $this->tank_auth->get_user_id(),
                            'dee_fecha_mod' => $fecha_base
                        );

                        $this->gsatelite->ingresar('dee_detalle_mov', $arreglo_detalle);

                        //Detalle de salgo de entrada a destno
                        $arreglo_insertar_productos = array(
                            'sar_id_art' => $ingresar_base['id'],
                            'sar_id_bod' => $this->input->post('bodega_destino'),
                            'sar_cant_actual' => $ingresar_base['cantidad'],
                            'sar_precio' => $compras['sar_precio'],
                            'sar_fecha_caducidad' => null,
                            'sar_usu_mod' => $this->tank_auth->get_user_id(),
                            'sar_fecha_mod' => date('Y-m-d H:i:s')
                        );

                        $saldo_ent_bod = $this->gsatelite->ingresar('sar_saldo_articulo', $arreglo_insertar_productos);

                        //
                        //     $get_caja_furgon_del_que_sale = $saldo_ixc=$this->db->select()->from('ixc_ingresoxcontenedor')->where('ixc_id',$ixc_id)->get()->result_array();

                        /*         $ingresar_ixc = array(
                          'ixc_contenedor'      => $get_caja_furgon_del_que_sale[0]['ixc_contenedor'],
                          'ixc_caja'            => $get_caja_furgon_del_que_sale[0]['ixc_caja'],
                          'ixc_cantidad_actual' => $campo_salida);
                          $id_ixc = $this->gsatelite->ingresar('ixc_ingresoxcontenedor',$ingresar_ixc);
                         */
                          $ixc = $ingresar_base['ixc'];
                          if ($parametro != 0) {
                            $arreglo_detalle = array(
                                'dee_id_ixc' => $ixc_id,
                                'dee_id_moi' => $id_movimiento_entrada,
                                'dee_id_art' => $ingresar_base['id'],
                                'dee_id_sar' => $saldo_ent_bod,
                                'dee_cantidad' => $campo_salida,
                                'dee_precio' => $compras['sar_precio'],
                                'dee_usr_mod' => $this->tank_auth->get_user_id(),
                                'dee_fecha_mod' => date('Y-m-d h:i:s'),
                            );
                        } else {
                            $arreglo_detalle = array(
                                //'dee_id_ixc'      => $ixc_id,
                                'dee_id_moi' => $id_movimiento_entrada,
                                'dee_id_art' => $ingresar_base['id'],
                                'dee_id_sar' => $saldo_ent_bod,
                                'dee_cantidad' => $campo_salida,
                                'dee_precio' => $compras['sar_precio'],
                                'dee_usr_mod' => $this->tank_auth->get_user_id(),
                                'dee_fecha_mod' => date('Y-m-d h:i:s'),
                            );
                        }


                        $this->gsatelite->ingresar('dee_detalle_mov', $arreglo_detalle);
                    }//end while

                    $actualizar_rxi = array(
                        'rxi_estado' => 0
                    );

                    $this->gsatelite->actualizar('rxi_requisicion_inventario', $actualizar_rxi, 'rxi_id', $requisicion);


                    $data = false;
                }//end if
                else {
                    echo "Ocurrio un error";
                }
            }//end foreach
        }
        //exit();

        if ($data == true) {
            /* $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Traslado de artículos",'texto_alerta'=>"No se permite el traslado hacia la misma bodega");
            $this->session->set_flashdata($alerta); */
            ob_end_clean();
            echo json_encode($data);
        } elseif ($data == false) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Traslado de artículos", 'texto_alerta' => "Proceso realizado con éxito");
            $this->session->set_flashdata($alerta);
            //$this->load->view('/inventario/gestion_productos/cargar_salida');
            $data = false;
            ob_end_clean();
            echo json_encode($data);
        }
    }

//fin de metodo para realizar metodos contables de peps y costo promedio

    public function cargar_salida($consulta = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/gestion_productos/cargar_salida');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;

                    $tipo_entrada = $post_array['estado'];
                    $fecha_inicio = $post_array['fecha_ini'];
                    $fecha_fin = $post_array['fecha_fin'];

                    $where = null;

                    if ($tipo_entrada) {
                        $where['tra_id_tip'] = $tipo_entrada;
                    }
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['date_format(tra_fecha_translado, "%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['date_format(tra_fecha_translado, "%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                    }

                    $traslado = $this->inventario_model->get_backlog_inventario_traslado($where);

                    $data['traslado']           = $traslado;
                    $data['recibir_traslado']   = ($this->gsatelite->get_parametro('SYS_RECIBIR_TRASLADO') == 1 )?true:false;
                    $html = $this->load->view('inventario/gestion_productos/consultar_traslado_productos', $data, true);

                    echo $html;
                    die();
                }
            } else {
                $select = $this->gsatelite->get_dropdown('tip_tipo_proceso', '{tip_nombre}', '', array('tip_estado' => 1, 'tip_traslado' => 1), null, '', 'tip_id', true);
                $data['tipo_proceso'] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data['titulo_personal'] = 'Traslado de productos';
                $this->_cargarvista($data);
            }
        }
    }

    public function traslado_articulo() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $bodegas_usuario = $this->inventario_model->usuarioxbodega();
            $rxi_bodega = array_filter(array_column($bodegas_usuario, 'bod_id'));
            $rxi_bodega = (count($rxi_bodega) > 0) ? $rxi_bodega : array(0);
            //muestra las requisiciones
                           $this->db->where_in('rxi_id_bod', $rxi_bodega);
            $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_tipo != ' => 3));
            $select = "";
            foreach ($requisicion as $key) {
                if ($key["rxi_estado"] == 6 || $key["rxi_estado"] == 3) {
                    $solicitante = $this->inventario_model->informacion_empleado($key['rxi_id_usu_solicita']);
                    if(count($solicitante) > 0){
                        $select .= '<option value="'.$key['rxi_id'].'">'.$key['rxi_numero'].' - '.$solicitante[0]['are_nombre'].' ('.formatear_fecha('d-m-Y', $key['rxi_fecha']).')</option>';
                    }
                }
            }
            $data["requisicion_rxi"] = $select;
            //Filtra las bodegas por usuario
            /* $bodegas = $this->inventario_model->get_bodegas_usuario();
            $select = "";
            foreach ($bodegas as $key) {
                $select .= "<option value='".$key['bod_id']."'>".$key['bod_nombre']."</option>";
            }
            $data["bodega_bod"] = $select; */
            //Correlativo para traslado_articulo
            $num_actual = $this->gsatelite->get_max('tra_translado', 'tra_id');
            $codigo = $num_actual + 1;
            $data['num_correlativo_traslado'] = generar_codigo_cor($codigo, 5);
            // Tipo traslado
            $tipo_proceso_reg = $this->gsatelite->get_tabla('tip_tipo_proceso', array('tip_estado' => 1, 'tip_traslado' => 1));
            $selectip = '';
            foreach ($tipo_proceso_reg as $key => $value) {
                $selectip .= '<option value="'.$value['tip_id'].'" data-autoriza="'.$value['tip_aplica_autorizacion'].'">'.$value['tip_nombre'].'</option>';
            }
            $data["traslado_tip"] = $selectip;
            // Categoria de articulos
            $selectia = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1, 'tia_padre' => null), null, '', 'tia_id', true);
            $data["categoria_tia"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $selectia);
            // Sucursales
            $selectsuc = "";
            $sucursales = $this->inventario_model->get_sucursalxusuario();
            foreach ($sucursales as $key) {
                $selectsuc .= "<option value='" . $key['suc_id'] . "'>" . $key['suc_nombre'] . "</option>";
            }
            $data["sucursales_suc"] = $selectsuc;
            $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $cantidad_defecto = $this->gsatelite->get_parametro('SYS_INV_DEFECTO_CANTIDAD_PRODUCTOS');
            $data['cantidad_defecto'] = ($cantidad_defecto != null && $cantidad_defecto > 0 ) ? $cantidad_defecto : "";
            $data['requision_medica'] = $this->inventario_model->requisicion_med_inv();
            $data['bodega_origen'] = $bodegas_usuario;
            $data['bodega'] = $this->gsatelite->get_tabla('bod_bodega', array('bod_estado' => 1));
            $data['tipo_transaccion'] = $this->inventario_model->cargar_todo('tip_tipo_proceso', array('tip_traslado' => 1, 'tip_estado' => 1));
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')!='')?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['titulo_personal'] = "Traslado de artículos entre bodegas";
            $this->_cargarvista($data);
        }
    }

    function guardar_traslado_producto() {
        satelite_validar();
        // var_dump($_POST);die();
        $redireccion    = $this->input->post('redireccion');
        $tipo_proceso   = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO'); 
        // Parte izquierda - Origen
        //Fecha de traslado 
        $fecha_traslado  = (trim($this->input->post('fec_traslado')) != "") ? $this->input->post('fec_traslado') : null;
        $requisicion_rxi = (trim($this->input->post('requisicion_rxi')) != "") ? $this->input->post('requisicion_rxi') : null;   
        $bodega_bod      = (trim($this->input->post('bodega_bod')) != "") ? $this->input->post('bodega_bod') : null;
        $sector_sxb1     = (trim($this->input->post('sector_sxb1')) != "") ? $this->input->post('sector_sxb1') : null;  //628
        // $sector_salida   = (is_array($this->input->post('sxb_salida'))) ? $this->input->post('sxb_salida') : array(); //ARRAY CON LOS SECTORES DE SALIDA (PRUEBAS) ///****///
        // Parte derecha - Destino
        $bodega_bod2    = (trim($this->input->post('bodega_bod2')) != "") ? $this->input->post('bodega_bod2') : null;
        $slcProdest     = (trim($this->input->post('slcProdest')) != "") ? $this->input->post('slcProdest') : null; 
        $traslado_tip   = (trim($this->input->post('traslado_tip')) != "") ? $this->input->post('traslado_tip') : null; 
        $txtAutoriza    = (trim($this->input->post('txtAutoriza')) != '') ? $this->input->post('txtAutoriza') : 0;    
        $comentario     = (trim($this->input->post('comentario')) != "") ? $this->input->post('comentario') : null; 
        // numero_correlativo_traslado
        $num_actual = $this->gsatelite->get_max('tra_translado', 'tra_id');
        $codigo = $num_actual + 1;
        $numCorrelativoTraslado = ($this->input->post('numCorrelativoTraslado') != "") ? $this->input->post('numCorrelativoTraslado') : generar_codigo_cor($codigo, 5);

        $medida_cva = $this->input->post('medida_cva'); //array
        $sector_sxb = $this->input->post('sector_sxb'); //ARRAY CON LOS SECTORES DE DESTINO DEBERIA SER EL MISMO DE MOMENTO ///***///
        $codigo_lote = $this->input->post('codigo_lote'); //array
        $producto_art = $this->input->post('producto_art'); //array
        $cantidad_dee = ($requisicion_rxi > 0) ? $this->input->post('cantidad_dee_conv') : $this->input->post('cantidad_dee');
        $producto_destino = $this->input->post('producto_destino'); //array
        // $sector_sxb2 = (trim($this->input->post('sector_sxb2')) != "") ? $this->input->post('sector_sxb2') : null;  //SECTOR DESTINO (EN LAS REQ. NO VIENE EL ARRAY) ///***///

        $tipos_proceso = $this->inventario_model->cargar_registro('tip_tipo_proceso', 'tip_id', $traslado_tip);
        $tip_id_entrada = $tipos_proceso['tip_id_tip_entrada'];
        $tip_id_salida = $tipos_proceso['tip_id_tip_salida'];
        $fecha_moi = ($fecha_traslado != null) ? formatear_fecha('Y-m-d', $fecha_traslado) . ' ' . date('H:i:s') : date('Y-m-d H:i:s');
        $fecha_entrada = date('Y-m-d H:i:s', strtotime('+1 second' , strtotime($fecha_moi)));

        if (trim($bodega_bod) != "" && trim($tip_id_entrada) != "" && trim($tip_id_salida) != "" && trim($bodega_bod2) != "") {
            if($txtAutoriza != 1){
                // Cambiar la bodega a array para hacer un foreach o for,
                // Hacer el ingreso a la dee en una funcion aparte para mandarla a llamar
                // Movimiento salida
                $moi_valores1 = array(
                    'moi_id_tip' => $tip_id_salida,
                    'moi_id_bod' => $bodega_bod,
                    'moi_descripcion' => $comentario,
                    'moi_documento' => $numCorrelativoTraslado,
                    'moi_fecha_mov' => $fecha_moi,
                    'moi_estado' => 1,
                    'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $moi_id_salida = $this->gsatelite->ingresar('moi_movimiento_inv', $moi_valores1);    

                // Movimiento entrada
                $moi_valores2 = array(
                    'moi_id_tip' => $tip_id_entrada,
                    'moi_id_bod' => $bodega_bod2,
                    'moi_descripcion' => $comentario,
                    'moi_documento' => $numCorrelativoTraslado,
                    'moi_fecha_mov' => $fecha_entrada,
                    'moi_estado' => 1,
                    'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $moi_id_entrada = $this->gsatelite->ingresar('moi_movimiento_inv', $moi_valores2);   

                $tra_traslado_valores = array(
                    'tra_id_moi_sal' => $moi_id_salida,
                    'tra_id_moi_ent' => $moi_id_entrada,
                    'tra_fecha_translado' => $fecha_moi,
                    'tra_descripcion' => $comentario,
                    'tra_id_tip' => $traslado_tip,
                    'tra_estado' => 1,
                    'tra_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tra_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tra_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tra_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'tra_correlativo' => $numCorrelativoTraslado
                );
                $this->gsatelite->ingresar('tra_translado', $tra_traslado_valores); 
                for ($x = 0; $x < count($producto_art); $x++) {
                    //verificar si posee paquetes
                    $post_empaque   = $this->input->post("chk_empaque_".$producto_art[$x]);
                    $array_empaques = NULL;
                    if ($post_empaque) {
                        $array_empaques = $post_empaque;
                    }
                    if (trim($producto_art[$x]) != "" && trim($cantidad_dee[$x]) != "") {
                        $cantidades = $this->inventario_model->get_cantidad_bodega(null, $bodega_bod, null, $producto_art[$x]);
                        $traslado = array('sector' => $sector_sxb[$x], 'bodega' => $bodega_bod2, 'moi_entrada' => $moi_id_entrada);
                        // $sector_saldra = (isset($sector_salida[$x]) && $sector_salida[$x] > 0) ? $sector_salida[$x] : null; ///***///
                        // $sector_destino = (isset($sector_sxb[$x]) && $sector_sxb[$x] > 0) ? $sector_sxb[$x] : $sector_sxb2; ///***///
                        // $traslado = array('sector' => $sector_destino, 'bodega' => $bodega_bod2, 'moi_entrada' => $moi_id_entrada); ///***///
                        //evaluara el tipo de proceso que debe seguir
                        if ($tipo_proceso == 2) { //si es por fefo
                            $condiciones = array (
                                "articulo"          => $producto_art[$x],
                                "moi_id"            => $moi_id_salida,
                                "sector"            => $sector_sxb1, // => $sector_saldra,
                                "cantidades"        => $cantidad_dee[$x],
                                "bodega"            => $bodega_bod,
                                "lote"              => $codigo_lote[$x],
                                "cantidad_maxima"   => $cantidades[0]["cantidad"],
                                "id_conversion"     => $medida_cva[$x],
                                "traslado"          => $traslado,
                                "producto_destino"  => $producto_destino[$x],
                                "requisicion"       => $requisicion_rxi,
                                "empaques"          => $array_empaques
                            );
                            $this->fefo($condiciones);
                        } else {
                            $sector_saldra = $sector_sxb1;
                            if ($requisicion_rxi != null) {
                                $this->peps_salida($producto_art[$x], $producto_destino[$x], $moi_id_salida, $medida_cva[$x], $cantidad_dee[$x], $sector_sxb1, $cantidades[0]["cantidad"], $bodega_bod, $traslado, $requisicion_rxi, $codigo_lote[$x],$array_empaques);
                                // $this->peps_salida($producto_art[$x], $producto_destino[$x], $moi_id_salida, $medida_cva[$x], $cantidad_dee[$x], $sector_saldra, $cantidades[0]["cantidad"], $bodega_bod, $traslado, $requisicion_rxi, $codigo_lote[$x],$array_empaques); ///***///
                            } else {
                                $this->peps_salida($producto_art[$x], $producto_destino[$x], $moi_id_salida, $medida_cva[$x], $cantidad_dee[$x], $sector_saldra, $cantidades[0]["cantidad"], $bodega_bod, $traslado, null, $codigo_lote[$x],$array_empaques);
                            }
                        }
                    }
                }
                //============= Generar asiento traslado inventario ===============//
                $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_INVENTARIO');
                if($generar_partida > 0){
                    $res_debe = $this->generar_asiento_traslado_inv_debe($moi_id_entrada, $numCorrelativoTraslado);
                    $this->generar_asiento_traslado_inv_haber($moi_id_salida, $res_debe['id_pct'], $numCorrelativoTraslado);//moi_id_salida, id_pct, numCorrelativoTraslado
                    $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_debe['id_pct']), array('moi_id' => $moi_id_salida));
                }
                //==============Fin Generar asiento traslado inventario ===========//
            } else{
                $traslado_reg = $this->gsatelite->get_tabla('trp_traslado_pendiente');
                $correlativo = count($traslado_reg) + 1;
                $traslado_guardar = array(
                    'trp_id_tip' => $traslado_tip,
                    // 'trp_id_prv' => $nada,
                    'trp_id_bod_origen' => $bodega_bod,
                    'trp_id_bod_destino' => $bodega_bod2,
                    'trp_id_usu' => $this->tank_auth->get_user_id(),
                    // 'trp_id_usu_autoriza' => $nada,
                    // 'trp_id_usu_anula' => $nada,
                    'trp_fecha_registro' => date('Y-m-d H:i:s'),
                    'trp_fecha_traslado' => date('Y-m-d H:i:s'),
                    'trp_documento' => $numCorrelativoTraslado,
                    'trp_descripcion' => $comentario,
                    'trp_correlativo' => $correlativo,
                    // 'trp_fecha_anula' => $nada,
                    // 'trp_fecha_autoriza' => $nada,
                    // 'trp_aplica_prestamo' => $nada,
                    // 'trp_descripcion_autoriza' => $nada,
                    // 'trp_descripcion_anula' => $nada,
                    'trp_estado_traslado' => 1,
                    'trp_estado' => 1,
                    'trp_usu_creacion' => $this->tank_auth->get_user_id(),
                    'trp_fecha_creacion' => date('Y-m-d H:i:s'),
                    'trp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'trp_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $tpr_id = $this->gsatelite->ingresar('trp_traslado_pendiente', $traslado_guardar);

                for ($x = 0; $x < count($producto_art); $x++) {
                    if (trim($producto_art[$x]) != "" && trim($cantidad_dee[$x]) != "") {
                        $cantidades = $this->inventario_model->get_cantidad_bodega(null, $bodega_bod, null, $producto_art[$x]);

                        $costo_bodega = $this->obtener_costos_movimiento($producto_art[$x], $cantidad_dee[$x], $cantidades[0]["cantidad"], $bodega_bod, $sector_sxb1, ($codigo_lote[$x] != '')?$codigo_lote[$x]:null);

                        $detalle_traslado_guardar = array(
                            'dtr_id_trp' => $tpr_id,
                            'dtr_id_art' => $producto_art[$x],
                            'dtr_id_cva' => $medida_cva[$x],
                            'dtr_id_sxb' => ($sector_sxb[$x] != '')?$sector_sxb[$x]:null,
                            'dtr_id_sxb_salida' => $sector_sxb1,
                            'dtr_cantidad' => $cantidad_dee[$x],
                            'dtr_cantidad_entregada' => 0,
                            // 'dtr_fecha_caducidad' => $nada,
                            'dtr_precio' => 0,
                            'dtr_subtotal' => 0,
                            'dtr_codigo_lote' => ($codigo_lote[$x] != '')?$codigo_lote[$x]:null,
                            // 'dtr_descripcion' => $nada,
                            'dtr_estado' => 1,
                            'dtr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dtr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dtr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dtr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dtr_id = $this->gsatelite->ingresar('dtr_detalle_traslado_pendiente', $detalle_traslado_guardar);

                        $saldo_detalle_guardar = array();
                        foreach ($costo_bodega['sars'] as $key => $value) {
                            $saldo_detalle_guardar[] = array(
                                'sxd_id_dtr' => $dtr_id,
                                'sxd_id_sar' => $costo_bodega['sars'][$key],
                                'sxd_cantidad' => ($costo_bodega['cantidades'][$key] != '')?$costo_bodega['cantidades'][$key]:0,
                                'sxd_precio' => ($costo_bodega['precios'][$key] != '')?$costo_bodega['precios'][$key]:0,
                                'sxd_subtotal' => ($costo_bodega['totales'][$key] != '')?$costo_bodega['totales'][$key]:0,
                                'sxd_fecha_caducidad' => ($costo_bodega['fecha_caducidad'][$key] != '')?$costo_bodega['fecha_caducidad'][$key]:null,
                                'sxd_estado' => 1,
                                'sxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                'sxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sxd_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                        }

                        if(count($saldo_detalle_guardar) > 0){
                            $this->gsatelite->ingresar('sxd_saldo_artxdetalle_pendiente', $saldo_detalle_guardar, true);
                        }
                    }
                }

            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Traslado de productos", 'texto_alerta' => "El registro se guardó correctamente");
            $this->session->set_flashdata($alerta);
            if ($redireccion == 0) {
                redirect('/inventario/gestion_productos/traslado_articulo');
            } else {
                redirect('/inventario/gestion_productos/cargar_salida');
            }
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se realizó el traslado", 'texto_alerta' => "Verifique la Configuración del Tipo de Proceso.");
            $this->session->set_flashdata($alerta);
            redirect('/inventario/gestion_productos/cargar_salida');
        }
    }

    /**
     * @author René Castaneda
     */
    function guardar_serie_entrada() {

    }

    /**
     * @author René Castaneda
     * @param int id del producto
     * @return OBTENER LAS SERIES DEL PRODUCTO
     */
    function get_series_producto() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('producto');
            $posee = false; //posee series (bandera)
            $select_series = "";
            if ($id > 0) {
                //preguntar si el producto posee series
                $pregunta = $this->gsatelite->get_tabla('ser_serie', array('ser_id_art' => $id, 'ser_estado' => 1));
                if (count($pregunta) > 0) {
                    $posee = true;
                    $select_series = $this->gsatelite->get_dropdown('ser_serie', 'ser_nombre', 'nombreSerie', array('ser_id_art' => $id, 'ser_estado' => 1), null, ' id="nombreSerie" class="nostyle" onchange="cargarTablaCorrelativos(this.value);  $(\'#v_nombreSerie\').text(\'\'); " ');
                }
                echo json_encode(array('posee' => $posee, 'select_series' => $select_series));
            }
        }
    }

    /**
     * @author René Castaneda
     * @param int id de la serie
     * @return OBTENER los correlativos de la serie
     */
    function get_correlativos_serie() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('serie');
            $otrosCi = $this->input->post('c_iniT');
            $otrosCf = $this->input->post('c_finT');
            $salidas_temporales = (count($otrosCi) > 0 and $otrosCi != "" ) ? array($otrosCi, $otrosCf) : null;
            $posee = false; //posee series (bandera)
            $tabla_correlativos = "";
            if ($id > 0) {
                //preguntar si la serie posee correlativos activos
                $this->db->order_by('cor_inicio', 'ASC'); //que la consulta se haga de manera ascendente.
                $consulta = $this->gsatelite->get_tabla('cor_correlativo', array('cor_id_ser' => $id));
                if (count($consulta) > 0) {
                    $posee = true;
                    $correlativos_disponibles = $this->inventario_model->get_Correlativos_disponibles($id, $salidas_temporales);
                    $data = array('correlativos_disponibles' => $correlativos_disponibles, 'consulta' => $consulta);
                    $tabla_correlativos = $this->load->view('inventario/gestion_productos/detalles_correlativos', $data, true);
                    //$tabla_correlativos = $this->db->last_query();
                }
                echo json_encode(array('posee' => $posee, 'tabla_correlativos' => $tabla_correlativos));
            }
        }
    }

    /**
     * @author René Castaneda
     * @param int id de la serie
     * @return que el rango elegido sea valido
     */
    function validar_rango_correlativo() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('serie');
            $iniC = $this->input->post('c_ini');
            $iniF = $this->input->post('c_fin');
            $otrosCi = $this->input->post('c_iniT');
            $otrosCf = $this->input->post('c_finT');
            $salidas_temporales = (count($otrosCi) > 0 and $otrosCi != "" ) ? array($otrosCi, $otrosCf) : null;
            if ($id > 0 and $iniC != "" and $iniF != "") {
                $espacio = false; //variable que cambiará a true si hay espacio disponible para el rango de correlativo
                $correlativos_disponibles = $this->inventario_model->get_Correlativos_disponibles($id, $salidas_temporales);
                $inicios = $correlativos_disponibles[0];
                $finales = $correlativos_disponibles[1];
                if (count($inicios) > 0) {
                    $segir = true; //bandera para detener el for
                    for ($i = 0; (($i < count($inicios)) and $segir); $i++) {
                        //validar que las cantidades encaje en un rango
                        if (($iniC >= $inicios[$i]) and ( $iniF <= $finales[$i])) {
                            $segir = false;
                            $espacio = true;
                        }
                    }
                }
                echo json_encode(array('espacio' => $espacio));
            }
        }
    }

    function aplicaSerieProducto() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('producto');
            $aplica = false;
            $consulta = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id, 'art_aplica_serie' => 1));
            if (count($consulta) > 0) {
                $aplica = true;
            }
            echo json_encode(array('aplica' => $aplica));
        }
    }

    function validaNombreSerieUnico() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_prod = $this->input->post('idP');
            $NombreSerie = $this->input->post('Nombreserie');
            $existe = false;
            if ($id_prod > 0 and $NombreSerie != "") {
                //preguntar si existe una serie con el mismo nombre.
                $consulta = $this->gsatelite->get_tabla('ser_serie', array('ser_nombre' => $NombreSerie, 'ser_id_art' => $id_prod));
                if (count($consulta) > 0) {
                    $existe = true;
                }
            }
            echo json_encode(array('existe' => $existe));
        }
    }

    /*
     * Requisiciones Controller
     */

    public function requisiciones($consulta = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/gestion_productos/requisiciones');
            if ($_POST) {
                if ($consulta > 0) {
                    // var_dump($_POST);die();
                    $post_array = $_POST;
                    //Se obtienen los filtros
                    $estado_requicision = $post_array['estado'];
                    $fecha_inicio = $post_array['fecha_ini'];
                    $fecha_fin = $post_array['fecha_fin'];
                    $where = null;
                    //Se agregan las condiciones si los filtros contienen datos
                    if ($estado_requicision) {
                        $where['rxi_estado'] = $estado_requicision;
                    }
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                        $where['date_format(rxi_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($fecha_inicio));
                        $where['date_format(rxi_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($fecha_fin));
                    }
                    $usuario = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
                    $roles_jefes = explode(",", $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD',0) );
                    $mis_roles   = $this->gsatelite->get_tabla("uxr_usuarioxrol",array("uxr_id_usu" => $this->tank_auth->get_user_id()) );
                    $permiso_rol = false;

                    foreach ($mis_roles as $rol) {
                        if ( in_array($rol["uxr_id_rol"], $roles_jefes) ) {
                            $permiso_rol = true;
                        }
                    }

                    if ( $permiso_rol == false) {
                        $where['rxi_id_usu_solicita'] = $this->tank_auth->get_user_id();
                    } 
                    //Se filtran las requisiciones del usuario
                    //$where['rxi_id_usu_solicita'] = $this->tank_auth->get_user_id();
                    //Condicion para obtener el seguimiento correcto del flujo
                    $where['id'] = $this->tank_auth->get_user_id();
                    //Se condiciona el paso actual
                    $where['sgr_fecha_salida'] = null;
                    $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
                    $flujos_array = json_decode($flujos, true);
                    $where['flu_id'] = $flujos_array['REQ_INV'];
                    $requisiciones = $this->inventario_model->get_backlog_requisiciones($where);
                   // print_r($this->db->last_query());die();
                    $data['requisiciones'] = $requisiciones;

                    $html = $this->load->view('inventario/gestion_productos/consultar_requisiciones', $data, true);

                    echo $html;
                    die();
                }
            } else {
                $data['titulo_personal'] = 'Listado de Requisiciones';
                $this->_cargarvista($data);
            }
        }
    }

    function agregar_requisicion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array = json_decode($flujos, true);

            $num_actual = $this->gsatelite->count('rxi_requisicion_inventario', array('rxi_id_flu' => $flujos_array['REQ_INV']));

            $codigo = $num_actual + 1;

            /* ************************************************** */
            /* Obtener los permisos para autorizar la requisicion */
            /* ************************************************** */
            $groupby = null;
            $orderby = null;
            $where   = null;

            // agrupador
            $groupby = 'rol_id';
            $where   = array('psf_orden'=>2, 'psf_id_flu'=>1, 'axr_id_acc'=>2, 'id'=>$this->tank_auth->get_user_id());
            $data['autorizar'] = $this->inventario_model->get_permisos_autorizar_requisicion($where, $groupby, $orderby);
            $data['parametro'] = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_INV'));
            /* ************************************************** */
            // print_r($this->db->last_query());die();
            /* ************************************************** */
            $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data['ver_existencias'] = $this->gsatelite->get_parametro_emp('SYS_REQUISICION_MOSTRAR_SALDO', '1');
            $data['num_requisicion'] = generar_codigo_cor($codigo, 5);
            $data['empleados'] = $this->inventario_model->listado_empleados(array('emp_estado' => 1));
            $data['usuario'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->get_bodegas_usuario();
            $data['titulo_personal'] = 'Crear requisiciones de inventario';
            $this->_cargarvista($data);
        }
    }

    function registrar_requisicion() {
        if ($_POST) {
            //Si se ha enviado valores de solicitud
            // var_dump($_POST);die();
            $post_array = $_POST;
            $id_detalle = 0;
            $usuario = $this->tank_auth->get_user_id();
            $slcBodega = $post_array['slcBodega'];
            $slcEmpleado = $post_array['slcEmpleado'];
            $tipoRequisicion = $post_array['slcTipo'];
            $fecha = $post_array['fecha'];
            //$empleadosxbodega = $this->db->join('users', 'id=uxb_id_usu')->where('uxb_id_bod', $slcBodega)->get('uxb_usuarioxbodega')->result_array();

            $txtDescripcion = $post_array['txtDescripcion'];

            $flujos = $this->gsatelite->get_parametro('SYS_FLUJOS_TRABAJO');
            $flujos_array = json_decode($flujos, true);
            $flujoRequisicionesInv = $flujos_array['REQ_INV'];


            $num_actual = $this->gsatelite->count('rxi_requisicion_inventario', array('rxi_id_flu' => $flujoRequisicionesInv));

            $codigo = $num_actual + 1;

            $cod_requisicion = generar_codigo_cor($codigo, 5);

            $ingresar_requisicion = array(
                'rxi_numero' => $cod_requisicion,
                'rxi_id_bod' => $slcBodega,
                'rxi_id_usu_solicita' => $usuario,
                'rxi_id_emp' => $slcEmpleado,
                'rxi_id_flu' => $flujoRequisicionesInv,
                'rxi_fecha' => date('Y-m-d', strtotime($fecha)),
                'rxi_descripcion' => $txtDescripcion,
                'rxi_estado' => 1,
                'rxi_tipo' => $tipoRequisicion,
                'rxi_usu_creacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_creacion' => date('Y-m-d h:i:s'),
                'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion' => date('Y-m-d h:i:s')
            );
            //die(print_r($ingresar_requisicion));

            $id_req = $this->gsatelite->ingresar('rxi_requisicion_inventario', $ingresar_requisicion);

            $productos = $post_array['productos'];
            $cantidades = $post_array['cantidad'];
            $conversiones = $post_array['conversion'];


            if ($id_req > 0) {
                $primer_paso = $this->inventario_model->get_primer_paso_flujo($flujoRequisicionesInv);
                if (count($primer_paso) > 0) {
                    $seguimiento_requisicion = array(
                        'sgr_id_rxi' => $id_req,
                        'sgr_id_psf' => $primer_paso[0]['psf_id'],
                        'sgr_id_usu' => $usuario,
                        'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgr_estado' => 1,
                        'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                    $id_detalle = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                }

                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {

                        $id_cant = $cantidades[$key];
                        $art_id = null;
                        $cva_id = null;
                        $act_id = null;
                        $dri_id = null;
                        $sri_id = null;

                        switch ($tipoRequisicion) {
                            case 1:
                            $art_id = $productos[$i];
                            $cva_id = $conversiones[$i];
                            break;
                            case 2:
                            $art_id = $productos[$i];
                            break;
                            case 3:
                            $act_id = $productos[$i];
                            break;
                        }

                        $detalle_req = array(
                            'dri_id_rxi' => $id_req,
                            'dri_id_art' => $art_id,
                            'dri_id_cva' => $cva_id,
                            'dri_id_act' => $act_id,
                            //'dri_id_sri' => $sri_id,
                            'dri_cantidad' => convertirFloat($cantidades[$i]),
                            'dri_estado' => 1,
                            'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                            'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dri_fecha_creacion' => date('Y-m-d H:i:s')
                        );

                        $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
                    }
                }

                // Variables a utilizar
                $tipo_btn   = $post_array['btnCrear'];
                $tipo_flujo = 1; // tipo flujo: 1- Requisiciones
                $flujo      = 1; // Flujo: 3 - Requisicion de Inventario
                // Parametro para determinar la autorizacion de la requisicion
                $autorizar = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_INV'));
                if (isset($autorizar) && $autorizar > 0 && $tipo_btn === '3' && $id_req > 0) {
                    $this->autorizar_requisicion_automatica($id_req, $tipo_flujo, $flujo);
                }

                //************* Autorizar requisición *******************************************/
                /* if ($this->gsatelite->get_parametro('INV_AUTORIZAR_REQUISION') == 1) {
                  $this->db->where('rxi_id', $id_req);
                  $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2, 'rxi_usu_mod' => $this->tank_auth->get_user_id(), 'rxi_fecha_mod' => date('Y-m-d H:i:s')));
                  $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos autorizada", 'texto_alerta' => "Ahora usted podrá ver la requisición en la pantalla de salida de artículos");
                  } else {

                  } */
                //*******************************************************************************/

                  $tipo_btn = $post_array['btnCrear'];

                  if ($id_detalle > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('inventario/gestion_productos/agregar_requisicion');
            } else {
                redirect('inventario/gestion_productos/requisiciones');
            }

            /* foreach ($empleadosxbodega as $key => $value) {
              $this->send_email($value['email']);
          } */
      }
  }

    function editar_requisicion($id_req = NULL) {
        satelite_validar();
        if ($_POST) {
            //Si se ha enviado valores de solicitud
           // print_r($_POST);die();

            $post_array = $_POST;

            $id_detalle = 0;
            $usuario = $this->tank_auth->get_user_id();
            $slcBodega = $post_array['slcBodega'];
            $tipoRequisicion = $post_array['slcTipo'];
            $slcEmpleado = $post_array['slcEmpleado'];
            $fecha = $post_array['fecha'];
            $empleadosxbodega = $this->db->join('users', 'id=uxb_id_usu')->where('uxb_id_bod', $slcBodega)->get('uxb_usuarioxbodega')->result_array();

            $txtDescripcion = $post_array['txtDescripcion'];

            $num_actual = $this->inventario_model->num_max_requi();

            $codigo = $num_actual[0]['maximo'] + 1;

            $cod_requisicion = generar_codigo_cor($codigo, 5);

            $flujoRequisicionesInv = $this->gsatelite->get_parametro('SYS_FLU_REQ_INV');

            $requisicion_array = array(
                'rxi_id_bod' => $slcBodega,
                'rxi_id_emp' => $slcEmpleado,
                'rxi_fecha' => date('Y-m-d', strtotime($fecha)),
                'rxi_descripcion' => $txtDescripcion,
                'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $resultado = $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $requisicion_array, array('rxi_id' => $id_req));

            $productosIds = $post_array['hdnDetalle'];
            $productos = $post_array['productos'];
            $cantidades = $post_array['cantidad'];
            $conversiones = $post_array['conversion'];

            $act_cant = $post_array['changePrices'];
            if ( (is_array($act_cant)) && (count($act_cant)>0)) {
                for ($i=0; $i < count($act_cant) ; $i++) { 
                    $data = explode(':::', $act_cant[$i]);
                    $canti = array('dri_cantidad'=>convertirFloat($data[0]));
                    $this->gsatelite->actualizar_array('dri_detalle_requisicion_inventario', $canti, array('dri_id_rxi' => $id_req,'dri_id_art'=>$data[1]));
                }
            }


            if ($resultado > 0) {
                    //Se verifica si se eliminaron productos.
                $where = array(
                    'dri_id_rxi' => $id_req
                );
                $dataDetalle = $this->inventario_model->get_requisicion_detalle($where);
                if (!is_array($productosIds)) {
                $productosIds = array();
            }
            foreach ($dataDetalle as $data) {
                if (!in_array($data['dri_id'], $productosIds)) {
                    $this->gsatelite->borrado_general('dri_detalle_requisicion_inventario', array('dri_id' => $data['dri_id']));
                }
            }

            if (count($productos) > 0) {
                for ($i = 0; $i < count($productos); $i++) {

                    $id_cant = $cantidades[$key];
                    $art_id = null;
                    $cva_id = null;
                    $act_id = null;
                    $dri_id = null;
                    $sri_id = null;

                    switch ($tipoRequisicion) {
                        case 1:
                        $art_id = $productos[$i];
                        $cva_id = $conversiones[$i];
                        break;
                        case 2:
                        $art_id = $productos[$i];
                        break;
                        case 3:
                        $act_id = $productos[$i];
                        break;
                    }

                    $detalle_req = array(
                        'dri_id_rxi' => $id_req,
                        'dri_id_art' => $art_id,
                        'dri_id_cva' => $cva_id,
                        'dri_id_act' => $act_id,
                            //'dri_id_sri' => $sri_id,
                        'dri_cantidad' => convertirFloat($cantidades[$i]),
                        'dri_estado' => 1,
                        'dri_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dri_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'dri_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dri_fecha_creacion' => date('Y-m-d H:i:s')
                    );

                    $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario', $detalle_req);
                }
            }

                //************* Autorizar requisición *******************************************/
                /* if ($this->gsatelite->get_parametro('INV_AUTORIZAR_REQUISION') == 1) {
                  $this->db->where('rxi_id', $id_req);
                  $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2, 'rxi_usu_mod' => $this->tank_auth->get_user_id(), 'rxi_fecha_mod' => date('Y-m-d H:i:s')));
                  $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos autorizada", 'texto_alerta' => "Ahora usted podrá ver la requisición en la pantalla de salida de artículos");
                  } else {

                  } */
                //*******************************************************************************/
                  /********************************************************************************/
            $tipo_btn = $post_array['btnCrear'];
            $tipo_flujo = 1; // tipo flujo: 1- Requisiciones
            $flujo      = 1; // Flujo: 3 - Requisicion de Inventario
                // Parametro para determinar la autorizacion de la requisicion
            $autorizar = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_INV'));
            if (isset($autorizar) && $autorizar > 0 && $tipo_btn === '3' && $id_req > 0) {
                $this->autorizar_requisicion_automatica($id_req, $tipo_flujo, $flujo);
            }
                /********************************************************************************/

                if ($resultado > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            /* foreach ($empleadosxbodega as $key => $value) {
                $this->send_email($value['email']);
            } */
            $this->session->set_flashdata($alerta);
            $tipo_btn = $post_array['btnCrear'];
            if ($tipo_btn == 1) {
                redirect('/inventario/gestion_productos/editar_requisicion/' . $id_req);
            } else {
                redirect('inventario/gestion_productos/requisiciones');
            }
        } else {
            $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $id_req));
            $data['requisicion'] = $requisicion[0];
            if ($requisicion[0]['rxi_id_ord'] != "") {
                $this->load->model('proyecto_model');
                $data['orden'] = $this->proyecto_model->get_orden(array('ord_id' => $requisicion[0]['rxi_id_ord']));
            }else{
                $data['orden'] = array();
            }
            $sectores_html = "<option></option>";
            $sectores = $this->inventario_model->get_sector_grid($requisicion[0]['rxi_id_bod']);
            foreach ($sectores as $ser) {
                $sectores_html .= "<option value='" . $ser['sxb_id'] . "' >" . $ser['seb_nombre'] . "</option>";
            }
            $where = array('dri_id_rxi' => $id_req);
            $data['sectores'] = $sectores_html;
            $data['detalle_requisicion'] = $this->inventario_model->get_requisicion_detalle($where);
            $data['usa_sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $data['empleados'] = $this->inventario_model->listado_empleados(array('emp_estado' => 1));
            $data['usuario'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->get_bodegas_usuario();
            $data['ver_existencias'] = $this->gsatelite->get_parametro_emp('SYS_REQUISICION_MOSTRAR_SALDO', '1');
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            /* ************************************************** */
            /* Obtener los permisos para autorizar la requisicion */
            /* ************************************************** */
            $orderby = null;
            $where   = null;
            // agrupador
            $where   = array('psf_orden'=>2, 'psf_id_flu'=>1, 'axr_id_acc'=>2, 'id'=>$this->tank_auth->get_user_id());
            $data['autorizar'] = $this->inventario_model->get_permisos_autorizar_requisicion($where, 'rol_id', $orderby);
            $data['parametro'] = $this->gsatelite->get_parametro('SYS_AUTORIZAR_REQUISICION', null, null, array('REQUISICION_INV'));
            /* ************************************************** */
            // print_r($this->db->last_query());die();
            /* ************************************************** */
            $data['titulo_personal'] = 'Editar requisiciones de inventario';
            // $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/editar_requisicion', $data);
            $this->_cargarvista(null, $data);
        }
    }

function historial_req() {
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
        $user = $this->tank_auth->get_user_id();
        $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodegas'] = $this->inventario_model->get_bodegas_usuario();
        $data['solicitudes'] = $this->inventario_model->historial_solicitudes($user);
        $data['pendientes'] = $this->inventario_model->historial_solicitudes2($user);
        $data['anuladas'] = $this->inventario_model->solicitudes_rechazadas($user);
            //var_dump($this->db->last_query());exit();
            // Nuevos datos
            //    $select = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}','', null, null, '', 'bod_id', true);
            //    $data["select_rxi_id_bod"] = str_replace('<option value="0">Seleccione</option>', '',$select);

        $data['titulo_personal'] = 'Historial de requisiciones';
        $this->_cargarvista(null, $data);
    }
}

function filtro_requisicion() {
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
            // All your code here.
        if ($_POST) {
                //die(print_r($_POST));

            $filtro = $this->input->post('filtro');
            $valor = $this->input->post('valor');
                $tipo_req = $this->input->post('tipo_req'); // 1= Despachada, 2= Pendientes, 3=Anulada
                $user = $this->tank_auth->get_user_id();

                $where = null;
                if ($filtro == 'rxi_fecha') {
                    $f = explode('#', $valor);
                    $where = array('date_format(' . $filtro . ',"%Y-%m-%d") >=' => date('Y-m-d', strtotime($f[0])), 'date_format(' . $filtro . ',"%Y-%m-%d") <=' => date('Y-m-d', strtotime($f[1])));
                } else {
                    $where = array("$filtro" => trim($valor));
                }

                // Obtener Solicitudes
                $html = '';
                if ($tipo_req == 1) {
                    $data['solicitudes'] = $this->inventario_model->historial_solicitudes($user, $where);
                    //  die(print_r($this->db->last_query()));
                    $html = $this->load->view('inventario/requisiciones/requisiciones_despachadas', $data, true);
                } else
                if ($tipo_req == 2) {
                    $data['pendientes'] = $this->inventario_model->historial_solicitudes2($user, $where);
                    $html = $this->load->view('inventario/requisiciones/requisiciones_pendientes', $data, true);
                } else {
                    $data['anuladas'] = $this->inventario_model->solicitudes_rechazadas($user, $where);
                    $html = $this->load->view('inventario/requisiciones/requisiciones_anuladas', $data, true);
                }

                // die(print_r($this->db->last_query()));
                echo json_encode(array('resultado' => $html));
            }
        }
    }

    function autorizacion_requisicion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $user = $this->tank_auth->get_user_id();
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->cargar_registros('bod_bodega', 'bod_estado', 1);
            $data['solicitudes'] = $this->inventario_model->historial_solicitudes($user);
            $data['pendientes'] = $this->inventario_model->historial_solicitudes3($user);
            $data['titulo_personal'] = 'Requisiciones pendientes de autorización';
            //var_dump($data); die();
            $this->_cargarvista(null, $data);
        }
    }

    function autorizar_req($rxi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->db->where('rxi_id', $rxi_id);
            $this->db->update('rxi_requisicion_inventario', array('rxi_estado' => 2, 'rxi_usu_mod' => $this->tank_auth->get_user_id(), 'rxi_fecha_mod' => date('Y-m-d H:i:s')));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición de articulos autorizada", 'texto_alerta' => "Ahora usted podrá ver la requisición en la pantalla de salida de artículos");

            $this->session->set_flashdata($alerta);
            redirect('inventario/requisiciones/autorizacion_requisicion');
        }
    }

    function mi_historial() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas'] = $this->inventario_model->cargar_registros('bod_bodega', 'bod_estado', 1);
            $data['solicitudes'] = $this->inventario_model->historial_solicitudes($this->tank_auth->get_user_id());
            $data['pendientes'] = $this->inventario_model->historial_solicitudes2($this->tank_auth->get_user_id());
            $data['titulo_personal'] = 'HISTORIAL DE REQUISICIONES';
            $this->_cargarvista(null, $data);
        }
    }

    function get_bodegas() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';

        //La categoria seleccionada en el proceso AJAX JSON
        $bodegas = $this->inventario_model->cargar_todo('bod_bodega');

        foreach ($bodegas as $fila) {
            $var .= "<option value='" . $fila['bod_id'] . "'>" . $fila['bod_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_categorias() {
        $option = "";
        $var = '<option>Seleccione una opción</option>';
        $bodega = $this->input->post('bodega_sel');
        $categorias = $this->inventario_model->get_categorias($bodega);

        foreach ($categorias as $key) {
            $var .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';

        //La categoria seleccionada en el proceso AJAX JSON
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->cargar_todo('art_articulo', array('art_id_tia' => $categoria));

        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "'>" . $fila['art_nombre'] . "</option>";
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos_catxbodega() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');

        $articulos = $this->inventario_model->get_productos_bodega_cantidad_salida($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_codigo'] . "--" . $fila['art_nombre'] . ' (' . $fila['sar_cant_actual'] . ')' . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos_catxbodega2() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->get_productos_bodega_cantidad_salida($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_nombre'] . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_productos_catxbodega_kardex() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->get_productos_bodega_cantidad_salida2($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_nombre'] . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function obtener_bodegas_articulos() {
        $id_articulo = $this->input->post('id_articulo');
        $id_solicitud = $this->input->post('id_solicitud');
        $cantidad_articulos = $this->inventario_model->get_cantidad_articulos_solicitud($id_articulo, $id_solicitud);
        $bodegas = $this->inventario_model->get_bodegas_articulos($id_articulo);
        $var = '<option value=""> Seleccione una opción </option>';
        foreach ($bodegas as $mostrar_bodegas) {
            $var .= '<option value = "' . $mostrar_bodegas['bod_id'] . '">' . $mostrar_bodegas['bod_nombre'] . '</option>';
        }

        $arreglo = array(
            "drop" => $var,
            "cantidad" => $cantidad_articulos[0]['dri_cantidad'],
        );
        echo json_encode($arreglo);
    }

    function get_productos_catxbodega_entrada() {
        $options = "";
        //$var ="<option value=''> seleccione una opcionasas </option>";
        $var = '<option> Seleccione una opción </option>';
        $bodega = $this->input->post('bodega_sel');
        $categoria = $this->input->post('categoria_sel');
        $articulos = $this->inventario_model->get_productos_bodega_cantidad_entrada($bodega, $categoria);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_nombre'] . ' (' . $fila['sar_cant_actual'] . ')' . "</option>";
            $etiqueta++;
        }


        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_tipo_articulos() {
        $option = "";
        $var = '<option>Seleccione una opción</option>';
        $bodega = $this->input->post('bodega');
        $categorias = $this->inventario_model->get_categorias($bodega);

        foreach ($categorias as $key) {
            $var .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function get_tipo_articulos_medicina() {
        $option = "";
        $var = '<option>Seleccione una opcion</option>';
        $bodega = $this->input->post('bodega');
        $categorias = $this->inventario_model->get_articulos_medicina($bodega);

        foreach ($categorias as $key) {
            $var .= "<option value='" . $key['art_id'] . "'>" . $key['art_nombre'] . ' (' . $key['sar_cant_actual'] . ')' . "</option>";
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }

    function modificar_cantidad() {
        $id_detalle = $this->input->get('identificador');
        $id_solicitud = $this->input->get('solicitud');

        $data['detalle'] = $id_detalle;
        $data['solicitud'] = $id_solicitud;

        $this->_cargarvista(null, $data);
    }

    function realizar_modificacion() {
        $bandera = false;
        $cantidad = $this->input->post('cantidad');
        $detalle = $this->input->post('detalle');
        $solicitud = $this->input->post('solicitud');


        $actualizar_cantidad_detalle = array('dri_cantidad' => convertirFloat($cantidad));

        $indicador = $this->gsatelite->actualizar('dri_detalle_requisicion_inventario', $actualizar_cantidad_detalle, 'dri_id', $detalle);

        if ($indicador != "") {
            $bandera = true;
        }

        echo json_encode($bandera);
    }

    function rechazar_solicitud() {
        $solicitud = $this->input->post('id_solicitud');
        $bandera = true;
        $eliminar_solicitud = array('rxi_estado' => 2);

        $indicador = $this->gsatelite->actualizar('rxi_requisicion_inventario', $eliminar_solicitud, 'rxi_id', $solicitud);

        if ($indicador != "") {
            $bandera = false;
        }

        echo json_encode($bandera);
    }

    function imprimir_boleta() {
        $data['id_req_show'] = $this->input->get('identificador');
        $data['detail'] = $this->inventario_model->cargar_req_detail($data['id_req_show']);
        //print_r($this->db->last_query());exit();
        $data['query'] = $this->inventario_model->productos_requisicion_rxi_new_1($data['id_req_show']);
        // die(print_r($this->db->last_query()));
        $data['pend'] = $this->input->get('pend');
        /* print_r($data['detail']['rxi_id_user']);
        exit(); */
        $data['user_info'] = $this->inventario_model->cargar_info_user($data['detail']['rxi_id_user']);
        $this->load->library('PDF');
        $this->load->library('EnLetras');
        $data['letras_solicitado'] = array();
        $data['letras_despachado'] = array();
        //print_r($this->enletras->ValorEnLetras(10124.65,""));//999999999 Limite de clase
        //exit();
        foreach ($data['query'] as $key => $valor) {
            $data['letras_solicitado'] = array_merge($data['letras_solicitado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad'], "")));

            if (isset($data['pend']) && $data['pend'] != '') {
                $data['letras_despachado'] = array_merge($data['letras_despachado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad_despacho'], "")));
            }
        }
        $aplica_estilos = ($this->gsatelite->get_parametro('SYS_EMPRESA') != 'CUSCATANCINGO') ? 1 : 0;
        $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $html = $this->load->view('inventario/requisiciones/generar_pdf', $data, true);
        $reporte = $this->pdf->reportePDF2($html, $aplica_estilos);
        /*    header("Content-Type: application/vnd.ms-excel");
          header("Expires: 0");
          header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
          header("content-disposition: attachment;filename=jujuju.xls");
          echo $html; */
      }

      function imprimir_requi_despa() {
        $data['id_req_show'] = $this->input->get('identificador');
        $data['detail'] = $this->inventario_model->cargar_req_detail($data['id_req_show']);     
        $data['query'] = $this->inventario_model->productos_requisicion_rxi_new_1($data['id_req_show']);
        $data['pend'] = $this->input->get('pend');
        /* print_r($data['detail']['rxi_id_user']);
        exit(); */
        $data['user_info'] = $this->inventario_model->cargar_info_user($data['detail']['rxi_id_user']);
        $this->load->library('PDF');
        $this->load->library('EnLetras');
        $data['letras_solicitado'] = array();
        $data['letras_despachado'] = array();
        //print_r($this->enletras->ValorEnLetras(10124.65,""));//999999999 Limite de clase
        //exit();
        foreach ($data['query'] as $key => $valor) {
            $data['letras_solicitado'] = array_merge($data['letras_solicitado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad'], "")));

            if (isset($data['pend']) && $data['pend'] != '') {
                $data['letras_despachado'] = array_merge($data['letras_despachado'], array($this->enletras->ValorEnLetras($valor['dri_cantidad_despacho'], "")));
            }
        }
        $aplica_estilos = ($this->gsatelite->get_parametro('SYS_EMPRESA') != 'CUSCATANCINGO') ? 1 : 0;
        //$aplica_estilos= ($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA')!='4') ? 1 : 0 ;
        //$aplica_estilos= 0;
        // $html = $this->load->view('inventario/requisiciones/generar_pdf',$data,true);
        $filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename'] = $filename;
        header("Content-Type: application/vnd.ms-excel");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("content-disposition: attachment;filename=" . $filename . ".xls");
        $html = $this->load->view('inventario/reportes/reporte_requicisiones_despachadas', $data, true);
        echo $html;
    }

    public function send_email($email) {
        $ci = get_instance();
        $ci->load->library('email');
        $config['protocol'] = "smtp";
        $config['smtp_host'] = "ssl://mail.gruposatelite.net";
        $config['smtp_port'] = "465";
        $config['smtp_user'] = $this->gsatelite->get_parametro('CORREO_ADMIN');
        $config['smtp_pass'] = "Nuevo1010";
        $config['charset'] = "utf-8";
        $config['mailtype'] = "html";
        $config['newline'] = "\r\n";

        $ci->email->initialize($config);

        $ci->email->from($this->gsatelite->get_parametro('CORREO_ADMIN'), $this->gsatelite->get_parametro('CORREO_ADMIN'));
        $list = array($email);
        $ci->email->to($list);
        $this->email->reply_to($this->gsatelite->get_parametro('CORREO_ADMIN'), '');
        $ci->email->subject('Requisición recibida');
        $ci->email->message('Estimado usuario usted tiene una requisición pendiente de despacho.');
        $ci->email->send();
    }

    public function get_conversiones_articulo($idProc = null, $flag = false) {

        $producto = ($idProc > 0) ? $idProc : $this->input->post('producto');

        $where = array('cva_id_art' => $producto, 'cva_estado'=>1);

        $conversiones = $this->inventario_model->get_conversiones_producto($where);
        $var = "<option value='0'>Seleccione</option>";
        $etiqueta = 0;
        foreach ($conversiones as $fila) {

            $selected = "";

            if ($fila['cva_defecto'] == 1) {
                $selected = "selected=selected";
            }

            $var .= "<option data-conv='" . $fila['cva_conversion'] . "' " . $selected . " value='" . $fila['cva_id'] . "' id='opt_conv" . $etiqueta . "'>" . $fila['mep_nombre'] . "</option>";
            $etiqueta++;
        }

        $arreglo = array('medidas' => $var);
        echo json_encode($arreglo);
    }

    function get_tipos_activos_fijo($idProc=null) {

        $producto = ($idProc > 0) ? $idProc : $this->input->post('producto');
        $bod_id = $this->input->post('bodega_sel');
        $tipos = $this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_estado' => 1));

        $opciones = "<option></option>";
        foreach ($tipos as $key) {
            $opciones .= "<option value='" . $key['tac_id'] . "'>" . $key['tac_nombre'] . "</option>";
        }

        if (count($tipos) == 0) {
            $opciones = "";
        }

        $sectores_html = "<option></option>";
        $sectores = $this->inventario_model->get_sector_grid($bod_id);
        foreach ($sectores as $ser) {
            $sectores_html .= "<option value='" . $ser['sxb_id'] . "' >" . $ser['seb_nombre'] . "</option>";
        }

        $arreglo = array(
            "drop" => $opciones,
            'sectores' => $sectores_html
        );

        echo json_encode($arreglo);
    }

    function get_activos_tipo($tipo_activo = null) {
        $tipo = ($tipo_activo != null) ? $tipo_activo : $this->input->post('tipo_activo');

        if ($tipo == '') {
            $productos = $this->gsatelite->get_tabla('act_activo_fijo');
        } else {
            $where = array('act_id_tac' => $tipo);
            $productos = $this->gsatelite->get_tabla('act_activo_fijo', $where);
        }

        //print_r($this->db->last_query());die();

        $etiqueta = 0;
        $opciones = "<option></option>";
        foreach ($productos as $fila) {
            $opciones .= "<option data-codigo='" . $fila['act_codigo'] . "' value='" . $fila['act_id'] . "' id='opt_prod" . $etiqueta . "'>" .$fila['act_codigo']. ' - '. $fila['act_nombre'] . "</option>";
            $etiqueta++;
        }

        if (count($productos) == 0) {
            $opciones = "";
        }
        $arreglo = array('activos' => $opciones);
        echo json_encode($arreglo);
    }

    function get_hijos_tipos_servicio($flag = false, $where = null, $where_servicios = null) {

        $opciones = '<option value="">Seleccione una opción</option>';


        $padre = ($this->input->post('padre') != '') ? $this->input->post('padre') : null;
        if ($_POST) {
            $where['tia_padre'] = $padre;
        }


        if ($padre != null) {
            $where_servicios['art_id_tia'] = $padre;
        }

        $categorias = $categorias = $this->gsatelite->get_tabla('tia_tipo_articulo', $where);


        $servicios = $this->inventario_model->artxcategorias(null, $padre, 'entrada');
        $this->db->where('art_tipo', 1);
        //var_dump($servicios);die();
        //$servicios = $this->inventario_model->get_servicios_inventario($where_servicios);
        //print_r($this->db->last_query());die();
        foreach ($categorias as $key) {
            $opciones .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
        }

        $servicios_opc = '<option value="">Seleccione una opción</option>';

        foreach ($servicios as $key) {
            $servicios_opc .= "<option data-codigo='" . $key['sri_codigo'] . "' value='" . $key['sri_id'] . "'>" . $key['sri_nombre'] . "</option>";
        }

        if (count($categorias) == 0) {
            $opciones = "";
        }

        if (count($servicios) == 0) {
            $servicios_opc = "";
        }

        $arreglo = array(
            "drop" => $opciones,
            'servicios' => $servicios_opc
        );

        echo json_encode($arreglo);
    }

    function enviar_autorizacion($iframe = false, $registro, $tipo_flujo) {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //var_dump($_POST);die();
                $post_array = $_POST;
                $paso_actual = $post_array['hdnActualPaso'];
                $paso_siguiente = $post_array['hdnSigPaso'];
                $txtComentario = $post_array['txtComentario'];

                //Se cierra el paso actual y se ingresa el siguiente paso si existe
                //Se cierra el paso actual
                $seguimiento_requisicion = array(
                    'sgr_id_usu' => $this->tank_auth->get_user_id(),
                    'sgr_observacion' => $txtComentario,
                    'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                    'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                );

                $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));

                //Si existe un siguiente paso se ingresa
                if ($paso_siguiente > 0) {
                    $seguimiento_requisicion = array(
                        'sgr_id_rxi' => $registro,
                        'sgr_id_psf' => $paso_siguiente,
                        'sgr_id_usu' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgr_estado' => 1,
                        'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                        'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                    );

                    $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                    if ($seguimiento > 0) {

                        $requisicion_array = array(
                            'rxi_estado' => 2,
                            'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rxi_fecha_modificacion' => date('Y-m-d h:i:s')
                        );

                        $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $requisicion_array, array('rxi_id' => $registro));
                    }
                }

                //Si es iframe se enviar un parametro para cerrar el modal
                //Sino se redirecciona a la url configurada
                if ($iframe == 1) {
                    $data['cerrar_modal'] = 1;
                    $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                } else {
                    $redireccionar = $post_array['redireccion'];
                    // $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Tarea Finalizada", 'texto_alerta' => "El registro se procesó correctamente");
                    // $this->session->set_flashdata($alerta);
                    redirect($redireccionar);
                }
            }
            $data['titulo_personal'] = "Siguiente Paso";
            $data['iframe'] = $iframe;
            $data['registro'] = $registro;
            $data['tipo_flujo'] = $tipo_flujo;

            $paso_actual = $this->inventario_model->get_paso_actual($registro, $tipo_flujo);
            $paso_siguiente = $this->inventario_model->get_paso_siguiente($registro, $tipo_flujo);
            //var_dump($paso_actual);die();
            $data['paso_actual'] = $paso_actual[0];
            $data['paso_siguiente'] = $paso_siguiente[0];

            $data['nombre_registro'] = $this->gsatelite->get_campo('rxi_requisicion_inventario', 'rxi_numero', array('rxi_id' => $registro));
            $data['titulo_registro'] = "Requisición N.";
            if ($iframe) {
                $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/enviar_autorizacion', $data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    function ver_detalle_req($iframe = 0, $id = null, $estado = null) {
        satelite_validar();
        $data['iframe'] = $iframe;
        $requisicion    = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $id));
        $data['requisicion'] = $requisicion[0];
        if ($requisicion[0]['rxi_id_ord'] != "") {
            $this->load->model('proyecto_model');
            $data['orden'] = $this->proyecto_model->get_orden(array('ord_id' => $requisicion[0]['rxi_id_ord']));
        } else {
            $data['orden'] = array();
        }
        //cantidad_minima_prod
        $where = array(
            'dri_id_rxi' => $id
        );
        $data['ver_existencias'] = $this->gsatelite->get_parametro_emp('SYS_REQUISICION_MOSTRAR_SALDO', '1');
        $data['solicitante']         = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $requisicion[0]['rxi_id_emp']));
        $data['bodega']              = $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $requisicion[0]['rxi_id_bod']));
        $data['detalle_requisicion'] = $this->inventario_model->get_requisicion_detalle($where);
        $data['decimales']           = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
        $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/detalle_requisicion', $data, true);
    }

    function get_documento_proveedor($flag = null) {
        // $documento_dpv = $this->gsatelite->get_tabla("dpv_documento_proveedor", array("dpv_id_orc !=" => null, "dpv_estado" => 1));
        // $productos_dxd = $this->gsatelite->get_tabla("dxd_detalle_documento_proveedor", array("dxd_id_dpv" => $documento_dpv[0]["dpv_id"]));
        //"dxd_procesado_inventario"
        if ($flag) {
            //"dpv_id_orc is null" => null, 'dpv_afecta_inventario'=>1, 'dpv_id_prv'=>$prv_id, "dxd_procesado_inventario" => 0, 'dpv_estado' => 1
            $dpv_bodega = $this->inventario_model->get_dpv_bodega(array('dpv_estado >' => 0, 'dpv_tipo !=' => 3,'dpv_afecta_inventario !=' => 1));
        } else {
            $prv_id = $this->input->post('proveedor');
            if ($prv_id > 0) {
                //"dpv_id_orc is null" => null, 'dpv_afecta_inventario'=>1, "dxd_procesado_inventario" => 0,
                $dpv_bodega = $this->inventario_model->get_dpv_bodega(array('dpv_id_prv' => $prv_id,  'dpv_estado >=' => 1, 'dpv_afecta_inventario !=' => 1));
            } else {
                $dpv_bodega = $this->inventario_model->get_dpv_bodega(array('dpv_estado >' => 0, 'dpv_tipo !=' => 3, 'dpv_afecta_inventario !=' => 1));
            }            
        }
        // $bodega = 0;
        // if (count($productos_dxd) != 0) {
        //     $bodega = $productos_dxd[0]["dxd_id_bod"];
        // }
        $select = '<option value=""></option>';
        $contador_dpv = 1;
        foreach ($dpv_bodega as $key) {
            $orc = ($key['dpv_id_orc'] != '') ? $key['dpv_id_orc'] : 0;
            $select .= '<option bodega="'.$key["bod_id"].'" doc_pro = "'.$key["dpv_id"].'" doc_orc = "'.$orc.'" value="'.$contador_dpv++.'">'.$key["dpv_numero_documento"].' - '.$key["proveedor"].'</option>';
        }
        // $datos_doc_prv = $this->gsatelite->get_tabla('dpv_documento_proveedor', array('dcp_estado' => 1, 'dcp_id_prv' => $prv_id));
        // $select = '<option value=""></option>';
        // foreach ($datos_doc_prv as $key) {
        //     if ($selected == $key['dcp_id']) {
        //         $select .= '<option value="' . $key['dcp_id'] . '" selected>' . $key['dcp_valor'] . '</option>';
        //     } else {
        //         $select .= '<option value="' . $key['dcp_id'] . '">' . $key['dcp_valor'] . '</option>';
        //     }
        // }
        if ($flag) {
            return $select;
        } else {
            echo json_encode(array('resp' => $select));
        }        
    }

    function get_sector_bodega($selected = null) {
        $bod_id = $this->input->post('bodega');
                            $this->db->where('sxb_estado', 1);
        $datos_sector_bod = $this->inventario_model->get_sector_grid($bod_id);
        $select = '<option value=""></option>';
        foreach ($datos_sector_bod as $key) {
            if ($selected == $key['sxb_id']) {
                $select .= '<option value="' . $key['sxb_id'] . '" selected>' . $key['seb_nombre'] . '</option>';
            } else {
                $select .= '<option value="' . $key['sxb_id'] . '">' . $key['seb_nombre'] . '</option>';
            }
        }
        echo json_encode(array('resp' => $select));
    }

    function get_medida_defecto() {
        $art_id = $this->input->post('producto');
        $where['sar_id_art'] = $art_id;
        $datos_cva_medida = $this->inventario_model->get_medida($art_id, 1);
        $select = '<option value=""></option>';
        foreach ($datos_cva_medida as $key) {
            if ($key['cva_defecto'] == 1) {
                $select .= '<option value="' . $key['cva_id'] . '" selected>' . $key['mep_nombre'] . '</option>';
                $where['cva_id_mep'] = $key['cva_id_mep'];
            } else {
                $select .= '<option value="' . $key['cva_id'] . '">' . $key['mep_nombre'] . '</option>';
            }
        }
        $datos = $this->facturacion_model->get_valor_ultima_entrada($where);
        $valor = (isset($datos['sar_precio']) && $datos['sar_precio'] != NULL) ? $datos['sar_precio'] : "";
        echo json_encode(array('resp' => $select, 'ultima' => $valor));
    }

    function obtener_productos_tia() {
        $tia_id = $this->input->post('categoria');
        $tipo = $this->input->post('tipo');
        $bod=0;
        $select_producto = "<option value=''></option>";
        if ($tipo == 1) {
            $productos = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_inventario' => 1, 'art_id_tia' => $tia_id));
            foreach ($productos as $key) {
                $select_producto .= '<option value="' . $key['art_id'] . '">'.$key['art_codigo'].' - '. $key['art_nombre'] . '</option>';
            }
        } else {
            $bod_id = $this->input->post('bodega');
            $sector = (trim($this->input->post('sector')) != "") ? $this->input->post('sector') : null;
            $productos = $this->inventario_model->get_cantidad_bodega($tia_id, $bod_id, $sector);
            if($bod_id<=0){ $bod=1; }
            if ($sector != null) {
                foreach ($productos as $key) {
                    $select_producto .= '<option value="' . $key['art_id'] . '" cant="' . round($key['cantidad'], 2) . '">'.$key['art_codigo'].' - '. $key['art_nombre'] . '&nbsp;(' . round($key['cantidad'], 2) . ')</option>';
                }
                /*
                  // sector null para que muestre toda la cantidad existente
                  $productos_filtro = $this->inventario_model->get_cantidad_bodega($tia_id, $bod_id, $sector, $productos[0]['art_id']);
                  foreach ($productos_filtro as $key) {
                  $select_producto .= '<option value="'.$key['art_id'].'" cant="'.round($key['cantidad'], 2).'">'.$key['art_nombre'].'&nbsp;('.round($key['cantidad'], 2).')</option>';
              } */
          } else {
            foreach ($productos as $key) {
                $select_producto .= '<option value="' . $key['art_id'] . '" cant="' . round($key['cantidad'], 2) . '">'.$key['art_codigo'].' - '.$key['art_nombre'] . '&nbsp;(' . round($key['cantidad'], 2) . ')</option>';
            }
        }
    }

    if (count($productos) == 0) {
        $select_producto = "<option value=''></option>";
    }

    $hijos = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_padre' => $tia_id));
    $select_categoria = "<option value=''></option>";
    $cat_hijo = 0;
    foreach ($hijos as $key1) {
        $cat_hijo = 1;
        $select_categoria .= '<option value="' . $key1['tia_id'] . '">'.$key1['tia_codigo'].' - '. $key1['tia_nombre'] . '</option>';
    }
    if (count($hijos) == 0) {
        $cat_hijo = 0;
        $select_categoria = "<option value=''></option>";
    }

    $arreglo = array('producto' => $select_producto, 'categoria' => $select_categoria, 'cat_hijo' => $cat_hijo, 'bodega'=>$bod);
    echo json_encode($arreglo);
}

function obtener_sectores_producto() {
    $bodega_id = $this->input->post('bodega');
    $sector_id = $this->input->post('sector');
    $producto_id = $this->input->post('id');
    $cantidad = 0;
    $productos_filtro = $this->inventario_model->get_cantidad_bodega(null, $bodega_id, $sector_id, $producto_id);
    if (count($productos_filtro) > 0) {
        $cantidad = $productos_filtro[0]['cantidad'];
    }
    $arreglo = array('resp' => $cantidad);
    echo json_encode($arreglo);
}

function get_codigo_cva() {
    $art_id = $this->input->post('producto');
    $cva_id = $this->input->post('medida');

    $productos = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
    $codigo_art = ($productos[0]['art_codigo'] != null) ? $productos[0]['art_codigo'] : '';
    $nombre_art = $productos[0]['art_nombre'];

    $medidas = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_estado' => 1, 'cva_id' => $cva_id, 'cva_id_art' => $art_id));
    $conversion = $medidas[0]['cva_conversion'];

    $medidas2 = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_estado' => 1, 'cva_id_art' => $art_id, 'cva_defecto' => 1));
    $defecto = $medidas2[0]['cva_conversion'];
    $id_cva_mep = $medidas2[0]['cva_id_mep'];
    $mep_nombre = $this->gsatelite->get_tabla('mep_medida_producto', array('mep_estado' => 1, 'mep_id' => $id_cva_mep));
    $defecto_nom = $mep_nombre[0]['mep_nombre'];

    $arreglo = array('codigo' => $codigo_art, 'conversion' => $conversion, 'defecto' => $defecto, 'nombre' => $nombre_art, 'defecto_nom' => $defecto_nom);
    echo json_encode($arreglo);
}

function get_cantidad_producto() {
    $bod_id = $this->input->post('bodega');
    $art_id = $this->input->post('producto');
    $cantidad = $this->inventario_model->get_cantidad_bodega(null, $bod_id, null, $art_id);
        // print_r($this->db->last_query());die();  
    if (count($cantidad) > 0) {
        $arreglo = array('cantidad' => $cantidad[0]['cantidad'], 'cva' => $cantidad[0]['cva_conversion'], 'nombre_cva' => $cantidad[0]['mep_nombre'], 'id_conv' => $cantidad[0]['cva_id'], 'minimo'=>$cantidad[0]['minimo'], 'maximo'=>$cantidad[0]['maximo'] );
        echo json_encode($arreglo);
    } else {
        $arreglo = array('cantidad' => 0);
        echo json_encode($arreglo);
    }
}

function cargar_requisicion($rxi_id = null, $tipo = null) {
    $dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
    $rxi_id = ($rxi_id) ? $rxi_id : $this->input->post('requisicion_rxi');
    $requisiciones = $this->inventario_model->mostrar_requisicion_salida($rxi_id);
    $tabla = "";
    $bodega = "";
    $sucursal = "";
    $sucursal_id = "";
    $select_sector = "";
    $orden = "";
    $art_orden = "";
    $contador = 0;
    $sectores = $this->inventario_model->get_sector_grid($requisiciones[0]['rxi_id_bod']);
    foreach ($sectores as $key_sect) {
        $select_sector .= '<option value="' . $key_sect['sxb_id'] . '">' . $key_sect['seb_nombre'] . '</option>';
    }
    if ($requisiciones[0]['rxi_id_ord'] != "") {
        $this->load->model('proyecto_model');
        $data_orden = $this->proyecto_model->get_orden(array('ord_id' => $requisiciones[0]['rxi_id_ord']));
        if (count($data_orden) > 0) {
            $articulos = array();
            $orden = $data_orden[0]['ord_codigo'];
            foreach ($data_orden as $key => $value) {
                array_push($articulos, ($value['art_codigo'] . ' - ' . $value['art_nombre']));
            }
            $art_orden = implode(',', $articulos);
        }
    }
    foreach ($requisiciones as $key) {
        $bodega = $key['rxi_id_bod'];
        $cantidad_restante = $key['dri_cantidad'] - $key['dri_cantidad_despacho'];
        $text_producto_dest = $key['art_codigo'].' - '.$key['art_nombre'];
        $id_producto_dest = '<input type="hidden" name="producto_destino[]" value="'.$key['art_id'].'" />';

        /*************************** Dropdown código de lotes *******************************************/
        $lotes = $this->inventario_model->get_cantidadxlote(array('art_id'=>$key['art_id'], 'sar_id_bod'=>$bodega));
        $drop_lote = '<option value=""></option>';
        if(count($lotes)>0){
            foreach ($lotes as $lot) {
                if($lot['dee_codigo_lote']!='' && $lot['cant'] > 0){
                    $drop_lote .= '<option value="'.$lot['dee_codigo_lote'].'" data-cant="'.$lot['cant'].'">'.$lot['dee_codigo_lote'].' ('.$lot['cant'].') </option>';
                }
            }
        }
        $tabla .= "<tr id='fila_".$contador."'>";
        $tabla .= "<td>" . $key['art_codigo'] . "</td>";
        $tabla .= "<td><input type='hidden' class='id_art_rxi' data-fila='fila_".$contador."' value='" . $key['art_id'] . "' name='producto_art[]' />" . $key['art_nombre'] . "</td>";
        $tabla .= '<td><select name="codigo_lote[]" valor="' . $key['art_id'] . '" class="select_lote" id="lote' . $key['art_id'] . '" style="width: 100%;" placeholder="Seleccione"><option value=""></option>' . $drop_lote . '</select></td>';
        if ($key['cva_defecto'] > 0) {
            $cva_id = $key['cva_id'];
            $mep_nombre = $key['mep_nombre'];
        } else {            
            $cva_id = $this->gsatelite->get_campo('cva_conversion_articulo', 'cva_id', array('cva_id_art' => $key['art_id'], 'cva_defecto' => 1)); 
                          $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id', 'INNER');
            $mep_nombre = $this->gsatelite->get_campo('mep_medida_producto', 'mep_nombre', array('cva_id_art' => $key['art_id'], 'cva_defecto' => 1));
            $cantidad_restante = ($cantidad_restante * $key['cva_conversion']);
        }        
        $tabla .= "<td><input type='hidden' value='" . $cva_id . "' cva='" . $key['cva_conversion'] . "' name='medida_cva[]' id='rxi_mep" . $key['art_id'] . "' />" . $mep_nombre . "</td>";
        $tabla .= "<td><input type='hidden' id='cantidad_req_" . $key['art_id'] . "' name='cantidad_maxima[]' /><label style='font-size:medium'></label></td>";
        if (is_null($tipo)) {
            $tabla .= '<td style="text-align: right;"><input type="hidden" class="costos_unit" value="' . number_format($key['costo'], $dec, '.','') . '" >$' . number_format($key['costo'], $dec) .  '</td>';
        }
        $tabla .= "<td><input type='text' class='validar_cantidad' value='" . $cantidad_restante . "' name='cantidad_dee[]' cant_def='" . $cantidad_restante . "' id='" . $key['art_id'] . "'><input type='hidden' value='' name='cantidad_dee_conv[]' id='dee_conv" . $key['art_id'] . "'></td>";
        if (is_null($tipo)) {
            $tabla .= '<td style="text-align: right;"><input type="hidden" class="costos_produc" value="' . number_format(($key['costo'] * $cantidad_restante), $dec, '.','') . '" >$<span class="cto_lbl">' . number_format(($key['costo'] * $cantidad_restante), $dec) .  '</span></td>';
        }
        if($tipo != null){
            $tabla .= '<td>'.$id_producto_dest.$text_producto_dest.'</td>';
        }
        if (is_null($tipo)) {
            $tabla .= '<td><select name="sector_sxb[]" valor="' . $key['art_id'] . '" class="grid_select" id="seleccion' . $key['art_id'] . '" style="width: 100%;" placeholder="Seleccione"><option value=""></option>' . $select_sector . '</select></td>';
        }
        $sucursal = $key['suc_nombre'];
        $sucursal_id = $key['suc_id'];
        $contador++;
    }
    echo json_encode(array('resp' => $tabla, 'bodega' => $bodega, 'sucursal' => $sucursal, 'sucursal_id' => $sucursal_id, 'orden' => $orden, 'art_orden' => $art_orden));
}

function cargar_detalle_facturacion($fac_id=null) {
    $fac_id = ($fac_id) ? $fac_id : $this->input->post('documento_cliente');
    $requisiciones = $this->inventario_model->mostrar_detalle_factura(array('def_id_fac'=>$fac_id));
    $tabla = "";
    $bodega = "";
    $sucursal = "";
    $sucursal_id = "";
    $select_sector = "";
    $bodega_factura = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
    $sectores = $this->inventario_model->get_sector_grid($bodega_factura);
    foreach ($sectores as $key_sect) {
        $select_sector .= '<option value="' . $key_sect['sxb_id'] . '">' . $key_sect['seb_nombre'] . '</option>';
    }
                  $this->db->join('suc_sucursal', 'suc_id = bod_id_suc', 'inner');
    $sucursales = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $bodega_factura));
    foreach ($requisiciones as $key) {
        $cantidad_restante = $key['def_cantidad'];
        $tabla .= '<tr>';
        $tabla .= '<td>' . $key['art_codigo'] . '</td>';
        $tabla .= '<td><input type="hidden" name="producto_art[]" class="id_art_rxi" value="'.$key['art_id'].'"><span>'.$key['art_nombre'].'</span></td>';
        $tabla .= '<td></td>'; //No posee lote para inventario
        $tabla .= '<td><input type="hidden" name="medida_cva[]" cva="'.$key['cva_conversion'].'" value="'.$key['cva_id'].'" id="rxi_mep'.$key['art_id'].'">';
        $tabla .= '<span>'.$key['mep_nombre'].'</span></td>';
        $tabla .= '<td><input type="hidden" name="cantidad_maxima[]" id="cantidad_req_'.$key['art_id'].'" ><label style="font-size: medium;"></label></td>';
        $tabla .= '<td style="text-align: right;"><input type="hidden" class="costos_unit" value="' . number_format($key['costo'], 2,'.','') . '" >$' . number_format($key['costo'], 2) . '</td>';
        // $tabla .= '<td><span id="costo_req_'.$key['art_id'].'"><span></td>'; //COSTO SAR
        $tabla .= '<td><input type="text" class="validar_cantidad" value="' . number_format($cantidad_restante, 2, '.', '') . '" name="cantidad_dee[]" cant_def="' . number_format($cantidad_restante, 2 ,'.', '') . '" id="' . $key['art_id'] . '" readonly></td>';
        $tabla .= '<td style="text-align: right;"><input type="hidden" class="costos_produc" value="' . number_format(($key['costo'] * $cantidad_restante), 2, '.','') . '" >$<span class="cto_lbl">' . number_format(($key['costo'] * $cantidad_restante), 2) .  '</span></td>';
        // $tabla .= '<td><span id="subtot_req_'.$key['art_id'].'"><span></td>'; //CTDAD ACTUAL * COSTO SAR
        $tabla .= '<td><select name="sector_sxb[]" valor="' . $key['art_id'] . '" class="grid_select" id="seleccion' . $key['art_id'] . '" style="width: 100%;" placeholder="Seleccione"><option value=""></option>' . $select_sector . '</select></td>';
        }
        echo json_encode(array('resp' => $tabla, 'bodega' => $bodega_factura, 'sucursal' => $sucursales[0]['suc_nombre'], 'sucursal_id' => $sucursales[0]['suc_id']));
    }

    function cargar_orden_compra($orc_id) {
        $orc_id             = $this->input->post('orden_compra_orc');
        $tipo               = $this->input->post('tipo');
        $orden_compra_prv   = $this->gsatelite->get_tabla('orc_orden_compra', array("orc_id" =>$orc_id));
        $cantidad_decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $orden_compra = $this->inventario_model->mostrar_orden_compra_entrada(array("dor_id_orc" => $orc_id, "dor_estado"=>1));
        $tabla = "";
        $bodega = "";
        $sucursal = "";
        $sucursal_id = "";
        $contador = 0;
        foreach ($orden_compra as $key) {
            if ($key['dor_cantidad_entregada'] != $key['dor_cantidad']) {
                $cantidad_restante = $key['dor_cantidad'] - $key['dor_cantidad_entregada'];
                $cantidad_convertida = $cantidad_restante * ($key['cva_conversion'] / $key['cva_defecto_actual']);
                $precio_convertida = ($key['cva_conversion'] / $key['cva_defecto_actual']);

                $precio_desc = number_format($key["dor_precio_unitario"]-($key["dor_precio_unitario"]*($key['dor_descuento']/100)), 2);

                $tabla .= "<tr>";
                $tabla .= "<td>" . $key['art_codigo'] . "</td>";
                $tabla .= "<td><input type='hidden' class='id_art_rxi' value='" . $key['art_id'] . "' name='producto_art[]' />" . $key['art_nombre'] . "</td>";
                $tabla .= "<td></td>";
                $tabla .= "<td><input type='hidden' value='" . $key['cva_id'] . "' cva_defecto='" . $key['cva_defecto_actual'] . "' cva='" . $key['cva_conversion'] . "' name='medida_cva[]' id='rxi_mep" . $key['art_id'] . "' />" . $key['mep_nombre'] . "</td>";
                //$tabla .= "<td><input type='hidden' id='cantidad_req_".$key['art_id']."' name='cantidad_maxima[]' /><label style='font-size:medium'></label></td>";
                $tabla .= "<td width='8%'>
                <input type='hidden' style='width:100%' value='" . $cantidad_convertida . "' name='cantidad_dee[]'>
                <input type='hidden' style='width:100%' value='" . $cantidad_restante . "' name='cantidad_dee_original[]'>
                <input type='text' decimales='".$cantidad_decimales."' style='width:100%' class='validar_cantidad soloDecimales' value='" . number_format($cantidad_restante, $cantidad_decimales) . "' cant_def='" . number_format($cantidad_restante, $cantidad_decimales) . "' id='" . $key['art_id'] . "'>
                </td>";
                $tabla .= "<td>
                <input type='hidden' name='precio_dee[]' value='" . ($precio_desc / $precio_convertida) . "'>
                <input type='hidden' id='dor_unitario" . $key["art_id"] . "' value='" . $precio_desc . "'> $" . $precio_desc . "
                </td>";
                $tabla .= "<td><input type='hidden' id='dor_total" . $key["art_id"] . "' class='costos_produc' name='costo_total[]' value='" . $key["dor_subtotal"] . "' /><label style='font-size:medium'>$" . number_format(($cantidad_restante * $precio_desc), 2) . "</label></td>";
                $tabla .= '<td><input type="text" class="fecha_general" name="fecha_dee[]" /></td>';
                $tabla .= '<td><select name="sector_sxb[]" class="grid_select" id="seleccion' . $key['art_id'] . '" style="width: 100%;" placeholder="Seleccione"><option value=""></option></select></select></td>';

                $contador += ($cantidad_restante * $precio_desc);
                /* $bodega = $key['cva_defecto_actual'];
                  $sucursal = $key['suc_nombre'];
                  $sucursal_id = $key['suc_id'];
                  , 'bodega'=>$bodega, 'sucursal'=>$sucursal, 'sucursal_id'=>$sucursal_id */
              }
          }
          echo json_encode(array('resp' => $tabla, "total" => number_format($contador, 2),'id_prv' => $orden_compra_prv[0]['orc_id_prv']));
      }


    function cargar_nota_remision() {
        $moi_id = $this->input->post('id_moi');
        $mov_salida = $this->inventario_model->get_detalles_nota_remision(array('moi_id' => $moi_id));
        $dec = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $tabla = "";
        $contador = 0;
        foreach ($mov_salida as $key => $val) {
            $cantidad_convertida = $val['dee_cantidad'] * ($val['cva_conversion'] / $val['dfct']);
            $precio_convertida = $val['dee_precio'] / ($val['cva_conversion'] / $val['dfct']);
            $tabla .= "<tr>";
            $tabla .= "<td>" . $val['art_codigo'] . "</td>";
            $tabla .= "<td><input type='hidden' value='" . $val['art_id'] . "' name='producto_art[]' />" . $val['art_nombre'] . "</td>";
            $tabla .= "<td></td>";
            $tabla .= "<td><input type='hidden' value='" . $val['cva_id'] . "' cva_defecto='" . $val['dfct'] . "' cva='" . $val['cva_conversion'] . "' name='medida_cva[]' id='rxi_mep" . $val['art_id'] . "' />" . $val['mep_nombre'] . "</td>";
            $tabla .= "<td><input type='hidden' value='" . $cantidad_convertida . "' name='cantidad_dee[]'><input type='hidden' value='" . $cantidad_convertida . "' name='cantidad_dee_original[]'>";
            $tabla .= "<input type='text' decimales='".$dec."' style='width:100%' class='validar_cantidad soloDecimales' value='" . number_format($cantidad_convertida, $dec,'.','') . "' cant_def='" . number_format($cantidad_convertida, $dec,'.','') . "' id='" . $val['art_id'] . "' readonly></td>";
            $tabla .= "<td><input type='hidden' name='precio_dee[]' value='" . $precio_convertida . "'>$" . number_format($precio_convertida, $dec) . "</td>";
            $tabla .= "<td><input type='hidden' id='dee_total" . $val["art_id"] . "' class='costos_produc' name='costo_total[]' value='" . $val["dee_subtotal"] . "' /><label style='font-size:medium'>$" . number_format(($cantidad_convertida * $precio_convertida), 2) . "</label></td>";
            $tabla .= '<td><input type="text" class="fecha_general" name="fecha_dee[]" /></td>';
            $tabla .= '<td><select name="sector_sxb[]" class="grid_select" id="seleccion' . $val['art_id'] . '" style="width: 100%;" placeholder="Seleccione"><option value=""></option></select></select></td>';
            $tabla .= "</tr>";
            $contador += number_format(($cantidad_convertida * $precio_convertida), 2);
        }
        echo json_encode(array('resp' => $tabla, "total" => number_format($contador, 2)));
    }

    function cargar_orden_compra_dpv($orc_id = null) {
        $dpv_id = $this->input->post('documentos_dcp');
        $bod_id = $this->input->post('bodegas_dcp');
        $tipo = $this->input->post('tipo');

        $orden_compra = $this->inventario_model->mostrar_orden_compra_dpv(array("dxd_id_dpv" => $dpv_id, "dxd_id_bod" => $bod_id, 'art_inventario'=>1));
        // Definicion de variables
        $id_dpv = $orden_compra[0]['dxd_id_dpv'];
        $id_prv = $this->gsatelite->get_tabla('dpv_documento_proveedor', array("dpv_id" =>$id_dpv));

        $tabla      = "";
        $bodega     = "";
        $sucursal   = "";
        $sucursal_id= "";
        $contador   = 0;

        foreach ($orden_compra as $key) {
            $cantidad_restante = $key['dxd_cantidad'];
            $cantidad_convertida = $cantidad_restante * ($key['cva_conversion'] / $key['cva_defecto_actual']);
            $precio_convertida = ($key['cva_conversion'] / $key['cva_defecto_actual']);

            $precio_desc = $key["dxd_precio_unitario"]-($key["dxd_precio_unitario"]*($key["dxd_descuento"]/100));

            $tabla .= "<tr>";
            $tabla .= "<td>" . $key['art_codigo'] . "</td>";
            $tabla .= "<td><input type='hidden' class='id_art_rxi' value='" . $key['art_id'] . "' name='producto_art[]' />" . $key['art_nombre'] . "</td>";
            $tabla .= "<td><input type='text' id='codigo_lote_".$key['art_id']."' name='codigo_lote[]' value='' style='width: 140px;' maxlength='99'></td>";
            $tabla .= "<td><input type='hidden' value='" . $key['cva_id'] . "' cva_defecto='" . $key['cva_defecto_actual'] . "' cva='" . $key['cva_conversion'] . "' name='medida_cva[]' id='rxi_mep" . $key['art_id'] . "' />" . $key['mep_nombre'] . "</td>";
            $tabla .= "<td width='8%'>
            <input type='hidden' style='width:100%' value='" . $cantidad_convertida . "' name='cantidad_dee[]'>
            <input type='text' style='width:100%' class='validar_cantidad' value='" . number_format($cantidad_restante, 2) . "' cant_def='" . number_format($cantidad_restante, 2) . "' id='" . $key['art_id'] . "' readonly>
            </td>";
            $tabla .= "<td>
            <input type='hidden' name='precio_dee[]' value='" . ($precio_desc / $precio_convertida) . "'>
            <input type='hidden' id='dor_unitario" . $key["art_id"] . "' value='" . $precio_desc . "'> $" . number_format($precio_desc, 2) . "
            </td>";
            $tabla .= "<td><input type='hidden' id='dor_total" . $key["art_id"] . "' class='costos_produc' name='costo_total[]' value='" . ($cantidad_restante * $precio_desc) . "' /><label style='font-size:medium'>$" . number_format(($cantidad_restante * $precio_desc), 2) . "</label></td>";
            $tabla .= '<td><input type="text" class="fecha_general" name="fecha_dee[]" style="width: 120px;"/></td>';
            $tabla .= '<td><select name="sector_sxb[]" class="grid_select" id="seleccion' . $key['art_id'] . '" style="width: 100%;" placeholder="Seleccione" data-sector="'.$key['sxb_id'].'"><option value=""></option></select></td>';
            $contador += ($cantidad_restante * $precio_desc);
        }
        echo json_encode(array('resp'=> $tabla,"total"=> number_format($contador, 2),'dpv_numero'=> (count($orden_compra)>0)?$orden_compra[0]['dpv_numero']:'',"id_prv"=>$id_prv[0]['dpv_id_prv']));
    }

    public function cargar_documento() {
        $orc_id = $this->input->post('orden_compra_orc');

        $documento_dpv = $this->gsatelite->get_tabla("dpv_documento_proveedor", array("dpv_id_orc" => $orc_id, "dpv_estado" => 1));
        $productos_dxd = $this->gsatelite->get_tabla("dxd_detalle_documento_proveedor", array("dxd_id_dpv" => $documento_dpv[0]["dpv_id"]));
        //"dxd_procesado_inventario"
        $dpv_bodega = $this->inventario_model->get_dpv_bodega(array("dpv_id_orc" => $orc_id, "dxd_procesado_inventario" => 0, 'dpv_estado' => 1));
        $bodega = 0;
        if (count($productos_dxd) != 0) {
            $bodega = $productos_dxd[0]["dxd_id_bod"];
        }

        $select = '<option value=""></option>';
        $contador_dpv = 1;
        foreach ($dpv_bodega as $key) {
            $select .= '<option bodega="' . $key["bod_id"] . '" doc_pro = "' . $key["dpv_id"] . '" value="' . $contador_dpv++ . '">' . $key["dpv_numero_documento"] . ' - ' . $key["proveedor"] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    function cargar_sector_selected() {
        $datos_productos = $ids = array();
        $bod_id = $this->input->post('bodega');
        $sxb_id = $this->input->post('sector');
        $art_id = $this->input->post('producto');
                            $this->db->where('sxb_estado', 1);
        $datos_sector_bod = $this->inventario_model->get_sector_grid($bod_id);
        if ($art_id > 0) {
            $datos_productos = $this->inventario_model->get_sector_producto(array('moi_id_bod' => $bod_id, 'sar_id_art' => $art_id));
        }
        ///////////////////////////////////////////////// SERA INUTIL YA???
        $select = '<option value=""></option>';
        foreach ($datos_sector_bod as $key) {
            $sltd = ($key['sxb_id'] == $sxb_id) ? 'selected' : '';
            $select .= '<option value="' . $key['sxb_id'] . '" ' . $sltd . ' >' . $key['seb_nombre'] . '</option>';
        }
        if (count($datos_productos) > 0) {
                        ///////////////////////////////////////////////// SERA INUTIL YA???
        }
        echo json_encode(array('resp' => $select));
    }

    function cargar_sector_traslado_selected() {
        $bod_id = $this->input->post('bodega');
        $sxb_id = $this->input->post('sector');
                            $this->db->where('sxb_estado', 1);
        $datos_sector_bod = $this->inventario_model->get_sector_grid($bod_id);
        $select = '<option value=""></option>';
        foreach ($datos_sector_bod as $key) {
            if ($sxb_id == $key['sxb_id']) {
                $select .= '<option value="' . $key['sxb_id'] . '" selected>' . $key['seb_nombre'] . '</option>';
            } else {
                $select .= '<option value="' . $key['sxb_id'] . '">' . $key['seb_nombre'] . '</option>';
            }
        }
        echo json_encode(array('resp' => $select));
    }

                function obtener_padres_tia($tia_id) {
        ///$tia_id = $this->input->post('categoria');
                    $padre = 0;
                    $nombre_categoria = "";
                    $id_categoria = "";
                    $codigo_categoria = "";
                    $contador = 0;
                    do {
                        if ($contador == 0) {
                            $categorias = $this->inventario_model->get_tia_padres(array('tia_id' => $tia_id));
                        } else {
                            $categorias = $this->inventario_model->get_tia_padres(array('tia_id' => $padre));
                        }
                        $padre = $categorias[0]["tia_padre"];
                        $nombre_categoria = $categorias[0]["tia_nombre"];
                        $id_categoria = $categorias[0]["tia_id"];
                        $codigo_categoria = $categorias[0]["tia_codigo"];
                        $contador ++;
                    } while ($padre != null);
                    $cadena = array($nombre_categoria, $id_categoria, $codigo_categoria);
                    return $cadena;
                }

                function obtener_categoriaxbodega() {
                    $where = null;
                    $bod_id = $this->input->post('bodega');
                    if ($bod_id != "") {
                        $where['bod_id'] = $bod_id;
                    }
                    $categoria_productos = $this->inventario_model->get_productosxbodega($where, "tia_id");
                    $select = "<option value=''></option>";
                    $categorias_id = array();
                    $categorias_nombre = array();
                    $categorias_codigo = array();
                    foreach ($categoria_productos as $key) {
                        if ($key["tia_padre"] == null and !in_array($key["tia_id"], $categorias_id)) {
                            $categorias_codigo[] = $key["tia_codigo"];
                            $categorias_nombre[] = $key["tia_nombre"];
                            $categorias_id[] = $key["tia_id"];
                        } else {
                            $arreglo = $this->obtener_padres_tia($key["tia_id"]);
                            if (!in_array($arreglo[0], $categorias_nombre)) {
                                $categorias_nombre[] = $arreglo[0];
                                $categorias_id[] = $arreglo[1];
                                $categorias_codigo[] = $arreglo[2];
                            }
                        }
                    }
                    for ($x = 0; $x < count($categorias_nombre); $x++) {
                        $select .= '<option value="' . $categorias_id[$x] . '">'.$categorias_codigo[$x].' - '.$categorias_nombre[$x] . '</option>';
                    }
                    //SE AGREGAN LOS SECTORES TAMBIEN
                                $this->db->join('seb_sector_bodega', 'seb_id = sxb_id_seb');
                    $sectores = $this->gsatelite->get_dropdown('sxb_sectorxbodega','{seb_nombre}','',array('sxb_id_bod' => $bod_id,'sxb_estado' => 1,'seb_estado' => 1),null,'','sxb_id', true);
                    $sxb = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $sectores);
                    echo json_encode(array('resp' => $select, 'sectores' => $sxb));
                }

                function obtener_productosxbodega() {
        ///$bod_id,$tia_id
                    $bod_id = $this->input->post('bodega');
                    $tia_id = $this->input->post('categoria');
                    $categoria_productos = $this->inventario_model->get_productosxbodega(array('art_id_bod' => $bod_id), "art_id");
                    $select = "<option value=''></option>";
                    $productos[][] = "";
                    $contador = 0;
                    foreach ($categoria_productos as $key) {
                        $padre = (trim($key["tia_padre"]) != "") ? $key["tia_padre"] : null;
                        if ($padre == null) {
                            $productos[$contador][0] = $key["art_id"];
                            $productos[$contador][1] = $key["art_nombre"];
                            $productos[$contador][2] = $key["tia_id"];
                        } else {
                            $arreglo = $this->obtener_padres_tia($key["tia_id"]);
                            $productos[$contador][0] = $key["art_id"];
                            $productos[$contador][1] = $key["art_nombre"];
                            $productos[$contador][2] = $arreglo[1];
                        }
                        $contador++;
                    }
                    foreach ($productos as $key) {
                        if ($tia_id == $key[2]) {
                            $select .= '<option value="' . $key[0] . '">' . $key[1] . '</option>';
                        }
                    }
                    echo json_encode(array('resp' => $select));
                }

                function get_bodegaxsucursal() {
                    $suc_id = $this->input->post('sucursal');
                    $select = '<option value=""></option>';
                    $where['bod_estado'] = 1;
                    $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
                    if ($empresa != 'istu') {
                        $where['bod_id_suc'] = $suc_id;
                    }
                    $bodegas = $this->gsatelite->get_tabla('bod_bodega', $where);
                    foreach ($bodegas as $key) {
                        $select .= '<option value="' . $key["bod_id"] . '">' . $key["bod_nombre"] . '</option>';
                    }
                    echo json_encode(array('resp' => $select));
                }

    /*
      function get_padres_bodega($bodega){
      $query = $this->db->select('art_nombre, sar_cant_actual, art_id_tia')
      ->from('sar_saldo_articulo')
      ->join('art_articulo', 'art_id = sar_id_art')
      ->group_by('art_id_tia')
      ;
      $padre = "";
      $hijo = "";

      $arreglos[] = "";
      $contador = 0;
      $variable = $query->get()->result_array();
      foreach ($variable as $key) {
      $id_tia = $key['art_id_tia'];
      do{
      $temporales = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id'=>$id_tia))
      $arreglo[$contador] = $temporales[0]['']
      } while ( <= 10)
      $contador ++;
      }
      print_r($variable);
      select art_nombre, sar_cant_actual, art_id_tia from sar_saldo_articulo
      INNER JOIN art_articulo ON art_id = sar_id_art
      GROUP BY art_id_tia
  } */

  function anular_requisicion($iframe = 0, $id = null, $tipo_flujo = null) {
    satelite_validar();
    if ($_POST) {
            //var_dump($_POST);die();
        $post_array = $_POST;

            //SYS_PASOS_ANULACION
        $txtComentario = $post_array['txtComentario'];
        $doc_array = array(
            'rxi_id_usu_anulacion' => $this->tank_auth->get_user_id(),
            'rxi_descripcion_anulacion' => $post_array['txtComentario'],
            'rxi_estado' => 5,
            'rxi_id_ord' => NULL,
            'rxi_usu_modificacion' => $this->tank_auth->get_user_id(),
            'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $pasos_anulacion = $this->gsatelite->get_parametro('SYS_PASOS_ANULACION');
        $pasos_array = json_decode($pasos_anulacion, true);
        $paso_siguiente = $pasos_array['REQ_INV'];

        $resultado = $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $doc_array, array('rxi_id' => $id));

        $paso_actual = $post_array['paso_actual'];

            //Se cierra el paso actual
        $seguimiento_requisicion = array(
            'sgr_id_usu' => $this->tank_auth->get_user_id(),
            'sgr_id_usu' => $this->tank_auth->get_user_id(),
            'sgr_observacion' => $txtComentario,
            'sgr_fecha_salida' => date('Y-m-d H:i:s'),
            'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
            'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
        );

        $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id' => $paso_actual));

            //Se ingresa el paso especial para anulacion
        if ($paso_siguiente > 0) {
            $seguimiento_requisicion = array(
                'sgr_id_rxi' => $id,
                'sgr_id_psf' => $paso_siguiente,
                'sgr_id_usu' => $this->tank_auth->get_user_id(),
                'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                'sgr_estado' => 1,
                'sgr_usu_creacion' => $this->tank_auth->get_user_id(),
                'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgr_fecha_creacion' => date('Y-m-d h:i:s'),
                'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
            );

            $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
        }

        /*******************Hacer que la materia prima anulada vuelva a estar disponible***********************/
            //Obtener los detalles de la requisicion
        $tbl_dri = $this->gsatelite->get_tabla('dri_detalle_requisicion_inventario', array('dri_id_rxi' => $id));
        foreach ($tbl_dri as $key => $row_dri) {
            $axmid = $row_dri['dri_id_axm'];
            $cant_revertir = $row_dri['dri_cantidad'];
                //Obtener datos actuales axm_articulo_matxarticulo_ord
            $tbl_axm = $this->gsatelite->get_tabla('axm_articulo_matxarticulo_ord', array('axm_id' => $axmid));
            $axmcantidad = $tbl_axm[0]['axm_cantidad'];
            $axmpendiente = $tbl_axm[0]['axm_pendiente'];
            $axmdespachada = $tbl_axm[0]['axm_despachada'];

                //Actualizar axm_articulo_matxarticulo_ord
            $this->gsatelite->actualizar_array('axm_articulo_matxarticulo_ord', array('axm_pendiente' => ($axmpendiente + $cant_revertir), 'axm_despachada' => ($axmdespachada - $cant_revertir)) ,array('axm_id' => $axmid));
        }
        /******************************************************************************************************/

            /*
             * Si es iframe se enviar un parametro para cerrar el modal
             * Sino se redirecciona a la url configurada
             */
            if ($iframe == 1) {
                $data['cerrar_modal'] = 1;
                $data['alerta'] = $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición", 'texto_alerta' => "La anulación se procesó correctamente.");
            } else {
                $redireccionar = $post_array['redireccion'];
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Requisición", 'texto_alerta' => "La anulación se procesó correctamente.");
                $this->session->set_flashdata($alerta);
                redirect($redireccionar);
            }
        }
        $data['iframe'] = $iframe;
        $requisicion = $this->gsatelite->get_tabla('rxi_requisicion_inventario', array('rxi_id' => $id));
        $data['requisicion'] = $requisicion[0];

        $where = array(
            'dri_id_rxi' => $id
        );

        $paso_actual = $this->inventario_model->get_paso_actual($id, $tipo_flujo);
        $data['paso_actual'] = $paso_actual[0];

        $data['solicitante'] = $this->inventario_model->informacion_empleado($requisicion[0]['rxi_id_usu_solicita']);
        $data['detalle_requisicion'] = $this->inventario_model->get_requisicion_detalle($where);
        $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/anular_requisicion', $data, true);
    }

    /*
     * @author: Mario Marquez
     * Funcion ajax, que devuelve el listado opciones dependientes de una categoria
     * Si Flag = 1, se regresan los array de información por json
     */

    public function get_dependencias_categoria($flag = null) {
        $padre = $this->input->post('padre');
        $bodega = $this->input->post('bodega');
        $sector = $this->input->post('sector');
        $servicios = $this->input->post('servicio');

        //$this->db->where('tia_padre', $padre);
        $impuestos='';
        $hijos = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => $padre));
        $cadena = "<option value='0' selected>Seleccione una opción</option>";
        $var = "<option value='0' selected>Seleccione una opción</option>";

        foreach ($hijos as $key => $value) {
            $cadena .= '<option value="' . $value['tia_id'] . '">'.$value['tia_codigo'].' - '.$value['tia_nombre'] . '</option>';
        }

        $where_art = array('art_estado' => 1, 'art_inventario' => 1);
        if ($sector > 0) {
            //$where_art['art_id_sxb'] = $sector;
        }

        if ($bodega != '') {
            //$where_art['art_id_bod'] = $bodega;
        }

        $articulos = $this->inventario_model->get_articulosxcategoria($padre, $servicios, $where_art);

        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option data-codigo='" . $fila['art_codigo'] . "' data-nombre='" . $fila['art_nombre'] . "' "
            . "precio='" . $fila['sar_precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "'>" . $fila['art_codigo'] . ' - '. $fila['art_nombre'] . "</option>";
            $etiqueta++;
        }

        if (count($hijos) == 0) {
            $cadena = "";
        }
        if (count($articulos) == 0) {
            $var = "";
        }

        if ($flag == null) {
            $arreglo = array('drop' => $cadena, 'producto' => $var, 'padre' => $padre, 'impuestos' => $impuestos);
        } else if ($flag == 1) {
            $arreglo = array(
                'producto' => $articulos
            );
        }

        echo json_encode($arreglo);
    }

    public function get_categorias_productos($bodega = null) {

        $bod_id = ($bodega != null) ? $bodega : $this->input->post('bodega');

        $categorias = '<option value="0">Seleccione una opción</option>';
        $productos = '<option value="0">Seleccione una opción</option>';

        $categorias_prod = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => null));

        foreach ($categorias_prod as $key) {
            $categorias .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_codigo'] . ' - ' . $key['tia_nombre'] . "</option>";
        }

        $where_art = array('art_inventario' => 1, 'art_estado' => 1);
        $productos_bod = $this->gsatelite->get_tabla('art_articulo', $where_art);

        foreach ($productos_bod as $key) {
            $productos .= "<option value='" . $key['art_id'] . "'>" . $key['art_codigo'] . ' - ' . $key['art_nombre'] . "</option>";
        }

        $arreglo = array(
            "categoria" => $categorias,
            "producto" => $productos
        );

        echo json_encode($arreglo);
    }

    public function get_productos_existencia() {
        $padre = $this->input->post('padre');
        $bodega = $this->input->post('bodega');
        $sector = $this->input->post('sector');
        $servicios = $this->input->post('servicio');
        $reporte = $this->input->post('reporte');

        //$this->db->where('tia_padre', $padre);
        $hijos = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => $padre));
        $cadena = "<option value='0' selected>Seleccione una opción</option>";
        $var = "<option value='0' selected>Seleccione una opción</option>";

        foreach ($hijos as $key => $value) {
            $cadena .= '<option value="' . $value['tia_id'] . '">'.$value['tia_codigo'].' - '. $value['tia_nombre'] . '</option>';
        }

        $where_art = array('art_estado' => 1, 'art_inventario' => 1);
        if ($sector > 0) {
            $where_art['sar_id_sxb'] = $sector;
        }

        if ($bodega != '') {
            $where_art['sar_id_bod'] = $bodega;
        }

        $articulos = $this->inventario_model->get_articulosxcategoria($padre, $servicios, $where_art);
        $etiqueta = 0;
        foreach ($articulos as $fila) {
            if ($fila['saldo'] >= 0) {
                $saldo = ($reporte == 1) ? "" : "(" . number_format($fila['saldo'], 2) . ")";

                $extra = '';
                $extra = ($fila['cdp_codigo']!='') ? $fila['cdp_codigo'] : '';
                if ($fila['art_sinonimo']!='') {
                    $extra = ($extra!='') ? $extra.'/ '.$fila['art_sinonimo'] : $fila['art_sinonimo'];
                }
                $extra = ($extra!='') ? ' ('.$extra.')' : '';

                $var .= "<option data-codigo='" . $fila['art_codigo'] . "' data-nombre='" . $fila['art_nombre'] . "' "
                . "precio='" . $fila['sar_precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "'>" . $fila['art_codigo'] . ' - '. $fila['art_nombre'] . $extra. ' ' . $saldo . "</option>";
            }
            $etiqueta++;
        }

        if (count($hijos) == 0) {
            $cadena = "";
        }
        if (count($articulos) == 0) {
            $var = "";
        }

        $arreglo = array('drop' => $cadena, 'producto' => $var, 'padre' => $padre, 'dato' => $articulos);
        echo json_encode($arreglo);
    }

    /*
     * @author: Mario Marquez
     * Función que busca los productos por nombre asignados a una categoria y bodega (saldos)
     * Si se les proporciona.
     * @return: Objeto json de la informacion resultante
     * Modificado: 16/10/2017    By: Edith Herrera
     * Además de los códigos asociados se obtiene la existencia en inventario en caso de que se obtenga bodega.
     */
    public function get_productos_like() {
        // var_dump($_POST);die();
        $categoria = $this->input->post('categoria');
        $tipo = $this->input->post('tipo');
        $sector = $this->input->post('sector');
        $bodega = $this->input->post('bodega');
        $producto = $this->input->post('producto');

        $where = null;
        $like = null;
        if ($categoria != '') {
            $where['art_id_tia'] = $categoria;
        }
        if ($bodega != '') {
            $where['sar_id_bod'] = $bodega;
        }
        if ($tipo != '') {
            $where['art_tipo'] = $tipo;
        }
        if ($sector > 0) {
            $where['sar_id_sxb'] = $sector;
        }

        $arreglo = array();
        $productos = $this->inventario_model->get_productos_like($where, $producto);
		// var_dump($this->db->last_query());die();
        $decimales = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;

        if (count($productos) > 0) {
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['art_id'];
                
                $extra = '';
                $extra = ($value['mrp_nombre'] != "") ? " " . $value['mrp_nombre'] . " " : "";
                if (isset($value['cdp_codigo']) && $value['cdp_codigo'] != '') {
                    $extra = ($extra != '') ? $extra . '/ ' . $value['cdp_codigo'] : ' ' . $value['cdp_codigo'];
                }
                if ($value['art_sinonimo']!='') {
                    $extra = ($extra!='') ? $extra.'/ '.$value['art_sinonimo'] : ' ' . $value['art_sinonimo'];
                }
                $extra = ($extra!='') ? ' ( '.$extra.' )' : '';

                if ($bodega != '') {
                    $arreglo[$key]['prod_nombre'] = $value['art_codigo'].' - '.$value['art_nombre'].$extra. ' (' . number_format($value['saldo'], $decimales, '.', '').') ';
                    $arreglo[$key]['saldo'] = number_format($value['saldo'], $decimales, '.', '');

                }else{
                    $arreglo[$key]['prod_nombre'] = $value['art_codigo'].' - '.$value['art_nombre'].$extra;
                    $arreglo[$key]['prod_nombre_simple'] = $value['art_nombre'];
                }
                $arreglo[$key]['total'] = $value;
            }
        }

        echo json_encode($arreglo);
    }

    /**
    * @author ELman Ortiz
    * @fecha: 22/07/2017
    * @descripcion: Genera el asiento contable automatico cuando se hace un ingreso de productos en inventario
    */
    function generar_asiento_entrada_inv_debe($moi_id, $doc_referencia){
        $cuentas = null;
        $total_debe = 0.00;
        //Tipo Cuenta de existencia por defecto
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('EXISTENCIA'));

        $subtxcatprod = $this->inventario_model->get_subtotales_cuentaprod($moi_id, $idtipo_cnt);
        //print_r($subtxcatprod); die();
        foreach ($subtxcatprod as $key => $value) {
            //$where = array('cnt_id'=> $value['cnt_id'], 'dta_estado'=> 1, 'dta_id_bod' => $bodega);
            //$registro = $this->inventario_model->get_cuenta_categoria($where);
            //print_r($registro); die();
            $cuentas[$key] = ($value['cnt_id']) ? array('0' => array('cnt_id' => $value['cnt_id'])) : array('0' => array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO')));
            $total_debe = $total_debe + $value['newsubtotal'];
        }

        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
        $origen = $this->gsatelite->get_tabla('orp_origen_partida',array('orp_tabla' =>'moi_movimiento'));
        $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;

        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
        if (count($consultar)>0) {
            $id_tipo_partida = $tipo_partida;
        }

        $pct_concepto = $this->gsatelite->get_campo('ccp_concepto_partida', 'ccp_referencia_proceso', array('ccp_id' => 5));

        if($pct_concepto == '' || $pct_concepto == null){
            $pct_concepto = "Concepto no definido";
        }

        $array_partida = array(
            'pct_id_tpd' => $id_tipo_partida,
            //'pct_id_prc' => $this->input->post('id_prc'),
            'pct_id_orp' => $orp_partida,//YA
            'pct_concepto' => $pct_concepto.'-'. $doc_referencia,//YA
            'pct_total' => number_format($total_debe, 2, '.', ''),//YA
            'pct_fecha' => date('Y-m-d H:i:s'), //YA
            'pct_correlativo' => $correlativo_partida,//YA
            //'pct_codigo' => $codigo,
            //'pct_modulo' => $modulo,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id(),
        );

        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('EXISTENCIA'));

        $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
        //Cuenta inicial
        foreach ($subtxcatprod as $j => $deta) {
            $array_detalle = array(
                    'dpc_id_cnt' => $cuentas[$j][0]['cnt_id'],//YA
                    'dpc_id_pct' => $agregar,//YA
                    'dpc_concepto' => 'Entrada de producto inventario',
                    'dpc_debe' => $deta['newsubtotal'],//debe
                    'dpc_haber' => 0.00,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );

            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
        return array('id_pct' => $agregar, 'total_haber' => $total_debe);
    }//Fin debe asiento contable entrada inventario

    /**
     *@return Elman Ortiz
     *@fecha 25/07/2017
     *@descripcion: Haber de entrada de inventario
     */
    function generar_asiento_entrada_inv_haber($tip_id, $id_pct, $monto_haber){
        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('MOVIMIENTOS'));
        $where = array('tip_id' => $tip_id, 'ctp_id_tcn' => $tipo_cuenta);
        //Obtener la cuenta
        $id_cuenta = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $id_cnt = $this->inventario_model->get_cuenta_contable_entrada_inventario($where);
        if(count($id_cnt) > 0){
            $id_cuenta = $id_cnt[0]['ctp_id_cnt'];
        }

        $array_detalle = array(
            'dpc_id_cnt' => $id_cuenta,//YA
            'dpc_id_pct' => $id_pct,//Ya
            'dpc_concepto' => 'Pago a Proveedor',
            'dpc_debe' => 0.00,//haber
            'dpc_haber' => $monto_haber,
            'dpc_estado' => 1,
            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
            'dpc_fecha_mod' => date('Y-m-d H:i:s'),
            'dpc_usu_crea' => $this->tank_auth->get_user_id(),
            'dpc_usu_mod' => $this->tank_auth->get_user_id()
        );
        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
    }//Fin haber asiento contable entrada inventario

    /**
     * @return Elman Ortiz
     * @fecha 25/07/2017
     * @descripcion: Genera la parte del haber para una salida de inventario
     * @modified by: Mario Marquez
     * @date: 05/11/2018
     */
    function generar_asiento_salida_inv_haber($moi_id){
        $cuentas = null;
        $total_debe = 0.00;
        //$bodega = $this->input->post('bodega_bod');

        //Se obtiene el registro del Movimiento
        $data_moi = $this->gsatelite->get_tabla('moi_movimiento_inv', array('moi_id' => $moi_id));

        $cnt_id_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        //Si el movimiento no depende de un Documento por Proveedor
        if(!$data_moi[0]['moi_id_dpv']){
            //Tipo Cuenta de existencia por defecto
            $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('EXISTENCIA'));
            $subtxcatprod = $this->inventario_model->get_subtotales_cuentaprod($moi_id, $idtipo_cnt);

            foreach ($subtxcatprod as $key => $value) {
                $cuentas[$key] = ($value['cnt_id']) ? array('0' => array('cnt_id' => $value['cnt_id'])) : array('0' => array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO')));
                $total_debe = $total_debe + $value['newsubtotal'];
            }

            $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
            $origen = $this->gsatelite->get_tabla('orp_origen_partida',array('orp_tabla' =>'moi_movimiento'));
            $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;

            $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
            $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
            $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
            if (count($consultar)>0) {
                $id_tipo_partida = $tipo_partida;
            }

            $fac_num = $this->inventario_model->get_fac_num($moi_id);
            $fac_num = ($fac_num) ? ' - '.$fac_num[0]['fac_numero'] : '';

            /*pct_concepto texto*/
            $this->db->join('fac_factura', 'fac_id = moi_id_fac');
            $factura = $this->gsatelite->get_tabla('moi_movimiento_inv', array('moi_id' => $moi_id));
            if(count($factura)>0){
                $pct_concepto = 'Salida por facturacion';
                $dpc_concepto = 'Salida de producto por facturacion';
            }else{
                $pct_concepto = 'Salida de producto inventario';
                $dpc_concepto = 'Salida de producto de inventario';
            }

            $array_partida = array(
                'pct_id_tpd' => $id_tipo_partida,
                //'pct_id_prc' => $this->input->post('id_prc'),
                'pct_id_orp' => $orp_partida,//YA
                'pct_concepto' => $pct_concepto . $fac_num,//YA
                'pct_total' => number_format($total_debe, 2, '.', ''),//YA
                'pct_fecha' => date('Y-m-d H:i:s'), //YA
                'pct_correlativo' => $correlativo_partida,//YA
                //'pct_codigo' => $codigo,
                //'pct_modulo' => $modulo,
                'pct_estado' => 1,
                'pct_fecha_crea' => date('Y-m-d H:i:s'),
                'pct_fecha_mod' => date('Y-m-d H:i:s'),
                'pct_usu_crea' => $this->tank_auth->get_user_id(),
                'pct_usu_mod' => $this->tank_auth->get_user_id(),
            );

            $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('EXISTENCIA'));
            $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

            foreach ($subtxcatprod as $j => $deta) {
                $array_detalle = array(
                    'dpc_id_cnt' => $cuentas[$j][0]['cnt_id'],//YA
                    'dpc_id_pct' => $agregar,//Ya
                    'dpc_concepto' => $dpc_concepto,
                    'dpc_debe' => 0.00,
                    'dpc_haber' => $deta['newsubtotal'],//debe
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }
        }

        else if($data_moi[0]['moi_id_dpv']){
            //var_dump($data_moi);die();

            //Se obtiene el documento por Proveedor
            $data_documento = $this->inventario_model->get_documento_proveedor(array('dpv_id' => $data_moi[0]['moi_id_dpv']));

            $concepto_documento = ($data_documento[0]['prv_tipo_pers'] == 1) ? $data_documento[0]['prv_nombre'].' '.$data_documento[0]['prv_apellido'] : $data_documento[0]['prv_nombre'];
            $concepto_documento.=' - '.formatear_fecha('d-m-Y',$data_documento[0]['dpv_fecha_documento']);
            $concepto_documento.=' - #'.$data_documento[0]['dpv_numero_documento'];

            //Se obtiene el concepto de la partida
            //Obtener concepto de la partida contable
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 7));//Id Partida contabilidad Salida Inv.
            if(count($pct_concepto) > 0){
              $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
          }else{
              $pct_concepto = 'Concepto no definido';
          }

          $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('EXISTENCIA'));

            //Tipo de Partida
          $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EXISTENCIA'));
          $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
            //Condiciones 
            //$where = array('moi_id' => $moi_id, 'dta_id_tcn' => $tipo_cuenta);
          $where = array('dpv_id' => $data_moi[0]['moi_id_dpv'], 'art_inventario' => 1);

            //$cuentas_haber_detalles = $this->contabilidad_model->get_cuentas_doc_proveedor_salida_inv_haber($where);
          $cuentas_haber_detalles = $this->contabilidad_model->get_cuentas_doc_proveedor_salida_inv_haber_dpv($where);

            //$where_articulos = array('dxd_id_dpv' => $data_moi[0]['moi_id_dpv'], 'art_inventario' => 0);
            //$cuentas_haber_detalles = $this->compras_model->get_cnt_x_prod_x_docproveedor($where_articulos);

          $total_debe = array_sum(array_column($cuentas_haber_detalles,'subtotal_prod'));

          $array_partida = array(
            'pct_id_tpd' => $tipo_partida,
            'pct_concepto' => $pct_concepto. ' - '.$concepto_documento,
            'pct_total' => number_format($total_debe, 2, '.', ''),
            'pct_fecha' => $data_moi[0]['moi_fecha_mov'],
            'pct_correlativo' => $correlativo_partida ,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id(),
        );

          $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

          $agregar = $pct_id;
            //Se ingresan los detalles
          foreach ($cuentas_haber_detalles as $detalle) {
            $array_detalle = array(
                'dpc_id_cnt' => ($detalle['cnt_id'] == null)?$cnt_id_defecto : $detalle['cnt_id'],
                'dpc_id_pct' => $pct_id,
                'dpc_concepto' => $dpc_concepto,
                'dpc_debe' => 0.00,
                'dpc_haber' => $detalle['subtotal_prod'],
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
    }        

    return array('id_pct' => $agregar, 'total_debe' => $total_debe);
    }//Fin haber asiento contable salida inventario

    /**
     * @return Elman Ortiz
     * @fecha 25/07/2017
     * @descripcion: Genera la parte del debe para una salida de inventario
     */
    function generar_asiento_salida_inv_debe($cliente, $id_pct, $monto_debe, $data_movimiento = null){

        if($data_movimiento['moi_id_dpv']!= null){

            $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('EXISTENCIA'));

            //Condiciones 
            $where = array(
                'moi_id' => $data_movimiento['moi_id'],
                'tip_salida' => 1,
                'ctp_id_tcn' => $tipo_cuenta,
                'art_inventario' => 1
            );

            $cuentas_haber_detalles = $this->contabilidad_model->get_cuentas_doc_proveedor_salida_inv_debe($where);
            
            $cnt_id_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');

            //Si existen detalles se ingresan, sino se ira a la cuenta por defecto
            if(count($cuentas_haber_detalles) > 0){
                foreach($cuentas_haber_detalles as $debe){
                    $array_detalle = array(
                        'dpc_id_cnt' => ($debe['cnt_id'] == null)?$cnt_id_defecto : $debe['cnt_id'],
                        'dpc_id_pct' => $id_pct,//Ya
                        'dpc_concepto' => '',
                        'dpc_debe' => $debe['subtotal_prod'],//debe
                        'dpc_haber' => 0.00,
                        'dpc_estado' => 1,
                        'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                        'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                        'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                        'dpc_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);   
                }
            }
            else{
                $array_detalle = array(
                    'dpc_id_cnt' => $cnt_id_defecto,
                    'dpc_id_pct' => $id_pct,
                    'dpc_concepto' => '',
                    'dpc_debe' => $monto_debe,
                    'dpc_haber' => 0.00,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);    
            }            
        }
        else {
            $cliente = ($cliente) ? $cliente : null ;
            $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('COSTO'));
            $where = array('tcn_id' => $tipo_cuenta, 'cli_id' => $cliente);
            //Obtener la cuenta
            $id_cuenta = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $id_cnt = $this->inventario_model->get_cuenta_contable_salida_inventario($where);
            if(count($id_cnt) > 0){
                $id_cuenta = $id_cnt[0]['cxn_id_cnt'];
            }

            $array_detalle = array(
                'dpc_id_cnt' => $id_cuenta,//YA
                'dpc_id_pct' => $id_pct,//Ya
                'dpc_concepto' => 'Cliente',
                'dpc_debe' => $monto_debe,//debe
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }       
    }//Fin debe asiento contable salida inventario

    /**
    * @author ELman Ortiz
    * @fecha: 26/07/2017
    * @descripcion: Genera el asiento contable automatico cuando se hace un traslado de productos en inventario
    * @descripcion Se hace con la bodega origen
    */
    function generar_asiento_traslado_inv_debe($moi_id_entrada, $numCorrelativoTraslado){
        $cuentas = null;
        $total_debe = 0.00;
        $bodega_origen = $this->input->post('bodega_bod');
        $tb_bodega = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $bodega_origen));
        $bod_nombre_origen = $tb_bodega[0]['bod_nombre'];

        //Tipo Cuenta de existencia por defecto
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('EXISTENCIA'));
        $subtxcatprod = $this->inventario_model->get_subtotales_cuentaprod($moi_id_entrada, $idtipo_cnt);

        foreach ($subtxcatprod as $key => $value) {
            //$where = array('dta_id_tia'=> $value['tia_id'], 'dta_estado'=> 1, 'dta_id_bod' => $bodega_origen);
            //$registro = $this->inventario_model->get_cuenta_categoria($where);
            $cuentas[$key] = ($value['cnt_id']) ? array('0' => array('cnt_id' => $value['cnt_id'])) : array('0' => array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO')));
            $total_debe = $total_debe + $value['newsubtotal'];
        }

        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
        $origen = $this->gsatelite->get_tabla('orp_origen_partida',array('orp_tabla' =>'moi_movimiento'));
        $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;

        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
        if (count($consultar)>0) {
            $id_tipo_partida = $tipo_partida;
        }

        $array_partida = array(
            'pct_id_tpd' => $id_tipo_partida,
            //'pct_id_prc' => $this->input->post('id_prc'),
            'pct_id_orp' => $orp_partida,//YA
            'pct_concepto' => 'Traslado de producto inventario' .' - '. $numCorrelativoTraslado,//YA
            'pct_total' => number_format($total_debe, 2, '.', ''),//YA
            'pct_fecha' => date('Y-m-d H:i:s'), //YA
            'pct_correlativo' => $correlativo_partida,//YA
            //'pct_codigo' => $codigo,
            //'pct_modulo' => $modulo,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id(),
        );

        $tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('EXISTENCIA'));

        $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
        foreach ($subtxcatprod as $j => $deta) {
            $array_detalle = array(
                'dpc_id_cnt' => $cuentas[$j][0]['cnt_id'],
                'dpc_id_pct' => $agregar,
                'dpc_concepto' => 'Entrada producto inventario'.' - '.$bod_nombre_origen,
                'dpc_debe' => $deta['newsubtotal'],//debe
                'dpc_haber' => 0.00,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

        return array('id_pct' => $agregar, 'total_haber' => $total_debe);
    }//Fin debe asiento contable traslado inventario lado debe

    /*****************************************************************************************/
    /**
    * @author ELman Ortiz
    * @fecha: 26/07/2017
    * @descripcion: Genera el asiento contable automatico cuando se hace un traslado de productos en inventario
    * @descripcion Se hace con la bodega destino
    */
    function generar_asiento_traslado_inv_haber($moi_id_salida, $id_pct, $numCorrelativoTraslado){
        $cuentas = null;
        $total_haber = 0.00;
        $bodega_destino = $this->input->post('bodega_bod2');
        $tb_bodega = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $bodega_destino));
        $bod_nombre_destino = $tb_bodega[0]['bod_nombre'];

        //Tipo Cuenta de existencia por defecto
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('EXISTENCIA'));
        $subtxcatprod = $this->inventario_model->get_subtotales_cuentaprod($moi_id_salida, $idtipo_cnt);

        foreach ($subtxcatprod as $key => $value) {
            //$where = array('dta_id_tia'=> $value['tia_id'], 'dta_estado'=> 1, 'dta_id_bod' => $bodega_destino);
            //$registro = $this->inventario_model->get_cuenta_categoria($where);
            $cuentas[$key] = ($value['cnt_id']) ? array('0' => array('cnt_id' => $value['cnt_id'])) : array('0' => array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO')));
            $total_haber = $total_haber + $value['newsubtotal'];
        }

        foreach ($subtxcatprod as $j => $deta) {
            $array_detalle = array(
                'dpc_id_cnt' => $cuentas[$j][0]['cnt_id'],//YA
                'dpc_id_pct' => $id_pct,//Ya

                'dpc_concepto' => 'Salida producto inventario'.' - '.$bod_nombre_destino,
                'dpc_debe' => 0.00,//debe
                'dpc_haber' => $deta['newsubtotal'],
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }
    }//Fin debe asiento contable traslado inventario lado haber
    /*****************************************************************************************/

    /*
     * @author: Mario Marquez
     * @return: Retorna un json con las existencias de los producto(s) proporcionados bajo una bodega.
     */

    public function get_existencias_producto() {
        if ($this->input->post()) {
            $post_array = $this->input->post();

            $productos = $post_array['productos'];
            $bodega = $post_array['bodega'];

            if ($productos != '') {
                $productosIds = explode(",", $productos);
                $this->db->where_in('art_id', $productosIds);
            }

            $where = array(
                'bod_id' => $bodega,
                'uxb_id_usu' => $this->tank_auth->get_user_id()
            );

            $existencias = $this->inventario_model->get_existencias($where, 'art_id');
            //die(print_r($this->db->last_query()));
            $resultado = array();

            if (count($existencias) > 0) {
                $i = 0;
                foreach ($existencias as $art) {
                    $resultado[$i]['producto'] = $art['art_id'];
                    $resultado[$i]['saldo_actual'] = $art['cantidad'];
                    $i++;
                }
            }

            echo json_encode($resultado);
        }
    }

    public function consultar_productos() {
        $producto = $this->input->post('producto');
        $result = $this->inventario_model->get_productos_slcAjax($producto);
        echo json_encode($result);
    }

    public function verificar_medida(){
        $id_art = $this->input->post('id');
        $medida = $this->input->post('medida');
        $result = $this->inventario_model->verificar_um(array('art_id' => $id_art),$medida);
        echo json_encode(array('resp'=>count($result)));
    }

    public function get_codigos_pro(){
        $id_art = $this->input->post('producto');
        $bodega = $this->input->post('bodega');

        $datos = $this->gsatelite->get_tabla('cdp_codigo_producto', array('cdp_id_art'=>$id_art));

        $saldo=0;
        if(isset($bodega) && $bodega > 0){
            $existe = $this->inventario_model->get_productos_like(array('art_id'=>$id_art, 'sar_id_bod'=>$bodega));
            if(count($existe)>0){
                $saldo= $existe[0]['saldo'];
            }else{
                $saldo = 0;
            }
        }


        $codigos=array();
        if(count($datos)>0){
            foreach ($datos as $dat) {
                $codigos[]=$dat['cdp_codigo'];
            }
        }
        if(count($codigos)>0){
            $mostrar = implode(', ', $codigos);
        }else{
            $mostrar ='';
        }

        /*************************** Dropdown código de lotes *******************************************/

        $lotes = $this->inventario_model->get_cantidadxlote(array('art_id'=>$id_art, 'sar_id_bod'=>$bodega));

        $drop_lote = '<option value=""></option>';
        if(count($lotes)>0){
            foreach ($lotes as $lot) {
                if($lot['dee_codigo_lote']!='' && $lot['cant'] > 0){
                    $drop_lote .= '<option value="'.$lot['dee_codigo_lote'].'" data-cant="'.$lot['cant'].'">'.$lot['dee_codigo_lote'].' ('.$lot['cant'].') </option>';
                }
            }
        }

        /*************************** obtener flag si aplica empaque *******************************************/

        $aplica_empaque = $this->gsatelite->get_campo("art_articulo","art_aplica_empaque",array('art_id'=>$id_art) );


        echo json_encode(array('mostrar'=>$mostrar, 'existencia'=>$saldo, 'lotes'=>$drop_lote, 'aplica_empaque' => $aplica_empaque));
    }

    public function ajax_bodegaxusuario()
    {
        $bodegaxusuario = $this->inventario_model->usuarioxbodega();
        $select = '<option value=""></option>';
        foreach ($bodegaxusuario as $key => $boxusu) {
            $select .= '<option value="'.$boxusu['bod_id'].'">'.$boxusu['bod_nombre'].'</option>';
        }
        echo $select;
        die();
    }

    function get_compra_documento_proveedor($selected = null) {
        $prv_id                         = $this->input->post('proveedor');
        $dxd_id_bod                     = $this->input->post('bodega');
        $afecta_inventario              = $this->input->post('precargado');
        $where                          = array();
        $where['dpv_estado']            = 1;
        if ( $dxd_id_bod != "") {
            $where['dxd_id_bod']        = $dxd_id_bod;
        }
        if ( $afecta_inventario == 1) {
            $where['dpv_id_prv']            = $prv_id;
            $where['dpv_afecta_inventario'] = 1;
            $where['tip_entrada']    = 1;
            $where['dpv_id NOT IN ( SELECT dpv_id FROM dpv_documento_proveedor
            JOIN dxd_detalle_documento_proveedor ON dxd_id_dpv = dpv_id
            JOIN moi_movimiento_inv ON moi_id_dpv = dpv_id
            JOIN tip_tipo_proceso ON tip_id = moi_id_tip
            WHERE tip_salida = 1 AND dpv_id_prv = '.$prv_id.' AND dxd_id_bod = '.$dxd_id_bod.' GROUP BY dpv_id)'] = NULL;
        }
        $dpv_documento_proveedor = $this->inventario_model->get_documento_proveedor( $where );
        $select = '<option value=""></option>';
        foreach ($dpv_documento_proveedor as $key) {
            $select .= '<option value="' . $key['dpv_id'] . '">' . $key['dpv_numero_documento'] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    function get_productos_documento_proveedor(){
        $dxd_id_dpv             = $this->input->post('documento');
        $dxd_id_bod             = $this->input->post('bodega');
        $where                  = NULL;
        $where['dxd_id_dpv']    = $dxd_id_dpv;
        $where['dxd_estado']    = 1;
        $where['dxd_id_bod']    = $dxd_id_bod;
        $where['dxd_id_dpv NOT IN (SELECT moi_id_dpv FROM moi_movimiento_inv
        JOIN tip_tipo_proceso ON tip_id = moi_id_tip
        WHERE tip_salida = 1 AND moi_id_dpv = dxd_id_dpv)'] = NULL;
        $articulos              = $this->inventario_model->get_productos_documento_proveedor($where);
        $data['articulos']      = $articulos;
        $data['decimales']      = ($this->gsatelite->get_parametro('NUMERO_DECIMALES')) ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
        $html                   = $this->load->view('inventario/gestion_productos/productos_documento_proveedor', $data, true);
        $data2['html']          = $html;
        $data2['dpv_numero']    = (count($articulos)>0)?$articulos[0]['dpv_numero']:'';
        echo json_encode($data2);
        die();
    }

    function finalizar_requisicion() {
        satelite_validar();
        if ($this->input->post()) {
            // Dato
            $requisicion = $this->input->post('requisicion');
            $actualizar  = array(
                'rxi_estado'             => 0,
                'rxi_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'rxi_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $resp = $this->gsatelite->actualizar_array("rxi_requisicion_inventario", $actualizar, array("rxi_id" => $requisicion));
            if ($resp > 0) {
                echo json_encode(array('resp'=>1));
            } else {
                echo json_encode(array('resp'=>0));
            }
        }

    }

    function exportar_ajuste($tipo = 1){
        satelite_validar();
        $array_post = $this->input->post();
            $cadena='<meta http-equiv="content-type" content="text/html; charset=utf-8"><table class="tabla" border="1" cellpadding="2" style="border:1px solid black;">';
            $cadena.='<tr>';
            $cadena.='<th style="text-align:center; font-weight:bold; width:25%;">Producto</th>';
            $cadena.='<th style="text-align:center; font-weight:bold; width:25%;">Código</th>';
            $cadena.='<th style="text-align:center; font-weight:bold; width:15%;">Cantidad Física</th>';
            $cadena.='<th style="text-align:center; font-weight:bold; width:15%;">Cantidad Existencia</th>';
            $cadena.='<th style="text-align:center; font-weight:bold; width:20%;">Movimiento</th>';
            $cadena.='</tr>';
        if (empty($array_post['productos'])) {
            $cadena.='<tr><td colspan="5">No se encontraron datos</td></tr>';
        } else {
            $nombre = $array_post['name_prod'];
            $codigo = $array_post['codigo_prod'];
            $cantidad = $array_post['cantidad'];
            $existencia = $array_post['existencia'];
            $tipo_movimiento = $array_post['tipo_movimiento'];
            $efectuar_movimiento = $array_post['efectuar_movimiento'];
            $text_mov = $array_post['text_mov'];
            foreach ($array_post['productos'] as $key => $value) {
                $cadena .= "<tr>";
                $cadena .= "<td style='text-align: left;border-style:solid'>". $nombre[$key]. "</td>";
                $cadena .= "<td style='text-align: left;border-style:solid' class='text'>". $codigo[$key]. "</td>";
                $cadena .= "<td style='text-align: right;border-style:solid'>" . number_format($cantidad[$key], 2) . "</td>";
                $cadena .= "<td style='text-align: right;border-style:solid'>".$existencia[$key]."</td>";
                $cadena .= "<td style='text-align: left;border-style:solid'>". $text_mov[$key] ."</td>";
                $cadena .= "</tr>";
            }
        }
        $cadena.='</table>';
        if ($tipo == 1) { 
            $this->load->library('pdf');
            $html=$this->load->view('reporte/header', array('titulo' => 'Ajuste de inventario', 'solotitulo' => true, 'subtitulo'=> ''), true);
            $html.=$cadena;
            $this->pdf->setPrintFooter(false);
            $this->pdf->makePDF($html,'L');
        } else {
            $filename = 'ajustes_inventario_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            $data['cadena']         = $cadena;
            $data['tipo_reporte']   = 'excel';
            $html = $this->load->view('inventario/gestion_productos/ajustes_inventario', $data, true);
            echo $html;
        }        

    }

    function get_productos_empaquetados(){
        if ($_POST){
            $bodega     = $this->input->post('bodega');
            $articulo   = $this->input->post('articulo');
            $lote       = $this->input->post('lote');
            $tipo       = $this->input->post('tipo');//0 lotes, 1 entrada, 2 salida
            $where      = NULL;
            $where["dmp_estado"] = 1;
            if ( $lote != ""){
                $where["dee_codigo_lote"] = $lote;
            }

            if ( $bodega != ""){
                $where["moi_id_bod"] = $bodega;
            }

            if ( $articulo != ""){
                $where["dee_id_art"] = $articulo;
            }

            $this->db->join("dee_detalle_mov","dee_id = dmp_id_dee");
            $this->db->join("moi_movimiento_inv","moi_id = dee_id_moi");
            $empaques = $this->gsatelite->get_tabla("dmp_detalle_empaque",$where);

            if ($tipo == 0){ //cantidad de lotes
             $resultado = count($empaques);
            } else if ( $tipo == 1) { // entrada
                $data['articulo'] = $articulo;
                $data['empaques'] = $empaques;
                $resultado = $this->load->view('inventario/gestion_productos/empaque_entrada', $data, true);
            } else { // salida
                $data['articulo'] = $articulo;
                $data['empaques'] = $empaques;
                $resultado = $this->load->view('inventario/gestion_productos/empaque_salida', $data, true);
            }

            echo json_encode($resultado);
        }
    }

    //Funcion para ocultar o mostrar campos producto destino en trsalado de productos
    public function ValidarProduccion(){
        $art_code = $this->input->post('producto');
        $result = $this->gsatelite->get_tabla('art_articulo',array('art_id'=>$art_code));
        echo json_encode($result);
    }

function traslado_empaque($array_empaques, $dee_id_salida){
    foreach ($array_empaques as $value) {
            //consultar el paquete anterior
        $this->db->join("dee_detalle_mov","dee_id = dmp_id_dee");
        $detalle_empaque =  $this->gsatelite->get_tabla("dmp_detalle_empaque",array("dmp_id" => $value, "dmp_estado" => 1) );

            //actualizar antiguo paquete
        $dmp_array_new = array(
            'dmp_id_cxu'            => $detalle_empaque[0]["dmp_id_cxu"],
            'dmp_id_dee'            => $dee_id_salida,
            'dmp_orden'             => $detalle_empaque[0]["dmp_orden"],
            'dmp_codigo_empaque'    => $detalle_empaque[0]["dmp_codigo_empaque"],
            'dmp_cantidad'          => $detalle_empaque[0]["dmp_cantidad"],
            'dmp_peso_neto'         => $detalle_empaque[0]["dmp_peso_neto"],
            'dmp_peso_bruto'        => $detalle_empaque[0]["dmp_peso_bruto"],
            'dmp_procesado_salida'  => 0,
            'dmp_estado'            => 1,
            'dmp_usu_creacion'      => $this->tank_auth->get_user_id(),
            'dmp_fecha_creacion'    => date('Y-m-d H:i:s'),
            'dmp_usu_modificacion'  => $this->tank_auth->get_user_id(),
            'dmp_fecha_modificacion'=> date('Y-m-d H:i:s')
        );
        $this->gsatelite->ingresar('dmp_detalle_empaque', $dmp_array_new);

            //actualizar antiguo paquete
        $paquetes_antiguos = array(
            'dmp_usu_modificacion'  => $this->tank_auth->get_user_id(),
            'dmp_fecha_modificacion'=> date('Y-m-d H:i:s'),
            'dmp_estado'            => 0,
            'dmp_procesado_salida'  => 1,
            'dmp_id_dee_salida'     => $dee_id_salida
        );
        $this->gsatelite->actualizar_array("dmp_detalle_empaque", $paquetes_antiguos, array("dmp_id" => $value) );

            //actualizar codigo de lote del detalle de movimiento.
        $this->gsatelite->actualizar_array("dee_detalle_mov", array("dee_codigo_lote" => $detalle_empaque[0]["dee_codigo_lote"]) , array("dee_id" => $dee_id_salida) );
    }
}

    /**
     *@return Luis Navarro
     *@fecha 30/07/2018
     *@descripcion: Realizar la autorazion automatica de la requisicon
     */
    public function autorizar_requisicion_automatica($requisicion = null, $tipo_flujo = null, $flujo = null) {
        // Obtener los pasos de seguimiento
        /*
        * Flujo: 1 = Requisicion de inventario
        */
        /******************************************************************************************/
        /* Obtener el paso actual de la requisicion                                               */
        $paso_actual    = $this->inventario_model->get_paso_actual($requisicion, $tipo_flujo);
        $paso_actual    = $paso_actual[0]['sgr_id'];

        /******************************************************************************************/
        /* Obtener el paso Siguiente de la requisicion                                            */
        $this->db->limit(1);
        $paso_siguiente    = $this->gsatelite->get_tabla('psf_paso_flujo', array('psf_id_flu'=>$flujo, 'psf_orden'=>3));
        $paso_siguiente    = $paso_siguiente[0]['psf_id'];
        /******************************************************************************************/
        $Comentario_actual = 'Creacion de la requisicion';
        $comentario_sig    = 'Autorizacion de requsicion automatica';
        if (!count($paso_actual) > 0 && !count($paso_siguiente) > 0) {
            die("Error");
        }
        //Se cierra el paso actual y se ingresa el siguiente paso si existe
        switch ($flujo) {
            case 1:
                //Se cierra el paso actual
                $seguimiento_requisicion = array(
                    'sgr_id_usu' => $this->tank_auth->get_user_id(),
                    'sgr_observacion' => $Comentario_actual,
                    'sgr_fecha_salida' => date('Y-m-d H:i:s'),
                    'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                );
                $this->gsatelite->actualizar_array('sgr_seguimiento_requisicion', $seguimiento_requisicion, array('sgr_id'=>$paso_actual));

                //Si existe un siguiente paso se ingresa
                if ($paso_siguiente > 0) {
                    $seguimiento_requisicion = array(
                        'sgr_id_rxi'    => $requisicion,
                        'sgr_id_psf'    => $paso_siguiente,
                        'sgr_id_usu'    => $this->tank_auth->get_user_id(),
                        'sgr_observacion'   => $comentario_sig,
                        'sgr_fecha_entrada' => date('Y-m-d H:i:s'),
                        'sgr_estado'        => 1,
                        'sgr_usu_creacion'  => $this->tank_auth->get_user_id(),
                        'sgr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgr_fecha_creacion'     => date('Y-m-d h:i:s'),
                        'sgr_fecha_modificacion' => date('Y-m-d h:i:s')
                    );
                    $seguimiento = $this->gsatelite->ingresar('sgr_seguimiento_requisicion', $seguimiento_requisicion);
                    if($seguimiento > 0 ){
                        //Se actualiza el estado del registro
                        $this->load->library('../controllers/inventario/inicio');
                        $this->inicio->cambiar_estado_registro($requisicion, $tipo_flujo, 3);
                    }
                }
                $this->gsatelite->actualizar_array('rxi_requisicion_inventario', array('rxi_id_usu_aprueba'=>$this->tank_auth->get_user_id()), array('rxi_id'=>$requisicion));
            break;
        }
    }

    public function imprimir_salida_productos($movimiento = 0) {
        satelite_validar();
        if ( $movimiento > 0 ) {
            $movimiento_salida  = $this->inventario_model->get_salidas_dee($movimiento);
            $data['filename']   = 'Reporte_salida_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']     = $movimiento_salida[0]["tip_nombre"];
            $data['movimiento'] = $movimiento_salida;
            $data['decimales']  = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['usa_sector'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $html   = $this->load->view('inventario/gestion_productos/imprimir_salida_productos', $data, true);
            $header = $this->load->view('reporte/header', $data, true);
            $GLOBALS['nombre_reporte']  = 'Reporte_salida_producto_' . date('dmY');
            $reporte                    = $header . $html;
            $this->pdf->makePdf($reporte, 'P', 'Reporte_salida_producto_', 'Letter');
        }
    }

    public function imprimir_remision_productos($movimiento = 0) {
        satelite_validar();
        if ( $movimiento > 0 ) {
            $movimiento_salida          = $this->inventario_model->get_salidas_dee_fact($movimiento);
            $filename                   = 'Reporte_nota_remision_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']             = 'Nota de Remisión';//$movimiento_salida[0]["tip_nombre"];
            $data['filename']           = $filename;
            $data['movimiento']         = $movimiento_salida;
            $data['decimales']          = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $html                       = $this->load->view('inventario/gestion_productos/imprimir_remision_productos', $data, true);
            $header                     = $this->load->view('reporte/header', $data, true);
            $GLOBALS['nombre_reporte']  = 'Reporte_salida_producto_' . date('dmY');
            $reporte                    = $header . $html;
            $this->pdf->makePdf($reporte, 'P', 'Reporte_salida_producto_', 'Letter');
        }
    }

    /**
     *@return Luis Navarro
     *@fecha 08/11/2018
     *@descripcion: Imprimir entrada de productos
     */
    public function imprimir_entrada_productos($movimiento = null) {
        satelite_validar();
        if ($movimiento != null && $movimiento > 0) {
            $movimiento_entrada = $this->inventario_model->get_salidas_dee($movimiento);
            $data['usa_sector'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
            $filename           = 'Reporte_entrada_producto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['titulo']     = $movimiento_entrada[0]["tip_nombre"];
            $data['filename']   = $filename;
            $data['movimiento'] = $movimiento_entrada;
            $data['decimales']  = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $html               = $this->load->view('inventario/gestion_productos/imprimir_entrada_productos', $data, true);
            $header             = $this->load->view('reporte/header', $data, true);
            $reporte            = $header . $html;
            $GLOBALS['nombre_reporte']  = 'Reporte_entrada_producto_' . date('dmY');
            $this->pdf->makePdf($reporte, 'L', 'Reporte_entrada_producto_', 'Letter');
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }


    /*
    * @author: Mario Marquez
    * @date: 13/11/2018
    * @Descripcion: Generacion masiva de partidas contables para salidas de inventario
    */
    public function generar_partida_contable_salida_inventario(){
       if ($this->input->post()) {
            //Se obtiene los movimientos que no contengan partidas y su tipo de proceso sea salida.
        $salidas_inventario = $this->inventario_model->get_movimientos(array('moi_id_pct is null' => null, 'tip_salida' => 1));

        $PartidasIds = array();
        if(count($salidas_inventario)> 0){
            foreach ($salidas_inventario as $movimiento) {
                $moi_id = $movimiento['moi_id'];
                $res_haber = $this->generar_asiento_salida_inv_haber($moi_id);

                $data_movimiento = array(
                    'moi_id' => $moi_id,
                    'moi_fecha_mov' => (trim($movimiento['moi_fecha_mov']) != '')?  formatear_fecha('Y-m-d',$movimiento['moi_fecha_mov']) . ' ' . date('H:i:s') : date('Y-m-d H:i:s'),
                    'moi_id_dpv' =>  $movimiento['moi_id_dpv'],
                    'moi_id_fac'            => $movimiento['moi_id_fac'],
                    'moi_documento'         => $movimiento['moi_documento'],
                    'moi_id_rxi'            => $movimiento['moi_id_rxi'],
                );
                $this->generar_asiento_salida_inv_debe($cliente, $res_haber['id_pct'], $res_haber['total_debe'], $data_movimiento);
                $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_haber['id_pct']), array('moi_id' => $moi_id));

                $PartidasIds[] = array('partida_id' => $res_haber['id_pct']);
            }
        }
        echo json_encode(array('cantidad_partidas' => count($PartidasIds)));
    }
    else{
        echo "Debe realizar un metodo de envio de datos";
    }
}

    /*
        * @author: Francisco Orozco
        * @date: 28/11/2018
        * @Descripcion: Generacion de codigos de barra.
    */
    function generardor_codigos_barra(){
        satelite_validar();
        if ( $_POST ) {
            $categoria      = $this->input->post("slc_categoria");
            $producto       = $this->input->post("txt_producto");
            $tipo_reporte   = $this->input->post("tipo_reporte");
            //$categoria_texto= $this->input->post("categoria");
            //$producto_texto = $this->input->post("producto");
            $cantidad       = intval($this->input->post("txt_cantidad"));

            $where["art_estado"]     = 1;

            if ( $categoria != "") {
                $where["art_id_tia"] = $categoria;
            }

            if ( $producto != "") {
                $where["art_id"] = $producto;
            }
            
            $data['datos']      = $this->gsatelite->get_tabla("art_articulo",$where);                     
            $data['cantidad']   = $cantidad;
            $html = $this->load->view('inventario/gestion_productos/consultar_generardor_codigos_barra', $data, true);

            if ($tipo_reporte == '') {
                $data2['html']      = $html;
                $data2['cantidad']  = count( $data['datos'] );
                echo json_encode($data2);
                die();
            } 

        } else {
            $categorias_array       = $this->gsatelite->get_dropdown('tia_tipo_articulo', 'tia_nombre', '', array('tia_estado' => 1), 'tia_id', null, null, true);
            $categorias             = str_replace('<option value="0">Seleccione</option>', '', $categorias_array);
            $data['categorias']     = $categorias;
            $data['titulo_personal']= 'Generador de códigos de barra';
            $this->_cargarvista(null, $data);
        }        
    }

    /*
        * @author: Francisco Orozco
        * @date: 28/11/2018
        * @Descripcion: Imprime de codigos de barra.
    */
    function imprimir_codigos_barra(){
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        if ( $_POST) {           
            $tipo_reporte           = $this->input->post("tipo_reporte");
            $data['tipo_reporte']   = $tipo_reporte;
            $data['chequeados']     = $this->input->post("chk_codigo");
            $data['cantidades']     = $this->input->post("cantidad");
            $data['codigos']        = $this->input->post("codigo");
            $data['nombres']        = $this->input->post("nombre");
            $data['id']             = $this->input->post("articulo");
            $filename               = 'codigo_barras_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']       = $filename;
            
            $html = $this->load->view('inventario/gestion_productos/imprimir_codigos_barra', $data, true);
            if ($tipo_reporte == '') {
                $data2['html'] = $html;
                echo json_encode($data2);
                die();
            } elseif ($tipo_reporte == 'pdf') {
                //$data['titulo']             = 'códigos de barra';
                //$header                     = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte']  = 'codigo_barras_' . date('dmY');
                $reporte    = $html;
                $this->pdf->setPrintFooter(false);                
                $this->pdf->makePdf($reporte);
                die();
            } elseif ($tipo_reporte == 'excel') {
                echo $html;
            }

        }
    }
    /**
     * Descripción:
     * Metodo para buscar productos mediante lo que se escribe en una caja de texto, consulta via ajax
     * @author Manuel Anzora - Grupo satélite
     * @since  2018-12-18
     * @param  recibe mediante post id de bodega, id de sector y text de productos
     */
    public function get_producto_req_like(){
        if($_POST){
            $bodega = $this->input->post('bodega');
            $sector = ($this->input->post('sector')!='')?$this->input->post('sector'):0;
            $producto = $this->input->post('producto');
            $sin_existen = $this->gsatelite->get_parametro_emp('SYS_REQUISICION_SIN_INVENTARIO', 1);
            $datos = array();
            if($bodega != ''){
                $where = array('art_estado' => 1, 'art_inventario' => 1, 'sar_id_bod'=> $bodega);
                if ($sector > 0) {
                    $where['sar_id_sxb'] = $sector;
                }
                if (!($sin_existen > 0)) {
                    $this->db->having('saldo > 0'); 
                }
                $datos = $this->inventario_model->get_producto_req_like($where, $producto);
            }
            echo json_encode($datos);
        }
    }

    public function visualizar_revertir_salida($moi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $data["movimiento_entrada"] = $this->gsatelite->get_tabla("moi_movimiento_inv", array("moi_estado" => 1, "moi_id" => $moi_id));
            $datos_entrada = $data["movimiento_entrada"][0];

            $data["moi_id_inicia_reversa"] = $moi_id;
            //print_r($datos_entrada); die();
            //Proveedor
            $data["proveedor_prv"] = ($datos_entrada['moi_id_prv'] != "") ? $datos_entrada['moi_id_prv']:0;
            //Orden compra
            $data["orden_compra_orc"] = ($datos_entrada['moi_id_orc'] != "") ? $datos_entrada['moi_id_orc']:0;
            ///Documento proveedor(Aunque dice dcp es el dpv)
            $data["doc_proveedor_dcp"] = ($datos_entrada['moi_id_dpv'] != "") ? $datos_entrada['moi_id_dpv']:0;
            ///Bodega
            $data["bodega_bod_id"] = ($datos_entrada['moi_id_bod'] != "") ? $datos_entrada['moi_id_bod']:0;
            //fecha_registro_mov
            $data["fecha_registro_mov"] = ($datos_entrada['moi_fecha_mov'] != "") ? date('Y-m-d',strtotime($datos_entrada['moi_fecha_mov'])):'';
            //Documento de referencia
            $data["doc_referencia"] = ($datos_entrada['moi_documento'] != "") ? $datos_entrada['moi_documento'] :'';
            //Tipo entrada
            $id_tipo_salida = $this->gsatelite->get_parametro('SYS_TIPO_PROCESO_REVERTIR_ENTRADA_SALIDA',null,null,array('id_tipo_proceso_revertir_salida'));            
            if (($id_tipo_salida == "" || $id_tipo_salida == null)){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Revetir entrada", 'texto_alerta' => "Parametro requerido");
                $this->session->set_flashdata($alerta);
                redirect('inventario/gestion_productos/salida_productos');                
            }else{
                //$data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $datos_entrada["moi_id_tip"]));       
                $data["tip_entrada"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $id_tipo_salida));                                       
                $data["tip_entrada"] = $id_tipo_salida;
            }      

            //print_r($data["tip_entrada"]); die();
            //Comentario
            $data["doc_referencia"] = ($datos_entrada['moi_documento'] != "") ? $datos_entrada['moi_documento'] :'';

            $detalle_requisicion = $this->gsatelite->get_tabla("dxm_detallexmovimiento", array("dxm_id_moi" => $datos_entrada["moi_id"]));

            //$data["doc_proveedor_dcp"] = $this->gsatelite->get_tabla("dcp_documento_proveedor",array("dcp_id"=>$datos_entrada["moi_id_dcp"]));
            //$data["doc_cliente_dcc"] = $this->gsatelite->get_tabla("dcp_documento_proveedor",array("dcp_id"=>$datos_entrada["moi_id_dcp"]));

            $data["bodega_bod"] = $this->gsatelite->get_tabla("bod_bodega", array("bod_id" => $datos_entrada["moi_id_bod"]));

            /* $sector_bodega = $this->gsatelite->get_tabla("sxb_sectorxbodega",array("sxb_id"=>$datos_entrada["moi_id_sxb"]));
            $data["sector_seb"] = $this->gsatelite->get_tabla("seb_sector_bodega",array("seb_id"=>$sector_bodega[0]["sxb_id_seb"])); */


            $data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $datos_entrada["moi_id_tip"]));

            //$data["detalle_movimiento"] = $this->gsatelite->get_tabla("dee_detalle_mov", array("dee_id_moi"=>$moi_id));
            $data["detalle_movimiento"] = $this->inventario_model->get_salidas_dee($moi_id);

            $data["sector_seb"] = $this->inventario_model->get_sector_grid($datos_entrada["moi_id_bod"]);


            $data["articulos"] = $this->gsatelite->get_tabla("art_articulo");
            $data["conversiones"] = $this->gsatelite->get_tabla("cva_conversion_articulo", array("cva_estado" => 1));
            $data["medida"] = $this->gsatelite->get_tabla("mep_medida_producto", array("mep_estado" => 1));
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['titulo_personal'] = 'Revertir salida de inventario';
            $this->_cargarvista($data);
        }
    }

    public function visualizar_revertir_entrada($moi_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data["moi_id_inicia_reversa"] = $moi_id;
            $data["movimiento_entrada"] = $this->gsatelite->get_tabla("moi_movimiento_inv", array("moi_estado" => 1, "moi_id" => $moi_id));
            $datos_entrada = $data["movimiento_entrada"][0];
            $data["proveedor_prv"] = $this->gsatelite->get_tabla("prv_proveedor", array("prv_id" => $datos_entrada["moi_id_prv"]));

            $this->db->join('prv_proveedor','prv_id = dpv_id_prv','left');
            $data["doc_proveedor_dcp"] = $this->gsatelite->get_tabla("dpv_documento_proveedor", array("dpv_id" => $datos_entrada["moi_id_dpv"]));
            $data['orc_documento'] = $this->gsatelite->get_dropdown('orc_orden_compra', '{orc_numero}', '', '', $data["movimiento_entrada"][0]['moi_id_orc'], '', 'orc_id', true);
            
            $this->db->join('rxi_requisicion_inventario','orc_id_rxi = rxi_id');
            $requisicion_rxi = $this->gsatelite->get_tabla('orc_orden_compra', array('orc_id' =>$data["movimiento_entrada"][0]['moi_id_orc']));            
            $data['requisicion_rxi'] = (count($requisicion_rxi)>0) ? $requisicion_rxi[0]['rxi_id'] : '';
            //$data["doc_cliente_dcc"] = $this->gsatelite->get_tabla("dcp_documento_proveedor",array("dcp_id"=>$datos_entrada["moi_id_dcp"]));
            $data["bodega_bod"] = $this->gsatelite->get_tabla("bod_bodega", array("bod_id" => $datos_entrada["moi_id_bod"]));
            /* $sector_bodega = $this->gsatelite->get_tabla("sxb_sectorxbodega",array("sxb_id"=>$datos_entrada["moi_id_sxb"]));
            $data["sector_seb"] = $this->gsatelite->get_tabla("seb_sector_bodega",array("seb_id"=>$sector_bodega[0]["sxb_id_seb"])); */

            $id_tipo_salida = $this->gsatelite->get_parametro('SYS_TIPO_PROCESO_REVERTIR_ENTRADA_SALIDA',null,null,array('id_tipo_proceso_revertir_entrada'));            
            if (($id_tipo_salida == "" || $id_tipo_salida == null)){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Revetir entrada", 'texto_alerta' => "Parametro requerido");
                $this->session->set_flashdata($alerta);
                redirect('inventario/gestion_productos/entrada_productos');                
            }else{
                //$data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $datos_entrada["moi_id_tip"]));       
                $data["entrada_tip"] = $this->gsatelite->get_tabla("tip_tipo_proceso", array("tip_id" => $id_tipo_salida)); 
                // $data["entrada_tip"] = $id_tipo_salida;
            } 
            //print_r($data["entrada_tip"]); die();
            $data["detalle_movimiento"] = $this->gsatelite->get_tabla("dee_detalle_mov", array("dee_id_moi" => $moi_id));
            $data["sector_seb"] = $this->inventario_model->get_sector_grid($datos_entrada["moi_id_bod"]);                        
            $data["articulos"] = $this->gsatelite->get_tabla("art_articulo");            
            $data["conversiones"] = $this->gsatelite->get_tabla("cva_conversion_articulo", array("cva_estado" => 1));
            $data["medida"] = $this->gsatelite->get_tabla("mep_medida_producto", array("mep_estado" => 1));
            $data['usuarios'] = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['decimales'] = ($this->gsatelite->get_parametro('NUMERO_DECIMALES'))?$this->gsatelite->get_parametro('NUMERO_DECIMALES'):2;
            $data['titulo_personal'] = 'Vista de inventario';
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Nelson Soriano
     * @param  id transferencia
     * @return estado de la transferencia
     */
    public function procesar_traslado(){
        satelite_validar();

        if ($this->input->post('id_traslado')) {
            $result     = true;
            $data       = explode('::', $this->input->post('id_traslado'));
            $operacion  = $data[0];
            $traslado   = $data[1];

            echo json_encode(array('resultado' => $result));
            die();
        }
    }

    /**
        * @author Francisco Orozco
        * @param  array condiciones
    */
    public function fefo( $condiciones = null ) {
        satelite_validar();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');

        //declaracion de variables de las condiciones
        $articulo               = ( isset($condiciones["articulo"]) )?$condiciones["articulo"]:null;
        $moi_id                 = ( isset($condiciones["moi_id"]) )?$condiciones["moi_id"]:null;
        $sector                 = ( isset($condiciones["sector"]) )?$condiciones["sector"]:null;
        $cantidad_solicitada    = ( isset($condiciones["cantidades"]) )?$condiciones["cantidades"]:0;
        $bodega                 = ( isset($condiciones["bodega"]) )?$condiciones["bodega"]:null;
        $lote                   = ( isset($condiciones["lote"]) )?$condiciones["lote"]:null;
        $cantidad_maxima        = ( isset($condiciones["cantidad_maxima"]) )?$condiciones["cantidad_maxima"]:null;
        $cva_id                 = ( isset($condiciones["id_conversion"]) )?$condiciones["id_conversion"]:null;
        $traslado               = ( isset($condiciones["traslado"]) )?$condiciones["traslado"]:null;
        $producto_destino       = ( isset($condiciones["producto_destino"]) )?$articulo:$condiciones["producto_destino"];
        $requisicion            = ( isset($condiciones["requisicion"]) )?$condiciones["requisicion"]:null;
        $empaques               = ( isset($condiciones["empaques"]) )?$condiciones["empaques"]:null;

        //inicializacion de variables 
        //Cantidad restante para repetir el foreach, dependiento de la cantidad que se ingreso.
        $cantidad_restante      = $cantidad_solicitada;
        //Cantidad para ingresar en la tabla dee_detalle
        $cantidad_ingresar      = 0;
        //Cantidad restante después de restarle la cantidad elegida
        $cantidad_actualizar    = 0;
        //Acumulador para salir del do while, cuando el acumulador es igual a la cantidad ingresada se saldrá del do while
        $acumulador_cantidad    = 0;
        $contador               = 0;
        
        //variables para la consulta de cantidades
        $where                  = null;
        $order_by               = "sar_fecha_caducidad";

        if ( $sector != "" ) {
            $where['sar_id_sxb'] = $sector;
        }

        if ( $lote != "" ) {
            $where['dee_codigo_lote'] = $lote;
        }

        $sar_saldo = $this->inventario_model->get_sar_cantidades($articulo, $bodega, $where, $order_by);
        
        if ($cantidad_solicitada <= $cantidad_maxima) { 
            do {
                $cantidad_sar   = $sar_saldo[$contador]['sar_cant_actual'];
                $fecha          = (trim($sar_saldo[$contador]['sar_fecha_caducidad']) != "") ? date('Y-m-d', strtotime($sar_saldo[$contador]['sar_fecha_caducidad'])) : null;
                $sar_id         = $sar_saldo[$contador]['sar_id'];
                $precio         = $sar_saldo[$contador]["sar_precio"];

                if ($cantidad_sar <= $cantidad_restante) {
                    $cantidad_restante      = $cantidad_restante - $cantidad_sar;
                    $cantidad_ingresar      = $cantidad_sar;
                    $cantidad_actualizar    = $cantidad_sar - $cantidad_ingresar;
                    $acumulador_cantidad   += $cantidad_ingresar;
                } else {
                    $temp                   = $cantidad_restante;
                    $cantidad_restante      = $cantidad_sar - $cantidad_restante;
                    $cantidad_ingresar      = $temp;
                    $cantidad_actualizar    = $cantidad_sar - $cantidad_ingresar;
                    $acumulador_cantidad   += $cantidad_ingresar;
                }

                $costo_total = $cantidad_ingresar * $precio;

                $dee_detalle_mov = array( //detalles de la salida
                    'dee_id_moi'                => $moi_id,
                    'dee_id_art'                => $articulo,
                    'dee_id_sar'                => $sar_id,
                    'dee_id_cva'                => $cva_id,
                    'dee_id_sxb'                => (trim($sector) != "") ? $sector : null,
                    'dee_cantidad'              => $cantidad_ingresar,
                    'dee_fecha_caducidad'       => $fecha,
                    'dee_precio'                => $precio,
                    'dee_subtotal'              => $costo_total,
                    'dee_codigo_lote'           => (trim($lote) != "") ? $lote : null,
                    'dee_estado'                => 1,
                    'dee_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'dee_fecha_creacion'        => date('Y-m-d H:i:s'),
                    'dee_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'dee_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
               
                $this->gsatelite->ingresar('dee_detalle_mov', $dee_detalle_mov);
                $sar_saldo_articulo = array(
                    'sar_cant_actual'           => $cantidad_actualizar,
                    'sar_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'sar_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('sar_saldo_articulo', $sar_saldo_articulo, array('sar_id' => $sar_id));

                if ($traslado != null) {
                    $sector = (trim($traslado["sector"]) != "") ? $traslado["sector"] : null;
                    $cadena_sar_insert = array( //producto destino
                        'sar_id_art'                => $producto_destino,
                        'sar_id_bod'                => $traslado["bodega"],
                        'sar_cant_actual'           => $cantidad_ingresar,
                        'sar_precio'                => $precio,
                        'sar_fecha_caducidad'       => $fecha,
                        'sar_id_sxb'                => $sector,
                        'sar_estado'                => 1,
                        'sar_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'sar_fecha_creacion'        => date('Y-m-d H:i:s'),
                        'sar_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'sar_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                    $sar_id_entrada = $this->gsatelite->ingresar('sar_saldo_articulo', $cadena_sar_insert);

                    $cadena_dee_insert = array( //detalle de la entrada
                        'dee_id_moi'                => $traslado["moi_entrada"],
                        'dee_id_art'                => $producto_destino,
                        'dee_id_sar'                => $sar_id_entrada,
                        'dee_id_cva'                => $cva_id,
                        'dee_id_sxb'                => $sector,
                        'dee_cantidad'              => $cantidad_ingresar,
                        'dee_fecha_caducidad'       => $fecha,
                        'dee_precio'                => $precio,
                        'dee_subtotal'              => $costo_total,
                        'dee_codigo_lote'           => $lote,
                        'dee_estado'                => 1,
                        'dee_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'dee_fecha_creacion'        => date('Y-m-d H:i:s'),
                        'dee_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'dee_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                    $dee_id = $this->gsatelite->ingresar('dee_detalle_mov', $cadena_dee_insert);

                    if ($empaques != null){
                        $this->traslado_empaque($empaques,$dee_id);
                    }
                }
                $contador++;
               // var_dump("acumulador de cantidad"+$acumulador_cantidad + "<br> cantidad"+$cantidad);die();
            } while ($acumulador_cantidad != $cantidad_solicitada);

        }
       
        if ($requisicion != null) {
            //hace los cambios en la requisicion
            if ($cantidad != 0) {
                $this->requisicion_salida($requisicion, $articulo, $moi_id, $cantidad);
            }
            //verifica si la requisicion cuenta con registros, si los estados de los productos estan concluidas el estado de la requisicion
            //pasa a despachado
            $cmb_estado = $this->inventario_model->mostrar_requisicion_salida($requisicion);
            if (count($cmb_estado) == 0) {
                $rxi_requisicion_inventario = array(
                    'rxi_estado'                => 0,
                    'rxi_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'rxi_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('rxi_requisicion_inventario', $rxi_requisicion_inventario, array('rxi_id' => $requisicion));
            }
        }
        return 1;
    }

    /**
    * @author Raul Escalante
    * @param  articulo, bodega, cantidad y precio de la entrada actual
    * @return precio promedio de los articulos incluyendo lo ya inventariado
    */
    public function recalcular_precio_promedio($articulo, $bodega, $cantidad, $precio){
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES','2');
        $existencia = ($cantidad != 0) ? $cantidad : 0; //ctdad nueva
        $valores    = ($precio != 0) ? ($precio * $existencia) : 0;     //valor (ctdad * precio)
        $ids = array();
        $where['art_id'] = $articulo;
        $where['bod_id'] = $bodega;
        $actual_existenc = $this->inventario_model->calcular_precio_promedio($where); //obtener lo que hay        
        foreach ($actual_existenc as $key => $value) {
            $existencia += ($value['sar_cant_actual'] != '') ? $value['sar_cant_actual'] : 0;
            $valores    += ($value['valor'] != '') ? $value['valor'] : 0;
            $ids[] = $value['sar_id'];        
        }
        $nuevo_precio = round(($valores / $existencia), $decimales);//precio promedio (valor/ctdad)
        $new_price = array('sar_precio' => $nuevo_precio);
        if (!(empty($ids))) {
            foreach ($ids as $key => $value) {
                $this->gsatelite->actualizar_array('sar_saldo_articulo', $new_price, array('sar_id' => $value));
            }
        }        
        return $nuevo_precio;
    }

    function imprimir_rxi() {
        satelite_validar();
        if ($_POST) {            
            $post_array = $this->input->post();
            $data['rxi_num']     = $post_array["num_rxi"];
            $data['rxi_fecha']   = $post_array["fecha_rxi"];
            $data['rxi_tipo']    = $post_array["tipo_rxi"];
            $data['rxi_solic']   = $post_array["solic_rxi"];
            $data['bod_id']      = $post_array["bod_rxi"];
            $data['rxi_bod']     = $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('bod_id' => $post_array["bod_rxi"]));
            $data['rxi_estado']  = $post_array["stdo_rxi"];
            $data['rxi_detalle'] = $this->inventario_model->get_requisicion_detalle(array('dri_id_rxi' => $post_array["id_rxi"]));
                                   $this->db->join("are_area", "are_id = emp_id_are");
            $data['rxi_are_slc'] = $this->gsatelite->get_tabla("emp_empleado", array("emp_id" => $data['rxi_detalle'][0]['rxi_id_emp']));
            $existe_fri = $this->gsatelite->get_tabla('fri_formato_impresion', array('fri_estado' => 1, 'fri_activo' => 1, 'fri_tipo_formato' => 7));
            if (count($existe_fri) > 0) {
                $conf_formato_array = json_decode($existe_fri[0]["fri_configuraciones_formato"], true);
                $data['config'] = $conf_formato_array;
                $hoja = explode(',',  $conf_formato_array['FORMATO']);
                $hojasize = (count($hoja) == 2) ? array($hoja[0], $hoja[1]) : 'Letter';
                $fuente = $conf_formato_array['FUENTE'];
                $html = $this->load->view('inventario/reportes/' . $existe_fri[0]['fri_archivo'], $data, true);
                $this->pdf->SetMargins(0, 0, 0);
                $this->pdf->setPrintFooter(false);
                $this->pdf->setCellPaddings(0, 0, 0, 0);
                $this->pdf->AddPage('P', $hojasize, array('family' => $fuente, 'style' => '', 'size' => 6) , true);
                $this->pdf->writeHTML($html, true, false, false, false, '');
                $this->pdf->boletaPDF('I');
            } else {
                $html = $this->load->view('inventario/reportes/detalle_rxi', $data, true);
                $data['titulo'] = "Requisición de Inventario";
                $header = $this->load->view('reporte/header', $data, true);
                $reporte = $header . $html;
                $this->pdf->SetTitle('Requisicion_' . $post_array["num_rxi"]);
                $this->pdf->makePdf($reporte, 'P', 'Reporte_requisicion_inventario', 'Letter');
            }
            /*
            $html = $this->load->view('inventario/reportes/detalle_rxi', $data, true);
            $data['titulo'] = "Requisición de Inventario";
            $header = $this->load->view('reporte/header', $data, true);
            $reporte = $header . $html;
            $this->pdf->SetTitle('Requisicion_' . $post_array["num_rxi"]);
            $this->pdf->makePdf($reporte, 'P', 'Reporte_requisicion_inventario', 'Letter');        
            */
        }
    }

    function picking_list($flag = null){
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/gestion_productos/picking_list');
        if ($_POST) {
            $post_array = $this->input->post();
            $estado = $post_array['estado'];
            $fecha_ini = formatear_fecha('Y-m-d', $post_array['fecha_ini']);
            $fecha_fin = formatear_fecha('Y-m-d', $post_array['fecha_fin']);
            $where['pkl_fecha >=']  = $fecha_ini . ' 00:00:00';
            $where['pkl_fecha <=']  = $fecha_fin . ' 23:59:59';
            if ($estado != '' && $estado >= 0) {
                $where['pkl_estado_picking_list'] = $estado;
            }
            $data['entradas'] = $this->inventario_model->get_backlog_picking_list($where);
            $html = $this->load->view('inventario/gestion_productos/consultar_picking_list', $data, true);
            if ($flag) {
                echo $html;    
            }
            die();
        } else {
            $data['titulo_personal'] = 'Picking List';
            $this->_cargarvista($data);
        }        
    }

    function agregar_picking_list(){
        satelite_validar();
        if ($_POST) {
            $redireccion = $this->input->post('btnCrear');
            $cliente     = $this->input->post('slcCliente');
            $fecha_pick  = $this->input->post('txtFecha');
            $suc_user    = $this->input->post('idSucursal');
            $vendedor    = $this->input->post('slcVendedor');
            $comentarios = $this->input->post('txtComentario');
            $orden       = $this->input->post('slcOrden');
            $bodega      = $this->input->post('slcBodega');
            $code_pick   = $this->input->post('code_pick');
            $fecha_orden = $this->input->post('fecha_orden');
            $dov_id      = $this->input->post('dov_id');//array
            $articulos   = $this->input->post('art_id'); //array
            $uni_medida  = $this->input->post('cva_id'); //array
            $disponible  = $this->input->post('tot_disp'); //array con las ctdades de c/art en esa bod
            $lotes_ids   = $this->input->post('lop_ids'); //array con los id de los lotes
            $ctdad_solic = $this->input->post('cant_sol'); //array con las ctdades solicitadas segun dov
            $ctdad_lop   = $this->input->post('ctd_lop'); //array con los valores reservados en cada lote
            $act_val     = $this->input->post('act_val'); //array con los valores iniciales de los lotes
            $sar_ids     = $this->input->post('sar_ids'); //array con los id de los sar
            $pdtes       = $this->input->post('pdtes'); //array con la ctdad no cubierta
            $ultimo = $this->gsatelite->get_max('pkl_picking_list', 'pkl_correlativo');
            $correlativo = ($ultimo != NULL) ? ($ultimo + 1) : 1;
            $sin_exist = 0;
            foreach ($lop_ids as $key => $value) {//si todos los detalles poseen al menos un lote
                if ($value == '') {
                    $sin_exist++;
                }
            }
            $estado_pick = ($sin_exist > 0) ? 1 : 2;//1 = pendiente (no completo), 2=completo (listo a facturar)
            //se crea el picking
            $picking_list = array(
                'pkl_id_suc' => $suc_user,
                'pkl_id_usu' => $this->tank_auth->get_user_id(),
                'pkl_correlativo' => $correlativo,
                'pkl_codigo' => $code_pick,
                'pkl_descripcion' => $comentarios,
                'pkl_fecha' => date("Y-m-d H:i:s"),
                'pkl_fecha_orden' => formatear_fecha('Y-m-d H:i:s', $fecha_orden),
                'pkl_estado_picking_list' => $estado_pick,
                'pkl_estado' => 1,                
                'pkl_fecha_creacion' => date("Y-m-d H:i:s"),
                'pkl_usu_creacion' => $this->tank_auth->get_user_id(),
                'pkl_fecha_modificacion' => date("Y-m-d H:i:s"),
                'pkl_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $this->db->insert('pkl_picking_list', $picking_list);
            $pkl_id = $this->db->insert_id();
            //crear el detalle del pick
            for ($i=0; $i < count($dov_id) ; $i++) {             
                $reservados = $ctdad_solic[$i] - $pdtes[$i];
                $detalle_picking_list = array(
                    'dxk_id_pkl' => $pkl_id,
                    'dxk_id_dov' => $dov_id[$i],
                    'dxk_id_bod' => $bodega,
                    'dxk_cantidad_reserva' => $reservados,
                    'dxk_cantidad_solicita' => $ctdad_solic[$i],
                    'dxk_cantidad_restante' => $pdtes[$i],
                    'dxk_estado' => 1,
                    'dxk_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dxk_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dxk_fecha_creacion' => date("Y-m-d H:i:s"),
                    'dxk_fecha_modificacion' => date("Y-m-d H:i:s")
                );
                $dxk_id = $this->gsatelite->ingresar('dxk_detalle_ordenxpicking_list', $detalle_picking_list);
                //los lotes involucrados
                if ($lotes_ids[$i] != '' && $ctdad_lop[$i] != '') {
                    $lop_ids = explode(',', $lotes_ids[$i]);
                    $ctd_lop = explode(',', $ctdad_lop[$i]);
                    $ctd_ini = explode(',', $act_val[$i]);
                    $ids_sar = explode(',', $sar_ids[$i]);
                    for ($j=0; $j < count($lop_ids) ; $j++) { 
                        $restante = $ctd_ini[$j] - $ctd_lop[$j];
                        $lote_picking_list = array(
                            'ldp_id_dxk' => $dxk_id,
                            'ldp_id_lop' => $lop_ids[$j],
                            'ldp_cantidad_reserva' => $ctd_lop[$j],  
                            'ldp_cantidad_solicita' => $ctdad_solic[$i],
                            'ldp_cantidad_restante' => $restante,
                            'ldp_estado' => 1,
                            'ldp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ldp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ldp_fecha_creacion' => date("Y-m-d H:i:s"),
                            'ldp_fecha_modificacion' => date("Y-m-d H:i:s")
                        );
                        $ldp_id = $this->gsatelite->ingresar('ldp_lotexdetalle_picking', $lote_picking_list);
                    } 
                    for ($k=0; $k < count($ids_sar) ; $k++) { 
                        $restante = $ctd_ini[$k] - $ctd_lop[$k];
                        $sar_picking_list = array(
                            'sxk_id_sar' => $ids_sar[$k],
                            'sxk_id_dxk' => $dxk_id,
                            'sxk_cantidad_reserva' => $ctd_lop[$k],  
                            'sxk_cantidad_solicita' => $ctdad_solic[$i],
                            'sxk_cantidad_restante' => $restante,
                            'sxk_estado' => 1,
                            'sxk_usu_creacion' => $this->tank_auth->get_user_id(),
                            'sxk_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sxk_fecha_creacion' => date("Y-m-d H:i:s"),
                            'sxk_fecha_modificacion' => date("Y-m-d H:i:s")
                        );
                        $sxk_id = $this->gsatelite->ingresar('sxk_saldo_artxdetalle_picking_list', $sar_picking_list);
                    }
                }
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Picking List", 'texto_alerta' => "El registro se guardó correctamente");
            $this->session->set_flashdata($alerta);
            if ($redireccion == 2) {
                redirect('/inventario/gestion_productos/picking_list');
            } else {
                redirect('/inventario/gestion_productos/agregar_picking_list');
            }
        } else {
            $this->db->join('orv_orden_venta','cli_id = orv_id_cli');
            $sel_cli = $this->gsatelite->get_dropdown('cli_cliente', '[CASE WHEN cli_personeria = 2 THEN CONCAT(cli_codigo,"-",cli_apellido) ELSE CONCAT(cli_codigo,"-",cli_nombre," ",cli_apellido) END]', '', array('orv_aplica_picking_list' => 1), null, '', '', true);
            $sel_ven = $this->gsatelite->get_dropdown('ven_vendedor', '[CONCAT(ven_codigo,"-",ven_nombre," ",ven_apellidos)]', '', array('ven_estado' => 1), null, '', '', true);
            $usuario = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $tabla = $this->gsatelite->get_max('pkl_picking_list', 'pkl_id');
            $data['clientes']        = str_replace('<option value="0">Seleccione</option>', '', $sel_cli);
            $data['vendedores']      = str_replace('<option value="0">Seleccione</option>', '', $sel_ven);
            $data['correlativo']     = ($tabla != NULL) ? ($tabla+1) : 1;
            $data['info_usuario']    = $usuario[0];
            $data['titulo_personal'] = 'Agregar Picking List';
            $this->_cargarvista($data);
        }
    }

    function get_info_cli_pkl(){
        $cli_id = $this->input->post('cliente');
        $ordenes = "<option value=''></option>";
        $datos = $this->inventario_model->get_ordenes_cliente($cli_id);
        foreach ($datos as $key => $value) {
            $ordenes .= '<option value="' . $value['orv_id'] . '">Orden #'. $value['orv_numero_orden'] . '</option>';
        }
        $vendedor = $this->inventario_model->get_vendedor_orden_cliente($cli_id);
        $arreglo = array('ordenes' => $ordenes, 'ven_id' => $vendedor[0]['orv_id_ven']);
        echo json_encode($arreglo);
    }

    function get_info_bod_pkl(){
        $orden = $this->input->post('orden');
        $this->db->join('dov_detalle_orden_venta',"bod_id = dov_id_bod");
        $this->db->join('orv_orden_venta',"orv_id = dov_id_orv");        
        $bodegas =  str_replace('<option value="0">Seleccione</option>', '', $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', '', array('bod_estado' => 1,'dov_id_orv' => $orden), null, '', '', true));        
        $fecha_orden = $this->gsatelite->get_campo('orv_orden_venta', 'orv_fecha_orden', array('orv_id' => $orden));
        $arreglo = array('bodegas' => $bodegas,'fecha_orden' => $fecha_orden);
        echo json_encode($arreglo);
    }

    function validar_saldos_orden(){
        $movimiento_lote = array();
        $moe_id_moi = array();
        $codigo   = $this->input->post('codigo');
        $cliente  = $this->input->post('cliente');
        $orden    = $this->input->post('orden');
        $vendedor = $this->input->post('vendedor');
        $bodega   = $this->input->post('bodega');
        $where['orv_id_cli'] = $cliente;
        $where['orv_id'] = $orden;
        $filas = '';
        if ($vendedor != '') {
            $where['orv_id_ven '] = $vendedor;
        } 
        $detalle_orden  = $this->inventario_model->get_detalle_orden($where);//detalle de la orden de venta        
        foreach ($detalle_orden as $key => $value) {
            $where_det['axo_id_art'] = $value['dov_id_art'];
            if ($value['dov_id_cva'] != '') {
                $where_det['axo_id_cva'] = $value['dov_id_cva'];
            }
            $movimiento_lote[$value['dov_id_art']] = $this->inventario_model->get_moe_id_moi($where_det);//si existen lotes de produccion para ese articulo
        }
        foreach ($movimiento_lote as $key => $value) {
            if (count($value) > 0) {
                $moe_id_moir[$key] = implode(',', array_column($value, 'moe_id_moi'));//ids de los lotes
            }else{
                $moe_id_moir[$key] = false;
            }            
        }
        foreach ($moe_id_moir as $key => $value) {
            $datos_art = $this->inventario_model->get_datos_art($key, $orden);
            $id = $cliente . '_' . $orden . '_' . $bodega . '_' . $key;//cliente-orden-bodega-articulo
            if ($value) {
                $i = 0;
                $valores = $this->inventario_model->get_art_bod_pick($key,$datos_art[0]['cva_id'],$bodega,$value);
                if (!(empty($valores))) {//si los lotes del articulo estan en esta bodega       
                    $total_disponible = (array_sum(array_column($valores, 'sar_cant_actual')) - array_sum(array_column($valores, 'reservado')));
                    $numero_lotes = count($valores);
                    $filas .= '<tr id="tr_'.$cliente.'_'.$orden.'_'.$bodega.'">';
                    $filas .= '<td>' . $codigo . '</td>';
                    $filas .= '<td>' . $datos_art[0]['orv_numero_orden'] . '</td>';
                    $filas .= '<td>' . $datos_art[0]['art_nombre'] . '<input type="hidden" name="art_id[]" id="art_id_'.$id.'" value="'. $key . '">';
                    $filas .= '<input type="hidden" name="dov_id[]" id="dov_id_'.$id.'" value="'. $datos_art[0]['dov_id'] . '"></td>';
                    $filas .= '<td>' . $datos_art[0]['mep_nombre'] . '<input type="hidden" name="cva_id[]" id="cva_id_'.$id.'" value="'. $datos_art[0]['cva_id'] . '"></td>';
                    $filas .= '<td>' . $total_disponible . '<input type="hidden" name="tot_disp[]" id="tot_disp_'.$id.'" value="'. $total_disponible . '"></td>';                    
                    $filas .= '<td>' . $valores[0]['lop_nombre'] . ' <a href="#modalLotes_'.$key.'" class="ver_en_modal"><span class="icon16 icomoon-icon-list-view"></span></a>';
                    $filas .= '<div id="modalLotes_'.$key.'" style="display: none;" ><div class="box"><div class="title"><h4><span>Detalle</span></h4></div><div class="content">';
                    $filas .= '<table border="1"><thead><tr><th>Número de Lote</th><th>Cantidad Necesaria</th><th>Saldo en Lote</th></tr></thead><tbody>';
                    $flag = true;
                    $pendiente = $datos_art[0]['dov_cantidad'];                
                    $sar_id = $lote_ids = $actual = $reserva_lote = array();
                    $disponible = $valores[$i]['sar_cant_actual'] - $valores[$i]['reservado'];
                    do {
                        $filas .= '<tr><td>'. $valores[$i]['lop_nombre'] . '</td><td>' . number_format($pendiente,2) . '</td><td>' . number_format($disponible,2) . '</td></tr>';
                        $reserva = ($pendiente >= $disponible) ? $disponible : $pendiente;
                        $lote_ids[] = $valores[$i]['lop_id'];
                        $actual[] = $disponible;
                        $sar_id[] = $valores[$i]['sar_id'];
                        $reserva_lote[] = $reserva;
                        $pendiente = $pendiente - $disponible;
                        $numero_lotes--;
                        $i++;
                        if ($pendiente <= 0 || $numero_lotes == 0) {
                            $flag = false;
                        }
                    } while ($flag);
                    $act_val = implode(',', $actual);
                    $lop_ids = implode(',', $lote_ids);
                    $ctd_lop = implode(',', $reserva_lote);
                    $sar_ids = implode(',', $sar_id);
                    $pdte = ($pendiente > 0) ? $pendiente : 0;
                    $filas .= '</tbody></table></div></div></div><input type="hidden" name="lop_ids[]" id="lop_ids_'.$id.'" value="'. $lop_ids . '">';
                    $filas .= '<input type="hidden" name="ctd_lop[]" id="ctd_lop_'.$id.'" value="'. $ctd_lop . '">';
                    $filas .= '<input type="hidden" name="act_val[]" id="act_val_'.$id.'" value="'. $act_val . '">';
                    $filas .= '<input type="hidden" name="sar_ids[]" id="sar_ids_'.$id.'" value="'. $sar_ids . '">';
                    $filas .= '<input type="hidden" name="pdtes[]" id="pdtes_'.$id.'" value="'. $pdte . '"></td>';
                    $filas .= '<td>' . $datos_art[0]['dov_cantidad'] . '<input type="hidden" name="cant_sol[]" id="cant_sol_'.$id.'" value="'. $datos_art[0]['dov_cantidad'] . '"></td>';
                    $filas .= '<td><button type="button" class="btn btn-danger btn-mini remover_tr" style="float:left; height:30px;width:50px;">Eliminar</button></td>';
                    $filas .= "</tr>";
                }else{
                    $filas .= '<tr id="tr_'.$cliente.'_'.$orden.'_'.$bodega.'">';
                    $filas .= '<td>' . $codigo . '</td>';
                    $filas .= '<td>' . $datos_art[0]['orv_numero_orden'] . '</td>';
                    $filas .= '<td>' . $datos_art[0]['art_nombre'] . '<input type="hidden" name="art_id[]" id="art_id_'.$id.'" value="'. $key . '">';
                    $filas .= '<input type="hidden" name="dov_id[]" id="dov_id_'.$id.'" value="'. $datos_art[0]['dov_id'] . '"></td>';
                    $filas .= '<td>' . $datos_art[0]['mep_nombre'] . '<input type="hidden" name="cva_id[]" id="cva_id_'.$id.'" value="'. $datos_art[0]['cva_id'] . '"></td>';
                    $filas .= '<td>0.00 &nbsp;<input type="hidden" name="tot_disp[]" id="tot_disp_'.$id.'" value="0.00"></td>';
                    $filas .= '<td>N/A &nbsp;<input type="hidden" name="lop_ids[]" id="lop_ids_'.$id.'" value="">';
                    $filas .= '<input type="hidden" name="ctd_lop[]" id="ctd_lop_'.$id.'" value="">';
                    $filas .= '<input type="hidden" name="act_val[]" id="act_val_'.$id.'" value="">';
                    $filas .= '<input type="hidden" name="sar_ids[]" id="sar_ids_'.$id.'" value="">';
                    $filas .= '<input type="hidden" name="pdtes[]" id="pdtes_'.$id.'" value="'. $datos_art[0]['dov_cantidad'] . '"></td>';
                    $filas .= '<td>' . $datos_art[0]['dov_cantidad'] . '<input type="hidden" name="cant_sol[]" id="cant_sol_'.$id.'" value="'. $datos_art[0]['dov_cantidad'] . '"></td>';
                    $filas .= '<td><button type="button" class="btn btn-danger btn-mini remover_tr" style="float:left; height:30px;width:50px;">Eliminar</button></td>';
                    $filas .= "</tr>";
                }
            } else {
                $filas .= '<tr id="tr_'.$cliente.'_'.$orden.'_'.$bodega.'">';
                $filas .= '<td>' . $codigo . '</td>';
                $filas .= '<td>' . $datos_art[0]['orv_numero_orden'] . '</td>';
                $filas .= '<td>' . $datos_art[0]['art_nombre'] . '<input type="hidden" name="art_id[]" id="art_id_'.$id.'" value="'. $key . '">';
                $filas .= '<input type="hidden" name="dov_id[]" id="dov_id_'.$id.'" value="'. $datos_art[0]['dov_id'] . '"></td>';
                $filas .= '<td>' . $datos_art[0]['mep_nombre'] . '<input type="hidden" name="cva_id[]" id="cva_id_'.$id.'" value="'. $datos_art[0]['cva_id'] . '"></td>';
                $filas .= '<td>0.00<input type="hidden" name="tot_disp[]" id="tot_disp_'.$id.'" value="0.00"></td>';
                $filas .= '<td>N/A &nbsp;<input type="hidden" name="lop_ids[]" id="lop_ids_'.$id.'" value="">';
                $filas .= '<input type="hidden" name="ctd_lop[]" id="ctd_lop_'.$id.'" value="">';
                $filas .= '<input type="hidden" name="act_val[]" id="act_val_'.$id.'" value="">';
                $filas .= '<input type="hidden" name="sar_ids[]" id="sar_ids_'.$id.'" value="">';
                $filas .= '<input type="hidden" name="pdtes[]" id="pdtes_'.$id.'" value="'. $datos_art[0]['dov_cantidad'] . '"></td>';
                $filas .= '<td>' . $datos_art[0]['dov_cantidad'] . '<input type="hidden" name="cant_sol[]" id="cant_sol_'.$id.'" value="'. $datos_art[0]['dov_cantidad'] . '"></td>';
                $filas .= '<td><button type="button" class="btn btn-danger btn-mini remover_tr" style="float:left; height:30px;width:50px;">Eliminar</button></td>';
                $filas .= "</tr>";
            }
        }
        $arreglo = array('filas' => $filas);
        echo json_encode($arreglo);
    }

    function editar_picking_list($id = NULL, $ver = NULL){
        satelite_validar();
        if ($_POST) {            
            $comentarios = $this->input->post('txtComentario');
            $redireccion = $this->input->post('btnCrear');
            $actualizar  = array(
                'pkl_descripcion' => $comentarios,
                'pkl_fecha_modificacion' => date("Y-m-d H:i:s"),
                'pkl_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $resultado = $this->gsatelite->actualizar_array('pkl_picking_list', $actualizar, array('pkl_id' => $id));
            if ($resultado > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Picking List", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Picking List", 'texto_alerta' => "Ocurrio un problema al guardar el registro.");
            }
            $this->session->set_flashdata($alerta);
            if ($redireccion == 2) {
                redirect('/inventario/gestion_productos/picking_list');
            } else {
                redirect('/inventario/gestion_productos/agregar_picking_list');
            }
        } else {
            $detalles = $this->inventario_model->get_detalle_picking($id);        
            $this->db->join('orv_orden_venta','cli_id = orv_id_cli');
            $sel_cli = $this->gsatelite->get_dropdown('cli_cliente', '[CASE WHEN cli_personeria = 2 THEN CONCAT(cli_codigo,"-",cli_apellido) ELSE CONCAT(cli_codigo,"-",cli_nombre," ",cli_apellido) END]', '', array('orv_aplica_picking_list' => 1), $detalles[0]['orv_id_cli'], '', '', true);
            $sel_ven = $this->gsatelite->get_dropdown('ven_vendedor', '[CONCAT(ven_codigo,"-",ven_nombre," ",ven_apellidos)]', '', array('ven_estado' => 1), $detalles[0]['orv_id_ven'], '', '', true);
            $orden = $this->gsatelite->get_dropdown('orv_orden_venta', 'Orden #{orv_numero_orden}', '', array('orv_aplica_picking_list' => 1,'orv_estado' => 1), $detalles[0]['orv_id'], '', '', true);
            $bodegas = $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', '', array('bod_estado' => 1), $detalles[0]['dxk_id_bod'], '', '', true);
            $usuario = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['clientes']        = str_replace('<option value="0">Seleccione</option>', '', $sel_cli);
            $data['vendedores']      = str_replace('<option value="0">Seleccione</option>', '', $sel_ven);
            $data['orden']           = str_replace('<option value="0">Seleccione</option>', '', $orden);
            $data['bodegas']         = str_replace('<option value="0">Seleccione</option>', '', $bodegas);
            $data['detalles']        = $detalles;
            $data['id']              = $id;
            $data['ver']             = $ver;
            $data['info_usuario']    = $usuario[0];
            $data['titulo_personal'] = 'Editar Picking List';
            if ($ver) {
                $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/editar_picking_list', $data);
            } else {
                $this->_cargarvista($data);
            }            
        }
    }

    function anular_picking_list($id = null){
        satelite_validar();
        if($_POST) {
            $motivo_anula = $this->input->post('motivo_anulacion');
            $detalles = $this->inventario_model->get_detalle_picking($id);            
            $actualizar  = array(
                'pkl_fecha_anuacion' => date("Y-m-d H:i:s"),
                'pkl_descripcion_anulacion' => $motivo_anula,
                'pkl_estado_picking_list' => 0,
                'pkl_fecha_modificacion' => date("Y-m-d H:i:s"),
                'pkl_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $resultado = $this->gsatelite->actualizar_array('pkl_picking_list', $actualizar, array('pkl_id' => $id));
            if ($resultado > 0) {
                for ($i=0; $i < count($detalles) ; $i++) {
                    $anular_detalle = array(
                        'dxk_estado' => 0,
                        'dxk_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dxk_fecha_modificacion' => date("Y-m-d H:i:s")
                    );
                    $res_dxk = $this->gsatelite->actualizar_array('dxk_detalle_ordenxpicking_list', $anular_detalle, array('dxk_id' => $detalles[$i]['dxk_id'] ,'dxk_id_pkl' => $id));
                    if ($detalles[$i]['ldp_id'] != NULL || trim($detalles[$i]['ldp_id']) != '') {
                        $anular_lote = array(
                            'ldp_cantidad_reserva' => 0,  
                            'ldp_estado' => 0,
                            'ldp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ldp_fecha_modificacion' => date("Y-m-d H:i:s")
                        );
                        $res_ldp = $this->gsatelite->actualizar_array('ldp_lotexdetalle_picking', $anular_lote, array('ldp_id' => $detalles[$i]['ldp_id'] ,'ldp_id_dxk' => $detalles[$i]['dxk_id']));
                    }
                    if ($detalles[$i]['sxk_id'] != NULL || trim($detalles[$i]['sxk_id']) != '') {
                        $anular_sxk = array(
                            'sxk_cantidad_reserva' => 0,  
                            'sxk_estado' => 0,
                            'sxk_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sxk_fecha_modificacion' => date("Y-m-d H:i:s")
                        );                        
                        $res_sxk = $this->gsatelite->actualizar_array('sxk_saldo_artxdetalle_picking_list', $anular_sxk, array('sxk_id' => $detalles[$i]['sxk_id'] ,'sxk_id_dxk' => $detalles[$i]['dxk_id']));
                    }
                }  
                $titulo = 'Exito';
                $registro = 1;
            } else {
                $titulo = 'Error';
                $registro = 0;
            }
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect('/inventario/gestion_productos/anular_picking_list/');
        } else {
            $detalles = $this->inventario_model->get_detalle_picking($id);            
            $this->db->join('orv_orden_venta','cli_id = orv_id_cli');
            $sel_cli = $this->gsatelite->get_dropdown('cli_cliente', '[CASE WHEN cli_personeria = 2 THEN CONCAT(cli_codigo,"-",cli_apellido) ELSE CONCAT(cli_codigo,"-",cli_nombre," ",cli_apellido) END]', '', array('orv_aplica_picking_list' => 1), $detalles[0]['orv_id_cli'], '', '', true);
            $usuario = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['clientes']     = str_replace('<option value="0">Seleccione</option>', '', $sel_cli);
            $data['vendedores']   = str_replace('<option value="0">Seleccione</option>', '', $this->gsatelite->get_dropdown('ven_vendedor', '[CONCAT(ven_codigo,"-",ven_nombre," ",ven_apellidos)]', '', array('ven_estado' => 1), $detalles[0]['orv_id_ven'], '', '', true));
            $data['orden']        = str_replace('<option value="0">Seleccione</option>', '', $this->gsatelite->get_dropdown('orv_orden_venta', 'Orden #{orv_numero_orden}', '', array('orv_aplica_picking_list' => 1,'orv_estado' => 1), $detalles[0]['orv_id'], '', '', true));
            $data['bodegas']      = str_replace('<option value="0">Seleccione</option>', '', $this->gsatelite->get_dropdown('bod_bodega', 'bod_nombre', '', array('bod_estado' => 1), $detalles[0]['dxk_id_bod'], '', '', true));
            $data['detalles']     = $detalles;
            $data['id']           = $id;
            $data['info_usuario'] = $usuario[0];
            $data['titulo_personal'] = "Anulación de Picking List";            
            $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/anulacion_picking_list', $data);
        }
    }

    public function salida_inventario_automatica_x_orden($rxi_id = null){
       
        if ($rxi_id > 0 ) {

            $where = array(
                'rxi_id' => $rxi_id
            );
            $detalles       = $this->inventario_model->get_requisicion_detalle($where);            
            $orden          = $this->gsatelite->get_tabla('ord_orden', array('ord_id' => $detalles[0]['rxi_id_ord']) );
            $moi_id_tip     = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array("SAL_MAT_OP")); 
            $tipo_proceso   = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO', 0);
            
            $this->db->insert('moi_movimiento_inv', array(
                'moi_id_prv'            => null,
                'moi_id_dpv'            => null,
                'moi_id_tip'            => $moi_id_tip,
                'moi_id_bod'            => $detalles[0]['rxi_id_bod'],
                'moi_id_fac'            => null,
                'moi_documento'         => $orden[0]['ord_codigo'],
                'moi_id_rxi'            => $rxi_id,
                'moi_descripcion'       => 'Generación Automática' . $orden[0]['ord_codigo'] ,
                'moi_fecha_mov'         => date('Y-m-d H:i:s'),
                'moi_estado'            => 1,
                'moi_usu_creacion'      => $this->tank_auth->get_user_id(),
                'moi_fecha_creacion'    => date('Y-m-d H:i:s'),
                'moi_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'moi_fecha_modificacion'=> date('Y-m-d H:i:s')
            ));            
            $moi_id = $this->db->insert_id(); 
            foreach ($detalles as $key => $detalle) {
                $cantidades = $this->inventario_model->get_cantidad_bodega(null, $detalle['rxi_id_bod'], null, $detalle['art_id']);             
                //evaluara el tipo de proceso que debe seguir
                if ($tipo_proceso == 2) { //si es por fefo
                    $condiciones = array (
                        "articulo"          => $detalle['art_id'],
                        "moi_id"            => $moi_id,
                        "sector"            => null,
                        "cantidades"        => $detalle['dri_cantidad'],
                        "bodega"            => $detalle['rxi_id_bod'],
                        "lote"              => null,
                        "cantidad_maxima"   => $cantidades[0]["cantidad"],
                        "id_conversion"     => $detalle['mep_id'],
                        "traslado"          => null,
                        "producto_destino"  => null,
                        "requisicion"       => $rxi_id
                    );

                    $this->fefo( $condiciones );
                } else {
                    if ($rxi_id != null) {
                        $this->peps_salida($detalle['art_id'], null, $moi_id, $detalle['mep_id'], $detalle['dri_cantidad'], null, $cantidades[0]["cantidad"], $detalle['rxi_id_bod'], null, $rxi_id, null);
                    } else {
                        $this->peps_salida($detalle['art_id'], null, $moi_id,$detalle['mep_id'], $detalle['dri_cantidad'], null, $cantidades[0]["cantidad"], $detalle['rxi_id_bod'], null, null, null);
                    }
                }
            }

            /************ Solicitud de materiales para produccion ******************************/
            $this->consolidar_solicitud_materiales($rxi_id);

            /************ Generar asiento contable Salida inventario ******************************/
            $generar_partida= $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_INVENTARIO');
            $cliente        = null;
            if($generar_partida > 0) {
                $res_haber = $this->generar_asiento_salida_inv_haber($moi_id);
                $data_movimiento = array(
                    'moi_id'        => $moi_id,
                    'moi_fecha_mov' => (trim($this->input->post('fecha_registro')) != '')?  formatear_fecha('Y-m-d',$this->input->post('fecha_registro')) . ' ' . date('H:i:s') : date('Y-m-d H:i:s'),
                    'moi_id_dpv'    => null,
                    'moi_id_fac'    => null,
                    'moi_documento' => $orden[0]['ord_codigo'],
                    'moi_id_rxi'    => $rxi_id,
                );
                $this->generar_asiento_salida_inv_debe($cliente, $res_haber['id_pct'], $res_haber['total_debe'], $data_movimiento);
                $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_haber['id_pct']), array('moi_id' => $moi_id));
            }

        } 
    }

    public function generar_movimiento_masivo($proceso = 0){
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');  
        $hora_inicio = date('Y-m-d H:i:s');
        if ($this->input->post()) {
            $post_array = $this->input->post();
            
            if($proceso == 0){
                $tipoProceso = $post_array['tipo_proceso'];
                //Salida por Facturación
                if($tipoProceso == 1){

                    //Se obtienen las facturas por día
                    $facturas = $this->inventario_model->get_factura_sin_movimiento(
                        array('fac_total > 0' => null,
                            'moi_id_fac IS NULL' => null
                        ),
                        " DATE(fac_fecha_fact) AS fecha_factura, count(fac_id) as facturas", "DATE(fac_fecha_fact)");

                    //print_r($this->db->last_query());die();
                    $data['facturas'] = $facturas;

                    $html = $this->load->view('inventario/gestion_productos/movimiento_masivo_factura', $data, true);

                    echo json_encode(array('html' => $html,'registros' => count($facturas)));
                    die();
                }
            }else{
                //Se inicia a procesar la información segun sea el tipo
               if($proceso == 1){
                    //Se procesan los movimientos de salida por Factura.
                    $fecha_factura = $post_array['fecha_factura'];
                    //$fecha_factura_f    = '2019-02-10';
                    $bodega_factura = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
                    $tip_salida     = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array("FACTURA"));
                    //Se obtienen las facturas por día
                    $facturas = $this->inventario_model->get_factura_sin_movimiento(array('fac_total > 0' => null, 'moi_id_fac IS NULL' => null,'DATE(fac_fecha_fact)' => $fecha_factura//, 'DATE(fac_fecha_fact) <=' => $fecha_factura_f 
                    ));
                    //var_dump( $this->db->last_query() );die();
                    $contador = 0;
                    foreach ($facturas as $fac) {
                        
                        $info_salida = array(
                            'bodega_bod' => $bodega_factura,
                            'fecha_registro' => formatear_fecha('d-m-Y', $fecha_factura),
                            'slc_proveedor' => '',
                            'slc_documento_proveedor' => '',
                            'doc_proveedor_dcp' => $fac['fac_id_cli'],
                            'doc_cliente_dcc' => $fac['fac_id'],
                            'doc_referencia' => '',
                            'tip_salida' => $tip_salida,
                            'comentario' => '',
                            'hdnexistencia' => '',
                            'txt_aplica_empaque' => '',
                            'dtg_producto' => '',
                            'slcLote' => ''
                        );

                        $detalle_factura = $this->inventario_model->mostrar_detalle_factura(array('def_id_fac'=>$fac['fac_id']));
                        $productos_array = array();
                        $conversion_array = array();
                        $cantidad_maxima_array = array();
                        $cantidad_dee_array = array();
                        $sector_array = array();

                        foreach ($detalle_factura as $def) {
                            $productos_array[] = $def['def_id_art'];
                            $conversion_array[] = $def['def_id_cva'];
                            $cantidad_maxima_array[] = 0;
                            $cantidad_dee_array[] = $def['def_cantidad'];
                            $sector_array[] = '';
                        }

                        $info_salida['producto_art'] = $productos_array;
                        $info_salida['medida_cva'] = $conversion_array;
                        $info_salida['cantidad_maxima'] = $cantidad_maxima_array;
                        $info_salida['cantidad_dee'] = $cantidad_dee_array;
                        $info_salida['sector_sxb'] = $sector_array;
                        
                        //var_dump($info_salida);die();
                        //Se genera el Movimiento
                        $resultado = $this->guardar_salida($info_salida);
                        if($resultado!=null){
                            $contador++;
                        }
                    }
                    $hora_fin = date('Y-m-d H:i:s');
                    echo json_encode(array('total_procesadas' => $contador, 'inicio' => $hora_inicio, 'fin' => $hora_fin ));
                    die();
                }
          }
        }
        
        $data['titulo_personal'] = "Movimientos Pendientes";
        cargarvista($data);
    }

    /**
        * Descripción:
        * Mantenimiento para la tabla rutas de Entrega
        * @author Raul Escalante
        * @since 2019-09-19
    */
    function rutas_entrega($flag = null){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('inventario/gestion_productos/rutas_entrega');
        if ($_POST) {
            $post_array = $this->input->post();
            $fecha_ini = formatear_fecha('Y-m-d', $post_array['fecha_ini']);
            $fecha_fin = formatear_fecha('Y-m-d', $post_array['fecha_fin']);
            $where['rte_fecha_entrega >=']  = $fecha_ini;
            $where['rte_fecha_entrega <=']  = $fecha_fin;
            $data['rutas'] = $this->inventario_model->get_detalles_ruta($where);
            $html = $this->load->view('inventario/gestion_productos/filtrar_rutas_entrega', $data, true);
            if ($flag) {
                echo $html;    
                die();
            }        
        } else {
            $data['titulo_personal'] = 'Rutas de Entrega';
            $this->_cargarvista($data);
        }        
    }

    /**
        * Descripción:
        * Agregarr una ruta de Entrega con facturas que aplican domicilio
        * @author Raul Escalante
        * @since 2019-09-19
    */
    function agregar_ruta_entrega(){
        satelite_validar();
        if ($_POST) {
            $fecha_ruta = $this->input->post('txtFecha');
            $hora_salida = $this->input->post('hora');
            $id_motorista = $this->input->post('slcMotorista');
            $id_ruta = $this->input->post('slcRuta');
            $redirect = $this->input->post('btnCrear'); 
            $det_facturas = $this->input->post('facturas');
            $det_comentar = $this->input->post('comentarios');
            $ruta_entrega = array(
                'rte_id_mot' => $id_motorista,
                'rte_id_rtc' => $id_ruta,
                'rte_fecha_entrega' => formatear_fecha('Y-m-d', $fecha_ruta),
                'rte_hora_salida' => formatear_fecha('H:i:s', $hora_salida),
                'rte_estado' => 1,
                'rte_usu_creacion' => $this->tank_auth->get_user_id(),                
                'rte_fecha_creacion' => date("Y-m-d H:i:s"),                
                'rte_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rte_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $this->db->insert('rte_ruta_entrega', $ruta_entrega);
            $rte_id = $this->db->insert_id();
            for ($i=0; $i < count($det_facturas) ; $i++) { 
                $detalle_ruta = array(
                    'dre_id_rte' => $rte_id,
                    'dre_id_fac' => $det_facturas[$i],
                    'dre_descripcion' => $det_comentar[$i],
                    'dre_estado' => 1,                    
                    'dre_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dre_fecha_creacion' => date("Y-m-d H:i:s"),
                    'dre_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dre_fecha_modificacion' => date("Y-m-d H:i:s")
                );
                $dre_id = $this->gsatelite->ingresar('dre_detalle_ruta_entrega', $detalle_ruta);
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Entrada de Rutas", 'texto_alerta' => "El registro se guardó correctamente");
            $this->session->set_flashdata($alerta);
            if ($redirect == 1) {
                redirect('/inventario/gestion_productos/agregar_ruta_entrega');
            } else {
                redirect('/inventario/gestion_productos/rutas_entrega');
            }
        } else {
            $this->db->join('emp_empleado','emp_id = mot_empleado');
            $motoristas = $this->gsatelite->get_dropdown('mot_motorista', '[CONCAT(emp_nombre," ",emp_apellido)]', '', array('mot_estado' => 1, 'emp_estado'=>1), null, '', 'mot_id', true);
            $rutas = $this->gsatelite->get_dropdown('rtc_ruta_cobro', 'rtc_nombre', '', array('rtc_estado' => 1), null, '', 'rtc_id', true);
            $data['motoristas'] = str_replace('<option value="0">Seleccione</option>', '', $motoristas);
            $data['rutas'] = str_replace('<option value="0">Seleccione</option>', '', $rutas);
            $data['titulo_personal'] = 'Agregar Ruta de Entrega';
            $this->_cargarvista($data);
        }
    }

    /**
        * Descripción:
        * Obtiene las facturas que aplican domicilio que no aun estan en una ruta de entrega
        * @author Raul Escalante
        * @since 2019-09-18
        * @return dropdown con las facturas
    */
    function get_facturas_disp(){
        $excluir = '';
        $select = '<option></option>';
        $condiciones = array('fac_estado >'=>0, 'fac_aplica_domicilio'=>1, 'fac_fecha_domicilio IS NULL'=>NULL);
        $asignadas = $this->gsatelite->get_tabla('dre_detalle_ruta_entrega', array('dre_estado' => 1));
        if ($asignadas) {
            $excluir = implode(',', array_column($asignadas,'dre_id_fac'));
        }
        if ($excluir != '') {
            $condiciones['fac_id NOT IN (' . $excluir . ')'] = NULL;
        }
        $facturas = $this->gsatelite->get_dropdown('fac_factura', 'Factura #{fac_numero}', '', $condiciones, null, '', 'fac_id', true);
        $select .= str_replace('<option value="0">Seleccione</option>', '', $facturas);
        echo $select;
    }

    /**
        * Descripción:
        * Obtiene la informacion del vehiculo asociado al motorista
        * @author Raul Escalante
        * @since 2019-09-18
        * @return campo mot_descripcion_vehiculo
    */
    function get_vehiculos_motorista(){
        $motorista = $this->input->post('mot_id');
        $veh_dscrp = $this->gsatelite->get_campo('mot_motorista', 'mot_descripcion_vehiculo', array('mot_id' => $motorista));
        $vehiculo = ($veh_dscrp != '') ? $veh_dscrp : 'No hay información del vehiculo';
        echo $vehiculo;
    }

    /**
        * Descripción:
        * Obtiene los detalles de la factura
        * @author Raul Escalante
        * @since 2019-09-18
        * @return campo mot_descripcion_vehiculo
    */
    function get_datos_factura($id = null){        
        $fac_id = ($id != null) ? $id : $this->input->post('fac_id');
        $datos = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $fac_id));
        $cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $datos[0]['fac_id_cli']));
        $cli_nom = ($cliente[0]['cli_personeria'] == 2) ? $cliente[0]['cli_apellido'] : $cliente[0]['cli_nombre'] . ' ' . $cliente[0]['cli_apellido'];
        $arreglo = array(
            'numero' => $datos[0]['fac_numero'], 
            'monto' => $datos[0]['fac_total'], 
            'cliente' => $cli_nom,
            'id_cliente' => $datos[0]['fac_id_cli'],
            'direccion' => $cliente[0]['cli_direccion'], 
            'comentarios' => $datos[0]['fac_observacion']
        );
        if ($id != null) {
            return $arreglo;
        } else {
            echo json_encode($arreglo);
        }        
    }

    function editar_ruta_entrega($id = null){
        satelite_validar();
        if ($_POST) {
            $rte_id = $this->input->post('rte_id');
            $fecha = $this->input->post('txtFecha');
            $hora = $this->input->post('hora');
            $actualizar  = array(
                'rte_fecha_entrega' => formatear_fecha("Y-m-d",$fecha),
                'rte_hora_salida' => formatear_fecha("H:i:s",$hora),
                'rte_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rte_fecha_modificacion' => date("Y-m-d H:i:s")                
            );
            $resultado = $this->gsatelite->actualizar_array('rte_ruta_entrega', $actualizar, array('rte_id' => $rte_id));
            if ($resultado > 0) {
                $titulo = 'Exito';
                $registro = 1;
            } else {
                $titulo = 'Error';
                $registro = 0;
            }
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect('/inventario/gestion_productos/editar_ruta_entrega/');
        } else {
            $where['rte_id'] = $id;
            $detalles = $this->inventario_model->get_detalles_ruta($where);
            $data['detalles'] = $detalles;
            $data['id'] = $id;
            $data['titulo_personal'] = "Editar Fecha de Ruta";            
            $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/editar_ruta_entrega', $data);
        }
    }

    function anular_ruta_entrega($id = null){
        satelite_validar();
        if ($_POST) {
            $rte_id = $this->input->post('rte_id'); 
            $this->gsatelite->borrado_general('dre_detalle_ruta_entrega', array('dre_id_rte' => $rte_id));
            $actualizar  = array(
                'rte_estado' => 0,
                'rte_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rte_fecha_modificacion' => date("Y-m-d H:i:s")                
            );
            $resultado = $this->gsatelite->actualizar_array('rte_ruta_entrega', $actualizar, array('rte_id' => $rte_id));
            if ($resultado > 0) {
                $titulo = 'Exito';
                $registro = 1;
            } else {
                $titulo = 'Error';
                $registro = 0;
            }
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect('/inventario/gestion_productos/anular_ruta_entrega/');
        } else {
            $where['rte_id'] = $id;
            $detalles = $this->inventario_model->get_detalles_ruta($where);
            $data['detalles'] = $detalles;
            $data['id'] = $id;
            $data['titulo_personal'] = "Anular Ruta de Entrega";            
            $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/anular_ruta_entrega', $data);
        }        
    }

    function reporte_ruta_entrega($id = null){
        $where['rte_id'] = $id;
        $detalles = $this->inventario_model->get_detalles_ruta($where);
        $data['detalles'] = $detalles;
        $html = $this->load->view('inventario/gestion_productos/detalle_ruta_entrega', $data, true);
        $data['titulo'] = 'Ruta de Entrega de Mercadería';
        $data['solotitulo'] = true;
        $GLOBALS['nombre_reporte'] = 'rpte_centro_costo_' . date('dmY');
        $header = $this->load->view('reporte/header', $data, true);
        $reporte = $header . $html;
        $this->load->library('pdf');
        $this->pdf->makePDF($reporte, 'P', 'ruta_entrega', 'Letter');
        die();
    }

    /**
        * Descripción:
        * Mantenimiento para la tabla de tipo procedimientos
        * @author Habby Lovo - Grupo Satélite
        * @since 2019-09-18
        * @param none
        * @return mantenimiento
    */
    public function autorizar_traslado(){
        satelite_validar();    
        $permisos = $this->gsatelite->get_permisos_opcion();
        $f_ini = $f_fin = date('Y-m-d');
        $state = -1;
        $crud = new grocery_CRUD();
        $bodegas = $this->inventario_model->get_bodegas_usuario();
        $bod_usu = (count($bodegas) > 0) ? implode(',', array_column($bodegas, 'bod_id')) : 0;
        if ($_POST) {
            $f_ini = $_POST['txtFechaIni'];
            $f_fin = $_POST['txtFechaFin'];
            if ($f_ini != '' && $f_fin != '') {
                $crud->where('DATE(trp_fecha_registro) >= ', formatear_fecha('Y-m-d', $f_ini));
                $crud->where('DATE(trp_fecha_registro) <= ', formatear_fecha('Y-m-d', $f_fin));
            }
            if(is_numeric($_POST['filEstado']) && $_POST['filEstado'] >= 0){
                $state = $_POST['filEstado'];
                $crud->where('trp_estado_traslado', $_POST['filEstado']);
            }
        } else {
            $crud->where('DATE(trp_fecha_registro) >= ', date('Y-m-d'));
            $crud->where('DATE(trp_fecha_registro) <= ', date('Y-m-d'));
        }        
        $columns = array(
            'trp_correlativo',
            'trp_id_usu',
            'trp_fecha_registro',
            'trp_id_bod_origen',
            'trp_id_bod_destino',
            'trp_estado_traslado'
        );
        $alias = array(
            'trp_correlativo'       => 'Correlativo',
            'trp_id_usu'            => 'Solicitante',
            'trp_fecha_registro'    => 'Fecha solicitud',
            'trp_id_bod_origen'     => 'Bodega Origen',
            'trp_id_bod_destino'    => 'Bodega Destino',
            'trp_estado_traslado'   => 'Estado'
        );
        $crud->set_table('trp_traslado_pendiente')
            ->set_subject('Traslados pendientes de autorización')
            ->display_as($alias)
            ->columns($columns)
            ->set_relation('trp_id_bod_origen', 'bod_bodega', '{bod_nombre}')
            ->set_relation('trp_id_bod_destino', 'bod_bodega', '{bod_nombre}')
            ->field_type('trp_estado_traslado', 'dropdown', array('0' => 'Anulado', '1' => 'Pendiente', '2' => 'Autorizado'))
            ->where("(trp_id_bod_origen IN ($bod_usu) OR trp_id_bod_destino IN ($bod_usu))", null)
            ->callback_column('trp_id_usu', function($value, $row) {
                $empleado_reg = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu' => $value));
                return trim($empleado_reg[0]['emp_nombre'].' '.$empleado_reg[0]['emp_apellido']);
            })
            ->callback_column('trp_fecha_registro', function($value, $row) {
                return formatear_fecha('d/m/Y', $value);
            })
            ->callback_column('sectores', function($value, $row) {
                $sectores_reg = $this->inventario_model->get_sectores_traslado_temporal(array('dtr_id_trp' => $row->trp_id));
                $sectores_nombres = ''; 
                if(count($sectores_reg) > 0){
                    $sectores_array = array_column($sectores_reg, 'seb_nombre');
                    $sectores_nombres = implode(', ', $sectores_array);
                }
                return $sectores_nombres;
            })
        ;
        $crud->unset_add();
        $crud->unset_edit();
        $crud->unset_read();
        $crud->unset_delete();
        $crud->unset_print();
        $crud->unset_export();
        $crud->add_action('Ver detalle', 'minia-icon-search', 'inventario/gestion_productos/detalle_traslado_temporal/1', 'ver_en_modal');
        $crud->add_action('Autorizar', 'icomoon-icon-checkmark', 'inventario/gestion_productos/detalle_traslado_temporal/0', 'ver_en_modal', null, '', array('trp_estado_traslado' => 1));
        $crud->add_action('Imprimir', 'icomoon-icon-printer', 'inventario/gestion_productos/imprimir_traslado_temporal', 'imprimir_traslado_temporal');
        //$crud->where('trp_id_usu_autoriza IS NULL AND trp_id_usu_anula IS NULL');
        $output = $crud->render();
        $data['f_ini'] = $f_ini;
        $data['f_fin'] = $f_fin;
        $data['estado'] = $state;
        $data['titulo_personal'] = 'Traslados pendientes de autorización';
        $this->_cargarvista($data, $output);
    }

    public function detalle_traslado_temporal($tipo, $id){
        if($this->input->post()){
            //print_r($this->input->post());die();
            $traslado_temp = $this->input->post('traslado_temp');
            $txtanulacion = $this->input->post('txtanulacion');
            $txtPrestamo = $this->input->post('txtPrestamo');
            $txtFechaPrestamo = $this->input->post('txtFechaPrestamo');
            $txtComentario = $this->input->post('txtComentario');

            $txtValidTraslado = $this->input->post('txtValidTraslado'); //valor del checkbox para guardar el seleccionado

            /* grid de detalles de traslado temporal*/
            $txtEdicionDetalleTraslado = $this->input->post('txtEdicionDetalleTraslado');
            $txtCantidadEntregada = $this->input->post('txtCantidadEntregada');

            $traslado_temp_reg2 = $this->gsatelite->get_tabla('trp_traslado_pendiente', array('trp_id' => $traslado_temp));
            if($traslado_temp_reg2[0]['trp_estado_traslado'] == 1){
                if(is_array($txtEdicionDetalleTraslado)){
                    if($txtanulacion == 1){
                        $traslado_anular = array(
                            'trp_id_usu_anula' => $this->tank_auth->get_user_id(),
                            'trp_fecha_anula' => date('Y-m-d H:i:s'),
                            'trp_descripcion_anula' => $txtComentario,
                            'trp_estado_traslado' => 0,
                            // 'trp_estado' => 1,
                            'trp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'trp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('trp_traslado_pendiente', $traslado_anular, array('trp_id' => $traslado_temp));
                    } else{
                        if($txtPrestamo != 0){
                            $traslado_anular = array(
                                'trp_aplica_prestamo' => 1,
                                'trp_fecha_prestamo' => $txtFechaPrestamo,
                                'trp_motivo_prestamo' => $txtComentario,
                                'trp_estado_traslado' => 2,
                                // 'trp_estado' => 1,
                                'trp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'trp_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('trp_traslado_pendiente', $traslado_anular, array('trp_id' => $traslado_temp));
                        } else{
                            $traslado_anular = array(
                                'trp_id_usu_autoriza' => $this->tank_auth->get_user_id(),
                                'trp_fecha_autoriza' => date('Y-m-d H:i:s'),
                                'trp_descripcion_autoriza' => $txtComentario,
                                'trp_estado_traslado' => 2,
                                // 'trp_estado' => 1,
                                'trp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'trp_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('trp_traslado_pendiente', $traslado_anular, array('trp_id' => $traslado_temp));
                        }

                        $traslado_pendiente_reg = $this->gsatelite->get_tabla('trp_traslado_pendiente', array('trp_id' => $traslado_temp));
                        $bodega_origen = $traslado_pendiente_reg[0]['trp_id_bod_origen'];
                        $bodega_destino = $traslado_pendiente_reg[0]['trp_id_bod_destino'];
                        
                        foreach ($txtEdicionDetalleTraslado as $key => $value) {
                            if($txtValidTraslado[$key]){
                                $detalle_traslado_actualizar = array(
                                    'dtr_cantidad_entregada' => $txtCantidadEntregada[$key],
                                    'dtr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dtr_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->actualizar_array('dtr_detalle_traslado_pendiente', $detalle_traslado_actualizar, array('dtr_id' => $txtEdicionDetalleTraslado[$key]));

                                $this->generar_movimiento_traslado_temporal($bodega_origen, $bodega_destino, $txtEdicionDetalleTraslado[$key]);

                            }
                            
                        }
                    }
                }
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Traslado de productos", 'texto_alerta' => "El registro se actualizo correctamente");
            $this->session->set_flashdata($alerta);
            $this->imprimir_traslado_temporal($traslado_temp);
            // redirect('/inventario/gestion_productos/detalle_traslado_temporal/'.$traslado_temp);
        }
        $traslado_temp_reg = $this->inventario_model->get_traslado_temporal(array('trp_id'=>$id));
        // print_r($traslado_temp_reg);
        $sectores_array = array_column($traslado_temp_reg, 'seb_nombre');
        $sectores_array = array_unique($sectores_array);
        // print_r($sectores_array);
        $sectores_array = array_filter($sectores_array);
        $sectores = implode(', ', $sectores_array);
        // var_dump($sectores);

        $data['traslado_temp_id'] = $id;
        $data['tipo'] = $tipo;

        $data['traslado_temp_reg'] = $traslado_temp_reg;
        $data['sectores'] = $sectores;
        $data['grid_detalle_traslado_temporal'] = $this->grid_detalle_traslado_temporal($traslado_temp_reg, $tipo);
        //var_dump($traslado_temp_reg); die();
        $data['titulo_personal'] = 'Traslados pendientes de autorización';
        $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/detalle_traslado_temporal', $data);
        //var_dump($traslado_temp_reg); die();

    }

    function grid_detalle_traslado_temporal($detalles, $tipo){
        try {
            $data['registro'] = $detalles;
            $data['tipo'] = $tipo;
            $html = $this->load->view('inventario/gestion_productos/grid_detalle_traslado_temporal', $data, true);
            return $html;
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function obtener_costos_movimiento($producto, $cantidad, $cantidad_maxima, $bodega = null, $sector = null, $lote = null){
        try {
            $sar_id_array = array();
            $cantidad_array = array();
            $precio_array = array();
            $total_array = array();
            $fecha_caducidad_array = array();

            $peps = 0;

            $where = array();
            if($lote != null){ $where['dee_codigo_lote'] = $lote; } // Cuando es por lote

            if($sector != ''){
                $where['sar_id_sxb'] = $sector;
            }
            $sar_saldo = $this->inventario_model->get_sar_cantidades($producto, $bodega, $where);

            if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 1) {
                $where['sar_id_art'] = $producto;
                if($bodega != null && $bodega != ""){
                    $where['sar_id_bod'] = $bodega;
                }
                if($sector != null && $sector != ""){
                    $where['sar_id_sxb'] = $sector;
                }
                $this->db->limit(1);
                $this->db->order_by('sar_id DESC');
                $precio_peps = $this->gsatelite->get_campo('sar_saldo_articulo', 'sar_precio', $where);
                $peps = 1;
            }

            //Cantidad restante para repetir el foreach, dependiento de la cantidad que se ingreso.
            $cantidad_restante = $cantidad;
            //Cantidad para ingresar en la tabla dee_detalle
            $cantidad_ingresar = 0;
            //Cantidad restante después de restarle la cantidad elegida
            $cantidad_actualizar = 0;
            //Acumulador para salir del do while, cuando el acumulador es igual a la cantidad ingresada se saldrá del do while
            $acumulador_cantidad = 0;
            $contador = 0;
            //Precio de la primera entrada con cantidades
            //Verifica si la cantidad máxima es menor a la cantidad elegida
            $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            if ($cantidad <= $cantidad_maxima) {
                do {
                    $sar_id = $sar_saldo[$contador]['sar_id'];

                    $sar_id_array[] = $sar_id;
                    $cantidad_sar = $sar_saldo[$contador]['sar_cant_actual'];
                    $fecha = (trim($sar_saldo[$contador]['sar_fecha_caducidad']) != "") ? date('Y-m-d', strtotime($sar_saldo[$contador]['sar_fecha_caducidad'])) : null;
                    
                    if ($peps == 0) {
                        $precio_peps = $sar_saldo[$contador]["sar_precio"];
                    }
                    $precio_peps = ($precio_peps > 0) ? $precio_peps : 0;
                    /*
                      Si la cantidad ingresada es mayor a la cantidad del registro, se hace una resta del mayor menos el menor.
                      se guarda el valor de la cantidad de sar_cant_actual en la tabla dee_detalle. Como resta cantidad para
                      almacenar, se repite el do while y pasa al otro registro y hace el mismo proceso
                     */
                    if ($cantidad_sar <= $cantidad_restante) {
                        $cantidad_restante = $cantidad_restante - $cantidad_sar;
                        $cantidad_ingresar = $cantidad_sar;
                        $cantidad_actualizar = $cantidad_sar - $cantidad_ingresar;
                        $acumulador_cantidad += $cantidad_ingresar;
                    } else {
                        $temp = $cantidad_restante;
                        $cantidad_restante = $cantidad_sar - $cantidad_restante;
                        $cantidad_ingresar = $temp;
                        $cantidad_actualizar = $cantidad_sar - $cantidad_ingresar;
                        $acumulador_cantidad += $cantidad_ingresar;
                    }
                    $costo_total = $cantidad_ingresar * $precio_peps;

                    $cantidad_array[] = $cantidad_ingresar;
                    $precio_array[] = $precio_peps;
                    $total_array[] = $costo_total;
                    $fecha_caducidad_array[] = $fecha;
                    print_r(array('sars' => $sar_id_array, 'cantidades' => $cantidad_array, 'precios' => $precio_array, 'totales' => $total_array, 'fecha_caducidad' =>$fecha_caducidad_array) );
                    $contador++;
                } while ($acumulador_cantidad != $cantidad);
            }
            // print_r(array('sars' => $sar_id_array, 'cantidades' => $cantidad_array, 'precios' => $precio_array, 'totales' => $total_array, 'fecha_caducidad' =>$fecha_caducidad_array) );
            // die();
            return array('sars' => $sar_id_array, 'cantidades' => $cantidad_array, 'precios' => $precio_array, 'totales' => $total_array, 'fecha_caducidad' =>$fecha_caducidad_array);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function generar_movimiento_traslado_temporal($bodega_origen, $bodega_destino, $saldo_detalle_id){
        $this->db->join('dtr_detalle_traslado_pendiente', 'dtr_id = sxd_id_dtr', 'inner');
        $this->db->join('trp_traslado_pendiente', 'trp_id = dtr_id_trp', 'inner');
        $traslado_saldo_detalle = $this->gsatelite->get_tabla('sxd_saldo_artxdetalle_pendiente', array('sxd_id_dtr' => $saldo_detalle_id));

        $tipos_proceso = $this->inventario_model->cargar_registro('tip_tipo_proceso', 'tip_id', $traslado_saldo_detalle[0]['trp_id_tip']);

        $tip_id_entrada = $tipos_proceso['tip_id_tip_entrada'];
        $tip_id_salida = $tipos_proceso['tip_id_tip_salida'];

        $documento = $traslado_saldo_detalle[0]['trp_documento'];
        $descripcion = $traslado_saldo_detalle[0]['trp_descripcion'];
        $fecha_mois = date('Y-m-d H:i:s');
        // movimientos
        $moi_salida = array(
            'moi_id_tip' => $tip_id_salida,
            'moi_id_bod' => $bodega_origen,
            'moi_descripcion' => $descripcion,
            'moi_documento' => $documento,
            'moi_fecha_mov' => $fecha_mois,
            'moi_estado' => 1,
            'moi_usu_creacion' => $this->tank_auth->get_user_id(),
            'moi_fecha_creacion' => date('Y-m-d H:i:s'),
            'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
            'moi_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $moi_id_salida = $this->gsatelite->ingresar('moi_movimiento_inv', $moi_salida);

        $moi_entrada = array(
            'moi_id_tip' => $tip_id_entrada,
            'moi_id_bod' => $bodega_destino,
            'moi_descripcion' => $descripcion,
            'moi_documento' => $documento,
            'moi_fecha_mov' => $fecha_mois,
            'moi_estado' => 1,
            'moi_usu_creacion' => $this->tank_auth->get_user_id(),
            'moi_fecha_creacion' => date('Y-m-d H:i:s'),
            'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
            'moi_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $moi_id_entrada = $this->gsatelite->ingresar('moi_movimiento_inv', $moi_entrada);

        $tra_traslado_valores = array(
            'tra_id_trp' => $traslado_saldo_detalle[0]['trp_id'],
            'tra_id_moi_sal' => $moi_id_salida,
            'tra_id_moi_ent' => $moi_id_entrada,
            'tra_fecha_translado' => $fecha_mois,
            'tra_descripcion' => $descripcion,
            'tra_id_tip' => $traslado_saldo_detalle[0]['trp_id_tip'],
            'tra_estado' => 1,
            'tra_usu_creacion' => $this->tank_auth->get_user_id(),
            'tra_fecha_creacion' => date('Y-m-d H:i:s'),
            'tra_usu_modificacion' => $this->tank_auth->get_user_id(),
            'tra_fecha_modificacion' => date('Y-m-d H:i:s'),
            'tra_correlativo' => $documento
        );
        $this->gsatelite->ingresar('tra_translado', $tra_traslado_valores);

        // detalles de salida
        $cantidad_total = $traslado_saldo_detalle[0]['dtr_cantidad_entregada'];
        foreach ($traslado_saldo_detalle as $key => $value) {
            $dee_salida = array(
                'dee_id_moi' => $moi_id_salida,
                'dee_id_art' => $value['dtr_id_art'],
                'dee_id_sar' => $value['sxd_id_sar'],
                'dee_id_cva' => $value['dtr_id_cva'],
                'dee_id_sxb' => $value['dtr_id_sxb_salida'],
                'dee_cantidad' => ($value['sxd_cantidad'] <= $cantidad_total)?$value['sxd_cantidad']:$cantidad_total,
                'dee_fecha_caducidad' => $value['sxd_fecha_caducidad'],
                'dee_precio' => $value['sxd_precio'],
                'dee_subtotal' => $value['sxd_subtotal'],
                'dee_codigo_lote'=> $value['dtr_codigo_lote'],
                'dee_estado' => 1,
                'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dee_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->ingresar('dee_detalle_mov', $dee_salida);

            $sar_salida = array(
                'sar_cant_actual' => ($value['sxd_cantidad'] <= $cantidad_total)?$value['sxd_cantidad']:$cantidad_total,
                'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sar_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('sar_saldo_articulo', $sar_salida, array('sar_id' => $value['sxd_id_sar']));
            // print_r($dee_salida);
            // print_r($sar_salida);

            $sar_entrada = array( //producto destino
                'sar_id_art' => $value['dtr_id_art'],
                'sar_id_bod' => $bodega_destino,
                'sar_cant_actual' => ($value['sxd_cantidad'] <= $cantidad_total)?$value['sxd_cantidad']:$cantidad_total,
                'sar_precio' => $value['sxd_precio'],
                'sar_fecha_caducidad' => $value['sxd_fecha_caducidad'],
                'sar_id_sxb' => $value['dtr_id_sxb'],
                'sar_estado' => 1,
                'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sar_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $sar_id_entrada = $this->gsatelite->ingresar('sar_saldo_articulo', $sar_entrada);

            $dee_entrada = array( //detalle de la entrada
                'dee_id_moi' => $moi_id_entrada,
                'dee_id_art' => $value['dtr_id_art'],
                'dee_id_sar' => $sar_id_entrada,
                'dee_id_cva' => $value['dtr_id_cva'],
                'dee_id_sxb' => $value['dtr_id_sxb'],
                'dee_cantidad' => ($value['sxd_cantidad'] <= $cantidad_total)?$value['sxd_cantidad']:$cantidad_total,
                'dee_fecha_caducidad' => $value['sxd_fecha_caducidad'],
                'dee_precio' => $value['sxd_precio'],
                'dee_subtotal' => $value['sxd_subtotal'],
                'dee_codigo_lote'=> $value['dtr_codigo_lote'],
                'dee_estado' => 1,
                'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                'dee_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->ingresar('dee_detalle_mov', $dee_entrada);
            // print_r($sar_entrada);
            // print_r($dee_entrada);
            $cantidad_total = (($cantidad_total - $value['sxd_cantidad']) >= 0 )?($cantidad_total - $value['sxd_cantidad']):0;
        }

    }

    public function imprimir_prestamo_traslado($id){
        // $this->load->library('pdf');
        // $data['ads'] = '';
        // $html = $this->load->view('inventario/gestion_productos/imprimir_prestamo_traslado', null, true);
        // print_r($html);die();
        // $this->pdf->makePdf($html, 'L', 'Prueba', 'Letter');

        // $where['rte_id'] = $id;
        // $detalles = $this->inventario_model->get_detalles_ruta($where);
        // $data['detalles'] = $detalles;
        $traslado_temp_reg = $this->inventario_model->get_traslado_temporal(array('trp_id'=>$id));
        $data['traslado_temp_reg'] = $traslado_temp_reg;
        print_r($traslado_temp_reg);die(); 
        $html = $this->load->view('inventario/gestion_productos/imprimir_prestamo_traslado', $data, true);
        $data['titulo'] = 'SECCIÓN DE INVETARIOS';
        $data['solotitulo'] = true;
        $GLOBALS['nombre_reporte'] = 'rpte_centro_costo_' . date('dmY');
        $header = $this->load->view('reporte/header', $data, true);
        $reporte = $header . $html;
        // print_r($html);
        $this->load->library('pdf');
        $this->pdf->makePDF($reporte, 'P', 'ruta_entrega', 'Letter');
        die();
    }

    public function imprimir_traslado_temporal($id){
        // $this->load->library('pdf');
        // $data['ads'] = '';
        // $html = $this->load->view('inventario/gestion_productos/imprimir_prestamo_traslado', null, true);
        // print_r($html);die();
        // $this->pdf->makePdf($html, 'L', 'Prueba', 'Letter');

        // $where['rte_id'] = $id;
        // $detalles = $this->inventario_model->get_detalles_ruta($where);
        // $data['detalles'] = $detalles;
        $traslado_temp_reg = $this->inventario_model->get_traslado_temporal(array('trp_id'=>$id));
        $data['traslado_temp_reg'] = $traslado_temp_reg;
        //print_r($this->db->last_query()); die();
        $html = $this->load->view('inventario/gestion_productos/imprimir_traslado_temporal', $data, true);
        $data['titulo'] = 'TRASLADO DE ARTICULOS';
        $data['solotitulo'] = true;
        $GLOBALS['nombre_reporte'] = 'rpte_centro_costo_' . date('dmY');
        $header = $this->load->view('reporte/header', $data, true);
        $reporte = $header . $html;
        // print_r($html);
        $this->load->library('pdf');
        $this->pdf->makePDF($reporte, 'P', 'ruta_entrega', 'Letter');
        die();
    }

    

    public function get_obtener_costos_traslado($id){
        $costo_traslado_reg = $this->inventario_model->get_detalle_costo_traslado(array('sxd_id_dtr' => $id));
        $cantidad = 0;
        $cantidad_total = 0;
        $precio = 0;
        $precio_precio = 0;
        $precio_unitario = 0;
        $costo_total = 0;
        $subtotal = 0;
        if(count($costo_traslado_reg) > 0){

            foreach ($costo_traslado_reg as $key => $value) {
                if($value['tra_id'] != null){
                    $cantidad = $value['dee_cantidad'];
                    $cantidad_total += $cantidad;
                    $precio = $value['dee_precio'];
                    $precio_precio += $precio;
                    $subtotal += $cantidad * $precio ;
                } else{
                    $cantidad = $value['sxd_cantidad'];
                    $cantidad_total += $cantidad;
                    $precio = $value['sxd_precio'];
                    $precio_precio += $precio;
                    $subtotal += $cantidad * $precio ;
                }
            }
            $precio_unitario = $subtotal/$cantidad_total;
            $costo_total = $subtotal;
        }
        return array('precio_unitario' => $precio_unitario, 'costo_total' => $costo_total, 'cantidad_total' => $cantidad_total);
    }

    public function control_existencia(){
        if ($_POST) {             
            $bod_id     = ($this->input->post('slcBodega') != '') ? $this->input->post('slcBodega') : null;
            $art_id     = ($this->input->post('producto_art') != '') ? $this->input->post('producto_art') : null;
            $fecha_ini  = ($this->input->post('fecha_ini') != '') ? formatear_fecha('Y-m-d', $this->input->post('fecha_ini')) : null;
            $fecha_fin  = ($this->input->post('fecha_fin') != '') ? formatear_fecha('Y-m-d', $this->input->post('fecha_fin')) : null;        

            $where = array(
                'cex_id_art'            => $art_id,
                'cex_id_bod'            => $bod_id,
                'cex_id_bod'            => $bod_id,
                'DATE(cex_fecha_desde)' => $fecha_ini,
                'DATE(cex_fecha_hasta)' => $fecha_fin
            );
            $grou_by            = 'cex_id';
            $data['destalles']  = $this->inventario_model->get_control_existencia($where,$grou_by);        
            $html               = $this->load->view('inventario/gestion_productos/ver_control_existencias', $data, true);                
            $resultado['html']  = $html;
            echo json_encode($resultado);
            die();
        } else {
            $data['permisos']       = $this->gsatelite->get_permisos_opcion();
            $data['usuarios']       = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas']        = $this->inventario_model->get_bodegas_usuario();
            $data['titulo_personal']= 'Control de existencias';
            $this->_cargarvista($data);
        }
    }


    public function agregar_control_existencia(){
        if ($_POST) { 
        
            $cex_id_art         = $this->input->post('filtro_articulo');
            $cex_id_bod         = $this->input->post('filtro_bodega');
            $cex_correlativo    = $this->input->post('txt_correlativo');
            $cex_fecha_desde    = $this->input->post('filtro_fecha_inicio');
            $cex_fecha_hasta    = $this->input->post('filtro_fecha_fin');
            $cex_id_cva         = $this->input->post('txt_medida');
            $cex_cantidad_ant   = $this->input->post('cantidad_anterior');
            $cex_precio_ant     = $this->input->post('precio_anterior');
            $cex_subtotal_ant   = $this->input->post('subtotal_anteior');
            
            $cex_contro_existencia = array ( 
                'cex_id_art'            => $cex_id_art,
                'cex_id_bod'            => $cex_id_bod,
                'cex_id_usu'            => $this->tank_auth->get_user_id(),
                'cex_correlativo'       => $cex_correlativo,           
                'cex_id_cva'            => $cex_id_cva,
                'cex_fecha_registro'    => date('Y-m-d h:i:s'), 
                'cex_fecha_desde'       => $cex_fecha_desde,
                'cex_fecha_hasta'       => $cex_fecha_hasta,
                'cex_cantidad_ant'      => $cex_cantidad_ant,
                'cex_precio_ant'        => $cex_precio_ant,
                'cex_subtotal_ant'      => $cex_subtotal_ant,
                'cex_estado'            => 1, 
                'cex_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'cex_fecha_modificacion'=> date('Y-m-d h:i:s'), 
                'cex_usu_creacion'      => $this->tank_auth->get_user_id(), 
                'cex_fecha_creacion'    => date('Y-m-d h:i:s')
            );
            $cex_id = $this->gsatelite->ingresar('cex_contro_existencia', $cex_contro_existencia);
            
            $dcx_correlativo          = $this->input->post('tbl_contador');
            $dcx_fecha                = $this->input->post('tbl_fecha');
            $dcx_id_tip               = $this->input->post('tbl_tipo');
            $dcx_documento            = $this->input->post('tbl_documento');
            $dcx_procedencia          = $this->input->post('tbl_proveedor');
            $dcx_destino              = $this->input->post('tbl_bodega');
            $dcx_precio               = $this->input->post('tbl_precio_u');
            $dcx_proceso              = $this->input->post('tbl_prorceso');
            $dcx_subtotal_existencia  = $this->input->post('tbl_saldo');
            $dcx_cantidad_existencia  = $this->input->post('tbl_saldo_existencia');
            

            $cargo = $this->input->post('tbl_cargo');
            $abono = $this->input->post('tbl_abono');
    
            $debe   = $this->input->post('tbl_debe');
            $haber  = $this->input->post('tbl_haber');

                            
            foreach ($dcx_correlativo as $key => $correlativo) {
                $dcx_cantidad = ($cargo[$key] != "")?$cargo[$key]:0;
                $dcx_cantidad += ($abono[$key] != "")?$abono[$key]:0;

                $dcx_precio_existencia = ($debe[$key] != "")?$debe[$key]:0;
                $dcx_precio_existencia += ($haber[$key] != "")?$haber[$key]:0;

                $dcx_detalle_control_existencia = array(
                    'dcx_id_cex'                => $cex_id,
                    'dcx_id_tip'                => $dcx_id_tip[$key],
                    'dcx_correlativo'           => $correlativo,
                    'dcx_fecha_registro'        => date('Y-m-d h:i:s'),
                    'dcx_fecha'                 => $dcx_fecha[$key],
                    'dcx_procedencia'           => $dcx_procedencia[$key],
                    'dcx_destino'               => $dcx_destino[$key],
                    'dcx_proceso'               => $dcx_proceso[$key],
                    'dcx_descripcion_proceso'   => 1,
                    'dcx_documento'             => $dcx_documento[$key],
                    'dcx_usuario'               => $this->tank_auth->get_user_id(),
                    'dcx_proveedor'             => $dcx_procedencia[$key],
                    'dcx_cantidad'              => $dcx_cantidad,
                    'dcx_precio'                => $dcx_precio[$key],
                    'dcx_subtotal'              => 1,
                    'dcx_cantidad_existencia'   => $dcx_cantidad_existencia[$key],
                    'dcx_precio_existencia'     => $dcx_precio_existencia,
                    'dcx_subtotal_existencia'   => $dcx_subtotal_existencia[$key],
                    'dcx_fecha_caducidad'       => date('Y-m-d h:i:s'),                  
                    'dcx_estado'                => 1, 
                    'dcx_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'dcx_fecha_modificacion'    => date('Y-m-d h:i:s'),
                    'dcx_usu_creacion'          => $this->tank_auth->get_user_id(),
                    'dcx_fecha_creacion'        => date('Y-m-d h:i:s')
                );
                $this->gsatelite->ingresar('dcx_detalle_control_existencia', $dcx_detalle_control_existencia);
            }

            if ($cex_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Control de existencia", 'texto_alerta' => "El registro se guardó correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Control de existencia", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            

            $tipo_btn = $this->input->post('btnCrear');
            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('inventario/gestion_productos/agregar_control_existencia');
            } else {
                redirect('inventario/gestion_productos/control_existencia');
            }

        } else {
            $correlativo            = $this->gsatelite->get_max('cex_contro_existencia','cex_id');
            $correlativo            = ( $correlativo != null)? $correlativo + 1 : 1;
            $data['correlativo']    = str_pad($correlativo, 4, "0", STR_PAD_LEFT);            
            $data['usuarios']       = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
            $data['bodegas']        = $this->inventario_model->get_bodegas_usuario();
            $data['titulo_personal']= 'Agregar control de existencias';
            $this->_cargarvista($data);
        }
       
    }

    public function get_existencias(){
        if ($_POST) { 
            $bod_id     = ($this->input->post('slcBodega') != '') ? $this->input->post('slcBodega') : null;
            $art_id     = ($this->input->post('producto_art') != '') ? $this->input->post('producto_art') : null;
            $bodega     = ($this->input->post('bodega') != '') ? $this->input->post('bodega') : null;
            $fecha_ini  = ($this->input->post('fecha_ini') != '') ? formatear_fecha('Y-m-d', $this->input->post('fecha_ini')) : null;
            $fecha_fin  = ($this->input->post('fecha_fin') != '') ? formatear_fecha('Y-m-d', $this->input->post('fecha_fin')) : null;        
            $kardex_prod= $this->inventario_model->kardex_producto($art_id, $bod_id, $fecha_ini, $fecha_fin);  
                       
            $this->db->join("cva_conversion_articulo","cva_id_mep = mep_id");
            $this->db->join("art_articulo","art_id = cva_id_art");
            $data['medida']     = $this->gsatelite->get_tabla("mep_medida_producto",array("cva_id_art" => $art_id, "cva_defecto" => 1) );        
            $data['detalles']   = $kardex_prod;
            $data['bod_id']     = $bod_id;
            $data['art_id']     = $art_id;
            $data['fecha_ini']  = $fecha_ini;
            $data['fecha_fin']  = $fecha_fin;
            $data['bodega']     = $bodega;
            $html               = $this->load->view('inventario/gestion_productos/ver_kardex', $data, true);
                
            $resultado['html']  = $html;
            echo json_encode($resultado);
            die();
           
        }
    }

    public function generar_partida_contable_entrada_inventario_masiva(){
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $array_resultados = array();
        $fecha_ini = formatear_fecha('Y-m-d', $this->input->post('fecha_ini'));
        $fecha_fin = formatear_fecha('Y-m-d', $this->input->post('fecha_fin'));
        $where['DATE(moi_fecha_mov) >= "' . $fecha_ini . '"'] = null;
        $where['DATE(moi_fecha_mov) <= "' . $fecha_fin . '"'] = null;                
        $where['moi_id_pct IS NULL'] = null;
        $where['tip_entrada'] = 1;
        $articulos = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'moi_id','moi_fecha_mov');
        $dt_articulos = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'moi_id, cuenta_id','dee_id_moi',null, array('detalle' => true));
        $cnt_haber = $this->contabilidad_model->obtener_haber_movimiento_inventario($where, 'moi_id, cnt_id', 'moi_id');
        if (count($articulos) > 0) {
            $prc_id = $this->gsatelite->get_min('prc_periodo_contable', 'prc_id', array('prc_estado' => 1));
            $id_tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('COSTO'))));
            $prefijo = (count($id_tipo_partida) > 0) ? $id_tipo_partida[0]['tpd_prefijo'] . '-' : '';
            $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 1));
            $origen_partida = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
            $cuenta_defecto = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id'=>$this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado'=>1));
            $concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 11));
            $pct_concepto = (count($concepto) > 0) ? $concepto[0]['ccp_descripcion_concepto'] : 'Concepto no definido';
            if(isset($articulos[0]['moi_id']) && $articulos[0]['moi_id'] == '') { 
                unset($articulos[0]); 
            }            
            foreach ($articulos as $key => $value) {
                $correlativo = ($this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1);
                $numero_ptda = str_pad($correlativo, 5, '0', STR_PAD_LEFT);
                $txtconcepto = $pct_concepto . ' - Numero de movimiento #' . $value['moi_id'];
                $array_partida = array(
                    'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
                    'pct_id_prc'        => $prc_id,
                    'pct_concepto'      => $txtconcepto,
                    'pct_id_orp'        => $origen_partida,
                    'pct_total'         => number_format($value['subtotal_prod'], 2, '.', ''),
                    'pct_fecha'         => formatear_fecha('Y-m-d', $value['moi_fecha_mov']),
                    'pct_correlativo'   => $correlativo,
                    'pct_codigo'        => $prefijo . $numero_ptda,
                    'pct_modulo'        => 3,
                    'pct_estado'        => 1,
                    'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                    'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                    'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                    'pct_usu_mod'       => $this->tank_auth->get_user_id()
                );
                $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                if ($agregar > 0) {
                    foreach ($dt_articulos as $k2 => $value1) {
                        if ($value1['moi_id'] == $value['moi_id']) {
                            $array_detalle_d = array(
                                'dpc_id_cnt'        => ($value1['cuenta_id'] > 0) ? $value1['cuenta_id'] : $cuenta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Entrada de producto a Inventario #' . $value1['moi_id'],
                                'dpc_debe'          => number_format($value1['subtotal_prod'], 2, '.', ''), 
                                'dpc_haber'         => number_format(0, 2, '.', ''), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_d);
                            if ($detalle > 0) {
                                unset($dt_articulos[$k2]);
                            }
                        }
                    }
                    foreach ($cnt_haber as $k3 => $value2) {
                        if ($value2['moi_id'] == $value['moi_id']) {
                            $array_detalle_h = array(
                                'dpc_id_cnt'        => ($value2['cnt_id'] > 0) ? $value2['cnt_id'] : $cuenta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Entrada de producto a Inventario #' . $value2['moi_id'],
                                'dpc_debe'          => number_format(0, 2, '.', ''), 
                                'dpc_haber'         => number_format($value2['total'], 2, '.', ''), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_h);
                            if ($detalle > 0) {
                                unset($cnt_haber[$k3]);
                            }
                        }
                    }
                    $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $agregar), array('moi_id' => $value['moi_id'])); 
                    $array_resultados[] = $agregar;
                }
            }
        }
        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }

    public function generar_partida_contable_salida_inventario_masiva(){
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $array_resultados = array();
        $fecha_ini = formatear_fecha('Y-m-d', $this->input->post('fecha_ini'));
        $fecha_fin = formatear_fecha('Y-m-d', $this->input->post('fecha_fin'));
        $where['DATE(moi_fecha_mov) >= "' . $fecha_ini . '"'] = null;
        $where['DATE(moi_fecha_mov) <= "' . $fecha_fin . '"'] = null;                
        $where['moi_id_pct IS NULL'] = null;
        $where['tip_salida'] = 1;
        $articulos = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'moi_id','moi_fecha_mov');
        $dt_articulos = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'moi_id, cuenta_id','dee_id_moi',null, array('detalle' => true));
        $cnt_debe = $this->contabilidad_model->obtener_haber_movimiento_inventario($where, 'moi_id, cnt_id', 'moi_id');
        if (count($articulos) > 0) {
            $prc_id = $this->gsatelite->get_min('prc_periodo_contable', 'prc_id', array('prc_estado' => 1));
            $id_tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('COSTO'))));
            $prefijo = (count($id_tipo_partida) > 0) ? $id_tipo_partida[0]['tpd_prefijo'] . '-' : '';
            $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 1));
            $origen_partida = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
            $cuenta_defecto = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id'=>$this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado'=>1));
            $concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 11));
            $pct_concepto = (count($concepto) > 0) ? $concepto[0]['ccp_descripcion_concepto'] : 'Concepto no definido';
            if(isset($articulos[0]['moi_id']) && $articulos[0]['moi_id'] == '') { 
                unset($articulos[0]); 
            }            
            foreach ($articulos as $key => $value) {
                $correlativo = ($this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1);
                $numero_ptda = str_pad($correlativo, 5, '0', STR_PAD_LEFT);
                $txtconcepto = $pct_concepto . ' - Numero de movimiento #' . $value['moi_id'];
                $array_partida = array(
                    'pct_id_tpd'        => $id_tipo_partida[0]['tpd_id'],
                    'pct_id_prc'        => $prc_id,
                    'pct_concepto'      => $txtconcepto,
                    'pct_id_orp'        => $origen_partida,
                    'pct_total'         => number_format($value['subtotal_prod'], 2, '.', ''),
                    'pct_fecha'         => formatear_fecha('Y-m-d', $value['moi_fecha_mov']),
                    'pct_correlativo'   => $correlativo,
                    'pct_codigo'        => $prefijo . $numero_ptda,
                    'pct_modulo'        => 3,
                    'pct_estado'        => 1,
                    'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                    'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                    'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                    'pct_usu_mod'       => $this->tank_auth->get_user_id()
                );
                $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                if ($agregar > 0) {
                    foreach ($cnt_debe as $k2 => $value1) {
                        if ($value1['moi_id'] == $value['moi_id']) {
                            $array_detalle_d = array(
                                'dpc_id_cnt'        => ($value1['cnt_id'] > 0) ? $value1['cnt_id'] : $cuenta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Salida de Producto de Inventario #' . $value1['moi_id'],
                                'dpc_debe'          => number_format($value1['total'], 2, '.', ''), 
                                'dpc_haber'         => number_format(0, 2, '.', ''), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_d);
                            if ($detalle > 0) {
                                unset($cnt_debe[$k2]);
                            }
                        }                        
                    }
                    foreach ($dt_articulos as $k3 => $value2) {
                        if ($value2['moi_id'] == $value['moi_id']) {
                            $array_detalle_h = array(
                                'dpc_id_cnt'        => ($value2['cuenta_id'] > 0) ? $value2['cuenta_id'] : $cuenta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $agregar,
                                'dpc_concepto'      => 'Salida de Producto de Inventario #' . $value2['moi_id'],
                                'dpc_debe'          => number_format(0, 2, '.', ''), 
                                'dpc_haber'         => number_format($value2['subtotal_prod'], 2, '.', ''), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle_h);
                            if ($detalle > 0) {
                                unset($dt_articulos[$k3]);
                            }
                        }
                    }
                    $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $agregar), array('moi_id' => $value['moi_id'])); 
                    $array_resultados[] = $agregar;
                }
            }
        }        
        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }

    public function partida_consolidada_masiva_salida_inventario(){
        $periodo = $this->input->post('periodo');
        $array_resultados = array();
        $procesar = array();
        if (trim($periodo != "")) {
            $fecha = '01-' . $periodo;
            $cta_defecto = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO'), 'cnt_estado' => 1));
            $prc_id = $this->gsatelite->get_min('prc_periodo_contable', 'prc_id', array('prc_estado' => 1));
            $mes_proc = formatear_fecha('Y-m', $fecha);
            $last = formatear_fecha('t', $fecha);
            for ($i = 1; $i <= $last; $i++) { 
                $fecha_pro = $mes_proc . '-' . $i;
                $where = array('DATE(moi_fecha_mov)' => formatear_fecha('Y-m-d', $fecha_pro), 'tip_salida' => 1, 'moi_id_pct IS NULL' => null);
                $articulos = $this->contabilidad_model->obtener_productosxfactura_inventario($where, null, null, null, array('detalle' => false));
                if (trim($articulos[0]['facturas']) != '') {
                    $procesar[$i]['articulos'] = $articulos;
                    $procesar[$i]['dt_articulos'] = $this->contabilidad_model->obtener_productosxfactura_inventario($where, 'cuenta_id', 'dee_id_moi', null, array('detalle' => true));
                    $procesar[$i]['cnt_haber'] = $this->contabilidad_model->obtener_haber_movimiento_inventario($where, 'cnt_id', 'moi_id');
                    $procesar[$i]['fecha'] = formatear_fecha('Y-m-d', $fecha_pro);
                }
            }
            if (count($procesar) > 0) {
                $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 1));
                $orp_partida = (count($origen) > 0) ? $origen[0]['orp_id'] : null;
                $id_tipo_partida = $this->gsatelite->get_tabla('tpd_tipo_partida', array('tpd_id' => $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS',null,null,array('COSTO'))));
                $tpd_partida = (count($id_tipo_partida) > 0) ? $id_tipo_partida[0]['tpd_id'] : null;
                $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 11, 'ccp_estado' => 1));
                $concepto = (count($pct_concepto) > 0) ? $pct_concepto[0]['ccp_descripcion_concepto'].' - Movimientos con fecha ' : 'Concepto no definido ';
                $codigo = ($tpd_partida != null) ? $id_tipo_partida[0]['tpd_prefijo'] . '-' : '';
                foreach ($procesar as $key => $value) {
                    $total = 0;
                    foreach ($value['dt_articulos'] as $k1 => $val1) {
                        $total += $val1['subtotal_prod'];
                    }
                    $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
                    $numero = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
                    $array_partida = array(
                        'pct_id_tpd'        => $tpd_partida,
                        'pct_id_prc'        => $prc_id,
                        'pct_concepto'      => $concepto . formatear_fecha('d-m-Y',$value['fecha']),
                        'pct_id_orp'        => $orp_partida,
                        'pct_total'         => number_format($total, 2, '.', ''),
                        'pct_fecha'         => formatear_fecha('Y-m-d', $value['fecha']),
                        'pct_correlativo'   => $correlativo_partida,
                        'pct_codigo'        => $codigo . $numero,
                        'pct_modulo'        => 3,
                        'pct_estado'        => 1,
                        'pct_fecha_crea'    => date('Y-m-d H:i:s'),
                        'pct_fecha_mod'     => date('Y-m-d H:i:s'),
                        'pct_usu_crea'      => $this->tank_auth->get_user_id(),
                        'pct_usu_mod'       => $this->tank_auth->get_user_id()
                    );
                    $pct_id = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
                    if ($pct_id > 0) {
                        foreach ($value['cnt_haber'] as $kd => $vald) {
                            $array_detalle1 = array(
                                'dpc_id_cnt' => ($vald['cnt_id'] > 0) ? $vald['cnt_id'] : $cta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $pct_id,
                                'dpc_concepto'      => 'Salidas de Inventario en fecha ' . formatear_fecha('d-m-Y', $value['fecha']),
                                'dpc_debe'          => number_format($vald['total'], 2, '.', ''),
                                'dpc_haber'         => number_format(0, 2), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );
                            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle1);
                        }
                        foreach ($value['dt_articulos'] as $kh => $valh) {
                            $array_detalle2 = array(
                                'dpc_id_cnt' => ($valh['cuenta_id'] > 0) ? $valh['cuenta_id'] : $cta_defecto[0]['cnt_id'],
                                'dpc_id_pct'        => $pct_id,
                                'dpc_concepto'      => 'Salidas de Inventario en fecha ' . formatear_fecha('d-m-Y', $value['fecha']),
                                'dpc_debe'          => number_format(0, 2),
                                'dpc_haber'         => number_format($valh['subtotal_prod'], 2, '.', ''), 
                                'dpc_estado'        => 1,
                                'dpc_fecha_crea'    => date('Y-m-d H:i:s'),
                                'dpc_fecha_mod'     => date('Y-m-d H:i:s'),
                                'dpc_usu_crea'      => $this->tank_auth->get_user_id(),
                                'dpc_usu_mod'       => $this->tank_auth->get_user_id()
                            );                     
                                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle2);
                        }
                        $array_resultados[] = $pct_id;
                        $facturas = $value['articulos'][0]['facturas'];
                        $this->gsatelite->actualizar_array("moi_movimiento_inv", array("moi_id_pct" => $pct_id), array("moi_id IN ( $facturas )"  => null)); 
                    }
                }
            }
        }
        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }

    public function print_control_existencia($control = null, $tipo = 0){
        $where['cex_id']    = $control;    
        $data['detalles']   = $this->inventario_model->get_control_existencia($where);        
        $data['tipo']       = $tipo;
        if ($tipo != 0) {
            $this->gsatelite->cargar_vista_masterpage('inventario/gestion_productos/print_control_existencia',$data);           
        }   else {
            $dato['titulo'] = 'Control de existencia.';
            $header         = $this->load->view('reporte/header', $dato, true);
            $html           = $this->load->view('inventario/gestion_productos/print_control_existencia', $data,true);  
            $GLOBALS['nombre_reporte']  = 'Reporte_control_existencia_'. date('dmY');
            $reporte        = $header . $html;
            $this->pdf->SetTitle('Reporte control Existencia');
            $this->pdf->makePdf($reporte, 'L', 'Reporte_control_existencia', 'Letter');
        }
    }

    public function get_costo_sar(){
        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
        $produc = $this->input->post('producto');
        $bodega = $this->input->post('bodega');
        $resultado = 0;
        if ($costo_promedio > 0) {
            $where = array('sar_id_art' => $produc, 'sar_id_bod' => $bodega);
            $costo = $this->inventario_model->get_costo_salida($where, $costo_promedio);
            if (count($costo) > 0) {
                $resultado = $costo[0]['sar_precio'];
            }
        }
        echo $resultado;
        die();
    }

    /**
    * Descripción: Invoca la Consulta de la ubicacion de productos y/o sectores del modulo de facturacion
    * @author Grupo satélite - Raul Escalante
    */
    public function ubicacion_producto(){
        satelite_validar();
        $this->load->library('../controllers/facturacion/facturar');
        $this->facturar->ubicacion_producto();
    }

}
/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */