<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Crear_solicitud_inventario extends CI_Controller
{
    
    function __construct()
	{
		parent::__construct();
		$this->load->model('inventario_model');
		$this->load->model('gsatelite');
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {		

		    $data['usuarios']  = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());            
            $data['bodegas']   = $this->inventario_model->cargar_registros('bod_bodega','bod_estado',1);
            $data['solicitudes'] = $this->inventario_model->historial_solicitudes($this->tank_auth->get_user_id());
			$this->_cargarvista(null,$data);
		}
	}
    
    
    function registrar_solicitud(){
                    $id_detalle = 0;
                    $usuario = $this->input->post('id');    
                    $detalles_solicitud = $this->input->post('opciones');
                    $descripcion = $this->input->post('descripcion');


                    $arregrlo_ingresar_solicitud = array(
                     'rxi_id_user'   => $usuario,
                     'rxi_fecha'     => date('Ymd h:i:s'),
                     'rxi_id_bod'    => $this->input->post('bodega'),
                     'rxi_descripcion' =>$descripcion,
                     'rxi_estado'    =>1,
                     'rxi_tipo'=> $this->input->post('tipo')
                    );

                    $obtener_id_solicitud = $this->gsatelite->ingresar('rxi_requisicion_inventario',$arregrlo_ingresar_solicitud);

                    foreach($detalles_solicitud as $ingresar_articulos){
                     $arreglo_detalle_solicitud = array('dri_id_rxi'=>$obtener_id_solicitud,'dri_id_art'=>$ingresar_articulos['id'],'dri_cantidad'=>$ingresar_articulos['cantidad']);    
                     $id_detalle = $this->gsatelite->ingresar('dri_detalle_requisicion_inventario',$arreglo_detalle_solicitud);
                                                                       }
                    exit();

        echo json_encode($id_detalle);
    }
    
    
    function obtener_bodegas_articulos(){
        $id_articulo        = $this->input->post('id_articulo');
        $id_solicitud       = $this->input->post('id_solicitud');
        $cantidad_articulos = $this->inventario_model->get_cantidad_articulos_solicitud($id_articulo,$id_solicitud);
        $bodegas            = $this->inventario_model->get_bodegas_articulos($id_articulo);
        $var                = '<option value=""> Seleccione una opcion </option>';
          foreach($bodegas as $mostrar_bodegas){
            $var .= '<option value = "'.$mostrar_bodegas['bod_id'].'">'.$mostrar_bodegas['bod_nombre'].'</option>';
          }
          
          $arreglo = array( 
         "drop"     =>$var,
         "cantidad" =>$cantidad_articulos[0]['dri_cantidad'],
                          );

      
       echo json_encode($arreglo); 
 
      
    }
    

    function get_articulos_bodegas()
    {
        $options = "";
          //$var ="<option value=''> seleccione una opcionasas </option>";
              $var = '<option> Seleccione una opcion </option>';
           
                $bodega    = $this->input->post('bodega');
                $categoria = $this->input->post('categoria');
                $articulos = $this->inventario_model->get_productos_bodega_cantidad($bodega,$categoria);
                foreach($articulos as $fila)
              {
                $var .= "<option value='". $fila['art_id']."'>".$fila['art_nombre'].' ('.$fila['sar_cant_actual'].')'."</option>";
              }

              
      $arreglo = array( 
         "drop"=>$var,
        );
      
  echo json_encode($arreglo);

    }


    function get_tipo_articulos()
    {
        $option      = "";
        $var         = '<option>Seleccione una opcion</option>';
        $bodega      = $this->input->post('bodega');
        $categorias  = $this->inventario_model->get_categorias($bodega);

        foreach ($categorias as $key) {
                $var .="<option value='".$key['tia_id']."'>".$key['tia_nombre']."</option>";
                                      }

        $arreglo = array( 
         "drop"=>$var,
        );
      
         echo json_encode($arreglo);

    }

    
    function get_tipo_articulos_medicina()
    {
        $option      = "";
        $var         = '<option>Seleccione una opcion</option>';
        $bodega      = $this->input->post('bodega');
        $categorias  = $this->inventario_model->get_articulos_medicina($bodega);

        foreach ($categorias as $key) {
                $var .="<option value='".$key['art_id']."'>".$key['art_nombre'].' ('.$key['sar_cant_actual'].')'."</option>";
                                      }

        $arreglo = array( 
         "drop"=>$var,
        );
      
         echo json_encode($arreglo);

    }


    function modificar_cantidad()
    {
        $id_detalle   = $this->input->get('identificador');
        $id_solicitud = $this->input->get('solicitud');

        $data['detalle']   = $id_detalle;
        $data['solicitud'] = $id_solicitud;

        $this->_cargarvista(null,$data);
    }

    function realizar_modificacion()
    {
        $bandera   = false;
        $cantidad  = $this->input->post('cantidad');
        $detalle   = $this->input->post('detalle');
        $solicitud = $this->input->post('solicitud');


        $actualizar_cantidad_detalle = array('dri_cantidad' => $cantidad);

        $indicador = $this->gsatelite->actualizar('dri_detalle_requisicion_inventario',$actualizar_cantidad_detalle,'dri_id',$detalle);

        if($indicador != ""){
          $bandera =  true;
        }

        echo json_encode($bandera);
     }


     function rechazar_solicitud()
     {
         $solicitud = $this->input->post('id_solicitud');
         $bandera = true;
         $eliminar_solicitud = array('rxi_estado'=>2);

         $indicador = $this->gsatelite->actualizar('rxi_requisicion_inventario',$eliminar_solicitud,'rxi_id',$solicitud);

         if($indicador != ""){
            $bandera = false;
             }

         echo json_encode($bandera);

     }


     function imprimir_boleta()
     {
         $id_solicitud = $this->input->get('identificador');
         $arreglo_actualizar = array('rxi_documento' => 0);
         //$this->gsatelite->actualizar('rxi_requisicion_inventario',$arreglo_actualizar,'rxi_id',$id_solicitud);
         $this->load->library('PDF');
         $data['detalles'] = $this->inventario_model->pdf_detalle_requisicion_inventario($id_solicitud);
         $reporte=$this->pdf->SolicitudInventario('inventario/reporteria/solicitud',$data,'Inventario');
     }



    	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
    
}