<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Correccion_inventario extends CI_Controller
{
	
	function __construct()
	{
		parent::__construct();
    	
    	$this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
        $this->load->library('grocery_CRUD');
        $this->load->library('excel/excel_reader.php');

	}
        function busqueda_en_inventarios()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal']="Consultar inventario";
            $this->_cargarvista($data);
        }
    }

   function busqueda_codigo()
    {
        $codigo=$this->input->post('codigo_buscar');
        $this->db->select('art_id')
          ->from('art_articulo')
          ->where('art_codigo',$codigo)
          ->or_where('art_nombre',$codigo);
          $articulo=$this->db->get()->result_array();
          $cadena ='';
    foreach ($articulo as $key2 => $codigo) {

        $informacion = $this->inventario_model->consultaxcodigo($codigo['art_id']);
     //  die($this->db->last_query()); 
        if (empty($informacion)) {
            $cadena.='';
            break;
        }
        $data['informacion'] = $informacion;
     // print_r($data);
        $html = $this->load->view('inventario/correccion_inventario/detalle_busqueda_correccion', $data, true);
        $cadena .= $html;
        //print_r($this->db->last_query()); exit;
        
    }
    
        $arreglo = array( 
            "drop"=>$cadena,
            
            );
 
        echo json_encode($arreglo);

    }

    function consultas_detalle_salidas($sar_saldo,$saldo_actual=null,$id_furgon=null)
    {
        $data['saldo_actual']=$saldo_actual;
         $data['id_sar_saldo']=$sar_saldo;
        $data['id_furgon']=$id_furgon;
        $data['n_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['detalle_salidas'] = $this->inventario_model->detalle_salidasxsar_id($sar_saldo,true,$id_furgon);
     //die($this->db->last_query());
        $this->load->view('inventario/correccion_inventario/consultas_detalle_salidas',$data);
    }

    function actualizar_salida_detalle() {
        $id_detalle = $this->input->post('id_detalle');
        $valor_detalle = $this->input->post('valor_detalle');
        $nuevo_saldo = $this->input->post('nuevo_saldo');
        $id_sar = $this->input->post('id_sar');
        $id_ixc = $this->input->post('id_furgon'); //si aplica furgon este valor vendra diferente de cero
        //actualizar el detalle
        if($id_detalle>0){ 
        $update= array('dee_cantidad'=>$valor_detalle,'dee_usr_mod'=>$this->tank_auth->get_user_id(),'dee_fecha_mod'=>date('Y-m-d H:i:s'));
        $exito= $this->gsatelite->actualizar_array('dee_detalle_mov',$update, array('dee_id'=>$id_detalle));
        }

        if ($id_sar>0) {
         $update= array('sar_cant_actual'=>$nuevo_saldo,'sar_usu_mod'=>$this->tank_auth->get_user_id(),'sar_fecha_mod'=>date('Y-m-d H:i:s'));
         $exito= $this->gsatelite->actualizar_array('sar_saldo_articulo',$update, array('sar_id'=>$id_sar));
        }

        if ($id_ixc>0) {
         $update= array('ixc_cantidad_actual'=>$nuevo_saldo,'ixc_usu_mod'=>$this->tank_auth->get_user_id(),'ixc_fecha_mod'=>date('Y-m-d H:i:s'));
         $exito= $this->gsatelite->actualizar_array('ixc_ingresoxcontenedor',$update, array('ixc_id'=>$id_ixc));
        } 

        echo json_encode(array('exito'=>$exito));

    }

    function consultas_detalle_entradas($id_sar,$saldo_actual=null,$id_furgon=null)
    {
        //NOTA: los terminos furgon y contenedor hacen referencia a lo mismo.
       //die('en desarrollo....');
        $tiene_salidas= $this->inventario_model->detalle_salidasxsar_id($id_sar,true,$id_furgon);
        $registro_sar= $this->gsatelite->get_tabla('sar_saldo_articulo',array('sar_id'=>$id_sar));
        $id_f=($id_furgon)? $id_furgon:0;
        $registro_contenedor=$this->gsatelite->get_tabla('ixc_ingresoxcontenedor',array('ixc_id'=>$id_f));

        $data['tiene_salidas']=count($tiene_salidas);
        $data['saldo_actual']=$saldo_actual;
        $data['id_sar_saldo']=$id_sar;
        $data['n_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['id_furgon']=$id_furgon;
        $data['registro_contendor'] = $registro_contenedor[0];

        $data['detalle_entradas'] = $this->inventario_model->detalle_entradasxsar_id($id_sar,true,$id_furgon);
        $this->load->view('inventario/correccion_inventario/consultas_detalle_entradas',$data);
    }

    function actualizar_entrada_detalle() {
        satelite_validar(true);
        if($_POST){
           // print_r($_POST); die();
            $id_detalle = $this->input->post('id_detalle');
            $id_art = $this->input->post('nuevo_art');
            $id_sar = $this->input->post('id_sar');
            $id_fugon = $this->input->post('id_furgon'); 

            $valor_detalle = $this->input->post('valor_detalle');
            $nuevo_saldo = $this->input->post('nuevo_saldo');
            $nuevo_precio = $this->input->post('nuevo_precio');

            $contenedor =  $this->input->post('contenedor');   
            $caja =  $this->input->post('caja');   
            $cantidad_caja =  $this->input->post('cantidad_caja');

            if ($id_detalle>0){ 
            $update= array('dee_cantidad'=>$valor_detalle,'dee_precio'=>$nuevo_precio,'dee_id_art'=>$id_art,'dee_usr_mod'=>$this->tank_auth->get_user_id(),'dee_fecha_mod'=>date('Y-m-d H:i:s'));
            $exito= $this->gsatelite->actualizar_array('dee_detalle_mov',$update, array('dee_id'=>$id_detalle));
            }

            if ($id_sar>0) {
             $update= array('sar_cant_actual'=>$nuevo_saldo,'sar_precio'=>$nuevo_precio,'sar_id_art'=>$id_art,'sar_usu_mod'=>$this->tank_auth->get_user_id(),'sar_fecha_mod'=>date('Y-m-d H:i:s'));
             $exito= $this->gsatelite->actualizar_array('sar_saldo_articulo',$update, array('sar_id'=>$id_sar));
            }

            if ($id_fugon>0) {
             $update= array(
                'ixc_cantidad_actual'=>$nuevo_saldo,
                'ixc_contenedor'=>$contenedor,
                'ixc_caja'=>$caja,
                'ixc_cantidad_caja'=>$cantidad_caja,
                'ixc_usu_mod'=>$this->tank_auth->get_user_id(),
                'ixc_fecha_mod'=>date('Y-m-d H:i:s'));
             $exito= $this->gsatelite->actualizar_array('ixc_ingresoxcontenedor',$update, array('ixc_id'=>$id_fugon));
            } 

            echo json_encode(array('exito'=>$exito));

        }
    }

    function consulta_detalle_furgon($articulo,$furgon)
    {
       
       die('en desarrollo....');
        $data['detalle_furgon']=$this->inventario_model->detalle_existenciaxfurgon($articulo,$furgon);
        $this->load->view('inventario/correccion_inventario/consultas_detalle_furgon',$data);
    }

     function ver_precios($id_sar)
        {
             die('en desarrollo....');
            $data['precios']=$this->inventario_model->listado_precios($id_sar);
            $this->load->view('inventario/correccion_inventario/ver_precios',$data);
        }

    function comparar_saldos($id_sar=null, $id_ixc=null,$saldo_detalle=null) {
        if($id_sar!=null and $id_ixc!=null and $saldo_detalle!=null) {
        $registro_sar = $this->gsatelite->get_tabla('sar_saldo_articulo',array('sar_id'=>$id_sar));
        $registro_ixc = $this->gsatelite->get_tabla('ixc_ingresoxcontenedor',array('ixc_id'=>$id_ixc));
        $data['sar_saldo']= $registro_sar[0];
        $data['contenedor']= $registro_ixc[0]; 
        $data['saldo_detalles']= $saldo_detalle; 
        $this->load->view('inventario/correccion_inventario/comparar_saldos', $data, FALSE);
        }else {
            echo "ERROR!!!";
        }
    }    

    function actualizar_saldo() {
        //print_r($_POST);
       $id_sar= $this->input->post('id_sar');
        $id_ixc= $this->input->post('id_ixc');
        $valor_detalle= $this->input->post('valor_detalle');
        $aplica_sar= $this->input->post('aplica_sar');
        $aplica_con= $this->input->post('aplica_con');
        $exito=0;
        if($aplica_sar){ 
        $update= array('sar_cant_actual'=>$valor_detalle,'sar_usu_mod'=>$this->tank_auth->get_user_id(),'sar_fecha_mod'=>date('Y-m-d H:i:s'));
        $exito= $this->gsatelite->actualizar_array('sar_saldo_articulo',$update, array('sar_id'=>$id_sar));
        }
        if ($aplica_con) {
         $update= array('ixc_cantidad_actual'=>$valor_detalle,'ixc_usu_mod'=>$this->tank_auth->get_user_id(),'ixc_fecha_mod'=>date('Y-m-d H:i:s'));
         $exito= $this->gsatelite->actualizar_array('ixc_ingresoxcontenedor',$update, array('ixc_id'=>$id_ixc));
        }

        echo json_encode(array('exito'=>$exito));
    }

    

	function index()
	{
		$data['solicitudes'] = $this->inventario_model->consulta_general('tra_translado');
        $data['titulo_personal']='KARDEX POR PRODUCTO';
		$this->_cargarvista(null,$data);
	}

    function krdx_producto()
    {
        $data['usuarios']  = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->cargar_todo('bod_bodega');
        $data['titulo_personal']='KARDEX POR PRODUCTO';
        $this->_cargarvista(null,$data);
    }


    function krdx_tipo_art()
    {
        $data['usuarios']  = $this->inventario_model->informacion_empleado($this->tank_auth->get_user_id());
        $data['bodega'] = $this->inventario_model->cargar_todo('bod_bodega');
        $data['titulo_personal']='KARDEX POR CATEGORÍA';
        $this->_cargarvista(null,$data);
    }
 function get_kardex_producto()
    {
        $id_prod= $this->input->post('id_prod');
        $id_bod= $this->input->post('id_bod');
        $fecha_ini= $this->input->post('fecha_ini');
        $fecha_fin= $this->input->post('fecha_fin');

        /*print_r($id_bod.'*'.$id_prod.'*'.$fecha_ini.'*'.$fecha_fin);
        exit();*/

        $kardex_prod = $this->inventario_model->kardex_producto($id_prod,$id_bod,$fecha_ini,$fecha_fin);
        $nombre_prod = $this->db->where('art_id', $id_prod)->join('mep_medida_producto','mep_id=art_id_mep')->get('art_articulo')->result_array();
        $nombre_bod = $this->inventario_model->cargar_registro('bod_bodega','bod_id',$id_bod);


$precios_detalle = array(); 
      foreach ($kardex_prod as $key) {
        array_push($precios_detalle,$key['dee_cantidad']);
      }

      $total_dee_cantidad = array_sum($precios_detalle);

        //header("Content-type: application/vnd.ms-excel");

        $html ='';
        $html.='<thead>';
            $html.='<tr>';
                $html.='<th colspan="12">';
                $html.='<center>BODEGA: <span>'.$nombre_bod['bod_nombre'].'</span></center>';
                $html.='</th>';
            $html.='</tr><tr>'; 
                $html.='<th colspan="12">';
                $html.='<center>PRODUCTO: <span>'.$nombre_prod[0]['art_nombre'].'- IDENTIFICADOR['.$nombre_prod[0]['art_codigo'].']</span></center>';
                $html.='</th>';
            $html.='</tr>';
            $html.='<tr>'; 
                $html.='<th colspan="12">';
                $html.='<center>MEDIDA: <span>'.$nombre_prod[0]['mep_nombre'].'</span></center>';
                $html.='</th>';
            $html.='</tr>';
        $html.='<tr>';
                $html.='<th >';
                    $html.='FECHA';
                $html.='</th>';
                $html.='<th >';
                    $html.='PROCESO';
                $html.='</th>';
                $html.='<th >';
                    $html.='DOCUMENTO';
                $html.='</th>';
                $html.='<th >';
                    $html.='PROVEEDOR';
                $html.='</th>';
                $html.='<th colspan="3">';
                    $html.='ENTRADAS';
                $html.='</th>';
                $html.='<th colspan="3">';
                    $html.='SALIDAS';
                $html.='</th>';
                $html.='<th colspan="3">';
                    $html.='EXISTENCIAS';
                $html.='</th>';
            $html.='</tr>';
        $html.='</thead><tbody id="contenedor">';

            $html.='<tr>';
                $html.='<td></td>';
                $html.='<td></td>';
                $html.='<td></td>';
                $html.='<td></td>';
                $html.='<td>Cantidad</td>';
                $html.='<td>Precio</td>';
                $html.='<td>Total</td>';
                $html.='<td>Cantidad</td>';
                $html.='<td>Precio</td>';
                $html.='<td>Total</td>';
                $html.='<td>Saldo Cantidad</td>';
                $html.='<td colspan="2"><span style="alignment:right;">Saldo Valor</span></td>';
             $html.='</tr>';

        $dee_cantidad1 = array();
        $dee_cantidad2 = array();
        $dee_precio1 = array();
        $dee_precio2 = array();
        $monto_existencia = array();
        $entradas = array();
        $salidas = array();
        $cantidad_existencia = array();
        foreach ($kardex_prod as $key) 
        {   
            $html.='<tr>';
            $html.='<td>'.date("Y-m-d", strtotime($key['moi_fecha_mov'])).'</td>';
            $html.='<td>'.$key['tip_nombre'].'</td>';
            $html.='<td>'.$key['moi_documento'].'</td>';
            $html.='<td>'.$key['prv_nombre'].'</td>';


            if($key['tip_entrada']==1){
                $html.='<td style="color: blue; text-align:right;">'.number_format($key['dee_cantidad'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $html.='<td style="color: blue; text-align:right;">'.'$'.number_format($key['dee_precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $html.='<td style="color: blue; text-align:right;">'.'$'.number_format(($key['dee_cantidad']*$key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $html.='<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                $total_entradas = round(($key['dee_cantidad']*$key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES'));
                array_push($entradas, $total_entradas);
                $t_entradas = array_sum($entradas);
                array_push($dee_cantidad1, $key['dee_cantidad']);
                $ttc1 = array_sum($dee_cantidad1);
                array_push($dee_precio1, $key['dee_precio']);
                $ttp1 = array_sum($dee_precio1);
            }

            if($key['tip_salida']==1){
                $html.='<td style="color: red; text-align:right;">&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                $html.='<td style="color: red; text-align:right;">'.number_format($key['dee_cantidad'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $html.='<td style="color: red; text-align:right;">'.'$'.number_format($key['dee_precio'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $html.='<td style="color: red; text-align:right;">'.'$'.number_format(($key['dee_cantidad']*$key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $total_salidas = round(($key['dee_cantidad']*$key['dee_precio']), $this->gsatelite->get_parametro('NUMERO_DECIMALES'));
                array_push($salidas, $total_salidas);
                $t_salidas = array_sum($salidas);             
                array_push($dee_cantidad2, $key['dee_cantidad']);
                $ttc2 = array_sum($dee_cantidad2);
                array_push($dee_precio2, $key['dee_precio']);
                $ttp2 = array_sum($dee_precio2);
            }

            if($key['cantidad_existencia']==null){
                $html.='<td>0</td>';
                $html.='<td colspan="2"><span style="alignment:right;">'.'$0'.'</span></td>';
            }else{
                if($key['tip_salida']==1){
                $html.='<td style="color: red; text-align:right;">'.number_format($key['cantidad_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $html.='<td colspan="2" style="color: red;"><span style="alignment:right;">'.'$'.number_format($key['monto_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</span></td>'; 
                }else{
                $html.='<td style="color: blue; text-align:right;">'.number_format($key['cantidad_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</td>';
                $html.='<td colspan="2" style="color: blue;"><span style="alignment:right;">'.'$'.number_format($key['monto_existencia'], $this->gsatelite->get_parametro('NUMERO_DECIMALES')).'</span></td>';                    
                }

                array_push($cantidad_existencia, $key['cantidad_existencia']);
                $total_cantidad_existencia = array_sum($cantidad_existencia); 
                array_push($monto_existencia, $key['monto_existencia']);
                $total_monto_existencia = array_sum($monto_existencia);
                                
            }

            $html.='</tr>';
            
        }
        /*$html.='<tr>';
            $html.='<td></td>';
            $html.='<td><b>Total:</b></td>';
            $html.='<td></td>';
            $html.='<td style="color: blue; text-align:right;">'.number_format($ttc1,2).'</td>';
            $html.='<td style="color: blue; text-align:right;"><!--$'.number_format($ttp1,2).'--></td>';
            $html.='<td style="color: blue; text-align:right;">$'.number_format($t_entradas,2).'</td>';
            if(isset($ttc2) && isset($ttp2) && isset($t_salidas)){
            $html.='<td style="color: red; text-align:right;">'.number_format($ttc2,2).'</td>';
            $html.='<td style="color: red; text-align:right;"><!--$'.number_format($ttp2,2).'--></td>';
            $html.='<td style="color: red; text-align:right;">$'.number_format($t_salidas,2).'</td>';
        }
        else
        {
            $html.='<td>'./*$total_cantidad_existencia.*/'</td>';
            //$html.='<td>'./*round($total_monto_existencia,2).*/'</td>';
            //$html.='<td>'./*$total_cantidad_existencia.*/'</td>';
        //}
           // $html.='<td>'./*$total_cantidad_existencia.*/'</td>';
            //$html.='<td>'./*round($total_monto_existencia,2).*/'</td>';


            //$html.='</tr>';

        $html.='</tbody>';

      $arreglo = array( 
          "drop"=>$html
      );
      
      echo json_encode($arreglo);
  }

  function get_kardex_tipo()
    {
        $ultima_categoria=$this->input->post('categoria');
        $bodega=$this->input->post('bodega');
        $fecha_ini= $this->input->post('fecha_ini');
        $fecha_fin= $this->input->post('fecha_fin');



        /*print_r($id_bod.'*'.$id_prod.'*'.$fecha_ini.'*'.$fecha_fin);
        exit();*/

        
        //$nombre_cat = $this->inventario_model->cargar_registro('tia_tipo_articulo','tia_id',$id_cat);
        $nombre_bod = $this->inventario_model->cargar_registro('bod_bodega','bod_id',$bodega);

        //header("Content-type: application/vnd.ms-excel");

        $cabezera ='';
        $cabezera2 ='';
        $cabezera.='<thead>';
            $cabezera.='<tr>';
                $cabezera.='<th colspan="14">';
                $cabezera.='<center>BODEGA: <span>'.$nombre_bod['bod_nombre'].'</span></center>';
                $cabezera.='</th>';
            $cabezera.='</tr><tr>'; 
                $cabezera.='<th colspan="14">';
                //$cabezera.='<center>TIPO DE PRODUCTO: <span>'.$nombre_cat['tia_nombre'].'</span></center>';
                $cabezera.='</th>';
            $cabezera.='</tr>';
        $cabezera2.='<tr>';
                $cabezera2.='<th >';
                    $cabezera2.='FECHA';
                $cabezera2.='</th>';
                $cabezera2.='<th >';
                    $cabezera2.='PROCESO';
                $cabezera2.='</th>';
                $cabezera2.='<th >';
                    $cabezera2.='DOCUMENTO';
                $cabezera2.='</th>';
                $cabezera2.='<th >';
                    $cabezera2.='MEDIDA';
                $cabezera2.='</th>';
                $cabezera2.='<th >';
                    $cabezera2.='PRODUCTO';
                $cabezera2.='</th>';
                $cabezera2.='<th colspan="3">';
                    $cabezera2.='ENTRADAS';
                $cabezera2.='</th>';
                $cabezera2.='<th colspan="3">';
                    $cabezera2.='SALIDAS';
                $cabezera2.='</th>';
                $cabezera2.='<th colspan="3">';
                    $cabezera2.='EXISTENCIAS';
                $cabezera2.='</th>';
            $cabezera2.='</tr>';
        $cabezera2.='</thead><tbody id="contenedor">';

            $cabezera2.='<tr>';
                $cabezera2.='<td></td>';
                $cabezera2.='<td></td>';
                $cabezera2.='<td></td>';
                $cabezera2.='<td></td>';
                $cabezera2.='<td>Descripci&oacute;n</td>';
                $cabezera2.='<td>Cantidad</td>';
                $cabezera2.='<td>Precio</td>';
                $cabezera2.='<td>Total</td>';
                $cabezera2.='<td>Cantidad</td>';
                $cabezera2.='<td>Precio</td>';
                $cabezera2.='<td>Total</td>';
                $cabezera2.='<td colspan="3"><span style="text-align:right;">Saldo</span></td>';
             $cabezera2.='</tr>';

             $padre_del_padre = array();
            $i=0;
            if($ultima_categoria == ""){
                    $categorias_total=$this->inventario_model->get_categorias();

                    foreach ($categorias_total as $y) {
                        $padre_del_padre[]=$y['tia_id'];
                    }
                    array_push($padre_del_padre, '');

            }else{
            while ( $ultima_categoria != null) {
                if($i==0){
                    $padre_del_padre[]=$ultima_categoria;
                }else{
                    $ultima_categoria=$this->db->where('tia_id', $ultima_categoria)->get('tia_tipo_articulo')->row_array();
                    $ultima_categoria=$ultima_categoria['tia_padre'];         
                    $padre_del_padre[]=$ultima_categoria;
                }
                $i++;
            }
            }
            $categorias_final=array_reverse($padre_del_padre);


            /*--------------------------------------------------------------------*/


            /*---------------------DEPENDENCIAS ENCONTRADAS-----------------------*/

                $cadena=""; // arreglo que mandaremos en un json
                $elementos=array(); // arreglo para almacenar todos los padre de la ultima opcion que se elije

                foreach ($categorias_final as $key => $value) {
                    if($key != null){
                        $elemento=$this->db->where('tia_id', $value)->get('tia_tipo_articulo')->row_array();
                        $elementos[]=array($elemento['tia_id']=>$elemento['tia_nombre']);

                    }   
                }


                if($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0){ $col=14;}else{ $col=11; } 
                $ultimo_padre=end($elementos);

                $departamento_inf_tr="";
                $departamento_infe_tr="";
                $i=1;
                foreach ($elementos as $key => $value) {
                    foreach ($value as $ids => $valores) {


                        if($ids!=key($ultimo_padre)){

                            $departamento_infe_tr='<tr><td colspan="'.$col.'"><b><br />Departamento '.$i.': '.$valores.'</b></td></tr>';

                        }else{

                            $tia_hijo=$this->inventario_model->get_tia_hijo($bodega,$ids);


                            if(count($tia_hijo)>0){
                                $departamento_inf_tr.=$departamento_infe_tr;
                                foreach ($tia_hijo as $tia => $tipo) {

                                    $informacion=$this->inventario_model->kardex_tipo($tipo['tia_id'],$bodega,$fecha_ini,$fecha_fin);
                                   //print_r($informacion);
                                    if(count($informacion)>0){
                                        $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$tipo['tia_nombre'].'</b></td></tr>';
                                        $departamento_inf_tr.=$cabezera2;
                                        $departamento_inf_tr.=$this->cuerpo_kardex($informacion);
                                    }
                                }
                            }else {
                                $informacion=$this->inventario_model->kardex_tipo($ids,$bodega,$fecha_ini,$fecha_fin);
                                //print_r($this->db->last_query());
                                if(count($informacion)>0){
                                    $departamento_inf_tr.='<tr><td colspan="'.$col.'"><b><br />Categoría '.$i.': '.$valores.'</b></td></tr>';
                                    $departamento_inf_tr.=$cabezera2;
                                    $departamento_inf_tr.=$this->cuerpo_kardex($informacion);
                                }
                            }       
                        }
                    }
                    $i++;
                }


        $cadena.=$cabezera.$departamento_inf_tr;


        

       // $kardex_tipo = $this->inventario_model->kardex_tipo($id_cat,$id_bod,$fecha_ini,$fecha_fin);
        


      $arreglo = array( 
          "drop"=>$cadena
      );
      
      echo json_encode($arreglo);
  }

  public function cuerpo_kardex($informacion)
  {
        $dee_cantidad1 = array();
        $dee_cantidad2 = array();
        $dee_precio1 = array();
        $dee_precio2 = array();
        $monto_existencia = array();
        $entradas = array();
        $salidas = array();
        $cantidad_existencia = array();
        $html="";
    foreach ($informacion as $key) 
        {   
            $html.='<tr>';
            $html.='<td>'.date("Y-m-d", strtotime($key['moi_fecha_mov'])).'</td>';
            $html.='<td>'.$key['tip_nombre'].'</td>';
            $html.='<td>'.$key['moi_documento'].'</td>';
            $html.='<td>'.$key['mep_nombre'].'</td>';
            $html.='<td>'.$key['art_nombre'].'['.$key['art_codigo'].']</td>';
            if($key['tip_entrada']==1){
                $html.='<td style="color: blue; text-align:right;">'.number_format($key['dee_cantidad'], 2).'</td>';
                $html.='<td style="color: blue; text-align:right;">'.'$'.number_format($key['dee_precio'], 2).'</td>';
                $html.='<td style="color: blue; text-align:right;">'.'$'.number_format(round(($key['dee_cantidad']*$key['dee_precio']),2),2).'</td>';
                $html.='<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                $total_entradas = round(($key['dee_cantidad']*$key['dee_precio']),2);
                array_push($entradas, $total_entradas);
                $t_entradas = array_sum($entradas);
                array_push($dee_cantidad1, $key['dee_cantidad']);
                $ttc1 = array_sum($dee_cantidad1);
                array_push($dee_precio1, $key['dee_precio']);
                $ttp1 = array_sum($dee_precio1);
            }
            
            if($key['tip_salida']==1){
                $html.='<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>';
                $html.='<td style="color: red; text-align:right;">'.number_format($key['dee_cantidad'], 2).'</td>';
                $html.='<td style="color: red; text-align:right;">'.'$'.number_format($key['dee_precio'], 2).'</td>';
                $html.='<td style="color: red; text-align:right;">'.'$'.number_format(round(($key['dee_cantidad']*$key['dee_precio']),2),2).'</td>';
                $total_salidas = round(($key['dee_cantidad']*$key['dee_precio']),2);
                array_push($salidas, $total_salidas);
                $t_salidas = array_sum($salidas);             
                array_push($dee_cantidad2, $key['dee_cantidad']);
                $ttc2 = array_sum($dee_cantidad2);
                array_push($dee_precio2, $key['dee_precio']);
                $ttp2 = array_sum($dee_precio2);
            }

            if($key['cantidad_existencia']==null){
                $html.='<td>0</td>';
                $html.='<td colspan="2" style="text-align:right;"><span style="text-align:right;">'.'$0'.'</span></td>';
            }else{               
                if($key['tip_salida']==1){
                    $html.='<td style="color: red; text-align:right;">'.number_format($key['cantidad_existencia'], 2).'</td>';
                    $html.='<td colspan="2" style="color: red; text-align:right;"><span style="text-align:right;">'.'$'.number_format(round($key['monto_existencia'],2), 2).'</span></td>';
                }else{
                 $html.='<td style="color: blue; text-align:right;">'.number_format($key['cantidad_existencia'], 2).'</td>';
                 $html.='<td colspan="2" style="color: blue; text-align:right;"><span style="text-align:right;">'.'$'.number_format(round($key['monto_existencia'],2), 2).'</span></td>';   
                }
                array_push($cantidad_existencia, $key['cantidad_existencia']);
                $total_cantidad_existencia = array_sum($cantidad_existencia); 
                array_push($monto_existencia, $key['monto_existencia']);
                $total_monto_existencia = array_sum($monto_existencia); 
            }

            $html.='</tr>';
        }
            $html.='<tr>';
            $html.='<td></td>';
            $html.='<td><b>Total:</b></td>';
            $html.='<td></td>';
            $html.='<td></td>';
            $html.='<td></td>';
            $html.='<td style="color: blue; text-align:right;">'.number_format(round($ttc1,2), 2).'</td>';
            $html.='<td style="color: blue; text-align:right;"><!--$'.number_format(round($ttp1,2), 2).'--></td>';
            $html.='<td style="color: blue; text-align:right;">$'.number_format($t_entradas, 2).'</td>';
            if(isset($ttc2) && isset($ttp2) && isset($t_salidas)){
            $html.='<td style="color: red; text-align:right;">'.number_format(round($ttc2,2), 2).'</td>';
            $html.='<td style="color: red; text-align:right;"><!--$'.number_format(round($ttp2,2), 2).'--></td>';
            $html.='<td style="color: red; text-align:right;">$'.number_format($t_salidas, 2).'</td>';
}
        else
        {
            $html.='<td>'./*$total_cantidad_existencia.*/'</td>';
            $html.='<td>'./*round($total_monto_existencia,2).*/'</td>';
            $html.='<td>'./*$total_cantidad_existencia.*/'</td>';
        }
           
            $html.='<td></td>';
            $html.='<td></td>';

            $html.='</tr>';

        $html.='</tbody>';

        return $html;
  }


  function export_excel($tipoR=1){
    //$tipoR=1 (excel), $tipoR=2 (pdf)
    if($tipoR==1) {
    header("Content-type: application/vnd.ms-excel; name='excel'"); 
    header("Content-Disposition: filename=ficheroExcel.xls"); 
    header("Pragma: no-cache"); 
    header("Expires: 0"); 
    echo $_POST['datos_a_enviar']; 
    }
    else if($tipoR==2){
        $data['table_header']     = "Reporte Kardex por Producto";
        $data["table_tbody"] = $_POST['datos_a_enviar']; 
        $this->pdf->reportePDF('inventario/reportes/reporte_kardexproducto_pdf.php', $data, 'Kardex Producto','L');
    }
  }

    function generar_boleta()
    {
    	$id_solicitud = $this->input->get('identificador');
        $obtener_movimiento_salida = $this->inventario_model->consulta_condicion_resultado('tra_translado','tra_id',$id_solicitud);
        $id_movimiento_salida = $obtener_movimiento_salida[0]['tra_id_moi_sal'];

        $campos_pdf = "dee_cantidad, dee_precio,art_nombre";
        $join_pdf   = "dee_detalle_mov,dbo.sar_saldo_articulo.sar_id = dbo.dee_detalle_mov.dee_id_sar/art_articulo,dbo.art_articulo.art_id = dbo.sar_saldo_articulo.sar_id_art";
        $tabla = "sar_saldo_articulo";
        $campo_condicion = "dbo.dee_detalle_mov.dee_id_moi";
        $data['detalle'] = $this->inventario_model->consulta_ejecutando_join($tabla,$campos_pdf,$join_pdf,$campo_condicion,$id_movimiento_salida);
        $html = $this->load->view('inventario/boleta_traslado/generar_pdf', $data, true);

        $this->load->library('PDF');
        $cabecera = '<table>';
            $cabecera .= '<tr>';
            $cabecera .= '<td><img src="' . base_url('/media/images/reporte/logo_small2.jpg') . '" alt="UTE" /></td>';
            $cabecera .= '<td><h1>Unidad T&eacute;cnica Ejecutiva del Sector de Justicia</h1></td>';
            $cabecera .= '</tr>';
            $cabecera .= '</table>';


        $pdf = $this->pdf->cargarPdf();
            $pdf->mirrorMargins = 1;
            //Agregar metadata al PDF
            $pdf->SetTitle( 'Traslado de inventario' );
            $pdf->SetAuthor( $this->config->item('sistema') . ' desarrollado por Grupo Satelite El Salvador');
            //Obtener el contenido de print.css
            $stylesheet = file_get_contents( base_url( 'stylesheets/print.css' ) );
            //Importante! el parametro entero 1 indica que esta es una hoja de estilo para el reporte
            $pdf->WriteHTML( $stylesheet, 1 );
            $pdf->SetHTMLHeader($cabecera);
            //Crear footer del reporte {sistema} - {Numero Pagina} - {fecha y hora}  
            $pdf->SetFooter( $this->config->item('sistema') . '|{PAGENO}|' . date("Ymd h:i:s") ); 
            //Escribir el resultado HTML en el PDF
            $pdf->WriteHTML( $html );
            //Guardar el archivo 
            $pdf->Output( $ruta_archivo_pdf, 'D'); 
 
    }
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}

}
?>