<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Consultas extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->library('excel/excel_reader.php');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function busqueda_codigo() {
        $post_array = $this->input->post();        
        $codigo = $post_array['codigo_buscar'];        
        $fecha_inicio = ($post_array['fecha_ini']!='')?date('Y-m-d',strtotime($post_array['fecha_ini'])):null;
        $fecha_fin = ($post_array['fecha_fin']!='')?date('Y-m-d',strtotime($post_array['fecha_fin'])):null;        
        $this->db->select('art_id')
                ->from('art_articulo')
                ->where('art_id', $codigo);
                // Se comentaron ya que el campo de busqueda ya no es texto
                // Sino un select ajax
                // ->where('art_codigo', $codigo)
                // ->or_where('art_nombre', $codigo);
        $articulo = $this->db->get()->result_array();
        $cadena = '';
        foreach ($articulo as $key2 => $codigo) {
            //$informacion = $this->inventario_model->consultaxcodigo($codigo['art_id']);            
            $where = "dee_id_art = " . $codigo['art_id'] . " ";            
            if($fecha_inicio != null && $fecha_fin != null){
                $where .= "AND DATE(moi_fecha_mov) >= '".$fecha_inicio."' ";
                $where .= "AND DATE(moi_fecha_mov) <= '".$fecha_fin."' ";
            }            
            $group_by = "bod_id";
            $order_by = "moi_fecha_mov ASC";
            $informacion = $this->inventario_model->consultar_movimientos_articulo($where, $group_by, $order_by);
            if (empty($informacion)) {
                $cadena .= '';
                break;
            }
            $cadena .= '<thead>';
            $url_img_pc = ($informacion[0]['foto'] != "") ? FCPATH . "assets/uploads/images/" . $informacion[0]['foto'] : "";
            $url_img = (file_exists($url_img_pc)) ? base_url('/assets/uploads/images/' . $informacion[0]['foto']) : base_url('/media/imagenes/sistema/noimagefound.jpg');
            $cadena .= '<tr><th colspan="9"><img src="' . $url_img . '" style="width:150px;height:150px;border: 1px solid gray;border-radius: 10px;"></th>';
            $cadena .= '<tr><th colspan="9"><b>Código: </b>' . @$informacion[0]['codigo'] . '</th>';
            $cadena .= '<tr><th colspan="9"><b>Nombre: </b>' . @$informacion[0]['nombre'] . '</th>';
            $cadena .= '<tr><th colspan="9"><b>Marca: </b>' . @$informacion[0]['marca'] . '</th>';
            $cadena .= '<tr>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cadena .= '<th style="">Contenedor</th>';
                $cadena .= '<th>Número de caja</th>';
                $cadena .= '<th style="">Acciones</th>';
            }
            $cadena .= '<th style="">Bodega</th>';
            $cadena .= '<th style="">Entradas</th>';
            $cadena .= '<th style="">Acciones</th>';
            $cadena .= '<th style="">Salidas</th>';
            $cadena .= '<th style="">Acciones</th>';
            $cadena .= '<th style="">Existencia Bodega</th>';
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $cadena .= '<th style="">Acciones</th>';
            }
            $cadena .= '</tr>';
            $cadena .= '</thead>';
            $n_decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            foreach ($informacion as $key) {
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $id_ixc = "/" . $key['ixc'];
                    $cadena .= '<tr><td>' . $key['furgon'] . '</td>';
                    $cadena .= '<td>' . $key['caja'] . '</td>';
                    $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/reportes/ver_precios/' . $key['id_sar'] . '">Ver precios</a></td>';
                } else {
                    $id_ixc = 0;
                    $cadena .= '<tr>';
                }
                $cadena .= '<td style="text-align:left;">' . $key['bodega'] . '</td>';
                $cadena .= '<td style="text-align:right;">' . number_format($key['Entradas'], ($n_decimales) ? $n_decimales : 2) . '</td>';
                $cadena .= '<td><a class="linker btn" href="'.base_url().'inventario/consultas/get_detalle_inn_out_bod/'.$key['art_id'].'/'.$key['bod_id'].'/'.$fecha_inicio.'/'.$fecha_fin.'/1/'.$id_ixc.'/0">Ver entradas</a></td>';
                $cadena .= '<td style="text-align:right;">' . number_format($key['Salidas'], ($n_decimales) ? $n_decimales : 2) . '</td>';
                $cadena .= '<td><a class="linker btn" href="'.base_url().'inventario/consultas/get_detalle_inn_out_bod/'.$key['art_id'].'/'.$key['bod_id'].'/'.$fecha_inicio.'/'.$fecha_fin.'/0/'.$id_ixc.'/0">Ver salidas</a></td>';
                $cadena .= '<td  style="text-align:right;">' . number_format($key['Saldo'], ($n_decimales) ? $n_decimales : 2) . '</td>';
                if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                    $cadena .= '<td><a class="linker btn" href="' . base_url() . 'inventario/consultas/consulta_detalle_furgon/' . $key['art_id'] . '/' . $key['furgon'] . '">Ver detalles</a></td></tr>';
                }
            }
        }

        $arreglo = array(
            "drop" => $cadena,
        );

        echo json_encode($arreglo);
    }

    function consultas_detalle_salidas($sar_id, $id_furgon = null,$traslados = 1) {
        $data['n_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['detalles'] = $this->inventario_model->detalle_salidasxsar_id($sar_id, null, $id_furgon,$traslados);
        $this->load->view('inventario/consultas/consultas_detalle_salidas', $data);
    }

    function get_detalle_inn_out_bod($art_id, $bod_id, $fecha_ini, $fecha_fin, $tipo, $id_furgon, $traslados) {
        $data['dec'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $tip = ($tipo > 0) ? "tip_entrada" : "tip_salida";
        $where = array('dee_id_art' => $art_id, 'moi_id_bod' => $bod_id, 'DATE(moi_fecha_mov) >= ' => $fecha_ini, 'DATE(moi_fecha_mov) <= ' => $fecha_fin, $tip => 1);
        $data['detalles'] = $this->inventario_model->get_detalle_inn_out_bod($where, $id_furgon, $traslados);
        if ($tipo > 0) {
            $this->load->view('inventario/consultas/consultas_detalle_entradas', $data);
        } else {
            $this->load->view('inventario/consultas/consultas_detalle_salidas', $data);
        }        
    }

    function consultas_detalle_entradas($sar_id, $id_furgon = null, $traslados = 1) {
        $data['n_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['detalles'] = $this->inventario_model->detalle_entradasxsar_id($sar_id, null, $id_furgon,$traslados);
        $this->load->view('inventario/consultas/consultas_detalle_entradas', $data);
    }

    function consulta_detalle_furgon($articulo, $furgon) {
        $data['detalle_furgon'] = $this->inventario_model->detalle_existenciaxfurgon($articulo, $furgon);
        $this->load->view('inventario/consultas/consultas_detalle_furgon', $data);
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}
