﻿<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Catalogo extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
	
		$this->load->model('gsatelite');
		$this->load->library('grocery_CRUD');
        
        if(ob_get_contents()) ob_end_clean();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}
  
	public function add_articulos()
    {
      
      $objeto_crud = new grocery_CRUD;
      $objeto_crud->set_table('art_articulo');
      $objeto_crud->set_subject('Artículo');
      $objeto_crud->set_relation('art_id_tia','tia_tipo_articulos','tia_nombre');
      $objeto_crud->set_relation('art_id_uni','uni_unidad_medida','uni_nombre');

      $objeto_crud->add_fields('art_nombre','art_codigo','art_minimo','art_maximo','art_id_tia','art_id_uni');
      $objeto_crud->columns('art_codigo','art_id_uni','art_id_tia','art_nombre');
      $objeto_crud->display_as('art_id_tia','Específico');
      $objeto_crud->display_as('art_nombre','Nombre del articulo');
      $objeto_crud->display_as('art_minimo','Cantidad minima del articulo');
      $objeto_crud->display_as('art_maximo','Cantidad maxima del articulo');
      $objeto_crud->display_as('art_id_uni','Unidad de articulo');

      $objeto_crud->set_rules('art_nombre','Nombre del articulo','required');
      $objeto_crud->set_rules('art_codigo','Codigo del articulo','required');
      $objeto_crud->set_rules('art_minimo','Cantidad minima del articulo','required||integer');
      $objeto_crud->set_rules('art_maximo','Cantidad maxima del articulo','required||integer');
      $objeto_crud->set_rules('art_id_tia','Específico','required');
      $objeto_crud->set_rules('art_id_uni','Unidad de medida del articulo','required');
      $objeto_crud->unset_delete();
      $output = $objeto_crud -> render();
      $this->_cargarvista(null,$output);
   }

    public function add_tipo()
    {
        $crud = new grocery_CRUD;
        $crud->set_table('tia_tipo_articulos');
        $crud->set_subject('Específicos');
        $crud->add_fields('tia_nombre', 'tia_estado');
        $crud->columns('tia_nombre');
        $crud->display_as('tia_nombre', 'Nombre de específico');
        $crud->display_as('tia_estado', 'Estado de específico');
        $crud->set_rules('tia_nombre','Nombre de específico','required');
        $crud->set_rules('tia_estado','Estado de específico','required||integer');
        $crud->unset_delete();
        $output = $crud->render();
        $this->_cargarvista(null, $output);
    }

    public function ingresar_tipo_unidad()
    {
        $crud = new grocery_CRUD;
        $crud->set_table('uni_unidad_medida');
        $crud->set_subject('Unidad de Medida');

        $crud->add_fields('uni_nombre', 'uni_abreviacion');
        $crud->columns('uni_nombre', 'uni_abreviacion');

        $crud->display_as('uni_nombre', 'Nombre');
        $crud->display_as('uni_abreviacion', 'Abreviación');

        $crud->set_rules('uni_nombre','Nombre','required');
        $crud->set_rules('uni_abreviacion','Abreviación','required');

        $output = $crud->render();
        $this->_cargarvista(null, $output);
    }

	
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */