<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Boleta_traslado extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('inventario_model');
        $this->load->library('pdf');
        $this->load->model('gsatelite');
    }

    function index()
    {
        $data['solicitudes'] = $this->inventario_model->consulta_general('tra_translado');
        $data['titulo_personal'] = 'Traslado entre bodegas';
        $this->_cargarvista(null, $data);
    }

    function generar_boleta()
    {
        $id_solicitud = $this->input->get('identificador');
        $obtener_movimiento_salida = $this->inventario_model->consulta_condicion_resultado('tra_translado', 'tra_id', $id_solicitud);
        $id_movimiento_salida = $obtener_movimiento_salida[0]['tra_id_moi_sal'];
        $id_movimiento_entrada = $obtener_movimiento_salida[0]['tra_id_moi_ent'];

        //var_dump($obtener_movimiento_salida);die();

        $campos_pdf = "dee_cantidad, dee_precio,art_codigo,art_nombre, mrp_nombre";
        $join_left = "mrp_marca_producto,art_articulo.art_id_mrp = mrp_marca_producto.mrp_id";
        $join_pdf = "dee_detalle_mov,sar_saldo_articulo.sar_id = dee_detalle_mov.dee_id_sar/art_articulo,art_articulo.art_id = sar_saldo_articulo.sar_id_art";
        $tabla = "sar_saldo_articulo";
        $campo_condicion = "dee_detalle_mov.dee_id_moi";
        $data['detalle'] = $this->inventario_model->consulta_ejecutando_join($tabla, $campos_pdf, $join_pdf, $campo_condicion, $id_movimiento_salida, '-', '-', $join_left);
        $bodega_entrada = $this->inventario_model->bodega_entrada($id_movimiento_entrada);
        $bodega_salida = $this->inventario_model->bodega_salida($id_movimiento_salida);
        $data['cabezera'] = '<table><tr><td>&nbsp;&nbsp;<span style="font-weight:bold;font-size: 1.em;">BODEGA DE PROCEDENCIA:</span><span>' . " " . $bodega_salida[0]['bod_nombre'] . '</span><br>
   <span style="font-weight:bold;font-size: 1.em;">BODEGA DESTINO:</span><span>' . " " . $bodega_entrada[0]['bod_nombre'] . '</span><br>
  <span style="font-weight:bold;font-size: 1.em;">FECHA DE MOVIMIENTO:</span><span>' . " " . date('d/m/Y', strtotime($bodega_entrada[0]['moi_fecha_mov'])) . '</span><br></td></tr></table>';
        $this->pdf->reportePDF('inventario/boleta_traslado/generar_pdf', $data, 'Traslado');
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}

?>