<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Agregar_articulos2 extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('consultas');
		$this->load->model('gsatelite');
		$this->load->model('inventario_model');
		$this->load->library('grocery_CRUD');
        
        if(ob_get_contents()) ob_end_clean();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}
  


 public function add_articulos()
	{
		
		$objeto_crud = new grocery_CRUD;
		$objeto_crud->set_table('art_articulo');
		$objeto_crud->set_relation('art_id_tia','tia_tipo_articulos','tia_nombre');
		$objeto_crud->set_relation('art_id_uni','uni_unidad_medida','uni_nombre');

		$objeto_crud->add_fields('art_nombre','art_codigo','art_minimo','art_maximo','art_id_tia','art_id_uni');
		$objeto_crud->columns('art_codigo','art_id_uni','art_id_tia','art_nombre');
		$objeto_crud->display_as('art_id_tia','Específico');
		$objeto_crud->display_as('art_nombre','Nombre del articulo');
		$objeto_crud->display_as('art_minimo','Cantidad minima del articulo');
		$objeto_crud->display_as('art_maximo','Cantidad maxima del articulo');
		$objeto_crud->display_as('art_id_uni','Unidad de articulo');

		$objeto_crud->set_rules('art_nombre','Nombre del articulo','required');
		$objeto_crud->set_rules('art_codigo','Codigo del articulo','required');
		$objeto_crud->set_rules('art_minimo','Cantidad minima del articulo','required||integer');
		$objeto_crud->set_rules('art_maximo','Cantidad maxima del articulo','required||integer');
		$objeto_crud->set_rules('art_id_tia','Específico','required');
		$objeto_crud->set_rules('art_id_uni','Unidad de medida del articulo','required');
		$objeto_crud->unset_delete();
		$output = $objeto_crud -> render();
		$this->_cargarvista(null,$output);
 }
	
	function get_tipocaracteristica($idart, $cxr_id, $correlativo, $correlativo2){
		/*$idart = $this->input->post('idart');		
		$cxr_id = $this->input->post('cxr_id');*/

		$tipo_car = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id'=>$cxr_id, 'cxr_estado' => 1));
		//print_r($tipo_car); die();
		$idcar = $tipo_car[0]['cxr_id_car'];
		//print_r($tipo_car); die();

		/*$this->join->('','');
		$tidato_car = $this->gsatelite->get_tabla('car_caracteristica',array('car_id'=> $idcar));*/
		$this->db->join('cxr_caractxtipo_articulo','cxu_id_cxr = cxr_id');
		$tidato_car = $this->gsatelite->get_tabla('cxu_caracxarticulo',array('cxr_id'=> $cxr_id, 'cxu_id_art'=> $idart, 'cxu_estado' => 1));
		//print_r($tidato_car); die();	
		$cxu_id = $tidato_car[0]['cxu_id'];
		if(!empty($tidato_car[0]['cxu_valor'])){
			$tipo_car = 9;
		}else{
			$tidato_car = $this->inventario_model->get_caracteristicas($idcar);	
			$tipo_car = $tidato_car[0]['car_tipo'];
		}
		//print_r($tipo_car); die();
		$html = "";
		$tip = "";
		$param_decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $decimales 	  = ($param_decimales != '')?$param_decimales:2;
		switch ($tipo_car) {
			case 1://Lista multiple				
				$html .= '<select id="1" multiple class="valorprin_'.$idart.$correlativo.'_'.$correlativo2.' aplicar_select valorCaracteristica" corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';				
				foreach ($tidato_car as $key => $value) {
					$html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
				}
				$html .= '</select>';
				$tip = 1;				
				break;
			case 2://Lista desplegable							
				$html .= '<select id="2" onchange=\'var p = $("option:selected",this).data("precio");if(p > 0) {crear_alerta("info", "Caracteristica con Precio", "Precio de la caracteristica: $"+p); $("#btn_aliinar_x'.$correlativo.'").attr("preciocara",p);}\' class="xprecio xprecio_'.$correlativo2.' valorCaracteristica valorprin_'.$idart.$correlativo.'_'.$correlativo2.' aplicar_select" placeholder="Seleccione" corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';
				$html .= '<option value></option>';
				foreach ($tidato_car as $key => $value) {
					$html .= '<option data-precio="'.number_format($value['vrl_precio_valor'],$decimales,'.','').'" data-row="'.$correlativo2.'" estado="0"  value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
				}
				$html .= '</select>';
				$tip = 2;
				break;
			case 3://Numerico
				$html .= '<input id="3" type="text" value="" class="valorprin_'.$idart.$correlativo.'_'.$correlativo2.' valorCaracteristica soloNumeros aplicar_select" corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';
				$tip = 3;
				break;
			case 4://Decimal
				$html .= '<input id="4" type="text" value="" class="valorprin_'.$idart.$correlativo.'_'.$correlativo2.' valorCaracteristica soloDecimales aplicar_select" corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';
				$tip = 4;
				break;
			case 5://Texto
				$html .= '<input id="5" type="text" value="" class="valorprin_'.$idart.$correlativo.'_'.$correlativo2.' valorCaracteristica aplicar_select" corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';
				$tip = 5;
				break;
			case 6://Checkbox
				//$html .= '<input id="6" type="checkbox" class="valorprin nostyle ibuttonCheck ibutton">';
				$html .= '<input type="checkbox" id="6"  class="valorprin_'.$idart.$correlativo.'_'.$correlativo2.' valorCaracteristica nostyle ibuttonCheck ibutton aplicar_select" corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';
				$tip = 6;
				break;				
			default: //'.$tidato_car[0]['cxu_valor'].'
				//$html .= '<input id="9" type="text" value="" class="valorprin_'.$idart.$correlativo.'_'.$correlativo2.' valorCaracteristica aplicar_select" readonly corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';
				$html .= '<input id="9" type="text" value="" class="valorprin_'.$idart.$correlativo.'_'.$correlativo2.' valorCaracteristica aplicar_select" readonly corr="'.$correlativo.'" correlativo = "'.$correlativo2.'" producto="'.$idart.'" cxu="'.$cxu_id.'">';
				$tip = 9;
				break;
		}
		//print_r($html); die();
		$arreglo = array('tag' => $html, 'tipo' => $tip);
        return $arreglo;
		//return $html;
	}
	
	function get_tipocaracteristica2(){
		$idart = $this->input->post('idart');		
		$cxr_id = $this->input->post('cxr_id');
		$correlativo = $this->input->post('correlativo');
		$tipo_car = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id'=>$cxr_id, 'cxr_estado' => 1));
		//print_r($tipo_car); die();
		$idcar = $tipo_car[0]['cxr_id_car'];
		//print_r($tipo_car); die();

		/*$this->join->('','');
		$tidato_car = $this->gsatelite->get_tabla('car_caracteristica',array('car_id'=> $idcar));*/
		$this->db->join('cxr_caractxtipo_articulo','cxu_id_cxr = cxr_id');
		$tidato_car = $this->gsatelite->get_tabla('cxu_caracxarticulo',array('cxr_id'=> $cxr_id, 'cxu_id_art'=> $idart, 'cxu_estado' => 1));
		//print_r($tidato_car); die();
		if(!empty($tidato_car[0]['cxu_valor'])){
			$tipo_car = 9;
			
		}else{
			$tidato_car = $this->inventario_model->get_caracteristicas($idcar);	
			$tipo_car = $tidato_car[0]['car_tipo'];
		}
		//print_r($tipo_car); die();
		$html = "";
		$tip = "";
		$param_decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $decimales 	  = ($param_decimales != '')?$param_decimales:2;
		switch ($tipo_car) {
			case 1://Lista multiple				
				$html .= '<select id="1_'.$correlativo.'" multiple class="valorprin_'.$idart.'_'.$correlativo.'">';				
				foreach ($tidato_car as $key => $value) {
					$html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
				}
				$html .= '</select>';
				$tip = 1;				
				break;
			case 2://Lista desplegable							
				$html .= '<select id="2_'.$correlativo.'" class="valorCaracteristica valorprin_'.$idart.'_'.$correlativo.'" placeholder="Seleccione">';
				$html .= '<option value></option>';
				foreach ($tidato_car as $key => $value) {
					$html .= '<option data-prices="'.number_format($value['vrl_precio_valor'],$decimales,'.','').'" data-row="'.$correlativo.'" value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
				}
				$html .= '</select>';
				$tip = 2;
				break;
			case 3://Numerico
				$html .= '<input id="3_'.$correlativo.'" type="text" value="" class="valorprin_'.$idart.'_'.$correlativo.' valorCaracteristica soloNumeros">';
				$tip = 3;
				break;
			case 4://Decimal
				$html .= '<input id="4_'.$correlativo.'" type="text" value="" class="valorprin_'.$idart.'_'.$correlativo.' valorCaracteristica soloDecimales">';
				$tip = 4;
				break;
			case 5://Texto
				$html .= '<input id="5_'.$correlativo.'" type="text" value="" class="valorprin_'.$idart.'_'.$correlativo.' valorCaracteristica">';
				$tip = 5;
				break;
			case 6://Checkbox
				//$html .= '<input id="6" type="checkbox" class="valorprin nostyle ibuttonCheck ibutton">';
				$html .= '<input type="checkbox" id="6_'.$correlativo.'"  class="valorprin_'.$idart.'_'.$correlativo.' valorCaracteristica nostyle ibuttonCheck ibutton" >';
				$tip = 6;
				break;				
			default:
				$price =$this->inventario_model->get_caracteristica_precio(array('cxr_id' => $tidato_car[0]['cxu_id_cxr'],'vrl_valor' => $tidato_car[0]['cxu_valor']));
				$html .= '<input id="9_'.$correlativo.'" data-prices="'.number_format($price->vrl_precio_valor,$decimales,'.','').'" type="text" value="'.str_replace('"', '”', $tidato_car[0]['cxu_valor']).'" class="valorprin_'.$idart.'_'.$correlativo.' valorCaracteristica" readonly>';
				$tip = 9;
				break;
		}		
		//print_r($html); die();
		$arreglo = array('tag' => $html, 'tipo' => $tip);
        echo json_encode($arreglo);
		//return $html;
	}
	
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */