﻿<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Agregar_articulos extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('consultas');
		$this->load->model('gsatelite');
		$this->load->model('inventario_model');
		$this->load->library('grocery_CRUD');
        
        if(ob_get_contents()) ob_end_clean();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}
  


 public function add_articulos()
	{
		
		$objeto_crud = new grocery_CRUD;
		$objeto_crud->set_table('art_articulo');
		$objeto_crud->set_relation('art_id_tia','tia_tipo_articulos','tia_nombre');
		$objeto_crud->set_relation('art_id_uni','uni_unidad_medida','uni_nombre');

		$objeto_crud->add_fields('art_nombre','art_codigo','art_minimo','art_maximo','art_id_tia','art_id_uni');
		$objeto_crud->columns('art_codigo','art_id_uni','art_id_tia','art_nombre');
		$objeto_crud->display_as('art_id_tia','Específico');
		$objeto_crud->display_as('art_nombre','Nombre del articulo');
		$objeto_crud->display_as('art_minimo','Cantidad minima del articulo');
		$objeto_crud->display_as('art_maximo','Cantidad maxima del articulo');
		$objeto_crud->display_as('art_id_uni','Unidad de articulo');

		$objeto_crud->set_rules('art_nombre','Nombre del articulo','required');
		$objeto_crud->set_rules('art_codigo','Codigo del articulo','required');
		$objeto_crud->set_rules('art_minimo','Cantidad minima del articulo','required||integer');
		$objeto_crud->set_rules('art_maximo','Cantidad maxima del articulo','required||integer');
		$objeto_crud->set_rules('art_id_tia','Específico','required');
		$objeto_crud->set_rules('art_id_uni','Unidad de medida del articulo','required');
		$objeto_crud->unset_delete();
		$output = $objeto_crud -> render();
		$this->_cargarvista(null,$output);
 }
	
	function get_tipocaracteristica(){
		$idart = $this->input->post('idart');		
		$cxr_id = $this->input->post('cxr_id');

		$tipo_car = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id'=>$cxr_id, 'cxr_estado' => 1));
		$idcar = $tipo_car[0]['cxr_id_car'];
		$this->db->join('cxr_caractxtipo_articulo','cxu_id_cxr = cxr_id');
		$tidato_car = $this->gsatelite->get_tabla('cxu_caracxarticulo',array('cxr_id'=> $cxr_id, 'cxu_id_art'=> $idart, 'cxu_estado' => 1));
		if(!empty($tidato_car[0]['cxu_valor'])){
			$tipo_car = 9;
		}else{
			$tidato_car = $this->inventario_model->get_caracteristicas($idcar);	
			$tipo_car = $tidato_car[0]['car_tipo'];
		}
		$html = "";
		$tip = "";
		switch ($tipo_car) {
			case 1://Lista multiple				
				$html .= '<select id="1" multiple class="lista valorCaracteristica valorprin_'.$idart.'">';				
				foreach ($tidato_car as $key => $value) {
					$html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
				}
				$html .= '</select>';
				$tip = 1;				
				break;
			case 2://Lista desplegable							
				$html .= '<select id="2" class="lista valorCaracteristica valorprin_'.$idart.'" placeholder="Seleccione">';
				$html .= '<option value></option>';
				foreach ($tidato_car as $key => $value) {
					$html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
				}
				$html .= '</select>';
				$tip = 2;
				break;
			case 3://Numerico
				$html .= '<input id="3" type="text" value="" class="valorprin_'.$idart.' valorCaracteristica soloNumeros">';
				$tip = 3;
				break;
			case 4://Decimal
				$html .= '<input id="4" type="text" value="" class="valorprin_'.$idart.' valorCaracteristica soloDecimales">';
				$tip = 4;
				break;
			case 5://Texto
				// $html .= '<input id="5" type="text" value="" class="valorprin_'.$idart.' valorCaracteristica">';
				$html .= '<textarea id="5" type="text" class="valorprin_' . $idart . ' valorCaracteristica"></textarea>';
				$tip = 5;
				break;
			case 6://Checkbox
				//$html .= '<input id="6" type="checkbox" class="valorprin nostyle ibuttonCheck ibutton">';
				$html .= '<input type="checkbox" id="6"  class="valorprin_'.$idart.' valorCaracteristica nostyle ibuttonCheck ibutton" >';
				$tip = 6;
				break;				
			default:
				$html .= '<textarea id="9" type="text" class="valorprin_'.$idart.' valorCaracteristica"></textarea>';
				$tip = 9;
				break;
		}
		//print_r($html); die();
		$arreglo = array('tag' => $html, 'tipo' => $tip);
        echo json_encode($arreglo);
		//return $html;
	}

	function get_caracteristicas_edit(){
		$id_art = $this->input->post('id_art');
		$cxr_id = $this->input->post('cxr_id');
		$where = array(
			'cxr_id' => $cxr_id, 
			'cxu_id_art' => $id_art
		);
		$datos_car = $this->inventario_model->get_datos_caracteristicas($where);
		$car_tipo = $datos_car[0]['car_tipo'];
		$html = "";
		$tip = "";
		if (count($datos_car) > 0) {			
			switch ($car_tipo) {
				case 1://Lista multiple				
					$html .= '<select id="1" multiple class="lista valorCaracteristica valorprin_'.$id_art.'">';
					$valores = explode(',', $datos_car[0]['cxu_valor']);	
					foreach ($datos_car as $key => $value) {
						if (in_array($value['vrl_valor'], $valores)) {
							$html .= '<option value="'.$value['vrl_id'].'" selected>'.$value['vrl_valor'].'</option>';
						} else {
							$html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
						}						
					}
					$html .= '</select>';
					$tip = 1;				
					break;
				case 2://Lista desplegable							
					$html .= '<select id="2" class="valorCaracteristica lista valorprin_'.$id_art.'" placeholder="Seleccione">';
					$html .= '<option value=""></option>';
					foreach ($datos_car as $key => $value) {
						if ($value['cxu_valor'] == $value['vrl_valor']) {
							$html .= '<option value="'.$value['vrl_id'].'" selected>'.$value['vrl_valor'].'</option>';
						} else {
							$html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
						}
					}
					$html .= '</select>';
					$tip = 2;
					break;
				case 3://Numerico
					$html .= '<input id="3" type="text" value="' . $datos_car[0]['cxu_valor'] . '" class="valorprin_'.$id_art.' valorCaracteristica soloNumeros">';
					$tip = 3;
					break;
				case 4://Decimal
					$html .= '<input id="4" type="text" value="' . $datos_car[0]['cxu_valor'] . '" class="valorprin_'.$id_art.' valorCaracteristica soloDecimales">';
					$tip = 4;
					break;
				case 5://Texto
					$html .= '<textarea id="5" type="text" class="valorprin_' . $id_art . ' valorCaracteristica">' . $datos_car[0]['cxu_valor'] . '</textarea>';
					$tip = 5;
					break;
				case 6://Checkbox
					$checked = ($datos_car[0]['cxu_valor'] == 'Si') ? 'checked' : '';
					$html .= '<input type="checkbox" id="6" ' . $checked . ' class="valorprin_' . $id_art . ' valorCaracteristica nostyle ibuttonCheck ibutton" >';
					$tip = 6;
					break;				
				default:
					$html .= '<textarea id="9" type="text" class="valorprin_'.$id_art.' valorCaracteristica">' . $datos_car[0]['cxu_valor'] . '</textarea>';
					$tip = 9;
					break;
			}
		}
		$arreglo = array('tag' => $html, 'tipo' => $tip);
        echo json_encode($arreglo);
	}
	
	
	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */