<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Inicio extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('cotizaciones_model');
        $this->load->model('tarificador_model');
        $this->load->model('gsatelite');
        //$this->load->library('detNavegador');
    }

    function index() {       

        $landing_page = $this->gsatelite->get_parametro_emp("SYS-ACTIVA-LANDING-PAGE")??0;
        /*
          $nav = new detNavegador();
          $navegador = ($nav->miNavegador());
          $bits = $navegador['bits'];
          $nombre_navegador = $navegador['nav_tipo'];
          $version_navegador = explode('.',$navegador['version']);
          $version_navegador = $version_navegador[0] . $bits;
          //$sistema_operativo = $navegador['sistema_op'];

          if ($nombre_navegador == "MSIE")
          {
          if (($version_navegador == 8) || ($version_navegador == 9))
          {

          }
          }
          print_r($nombre_navegador);
          exit();
         */
            
        if ($this->session->userdata('menu_modulo') != '') {
            $this->session->set_userdata('menu_modulo', '');
            $this->session->unset_userdata('menu_modulo');
        }

        if (!$this->tank_auth->is_logged_in()) {
            
            if ($landing_page) {
                redirect('/auth/landin/');
            }else{
                redirect('/auth/login/');
            }

        }else{
            ///INICIO verificar si el usuario posee sucursal///

            $alert_inicial  = null;
            $usuario        = $this->tank_auth->get_user_id();
            $sucursales     = $this->gsatelite->count('usc_usuario_sucursal', array('usc_id_usu' => $usuario) );
            if ( $sucursales == 0) {
                $sucursal = $this->gsatelite->get_campo('emp_empleado', 'emp_id_suc', array('emp_id_usu' => $usuario) );
                if ( $sucursal != "") {
                    $usc_usuario_sucursal = array(
                        'usc_id_suc'            => $sucursal,
                        'usc_id_usu'            => $usuario,
                        'usc_defecto'           => 1,
                        'usc_estado'            => 1,
                        'usc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'usc_fecha_creacion'    => date('Y-m-d h:i:s'),
                        'usc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'usc_fecha_modificacion'=> date('Y-m-d h:i:s')                   
                    );
                    $this->gsatelite->ingresar('usc_usuario_sucursal', $usc_usuario_sucursal);
                }
            }
            //FIN verificar si el usuario posee sucursal///

            $cotizaciones = $this->cotizaciones_model->obtener_cotizaciones();
            foreach ($cotizaciones as $key => $value) {
                $dias_seg = $this->gsatelite->get_intervalo_dias($value['cot_ult_fecha_cont'], date('Y-m-d H:i:s'));
                $dias_par = $this->gsatelite->get_parametro('INTERVALO_FECHA_ENVIO');
                if ($dias_seg >= $dias_par && date('Y-m-d') > $this->gsatelite->get_parametro('FECHA_ENVIO_CORREO')) {
                    //$this->send_email($value['ven_email']);
                    $this->db->where('par_codigo', 'FECHA_ENVIO_CORREO');
                    $this->db->update('par_parametro', array('par_valor' => date('Y-m-d')));
                }
            }

            $verificacion = $this->gsatelite->get_parametro('FECHA_VERIFICACION_TARIFA', null, true);

            if ($verificacion->par_valor == date('Y-m-d') && $verificacion->par_default == 0) {

                $this->db->where('par_codigo', 'FECHA_VERIFICACION_TARIFA');
                $this->db->update('par_parametro', array('par_default' => 1));


                $where = "DATE(trf_hasta) < '" . date('Y-m-d') . "' AND trf_estado = 1";
                $tarifas = $this->tarificador_model->get_listado_tarifas($where);

                $actualizar = array();

                foreach ($tarifas as $trf) {
                    $trf['trf_estado'] = 0;

                    $actualizar[] = $trf;
                }

                if (count($actualizar) > 0 && $actualizar != null) {
                    $this->db->update_batch('trf_tarifa', $actualizar, 'trf_id');
                }

                $this->db->where('par_codigo', 'FECHA_VERIFICACION_TARIFA');
                $this->db->update('par_parametro', array('par_default' => 0, 'par_valor' => date('Y-m-d', strtotime(' + 1 day '))));
            }
            $data = $this->masterpage->getUsuario();
            $data['alert_inicial'] = $alert_inicial;               
        
            $this->masterpage->setMasterPage('masterpage_default');
            $this->masterpage->addContentPage('welcome', 'content', $data);
            $this->masterpage->show();
        }
    }

    public function send_email($email) {
        $ci = get_instance();
        $ci->load->library('email');
        $config['protocol'] = "smtp";
        $config['smtp_host'] = "ssl://mail.gruposatelite.net";
        $config['smtp_port'] = "465";
        $config['smtp_user'] = $this->gsatelite->get_parametro('CORREO_ADMIN');
        $config['smtp_pass'] = "Nuevo1010";
        $config['charset'] = "utf-8";
        $config['mailtype'] = "html";
        $config['newline'] = "\r\n";

        $ci->email->initialize($config);

        $ci->email->from($this->gsatelite->get_parametro('CORREO_ADMIN'), $this->gsatelite->get_parametro('CORREO_ADMIN'));
        $list = array($email);
        $ci->email->to($list);
        $this->email->reply_to($this->gsatelite->get_parametro('CORREO_ADMIN'), '');
        $ci->email->subject('Cotizaciones pendientes');
        $ci->email->message('Estimado usuario usted tiene una o varias cotizaciones pendiente de dar seguimiento.');
        $ci->email->send();
    }

    public function guardar_gral($parametros, $carpeta = null, $mimes = null) {
        $carpeta = $parametros;
        //var_dump($mimes);
        if ($mimes != null) {
            $mimes = str_replace('-', '|', $mimes);
            $image = $this->upload_gral($carpeta, $mimes);
        } else {
            $image = $this->upload_gral($carpeta);
        }
        //$this->session->keep_flashdata('datos_1');
        //echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        echo $image['upload_data']['file_name'];
    }

    function upload_gral($carpeta, $mimes = null) {
        $ruta = FCPATH . "public/temp/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        if ($mimes != null) {
            $config['allowed_types'] = $mimes;
        } else {
            $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx|zip|rar|txt';
        }

        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    function mover_img_gral($ruta, $destino, $archivo) {
        if (is_dir($ruta)) {
            if (copy($ruta . '/' . $archivo, $destino . '/' . $archivo)) {
                return unlink($ruta . '/' . $archivo);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function eliminar_imagen_gral($carpeta = "", $ruta = null) {

        $url = $this->input->post("url");
        //echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";
        if ($ruta != null) {
            $ruta = (substr_count($ruta, "____") > 0)? "./".str_replace(array('____',"./"), array("/",""), $ruta):$ruta;
            unlink("$ruta/$carp/" . $url);
        } else {
            unlink("./public/temp/$carp/" . $url);
        }
    }

    function imprimirError() {
        $this->load->library('pdf');
        $texto = $this->input->post('textoError');
        $url = $this->input->post('urlError');
        $texto = substr($texto, strpos($texto, '<div id="container">'));
        $this->pdf->SetAuthor('Grupo Satelite');
        $html_header = $this->load->view("reporte/header", array('titulo' => "Error<br>URL: $url "), true);
        $this->pdf->makePDF($html_header . $texto, "I", "ReporteError");
        die();
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */