<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Reportes extends CI_Controller{

	function __construct(){
		parent::__construct();
		$this->load->model('tarificador_model');
		$this->load->model('facturacion_model');
		$this->load->library('pdf');
		$this->load->library('excel/excel_reader.php');
	}

	function index(){
		if(!$this->tank_auth->is_logged_in()){
			redirect('/auth/login/');
		}
		else{
			$data['titulo_personal']='Tarificador';
			$this->_cargarvista();
		}
	}

	/**
	 *@author Nelson Soriano
	 *@since  18-01-2019
	 *@param  none
	 *@return Vista con los controles para la busqueda del reporte
	**/

	public function facturas_anuladas(){
		satelite_validar();
		if (!$this->tank_auth->is_logged_in()){redirect('/auth/login/');}
		$data['titulo_personal'] 		= 'Reporte de Facturas Anuladas';
		$sucursales_option				= $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre} - {suc_codigo}', 'sucursales', null, null, null, null, true);
		$t_facturas_option              = $this->gsatelite->get_dropdown('tif_tipo_factura','{tif_nombre} - {tif_abreviacion}','tipos',array('tif_estado' => 1),null,null,null,true);
		$data['sucursales'] 			= str_replace('﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿<option value="0">Seleccione</option>', '', $sucursales_option); 
		$data['tipo_factura']           = str_replace('﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿﻿<option value="0">Seleccione</option>', '', $t_facturas_option);
		$data['permisos']               = $this->gsatelite->get_permisos_opcion('facturacion/reportes/facturas_anuladas');
		$this->_cargarvista($data);
	}

	/**
	 *@author Nelson Soriano
	 *@since  18-01-2019
	 *@param  fecha de inicio y finalizacion de la consulta, tipo de factura y sucursal de consulta
	 *@return Reporte de facturas anuladas
	**/

	public function mostrar_facturas_anuladas($reporte = 0){
		satelite_validar();
		// var_dump($_POST);die();
		$tipoFiltro   = $this->input->post('tipo_filtro');
		$desde    	  = $this->input->post('txtFecha_desde');
		$hasta        = $this->input->post('txtFecha_hasta');
		$sucursal     = $this->input->post('slcSucursales');
		$tipoFactura  = $this->input->post('slcTipoFactura');
		$param1       = '';
		$param2		  = '';
		$where = array('fac_estado' => 0);
		switch ($tipoFiltro) {
			case 'fac_fecha_fact':
				if ($desde != '' && $hasta != '') {
					$where['DATE(fac_fecha_fact) >= '] = formatear_fecha('Y-m-d', $desde);
					$where['DATE(fac_fecha_fact) <= '] = formatear_fecha('Y-m-d', $hasta);
				}
			break;
			case 'fac_fecha_cont':
				if ($desde != '' && $hasta != '') {
					$where['DATE(fac_fecha_cont) >= '] = formatear_fecha('Y-m-d', $desde);
					$where['DATE(fac_fecha_cont) <= '] = formatear_fecha('Y-m-d', $hasta);
				}
			break;    			
			default:
				// fac_fecha_anulacion
				if ($desde != '' && $hasta != '') {
					$where['DATE(fac_fecha_anulacion) >= '] = formatear_fecha('Y-m-d', $desde);
					$where['DATE(fac_fecha_anulacion) <= '] = formatear_fecha('Y-m-d', $hasta);
				}
			break;
		}

		if ($sucursal != '') {
			$where['fac_id_suc']  = $sucursal;
			$param1 = 'Sucursal: '.$this->gsatelite->get_campo('suc_sucursal','suc_nombre',array('suc_id' => $sucursal));
		}

		if ($tipoFactura != '') {
			$where['fac_id_tif']  = $tipoFactura;
			$param2 = 'Tipo de Factura: '. $this->gsatelite->get_campo('tif_tipo_factura','tif_nombre',array('tif_id' => $tipoFactura));
		}
		$datos                    = $this->facturacion_model->obtener_facturas_anuladas($where);
		$data['es_reporte']       = $reporte;
		$data['txtFecha_desde']   = $desde;
		$data['txtFecha_hasta']   = $hasta;
		$data['tipoFiltro']   	  = $tipoFiltro;
		$data['tipo']             = $tipoFactura;
		$data['sucursal']         = $sucursal;
		$data['periodo']          = date_format(date_create($desde), 'd-m-Y') . ' A ' . date_format(date_create($hasta), 'd-m-Y');
		$data['registros']        = $datos;
		$tipo_accion              = $this->input->post('tipo_accion');
		$data['accion'] 		  = $tipo_accion;
		$html 					  = $this->load->view('facturacion/reportes/mostrar_facturas_anuladas',$data,true);
		if ($reporte) {
			$filtro_titulo = ($desde==$hasta)? "De: ".date_format(date_create($desde), 'd-m-Y').'<br>'.$param1.'<br>'.$param2:"De: ".$data['periodo'].'<br>'.$param1.'<br>'.$param2.'<br>';
            if ($tipo_accion) { //excel
            	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            	header("Content-Disposition: attachment;filename=Facturas anuladas".date('d-m-Y_His').".xls");
            	header("Pragma: no-cache");
            	header("Expires: 0");
            	echo '<meta charset="utf-8" />';
            	echo "<table border='0'>
            	<tr><th colspan='6' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
            	<tr><th colspan='6' align='center' >Facturas Anuladas</th></tr>
            	<tr><th colspan='6' align='center' >".$filtro_titulo. "</th></tr>
            	</table>";
            	echo $html; die();
            } else { 
            	$this->load->library('pdf');
            	$html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Facturas Anuladas <br /> $filtro_titulo", 'solotitulo'=> true), true);
            	$html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
            	$this->pdf->makePDF($html_header.$html,'lanscape', 'Facturas_anuladas','Legal');
            	die();
            }
        }
        echo json_encode(array('html'=>$html));
    }

    //HISTORIAL FACTURACIÓN
    function historial_factura(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {

    		$listado_factura = $this->facturacion_model->reporte_historial_facturacion();

			//$data['listado_factura'] = $listado_factura;
								//$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
								//$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
    		$data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '', 'cli_id', true);

    		$data["titulo_personal"] ="Historial de facturación";

    		$this->_cargarvista($data);
    	}
    }

    public function consultar_historial_factura($return=null){

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado_factura = $this->facturacion_model->reporte_historial_facturacion($cliente,$fecha_ini,$fecha_fin);

    	$cadena="";

    	foreach ($listado_factura as $key => $fac) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$fac['producto']."</td>";
    		$cadena.="<td>".$fac['factura']."</td>";
    		$cadena.="<td>".$fac['fecha_inicio']."</td>";
    		$cadena.="<td>".$fac['fecha_fin']."</td>";
    		$cadena.="<td>".number_format($fac['total'],2)."</td>";
    		$cadena.="<td>".$fac['estado']."</td>";
    		$cadena.="<td>".$fac['plan']."</td>";
    		$cadena.="<td>".$fac['fecha_pago']."</td>";
    		$cadena.="<td>".$fac['correlativo']."</td>";
    		$cadena.='</tr>';
    	}

    	if (!empty($listado_factura)){
    		$arreglo=array('drop'=>$cadena);
    	}
    	else {
    		$arreglo=array('drop'=>"<tr><td colspan='9'>No existen datos</td></tr>");
    	}

    	if($return!=null){
    		return $arreglo;
    	}
    	else{

    	}
    	$data['listado_factura'] = $listado_factura;
    	$info = $this->load->view('facturacion/reportes/consulta_historial_factura', $data, true);
    	$arreglo = array('drop' => $info);
    	echo json_encode($arreglo);
    }

    public function reporte_historial_factura($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_inicio')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_inicio'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado_factura = $this->facturacion_model->reporte_historial_facturacion($cliente,$fecha_ini,$fecha_fin);

    	$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Historial de Facturación"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Producto</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Factura</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha inicio</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha fin</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Estado</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Plan de Pago</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha de pago</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Correlativo de pago</th>';
    	$cadena.='</tr>';

    	foreach ($listado_factura as $fac) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$fac['producto']."</td>";
    		$cadena.="<td>".$fac['factura']."</td>";
    		$cadena.="<td>".$fac['fecha_inicio']."</td>";
    		$cadena.="<td>".$fac['fecha_fin']."</td>";
    		$cadena.="<td>".number_format($fac['total'],2)."</td>";
    		$cadena.="<td>".$fac['estado']."</td>";
    		$cadena.="<td>".$fac['plan']."</td>";
    		$cadena.="<td>".$fac['fecha_pago']."</td>";
    		$cadena.="<td>".$fac['correlativo']."</td>";
    		$cadena.="</tr>";
    	}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;

    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data);
    	}
    	else if($tipo==2){
    		$data['table_header']     = "HISTORIAL DE FACTURACIÓN";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    //HISTORIAL FACTURACIÓN
    function pagos(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {

		//	$listado_pagos = $this->facturacion_model->reporte_pagos();

		//	$data['listado_pagos'] = $listado_pagos;
								//$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
								//$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
    		$data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '', 'cli_id', true);

    		$data["titulo_personal"] ="Reporte de Pagos";

    		$this->_cargarvista($data);
    	}
    }

    public function consultar_pagos($return=null){

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}
    	$listado_pagos = $this->facturacion_model->reporte_pagos($cliente,$fecha_ini,$fecha_fin);

    	$cadena="";

    	foreach ($listado_pagos as $key => $fac) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$fac['codigo_cliente']."</td>";
    		$cadena.="<td>".$fac['nombre']."</td>";
    		$cadena.="<td>".$fac['NIT']."</td>";
    		$cadena.="<td>".$fac['registro']."</td>";
    		$cadena.="<td>".$fac['factura']."</td>";
    		$cadena.="<td>".$fac['fecha_inicio_factura']."</td>";
    		$cadena.="<td>".$fac['fecha_fin_factura']."</td>";
    		$cadena.="<td>".$fac['fecha_vencimiento']."</td>";
    		$cadena.="<td>".$fac['correlativo_recibo']."</td>";
    		$cadena.="<td>".date('d/m/Y', strtotime($fac['fecha_pago']))."</td>";
    		$cadena.="<td>".number_format($fac['total_cancelado'],2)."</td>";
    		$cadena.='</tr>';
    	}

    	if (!empty($listado_pagos)){
    		$arreglo=array('drop'=>$cadena);
    	}
    	else {
    		$arreglo=array('drop'=>"<tr><td colspan='11'>No existen datos</td></tr>");
    	}

    	if($return!=null){
    		return $arreglo;
    	}
    	else{

    	}
    	$data['listado_pagos'] =$listado_pagos;
    	$info=$this->load->view('facturacion/reportes/consulta_reporte_pagos', $data, true);
    	$arreglo=array('drop'=>$info);
    	echo json_encode($arreglo);
    }

    public function reporte_pagos($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado_pagos = $this->facturacion_model->reporte_pagos($cliente,$fecha_ini,$fecha_fin);

    	$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "pagos"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Código Cliente</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">NIT</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Registro</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Factura</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha inicio</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha fin</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha vencimiento</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Correlativo recibo</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha Pago</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total cancelado</th>';
    	$cadena.='</tr>';

    	foreach ($listado_pagos as $fac) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$fac['codigo_cliente']."</td>";
    		$cadena.="<td>".$fac['nombre']."</td>";
    		$cadena.="<td>".$fac['NIT']."</td>";
    		$cadena.="<td>".$fac['registro']."</td>";
    		$cadena.="<td>".$fac['factura']."</td>";
    		$cadena.="<td>".$fac['fecha_inicio_factura']."</td>";
    		$cadena.="<td>".$fac['fecha_fin_factura']."</td>";
    		$cadena.="<td>".$fac['fecha_vencimiento']."</td>";
    		$cadena.="<td>".$fac['correlativo_recibo']."</td>";
    		$cadena.="<td>".date('d/m/Y',strtotime($fac['fecha_pago']))."</td>";
    		$cadena.="<td>".number_format($fac['total_cancelado'],2)."</td>";
    		$cadena.='</tr>';
    	}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;

    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data);
    	}
    	else if($tipo==2){
    		$data['table_header']     = "Historial de facturación";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    //REPORTE FACTURACIÓN
    function facturas(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {

    		$listado_facturas = $this->facturacion_model->reporte_facturas();

    		$data['listado_facturas'] = $listado_facturas;
								//$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
								//$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
    		$cli = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '', 'cli_id', true);
    		$data["clientes"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>',$cli);

    		$data["titulo_personal"] ="Reporte de Facturas";

    		$this->_cargarvista($data);
    	}
    }

    public function consultar_facturas($return=null){

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	$post_estado=$this->input->post('estado');
    	if($post_estado!=''){
    		$estado=$post_estado;
    	}else{
    		$estado=5;
    	};


    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

		//$cliente_serv=$this->gsatelite->get_tabla('sxc_servicioxcliente', array('sxc_id_cli'=>$cliente)); //Verificamos si el cliente está asociado a un sevicio (módulo tarificador).

    	$cliente_serv=$this->gsatelite->get_tabla('fac_factura', array('fac_id_cli'=>$cliente, 'fac_tipo'=>2, 'date_format(fac_fecha_crea,"%Y-%m-%d") >='=>$fecha_ini, 'date_format(fac_fecha_crea,"%Y-%m-%d") <='=>$fecha_fin));
    	$cliente_art=$this->gsatelite->get_tabla('fac_factura', array('fac_id_cli'=>$cliente, 'fac_tipo'=>1, 'date_format(fac_fecha_crea,"%Y-%m-%d") >='=>$fecha_ini, 'date_format(fac_fecha_crea,"%Y-%m-%d") <='=>$fecha_fin));
		//die(print_r(count($cliente_serv.'/')).print_r(count($cliente_art)));
    	$listado_fac=array();
    	if(count($cliente_serv)>0){
    		$listado_facturas = $this->facturacion_model->reporte_facturas($cliente,$fecha_ini,$fecha_fin, $estado);
    	}


    	if(count($cliente_art)>0){
    		if($estado==3){ $estado=0; }
    		$id_nit=$this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
    		$listado_factura = $this->facturacion_model->reporte_fac($cliente,$fecha_ini,$fecha_fin, $estado, $id_nit);
    	}

    	if(count($listado_facturas)>0 && count($listado_factura)>0){
    		$resultado=array_merge($listado_facturas,$listado_factura);
    	}else if(count($listado_facturas)>0 && count($listado_factura)<=0){
    		$resultado=$listado_facturas;
    	}else if(count($listado_facturas)<=0 && count($listado_factura)>0){
    		$resultado=$listado_factura;
    	}

    	$cadena="";
    	$column=1;
    	$cant=count($cliente_serv);
    	foreach ($resultado as $key => $fac) {

    		if(isset($fac['NIT'])){
    			$nit=$fac['NIT'];
    		}else{
    			if(isset($fac['nit_dcc']) && $fac['nit_dcc'] != ''){
    				$nit=$fac['nit_dcc'];
    			}else{
    				$nit=$fac['nit_dce'];
    			}
    		}
			//die(print_r($fac['fac_tipo'].'/'.$cant));
    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$fac['codigo_cliente']."</td>";
    		$cadena.="<td>".$fac['nombre']."</td>";
    		$cadena.="<td>".$nit."</td>";
    		if($fac['fac_tipo']==2 && $cant>0){
    			$column=2;
    			$cadena.="<td>".$fac['registro']."</td>";
    		}else if($fac['fac_tipo']==1 && $cant>0){
    			$cadena.="<td></td>";
    		}else{

    		}
    		$cadena.="<td>".$fac['tipo_factura']."</td>";
    		$cadena.="<td>".$fac['factura']."</td>";
    		if($fac['fac_tipo']==2 && $cant>0){
    			$cadena.="<td>".$fac['fecha_inicio']."</td>";
    			$cadena.="<td>".$fac['fecha_fin']."</td>";
    			$cadena.="<td>".$fac['fecha_vencimiento']."</td>";
    		}else if($fac['fac_tipo']==1 && $cant>0){
    			$cadena.="<td></td>";
    			$cadena.="<td></td>";
    			$cadena.="<td></td>";
    		}
    		$cadena.="<td>".$fac['Producto']."</td>";
    		if($fac['fac_tipo']==2 && $cant>0){
    			$cadena.="<td>".$fac['minutos_consumidos_fac']."</td>";
    		}else if($fac['fac_tipo']==1 && $cant>0){
    			$cadena.="<td></td>";
    		}
    		$cadena.="<td>".$fac['total_neto']."</td>";
    		$cadena.="<td>".$fac['totalMasIva']."</td>";
    		$cadena.="<td>".$fac['estado']."</td>";
    		$cadena.='</tr>';
    	}

    	if (!empty($resultado)){
    		$arreglo=array('drop'=>$cadena, 'col'=>$column);
    	}
    	else {
    		$arreglo=array('drop'=>"<tr><td colspan='14'>No existen datos</td></tr>");
    	}
		//die(print_r($arreglo));
    	if($return!=null){
    		return $arreglo;
    	}
    	else{
    		echo json_encode($arreglo);
    	}
    }

    public function reporte_facturas($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado_facturas = $this->facturacion_model->reporte_facturas($cliente,$fecha_ini,$fecha_fin);

    	$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "facturas"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Código Cliente</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Nombre</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">NIT</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Registro</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Tipo de Factura</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Factura</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha inicio</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha fin</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha vencimiento</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Producto</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Minutos consumidos</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total Neto</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total + IVA</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Estado</th>';
    	$cadena.='</tr>';

    	foreach ($listado_facturas as $fac) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['codigo_cliente']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['nombre']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['NIT']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['registro']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['tipo_factura']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['factura']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['fecha_inicio']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['fecha_fin']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['fecha_vencimiento']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['Producto']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['minutos_consumidos_fac']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($fac['total_neto'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($fac['totalMasIva'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$fac['estado']."</td>";
    		$cadena.='</tr>';
    	}

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;

    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTES DE FACTURAS";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    function contabilidad(){

    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {
    		$alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Opción fuera de uso", 'texto_alerta' => "El reporte solicitado se encuentra fuera de uso.");
    		$this->session->set_flashdata($alerta);
    		redirect('facturacion/facturar/comprobante_descuento');
								//$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
								//$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
    		$data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '', 'cli_id', true);

    		$data["titulo_personal"] ="Reporte de Contabilidad";

    		$this->_cargarvista($data);
    	}
    }

    public function consultar_contabilidad($return=null){

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$contabilidad = $this->facturacion_model->get_reporte_contabilidad($cliente,$fecha_ini,$fecha_fin);
    	$cadena="";
    	$comprobante = "";
    	$plan = array();
    	foreach ($contabilidad as $key => $con) {

    		$cadena.="<tr>";
    		$cadena.="<td>".$con['src_nombre']."</td>";
    		$cadena.="<td>".$con['factura']."</td>";
    		$cadena.="<td>".number_format($con['subtotal'],2)."</td>";
    		$cadena.="<td>".$con['minutos']."</td>";
    		$cadena.="<td>".$con['iva']."</td>";
    		$cadena.="<td>".number_format($con['total'],2)."</td>";
    		$cadena.="<td>".$con['recibo']."</td>";
    		$cadena.="<td>".$con['fecha_pago']."</td>";
    		$cadena.='</tr>';

    		$comprobante = $con['comprobante'];

    		$plan[] = $con['pln_nombre'];
    	}
    	$data['tabla']=$cadena;
    	$info = $this->load->view('facturacion/reportes/consulta_contabilidad',$data, true);

    	if ($cadena!=''){
    		$arreglo=array('drop'=>$cadena,'comprobante'=>$comprobante,'plan'=>$plan);
    	}
    	else {
    		$arreglo=array('drop'=>"<tr><td colspan='8'>No existen datos</td></tr>");
    	}

    	if($return!=null){
    		return $arreglo;
    	}
    	else{

    	}
    	$salida = array('drop' =>$info);
    	echo json_encode($salida);
    }

    public function reporte_contabilidad($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$contabilidad = $this->facturacion_model->get_reporte_contabilidad($cliente,$fecha_ini,$fecha_fin);

    	$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Contabilidad"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Producto/Servicio</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Factura</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Costo Servicio</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Minutos</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">IVA</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Recibo</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha de pago</th>';
    	$cadena.='</tr>';

    	foreach ($contabilidad as $con) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$con['src_nombre']."</td>";
    		$cadena.="<td>".$con['factura']."</td>";
    		$cadena.="<td>".number_format($con['caf_valor'],2)."</td>";
    		$cadena.="<td>".$con['minutos']."</td>";
    		$cadena.="<td>".$con['iva']."</td>";
    		$cadena.="<td>".number_format($con['total'],2)."</td>";
    		$cadena.="<td>".$con['recibo']."</td>";
    		$cadena.="<td>".$con['fecha_pago']."</td>";
    		$cadena.='</tr>';
    	}

    	$cadena.='</table>';
    	//die(print_r($cadena));
    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;

    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data);
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTE DE CONTABILIDAD";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    function plan_pagos(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {
								//$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
								//$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
    		$data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '', 'cli_id', true);

    		$data["titulo_personal"] ="Reporte Consulta Plan de Pagos";

    		$this->_cargarvista($data);
    	}
    }

    public function consultar_plan_pagos($return=null){

    	$plan= ($this->input->post('plan')!='') ? $this->input->post('plan') : 0;

		// $fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

		// $fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

		// if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$facxplan = $this->tarificador_model->get_facturas_plan_pago(array('plg_id'=>$plan));

    	$this->db->order_by('cpl_numero ASC');
    	$cuotas_plan = $this->tarificador_model->get_cuotas_plan_pago(array('plg_id'=>$plan));

    	$cadena_fac="";
    	$cadena_cuo="";

    	$total_facturas = array_sum(array_column($facxplan,'fac_total'));
    	foreach ($facxplan as $key => $fac) {

    		$periodo = date('d-m-Y',strtotime($fac['fxs_fecha_inicio'])).' - '.date('d-m-Y',strtotime($fac['fxs_fecha_fin']));
    		if ($fac['fac_estado']==1) { $estado = 'Pendiente'; } else if($fac['fac_estado']==2) { $estado = 'Pagada'; } else if($fac['fac_estado']==0) { $estado = 'Anulada'; }

    		$cadena_fac.="<tr>";
    		$cadena_fac.="<td>".$fac['src_nombre']."</td>";
    		$cadena_fac.="<td>".$fac['fac_numero']."</td>";
    		$cadena_fac.="<td>".$periodo."</td>";
    		$cadena_fac.="<td>$".$fac['fac_total']."</td>";
    		$cadena_fac.="<td>".$estado."</td>";
    		$cadena_fac.='</tr>';
    	}
    	$cadena_fac.="<tr>";
    	$cadena_fac.= "<td colspan='3' style='font-weight:bold;'>Total</td>";
    	$cadena_fac.= "<td colspan='2'>$".number_format($total_facturas,2)."</td>";
    	$cadena_fac.='</tr>';

    	$total_cuotas = array_sum(array_column($cuotas_plan,'cpl_total'));
    	foreach ($cuotas_plan as $key => $cuo) {

    		$fecha_ven = date('d-m-Y',strtotime($cuo['cpl_fecha_vencimiento']));
    		if ($cuo['cpl_estado']==1) { $estado = 'Pendiente'; } else if($cuo['cpl_estado']==2) { $estado = 'Cancelada'; } else if($cuo['cpl_estado']==0) { $estado = 'Anulado'; }
    		if($cuo['paf_fecha_pag']!= null){ $fecha_pago=date('d-m-Y', strtotime($cuo['paf_fecha_pag'])); }else{ $fecha_pago=''; }

    		$cadena_cuo.="<tr>";
    		$cadena_cuo.="<td>".$cuo['cpl_numero']."</td>";
    		$cadena_cuo.="<td>".$cuo['paf_numero']."</td>";
    		$cadena_cuo.="<td>".$fecha_ven."</td>";
    		$cadena_cuo.="<td>".$fecha_pago."</td>";
    		$cadena_cuo.="<td>$".number_format($cuo['cpl_monto'],2)."</td>";
    		$cadena_cuo.="<td>$".number_format($cuo['cpl_interes'],2)."</td>";
    		$cadena_cuo.="<td>$".number_format($cuo['cpl_total'],2)."</td>";
    		$cadena_cuo.="<td>".$estado."</td>";
			// $cadena_cuo.="<td>".''."</td>";
    		$cadena_cuo.='</tr>';
    	}

    	$cadena_cuo.="<tr>";
    	$cadena_cuo.= "<td colspan='6' style='font-weight:bold;'>Total</td>";
    	$cadena_cuo.= "<td colspan='2'>$".number_format($total_cuotas,2)."</td>";
    	$cadena_cuo.='</tr>';

    	if ($cadena_fac!='' && $cadena_cuo!=''){
    		$arreglo=array('facturas'=>$cadena_fac,'cuotas'=>$cadena_cuo);
    	}
    	else {
    		$arreglo=array('drop'=>"<tr><td colspan='8'>No existen datos</td></tr>");
    	}

    	if($return!=null){
    		return $arreglo;
    	}
    	else{
    		echo json_encode($arreglo);
    	}
    }

    public function reporte_plan_pagos($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}

    	$plan= ($this->input->post('plan')!='') ? $this->input->post('plan') : 0;

    	$facxplan = $this->tarificador_model->get_facturas_plan_pago(array('plg_id'=>$plan));

    	$cuotas_plan = $this->tarificador_model->get_cuotas_plan_pago(array('plg_id'=>$plan));

    	$cadena_fac="";
    	$cadena_cuo="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Plan de Pagos"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena_fac.='<table></table>'; }

    	$header_pagos = '';

    	//Facturas
    	$cadena_fac='<table class="tabla" style="border:1px solid black;">';
    	$cadena_fac.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Producto</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Factura</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Periodo</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Total</th>';
    	$cadena_fac.='<th style="text-align:center; font-weight:bold;">Estado</th>';
    	$cadena_fac.='</tr>';


    	$total_facturas = array_sum(array_column($facxplan,'fac_total'));
    	foreach ($facxplan as $key => $fac) {

    		$periodo = date('d-m-Y',strtotime($fac['fxs_fecha_inicio'])).' - '.date('d-m-Y',strtotime($fac['fxs_fecha_fin']));
    		if ($fac['fac_estado']==1) { $estado = 'Pendiente'; } else if($fac['fac_estado']==2) { $estado = 'Pagada'; } else if($fac['fac_estado']==0) { $estado = 'Anulada'; }

    		$cadena_fac.="<tr style='border:1px solid black;'>";
    		$cadena_fac.="<td>".$fac['src_nombre']."</td>";
    		$cadena_fac.="<td>".$fac['fac_numero']."</td>";
    		$cadena_fac.="<td>".$periodo."</td>";
    		$cadena_fac.="<td>$".$fac['fac_total']."</td>";
    		$cadena_fac.="<td>".$estado."</td>";
    		$cadena_fac.='</tr>';
    	}
    	$cadena_fac.="<tr>";
    	$cadena_fac.= '<td colspan="3" style="font-weight:bold;text-align:left;">Total</td>';
    	$cadena_fac.= '<td colspan="2" style="text-align:left;">$'.number_format($total_facturas,2).'</td>';
    	$cadena_fac.='</tr>';

    	$cadena_fac.='</table>';

    	//Cuotas
    	$cadena_cuo='<table class="tabla" style="border:1px solid black;">';
    	$cadena_cuo.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">No.</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Correlativo</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Vencimiento</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Fecha de pago</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Monto</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Interés</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Total</th>';
    	$cadena_cuo.='<th style="text-align:center; font-weight:bold;">Estado</th>';
    	// $cadena_cuo.='<th style="text-align:center; font-weight:bold;">Fecha de Pago</th>';
    	$cadena_cuo.='</tr>';

    	$total_cuotas = array_sum(array_column($cuotas_plan,'cpl_total'));
    	foreach ($cuotas_plan as $key => $cuo) {

    		$fecha_ven = date('d-m-Y',strtotime($cuo['cpl_fecha_vencimiento']));
    		if ($cuo['cpl_estado']==1) { $estado = 'Pendiente'; } else if($cuo['cpl_estado']==2) { $estado = 'Cancelada'; } else if($cuo['cpl_estado']==0) { $estado = 'Anulado'; }
    		if($cuo['paf_fecha_pag']!= null){ $fecha_pago=date('d-m-Y', strtotime($cuo['paf_fecha_pag'])); }else{ $fecha_pago=''; }

    		$cadena_cuo.="<tr style='border:1px solid black;'>";
    		$cadena_cuo.="<td>".$cuo['cpl_numero']."</td>";
    		$cadena_cuo.="<td>".$cuo['paf_numero']."</td>";
    		$cadena_cuo.="<td>".$fecha_ven."</td>";
    		$cadena_cuo.="<td>".$fecha_pago."</td>";
    		$cadena_cuo.="<td>$".number_format($cuo['cpl_monto'],2)."</td>";
    		$cadena_cuo.="<td>$".number_format($cuo['cpl_interes'],2)."</td>";
    		$cadena_cuo.="<td>$".number_format($cuo['cpl_total'],2)."</td>";
    		$cadena_cuo.="<td>".$estado."</td>";
			// $cadena_cuo.="<td>".''."</td>";
    		$cadena_cuo.='</tr>';
    	}

    	$cadena_cuo.="<tr>";
    	$cadena_cuo.= '<td colspan="6" style="font-weight:bold;text-align:left;">Total</td>';
    	$cadena_cuo.= '<td colspan="2" style="text-align:left;">$'.number_format($total_cuotas,2).'</td>';
    	$cadena_cuo.='</tr>';

    	$cadena_cuo.='</table>';

    	$cadena=$cadena_fac.'<br><br>'.$cadena_cuo;
		//die(print_r($cadena_cuo));

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody_fac']      = $cadena_fac;
    		$data['table_tbody_cuo']      = $cadena_cuo;

    		$this->pdf->reportePDF('tarificador/reportes/reporte_plan_pagos.php', $data);
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTE DE PLANES DE PAGO";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    function facturas_vencida(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {

			//$data['listado_facturas'] = $this->facturacion_model->get_facturas_vencidas();

			//die(var_dump($data['listado_facturas']));
								//$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
								//$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
    		$data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', null, null, '', 'cli_id', true);
    		$data['servicios'] = $this->gsatelite->get_dropdown('src_servicio', '{src_nombre}','', null, null, '', 'src_id', true);

    		$data["titulo_personal"] ="Reporte de Facturas Vencidas";

    		$this->_cargarvista($data);
    	}
    }

    public function consultar_facturas_vencida($return=null){

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$servicio = ($this->input->post('servicio')!='') ? $this->input->post('servicio') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado_facturas = $this->facturacion_model->get_facturas_vencidas($cliente,$servicio,$fecha_ini,$fecha_fin);

    	$cadena = '';

    	foreach ($listado_facturas as $key => $fac) {

    		$cadena.="<tr>";
    		$cadena.="<td>".$fac['cliente']."</td>";
    		$cadena.="<td>".$fac['servicio']."</td>";
    		$cadena.="<td>".$fac['numero']."</td>";
    		$cadena.="<td>".$fac['factura']."</td>";
    		$cadena.="<td>".number_format($fac['total_fac'],2)."</td>";
    		$cadena.="<td>".$fac['vencimiento']."</td>";
    		$cadena.="<td>".$fac['dias_vencido']."</td>";
    		$cadena.='</tr>';
    	}

    	if ($cadena!=''){
    		$arreglo=array('drop'=>$cadena);
    	}
    	else {
    		$arreglo=array('drop'=>"<tr><td colspan='7'>No existen datos</td></tr>");
    	}

    	if($return!=null){
    		return $arreglo;
    	}
    	else{
    		echo json_encode($arreglo);
    	}
    }

    public function reporte_facturas_vencida($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}

    	$cliente= ($this->input->post('cliente')!='') ? $this->input->post('cliente') : 0;

    	$servicio = ($this->input->post('servicio')!='') ? $this->input->post('servicio') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado_facturas = $this->facturacion_model->get_facturas_vencidas($cliente,$servicio,$fecha_ini,$fecha_fin);

    	$cadena="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "Facturas Vencidas"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Cliente</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Producto</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Número Principal</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Factura</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Total</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha de Vencimiento</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Días Vencidos</th>';
    	$cadena.='</tr>';

    	foreach ($listado_facturas as $fac) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$fac['cliente']."</td>";
    		$cadena.="<td>".$fac['servicio']."</td>";
    		$cadena.="<td>".$fac['numero']."</td>";
    		$cadena.="<td>".$fac['factura']."</td>";
    		$cadena.="<td>".number_format($fac['total_fac'],2)."</td>";
    		$cadena.="<td>".$fac['vencimiento']."</td>";
    		$cadena.="<td>".$fac['dias_vencido']."</td>";
    		$cadena.='</tr>';
    	}

    	$cadena.='</table>';
    	//die(print_r($cadena));
    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;

    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = "REPORTE DE FACTURAS VENCIDAS";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }

    function imprimir_comprobante_pago()
    {
    	satelite_validar();
    	if($_GET['fac_id']==NULL && $_GET['cpl_id']=NULL) { redirect('/auth/login/'); }
    	$data['cabezera']	=  explode('/', $this->gsatelite->get_parametro('SYS_CABEZERA_RECIBO_PAGO'));

    	$data['datos_recibo']	=	$this->tarificador_model->comprobante_pago($_GET['fac_id'], $_GET['cpl_id']);
    	$GLOBALS['nombre_reporte'] = 'Factura_'.$data['datos_recibo']->fac_numero.'_'.date('Y-m-d_H-m-s');
    	$this->pdf->setPrintFooter(false);

    	$this->pdf->reportePDF("tarificador/impresiones/comprobante_pago", $data);
    }

    //Impresiones
    function imprimir_factura_general($fac_id=null, $sxc=null, $fecha_inicio=null, $fecha_fin=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}
    	if($fac_id==null) { redirect('/auth/login/'); }
    	$rows = $this->load->view('reporte/header', array('titulo' => "Listado de CDR"), true);
    	$data['table_header']     = $rows;
    	$nombre_factura_servicios = $this->gsatelite->get_parametro('FACTURA_SERVICIOS');
    	$cli_id = $this->gsatelite->get_campo('fac_factura','fac_id_cli',array('fac_id'=>$fac_id));

    	// Si solo biene el ID ir a la base a traerse el sxc y la fecha inicio y fecha fin de la tabla fxs_facturaxservicio
    	if(empty($sxc)){
    		$factura_detalle = $this->gsatelite->get_registro('fxs_facturaxservicio', array('fxs_id_fac'=>$fac_id));
    		$sxc = $factura_detalle->fxs_id_sxc;
    		$fecha_inicio = $factura_detalle->fxs_fecha_inicio;
    		$fecha_fin 	=	$factura_detalle->fxs_fecha_fin;
    	}

    	$fecha_ini=date('Y-m-d', strtotime($fecha_inicio));
    	$fec_fin=date('Y-m-d', strtotime($fecha_fin));


    	$data['fecha_ini']=$fecha_ini;
    	$data['fecha_fin']=$fecha_fin;
    	$data['cliente'] = $this->gsatelite->get_tabla('cli_cliente',array('cli_id'=>$cli_id));
    	$data['cliente_fac'] = $this->tarificador_model->get_info_cliente_factura(array('fac_id'=>$fac_id));

    	$data['telefono_principal'] = $this->gsatelite->get_campo('txs_telefonoxservicio','txs_numero',array('txs_id_sxc'=>$data['cliente_fac'][0]['sxc_id'],'txs_principal'=>1));

    	$data['facturas_pendientes'] = $this->tarificador_model->get_facturas_pendientes($fac_id,$cli_id);

    	$data['total_pagos'] = $this->gsatelite->get_suma('paf_pago_factura','paf_total',array('paf_id_fac'=>$fac_id));

    	$data['cargos_mensuales'] = $this->tarificador_model->get_cargos_factura($fac_id,1,$fecha_ini,$fec_fin);
    	$data['cargos_adicionales'] = $this->tarificador_model->get_cargos_factura($fac_id,2,$fecha_ini,$fec_fin);
    	$data['minutos_consumidos'] = $this->tarificador_model->get_factura_min_consumidos($fac_id,1);
    	//die(print_r($sxc));
    	$where=array('caf_id_sxc'=>$sxc, 'date_format(caf_fecha,"%Y-%m-%d") >='=>date('Y-m-d', strtotime($fecha_ini)),
    		'date_format(caf_fecha,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($fec_fin))
    	);

    	$data['detalle_caf_fijos'] = $this->facturacion_model->get_fijos_caf($where,1,1);


    	$data['detalle_impuestos'] = $this->facturacion_model->detalle_impuestos_factura($fac_id,$fecha_ini,$fec_fin);

    	$data['detalle_llamadas'] = $this->tarificador_model->get_factura_min_consumidos($fac_id);

    	$data['empresa_nit'] = $this->gsatelite->get_parametro('SYS_NIT');

    	$GLOBALS['nombre_reporte'] = 'Factura_'.$data['cliente_fac'][0]['fac_numero'].'_'.date('Y-m-d_H-m-s');
    	$this->pdf->setPrintFooter(false);
    	$this->pdf->reportePDF("tarificador/impresiones/$nombre_factura_servicios", $data);
    }

     //Reporte Libros de IVA
    function libro_iva(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {

			// $listado = $this->facturacion_model->reporte_libros_iva();

    		$data['listado'] = $listado;
			//die(var_dump($listado_facturas));
    		$data['tipos'] = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}','', array('tif_estado'=>1), null, '', 'tif_id', true);

    		$data["titulo_personal"] ="Reporte de Libro de IVA";

    		$this->_cargarvista($data);
    	}
    }

    public function consultar_libros_iva($return=null){

    	$tipo_fac= ($this->input->post('tipo')!='') ? $this->input->post('tipo') : 0;

    	$fecha_ini= ($this->input->post('fecha_ini')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_ini'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado = $this->facturacion_model->reporte_libros_iva($tipo_fac,$fecha_ini,$fecha_fin);
    	$cadena="";
    	$totales="";

    	$tlt_exentas=0; $tlt_gravadas=0; $tlt_deb_fiscal=0;
    	$tlt_exportaciones=0; $tlt_ventas_tot=0; $tlt_imp_1=0;
    	$tlt_imp_2=0;
    	foreach ($listado as $key => $lst) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td>".$lst['fecha_fac']."</td>";
    		$cadena.="<td>".$lst['fac_numero']."</td>";
    		$cadena.="<td>".$lst['tif_abreviacion']."</td>";
    		$cadena.="<td>".$lst['NIT']."</td>";
    		$cadena.="<td>".$lst['DUI']."</td>";
    		$cadena.="<td>".$lst['cli_registro']."</td>";
    		$cadena.="<td>".$lst['cli_nombre']."</td>";
    		$cadena.="<td>".number_format($lst['EXENTAS'],2)."</td>";
    		$cadena.="<td>".number_format($lst['GRAVADAS'],2)."</td>";
    		$cadena.="<td>".number_format($lst['DEB_FISCAL'],2)."</td>";
    		$cadena.="<td>".number_format($lst['EXPORTACIONES'],2)."</td>";
    		$cadena.="<td>".number_format($lst['VENTAS_TOTALES'],2)."</td>";
    		$cadena.="<td>".number_format($lst['IMP_RETENIDO_1'],2)."</td>";
    		$cadena.="<td>".number_format($lst['IMP_RETENIDO_5'],2)."</td>";
    		$cadena.='</tr>';

			// TOTALES
    		$tlt_exentas+=$lst['EXENTAS'];
    		$tlt_gravadas+=$lst['GRAVADAS'];
    		$tlt_deb_fiscal+=$lst['DEB_FISCAL'];
    		$tlt_exportaciones+=$lst['EXPORTACIONES'];
    		$tlt_ventas_tot+=$lst['VENTAS_TOTALES'];
    		$tlt_imp_1+=$lst['IMP_RETENIDO_1'];
    		$tlt_imp_2+=$lst['IMP_RETENIDO_5'];
    	}

    	$totales.="<tr style='border:1px solid black;'>";
    	$totales.="<td colspan='7'><strong>Totales</strong></td>";
    	$totales.="<td>".number_format($tlt_exentas,2)."</td>";
    	$totales.="<td>".number_format($tlt_gravadas,2)."</td>";
    	$totales.="<td>".number_format($tlt_deb_fiscal,2)."</td>";
    	$totales.="<td>".number_format($tlt_exportaciones,2)."</td>";
    	$totales.="<td>".number_format($tlt_ventas_tot,2)."</td>";
    	$totales.="<td>".number_format($tlt_imp_1,2)."</td>";
    	$totales.="<td>".number_format($tlt_imp_2,2)."</td>";
    	$totales.='</tr>';

    	if (!empty($listado)){
    		$arreglo=array('drop'=>$cadena, 'total'=>$totales);
    	}
    	else {
    		$arreglo=array('drop'=>"<tr><td colspan='14'>No existen datos</td></tr>");
    	}

    	if($return!=null){
    		return $arreglo;
    	}
    	else{
    		echo json_encode($arreglo);
    	}
    }

    public function reporte_libros($tipo=null){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	}
		//die(print_r($_POST));

    	$tipo_fac= ($this->input->post('tipo_fac')!='') ? $this->input->post('tipo_fac') : 0;

    	$fecha_ini= ($this->input->post('fecha_inicio')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_inicio'))) : "";

    	$fecha_fin= ($this->input->post('fecha_fin')!='') ? date('Y-m-d',strtotime($this->input->post('fecha_fin'))) : "";

    	if($fecha_fin=="" || $fecha_ini == ""){ $fecha_fin=""; $fecha_ini = "";}

    	$listado = $this->facturacion_model->reporte_libros_iva($tipo_fac,$fecha_ini,$fecha_fin);
		//die(print_r($listado));
    	$this->load->library('EnLetras');
    	$mes_anio=$this->enletras->mes_anio($listado[0]['fecha_fac'],1);
    	$fecha=explode('/', $mes_anio);
    	$cadena="";
    	$extra="";

    	$rows=$this->load->view('reporte/header', array('titulo' => "libros de IVA"), true);
    	//<meta http-equiv="content-type" content="text/html; charset=utf-8">
    	$extra='<table cellpadding="3" cellspacing="5">';
    	$extra.="<tr>";
    	$extra.="<td style='text-align:right' width='5%'><strong>Mes:</strong></td>";
    	$extra.="<td style='text-align:left'>".$fecha[0]."</td>";
    	$extra.="<td style='text-align:right'><strong>Año:</strong></td>";
    	$extra.="<td style='text-align:left'>".$fecha[1]."</td>";
    	$extra.="<td style='text-align:right'><strong>Tipo:</strong></td>";
    	$extra.="<td style='text-align:left'>".$listado[0]['tif_abreviacion']."</td>";
    	$extra.="<td style='text-align:right'><strong>Nombre del contribuyente:</strong></td>";
    	$extra.="<td style='text-align:left'>".$listado[0]['cli_nombre']."</td>";
    	$extra.="<td style='text-align:right'><strong>N. R. C.:</strong></td>";
    	$extra.="<td style='text-align:left'>".$lst['cli_registro']."</td>";
    	$extra.='</tr>';
    	$extra.='</table>';

    	if($tipo==2){ $cadena.='<table></table>'; }
    	$cadena='<table class="tabla" style="border:1px solid black;">';
    	$cadena.='<tr style="background-color: #C0C0C0;border:1px solid black;">';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Fecha de emisión</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Correlativo</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Tipo</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">No. de NIT</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">DUI</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">N. R. C.</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Nombre del cliente</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Exentas</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Internas gravadas</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Debito fiscal</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Exportaciones</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Ventas totales</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Impuesto retenido 1%</th>';
    	$cadena.='<th style="text-align:center; font-weight:bold;">Impuesto retenido 5%</th>';
    	$cadena.='</tr>';

    	$totales="";

    	$tlt_exentas=0; $tlt_gravadas=0; $tlt_deb_fiscal=0;
    	$tlt_exportaciones=0; $tlt_ventas_tot=0; $tlt_imp_1=0;
    	$tlt_imp_2=0;

    	foreach ($listado as $lst) {

    		$cadena.="<tr style='border:1px solid black;'>";
    		$cadena.="<td style='border:1px solid black;'>".$lst['fecha_fac']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$lst['fac_numero']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$lst['tif_abreviacion']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$lst['NIT']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$lst['DUI']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$lst['cli_registro']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".$lst['cli_nombre']."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($lst['EXENTAS'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($lst['GRAVADAS'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($lst['DEB_FISCAL'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($lst['EXPORTACIONES'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($lst['VENTAS_TOTALES'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($lst['IMP_RETENIDO_1'],2)."</td>";
    		$cadena.="<td style='border:1px solid black;'>".number_format($lst['IMP_RETENIDO_5'],2)."</td>";
    		$cadena.='</tr>';

			// TOTALES
    		$tlt_exentas+=$lst['EXENTAS'];
    		$tlt_gravadas+=$lst['GRAVADAS'];
    		$tlt_deb_fiscal+=$lst['DEB_FISCAL'];
    		$tlt_exportaciones+=$lst['EXPORTACIONES'];
    		$tlt_ventas_tot+=$lst['VENTAS_TOTALES'];
    		$tlt_imp_1+=$lst['IMP_RETENIDO_1'];
    		$tlt_imp_2+=$lst['IMP_RETENIDO_5'];
    	}

    	$cadena.="<tr style='border:1px solid black;'>";
    	if($tipo==1){
    		$cadena.="<td style='border:1px solid black;' ></td>";
    		$cadena.="<td style='border:1px solid black;' ></td>";
    		$cadena.="<td style='border:1px solid black;' ></td>";
    		$cadena.="<td style='border:1px solid black;' ></td>";
    		$cadena.="<td style='border:1px solid black;' ></td>";
    		$cadena.="<td style='border:1px solid black;' ></td>";
    	}
    	$cadena.="<td  colspan='7' style='border:1px solid black;text-align:right;' ><strong>Totales &nbsp;</strong></td>";
    	$cadena.="<td style='border:1px solid black;'>".number_format($tlt_exentas,2)."</td>";
    	$cadena.="<td style='border:1px solid black;'>".number_format($tlt_gravadas,2)."</td>";
    	$cadena.="<td style='border:1px solid black;'>".number_format($tlt_deb_fiscal,2)."</td>";
    	$cadena.="<td style='border:1px solid black;'>".number_format($tlt_exportaciones,2)."</td>";
    	$cadena.="<td style='border:1px solid black;'>".number_format($tlt_ventas_tot,2)."</td>";
    	$cadena.="<td style='border:1px solid black;'>".number_format($tlt_imp_1,2)."</td>";
    	$cadena.="<td style='border:1px solid black;'>".number_format($tlt_imp_2,2)."</td>";
    	$cadena.='</tr>';

    	$cadena.='</table>';

    	$filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

    	if($tipo==1){
    		$data['table_header']     = $rows;
    		$data['table_tbody']      = $cadena;
    		$data['extra_info']		  = $extra;

    		$this->pdf->reportePDF('tarificador/reportes/reporte_pdf.php', $data,null,'L');
    	}
    	else if($tipo==2){
    		$data['table_header']     = " LIBRO  O REGISTRO DE IVA   ( ART.141  C.T.  Y 86  R.C.T.)";
    		$data['table_tbody']      = $cadena;
    		$data['filename']         = $filename;
    		$data['extra_info']		  = $extra;
    		$this->load->view('tarificador/reportes/reporte_excel.php', $data);
    	}
    }


    public function historial_cajas(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {
    		$data['areas']			 = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}','', array("arf_estado" => 1), null, '', 'arf_id', true);
    		$data['tipo_pagos']		 = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}','', array("tpg_estado" => 1), null, '', 'tpg_id', true);
    		$data['cajas'] 			 = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}','', null, null, '', 'caj_id', true);
    		$data['tipo_facturas'] 	 = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}','', array("tif_estado" => 1), null, '', 'tif_id', true);
    		$data['tipo_pago'] 	 	 = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}','', array("tpg_estado" => 1), null, '', 'tpg_id', true);
    		$data["titulo_personal"] = "Historial de cajas";
    		$this->_cargarvista($data);
    	}
    }

    function consultar_historial_cajas(){
    	$fecha_ini = $this->input->post('fecha_ini');
    	$fecha_fin = $this->input->post('fecha_fin');
    	$caja	   = $this->input->post('caja');
    	$estado	   = $this->input->post('estado');
    	$area	   = $this->input->post('area');
    	$tipo_pago = $this->input->post('tipo_pago');
    	$tipo_fact = $this->input->post('tipo_fact');
    	$monto_min = $this->input->post('monto_min');
    	$where = $having = null;
    	if ($fecha_fin!='') {
    		$fecha_fn=date('Y-m-d', strtotime($fecha_fin));
    	}
    	if ($fecha_ini!='') {
    		$fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
    	}
    	if ( $area != "" ) {
    		$where['fac_id_arf'] = $area;
    	}
    	if ( $tipo_pago != "" ) {
    		$where['fac_id_tpg'] = $tipo_pago;
    	}
    	if ( $monto_min != "" ) {
    		$where['fac_total >='] = $monto_min;
    	}
    	if ( $tipo_fact != "" ) {
    		$where['tif_id'] = $tipo_fact;
    	}
    	if ($estado == "") {
    		$estado = null;
    	} elseif ( $estado == 3 ) {
    		$estado = 0;
    		$having = "f1.fac_estado = 0";
    	}else{
    		$having = "f1.fac_estado = $estado";
    	}
    	if ($caja == ""){
    		$caja = null;
    	}
    	$data['aplica_modal_partida'] = 1;
    	$data['cajas'] 	= $this->facturacion_model->historial_cajas($caja,$fecha_inicio,$fecha_fn,$estado,$where,$having);
    	$arreglo = array(
    		'html' => $this->load->view('facturacion/reportes/consultar_historial_cajas', $data, true)//,						
    		//	'cuentas'=>(count($data['carga_datos'])>0)? 1: 0
    	);
    	echo json_encode($arreglo);
    }

    function imprimir_historial_cajas(){
    	$fecha_ini = $this->input->post('fecha_inicio');
    	$fecha_fin = $this->input->post('fecha_fin');
    	$caja	   = $this->input->post('caja');
    	$estado	   = $this->input->post('estado');
    	$area	   = $this->input->post('slc_area');
    	$tipo_pago = $this->input->post('slc_tipo_pago');
    	$tipo_fact = $this->input->post('slc_tipo_fact');
    	$monto_min = $this->input->post('monto_min');
    	$where = $having = null;
    	if ($fecha_ini!='') {
    		$fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
    	}
    	if ($fecha_fin!='') {
    		$fecha_fn = date('Y-m-d', strtotime($fecha_fin));
    	}
    	if ( $area != "" ) {
    		$where['fac_id_arf'] = $area;
    	}
    	if ( $tipo_pago != "" ) {
    		$where['fac_id_tpg'] = $tipo_pago;
    	}
    	if ( $monto_min != "" ) {
    		$where['fac_total >='] = $monto_min;
    	}
    	if ( $tipo_fact != "" ) {
    		$where['tif_id'] = $tipo_fact;
    	}
    	if ($estado == "") {
    		$estado = null;
    	} elseif ( $estado == 3 ) {
    		$estado = 0;$having = "f1.fac_estado = 0";
    	}else{
    		$having = "f1.fac_estado = $estado";
    	}
    	if ($caja == ""){
    		$caja = null;
    		$caja_filtro = 'Todas las Cajas';
    	} else {
    		$caja_filtro = 'Cajero: ' . $this->gsatelite->get_campo('caj_caja', 'caj_nombre', array('caj_id' => $caja));
    	}
    	$periodo = ($fecha_ini != '' && $fecha_fin != '') ? 'Del '.formatear_fecha('d-m-Y',$fecha_ini).' Al '.formatear_fecha('d-m-Y',$fecha_fin).'<br/>'.$caja_filtro : $caja_filtro;
    	$data['cajas']	= $this->facturacion_model->historial_cajas($caja,$fecha_inicio,$fecha_fn,$estado,$where,$having);
    	$html  = $this->load->view('reporte/header', array('titulo' => 'Historial Cajas', 'solotitulo' => true, 'subtitulo'=> $periodo), true);
    	$html .= $this->load->view('facturacion/reportes/imprimir_historial_cajas', $data, true);
    	$head = '<!DOCTYPE html><html><head><title>Historial Cajas</title></head><body><script type="text/javascript">';
    	$head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Historial Cajas";';
    	$head .= 'window.print();</script>';
    	$footer = '</body></html>';
    	$reporte = $head . $html . $footer;
    	echo $reporte;
		// $this->pdf->makePDF($html,'L');
    }

    function historial_cajas_excel(){
    	$fecha_ini = $this->input->post('fecha_inicio');
    	$fecha_fin = $this->input->post('fecha_fin');
    	$caja	   = $this->input->post('caja');
    	$estado	   = $this->input->post('estado');
    	$area	   = $this->input->post('slc_area');
    	$tipo_pago = $this->input->post('slc_tipo_pago');
    	$tipo_fact = $this->input->post('slc_tipo_fact');
    	$monto_min = $this->input->post('monto_min');
    	$where = $having = null;
    	if ($fecha_fin!='') {
    		$fecha_fn=date('Y-m-d', strtotime($fecha_fin));
    	}
    	if ($fecha_ini!='') {
    		$fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
    	}
    	if ( $area != "" ) {
    		$where['fac_id_arf'] = $area;
    	}
    	if ( $tipo_pago != "" ) {
    		$where['fac_id_tpg'] = $tipo_pago;
    	}
    	if ( $monto_min != "" ) {
    		$where['fac_total >='] = $monto_min;
    	}
    	if ( $tipo_fact != "" ) {
    		$where['tif_id'] = $tipo_fact;
    	}
    	if ($estado == "") {
    		$estado = null;
    	} elseif ( $estado == 3 ) {
    		$estado = 0;
    		$having = "f1.fac_estado = 0";
    	}else{
    		$having = "f1.fac_estado = $estado";
    	}
    	if ($caja == ""){
    		$caja = null;
    		$caja_filtro = 'Todas las Cajas';
    	} else {
    		$caja_filtro = 'Cajero: ' . $this->gsatelite->get_campo('caj_caja', 'caj_nombre', array('caj_id' => $caja));
    	}
    	$data['subtl'] = ($fecha_ini != '' && $fecha_fin != '') ? 'Del '.formatear_fecha('d-m-Y',$fecha_ini).' Al '.formatear_fecha('d-m-Y',$fecha_fin).' / '.$caja_filtro : $caja_filtro;
    	$data['cajas'] = $this->facturacion_model->historial_cajas($caja,$fecha_inicio,$fecha_fn,$estado,$where,$having);
    	$this->load->view('facturacion/reportes/historial_cajas_excel', $data);
    }

    public function historial_caja_cajero(){
    	if (!$this->tank_auth->is_logged_in()){
    		redirect('/auth/login/');
    	} else {
    		$rol_cajero =  $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
    		$data['cajas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}','', array('caj_estado' => 1), null, '', 'caj_id', true));
    		$data['disable']= 0; // Se deshabilitará si el usuario es cajero.
    		$opt_cajero = '<option value=""></option>';
    		if($rol_cajero>0){
    			$existe = $this->gsatelite->verificar_registro_real('rol_rol', $rol_cajero);
    			if($existe){
    				/***** Se verifican los permisos de los roles asociados al usuario para la carga de los cajeros ******/
    				$usu = $this->tank_auth->get_user_id();
    				$reg_uxr = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu' => $usu));
    				$roles = array_column($reg_uxr, 'uxr_id_rol');
    				$data['roles'] = $roles;
    				if(count($roles) == 1 && $roles[0] == $rol_cajero){
    					$actual = $usu;
    				}else{
    					// Incrementa cuando el usuario tiene otros roles (diferentes de cajero) y tiene permiso para esta opción de menú.
    					$permisos_otros = 0;
    					// Incrementa en caso de que sea cajero.
    					$es_cajero = 0;
    					foreach ($roles as $key) {
    						$result = $this->gsatelite->get_permisos_opcion('historial_caja_cajero', null, array('uxr_id_rol'=>$key), true);
    						if($key==$rol_cajero && is_array($result)){
    							$es_cajero++;
    						}else if($key!=$rol_cajero && is_array($result)){
    							$permisos_otros++;
    						}
    					}
    					if($permisos_otros>0){
    						$actual = 0;
    					}else if($permisos_otros<=0 && $es_cajero>0){
    						$actual = $usu;
    					}else{
    						$actual = 0;
    					}
    				}
    				if($actual > 0){
    					// si es cajero cargará únicamente su usuario
    					$cajeros = $this->facturacion_model->cajeros($rol_cajero, array('id'=>$usu));
    				}else{
    					// Si no es cajero carga todos los usuarios con el rol
    					$cajeros = $this->facturacion_model->cajeros($rol_cajero);
    				}
    				/************ Cargar usuarios con rol cajero, según parámetro **********************************/
    				if(count($cajeros) > 0){
    					foreach ($cajeros as $caj) {
    						$select = "";
    						if($actual == $caj['id']){
    							$data['disable']=1;
    							$select='selected="selected"';
    						}
    						$opt_cajero .= '<option value="'.$caj['id'].'" data-emp="'.$caj['id'].'" '.$select.'>'.$caj['emp_nombre'].' '.$caj['emp_apellido'].'</option>';
    					}
    				}
    				$data['cajero'] = $opt_cajero;
    			}else{
    				$alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Rol",'texto_alerta'=>"Debe realizar las configuraciones necesarias para el rol de cajero");
    				$this->session->set_flashdata($alerta);
    			}
    		}else{
    			$alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Rol",'texto_alerta'=>"Debe realizar las configuraciones necesarias para el rol de cajero");
    			$this->session->set_flashdata($alerta);
    		}
    		$data["titulo_personal"] ="Historial de caja";
    		$this->_cargarvista($data);
    	}
    }

	function consultar_historial_caja_cajero(){
		satelite_validar(true);
		$txtCaja = array();
		$fecha_ini = $this->input->post('fecha_inicio');
		$fecha_fin = $this->input->post('fecha_fin');
		$id_caja  = (is_array($this->input->post('slcCaja'))) ? $this->input->post('slcCaja') : null;
		if ($fecha_fin!='') {
			$fecha_fn=date('Y-m-d', strtotime($fecha_fin));
		}
		if ($fecha_ini!='') {
			$fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
		}
		if ($id_caja != null) {
			$where_array = $id_caja;
		}
		$rol_cajero = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
		$data['tipospago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array());
		$usu = null;
		// if($cajero > 0){
		// 	$usu=$this->input->post('cajero');
		// 	$this->db->where('uxc_id_usu', $usu);
		// }else{
			$usu = $this->tank_auth->get_user_id();
			$reg_uxr = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu'=>$usu));
			$roles = array_column($reg_uxr, 'uxr_id_rol');
			$data['roles'] = $roles;
			if(count($roles) == 1 && $roles[0] == $rol_cajero){
				$this->db->where('uxc_id_usu', $usu);
			}else{
    			$permisos_otros = 0; // Incrementa cuando el usuario tiene otros roles (diferentes de cajero) y tiene permiso para esta opción de menú.
    			$es_cajero = 0; // Incrementa en caso de que sea cajero.
    			foreach ($roles as $key) {
    				$result = $this->gsatelite->get_permisos_opcion('historial_caja_cajero', null, array('uxr_id_rol'=>$key), true);
    				if($key == $rol_cajero && is_array($result)){
    					$es_cajero++;
    				}else if($key != $rol_cajero && is_array($result) && $result['sin_permisos']==0 ){
    					$permisos_otros++;
    				}
    			}
    			// if($permisos_otros>0){
    			// 	$this->db->where('(uxc_id_usu != '.$usu.' or uxc_id_usu = '.$usu.') ', null, false);
    			// }else if($permisos_otros<=0 && $es_cajero>0){
    			// 	$this->db->where('uxc_id_usu', $usu);
    			// }else{
    			// 	$this->db->where('uxc_id_usu', 0);
    			// }
    		}
    	// }
    	$data['cajas_todo'] = $this->facturacion_model->historial_caja_cajero($fecha_inicio, $fecha_fn, $where_array);
    	// var_dump($this->db->last_query());die();
    	if (count($data['cajas_todo']) > 0) {
    		$caja = (trim($data['cajas_todo'][0]['caj_nombre']) != "") ? "Caja: " . trim($data['cajas_todo'][0]['caj_nombre']) . "<br>" : ""; 
    		$sucursal = (trim($data['cajas_todo'][0]['suc_nombre']) != "") ? "Sucursal: " . trim($data['cajas_todo'][0]['suc_nombre']) . "<br>" : ""; 
    		$filtro = $sucursal . $caja; 
    	} else {
    		$filtro = ""; 
    	}
    	if (isset($this->uri->segments[4])) {
    		$data['format'] = $this->uri->segments[4];
    	}else{
    		$data['format'] = "html";
    	}
    	$data['fecha_ini'] = $fecha_inicio;
    	$data['fecha_fin'] = $fecha_fin;
    	$fecha_ini_inverse = date("Y-m-d", strtotime($fecha_inicio)); 
    	$fecha_fin_inverse = date("Y-m-d", strtotime($fecha_fin));
    	switch ($data['format']) {
    		case 'html':
    			$arreglo=array('html'=>$this->load->view('facturacion/reportes/consultar_historial_caja_cajero', $data,true));
    			echo json_encode($arreglo);
    			break;
    		case 'excel':
    			$this->load->view('facturacion/reportes/consultar_historial_caja_cajero', $data);
    			break;
    		case 'pdf': 
                ini_set( 'memory_limit', '512M' );
                // ini_set('max_execution_time', '9999');
                $rep = array('titulo' => "Ventas Credito y Contado del $fecha_ini_inverse al $fecha_fin_inverse", 'subtitulo' => $filtro);
				$html = $this->load->view('reporte/header', $rep, true);
			    	$html.=$this->load->view('facturacion/reportes/consultar_historial_caja_cajero', $data, true);
			    	$this->pdf->makePDF($html,'L');

    			break;
    	}
    }

    function imprimir_historial_caja_cajero(){
    	$fecha_ini=$this->input->post('fecha_inicio');
    	$fecha_fin=$this->input->post('fecha_fin');
    	$cajero=$this->input->post('slcCajero');

    	if ($fecha_ini!='') {
    		$fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
    	}
    	if ($fecha_fin!='') {
    		$fecha_fn = date('Y-m-d', strtotime($fecha_fin));
    	}

    	/*************** validación de roles para registros de caja ***************************/
    	$rol_cajero = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
    	$id_caja=null;
    	$usu = null;
    	if($cajero>0){
    		$usu=$this->input->post('cajero');
    		$id_ = $this->gsatelite->get_campo('uxc_usuarioxcaja','uxc_id_caj',array('uxc_id_usu'=>$usu, 'uxc_estado' => 1));
    		$id_caja = $id_[0]['uxc_id_caj'];
    		$this->db->where('uxc_id_usu', $usu);
    	}else{
    		$usu=$this->tank_auth->get_user_id();
    		$reg_uxr = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu'=>$usu));
    		$roles = array_column($reg_uxr, 'uxr_id_rol');

    		if(count($roles)==1 && $roles[0]==$rol_cajero){
    			$this->db->where('uxc_id_usu', $usu);
    		}else{
	    			$permisos_otros = 0; // Incrementa cuando el usuario tiene otros roles (diferentes de cajero) y tiene permiso para esta opción de menú.
	    			$es_cajero = 0; // Incrementa en caso de que sea cajero.

	    			foreach ($roles as $key) {
	    				//die(print_r($key));
	    				$result = $this->gsatelite->get_permisos_opcion('historial_caja_cajero', null, array('uxr_id_rol'=>$key), true);

	    				if($key==$rol_cajero && is_array($result)){
	    					$es_cajero++;
	    				}else if($key!=$rol_cajero && is_array($result) && $result['sin_permisos']==0 ){
	    					$permisos_otros++;
	    				}
	    			}

	    			if($permisos_otros>0){
	    				$this->db->where('(uxc_id_usu != '.$usu.' or uxc_id_usu = '.$usu.') ', null, false);
	    			}else if($permisos_otros<=0 && $es_cajero>0){
	    				$this->db->where('uxc_id_usu', $usu);
	    			}else{
	    				$this->db->where('uxc_id_usu', 0);
	    			}
	    		}

	    	}
	    	/*************************************************************************************/

	    	$data['cajas']=$this->facturacion_model->historial_caja_cajero($fecha_inicio,$fecha_fn,$id_caja);

	    	$this->load->library('pdf');
	    	$html=$this->load->view('reporte/header', array('titulo' => 'Historial de caja', 'solotitulo' => true, 'subtitulo'=> ''), true);
	    	$html.=$this->load->view('facturacion/reportes/imprimir_historial_caja_cajero', $data, true);
	    	$this->pdf->makePDF($html,'L');
	    }

	    public function reporte_personal_factura($consulta = 0) {
	    	if (!$this->tank_auth->is_logged_in()) {
	    		redirect('/auth/login/');
	    	} else {
	    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_personal_factura');
	    		if ($_POST) {
	    			if ($consulta > 0) {
                    //var_dump($_POST);die();

	    				$post_array = $_POST;

	    				$tipo_entrada = $post_array['estado'];

	    				$fecha_inicio = $post_array['fecha_ini'];
	    				$fecha_fin = $post_array['fecha_fin'];

	    				$label = $post_array['label'];

	    				$data['label_select'] = $label;
	    				$data['fecha_ini'] = $fecha_inicio;
	    				$data['fecha_fin'] = $fecha_fin;

	    				$where = null;

                    /*if ($tipo_entrada) {
                        $where['moi_id_tip'] = $tipo_entrada;
                    }*/
                    if ($fecha_inicio != '' && $fecha_fin != '') {
                    	$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
                    	$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
                    }
                    $where['fac_estado != '] = 0;
                    /*if($tipo_entrada == ""){
                    	$tipo_entrada = -1;
                    }*/

                    $data['plaza'] = $tipo_entrada;

                    $data['facturas'] = $this->facturacion_model->get_factura_ven($where);
                    $data['tipo_reporte'] = 'grid';

                    $html = $this->load->view('facturacion/reportes/imprimir_factura_empleado', $data, true);

                    echo $html;
                    die();
                }
            } else {
            	$select = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}', '', array('pto_estado' => 1), null, '', 'pto_id', true);
            	$data['tipo_proceso'] = str_replace('<option value="0">Seleccione</option>', '', $select);
            	$data['titulo_personal'] = 'Reporte de personal por factura';
            	$this->_cargarvista($data);
            }
        }
    }

    function imprimir_personal_factura(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');
    	$area = $this->input->post('puestos_personal');
    	$label = $this->input->post('label_select_reporte');
    	$tipo = $this->input->post('tipo_reporte');

    	$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));

    	$area_array = explode(',', $area);

    	if(trim($area) == ""){
    		$area_array = -1;
    	}

    	$data['plaza'] = $area_array;
    	$data['label_select'] = $label;
    	$data['facturas'] = $this->facturacion_model->get_factura_ven($where);
    	$data['tipo_reporte'] = $tipo;

    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_factura_empleado', $data);
    	} else{
    		$html = $this->load->view('facturacion/reportes/imprimir_factura_empleado', $data, true);
    		$GLOBALS['nombre_reporte'] = 'garantia_' . date('dmY');
    		$this->pdf->makePdf($html, 'L', 'garantia', 'Letter');
    	}
    }

    public function reporte_detallado_abono($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_detallado_abono');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;

    				$cliente = $post_array['cliente'];
    				$vendedor = $post_array['vendedor'];
    				$pago = $post_array['pago'];

    				$slcCobrador = $this->input->post('slcCobrador');

    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];

    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;

    				$where = null;

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($cliente) != ""){
    					$where['cli_id'] = $cliente;
    				}
    				if(trim($vendedor) != ""){
    					$where['ven_id'] = $vendedor;
    				}

    				if(trim($slcCobrador) > 0){
    					$where['abc_id_cob'] = $slcCobrador;
    				}

    				$data['pago'] = $pago;
    				$data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id');
					// var_dump($this->db->last_query());die();
    				$data['detalle_abono'] = $this->gsatelite->get_tabla('dab_detalle_abono', array('dab_estado'=>1, 'dab_id_tpg'=>$pago));
    				$data['tipo_reporte'] = 'grid';

    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_detallado_abono', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo}{ven_nombre}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
    			$data['vendedor'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

    			$select = '';
    			$clientes_reg = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado'=>1));
    			foreach ($clientes_reg as $key) {
    				if($key['cli_personeria'] == 1){
    					$select .= '<option value="'.$key['cli_id'].'">'.$key['cli_codigo'].' - '.trim($key['cli_nombre'].' '.$key['cli_apellido']).'</option>';
    				} else{
    					$select .= '<option value="'.$key['cli_id'].'">'.$key['cli_codigo'].' - '.trim($key['cli_apellido']).'</option>';
    				}
    			}
    			$data['clientes'] = $select;

    			$select = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
    			$data['tipo_pago'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

    								   $this->db->join('emp_empleado', 'emp_id=cob_id_emp', 'left');
    			$slcCobrador = $this->gsatelite->get_dropdown('cob_cobrador', '{cob_codigo} -  {cob_nombre} {cob_apellido}','', null, null, '', 'cob_id', true);
    			$data['slcCobrador'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slcCobrador);
    			$data['titulo_personal'] = 'Reporte detallado de abono';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_detallado_abono(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');

    	$cliente = $this->input->post('slcCliente');
    	$vendedor = $this->input->post('slcVendedor');
    	$pago = $this->input->post('slcPago');
    	$slcCobrador = $this->input->post('slcCobrador');

    	$tipo = $this->input->post('tipo_reporte');

    	$where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));

    	if(trim($cliente) != ""){
    		$where['cli_id'] = $cliente;
    	}
    	if(trim($vendedor) != ""){
    		$where['ven_id'] = $vendedor;
    	}

    	if(trim($slcCobrador) > 0){
    		$where['abc_id_cob'] = $slcCobrador;
    	}

    	$data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id');
    	$data['detalle_abono'] = $this->gsatelite->get_tabla('dab_detalle_abono', array('dab_estado'=>1, 'dab_id_tpg'=>$pago));

    	$data['tipo_reporte'] = $tipo;

    	$data['cliente'] = $cliente;
    	$data['vendedor'] = $vendedor;
    	$data['pago'] = $pago;

    	$data['textcliente'] = $this->input->post('txtCliente');
    	$data['textvendedor'] = $this->input->post('txtVendedor');
    	$data['textpago'] = $this->input->post('txtPago');

    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_detallado_abono', $data);
    	} else{
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_detallado_abono', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
    		$this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_abono_cliente($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_abono_cliente');
    		if ($_POST) {
    			if ($consulta > 0) {
                    //var_dump($_POST);die();

    				$post_array = $_POST;

    				$cliente = $post_array['cliente'];
    				$vendedor = $post_array['vendedor'];
    				$pago = $post_array['pago'];

    				$textocliente = $post_array['textocliente'];

    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];

    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;

    				$where = null;

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($cliente) != ""){
    					$where['cli_id'] = $cliente;
    				}
    				if(trim($vendedor) != ""){
    					$where['ven_id'] = $vendedor;
    				}

    				$data['pago'] = $pago;
    				$data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id');
                    //print_r($this->db->last_query());die();
    				$data['textocliente'] = $textocliente;

    				if(trim($pago) != ""){
    					$data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado'=>1, 'dab_id_tpg'=>$pago));
    				} else{
    					$data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado'=>1));
    				}

    				$data['tipo_reporte'] = 'grid';

    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_abono_cliente', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo}{ven_nombre}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
    			$data['vendedor'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$select = $this->gsatelite->get_dropdown('cli_cliente', "[CASE WHEN cli_personeria = 1 THEN CONCAT_WS(' ',cli_codigo,' - ', cli_nombre, cli_apellido) ELSE  CONCAT_WS(' ',cli_codigo,' - ', cli_apellido) END]", 'clientes', array('cli_estado' => 1), null, null, null, true);
    			$data['clientes'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$select = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
    			$data['tipo_pago'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$data['titulo_personal'] = 'Reporte de abonos por cliente';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_abono_cliente(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');

    	$cliente = $this->input->post('slcCliente');
    	$vendedor = $this->input->post('slcVendedor');
    	$pago = $this->input->post('slcPago');

    	$tipo = $this->input->post('tipo_reporte');

    	$where['abc_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['abc_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));

    	if(trim($cliente) != ""){
    		$where['cli_id'] = $cliente;
    	}
    	if(trim($vendedor) != ""){
    		$where['ven_id'] = $vendedor;
    	}

    	$data['abono'] = $this->facturacion_model->get_detalle_abono($where, 'abc_id');

    	if(trim($pago) != ""){
    		$data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado'=>1, 'dab_id_tpg'=>$pago));
    	} else{
    		$data['detalle_abono'] = $this->facturacion_model->get_detalle_por_abono(array('dab_estado'=>1));
    	}


    	$data['tipo_reporte'] = $tipo;

    	$data['cliente'] = $cliente;
    	$data['vendedor'] = $vendedor;
    	$data['pago'] = $pago;

    	$data['textcliente'] = $this->input->post('txtCliente');
    	$data['textvendedor'] = $this->input->post('txtVendedor');
    	$data['textpago'] = $this->input->post('txtPago');

    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_abono_cliente', $data);
    	} else{
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_abono_cliente', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
    		$this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_facturas_proximas_vencer($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_facturas_proximas_vencer');
    		if ($_POST) {
    			if ($consulta > 0) {
                    //var_dump($_POST);die();

    				$post_array = $_POST;

    				$cliente = $post_array['cliente'];
    				$vendedor = $post_array['vendedor'];
                    //$pago = $post_array['pago'];

    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];

    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;

    				$where = null;

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['fac_fecha_vencimiento >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['fac_fecha_vencimiento <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($cliente) != ""){
    					$where['cli_id'] = $cliente;
    				}
    				if(trim($vendedor) != ""){
    					$where['ven_id'] = $vendedor;
    				}
    				$where['fac_estado'] = 1;
                    //$data['pago'] = $pago;
    				$data['abono'] = $this->facturacion_model->get_facturas_proximas_vencer($where);
                    //print_r($data['abono']);die();
                	//$data['detalle_abono'] = $this->facturacion_model->get_facturas_proximas_vencer(array('dab_estado'=>1));

    				$data['tipo_reporte'] = 'grid';

    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_facturas_proximas_vencer', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
    			$data['vendedor'] = str_replace('<option value="0">Seleccione</option>', '', $select);

    			$select = '';
    			$clientes_reg = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado'=>1));
    			foreach ($clientes_reg as $key) {
    				if($key['cli_personeria'] == 1){
    					$select .= '<option value="'.$key['cli_id'].'">'.trim($key['cli_nombre'].' '.$key['cli_apellido']).'</option>';
    				} else{
    					$select .= '<option value="'.$key['cli_id'].'">'.trim($key['cli_apellido']).'</option>';
    				}
    			}
                //$select = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}', '', array('cli_estado' => 1), null, '', 'cli_id', true);

    			$data['clientes'] = $select;
    			$select = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
    			$data['tipo_pago'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$data['titulo_personal'] = 'Reporte de facturas próximas a vencer';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_facturas_proximas_vencer(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');

    	$cliente = $this->input->post('slcCliente');
    	$vendedor = $this->input->post('slcVendedor');
    	//$pago = $this->input->post('slcPago');

    	$tipo = $this->input->post('tipo_reporte');

    	$where['fac_fecha_vencimiento >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['fac_fecha_vencimiento <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));

    	if(trim($cliente) != ""){
    		$where['cli_id'] = $cliente;
    	}
    	if(trim($vendedor) != ""){
    		$where['ven_id'] = $vendedor;
    	}
    	$where['fac_estado'] = 1;

    	$data['abono'] = $this->facturacion_model->get_facturas_proximas_vencer($where);

    	$data['tipo_reporte'] = $tipo;

    	$data['cliente'] = $cliente;
    	$data['vendedor'] = $vendedor;
        //$data['pago'] = $pago;

    	$data['textcliente'] = $this->input->post('txtCliente');
    	$data['textvendedor'] = $this->input->post('txtVendedor');
        //$data['textpago'] = $this->input->post('txtPago');

    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_facturas_proximas_vencer', $data);
    	} else{
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_facturas_proximas_vencer', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
    		$this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_acumulado_factura_mensual_categoria($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_acumulado_factura_mensual_categoria');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;

    				$categoria = $post_array['categoria'];

    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_inicio2 = $post_array['fecha_ini2'];
    				$fecha_fin = $post_array['fecha_fin'];

    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_ini2'] = $fecha_inicio2;
    				$data['fecha_fin'] = $fecha_fin;

    				$where = null;

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($categoria) != ""){
    					$where['art_id_tia'] = $categoria;
    				}
    				$group_by = "tia_nombre, art_id_tia, arf_id";
    				$order_by = "art_id_tia, fac_id_tpg";
    				$data['facturas'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);
    				$group_by = null;
    				$order_by = "art_id_tia, fac_id_tpg, arf_id";
    				$data['tipos_pago'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);
    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_acumulado_factura_mensual_categoria', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
    			$data['categoria'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$data['titulo_personal'] = 'Reporte acumulado de facturas mensuales por categoría';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_acumulado_factura_mensual_categoria(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');

    	$categoria = $this->input->post('slcCategoria');

    	$tipo = $this->input->post('tipo_reporte');

    	$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));

    	if(trim($categoria) != ""){
    		$where['art_id_tia'] = $categoria;
    	}
    	$group_by = "tia_nombre, art_id_tia, arf_id";
    	$order_by = "art_id_tia, fac_id_tpg";
    	$data['facturas'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);
    	$group_by = null;
    	$order_by = "art_id_tia, fac_id_tpg, arf_id";
    	$data['tipos_pago'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);
    	$data['tipo_reporte'] = $tipo;

    	$data['categoria'] = $categoria;
    	$data['textcategoria'] = $this->input->post('txtCategoria');

    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_acumulado_factura_mensual_categoria', $data);
    	} else{
    		$data['titulo'] = 'facturación acumulado mensual por categoría';
    		$data['header'] = $this->load->view('reporte/header', $data, true);
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_acumulado_factura_mensual_categoria', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
    		$this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_acumulado_factura_mensual_producto($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_acumulado_factura_mensual_producto');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;
    				$categoria 		= $post_array['categoria'];
    				$fecha_inicio 	= $post_array['fecha_ini'];
                    //$fecha_inicio2 	= $post_array['fecha_ini2'];
    				$fecha_fin 		= $post_array['fecha_fin'];
    				$data['fecha_ini'] = $fecha_inicio;
                    //$data['fecha_ini2'] = $fecha_inicio2;
    				$data['fecha_fin'] = $fecha_fin;
    				$where['fac_estado >'] = 0;
    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['DATE(fac_fecha_fact) >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['DATE(fac_fecha_fact) <='] = date('Y-m-d', strtotime($fecha_fin));
    				}
    				if(trim($categoria) != ""){
    					$where['art_id'] = $categoria;
    				}

    				$group_by = "art_id, arf_id, fac_id_tpg";
    				$order_by = "tia_id, art_id, arf_id";
    				$data['facturas'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);	
                    // $group_by = null;
                    // $order_by = "art_id, fac_id_tpg, arf_id";
                    // $data['tipos_pago'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);
                    // print_r($this->db->last_query());die();	
    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_acumulado_factura_mensual_producto', $data, true);
    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
    			$data['categoria'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$data['titulo_personal'] = 'Detalle de facturación acumulado mensual por producto';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_acumulado_factura_mensual_producto(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');

    	$categoria = $this->input->post('slcproducto_servicio');

    	$tipo = $this->input->post('tipo_reporte');
    	$where['fac_estado >'] = 0;
    	$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));

    	if(trim($categoria) != ""){
    		$where['art_id'] = $categoria;
    	}	
    	$group_by = "art_id, arf_id, fac_id_tpg";
    	$order_by = "tia_id, art_id, arf_id";
    	$data['facturas'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);
        // $group_by = null;
        // $order_by = "art_id, fac_id_tpg, arf_id";
        // $data['tipos_pago'] = $this->facturacion_model->get_factura_acumulado($where, $group_by, $order_by);
    	$data['tipo_reporte'] = $tipo;
    	$data['categoria'] = $categoria;
    	$data['textcategoria'] = $this->input->post('txtCategoria');
    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_acumulado_factura_mensual_producto', $data);
    	} else{
    		$data['titulo'] = 'facturación acumulado mensual por producto';
    		$data['header'] = $this->load->view('reporte/header', $data, true);
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_acumulado_factura_mensual_producto', $data, true);
    		$head = '<!DOCTYPE html><html><head><title>Reporte Facturación Mensual por Producto</title></head><body><script type="text/javascript">';
    		$head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Facturación Acumulado Mensual por Producto";';
    		$head .= 'window.print();</script>';
    		$footer = '</body></html>';
    		$reporte = $head.$html.$footer;
    		echo $reporte;die();
        	// $GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
        	// $this->pdf->makePdf($html, 'P', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_productos_facturacion($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_productos_facturacion');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array	= $_POST;
    				$producto 	= $post_array['productos'];
    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];
                    $bodega = $post_array['bodega'];
    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;
    				$where = null;
    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['date(fac_fecha_fact) >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['date(fac_fecha_fact) <='] = date('Y-m-d', strtotime($fecha_fin));
    				}
                    if($bodega != ""){
                        $where["def_id_bod"] = $bodega;
                    }
    				if (is_array($producto) && count($producto) > 0 ) {
    					$ids_art = implode(',', $producto);
    					$where["def_id_art in ($ids_art)"] = null;
    				} elseif (trim($producto) != "" && substr_count($producto, ',') > 0) {
    					$ids_art = trim($producto, ',');
    					$where["def_id_art in ($ids_art)"] = null;
    				} elseif (trim($producto) != "" && is_numeric($producto) && trim($producto) > 0) {
    					$ids_art = trim($producto);
    					$where["def_id_art in ($ids_art)"] = null;
    				}
    				$where["fac_estado != 0"] = null;
    				$data['muestra_cliente'] = ($post_array['chkInfo'] > 0) ? 1 : 0;
    				$data["label_cli_ven"] = ($post_array['chkInfo'] > 0) ? "Cliente" : "Vendedor";
    				$data['facturas'] = $this->facturacion_model->get_productos_facturacion($where);
                    $data['tipo_reporte'] = 'grid';
                    $html = $this->load->view('facturacion/reportes/imprimir_reporte_producto_facturacion', $data, true);
    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
                $slc_bd = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
    			$data['categoria'] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data['bodegas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_bd);
    			$data['titulo_personal'] = 'Reporte de productos por factura';
    			$this->_cargarvista($data);
    		}
    	}
    }

    public function componentes_factura($flag = null) {
    	satelite_validar();
    	$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/componentes_factura');
    	if ($_POST) {
    		$productos = $_POST['slcproducto_servicio'];
    		$fecha_ini = $_POST['txtFechaIni'];
    		$fecha_fin = $_POST['txtFechaFin'];
    		$tipo_repo = $_POST['tipo_reporte'];
    		$where = array("fac_estado > " => 0);
    		if ($fecha_ini != '') {
    			$where['DATE(fac_fecha_fact) >='] = formatear_fecha('Y-m-d', $fecha_ini);
    		}
    		if ($fecha_fin != '') {
    			$where['DATE(fac_fecha_fact) <='] = formatear_fecha('Y-m-d', $fecha_fin);
    		}
    		if (trim($productos) != "") {
    			$ids_art = trim($productos);
    			$where["cdf_id_art IN ($ids_art)"] = null;
    		}
    		$data['tipo_reporte'] = $tipo_repo;
    		$data['facturas'] = $this->facturacion_model->get_componentes_facturacion($where);
    		$html = $this->load->view('facturacion/reportes/detalle_reporte_componentes', $data, true);
    		if ($flag) {
    			echo json_encode(array('html' => $html, 'filas' => count($data['facturas'])));
    		} else {
    			if ($tipo_repo == 'pdf') {
    				$head = $this->load->view('reporte/header', array('titulo' => 'componentes'), true);
    				$reporte = $head . $html;
    				$this->pdf->makePDF($reporte,'P','','Letter');
    			} else {
    				echo $html;
    			}    			
    		}    		
    	} else {
    		// $slc_bd = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}', '', array('bod_estado' => 1), null, '', 'bod_id', true);
			// $data['bodegas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_bd);
    		// $select = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
    		// $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    		$data['titulo_personal'] = 'Reporte de componentes por factura';
    		$this->_cargarvista($data);
    	}
    }

    function imprimir_reporte_producto_facturacion(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');
        $bodega = $this->input->post('slc_bod');
    	$producto = $this->input->post('slcproducto_servicio');
    	$tipo = $this->input->post('tipo_reporte');
    	$where['DATE(fac_fecha_fact) >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['DATE(fac_fecha_fact) <='] = date('Y-m-d', strtotime($fecha_fin));
        if($bodega != ""){
            $where["def_id_bod"] = $bodega;
        }
    	if (is_array($producto) && count($producto) > 0 ) {
    		$ids_art = implode(',', $producto);
    		$where["def_id_art in ($ids_art)"] = null;
    	} elseif (trim($producto) != "" && substr_count($producto, ',') > 0) {
    		$ids_art = trim($producto);
    		$where["def_id_art in ($ids_art)"] = null;
    	} elseif (trim($producto) != "" && is_numeric($producto) && trim($producto) > 0) {
    		$ids_art = trim($producto);
    		$where["def_id_art in ($ids_art)"] = null;
    	}
    	$data['muestra_cliente'] = ($this->input->post('txt_info') > 0) ? 1 : 0;
    	$data["label_cli_ven"] = ($this->input->post('txt_info') > 0) ? "Cliente" : "Vendedor";
    	$data['facturas'] = $this->facturacion_model->get_productos_facturacion($where);
        $data['tipo_reporte'] = $tipo;
    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;
    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_producto_facturacion', $data);
    	} else{
    		$data['titulo'] = 'Productos por facturación';
    		$data['header'] = $this->load->view('reporte/header', $data, true);
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_producto_facturacion', $data, true);
            $header = '<!DOCTYPE html><html><head><title>REPORTE DE PRODUCTOS POR FACTURACION</title></head><body><script type="text/javascript">';
            $header .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - REPORTE DE PRODUCTOS POR FACTURACION";';
            $header .= 'window.print();</script>';
            $footer = '</body></html>';
            $reporte = $header . $html . $footer;
            echo $reporte;
            die();
    		// $GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
    		// $this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_facturas_detallado($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_facturas_detallado');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;
    				$documento 	= $post_array['documento'];
    				$cajero 	= $post_array['cajero'];
    				$tipo_pago  = $post_array['tipo_pago'];
                    $vendedor  = $post_array['vendedor'];
    				$estado  	= $post_array['estado'];
    				$fecha_inicio 	= $post_array['fecha_ini'];
    				$fecha_fin 		= $post_array['fecha_fin'];
    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;
    				$where = null;
    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['fac_fecha_fact >='] = date('Y-m-d H:i:s', strtotime($fecha_inicio." 00:00:00"));
    					$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}
    				if(trim($documento) != ""){
    					$where['fac_id_tif'] = $documento;
    				}
    				if(trim($tipo_pago) != "") {
    					$where['fac_id_tpg'] = $tipo_pago;
    				}
    				if(trim($estado) != "") {
    					$where['fac_estado']	= $estado;
    				}
    				if(trim($cajero) != "") {
    					$where['uxc_id_caj']	= $cajero;
    				}
                    if(trim($vendedor) != "") {
                        $where['fac_id_ven']    = $vendedor;
                    }
    				$data['facturas'] = $this->facturacion_model->get_facturas_detallado($where);
    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_facturas_detallado', $data, true);
    				echo $html;
    				die();
    			}
    		} else {
    			$caja = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}', '', array('caj_estado' => 1), null, '', 'caj_id', true);
    			$tpg = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
    			$tif = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1,'tif_aplica_venta' => 1), null, '', 'tif_id', true);                
                $vendedor = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
    			$data['cajas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $caja);
    			$data['tipo_pago'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tpg);
    			$data['tipo_factura'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tif);
    			$data['vendedores'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $vendedor);
    			$data['titulo_personal'] = 'Reporte de facturación detallado';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_facturas_detallado(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');
    	$documento = $this->input->post('slcDocumento');
    	$tipo_pago = $this->input->post('slcTipoPago');
    	$cajero    = $this->input->post('slcCaja');
    	$estado    = $this->input->post('slc_estado');
        $vendedor  = $this->input->post('slcVendedor');
    	$tipo = $this->input->post('tipo_reporte');
    	$where['fac_fecha_fact >='] = date('Y-m-d H:i:s', strtotime($fecha_ini." 00:00:00"));
    	$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    	if(trim($documento) != ""){
    		$where['fac_id_tif'] = $documento;
    	}
    	if(trim($tipo_pago) != "") {
    		$where['fac_id_tpg'] = $tipo_pago;
    	}
    	if(trim($estado) != "") {
    		$where['fac_estado']	= $estado;
    	}
    	if(trim($cajero) != "") {
    		$where['uxc_id_caj']	= $cajero;
    	}
        if(trim($vendedor) != "") {
            $where['fac_id_ven']    = $vendedor;
        }
        $data['facturas'] = $this->facturacion_model->get_facturas_detallado($where);
    	$data['tipo_reporte'] = $tipo;
    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;
    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_facturas_detallado', $data);
    	} else{
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_facturas_detallado', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Facturas_detallado' . date('dmY');
    		$header = '<!DOCTYPE html><html><head><title>REPORTE DE FACTURACION DETALLADO</title></head><body><script type="text/javascript">';
    		$header .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - REPORTE DE FACTURACION DETALLADO";';
    		$header .= 'window.print();</script>';
    		$footer = '</body></html>';
    		$reporte = $header . $html . $footer;
    		echo $reporte;
    		die();	        
	        // $this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_anticipos_pendientes($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_anticipos_pendientes');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;

    				$documento = $post_array['documento'];

    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];

    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;

    				$where = null;

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['anl_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['anl_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($documento) != ""){
    					$where['cli_id_tpc'] = $documento;
    				}
    				$where['anl_estado'] = 1;

    				$data['facturas'] = $this->facturacion_model->get_anticipos_pendientes($where);

    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_anticipos_pendientes', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('tpc_tipo_cliente', '{tpc_nombre}', '', array('tpc_estado' => 1), null, '', 'tpc_id', true);
    			$data['tipo_factura'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$data['titulo_personal'] = 'Reporte de anticipos pendientes';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_anticipos_pendientes(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');

    	$documento = $this->input->post('slcCliente');

    	$tipo = $this->input->post('tipo_reporte');

    	$data['label_cliente'] = $this->input->post('lbl_cat_cliente');

    	$where['anl_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
    	$where['anl_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));

    	if(trim($documento) != ""){
    		$where['cli_id_tpc'] = $documento;
    	}
    	$where['anl_estado'] = 1;

    	$data['facturas'] = $this->facturacion_model->get_anticipos_pendientes($where);
    	$data['tipo_reporte'] = $tipo;

    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_anticipos_pendientes', $data);
    	} else{
    		$data['titulo'] = 'anticipos pendientes';
    		$data['header'] = $this->load->view('reporte/header', $data, true);

    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_anticipos_pendientes', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
    		$this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    public function reporte_anticipos_detallado($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_anticipos_detallado');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;

    				$documento = $post_array['documento'];
    				$cliente = $post_array['cliente'];

    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];

    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;

    				$where = null;

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['ana_fecha >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['ana_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($documento) != ""){
    					$where['cli_id_tpc'] = $documento;
    				}
    				if(trim($cliente) != ""){
    					$where['cli_id'] = $cliente;
    				}

    				$where['ana_estado'] = 1;

    				$data['anticipos'] = $this->facturacion_model->get_anticipos_detallado($where);

    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_anticipos_detallado', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('tpc_tipo_cliente', '{tpc_nombre}', '', array('tpc_estado' => 1), null, '', 'tpc_id', true);
    			$data['tipo_factura'] = str_replace('<option value="0">Seleccione</option>', '', $select);

    			$select = '';
    			$clientes_reg = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado'=>1));
    			foreach ($clientes_reg as $key) {
    				if($key['cli_personeria'] == 1){
    					$select .= '<option value="'.$key['cli_id'].'">'.$key['cli_codigo'].' - '.trim($key['cli_nombre'].' '.$key['cli_apellido']).'</option>';
    				} else{
    					$select .= '<option value="'.$key['cli_id'].'">'.trim($key['cli_apellido']).'</option>';
    				}
    			}
    			$data['clientes'] = $select;

    			$data['titulo_personal'] = 'Reporte de anticipos detallado';
    			$this->_cargarvista($data);
    		}
    	}
    }

    function imprimir_reporte_anticipos_detallados(){
    	$fecha_ini = $this->input->post('txtFechaIni');
    	$fecha_fin = $this->input->post('txtFechaFin');

    	$documento = $this->input->post('slcCliente');
    	$cliente = $this->input->post('slcClientecli');

    	$tipo = $this->input->post('tipo_reporte');

    	if ($fecha_ini != '' && $fecha_fin != '') {
    		$where['ana_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
    		$where['ana_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    	}

    	if(trim($documento) != ""){
    		$where['cli_id_tpc'] = $documento;
    	}
    	if(trim($cliente) != ""){
    		$where['cli_id'] = $cliente;
    	}

    	$where['ana_estado'] = 1;

    	$data['anticipos'] = $this->facturacion_model->get_anticipos_detallado($where);
    	$data['tipo_reporte'] = $tipo;

    	$data['fecha_ini'] = $fecha_ini;
    	$data['fecha_fin'] = $fecha_fin;

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_anticipos_detallado', $data);
    	} else{
    		$data['titulo'] = 'anticipos detallado';
    		$data['header'] = $this->load->view('reporte/header', $data, true);

    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_anticipos_detallado', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
    		$this->pdf->makePdf($html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    /**
     * @author Habby Lovo;
     * @since 21/09/2017
 	*/

    public function reporte_caja($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_caja');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;
    				$caja = $post_array['caja'];
    				$text_caja = $post_array['txtcaja'];
    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];
    				$data['caja_id'] = $caja;
    				$data['caja_text'] = $text_caja;
    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;
    				$where = null;
    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}
    				if(trim($caja) != ""){
    					$where['uxc_id_caj'] = $caja;
    				}
    				$usuarios = $this->facturacion_model->get_factura_caja($where, 1);
    				$usuario_array = array();
    				$correlativos_array = array();
    				foreach ($usuarios as $key) {
    					$final = ($key['fin'] < 0) ? "Ilimitado" : $key['fin'];
    					$correlativos_array[] = $key['tif_nombre'].':'.$key['inicio'].'-'.$final;
    					$temp_usuario_array = explode(',', $key['empleados']);
    					if(count($temp_usuario_array) > 1){
    						foreach ($temp_usuario_array as $key2) {
    							$usuario_array[] = trim($key2);
    						}
    					} else{
    						$usuario_array[] = trim($key['empleados']);
    					}
    				}
    				$usuario_array = array_unique($usuario_array);
    				$usuario_array = implode(', ', $usuario_array);
    				$correlativos_array = implode(', ', $correlativos_array);
    				$data['usuarios_caja'] = $usuario_array;
    				$data['rangos_corr_caja'] = $correlativos_array;
    				$data['registros_facturaxcaja'] = $this->facturacion_model->get_factura_caja($where);
                    // print_r($this->db->last_query());die();
                    // die();
    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_caja', $data, true);
    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}', '', array('caj_estado' => 1), null, '', 'caj_id', true);
    			$data['cajas'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$data['titulo_personal'] = 'Reporte de caja';
    			$this->_cargarvista($data);
    		}
    	}
    }
    function imprimir_reporte_caja(){
    	$post_array = $_POST;
    	$caja = $post_array['rpt_slcCaja'];
    	$text_caja = $post_array['rpt_txtCaja'];
    	$fecha_inicio = $post_array['rpt_txtFechaIni'];
    	$fecha_fin = $post_array['rpt_txtFechaFin'];
    	$tipo = $post_array['tipo_reporte'];
    	$data['caja_id'] = $caja;
    	$data['caja_text'] = $text_caja;
    	$data['fecha_ini'] = $fecha_inicio;
    	$data['fecha_fin'] = $fecha_fin;
    	$data['tipo_reporte'] = $tipo;
    	$where = null;
    	if ($fecha_inicio != '' && $fecha_fin != '') {
    		$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
    		$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    	}
    	if(trim($caja) != ""){
    		$where['uxc_id_caj'] = $caja;
    	}
    	$usuarios = $this->facturacion_model->get_factura_caja($where, 1);
    	$usuario_array = array();
    	$correlativos_array = array();
    	foreach ($usuarios as $key) {
    		$final = ($key['fin'] < 0) ? "Ilimitado" : $key['fin'];
    		$correlativos_array[] = $key['tif_nombre'].':'.$key['inicio'].'-'.$final;
    		$temp_usuario_array = explode(',', $key['empleados']);
    		if(count($temp_usuario_array) > 1){
    			foreach ($temp_usuario_array as $key2) {
    				$usuario_array[] = trim($key2);
    			}
    		} else{
    			$usuario_array[] = trim($key['empleados']);
    		}
    	}
    	$usuario_array = array_unique($usuario_array);
    	$usuario_array = implode(', ', $usuario_array);
    	$correlativos_array = implode(', ', $correlativos_array);
    	$data['usuarios_caja'] = $usuario_array;
    	$data['rangos_corr_caja'] = $correlativos_array;
    	$data['registros_facturaxcaja'] = $this->facturacion_model->get_factura_caja($where);
    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_caja', $data);
    	} else{
    		$data['titulo'] = 'caja';
    		$encabezado = $this->load->view('reporte/header', $data, true);
    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_caja', $data, true);
    		$head = '<!DOCTYPE html><html><head><title>Reporte Cajas</title></head><body><script type="text/javascript">';
    		$head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Cajas";';
    		$head .= 'window.print();</script>';
    		$footer = '</body></html>';
    		$reporte = $head.$encabezado.$html.$footer;
    		echo $reporte;
	        // $GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');
	        // $this->pdf->makePdf($encabezado.$html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    /**
     * @author Habby Lovo;
     * @since 25/09/2017
 	*/

    public function reporte_totales_caja($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_totales_caja');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;

    				$caja = $post_array['caja'];
    				$text_caja     = $post_array['txtcaja'];
    				$sucursal      = ($post_array['sucursal'] != "")?$post_array['sucursal']:null;
    				$fecha_inicio  = $post_array['fecha_ini'];
    				$fecha_fin     = $post_array['fecha_fin'];

    				$data['caja_id'] = $caja;
    				$data['caja_text'] = $text_caja;
    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;
    				if($sucursal == null){
    					$sucursal = $this->gsatelite->get_campo('caj_caja', 'caj_id_suc', array('caj_id'=> $caja));
    				}
    				$data['sucursal']  = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id'=>$sucursal));

    				$where = null;

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($caja) != ""){
    					$where['uxc_id_caj'] = $caja;
    				}

    				if(trim($sucursal) != ""){
    					$where['fac_id_suc'] = $sucursal;
    				}
    				$usuarios = $this->facturacion_model->get_factura_caja($where, 1);

    				$usuario_array = array();
    				$correlativos_array = array();
    				foreach ($usuarios as $key) {
    					$correlativos_array[] = $key['tif_nombre'].':'.$key['inicio'].'-'.$key['fin'];
    					$temp_usuario_array = explode(',', $key['empleados']);
    					if(count($temp_usuario_array) > 1){
    						foreach ($temp_usuario_array as $key2) {
    							$usuario_array[] = trim($key2);
    						}
    					} else{
    						$usuario_array[] = trim($key['empleados']);
    					}
    				}


    				$usuario_array = array_unique($usuario_array);
    				$usuario_array = implode(', ', $usuario_array);
    				$correlativos_array = implode(', ', $correlativos_array);
			        //var_dump($correlativos_array);die();
    				$data['usuarios_caja'] = $usuario_array;
    				$data['rangos_corr_caja'] = $correlativos_array;
    				$data['registros_facturaxcaja'] = $this->facturacion_model->get_factura_caja($where);
    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_totales_caja', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}', '', array('caj_estado' => 1), null, '', 'caj_id', true);
    			$data['cajas'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', null, null, '', 'suc_id', true);
    			$data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '', $select);
    			$data['titulo_personal'] = 'Reporte de caja';
    			$this->_cargarvista($data);
    		}
    	}
    }
    function imprimir_reporte_totales_caja(){
    	$post_array = $_POST;

    	$caja       = $post_array['rpt_slcCaja'];
    	$text_caja  = $post_array['rpt_txtCaja'];
    	$fecha_inicio = $post_array['rpt_txtFechaIni'];
    	$fecha_fin  = $post_array['rpt_txtFechaFin'];
    	$tipo       = $post_array['tipo_reporte'];
    	$slcSucursal= ($post_array['slcSucursal'] != "")?$post_array['slcSucursal']:null;

    	$data['caja_id']   = $caja;
    	$data['caja_text'] = $text_caja;
    	$data['fecha_ini'] = $fecha_inicio;
    	$data['fecha_fin'] = $fecha_fin;
    	$data['tipo_reporte'] = $tipo;
    	$data['sucursal']  = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id'=>$slcSucursal));
    	$where = null;

    	if ($fecha_inicio != '' && $fecha_fin != '') {
    		$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
    		$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    	}

    	if(trim($caja) != ""){
    		$where['uxc_id_caj'] = $caja;
    	}

    	if(trim($slcSucursal) != ""){
    		$where['fac_id_suc'] = $slcSucursal;
    	}

    	$usuarios = $this->facturacion_model->get_factura_caja($where, 1);
    	$usuario_array = array();
    	$correlativos_array = array();
    	foreach ($usuarios as $key) {
    		$correlativos_array[] = $key['tif_nombre'].':'.$key['inicio'].'-'.$key['fin'];
    		$temp_usuario_array = explode(',', $key['empleados']);
    		if(count($temp_usuario_array) > 1){
    			foreach ($temp_usuario_array as $key2) {
    				$usuario_array[] = trim($key2);
    			}
    		} else{
    			$usuario_array[] = trim($key['empleados']);
    		}
    	}

    	$usuario_array = array_unique($usuario_array);
    	$usuario_array = implode(', ', $usuario_array);
    	$correlativos_array = implode(', ', $correlativos_array);
    	$data['usuarios_caja'] = $usuario_array;
    	$data['rangos_corr_caja'] = $correlativos_array;
    	$data['registros_facturaxcaja'] = $this->facturacion_model->get_factura_caja($where);

    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_totales_caja', $data);
    	} else{
    		$data['titulo'] = 'totales por caja';
    		$header = $this->load->view('reporte/header', $data, true);

    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_totales_caja', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');

	        //echo $html;
    		$this->pdf->makePdf($header.$html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    function historial_caja_cajero_excel(){
		//setlocale(LC_TIME, 'spanish');
    	$fecha_ini=$this->input->post('fecha_inicio');
    	$fecha_fin=$this->input->post('fecha_fin');
    	/*$cajero=$this->input->post('slcCajero');*/
    	$cajero = 0;
    	$id_caja=$this->input->post('caja');

    	if ($fecha_fin!='') {
    		$fecha_fn=date('Y-m-d', strtotime($fecha_fin));
    	}
    	if ($fecha_ini!='') {
    		$fecha_inicio=date('Y-m-d', strtotime($fecha_ini));
    	}

    	if($cajero>0){
    		$usu=$cajero;
    		$id_caja = $this->gsatelite->get_campo('uxc_usuarioxcaja','uxc_id_caj',array('uxc_id_usu'=>$usu, 'uxc_estado'=>1));
    	}
    	$data['cajero'] = $cajero;
    	$data['fecha']->ini = $fecha_ini;
    	$data['fecha']->fin = $fecha_fin;
    	$data['cajas']=$this->facturacion_model->historial_caja_cajero($fecha_inicio,$fecha_fn,$id_caja);
    	$this->load->view('facturacion/reportes/historial_caja_cajero_excel', $data);

    }

	/**
     * @author Francisco Orozco
     * @since 25/01/2018
     * @method Reportes por anticipos
	*/
	function anticiposxestado(){
		satelite_validar();
		$this->gsatelite->actualizar_array('anl_anticipo_cliente',array('anl_estado'=> 0),array('DATE(anl_fecha_vencimiento) <' => date('Y-m-d')));
		$clientes				= $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => 1), null, null, null, true);
		$data['clientes'] 		= str_replace('<option value="0">Seleccione</option>', '', $clientes);
		$data['titulo_personal']= 'Reporte de anticipos';
		$this->_cargarvista($data);
	}

	function reporte_anticiposxestado($flag = null){
		satelite_validar();
		if ($_POST){
			$post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {

            	$fecha_ini 		= ($post_array['fecha_ini'] != '') ? formatear_fecha('Y-m-d',$post_array['fecha_ini']) : null;
            	$fecha_fin 		= ($post_array['fecha_fin'] != '') ? formatear_fecha('Y-m-d',$post_array['fecha_fin']) : null;

            	$cliente        = ($post_array['cliente'] != '') ? $post_array['cliente'] : null;
            	$cliente_nombre	= ($post_array['nombre_cliente'] != '') ? $post_array['nombre_cliente'] : "Todos";

            	$estado       	= ($post_array['estado'] != '') ? $post_array['estado'] : null;
            	$estado_nombre	= ($post_array['nombre_estado'] != '') ? $post_array['nombre_estado'] : "Todos";
            } else {
            	$fecha_ini 		= ($post_array['filtro_inicio'] != '') ? formatear_fecha('Y-m-d',$post_array['filtro_inicio']) : null;
            	$fecha_fin 		= ($post_array['filtro_fin'] != '') ? formatear_fecha('Y-m-d',$post_array['filtro_fin']) : null;

            	$cliente 		= ($post_array['filtro_cliente'] != '') ? $post_array['filtro_cliente'] : null;
            	$cliente_nombre = ($post_array['filtro_cliente_nombre'] != '') ? $post_array['filtro_cliente_nombre'] : "Todos";

            	$estado        	= ($post_array['filtro_estado'] != '') ? $post_array['filtro_estado'] : null;
            	$estado_nombre	= ($post_array['filtro_estado_nombre'] != '') ? $post_array['filtro_estado_nombre'] : "Todos";
            }
        }

		//Tipo de Reportes si sera Excel o Pdf
        $tipo_reporte = $this->input->post('tipo_reporte');

        $where = array();
		//Se crean las condicionales del reporte
        if ($fecha_ini != '' && $fecha_fin != '') {
        	$where["DATE(anl_fecha) >="] 	= formatear_fecha('Y-m-d',$fecha_ini);
        	$where["DATE(anl_fecha) <="] 	= formatear_fecha('Y-m-d',$fecha_fin);
        	$data['fecha_inicio'] 			= formatear_fecha('d-m-Y',$fecha_ini);
        	$data['fecha_fin'] 				= formatear_fecha('d-m-Y',$fecha_fin);
        }

        if ($cliente != null) {
        	$where['anl_id_cli']    = $cliente;
        }

        $data['reporte'] 			= $this->facturacion_model->reporte_anticiposxestado($where, $estado);
        $data['estado_nombre']		= $estado_nombre;
        $data['cliente_nombre']		= $cliente_nombre;
        $data['tipo_reporte'] 		= $tipo_reporte;
        $filename 					= 'rpt_anticipos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename'] 			= $filename;
        $data['cantidad_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');

        if ( $data['cantidad_decimales'] == "" or $data['cantidad_decimales'] == null ){
        	$data['cantidad_decimales'] = 2;
        }


        $html = $this->load->view('facturacion/reportes/reporte_anticiposxestado', $data, true);

        if ($flag) {
        	echo $html;
        	die();
        } else {
        	if ($tipo_reporte == 'pdf') {

        		$data['titulo'] = 'Anticipos';

        		$header = $this->load->view('reporte/header', $data, true);

        		$GLOBALS['nombre_reporte'] = 'Reporte_anticipos' . date('dmY');

        		$reporte = $header . $html;

        		$this->pdf->makePdf($reporte, 'L', 'Reporte_anticipos', 'Letter');
        	} elseif ($tipo_reporte == 'excel') {

        		$filename = 'rpt_anticipoS?' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

        		$data['titulo'] = 'anticipos';

        		$data['filename'] = $filename;

        		echo $html;
        	}
        }
    }

	/**
    * @author Habby Lovo
    * @since 2018-02-12
    * @return reporte consolidado de facturas por proyecto
    */
	public function consolidado_factura_proyecto($consulta=0){
		satelite_validar();
		$data['permisos'] = $this->gsatelite->get_permisos_opcion();
		if ($_POST) {
			if ($consulta > 0) {
				$post_array = $_POST;

				$fecha_ini = $post_array['fecha_ini'];
				$fecha_fin = $post_array['fecha_fin'];
				$cliente = $post_array['cliente'];
				$proyecto = $post_array['proyecto'];
				$estado = $post_array['estado'];

                //$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
				$data['fecha_ini']  = $fecha_ini;
				$data['fecha_fin']  = $fecha_fin;
				$data['cliente_id']  = $cliente;
				$data['proyecto']  = $proyecto;
				$data['estado']   = $estado;

				$where = null;

				if ($fecha_ini != '' && $fecha_fin != '') {
					$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_ini));
					$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
				}

				if(trim($cliente) != ""){
					$where['cli_id'] = $cliente;
				}
				if(trim($proyecto) != ""){
					$where['pcl_id'] = $proyecto;
				}
				if(trim($estado) != ""){
					$where['pcl_id_epr'] = $estado;
				}

				$proyectos = $this->facturacion_model->get_factura_proyecto($where);

				$data['proyectos'] = $proyectos;
				$data['tipo_reporte'] = 'grid';
				$html = $this->load->view('facturacion/reportes/grid_consolidado_factura_proyecto', $data, true);
				echo $html;
				die();
			}
		} else {
			$cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
			$est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
			$data['clientes'] = $cli;
			$data['estados'] = $est;
			$data['titulo_personal'] = "Consolidado de facturas por proyecto";
			cargarvista($data);
		}
	}

	public function imprimir_consolidado_factura_proyecto(){
		$post_array = $_POST;

		$fecha_ini = $post_array['rpt_txtFechaIni'];
		$fecha_fin = $post_array['rpt_txtFechaFin'];
		$cliente = $post_array['rpt_cliente'];
		$proyecto = $post_array['rpt_proyecto'];
		$estado = $post_array['rpt_estado'];
		$tipo = $post_array['rpt_tipo'];

		$data['fecha_ini']  = $fecha_ini;
		$data['fecha_fin']  = $fecha_fin;
		$data['cliente_id']  = $cliente;
		$data['proyecto']  = $proyecto;
		$data['estado']   = $estado;

		$where = null;

		if ($fecha_ini != '' && $fecha_fin != '') {
			$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_ini));
			$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
		}

		if(trim($cliente) != ""){
			$where['cli_id'] = $cliente;
		}
		if(trim($proyecto) != ""){
			$where['pcl_id'] = $proyecto;
		}
		if(trim($estado) != ""){
			$where['pcl_id_epr'] = $estado;
		}

		$proyectos = $this->facturacion_model->get_factura_proyecto($where);

		$data['proyectos'] = $proyectos;
		$data['tipo_reporte'] = $tipo;

		if($tipo == 'excel'){
			$filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['filename'] = $filename;
			$this->load->view('facturacion/reportes/grid_consolidado_factura_proyecto', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
		} else{
			$this->load->library('pdf');
			$data['titulo'] = 'Listado de facturas por proyecto';
			$data['solotitulo'] = '1';

			$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('facturacion/reportes/grid_consolidado_factura_proyecto', $data, true);
			$GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

			$this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
		}
	}

    /**
    * @author Habby Lovo
    * @since 2018-02-12
    * @return reporte detallado de factura por proyecto
    */
    public function detallado_factura_proyecto($consulta=0){
    	satelite_validar();
    	$data['permisos'] = $this->gsatelite->get_permisos_opcion();
    	if ($_POST) {
    		if ($consulta > 0) {
    			$post_array = $_POST;

    			$fecha_ini = $post_array['fecha_ini'];
    			$fecha_fin = $post_array['fecha_fin'];
    			$cliente = $post_array['cliente'];
    			$proyecto = $post_array['proyecto'];
    			$factura = $post_array['factura'];
    			$estado = $post_array['estado'];

                //$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
    			$data['fecha_ini']  = $fecha_ini;
    			$data['fecha_fin']  = $fecha_fin;
    			$data['cliente_id']  = $cliente;
    			$data['proyecto']  = $proyecto;
    			$data['factura']  = $factura;
    			$data['estado']   = $estado;

    			$where = null;

    			if ($fecha_ini != '' && $fecha_fin != '') {
    				$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_ini));
    				$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    			}

    			if(trim($cliente) != ""){
    				$where['fac_id_cli'] = $cliente;
    			}
    			if(trim($proyecto) != ""){
    				$where['pcl_id'] = $proyecto;
    			}
    			if(trim($factura) != ""){
    				$where['fac_id'] = $factura;
    			}
    			if(trim($estado) != ""){
    				$where['pcl_id_epr'] = $estado;
    			}

    			$proyectos = $this->facturacion_model->get_detalle_factura_proyecto($where);

    			$data['proyectos'] = $proyectos;
    			$data['tipo_reporte'] = 'grid';
    			$html = $this->load->view('facturacion/reportes/grid_detallado_factura_proyecto', $data, true);
    			echo $html;
    			die();
    		}
    	} else {
    		$cli = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' =>1));
    		$est = $this->gsatelite->get_tabla('epr_estado_proyecto',array('epr_estado' =>1));
    		$data['clientes'] = $cli;
    		$data['estados'] = $est;
    		$data['titulo_personal'] = "Consolidado de facturas por proyecto";
    		cargarvista($data);
    	}
    }

    public function imprimir_detallado_factura_proyecto(){
    	$post_array = $_POST;

    	$fecha_ini = $post_array['rpt_txtFechaIni'];
    	$fecha_fin = $post_array['rpt_txtFechaFin'];
    	$cliente = $post_array['rpt_cliente'];
    	$proyecto = $post_array['rpt_proyecto'];
    	$factura = $post_array['rpt_factura'];
    	$estado = $post_array['rpt_estado'];
    	$tipo = $post_array['rpt_tipo'];

    	$data['fecha_ini']  = $fecha_ini;
    	$data['fecha_fin']  = $fecha_fin;
    	$data['cliente_id']  = $cliente;
    	$data['proyecto']  = $proyecto;
    	$data['factura']  = $factura;
    	$data['estado']   = $estado;

    	$where = null;

    	if ($fecha_ini != '' && $fecha_fin != '') {
    		$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_ini));
    		$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    	}

    	if(trim($cliente) != ""){
    		$where['fac_id_cli'] = $cliente;
    	}
    	if(trim($proyecto) != ""){
    		$where['pcl_id'] = $proyecto;
    	}
    	if(trim($factura) != ""){
    		$where['fac_id'] = $factura;
    	}
    	if(trim($estado) != ""){
    		$where['pcl_id_epr'] = $estado;
    	}

    	$proyectos = $this->facturacion_model->get_detalle_factura_proyecto($where);

    	$data['proyectos'] = $proyectos;
    	$data['tipo_reporte'] = $tipo;

    	if($tipo == 'excel'){
    		$filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/grid_detallado_factura_proyecto', $data);
            //$this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
    	} else{
    		$this->load->library('pdf');
    		$data['titulo'] = 'Listado de facturas por proyecto';
    		$data['solotitulo'] = '1';

    		$header = $this->load->view('reporte/header', $data, true);
    		$html = $this->load->view('facturacion/reportes/grid_detallado_factura_proyecto', $data, true);
    		$GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

    		$this->pdf->makePdf($header.$html, 'L', 'rpt_listado_proyectos', 'Letter');
    	}
    }

    public function get_facturas_proyecto(){
    	$pro_id = $this->input->post('proyecto');
    	$opciones = '';
    	$eta_pro = $this->facturacion_model->get_estado_proyecto_cliente(array('pcl_id' => $pro_id));
    	foreach ($eta_pro as $key) {
    		$opciones .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
    	}
    	$opciones_ordenes = '<option value=""></option>';
    	$facturas_reg = $this->gsatelite->get_tabla('fac_factura', array('fac_id_pcl'=>$pro_id));
    	foreach ($facturas_reg as $key) {
    		$opciones_ordenes .= '<option value="' . $key["fac_id"] . '">' . $key["fac_numero"] . '</option>';
    	}
    	echo json_encode(array('resp' => $opciones, 'facturas' => $opciones_ordenes));
    }

    /**
    * @author Edith Herrera - Grupo Satélite
    * @since  2018-04-05
    * Reporte de ventas por hora.
    **/

    public function ventas_hora(){
    	satelite_validar();
    	if($_POST){
    		$fecha_ini	= $this->input->post('fecha_ini');
    		$fecha_fin	= $this->input->post('fecha_fin');
    		$hora_ini   = $this->input->post('hora_ini');
    		$hora_fin   = $this->input->post('hora_fin');
    		$sucursal   = $this->input->post('sucursal');
    		$caja       = $this->input->post('caja');
    		$tipo		= ($this->input->post('tipo') != '') ? $this->input->post('tipo') : null;
    		$where 		= null;
    		$groupby    = null;
    		$orderby    = null;
    		if (trim($fecha_ini) != '') {
    			$fecha_inicio    = date('Y-m-d', strtotime($fecha_ini));
    			$hora_ini        = date('H:i:s', strtotime($hora_ini));
    			$where['fac_fecha_fact >='] = $fecha_inicio . ' '.$hora_ini;
    		}
    		if (trim($fecha_fin) != '') {
    			$fecha_fn = date('Y-m-d', strtotime($fecha_fin));
    			$hora_fn  = date('H:i:s', strtotime($hora_fin));
    			$where['fac_fecha_fact <='] = $fecha_fn . ' '.$hora_fn;
    		}
    		if (trim($tipo) != null) {
    			$where['fac_id_tif'] = $tipo;
                // Comentado ya que se reestructuro la consulta
                // $groupby = 'DATE_FORMAT(fac_fecha_crea, ("%H")), tif_id';
    		} else {
                // Comentado ya que se reestructuro la consulta
                // $groupby = 'DATE_FORMAT(fac_fecha_crea, ("%H"))';
    		}
    		if (trim($sucursal) != null) {
    			$where['suc_id'] = $sucursal;
    		}

    		if (trim($caja) != null) {
    			$where['caj_id'] = $caja;
    		}
    		$where['fac_estado > 0'] = null;
            // Agrupador
    		$groupby = 'caj_id, suc_id';
            // Forma de ordenar
    		$orderby = 'suc_id';
    		$facturas = $this->facturacion_model->get_venta_x_hora($where, $groupby, $orderby);
			// print_r($this->db->last_query());die();	
			// die(print_r($facturas));
    		$data['detalles'] = $this->facturacion_model->get_venta_x_hora($where, $groupby, $orderby);

    		$html = $this->load->view('facturacion/reportes/detalle_ventas_hora', $data, true);

    		echo $html;
    		die();
    	}
    	/**********************************************************************************************/
    	$tipos    = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1, 'tif_aplica_venta' => 1), null, '', 'tif_id', true);
    	$cajas    = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}','', null, null, '', 'caj_id', true);
    	$sucursal = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', null, null, '', 'suc_id', true);
    	$data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal);
    	$data['cajas']      = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cajas);
    	$data["tipos"]      = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipos);
    	/**********************************************************************************************/
    	$data["titulo_personal"] 	= "Ventas por hora";
    	$this->_cargarvista($data);
    }



    function imprimir_ventas_hora($export){
    	satelite_validar();
    	if ($this->input->post()) {
    		$fecha_ini  = $this->input->post('fecha_inicio');
    		$fecha_fin  = $this->input->post('fecha_fin');
    		$hora_ini   = $this->input->post('txtHoraIni');
    		$hora_fin   = $this->input->post('txtHoraFin');
    		$sucursal   = $this->input->post('slc_sucursal');
    		$caja       = $this->input->post('slc_cajas');
    		$tipo       = ($this->input->post('slc_tipo')!='')?$this->input->post('slc_tipo'):null;
    		$where      = null;
    		$groupby    = null;
    		$orderby    = null;
    		if (trim($fecha_ini) != '') {
    			$fecha_inicio    = date('Y-m-d', strtotime($fecha_ini));
    			$hora_ini        = date('H:i:s', strtotime($hora_ini));
    			$where['fac_fecha_fact >='] = $fecha_inicio . ' '.$hora_ini;
    		}
    		if (trim($fecha_fin) != '') {
    			$fecha_fn = date('Y-m-d', strtotime($fecha_fin));
    			$hora_fn  = date('H:i:s', strtotime($hora_fin));
    			$where['fac_fecha_fact <='] = $fecha_fn . ' '.$hora_fn;
    		}
    		if (trim($tipo) != null) {
    			$where['fac_id_tif'] = $tipo;
                // Comentado ya que se reestructuro la consulta
                // $groupby = 'DATE_FORMAT(fac_fecha_crea, ("%H")), tif_id';
    		} else {
                // Comentado ya que se reestructuro la consulta
                // $groupby = 'DATE_FORMAT(fac_fecha_crea, ("%H"))';
    		}
    		if (trim($sucursal) != null) {
    			$where['suc_id'] = $sucursal;
    		}
    		if (trim($caja) != null) {
    			$where['caj_id'] = $caja;
    		}
    		$where['fac_estado > 0'] = null;
            // Agrupador
    		$groupby = 'caj_id, suc_id';
            // Forma de ordenar
    		$orderby = 'suc_id';
    		$data['detalles'] = $this->facturacion_model->get_venta_x_hora($where, $groupby, $orderby);
            // die(print_r($data['detalles']));
    		if($export==1){
    			$this->load->library('pdf');
    			$html=$this->load->view('reporte/header', array('titulo' => 'Ventas por hora', 'solotitulo' => true, 'subtitulo'=> ''), true);
    			$html.=$this->load->view('facturacion/reportes/imprimir_venta_hora', $data, true);
    			$this->pdf->makePDF($html,'L');
    		}else{
    			$data['excel'] = 1;
    			$this->load->view('facturacion/reportes/imprimir_venta_hora', $data);
    		}
    	}
    }

    function facturas_reporte($export = 0) {
    	ini_set( 'memory_limit', '2048M' );
    	ini_set('max_execution_time', '9999');		
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
         	// 	$consulta_factura = $this->facturacion_model->get_facturas();
    		$clientes = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => 1), null, '', 'cli_id', true);
    		$data["clientes"] = str_replace('<option value="0">Seleccione</option>', '',$clientes);
    		$vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}','', array('ven_estado' => '1'), null, '', 'ven_id', true);
    		$data["vendedores"] = str_replace('<option value="0">Seleccione</option>', '',$vendedores);
    		$data["titulo_personal"] = "Facturas procesadas";
    		cargarvista($data, null, 'facturacion/consultas/facturas');
    	}
    }

    function aplica_anulacion($id){
    	$fecha = date('Y-m-d');
    	$motivo = $this->input->post("justificar_anulacion");
    	$num_fac = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $id));
    	$num_fac = (count($num_fac) > 0) ? $num_fac[0]['fac_numero'] : '';
    	// Verificar si NO hubo descarga
    	$factura = $this->gsatelite->get_registro('mxf_movimientoxfact',array('mxf_id_fac'=>$id, 'mxf_estado'=>1));


    	if(count($factura)>0){

			//$proceso = $this->gsatelite->get_campo('tip_tipo_proceso','tip_id',array('tip_entrada_fac'=>1)); // Proceso que se le pondra
    		$proceso = $this->gsatelite->get_campo('tip_tipo_proceso','tip_id_tip_entrada',array('tip_facturacion'=>1,'tip_estado'=>1));

    		$bodega =  $this->gsatelite->get_campo('moi_movimiento_inv','moi_id_bod', array('moi_id'=>$factura->mxf_id_moi));
    		$producto_fila = $this->gsatelite->get_registro('dee_detalle_mov', array('dee_id_moi'=>$factura->mxf_id_moi));
    		$array = json_decode(json_encode($producto_fila), true);
    		$producto = array();
    		$cantidad = array();
    		$datos = array();

    		if(count($producto_fila)==1){
    			$producto[] = $array['dee_id_art'];
    			$cantidad[] = $array['dee_cantidad'];
    		} else {
    			foreach ($array as $key => $value) {
    				$producto[] = $value['dee_id_art'];
    				$cantidad[] = $value['dee_cantidad'];
    			}
    		}
    		$datos[] = $producto;
    		$datos[] = $cantidad;
    		$datos[] = $bodega;
    		$datos[] = $id;

    		$this->ingresar_productos_movimiento(true, $datos, $proceso, $motivo, $id);
    	} else {
      /* ======================================================================================================
                                Inicio Partida contable para la anulacion de factura
                                =========================================================================================================*/
                                $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
                                if($generar_partida > 0){
                                	$where['fac_id'] = $id;
                                	$info['num_fac'] = $num_fac;
                //$res_debe = $this->generar_partida_anular_factura_afecta_noafecta_inv_debe($where,$info);
                //$this->generar_partida_anular_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_debe']);

                //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida
                //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                //$this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct_anulacion' => $res_debe['id_pct']),array('fac_id' => $id));
            	//Esta es una instancion del controlador de facturar para poder hacer uso del metodo
                                	$this->load->library('../controllers/facturacion/facturar');
                                	$this->facturar->generar_partida_anulacion_facturacion_contabilidad($where, $info);
            	//$this->generar_partida_anulacion_facturacion_contabilidad($where, $info);
                                }

      /* ======================================================================================================
                          Fin Partida contable para la anulacion de factura
                          =========================================================================================================*/
			$this->facturacion_model->anular_factura($id, $fecha, $motivo);  // No hubo descarga
		}

		$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Actualización de estado",'texto_alerta'=>"Se modificó el estado de la factura exitosamente");

		$this->session->set_flashdata($alerta);
		redirect('facturacion/reportes/facturas_reporte');
	}

	function precios_ventas () {
		satelite_validar();
		$permisos = $this->gsatelite->get_permisos_opcion();

		if($this->input->post()) {
			$post_array     = $this->input->post();

			$fecha_inicio    = ($post_array['txtFechaIni'] != '' )? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
			$fecha_fin       = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;
			$producto        = ($post_array['producto'] != '') ? $post_array['producto'] : null;
			$slc_lista_precio= ($post_array['slc_lista_precio'] != '') ? $post_array['slc_lista_precio'] : null;

            // Condicionales para la consulta
			$where      = null;
			$groupby    = null;
			$orderby    = null;

			if (trim($fecha_fin) != '') {
				$fecha_fn = date('Y-m-d', strtotime($fecha_fin));
				$where['fac_fecha_fact <='] = $fecha_fn . ' 23:00:00';
			}

			if (trim($fecha_inicio) != '') {
				$fecha_inicio    = date('Y-m-d', strtotime($fecha_inicio));
				$where['fac_fecha_fact >='] = $fecha_inicio . ' 00:00:00';
			}

			if ($producto != '') {
				$where['art_id'] = $producto;
			}

			if ($slc_lista_precio != '') {
				$where['tlp_id'] = $slc_lista_precio;
			}

			$groupby = 'art_id';

			$data['detalles']       = $this->facturacion_model->get_preciosxventas($where, $groupby, $orderby);

			$tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
			$data["tipo_reporte"]   = $tipo_reporte;
			$filename                   = 'Reporte_precios_ventas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['titulo']             = 'Precios de Ventas';
			$data['filename']           = $filename;
			$html = $this->load->view('facturacion/reportes/consultar_precios_ventas', $data, true);

			if ($tipo_reporte == '') {
				$data2['html'] = $html;
				echo json_encode($data2);
				die();
			} elseif ($tipo_reporte == 'pdf') {
				$data['titulo']             = 'Precios de Ventas';
				$header                     = $this->load->view('reporte/header', $data, true);
				$GLOBALS['nombre_reporte']  = 'Reporte_precios_ventas_' . date('dmY');
				$reporte                    = $header . $html;
				$this->pdf->makePdf($reporte, 'L', 'Reporte_precios_ventas_', 'Letter');
			} elseif ($tipo_reporte == 'excel') {
				echo $html;
			}
		} else {
			$lista_precios = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', null, null, '', 'tlp_id', true);
			$data['lista_precios'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $lista_precios);
			$data['titulo_personal']    = 'Reporte de Precios de Ventas';
			cargarvista($data);
		}
	}

    /**
     * Descripción:
     * Función de consulta de facturas
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-06-15
     * @param  Ninguno
     * @return Consulta de facturas según cajero en sesión
     */
    function facturas_caja() {
    	// ini_set( 'memory_limit', '2048M' );
    	ini_set('max_execution_time', '9999');
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		// $consulta_factura = $this->facturacion_model->get_facturas();
    		// $clientes = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado' => '1'), null, '', 'cli_id', true);
    		// $data["clientes"] = str_replace('<option value="0">Seleccione</option>', '',$clientes);
    		// FILTRO CLIENTES SE SUSTITUYO POR UN AJAX
    		$vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}','', array('ven_estado' => '1'), null, '', 'ven_id', true);
    		$data["vendedores"] = str_replace('<option value="0">Seleccione</option>', '',$vendedores);
    		$data["titulo_personal"] = "Facturas procesadas";
    		cargarvista($data, null, 'facturacion/consultas/facturas_caja');
    	}
    }

    /**
     * Descripción:
     * Reporte de proyección de ventas
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-06-19
     * @param  Ninguno
     * @return Registros por cajas.
     */
    /**
     * Descripción: Actualizacion
     * Reporte de proyección de ventas
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-11-28
     * @param  Ninguno
     * @return Registros por cajas.
     */
    public function proyeccion_venta() {
    	satelite_validar();
    	if ($this->input->post()) {
    		$tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
    		if ($tipo_reporte != null) {
            	//envio del submit
    			$periodo  = (trim($this->input->post('filtro_periodo')) != "") ? $this->input->post('filtro_periodo') : null;
    			$caja     = (trim($this->input->post('filtro_caja')) != "") ? $this->input->post('filtro_caja') : null;
    			$sucursal = ($this->input->post('filtro_sucu') > 0) ? $this->input->post('filtro_sucu') : null;
    		} else {
            	//envio desde ajax
    			$periodo  = $this->input->post('periodo');
				$caja     = $this->input->post('caja'); // multiselect
				$sucursal = $this->input->post('sucursal');
			}
            // Meses
			$meses = array('Enero'=> 1,'Febrero'=> 2,'Marzo'=> 3,'Abril'=> 4,'Mayo'=> 5,'Junio'=> 6, 'Julio'=> 7, 'Agosto'=> 8, 'Septiembre'=> 9, 'Octubre'=> 10, 'Noviembre'=> 11, 'Diciembre'=> 12);
			$meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');
			/***************************** CONSULTA *****************************************/
			$where = null;
			if ($periodo != '') {
		        // Dividir y obtener el mes y anio
				$fecha = explode('-', $periodo);
				$fecha_date = $fecha[1]."-".$meses[$fecha[0]];
				$fecha_date = formatear_fecha('Y-m', $fecha_date);   		
			}
			// Obtener el primer y ultimo dia del mes
			$inicio = date('Y-m-d', strtotime("{$fecha_date}"));
			$dateIni = date('Y-m', strtotime("{$fecha_date}"));
			$actual = date('Y-m');
			if($dateIni == $actual){
				//Si el mes es el actual la fecha fin debe ser la fecha actual 
				$fin = date('Y-m-d');
			}else{
				//Si el mes es menor al actual entonces la fecha fin debe ser el ultimo dia del mes
				$fin    = date('Y-m-t', strtotime("{$fecha_date}"));
			}
			// Se filtra las cajas seleccionadas
			$caja_id = null;
			if ($caja != '' && $caja != 'null'){
				$cajas = $caja;
				if(is_array($cajas) && $cajas[0]!=''){
					if($cajas[0]!='todas'){
						$this->db->where_in('caj_id', $cajas);
					}
				}else{
					if($caja_id>0){
						$caja_id = $cajas;
					}
				}
			}
			
			$data['registros'] = $this->facturacion_model->proyeccion_cajas($caja_id, $inicio, $fin, $sucursal, 'DAY(fac_fecha_fact)');			
			if ($caja != '' && $caja != 'null'){
				$cajas = $caja;
				if(is_array($cajas) && $cajas[0]!=''){
					if($cajas[0]!='todas'){
						$this->db->where_in('caj_id', $cajas);
					}
				}else{
					if($caja_id>0){
						$caja_id = $cajas;
					}
				}
			}
			$data['inicio'] = $inicio;
			$data['fin'] = $fin;
			$data['ndias'] = date( "t", strtotime( $inicio ));
			$data['detalle'] = $this->facturacion_model->proyeccion_cajas($caja_id, $inicio, $fin, $sucursal, 'caj_id');
			/****************************************************************************************************** */
			$data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Proyecciones de venta'), true);
			$data['tipo_reporte'] = $tipo_reporte;
			if ($tipo_reporte != '') {
				switch ($tipo_reporte) {
					case 'pdf':
					$data['titulo'] = 'Proyecciones de venta';
					$html = $this->load->view('facturacion/reportes/export_proyeccion_ventas', $data, true);
					$this->pdf->makePdf($html, 'L', 'conteos', 'A4');
					break;
					case 'excel':
					$filename = 'rpt_proyecciones_venta' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
					$data['titulo'] = ' proyecciones de venta';
					$data['filename'] = $filename;
					$data['excel'] = 1;

					$html = $this->load->view('facturacion/reportes/export_proyeccion_ventas', $data, true);
					echo $html;
					break;
				}
			}else{
				$html = $this->load->view('facturacion/reportes/detalle_proyeccion_venta', $data, true);
				echo json_encode(array('resultado' => $html, 'periodo'=>$periodo, 'caja'=>$caja, 'sucursal' => $sucursal));
			}
		}else{
			$cajas = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}','', null, null, '', 'caj_id', true);
			$data['cajas'] = str_replace('<option value="0">Seleccione</option>', '', $cajas);
			
			$sucursales = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, '', 'suc_id', true);
			$data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '', $sucursales);

			$data["titulo_personal"] ="Proyecciones de venta";
			$this->_cargarvista($data);
		}
	}



    /**
     * Descripción:
     * Reporte de ordenes de venta
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-02
     * @param  Ninguno
     * @return Ordenes de venta.
     */
    public function ordenes_venta() {
    	satelite_validar();
    	if ($this->input->post()) {
    		$tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';

    		if ($tipo_reporte != null) {
    			$fecha_inicio = ($this->input->post('filtro_inicio') > 0) ? $this->input->post('filtro_inicio') : null;
    			$fecha_fin = ($this->input->post('filtro_fin') > 0) ? $this->input->post('filtro_fin') : null;
    			$estado = ($this->input->post('filtro_estado') > 0) ? $this->input->post('filtro_estado') : null;
    		} else {
    			$fecha_inicio = $this->input->post('inicio');
    			$fecha_fin = $this->input->post('fin');
    			$estado  = $this->input->post('estado');
    		}
    		/***************************** CONSULTA *****************************************/
    		$where = array();
    		if ($fecha_inicio != '' && $fecha_fin != '') {
    			$where['orv_fecha_orden >='] = date('Y-m-d', strtotime($fecha_inicio));
    			$where['orv_fecha_orden <='] = date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59"));
    		}

    		if($estado > 0){
    			$where['orv_estado'] = $estado;
    		}

    		$data['registros'] = $registros = $this->facturacion_model->get_ordenes_venta($where);
    		/* ********************************************************************************** */
    		$data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Ordenes de venta'), true);

    		$data['tipo_reporte'] = $tipo_reporte;
    		if ($tipo_reporte != '') {
    			switch ($tipo_reporte) {
    				case 'pdf':
    				$data['titulo'] = 'Ordenes de venta';
    				$html = $this->load->view('facturacion/reportes/export_ordenes_venta', $data, true);
    				$this->pdf->makePdf($html, 'L', 'conteos', 'A4');
    				break;
    				case 'excel':
    				$filename = 'rpt_ordenes_venta' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    				$data['titulo'] = ' ordenes de venta';
    				$data['filename'] = $filename;
    				$data['excel'] = 1;

    				$html = $this->load->view('facturacion/reportes/export_ordenes_venta', $data, true);
    				echo $html;
    				break;
    			}
    		}else{
    			$html = $this->load->view('facturacion/reportes/detalle_ordenes_venta', $data, true);
    			echo json_encode(array('resultado' => $html, 'inicio'=>$fecha_inicio, 'fin'=>$fecha_fin, 'estado'=>$estado));
    		}
    	}else{
    		$cajas = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}','', null, null, '', 'caj_id', true);
    		$data['cajas'] = str_replace('<option value="0">Seleccione</option>', '', $cajas);
    		$data["titulo_personal"] ="Ordenes de venta";
    		$this->_cargarvista($data);
    	}
    }

    /**
     * Descripción:
     * Función para las listas de precios de ventas por productos.
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-07-25
     * @param  Ninguno
     * @return Registros listas de precios de ventas por productos.
     */
    function rpt_listas_precios(){
    	satelite_validar();
    	if ($this->input->post()) {
    		$tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';
    		$where = array();
    		if ($tipo_reporte != null) {
    			$cliente = $this->input->post('filtro_cliente');
    			$categoria = ($this->input->post('filtro_categoria') != '') ? $this->input->post('filtro_categoria') : null;
    			$producto = ($this->input->post('filtro_producto') != '') ? $this->input->post('filtro_producto') : null;
    			$lista = ($this->input->post('filtro_lista') > 0) ? $this->input->post('filtro_lista') : null;
    			if ($lista != "") {
    				$where['tlp_id in ('.$lista.')']= null;
    			}
    		} else {
    			$lista = $this->input->post('lista');
    			$cliente = $this->input->post('cliente');
    			$producto = $this->input->post('producto');
    			$categoria = $this->input->post('categoria');
    			if (is_array($lista) && count($lista) > 0) {
    				$ids = implode(',', $lista);
    				$where["tlp_id IN ($ids)"] = null;
    			}
    		}
    		if ($categoria > 0) {
    			$where['tia_id'] = $categoria;
    		}
    		if ($producto > 0) {
    			$where['art_id'] = $producto;
    		}
    		if ($cliente > 0) {
    			$where["tlp_id IN (SELECT tpn_id_tlp FROM tpn_tipo_precio_cliente WHERE tpn_estado = 1 AND tpn_id_cli = $cliente)"] = null;
    		}
    		$data['empresa'] = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
    		$data['registros'] = $this->facturacion_model->get_listado_precio($where);
    		$numfila = count($data['registros']);
    		$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
    		/****************************************************************************************************** */
    		$data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Lista de precios'), true);
    		$data['tipo_reporte'] = $tipo_reporte;
    		if ($tipo_reporte != '') {
    			switch ($tipo_reporte) {
    				case 'pdf':
    				$data['titulo'] = 'Lista de precios';
    				$html = $this->load->view('facturacion/reportes/rpt_lista_precio_export', $data, true);
    				$head = '<!DOCTYPE html><html><head><title>Listas de precios</title></head><body><script type="text/javascript">';
    				$head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Listas de precios";';
    				$head .= 'window.print();</script>';
    				$footer = '</body></html>';
    				$reporte = $head . $html . $footer;
    				echo $reporte;
                        // $this->pdf->makePdf($html, 'L', 'conteos', 'A4');
    				break;
    				case 'excel':
    				$filename = 'rpt_lista' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    				$data['titulo'] = ' Reporte de lista de precios';
    				$data['filename'] = $filename;
    				$data['excel'] = 1;
    				$html = $this->load->view('facturacion/reportes/rpt_lista_precio_export', $data, true);
    				echo $html;
    				break;
    			}
    		}else{
    			$html = $this->load->view('facturacion/reportes/detalle_lista_precio', $data, true);
    			echo json_encode(array('resultado' => $html,'categoria'=>$categoria, 'producto'=>$producto, 'lista'=>$lista, 'cliente'=>$cliente, 'numfila'=>$numfila));
    		}
    	}else{
    		$ls_precio = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', null, null, '', 'tlp_id', true);
    		$categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
    		$data['listas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $ls_precio);
    		$data['categorias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $categorias);
    		$data["titulo_personal"] = "Lista de precio";
    		$this->_cargarvista($data);
    	}
    }

	/**
     * Descripción:
     * Función para las listas de precios por venta.
     * @author Andrea Rivera - Grupo Satélite
     * @since  2020-01-07
     * @param  Ninguno
     * @return Registros listas de precios por venta.
     */
	public function rpt_lista_precios_venta(){
		satelite_validar();
		try{
			ini_set('memory_limit', '-1');
			ini_set('max_execution_time', '9999');
			if($this->input->post()){
				$txtFechaInicio = $this->input->post('txtFechaInicio');
				$txtFechaFin = $this->input->post('txtFechaFin');
				$slcSucursal = $this->input->post('slcSucursal');
				$tipoLista = $this->input->post('slcLista');
                //print_r($slcLista);                
				$where = array();
				if($txtFechaInicio != '' && $txtFechaFin != '' && $slcLista =! ''){
					$where['(DATE(fac_fecha_fact) >= "'.formatear_fecha("Y-m-d", $txtFechaInicio).'" AND DATE(fac_fecha_fact) <= "'.formatear_fecha("Y-m-d", $txtFechaFin).'" )' ] = null;
					if (count($tipoLista)>0) {
						$where['tlp_id in ('.implode(',', $tipoLista).')']= null;         		
					}		    		
				}
				if($slcSucursal != ''){
					$where['fac_id_suc' ] = $slcSucursal;
				}
				$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

				$where['fac_estado != 0'] = null;
				$reporte_reg = $this->facturacion_model->get_lista_precio_venta($where);
				$data["reporte_reg"] = $reporte_reg;
				$data['tipo'] = $tipo;
				$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
				$html = $this->load->view('facturacion/reportes/tabla_reporte_precios_venta', $data, true);
				echo $html;
				die();
			}
			$ls_precio = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', null, null, '', 'tlp_id', true);
			$data['listas'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $ls_precio);
			$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array(), null, '', 'suc_id', true);
			$data['slcSucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

			$data['titulo_personal'] = 'Lista de precios por ventas';
			cargarvista($data);
		} catch (Exception $e) {
			show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
		}
	}

	public function mostrar_lista_precios_venta()
	{
		try{
			ini_set('memory_limit', '-1');
			ini_set('max_execution_time', '9999');
			if($this->input->post()){
				$txtFechaInicio = $this->input->post('txtFechaInicio');
				$txtFechaFin = $this->input->post('txtFechaFin');
				$slcSucursal = $this->input->post('slcSucursal');
				$slcLista = $this->input->post('slcLista');
				$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';
				$where = array();
				if($txtFechaInicio != '' && $txtFechaFin != '' && $slcLista !=''){
					$where['(DATE(fac_fecha_fact) >= "'.formatear_fecha("Y-m-d", $txtFechaInicio).'" AND DATE(fac_fecha_fact) <= "'.formatear_fecha("Y-m-d", $txtFechaFin).'" )' ] = null;
					$where['tlp_id in ('.$slcLista.')']= null;

				}
				if($slcSucursal != ''){
					$where['fac_id_suc' ] = $slcSucursal;
				}
				$where['fac_estado != 0'] = null;
				$reporte_reg = $this->facturacion_model->get_lista_precio_venta($where);
                /*print_r($this->db->last_query());
                die();*/
                $data["reporte_reg"] = $reporte_reg;
                $data['tipo'] = $tipo;
                $data['filename'] = 'Lista de precios por venta';
                $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
                if($tipo == 'excel'){
                	$html = $this->load->view('facturacion/reportes/tabla_reporte_precios_venta', $data, true);
                	echo $html;
                } else{
                	ini_set('display_errors', 0);
                	$html_header = $this->load->view('reporte/header', array('titulo' => 'Precios por Venta'), true);
                	$html = $this->load->view('facturacion/reportes/tabla_reporte_precios_venta_pdf', $data, true);
		            // echo $html;
		            // die();
                	$reporte = $this->pdf->makePDF($html_header . $html, 'L');
		            // $this->pdf->makePdf($html, 'h', 'Reporte_de_programas_vinculados', 'Letter');
                }
                die();
            }
        } catch (Exception $e) {
        	show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }

    }

	/**
	 * Descripción:
	 * Reporte de productos mas vendidos.
	 * @author Rafael Cuchilla
	 * @since  2018-08-14
	 */
	function rpt_productos_masvendidos(){
		satelite_validar();
		if($this->input->post()) {
			$post_array   = $this->input->post();
			$fecha_inicio = ($post_array['txtFechaIni'] != '' )? date('Y-m-d', strtotime($post_array['txtFechaIni'])) : null;
			$fecha_fin 	  = ($post_array['txtFechaFin'] != '')? date('Y-m-d', strtotime($post_array['txtFechaFin'])) : null;
			$producto 	  = ($post_array['producto'] != '') ? $post_array['producto'] : 10;
			$marca 		  = ($post_array['marca'] > 0) ? $post_array['marca'] : null;
			$categoria 	  = ($post_array['categoria'] != '') ? $post_array['categoria'] : null;			
			// Condicionales para la consulta
			$data['top'] = $producto;
			$data['fecha_ini'] = $fecha_inicio;
			$data['fecha_fin'] = $fecha_fin;
			$data['detalles'] = $this->facturacion_model->get_productos_masvendidos($fecha_inicio, $fecha_fin, $producto, $categoria, $marca);
			$tipo_reporte           = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
			$data["tipo_reporte"]   = $tipo_reporte;
			$filename                   = 'Reporte_productos_masvendidos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['titulo']             = 'Productos mas Vendidos';
			$data['filename']           = $filename;
			$html = $this->load->view('facturacion/reportes/grid_masvendidos', $data, true);
			if ($tipo_reporte == 'grid') {
				$data2['html'] = $html;
				echo json_encode($data2);
				die();
			} elseif ($tipo_reporte == 'pdf') {
				$data['titulo']             = 'Productos mas Vendidos';
				$header                     = $this->load->view('reporte/header', $data, true);
				$GLOBALS['nombre_reporte']  = 'Reporte_productos_masvendidos_' . date('dmY');
				$reporte                    = $header . $html;
				$this->pdf->makePdf($reporte, 'L', 'Reporte_productos_masvendidos_', 'Letter');
			} elseif ($tipo_reporte == 'excel') {
				echo $html;
			}
		} else {
			$categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => '1'), null, '', 'tia_id', true);
			$data['categorias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $categorias);
			$marcaprod = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_codigo} - {mrp_nombre}', '', array('mrp_estado' => '1'), null, '', 'mrp_id', true);
			$data['marcas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $marcaprod);
			$data['titulo_personal']    = 'Reporte de Productos Mas Vendidos';
			cargarvista($data);
		}
	}

    /**
     * Descripción:
     * Función para reporte de vendedores
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-17
     * @param  Ninguno
     * @modify Raul Escalante - 28/10/2019 //Se modifico la query para mostrar al vendedor aunque no tenga meta de ventas
     * @return Mostrar las ventas totales de vendedores por mes
     */
    public function reporte_vendedores() {
    	satelite_validar();
    	$permisos = $this->gsatelite->get_permisos_opcion();    	
    	if ($_POST) {
    		$post_array     = $this->input->post();
    		$periodo 		= ($post_array['txtfecha_mensual'] != '' )? $post_array['txtfecha_mensual'] : null;
    		$vendedor       = ($post_array['slc_vendedor'] != '') ? $post_array['slc_vendedor'] : null;
    		$sucursal 		= ($post_array['slc_sucursal'] != '') ? $post_array['slc_sucursal'] : null;
    		$meses          = array('Enero'=> 1, 'Febrero'=> 2, 'Marzo'=> 3, 'Abril'=> 4, 'Mayo'=> 5, 'Junio'=> 6, 'Julio'=> 7, 'Agosto'=> 8, 'Septiembre'=> 9, 'Octubre'=> 10,  'Noviembre'=> 11, 'Diciembre'=> 12);
    		$meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');
            // Dividir y obtener el mes y anio
    		$fecha      = explode('-', $periodo);
    		$fecha_date = $fecha[1]."-".$meses[$fecha[0]];
    		$fecha_date = formatear_fecha('Y-m', $fecha_date);
    		$where   = null;
    		$groupby = null;
    		$orderby = null;
    		$datos   = null;
    		if (trim($vendedor) != "") {
    			$where['ven_id'] = $vendedor;
    		}
    		if (trim($sucursal) != "") {
    			$where['fac_id_suc'] = $sucursal;
    		}
    		if (trim($periodo) != "") {
    			$datos['periodo'] = $fecha_date;
    			$where['DATE(fac_fecha_fact) BETWEEN "'.$fecha_date.'-01" AND LAST_DAY("'.$fecha_date.'-01")'] = null;
    		}
    		$where['ven_estado'] = 1;
    		$where['fac_estado > '] = 0;
    		$where['fac_id_origen_devolucion IS NULL'] = NULL;
    		$groupby = 'fac_id_ven';
    		$data['vendedores']         = $this->facturacion_model->get_reporte_vendedores($where, $groupby, $orderby, $datos);
    		$data['meses']              = $meses_letras;
    		$tipo_reporte               = ($post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : '';
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$filename                   = 'Reporte_vendedores_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['titulo']             = 'Reporte de Vendedores';
    		$data['filename']           = $filename;
    		$html = $this->load->view('facturacion/reportes/consultar_reporte_vendedores', $data, true);

    		if ($tipo_reporte == '') {
    			$resultado['html'] = $html;
    			echo json_encode($resultado);
    			die();  
    		} elseif ($tipo_reporte == 'pdf') {
    			$data['titulo']             = 'Vendedores';
    			$header                     = $this->load->view('reporte/header', $data, true);
    			$GLOBALS['nombre_reporte']  = 'Reporte_vendedores_' . date('dmY');
    			$reporte                    = $header . $html;
    			$this->pdf->makePdf($reporte, 'L', 'Reporte_vendedores_', 'Letter');
    		} elseif ($tipo_reporte == 'excel') {
    			echo $html;
    		}
    	} else {
    		$selected = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado'=>1), null, '', 'ven_id', true);
    		$data['vendedores'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $selected);
    		$selected = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, '', 'suc_id', true);
    		$data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $selected);

    		$data['titulo_personal']    = 'Reporte de Vendedores';
    		cargarvista($data);
    	}
    }

    /**
     * Descripción:
     * Función para mostrar el grafico de las metas de los vendedores
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-17
     * @param  $periodo = al mes y anio que se desea reportar, $vendedor = id del vendedor, $sucursal = id de la sucursal
     * @modify Raul Escalante - 28/10/2019 //Se modifico la query para mostrar al vendedor aunque no tenga meta de ventas
     * @return El grafico de las metas de los vendedores
     */
    public function ver_grafico_reporte_vendedores($periodo = null, $vendedor = null, $sucursal = null) {
    	$vendedor = ($vendedor > 0) ? $vendedor : '';
    	$sucursal = ($sucursal > 0) ? $sucursal : '';
    	$fecha = explode('-', $periodo);
    	$meses = array('Enero'=> 1, 'Febrero'=> 2, 'Marzo'=> 3, 'Abril'=> 4, 'Mayo'=> 5, 'Junio'=> 6, 'Julio'=> 7, 'Agosto'=> 8, 'Septiembre'=> 9, 'Octubre'=> 10,  'Noviembre'=> 11, 'Diciembre'=> 12);
    	$meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');
    	$fecha_date = $fecha[1]."-".$meses[$fecha[0]];
    	$fecha_date = formatear_fecha('Y-m', $fecha_date);
    	$where   = null;
    	$groupby = null;
    	$orderby = null;
    	$datos   = null;
    	if (trim($vendedor) != "") {
    		$where['ven_id'] = $vendedor;
    	}
    	if (trim($sucursal) != "") {
    		$where['fac_id_suc'] = $sucursal;
    	}
    	if (trim($periodo) != "") {
    		$datos['periodo'] = $fecha_date;
    		$where['DATE(fac_fecha_fact) BETWEEN "'.$fecha_date.'-01" AND LAST_DAY("'.$fecha_date.'-01")'] = null;
    	}
    	$where['ven_estado'] = 1;
    	$where['fac_estado > '] = 0;
    	$where['fac_id_origen_devolucion IS NULL'] = NULL;
    	$groupby = 'fac_id_ven';
    	$data = array();
    	$data['titulo_grafico'] = "Reporte de Vendedores - $periodo";
    	$data['vendedores']  = $this->facturacion_model->get_reporte_vendedores($where, $groupby, $orderby, $datos);
    	$this->load->view('facturacion/reportes/grafico_reporte_vendedores', $data, FALSE);    	
    }

    /**
     * Descripción:
     * Reporte de los mejores clientes
     * @author Israel Alfaro - Grupo Satélite
     * @since  2018-10-24
     */
    public function reporte_mejores_clientes() {
    	satelite_validar();
    	$datos['titulo_personal'] = 'Reporte de mejores clientes';
    	$this->_cargarvista($datos, null);
    }

    public function get_mejores_clientes() {
    	satelite_validar();
    	$f1 = date('Y-m-d 00:00:00', strtotime($this->input->post('desde')));
    	$f2 = date('Y-m-d 23:59:59', strtotime($this->input->post('hasta')));
    	$limite = ($this->input->post('cantidad') != "") ? $this->input->post('cantidad') : "10";
    	$tipo = $this->input->post('tipo');
    	if ($this->input->post('desde') != "" and $this->input->post('hasta') != "") {
    		$where = array(
    			'fac_fecha_fact >=' => $f1,
    			'fac_fecha_fact <=' => $f2
    		);
    		$data['tipo'] = $tipo;
    		$data['consulta'] = $this->facturacion_model->get_mejores_clientes($where, $limite);
            // die($this->db->last_query());
    		$data['fecha1'] = date('d-m-Y', strtotime($this->input->post('desde')));
    		$data['fecha2'] = date('d-m-Y', strtotime($this->input->post('hasta')));
    		$data['np'] = $limite;
    		$data['f1_iframe'] = date('d-m-Y', strtotime($this->input->post('desde')));
    		$data['f2_iframe'] = date('d-m-Y', strtotime($this->input->post('hasta')));
    		$html = $this->load->view('facturacion/reportes/get_mejores_clientes', $data, true);
    	}

    	if ($tipo == null or $tipo == "") {
    		echo $html;
    	} else if ($tipo == 2) {
    		$this->load->library('pdf');
    		$html_header = $this->load->view('reporte/header', array('titulo' => 'Mejores Clientes'), true);
    		$reporte = $this->pdf->makePDF($html_header . $html, 'P');
    	} else {
    		header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    		header("Content-Disposition: attachment;filename=Reporte_mejores_clientes.xls");
    		header("Pragma: no-cache");
    		header("Expires: 0");
    		echo $html;
    	}
    }

	/**
     * Descripción:
     * Genera reporte de los mejores clientes
     * @author Israel Alfaro - Grupo Satélite
     * @since  2018-10-24
     */
	function ver_grafico_mejores_clientes($f1 = null, $f2 = null, $n = null) {
		$f1 = date('Y-m-d 00:00:00', strtotime($f1));
		$f2 = date('Y-m-d 23:59:59', strtotime($f2));
		$where = array('fac_fecha_fact >=' => $f1, 'fac_fecha_fact <=' => $f2);
		$data = array();
		$textof1 = date('d-m-Y', strtotime($f1));
		$textof2 = date('d-m-Y', strtotime($f2));
		$n = ($n) ? $n : 10;
		$data['titulo_grafico'] = "Desde $textof1 Hasta $textof2 Los $n mejores clientes";
		$data['consulta'] = $this->facturacion_model->get_mejores_clientes($where, $n);
		$this->load->view('cotizaciones/consultas/grafico_mejores_clientes', $data, FALSE);
	}

    /**
     * Descripción:
     * Función para reporte de ventas por sucursal
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-10-22
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    function reporte_ventas_sucursal($flag = null){              
    	satelite_validar();
    	if ($_POST){

    		$post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
            	$fecha_inicio = ($post_array['fecha_desde'] != '') ? $post_array['fecha_desde'] : null;
            	$fecha_fin    = ($post_array['fecha_hasta'] != '') ? $post_array['fecha_hasta'] : null;
            	$sucursal     = ($post_array['sucursal'] != '') ? $post_array['sucursal'] : null;

            } else {
            	$fecha_inicio = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
            	$fecha_fin     = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;                
            	$sucursal         = ($post_array['hslcSucursal'] != '') ? $post_array['hslcSucursal'] : null;

            	$data['fecha_desde_text']     = ($post_array['hFecha_desde'] != '') ? '<b>Desde: </b>' . $post_array['hFecha_desde'] : '<b>Desde: </b>' . '';
            	$data['fecha_hasta_text']        = ($post_array['hFecha_hasta'] != '') ? '<b>Hasta: </b>' . $post_array['hFecha_hasta'] : '<b>Hasta: </b>' . '';                
            	$data['sucursal_text'] = ($post_array['hslcSucursaltext'] != '') ? '<b>Sucursal: </b>' . $post_array['hslcSucursaltext'] : '<b>Sucursal: </b>' .'Todas';
            }
            
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($fecha_inicio != null) {
            	$where['fecha_inicio'] = formatear_fecha('Y-m-d', $fecha_inicio);                
            }
            
            if ($fecha_fin != null) {
            	$where['fecha_fin'] = formatear_fecha('Y-m-d', $fecha_fin);                
            }

            if ($sucursal != null) {
            	$where['id_sucursal'] = $sucursal;
            }

            //$where['fac_estado']        = 0;
            //print_r($where); die();

            $reporte = $this->facturacion_model->get_reporte_sucursal_venta($where, 'fac_id_suc');
            // print_r($this->db->last_query()); die();
            $filename = 'rpt_reporte_venta_sucursal' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
            $data['filename']              = $filename;
            $data['reporte']               = $reporte;
            $data['tipo_reporte']          = $tipo_reporte;
            
            $html = $this->load->view('facturacion/reportes/filtrar_ventas_sucursal', $data, true);
            
            if ($flag) {                
            	echo $html;
            	die();
            } else {
            	if ($tipo_reporte == 'pdf') {

            		$data['titulo'] = 'ventas por sucursal';

            		$header = $this->load->view('reporte/header', $data, true);

            		$GLOBALS['nombre_reporte'] = 'reporte_ventas_sucursal_' . date('dmY');

            		$reporte = $header . $html;

            		$this->pdf->makePdf($reporte, 'L', 'reporte_ventas_sucursal', 'Letter');
            	} elseif ($tipo_reporte == 'excel') {

            		$filename = 'rpt_empleado_tipo_vivienda_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            		$data['titulo'] = 'ventas por sucursal';

            		$data['filename'] = $filename;

            		echo $html;
            	}
            }
            
        } else{
        	$emp_id = $this->tank_auth->get_empresa_id();
            //print_r($emp_id); die();
        	if($emp_id>0){
        		$tot_suc = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id_emr'=>$emp_id));
        		if(count($tot_suc) > 0){
        			$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', array('suc_id_emr' => $emp_id), null, '', 'suc_id', true);
        		}else{                    
        			$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', '', null, '', 'suc_id', true);
        		}
        	}
            //$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', $where, null, '', 'suc_id', true);
        	$data["slcSucursal"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        	$data['titulo_personal'] = "Reporte ventas por sucursal";
        	$this->_cargarvista($data);
        }
    }//Fin funcion reporte_ventas_sucursal

    /**
    * @author Israel Alfaro
    * @since 2018-10-30
    * @return  reporte de propinas
    */
    function reporte_propina() {
    	// satelite_validar();
    	if ($_POST) {
    		$fecha_inicio 	= date('Y-m-d', strtotime($this->input->post('txtFechaIni')));
    		$fecha_final  	= date('Y-m-d', strtotime($this->input->post('txtFechaFin')));
    		$tipo_reporte	= $this->input->post('txtReporte');
    		$tipo 		 	= $this->input->post('chkInfo');
    		$tipo		    = ($tipo == false)?0:1;

    		$where 			= array();
    		$where["DATE(fac_fecha_fact)  >= '".$fecha_inicio."'"] 	= null;
    		$where["DATE(fac_fecha_fact)  <= '".$fecha_final."'"] 	= null;
    		$where["fac_estado >"] 									= 0;
    		$where["ixf_id_imp"] 									= 2;

    		if ($tipo == 0){ 
    			$data = $this->facturacion_model->obtener_propinas_por_fechas($where, $tipo);
    		} else {
    			$data = $this->facturacion_model->obtener_propinas_consolidadas($fecha_inicio,$fecha_final);
    		}

    		$data['datos'] = $data;
    		if ($tipo_reporte == 1) {
    			$this->load->library('pdf');
    			$html  = $this->load->view('reporte/header', array('titulo' => 'Propinas'), true);
    			if ( $tipo == 0) {
    				$html .= $this->load->view('facturacion/reportes/rpt_propinas', $data, true); 
    			} else {
    				$html .= $this->load->view('facturacion/reportes/rpt_propinas_consolidado', $data, true); 
    			}	             
    			$reporte=$this->pdf->makePDF($html, 'L');
    			$this->_cargarvista( null, $data );
    		} else {
    			$filename = 'reporte_propina_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    			$data['titulo'] = 'Propina';
    			$data['excel'] = 1;
    			$data['filename'] = $filename;
    			if ( $tipo == 0) {
    				$html = $this->load->view('facturacion/reportes/rpt_propinas', $data, true);
    			} else {
    				$html = $this->load->view('facturacion/reportes/rpt_propinas_consolidado', $data, true);
    			}
    			echo $html;
    		}
    	} else {
    		$data['titulo_personal'] = "Reporte de Propina";
    		cargarvista($data);
    	}
    }

    function get_detalle_rpt_propina() {
    	$fecha_inicio 	= date('Y-m-d', strtotime($this->input->post('txtFechaIni')));
    	$fecha_final  	= date('Y-m-d', strtotime($this->input->post('txtFechaFin')));
    	$tipo 			= $this->input->post('chkInfo');

    	$where 			= array();
    	$where["DATE(fac_fecha_fact)  >= '".$fecha_inicio."'"] 	= null;
    	$where["DATE(fac_fecha_fact)  <= '".$fecha_final."'"] 	= null;
    	$where["fac_estado >"] 									= 0;
    	$where["ixf_id_imp"] 									= 2;
		// $data = $this->facturacion_model->obtener_propinas_por_fechas($where);
    	
    	if ($tipo == 0){
    		$data = $this->facturacion_model->obtener_propinas_por_fechas($where,$tipo);
    		$data['datos'] = $data;
    		$html = $this->load->view('facturacion/reportes/detalle_rpt_propina', $data, true);
    	} else {
    		$data = $this->facturacion_model->obtener_propinas_consolidadas($fecha_inicio,$fecha_final);
    		$data['datos'] = $data;
    		$html = $this->load->view('facturacion/reportes/consolidado_rpt_propina', $data, true);
    	}
    	
    	echo $html;
    }

    /**
     * Descripción:
     * Función para reporte de ventas por sucursal
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-10-22
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    function reporte_ventas_sucursal_detallado($flag = null){              
    	satelite_validar();        
    	if ($_POST){        	
    		$post_array = $this->input->post();
            //print_r($post_array); die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
            	$fecha_inicio = ($post_array['fecha_desde'] != '') ? $post_array['fecha_desde'] : null;
            	$fecha_fin    = ($post_array['fecha_hasta'] != '') ? $post_array['fecha_hasta'] : null;
            	$sucursal     = ($post_array['sucursal'] != '') ? $post_array['sucursal'] : null;
            	$tipo_factura = ($post_array['tipo_factura'] != '') ? $post_array['tipo_factura'] : null;
            	$facDomicilio = ($post_array['facDomicilio'] != '') ? $post_array['facDomicilio'] : null;

            } else {
            	$fecha_inicio   = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
            	$fecha_fin      = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;                
            	$sucursal       = ($post_array['hslcSucursal'] != '') ? $post_array['hslcSucursal'] : null;
            	$tipo_factura   = ($post_array['hslcTipoFactura'] != '') ? $post_array['hslcTipoFactura'] : null;
            	$facDomicilio   = (trim($post_array['facDomicilio']) != '') ? $post_array['facDomicilio'] : null;

            	$data['fecha_desde_text']   = ($post_array['hFecha_desde'] != '') ? '<b>Desde: </b>' . $post_array['hFecha_desde'] : '<b>Desde: </b>' . '';
            	$data['fecha_hasta_text']   = ($post_array['hFecha_hasta'] != '') ? '<b>Hasta: </b>' . $post_array['hFecha_hasta'] : '<b>Hasta: </b>' . '';                
            	$data['sucursal_text']      = ($post_array['hslcSucursaltext'] != '') ? '<b>Sucursal: </b>' . $post_array['hslcSucursaltext'] : '<b>Sucursal: </b>' .'Todas';
            	$data['tipo_factura_text']  = ($post_array['hslcTipoFacturatext'] != '') ? '<b>Tipo factura: </b>' . $post_array['hslcTipoFacturatext'] : '<b>Tipo factura: </b>' .'Todas';
            	$data['facDomicilio_text']  = (trim($post_array['facDomicilio']) != '') ? '<b>Domicilio: </b> Si' : '<b>Domicilio: </b>' .'No';
            }
            
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;

            if ($fecha_inicio != null) {
            	$where['fecha_inicio'] = formatear_fecha('Y-m-d', $fecha_inicio);                
            }
            
            if ($fecha_fin != null) {
            	$where['fecha_fin'] = formatear_fecha('Y-m-d', $fecha_fin);                
            }

            if ($sucursal != null) {
            	$where['id_sucursal'] = $sucursal;
            }

            if ($tipo_factura != null) {
            	$where['id_tipo_factura'] = $tipo_factura;
            }
            
            if ($facDomicilio != null) {
            	$where['fac_aplica_domicilio'] = $facDomicilio;
            }
            
            //$where['fac_estado']        = 0;
            //print_r($where); die();

            $reporte = $this->facturacion_model->get_reporte_sucursal_venta_detallado($where, 'fac_id_suc');
            // print_r($this->db->last_query());die();
            $filename = 'rpt_reporte_venta_sucursal' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
            $data['filename']              = $filename;
            $data['reporte']               = $reporte;
            $data['tipo_reporte']          = $tipo_reporte;
            
            $html = $this->load->view('facturacion/reportes/filtrar_ventas_sucursal_detallado', $data, true);
            
            if ($flag) {                
            	echo $html;
            	die();
            } else {
            	if ($tipo_reporte == 'pdf') {
            		$data['titulo'] = 'ventas por sucursal detallado';
            		$header = $this->load->view('reporte/header', $data, true);
            		$GLOBALS['nombre_reporte'] = 'reporte_ventas_sucursal_detallado_' . date('dmY');
            		$reporte = $header . $html;
                    $head = '<!DOCTYPE html><html><head><title>Ventas por Sucursal Detallado</title></head><body><script type="text/javascript">';
                    $head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Ventas por Sucursal Detallado";';
                    $head .= 'window.print();</script>';
                    $footer = '</body></html>';
                    echo $head.$reporte.$footer;
            		// $this->pdf->makePdf($reporte, 'L', 'reporte_ventas_sucursal_detallado', 'Letter');
            	} elseif ($tipo_reporte == 'excel') {

            		$filename = 'rpt_empleado_tipo_vivienda_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            		$data['titulo'] = 'ventas por sucursal detallado';

            		$data['filename'] = $filename;

            		echo $html;
            	}
            }
            
        } else{
        	$emp_id = $this->tank_auth->get_empresa_id();
            //print_r($emp_id); die();
        	if($emp_id>0){
        		$tot_suc = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id_emr'=>$emp_id));
        		if(count($tot_suc) > 0){
        			$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', array('suc_id_emr' => $emp_id), null, '', 'suc_id', true);
        		}else{                    
        			$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', '', null, '', 'suc_id', true);
        		}
        	}
            //$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', $where, null, '', 'suc_id', true);
        	$data["slcSucursal"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        	$data['titulo_personal'] = "Reporte ventas por sucursal detallado";

        	$select = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_aplica_venta' => 1, 'tif_estado' => 1), null, '', 'tif_id', true);
        	$data["slcTipoFactura"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);


        	$this->_cargarvista($data);
        }
	}//Fin funcion reporte_ventas_sucursal_detallado
	
	/**
		* @author Francisco Orozco
		* @since 2018-11-05
		* @return reporte de comparacion de clientes
		* @modify Manuel Anzora - 30/11/2018
    */
		public function comparativo_clientes() {
			satelite_validar();
			if ($_POST){
				$text_clientes = array();
				$clientes 	   = $this->input->post('slc_cliente');
			//$text_clientes = $this->input->post('text_clientes');// YA NO SE USARA POR FALLAR CUANDO EL NOMBRE DEL CLIENTE POSEE COMA
				$fecha_inicio  = ($this->input->post('txt_fecha_inicio') != "") ? formatear_fecha('Y-m-d', '01-'.$this->input->post('txt_fecha_inicio')) : null;
				$fecha_fin 	   = ($this->input->post('txt_fecha_fin') != "") ? formatear_fecha('Y-m-t', '01-'.$this->input->post('txt_fecha_fin')) : null;
				$array_cliente = (trim($clientes) != '') ? array("cli_estado" => 1, "cli_id IN ($clientes)" => null) : array('cli_estado' => 1);
				$clientes_all = $this->gsatelite->get_tabla('cli_cliente', $array_cliente);
				$array_ids = array_column($clientes_all, 'cli_id');
				foreach ($clientes_all as $key => $value) {
					$text_clientes[] = ($value['cli_personeria'] > 1) ? $value['cli_codigo'].' - '.$value['cli_apellido'] : $value['cli_codigo'].' - '.$value['cli_nombre'].' '.$value['cli_apellido'];
				}
				$clientes = (trim($clientes) != '') ? $clientes : implode(',', $array_ids);
				$tipo_reporte   	= ($this->input->post('tipo_reporte') != false) ? $this->input->post('tipo_reporte') : '';
				$meses_direrencia	= $this->input->post('txt_meses_diferencia');
			//print_r($meses_direrencia);
				$clientes_array 	= (trim($clientes) !="") ? explode(",", $clientes) : null;
				$nombres_array 		= $text_clientes;
				$where_array		= $clientes_array;

			// var_dump($where_array);die();
				$where["DATE(fac_fecha_fact) >= '$fecha_inicio'"] = null;
				$where["DATE(fac_fecha_fact) <= '$fecha_fin'"] 	= null;
				$where["fac_estado"] = 2;

				$comparativo = $this->facturacion_model->comparativo_clientes($where, $where_array);
				$data["tipo_reporte"]   	= $tipo_reporte; 
				$data["comparativo"]		= $comparativo;
				$data["fecha_inicio"]		= $fecha_inicio;
				$data["fecha_fin"]			= $fecha_fin;
				$data["clientes"]			= $clientes_array;
				$filename               	= 'reporte_comparativo_clientes_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
				$data['titulo']         	= 'Reporte comparativo de clientes';
				$data['filename']       	= $filename;
				$data['meses_direrencia']	= $meses_direrencia;
				$data['nombres_clientes']	= $nombres_array;
				$html                   	= $this->load->view('facturacion/reportes/reportes_comparativo_clientes', $data, true);
			// echo $html;die();
				if ($tipo_reporte == '') {
					$data2['html'] = $html;
					echo json_encode($data2);
					die();
				} elseif ($tipo_reporte == 'pdf') {            
					$header                     = $this->load->view('reporte/header', $data, true);
					$GLOBALS['nombre_reporte']  = 'reporte_comparativo_clientes_' . date('dmY');
					$reporte                    = $header . $html;
					$this->pdf->makePdf($reporte, 'L', 'reporte_comparativo_clientes_', 'Letter');
				} elseif ($tipo_reporte == 'excel') {
					echo $html;
				}

			} else {
				$data['titulo_personal']    = 'Reporte comparativo de clientes';
				cargarvista($data);
			} 
		}

	 /**
        * @author Francsico Orozco
        * @since 2018-11-07
        * @return clientes
        * @param $like string para condicionar.
    */
	 public function get_clientes_like(){
	 	if ($_POST) {
	 		$like           = $this->input->post('cliente');
	 		$clasificacion  = $this->input->post('clasificacion');
	 		$evaluar_plan   = $this->input->post('evaluar_plan');

	 		$where['cli_estado'] = 1;

	 		if( $clasificacion != "" or $clasificacion != false){
	 			$where['cli_id_cfc'] = $clasificacion;
	 		}

	 		if ($evaluar_plan == true && $evaluar_plan != 0) {
	 			$where['sxc_estado'] = 1;
	 			$where['pxl_estado'] = 1;
	 		}

	 		$result = $this->facturacion_model->get_clientes_like($where,$like,$evaluar_plan);

	 		echo json_encode($result);

	 	}
	 }

    /**
     * Descripción:
     * Función para generar reporte de comprobantes de descuentos
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-11-15
     * @param ninguno
     * @return PDF o Excel
     */
    public function reporte_comprobantes() {
    	satelite_validar();
    	$permisos = $this->gsatelite->get_permisos_opcion();

    	if ($_POST){
			// print_r($_POST);die();
    		$sucursal       	= $this->input->post('slcSucursal');
    		$cajero          	= $this->input->post('slcCajero');
    		$fecha_inicio 		= $this->input->post('txt_fecha_inicio') != "" ? date('Y-m-d', strtotime($this->input->post('txt_fecha_inicio'))) : null;
    		$fecha_fin 			= $this->input->post('txt_fecha_fin') != "" ? date('Y-m-d', strtotime($this->input->post('txt_fecha_fin'))) : null;
    		$tipo_reporte   	= ($this->input->post('tipo_reporte') != false) ? $this->input->post('tipo_reporte') : '';

    		$where['cmd_fecha >= "'.$fecha_inicio.'"']  = null;
    		$where['cmd_fecha <= "'.$fecha_fin.'"'] 	= null;
			// $where['fac_estado']						= 2; // Estado del comprobante

    		if ($cajero > 0) {
    			$where['uxc_id_usu'] = $cajero;
    		}

    		if ($sucursal > 0) {
    			$where['suc_id'] = $sucursal;
    		}

    		$groupby = 'cmd_id';

    		$comparativo = $this->facturacion_model->comprobantes_descuento($where, $groupby);

    		$data["tipo_reporte"]   	= $tipo_reporte; 
    		$data["comparativo"]		= $comparativo;
    		$data["fecha_inicio"]		= $fecha_inicio;
    		$data["fecha_fin"]			= $fecha_fin;
    		$data["sucursal"]			= $sucursal;
    		$filename               	= 'reporte_comprobante_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['titulo']         	= 'Reporte de Comprobante';
    		$data['filename']       	= $filename;
    		$html                   	= $this->load->view('facturacion/reportes/consultar_comprobante_descuento', $data, true);

    		if ($tipo_reporte == '') {
    			$data2['html'] = $html;
    			echo json_encode($data2);
    			die();
    		} elseif ($tipo_reporte == 'pdf') {            
    			$header                     = $this->load->view('reporte/header', $data, true);
    			$GLOBALS['nombre_reporte']  = 'reporte_comprobante_' . date('dmY');
    			$reporte                    = $header . $html;
    			$this->pdf->makePdf($reporte, 'L', 'reporte_comprobante_', 'Letter');
    		} elseif ($tipo_reporte == 'excel') {
    			echo $html;
    		}

    	} else {

			// Proceso para obtener los usuarios con tipo de rol cajero
			// Parametro para obtener el rol de cajero
    		$rol_cajero =  $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');

			$data['disable']=0; // Se deshabilitará si el usuario no es cajero.
			$opt_cajero = '<option value=""></option>';
			if($rol_cajero>0) {
				$existe = $this->gsatelite->get_registro('rol_rol', array('rol_id'=>$rol_cajero));
				if(count($existe)>0) {
					/***** Se verifican los permisos de los roles asociados al usuario para la carga de los cajeros ******/
					$where   = null;
					$groupby = 'id';
					$orderby = null;
					/***********************************************************************************************/
					$cajeros = $this->facturacion_model->obtener_cajeros($where, $groupby, $orderby);
					/************ Cargar usuarios con rol cajero, según parámetro **********************************/
					if(count($cajeros)>0){
						foreach ($cajeros as $caj) {
							$select = "";
							$opt_cajero .= '<option value="'.$caj['id'].'" data-emp="'.$caj['id'].'" '.$select.'>'.$caj['emp_nombre'].' '.$caj['emp_apellido'].'</option>';
						}
					}

					$data['cajero'] = str_replace('<option value="0">Seleccione</option>', '', $opt_cajero);
				} else {
					$alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Rol",'texto_alerta'=>"Debe realizar las configuraciones necesarias para el rol de cajero");
					$this->session->set_flashdata($alerta);
				}
			} else {
				$alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Rol",'texto_alerta'=>"Debe realizar las configuraciones necesarias para el rol de cajero");
				$this->session->set_flashdata($alerta);
			}

			$sucursales = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, '', 'suc_id', true);
			$data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '', $sucursales);

			$data['titulo_personal']    = 'Reporte de Comprobante de Descuento';
			cargarvista($data);
		}
	}

	/***********************************************************************/
    /**
     * Descripción:
     * Función para reporte diario articulo detallado
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-11-19
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    function reporte_diario_articulo_detallado($flag = null){              
    	satelite_validar();
    	if ($_POST){
    		$post_array = $this->input->post();
    		/* Si es consulta ajax se toman los nombres del Jquery, De lo contrario, se toman los filtros de impresión */
    		if ($flag) {
    			$fecha_inicio = ($post_array['fecha_desde'] != '') ? $post_array['fecha_desde'] : null;
    			$fecha_fin    = ($post_array['fecha_hasta'] != '') ? $post_array['fecha_hasta'] : null;
    			$sucursal     = ($post_array['sucursal'] != '') ? $post_array['sucursal'] : null;
    			$tipo_fac     = ($post_array['tipo_factura'] != '') ? $post_array['tipo_factura'] : null;
    		} else {
    			$fecha_inicio = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
    			$fecha_fin    = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;                
    			$sucursal     = ($post_array['hslcSucursal'] != '') ? $post_array['hslcSucursal'] : null;
    			$tipo_fac     = ($post_array['hslcTipoFactura'] != '') ? $post_array['hslcTipoFactura'] : null;
    			$data['fecha_desde_text']     = ($post_array['hFecha_desde'] != '') ? '<b>Desde: </b>' . $post_array['hFecha_desde'] : '<b>Desde: </b>' . '';
    			$data['fecha_hasta_text']        = ($post_array['hFecha_hasta'] != '') ? '<b>Hasta: </b>' . $post_array['hFecha_hasta'] : '<b>Hasta: </b>' . '';                
    			$data['sucursal_text'] = ($post_array['hslcSucursaltext'] != '') ? '<b>Sucursal: </b>' . $post_array['hslcSucursaltext'] : '<b>Sucursal: </b>' .'Todas';
    		}            
            //Tipo de Reportes si sera Excel o Pdf
    		$tipo_reporte = $this->input->post('tipo_reporte');
    		$where = null;
    		if ($fecha_inicio != null) {
    			$where['fecha_inicio'] = formatear_fecha('Y-m-d', $fecha_inicio);                
    		}            
    		if ($fecha_fin != null) {
    			$where['fecha_fin'] = formatear_fecha('Y-m-d', $fecha_fin);                
    		}
    		if ($sucursal != null) {
    			$where['id_sucursal'] = $sucursal;
    		}
    		if ($tipo_fac != null) {
    			$where['id_tipo_factura'] = $tipo_fac;
    		}
    		$reporte = $this->facturacion_model->get_reporte_diario_articulo_detallado($where, 'fac_id_suc');            
            // if(count($reporte)>0){
            // 	$reporte = $this->preparar_datos_diario_articulo_detallado($reporte);	
            // }            
            // print_r($this->db->last_query()); die();
    		$filename = 'rpt_reporte_diario_articulo_detallado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
    		$data['filename']              = $filename;
    		$data['reporte']               = $reporte;
    		$data['tipo_reporte']          = $tipo_reporte;            
    		$html = $this->load->view('facturacion/reportes/filtra_reporte_diario_articulo_detallado', $data, true);

    		if ($flag) {                
    			echo $html;
    			die();
    		} else {
    			if ($tipo_reporte == 'pdf') {
    				$data['titulo'] = 'ventas reporte diario de artículo detallado';
    				$header = $this->load->view('reporte/header', $data, true);
    				$GLOBALS['nombre_reporte'] = 'reporte_diario_articulos_detallados_' . date('dmY');
    				$reporte = $header . $html;
    				$head = '<!DOCTYPE html><html><head><title>Ventas Diario de Artículo Detallado</title></head><body><script type="text/javascript">';
    				$head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Ventas Diario de Artículo Detallado";';
    				$head .= 'window.print();</script>';
    				$footer = '</body></html>';
    				echo $head.$reporte.$footer;
                    // $this->pdf->makePdf($reporte, 'L', 'reporte_diario_articulo_detallado_', 'Letter');
    			} elseif ($tipo_reporte == 'excel') {

    				$filename = 'rpt_diario_articulo_detallado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

    				$data['titulo'] = 'diario de articulos detallados';

    				$data['filename'] = $filename;

    				echo $html;
    			}
    		}

    	} else{
    		$emp_id = $this->tank_auth->get_empresa_id();
    		if($emp_id>0){
    			$tot_suc = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id_emr'=>$emp_id));
    			if(count($tot_suc) > 0){
    				$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', array('suc_id_emr' => $emp_id), null, '', 'suc_id', true);
    			}else{                    
    				$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', '', '', null, '', 'suc_id', true);
    			}
    		}
    		$data["slcSucursal"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
    		$select = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1, 'tif_aplica_venta' => 1), null, '', 'tif_id', true);
    		$data["slcTipoFactura"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

    		$data['titulo_personal'] = "Reporte diario articulo detallado";
    		$this->_cargarvista($data);
    	}
    }//Fin funcion reporte_ventas_sucursal

    /**
     * Descripción:
     * Función para reporte diario articulo detallado
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-11-20
     * @param $datos = arreglos con los datos a ser tratados
     * @return Retorna el arreglo de de datos ordenados
     */
    function preparar_datos_diario_articulo_detallado($datos){
    	//print_r($datos); die();
    	$resultados = [];
    	$detalle = [];
    	$j = 0;    	
    	//Definir variables
    	$subtotal = 0.00;
    	$descuento = 0.00;
    	$iva = 0.00;
    	$total = 0.00;

    	if(count($datos)>0){
    		$facid = $datos[0]['fac_id'];
    		foreach ($datos as $i => $dato) {
    			
    			$facsig = (isset($datos[$i+1])) ? $datos[$i+1]['fac_id'] : 0;
    			//echo 'Actual '.$facid.'     siguiente '.$facsig;
    			//echo '<br>';

    		if(($facid == $dato['fac_id']) /*&& ($facid == $facsig)*/ ){
    				//Datos previos
    				/*$fac_id = $dato['fac_id'];
    				$codigo = $dato['codigo'];
    				$fecha = $dato['fecha'];
    				$tipo_pago = $dato['tipo_pago'];
    				$cod_articulo = $dato['cod_articulo'];
    				$nom_articulo = $dato['nom_articulo'];
    				$cant_articulo = $dato['cant_articulo'];*/
    				if($facid == $facsig){
    					$subtotal += $dato['subtotal'];
    					$descuento += $dato['descuento'];
    					$iva += $dato['iva'];
    					$total += $dato['total'];

    					$detalle['fac_id'] = $dato['fac_id']; 
    					$detalle['codigo'] = $dato['codigo']; 
    					$detalle['fecha'] = $dato['fecha']; 
    					$detalle['tipo_pago'] = $dato['tipo_pago']; 
    					$detalle['cod_articulo'] = $dato['cod_articulo']; 
    					$detalle['nom_articulo'] = $dato['nom_articulo']; 
    					$detalle['cant_articulo'] = $dato['cant_articulo']; 
    					$detalle['subtotal'] = 0.00; 
    					$detalle['descuento'] = 0.00; 
    					$detalle['iva'] = 0.00;
    					$detalle['total'] = 0.00;

    					array_push($resultados, $detalle);
    				}else{
    					//Se totalizan los valores para el ultimo detalle de la factura    				
    					$subtotal += $dato['subtotal'];
    					$descuento += $dato['descuento'];
    					$iva += $dato['iva'];
    					$total += $dato['total'];
    					//Se agrega el ultimo detalle
    					$detalle['fac_id'] = $dato['fac_id']; 
    					$detalle['codigo'] = $dato['codigo']; 
    					$detalle['fecha'] = $dato['fecha']; 
    					$detalle['tipo_pago'] = $dato['tipo_pago']; 
    					$detalle['cod_articulo'] = $dato['cod_articulo']; 
    					$detalle['nom_articulo'] = $dato['nom_articulo']; 
    					$detalle['cant_articulo'] = $dato['cant_articulo'];
    					$detalle['subtotal'] = $subtotal; 
    					$detalle['descuento'] = $descuento; 
    					$detalle['iva'] = $iva;
    					$detalle['total'] = $total;
    					array_push($resultados, $detalle);
    					//Resetear los datos de los acumuladores
    					$subtotal = 0.00;
    					$descuento = 0.00;
    					$iva = 0.00;
    					$total = 0.00;
    					//if($facid != $dato['fac_id']){
    					$facid = $facsig;
    					//}
    				}    				
    			}else{    				
    				//Se totalizan los valores para el ultimo detalle de la factura    				
    				$subtotal += $dato['subtotal'];
    				$descuento += $dato['descuento'];
    				$iva += $dato['iva'];
    				$total += $dato['total'];
    				//Se agrega el ultimo detalle
    				$detalle['fac_id'] = $dato['fac_id']; 
    				$detalle['codigo'] = $dato['codigo']; 
    				$detalle['fecha'] = $dato['fecha']; 
    				$detalle['tipo_pago'] = $dato['tipo_pago']; 
    				$detalle['cod_articulo'] = $dato['cod_articulo']; 
    				$detalle['nom_articulo'] = $dato['nom_articulo']; 
    				$detalle['cant_articulo'] = $dato['cant_articulo'];
    				$detalle['subtotal'] = $subtotal; 
    				$detalle['descuento'] = $descuento; 
    				$detalle['iva'] = $iva;
    				$detalle['total'] = $total;
    				array_push($resultados, $detalle);
    				//Resetear los datos de los acumuladores
    				$subtotal = 0.00;
    				$descuento = 0.00;
    				$iva = 0.00;
    				$total = 0.00;
    				//if($facid != $dato['fac_id']){
    				$facid = $dato['fac_id'];
    				//}
    				

    			}

    			$j++;
    		}	
    	}
    	return $resultados;
    }

	/**
    	* @author Francisco Orozco
    	* @since 2018-12-07
    	* @return reporte de ventas por categoria
    */
    	function ventas_categorias(){
    		satelite_validar();
    		if ($_POST) {
    			$fecha_inicio   = ( $this->input->post('txtFechaIni') != '' )? date('Y-m-d', strtotime( $this->input->post('txtFechaIni') )) : null;
    			$fecha_fin      = ( $this->input->post('txtFechaFin') != '')? date('Y-m-d', strtotime( $this->input->post('txtFechaFin') )) : null;
    			$slc_tipo_pago  = ( $this->input->post('slc_categoria') != '') ? $this->input->post('slc_categoria') : null;
    			$tipo_reporte   = ( $this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : '';

    			$where["fac_estado !="]		= 0;
    			$where_in					= null;
    			if ( $fecha_inicio != "" ) {
    				$where["DATE(fac_fecha_fact) >="]	= $fecha_inicio;
    			}

    			if ( $fecha_fin != "" ) {
    				$where["DATE(fac_fecha_fact) <="]	= $fecha_fin;
    			}

    			if ( $slc_tipo_pago != "null" ) {
    				$where_in = $slc_tipo_pago;
    			}

    			$data['consulta'] 		= $this->facturacion_model->get_ventas_categorias($where,$where_in);
    			$data["tipo_reporte"]   = $tipo_reporte;
    			$filename               = 'Reporte_venta_categoría' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    			$data['titulo']         = 'Reporte de venta por categoría';
    			$data['filename']       = $filename;
    			$data['desde']			= date('d-m-Y', strtotime( $fecha_inicio ) );
    			$data['fin']			= date('d-m-Y', strtotime( $fecha_fin ) );
    			$html 					= $this->load->view('facturacion/reportes/reporte_ventas_categorias', $data, true);

    			if ($tipo_reporte == 'pdf') {
    				$header                     = $this->load->view('reporte/header', $data, true);
    				$GLOBALS['nombre_reporte']  = 'Reporte_venta_categoría_' . date('dmY');
    				$reporte                    = $header . $html;
    				$this->pdf->makePdf($reporte, 'L', 'Reporte_venta_categoría_', 'Letter');
    			} elseif ($tipo_reporte == 'excel') {
    				echo $html;
    			} else {
    				$data2['html'] = $html;
    				echo json_encode($data2);
    				die();
    			}

    		} else {
    			$categorias				= $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array("tia_estado" => 1), '', '', 'tia_id', true);
    			$data['categorias']		= str_replace('<option value="0">Seleccione</option>', '', $categorias);
    			$data['titulo_personal']= 'Reporte de venta por categoría';
    			cargarvista($data);
    		}
    	}

	/**
    * @author Habby Lovo
    * @since 2019-03-04
    * @return generar reporte filtrar venta
    */
	public function informe_icv() {   
		satelite_validar();
		$permisos = $this->gsatelite->get_permisos_opcion();
		$data['permisos'] = $permisos;
		$slcTipoFac = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array("tif_estado" => 1), '', '', 'tif_id', true);
		$data['slcTipoFac'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slcTipoFac);         
		$data['titulo_personal'] = "Reporte ventas mayores/menores";

		cargarvista($data);
	}

    /**
    * @author Habby Lovo
    * @since 2019-03-04
    * @return filtrar ventas
    */

    public function filtrar_informe_icv($es_reporte=0){   
    	satelite_validar();
    	ini_set('memory_limit', '2048M');
    	ini_set('max_execution_time', '9999');
    	ini_set('max_input_vars', '2500');
    	$registros = array();
    	$permisos = $this->gsatelite->get_permisos_opcion('informe_icv');
    	$data['permisos'] = $permisos;
    	$ventas_filtro = $this->input->post('ventas_filtro');
    	$txtFecha_desde = $this->input->post('txtFecha_desde');
    	$txtFecha_hasta = $this->input->post('txtFecha_hasta');
    	$slcTipoFac = $this->input->post('slcTipoFac');
    	$chkConsolidar = $this->input->post('chkConsolidar');
    	$tipoGenerador = ($this->input->post('tipo_accion') > 0)? $this->input->post('tipo_accion'):0;
        // var_dump($_POST); die();
    	$where['fac_estado !='] = '0';
    	$where['id_iva'] = $this->gsatelite->get_parametro('SYS_ID_IVA');
    	if ($this->input->post()) {
    		if ($txtFecha_desde !='') {
    			$txtFecha_desde = '01-'.$txtFecha_desde;
    			$where['DATE(fac_fecha_fact) >='] = formatear_fecha('Y-m-d',$txtFecha_desde);
    		}
    		if ($txtFecha_hasta !='') {
    			$txtFecha_hasta = '01-'.$txtFecha_hasta;
    			$where['DATE(fac_fecha_fact) <='] = formatear_fecha('Y-m-t',$txtFecha_hasta);
    		}
            if(trim($ventas_filtro) != ''){ //si no viene 1 ni 2 son ventas generales sin condición sobre el total
            	if ($ventas_filtro != 3) {
            		$where['fac_impuesto >'] = 0;
            	}
            	if($ventas_filtro == 1){
            		$where['fac_total <='] = 200;
            	} else if($ventas_filtro == 2){
            		$where['fac_total >'] = 200;
            	}
            }
            if ((is_array($slcTipoFac) && count($slcTipoFac) > 0) || (trim($slcTipoFac) != '' && ($slcTipoFac) > 0 ) ) {
            	$ids_tif = (!is_array($slcTipoFac) && trim($slcTipoFac) > 0)? array(trim($slcTipoFac)):$slcTipoFac;
            	$where['fac_id_tif IN ('.implode(',', $ids_tif).')'] = null;
            }
            if ($chkConsolidar == 1) { //por Fecha
            	$where['group_by'] = "DATE(fac_fecha_fact)"; 
            }
        }
        $data['where_consulta'] = $where;
        $data['es_reporte'] = ($tipoGenerador > 0) ? 1 : 0;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['tipo_documento_nit'] = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $data['tipo_documento_nrc'] = $this->gsatelite->get_parametro('TIPO_DOCUMENTO_NRC_PROVEEDOR');        
        $meses = array('','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
        $data['meses'] = $meses;
        $data['ventas_filtro'] = $ventas_filtro;
        $html = $this->load->view('facturacion/reportes/filtrar_informe_icv', $data, true);

        $filtro_titulo = "";
        $filtro_titulo .= ($txtFecha_desde !='')? " Desde: ".$txtFecha_desde:"";
        $filtro_titulo .= ($txtFecha_hasta !='' )? " Hasta: ".$txtFecha_hasta:"";

        if ($tipoGenerador == 2) { //excel
        	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        	header("Content-Disposition: attachment;filename=ventas".date('d-m-Y_His').".xls"); 
        	header("Pragma: no-cache");
        	header("Expires: 0");
        	echo '<meta charset="utf-8" />';
        	echo "<table border='0'>
        	<tr><th colspan='10' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
        	<tr><th colspan='10' align='center' >Reporte ventas</th></tr>
        	<tr><th colspan='10' align='center' >".$filtro_titulo. "</th></tr>
        	</table>";
        	echo $html; die();
        } else if ($tipoGenerador == 1) { //pdf
        	ini_set( 'memory_limit', '2048M' );
        	ini_set('max_execution_time', '9999');
        	$this->load->library('pdf');
        	$html_header=$this->load->view('reporte/header', array('titulo' => "Reporte venta<br /> $filtro_titulo", 'solotitulo'=> true), true);
        	$html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
        	$this->pdf->makePDF($html_header.$html,'lanscape', 'total_activo','Letter');
        	die();
        } elseif ($tipoGenerador == 4) {//csv
        	$linea = array();
        	$registros = $this->facturacion_model->informe_ventas_icv($where);
        	$cod_anex_icv = ($ventas_filtro == 2) ? 4 : 5;
        	foreach ($registros as $key => $value) {
        		$linea_texto = array();
                if ($value['documento'] != "") {
                    $d = explode(':#', $value['documento']);
                    $doc = str_replace('-', '', $d[1]);
                    if ($d[2] == 2) {
                        $doc = str_pad($doc, 14, " ", STR_PAD_RIGHT);
                    } elseif ($d[2] == 3) {
                        $doc = str_pad($doc, 14, " ", STR_PAD_LEFT);
                    }
                    $t_d = $d[2];
                } else {
                    $t_d = 0;
                    $doc = str_pad('0', 14, " ", STR_PAD_RIGHT);
                }
        		$monto = number_format($value['subtotal'], 2, '.', '');
        		$iva = number_format($value['monto_iva'], 2, '.', '');
                $cliente = str_replace(array("Á", "É","Í", "Ó", "Ú"), array("A", "E", "I", "O", "U"), mb_strtoupper($value['cliente'], 'UTF-8'));
                //Columnas del reporte
        		if ($ventas_filtro != 1) {
        			$linea_texto[] = $value['mes'];
        			$linea_texto[] = $t_d;
        			$linea_texto[] = $doc;
        		}elseif ($ventas_filtro == 1) {
                    $linea_texto[] = $value['mes'];
                }
                if ($ventas_filtro == 2) {
                    $linea_texto[] = str_pad($cliente, 100, " ", STR_PAD_RIGHT);
                }
        		if ($ventas_filtro != 3) {
        			$linea_texto[] = formatear_fecha('dmY', $value['fecha_factura']);
        		}                
        		if ($ventas_filtro == 1) {
        			$linea_texto[] = str_pad(number_format($value['n_facturas'],0,'.',''), 8, "0", STR_PAD_LEFT);
        		}elseif ($ventas_filtro == 2) {
                    $linea_texto[] = str_pad($value['tif_codigo_hacienda'], 2, " ", STR_PAD_RIGHT);
        			$linea_texto[] = str_pad(str_replace('-', '', $value['numero']), 100, " ", STR_PAD_RIGHT);
        		}
        		$linea_texto[] = str_pad($monto, 11, "0", STR_PAD_LEFT);
        		if ($ventas_filtro != 3) {
        			$linea_texto[] = str_pad($iva, 11, "0", STR_PAD_LEFT);
        		}                
        		$linea_texto[] = $value['anio'];
        		if ($ventas_filtro != 3) {
        			$linea_texto[] = $cod_anex_icv;
        		}        		
        		$linea[] = trim(implode(',', $linea_texto));
        	}
        	$ruta_carga = 'public/temp/archivos/';
        	$nombre = 'ventas_icv_'.date('d-m-Y').'.csv';
        	$ruta_completa  = $ruta_carga . $nombre;
        	if (file_exists($ruta_completa)) {
        		unlink($ruta_completa);
        	}
        	$separador = chr(13) . chr(10);
        	$texto_completo = $separador . implode($separador, $linea);
        	$archivo = fopen($ruta_completa, 'w+') or die('Sin permisos de escritura en el servidor');
        	$texto_completo = trim($texto_completo);
        	fputs($archivo, $texto_completo);
        	fclose($archivo);
        	if (ob_get_contents()) ob_end_clean();
        	header('Content-Type: text/html; charset=utf-8');
        	header("Content-Type: application/octet-stream");
        	header('Content-Disposition: attachment; filename=' . $nombre);
        	readfile($ruta_completa);
        	die();
        } else if ($tipoGenerador == 3) { //txt
        	$registros=$this->facturacion_model->informe_ventas_icv($where);
        	$array_lineas = array();
        	$array_lineas_inconsistentes[] = '======================== LINEAS INCONSISTENTES =========================';
        	$ruta_carga='public/temp/archivos/';
        	$nombre='compras_proveedor_'.date('d-m-Y_H_i').'.prn';
        	if($ventas_filtro == 1){
                /* ================================================================================================
                                            FORMATO PARA VENTAS MENORES = A 200
                                            ================================================================================================ */
                                            $nombre='ventas_menores'.date('d-m-Y_H_i').'.prn';
                                            foreach ($registros as $f) {
                                            	$linea = "";

                                            	$registro = "";
                                            	if($f['cli_registro'] != null){
                    	$registro = str_replace('-', '', $f['cli_registro']);// registro del cliente
                    }
                    $registro = ($chkConsolidar == 1)? $f['n_facturas']:$registro;
                    $linea .=  str_pad(trim($f['anio'].$f['mes'].$f['dia']), 8, "", STR_PAD_RIGHT);
                    $linea .=  str_pad(trim($registro), 8, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(number_format($f['subtotal'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(number_format($f['monto_iva'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(trim($f['anio']), 4, " ", STR_PAD_RIGHT);
                    if ($registro != ""){
                    	$array_lineas[] = $linea;
                    }
                    else{
                    	$array_lineas_inconsistentes[] = $linea;
                    }
                }
                /* ================================================================================================
                                            FIN FORMATO PARA VENTAS MENORES = A 200
                                            ================================================================================================ */
                                        } else if($ventas_filtro == 2){
                                        	$registros=$this->facturacion_model->informe_ventas_icv($where);
                /* ================================================================================================
                                                FORMATO PARA VENTAS MAYORES A 200
                                                ================================================================================================ */
                                                $nombre='ventas_mayores'.date('d-m-Y_H_i').'.prn';
                                                foreach ($registros as $f) {
                                                	$linea = "";
                                                	$tdoc = "---";
                                                	$ndoc = "---";
                                                	$id_ndohacienda = "";
                                                	if (trim($f['documento']) != '') {
                                                		$d = explode(':#', $f['documento']);
                        $tdoc = $d[0];//no se usa
                        $ndoc = str_replace('-', '', $d[1]);//numero de documento sin guiones
                        $id_ndohacienda = $d[2];//numero segun hacienda
                    }

                    if($id_ndohacienda > 5){
                    	$id_ndohacienda = 6;
                    }

                    $linea .=  str_pad(trim($f['mes']), 2, " ", STR_PAD_RIGHT);//Mes
                    $linea .=  str_pad(trim($id_ndohacienda), 1, " ", STR_PAD_RIGHT);//Tipo de documento
                    $linea .=  str_pad(trim($ndoc), 14, ' ', STR_PAD_RIGHT);//Documento
                    $linea .=  str_pad(trim($f['anio'].$f['mes'].$f['dia']), 8, "", STR_PAD_RIGHT);//fecha emision
                    $linea .=  str_pad(trim($f['tif_codigo_hacienda']), 1, " ", STR_PAD_RIGHT);//Tipo de documento factura
                    $linea .=  str_pad(trim($f['numero']), 20, " ", STR_PAD_RIGHT);//numero factura
                    $linea .=  str_pad(number_format($f['subtotal'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(number_format($f['monto_iva'],2,'',''), 11, "0", STR_PAD_LEFT);
                    $linea .=  str_pad(trim($f['anio']), 4, " ", STR_PAD_RIGHT);

                    if ($ndoc != "---" && $id_ndohacienda != ""){
                    	$array_lineas[] = $linea;
                    }
                    else{
                    	$array_lineas_inconsistentes[] = $linea;
                    }
                }
                /* ================================================================================================
                                                FIN FORMATO PARA VENTAS MAYORES A 200
                                                ================================================================================================ */
                                            } else {
            	/* ================================================================================================
            	                            FORMATO PARA VENTAS GENERALES (MISMO FORMATO QUE EL DE MENORES A 200)
            	                            ================================================================================================ */
            	                            $nombre='ventas_generales'.date('d-m-Y_H_i').'.prn';
            	                            foreach ($registros as $f) {
            	                            	$linea = "";

            	                            	$registro = "";
            	                            	if($f['cli_registro'] != null){
            	    	$registro = str_replace('-', '', $f['cli_registro']);// registro del cliente
            	    }
            	    $registro = ($chkConsolidar == 1)? $f['n_facturas']:$registro;
            	    $linea .=  str_pad(trim($f['anio'].$f['mes'].$f['dia']), 8, "", STR_PAD_RIGHT);
            	    $linea .=  str_pad(trim($registro), 8, "0", STR_PAD_LEFT);
            	    $linea .=  str_pad(number_format($f['subtotal'],2,'',''), 11, "0", STR_PAD_LEFT);
            	    $linea .=  str_pad(number_format($f['monto_iva'],2,'',''), 11, "0", STR_PAD_LEFT);
            	    $linea .=  str_pad(trim($f['anio']), 4, " ", STR_PAD_RIGHT);
            	    if ($registro != ""){
            	    	$array_lineas[] = $linea;
            	    }
            	    else{
            	    	$array_lineas_inconsistentes[] = $linea;
            	    }
            	}
            	/* ================================================================================================
            	                            FIN FORMATO PARA VENTAS GENERALES (MISMO FORMATO QUE EL DE MENORES A 200)
            	                            ================================================================================================ */
            	                        }
            /* ================================================================================================
                                    GENERACION DEL ARCHIVO PRN
                                    ================================================================================================ */
                                    $separador = chr(13).chr(10);
                                    if (count($array_lineas_inconsistentes)>1){
                                    	$lineas = implode($separador,array_merge($array_lineas,$array_lineas_inconsistentes));
                                    }
                                    else{
                                    	$lineas = implode($separador,$array_lineas);
                                    }

                                    $ruta_completa=$ruta_carga.$nombre;

                                    if (file_exists("$ruta_completa")) {
                unlink("$ruta_completa"); //eliminar el archivo si existiese
            }
            $archivo=fopen($ruta_completa,'w+') or die('No hay permisos de escritura');
            $lineas=trim($lineas);
            fputs($archivo, $lineas);
            fclose($archivo);
            header( "Content-Type: application/octet-stream");
            header('Content-Disposition: attachment; filename="'.$nombre.'"');
           // header("Location: ".base_url()."public/temp/archivos/$nombre");
            ob_clean(); 
            flush(); 
            readfile("$ruta_completa");
            #header("Location: " . base_url() . "uploads/txt_planilla/$nombre_archivo"); 
            die();
        }
        echo json_encode(array('html'=>$html));
    }

    function _cargarvista($data=0,$crud=0){
    	$this->load->view('vacia',$crud);
    	if($data!=0)
    		$data=array_merge($data,$this->masterpage->getUsuario());
    	else
    		$data=$this->masterpage->getUsuario();
    	$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
    	$this->masterpage->setMasterPage('masterpage_default');
    	$this->masterpage->addContentPage($vista, 'content',$data);
    	$this->masterpage->show();
    }

    function corte_caja($flag = null){              
    	satelite_validar();
    	if ($_POST){
    		$post_array = $this->input->post();
    		if ($flag) {            	
    			$fecha_inicio = ($post_array['txtFechaIni'] != '') ? $post_array['txtFechaIni'] : null;
    			$fecha_fin    = ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
    			$caja     	  = ($post_array['caja'] != '') ? $post_array['caja'] : null;
    		} else {
    			$fecha_inicio = ($post_array['h_fecha_ini'] != '') ? $post_array['h_fecha_ini'] : null;
    			$fecha_fin    = ($post_array['h_fecha_fin'] != '') ? $post_array['h_fecha_fin'] : null;                
    			$caja         = ($post_array['h_caja_id'] != '') ? $post_array['h_caja_id'] : null;
    			$data['fecha_desde_text'] = '<b>Desde: </b>' . $post_array['h_fecha_ini'];
    			$data['fecha_hasta_text'] = '<b>Hasta: </b>' . $post_array['h_fecha_fin'];
    			$data['caja_text'] = ($post_array['h_caja_text'] != '') ? '<b>Caja: </b>' . $post_array['h_caja_text'] : '<b>Cajas: </b>' .'Todas';
    		}
    		$tipo_reporte = $this->input->post('tipo_reporte');
    		$where_in = null;
    		$where_out = null;
    		if ($fecha_inicio != null && $fecha_fin != null) {
    			$where['fac_fecha_cont >='] = (formatear_fecha('Y-m-d', $fecha_inicio)) . ' 00:00:00';
    			$where['fac_fecha_cont <='] = (formatear_fecha('Y-m-d', $fecha_fin)) . ' 23:59:59';
    		}
    		if ($caja != null) {
    			$where['caj_id'] = $caja;
    		}
    		$where['fac_estado !='] = 0;
    		$tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
    		$nt_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
    		$where['fac_id_tif !='] = $nt_remi;
    		$reporte = $this->facturacion_model->get_facturacion_corte_caja($where);
    		$filename = 'rpt_corte_caja' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
    		$data['filename']              = $filename;
    		$data['reporte']               = $reporte;
    		$data['tipo_reporte'] = $tipo_reporte;
    		$data['titulo'] = 'Reporte de Corte de Caja';
    		$html = $this->load->view('facturacion/reportes/filtrar_corte_caja', $data, true);            
    		if ($flag) {          
    			echo $html;
    			die();
    		} else {
    			if ($tipo_reporte == 'pdf') {
    				$header = $this->load->view('reporte/header', $data, true);
    				$GLOBALS['nombre_reporte'] = 'reporte_corte_caja_' . date('dmY');
    				$reporte = $header . $html;
    				$this->pdf->makePdf($reporte, 'P', 'reporte_corte_caja', 'Letter');
    			} elseif ($tipo_reporte == 'excel') {
    				echo $html;
    			}
    		}
    	} else{
    		$select = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}', '', array('caj_estado' => 1), null, '', 'caj_id', true);
    		$data["cajas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/corte_caja');
    		$data['titulo_personal'] = "Reporte de Corte de Caja";
    		$this->_cargarvista($data);
    	}
    }//Fin funcion corte_caja

    /**
     * Consultas:reporte de cotizaciones facturadas
     * @author Marlon Olmedo
     * @since  16-07-2019
     * @param  none
     */
    public function reporte_cotizaciones_facturadas() {
    	satelite_validar();
        $datos['vendedores'] = $this->gsatelite->get_tabla('ven_vendedor',"ven_estado <> 0");//Obtener los vendedores
        $datos['titulo_personal'] = 'Cotizaciones Facturadas';
        $this->_cargarvista($datos, null);
    }
/**
     * Consultas:imprime la grid de el reporte de cotizaciones facturadas y obtiene los datos
     * @author Marlon Olmedo
     * @since  16-07-2019
     * @param  none
     */
public function get_cotizaciones_facturadas() {
	satelite_validar();

	$f1 = date('Y-m-d 00:00:00', strtotime($this->input->post('desde')));
	$f2 = date('Y-m-d 23:00:00', strtotime($this->input->post('hasta')));
        //$limite = ($this->input->post('cantidad') != "") ? $this->input->post('cantidad') : "10";
	$vendedor = ($this->input->post('vendedor') != "") ? $this->input->post('vendedor') : "";
	$tipo = $this->input->post('tipo');
	if ($this->input->post('desde') != "" and $this->input->post('hasta') != "") {
		$where = array(
			'cot_fecha_pres >=' => $f1, 
			'cot_fecha_pres <=' => $f2
		);
		if ($vendedor != "") {
			$where['ven_id'] = $vendedor;
		}
		$where['cot_estado'] = 1;
		$where['cot_estado_facturacion >'] = 0;
		$data['consulta'] = $this->facturacion_model->get_cotizaciones_facturadas($where);
            //print_r($this->db->last_query());die();
		$data['fecha1'] = date('d-m-Y', strtotime($this->input->post('desde')));
		$data['fecha2'] = date('d-m-Y', strtotime($this->input->post('hasta')));
            //$data['np'] = $limite;
		$data['id_ven'] = $vendedor;
		$html = $this->load->view('facturacion/reportes/get_cotizaciones_facturadas', $data, true);
	}

	if ($tipo == null or $tipo == "") {
		echo $html;
	} else if ($tipo == 2) {
		$this->load->library('pdf');
		$html_header = $this->load->view('reporte/header', array('titulo' => 'Cotizaciones Facturadas'), true);
		$reporte = $this->pdf->makePDF($html_header . $html, 'L');
	} else {
		header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
		header("Content-Disposition: attachment;filename=Reporte_cotizacion_facturadas.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		$html_header = $this->load->view('reporte/header', array('titulo' => 'Cotizaciones Facturadas'), true);
		echo $html_header.$html;
	}
}

    /**
     * Descripción:
     * Función para mostrar los datos de los expedientes del paciente creados
     * @author Habby Lovo - Grupo satélite
     * @since  2019-08-12
     * @param  Ninguno
     * @return registros de paciente
     */
    function reporte_utilidad(){
    	try{
    		ini_set('memory_limit', '-1');
    		ini_set('max_execution_time', '9999');
    		if($this->input->post()){
    			$txtFechaInicio = $this->input->post('txtFechaInicio');
    			$txtFechaFin = $this->input->post('txtFechaFin');
    			$slcSucursal = $this->input->post('slcSucursal');

    			$where = array();
    			if($txtFechaInicio != '' && $txtFechaFin != ''){
    				$where['(DATE(fac_fecha_fact) >= "'.formatear_fecha("Y-m-d", $txtFechaInicio).'" AND DATE(fac_fecha_fact) <= "'.formatear_fecha("Y-m-d", $txtFechaFin).'" )' ] = null;
    			}
    			if($slcSucursal != ''){
    				$where['fac_id_suc' ] = $slcSucursal;
    			}

    			$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

    			$where['fac_estado != 0'] = null;
    			$reporte_reg = $this->facturacion_model->get_reporte_utilidad($where);
                // print_r($this->db->last_query());
                // die();
    			$data["reporte_reg"] = $reporte_reg;
    			$data['tipo'] = $tipo;
    			$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
    			$html = $this->load->view('facturacion/reportes/tabla_reporte_utilidad', $data, true);
    			echo $html;
    			die();
    		}
    		$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array(), null, '', 'suc_id', true);
    		$data['slcSucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

    		$data['titulo_personal'] = 'Reporte de utilidad/perdida';
    		cargarvista($data);
    	} catch (Exception $e) {
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    	
    }

    function imprimir_reporte_utilidad(){
    	try{
    		ini_set('memory_limit', '-1');
    		ini_set('max_execution_time', '9999');
    		if($this->input->post()){
    			$txtFechaInicio = $this->input->post('txtFechaInicio');
    			$txtFechaFin = $this->input->post('txtFechaFin');
    			$slcSucursal = $this->input->post('slcSucursal');
    			$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

    			$where = array();
    			if($txtFechaInicio != '' && $txtFechaFin != ''){
    				$where['(DATE(fac_fecha_fact) >= "'.formatear_fecha("Y-m-d", $txtFechaInicio).'" AND DATE(fac_fecha_fact) <= "'.formatear_fecha("Y-m-d", $txtFechaFin).'" )' ] = null;
    			}
    			if($slcSucursal != ''){
    				$where['fac_id_suc' ] = $slcSucursal;
    			}
    			$where['fac_estado != 0'] = null;
    			$reporte_reg = $this->facturacion_model->get_reporte_utilidad($where);
    			$data["reporte_reg"] = $reporte_reg;
    			$data['tipo'] = $tipo;
    			$data['filename'] = 'Reporte de utilidad';
    			$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
    			if($tipo == 'excel'){
    				$html = $this->load->view('facturacion/reportes/tabla_reporte_utilidad', $data, true);
    				echo $html;
    			} else{
    				ini_set('display_errors', 0);
    				$html_header = $this->load->view('reporte/header', array('titulo' => 'utilidad'), true);
    				$html = $this->load->view('facturacion/reportes/tabla_reporte_utilidad_pdf', $data, true);
    				$head = '<!DOCTYPE html><html><head><title>Reporte Utilidad</title></head><body><script type="text/javascript">';
    				$head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte de Utilidad";';
    				$head .= 'window.print();</script>';
    				$footer = '</body></html>';
    				$reporte = $head . $html_header . $html . $footer;// $this->pdf->makePDF($html_header . $html, 'L');
    				echo $reporte;
		            // $this->pdf->makePdf($html, 'h', 'Reporte_de_programas_vinculados', 'Letter');
    			}
    			die();
    		}
    	} catch (Exception $e) {
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    }

    function reporte_descuentos($id_factura = NULL){
    	satelite_validar();
    	if ($id_factura) {
    		$this->load->library('pdf');
    		$where['fac_id'] = $id_factura;
    		$detalles = $this->facturacion_model->get_reporte_descuentos($where);
    		// print_r($this->db->last_query());
    		// die();
    		// $usu = ($detalles[0]['def_usu_autoriza_descuento'] != '') ? $detalles[0]['def_usu_autoriza_descuento'] : $detalles[0]['def_usu_crea'];
    		$usu = ($detalles[0]['def_usu_autoriza_descuento'] != '') ? $detalles[0]['def_usu_autoriza_descuento'] : null;
    		if($usu != null){
    			$emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $usu));
    			$data['autorizo'] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $emp, 'emp_estado' => 1));
    		} else{
    			$data['autorizo'] = array();
    		}
    		
    		$data['detalles'] = $detalles;
    		
    		$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
    		$html = $this->load->view('facturacion/reportes/detalle_descuento_factura',$data,true);    		
    		$html_header=$this->load->view('reporte/header', array('titulo' => "Reporte de Descuentos por Facturas", 'solotitulo'=> true), true);                
    		$this->pdf->makePDF($html_header . $html,'P', 'reporte_descuentos','Letter');
    		die();
    	}    	
    }

    /**
     * @author Habby Lovo;
     * @since 21/09/2017
 	*/

    public function reporte_beneficios($consulta = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion('facturacion/reportes/reporte_beneficios');
    		if ($_POST) {
    			if ($consulta > 0) {
    				$post_array = $_POST;

    				$caja = $post_array['caja'];
    				$text_caja = $post_array['txtcaja'];
    				$fecha_inicio = $post_array['fecha_ini'];
    				$fecha_fin = $post_array['fecha_fin'];
    				$slcBeneficios = $post_array['slcBeneficios'];

    				$data['caja_id'] = $caja;
    				$data['caja_text'] = $text_caja;
    				$data['fecha_ini'] = $fecha_inicio;
    				$data['fecha_fin'] = $fecha_fin;
    				$data['slcBeneficios'] = $slcBeneficios;

    				$beneficios_reg = $this->gsatelite->get_tabla('tbf_tipo_beneficio', array('tbf_id' => $slcBeneficios));
    				$data['beneficios'] = '';
    				if(count($beneficios_reg) > 0){
    					$data['beneficios'] = $beneficios_reg[0]['tbf_porcentaje'];
    				}
    				$where_beneficio = null;
    				if($slcBeneficios != ''){
    					$where_beneficio = array('tbf_id' => $slcBeneficios);
    				}
    				$clientes_reg = $this->facturacion_model->get_clientes_beneficios($where_beneficio);
    				$clientes_ids = array();
    				foreach ($clientes_reg as $key => $value) {
    					$clientes_ids[] = ($value['alm_id_cli_factura'] != null)?$value['alm_id_cli_factura']:$value['cli_id'];
    				}
                    // print_r($clientes_ids);
                    // die();
    				$where = null;
    				if(count($clientes_ids) > 0){
    					$where['fac_id_cli in ('.implode(',', $clientes_ids).')'] = null;
    				} else{
    					$where['fac_id_cli in (0)'] = null;
    				}

    				if ($fecha_inicio != '' && $fecha_fin != '') {
    					$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
    					$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    				}

    				if(trim($caja) != ""){
    					$where['uxc_id_caj'] = $caja;
    				}
    				$usuarios = $this->facturacion_model->get_factura_caja($where, 1);
    				$usuario_array = array();
    				$correlativos_array = array();
    				foreach ($usuarios as $key) {
    					$correlativos_array[] = $key['tif_nombre'].':'.$key['inicio'].'-'.$key['fin'];
    					$temp_usuario_array = explode(',', $key['empleados']);
    					if(count($temp_usuario_array) > 1){
    						foreach ($temp_usuario_array as $key2) {
    							$usuario_array[] = trim($key2);
    						}
    					} else{
    						$usuario_array[] = trim($key['empleados']);
    					}
    				}

    				$usuario_array = array_unique($usuario_array);
    				$usuario_array = implode(', ', $usuario_array);
    				$correlativos_array = implode(', ', $correlativos_array);
    				$data['usuarios_caja'] = $usuario_array;
    				$data['rangos_corr_caja'] = $correlativos_array;
    				$data['registros_facturaxcaja'] = $this->facturacion_model->get_factura_caja($where);
    				$data['tipo_reporte'] = 'grid';
    				$html = $this->load->view('facturacion/reportes/imprimir_reporte_caja', $data, true);

    				echo $html;
    				die();
    			}
    		} else {
    			$select = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}', '', array('caj_estado' => 1), null, '', 'caj_id', true);
    			$data['cajas'] = str_replace('<option value="0">Seleccione</option>', '', $select);

    			$select = $this->gsatelite->get_dropdown('tbf_tipo_beneficio', '{tbf_nombre}', '', array('tbf_estado' => 1), null, '', 'tbf_id', true);
    			$data['slcBeneficios'] = str_replace('<option value="0">Seleccione</option>', '', $select);

    			$data['titulo_personal'] = 'Reporte de caja';
    			$this->_cargarvista($data);
    		}
    	}
    }
    function imprimir_reporte_beneficios(){
    	$post_array = $_POST;

    	$caja = $post_array['rpt_slcCaja'];
    	$text_caja = $post_array['rpt_txtCaja'];
    	$fecha_inicio = $post_array['rpt_txtFechaIni'];
    	$fecha_fin = $post_array['rpt_txtFechaFin'];
    	$tipo = $post_array['tipo_reporte'];
    	$slcBeneficios = $post_array['rpt_slcBeneficios'];


    	$data['caja_id'] = $caja;
    	$data['caja_text'] = $text_caja;
    	$data['fecha_ini'] = $fecha_inicio;
    	$data['fecha_fin'] = $fecha_fin;
    	$data['tipo_reporte'] = $tipo;

    	$where = null;

    	$data['slcBeneficios'] = $slcBeneficios;

    	$beneficios_reg = $this->gsatelite->get_tabla('tbf_tipo_beneficio', array('tbf_id' => $slcBeneficios));
    	$data['beneficios'] = '';
    	if(count($beneficios_reg) > 0){
    		$data['beneficios'] = $beneficios_reg[0]['tbf_porcentaje'];
    	}
    	$where_beneficio = null;
    	if($slcBeneficios != ''){
    		$where_beneficio = array('tbf_id' => $slcBeneficios);
    	}
    	$clientes_reg = $this->facturacion_model->get_clientes_beneficios($where_beneficio);

    	$clientes_ids = array();
    	foreach ($clientes_reg as $key => $value) {
    		$clientes_ids[] = ($value['alm_id_cli_factura'] != null)?$value['alm_id_cli_factura']:$value['cli_id'];
    	}
        // print_r($clientes_ids);
        // die();
    	$where = null;
    	if(count($clientes_ids) > 0){
    		$where['fac_id_cli in ('.implode(',', $clientes_ids).')'] = null;
    	} else{
    		$where['fac_id_cli in (0)'] = null;
    	}

    	if ($fecha_inicio != '' && $fecha_fin != '') {
    		$where['fac_fecha_fact >='] = date('Y-m-d', strtotime($fecha_inicio));
    		$where['fac_fecha_fact <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
    	}

    	if(trim($caja) != ""){
    		$where['uxc_id_caj'] = $caja;
    	}
    	$usuarios = $this->facturacion_model->get_factura_caja($where, 1);
    	$usuario_array = array();
    	$correlativos_array = array();
    	foreach ($usuarios as $key) {
    		$correlativos_array[] = $key['tif_nombre'].':'.$key['inicio'].'-'.$key['fin'];
    		$temp_usuario_array = explode(',', $key['empleados']);
    		if(count($temp_usuario_array) > 1){
    			foreach ($temp_usuario_array as $key2) {
    				$usuario_array[] = trim($key2);
    			}
    		} else{
    			$usuario_array[] = trim($key['empleados']);
    		}
    	}

    	$usuario_array = array_unique($usuario_array);
    	$usuario_array = implode(', ', $usuario_array);
    	$correlativos_array = implode(', ', $correlativos_array);
    	$data['usuarios_caja'] = $usuario_array;
    	$data['rangos_corr_caja'] = $correlativos_array;
    	$data['registros_facturaxcaja'] = $this->facturacion_model->get_factura_caja($where);


    	if($tipo == 'excel'){
    		$filename = 'rpt_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    		$data['filename'] = $filename;
    		$this->load->view('facturacion/reportes/imprimir_reporte_caja', $data);
    	} else{
    		$data['titulo'] = 'caja';
    		$header = $this->load->view('reporte/header', $data, true);

    		$html = $this->load->view('facturacion/reportes/imprimir_reporte_caja', $data, true);
    		$GLOBALS['nombre_reporte'] = 'Abono_detallado' . date('dmY');

    		$this->pdf->makePdf($header.$html, 'L', 'Abono_detallado', 'Letter');
    	}
    }

    /**
     * Descripción:
     * Función para mostrar los datos de los seguimientos de las facturas anuladas
     * @author Habby Lovo - Grupo satélite
     * @since  2019-09-27
     * @param  Ninguno
     * @return registros de paciente
     */
    function reporte_seguimiento_factura_anulada(){
    	try{
    		ini_set('memory_limit', '-1');
    		ini_set('max_execution_time', '9999');
    		if($this->input->post()){
    			$txtFechaInicio = $this->input->post('txtFechaInicio');
    			$txtFechaFin = $this->input->post('txtFechaFin');
    			$slcSucursal = $this->input->post('slcSucursal');
    			$slcTipoFactura = $this->input->post('slcTipoFactura');
    			$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

    			$where = array();
    			if($txtFechaInicio != '' && $txtFechaFin != ''){
    				$where['(date(fac_fecha_fact) >= "'.formatear_fecha('Y-m-d', $txtFechaInicio).'" AND date(fac_fecha_fact) <= "'.formatear_fecha('Y-m-d', $txtFechaFin).'")'] = null;
    			}

    			if($slcSucursal != ''){
    				$where['fac_id_suc' ] = $slcSucursal;
    			}

    			if($slcTipoFactura != ''){
    				$where['fac_id_tif' ] = $slcTipoFactura;
    			}

    			$where['fac_aplica_seguimiento_anulacion'] = 1;

    			$this->db->join('afa_abono_factura_anulada', 'afa_id_fac = fac_id', 'INNER');
    			$this->db->order_by('fac_id, fac_fecha_fact, afa_id', 'ASC');
    			$reporte_reg = $this->facturacion_model->get_facturas_seguimiento($where);

    			$data["reporte_reg"] = $reporte_reg;
    			$data['tipo'] = $tipo;
    			$html = $this->load->view('facturacion/reportes/tabla_reporte_seguimiento_factura_anulada', $data, true);
    			echo $html;
    			die();
    		}
    		$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array(), null, '', 'suc_id', true);
    		$data['slcSucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

	        // $tipo_factura = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1, 'tif_aplica_anulacion' => 1));
    		$select = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1, 'tif_aplica_anulacion' => 1), null, '', 'tif_id', true);
    		$data['slcTipoFactura'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

    		$data['titulo_personal'] = 'Reporte de seguimiento de facturas anuladas';
    		cargarvista($data);
    	} catch (Exception $e) {
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    	
    }

    function imprimir_reporte_seguimiento_factura_anulada(){
    	try{
    		ini_set('memory_limit', '-1');
    		ini_set('max_execution_time', '9999');
    		if($this->input->post()){
    			$txtFechaInicio = $this->input->post('txtFechaInicio');
    			$txtFechaFin = $this->input->post('txtFechaFin');
    			$slcSucursal = $this->input->post('slcSucursal');
    			$slcTipoFactura = $this->input->post('slcTipoFactura');
    			$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

    			$where = array();
    			if($txtFechaInicio != '' && $txtFechaFin != ''){
    				$where['(date(fac_fecha_fact) >= "'.formatear_fecha('Y-m-d', $txtFechaInicio).'" AND date(fac_fecha_fact) <= "'.formatear_fecha('Y-m-d', $txtFechaFin).'")'] = null;
    			}

    			if($slcSucursal != ''){
    				$where['fac_id_suc' ] = $slcSucursal;
    			}

    			if($slcTipoFactura != ''){
    				$where['fac_id_tif' ] = $slcTipoFactura;
    			}

    			$where['fac_aplica_seguimiento_anulacion'] = 1;

    			$this->db->join('afa_abono_factura_anulada', 'afa_id_fac = fac_id', 'INNER');
    			$this->db->order_by('fac_id, fac_fecha_fact, afa_id', 'ASC');
    			$reporte_reg = $this->facturacion_model->get_facturas_seguimiento($where);

    			$data["reporte_reg"] = $reporte_reg;
    			$data['tipo'] = $tipo;
    			$data['filename'] = 'Reporte de seguimiento de facturas anuladas';
    			if($tipo == 'excel'){
    				$html = $this->load->view('facturacion/reportes/tabla_reporte_seguimiento_factura_anulada', $data, true);
    				echo $html;
    			} else{
		            // ini_set('display_errors', 0);
    				$html_header = $this->load->view('reporte/header', array('titulo' => 'seguimiento de facturas anuladas'), true);
    				$html = $this->load->view('facturacion/reportes/tabla_reporte_seguimiento_factura_anulada_pdf', $data, true);
		            // echo $html;
		            // die();
    				$reporte = $this->pdf->makePDF($html_header . $html, 'L');
		            // $this->pdf->makePdf($html, 'h', 'Reporte_de_programas_vinculados', 'Letter');
    			}
    			die();
    		}
    	} catch (Exception $e) {
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    }

    /**
     * Descripción:
     * Función para mostrar los datos de los expedientes del paciente creados
     * @author Habby Lovo - Grupo satélite
     * @since  2019-11-08
     * @param  Ninguno
     * @return registros de paciente
     */
    function reporte_ventas_consolidado(){
    	try{
    		ini_set('memory_limit', '-1');
    		ini_set('max_execution_time', '9999');
    		if($this->input->post()){
    			$txtFechaInicio = $this->input->post('txtFechaInicio');
    			$txtFechaFin = $this->input->post('txtFechaFin');
    			$slcSucursal = $this->input->post('slcSucursal');

    			$where = array();
    			if($txtFechaInicio != '' && $txtFechaFin != ''){
    				$where['(DATE(fac_fecha_fact) >= "'.formatear_fecha("Y-m-d", $txtFechaInicio).'" AND DATE(fac_fecha_fact) <= "'.formatear_fecha("Y-m-d", $txtFechaFin).'" )' ] = null;
    			}
    			if($slcSucursal != ''){
    				$where['fac_id_suc' ] = $slcSucursal;
    			}

    			$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

    			$where['fac_estado != 0'] = null;
    			$reporte_reg = $this->facturacion_model->get_ventas_consolidado($where);
                //print_r($this->db->last_query());
                // die();
    			$data["reporte_reg"] = $reporte_reg;
    			$data['tipo'] = $tipo;
    			$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
    			$html = $this->load->view('facturacion/reportes/tabla_reporte_ventas_consolidado', $data, true);
    			echo $html;
    			die();
    		}
    		$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array(), null, '', 'suc_id', true);
    		$data['slcSucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

    		$data['titulo_personal'] = 'Reporte de ventas consolidado';
    		cargarvista($data);
    	} catch (Exception $e) {
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    	
    }

    function imprimir_reporte_ventas_consolidado(){
    	try{
    		ini_set('memory_limit', '-1');
    		ini_set('max_execution_time', '9999');
    		if($this->input->post()){
    			$txtFechaInicio = $this->input->post('txtFechaInicio');
    			$txtFechaFin = $this->input->post('txtFechaFin');
    			$slcSucursal = $this->input->post('slcSucursal');
    			$tipo = ($this->input->post('tipo_reporte') != '')?$this->input->post('tipo_reporte'):'';

    			$where = array();
    			if($txtFechaInicio != '' && $txtFechaFin != ''){
    				$where['(DATE(fac_fecha_fact) >= "'.formatear_fecha("Y-m-d", $txtFechaInicio).'" AND DATE(fac_fecha_fact) <= "'.formatear_fecha("Y-m-d", $txtFechaFin).'" )' ] = null;
    			}
    			if($slcSucursal != ''){
    				$where['fac_id_suc' ] = $slcSucursal;
    			}
    			$where['fac_estado != 0'] = null;
    			$reporte_reg = $this->facturacion_model->get_ventas_consolidado($where);
    			$data["reporte_reg"] = $reporte_reg;
    			$data['tipo'] = $tipo;
    			$data['filename'] = 'Reporte de ventas consolidado';
    			$data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
    			if($tipo == 'excel'){
    				$html = $this->load->view('facturacion/reportes/tabla_reporte_ventas_consolidado', $data, true);
    				echo $html;
    			} else{
    				ini_set('display_errors', 0);
    				$html_header = $this->load->view('reporte/header', array('titulo' => 'Ventas Consolidado'), true);
    				$html = $this->load->view('facturacion/reportes/tabla_reporte_ventas_consolidado_pdf', $data, true);
		            // echo $html;
		            // die();
    				$reporte = $this->pdf->makePDF($html_header . $html, 'L');
		            // $this->pdf->makePdf($html, 'h', 'Reporte_de_programas_vinculados', 'Letter');
    			}
    			die();
    		}
    	} catch (Exception $e) {
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    }

     /**
     * Descripción:
     * Función para reporte de ventas por sucursal
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-10-22
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
     function reporte_participacion_ventas_cliente($flag = null){              
     	satelite_validar();       
     	if ($_POST){            
     		$post_array = $this->input->post();            
            //Si es consulta ajax se toman los nombres del Jquery si no, se toman los filtros de impresión
            //print_r($post_array); die();
     		if ($flag) {
     			$fecha_inicio = ($post_array['fecha_desde'] != '') ? $post_array['fecha_desde'] : null;
     			$fecha_fin    = ($post_array['fecha_hasta'] != '') ? $post_array['fecha_hasta'] : null;
     			$cliente      = ($post_array['cliente'] != '') ? $post_array['cliente'] : null;
     			$vendedor     = ($post_array['vendedor'] != '') ? $post_array['vendedor'] : null;
                //$tipo_factura     = ($post_array['tipo_factura'] != '') ? $post_array['tipo_factura'] : null;            
     		} else {
     			$fecha_inicio = ($post_array['hFecha_desde'] != '') ? $post_array['hFecha_desde'] : null;
     			$fecha_fin    = ($post_array['hFecha_hasta'] != '') ? $post_array['hFecha_hasta'] : null;                
     			$cliente      = ($post_array['hslcCliente'] != null) ? $post_array['hslcCliente'] : null;
     			$vendedor     = ($post_array['hvendedor'] != '') ? $post_array['hvendedor'] : null;
                //$tipo_factura         = ($post_array['hslcTipoFactura'] != '') ? $post_array['hslcTipoFactura'] : null;
     			$data['fecha_desde_text'] = ($post_array['hFecha_desde'] != '') ? '<b>Desde: </b>' . $post_array['hFecha_desde'] : '<b>Desde: </b>' . '';
     			$data['fecha_hasta_text'] = ($post_array['hFecha_hasta'] != '') ? '<b>Hasta: </b>' . $post_array['hFecha_hasta'] : '<b>Hasta: </b>' . '';
                //$data['sucursal_text'] = ($post_array['hslcSucursaltext'] != '') ? '<b>Sucursal: </b>' . $post_array['hslcSucursaltext'] : '<b>Sucursal: </b>' .'Todas';
                //$data['tipo_factura_text'] = ($post_array['hslcTipoFacturatext'] != '') ? '<b>Tipo factura: </b>' . $post_array['hslcTipoFacturatext'] : '<b>Tipo factura: </b>' .'Todas';
     		}
            //Tipo de Reportes si sera Excel o Pdf
     		$tipo_reporte = $this->input->post('tipo_reporte');
     		$where = null;
     		$group = null;

     		if ($fecha_inicio != null) {
     			$where['fecha_inicio'] = formatear_fecha('Y-m-d', $fecha_inicio);                
     		}
     		if ($fecha_fin != null) {
     			$where['fecha_fin'] = formatear_fecha('Y-m-d', $fecha_fin);                
     		}
     		if ($vendedor != null) {
     			$where['ven_id']  = $vendedor;
                $data['por_vend'] = false; //No hay que filtrar por vendedor
                $group_by         = 'fac_id_cli';
            } else {
            	$where['ven_id']  = 'null';
                $data['por_vend'] = true; //Se filtrara por cada vendedor
                $group_by         = 'fac_id_ven, fac_id_cli';
            }
            //print_r($cliente); die();
            if (!(is_null($cliente))) {            
                if(is_string($cliente)){//si es string el dato se usa para el pdf o excel de lo contrario en la vista
                	$where['id_cliente'] = $cliente;
                }else{
                	$where['id_cliente'] = implode(',', $cliente);    
                }            
            }else{
            	$where['id_cliente'] = 'null';
            }       
            //$where['fac_estado']        = 0;

            $reporte = $this->facturacion_model->get_reporte_participacion_ventas_cliente($where, $group_by);
            //$saler = $this->gsatelite->get_tabla('ven_vendedor',"ven_estado <> 0");                
            //$data['id_vend']       = array_column($saler, 'ven_id');        
            $filename = 'rpt_reporte_participacion_ventas_cliente' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);          
            $data['filename']       = $filename;
            $data['reporte']        = $reporte;
            $data['tipo_reporte']   = $tipo_reporte;
            $data['total']          = array_sum(array_column($reporte, 'subtotal'));
            if (!(is_null($cliente))) {   
            	$data['cliente_text'] = '<b>Cliente: </b>'.implode(',',(array_column($reporte, 'nombre_cliente')));
            }else{
            	$data['cliente_text'] = '<b>Cliente: </b> Todos';
            }        

            $html = $this->load->view('facturacion/reportes/filtrar_participacion_ventas_cliente', $data, true);

            if ($flag) {                
            	echo $html;
            	die();
            } else {
            	if ($tipo_reporte == 'pdf') {

            		$data['titulo'] = 'porcentaje de participacion de ventas por cliente';

            		$header = $this->load->view('reporte/header', $data, true);

            		$GLOBALS['nombre_reporte'] = 'reporte_participacion_ventas_cliente_' . date('dmY');

            		$reporte = $header . $html;

            		$this->pdf->makePdf($reporte, 'L', 'reporte_participacion_ventas_cliente', 'Letter');
            	} elseif ($tipo_reporte == 'excel') {

            		$filename = 'rpt_reporte_participacion_ventas_cliente_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            		$data['titulo'] = 'reportaje de participacion de ventas por cliente';

            		$data['filename'] = $filename;

            		echo $html;
            	}
            }
        } else{
        	$select_cliente = $this->facturacion_model->get_nombre_cliente_personeria();        
        	$data["slcCliente"] = $select_cliente;        
            $data['vendedores'] = $this->gsatelite->get_tabla('ven_vendedor',"ven_estado <> 0");//Obtener los vendedores
            $data['titulo_personal'] = "Reporte porcentaje participación de ventas por cliente";
            //$this->_cargarvista($data);
            cargarvista($data);
        }
    }//Fin funcion reporte_ventas_sucursal_detallado


    /**
     * Descripción:
     * Función para reporte de ventas por vendedor agrupado pro tipo de pago
     * @since 2021-10
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    public function ventas_vendedor($flag = null){
    	satelite_validar();
    	if ($_POST) {
    		ini_set('max_execution_time', '9999');
    		$post_array = $this->input->post();
    		$fecha_ini = $post_array['fecha_ini'];
    		$fecha_fin = $post_array['fecha_fin'];
    		$vendedor = $post_array['vendedor'];
    		$tipo_rep = $post_array['tipo_reporte'];
    		$where['t.fac_estado > '] = 0;
    		$name_vend = "";
    		if ($fecha_ini != "") {
    			$where['DATE(t.fac_fecha_fact) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(t.fac_fecha_fact) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
    		}
    		if ($vendedor > 0) {
    			$where['t.fac_id_ven'] = $vendedor;
    			$tbl_ven = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id' => $vendedor));
    			$name_vend = $tbl_ven[0]['ven_codigo'] . ' - ' . $tbl_ven[0]['ven_nombre'] . ' ' . $tbl_ven[0]['ven_apellidos'];
    		}
    		$reporte = $this->facturacion_model->get_ventas_por_vend_tpg($where);
    		$data['filename'] = 'ventas_vendedor_' . date('dmY_His');
    		$data['registros'] = $reporte;
    		$data['fecha_ini'] = $fecha_ini;
    		$data['fecha_fin'] = $fecha_fin;
    		$data['vend_nomb'] = $name_vend;
    		$data['tipo_reporte'] = $tipo_rep;
    		$data['tipo_pago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_estado' => 1));
    		$html = $this->load->view('facturacion/reportes/filtrar_ventas_x_vendedor', $data, true);
    		if ($flag) {
    			echo json_encode(array('html' => $html, 'filas' => count($reporte)));
    		} else {
    			if ($tipo_rep == 'pdf') {
    				$data['titulo'] = 'Ventas por Vendedor';
    				$header = $this->load->view('reporte/header', $data, true);
    				$GLOBALS['nombre_reporte'] = 'ventas_vendedor_' . date('dmY_His');
    				$reporte = $header . $html;
    				$this->pdf->makePdf($reporte, 'P', 'reporte_participacion_ventas_cliente', 'Letter');
    			} else {
    				echo $html;
    			}
    		}
    	} else {
    		$vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
    		$data['vendedores'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $vendedores);
    		$data['titulo_personal'] = "Ventas por vendedor";
            cargarvista($data);
    	}
    }

    /**
     * Descripción:
     * Reporte con el detalle de productos por nota de remision por cliente
     * @since 2022-06
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    public function detalle_notas_remision($flag = null){
    	satelite_validar();
    	$tif_nr = $this->gsatelite->get_parametro('SYS_TIPO_FACTURAS', null, null, array('NOTA REMISION'));
    	if ($_POST) {
    		$fecha_ini = $this->input->post('fecha_ini');
    		$fecha_fin = $this->input->post('fecha_fin');
    		$clientes = $this->input->post('cliente_id');
    		$tipo_ver = $this->input->post('ver_version');
    		$facturas = $this->input->post('cli_facturas');
    		$tipo_rep = $this->input->post('tipo_reporte');
    		$where = array('fac_estado > ' => 0, 'fac_id_tif' => $tif_nr);
    		if ($fecha_ini != "") {
    			$where['DATE(fac_fecha_fact) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(fac_fecha_fact) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
    		}
    		if ($clientes > 0) {
    			$where['fac_id_cli'] = $clientes;
    		}
    		if ($facturas != "") {
    			$where["fxr_id_fac IN ($facturas)"] = null;
    		}
    		$group = ($tipo_ver > 0) ? "def_id_art, def_id_cva, fxr_id_fac, fac_id" : "def_id_art, def_id_cva, fxr_id_fac";
    		$reporte = $this->facturacion_model->get_detalles_nota_rem($where, $group);
    		$data['filename'] = 'notas_remision_' . date('dmY_His');
    		$data['versions'] = $tipo_ver;
    		$data['tipo_rep'] = $tipo_rep;
    		$data['registros'] = $reporte;
    		$data['fecha_ini'] = $fecha_ini;
    		$data['fecha_fin'] = $fecha_fin;
    		$html = $this->load->view('facturacion/reportes/filtrar_detalles_notas_rem', $data, true);
    		if ($flag) {
    			echo json_encode(array('html' => $html, 'filas' => count($reporte)));
    		} else {
    			if ($tipo_rep == 'pdf') {
    				$data['titulo'] = 'Detalles por Notas de Remisión';
    				$header = $this->load->view('reporte/header', $data, true);
    				$GLOBALS['nombre_reporte'] = 'rpte_nota_rem_factd_' . date('dmY_His');
    				$reporte = $header . $html;
    				$this->pdf->makePdf($reporte, 'P', 'rpte_nota_rem_factd', 'Letter');
    			} else {
    				echo $html;
    			}
    		}
    	} else {
    		if (!($tif_nr > 0)) {
    			$this->gsatelite->show_dialog('No existe el tipo Nota de Remisión en Parámetro.', 'facturacion/index', 'error', 'Error de Parámetros');
    		}
    		$data['titulo_personal'] = "Notas de Remision Facturadas";
    		$data['permisos'] = $this->gsatelite->get_permisos_opcion();
            cargarvista($data);
    	}
    }

	/**
     * Descripción:
     * Función para mostrar los reportes de facturas y entregas de inventarios
     * @author Max Molina - Grupo satélite
     * @since  2021-10-27
     */

	public function reportes_facturas_entregas_inventarios(){
		satelite_validar();
		if ($_POST) {
			// var_dump($_POST);die();
			// $tipo_f = $this->input->post('tipo_fac');
            $cliente = $this->input->post('slc_cliente');
            $no_fact = $this->input->post('slc_factura');
			$txt_fecha_inicio = $this->input->post('txt_fecha_inicio');
            $txt_fecha_fin = $this->input->post('txt_fecha_fin');

			$where_date = "DATE(FAC.fac_fecha_fact) BETWEEN '".formatear_fecha('Y-m-d', $txt_fecha_inicio)."' AND '".formatear_fecha('Y-m-d', $txt_fecha_fin)."'";
			
            $datos = $this->facturacion_model->lista_facturasXclientes($cliente, $no_fact, $where_date);
            // var_dump($this->db->last_query());die();
            // die(print_r(var_dump($datos),true));
            $fila = 1;
			$var = "";
            if (count($datos)) {
				foreach ($datos as $data) {
					$var .= '<tr>
								<td>' . $fila++. '</td>
                                <td>'.$data['cli_nombre']." ".$data['cli_apellido'].'</td>
								<td>'.$data['fac_numero']." - ".$data['tif_nombre'].'</td>
								<td>'.formatear_fecha('Y-m-d', $data['fac_fecha_fact']).'</td>
    							<td>' . $data['nom'] . '</td>
								<td>' . number_format($data['cvafax'], 4)." - ".$data['nombre'] . '</td>
    							<td>' . $data['documento'] . '</td>
    							<td>' . $data['fecha_fac'] . '</td>
    							<td>' . number_format($data['cvadesp'], 4) . '</td>
                            </tr>';
				}
				$arr = array(
                    "drop" => $var,
                );
			}else{
				$arr = array('tipo_alerta' => 'error', 'titulo_alerta' => "Anulación de facturas", 'texto_alerta' => "La factura que usted ha solicitado no existe");
			}

			// var_dump($arr);die();
			echo json_encode($arr);
			unset($arr);
		} else {
			$result = $this->facturacion_model->clientes_facturas_enttregas_inventario();
			// var_dump($result);die();
			
			$clientes = '';
			foreach ($result as $key => $cli) {
                if ($cli['cli_codigo'] != '') {
                    $codigo = $cli['cli_codigo'] . ' - ';
                } else {
                    $codigo = '';
                }
                if ($cli['cli_personeria'] != 2) {
                    $clientes .= '<option value="' . $cli['cli_id'] . '">' . $codigo . trim($cli['cli_nombre'] . ' ' . $cli['cli_apellido']) . '</option>';
                } else {
                    $clientes .= '<option value="' . $cli['cli_id'] . '">' . $codigo . $cli['cli_apellido'] . '</option>';
                }
            }
			$data['filename'] = 'reportes_facturas_entregas_inventarios';
			$data['cliente'] = $clientes;
			
			cargarvista($data);
		}
		
	}

	public function facturas_padre_cli() {
		$select = '<option></option>';
		$cliente = $this->input->post('cliente');
		$tif_nr = $this->gsatelite->get_parametro('SYS_TIPO_FACTURAS', null, null, array('NOTA REMISION'));
		$where = array('fac_estado > ' => 0, 'cof_estado > ' => 0, 'sef_estado > ' => 0, 'fac_id_tif != ' => $tif_nr, 'fac_id_cli' => $cliente);
		$facturas_cliente = $this->facturacion_model->facturas_padres_remision($where);
		foreach ($facturas_cliente as $k => $var) {
			$select .= '<option value="' . $var['fac_id'] . '">'  .$var['factura'] . '</option>';
		}
		echo $select;
	}

	/**
     * Descripción:
     * Función para imprimir los reportes de facturas y entregas de inventarios
     * @author Max Molina - Grupo satélite
     * @since  2021-11-03
     */

	public function imprimir_facturas_entregas_inventarios(){
		satelite_validar();
		if ($_POST) {
			// var_dump($_POST);die();
			// $tipo_f = $this->input->post('tipo_fac');
            $cliente = $this->input->post('cliente');
            $no_fact = $this->input->post('factura');
			$txt_fecha_inicio = $this->input->post('fecha_desde');
            $txt_fecha_fin = $this->input->post('fecha_fin');
			$reporte = $this->input->post('tipo_reporte');

			$where_date = "DATE(FAC.fac_fecha_fact) BETWEEN '".formatear_fecha('Y-m-d', $txt_fecha_inicio)."' AND '".formatear_fecha('Y-m-d', $txt_fecha_fin)."'";
			
            $datos = $this->facturacion_model->lista_facturasXclientes($cliente, $no_fact, $where_date);
            // var_dump($this->db->last_query());die();
			// var_dump($datos);die();

			$data['reporte'] = $reporte;
        	$data['txt_fecha_inicio'] = formatear_fecha('Y/m/d', $txt_fecha_inicio);
			$data['txt_fecha_fin'] = formatear_fecha('Y/m/d', $txt_fecha_fin);
        	$data['filename'] = 'rpt_facturas_entregas_inventario' . '_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 5);
        	$data['registros'] = $datos;
			// var_dump($data);die();
        	$html = $this->load->view('facturacion/reportes/detalle_facturas_entregas_inventario', $data, true);

			if ($reporte == 'pdf') {
				ini_set('memory_limit', '512M' );
				ini_set('max_execution_time', '9999');
				$header = $this->load->view('reporte/header',  array('titulo' => ' de Facturas y Entregas de Inventarios'), true);
				$header = $this->load->view('reporte/header',  array('subtitulo' => 'Periodo: '.formatear_fecha('Y/m/d', $txt_fecha_inicio)." - ".formatear_fecha('Y/m/d', $txt_fecha_fin) ), true);
				$documento = $header . $html;
				$this->pdf->makePdf($documento, 'L');
			} else {
				echo $html;
			}
		}
	}

	public function rpt_compr_reten($flag = null){
		satelite_validar();
		if ($_POST) {
			$fecha_ini = $this->input->post('fecha_ini');
    		$fecha_fin = $this->input->post('fecha_fin');
    		$clientes = $this->input->post('cliente_id');
    		$tipo_rep = $this->input->post('tipo_reporte');
    		$where = array('fac_estado > ' => 0, 'fac_monto_pendiente > ' => 0, 'fac_monto_pendiente <= fac_total_retencion' => null);
    		if ($fecha_ini != "") {
    			$where['DATE(fac_fecha_fact) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(fac_fecha_fact) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
    		}
    		if ($clientes > 0) {
    			$where['fac_id_cli'] = $clientes;
    		}
    		$reporte = $this->facturacion_model->get_fact_con_retenc($where);
			$data['filename'] = 'comprobante_retencion_pdte_' . date('dmY_His');
    		$data['tipo_rep'] = $tipo_rep;
    		$data['registros'] = $reporte;
    		$data['fecha_ini'] = $fecha_ini;
    		$data['fecha_fin'] = $fecha_fin;
    		$html = $this->load->view('facturacion/reportes/filtrar_comp_ret_pdtes', $data, true);
    		if ($flag) {
    			echo json_encode(array('html' => $html, 'filas' => count($reporte)));
    		} else {
    			if ($tipo_rep == 'pdf') {
    				$data['titulo'] = 'comprobantes de retención pendientes';
    				$header = $this->load->view('reporte/header', $data, true);
    				$GLOBALS['nombre_reporte'] = 'comprobante_retencion_pdte_' . date('dmY_His');
    				$reporte = $header . $html;
    				$this->pdf->makePdf($reporte, 'P', 'rpte_comp_ret_pdte', 'Letter');
    			} else {
    				echo $html;
    			}
    		}    		
		} else {
			$data['titulo_personal'] = "Comprobantes de Retencion Pendientes";
			$data['permisos'] = $this->gsatelite->get_permisos_opcion();
			cargarvista($data);
		}
	}

	public function notas_no_facturadas($flag = null){
		satelite_validar();
		$tif_nr = $this->gsatelite->get_parametro('SYS_TIPO_FACTURAS', null, null, array('NOTA REMISION'));
		if ($_POST) {
			$fecha_ini = $this->input->post('fecha_ini');
    		$fecha_fin = $this->input->post('fecha_fin');
    		$clientes = $this->input->post('cliente_id');
    		$tipo_rep = $this->input->post('tipo_reporte');
    		$where = array('fac_estado > ' => 0, 'fac_id_tif' => $tif_nr, 'fxr_id IS NULL' => null);
    		if ($fecha_ini != "") {
    			$where['DATE(fac_fecha_fact) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(fac_fecha_fact) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
    		}
    		if ($clientes > 0) {
    			$where['fac_id_cli'] = $clientes;
    		}
    		$reporte = $this->facturacion_model->get_notaS_sin_facturar($where);
			$data['filename'] = 'notas_rem_no_fact_' . date('dmY_His');
    		$data['tipo_rep'] = $tipo_rep;
    		$data['registros'] = $reporte;
    		$data['fecha_ini'] = $fecha_ini;
    		$data['fecha_fin'] = $fecha_fin;
    		$html = $this->load->view('facturacion/reportes/filtrar_notas_rem_no_fact', $data, true);
    		if ($flag) {
    			echo json_encode(array('html' => $html, 'filas' => count($reporte)));
    		} else {
    			if ($tipo_rep == 'pdf') {
    				$data['titulo'] = 'Notas de Remisión no facturadas';
    				$header = $this->load->view('reporte/header', $data, true);
    				$GLOBALS['nombre_reporte'] = 'rpte_nota_rem_no_factd_' . date('dmY_His');
    				$reporte = $header . $html;
    				$this->pdf->makePdf($reporte, 'P', 'rpte_nota_rem_no_factd', 'Letter');
    			} else {
    				echo $html;
    			}
    		}
		} else {
			if (!($tif_nr > 0)) {
				$this->gsatelite->show_dialog('No existe el tipo Nota de Remisión en Parámetro.', 'facturacion/index', 'error', 'Error de Parámetros');
			}
			$data['titulo_personal'] = "Notas de Remision No Facturadas";
			$data['permisos'] = $this->gsatelite->get_permisos_opcion();
			cargarvista($data);
		}
		
	}

	/**
     * Descripción:
     * Función para obtener a los clientes 
     * @author Max Molina - Grupo satélite
     * @since  2021-10-27
     */
	public function facturas_enttregas_inventario(){
		if ($_POST) {
			//var_dump($_POST);die();
			$arreglo = array();
        	$cliente = ($this->input->post('cliente') != '') ? $this->input->post('cliente') : null;
        	$factura  = (trim($this->input->post('factura')) != '') ? trim($this->input->post('factura')) : null;
        	$fxr_factura_remision = $this->gsatelite->get_tabla('fxr_factura_remisionxfactura');
        	$remision_ids = implode(",", array_column($fxr_factura_remision,"fxr_id_fac_remision"));
        	$like = null;
        	$where = array(
        	    'fac_estado > 0' => null,
        	    'fac_id_origen_devolucion IS NULL' => null,
        	    'tif_aplica_anulacion'=> 1
        	);
        	if ($cliente) {
        	    $where["fac_id_cli"] = $cliente;
        	}
        	if($remision_ids != ''){
        	    $where["fac_id NOT IN ($remision_ids)"] = null;
        	}
        	if ($factura != '') {
        	    $like = "(tif_nombre LIKE '%" . $factura . "%' OR fac_numero LIKE '%" . $factura . "%')";
        	}
        	$select_query = "fac_id, fac_numero, fac_nombre_factura, tif_nombre, fac_fecha_fact";
        	$productos = $this->facturacion_model->get_facturas_like($where, $like, $select_query);
        	if (count($productos) > 0) {
        	    $arreglo = $productos;
        	}
        	echo json_encode($arreglo);
		}
	}

	/**
	 * * Descripción: Reporte de cuotas de la CMC
	 * **/
	public function reporte_ventas_cuotas() {
		satelite_validar();
		if($_POST){
			$post_array = $this->input->post();
			$fecha_inicio = ($post_array['fecha_inicio'] != '' )? $post_array['fecha_inicio'] : null;
			$fecha_fin 	= ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
			$categoria 	= ($post_array['categoria'] != '') ? $post_array['categoria'] : null;
			$state_pago = ($post_array['estado'] != '') ? $post_array['estado'] : null;
			$curso 		= ($post_array['curso'] != '') ? $post_array['curso'] : null;
    		$meses_letras = array(1=>'Enero', 2=>'Febrero', 3=>'Marzo', 4=>'Abril', 5=>'Mayo', 6=>'Junio', 7=>'Julio', 8=>'Agosto', 9=>'Septiembre', 10=>'Octubre',  11=>'Noviembre', 12=>'Diciembre');
			$fecha_inicio = formatear_fecha('Y-m-d', $fecha_inicio);
			$fecha_fin = formatear_fecha('Y-m-d', $fecha_fin);
    		$where = array();
    		if ($fecha_inicio != "") {
    			$where['DATE(cmc_fecha) >= '] = $fecha_inicio;
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(cmc_fecha) <= '] = $fecha_fin;
    		}
    		if ($categoria) {
    			$where['tia_id'] = $categoria;
    		}
    		if ($curso) {
    			$where['art_id'] = $curso;
    		}
    		if ($state_pago > 0) {
    			switch ($state_pago) {
    				case 1:
    					// Pagado y Facturado
    					$where['cmc_estado'] = 1;
    					$where['cmc_id_fac > '] = 0;
    					$where['cmc_estado_cargo'] = 2;
    					break;
    				case 2:
    					// Pagado pendiente de facturar
    					$where['cmc_estado'] = 1;
    					$where['cmc_estado_cargo'] = 2;
    					$where['cmc_id_fac IS NULL'] = null;
    					break;
    				case 4:
    					// Anulado
    					$where['cmc_estado'] = 0;
    					$where['cmc_estado_cargo'] = 0;
    					$where['cmc_observacion IS NULL'] = null;
    					break;
    				default:
    					// Pendiente de pago
    					$where['cmc_estado'] = 1;
    					$where['cmc_estado_cargo'] = 1;
    					break;
    			}
    		}
    		$data['ventas_cuotas'] = $this->facturacion_model->get_reporte_ventas_cuotas($where);
    		$data["tipo_reporte"]  = $post_array['tipo_reporte'];
    		$html = $this->load->view('facturacion/reportes/consultar_reporte_ventas_cuotas', $data, true);
    		echo json_encode(array('html' => $html));
		} else {
			$data['titulo_personal'] = "Reporte de ventas por cuotas";
			cargarvista($data);
		}		
	}

	function imprimir_reporte_ventas_cuotas(){
		satelite_validar();
		$post_array 	= $this->input->post();
		$fecha_inicio 	= ($post_array['txtFechaIni'] != '' )? $post_array['txtFechaIni'] : null;
    	$fecha_fin 		= ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
    	$categoria 		= ($post_array['slcCategoriaProducto'] != '') ? $post_array['slcCategoriaProducto'] : null;
    	$curso 			= ($post_array['slcCurso'] != '') ? $post_array['slcCurso'] : null;
    	$state_pago 	= ($post_array['slcState'] != '') ? $post_array['slcState'] : null;
    	$tipo_reporte 	= $post_array['tipo_reporte'];
    	$fecha_inicio 	= formatear_fecha('Y-m-d', $fecha_inicio);
    	$fecha_fin  	= formatear_fecha('Y-m-d', $fecha_fin);
    	$where = array();
    	if ($fecha_inicio != "") {
    		$where['DATE(cmc_fecha) >= '] = $fecha_inicio;
    	}
    	if ($fecha_fin != "") {
    		$where['DATE(cmc_fecha) <= '] = $fecha_fin;
    	}
    	if ($categoria) {
    		$where['tia_id'] = $categoria;
    	}
    	if ($curso) {
    		$where['art_id'] = $curso;
    	}
    	if ($state_pago > 0) {
    		switch ($state_pago) {
    			case 1:
    				// Pagado y Facturado
	    			$where['cmc_estado'] = 1;
	    			$where['cmc_id_fac > '] = 0;
	    			$where['cmc_estado_cargo'] = 2;
    				break;
    			case 2:
    				// Pagado pendiente de facturar
	    			$where['cmc_estado'] = 1;
	    			$where['cmc_estado_cargo'] = 2;
	    			$where['cmc_id_fac IS NULL'] = null;
	    			break;
    			case 4:
    				// Anulado
	    			$where['cmc_estado'] = 0;
	    			$where['cmc_estado_cargo'] = 0;
	    			$where['cmc_observacion IS NULL'] = null;
	    			break;
    			default:
    				// Pendiente de pago
	    			$where['cmc_estado'] = 1;
	    			$where['cmc_estado_cargo'] = 1;
	    			break;
    		}
    	}
    	$data['ventas_cuotas']      = $this->facturacion_model->get_reporte_ventas_cuotas($where);
    	$filename = 'reporte_ventas_cuotas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	$periodo = ($fecha_inicio != "") ? "Desde: " . formatear_fecha('d-m-Y', $fecha_inicio) :"";
    	$periodo .= ($fecha_fin != "") ? " Hasta: " . formatear_fecha('d-m-Y', $fecha_fin) :"";
    	$data['periodo'] = $periodo;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;
    	// var_dump($data);die();
    	if($tipo_reporte == 'excel'){
    		$this->load->view('facturacion/reportes/consultar_reporte_ventas_cuotas', $data);
    	} else{
    		$header = $this->load->view('reporte/header', array('titulo'=>'ventas por cuotas', 'subtitulo'=>$periodo), true);
			$html = $this->load->view('facturacion/reportes/consultar_reporte_ventas_cuotas', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'L', 'Reporte_ventas_cuotas_', 'Letter');
    	}
    }

	public function select_cursos_categoria () {
        satelite_validar(true);
        $id_categoria = $this->input->post('categoria');

        $query = "SELECT MODU.mod_id_art, MODU.mod_nombre FROM mod_modulo MODU
			INNER JOIN art_articulo ART ON ART.art_id = MODU.mod_id_art
			INNER JOIN tia_tipo_articulo TIA ON TIA.tia_id = ART.art_id_tia
            WHERE TIA.tia_id = ".$id_categoria."";

        $resultado = $this->db->query($query)->result_array();

        $cursos = '<option value=""></option>';

        if(!empty($resultado)) {

            foreach ($resultado as $key => $value) {
            
                $cursos .= '<option value="' . $value['mod_id_art']. '">' . $value['mod_nombre'] . '</option>';

            }

        }

        echo json_encode($cursos);
    }

    public function totales_facturacion($flag = null) {
		satelite_validar();
		if($_POST){
			// var_dump($_POST);die();
			$tipo_filtro  = $_POST['tipo_filtro'];
			$fecha_inicio = formatear_fecha('Y-m-d', $_POST['fecha_inicio']);
			$fecha_fin 	  = formatear_fecha('Y-m-d', $_POST['fecha_final']);
    		$where = array("fac_estado > " => 0);
    		switch ($tipo_filtro) {
    			case 'fac_fecha_cont':
    				if ($fecha_inicio != "") {
	    				$where['DATE(fac_fecha_cont) >= '] = $fecha_inicio;
	    			}
	    			if ($fecha_fin != "") {
	    				$where['DATE(fac_fecha_cont) <= '] = $fecha_fin;
	    			}
    			break;    			
    			default:
	    			if ($fecha_inicio != "") {
	    				$where['DATE(fac_fecha_fact) >= '] = $fecha_inicio;
	    			}
	    			if ($fecha_fin != "") {
	    				$where['DATE(fac_fecha_fact) <= '] = $fecha_fin;
	    			}
    			break;
    		}
    		$registros = $this->facturacion_model->consolid_facXdia($where, "DATE(fac_fecha_fact), DATE(fac_fecha_cont)");
			$data['registros'] = $registros;
			$data["tipo_reporte"] = $_POST['tipo_reporte'];
			$html = $this->load->view('facturacion/reportes/consolidar_factura_dia', $data, true);
			if ($flag) {
				echo json_encode(array('html' => $html, 'filas' => count($registros)));
			} else {
				if ($_POST['tipo_reporte'] == "pdf") {
					$header = $this->load->view('reporte/header', array('titulo'=>'Facturación Consolidado'), true);
					$GLOBALS['nombre_reporte']  = 'consollidado_facturas' . date('dmY');
					$reporte = $header . $html;
					$this->pdf->makePdf($reporte, 'P', 'consollidado_facturas', 'Letter');
				} else {
					echo $html;
				}
			}			
		} else {
			$data['titulo_personal'] = "Totales Facturas";
			cargarvista($data);
		}
	}

	public function transmision_documentos() {
		satelite_validar();
		if($_POST){
			$post_array = $this->input->post();
			$tipo_filtro = $post_array['tipo_filtro'];
			$fecha_inicio = ($post_array['fecha_inicio'] != '' )? $post_array['fecha_inicio'] : null;
			$fecha_fin 	= ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
			$fecha_inicio = formatear_fecha('Y-m-d', $fecha_inicio);
			$fecha_fin = formatear_fecha('Y-m-d', $fecha_fin);
    		$where = array("fac_tipo_facturacion" => 1);
    		switch ($tipo_filtro) {
    			case 'fac_fecha_cont':
    				if ($fecha_inicio != "") {
	    				$where['DATE(fac_fecha_cont) >= '] = $fecha_inicio;
	    			}
	    			if ($fecha_fin != "") {
	    				$where['DATE(fac_fecha_cont) <= '] = $fecha_fin;
	    			}
    			break;
    			
    			default:
	    			if ($fecha_inicio != "") {
	    				$where['DATE(fac_fecha_fact) >= '] = $fecha_inicio;
	    			}
	    			if ($fecha_fin != "") {
	    				$where['DATE(fac_fecha_fact) <= '] = $fecha_fin;
	    			}
    			break;
    		}
    		$data['facturas_generadas_no_transmitidas'] = $facturas_generadas_no_transmitidas = $this->facturacion_model->get_total_facturas_generadas_no_transmitidas($where);
			$data['facturas_validadas'] = $facturas_validadas = $this->facturacion_model->get_total_facturas_validadas($where);
			$data['facturas_transmitidas_no_procesadas'] = $facturas_transmitidas_no_procesadas = $this->facturacion_model->get_total_facturas_transmitidas_no_procesadas($where);
			$data['facturas_enviadas_por_correo'] = $facturas_enviadas_por_correo = $this->facturacion_model->get_total_facturas_enviadas_por_correo($where);
			$data['facturas_no_enviadas_por_correo'] = $facturas_no_enviadas_por_correo = $this->facturacion_model->get_total_facturas_no_enviadas_por_correo($where);	
			$total_estado_facturas = $facturas_generadas_no_transmitidas[0]['total'] + $facturas_validadas[0]['total'] + $facturas_transmitidas_no_procesadas[0]['total'] + $facturas_enviadas_por_correo[0]['total'] + $facturas_no_enviadas_por_correo[0]['total'];
			$data['total_estado_facturas'] = $total_estado_facturas;
    		$tipo_reporte               = $post_array['tipo_reporte'];
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$html = $this->load->view('facturacion/reportes/consultar_transmision_documentos', $data, true);
    		if ($tipo_reporte == '') {
    			echo json_encode(array('html' => $html));
    		}
		} else {
			$data['titulo_personal'] = "Reporte de transmision de documentos";
			cargarvista($data);
		}
	}

	public function imprimir_transmision_documentos() {
		satelite_validar();
		$post_array 	= $this->input->post();
		$tipo_filtro 	= $post_array['tipo_filtro'];
		$fecha_inicio 	= ($post_array['txtFechaIni'] != '' )? $post_array['txtFechaIni'] : null;
    	$fecha_fin 		= ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
    	$tipo_reporte 	= $post_array['tipo_reporte'];
    	$fecha_inicio 	= formatear_fecha('Y-m-d', $fecha_inicio);
    	$fecha_fin  	= formatear_fecha('Y-m-d', $fecha_fin);
		$where = array();
		switch ($tipo_filtro) {
			case 'fac_fecha_cont':
				if ($fecha_inicio != "") {
					$where['DATE(fac_fecha_cont) >= '] = $fecha_inicio;
				}
				if ($fecha_fin != "") {
					$where['DATE(fac_fecha_cont) <= '] = $fecha_fin;
				}
			break;

			default:
				if ($fecha_inicio != "") {
					$where['DATE(fac_fecha_fact) >= '] = $fecha_inicio;
				}
				if ($fecha_fin != "") {
					$where['DATE(fac_fecha_fact) <= '] = $fecha_fin;
				}
			break;
		}
		$data['facturas_generadas_no_transmitidas'] = $facturas_generadas_no_transmitidas = $this->facturacion_model->get_total_facturas_generadas_no_transmitidas($where);
		$data['facturas_validadas'] = $facturas_validadas = $this->facturacion_model->get_total_facturas_validadas($where);
		$data['facturas_transmitidas_no_procesadas'] = $facturas_transmitidas_no_procesadas = $this->facturacion_model->get_total_facturas_transmitidas_no_procesadas($where);
		$data['facturas_enviadas_por_correo'] = $facturas_enviadas_por_correo = $this->facturacion_model->get_total_facturas_enviadas_por_correo($where);
		$data['facturas_no_enviadas_por_correo'] = $facturas_no_enviadas_por_correo = $this->facturacion_model->get_total_facturas_no_enviadas_por_correo($where);		
		$total_estado_facturas = $facturas_generadas_no_transmitidas[0]['total'] + $facturas_validadas[0]['total'] + $facturas_transmitidas_no_procesadas[0]['total'] + $facturas_enviadas_por_correo[0]['total'] + $facturas_no_enviadas_por_correo[0]['total'];		
		$data['total_estado_facturas'] = $total_estado_facturas;
    	$filename                   = 'reporte_transmision_documentos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	$periodo = ($fecha_inicio != "") ? "Desde: " . formatear_fecha('d-m-Y', $fecha_inicio) :"";
    	$periodo .= ($fecha_fin != "") ? " Hasta: " . formatear_fecha('d-m-Y', $fecha_fin) :"";
    	$data['periodo'] = $periodo;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;
		if($tipo_reporte == 'excel'){
    		$this->load->view('facturacion/reportes/consultar_transmision_documentos', $data);
    	} else{
			$data['titulo']		= 'transmision resumido';
    		$data['subtitulo'] 	= $periodo;
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('facturacion/reportes/consultar_transmision_documentos', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'P', 'Reporte_transmision_documentos_', 'Letter');
    	}
	}

	public function libro_venta_consumidor_final(){
		satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        $this->load->model('contabilidad_model');
        $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        $data['id_tif_exportacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL', null, null, array('ID_TIF_EXPORTACION'));
        if ($data['id_tif_exportacion'] == "" || $data['id_tif_exportacion'] == null) {
        	$alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Reporte libro de ventas", 'texto_alerta' => "Parametro requerido");
        	$this->session->set_flashdata($alerta);
        	redirect('/facturacion/index');
        	die();
        }
        $data['esf_elect']          = $tipo_fact_elect;
        $select                     = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
        $data["slcTipoFactura"]     = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $select                     = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', null, '', 'suc_id', true);
        $data["slcSucursal"]        = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $data['titulo_personal']    = "Reporte libro de ventas consumidor final";
        $this->_cargarvista($data);
    }

    public function libro_venta_contribuyente(){
        satelite_validar();
        ini_set('memory_limit', '4048M');
        ini_set('max_execution_time', '9999');
        $this->load->model('contabilidad_model');
        $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        $data['id_tif_exportacion'] = $this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_LIBRO_VENTA_CONSUMIDOR_FINAL', null, null, array('ID_TIF_EXPORTACION'));
        if ($data['id_tif_exportacion'] == "" || $data['id_tif_exportacion'] == null) {
        	$alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Libro de iva al contribuyente", 'texto_alerta' => "Parametro requerido");
        	$this->session->set_flashdata($alerta);
        	redirect('/facturacion/index');
        	die();
        }
        $data['esf_elect']          = $tipo_fact_elect;
        $select = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1, 'tif_aplica_venta' => 1), null, '', 'tif_id', true);
        $data["slcTipoFactura"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', '', null, '', 'suc_id', true);
        $data["slcSucursal"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        $data['titulo_personal'] = "Reporte de ventas a contribuyentes";
        $this->_cargarvista($data);
    }


	/**
	 * Descripcion: NOTAS DE REMISION NO FACTURADAS
	 * @author: Daniel Perez
	**/
	/* EN DESUSO
	public function notasrem_nofact(){
		$params = new stdClass();
		$params->fecha_desde = $this->input->post('txtFecha_desde');
		$params->fecha_hasta = $this->input->post('txtFecha_hasta');
		$params->tipoFactura = $tif_nr;
		$data['sucursales_option'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre} - {suc_codigo}', 'sucursales', null, null, null, null, true);
		$data['facturas_tipo'] = $this->gsatelite->get_dropdown('tif_tipo_factura','{tif_nombre} - {tif_abreviacion}','tipos',array('tif_estado' => 1),null,null,null,true);
		$data['tif_ndr'] = $tif_nr;
		switch ($case) {
			case '2':
				// EXPORTAR PDF
					$params = json_decode(file_get_contents('php://input'));
					$params->fecha_desde = '"'.date_format(date_create($params->fecha_desde),'Y-m-d').' 00:00:00"';
					$params->fecha_hasta = '"'.date_format(date_create($params->fecha_hasta),'Y-m-d').' 23:59:59"';
					$datos = $this->facturacion_model->notasrem_nofact($params);
					$data['registros']        = $datos;
					$html = $this->load->view('facturacion/reportes/notasrem_nofact',  $data, true);
	            	$this->load->library('pdf');
	            	$html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
	            	$this->pdf->makePDF($html_header.$html,'lanscape', 'Facturas_anuladas','Legal');
	            	die();
			break;
			// EXPORTAR EXCEL
			case '3':
					$params = json_decode(file_get_contents('php://input'));
					$params->fecha_desde = '"' . date_format(date_create($params->fecha_desde),'Y-m-d').' 00:00:00"';
					$params->fecha_hasta = '"' . date_format(date_create($params->fecha_hasta),'Y-m-d').' 23:59:59"';
					$datos = $this->facturacion_model->notasrem_nofact($params);
					$this->load->view('facturacion/reportes/notasrem_nofact',  $data);
			break;
		}
	}
	*/

}
?>
