<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimientos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('proceso_model');
        $this->load->model('gsatelite');
        $this->load->model('cotizaciones_model', 'cotModel');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function vendedores() {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                $query = $this->proceso_model->getusername();
                $urlx = explode('/', uri_string());
                $ven_id = end($urlx);
                if ($ven_id > 0) {
                    $usu_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id_usu', array('ven_id' => $ven_id));
                    if ($usu_id > 0 and strlen($query) > 0) {
                        $query .= ",{$usu_id}";
                    } else {
                        $query .= "{$usu_id}";
                    }
                }

                if (strlen($query) < 1) {
                    $query = "0";
                }


                $crud = new grocery_CRUD();
                //Columnas a mostrar en READ
                $columns = array(
                    'ven_codigo',
                    'ven_nombre',
                    'ven_apellidos',
                    'ven_meta_ventas',
                    'ven_email',
                    'ven_estado',
                );

                //Alias para las columnas
                $alias = array(
                    'ven_codigo' => 'Código',
                    'ven_nombre' => 'Nombre',
                    'ven_apellidos' => 'Apellidos',
                    'ven_meta_cotizado' => 'Meta Cotizado',
                    'ven_meta_ventas' => 'Meta de Ventas',
                    'ven_numero_visitas' => 'No. Visitas',
                    'ven_email' => 'E-mail',
                    'ven_estado' => 'Estado',
                    'ven_id_usu' => 'Usuario',
                    'ven_estado' => 'Estado',
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'ven_codigo',
                    'ven_id_usu',
                    'ven_nombre',
                    'ven_apellidos',
                    'Supervisor',
                    'ven_meta_ventas',
                    'ven_email',
                    'ven_fecha_mod',
                    'ven_usu_mod',
                    'ven_codigo',
                    'ven_estado',
                );

                $required_fields = array(
                    'ven_nombre',
                    'ven_id_usu',
                    'ven_apellidos',
                    'ven_codigo',
                    'Supervisor',
                    'ven_meta_ventas',
                    'ven_estado');
                $edit_columns = $add_columns;

                $crud->set_table('ven_vendedor')
                        ->set_subject('Vendedor')
                        ->where('ven_estado <>', -1)
                        ->unset_delete()
                        //->where('ven_estado', 1)
                        ->columns($columns)
                        ->display_as($alias)
                        ->add_fields($add_columns)
                        ->edit_fields($edit_columns)
                        ->required_fields($required_fields)
                        ->set_relation('ven_id_usu', 'users', 'username', "id in ( {$query} )")
                        ->set_rules('ven_email', 'Email', 'valid_email')
                        ->set_rules('ven_codigo', 'Código', 'trim|required|campo_unico[ven_vendedor.ven_codigo]')
                        ->set_relation_n_n('Supervisor', 'vxs_vendedorxsupervisor', 'sup_supervisor', 'vxs_id_ven', 'vxs_id_sup', 'sup_nombre')
                        ->field_type('ven_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('ven_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                $urlx = explode('/', uri_string());
                if(end($urlx) == 'add') {
                    $crud->field_type('ven_estado', 'hidden', 1);
                } else {
                    $crud->field_type('ven_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $output = $crud->render();

                $data['titulo_personal'] = "Vendedores";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function clientes() {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                //preguntar si el usuario es supervisor o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);

                $urlx = explode('/', uri_string());
                $cli_id = end($urlx);
                if ($cli_id > 0) {
                    $datosCliente = $this->cotModel->get_registro('cli_cliente', 'cli_id', $cli_id);
                    $id_vendedor = $datosCliente->cli_id_ven;
                } else {
                    $id_vendedor = "0";
                }

                $crud = new grocery_CRUD();
                //Columnas a mostrar en READ
                $columns = array(
                    'cliente',
                    'cli_nombre',
                    'cli_apellido',
                    'cli_apellido',
                    'cli_estado',
                    'cli_email',
                    'cli_razon_comercial',
                    'cli_observacion',
                    'cli_sitio_web',
                );

                //Alias para las columnas
                $alias = array(
                    'cli_nombre' => 'Nombre',
                    'cli_apellido' => 'Apellidos',
                    'cli_email' => 'E-mail',
                    'cli_estado' => 'Estado',
                    'cli_razon_comercial' => 'Razón Comercial',
                    'cli_personeria' => 'Personería',
                    'cli_observacion' => 'Observación',
                    'cli_sitio_web' => 'Sitio Web',
                    'cli_id_sec' => 'Sector',
                    'cli_id_cac' => 'Cartera',
                    'cli_id_ven' => 'Vendedor',
                    'cliente' => 'Cliente',
                    'cli_id_tmc' => 'Medio de contacto',
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'cli_personeria',
                    'cli_nombre',
                    'cli_apellido',
                    'cli_razon_comercial',
                    'cli_email',
                    'cli_observacion',
                    'cli_id_sec',
                    'cli_id_cac',
                    'cli_id_ven',
                    'cli_sitio_web',
                    'cli_id_tmc',
                    'cli_estado',
                    'cli_fecha_mod',
                    'cli_usu_mod',
                );

                $required_fields = array(
                    'cli_nombre',
                    'cli_apellido',
                    'cli_estado',
                    'cli_id_sec',
                    'cli_id_cac');


                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('cli_cliente')
                        ->set_subject('Cliente')
                        ->where('cli_estado <>', -1)
                        ->unset_delete()
                        ->columns($columns)
                        ->display_as($alias)
                        ->add_fields($add_columns)
                        ->edit_fields($edit_columns)
                        ->set_relation('cli_id_sec', 'sec_sector_cliente', 'sec_nombre')
                        ->set_relation('cli_id_cac', 'cac_cartera_cliente', 'cac_nombre')
                        ->set_relation('cli_id_tmc', 'tmc_tipo_medio', 'tmc_nombre')
                        ->field_type('cli_personeria', 'dropdown', array('1' => 'Jurídica', '0' => 'Natural'))
                        ->set_rules('cli_email', 'Email', 'valid_email')
                        ->required_fields($required_fields)
                        ->field_type('cli_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('cli_usu_mod', 'hidden', $this->tank_auth->get_user_id());

                $urlx = explode('/', uri_string());
                if(end($urlx) == 'add') {
                    $crud->field_type('cli_estado', 'hidden', 1);
                } else {
                    $crud->field_type('cli_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $crud->unset_columns('cli_nombre', 'cli_apellido');

                $crud->callback_column('cliente', function($value, $row) {
                    $str = $row->cli_nombre . ' ' . $row->cli_apellido;
                    return $str;
                });

                if ($esSup > 0) { //es supervisor
                    $queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
                    if ($id_vendedor != 0) {
                        if (!in_array($id_vendedor, (explode(',', $queryIdVen)))) {
                            $queryIdVen = "0";
                        }
                    }

                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', "ven_id in ( {$queryIdVen} )");
                } else if ($esVen > 0) { //es vendedor
                    $usu_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id_usu', array('ven_id' => $id_vendedor));
                    if ($id_vendedor != 0) {
                        if ($usu_id == $this->tank_auth->get_user_id()) {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                        } else {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                        }
                    } else {
                        $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    }
                } else {
                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                }



                $output = $crud->render();

                $data['titulo_personal'] = "Clientes";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento tipo factura
     * @Modificacion: condicion para otorgar permisos
     */
    function tipo_factura($value = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                //Condicion para otorgar permisos para que otro modulo/funcion la utilize
                if ($value != null) {
                    $permisos = $value;
                } else {
                    $permisos = $this->gsatelite->get_permisos_opcion('facturacion/mantenimientos/tipo_factura');
                }
                $crud->set_table('tif_tipo_factura')
                        ->set_subject('Tipos de factura')
                        ->columns('tif_nombre', 'tif_abreviacion', 'tif_estado')
                        ->fields('tif_nombre', 'tif_abreviacion', 'tif_estado', 'tif_usu_mod', 'tif_fecha_mod', 'tif_usu_crea', 'tif_fecha_crea','tif_aplica_compra','tif_aplica_venta')
                        ->display_as('tif_nombre', 'Nombre')
                        ->display_as('tif_abreviacion', 'Abreviación')
                        ->display_as('tif_estado', 'Estado')
                        ->display_as('tif_aplica_compra', 'Aplica compra')
                        ->display_as('tif_aplica_venta', 'Aplica venta')
                        ->display_as('tif_codigo_hacienda','Código Hacienda')
                        ->display_as('tif_aplica_nota_credito','Aplica Nota Crédito')
                        ->display_as('tif_aplica_nota_debito','Aplica Nota Débito')
                        ->display_as('tif_aplica_aplica_auditoria','Aplica Auditoría')
                        ->required_fields('tif_nombre', 'tif_abreviacion', 'tif_estado')
                        ->set_rules('tif_nombre', 'Nombre', 'trim|required|campo_unico[tif_tipo_factura.tif_nombre]')
                        ->field_type('tif_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tif_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tif_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('tif_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                //->unset_delete()

                        ->callback_field('tif_aplica_compra', function($value, $primary_key) {
                            $value = ($value != '') ? $value : 0;
                            $defecto = ($value)?'checked':'';
                            return '<input type="checkbox" id="tif_aplica_compra" '.$defecto.' class="nostyle"><input type="hidden" id="field-tif_aplica_compra" name="tif_aplica_compra" value="'.$value.'">';
                        })

                        ->callback_field('tif_aplica_venta', function($value, $primary_key) {
                            $value = ($value != '') ? $value : 0;
                            $defecto = ($value)?'checked':'';
                            return '<input type="checkbox" id="tif_aplica_venta" '.$defecto.' class="nostyle"><input type="hidden" id="field-tif_aplica_venta" name="tif_aplica_venta" value="'.$value.'">';
                        })
                ;
                $urlx = explode('/', uri_string());
                if(end($urlx) == 'add') {
                    $crud->field_type('tif_estado', 'hidden', 1);
                } else {
                    $crud->field_type('tif_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $data['titulo_personal'] = "Tipos de factura";

                //Validaciones permisos
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/tipo_factura/read');
                }

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento imp_impuesto
     */
    function impuestos() {
        satelite_validar();

        $crud = new grocery_CRUD();
        $crud->set_table('imp_impuesto')
                ->set_subject('Impuestos')
                ->columns('imp_nombre', 'imp_porcentaje', 'imp_valor', 'imp_estado')
                ->fields('imp_nombre', 'imp_porcentaje', 'imp_valor', 'imp_defecto', 'imp_estado', 'imp_usu_mod', 'imp_fecha_mod')
                ->display_as('imp_nombre', 'Nombre')
                ->display_as('imp_porcentaje', 'Porcentaje')
                ->display_as('imp_valor', 'Valor')
                ->display_as('imp_estado', 'Estado')
                ->display_as('imp_defecto', 'Aplicar por Defecto')
                ->required_fields('imp_nombre', 'imp_porcentaje', 'imp_valor', 'imp_estado', 'imp_defecto')
                ->set_rules('imp_nombre', 'Nombre', 'trim|required|campo_unico[imp_impuesto.imp_nombre]')
                ->field_type('imp_defecto', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                ->field_type('imp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('imp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
        ;
        $urlx = explode('/', uri_string());
        if(end($urlx) == 'add') {
            $crud->field_type('imp_estado', 'hidden', 1);
        } else {
            $crud->field_type('imp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Impuestos";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function series() {
        satelite_validar();

        $crud = new grocery_CRUD();
        $crud->set_table('sef_serie_factura')
                ->set_subject('Series')
                ->columns('sef_nombre', 'sef_abrev', 'sef_estado')
                ->fields('sef_id_tif', 'sef_nombre', 'sef_abrev', 'sef_estado', 'sef_usu_mod', 'sef_fecha_mod')
                ->display_as('sef_nombre', 'Nombre')
                ->display_as('sef_abrev', 'Abreviación  ')
                ->display_as('sef_estado', 'Estado')
                ->display_as('sef_id_tif', 'Tipo de factura')
                ->required_fields('sef_id_tif', 'sef_nombre', 'sef_abrev', 'sef_estado')
                ->set_relation('sef_id_tif', 'tif_tipo_factura', 'tif_nombre')
                ->set_rules('sef_nombre', 'Nombre', 'trim|required|campo_unico[sef_serie_factura.sef_nombre]')
                ->set_rules('sef_abrev', 'Abreviación', 'trim|required|campo_unico[sef_serie_factura.sef_nombre]')
                ->add_action('Gestionar', '', 'facturacion/mantenimientos/correlativos', 'icomoon-icon-cog-2  tbutton')
                //personal/catalogos/ing_des_pla','ui-icon-plus tbutton')      
                // ->field_type('imp_defecto','dropdown',array('1' => 'Sí', '0' => 'No'))
                ->field_type('sef_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('sef_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
        ;
        $urlx = explode('/', uri_string());
        if(end($urlx) == 'add') {
            $crud->field_type('sef_estado', 'hidden', 1);
        } else {
            $crud->field_type('sef_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Series";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function cargar_correlativo() {
        $id_serie = $this->input->post("serie_id");
        $correlativo = $this->gsatelite->get_dropdown('cof_correlativo_factura', '{cof_inicio} - {cof_fin}', '', array('cof_estado' => '1', 'cof_id_sef' => $id_serie), null, '', 'cof_id', true);
        $datos["series"] = str_replace('<option value="0">Seleccione</option>', '', $correlativo);
        echo $datos['series'];
    }

    function correlativos($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $data['title'] = "Rango";
            $data['titulo_personal'] = "Correlativos";
            $data['correlativo_tabla'] = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_id_sef' => $id, 'cof_estado' => 1));


            if ($_POST) {
                if ($_POST['boton'] == 'ingreso') {
                    //print_r($_POST); exit();
                    $info_tabla = array(
                        'cof_id_sef' => $id,
                        'cof_inicio' => (int) $_POST['inicioCorrelativo'],
                        'cof_fin' => (int) $_POST['finCorrelativo'],
                        'cof_estado' => 1,
                        'cof_usu_mod' => $this->tank_auth->get_user_id(),
                        'cof_fecha_mod' => date('Y-m-d H:i:s'),
                        'cof_usu_crea' => $this->tank_auth->get_user_id(),
                        'cof_fecha_crea' => date('Y-m-d H:i:s'),
                        'cof_masivo' => ($this->input->post('cof_masivo')) ? 1 : 0,
                        'cof_actual' => 0
                    );
                    $rango = array();
                    $aplica = true;
                    foreach ($data['correlativo_tabla'] as $key => $value) {
                        $rango[] = ($value['cof_inicio'] . ' ' . $value['cof_fin']);
                    }
                    foreach ($rango as $key => $value) {
                        $valores = explode(' ', $value);
                        $inicio = $valores[0];
                        $fin = $valores[1];

                        if ($_POST['inicioCorrelativo'] >= $inicio && $_POST['inicioCorrelativo'] <= $fin) {
                            $aplica = false;
                            break;
                        } else
                        if ($_POST['inicioCorrelativo'] < $inicio && $_POST['finCorrelativo'] >= $inicio) {
                            $aplica = false;
                            break;
                        } else if ($_POST['inicioCorrelativo'] >= $_POST['finCorrelativo']) {
                            $aplica = false;
                            break;
                        }
                    }

                    if ($aplica) {
                        //var_dump("Entra"); die();
                        $registro = $this->gsatelite->ingresar('cof_correlativo_factura', $info_tabla);
                        if ($registro > 0)
                            $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente");
                        else
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar, verifique la informacion ingresada");
                        $this->session->set_flashdata($alerta);
                        redirect('facturacion/mantenimientos/correlativos/' . $id);
                    } else {
                        //var_dump("DENEGADO"); die();
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar verifique la informacion ingresada ");
                        $this->session->set_flashdata($alerta);
                        redirect('facturacion/mantenimientos/correlativos/' . $id);
                    }
                }
            }
            $this->_cargarvista($data);
        }
    }

    public function eliminar($id_sef, $id_cof, $inicio, $fin) {

        /* Obtener primero todos los correlativos utilizados en facturas para esa serie */
        $en_uso = $this->gsatelite->get_registro('cof_correlativo_factura', array('cof_id_sef' => $id_sef, 'cof_estado' => 1));
        $borrar = true;

        if (count($en_uso) > 1) {
            foreach ($en_uso as $key => $value) {
                if ($value->cof_inicio >= $inicio && $value->cof_fin <= $fin) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro está en uso");
                    $borrar = false;
                    break;
                }
            }
        } else if (count($en_uso) == 1) {
            if ($en_uso->cof_inicio >= $inicio && $en_uso->cof_fin <= $fin) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro está en uso");
                $borrar = false;
            }
        }

        //var_dump($borrar); die();
        if ($borrar) {
            $registro = $this->gsatelite->borrado_general('cof_correlativo_factura', array('cof_id' => $id_cof));
            if ($registro > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar verifique la informacion ingresada");
            }
        }

        $this->session->set_flashdata($alerta);
        redirect('facturacion/mantenimientos/correlativos/' . $id_sef);
    }

    function tipos_pago() {
        satelite_validar();

        $crud = new grocery_CRUD();
        $crud->set_table('tpg_tipo_pago')
                ->set_subject('Tipo de pago')
                ->columns('tpg_nombre', 'tpg_estado')
                ->fields('tpg_nombre', 'tpg_estado', 'tpg_usu_mod', 'tpg_fecha_mod')
                ->display_as('tpg_nombre', 'Nombre')
                ->display_as('tpg_estado', 'Estado')
                ->required_fields('tpg_nombre', 'tpg_estado')
                ->set_rules('tpg_nombre', 'Nombre', 'trim|required|campo_unico[tpg_tipo_pago.tpg_nombre]')
                ->field_type('tpg_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpg_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
        ;
        $urlx = explode('/', uri_string());
        if(end($urlx) == 'add') {
            $crud->field_type('tpg_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Tipos de Pago";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function _cargarvista($data = 0, $crud = 0) {


        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */