<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Cotizaciones
 *
 * @package Satelite Base
 * @author Rene Castaneda
 * @copyright 2014
 * @access public
 */
class Facturar extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('pdf');
        $this->load->model('facturacion_model');
        $this->load->model('tarificador_model');
        $this->load->model('inventario_model');
        $this->load->model('registro_academico_model');
        $this->load->model('gsatelite');
        $this->load->library('form_validation');
        $this->load->library('EnLetras');
    }

    /**
     *
     *
     * @autor Habby Lovo
     * @since 22/05/2017
     * @param $tipo => flag para redirección si es por usuario o general.
     */
    function crear_factura($orv_id = null, $tipo=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $cli_alumno_cuotas = 0;
            $cuota_slctd_pagar = "";
            if ($this->input->post()) {
                $cli_alumno_cuotas = $this->input->post('clienteid');
                $cuota_slctd_pagar = $this->input->post('cuotaslct');
            }

            $datos["titulo_personal"] = "Facturación";
            $persona_array = array();
            $nombre_fac = '';
            $observacion_fac = '';
            $idvendedor = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu'=> $this->tank_auth->get_user_id()));
            $orden_venta_reg = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id'=>$orv_id, 'orv_estado'=>1));
            if(count($orden_venta_reg) > 0){
                $orden_venta_det_reg = $this->gsatelite->get_tabla('pxo_personalxorden_venta', array('pxo_id_orv' => $orden_venta_reg[0]['orv_id']));
                foreach ($orden_venta_det_reg as $key) {
                    $persona_array[] = $key['pxo_id_emp'];
                }
                $nombre_fac = $orden_venta_reg[0]['orv_nombre_factura'];
                $observacion_fac = $orden_venta_reg[0]['orv_observacion'];
            }
            $datos['nombre_factura'] = $nombre_fac;
            $datos['observacion_factura'] = $observacion_fac;
            $datos['orv_id'] = ($orv_id > 0) ? $orv_id : '';
            $datos['tipo'] = $tipo;
            /* PEDIR UNICAMENTE LOS OPTIONS PARA LLENAR LOS SELECTS */
            $clidefct = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO')));
            if (count($clidefct) > 0) {
                $datos['iddf'] = $clidefct[0]['cli_id'];
                $nombre_def = $clidefct[0]['cli_codigo'] . ' - ';
                $nombre_def .= ($clidefct[0]['cli_personeria'] > 1) ? $clidefct[0]['cli_apellido'] : $clidefct[0]['cli_nombre'] . ' ' . $clidefct[0]['cli_apellido'];
                $datos['namedf'] = $nombre_def;
                $datos["cliente_defecto"] = $clidefct[0]['cli_id'];
            } else {
                $datos['iddf'] = "";
                $datos['namedf'] = "";
                $datos["cliente_defecto"] = "";
            }
            if ($cli_alumno_cuotas > 0 && $cuota_slctd_pagar != "") {
                $datos['cuotas_reg_acad_sltd'] = $cuota_slctd_pagar;
                $rowcli = $this->gsatelite->get_registro('cli_cliente', array('cli_estado' => 1, 'cli_id' => $cli_alumno_cuotas));
                $datos['iddf'] = $rowcli->cli_id;
                $nombre_def  = $rowcli->cli_codigo . ' - ';
                $nombre_def .= ($rowcli->cli_personeria > 1) ? $rowcli->cli_apellido : $rowcli->cli_nombre . ' ' . $rowcli->cli_apellido;
                $datos['namedf'] = $nombre_def;
                $datos["cliente_defecto"] = $cli_alumno_cuotas;
            }
            if(count($orden_venta_reg) > 0){
                $cliorv = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $orden_venta_reg[0]['orv_id_cli']));
                $datos['iddf'] = $orden_venta_reg[0]['orv_id_cli'];
                $nombre_orv = $cliorv[0]['cli_codigo'] . ' - ';
                $nombre_orv .= ($cliorv[0]['cli_personeria'] > 1) ? $cliorv[0]['cli_apellido'] : $cliorv[0]['cli_nombre'] . ' ' . $cliorv[0]['cli_apellido'];
                $datos['namedf'] = $nombre_orv;
            }
            $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $datos['cajas'] = $this->facturacion_model->datos_usuario_caja($rol);
            $caj_id_cec_defecto = ($datos["cajas"])? $datos["cajas"][0]['caj_id_cec_defecto']:0;
            $date1 = formatear_fecha('d-m-Y', $datos['cajas'][0]['uxc_fecha_crea']);
            $date2 = date('d-m-Y', time());
            $date3 = formatear_fecha('d-m-Y', $datos['cajas'][0]['uxc_fecha_proceso']);
            $datos['fecha_caja'] = ($datos['cajas'][0]['uxc_fecha_utiliza'] > 0 || ($date2 <= $date1 || $date3 >= $date2)) ? 1 : 2;
            /**/
            // function cerrar_correlativos_agotados($caja){
            //     $correlativoxcaja_reg = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_caj' => $caja, 'cxj_estado' => 1));
            //     foreach ($correlativoxcaja_reg as $key => $value) {
            //         $numeros_cierre_serie = $this->facturacion_model->get_numeros_facturas2(array('fac_numero >=' => $value['cxj_inicio'], 'fac_numero <=' => $value['cxj_fin'], 'fac_id_cof' => $value['cxj_id_cof'], 'fac_id_tif' => $tipo_factura_id));
            //         if((($fin-$inicio) - count($numeros_cierre_serie)) == 0){
            //             $array_update_correlativo = array(
            //                     'cxj_estado' => 0
            //                 );
            //             $where_update_correlativo = array('cxj_inicio' => $inicio, 'cxj_fin' => $fin, 'cxj_id_cof' => $correlativo_id);
            //             $this->gsatelite->actualizar_array('cxj_correlativoxcaja', $array_update_correlativo, $where_update_correlativo);
            //         }
            //     }
            // }
            // print_r($datos['cajas'][0]['uxc_id_caj']);
            // die();

            $user=$this->tank_auth->get_user_id();
            $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$user));
            $sucursal_drop = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, $empleado[0]['emp_id_suc'], '', 'suc_id', true);
            $datos['sucursal'] = str_replace('<option value="0">Seleccione</option>', '', $sucursal_drop);

            $sucursal_cli = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_nombre}', '', array('scl_estado'=>1), null, '', 'scl_id', true);
            $datos['sucursal_cli'] = str_replace('<option value="0">Seleccione</option>', '', $sucursal_cli);

            $formas_pago = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => '1'), null, '', 'frp_id', true);
            $datos["formas_pago"] = str_replace('<option value="0">Seleccione</option>', '', $formas_pago);

            $formas_envio = $this->gsatelite->get_dropdown('frv_forma_envio', '{frv_nombre}', '', array('frv_estado' => '1'), null, '', 'frv_id', true);
            $datos["formas_envio"] = str_replace('<option value="0">Seleccione</option>', '', $formas_envio);

            $transporte = $this->gsatelite->get_dropdown('ttr_tipo_transporte', '{ttr_nombre}', '', array('ttr_estado' => '1'), null, '', 'ttr_id', true);
            $datos["transporte"] = str_replace('<option value="0">Seleccione</option>', '', $transporte);

            $tipos_pago = '';
            $tabla_tipo_pago = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_estado' => 1));
            foreach ($tabla_tipo_pago as $k => $val) {//
                $tipos_pago .= '<option value="' . $val['tpg_id'] . '" data-aplcred="' . intval($val['tpg_aplica_credito']) . '" >' . $val['tpg_nombre'] . '</option>';
            }
            $datos["tipos_pago"] = $tipos_pago;

            $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
            $datos["tpg_contado"] = ($tpg_contado) ? $tpg_contado : 0;
            //datos factura
            $series = $this->facturacion_model->nuevas_series_cargar();
            $series1 = '';
            foreach ($series as $key) {
                $series1 .= '<option value="' . $key['sef_id'] . '" >' . $key['sef_nombre'] . '</option>';
            }
            $datos["series"] = str_replace('<option value="0">Seleccione</option>', '', $series1);
            $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto'=> 1, 'arf_estado'=> 1));

            if(count($orden_venta_reg) > 0){
                $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $orden_venta_reg[0]['orv_id_arf'], '', 'arf_id', true);
            } else{
                $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_defecto, '', 'arf_id', true);
            }
            $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
            /* Centro de Costo por Defecto */
            $empresa     = $this->tank_auth->get_empresa_id();  // Empresa que se ha seleccionado cuando se ha logueado

                           $this->db->where("(cec_id_emr=$empresa OR cec_id_emr IS NULL)");$this->db->limit(1);
            $cec_defecto = $this->gsatelite->get_campo('cec_centro_costo', 'cec_id', array('cec_defecto'=>1, 'cec_estado'=>1));
            $cec_defecto = ($caj_id_cec_defecto > 0) ? $caj_id_cec_defecto : $cec_defecto;
            $costo_drop = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => '1'), $cec_defecto, '', 'cec_id', true);
            $datos["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $costo_drop);
            /* *************************** */
            $data['filtro'] = $filtro = $this->gsatelite->get_parametro('SYS_FAC_FILTRO_VENDEDOR');
            $ven_selected = null;
            if($filtro==1){
                $user = $this->tank_auth->get_user_id();
                $vendedor = $this->gsatelite->get_registro('ven_vendedor', array('ven_id_usu'=>$user));
                if(count($vendedor)>0){
                    $ven_selected = $vendedor->ven_id;
                }
            }
            if ($orv_id>0) {
                $ven_selected = $orden_venta_reg[0]['orv_id_ven'];
            }

            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $ven_selected, '', 'ven_id', true);
            $datos["vendedores"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $vendedores);
            $tpvdef = 0;
            $select = "";
            $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
            foreach ($tip_venta_reg as $key) {
                $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '" >' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
                if ($key['tpv_defecto'] == 1) {
                    $tpvdef = $key['tpv_id'];
                }
            }
            $datos["tpv_defecto"] = $tpvdef;
            $datos["tipo_venta"] = $select;

            // obtener las bodegas
            $monto_zero = $this->gsatelite->get_parametro('SYS_MONTO_ZERO');
            $datos["monto_zero"] = $monto_zero;

            $datos["categorias"] = array(); //$this->obtener_categoriaxbodega2();//antes estaba obtener_categoriaxbodega sin el 2
            $select = "";
            $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));
            foreach ($impuesto_campos as $key) {
                if ($key["imp_defecto"] == 1) {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                }
            }
            $datos["impuestos"] = $select;
            $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
            $datos['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;
            $select = "";
            $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            foreach ($retencion_campos as $key) {
                if ($key["ret_defecto"] == 1) {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
            $datos["retencion"] = $select;
            $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu' => $user));
            $select = "";
            foreach ($bodegas_reg as $key) {
                $selected = ($key['uxb_defecto'] == 1)?'selected':'';
                $select .= '<option value="'.$key['bod_id'].'" '.$selected.'>'.$key['bod_nombre'].'</option>';
            }
            $datos["bodega_prefe"] = $select;
            $datos["id"] = $user;
            $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $persona_array, '', 'emp_id', true);
            $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_select);
            $incoterms_drop = $this->gsatelite->get_dropdown('inr_incoterms', '{inr_codigo} - {inr_nombre}', '', array('inr_estado' => 1), null, '', 'inr_id', true);
            $datos["incotermslc"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $incoterms_drop);
            $decimales  = $this->gsatelite->get_tabla("par_parametro",array('par_codigo' => 'NUMERO_DECIMALES'));
            $datos["cantidad_decimales"] = ($decimales[0]["par_valor"] != "" ) ? $decimales[0]["par_valor"]:$decimales[0]["par_default"];

            // Parametro para obtener el tipo de factura ticket
            $tipo_ticket         = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('TICKET'));
            $dias_antiguedad_saldo = $this->gsatelite->get_parametro('SYS_DIAS_ANTIGUEDAD_SALDO_FACTURACION');
            $datos["dias_antiguedad_saldo"] = ($dias_antiguedad_saldo != "")?$dias_antiguedad_saldo:"90";

            /* METODO , RANGOS Y AUTORIZACION DE DESCUENTOS || ANTES ERA SYS_FAC_AUTORIZACION_DESCUENTO */
            $autorizacion_descuento = $this->gsatelite->get_parametro_emp('SYS_AUTORIZACION_DESCUENTO_FACTURA', 1);
            $descuentos_globales = json_decode($this->gsatelite->get_parametro_emp('SYS_DESCUENTOS_GENERALES'), true);
            $supervisores_option = "";
            if ($autorizacion_descuento == 1) {
                $supervisores_option = $this->facturacion_model->get_supervisores_descuento( array( 'ven_id_usu' => $this->tank_auth->get_user_id() ) );
            }
            $datos['supervisores_option'] = trim($supervisores_option);
            $datos["autorizacion_descuento"] = $autorizacion_descuento;
            $datos['descuento_min_global'] = ($descuentos_globales != null) ? floatval($descuentos_globales['MINIMO']) : 0;
            $datos['descuento_max_global'] = ($descuentos_globales != null) ? floatval($descuentos_globales['MAXIMO']) : 0;
            $datos['modo_descuentos'] = ($this->gsatelite->get_parametro_emp('SYS_MODO_DESCUENTO_FACTURA') != "") ? $this->gsatelite->get_parametro_emp('SYS_MODO_DESCUENTO_FACTURA') : 2;
            ////////////////////////////////////////////////////////////////////////////////////////////////////////

            $datos['tipo_ticket'] = ($tipo_ticket>0)?$tipo_ticket:0;
            $datos["show_option"] = $this->gsatelite->get_parametro('SYS_ELEMENTOS_MOSTRAR_FACTURA','1,1,1,1');
            $datos["focus_defecto_fact"] = $this->gsatelite->get_parametro('SYS_FOCUS_FACTURACION');

                        $this->db->select('ret_id, ret_valor_minimo, ret_porcentaje');
            $data_ret = $this->gsatelite->get_tabla('ret_retencion',array('ret_estado'=>1,'ret_valor_minimo >'=>0));
            $datos["retencionesAuto"] = json_encode($data_ret);

            $producto_maximo = array();
            $configuraciones_factura = $this->gsatelite->get_tabla('frf_formato_factura', array('frf_activo'=>1));
            foreach ($configuraciones_factura as $key => $conf_fac) {
                $formato_array = json_decode($configuraciones_factura[$key]['frf_configuraciones_formato'], true);
                if(isset($formato_array["PRODUCTO_MAXIMO"])){
                    $key = key($formato_array["PRODUCTO_MAXIMO"]);
                    $producto_maximo[$key] = $formato_array["PRODUCTO_MAXIMO"][$key];
                }
            }
            if (!(empty($producto_maximo))) {
                $datos["producto_maximo"] = json_encode($producto_maximo);
            }
            $datos["activar_alerta_productox"] = $this->gsatelite->get_parametro('SYS_NOTIFICACION_EXISTENCIAX');
            $datos["validar_costo"] = $this->gsatelite->get_parametro_emp('SYS_PRECIO_MENOR_COSTO');
            $datos["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
            $datos["tipo_facturacion"] = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);///////////////////////// FACT ELECT
            $datos["permiso_new_cliente"] = $this->gsatelite->get_permisos_opcion('facturacion/entradas/clientes', null, null, true);
            $this->_cargarvista($datos, null);
        }
    }

    function cargar_bodega_preferencial(){
        $user = $this->tank_auth->get_user_id();
        $art_id = $this->input->post('producto');
        //$mep_id = $this->input->post('medida');
        $producto_array = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $art_id, 'cva_estado'=>1));
        $id_movimiento_dev = ($this->input->post('mov_dev_fac') > 0)? 1:0;

        $bod_id_dev = 0;
        if ($this->input->post('id_factura_dev') > 0 &&  $id_movimiento_dev == 1) {
            $id_fdev = $this->input->post('id_factura_dev') ;
                             $this->db->join('moi_movimiento_inv', 'moi_id = dee_id_moi');
            $id_bodega_art = $this->gsatelite->get_tabla('dee_detalle_mov',array("moi_id_fac" => $id_fdev, "dee_id_art" => $art_id));

            $bod_id_dev = $id_bodega_art[0]['moi_id_bod'];
            $bod_name_dev = $this->gsatelite->get_tabla('bod_bodega',array('bod_id'=>$id_bodega_art[0]['moi_id_bod']));

            $arreglo_dev_bod[] = array(
                'bod_id'=>$bod_id_dev,
                'bodega'=>$bod_name_dev[0]['bod_nombre'],
                'mep_id'=>null,
                'cva_convercion'=>null,
                'defecto'=>null,
                'cantidad_base_def'=>0,
                'cantidad_convertida'=>0,
                'seleccionada'=>'selected'
            );
        }

        $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu'=>$user), $art_id);
        $select = array();
        $arreglo = array();
        $encontro_bod_dev = 0;
        foreach ($bodegas_reg as $key) {
            $arreglo_pro_temp = array();

            $encontro_bod_dev = ($bod_id_dev == $key['uxb_id_bod'] || $encontro_bod_dev == 1)? 1:0;

            if ($bod_id_dev == $key['uxb_id_bod'] and $encontro_bod_dev == 1) {
                $selected = "selected";
            } else {
                $selected = ($key['uxb_defecto'] == 1)? ' selected':''; //miramos la bodega defecto para dejarla selected
            }

            if(trim($key['productos']) != ''){//verificamos si hay registros de productos en la bodega
                $productos_reg = $key['productos'];
                $productos_array = explode('*', $productos_reg); //separamos las partes de la consulta, posicion 0, cantidad por unidad defecto, 1 detalles
                $productos_id_array = explode(',', $productos_array[1]); //ids de las unidades de medida mep

                foreach ($productos_id_array as $key2) {
                    $arreglo_temp = explode('+', $key2); //posicion 1 es el id mep
                    $arreglo_temp2 = explode('-', $arreglo_temp[1]); //posicion 0 es el cva_convercion, 1 define el mep defecto

                    $cantidad_convertida = $productos_array[0]/count($producto_array);
                    if($arreglo_temp2[1] != 1){ //verificamos si la cantidad es por defecto, si no es por defecto lo dividimos
                        $cantidad_convertida =  floor(($productos_array[0]/count($producto_array))/$arreglo_temp2[0]);
                    }
                    //se crea un arreglo con los datos de la bodega y los datos de los producto
                    $arreglo_pro_temp[$arreglo_temp[0]] = array(
                        'bod_id'=>$key['bod_id'],
                        'bodega'=>$key['bod_nombre'],
                        'mep_id'=>$arreglo_temp[0],
                        'cva_convercion'=>$arreglo_temp2[0],
                        'defecto'=>$arreglo_temp2[1],
                        'cantidad_base_def'=>floor($productos_array[0]/count($producto_array)),
                        'cantidad_convertida'=>$cantidad_convertida,
                        'seleccionada'=>$selected
                    );
                }
            } else{
                $arreglo_pro_temp[] = array(
                    'bod_id'=>$key['bod_id'],
                    'bodega'=>$key['bod_nombre'],
                    'mep_id'=>null,
                    'cva_convercion'=>null,
                    'defecto'=>null,
                    'cantidad_base_def'=>0,
                    'cantidad_convertida'=>0,
                    'seleccionada'=>$selected
                );
            }

            $arreglo[$key['bod_id']] = $arreglo_pro_temp;
        }
        $defecto = 0;


        foreach ($producto_array as $key => $medidas) { //creamos un arreglo para guardar los select
            //$style = ($medidas['cva_defecto'] == 1)?' style = "display:none;"':''; //escondemos el select que esta inactivo
            $select[$medidas['cva_id_mep']] = '<select id="detall_bodega_add" class="nostyle" placeholder="Seleccione"><option value=""></option>';
        }

        if ($encontro_bod_dev == 0 and $bod_id_dev > 0) {
            $arreglo[$bod_id_dev]  = $arreglo_dev_bod;
        }

        foreach ($arreglo as $key => $bodegas) {
            foreach ($bodegas as $key => $unidades) {
                if(trim($unidades['mep_id']) != ''){
                    $select[$unidades['mep_id']] .= '<option total="'.$unidades['cantidad_convertida'].'" value="'.$unidades['bod_id'].'"'.$unidades['seleccionada'].'>'.$unidades['bodega'].' - '.$unidades['cantidad_convertida'].'</option>';
                } else{
                    foreach ($producto_array as $key => $medidas) {
                        $select[$medidas['cva_id_mep']] .= '<option total="'.$unidades['cantidad_convertida'].'" value="'.$unidades['bod_id'].'"'.$unidades['seleccionada'].'>'.$unidades['bodega'].' - '.$unidades['cantidad_convertida'].'</option>';
                    }
                }
            }
        }
        foreach ($producto_array as $key => $medidas) {
            $select[$medidas['cva_id_mep']] .= '</select>';
            if ($medidas['cva_defecto'] == 1) {
                $defecto = $medidas['cva_id_mep'];
            }
        }
        echo json_encode(array('select_bodegas'=>$select, 'mep_defecto'=>$defecto));
        //$datos["bodega_prefe"] = $select;
    }

    function duplicar_factura($flag=0, $fac_id = 0,  $id_fac = null) {
        //die('abcabcabcabc');
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // si el parametro $fac_id trae cero y el $id_fac es mayor a cero se trata de una devoución. 28052018 //added by René Castaneda
            $fac_id = ($fac_id == 0 && $id_fac > 0)? $id_fac : $fac_id;
            $datos['es_devolucion'] = 0;
            $datos['afecto_fac_inventario_dev'] = 0;
            if ($id_fac > 0) {
                $datos['es_devolucion'] = 1;
                $mov_fac = $this->facturacion_model->get_detalle_movimiento_devolucion($fac_id);
                if (count($mov_fac)) {
                    $datos['afecto_fac_inventario_dev'] = 1;
                }
            }
            $datos["titulo_personal"] = "Facturación";
            /* PEDIR UNICAMENTE LOS OPTIONS PARA LLENAR LOS SELECTS */
            $factura_datos = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $fac_id));
            $datos["datos_factura_origen"] = $factura_datos[0];
            /* ========================================= PARAMETROS ========================================================== */
            $datos["cantidad_decimales"] = $this->gsatelite->get_parametro('NUMERO_DECIMALES','2');
            $datos["show_option"] = $this->gsatelite->get_parametro('SYS_ELEMENTOS_MOSTRAR_FACTURA','1,1,1,1');
            $datos["cliente_defecto"] = $factura_datos[0]['fac_id_cli'];
            $datos["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
            $datos['permite_mas_productos'] = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO',0);
            $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $datos['cajas']  = $this->facturacion_model->datos_usuario_caja($rol);
            $date1 = formatear_fecha('d-m-Y', $datos['cajas'][0]['uxc_fecha_crea']);
            $date2 = date('d-m-Y', time());
            $date3 = formatear_fecha('d-m-Y', $datos['cajas'][0]['uxc_fecha_proceso']);
            $datos['fecha_caja'] = (($date2 <= $date1 || $date3 >= $date2) ? 1 : 2);
            /* ========================================= CLIENTES ========================================================== */
            // Obtener el primer documento de cliente
            $docs_cliente       = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $factura_datos[0]['fac_id_cli']));
            $datos['documento']  = (count($docs_cliente)>0)?$docs_cliente[0]['dcc_valor']:'';
            $client          = '';
            $cliente_nom_fac = '';
            // $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $factura_datos[0]['fac_id_cli']));
            // var_dump
            $datos['iddf'] = $factura_datos[0]['fac_id_cli'];
            $nombre_dpl = $clientes[0]['cli_codigo'] . ' - ';
            $nombre_dpl .= ($clientes[0]['cli_personeria'] > 1) ? $clientes[0]['cli_apellido'] : $clientes[0]['cli_nombre'] . ' ' . $clientes[0]['cli_apellido'];
            $cliente_nom_fac = ($clientes[0]['cli_personeria'] > 1) ? $clientes[0]['cli_apellido'] : $clientes[0]['cli_nombre'] . ' ' . $clientes[0]['cli_apellido'];
            $datos['namedf'] = $nombre_dpl;

            // foreach ($clientes as $cli) {
            //     if ($cli['cli_codigo'] != '') {
            //         $codigo = trim($cli['cli_codigo']) . ' - ';
            //     } else {
            //         $codigo = '';
            //     }
            //     // Verificar cliente de la fuctura
            //     $selected_cli = '';
            //     if (trim($factura_datos[0]['fac_id_cli']) == $cli['cli_id']) {
            //         $selected_cli            = 'selected';
            //         $cliente_nom_fac = ($cli['cli_personeria'] == 1) ? $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $cli['cli_apellido'];
            //     }
            //     // Obtener el nombre del cliente
            //     $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
            //     // Obtener todo los clientes junto al seleccionado
            //     $client .= '<option value="' . $cli['cli_id'] . '" '.$selected_cli.'>' . $nombre_cliente . '</option>';
            // }
            $datos['cliente_nom_fac'] = $cliente_nom_fac;

            //$sucursal_drop = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, $factura_datos[0]['fac_id_suc'], '', 'suc_id', true);
            // Obtener el tipo de factura de nota de credito para la devolucion, sino coloca la que se ha seleccionado por defecto
            $nota_credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('NOTA_CREDITO'));
            $tif_factura  = ($datos['es_devolucion'] == 1 && $nota_credito > 0)? $nota_credito : $factura_datos[0]['fac_id_tif'];


            $tipos_factura = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => '1','tif_aplica_venta' => '1'), $tif_factura, '', 'tif_id', true);
            $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $factura_datos[0]['fac_id_tpg'], '', 'tpg_id', true);
            $formas_pago = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => '1'), $factura_datos[0]['fac_id_frp'], '', 'frp_id', true);
            $select_retencion = "";
            $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            foreach ($retencion_campos as $key) {
                if ($key["ret_defecto"] == 1) {
                    $select_retencion .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select_retencion .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
            //personal para duplicar
            $personal_registros = $this->gsatelite->get_tabla('pxf_personalxfactura', array('pxf_id_fac' => $fac_id));
            $array_emp = array_column($personal_registros, 'pxf_id_emp');
            $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $array_emp, '', 'emp_id', true);
            $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $factura_datos[0]['fac_id_arf'], '', 'arf_id', true);
            $costo_drop = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => '1'), $factura_datos[0]['fac_id_cec'], '', 'cec_id', true);

            $pct_where = array('pcl_id_cli' => $factura_datos[0]['fac_id_cli'], 'pcl_estado' => 1, 'epr_cierre' => 0);
                        $this->db->join('epr_estado_proyecto', 'epr_id = pcl_id_epr');
            $pct_drop = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', $pct_where, $factura_datos[0]['fac_id_pcl'], '', 'pcl_id', true);
            /* ===================================== DATOS DE LA FACTURA A DUPLICAR ============================================== */
            $datos['factura_reg'] = $factura_datos;
            $datos['factura_id'] = $fac_id;
            $datos['factura_dup'] = 1;
            $datos['orv_id'] = '';

            // $datos['clientes'] = $client;
            $datos['nombre_factura'] = $factura_datos[0]['fac_nombre_factura'];
            $datos['documento_factura'] = $factura_datos[0]['fac_documento_cliente'];
            $datos["select_proyectos"] = str_replace('<option value="0">Seleccione</option>', '', $pct_drop);
            //$datos['sucursal'] = str_replace('<option value="0">Seleccione</option>', '', $sucursal_drop);
            $datos["tipos_factura"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_factura);
            $datos["tipos_pago"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_pago);
            $datos["formas_pago"] = str_replace('<option value="0">Seleccione</option>', '', $formas_pago);
            $datos["retencion"] = $select_retencion;
            $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_select);
            $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
            $datos["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $costo_drop);
            $datos["categorias"] = $this->obtener_categoriaxbodega2();
            $datos['observacion_factura'] = $factura_datos[0]['fac_observacion'];
            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $factura_datos[0]['fac_id_ven'], '', 'ven_id', true);
            $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores);
            $id_cli = $this->input->post('id');
            $sucursal_cli = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_codigo} - {scl_nombre}', '', array('scl_estado'=>1, 'scl_id_cli'=>$factura_datos[0]['fac_id_cli']), null, '', 'scl_id', true);
            $sucursal_cli = str_replace('<option value="0">Seleccione</option>', '', $sucursal_cli);
            $sucursal_cli = str_replace('<option value="0">Sin Registros</option>', '', $sucursal_cli);
            $datos['sucursal_cli'] = $sucursal_cli;
            $this->db->select('ret_id,ret_valor_minimo,ret_porcentaje');
            $data_ret = $this->gsatelite->get_tabla('ret_retencion',array('ret_estado'=>1,'ret_valor_minimo >'=>0));
            $datos["retencionesAuto"] = json_encode($data_ret);

            // DESCUENTOS
            $autorizacion_descuento = $this->gsatelite->get_parametro_emp('SYS_AUTORIZACION_DESCUENTO_FACTURA', 1);
            $descuentos_globales = json_decode($this->gsatelite->get_parametro_emp('SYS_DESCUENTOS_GENERALES'), true);
            $supervisores_option = "";
            if ($autorizacion_descuento == 1) {
                $supervisores_option = $this->facturacion_model->get_supervisores_descuento( array( 'ven_id_usu' => $this->tank_auth->get_user_id() ) );
            }
            $datos['supervisores_option'] = trim($supervisores_option);
            $datos["autorizacion_descuento"] = $autorizacion_descuento;
            $datos['descuento_min_global'] = ($descuentos_globales != null) ? floatval($descuentos_globales['MINIMO']) : 0;
            $datos['descuento_max_global'] = ($descuentos_globales != null) ? floatval($descuentos_globales['MAXIMO']) : 0;
            $datos['modo_descuentos'] = ($this->gsatelite->get_parametro_emp('SYS_MODO_DESCUENTO_FACTURA') != "") ? $this->gsatelite->get_parametro_emp('SYS_MODO_DESCUENTO_FACTURA') : 2;

            if($flag>0){
                $datos['tipo'] = 1;
                cargarvista($datos, null, 'facturacion/facturar/crear_factura');///0/1
            }else{
                cargarvista($datos, null, 'facturacion/facturar/crear_factura');
            }
        }
    }

    function generar_garantia($id_factura) {
        $data['detalle_factura'] = $this->facturacion_model->get_producto_factura_detalle(array('def_id_fac' => $id_factura));
        $data['cliente'] = $this->facturacion_model->get_datos_garantia(array('fac_id' => $id_factura));
        $data['tipo_reporte'] = 'pdf';
        $data['numero_factura'] = $id_factura;
        $html = $this->load->view('facturacion/reportes/imprimir_garantia', $data, true);
        //$html_header = $this->load->view('reporte/header', array('titulo' => "GARANTÍA", 'solotitulo'=> true), true);
        $GLOBALS['nombre_reporte'] = 'garantia_' . date('dmY');
        //$this->pdf->writeHTMLCell(50, 0, 50, 50, 'cellcontent', 'LRTB', 1, 0, true, 'L');
        $this->pdf->makePdf($html, 'R', 'garantia', 'Letter');
    }

    //factura
    function imprimir_personal_factura() {
        $data['facturas'] = $this->facturacion_model->get_factura_ven();
        $data['tipo_reporte'] = 'pdf';
        $html = $this->load->view('facturacion/reportes/imprimir_factura_empleado', $data, true);
        // $header = $this->load->view('reporte/header', $data, true);
        $GLOBALS['nombre_reporte'] = 'garantia_' . date('dmY');
        //$this->pdf->writeHTMLCell(50, 0, 50, 50, 'cellcontent', 'LRTB', 1, 0, true, 'L');
        $this->pdf->makePdf($html, 'L', 'garantia', 'Letter');
    }

    function reporte_anticipos_pendientes() {
        $data['anticipos'] = $this->facturacion_model->get_anticipos(array('anl_estado' => 1));
        $data['tipo_reporte'] = 'pdf';
        $html = $this->load->view('facturacion/reportes/imprimir_anticipos_pendientes', $data, true);
        // $header = $this->load->view('reporte/header', $data, true);
        $GLOBALS['nombre_reporte'] = 'garantia_' . date('dmY');
        //$this->pdf->writeHTMLCell(50, 0, 50, 50, 'cellcontent', 'LRTB', 1, 0, true, 'L');
        $this->pdf->makePdf($html, 'R', 'garantia', 'Letter');
    }

    /**
     * @author Habby Lovo
     */
    function obtener_padres_tia($tia_id) {
        ///$tia_id = $this->input->post('categoria');
        $padre = -1;
        $nombre_categoria = "";
        $id_categoria = "";
        $contador = 0;
        do {
            if ($contador == 0) {
                $categorias = $this->inventario_model->get_tia_padres(array('tia_id' => $tia_id));
            } else {
                $categorias = $this->inventario_model->get_tia_padres(array('tia_id' => $padre));
            }
            $padre = $categorias[0]["tia_padre"];
            $nombre_categoria = $categorias[0]["tia_nombre"];
            $id_categoria = $categorias[0]["tia_id"];
            $contador++;
        } while ($padre != null);
        $cadena = array($nombre_categoria, $id_categoria);
        return $cadena;
    }

    function obtener_padre($tia_id, $categorias_array = null) {
        //$registros = $this->inventario_model->get_papa_tia(array('tia_id'=>$tia_id));
        $tia_id_ = '';
        $tia_codigo = '';
        $tia_padre = '';
        $tia_nombre = '';
        foreach ($categorias_array as $key) {
            if ($tia_id == $key['tia_id']) {
                $tia_id = $key['tia_id'];
                $tia_codigo = $key['tia_codigo'];
                $tia_padre = $key['tia_padre'];
                $tia_nombre = $key['tia_nombre'];
            }
        }
        if ($tia_padre != null) {
            do {
                foreach ($categorias_array as $key) {
                    if ($tia_padre == $key['tia_id']) {
                        $tia_id = $key['tia_id'];
                        $tia_codigo = $key['tia_codigo'];
                        $tia_padre = $key['tia_padre'];
                        $tia_nombre = $key['tia_nombre'];
                    }
                }
            } while ($tia_padre != null);
        }
        //echo $tia_nombre;
        return array($tia_nombre, $tia_id, $tia_codigo);
    }

    function obtener_categoriaxbodega() {
        $permite_combinar = $this->gsatelite->get_parametro('SYS_PERMITE_FACTURAR_PRODUCTO_SERVICIO');
        $categoria_productos = $this->inventario_model->get_categoria_factura2("tia_nombre");
        //print_r($this->db->last_query());die();exit();
        $categorias_array = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));
        $select = "";
        $categorias_id = array();
        $categorias_codigo = array();
        $categorias_nombre = array();
        $venta = array();
        $inventario = array();
        foreach ($categoria_productos as $key) {
            if ($key["tia_padre"] == "") {
                if (!in_array($key["tia_nombre"], $categorias_nombre)) {
                    $categorias_nombre[] = $key["tia_nombre"];
                    $categorias_codigo[] = $key["tia_codigo"];
                    $categorias_id[] = $key["tia_id"];
                    $venta[] = $key["art_venta"];
                    $inventario[] = $key["art_inventario"];
                }
            } else {
                $arreglo = $this->obtener_padre($key["tia_id"], $categorias_array);
                if (!in_array($arreglo[0], $categorias_nombre)) {
                    $categorias_nombre[] = $arreglo[0];
                    $categorias_id[] = $arreglo[1];
                    $categorias_codigo[] = $arreglo[2];
                    $venta[] = $key["art_venta"];
                    $inventario[] = $key["art_inventario"];
                }
            }
        }
        for ($x = 0; $x < count($categorias_nombre); $x++) {
            $select .= '<option value="' . $categorias_id[$x] . '">'.$categorias_codigo[$x].' - '.$categorias_nombre[$x] . '</option>';
        }
        return $select;
    }

    function obtener_categoriaxbodega2() {
        $permite_combinar = $this->gsatelite->get_parametro('SYS_PERMITE_FACTURAR_PRODUCTO_SERVICIO');
        $categoria_productos = $this->inventario_model->get_categoria_factura3("tia_nombre");
        $categorias_array = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));
        $select = "";
        $categorias_id = array();
        $categorias_codigo = array();
        $categorias_nombre = array();
        $venta = array();
        $inventario = array();
        foreach ($categoria_productos as $key) {
            if ($key["tia_estado"] > 0) {
                if ($key["tia_padre"] == "") {
                    if (!in_array($key["tia_nombre"], $categorias_nombre)) {
                        $categorias_nombre[] = $key["tia_nombre"];
                        $categorias_codigo[] = $key["tia_codigo"];
                        $categorias_id[] = $key["tia_id"];
                        $venta[] = $key["art_venta"];
                        $inventario[] = $key["art_inventario"];
                    }
                } else {
                    $arreglo = $this->obtener_padre($key["tia_id"], $categorias_array);
                    if (!in_array($arreglo[0], $categorias_nombre)) {
                        $categorias_nombre[] = $arreglo[0];
                        $categorias_id[] = $arreglo[1];
                        $categorias_codigo[] = $arreglo[2];
                        $venta[] = $key["art_venta"];
                        $inventario[] = $key["art_inventario"];
                    }
                }
            }
        }
        for ($x = 0; $x < count($categorias_nombre); $x++) {
            $select .= '<option value="' . $categorias_id[$x] . '">'.$categorias_codigo[$x].' - '.$categorias_nombre[$x] . '</option>';
        }
        return $select;
    }

    function cargar_cotizacion_factura() {
        $cot_id = $this->input->post('cotizacion');
        $cotizaciones = $this->facturacion_model->get_producto_detalle(array('axc_id_cot' => $cot_id));
        $proyectos = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $cot_id, 'cot_estado' => 1));
        $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));
        $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $contador = 1;

        $tabla_llenar = "";
        $productos_id = "";
        foreach ($cotizaciones as $key) {
            $axc_id = $key['axc_id'];
            $id_art = $key['axc_id_art'];
            $codigo = $key['art_codigo'];
            $medida = $key['cva_id'];
            $tipo_producto = $key['art_tipo'];
            $descripcion = $key['axc_descripcion'];

            $productos_id .= $id_art . ',';

            $precio = $key['axc_precio'];
            $cantidad = $key['axc_cantidad'];
            $impuesto = $key['axc_impuesto'];
            $subtotal = $key['axc_subtotal'];
            $descuento_cant = $key['axc_descuento'];

            $total_precio_cantidad = '<label id="sum_label_' . $id_art ."_". $contador. '">$' . number_format(($precio * $cantidad), 2) . "</label>";

            $impuestos_act_producto = '';
            $impuestos_array_act_producto = '';
            $impuesto_cantidad_maxima = 0;
            $impuesto_producto = $this->facturacion_model->get_impuestos_productos(array('ixt_id_axc' => $axc_id));
            //$impuesto_producto = $this->gsatelite->get_tabla('ixt_impuestoxcotizacion', array('ixt_id_axc'=>$axc_id));
            foreach ($impuesto_producto as $key2) {
                $impuestos_act_producto .= $key2['ixt_id_imp'] . ',';
                $impuestos_array_act_producto .= $key2['imp_porcentaje'] . ',';
                $impuesto_cantidad_maxima += $key2['imp_porcentaje'];
            }
            if ($impuestos_act_producto != '') {
                $impuestos_act_producto = substr($impuestos_act_producto, 0, -1);
                $impuestos_array_act_producto = substr($impuestos_array_act_producto, 0, -1);
            }
            //verificar despues 14/11/2017
            //$id_combo_agrupacion = '<input type="hidden" id="combo_agrupacion'.$id_producto.'_'.$contador.'" value="'.$combo_agrupacion.'" />';//sin cambios

            $id_id_producto = '<input type="hidden" id="producto_detalle' . $id_art ."_". $contador. '" name="producto_factura[]" value="' . $id_art . '" />'; //sin cambios
            $id_producto_correlativo = '<input type="hidden" name="producto_correlativo[]" value="' . $contador . '" />';//Se agrego 26/10/2017
            $id_medida_producto = '<input type="hidden" name="medida_factura[]" id="medida_factura_' . $id_art ."_". $contador. '" value="' . $medida . '" />';
            $id_codigo_producto = '<input type="hidden" name="codigo_factura[]" value="' . $codigo . '" />'; //sin cambios
            $id_descripcion_producto = '<input type="hidden" name="descripcion_factura[]" id="descripcion_factura_' . $id_art."_". $contador. '" value="' . $descripcion . '" />';
            $id_cantidad_producto = '<input type="hidden" name="cantidad_factura[]" id="cantidad_factura_' . $id_art ."_". $contador. '" idn="' . $id_art . '_6" value="' . $cantidad . '" />';
            $id_precio_producto = '<input type="hidden" name="precio_factura[]" id="precio_factura_' . $id_art ."_". $contador. '" correlativo="'.$contador.'" idn="' . $id_art . '" class="precios_sumar" value="' . $precio . '" />';

            $id_impuesto_array = '<input type="hidden" name="impuesto_array[]" id="impuesto_array_' . $id_art ."_". $contador. '" value="' . $impuestos_act_producto . '" />';
            $id_retencion_array = '<input type="hidden" name="retencion_array[]" id="retencion_array_' . $id_art ."_". $contador. '" value="0" />';
            $id_impuesto_por_array = '<input type="hidden" name="impuesto_por_array[]" id="impuesto_por_array_' . $id_art ."_". $contador. '" value="' . $impuestos_array_act_producto . '" />';
            $id_retencion_por_array = '<input type="hidden" name="retencion_por_array[]" id="retencion_por_array_' . $id_art ."_". $contador. '" value="0" />';

            //porcentaje total de los descuento, retenciones e impuestos
            $id_impuesto_por_producto = '<input type="hidden" name="impuesto_por_factura[]" id="impuesto_por_factura_' . $id_art ."_". $contador. '" value="' . $impuesto_cantidad_maxima . '" />';
            $id_retencion_por_producto = '<input type="hidden" name="retencion_por_factura[]" id="retencion_por_factura_' . $id_art ."_". $contador. '" value="0" />';
            $id_descuento_por_producto = '<input type="hidden" name="descuento_por_factura[]" id="descuento_por_factura_' . $id_art ."_". $contador. '" value="' . $descuento_cant . '" />';

            $descuento = ($precio * $cantidad) * ($descuento_cant / 100);
            $retencion = (($precio * $cantidad) - 0) * (0 / 100);
            $impuesto = (($precio * $cantidad) - $descuento) * ($impuesto_cantidad_maxima / 100);

            //cantidad aplicando el impuesto
            $id_impuesto_producto = '<input type="hidden" name="impuesto_factura[]" id="impuesto_factura_' . $id_art ."_". $contador. '" idn="' . $id_art . '_1" value="' . $impuesto . '" />';
            $id_retencion_producto = '<input type="hidden" name="retencion_factura[]" id="retencion_factura_' . $id_art ."_". $contador. '" idn="' . $id_art . '_2" value="' . $retencion . '" />';
            $id_descuento_producto = '<input type="hidden" name="descuento_factura[]" id="descuento_factura_' . $id_art ."_". $contador. '" idn="' . $id_art . '_3" value="' . $descuento . '" />';

            $subtotal_factura = ($precio * $cantidad) - $descuento;

            $total_factura = $subtotal_factura + $impuesto;
            $id_subtotal_producto = '<input type="hidden" name="subtotal_factura[]" id="subtotal_factura_' . $id_art ."_". $contador. '" idn="' . $id_art . '_4" value="' . $subtotal_factura . '" />';
            $id_total_producto = '<input type="hidden" name="total_factura[]" id="total_factura_' . $id_art ."_". $contador. '" idn="' . $id_art . '_5" value="' . $total_factura . '" />';

            $aplica = $this->aplica_descarga($id_art, $cantidad, 1);
            $id_aplica = '<input type="hidden" name="aplica_descarga[]" id="aplica_descarga' . $id_art ."_". $contador.'" value="' . $aplica['aplica'] . '" />'; //sin cambios

            $editar = '<a id="modificar_factura" correlativo="'.$contador.'" idn="' . $id_art . '_7" fecha_garantia dias_garantia href="#detalle_producto" id_pro="' . $id_art ."_". $contador. '" cant="' . $cantidad . '" uni="' . $medida . '" prec="' . $precio . '" descrip="' . $descripcion . '" imp="' . $impuestos_act_producto . '" ret="" desc="' . $descuento_cant . '" class="icon12 icomoon-icon-pencil-5 detalle_fanc verificar_garantia" style="margin-right: 10px;font-size:15px"></a>';

            $eliminar = '<a id="del_doc" valor="' . $contador . '" thead="tabla_detalle" tbody="contenedor_detalles" class="icon-remove white" style="margin-right: 5px;cursor:pointer;">&nbsp;</a>';
            $caracteristicas = '<a class="icon-table detalle_fanc" style="cursor:pointer;" id="agregar_caracteristica" href="#caracteristica_producto' . $id_art ."_". $contador. '"><span class="icon16 icomoon-icon-list-view-2"></span></a>';

            $text_codigo_producto = '<label id="text_codigo_' . $id_art ."_". $contador. '">' . $codigo . '</label>';
            $text_descripcion_producto = '<label id="text_descripcion_' . $id_art ."_". $contador. '">' . $descripcion . '</label>';
            $text_cantidad_producto = '<label id="text_cantidad_' . $id_art ."_". $contador. '">' . $cantidad . '</label>';
            $text_precio_producto = '<label id="text_precio_' . $id_art ."_". $contador. '">$' . number_format($precio, 2) . '</label>';
            $text_impuesto = '<label id="text_impuesto_' . $id_art ."_". $contador. '">$' . number_format($impuesto, 2) . '</label>';
            $text_retencion = '<label id="text_retencion_' . $id_art ."_". $contador. '">$' . number_format($retencion, 2) . '</label>';
            $text_descuento = '<label id="text_descuento_' . $id_art ."_". $contador. '">$' . number_format($descuento, 2) . '</label>';
            $text_subtotal_factura = '<label id="text_subtotal_factura_' . $id_art ."_". $contador. '">$' . number_format($subtotal_factura, 2) . '</label>';
            $text_total_factura = '<label id="text_total_factura_' . $id_art ."_". $contador. '">$' . number_format($total_factura, 2) . '</label>';


            $id_tipo_producto = '<input type="hidden" name="tip_producto[]" id="tip_producto' . $id_art ."_". $contador. '" value="' . $tipo_producto . '" />'; //sin cambios

            $tabla_llenar .= '<tr id="filatabla_detalle' . $contador . '" >' .
                    '<td>' . $id_aplica . $id_id_producto . $id_medida_producto . $id_codigo_producto .$id_producto_correlativo. $text_codigo_producto . '</td>' .
                    '<td>' . $id_descripcion_producto . $text_descripcion_producto . '</td>' .
                    '<td>' . $id_cantidad_producto . $text_cantidad_producto . '</td>' .
                    '<td>' . $id_precio_producto . $text_precio_producto . '</td>' .
                    '<td>' . $total_precio_cantidad . '</td>' .
                    '<td>' . $id_descuento_producto . $id_descuento_por_producto . $text_descuento . '</td>' .
                    '<td>' . $id_subtotal_producto . $text_subtotal_factura . '</td>' .
                    '<td>' . $id_impuesto_producto . $id_impuesto_por_producto . $id_impuesto_array . $id_impuesto_por_array . $text_impuesto . '</td>' .
                    '<td>' . $id_retencion_producto . $id_retencion_por_producto . $id_retencion_array . $id_retencion_por_array . $text_retencion . '</td>' .
                    '<td>' . $id_tipo_producto . $id_total_producto . $text_total_factura . '</td>' .
                    '<td align="center"><div>' . $editar . $eliminar . $caracteristicas . '<div id="caracteristica_producto' . $id_art ."_". $contador. '" style="display:none"></div></div></td>' .
                    '</tr>';
            $contador++;
        }
        $productos_id = substr($productos_id, 0, -1);
        echo json_encode(array('tabla' => $tabla_llenar, 'contador' => $contador, 'productos' => $productos_id, 'proyecto'=>$proyectos[0]['cot_id_pcl'], 'fecha_entrega'=>formatear_fecha('d-m-Y', $proyectos[0]['cot_fecha_entrega'])));
    }

    function cargar_ordenes_venta_factura($tipo = -1) {
        $id = $this->input->post('orden');
        $cli_id = $this->input->post('cliente');
        $es_devolucion = ($this->input->post('es_devolucion') != null && $this->input->post('es_devolucion') == 1) ? 1:0;
        $correlativo_cotizacion = $this->input->post('correlativo_cotizacion');
        $data_grid['es_devolucion'] = ($this->input->post('es_devolucion') == 2) ? 2 : $es_devolucion;
        $data_grid['correlativo_cotizacion'] = $correlativo_cotizacion;
        $tabla = '';
        $contador = 1;
        $productos_id = '';
        $proyecto = '';
        $fecha = '';
        $persona_array = array();
        $nombre_fac = '';
        $observacion_fac = '';
        $orv_id = '';
        $empleados_select = '';
        $vendedor_select = '';
        $area_fac = '';
        $tpg_id = '';
        $formula_id = '';
        $formula_valor = '';
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data_grid['decimales'] = ($decimales != '') ? $decimales : 2;
        $data_grid['cliente'] = $cli_id;
        $data_grid['tipo'] = $tipo;
        $numero_orden_compra = '';

        if($tipo == 0){// caso de cotizaciones.
            $cli_info = $this->gsatelite->get_tabla('cli_cliente', array('cli_id'=>$cli_id, 'cli_estado'=>1));
            $consulta = $this->facturacion_model->get_detalle_cotizacion_factura(array('axc_id_cot' =>$id, 'axc_estado' =>1));
            //Verificar si hay registros
            if(count($consulta) > 0){
                $numero_orden_compra = $consulta[0]['cog_numero_orden'];
            }
            if (count($cli_info)>0) {
                $vendedor_select =   $cli_info[0]['cli_id_ven'];
            }
            if(count($consulta) > 0){
                foreach ($consulta as $key) {
                    $axc_id_foa = $key['axc_id_foa'];
                    $axc_valor_formula = $key['axc_valor_formula'];
                    $formula_id .= $axc_id_foa.',';
                    $formula_valor .= $axc_valor_formula.',';
                }
                $formula_id = substr($formula_id, 0, -1);
                $formula_valor = substr($formula_valor, 0, -1);
            }
            if ($vendedor_select==''|| $vendedor_select== null) {
                $vendedor_select = $consulta[0]['cot_id_ven'];
            }
            $data_grid['tipo_consulta'] = $tipo;
            $data_grid['detalles_factura'] = $consulta;
            $tpg_id = $consulta[0]['cot_id_tpg'];
            $proyecto = $consulta[0]['cot_id_pcl'];
            $fecha = formatear_fecha('d-m-Y', $consulta[0]['cot_fecha_entrega']);
            $tabla = $this->load->view('facturacion/facturar/grid_facturar_cot_orv', $data_grid, true);
        } else if($tipo == 1){
            // ordenes de venta.
            $cli_info = $this->gsatelite->get_tabla('cli_cliente', array('cli_id'=>$cli_id, 'cli_estado'=>1));
            if (count($cli_info)>0) {
                $vendedor_select =   $cli_info[0]['cli_id_ven'];
            }
            $orden_venta_reg = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id'=>$id, 'orv_estado'=>1));
            if(count($orden_venta_reg) > 0){
                $orden_venta_det_reg = $this->gsatelite->get_tabla('pxo_personalxorden_venta', array('pxo_id_orv'=>$id));
                foreach ($orden_venta_det_reg as $key) {
                    $persona_array[] = $key['pxo_id_emp'];
                }
                $nombre_fac = $orden_venta_reg[0]['orv_nombre_factura'];
                $observacion_fac = $orden_venta_reg[0]['orv_observacion'];
                $area_fac = $orden_venta_reg[0]['orv_id_arf'];
                $tpg_id = $orden_venta_reg[0]['orv_condicion_pago'];
                if ($vendedor_select==''|| $vendedor_select== null) {
                    $vendedor_select = $orden_venta_reg[0]['orv_id_ven'];
                }
            }
            $datos['nombre_factura'] = $nombre_fac;
            $datos['observacion_factura'] = $observacion_fac;
            $datos['orv_id'] = $orv_id;
            $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $persona_array, '', 'emp_id', true);
            $empleados_select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $empleados_select);
            $consulta = $this->facturacion_model->get_detalle_orden_factura(array('dov_id_orv' =>$id));
            $data_grid['detalles_factura'] = $consulta;
            $data_grid['tipo_consulta'] = $tipo;
            $tabla = $this->load->view('facturacion/facturar/grid_facturar_cot_orv', $data_grid, true);
        } else if($tipo == 2){
            $consulta = $this->facturacion_model->get_detalle_factura_duplicar(array('def_id_fac' =>$id));
            $haynotas = $this->facturacion_model->existen_notas_credito($id);
            if (count($haynotas) > 0) {
                foreach ($consulta as $key => &$value) {
                    //Se coloca &$value para que el array se modifique, si solo se pone $value no lo hara
                    foreach ($haynotas as $k => $nota) {
                        if ($nota['def_id_art'] == $value['articulo'] && $nota['def_id_cva'] == $value['id_cva']) {
                            $value['subtotal'] = $value['subtotal'] - abs($nota['def_subtotal']);
                            $value['impuesto'] = $value['impuesto'] - abs($nota['def_impuesto']);
                            $value['total'] = $value['total'] - (abs($nota['def_impuesto']) + abs($nota['def_subtotal']));
                            $value['suma'] = $value['suma'] - abs($nota['def_descuento']);
                            $value['precio'] = $value['precio'] - (abs($nota['def_subtotal']) / $nota['def_cantidad']);
                        }
                    }
                }
            }
            $id_bodega_art_mov = array();
            //si es devolución preguntar por el movimiento de inventario
            if ($es_devolucion == 1){
                $movimiento_devolucion = $this->facturacion_model->get_detalle_movimiento_devolucion($id);
                if (count($movimiento_devolucion) > 0) {
                    $id_bodega_art_mov = array_column($movimiento_devolucion, 'moi_id_bod', 'dee_id_art');
                }
            }
            $data_grid['tipo_consulta'] = $tipo;
            $data_grid['id_bodega_art_mov'] = $id_bodega_art_mov;
            $data_grid['detalles_factura'] = $consulta;
            // print_r($consulta);die();
            $tabla = $this->load->view('facturacion/facturar/grid_facturar_cot_orv', $data_grid, true);
        } else{
            $consulta = array();
        }

        if(count($consulta) > 0){
            foreach ($consulta as $key) {
                $id_art = $key['articulo'];
                $productos_id .= $id_art . ',';
                $contador++;
            }
            $productos_id = substr($productos_id, 0, -1);
        }

        echo json_encode(array(
            'tabla'=>$tabla,
            'contador' => $contador,
            'productos' => $productos_id,
            'proyecto'=> $proyecto,
            'fecha_entrega'=> $fecha,
            'nombre_factura'=>$nombre_fac,
            'observacion_factura'=>$observacion_fac,
            'empleados_select'=>$empleados_select,
            'vendedor_select'=>$vendedor_select,
            'orv_id' => $orv_id,
            'tipo_pago' => $tpg_id,
            'area_fac'=>$area_fac,
            'formula_id'=>$formula_id,
            'formula_valor'=>$formula_valor,
            'numero_orden_compra' => $numero_orden_compra,
            'filtrarvendedor' => $this->gsatelite->get_parametro('SYS_FAC_FILTRO_VENDEDOR', 1)
        ));
    }

    public function cargar_cuotas_curso_factura(){
        $contador = 1;
        $productos_id = '';
        $id = $this->input->post('orden');
        $cli_id = $this->input->post('cliente');
        $array_articulos = $this->input->post('productos');
        $array_cuotas = $this->input->post('varias_cuotas');
        $correlativo_cotizacion = $this->input->post('correlativo_cotizacion');
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data_grid['correlativo_cotizacion'] = $correlativo_cotizacion;
        $data_grid['decimales'] = ($decimales != '') ? $decimales : 2;
        $data_grid['tipo'] = 3;
        $where = array('cmc_estado' => 1);
        if (is_array($array_cuotas) && count($array_cuotas) > 1) {
            $txtcuotas = implode(',', $array_cuotas);
            $where["cmc_id IN ($txtcuotas)"] = null;
        } else {
            $where['cmc_id'] = $id;
        }
        if (is_array($array_articulos) && count($array_articulos) > 0) {
            $productos = implode(',', array_unique($array_articulos));
            $where["a.art_id IN ($productos)"] = null;
        }
        $alm_inf = $this->gsatelite->get_tabla('alm_alumno', array('alm_id_cli'=>$cli_id, 'alm_estado'=>1));
        $consulta = $this->facturacion_model->get_detalle_cuotas_curso_factura($where);
        $data_grid['detalles_factura'] = $consulta;
        $data_grid['cliente'] = $cli_id;
        $preins = $this->facturacion_model->get_preinscripcion_almMod(array('mod_id_art'=>$consulta[0]['articulo'], 'alm_id_cli'=>$cli_id, 'lxp_tipo_inscripcion'=>1));
        $data_grid['lxp'] = (count($preins) > 0) ? $preins['lxp_id'] : 0;
        $tabla = $this->load->view('facturacion/facturar/grid_facturar_cuotas_cmc', $data_grid, true);
        if(count($consulta) > 0){
            foreach ($consulta as $key) {
                $id_art = $key['articulo'];
                $productos_id .= $id_art . ',';
                $contador++;
            }
            $productos_id = substr($productos_id, 0, -1);
        }

        $answer = array(
            'tabla'=>$tabla,
            'contador' => $contador,
            'productos' => $productos_id,
            // 'proyecto'=> $proyecto,
            // 'fecha_entrega'=> $fecha,
            // 'nombre_factura'=>$nombre_fac,
            // 'observacion_factura'=>$observacion_fac,
            // 'empleados_select'=>$empleados_select,
            // 'vendedor_select'=>$vendedor_select,
            // 'orv_id' => $orv_id,
            // 'tipo_pago' => $tpg_id,
            // 'area_fac'=>$area_fac,
            // 'formula_id'=>$formula_id,
            // 'formula_valor'=>$formula_valor,
            // 'numero_orden_compra' => $numero_orden_compra,
            'filtrarvendedor' => $this->gsatelite->get_parametro('SYS_FAC_FILTRO_VENDEDOR', 1)
        );
        echo json_encode( $answer );
    }


    function cargar_registros_factura($fac_id) {
        //$productos_reg = $this->gsatelite->get_tabla('def_detalle_fact', array('def_id_fac'=>$fac_id));
        $productos_reg = $this->facturacion_model->get_producto_factura_detalle(array('def_id_fac' => $fac_id));

        $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));
        $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $contador = 1;

        $tabla_llenar = "";
        $productos_id = "";
        $descuento_porcentaje_factura = 0;
        $contador_productos = 0;
        $correlativo_productos = 1;
        foreach ($productos_reg as $key) {

            $def_id = $key['def_id'];
            $id_art = $key['def_id_art'];
            $codigo = $key['art_codigo'];
            $medida = $key['def_id_cva'];

            $id_formula = (trim($key['def_id_fao']) != "") ? $key['def_id_fao'] : null;
            $valor_formula = (trim($key['def_valor_formula']) != "") ? $key['def_valor_formula'] : 0.00;
            $descripcion = $key['def_descripcion'];

            //$productos_id .= $id_art.',';

            $precio                 = $key['def_precio'];
            $cantidad               = $key['def_cantidad'];
            $impuesto               = $key['def_impuesto'];
            $retencion              = $key['def_retencion'];
            $descuento              = $key['def_descuento'];
            $precio_sugerido_lista  = $key['def_precio_sugerido_lista'];

            $total_precio_cantidad = '<label id="sum_label_' . $id_art .'_'.$correlativo_productos. '">$' . number_format(($precio * $cantidad), 2) . "</label>";

            $impuesto_por = $key['def_porcentaje_impuesto'];
            $retencion_por = $key['def_porcentaje_retencion'];
            $descuento_por = $key['def_porcentaje_descuento'];

            $subtotal = $key['def_subtotal'];

            $tipo_producto = $key['art_tipo'];
            $combo_agrupacion = $key['art_combo'];
            $fecha_garantia = $key['def_fecha_vence_garantia'];
            $dias_garantia = $key['def_dias_garantia'];

            $tipo_venta = $key['def_id_tpv'];
            $tipo_venta_text = $key['tpv_abreviacion'];

            //impuesto
            $impuestos_act_producto = '';
            $impuestos_array_act_producto = '';
            //$impuesto_cantidad_maxima = 0;
            $impuesto_producto = $this->facturacion_model->get_impuestos_factura_productos(array('ixf_id_def' => $def_id));
            //$impuesto_producto = $this->gsatelite->get_tabla('ixt_impuestoxcotizacion', array('ixt_id_axc'=>$axc_id));
            foreach ($impuesto_producto as $key2) {
                $impuestos_act_producto .= $key2['ixf_id_imp'] . ',';
                $impuestos_array_act_producto .= $key2['imp_porcentaje'] . ',';
                //$impuesto_cantidad_maxima += $key2['imp_porcentaje'];
            }
            if ($impuestos_act_producto != '') {
                $impuestos_act_producto = substr($impuestos_act_producto, 0, -1);
                $impuestos_array_act_producto = substr($impuestos_array_act_producto, 0, -1);
            }

            //retencion
            $retencion_act_producto = '';
            $retencion_array_act_producto = '';
            //$impuesto_cantidad_maxima = 0;
            $retencion_producto = $this->facturacion_model->get_retencion_factura_productos(array('rxf_id_def' => $def_id));
            //$impuesto_producto = $this->gsatelite->get_tabla('ixt_impuestoxcotizacion', array('ixt_id_axc'=>$axc_id));
            foreach ($retencion_producto as $key2) {
                $retencion_act_producto .= $key2['rxf_id_ret'] . ',';
                $retencion_array_act_producto .= $key2['ret_porcentaje'] . ',';
                //$impuesto_cantidad_maxima += $key2['imp_porcentaje'];
            }
            if ($retencion_act_producto != '') {
                $retencion_act_producto = substr($retencion_act_producto, 0, -1);
                $retencion_array_act_producto = substr($retencion_array_act_producto, 0, -1);
            }

            $id_id_producto = '<input type="hidden" id="producto_detalle' . $id_art .'_'.$correlativo_productos.'" name="producto_factura[]" value="' . $id_art . '" />'; //sin cambios
            $id_medida_producto = '<input type="hidden" name="medida_factura[]" id="medida_factura_' . $id_art .'_'.$correlativo_productos. '" value="' . $medida . '" />';
            $id_codigo_producto = '<input type="hidden" name="codigo_factura[]" value="' . $codigo . '" />'; //sin cambios
            $id_descripcion_producto = '<input type="hidden" name="descripcion_factura[]" id="descripcion_factura_' . $id_art .'_'.$correlativo_productos. '" value="' . $descripcion . '" />';
            $id_cantidad_producto = '<input type="hidden" name="cantidad_factura[]" id="cantidad_factura_' . $id_art .'_'.$correlativo_productos. '" idn="' . $id_art . '_6" value="' . $cantidad . '" />';
            $id_precio_producto = '<input type="hidden" name="precio_factura[]" id="precio_factura_' . $id_art .'_'.$correlativo_productos. '" idn="' . $id_art . '" correlativo="'.$correlativo_productos.'" class="precios_sumar" value="' . $precio . '" />';
            $id_producto_correlativo = '<input type="hidden" name="producto_correlativo[]" value="' . $correlativo_productos . '" />';
            $input_precio_sugerido    = '<input type="hidden" name="precio_sugerido_array[]" value="'.$precio_sugerido_lista.'">';


            $id_impuesto_array = '<input type="hidden" name="impuesto_array[]" id="impuesto_array_' . $id_art .'_'.$correlativo_productos. '" value="' . $impuestos_act_producto . '" />';
            $id_retencion_array = '<input type="hidden" name="retencion_array[]" id="retencion_array_' . $id_art .'_'.$correlativo_productos. '" value="' . $retencion_act_producto . '" />';
            $id_impuesto_por_array = '<input type="hidden" name="impuesto_por_array[]" id="impuesto_por_array_' . $id_art .'_'.$correlativo_productos. '" value="' . $impuestos_array_act_producto . '" />';
            $id_retencion_por_array = '<input type="hidden" name="retencion_por_array[]" id="retencion_por_array_' . $id_art .'_'.$correlativo_productos. '" value="' . $retencion_array_act_producto . '" />';

            //porcentaje total de los descuento, retenciones e impuestos
            $id_impuesto_por_producto = '<input type="hidden" name="impuesto_por_factura[]" id="impuesto_por_factura_' . $id_art .'_'.$correlativo_productos. '" value="' . $impuesto_por . '" />';
            $id_retencion_por_producto = '<input type="hidden" name="retencion_por_factura[]" id="retencion_por_factura_' . $id_art .'_'.$correlativo_productos. '" value="' . $retencion_por . '" />';
            $id_descuento_por_producto = '<input type="hidden" name="descuento_por_factura[]" id="descuento_por_factura_' . $id_art .'_'.$correlativo_productos. '" value="' . $descuento_por . '" />';

            $descuento = ($precio * $cantidad) * ($descuento_por / 100);
            $retencion = (($precio * $cantidad) - $descuento) * ($retencion_por / 100);
            $impuesto = (($precio * $cantidad) - $descuento) * ($impuesto_por / 100);

            //cantidad aplicando el impuesto
            $id_impuesto_producto = '<input type="hidden" name="impuesto_factura[]" id="impuesto_factura_' . $id_art .'_'.$correlativo_productos. '" idn="' . $id_art . '_1" value="' . $impuesto . '" />';
            $id_retencion_producto = '<input type="hidden" name="retencion_factura[]" id="retencion_factura_' . $id_art .'_'.$correlativo_productos. '" idn="' . $id_art . '_2" value="' . $retencion . '" />';
            $id_descuento_producto = '<input type="hidden" name="descuento_factura[]" id="descuento_factura_' . $id_art .'_'.$correlativo_productos. '" idn="' . $id_art . '_3" value="' . $descuento . '" />';

            $subtotal_factura = ($precio * $cantidad) - $descuento;

            $total_factura = $subtotal_factura + $impuesto;
            $id_subtotal_producto = '<input type="hidden" name="subtotal_factura[]" id="subtotal_factura_' . $id_art .'_'.$correlativo_productos. '" idn="' . $id_art . '_4" value="' . $subtotal_factura . '" />';
            $id_total_producto = '<input type="hidden" name="total_factura[]" id="total_factura_' . $id_art .'_'.$correlativo_productos. '" idn="' . $id_art . '_5" value="' . $total_factura . '" />';


            $aplica = $this->aplica_descarga($id_art, $cantidad, 1);

            $id_combo_agrupacion = '<input type="hidden" id="combo_agrupacion' . $id_art .'_'.$correlativo_productos. '" value="' . $combo_agrupacion . '" />'; //sin cambios

            $id_aplica = '<input type="hidden" name="aplica_descarga[]" id="aplica_descarga' . $id_art .'_'.$correlativo_productos. '" value="' . $aplica['aplica'] . '" />'; //sin cambios
            $id_tipo_producto = '<input type="hidden" name="tip_producto[]" id="tip_producto' . $id_art .'_'.$correlativo_productos. '" value="' . $tipo_producto . '" />'; //sin cambios
            $id_fecha_garantia = '<input type="hidden" name="garantia_factura[]" id="garantia_factura' . $id_art .'_'.$correlativo_productos. '" value="">';
            $id_fecha_garantia_text = '<input type="hidden" name="txtgarantia_factura[]" id="txtgarantia_factura' . $id_art .'_'.$correlativo_productos. '" value="">';

            $id_tipo_venta = '<input type="hidden" name="tipo_venta[]" id="tipo_venta_' . $id_art .'_'.$correlativo_productos. '" value="' . $tipo_venta . '">';


            /* $id_fecha_garantia = '<input type="hidden" name="garantia_factura[]" id="garantia_factura'. $id_art .'" value="'.$fecha_garantia.'">';
              $id_fecha_garantia_text = '<input type="hidden" name="txtgarantia_factura[]" id="txtgarantia_factura'. $id_art .'" value="'.$dias_garantia.'">'; */

            //fecha_garantia="'.$fecha_garantia.'" dias_garantia="'.$dias_garantia.'"
            $editar = '<a id="modificar_factura" idn="' . $id_art . '_7_'.$correlativo_productos.'" fecha_garantia="" dias_garantia="" href="#detalle_producto" id_pro="' . $id_art . '" cant="' . $cantidad . '" uni="' . $medida . '" prec="' . $precio . '" descrip="' . $descripcion . '" imp="' . $impuestos_act_producto . '" ret="' . $retencion_act_producto . '" desc="' . $descuento_por . '" tip_v="' . $tipo_venta . '" correlativo="'.$correlativo_productos.'"  class="icon12 icomoon-icon-pencil-5 detalle_fanc" style="margin-right: 10px;font-size:15px"></a>';

            $eliminar = '<a id="del_doc" valor="' . $contador . '" thead="tabla_detalle" tbody="contenedor_detalles" class="icon-remove white" style="margin-right: 5px;cursor:pointer;">&nbsp;</a>';

            $caracteristicas = '<a class="icon-table detalle_fanc" style="cursor:pointer;" id="agregar_caracteristica_'.$correlativo_productos.'" href="#caracteristica_producto' . $id_art .'_'.$correlativo_productos. '"><span class="icon16 icomoon-icon-list-view-2"></span></a>';


            //$caracteristicaxde = $this->gsatelite->get_tabla('cxd_caracteristicaxdetalle_factura', array('cxd_id_def' => $def_id));
            $caracteristicaxde = $this->inventario_model->get_caracteristicas_det_factura(array('cxd_id_def' => $def_id));

            $caracteristicas_json = json_decode($this->obtener_factura_caracteristica($id_art, $caracteristicaxde, $id_formula, $correlativo_productos));

            $div_caracteristica = '<div id="caracteristica_producto' . $id_art .'_'.$correlativo_productos. '" style="display:none">
                <div class="box">
                    <div class="title">
                        <h4><span>características del producto</span></h4>
                    </div>
                    <div class="content">
                        <div class="form-row row-fluid">
                            <input type="hidden" value="' . $caracteristicas_json->tipo . '" name="tipo_caracteristica[]">
                            <div>
                                ' . $caracteristicas_json->tabla . '
                            </div>
                        </div>';

            if (trim($caracteristicas_json->select) != "") {
                $div_caracteristica .= '<div class="form-row row-fluid">
                            <label class="span3">Fórmulas:</label>
                            <div class="span5">
                                ' . $caracteristicas_json->select . '
                            </div>
                            <div class="span4">
                               <button type="button" class="btn btn-success aplicar_formula_btn" producto="' . $id_art . '" correlativo="'.$correlativo_productos.'">Aplicar fórmula</button>
                           </div>
                        </div>
                        <div class="form-row row-fluid">
                            <label class="span4 offset3">Resultado:</label>
                            <div class="span4">
                               <label id="resultado_formula_label' . $id_art .'_'.$correlativo_productos. '">' . $valor_formula . '</label>
                               <input type="hidden" name="resultado_formula_input' . $id_art .'_'.$correlativo_productos. '" id="resultado_formula_input' . $id_art .'_'.$correlativo_productos. '" value="' . $valor_formula . '">
                               <input type="hidden" name="resultado_formula_select' . $id_art .'_'.$correlativo_productos. '" id="resultado_formula_select' . $id_art .'_'.$correlativo_productos. '" value="' . $id_formula . '">
                            </div>
                        </div>';
            }
            $div_caracteristica .= '<div class="form-row row-fluid">
                            <div class="span12">
                                <div class="form-actions" style="text-align:center;">
                                   <button type="button" class="btn btn-success" onclick="javascript:$.fancybox.close();"><span class="icon16 icomoon-icon-checkmark white"></span>Guardar</button>
                                   <a onclick="javascript:$.fancybox.close();" class="btn btn-danger btn-close" id="btnCancelarSelect"><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>
                               </div>
                           </div>
                        </div>
                    </div>
                </div>';


            $text_codigo_producto = '<label id="text_codigo_' . $id_art .'_'.$correlativo_productos. '">' . $codigo . '</label>';
            $text_descripcion_producto = '<label id="text_descripcion_' . $id_art .'_'.$correlativo_productos. '">' . str_replace("\n", "<br>", $descripcion) . '</label>';
            $text_cantidad_producto = '<label id="text_cantidad_' . $id_art .'_'.$correlativo_productos. '">' . number_format($cantidad, 2) . '</label>';
            $text_precio_producto = '<label id="text_precio_' . $id_art .'_'.$correlativo_productos. '">$' . number_format($precio, 2) . '</label>';
            $text_impuesto = '<label id="text_impuesto_' . $id_art .'_'.$correlativo_productos. '">$' . number_format($impuesto, 2) . '</label>';
            $text_retencion = '<label id="text_retencion_' . $id_art .'_'.$correlativo_productos. '">$' . number_format($retencion, 2) . '</label>';
            $text_descuento = '<label id="text_descuento_' . $id_art .'_'.$correlativo_productos. '">$' . number_format($descuento, 2) . '</label>';
            $text_subtotal_factura = '<label id="text_subtotal_factura_' . $id_art .'_'.$correlativo_productos. '">$' . number_format($subtotal_factura, 2) . '</label>';

            $text_total_factura = '<label id="text_total_factura_' . $id_art .'_'.$correlativo_productos. '">$' . number_format($total_factura, 2) . '<font style="float:right;">' . $tipo_venta_text . '</font></label>';

            $descuento_porcentaje_factura += $descuento_por;

            $tabla_llenar .= '<tr id="filatabla_detalle' . $contador . '" >' .
                    '<td>' . $id_combo_agrupacion . $id_aplica . $id_id_producto . $id_medida_producto . $id_codigo_producto . $id_producto_correlativo . $text_codigo_producto . $input_precio_sugerido . '</td>' .
                    '<td>' . $id_descripcion_producto . $text_descripcion_producto . '</td>' .
                    '<td>' . $id_cantidad_producto . $text_cantidad_producto . '</td>' .
                    '<td>' . $id_precio_producto . $text_precio_producto . '</td>' .
                    '<td>' . $total_precio_cantidad . '</td>' .
                    '<td>' . $id_descuento_producto . $id_descuento_por_producto . $text_descuento . '</td>' .
                    '<td>' . $id_subtotal_producto . $text_subtotal_factura . '</td>' .
                    '<td>' . $id_impuesto_producto . $id_impuesto_por_producto . $id_impuesto_array . $id_impuesto_por_array . $text_impuesto . '</td>' .
                    '<td>' . $id_retencion_producto . $id_retencion_por_producto . $id_retencion_array . $id_retencion_por_array . $text_retencion . '</td>' .
                    '<td>' . $id_total_producto . $text_total_factura . $id_fecha_garantia . $id_fecha_garantia_text . $id_tipo_producto . $id_tipo_venta . '</td>' .
                    '<td align="center"><div>' . $editar . $eliminar . $caracteristicas . '</div>' . $div_caracteristica . '</td>' .
                    '</tr>';
            $contador++;
            $contador_productos++;
            $correlativo_productos++;
        }
        $porcentaje_factura_descuento = number_format(($descuento_porcentaje_factura / ($contador - 1)), 2);
        //$productos_id = substr($productos_id, 0, -1);
        $regresar = array("tabla" => $tabla_llenar, "descuento_factura" => $porcentaje_factura_descuento);
        return $regresar;
        //return $tabla_llenar;
        //echo json_encode(array('tabla'=>$tabla_llenar, 'contador'=>$contador, 'productos'=>$productos_id));
    }

    function obtener_productosxbodega() {
        ///$bod_id,$tia_id
        $tia_id = $this->input->post('categoria');
        //$bod_id = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
        $categoria_productos = $this->inventario_model->get_categoria_factura3("art_id");
        $categorias_array = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));
        $select = "<option value=''></option>";
        $productos[][] = "";
        $contador = 0;
        foreach ($categoria_productos as $key) {
            $padre = (trim($key["tia_padre"]) != "") ? $key["tia_padre"] : null;
            if ($padre == null) {
                $productos[$contador][0] = $key["art_id"];
                $productos[$contador][1] = $key["art_nombre"];
                $productos[$contador][2] = $key["tia_id"];
                $productos[$contador][3] = $key["art_venta"];
                $productos[$contador][4] = $key["art_inventario"];
                $productos[$contador][5] = $key["art_tipo"];
                $productos[$contador][6] = $key["bod_id"];
                $productos[$contador][7] = $key["art_codigo"];
                $productos[$contador][8] = $key["mod_id"];
                $productos[$contador][9] = $key["art_sinonimo"];
                $productos[$contador][10] = $key["cdp_codigo"];
            } else {
                $arreglo = $this->obtener_padre($key["tia_id"], $categorias_array);
                $productos[$contador][0] = $key["art_id"];
                $productos[$contador][1] = $key["art_nombre"];
                $productos[$contador][2] = $arreglo[1];
                $productos[$contador][3] = $key["art_venta"];
                $productos[$contador][4] = $key["art_inventario"];
                $productos[$contador][5] = $key["art_tipo"];
                $productos[$contador][6] = $key["bod_id"];
                $productos[$contador][7] = $key["art_codigo"];
                $productos[$contador][8] = $key["mod_id"];
                $productos[$contador][9] = $key["art_sinonimo"];
                $productos[$contador][10] = $key["cdp_codigo"];
            }
            $contador++;
        }
        $extra = '';
        foreach ($productos as $key) {
            $extra = ($key[10]!='') ? $key[10] : '';
            if ($key[9]!='') {
                $extra = ($extra!='') ? $extra.'/ '.$key[9] : $key[9];
            }
            $extra = ($extra!='') ? ' ('.$extra.')' : '';
            if ($tia_id == $key[2]) {
                $temp_codigo = $key[7];
                //$select .= '<option>'.$temp_codigo.'</option>';
                if ($temp_codigo != '') {
                    $select .= '<option value="' . $key[0] . '" venta="' . $key[3] . '" inven="' . $key[4] . '" tip="' . $key[5] . '" bod="' . $key[6] . '" niv="' . $key[8] . '">' . $temp_codigo . ' - ' . $key[1] . $extra . '</option>';
                } else {
                    $select .= '<option value="' . $key[0] . '" venta="' . $key[3] . '" inven="' . $key[4] . '" tip="' . $key[5] . '" bod="' . $key[6] . '" niv="' . $key[8] . '">' . $key[1] . $extra . '</option>';
                }
            }
        }
        echo json_encode(array('resp' => $select));
    }

    function obtener_detalle_producto() {
        $regresar = "";
        $cli_id = $this->input->post('cliente');
        $art_id = $this->input->post('producto');
        $def_id = $this->input->post('id_def');
        $descripcion_curso = '';
        $descripcion_curso_array = $this->facturacion_model->get_descripcion_curso(array('lxp_estado' => 1, 'alm_id_cli' => $cli_id, 'mod_id_art' => $art_id));
        // print_r($descripcion_curso_array);die();
        if(count($descripcion_curso_array) > 0){
            $descripcion_curso = (trim($descripcion_curso_array[0]['descripcion']) != '')?$descripcion_curso_array[0]['descripcion']:$descripcion_curso_array[0]['descripcion_grd'];
        }

        $tipo = $this->input->post('tipo');
        if ($tipo == 0) {
            $medida = $this->input->post('medida');
            $impuesto = $this->input->post('impuesto');
            $impuestos_array = explode(",", $impuesto);
            $retencion = $this->input->post('retencion');
            $retencion_array = explode(",", $retencion);
        }
        $bod_id = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
        $unidad_cva = $this->inventario_model->get_medida($art_id, 1);

        //$precio_producto = $this->costo_promedio_salida($art_id, $bod_id, null);
        $tip_producto_val = "";
        $tipo_producto = $this->gsatelite->get_campo('art_articulo', 'art_tipo', array('art_id'=>$art_id));
        //muestra la unidad de medida del producto y selecciona la del defecto, si se edita muestra la que se escogio de ultimo
        $select_medida = "<option value=''></option>";
        foreach ($unidad_cva as $key) {
            if ($tipo == 1) {
                if ($key["cva_defecto"] == 1) {
                    $select_medida .= "<option data-mep='" . $key["cva_id_mep"] . "' data-val='".$key['cva_conversion']."' value='" . $key["cva_id"] . "' selected data-defecto='" . $key["defecto"] . "'>" . $key["mep_nombre"] . "</option>";
                } else {
                    $select_medida .= "<option data-mep='" . $key["cva_id_mep"] . "' data-val='".$key['cva_conversion']."' value='" . $key["cva_id"] . "' data-defecto='" . $key["defecto"] . "'>" . $key["mep_nombre"] . "</option>";
                }
            } else {
                if ($medida == $key["cva_id"]) {
                    $select_medida .= "<option data-mep='" . $key["cva_id_mep"] . "' data-val='".$key['cva_conversion']."' value='" . $key["cva_id"] . "' selected data-defecto='" . $key["defecto"] . "'>" . $key["mep_nombre"] . "</option>";
                } else {
                    $select_medida .= "<option data-mep='" . $key["cva_id_mep"] . "' data-val='".$key['cva_conversion']."' value='" . $key["cva_id"] . "' data-defecto='" . $key["defecto"] . "'>" . $key["mep_nombre"] . "</option>";
                }
            }
        }

        //Muestra los tipos de lista asociados al cliente y al producto
        $id_tipl = 0;
        $tipos_lista = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $art_id, 'tpn_id_cli' => $cli_id));
        $is_list_dfc = array_sum(array_column($tipos_lista, 'tlp_defecto'));
        $exist_dfcto = ($is_list_dfc > 0) ? true : false;
        $select_tipo_lista = "<option value=''></option>";
        foreach ($tipos_lista as $key => $value) {
            if ($exist_dfcto) {
                if($value['tlp_defecto'] == 1){
                    $select_tipo_lista .= "<option data-mepx='".$value['lip_id_mep']."' data-tlp='" . $value["tlp_id"] . "' data-des_min='" . $value["lip_descuento_min"] ."' data-des_max='". $value["lip_descuento_max"] ."' value='" . $value["tlp_id"] . "' selected>" . $value["tlp_nombre"] . "</option>";
                    $id_tipl = $value["tlp_id"];
                }else{
                    $select_tipo_lista .= "<option data-mepx='".$value['lip_id_mep']."' data-tlp='" . $value["tlp_id"] . "' data-des_min='" . $value["lip_descuento_min"] ."' data-des_max='". $value["lip_descuento_max"] ."' value='" . $value["tlp_id"] . "'>" . $value["tlp_nombre"] . "</option>";
                }
            } else {
                if($key == 0){
                    $select_tipo_lista .= "<option data-mepx='".$value['lip_id_mep']."' data-tlp='" . $value["tlp_id"] . "' data-des_min='" . $value["lip_descuento_min"] ."' data-des_max='". $value["lip_descuento_max"] ."' value='" . $value["tlp_id"] . "' selected>" . $value["tlp_nombre"] . "</option>";
                    $id_tipl = $value["tlp_id"];
                }else{
                    $select_tipo_lista .= "<option data-mepx='".$value['lip_id_mep']."' data-tlp='" . $value["tlp_id"] . "' data-des_min='" . $value["lip_descuento_min"] ."' data-des_max='". $value["lip_descuento_max"] ."' value='" . $value["tlp_id"] . "'>" . $value["tlp_nombre"] . "</option>";
                }
            }
        }
        $id_tiplc = 0;
        $tipos_lista2 = $this->inventario_model->get_tipo_lista_precio(array('tpn_id_cli' => $cli_id));
        // print_r($this->db->last_query());
        $select_tipo_lista_cliente = "<option value=''></option>";
        foreach ($tipos_lista2 as $key => $value) {

            if($value['tlp_defecto'] == 1){
                $select_tipo_lista_cliente .= "<option data-tlp='" . $value["tlp_id"] . "' data-des_min='". $value["lip_descuento_min"] ."' data-des_max='". $value["lip_descuento_max"] ."' value='" . $value["tlp_id"] . "' selected>" . $value["tlp_nombre"] . "</option>";
                $id_tiplc = $value["tlp_id"];
            }else{
                $select_tipo_lista_cliente .= "<option data-tlp='" . $value["tlp_id"] . "' data-des_min='". $value["lip_descuento_min"] ."' data-des_max='". $value["lip_descuento_max"] ."' value='" . $value["tlp_id"] . "'>" . $value["tlp_nombre"] . "</option>";
            }
        }

        // var_dump($select_tipo_lista);
        // var_dump($select_tipo_lista_cliente);
        // die();
        //obtiene los detalles del producto seleccionado
        $detalles = $this->inventario_model->get_detalle_producto(array('cva_defecto' => 1, 'cva_estado' => 1, 'art_id' => $art_id));
        $articulos_array = array();
        $articulos_cantidades_array = array();
        $articulos_medida_array = array();
        foreach ($detalles as $key) {
            $id = $key["art_id"];
            $codigo = $key["art_codigo"];
            if ($codigo != '') {
                $nombre = $codigo . ' - ' . $key["art_nombre"];
            } else {
                $nombre = $key["art_nombre"];
            }
            $bodega = $key["art_id_bod"];
            $tip_producto_val = $key['art_tipo'];
            $agrupacion = $key["art_combo"];
            $descripcion = "";
            $descripcion2 = "";
            if ($agrupacion == 1) {
                $productos_agrupacion = $this->inventario_model->get_productos_combo(array('cma_id_art' => $art_id, 'cma_estado'=>1));
                foreach ($productos_agrupacion as $key2) {
                    $articulos_array[] = $key2['art_id'];
                    $articulos_cantidades_array[] = $key2['cma_cantidad'] * ($key2['cva_conversion']/$key2['conversion_defecto']);

                    $articulos_medida_array[] = $key2['cva_id'];
                    //$descripcion .= trim($key2["art_nombre"]) . ' x ' . $key2['cma_cantidad'] . "\n";
                    //$descripcion2 .= trim($key2["art_nombre"]) . ' x ' . $key2['cma_cantidad'] . '<br>';
                }
                /*$descripcion = substr($descripcion, 0, -1);
                $descripcion2 = substr($descripcion2, 0, -4);*/
                if(trim($key["art_descripcion"] != '')  ){
                    $descripcion = $key["art_descripcion"];
                    $descripcion2 .= $key["art_descripcion"];
                }else{
                    $descripcion = $key["art_nombre"];
                    $descripcion2 .= $key["art_nombre"];
                }
            } else {
                if(trim($key["art_descripcion"] != '')  ){
                    $descripcion = $key["art_descripcion"];
                    $descripcion2 .= $key["art_descripcion"];
                }else{
                    $descripcion = $key["art_nombre"];
                    $descripcion2 .= $key["art_nombre"];
                }
            }
        }

        //Carga los impuestos si es un nuevo producto y carga los impuestos seleccionados si se edita
        $select = "";
        $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1, 'IFNULL(imp_proceso_aplica,0) <>' => 2));
        $impuestos_clientes    = $this->gsatelite->get_tabla('ixc_impuestoxcliente',array('ixc_id_cli' => $cli_id));

                                   $this->db->join('tia_tipo_articulo','tia_id = ixr_id_tia');
                                   $this->db->join('art_articulo','art_id_tia = tia_id');
        $impuestos_tipo_articulo = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('art_id' => $art_id, 'ixr_estado' => 1));

        $id_impuestos = [];
        $imp_no_apply = [];

        foreach ($impuestos_clientes as $imp_cliente) {
            if ($imp_cliente['ixc_aplica'] > 0) {
                array_push($id_impuestos,$imp_cliente['ixc_id_imp']);
            }else{
                array_push($imp_no_apply, $imp_cliente['ixc_id_imp']);
            }
        }

        foreach ($impuestos_tipo_articulo as $imp_cliente) {
            if (!(in_array($imp_cliente['ixr_id_imp'], $id_impuestos)) && !(in_array($imp_cliente['ixr_id_imp'], $imp_no_apply))) {
                array_push($id_impuestos,$imp_cliente['ixr_id_imp']);
            }
        }

        foreach ($impuesto_campos as $key) {
            if ($tipo == 1) {
                if (!in_array($key['imp_id'], $imp_no_apply)) {
                    if (in_array($key['imp_id'], $id_impuestos)) {
                        $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
                    } else {
                        $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                    }
                }
            } else {
                if (in_array($key["imp_id"], $impuestos_array)) {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                }
            }
        }
        //print_r($id_impuestos);die();
        $impuesto_drop = $select;

        $select = "";
        $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $retencion_def = $this->gsatelite->get_tabla('rxf_retencionxdetalle_factura', array('rxf_id_def' => $def_id));

        $retenciones_ids = array_column($retencion_def, 'rxf_id_ret');
        //Si es gran contrinuyente traer las retenciones guardadas
        $es_gran = $this->gsatelite->get_campo('cli_cliente', 'cli_es_gran_contribuyente', array('cli_id' => $cli_id));
                                                    $this->db->join('ret_retencion', 'ret_id = rxc_id_ret');
        $retencion_cliente = (/*$es_gran*/ 1 == 1) ? $this->gsatelite->get_tabla('rxc_retencionxcliente', array('rxc_id_cli' => $cli_id, 'ret_valor_minimo' => 0)) : array();
        if (count($retencion_cliente) > 0) {
            foreach ($retencion_cliente as $key => $value) {
                array_push($retenciones_ids, $value['rxc_id_ret']);
            }
        }
        if (isset($retencion_array) && count($retencion_array) > 0) {
            if ($tipo == 0) {
                $retenciones_ids = array_merge($retenciones_ids, $retencion_array);
            }
        }
        foreach ($retencion_campos as $key) {
            if ($tipo == 1) {
                if (in_array($key["ret_id"], $retenciones_ids) && $key["ret_valor_minimo"] == 0) {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "'   ret_valor='" . $key["ret_valor"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "'   ret_valor='" . $key["ret_valor"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            } else {
                if (in_array($key["ret_id"], $retenciones_ids)) {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "'   ret_valor='" . $key["ret_valor"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "'   ret_valor='" . $key["ret_valor"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
        }
        $retencion_drop = $select;

        $select = "";
        $tpv_campos = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
        //$retencion_def = $this->gsatelite->get_tabla('rxf_retencionxdetalle_factura', array('rxf_id_def' => $def_id));

        $retenciones_ids = array_column($retencion_def, 'rxf_id_ret');
        foreach ($retencion_campos as $key) {
            if ($tipo == 1) {
                if ( in_array($key["ret_id"], $retenciones_ids)) {
                    $select .= "<option value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select .= "<optionvalue='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            } else {
                if (in_array($key["ret_id"], $retenciones_ids)) {
                    $select .= "<option value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select .= "<option value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
        }

        $tipo_ventas_drop = $select;
        $id_tipl = ($id_tipl > 0) ? $id_tipl : $id_tiplc;

        //Listado de precios
        $precios = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_tlp' => $id_tipl,'lip_id_art' => $art_id, 'lip_estado' => 1));

        $opciones = "<option></option>";
        $opciones_busqueda = "<option></option>";
        if (count($precios) > 0) {
            foreach ($precios as $lip) {
                $opciones .= "<option data-inicio='" . $lip['lip_desde'] . "' data-fin='" . $lip['lip_hasta'] . "' value='" . $lip['lip_id'] . "'>" . $lip['lip_precio'] . "</option>";
                $opciones_busqueda .= '<option data-inicio="'.$lip['lip_desde'].'" data-fin="'.$lip['lip_hasta'].'" data-mind="'.floatval($lip['lip_descuento_min']).'" data-maxd="'.floatval($lip['lip_descuento_max']).'" data-glbmind="'.floatval($lip['lip_descuento_min_autorizado']).'" data-gblmaxd="'.floatval($lip['lip_descuento_max_autorizado']).'" value="'.$lip['lip_id_mep'].'">'.$lip['lip_precio'].'</option>';
            }
        }

        $this->load->library('../controllers/inventario/gestion_productos');

        if(!($bodega > 0)){
            $user = $this->tank_auth->get_user_id();
            $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu'=>$user, 'uxb_defecto'=>1), $art_id);
            $bodega = (!empty($bodegas_reg))? $bodegas_reg[0]['uxb_id_bod'] : '';
        }
        $precio = 0;
        //print_r($bodega);die();
        if ($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 1 && $bodega != '') {
            //$precio = $this->gestion_productos->costo_promedio_salida($art_id, $bodega);
            $where = array('sar_id_art' => $art_id, 'sar_id_bod' => $bodega);
            $this->db->limit(1);
            $this->db->order_by('sar_id DESC');
            $precio = $this->gsatelite->get_tabla('sar_saldo_articulo', $where);
        }else{
            $max = $this->gsatelite->get_max('sar_saldo_articulo', 'sar_id', array('sar_id_art'=>$art_id, 'sar_id_bod'=>$bodega));/* QUITAR BODEGA????*/

            if($max > 0){
                $precio = $this->gsatelite->get_tabla('sar_saldo_articulo', array('sar_id'=>$max));
            }
        }
        //print_r($max); die();
        /* para registro academico*/
        //verificar si es curso con lxp estado 1 almidcli y mod id art
        //obtener flag de trd curso libre en 1, gfaid y gfacantidad
        //si es curso libre, ejecutar query de facturas realizadas en el dia actual> pasar dia de hoy y id_gfa
        //count >0 y mod de count con gfacantidad no es 0, entonces 15%
        //count >0 y mod de count con gfacantidad es 0, entonces 50%
        //en ambos casos establecer alerta "Se ha incluido el descuento de grupo familiar"
        //flag para el js llamado> gfa_descuento_curso_libre
        //en caso count es 0 o es otro tipo de producto, proceder normal y al flag pasarle 0 en determinado caso
        $obtener_info_curso = $this->registro_academico_model->get_informacion_alumno_curso(array('lxp_estado'=> 1, 'alm_id_cli'=> $cli_id, 'mod_id_art'=> $art_id));
        $aplica_descuento_gfa = 0;
        $descuento_grupo_familiar = 0;
        $mensaje_descuento_grupo_familiar = "";

        if(count($obtener_info_curso) > 0) {
            $flag_curso_libre = $obtener_info_curso[0]['trd_es_curso_libre'];
            $grupo_familiar = $obtener_info_curso[0]['gfa_id'];
            $alm_aplica_gfa = $obtener_info_curso[0]['alm_aplica_gfa']; 
            if(is_null($alm_aplica_gfa) || $alm_aplica_gfa == 0) {
                if(isset($flag_curso_libre) && $flag_curso_libre == 1 && isset($grupo_familiar)) {
                    $obtener_alumnos_gfa = $this->gsatelite->get_tabla('alm_alumno', array('alm_id_gfa' => $grupo_familiar));
                    $cantidad_alumnos_gfa = count($obtener_alumnos_gfa);
                    $cantidad_facturas_realizas_gfa_hoy = $this->facturacion_model->get_facturas_realizadas_grupo_familiar_hoy(array('DATE(fac_fecha_fact)' => date('Y-m-d'), 'alm_id_gfa' => $grupo_familiar, 'fac_estado >' => 0));
                    $count_facturas_gfa_hoy = $cantidad_facturas_realizas_gfa_hoy[0]['cantidad_facturas_realizadas_gfa_hoy'];
                    $monto_menor_actual = $this->registro_academico_model->get_registro_monto_menor(array('alm_id_gfa' => $grupo_familiar, 'trd_es_curso_libre' => 1, 'lxp_tipo_inscripcion' => 1));                    
                    if ($monto_menor_actual && $monto_menor_actual[0]['alm_id_cli'] == $cli_id && $monto_menor_actual[0]['mod_id_art'] == $art_id) {
                        $aplica_descuento_gfa = 1;
                        $descuento_grupo_familiar = 0.5;
                        $mensaje_descuento_grupo_familiar = "Se ha incluido el descuento del grupo familiar";
                    } else {
                        if ($count_facturas_gfa_hoy > 0) {
                            $aplica_descuento_gfa = 1;
                            $factura_actual = $count_facturas_gfa_hoy + 1;
                            $descuento_grupo_familiar = ($factura_actual % 2 == 0) ? 0.15: 0.5;
                            $mensaje_descuento_grupo_familiar = "Se ha incluido el descuento de grupo familiar";
                        } 
                    }
                }
            }
        }


        if ($tipo == 1) {
            $regresar = array(
                'select' => $select_medida,
                'id' => $id,
                'nombre' => $nombre,
                'bodega' => $bodega,
                'descripcion' => $descripcion,
                'descripcion2' => $descripcion2,
                'articulos_array'=> $articulos_array,
                'articulos_cantidades_array' => $articulos_cantidades_array,
                'articulos_medida_array' => $articulos_medida_array,
                'codigo' => $codigo,
                'impuesto' => $impuesto_drop,
                'retencion' => $retencion_drop,
                'agrupacion' => $agrupacion,
                'tipo_producto_val' => $tip_producto_val,
                //'precio_producto' => $precio_producto,
                'select_tipo_lista' => $select_tipo_lista,
                'rangos_precios' => $opciones_busqueda,
                'tipo_producto' => $tipo_producto,
                'descripcion_curso'=>$descripcion_curso,
                'select_tipo_lista_cliente'=>$select_tipo_lista_cliente,
                'precio'=> (isset($precio[0]['sar_precio']) && is_numeric($precio[0]['sar_precio'])) ? $precio[0]['sar_precio'] : 0.00,
                'valida_inv'=>$this->gsatelite->get_parametro_emp('SYS_FACTURA_SN_EXIST'),
                'aplica_descuento_gfa' => $aplica_descuento_gfa,
                'descuento_grupo_familiar' => $descuento_grupo_familiar,
                'mensaje_descuento_grupo_familiar' => $mensaje_descuento_grupo_familiar
            );
        } else {
            $regresar = array('select' => $select_medida,
                'id' => $id,
                'nombre' => $nombre,
                'bodega' => $bodega,
                'descripcion' => $descripcion,
                'descripcion2' => $descripcion2,
                'articulos_array'=> $articulos_array,
                'articulos_cantidades_array' => $articulos_cantidades_array,
                'articulos_medida_array' => $articulos_medida_array,
                'codigo' => $codigo,
                'impuesto' => $impuesto_drop,
                'retencion' => $retencion_drop,
                'agrupacion' => $agrupacion,
                'tipo_producto_val' => $tip_producto_val,
                //'precio_producto' => $precio_producto,
                'select_tipo_lista' => $select_tipo_lista,
                'rangos_precios' => $opciones_busqueda,
                'tipo_producto' => $tipo_producto,
                'descripcion_curso'=>$descripcion_curso,
                'select_tipo_lista_cliente'=>$select_tipo_lista_cliente,
                'precio'=> (isset($precio[0]['sar_precio']) && is_numeric($precio[0]['sar_precio'])) ? $precio[0]['sar_precio'] : 0.00,
                'valida_inv'=>$this->gsatelite->get_parametro_emp('SYS_FACTURA_SN_EXIST'),
                'aplica_descuento_gfa' => $aplica_descuento_gfa,
                'descuento_grupo_familiar' => $descuento_grupo_familiar,
                'mensaje_descuento_grupo_familiar' => $mensaje_descuento_grupo_familiar
            );
        }
        /*print_r($regresar['precio']);die();*/
        echo json_encode($regresar);
    }


    public function calcular_combos($art_id) {
        $productos_agrupacion = $this->inventario_model->get_productos_combo(array('cma_id_art' => $art_id));
        foreach ($productos_agrupacion as $key2) {
            $descripcion .= trim($key2["art_nombre"]) . ' x ' . $key2['cma_cantidad'] . "\n";
            $descripcion2 .= trim($key2["art_nombre"]) . ' x ' . $key2['cma_cantidad'] . '<br>';
        }
        print_r($productos_agrupacion);

        //recorremos
        /* $descripcion = substr($descripcion, 0, -1);
          $descripcion2 = substr($descripcion2, 0, -4); */
    }

    /**
     * @modify: Manuel Anzora
     * @descripcion: obtiene las caracteristicas de productos
     * @date: 05-12-2018
     */

    function obtener_caracteristica() {
        $id_art       = $this->input->post('producto');
        $correlativo  = $this->input->post('correlativo');
        $cotizacion   = $this->input->post('cotizacion');
        $to           = $this->input->post('to');

        $this->load->library('../controllers/inventario/agregar_articulos2');

        $caracteristicas = $this->inventario_model->get_caracteristica_factura(array('cxu_id_art' => $id_art, 'cxu_estado' => 1));
        //$formulas = $this->inventario_model->get_formulas();
        $sin_reg = '<tr><th colspan="2" style="text-align:center;">Sin Características</th></tr>';
        $tipo = 0;
        $tabla = '';
        $contador = 0;
        if (count($caracteristicas) > 0) {
            $tipo = 1;
            $tabla .= '<div class="form-row row-fluid">
                            <div class="span12">
                                <div class="span3">Característica</div>
            ';
            /*  Select de las caracteristicas del producto                          */
            $select_caracteristicas = '<select id="slcCaract_' . $id_art . '_'.$correlativo.'_1" class="slcCaract_chang" style="width: 80%;" correlativo="'.$correlativo.'" placeholder="seleccione" onchange="$(\'#slcCaract_' . $id_art . '_'.$correlativo.'_1'.'_error\').text(\'\')"><option value=""></option>';
            foreach ($caracteristicas as $key) {
                $select_caracteristicas .= '<option value="' . $key['car_id'] . '" data-cxr="' . $key['cxr_id'] . '" producto="' . $id_art . '" car_art="' . $key['cxu_id'] . '">' . $key['car_nombre'] . '</option>';
            }
            $select_caracteristicas .= '</select>';
            /*          Fin de el select de las caracteristicas del producto                */
            $tabla .= ' <div class="span5">' . $select_caracteristicas . '<div id="slcCaract_' . $id_art . '_'.$correlativo.'_1'.'_error" style="color:red;padding-top:2%;"></div></div>
                        </div>
                        <div class="span12" style="margin-top: 10px;">
                        <div class="span3">Valor</div>
                        <div class="span5" id="element_' . $id_art . '_'.$correlativo.'" style ="width: 32%;">
                            <input type="text" id="impCaract_' . $id_art . '_'.$correlativo.'" class="text" style="width: 80%" onchange="$(\'#impCaract_' . $id_art . '_'.$correlativo.'_error\').text(\'\')" >
                            <div id="impCaract_' . $id_art . '_'.$correlativo.'_error" style="color:red;margin-top:-3%;"></div>
                        </div>
                        <div class="span4">
                            <button type="button" class="btn btn-success agregar_caract_btn" producto="' . $id_art . '" style="margin-left: 5px;" correlativo="'.$correlativo.'" >Agregar</button>
                            <input id="caracTable_contador' . $id_art . '_'.$correlativo.'" value="'.count($caracteristicas).'" type="hidden">
                        </div>';


            $tabla .= '<div class="span12">
                        <table class="responsive table table-bordered" style="margin-top: 10px; font-size: 12px">
                            <thead>
                                <th>Nombre</th>
                                <th style="width:40% !important;">Valor</th>
                                <th style="width:20%">Acción</th>
                            </thead>
                            <tbody id="caracTable_' . $id_art . '_'.$correlativo.'">
                            ';

            /* ================================================================================================================
                                        CARGA LAS CARACTERISTICAS DE LA COTIZACION
            ================================================================================================================ */

            if($cotizacion != 0){
                $valor_caracteristica = $this->inventario_model->cargar_caracterisitca_cotizacion(array('axc_id_cot'=>$cotizacion));
                $cxu_columna_array    = array_column($valor_caracteristica, 'cxo_id_cxu');
                $valor_columna_array  = array_column($valor_caracteristica, 'cxo_valor');
                $precio_columna_array = array_column($valor_caracteristica, 'cxo_precio_valor');

            }
            $ocultar = false;
            foreach ($caracteristicas as $key) {
                $cxu_id     = $key['cxu_id'];
                $cxu_valor  = $key['cxu_valor'];
                $precio     =  $this->inventario_model->get_caracteristica_precio(array('cxr_id' => $key['cxr_id'],'vrl_valor' => $key['cxu_valor']));
                $cxu_precio = $precio->vrl_precio_valor;
                $id_impPrecio   = '<input type="hidden" class="valorBase" name="preciosValores_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" value="'.$cxu_precio.'" id="preciosValores_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" />';

                /**
                la variable $carac_no_aplica es una bandera utilizada para determinar si la caracteristica que pasa en el bucle esta almacenada en la cotizacion, si esta almacenada el valor de la bandera es 1, de lo contrario es 0
                **/
                $carac_no_aplica = 0;
                if($cotizacion != 0){
                    if(in_array($cxu_id, $cxu_columna_array)){
                        $carac_no_aplica = 1;
                        $indice     = array_search($cxu_id, $cxu_columna_array);
                        $cxu_valor  = $valor_columna_array[$indice];
                        $cxu_precio = $precio_columna_array[$indice];
                        $id_impPrecio = '';
                    }
                }


                $car_nombre_hid = '<input type="hidden" id="slcCaract_'.$key['cxr_id_car'].'_'.$correlativo.'" name="fam_nombre[]" value="'.$key['cxr_id_car'].'">';
                $nombre_carac2  = '<input type="hidden" id="nombre_empaquetado_'.$correlativo.'" value="'.$key['car_nombre'].'" name="nombre_empaquetado_'.$correlativo.'" class="nombre_empaquetado_'.$contador.'" >';
                $id             = '<input type="hidden" id="carac_empaquetado_'.$correlativo.'" value="'.$cxu_id.'" name="carac_empaquetado_'.$correlativo.'" class="carac_empaquetado_'.$contador.'" >';
                $id_impCaract   = '<input type="hidden" name="valorcaja_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" value="'.str_replace('"','”',$cxu_valor).'" id="valor_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" />';



                $id_impCaract2  = '';
                //si el valor de la caracteristica esta vacio
                $price = $cxu_precio;
                if(trim($cxu_valor) == ''){
                    $info_campos = $this->agregar_articulos2->get_tipocaracteristica($id_art, $key['cxr_id'], $contador, $correlativo);
                    $id_impCaract = $info_campos['tag'];
                    $id_impCaract2 = '<input type="hidden" name="valorcaja_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" value="" id="valor_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" />';

                     $id_impPrecio   = '<input type="hidden" name="preciosValores_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" value="'.$cxu_precio.'" id="preciosValores_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" />';
                     $ocultar = true;

                }


                $id_impCaract_car = '<input type="hidden" name="caracteristica_'.$id_art.'_'.$correlativo.'[]" value="'.$key['cxu_id'].'" />';
                $id_impCaract_val = '<input class="valor_empaquetado_'.$contador.'" type="hidden" name="valor_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" value="'.str_replace('"','”', $cxu_valor).'" id="valorreg_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'"  />';
                $id_impCaract_des = '<input type="hidden" name="descripcion_'.$id_art.'_'.$key['cxu_id'].'_'.$correlativo.'" value="'.$key['cxu_id'].'" value="'.str_replace('"','”', $cxu_valor).'"  />';



                $eliminar = '<a id="btn_aliinar_x'.$contador.'" class="btn btn-danger btn-mini minia-icon-trashcan white borrar_caract" valor="' . $contador . '_' . $correlativo . '" producto="'.$id_art.'" thead="caracTable_" tbody="bdcarat" correlativo="'.$correlativo.'" precioCara="'.$price.'"> Eliminar</a>';
                /**
                en la condicion evalua el valor de la bandera $carac_no_aplica, si el valor es 0, es porque la caracteristica no fue almacenada en los datos de la cotizacion
                **/
              /*  if ($cxu_precio != '') {
                     $id_impPrecio = '';
                }*/
                if($carac_no_aplica==0){
                    //caracterista no existe en la cotizacion
                    // la variable $to es un flag que imprime todos los controles al venir de agregar, en editar solo imprime los que estan guardados

                       if ($to == 'agregar') {
                           $tabla .= '<tr id="bdcarat'.$id_art.$contador.'_'.$correlativo.'">
                            <td>'.$car_nombre_hid.$key['car_nombre'].$nombre_carac2.$id.'</td>
                            <td>'.$id_impCaract.$id_impCaract2.$id_impCaract_car.$id_impCaract_val.$id_impCaract_des.$cxu_valor.$id_impPrecio.'</td>
                            <td>'.$eliminar.'</td>
                        </tr>';
                       }

                }else{
                    $tabla .= '<tr id="bdcarat'.$id_art.$contador.'_'.$correlativo.'">
                            <td>'.$car_nombre_hid.$key['car_nombre'].$nombre_carac2.$id.$id_impPrecio.'</td>
                            <td>'.$id_impCaract.$id_impCaract2.$id_impCaract_car.$id_impCaract_val.$id_impCaract_des.'<span style="font-weight: bold;color:#0167b1;">'.$cxu_valor.'</span></td>
                            <td>'.$eliminar.'</td>
                        </tr>';
                }

                $contador++;
            }

            //$tabla .= '<tr id="col_def' . $id_art . '"><td colspan="3" style="text-align: center;">Sin registros</td></tr>';

            $tabla .= '     </tbody>
                        </table>
            </div></div>';
        } else {
            $tabla = '<table width="100%" class="responsive table table-bordered" id="tabla_caracteristica_' . $id_art . '_'.$correlativo.'" style="font-size:14px;">
                        <thead>
                            ' . $sin_reg . '
                        </thead>
                        <tbody id="contenedor_caracteristica">
            ';
            $tabla .= '</tbody></table>';
        }

        $formulas_sele = $this->inventario_model->get_formulas(array('foa_id_art' => $id_art, 'foa_estado' => 1), 'foa_id');
        $formulas_gen = $this->inventario_model->get_formulas(array('foa_id_art' => $id_art, 'foa_estado' => 1));

        $select_formula = "";

        if (count($formulas_sele) > 0) {
            $tipo = 2;

            $select_formula = '<select id="select_formula_' . $id_art . '_'.$correlativo.'" name="formula_producto_select[]" class="nostyle cargar_valores_def" style="width:80%;" placeholder="Seleccione">';
            $select_formula .= '<option value=""></option>';
            foreach ($formulas_sele as $key) {
                $formulas = "";
                $contador = 0;
                foreach ($formulas_gen as $key2) {
                    if ($key2['foa_id'] == $key['foa_id']) {
                        $contador++;
                        $temp = $key2['foa_id'];
                        $formulas .= 'operando' . $contador . '=' . $key2['dxf_id_cxu'];
                        $formulas .= '$operador' . $contador . '=' . $key2['dxf_operador'] . '&';
                    }
                }
                $select = (count($formulas_sele) == 1)?'selected':'';
                $select_formula .= '<option value="' . $key['foa_id'] . '" afect_cantidad="' . $key['foa_afecta_cantidad'] . '" id="option_formula_' . $key['foa_id'] . '_' . $id_art . '_'.$correlativo.'" formula="' . $formulas . '" '.$select.'>' . $key['foa_nombre'] . '</option>';
            }
            $select_formula .= "</select>";
        }
        echo json_encode(array('tabla' => $tabla, 'select' => $select_formula, 'tipo' => $tipo));
    }

    function obtener_valores_defect_formula($formula = null) {

        //$formula = $this->input->post('formula');
        $formula = ($formula == null)?$this->input->post('formula'):$formula;
        $this->db->join('foa_formula_articulo', 'foa_id = dxf_id_foa');
        //$this->db->order_by('dxf_id_cxu', 'asc');
        $valores = $this->gsatelite->get_tabla('dxf_detallexformula', array('dxf_id_foa' => $formula));
        //print_r($valores);
        $id_caract_temp = "";
        $valores_dxf = array();
        $id_caract_dxf = array();
        $valores_formula = array();
        $prueba = '';
        foreach ($valores as $key) {
            //if ($id_caract_temp != $key['dxf_id_cxu']) {
            //if (trim($key['dxf_valor_defecto']) != '') {
            $valores_formula[] = array('art_id' => $valores[0]['foa_id_art'], 'caracteristicas' => $key['dxf_id_cxu'], 'valores' => $key['dxf_valor_defecto']);
            $id_caract_temp = $key['dxf_id_cxu'];
            $valores_dxf[] = $key['dxf_valor_defecto'];
            $id_caract_dxf[] = $key['dxf_id_cxu'];
            //}
            //}
        }
        echo json_encode(array('valores' => $valores_dxf, 'caracteristica' => $id_caract_dxf, 'producto' => $valores[0]['foa_id_art'], 'extra' => $valores_formula));
    }

    function obtener_factura_caracteristica($id_art, $caracteristicas_detalle, $id_formula, $correlativo) {
        $caracteristicas = $this->inventario_model->get_caracteristica_factura(array('cxu_id_art' => $id_art, 'cxu_estado' => 1));
        //$formulas = $this->inventario_model->get_formulas();

        $sin_reg = '<tr><th colspan="2" style="text-align:center;">Sin Características</th></tr>';

        $sin_reg = '<tr><th colspan="2" style="text-align:center;">Sin Características</th></tr>';
        $tipo = 0;
        $tabla = '';
        if (count($caracteristicas) > 0) {
            $tipo = 1;
            $tabla .= '<div class="form-row row-fluid"><div class="span12"><div class="span3">Característica</div>';
            /*          select de las caracteristicas del producto                          */
            $select_caracteristicas = '<select id="slcCaract_' . $id_art .'_'.$correlativo.'" class="slcCaract_chang nostyle" style="width: 80%;" correlativo="'.$correlativo.'" placeholder="seleccione" onchange="$(\'#slcCaract_' . $id_art .'_'.$correlativo. '_error\').text(\'\')"><option value=""></option>';
            foreach ($caracteristicas as $key) {
                $select_caracteristicas .= '<option value="' . $key['car_id'] . '" data-cxr="' . $key['cxr_id'] . '" producto="' . $id_art . '" car_art="' . $key['cxu_id'] . '">' . $key['car_nombre'] . '</option>';
            }
            $select_caracteristicas .= '</select>';
            /*          fin de el select de las caracteristicas del producto                */
            $tabla .= ' <div class="span5">' . $select_caracteristicas . '<div id="slcCaract_' . $id_art .'_'.$correlativo. '_error" style="color:red;padding-top:2%;"></div></div>
                        </div>
                        <div class="span12" style="margin-top: 10px;">
                        <div class="span3">Valor</div>
                        <div class="span5" id="element_' . $id_art .'_'.$correlativo. '" style ="width: 32%;">
                            <input type="text" id="impCaract_' . $id_art .'_'.$correlativo. '" class="text" style="width: 80%" onchange="$(\'#impCaract_' . $id_art . '_error\').text(\'\')" >
                            <div id="impCaract_' . $id_art .'_'.$correlativo. '_error" style="color:red;margin-top:-3%;"></div>
                        </div>
                        <div class="span4">
                            <button type="button" class="btn btn-success agregar_caract_btn" producto="' . $id_art . '" style="margin-left: 5px;" correlativo="'.$correlativo.'" >Agregar</button>
                            <input id="caracTable_contador' . $id_art .'_'.$correlativo. '" value="' . (count($caracteristicas_detalle) + 1) . '" type="hidden">
                        </div>';


            $tabla .= '<div class="span12">
                        <table class="responsive table table-bordered" style="margin-top: 10px; font-size: 12px">
                            <thead>
                                <th>Nombre</th>
                                <th>Valor</th>
                                <th style="width:20%">Acción</th>
                            </thead>
                            <tbody id="caracTable_' . $id_art .'_'.$correlativo. '">';
            $contador = 0;
            foreach ($caracteristicas_detalle as $key) {
                $contador++;
                $id_slcCaract = '<input type="hidden" id="slcCaract_' . $key['cxr_id_car'] .'_'.$correlativo. '" name="fam_nombre[]" value="' . $key['cxr_id_car'] . '" />';

                $id_impCaract = '<input type="hidden" name="valorcaja_' . $id_art . '_' . $key['cxd_id_cxu'] .'_'.$correlativo. '" value="' . str_replace('"','”',$key['cxd_valor']) . '" id="valor_' . $id_art . '_' . $key['cxd_id_cxu'] .'_'.$correlativo. '" />';

                $id_impPrecios = '<input type="hidden" name="preciosValores_' . $id_art . '_' . $key[''] .'_'.$correlativo. '" value="' . str_replace('"','”',$key['cxd_valor']) . '" id="preciosValores_' . $id_art . '_' . $key['cxd_id_cxu'] .'_'.$correlativo. '" />';

                $id_impCaract_car = '<input type="hidden" name="caracteristica_' . $id_art .'_'.$correlativo. '[]" value="' . $key['cxd_id_cxu'] . '" />';
                $id_impCaract_val = '<input type="hidden" name="valor_' . $id_art . '_' . $key['cxd_id_cxu'] .'_'.$correlativo. '" value="' . str_replace('"','”',$key['cxd_valor']) . '" id="valorreg_' . $id_art . '_' . $key['cxd_id_cxu'] .'_'.$correlativo. '"  />';
                $id_impCaract_des = '<input type="hidden" name="descripcion_' . $id_art . '_' . $key['cxd_id_cxu'] .'_'.$correlativo. '" value="' . $key['cxd_id_cxu'] . '" value="' . $key['cxd_id_cxu'] . '"  />';

                $eliminar = '<a class="btn btn-danger btn-mini minia-icon-trashcan white borrar_caract" valor="' . $contador .'_'.$correlativo. '" producto="' . $id_art . '" thead="caracTable_" tbody="bdcarat" correlativo="'.$correlativo.'"> Eliminar</a>';

                $tabla .= '<tr id="bdcarat' . $id_art . $contador .'_'.$correlativo. '" >';
                $tabla .= '<td>' . $id_slcCaract . $key['car_nombre'] . $id_impPrecios.'</td>';
                $tabla .= '<td>' . $id_impCaract . $id_impCaract_car . $id_impCaract_val . $id_impCaract_des . str_replace('"','”',$key['cxd_valor']) . '</td>';
                $tabla .= '<td>' . $eliminar . '</td>';
                $tabla .= '</tr>';
            }
            /* <tr id="col_def' . $id_art . '"><td colspan="3" style="text-align: center;">Sin registros</td></tr> */
            $tabla .= '</tbody></table></div></div>';
        } else {
            $tabla = '<table width="100%" class="responsive table table-bordered" id="tabla_caracteristica_' . $id_art . '" style="font-size:14px;">
                        <thead>
                            ' . $sin_reg . '
                        </thead>
                        <tbody id="contenedor_caracteristica">
            ';
            $tabla .= '</tbody></table>';
        }


        $formulas_sele = $this->inventario_model->get_formulas(array('foa_id_art' => $id_art, 'foa_estado' => 1), 'foa_id');
        $formulas_gen = $this->inventario_model->get_formulas(array('foa_id_art' => $id_art, 'foa_estado' => 1));

        $select_formula = "";

        if (count($formulas_sele) > 0) {
            $tipo = 2;

            $select_formula = '<select id="select_formula_' . $id_art .'_'.$correlativo. '" name="formula_producto_select[]" class="nostyle cargar_valores_def" style="width:80%;" placeholder="Seleccione">';
            $select_formula .= '<option value=""></option>';
            foreach ($formulas_sele as $key) {
                $formulas = "";
                $contador = 0;
                foreach ($formulas_gen as $key2) {
                    if ($key2['foa_id'] == $key['foa_id']) {
                        $contador++;
                        $temp = $key2['foa_id'];
                        $formulas .= 'operando' . $contador . '=' . $key2['dxf_id_cxu'];
                        $formulas .= '$operador' . $contador . '=' . $key2['dxf_operador'] . '&';
                    }
                }
                if ($key['foa_id'] == $id_formula) {
                    $select_formula .= '<option value="' . $key['foa_id'] . '" afect_cantidad="' . $key['foa_afecta_cantidad'] . '" id="option_formula_' . $key['foa_id'] . '_' . $id_art .'_'.$correlativo.'" formula="' . $formulas . '" selected>' . $key['foa_nombre'] . '</option>';
                } else {
                    $select_formula .= '<option value="' . $key['foa_id'] . '" afect_cantidad="' . $key['foa_afecta_cantidad'] . '" id="option_formula_' . $key['foa_id'] . '_' . $id_art .'_'.$correlativo. '" formula="' . $formulas . '">' . $key['foa_nombre'] . '</option>';
                }
            }
            $select_formula .= "</select>";
        }
        return json_encode(array('tabla' => $tabla, 'select' => $select_formula, 'tipo' => $tipo));
    }

    function obtener_anticipo() {
        $cli_id = $this->input->post('cliente');
        $anticipos_reg = $this->gsatelite->get_tabla('anl_anticipo_cliente', array('anl_estado' => 1, 'anl_id_cli' => $cli_id));

        //$caracteristicas = $this->inventario_model->get_caracteristica_factura(array('cxu_id_art'=>$id_art, 'cxu_estado'=>1));
        //$formulas = $this->inventario_model->get_formulas();

        $sin_reg = '<tr><th style="text-align:center;">Sin Anticipos</th></tr>';
        $tipo = 0;
        if (count($anticipos_reg) > 0) {
            $tipo = 1;
            $sin_reg = '<tr >
                            <th>
                                Fecha
                            </th>
                            <th>
                                Monto
                            </th>
                            <th>
                                Saldo
                            </th>
                            <th>
                                Concepto
                            </th>
                            <th>
                            </th>
                        </tr>';
        }

        $tabla = '<table width="100%" class="responsive table table-bordered" id="tabla_anticipo_' . $cli_id . '" style="font-size:14px;">
                    <thead>
                        ' . $sin_reg . '
                    </thead>
                    <tbody id="contenedor_anticipo">
        ';

        foreach ($anticipos_reg as $key) {
            $tabla .= '<tr>';
            $tabla .= '<td>' . date('Y-m-d', strtotime($key['anl_fecha'])) . '</td>';
            $tabla .= '<td>' . $key['anl_monto'] . '</td>';
            $tabla .= '<td>' . $key['anl_saldo'] . '</td>';
            $tabla .= '<td>' . $key['anl_descripcion'] . '</td>';
            $tabla .= '<td>
                            <input type="checkbox" name="anticipo_clien[]" value="' . $key['anl_id'] . '" monto="' . $key['anl_saldo'] . '" class="anticipos_clien" >
                            <input type="hidden" name="anticipo_saldo_' . $key['anl_id'] . '" value="' . $key['anl_saldo'] . '">
                        </td>';
        }
        $tabla .= '</tbody></table>';

        echo json_encode(array('tabla' => $tabla));
    }

    function obtener_resultado_formula() {
        $formula = $this->input->post('formula');
        $value = eval("return ($formula);");
        echo json_encode(array('resultado' => number_format((float) $value, 2, '.', '')));
    }

    function generar_numero_factura($inicio = null, $fin = null, $correlativo_id = null, $tipo_factura_id = null, $verificar = null, $return = null) {
        $ajax = 0;
        $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2); // FACT ELECT
        if ($inicio == null) {
            $inicio = $this->input->post('inicio');
            $fin = $this->input->post('fin');
            $correlativo_id = $this->input->post('correlativo');
            $tipo_factura_id = $this->input->post('tipo_factura');
            $verificar = $this->input->post('tipo');
            $ajax = ($this->input->post('ajax')!='')?$this->input->post('ajax'):0;
            $verificar = ($ajax == 1) ? 0 : $this->input->post('tipo');
        }
        $wherenum = array('fac_numero >=' => $inicio, 'fac_id_cof' => $correlativo_id, 'fac_id_tif' => $tipo_factura_id);
        $wherecie = array('fac_numero >=' => $inicio, 'fac_id_cof' => $correlativo_id, 'fac_id_tif' => $tipo_factura_id);
        if ($tipo_facturacion != 1) {
            $wherenum['fac_numero <='] = $fin;
            $wherecie['fac_numero <='] = $fin;
        }
        $numeros = $this->facturacion_model->get_numeros_facturas($wherenum);//SELECT FROM fac_factura WHERE $wherenum ORDER BY fac_numero DESC LIMIT 1
        $n_cierre = $this->facturacion_model->get_numeros_facturas2($wherecie, "fac_id as facturas"); //SELECT fac_id FROM fac_factura WHERE $wherecie ORDER BY fac_numero DESC
        if($tipo_facturacion != 1 && (($fin - $inicio) - count($n_cierre)) < 0){//EN CASO DE FACT ELECT. SE QUEDARA VIVO SIEMPRE
            $where_update_correlativo = array('cxj_inicio' => $inicio, 'cxj_fin' => $fin, 'cxj_id_cof' => $correlativo_id);
            $this->gsatelite->actualizar_array('cxj_correlativoxcaja', array('cxj_estado' => 0), $where_update_correlativo);
        }
        //se cambio a limit 1 DESC
        $edit = ($tipo_facturacion != 1) ? $this->gsatelite->get_campo('tif_tipo_factura','tif_edit_correlativo', array('tif_id'=>$tipo_factura_id)) : 0;
        $numero = $inicio;
        $numero_factura = array();
        $numero_temp = (count($numeros) > 0) ? ($numeros[0]['fac_numero'] + 1) : $inicio;
        if($numero_temp <= $fin && $tipo_facturacion != 1){
            if ($verificar == 0) {
                $numero = $numero_temp;
            } else{
                $valor = $this->input->post('valor');
                $existe = $this->gsatelite->get_tabla('fac_factura', array('fac_numero >=' => $inicio, 'fac_numero <=' => $fin, 'fac_id_cof' => $correlativo_id, 'fac_id_tif' => $tipo_factura_id, 'fac_numero'=>$valor) );
                if (count($existe) > 0) {
                    $numero = 0;
                } else {
                    $numero = 1;
                }
            }
        }
        if ($fin < 0 && $tipo_facturacion == 1) {
            if ($verificar > 0) {
                $valor = $this->input->post('valor');
                $existe = $this->gsatelite->get_tabla('fac_factura', array('fac_numero >=' => $inicio, 'fac_id_cof' => $correlativo_id, 'fac_id_tif' => $tipo_factura_id, 'fac_numero'=>$valor));
                if (count($existe) > 0) {
                    $numero = 0;
                } else {
                    $numero = 1;
                }
            } else {
                $numero = $numero_temp;
            }            
        }
        /* TEMPORAL PARA N DE REMI*/
        if ($tipo_facturacion == 1 && $fin > 0) {
            if ($verificar > 0) {
                $valor = $this->input->post('valor');
                $existe = $this->gsatelite->get_tabla('fac_factura', array('fac_numero >=' => $inicio, 'fac_id_cof' => $correlativo_id, 'fac_id_tif' => $tipo_factura_id, 'fac_numero'=>$valor));
                if (count($existe) > 0) {
                    $numero = 0;
                } else {
                    $numero = 1;
                }
            } else {
                $numero = $numero_temp;
            }            
        }
        // if (count($numeros) > 0) {
        //     $numero = 0;
        //     foreach ($numeros as $key) {
        //         $numero_factura[] = $key['fac_numero'];
        //     }
        //     if ($verificar == 0) {
        //         for ($x = $inicio; $x <= $fin; $x++) {
        //             if (!in_array($x, $numero_factura)) {
        //                 $numero = $x;
        //                 break;
        //             }
        //         }
        //     } else {
        //         $valor = $this->input->post('valor');
        //         if (in_array($valor, $numero_factura)) {
        //             $numero = 0;
        //         } else {
        //             $numero = 1;
        //         }
        //     }
        // }
        if ($return) {
            return json_encode(array('resultado' => $numero, 'factura_cant' => count($n_cierre), 'factura_rest' => ($fin - (count($n_cierre) + $inicio - 1))));
        } else {
            if($ajax != 0){
                $where_extra['cof_id'] = $correlativo_id;
                $where_inject = "cof_id = $correlativo_id AND $numero BETWEEN cxj_inicio AND cxj_fin";
                $query_datos_extra = $this->facturacion_model->get_datos_serie_factura($where_inject);
                $datos_extra['iva_dl'] = "I.V.A. D.L.# 296"; //variable para ticket .net
                $datos_extra['numero_resol'] = ($query_datos_extra)? $query_datos_extra[0]['sef_resolucion']:''; //variable para ticket .net
                $datos_extra['fecha_resol'] = ($query_datos_extra)? $query_datos_extra[0]['sef_fecha_resolucion']:''; //variable para ticket .net
                $datos_extra['rango_inicio'] = ($query_datos_extra)? $query_datos_extra[0]['cxj_inicio']:''; //variable para ticket .net
                $datos_extra['rango_fin'] = ($query_datos_extra)? $query_datos_extra[0]['cxj_fin']:''; //variable para ticket .net

                echo "jsonPHP".preg_replace("/\xEF\xBB\xBF/", "", json_encode(array('resultado' => $numero, 'factura_cant' => count($n_cierre), 'factura_rest' => ($fin - (count($n_cierre) + $inicio - 1)), 'edit'=>$edit, 'datos_extra'=>$datos_extra)));
            } else {
                $restantes = ($tipo_facturacion != 1) ? ($fin - (count($n_cierre) + $inicio - 1)) : 9; //SE COLOCA 5OLO PARA QUE SEA > 1
                echo json_encode(array('resultado' => $numero, 'factura_cant' => count($n_cierre), 'factura_rest' => $restantes, 'edit'=>$edit));
            }
        }
    }

    function guardar_factura() {
        // var_dump($_POST);die();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');
        //preguntar si aplica guardado como orden de venta.
        $guardar_como_orv = ($this->input->post('guardar_como_orv') > 0) ? 1 : 0;
        $tipo = ($this->input->post('usu_dir') != '') ? $this->input->post('usu_dir') : null;
        // Si aplica guardar como orden de venta invocar a la función independiente que hara ello. // Add by René Castaenda 01/06/2018 //
        if ($guardar_como_orv == 1) {
            $this->guardar_fact_ordVenta($tipo);
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Orden de Venta", 'texto_alerta' => "El registro se guardó correctamente.");
            $this->session->set_flashdata($alerta);
            if($tipo!=null){
                redirect('facturacion/facturar/crear_factura/0/1');
            }else{
                redirect('facturacion/facturar/crear_factura');
            }
            exit;
        }
        /********************************************************************************************************/
        $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2); // FACT ELECT
        /* SI ES FACTURACION MANUAL, Verificar si no se han agotado los correlativos */
        $corr         = $this->input->post('dtf_correlativo'); //////////////////////////////////////////////////////////////////////////// 109
        $cof          = $this->input->post('dtf_serie'); ////////////////////////////////////////////////////////////////////////////////// 84
        $tif          = $this->input->post('dtg_tipo_factura'); /////////////////////////////////////////////////////////////////////////// 1
        $inicio_fin   = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id' => $corr, 'cxj_estado' => 1));
        $recorrer_fac = $this->generar_numero_factura($inicio_fin[0]['cxj_inicio'], $inicio_fin[0]['cxj_fin'], $cof, $tif, 0, 1);
        $cxj_verificar  = json_decode($recorrer_fac, true);
        /* array(3) { ["resultado"]=> string(1) "1" ["factura_cant"]=> int(0) ["factura_rest"]=> int(-1) } */
        // var_dump($cxj_verificar);die();
        $facturas_restantes = $cxj_verificar['factura_rest']; ////////////////////////////////////////////////////////////////////////////// -1 JUST AFECT SI 1 o 0
        /********************* VERIFICA EXISTENCIA DE CORRELATIVO EN FACTURAS CREADAS ***************************/
        $dtf_factura = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null;
        $reg_numero = $this->gsatelite->get_registro('fac_factura', array('fac_numero'=>$dtf_factura));
        if(!empty($reg_numero)){
            $dtf_factura = $cxj_verificar['resultado'];
        }
        /********************************************************************************************************/
        //Tab datos generales
        $dtg_cliente = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null;
        /* Sucursal asociado al cajero asignado */
        $dtg_sucursal = (trim($this->input->post('emp_sucursal')) != "") ? $this->input->post('emp_sucursal') : null;
        $sucursal_cli = (trim($this->input->post('slcSucursalCliente')) != "") ? $this->input->post('slcSucursalCliente') : null;
        $dtg_nombre_factura    = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
        $dtg_documento_factura = (trim($this->input->post('dtg_documento_factura')) != "") ? $this->input->post('dtg_documento_factura') : null;
        $dtg_tipo_factura      = (trim($this->input->post('dtg_tipo_factura')) > 0) ? $this->input->post('dtg_tipo_factura') : null;
        $dtg_tipo_pago  = (trim($this->input->post('dtg_tipo_pago')) > 0) ? $this->input->post('dtg_tipo_pago') : null;
        $dtg_forma_pago = (trim($this->input->post('dtg_forma_pago')) > 0) ? $this->input->post('dtg_forma_pago') : null;
        $dtg_cotizacion = (is_array($this->input->post('dtg_cotizacion')))?$this->input->post('dtg_cotizacion'):array();
        $dtg_orden = (trim($this->input->post('dtg_orden')) > 0) ? $this->input->post('dtg_orden') : null;
        $dtg_envio = (trim($this->input->post('dtg_envio')) != "") ? $this->input->post('dtg_envio') : null;
        $dtf_serie = (trim($this->input->post('dtf_serie')) > 0 ) ? $this->input->post('dtf_serie') : null;
        $dtf_correlativo  = (trim($this->input->post('dtf_correlativo')) != "") ? $this->input->post('dtf_correlativo') : null;
        $dtf_factura      = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null;
        $dtf_fecha_fact   = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s')) : null;
        $dtf_fecha_vence  = (trim($this->input->post('dtf_fech_vence')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_vence')))) : null;
        $dtf_fecha_conta  = (trim($this->input->post('dtf_fech_conta')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_conta')))) : null;
        $dtf_fech_entrega = (trim($this->input->post('dtf_fech_entrega')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_entrega')))) : null;
        $dtf_centro_costo = (trim($this->input->post('dtf_centro_costo')) != "") ? $this->input->post('dtf_centro_costo') : null;
        $dtf_area = (trim($this->input->post('dtf_area')) > 0) ? $this->input->post('dtf_area') : null;
        $vendedor = (trim($this->input->post('vendedor')) > 0) ? $this->input->post('vendedor') : null;
        $personal = (is_array($this->input->post('personal'))) ? $this->input->post('personal') : array();
        $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
        $slcProyecto   = ($this->input->post('slcProyecto') > 0) ? $this->input->post('slcProyecto') : null;
        $dtf_empresa   = ($this->input->post('dtf_empresa') != '') ? $this->input->post('dtf_empresa') : $this->tank_auth->get_empresa_id();
        $dtf_transporte  = ($this->input->post('dtf_transporte') != '') ? $this->input->post('dtf_transporte') : null;
        $dtf_forma_envio = ($this->input->post('dtf_forma_envio') != '') ? $this->input->post('dtf_forma_envio') : null;
        $dtf_incoterms   = ($this->input->post('dtf_incoterms') != '') ? $this->input->post('dtf_incoterms') : null;
        $slct_incoterms   = ($this->input->post('slc_incoterm') > 0) ? $this->input->post('slc_incoterm') : null;
        $fac_orden_compra = ($this->input->post('fac_orden_compra') != '') ? $this->input->post('fac_orden_compra') : null;
        $dtf_orden_compra = ($this->input->post('dtf_orden_compra') != '') ? $this->input->post('dtf_orden_compra') : null;
         //0/1 APLICA SOLO EN CASO DE DEVOLUCION DE FACTURA CASO CONTRARIO EN EL POST VIENE OTRO CHECKBOX "afecta_inv"
        $crear_mov_inv = $this->input->post('crear_mov_inventario');
        //Array costo de venta de producto por detalle
        $dtf_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? $this->input->post('costo_venta_por_producto') : null;
        $descuentoT_factura_total     = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
        $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
        $suma_factura_total  = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
        // $anticipo_factura_total  = (trim($this->input->post('anticipo_factura_total')) != "")?$this->input->post('anticipo_factura_total'):0; //18
        $subtotal_factura_total  = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0; //17
        $impuesto_factura_total  = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
        $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
        $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi') : 0;
        //Valores actuales en la base de datos para el axc
        $axc_cantidad_base = ($this->input->post('axc_can_base') != '') ? $this->input->post('axc_can_base') : null;
        $axc_cantidad_facturada_base = ($this->input->post('axc_can_facturada_base') != '') ? $this->input->post('axc_can_facturada_base') : null;
        $axc_cantidad_pendiente_base = ($this->input->post('axc_can_pendiente_base') != '') ? $this->input->post('axc_can_pendiente_base') : null;
        $anticipo_clien = $this->input->post('anticipo_clien');
        $fac_domicilio  = ($this->input->post('facDomicilio') == true) ? 1 : 0;
        // $fac_anticipo   = ($this->input->post('anticipo')== 'on')?1:0;
        $caja = $this->input->post('caja_usuario');
        $usuario  = ($this->input->post('dtf_usuario')!='')?$this->input->post('dtf_usuario'):$this->tank_auth->get_user_id();
        $nota_rem = ($this->input->post('slc_remision') != '') ? $this->input->post('slc_remision') : NULL;
        // Se guarda un temporal del total de la factura para poder ir restando en cada repetición y se usa para detener la actualización de registros
        $total_temporal   = $total_factura_total_origi;
        $total_temporal_2 = 0;  // Se usa para operar los anticipos
        $monto_actualizar = 0;
        $id_anticipo    = 0;
        $saldo_restante = 0;
        $fin_anticipo   = 0;
        $fin_anticipo_2 = 0;
        $monto_guardar  = 0;
        $productos_id_moi      = array();
        $produtos_cantidad_moi = array();
        $productos_medida_moi  = array();
        $producto_bodega_moi   = array();
        $alerta   = "";
        $tipo_art = array();
        $articulos_and_bodegas = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 0));
        foreach ($articulos_and_bodegas as $k => $vl) {
            $tipo_art[$vl['art_id']] = $vl['art_id_bod'];
        }
        //////////////////////////////////////////////////////////////
        $hora_maxima = strtotime('+6 second');
        $hora_minima = strtotime('-6 second');
        $fecha_f = trim($this->input->post('dtf_fech_fact'));
        $fecha_maxima_fact = ($fecha_f != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_maxima)) : null;
        $fecha_minima_fact = ($fecha_f != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_minima)) : null;
        /*
        *Agregado por Nelson Soriano
        *@since 2-02-2019
        *Descripcion: Preguntamos si la factura trae anticipos a aplicarse,registrarse o si viene null
        */
        if ($this->input->post('anticipo') == 'on') {
            $fac_anticipo = 1;
            $fac_monto_anticipo       = $total_factura_total;
            $fac_monto_saldo_anticipo = $total_factura_total;
            $fac_monto_usado_anticipo = 0;
        }else{
            $fac_anticipo                 = 0;
            $fac_monto_anticipo           = null;
            $fac_monto_saldo_anticipo     = null;
            $fac_monto_usado_anticipo     = null;
        }
        $array_facturas_id = null;
        $registrar_detalle_anticipo = null;
        if ($this->input->post('anticipo_valores_fac'))  {
            $fac_anticipo = 0;
            $registrar_detalle_anticipo = true;
            $trae_anticipos = $this->input->post('anticipo_valores_fac');
            $monto = 0;
            for ($i=0; $i < count($trae_anticipos); $i++) {
                $array_info     = explode(':::', $trae_anticipos[$i]);
                $id_factura     = $array_info[0];
                $monto_aplicar  = $array_info[1];
                $saldo          = $this->gsatelite->get_campo('fac_factura','fac_monto_saldo_anticipo',array('fac_id'=>$id_factura));
                if ($saldo >= $monto_aplicar) {
                    $nuevo_saldo  = $saldo - $monto_aplicar;
                    $usado        = $monto_aplicar;
                    $this->gsatelite->actualizar_array('fac_factura', array('fac_monto_saldo_anticipo'=>$nuevo_saldo,'fac_monto_usado_anticipo'=>$usado), array('fac_id'=>$id_factura));
                    $estado = ($nuevo_saldo == 0)?2:1;
                    $monto       += $monto_aplicar;
                    $array_facturas_id[$i] = array('factura'=>$id_factura,'utilizado'=>$usado,'saldo'=>$nuevo_saldo,'estado'=>$estado);
                }
            }
            $fac_monto_anticipo       = null;
            $fac_monto_saldo_anticipo = null;
            $fac_monto_usado_anticipo = null;
        }
        if ($this->input->post('pagar_rapido_fact') > 0) {
            $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
            $dtg_tipo_pago = ($tpg_contado > 0) ? $tpg_contado : $dtg_tipo_pago;        
        }
        $factura_where = array(
            'fac_id_cli' => $dtg_cliente,
            'fac_id_cof' => $dtf_serie,
            'fac_id_tpg' => $dtg_tipo_pago,
            'fac_id_uxc' => $caja,
            'fac_fecha_fact >= ' => $fecha_minima_fact, 'fac_fecha_fact <=' => $fecha_maxima_fact,
            'fac_fecha_cont' => $dtf_fecha_conta,
            'fac_fecha_crea >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_crea <=' => date('Y-m-d H:i:s',$hora_maxima),
            'fac_usu_crea' =>  $usuario,
            'fac_usu_mod' =>  $usuario,
            'fac_fecha_mod >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_mod <=' => date('Y-m-d H:i:s',$hora_maxima)
        );
        $factura_repetida = $this->gsatelite->get_tabla('fac_factura', $factura_where);
        if(count($factura_repetida) > 0){
            $fac_id = $factura_repetida[0]['fac_id'];
            $dtf_factura = $factura_repetida[0]['fac_numero'];
            $alerta = array('tipo_alerta' => 'warning', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro ya se había guardado correctamente, con el número: ".$dtf_factura);
            $this->session->set_flashdata($alerta);
            redirect('facturacion/facturar/crear_factura');
        } else{
            if($facturas_restantes == 1 || $facturas_restantes == 0){ //EN FACT ELECT NO DEBERIA ENTRAR AHI, SIEMPRE DEBERA SER NEGATIVO
                $actualizar_cxj = array(
                    'cxj_estado' => 0,
                    'cxj_usu_mod' =>  $usuario,
                    'cxj_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cxj_correlativoxcaja', $actualizar_cxj, array('cxj_id'=>$corr) );
            }
            //Se guarda la factura
            if ($dtg_cliente != "" && $dtf_correlativo != "" && $dtf_factura != "" && $dtf_fecha_fact != "" && $dtf_fecha_conta != "" && $dtf_fecha_vence != "") {
                $id_dup_fac_devolucion = ($this->input->post('id_dup_fac_devolucion')>0)? $this->input->post('id_dup_fac_devolucion'):0;
                // Verificar que la accion viene del boton pagar
                $pagar_rapido_fact     = ($this->input->post('pagar_rapido_fact')>0)? $this->input->post('pagar_rapido_fact'):0;
                // Obtener los valores de Recibe y cambio para procesar el pago
                $txt_monto_recibido    = ($this->input->post('txt_monto_recibido_')>0)? $this->input->post('txt_monto_recibido_'):0;
                $txt_monto_devolver    = ($this->input->post('txt_monto_devolver_')>0)? $this->input->post('txt_monto_devolver_'):0;
                $factura = array(
                    'fac_id_cli' => $dtg_cliente,
                    'fac_id_ven' => $vendedor,
                    'fac_id_cof' => $dtf_serie,
                    'fac_id_suc' => $dtg_sucursal,
                    'fac_id_tpg' => $dtg_tipo_pago,
                    'fac_id_frp' => $dtg_forma_pago,
                    'fac_id_tif' => $dtg_tipo_factura,
                    'fac_id_arf' => $dtf_area,
                    'fac_id_cec' => $dtf_centro_costo,
                    'fac_id_ord' => $dtg_orden,
                    'fac_id_uxc' => $caja,
                    'fac_id_scl' => $sucursal_cli,
                    'fac_id_pcl' => $slcProyecto,
                    'fac_id_frv' => $dtf_forma_envio,
                    'fac_id_ttr' => $dtf_transporte,
                    'fac_incoterm' => $dtf_transporte,
                    'fac_numero' => $dtf_factura,
                    'fac_fecha_fact' => $dtf_fecha_fact,
                    'fac_fecha_cont' => $dtf_fecha_conta,
                    'fac_fecha_entrega' => $dtf_fech_entrega,
                    'fac_documento_cliente' => $dtg_documento_factura,
                    'fac_nombre_factura' => $dtg_nombre_factura,
                    'fac_observacion' => $observaciones,
                    'fac_retencion_abono' => 0,
                    'fac_tipo_facturacion' => 0, //SI ES ELECTRONICA LUEGO SE ACTUALIZA A 1
                    'fac_total_retencion' => str_replace(',', '', $retencion_factura_total),
                    'fac_subtotal' => str_replace(',', '', $subtotal_factura_total),
                    'fac_descuento' => str_replace(',', '', $descuentoT_factura_total),
                    'fac_impuesto' => str_replace(',', '', $impuesto_factura_total),
                    'fac_total' => str_replace(',', '', $total_factura_total),
                    'fac_monto_pendiente' => str_replace(',', '', $total_factura_total),
                    'fac_id_inr' => $slct_incoterms,
                    'fac_incoterm' => $dtf_incoterms,
                    'fac_orden_compra' => $dtf_orden_compra,
                    'fac_monto_abono' => 0,
                    'fac_dui_cliente_factura' => $this->input->post('info_complementaria_dui'),
                    'fac_nit_cliente_factura' => $this->input->post('info_complementaria_nit'),
                    'fac_residencia_cliente_factura' => $this->input->post('info_complementaria_residencia'),
                    'fac_fecha_crea' => date('Y-m-d H:i:s'),
                    'fac_usu_crea' =>  $usuario,
                    'fac_usu_mod' =>  $usuario,
                    'fac_fecha_mod' => date('Y-m-d H:i:s'),
                    'fac_estado' => 1,
                    'fac_aplica_domicilio'=>$fac_domicilio,
                    'fac_fecha_vencimiento' => $dtf_fecha_vence,
                    'fac_monto_anticipo' => $fac_monto_anticipo,
                    'fac_monto_saldo_anticipo' => $fac_monto_saldo_anticipo,
                    'fac_monto_usado_anticipo' => $fac_monto_usado_anticipo,
                    'fac_id_emr' => $dtf_empresa
                );
                $mov_fac_dev = array();
                if ($id_dup_fac_devolucion > 0) {
                    $factura['fac_id_origen_devolucion'] = $id_dup_fac_devolucion;
                    $factura['fac_estado'] =  2; //marcar pagada
                    $factura['fac_monto_pendiente'] =  0;
                    $factura['fac_fecha_pagada'] =  $dtf_fecha_fact;
                        //preguntar si se tiene procesado un movimiento en inventario
                    $mov_fac_dev = $this->facturacion_model->get_detalle_movimiento_devolucion($id_dup_fac_devolucion);
                }
                $fac_id = $this->gsatelite->ingresar('fac_factura', $factura);
                $cotizacion_guardar = array();
                foreach ($dtg_cotizacion as $key => $value) {
                    $cotizacion_guardar[] = array(
                        'czf_id_fac' => $fac_id,
                        'czf_id_cot' => $value,
                        'czf_estado' => 1,
                        'czf_usu_creacion' =>  $usuario,
                        'czf_fecha_creacion' => date('Y-m-d H:i:s'),
                        'czf_usu_modificacion' =>  $usuario,
                        'czf_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                }
                if(count($cotizacion_guardar) > 0){
                    $this->gsatelite->ingresar('czf_cotizacionxfacturacion', $cotizacion_guardar, true);
                }
                //NOTAS DE REMISION NO FACTURADAS, YA NO HAY ARTICULOS PENDIENTES (YA SE LOS LLEVO EN 1 O VARIAS NOTAS DE REMISION), SOLO FALTABA EL PAGO
                if ($nota_rem != null) {
                    $suma_ctdad = array_sum($this->input->post('cantidad_factura'));
                    for ($i=0; $i < count($nota_rem); $i++) {
                        $ctdad_remision = $this->gsatelite->get_suma('def_detalle_fact', 'def_cantidad', array('def_estado' => 1, 'def_id_fac' => $nota_rem[$i]));
                        $facxremision = array(
                            'fxr_id_fac' => $fac_id,
                            'fxr_id_fac_remision' => $nota_rem[$i],
                            'fxr_total_unidades_padre' => $suma_ctdad,
                            'fxr_total_unidades_pendientes' => 0,
                            'fxr_total_unidades_entregadas' => $ctdad_remision,
                            'fxr_estado' => 1,
                            'fxr_usu_creacion' =>  $usuario,
                            'fxr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'fxr_usu_modificacion' =>  $usuario,
                            'fxr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_fxr = $this->gsatelite->ingresar('fxr_factura_remisionxfactura', $facxremision);
                        if($id_fxr > 0) {
                            $montos = $this->facturacion_model->get_monto_nota_remision(array("fac_id" => $nota_rem[$i]));
                            $datos = array('fac_estado' => 2, 'fac_monto_pendiente' => 0, 'fac_monto_abono' => $montos[0]['fac_total']);
                            $this->gsatelite->actualizar_array('fac_factura', $datos, array('fac_id' => $nota_rem[$i]));
                        }
                    }
                }
                if (($id_dup_fac_devolucion  > 0 || $pagar_rapido_fact > 0) AND $fac_id > 0) {
                    // Proceso de devolucion
                    if ($id_dup_fac_devolucion  > 0) {
                        ////Actualizar mMonto pendiente de la fatcura original y realizar el registro del pago
                        $reg_devolucion = $this->gsatelite->get_registro('fac_factura', 'fac_id', $id_dup_fac_devolucion);
                        $stado_orig = $reg_devolucion->fac_estado;
                        $retenc_org = $reg_devolucion->fac_total_retencion;
                        $abondo_org = $reg_devolucion->fac_monto_abono;
                        $pdte_orign = number_format($reg_devolucion->fac_monto_pendiente, 2, '.', '');
                        $valor_devl = number_format($total_factura_total, 2, '.', '');
                        $valor_devl = ($valor_devl < 0) ? ($valor_devl * -1) : $valor_devl;
                        $nuevo_pdte = (($pdte_orign - $valor_devl) < 0) ? 0 : ($pdte_orign - $valor_devl);
                        $nuevo_stdo = ($stado_orig == 2 || (!($retenc_org > 0 || $nuevo_pdte > 0))) ? 2 : 1;
                        $actu_orign = array(
                            'fac_fecha_devolucion' => date('Y-m-d H:i:s'),
                            'fac_monto_pendiente' => $nuevo_pdte,
                            'fac_monto_abono' => ($abondo_org + $valor_devl),
                            'fac_estado' => $nuevo_stdo,
                            'fac_usu_mod' => $this->tank_auth->get_user_id(),
                            'fac_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('fac_factura', $actu_orign, array('fac_id' => $id_dup_fac_devolucion));
                    }
                    // Tabla en abc
                    $array_abono = array(
                        'abc_id_cli' => $dtg_cliente,
                        'abc_id_tif' => $dtg_tipo_factura,
                        'abc_fecha' => $dtf_fecha_fact,
                        'abc_monto' => str_replace(',', '', $total_factura_total),
                        'abc_total_abonar' => str_replace(',', '', $total_factura_total),
                        'abc_comprobante' => (isset($reg_devolucion->fac_numero))?$reg_devolucion->fac_numero:0,
                        'abc_estado' => 1,
                        'abc_usu_creacion' => $usuario,
                        'abc_fecha_creacion' => date('Y-m-d H:i:s'),
                        'abc_usu_modificacion' => $usuario,
                        'abc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $abc_id_abono = $this->gsatelite->ingresar('abc_abono_cliente', $array_abono);
                    //tabla en abf
                    $array_abono_factura = array(
                        'abf_id_fac' => $fac_id,
                        'abf_id_abc' => $abc_id_abono,
                        'abf_monto' => str_replace(',', '', $total_factura_total),
                        'abf_pendiente_factura' => 0,
                        'abf_monto_entregado' => $txt_monto_recibido,
                        'abf_monto_cambio' => $txt_monto_devolver,
                        'abf_usu_creacion' =>$usuario,
                        'abf_fecha_creacion' =>date('Y-m-d H:i:s'),
                        'abf_usu_modificacion' =>$usuario,
                        'abf_fecha_modificacion' =>date('Y-m-d H:i:s')
                    );
                    $abf_id_abono_fac = $this->gsatelite->ingresar('abf_abono_factura', $array_abono_factura);

                    // Cuando se desea pagar sin ir a la pantalla de pagos
                    if ($pagar_rapido_fact > 0 && $abf_id_abono_fac > 0 && $abc_id_abono > 0) {
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_estado' => 2, 'fac_monto_abono' => str_replace(',', '', $total_factura_total), 'fac_monto_pendiente' => 0.00), array('fac_id'=>$fac_id));
                            //Se agrega el detalle del Pago en caso de existir
                        if($dtg_forma_pago != null){
                            $dtg_banco = (trim($this->input->post('dtg_banco')) > 0) ? $this->input->post('dtg_banco') : null;
                            $dtg_nombre_referencia = (trim($this->input->post('dtg_nombre_referencia')) > 0) ? $this->input->post('dtg_nombre_referencia') : null;
                            $dtg_referencia = (trim($this->input->post('dtg_referencia')) > 0) ? $this->input->post('dtg_referencia') : null;
                            $detalle_dab = array(
                                'dab_id_ban' => $dtg_banco,
                                'dab_id_tra' => null,
                                'dab_id_frp' =>  $dtg_forma_pago,
                                'dab_id_tpg' => $dtg_tipo_pago,
                                'dab_id_abc' => $abc_id_abono,
                                'dab_fecha' => date('Y-m-d H:i:s'),
                                'dab_monto' =>  $txt_monto_recibido ,
                                'dab_nombre' => $dtg_nombre_referencia,
                                'dab_referencia' => $dtg_referencia,
                                'dab_estado' => 1,
                                'dab_usu_creacion' => $usuario,
                                'dab_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dab_usu_modificacion' => $usuario,
                                'dab_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('dab_detalle_abono', $detalle_dab);
                        }
                    }
                }
                $tif_excep = $this->gsatelite->get_campo('tif_tipo_factura','tif_tipo',array('tif_id'=>$dtg_tipo_factura));
                $caso_xcepcion = ($tif_excep != 2) ? false : true;
                if ($tipo_fact_elect == 1) {
                    if (!$caso_xcepcion) {
                        $datos =  $this->generar_datos_factura_electronica($fac_id);
                        $fact_elect = array(
                            'fac_tipo_facturacion' => 1, 
                            'fac_codigo_generacion' => $datos['cod_generation'],
                            'fac_numero_control' => $datos['num_control']
                        );
                        $this->gsatelite->actualizar_array("fac_factura", $fact_elect, array("fac_id" => $fac_id));
                    }
                }
                // orden de venta
                $slcOrdVnt = (trim($this->input->post('slcOrdVnt')) != "") ? $this->input->post('slcOrdVnt') : null;
                if($slcOrdVnt != null &&$slcOrdVnt != ''){
                    $orden_venta_array = array(
                        'orv_id_fac' => $fac_id,
                        'orv_estado' => 2,
                        'orv_usu_modificacion' => $usuario,
                        'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array("orv_orden_venta", $orden_venta_array, array("orv_id" => $slcOrdVnt));
                }
                //Se actualiza el estado de la cotizacion
                if (false && $dtg_cotizacion != '') {
                    $detalle_cotizacion = array('cot_estado' => 0);
                        //$this->gsatelite->actualizar_array("cot_cotizacion", $detalle_cotizacion, array("cot_id" => $dtg_cotizacion));
                }
                //Se guarda el personal de la factura
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                            //tabla pxf_personalxfactura
                        $detalle_personal = array(
                            'pxf_id_fac' => $fac_id,
                            'pxf_id_emp' => $personal[$x],
                            'pxf_estado' => 1,
                            'pxf_usu_creacion' => $usuario,
                            'pxf_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxf_usu_modificacion' => $usuario,
                            'pxf_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxf_personalxfactura', $detalle_personal);
                    }
                }
                // Columna codigo
                $cotizacion_id_fac   = $this->input->post('cotizacion_id'); //array
                $combo_agrupacion    = $this->input->post('combo_agrupacion');
                $aplica_descarga     = $this->input->post('aplica_descarga');
                $fecha_garantia      = $this->input->post('garantia_factura');
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');
                $tip_producto        = $this->input->post('tip_producto');
                $productos_factura   = $this->input->post('producto_factura');
                $correlativo         = $this->input->post('producto_correlativo');
                $medida_factura      = $this->input->post('medida_factura');
                $bodega_factura      = $this->input->post('bodega_producto'); //array
                $codigo_factura      = $this->input->post('codigo_factura'); //array
                $inscripcion_fac     = $this->input->post('inscripcion_factura'); //array inscripción (Si existe)
                // Columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura'); //array
                // Columna cantidad
                $cantidad_factura            = $this->input->post('cantidad_factura'); //array
                $cantidad_factura_convertida = $this->input->post('cantidad_factura_convertida'); //array
                $medida_defec_fac_convertida = $this->input->post('medida_ctdad_fact_convert'); //array
                $cantidad_inicial            = $this->input->post('cantidad_inicial'); //array
                // Columna precio
                $precio_factura = $this->input->post('precio_factura'); //array
                // Impuesto
                $impuesto_factura     = $this->input->post('impuesto_factura'); //array
                $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                $impuesto_array       = $this->input->post('impuesto_array'); //array
                $impuesto_por_array   = $this->input->post('impuesto_por_array'); //array
                // Retencion
                $retencion_factura       = $this->input->post('retencion_factura'); //array
                $retencion_por_factura   = $this->input->post('retencion_por_factura'); //array
                $retencion_array         = $this->input->post('retencion_array'); //array
                $retencion_por_array     = $this->input->post('retencion_por_array'); //array
                $retencion_por_array_val = $this->input->post('retencion_por_array_val'); //array subsidios con valor
                // Descuento
                $descuento_factura     = $this->input->post('descuento_factura'); //array
                $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                $autorizo_desc_x_list = $this->input->post('autorizo_desc_lista');//  ARRAY CON DESCUENTOS POR LISTA SI NO HAY VIENE VACIO
                $autorizo_desc_full_gnal = $this->input->post('usu_autoriza_desc_global'); //ID DE USER DESCUENTO, SI VIENE, MATA AL DE LISTA
                // Subtotal
                $subtotal_factura = $this->input->post('subtotal_factura'); //array
                // Total
                $total_factura = $this->input->post('total_factura'); //array
                $tipo_venta    = $this->input->post('tipo_venta'); //array
                //Arreglo con los id de los detalles de la cotizacion
                $axc_id_art_cotizacion = $this->input->post('axc_id_art_cotizacion'); //array
                //preguntamos por el porcentaje del impuesto
                $q_colum_impuesto = $this->gsatelite->get_tabla("imp_impuesto");
                $array_porcentaje = array_column($q_colum_impuesto, 'imp_porcentaje', 'imp_id');

                $cuotas_reg_acad = $this->input->post('cmc_actualizar'); 
                $pagado_reg_acad = $this->input->post('cmc_cuota_pago'); 
                $cuotas_mora_reg = $this->input->post('cmc_actualizar_mora'); 
                $dias_mora_reg_a = $this->input->post('cmc_dias_mora'); 
                $valor_x_mora_rg = $this->input->post('cmc_precio_mora');
                $pago_mora_reg_a = $this->input->post('cmc_monto_mora'); 

                //datos de caracteristica
                /*  Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                    se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                    el id del producto con el id de la caracteristica para guardar la relacion
                 */
                $bodegas_all = array_unique($bodega_factura);
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $tipo = $this->input->post('tipo_caracteristica');

                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;
                        $caracteristicas_id = $this->input->post('caracteristica_'.$productos_factura[$x].'_'.$correlativo[$x]);
                        //solo se usara la formula cuando el producto contenga alguna formula existente asociada a el
                        $formula = null;
                        $formula_id = null;
                        if ($tipo[$x] == 2) {
                            // la formula se obtiene con el codigo del producto, el input tiene la siguiente forma nombre_cada_+idproducto
                            $formula = (trim($this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                            $formula_id = (trim($this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                        }
                        //verificar si aplica descarga o si es una factura de devolución con movimiento.
                        if ((($aplica_descarga[$x] == 1 || count($mov_fac_dev) > 0) && $tip_producto[$x] == 0) || ($tip_producto[$x] == 1 && $combo_agrupacion[$x] == 1 && ($aplica_descarga[$x] == 1 || $aplica_descarga[$x] == 2))) {
                            if($combo_agrupacion[$x] == 1){
                                $combos_articulo_array = $this->input->post('combo_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $cantidad_temp_combo = $this->input->post('combo_cantidad_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $combos_medida_array = $this->input->post('combo_medida_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                for($k = 0; $k < count($combos_articulo_array); $k++){
                                    if (array_key_exists($combos_articulo_array[$k], $tipo_art)) {
                                        $combos_cantidad_array = (float)trim($cantidad_factura[$x]) * (float)trim($cantidad_temp_combo[$k]);
                                        $productos_id_moi[] = $combos_articulo_array[$k];
                                        $produtos_cantidad_moi[] = $combos_cantidad_array;
                                        $productos_medida_moi[] = $combos_medida_array[$k];
                                        $producto_bodega_moi[] = ($bodega_factura[$x] != "") ? $bodega_factura[$x] : $tipo_art[$combos_articulo_array[$k]];
                                    }
                                }
                            } else{
                                $productos_id_moi[] = $productos_factura[$x];
                                //cantidad_factura_convertida
                                $produtos_cantidad_moi[] = $cantidad_factura_convertida[$x];
                                $productos_medida_moi[] = $medida_defec_fac_convertida[$x];//$medida_factura[$x];
                                $producto_bodega_moi[] = $bodega_factura[$x];
                            }
                        }
                        $fecha_def = null;
                        if (trim($fecha_text_garantia[$x]) != '') {
                            $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                        }
                            //Se almacena la relacion de la caracteristica y la formula aplicada a esta si se aplico.
                            //tabla def_detalle_fact
                        $usu_aut_descuentos = ($autorizo_desc_x_list[$x] != "") ? $autorizo_desc_x_list[$x] : "";//SI VIENE EL USU AUTORIZADO DE LISTA SINO VACIO
                        $usu_aut_descuentos = ($autorizo_desc_full_gnal > 0) ? $autorizo_desc_full_gnal : $usu_aut_descuentos;//SI HAY UN GENERAL MATA AL DE LISTA
                        $detalle_factura = array(
                            'def_id_fac' => $fac_id,
                            'def_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                            'def_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                            'def_id_fao' => (trim($formula_id) != "") ? $formula_id : null,
                            'def_id_lip' => $idlip,
                            'def_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                            'def_id_bod' => (trim($bodega_factura[$x]) != "") ? $bodega_factura[$x] : null,
                            'def_id_axc' => (trim($axc_id_art_cotizacion[$x]) != "") ? $axc_id_art_cotizacion[$x] : null,
                            'def_valor_formula' => (trim($formula) != "") ? $formula : null,
                            'def_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                            'def_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                            'def_precio' => (trim($precio_factura[$x]) != "") ? $subtotal_factura[$x] / $cantidad_factura[$x]: null,
                            'def_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                            'def_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                            'def_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                            'def_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                            'def_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                            'def_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                            'def_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                            'def_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                            'def_fecha_vence_garantia' => $fecha_def,
                            'def_dias_garantia' => (trim($fecha_text_garantia[$x]) != "") ? $fecha_text_garantia[$x] : 0,
                            'def_precio_inventario' => ($dtf_costo_venta_por_producto[$x] != '') ? $dtf_costo_venta_por_producto[$x] : null,
                            'def_usu_autoriza_descuento' =>  ($usu_aut_descuentos != "") ? $usu_aut_descuentos : null,
                            'def_estado' => 1,
                            'def_usu_crea' => $usuario,
                            'def_fecha_crea' => date('Y-m-d H:i:s'),
                            'def_usu_mod' => $usuario,
                            'def_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $def_id = $this->gsatelite->ingresar('def_detalle_fact', $detalle_factura); 
                            // ingresamos el detalle de los anticipos ///
                        if (($registrar_detalle_anticipo == true) && (is_array($array_facturas_id)) ) {
                            $registros = count($array_facturas_id);
                            for ($i=0; $i < $registros ; $i++) {
                                $array_data = array(
                                    'dfa_id_def'                => $def_id,
                                    'dfa_id_fac'                => $array_facturas_id[$i]['factura'],
                                    'dfa_monto_utilizado'       => $array_facturas_id[$i]['utilizado'],
                                    'dfa_saldo'                 => $array_facturas_id[$i]['saldo'],
                                    'dfa_fecha'                 => date('Y-m-d H:i:s'),
                                    'dfa_estado'                => $array_facturas_id[$i]['estado'],
                                    'dfa_usu_crea'              => $usuario,
                                    'dfa_fecha_crea'            => date('Y-m-d H:i:s'),
                                    'dfa_fecha_mod'             => date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->ingresar('dfa_detalle_factura_anticipo',$array_data);
                            }
                        }
                            //Actualizar valores de axc_articuloxcotizacion(axc_cantidad_facturada, axc_cantidad_pendiente)
                            //En caso que sea una facturacion parcial por cotizacion
                        if(count($dtg_cotizacion) > 0){
                            //$axc_cant = (trim($cantidad_inicial[$x]) != "") ? $cantidad_inicial[$x] : 0;
                            $axc_cant_base      = (trim($axc_cantidad_base[$x]) != "") ? $axc_cantidad_base[$x] : 0;
                            $axc_cant_fac_base  = (trim($axc_cantidad_facturada_base[$x]) != "") ? $axc_cantidad_facturada_base[$x] : 0;
                            $axc_cant_pend_base = (trim($axc_cantidad_pendiente_base[$x]) != "") ? $axc_cantidad_pendiente_base[$x] : 0;
                            $axc_cant_fac       = (trim($cantidad_factura_convertida[$x]) != "") ? $cantidad_factura_convertida[$x] : 0;
                            $axc_pen            = $axc_cant_pend_base - $axc_cant_fac;
                                //Array con los datos para actualizar
                            $axc_articuloxcotizacion = array(
                                'axc_cantidad_facturada' => $axc_cant_fac + $axc_cant_fac_base,
                                'axc_cantidad_pendiente' => $axc_pen
                            );
                                //Se actualizan el valor facturado, el pendiente, y la cantidad adicional
                            $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $axc_articuloxcotizacion, array('axc_id'=>$axc_id_art_cotizacion[$x]));
                                //Valida si el total pendiente de facturar(de esta y las anteriores es 0 o menor por sobre giros)
                                //y dependiendo de eso se actualiza el estado: (1=pendiente, 2=parcial, 3=finalizado)
                            $cot_estado_facturacion = 1;
                            if($axc_pen <= 0){
                                $cot_estado_facturacion = 3;
                            }else{
                                $cot_estado_facturacion = 2;
                            }
                                //Actualizar el estado de la cotizacion
                            $array_cotizacion_estado_fac = array('cot_estado_facturacion' => $cot_estado_facturacion);
                            $this->gsatelite->actualizar_array('cot_cotizacion', $array_cotizacion_estado_fac, array('cot_id'=>$cotizacion_id_fac[$x]));
                        }
                        if($inscripcion_fac[$x] != '' && $inscripcion_fac[$x] > 0){
                            $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_tipo_inscripcion'=>2, 'lxp_id_fac'=>$fac_id, 'lxp_id_def'=>$def_id, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), array('lxp_id'=>$inscripcion_fac[$x]));
                        }
                            //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                        //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    $monto_temp = $subtotal_factura[$x] * ($array_porcentaje[$impuesto_ids[$k]] / 100);
                                        //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixf_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixf_id_def' => $def_id,
                                        'ixf_monto' => $monto_temp,
                                        'ixf_porcentaje' => $array_porcentaje[$impuesto_ids[$k]],
                                        'ixf_estado' => 1,
                                        'ixf_usu_mod' => $usuario,
                                        'ixf_fecha_mod' => date('Y-m-d H:i:s'),
                                        'ixf_fecha_crea' => date('Y-m-d H:i:s'),
                                        'ixf_usu_crea' => $usuario
                                    );
                                    $this->gsatelite->ingresar('ixf_impuestoxfactura', $detalle_impuesto);
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        $retencion_valor = explode(",", $retencion_por_array_val[$x]);
                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] > 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    if($retencion_por[$k]>0){
                                        $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    }else{
                                        $monto_temp = $retencion_valor[$k];
                                    }
                                        // Tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxf_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxf_id_def' => $def_id,
                                        'rxf_monto' => $monto_temp,
                                        'rxf_estado' => 1,
                                        'rxf_usu_creacion' => $usuario,
                                        'rxf_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'rxf_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxf_usu_modificacion' => $usuario
                                    );
                                    $this->gsatelite->ingresar('rxf_retencionxdetalle_factura', $detalle_retencion);
                                }
                            }
                        }
                        for ($y = 0; $y < count($caracteristicas_id); $y++) {
                            //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                            if ($tipo[$x] == 0) {
                            } else if ($tipo[$x] == 1) {
                                // Toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                                // La descripcion es el nombre de car_caracteristicas
                                $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                            } else if ($tipo[$x] == 2) {
                                // Toma los valores de las cajas escondidas despues de aplicar la formula se almacenan en estas, Si no se a seleccionado ninguna formula, entonces el valor de las cajas que se toma seria las visibles
                                if ($formula != "") {
                                    $caracteristicas_id_valor = $this->input->post('valor_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                                } else {
                                    $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                                }
                                    // La descripcion es el nombre de car_caracteristicas
                                $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]);
                            }
                            if ($tipo[$x] != 0) {
                                if (trim($caracteristicas_id_valor) != "") {
                                    //se guardara en la tabla cxd_caracteristicaxdetalle_factura
                                    $caracteristicas_factura = array(
                                        'cxd_id_def' => $def_id,
                                        'cxd_id_cxu' => (trim($caracteristicas_id[$y]) != "") ? $caracteristicas_id[$y] : null,
                                        'cxd_valor' => (trim($caracteristicas_id_valor) != "") ? $caracteristicas_id_valor : null,
                                        'cxd_descripcion' => (trim($caracteristicas_id_descripcion) != "") ? $caracteristicas_id_descripcion : null,
                                        'cxd_estado' => 1,
                                        'cxd_usu_creacion' => $usuario,
                                        'cxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'cxd_usu_modificacion' => $usuario,
                                        'cxd_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('cxd_caracteristicaxdetalle_factura', $caracteristicas_factura);
                                }
                            }
                        }
                            // Si se agotaron los correlativos, se actualiza la cxj en estado 0
                        if (isset($cxj_verificar) && $cxj_verificar['factura_rest'] == 1) {
                            $this->gsatelite->actualizar_array('cxj_correlativoxcaja', array('cxj_estado' => 0), array('cxj_id' => $this->input->post('dtf_correlativo')));
                        }
                        /* ================================ COMPONENTES ==========================================================*/
                        $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];
                        /* para descargar de bodega;    type array*/
                        $descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id'.$identificador);
                        /* detalle para guardar;        type array*/
                        $producto_componente = ($this->input->post('producto_componente'.$identificador) != '') ? $this->input->post('producto_componente'.$identificador) : '';
                        $medida_componente             = $this->input->post('medida_componente'.$identificador);
                        $cantidad_componente           = $this->input->post('cantidad_conv_componente'.$identificador);
                        $precio_componente             = $this->input->post('precio_componente'.$identificador);
                        $subtotal_componente           = $this->input->post('subtotal_componente'.$identificador);
                        $descripcion_componente        = $this->input->post('descripcion_componente'.$identificador);
                        $alternar_componente           = $this->input->post('alternar_componente'.$identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if($producto_componente != ''){
                            foreach ($producto_componente as $id_comp => $comp) {
                                if ($descargar_componente[$id_comp] == 1 && $tipo_componente[$id_comp] == 0) {
                                    $productos_id_moi[] = $comp;
                                    $produtos_cantidad_moi[] = $cantidad_componente[$id_comp];
                                    $productos_medida_moi[] = $medida_componente[$id_comp];
                                    $producto_bodega_moi[] = $bodega_componente;
                                }
                                $componente_sav[] = array(
                                    'cdf_id_def' => $def_id,
                                    'cdf_id_art' => $comp,
                                    'cdf_id_cva' => $medida_componente[$id_comp],
                                    'cdf_descripcion' => $descripcion_componente[$id_comp],
                                    'cdf_cantidad' => $cantidad_componente[$id_comp],
                                    'cdf_precio' => $precio_componente[$id_comp],
                                    'cdf_subtotal' => $subtotal_componente[$id_comp],
                                    'cdf_total' => $subtotal_componente[$id_comp],
                                    'cdf_altera_precio' => $alternar_componente[$id_comp],
                                    'cdf_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                    'cdf_estado' => 1,
                                    'cdf_usu_creacion' => $usuario,
                                    'cdf_fecha_creacion' =>  $fecha_creacion,
                                    'cdf_usu_modificacion' => $usuario,
                                    'cdf_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('cdf_componente_detalle_factura', $componente_sav, true);
                        }
                        /* ============================================================ CENTRO COSTO ======================================================================*/
                        $centro_costo_costo    = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                        $tipo_cuenta_costo     = $this->input->post('tipo_cuenta_costo'.$identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                        $porcentaje_costo      = $this->input->post('porcentaje_costo'.$identificador);
                        $subtotal_costo        = $this->input->post('subtotal_costo'.$identificador);
                        $pais_costo            = $this->input->post('pais'.$identificador);
                        $costo_sav = array();
                        if($centro_costo_costo != ''){
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcf_id_def' => $def_id,
                                    'dcf_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcf_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcf_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcf_id_pai' => ($pais_costo[$id_cost] != "")?$pais_costo[$id_cost]:null,
                                    'dcf_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcf_monto' => $subtotal_costo[$id_cost],
                                    'dcf_estado' => 1,
                                    'dcf_usu_creacion' => $usuario,
                                    'dcf_fecha_creacion' =>  $fecha_creacion,
                                    'dcf_usu_modificacion' => $usuario,
                                    'dcf_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcf_detalle_centrocostoxfactura', $costo_sav, true);
                        }

                        //CASO GFA
                        $descuento_gfa_aplicado = isset($_POST['descuento_gfa_aplicado'][$x]) ? (int)$_POST['descuento_gfa_aplicado'][$x] : 0;
                        if ($descuento_gfa_aplicado == 1 && $dtg_cliente > 0) {
                            // Reutilizar lógica de obtener_detalle_producto
                            $obtener_info_curso = $this->registro_academico_model->get_informacion_alumno_curso(array('lxp_estado' => 1, 'alm_id_cli' => $dtg_cliente, 'mod_id_art' => $idart));
                            if (count($obtener_info_curso) > 0) {
                                $flag_curso_libre = $obtener_info_curso[0]['trd_es_curso_libre'];
                                $grupo_familiar = $obtener_info_curso[0]['gfa_id'];
                                $alm_aplica_gfa = $obtener_info_curso[0]['alm_aplica_gfa'];
                                if (is_null($alm_aplica_gfa) || $alm_aplica_gfa == 0) {
                                    if (isset($flag_curso_libre) && $flag_curso_libre == 1 && isset($grupo_familiar) && $grupo_familiar > 0) {
                                        $obtener_alumnos_gfa = $this->gsatelite->get_tabla('alm_alumno', array('alm_id_gfa' => $grupo_familiar));
                                        $cantidad_alumnos_gfa = count($obtener_alumnos_gfa);

                                        $facturas_gfa_hoy = $this->facturacion_model->get_facturas_realizadas_grupo_familiar_hoy(array('DATE(fac_fecha_fact)' => date('Y-m-d'), 'alm_id_gfa' => $grupo_familiar, 'fac_estado >' => 0));
                                        $count_facturas_gfa_hoy = $facturas_gfa_hoy[0]['cantidad_facturas_realizadas_gfa_hoy'];
                                        $clientes_facturas = isset($facturas_gfa_hoy[0]['clientes_facturas']) ? explode(',', $facturas_gfa_hoy[0]['clientes_facturas']) : [];
                                        $factura_actual = $count_facturas_gfa_hoy; // + 1

                                        $clientes_a_actualizar = [];

                                        if ($count_facturas_gfa_hoy > 0) {

                                            if ($cantidad_alumnos_gfa == 2) {
                                                // 2 Miembros
                                                if ($factura_actual == 1 || $factura_actual == 2) {
                                                    $clientes_a_actualizar = array_column($obtener_alumnos_gfa, 'alm_id_cli');
                                                }
                                            } elseif ($cantidad_alumnos_gfa == 3) {
                                                // 3 Miembros
                                                if ($factura_actual == 1 || $factura_actual == 2 || $factura_actual == 3) {
                                                    $clientes_a_actualizar = array_column($obtener_alumnos_gfa, 'alm_id_cli');
                                                }
                                            } elseif ($cantidad_alumnos_gfa == 4) {
                                                // 4 Miembros
                                                if($factura_actual == 1) {
                                                    $clientes_a_actualizar = [$dtg_cliente];
                                                } elseif ($factura_actual == 2) {
                                                    $clientes_a_actualizar = array_unique(array_merge([$clientes_facturas[0], $dtg_cliente]));
                                                } elseif ($factura_actual == 3) {
                                                    $clientes_a_actualizar = array_column($obtener_alumnos_gfa, 'alm_id_cli');
                                                } elseif ($factura_actual == 4) {
                                                    $clientes_a_actualizar = array_unique(array_merge([$clientes_facturas[2], $dtg_cliente]));
                                                }
                                            } elseif ($cantidad_alumnos_gfa == 5) {
                                                // 5 Miembros
                                                if($factura_actual == 1) {
                                                    $clientes_a_actualizar = [$dtg_cliente];
                                                } elseif ($factura_actual == 2) {
                                                    $clientes_a_actualizar = array_unique(array_merge([$clientes_facturas[0], $dtg_cliente]));
                                                } elseif ($factura_actual == 3) {

                                                    $clientes_a_actualizar = array_unique(array_merge(array_slice($clientes_facturas, 0, 2), [$dtg_cliente]));
                                                } elseif ($factura_actual == 4) {

                                                    $clientes_a_actualizar = array_column($obtener_alumnos_gfa, 'alm_id_cli');
                                                } elseif ($factura_actual == 5) {
                                                    $clientes_a_actualizar = array_unique(array_merge([$clientes_facturas[3], $dtg_cliente]));
                                                }
                                            }

                                            if (!empty($clientes_a_actualizar)) {
                                                $update_alumno = array(
                                                    'alm_aplica_gfa' => 1,
                                                    'alm_usu_mod' => $usuario,
                                                    'alm_fecha_mod' => date('Y-m-d H:i:s')
                                                );
                                                //$condiciones = array('alm_id_cli' => array_unique($clientes_a_actualizar));
                                                //$this->gsatelite->actualizar_array('alm_alumno', $update_alumno, $condiciones);
                                                $this->db->where_in('alm_id_cli', array_unique($clientes_a_actualizar));
                                                $this->db->update('alm_alumno', $update_alumno);
                                                log_message('info', 'Cantidad de registros afectados: ' . $this->db->affected_rows());
                                                log_message('info', 'Consulta ejecutada (update alm_aplica_gfa = 1): ' . $this->db->last_query());
                                            }
                                        }
                                    }
                                }
                            }
                        }

                    }
                }//END for ($x = 0; $x < count($productos_factura); $x++) {
                /*************************** INSCRIPCIÓN DE ALUMNO (GRADO) *********************************************/
                $grado = ($this->input->post('inscripcion_grd_factura'))?$this->input->post('inscripcion_grd_factura'):null;
                if($grado != null && $grado[0] > 0){
                    $inscripcion = $this->generar_inscripcion_grado($dtg_cliente, $grado[0], $fac_id, $def_id);
                }
                if (is_array($cuotas_reg_acad) && count($cuotas_reg_acad) > 0) {
                    foreach ($cuotas_reg_acad as $k => $value) {
                        $update = array(
                            'cmc_id_fac' => $fac_id, 
                            'cmc_fecha_pago' => date('Y-m-d'),
                            'cmc_estado_cargo' => 2,
                            'cmc_total_cuota' => $pagado_reg_acad[$k],
                            'cmc_usu_modificacion' => $usuario,
                            'cmc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $update, array('cmc_id'=>$value));
                    }
                }
                if (is_array($cuotas_mora_reg) && count($cuotas_mora_reg) > 0) {
                    foreach ($cuotas_mora_reg as $k => $value) {
                        $update = array(
                            'cmc_id_fac' => $fac_id, 
                            'cmc_dias_mora' => $dias_mora_reg_a[$k],
                            'cmc_monto_mora' => $valor_x_mora_rg[$k],
                            'cmc_fecha_pago' => date('Y-m-d'),
                            'cmc_estado_cargo' => 2,
                            'cmc_total_cuota' => $pago_mora_reg_a[$k],
                            'cmc_usu_modificacion' => $usuario,
                            'cmc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $update, array('cmc_id'=>$value));
                    }
                }

// VALIDAR QUE SI ES UNA NOTA DE REM Y YA SALIO, QUE YA NO SALGA

// porque s lo hizo con otro tip


                //YA SE CONSULTO EL PARAMETRO EN LA VISTA, PARA CASOS EXCEPTO LA DEVOLUCION YA QUE PARA LA DEVOLUCION DE FACTURA SE MUESTRA EL OTRO SELECT
                $aplicar_descarga_inv = ($this->input->post('afecta_inv') != "") ? $this->input->post('afecta_inv') : $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
                $facturar_sin_existen = $this->gsatelite->get_parametro_emp('SYS_FACTURA_SN_EXIST'); //1= permite facturar sin existencia / 0= no permite
                if ($id_dup_fac_devolucion > 0) {
                    if ($crear_mov_inv > 0) {
                        $this->crear_movimiento_devolucion($fac_id, $producto_bodega_moi, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi, $bodegas_all);
                    }
                } elseif ($aplicar_descarga_inv > 0 && !($facturar_sin_existen > 0)) {
                    $this->crear_movimiento($fac_id, $producto_bodega_moi, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi, $bodegas_all);
                }
                /* ======================================================================================================
                                    Inicio Partida contable para facturacion afecta/no afecta inventario
                =========================================================================================================*/
                $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
                if($generar_partida > 0 && $id_dup_fac_devolucion <= 0){
                    $where['fac_id'] = $fac_id;
                    $info['num_fac'] = $dtf_factura;
                    $info['fac_fecha_conta'] = $dtf_fecha_conta;
                    $res_debe = $this->generar_partida_factura_afecta_noafecta_inv_debe($where,$info);
                    $this->generar_partida_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_haber']);
                    //Insertando los detalles
                    if(count($res_debe['array_detalle_partida']) > 0){
                        $this->gsatelite->ingresar('dpc_detalle_partida', $res_debe['array_detalle_partida'], true);
                    }
                    //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida: 1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                    $this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct' => $res_debe['id_pct'], 'fac_generacion_partida' => 1),array('fac_id' => $fac_id));
                    /* ======== Contrapartida en caso de tener productos que afecten inventario ======== */
                    $where_existe['fac_id'] = $fac_id;
                    $where_existe['art_inventario'] = 1;
                    $afecta_inv = $this->facturacion_model->existe_prod_afec_inv($where_existe);
                    if($afecta_inv[0]['afecta_inv'] && $generar_partida == 2){
                        $where['cec_id']  = ($dtf_centro_costo) ? $dtf_centro_costo : 0;
                        $res_debe = $this->generar_contra_partida_factura_afecta_afecta_inv_debe($where,$info);
                        $this->generar_contra_partida_factura_afecta_inv_haber($where, $res_debe['id_pct']);
                    }
                }
                /* ======================================================================================================
                                    Fin Partida contable para facturacion afecta/no afecta inventario
                =========================================================================================================*/
                /* SI ES FACTURA ELECTRONICA LLAMAR LA FUNCION QUE CREARA EL JSON*/
                if ($tipo_fact_elect == 1) {
                    if (!$caso_xcepcion) {
                        $this->crear_json_fact($fac_id);
                        $this->enviar_facturacion_sat($fac_id);
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente, con el número: ".$dtf_factura);
            } else {
                $alerta = array('tipo_alerta' => 'error','titulo_alerta' =>"Registro de factura",'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
        }
        /* REDIRECCIONES */
        $redireccion = $this->input->post('redireccionar');
        $this->session->set_flashdata('id_factura', $fac_id);
        $this->session->set_flashdata($alerta);
        $dir = $this->input->post('usu_dir');
        if($dir > 0){
            $direct = '/0/1';
            $dir_pago = '/1';
        }else{
            $direct = '';
            $dir_pago = '';
        }
        if ($redireccion == 0) {
            if (isset($id_dup_fac_devolucion) && $id_dup_fac_devolucion > 0) {
                redirect('facturacion/facturar/factura_devolucion/');
            }
            if($dir > 0){
                $this->session->set_flashdata($alerta);
                redirect('facturacion/facturar/crear_factura'.$direct);
            }else{
                $this->session->set_flashdata($alerta);
                redirect('facturacion/facturar/crear_factura/');
            }
        } else if ($redireccion == 1) {
            if($dir > 0){
                redirect('facturacion/facturar/factura_caja');
            }else{
                redirect('facturacion/facturar/factura/');
            }
        } else if ($redireccion == 3) {
            echo "jsonPHP".preg_replace("/\xEF\xBB\xBF/", "", json_encode(array('fac_id' => $fac_id), JSON_UNESCAPED_UNICODE  ));
        } else {
            redirect('facturacion/facturar/crear_pago_factura/' . $dtg_cliente . '/' . $fac_id.'/1'.$dir_pago);
        }
    }

    function crear_movimiento($fac_id, $bodega_bod, $producto_art, $cantidad_dee, $medida_cva, $bodegas_all, $tipo_proceso_fac="FACTURA") {
        $this->load->library('../controllers/inventario/gestion_productos');
        $tip_salida = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array("$tipo_proceso_fac"));
        $usuario = ($this->input->post('dtf_usuario')!='') ? $this->input->post('dtf_usuario') : $this->tank_auth->get_user_id();
        $tif_fac = $this->gsatelite->get_campo('fac_factura','fac_id_tif', array('fac_id' => $fac_id));
        $tif_nom = $this->gsatelite->get_campo('tif_tipo_factura','tif_abreviacion', array('tif_id' => $tif_fac));
        $fac_num = $this->gsatelite->get_campo('fac_factura', 'fac_numero', array('fac_id' => $fac_id));
        $doc_referencia = $tif_nom . $fac_num;
        $bodega_par = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
        foreach ($bodegas_all as $key => $bod_id) {
            $bod_id = ($bod_id != "") ? $bod_id : $bodega_par;
            if (trim($bod_id) != "" && trim($tip_salida) != "") {
                $respuesta = array(
                    'moi_id_tip' => $tip_salida,
                    'moi_id_bod' => $bod_id,
                    'moi_id_fac' => $fac_id,
                    'moi_documento'=> $doc_referencia,
                    'moi_fecha_mov' => date('Y-m-d H:i:s'),
                    'moi_estado' => 1,
                    'moi_usu_creacion' => $usuario,
                    'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'moi_usu_modificacion' => $usuario,
                    'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $respuesta); 
                for ($x = 0; $x < count($producto_art); $x++) {
                    if (trim($producto_art[$x]) != "" && trim($cantidad_dee[$x]) != ""){
                        if($bod_id == $bodega_bod[$x]){
                            $cantidades = $this->inventario_model->get_cantidad_bodega(null, $bod_id, null, $producto_art[$x]);
                            $this->gestion_productos->peps_salida($producto_art[$x], null, $moi_id, $medida_cva[$x], $cantidad_dee[$x], null, $cantidades[0]["cantidad"], $bod_id);
                        }
                    }
                }
                /** ********** Generar asiento contable Salida por factura ***************************** */
                $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
                $cliente = ($this->input->post('dtg_cliente')) ? $this->input->post('dtg_cliente') : '';
                if ($generar_partida > 0) {
                    $this->load->library('../controllers/inventario/gestion_productos');
                    $res_haber = $this->gestion_productos->generar_asiento_salida_inv_haber($moi_id);
                    $this->gestion_productos->generar_asiento_salida_inv_debe($cliente, $res_haber['id_pct'], $res_haber['total_debe']);
                    $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_haber['id_pct']), array('moi_id' => $moi_id));
                }
                /** ***********Fin generacion asiento contable salida por factura *********************** */
            }
        }
    }

    function crear_pago($cliente = null, $factura = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $datos["titulo_personal"] = "Pagos";

            /*
              Se cargan los datos de los clientes que tengan facturas, si viene de una factura, el cliente y la factura se filtran en la consulta
              para mostrar solo un registro del cliente que se le hizo la factura.
              si se viene de la grid de pagos, el cliente no se selecciona y no se muestra nada en la grid de las facturas, se tendria
              que seleccionar en la grid el cliente para mostrar todas sus facturas.
              si se modifica seleccionando un cliente especifico se cargan las facturas de dicho cliente seleccionado
             */
            $select = '';
            $disable_select_cliente = 0;
            $clientes_drop = $this->facturacion_model->get_datos_garantia(array('fac_monto_pendiente <>' => 0), 'fac_id_cli');
            foreach ($clientes_drop as $key) {
                if ($cliente == $key['cli_id']) {
                    $disable_select_cliente = 1;
                    $select .= '<option value="' . $key['cli_id'] . '" selected>' . $key['cli_nombre'] . ' ' . $key['cli_apellido'] . '</option>';
                } else {
                    $select .= '<option value="' . $key['cli_id'] . '">' . $key['cli_nombre'] . ' ' . $key['cli_apellido'] . '</option>';
                }
            }
            //desabilita el cliente para que no se pueda cambiar en caso que venga de una factura
            $datos['disable_cliente'] = $disable_select_cliente;
            $datos['clientes'] = $select;

            $factura_detalle = array();
            $anticipo_cliente = "";

            //de donde viene las facturas
            $tipo = 1;
            //si se selcciona el cliente y la factura, muestra solo el detalle de la factura seleccionada, si viene de la factura
            if ($cliente != null && $factura != null) {
                $tipo = 3;
                $factura_detalle = $this->facturacion_model->get_datos_pagos(array('cli_id' => $cliente, 'fac_id' => $factura, 'fac_estado' => 1));
            } else if ($cliente != null) {
                $tipo = 2;
                //si el cliente se selecciono anteriormente cargaria las facturas de dicho cliente
                $anticipo_cliente = $this->obtener_anticipo_editar($cliente);
                $factura_detalle = $this->facturacion_model->get_datos_pagos(array('cli_id' => $cliente, 'fac_estado' => 1));
            }

            $arreglo = $this->obtener_detalle_factura_seleccionada($factura_detalle);

            $datos['tipo_pago'] = $tipo;
            $datos['cliente'] = $cliente;
            $datos['factura'] = $factura;

            $datos['tabla_factura'] = $arreglo['tabla'];

            $datos['total_saldo'] = $arreglo['total_saldo'];
            $datos['total_monto'] = $arreglo['total_monto'];
            $datos['total_retencion'] = $arreglo['total_retencion'];

            $datos['anticipos_cliente'] = $anticipo_cliente;
            //$datos['factura_detalle'] = $factura_detalle;

            $tipo_pago_drop = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => 1), null, '', 'tpg_id', true);
            $datos['tipos_pago'] = str_replace('<option value="0">Seleccione</option>', '', $tipo_pago_drop);

            $banco_drop = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
            $datos['bancos'] = str_replace('<option value="0">Seleccione</option>', '', $banco_drop);

            $select = '';
            $gestor_cobros_drop = $this->facturacion_model->get_cobrador(array('cob_estado' => 1));
            foreach ($gestor_cobros_drop as $key) {
                $select = '<option value="' . $key['cob_id'] . '">' . $key['cob_codigo'] . ' - ' . trim(($key['cob_nombre'] . $key['cob_apellido'])) . '</option>';
            }
            $datos['cobrador'] = $select;

            $this->_cargarvista($datos, null);
        }
    }

     /**
    * @modify Manue Anzora - Grupo Satélite
    * @since 2018-11-29
    * Actualiza los campos de domicilio en una factura
    **/
    function factura($fecha_inicio = null, $fecha_fin = null, $tipo = null, $usu = null, $tpf = null, $est = null) {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '9999');
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $roles_usuario = $this->facturacion_model->get_roles_usuario($this->tank_auth->get_user_id());
            // $id_rol_caja = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $rol_admit = 0;
            foreach ($roles_usuario as $key => $value) {
                if($value == 1){
                    $rol_admit = 1;
                }
            }
            // Declaracion de variables
            $es_devolucion = 0;
            if ($tipo){
                $url_padre =  $_SERVER['HTTP_REFERER'];
            } else {
                $url_padre = uri_string();
            }
            if(substr_count($url_padre, 'factura_caja') > 0){
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura_caja');
            } elseif (substr_count($url_padre, 'factura_devolucion') > 0 ) {
                // Proceso para devolucion de factura
                $es_devolucion = 1;
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura_devolucion');
            }  else {
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura');
            }
            if($usu!=null) {
                $data['usu'] = $usu;
                $flag='/1';
            } else {
                $flag='/0';
            }
            if ($fecha_inicio == null && $fecha_fin == null) {
                $fecha_inicio = $this->input->post('txtFechaIni');
                $fecha_fin = $this->input->post('txtFechaFin');
            }
            $tipoFactura = ($tpf != null) ? $tpf : null;
            if ($this->input->post('tipo_fac') != "") {
                $tipoFactura = $this->input->post('tipo_fac');
            }
            $festado = ($est != null) ? $est : null;
            if (is_numeric($this->input->post('estado'))) {
                $festado = $this->input->post('estado'); 
            }
            $output = null;
            $crud = new grocery_CRUD();
            if (trim($fecha_inicio) != '') {
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $crud->where('DATE(fac_fecha_fact) >=', date('Y-m-d', strtotime($fecha_inicio)));
                    $crud->where('DATE(fac_fecha_fact) <=', date('Y-m-d H:i:s', strtotime($fecha_fin)));
                    //validar que si es la opción de fatura-caja solo muestre las del usuario logueado, si es la de facturar muestre todo.
                    if(/*$rol_admit != 1*/ substr_count($_SERVER['HTTP_REFERER'], 'factura_caja') > 0 ){
                        $crud->where('fac_usu_crea', $this->tank_auth->get_user_id());
                    }
                }
                if ($tipoFactura != '' && is_numeric($tipoFactura)) {
                    $crud->where('fac_id_tif', $tipoFactura);
                }
                if ($festado != ''){
                    if ($festado == 9) {
                        $festado = 0;
                    }
                    $crud->where('fac_estado', $festado);
                }
                if($usu!=null){
                    $usuarios = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id_usu'=>$usu));
                    if(count($usuarios) > 0){
                        $ids = array_column($usuarios, 'uxc_id');
                        $cadena = implode(',', $ids);
                        $crud->where('fac_id_uxc IN ('.$cadena.')', null, FALSE);
                    }
                }
                $tipoPagos = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_estado' => 1));
                if (count($tipoPagos) > 0) {
                    foreach ($tipoPagos as $f) {
                        $tpg_array[$f['tpg_id']] = $f['tpg_nombre'];
                    }
                } else {
                    $tpg_array = array('1' => 'Contado', '2' => 'Credito');
                }                

                // Verificar que no tiene devolucion
                // NO SE MOSTRARAN LAS NOTAS DE REMISION NI LAS NOTAS DE CREDITO EN LA GRID
                $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
                $not_cred = (isset($tipo_factura['NOTA CREDITO'])) ? $tipo_factura['NOTA CREDITO'] : 0;
                $not_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
                $excluidas = implode(',', array($not_cred, $not_remi));
                if ($es_devolucion > 0) {
                    $crud->where("fac_id_origen_devolucion IS NULL AND fac_fecha_devolucion IS NULL AND fac_id_tif NOT IN ($excluidas)", null, FALSE);
                } else {
                    $crud->where("fac_id_tif NOT IN ($excluidas)", null, FALSE);
                }
                // traemos solo las facturas que sean de este modulo en el tif_aplica_compra / tif_aplica_venta
                $display_as = array(
                    'fac_numero'            => 'Número',
                    'fac_id_cli'            => 'Cliente',
                    // 'pcl_codigo'        => 'Proyecto',
                    // 'fac_observacion'   => 'Observacion',// rosario
                    'fac_subtotal'          => 'SubTotal',
                    'fac_fecha_fact'        => 'Fecha',
                    'fac_monto_pendiente'   => 'Saldo pdte.',
                    'fac_total_retencion'   => 'Retencion',
                    'fac_impuesto'          => 'Impuesto',
                    'fac_total'             => 'Total',
                    'fac_id_tpg'            => 'Tipo Pago',
                    'fac_estado'            => 'Estado',
                    'fac_id_tif'            => 'Tipo factura'
                );
                $columns = array(
                    'fac_id_tif',
                    'fac_numero',
                    // 'fac_id_cof',
                    'fac_id_cli',
                    // 'pcl_codigo',
                    // 'fac_observacion', //rosario
                    'fac_fecha_fact',
                    'fac_subtotal',
                    'fac_total_retencion',
                    'fac_impuesto',
                    'fac_total',
                    'fac_monto_pendiente',
                    'fac_id_tpg',
                    'fac_estado'
                );
                $crud->set_subject('Factura');
                $crud->set_table('fac_factura');
                $crud->columns($columns);
                $crud->display_as($display_as);
                $crud->set_relation('fac_id_tif', 'tif_tipo_factura', 'tif_nombre');
                // $crud->callback_column('pcl_codigo', function($value, $row) {
                //     return $this->gsatelite->get_campo('pcl_proyecto_cliente', 'pcl_codigo', array('pcl_id' => $row->fac_id_pcl));
                // });
                // $crud->callback_column('fac_id_cof', function($value, $row) {
                //            $this->db->join('cof_correlativo_factura', 'cof_id_sef = sef_id');
                //     return $this->gsatelite->get_campo('sef_serie_factura', 'sef_nombre', array('sef_id_tif' => $row->fac_id_tif, 'cof_id' => $row->fac_id_cof));
                // });
                $crud->field_type('fac_estado', 'dropdown', array('2' => 'Pagado', '1' => 'Pendiente', '0' => 'Anulada'));
                $crud->field_type('fac_id_tpg', 'dropdown', $tpg_array);
                $crud->callback_column('fac_id_cli', function($value, $row) {
                    $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $row->fac_id_cli));
                    $regresar = '';
                    if ($clientes[0]['cli_personeria'] == 1) {
                        $regresar = /* $clientes[0]['cli_codigo'] .' '. */ $clientes[0]['cli_nombre'] . ' ' . $clientes[0]['cli_apellido'];
                    } else {
                        $regresar = /* $clientes[0]['cli_codigo'] .' '. */ $clientes[0]['cli_apellido'];
                    }
                    return $regresar;
                });
                $crud->callback_column('fac_fecha_fact', function($value, $row) {
                    $fecha = (trim($row->fac_fecha_fact) != "") ? formatear_fecha('Y-m-d', trim($row->fac_fecha_fact)) : "";
                    return $fecha;
                });
                $crud->callback_column('fac_total', function($value, $row) {
                    $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
                    $total = $smb . number_format(($row->fac_total - floatval($row->fac_total_retencion)), 2);
                    return $total;
                });
                $crud->callback_column('fac_subtotal', function($value, $row) {
                    $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
                    return $smb . number_format($row->fac_subtotal, 2);
                });
                $crud->callback_column('fac_total_retencion', function($value, $row) {
                    $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
                    return $smb . number_format($row->fac_total_retencion, 2);
                });
                $crud->callback_column('fac_impuesto', function($value, $row) {
                    $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
                    return $smb . number_format($row->fac_impuesto, 2);
                });
                $crud->callback_column('fac_monto_pendiente', function($value, $row) {
                    $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
                    return $smb . number_format($row->fac_monto_pendiente, 2);
                });
                //proceso para cambiar color de tr cuando la facturacion aplica domicilio
                $crud->callback_column('fac_numero',function($value, $row){
                    $domicilio = $row->fac_aplica_domicilio;
                    $entregado_domicilio = $row->fac_entregado_domicilio;
                    if($domicilio > 0 && $entregado_domicilio == 0){
                        return "<label class='color_tr' data-color='#4ac718'>".$value."</label>";
                    } else {
                        return $value;
                    }
                });
                //cargamos solo las facturas que sean del tipo venta
                $crud->where('tif_aplica_venta',1);
                $crud->unset_add();
                $crud->unset_edit();
                $crud->unset_delete();
                $crud->unset_read();
                // Proceder a solo mostrar la opcion de devolucion en la pantalla de factura cuando viene de la vista devolucon_factura
                if ($es_devolucion > 0) {
                    $crud->add_action('Procesar devolución', '', 'facturacion/facturar/duplicar_factura'.$flag.'/0', 'icomoon-icon-copy-2', null,'', "![fac_id_origen_devolucion] > 0 AND [fac_fecha_devolucion] == NULL");
                } else {
                    $ret_fac_paga = $this->gsatelite->get_parametro_emp('SYS_FACTURA_PAGADA_RETENCIONES', 0);
                    $permiso_pago = $this->gsatelite->get_permisos_opcion('facturacion/facturar/pagos_fac', null, null, true);
                    // Opciones por defecto para las pantalla de factura y factura_caja
                    $crud->add_action('Imprimir', '', 'facturacion/facturar/imprimir_factura', 'icomoon-icon-copy-2 imprimir');
                    if ($permiso_pago['permite_agregar']) {
                        $crud->add_action('Pago', '', 'facturacion/facturar/pagar_factura', 'icomoon-icon-coins', null,'', "[fac_estado] == 'Pendiente'");
                    }
                    $crud->add_action('Historial', '', 'historial', 'icomoon-icon-history mostrar_historial');
                    $crud->add_action('Garantia', '', 'facturacion/facturar/generar_garantia', 'icomoon-icon-checkbox-2 duplicar_garantia');
                    $crud->add_action('Editar', '', 'facturacion/facturar/editar_factura', 'icomoon-icon-copy-2 editar', null,'', "[fac_estado] == 'Pendiente' or ![fac_estado] == 'Pagado'");
                    if ($ret_fac_paga > 0) {
                        $crud->add_action('Comp. Retención', '', 'aplicar_comprobante_retencion', 'iconic-icon-document-stroke modal_ret_pdte', null,'', "[fac_estado] == 'Pagado' AND [fac_monto_pendiente] > 0 AND [fac_total_retencion] > 0");
                    }
                    $crud->add_action('Duplicar', '', 'facturacion/facturar/duplicar_factura'.$flag, 'icomoon-icon-copy-2', null,'', "![fac_id_origen_devolucion] > 0");
                    $crud->add_action('Orden de Entrega', '', 'orden_entrega', 'icomoon-icon-copy-2 orden ver_accion_modal', null, '', "[fac_estado] == 'Pendiente' OR [fac_estado] == 'Pagado'");
                    $crud->add_action('Domicilio', '', 'facturacion/facturar/historial_domicilio', 'icomoon-icon-checkmark  fac_domicilio', null,'', "[fac_aplica_domicilio] == 1");
                }
                $crud->order_by('fac_numero', 'ASC');
                $output = $crud->render();
            }
            $data['dropdown_suc'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_id_emr' => $this->tank_auth->get_empresa_id()), null, '', 'suc_id', true);
            $data['es_devolucion'] = $es_devolucion;
            $data['user'] = $usu;
            $data['add_factura'] = (isset($es_devolucion) && $es_devolucion > 0) ? 0 : $permisos["permite_agregar"];
            $data['titulo_personal'] = (isset($es_devolucion) && $es_devolucion > 0) ? 'Devolución - Factura' : "Facturación";
            if ($tipo == null) {
                cargarvista($data, $output, 'facturacion/facturar/factura');
            } else {
                print($output->output);
            }
        }
    }

    function editar_factura($tipo = null){
        if($tipo == 1){ //var_dump($_POST); die();
            $fac_id = $this->input->post('factura');
            $cli_id = $this->input->post('cliente');
            $tpg_id = $this->input->post('tipo_pago');
            $obs_fa = (trim($this->input->post('observable_factura')) != "")?$this->input->post('observable_factura'):"";
            $fecha_vencimiento = ($this->input->post('txtFechaVencimiento') != "")? formatear_fecha('Y-m-d', $this->input->post('txtFechaVencimiento')) : date('Y-m-d H:i:s');
            $actualizar_factura = array(
                'fac_id_cli'        => $cli_id,
                'fac_id_tpg'        => $tpg_id,
                'fac_observacion'   => $obs_fa,
                'fac_fecha_vencimiento'   => $fecha_vencimiento
            );
            $this->gsatelite->actualizar_array('fac_factura', $actualizar_factura, array('fac_id'=>$fac_id));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización de factura", 'texto_alerta' => "Factura actualizada correctamente.");
            $this->session->set_flashdata($alerta);
            redirect('facturacion/facturar/factura');
        } else{
            $data["id_fac"] = $this->input->post('factura');
            $data["detalle"] = $this->facturacion_model->get_detalle_factura($data['id_fac']);
            $datos_factura = $this->facturacion_model->get_facturas(array('fac_id'=>$data['id_fac']));
            $data['factura'] = $datos_factura;
            $data['num_fac'] = $datos_factura[0]['tif_abreviacion'] . ' - ' . $datos_factura[0]['fac_numero'];
            $data['factura_info'] = $this->facturacion_model->get_factura_info($data['id_fac']);
            $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            // ***************************************************************
            // Se comento ya que se colocara un label para ver el cliente asociado a la factura
            //$clientes = $this->facturacion_model->clientes_lista_precio(array('cli_estado'=>1));
            //$client = '';
            //foreach ($clientes as $cli) {
            //    if ($cli['cli_codigo'] != '') {
            //        $codigo = trim($cli['cli_codigo']) . ' - ';
            //    } else {
            //        $codigo = '';
            //    }
            //    $selected = '';
            //    if($data['factura'][0]['fac_id_cli'] == $cli['cli_id']){
            //        $selected = 'selected';
            //    }
            //    $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
            //
            //    $client .= '<option listas="' . $cli['lista'] . '" value="' . $cli['cli_id'] . '" '.$selected.'>' . $nombre_cliente . '</option>';
            //}
            // ***************************************************************
            $cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $data['factura'][0]['fac_id_cli']));
            if (count($cliente)>0) {
                $codigo  = (trim($cliente[0]['cli_codigo']) != '') ? trim($cliente[0]['cli_codigo']) . ' - ' : '';
                $cliente = ($cliente[0]['cli_personeria'] == 1) ? $codigo . $cliente[0]['cli_nombre'] . ' ' . $cliente[0]['cli_apellido'] : $codigo . $cliente[0]['cli_apellido'];
            } else {
                $cliente = '';
            }
            $data['cliente'] = $cliente;
            // ***************************************************************
            $tipos_pago = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1));
            $option_tpg = '<option value=""></option>';
            foreach ($tipos_pago as $k2) {
                $selected_ = ($k2['tpg_id'] == $data['factura'][0]['fac_id_tpg']) ? 'selected' : '';
                $option_tpg .= '<option value="' . $k2['tpg_id'] . '" data-aplcred="' . intval($k2['tpg_aplica_credito']) . '" ' . $selected_ .'  >' . $k2['tpg_nombre'] . '</option>';
            }
            $data['tipos_pago'] = $option_tpg;
            // ***************************************************************
            // CLIENTE TIENE PRECARGADO UN TIPO DE PAGO QUE NO AFECTA CREDITO ( = CONTADO )
            $data["datos_tpgcli"] = $this->facturacion_model->get_info_tpg_cli($data['factura'][0]['fac_id_cli']);
            $vista = $this->load->view("facturacion/facturar/editar_factura",$data,true);
            ob_end_clean();
            echo json_encode(array('resultado'=>$vista));
        }
    }

    function pagar_factura($id) {
        $cliente = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $id));
        $regresar = 'facturacion/facturar/crear_pago_factura/' . $cliente[0]['fac_id_cli'] . '/' . $id.'/2';
        redirect($regresar);
        //return $regresar;
    }

    function ver_pagos() {
        $id = $this->input->post('factura');
        $this->db->join('abf_abono_factura', 'abc_id = abf_id_abc');
        $this->db->join('fac_factura', 'fac_id = abf_id_fac');
        $this->db->join('cmr_comprobante_retencion', 'cmr_id_abf = abf_id', 'LEFT');
        $registro = $this->gsatelite->get_tabla('abc_abono_cliente', array('abf_id_fac' => $id));
        $regresar = '';
        if (count($registro) > 0) {
            $monto_tmp = $registro[0]['fac_total'];
            $contador_abonos = 0;
            foreach ($registro as $key) {
                $contador_abonos += $key['abf_monto'];
                $contador_abonos += ($key['cmr_monto'] > 0) ? $key['cmr_monto'] : 0;
                $monto_temp = $monto_tmp - $contador_abonos;
                $retencion = ($key['cmr_monto'] > 0) ? number_format($key['cmr_monto'],2).' ('.$key['cmr_numero'].')' : number_format(0,2);
                $regresar .= '<tr>
                                <td>' . formatear_fecha('d/m/Y', $key['abc_fecha']) . '</td>
                                <td style="text-align: right;">$' . number_format($key['abf_monto'], 2) . '</td>
                                <td style="text-align: right;">$' . $retencion .  '</td>
                                <td style="text-align: right;">$' . number_format($monto_temp, 2) . '</td>
                                <td>' . $key['abc_comprobante'] . '</td>
                ';
            }
        } else {
            $regresar .= '<tr><td colspan="5" style="text-align:center">Sin registros</td></tr>';
        }

        echo json_encode(array('tabla' => $regresar));
        /* SELECT * FROM
          abc_abono_cliente
          INNER JOIN abf_abono_factura ON abc_id = abf_id_abc
          WHERE
          abf_id_fac = 11097 */
    }

    /**
     * @author Edith Herrera
     */
    function anular_factura($tarificador = false) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $tipos_factura = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => '1'), null, '', 'tif_id', true);
            $data["tipo_factura"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_factura);
            $data['tipo_fac'] = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_estado' => 1));
            $data['titulo_personal'] = "Anular factura";
            if ($tarificador)
                return $data;///PDTE REVISAR PANTALLA MODULO INACTIVO
            $this->_cargarvista(null, $data);
        }
    }

    /**
     * @author Edith Herrera
     */
    function busqueda_factura() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // $tipo_f = $this->input->post('tipo_fac');
            $cliente = $this->input->post('cliente');
            $no_fact = $this->input->post('factura');
            $datos = $this->facturacion_model->datos_principales($cliente, $no_fact);
            //die(print_r(var_dump($datos),true));
            $facturadet = $this->facturacion_model->factura_detalle($cliente, $no_fact);
            $slcmotivos = '<option></option>';
            $tblmotivos = $this->gsatelite->get_tabla('maf_motivo_anulacion_factura', array('maf_estado' => 1));
            if (count($tblmotivos) > 0) {
                foreach ($tblmotivos as $k => $mtv) {
                    $slcmotivos .= '<option value="'.$mtv['maf_id'].'">'.$mtv['maf_nombre'].'</option>';
                }
            }
            $title_button = "";
            $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2); // FACT ELECT
            if (count($datos)) {
                foreach ($datos as $key) {
                    //Se valida la fecha de contabilización para no dejar anular
                    $disabled = (!validarFechaPeriodoContable(formatear_fecha('Y-m-d', $key['fac_fecha_cont']))) ? "disabled=disabled":"";
                    //Se valida si la factura esta pagada y ya se anulo el pago.
                    $where_abono = array(
                        'abf_id_fac' => $key['fac_id'],
                        'abc_estado' => 1,
                        'abc_fecha_anulacion IS NULL' => null,
                        'abf_fecha_anulacion IS NULL' => null
                    );
                    $this->db->join('abc_abono_cliente', 'abc_id = abf_id_abc');
                    $abonos_pendientes = $this->gsatelite->get_tabla('abf_abono_factura',  $where_abono);
                    //Variable que pasa a False si hay abonos o pagos pendientes de anular
                    $sin_abono = true;
                    if(count($abonos_pendientes) > 0){
                        $sin_abono= false;
                        $disabled = "disabled=disabled";
                    }
                    // $where_remi = array('fxr_id_fac' => $key['fac_id'], 'fxr_estado' => 1);
                    // $remisiones_hijas = $this->gsatelite->get_tabla('fxr_factura_remisionxfactura',  $where_remi);
                    // if (count($remisiones_hijas) > 0) {
                    //     $rems_hijas = true;
                    //     $disabled = "disabled=disabled";
                    // } else {
                        $rems_hijas = false;
                    // }                    
                    $title_button = ($disabled=="disabled=disabled")? 'title="Revisar periodo contable activo"':'';
                    $title_button = ($sin_abono == false) ? 'title="Debe anular los pagos asociados a la factura"' : $title_button;
                    // $title_button = ($rems_hijas) ? 'title="Debe eliminar las remisiones asociadas a la factura"' : $title_button;
                    $cliente = '';
                    $codigo = '';
                    if (trim($key['cli_codigo']) != '') {
                        $codigo = $key['cli_codigo'] . ' - ';
                    }
                    if (trim($key['cli_personeria']) != 2) {
                        $cliente = $codigo . trim($key['cli_nombre'] . ' ' . $key['cli_apellido']);
                    } else {
                        $cliente = $codigo . trim($key['cli_apellido']);
                    }
                    if ($tipo_fact_elect == 1) {
                        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
                        $date1 = date('Y-m-d');
                        if (trim($key['fac_sello_recepcion']) != "") {
                            $sello = explode(" | ", $key['fac_observaciones_factura_electronica']);
                            if (strtotime(end($sello))) {
                                $date2 = formatear_fecha('Y-m-d', end($sello));  
                            } else {
                                $date2 = formatear_fecha('Y-m-d', $key['fac_fecha_fact']);
                            }
                        } else {
                            $date2 = formatear_fecha('Y-m-d', $key['fac_fecha_fact']);
                        }
                        $fecha_1 = new DateTime($date1);
                        $fecha_2 = new DateTime($date2);
                        $diferencia = date_diff($fecha_1, $fecha_2);
                        $ndias = $diferencia->days;
                        switch ($key['tif_id']) {
                            case $tipo_factura['EXPORTACION']:
                            case $tipo_factura['CONSUMIDOR FINAL']:
                                $fuera_plazo = ($ndias > 90) ? true : false;
                                break;                            
                            default:
                                $fuera_plazo = ($ndias > 1) ? true : false;
                                break;
                        }
                    } else {
                        $fuera_plazo = false;
                    }

                    $codigo_vendedor = '';
                    if ($key['ven_codigo'] != '') {
                        $codigo_vendedor = $key['ven_codigo'] . ' - ';
                    }
                    if ($tipo_fact_elect == 1 && $fuera_plazo){
                        $disabled = "disabled=disabled";
                        $alerta = '<script type="text/javascript">$(document).ready(function() {
                            crear_alerta("error", "Fuera del Plazo Permitido", "No se puede realizar por estar fuera del plazo permitido para este tipo de docummento.");
                        });</script>';
                    } else {
                        if($disabled!="" && $sin_abono == true && $rems_hijas == false){
                            $alerta = '<script type="text/javascript">$(document).ready(function() {
                                crear_alerta("info","Factura","Fecha Contable fuera de los periodos activos");
                            });</script>';
                        } else if($disabled!="" && $sin_abono == false && $rems_hijas == false){
                            $alerta = '<script type="text/javascript">$(document).ready(function() {
                                crear_alerta("info","Factura","Debe anular primero los pagos asociados a la factura.");
                            });</script>';
                        } else if($disabled != "" && $rems_hijas == true){
                            $alerta = '<script type="text/javascript">$(document).ready(function() {
                                crear_alerta("info","Notas de Remisión","Debe eliminar primero las notas de remisión asociadas a la factura.");
                            });</script>';
                        } else {
                            $alerta = '';
                        }
                    }
                }
                $data['key'] = $key;
                $data['alerta'] = $alerta;
                $data['cliente'] = $cliente;
                $data['disabled'] = $disabled;
                $data['slcmotivos'] = $slcmotivos;
                $data['facturadet'] = $facturadet;
                $data['title_button'] = $title_button;
                $data['codigo_vendedor'] = $codigo_vendedor;
                $data['tipo_fact_elect'] = $tipo_fact_elect;
                $html = $this->load->view("facturacion/facturar/detalle_anula_factura", $data, true);
                $arr = array(
                    "drop" => trim($html)
                );
            } else {
                $arr = array('tipo_alerta' => 'error', 'titulo_alerta' => "Anulación de facturas", 'texto_alerta' => "La factura que usted ha solicitado no existe");
            }
            echo json_encode($arr);
        }
    }

    /**
     * @author	Habby Lovo
     */
    function guardar_anulacion() {
        $id = $this->input->post('codigo');//idfactura a anular
        $usuario_id = ($this->input->post('usuario')!='')?$this->input->post('usuario'):$this->tank_auth->get_user_id();
        $ajax = ($this->input->post('ajax')!='')?$this->input->post('ajax'):'';
        $motivo = $this->input->post('razon');
        $cot_id = $this->input->post('cot_id');
        $slc_motivofac = $this->input->post('motivo_fact_elect');
        $tarificador = $this->input->post('tarificador');
        $reactivar = ($this->input->post('reactivar_orden')) ? $this->input->post('reactivar_orden') : 0;
        $id_orden = ($this->input->post('id_orden')) ? $this->input->post('id_orden') : '';
        $aplica_seguimiento = $this->input->post('txtAplicaSeguimiento');
        $factura_reg = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $id));//FACTURA
        $factura = $this->facturacion_model->get_factura_anulacion(array('moi_id_fac' => $id));//MOI DE LA FACTURA
        $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $nt_remi = (isset($tipo_factura['NOTA REMISION'])) ? $tipo_factura['NOTA REMISION'] : 0;
        $es_nota_remision = ($factura_reg[0]['fac_id_tif'] == $nt_remi) ? true : false;
        $fac_total_pendiente = 0;
        if($aplica_seguimiento == 1){
            $factura_reg = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $id));
            if(count($factura_reg) > 0){
                $fac_total_pendiente = $factura_reg[0]['fac_total'];
            }
        }

        //Verificar si la factura aplica grupo familiar
        $dtg_cliente = $factura_reg[0]['fac_id_cli'];
        $gfa_aplicado = false;
        $grupo_familiar = null;
        $detalles = $this->gsatelite->get_tabla('def_detalle_fact', array('def_id_fac' => $id, 'def_estado' => 1));
        foreach ($detalles as $detalle) {
            $idart = $detalle['def_id_art'];
            $obtener_info_curso = $this->registro_academico_model->get_informacion_alumno_curso(array('lxp_estado' => 1, 'alm_id_cli' => $dtg_cliente, 'mod_id_art' => $idart));
            if (count($obtener_info_curso) > 0) {
                $flag_curso_libre = $obtener_info_curso[0]['trd_es_curso_libre'];
                $grupo_familiar = $obtener_info_curso[0]['gfa_id'];
                if (isset($flag_curso_libre) && $flag_curso_libre == 1 && isset($grupo_familiar) && $grupo_familiar > 0) {
                    $gfa_aplicado = true;
                    break;
                }
            }
        }

        // Revertir alm_aplica_gfa si aplica
        if ($gfa_aplicado && $grupo_familiar) {
            $facturas_gfa_hoy = $this->facturacion_model->get_facturas_realizadas_grupo_familiar_hoy(array('DATE(fac_fecha_fact)' => date('Y-m-d'), 'alm_id_gfa' => $grupo_familiar, 'fac_estado >' => 0, 'fac_id !=' => $id));
            $count_facturas_gfa_hoy = $facturas_gfa_hoy[0]['cantidad_facturas_realizadas_gfa_hoy'];
            $clientes_facturas = isset($facturas_gfa_hoy[0]['clientes_facturas']) ? explode(',', $facturas_gfa_hoy[0]['clientes_facturas']) : [];
            $clientes_facturas = array_unique($clientes_facturas); // Manejar facturas repetidas

            $obtener_alumnos_gfa = $this->gsatelite->get_tabla('alm_alumno', array('alm_id_gfa' => $grupo_familiar));
            $cantidad_alumnos_gfa = count($obtener_alumnos_gfa);

            $clientes_a_revertir = [];
            if ($count_facturas_gfa_hoy == 0) {
                // Si no hay otras facturas GFA hoy, revertir todos los miembros
                $clientes_a_revertir = array_column($obtener_alumnos_gfa, 'alm_id_cli');
            } else {
                // Determinar clientes a revertir según el caso
                if ($cantidad_alumnos_gfa == 2 && $count_facturas_gfa_hoy < 2) {
                    $clientes_a_revertir = array_column($obtener_alumnos_gfa, 'alm_id_cli');
                } elseif ($cantidad_alumnos_gfa == 3 && $count_facturas_gfa_hoy < 3) {
                    $clientes_a_revertir = array_column($obtener_alumnos_gfa, 'alm_id_cli');
                } elseif ($cantidad_alumnos_gfa == 4) {
                    if ($count_facturas_gfa_hoy < 2) {
                        $clientes_a_revertir = array_column($obtener_alumnos_gfa, 'alm_id_cli');
                    } elseif ($count_facturas_gfa_hoy < 4) {
                        $clientes_a_revertir = array_diff(array_column($obtener_alumnos_gfa, 'alm_id_cli'), $clientes_facturas);
                    }
                } elseif ($cantidad_alumnos_gfa == 5) {
                    if ($count_facturas_gfa_hoy < 3) {
                        $clientes_a_revertir = array_diff(array_column($obtener_alumnos_gfa, 'alm_id_cli'), $clientes_facturas);
                    } elseif ($count_facturas_gfa_hoy < 5) {
                        $clientes_a_revertir = array_diff(array_column($obtener_alumnos_gfa, 'alm_id_cli'), $clientes_facturas);
                    }
                }
            }

            if (!empty($clientes_a_revertir)) {
                $update_alumno = array(
                    'alm_aplica_gfa' => 0,
                    'alm_usu_mod' => $usuario_id,
                    'alm_fecha_mod' => date('Y-m-d H:i:s')
                );
                //$condiciones = array('alm_id_cli' => array_unique($clientes_a_revertir));
                //$this->gsatelite->actualizar_array('alm_alumno', $update_alumno, $condiciones);
                $this->db->where_in('alm_id_cli', array_unique($clientes_a_revertir));
                $this->db->update('alm_alumno', $update_alumno);
                log_message('info', 'Cantidad de registros afectados: ' . $this->db->affected_rows());
                log_message('info', 'Consulta ejecutada (update alm_aplica_gfa = 0): ' . $this->db->last_query());
            }
        }

        /*==================   Verificar si es registro académico y revertir procesos   ======================*/
        $registro = $this->gsatelite->get_registro('lxp_alumnoxpensum', array('lxp_id_fac'=>$id, 'lxp_estado'=>1));
        if(count($registro)>0){
            $anular_reg = $this->procesar_anulacion_alumno($id);
            if($anular_reg==false){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Anulación de factura", 'texto_alerta' => "El registro del alumno inscrito no puede ser anulado.");
                $this->session->set_flashdata($alerta);
                if ($tarificador)
                    redirect('tarificador/procesos/anular_factura');
                redirect('facturacion/facturar/anular_factura');
                die();
            }
        }
        /*==================   Verificar si es registro académico y revertir cuotas tanbien   ======================*/
        $registros_cmc = $this->gsatelite->get_tabla('cmc_cargo_alumnoxcurso', array('cmc_id_fac'=>$id, 'cmc_estado'=>1));
        if(count($registros_cmc) > 0){
            foreach ($registros_cmc as $k => $val) {
                $updatecmc = array('cmc_id_fac' => null, 'cmc_usu_modificacion' => $usuario_id, 'cmc_fecha_modificacion' => date('Y-m-d H:i:s'));
                if ($val['cmc_confirma_externo'] != "") {
                    $updatecmc['cmc_observacion'] = $val['cmc_observacion'] . " |ANULACION DE FACTURA ID: $id EL " . date('Y-m-d');
                } else {
                    $updatecmc['cmc_dias_mora'] = null;
                    $updatecmc['cmc_monto_mora'] = null;
                    $updatecmc['cmc_fecha_pago'] = null;
                    $updatecmc['cmc_estado_cargo'] = 1;
                    $updatecmc['cmc_observacion'] = $val['cmc_observacion'] . " |ANULACION DE FACTURA ID: $id EL " . date('Y-m-d');
                    $updatecmc['cmc_total_cuota'] = null;
                }
                $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $updatecmc, array('cmc_id'=>$val['cmc_id']));
            }
        }
        /*======================    Partida contable para la anulacion de factura    =========================*/
        $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
        if($generar_partida > 0){
            $where['fac_id'] = $id;
            $info['num_fac'] = (count($factura) > 0 ) ? $factura[0]['fac_numero'] : '';
            $this->generar_partida_anulacion_facturacion_contabilidad($where, $info);
        }
        /*=====   Si se marco reactivar la orden de venta asociada a la factura se actualiza el estado   ======*/
        if ($reactivar > 0) {
            if ($id_orden != '') {
                $orv =  array(
                    'orv_observacion'        => $motivo,
                    'orv_estado'             => 1,
                    'orv_usu_modificacion'   => $usuario_id,//$this->tank_auth->get_user_id(),
                    'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar('orv_orden_venta', $orv, 'orv_id', $id_orden);
            }
        }
        /* ==========          Desvincula las notas de remision de las facturas          ================ */
        if ($es_nota_remision) {
            //SI ES NOTA DE REMISION, PUEDE SER FACTURADA O NO, SI ES FACTURADA HAY REGISTROS DE UNA FACTURA PADRE, SINO SOLO SE HACE EL MOI-REVERSA SI APLICA
            $fxr_factura_remision = $this->gsatelite->get_tabla("fxr_factura_remisionxfactura", array("fxr_id_fac_remision" => $id));
            if (count($fxr_factura_remision) > 0) {
                $hija_padre = $fxr_factura_remision[0];
                // VERIFICAR EL ESTADO DE LA PADRE POR CUALQUIER COSA
                $estado_padre = $this->gsatelite->get_campo('fac_factura', 'fac_estado', array('fac_id' => $hija_padre['fxr_id_fac']));
                if ($estado_padre > 0) {
                    //DEVOLVER LA CANTIDAD DE LA REMISION A LA PADRE, COMO PENDIENTE
                    $this->recalcular_cantidad_pendiente($id, $hija_padre['fxr_id_fac']);
                }
            }
        }
        /*======================================================================================================
        ====                        Verificar si existe un mov de inv y si existe anularlo                        ====
        =======================================================================================================*/
        if (count($factura) > 0) {
            $cantidad = array();
            $precio = array();
            $producto_art = array();
            $convercion_cva = array();
            $bodega_bod = array();
            $sector_sxb = array();
            foreach ($factura as $key) {
                $cantidad[] = $key['dee_cantidad'];
                $precio[] = $key['sar_precio'];
                $producto_art[] = $key['dee_id_art'];
                $convercion_cva[] = $key['dee_id_cva'];
                $bodega_bod[] = $key['sar_id_bod'];
                $sector_sxb[] = $key['sar_id_sxb'];
            }
            $arreglo = array(
                'cantidades' => $cantidad,
                'precios' => $precio,
                'productos' => $producto_art,
                'converciones' => $convercion_cva,
                'bodegas' => $bodega_bod,
                'sectores' => $sector_sxb,
                'usuario' => $usuario_id
            );
            //regresaremos los datos de los detalles de la cotizacion que se regresaron al inventario y luego de laa anulacion de la factura
            if ($cot_id != '') {
                foreach ($factura as $value) {
                    $cantidad_facturada = $value['axc_cantidad_facturada'] - $value['dee_cantidad'];//restamos la cantidad facturada
                    $cantidad_pendiente = $value['axc_cantidad_pendiente'] + $value['dee_cantidad'];//regresamos a la cantidad pendiente
                    $actualizacion = array('axc_cantidad_pendiente' => $cantidad_pendiente, 'axc_cantidad_facturada' => $cantidad_facturada);
                    $respuesta = $this->gsatelite->actualizar_array('axc_articuloxcotizacion',$actualizacion, array('axc_id' => $value['axc_id']));
                }
                $restante = $this->gsatelite->get_tabla("axc_articuloxcotizacion", array("axc_id_cot" => $cot_id, "axc_cantidad_facturada >" => 0));
                if (count($restante) > 0) {//verificamos si existen articulos aun facturados de la cotizacion
                    $estado = array('cot_estado_facturacion' => 2, 'cot_estado' => 1);//si existen estao queda a parcial de facturar y se activa
                } else {
                    $estado = array('cot_estado_facturacion' => 1, 'cot_estado' => 1);//si existen estao queda a pendiente de facturar y se activa
                }
                $this->gsatelite->actualizar_array('cot_cotizacion',$estado, array('cot_id' => $cot_id));
            }
            $this->revertir_factura($id, $arreglo, $key['fac_id_tif']);
        }
        $sello = "";
        $fecha = date('Y-m-d H:i:s');
        $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        if ($tipo_fact_elect == 1) {
            if ($factura_reg[0]["fac_sello_recepcion"] != "" && $factura_reg[0]["fac_sello_recepcion"] != null) {
                $jsonEnv = json_encode([
                    "codigoGeneracion" => $factura_reg[0]["fac_codigo_generacion"],
                    "selloRecepcion" => $factura_reg[0]["fac_sello_recepcion"],
                    "tipoAnulacion" => $slc_motivofac,
                    "motivo" => ($slc_motivofac == 3) ? $motivo : null,
                    "idInterno" => $id
                ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                ##Dar tratamiento, para todos los tipos posibles de errores
                ##En motivo de anulacion poner minimo de 5 caracteres
                $res_env = $this->procesar_invalidacion($jsonEnv);
                $decode_res = json_decode($res_env, true);
                if (isset($decode_res["body"]["validations"]["errors"])) {
                    $mensaje = $decode_res["body"]["message"] . " | " . implode(" // ", $decode_res["body"]["validations"]["errors"]);
                } else {
                    $mensaje = $decode_res["body"]["message"] . " | " . $decode_res["body"]["response"]["descripcionMsg"];
                }
                $actualice = array(
                    "fac_id_maf" => $slc_motivofac,
                    "fac_sello_anulacion_fact_elect" => $decode_res["body"]["response"]["selloRecibido"],
                    "fac_comentario_anula_fact_elect" => $mensaje
                );
                $this->gsatelite->actualizar_array("fac_factura", $actualice, array("fac_id" => $factura_reg[0]['fac_id']));
                $sello = ($decode_res["body"]["response"]["selloRecibido"]) ? "Sello: ".$decode_res["body"]["response"]["selloRecibido"] : "";
            }
        }
        $this->facturacion_model->anular_factura($id, $fecha, $motivo, $aplica_seguimiento, $fac_total_pendiente);
        if ($ajax != '') {
            echo "jsonPHP".preg_replace("/\xEF\xBB\xBF/", "", json_encode(array('factura'=>'anulada'), JSON_FORCE_OBJECT ));
        } else {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Anulación de Documento", 'texto_alerta' => "Proceso realizado exitosamente </br> $sello");
            $this->session->set_flashdata($alerta);
            if ($tarificador) {
                redirect('tarificador/procesos/anular_factura');
            } else {
                if ($es_nota_remision) {
                    redirect('facturacion/facturar/anular_remision');
                } else {
                    redirect('facturacion/facturar/anular_factura');
                }
            }
        }
        //}

        function llamar_datos_row($tabla, $where, $order) {
            $query = $this->facturacion_model->cargar_todo($tabla, $where, $order);
            return $query;
        }

        // 	$estado = array(
        // 			'fac_motivo_anulacion'=>$motivo,
        // 			'fac_estado' =>0,
        // 			'fac_usu_mod'=> $this->tank_auth->get_user_id(),
        // 			'fac_fecha_anulacion'=> date('Y-m-d H:i:s'));
        // 				//$this->db->where('fac_id', $factura);
        // 		$registro=$this->gsatelite->actualizar_array('fac_factura', $estado, array('fac_id'=>$factura));
        // if ($registro != 0) {
        // 	$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Anulación de facturas",'texto_alerta'=>"Transacción efectuada correctamente");
        // }else{
        // 	$alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Anulación de facturas",'texto_alerta'=>"Transacción no efectuada, favor verificar información");
        // }
        //  $this->session->set_flashdata($alerta);
        //  redirect('facturacion/facturar/anular_factura');
    }

    function procesar_invalidacion($json){
        $dato_api = json_decode($this->gsatelite->get_parametro('API_KEY_FACTURACION_SAT'), true);
        $cliente_key = $dato_api["kEY_CLIENTE"];
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $dato_api["URL_INVALIDACION"],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => $json,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_HTTPHEADER => array(
                "Authorization: $cliente_key",
                "Content-Type: application/json",
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    function revertir_factura($fac_id, $detalle, $id_tif) {
        $id_nota_remision = $this->gsatelite->get_parametro('SYS_TIPO_FACTURAS ', null, null, array('NOTA REMISION'));//se busca el id parametrisado que defina la nota de remision
        if ($id_nota_remision == $id_tif) { //se valida que si es nota de remision el movimiento en la moi sea por nota de remision, sino sera por facturacion anulada
            $tipo_factura = 'ENT_REMISION';
        } else {
            $tipo_factura = 'FACTURA_ANULAR';
        }
        $tip_salida = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array("$tipo_factura")); // el tipo de factura
        //$tip_salida = 12;
        $bodega_bod = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA'); //bodega parametrisada origen
        $fac_documento = $this->facturacion_model->get_doc_fact($fac_id); 
        $producto_art = $detalle['productos']; //array
        $cantidad_dee = $detalle['cantidades']; //array
        $medida_cva = $detalle['converciones']; //array
        $precio_dee = $detalle['precios']; //array
        $bodega_bod = $detalle['bodegas']; //array
        $sector_sxb = $detalle['sectores']; //array
        $usuario_id = ($detalle['usuario']!=null)?$detalle['usuario']:$this->tank_auth->get_user_id();
        if (trim($bodega_bod[0]) != "" && trim($tip_salida) != "") {
            $respuesta = array(
                'moi_id_tip' => $tip_salida,
                'moi_id_bod' => $bodega_bod[0],
                'moi_id_fac' => $fac_id,
                'moi_fecha_mov' => date('Y-m-d H:i:s'),
                'moi_documento' => "Anulación Doc: " . $fac_documento,
                'moi_estado' => 1,
                'moi_usu_creacion' => $usuario_id,
                'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                'moi_usu_modificacion' => $usuario_id,
                'moi_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $respuesta);
            $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
            for ($x = 0; $x < count($producto_art); $x++) {
                if (trim($producto_art[$x]) != "" && trim($cantidad_dee[$x]) != "" && trim($precio_dee[$x]) != "") {
                    $fecha = null;
                    $sector = (trim($sector_sxb[$x]) != "") ? $sector_sxb[$x] : null;
                    if ($costo_promedio == 1) {
                        $nuevo_precio =  $this->recalcular_precio_promedio($producto_art[$x], $bodega_bod[0], $cantidad_dee[$x], $precio_dee[$x]);
                    }
                    $respuesta = array(
                        'sar_id_art' => $producto_art[$x],
                        'sar_id_bod' => $bodega_bod[0],
                        'sar_cant_actual' => $cantidad_dee[$x],
                        'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $precio_dee[$x],
                        'sar_fecha_caducidad' => $fecha,
                        'sar_id_sxb' => $sector,
                        'sar_estado' => 1,
                        'sar_usu_creacion' => $usuario_id,
                        'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sar_usu_modificacion' => $usuario_id,
                        'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $sar_id = $this->gsatelite->ingresar('sar_saldo_articulo', $respuesta);
                    $respuesta = array(
                        'dee_id_moi' => $moi_id,
                        'dee_id_art' => $producto_art[$x],
                        'dee_id_sar' => $sar_id,
                        'dee_id_cva' => $medida_cva[$x],
                        'dee_id_sxb' => $sector,
                        'dee_cantidad' => $cantidad_dee[$x],
                        'dee_fecha_caducidad' => $fecha,
                        'dee_precio' => $precio_dee[$x],
                        'dee_subtotal' => ($cantidad_dee[$x] * $precio_dee[$x]),
                        'dee_estado' => 1,
                        'dee_usu_creacion' => $usuario_id,
                        'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dee_usu_modificacion' => $usuario_id,
                        'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('dee_detalle_mov', $respuesta);
                }
            }
        }
        $fac_numero = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $fac_id));

        //============= Generar asiento reversion factura  ===============//
        $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
        $doc_referencia = $fac_numero[0]['fac_numero'];
        if ($generar_partida > 0) {
            //Concepto anulacion de factura
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 3));
            if(count($pct_concepto) > 0){
                $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
            }else{
                $pct_concepto = 'Concepto no definido';
            }

            /* $this->load->library('../controllers/inventario/gestion_productos');
              $res_debe = $this->gestion_productos->generar_asiento_entrada_inv_debe($
              , $doc_referencia);
              $this->gestion_productos->generar_asiento_entrada_inv_haber($proveedor_prv, $res_debe['id_pct'], $res_debe['total_haber']);//Proveedor, idpartida
              $this->gsatelite->actualizar_array('moi_movimiento_inv', array('moi_id_pct' => $res_debe['id_pct']), array('moi_id' => $moi_id)); */
            $moi_mi = $this->gsatelite->get_tabla('moi_movimiento_inv', array('moi_id_fac' => $fac_id));
            $fac = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $fac_id));
            if (count($moi_mi) > 0) {
                $pct_par_con = $this->gsatelite->get_tabla('pct_partida_contable', array('pct_id' => $moi_mi[0]['moi_id_pct']));
                $det_cuencon = $this->gsatelite->get_tabla('dpc_detalle_partida', array('dpc_id_pct' => $moi_mi[0]['moi_id_pct']));
                /*                 * *Crear partida contable** */
                $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + 1;
                $array_partida = array(
                    'pct_id_tpd' => $pct_par_con[0]['pct_id_tpd'], //YA
                    //'pct_id_prc' => $this->input->post('id_prc'),
                    'pct_id_orp' => $pct_par_con[0]['pct_id_orp'], //YA
                    'pct_concepto' => $pct_concepto . $fac[0]['fac_numero'], //YA
                    'pct_total' => number_format($pct_par_con[0]['pct_total'], 2, '.', ''), //YA
                    'pct_fecha' => date('Y-m-d H:i:s'), //YA
                    'pct_correlativo' => $correlativo_partida, //YA
                    //'pct_codigo' => $codigo,
                    //'pct_modulo' => $modulo,
                    'pct_estado' => 1,
                    'pct_fecha_crea' => date('Y-m-d H:i:s'),
                    'pct_fecha_mod' => date('Y-m-d H:i:s'),
                    'pct_usu_crea' => $usuario_id,
                    'pct_usu_mod' => $usuario_id,
                );
                $agregar = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

                //Crear parte debe
                foreach ($det_cuencon as $j => $deta) {
                    if ($deta['dpc_debe'] > 0) {
                        $array_detalle = array(
                            'dpc_id_cnt' => $deta['dpc_id_cnt'], //YA
                            'dpc_id_pct' => $agregar, //Ya
                            'dpc_concepto' => $deta['dpc_concepto'],
                            'dpc_debe' => 0.00, //debe
                            'dpc_haber' => $deta['dpc_debe'],
                            'dpc_estado' => 1,
                            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                            'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                            'dpc_usu_crea' => $usuario_id,
                            'dpc_usu_mod' => $usuario_id
                        );
                        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                    }
                }/*                 * **Fin parte debe*** */

                //Crear parte haber
                //Cuenta inicial
                $cnt_comp = $det_cuencon[0]['dpc_id_cnt'];
                $sumnewtotal = 0.00;
                $countrow = 0;
                $len = count($det_cuencon);

                foreach ($det_cuencon as $j => $deta) {
                    if ($deta['dpc_haber'] > 0) {
                        $array_detalle = array(
                            'dpc_id_cnt' => $deta['dpc_id_cnt'], //YA
                            'dpc_id_pct' => $agregar, //Ya
                            'dpc_concepto' => 'Entrada producto por anulacion factura', //$deta['dpc_concepto'],
                            'dpc_debe' => $deta['dpc_haber'], //debe
                            'dpc_haber' => 0.00, //haber
                            'dpc_estado' => 1,
                            'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                            'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                            'dpc_usu_crea' => $usuario_id,
                            'dpc_usu_mod' => $usuario_id
                        );
                        $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
                    }
                }//Fin foreach
                /*                 * **Fin parte haber*** */
            }//Validacion si existe factura
        }//Fin validacion generacion partida
        //==============Fin Generar asiento reversion factura  ===========//
    }
    //Fin revertir factura

    /**
     * @author Habby Lovo
     * @since 23/11/2017
     */
    function get_cotizaciones() {
        $id_cliente = $this->input->post('id');
        $id_pcl = $this->input->post('pcl_id');
        $id_ven = $this->input->post('id_ven');
        $filtro = $this->gsatelite->get_parametro('SYS_FAC_FILTRO_VENDEDOR');

        if($id_pcl != '' && $id_pcl != 'null'){
            $where = array('cot_id_cli'=>$id_cliente, 'cot_estado'=>1, 'cot_id_pcl'=>$id_pcl);
            $cotizaciones = $this->facturacion_model->get_cotizaciones($where);
        } else{
            $cotizaciones = $this->facturacion_model->get_cotizaciones_ganadas($id_cliente);
        }
        $html = '<option value=""></option>';
        foreach ($cotizaciones as $key => $value) {
            $tip = 0;
            if (trim($value['ord_id']) != '') {
                $tip = 1;
            }
            if ($value['pdte_fac'] > 0) {
                $html .= '<option value="' . $value['cot_id'] . '" tip="' . $tip . '">' . $value['cot_codigo'] . ' - ' . $value['cot_concepto'] . '</option>';
            }
        }
        //Se obtienen los proyectos
        if($id_pcl != '' && $id_pcl != 'null'){
            $proyectos = array(); //vacio para que no entre al if
        } else{
            $this->db->join('epr_estado_proyecto','epr_id = pcl_id_epr', 'inner');
            $proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $id_cliente, 'pcl_estado' => 1, 'epr_cierre'=>0));
        }
        $opciones = "<option></option>";
        if (count($proyectos) > 0) {
            foreach ($proyectos as $pcl) {
                $nombre = $pcl['pcl_codigo'] . ' - ' . $pcl['pcl_nombre'];
                $opciones .= "<option value='" . $pcl['pcl_id'] . "' data-suc='".$pcl['pcl_id_scl']."'>" . $nombre . "</option>";
            }
        }
        if(($id_ven>0 && $id_ven!=null) || $filtro == 1){
            $this->db->where('orv_id_ven', $id_ven);
        }
        $SlcOrdenVenta = '<option value=""></option>';
        $OrdenVenta = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id_cli' => $id_cliente, 'orv_estado'=>1));
        foreach ($OrdenVenta as $key => $value) {
            $SlcOrdenVenta .= '<option value="'.$value['orv_id'].'" data-cliente="'.$value['orv_id_cli'].'">'.$value['orv_numero_orden'].' - '.$value['orv_nombre_factura'].'</option>';
        }


        echo json_encode(array('drop' => $html, 'proyectos'=> $opciones, 'ordenVenta' =>$SlcOrdenVenta));
    }

    function get_cuotas_reg_acad() {
        $id_alm = $this->input->post('clid');
        $seleccion = $this->input->post('selected');
        $alumno = $this->gsatelite->get_registro('alm_alumno', 'alm_id_cli', $id_alm);
        $option = '<option value=""></option>';
        if (!empty($alumno) && is_object($alumno)) {
            $where = array('alm_id' => $alumno->alm_id, '(cmc_estado_cargo = 1 OR ( cmc_estado_cargo = 2 AND cmc_id_fac IS NULL))' => NULL );
            $materias_cursos = $this->registro_academico_model->get_cuotas_curso_libre($where);
            if (count($materias_cursos) > 0) {
                $slctd = (trim($seleccion) != "") ? explode(',', $seleccion) : array(0); 
                foreach ($materias_cursos as $key => $val) {
                    $scd = (in_array($val['cmc_id'], $slctd)) ? 'selected' :'';
                    $option .= '<option value="'.$val['cmc_id'].'" data-artid="'.$val['mod_id_art'].'" '.$scd.' >'.$val['mod_nombre'].' - CUOTA '.$val['cmc_cuota'].'</option>';
                }
            }
        }
        echo json_encode(array('drop' => $option));
    }

    function get_ordenes() {
        $id_cotizacion = $this->input->post('id');
        $ordenes = $this->gsatelite->get_tabla('ord_orden', array('ord_id_cot' => $id_cotizacion, 'ord_estado' => 1));
        $html = '<option value=""></option>';
        foreach ($ordenes as $key) {
            $html .= '<option value="' . $key['ord_id'] . '" selected>' . $key['ord_codigo'] . '</option>';
        }

        echo json_encode(array('drop' => $html));
    }

    function get_tabla_cotizaciones() {
        $id_cotizacion = $this->input->post('id_cotizacion');
        $producto_x_cot = $this->facturacion_model->articulos_cotizacion($id_cotizacion);

        $data['productos'] = $producto_x_cot;

        $html = $this->load->view('facturacion/facturar/productos_x_cotizacion', $data, true);
        echo json_encode(array('drop' => $html));
    }

    /**
     * @author René Castaneda
     * @return Crea un pdf del detalle de una factura predeteminada
     * @author Habby Lovo
     * @since  1/11/17
    */
    function imprimir_factura($id_factura = null, $tipo = null, $return_html=false) {
        $this->load->library('EnLetras');
        $masivo = false;
        //Si es masiva verifica el post
        if ($_POST) {
            $masivo = true;
            $correlativo_inicial = $this->input->post('txt_correlativo_inicial');// Correlativo de la factura
            $factura_inicial     = $this->input->post('txt_factura_ini');//id de la factura inicial para el where
            $correlativo_final   = $this->input->post('txt_correlativo_final');////ultimo correlativo de la factura
            $factura_final       = $this->input->post('txt_factura_fin');//id de la ultima factura que se puede imprimir
            $where_in            = ($this->input->post('txt_facturas_in') !="") ?$this->input->post('txt_facturas_in'):null; // String de facturas a imprimir
            $where_in_array = explode(",", $where_in);
        }
        if ( $masivo == false) {
            if ($id_factura == null and $this->session->flashdata('id_factura') != "") {
                $id_factura = $this->session->flashdata('id_factura');
                $num_factura = $this->gsatelite->get_campo('fac_factura', 'fac_numero', array('fac_id'=>$id_factura));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Facturación", 'texto_alerta' => "Factura procesada correctamente");
                $this->session->set_flashdata($alerta);
            } else {
                if ($id_factura != "" and $id_factura > 0) {
                    $id_factura = $id_factura;
                } else {
                    if($tipo>0){
                        redirect("/facturacion/facturar/crear_factura/0/1");
                    }else{
                        redirect("/facturacion/facturar/crear_factura");
                    }
                }
            }
        }
        if ( $masivo == false) { // No es masiva
            $facturas = $this->facturacion_model->get_factura_info($id_factura);
        } else{ // Es masiva
            $facturas = $this->facturacion_model->get_facturas_masiva_info($correlativo_inicial, $correlativo_final, $factura_inicial,$factura_final,$where_in_array);
        }
        // var_dump($facturas);die();
        $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2); // FACT ELECT
        $frfwhere = array('frf_id_tif'=>$facturas[0]['fac_id_tif'], 'frf_activo' => 1);
        if ($tipo_fact_elect == 1) {
            $frfwhere['frf_factura_electronica'] = 1;
                                $this->db->order_by("ief_id", "ASC");
            $data['xtra_inf'] = $this->gsatelite->get_tabla("ief_informacion_extra_factura",array("ief_id_fac"=>$id_factura,"ief_impresion_factura"=>1,"ief_estado"=>1));
            $data['pdf'] = $this->pdf;
            $data['datos_emr'] = $this->facturacion_model->get_empresa_dte($this->tank_auth->get_empresa_id())[0];
        }
        // Tabla de las configuraciones de los tipos de factura
        $tipo_pago = $this->gsatelite->get_tabla('frf_formato_factura', $frfwhere);
        // Configuracion de los ids de los tipos de pago
        $conf_tpg       = $tipo_pago[0]['frf_configuracion_tipo_pago'];
        $conf_tpg_array = json_decode($conf_tpg, true);
        $conf_tpg_imp   = 3;
        $html               = "";
        $html_rifa          = "";
        $cantidad_facturas  = count($facturas);
        $contador_facturas  = 0;
        $decimales          = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['pdecimal']   = ($decimales != '')?$decimales:2;

        foreach($facturas as $consulta_factura) {
            if($conf_tpg_array['CREDITO'] == $consulta_factura['fac_id_tpg']){
                $conf_tpg_imp = 1;
            } else if($conf_tpg_array['CONTADO'] == $consulta_factura['fac_id_tpg']){
                $conf_tpg_imp = 2;
            } else{
                $conf_tpg_imp = 3;
            }
            $data['tip_pago_imp'] = $conf_tpg_imp;
            //configuraciones de formato
            $conf_formato = $tipo_pago[0]['frf_configuraciones_formato'];
            $conf_formato_array = json_decode($conf_formato, true);
            // Array Asociativo con los parametros de la frf
            $array_datos = array();
            $array_datos['documento']   = $conf_formato_array['DOCUMENTO'];
            $array_datos['iva']         = (isset($conf_formato_array['IVA']))?$conf_formato_array['IVA']:0;
            $array_datos['nrc']         = (isset($conf_formato_array['NRC'])?$conf_formato_array['NRC']:0);
            $array_datos['iva_percibido']     = (isset($conf_formato_array['IVA_PERCIBIDO'])?$conf_formato_array['IVA_PERCIBIDO']:0);
            $array_datos['factura']     = $consulta_factura['fac_id'];
            $data['datos_factura'] = $this->facturacion_model->get_detalle_clientexfactura(array('fac_id'=>$consulta_factura['fac_id']), $array_datos);
            if ($data['datos_factura'][0]['fac_id_fac_credito'] != null) {
                $fac_padre = (array)$this->gsatelite->get_registro('fac_factura', array('fac_id' => $data['datos_factura'][0]['fac_id_fac_credito']));
                $tif_padre = $this->facturacion_model->get_serie_padre($fac_padre['fac_id']);
                $numero = $tif_padre[0]['serie_numero'];
                $data['factura_padre'] = $numero;
                $data['fecha_fac_padre'] = formatear_fecha('d-m-Y', $fac_padre['fac_fecha_fact']);
            }
            //Datos extras para credito fiscal
            $data['tipo_pago_cliente'] = $consulta_factura['tpg_nombre'];
            $data['row_factura'] = $consulta_factura;
            $data['width_conf']  = $conf_formato_array['WIDTH'];
            $data['height_conf'] = $conf_formato_array['HEIGHT'];
            
            $data['maxdui']      = (isset($conf_formato_array['MAXDUI']))?$conf_formato_array['MAXDUI']:0;
            $data['PROPINA']     = (isset($conf_formato_array['PROPINA'])?$conf_formato_array['PROPINA']:0);
            $data['empresa']     = (isset($conf_formato_array['EMPRESA'])?$conf_formato_array['EMPRESA']:'');
            $data['SUBSIDIO']    = (isset($conf_formato_array['SUBSIDIO'])?$conf_formato_array['SUBSIDIO']:0);
            $data['size_letra']  = 6;
            $data['producto_maximo'] = (isset($conf_formato_array['PRODUCTO_MAXIMO']) ? $conf_formato_array['PRODUCTO_MAXIMO'][$facturas[0]['fac_id_tif']]['MAX_CARACTER'] : "");
            $data['default_products'] = (isset($conf_formato_array['DEFAULT_PRODUCTS'])?$conf_formato_array['DEFAULT_PRODUCTS']:[]);
            $datos_cajero = $this->facturacion_model->get_nombre_cajero_factura($consulta_factura['fac_id']);
            $data['cajero_name'] = $datos_cajero[0]['cajero'];
            $data['cajero_docs'] = $datos_cajero[0]['dui_cajero'];
            $fecha_factura = "";
            if ( isset($conf_formato_array['SIZE_LETRA']) != ''){ // Se verifica si existe la variable en la tabla frf
                $data['size_letra'] = $conf_formato_array['SIZE_LETRA'];
            }
            //verificar si hay promo de ticket
            if (isset($conf_formato_array['TICKET']) && $conf_formato_array['TICKET'] > 0) {
                $fecha_actual = date('Y-m-d');
                $fecha_factura = $data['datos_factura'][0]["fac_fecha_fact"];
                $where_rifa["crf_estado"] = 1;
                $where_rifa["DATE(crf_fecha_inicio) <= "] = $fecha_actual;
                $where_rifa["DATE(crf_fecha_fin) >= "] = $fecha_actual;
                $rifa = $this->gsatelite->get_tabla("crf_configuracion_rifa", $where_rifa );
                if ( count($rifa) > 0 && isset($conf_formato_array['TACO']) && $conf_formato_array['TACO'] != "" && $data['datos_factura'][0]["fac_total"] >= $rifa[0]["crf_monto_inicio"]) {
                    $data["rifa"] = $rifa;
                    $html_rifa = $this->load->view('facturacion/facturar/'.$conf_formato_array['TACO'], $data, true);
                }
            }
            $data['return_html'] = $return_html;
            $data['tipo'] = $tipo;
            $date1 = new DateTime($fecha_factura);
            $date2 = new DateTime($data['datos_factura'][0]["fac_fecha_vencimiento"]);
            $diff = $date1->diff($date2);
            $data['dias_plazo'] = $diff->days;
            // var_dump($tipo_pago[0]['frf_archivo']);die();
            // var_dump($data);die();
            
            $html .= $this->load->view('facturacion/facturar/'.$tipo_pago[0]['frf_archivo'], $data, true);
            $html .= $html_rifa;
            $contador_facturas++;
            $html .= ($contador_facturas  < $cantidad_facturas)? '<br style="page-break-after: always;" />': '';
        }
        $js = "print(true)"; // Se ejecuta la mpresión al cargar el PDF.
        if(!$return_html){
            $this->pdf->IncludeJS($js);
        }
        if(isset($conf_formato_array['SETCELLPADDINGS']) != '' OR isset($conf_formato_array['FORMATO']) != ''){
            $orientacion = $conf_formato_array['ORIENTACION'];
            $formato = $conf_formato_array['FORMATO'];
            if($return_html == true && $tipo == 1){
                $formato = $conf_formato_array['FORMATO_POS'];
            }
            $formato_array = explode(",",$formato); // Convierte el formato a array por si se quiere un formato personalizado de pagina
            $fuente = "helvetica";
            if ( isset($conf_formato_array['SETCELLPADDINGS']) != '' ){
                $setCellPaddings = $conf_formato_array['SETCELLPADDINGS'];
            }
            if ( isset($conf_formato_array['FUENTE']) != ''){// Verifica si existe el tiempo de fuente, ejemplo: calibrib.
                $fuente = $conf_formato_array['FUENTE'];
            }
            $margins = $conf_formato_array['MARGINS'];
            // Verificar si es ticket que sera imprimido
            if (isset($conf_formato_array['TICKET']) && $conf_formato_array['TICKET']>0 && count($formato_array) > 1) {
                // Cantidad de productos
                $cantidad_productos = count($data['datos_factura']);
                // Calcular la cantidad de altura que se sumara
                $cant_pro_px = $cantidad_productos * 9;
                // Asignar el formato
                $formato = array(0=>$formato_array[0], 1=>($formato_array[1]+$cant_pro_px));
            } else {
                $formato = (count($formato_array) > 1)?$formato_array:$formato;//si tiene mas de un elemento se toma el array y si no el valor del formato
            }
                // print_r($conf_formato_array['PRODUCTO_MAXIMO'][$facturas[0]['fac_id_tif']]['MAX_CARACTER']);
                // print_r($fecha_factura);
                // print_r($conf_formato_array['MARGINS']);
                // die();
            $this->pdf->setPrintHeader(false);
            $this->pdf->SetFont($fuente);
            $this->pdf->setCellPaddings($setCellPaddings);
            $this->pdf->SetAutoPageBreak(true, 0);
            if (phpversion() > 6) {
                $m = explode(',', $margins); /// $margins = "0,0,0" pero lo toma como un solo valor
                $this->pdf->SetMargins($m[0],$m[1],$m[2]);
            } else {
                $this->pdf->SetMargins($margins);
            }            
            $this->pdf->AddPage($orientacion, $formato, array('family' => $fuente, 'style' => '', 'size' => 6) , true);
            $this->pdf->setPrintFooter(false);
            $this->pdf->writeHTML($html, true, false, false, false, '');
            if($return_html) {
                //Si es por peticion de WebServices se retorna el HTML por JSON
                if($tipo == 1 && $return_html == true){
                    $html = $this->pdf->boletaPDF('E'); //return $html;
                    echo "jsonPHP".preg_replace("/\xEF\xBB\xBF/", "", json_encode(array('html' => preg_replace( "/\r|\n/", "", $html))));
                }
            } else {
                $this->pdf->boletaPDF('I');
            }
        } else{
            if($return_html) {
                return $html;
            }
            $this->pdf->setPrintFooter(false);
            $this->pdf->makePDF($html, $conf_formato_array['ORIENTACION'], null , 'Letter');
        }
    }

    /**
     * @author René Castaneda
     * @return devuelve los datos del producto
     */
    function productos_select2Ajax() { //peticion por ajax
        if ($this->input->get('criterio')) {
            $valor = $this->input->get('criterio'); //termino o criterio de busqueda
            $consulta = $this->facturacion_model->get_productosLike($valor);
        }
        echo json_encode($consulta);
    }

    function cargar_correlativo() {
        $id_serie = $this->input->post("serie_id");
        $caja = $this->input->post("caja");
        $correlativosxc = $this->facturacion_model->correlativos_x_cajas($id_serie, $caja);

        $corre_select = '<option value=""></option>';
        foreach ($correlativosxc as $corre) {
            $numfinal = ($corre['cxj_fin'] < 0) ? 'Ilimitado' : $corre['cxj_fin']; 
            $corre_select .= '<option value="' . $corre['cxj_id'] . '" selected>' . $corre['cxj_inicio'] . ' - ' . $numfinal . '</option>';
        }
        $botonnn = '<input type="hidden" name="id_cof_" id="id_cof_" value="' . $correlativosxc[0]['cof_id'] . '">';
        $datos["series"] = $corre_select;
        // echo $datos['series'];
        echo json_encode(array('series' => $corre_select, 'botonnn' => $botonnn));
        //  echo $datos["ppppp"];
    }

    function comprobar_correlativo() {
        $id_correlativo = $this->input->post("id");
        $id_serie = $this->input->post("id_serie");
        $campo = $this->gsatelite->get_campo('cof_correlativo_factura', 'cof_inicio', array('cof_id_sef' => $id_serie, 'cof_inicio' => $id_correlativo, 'cof_fin' => $id_correlativo, 'cof_estado' => 1));
        if (!empty($campo)) {
            echo json_encode(array('drop' => $campo));
        } else {
            echo json_encode(array('drop' => 0));
        }
    }

    function correlativo_siguiente() {
        $inicio = $this->input->post("inicio");
        $fin = $this->input->post("fin");
        $id_serie = $this->input->post("id_serie");
        $cor = $this->input->post('id_corr');
        $id_cxj = $this->input->post('id_cxj');
        $caj_id = $this->input->post('caj_id');

        //		print_r($_POST);
        $uxj_id = $this->input->post('uxj_id');

        $siguiente = $this->facturacion_model->get_new_correlativo($inicio, $fin, $id_serie, 0, $cor, $id_cxj, $caj_id, $uxj_id);

        //die(print_r($this->db->last_query()));
        //die(print_r($siguiente));
        if (!empty($siguiente)) {
            echo json_encode(array('drop' => $siguiente[0]['cor_actual']));
        } else {
            echo json_encode(array('drop' => 0));
        }
    }

    /**
     * @author René Castaneda
     * @return devuelve un select con los productos correspondientes a una serie
     */
    function productos_categoria() { //peticion por ajax
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('idCat');
            $posee = false; //posee productos (bandera)
            $select_productos = "";
            if ($id > 0) {
                //preguntar si el producto posee series
                $pregunta = $this->gsatelite->get_tabla('art_articulo', array('art_id_tia' => $id, 'art_venta' => 1, 'art_estado' => 1));
                if (count($pregunta) > 0) {
                    $posee = true;
                    $select_productos = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} :: {art_nombre}', 'select_pro2', array('art_id_tia' => $id, 'art_venta' => 1, 'art_estado' => 1), null, '  id="select_pro2" class="nostyle"');
                    $select_productos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select_productos);
                }
                echo json_encode(array('posee' => $posee, 'select_producto' => $select_productos));
            }
        }
    }

    /**
     * @author Melbin Cruz
     * @return Devuelve un select con los productos de una bodega en particular
     */
    public function obtener_hijos_cat() {
        $padre = $this->input->post('padre');
        $bodega = $this->input->post('bodega');
        $pantalla = $this->input->post('pantalla');
        $this->db->where('tia_padre', $padre);
        $hijos = $this->db->get('tia_tipo_articulo')->result_array();
        $cadena = "<option value='0' selected>Seleccione una opción</option>";
        foreach ($hijos as $key => $value) {
            $cadena .= '<option value="' . $value['tia_id'] . '">' . $value['tia_nombre'] . '</option>';
        }

        $var = '<option value="0"> Seleccione una opción </option>';
        $consulta = $this->gsatelite->get_tabla('bod_bodega', array('bod_id' => $bodega));
        $tipo_bodega = $consulta[0]['bod_tipo_bodega'];
        if ($pantalla == "entrada") {
            $articulos = $this->inventario_model->artxcategorias($bodega, $padre, $pantalla, true);
        } else if ($pantalla == "salida") {
            $articulos = $this->inventario_model->artxcategorias($bodega, $padre, $pantalla, true);
            //$articulos = $this->inventario_model->get_productos_bodega_cantidad_salida($bodega,$padre);
        }

        //print_r($this->db->last_query());exit();



        $etiqueta = 0;
        foreach ($articulos as $fila) {
            if ($pantalla == "salida") {
                $var .= "<option precio='" . $fila['precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "' name='" . (string) $fila['sar_cant_actual'] . "'>" . $fila['art_codigo'] . " | " . $fila['art_nombre'] . ' (' . $fila['sar_cant_actual'] . ')' . "</option>";
                $etiqueta++;
            }
        }
        if (count($hijos) == 0) {
            $cadena = "";
        }
        if (count($articulos) == 0) {
            $var = "";
        }
        $arreglo = array('drop' => $cadena, 'producto' => $var, 'padre' => $padre);
        echo json_encode($arreglo);
    }

    /**
     * @author René Castaneda
     * @return devuelve un modal para el ingreso de los productos
     */
    function detalles_factura_modal() { //peticion por ajax
        $id_art = $this->input->post('producto');
        $id_cli = $this->input->post('cliente');
        $art = $this->gsatelite->get_tabla("art_articulo", array('art_id' => $id_art));

        $impuestos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));

        if ($id_cli > 0) {
            $prueba = $this->facturacion_model->impuesto_cliente($id_cli);

            //die(print_r($prueba));
            $seleccionados = array();
            foreach ($prueba as $f) {
                $seleccionados[] = $f['ixc_id_cli'];
            }
            $sum = array_sum($seleccionados);
            //die(print_r($seleccionados));
            foreach ($prueba as $f) {
                if ($sum > 0) {
                    if ($f['ixc_id_cli'] > 0) {
                        $selected = 'selected';
                    } else {
                        $selected = '';
                    }
                }

                if ($sum <= 0) {
                    if ($selected == '' && $f['imp_defecto'] == 1 && $f['ixc_id_cli'] == '') {
                        $defecto = 'selected';
                    } else {
                        $defecto = '';
                    }
                }

                if ($selected == '') {
                    $result = $defecto;
                } else {
                    $result = $selected;
                }

                $display = $f['imp_nombre'] . ' (' . $f['imp_porcentaje'] . ' % )';
                $opciones .= '<option value="' . $f['imp_id'] . '" id_imp="' . $f['ixc_id_imp'] . '" porcentaje="' . $f['imp_porcentaje'] . '" ' . $result . '  >' . $display . '</option>';
            }
        }

        $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), null, '', 'tpg_id', true);
        $data["tipos_pago"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_pago);

        $data["nombre"] = $art[0]['art_nombre'];
        $data["codigo"] = $art[0]['art_codigo'];
        $data["id"] = $art[0]['art_id'];
        $data["impuestos"] = $impuestos;
        $data["opciones"] = $opciones;
        $this->load->view('facturacion/facturar/detalles_factura_modal', $data);
    }

    function info_articulo($id = null) {


        $id_grupo = $this->gsatelite->get_campo('gra_grupo_academico', 'gra_id', array('gra_id_art' => $id));

        $data['grupos'] = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id' => $id_grupo));
        $data['docente'] = $this->facturacion_model->docente_grupo($id_grupo);
        $data['modulo'] = $this->facturacion_model->modulo_grupo($id_grupo);
        $data['hora'] = $this->facturacion_model->horario_grupo($id_grupo);
        $data['unidades'] = $this->facturacion_model->unidades_grupo($id_grupo);
        //  print_r($this->db->last_query());

        $this->load->view('facturacion/facturar/detalle_articulo_modal', $data);
    }

    function aplica_descarga($id_articulo = null, $cantidad = null, $tipo = null, $combo_val = 0, $combo_productos_val = null, $combo_cantidades_val = null, $bod_id_val = null) {
        $combo = 0;
        $bod_id = 0;
        $cantidad_inv = 0;
        
        if ($id_articulo == null) {
            $id_articulo = $this->input->post('art_id');
            $bod_id = $this->input->post('bodegas');
            $cantidad = $this->input->post('cant_sol');
            $combo = $this->input->post('combo');
            $combo_productos = $this->input->post('combo_productos');
            $combo_cantidades = $this->input->post('combo_cantidades');
        }
        if($combo_val != 0){
            $bod_id = $bod_id_val;
            $combo = $combo_val;
            $combo_productos = $combo_productos_val;
            $combo_cantidades = $combo_cantidades_val;
        }
        $descarga_aplica = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
        $factura_aplica = $this->gsatelite->get_parametro_emp('SYS_FACTURA_SN_EXIST');
        $bodega_factura = ($bod_id > 0)?$bod_id:$this->gsatelite->get_campo('uxb_usuarioxbodega', 'uxb_id_bod', array('uxb_id_usu' => $this->tank_auth->get_user_id(), 'uxb_defecto'=>1));
        //print_r($bodega_factura);exit();die();
        $combo_cantidad_actual = array();
        if($combo == 1){ //caso cuando venga tipo combo
            $combo_productos_array = explode(',', $combo_productos); //separamos los ids que mandamos por ajax
            $combo_cantidades_array = explode(',', $combo_cantidades); // tambien las cantidades
            foreach ($combo_productos_array as $key) { //recorremos los productos para verificar sus existencias
                $combo_cantidad_actual_temp = $this->facturacion_model->get_articulos('sar_saldo_articulo', array('sar_id_art' => $key, 'sar_id_bod' => $bodega_factura));

                $combo_cantidad_actual_temp = (trim($combo_cantidad_actual_temp) != '')?$combo_cantidad_actual_temp:0;
                $combo_cantidad_actual[] = $combo_cantidad_actual_temp; // guardamos la existencia actual de cada producto del combo
                $cantidad_inv = ($combo_cantidad_actual_temp > $cantidad_inv)?$combo_cantidad_actual_temp:$cantidad_inv; //comparamos cual de todas las cantidades es mayor
            }
            //echo $cantidad_inv.'<br>';
            for($x = 0; $x < count($combo_cantidad_actual); $x++){ //recorremos el arreglo para hacer el calculo
                $cantidad_producir = (float)$combo_cantidad_actual[$x]/((float)$combo_cantidades_array[$x]) ; //dividimos la cantidad actual en bodega y la dividimos entre la cantidad q requiere el combo y multiplicado por la cantidad solicitada

                $cantidad_inv = ((float)$cantidad_producir < (float)$cantidad_inv)?floor($cantidad_producir):floor($cantidad_inv); //verificamos quien es el menor para saber cuantos combos tenemos en si.

                //echo (float)$combo_cantidad_actual[$x].'/'.(float)$combo_cantidades_array[$x].'='.$cantidad_producir.'menor'.$cantidad_inv;
            }
        } else{
            $bodega_factura = (is_null($bodega_factura) && $bod_id_val > 0) ? $bod_id_val : $bodega_factura;
            $cantidad_inv = $this->facturacion_model->get_articulos('sar_saldo_articulo', array('sar_id_art' => $id_articulo, 'sar_id_bod' => $bodega_factura));
        }

                            $this->db->order_by('tip_id', 'ASC')->limit(1);
        $id_proceso_padre = $this->gsatelite->get_campo('tip_tipo_proceso', 'tip_id_tip_entrada', array('tip_facturacion' => 1, 'tip_estado' => 1));
        $tipo_proceso = $this->facturacion_model->get_tipo_proceso('dee_detalle_mov', array('dee_id_art' => $id_articulo, 'moi_id_tip' => $id_proceso_padre, 'tip_estado' => 1));
        $para_inventario = $this->gsatelite->get_campo('art_articulo', 'art_inventario', array('art_id' => $id_articulo));
        $detalle_articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_articulo));
        $regresar = array();
        // var_dump( $descarga_aplica, $factura_aplica, $cantidad_inv, $id_proceso_padre );die();
        /* EN BASE AL PARAMETRO FACTURA/REMISIONES 0=NO/NO(FIJO), 1=SI/SI(FIJO), 2=OPCIONAL/OPCIONAL(EDITABLE), 3=NO/SI(FIJO)??? */
        if ($descarga_aplica == 0) {
            // NO APLICA Y NO SE PUEDE CAMBIAR
            $regresar = array('aplica' => 2);
        } else {
            if ($factura_aplica == 1) {
                if ($descarga_aplica == 1) { 
                    if ($cantidad <= floatval($cantidad_inv)) {
                        $regresar = array('aplica' => 1); //aplica la descarga normal si hay productos
                    } else {
                        $regresar = array('aplica' => 2); //No hay inventario
                    }
                } else {
                    $regresar = array('aplica' => 2); //aplica la descarga sin existencias
                }
                //echo json_encode(array('aplica' => 2));
            } else {
                if (floatval($cantidad_inv) == 0) {
                    $regresar = array('aplica' => 4); // no hay productos en bodega
                } else {
                    if ($descarga_aplica == 0) {
                        // No descargar de Inventario, pero hace factura solo si hay en existencias.
                        //die(print_r('aplica 0 fac 1'));
                        if ($cantidad <= floatval($cantidad_inv)) {
                            $regresar = array('aplica' => 2);
                        } else {
                            $regresar = array('aplica' => 0);
                        }
                    } else {
                        //modifica en mxf_movimientoxfac
                        //die(print_r('aplica 1 fac 0'));
                        if ($cantidad <= floatval($cantidad_inv)) {
                            $regresar = array('aplica' => 1); //se hara la descarga de inventario
                        } else {
                            $regresar = array('aplica' => 0); //no hay productos necesarios para agregar a la factura
                        }
                    }
                }
            }
        }

        if(count($detalle_articulo) > 0){
            if($detalle_articulo[0]['art_tipo'] == 1){
                $regresar = array('aplica' => 1);
            }
        }



        if ($tipo != null) {
            return $regresar;
        } else {
            echo json_encode($regresar);
        }
    }

    function aplica_descarga_grid($id_articulo = null, $cantidad = null, $tipo = null) {//////////////////////////////////////////PDTE
        $combo = 0;
        $cantidad_inv = 0;
        if ($id_articulo == null) {
            $id_articulo = $this->input->post('art_id');
            $bod_id = $this->input->post('bodegas');
            $cantidad = $this->input->post('cant_sol');
            $combo = $this->input->post('combo');
            $combo_productos = $this->input->post('combo_productos');
            $combo_cantidades = $this->input->post('combo_cantidades');
        }

        $descarga_aplica = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
        $factura_aplica = $this->gsatelite->get_parametro_emp('SYS_FACTURA_SN_EXIST');
        $bodega_factura = ($bod_id > 0)?$bod_id:$this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');



        $combo_cantidad_actual = array();
        if($combo == 1){ //caso cuando venga tipo combo
            $combo_productos_array = explode(',', $combo_productos); //separamos los ids que mandamos por ajax
            $combo_cantidades_array = explode(',', $combo_cantidades); // tambien las cantidades


            foreach ($combo_productos_array as $key) { //recorremos los productos para verificar sus existencias
                $combo_cantidad_actual_temp = $this->facturacion_model->get_articulos('sar_saldo_articulo', array('sar_id_art' => $key, 'sar_id_bod' => $bodega_factura));

                $combo_cantidad_actual_temp = (trim($combo_cantidad_actual_temp) != '')?$combo_cantidad_actual_temp:0;
                $combo_cantidad_actual[] = $combo_cantidad_actual_temp; // guardamos la existencia actual de cada producto del combo
                $cantidad_inv = ($combo_cantidad_actual_temp > $cantidad_inv)?$combo_cantidad_actual_temp:$cantidad_inv; //comparamos cual de todas las cantidades es mayor
            }
            //echo $cantidad_inv.'<br>';
            for($x = 0; $x < count($combo_cantidad_actual); $x++){ //recorremos el arreglo para hacer el calculo
                $cantidad_producir = (float)$combo_cantidad_actual[$x]/((float)$combo_cantidades_array[$x]) ; //dividimos la cantidad actual en bodega y la dividimos entre la cantidad q requiere el combo y multiplicado por la cantidad solicitada

                $cantidad_inv = ((float)$cantidad_producir < (float)$cantidad_inv)?floor($cantidad_producir):floor($cantidad_inv); //verificamos quien es el menor para saber cuantos combos tenemos en si.

                //echo (float)$combo_cantidad_actual[$x].'/'.(float)$combo_cantidades_array[$x].'='.$cantidad_producir.'menor'.$cantidad_inv;
            }
        } else{
            $cantidad_inv = $this->facturacion_model->get_articulos('sar_saldo_articulo', array('sar_id_art' => $id_articulo, 'sar_id_bod' => $bodega_factura));
        }

        $this->db->order_by('tip_id', 'ASC')->limit(1);
        $id_proceso_padre = $this->gsatelite->get_campo('tip_tipo_proceso', 'tip_id_tip_entrada', array('tip_facturacion' => 1, 'tip_estado' => 1));

        $tipo_proceso = $this->facturacion_model->get_tipo_proceso('dee_detalle_mov', array('dee_id_art' => $id_articulo, 'moi_id_tip' => $id_proceso_padre, 'tip_estado' => 1));
        $para_inventario = $this->gsatelite->get_campo('art_articulo', 'art_inventario', array('art_id' => $id_articulo));

        $regresar = array();

        if ($descarga_aplica == 0) {
            $regresar = array('aplica' => 2);
        } else {
            if ($factura_aplica == 1) {
                if ($descarga_aplica == 1) {
                    if ($cantidad <= intval($cantidad_inv)) {
                        $regresar = array('aplica' => 1); //aplica la descarga normal si hay productos
                    } else {
                        $regresar = array('aplica' => 2); //No hay inventario
                    }
                } else {
                    $regresar = array('aplica' => 2); //aplica la descarga sin existencias
                }
                //echo json_encode(array('aplica' => 2));
            } else {
                if (intval($cantidad_inv) == 0) {
                    $regresar = array('aplica' => 4); // no hay productos en bodega
                } else {
                    if ($descarga_aplica == 1) { //modifica en mxf_movimientoxfac
                        if ($cantidad <= intval($cantidad_inv)) {
                            $regresar = array('aplica' => 1); //se hara la descarga de inventario
                        } else {
                            $regresar = array('aplica' => 0); //no hay productos necesarios para agregar a la factura
                        }
                        //die(print_r('aplica 1 fac 0'));
                    } else {   // No descargar de Inventario, pero hace factura solo si hay en existencias.
                        if ($cantidad <= intval($cantidad_inv)) {
                            $regresar = array('aplica' => 2);
                        } else {
                            $regresar = array('aplica' => 0);
                        }
                        //die(print_r('aplica 0 fac 1'));
                    }
                }
            }
        }



        if ($tipo != null) {
            return $regresar;
        } else {
            echo json_encode($regresar);
        }
    }

    /**
     * @author René Castaneda
     * @return devuelve el nombre del producto
     */
    function detalles_factura_modal_editar() { //peticion por ajax
        $data["descripcion"] = $this->input->post('descripcion');
        $data["codigo"] = $this->input->post('codigo');
        $data["cantidad"] = $this->input->post('cantidad');
        $data["precio"] = $this->input->post('precio');
        $data["id_fila"] = $this->input->post('id_fila');
        $data["foco"] = $this->input->post('foco');
        $data["producto"] = $this->input->post('producto_id');
        $data["impuestos"] = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));
        $arreglo = ($this->input->post('imp_selected') != "") ? explode(',', $this->input->post('imp_selected')) : array();
        $data["impuestos_selected"] = ($this->input->post('imp_selected') != "" and count($arreglo) <= 0 ) ? array($this->input->post('imp_selected')) : $arreglo;

        $tipo_pago = $this->input->post('tipo_pago');
        $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $tipo_pago, '', 'tpg_id', true);
        $data["tipos_pago"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_pago);
        // die(print_r($this->input->post('imp_selected')));
        $this->load->view('facturacion/facturar/detalles_factura_modal_editar', $data);
    }

    function descargar_pro_inventario() {
        $data['productos'] = $this->input->post('arreglo');
        $resultado = $data['productos'];
        $cadena = array();
        $productos_depurado = array();
        $cantidades_depurado = array();


        foreach ($resultado as $key => $value) {
            $cadena = explode(" ", $value);
            $productos_depurado = array_merge($productos_depurado, array($cadena[0]));
            $cantidades_depurado = array_merge($cantidades_depurado, array($cadena[1]));
        }
        $productos = $productos_depurado;
        $cantidades = $cantidades_depurado;

        echo json_encode(array('valores' => $productos));

        //	foreach ($data['productos'] as $key) {
        //echo json_encode(array('valores'=>$key));
        //	}
    }

    function salida_productos_movimiento($ajuste = null, $egreso = null, $proc_salida = null, $descript_ajuste = null, $factura = null) {

        $flag = 0;
        //Definicion de campos de una requisicion

        $access_moi = 0;
        //Bandera para especificar si se realizara al menos un movimiento, si alguna cantidad es diferente de cero.
        //variables de control (para guardar el id_del detalle y vincularlo con el correlativo indicado en el caso que aplique serie)
        //$arregloIDtrProductos = $this->input->post('ids_filaP'); //este arreglo solo llevará los ids de los tr de todos los productos
        //$arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie

        if ($ajuste == null) {
            //Campos generales
            $this->db->order_by('tip_id', 'ASC')->limit(1);
            $salida = $this->gsatelite->get_campo('tip_tipo_proceso', 'tip_id_tip_salida', array('tip_facturacion' => 1, 'tip_estado' => 1));
            $usuario = $this->tank_auth->get_user_id();
            $fecha = date("Y-m-d h:i:s", strtotime($this->input->post('fecha_fac')));
            $bodega = $this->gsatelite->get_parametro('SYS_BODEGA_FACTURA');
            ;

            $data['productos'] = explode(',', $this->input->post('arreglo'));
            $resultado = $data['productos'];

            $cadena = array();
            $productos_depurado = array();
            $cantidades_depurado = array();

            foreach ($resultado as $key => $value) {
                $cadena = explode(" ", $value);
                $productos_depurado = array_merge($productos_depurado, array($cadena[0]));
                $cantidades_depurado = array_merge($cantidades_depurado, array($cadena[1]));
                $access_moi = 1;
            }

            $productos = $productos_depurado;
            $cantidades = $cantidades_depurado;
            //	echo json_encode(array('valores'=>$productos));
        }

        if ($access_moi == 1) { //Si al menos se va a procesar un producto
            //Preparando variables para movimiento de salida
            $egresar_movimiento = array(
                'moi_id_bod' => $bodega,
                'moi_id_tip' => ($salida == '') ? NULL : $salida,
                'moi_fecha_mov' => $fecha,
                'moi_estado' => 1,
                'moi_usu_creacion' => $usuario,
                'moi_fecha_creacion' => date('Y-m-d h:i:s'),
                'moi_usu_modificacion' => $usuario,
                'moi_fecha_modificacion' => date('Y-m-d h:i:s'),
                'moi_descripcion' => NULL,
                'moi_documento' => NULL
            );

            $id_movimiento = $this->gsatelite->ingresar('moi_movimiento_inv', $egresar_movimiento);
            //Se ingresa un movimiento de salida

            /* Ingresar un registro a mxf_movimientoxfac */


            $arreglo_mxf = array(
                'mxf_id_fac' => $factura,
                'mxf_id_moi' => $id_movimiento,
                'mxf_tipo' => 1,
                'mxf_estado' => 1,
                'mxf_usu_mod' => $this->tank_auth->get_user_id(),
                'mxf_fecha_mod' => date("Y-m-d H:i:s")
            );

            $this->gsatelite->ingresar('mxf_movimientoxfact', $arreglo_mxf);

            $IDsMovimientos = array(); //este arreglo guardará todos los ids que se inserten del movimiento

            foreach ($productos as $key => $id_prod) {

                $saldos = $this->llamar_datos_row("sar_saldo_articulo", array('sar_id_art' => $productos[$key], 'sar_id_bod' => $bodega, 'sar_cant_actual !=' => 0), 'sar_id ASC');

                if (count($saldos) > 0) {
                    $puntero = 0;           //Inicia consulta de saldos
                    $final = count($saldos) - 1; //Limite de consulta de saldos
                    $cant_solicitada = $cantidades[$key];
                    //$ixc_id=$ixc[$key];
                    //$id_filaUnico = $arregloIDtrProductos[$key].'S'; //variable de control (indice del arreglo-que concuerdará con el id del tr de las series. y poder llevar el id del detalle correctamente)
                    //Funcion recursiva hasta acabar el pedido o cantidad=0
                    do {
                        $cant_restador = $this->procesar_saldos($usuario, $id_movimiento, $cant_solicitada, $saldos[$puntero]);
                        $cant_solicitada = $cant_solicitada - $cant_restador[0];
                        // $IDsMovimientos["$id_filaUnico"] = $cant_restador[1]; // la variable $cant_restador es un arreglo y en su posicion 1 trae el id del detalle insertado.
                        $puntero++;
                    } while (($puntero <= $final) && ($cant_solicitada > 0));
                } else {
                    $flag = 1;
                }
            }
        } else {

        }

        //REALIZAR los insert de los correlativos
        /*
          $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie
          $idsDetalles = $IDsMovimientos;

          $ids_productos=$this->input->post('producto_serie');
          $nom_series=$this->input->post('nombre_serie');
          $ini_correlativo=$this->input->post('iniC_serie');
          $fin_correlativo=$this->input->post('finC_serie');
          if(count($ids_productos)>0){
          for ($i=0; $i < count($ids_productos) ; $i++) {
          if($nom_series[$i]>0) { //condicionar que sea un id valido.
          $id_serie = $nom_series[$i];
          //preguntar por el id del detalle correcto
          $id_filaUnicoS = $arregloIDtrProductosSeries[$i];
          $idMovimientoSerie = $idsDetalles[$id_filaUnicoS]; //hacer referencia al key correcto.
          $insert_correlativo = array(
          'cor_id_ser'   =>$id_serie
          ,'cor_tipo'     =>2
          ,'cor_inicio'   =>$ini_correlativo[$i]
          ,'cor_fin'      =>$fin_correlativo[$i]
          ,'cor_estado'   =>1
          ,'cor_id_dee'   =>$idMovimientoSerie
          ,'cor_usu_mod'  =>$this->tank_auth->get_user_id()
          ,'cor_fecha_mod'=>date('Y-m-d H:i:s')
          );

          $id_correlativo = $this->gsatelite->ingresar('cor_correlativo',$insert_correlativo); //insertar del correlativo
          }

          }
          }
         */
        //FIN DEL SCRIPT QUE INSERTA LAS SERIES Y CORRELATIVOS

        /*
          if($ajuste==null){
          $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Salida de artículos",'texto_alerta'=>"El registro se guardó correctamente");

          $this->session->set_flashdata($alerta);

          redirect('/facturacion/facturar');
          }else{
          return $flag;
          }
         */
        //}
    }

    public function ingresar_productos_movimiento($ajuste = null, $ingreso = null, $proc_entrada = null, $descript_ajuste = null, $factura = null) {
        //var_dump($ingreso); die();
        $flag = 0; //Bandera de error
        $parametro = $_POST['parametro'];
        //variables de control (para guardar el id_del detalle y vincularlo con el correlativo indicado en el caso que aplique serie)
        $arregloIDtrProductos = $this->input->post('ids_filaP'); //este arreglo solo llevará los ids de los tr de todos los productos
        $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie


        if ($ajuste == null) {
            $entrada = $_POST['tipo_transaccion'];
            $usuario = $this->tank_auth->get_user_id();
            $bodega = $_POST['bodega'];
            $proveedor = $_POST['proveedor'];
            $fecha = date('Y-m-d h:i:s');
            $documento = $_POST['documento'];


            $descripcion = $_POST['descripcion_requisicion'];

            //$caducidad = $_POST['caducidad'];
            $productos = $_POST['productos'];
            $cantidades = $_POST['cantidad'];
            $retaceo = $_POST['retaceo'];
            if ($_POST['retaceo'] == '') {
                $precios = $_POST['precios'];
            } else {
                $precios = $_POST['precios1'];
            }

            $p1 = $_POST['p1'];
            $u1 = $_POST['u1'];
            $p2 = $_POST['p2'];
            $u2 = $_POST['u2'];
            $p3 = $_POST['p3'];
            $u3 = $_POST['u3'];
            $p4 = $_POST['p4'];
            $u4 = $_POST['u4'];
            $p5 = $_POST['p5'];
            $u5 = $_POST['u5'];
            $n1 = $_POST['nombre_precio1'];
            $n2 = $_POST['nombre_precio2'];
            $n3 = $_POST['nombre_precio3'];
            $n4 = $_POST['nombre_precio4'];
            $n5 = $_POST['nombre_precio5'];
            $caja = $_POST['caja'];
            $furgon = $_POST['furgon'];
            $cantxcaja = $_POST['cantxcaja'];
        } else {

            $entrada = $proc_entrada;

            $usuario = $this->tank_auth->get_user_id();

            $bodega = $ingreso[2];




            $fecha = date("Y-m-d H:i:s");
            $documento = '';
            $descripcion = $descript_ajuste;

            //$productos1 = $ingreso[0];

            $productos = $ingreso[0];
            $cantidades = $ingreso[1];

            $precios = array();

            foreach ($productos as $key => $id_prod) {//Conociendo los precios de cada producto
                //$id_prod=$this->db->select('art_id')->where('art_codigo',$id_prod)->get('art_articulo')->result_array();
                $saldos = $this->llamar_datos_row("sar_saldo_articulo", array('sar_id_art' => $productos[$key], 'sar_id_bod' => $bodega/* ,'sar_cant_actual !='=>'0' */), 'sar_id ASC');

                if (count($saldos) > 0) {
                    $precios = array_merge($precios, array($saldos[0]['sar_precio']));
                } else {
                    $flag = 1;
                }
            }
            /* $productos=array();
              foreach ($productos1 as $key => $id) {
              $id_producto=$this->db->select('art_id')->where('art_codigo',$id)->get('art_articulo')->result_array();
              array_push($productos,$id_producto[0]['art_id']);
              } */
        }


        if ($flag == 0) {
            //en este punto se realizara la insercion del movimiento
            ( $proveedor == 0 ) ? $proveedor = NULL : $proveedor;
            if (!empty($retaceo)) {

                $ingresar_movimiento = array(
                    'moi_retaceo' => $retaceo,
                    'moi_id_bod' => $bodega,
                    'moi_id_tip' => $entrada,
                    'moi_documento' => $documento,
                    'moi_fecha_mov' => $fecha,
                    'moi_usr_mod' => $usuario,
                    'moi_fecha_mod' => date("Y-m-d H:i:s"),
                    'moi_descripcion' => $descripcion,
                    'moi_id_prv' => $proveedor
                );
            } else {
                $ingresar_movimiento = array(
                    'moi_id_bod' => $bodega,
                    'moi_id_tip' => $entrada,
                    'moi_documento' => $documento,
                    'moi_fecha_mov' => $fecha,
                    'moi_usr_mod' => $this->tank_auth->get_user_id(),
                    'moi_fecha_mod' => date("Y-m-d H:i:s"),
                    'moi_descripcion' => $descripcion,
                    'moi_id_prv' => $proveedor
                );
            }

            $id_movimiento = $this->gsatelite->ingresar('moi_movimiento_inv', $ingresar_movimiento);

            $ingresar_movxfactura = array(
                'mxf_id_fac' => $ingreso[3],
                'mxf_id_moi' => $id_movimiento,
                'mxf_tipo' => 2,
                'mxf_estado' => 1,
                'mxf_usu_mod' => $this->tank_auth->get_user_id(),
                'mxf_fecha_mod' => date('Y-m-d H:i:s')
            );

            $registrar = $this->gsatelite->ingresar('mxf_movimientoxfact', $ingresar_movxfactura);
            // Modificar campos de Factura para la anulacion

            $this->facturacion_model->anular_factura($ingreso[3], $fecha, $descript_ajuste);

            //este bucle repetitivo nos servira para guardar todos los productos anexados a la compra
            $IDsMovimientos = array(); //este arreglo guardará todos los ids que se inserten
            foreach ($productos as $key => $id_prod) {
                $id_cant = $cantidades[$key];
                $id_precio = $precios[$key];
                $id_cantxcaja = $cantxcaja[$key];

                if (isset($caducidad)) {
                    $id_caducidad = date('Y-m-d', strtotime($caducidad[$key])); // date('Y-m-d h:i:s', strtotime($_POST['caducidad']));
                }
                if (isset($caja)) {
                    $id_caja = $caja[$key];
                }

                if (isset($furgon)) {
                    $id_furgon = $furgon[$key];
                }

                if (isset($p1)) {
                    $id_precio_venta1 = $p1[$key];
                }
                if (isset($u1)) {
                    $id_unidad_medida1 = $u1[$key];
                }

                if (isset($p2)) {
                    $id_precio_venta2 = $p2[$key];
                }

                if (isset($u2)) {
                    $id_unidad_medida2 = $u2[$key];
                }

                if (isset($p3)) {
                    $id_precio_venta3 = $p3[$key];
                }
                if (isset($u3)) {
                    $id_unidad_medida3 = $u3[$key];
                }
                if (isset($p4)) {
                    $id_precio_venta4 = $p4[$key];
                }
                if (isset($u4)) {
                    $id_unidad_medida4 = $u4[$key];
                }
                if (isset($p5)) {
                    $id_precio_venta5 = $p5[$key];
                }
                if (isset($u5)) {
                    $id_unidad_medida5 = $u5[$key];
                }
                if (isset($n1)) {
                    $id_nombre_precio1 = $n1[$key];
                }
                if (isset($n2)) {
                    $id_nombre_precio2 = $n2[$key];
                }
                if (isset($n3)) {
                    $id_nombre_precio3 = $n3[$key];
                }
                if (isset($n4)) {
                    $id_nombre_precio4 = $n4[$key];
                }
                if (isset($n5)) {
                    $id_nombre_precio5 = $n5[$key];
                }

                // Esta parte no cuenta aca.
                /*
                  if($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 0){
                  $ingresar_saldo = array(
                  'sar_id_art'       =>$id_prod,
                  'sar_id_bod'       =>$bodega,
                  'sar_cant_actual'  =>$id_cant,
                  'sar_precio'       =>$id_precio
                  );

                  $id_saldo = $this->gsatelite->ingresar('sar_saldo_articulo',$ingresar_saldo);
                  }
                  else
                  { */

                $saldo_actual = $this->db->select()
                                ->from('sar_saldo_articulo')
                                ->where('sar_id_art', $id_prod)
                                ->where('sar_id_bod', $bodega)
                                ->get()->result_array();

                if (empty($saldo_actual)) {
                    $precio_actual = 0;
                    $sar_cant_actual = 0;
                } else {
                    $sar_cant_actual = $saldo_actual[0]['sar_cant_actual'];
                    $precio_actual = ($saldo_actual[0]['sar_cant_actual']) * ($saldo_actual[0]['sar_precio']);
                }

                $precio_entrada = $id_cant * $id_precio;
                $cantidad_existencia = $sar_cant_actual + ($id_cant);
                $suma_precios = $precio_actual + $precio_entrada;
                $nuevo_precio = $suma_precios / $cantidad_existencia;

                $ingresar_saldo = array(
                    'sar_id_art' => $id_prod,
                    'sar_id_bod' => $bodega,
                    'sar_cant_actual' => $cantidad_existencia,
                    'sar_precio' => $nuevo_precio,
                    'sar_fecha_caducidad' => null,
                    'sar_usu_mod' => $this->tank_auth->get_user_id(),
                    'sar_fecha_mod' => date('Y-m-d H:i:s')
                );
                if (empty($saldo_actual)) {
                    $id_saldo = $this->gsatelite->ingresar('sar_saldo_articulo', $ingresar_saldo);
                } else {
                    $id_saldo1 = $this->db->where('sar_id', $saldo_actual[0]['sar_id'])->update('sar_saldo_articulo', $ingresar_saldo);
                    $id_saldo = $saldo_actual[0]['sar_id'];
                }

                //  }

                if ($ajuste == null && $parametro != 0) {
                    $ingresar_ixc = array(
                        'ixc_cantidad_caja' => $id_cantxcaja,
                        'ixc_contenedor' => $id_furgon,
                        'ixc_caja' => $id_caja,
                        'ixc_cantidad_actual' => $id_cant);
                    $id_ixc = $this->gsatelite->ingresar('ixc_ingresoxcontenedor', $ingresar_ixc);
                }


                $ingresar_detalle = array(
                    'dee_id_ixc' => $id_ixc,
                    'dee_id_moi' => $id_movimiento,
                    'dee_id_art' => $id_prod,
                    'dee_id_sar' => $id_saldo,
                    'dee_cantidad' => $id_cant,
                    'dee_precio' => $id_precio,
                    'dee_usr_mod' => $usuario,
                    'dee_fecha_mod' => date('Y-m-d h:i:s')
                );

                $id_detalle = $this->gsatelite->ingresar('dee_detalle_mov', $ingresar_detalle);
                $id_filaUnico = $arregloIDtrProductos[$key] . 'S'; //variable de control (indice del arreglo-que concuerdará con el id del tr de las series. y poder llevar el id del detalle correctamente)
                $IDsMovimientos["$id_filaUnico"] = $id_detalle;

                if (!empty($id_precio_venta1) && !empty($id_unidad_medida1) && !empty($id_nombre_precio1)) {

                    $ingresar_precios1 = array('pdv_id_sar' => $id_saldo,
                        'pdv_precio' => $id_precio_venta1,
                        'pdv_id_mep' => $id_unidad_medida1,
                        'pdv_nombre' => $id_nombre_precio1);
                    $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios1);
                }
                if (!empty($id_precio_venta2) && !empty($id_unidad_medida2) && !empty($id_nombre_precio2)) {
                    $ingresar_precios2 = array('pdv_id_sar' => $id_saldo,
                        'pdv_precio' => $id_precio_venta2,
                        'pdv_id_mep' => $id_unidad_medida2,
                        'pdv_nombre' => $id_nombre_precio2);
                    $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios2);
                }
                if (!empty($id_precio_venta3) && !empty($id_unidad_medida3) && !empty($id_nombre_precio3)) {
                    $ingresar_precios3 = array('pdv_id_sar' => $id_saldo,
                        'pdv_precio' => $id_precio_venta3,
                        'pdv_id_mep' => $id_unidad_medida3,
                        'pdv_nombre' => $id_nombre_precio3);
                    $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios3);
                }
                if (!empty($id_precio_venta4) && !empty($id_unidad_medida4) && !empty($id_nombre_precio4)) {
                    $ingresar_precios4 = array('pdv_id_sar' => $id_saldo,
                        'pdv_precio' => $id_precio_venta4,
                        'pdv_id_mep' => $id_unidad_medida4,
                        'pdv_nombre' => $id_nombre_precio4);
                    $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios4);
                }
                if (!empty($id_precio_venta5) && !empty($id_unidad_medida5) && !empty($id_nombre_precio5)) {
                    $ingresar_precios5 = array('pdv_id_sar' => $id_saldo,
                        'pdv_precio' => $id_precio_venta5,
                        'pdv_id_mep' => $id_unidad_medida5,
                        'pdv_nombre' => $id_nombre_precio5);
                    $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta', $ingresar_precios5);
                }
            }//end foreach
        }

        //REALIZAR EL INSERT DE LAS SERIES EN LOS PRODUCTOS A CUALES SE LES HA APLICADO.
        $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie
        $idsDetalles = $IDsMovimientos;

        $ids_productos = $this->input->post('producto_serie');
        $nom_series = $this->input->post('nombre_serie');
        $ini_correlativo = $this->input->post('iniC_serie');
        $fin_correlativo = $this->input->post('finC_serie');
        if (count($ids_productos) > 0) {
            for ($i = 0; $i < count($ids_productos); $i++) {
                if ($ids_productos[$i] > 0) { //condicionar que sea un id valido.
                    //preguntar por el id del detalle correcto
                    $id_filaUnicoS = $arregloIDtrProductosSeries[$i];
                    $idMovimientoSerie = $idsDetalles[$id_filaUnicoS]; //hacer referencia al key correcto.
                    $insert_serie = array(
                        'ser_id_art' => $ids_productos[$i]
                        , 'ser_nombre' => trim($nom_series[$i])
                        , 'ser_estado' => 1
                        , 'ser_fecha_mod' => date('Y-m-d H:i:s')
                        , 'ser_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_serie = $this->gsatelite->ingresar('ser_serie', $insert_serie); //insertar la serie

                    $insert_correlativo = array(
                        'cor_id_ser' => $id_serie
                        , 'cor_tipo' => 1
                        , 'cor_inicio' => $ini_correlativo[$i]
                        , 'cor_fin' => $fin_correlativo[$i]
                        , 'cor_estado' => 1
                        , 'cor_id_dee' => $idMovimientoSerie
                        , 'cor_usu_mod' => $this->tank_auth->get_user_id()
                        , 'cor_fecha_mod' => date('Y-m-d H:i:s')
                    );

                    $id_correlativo = $this->gsatelite->ingresar('cor_correlativo', $insert_correlativo); //insertar del correlativo
                }
            }
        }
        //FIN DEL SCRIPT QUE INSERTA LAS SERIES Y CORRELATIVOS
        if ($ajuste == null) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Entrada de artículos", 'texto_alerta' => "El registro se guardó correctamente");

            $this->session->set_flashdata($alerta);
            redirect('/inventario/gestion_productos/entrada_productos');
        } else {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Anulación de factura", 'texto_alerta' => "Anulación de factura exitosamente");

            $this->session->set_flashdata($alerta);
            redirect('facturacion/facturar/anular_factura');
        }
    }

    function llamar_datos_row($tabla, $where, $order) {
        $query = $this->inventario_model->cargar_todo($tabla, $where, $order);
        return $query;
    }

    function procesar_saldos($user, $id_mov, $cant_solic, $saldo_row, $ixc_id = null) {

        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
            $saldo_ixc = $this->db->select('ixc_cantidad_actual')->from('ixc_ingresoxcontenedor')->where('ixc_id', $ixc_id)->get()->result_array();
        }

        $cant_fila = $saldo_row['sar_cant_actual'];
        //Cantidad de productos segun PEPS actual

        $restador = null;
        //Cantidad de elementos restantes por procesar

        if ($cant_solic <= $cant_fila) {
            //Si hay suficientes elementos en la fila actual
            $restador = $cant_solic;

            $this->gsatelite->actualizar('sar_saldo_articulo', array('sar_cant_actual' => ($cant_fila - $cant_solic)), 'sar_id', $saldo_row['sar_id']);
            //Actualizando el saldo del articulo para la fila especifica
            if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') != 0) {
                $this->gsatelite->actualizar('ixc_ingresoxcontenedor', array('ixc_cantidad_actual' => ($saldo_ixc[0]['ixc_cantidad_actual'] - $cant_solic)), 'ixc_id', $ixc_id);
            }
        }

        if ($cant_solic > $cant_fila) {
            //Si no hay suficientes elementos en la fila
            $restador = $cant_fila;

            $this->gsatelite->actualizar('sar_saldo_articulo', array('sar_cant_actual' => 0), 'sar_id', $saldo_row['sar_id']);
            //Actualizando el saldo del articulo para la fila especifica
        }
        if ($this->gsatelite->get_parametro('INV_APLICA_FURGON') == 0) {
            $ixc_id = null;
        }


        $ingresar_detalle = array(
            //'dee_id_ixc' => $ixc_id,
            'dee_id_moi' => $id_mov,
            'dee_id_art' => $saldo_row['sar_id_art'],
            'dee_id_sar' => $saldo_row['sar_id'],
            'dee_cantidad' => $restador,
            'dee_precio' => $saldo_row['sar_precio'],
            'dee_subtotal' => ($restador * $saldo_row['sar_precio']),
            'dee_estado' => 1,
            'dee_usu_creacion' => $user,
            'dee_fecha_creacion' => date('Y-m-d h:i:s'),
            'dee_usu_modificacion' => $user,
            'dee_fecha_modificacion' => date('Y-m-d h:i:s')
        );

        $id_detalle_m = $this->gsatelite->ingresar('dee_detalle_mov', $ingresar_detalle);

        //Ingresando un nuevo detalle para el movimiento de salida actual

        return array($restador, $id_detalle_m);
    }

    function get_precio_producto() {
        $cantidad = $this->input->post('cantidad');
        $id_producto = $this->input->post('id_product');
        $consulta = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_art' => $id_producto));
        $precio = 0;
        foreach ($consulta as $f) {
            if ($cantidad >= $f['lip_desde'] and $cantidad <= $f['lip_hasta'] and $precio == 0) {
                $precio = $f['lip_precio'];
            }
        }
        echo json_encode(array('precio' => $precio));
    }

    function cliente_facturas() {
        $id_cliente = $this->input->post('cliente');

        $fxr_factura_remision = $this->gsatelite->get_tabla('fxr_factura_remisionxfactura');
        $remision_ids = implode(",", array_column($fxr_factura_remision,"fxr_id_fac_remision"));
        //print_r($remision_ids);die();

        $where = array(
            '(fac_estado=1 OR fac_estado=2)' => null,
            'fac_id_origen_devolucion IS NULL' => null,
            'fac_id_cli' => $id_cliente,
            'tif_aplica_anulacion'=>1
        );

        if($remision_ids != ''){
            $where["fac_id NOT IN ($remision_ids)"] = null;
        }


        //$facturas = $this->gsatelite->get_tabla('fac_factura', $where);
        $facturas = $this->facturacion_model->get_facturaxcliente($where);

        $html = '';
        foreach ($facturas as $value) {
            $html .= '<option value="'.$value['fac_id'].'">'.$value['tif_nombre'].' - Doc #: '.$value['fac_numero'].' - Fecha Doc:' .formatear_fecha('d-m-Y',$value['fac_fecha_fact']).'</option>';
        }

        // $select = $this->gsatelite->get_dropdown('fac_factura', '{fac_numero}-{fac_nombre_factura}', '', $where, null, '', 'fac_id', true);
        // $facturas = str_replace('<option value="0">Seleccione</option>', '', $select);

        // print_r($this->db->last_query());
        echo json_encode(array('drop' => $html));
    }

    function procesar_factura() {
        satelite_validar();
        if ($_POST) {
            die(print_r($_POST));
        } else {
            //$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
            //$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
            $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido} ', '', array('cli_estado' => 1), null, '', null, true);
            $data['titulo_personal'] = "Procesamiento de facturas";
            $this->_cargarvista($data);
        }
    }

    function facturas_detalle() {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '9999');

        $fecha_ini = $this->input->post('fecha_ini');
        $fecha_fin = $this->input->post('fecha_fin');

        $cliente = ($this->input->post('cliente') != '') ? $this->input->post('cliente') : null;
        //$documento= ($this->input->post('documento')!='')? $this->input->post('documento') : null;
        // '2016-02-01' BETWEEN DATE_FORMAT(pln_desde,"%Y-%m-%d") AND DATE_FORMAT(pln_hasta,"%Y-%m-%d" )

        if ($cliente != null) {
            $where = array('date_format(pln_desde,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_ini)),
                'date_format(pln_hasta,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_fin)),
                /* 'date_format(pxl_fecha_inicio,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($fecha_ini)), */
                /* 	 'date_format(pxl_fecha_fin,"%Y-%m-%d") >= '=>date('Y-m-d', strtotime($fecha_fin)), */
                'cli_id' => $cliente
            );
        } else {
            $where = array('date_format(pln_desde,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_ini)),
                'date_format(pln_hasta,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_fin)),
                    /* 'date_format(pxl_fecha_inicio,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($fecha_ini)),  */
                    /* 'date_format(pxl_fecha_fin,"%Y-%m-%d") >= '=>date('Y-m-d', strtotime($fecha_fin)) */
            );
        }
        // if($documento!=null){
        // 	$where['dcc_valor']=$documento;
        // }
        $fxp_facturaxplan = $this->gsatelite->get_tabla('fxp_facturaxplan_pago');

        $fxp_array = array_column($fxp_facturaxplan, 'fxp_id_fac');

        $hoy = date('Y-m-d');
        $date1 = date('Y-m-d', strtotime($fecha_ini));
        $date2 = date('Y-m-d', strtotime($fecha_fin));
        if ($date1 <= $hoy && $hoy <= $date2) { //Si la fecha actual esta entre el rango de fechas seleccionado
            $fecha_cargo = $hoy;      //se colocará la fecha actual al ingresar el cargo,
        } else {          //sino la última fecha del rango.
            $fecha_cargo = $date2;
        }

        $cargos_fijos = $this->facturacion_model->get_cargos_fijos($where, $date1, $date2);
        //registros de cargos fijos agrupados por servicio--
        // $cargos_fijos_pxl = $this->facturacion_model->get_cargos_fijos($where,null,1);
        //registros de cargos fijos agrupados por plan/promocion--




        $consumos = $this->facturacion_model->get_cargos_consumo($date1, $date2, $cliente); // registros de cargos por consumo
        //PARAMETROS TIPO DE CARGO
        $id_fijo = $this->gsatelite->get_parametro('SYS_CARGO_FIJO');
        $id_consumo = $this->gsatelite->get_parametro('SYS_CARGO_CONSUMO');

        if ($cliente != null) {
            $where_ad = array('date_format(fac_fecha_cont,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)), 'date_format(fac_fecha_cont,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)), 'cof_masivo' => 1, 'cli_id' => $cliente, 'fac_estado' => 1);
        } else {
            $where_ad = array('date_format(fac_fecha_cont,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)), 'date_format(fac_fecha_cont,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)), 'cof_masivo' => 1, 'fac_estado' => 1);
        }
        // $where_ad=array('date_format(fac_fecha_fact,"%Y-%m-%d") >='=>date('Y-m-d', strtotime($fecha_ini)), 'date_format(fac_fecha_fact,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($fecha_fin)), 'cof_masivo'=>1);
        /* if($documento!=null){
          $where_ad['dcc_valor']=$documento;
          } */

        $total_factura_bd = $this->facturacion_model->get_detalle_total_bd($where_ad); //Facturas ingresadas mediante el proceso masivo.
        //Array con sxc_numero para comparar arrays ($total_factura_bd).
        $factura_bd = array();
        $factura_id = array();
        // $factura_cli=array();
        if (count($total_factura_bd) > 0) {
            foreach ($total_factura_bd as $fbd) {
                $fact[] = $fbd['sxc_id'];
                $idfac[] = $fbd['fac_id'];
                $facli[] = $fbd['cli_id'];
            }
            $factura_bd = $fact;
            $factura_id = $idfac;
            //$factura_cli=$facli;
        }

        $total_factura = $this->facturacion_model->get_detalle_totalxcliente($date1, $date2, $id_fijo, $id_consumo, null, null, null, $cliente);

        //Creación de array con todos los tipos de facturas que se encuentran en $total_factura
        $tipos = array();

        foreach ($total_factura as $fac_cof => $fac) {
            $tipos[] = $fac['cli_id_tif'];
        }

        $tifs = $tipos;
        $tipos = array_count_values($tifs);

        /*         * ************************** Verificación de correlativos ********************************** */
        $siguiente = 0;
        foreach ($total_factura as $fact => $fac) {
            if ($fac['sxc_id'] == 0 || !in_array($fac['sxc_id'], $factura_bd)) {

                $tif = $fac['cli_id_tif'];
                $tif_nombre = $fac['tif_nombre'];

                $this->db->order_by('cof_inicio', 'desc');
                $this->db->limit(1);
                $this->db->join('sef_serie_factura', 'sef_id=cof_id_sef');
                $cof = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_estado' => 1, 'sef_id_tif' => $tif, 'cof_masivo' => 1));

                if (count($cof) > 0) {
                    //verificar disponibilidad y numero a asignar
                    foreach ($cof as $cf => $cor) {
                        $cof_fin = $cor['cof_fin'];
                        $cof_ini = $cor['cof_inicio'];
                        $cof_actual = $cor['cof_actual'];
                        $cof_id = $cor['cof_id'];

                        //$corr_utilizado=$this->facturacion_model->get_correlativo($cor['cof_inicio'],$cof_fin,$cor['sef_id'], 1); //Consulta de último correlativo utilizado
                        if ($cof_actual == 0) {
                            $ultimo = $cof_ini; // Último correlativo utilizado para este tipo de factura.
                        } else { // Se deja el correlativo de inicio del rango.
                            $ultimo = $cof_actual + 1;
                        }

                        if ($cof_actual < $cof_fin) {
                            $disp = $cof_fin - $cof_actual; // Disponibilidad de correlativos.
                            $cant_necesaria = $tipos[$cor['sef_id_tif']]; // Cantidad de correlativos necesarios para facturar.

                            if ($disp < $cant_necesaria) {
                                $this->gsatelite->actualizar_array('cof_correlativo_factura', array('cof_masivo' => 0), array('cof_id' => $cof_id));
                                echo json_encode(array('resultado' => 0, 'tipo' => $tif_nombre, 'disp' => 1)); //no hay suficientes correlativos
                                die();
                            }
                        } else {
                            $this->gsatelite->actualizar_array('cof_correlativo_factura', array('cof_masivo' => 0), array('cof_id' => $cof_id));
                            echo json_encode(array('resultado' => 0, 'tipo' => $tif_nombre, 'disp' => 1)); //no hay suficientes correlativos
                            die();
                        }
                    }
                } else {
                    echo json_encode(array('resultado' => 0, 'tipo' => $tif_nombre, 'disp' => 0));
                    die();
                }
            }
        }// end foreach $total_factura
        /*         * ************************************************************************************************************ */

        //$where_ad=array('date_format(caf_fecha,"%Y-%m-%d") >='=>date('Y-m-d', strtotime($fecha_ini)), 'date_format(caf_fecha,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($fecha_fin)) );
        //$cargos_adicionales = $this->facturacion_model->get_cargos_adicionales($where_ad, $id_fijo, $id_consumo);

        /*         * ********************************** Ingreso y actualización de cargos fijos y por consumo ****************** */

        //--------------- Fijos de caf ------------------------
        if ($cliente != null) {
            $where = array('date_format(caf_fecha,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)),
                'date_format(caf_fecha,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)), 'cli_id' => $cliente);
        } else {
            $where = array('date_format(caf_fecha,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)),
                'date_format(caf_fecha,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)));
        }
        // if($documento!=null){
        //    	$where['dcc_valor']=$documento;
        //    }

        $fijos_caf = $this->facturacion_model->get_fijos_caf($where, $id_fijo); //registros de cargos fijos en caf

        $fijos_arr = array();
        if (count($fijos_caf) > 0) {
            foreach ($fijos_caf as $fbd) {
                $db[] = $fbd['sxc_id'] . ',' . $fbd['caf_nombre'] . ',' . date('Y-m-d', strtotime($fbd['caf_fecha']));
            }
            $fijos_arr = $db;
        }
        //-----------------------------------------------------
        //--------------- Consumos de caf ------------------------
        if ($cliente != null) {
            $where_cons = array('date_format(caf_fecha,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)), 'date_format(caf_fecha,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)), 'caf_id_tcs' => $id_consumo, 'cli_id' => $cliente);
        } else {
            $where_cons = array('date_format(caf_fecha,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)), 'date_format(caf_fecha,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)), 'caf_id_tcs' => $id_consumo);
        }
        // if($documento!=null){
        // 	$where_cons['dcc_valor']=$documento;
        // }

        $consumos_caf = $this->facturacion_model->get_consumos_caf($where_cons, $id_consumo); //registros cargos por consumo en caf
        $consumo_arr = array();
        if (count($consumos_caf) > 0) {
            foreach ($consumos_caf as $cbd) {
                $con[] = $cbd['sxc_id'];
            }
            $consumo_arr = $con;
        }


        /*         * ************* Actualización e ingreso de cargos fijos **************** */
        $sxc_fij = array();
        foreach ($cargos_fijos as $key => $value) {

            $costo = $value['pln_costo'];
            $fecha_cont = $value['pxl_fecha_inicio'];
            $ultimo_dia = $value['pxl_fecha_fin'];
            $dia_ini = date('Y-m-d', strtotime($fecha_cont));
            $dia_contrato = intval(date('d', strtotime($fecha_cont)));
            $dia_fin = intval(date('d', strtotime($fecha_fin)));

            //$valores[$value['sxc_id']] prorrateo con planes y promociones unidas.
            if ($date1 < $dia_ini && $dia_ini <= $date2) {

                // Cálculo de días //
                $datetime1 = new DateTime($fecha_cont);
                $datetime2 = new DateTime($date2);
                $interval = $datetime1->diff($datetime2);
                $dias = $interval->format('%a');
                $mes = $dias + $dia_contrato;
                $dias_incluidos = (int) $dias + 1;
                //die(print_r($dias.'/'.$mes));
                // if($dia_fin==30){
                // }else if($dia_fin==31){
                // 	$dias_incluidos=(int)$dias;
                // }else if ($dia_fin==29){
                // 	$dias_incluidos=(int)$dias;
                // }
                ////////////////////
            } else if ($date1 < $ultimo_dia && $ultimo_dia <= $date2) {
                // Cálculo de días //
                $datetime1 = new DateTime($date1);
                $datetime2 = new DateTime($ultimo_dia);
                $interval = $datetime1->diff($datetime2);
                $dias = $interval->format('%a');
                $dias_incluidos = (int) $dias + 1;
                ////////////////////
            } else {
                $dias_incluidos = 30;
            }

            $costoxdia = $costo / 30;

            $costo_tot = $dias_incluidos * $costoxdia;
            $costo_total = number_format($costo_tot, '2', '.', '');
            $array_caf = array(
                'caf_id_sxc' => $value['sxc_id'],
                'caf_id_tcs' => $id_fijo,
                'caf_fecha' => date('Y-m-d H:i:s', strtotime($fecha_fin)),
                'caf_valor' => $costo_total,
                'caf_estado' => 1,
                'caf_fecha_crea' => date('Y-m-d H:i:s'),
                'caf_fecha_mod' => date('Y-m-d H:i:s'),
                'caf_usu_crea' => $this->tank_auth->get_user_id(),
                'caf_usu_mod' => $this->tank_auth->get_user_id(),
                'caf_impuesto' => 0,
                'caf_subtotal' => $costo_total,
                'caf_nombre' => $value['pln_nombre'],
                'caf_sistema' => 1
            );
            $caf_fecha = date('Y-m-d', strtotime($fecha_fin));
            // die(print_r($fijos_arr).print_r($value['sxc_id'].','.$value['pln_nombre'].','.$caf_fecha));
            if (count($fijos_arr) > 0) {
                if (in_array($value['sxc_id'] . ',' . $value['pln_nombre'] . ',' . $caf_fecha, $fijos_arr)) {
                    //Si existe, se debe actualizar.
                    unset($array_caf['caf_fecha']);
                    $caf = $this->gsatelite->actualizar_array('caf_cargo_facturacion', $array_caf, array('caf_id_sxc' => $value['sxc_id'], 'caf_id_tcs' => $id_fijo, 'caf_nombre' => $value['pln_nombre'], 'date_format(caf_fecha,"%Y-%m-%d")' => $caf_fecha));
                } else if ($value['sxc_id'] == 0 || !in_array($value['sxc_id'] . ',' . $value['pln_nombre'] . ',' . $caf_fecha, $fijos_arr)) {
                    //Si no existe, se debe insertar.
                    $array_caf['caf_sistema'] = 1;
                    $caf = $this->gsatelite->ingresar('caf_cargo_facturacion', $array_caf);
                }
            } else {
                $array_caf['caf_sistema'] = 1;
                $caf = $this->gsatelite->ingresar('caf_cargo_facturacion', $array_caf);
            }
            //FIJOS
            $cargos_servicios = $this->gsatelite->get_tabla('caf_cargo_facturacion', array('caf_id_sxc' => $value['sxc_id'], 'caf_id_tcs' => $id_fijo));

            $impuestos_cliente = $this->facturacion_model->get_impuestos_cliente(array('ixc_id_cli' => $value['cli_id']));

            foreach ($cargos_servicios as $caf) {

                $this->gsatelite->borrado_general('ixg_impuestoxcargo', array('ixg_id_caf' => $caf['caf_id']));
                $total_caf_imp = 0;
                $monto = 0;
                if (count($impuestos_cliente) > 0) {
                    foreach ($impuestos_cliente as $imp) {
                        $monto = round($caf['caf_valor'] * ($imp['imp_porcentaje'] / 100), 2);
                        $total_caf_imp += $monto;
                        $ixg_array = array(
                            'ixg_id_imp' => $imp['imp_id'],
                            'ixg_id_caf' => $caf['caf_id'],
                            'ixg_monto' => $monto,
                            'ixg_estado' => 1,
                            'ixg_usu_mod' => $this->tank_auth->get_user_id(),
                            'ixg_usu_crea' => $this->tank_auth->get_user_id(),
                            'ixg_fecha_crea' => date('Y-m-d h:i:s'),
                            'ixg_fecha_mod' => date('Y-m-d h:i:s')
                        );
                        $ixg = $this->gsatelite->ingresar('ixg_impuestoxcargo', $ixg_array);
                    }
                }
                $caf_array = array(
                    'caf_impuesto' => $total_caf_imp,
                    'caf_subtotal' => $caf['caf_valor'] + $total_caf_imp,
                    'caf_fecha_mod' => date('Y-m-d h:i:s'),
                    'caf_usu_mod' => $this->tank_auth->get_user_id()
                );

                $this->gsatelite->actualizar_array('caf_cargo_facturacion', $caf_array, array('caf_id' => $caf['caf_id']));
            }

            //Adicionales
            $this->db->where("datediff('" . date('Y-m-d', strtotime($fecha_fin)) . "', caf_fecha) BETWEEN 0 AND 30");

            $cargos_servicios = $this->gsatelite->get_tabla('caf_cargo_facturacion', array('caf_id_sxc' => $value['sxc_id'], 'caf_id_tcs != ' => $id_fijo, 'caf_id_tcs != ' => $id_consumo));

            $impuestos_cliente = $this->facturacion_model->get_impuestos_cliente(array('ixc_id_cli' => $value['cli_id']));

            foreach ($cargos_servicios as $caf) {

                $this->gsatelite->borrado_general('ixg_impuestoxcargo', array('ixg_id_caf' => $caf['caf_id']));
                $total_caf_imp = 0;
                foreach ($impuestos_cliente as $imp) {

                    $monto = round($caf['caf_valor'] * ($imp['imp_porcentaje'] / 100), 2);
                    $total_caf_imp += $monto;
                    $ixg_array = array(
                        'ixg_id_imp' => $imp['imp_id'],
                        'ixg_id_caf' => $caf['caf_id'],
                        'ixg_monto' => $monto,
                        'ixg_estado' => 1,
                        'ixg_usu_mod' => $this->tank_auth->get_user_id(),
                        'ixg_usu_crea' => $this->tank_auth->get_user_id(),
                        'ixg_fecha_crea' => date('Y-m-d h:i:s'),
                        'ixg_fecha_mod' => date('Y-m-d h:i:s')
                    );

                    $ixg = $this->gsatelite->ingresar('ixg_impuestoxcargo', $ixg_array);
                }

                $caf_array = array(
                    'caf_impuesto' => $total_caf_imp,
                    'caf_subtotal' => $caf['caf_valor'] + $total_caf_imp,
                    'caf_fecha_mod' => date('Y-m-d h:i:s'),
                    'caf_usu_mod' => $this->tank_auth->get_user_id()
                );

                $this->gsatelite->actualizar_array('caf_cargo_facturacion', $caf_array, array('caf_id' => $caf['caf_id']));
            }
            $sxc_fij[] = $value['sxc_id'] . ',' . $value['pln_nombre'];
        }

        $carg_fijo = $sxc_fij;

        //die(print_r($data[0].','.$data[1]).print_r($carg_fijo));
        //Borrar registros de caf inexistentes e pln
        if (count($fijos_arr) > 0) {
            $caf_id = '';
            for ($i = 0; $i < count($fijos_arr); $i++) {
                $data = explode(',', $fijos_arr[$i]);
                // $data[0] --> sxc_id
                // $data[1] --> caf_nombre

                if ($data[0] > 0 && !in_array($data[0] . ',' . $data[1], $carg_fijo)) {

                    $cargos_servicios = $this->gsatelite->get_tabla('caf_cargo_facturacion', array('caf_id_sxc' => $data[0], 'caf_id_tcs' => $id_fijo, 'caf_nombre' => $data[1]));
                    $cargo_pag = '';
                    foreach ($cargos_servicios as $caf) {
                        // $this->gsatelite->borrado_general('cxs_cargoxfacturacion_serv',array('cxs_id_caf'=>$caf['caf_id']));
                        $this->gsatelite->borrado_general('ixg_impuestoxcargo', array('ixg_id_caf' => $caf['caf_id']));
                        $cargos_pagados = $this->gsatelite->get_tabla('cxs_cargoxfacturacion_serv', array('cxs_id_caf' => $caf['caf_id']));
                        if (count($cargos_pagados) > 0) {
                            $cargo_pag = 1;
                        } else {
                            $cargo_pag = 0;
                        }
                    }

                    if (count($cargo_pag) <= 0) {
                        $borrado = $this->gsatelite->borrado_general('caf_cargo_facturacion', array('caf_id_sxc' => $fijos_arr[$i], 'caf_id_tcs' => $id_fijo, 'caf_nombre' => $data[1]));
                    }
                    //echo print_r('caf_id_sxc => '.$fijos_arr[$i].'|| fijo => '.$id_fijo."<br>");
                }
            }
        }

        /*         * ********************************************************** */


        /*         * ************* Actualización e ingreso de cargos por consumo **************** */
        $sxc_con = array();

        foreach ($consumos as $con => $valor) {

            if ($valor['total'] > 0) {
                $array_cons = array(
                    'caf_id_sxc' => $valor['sxc_id'],
                    'caf_id_tcs' => $id_consumo,
                    'caf_fecha' => date('Y-m-d H:i:s', strtotime($fecha_fin)),
                    'caf_valor' => $valor['total'],
                    'caf_estado' => 1,
                    'caf_fecha_crea' => date('Y-m-d H:i:s'),
                    'caf_fecha_mod' => date('Y-m-d H:i:s'),
                    'caf_usu_crea' => $this->tank_auth->get_user_id(),
                    'caf_usu_mod' => $this->tank_auth->get_user_id(),
                    'caf_impuesto' => 0,
                    'caf_subtotal' => $valor['total'],
                    'caf_nombre' => $value['pln_nombre']
                );
                if (count($consumo_arr) > 0) {
                    if (in_array($valor['sxc_id'], $consumo_arr)) {
                        //Si existe, se debe actualizar.
                        unset($array_caf['caf_fecha']);
                        $caf_con = $this->gsatelite->actualizar_array('caf_cargo_facturacion', $array_cons, array('caf_id_sxc' => $valor['sxc_id'], 'caf_id_tcs' => $id_consumo));
                    } else if ($valor['sxc_id'] == 0 || !in_array($valor['sxc_id'], $consumo_arr)) {
                        //Si no existe, se debe insertar.
                        $array_cons['caf_sistema'] = 1;
                        $caf_con = $this->gsatelite->ingresar('caf_cargo_facturacion', $array_cons);
                    }
                } else {
                    $array_cons['caf_sistema'] = 1;
                    $caf_con = $this->gsatelite->ingresar('caf_cargo_facturacion', $array_cons);
                }

                $cargos_servicios = $this->gsatelite->get_tabla('caf_cargo_facturacion', array('caf_id_sxc' => $valor['sxc_id'], 'caf_id_tcs' => $id_consumo));

                $impuestos_cliente = $this->facturacion_model->get_impuestos_cliente(array('ixc_id_cli' => $valor['sxc_id_cli']));

                foreach ($cargos_servicios as $caf) {

                    $this->gsatelite->borrado_general('ixg_impuestoxcargo', array('ixg_id_caf' => $caf['caf_id']));
                    $total_caf_imp = 0;
                    foreach ($impuestos_cliente as $imp) {

                        $monto = round($caf['caf_valor'] * ($imp['imp_porcentaje'] / 100), 2);
                        $total_caf_imp += $monto;
                        $ixg_array = array(
                            'ixg_id_imp' => $imp['imp_id'],
                            'ixg_id_caf' => $caf['caf_id'],
                            'ixg_monto' => $monto,
                            'ixg_estado' => 1,
                            'ixg_usu_mod' => $this->tank_auth->get_user_id(),
                            'ixg_usu_crea' => $this->tank_auth->get_user_id(),
                            'ixg_fecha_crea' => date('Y-m-d h:i:s'),
                            'ixg_fecha_mod' => date('Y-m-d h:i:s')
                        );

                        $ixg = $this->gsatelite->ingresar('ixg_impuestoxcargo', $ixg_array);
                    }

                    $caf_array = array(
                        'caf_impuesto' => $total_caf_imp,
                        'caf_subtotal' => $caf['caf_valor'] + $total_caf_imp,
                        'caf_fecha_mod' => date('Y-m-d h:i:s'),
                        'caf_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $this->gsatelite->actualizar_array('caf_cargo_facturacion', $caf_array, array('caf_id' => $caf['caf_id']));
                }
                $sxc_con[] = $valor['sxc_id'];
            }
        }

        $carg_cons = $sxc_con;


        /*         * ********* Borrar registros de caf inexistentes e cdd(cdr) ****************** */
        if (count($consumo_arr) > 0) {
            for ($i = 0; $i < count($consumo_arr); $i++) {
                if ($consumo_arr[$i] > 0 && !in_array($consumo_arr[$i], $carg_cons)) {
                    //die(print_r($consumo_arr[$i].'/').print_r($carg_cons));
                    $caf_filas = $this->facturacion_model->get_caf_filas($consumo_arr[$i], $id_consumo);

                    $temp_array = explode(',', str_replace("'", '', $caf_filas->caf_id));

                    if (!empty($caf_filas))
                        $this->db->where_in('cxs_id_caf', $temp_array)->delete('cxs_cargoxfacturacion_serv');
                    $cargos_servicio = $this->gsatelite->get_tabla('caf_cargo_facturacion', array('caf_id_sxc' => $consumo_arr[$i], 'caf_id_tcs' => $id_consumo));
                    foreach ($cargos_servicio as $cons) {
                        $this->gsatelite->borrado_general('ixg_impuestoxcargo', array('ixg_id_caf' => $cons['caf_id']));
                        $cargos_pagados = $this->gsatelite->get_tabla('cxs_cargoxfacturacion_serv', array('cxs_id_caf' => $caf['caf_id']));
                    }

                    if (count($cargos_pagados) <= 0) {
                        $borrado = $this->gsatelite->borrado_general('caf_cargo_facturacion', array('caf_id_sxc' => $consumo_arr[$i], 'caf_id_tcs' => $id_consumo));
                    }
                }
            }
        }
        /*         * ************************************************************************************************************ */


        //PARAMETROS
        $id_fijo = $this->gsatelite->get_parametro('SYS_CARGO_FIJO');
        $id_consumo = $this->gsatelite->get_parametro('SYS_CARGO_CONSUMO');

        if ($cliente != null) {
            $where_ad = array('date_format(caf_fecha,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)), 'date_format(caf_fecha,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)), 'cof_masivo' => 1, 'cli_id' => $cliente);
        } else {
            $where_ad = array('date_format(caf_fecha,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_ini)), 'date_format(caf_fecha,"%Y-%m-%d") <=' => date('Y-m-d', strtotime($fecha_fin)), 'cof_masivo' => 1);
        }
        // if($documento!=null){
        // 	$where_ad['dcc_valor']=$documento;
        // }

        $total_factura_bd = $this->facturacion_model->get_detalle_total_bd($where_ad);

        if (!empty($total_factura)) {
            $total_facturas = $this->facturacion_model->get_detalle_totalxcliente($date1, $date2, $id_fijo, $id_consumo, null, 1, null, $cliente);
        } else {
            $total_facturas = $this->facturacion_model->get_detalle_totalxcliente($date1, $date2, $id_fijo, $id_consumo, null, null, null, $cliente);
        }

        $sxc_nuevo = array();
        foreach ($total_facturas as $fac => $valu) {
            if (in_array($valu['sxc_id'], $factura_bd)) {
                if ($valu['fac_estado'] == 0) {
                    /*                     * **************************** Borrar detalles ************************************************* */
                    $cb = $this->gsatelite->borrado_general('cxs_cargoxfacturacion_serv', array('cxs_id_fxs' => $valu['fxs_id']));
                    //$fb=$this->gsatelite->borrado_general('fxs_facturaxservicio',array('fxs_id_fac'=>$valu['cxs_id_fxs']));
                    $fb = $this->gsatelite->borrado_general('fxs_facturaxservicio', array('fxs_id' => $valu['cxs_id_fxs']));
                    /*                     * ********************************************************************************************** */
                }
            }
            //if($valu['fac_estado'] != 2){
            $sxc_nuevo[] = $valu['sxc_id'];
            //}
        }

        $nuevos = $sxc_nuevo;
        foreach ($total_factura_bd as $facbd => $vbd) {
            if (!in_array($vbd['sxc_id'], $nuevos)) {
                /*                 * **************************** Borrar detalles ************************************************* */
                $anular = array('fac_fecha_anulacion' => date('Y-m-d H:i:s'), 'fac_motivo_anulacion' => 'Procesamiento masivo', 'fac_estado' => 0);
                $facb = $this->gsatelite->actualizar_array('fac_factura', $anular, array('fac_id' => $vbd['fac_id']));
                $cb = $this->gsatelite->borrado_general('cxs_cargoxfacturacion_serv', array('cxs_id_fxs' => $vbd['fxs_id']));
                $fb = $this->gsatelite->borrado_general('fxs_facturaxservicio', array('fxs_id' => $vbd['cxs_id_fxs']));
                // $fb=$this->gsatelite->borrado_general('fxs_facturaxservicio',array('fxs_id_fac'=>$vbd['cxs_id_fxs']));
                /*                 * ********************************************************************************************** */
            }
        }


        $total_fact = $this->facturacion_model->get_detalle_totalxcliente($date1, $date2, $id_fijo, $id_consumo, null, 1, null, $cliente);

        $ids_fac = array();
        $array_cxs = array();
        foreach ($total_fact as $fac => $val) {
            $subtotal = 0;
            $fijo = 0;
            $consumo = 0;
            $adicional = 0;
            /*             * ****************** Verificación de correlativo ************************** */
            $tipo_fac = $val['cli_id_tif'];
            $tif_nombre = $val['tif_nombre'];
            $fijo = $val['fijo'];
            $consumo = $val['consumo'];
            $adicional = $val['adicional'];
            $subtotal = $fijo + $consumo + $adicional;
            $fec_factura = date('Y-m-d', strtotime('+1 day', strtotime($fecha_fin)));

            $dias_vence = $this->gsatelite->get_parametro('SYS_VENCE_FACTURA');
            $now = date('d-m-Y');
            //$fecha_vence= $this->calcular_fecha_vencimiento($fecha_fin);
            $fecha_vence = date('Y-m-d', strtotime('+' . $dias_vence . ' day', strtotime($now)));
            $now = date('Y-m-d');
            $tif = $val['cli_id_tif'];

            if (in_array($val['sxc_id'], $factura_bd)) {  //&& !in_array($valu['fac_id'],$fxp_array)
                //End registros a actualizar
                // die(print_r($fijo.'fijo'.$consumo.'consumo'.$adicional.'adicional'.$subtotal.'subtotal'));
                $array_factura = array(
                    'fac_id_cli' => $val['cli_id']
                    , 'fac_id_tpg' => $val['tpg_id']
                    , 'fac_fecha_fact' => date('Y-m-d', strtotime($fecha_fin))
                    , 'fac_subtotal' => floatval($subtotal)
                    , 'fac_total' => floatval($subtotal)
                    , 'fac_tipo' => 2
                    , 'fac_id_ven' => $val['cli_id_ven']
                    , 'fac_usu_mod' => $this->tank_auth->get_user_id()
                    , 'fac_fecha_mod' => date("Y-m-d H:i:s")
                    , 'fac_fecha_vencimiento' => $fecha_vence
                );
                $pago = $this->gsatelite->get_campo('paf_pago_factura', 'paf_id', array('paf_id_fac' => $val['fac_id']));
                if ($pago <= 0 || $pago == '') {
                    $id_fac = $this->gsatelite->actualizar_array('fac_factura', $array_factura, array('fac_id' => $val['fac_id']));
                }
                if ($id_fac > 0) {
                    $fact = $val['fac_id'];
                    $servicios = $val['servicio'];
                    //$this->ingresa_detalle($fact,$servicios,$fecha_ini,$fecha_fin);
                }
                /*                 * ****************Insertar fxs********************* */
                // $fxs = 0;
                // if($fact!=null){
                // 	$array_fxs=array(
                // 			'fxs_id_sxc'=>$val['caf_id_sxc'],
                // 			'fxs_id_fac'=>$fact,
                // 			'fxs_fecha_inicio'=>date('Y-m-d H:i:s', strtotime($fecha_ini)),
                // 			'fxs_fecha_fin'=>date('Y-m-d H:i:s', strtotime($fecha_fin)),
                // 			'fxs_estado'=>1,
                // 			'fxs_fecha_crea'=>date('Y-m-d H:i:s'),
                // 			'fxs_usu_crea'=>$this->tank_auth->get_user_id(),
                // 			'fxs_fecha_mod'=>date('Y-m-d H:i:s'),
                // 			'fxs_usu_mod'=>$this->tank_auth->get_user_id()
                // 		);
                // 	$fxs=$this->gsatelite->ingresar('fxs_facturaxservicio', $array_fxs);
                // }
                /*                 * ******************************************** */

                /*                 * ****************Insertar cxs ********************* */
                // if($fxs>0){
                // 	$array_cxs=array(
                // 				'cxs_id_caf'=>$val['caf_id'],
                // 				'cxs_id_fxs'=>$fxs,
                // 				'cxs_estado'=>1,
                // 				'cxs_fecha_crea'=>date('Y-m-d H:i:s'),
                // 				'cxs_usu_crea'=>$this->tank_auth->get_user_id(),
                // 				'cxs_fecha_mod'=>date('Y-m-d H:i:s'),
                // 				'cxs_usu_mod'=>$this->tank_auth->get_user_id()
                // 			);
                // 	$cxs=$this->gsatelite->ingresar('cxs_cargoxfacturacion_serv', $array_cxs);
                // }
                /*                 * ******************************************** */
            } else if ($val['sxc_id'] == 0 || !in_array($val['sxc_id'], $factura_bd)) { // se verifica que los registros a ingresar no se encuentren en BD
                $this->db->join('sef_serie_factura', 'sef_id=cof_id_sef'); //Consulta de correlativos segun tipo de factura para ingresar
                $cof = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_estado' => 1, 'sef_id_tif' => $tipo_fac, 'cof_masivo' => 1));
                if (count($cof) > 0) {
                    $subtotal = 0;
                    $fijo = 0;
                    $consumo = 0;
                    $adicional = 0;
                    //die(print_r($fijo.'fijo'.$consumo.'consumo'.$adicional.'adicional'.$subtotal.'subtotal2'));
                    //verificar disponibilidad y numero a asignar
                    foreach ($cof as $cf => $cor) {
                        $cof_fin = $cor['cof_fin'];
                        $cof_ini = $cor['cof_inicio'];
                        $cof_actual = $cor['cof_actual'];

                        //$corr_utilizado=$this->facturacion_model->get_correlativo($cor['cof_inicio'],$cof_fin,$cor['sef_id'], 1); //Consulta de último correlativo utilizado
                        if ($cof_actual == 0) {
                            $ultimo = $cof_ini; // Último correlativo utilizado para este tipo de factura.
                        } else { // Se deja el correlativo de inicio del rango.
                            $ultimo = $cof_actual + 1;
                        }
                        if ($cof_actual < $cof_fin) {

                            $disp = $cof_fin - $cof_actual; // Disponibilidad de correlativos.
                            $cant_necesaria = $tipos[$cor['sef_id_tif']]; //
                            if (($cof_fin - $cof_actual) >= 1) { //$disp>=$cof_actual
                                $array_cof = array(
                                    'cof_usu_mod' => $this->tank_auth->get_user_id(),
                                    'cof_fecha_mod' => date('Y-m-d H:i:s'),
                                    'cof_actual' => $ultimo
                                );

                                $corr = $this->gsatelite->actualizar_array('cof_correlativo_factura', $array_cof, array('cof_id' => $cor['cof_id']));

                                /*                                 * ******************** Ingreso de factura *********************************** */
                                $fijo = $val['fijo'];
                                $consumo = $val['consumo'];
                                $adicional = $val['adicional'];
                                $subtotal = $fijo + $consumo + $adicional;
                                //die(print_r($fijo.'/'.$consumo.'/'.$adicional));

                                $fec_factura = date('Y-m-d', strtotime('+1 day', strtotime($fecha_fin)));
                                //$dias_vence=$this->gsatelite->get_parametro('SYS_VENCE_FACTURA');
                                //$fecha_vence=$this->calcular_fecha_vencimiento($fecha_fin);
                                $fecha_vence = date('Y-m-d', strtotime('+' . $dias_vence . ' day', strtotime($now)));

                                $tif = $val['cli_id_tif'];

                                $array_factura = array(
                                    'fac_id_cli' => $val['cli_id']
                                    , 'fac_id_ven' => $val['cli_id_ven']
                                    , 'fac_id_tpg' => $val['tpg_id']
                                    , 'fac_id_cof' => $cor['cof_id']
                                    , 'fac_numero' => $ultimo
                                    , 'fac_fecha_fact' => date('Y-m-d', strtotime($fecha_fin))
                                    , 'fac_fecha_cont' => date('Y-m-d', strtotime($fecha_fin))
                                    , 'fac_observacion' => null
                                    , 'fac_subtotal' => floatval(str_replace(',', '', $subtotal))
                                    , 'fac_tipo' => 2
                                    , 'fac_descuento' => 0
                                    , 'fac_impuesto' => 0
                                    , 'fac_total' => floatval(str_replace(',', '', $subtotal))
                                    , 'fac_motivo_anulacion' => null
                                    , 'fac_fecha_anulacion' => null
                                    , 'fac_estado' => 1
                                    , 'fac_usu_mod' => $this->tank_auth->get_user_id()
                                    , 'fac_fecha_mod' => date("Y-m-d H:i:s")
                                    , 'fac_usu_crea' => $this->tank_auth->get_user_id()
                                    , 'fac_fecha_crea' => date("Y-m-d H:i:s")
                                    , 'fac_fecha_vencimiento' => $fecha_vence
                                );
                                //die(print_r($array_factura).print_r($fijo.'/'.$consumo.'/'.$adicional));
                                $id_fac = $this->gsatelite->ingresar('fac_factura', $array_factura);

                                $insert_fac[] = $id_fac;
                                /*                                 * *************************************************************************** */
                                if ($ultimo == $cor['cof_fin']) {
                                    $act_cof = array('cof_masivo' => 0);
                                    $this->gsatelite->actualizar_array('cof_correlativo_factura', $act_cof, array('cof_id' => $cor['cof_id']));
                                }

                                /////////////////////////////////////////////////////
                                $sxc_cliente = $val['servicio'];

                                $coma = strpos($sxc_cliente, ',');

                                if ($coma != '') {
                                    $sxc_fac = explode(',', $sxc_cliente);
                                }
                                /////////////////////////////////////////////////////

                                /*                                 * **************** Insertar fxs ********************* */
                                $array_fxs = array(
                                    'fxs_id_sxc' => $val['caf_id_sxc'],
                                    'fxs_id_fac' => $id_fac,
                                    'fxs_fecha_inicio' => date('Y-m-d H:i:s', strtotime($fecha_ini)),
                                    'fxs_fecha_fin' => date('Y-m-d H:i:s', strtotime($fecha_fin)),
                                    'fxs_estado' => 1,
                                    'fxs_fecha_crea' => date('Y-m-d H:i:s'),
                                    'fxs_usu_crea' => $this->tank_auth->get_user_id(),
                                    'fxs_fecha_mod' => date('Y-m-d H:i:s'),
                                    'fxs_usu_mod' => $this->tank_auth->get_user_id()
                                );
                                $fxs = $this->gsatelite->ingresar('fxs_facturaxservicio', $array_fxs);
                                /*                                 * ******************************************** */

                                /*                                 * ****************Insertar cxs ********************* */
                                // $array_cxs=array(
                                // 		'cxs_id_caf'=>$val['caf_id'],
                                // 		'cxs_id_fxs'=>$fxs,
                                // 		'cxs_estado'=>1,
                                // 		'cxs_fecha_crea'=>date('Y-m-d H:i:s'),
                                // 		'cxs_usu_crea'=>$this->tank_auth->get_user_id(),
                                // 		'cxs_fecha_mod'=>date('Y-m-d H:i:s'),
                                // 		'cxs_usu_mod'=>$this->tank_auth->get_user_id()
                                // );
                                // $cxs=$this->gsatelite->ingresar('cxs_cargoxfacturacion_serv', $array_cxs);
                                $where = array('caf_id_sxc' => $val['sxc_id'], 'date_format(caf_fecha,"%Y-%m-%d") >=' => date('Y-m-d', strtotime($fecha_fin)),);
                                $detalle_caf_fijos = $this->facturacion_model->get_fijos_caf($where, 1, 1);

                                foreach ($detalle_caf_fijos as $caf) {
                                    $array_cxs [] = array(
                                        'cxs_id_caf' => $caf['caf_id'],
                                        'cxs_id_fxs' => $fxs,
                                        'cxs_estado' => 1,
                                        'cxs_fecha_crea' => date('Y-m-d H:i:s'),
                                        'cxs_usu_crea' => $this->tank_auth->get_user_id(),
                                        'cxs_fecha_mod' => date('Y-m-d H:i:s'),
                                        'cxs_usu_mod' => $this->tank_auth->get_user_id()
                                    );
                                }
                                /*                                 * ******************************************** */
                            } else if ($disp < $cant_necesaria) {
                                echo json_encode(array('resultado' => 0, 'tipo' => $tif_nombre, 'disp' => 1)); //no hay suficientes correlativos
                            }
                        } else {
                            echo json_encode(array('resultado' => 0, 'tipo' => $tif_nombre, 'disp' => 1)); //no hay suficientes correlativos
                        }
                    }
                } else {
                    echo json_encode(array('resultado' => 0, 'tipo' => $tif_nombre, 'disp' => 0));
                }

                /*                 * ************************************************************************* */
            }// End in_array
        }//End foreach total_factura
        //Insertar los cxs_cargoxfacturacion_serv
        if (count($array_cxs) > 0 && $array_cxs != null) {
            $this->db->insert_batch('cxs_cargoxfacturacion_serv', $array_cxs);
        }

        // if(!empty($insert_fac)){
        // 	$ids_fac=$insert_fac;
        //       $facturas=implode(',', $ids_fac);
        // 	$fac_ids=$this->facturacion_model->get_detalle_totalxcliente($date1,$date2,$id_fijo,$id_consumo,$facturas,1,1,$cliente);
        // }else{
        // 	$facts=implode(',',$factura_id);
        // 	$fac_ids=$this->facturacion_model->get_detalle_totalxcliente($date1,$date2,$id_fijo,$id_consumo, $facts,1,1,$cliente);
        // }

        $fac_ids = $this->facturacion_model->get_detalle_totalxcliente($date1, $date2, $id_fijo, $id_consumo, null, 1, 1, $cliente);

        //$this->db->flush_cache();
        $data["facturas"] = $fac_ids;
        $data["fxp_array"] = $fxp_array;
        $data['fecha_ini'] = $fecha_ini;
        $data["fecha_fin"] = $fecha_fin;
        $html = $this->load->view('facturacion/facturar/facturas_detalle', $data, true);
        echo json_encode(array('resultado' => $html));
    }

    /**
     *
     *
     * @autor Edith Herrera
     * @since 12/03/2016
     */
    function pago_caja() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {
                if ($_POST) {
                    //die(print_r($_POST));

                    $array_pago = array(
                        'paf_id_fac' => ($this->input->post('facturas')) ? $this->input->post('facturas') : null
                        , 'paf_id_caj' => 1
                        , 'paf_id_tpg' => $this->input->post('tipo_pago')
                        , 'paf_id_cof' => $this->input->post('correlativo')
                        , 'paf_numero' => $this->input->post('n_fac')
                        , 'paf_fecha_pag' => date("Y-m-d H:i:s", strtotime($this->input->post('fecha_fac')))
                        , 'paf_fecha_cont' => date("Y-m-d H:i:s", strtotime($this->input->post('fecha_con')))
                        , 'paf_observacion' => ($this->input->post('observaciones')) ? trim($this->input->post('observaciones')) : null
                        , 'paf_subtotal' => $this->input->post('subtotal')
                        //,'paf_descuento'=>(trim($descuentos)=="")? 0: trim($descuentos)
                        , 'paf_impuesto' => 0
                        , 'paf_total' => $this->input->post('total_fac')
                        , 'paf_motivo_anulacion' => null
                        , 'paf_fecha_anulacion' => null
                        , 'paf_estado' => 1
                        , 'paf_usu_mod' => $this->tank_auth->get_user_id()
                        , 'paf_fecha_mod' => date("Y-m-d H:i:s")
                        , 'paf_fecha_crea' => date("Y-m-d H:i:s")
                        , 'paf_usu_crea' => $this->tank_auth->get_user_id()
                        , 'paf_id_cpl' => ($this->input->post('cpl_id')) ? $this->input->post('cpl_id') : null
                    );
                    $id_fac = $this->gsatelite->ingresar('paf_pago_factura', $array_pago);

                    if ($id_fac > 0) {
                        $array_co_factura = array(
                            'cof_actual' => $this->input->post("n_fac"),
                            'cof_estado' => 1,
                            'cof_usu_mod' => $this->tank_auth->get_user_id(),
                            'cof_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $cor = $this->gsatelite->actualizar_array('cof_correlativo_factura', $array_co_factura, array('cof_id' => $this->input->post('correlativo')));
                    }

                    $fac_id = $this->input->post('facturas');
                    $cuota_id = $this->input->post('cpl_id');
                    if ($fac_id > 0) {
                        $actualizar_fac = array(
                            'fac_estado' => 2,
                            'fac_usu_mod' => $this->tank_auth->get_user_id(),
                            'fac_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $fac = $this->gsatelite->actualizar_array('fac_factura', $actualizar_fac, array('fac_id' => $fac_id));

                        $actualizar_fxs = array(
                            'fxs_estado' => 2,
                            'fxs_usu_mod' => $this->tank_auth->get_user_id(),
                            'fxs_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $fxs = $this->gsatelite->actualizar_array('fxs_facturaxservicio', $actualizar_fxs, array('fxs_id_fac' => $fac_id));
                    }

                    if ($cuota_id > 0) {
                        $actualizar_cpl = array(
                            'cpl_estado' => 2,
                            'cpl_user_mod' => $this->tank_auth->get_user_id(),
                            'cpl_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $fac = $this->gsatelite->actualizar_array('cpl_cuota_plan_pago', $actualizar_cpl, array('cpl_id' => $cuota_id));

                        // Verificar si es la ultima cuota, en el caso que sea la ultima, poner las facturas involucradas en un estado de 2

                        $cuotas_pendientes = $this->db->select('count(*) AS cuotas', false)->from('cpl_cuota_plan_pago')->where(array('cpl_id_plg' => $_POST['cuota'], 'cpl_estado' => 1))->get()->row();
                        if ($cuotas_pendientes->cuotas < 1) {
                            $facturas = $this->db->select('fxp_id_fac')->from('fxp_facturaxplan_pago')->where(array('fxp_id_plg' => $_POST['cuota'], 'fxp_estado' => 1))->get()->result_array();

                            if (count($facturas) > 0)
                                foreach ($facturas as $key => $value) {
                                    $this->gsatelite->actualizar('fac_factura', array('fac_estado' => 2), array('fac_id' => $value['fxp_id_fac']));
                                    $this->gsatelite->actualizar('fxs_facturaxservicio', array('fxs_estado' => 2), array('fxs_id_fac' => $value['fxp_id_fac']));
                                }
                        }
                    }
                    // Parametros para imprimir comprobante de pago
                    $imprimir = array('fac_id' => ($this->input->post('facturas')) ? $this->input->post('facturas') : null, 'paf_id_cpl' => ($this->input->post('cpl_id')) ? $this->input->post('cpl_id') : null);


                    if ($id_fac > 0 && $cor > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Pago", 'texto_alerta' => "Pago procesado correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Pago", 'texto_alerta' => "Transacción no efectuada, favor verificar información");
                    }

                    $this->session->set_flashdata($imprimir);
                    $this->session->set_flashdata($alerta);
                    redirect("/facturacion/facturar/pago_caja");
                } else { //si no existe un post cargar la vista normal
                    $this->load->library('EnLetras');
                    $datos["titulo_personal"] = "Pago / Caja";
                    /* PEDIR UNICAMENTE LOS OPTIONS PARA LLENAR LOS SELECTS */
                    $cli = $this->facturacion_model->numeros_cliente();
                    $datos['clientes'] = $cli;

                    // 	$where_ad=array('date_format(fac_fecha_cont,"%Y-%m-%d") >='=>date('Y-m-d', strtotime($fecha_ini)), 'date_format(fac_fecha_cont,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($fecha_fin)), 'cof_masivo'=>1,'cli_id'=>$cliente,'fac_estado'=>1);
                    $fac = $this->facturacion_model->get_detalle_total_bd();
                    $datos['facturas'] = $fac;

                    $series = $this->gsatelite->get_dropdown('sef_serie_factura', '{sef_nombre} {sef_abrev}', '', array('sef_estado' => '1'), null, '', 'sef_id', true);
                    $datos["series"] = str_replace('<option value="0">Seleccione</option>', '', $series);


                    // $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}','', array('tpg_estado' => '1'), null, '', 'tpg_id', true);
                    // $datos["tipos_pago"] = str_replace('<option value="0">Seleccione</option>', '',$tipos_pago);

                    $this->_cargarvista($datos, null);
                }
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function facturaxcliente() {
        if ($this->input->post('id_cli') > 0) {
            $cli = $this->input->post('id_cli');
        } else {
            $cli = 0;
        }
        //$where = array('cli_id'=>$cli,'fac_estado'=>1);
        $where = 'cli_id = ' . $cli . ' AND fac_estado = 1 AND fac_id NOT IN (SELECT fxp_id_fac FROM fxp_facturaxplan_pago)';
        $facturas = $this->facturacion_model->get_detalle_total_bd($where);

        $this->load->library('EnLetras');
        $opt = '<option value=""></option>';
        foreach ($facturas as $fac) {
            $fecha = $fac['fac_fecha_cont'];
            //$fecha=$fac['fac_fecha_fact'];
            $date = date('Y-m-d', strtotime($fecha));
            $mes = $this->enletras->mes_anio($date, 1);
            $mesLetras = str_replace('/', ' ', $mes);

            $opt .= '<option value="' . $fac['fac_id'] . '">' . $fac["fac_numero"] . ' - ' . $mesLetras . '</option>';
        }

        $cuotas = $this->facturacion_model->cuotas_cliente($cli);

        $opc = '<option value=""></option>';
        foreach ($cuotas as $cu) {
            if ($cu['plg_numero'] > 0) {

                $opc .= '<option value="' . $cu['plg_id'] . '">' . $cu['pln_nombre'] . ' - Monto $' . $cu['plg_monto_deuda'] . '</option>';
            }
        }
        //die($opt.'/'.$opc);
        echo json_encode(array('opfac' => $opt, 'opccuo' => $opc));
        //echo $opc;
    }

    function cargar_info_fact() {
        $fac = $this->input->post('id_fac');
        $cli = $this->input->post('id_cli');
        $facturas = $this->facturacion_model->get_detalle_total_bd(array('fac_id' => $fac));

        $this->load->library('EnLetras');

        $num_fact = $facturas[0]['fac_numero'];
        $tpg = $facturas[0]['tpg_id'];
        $nombre = $facturas[0]['tpg_nombre'];
        $tif = $facturas[0]['tif_id'];
        $tipo = $facturas[0]['tif_nombre'];
        $impuesto = $facturas[0]['fac_impuesto'];

        // Información según factura seleccionada
        $factura = $this->gsatelite->get_registro('fac_factura', array('fac_id' => $fac));
        $fecha_factura = date('Y-m-d', strtotime($factura->fac_fecha_cont));
        $where = array('fac_id' => $fac, 'caf_id_tcs' => 1, 'fac_fecha_cont' => $fecha_factura/* , 'caf_fecha'=>$fecha_factura */);
        $sxc_cargos = $this->facturacion_model->get_cargos_cliente($where);
        //die(print_r($this->db->last_query()));
        // Cargos correspondientes a la factura seleccionada(detalle).
        $sxc_id = $sxc_cargos[0]['caf_id_sxc'];
        $cargos_mensuales = $this->facturacion_model->get_detalle_pago_caja($sxc_id, $fecha_factura, 1);

        // $where2=array('fac_id'=>$fac, 'caf_id_tcs'=>2);
        //  		$consumos = $this->facturacion_model->get_cargos_cliente($where2);
        $consumos = $this->facturacion_model->get_detalle_pago_caja($sxc_id, $fecha_factura, 2);

        // $where3=array('fac_id'=>$fac, 'caf_id_tcs <>'=>1);
        // $cargos_adicionales = $this->facturacion_model->get_cargos_cliente($where3, 1);

        $cargos_adicionales = $this->facturacion_model->get_detalle_pago_caja($sxc_id);

        //die(print_r($this->db->last_query()));

        $total = 0;
        $html = '';
        $htmlcon = '';
        $htmlad = '';
        $valcm = 0;
        $valcon = 0;
        $valca = 0;
        $subcm = 0;
        $subcon = 0;
        $subca = 0;
        //die(print_r($cargos_mensuales));
        foreach ($cargos_mensuales as $cm) {
            //$fecha=$cm['fac_fecha_cont'];
            $fecha = $cm['caf_fecha'];
            $date = date('Y-m-d', strtotime($fecha));
            $impuesto_caf = number_format(($cm['caf_impuesto'] > 0) ? $cm['caf_impuesto'] : '0.00', 2);
            $mes = $this->enletras->mes_anio($date, 1);
            $mesLetras = str_replace('/', ' ', $mes);
            $html .= '<tr><td>' . $num_fact . '</td><td>' . $mesLetras . '</td><td>' . $cm['cantidad'] . '</td>';
            $html .= '<td>' . $cm['caf_valor'] . '</td><td>' . $impuesto_caf . '</td><td>' . $cm['subtotal'] . '</td>';
            $subcm += $cm['subtotal'];
            $valcm += $cm['caf_valor'];
        }



        foreach ($consumos as $con) {
            //$fecha=$con['fac_fecha_cont'];
            $fecha_c = $con['caf_fecha'];
            $date = date('Y-m-d', strtotime($fecha_c));
            $impuesto_caf = number_format(($con['caf_impuesto'] > 0) ? $con['caf_impuesto'] : '0.00', 2);
            $mes = $this->enletras->mes_anio($date, 1);
            $mesLetras = str_replace('/', ' ', $mes);
            $htmlcon = '<tr><td>' . $num_fact . '</td><td>' . $mesLetras . '</td><td>' . $con['cantidad'] . '</td>';
            $htmlcon .= '<td>' . $con['caf_valor'] . '</td><td>' . $impuesto_caf . '</td><td>' . $con['subtotal'] . '</td>';
            $subcon += $con['subtotal'];
            $valcon += $con['caf_valor'];
        }
        foreach ($cargos_adicionales as $ca) {
            //$fecha=$ca['fac_fecha_cont'];
            $fecha = $ca['caf_fecha'];
            $date = date('Y-m-d', strtotime($fecha));
            $impuesto_caf = number_format(($ca['caf_impuesto'] > 0) ? $ca['caf_impuesto'] : '0.00', 2);
            $mes = $this->enletras->mes_anio($date, 1);
            $mesLetras = str_replace('/', ' ', $mes);
            $htmlad = '<tr><td>' . $num_fact . '</td><td>' . $mesLetras . '</td><td>' . $ca['cantidad'] . '</td>';
            $htmlad .= '<td>' . $ca['caf_valor'] . '</td><td>' . $impuesto_caf . '</td><td>' . $ca['subtotal'] . '</td>';
            $subca += $ca['subtotal'];
            $valca += $ca['caf_valor'];
        }
        $filas = $html . $htmlcon . $htmlad;
        $total = $subcm + $subcon + $subca;
        $subtotal_fac = $valcm + $valca + $valcon;

        //die(print_r($filas));
        /*         * *************************Verificar facturas pendientes ****************************** */
        $reg = $this->gsatelite->get_campo('fac_factura', 'fac_fecha_cont', array('fac_id' => $fac));
        $fecha_fac = date('Y-m-d', strtotime($reg));
        $anterior = $this->gsatelite->get_campo('fac_factura', 'fac_id', array('fac_id_cli' => $cli, 'fac_fecha_cont <' => $fecha_fac, 'fac_estado' => 1));
        if ($anterior > 0) {
            $ant = 1;
        } else {
            $ant = 0;
        }
        /*         * ************************************************************************************* */

        //$tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}','', array('tpg_estado' => '1'), $tpg, '', 'tpg_id', true);
        // $pagos = str_replace('<option value="0">Seleccione</option>', '',$tipos_pago);
        $pagos = '<option value=""></option>';
        $pagos .= '<option value="' . $tpg . '">' . $nombre . '</option>';

        $vence = $this->gsatelite->get_campo('fac_factura', 'fac_fecha_vencimiento', array('fac_id' => $fac));

        $fecha_vence = date('Y-m-d', strtotime($vence));
        $hoy = date('Y-m-d');
        $mora = 0;
        if ($fecha_vence < $hoy) {
            $mora = $this->gsatelite->get_parametro('SYS_MORA_FAC');
        }
        echo json_encode(array('tipo' => $tipo, 'pago' => $nombre, 'tpg_id' => $tpg, 'pagos' => $pagos, 'filas' => $filas, 'total' => $total, 'valida' => $ant, 'impuesto' => $impuesto, 'subtotal_fac' => $subtotal_fac, 'mora' => $mora));
    }

    function financiamiento() {
        //satelite_validar(false);

        $listado_planes = $this->tarificador_model->get_listado_planes_pago();
        $data['listado_planes'] = $listado_planes;

        $data['titulo_personal'] = 'Planes de pago';

        $this->_cargarvista($data);
    }

    function agregar_financiamiento() {
        satelite_validar();

        if ($_POST) {
            //die(var_dump($_POST));

            $facturas = $this->input->post('facturas');
            $tipo_btn = $this->input->post('tipo_btn');

            //$monto_deuda = $this->input->post('monto_deuda');

            $num_cuotas = $this->input->post('num_cuotas');
            $total_cuotas = count($num_cuotas);
            $vencimientos = $this->input->post('vencimientos');
            $impuestos = $this->input->post('impuestos');
            $montos = $this->input->post('montos');
            $totales = $this->input->post('totales');
            $observacion = $this->input->post('observacion');
            $fecha_plan = date('Y-m-d', strtotime($this->input->post('fecha_plan')));

            $monto_deuda = array_sum($totales);

            $plan_array = array(
                'plg_numero' => 1,
                'plg_monto_deuda' => floatval($monto_deuda),
                'plg_cuotas' => $total_cuotas,
                'plg_fecha_plan' => $fecha_plan,
                'plg_fecha_primera_cuota' => date('Y-m-d', strtotime($vencimientos[0])),
                'plg_observacion' => $observacion,
                'plg_estado' => 1,
                'plg_fecha_crea' => date('Y-m-d H:i:s'),
                'plg_fecha_mod' => date('Y-m-d H:i:s'),
                'plg_usu_crea' => $this->tank_auth->get_user_id(),
                'plg_user_mod' => $this->tank_auth->get_user_id(),
            );

            $plan_id = $this->gsatelite->ingresar('plg_plan_pago', $plan_array);

            $fxs_ids = array();
            //INGRESAR FxP
            $total_impuestos = array_sum($impuestos);
            for ($i = 0; $i < count($facturas); $i++) {
                // Calculamos el porcentaje de cada factura contra el total de la deuda
                $total_factura = $this->gsatelite->get_campo('fac_factura', 'fac_total', array('fac_id' => $facturas[$i]));
                $total_factura = ($total_impuestos > 0) ? floatval($total_factura) + floatval($total_impuestos / count($facturas)) : $total_factura;
                $porcentaje_por_factura = floatval($total_factura) / floatval($monto_deuda);

                $fxp_array = array(
                    'fxp_id_fac' => $facturas[$i],
                    'fxp_id_plg' => $plan_id,
                    'fxp_porcentaje' => round($porcentaje_por_factura, 2),
                    'fxp_estado' => 1,
                    'fxp_fecha_mod' => date('Y-m-d H:i:s'),
                    'fxp_fecha_crea' => date('Y-m-d H:i:s'),
                    'fxp_usu_crea' => $this->tank_auth->get_user_id(),
                    'fxp_user_mod' => $this->tank_auth->get_user_id(),
                );

                $fxs_ids[] = $this->gsatelite->ingresar('fxp_facturaxplan_pago', $fxp_array);
            }

            //INGRESAR CUOTAS
            $cpl_ids = array();
            //INGRESAR FxP
            for ($i = 0; $i < count($num_cuotas); $i++) {

                $fecha = date('Y-m-d', strtotime($vencimientos[$i]));

                $cpl_array = array(
                    'cpl_id_plg' => $plan_id,
                    'cpl_numero' => $num_cuotas[$i],
                    'cpl_monto' => $montos[$i],
                    'cpl_interes' => ($impuestos[$i] != '') ? $impuestos[$i] : 0,
                    'cpl_total' => $totales[$i],
                    'cpl_fecha_vencimiento' => $fecha,
                    'cpl_estado' => 1,
                    'cpl_fecha_mod' => date('Y-m-d H:i:s'),
                    'cpl_fecha_crea' => date('Y-m-d H:i:s'),
                    'cpl_usu_crea' => $this->tank_auth->get_user_id(),
                    'cpl_user_mod' => $this->tank_auth->get_user_id(),
                );

                $cpl_ids[] = $this->gsatelite->ingresar('cpl_cuota_plan_pago', $cpl_array);
            }


            if ($plan_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == '2') {
                redirect('facturacion/facturar/financiamiento');
            } else {
                redirect('facturacion/facturar/agregar_financiamiento');
            }
        }

        $data['titulo_personal'] = 'Financiamiento';

        //$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
        //$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
        $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}', '', array('cli_estado' => '1'), null, '', 'cli_id', true);

        $interes = $this->gsatelite->get_parametro('SYS_IMP_CUOTA');

        $data['max_cuotas'] = $this->gsatelite->get_parametro('SYS_NUM_MAX_CUOTA');

        $interes = $interes / 100;

        $data['interes'] = $interes;

        $this->_cargarvista($data);
    }

    function editar_financiamiento($plg_id = null, $pagadas = 0) {
        satelite_validar();

        if ($plg_id == null) {
            redirect('tarificador/procesos/financiamiento');
        }
        if ($_POST) {
            //die(var_dump($_POST));

            $facturas = $this->input->post('facturas');
            $tipo_btn = $this->input->post('tipo_btn');

            //$monto_deuda = $this->input->post('monto_deuda');

            $num_cuotas = $this->input->post('num_cuotas');

            $total_cuotas = (count($num_cuotas) > 0) ? count($num_cuotas) : $this->input->post('cuotas_total');

            $vencimientos = $this->input->post('vencimientos');
            $impuestos = $this->input->post('impuestos');
            $montos = $this->input->post('montos');
            $totales = $this->input->post('totales');
            $observacion = $this->input->post('observacion');
            $fecha_plan = date('Y-m-d', strtotime($this->input->post('fecha_plan')));
            $monto_deuda = array_sum($totales);

            $plan_array = array(
                'plg_monto_deuda' => floatval($monto_deuda),
                'plg_cuotas' => $total_cuotas,
                'plg_fecha_plan' => $fecha_plan,
                'plg_fecha_primera_cuota' => date('Y-m-d', strtotime($vencimientos[0])),
                'plg_observacion' => $observacion,
                'plg_estado' => 1,
                'plg_fecha_crea' => date('Y-m-d H:i:s'),
                'plg_fecha_mod' => date('Y-m-d H:i:s'),
                'plg_usu_crea' => $this->tank_auth->get_user_id(),
                'plg_user_mod' => $this->tank_auth->get_user_id(),
            );

            $result = $this->gsatelite->actualizar_array('plg_plan_pago', $plan_array, array('plg_id' => $plg_id));

            $total_impuestos = array_sum($impuestos);
            if (count($facturas) > 0 && $facturas != '') {
                $fxs_ids = array();
                //INGRESAR FxP
                for ($i = 0; $i < count($facturas); $i++) {

                    // Calculamos el porcentaje de cada factura contra el total de la deuda
                    $total_factura = $this->gsatelite->get_campo('fac_factura', 'fac_total', array('fac_id' => $facturas[$i]));
                    $total_factura = ($total_impuestos > 0) ? floatval($total_factura) + floatval($total_impuestos / count($facturas)) : $total_factura;
                    $porcentaje_por_factura = floatval($total_factura) / floatval($monto_deuda);

                    $fxp_array = array(
                        'fxp_id_fac' => $facturas[$i],
                        'fxp_id_plg' => $plg_id,
                        'fxp_porcentaje' => round($porcentaje_por_factura, 2),
                        'fxp_estado' => 1,
                        'fxp_fecha_mod' => date('Y-m-d H:i:s'),
                        'fxp_fecha_crea' => date('Y-m-d H:i:s'),
                        'fxp_usu_crea' => $this->tank_auth->get_user_id(),
                        'fxp_user_mod' => $this->tank_auth->get_user_id(),
                    );

                    $fxs_ids[] = $this->gsatelite->ingresar('fxp_facturaxplan_pago', $fxp_array);
                }
            }

            if (count($num_cuotas) > 0 && $num_cuotas != '') {
                //INGRESAR CUOTAS
                $cpl_ids = array();
                //INGRESAR FxP
                for ($i = 0; $i < count($num_cuotas); $i++) {

                    $fecha = date('Y-m-d', strtotime($vencimientos[$i]));

                    $cpl_array = array(
                        'cpl_id_plg' => $plg_id,
                        'cpl_numero' => $num_cuotas[$i],
                        'cpl_monto' => $montos[$i],
                        'cpl_interes' => ($impuestos[$i] != '') ? $impuestos[$i] : 0,
                        'cpl_total' => $totales[$i],
                        'cpl_fecha_vencimiento' => $fecha,
                        'cpl_estado' => 1,
                        'cpl_fecha_mod' => date('Y-m-d H:i:s'),
                        'cpl_fecha_crea' => date('Y-m-d H:i:s'),
                        'cpl_usu_crea' => $this->tank_auth->get_user_id(),
                        'cpl_user_mod' => $this->tank_auth->get_user_id(),
                    );

                    $cpl_ids[] = $this->gsatelite->ingresar('cpl_cuota_plan_pago', $cpl_array);
                }
            }

            if ($result > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) actualizado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al actualizar la información");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == '2') {
                redirect('facturacion/facturar/financiamiento');
            } else {
                redirect('facturacion/facturar/editar_financiamiento/' . $plg_id . '/' . $pagadas);
            }
        }

        $data['titulo_personal'] = 'Financiamiento';

        $facxplan = $this->tarificador_model->get_facturas_plan_pago(array('plg_id' => $plg_id));
        $cliente_id = $facxplan[0]['cli_id'];
        //$tde_id=$this->gsatelite->get_parametro('SYS_TIPO_DOC');
        //$this->db->join('dcc_documento_cliente', 'dcc_id_cli=cli_id AND dcc_id_tde='.$tde_id.'', 'left');
        $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}', '', array('cli_estado' => '1'), $cliente_id, '', 'cli_id', true);


        $data['facturas'] = $this->cargar_facturas($cliente_id);

        $data['facxplan'] = $facxplan;

        $data['monto_deuda'] = array_sum(array_column($facxplan, 'fac_total'));

        //die(var_dump($data['monto_deuda']));

        $this->db->order_by('cpl_numero ASC');
        $data['cuotas_plan'] = $this->tarificador_model->get_cuotas_plan_pago(array('plg_id' => $plg_id));
        $data['plg_id'] = $plg_id;

        $interes = $this->gsatelite->get_parametro('SYS_IMP_CUOTA');

        $data['max_cuotas'] = intval($this->gsatelite->get_parametro('SYS_NUM_MAX_CUOTA'));
        $data['pagadas'] = $pagadas;
        $interes = $interes / 100;

        $data['interes'] = $interes;

        $this->_cargarvista($data);
    }

    public function cargar_facturas($cli_id = 0) {

        if ($_POST) {
            $cli_id = $this->input->post('cli');
        }

        $listado = $this->tarificador_model->get_facturas_cliente(array('sxc_id_cli' => $cli_id, 'fac_estado' => 1));


        $opciones = "<option value='0'>Seleccione</option>";

        if (count($listado) > 0) {
            foreach ($listado as $list) {

                $periodo = date('d-m-Y', strtotime($list['fxs_fecha_inicio'])) . ' - ' . date('d-m-Y', strtotime($list['fxs_fecha_fin']));
                $fecha_ven = date('d-m-Y', strtotime($list['fac_fecha_vencimiento']));
                $nombre_fac = $list['fac_numero'] . ' Monto $' . $list['fac_total'] . ' Vence ' . $fecha_ven;

                $opciones .= '<option value="' . $list['fac_id'] . '" data-servicio="' . $list['src_nombre'] . '" data-num_fac="' . $list['fac_numero'] . '" data-periodo="' . $periodo . '" data-total="' . $list['fac_total'] . '" data-estado="' . $list['fac_estado'] . '">' . $nombre_fac . '</option>';
            }
        }

        if ($_POST) {
            echo $opciones;
        } else {
            return $opciones;
        }
    }

    public function cargar_planes($cli_id = 0) {

        if ($_POST) {
            $cli_id = $this->input->post('cli');
        }

        $this->db->group_by('plg_id');
        $listado = $this->tarificador_model->get_facturas_plan_pago(array('cli_id' => $cli_id));


        $opciones = "<option value='0'>Seleccione</option>";

        if (count($listado) > 0) {
            foreach ($listado as $list) {

                $fecha_plan = date('d-m-Y', strtotime($list['plg_fecha_plan']));

                $nombre_plan = "Plan - " . $list['plg_id'] . " - Monto " . $list['plg_monto_deuda'] . " Cuotas " . $list['plg_cuotas'] . " " . $fecha_plan
                ;

                $opciones .= '<option value="' . $list['plg_id'] . '">' . $nombre_plan . '</option>';
            }
        }

        if ($_POST) {
            echo $opciones;
        } else {
            return $opciones;
        }
    }

    function e_registros_plan_pago($plan = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {

                $factura = $this->input->post('factura');
                $plan = $this->input->post('plan');
                if ($factura > 0) {
                    $where_fxp = array('fxp_id_fac' => $factura, 'fxp_id_plg' => $plan);

                    $result = $this->gsatelite->borrado_general('fxp_facturaxplan_pago', $where_fxp);
                }

                $where_cpl = array('cpl_id_plg' => $plan);
                $result = $this->gsatelite->borrado_general('cpl_cuota_plan_pago', $where_cpl);

                echo $result;
            } else {
                if ($plan != null) {
                    $where_fxp = array('fxp_id_plg' => $plan);

                    $result = $this->gsatelite->borrado_general('fxp_facturaxplan_pago', $where_fxp);

                    $where_cpl = array('cpl_id_plg' => $plan);
                    $result = $this->gsatelite->borrado_general('cpl_cuota_plan_pago', $where_cpl);

                    $result = $this->gsatelite->borrado_general('plg_plan_pago', array('plg_id' => $plan));

                    if ($result > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) eliminado(s) con éxito");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al eliminar la información");
                    }

                    $this->session->set_flashdata($alerta);
                    redirect('tarificador/procesos/financiamiento');
                }
            }
        }
    }

    function consultar_planes_factura($factura = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $factura = $this->input->post('factura');
            }
            $count = $this->tarificador_model->get_facturas_plan_pago(array('fac_id' => $factura));

            if (count($count) > 0) {
                echo 1;
            } else {
                echo 0;
            }
        }
    }

    function calcular_fecha_vencimiento($fecha = null) {

        //$fecha = '31-07-2016';

        $parts = explode('-', ($fecha));

        $dia = intval($parts[0]);
        $dia_principal = intval($parts[0]);
        $mes = intval($parts[1]);
        $anio = intval($parts[2]);
        $dias_vence = 30;



        for ($i = 1; $i <= 1; $i++) {
            if ($mes > 1) {
                $mes++;
            }
            if ($mes == 2) {
                if ($dia_principal > 27) {
                    $dia = date("d", (mktime(0, 0, 0, $mes + 1, 1, $anio) - 1));
                }
            } else {
                $dia = $dia_principal + 1;
                if ($dia_principal > 30) {
                    $dia = date("d", (mktime(0, 0, 0, $mes + 1, 1, $anio) - 1));
                }
            }

            if ($mes > 12) {
                $mes = 1;
                $anio++;
            }
            $fecha = $dia . '-' . ($mes < 10 ? '0' : '') . $mes . '-' . $anio;
        }
        return $fecha;
    }

    function cargar_info_cuota() {
        $id_cli = $this->input->post('id_cli');
        $id_plg = $this->input->post('id_plg');
        $detalle_cuota = $this->facturacion_model->cuotas_cliente($id_cli, $id_plg);
        $pago = '<option value=""> </option>';
        foreach ($detalle_cuota as $dc) {
            $html = '<tr><td>' . $dc['cpl_numero'] . '<input type="hidden" name="cpl_id" id="cpl_id" value="' . $dc['cpl_id'] . '"></td><td>Cuota ' . $dc['cpl_numero'] . '</td><td>1</td>';
            $html .= '<td>' . $dc['cpl_monto'] . '</td><td>' . $dc['cpl_interes'] . '</td><td>' . $dc['cpl_total'] . '</td>';

            $tif = $dc['tif_nombre'];
            $tpg_id = $dc['fac_id_tpg'];
            $tpg = $dc['tpg_nombre'];
            $pago .= '<option value="' . $tpg_id . '"> ' . $tpg . '</option>';

            $subtotal = $dc['cpl_total'];
            $imp = $dc['cpl_interes'];
            $monto = $dc['cpl_monto'];
            $vence = $dc['cpl_fecha_vencimiento'];
        }

        $fecha_vence = date('Y-m-d', strtotime($vence));
        $hoy = date('Y-m-d');
        $mora = 0;
        if ($fecha_vence < $hoy) {
            $mora = $this->gsatelite->get_parametro('SYS_MORA_FAC');
        }

        echo json_encode(array('filas' => $html, 'fac' => $tif, 'pago' => $pago, 'total' => $subtotal, 'monto' => $monto, 'impuesto' => $imp, 'tipo' => $tif, 'tpg_id' => $tpg_id, 'mora' => $mora));
    }

    //Insertar en fxs_facturaxservicio y cxs_cargoxfacturacion
    function ingresa_detalle($id_fac, $sxc_id, $fecha_ini, $fecha_fin) {
        //die(print_r($id_fac.'/'.$sxc_id.'/'.$fecha_ini.'/'.$fecha_fin));
        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fec_fin = date('Y-m-d', strtotime($fecha_fin));
        $coma = strpos($sxc_id, ',');
        if ($coma != '') {
            $sxc_fac = explode(',', $sxc_id);
        } else {
            $sxc_fac = $sxc_id;
        }
        //die(print_r($sxc_fac).print_r($fecha_inicio.'*'.$fec_fin));
        if (count($sxc_fac) > 0) {
            foreach ($sxc_fac as $key => $fac) {
                /*                 * ****************Insertar fxs********************* */
                $array_fxs = array(
                    'fxs_id_sxc' => $fac,
                    'fxs_id_fac' => $id_fac,
                    'fxs_fecha_inicio' => date('Y-m-d H:i:s', strtotime($fecha_inicio)),
                    'fxs_fecha_fin' => date('Y-m-d H:i:s', strtotime($fec_fin)),
                    'fxs_estado' => 1,
                    'fxs_fecha_crea' => date('Y-m-d H:i:s'),
                    'fxs_usu_crea' => $this->tank_auth->get_user_id(),
                    'fxs_fecha_mod' => date('Y-m-d H:i:s'),
                    'fxs_usu_mod' => $this->tank_auth->get_user_id()
                );

                $where_fxs = array('date_format(fxs_fecha_inicio,"%Y-%m-%d")' => $fecha_inicio, 'date_format(fxs_fecha_fin,"%Y-%m-%d")' => $fec_fin, 'fxs_id_sxc' => $fac, 'fxs_id_fac' => $id_fac);
                $fxs_bd = $this->gsatelite->get_registro('fxs_facturaxservicio', $where_fxs);

                if (count($fxs_bd) > 0) {
                    $fxs_id = $fxs_bd->fxs_id;
                    //$fxs=$this->gsatelite->actualizar_array('fxs_facturaxservicio', $array_fxs, array('fxs_id'=>$fxs_id));
                } else {
                    //$fxs_id=$this->gsatelite->ingresar('fxs_facturaxservicio', $array_fxs);
                }

                /*                 * ******************************************** */

                /*                 * ****************Insertar cxs ********************* */

                $where = array('caf_id_sxc' => $fac);
                $detalle_caf_fijos = $this->facturacion_model->get_fijos_caf($where, 1, 1);
                //die(print_r($this->db->last_query()));

                foreach ($detalle_caf_fijos as $caf) {
                    $array_cxs [] = array(
                        'cxs_id_caf' => $caf['caf_id'],
                        'cxs_id_fxs' => $fxs,
                        'cxs_estado' => 1,
                        'cxs_fecha_crea' => date('Y-m-d H:i:s'),
                        'cxs_usu_crea' => $this->tank_auth->get_user_id(),
                        'cxs_fecha_mod' => date('Y-m-d H:i:s'),
                        'cxs_usu_mod' => $this->tank_auth->get_user_id()
                    );
                }
                /*                 * ******************************************** */
            }
        }
        die();
    }

    function get_tipo_factura() {
        $retXcli = array();
        $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
        $not_debi   = (isset($parametros['NOTA DEBITO'])) ? $parametros['NOTA DEBITO'] : 0;
        $not_cred   = (isset($parametros['NOTA CREDITO'])) ? $parametros['NOTA CREDITO'] : 0;
        $not_remi   = (isset($parametros['NOTA REMISION'])) ? $parametros['NOTA REMISION'] : 0;
        $excluidas  = implode(',', array($not_cred, $not_remi, $not_debi));
        $cliente               = $this->input->post('cliente');
        $cliente_array         = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cliente) );
        $dias_antiguedad_saldo = ($this->input->post('dias_antiguedad_saldo') != "")?$this->input->post('dias_antiguedad_saldo'):"90";

        $dias_plazo = $cliente_array[0]['cli_dias_plazo'];
        $tipo_fac   = $cliente_array[0]['cli_id_tif'];
        $tipo_pago  = $cliente_array[0]['cli_id_tpg'];
        $frp_pago       = $cliente_array[0]['cli_id_frp'];
        $nombre_factura = $cliente_array[0]['cli_nombre_factura'];
        $grancontrib    = ($cliente_array[0]['cli_es_gran_contribuyente'] != '') ? $cliente_array[0]['cli_es_gran_contribuyente'] : 0;

                              $this->db->join('ret_retencion', 'rxc_id_ret = ret_id');
        $retencion_cliente  = $this->gsatelite->get_tabla('rxc_retencionxcliente', array('rxc_id_cli' => $cliente, 'ret_valor_minimo >' => 0));
        if (count($retencion_cliente) > 0) {
            foreach ($retencion_cliente as $key => $value) {
                array_push($retXcli, $value['rxc_id_ret']);
            }
        }
        $ret_cliente = (count($retXcli) > 0) ? json_encode($retXcli) : "";
        $dias_plazo         = $cliente_array[0]['cli_dias_plazo'];
        $dias_plazo         = (trim($dias_plazo) != '')?$dias_plazo:'';
        $tipo_vencimiento   = $cliente_array[0]['cli_tipo_fac_vence'];
        $datos_adicionales  = $this->facturacion_model->get_datos_saldo($cliente);

        $limite_credito     = (trim($datos_adicionales[0]['cli_monto_credito']) != '') ? $datos_adicionales[0]['cli_monto_credito'] : 0;
        $saldo_pendiente    = (trim($datos_adicionales[0]['fac_monto_pendiente']) != '') ? $datos_adicionales[0]['fac_monto_pendiente'] : 0;
        /* **** Seleccion de Tipo de Factura **** */
                          $this->db->limit('1');
        $factura_defecto= $this->gsatelite->get_campo('tif_tipo_factura', 'tif_id', array('tif_defecto'=>1, 'tif_estado'=>1, 'tif_aplica_venta'=>1));
        $tipo_factura   = (trim($tipo_fac)>0)?$tipo_fac:$factura_defecto;  // Colocar factura si tiene, sino colocar la por defecto
        $nombre_cliente = ($cliente_array[0]['cli_personeria'] == 2)?$cliente_array[0]['cli_apellido']:$cliente_array[0]['cli_nombre']." ".$cliente_array[0]['cli_apellido'];
        $nombre_factura = (trim($nombre_factura) != null)?$nombre_factura:$nombre_cliente;
        $tipos = '<option value=""></option>';
        $excluidas = ($excluidas == '') ? '0' : $excluidas;
        $tipos_factura  = $this->gsatelite->get_tabla("tif_tipo_factura", array("tif_estado" => 1,"tif_aplica_venta" => 1,"tif_id NOT IN ($excluidas)" => NULL));
        foreach ($tipos_factura as $k) {
            $slctd = ($k['tif_id'] == $tipo_factura) ? 'selected' : '';
            $tipos .= '<option value="'.$k['tif_id'].'" data-nrc="'.$k['tif_aplica_nrc'].'" data-info="'.$k['tif_monto_minimo'].'" '.$slctd.'>'.$k['tif_nombre'].'</option>';
        }
        /* ************************************** */
        // Obtener el primer documento del cliente
        $dcc        = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $cliente, 'dcc_estado' => 1));
        $documento  = (count($dcc) > 0) ? $dcc[0]['dcc_valor'] : '';
        /* **** Seleccion de Tipo de Pago **** */
                        $this->db->limit('1');
        $pago_defecto = $this->gsatelite->get_campo('tpg_tipo_pago', 'tpg_id', array('tpg_defecto'=>1, 'tpg_estado'=>1));
        $tip_pago    = (trim($tipo_pago)>0) ? $tipo_pago : $pago_defecto;  // Colocar pago si tiene, sino colocar la por defecto
        //$tipos_pago   = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $tip_pago, '', 'tpg_id', true);
        $tipos_pago   = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1));
        $option_tpg = '<option value="0">Seleccione</option>';
        foreach ($tipos_pago as $key2) {
            $selected_ = ($key2['tpg_id'] == $tip_pago) ? 'selected' : '';//antes tpg_aplica_contado
            $option_tpg .= '<option value="'.$key2['tpg_id'].'" data-aplcred="' . intval($key2['tpg_aplica_credito']) . '" '.$selected_.'>'.$key2['tpg_nombre'].'</option>';
        }
        $tipos_pago   = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $option_tpg);
        /* ************************************** */
        /* **** Seleccion de Forma de Pago **** */
                              $this->db->limit('1');
        $forma_pago_defecto = $this->gsatelite->get_campo('frp_forma_pago', 'frp_id', array('frp_defecto'=>1, 'frp_estado'=>1));
        $formas_pago  = (trim($frp_pago)>0)?$frp_pago:$forma_pago_defecto;  // Colocar pago si tiene, sino colocar la por defecto
        $forma_pago  = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => '1'), $formas_pago, '', 'frp_id', true);
        $forma_pago   = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $forma_pago);
        /* ************************************** */
        /*************** Mora *******************/
                         $this->db->limit('1');
        $facturas_mora = $this->gsatelite->get_tabla('fac_factura',array('TIMESTAMPDIFF(DAY,fac_fecha_vencimiento, CURRENT_DATE()) >' => $dias_antiguedad_saldo, 'fac_id_cli'=>$cliente, 'fac_estado' =>1));
        /* ************************************** */
        /************ Empresa/Convenio ************/
                              $this->db->join('alm_alumno', 'alm_id = clm_id_alm'); $this->db->group_by('alm_id');
        $empresa_convenio   = $this->gsatelite->get_dropdown('clm_cliente_alumno', '{alm_nombre} {alm_apellido}', '', array('clm_estado' => '1', 'clm_id_cli'=>$cliente), null, '', 'clm_id', true);
        $empresa_convenio   = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $empresa_convenio);
        /* ************************************** */

        /************ Sugerido de Vendedor ************/
        $ven_id     = ($cliente_array[0]['cli_id_ven'] > 0) ? $cliente_array[0]['cli_id_ven'] : "";
        /**********************************************/
        $respuesta = array(
            'tipos'             => $tipos,
            'tif'               => $tipo_fac,
            'tpg'               => $tipo_pago,
            'tipo_pago'         => $tipos_pago,
            'saldo_pendiente'   => $saldo_pendiente,
            'limite_credito'    => $limite_credito,
            'forma_pago'        => $forma_pago,
            'nombre_fac'        => $nombre_factura,
            'moroso'            => count($facturas_mora),
            'dias_plazo'        => $dias_plazo,
            'empresa_convenio'  => $empresa_convenio,
            'tipo_vencimiento'  => $tipo_vencimiento,
            'vendedor'          => $ven_id,
            'filtrarvendedor'   => $this->gsatelite->get_parametro('SYS_FAC_FILTRO_VENDEDOR', 1),//SI ESTA EN 0 INAHIBILTA EL SELECT DE VENDEDOR
            'doc_cliente'       => $documento,
            'grancont'          => $grancontrib,
            'ret_cli'           => $ret_cliente
        );
        echo json_encode($respuesta);
    }

    function get_series_tif() {
        $tipo = $this->input->post('tipo_fac');
        $caja = $this->input->post('caja');
        $idcliente = $this->input->post('idcliente');
        //Validar si es permitido el tipo de factura para el cliente
        $validacion_tif = $this->validar_tipo_factura_por_empleado($idcliente, $tipo);

        $tipo_fac = $this->facturacion_model->nuevas_series($tipo, $caja);
        $datos = '';
        foreach ($tipo_fac as $key) {
            $num_final = ($key['cof_fin'] < 0) ? 'Ilimitado' : $key['cof_fin'];
            $datos .= '<option value="' . $key['cof_id'] . '" selected>' . $key['sef_nombre'] .' ('.$key['cof_inicio'] . '-' . $num_final . ')</option>';
        }
        if (count($tipo_fac) <= 0) {
            echo json_encode(array('tipo' => $datos, 'datos' => 1, 'validacion_tif' => $validacion_tif));
        } else {
            echo json_encode(array('tipo' => $datos, 'datos' => 0, 'validacion_tif' => $validacion_tif));
        }
    }

    function apertura_remesa_caja() {
        // Validar que existe el tipo de factura ticket para imprimir corte o cierre
        $ticket            = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('TICKET'));
        $verificar_tk      = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_id'=>$ticket, 'tif_estado'=>1));
        $data['existe_tk'] = (count($verificar_tk) > 0) ? 1 : 0;
        /***********************************************/
        $data['grid'] = $this->facturacion_model->cajas_asignadas_grid();
        $data['titulo_personal'] = 'Nueva apertura y remesa';
        $this->_cargarvista($data);
    }

    function agregar_apertura_remesa_caja() {
        satelite_validar();
        if ($_POST) {
            // die(var_dump($_POST));
            //nos cambia el estado de la caja actual
            $id_uxc_edit = $this->input->post('id_uxc_edit');
            $uxc_array = array(
                'uxc_estado' => 0,
            );
            // Se actualiza el estado de todos los registros de la caja a 0
            $this->gsatelite->actualizar_array('uxc_usuarioxcaja', $uxc_array, array('uxc_id_caj' => $this->input->post('caja')));
            $redirect = $this->input->post('redirect');
            $hora = date('H:i:s');
            $fecha_inicio = formatear_fecha('Y-m-d', $this->input->post('fecha'));
            $fecha_proceso = $fecha_inicio . ' ' . $hora;
            $caja = $this->input->post('caja');
            $facturar_actual = ($this->input->post('fac_act') != '') ? (($this->input->post('fac_act') == 'on' || is_numeric($this->input->post('fac_act'))) ? 1 : 0) : 0 ;
            $secuencia = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id_caj' => $caja));
            $total_sec = count($secuencia) + 1; 
            $es_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);

            // Tipo de Proceso(1:Apertura, 2:Corte, 3:Cierre)
            $caja_cerrada = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_fecha_proceso'=>$fecha_inicio, 'uxc_tipo'=>3, 'uxc_id_caj'=>$caja));
            if(count($caja_cerrada) > 0){
                $caja_actualizar_array = array(
                    'uxc_tipo' => 2,
                    'uxc_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('uxc_usuarioxcaja', $caja_actualizar_array, array('uxc_id' => $caja_cerrada[0]['uxc_id']));
            }
            $uxc_array = array(
                'uxc_id_caj' => $this->input->post('caja'),
                'uxc_id_usu' => $this->input->post('cajero'),
                'uxc_fecha' => date('Y-m-d H:i:s'),
                'uxc_fecha_proceso' => $fecha_proceso,
                'uxc_tipo' => $this->input->post('proceso'),
                'uxc_sec' => $total_sec,
                'uxc_monto' => $this->input->post('monto'),
                'uxc_estado' => 1,
                'uxc_usu_mod' => $this->tank_auth->get_user_id(),
                'uxc_fecha_mod' => date('Y-m-d H:i:s'),
                'uxc_fecha_crea' => date('Y-m-d h:i:s'),
                'uxc_usu_crea' => $this->tank_auth->get_user_id(),
                'uxc_fecha_utiliza' => ($es_fact_elect == 1) ? 1 : $facturar_actual
            );
            $respuesta = $this->gsatelite->ingresar('uxc_usuarioxcaja', $uxc_array);

            // Hacer corte o cierre
            /***********************************************************************
            *   Tipo: 2 = Corte
                      3 = Cierre
            */
            $tipo = $this->input->post('proceso');
            if ($id_uxc_edit > 0 && ($tipo > 1 && $tipo < 4)) {
                $this->generar_corte_cierre_caja($id_uxc_edit, null, $tipo);
            }

            $this->session->set_flashdata('id_uxc', $id_uxc_edit);
            $this->session->set_flashdata('tipo', $tipo);
            /**********************************************************************/

            $redirect = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            if ($redirect == '2') {
                redirect('facturacion/facturar/apertura_remesa_caja');
            } else {
                redirect('facturacion/facturar/agregar_apertura_remesa_caja');
            }
        }
        // Validar que existe el tipo de factura ticket para imprimir corte o cierre
        $ticket            = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('TICKET'));
        $verificar_tk      = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_id'=>$ticket, 'tif_estado'=>1));
        $data['existe_tk'] = (count($verificar_tk)>0)?1:0;
        /***********************************************/
        $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
        $data['titulo_personal'] = 'Apertura y remesa de caja';
        $cajas = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}', '', array('caj_estado' => '1'), null, '', 'caj_id', true);
        $data["cajas"] = str_replace('<option value="0">Seleccione</option>', '', $cajas);
        $data['cajeros'] = $this->facturacion_model->cajeros($rol);
        $this->_cargarvista($data);
    }

    public function editar_apertura_remesa_caja($uxc_id) {
        $data['uxc_id'] = $uxc_id;
        $data['informacion_uxc'] = $this->facturacion_model->datos_uxc_edit($uxc_id);
        //print_r($this->db->last_query()); die();
        $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');

        $data['cajeros'] = $this->facturacion_model->cajeros($rol);

        $data['titulo_personal'] = 'Editar apertura y remesa de caja';
        $this->_cargarvista($data);
    }

    public function guardar_cambios_aper($uxc_id) {
        $id_cxu = $this->input->post('uxc_id');
        $hora = date('H:i:s');
        $fecha_ini = $this->input->post('fecha');
        $fecha_inicio = date('Y-m-d', strtotime($fecha_ini));
        $fecha_proceso = $fecha_inicio . ' ' . $hora;
        //  $cajas = $this->input->post('caja');
        //  $secuencia = $this->gsatelite->get_tabla('uxc_usuarioxcaja',array('uxc_id_caj'=>$caja,'uxc_estado'=>1) );
        $uxc_array = array(
            'uxc_id_caj' => $this->input->post('caja'),
            'uxc_id_usu' => $this->input->post('cajero'),
            'uxc_fecha' => $fecha_proceso,
            'uxc_fecha_proceso' => $fecha_proceso,
            'uxc_tipo' => $this->input->post('proceso'),
            'uxc_sec' => $this->input->post('uxc_sec'),
            'uxc_monto' => $this->input->post('monto'),
            'uxc_estado' => $this->input->post('estado'),
            'uxc_usu_mod' => $this->tank_auth->get_user_id(),
            'uxc_fecha_mod' => date('Y-m-d H:i:s'),
            'uxc_fecha_crea' => $this->input->post('uxc_fecha_crea'),
            'uxc_usu_crea' => $this->input->post('uxc_usu_crea')
        );

        $redirect = $this->input->post('redirect');
        $respuesta = $this->gsatelite->actualizar_array('uxc_usuarioxcaja', $uxc_array, array('uxc_id' => $id_cxu));
        if ($respuesta > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Actualización realizada con éxito");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al actualizar la información");
        }

        $this->session->set_flashdata($alerta);

        if ($redirect == '2') {
            redirect('facturacion/facturar/apertura_remesa_caja');
        } else {
            redirect('facturacion/facturar/editar_apertura_remesa_caja/' . $id_cxu);
        }
    }

    public function validar_cajaxusuario() {
        $caja = $this->input->post('caja');
        $cajero = $this->input->post('user');
        $tipo_proceso = ($this->input->post('tipo_proceso')) ? $this->input->post('tipo_proceso') : 0;

        $uxc = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_estado' => 1, 'uxc_tipo'=>1, 'uxc_id_usu'=>$cajero));
        $ticket = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('TICKET'));

        //aplica ticket
        if ($ticket > 0 && $tipo_proceso>1 ) { //no aplica en apertura de caja
            // Obtener el correlativo para la tira de corte o cierre
            $corr_ticket = $this->generar_correlativo_corte_cierre($caja);
            if(!isset($corr_ticket['error'])){
                $correlativo_val = (isset($corr_ticket['correlativo']))?$corr_ticket['correlativo']:null;
            }
            if($correlativo_val == null){
                echo json_encode(array('resp' => 2,'error'=>1));
                die();
            }
        }

        // print_r($this->db->last_query());
        //print_r($uxc);
        // print_r($cajero);
        if(count($uxc) > 0){
            foreach ($uxc as $uxxc) {
                if ($cajero == $uxxc['uxc_id_usu'] && $caja == $uxxc['uxc_id_caj']) {
                    echo json_encode(array('resp' => 1));
                    die();
                } else if ($cajero == $uxxc['uxc_id_usu']) {
                    echo json_encode(array('resp' => 2));
                    die();
                }
            }
        } else{
            echo json_encode(array('resp' => 3));
            die();
        }
    }

    public function info_cajas() {

        $id_caja    = (is_numeric($this->input->post('id_caja')) && $this->input->post('id_caja')>0)?$this->input->post('id_caja'):0;
        $fecha      = date("Y-m-d");
        $datos_caje = $this->facturacion_model->datos_caja_asignadas($id_caja);
        $cajero     = '<option value=""></option>';
        $proceso    = '<option value=""></option>';
        $fecha      = date('d-m-Y');
        $sucursal   = '';
        $monto      = 0;
        $fecha_caj = '';
        if (!empty($datos_caje)) {
            foreach ($datos_caje as $dat_ca) {
                if ($dat_ca['uxc_tipo'] == 1) {
                    $cajero = '';
                    $nombre_cajero = (is_null($dat_ca['emp_id'])) ? $dat_ca['username'] : $dat_ca['emp_nombre'] . " " . $dat_ca['emp_apellido'];
                    $cajero .= "<option value='" . $dat_ca['uxc_id_usu'] . "'selected='selected'>" . $nombre_cajero . "</option>";
                    $proceso .= '<option value="2" selected>Corte(Diario)</option><option value="3">Cierre</option>';
                    $fecha = date('d-m-Y', strtotime($dat_ca['uxc_fecha_proceso']));
                    $id_uxc_edit = '<input type="hidden" name="id_uxc_edit" id="id_uxc_edit" class="soloNumeros" value="' . $dat_ca['uxc_id'] . '">';
                    // Sucursal asociada al empleado
                    $sucursal = $dat_ca['suc_nombre'];
                    // Monto sugerido
                    $monto    = $this->gsatelite->get_suma("fac_factura", "fac_total", array("fac_id_uxc"=>$dat_ca['uxc_id']));
                    $caso = 1; // Corte o Cierre de caja
                } elseif ($dat_ca['uxc_tipo'] == 2) {
                    $proceso .= '<option value="1" selected>Reapertura</option><option value="3">Cierre</option>';
                    $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
                    $cajeros = $this->facturacion_model->cajeros($rol);
                    foreach ($cajeros as $caj) {
                        $nombre_cajero = (is_null($caj['emp_id'])) ? $caj['username'] : $caj['emp_nombre'] . " " . $caj['emp_apellido'];
                        $cajero .= "<option value='" . $caj['id'] . "'>" . $nombre_cajero . "</option>";
                    }
                    //$fecha = date('d-m-Y', strtotime($dat_ca['uxc_fecha_proceso']));
                    $fecha = date('d-m-Y', strtotime($dat_ca['uxc_fecha_proceso']));
                    $id_uxc_edit = '<input type="hidden" name="id_uxc_edit" id="id_uxc_edit" class="soloNumeros" value="' . $dat_ca['uxc_id'] . '">';
                    // Obtener el ID anterior
                    $this->db->order_by('uxc_id', 'DESC');
                    $anterior_id = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id_caj'=>$id_caja, 'uxc_tipo'=>1));
                    // Verificar que hay registros para proceder a verificar el monto
                    if (count($anterior_id)>0) {
                        $monto       = $this->gsatelite->get_suma('fac_factura', 'fac_total', array('fac_id_uxc'=>$anterior_id[0]['uxc_id']));
                    } else {
                        $monto = 0;
                    }
                    $sucursal = $dat_ca['suc_nombre'];
                    $caso = 2; // Reapertura o cierre de caja
                } elseif ($dat_ca['uxc_tipo'] == 3) {
                    $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
                    $cajeros = $this->facturacion_model->cajeros($rol);
                    foreach ($cajeros as $caj) {
                        $nombre_cajero = (is_null($caj['emp_id'])) ? $caj['username'] : $caj['emp_nombre'] . " " . $caj['emp_apellido'];
                        $cajero .= "<option value='" . $caj['id'] . "'>" . $nombre_cajero . "</option>";
                    }
                    $proceso .= '<option value="1" selected>Apertura</option>';
                    $id_uxc_edit = '<input type="hidden" name="id_uxc_edit" id="id_uxc_edit" class="soloNumeros" value="' . $dat_ca['uxc_id'] . '">';
                    $caso = 3; // Apertura de caja
                    $fecha_caj = date('d-m-Y', strtotime($dat_ca['uxc_fecha_proceso']));
                }
            }
        } else {
            $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $cajeros = $this->facturacion_model->cajeros($rol);
            foreach ($cajeros as $caj) {
                $nombre_cajero = (is_null($caj['emp_id'])) ? $caj['username'] : $caj['emp_nombre'] . " " . $caj['emp_apellido'];
                $cajero .= "<option value='" . $caj['id'] . "'>" . $nombre_cajero . "</option>";
            }
            $proceso .= '<option value="1" selected>Apertura</option>';
            $caso = 4;
        }

        $arreglo = array('fecha' => $fecha, 'cajero' => $cajero, 'proceso' => $proceso, 'caso' => $caso, 'id_uxc_edit' => $id_uxc_edit, 'sucursal' => $sucursal, 'monto' => $monto,'fecha_cierre'=>$fecha_caj);
        echo json_encode($arreglo);
    }
    /*****
     * @Autor: Manuel Anzora
     * @Create: 28/12/2018
     * @Description: metodo para buscar el cierre de una caja en una fecha determinada.
     * @Param: los parametros se envia median post de un ajax.
    */
    public function get_info_caja(){
        if($_POST){
            $caja = $this->input->post('caja');
            $fecha = date('Y-m-d', strtotime($this->input->post('fecha')));
            $datos = $this->facturacion_model->get_dato_caja($caja, $fecha);
            $band=0;
            if(count($datos)>0){
                $band = 1;
            }
            //RETORNA 1 SI EXISTE UN CIERRE DE CAJA
            echo $band;
        }
    }
    public function detalle_caja() {
        $id = $this->input->post('caja_asig');
        $datos_caje = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id'=>$id));
        //$datos_caje = $this->facturacion_model->datos_caja_asignadas($id_caja);
        $cajero = 0;
        if (!empty($datos_caje)) {
            foreach ($datos_caje as $dat_ca) {
                if ($dat_ca['uxc_tipo'] == 2) {
                    $cajero = $dat_ca['uxc_id_usu'];
                }
            }
        }

        $arreglo = array('cajero' => $cajero);
        echo json_encode($arreglo);
    }

    /*
     * @method: Obtener el costo promedio de un producto.
     * @description: Migrado desde el modulo de inventarios.
     */

    function crear_pago_factura($cliente = null, $factura = null, $redireccionar = 3, $tipo = null) {
        satelite_validar();
        $this->load->library('../controllers/modulo_cuentas_cobrar/procesos');
        $info = $this->procesos->crear_pago($cliente, $factura, null, 3);
        $info['tipo'] = $tipo;
        $info['redireccionar'] = $redireccionar; // caso 1 para facturacion
        $data['tipo'] = $tipo;
        $data['redireccionar'] = $redireccionar; // caso 1 para facturacion
        $data['html'] = $this->load->view('modulo_cuentas_cobrar/procesos/crear_pago', $info, true);
        $this->_cargarvista($data);
    }

    function costo_promedio_salida($id_art, $bodega_bod, $sector = null) {
        $cantidad_entrada = 0;
        $costo_entrada = 0;
        $cantidad_salida = 0;
        $costo_salida = 0;
        if ($sector != null) {
            $dee_detalle = $this->inventario_model->get_costo_promedio(array('sar_id_art' => $id_art, 'sar_id_bod' => $bodega_bod, 'sar_id_sxb' => $sector));
        } else {
            $dee_detalle = $this->inventario_model->get_costo_promedio(array('sar_id_art' => $id_art, 'sar_id_bod' => $bodega_bod));
        }

        //print_r($dee_detalle);exit();die();

        foreach ($dee_detalle as $key) {
            $datos = explode(" ", $key["valores"]);
            $cantidad_entrada += $datos[0];
            $costo_entrada += $datos[1];
            $cantidad_salida += $datos[2];
            $costo_salida += $datos[3];
        }
        //$cantidades = $this->inventario_model->get_costo_promedio(array('art_id'=>$id_art, 'bod_id'=>$bodega_bod));
        if(($cantidad_entrada - $cantidad_salida) == 0){
            $costo_promedio = 0.00;
        }else{
            $costo_promedio = (($costo_entrada - $costo_salida) / ($cantidad_entrada - $cantidad_salida));
        }

        return $costo_promedio;
    }

    /*
     * @method: Grid de pagos.
     * @description: Migrado desde el módulo de cantas por cobrar.
     */

    public function pagos_fac() {
        satelite_validar();
        $this->load->library('../controllers/modulo_cuentas_cobrar/procesos');
        $info = $this->procesos->pagos(true);
        $data['html'] = $this->load->view('modulo_cuentas_cobrar/procesos/pagos', $info, true);
        $this->_cargarvista($data);
    }

    public function get_sucursal_cli(){
        satelite_validar();
        $id_cli = $this->input->post('id');

        $sucursal_cli = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_codigo} - {scl_nombre}', '', array('scl_estado'=>1, 'scl_id_cli'=>$id_cli), null, '', 'scl_id', true);
        $sucursal_cli = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_cli);
        $sucursal_cli = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $sucursal_cli);
        //$sucursales = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_cli);


        echo json_encode($sucursal_cli);
    }

    public function get_nota_remision(){
        satelite_validar();
        $id_cli = $this->input->post('id');
        $id_nota_remision = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS') ,true);
        $nota_remision_id = (isset($id_nota_remision['NOTA REMISION'])) ? $id_nota_remision['NOTA REMISION'] :0;
        $id_cot = ($this->input->post('cotizacion')) ? implode(",", $this->input->post('cotizacion')) : "";
        $where = array('fac_estado' => 1,
                       'fac_id_cli'=>$id_cli,
                       'fac_id_tif' => $nota_remision_id);
        if ($id_cot != '') {
            $where["fac_id_cot IN ($id_cot)"] = NULL;
        }
        $notas = $this->gsatelite->get_tabla('fac_factura', $where);
        $nota_remision = '<option value=""></option>';
        foreach ($notas as $key => $val) {
            $nota_remision .= '<option value="'.$val['fac_id'].'" data-cliente="'.$val['fac_id_cli'].'">'.$val['fac_numero'].' - '.$val['fac_nombre_factura'].'</option>';
        }
        echo json_encode($nota_remision);
    }

    public function new_precioxtipo_lista_precio(){
        $id_tipl = $this->input->post('tipo_li_pre');
        $art_id  = $this->input->post('producto');
        //Listado de precios
        $precios = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_tlp' => $id_tipl, 'lip_id_art' => $art_id, 'lip_estado' => 1));

        $opciones = "<option></option>";
        $opciones_busqueda = "<option></option>";
        if (count($precios) > 0) {
            foreach ($precios as $lip) {
                $opciones .= "<option data-inicio='" . $lip['lip_desde'] . "' data-fin='" . $lip['lip_hasta'] . "' value='" . $lip['lip_id'] . "'>" . $lip['lip_precio'] . "</option>";
                $opciones_busqueda .= "<option data-inicio='" . $lip['lip_desde'] . "' data-fin='" . $lip['lip_hasta'] . "' value='" . $lip['lip_id_mep'] . "'>" . $lip['lip_precio'] . "</option>";
            }
        }

        $reg = array(
            'rangos_precios' => $opciones_busqueda
        );
        echo json_encode($reg);
    }

   /**
    * @author Habby Lovo
    * @since  19/12/2017
    * @return orden de venta
    */
   function orden_venta($fecha_inicio = null, $fecha_fin = null, $tipo = null) {
       if (!$this->tank_auth->is_logged_in()) {
           redirect('/auth/login/');
       } else {
            $es_jefe = false;
            $roles_usuario = $this->facturacion_model->get_roles_usuario($this->tank_auth->get_user_id());
            $rol_jefe = $this->gsatelite->get_parametro('SYS_ROL_JEFE_UNIDAD');
            $rol_admit = 0;
            foreach ($roles_usuario as $key => $value) {
                if($value == 1){
                    $rol_admit = 1;
                }
                if ($value == $rol_jefe) {
                    $es_jefe = true;
                }
            }
            $permisos = $this->gsatelite->get_permisos_opcion();
            if ($tipo) {
                $url_padre =  $_SERVER['HTTP_REFERER'];
            } else {
                $url_padre = uri_string();
            }
            $es_anulacion = ((substr_count($url_padre, 'orden_venta_anular') > 0 || $permisos['funcion'] == 'orden_venta_anular')) ? true : false;
            if ($fecha_inicio == null && $fecha_fin == null) {
                $fecha_inicio = $this->input->post('txtFechaIni');
                $fecha_fin = $this->input->post('txtFechaFin');
            }
            $output = null;
            $crud = new grocery_CRUD();
            if (trim($fecha_inicio) != '') {
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $crud->where('orv_fecha_orden >=', date('Y-m-d', strtotime($fecha_inicio)));
                    $crud->where('orv_fecha_orden <=', date('Y-m-d H:i:s', strtotime($fecha_fin . " 23:59:59")));

                }
                if($rol_admit != 1){
                    // $crud->where('orv_usu_creacion', $this->tank_auth->get_user_id());
                }
                $filEstado = $this->input->post('filEstado');
                if($filEstado != ""){
                    $crud->where('orv_estado', $filEstado);
                }

                $txtcliente = $this->input->post("txtcliente");
                if($txtcliente != ""){
                    $crud->where('orv_id_cli', $txtcliente);
                }
                $display_as = array(
                    'orv_numero_orden'   => 'No. Orden',
                    'orv_nombre_factura' => 'Nombre factura',
                    'orv_fecha_orden'    => 'Fecha',
                    'orv_id_cli'         => 'Cliente',
                    'orv_total'          => 'Monto',
                    'orv_estado'         => 'Estado'
                );
                $columns = array(
                    'orv_numero_orden',
                    'orv_nombre_factura',
                    'orv_fecha_orden',
                    'orv_id_cli',
                    'orv_total',
                    'orv_estado'
                );
                $crud->set_subject('Orden de venta')
                    ->set_table('orv_orden_venta')
                    ->columns($columns)
                    ->display_as($display_as)
                    ->callback_column('orv_id_cli', function($value, $row) {
                        $cliente_array = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $row->orv_id_cli));
                        $cliente = ($cliente_array[0]["cli_personeria"] == 1)?($cliente_array[0]["cli_codigo"]." - ".$cliente_array[0]["cli_nombre"]." ".$cliente_array[0]["cli_apellido"]):$cliente_array[0]["cli_codigo"]." - ".$cliente_array[0]["cli_apellido"];
                        return $cliente;
                    })
                    ->callback_column('orv_fecha_orden', function($value, $row) {
                        $fecha = (trim($row->orv_fecha_orden) != "") ? formatear_fecha('d/m/Y', trim($row->orv_fecha_orden)): "";
                        return $fecha;
                    })
                    ->callback_column('orv_total', function($value, $row) {
                        $total = '$' . number_format($row->orv_total, 2);
                        return $total;
                    })
                    ->field_type('orv_estado', 'dropdown', array('1' => 'Pendiente de facturar', '2' => 'Facturado',  '3' => 'Anulada'))
                ;

                $crud->unset_add();
                $crud->unset_edit();
                $crud->unset_delete();
                // $crud->unset_print();
                // $crud->unset_export();
                $crud->unset_read();

               if ($es_anulacion) { //verificar si se esta accediendo desde la opción anular orden de venta
                    $crud->add_action('&nbsp;&nbsp;Anular', '', 'facturacion/facturar/anular_orden_venta', 'icomoon-icon-cancel-2 anular_orden', null,'' , array('orv_estado'=>'Pendiente de facturar'));
                    if ($es_jefe) {
                        $crud->add_action('&nbsp;&nbsp;Duplicar', '', 'facturacion/facturar/duplicar_orden_venta', 'icomoon-icon-copy-2 duplicar_orden', null, '', null);
                    }
                } else {
                    $crud->add_action('&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_orden_venta', 'icomoon-icon-printer-2 imprimir', null,''/*, array('orv_estado'=>'Pendiente de facturar')*/);
                    $crud->add_action('&nbsp;&nbsp;Editar', '', 'facturacion/facturar/editar_orden_venta', 'icomoon-icon-copy-2 editar', null,'' , array('orv_estado'=>'Pendiente de facturar'));
                    $crud->add_action('&nbsp;&nbsp;Facturar', '', 'facturacion/facturar/crear_factura', 'icomoon-icon-copy-2 facturar', null,'' , array('orv_estado'=>'Pendiente de facturar'));

                    $crud->add_action('&nbsp;Nota envio', '', 'facturacion/facturar/imprimir_nota_envio', 'icomoon-icon-printer-2 imprimir nota_envio_x', null,'', array('orv_estado <>'=>'Anulada'));
                }


                $output = $crud->render();
            }

            $data['output'] = $output;
            $data['add'] = ($es_anulacion)? 0:$permisos["permite_agregar"];
            $data['titulo_personal'] = ($es_anulacion)? "Anulación Orden de venta":"Orden de venta";

            if ($tipo == null) {
                //$this->_cargarvista($data, $output);
                cargarvista($data,$output,'facturacion/facturar/orden_venta');
            } else {
                print($output->output);
            }

        }
    }

    public function crear_orden_venta(){
        satelite_validar();
        if ($_POST) {
            $dtg_Norden         = (trim($this->input->post('dtg_Norden')) != "") ? $this->input->post('dtg_Norden') : "";
            $dtg_cliente        = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : "";
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
            $dtf_area           = (trim($this->input->post('dtf_area')) != "") ? $this->input->post('dtf_area') : null;
            $personal           = $this->input->post('personal');//NULL
            $dtg_vendedor       = (trim($this->input->post('dtf_vendedor')) != "") ? $this->input->post('dtf_vendedor') : null;
            $observaciones      = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
            $descuentoT_factura_total  = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
            $subtotal_factura_total    = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
            $impuesto_factura_total    = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
            $retencion_factura_total   = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
            $total_factura_total       = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi'))!="") ? $this->input->post('total_factura_total_origi'):0;
            $orv_condicion_pago        = (trim($this->input->post('slc_cond_pago')) != "") ? $this->input->post('slc_cond_pago') : null;
            $orv_comentario            = (trim($this->input->post('txt_comentarios')) != "") ? $this->input->post('txt_comentarios') : null;
            $orv_aplica_picking        = $this->input->post('hdn_picking');
            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;
            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $alerta = "";
            if ($dtg_Norden != "" && $dtg_cliente != "") {
                if ($total_factura_total < 0) {
                   $total_factura_total = 0;
                }
                $ordenes = $this->gsatelite->get_tabla('orv_orden_venta');
                $orden_n = (count($ordenes) + 1);

                           $this->db->order_by('orv_id', 'DESC');
                           $this->db->limit(1);
                $ordenes = $this->gsatelite->get_tabla('orv_orden_venta');
                $orden_n = (isset($ordenes[0]['orv_numero_orden']))? ($ordenes[0]['orv_numero_orden'] + 1):1;
                $orden_array = array(
                    'orv_id_arf' => $dtf_area,
                    'orv_id_cli' => $dtg_cliente,
                    'orv_id_ven' => $dtg_vendedor,
                    //'orv_id_fac' => $dtf_serie,
                    'orv_numero_orden' => $orden_n,
                    'orv_fecha_orden' => date('Y-m-d H:i:s'),
                    'orv_nombre_factura' => $dtg_nombre_factura,
                    'orv_total_retencion' => $retencion_factura_total,
                    'orv_subtotal' => $subtotal_factura_total,
                    'orv_descuento' => $descuentoT_factura_total,
                    'orv_impuesto' => $impuesto_factura_total,
                    'orv_total' => convertirFloat($total_factura_total),
                    'orv_observacion' => $observaciones,
                    'orv_condicion_pago' => $orv_condicion_pago,
                    'orv_comentario' => $orv_comentario,
                    'orv_aplica_picking_list' => $orv_aplica_picking,
                    /*'orv_motivo_anulacion' => $slcProyecto,
                    'orv_fecha_anulacion' => $dtf_factura,*/
                    'orv_estado' => 1,
                    'orv_fecha_creacion' => date('Y-m-d H:i:s'),
                    'orv_usu_creacion' => $this->tank_auth->get_user_id(),
                    'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $orv_id = $this->gsatelite->ingresar('orv_orden_venta', $orden_array);
                //Se guarda el personal de la factura
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                        //tabla pxf_personalxfactura
                        $detalle_personal = array(
                            'pxo_id_orv' => $orv_id,
                            'pxo_id_emp' => $personal[$x],
                            'pxo_estado' => 1,
                            'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxo_personalxorden_venta', $detalle_personal);
                    }
                }
                //columna codigo
                $combo_agrupacion = $this->input->post('combo_agrupacion');
                $aplica_descarga = $this->input->post('aplica_descarga'); //array
                $fecha_garantia = $this->input->post('garantia_factura');
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');
                $tip_producto = $this->input->post('tip_producto');
                $productos_factura = $this->input->post('producto_factura'); //array
                $correlativo = $this->input->post('producto_correlativo'); //array
                $medida_factura = $this->input->post('medida_factura'); //array
                $codigo_factura = $this->input->post('codigo_factura'); //array
                //columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura'); //array
                //columna cantidad
                $cantidad_factura = $this->input->post('cantidad_factura'); //array
                //columna precio
                $precio_factura = $this->input->post('precio_factura'); //array
                //impuesto
                $impuesto_factura = $this->input->post('impuesto_factura'); //array
                $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                $impuesto_array = $this->input->post('impuesto_array'); //array
                $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                //retencion
                $retencion_factura = $this->input->post('retencion_factura'); //array
                $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                $retencion_array = $this->input->post('retencion_array'); //array
                $retencion_por_array = $this->input->post('retencion_por_array'); //array
                //descuento
                $descuento_factura = $this->input->post('descuento_factura'); //array
                $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                //subtotal
                $subtotal_factura = $this->input->post('subtotal_factura'); //array
                //total
                $total_factura = $this->input->post('total_factura'); //array
                $tipo_venta = $this->input->post('tipo_venta'); //array
                $bodega_producto = $this->input->post('bodega_producto'); //array
                //Array costo de venta de producto por detalle
                $dov_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? $this->input->post('costo_venta_por_producto') : null; //array
                //datos de caracteristica
                /*
                  Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                  se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                  el id del producto con el id de la caracteristica para guardar la relacion
                */
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $tipo = $this->input->post('tipo_caracteristica');
                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;
                        if ($aplica_descarga[$x] == 1 && $tip_producto[$x] == 0) {
                            if($combo_agrupacion[$x] == 1){
                                $combos_articulo_array = $this->input->post('combo_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $cantidad_temp_combo = $this->input->post('combo_cantidad_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $combos_cantidad_array = $cantidad_factura[$x]*$cantidad_temp_combo;
                                $combos_medida_array = $this->input->post('combo_medida_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                for($k = 0; $k < count($combos_articulo_array); $k++){
                                    $productos_id_moi[] = $combos_articulo_array[$k];
                                    $produtos_cantidad_moi[] = $combos_cantidad_array[$k];
                                    $productos_medida_moi[] = $combos_medida_array[$k];
                                }
                            } else{
                                $productos_id_moi[] = $productos_factura[$x];
                                $produtos_cantidad_moi[] = $cantidad_factura[$x];
                                $productos_medida_moi[] = $medida_factura[$x];
                            }
                        }
                        $fecha_def = null;
                        if (trim($fecha_text_garantia[$x]) != '') {
                            $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                        }
                        $detalle_factura = array(
                            'dov_id_orv' => $orv_id,
                            'dov_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                            'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                            'dov_id_lip' => $idlip,
                            'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                            'dov_id_bod' => (trim($bodega_producto[$x]) != "") ? $bodega_producto[$x] : null,
                            'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                            'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                            'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                            'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                            'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                            'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                            'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                            'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                            'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                            'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                            'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                            'dov_combo' => (trim($combo_agrupacion[$x]) != "") ? $combo_agrupacion[$x] : null,
                            'dov_precio_inventario' => $dov_costo_venta_por_producto[$x],
                            'dov_estado' => 1,
                            'dov_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dov_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dov_id = $this->gsatelite->ingresar('dov_detalle_orden_venta', $detalle_factura);
                        //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                    //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    $monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                    //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixv_id_dov' => $dov_id,
                                        'ixv_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixv_monto' => $monto_temp,
                                        'ixv_porcentaje' => $impuesto_por[$k],
                                        'ixv_estado' => 1,
                                        'ixv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'ixv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'ixv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'ixv_usu_creacion' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('ixv_impuestoxorden_venta', $detalle_impuesto);
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] != 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    //tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxv_id_dov' => $dov_id,
                                        'rxv_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxv_monto' => $monto_temp,
                                        'rxv_porcentaje' => $retencion_por[$k],
                                        'rxv_estado' => 1,
                                        'rxv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('rxv_retencionxorden_venta', $detalle_retencion);
                                }
                            }
                        }
                        /* ==========================================================================================
                                    COMPONENTES
                        ===========================================================================================*/
                        $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];
                        /* para descargar de bodega             type array*/
                        /*$descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id'.$identificador); // no es arreglo*/
                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente'.$identificador) != '')?$this->input->post('producto_componente'.$identificador):'';
                        $medida_componente = $this->input->post('medida_componente'.$identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente'.$identificador);
                        $precio_componente = $this->input->post('precio_componente'.$identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente'.$identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente'.$identificador);
                        $alternar_componente = $this->input->post('alternar_componente'.$identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if($producto_componente != ''){
                            foreach ($producto_componente as $id_comp => $comp) {
                                /*if ($descargar_componente[$id_comp] == 1 && $tipo_componente[$id_comp] == 0) {
                                    $productos_id_moi[] = $comp;
                                    $produtos_cantidad_moi[] = $cantidad_componente[$id_comp];
                                    $productos_medida_moi[] = $medida_componente[$id_comp];
                                    $producto_bodega_moi[] = $bodega_componente;
                                }*/
                                $componente_sav[] = array(
                                    'cdv_id_dov' => $dov_id,
                                    'cdv_id_cva' => $medida_componente[$id_comp],
                                    'cdv_descripcion' => $descripcion_componente[$id_comp],
                                    'cdv_cantidad' => $cantidad_componente[$id_comp],
                                    'cdv_precio' => $precio_componente[$id_comp],
                                    'cdv_subtotal' => $subtotal_componente[$id_comp],
                                    'cdv_total' => $subtotal_componente[$id_comp],
                                    'cdv_altera_precio' => $alternar_componente[$id_comp],
                                    'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                    'cdv_estado' => 1,
                                    'cdv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'cdv_fecha_creacion' =>  $fecha_creacion,
                                    'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'cdv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('cdv_componente_detallexorden_venta', $componente_sav, true);
                        }
                        /* ====================================================================================================================
                                    FIN COMPONENTES
                        ======================================================================================================================*/
                        /* ====================================================================================================================
                                    CENTRO COSTO
                        ======================================================================================================================*/
                        $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                        $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                        $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                        $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                        $pais_costo = $this->input->post('pais'.$identificador);
                        $costo_sav = array();
                        if($centro_costo_costo != ''){
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcv_id_dov' => $dov_id,
                                    'dcv_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcv_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcv_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcv_id_pai' => ($pais_costo[$id_cost] != "")?$pais_costo[$id_cost]:null,
                                    'dcv_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcv_monto' => $subtotal_costo[$id_cost],
                                    'dcv_estado' => 1,
                                    'dcv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_creacion' =>  $fecha_creacion,
                                    'dcv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcv_detalle_centrocostoxorden_venta', $costo_sav, true);
                        }

                    }
                }
                if (count($productos_id_moi) > 0) {
                    //se comento porque no aplica descarga de inventario en ordend e venta // add by René Castaneda
                    //$this->crear_movimiento($orv_id, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi);
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata($alerta);
            //$this->session->set_flashdata('id_orden_venta', $orv_id);
            if ($redireccion == 0) {
                redirect('facturacion/facturar/crear_orden_venta/');
            } else if ($redireccion == 1) {
                redirect('facturacion/facturar/orden_venta/');
            } else {
                $this->session->set_flashdata('id_orden', $orv_id);
                redirect('facturacion/facturar/crear_orden_venta/');
            }
        }
        $datos["titulo_personal"] = "Agregar orden de venta";
                   $this->db->order_by('orv_id', 'DESC');
                   $this->db->limit(1);
        $ordenes = $this->gsatelite->get_tabla('orv_orden_venta');
        //$datos["numero_orden"] = (count($ordenes) + 1);
        $datos["numero_orden"] = (isset($ordenes[0]['orv_numero_orden'])) ? ($ordenes[0]['orv_numero_orden'] + 1) : 1;
        $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
        $datos['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;
        $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto'=> 1, 'arf_estado'=> 1));
        $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_defecto, '', 'arf_id', true);
        $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
        $vendedor_reg = $this->facturacion_model->obtener_usuarios_rol(array('rol_id'=>5,'id'=>$this->tank_auth->get_user_id()));
        $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
        $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_select);
        $vendedores_select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), (count($vendedor_reg) > 0?$vendedor_reg[0]['ven_id']:null), '', 'ven_id', true);
        $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores_select);
        $datos['vendedor_reg'] = (count($vendedor_reg) > 0) ? 1 : 0;
        $datos['vendedor_defecto'] = (count($vendedor_reg) > 0) ? $vendedor_reg[0]['ven_id'] : "";
        $select = "";
        $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
        foreach ($tip_venta_reg as $key) {
            $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '">' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
        }
        $datos["tipo_venta"] = $select;
        $datos["categorias"] = $this->obtener_categoriaxbodega2();
        $cliente_defecto = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');
        $datos["cliente_defecto"] = ($cliente_defecto > 0) ? $cliente_defecto : '';
        $datos["cliente_defecto_name"] = ($cliente_defecto > 0) ? $this->get_nombre_cliente($cliente_defecto) : '';
        $datos["activar_alerta_productox"] = $this->gsatelite->get_parametro('SYS_NOTIFICACION_EXISTENCIAX');
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $datos['decimales'] = ($decimales != '')?$decimales:2;
        $user=$this->tank_auth->get_user_id();
        $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu'=>$user));
        $select = "";
        foreach ($bodegas_reg as $key) {
            $selected = ($key['uxb_defecto'] == 1)?'selected':'';
            $select .= '<option value="'.$key['bod_id'].'" '.$selected.'>'.$key['bod_nombre'].'</option>';
        }
        $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
        $tpg_credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CREDITO'));
        $datos["tpg_credito"] = ($tpg_credito) ? $tpg_credito : 0;
        $datos["tpg_contado"] = ($tpg_contado) ? $tpg_contado : 0;
        $datos["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
        $datos["bodega_prefe"] = $select;
        $this->_cargarvista($datos, null);
    }

    public function editar_orden_venta($id){
        satelite_validar();
        if ($_POST) {
            $dtg_Norden = (trim($this->input->post('dtg_Norden')) != "") ? $this->input->post('dtg_Norden') : null;
            $dtg_cliente = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null;
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
            $dtf_area = (trim($this->input->post('dtf_area')) != "") ? $this->input->post('dtf_area') : null;
            $personal = $this->input->post('personal');
            $dtg_vendedor = (trim($this->input->post('dtf_vendedor')) != "") ? $this->input->post('dtf_vendedor') : null;
            $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
            $descuentoT_factura_total = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
            $subtotal_factura_total = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
            $impuesto_factura_total = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
            $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
            $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi'):0;
            $orv_condicion_pago        = (trim($this->input->post('slc_cond_pago')) != "") ? $this->input->post('slc_cond_pago') : null;
            $orv_comentario            = (trim($this->input->post('txt_comentarios')) != "") ? $this->input->post('txt_comentarios') : null;
            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;
            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $alerta = "";
            if ($dtg_Norden != "" && $dtg_cliente != "") {
                if ($total_factura_total < 0) {
                   $total_factura_total = 0;
                }
                $orden_array = array(
                    'orv_id_arf' => $dtf_area,
                    'orv_id_cli' => $dtg_cliente,
                    'orv_id_ven' => $dtg_vendedor,
                    'orv_nombre_factura' => $dtg_nombre_factura,
                    'orv_total_retencion' => $retencion_factura_total,
                    'orv_subtotal' => $subtotal_factura_total,
                    'orv_descuento' => $descuentoT_factura_total,
                    'orv_impuesto' => $impuesto_factura_total,
                    'orv_condicion_pago' => $orv_condicion_pago,
                    'orv_comentario' => $orv_comentario,
                    'orv_total' => convertirFloat($total_factura_total),
                    'orv_observacion' => $observaciones,
                    'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('orv_orden_venta', $orden_array, array('orv_id'=>$id));
                //$orv_id = $this->gsatelite->ingresar('orv_orden_venta', $orden_array);
                //Se guarda el personal de la factura
                $this->gsatelite->borrado_general("pxo_personalxorden_venta", array('pxo_id_orv'=>$id));
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                        //tabla pxo_personalxorden_venta
                        $detalle_personal = array(
                            'pxo_id_orv' => $id,
                            'pxo_id_emp' => $personal[$x],
                            'pxo_estado' => 1,
                            'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxo_personalxorden_venta', $detalle_personal);
                    }
                }
                //columna codigo
                $dov_id_grid = $this->input->post('dov_id');
                $combo_agrupacion = $this->input->post('combo_agrupacion');
                $aplica_descarga = $this->input->post('aplica_descarga'); //array
                $fecha_garantia = $this->input->post('garantia_factura');
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');
                $tip_producto = $this->input->post('tip_producto');
                $productos_factura = $this->input->post('producto_factura'); //array
                $correlativo = $this->input->post('producto_correlativo'); //array
                $medida_factura = $this->input->post('medida_factura'); //array
                $codigo_factura = $this->input->post('codigo_factura'); //array
                //columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura'); //array
                //columna cantidad
                $cantidad_factura = $this->input->post('cantidad_factura'); //array
                //columna precio
                $precio_factura = $this->input->post('precio_factura'); //array
                //impuesto
                $impuesto_factura = $this->input->post('impuesto_factura'); //array
                $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                $impuesto_array = $this->input->post('impuesto_array'); //array
                $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                //retencion
                $retencion_factura = $this->input->post('retencion_factura'); //array
                $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                $retencion_array = $this->input->post('retencion_array'); //array
                $retencion_por_array = $this->input->post('retencion_por_array'); //array
                //descuento
                $descuento_factura = $this->input->post('descuento_factura'); //array
                $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                //subtotal
                $subtotal_factura = $this->input->post('subtotal_factura'); //array
                //total
                $total_factura = $this->input->post('total_factura'); //array
                $tipo_venta = $this->input->post('tipo_venta'); //array
                //datos de caracteristica
                /*Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                  se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                  el id del producto con el id de la caracteristica para guardar la relacion*/
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $dov_array = $this->gsatelite->get_tabla('dov_detalle_orden_venta', array('dov_id_orv'=>$id));
                foreach ($dov_array as $key3) {
                    if(!in_array($key3['dov_id'], $dov_id_grid)){
                        $this->gsatelite->borrado_general("ixv_impuestoxorden_venta", array('ixv_id_dov'=>$key3['dov_id']));
                        $this->gsatelite->borrado_general("rxv_retencionxorden_venta", array('rxv_id_dov'=>$key3['dov_id']));
                        $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general('dcv_detalle_centrocostoxorden_venta', array('dcv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general("dov_detalle_orden_venta", array('dov_id'=>$key3['dov_id']));
                    }
                }
                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;
                        if(trim($dov_id_grid[$x]) != ''){
                            $detalle_factura = array(
                                'dov_id_orv' => $id,
                                'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'dov_id_lip' => $idlip,
                                'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('dov_detalle_orden_venta', $detalle_factura, array('dov_id'=>$dov_id_grid[$x]));
                            $dov_id = $dov_id_grid[$x];
                        } else{
                            $detalle_factura = array(
                                'dov_id_orv' => $id,
                                'dov_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                                'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'dov_id_lip' => $idlip,
                                'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'dov_combo' => (trim($combo_agrupacion[$x]) != "") ? $combo_agrupacion[$x] : null,
                                'dov_estado' => 1,
                                'dov_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $dov_id = $this->gsatelite->ingresar('dov_detalle_orden_venta', $detalle_factura);
                        }
                        //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        $this->gsatelite->borrado_general("ixv_impuestoxorden_venta", array('ixv_id_dov'=>$dov_id));
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                    //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    $monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                    //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixv_id_dov' => $dov_id,
                                        'ixv_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixv_monto' => $monto_temp,
                                        'ixv_porcentaje' => $impuesto_por[$k],
                                        'ixv_estado' => 1,
                                        'ixv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'ixv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'ixv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'ixv_usu_creacion' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('ixv_impuestoxorden_venta', $detalle_impuesto);
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        $this->gsatelite->borrado_general("rxv_retencionxorden_venta", array('rxv_id_dov'=>$dov_id));
                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] != 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    //tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxv_id_dov' => $dov_id,
                                        'rxv_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxv_monto' => $monto_temp,
                                        'rxv_porcentaje' => $retencion_por[$k],
                                        'rxv_estado' => 1,
                                        'rxv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('rxv_retencionxorden_venta', $detalle_retencion);
                                }
                            }
                        }
                        /* ==========================================================================
                                    COMPONENTES
                        ==========================================================================*/
                        $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];
                        /* para descargar de bodega             type array*/
                        $tipo_estado = $this->input->post('tipo_estado'.$identificador);
                        $descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id'.$identificador); // no es arreglo
                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente'.$identificador) != '')?$this->input->post('producto_componente'.$identificador):'';
                        $medida_componente = $this->input->post('medida_componente'.$identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente'.$identificador);
                        $precio_componente = $this->input->post('precio_componente'.$identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente'.$identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente'.$identificador);
                        $alternar_componente = $this->input->post('alternar_componente'.$identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);
                        $componentes_reg = $this->gsatelite->get_tabla('cdv_componente_detallexorden_venta', array('cdv_id_dov'=>$dov_id));
                        $fecha_creacion = date('Y-m-d H:i:s');
                        //$componente_up = array();
                        if($tipo_estado != ''){
                            foreach ($componentes_reg as $comp_reg) {
                                if(!in_array($comp_reg['cdv_id'], $tipo_estado)){
                                    $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id' => $comp_reg['cdv_id']));
                                } else{
                                    $indice_comp = array_search($comp_reg['cdv_id'], $tipo_estado);
                                    $componente_up = array(
                                        'cdv_descripcion' => $descripcion_componente[$indice_comp],
                                        'cdv_cantidad' => $cantidad_componente[$indice_comp],
                                        'cdv_precio' => $precio_componente[$indice_comp],
                                        'cdv_subtotal' => $subtotal_componente[$indice_comp],
                                        'cdv_total' => $subtotal_componente[$indice_comp],
                                        'cdv_altera_precio' => $alternar_componente[$indice_comp],
                                        'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$indice_comp],
                                        'cdv_estado' => 1,
                                        'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_modificacion' =>  $fecha_creacion
                                    );
                                    $this->gsatelite->actualizar_array('cdv_componente_detallexorden_venta', $componente_up, array('cdv_id' => $comp_reg['cdv_id']));
                                }
                            }
                        } else{
                            $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id_dov' => $dov_id));
                        }
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if($producto_componente != ''){
                            foreach ($producto_componente as $id_comp => $comp) {
                                if($tipo_estado[$id_comp] == 0){
                                    $componente_sav[] = array(
                                        'cdv_id_dov' => $dov_id,
                                        'cdv_id_cva' => $medida_componente[$id_comp],
                                        'cdv_descripcion' => $descripcion_componente[$id_comp],
                                        'cdv_cantidad' => $cantidad_componente[$id_comp],
                                        'cdv_precio' => $precio_componente[$id_comp],
                                        'cdv_subtotal' => $subtotal_componente[$id_comp],
                                        'cdv_total' => $subtotal_componente[$id_comp],
                                        'cdv_altera_precio' => $alternar_componente[$id_comp],
                                        'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                        'cdv_estado' => 1,
                                        'cdv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_creacion' =>  $fecha_creacion,
                                        'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                            }
                            if(count($componente_sav) > 0){
                                $this->gsatelite->ingresar('cdv_componente_detallexorden_venta', $componente_sav, true);
                            }
                        }
                        /* ====================================================================================================================
                                    FIN COMPONENTES
                        ======================================================================================================================*/
                        /* ====================================================================================================================
                                    CENTRO COSTO
                        ======================================================================================================================*/
                        $this->gsatelite->borrado_general('dcv_detalle_centrocostoxorden_venta', array('dcv_id_dov' => $dov_id));
                        $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                        $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                        $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                        $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                        $pais_costo = $this->input->post('pais'.$identificador);
                        $costo_sav = array();
                        if($centro_costo_costo != ''){
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcv_id_dov' => $dov_id,
                                    'dcv_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcv_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcv_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcv_id_pai' => ($pais_costo[$id_cost] != "")?$pais_costo[$id_cost]:null,
                                    'dcv_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcv_monto' => $subtotal_costo[$id_cost],
                                    'dcv_estado' => 1,
                                    'dcv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_creacion' =>  $fecha_creacion,
                                    'dcv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcv_detalle_centrocostoxorden_venta', $costo_sav, true);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de orden de venta", 'texto_alerta' => "El registro se guardó correctamente.");
            } else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de orden de venta", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata($alerta);
            //$this->session->set_flashdata('id_orden_venta', $orv_id);
            if ($redireccion == 0) {
                redirect('facturacion/facturar/editar_orden_venta/'.$id);
            } else if ($redireccion == 1) {
                redirect('facturacion/facturar/orden_venta/');
            }
            exit();die();
        }
        $datos["titulo_personal"] = "Editar orden de venta";
        $orv_id = $id;
        $orden_venta_datos = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id' => $orv_id));
        /* =============    CARGA DE DATOS      ===========*/
        $datos['datos_orden'] = $orden_venta_datos[0];
        $datos['orv_id'] = $orv_id;
        $tipos_pago = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1));
        $option_tpg = '<option value=""></option>';
        foreach ($tipos_pago as $k2) {
            $selected_ = ($k2['tpg_id'] == $orden_venta_datos[0]['orv_condicion_pago']) ? 'selected' : '';
            $option_tpg .= '<option value="' . $k2['tpg_id'] . '" data-aplcred="' . intval($k2['tpg_aplica_credito']) . '" ' . $selected_ .'  >' . $k2['tpg_nombre'] . '</option>';
        }
        $datos['tipos_pago'] = $option_tpg;
        //  regresa datos de parametro
        $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
        $datos['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;
        //  regresa el cliente
        $datos["cliente"] = $orden_venta_datos[0]['orv_id_cli'];
        $datos["cliente_name"] = $this->get_nombre_cliente($orden_venta_datos[0]['orv_id_cli']);
        //  regresa las areas
        $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto'=> 1, 'arf_estado'=> 1));
        $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_defecto, '', 'arf_id', true);
        $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
        //por si esta el valor de la orden de venta, si no se carga el area por defecto
        $valor = $orden_venta_datos[0]['orv_id_arf'] != "" ? $orden_venta_datos[0]['orv_id_arf'] : $arf_defecto;
        $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'),  $valor, '', 'arf_id', true);
        $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
        //  regresa los empleados
        $personalxorden_array = $this->gsatelite->get_tabla('pxo_personalxorden_venta', array('pxo_id_orv' => $orv_id));
        //tabla de la relacion entre el empleado y la orden de venta
        $pxo_id_emp = array(); //guardaremos los ids de los empleado
        foreach ($personalxorden_array as $key) {
            $pxo_id_emp[] = $key['pxo_id_emp'];
        }
        $empleados_drop = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $pxo_id_emp, '', 'emp_id', true);
        $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_drop);
        //  fin regresa los empleados
        $vendedores_select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $orden_venta_datos[0]['orv_id_ven'], '', 'ven_id', true);
        $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores_select);
        //  regresa las categorias de los productos
        $datos["categorias"] = $this->obtener_categoriaxbodega2();
        $select = "";
        $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
        foreach ($tip_venta_reg as $key) {
            $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '">' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
        }
        $datos["tipo_venta"] = $select;
        //$data["detalle_orden"] = $this->gsatelite->get_tabla('dov_detalle_orden_venta', array('dov_id_orv' => $orv_id));
        $data_grid['detalle_orden'] = $this->facturacion_model->get_detalle_orden_venta(array('dov_id_orv' =>$orv_id));
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data_grid['decimales'] = ($decimales != '')?$decimales:2;
        $datos['decimales'] = ($decimales != '')?$decimales:2;
        $data_grid['cliente'] = $orden_venta_datos[0]['orv_id_cli'];
        $datos["limite_credito"] = $this->gsatelite->get_campo('cli_cliente', 'cli_monto_credito', array('cli_id' => $orden_venta_datos[0]['orv_id_cli']));
        $datos["html"] = $this->load->view('facturacion/facturar/grid_orden_venta', $data_grid, true);
        $datos["cliente_defecto"] = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');
        $tiene_lista = 0;
        foreach ($data_grid['detalle_orden'] as $key) {
            $id_tlp = $key['lip_id_tlp'];
            $tiene_lista += (trim($id_tlp) != '')?1:0;
        }
        $datos['tiene_lista'] = $tiene_lista;
        $user=$this->tank_auth->get_user_id();
        $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu'=>$user));
        $select = "";
        foreach ($bodegas_reg as $key) {
            $selected = ($key['uxb_defecto'] == 1)?'selected':'';
            $select .= '<option value="'.$key['bod_id'].'" '.$selected.'>'.$key['bod_nombre'].'</option>';
        }
        $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
        $tpg_credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CREDITO'));
        $datos["datos_tpgcli"] = $this->facturacion_model->get_info_tpg_cli($orden_venta_datos[0]['orv_id_cli']);
        $datos["tpg_contado"] = ($tpg_contado) ? $tpg_contado : 0;
        $datos["tpg_credito"] = ($tpg_credito) ? $tpg_credito : 0;
        $datos["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
        $datos["bodega_prefe"] = $select;
        $this->_cargarvista($datos, null);
    }

    /**
     * @autor Habby Lovo
     * @since 09/02/2018
     *
     * @description : Nos obtiene la grid de componentes con los detalles.
    */
    public function obtener_componente_edit($producto, $correlativo, $dov_id, $cliente, $bodega = null, $tipo = 1, $productos_valid_array = array()){
        //$this->load->library('../controllers/facturacion/facturar');
        //$correlativo = ($this->input->post('correlativo') != '')?$this->input->post('correlativo'):null;
        //$producto = ($this->input->post('producto') != '')?$this->input->post('producto'):null;
        // lista de precio
        $id_tipl = 0;
        $data_grid['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $tipos_lista2 = $this->inventario_model->get_tipo_lista_precio(array('tpn_id_cli' => $cliente));
        $select_tipo_lista_cliente = "<option value=''></option>";
        foreach ($tipos_lista2 as $key => $value) {
            if($key == 0){
                $select_tipo_lista_cliente .= "<option data-des_min=". $value["lip_descuento_min"] ." data-des_max=". $value["lip_descuento_max"] ." data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . " selected>" . $value["tlp_nombre"] . "</option>";
                $id_tipl = $value["tlp_id"];
            }else{
                $select_tipo_lista_cliente .= "<option data-des_min=". $value["lip_descuento_min"] ." data-des_max=". $value["lip_descuento_max"] ." data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . ">" . $value["tlp_nombre"] . "</option>";
            }
        }
        //carga la grid de componentes
        $html = '';
        //if($correlativo != null && $correlativo >= 0){
        if($correlativo > -1){
            $data_grid['bodega_nombre'] = '';
            $data_grid['bodega_id'] = '';
            if($bodega != null){
                $bodega_reg = $this->gsatelite->get_tabla('bod_bodega', array('bod_id'=>$bodega));
                $data_grid['bodega_nombre'] = $bodega_reg[0]['bod_nombre'];
                $data_grid['bodega_id'] = $bodega;
            }
            $data_grid['detalles_validar'] = $productos_valid_array;

            $data_grid['ident'] = "_".$producto."_".$correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['lista_id'] = $id_tipl;
            $data_grid['lista_cliente'] = $select_tipo_lista_cliente;
            $data_grid['productos'] = $this->gsatelite->get_tabla('art_articulo', array('art_componente'=>1, 'art_estado'=>1));
            if($tipo == 1){
                $data_grid['componentes'] = $this->facturacion_model->get_componente_orden_venta(array('cdv_id_dov'=>$dov_id));
            } else if($tipo == 2) {
                $data_grid['componentes'] = $this->facturacion_model->get_componente_factura(array('cdf_id_def'=>$dov_id));
            } else {
                $this->load->model('cotizaciones_model');
                $data_grid['componentes'] = $this->cotizaciones_model->get_componente_cotizacion(array('cdc_id_axc'=>$dov_id));
            }
            $html = $this->load->view('facturacion/facturar/grid_componentes', $data_grid, true);
        }
        $json_validar = explode('%%%%%%%', $html);
        $arreglo_valid = json_decode(str_replace(array(' ','</div>'), '', $json_validar[1]), true);
        $html = str_replace('<div style="display: none;" id="json">', '', $json_validar[0]);
        return array('html'=>$html,'componente_validar'=>(array)$arreglo_valid);
    }

    public function get_productos_like() {
        satelite_validar(true);
        $categoria = ($this->input->post('categoria') != '') ? $this->input->post('categoria') : null;
        $producto  = (trim($this->input->post('producto')) != '') ? trim($this->input->post('producto')) : null;
        $anticipo  = $this->input->post('anticipo');

        $where = null;
        $where['art_estado'] = 1; //filtrar solo los productos activos.
        $like = null;
        if ($categoria != null) {
            $where['art_id_tia'] = $categoria;
        }

        if ($producto != '') {
            $where['(art_tipo >= 0 AND art_venta = 1)'] = null;
            $like = "(art_nombre LIKE '%".$producto."%' OR art_codigo LIKE '%".$producto."%' OR art_sinonimo LIKE '%".$producto."%' OR cdp_codigo LIKE '%".$producto."%' OR mrp_nombre LIKE '%".$producto."%')";
        }
        
        if ($anticipo < 2) {
            if ($anticipo == 1 ) {
                $where['art_anticipo'] = 1;
            }else{
                $where['(art_anticipo <> 1 OR art_anticipo is null)'] = null;
            }
        }

        $arreglo = array();
        $select_query = " HIGH_PRIORITY art_id producto, art_nombre prod_nombre, IFNULL(art_codigo,'') codigo, art_sinonimo sinonimo, cdp_codigo, art_tipo, IFNULL(mrp_nombre,'') mrp_nombre";
        $productos = $this->facturacion_model->get_productos_like($where, $like, $select_query);
        // echo $this->db->last_query(); die();
        if (count($productos) > 0) {
            $arreglo = $productos;
            /* // se comenta dado que la query ya predefine la estructura que se necesita retornar
            foreach ($productos as $key => $value) {
                $arreglo[$key]['producto'] = $value['art_id'];
                $arreglo[$key]['prod_nombre'] = $value['art_nombre'];
                $arreglo[$key]['codigo'] = $value['art_codigo'];
            } */
        }
        echo json_encode($arreglo);
    }

     /**
     * @author Edith Herrera
     * @since 2018-01-20
     * @return
     */
    public function get_info_producto()
    {
        satelite_validar(true);

        $cliente = $this->input->post('cliente');
        $articulo = $this->input->post('producto');
        $cli_alm = $this->gsatelite->get_tabla('alm_alumno', array('alm_id_cli'=>$cliente));
        $mod_alm = $this->gsatelite->get_tabla('mod_modulo', array('mod_id_art'=>$articulo));
        $grd_alm = $this->gsatelite->get_tabla('grd_grado', array('grd_id_art'=>$articulo));

        $mensaje = "";
        $mensaje2 = "";

        if((count($grd_alm)>0 || count($mod_alm)>0) && count($cli_alm)<=0){
            $mensaje = "El cliente seleccionado no está registrado como alumno.";
        }else{
             $lxp_id = 0;
             $grado = 0;
            if(count($mod_alm)>0){
                $preins = $this->facturacion_model->get_preinscripcion_almMod(array('mod_id_art'=>$articulo, 'alm_id_cli'=>$cliente, 'lxp_tipo_inscripcion'=>1));

                if(count($preins)<=0){
                    if(count($mod_alm)>0){
                        $mensaje2 = "No se encontró pre-inscripción para este alumno y nivel.";
                    }
                    $lxp_id = 0;
                }else{
                    $lxp_id = $preins['lxp_id'];
                }
            }else if(count($grd_alm)>0){
                $registro = $this->gsatelite->get_registro('gra_grupo_academico', array('gra_id_grd'=>$grd_alm[0]['grd_id']));
                $reg_gra = $registro[0];

                $area = $reg_gra->gra_id_ard;
                // Verifica si hay grupos para cada materia del pensum asociado al área.
                $no_grupos = $this->facturacion_model->get_grupos_grado(array('pen_id_ard'=>$area, 'gra_id IS NULL'=>null));

                if(count($no_grupos)>0){
                    $mensaje2 = "Hay niveles sin grupos para este pensum.";
                    $grado = $grd_alm[0]['grd_id'];
                }else{
                    $grado = $grd_alm[0]['grd_id'];
                }

            }

        }

        echo json_encode(array('mensaje'=>$mensaje, 'mensaje2'=>$mensaje2, 'preins'=>$lxp_id, 'grado'=>$grado));
    }

    /**
    * @author Habby Lovo
    * @since 2018-01-22
    * @return
    */
    public function obtener_componente(){
        satelite_validar(true);
        $correlativo = ($this->input->post('correlativo') != '')?$this->input->post('correlativo'):null;
        $producto = ($this->input->post('producto') != '')?$this->input->post('producto'):null;
        $html = '';
        $error = 0;
        if($correlativo != null){
            $data_grid['bodega_id'] = '';
            $data_grid['bodega_nombre'] = '';
            $data_grid['ident'] = "_".$producto."_".$correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['productos'] = $this->gsatelite->get_tabla('art_articulo', array('art_componente'=>1, 'art_estado'=>1));
            $html = $this->load->view('facturacion/facturar/grid_componentes', $data_grid, true);
        }else{
            $error = 1;
        }

        echo json_encode(array('html'=>$html, 'error'=>$error));
    }

    public function get_agrupacombos($producto = null, $id_correlativo = null){
        $correlativo = ($id_correlativo != null) ? $id_correlativo : $this->input->post('correlativo');
        $producto_id = ($producto != null) ? $producto : $this->input->post('producto');
        if (is_null($correlativo) || is_null($producto_id)) {
            $html = '';
            $error = 1;
        } else {
            $error = 0;
            $data_grid['ident'] = "_".$producto_id."_".$correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto_id;
            $data_grid['producto_agr'] = $this->inventario_model->get_productos_combo(array('cma_id_art' => $producto_id));
            $html = $this->load->view('facturacion/facturar/grid_agrupacombo', $data_grid, true);
        }
        if ($producto != null && $id_correlativo != null) {
            return array('html'=>$html, 'error'=>$error);
        } else {
            echo json_encode(array('html'=>$html, 'error'=>$error));
        }
    }


    public function obtener_lista_producto($art_id, $id_tipl){
        //Listado de precios
        $precios = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_tlp' => $id_tipl, 'lip_id_art' => $art_id, 'lip_estado' => 1));

        $opciones = "<option></option>";
        $opciones_busqueda = "<option value=''></option>";
        if (count($precios) > 0) {
            foreach ($precios as $lip) {
                $opciones .= "<option data-inicio='" . $lip['lip_desde'] . "' data-fin='" . $lip['lip_hasta'] . "' value='" . $lip['lip_id'] . "'>" . $lip['lip_precio'] . "</option>";
                $opciones_busqueda .= "<option data-inicio='" . $lip['lip_desde'] . "' data-fin='" . $lip['lip_hasta'] . "' value='" . $lip['lip_id_mep'] . "'>" . $lip['lip_precio'] . "</option>";
            }
        }
        return $opciones_busqueda;
    }

    public function get_componente_select(){
        //array('art_componente'=>1)
        $componente_reg = $this->facturacion_model->get_articulos_mep(array('art_componente'=>1));

        $componente_producto_array = array();
        $componente_temp_array = array();
        $select_producto = '';
        $select_medida = '';
        foreach ($componente_reg as $comp) {
            $select_producto .= '<option value="'.$comp['art_id'].'" data-tipo="'.$comp['art_tipo'].'" data-codigo="'.$comp['art_codigo'].'" data-desc="'.$comp['art_sinonimo'].'">'.$comp['art_codigo'].' - '.$comp['art_nombre'].'</option>';

            $busqueda_array = array('*', '$', '/', '+', '!', '?', '(');
            $remplace_array = array('<option data-mep="', '" data-val="', '" value="', '" selected>', '">', '</option>', '" data-def="'.$comp['medida_defecto'].'');
            $select_medida = '';
            $medidas_temp = $comp['medidas'];
            $medida_array = explode(',', $medidas_temp);

            foreach ($medida_array as $mep) {
                $select_mep_temp = str_replace($busqueda_array, $remplace_array, $mep);
                $select_medida .= $select_mep_temp;
            }
            $componente_temp_array[$comp['art_id']] = $select_medida;
        }
        $componente_producto_array['producto_select'] = $select_producto;
        $componente_producto_array['medida_select'] = $componente_temp_array;
        echo json_encode(array('producto_select'=>$select_producto, 'medida_select'=>$componente_temp_array));

        //print_r($componente_producto_array);exit();die();
    }

    /**
    * @author ELman Ortiz
    * @fecha: 07/02/2018
    * @descripcion: Genera la partida contable automatica cuando se crea una factura independientemente si el producto tiene
    * @la configuracion de afecta o no inventario
    * @param integer fac_id, string num_fac
    * @return array {pct_id, total debe}
    * @Modified by Mario Marquez
    * @fecha: 23/02/2018
    */
    function generar_partida_factura_afecta_noafecta_inv_debe($where, $info){
        $total_debe = 0.0000;


        //Se obtiene la data de la Factura @author Mario Marquez
        $data_factura = $this->gsatelite->get_tabla('fac_factura',array('fac_id' => $where['fac_id']));

        $fac_fecha_conta = $info['fac_fecha_conta'];
        //Tipo de cuenta por defecto
        //Se valida segun el tipo de Pago de la factura el tipo de cuenta que buscara @author Mario Marquez
        $idtipo_cnt = 0;
        if($data_factura[0]['fac_id_tpg'] == '1'){
            $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
        }
        else if($data_factura[0]['fac_id_tpg'] == '2'){
            $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
        }

        // si es factura excenta buscar otro tipo de cuenta pero que no este anulada
        if ($data_factura[0]['fac_impuesto'] <= 0 ) {
           //dado que si es anulación de factura el valor del impuesto sera cero validamos contra los detalles.

           $def_f = $this->gsatelite->get_tabla('def_detalle_fact',array('def_id_fac'=>$data_factura[0]['fac_id'],'def_impuesto > 0'=>null));
           if (count($def_f) <= 0 ) //sino se encontro aplicación de impuestos es factura excenta
           {
               $idtipo_cnt_ant = $idtipo_cnt;
               $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO_EXENTA'));
               $idtipo_cnt = ($idtipo_cnt > 0 )? $idtipo_cnt:$idtipo_cnt_ant;
           }
        }

        $where['idtipo_cnt'] = $idtipo_cnt;//Se agrega el id del tipo cuenta que deben ser las cuentas para los productos
        $cnt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac($where);
        //Obtener los productos
        foreach ($cnt_prods as $key => $cnt_prod) {
            $total_debe = $total_debe + $cnt_prod['subtotal_prod'];
        }
        //Obtener los impuestos
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('IMPUESTOS'));
        $where['idtipo_cnt'] = $idtipo_cnt;
        $cnt_imps = $this->facturacion_model->get_cnt_x_impu_x_fac($where);

        foreach ($cnt_imps as $key => $cnt_imp) {
            $total_debe = $total_debe + $cnt_imp['subtotximpcuenta'];
        }
        //Obtener las retenciones
        $cnt_rets = $this->facturacion_model->get_cnt_x_reten_x_fac($where);
        foreach ($cnt_rets as $key => $cnt_ret) {
            $total_debe = $total_debe + $cnt_ret['subtotxretcuenta'];
        }


        //Correlativo de la partida contable
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
        //Determinar el origen de la partida si es Documento Proveedor - Sin afectar inventario
        $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 2));
        $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;
        //Cuenta por defecto
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
        //Tipo de partida
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('INGRESO'));
        $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
        if (count($consultar)>0) {
            $id_tipo_partida = $tipo_partida;
        }

        //Concepto por factura sin afectar inventario
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 2));
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        }else{
          $pct_concepto = 'Concepto no definido';
        }

        $array_partida = array(
            'pct_id_tpd' => $id_tipo_partida,
            //'pct_id_prc' => $this->input->post('id_prc'),
            'pct_id_orp' => $orp_partida,//YA
            'pct_concepto' => $pct_concepto . $info['num_fac'],//YA
            'pct_total' => number_format($total_debe, 4, '.', ''),//YA
            'pct_fecha' => $fac_fecha_conta, //La partida contable se genera con la fecha de contabilizacion de la factura
            'pct_correlativo' => $correlativo_partida,//YA
            //'pct_codigo' => $codigo,
            //'pct_modulo' => $modulo,
            'pct_estado' => 1,
            'pct_fecha_crea' => date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea' => $this->tank_auth->get_user_id(),
            'pct_usu_mod' => $this->tank_auth->get_user_id()
        );

        $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
        //Ingresar los detalles de la partida para los productos
        $array_detalle = array();
        foreach ($cnt_prods as $j => $deta) {
            $dpc_id_cnt = ($deta['cnt_id'] > 0) ? $deta['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_detalle[] = array(
                'dpc_id_cnt' => $dpc_id_cnt,//YA
                'dpc_id_pct' => $id_pct,//YA
                'dpc_concepto' => 'Venta de producto',//YA
                'dpc_debe' => 0.00,
                'dpc_haber' => $deta['subtotal_prod'],//debe
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

            //$detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

        //Ingresar los detalles de la partida para los impuesto
        foreach ($cnt_imps as $j => $deta) {
            $dpc_id_cnt = ($deta['cxe_id_cnt'] > 0) ? $deta['cxe_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_detalle[] = array(
                'dpc_id_cnt' => $dpc_id_cnt,//YA
                'dpc_id_pct' => $id_pct,//YA
                'dpc_concepto' => 'Impuestos por venta',
                'dpc_debe' => 0.00,
                'dpc_haber' => $deta['subtotximpcuenta'],//debe
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );

            //$detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

        //Ingresar los detalles de la partida para las retenciones
        foreach ($cnt_rets as $n => $det) {
            $dpc_id_cnt = ($det['dcr_id_cnt'] > 0) ? $det['dcr_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_detalle[] = array(
                'dpc_id_cnt' => $dpc_id_cnt,//YA
                'dpc_id_pct' => $id_pct,//YA
                'dpc_concepto' => 'Retencion por venta',
                'dpc_debe' => 0.00,
                'dpc_haber' => $det['subtotxretcuenta'],//debe
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            //$detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

        return array('id_pct' => $id_pct, 'total_haber' => $total_debe, 'array_detalle_partida' => $array_detalle);
    }

    /**
     *@return Elman Ortiz
     *@fecha 08/02/2018
     *@descripcion: Haber para factura NO afecta inventario por ventas
     */
    function generar_partida_factura_afecta_noafecta_inv_haber($where, $id_pct, $monto_haber){
        //$tipo_cuenta = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, false, array('CUENTA_POR_PAGAR'));
        //$where = array('prv_id' => $prv_id, 'tcn_id' => $tipo_cuenta);
        //Obtener la cuenta
        //$where['tpg_id'] = $tpg_id;
        //$where['tpg_id'] = $tpg_id;
        //$where['cxg_estado'] = 1;
        $id_cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
        $id_cnt = $this->facturacion_model->get_cuenta_contable_tipopago($where);
        $n_cnt = count($id_cnt);
        if ($n_cnt > 0) {
            $i=0;
            $acumulado_debe = 0;
            foreach ($id_cnt as $key => $cuenta) {
                $i++;
                $id_cuenta = ($cuenta['cnt_id'] > 0)? $cuenta['cnt_id']:$id_cuenta_defecto;
                $acumulado_debe +=$cuenta['total'];
                //preguntar si ha llegado al ultimo registro para comparar contra el total del haber y cuadrar
                if ($i==$n_cnt && $monto_haber > 0)
                {
                    $diferencia = $monto_haber - $acumulado_debe;
                    $cuenta['total'] = (abs($diferencia) > 0 )? ($cuenta['total'] + $diferencia):$cuenta['total'];
                }
                $array_detalle = array(
                    'dpc_id_cnt' => $id_cuenta,//YA
                    'dpc_id_pct' => $id_pct,//Ya
                    'dpc_concepto' => 'Ingreso por venta',//Entrada a caja
                    'dpc_debe' => $cuenta['total'],
                    'dpc_haber' => 0.00,//haber
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }//Fin foreach para ingresar registros
        }
        elseif($monto_haber > 0) //sino hay retorno de datos agregar la cuenta por defecto
        {
            $array_detalle = array(
                'dpc_id_cnt' => $id_cuenta_defecto,//YA
                'dpc_id_pct' => $id_pct,//Ya
                'dpc_concepto' => 'Ingreso por venta',//Entrada a caja
                'dpc_debe' => $monto_haber,
                'dpc_haber' => 0.00,//haber
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

    }//Fin haber partida contable cuando NO afecta inventario por medio de documento por proveedor

    /*****************************************************************************************/
    /**
    * @author ELman Ortiz
    * @fecha: 09/02/2018
    * @descripcion: Genera la partida contable automatica cuando se crea una factura independientemente si el producto tiene
    * @la configuracion de afecta o no inventario
    * @param integer fac_id, string num_fac
    * @return array {pct_id, total debe}
    */
    function generar_contra_partida_factura_afecta_afecta_inv_debe($where, $info){
        $total_debe = 0.0000;
        //Tipo de cuenta por defecto
        $idtipo_cnt      = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('EXISTENCIA'));
        $where['tcn_id'] = $idtipo_cnt;//Se agrega el id del tipo cuenta que deben ser las cuentas para los productos
        $cnt_prods       = $this->facturacion_model->get_cnt_x_prod_x_fac_afec_inv($where);

        //Obtener los productos
        foreach ($cnt_prods as $key => $cnt_prod) {
            $total_debe = $total_debe + $cnt_prod['subtotal_prod'];
        }

        //Correlativo de la partida contable
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;

        //Determinar el origen de la partida si es Facturacion - cuando afecta inventario
        $origen      = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 2));
        $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;

        //Cuenta por defecto
        $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');

        //Tipo de partida
        $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('COSTO'));
        $consultar    = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));

        if (count($consultar)>0) {
            $id_tipo_partida = $tipo_partida;
            // Generador de Codigo para la partida contable
            $numero         = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
            $codigo         = $consultar[0]['tpd_prefijo'].'-'.$numero;   // Codigo que tendra la partida
        }

        //Concepto por factura afecta inventario
        $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 1));
        if(count($pct_concepto) > 0){
          $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
        }else{
          $pct_concepto = 'Concepto no definido';
        }

        $array_partida = array(
            'pct_id_tpd'    => $id_tipo_partida,
            //'pct_id_prc'  => $this->input->post('id_prc'),
            'pct_id_orp'    => $orp_partida,            //YA
            'pct_concepto'  => $pct_concepto .'-'. $info['num_fac'],//YA
            'pct_total'     => number_format($total_debe, 4, '.', ''),//YA
            'pct_fecha'     => date('Y-m-d H:i:s'),     //YA
            'pct_correlativo' => $correlativo_partida,  //YA
            'pct_codigo'    => (isset($codigo))?$codigo:null,
            //'pct_modulo'  => $modulo,
            'pct_estado'    => 1,
            'pct_fecha_crea'=> date('Y-m-d H:i:s'),
            'pct_fecha_mod' => date('Y-m-d H:i:s'),
            'pct_usu_crea'  => $this->tank_auth->get_user_id(),
            'pct_usu_mod'   => $this->tank_auth->get_user_id()
        );

        $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

        //Ingresar los detalles de la partida para los productos
        foreach ($cnt_prods as $j => $deta) {
            $dpc_id_cnt    = ($deta['cnt_id'] > 0) ? $deta['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_detalle = array(
                'dpc_id_cnt'    => $dpc_id_cnt,     //YA
                'dpc_id_pct'    => $id_pct,         //YA
                'dpc_concepto'  => 'Costo de venta',//YA
                'dpc_debe'      => $deta['subtotal_prod'],//debe
                'dpc_haber'     => 0.00,
                'dpc_estado'    => 1,
                'dpc_fecha_crea'=> date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                'dpc_usu_mod'   => $this->tank_auth->get_user_id()
            );

            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

        return array('id_pct' => $id_pct, 'total_haber' => $total_debe);
    }

    /**
     *@return Elman Ortiz
     *@fecha 10/02/2018
     *@descripcion: Haber para factura cuando afecta inventario por ventas
     */
    function generar_contra_partida_factura_afecta_inv_haber($where, $id_pct){
        $total_debe = 0.0000;

        //Tipo de cuenta por defecto
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('COSTO'));

        $where['tcn_id'] = $idtipo_cnt;//Se agrega el id del tipo cuenta que deben ser las cuentas para los productos

        $cnt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac_afec_inv($where);

        //Obtener los productos
        foreach ($cnt_prods as $key => $cnt_prod) {
            $total_debe = $total_debe + $cnt_prod['subtotal_prod'];
        }

        //Ingresar los detalles de la partida para los productos
        foreach ($cnt_prods as $j => $deta) {
            $dpc_id_cnt     = ($deta['cnt_id'] > 0) ? $deta['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
            $array_detalle  = array(
                'dpc_id_cnt'    => $dpc_id_cnt,         //YA
                'dpc_id_pct'    => $id_pct,             //YA
                'dpc_concepto'  => 'Existencias',    //YA
                'dpc_debe'      => 0.00,
                'dpc_haber'     => $deta['subtotal_prod'],//debe
                'dpc_estado'    => 1,
                'dpc_fecha_crea'=> date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea'  => $this->tank_auth->get_user_id(),
                'dpc_usu_mod'   => $this->tank_auth->get_user_id()
            );

            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

        return array('id_pct' => $id_pct, 'total_haber' => $total_debe);
    }//Fin haber partida contable cuando afecta inventario por medio de facturacion

     /**
     * @author Edith Herrera
     * @since  2018-01-20
     * @return
     */
    public function validar_siguiente_nivel()
    {
        satelite_validar(true); /**//**//**//**//**//**//**//**//**//**/

        $cliente = $this->input->post('cliente');
        $articulo = $this->input->post('producto');

        $mod_alm = $this->gsatelite->get_tabla('mod_modulo', array('mod_id_art'=>$articulo));
        $cli_alm = $this->gsatelite->get_tabla('alm_alumno', array('alm_id_cli'=>$cliente));

        $grd_id = $this->gsatelite->get_tabla('grd_grado', array('grd_id_art'=>$articulo));

        //////////////// Si el producto se asocia un grado se verifica la fecha máxima de inscripción ////////////////////////
        $grd_alm = array();
        if(count($grd_id)>0){
            $fecha_actual= date('Y-m-d');
                    $this->db->where('date_format(pyc_fecha_maxima_inscripcion, "%Y-%m-%d") >= date_format("'.$fecha_actual.'", "%Y-%m-%d")', null, FALSE);
                    $this->db->join('gra_grupo_academico', 'gra_id_grd = grd_id');
                    $this->db->join('pyc_proyeccion', 'gra_id_pyc = pyc_id');
            $grd_alm = $this->gsatelite->get_tabla('grd_grado', array('grd_id_art'=>$articulo));
        }


        $resp = 0;
        $mensaje="El alumno no puede ser inscrito en este nivel";

        $this->load->library('../controllers/registro_academico/procesos');

        if(count($mod_alm)>0 && count($cli_alm)>0){ // Verifica que exista un nivel y alumno
            $area_reg = $this->db->select('gra_id_ard')->from('gra_grupo_academico')->join('pen_pensum', 'gra_id_pen=pen_id')->where('pen_id_mod', $mod_alm[0]['mod_id'])->get()->result_array();

            if(count($area_reg)>0){
                $habilitados = $this->procesos->cargar_pensum_inscripcion($area_reg[0]['gra_id_ard'], $cli_alm[0]['alm_id'], 1, null, 1);

                $inscripcion = $this->db->select()->from('lxa_alumnoxarea')->join('lxp_alumnoxpensum', 'lxa_id=lxp_id_lxa')->where('lxa_id_ard', $area_reg[0]['gra_id_ard'])->get()->result_array();

                $hab_array = array();
                if(count($habilitados)>0){
                    foreach ($habilitados as $hab) {
                        $hab_array[] = $hab->pen_id_mod;
                    }

                    if(in_array($mod_alm[0]['mod_id'], $hab_array)){
                        $resp=1;
                        $mensaje="";
                    }
                }else{
                    if(count($inscripcion)<=0){
                        $resp=1;
                        $mensaje="";
                    }
                }
            }
        }else if(count($grd_id)>0 && count($grd_alm)<=0){
            $mensaje="No se puede realizar la inscripción debido a la fecha máxima.";
            $resp=0;
        }else{
            $mensaje="";
            $resp=1;
        }

        echo json_encode(array('resp'=>$resp, 'mensaje'=>$mensaje));
    }

    /**
    * @author Habby Lovo
    * @since 2018-02-23
    * @return
    */
    public function obtener_costos(){
        //print_r($this->tank_auth->get_all_empresa()); die();
        satelite_validar(true);
        //print_r($_POST); die();
        $correlativo = ($this->input->post('correlativo') != '')?$this->input->post('correlativo'):null;
        $producto = ($this->input->post('producto') != '')?$this->input->post('producto'):null;
        $costo = ($this->input->post('costo') != '')?$this->input->post('costo'):null;
        $subtotal = ($this->input->post('subtotal') != '')?$this->input->post('subtotal'):null;
        $tipo_pago_factura = ($this->input->post('tipo_pago') != '')?$this->input->post('tipo_pago'):null;
        $tipo = ($this->input->post('tipo') != '')?$this->input->post('tipo'):0;
        $idcliente = $this->input->post('idcli');



        //CONFIGURACION DE PAIS
        $paiscli = $this->gsatelite->get_campo('cli_cliente', 'cli_id_pai', array('cli_id' => $idcliente)); //pais del cliente
        $id_pais_defecto = $this->tank_auth->get_all_empresa()->emr_id_pai; //pais ligada a la empresa
        if(!($id_pais_defecto > 0)){
            $id_pais_defecto = 7;
        }

        if($paiscli != ''){
            $paiscli = $paiscli;
        } else if($id_pais_defecto != ''){
            $paiscli = $id_pais_defecto;
        } else{
            $select_pai = $this->gsatelite->get_campo('pai_pais', 'pai_id', array('pai_defecto'=>1));
            $paiscli = $select_pai;
        }
        // FIN DE CONFIGURACION DE PAISES
        $impuesto_det = (trim($this->input->post('impuesto_det')) != '')? $this->input->post('impuesto_det'):null;
        //$id_pais_defecto = $this->gsatelite->get_parametro('SYS_ID_PAIS');

        // print_r($this->input->post());
        //print_r($paiscli); die();
        $html = '';
        $error = 0;
        if($correlativo != null){
            $data_grid['ident'] = "_".$producto."_".$correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['subtotal'] = $subtotal;
            $data_grid['tipo'] = $tipo;
            $data_grid['costo'] = $costo; // datos de costos
            $data_grid['editar'] = 0;
            $producto_det = $this->gsatelite->get_tabla('art_articulo', array('art_id'=>$producto));
            $categoria = $producto_det[0]['art_id_tia'];

            //Obtener los centros centros de costos del tipo de ingreso segun el tipo de pago de la factura en el caso de ser enviado
             $tcn_id = 0;
            //if($tipo_pago_factura!= null && $tipo_pago_factura == '1'){
                //$tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('CAJA'));
            //}
            //else{
                $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
            //}

            if ($impuesto_det == '' || $impuesto_det <= 0) { // si es factura exenta buscar otro tipo de cuenta
               $tcn_id_anterior = $tcn_id;
               $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO_EXENTA'));
               $tcn_id = ($tcn_id > 0 )? $tcn_id:$tcn_id_anterior;
            }

            //IFNULL(dta_id_pai, $id_pais_defecto) = IF(ISNULL(dta_id_pai),$id_pais_defecto,$paiscli)
            $where_conf = array('dta_id_tia'=>$categoria,
                                'tcn_id'=>$tcn_id,
                                'IFNULL(dta_id_pai, '.$id_pais_defecto.') = '.$paiscli => null
                                );
            if($costo>0) $where_conf['dta_id_cec'] = $costo; //agregar el centro de costo al where
            // print_r($where_conf);
            $data_grid['costo_reg'] = $this->facturacion_model->get_centro_costo($where_conf,$id_pais_defecto);
            //echo $this->db->last_query();
            //die();
            // echo "<br>";

            // CONFIGURAR EL CENTRO DE COSTO POR DEFECTO Y CUENTA
            if(!count($data_grid['costo_reg']) > 0){
                $datos_empresa = $this->tank_auth->get_all_empresa();   //datos de la empresa
                $id_cuenta_defecto = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO', null);
                $empresa_id = $datos_empresa->emr_id;
                //CONFIGURACION DE PAISES
                $pais_defecto = '';
                $pais_usuario = $this->inventario_model->get_pais_usuario2(array('id' =>$this->tank_auth->get_user_id())); // pais de la persona logeada de la nacionalidad
                $id_pais_defecto = $datos_empresa->emr_id_pai; //pais ligada a la empresa
                if(count($pais_usuario) > 0){
                    if($pais_usuario[0]['emp_id_pai'] != ''){
                        $pais_defecto =  $pais_usuario[0]['emp_id_pai'];
                    } else{
                        $pais_defecto = $id_pais_defecto;
                    }
                } else if($id_pais_defecto != ''){
                    $pais_defecto = $id_pais_defecto;
                } else{
                    $select_pai = $this->gsatelite->get_campo('pai_pais', 'pai_id', array('pai_defecto'=>1));
                    $pais_defecto = $select_pai;
                }
                // FIN DE CONFIGURACION DE PAISES
                $where_centro_costo = array('pai_id'=>$pais_defecto, 'cec_id_emr'=>$empresa_id, 'cnt_id'=>$id_cuenta_defecto);
                $centro_costo_reg = $this->facturacion_model->get_centro_costo_defecto($where_centro_costo);
                $data_grid['costo_reg'] = $centro_costo_reg;
            }
            // FIN DE CONFIGURAR EL CENTRO DE COSTO POR DEFECTO Y CUENTA
            // print_r($data_grid['costo_reg']);
            // print_r($this->db->last_query());
            // die();

            $html = $this->load->view('facturacion/facturar/grid_centro_costo', $data_grid, true);
        } else{
            $error = 1;
        }

        echo json_encode(array('html'=>$html, 'error'=>$error));
    }

    /**
     * @autor Habby Lovo
     * @since 09/04/2018
     *
     * @description : Nos obtiene la grid de centro de costo con los detalles.
    */
    public function obtener_costo_edit($producto, $correlativo, $def_id, $cliente, $tipo, $subtotal){
        $data_grid['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        //carga la grid de componentes
        $html = '';
        //if($correlativo != null && $correlativo >= 0){
        if($correlativo > -1){
            $data_grid['ident'] = "_".$producto."_".$correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['editar'] = 1;
            $data_grid['duplicar'] = 1;

            $data_grid['subtotal'] = $subtotal;
            $data_grid['costo'] = null; // datos de costos

            $producto_det = $this->gsatelite->get_tabla('art_articulo', array('art_id'=>$producto));
            $categoria = $producto_det[0]['art_id_tia'];

            //Tipo de cuenta por defecto
            $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
            $data_grid['costo_reg'] = $this->facturacion_model->get_centro_costo(array('dta_id_tia'=>$categoria, 'tcn_id'=>$tcn_id));

            if($tipo == 2){
                $data_grid['costo_grid'] = $this->facturacion_model->get_centro_costo_detalle_fac(array('dcf_id_def'=>$def_id));
            } else{
                $data_grid['costo_grid'] = array();
            }
            $html = $this->load->view('facturacion/facturar/grid_centro_costo', $data_grid, true);
        }
        return array('html'=>$html);
    }

    /**
    * @author Edith Herrera - Grupo Satélite
    * @since 2018-04-03
    * Inscripción de alumno a un grado académico.
    * Este proceso esta siento utilizado en la función guardar_factura y en alumno_inscripcion de registro académico
    **/

    public function generar_inscripcion_grado($cliente = null, $grado, $fac_id = null, $def_id = null, $alm_id = null, $tipo_ins = null, $id_cfg = null, $id_tlp = null, $id_pyc = null, $id_ard = null){
        log_message('info', "parametros de generar_inscripcion_grado: cliente=$cliente, grado=$grado, fac_id=$fac_id, def_id=$def_id, alm_id=$alm_id, tipo_ins=$tipo_ins, id_cfg=$id_cfg, id_tlp=$id_tlp, id_pyc=$id_pyc, id_ard=$id_ard");
        
        if($cliente!=null){
            $alumno = $this->gsatelite->get_campo('alm_alumno', 'alm_id', array('alm_id_cli'=>$cliente));
            log_message('info', 'info alumno por cliente_id: ' . json_encode($alumno));
        }else{
            $alumno = $alm_id;
        }
        if($tipo_ins!=null){ $tipo = $tipo_ins; }else{ $tipo = 2; }

        log_message('info', "verificar tipo: $tipo");

        if($id_tlp == null) {
            $id_tlp = $this->gsatelite->get_parametro('SYS_ID_TIPO_LISTA_PRECIO_ALUMNOS'); 
            log_message('info', "id_tlp de parametro: $id_tlp");
        }

        //Fechas de acuerdo al proceso seleccionado (2=Inscripción o 1=pre-inscripción).
        if($tipo_ins==1){
            $fecha_pre = date('Y-m-d H:i:s');
            $fecha_ins = date('Y-m-d H:i:s');
        }else{
            $fecha_pre = null;
            $fecha_ins = date('Y-m-d H:i:s');
        }

        log_message('info', "Fechas que se generan: fecha_pre=$fecha_pre, fecha_ins=$fecha_ins");

        if($alumno>0 && $grado>0 ){
            //&& $fac_id>0 && $def_id>0
                //Grupos asociados al grado
            $this->db->where("(
                (gra_fecha_inicio <= pyc_fecha_fin AND gra_fecha_fin >= pyc_fecha_inicio) OR
                (gra_fecha_inicio IS NULL AND gra_fecha_fin >= pyc_fecha_inicio) OR
                (gra_fecha_fin IS NULL AND gra_fecha_inicio <= pyc_fecha_fin) OR
                (gra_fecha_inicio IS NULL AND gra_fecha_fin IS NULL) OR
                (pyc_fecha_inicio IS NULL AND pyc_fecha_fin IS NULL)
            )");

                $this->db->join('pyc_proyeccion', 'pyc_id = gra_id_pyc', 'LEFT');
            $grupos = $this->gsatelite->get_tabla('gra_grupo_academico', array('gra_id_grd'=>$grado, 'gra_id_ard'=>$id_ard, 'gra_id_pyc'=>$id_pyc, 'gra_estado'=>1));
            log_message('info', 'Grupos info: ' . json_encode($grupos));
            log_message('info', 'Count: ' . count($grupos));

            foreach ($grupos as $gra ){

                log_message('info', 'Grupo foreach: ' . json_encode($gra));

                    // Área asociada al alumno
                $lxa = $this->gsatelite->get_registro('lxa_alumnoxarea', array('lxa_id_ard'=>$gra['gra_id_ard'], 'lxa_id_alm'=>$alumno));
                log_message('info', 'lxa_alumnoxarea: ' . json_encode($lxa));

                $get_lxp = array();
                if(!empty($lxa)){ // Si tiene área asociada
                    $lxa_id = $lxa->lxa_id;
                    log_message('info', 'lxa_id: ' . $lxa_id);
                        // Inscripciones del alumno
                    $get_lxp = $this->gsatelite->get_registro('lxp_alumnoxpensum', array('lxp_id_lxa'=>$lxa_id, 'lxp_id_gra'=>$gra['gra_id'], 'lxp_estado'=>1));
                    log_message('info', 'lxp_alumnoxpensum: ' . json_encode($get_lxp));
                }else{ 
                    // Si no tiene área asociada
                    $array_lxa = array(
                        'lxa_id_alm'=>$alumno,
                        'lxa_id_ard'=>$gra['gra_id_ard'],
                        'lxa_fecha_incripcion'=>date('Y-m-d H:i:s'),
                        'lxa_estado'=>1,
                        'lxa_fecha_crea'=>date('Y-m-d H:i:s'),
                        'lxa_usu_crea'=>$this->tank_auth->get_user_id(),
                        'lxa_fecha_mod'=>date('Y-m-d H:i:s'),
                        'lxa_usu_mod'=>$this->tank_auth->get_user_id()
                    );
                    $lxa_id = $this->gsatelite->ingresar('lxa_alumnoxarea', $array_lxa);
                    log_message('info', 'Insert into lxa_alumnoxarea, lxa_id: ' . $lxa_id);
                }

                    // Si tiene área pero no inscripciones se crea la inscrripción
                if($lxa_id>0 && empty($get_lxp)){
                    $array_lxp = array(
                        'lxp_id_lxa'=>$lxa_id,
                        'lxp_id_gra'=>$gra['gra_id'],
                        'lxp_id_fac'=>($fac_id!='') ? $fac_id : null,
                        'lxp_id_def'=>($def_id!='') ? $def_id : null,
                        'lxp_condicion'=>1,
                        'lxp_fecha_inscripcion'=>$fecha_ins,
                        'lxp_fecha_preinscripcion'=>$fecha_pre,
                        'lxp_tipo_inscripcion'=>$tipo,
                        'lxp_exam_ubicacion'=>0,
                        'lxp_estado'=>1,
                        'lxp_fecha_crea'=>date('Y-m-d H:i:s'),
                        'lxp_usu_crea'=>$this->tank_auth->get_user_id(),
                        'lxp_fecha_mod'=>date('Y-m-d H:i:s'),
                        'lxp_usu_mod'=>$this->tank_auth->get_user_id()
                    );
                    log_message('info', 'lxp array: ' . json_encode($array_lxp));
                    $lxp = $this->gsatelite->ingresar('lxp_alumnoxpensum', $array_lxp);
                    log_message('info', 'Insert into lxp_alumnoxpensum, lxp: ' . $lxp);
                }else{
                    // Si tiene área e inscripciones se actualiza la inscrripción
                    $array_lxp = array(
                        'lxp_id_fac'=>($fac_id!='') ? $fac_id : null,
                        'lxp_id_def'=>($def_id!='') ? $def_id : null,
                        'lxp_condicion'=>1,
                        'lxp_fecha_inscripcion'=>$fecha_ins,
                        'lxp_fecha_preinscripcion'=>$fecha_pre,
                        'lxp_tipo_inscripcion'=>$tipo,
                        'lxp_exam_ubicacion'=>0,
                        'lxp_estado'=>1,
                        'lxp_fecha_mod'=>date('Y-m-d H:i:s'),
                        'lxp_usu_mod'=>$this->tank_auth->get_user_id()
                    );
                    log_message('info', 'Update lxp array: ' . json_encode($array_lxp));
                    $lxp = $this->gsatelite->actualizar_array('lxp_alumnoxpensum', $array_lxp, array('lxp_id'=>$get_lxp->lxp_id));
                    log_message('info', 'Update lxp_alumnoxpensum, lxp: ' . $lxp);
                }
            }

                    $this->db->where_in('gxa_estado_grado', '1,2');
            $gxa =  $this->gsatelite->get_tabla('gxa_gradoxalumno', array('gxa_id_grd'=>$grado,'gxa_id_alm'=>$alumno));
            log_message('info', 'gxa_gradoxalumno: ' . json_encode($gxa));

            if(!count($gxa)>0){
                    // Se agrega la relación de alumno y grado
                $array_gxa = array(
                    'gxa_id_grd'=>$grado,
                    'gxa_id_alm'=>$alumno,
                    'gxa_fecha'=>date('Y-m-d H:i:s'),
                    'gxa_estado_grado'=>2, // En curso
                    'gxa_estado'=>1,
                    'gxa_usu_creacion'=>$this->tank_auth->get_user_id(),
                    'gxa_fecha_creacion'=>date('Y-m-d H:i:s'),
                    'gxa_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'gxa_fecha_modificacion'=>date('Y-m-d H:i:s')
                );
                log_message('info', 'gxa array: ' . json_encode($array_gxa));
                $gxa_id = $this->gsatelite->ingresar('gxa_gradoxalumno', $array_gxa);
                log_message('info', 'Insert into gxa_gradoxalumno, gxa_id: ' . $gxa_id);
                //if($tipo==2){
                    //$grado;
                    $reg_grd = $this->gsatelite->get_registro('grd_grado', array('grd_id'=>$grado));
                    log_message('info', 'reg_grd: ' . json_encode($reg_grd));

                    if (!isset($id_cfg) || $id_cfg == '') {
                        $id_cfg = $reg_grd->grd_id_cfg;
                        log_message('info', 'id_cfg por reg_grd->grd_id_cfg: ' . $id_cfg);
                    }

                    $detalles = $this->gsatelite->get_tabla('dfc_detalle_configuracion_cargo', array('dfc_id_cfg'=>$id_cfg));

                    log_message('info', 'dfc_detalle_configuracion_cargo: ' . json_encode($detalles));
                        // Detalles de configuración de cargos                        
                    foreach ($detalles as $det) {
                        log_message('info', 'detalle: ' . json_encode($det));
                        $i=1;
                        $articulo = $this->gsatelite->get_registro('art_articulo', array('art_id'=>$det['dfc_id_art']));
                        log_message('info', 'articulo: ' . json_encode($articulo));

                            // Cargos generados según cantidad de cuotas
                        for ($i=1; $i <= $det['dfc_numero_cuota'] ; $i++) {

                            $where_array = array(
                                "lip_id_art" => $det['dfc_id_art'],
                                "lip_desde <=" => $i,
                                "lip_hasta >=" => $i,
                                "tlp_id" => $id_tlp
                            );

                                          $this->db->join("tlp_tipo_lista_precio", "tlp_id = lip_id_tlp" );
                            $reg_precio = $this->gsatelite->get_registro("lip_listado_precio", $where_array);
                            log_message('info', 'reg_precio: ' . json_encode($reg_precio));

                            // Validar el resultado de reg_precio
                            $clg_monto = 0;
                            if (!empty($reg_precio) && is_object($reg_precio) && isset($reg_precio->lip_precio)) {
                                $clg_monto = $reg_precio->lip_precio;
                            } elseif (is_array($reg_precio) && count($reg_precio) > 0) {
                                // En caso de que devuelva un arreglo (múltiples registros), tomar el primero
                                $clg_monto = isset($reg_precio[0]['lip_precio']) ? $reg_precio[0]['lip_precio'] : 0;
                            }

                                             $this->db->join('imp_impuesto', 'imp_id = ixr_id_imp');
                            $registros_ixr = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('ixr_id_tia'=>$articulo->art_id_tia, 'ixr_estado'=>1));
                            log_message('info', 'registros_ixr: ' . json_encode($registros_ixr));

                            $total_impuesto = 0;

                            if (count($registros_ixr) > 0 || !empty($registros_ixr)) {
                                foreach ($registros_ixr as $ixr) {
                                    if($ixr['imp_valor'] > 0) {
                                        $total_impuesto = $total_impuesto + $ixr['imp_valor'];
                                    } else {
                                        $porcentaje_impuesto = $clg_monto * ($ixr['imp_porcentaje']/100);
                                        $total_impuesto = $total_impuesto + $porcentaje_impuesto;
                                    }
                                }
                            }

                            log_message('info', 'total_impuesto: ' . $total_impuesto);

                            /*************************** Periodo *****************************/
                            $fecha_inicial = date('Y-m-d');

                            if($i>1){
                                $mas = (int)$i-1;
                                $fecha_mes = date('Y-m-d', strtotime( '+'.$mas.' month' , strtotime($fecha_inicial)));
                            }else{
                                $fecha_mes = $fecha_inicial;
                            }

                            $periodo = date('Ym' , strtotime($fecha_mes));
                            $mes = date('m', strtotime($fecha_mes));
                            $anio = date('Y', strtotime($fecha_mes));

                            /***************** Fecha de vencimiento ****************************/
                            $fecha = date($anio.'-'.$mes.'-'.$det['dfc_dia_fecha_cargo']);
                            $dias_plazo = $det['dfc_dias_plazo'] - 1;
                            $nuevafecha = strtotime('+'.$dias_plazo.' day' , strtotime($fecha)) ;
                            $nuevafecha = date('Y-m-d', $nuevafecha); 

                            log_message('info', "Verificando fechas: fecha_inicial=$fecha_inicial, fecha_mes=$fecha_mes, periodo=$periodo, fecha=$fecha, nuevafecha=$nuevafecha");


                                // Se agregan cargos al alumno.
                            $array_clg = array(
                                'clg_id_art' => $det['dfc_id_art'],
                                'clg_id_fac' => null,
                                'clg_id_gxa' => $gxa_id,
                                'clg_id_def' => null,
                                'clg_fecha'  => $fecha.' 00:00:00',
                                'clg_nombre' => ($articulo->art_nombre!='') ? $articulo->art_nombre : '',
                                'clg_cuota'  => $i,
                                'clg_monto'  => $clg_monto,
                                'clg_periodo'=> $periodo,
                                'clg_codigo_barra' => null,
                                'clg_fecha_vencimiento'=> $nuevafecha. ' 00:00:00',
                                'clg_dias_mora' => null,
                                'clg_monto_mora' => null,
                                'clg_fecha_pago' => null,
                                'clg_estado_cargo'=> 1,  // Pendiente
                                'clg_observacion' => null,
                                'clg_estado'=>1,
                                'clg_total_cuota' => null,
                                'clg_usu_creacion'=>$this->tank_auth->get_user_id(),
                                'clg_fecha_creacion'=>date('Y-m-d H:i:s'),
                                'clg_usu_modificacion'=>$this->tank_auth->get_user_id(),
                                'clg_fecha_modificacion'=>date('Y-m-d H:i:s'),
                                'clg_id_tlp' => $id_tlp,
                                'clg_impuestos' => number_format($total_impuesto, 2),
                                'clg_enlace_pago_externo' => null,
                                'clg_confirma_externo' => null
                            );
                            log_message('info', 'clg array: ' . json_encode($array_clg));
                            $this->gsatelite->ingresar('clg_cargo_alumnoxgrado', $array_clg);
                            //$this->gsatelite->ingresar('clg_cargo_alumnoxgrado', $array_gxa);
                        }
                    }

                //}
                }
            return true;
        }else{
            return false;
        }

    }


     /**
     * @author Edith Herrera
     * @since  2018-04-03
     * @return Mensaje de validación
     */
    public function validar_grado()
    {
        satelite_validar(true);

        $cliente = $this->input->post('cliente');
        $articulo = $this->input->post('producto');
        $grd_alm = $this->gsatelite->get_tabla('grd_grado', array('grd_id_art'=>$articulo));
        $alumno = $this->gsatelite->get_tabla('alm_alumno', array('alm_id_cli'=>$cliente));

        $mensaje = "";
        $grado = 0;

        if(count($grd_alm)>0 && count($alumno)>0){
            $grado = $grd_alm[0];
            $alm = $alumno[0];

            $grupos = $this->gsatelite->get_tabla('gra_grupo_academico');

            // **** Validar que no se pueda inscribir el mismo grado, a menos que el anterior esta reprobado o retirado *******//

            $get_gxa = $this->facturacion_model->get_inscripcion_grado(array('gxa_id_alm'=>$alm['alm_id'], 'gxa_id_grd'=>$grado['grd_id'], 'gxa_estado'=>1, 'lxp_tipo_inscripcion'=>2));
            //die(print_r($get_gxa));
            //$get_gxa = $this->gsatelite->get_tabla('gxa_gradoxalumno', array('gxa_id_alm'=>$alm['alm_id'], 'gxa_id_grd'=>$grado['grd_id'], 'gxa_estado'=>1));

            if(count($get_gxa)>0 && $get_gxa[0]['gxa_estado_grado']!=0 && $get_gxa[0]['gxa_estado_grado']!=3){
                $mensaje = "El alumno ya posee una inscripción en este grado.";
            }

            // ************* validar que se haya aprobado el grado anterior ********************************** //
            if($grado['grd_orden']>1){
                $anterior = $grado['grd_orden']-1;
                $grd_anterior = $this->gsatelite->get_registro('grd_grado', array('grd_orden'=>$anterior, 'grd_id_ard'=>$grado['grd_id_ard']));

                if(count($grd_anterior)>0){
                    $get_gxa = $this->gsatelite->get_tabla('gxa_gradoxalumno', array('gxa_id_alm'=>$alm['alm_id'], 'gxa_id_grd'=>$grd_anterior->grd_id));
                    if(count($get_gxa)>0 && $get_gxa[0]['gxa_estado_grado']!=1){
                        $mensaje = "El grado anterior aún no ha sido aprobado.";
                    }
                }

            }

        }

        echo json_encode(array('mensaje'=>$mensaje));
    }


    /**
    * @author ELman Ortiz
    * @fecha: 23/03/2018
    * @descripcion: Genera la partida contable automatica cuando se crea una factura independientemente si el producto tiene
    * @la configuracion de afecta o no inventario
    * @param integer fac_id, string num_fac
    * @return array {pct_id, total debe}
    */
    function generar_partida_anular_factura_afecta_noafecta_inv_debe($where, $info, $return = false){
        //print_r($where);
        //die();
        $total_debe = 0.0000;
        //Tipo de cuenta por defecto
        $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
        $where['idtipo_cnt'] = ($idtipo_cnt > 0) ? $idtipo_cnt : 0;//Se agrega el id del tipo cuenta que deben ser las cuentas para los productos
        $cnt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac_anular($where, $return);
        //print_r($this->db->last_query()); die();
        //Obtener los productos
        foreach ($cnt_prods as $key => $cnt_prod) {
            $total_debe = $total_debe + $cnt_prod['subtotal_prod'];
        }
        //Obtener detalles de los productos
        $cnt_dt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac_anular($where, $return);
        //print_r($cnt_dt_prods); die();
        //Obtener los impuestos
        $cnt_imps = $this->facturacion_model->get_cnt_x_impu_x_fac_anular($where, $return);

        foreach ($cnt_imps as $key => $cnt_imp) {
            $total_debe = $total_debe + $cnt_imp['subtotximpcuenta'];
        }
        //Obtener las retenciones
        $cnt_rets = $this->facturacion_model->get_cnt_x_ret_x_fac_anular($where, $return);
        //print_r($cnt_rets);
        //die();
        foreach ($cnt_rets as $key => $cnt_ret) {
            $total_debe = $total_debe + $cnt_ret['subtotxretcuenta'];
        }
        /*$cnt_rets = $this->compras_model->get_cnt_x_ret_x_docproveedor($where);
        foreach ($cnt_rets as $key => $cnt_ret) {
            $total_debe = $total_debe + $cnt_ret['subtotxretcuenta'];
        }*/

        if($return){//Se devuelve el arreglo para la vista previa
            return array('articulo_anul' => $cnt_prods, 'det_articulo_anul' => $cnt_dt_prods,'impuesto_anul' => $cnt_imps,'retencion_anul' => $cnt_rets, 'total_debe' => $total_debe);
        }else{//Se inserta la partida contable en la BD
            //Correlativo de la partida contable
            $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
            //Determinar el origen de la partida si es Documento Proveedor - Sin afectar inventario
            $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 2));
            $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;
            //Cuenta por defecto
            $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
            //Tipo de partida
            $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));
            $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
            if (count($consultar)>0) {
                $id_tipo_partida = $tipo_partida;
            }

            //Concepto por anulacion de factura
            $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 3));
            if(count($pct_concepto) > 0){
              $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
            }else{
              $pct_concepto = 'Concepto no definido';
            }

            $array_partida = array(
                'pct_id_tpd' => $id_tipo_partida,
                //'pct_id_prc' => $this->input->post('id_prc'),
                'pct_id_orp' => $orp_partida,//YA
                'pct_concepto' => $pct_concepto.' - ' . $info['num_fac'],//YA
                'pct_total' => number_format($total_debe, 4, '.', ''),//YA
                'pct_fecha' => date('Y-m-d H:i:s'), //YA
                'pct_correlativo' => $correlativo_partida,//YA
                //'pct_codigo' => $codigo,
                //'pct_modulo' => $modulo,
                'pct_estado' => 1,
                'pct_fecha_crea' => date('Y-m-d H:i:s'),
                'pct_fecha_mod' => date('Y-m-d H:i:s'),
                'pct_usu_crea' => $this->tank_auth->get_user_id(),
                'pct_usu_mod' => $this->tank_auth->get_user_id()
            );

            $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);

            //Ingresar los detalles de la partida para los productos
            foreach ($cnt_prods as $j => $deta) {
                $dpc_id_cnt = ($deta['cnt_id'] > 0) ? $deta['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                $array_detalle = array(
                    'dpc_id_cnt' => $dpc_id_cnt,//YA
                    'dpc_id_pct' => $id_pct,//YA
                    'dpc_concepto' => 'Venta de producto',//YA
                    'dpc_debe' => $deta['subtotal_prod'],//debe
                    'dpc_haber' => 0.00,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );

                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }

            //Ingresar los detalles de la partida para los impuesto
            foreach ($cnt_imps as $j => $deta) {
                $dpc_id_cnt = ($deta['cxe_id_cnt'] > 0) ? $deta['cxe_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
                $array_detalle = array(
                    'dpc_id_cnt' => $dpc_id_cnt,//YA
                    'dpc_id_pct' => $id_pct,//YA
                    'dpc_concepto' => 'Impuestos por venta',
                    'dpc_debe' => $deta['subtotximpcuenta'],//debe
                    'dpc_haber' => 0.00,
                    'dpc_estado' => 1,
                    'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                    'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dpc_usu_mod' => $this->tank_auth->get_user_id()
                );

                $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
            }

            return array('id_pct' => $id_pct, 'total_debe' => $total_debe);
        }//Fin else para insertar la partida contable en la BD

    }

    /**
     *@return Elman Ortiz
     *@fecha 23/03/2018
     *@descripcion: Haber para factura al ser anulada
     */
    function generar_partida_anular_factura_afecta_noafecta_inv_haber($where, $id_pct, $monto_haber, $return = false){

        $id_cuenta = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');

        if($return){//Si es el modulo contabilidad
            $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
            $where['idtipo_cnt'] = ($idtipo_cnt>0)? $idtipo_cnt:0;
            $id_cnt = $this->facturacion_model->get_cnt_x_haber_x_fac_anular($where, true);
            //print_r($id_cnt); die();
            return $id_cnt;
        }else{
            if(count($id_cnt) > 0){
                if($id_cnt[0]['cnt_id'] > 0){
                    $id_cuenta = $id_cnt[0]['cnt_id'];
                }
            }

            $array_detalle = array(
                'dpc_id_cnt' => $id_cuenta,//YA
                'dpc_id_pct' => $id_pct,//Ya
                'dpc_concepto' => 'Entrada a caja',
                'dpc_debe' => 0.00,//debe
                'dpc_haber' => $monto_haber,
                'dpc_estado' => 1,
                'dpc_fecha_crea' => date('Y-m-d H:i:s'),
                'dpc_fecha_mod' => date('Y-m-d H:i:s'),
                'dpc_usu_crea' => $this->tank_auth->get_user_id(),
                'dpc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);
        }

    }//Fin haber partida contable cuando NO afecta inventario por medio de documento por proveedor

    /**
     *@return Elman Ortiz
     *@fecha 26/03/2018
     *@descripcion: Funcion principal que se utilizar para generar la partida de anulacion tanto del
     *@descripcion: modulo de facturacion y contabilidad
     *@return return: true, Devuelve un arreglo para ser usado el modulo contabilidad
     *@return return: false, Genera la partida contable
     */
    public function generar_partida_anulacion_facturacion_contabilidad($where, $info, $return = false){
        if($return){
            $res_debe = $this->generar_partida_anular_factura_afecta_noafecta_inv_debe($where ,false, $return);
            /*****Where para el haber*****/
            $where_ha['fac_fecha_cont'] = $where['fac_fecha_cont'];
            $where_ha['fac_estado'] = 0;
            $info_ha['num_fac'] = '';
            /****************************/
            $res_haber = $this->generar_partida_anular_factura_afecta_noafecta_inv_haber($where_ha, 0, 0, true);
            return array('debe' => $res_debe,'haber' => $res_haber);
        }else{
            $id = $where['fac_id'];
            $res_debe = $this->generar_partida_anular_factura_afecta_noafecta_inv_debe($where, $info, $return);
            $this->generar_partida_anular_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_debe'], $return);
            //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida
            //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
            $this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct_anulacion' => $res_debe['id_pct']), array('fac_id' => $id));
        }

    }


    /**
     * @author Edith Herrera - Grupo Satélite
     * @since 2018-04-18
     * @return True, cuando se ha revertido la información del alumno y False cuando no se ha podido realizar la función
     *
    **/
    public function procesar_anulacion_alumno($id){

        $info = $this->facturacion_model->get_registro_alumno(array('fac_id'=>$id));

        if(count($info)){ // Si se encuentran inscripciones
            $cancelar = 0;
            foreach ($info as $key ) {
                 if($key['lxp_condicion']!=1 || $key['lxp_promedio']>0){
                    $cancelar++;
                 }
            }

            if($cancelar==0){
                $act = 0;
                $user = $this->tank_auth->get_user_id();
                foreach ($info as $inf ) {
                    if($inf['gra_id_grd']>0){ // Es inscripción de grado
                        if($inf['lxp_fecha_inscripcion']!=null){
                            $act += $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_tipo_inscripcion'=>1, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$user), array('lxp_id'=>$inf['lxp_id']));
                        }else{
                            $act += $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_estado'=>0, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$user), array('lxp_id'=>$inf['lxp_id']));
                            $act += $this->gsatelite->actualizar_array('gxa_gradoxalumno', array('gxa_estado'=>0, 'gxa_fecha_modificacion'=>date('Y-m-d H:i:s'), 'gxa_usu_modificacion'=>$user), array('gxa_id_grd'=>$inf['gra_id_grd'], 'gxa_id_alm'=>$inf['lxa_id_alm'], 'gxa_estado_grado'=>2));
                        }

                    }else{ // Es inscripción de curso
                        $act += $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_tipo_inscripcion'=>1, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$user), array('lxp_id'=>$inf['lxp_id']));
                    }
                }
                if($act>0){
                    $this->gsatelite->actualizar_array('fac_factura', array('fac_estado'=>0, 'fac_fecha_mod'=>date('Y-m-d H:i:s'), 'fac_usu_mod'=>$user), array('fac_id'=>$inf['fac_id']));
                }
            }else{
                return false;
            }

            return true;

        }
    }

    /**
     *@return Luis Navarro
     *@fecha 18/04/2018
     *@descripcion: Funcion para generar el corte o cierre de caja por usuario
     *@return Registra el corte o cierre de una caj
     */
    public function generar_corte_cierre_caja($uxc = null, $info = null, $tipo = null) {
        satelite_validar();

        // Obtener los datos del usuario por caja
        $uxc = (isset($uxc) && $uxc>0)?$uxc:null;
        $tipo = (isset($tipo) && $tipo>0)?$tipo:2;
        $uxc_id = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id'=>$uxc));
        $crc_id_array = array();
        $dgc_id_array = array();
        $dft_id_array = array();

        // Obtener el total de facturado y facturas utilizadas
        $total_facturado        = 0;
        $total_fac_utilizadas   = 0;

        // condicional
        $where['uxc_id']        = $uxc;
        $where['fac_estado > '] = 0 ;
        // Agrupador
        $groupby = 'fac_id_cof, fac_id_tif';

        // Obtener los datos de correlativos y caja
        $dt_corr_uxc = $this->facturacion_model->get_datos_corr_usuarioxcaja($where, $groupby);
        // die(print_r($this->db->last_query()));
        // Recorrer los tipos de factura con correlativos
        foreach ($dt_corr_uxc as $llave => $valor) {
            // Sumar el total de facturas realizadas
            $total_fac_utilizadas += ($valor['cantidadFac']>0)?$valor['cantidadFac']:0;

            $crc_array = array(
                'crc_id_uxc'             => ($valor['uxc_id']>0)?$valor['uxc_id']:null,
                'crc_id_cof'             => ($valor['cof_id']>0)?$valor['cof_id']:null,
                'crc_id_tif'             => ($valor['fac_id_tif']>0)?$valor['fac_id_tif']:null,
                'crc_correlativo_inicio' => ($valor['corrPrimero']>0)?$valor['corrPrimero']:null,
                'crc_correlativo_fin'    => ($valor['corrUltimo']>0)?$valor['corrUltimo']:null,
                'crc_fac_utilizada'      => ($valor['cantidadFac']>0)?$valor['cantidadFac']:null,
                'crc_descripcion'        => null,
                'crc_estado'             => 1,
                'crc_usu_creacion'       => $this->tank_auth->get_user_id(),
                'crc_fecha_creacion'     => date('Y-m-d H:i:s'),
                'crc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'crc_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $id_crc = $this->gsatelite->ingresar('crc_correlativo_cortexcaja', $crc_array);
            array_push($crc_id_array, $id_crc);
        }

        // Agrupador
        $groupby = 'fac_id_tif,fac_id_tpg,fac_id_frp';
        // Obtener los datos de tipos de pagos
        $dt_pago_dgc = $this->facturacion_model->get_datos_pago_usuarioxcaja($where, $groupby);

        if(count($dt_corr_uxc) > 0){
            // Recorrer los registros para los tipos de pagos
            foreach ($dt_pago_dgc as $llave => $valor) {
                // Suma de la totalidad
                $total = ($valor['gravadatotal']);
                $total_facturado += $total;
                $dgc_array = array(
                    'dgc_id_uxc'          => ($valor['uxc_id']>0)?$valor['uxc_id']:null,
                    'dgc_id_tif'          => ($valor['fac_id_tif']>0)?$valor['fac_id_tif']:null,
                    'dgc_id_tpg'          => ($valor['fac_id_tpg']>0)?$valor['fac_id_tpg']:null,
                    'dgc_id_frp'          => ($valor['fac_id_frp']>0)?$valor['fac_id_frp']:null,
                    'dgc_total'           => ($total > 0) ? round($total, 4):0,
                    'dgc_fac_utilizada'   => ($valor['cantidadFac']>0)?$valor['cantidadFac']:null,
                    'dgc_descripcion'     => null,
                    'dgc_estado'          => 1,
                    'dgc_usu_creacion'    => $this->tank_auth->get_user_id(),
                    'dgc_fecha_creacion'  => date('Y-m-d H:i:s'),
                    'dgc_usu_modificacion'=> $this->tank_auth->get_user_id(),
                    'dgc_fecha_modificacion'=> date('Y-m-d H:i:s')
                );

                $id_dgc = $this->gsatelite->ingresar('dgc_detalle_pago_corte', $dgc_array);
                array_push($dgc_id_array, $id_dgc);
            }
            // Definir agrupador
            $groupby = 'tia_id';
            // Obtener los registros de los articulos con categorias en facturas
            $dt_art_fac_dft = $this->facturacion_model->get_catxproductos_usuarioxcaja($where, $groupby);
            // Recorrer los registros de las categorias por articulo en las facturas
            foreach ($dt_art_fac_dft as $llave => $valor) {
                $dft_array = array(
                    'dft_id_tia'            => ($valor['tia_id']>0)?$valor['tia_id']:null,
                    'dft_id_uxc'            => ($valor['uxc_id']>0)?$valor['uxc_id']:null,
                    'dft_total'             => ($valor['total'] > 0) ? round($valor['total'], 4) : 0,
                    'dft_art_encontrado'    => $valor['prodTotal'],
                    'dft_art_diferente'     => $valor['prodDistintos'],
                    'dft_fac_encontrada'    => $valor['facturas'],
                    'dft_descripcion'       => null,
                    'dft_estado'            => 1,
                    'dft_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'dft_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'dft_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'dft_fecha_modificacion'=> date('Y-m-d H:i:s')
                );

                $id_dft = $this->gsatelite->ingresar('dft_detalle_fact_tipoart', $dft_array);
                array_push($dft_id_array, $id_dft);
            }
        }

        // Obtener el correlativo
        $caja   = $uxc_id[0]['uxc_id_caj'];

        // Obtener el correlativo para la tira de corte o cierre
        $corr_ticket = $this->generar_correlativo_corte_cierre($caja); // Correlativo para el corte o cierre
        // print_r($corr_ticket);
        //area por defecto
        $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto'=> 1, 'arf_estado'=> 1));

        // Parametro de cliente por defecto
        $cliente_defecto = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');

        if (is_numeric($cliente_defecto) && $cliente_defecto > 0 && !isset($corr_ticket['error'])) {
            // Generar factura para guardar el correlativo que tendra el corte mensual
            $datos_array_factura = array(
                'fac_id_cli'                => $cliente_defecto,
                'fac_id_tif'                => (!isset($corr_ticket['error']))?$corr_ticket['tif_id']:null,
                'fac_id_cof'                => (!isset($corr_ticket['error']))?$corr_ticket['cof_id']:null,
                'fac_numero'                => (!isset($corr_ticket['error']))?$corr_ticket['correlativo']:null,
                'fac_id_arf'                => $arf_defecto,
                'fac_id_uxc'                => $uxc,
                'fac_fecha_fact'            => date('Y-m-d H:i:s'),
                'fac_fecha_cont'            => date('Y-m-d H:i:s'),
                'fac_fecha_vencimiento'     => date('Y-m-d H:i:s'),
                'fac_subtotal'              => 0,
                'fac_descuento'             => 0,
                'fac_impuesto'              => 0,
                'fac_total'                 => 0,
                'fac_estado'                => 2,
                'fac_fecha_crea'            => date('Y-m-d H:i:s'),
                'fac_usu_mod'               => $this->tank_auth->get_user_id(),
                'fac_fecha_mod'             => date('Y-m-d H:i:s'),
                'fac_usu_crea'              => $this->tank_auth->get_user_id()
            );

            $id_factura = $this->gsatelite->ingresar('fac_factura', $datos_array_factura);
        }

        $id_partida_consolidada = null;
        if($tipo == 2 || $tipo == 3){
            $permite_partida = $this->gsatelite->get_parametro('SYS_PARTIDA_CONSOLIDADA_CAJA', 0);
            if($permite_partida != 0){
                $uxc_array = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id' => $uxc));
                $id_partida_consolidada = $this->partida_consolidada_caja($uxc, $uxc_array[0]['uxc_fecha_proceso']);
            }
        }

        // Ingresar correlativo y actualizar el registro uxc
        // Actualizar el total de facturado y las facturas utilizadas por el cajero
        $datos_array = array(
            'uxc_id_pct'              => $id_partida_consolidada,
            'uxc_id_fac'              => (is_numeric($id_factura) && $id_factura > 0) ? $id_factura : null,
            'uxc_id_cof_correlativo'  => (!isset($corr_ticket['error']))?$corr_ticket['cof_id']:null,
            'uxc_correlativo_corte'   => (!isset($corr_ticket['error']))?$corr_ticket['correlativo']:null,
            'uxc_total_facturado'     => $total_facturado,
            'uxc_fac_utilizada'       => $total_fac_utilizadas,
            'uxc_usu_mod'             => $this->tank_auth->get_user_id(),
            'uxc_fecha_mod'           => date('Y-m-d H:i:s')
        );
        $this->gsatelite->actualizar_array('uxc_usuarioxcaja', $datos_array, array('uxc_id'=> $uxc));

        return array('crc'=>count($crc_id_array), 'dgc'=>count($dgc_id_array), 'dft'=>count($dft_id_array));
    }

    /**
     *@return Luis Navarro
     *@fecha 19/04/2018
     *@descripcion: Funcion para imprimir tira de corte o cierre de usuario por caja
     *@return el pdf con la tira
     */
    public function imprimir_tira_corte_cierre($uxc = null, $tipo = null) {
        satelite_validar();
        // registro_ventas
        //preguntar si viene por url el prefijo ccm
        $id_filtro_ccm = 0;
        $registro_corte = array();
        $registro_ventas = array();
        $regs_frp_ventas = array();
        $band=0;
        $fecha_emicion_m = date('Y-m-d H:i:s');
        $fecha_ccm = "";
        if (substr_count($uxc, 'ccm') > 0 ) {
            $id_filtro_ccm = str_replace('ccm', '', $uxc);
            $corte_mensual = 1;
            $tipo = 3;
            $band=1;
            $uxc = null;
            $uxc_id = null;
            $registro_corte = $this->gsatelite->get_tabla('ccm_corte_caja_mensual',array('ccm_id'=>$id_filtro_ccm));
            $caja = $registro_corte[0]['ccm_id_caj'];
            $fecha_ccm = formatear_fecha('m-Y', $registro_corte[0]['ccm_fecha_desde']);
            $registro_det = $this->gsatelite->get_tabla('dxc_detallexcorte_mensual',array('dxc_id_ccm'=>$id_filtro_ccm));
            $where = array_column($registro_det, 'dxc_id_uxc');
            $registro_corte = $registro_corte[0];
            $uxc_reg = $this->facturacion_model->get_usuario_cajas(array('dxc_id_ccm'=>$id_filtro_ccm));
            $prueba = explode(',', $uxc_reg[0]['usuarios_caja']);
            $registro_ventas = $this->facturacion_model->get_ventas_tipo($prueba, 'dgc_id_tpg');
        }
        if ($id_filtro_ccm == 0) {
            $corte_mensual = 0;
            // Si vienen datos POST, es para el corte mensual
            if ($this->input->post()) {
                $caja       = $this->input->post('caja');
                $tipo       = $this->input->post('tipo');
                $fechaDesde = formatear_fecha('Y-m-d', $this->input->post('fechaInicio'));
                $fechaHasta = formatear_fecha('Y-m-d', $this->input->post('fechaFin'));
                $corte_mensual = $this->input->post('corte_mensual');
                $band = 1;
            }
            // Obtener los datos del usuario por caja
            $uxc  = (isset($uxc) && $uxc>0)?$uxc:null;
            $tipo = (isset($tipo) && $tipo>0)?$tipo:2;
            $this->db->join('users', 'id = uxc_id_usu');
            $this->db->join('emp_empleado', 'emp_id = usu_id_emp', 'left');
            $uxc_id = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id'=>$uxc));

            // condicional
            $where['uxc_id']        = $uxc;

            // print_r($this->db->last_query());
            // die();
            // Para obtener los ID para el cierre
            if($tipo == 3){
                $uxc_array = $this->facturacion_model->obtener_usuarioscaja_dia($where);
                unset($where['uxc_id']);
                $uxc_ids = explode(",", $uxc_array[0]['id_uxc']);
                $where = $uxc_ids;
            }


            $registro_ventas = $this->facturacion_model->get_ventas_tipo($where, 'dgc_id_tpg', array('fac_estado >' => 0));
            $regs_frp_ventas = $this->facturacion_model->get_ventas_forma_pago($where, null, array('fac_estado >' => 0));
            // print_r($this->db->last_query());
            // die();
            // print_r($uxc_id);
            // print_r($this->db->last_query());die();

            // Para obtener los ID para el corte mensual
            if ($corte_mensual != 0) {
                unset($where['uxc_id']);
                $where = "(DATE(uxc.uxc_fecha_proceso) BETWEEN '$fechaDesde' AND '$fechaHasta') AND uxc.uxc_id_caj = $caja";//cambie 2019-04-11
                $uxc_array = $this->facturacion_model->obtener_corte_caja_uxc($where);
                $uxc_ids = explode(",", $uxc_array[0]['uxc_id']);
                $where = $uxc_ids;

                // GUARDAR LA ESTRUCTURA DEL CORTE Z MENSUAL
                //preguntar si ya existe un corte
                $where_existe['ccm_id_caj'] = $caja;
                $where_existe["(DATE('$fechaDesde') BETWEEN DATE(ccm_fecha_desde) AND DATE(ccm_fecha_hasta) OR DATE('$fechaHasta') BETWEEN DATE(ccm_fecha_desde) AND DATE(ccm_fecha_hasta))"] = null;
                $query_existe_corte = $this->gsatelite->get_tabla('ccm_corte_caja_mensual',$where_existe);

                if (count($uxc_array) > 0 && isset($uxc_array[0]['uxc_id']) && count($query_existe_corte) <= 0) {
                    // Obtener el correlativo para la tira de corte o cierre
                    $data['corr_ticket'] = $this->generar_correlativo_corte_cierre($caja); // Correlativo para el corte o cierre

                    // Parametro de cliente por defecto
                    $cliente_defecto                = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');

                    if (is_numeric($cliente_defecto) && $cliente_defecto > 0 && !isset($data['corr_ticket']['error'])) {
                        // Generar factura para guardar el correlativo que tendra el corte mensual
                        $datos_array_factura = array(
                            'fac_id_cli'                => $cliente_defecto,
                            'fac_id_tif'                => (!isset($data['corr_ticket']['error']))?$data['corr_ticket']['tif_id']:null,
                            'fac_id_cof'                => (!isset($data['corr_ticket']['error']))?$data['corr_ticket']['cof_id']:null,
                            'fac_numero'                => (!isset($data['corr_ticket']['error']))?$data['corr_ticket']['correlativo']:null,
                            'fac_fecha_fact'            => date('Y-m-d H:i:s'),
                            'fac_fecha_cont'            => date('Y-m-d H:i:s'),
                            'fac_fecha_vencimiento'     => date('Y-m-d H:i:s'),
                            'fac_subtotal'              => 0,
                            'fac_descuento'             => 0,
                            'fac_impuesto'              => 0,
                            'fac_total'                 => 0,
                            'fac_estado'                => 2,
                            'fac_fecha_crea'            => date('Y-m-d H:i:s'),
                            'fac_usu_mod'               => $this->tank_auth->get_user_id(),
                            'fac_fecha_mod'             => date('Y-m-d H:i:s'),
                            'fac_usu_crea'              => $this->tank_auth->get_user_id()
                        );
                        $id_factura = $this->gsatelite->ingresar('fac_factura', $datos_array_factura);
                    }
                    $fecha_emicion_m = date('Y-m-d H:i:s');
                    $datos_array_corte = array(
                        'ccm_id_caj'                => $caja,
                        'ccm_id_fac'                => (is_numeric($id_factura) && $id_factura > 0)? $id_factura : null,
                        'ccm_id_cof_correlativo'    => (!isset($data['corr_ticket']['error']))?$data['corr_ticket']['cof_id']:null,
                        'ccm_correlativo_corte'     => (!isset($data['corr_ticket']['error']))?$data['corr_ticket']['correlativo']:null,
                        'ccm_usu_genera'            => $this->tank_auth->get_user_id(),
                        'ccm_descripcion'           => "Corte mensual",
                        'ccm_fecha_desde'           => $fechaDesde,
                        'ccm_fecha_hasta'           => $fechaHasta,
                        'ccm_estado'                => 1,
                        'ccm_usu_creacion'          => $this->tank_auth->get_user_id(),
                        'ccm_fecha_creacion'        => $fecha_emicion_m,
                        'ccm_usu_modificacion'      => $this->tank_auth->get_user_id(),
                        'ccm_fecha_modificacion'    => date('Y-m-d H:i:s')
                    );
                    $id_corte_mensual = $this->gsatelite->ingresar('ccm_corte_caja_mensual',$datos_array_corte);
                    for ($q=0; $q < count($uxc_ids); $q++)
                    {
                        $detalle_array_corte = array(
                            'dxc_id_ccm'            => $id_corte_mensual,
                            'dxc_id_uxc'            => $uxc_ids[$q],
                            'dxc_estado'            => 1,
                            'dxc_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'dxc_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'dxc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dxc_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('dxc_detallexcorte_mensual',$detalle_array_corte);
                    }
                }

                $where_p = 'date(ccm_fecha_desde) >="'.$fechaDesde.'" AND DATE(ccm_fecha_hasta) <= LAST_DAY("'.$fechaHasta.'") AND ccm_id_caj = '.$caja;
                $ccm_reg = $this->facturacion_model->get_caja_mensual($where_p);

                $uxc_reg = $this->facturacion_model->get_usuario_cajas(array('dxc_id_ccm'=>$ccm_reg[0]['ccm_id']));
                $filtro_usuarios_caja = explode(',', $uxc_reg[0]['usuarios_caja']);
                $registro_ventas = $this->facturacion_model->get_ventas_tipo($filtro_usuarios_caja, 'dgc_id_tpg');
            }
        }
        $data['fecha_emision'] = (count($registro_corte) > 0)?formatear_fecha('d/m/Y', $registro_corte['ccm_fecha_creacion']):formatear_fecha('d/m/Y', $fecha_emicion_m ) ;
        $data['hora_emision'] = (count($registro_corte) > 0)?date('g:i a', strtotime($registro_corte['ccm_fecha_creacion'])):date('g:i a', strtotime($fecha_emicion_m) ) ;
        if(count($registro_corte) > 0){
            $fecha_creacion = $registro_corte['ccm_fecha_creacion'];
            $fecha_hasta = formatear_fecha('Y-m-d', $registro_corte['ccm_fecha_hasta']).' 19:00:00';
            $fecha_hasta_fin = formatear_fecha('Y-m-d', $registro_corte['ccm_fecha_hasta']).' 23:59:59';

            $fechatotime_corte = strtotime($registro_corte['ccm_fecha_creacion']);
            $fechatotime_defecto = strtotime($fecha_hasta_fin);
            if($fechatotime_corte > $fechatotime_defecto){
                $data['fecha_emision'] = (count($registro_corte) > 0)?formatear_fecha('d/m/Y', $fecha_hasta):formatear_fecha('d/m/Y', $fecha_emicion_m ) ;
                $data['hora_emision'] = (count($registro_corte) > 0)?date('g:i a', strtotime($fecha_hasta)):date('g:i a', strtotime($fecha_emicion_m) ) ;
            }
        }
        // print_r($registro_corte); die();
        if( ($tipo == 2 || $tipo==3) && $band == 0){
            $data['fecha_emision'] = (count($registro_corte) > 0)?formatear_fecha('d/m/Y', $registro_corte['ccm_fecha_creacion']):formatear_fecha('d/m/Y', $uxc_id[0]['uxc_fecha_proceso'] ) ;
            $data['hora_emision'] = (count($registro_corte)>0)?date('g:i a',strtotime($registro_corte['ccm_fecha_creacion'])):date('g:i a', strtotime($uxc_id[0]['uxc_fecha_mod']));
        }

        // Datos para la vista
        $data['uxc_id'] = $uxc;
        $data['tipo']   = $tipo;
        $data['band']   = $band;
        $data['info_uxc'] = $uxc_id;
        // Dato para el corte mensual
        $data['caja']          = (isset($caja))?$caja:null;
        $data['corte_mensual'] = $corte_mensual;

        $data['registro_corte'] = $registro_corte;
        $data['registro_ventas'] = $registro_ventas;
        $data['regs_frp_ventas'] = $regs_frp_ventas;

        $data['mes_corte'] = number_format(formatear_fecha('m',$data['fecha_emision'])) -1;

        // Agrupador para obtener los tipos de pagos con sus cantidades correspondientes
        $groupby = 'dcg1.dgc_id_tif';
        $orderby = 'dcg1.dgc_id_tif, dcg1.dgc_id_tpg';

        /* Consulta para imprimir el ticket de corte o cierre */
        // Obtener los correlativos por tipo de factura
        $data['get_correlativos_cortexcaja'] = $this->facturacion_model->get_correlativos_cortexcaja($where, 'tif_id', null, 2);

        // Obtener todo los registros
        $data['get_correlativos'] = $this->facturacion_model->get_correlativos_cortexcaja($where, null, null, 2);
        // print_r($registro_corte['get_correlativos']);die();
        // Para obtener en orden de pago
        $data['get_tipo_pago_corte']         = $this->facturacion_model->get_tipo_pago_corte($where, $groupby, $orderby, 2);
        $data['filtro_mes'] = ($fecha_ccm == "") ? explode('-', $this->input->post('txtMes')) : explode('-', $fecha_ccm);
        // print_r($this->db->last_query());exit();die();
        // Obtener las categorias con los montos totales
        // print_r($data['get_tipo_pago_corte']);
        // die();
        $data['get_fact_categoria_corte']    = $this->facturacion_model->get_fact_categoria_corte($where, 'tia_id', 'tia_id', 2);
        // print_r($this->db->last_query());
        // die();
        // print_r($this->db->last_query());die();
        // condicional
        $where['uxc_id']        = (isset($uxc) && $uxc>0)?$uxc:null;
        // Agrupador
        $groupby = 'fac_id_tif,fac_id_tpg';
        // Obtener los datos de tipos de pagos
        $data['dt_pago_dgc'] = $this->facturacion_model->get_datos_pago_usuarioxcaja($where, $groupby, 2);

        // Dinamico la tira de corte o cierre dependiendo de la cantidad de categorias
        $cantCategorias =   count($data['get_fact_categoria_corte']) * 10;
        $cantPagos =   count($data['registro_ventas']) * 20;
        // Configuracion
        $fuente = 'helvetica';
        $setCellPaddings = '0,0,0,0';
        
        $orientacion = 'P';
        $formato     = array(0 => 69, 1 => (210 + $cantPagos + $cantCategorias));
        $html = $this->load->view('facturacion/facturar/detalle_tira_corte_cierre_pdf', $data, true);
        // print_r($data);
        // die();
        $this->pdf->setPrintHeader(false);
        $this->pdf->SetFont($fuente);
        $this->pdf->setCellPaddings($setCellPaddings);
        $this->pdf->SetAutoPageBreak(true, 0);
        // $this->pdf->SetMargins(10, 16, 10);
        $this->pdf->SetMargins(0,0,0); //$margins = '0,0,0';
        $this->pdf->AddPage($orientacion, $formato, array(
            'family' => $fuente,
            'style' => '',
            'size' => 9) , true
        );
        $this->pdf->setPrintFooter(false);
        $this->pdf->writeHTML($html, true, false, false, false, '');
        $this->pdf->boletaPDF('I');
    }

    /**
     *@return Luis Navarro
     *@fecha 25/05/2018
     *@descripcion: Funcion de mostrar la vista de generar vista de corte mensual z
     *@return vista del corte mensual
     */
    public function generar_corte_mensual_z(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        $cajas = $this->gsatelite->get_dropdown('caj_caja', '{caj_nombre}', '', array('caj_estado' => '1'), null, '', 'caj_id', true);
        $data["cajas"] = str_replace('<option value="0">Seleccione</option>', '', $cajas);

        $data['titulo_personal'] = 'Generación Corte Z Mensual';
        $this->_cargarvista($data);
    }

    /**
     *@return Francisco Orozco
     *@fecha 21/08/2018
     *@descripcion: Funcion para imprimir orden de venta
     *@return impresion pdf de la orden de venta
     */
    public function imprimir_orden_venta($orden = null) {
        satelite_validar();
        if ( $orden > 0 ) {
            $this->load->library('EnLetras');
            //verificar si existe formato de orden de compra
            $formato_orden = $this->gsatelite->get_tabla('fri_formato_impresion', array('fri_estado' => 1,'fri_activo' => 1, 'fri_tipo_formato' => 3) );
            if ( count($formato_orden) > 0 && $orden > 0) {
                $where['orv_id']    = $orden;

                //DATOS DE LA EMPRESA
                $data['empresa']    = $this->gsatelite->get_parametro("SYS_EMPRESA");
                $data['direccion']  = $this->gsatelite->get_parametro("SYS_DIR");
                $data['telefono']   = $this->gsatelite->get_parametro("SYS_TEL");
                $data['titulo'] = 'Orden De venta';
                //CONFIGURACIONES
                $conf_formato = $formato_orden[0]['fri_configuraciones_formato'];
                $conf_formato_array = json_decode($conf_formato, true);
                $array_datos = array();
                $array_datos['iva']         = (isset($conf_formato_array['IVA']))?$conf_formato_array['IVA']:0;
                $array_datos['propina']    = (isset($conf_formato_array['PROPINA']))?$conf_formato_array['PROPINA']:0;
                $array_datos['fijo']    = (isset($conf_formato_array['FIJO']))?$conf_formato_array['FIJO']:0;
                $array_datos['celular']    = (isset($conf_formato_array['CELULAR']))?$conf_formato_array['CELULAR']:0;
                $array_datos['documento']    = (isset($conf_formato_array['DOCUMENTO']))?$conf_formato_array['DOCUMENTO']:0;
                $data['orden_venta']= $this->facturacion_model->get_orden_venta($where,$array_datos);
                $data['width_conf'] = $conf_formato_array['WIDTH'];
                $data['height_conf']= $conf_formato_array['HEIGHT'];
                $data['size_letra'] = 6;
                if ( isset($conf_formato_array['SIZE_LETRA']) != ''){ // Se verifica si existe la variable en la tabla frf
                    $data['size_letra'] = $conf_formato_array['SIZE_LETRA'];
                }
                $html = $this->load->view('facturacion/facturar/'.$formato_orden[0]['fri_archivo'], $data, true);
                $js = "print(true)"; // Se ejecuta la mpresión al cargar el PDF.
                $this->pdf->IncludeJS($js);
                if(isset($conf_formato_array['SETCELLPADDINGS']) != '' OR isset($conf_formato_array['FORMATO']) != ''){
                    $orientacion = $conf_formato_array['ORIENTACION'];
                    $formato = $conf_formato_array['FORMATO'];
                    $formato_array = explode(",",$formato); // Convierte el formato a array por si se quiere un formato personalizado de pagina
                    $fuente = "helvetica";
                    if ( isset($conf_formato_array['SETCELLPADDINGS']) != '' ){
                        $setCellPaddings = $conf_formato_array['SETCELLPADDINGS'];
                    }
                    if ( isset($conf_formato_array['FUENTE']) != ''){// Verifica si existe el tiempo de fuente, ejemplo: calibrib.
                        $fuente = $conf_formato_array['FUENTE'];
                    }
                    $margins = $conf_formato_array['MARGINS'];
                    // Verificar si es ticket que sera imprimido
                    if (isset($conf_formato_array['TICKET']) && $conf_formato_array['TICKET'] > 0 && count($formato_array) > 1) {
                        // Cantidad de productos
                        $cantidad_productos = count($data['orden_venta']);
                        // Calcular la cantidad de altura que se sumara
                        $cant_pro_px = $cantidad_productos * 9;
                        // Asignar el formato
                        $formato = array(0=>$formato_array[0], 1=>($formato_array[1]+$cant_pro_px));
                    } else {
                        $formato = (count($formato_array) > 1)?$formato_array:$formato;//si tiene mas de un elemento se toma el array y si no el valor del formato
                    }
                    $this->pdf->setPrintHeader(false);
                    $this->pdf->SetFont($fuente);
                    $this->pdf->setCellPaddings($setCellPaddings);
                    $this->pdf->SetAutoPageBreak(true, 0);
                    $this->pdf->SetMargins($margins); //274, 155
                    $this->pdf->AddPage($orientacion, $formato, array(
                        'family' => $fuente,
                        'style' => '',
                        'size' => 6) , true
                    );
                    $this->pdf->setPrintFooter(false);
                    $this->pdf->writeHTML($html, true, false, false, false, '');
                    $this->pdf->boletaPDF('I');
                } else{
                    $this->pdf->setPrintFooter(false);
                    $this->pdf->makePDF($html, $conf_formato_array['ORIENTACION'], null , 'Letter');
                }

                var_dump( "FIN" );die();
            } else {
                // ID de la orden de venta
                $orv_id = $orden;
                // Datos de la orden de venta
                $orden_venta_datos = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id' => $orv_id));
                //Datos del vendedor
                $data['vendedor'] = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id' => $orden_venta_datos[0]['orv_id_ven']));
                //Datos de tipo de pago
                $data['tipo_pago'] = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_id' => $orden_venta_datos[0]['orv_condicion_pago']));
                // Enviar dats de la orden de venta a la vista
                $data['orden_venta_datos'] = $orden_venta_datos;
                // Cliente
                $data['cliente'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $orden_venta_datos[0]['orv_id_cli']));
                $data['telefono'] = $this->gsatelite->get_max('txc_telefonoxcliente', 'txc_numero', array('txc_id_cli' => $orden_venta_datos[0]['orv_id_cli']));
                // Detalle de la orden de venta
                $data['datos_orden'] = $this->facturacion_model->get_detalle_orden_venta(array('dov_id_orv' =>$orv_id));
                $data['titulo'] = 'Orden de venta';
                $header = $this->load->view('reporte/header', $data, true);
                // Cargar la vista para el PDF
                $html = $this->load->view('facturacion/facturar/imprimir_orden_venta', $data, true);
                $body = $html;
                $GLOBALS['nombre_reporte'] = 'orden_venta' . date('dmY');
                $this->pdf->makePdf($body, 'L', 'orden_venta', 'Letter');
            }
        }
    }

    /**
     *@return René Castaneda
     *@fecha 29/05/2018
     *@descripcion: Funcion para crear movimiento de entrada a inventario apartir de la devolución
     */
    function crear_movimiento_devolucion($fac_id, $bodega_bod, $producto_art, $cantidad_dee, $medida_cva, $bodegas_all,$tipo_proceso_fac="FACTURA_DEVOLUCION") {

        $tip_entrada = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array("$tipo_proceso_fac"));
        $reg_fac = $this->gsatelite->get_registro('fac_factura','fac_id',$fac_id);
        //$factura_origen = $this->gsatelite->get_registro('fac_factura','fac_id',$reg_fac->fac_id_origen_devolucion);
        $registro_mov_origen = $this->gsatelite->get_tabla('moi_movimiento_inv',array('moi_id_fac'=>$reg_fac->fac_id_origen_devolucion));

        if (count($registro_mov_origen) > 0) { //condicionar si la factura de origen realizo descarga de inventario
            $array_mov = array_column($registro_mov_origen, 'moi_id');

        foreach ($bodegas_all as $bod_id) {
            //condicionar que el id este dentro de los detalles
            if (trim($bod_id) != "" && trim($tip_entrada) != "" && in_array($bod_id, $bodega_bod)) {
                //aca
                $respuesta = array(
                    'moi_id_tip' => $tip_entrada,
                    'moi_id_bod' => $bod_id,
                    'moi_id_fac' => $fac_id,
                    //'moi_documento'=> $doc_referencia,
                    'moi_fecha_mov' => date('Y-m-d H:i:s'),
                    'moi_estado' => 1,
                    'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $respuesta);
                for ($x = 0; $x < count($producto_art); $x++) {
                    if (trim($producto_art[$x]) != "" && trim($cantidad_dee[$x]) != "") {
                        $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');

                                                $this->db->where_in('dee_id_moi', $array_mov);
                                                $this->db->join('sar_saldo_articulo', 'sar_id = dee_id_sar');
                            $registro_detalle = $this->gsatelite->get_tabla('dee_detalle_mov',array('dee_id_art'=>$producto_art[$x]));

                        if($bod_id == $bodega_bod[$x] ){
                            if ($costo_promedio == 1) {
                                $nuevo_precio =  $this->recalcular_precio_promedio($producto_art[$x], $bodega_bod[$x], $cantidad_dee[$x], $registro_detalle[0]['dee_precio']);
                            }

                            if (count($registro_detalle) > 0) {
                                $saldo_inven = array(
                                    'sar_id_art' => $producto_art[$x],
                                    'sar_id_bod' => $bodega_bod[$x],
                                    'sar_cant_actual' => $cantidad_dee[$x],
                                    'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $registro_detalle[0]['dee_precio'],
                                    'sar_fecha_caducidad' => null,
                                    'sar_id_sxb' => $registro_detalle[0]['sar_id_sxb'],
                                    'sar_estado' => 1,
                                    'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $sar_id = $this->gsatelite->ingresar('sar_saldo_articulo', $saldo_inven);

                                $detalle_inv = array(
                                    'dee_id_moi' => $moi_id,
                                    'dee_id_art' => $producto_art[$x],
                                    'dee_id_sar' => $sar_id,
                                    'dee_id_cva' => $medida_cva[$x],
                                    'dee_id_sxb' => $sector,
                                    'dee_cantidad' => $cantidad_dee[$x],
                                    'dee_fecha_caducidad' => $fecha,
                                    'dee_precio' => $registro_detalle[0]['dee_precio'],
                                    'dee_subtotal' => ($cantidad_dee[$x] * (($registro_detalle[0]['dee_precio'])? $registro_detalle[0]['dee_precio']:0)),
                                    'dee_estado' => 1,
                                    'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->ingresar('dee_detalle_mov', $detalle_inv);
                        }

                        }
                    }
                }
            }
        }
    }
 }
    /**
    *@return René Castaneda
    *@fecha 02/06/2018
    *@descripcion: Funcion para crear una orden de venta con la información de la factura.
    *@param Se envía el parámetro << flag >> para indicar el redireccionamiento, según pantalla de origen (cajero).
    */
     public function guardar_fact_ordVenta($flag=null)
     {
         if ($_POST) {

            //      COLUMNA 1 //dtg_documento_factura
            $dtg_orden_factura = "";
            if(trim($this->input->post('dtg_documento_factura')) != "")
                $dtg_orden_factura = trim($this->input->post('dtg_documento_factura'));


             $dtg_Norden            = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null;
             $dtg_cliente           = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null;
             $dtg_nombre_factura    = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
             $dtf_area              = (trim($this->input->post('dtf_area')) != "") ? $this->input->post('dtf_area') : null;
             $personal              = $this->input->post('personal');
             $vendedor = (trim($this->input->post('vendedor')) != "") ? $this->input->post('vendedor') : null;

             $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null; //15


             $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
             $descuentoT_factura_total = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
             $subtotal_factura_total = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
             $impuesto_factura_total = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
             $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;

             $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0; //20

             $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi'):0;

             $id_anticipo = 0;
             $saldo_restante = 0;
             $fin_anticipo = 0;
             $fin_anticipo_2 = 0;
             $monto_guardar = 0;
             $monto_actualizar = 0;

             $productos_id_moi = array();
             $produtos_cantidad_moi = array();
             $productos_medida_moi = array();

             $alerta = "";

             //print_r($_POST);die();exit();
             if ($dtg_Norden != "" && $dtg_cliente != "") {
                 if ($total_factura_total < 0) {
                    $total_factura_total = 0;
                 }
                 $ordenes = $this->gsatelite->get_tabla('orv_orden_venta');
                 $orden_n = (count($ordenes) + 1);

                 //PREGUNTAR SI PROVIENE DE UNA ORDEN DE VENTA
                 // SE DEBE ACTUALIZAR A ANULADA LA ORDEN DE VENTA DE ORIGEN PARA EVITAR DUPLICIDAD
                 // orden de venta
                 $slcOrdVnt = (trim($this->input->post('slcOrdVnt')) != "") ? $this->input->post('slcOrdVnt') : null;
                 if($slcOrdVnt > 0){
                     $orden_venta_array = array(
                         'orv_estado' => 3, //anulada
                         'orv_motivo_anulacion'=>"Anulada por replicación en orden número: $orden_n",
                         'orv_fecha_anulacion' => date('Y-m-d H:i:s'),
                         'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                         'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                     );
                     $this->gsatelite->actualizar_array("orv_orden_venta", $orden_venta_array, array("orv_id" => $slcOrdVnt));
                 }
                 ////////////////////////////////////////////////////////////////

                 $orden_array = array(
                     'orv_id_arf' => $dtf_area,
                     'orv_id_cli' => $dtg_cliente,
                     'orv_numero_orden' => $orden_n,
                     'orv_id_ven' =>  $vendedor,
                     'orv_fecha_orden' => date('Y-m-d H:i:s'),
                     'orv_nombre_factura' => $dtg_nombre_factura,
                     'orv_total_retencion' => $retencion_factura_total,
                     'orv_subtotal' => $subtotal_factura_total,
                     'orv_descuento' => $descuentoT_factura_total,
                     'orv_impuesto' => $impuesto_factura_total,
                     'orv_total' => $total_factura_total,
                     'orv_observacion' => $observaciones,
                     'orv_estado' => 1,
                     'orv_fecha_creacion' => date('Y-m-d H:i:s'),
                     'orv_usu_creacion' => $this->tank_auth->get_user_id(),
                     'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                     'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                 );
                 $orv_id = $this->gsatelite->ingresar('orv_orden_venta', $orden_array);

                 //Se guarda el personal de la factura
                 for ($x = 0; $x < count($personal); $x++) {
                     if (trim($personal[$x]) > 0) {
                         //tabla pxf_personalxfactura
                         $detalle_personal = array(
                             'pxo_id_orv' => $orv_id,
                             'pxo_id_emp' => $personal[$x],
                             'pxo_estado' => 1,
                             'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                             'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                             'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                             'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                         );
                         $this->gsatelite->ingresar('pxo_personalxorden_venta', $detalle_personal);
                     }
                 }

                 //columna codigo
                 $combo_agrupacion = $this->input->post('combo_agrupacion');
                 $aplica_descarga = $this->input->post('aplica_descarga'); //array
                 $fecha_garantia = $this->input->post('garantia_factura');
                 $fecha_text_garantia = $this->input->post('txtgarantia_factura');

                 $tip_producto = $this->input->post('tip_producto');



                 $productos_factura = $this->input->post('producto_factura'); //array
                 $correlativo = $this->input->post('producto_correlativo'); //array
                 $medida_factura = $this->input->post('medida_factura'); //array
                 $codigo_factura = $this->input->post('codigo_factura'); //array
                 //columna descripcion
                 $descripcion_factura = $this->input->post('descripcion_factura'); //array
                 //columna cantidad
                 $cantidad_factura = $this->input->post('cantidad_factura'); //array
                 //columna precio
                 $precio_factura = $this->input->post('precio_factura'); //array
                 //impuesto
                 $impuesto_factura = $this->input->post('impuesto_factura'); //array
                 $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                 $impuesto_array = $this->input->post('impuesto_array'); //array
                 $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                 //retencion
                 $retencion_factura = $this->input->post('retencion_factura'); //array
                 $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                 $retencion_array = $this->input->post('retencion_array'); //array
                 $retencion_por_array = $this->input->post('retencion_por_array'); //array
                 //descuento
                 $descuento_factura = $this->input->post('descuento_factura'); //array
                 $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                 //subtotal
                 $subtotal_factura = $this->input->post('subtotal_factura'); //array
                 //total
                 $total_factura = $this->input->post('total_factura'); //array

                 $tipo_venta = $this->input->post('tipo_venta'); //array
                 //datos de caracteristica
                 /*
                   Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                   se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                   el id del producto con el id de la caracteristica para guardar la relacion
                 */

                 $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                 $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                 $tipo = $this->input->post('tipo_caracteristica');
                 for ($x = 0; $x < count($productos_factura); $x++) {
                     if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                         //es el id de la caracteristica que cuenta el producto
                         $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                         $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                         $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;

                         if ($aplica_descarga[$x] == 1 && $tip_producto[$x] == 0) {

                             if($combo_agrupacion[$x] == 1){
                                 $combos_articulo_array = $this->input->post('combo_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                 $cantidad_temp_combo = $this->input->post('combo_cantidad_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                 $combos_cantidad_array = $cantidad_factura[$x]*$cantidad_temp_combo;
                                 $combos_medida_array = $this->input->post('combo_medida_'.$productos_factura[$x].'_'.$correlativo[$x]);

                                 for($k = 0; $k < count($combos_articulo_array); $k++){
                                     $productos_id_moi[] = $combos_articulo_array[$k];
                                     $produtos_cantidad_moi[] = $combos_cantidad_array[$k];
                                     $productos_medida_moi[] = $combos_medida_array[$k];
                                 }
                             } else{
                                 $productos_id_moi[] = $productos_factura[$x];
                                 $produtos_cantidad_moi[] = $cantidad_factura[$x];
                                 $productos_medida_moi[] = $medida_factura[$x];
                             }
                         }

                         $fecha_def = null;
                         if (trim($fecha_text_garantia[$x]) != '') {
                             $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                         }

                         $detalle_factura = array(
                             'dov_id_orv' => $orv_id,
                             'dov_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                             'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                             'dov_id_lip' => $idlip,
                             'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                             'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                             'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                             'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                             'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                             'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                             'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                             'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                             'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                             'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                             'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                             'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                             'dov_combo' => (trim($combo_agrupacion[$x]) != "") ? $combo_agrupacion[$x] : null,
                             'dov_estado' => 1,
                             'dov_usu_creacion' => $this->tank_auth->get_user_id(),
                             'dov_fecha_creacion' => date('Y-m-d H:i:s'),
                             'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                             'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                         );
                         $dov_id = $this->gsatelite->ingresar('dov_detalle_orden_venta', $detalle_factura);

                         //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                         $impuesto_ids = explode(",", $impuesto_array[$x]);
                         $impuesto_por = explode(",", $impuesto_por_array[$x]);
                         for ($k = 0; $k < count($impuesto_ids); $k++) {
                             if ($impuesto_ids[$k] != 0) {
                                 if (trim($impuesto_por[$k]) != "") {
                                     //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                     $monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                     //tabla ixf_impuestoxfactura
                                     $detalle_impuesto = array(
                                         'ixv_id_dov' => $dov_id,
                                         'ixv_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                         'ixv_monto' => $monto_temp,
                                         'ixv_porcentaje' => $impuesto_por[$k],
                                         'ixv_estado' => 1,
                                         'ixv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                         'ixv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                         'ixv_fecha_creacion' => date('Y-m-d H:i:s'),
                                         'ixv_usu_creacion' => $this->tank_auth->get_user_id()
                                     );
                                     $this->gsatelite->ingresar('ixv_impuestoxorden_venta', $detalle_impuesto);
                                 }
                             }
                         }

                         $retencion_ids = explode(",", $retencion_array[$x]);
                         $retencion_por = explode(",", $retencion_por_array[$x]);
                         for ($k = 0; $k < count($retencion_ids); $k++) {
                             if ($retencion_ids[$k] != 0) {
                                 if (trim($retencion_por[$k]) != "") {
                                     $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                     //tabla rxf_retencionxdetalle_factura
                                     $detalle_retencion = array(
                                         'rxv_id_dov' => $dov_id,
                                         'rxv_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                         'rxv_monto' => $monto_temp,
                                         'rxv_porcentaje' => $retencion_por[$k],
                                         'rxv_estado' => 1,
                                         'rxv_usu_creacion' => $this->tank_auth->get_user_id(),
                                         'rxv_fecha_creacion' => date('Y-m-d H:i:s'),
                                         'rxv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                         'rxv_fecha_modificacion' => date('Y-m-d H:i:s')
                                     );
                                     $this->gsatelite->ingresar('rxv_retencionxorden_venta', $detalle_retencion);
                                 }
                             }
                         }

 /* ====================================================================================================================
                                     COMPONENTES
 ======================================================================================================================*/
                         $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];

                         /* para descargar de bodega             type array*/
                         /*$descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                         $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                         $bodega_componente = $this->input->post('bodega_componente_id'.$identificador); // no es arreglo*/

                         /* detalle para guardar                 type array*/
                         $producto_componente = ($this->input->post('producto_componente'.$identificador) != '')?$this->input->post('producto_componente'.$identificador):'';
                         $medida_componente = $this->input->post('medida_componente'.$identificador);
                         $cantidad_componente = $this->input->post('cantidad_conv_componente'.$identificador);

                         $precio_componente = $this->input->post('precio_componente'.$identificador);
                         $subtotal_componente = $this->input->post('subtotal_componente'.$identificador);
                         $descripcion_componente = $this->input->post('descripcion_componente'.$identificador);

                         $alternar_componente = $this->input->post('alternar_componente'.$identificador);
                         $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);

                         $fecha_creacion = date('Y-m-d H:i:s');
                         $componente_sav = array();
                         if($producto_componente != ''){
                             foreach ($producto_componente as $id_comp => $comp) {
                                 /*if ($descargar_componente[$id_comp] == 1 && $tipo_componente[$id_comp] == 0) {
                                     $productos_id_moi[] = $comp;
                                     $produtos_cantidad_moi[] = $cantidad_componente[$id_comp];
                                     $productos_medida_moi[] = $medida_componente[$id_comp];
                                     $producto_bodega_moi[] = $bodega_componente;
                                 }*/

                                 $componente_sav[] = array(
                                     'cdv_id_dov' => $dov_id,
                                     'cdv_id_cva' => $medida_componente[$id_comp],
                                     'cdv_descripcion' => $descripcion_componente[$id_comp],
                                     'cdv_cantidad' => $cantidad_componente[$id_comp],
                                     'cdv_precio' => $precio_componente[$id_comp],
                                     'cdv_subtotal' => $subtotal_componente[$id_comp],
                                     'cdv_total' => $subtotal_componente[$id_comp],
                                     'cdv_altera_precio' => $alternar_componente[$id_comp],
                                     'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                     'cdv_estado' => 1,
                                     'cdv_usu_creacion' => $this->tank_auth->get_user_id(),
                                     'cdv_fecha_creacion' =>  $fecha_creacion,
                                     'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                     'cdv_fecha_modificacion' =>  $fecha_creacion
                                 );
                             }

                             $this->gsatelite->ingresar('cdv_componente_detallexorden_venta', $componente_sav, true);
                         }
 /* ====================================================================================================================
                                     FIN COMPONENTES
 ======================================================================================================================*/
                     }
                 }

                /* if (count($productos_id_moi) > 0) {
                     $this->crear_movimiento($orv_id, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi);
                 } */
                 $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Orden de venta", 'texto_alerta' => "El registro se guardó correctamente.");
             } else {
                 $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de Orden de venta", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
             }

             $redireccion = $this->input->post('redireccionar');
             $this->session->set_flashdata($alerta);
             $this->session->set_flashdata('n_orden_venta_factura', $orden_n);

            $redir = '/';
            if($flag!=null){
                $redir = '/0/1';
            }
             //redireccionar a la facturación de nuevo
             if ($redireccion == 0) {
                 redirect('facturacion/facturar/crear_factura'.$redir);
             } else if ($redireccion == 1) {
                if($flag!=null){
                    redirect('facturacion/facturar/factura_caja');
                }else{
                    redirect('facturacion/facturar/factura/');
                }
             }
         }
     }

    /**
     *@return Luis Navarro
     *@fecha 07/06/2018
     *@descripcion: Funcion para obtener la sucuesal  asociado al empleado
     */
     public function get_sucursal_empleado() {
        satelite_validar(true);
        if ($this->input->post()) {
            $cajero = $this->input->post("cajero");

            // obtener la sucursal asociada al empleado
            $this->db->join('users', 'emp_id_usu = id');
            $empleado = $this->gsatelite->get_tabla('emp_empleado', array('id'=>$cajero));
            $emp_sucursal = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id'=>$empleado[0]['emp_id_suc']));

            echo json_encode(array('sucursal'=>$emp_sucursal[0]['suc_nombre']));
        }
     }


    /**
     *@return Luis Navarro
     *@fecha 11/06/2018
     *@descripcion: Funcion para Generar correlativos
     *@return Obtener correlativos para corte o cierre de ticket
     */
    public function generar_correlativo_corte_cierre($caja = null) {

        if (is_numeric($caja) && $caja != null) {
            // Definicion
            $where = null;

            $ticket = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('TICKET'));
            // Filtrar
            $where['uxc_id_caj']    = $caja;
            $where['uxc_tipo']      = 1;
            $where['sef_id_tif']    = $ticket;

            // Verificar si la caja tiene asignada una serie para ticket
            $datos_caja = $this->facturacion_model->get_datos_usuarioxcaja($where, null, 'uxc_id DESC'); //
            // print_r($this->db->last_query());die();

            if (count($datos_caja)>0) {
                // Verificar que existen facturas
                // $facturas = (count($facturas)>0)?($datos_caja[0]['cxj_inicio']+$facturas):$datos_caja[0]['cxj_inicio'];
                // $facturas   = $this->gsatelite->count('fac_factura', array('fac_id_cof'=>$datos_caja[0]['cof_id'], 'fac_id_tif'=>$ticket));

                // Funcion para obtener el siguiente correlativo
                $siguiente_corr = $this->generar_numero_factura($datos_caja[0]['cxj_inicio'], $datos_caja[0]['cxj_fin'], $datos_caja[0]['cof_id'], $ticket, 0, true);
                $datos_correlativo = json_decode($siguiente_corr);
                // print_r(intval($datos_correlativo->resultado));die();
                if (intval($datos_correlativo->resultado) > 0) {
                    return array('correlativo'=>($datos_correlativo->resultado), 'cof_id'=>$datos_caja[0]['cof_id'], 'tif_id' => $ticket);
                } else {
                    // Ya no hay correlativos para asignar
                    return array('error'=>1);
                }
            } else {
                // No se posee una serie de ticket
                return array('error'=>0);
            }
        }
    }

    public function anular_orden_venta($id=0)
    {
        $id_orden = ($id > 0)? $id:$this->input->post('id_orden');
        $observacion = trim($this->input->post('observacion'));
        $exito = 0;
        if ($id_orden > 0) {
            $orden_venta_array = array(
                'orv_estado' => 3, //anulada
                'orv_motivo_anulacion'=>$observacion,
                'orv_fecha_anulacion' => date('Y-m-d H:i:s'),
                'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                'orv_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array("orv_orden_venta", $orden_venta_array, array("orv_id" => $id_orden));
           $exito = 1;
           $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Orden de venta anulada", 'texto_alerta' => "El registro se anuló correctamente.");
           $this->session->set_flashdata($alerta);

        }
        die(json_encode(array('exito'=>$exito)));
    }

     /**
     * Descripción:
     * Función de gestión de facturas
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-06-22
     * @param  Ninguno
     * @return Grid de facturas según cajero en sesión
     */
    public function factura_caja(){
        //satelite_validar();
        $user = $this->tank_auth->get_user_id();
        $this->factura(null, null, null, $user);
    }

    /**
     * Descripción:
     * Función para cargar las ordenes de ventas.
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-06-26
     * @param  ninguno
     * @return Dropdown de ordenes de venta.
     */

    public function get_orden_venta(){
        satelite_validar(true);
        $cli_id = $this->input->post('cli_id');
        $ven_id = $this->input->post('ven_id');
        if($ven_id > 0 && $ven_id != null){
            $this->db->where('orv_id_ven', $ven_id);
        }
        if($cli_id > 0 && $cli_id != null){
            $this->db->where('orv_id_cli', $cli_id);
        }
        //restringir a este año y el anterior por el volumen de datos (caso super rosario)
        $yrs = implode(',', array(date('Y'), (date('Y') - 1)));
        $orden_venta = $this->gsatelite->get_tabla("orv_orden_venta", array("orv_estado" => 1, "YEAR(orv_fecha_orden) IN ($yrs)" => NULL));
        $SlcOrdenVenta = '<option value=""></option>';
        foreach ($orden_venta as $key => $val) {
            $SlcOrdenVenta .= '<option value="'.$val['orv_id'].'" data-cliente="'.$val['orv_id_cli'].'">'.$val['orv_numero_orden'].' - '.$val['orv_nombre_factura'].'</option>';
        }
        $vendedor = ($ven_id > 0) ? $ven_id : $this->tank_auth->get_user_id();
        $supervisores_option = $this->facturacion_model->get_supervisores_descuento(array('ven_id' => $vendedor));
        $select_sup = '<option value=""></option>' . trim($supervisores_option);
        echo json_encode(array('ordenVenta' =>$SlcOrdenVenta, 'supervisores' => $select_sup));
    }

    /**
    * @author René Castaneda
    * @since 2018-06-26
    * @return Gestión de la anulación de ordenes de venta.
     */
    public function orden_venta_anular()
    {
        satelite_validar();
        //$permisos = $this->gsatelite->get_permisos_opcion();
        $this->orden_venta();
    }

    /**
    * @author René Castaneda
    * @since 2018-06-28
    * @return Filtrar los cortes z realizados
     */
    public function filtrar_corte_mensual($value='')
    {
        $id_caja = $this->input->post('id_caja');
        $txtFecha_inicio = formatear_fecha('Y-m-d',$this->input->post('txtFecha_inicio'));
        $txtFecha_hasta = formatear_fecha('Y-m-d',$this->input->post('txtFecha_hasta'));
        $where_filtro['ccm_id_caj'] = $id_caja;
        if (trim($txtFecha_inicio) != '' )
        {
            $where_filtro['ccm_fecha_desde >='] = formatear_fecha('Y-m-d',$txtFecha_inicio);
        }
        if (trim($txtFecha_hasta) != '' )
        {
            $where_filtro['ccm_fecha_desde <='] = formatear_fecha('Y-m-d',$txtFecha_hasta);
        }
                 $this->db->join('caj_caja', 'caj_id = ccm_id_caj');
        $query = $this->gsatelite->get_tabla('ccm_corte_caja_mensual',$where_filtro);
        $datos['es_reporte'] = 0;
        $datos['registros'] = $query;
        $html = $this->load->view('facturacion/facturar/filtrar_corte_mensual', $datos, true);
        die(json_encode(array('html' => $html)));

    }

    /**
    * @author René Castaneda
    * @since 2018-06-28
    * @return Verificar si el corte exite
     */
    public function verificar_existe_corte()
    {
        $id_caja = $this->input->post('id_caja');
        $txtFecha_inicio = formatear_fecha('Y-m-d',$this->input->post('txtFecha_inicio'));
        $txtFecha_hasta = formatear_fecha('Y-m-d',$this->input->post('txtFecha_hasta'));
        $where_existe['ccm_id_caj'] = $id_caja;
        $where_existe["(DATE('$txtFecha_inicio') BETWEEN DATE(ccm_fecha_desde) AND DATE(ccm_fecha_hasta) OR DATE('$txtFecha_hasta') BETWEEN DATE(ccm_fecha_desde) AND DATE(ccm_fecha_hasta))"] = null;
        $query_existe_corte = $this->gsatelite->get_tabla('ccm_corte_caja_mensual',$where_existe);
        $existe = (count($query_existe_corte) > 0)? 1:0;
        die(json_encode(array('existe'=>$existe)));

    }

    /**
    * @author René Castaneda
    * @since 2018-06-29
    * @return Verificar la contraseña del supervisor
     */
    public function autorizar_descuento_supervisor()
    {
        $usuario_sup = $this->input->post('usuario_sup');
        $pass_sup = $this->input->post('pass_sup');
        $exito = 0;
        if ($usuario_sup > 0 && $pass_sup != '')
        {
            $registro = $this->gsatelite->get_tabla('users',array('id'=>$usuario_sup));
            $verificar_clave = $this->tank_auth->verificar_clave($pass_sup, $registro[0]['password'], $registro[0]['username']); // verifica clave ingresada
            if ($verificar_clave) {
                $exito = 1;
            }
        }
        die(json_encode(array('exito' =>$exito)));
    }

    /**
    * @author René Castaneda
    * @since 2018-07-04
    * @return json - ajax validar que no se repita la apertura o el cierre en la misma fecha.
     */
    public function validar_repetir_cierre_apertura()
    {
        $id_caja = $this->input->post('id_caja');
        $fecha_proceso = $this->input->post('fecha_proceso');
        $tipo_proceso = $this->input->post('tipo_proceso');
        $existe = 0; //no existe correcte
        if ($id_caja > 0 && $fecha_proceso != '' && $tipo_proceso > 0 )
        {
            $fecha = formatear_fecha('Y-m-d', $fecha_proceso);
            $registro = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_tipo'=>$tipo_proceso, 'DATE(uxc_fecha_proceso)'=>$fecha, 'uxc_id_caj'=>$id_caja));
            if ($registro) {
                $existe = 1; //exsite corte
            }
        }
        die(json_encode(array('existe' =>$existe)));
    }

    /**
    * @author Luis Navarro
    * @since 2018-07-12
    * @return Gestión de devolucion de factura.
     */
    public function factura_devolucion() {
        satelite_validar();
        $this->factura(null, null, null, null);
    }

     /**
     * @author Edith Herrera
     * @since  2018-08-22
     * @return Grid de comprobantes de descuento.
    * */
    function comprobante_descuento() {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        if ($_POST) {
            $post_array = $_POST;

            $fecha_inicio   = $post_array['fecha_ini'];
            $fecha_fin      = $post_array['fecha_fin'];
            $estado         = $post_array['estado'];

            /*  Determinar si es vendedor o supervisor el usuario logueado  */
            $where          = null;
            $usuario        = $this->tank_auth->get_user_id();

            $info['id']     = $usuario;

            if ($fecha_inicio != '' && $fecha_fin != '') {
                $where['date_format(cmd_fecha, "%Y-%m-%d") >=']  = formatear_fecha('Y-m-d', $fecha_inicio);
                $where['date_format(cmd_fecha, "%Y-%m-%d") <=' ] = formatear_fecha('Y-m-d', $fecha_fin);
            }

            if($estado>0){
                $where['cmd_estado_comprobante'] = $estado;
            }
            $vendedores = $this->facturacion_model->get_vendedoresxsupervisor_comprobante($info, 'id', 'id');
            $where['cmd_id_ven IN ('.$vendedores[0]['vendedores'].')'] = null;

            // $this->db->join('cli_cliente', 'cmd_id_cli = cli_id');
            // $comprobantes = $this->gsatelite->get_tabla('cmd_comprobante_descuento', $where);
            $comprobantes = $this->facturacion_model->get_comprobante_descuentos($where, null, null);
            $data['detalles'] = $comprobantes;
            $html = $this->load->view('facturacion/facturar/detalle_comprobante', $data, true);
            echo $html;
        } else {

            // $where = null;
            // $where['date_format(cmd_fecha, "%Y-%m-%d") >='] = date('Y-m-d');
            // $where['date_format(cmd_fecha, "%Y-%m-%d") <=' ] = date('Y-m-d');

            // $this->db->join('cli_cliente', 'cmd_id_cli = cli_id');
            // $comprobantes = $this->gsatelite->get_tabla('cmd_comprobante_descuento', $where);
            // $comprobantes = $this->facturacion_model->get_comprobante_descuentos($where);
            // $data['detalles'] = $comprobantes;
            //$html = $this->load->view('facturacion/facturar/detalle_comprobante', $data, true);
            //$data['html'] = $html;

            $data['titulo_personal'] = "Comprobante de descuento";
            $this->_cargarvista($data);
        }
    }

    public function agregar_comprobante(){
        satelite_validar();
        if($this->input->post()){
            $post_array = $this->input->post();

            $last   = $this->facturacion_model->get_max_codigo('cmd_comprobante_descuento', 'cmd_numero_comprobante');
            $code   = $last->codigo;
            $cod    = (int)$code+1;
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);


            $monto      = $post_array['txtMonto'];
            $cliente    = $post_array['slcCliente'];
            $remitente  = $post_array['txtRemitente'];
            $destinatario = $post_array['txtDestinatario'];
            $fechaGen   = $post_array['txtFechaGen'];
            $fechaVen   = $post_array['txtFechaVen'];
            $descripcion= ($post_array['txtDescripcion']!='')? $post_array['txtDescripcion']:null;
            $slcVendedor= $post_array['slcVendedor'];

            $array_cmd = array(
                'cmd_id_cli'        => $cliente,
                'cmd_id_usu_genera' => $this->tank_auth->get_user_id(),
                'cmd_id_ven'        => $slcVendedor,
                'cmd_fecha'         => formatear_fecha('Y-m-d', $fechaGen),
                'cmd_monto'         => $monto,
                'cmd_saldo'         => $monto,
                'cmd_numero_comprobante'  => $codigo,
                'cmd_remitente'     => $remitente,
                'cmd_destinatario'  => $destinatario,
                'cmd_descripcion'   => $descripcion,
                'cmd_fecha_vencimiento'   => formatear_fecha('Y-m-d', $fechaVen),
                'cmd_estado_comprobante'  => 1,
                'cmd_estado'        => 1,
                'cmd_usu_creacion'  => $this->tank_auth->get_user_id(),
                'cmd_fecha_creacion'=> date('Y-m-d H:i:s'),
                'cmd_usu_modificacion'    => $this->tank_auth->get_user_id(),
                'cmd_fecha_modificacion'  => date('Y-m-d H:i:s'),
                );
            $reg = $this->gsatelite->ingresar('cmd_comprobante_descuento', $array_cmd);

            if($reg>0){
                $array_anl = array(
                    'anl_id_cli'    => $cliente,
                    'anl_fecha'     => formatear_fecha('Y-m-d', $fechaGen),
                    'anl_comprobante'       => $codigo,
                    'anl_fecha_vencimiento' => formatear_fecha('Y-m-d', $fechaVen),
                    'anl_descripcion'       => $descripcion,
                    'anl_monto'     => $monto,
                    'anl_saldo'     => $monto,
                    'anl_estado'    => 1,
                    'anl_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'anl_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'anl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'anl_fecha_modificacion'=> date('Y-m-d H:i:s')

                    );
                $reg_anl = $this->gsatelite->ingresar('anl_anticipo_cliente', $array_anl);
            }

            // Actualizar el registro de  comprobante con el anticipo
            if ($reg_anl>0) {
                $comprobante_array = array(
                    'cmd_id_anl'            => $reg_anl,
                    'cmd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'cmd_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array("cmd_comprobante_descuento", $comprobante_array, array("cmd_id" => $reg));
            }

            $redir = $post_array['redireccion'];
            if ($reg_anl > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('facturacion/facturar/comprobante_descuento');
            }else{
                redirect('facturacion/facturar/agregar_comprobante');
            }

        }else{
            $last=$this->facturacion_model->get_max_codigo('cmd_comprobante_descuento', 'cmd_numero_comprobante');
            $code=$last->codigo;
            $cod= (int)$code+1;
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
            $data['codigo']=$codigo;

           $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));

            $client = '<option value=""></option>';
            foreach ($clientes as $cli) {

                if ($cli['cli_codigo'] != '') {
                    $codigo = trim($cli['cli_codigo']) . ' - ';
                } else {
                    $codigo = '';
                }

                $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];

                $client .= '<option value="' . $cli['cli_id'] . '">' . $nombre_cliente . '</option>';
            }
            $data['cliente'] = $client;

            /*  Determinar si es vendedor o supervisor el usuario logueado  */
            $usuario = $this->tank_auth->get_user_id();
            $es_vendedor = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $usuario, 'ven_estado' => 1));
            $vendedores = $this->gsatelite->get_tabla('ven_vendedor', array('ven_estado' => 1));
            $es_supervisor = $this->gsatelite->get_tabla('sup_supervisor', array('sup_id_usu' => $usuario, 'sup_estado' => 1));
            $html = '<option value=""></option>';
            $disabled = '';
            $id_vendedor = '';
            // Verificar si el usuario logueado es Supervisor o Vendedor
            if (count($es_vendedor) > 0) {
                foreach ($es_vendedor as $key => $value) {
                    $id_vendedor = $value['ven_id'];
                    $html = '<option value="'.$value['ven_id'].'">'.$value['ven_codigo'].' - '.$value['ven_nombre'].' '.$value['ven_apellidos'].'</option>';
                }
                $disabled = 'disabled';
            } else if (count($es_supervisor) > 0) {
                $this->db->join('ven_vendedor', 'ven_id = vxs_id_ven', 'inner');
                $vxs = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_sup' => $es_supervisor[0]['sup_id'], 'ven_estado' => 1));
                foreach ($vxs as $key => $value) {
                    $html .= '<option value="'.$value['ven_id'].'">'.$value['ven_codigo'].' - '.$value['ven_nombre'].' '.$value['ven_apellidos'].'</option>';
                }
            } else {
                $data['no_ven_sup'] = 1;
            }

            $data['vendedores']   = $html;
            $data['id_vendedor']  = $id_vendedor;
            $data['ven_disabled'] = $disabled;
            /* ************************************************************* */

            $data['titulo_personal'] = "Agregar comprobante";
            $this->_cargarvista($data, null);
        }
    }

     function imprimir_comprobante($id_cmd = null) {
        satelite_validar();

        $comprobante = $this->input->post('chkComp');
        $this->load->library('EnLetras');

        $ids = array();
        if(!$id_cmd && is_array($comprobante)){
            $ids = $comprobante;
        }else{
            $ids[] = $id_cmd;
        }

        $this->db->where_in('cmd_id', $ids);
        $this->db->join('cli_cliente', 'cmd_id_cli = cli_id');
        $data['detalles'] = $detalles = $this->gsatelite->get_tabla('cmd_comprobante_descuento');

        $this->gsatelite->cargar_vista_masterpage("facturacion/facturar/imprimir_comprobante",$data,null);
    }

    function orden_entrega() {
        satelite_validar();
        $factura = $this->input->post('factura_entregar');
        $sucursal = $this->input->post('sucursal');
        $data['detalles'] = $this->facturacion_model->get_orden_entrega(array('fac_id' => $factura));
        $data['sucursal'] = $this->gsatelite->get_registro('suc_sucursal', array('suc_id' => $sucursal));
        $data['sectores'] = $this->gsatelite->get_parametro('SYS_USA_SECTORES', '0');
        $reporte = $this->load->view('facturacion/facturar/detalle_orden_entrega', $data, true);
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePdf($reporte, 'P', 'orden_entrega', 'Letter');
    }

    function duplicar_comprobante(){
        satelite_validar();
        $post_array = $this->input->post();

        $cmd_id         = $post_array['id_cmd'];
        $vencimiento    = formatear_fecha('Y-m-d', $post_array['fecha']);
        $cantidad       = $post_array['cantidad'];
        $destinatario   = ($post_array['destinatario']!='') ? $post_array['destinatario']:null;
        $descripcion    = ($post_array['descripcion']!='') ? $post_array['descripcion']:null;

        $reg_cmd        = $this->gsatelite->get_registro('cmd_comprobante_descuento', array('cmd_id'=>$cmd_id));

        // Determinar si el usuario que esta logueado es vendedor o supervisor
        $usuario = $this->tank_auth->get_user_id();
        $es_vendedor = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $usuario, 'ven_estado' => 1));
        $es_supervisor = $this->gsatelite->get_tabla('sup_supervisor', array('sup_id_usu' => $usuario, 'sup_estado' => 1));

        // Determinar si no es vendedor que muestre el una alerta de error
        if (!count($es_vendedor) > 0 ) {
            $this->gsatelite->show_dialog('El usuario logueado no es vendedor.', 'facturacion/facturar/comprobante_descuento', 'error', 'Error al Duplicar Comprobante');
            die();
        }

        $exito = 0;
        for ($i=1; $i <= $cantidad ; $i++) {
            $last   = $this->facturacion_model->get_max_codigo('cmd_comprobante_descuento', 'cmd_numero_comprobante');
            $code   = $last->codigo;
            $cod    = (int)$code+1;
            $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

            $array_cmd = array(
                'cmd_id_cli'                => $reg_cmd->cmd_id_cli,
                'cmd_id_usu_genera'         => $this->tank_auth->get_user_id(),
                'cmd_id_ven'                => $es_vendedor[0]['ven_id'],
                'cmd_fecha'                 => formatear_fecha('Y-m-d', $reg_cmd->cmd_fecha),
                'cmd_monto'                 => $reg_cmd->cmd_monto,
                'cmd_saldo'                 => $reg_cmd->cmd_monto,
                'cmd_numero_comprobante'    => $codigo,
                'cmd_remitente'             => $reg_cmd->cmd_remitente,
                'cmd_destinatario'          => $destinatario,
                'cmd_descripcion'           => $descripcion,
                'cmd_fecha_vencimiento'     => formatear_fecha('Y-m-d', $vencimiento),
                'cmd_estado_comprobante'    => 1,
                'cmd_estado'                => 1,
                'cmd_usu_creacion'          => $this->tank_auth->get_user_id(),
                'cmd_fecha_creacion'        => date('Y-m-d H:i:s'),
                'cmd_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'cmd_fecha_modificacion'    => date('Y-m-d H:i:s'),
                );
            $reg = $this->gsatelite->ingresar('cmd_comprobante_descuento', $array_cmd);

            if($reg>0){
                $array_anl = array(
                    'anl_id_cli'            => $reg_cmd->cmd_id_cli,
                    'anl_fecha'             => formatear_fecha('Y-m-d', $reg_cmd->cmd_fecha),
                    'anl_fecha_vencimiento' => formatear_fecha('Y-m-d', $vencimiento),
                    'anl_descripcion'       => $descripcion,
                    'anl_monto'             => $reg_cmd->cmd_monto,
                    'anl_saldo'             => $reg_cmd->cmd_monto,
                    'anl_estado'            => 1,
                    'anl_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'anl_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'anl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'anl_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $reg_anl = $this->gsatelite->ingresar('anl_anticipo_cliente', $array_anl);

                // Actualizar el registro de  comprobante con el anticipo
                $comprobante_array = array(
                    'cmd_id_anl'            => $reg_anl,
                    'cmd_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'cmd_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array("cmd_comprobante_descuento", $comprobante_array, array("cmd_id" => $reg));

                $exito++;
            }

        }

        if ($exito > 0) {
            $alerta = array(
                  'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "Se han duplicado <b>$exito</b> comprobantes de descuento con éxito."
            );
            $this->session->set_flashdata($alerta);
        }

        echo json_encode(array('exito' => $exito));
        die();
    }

    public function consulta_pago_factura() {
        satelite_validar();
        if ($this->input->post()) {
            $factura = $this->input->post("factura");
            $razon   = $this->input->post("razon");

            $this->db->join('fac_factura', 'fac_id = abf_id_fac');
            $this->db->join('abc_abono_cliente', 'abc_id = abf_id_abc');
            $abono_info = $this->gsatelite->get_tabla('abf_abono_factura', array('abf_id_fac' => $factura, 'abc_estado'=> 1));

            $factura = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $factura));

            if (count($abono_info) == 1 && $abono_info[0]['abf_monto'] == $factura[0]['fac_total']) {
                echo json_encode(array('abono_count' => count($abono_info)));
            } else {
                echo json_encode(array('error' => 1));
            }

            die();

        }
    }

    public function anular_pago_factura() {
        satelite_validar();
        if ($this->input->post()) {
            $factura = $this->input->post('factura');
            $razon = $this->input->post('razon');
            $this->load->library('../controllers/modulo_cuentas_cobrar/procesos');
            $result = $this->procesos->anular_pago_abono($factura, $razon);

            echo json_encode(array('exito' => $result));
            die();
        }
    }

    public function validar_tipo_factura_por_empleado($idcliente, $tipo){
        $tde_nit = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
        $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        $tiene_registro = $this->gsatelite->get_registro('cli_cliente', array('cli_id' => $idcliente));
        $tiene_nrc = $this->gsatelite->get_campo('tif_tipo_factura', 'tif_aplica_nrc', array('tif_id' => $tipo));
        $cnit = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_estado' => 1, 'dcc_id_cli' => $idcliente, 'dcc_id_tde' => $tde_nit));
        if($tiene_nrc > 0){
            if($tiene_registro->cli_registro != ''){
                if ($tipo_facturacion == 1) {
                    if ($tiene_registro->cli_id_gir > 0 && count($cnit) > 0) {
                        return 1;
                    } else {
                        return 0;
                    }
                } else {
                    return 1;
                }
            }else{
                if ($tiene_registro->cli_id_cli_asociado > 0 && $tiene_registro->cli_id_cli_asociado != $tiene_registro->cli_id) {
                    $asoc_registro = $this->gsatelite->get_registro('cli_cliente', array('cli_id' => $tiene_registro->cli_id_cli_asociado));
                    $anit = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_estado' => 1, 'dcc_id_cli' => $asoc_registro->cli_id, 'dcc_id_tde' => $tde_nit));
                    if ($asoc_registro->cli_registro != '') {
                        if ($tipo_facturacion == 1) {
                            if ($asoc_registro->cli_id_gir > 0 && count($anit) > 0) {
                                return 1;
                            } else {
                                return 0;
                            }
                        } else {
                            return 1;
                        }
                    } else {
                        return 0;
                    }
                } else {
                    return 0;
                }
            }
        }else{
            return 1;
        }
    }

     /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-11-14
     * @return Anular una comprobante
     */
    public function anular_comprobante($id = null) {
        if ($id != null) {

            $id = $this->input->post('idcomprobante');
            $comentario = $this->input->post('motivo');

            // Obtener los registros del comprobante
            $comprobante = $this->gsatelite->get_tabla('cmd_comprobante_descuento', array('cmd_id' => $id));

            $comprobante_actualizar = array(
                    'cmd_estado_comprobante' => 2,
                    'cmd_estado'             => 0,
                    'cmd_observacion_anulacion' => $comentario,
                    'cmd_id_usu_anula' => $this->tank_auth->get_user_id(),
                    'cmd_fecha_anulacion'=> date('Y-m-d H:i:s'),
                    'cmd_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'cmd_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $comprobante_id = $this->gsatelite->actualizar_array('cmd_comprobante_descuento', $comprobante_actualizar, array('cmd_id' => $id));

            if (count($comprobante)>0) {
                $anticipo_actualizar = array(
                    'anl_saldo'     => 0,
                    'anl_estado'    => 0,
                    'anl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'anl_fecha_modificacion'=> date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('anl_anticipo_cliente', $anticipo_actualizar, array('anl_id' => $comprobante[0]['cmd_id_anl']));
            }

            if ($comprobante_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Comprobante", 'texto_alerta' => "El registro se Anuló correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de Comprobante", 'texto_alerta' => "El registro no se Anuló correctamente.");
            }
            $this->session->set_flashdata($alerta);
            redirect('facturacion/facturar/comprobante_descuento');

        } else {
            $this->gsatelite->show_dialog('No hay un identificador para anular Comprobante', '', 'error', 'Anular Comprobante');
        }
    }

    /**
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-11-29
     * @return Actualiza los campos de domicilio en la factura
     */
    public function historial_domicilio($tipo = null){
        /***
            tipo = null: peticion desde ajax
            tipo != null: envio de post con los datos a almacenar*
        ***/
        if($tipo==null){
            $fac_id = $this->input->post('factura');
            $factura = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $fac_id));
            //Si la observacion es vacia entonces puede aditar el campo
            $disabled = ($factura[0]['fac_observacion_domicilio']!=null)?1:0;
            $data['factura'] = $factura;
            $data['fac_id'] = $fac_id;
            $data['disabled'] = $disabled;
            $vista = $this->load->view("facturacion/facturar/historial_domicilio",$data,true);

            ob_end_clean();
            echo json_encode(array('resultado'=>$vista));

        }else{
            $fac_id = $this->input->post('factura');
            $fecha = ($this->input->post('fac_fecha_dimicilio')!='')?date('Y-m-d H:i:s',strtotime($this->input->post('fac_fecha_dimicilio'))):date('Y-m-d H:i:s');
            $observacion = $this->input->post('fac_observacion_domicilio');
            $actualizar_factura = array(
                'fac_entregado_domicilio' => 1,
                'fac_fecha_domicilio' => $fecha,
                'fac_observacion_domicilio'   => $observacion
            );
            $this->gsatelite->actualizar_array('fac_factura', $actualizar_factura, array('fac_id'=>$fac_id));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización de factura", 'texto_alerta' => "Factura actualizada correctamente.");
            $this->session->set_flashdata($alerta);
            redirect('facturacion/facturar/factura');
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-11-30
     * @return Vista para actualizar el comprobante de descuento
    */
    public function editar_comprobante($comprobante = null){
        satelite_validar();
        $permisos            = $this->gsatelite->get_permisos_opcion('facturacion/facturar/comprobante_descuento');
        $this->gsatelite->verificar_registro_real('cmd_comprobante_descuento', $comprobante);
        $reg_comprobante     = $this->gsatelite->get_tabla('cmd_comprobante_descuento', array('cmd_id' => $comprobante));
        $reg_abono           = $this->gsatelite->get_tabla('anl_anticipo_cliente', array('anl_id' => $reg_comprobante[0]['cmd_id_anl']));
        $data['comprobante'] = $reg_comprobante[0];

        if($this->input->post()){
            //print_r($this->input->post());die();
            $post_array = $this->input->post();

            $monto          = $post_array['txtMonto'];
            $cliente        = $post_array['slcCliente'];
            $remitente      = $post_array['txtRemitente'];
            $destinatario   = $post_array['txtDestinatario'];
            $fechaGen       = $post_array['txtFechaGen'];
            $fechaVen       = $post_array['txtFechaVen'];
            $descripcion    = ($post_array['txtDescripcion']!='')? $post_array['txtDescripcion']:null;
            $slcVendedor    = $post_array['slcVendedor'];

            $array_cmd = array(
                //'cmd_id_cli'        => $cliente,
                //'cmd_id_ven'        => $slcVendedor,
                //'cmd_fecha'         => formatear_fecha('Y-m-d', $fechaGen),
                'cmd_monto'         => ($reg_comprobante[0]['cmd_saldo'] != $reg_abono[0]['anl_saldo']) ? $reg_comprobante[0]['cmd_monto'] : $monto,
                'cmd_saldo'         => ($reg_comprobante[0]['cmd_saldo'] != $reg_abono[0]['anl_saldo']) ? $reg_comprobante[0]['cmd_monto'] : $monto,
                'cmd_remitente'     => $remitente,
                'cmd_destinatario'  => $destinatario,
                'cmd_descripcion'   => $descripcion,
                'cmd_fecha_vencimiento'   => formatear_fecha('Y-m-d', $fechaVen),
                'cmd_estado_comprobante'  => 1,
                'cmd_estado'              => 1,
                'cmd_usu_modificacion'    => $this->tank_auth->get_user_id(),
                'cmd_fecha_modificacion'  => date('Y-m-d H:i:s'),
                );
            $this->gsatelite->actualizar_array('cmd_comprobante_descuento', $array_cmd, array('cmd_id' => $comprobante));

            if($comprobante>0 && $reg_comprobante[0]['cmd_saldo'] === $reg_abono[0]['anl_saldo']){
                $array_anl = array(
                    'anl_fecha_vencimiento' => formatear_fecha('Y-m-d', $fechaVen),
                    'anl_descripcion'       => $descripcion,
                    'anl_monto'             => $monto,
                    'anl_saldo'             => $monto,
                    'anl_estado'            => 1,
                    'anl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'anl_fecha_modificacion'=> date('Y-m-d H:i:s')

                    );
                $reg_anl = $this->gsatelite->actualizar_array('anl_anticipo_cliente', $array_anl, array('anl_id' => $reg_comprobante[0]['cmd_id_anl']));
            }

            $redir = $post_array['redireccion'];
            if ($reg_anl > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la informacion ingresada.");
            }
            $this->session->set_flashdata($alerta);

            if($redir>0){
                redirect('facturacion/facturar/comprobante_descuento');
            }else{
                redirect('facturacion/facturar/editar_comprobante/' . $comprobante);
            }

        } else {

           $data['codigo']  = $reg_comprobante[0]['cmd_numero_comprobante'];

           $clientes        = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));

           $client = '<option value=""></option>';
           foreach ($clientes as $cli) {

                $codigo = ($cli['cli_codigo'] != '') ? trim($cli['cli_codigo']) . ' - ' : '';

                $selected = ($reg_comprobante[0]['cmd_id_cli'] == $cli['cli_id']) ? 'selected' : '';

                $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];

                $client .= '<option value="' . $cli['cli_id'] . '" '.$selected.'>' . $nombre_cliente . '</option>';
            }
            $data['cliente'] = $client;

            /*  Determinar si es vendedor o supervisor el usuario logueado  */
            $usuario        = $this->tank_auth->get_user_id();
            $es_vendedor    = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $usuario, 'ven_estado' => 1));
            $vendedores     = $this->gsatelite->get_tabla('ven_vendedor', array('ven_estado' => 1));
            $es_supervisor  = $this->gsatelite->get_tabla('sup_supervisor', array('sup_id_usu' => $usuario, 'sup_estado' => 1));
            $html           = '<option value=""></option>';
            $disabled       = '';
            $id_vendedor    = '';
            // Verificar si el usuario logueado es Supervisor o Vendedor
            if (count($es_vendedor) > 0) {
                foreach ($es_vendedor as $key => $value) {
                    $id_vendedor = $value['ven_id'];
                    $html = '<option value="'.$value['ven_id'].'">'.$value['ven_codigo'].' - '.$value['ven_nombre'].' '.$value['ven_apellidos'].'</option>';
                }
                $disabled = 'disabled';
            } else if (count($es_supervisor) > 0) {
                $this->db->join('ven_vendedor', 'ven_id = vxs_id_ven', 'inner');
                $vxs = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_sup' => $es_supervisor[0]['sup_id'], 'ven_estado' => 1));
                foreach ($vxs as $key => $value) {
                    $html .= '<option value="'.$value['ven_id'].'">'.$value['ven_codigo'].' - '.$value['ven_nombre'].' '.$value['ven_apellidos'].'</option>';
                }
            } else {
                $data['no_ven_sup'] = 1;
            }

            // Permitir o no editar el monto del comprobante
            $data['monto_comprobante'] = ($reg_comprobante[0]['cmd_saldo'] != $reg_abono[0]['anl_saldo']) ? 'disabled' : '';

            $data['vendedores']   = $html;
            $data['id_vendedor']  = $id_vendedor;
            $data['ven_disabled'] = $disabled;
            /* ************************************************************* */

            $data['titulo_personal'] = "Editar comprobante";
            $this->_cargarvista($data, null);
        }
    }

    //rené castaneda (centralizacion de funciones para procesar facturas en forma masiva.)
    public function generar_partida_masiva_facturacion($id_directo=null)
    {
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');

        //omitir las anuladas y las de devolución.
        //$query_facturas = $this->gsatelite->get_tabla("fac_factura",array('fac_estado in (1,2) AND fac_id_pct is NULL AND fac_id_origen_devolucion is NULL'=>null));
        if ($id_directo>0)
            $query_facturas = $this->gsatelite->get_tabla("fac_factura",array('fac_id'=>$id_directo));
        else
            $query_facturas = $this->gsatelite->get_tabla("fac_factura",array('fac_estado in (1,2) AND fac_id_pct is NULL AND fac_id_origen_devolucion is NULL'=>null));

        $array_resultados = array();
        foreach ($query_facturas as $fila_fac) {

                $fac_id = $fila_fac["fac_id"];
                $dtf_factura = $fila_fac["fac_numero"];
                $dtf_fecha_conta = $fila_fac["fac_fecha_cont"];

                $where['fac_id'] = $fac_id;
                $info['num_fac'] = $dtf_factura;
                $info['fac_fecha_conta'] = $dtf_fecha_conta;
                $res_debe = $this->generar_partida_factura_afecta_noafecta_inv_debe($where,$info);
                $this->generar_partida_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_haber']);
                //Insertando los detalles
                if(count($res_debe['array_detalle_partida']) > 0){
                      $this->gsatelite->ingresar('dpc_detalle_partida', $res_debe['array_detalle_partida'], true);
                }
                $array_resultados[] = array("id_fac"=>$fac_id, "id_pct"=>$res_debe['id_pct']);

                //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida
                //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                $this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct' => $res_debe['id_pct'], 'fac_generacion_partida' => 1),array('fac_id' => $fac_id));

                /* ======== Contrapartida en caso de tener productos que afecten inventario ======== */
                $where_existe['fac_id'] = $fac_id;
                $where_existe['art_inventario'] = 1;
                //$afecta_inv = $this->facturacion_model->existe_prod_afec_inv($where_existe);
                //print_r($afecta_inv); die();

                // if($afecta_inv[0]['afecta_inv']){
                //     $where['cec_id']  = ($dtf_centro_costo) ? $dtf_centro_costo : 0;
                //     $res_debe = $this->generar_contra_partida_factura_afecta_afecta_inv_debe($where,$info);
                //     $this->generar_contra_partida_factura_afecta_inv_haber($where, $res_debe['id_pct']);
                // }
        }
        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();
    }
    //rené castaneda (centralizacion de funciones para procesar facturas anuladas en forma masiva.)
    public function generar_partida_masiva_facturacion_anulada()
    {
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');

        //obtener las facturas anuladas y omitir la anuladas.
        $query_facturas = $this->gsatelite->get_tabla("fac_factura",array('fac_estado = 0 AND fac_id_pct_anulacion is NULL AND fac_id_origen_devolucion is NULL'=>null));
        //print_r($query_facturas); die();
        $array_resultados = array();

        $array_resultados = array();
        foreach ($query_facturas as $fila_fac)
        {
            $where['fac_id'] = $fila_fac['fac_id'];
            $info['num_fac'] = $fila_fac['fac_numero'];
           $info_pct = $this->generar_partida_anulacion_facturacion_contabilidad($where, $info,false,true);
            $array_resultados[] = array("id_fac"=>$fila_fac['fac_id'], "id_pct"=>$info_pct['id_pct']);
        }

        echo json_encode(array('cantidad_partidas' => count($array_resultados)));
        die();

    }
    /**
     * Facturacion::_cargarvista()
     *
     * @param integer $data
     * @param integer $crud
     * @return void
     */
    function _cargarvista($data = 0, $crud = 0, $ruta_vista = ""){
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = (trim($ruta_vista) != '' and substr_count(trim($ruta_vista), '/') > 1 ) ? trim($ruta_vista) : $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
    *@author Nelson Soriano
    *@since  28-01-2019
    *@param  None
    *@return Anticipos disponibles
    *Descripcion: Devuelve los anicipos disponibles segun el cliente y producto
    **/

    public function mostrar_anticiposx(){
        satelite_validar();
        $cliente   = $this->input->post('id_cliente');
        $producto  = $this->input->post('id_producto');
        $result    = $this->facturacion_model->anticipos_obtener($cliente,$producto);
        $d         = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $decimales = ($d == '')?$decimales = 2:$decimales = $d;
        $modal     = $this->input->post('row');
        $cor       = 0;
        if ($result) {
           foreach ($result as $key => $valores) {
               echo ' <tr class="registros_'.$modal.'">
                        <td style="text-align:center">'.$valores["factura"].'</td>
                        <td style="text-align:center">$'.number_format($valores["fac_monto_anticipo"],$decimales).'

                        <input type="hidden" class="monto_anticipo_'.$cor.'_'.$modal.'" value="'.number_format($valores["fac_monto_anticipo"],$decimales).'">
                        </td>

                        <td style="text-align:center"><span class="pendiente_'.$cor.'_'.$modal.'">$'.number_format($valores["fac_monto_saldo_anticipo"],$decimales).'</span>

                            <input type="hidden" data-decimales="'.$decimales.'" class="pendiente monto_pendiente_'.$cor.'_'.$modal.'" data-inicial="'.number_format($valores["fac_monto_saldo_anticipo"],$decimales).'" value="'.number_format($valores["fac_monto_saldo_anticipo"],$decimales).'">
                        </td>

                        <td style="text-align: center;">';
                        echo'
                        <input id_factura="'.$valores['fac_id'].'" data-option=\'{"id_factura":"'.$valores['fac_id'].'"}\' type="text" modal="'.$modal.'" decimales="'.$decimales.'" readonly="true" name="montoAplicar[]" class="numerico aplicarx montoAplicar_'.$cor.'_'.$modal.'" correlativo="'.$cor.'" id="montoAplicar_'.$cor.'_'.$modal.'" style="width:80px;text-align:center" value="" class="numerico text"/>

                        </td>
                        <td style="text-align: center;">

                        <input modal="'.$modal.'" decimales="'.$decimales.'" type="checkbox" class="form-check-input habilitar inputs_'.$modal.'" id="'.$cor.'">

                        </td>
                    </tr>';
                    $cor++;
           }
        }else{
            echo '
                <tr>
                    <td colspan="5" style="text-align:center;font-weight:bold">No se encontraron registros</td>
                    </tr>
            ';
        }

    }

    /**
    * @author Habby Lovo
    * @since 2018-02-23
    * @return
    */
    public function obtener_costos_edit($producto, $correlativo, $dov_id, $cliente, $tipo, $subtotal){
        $data_grid['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        //carga la grid de componentes
        $html = '';
        //if($correlativo != null && $correlativo >= 0){
        if($correlativo > -1){
            $data_grid['ident'] = "_".$producto."_".$correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['editar'] = 1;
            $data_grid['duplicar'] = 1;
            $data_grid['tipo'] = $tipo;

            $data_grid['subtotal'] = $subtotal;
            $data_grid['costo'] = null; // datos de costos

            $producto_det = $this->gsatelite->get_tabla('art_articulo', array('art_id'=>$producto));
            $categoria = $producto_det[0]['art_id_tia'];

            $paiscli = $this->gsatelite->get_campo('cli_cliente', 'cli_id_pai', array('cli_id' => $cliente));
            $id_pais_defecto = $this->tank_auth->get_all_empresa();
            $id_pais_defecto = $id_pais_defecto->emr_id_pai;
            if(!($id_pais_defecto > 0)){
                $id_pais_defecto = 7;
            }
            //Tipo de cuenta por defecto
            $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
            $data_grid['costo_reg'] = $this->facturacion_model->get_centro_costo(array(
                                        'dta_id_tia'=>$categoria,
                                        'tcn_id'=>$tcn_id,
                                        'IFNULL(dta_id_pai, '.$id_pais_defecto.') = '.(($paiscli != null)?$paiscli:0) => null
                                    ));
            if($tipo == 2){
                $data_grid['costo_grid'] = $this->facturacion_model->get_centro_costo_detalle_dov(array('dcv_id_dov'=>$dov_id));
            } else{
                $data_grid['costo_grid'] = array();
            }
            $html = $this->load->view('facturacion/facturar/grid_centro_costo', $data_grid, true);
        }
        return array('html'=>$html);
    }

    /**
    * @author Nelson Soriano
    * @since  2019-02-23
    * @return reporte nota de envio
    * @param  id orden de venta
    * Descripcion: Formato de nota de envio
    */
    public function imprimir_nota_envio($reporte = null){
        satelite_validar();
        $id_orv = $this->input->post('id_nota');
        if ($reporte) {
            $id = $this->input->post('orv_id_print');
            $fecha = $this->input->post('fecha_entrega');
            $hora  = $this->input->post('hora_entrega');
            $direc = $this->input->post('direccion_entrega');
            $bodega = $this->input->post('select_bodega');
            $conta  = ($this->input->post('contactos_clientex') != '') ? $this->input->post('contactos_clientex') : $this->input->post('contrato_entrega');
            $asunto = $this->input->post('asunto_envio');
            $ob     = $this->input->post('observacion_entrega');
            if ($this->input->post('contrato_entrega') != '') {
                $array_conta = array(
                    'con_id_cli'    => $cliente,
                    'con_nombre'    => $conta,
                    'con_estado'    => 1,
                    'con_usu_mod'   => $this->tank_auth->get_user_id(),
                    'con_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('con_contacto',$array_conta);
            }
            $arreglo    = array(
                'orv_fecha_envio'       => ($fecha != "") ? formatear_fecha('Y-m-d', $fecha) : null,
                'orv_hora_envio'        => ($hora != "") ? formatear_fecha('H:i', $hora) : null,
                'orv_direccion_entrega' => $direc,
                'orv_observacion_envio' => $ob,
                'orv_usu_envio'         => $this->tank_auth->get_user_id(),
                'orv_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'orv_asunto_envio'      => ($asunto != "") ? $asunto : null,
                'orv_fecha_modificacion' => date('Y-m-d H:i:s'),
            );
            $this->gsatelite->actualizar_array('orv_orden_venta',$arreglo,array('orv_id'=>$id));
            $info_x = $this->gsatelite->get_tabla('orv_orden_venta',array('orv_id'=>$id));
            $cliente = $info_x[0]['orv_id_cli'];
            $data['info']   = $info_x;
            $data['contax'] = $conta;
            $data['bodega'] = $bodega;
            $data['titulo'] = 'Nota de envío';
            $data['det_nota']  = $this->facturacion_model->detalle_nota_envio($id);
            $data['cliente']   = $this->gsatelite->get_tabla('cli_cliente',array('cli_id'=>$cliente));
            $data['telefonos'] = $this->gsatelite->get_tabla('txc_telefonoxcliente',array('txc_id_cli'=>$cliente,'txc_estado'=>1));
            $html = $this->load->view('facturacion/facturar/imprimir_nota_envio', $data, true);
            $this->pdf->setPrintHeader(false);
            $this->pdf->SetFont('pdfahelvetica');
            $this->pdf->setCellPaddings(1,3);
            $this->pdf->SetAutoPageBreak(true, 0);
            $this->pdf->SetMargins(22,15);
            $this->pdf->AddPage('p', 'Letter', array('family' => 'pdfahelvetica', 'style' => '', 'size' => 2) , true);
            $this->pdf->setPrintFooter(false);
            $this->pdf->writeHTML($html, true, false, false, false, '');
            $this->pdf->boletaPDF('I');
            die();
        } else {
            $data['id_orv'] = $id_orv;
            $datos = $this->gsatelite->get_tabla('orv_orden_venta',array('orv_id'=>$id_orv));
            $cliente     = $datos[0]['orv_id_cli'];
            $suc_cli = $this->gsatelite->get_tabla('scl_sucursal_cliente',array('scl_estado'=> 1,'scl_id_cli'=>$cliente));
            $contactos_client  = $this->gsatelite->get_tabla('con_contacto',array('con_id_cli'=>$cliente,'con_estado'=>1));
            $data['fecha_envio'] = ($datos[0]['orv_fecha_envio'] != "") ? formatear_fecha('d-m-Y', $datos[0]['orv_fecha_envio']) : "";
            $data['hora_envio'] = ($datos[0]['orv_hora_envio'] != "") ? formatear_fecha('H:i', $datos[0]['orv_hora_envio']) : '';
            $data['direccion'] = ($datos[0]['orv_direccion_entrega'] != "")? $datos[0]['orv_direccion_entrega'] : '';
            $data['asunto_env'] = ($datos[0]['orv_asunto_envio'] != "") ? $datos[0]['orv_asunto_envio'] : '';
            $data['observac'] = ($datos[0]['orv_observacion_envio'] != "") ? $datos[0]['orv_observacion_envio'] : '';
            if ((is_array($suc_cli)) && (count($suc_cli) > 0)) {
                $data['mostrar_select'] = true;
                $data['opc'] = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_nombre} - {scl_direccion}', '', array('scl_estado'=>1,'scl_id_cli'=> $cliente),null,null,null,true);
            } else {
                $data['mostrar_select'] = false;
            }
            $bodega = $this->inventario_model->usuarioxbodega();
            $select_bodega = "";
            foreach ($bodega as $key => $bdg) {
                $select_bodega .= '<option value="'.$bdg['bod_id'].'">'.$bdg['bod_nombre'].'</option>';
            }
            $data['select_bodega'] = $select_bodega;
            $contactos_clientex = "";
            foreach ($contactos_client as $key => $conta) {
                $contactos_clientex .= '<option  value="'.$conta['con_nombre'].' '.$conta['con_apellidos'].'::::'.$conta['con_telefono'].'">'.$conta['con_nombre'].' '.$conta['con_apellidos'].'::::'.$conta['con_telefono'].'</option>';
            }
            $data['select_contacts'] = $contactos_clientex;
            $html = $this->load->view('facturacion/facturar/modal_nota_envio', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }
    }

    /**
     * @author Elman Ortiz - Grupo Satélite
     * @since  2019-03-04
     * @return Eliminar detalle de abonos de cliente y factura
     */
    public function eliminar_abf_abc($password = null){
        //$this->actualizar_array_in('fac_id', array('fac_subtotal' => 10.50), array('fac_id' => 1));
        //Caja 1
        if ($password) {
            if ($password == 'n12b5p30ateliteZ') {

                $caja1 = array();
                $uxc_caja1 = array();

                $caja1_dia1 = array('50','68','95','98','114','116','118','120','123','137','162','172','182','184','186','188','196','199','213','102','103','107','108');
                $uxc_caja1_dia1 = array('11');
                $caja1_dia2 = array('253','277','294','298','302','307','310','313','315','321','328','332','337','344','351','378','397');
                $uxc_caja1_dia2 = array('24');
                $caja1_dia3 = array('429','479','600');
                $uxc_caja1_dia3 = array('38');
                $caja1_dia4 = array();
                $uxc_caja1_dia4 = array('47');
                $caja1_dia5 = array('975','1005','1057');
                $uxc_caja1_dia5 = array('63');
                $caja1_dia6 = array('1168','1179','1199','1201');
                $uxc_caja1_dia6 = array('103','105');



                array_push($caja1, $caja1_dia1);
                array_push($caja1, $caja1_dia2);
                array_push($caja1, $caja1_dia3);
                array_push($caja1, $caja1_dia4);
                array_push($caja1, $caja1_dia5);
                array_push($caja1, $caja1_dia6);

                array_push($uxc_caja1, $uxc_caja1_dia1);
                array_push($uxc_caja1, $uxc_caja1_dia2);
                array_push($uxc_caja1, $uxc_caja1_dia3);
                array_push($uxc_caja1, $uxc_caja1_dia4);
                array_push($uxc_caja1, $uxc_caja1_dia5);
                array_push($uxc_caja1, $uxc_caja1_dia6);


                //Caja 2
                $caja2 = array();
                $uxc_caja2 = array();

                $caja2_dia1 = array('3','5','21','25','31','47','55','62','302','65','68','76','90','96','104','107','111','118','122','125','128','130','133','143','148','150','156','158','161','177','182','187','194','197','8','9','13','14','16','17','51','52','167','168');
                $uxc_caja2_dia1 = array('16');
                $caja2_dia2 = array('207','215','219','222','225','228','231','236','240','242','244','246','250','252','255','257','259','262','264','270','303','312','326','335','339','343','345','362','403','211','212');
                $uxc_caja2_dia2 = array('29');
                $caja2_dia3 = array('449','454','462','465','467','480','483','486','491','510','513','525','527','529','534','536','542','545','549','562','567','573','576','578','582','586','589','591','593','596','599','607','609','613','616','623','627','649','654','451','452');
                $uxc_caja2_dia3 = array('39','41');
                $caja2_dia4 = array('679','685','687','689','691','704','708','710','712','716','720','722','727','740','742','745','670','671','749','751','754','758','762','765','767','774','780','786','788','794','797','800','808','814','817','830','836','838','810','811','843','847','851','853','855','862','864','867','869','871','873','884','888');
                $uxc_caja2_dia4 = array('53','59','61');
                $caja2_dia5 = array();
                $uxc_caja2_dia5 = array('112');
                $caja2_dia6 = array('896','901','904','915','929','934','937','947','949','967','971','975','978','1004','1006','1010','1017','1025','1039','1044','1055','1060','1063','910','911','1029','1030');
                $uxc_caja2_dia6 = array('115');

                array_push($caja2, $caja2_dia1);
                array_push($caja2, $caja2_dia2);
                array_push($caja2, $caja2_dia3);
                array_push($caja2, $caja2_dia4);
                array_push($caja2, $caja2_dia5);
                array_push($caja2, $caja2_dia6);

                array_push($uxc_caja2, $uxc_caja2_dia1);
                array_push($uxc_caja2, $uxc_caja2_dia2);
                array_push($uxc_caja2, $uxc_caja2_dia3);
                array_push($uxc_caja2, $uxc_caja2_dia4);
                array_push($uxc_caja2, $uxc_caja2_dia5);
                array_push($uxc_caja2, $uxc_caja2_dia6);

                //Caja 3
                $caja3 = array();
                $uxc_caja3 = array();

                $caja3_dia1 = array('32','55','106','174');
                $uxc_caja3_dia1 = array('15');
                $caja3_dia2 = array('261','273','352','354');
                $uxc_caja3_dia2 = array('28');
                $caja3_dia3 = array('449','451','456');
                $uxc_caja3_dia3 = array('42');
                $caja3_dia4 = array('502','570');
                $uxc_caja3_dia4 = array('55');
                $caja3_dia5 = array();
                $uxc_caja3_dia5 = array('77');
                $caja3_dia6 = array('901','992');
                $uxc_caja3_dia6 = array('109');

                array_push($caja3, $caja3_dia1);
                array_push($caja3, $caja3_dia2);
                array_push($caja3, $caja3_dia3);
                array_push($caja3, $caja3_dia4);
                array_push($caja3, $caja3_dia5);
                array_push($caja3, $caja3_dia6);

                array_push($uxc_caja3, $uxc_caja3_dia1);
                array_push($uxc_caja3, $uxc_caja3_dia2);
                array_push($uxc_caja3, $uxc_caja3_dia3);
                array_push($uxc_caja3, $uxc_caja3_dia4);
                array_push($uxc_caja3, $uxc_caja3_dia5);
                array_push($uxc_caja3, $uxc_caja3_dia6);

                //Caja 4
                $caja4 = array();
                $uxc_caja4 = array();

                $caja4_dia1 = array('42','45','203');
                $uxc_caja4_dia1 = array('12');
                $caja4_dia2 = array('283','296','308','336','338','340','394','398','412','455','459','462','467','471','475','479','464','465');
                $uxc_caja4_dia2 = array('26');
                $caja4_dia3 = array('512','526','532','540','551','554','565','568','585','610','622','624','626','628','637','668','670','677','687','735','755','598','599','616','617');
                $uxc_caja4_dia3 = array('37');
                $caja4_dia4 = array('906');
                $uxc_caja4_dia4 = array('49');
                $caja4_dia5 = array('1056');
                $uxc_caja4_dia5 = array('78');
                $caja4_dia6 = array('1160','1163','1207','1226','1234','1235');
                $uxc_caja4_dia6 = array('107','116');

                array_push($caja4, $caja4_dia1);
                array_push($caja4, $caja4_dia2);
                array_push($caja4, $caja4_dia3);
                array_push($caja4, $caja4_dia4);
                array_push($caja4, $caja4_dia5);
                array_push($caja4, $caja4_dia6);

                array_push($uxc_caja4, $uxc_caja4_dia1);
                array_push($uxc_caja4, $uxc_caja4_dia2);
                array_push($uxc_caja4, $uxc_caja4_dia3);
                array_push($uxc_caja4, $uxc_caja4_dia4);
                array_push($uxc_caja4, $uxc_caja4_dia5);
                array_push($uxc_caja4, $uxc_caja4_dia6);

                //Caja 5
                $caja5 = array();
                $uxc_caja5 = array();

                $caja5_dia1 = array();
                $uxc_caja5_dia1 = array('14');
                $caja5_dia2 = array();
                $uxc_caja5_dia2 = array('43');
                $caja5_dia3 = array('214','277');
                $uxc_caja5_dia3 = array('45');
                $caja5_dia4 = array();
                $uxc_caja5_dia4 = array('64');
                $caja5_dia5 = array();
                $uxc_caja5_dia5 = array('67','100');
                $caja5_dia6 = array('542','545','547','553','559');
                $uxc_caja5_dia6 = array('117');

                array_push($caja5, $caja5_dia1);
                array_push($caja5, $caja5_dia2);
                array_push($caja5, $caja5_dia3);
                array_push($caja5, $caja5_dia4);
                array_push($caja5, $caja5_dia5);
                array_push($caja5, $caja5_dia6);

                array_push($uxc_caja5, $uxc_caja5_dia1);
                array_push($uxc_caja5, $uxc_caja5_dia2);
                array_push($uxc_caja5, $uxc_caja5_dia3);
                array_push($uxc_caja5, $uxc_caja5_dia4);
                array_push($uxc_caja5, $uxc_caja5_dia5);
                array_push($uxc_caja5, $uxc_caja5_dia6);

                //Caja 6
                $caja6 = array();
                $uxc_caja6 = array();

                $caja6_dia1 = array('144','153','170','172','175','184');
                $uxc_caja6_dia1 = array('13');
                $caja6_dia2 = array('206','213','280','311','317','342','355','362','364','366','398');
                $uxc_caja6_dia2 = array('21');
                $caja6_dia3 = array('416','438','445','478','489','504');
                $uxc_caja6_dia3 = array('36');
                $caja6_dia4 = array('701','810','817');
                $uxc_caja6_dia4 = array('57');
                $caja6_dia5 = array();
                $uxc_caja6_dia5 = array('76');
                $caja6_dia6 = array('1195');
                $uxc_caja6_dia6 = array('111');

                array_push($caja6, $caja6_dia1);
                array_push($caja6, $caja6_dia2);
                array_push($caja6, $caja6_dia3);
                array_push($caja6, $caja6_dia4);
                array_push($caja6, $caja6_dia5);
                array_push($caja6, $caja6_dia6);

                array_push($uxc_caja6, $uxc_caja6_dia1);
                array_push($uxc_caja6, $uxc_caja6_dia2);
                array_push($uxc_caja6, $uxc_caja6_dia3);
                array_push($uxc_caja6, $uxc_caja6_dia4);
                array_push($uxc_caja6, $uxc_caja6_dia5);
                array_push($uxc_caja6, $uxc_caja6_dia6);

                //Array para actualizar datos de la factura
                $factura_update = array('fac_estado' => 0,
                                        'fac_total_retencion' => 0,
                                        'fac_subtotal' => 0,
                                        'fac_descuento' => 0,
                                        'fac_impuesto' => 0,
                                        'fac_impuesto' => 0,
                                        'fac_total' => 0,
                                        'fac_monto_pendiente' => 0,
                                        'fac_monto_abono' => 0,
                                        'fac_fecha_mod' => date('Y-m-d 00:00:00'),
                                        'fac_usu_mod' => 1
                                        );


                //Realizar la eliminacion de los datos
                //Caja 1
                foreach ($caja1 as $key1 => $ca1) {
                    $caja1_abc_abf = $this->facturacion_model->get_abf_abc($ca1,$uxc_caja1[$key1]);

                    //Actualizando los valores de las facturas
                    $this->actualizar_array_in('fac_factura', $factura_update, $ca1, $uxc_caja1[$key1]);
                            //actualizar_array_in($tabla, $cadena, $uxc_array, $num_fac_array)
                    //Borrando los abf
                    foreach ($caja1_abc_abf as $key => $abf) {
                        $this->gsatelite->borrado_general('abf_abono_factura', array('abf_id' => $abf['abf_id']));
                    }

                    //Borrando los abc
                    foreach ($caja1_abc_abf as $key => $abc) {
                        $this->gsatelite->borrado_general('abc_abono_cliente', array('abc_id' => $abc['abc_id']));
                    }

                    /*****Borrado de partidas contables*****/
                    //Borrando detalles de partidas contables
                    foreach ($caja1_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $pct['pct_id']));
                    }

                    //Actualizar el fac_id_pct
                    foreach ($caja1_abc_abf as $key => $fac) {
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => null), array('fac_id' => $fac['fac_id']));
                    }

                    //Borrado de partida contable
                    foreach ($caja1_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $pct['pct_id']));
                    }

                }

                //Caja 2
                foreach ($caja2 as $key2 => $ca2) {
                    $caja2_abc_abf = $this->facturacion_model->get_abf_abc($ca2,$uxc_caja2[$key2]);

                    //Actualizando los valores de las facturas
                    $this->actualizar_array_in('fac_factura', $factura_update, $ca2, $uxc_caja2[$key2]);

                    //Borrando los abf
                    foreach ($caja2_abc_abf as $key => $abf) {
                        $this->gsatelite->borrado_general('abf_abono_factura', array('abf_id' => $abf['abf_id']));
                    }

                    //Borrando los abc
                    foreach ($caja2_abc_abf as $key => $abc) {
                        $this->gsatelite->borrado_general('abc_abono_cliente', array('abc_id' => $abc['abc_id']));
                    }

                    /*****Borrado de partidas contables*****/
                    //Borrando detalles de partidas contables
                    foreach ($caja2_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $pct['pct_id']));
                    }

                    //Actualizar el fac_id_pct
                    foreach ($caja2_abc_abf as $key => $fac) {
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => null), array('fac_id' => $fac['fac_id']));
                    }

                    //Borrado de partida contable
                    foreach ($caja2_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $pct['pct_id']));
                    }

                }

                //Caja 3
                foreach ($caja3 as $key3 => $ca3) {
                    $caja3_abc_abf = $this->facturacion_model->get_abf_abc($ca3,$uxc_caja3[$key3]);

                    //Actualizando los valores de las facturas
                    $this->actualizar_array_in('fac_factura', $factura_update, $ca3, $uxc_caja3[$key3]);

                    //Borrando los abf
                    foreach ($caja3_abc_abf as $key => $abf) {
                        $this->gsatelite->borrado_general('abf_abono_factura', array('abf_id' => $abf['abf_id']));
                    }

                    //Borrando los abc
                    foreach ($caja3_abc_abf as $key => $abc) {
                        $this->gsatelite->borrado_general('abc_abono_cliente', array('abc_id' => $abc['abc_id']));
                    }

                    /*****Borrado de partidas contables*****/
                    //Borrando detalles de partidas contables
                    foreach ($caja3_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $pct['pct_id']));
                    }

                    //Actualizar el fac_id_pct
                    foreach ($caja3_abc_abf as $key => $fac) {
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => null), array('fac_id' => $fac['fac_id']));
                    }

                    //Borrado de partida contable
                    foreach ($caja3_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $pct['pct_id']));
                    }

                }

                //Caja 4
                foreach ($caja4 as $key4 => $ca4) {
                    $caja4_abc_abf = $this->facturacion_model->get_abf_abc($ca4,$uxc_caja4[$key4]);

                    //Actualizando los valores de las facturas
                    $this->actualizar_array_in('fac_factura', $factura_update, $ca4, $uxc_caja4[$key4]);

                    //Borrando los abf
                    foreach ($caja4_abc_abf as $key => $abf) {
                        $this->gsatelite->borrado_general('abf_abono_factura', array('abf_id' => $abf['abf_id']));
                    }

                    //Borrando los abc
                    foreach ($caja4_abc_abf as $key => $abc) {
                        $this->gsatelite->borrado_general('abc_abono_cliente', array('abc_id' => $abc['abc_id']));
                    }

                    /*****Borrado de partidas contables*****/
                    //Borrando detalles de partidas contables
                    foreach ($caja4_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $pct['pct_id']));
                    }

                    //Actualizar el fac_id_pct
                    foreach ($caja4_abc_abf as $key => $fac) {
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => null), array('fac_id' => $fac['fac_id']));
                    }

                    //Borrado de partida contable
                    foreach ($caja4_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $pct['pct_id']));
                    }

                }

                //Caja 5
                foreach ($caja5 as $key5 => $ca5) {
                    $caja5_abc_abf = $this->facturacion_model->get_abf_abc($ca5,$uxc_caja5[$key5]);

                    //Actualizando los valores de las facturas
                    $this->actualizar_array_in('fac_factura', $factura_update, $ca5, $uxc_caja5[$key5]);

                    //Borrando los abf
                    foreach ($caja5_abc_abf as $key => $abf) {
                        $this->gsatelite->borrado_general('abf_abono_factura', array('abf_id' => $abf['abf_id']));
                    }

                    //Borrando los abc
                    foreach ($caja5_abc_abf as $key => $abc) {
                        $this->gsatelite->borrado_general('abc_abono_cliente', array('abc_id' => $abc['abc_id']));
                    }

                    /*****Borrado de partidas contables*****/
                    //Borrando detalles de partidas contables
                    foreach ($caja5_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $pct['pct_id']));
                    }

                    //Actualizar el fac_id_pct
                    foreach ($caja5_abc_abf as $key => $fac) {
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => null), array('fac_id' => $fac['fac_id']));
                    }

                    //Borrado de partida contable
                    foreach ($caja5_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $pct['pct_id']));
                    }

                }

                //Caja 6
                foreach ($caja6 as $key6 => $ca6) {
                    $caja6_abc_abf = $this->facturacion_model->get_abf_abc($ca6,$uxc_caja6[$key6]);

                    //Actualizando los valores de las facturas
                    $this->actualizar_array_in('fac_factura', $factura_update, $ca6, $uxc_caja6[$key6]);

                    //Borrando los abf
                    foreach ($caja6_abc_abf as $key => $abf) {
                        $this->gsatelite->borrado_general('abf_abono_factura', array('abf_id' => $abf['abf_id']));
                    }

                    //Borrando los abc
                    foreach ($caja6_abc_abf as $key => $abc) {
                        $this->gsatelite->borrado_general('abc_abono_cliente', array('abc_id' => $abc['abc_id']));
                    }

                    /*****Borrado de partidas contables*****/
                    //Borrando detalles de partidas contables
                    foreach ($caja6_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('dpc_detalle_partida', array('dpc_id_pct' => $pct['pct_id']));
                    }

                    //Actualizar el fac_id_pct
                    foreach ($caja6_abc_abf as $key => $fac) {
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_id_pct' => null), array('fac_id' => $fac['fac_id']));
                    }

                    //Borrado de partida contable
                    foreach ($caja6_abc_abf as $key => $pct) {
                        $this->gsatelite->borrado_general('pct_partida_contable', array('pct_id' => $pct['pct_id']));
                    }

                }

                echo "*****PROCESO TERMINADO******";
                die();
            }else{
                echo "*****URL INCORRECTA (PROCESO NO PUDO SER EJECUTADO)******";
            }
        }else{
            echo "*****EL PROCESO NO PUDO EJECUTARSE******";
        }
    }

    public function actualizar_array_in($tabla, $cadena, $num_fac_array, $uxc_array) {
        if(count($uxc_array)>0 && count($num_fac_array)>0){
            $this->db->where_in('fac_id_uxc', $uxc_array);
            $this->db->where_in('fac_numero', $num_fac_array);
            $this->db->update($tabla, $cadena);
        }

        return 1;
    }

    /*****************************************************************************/

    /**
     * @author Elman Ortiz - Grupo Satélite
     * @since  2019-03-04
     * @return Lista para la nota de credito
     */
    function nota_credito($fecha_inicio = null, $fecha_fin = null, $tipo = null, $usu=null) {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '9999');
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $roles_usuario = $this->facturacion_model->get_roles_usuario($this->tank_auth->get_user_id());
            // $id_rol_caja = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $rol_admit = 0;
            foreach ($roles_usuario as $key => $value) {
                if($value == 1){
                    $rol_admit = 1;
                }
            }
            // Declaracion de variables
            $es_devolucion = 0;
            if ($tipo){
                $url_padre =  $_SERVER['HTTP_REFERER'];
            } else {
                $url_padre = uri_string();
            }
            if(substr_count($url_padre, 'factura_caja')>0 ){
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura_caja');
            } elseif (substr_count($url_padre, 'lista_nota_credido') > 0 ) {
                // Proceso para devolucion de factura
                $es_devolucion = 1;
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/lista_nota_credido');
            }  else {
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura');
            }
            if($usu!=null) {
                $data['usu'] = $usu;
                $flag='/1';
            } else {
                $flag='/0';
            }

            //Mejora para el ajax, de fecha no requerida
            if($fecha_inicio == 'null' && $fecha_fin == 'null'){
                $fecha_inicio = null;
                $fecha_fin = null;
            }
            if ($fecha_inicio == null && $fecha_fin == null) {
                //die('mmmccc');
                $fecha_inicio = $this->input->post('txtFechaIni');
                $fecha_fin = $this->input->post('txtFechaFin');
            }
            // var_dump($this->input->post());
            $id_facturas = array(-1);
            $tipo_factura = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'),true);
            foreach ($tipo_factura as $key => $value) {
                if ($key == 'CREDITO FISCAL' || $key == 'NOTA CREDITO') {
                    array_push($id_facturas, $value);
                };
            }
            $tipoFactura = ( $this->input->post('tipo_fac') != "" ) ? $this->input->post('tipo_fac') : null;
            $output = null;
            $cliente = $this->input->post('pag_cliente');
            $crud = new grocery_CRUD();
            if($this->input->post()){
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $crud->where('DATE(fac_fecha_fact) >=', date('Y-m-d', strtotime($fecha_inicio)));
                    $crud->where('DATE(fac_fecha_fact) <=', date('Y-m-d H:i:s', strtotime($fecha_fin)));
                    //validar que si es la opción de fatura-caja solo muestre las del usuario logueado, si es la de facturar muestre todo.
                    if(/*$rol_admit != 1*/ substr_count($_SERVER['HTTP_REFERER'], 'factura_caja') > 0 ){
                        $crud->where('fac_usu_crea', $this->tank_auth->get_user_id());
                    }
                }
                if ($cliente > 0) {
                    $crud->where("fac_id_cli", $cliente);
                }
                if ($tipoFactura != null) {
                    $crud->where('fac_id_tif =', $tipoFactura);
                } else {
                    $ids = implode(',', $id_facturas);
                    $crud->where("fac_id_tif IN ($ids)");
                }
                if($usu!=null){
                    $usuarios = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id_usu'=>$usu));
                    $ids = array_column($usuarios, 'uxc_id');
                    $cadena = implode(',', $ids);

                    if(count($ids)>0){
                        $crud->where('fac_id_uxc IN ('.$cadena.')', null, FALSE);
                    }
                }
                // Verificar que no tiene devolucion
                if ($es_devolucion > 0) {
                    // $crud->where('![fac_id_origen_devolucion] > 0 AND [fac_fecha_devolucion] == NULL', null, FALSE);
                }
            }else{
                $crud->where("fac_id_cli", 0);
            }
            $display_as = array(
                'fac_numero'        => 'Número',
                'fac_id_cli'        => 'Cliente',
                'pcl_codigo'        => 'Proyecto',
                'fac_observacion'   => 'Observación',
                'fac_fecha_fact'    => 'Fecha',
                'fac_total'         => 'Total',
                'fac_estado'        => 'Estado',
                'fac_id_tif'        => 'Tipo Documento'
            );
            $columns = array(
                'fac_id_tif',
                'fac_numero',
                'fac_id_cli',
                'pcl_codigo',
                'fac_observacion',
                'fac_fecha_fact',
                'fac_total',
                'fac_estado'
            );

            $crud->set_subject('Documentos');
            $crud->set_table('fac_factura');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->set_relation('fac_id_tif', 'tif_tipo_factura', 'tif_nombre');
            $crud->callback_column('pcl_codigo', function($value, $row) {
                $proyecto = $this->gsatelite->get_campo('pcl_proyecto_cliente', 'pcl_codigo', array('pcl_id' => $row->fac_id_pcl));
                return $proyecto;
            });
            $crud->field_type('fac_estado', 'dropdown', array('2' => 'Pagado', '1' => 'Pendiente', '0' => 'Anulada'));
            $crud->callback_column('fac_id_cli', function($value, $row) {
                $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $row->fac_id_cli));
                $regresar = '';
                if ($clientes[0]['cli_personeria'] == 1) {
                    $regresar = $clientes[0]['cli_codigo'] .' '. $clientes[0]['cli_nombre'] . ' ' . $clientes[0]['cli_apellido'];
                } else {
                    $regresar = $clientes[0]['cli_codigo'] .' '. $clientes[0]['cli_apellido'];
                }
                return $regresar;
            });
            $crud->callback_column('fac_fecha_fact', function($value, $row) {
                $fecha = (trim($row->fac_fecha_fact) != "") ? formatear_fecha('Y-m-d', trim($row->fac_fecha_fact)) : "";
                return $fecha;
            });
            $crud->callback_column('fac_total', function($value, $row) {
                $total = '$' . number_format($row->fac_total-$row->fac_total_retencion, 2);
                return $total;
            });
            //proceso para cambiar color de tr cuando la facturacion aplica domicilio
            $crud->callback_column('fac_numero',function($value, $row){
                $domicilio = $row->fac_aplica_domicilio;
                $entregado_domicilio = $row->fac_entregado_domicilio;
                if($domicilio > 0 && $entregado_domicilio == 0){
                    return "<label class='color_tr' data-color='#4ac718'>".$value."</label>";
                } else return $value;
            });

            $crud->unset_add();
            $crud->unset_edit();
            $crud->unset_delete();
            $crud->unset_read();
            $tifnc = $this->gsatelite->get_parametro('SYS_TIPO_FACTURAS', null, null, array('NOTA CREDITO'));
            $tifnc = ($tifnc != "") ? $tifnc : 0;
            // Proceder a solo mostrar la opcion de devolucion en la pantalla de factura cuando viene de la vista devolucon_factura
            if ($es_devolucion > 0) {
                $crud->add_action('&nbsp;&nbsp;Procesar Nota C.', '', 'facturacion/facturar/duplicar_nota_credito'.$flag.'/0', 'icomoon-icon-copy-2', null,'', "(([fac_estado] == 'Pendiente' AND ([fac_monto_pendiente] - [fac_total_retencion]) > 0) OR [fac_estado] == 'Pagado') AND [fac_id_tif] != $tifnc");
                $crud->add_action('&nbsp;&nbsp;Anular', '', 'facturacion/facturar/anular_nota_credito', 'icomoon-icon-copy-2 anulacion', null,'', "[fac_id_origen_devolucion] > 0 AND [fac_estado] == 'Pagado'");
            } else {
                // Opciones por defecto para las pantalla de factura y factura_caja
                $crud->add_action('&nbsp;&nbsp;Garantia', '', 'facturacion/facturar/generar_garantia', 'icomoon-icon-checkbox-2 duplicar_garantia');
                $crud->add_action('&nbsp;&nbsp;Pago', '', 'facturacion/facturar/pagar_factura', 'icomoon-icon-coins', null,'', "[fac_estado] == 'Pendiente'");
                $crud->add_action('&nbsp;&nbsp;Historial', '', 'historial', 'icomoon-icon-history mostrar_historial');
                $crud->add_action('&nbsp;&nbsp;Duplicar', '', 'facturacion/facturar/duplicar_factura'.$flag, 'icomoon-icon-copy-2', null,'', "![fac_id_origen_devolucion] > 0");
                $crud->add_action('&nbsp;&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_factura', 'icomoon-icon-copy-2 imprimir');
                $crud->add_action('&nbsp;&nbsp;Editar', '', 'facturacion/facturar/editar_factura', 'icomoon-icon-copy-2 editar', null,'', "[fac_estado] == 'Pendiente' or ![fac_estado] == 'Pagado'");
                $crud->add_action('&nbsp;&nbsp;Domicilio', '', 'facturacion/facturar/historial_domicilio', 'icomoon-icon-checkmark  fac_domicilio', null,'', "[fac_aplica_domicilio] == 1");
            }

            $crud->add_action('&nbsp;&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_factura', 'acciones icomoon-icon-copy-2 imprimir crud-action');            
            $crud->order_by('fac_id', 'asc');
            $output = $crud->render();

            $data['es_devolucion'] = $es_devolucion;
            $data['user'] = $usu;
            $data['add_factura'] = (isset($es_devolucion) && $es_devolucion > 0 ) ? 0 : $permisos["permite_agregar"];
            $data['titulo_personal'] = (isset($es_devolucion) && $es_devolucion > 0) ? 'Notas de Crédito' :"Facturación";
            
            $data['tipo_factura'] = $id_facturas;

            if ($tipo == null) {
                cargarvista($data, $output, 'facturacion/facturar/nota_credito');
            } else {
                print($output->output);
            }
        }
    }

    /**
    * @author Elman Ortiz
    * @since 2019-03-19
    * @return Gestión de devolucion de factura.
     */
    public function lista_nota_credido() {
        satelite_validar();
        $this->nota_credito(null, null, null, null);
    }

    /**
    * @author Elman Ortiz
    * @since 2018-07-12
    * @return Gestión de devolucion de factura.
     */
    function duplicar_nota_credito($flag=0, $fac_id = 0,  $id_fac = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // si el parametro $fac_id trae cero y el $id_fac es mayor a cero se trata de una devoución. 28052018 //added by René Castaneda
            $fac_id = ($fac_id == 0 && $id_fac > 0) ? $id_fac : $fac_id;
            $datos['es_devolucion'] = 1;//antes era 0
            $datos['afecto_fac_inventario_dev'] = 0;
            if ($id_fac > 0) {
                //$datos['es_devolucion'] = 1;
                $mov_fac = $this->facturacion_model->get_detalle_movimiento_devolucion($fac_id);
                if (count($mov_fac)) {
                    $datos['afecto_fac_inventario_dev'] = 1;
                }
                $fac_padre = (Array)$this->gsatelite->get_registro('fac_factura', array('fac_id' => $id_fac));
                $existe_otra = 0;/// $this->gsatelite->count('fac_factura', array("fac_estado > " => 0, "fac_id_fac_credito" => $fac_padre["fac_id"]));
                if(false && !(($fac_padre['fac_monto_pendiente'] - $fac_padre['fac_total_retencion']) > 0)) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nota de crédito", 'texto_alerta' => "No se puede aplicar el documento.");
                    $this->session->set_flashdata($alerta);
                    redirect('facturacion/facturar/lista_nota_credido');
                }
                if ($existe_otra > 0) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Nota de crédito", 'texto_alerta' => "Solo se puede aplicar una vez por cada documento.");
                    $this->session->set_flashdata($alerta);
                    redirect('facturacion/facturar/lista_nota_credido');
                }
            }
            $datos["titulo_personal"] = "Nota de credito";
            /* PEDIR UNICAMENTE LOS OPTIONS PARA LLENAR LOS SELECTS */
            $factura_datos = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $fac_id));
            $datos["datos_factura_origen"] = $factura_datos[0];
            /* ========================================= PARAMETROS ========================================================== */
            $datos["cantidad_decimales"] = $this->gsatelite->get_parametro('NUMERO_DECIMALES','2');
            $datos["show_option"] = $this->gsatelite->get_parametro('SYS_ELEMENTOS_MOSTRAR_FACTURA','1,1,1,1');
            $datos["cliente_defecto"] = $factura_datos[0]['fac_id_cli'];
            $datos['permite_mas_productos'] = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO',0);
            $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $datos['cajas']  = $this->facturacion_model->datos_usuario_caja($rol);
            /* ========================================= CLIENTES ========================================================== */
            // Obtener el primer documento de cliente
            $docs_cliente       = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $factura_datos[0]['fac_id_cli']));
            $datos['documento']  = (count($docs_cliente)>0)?$docs_cliente[0]['dcc_valor']:'';
            $client          = '';
            $cliente_nom_fac = '';
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
            foreach ($clientes as $cli) {
                if ($cli['cli_codigo'] != '') {
                    $codigo = trim($cli['cli_codigo']) . ' - ';
                } else {
                    $codigo = '';
                }
                // Verificar cliente de la fuctura
                $selected_cli = '';
                if (trim($factura_datos[0]['fac_id_cli']) == $cli['cli_id']) {
                    $selected_cli            = 'selected';
                    $cliente_nom_fac = ($cli['cli_personeria'] == 1) ? $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $cli['cli_apellido'];
                }
                // Obtener el nombre del cliente
                $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                // Obtener todo los clientes junto al seleccionado
                $client .= '<option value="' . $cli['cli_id'] . '" '.$selected_cli.'>' . $nombre_cliente . '</option>';
            }
            $datos['cliente_nom_fac'] = $cliente_nom_fac;
            // Obtener el tipo de factura de nota de credito para la devolucion, sino coloca la que se ha seleccionado por defecto
            $nota_credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('NOTA_CREDITO'));
            $tif_factura  = ($datos['es_devolucion'] == 1 && $nota_credito > 0)? $nota_credito : $factura_datos[0]['fac_id_tif'];
            $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $incluidas  = $parametros['NOTA CREDITO'];
            if ($incluidas != '') {
                $tipos_factura = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1,'tif_aplica_venta' =>1, "tif_id IN ($incluidas)" => NULL), $tif_factura, '', 'tif_id', true);
            } else {
                $tipos_factura = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => '1','tif_aplica_venta' =>1, 'tif_aplica_nota_credito' => '1'), $tif_factura, '', 'tif_id', true);
            }
            $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $factura_datos[0]['fac_id_tpg'], '', 'tpg_id', true);
            $formas_pago = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => '1'), $factura_datos[0]['fac_id_frp'], '', 'frp_id', true);
            $select_retencion = "";
            $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            foreach ($retencion_campos as $key) {
                if ($key["ret_defecto"] == 1) {
                    $select_retencion .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select_retencion .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
            $datos["retencion"] = $select_retencion;

            $select = "";
            $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));
            foreach ($impuesto_campos as $key) {
                if ($key["imp_defecto"] == 1) {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                }
            }
            $datos["impuestos"] = $select;
            $datos["tipo_facturacion"] = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);

            //personal para duplicar
            $personal_registros = $this->gsatelite->get_tabla('pxf_personalxfactura', array('pxf_id_fac' => $fac_id));
            $array_emp = array_column($personal_registros, 'pxf_id_emp');
            $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $array_emp, '', 'emp_id', true);
            $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $factura_datos[0]['fac_id_arf'], '', 'arf_id', true);
            $costo_drop = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => '1'), $factura_datos[0]['fac_id_cec'], '', 'cec_id', true);
            /* ===================================== DATOS DE LA FACTURA A DUPLICAR ============================================== */
            $datos['factura_reg'] = $factura_datos;
            $datos['factura_id'] = $fac_id;
            $datos['factura_dup'] = 1;
            $datos['orv_id'] = '';
            $datos['clientes'] = $client;
            $datos['nombre_factura'] = $factura_datos[0]['fac_nombre_factura'];
            $datos['documento_factura'] = $factura_datos[0]['fac_documento_cliente'];
            $datos["tipos_factura"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_factura);
            $datos["tipos_pago"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_pago);
            $datos["formas_pago"] = str_replace('<option value="0">Seleccione</option>', '', $formas_pago);
            $datos["retencion"] = $select_retencion;
            $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_select);
            $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
            $datos["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $costo_drop);
            $datos["categorias"] = $this->obtener_categoriaxbodega2();
            $datos['observacion_factura'] = $factura_datos[0]['fac_observacion'];
            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $factura_datos[0]['fac_id_ven'], '', 'ven_id', true);
            $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores);
            $id_cli = $this->input->post('id');
            $sucursal_cli = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_codigo} - {scl_nombre}', '', array('scl_estado'=>1, 'scl_id_cli'=>$factura_datos[0]['fac_id_cli']), null, '', 'scl_id', true);
            $sucursal_cli = str_replace('<option value="0">Seleccione</option>', '', $sucursal_cli);
            $sucursal_cli = str_replace('<option value="0">Sin Registros</option>', '', $sucursal_cli);
            $datos['sucursal_cli'] = $sucursal_cli;

            $this->db->select('ret_id,ret_valor_minimo,ret_porcentaje');
            $data_ret = $this->gsatelite->get_tabla('ret_retencion',array('ret_estado'=>1,'ret_valor_minimo >'=>0));
            $datos["retencionesAuto"] = json_encode($data_ret);
            $producto_maximo = array();
            $configuraciones_factura = $this->gsatelite->get_tabla('frf_formato_factura', array('frf_activo'=>1));
            foreach ($configuraciones_factura as $key => $conf_fac) {
                $formato_array = json_decode($configuraciones_factura[$key]['frf_configuraciones_formato'], true);
                if(isset($formato_array["PRODUCTO_MAXIMO"])){
                    $key = key($formato_array["PRODUCTO_MAXIMO"]);
                    $producto_maximo[$key] = $formato_array["PRODUCTO_MAXIMO"][$key];
                }
            }
            if (!(empty($producto_maximo))) {
                $datos["producto_maximo"] = json_encode($producto_maximo);
            }
            if($flag>0){
                cargarvista($datos, null, 'facturacion/facturar/lista_nota_credido');
            }else{
                cargarvista($datos, null, 'facturacion/facturar/crear_nota_credito');
            }

        }
    }//duplicar_nota_credito

    /**
    * @author Elmer Hernández
    * @since 2019-11-08
    * @descripcion Función para anular nota de crédito.
     */
    function anular_nota_credito($id_fac = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
            //Queda pendiente verifica proceso de las partidas contables Al 11-11-2019
            $nota_cred = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $id_fac));
            if ($tipo_fact_elect == 1) {
                if (trim($nota_cred[0]["fac_sello_recepcion"]) != "") {
                    $date1 = new DateTime();
                    $sello = explode(" | ", $nota_cred[0]['fac_observaciones_factura_electronica']);
                    $fecha_sello = str_replace('/', '-', end($sello)); 
                    if ($fecha_sello) {
                        $date2 = new DateTime($fecha_sello);
                    } else {
                        $date2 = new DateTime($nota_cred[0]['fac_fecha_fact']);
                    }
                    $diferencia = date_diff($date1, $date2);
                    if ($diferencia->days > 1) {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fuera del Plazo Permitido", 'texto_alerta' => "No se puede realizar por estar fuera del plazo permitido para este tipo de documento.");
                        $this->session->set_flashdata($alerta);
                        redirect('facturacion/facturar/lista_nota_credido');
                        die();
                    }
                }
            }

            $fac_padre = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $nota_cred[0]['fac_id_fac_credito']));
            $exist_moi = $this->gsatelite->get_tabla('moi_movimiento_inv', array('moi_id_fac' => $id_fac));
            if (count($exist_moi) > 0) {
                $anulacion = $this->revertir_moi_devolucion($exist_moi[0]['moi_id']);
                if ($anulacion < 1) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Revertir Movimiento Inventario", 'texto_alerta' => "Parámetro requerido");
                    $this->session->set_flashdata($alerta);
                    redirect('facturacion/facturar/lista_nota_credido');
                    die();
                }
            }
            $this->gsatelite->actualizar('orv_orden_venta', array('orv_estado' => 0), 'orv_id_fac', $id_fac);
            $this->gsatelite->actualizar('pxf_personalxfactura', array('pxf_estado' => 0), 'pxf_id_fac', $id_fac);
            $detalles_fac = $this->gsatelite->get_tabla('def_detalle_fact', array('def_id_fac' => $id_fac));
            foreach ($detalles_fac as $key => $value) {
                $this->gsatelite->actualizar('ixf_impuestoxfactura', array('ixf_estado' => 0), 'ixf_id_def', $value['def_id']);//ok
                $this->gsatelite->actualizar('rxf_retencionxdetalle_factura', array('rxf_estado' => 0), 'rxf_id_def', $value['def_id']);//ok
                $this->gsatelite->actualizar('cxd_caracteristicaxdetalle_factura', array('cxd_estado' => 0), 'cxd_id_def', $value['def_id']);//ok
                $this->gsatelite->actualizar('cdf_componente_detalle_factura', array('cdf_estado' => 0), 'cdf_id_def', $value['def_id']);//ok
                $this->gsatelite->actualizar('dcf_detalle_centrocostoxfactura', array('dcf_estado' => 0), 'dcf_id_def', $value['def_id']);//ok
            }
            $this->gsatelite->actualizar('def_detalle_fact', array('def_estado' => 0), 'def_id_fac', $id_fac);
            $anular_abc = array(
                'abc_estado' => 0,
                'abc_id_usu_anulacion' => $this->tank_auth->get_user_id(),
                'abc_motivo_anulacion' => 'Anulación de Nota de Crédito Generadora',
                'abc_fecha_anulacion' => date('Y-m-d H:i:s'),
                'abc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'abc_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $anular_abc_where = array('abc_id_cli' => $nota_cred[0]['fac_id_cli'], 'abc_id_tif' => $nota_cred[0]['fac_id_tif'], 'abc_fecha'  => $nota_cred[0]['fac_fecha_fact']);
            $this->gsatelite->actualizar_array('abc_abono_cliente', $anular_abc, $anular_abc_where);
            $abc_id = $this->gsatelite->get_campo('abc_abono_cliente', 'abc_id', $anular_abc_where);
            $anular_abf = array(
                'abf_fecha_anulacion' => date('Y-m-d H:i:s'),
                'abf_usu_modificacion' => $this->tank_auth->get_user_id(),
                'abf_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $anular_abf_where = array('abf_id_fac' => $nota_cred[0]['fac_id_fac_credito'], 'abf_id_abc' => $abc_id);
            $this->gsatelite->actualizar_array('abf_abono_factura', $anular_abf, $anular_abf_where);
            $array_nota = array(
                'fac_motivo_anulacion' => 'Anulación de Nota de Crédito por $ ' . abs($nota_cred[0]['fac_total']),
                'fac_fecha_anulacion' => date('Y-m-d H:i:s'),
                'fac_subtotal' => 0,
                'fac_descuento' => 0,
                'fac_impuesto' => 0,
                'fac_total_retencion' => 0,
                'fac_total' => 0,
                'fac_estado' => 0,
                'fac_usu_mod' => $this->tank_auth->get_user_id(),
                'fac_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('fac_factura', $array_nota, array('fac_id' => $id_fac));
            $array_fac_padre = array(
                'fac_monto_pendiente' => convertirFloat(($fac_padre[0]['fac_monto_pendiente'] + abs(($nota_cred[0]['fac_total'] - $nota_cred[0]['fac_total_retencion'])))),
                'fac_monto_abono' => convertirFloat(($fac_padre[0]['fac_monto_abono'] - abs(($nota_cred[0]['fac_total'] - $nota_cred[0]['fac_total_retencion'])))),
                'fac_fecha_pagada' => null,
                'fac_fecha_devolucion' => null,
                'fac_estado' => 1,
                'fac_usu_mod' => $this->tank_auth->get_user_id(),
                'fac_fecha_mod' => date('Y-m-d H:i:s')
            );
            $respuesta = $this->gsatelite->actualizar_array('fac_factura', $array_fac_padre, array('fac_id' => $fac_padre[0]['fac_id']));
            $sello = "";
            if ($tipo_fact_elect == 1) {
                if ($nota_cred[0]["fac_sello_recepcion"] != "" && $nota_cred[0]["fac_sello_recepcion"] != null) {
                    $jsonEnv = json_encode([
                        "codigoGeneracion" => $nota_cred[0]["fac_codigo_generacion"],
                        "selloRecepcion" => $nota_cred[0]["fac_sello_recepcion"],
                        "tipoAnulacion" => 2, /* QUEMADO DE MOMENTO*/
                        "motivo" => null,
                        "idInterno" => $nota_cred[0]["fac_id"]
                    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                    $res_env = $this->procesar_invalidacion($jsonEnv);
                    $decode_res = json_decode($res_env, true);
                    if (isset($decode_res["body"]["validations"]["errors"])) {
                        $mensaje = $decode_res["body"]["message"] . " | " . implode(" // ", $decode_res["body"]["validations"]["errors"]);
                    } else {
                        $mensaje = $decode_res["body"]["message"] . " | " . $decode_res["body"]["response"]["descripcionMsg"];
                    }
                    $actualice = array(
                        "fac_id_maf" => 2,
                        "fac_sello_anulacion_fact_elect" => $decode_res["body"]["response"]["selloRecibido"],
                        "fac_comentario_anula_fact_elect" => $mensaje
                    );
                    $this->gsatelite->actualizar_array("fac_factura", $actualice, array("fac_id" => $nota_cred[0]["fac_id"]));
                    $sello = ($decode_res["body"]["response"]["selloRecibido"]) ? "</br> Sello: ".$decode_res["body"]["response"]["selloRecibido"] : "";
                }
            }
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Anulación de nota de crédito", 'texto_alerta' => "Registro anulado correctamente. $sello");
                $this->session->set_flashdata($alerta);
                redirect('facturacion/facturar/lista_nota_credido');
            }
        }
    }

    /************GUARDAR NOTA DE CREDITO**************************/
    function guardar_nota_credito($id_fac = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // var_dump($_POST);die();
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');
            $guardar_como_orv = ($this->input->post('guardar_como_orv') > 0)? 1:0; //preguntar si aplica guardado como orden de venta.
            $tipo = ($this->input->post('usu_dir')!='')?$this->input->post('usu_dir'):null;
            $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2); // FACT ELECT
            // Si aplica guardar como orden de venta invocar a la función independiente que hara ello.
            // Add by René Castaenda 01/06/2018
            if ($guardar_como_orv == 1) {
                $this->guardar_fact_ordVenta($tipo);
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Orden de Venta", 'texto_alerta' => "El registro se guardó correctamente.");
                $this->session->set_flashdata($alerta);
                if($tipo!=null){
                    redirect('facturacion/facturar/crear_factura/0/1');
                }else{
                    redirect('facturacion/facturar/crear_factura');
                }
                exit;
            }
            /********************************************************************************************************/
            /* Verificar si no se han agotado los correlativos */
            $corr         = $this->input->post('dtf_correlativo');
            $cof          = $this->input->post('dtf_serie');
            $tif          = $this->input->post('dtg_tipo_factura');
            $inicio_fin   = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id'=>$corr, 'cxj_estado'=>1));
            $recorrer_fac = $this->generar_numero_factura($inicio_fin[0]['cxj_inicio'], $inicio_fin[0]['cxj_fin'], $cof, $tif, 0, 1);
            $cxj_verificar  = json_decode($recorrer_fac, true);
            $facturas_restantes = $cxj_verificar['factura_rest'];
            /********************* VERIFICA EXISTENCIA DE CORRELATIVO EN FACTURAS CREADAS ***************************/
            $dtf_factura = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null; //10
            $reg_numero = $this->gsatelite->get_registro('fac_factura', array('fac_numero'=>$dtf_factura));
            if(count($reg_numero)>0){
                $dtf_factura = $cxj_verificar['resultado'];
            }
            /********************************************************************************************************/
            //Tab datos generales
            $dtg_cliente = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null; //1
            /* Sucursal asociado al cajero asignado */
            $dtg_sucursal = (trim($this->input->post('emp_sucursal')) != "") ? $this->input->post('emp_sucursal') : null; //4
            /****************************************/
            $sucursal_cli = (trim($this->input->post('slcSucursalCliente')) != "") ? $this->input->post('slcSucursalCliente') : null;
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null; //14
            $dtg_documento_factura = (trim($this->input->post('dtg_documento_factura')) != "") ? $this->input->post('dtg_documento_factura') : null; //13
            $dtg_tipo_factura = (trim($this->input->post('dtg_tipo_factura')) > 0) ? $this->input->post('dtg_tipo_factura') : null; //7
            $dtg_tipo_pago = (trim($this->input->post('dtg_tipo_pago')) > 0) ? $this->input->post('dtg_tipo_pago') : null; //5
            $dtg_forma_pago = (trim($this->input->post('dtg_forma_pago')) > 0) ? $this->input->post('dtg_forma_pago') : null;
            $dtg_cotizacion = (trim($this->input->post('dtg_cotizacion')) > 0) ? $this->input->post('dtg_cotizacion') : null; //no6
            $dtg_orden = (trim($this->input->post('dtg_orden')) > 0) ? $this->input->post('dtg_orden') : null; //n7
            $dtg_envio = (trim($this->input->post('dtg_envio')) != "") ? $this->input->post('dtg_envio') : null; //falta
            $dtf_serie = (trim($this->input->post('dtf_serie')) > 0 ) ? $this->input->post('dtf_serie') : null; //6
            $dtf_correlativo = (trim($this->input->post('dtf_correlativo')) != "") ? $this->input->post('dtf_correlativo') : null; //3
            //$dtf_factura = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null; //10
            $dtf_fecha_fact = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s')) : null; //11
            $dtf_fecha_vence = (trim($this->input->post('dtf_fech_vence')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_vence')))) : null; //21
            $dtf_fecha_conta = (trim($this->input->post('dtf_fech_conta')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_conta')))) : null; //12
            $dtf_fech_entrega = (trim($this->input->post('dtf_fech_entrega')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_entrega')))) : null; //12
            $dtf_area = (trim($this->input->post('dtf_area')) > 0) ? $this->input->post('dtf_area') : null; //8
            $dtf_centro_costo = (trim($this->input->post('dtf_centro_costo')) != "") ? $this->input->post('dtf_centro_costo') : null; //9
            $vendedor = (trim($this->input->post('vendedor')) > 0) ? $this->input->post('vendedor') : null; //2
            $personal = $this->input->post('personal'); // array
            $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null; //15
            $slcProyecto = ($this->input->post('slcProyecto') > 0) ? $this->input->post('slcProyecto') : null;
            $dtf_forma_envio = ($this->input->post('dtf_forma_envio') != '') ? $this->input->post('dtf_forma_envio') : null;
            $dtf_transporte = ($this->input->post('dtf_transporte') != '') ? $this->input->post('dtf_transporte') : null;
            $dtf_incoterms = ($this->input->post('dtf_incoterms') != '') ? $this->input->post('dtf_incoterms') : null;
            $fac_orden_compra = ($this->input->post('fac_orden_compra') != '') ? $this->input->post('fac_orden_compra') : null;
            $dtf_orden_compra = ($this->input->post('dtf_orden_compra') != '') ? $this->input->post('dtf_orden_compra') : null;
            //Array costo de venta de producto por detalle
            $dtf_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? number_format($this->input->post('costo_venta_por_producto'), 2) : null;
            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0; //
            $descuentoT_factura_total = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0; //18
            //$anticipo_factura_total = (trim($this->input->post('anticipo_factura_total')) != "")?$this->input->post('anticipo_factura_total'):0; //18
            $subtotal_factura_total = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0; //17
            $impuesto_factura_total = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0; //19
            $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0; //16
            $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0; //20
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi') : 0;
            //Valores actuales en la base de datos para el axc
            $axc_cantidad_base = ($this->input->post('axc_can_base') != '') ? $this->input->post('axc_can_base') : null;
            $axc_cantidad_facturada_base = ($this->input->post('axc_can_facturada_base') != '') ? $this->input->post('axc_can_facturada_base') : null;
            $axc_cantidad_pendiente_base = ($this->input->post('axc_can_pendiente_base') != '') ? $this->input->post('axc_can_pendiente_base') : null;
            $anticipo_clien = $this->input->post('anticipo_clien');
            $caja = $this->input->post('caja_usuario');
            $fac_domicilio = ($this->input->post('facDomicilio') == true)?1:0;
            //$fac_anticipo = ($this->input->post('anticipo')== 'on')?1:0;
            $crear_mov_inv = $this->input->post('crear_mov_inventario'); //0/1
            // Se guarda un temporal del total de la factura para poder ir restando en cada repetición y se usa para detener la actualización de registros
            $total_temporal = $total_factura_total_origi;
            // Se usa para operar los anticipos
            $total_temporal_2 = 0;
            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;
            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $producto_bodega_moi = array();
            $alerta = "";
            ////////////////////////////////////////////////////////////////////
            $hora_maxima = strtotime('+6 second');
            $hora_minima = strtotime('-6 second');
            $fecha_maxima_fact = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_maxima)) : null;
            $fecha_minima_fact = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_minima)) : null;

            $fac_anticipo                 = 0;
            $fac_monto_anticipo           = null;
            $fac_monto_saldo_anticipo     = null;
            $fac_monto_usado_anticipo     = null;
            $registrar_detalle_anticipo = null;
            $array_facturas_id = null;

            $factura_where = array(
                'fac_id_cli' => $dtg_cliente,
                'fac_id_cof' => $dtf_serie,
                'fac_id_tpg' => $dtg_tipo_pago,
                'fac_id_uxc' => $caja,
                'fac_fecha_fact >= ' => $fecha_minima_fact, 'fac_fecha_fact <=' => $fecha_maxima_fact,
                'fac_fecha_cont' => $dtf_fecha_conta,
                'fac_fecha_crea >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_crea <=' => date('Y-m-d H:i:s',$hora_maxima),
                'fac_usu_crea' => $this->tank_auth->get_user_id(),
                'fac_usu_mod' => $this->tank_auth->get_user_id(),
                'fac_fecha_mod >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_mod <=' => date('Y-m-d H:i:s',$hora_maxima)
            );
            $factura_repetida = $this->gsatelite->get_tabla('fac_factura', $factura_where);
            if(count($factura_repetida) > 0){
                $fac_id = $factura_repetida[0]['fac_id'];
                $dtf_factura = $factura_repetida[0]['fac_numero'];
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente, con el número: ".$dtf_factura);
            } else{
                if($facturas_restantes == 1 || $facturas_restantes == 0){
                    $actualizar_cxj = array(
                        'cxj_estado' => 0,
                        'cxj_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxj_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cxj_correlativoxcaja', $actualizar_cxj, array('cxj_id'=>$corr) );
                }

                if ($dtg_cliente != "" && $dtf_correlativo != "" && $dtf_factura != "" && $dtf_fecha_fact != "" && $dtf_fecha_conta != "" && $dtf_fecha_vence != "") {
                    //Se guarda la factura
                    $id_dup_fac_devolucion = ($this->input->post('id_dup_fac_devolucion')>0)? $this->input->post('id_dup_fac_devolucion'):0;
                    // Verificar que la accion viene del boton pagar
                    $pagar_rapido_fact     = ($this->input->post('pagar_rapido_fact')>0)? $this->input->post('pagar_rapido_fact'):0;
                    // Obtener los valores de Recibe y cambio para procesar el pago
                    $txt_monto_recibido    = ($this->input->post('txt_monto_recibido_')>0)? $this->input->post('txt_monto_recibido_'):0;
                    $txt_monto_devolver    = ($this->input->post('txt_monto_devolver_')>0)? $this->input->post('txt_monto_devolver_'):0;
                    $factura = array(
                        'fac_id_cli' => $dtg_cliente,
                        'fac_id_ven' => $vendedor,
                        'fac_id_cof' => $dtf_serie,
                        'fac_id_suc' => $dtg_sucursal,
                        'fac_id_tpg' => $dtg_tipo_pago,
                        'fac_id_frp' => $dtg_forma_pago,
                        'fac_id_cot' => $dtg_cotizacion,
                        'fac_id_tif' => $dtg_tipo_factura,
                        'fac_id_arf' => $dtf_area,
                        'fac_id_cec' => $dtf_centro_costo,
                        'fac_id_ord' => $dtg_orden,
                        'fac_id_uxc' => $caja,
                        'fac_id_scl' => $sucursal_cli,
                        'fac_id_pcl' => $slcProyecto,
                        'fac_id_frv' => $dtf_forma_envio,
                        'fac_id_ttr' => $dtf_transporte,
                        'fac_incoterm' => $dtf_transporte,
                        'fac_numero' => $dtf_factura,
                        'fac_fecha_fact' => $dtf_fecha_fact,
                        'fac_fecha_cont' => $dtf_fecha_conta,
                        'fac_fecha_entrega' => $dtf_fech_entrega,
                        'fac_documento_cliente' => $dtg_documento_factura,
                        'fac_nombre_factura' => $dtg_nombre_factura,
                        'fac_observacion' => $observaciones,
                        'fac_anticipo' => $flag_anticipo,
                        'fac_tipo_facturacion' => 0, //SI ES ELECTRONICA LUEGO SE ACTUALIZA A 1
                        'fac_retencion_abono' => 0,
                        'fac_total_retencion' => str_replace(',', '', $retencion_factura_total),
                        'fac_subtotal' => str_replace(',', '', $subtotal_factura_total),
                        'fac_descuento' => str_replace(',', '', $descuentoT_factura_total),
                        'fac_impuesto' => str_replace(',', '', $impuesto_factura_total),
                        'fac_total' => str_replace(',', '', $total_factura_total),
                        'fac_monto_pendiente' => str_replace(',', '', $total_factura_total),
                        'fac_incoterm' => $dtf_incoterms,
                        'fac_orden_compra' => $dtf_orden_compra,
                        'fac_monto_abono' => 0,
                        'fac_dui_cliente_factura' => $this->input->post('info_complementaria_dui'),
                        'fac_nit_cliente_factura' => $this->input->post('info_complementaria_nit'),
                        'fac_residencia_cliente_factura' => $this->input->post('info_complementaria_residencia'),
                        'fac_fecha_crea' => date('Y-m-d H:i:s'),
                        'fac_usu_crea' => $this->tank_auth->get_user_id(),
                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                        'fac_fecha_mod' => date('Y-m-d H:i:s'),
                        'fac_estado' => 1,
                        'fac_aplica_domicilio'=>$fac_domicilio,
                        'fac_fecha_vencimiento' => $dtf_fecha_vence,
                        'fac_anticipo' => $fac_anticipo,
                        'fac_monto_anticipo' => $fac_monto_anticipo,
                        'fac_monto_saldo_anticipo' => $fac_monto_saldo_anticipo,
                        'fac_monto_usado_anticipo' => $fac_monto_usado_anticipo,
                        'fac_id_fac_credito' => $id_fac
                    );
                    $mov_fac_dev = array();
                    if ($id_dup_fac_devolucion > 0) {
                        $factura['fac_id_origen_devolucion'] = $id_dup_fac_devolucion;
                        $factura['fac_estado'] =  2; //marcar pagada
                        $factura['fac_monto_pendiente'] =  0;
                        $factura['fac_fecha_pagada'] =  $dtf_fecha_fact;
                        //preguntar si se tiene procesado un movimiento en inventario
                        $mov_fac_dev = $this->facturacion_model->get_detalle_movimiento_devolucion($id_dup_fac_devolucion);
                    }
                    $fac_id = $this->gsatelite->ingresar('fac_factura', $factura);
                    if (($id_dup_fac_devolucion  > 0 || $pagar_rapido_fact > 0) and $fac_id > 0) {
                        // Proceso de devolucion
                        if ($id_dup_fac_devolucion  > 0) {
                            //realizar el registro del pago
                            $reg_devolucion = $this->gsatelite->get_registro('fac_factura', 'fac_id', $id_dup_fac_devolucion);
                            //actualizar fecha de devolucion
                            $this->gsatelite->actualizar_array('fac_factura', array('fac_fecha_devolucion'=>date('Y-m-d H:i:s')), array('fac_id'=>$id_dup_fac_devolucion));
                        }
                        //se resta la nota de credito al monto de la factura
                        if ($fac_id > 0){
                            $monto_pendiente = $this->gsatelite->get_campo('fac_factura','fac_monto_pendiente',array('fac_id'=> $id_fac));
                            $montos_abonados = $this->gsatelite->get_campo('fac_factura','fac_monto_abono',array('fac_id'=> $id_fac));
                            $actualizar_padre['fac_monto_pendiente'] = ($monto_pendiente + ($total_factura_total - $retencion_factura_total));
                            $actualizar_padre['fac_monto_abono'] = ($montos_abonados + abs(($total_factura_total - $retencion_factura_total)));
                            //Se descontara el monto de la nota de credito sin tomar las retenciones
                            if (($monto_pendiente + ($total_factura_total - $retencion_factura_total)) <= 0) {
                                $actualizar_padre['fac_estado'] = 2;
                            }
                            //los montos se suman ya que el monto de la nota de credito viene en negativo por lo tanto (+ por -)= -, se restan
                            $this->gsatelite->actualizar_array('fac_factura', $actualizar_padre, array('fac_id'=>$id_fac));
                        }
                        // Tabla en abc
                        $array_abono = array(
                            'abc_id_cli' => $dtg_cliente,
                            'abc_id_tif' => $dtg_tipo_factura,
                            'abc_fecha' => $dtf_fecha_fact,
                            'abc_monto' => abs(str_replace(',', '', ($total_factura_total - $retencion_factura_total))),
                            'abc_total_abonar' => abs(str_replace(',', '', ($total_factura_total - $retencion_factura_total))),
                            'abc_comprobante' => (isset($reg_devolucion->fac_numero))?$reg_devolucion->fac_numero:0,
                            'abc_estado' => 1,
                            'abc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'abc_fecha_creacion' => date('Y-m-d H:i:s'),
                            'abc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'abc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $abc_id_abono = $this->gsatelite->ingresar('abc_abono_cliente', $array_abono);

                        //tabla en abf
                        $array_abono_factura = array(
                            'abf_id_fac' => $id_fac,
                            'abf_id_abc' => $abc_id_abono,
                            'abf_monto' => abs(str_replace(',', '', ($total_factura_total - $retencion_factura_total))),
                            'abf_pendiente_factura' => 0,
                            'abf_monto_entregado' => $txt_monto_recibido,
                            'abf_monto_cambio' => $txt_monto_devolver,
                            'abf_usu_creacion' =>$this->tank_auth->get_user_id(),
                            'abf_fecha_creacion' =>date('Y-m-d H:i:s'),
                            'abf_usu_modificacion' =>$this->tank_auth->get_user_id(),
                            'abf_fecha_modificacion' =>date('Y-m-d H:i:s')
                        );
 
                        $abf_id_abono_fac = $this->gsatelite->ingresar('abf_abono_factura', $array_abono_factura);

                        // Cuando se desea pagar sin ir a la pantalla de pagos
                        if ($pagar_rapido_fact > 0 && $abf_id_abono_fac > 0 && $abc_id_abono > 0) {
                            $this->gsatelite->actualizar_array('fac_factura', array('fac_estado' => 2, 'fac_monto_abono' => str_replace(',', '', $total_factura_total), 'fac_monto_pendiente' => 0.00), array('fac_id'=>$fac_id));
                        }

                    }
                    // orden de venta
                    $slcOrdVnt = (trim($this->input->post('slcOrdVnt')) != "") ? $this->input->post('slcOrdVnt') : null;
                    if($slcOrdVnt != ''){
                        $orden_venta_array = array(
                            'orv_id_fac' => $fac_id,
                            'orv_estado' => 2,
                            'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array("orv_orden_venta", $orden_venta_array, array("orv_id" => $slcOrdVnt));
                    }

                    //Se actualiza el estado de la cotizacion
                    if ($dtg_cotizacion != '') {
                        $detalle_cotizacion = array(
                            'cot_estado' => 0
                        );
                        //$this->gsatelite->actualizar_array("cot_cotizacion", $detalle_cotizacion, array("cot_id" => $dtg_cotizacion));
                    }

                    //Se guarda el personal de la factura
                    for ($x = 0; $x < count($personal); $x++) {
                        if (trim($personal[$x]) != "") {
                            //tabla pxf_personalxfactura
                            $detalle_personal = array(
                                'pxf_id_fac' => $fac_id,
                                'pxf_id_emp' => $personal[$x],
                                'pxf_estado' => 1,
                                'pxf_usu_creacion' => $this->tank_auth->get_user_id(),
                                'pxf_fecha_creacion' => date('Y-m-d H:i:s'),
                                'pxf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'pxf_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('pxf_personalxfactura', $detalle_personal);
                        }
                    }


                    // Columna codigo
                    $combo_agrupacion = $this->input->post('combo_agrupacion');
                    $aplica_descarga = $this->input->post('aplica_descarga'); //array
                    $fecha_garantia = $this->input->post('garantia_factura');
                    $fecha_text_garantia = $this->input->post('txtgarantia_factura');

                    $tip_producto = $this->input->post('tip_producto');

                    $productos_factura = $this->input->post('producto_factura'); //array
                    $correlativo = $this->input->post('producto_correlativo'); //array
                    $medida_factura = $this->input->post('medida_factura'); //array
                    $bodega_factura = $this->input->post('bodega_producto'); //array
                    $codigo_factura = $this->input->post('codigo_factura'); //array

                    $inscripcion_fac = $this->input->post('inscripcion_factura'); //array inscripción (Si existe)

                    // Columna descripcion
                    $descripcion_factura = $this->input->post('descripcion_factura'); //array
                    // Columna cantidad
                    $cantidad_factura = $this->input->post('cantidad_factura'); //array
                    $cantidad_factura_convertida = $this->input->post('cantidad_factura_convertida'); //array
                    $cantidad_inicial = $this->input->post('cantidad_inicial'); //array
                    // Columna precio
                    $precio_factura = $this->input->post('precio_factura'); //array
                    // Impuesto
                    $impuesto_factura = $this->input->post('impuesto_factura'); //array
                    $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                    $impuesto_array = $this->input->post('impuesto_array'); //array
                    $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                    // Retencion
                    $retencion_factura = $this->input->post('retencion_factura'); //array
                    $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                    $retencion_array = $this->input->post('retencion_array'); //array
                    $retencion_por_array = $this->input->post('retencion_por_array'); //array
                    $retencion_por_array_val = $this->input->post('retencion_por_array_val'); //array subsidios con valor

                    // Descuento
                    $descuento_factura = $this->input->post('descuento_factura'); //array
                    $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                    // Subtotal
                    $subtotal_factura = $this->input->post('subtotal_factura'); //array
                    // Total
                    $total_factura = $this->input->post('total_factura'); //array

                    $tipo_venta = $this->input->post('tipo_venta'); //array

                    //Arreglo con los id de los detalles de la cotizacion
                    $axc_id_art_cotizacion = $this->input->post('axc_id_art_cotizacion'); //array


                    //preguntamos por el porcentaje del impuesto
                    $q_colum_impuesto = $this->gsatelite->get_tabla("imp_impuesto");
                    $array_porcentaje = array_column($q_colum_impuesto, 'imp_porcentaje', 'imp_id');

                    //datos de caracteristica
                    /*
                      Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                      se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                      el id del producto con el id de la caracteristica para guardar la relacion
                     */

                    $bodegas_all = array_unique($bodega_factura);


                    $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                    $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                    $tipo = $this->input->post('tipo_caracteristica');
                    for ($x = 0; $x < count($productos_factura); $x++) {
                        if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                            //es el id de la caracteristica que cuenta el producto
                            $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                            $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                            $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;

                            $caracteristicas_id = $this->input->post('caracteristica_'.$productos_factura[$x].'_'.$correlativo[$x]); //array
                            //solo se usara la formula cuando el producto contenga alguna formula existente asociada a el
                            $formula = null;
                            $formula_id = null;
                            if ($tipo[$x] == 2) {
                                // la formula se obtiene con el codigo del producto, el input tiene la siguiente forma nombre_cada_+idproducto
                                $formula = (trim($this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                                $formula_id = (trim($this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                            }

                            //var_dump($aplica_descarga[$x]);
                            //var_dump($tip_producto[$x]);

                            //verificar si aplica descarga o si es una factura de devolución con movimiento.
                            if (($aplica_descarga[$x] == 1 || count($mov_fac_dev) > 0 ) && $tip_producto[$x] == 0) {

                                if($combo_agrupacion[$x] == 1){
                                    $combos_articulo_array = $this->input->post('combo_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                    $cantidad_temp_combo = $this->input->post('combo_cantidad_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                    $combos_medida_array = $this->input->post('combo_medida_'.$productos_factura[$x].'_'.$correlativo[$x]);

                                    for($k = 0; $k < count($combos_articulo_array); $k++){
                                        $combos_cantidad_array = (float)trim($cantidad_factura[$x])*(float)trim($cantidad_temp_combo[$k]);

                                        $productos_id_moi[] = $combos_articulo_array[$k];
                                        $produtos_cantidad_moi[] = $combos_cantidad_array;
                                        $productos_medida_moi[] = $combos_medida_array[$k];
                                        $producto_bodega_moi[] = $bodega_factura[$x];
                                    }
                                } else{
                                    $productos_id_moi[] = $productos_factura[$x];
                                    //cantidad_factura_convertida
                                    $produtos_cantidad_moi[] = $cantidad_factura_convertida[$x];
                                    $productos_medida_moi[] = $medida_factura[$x];
                                    $producto_bodega_moi[] = $bodega_factura[$x];
                                }
                            }


                            //var_dump($productos_id_moi);
                            //var_dump($produtos_cantidad_moi);

                            $fecha_def = null;
                            if (trim($fecha_text_garantia[$x]) != '') {
                                $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                            }

                            //Se almacena la relacion de la caracteristica y la formula aplicada a esta si se aplico.
                            //tabla def_detalle_fact
                            $detalle_factura = array(
                                'def_id_fac' => $fac_id,
                                'def_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                                'def_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'def_id_fao' => (trim($formula_id) != "") ? $formula_id : null,
                                'def_id_lip' => $idlip,
                                'def_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                //'def_id_bod' => (trim($bodega_factura[$x]) != "") ? $bodega_factura[$x] : null,
                                'def_id_axc' => (trim($axc_id_art_cotizacion[$x]) != "") ? $axc_id_art_cotizacion[$x] : null,
                                'def_valor_formula' => (trim($formula) != "") ? $formula : null,
                                'def_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'def_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'def_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'def_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'def_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'def_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'def_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'def_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'def_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'def_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'def_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'def_fecha_vence_garantia' => $fecha_def,
                                'def_dias_garantia' => (trim($fecha_text_garantia[$x]) != "") ? $fecha_text_garantia[$x] : null,
                                'def_precio_inventario' => $dtf_costo_venta_por_producto[$x],
                                'def_estado' => 1,
                                'def_usu_crea' => $this->tank_auth->get_user_id(),
                                'def_fecha_crea' => date('Y-m-d H:i:s'),
                                'def_usu_mod' => $this->tank_auth->get_user_id(),
                                'def_fecha_mod' => date('Y-m-d H:i:s')
                            );
                            $def_id = $this->gsatelite->ingresar('def_detalle_fact', $detalle_factura);

                            //Actualizar valores de axc_articuloxcotizacion(axc_cantidad_facturada, axc_cantidad_pendiente)
                            //En caso que sea una facturacion parcial por cotizacion
                            if($dtg_cotizacion > 0){
                                //$axc_cant = (trim($cantidad_inicial[$x]) != "") ? $cantidad_inicial[$x] : 0;
                                $axc_cant_base = (trim($axc_cantidad_base[$x]) != "") ? $axc_cantidad_base[$x] : 0;
                                $axc_cant_fac_base = (trim($axc_cantidad_facturada_base[$x]) != "") ? $axc_cantidad_facturada_base[$x] : 0;
                                $axc_cant_pend_base = (trim($axc_cantidad_pendiente_base[$x]) != "") ? $axc_cantidad_pendiente_base[$x] : 0;

                                $axc_cant_fac = (trim($cantidad_factura_convertida[$x]) != "") ? $cantidad_factura_convertida[$x] : 0;
                                $axc_pen = $axc_cant_pend_base - $axc_cant_fac;

                                //Array con los datos para actualizar
                                $axc_articuloxcotizacion = array(
                                    //'axc_cantidad' => $axc_cant,
                                    'axc_cantidad_facturada' => $axc_cant_fac + $axc_cant_fac_base,
                                    'axc_cantidad_pendiente' => $axc_pen

                                );
                                //Se actualizan el valor facturado, el pendiente, y la cantidad adicional
                                $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $axc_articuloxcotizacion, array('axc_id'=>$axc_id_art_cotizacion[$x]));

                                //Valida si el total pendiente de facturar(de esta y las anteriores es 0 o menor por sobre giros)
                                //y dependiendo de eso se actualiza el estado
                                //(1=pendiente, 2=parcial, 3=finalizado)
                                $cot_estado_facturacion = 1;
                                if($axc_pen <= 0){
                                    $cot_estado_facturacion = 3;
                                }else{
                                    $cot_estado_facturacion = 2;
                                }
                                //Actualizar el estado de la cotizacion
                                $array_cotizacion_estado_fac = array(
                                    'cot_estado_facturacion' => $cot_estado_facturacion
                                );
                                $this->gsatelite->actualizar_array('cot_cotizacion', $array_cotizacion_estado_fac, array('cot_id'=>$dtg_cotizacion));
                            }

                            if($inscripcion_fac[$x]!=''){
                               $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_tipo_inscripcion'=>2, 'lxp_id_fac'=>$fac_id, 'lxp_id_def'=>$def_id, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), array('lxp_id'=>$inscripcion_fac[$x]));
                            }


                            //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                            $impuesto_ids = explode(",", $impuesto_array[$x]);
                            $impuesto_por = explode(",", $impuesto_por_array[$x]);
                            for ($k = 0; $k < count($impuesto_ids); $k++) {
                                if ($impuesto_ids[$k] != 0) {
                                    if (trim($impuesto_por[$k]) != "") {
                                        //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                        //$monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                        $monto_temp = $subtotal_factura[$x] * ($array_porcentaje[$impuesto_ids[$k]] / 100);
                                        //tabla ixf_impuestoxfactura
                                        $detalle_impuesto = array(
                                            'ixf_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                            'ixf_id_def' => $def_id,
                                            'ixf_monto' => $monto_temp,
                                            'ixf_porcentaje' => $array_porcentaje[$impuesto_ids[$k]],
                                            'ixf_estado' => 1,
                                            'ixf_usu_mod' => $this->tank_auth->get_user_id(),
                                            'ixf_fecha_mod' => date('Y-m-d H:i:s'),
                                            'ixf_fecha_crea' => date('Y-m-d H:i:s'),
                                            'ixf_usu_crea' => $this->tank_auth->get_user_id()
                                        );
                                        $this->gsatelite->ingresar('ixf_impuestoxfactura', $detalle_impuesto);
                                    }
                                }
                            }

                            $retencion_ids = explode(",", $retencion_array[$x]);
                            $retencion_por = explode(",", $retencion_por_array[$x]);
                            $retencion_valor = explode(",", $retencion_por_array_val[$x]);

                            for ($k = 0; $k < count($retencion_ids); $k++) {
                                if ($retencion_ids[$k] != 0) {
                                    if (trim($retencion_por[$k]) != "") {
                                        if($retencion_por[$k]>0){
                                            $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                        }else{
                                            $monto_temp = $retencion_valor[$k];
                                        }
                                        // Tabla rxf_retencionxdetalle_factura
                                        $detalle_retencion = array(
                                            'rxf_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                            'rxf_id_def' => $def_id,
                                            'rxf_monto' => $monto_temp,
                                            'rxf_estado' => 1,
                                            'rxf_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'rxf_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'rxf_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'rxf_usu_modificacion' => $this->tank_auth->get_user_id()
                                        );
                                        $this->gsatelite->ingresar('rxf_retencionxdetalle_factura', $detalle_retencion);
                                    }
                                }
                            }

                            for ($y = 0; $y < count($caracteristicas_id); $y++) {
                                //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                                if ($tipo[$x] == 0) {

                                } else if ($tipo[$x] == 1) {
                                    // Toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                    $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                } else if ($tipo[$x] == 2) {
                                    // Toma los valores de las cajas escondidas despues de aplicar la formula se almacenan en estas
                                    // Si no se a seleccionado ninguna formula, entonces el valor de las cajas que se toma seria las visibles
                                    if ($formula != "") {
                                        $caracteristicas_id_valor = $this->input->post('valor_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                    } else {
                                        $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                    }
                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                }
                                if ($tipo[$x] != 0) {
                                    if (trim($caracteristicas_id_valor) != "") {
                                        //se guardara en la tabla cxd_caracteristicaxdetalle_factura
                                        $caracteristicas_factura = array(
                                            'cxd_id_def' => $def_id,
                                            'cxd_id_cxu' => (trim($caracteristicas_id[$y]) != "") ? $caracteristicas_id[$y] : null,
                                            'cxd_valor' => (trim($caracteristicas_id_valor) != "") ? $caracteristicas_id_valor : null,
                                            'cxd_descripcion' => (trim($caracteristicas_id_descripcion) != "") ? $caracteristicas_id_descripcion : null,
                                            'cxd_estado' => 1,
                                            'cxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cxd_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('cxd_caracteristicaxdetalle_factura', $caracteristicas_factura);
                                    }
                                }
                            }

                            // Si se agotaron los correlativos, se actualiza la cxj en estado 0
                            if (isset($cxj_verificar) && $cxj_verificar['factura_rest'] == 1) {
                                $this->gsatelite->actualizar_array('cxj_correlativoxcaja', array('cxj_estado' => 0), array('cxj_id' => $this->input->post('dtf_correlativo')));
                            }

                            /* ====================================================================================================================
                                        COMPONENTES
                            ======================================================================================================================*/
                            $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];

                            /* para descargar de bodega             type array*/
                            $descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                            $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                            $bodega_componente = $this->input->post('bodega_componente_id'.$identificador); // no es arreglo

                            /* detalle para guardar                 type array*/
                            $producto_componente = ($this->input->post('producto_componente'.$identificador) != '')?$this->input->post('producto_componente'.$identificador):'';
                            $medida_componente = $this->input->post('medida_componente'.$identificador);
                            $cantidad_componente = $this->input->post('cantidad_conv_componente'.$identificador);

                            $precio_componente = $this->input->post('precio_componente'.$identificador);
                            $subtotal_componente = $this->input->post('subtotal_componente'.$identificador);
                            $descripcion_componente = $this->input->post('descripcion_componente'.$identificador);

                            $alternar_componente = $this->input->post('alternar_componente'.$identificador);
                            $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);

                            $fecha_creacion = date('Y-m-d H:i:s');
                            $componente_sav = array();
                            if($producto_componente != ''){
                                foreach ($producto_componente as $id_comp => $comp) {
                                    if ($descargar_componente[$id_comp] == 1 && $tipo_componente[$id_comp] == 0) {
                                        $productos_id_moi[] = $comp;
                                        $produtos_cantidad_moi[] = $cantidad_componente[$id_comp];
                                        $productos_medida_moi[] = $medida_componente[$id_comp];
                                        $producto_bodega_moi[] = $bodega_componente;
                                    }

                                    $componente_sav[] = array(
                                        'cdf_id_def' => $def_id,
                                        'cdf_id_cva' => $medida_componente[$id_comp],
                                        'cdf_descripcion' => $descripcion_componente[$id_comp],
                                        'cdf_cantidad' => $cantidad_componente[$id_comp],
                                        'cdf_precio' => $precio_componente[$id_comp],
                                        'cdf_subtotal' => $subtotal_componente[$id_comp],
                                        'cdf_total' => $subtotal_componente[$id_comp],
                                        'cdf_altera_precio' => $alternar_componente[$id_comp],
                                        'cdf_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                        'cdf_estado' => 1,
                                        'cdf_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'cdf_fecha_creacion' =>  $fecha_creacion,
                                        'cdf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdf_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                                $this->gsatelite->ingresar('cdf_componente_detalle_factura', $componente_sav, true);
                            }
                            /* ====================================================================================================================
                                        CENTRO COSTO
                            ======================================================================================================================*/

                            $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                            $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                            $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                            $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                            $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                            $pais_costo = $this->input->post('pais'.$identificador);

                            $costo_sav = array();
                            if($centro_costo_costo != ''){
                                foreach ($centro_costo_costo as $id_cost => $costo) {
                                    $costo_sav[] = array(
                                        'dcf_id_def' => $def_id,
                                        'dcf_id_cec' => $centro_costo_costo[$id_cost],
                                        'dcf_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                        'dcf_id_cnt' => $cuenta_contable_costo[$id_cost],
                                        'dcf_id_pai' => ($pais_costo[$id_cost] != "")?$pais_costo[$id_cost]:null,
                                        'dcf_porcentaje' => $porcentaje_costo[$id_cost],
                                        'dcf_monto' => $subtotal_costo[$id_cost],
                                        'dcf_estado' => 1,
                                        'dcf_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'dcf_fecha_creacion' =>  $fecha_creacion,
                                        'dcf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'dcf_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                                $this->gsatelite->ingresar('dcf_detalle_centrocostoxfactura', $costo_sav, true);
                            }
                        }
                    }

                    /*************************** INSCRIPCIÓN DE ALUMNO (GRADO) *********************************************/
                    $grado = ($this->input->post('inscripcion_grd_factura'))?$this->input->post('inscripcion_grd_factura'):null;

                    if($grado!=null){
                        $inscripcion = $this->generar_inscripcion_grado($dtg_cliente, $grado[0], $fac_id, $def_id);
                    }
                    /**********************************************************************************************************/


                    if (count($productos_id_moi) > 0 && $id_dup_fac_devolucion <= 0) {
                        $this->crear_movimiento($fac_id, $producto_bodega_moi, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi, $bodegas_all);
                    } elseif ($id_dup_fac_devolucion > 0) {
                        // si es factura de anulación realizar una entrada especial para inventario
                        if ($crear_mov_inv > 0) {
                            $this->crear_movimiento_devolucion($fac_id, $producto_bodega_moi, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi, $bodegas_all);
                        }
                    }

                    /* ======================================================================================================
                                        Inicio Partida contable para facturacion afecta/no afecta inventario
                    =========================================================================================================*/
                    $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
                    if($generar_partida > 0 && $id_dup_fac_devolucion <= 0){
                        $where['fac_id'] = $fac_id;
                        $info['num_fac'] = $dtf_factura;
                        $info['fac_fecha_conta'] = $dtf_fecha_conta;
                        $res_debe = $this->generar_partida_factura_afecta_noafecta_inv_debe($where,$info);
                        $this->generar_partida_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_haber']);
                        //Insertando los detalles
                        if(count($res_debe['array_detalle_partida']) > 0){
                              $this->gsatelite->ingresar('dpc_detalle_partida', $res_debe['array_detalle_partida'], true);
                        }

                        //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida
                        //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                        $this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct' => $res_debe['id_pct'], 'fac_generacion_partida' => 1),array('fac_id' => $fac_id));

                        /* ======== Contrapartida en caso de tener productos que afecten inventario ======== */
                        $where_existe['fac_id'] = $fac_id;
                        $where_existe['art_inventario'] = 1;
                        $afecta_inv = $this->facturacion_model->existe_prod_afec_inv($where_existe);
                        if($afecta_inv[0]['afecta_inv'] && $generar_partida == 2){
                            $where['cec_id']  = ($dtf_centro_costo) ? $dtf_centro_costo : 0;

                            $res_debe = $this->generar_contra_partida_factura_afecta_afecta_inv_debe($where,$info);
                            //print_r($res_debe); die();
                            $this->generar_contra_partida_factura_afecta_inv_haber($where, $res_debe['id_pct']);
                        }

                    }
                    /* ======================================================================================================
                                        Fin Partida contable para facturacion afecta/no afecta inventario
                    =========================================================================================================*/
                    /* SI ES FACTURA ELECTRONICA LLAMAR LA FUNCION QUE CREARA EL JSON*/
                    if ($tipo_fact_elect == 1) {
                        $datos =  $this->generar_datos_factura_electronica($fac_id);
                        $fact_elect = array(
                            'fac_tipo_facturacion' => 1, 
                            'fac_codigo_generacion' => $datos['cod_generation'],
                            'fac_numero_control' => $datos['num_control']
                        );
                        $this->gsatelite->actualizar_array("fac_factura", $fact_elect, array("fac_id" => $fac_id)); 
                        $this->crear_json_fact($fac_id);
                        $this->enviar_facturacion_sat($fac_id);
                    }
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente, con el número: ".$dtf_factura);

                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
                }
            }

        /* REDIRECCIONES */
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata('id_factura', $fac_id);
            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('usu_dir');
            if($dir>0){
                $direct = '/0/1';
                $dir_pago = '/1';
            }else{
                $direct = '';
                $dir_pago = '';
            }

            $this->session->set_flashdata($alerta);
            redirect('facturacion/facturar/lista_nota_credido');

        }
    }
    /************FIN GUARDAR NOTA DE CREDITO**********************/

    public function descarga_masiva_inventario(){
        satelite_validar();
        ini_set( 'memory_limit', "2048M");
        $fallas                  = array();
        $exitos                  = array();
        $this->load->library('../controllers/inventario/gestion_productos');
        $get_facturas     = $this->facturacion_model->get_descarga_masiva_inventario('limit  1000');
        $totales          = $this->facturacion_model->get_descarga_masiva_inventario();
        $data['total']    = count(array_unique(array_column($totales, 'fac_id')));//cuantas IDs se descargaran
        $data['titulo_personal'] = 'Descarga Masiva';
        // funcion para relacionar los def con las bodegas ya que se guardaron null por algun error, y para realizar las descargas se sincronizan mediante esta funcion
        $this->facturacion_model->update_def_facturas_bod();
        foreach ($get_facturas as $key => $factura) {
            $productos_id_moi        = $factura['def_id_art'];//productos
            $produtos_cantidad_moi   = ($factura['def_cantidad']) ? $factura['def_cantidad'] : 0; //cantidades
            $productos_medida_moi    = $factura['def_id_cva']; //medidas de conversion de los productos
            $producto_bodega_moi     = $factura['def_id_bod']; //bodega de cada producto
            $fac_id                  = $factura['fac_id']; //id de la factura

            $cantidades   = $this->inventario_model->get_sar_cantidades($productos_id_moi, null,null);
            //   $cantidades   = $this->inventario_model->get_cantidad_bodega(null, $producto_bodega_moi, null, $productos_id_moi);
            if ((is_array($cantidades)) && (count($cantidades)>0) ) {
                $tip_salida              = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array('FACTURA'));
                $respuesta = array(

                    'moi_id_tip' => $tip_salida,
                    'moi_id_bod' => $producto_bodega_moi,
                    'moi_id_fac' => $fac_id,
                    'moi_fecha_mov' => date('Y-m-d H:i:s'),
                    'moi_estado' => 1,
                    'moi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'moi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                 $moi_id       = $this->gsatelite->ingresar('moi_movimiento_inv', $respuesta);

                 $this->gestion_productos->peps_salida($productos_id_moi, null, $moi_id, $productos_medida_moi, $produtos_cantidad_moi, null, $cantidades[0]["sar_cant_actual"], $producto_bodega_moi);//$cantidades[0]["cantidad"]
                 $producto = $this->gsatelite->get_campo('art_articulo','art_nombre',array('art_id'=> $productos_id_moi));
                 $bodega = $this->gsatelite->get_campo('bod_bodega','bod_nombre',array('bod_id'=> $producto_bodega_moi));
                 $exitos[]     =  array('factura' => $factura['fac_numero'],'producto'=> $producto,'cantidad'=> $produtos_cantidad_moi,'estado' => 'Factura procesada correctamente, Bodega:'.$bodega);

            }else{
                $producto = $this->gsatelite->get_campo('art_articulo','art_nombre',array('art_id'=> $productos_id_moi));
                $bodega   = $this->gsatelite->get_campo('bod_bodega','bod_nombre',array('bod_id'=> $producto_bodega_moi));
                $fallas[] = array('factura' => $factura['fac_numero'],'producto'=> $producto,'cantidad'=> $produtos_cantidad_moi,'estado' => 'No hay existencia suficiente en la  bodega:  '.$bodega);
            }

        }

        $data['fallas']  = $fallas;
        $data['exitos']  = $exitos;
        $data['records'] = $get_facturas;
        $this->_cargarvista($data, null);
        //$html   = $this->load->view('facturacion/facturar/descarga_masiva_inventario',$data,true);

        //$this->load->library('pdf');
        //$html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Descarga de inventarios <br />", 'solotitulo'=> true), true);
        //$html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
        //$this->pdf->makePDF($html_header.$html,'lanscape', 'Descarga inventario','Legal');

    }

    public function correccion_prueba($fecha, $caja){

        $where_uxc["(DATE(uxc.uxc_fecha_proceso) BETWEEN '$fecha' AND LAST_DAY('$fecha')) AND uxc.uxc_id_caj = $caja"] = null;
        $where_uxc2["(DATE(uxc.uxc_fecha) BETWEEN '$fecha' AND LAST_DAY('$fecha')) AND uxc.uxc_id_caj = $caja"] = null;

        $query = $this->db->select('GROUP_CONCAT(uxc.uxc_id) AS uxc_id', false)
            ->from('uxc_usuarioxcaja as uxc')
            ->where($where_uxc);

        $resulado_fecha_proceso = $query->get()->result_array();

        $query = $this->db->select('GROUP_CONCAT(uxc.uxc_id) AS uxc_id', false)
            ->from('uxc_usuarioxcaja as uxc')
            ->where($where_uxc2);

        $resulado_fecha = $query->get()->result_array();

        /* ============================================================================
        ============================================================================ */
        $uxc_fechaP = array_column($resulado_fecha_proceso, "uxc_id");
        $uxc_fecha = array_column($resulado_fecha, "uxc_id");

        $uxc_fechaParray = explode(",", $uxc_fechaP[0]);
        $uxc_fechaarray = explode(",", $uxc_fecha[0]);

        $diferencia = array();
        foreach ($uxc_fechaParray as $keyP => $valueP) {
            if(!in_array($valueP, $uxc_fechaarray)){
                $diferencia[] = $valueP;
            }
        }

        /* ============================================================================
        ============================================================================ */
        $where_borrar["dft_id_uxc in($uxc_fechaP[0])"] = null;
        $this->gsatelite->borrado_general('dft_detalle_fact_tipoart', $where_borrar);
        /* ============================================================================
        ============================================================================ */

        // print_r($diferencia);
        $groupby = 'tia_id';
        $dft_array = array();
        foreach ($uxc_fechaParray as $keyU => $valueU) {
            $where['uxc_id'] = $valueU;
            $dt_art_fac_dft = $this->facturacion_model->get_catxproductos_usuarioxcaja($where, $groupby);
            // print_r($this->db->last_query());
            // die();
            foreach ($dt_art_fac_dft as $llave => $valor) {
                $dft_array[] = array(
                    'dft_id_tia'            => ($valor['tia_id']>0)?$valor['tia_id']:null,
                    'dft_id_uxc'            => ($valor['uxc_id']>0)?$valor['uxc_id']:null,
                    'dft_total'             => $valor['total'],
                    'dft_art_encontrado'    => $valor['prodTotal'],
                    'dft_art_diferente'     => $valor['prodDistintos'],
                    'dft_fac_encontrada'    => $valor['facturas'],
                    'dft_descripcion'       => null,
                    'dft_estado'            => 1,
                    'dft_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'dft_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'dft_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'dft_fecha_modificacion'=> date('Y-m-d H:i:s')
                );

                // $id_dft = $this->gsatelite->ingresar('dft_detalle_fact_tipoart', $dft_array);
            }
        }
        $this->gsatelite->ingresar('dft_detalle_fact_tipoart', $dft_array, true);
        die();
    }


	/**
    * @author Raul Escalante
    * @param  articulo, bodega, cantidad y precio de la entrada actual
    * @return precio promedio de los articulos incluyendo lo ya inventariado
    */
    public function recalcular_precio_promedio($articulo, $bodega, $cantidad, $precio){
        $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES','2');
        $existencia = ($cantidad != 0) ? $cantidad : 0; //ctdad nueva
        $valores    = ($precio != 0) ? ($precio * $existencia) : 0;     //valor (ctdad * precio)
        $ids = array();
        $where['art_id'] = $articulo;
        $where['bod_id'] = $bodega;
        $actual_existenc = $this->inventario_model->calcular_precio_promedio($where); //obtener lo que hay
        foreach ($actual_existenc as $key => $value) {
            $existencia += ($value['sar_cant_actual'] != '') ? $value['sar_cant_actual'] : 0;
            $valores    += ($value['valor'] != '') ? $value['valor'] : 0;
            $ids[] = $value['sar_id'];
        }
        $nuevo_precio = round(($valores / $existencia), $decimales);//precio promedio (valor/ctdad)
        $new_price = array('sar_precio' => $nuevo_precio);
        if (!(empty($ids))) {
            foreach ($ids as $key => $value) {
                $this->gsatelite->actualizar_array('sar_saldo_articulo', $new_price, array('sar_id' => $value));
            }
        }
        return $nuevo_precio;
    }

    public function descarga_masiva_inventario2($flag = null){
        satelite_validar();
        ini_set( 'memory_limit', "2048M");
        if ($_POST) {
            if ($flag) {//REALIZAR EL PROCESO
                $fallas = array();
                $exitos = array();
                $fecha_desde = ($this->input->post('fecha_desde') !='') ? date('Y-m-d', strtotime($this->input->post('fecha_desde'))) : "";
                $fecha_hasta = ($this->input->post('fecha_hasta') !='') ? date('Y-m-d', strtotime($this->input->post('fecha_hasta'))) : "";
                $get_facturas = $this->facturacion_model->get_descarga_masiva_inventario('300',$fecha_desde,$fecha_hasta);
                $num = $this->facturacion_model->get_ctdad_facturas_bod();
                $totales = $num[0]['cantidad'];
                $costo_promedio = $this->gsatelite->get_parametro('INV_COSTO_PROMEDIO');
                foreach ($get_facturas as $key => $factura) {
                    if ($factura['def_id_bod'] == "") {
                        if ($factura['fac_id_suc'] != "") {
                            $this->facturacion_model->update_one_def_facturas_bod($factura['def_id']);
                            $factura['def_id_bod'] = $this->gsatelite->get_campo('def_detalle_fact','def_id_bod',array('def_id' => $factura['def_id']));

                        } else {
                            $producto = $this->gsatelite->get_campo('art_articulo','art_nombre',array('art_id' => $factura['fac_id_suc']));
                            $fallas[] = array(
                                'factura' => $factura['fac_numero'],
                                'producto'=> $producto,
                                'cantidad'=> $factura['def_cantidad'],
                                'estado'  => 'No se ha definido la bodega de procedencia'
                            );
                        }
                    }
                    $moi_art   = $factura['def_id_art'];
                    $moi_ctda  = ($factura['def_cantidad']) ? $factura['def_cantidad'] : 0;
                    $moi_cva   = $factura['def_id_cva'];
                    $moi_bod   = $factura['def_id_bod'];
                    $fac_id    = $factura['fac_id'];
                    $fac_fecha = strtotime($factura['fac_fecha_fact']);
                    $saldo_bod_array = $this->inventario_model->get_sum_sar_cantidades($moi_art, $moi_bod);
                    $saldo_bod = $saldo_bod_array[0]['cantidad'];
                    $tip_salida = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array('FACTURA'));
                    if ($moi_ctda <= $saldo_bod) {
                        $i = 0;
                        $sar_saldo = $this->inventario_model->get_sar_cantidades($moi_art, $moi_bod);
                        if ($costo_promedio == 1) {
                            $where = array('sar_id_art' => $moi_art, 'sar_id_bod' => $moi_bod);
                            $this->db->limit(1);
                            $this->db->order_by('sar_id DESC');
                            $precio = $this->gsatelite->get_campo('sar_saldo_articulo', 'sar_precio', $where);
                        } else {
                            $precio = $sar_saldo[$i]["sar_precio"];
                        }
                        $ctdad_x_ingresar = $moi_ctda; //Cantidad restante para repetir el bucle, segun la cantidad que se ingreso.
                        $ctdad_procesada = 0; //Cantidad para ingresar en la tabla dee_detalle
                        $ctdad_quedo = 0; //Cantidad restante después de restarle la cantidad elegida
                        $acumulador = 0; //Acumulador, cuando sea igual a la cantidad ingresada se saldrá del bucle
                        $respuesta  = array(
                            'moi_id_tip'             => $tip_salida,
                            'moi_id_bod'             => $moi_bod,
                            'moi_id_fac'             => $fac_id,
                            'moi_fecha_mov'          => date('Y-m-d H:i:s', $fac_fecha),
                            'moi_estado'             => 1,
                            'moi_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'moi_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'moi_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $moi_id = $this->gsatelite->ingresar('moi_movimiento_inv', $respuesta);
                        while ($moi_ctda > $acumulador) {
                            $cantidad_sar   = $sar_saldo[$i]['sar_cant_actual'];
                            $sar_id         = $sar_saldo[$i]['sar_id'];
                            if ($cantidad_sar >= $ctdad_x_ingresar) {
                                $ctdad_procesada = $ctdad_x_ingresar;
                                $ctdad_quedo = $cantidad_sar - $ctdad_procesada;
                                $acumulador += $ctdad_procesada;
                            } else {
                                $ctdad_procesada = $cantidad_sar;
                                $ctdad_quedo = $cantidad_sar - $ctdad_procesada;
                                $acumulador += $ctdad_procesada;
                                $ctdad_x_ingresar = $ctdad_x_ingresar - $cantidad_sar;
                            }
                            $costo_total = $ctdad_procesada * $precio;
                            $cadena_dee = array(
                                'dee_id_moi'   => $moi_id,
                                'dee_id_art'   => $moi_art,
                                'dee_id_sar'   => $sar_id,
                                'dee_id_cva'   => $moi_cva,
                                'dee_cantidad' => ($ctdad_procesada) ? $ctdad_procesada : 0,
                                'dee_precio'   => ($precio) ? $precio : 0,
                                'dee_subtotal' => $costo_total,
                                'dee_estado' => 1,
                                'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('dee_detalle_mov', $cadena_dee);
                            $cadena = array(
                                'sar_cant_actual' => $ctdad_quedo,
                                'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('sar_saldo_articulo', $cadena, array('sar_id' => $sar_id));
                            $i++;
                        }
                        $producto = $this->gsatelite->get_campo('art_articulo','art_nombre',array('art_id'=> $moi_art));
                        $bodega   = $this->gsatelite->get_campo('bod_bodega','bod_nombre',array('bod_id'=> $moi_bod));
                        $exitos[] =  array(
                            'factura'  => $factura['fac_numero'],
                            'producto' => $producto,
                            'cantidad' => $moi_ctda,
                            'estado'   => 'Factura procesada correctamente, Bodega:'.$bodega
                        );
                        //SI ES ANULACION...
                        if ($factura['fac_estado'] == 0 && $factura['fac_fecha_anulacion'] != ""){
                            $tip_entrada = $this->gsatelite->get_parametro('SYS_TIP_AUTOMATICOS', null, null, array('FACTURA_ANULAR'));
                            $resp_anulada = $this->db->insert('moi_movimiento_inv', array(
                                'moi_id_tip'             => $tip_entrada,
                                'moi_id_bod'             => $moi_bod,
                                'moi_id_fac'             => $fac_id,
                                'moi_fecha_mov'          => formatear_fecha('Y-m-d H:i:s', $factura['fac_fecha_anulacion']),
                                'moi_estado'             => 1,
                                'moi_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'moi_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'moi_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'moi_fecha_modificacion' => date('Y-m-d H:i:s')
                            ));
                            $moi_id_anul = $this->db->insert_id();
                            if ($costo_promedio == 1) {
                                $nuevo_precio =  $this->recalcular_precio_promedio($moi_art, $moi_bod, $moi_ctda, $precio);
                            }
                            $respu_anulada = $this->db->insert('sar_saldo_articulo', array(
                                'sar_id_art' => $moi_art,
                                'sar_id_bod' => $moi_bod,
                                'sar_cant_actual' => $moi_ctda,
                                'sar_precio' => ($costo_promedio == 1) ? $nuevo_precio : $precio,
                                'sar_estado' => 1,
                                'sar_usu_creacion' => $this->tank_auth->get_user_id(),
                                'sar_fecha_creacion' => date('Y-m-d H:i:s'),
                                'sar_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'sar_fecha_modificacion' => date('Y-m-d H:i:s')
                            ));
                            $sar_id_anul = $this->db->insert_id();
                            $costo_total = ($costo_promedio == 1) ? ($nuevo_precio * $moi_ctda) : ($precio * $moi_ctda);
                            $dee_array = array(
                                'dee_id_moi'   => $moi_id_anul,
                                'dee_id_art'   => $moi_art,
                                'dee_id_sar'   => $sar_id_anul,
                                'dee_id_cva'   => $moi_cva,
                                'dee_cantidad' => $moi_ctda,
                                'dee_precio'   => ($costo_promedio == 1) ? $nuevo_precio : $precio,
                                'dee_subtotal' => $costo_total,
                                'dee_estado' => 1,
                                'dee_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dee_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dee_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dee_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $dee_id = $this->gsatelite->ingresar('dee_detalle_mov', $dee_array);
                        }
                    }else{
                        $producto = $this->gsatelite->get_campo('art_articulo','art_nombre',array('art_id'=> $moi_art));
                        $bodega   = $this->gsatelite->get_campo('bod_bodega','bod_nombre',array('bod_id'=> $moi_bod));
                        $anulada  = ($factura['fac_estado'] == 0) ? ' (Factura Anulada)' : '';
                        $fallas[] = array(
                            'factura'  => $factura['fac_numero'],
                            'producto' => $producto,
                            'cantidad' => $moi_ctda,
                            'estado'   => 'No hay existencia suficiente en la  bodega:  '. $bodega . $anulada
                        );
                    }
                }//end foreach
                $total = $totales;
                $lista = count(array_unique(array_column($get_facturas, 'fac_id')));
                $ctdad = (count($get_facturas) < 300) ? count($get_facturas) : 300;
                $pdtes = $total - $lista;
                $data['total']   = $total;
                $data['pdtes']   = $pdtes;
                $data['fallas']  = $fallas;
                $data['ctdad']   = $ctdad;
                $data['exitos']  = $exitos;
                $data['records'] = $get_facturas;
                $html = $this->load->view('facturacion/facturar/detalle_descarga_masiva_inventario2', $data, true);
                echo $html;

            } else {//YA SE HIZO PROCESO, SOLO IMPRIMIRLO
                $vacio = '<table class="responsive dynamicTable display table dataTable"><tr><th style="text-align: center;height: 40px;">NO SE ENCONTRARON REGISTROS</th></tr></table>';
                $imp_reporte = ($this->input->post('imp_reporte') !='') ? $this->input->post('imp_reporte') : "";
                $reporte     = ($this->input->post('reporte') !='') ? $this->input->post('reporte') : $vacio;
                if ($imp_reporte == 'pdf') {
                    $head = $this->load->view('reporte/header', array('titulo' => "Descarga masiva de inventarios <br />", 'solotitulo'=> true), true);
                    $html = $reporte;
                    $html = str_replace('style="font-size:12px;"','style="font-size:9px;"',$html);////  CAMBIAR TAMANO LETRA
                    $impr = $head . $html;
                    $this->pdf->makePdf($impr, 'P', 'Descarga Masiva', 'Letter');
                } elseif ($imp_reporte == 'excel') {
                    $empresa = mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                    $head = '<meta charset="utf-8"><table><tr><td align="center" colspan="3" ><h4>' . $empresa . '<br>Descarga Masiva de Inventario</h4></td></tr></table>';
                    $filename = 'descarga_masiva_' . date('dmY') . '_' . date('His') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $html = $reporte;
                    $excel = $head . $html;
                    header("Content-Type: application/vnd.ms-excel");
                    header("content-disposition: attachment;filename=" . $filename . ".xls");
                    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                    header("Expires: 0");
                    echo $excel;
                }
            }
        } else {
            $data['titulo_personal'] = 'Descarga Masiva';
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-07-09
     * @return vista de una nota de debito
     */
    function nota_debito($fecha_inicio = null, $fecha_fin = null, $tipo = null, $usu=null) {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '9999');
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $roles_usuario = $this->facturacion_model->get_roles_usuario($this->tank_auth->get_user_id());
           // $id_rol_caja = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $rol_admit = 0;
            foreach ($roles_usuario as $key => $value) {
                if($value == 1){
                    $rol_admit = 1;
                }
                // if($value == 5){
                //     $rol_admit = 1;
                // }
            }
            // Declaracion de variables
            $es_devolucion = 0;
            if ($tipo){
                $url_padre =  $_SERVER['HTTP_REFERER'];
            } else {
                $url_padre = uri_string();
            }
            if(substr_count($url_padre, 'factura_caja')>0 ){
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura_caja');
            } elseif (substr_count($url_padre, 'lista_nota_credido') > 0 ) {
                // Proceso para devolucion de factura
                $es_devolucion = 1;
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura_devolucion');
            }  else {
                $permisos = $this->gsatelite->get_permisos_opcion('facturacion/facturar/factura');
            }
            if($usu!=null) {
                $data['usu'] = $usu;
                $flag='/1';
            } else {
                $flag='/0';
            }
            if ($fecha_inicio == null && $fecha_fin == null) {
                //die('mmmccc');
                $fecha_inicio = $this->input->post('txtFechaIni');
                $fecha_fin = $this->input->post('txtFechaFin');
            }
            //var_dump($this->input->post());
            $tipoFactura = ( $this->input->post('tipo_fac') != "" ) ? $this->input->post('tipo_fac') : null;
            $output = null;
            $crud = new grocery_CRUD();
            $parametroFacturas = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $ndb = $parametroFacturas["NOTA DEBITO"];
            $ccf = $parametroFacturas["CREDITO FISCAL"];

            if (trim($fecha_inicio) != '') {
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $crud->where('DATE(fac_fecha_fact) >=', date('Y-m-d', strtotime($fecha_inicio)));
                    $crud->where('DATE(fac_fecha_fact) <=', date('Y-m-d H:i:s', strtotime($fecha_fin)));
                    //validar que si es la opción de fatura-caja solo muestre las del usuario logueado, si es la de facturar muestre todo.
                    if(/*$rol_admit != 1*/ substr_count($_SERVER['HTTP_REFERER'], 'factura_caja') > 0 ){
                        $crud->where('fac_usu_crea', $this->tank_auth->get_user_id());
                    }
                }
                if ($tipoFactura != '') {
                    $crud->where('fac_id_tif =', $tipoFactura);
                }
                if($usu!=null){
                    $usuarios = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id_usu'=>$usu));
                    $ids = array_column($usuarios, 'uxc_id');
                    $cadena = implode(',', $ids);

                    if(count($ids)>0){
                        $crud->where('fac_id_uxc IN ('.$cadena.')', null, FALSE);
                    }
                }
                $crud->where("fac_id_tif IN (0,$ndb,$ccf)", null);
                // Verificar que no tiene devolucion
                if ($es_devolucion > 0) {
                    // $crud->where('![fac_id_origen_devolucion] > 0 AND [fac_fecha_devolucion] == NULL', null, FALSE);
                }
                $crud->where('fac_estado >', 0);

                $display_as = array(
                    'fac_numero'        => 'Número',
                    'fac_id_cli'        => 'Cliente',
                    'pcl_codigo'        => 'Proyecto',
                    'fac_observacion'   => 'Observacion',
                    'fac_fecha_fact'    => 'Fecha',
                    'fac_total'         => 'Total',
                    'fac_estado'        => 'Estado',
                    'fac_id_tif'        => 'Tipo factura'
                );
                $columns = array(
                    'fac_id_tif',
                    'fac_numero',
                    'fac_id_cli',
                    /*
                    'pcl_codigo',
                    'fac_observacion',
                    */
                    'fac_fecha_fact',
                    'fac_total',
                    'fac_estado'
                );
                $crud->set_subject('Factura');
                $crud->set_table('fac_factura');
                $crud->columns($columns);
                //$crud->display_as('fac_id_tif', 'Tipo factura');
                $crud->display_as($display_as);
                $crud->set_relation('fac_id_tif', 'tif_tipo_factura', 'tif_nombre');
                $crud->callback_column('pcl_codigo', function($value, $row) {
                    $proyecto = $this->gsatelite->get_campo('pcl_proyecto_cliente', 'pcl_codigo', array('pcl_id' => $row->fac_id_pcl));
                    return $proyecto;
                });
                //$crud->set_relation('fac_id_cli', 'cli_cliente', '{cli_nombre} {cli_apellido}');
                $crud->field_type('fac_estado', 'dropdown', array('2' => 'Pagado', '1' => 'Pendiente', '0' => 'Anulada'));
                $crud->callback_column('fac_id_cli', function($value, $row) {
                    $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $row->fac_id_cli));
                    $regresar = '';
                    if ($clientes[0]['cli_personeria'] == 1) {
                        $regresar = $clientes[0]['cli_codigo'] .' '. $clientes[0]['cli_nombre'] . ' ' . $clientes[0]['cli_apellido'];
                    } else {
                        $regresar = $clientes[0]['cli_codigo'] .' '. $clientes[0]['cli_apellido'];
                    }
                    return $regresar;
                });
                $crud->callback_column('fac_fecha_fact', function($value, $row) {
                    $fecha = (trim($row->fac_fecha_fact) != "") ? formatear_fecha('Y-m-d', trim($row->fac_fecha_fact)) : "";
                    return $fecha;
                });
                $crud->callback_column('fac_total', function($value, $row) {
                    $total = '$' . number_format($row->fac_total-$row->fac_total_retencion, 2);
                    return $total;
                });
                //proceso para cambiar color de tr cuando la facturacion aplica domicilio
                $crud->callback_column('fac_numero',function($value, $row){
                     $domicilio = $row->fac_aplica_domicilio;
                     $entregado_domicilio = $row->fac_entregado_domicilio;

                     if($domicilio > 0 && $entregado_domicilio == 0){
                        return "<label class='color_tr' data-color='#4ac718'>".$value."</label>";
                     } else return $value;
                });

                $crud->unset_add();
                $crud->unset_edit();
                $crud->unset_delete();
                $crud->unset_read();
                //print_r('Esta es la devolucion: ' .$es_devolucion); die();
                // Proceder a solo mostrar la opcion de devolucion en la pantalla de factura cuando viene de la vista devolucon_factura
                //if ($es_devolucion > 0) {
                    $crud->add_action('&nbsp;&nbsp;Procesar Nota', '', 'facturacion/facturar/crear_nota_debito'.$flag.'/0', 'icomoon-icon-copy-2');
                //} else {
                    // Opciones por defecto para las pantalla de factura y factura_caja
                    $crud->add_action('&nbsp;&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_factura', 'icomoon-icon-copy-2 imprimir crud-action');
                    //redirect('modulo_cuentas_cobrar/procesos/crear_pago/'.$dtg_cliente.'/'.$fac_id)
                    /*$crud->add_action('&nbsp;&nbsp;Pago', '', 'facturacion/facturar/pagar_factura', 'icomoon-icon-coins', null,'', "[fac_estado] == 'Pendiente'");
                    $crud->add_action('&nbsp;&nbsp;Historial', '', 'historial', 'icomoon-icon-history mostrar_historial');
                    $crud->add_action('&nbsp;&nbsp;Editar', '', 'facturacion/facturar/editar_factura', 'icomoon-icon-copy-2 editar', null,'', "[fac_estado] == 'Pendiente' or ![fac_estado] == 'Pagado'");
                    $crud->add_action('&nbsp;&nbsp;Domicilio', '', 'facturacion/facturar/historial_domicilio', 'icomoon-icon-checkmark  fac_domicilio', null,'', "[fac_aplica_domicilio] == 1");*/
                //}

                //$crud->add_action('&nbsp;&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_factura', 'acciones icomoon-icon-copy-2 imprimir crud-action');
                /* if ($permisos["permite_ver"]) {
                  //$crud->add_action('&nbsp;&nbsp;Ver', '', 'inventario/mantenimiento/tipo_agrupacion/read','icomoon-icon-search-3');
                  } */
                $crud->order_by('fac_id', 'asc');
                $output = $crud->render();
            }

            $data['es_devolucion'] = $es_devolucion;
            $data['user'] = $usu;
            $data['add_factura'] = (isset($es_devolucion) && $es_devolucion > 0)?0:$permisos["permite_agregar"];
            $data['titulo_personal'] = (isset($es_devolucion) && $es_devolucion > 0)?'Devolución - Factura':"Facturación";
            $data['parametros'] = $parametroFacturas;
            //print_r($data['parametros']);die();
            if ($tipo == null) {
                //die('Si');
                //$this->_cargarvista($data, $output);
                cargarvista($data, $output, 'facturacion/facturar/nota_debito');
            } else {
                print($output->output);
            }
        }
    }

        /**
    * @author Marlon Olmedo
    * @since 2018-09-07
    * @return crea una factura paara lata de credito.
     */
    function crear_nota_debito($flag=0, $fac_id = 0,  $id_fac = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            // si el parametro $fac_id trae cero y el $id_fac es mayor a cero se trata de una devoución. 28052018 //added by René Castaneda
            $fac_id = ($fac_id == 0 && $id_fac > 0)? $id_fac:$fac_id;

            $datos['es_devolucion'] = 2;//antes era 0
            $datos['afecto_fac_inventario_dev'] = 0;

            if ($id_fac > 0) {
                $datos['es_devolucion'] = 2;
                $mov_fac = $this->facturacion_model->get_detalle_movimiento_devolucion($fac_id);
                if (count($mov_fac)) {
                    $datos['afecto_fac_inventario_dev'] = 1;
                }
            }

            $datos["titulo_personal"] = "Nota de débito";
            /* PEDIR UNICAMENTE LOS OPTIONS PARA LLENAR LOS SELECTS */
            $data['parametros'] = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $factura_datos = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $fac_id));
            $detalles_facturas = $this->gsatelite->get_tabla('def_detalle_fact', array('def_id_fac' => $fac_id));
            //print_r($detalles_facturas);die();
            $datos["datos_factura_origen"] = $factura_datos[0];
            /* ========================================= PARAMETROS ========================================================== */
            $datos["cantidad_decimales"] = $this->gsatelite->get_parametro('NUMERO_DECIMALES','2');
            $datos["show_option"] = $this->gsatelite->get_parametro('SYS_ELEMENTOS_MOSTRAR_FACTURA','1,1,1,1');
            $datos["cliente_defecto"] = $factura_datos[0]['fac_id_cli'];
            $datos['permite_mas_productos'] = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO',0);

            $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $datos['cajas']  = $this->facturacion_model->datos_usuario_caja($rol);

            /* ========================================= CLIENTES ========================================================== */

            // Obtener el primer documento de cliente
            $docs_cliente       = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $factura_datos[0]['fac_id_cli']));
            $datos['documento']  = (count($docs_cliente)>0)?$docs_cliente[0]['dcc_valor']:'';

            $client          = '';
            $cliente_nom_fac = '';
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
            foreach ($clientes as $cli) {
                if ($cli['cli_codigo'] != '') {
                    $codigo = trim($cli['cli_codigo']) . ' - ';
                } else {
                    $codigo = '';
                }
                // Verificar cliente de la fuctura
                $selected_cli = '';
                if (trim($factura_datos[0]['fac_id_cli']) == $cli['cli_id']) {
                    $selected_cli            = 'selected';
                    $cliente_nom_fac = ($cli['cli_personeria'] == 1) ? $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $cli['cli_apellido'];
                }
                // Obtener el nombre del cliente
                $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                // Obtener todo los clientes junto al seleccionado
                $client .= '<option value="' . $cli['cli_id'] . '" '.$selected_cli.'>' . $nombre_cliente . '</option>';
            }
            $datos['cliente_nom_fac'] = $cliente_nom_fac;
            //$sucursal_drop = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, $factura_datos[0]['fac_id_suc'], '', 'suc_id', true);

            // Obtener el tipo de factura de nota de credito para la devolucion, sino coloca la que se ha seleccionado por defecto
            $nota_credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('NOTA_CREDITO'));
            //$tif_factura  = ($datos['es_devolucion'] == 1 && $nota_credito > 0)? $nota_credito : $factura_datos[0]['fac_id_tif'];

            $tipos_factura = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => '1','tif_aplica_venta' =>1, 'tif_aplica_nota_debito' => '1'), $data['parametros']['NOTA DEBITO'], '', 'tif_id', true);

            $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $factura_datos[0]['fac_id_tpg'], '', 'tpg_id', true);

            $formas_pago = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => '1'), $factura_datos[0]['fac_id_frp'], '', 'frp_id', true);

            $select_retencion = "";
            $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            foreach ($retencion_campos as $key) {
                if ($key["ret_defecto"] == 1) {
                    $select_retencion .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select_retencion .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
            //personal para duplicar
            $personal_registros = $this->gsatelite->get_tabla('pxf_personalxfactura', array('pxf_id_fac' => $fac_id));
            $array_emp = array_column($personal_registros, 'pxf_id_emp');

            $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $array_emp, '', 'emp_id', true);

            $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $factura_datos[0]['fac_id_arf'], '', 'arf_id', true);

            $costo_drop = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => '1'), $factura_datos[0]['fac_id_cec'], '', 'cec_id', true);

            $tipo_venta_drop = $this->gsatelite->get_dropdown('tpv_tipo_venta', '{tpv_nombre}', '', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1),null ,'', 'tpv_id', true);


            /* ===================================== DATOS DE LA FACTURA A DUPLICAR ============================================== */

            $datos['factura_reg'] = $factura_datos;
            $datos['factura_id'] = $fac_id;
            $datos['factura_dup'] = 1;
            $datos['orv_id'] = '';

            $datos['clientes'] = $client;
            $datos['nombre_factura'] = $factura_datos[0]['fac_nombre_factura'];
            $datos['documento_factura'] = $factura_datos[0]['fac_documento_cliente'];
            //$datos['sucursal'] = str_replace('<option value="0">Seleccione</option>', '', $sucursal_drop);
            $datos["tipos_factura"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_factura);
            $datos["tipos_pago"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_pago);
            $datos["formas_pago"] = str_replace('<option value="0">Seleccione</option>', '', $formas_pago);

            $datos["retencion"] = $select_retencion;

            $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_select);

            $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);

            $datos["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $costo_drop);

            $datos["tipo_venta"] = str_replace('<option value="0">Seleccione</option>', '', $tipo_venta_drop);

            $datos["categorias"] = $this->obtener_categoriaxbodega2();

            $datos['observacion_factura'] = $factura_datos[0]['fac_observacion'];

            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $factura_datos[0]['fac_id_ven'], '', 'ven_id', true);
            $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores);

            $id_cli = $this->input->post('id');

            $sucursal_cli = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_codigo} - {scl_nombre}', '', array('scl_estado'=>1, 'scl_id_cli'=>$factura_datos[0]['fac_id_cli']), null, '', 'scl_id', true);
            $sucursal_cli = str_replace('<option value="0">Seleccione</option>', '', $sucursal_cli);
            $sucursal_cli = str_replace('<option value="0">Sin Registros</option>', '', $sucursal_cli);
            $datos['sucursal_cli'] = $sucursal_cli;

            $this->db->select('ret_id,ret_valor_minimo,ret_porcentaje');
            $data_ret = $this->gsatelite->get_tabla('ret_retencion',array('ret_estado'=>1,'ret_valor_minimo >'=>0));
            $datos["retencionesAuto"] = json_encode($data_ret);
            //print_r($datos["empleados"]);die();
            $datos['fac_id'] = $fac_id;
            //print_r($datos['detalle_factura']);die();
            if($flag>0){
                cargarvista($datos, null, 'facturacion/facturar/crear_factura/0/1');
            }else{
                cargarvista($datos, null, 'facturacion/facturar/crear_nota_debito');
            }

        }
    }//duplicar_nota_credito

            /**
    * @author Marlon Olmedo
    * @since 2018-09-07
    * @return almacena una nota de debito.
     */
        /************GUARDAR NOTA DE DEBITO**************************/
    function guardar_nota_debito($id_fac = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');
            $tipo_fact_elect = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2); // FACT ELECT
            $guardar_como_orv = ($this->input->post('guardar_como_orv') > 0)? 1:0; //preguntar si aplica guardado como orden de venta.
            $tipo = ($this->input->post('usu_dir')!='')?$this->input->post('usu_dir'):null;

            // Si aplica guardar como orden de venta invocar a la función independiente que hara ello.
            // Add by René Castaenda 01/06/2018
            if ($guardar_como_orv == 1) {
                $this->guardar_fact_ordVenta($tipo);
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Orden de Venta", 'texto_alerta' => "El registro se guardó correctamente.");
                $this->session->set_flashdata($alerta);
                if($tipo!=null){
                    redirect('facturacion/facturar/crear_factura/0/1');
                }else{
                    redirect('facturacion/facturar/crear_factura');
                }
                exit;
            }

            /********************************************************************************************************/
            /* Verificar si no se han agotado los correlativos */
            $corr         = $this->input->post('dtf_correlativo');
            $cof          = $this->input->post('dtf_serie');
            $tif          = $this->input->post('dtg_tipo_factura');
            $inicio_fin   = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id'=>$corr, 'cxj_estado'=>1));
            $recorrer_fac = $this->generar_numero_factura($inicio_fin[0]['cxj_inicio'], $inicio_fin[0]['cxj_fin'], $cof, $tif, 0, 1);
            $cxj_verificar  = json_decode($recorrer_fac, true);
            $facturas_restantes = $cxj_verificar['factura_rest'];
            /********************************************************************************************************/
            /********************* VERIFICA EXISTENCIA DE CORRELATIVO EN FACTURAS CREADAS ***************************/
                $dtf_factura = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null; //10
                $reg_numero = $this->gsatelite->get_registro('fac_factura', array('fac_numero'=>$dtf_factura));

                if(count($reg_numero)>0){
                    $dtf_factura = $cxj_verificar['resultado'];
                }

            /********************************************************************************************************/
            //Tab datos generales
            $dtg_cliente = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null; //1
            /* Sucursal asociado al cajero asignado */
            $dtg_sucursal = (trim($this->input->post('emp_sucursal')) != "") ? $this->input->post('emp_sucursal') : null; //4
            /****************************************/
            $sucursal_cli = (trim($this->input->post('slcSucursalCliente')) != "") ? $this->input->post('slcSucursalCliente') : null;
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null; //14
            $dtg_documento_factura = (trim($this->input->post('dtg_documento_factura')) != "") ? $this->input->post('dtg_documento_factura') : null; //13
            $dtg_tipo_factura = (trim($this->input->post('dtg_tipo_factura')) > 0) ? $this->input->post('dtg_tipo_factura') : null; //7
            $dtg_tipo_pago = (trim($this->input->post('dtg_tipo_pago')) > 0) ? $this->input->post('dtg_tipo_pago') : null; //5
            $dtg_forma_pago = (trim($this->input->post('dtg_forma_pago')) > 0) ? $this->input->post('dtg_forma_pago') : null;
            $dtg_cotizacion = (trim($this->input->post('dtg_cotizacion')) > 0) ? $this->input->post('dtg_cotizacion') : null; //no6
            $dtg_orden = (trim($this->input->post('dtg_orden')) > 0) ? $this->input->post('dtg_orden') : null; //n7
            $dtg_envio = (trim($this->input->post('dtg_envio')) != "") ? $this->input->post('dtg_envio') : null; //falta

            $dtf_serie = (trim($this->input->post('dtf_serie')) > 0 ) ? $this->input->post('dtf_serie') : null; //6
            $dtf_correlativo = (trim($this->input->post('dtf_correlativo')) != "") ? $this->input->post('dtf_correlativo') : null; //3
            //$dtf_factura = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null; //10
            $dtf_fecha_fact = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s')) : null; //11
            $dtf_fecha_vence = (trim($this->input->post('dtf_fech_vence')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_vence')))) : null; //21
            $dtf_fecha_conta = (trim($this->input->post('dtf_fech_conta')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_conta')))) : null; //12
            $dtf_fech_entrega = (trim($this->input->post('dtf_fech_entrega')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_entrega')))) : null; //12

            $dtf_area = (trim($this->input->post('dtf_area')) > 0) ? $this->input->post('dtf_area') : null; //8
            $dtf_centro_costo = (trim($this->input->post('dtf_centro_costo')) != "") ? $this->input->post('dtf_centro_costo') : null; //9

            $vendedor = (trim($this->input->post('vendedor')) > 0) ? $this->input->post('vendedor') : null; //2
            $personal = $this->input->post('personal'); // array

            $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;

            $slcProyecto = ($this->input->post('slcProyecto') > 0) ? $this->input->post('slcProyecto') : null;

            $dtf_forma_envio = ($this->input->post('dtf_forma_envio') != '') ? $this->input->post('dtf_forma_envio') : null;

            $dtf_transporte = ($this->input->post('dtf_transporte') != '') ? $this->input->post('dtf_transporte') : null;

            $dtf_incoterms = ($this->input->post('dtf_incoterms') != '') ? $this->input->post('dtf_incoterms') : null;
            $fac_orden_compra = ($this->input->post('fac_orden_compra') != '') ? $this->input->post('fac_orden_compra') : null;
            $dtf_orden_compra = ($this->input->post('dtf_orden_compra') != '') ? $this->input->post('dtf_orden_compra') : null;

            //Array costo de venta de producto por detalle
            $dtf_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? number_format($this->input->post('costo_venta_por_producto'),2) : null;

            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0; //
            $descuentoT_factura_total = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
            //$anticipo_factura_total = (trim($this->input->post('anticipo_factura_total')) != "")?$this->input->post('anticipo_factura_total'):0; //18
            $subtotal_factura_total = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0; //17
            $impuesto_factura_total = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0; //19
            $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0; //16
            $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0; //20
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi') : 0;

            //Valores actuales en la base de datos para el axc
            $axc_cantidad_base = ($this->input->post('axc_can_base') != '') ? $this->input->post('axc_can_base') : null;
            $axc_cantidad_facturada_base = ($this->input->post('axc_can_facturada_base') != '') ? $this->input->post('axc_can_facturada_base') : null;
            $axc_cantidad_pendiente_base = ($this->input->post('axc_can_pendiente_base') != '') ? $this->input->post('axc_can_pendiente_base') : null;


            $anticipo_clien = $this->input->post('anticipo_clien');
            $caja = $this->input->post('caja_usuario');

            $fac_domicilio = ($this->input->post('facDomicilio') == true)?1:0;
            //$fac_anticipo = ($this->input->post('anticipo')== 'on')?1:0;

            // Se guarda un temporal del total de la factura para poder ir restando en cada repetición y se usa para detener la actualización de registros
            $total_temporal = $total_factura_total_origi;
            // Se usa para operar los anticipos
            $total_temporal_2 = 0;

            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;

            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $producto_bodega_moi = array();

            $alerta = "";

            $hora_maxima = strtotime('+6 second');
            $hora_minima = strtotime('-6 second');

            $fecha_maxima_fact = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_maxima)) : null; //11
            $fecha_minima_fact = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_minima)) : null; 

             /*Agregado por Nelson Soriano
                *@since 2-02-2019
                *Descripcion:
                *Preguntamos si la factura trae anticipos a aplicarse,registrarse o si viene null
                */

                /*if ($this->input->post('anticipo') == 'on') {
                    $fac_anticipo = 1;
                    $fac_monto_anticipo       = $total_factura_total;
                    $fac_monto_saldo_anticipo = $total_factura_total;
                    $fac_monto_usado_anticipo = 0;
                }else{*/

                    $fac_anticipo                 = 0;
                    $fac_monto_anticipo           = null;
                    $fac_monto_saldo_anticipo     = null;
                    $fac_monto_usado_anticipo     = null;

                /*}*/

                    $registrar_detalle_anticipo = null;
                    $array_facturas_id = null;

                if ($this->input->post('anticipo_valores_fac'))  {
                        $fac_anticipo = 0;
                        $registrar_detalle_anticipo = true;
                        $trae_anticipos = $this->input->post('anticipo_valores_fac');
                        $monto = 0;
                        for ($i=0; $i < count($trae_anticipos); $i++) {
                            $array_info      = explode(':::', $trae_anticipos[$i]);
                            $id_factura      = $array_info[0];
                            $monto_aplicar   = $array_info[1];
                            $saldo           = $this->gsatelite->get_campo('fac_factura','fac_monto_saldo_anticipo',array('fac_id'=>$id_factura));
                            if ($saldo       >= $monto_aplicar) {
                            $nuevo_saldo  = $saldo - $monto_aplicar;
                            $usado        = $monto_aplicar;
                            $this->gsatelite->actualizar_array('fac_factura', array('fac_monto_saldo_anticipo'=>$nuevo_saldo,'fac_monto_usado_anticipo'=>$usado), array('fac_id'=>$id_factura));
                             $estado = ($nuevo_saldo == 0)?2:1;
                             $monto       += $monto_aplicar;
                             $array_facturas_id[$i] = array('factura'=>$id_factura,'utilizado'=>$usado,'saldo'=>$nuevo_saldo,'estado'=>$estado);
                         }
                      }
                        $fac_monto_anticipo       = null;
                        $fac_monto_saldo_anticipo = null;
                        $fac_monto_usado_anticipo = null;
                    }


            $factura_where = array(
                'fac_id_cli' => $dtg_cliente,
                'fac_id_cof' => $dtf_serie,
                'fac_id_tpg' => $dtg_tipo_pago,
                'fac_id_uxc' => $caja,
                'fac_fecha_fact >= ' => $fecha_minima_fact, 'fac_fecha_fact <=' => $fecha_maxima_fact,
                'fac_fecha_cont' => $dtf_fecha_conta,
                'fac_fecha_crea >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_crea <=' => date('Y-m-d H:i:s',$hora_maxima),
                'fac_usu_crea' => $this->tank_auth->get_user_id(),
                'fac_usu_mod' => $this->tank_auth->get_user_id(),
                'fac_fecha_mod >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_mod <=' => date('Y-m-d H:i:s',$hora_maxima)
            );
            $factura_repetida = $this->gsatelite->get_tabla('fac_factura', $factura_where);

            if(count($factura_repetida) > 0){
                $fac_id = $factura_repetida[0]['fac_id'];
                $dtf_factura = $factura_repetida[0]['fac_numero'];
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente, con el número: ".$dtf_factura);
            } else{
                if($facturas_restantes == 1 || $facturas_restantes == 0){
                    $actualizar_cxj = array(
                        'cxj_estado' => 0,
                        'cxj_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxj_fecha_mod' => date('Y-m-d H:i:s')
                    );
                   $this->gsatelite->actualizar_array('cxj_correlativoxcaja', $actualizar_cxj, array('cxj_id'=>$corr) );
                }

                if ($dtg_cliente != "" && $dtf_correlativo != "" && $dtf_factura != "" && $dtf_fecha_fact != "" && $dtf_fecha_conta != "" && $dtf_fecha_vence != "") {
                    //Se guarda la factura

                    $id_dup_fac_devolucion = ($this->input->post('id_dup_fac_devolucion')>0)? $this->input->post('id_dup_fac_devolucion'):0;
                    // Verificar que la accion viene del boton pagar
                    $pagar_rapido_fact     = ($this->input->post('pagar_rapido_fact')>0)? $this->input->post('pagar_rapido_fact'):0;

                    // Obtener los valores de Recibe y cambio para procesar el pago
                    $txt_monto_recibido    = ($this->input->post('txt_monto_recibido_')>0)? $this->input->post('txt_monto_recibido_'):0;
                    $txt_monto_devolver    = ($this->input->post('txt_monto_devolver_')>0)? $this->input->post('txt_monto_devolver_'):0;

                    $factura = array(
                        'fac_id_cli' => $dtg_cliente,
                        'fac_id_ven' => $vendedor,
                        'fac_id_cof' => $dtf_serie,
                        'fac_id_suc' => $dtg_sucursal,
                        'fac_id_tpg' => $dtg_tipo_pago,
                        'fac_id_frp' => $dtg_forma_pago,
                        'fac_id_cot' => $dtg_cotizacion,
                        'fac_id_tif' => $dtg_tipo_factura,
                        'fac_id_arf' => $dtf_area,
                        'fac_id_cec' => $dtf_centro_costo,
                        'fac_id_ord' => $dtg_orden,
                        'fac_id_uxc' => $caja,
                        'fac_id_scl' => $sucursal_cli,
                        'fac_id_pcl' => $slcProyecto,
                        'fac_id_frv' => $dtf_forma_envio,
                        'fac_id_ttr' => $dtf_transporte,
                        'fac_incoterm' => $dtf_transporte,
                        'fac_numero' => $dtf_factura,
                        'fac_fecha_fact' => $dtf_fecha_fact,
                        'fac_fecha_cont' => $dtf_fecha_conta,
                        'fac_fecha_entrega' => $dtf_fech_entrega,
                        'fac_documento_cliente' => $dtg_documento_factura,
                        'fac_nombre_factura' => $dtg_nombre_factura,
                        'fac_observacion' => $observaciones,
                        'fac_anticipo' => $flag_anticipo,
                        'fac_retencion_abono' => 0,
                        'fac_total_retencion' => str_replace(',', '', $retencion_factura_total),
                        'fac_subtotal' => str_replace(',', '', $subtotal_factura_total),
                        'fac_descuento' => str_replace(',', '', $descuentoT_factura_total),
                        'fac_impuesto' => str_replace(',', '', $impuesto_factura_total),
                        'fac_total' => str_replace(',', '', $total_factura_total),
                        'fac_monto_pendiente' => str_replace(',', '', $total_factura_total),
                        'fac_incoterm' => $dtf_incoterms,
                        'fac_orden_compra' => $dtf_orden_compra,
                        'fac_monto_abono' => 0,
                        //'fac_motivo_anulacion' => $dtg_cotizacion,
                        //'fac_fecha_anulacion' => $dtg_cotizacion,
                        'fac_dui_cliente_factura' => $this->input->post('info_complementaria_dui'),
                        'fac_nit_cliente_factura' => $this->input->post('info_complementaria_nit'),
                        'fac_residencia_cliente_factura' => $this->input->post('info_complementaria_residencia'),
                        'fac_fecha_crea' => date('Y-m-d H:i:s'),
                        'fac_usu_crea' => $this->tank_auth->get_user_id(),
                        'fac_usu_mod' => $this->tank_auth->get_user_id(),
                        'fac_fecha_mod' => date('Y-m-d H:i:s'),
                        'fac_estado' => 1,
                        'fac_aplica_domicilio'=>$fac_domicilio,
                        'fac_fecha_vencimiento' => $dtf_fecha_vence,
                        'fac_anticipo' => $fac_anticipo,
                        'fac_monto_anticipo' => $fac_monto_anticipo,
                        'fac_monto_saldo_anticipo' => $fac_monto_saldo_anticipo,
                        'fac_monto_usado_anticipo' => $fac_monto_usado_anticipo,
                        'fac_id_fac_debito' => $id_fac
                    );

                    $fac_id = $this->gsatelite->ingresar('fac_factura', $factura);

                        // Tabla en abc
                        $array_abono = array(
                            'abc_id_cli' => $dtg_cliente,
                            'abc_id_tif' => $dtg_tipo_factura,
                            'abc_fecha' => $dtf_fecha_fact,
                            'abc_monto' => str_replace(',', '', $total_factura_total),
                            'abc_total_abonar' => str_replace(',', '', $total_factura_total),
                            'abc_comprobante' => (isset($reg_devolucion->fac_numero))?$reg_devolucion->fac_numero:0,
                            'abc_estado' => 1,
                            'abc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'abc_fecha_creacion' => date('Y-m-d H:i:s'),
                            'abc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'abc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $abc_id_abono = $this->gsatelite->ingresar('abc_abono_cliente', $array_abono);

                        //tabla en abf
                        $array_abono_factura = array(
                            'abf_id_fac' => $fac_id,
                            'abf_id_abc' => $abc_id_abono,
                            'abf_monto' => str_replace(',', '', $total_factura_total),
                            'abf_pendiente_factura' => 0,
                            'abf_monto_entregado' => $txt_monto_recibido,
                            'abf_monto_cambio' => $txt_monto_devolver,
                            'abf_usu_creacion' =>$this->tank_auth->get_user_id(),
                            'abf_fecha_creacion' =>date('Y-m-d H:i:s'),
                            'abf_usu_modificacion' =>$this->tank_auth->get_user_id(),
                            'abf_fecha_modificacion' =>date('Y-m-d H:i:s')
                        );

                        $abf_id_abono_fac = $this->gsatelite->ingresar('abf_abono_factura', $array_abono_factura);

                        // Cuando se desea pagar sin ir a la pantalla de pagos
                        /*if ($pagar_rapido_fact > 0 && $abf_id_abono_fac > 0 && $abc_id_abono > 0) {
                            $this->gsatelite->actualizar_array('fac_factura', array('fac_estado' => 2, 'fac_monto_abono' => str_replace(',', '', $total_factura_total), 'fac_monto_pendiente' => 0.00), array('fac_id'=>$fac_id));
                        }*/

                   // }
                    // orden de venta
                    /*$slcOrdVnt = (trim($this->input->post('slcOrdVnt')) != "") ? $this->input->post('slcOrdVnt') : null;
                    if($slcOrdVnt != ''){
                        $orden_venta_array = array(
                            'orv_id_fac' => $fac_id,
                            'orv_estado' => 2,
                            'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array("orv_orden_venta", $orden_venta_array, array("orv_id" => $slcOrdVnt));
                    }*/

                    //Se actualiza el estado de la cotizacion
                    /*if ($dtg_cotizacion != '') {
                        $detalle_cotizacion = array(
                            'cot_estado' => 0
                        );
                        $this->gsatelite->actualizar_array("cot_cotizacion", $detalle_cotizacion, array("cot_id" => $dtg_cotizacion));
                    }*/

                    //Se guarda el personal de la factura
                    for ($x = 0; $x < count($personal); $x++) {
                        if (trim($personal[$x]) != "") {
                            //tabla pxf_personalxfactura
                            $detalle_personal = array(
                                'pxf_id_fac' => $fac_id,
                                'pxf_id_emp' => $personal[$x],
                                'pxf_estado' => 1,
                                'pxf_usu_creacion' => $this->tank_auth->get_user_id(),
                                'pxf_fecha_creacion' => date('Y-m-d H:i:s'),
                                'pxf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'pxf_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('pxf_personalxfactura', $detalle_personal);
                        }
                    }


                    // Columna codigo
                    $combo_agrupacion = $this->input->post('combo_agrupacion');
                    $aplica_descarga = $this->input->post('aplica_descarga'); //array
                    $fecha_garantia = $this->input->post('garantia_factura');
                    $fecha_text_garantia = $this->input->post('txtgarantia_factura');

                    $tip_producto = $this->input->post('tip_producto');

                    $productos_factura = $this->input->post('producto_factura'); //array
                    $correlativo = $this->input->post('producto_correlativo'); //array
                    $medida_factura = $this->input->post('medida_factura'); //array
                    $bodega_factura = $this->input->post('bodega_producto'); //array
                    $codigo_factura = $this->input->post('codigo_factura'); //array

                    $inscripcion_fac = $this->input->post('inscripcion_factura'); //array inscripción (Si existe)

                    // Columna descripcion
                    $descripcion_factura = $this->input->post('descripcion_factura'); //array
                    // Columna cantidad
                    $cantidad_factura = $this->input->post('cantidad_factura'); //array
                    $cantidad_factura_convertida = $this->input->post('cantidad_factura_convertida'); //array
                    $cantidad_inicial = $this->input->post('cantidad_inicial'); //array
                    // Columna precio
                    $precio_factura = $this->input->post('precio_factura'); //array
                    // Impuesto
                    $impuesto_factura = $this->input->post('impuesto_factura'); //array
                    $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                    $impuesto_array = $this->input->post('impuesto_array'); //array
                    $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                    // Retencion
                    $retencion_factura = $this->input->post('retencion_factura'); //array
                    $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                    $retencion_array = $this->input->post('retencion_array'); //array
                    $retencion_por_array = $this->input->post('retencion_por_array'); //array
                    $retencion_por_array_val = $this->input->post('retencion_por_array_val'); //array subsidios con valor

                    // Descuento
                    $descuento_factura = $this->input->post('descuento_factura'); //array
                    $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                    // Subtotal
                    $subtotal_factura = $this->input->post('subtotal_factura'); //array
                    // Total
                    $total_factura = $this->input->post('total_factura'); //array

                    $tipo_venta = $this->input->post('tipo_venta'); //array

                    //Arreglo con los id de los detalles de la cotizacion
                    $axc_id_art_cotizacion = $this->input->post('axc_id_art_cotizacion'); //array


                    //preguntamos por el porcentaje del impuesto
                    $q_colum_impuesto = $this->gsatelite->get_tabla("imp_impuesto");
                    $array_porcentaje = array_column($q_colum_impuesto, 'imp_porcentaje', 'imp_id');

                    //datos de caracteristica
                    /*
                      Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                      se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                      el id del producto con el id de la caracteristica para guardar la relacion
                     */

                    $bodegas_all = array_unique($bodega_factura);


                    $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                    $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                    $tipo = $this->input->post('tipo_caracteristica');
                    for ($x = 0; $x < count($productos_factura); $x++) {
                        if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                            //es el id de la caracteristica que cuenta el producto
                            $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                            $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                            $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;

                            $caracteristicas_id = $this->input->post('caracteristica_'.$productos_factura[$x].'_'.$correlativo[$x]); //array
                            //solo se usara la formula cuando el producto contenga alguna formula existente asociada a el
                            $formula = null;
                            $formula_id = null;
                            if ($tipo[$x] == 2) {
                                // la formula se obtiene con el codigo del producto, el input tiene la siguiente forma nombre_cada_+idproducto
                                $formula = (trim($this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                                $formula_id = (trim($this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                            }

                            //var_dump($aplica_descarga[$x]);
                            //var_dump($tip_producto[$x]);

                            //verificar si aplica descarga o si es una factura de devolución con movimiento.
                            if (($aplica_descarga[$x] == 1 || count($mov_fac_dev) > 0 ) && $tip_producto[$x] == 0) {

                                if($combo_agrupacion[$x] == 1){
                                    $combos_articulo_array = $this->input->post('combo_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                    $cantidad_temp_combo = $this->input->post('combo_cantidad_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                    $combos_medida_array = $this->input->post('combo_medida_'.$productos_factura[$x].'_'.$correlativo[$x]);

                                    for($k = 0; $k < count($combos_articulo_array); $k++){
                                        $combos_cantidad_array = (float)trim($cantidad_factura[$x])*(float)trim($cantidad_temp_combo[$k]);

                                        $productos_id_moi[] = $combos_articulo_array[$k];
                                        $produtos_cantidad_moi[] = $combos_cantidad_array;
                                        $productos_medida_moi[] = $combos_medida_array[$k];
                                        $producto_bodega_moi[] = $bodega_factura[$x];
                                    }
                                } else{
                                    $productos_id_moi[] = $productos_factura[$x];
                                    //cantidad_factura_convertida
                                    $produtos_cantidad_moi[] = $cantidad_factura_convertida[$x];
                                    $productos_medida_moi[] = $medida_factura[$x];
                                    $producto_bodega_moi[] = $bodega_factura[$x];
                                }
                            }



                            /*print_r($productos_id_moi);
                            print_r($produtos_cantidad_moi);
                            print_r($productos_medida_moi);
                            print_r($producto_bodega_moi); exit();die();*/

                            //var_dump($productos_id_moi);
                            //var_dump($produtos_cantidad_moi);

                            $fecha_def = null;
                            if (trim($fecha_text_garantia[$x]) != '') {
                                $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                            }

                            //Se almacena la relacion de la caracteristica y la formula aplicada a esta si se aplico.
                            //tabla def_detalle_fact
                            $detalle_factura = array(
                                'def_id_fac' => $fac_id,
                                'def_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                                'def_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'def_id_fao' => (trim($formula_id) != "") ? $formula_id : null,
                                'def_id_lip' => $idlip,
                                'def_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                //'def_id_bod' => (trim($bodega_factura[$x]) != "") ? $bodega_factura[$x] : null,
                                'def_id_axc' => (trim($axc_id_art_cotizacion[$x]) != "") ? $axc_id_art_cotizacion[$x] : null,
                                'def_valor_formula' => (trim($formula) != "") ? $formula : null,
                                'def_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'def_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'def_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'def_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'def_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'def_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'def_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'def_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'def_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'def_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'def_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'def_fecha_vence_garantia' => $fecha_def,
                                'def_dias_garantia' => (trim($fecha_text_garantia[$x]) != "") ? $fecha_text_garantia[$x] : null,
                                'def_precio_inventario' => $dtf_costo_venta_por_producto[$x],
                                'def_estado' => 1,
                                'def_usu_crea' => $this->tank_auth->get_user_id(),
                                'def_fecha_crea' => date('Y-m-d H:i:s'),
                                'def_usu_mod' => $this->tank_auth->get_user_id(),
                                'def_fecha_mod' => date('Y-m-d H:i:s')
                            );
                            $def_id = $this->gsatelite->ingresar('def_detalle_fact', $detalle_factura);

                        // ingresamos el detalle de los anticipos ///
                        if (($registrar_detalle_anticipo == true) && (is_array($array_facturas_id)) ) {
                            $registros = count($array_facturas_id);
                            for ($i=0; $i < $registros ; $i++) {
                               $array_data = array(
                                    'dfa_id_def'                => $def_id,
                                    'dfa_id_fac'                => $array_facturas_id[$i]['factura'],
                                    'dfa_monto_utilizado'       => $array_facturas_id[$i]['utilizado'],
                                    'dfa_saldo'                 => $array_facturas_id[$i]['saldo'],
                                    'dfa_fecha'                 => date('Y-m-d H:i:s'),
                                    'dfa_estado'                => $array_facturas_id[$i]['estado'],
                                    'dfa_usu_crea'              => $this->tank_auth->get_user_id(),
                                    'dfa_fecha_crea'            => date('Y-m-d H:i:s'),
                                    'dfa_fecha_mod'             => date('Y-m-d H:i:s')
                               );
                               $this->gsatelite->ingresar('dfa_detalle_factura_anticipo',$array_data);
                            }
                        }
                        ////////////////////////////////////////////

                            //Actualizar valores de axc_articuloxcotizacion(axc_cantidad_facturada, axc_cantidad_pendiente)
                            //En caso que sea una facturacion parcial por cotizacion
/*                            if($dtg_cotizacion > 0){
                                //$axc_cant = (trim($cantidad_inicial[$x]) != "") ? $cantidad_inicial[$x] : 0;
                                $axc_cant_base = (trim($axc_cantidad_base[$x]) != "") ? $axc_cantidad_base[$x] : 0;
                                $axc_cant_fac_base = (trim($axc_cantidad_facturada_base[$x]) != "") ? $axc_cantidad_facturada_base[$x] : 0;
                                $axc_cant_pend_base = (trim($axc_cantidad_pendiente_base[$x]) != "") ? $axc_cantidad_pendiente_base[$x] : 0;

                                $axc_cant_fac = (trim($cantidad_factura_convertida[$x]) != "") ? $cantidad_factura_convertida[$x] : 0;
                                $axc_pen = $axc_cant_pend_base - $axc_cant_fac;

                                //Array con los datos para actualizar
                                $axc_articuloxcotizacion = array(
                                    //'axc_cantidad' => $axc_cant,
                                    'axc_cantidad_facturada' => $axc_cant_fac + $axc_cant_fac_base,
                                    'axc_cantidad_pendiente' => $axc_pen

                                );
                                //Se actualizan el valor facturado, el pendiente, y la cantidad adicional
                                $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $axc_articuloxcotizacion, array('axc_id'=>$axc_id_art_cotizacion[$x]));

                                //Valida si el total pendiente de facturar(de esta y las anteriores es 0 o menor por sobre giros)
                                //y dependiendo de eso se actualiza el estado
                                //(1=pendiente, 2=parcial, 3=finalizado)
                                $cot_estado_facturacion = 1;
                                if($axc_pen <= 0){
                                    $cot_estado_facturacion = 3;
                                }else{
                                    $cot_estado_facturacion = 2;
                                }
                                //Actualizar el estado de la cotizacion
                                $array_cotizacion_estado_fac = array(
                                    'cot_estado_facturacion' => $cot_estado_facturacion
                                );
                                $this->gsatelite->actualizar_array('cot_cotizacion', $array_cotizacion_estado_fac, array('cot_id'=>$dtg_cotizacion));
                            }*/

                            /*if($inscripcion_fac[$x]!=''){
                               $this->gsatelite->actualizar_array('lxp_alumnoxpensum', array('lxp_tipo_inscripcion'=>2, 'lxp_id_fac'=>$fac_id, 'lxp_id_def'=>$def_id, 'lxp_fecha_mod'=>date('Y-m-d H:i:s'), 'lxp_usu_mod'=>$this->tank_auth->get_user_id()), array('lxp_id'=>$inscripcion_fac[$x]));
                            }*/


                            //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                            $impuesto_ids = explode(",", $impuesto_array[$x]);
                            $impuesto_por = explode(",", $impuesto_por_array[$x]);
                            for ($k = 0; $k < count($impuesto_ids); $k++) {
                                if ($impuesto_ids[$k] != 0) {
                                    if (trim($impuesto_por[$k]) != "") {
                                        //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                        //$monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                        $monto_temp = $subtotal_factura[$x] * ($array_porcentaje[$impuesto_ids[$k]] / 100);
                                        //tabla ixf_impuestoxfactura
                                        $detalle_impuesto = array(
                                            'ixf_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                            'ixf_id_def' => $def_id,
                                            'ixf_monto' => $monto_temp,
                                            'ixf_porcentaje' => $array_porcentaje[$impuesto_ids[$k]],
                                            'ixf_estado' => 1,
                                            'ixf_usu_mod' => $this->tank_auth->get_user_id(),
                                            'ixf_fecha_mod' => date('Y-m-d H:i:s'),
                                            'ixf_fecha_crea' => date('Y-m-d H:i:s'),
                                            'ixf_usu_crea' => $this->tank_auth->get_user_id()
                                        );
                                        $this->gsatelite->ingresar('ixf_impuestoxfactura', $detalle_impuesto);
                                    }
                                }
                            }

                            $retencion_ids = explode(",", $retencion_array[$x]);
                            $retencion_por = explode(",", $retencion_por_array[$x]);
                            $retencion_valor = explode(",", $retencion_por_array_val[$x]);

                            for ($k = 0; $k < count($retencion_ids); $k++) {
                                if ($retencion_ids[$k] != 0) {
                                    if (trim($retencion_por[$k]) != "") {
                                        if($retencion_por[$k]>0){
                                            $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                        }else{
                                            $monto_temp = $retencion_valor[$k];
                                        }
                                        // Tabla rxf_retencionxdetalle_factura
                                        $detalle_retencion = array(
                                            'rxf_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                            'rxf_id_def' => $def_id,
                                            'rxf_monto' => $monto_temp,
                                            'rxf_estado' => 1,
                                            'rxf_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'rxf_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'rxf_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'rxf_usu_modificacion' => $this->tank_auth->get_user_id()
                                        );
                                        $this->gsatelite->ingresar('rxf_retencionxdetalle_factura', $detalle_retencion);
                                    }
                                }
                            }

                            for ($y = 0; $y < count($caracteristicas_id); $y++) {
                                //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                                if ($tipo[$x] == 0) {

                                } else if ($tipo[$x] == 1) {
                                    // Toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                    $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                } else if ($tipo[$x] == 2) {
                                    // Toma los valores de las cajas escondidas despues de aplicar la formula se almacenan en estas
                                    // Si no se a seleccionado ninguna formula, entonces el valor de las cajas que se toma seria las visibles
                                    if ($formula != "") {
                                        $caracteristicas_id_valor = $this->input->post('valor_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                    } else {
                                        $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                    }
                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos_factura[$x] . '_' . $caracteristicas_id[$y].'_'.$correlativo[$x]); //array
                                }
                                if ($tipo[$x] != 0) {
                                    if (trim($caracteristicas_id_valor) != "") {
                                        //se guardara en la tabla cxd_caracteristicaxdetalle_factura
                                        $caracteristicas_factura = array(
                                            'cxd_id_def' => $def_id,
                                            'cxd_id_cxu' => (trim($caracteristicas_id[$y]) != "") ? $caracteristicas_id[$y] : null,
                                            'cxd_valor' => (trim($caracteristicas_id_valor) != "") ? $caracteristicas_id_valor : null,
                                            'cxd_descripcion' => (trim($caracteristicas_id_descripcion) != "") ? $caracteristicas_id_descripcion : null,
                                            'cxd_estado' => 1,
                                            'cxd_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cxd_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cxd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cxd_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('cxd_caracteristicaxdetalle_factura', $caracteristicas_factura);
                                    }
                                }
                            }

                            // Si se agotaron los correlativos, se actualiza la cxj en estado 0
                            if (isset($cxj_verificar) && $cxj_verificar['factura_rest'] == 1) {
                                $this->gsatelite->actualizar_array('cxj_correlativoxcaja', array('cxj_estado' => 0), array('cxj_id' => $this->input->post('dtf_correlativo')));
                            }

                            /* ====================================================================================================================
                                                                COMPONENTES
                            ======================================================================================================================*/
                            $identificador = '_'.$productos_factura[$x].'_'.$correlativo[$x];

                            /* para descargar de bodega             type array*/
                            $descargar_componente = $this->input->post('producto_descargar_componente'.$identificador);
                            $tipo_componente = $this->input->post('producto_tipo_componente'.$identificador);
                            $bodega_componente = $this->input->post('bodega_componente_id'.$identificador); // no es arreglo

                            /* detalle para guardar                 type array*/
                            $producto_componente = ($this->input->post('producto_componente'.$identificador) != '')?$this->input->post('producto_componente'.$identificador):'';
                            $medida_componente = $this->input->post('medida_componente'.$identificador);
                            $cantidad_componente = $this->input->post('cantidad_conv_componente'.$identificador);

                            $precio_componente = $this->input->post('precio_componente'.$identificador);
                            $subtotal_componente = $this->input->post('subtotal_componente'.$identificador);
                            $descripcion_componente = $this->input->post('descripcion_componente'.$identificador);

                            $alternar_componente = $this->input->post('alternar_componente'.$identificador);
                            $mostrar_descripcion_componete = $this->input->post('showdesc_componente'.$identificador);

                            $fecha_creacion = date('Y-m-d H:i:s');
                            $componente_sav = array();
                            if($producto_componente != ''){
                                foreach ($producto_componente as $id_comp => $comp) {
                                    if ($descargar_componente[$id_comp] == 1 && $tipo_componente[$id_comp] == 0) {
                                        $productos_id_moi[] = $comp;
                                        $produtos_cantidad_moi[] = $cantidad_componente[$id_comp];
                                        $productos_medida_moi[] = $medida_componente[$id_comp];
                                        $producto_bodega_moi[] = $bodega_componente;
                                    }

                                    $componente_sav[] = array(
                                        'cdf_id_def' => $def_id,
                                        'cdf_id_cva' => $medida_componente[$id_comp],
                                        'cdf_descripcion' => $descripcion_componente[$id_comp],
                                        'cdf_cantidad' => $cantidad_componente[$id_comp],
                                        'cdf_precio' => $precio_componente[$id_comp],
                                        'cdf_subtotal' => $subtotal_componente[$id_comp],
                                        'cdf_total' => $subtotal_componente[$id_comp],
                                        'cdf_altera_precio' => $alternar_componente[$id_comp],
                                        'cdf_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                        'cdf_estado' => 1,
                                        'cdf_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'cdf_fecha_creacion' =>  $fecha_creacion,
                                        'cdf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdf_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                                $this->gsatelite->ingresar('cdf_componente_detalle_factura', $componente_sav, true);
                            }
                            /* ====================================================================================================================
                                                                CENTRO COSTO
                            ======================================================================================================================*/

                            $centro_costo_costo = ($this->input->post('centro_costo_costo'.$identificador) != '')?$this->input->post('centro_costo_costo'.$identificador):'';
                            $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo'.$identificador);
                            $cuenta_contable_costo = $this->input->post('cuenta_contable_costo'.$identificador);
                            $porcentaje_costo = $this->input->post('porcentaje_costo'.$identificador);
                            $subtotal_costo = $this->input->post('subtotal_costo'.$identificador);
                            $pais_costo = $this->input->post('pais'.$identificador);

                            $costo_sav = array();
                            if($centro_costo_costo != ''){
                                foreach ($centro_costo_costo as $id_cost => $costo) {
                                    $costo_sav[] = array(
                                        'dcf_id_def' => $def_id,
                                        'dcf_id_cec' => $centro_costo_costo[$id_cost],
                                        'dcf_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                        'dcf_id_cnt' => $cuenta_contable_costo[$id_cost],
                                        'dcf_id_pai' => ($pais_costo[$id_cost] != "")?$pais_costo[$id_cost]:null,
                                        'dcf_porcentaje' => $porcentaje_costo[$id_cost],
                                        'dcf_monto' => $subtotal_costo[$id_cost],
                                        'dcf_estado' => 1,
                                        'dcf_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'dcf_fecha_creacion' =>  $fecha_creacion,
                                        'dcf_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'dcf_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                                $this->gsatelite->ingresar('dcf_detalle_centrocostoxfactura', $costo_sav, true);
                            }
                        }
                    }

                    /*************************** INSCRIPCIÓN DE ALUMNO (GRADO) *********************************************/
/*                    $grado = ($this->input->post('inscripcion_grd_factura'))?$this->input->post('inscripcion_grd_factura'):null;

                    if($grado!=null){
                        $inscripcion = $this->generar_inscripcion_grado($dtg_cliente, $grado[0], $fac_id, $def_id);
                    }*/
                    /**********************************************************************************************************/


/*                    if (count($productos_id_moi) > 0 && $id_dup_fac_devolucion <= 0) {
                        $this->crear_movimiento($fac_id, $producto_bodega_moi, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi, $bodegas_all);
                    }
                    elseif ($id_dup_fac_devolucion > 0) { // si es factura de anulación realizar una entrada especial para inventario
                        $this->crear_movimiento_devolucion($fac_id, $producto_bodega_moi, $productos_id_moi, $produtos_cantidad_moi, $productos_medida_moi, $bodegas_all);
                    }*/

                    /* ======================================================================================================
                                        Inicio Partida contable para facturacion afecta/no afecta inventario
                    =========================================================================================================*/
                    //die();
                    $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
                    if($generar_partida > 0 && $id_dup_fac_devolucion <= 0){
                        $where['fac_id'] = $fac_id;
                        $info['num_fac'] = $dtf_factura;
                        $info['fac_fecha_conta'] = $dtf_fecha_conta;
                        $res_debe = $this->generar_partida_factura_afecta_noafecta_inv_debe($where,$info);
                        $this->generar_partida_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_haber']);
                        //Insertando los detalles
                        if(count($res_debe['array_detalle_partida']) > 0){
                              $this->gsatelite->ingresar('dpc_detalle_partida', $res_debe['array_detalle_partida'], true);
                        }

                        //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida
                        //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                        $this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct' => $res_debe['id_pct'], 'fac_generacion_partida' => 1),array('fac_id' => $fac_id));

                        /* ======== Contrapartida en caso de tener productos que afecten inventario ======== */
                        $where_existe['fac_id'] = $fac_id;
                        $where_existe['art_inventario'] = 1;
                        $afecta_inv = $this->facturacion_model->existe_prod_afec_inv($where_existe);
                        //print_r($afecta_inv); die();
                        if($afecta_inv[0]['afecta_inv'] && $generar_partida == 2){
                            $where['cec_id']  = ($dtf_centro_costo) ? $dtf_centro_costo : 0;

                            $res_debe = $this->generar_contra_partida_factura_afecta_afecta_inv_debe($where,$info);
                            //print_r($res_debe); die();
                            $this->generar_contra_partida_factura_afecta_inv_haber($where, $res_debe['id_pct']);
                        }

                    }
                    /* ======================================================================================================
                                        Fin Partida contable para facturacion afecta/no afecta inventario
                    =========================================================================================================*/
                    if ($tipo_fact_elect == 1) {
                        $datos =  $this->generar_datos_factura_electronica($fac_id);
                        $fact_elect = array( 'fac_tipo_facturacion' => 1, 'fac_codigo_generacion' => $datos['cod_generation'], 'fac_numero_control' => $datos['num_control'] );
                        $this->gsatelite->actualizar_array("fac_factura", $fact_elect, array("fac_id" => $fac_id));
                        $this->crear_json_fact($fac_id);
                        $this->enviar_facturacion_sat($fac_id);
                    }
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente, con el número: ".$dtf_factura);

                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
                }
            }

        /* REDIRECCIONES */
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata('id_factura', $fac_id);
            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('usu_dir');
            if($dir>0){
                $direct = '/0/1';
                $dir_pago = '/1';
            }else{
                $direct = '';
                $dir_pago = '';
            }


            //if ($redireccion == 0) {

                /*if (isset($id_dup_fac_devolucion) && $id_dup_fac_devolucion > 0) {
                    redirect('facturacion/facturar/factura_devolucion/');
                }
                if($dir>0){
                    $this->session->set_flashdata($alerta);
                    redirect('facturacion/facturar/crear_factura'.$direct);
                }else{
                    $this->session->set_flashdata($alerta);
                    redirect('facturacion/facturar/crear_factura/');
                }*/
                $this->session->set_flashdata($alerta);
                redirect('facturacion/facturar/nota_debito');
            /*} else if ($redireccion == 1) {
                if($dir>0){
                    redirect('facturacion/facturar/factura_caja');
                }else{
                    redirect('facturacion/facturar/factura/');
                }
            } else {
                redirect('facturacion/facturar/crear_pago_factura/' . $dtg_cliente . '/' . $fac_id.'/1'.$dir_pago);
            }*/
        }
    }
    /************FIN GUARDAR NOTA DE CREDITO**********************/
    
    /**
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-07-09
     * @return vista de una nota de debito
     */
    function nota_remision($fecha_inicio = null, $fecha_fin = null, $tipo = null, $usu=null) {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '9999');
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['parametros'] = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            $permisos = $this->gsatelite->get_permisos_opcion();
            
            // Declaracion de variables
            if ($tipo){
                $url_padre = uri_string();
            }
            if($usu != null) {
                $data['usu'] = $usu;
                $flag='/1';
            } else {
                $flag='/0';
            }
            if ($fecha_inicio == null && $fecha_fin == null) {
                $fecha_inicio = $this->input->post('txtFechaIni');
                $fecha_fin = $this->input->post('txtFechaFin');
            }
            $tipoFactura = ( $this->input->post('tipo_fac') != "" ) ? $this->input->post('tipo_fac') : "";
            $output = null;
            $crud = new grocery_CRUD();
            if (trim($fecha_inicio) != '') {
                if ($fecha_inicio != '' && $fecha_fin != '') {
                    $crud->where('DATE(fac_fecha_fact) >=', date('Y-m-d', strtotime($fecha_inicio)));
                    $crud->where('DATE(fac_fecha_fact) <=', date('Y-m-d H:i:s', strtotime($fecha_fin)));
                    //validar que si es la opción de fatura-caja solo muestre las del usuario logueado, si es la de facturar muestre todo.
                    if(substr_count($_SERVER['HTTP_REFERER'], 'factura_caja') > 0 ){
                        $crud->where('fac_usu_crea', $this->tank_auth->get_user_id());
                    }
                }
                if ($tipoFactura != '') {
                    $crud->where('fac_id_tif =', $tipoFactura);
                }
                if($usu != null){
                    $usuarios = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id_usu'=>$usu));
                    $ids = array_column($usuarios, 'uxc_id');
                    $cadena = implode(',', $ids);
                    if(count($ids)>0){
                        $crud->where('fac_id_uxc IN ('.$cadena.')', null, FALSE);
                    }
                }
                $crud->where('fac_estado >', 0);
                $crud->where('fac_id_tif =', $data['parametros']['NOTA REMISION']);
                $display_as = array(
                    'fac_numero'        => 'Número',
                    'fac_id_cli'        => 'Cliente',
                    'pcl_codigo'        => 'Proyecto',
                    'fac_observacion'   => 'Observacion',
                    'fac_fecha_fact'    => 'Fecha',
                    'fac_total'         => 'Total',
                    'remision'          => 'Estado',
                    'fac_id_tif'        => 'Tipo factura'
                );

                $columns = array(
                    'fac_id_tif',
                    'fac_numero',
                    'fac_id_cli',
                    'pcl_codigo',
                    'fac_observacion',
                    'fac_fecha_fact',
                    'fac_total',
                    'remision'
                );

                $crud->set_subject('Factura');
                $crud->set_table('fac_factura');
                $crud->columns($columns);
                //$crud->display_as('fac_id_tif', 'Tipo factura');
                $crud->display_as($display_as);
                $crud->set_relation('fac_id_tif', 'tif_tipo_factura', 'tif_nombre');
                $crud->callback_column('pcl_codigo', function($value, $row) {
                    $proyecto = $this->gsatelite->get_campo('pcl_proyecto_cliente', 'pcl_codigo', array('pcl_id' => $row->fac_id_pcl));
                    return $proyecto;
                });
                //$crud->set_relation('fac_id_cli', 'cli_cliente', '{cli_nombre} {cli_apellido}');
                $crud->field_type('fac_estado', 'dropdown', array('2' => 'Finalizado', '1' => 'Pendiente', '0' => 'Anulada'));
                $crud->callback_column('fac_id_cli', function($value, $row) {
                    $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $row->fac_id_cli));
                    $regresar = '';
                    if ($clientes[0]['cli_personeria'] == 1) {
                        $regresar = $clientes[0]['cli_codigo'] .' '. $clientes[0]['cli_nombre'] . ' ' . $clientes[0]['cli_apellido'];
                    } else {
                        $regresar = $clientes[0]['cli_codigo'] .' '. $clientes[0]['cli_apellido'];
                    }
                    return $regresar;
                });
                $crud->callback_column('fac_fecha_fact', function($value, $row) {
                    $fecha = (trim($row->fac_fecha_fact) != "") ? formatear_fecha('Y-m-d', trim($row->fac_fecha_fact)) : "";
                    return $fecha;
                });
                $crud->callback_column('remision', function($value, $row) {
                    //LAS NO FACTURADAS NO EXISTEN EN LA fxr_factura_remisionxfactura HASTA QUE SON LLAMADAS PARA UNA FACTURA PADRE
                    $hay_padre = $this->gsatelite->get_tabla('fxr_factura_remisionxfactura', array('fxr_id_fac_remision' => $row->fac_id));
                    return (count($hay_padre) > 0) ? 'Facturada' : 'No Facturada';
                });
                $crud->callback_column('fac_total', function($value, $row) {
                    $total = '$' . number_format($row->fac_total-$row->fac_total_retencion, 2);
                    return $total;
                });
                //proceso para cambiar color de tr cuando la facturacion aplica domicilio
                $crud->callback_column('fac_numero',function($value, $row){
                     $domicilio = $row->fac_aplica_domicilio;
                     $entregado_domicilio = $row->fac_entregado_domicilio;

                     if($domicilio > 0 && $entregado_domicilio == 0){
                        return "<label class='color_tr' data-color='#4ac718'>".$value."</label>";
                     } else return $value;
                });

                $crud->unset_add();
                $crud->unset_edit();
                $crud->unset_delete();
                $crud->unset_read();
                if (!$permisos["permite_ver"]) {
                    $crud->unset_print();
                    $crud->unset_export();
                }

                $crud->add_action('&nbsp;&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_factura', 'icomoon-icon-copy-2 imprimir crud-action');
                    /*$crud->add_action('&nbsp;&nbsp;Pago', '', 'facturacion/facturar/pagar_factura', 'icomoon-icon-coins', null,'', "[fac_estado] == 'Pendiente'");
                    $crud->add_action('&nbsp;&nbsp;Historial', '', 'historial', 'icomoon-icon-history mostrar_historial');
                    $crud->add_action('&nbsp;&nbsp;Duplicar', '', 'facturacion/facturar/duplicar_factura'.$flag, 'icomoon-icon-copy-2', null,'', "![fac_id_origen_devolucion] > 0");
                    $crud->add_action('&nbsp;&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_factura', 'icomoon-icon-copy-2 imprimir');
                    $crud->add_action('&nbsp;&nbsp;Editar', '', 'facturacion/facturar/editar_factura', 'icomoon-icon-copy-2 editar', null,'', "[fac_estado] == 'Pendiente' or ![fac_estado] == 'Pagado'");
                    $crud->add_action('&nbsp;&nbsp;Domicilio', '', 'facturacion/facturar/historial_domicilio', 'icomoon-icon-checkmark  fac_domicilio', null,'', "[fac_aplica_domicilio] == 1");*/
                $crud->order_by('fac_id', 'asc');
                $output = $crud->render();
            }
            $data['es_devolucion'] = 0;
            $data['user'] = $usu;
            $data['add_factura'] = $permisos["permite_agregar"];
            $data['titulo_personal'] = "Nota de Remisión";
            //print_r($data['parametros']);die();
            if ($tipo == null) {
                cargarvista($data, $output, 'facturacion/facturar/nota_remision');
            } else {
                print($output->output);
            }
        }
    }

/**
     *
     *
     * @autor Marlon Olmedo
     * @since 17/07/2019
     * @param hace la pantalla para la nota de remision.
     */
    function crear_nota_remision($orv_id = null, $tipo=null, $fac_id= null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $datos["titulo_personal"] = "Nota de Remisión";
            $persona_array = array();
            $nombre_fac = '';
            $observacion_fac = '';
            $idvendedor = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $this->tank_auth->get_user_id()));
            $orden_venta_reg = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id' => $orv_id, 'orv_estado' =>1 ));
            if(count($orden_venta_reg) > 0){
                $orden_venta_det_reg = $this->gsatelite->get_tabla('pxo_personalxorden_venta', array('pxo_id_orv'=>$orden_venta_reg[0]['orv_id']));
                foreach ($orden_venta_det_reg as $key) {
                    $persona_array[] = $key['pxo_id_emp'];
                }
                $nombre_fac = $orden_venta_reg[0]['orv_nombre_factura'];
                $observacion_fac = $orden_venta_reg[0]['orv_observacion'];
            }
            $datos['nombre_factura'] = $nombre_fac;
            $datos['observacion_factura'] = $observacion_fac;
            $datos['orv_id'] = ($orv_id > 0) ? $orv_id : '';
            $datos['tipo'] = $tipo;
            /* PEDIR UNICAMENTE LOS OPTIONS PARA LLENAR LOS SELECTS */
            $clidefct = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO')));
            if (count($clidefct) > 0) {
                $datos['iddf'] = $clidefct[0]['cli_id'];
                $nombre_def = $clidefct[0]['cli_codigo'] . ' - ';
                $nombre_def .= ($clidefct[0]['cli_personeria'] > 1) ? $clidefct[0]['cli_apellido'] : $clidefct[0]['cli_nombre'] . ' ' . $clidefct[0]['cli_apellido'];
                $datos['namedf'] = $nombre_def;
                $datos["cliente_defecto"] = $clidefct[0]['cli_id'];
            } else {
                $datos['iddf'] = "";
                $datos['namedf'] = "";
                $datos["cliente_defecto"] = "";
            }
            if(count($orden_venta_reg) > 0){
                $cliorv = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $orden_venta_reg[0]['orv_id_cli']));
                $datos['iddf'] = $orden_venta_reg[0]['orv_id_cli'];
                $nombre_orv = $cliorv[0]['cli_codigo'] . ' - ';
                $nombre_orv .= ($cliorv[0]['cli_personeria'] > 1) ? $cliorv[0]['cli_apellido'] : $cliorv[0]['cli_nombre'] . ' ' . $cliorv[0]['cli_apellido'];
                $datos['namedf'] = $nombre_orv;
            }
            $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            $datos['cajas'] = $this->facturacion_model->datos_usuario_caja($rol);
            $caj_id_cec_defecto = ($datos["cajas"])? $datos["cajas"][0]['caj_id_cec_defecto']:0;
            $date1 = formatear_fecha('d-m-Y', $datos['cajas'][0]['uxc_fecha_crea']);
            $date2 = date('d-m-Y', time());
            $date3 = formatear_fecha('d-m-Y', $datos['cajas'][0]['uxc_fecha_proceso']);
            $datos['fecha_caja'] = ($datos['cajas'][0]['uxc_fecha_utiliza'] > 0 || ($date2 <= $date1 || $date3 >= $date2)) ? 1 : 2;
            $user=$this->tank_auth->get_user_id();
            $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu'=>$user));
            $empsuc = (count($empleado) > 0) ? $empleado[0]['emp_id_suc'] : null;
            $sucursal_drop = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, $empsuc, '', 'suc_id', true);
            $datos['sucursal'] = str_replace('<option value="0">Seleccione</option>', '', $sucursal_drop);
            $sucursal_cli = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_nombre}', '', array('scl_estado'=>1), null, '', 'scl_id', true);
            $datos['sucursal_cli'] = str_replace('<option value="0">Seleccione</option>', '', $sucursal_cli);
            $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
            if (is_null($parametros['NOTA REMISION']) || !($parametros['NOTA REMISION'] > 0)) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => 'Configure el valor NOTA REMISION en el parámetro: "SYS_TIPO_FACTURAS"');
                $this->session->set_flashdata($alerta);
                redirect(base_url('facturacion/facturar/nota_remision'));
                die();
            }
            $tipos_factura=$this->gsatelite->get_dropdown('tif_tipo_factura','{tif_nombre}','',array('tif_estado'=>1,'tif_id'=>$parametros['NOTA REMISION']),$parametros['NOTA REMISION'],'','tif_id', true);
            $datos["tipos_factura"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipos_factura);

            $tipos_pago = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), null, '', 'tpg_id', true);
            $datos["tipos_pago"] = str_replace('<option value="0">Seleccione</option>', '', $tipos_pago);
            $formas_pago = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => '1'), null, '', 'frp_id', true);
            $datos["formas_pago"] = str_replace('<option value="0">Seleccione</option>', '', $formas_pago);
            $formas_envio = $this->gsatelite->get_dropdown('frv_forma_envio', '{frv_nombre}', '', array('frv_estado' => '1'), null, '', 'frv_id', true);
            $datos["formas_envio"] = str_replace('<option value="0">Seleccione</option>', '', $formas_envio);
            $transporte = $this->gsatelite->get_dropdown('ttr_tipo_transporte', '{ttr_nombre}', '', array('ttr_estado' => '1'), null, '', 'ttr_id', true);
            $datos["transporte"] = str_replace('<option value="0">Seleccione</option>', '', $transporte);

            //datos factura
            $series = $this->facturacion_model->nuevas_series_cargar();
            $series1 = '';
            foreach ($series as $key) {
                $series1 .= '<option value="' . $key['sef_id'] . '" >'/* .$key['sef_nombre'].' ' */ . $key['sef_nombre'] . '</option>';
            }
            $datos["series"] = str_replace('<option value="0">Seleccione</option>', '', $series1);
            $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto'=> 1, 'arf_estado'=> 1));
            if(count($orden_venta_reg) > 0){
                $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $orden_venta_reg[0]['orv_id_arf'], '', 'arf_id', true);
            } else{
                $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_defecto, '', 'arf_id', true);
            }
            $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);

            /* Centro de Costo por Defecto */
            $empresa     = $this->tank_auth->get_empresa_id();  // Empresa que se ha seleccionado cuando se ha logueado
            $this->db->where("(cec_id_emr=$empresa OR cec_id_emr IS NULL)");$this->db->limit(1);
            $cec_defecto = $this->gsatelite->get_campo('cec_centro_costo', 'cec_id', array('cec_defecto'=>1, 'cec_estado'=>1));
            $cec_defecto = ($caj_id_cec_defecto > 0)? $caj_id_cec_defecto:$cec_defecto;
            $costo_drop = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => '1'), $cec_defecto, '', 'cec_id', true);
            $datos["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '', $costo_drop);
            /* *************************** */
            $data['filtro'] = $filtro = $this->gsatelite->get_parametro('SYS_FAC_FILTRO_VENDEDOR');
            $ven_selected = null;
            if($filtro==1){
                $user = $this->tank_auth->get_user_id();
                $vendedor = $this->gsatelite->get_registro('ven_vendedor', array('ven_id_usu'=>$user));
                if(count($vendedor)>0){
                    $ven_selected = $vendedor->ven_id;
                }
            }
            if ($orv_id>0) {
                $ven_selected = $orden_venta_reg[0]['orv_id_ven'];
            }

            $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), $ven_selected, '', 'ven_id', true);
            $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores);

            $select = "";
            $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => '1'));
            foreach ($tip_venta_reg as $key) {
                $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '">' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
            }
            $datos["tipo_venta"] = $select;

            // obtener las bodegas
            // $descargar = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
            $monto_zero = $this->gsatelite->get_parametro('SYS_MONTO_ZERO');
            $datos["monto_zero"] = $monto_zero;
            // if ($descargar == 1) {
            //     //  $bodegas = $this->gsatelite->get_dropdown('bod_bodega', '{bod_nombre}','', array('bod_estado' => '1'), null, '', 'bod_id', true);
            //     //  $datos['bodega'] = str_replace('<option value="0">Seleccione</option>', '',$bodegas);
            // }
            /* $cadena_in = (count($cadena_in) <= 0) ? array(0) : $cadena_in;
              $this->db->where_in('tia_id', $cadena_in);
              $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} {tia_nombre}', '', array('tia_estado' => '1'), null, '', 'tia_id', true);
              //$datos["categorias"] = str_replace('<option value="0">Seleccione</option>', '', $categorias); */
            $datos["categorias"] = $this->obtener_categoriaxbodega2();//antes estaba obtener_categoriaxbodega sin el 2

            $select = "";
            $impuesto_campos = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1));
            foreach ($impuesto_campos as $key) {
                if ($key["imp_defecto"] == 1) {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "' selected>" . $key["imp_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["imp_porcentaje"] . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                }
            }
            $datos["impuestos"] = $select;
            $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
            $datos['permite_mas_productos'] = (trim($permite_mas_productos) != '')?$permite_mas_productos:0;
            $select = "";
            $retencion_campos = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
            foreach ($retencion_campos as $key) {
                if ($key["ret_defecto"] == 1) {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "' selected>" . $key["ret_nombre"] . "</option>";
                } else {
                    $select .= "<option porcentaje='" . $key["ret_porcentaje"] . "' value='" . $key["ret_id"] . "'>" . $key["ret_nombre"] . "</option>";
                }
            }
            $datos["retencion"] = $select;

            $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu'=>$user));
            $select = "";
            foreach ($bodegas_reg as $key) {
                $selected = ($key['uxb_defecto'] == 1)?'selected':'';
                $select .= '<option value="'.$key['bod_id'].'" '.$selected.'>'.$key['bod_nombre'].'</option>';
            }
            $datos["bodega_prefe"] = $select;
            $datos["id"] = $user;
            $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $persona_array, '', 'emp_id', true);
            $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_select);

            $decimales  = $this->gsatelite->get_tabla("par_parametro",array('par_codigo' => 'NUMERO_DECIMALES'));
            $datos["cantidad_decimales"] = ($decimales[0]["par_valor"] != "" )?$decimales[0]["par_valor"]:$decimales[0]["par_default"];

            // Parametro para obtener el tipo de factura ticket
            $tipo_ticket         = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('TICKET'));
            $dias_antiguedad_saldo = $this->gsatelite->get_parametro('SYS_DIAS_ANTIGUEDAD_SALDO_FACTURACION');
            $datos["dias_antiguedad_saldo"] = ($dias_antiguedad_saldo != "")?$dias_antiguedad_saldo:"90";

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $autorizacion_descuento = $this->gsatelite->get_parametro_emp('SYS_AUTORIZACION_DESCUENTO_FACTURA', 1);
            $descuentos_globales = json_decode($this->gsatelite->get_parametro_emp('SYS_DESCUENTOS_GENERALES'), true);
            $supervisores_option = "";
            if ($autorizacion_descuento == 1) {
                $supervisores_option = $this->facturacion_model->get_supervisores_descuento( array( 'ven_id_usu' => $this->tank_auth->get_user_id() ) );
            }
            $datos['supervisores_option'] = trim($supervisores_option);
            $datos["autorizacion_descuento"] = $autorizacion_descuento;
            $datos['descuento_min_global'] = ($descuentos_globales != null) ? floatval($descuentos_globales['MINIMO']) : 0;
            $datos['descuento_max_global'] = ($descuentos_globales != null) ? floatval($descuentos_globales['MAXIMO']) : 0;
            $datos['modo_descuentos'] = ($this->gsatelite->get_parametro_emp('SYS_MODO_DESCUENTO_FACTURA') != "") ? $this->gsatelite->get_parametro_emp('SYS_MODO_DESCUENTO_FACTURA') : 2;
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $datos['tipo_ticket'] = ($tipo_ticket>0)?$tipo_ticket:0;
            $datos["show_option"] = $this->gsatelite->get_parametro('SYS_ELEMENTOS_MOSTRAR_FACTURA','1,1,1,1');
            $datos["cliente_defecto"] = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');
            $datos["focus_defecto_fact"] = $this->gsatelite->get_parametro('SYS_FOCUS_FACTURACION');            
                        $this->db->select('ret_id,ret_valor_minimo,ret_porcentaje');
            $data_ret = $this->gsatelite->get_tabla('ret_retencion',array('ret_estado'=>1,'ret_valor_minimo >'=>0));
            $datos["retencionesAuto"] = json_encode($data_ret);
            $producto_maximo = array();
            $configuraciones_factura = $this->gsatelite->get_tabla('frf_formato_factura', array('frf_activo'=>1));
            foreach ($configuraciones_factura as $key => $conf_fac) {
                $formato_array = json_decode($configuraciones_factura[$key]['frf_configuraciones_formato'], true);
                if(isset($formato_array["PRODUCTO_MAXIMO"])){
                    $key = key($formato_array["PRODUCTO_MAXIMO"]);
                    $producto_maximo[$key] = $formato_array["PRODUCTO_MAXIMO"][$key];
                }
            }
            if (!(empty($producto_maximo))) {
                $datos["producto_maximo"] = json_encode($producto_maximo);
            }
            $datos["activar_alerta_productox"] = $this->gsatelite->get_parametro('SYS_NOTIFICACION_EXISTENCIAX');
            $datos["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
            $this->_cargarvista($datos, null, 'facturacion/facturar/crear_nota_remision');
        }
    }

    function guardar_nota_remision() {
        // var_dump($_POST);die();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        //nota de remision np aplica guardado como orden de venta viene como 0.
        $guardar_como_orv = ($this->input->post('guardar_como_orv') > 0) ? 1 : 0;// SIEMPRE 0
        $tipo = ($this->input->post('usu_dir')!='')?$this->input->post('usu_dir'):null;//""
        /********************************************************************************************************/
        /* Verificar si no se han agotado los correlativos */
        $corr         = $this->input->post('dtf_correlativo');
        $cof          = $this->input->post('dtf_serie');
        $tif          = $this->input->post('dtg_tipo_factura');
        $inicio_fin   = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id'=>$corr, 'cxj_estado'=>1));
        $recorrer_fac = $this->generar_numero_factura($inicio_fin[0]['cxj_inicio'], $inicio_fin[0]['cxj_fin'], $cof, $tif, 0, 1);
        $cxj_verificar  = json_decode($recorrer_fac, true);
        $facturas_restantes = $cxj_verificar['factura_rest'];
        /********************* VERIFICA EXISTENCIA DE CORRELATIVO EN FACTURAS CREADAS ***************************/
        $dtf_factura = (trim($this->input->post('dtf_factura')) != "") ? $this->input->post('dtf_factura') : null;
        $reg_numero = $this->gsatelite->get_registro('fac_factura', array('fac_numero'=>$dtf_factura));
        if(count($reg_numero)>0){
            $dtf_factura = $cxj_verificar['resultado'];
        }
        /********************************************************************************************************/
        //Tab datos generales
        $dtg_cliente = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null;
        /* Sucursal asociado al cajero asignado */
        $dtg_sucursal = (trim($this->input->post('emp_sucursal')) != "") ? $this->input->post('emp_sucursal') : null;
        /****************************************/
        $sucursal_cli = (trim($this->input->post('slcSucursalCliente')) != "") ? $this->input->post('slcSucursalCliente') : null;
        $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
        $dtg_documento_factura = (trim($this->input->post('dtg_documento_factura')) != "") ? $this->input->post('dtg_documento_factura') : null;
        $dtg_tipo_factura = (trim($this->input->post('dtg_tipo_factura')) > 0) ? $this->input->post('dtg_tipo_factura') : null;
        $dtg_tipo_pago = (trim($this->input->post('dtg_tipo_pago')) > 0) ? $this->input->post('dtg_tipo_pago') : null;
        $dtg_forma_pago = (trim($this->input->post('dtg_forma_pago')) > 0) ? $this->input->post('dtg_forma_pago') : null;
        $dtg_cotizacion = (trim($this->input->post('dtg_cotizacion')) > 0) ? $this->input->post('dtg_cotizacion') : null;
        $dtg_orden = (trim($this->input->post('dtg_orden')) > 0) ? $this->input->post('dtg_orden') : null; 
        $dtg_envio = (trim($this->input->post('dtg_envio')) != "") ? $this->input->post('dtg_envio') : null; 
        $dtf_serie = (trim($this->input->post('dtf_serie')) > 0 ) ? $this->input->post('dtf_serie') : null;
        $dtf_correlativo = (trim($this->input->post('dtf_correlativo')) != "") ? $this->input->post('dtf_correlativo') : null;
        $dtf_fecha_fact = (trim($this->input->post('dtf_fech_fact')) != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s')) : null;
        $dtf_fecha_vence = (trim($this->input->post('dtf_fech_vence')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_vence')))) : null;
        $dtf_fecha_conta = (trim($this->input->post('dtf_fech_conta')) != "") ? formatear_fecha('Y-m-d', $this->input->post('dtf_fech_conta')) : date('Y-m-d');
        $dtf_fech_entrega = (trim($this->input->post('dtf_fech_entrega')) != "") ? date('Y-m-d', strtotime(trim($this->input->post('dtf_fech_entrega')))) : null;
        $dtf_area = (trim($this->input->post('dtf_area')) > 0) ? $this->input->post('dtf_area') : null;///////////////
        $dtf_centro_costo = (trim($this->input->post('dtf_centro_costo')) != "") ? $this->input->post('dtf_centro_costo') : null;
        $vendedor = (trim($this->input->post('vendedor')) > 0) ? $this->input->post('vendedor') : null;
        $personal = $this->input->post('personal'); //No aplicaria para este tipo de facturacion, vendria vacio
        $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
        $slcProyecto = ($this->input->post('slcProyecto') > 0) ? $this->input->post('slcProyecto') : null;
        $dtf_forma_envio = ($this->input->post('dtf_forma_envio') != '') ? $this->input->post('dtf_forma_envio') : null; 
        $dtf_transporte = ($this->input->post('dtf_transporte') != '') ? $this->input->post('dtf_transporte') : null; 
        $dtf_incoterms = ($this->input->post('dtf_incoterms') != '') ? $this->input->post('dtf_incoterms') : null; 
        $fac_orden_compra = ($this->input->post('fac_orden_compra') != '') ? $this->input->post('fac_orden_compra') : null;
        $dtf_orden_compra = ($this->input->post('dtf_orden_compra') != '') ? $this->input->post('dtf_orden_compra') : null;
        $imprime_cero = ($this->input->post('imp_cero') != '') ? 1 : 0;
        $es_traslado = $this->input->post('hdn_apply_traslado');
        $aplica_mov = $this->input->post('afecta_inv');
        
        //SI VIENE UN FAC_ID HAY QUE AGREGAR EN LA FXR
        $rem_ya_facturada = ($this->input->post('dtg_facturas_factura') > 0) ? $this->input->post('dtg_facturas_factura') : null;
        //Array costo de venta de producto por detalle
        $dtf_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? $this->input->post('costo_venta_por_producto') : null;
        $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
        $descuentoT_factura_total = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
        //$anticipo_factura_total = (trim($this->input->post('anticipo_factura_total')) != "")?$this->input->post('anticipo_factura_total'):0;
        $subtotal_factura_total = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
        $impuesto_factura_total = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
        $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
        $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
        $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi') : 0;
        //Valores actuales en la base de datos para el axc
        $axc_cantidad_base = ($this->input->post('axc_can_base') != '') ? $this->input->post('axc_can_base') : null;////////////////////////////////////////////PDTE REVISAR CASO
        $axc_cantidad_facturada_base = ($this->input->post('axc_can_facturada_base') != '') ? $this->input->post('axc_can_facturada_base') : null;//////////////PDTE REVISAR CASO
        $axc_cantidad_pendiente_base = ($this->input->post('axc_can_pendiente_base') != '') ? $this->input->post('axc_can_pendiente_base') : null;//////////////PDTE REVISAR CASO
        $anticipo_clien = $this->input->post('anticipo_clien');/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $caja = $this->input->post('caja_usuario');
        $fac_domicilio = ($this->input->post('facDomicilio') == true) ? 1 : 0;///////////////////////////////////////////////////////////////////////////////////NO SE SI DEJARLO
        
        // Se guarda un temporal del total de la factura para poder ir restando en cada repetición y se usa para detener la actualización de registros
        $total_temporal = $total_factura_total_origi;
        $total_temporal_2 = 0;  // Se usa para operar los anticipos
        $id_anticipo = 0;
        $saldo_restante = 0;
        $fin_anticipo = 0;
        $fin_anticipo_2 = 0;
        $monto_guardar = 0;
        $monto_actualizar = 0;
        $productos_id_moi = array();
        $produtos_cantidad_moi = array();
        $productos_medida_moi = array();
        $producto_bodega_moi = array();
        $alerta = "";
        //////VERIFICAR SI YA SE GUARDO ESA FACTURA EN CASOS DE MALA CONEXION O DOBLE CLICS
        $hora_maxima = strtotime('+10 second');
        $hora_minima = strtotime('-10 second');
        $fecha_f = trim($this->input->post('dtf_fech_fact'));
        $fecha_maxima_fact = ($fecha_f != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_maxima)) : null;
        $fecha_minima_fact = ($fecha_f != "") ? (formatear_fecha('Y-m-d', trim($this->input->post('dtf_fech_fact'))).' '.date('H:i:s', $hora_minima)) : null;
        $factura_where = array(
            'fac_id_cli' => $dtg_cliente,
            'fac_id_cof' => $dtf_serie,
            'fac_id_tpg' => $dtg_tipo_pago,
            'fac_id_uxc' => $caja,
            'fac_fecha_fact >= ' => $fecha_minima_fact, 'fac_fecha_fact <=' => $fecha_maxima_fact,
            'fac_fecha_cont' => $dtf_fecha_conta,
            'fac_fecha_crea >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_crea <=' => date('Y-m-d H:i:s',$hora_maxima),
            'fac_usu_crea' => $this->tank_auth->get_user_id(),
            'fac_usu_mod' => $this->tank_auth->get_user_id(),
            'fac_fecha_mod >= ' => date('Y-m-d H:i:s',$hora_minima), 'fac_fecha_mod <=' => date('Y-m-d H:i:s',$hora_maxima)
        );
        $factura_repetida = $this->gsatelite->get_tabla('fac_factura', $factura_where);
        if(count($factura_repetida) > 0){
            $fac_id = $factura_repetida[0]['fac_id'];
            $dtf_factura = $factura_repetida[0]['fac_numero'];
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente, con el número: ".$dtf_factura);
        } else{
            if($facturas_restantes == 1 || $facturas_restantes == 0){
                $actualizar_cxj = array(
                    'cxj_estado' => 0,
                    'cxj_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxj_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cxj_correlativoxcaja', $actualizar_cxj, array('cxj_id'=>$corr) );
            }
            //Se guarda la factura
            if ($dtg_cliente != "" && $dtf_correlativo != "" && $dtf_factura != "" && $dtf_fecha_fact != "" && $dtf_fecha_conta != "" && $dtf_fecha_vence != "") {
                $id_dup_fac_devolucion = ($this->input->post('id_dup_fac_devolucion')>0)? $this->input->post('id_dup_fac_devolucion'):0;
                // Verificar que la accion viene del boton pagar
                $pagar_rapido_fact     = ($this->input->post('pagar_rapido_fact')>0)? $this->input->post('pagar_rapido_fact'):0;
                // Obtener los valores de Recibe y cambio para procesar el pago
                $txt_monto_recibido    = ($this->input->post('txt_monto_recibido_')>0)? $this->input->post('txt_monto_recibido_'):0;
                $txt_monto_devolver    = ($this->input->post('txt_monto_devolver_')>0)? $this->input->post('txt_monto_devolver_'):0;
                if ($rem_ya_facturada > 0) {
                    $estado = 2;
                } else {
                    $estado = 1;
                }                    

                $factura = array(
                    'fac_id_cli' => $dtg_cliente,
                    'fac_id_ven' => $vendedor,
                    'fac_id_cof' => $dtf_serie,
                    'fac_id_suc' => $dtg_sucursal,
                    'fac_id_tpg' => $dtg_tipo_pago,
                    'fac_id_frp' => $dtg_forma_pago,
                    'fac_id_cot' => $dtg_cotizacion,
                    'fac_id_tif' => $dtg_tipo_factura,
                    'fac_id_arf' => $dtf_area,
                    'fac_id_cec' => $dtf_centro_costo,
                    'fac_id_ord' => $dtg_orden,
                    'fac_id_uxc' => $caja,
                    'fac_id_scl' => $sucursal_cli,
                    'fac_id_pcl' => $slcProyecto,
                    'fac_id_frv' => $dtf_forma_envio,
                    'fac_id_ttr' => $dtf_transporte,
                    'fac_incoterm' => $dtf_transporte,
                    'fac_numero' => $dtf_factura,
                    'fac_fecha_fact' => $dtf_fecha_fact,
                    'fac_fecha_cont' => $dtf_fecha_conta,
                    'fac_fecha_entrega' => $dtf_fech_entrega,
                    'fac_documento_cliente' => $dtg_documento_factura,
                    'fac_nombre_factura' => $dtg_nombre_factura,
                    'fac_observacion' => $observaciones,
                    'fac_imprime_cero' => $imprime_cero,
                    'fac_retencion_abono' => 0,
                    'fac_total_retencion' => str_replace(',', '', $retencion_factura_total),
                    'fac_subtotal' => str_replace(',', '', $subtotal_factura_total),
                    'fac_descuento' => str_replace(',', '', $descuentoT_factura_total),
                    'fac_impuesto' => str_replace(',', '', $impuesto_factura_total),
                    'fac_total' => str_replace(',', '', $total_factura_total),
                    'fac_monto_pendiente' => 0,
                    'fac_incoterm' => $dtf_incoterms,
                    'fac_orden_compra' => $dtf_orden_compra,
                    'fac_monto_abono' => str_replace(',', '', $total_factura_total),
                    'fac_dui_cliente_factura' => $this->input->post('info_complementaria_dui'),
                    'fac_nit_cliente_factura' => $this->input->post('info_complementaria_nit'),
                    'fac_residencia_cliente_factura' => $this->input->post('info_complementaria_residencia'),
                    'fac_fecha_crea' => date('Y-m-d H:i:s'),
                    'fac_usu_crea' => $this->tank_auth->get_user_id(),
                    'fac_usu_mod' => $this->tank_auth->get_user_id(),
                    'fac_fecha_mod' => date('Y-m-d H:i:s'),
                    'fac_estado' => $estado, //si no es traslado y no ha sido facturada se deja en 1 para que el detalle pueda ser halado por una factura normal y ahi se pasara a 2
                    'fac_aplica_domicilio'=>$fac_domicilio,
                    'fac_fecha_vencimiento' => $dtf_fecha_vence,
                    'fac_monto_anticipo' => 0,//NO VIENE EN EL POST
                    'fac_monto_saldo_anticipo' => 0,//NO VIENE EN EL POST
                    'fac_monto_usado_anticipo' => 0 //NO VIENE EN EL POST
                );
                $mov_fac_dev = array();
                if ($id_dup_fac_devolucion > 0) {
                    //NO SUCEDE EN EL FLUJO NORMAL
                    $factura['fac_id_origen_devolucion'] = $id_dup_fac_devolucion;
                    $factura['fac_estado'] =  2; //marcar pagada
                    $factura['fac_monto_pendiente'] =  0;
                    $factura['fac_fecha_pagada'] =  $dtf_fecha_fact;
                    //preguntar si se tiene procesado un movimiento en inventario
                    $mov_fac_dev = $this->facturacion_model->get_detalle_movimiento_devolucion($id_dup_fac_devolucion);
                }
                $fac_id =  $this->gsatelite->ingresar('fac_factura', $factura);
                if (($id_dup_fac_devolucion  > 0 || $pagar_rapido_fact > 0) && $fac_id > 0) {
                    // Proceso de devolucion
                    if ($id_dup_fac_devolucion  > 0) {
                        //realizar el registro del pago y actualizar fecha de devolucion
                        $reg_devolucion = $this->gsatelite->get_registro('fac_factura', 'fac_id', $id_dup_fac_devolucion);
                        $this->gsatelite->actualizar_array('fac_factura', array('fac_fecha_devolucion'=>date('Y-m-d H:i:s')), array('fac_id'=>$id_dup_fac_devolucion));
                    }
                }
                // orden de venta
                $slcOrdVnt = (trim($this->input->post('slcOrdVnt')) != "") ? $this->input->post('slcOrdVnt') : null;
                if($slcOrdVnt != ''){
                    $orden_venta_array = array(
                        'orv_id_fac' => $fac_id,
                        'orv_estado' => 2,
                        'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array("orv_orden_venta", $orden_venta_array, array("orv_id" => $slcOrdVnt));
                }
                //Se guarda el personal de la factura si viene
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                        $detalle_personal = array(
                            'pxf_id_fac' => $fac_id,
                            'pxf_id_emp' => $personal[$x],
                            'pxf_estado' => 1,
                            'pxf_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxf_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxf_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxf_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxf_personalxfactura', $detalle_personal);
                    }
                }
                // Columna codigo
                $combo_agrupacion    = $this->input->post('combo_agrupacion');
                $aplica_descarga     = $this->input->post('aplica_descarga');
                $fecha_garantia      = $this->input->post('garantia_factura');/////////////////XXXXXX
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');//////////////XXXXXX
                $tip_producto        = $this->input->post('tip_producto');
                $productos_factura   = $this->input->post('producto_factura');
                $correlativo         = $this->input->post('producto_correlativo');
                $medida_factura      = $this->input->post('medida_factura');
                $bodega_factura      = $this->input->post('bodega_producto');
                $codigo_factura      = $this->input->post('codigo_factura');
                $inscripcion_fac     = $this->input->post('inscripcion_factura');/////////////XXXXXX
                // Columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura');
                // Columna cantidad
                $cantidad_factura            = $this->input->post('cantidad_factura');
                $cantidad_factura_convertida = $this->input->post('cantidad_factura_convertida');
                $cantidad_inicial            = $this->input->post('cantidad_inicial');////////// -> AXC ?
                $cantidad_factura_padre      = $this->input->post('cantidad_factura_padre');////////// -> REM FACT
                $id_def_ctdad_factura_padre  = $this->input->post('def_factura_padre');////////// -> REM FACT
                // Columna precio
                $ctdadtotal = array_sum($cantidad_factura);
                $precio_factura = $this->input->post('precio_factura');
                // Impuesto
                $impuesto_factura     = $this->input->post('impuesto_factura');
                $impuesto_por_factura = $this->input->post('impuesto_por_factura');
                $impuesto_array       = $this->input->post('impuesto_array');
                $impuesto_por_array   = $this->input->post('impuesto_por_array');
                // Retencion
                $retencion_factura       = $this->input->post('retencion_factura');
                $retencion_por_factura   = $this->input->post('retencion_por_factura');
                $retencion_array         = $this->input->post('retencion_array');/////////////XXXXXX
                $retencion_por_array     = $this->input->post('retencion_por_array');
                $retencion_por_array_val = $this->input->post('retencion_por_array_val');
                // Descuento
                $descuento_factura     = $this->input->post('descuento_factura');
                $descuento_por_factura = $this->input->post('descuento_por_factura');
                $autorizo_desc_x_list = $this->input->post('autorizo_desc_lista');//  ARRAY CON DESCUENTOS POR LISTA SI NO HAY VIENE VACIO
                $autorizo_desc_full_gnal = $this->input->post('usu_autoriza_desc_global'); //ID DE USER DESCUENTO, SI VIENE, MATA AL DE LISTA
                // Subtotal
                $subtotal_factura = $this->input->post('subtotal_factura');
                // Total
                $total_factura = $this->input->post('total_factura');
                $tipo_venta = $this->input->post('tipo_venta');
                //Arreglo con los id de los detalles de la cotizacion
                $axc_id_art_cotizacion = $this->input->post('axc_id_art_cotizacion');////////// -> AXC ?
                //preguntamos por el porcentaje del impuesto
                $q_colum_impuesto = $this->gsatelite->get_tabla("imp_impuesto");
                $array_porcentaje = array_column($q_colum_impuesto, 'imp_porcentaje', 'imp_id');
                //datos de caracteristica
                /*  Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input se obtienen los ids de las caracteristicas
                asociadas con el producto y con esta obtenemos el valor de la caja usando el id del producto con el id de la caracteristica para guardar la relacion */
                $bodegas_all = array_unique($bodega_factura);
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $tipo = $this->input->post('tipo_caracteristica');
                //SI ES UNA REMISION DE UNA FACTURA PADRE SE ACTUALIZA EL REGISTRO DE CANTIDADES
                $rem_hija = $rems_hijas = 0;
                if ($rem_ya_facturada > 0) {
                    $otros = $this->gsatelite->get_suma('fxr_factura_remisionxfactura', 'fxr_total_unidades_entregadas', array("fxr_id_fac" => $rem_ya_facturada,"fxr_estado" => 1));
                    $ctdad_padre = $this->gsatelite->get_suma('def_detalle_fact', 'def_cantidad', array("def_id_fac" => $rem_ya_facturada, "def_estado" => 1));
                    $ctda_esta_entrega = array_sum($cantidad_factura);
                    $registro = array(
                        'fxr_id_fac' => $rem_ya_facturada,
                        'fxr_id_fac_remision' => $fac_id,
                        'fxr_total_unidades_padre' => $ctdad_padre,
                        'fxr_total_unidades_pendientes' => ($ctdad_padre - ($otros + $ctda_esta_entrega)),
                        'fxr_total_unidades_entregadas' => $ctda_esta_entrega,
                        'fxr_estado' => 1,
                        'fxr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'fxr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'fxr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'fxr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $rem_hija = $this->gsatelite->ingresar('fxr_factura_remisionxfactura', $registro);
                    $rems_hijas = implode(',', array_column($this->gsatelite->get_tabla('fxr_factura_remisionxfactura', array('fxr_estado' => 1, 'fxr_id_fac' => $rem_ya_facturada)), 'fxr_id_fac_remision'));
                }
                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != 0 && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id']: null;
                        $caracteristicas_id = $this->input->post('caracteristica_'.$productos_factura[$x].'_'.$correlativo[$x]);
                        //solo se usara la formula cuando el producto contenga alguna formula existente asociada a el
                        $formula = null;
                        $formula_id = null;
                        if ($tipo[$x] == 2) {
                            // la formula se obtiene con el codigo del producto, el input tiene la siguiente forma nombre_cada_+idproducto
                            $formula = (trim($this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_input' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                            $formula_id = (trim($this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x])) != "") ? $this->input->post('resultado_formula_select' . $productos_factura[$x].'_'.$correlativo[$x]) : null;
                        }
                        //verificar si aplica descarga o si es una factura de devolución con movimiento.
                        if (($aplica_descarga[$x] == 1 || count($mov_fac_dev) > 0 ) && $tip_producto[$x] == 0) {
                            if($combo_agrupacion[$x] == 1){
                                $combos_articulo_array = $this->input->post('combo_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $cantidad_temp_combo = $this->input->post('combo_cantidad_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                $combos_medida_array = $this->input->post('combo_medida_'.$productos_factura[$x].'_'.$correlativo[$x]);
                                for($k = 0; $k < count($combos_articulo_array); $k++){
                                    $combos_cantidad_array = (float)trim($cantidad_factura[$x])*(float)trim($cantidad_temp_combo[$k]);
                                    $productos_id_moi[] = $combos_articulo_array[$k];
                                    $produtos_cantidad_moi[] = $combos_cantidad_array;
                                    $productos_medida_moi[] = $combos_medida_array[$k];
                                    $producto_bodega_moi[] = $bodega_factura[$x];
                                }
                            } else{
                                $productos_id_moi[] = $productos_factura[$x];
                                //cantidad_factura_convertida
                                $produtos_cantidad_moi[] = $cantidad_factura_convertida[$x];
                                $productos_medida_moi[] = $medida_factura[$x];
                                $producto_bodega_moi[] = $bodega_factura[$x];
                            }
                        }
                        $fecha_def = null;
                        if (trim($fecha_text_garantia[$x]) != '') {
                            $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                        }
                        $detalle_remision_padre = $this->gsatelite->get_registro('def_detalle_fact', array('def_id' => $id_def_ctdad_factura_padre[$x]));
                        //Se almacena la relacion de la caracteristica y la formula aplicada a esta si se aplico.
                        $usu_aut_descuentos = ($autorizo_desc_x_list[$x] != "") ? $autorizo_desc_x_list[$x] : "";//SI VIENE EL USU AUTORIZADO DE LISTA SINO VACIO
                        $usu_aut_descuentos = ($autorizo_desc_full_gnal > 0) ? $autorizo_desc_full_gnal : $usu_aut_descuentos;//SI HAY UN GENERAL MATA AL DE LISTA
                        //tabla def_detalle_fact
                        $detalle_factura = array(
                            'def_id_fac' => $fac_id,
                            'def_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                            'def_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                            'def_id_fao' => (trim($formula_id) != "") ? $formula_id : null,
                            'def_id_lip' => ($rem_hija > 0) ? $detalle_remision_padre->def_id_lip : $idlip,
                            'def_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                            'def_id_bod' => (trim($bodega_factura[$x]) != "") ? $bodega_factura[$x] : null,
                            'def_id_axc' => (trim($axc_id_art_cotizacion[$x]) != "") ? $axc_id_art_cotizacion[$x] : null,
                            'def_valor_formula' => (trim($formula) != "") ? $formula : null,
                            'def_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                            'def_cantidad' => (trim($cantidad_factura[$x]) != "") ? (float)$cantidad_factura[$x] : null,
                            'def_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                            'def_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                            'def_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                            'def_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                            'def_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                            'def_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                            'def_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                            'def_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                            'def_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                            'def_fecha_vence_garantia' => $fecha_def,
                            'def_dias_garantia' => (trim($fecha_text_garantia[$x]) != "") ? $fecha_text_garantia[$x] : null,
                            'def_usu_autoriza_descuento' =>  ($usu_aut_descuentos != "") ? $usu_aut_descuentos : null,
                            'def_precio_inventario' => (float)$dtf_costo_venta_por_producto[$x],
                            'def_estado' => 1,
                            'def_usu_crea' => $this->tank_auth->get_user_id(),
                            'def_fecha_crea' => date('Y-m-d H:i:s'),
                            'def_usu_mod' => $this->tank_auth->get_user_id(),
                            'def_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $def_id = $this->gsatelite->ingresar('def_detalle_fact', $detalle_factura);
                        //Actualizar valores de axc_articuloxcotizacion(axc_cantidad_facturada, axc_cantidad_pendiente) en caso que sea una facturacion parcial por cotizacion
                        if($dtg_cotizacion > 0){
                            //$axc_cant = (trim($cantidad_inicial[$x]) != "") ? $cantidad_inicial[$x] : 0;
                            $axc_cant_base      = (trim($axc_cantidad_base[$x]) != "") ? $axc_cantidad_base[$x] : 0;
                            $axc_cant_fac_base  = (trim($axc_cantidad_facturada_base[$x]) != "") ? $axc_cantidad_facturada_base[$x] : 0;
                            $axc_cant_pend_base = (trim($axc_cantidad_pendiente_base[$x]) != "") ? $axc_cantidad_pendiente_base[$x] : 0;
                            $axc_cant_fac       = (trim($cantidad_factura_convertida[$x]) != "") ? $cantidad_factura_convertida[$x] : 0;
                            $axc_pen            = $axc_cant_pend_base - $axc_cant_fac;
                            //Array con los datos para actualizar
                            $axc_articuloxcotizacion = array(
                                //'axc_cantidad' => $axc_cant,
                                'axc_cantidad_facturada' => $axc_cant_fac + $axc_cant_fac_base,
                                'axc_cantidad_pendiente' => $axc_pen
                            );
                            //Se actualiza el estado de la cotizacion
                            //Se actualizan el valor facturado, el pendiente, y la cantidad adicional
                            $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $axc_articuloxcotizacion, array('axc_id'=>$axc_id_art_cotizacion[$x]));
                            //Valida si el total pendiente de facturar(de esta y las anteriores es 0 o menor por sobre giros) y dependiendo de eso se actualiza el estado:
                            //(1=pendiente, 2=parcial, 3=finalizado). Revisa si la cantidad de articulos que pertenescan a esa cotizacion ya estan todos en cantidad pendiente 0,
                            //si lo esta la cotizacion esta comletamete facturada, sino esta parcial
                            $cot_estado_facturacion = 1;
                            $can_articulo =  $this->gsatelite->get_tabla('axc_articuloxcotizacion', array('axc_id_cot'=>$dtg_cotizacion, 'axc_cantidad_pendiente >' => 0));
                            if(count($can_articulo) > 0){
                                $cot_estado_facturacion = 2;
                                $cot_estado = 1;
                            }else{
                                $cot_estado_facturacion = 3;
                                $cot_estado = 0;
                                //$this->gsatelite->actualizar_array("cot_cotizacion", array('cot_estado' => 0), array("cot_id" => $dtg_cotizacion));
                            }
                            //Actualizar el estado de la cotizacion
                            $array_cotizacion_estado_fac = array('cot_estado_facturacion' => $cot_estado_facturacion, 'cot_estado' => $cot_estado);
                            $this->gsatelite->actualizar_array('cot_cotizacion', $array_cotizacion_estado_fac, array('cot_id'=>$dtg_cotizacion));
                        }
                        if ($rem_hija > 0) {
                            $entregados = $this->gsatelite->get_suma('def_detalle_fact', 'def_cantidad', array("def_id_art" => $productos_factura[$x], "def_id_fac IN ($rems_hijas)" => null));
                            $pendiente = $cantidad_factura_padre[$x] - $entregados;
                            $this->gsatelite->actualizar_array('def_detalle_fact', array('def_cantidad_faltante' => $pendiente), array('def_id' => $def_id));
                            $this->gsatelite->actualizar_array('def_detalle_fact', array('def_cantidad_faltante' => $pendiente, 'def_usu_mod' => $this->tank_auth->get_user_id(), 'def_fecha_mod' => date('Y-m-d H:i:s')), array('def_id' => $id_def_ctdad_factura_padre[$x]));
                        }
                        //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                    //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    //$monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                    $monto_temp = $subtotal_factura[$x] * ($array_porcentaje[$impuesto_ids[$k]] / 100);
                                    //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixf_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixf_id_def' => $def_id,
                                        'ixf_monto' => $monto_temp,
                                        'ixf_porcentaje' => $array_porcentaje[$impuesto_ids[$k]],
                                        'ixf_estado' => 1,
                                        'ixf_usu_mod' => $this->tank_auth->get_user_id(),
                                        'ixf_fecha_mod' => date('Y-m-d H:i:s'),
                                        'ixf_fecha_crea' => date('Y-m-d H:i:s'),
                                        'ixf_usu_crea' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('ixf_impuestoxfactura', $detalle_impuesto); 
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        $retencion_valor = explode(",", $retencion_por_array_val[$x]);

                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] != 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    if($retencion_por[$k]>0){
                                        $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    }else{
                                        $monto_temp = $retencion_valor[$k];
                                    }
                                    // Tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxf_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxf_id_def' => $def_id,
                                        'rxf_monto' => $monto_temp,
                                        'rxf_estado' => 1,
                                        'rxf_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rxf_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'rxf_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxf_usu_modificacion' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('rxf_retencionxdetalle_factura', $detalle_retencion);
                                }
                            }
                        }
                        for ($y = 0; $y < count($caracteristicas_id); $y++) {
                            //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                            if ($tipo[$x] == 0) {
                            } else if ($tipo[$x] == 1) {
                                // Toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                $caracteristicas_id_valor = $this->input->post('val